<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
    class Ventas extends CI_Controller{
        
        function __construct(){
            parent::__construct();
        }
        
        function estadistica($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $mensaje = array(
                    'error' => 0, 
                );
                $this->session->set_userdata($mensaje);
                
                $this->load->model('sucursal_model');
                $this->load->model('ventas_model');
                $this->load->model('cliente_model');
                $this->data['anios'] = $this->ventas_model->getAnios();
                $this->data['sucursales'] = $this->sucursal_model->viewSucursal();
                $this->data['tipos'] = $this->sucursal_model->getTipo();
                $this->data['data_years'] = $this->ventas_model->getEstadisticasAnio(0);
                $this->data['vendedores'] = $this->cliente_model->verVendedoresActivo();
                
                $this->load->view('mantenimiento_estadisticas', $this->data);
            }
        }
        
        function get_estadisticas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{  
                $anio = $this->input->post('anio');
                $this->load->model('ventas_model');
                $data = $this->ventas_model->getEstadisticasAnio2($anio);
                echo json_encode($data);
            }
        }
        
        function getPieChart(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                
                $dateInput = explode('/',$fechaini);
                $fechaini2 = $dateInput[2].'-'.$dateInput[1].'-'.$dateInput[0];
                
                $dateInput2 = explode('/',$fechafin);
                $fechafin2 = $dateInput2[2].'-'.$dateInput2[1].'-'.$dateInput2[0];
                
                
                $this->load->model('compras_model');
                $data = $this->compras_model->getLinesChartFechas($fechaini2,$fechafin2);
                $data_pie = $this->compras_model->getPieChartFechas($fechaini2,$fechafin2);
                
                $i=0;
                $array_info = array();
                $total_gen = 0;
                foreach($data as $dat){
                    $venta = $dat->valventan *1;
                    $costo = abs($dat->valcosto) *1;
                    $hits = $dat->hits *1;
                    $percepcion = ($venta-$costo)*1;
                    $array_info[$i] = array(
                        //"fecha" => $dat->fechaFormat,
                        "fecha" => $dat->fechaFormat2,
                        "valventan" => $venta,
                        "valcosto" => $costo,
                        "utilidad" => $percepcion
                    );
                    $i++;
                }
                
                $j=0;
                $array_pie = array();
                foreach($data_pie as $dat){
                    $venta = $dat->valventan *1;
                    $costo = abs($dat->valcosto) *1;
                    $percepcion = ($venta-$costo)*1;
                    //$total_gen = $venta+$costo+$percepcion;
                    $total_gen = $venta;
                    $array_data = array(
                        "venta" => $venta,
                        "costo" => $costo,
                        "utilidad" => $percepcion
                    );
                    
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Venta",
                        "valor" => $venta,
                        "data" => $array_data,
                        "total" =>$total_gen
                    );
                    $j++;
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Costo",
                        "valor" => $costo,
                        "data" => $array_data,
                        "total" =>$total_gen
                    );
                    $j++;
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Utilidad",
                        "valor" => $percepcion,
                        "data" => $array_data,
                        "total" =>$total_gen
                    );
                    $j++;
                }
                
                $array =  array(
                    "datos"=>$array_info,
                    "pie" =>$array_pie
                );
                
                
                echo json_encode($array);
            }
        }
        
        function get_estadisticas_sucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{  
                $centros = $this->input->post('centros');
                $anio = $this->input->post('anio');
                $this->load->model('ventas_model');
                $data = $this->ventas_model->getEstadisticasSucursal($centros, $anio);
                $i1=0;
                $array1 = array();
                $i=0;
                $array2 = array();
                $k=0;
                
                foreach($data as $ven => $key){
                    $centrosids = explode(", ", $centros);
                    $totCenters = count($centrosids);
                    $realCenters = $totCenters - 1;
                    $array4 = array();
                    $array_centros[$i1]  = array();
                    for($j=0; $j<=$realCenters; $j++){
                        $dato =  "C".$centrosids[$j];
                        $envio = $key[$dato]*1;
                        if($envio==null){
                            $envio=0*1;
                        }
                        $array4 = array(
                            $dato => $envio, 
                        );
                        $array_centros[$i1] = array_merge($array_centros[$i1], $array4);
                    } 
                    $array2[$i1] = array(
                        "mes" => $key['mes'],
                        "month" => $key['month'],
                        "Total" => $key['Total'],
                        "idcentro" => $key['idcentro'],
                    );
                    $array1[$i1] = array_merge($array2[$i1],$array_centros[$i1]);
                   
                    $i1++;
                }
               
                
                $series = $this->ventas_model->getEstadisticasSeries($centros, $anio);
                
                $array = array(
                    "datos" => $array1,
                    "series" => $series
                );
                echo json_encode($array);
            }
        }
        
        function get_estadisticas_categorias(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{  
                $anio = $this->input->post('anio');
                $this->load->model('ventas_model');
                $data = $this->ventas_model->getEstadisticasCategorias($anio);
                $series = $this->ventas_model->getSeriesCategorias($anio);
                $series_array = $this->ventas_model->getSeriesCategorias_array($anio);
                $i=0;
                $array1 = array();
                $array2 = array();
                foreach($data as $info =>$key){
                    $i1=0;
                    $array4 = array();
                    $array_Cat[$i]  = array();
                    foreach ($series as $ser){
                        $campo = "C".$ser->ID;
                        $dato =  $key[$campo];
                        $envio= $dato*1;
                        $array4 = array(
                            $campo => $envio, 
                        );
                        $array_Cat[$i] = array_merge($array_Cat[$i], $array4);
                    } 
                    switch($key['mes']){
                        case 1:
                            $month = "ENERO";
                            break;
                        case 2:
                            $month = "FEBRERO";
                            break;
                        case 3:
                            $month = "MARZO";
                            break;
                        case 4:
                            $month = "ABRIL";
                            break;
                        case 5:
                            $month = "MAYO";
                            break;
                        case 6:
                            $month = "JUNIO";
                            break;
                        case 7:
                            $month = "JULIO";
                            break;
                        case 8:
                            $month = "AGOSTO";
                            break;
                        case 9:
                            $month = "SEPTIEMBRE";
                            break;
                        case 10:
                            $month = "OCTUBRE";
                            break;
                        case 11:
                            $month = "NOVIEMBRE";
                            break;
                        case 12:
                            $month = "DICIEMBRE";
                            break;
                    }
                    $array2[$i] = array(
                        "mes" => $key['mes'],
                        "month" => $month,
                        "anio" => $key['anio'],
                        "total" => $key['total']
                    );
                    $array1[$i] = array_merge($array2[$i],$array_Cat[$i]);
                    $i++;
                }
                $array = array(
                    "datos" => $array1,
                    "series" => $series
                );
                echo json_encode($array);
            }
        }
        
        function get_estadisticas_vendedores(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{  
                $vendedores = $this->input->post('vendedores');
                $anio = $this->input->post('anio');
                $this->load->model('ventas_model');
                $data = $this->ventas_model->getEstadisticasVendedor($vendedores, $anio);
                $i1=0;
                $array1 = array();
                $i=0;
                $array2 = array();
                $k=0;
                foreach($data as $ven => $key){
                    $vendedoresids = explode(", ", $vendedores);
                    $totVend = count($vendedoresids);
                    $realVend = $totVend - 1;
                    $array4 = array();
                    $array_vd[$i1]  = array();
                    for($j=0; $j<=$realVend; $j++){
                        $dato =  "V".$vendedoresids[$j];
                        $envio = $key[$dato]*1;
                        if($envio==null){
                            $envio=0*1;
                        }
                        $array4 = array(
                            $dato => $envio, 
                        );
                        $array_vd[$i1] = array_merge($array_vd[$i1], $array4);
                    } 
                    $array2[$i1] = array(
                        "mes" => $key['mes'],
                        "month" => $key['mesName'],
                        "Total" => $key['Total']
                    );
                    $array1[$i1] = array_merge($array2[$i1],$array_vd[$i1]);
                   
                    $i1++;
                }
                
                $series = $this->ventas_model->getVendedoresSeries($vendedores, $anio);
                
                $array = array(
                    "datos" => $array1,
                    "series" => $series
                );
                echo json_encode($array);
            }
        }
        
        function get_estadisticas_agrupacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{  
                $anio = $this->input->post('anio');
                $this->load->model('ventas_model');
                $data = $this->ventas_model->getEstadisticasAgrupacion($anio);
                $series = $this->ventas_model->getSeriesAgrupacion($anio);
                
                $series_array = $this->ventas_model->getSeriesAgrupacionResult($anio);
                
                
                $array_series = array();
                $as = 0;
                $l = 0;
                $i=0;
                $repe=0;
                foreach($series_array as $k => $seri){
                    $val = trim($seri['valueField']);
                    $val = str_replace(' ', '', $val);
                    if($val!="" || $val!=null){
                        $array_series[$as] = array(
                            "valueField" => "G_".$val,
                            "name" => $val
                        );
                         $as++;
                    }
                }
                $array_series[$as] = array(
                    "valueField" => "G_singrupo",
                    "name" => "Sin Grupo"
                );
                $as++;
                $sumatoria=0;
                $total_ventas=0;
                
                foreach($data as $info =>$key){
                    $i1=0;
                    $array4 = array();
                    $array_Gru[$i]  = array();
                    $l = 0;
                    foreach($series_array as $k => $seri){
                        $val = trim($seri['valueField']);
                        $val = str_replace(' ', '', $val);
                        if($val!="" || $val!=null){
                            $campo = "G_".$val;
                            $dato =  ($key[$campo])*1;
                            $envio= $dato*1;
                            $sumatoria+=$envio;
                            $total_ventas = ($key["Total"])*1;
                            $array4 = array(
                                $campo => $envio, 
                            );
                        }else{
                            $total_ventas = ($key["Total"])*1;
                        }
                        $array_Gru[$i] = array_merge($array_Gru[$i], $array4);
                    }
                    
                    $valor_singrup = $total_ventas-$sumatoria;
                    
                    //$dato = $key["G_singrupo"];
                    //$valor_singrupo = $dato*1;
                    $array4 = array(
                        "G_singrupo" => $valor_singrup, 
                    );
                    $array_Gru[$i] = array_merge($array_Gru[$i], $array4);
                    
                    
                    switch($key['mes']){
                        case 1:
                            $month = "ENERO";
                            break;
                        case 2:
                            $month = "FEBRERO";
                            break;
                        case 3:
                            $month = "MARZO";
                            break;
                        case 4:
                            $month = "ABRIL";
                            break;
                        case 5:
                            $month = "MAYO";
                            break;
                        case 6:
                            $month = "JUNIO";
                            break;
                        case 7:
                            $month = "JULIO";
                            break;
                        case 8:
                            $month = "AGOSTO";
                            break;
                        case 9:
                            $month = "SEPTIEMBRE";
                            break;
                        case 10:
                            $month = "OCTUBRE";
                            break;
                        case 11:
                            $month = "NOVIEMBRE";
                            break;
                        case 12:
                            $month = "DICIEMBRE";
                            break;
                    }
                    $array2[$i] = array(
                        "mes" => $key['mes'],
                        "month" => $month,
                        "anio" => $anio
                    );
                    $array1[$i] = array_merge($array2[$i],$array_Gru[$i]);
                    $i++;
                }
                $array = array(
                    "datos" => $array1,
                    "series" => $array_series
                );
                echo json_encode($array);
            }
        }
        
        function anadiaria($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                $mensaje = array(
                    'error' => 0,
                );
                $this->session->set_userdata($mensaje);
                
                $this->load->model('ventas_model');
                $this->data['categorias'] = $this->ventas_model->getSeriesCategorias_chart();
                $this->load->view('mantenimiento_anadiaria', $this->data);
            }
        }
        
        function ventas_periodo($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('sucursal_model');
                $this->load->model('catalog_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $mensaje = array(
                    'error' => 0,
                );
                $this->session->set_userdata($mensaje);
                $this->data['sucursales'] = $this->sucursal_model->viewSucursal();
                $this->data['tipos'] = $this->sucursal_model->getTipo();
                $this->data['categorias'] = $this->catalog_model->listDepartamentos();

                $this->load->view('mantenimiento_ventasperiodo', $this->data);
            }
        }
        
        function get_estadisticas_all(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
                $data = $this->compras_model->getAllVentas2();
                $data_pie = $this->compras_model->getTotalVentas_Pie();
                $primer_dia="";
                $i=0;
                $array_info = array();
                foreach($data as $dat){
                    
                    if($i==0){
                        $primer_dia=$dat->fechaFormat2;
                    }
                    
                    $venta = $dat->valventan *1;
                    $costo = abs($dat->valcosto) *1;
                    $percepcion = ($venta-$costo)*1;
                    $array_info[$i] = array(
                        //"fecha" => $dat->fechaFormat,
                        "fecha" => $dat->fechaFormat2,
                        "valventan" => $venta,
                        "valcosto" => $costo,
                        "utilidad" => $percepcion
                    );
                    $i++;
                }
                $j=0;
                $array_pie = array();
                foreach($data_pie as $dat){
                    $venta = $dat->valventan *1;
                    $costo = abs($dat->valcosto) *1;
                    $hits = $dat->hits *1;
                    
                    $array_data = array(
                        "venta" => $venta,
                        "costo" => $costo,
                        "clientes" => $hits
                    );
                    
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Venta",
                        "valor" => $venta,
                        "data" => $array_data
                    );
                    $j++;
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Costo",
                        "valor" => $costo,
                        "data" => $array_data
                    );
                    $j++;
                }
                
                $array =  array(
                    "datos"=>$array_info,
                    "pie" =>$array_pie, 
                    "primer_dia" =>$primer_dia
                );
                
                echo json_encode($array);    
            }
        }
        
        function getPieChart_Cat(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                
                $dateInput = explode('/',$fechaini);
                $fechaini2 = $dateInput[2].'-'.$dateInput[1].'-'.$dateInput[0];
                
                $dateInput2 = explode('/',$fechafin);
                $fechafin2 = $dateInput2[2].'-'.$dateInput2[1].'-'.$dateInput2[0];
                
                
                $this->load->model('ventas_model');
                $data = $this->ventas_model->getLinesChartFechas_Cat($fechaini2,$fechafin2);
                $categorias = $this->ventas_model->getSeriesCategorias_chart();
                $pie = $this->ventas_model->getTotalesCategorias_chart($fechaini2,$fechafin2);

                $i1=0;
                $array1 = array();
                $i=0;
                $array2 = array();
                $k=0;
                $i1=0;
                foreach($data as $dat){
                    $array4 = array();
                    $arraycat[$i1]  = array();
                    $total = 0;
                    foreach($categorias as $cat){
                        $columna =  $cat->valueField;
                        $valor = $dat[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $total+=$tot;
                        $array4 = array(
                            $columna => round($tot,2)
                        );
                        $arraycat[$i1] = array_merge($arraycat[$i1], $array4);
                    } 
                   
                    $array2[$i1] = array(
                        "fecha" =>  $dat['fecha'],
                        "total"=> round($total,2)
                    );
                    $array1[$i1] = array_merge($array2[$i1],$arraycat[$i1]);
                      
                    $i1++;
                }
                
                
                $j=0;
                $i1=0;
                $array_pie = array();
                $array_data = array();
                $array4 = array();
                $total_categorias=0;

                foreach($pie as $in){
                    foreach($categorias as $cat){
                        $columna =  $cat->valueField;
                        $name =  $cat->name;
                        $valor = $in[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $total+=$tot;
                        $total_categorias+=$tot;
                        $array4 = array(
                            $columna => round($tot,2),
                            $name => $name,
                        );
                        $array_data = array_merge($array_data, $array4);
                    } 
                    
                    foreach($categorias as $cat){
                        $columna =  $cat->valueField;
                        $descrip =  $cat->name;
                        $valor = $in[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $tot= round($tot,2);
                        $array_pie[$j] = array(
                            "tipo" => $descrip,
                            "valor" => $tot,
                            "data" => $array_data,
                            "total_categorias" =>round($total_categorias,2)
                        );
                        $j++;
                    
                    }
                    
                }
                
                
                
                $array =  array(
                    "datos"=>$array1,
                    "pie"=>$array_pie
                );
                
                
                echo json_encode($array);
            }
        }
        
        function getSubDep(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                       
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin'); 
                $depto = $this->input->post('depto'); 
                $dateInput = explode('/',$fechaini);
                $fechaini2 = $dateInput[2].'-'.$dateInput[1].'-'.$dateInput[0];
                
                $dateInput2 = explode('/',$fechafin);
                $fechafin2 = $dateInput2[2].'-'.$dateInput2[1].'-'.$dateInput2[0];
                
                
                
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
                $categorias = $this->compras_model->getSubCategorias_Array($depto);
                $categorias2 = $this->compras_model->getSubCategorias_Array2($depto, $fechaini2, $fechafin2);
                $data = $this->compras_model->getInfoSubCat($depto, $fechaini2, $fechafin2);
                
                
                $j=0;
                $i1=0;
                $i=0;
                $array_pie = array();
                $array4 = array();
                $total_categorias=0;
                $array_grid = array();
                foreach($data as $in){
                    foreach($categorias2 as $cat){
                        $columna =  $cat->valueField;
                        $descrip =  $cat->name;
                        $valor = $in[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $tot= round($tot,2);
                        
                        if($tot>0){
                            $array_pie[$j] = array(
                                "tipo" => $descrip,
                                "valor" => $tot,
                                "serie" =>"sub"
                            );
                            $j++;
                            $total_categorias+=$tot;
                        }
                    }
                }
                
                foreach($data as $in){
                    foreach($categorias2 as $cat){
                        $columna =  $cat->valueField;
                        $descrip =  $cat->name;
                        $sumCantidad =  $cat->sumCantidad;
                        $valor = $in[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $tot= round($tot,2);
                        $sumCantidad= round($sumCantidad,2);
                        $precioProm =$tot/$sumCantidad;
                        $precioProm= round($precioProm,2);
                        $porcentaje = ($tot/$total_categorias)*100;
                        $porcentaje= round($porcentaje,2);
                        if($tot>0){
                            $array_grid[$i] = array(
                                "descrip" => $descrip,
                                "sumCantidades" => $sumCantidad,
                                "precioProm" => $precioProm,
                                "total" => $tot,
                                "porcentaje" =>$porcentaje."%"
                            );
                            $i++;
                        }
                    }
                }
                
                
                $array =  array(
                    "datos"=>$array_pie,
                    "total_cat"=>$total_categorias,
                    "grid" =>$array_grid
                );
                
                echo json_encode($array);
            }
        }
        
        function getDataGridVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                       
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin'); 
                $linea = $this->input->post('linea'); 
                $dateInput = explode('/',$fechaini);
                $fechaini2 = $dateInput[2].'-'.$dateInput[1].'-'.$dateInput[0];
                
                $dateInput2 = explode('/',$fechafin);
                $fechafin2 = $dateInput2[2].'-'.$dateInput2[1].'-'.$dateInput2[0];
                
                $this->load->model('compras_model');
                $datos= $this->compras_model->getDataGridVentas($linea, $fechaini2, $fechafin2);
                
                
                $total =0;
                 foreach($datos as $in){
                     $total+=$in->preSum;
                 }
                
                $i=0;
                $array_grid = array();
                foreach($datos as $in){
                    
                    $idproducto = $in->idproducto;
                    $descrip = $in->descrip;
                    $modelo = $in->modelo;
                    
                    $cantSum = $in->cantSum;
                    $cantSum= round($cantSum,2);
                    
                    $inventario = $in->inventario;
                    $inventario= round($inventario);

                    $precioNeto = $in->precioNeto;
                    $precioNeto = round($precioNeto,2);
                    
                    $preSum = $in->preSum;
                    $preSum = round($preSum,2);
                    
                    $porcentaje = ( $in->preSum/$total)*100;
                    $porcentaje= round($porcentaje,2);
                    
                    $array_grid[$i] = array(
                        "idproducto" => $idproducto,
                        "modelo" => $modelo,
                        "descrip" => $descrip,
                        "cantSum" =>$cantSum,
                        "inventario" =>$inventario,
                        "precioNeto" =>$precioNeto,
                        "preSum" =>$preSum,
                        "porcentaje" =>$porcentaje.'%'
                    );
                    $i++;
                }   
                
                
                
                $lineas= $this->compras_model->getCatLineasCat($linea);
                $array =  array(
                    "datos"=>$array_grid,
                    "lineas"=>$lineas,
                );
                echo json_encode($array);
            }
        }
		
		function so_tran($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                // $this->load->model('configuracion_model');
                // $appName = $this->configuracion_model->getAppName($idApp);
                // $resultAppName = array(
                //     'iddApp' => $idApp,
                //     'appName' => $appName,
                //     'namePage' => $appName
                // );
                // $this->session->set_userdata($resultAppName);
                // $this->load->model('global_model');
                
				// $controlador = $this->uri->segment(1);
                // $funcion = $this->uri->segment(2);
                // $direccion = $controlador.'/'.$funcion;
				
				// $idcliente = $this->uri->segment(4);

                // $this->load->model('cliente_model');
                // $this->load->model('proveedor_model'); $this->load->model('variable_model'); $this->load->model('compras_model');
                // $this->load->model('empleado_model'); $this->load->model('ventas_model'); $this->load->model('sucursal_model');
				
                // if($idcliente==""){ $idcliente = 0; }
                
                // $tipo_productos = $this->configuracion_model->getProCentro($idApp);
                // $arreglo = array(
                //     'compras_tipopro' => $tipo_productos
                // );
                // $this->session->set_userdata($arreglo);
                
				// $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                // $this->data['idcliente'] = $idcliente;
                // $this->data['clientes'] = $this->cliente_model->getListadoClientes();
                // $this->data['vendedores'] = $this->empleado_model->viewEmple();
                // $this->data['formas_pago'] = $this->ventas_model->formasPago();
                // $this->data['tipoDoc'] = $this->ventas_model->tipoDoc();
                // $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
                // $this->data['estados_data'] = $this->variable_model->getVariablesNombre("so_stat");
                
                //$this->load->view('mantenimiento_ordenesdeventas', $this->data);

                $this->load->view('phpenproceso');
			}
        }

        function mantenimientoCotizaciones($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				
				$idcliente = $this->uri->segment(4);

                $this->load->model('cliente_model');
                $this->load->model('proveedor_model'); $this->load->model('variable_model'); $this->load->model('compras_model');
                $this->load->model('empleado_model'); $this->load->model('ventas_model'); $this->load->model('sucursal_model');
				
                if($idcliente==""){ $idcliente = 0; }
                
                $tipo_productos = $this->configuracion_model->getProCentro($idApp);
                $arreglo = array(
                    'compras_tipopro' => $tipo_productos
                );
                $this->session->set_userdata($arreglo);
                
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['idcliente'] = $idcliente;
                $this->data['clientes'] = $this->cliente_model->getListadoClientes();
                $this->data['vendedores'] = $this->empleado_model->viewEmpleActivo();
                $this->data['formas_pago'] = $this->ventas_model->formasPago();
                $this->data['tipoDoc'] = $this->ventas_model->tipoDoc();
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
                $this->data['estados_data'] = $this->variable_model->getVariablesNombre("so_stat");
                $this->data['gzips'] = $this->global_model->getZips();
                $zip_variable = $this->variable_model->getTextVar("gv_zip");
                $idzip = $zip_variable['valor_num'];
                $this->data['idzip_default'] = round($idzip);
                
                $this->load->view('mantenimiento_ordenesdeventas_copy', $this->data);
			}
        }

        function generarCopiasCotizacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{  
                $copias = $this->input->post('copias');
                $trannum = $this->input->post('trannum');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('ventas_model');
                $this->ventas_model->generarCopiasCotizacion($trannum, $copias);
                echo json_encode($this->ventas_model->getListadoDetalleCotizaciones($idcentro));
            }
        }
		
        function callRegistro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{  
                $this->load->model('ventas_model');
                $ordenes = $this->ventas_model->getOrdenes();
                echo json_encode($ordenes);
            }
        }
		
        function getListadoDetalleCotizaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('ventas_model');
                $ordenes = $this->ventas_model->getListadoDetalleCotizaciones($idcentro);
                echo json_encode($ordenes);
            }
        }
        
        function getVendedorCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{  
                $this->load->model('ventas_model');
                $idcliente = $this->input->post('idcliente');
                $vendedor = $this->ventas_model->getVendedorCliente($idcliente);
                echo json_encode($vendedor);
            }
        }
        
        function getVentasProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getVendedores();
                
                $array = array();
                $i = 0;
                
                foreach($datos as $ven){
                    $array[$i] = array(
                        "vendedor" => "$ven->vendedor",
                        "categoria" => "$ven->categoria",
                        "fecha" => date("Y/m/d",strtotime($ven->fecha)),
                        "valorventa" => "$ven->valorventa"
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
        function getVentasClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getVendedoresClientes();
                
                $array = array();
                $i = 0;
                
                foreach($datos as $ven){
                    $array[$i] = array(
                        "vendedor" => "$ven->vendedor",
                        "categoria" => "$ven->categoria",
                        "fecha" => date("Y/m/d",strtotime($ven->fecha)),
                        "valorventa" => "$ven->valorventa"
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
        function vendedordetalleAnio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $anio = $this->input->post('anio');
                $emplea = $this->input->post('emplea');
                $catalogo = $this->input->post('catalogo');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDetalleVendedorAnio($anio, $emplea, $catalogo);
                echo json_encode($array);
            }
        }
        
        function vendedordetalle(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $anio = $this->input->post('anio');
                $mes = $this->input->post('mes');
                $emplea = $this->input->post('emplea');
                $catalogo = $this->input->post('catalogo');
                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDetalleVendedor($anio, $mes, $emplea, $catalogo);
                echo json_encode($array);
            }
        }
        
        function vendedordetalleAnioCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $anio = $this->input->post('anio');
                $emplea = $this->input->post('emplea');
                $catalogo = $this->input->post('catalogo');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDetalleVendedorAnioCliente($anio, $emplea, $catalogo);
                echo json_encode($array);
            }
        }
        
        function vendedordetalleCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $anio = $this->input->post('anio');
                $mes = $this->input->post('mes');
                $emplea = $this->input->post('emplea');
                $catalogo = $this->input->post('catalogo');
                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDetalleVendedorCliente($anio, $mes, $emplea, $catalogo);
                echo json_encode($array);
            }
        }
        
        function ventasProductos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                 $this->session->set_userdata($resultAppName);
                 $this->load->model('ventas_model');
                 $this->data['dat_Cat'] = $this->ventas_model->viewCat();
                 $this->data['dat_Subcat'] = $this->ventas_model->viewSubcat();
                 $this->load->view('mantenimiento_ventasproducto', $this->data); 
            }
        }
        
        function productodetalleAnio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $anio = $this->input->post('anio');
                $subcategoria = $this->input->post('subcategoria');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDetalleProductoAnio($anio, $subcategoria);
                echo json_encode($array);
            }
        }
        
        function productodetalleDia(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $anio = $this->input->post('anio');
                $mes = $this->input->post('mes');
                $dia = $this->input->post('dia');
                $subcategoria = $this->input->post('subcategoria');
                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDetalleProductoDia($anio, $mes, $dia, $subcategoria);
                echo json_encode($array);
            }
        }
        
        function productodetalle(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $anio = $this->input->post('anio');
                $mes = $this->input->post('mes');
                $subcategoria = $this->input->post('subcategoria');
                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDetalleProducto($anio, $mes, $subcategoria);
                echo json_encode($array);
            }
        }
        
        function create_order(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentrouser = $this->session->userdata('idcentrouser');
                $idcliente = $this->input->post('codigoCliente');
                $fechaingreso = $this->input->post('fechaingreso');
                $tipoDocumento = $this->input->post('tipoDocumento');
                $cajclase = $this->input->post('cajclase');
                $vendedor = $this->input->post('vendedor');
                $inputDirigido = $this->input->post('inputDirigido');
                $inputCorreo = $this->input->post('inputCorreo');
                $fechaentrega = $this->input->post('fechaentrega');
                $lugar_entrega = $this->input->post('lugar_entrega');
                $referencia = $this->input->post('referencia');
                $notas = trim($this->input->post('notas'));
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('ventas_model');
                $save = $this->ventas_model->insertOrden($idcentrouser, $idcliente, $fechaingreso, $tipoDocumento, $cajclase, $vendedor, $fechaentrega, $lugar_entrega, $referencia, $notas, $whodidit, $inputDirigido, $inputCorreo);
                if($save!=0){
                    redirect('Detalle_Cotizaciones/'.$save);
                }
            }
        }
        
        function detalleOrden($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $controlador = $this->uri->segment(1);
                // $funcion = $this->uri->segment(2);
                // $direccion = $controlador.'/'.$funcion;
                $direccion = $controlador;
                
				$this->load->model('ventas_model');   $this->load->model('compras_model');
                $this->load->model('variable_model'); $this->load->model('sucursal_model');
                $this->load->model('global_model');   $this->load->model('invtran_model');
                $this->load->model('cliente_model');
				
                $namevariable = 'pos_passprecio0'.$this->session->userdata('idcentrouser');
                
                $this->data['clave_precios'] = $this->global_model->getValorTextoVariable($namevariable);
                $this->data['formatos']      = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion']   = $this->ventas_model->detalleOrdenVenta($trannum);
                $this->data['empleados']     = $this->compras_model->getListProveedores(3);
                $this->data['formas_pago']   = $this->ventas_model->formasPago();
                $this->data['tipoDoc']       = $this->ventas_model->tipoDoc();
                $this->data['docExento']     = $this->ventas_model->validateDocumentoExento($trannum);
                $this->data['sucursales']    = $this->sucursal_model->viewSucursalActiva();
                $this->data['estados_data']  = $this->variable_model->getVariablesNombre("so_stat");
                $this->data['cambio_pre']    = $this->global_model->getValorNumVariable("so_chgpre");
                $this->data['correo_user']   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                $this->data['numdecimales']  = $this->compras_model->getCantidadDecimales('po_decimales');
                $this->data['cliente_data']  = $this->cliente_model->viewClienteActivo();
				$this->data['pos_prenoiva']  = $this->global_model->getValorNumVariable('pos_prenoiva');
                
				$tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }

                $this->session->set_userdata($array);
				
                $this->load->view('mantenimiento_detalle_ordenventa', $this->data); 
            }
        }

        function getDetalleOrdenVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ventas_model');
                $trannum = $this->input->post('trannum');
                $detalle = $this->ventas_model->detalleOrdenVenta($trannum);
                echo json_encode($detalle);

            }
        }
        
        function editarDatosVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $fechaingreso = $this->input->post('fechaingreso');
                $notas = trim($this->input->post('notas'));
                $vendedor = $this->input->post('vendedor');
                $tipodocumento = $this->input->post('tipodocumento');
                $formapago = $this->input->post('formapago');
                $fechaentrega = $this->input->post('fechaentrega');
                $lugarentrega = $this->input->post('lugarentrega');
                $referencia = $this->input->post('referencia');
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
                $query =  $this->ventas_model->updateDatosOrden_Venta($trannum, $fechaingreso, $vendedor, $tipodocumento, $formapago, $fechaentrega, $lugarentrega, $referencia,$notas);
                $datos = $this->ventas_model->detalleOrdenVenta2($trannum);
                $array = array(
                    "tipodoc" => $datos['tipodoc'],
                    "formapago" => $datos['formaPago'],
                    "vendedor" => $datos['workername']
                );
                echo json_encode($array);
            }
        }
        
        function getProductoSearchAll(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $search = $this->input->post('search');
                $this->load->model('ventas_model');
                $cant = $this->ventas_model->getCantLotes($search);
                $datos = $this->ventas_model->getLotesProductosSearchAll($search);
                $array = array(
                    "cant" => $cant,
                    "datos" => $datos
                );
                echo json_encode($array);
            }
        }
        
        function verificar_producto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $search = $this->input->post('search');
                $trannum = $this->input->post('trannum');
                $this->load->model('ventas_model');
                $existe = $this->ventas_model->verificar_producto($search, $trannum);
                if($existe!=0){
                    $details = $this->ventas_model->get_Pro($search, $trannum);
                    $cantidad= $details['cantidad'];
                    $precio= $details['precioneto'];
                    $notas= $details['notas'];
                    $idrec= $details['idrec'];
                }else{
                    $details = 0;
                    $cantidad= 0;
                    $precio= 0;
                    $notas= 0;
                    $idrec= 0;
                }
                $array = array(
                    "existe" => $existe,
                    "cantidad" => $cantidad,
                    "precio" => $precio,
                    "notas" => $notas,
                    "idrec" => $idrec,
                    "trannum" =>$trannum
                );
                echo json_encode($array);
            }
        }
        
        function createOrderProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $cantidad = $this->input->post('cantidad');
                $precio = $this->input->post('precio');
                $notas = trim($this->input->post('notas'));
                $idproducto = $this->input->post('idproducto');
                $descrip = $this->input->post('descrip');
                $um = $this->input->post('um');
                
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
                $query =  $this->ventas_model->createOrderProduct($trannum, $cantidad, $precio, $idproducto, $descrip, $um, $notas);
                $data = $this->ventas_model->getOrdenDetails($trannum);
                $array = array(
                    "data" => $data
                );
                echo json_encode($array);
            }
        }
        
        function createOrderProducts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $codigos = $this->input->post('codigos');
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
                $query =  $this->ventas_model->createOrderProducts($trannum, $codigos);
                $data = $this->ventas_model->getOrdenDetails($trannum);
                $array = array(
                    "data" => $data
                );
                echo json_encode($array);
            }
        }
        
        function getProductosUp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
               
                $this->load->model('ventas_model');
                $productos_list = $this->ventas_model->getProductosDispo($trannum);
               
                echo json_encode($productos_list);
            }
        }
           
        function updateCantidadorders_100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $precioneto = $this->input->post('precioneto');
                $notas = trim($this->input->post('notas'));
                $trannum = $this->input->post('trannum');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->updateCantidadorders_100k($idrec, $cantidad, $precioneto, $trannum,$notas);
                echo json_encode($array);
            }
        }
        
        function deleteOrders_100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('trannum');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->deleteProductoTemporal($idrec, $trannum);
                echo json_encode($array);
            }
        }
        
        function updateOrderProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('trannum');
                $cantidad = $this->input->post('cantidad');
                $precio = $this->input->post('precio');
                $idproducto = $this->input->post('idproducto');
                $notas = trim($this->input->post('notas'));
                
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
                
                $query =  $this->ventas_model->updateCantidadorders_100k($idrec, $cantidad, $precio, $trannum, $notas);
                $data = $this->ventas_model->getOrdenDetails($trannum);
                $array = array(
                    "data" => $data
                );
                echo json_encode($array);
            } 
        }
        
        function cambiarEstado($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $estado = $this->input->post('estado_next');
                $this->load->model('ventas_model');
                $query = $this->ventas_model->cambiarEstado($trannum,$estado);
                redirect('Cotizaciones/'.$this->session->userdata('iddApp'));
            }
        }
        
        function uploadProductosText(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $lista = $this->input->post('lista');
                $tipo = $this->input->post('tipo');
                
                $this->load->model('ventas_model');
                $query =  $this->ventas_model->uploadProductosText($trannum, $lista, $tipo);
                $data = $this->ventas_model->getOrdenDetails($trannum);
                $array = array(
                    "data" => $data
                );
                echo json_encode($array);
            } 
        }
        
        function o_prep($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $idcliente = $this->uri->segment(4);

                $this->load->model('cliente_model');
                $this->load->model('variable_model');
                $this->load->model('empleado_model');
                $this->load->model('ventas_model');
                if($idcliente==""){
                    $idcliente=0;
                }
                $this->data['idcliente'] = $idcliente;
                $this->data['cliente_data'] = $this->cliente_model->viewCliente();
                $this->data['vendedores'] = $this->empleado_model->viewEmple();
                $this->data['formas_pago'] = $this->ventas_model->formasPago();
                $this->data['tipoDoc'] = $this->ventas_model->tipoDoc();
                $this->data['estados_data'] = $this->variable_model->getVariablesNombre("so_stat");
                $this->data['ordenes_preparacion'] = $this->ventas_model->getOrdenesPreparacion();
                
                $this->load->view('mantenimiento_o_preparacion', $this->data);
                
            }
        }
        
        function verificar_orders(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('ventas_model');
                $data = $this->ventas_model->verifica_Orden($trannum);
                
                echo json_encode($data);
            } 
        }
        
        function cuadre_vendedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('empleado_model');
                $empleados = $this->empleado_model->viewEmple();
                $this->data['emple_data'] = $empleados;
                $this->data['direccion'] = $controlador;
                foreach($empleados as $empl){
                    $idvendedor = $empl->idauxi;
                    break;
                }
                $this->data['idempleado'] = $idvendedor;
                $this->load->view('mantenimiento_cuadrediario_vendedor', $this->data); 
            }
        }
        
        function ventas_diarias(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idvendedor = $this->input->post('idvendedor');
                $fechai = $this->input->post('fechai');
                $fechaf = $this->input->post('fechaf');
                
                $this->load->model('ventas_model');
                $ventas = $this->ventas_model->ventas_diarias($idvendedor, $fechai, $fechaf);
                $abonos = $this->ventas_model->abonos_diarios($idvendedor, $fechai, $fechaf);
               
                $i=0;
                $array = array();
                  
                foreach($ventas as $ven){
                    $array[$i] = array(
                        "numero" => $ven->numero,
                        "fecha" => $ven->fecha,
                        "referencia" =>"",
                        "cliente" => $ven->cliente,
                        "saldo" => $ven->saldo,
                        "tipoDoc" => $ven->tipoDoc
                    );
                    $i++;
                }
                foreach($abonos as $abo){
                    $array[$i] = array(
                        "numero" => $abo->numero,
                        "fecha" => $abo->fecha,
                        "referencia" => $abo->referencia,
                        "cliente" => $abo->cliente,
                        "saldo" => $abo->saldo,
                        "tipoDoc" => "Abono"
                    );
                    $i++;
                }
                echo json_encode($array);
            } 
        }
        
        function facturas($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcionmenu' => $opcionmenu,
                    'controlador_vn' =>$controlador,
                    'funcion_vn' =>$funcion,
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('invtran_model');
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$fechaactual = $date->format('Y-m-d');
				
                
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $direccion2 = $controlador.'/'.$funcion.'/pprint';
				$this->data['pprintfo'] = $this->global_model->getFormatosImpresionGrid($direccion2);
				$this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
				$this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $this->data['newcliente'] = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
                $this->data['fechaactual'] = $fechaactual;
				
				$idcentro = $this->session->userdata('idcentrouser');
				$nombrevar = 'pos_rprint0'.$idcentro;
				$this->data['pos_rprint'] = $this->global_model->getValorNumVariable($nombrevar);
				
				$this->load->view('mantenimiento_facturasdevoluciones', $this->data);
				$showpprint = array(
					"show_pprint" => 0
				);
				$this->session->set_userdata($showpprint);
            }
        }
		//Versión funcionando hasta 11/06/2019
		function facturaz_descontinuada($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcionmenu' => $opcionmenu,
                    'controlador_vn' =>$controlador,
                    'funcion_vn' =>$funcion,
                );
                $this->session->set_userdata($resultAppName);

                $this->load->model('ventas_model'); $this->load->model('global_model');
                $this->load->model('invtran_model');
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$fechaactual = $date->format('Y-m-d');
				                
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $direccion2 = $controlador.'/'.$funcion.'/pprint';
				$this->data['pprintfo'] = $this->global_model->getFormatosImpresionGrid($direccion2);
				$this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
				$this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $this->data['newcliente'] = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
                $this->data['fechaactual'] = $fechaactual;
				
				$idcentro = $this->session->userdata('idcentrouser');
				$nombrevar = 'pos_rprint0'.$idcentro;
                $this->data['pos_rprint'] = $this->global_model->getValorNumVariable($nombrevar);
				$this->data['pos_sendfacelectroni'] = $this->global_model->getValorNumVariable('pos_sendfacelectroni');
				$this->data['pos_tregalo'] = $this->global_model->getValorNumVariable('pos_tregalo');
                $this->data['pos_multiprint'] = $this->global_model->getValorNumVariable('pos_multiprint');
				$this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
				
				$this->load->view('mantenimiento_facturazdevoluziones_fast', $this->data);
				
                $showpprint = array(
					"show_pprint" => 0
				);
				$this->session->set_userdata($showpprint);
            }
        }
		//Versión cambio de popup adicionar
		function facturaz_funcion_ant($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcionmenu' => $opcionmenu,
                    'controlador_vn' =>$controlador,
                    'funcion_vn' =>$funcion,
                );
                $this->session->set_userdata($resultAppName);

                $this->load->model('ventas_model'); $this->load->model('global_model');
                $this->load->model('invtran_model');
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$fechaactual = $date->format('Y-m-d');
                
                $idcaja = $this->session->userdata('idcajauser');
                $idcentro = $this->session->userdata('idcentrouser');

                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $direccion2 = $controlador.'/'.$funcion.'/pprint';
				$this->data['pprintfo'] = $this->global_model->getFormatosImpresionGrid($direccion2);
                $defven = $this->global_model->getDefaultIdClaseVNSucursal('pos_idclase0'.$idcaja);
                if($defven == 0){
                    $defven = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                }
                $this->data['defven'] = $defven;
				$this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $iduser = $this->session->userdata('iduser');
                $this->data['encargado'] = $this->ventas_model->getEncargadoCentroFacturacion($iduser);
                $this->data['newcliente'] = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
                $this->data['fechaactual'] = $fechaactual;
                $this->data['opcionResumen'] = $this->session->userdata('opcionMostrarResumen');
				
				$nombrevar = 'pos_rprint0'.$idcentro;
                $this->data['pos_rprint'] = $this->global_model->getValorNumVariable($nombrevar);
				$this->data['pos_sendfacelectroni'] = $this->global_model->getValorNumVariable('pos_sendfacelectroni');
				$this->data['pos_tregalo'] = $this->global_model->getValorNumVariable('pos_tregalo');
                $this->data['pos_multiprint'] = $this->global_model->getValorNumVariable('pos_multiprint');
				$this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
				$this->data['pos_referencia'] = $this->global_model->getValorNumVariable('pos_referencia');
                
                $this->load->view('mantenimiento_facturazdevoluziones_p', $this->data);
				
                $showpprint = array(
					"show_pprint" => 0
				);
				$this->session->set_userdata($showpprint);
            }
        }
        
        //Versión cambio de popup adicionar cliente
		function facturaz($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);

                $direccion = $controlador.'/'.$funcion;

                if ($direccion == 'ventas/facturaz') {
                    $this->configuracion_model->modifyFormatosImpresion();
                    redirect('Facturacion/'.$idApp);
                }
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcionmenu' => $opcionmenu,
                    'controlador_vn' =>$controlador,
                    'funcion_vn' =>$funcion,
                );
                $this->session->set_userdata($resultAppName);

                $this->load->model('user_model');
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('invtran_model');

				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$fechaactual = $date->format('Y-m-d');
                
                $idcaja = $this->session->userdata('idcajauser');
                $idcentro = $this->session->userdata('idcentrouser');

                $direccion = $controlador;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $direccion2 = $controlador.'/pprint';
				$this->data['pprintfo'] = $this->global_model->getFormatosImpresionGrid($direccion2);
                $defven = $this->global_model->getDefaultIdClaseVNSucursal('pos_idclase0'.$idcaja);
                if($defven == 0){
                    $defven = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                }
                $this->data['defven'] = $defven;
				$this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $iduser = $this->session->userdata('iduser');
                $this->data['encargado'] = $this->ventas_model->getEncargadoCentroFacturacion($iduser);
                $this->data['newcliente'] = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
                $this->data['fechaactual'] = $fechaactual;
                $this->data['opcionResumen'] = $this->session->userdata('opcionMostrarResumen');
				
				$this->data['pos_rprint'] = $this->global_model->getValorNumVariable('pos_rprint0'.$idcentro);
				$this->data['pos_sendfacelectroni'] = $this->global_model->getValorNumVariable('pos_sendfacelectroni');
				$this->data['pos_tregalo'] = $this->global_model->getValorNumVariable('pos_tregalo');
                $this->data['pos_multiprint'] = $this->global_model->getValorNumVariable('pos_multiprint');
				$this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
				$this->data['pos_referencia'] = $this->global_model->getValorNumVariable('pos_referencia');
				$this->data['pos_fpedidos'] = $this->global_model->getValorNumVariable('pos_fpedidos');
                $this->data['so_chgstat'] = $this->global_model->getValorTextoVariable('so_chgstat');
                $this->data['pos_oprig'] = $this->global_model->getValorNumVariable('pos_oprig0'.$idcaja);
                $this->data['pos_nconsulta'] = $this->global_model->getValorNumVariable('pos_nconsulta0'.$idcaja);
                $this->data['pos_modecliente'] = $this->global_model->getValorNumVariable('pos_modecliente0'.$idcaja);
                $this->data['pos_ordenes'] = $this->global_model->getValorNumVariable('pos_ordenes0'.$idcaja);
                $this->data['pos_tipocortes'] = $this->global_model->getValorNumVariable("pos_tipocortes");
                $this->data['pos_frecuente'] = $this->global_model->getValorTextoVariable('pos_frecuente');
                $this->data['origenes'] = $this->ventas_model->getOrigenesDeVenta('wo_origen'); 

                
                $this->data['derechos'] =  explode(",", $this->user_model->getDerechos());

                $this->load->view('mantenimiento_facturazdevoluziones_a', $this->data);
				
                $showpprint = array(
					"show_pprint" => 0
				);
				$this->session->set_userdata($showpprint);
            }
        }

        function validacionAperturaDeCaja(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcaja = $this->input->post('idcaja');
				
                $this->load->model('ventas_model');
				echo json_encode($this->ventas_model->validacionAperturaDeCaja($idcaja));
			}
        }
        
		function getClienteLocal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$this->load->model('global_model');
				$this->load->model('ventas_model');
				
				$nombrevar = 'pos_cliente0'.$idcentro;
				$idcliente = $this->global_model->getValorNumVariable($nombrevar);
				$array = $this->ventas_model->getDatosClienteFrecuente($idcliente);	
				echo json_encode($array);
			}
		}
        
        function getInvclaseByCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcliente = $this->input->post('idauxi');
                
                $this->load->model('ventas_model');
				$array = $this->ventas_model->getInvclaseByCliente($idcliente);	
				echo json_encode($array);
			}
        }

        function getDocumentoVendedorByCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idauxi = $this->input->post('idauxi');
                
                $this->load->model('ventas_model');
				echo json_encode($this->ventas_model->getDocumentoVendedorByCliente($idauxi));
			}
        }
        
        function getDatosFacturasVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                
                $datosTemp = array(
                    'idcentroTemp' => $idcentro,
                    'idcajaTemp' => $idcaja,
                    'fechaini' => $fechaini,
                    'fechafin' => $fechafin
                );
                $this->session->set_userdata($datosTemp);
                
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosFacturaciones('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    if($info->exento == 0){
                        $valtax1 = $info->valtax1;
                    }else{
                        $valtax1 = 0;
                    }
                    
                    $totalVenta = $info->valventan + $valtax1;
                    
                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "numeroserie" => $info->numero,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "valventan" => number_format($totalVenta, 2, '.', ''),
                        "estatus" => $info->estatus
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
		
		function getDatosFacturasVentasDia(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
				$idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                $numx = $this->input->post('numx');
                $numz = $this->input->post('numz');
                
                $datosTemp = array(
                    'idcentroTemp' => $idcentro,
                    'idcajaTemp' => $idcaja,
                    'fechaini' => $fechaini
				);
                $this->session->set_userdata($datosTemp);
                
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosFacturacionesDia('VN', $idcentro, $idcaja, $fechaini, $numx, $numz);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    if($info->exento == 0){
                        $valtax1 = $info->valtax1;
                    }else{
                        $valtax1 = 0;
                    }
                    
                    $totalVenta = $info->valventan + $valtax1;
                    
                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "hora" => $info->hora,
                        "tipodoc" => $info->tipodoc,
                        "numeroserie" => $info->numero,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "referencia" => $info->referencia,
                        "valventan" => number_format($totalVenta, 2, '.', ''),
                        "estatus" => $info->estatus
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }

		function getDatosFacturasVentasCajaDia(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
				$idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                $numx = $this->input->post('numx');
                $numz = $this->input->post('numz');
                
                $datosTemp = array(
                    'idcentroTemp' => $idcentro,
                    'idcajaTemp' => $idcaja,
                    'fechaini' => $fechaini
				);
                $this->session->set_userdata($datosTemp);
                
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosFacturasVentasCajaDia('VN', $idcentro, $idcaja, $fechaini, $numx, $numz);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    if($info->exento == 0){
                        $valtax1 = $info->valtax1;
                    }else{
                        $valtax1 = 0;
                    }
                    
                    $totalVenta = $info->valventan + $valtax1;
                    
                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "hora" => $info->hora,
                        "tipodoc" => $info->tipodoc,
                        "numeroserie" => $info->numero,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "referencia" => $info->referencia,
                        "valventan" => number_format($totalVenta, 2, '.', ''),
                        "estatus" => $info->estatus
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }

        function getDatosFacturasVentasCerradasDia(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
				$idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                $numx = $this->input->post('numx');
                $numz = $this->input->post('numz');
                
                $datosTemp = array(
                    'idcentroTemp' => $idcentro,
                    'idcajaTemp' => $idcaja,
                    'fechaini' => $fechaini
				);
                $this->session->set_userdata($datosTemp);
                
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosFacturasVentasCerradasDia('VN', $idcentro, $idcaja, $fechaini, $numx, $numz);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    if($info->exento == 0){
                        $valtax1 = $info->valtax1;
                    }else{
                        $valtax1 = 0;
                    }
                    
                    $totalVenta = $info->valventan + $valtax1;
                    
                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "hora" => $info->hora,
                        "tipodoc" => $info->tipodoc,
                        "numeroserie" => $info->numero,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "referencia" => $info->referencia,
                        "valventan" => number_format($totalVenta, 2, '.', ''),
                        "estatus" => $info->estatus
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
		
		function getPendientesImpresionVentas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
					$idcentro = $this->session->userdata('idcentroTemp');
				}else{
                    $idcentro = $this->session->userdata('idcentrouser');
				}

                $idcaja = $this->session->userdata('idcajauser');
                
				$estado = 0;
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosFacturacionesPendientesPrint('VN', $idcentro, $idcaja, $estado);
                $documentos = $this->ventas_model->getDocumentosFacturacionesPendientesPrint('VN', $idcentro, $idcaja, $estado);
				
                $i=0;
                $detalle = array();
                
				if($datos != false){
					foreach($datos as $info){
						$detalle[$i] = array(
							"trannum" => $info->trannum,
							"fecha" => $info->fecha,
							"idclase" => $info->invclase,
							"tipodoc" => $info->tipodoc,
							"numeroserie" => $info->numeroserie,
							"namecliente" => $info->namecliente,
							"namevendedor" => $info->namevendedor,
							"count" => $info->prncount,
							"estatus" => $info->estatus
						);
						$i++;
					}
				}
				
				$tiposdoc = array();
				$tiposdoc[0] = array(
					'id' => 0,
					'descrip' => 'PENDIENTES'
				);
				
				$j=1;
				foreach($documentos as $doc){
					$tiposdoc[$j] = array(
						'id' => $doc->invclase,
						'descrip' => strtoupper($doc->tipodoc)
					);
					$j++;
				}
				
				if($i==0){
					$i = "0";
				}
				
				$array = array(
					"datos" => $detalle,
					"cantidad" => $i,
					"tiposdoc" => $tiposdoc
				);
                
                echo json_encode($array);
            }
		}
		
		function getPendientesImpresionVentasByTipo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$tipodoc = $this->input->post('tipodoc');
				$controlador = $this->session->userdata('controlador_vn');
                $funcion = $this->session->userdata('funcion_vn');
                // $url = $controlador.'/'.$funcion.'/pprint';
                $url = $controlador.'/pprint';
                $idcaja = $this->session->userdata('idcajauser');
				$estado = 0;
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosFacturacionesPendientesPrintByTipo('VN', $idcentro, $idcaja, $tipodoc, $estado);
				
                $urlPrint = "";
                if($tipodoc != 0){
                    $urlPrint = $this->ventas_model->getFormatoPrintDef($tipodoc, $url);
                }
                
				$i=0;
                $detalle = array();
                
                foreach($datos as $info){
                    $detalle[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "idclase" => $info->invclase,
                        "tipodoc" => $info->tipodoc,
                        "numeroserie" => $info->numeroserie,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "count" => $info->prncount,
						"estatus" => $info->estatus
                    );
                    $i++;
                }
				
				$array = array(
					"datos" => $detalle,
                    "url_print" => $urlPrint
				);
                
                echo json_encode($array);
			}
        }
        
        function getPendientesPrintByTipo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$tipodoc = $this->input->post('tipodoc');
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
				$controlador = $this->session->userdata('controlador_vn');
                $funcion = $this->session->userdata('funcion_vn');
                // $url = $controlador.'/'.$funcion.'/pprint';
                $url = $controlador.'/pprint';
                $idcaja = $this->session->userdata('idcajauser');

				$estado = 0;
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getPendientesPrintByTipo('VN', $idcentro, $idcaja, $tipodoc, $fechaini, $fechafin, $estado);
				
                $urlPrint = "";
                if($tipodoc != 0){
                    $urlPrint = $this->ventas_model->getFormatoPrintDef($tipodoc, $url);
                }
                
				$i=0;
                $detalle = array();
                foreach($datos as $info){
                    $detalle[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "idclase" => $info->invclase,
                        "tipodoc" => $info->tipodoc,
                        "numeroserie" => $info->numeroserie,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "count" => $info->prncount,
						"estatus" => $info->estatus
                    );
                    $i++;
                }
				
				$array = array(
					"datos" => $detalle,
                    "url_print" => $urlPrint
				);
                
                echo json_encode($array);
			}
        }
        
        function insertFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r","\"", "'");
                $reemplazar = array("", "", "", "","","");

                $fecha = $this->input->post('fecha');
                $notas = trim($this->input->post('notas'));
                $notas = str_replace($buscar, $reemplazar, $notas);
                $documento = $this->input->post('documento');
                $vendedor = $this->input->post('vendedor');
                $cliente = $this->input->post('cliente');
                $idcentro = $this->input->post('idcentro');
                $idcentrod = $this->input->post('idcentrod');
                $idcaja = $this->input->post('idcaja');
                $descrip = $this->input->post('descrip');
                $referencia = $this->input->post('referencia');
                
                $this->load->model('global_model');
                $this->load->model('ventas_model');
				
                if($cliente == 999999){
                    $nombrevar = 'pos_grupocli0'.$idcentro;
                    $grupoCliente = $this->global_model->getValorTextoVariable($nombrevar);
                
                    if($grupoCliente == "0"){
                        $cliente = $this->ventas_model->insertNuevoClienteVN($descrip);
                    }else{
                        $cliente = $this->ventas_model->insertNuevoClienteVNGrupo($descrip, $grupoCliente);
                    }
				}
                
                $array = $this->ventas_model->insertarFacturacion($fecha, $notas, $documento, $vendedor, $cliente, $idcentro, $idcentrod, $idcaja, $referencia);
                echo json_encode($array);
            }
        }
        
        function insertFacturacionClienteFrecuente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                // $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
                // $reemplazar = array("", "", "", "");

                // $notas = trim($this->input->post('notas'));
                // $notas = str_replace($buscar, $reemplazar, $notas);
                
                $fecha      = $this->input->post('fecha');
                $cliente    = $this->input->post('cliente');
                $idcentrod  = $this->input->post('idcentrod');
                $idcentro   = $this->input->post('idcentro');
                $idcaja     = $this->input->post('idcaja');
                $documento  = $this->input->post('documento');
                $vendedor   = $this->input->post('vendedor');
                $origen     = $this->input->post('origen');
                $referencia = $this->input->post('referencia');
                $cli_name   = $this->input->post('cli_name');
                $cli_phone  = $this->input->post('cli_phone');
                $cli_email  = $this->input->post('cli_email');
                $cli_dui    = $this->input->post('cli_dui');
                $cli_nrc    = $this->input->post('cli_nrc');
                $cli_nit    = $this->input->post('cli_nit');
                $cli_direc  = $this->input->post('cli_direc');
                $cli_idzip  = $this->input->post('cli_idzip');
                $cli_giro   = $this->input->post('cli_giro');
                $cli_gdte   = ($this->input->post('cli_gdte') !== null) ? $this->input->post('cli_gdte') : '';
                $cli_tipo   = $this->input->post('cli_tipo');
                
                $this->load->model('global_model');
                $this->load->model('ventas_model');
				
                if ($cliente == 999999) {
                    $nombrevar = 'pos_grupocli0'.$idcentro;
                    $grupoCliente = $this->global_model->getValorTextoVariable($nombrevar);
                
                    if($grupoCliente == "0"){
                        $cliente = $this->ventas_model->insertNuevoClienteFrecuenteVN($cli_name, $cli_phone, $cli_email, $cli_dui, $cli_nrc, $cli_direc, $cli_idzip, $cli_giro, $cli_gdte, $cli_tipo, $cli_nit);
                    }else{
                        $cliente = $this->ventas_model->insertNuevoClienteFrecuenteVNGrupo($cli_name, $cli_phone, $cli_email, $cli_dui, $cli_nrc, $cli_direc, $cli_idzip, $cli_giro, $cli_gdte, $cli_tipo, $grupoCliente, $cli_nit);
                    }
				} else $this->ventas_model->updateRegistroClienteFrecuente($cliente, $cli_name, $cli_phone, $cli_email, $cli_dui, $cli_nrc, $cli_direc, $cli_idzip, $cli_giro, $cli_gdte, $cli_tipo, $cli_nit);
                
                $array = $this->ventas_model->insertarFacturacion($fecha, '', $documento, $vendedor, $cliente, $idcentro, $idcentrod, $idcaja, $referencia, 0, $origen);
                echo json_encode($array);
            }
        }
        
        function insertFacturacionClienteFrecuenteNC(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                // $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
                // $reemplazar = array("", "", "", "");

                // $notas = trim($this->input->post('notas'));
                // $notas = str_replace($buscar, $reemplazar, $notas);
                
                $fecha      = $this->input->post('fecha');
                $cliente    = $this->input->post('cliente');
                $idcentrod  = $this->input->post('idcentrod');
                $idcentro   = $this->input->post('idcentro');
                $idcaja     = $this->input->post('idcaja');
                $documento  = $this->input->post('documento');
                $vendedor   = $this->input->post('vendedor');
                $referencia = $this->input->post('referencia');
                $cli_name   = $this->input->post('cli_name');
                $cli_phone  = $this->input->post('cli_phone');
                $cli_email  = $this->input->post('cli_email');
                $cli_dui    = $this->input->post('cli_dui');
                $cli_nrc    = $this->input->post('cli_nrc');
                $cli_nit    = $this->input->post('cli_nit');
                $cli_direc  = $this->input->post('cli_direc');
                $cli_idzip  = $this->input->post('cli_idzip');
                $cli_giro   = $this->input->post('cli_giro');
                $cli_gdte   = ($this->input->post('cli_gdte') !== null) ? $this->input->post('cli_gdte') : '';
                $cli_tipo   = $this->input->post('cli_tipo');
                $tranref    = $this->input->post('tranref');
                $devDate    = $this->input->post('devDate');
                $devSerie   = $this->input->post('devSerie');
                $devNumero  = $this->input->post('devNumero');
                
                $this->load->model('global_model');
                $this->load->model('ventas_model');
				
                if ($cliente == 999999) {
                    $nombrevar = 'pos_grupocli0'.$idcentro;
                    $grupoCliente = $this->global_model->getValorTextoVariable($nombrevar);
                
                    if($grupoCliente == "0"){
                        $cliente = $this->ventas_model->insertNuevoClienteFrecuenteVN($cli_name, $cli_phone, $cli_email, $cli_dui, $cli_nrc, $cli_direc, $cli_idzip, $cli_giro, $cli_gdte, $cli_tipo, $cli_nit);
                    }else{
                        $cliente = $this->ventas_model->insertNuevoClienteFrecuenteVNGrupo($cli_name, $cli_phone, $cli_email, $cli_dui, $cli_nrc, $cli_direc, $cli_idzip, $cli_giro, $cli_gdte, $cli_tipo, $grupoCliente, $cli_nit);
                    }
				} else $this->ventas_model->updateRegistroClienteFrecuente($cliente, $cli_name, $cli_phone, $cli_email, $cli_dui, $cli_nrc, $cli_direc, $cli_idzip, $cli_giro, $cli_gdte, $cli_tipo, $cli_nit);
                
                $array = $this->ventas_model->insertarFacturacionNC($fecha, '', $documento, $vendedor, $cliente, $idcentro, $idcentrod, $idcaja, $referencia, $tranref, $devDate, $devSerie, $devNumero);
                echo json_encode($array);
            }
        }
        
        function detallefacturacionprincipal($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
				$this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
					$idcentro = $this->session->userdata('idcentroTemp');
					$idcaja = $this->session->userdata('idcajaTemp');
				}else{
                    $idcentro = $this->session->userdata('idcentrouser');
					$idcaja = $this->session->userdata('idcajauser');
                }
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $this->data['informacion'] = $this->ventas_model->getDatosFactura($trannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
				$nombrevar = 'pos_chgpre0'.$idcentro;
				$this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
				$this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
				$this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
				$this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
				$name_var = 'pos_easy0'.$idcaja;
				$this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
				
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                $this->load->view('mantenimiento_detallefacturas2', $this->data);
            }
        }
		
		function detallefacturacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
				$this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
					$idcentro = $this->session->userdata('idcentroTemp');
					$idcaja = $this->session->userdata('idcajaTemp');
				}else{
                    $idcentro = $this->session->userdata('idcentrouser');
					$idcaja = $this->session->userdata('idcajauser');
                }
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $this->data['informacion'] = $this->ventas_model->getDatosFactura($trannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
				$nombrevar = 'pos_chgpre0'.$idcentro;
				$this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
				$this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
				$this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
				$this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
				$name_var = 'pos_easy0'.$idcaja;
				$this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
				
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detallefacturas_simple', $this->data);
            }
        }        
        //Modificado 20180810*******************
		function detallefacturazion_old($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
				$this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
					$idcentro = $this->session->userdata('idcentroTemp');
					$idcaja = $this->session->userdata('idcajaTemp');
				}else{
                    $idcentro = $this->session->userdata('idcentrouser');
					$idcaja = $this->session->userdata('idcajauser');
                }
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                
                $informacionFactura = $this->ventas_model->getDatosFactura($trannum);
                $this->data['informacion'] = $informacionFactura;
                
                foreach($informacionFactura as $info){
                    $idclase = $info->idclase;
                }
                
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
				$nombrevar = 'pos_chgpre0'.$idcentro;
				$this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
                $this->data['pos_maxglodiscount'] = $this->global_model->getValorNumVariable('pos_maxglodiscount');
                $this->data['clavedescuentos'] = $this->global_model->getValorNotasVariable('pos_maxglodiscount');
                $this->data['pos_emailreq'] = $this->global_model->getValorNumVariable('pos_emailreq');
				$this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
				$this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
				$this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
				$this->data['pos_precios'] = $this->global_model->getValorNumVariable('pos_precios');
				$name_var = 'pos_easy0'.$idcaja;
				$this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
                $name_var2 = 'pos_cajafast0'.$idcaja;
                $this->data['pos_cajafast'] = $this->global_model->getValorNumVariable($name_var2);
				
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $pos_searchmod = $this->global_model->getValorNumVariable('pos_searchmod');
                
                if($pos_searchmod == 1){
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_dxgrid', $this->data);
                }else{
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_simple_cambios', $this->data);
                }
            }
        }
        //Modificado 20181217*******************
        function detallefacturazion_modificadokc($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
                $this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
                
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $informacionFactura = $this->ventas_model->getDatosFactura($trannum);
                $this->data['informacion'] = $informacionFactura;
                
                foreach($informacionFactura as $info){
                    $idclase = $info->idclase;
                }
                
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $nombrevar = 'pos_chgpre0'.$idcentro;
                $this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
                $this->data['pos_maxglodiscount'] = $this->global_model->getValorNumVariable('pos_maxglodiscount');
                $this->data['pos_emailreq'] = $this->global_model->getValorNumVariable('pos_emailreq');
                $this->data['clavedescuentos'] = $this->global_model->getValorNotasVariable('pos_maxglodiscount');
                $this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
                $this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
                $this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
                $this->data['pos_precios'] = $this->global_model->getValorNumVariable('pos_precios');
                $this->data['send_print'] = $this->global_model->getValorNumVariable('pos_sendprint0'.$idcaja);
                $name_var = 'pos_easy0'.$idcaja;
                $this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
                $name_var2 = 'pos_cajafast0'.$idcaja;
                $this->data['pos_cajafast'] = $this->global_model->getValorNumVariable($name_var2);
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $pos_searchmod = $this->global_model->getValorNumVariable('pos_searchmod');
                
                if($pos_searchmod == 1){
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_dxgrid', $this->data);
                }else{
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    #$this->load->view('mantenimiento_detallefacturaz_simple_key', $this->data);
                    $this->load->view('mantenimiento_detallefacturaz_simple_cambios', $this->data);
                }
            }
        }
        //Modificado 20181217*******************
        function detallefacturazion__funcionando($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
                $this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
                
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $informacionFactura = $this->ventas_model->getDatosFactura($trannum);
                $this->data['informacion'] = $informacionFactura;
                
                foreach($informacionFactura as $info){
                    $idclase = $info->idclase;
                }
                
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $nombrevar = 'pos_chgpre0'.$idcentro;
                $this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
                $this->data['pos_cupon'] = $this->global_model->getValorTextoVariable('pos_cupon');
                $this->data['pos_maxglodiscount'] = $this->global_model->getValorNumVariable('pos_maxglodiscount');
                $this->data['pos_aplmaxdiscount'] = $this->global_model->getValorNumVariable('pos_aplmaxdiscount');
                $this->data['pos_emailreq'] = $this->global_model->getValorNumVariable('pos_emailreq');
                $this->data['clavedescuentos'] = $this->global_model->getValorNotasVariable('pos_maxglodiscount');
                $this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
                $this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
                $this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
                $this->data['pos_precios'] = $this->global_model->getValorNumVariable('pos_precios');
                $this->data['send_print'] = $this->global_model->getValorNumVariable('pos_sendprint0'.$idcaja);
                $name_var = 'pos_easy0'.$idcaja;
                $this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
                $name_var2 = 'pos_cajafast0'.$idcaja;
                $this->data['pos_cajafast'] = $this->global_model->getValorNumVariable($name_var2);
                $this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $pos_searchmod = $this->global_model->getValorNumVariable('pos_searchmod');
                
                if($pos_searchmod == 1){
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_dxgrid', $this->data);
                }else{
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    #$this->load->view('mantenimiento_detallefacturaz_simple_key', $this->data);
                    $this->load->view('mantenimiento_detallefacturaz_descuento', $this->data);
                }
            }
        }        
        //MODIFICACION PAGO EFECTIVO
        function detallefacturazion_pagos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
                $this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
                
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $informacionFactura = $this->ventas_model->getDatosFactura($trannum);
                $this->data['informacion'] = $informacionFactura;
                
                foreach($informacionFactura as $info){
                    $idclase = $info->idclase;
                }
                
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $nombrevar = 'pos_chgpre0'.$idcentro;
                $this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
                $this->data['pos_maxglodiscount'] = $this->global_model->getValorNumVariable('pos_maxglodiscount');
                $this->data['pos_aplmaxdiscount'] = $this->global_model->getValorNumVariable('pos_aplmaxdiscount');
                $this->data['pos_emailreq'] = $this->global_model->getValorNumVariable('pos_emailreq');
                $this->data['clavedescuentos'] = $this->global_model->getValorNotasVariable('pos_maxglodiscount');
                $this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
                $this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
                $this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
                $this->data['pos_precios'] = $this->global_model->getValorNumVariable('pos_precios');
                $this->data['send_print'] = $this->global_model->getValorNumVariable('pos_sendprint0'.$idcaja);
                $name_var = 'pos_easy0'.$idcaja;
                $this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
                $name_var2 = 'pos_cajafast0'.$idcaja;
                $this->data['pos_cajafast'] = $this->global_model->getValorNumVariable($name_var2);
                $this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $pos_searchmod = $this->global_model->getValorNumVariable('pos_searchmod');
                
                if($pos_searchmod == 1){
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_dxgrid', $this->data);
                }else{
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    #$this->load->view('mantenimiento_detallefacturaz_simple_key', $this->data);
                    $this->load->view('mantenimiento_detallefacturaz_pagos', $this->data);
                }
            }
        }        
        //Modificado 20190117*******************
        function detallefacturaziondescuento($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
                $this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
                
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $informacionFactura = $this->ventas_model->getDatosFactura($trannum);
                $this->data['informacion'] = $informacionFactura;
                
                foreach($informacionFactura as $info){
                    $idclase = $info->idclase;
                }
                
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $nombrevar = 'pos_chgpre0'.$idcentro;
                $this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
                $this->data['pos_maxglodiscount'] = $this->global_model->getValorNumVariable('pos_maxglodiscount');
                $this->data['pos_emailreq'] = $this->global_model->getValorNumVariable('pos_emailreq');
                $this->data['clavedescuentos'] = $this->global_model->getValorNotasVariable('pos_maxglodiscount');
                $this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
                $this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
                $this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
                $this->data['pos_precios'] = $this->global_model->getValorNumVariable('pos_precios');
                $this->data['send_print'] = $this->global_model->getValorNumVariable('pos_sendprint0'.$idcaja);
                $name_var = 'pos_easy0'.$idcaja;
                $this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
                $name_var2 = 'pos_cajafast0'.$idcaja;
                $this->data['pos_cajafast'] = $this->global_model->getValorNumVariable($name_var2);
                $this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $pos_searchmod = $this->global_model->getValorNumVariable('pos_searchmod');
                
                if($pos_searchmod == 1){
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_dxgrid', $this->data);
                }else{
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    #$this->load->view('mantenimiento_detallefacturaz_simple_key', $this->data);
                    $this->load->view('mantenimiento_detallefacturaz_descuento', $this->data);
                }
            }
        }
        
        function detallefacturazion_cambios($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
				$this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
					$idcentro = $this->session->userdata('idcentroTemp');
					$idcaja = $this->session->userdata('idcajaTemp');
				}else{
                    $idcentro = $this->session->userdata('idcentrouser');
					$idcaja = $this->session->userdata('idcajauser');
                }
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $this->data['informacion'] = $this->ventas_model->getDatosFactura($trannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
				$nombrevar = 'pos_chgpre0'.$idcentro;
				$this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
				$this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
				$this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
				$this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
				$this->data['pos_precios'] = $this->global_model->getValorNumVariable('pos_precios');
				$name_var = 'pos_easy0'.$idcaja;
				$this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
				
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $pos_searchmod = $this->global_model->getValorNumVariable('pos_searchmod');
                
                if($pos_searchmod == 1){
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_dxgrid', $this->data);
                }else{
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_simple_cambios', $this->data);
                }
            }
        }        
        //Modificado 20190129*******************
        function detallefacturazioncanje($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
                $this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
                
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $informacionFactura = $this->ventas_model->getDatosFactura($trannum);
                $this->data['informacion'] = $informacionFactura;
                
                foreach($informacionFactura as $info){
                    $idclase = $info->idclase;
                }
                
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $nombrevar = 'pos_chgpre0'.$idcentro;
                $this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
                $this->data['pos_maxglodiscount'] = $this->global_model->getValorNumVariable('pos_maxglodiscount');
                $this->data['pos_emailreq'] = $this->global_model->getValorNumVariable('pos_emailreq');
                $this->data['clavedescuentos'] = $this->global_model->getValorNotasVariable('pos_maxglodiscount');
                $this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
                $this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
                $this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
                $this->data['pos_precios'] = $this->global_model->getValorNumVariable('pos_precios');
                $pos_canje = $this->global_model->getValorNumVariable('pos_canje');
                $this->data['pos_canje'] = $pos_canje;
                $this->data['send_print'] = $this->global_model->getValorNumVariable('pos_sendprint0'.$idcaja);
                $name_var = 'pos_easy0'.$idcaja;
                $this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
                $name_var2 = 'pos_cajafast0'.$idcaja;
                $this->data['pos_cajafast'] = $this->global_model->getValorNumVariable($name_var2);
                $this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $pos_searchmod = $this->global_model->getValorNumVariable('pos_searchmod');
                
                $variableInfoCanje = array(
                    "pos_canje" => $pos_canje
                );
                $this->session->set_userdata($variableInfoCanje);
                
                if($pos_searchmod == 1){
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_dxgrid', $this->data);
                }else{
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    #$this->load->view('mantenimiento_detallefacturaz_simple_key', $this->data);
                    $this->load->view('mantenimiento_detallefacturaz_canje', $this->data);
                }
            }
        }


        //20200226 Modificacion Combos
        //20220225 Separar campos nrc y dui
        //20220225 Cambios modal adicionar/modificar producto
        function detallefacturazion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('dte_model');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
                $this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if ( $opcion == 1 ) {
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja   = $this->session->userdata('idcajaTemp');
                } else {
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja   = $this->session->userdata('idcajauser');
                }
                
                $controlador = $this->uri->segment(1);
                $funcion     = $this->uri->segment(2);
                $direccion   = $controlador.'/'.$funcion;

                if ($direccion == 'ventas/detallefacturazion') {
                    $this->load->model('configuracion_model');
                    $this->configuracion_model->modifyFormatosImpresion();
                    redirect('Detalle_Facturacion/'.$trannum);
                }
                
                $this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['documentos']  = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven']      = $this->global_model->getDefaultIdClaseVN('pos_idclase0'.$idcaja);
                $informacionFactura        = $this->ventas_model->getDatosFactura($trannum);
                $this->data['informacion'] = $informacionFactura;
                
                foreach ( $informacionFactura as $info ) {
                    $idclase = $info->idclase;
                    $iddte   = ( $info->iddte == '' ) ? 0 : 1;
                    $idcliente = $info->idcps;
                    $inopera = $info->inopera;
                }
                
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);

                if ( $this->session->userdata('opcionCambioPrecio' ) == 0 ) {
                    $this->data['pdescuento'] = $this->global_model->getValorNumVariable('pos_chgpre0'.$idcentro);
                } else {
                    $this->data['pdescuento'] = 1;
                }
                
                $this->data['inopera']            = $inopera;
                $this->data['documentoDTE']       = (( $iddte == 0 ) ? 0 : (( $this->dte_model->validateExistDocumentDte($trannum) != false ) ? 1 : 0));
                $this->data['pos_prenoiva']       = $this->global_model->getValorNumVariable('pos_prenoiva');
                $this->data['pos_cupon']          = $this->global_model->getValorTextoVariable('pos_cupon');
                $this->data['pos_timevn']         = $this->global_model->getValorTextoVariable('pos_timevn');
                $this->data['pos_recargo']        = $this->global_model->getValorNumVariable('pos_recargo');
                $this->data['name_recargo']       = $this->global_model->getDescripVariable('pos_recargo');
                $this->data['pos_maxglodiscount'] = $this->global_model->getValorNumVariable('pos_maxglodiscount');
                $this->data['pos_aplmaxdiscount'] = $this->global_model->getValorNumVariable('pos_aplmaxdiscount');
                $this->data['pos_emailreq']       = $this->global_model->getValorNumVariable('pos_emailreq');
                $this->data['clavedescuentos']    = $this->global_model->getValorNotasVariable_Pa('pos_maxglodiscount');
                $this->data['clavecomision']      = $this->global_model->getValorNotasVariable_Pa('pos_recargo');
                $this->data['actividades']        = $this->cliente_model->verActividades();
                $this->data['gzip_depto']         = $this->cliente_model->viewDepto();
                $this->data['gzip_munic']         = $this->cliente_model->viewMunicipio();
                $this->data['defidzip']           = $this->global_model->getValorNumVariable('gv_zip');
                $this->data['pos_vendemode']      = $this->global_model->getValorNumVariable('pos_vendemode');
                $this->data['pos_precios']        = $this->global_model->getValorNumVariable('pos_precios');
                $this->data['send_print']         = $this->global_model->getValorNumVariable('pos_sendprint0'.$idcaja);
                $this->data['pos_easy']           = $this->global_model->getValorNumVariable('pos_easy0'.$idcaja);
                $this->data['pos_cajafast']       = $this->global_model->getValorNumVariable('pos_cajafast0'.$idcaja);
                $this->data['pos_secure']         = $this->global_model->getValorNumVariable('pos_secure');
                $this->data['pos_referencia']     = $this->global_model->getValorNumVariable('pos_referencia');
                $this->data['nameServicios']      = $this->global_model->getDescripcionTipoProducto(4);
                $this->data['pos_combo']          = $this->global_model->getValorNumVariable('pos_combo0'.$idcaja);
                $this->data['pos_nmodifica']      = $this->global_model->getValorNumVariable('pos_nmodifica0'.$idcaja);
                $this->data['pos_series']         = $this->global_model->getValorNumVariable('po_series');
                $this->data['preciosXCliente']    = $this->global_model->getValorNumVariable('pos_preciosXCliente');

                $pos_lprecio   = $this->global_model->getValorNumVariable('pos_lprecio');
                $numDecimales  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 17);
                $pos_svendedor = $this->global_model->getValorNumVariable('pos_svendedor0'.$idcaja);
                
                $this->data['pos_lprecio']   = $pos_lprecio;
                $this->data['nlPrecios']     = ($pos_lprecio == 0) ? '' : $this->ventas_model->getListaPrecioCliente($idcliente);
                $this->data['numdecimales']  = ( $numDecimales == '' ) ? 2 : (int) $numDecimales;
                $this->data['clave_precios'] = $this->global_model->getValorTextoVariable('pos_clavepre0'.$idcaja);
                $this->data['passMultiPrecio'] = $this->global_model->getValorTextoVariable('pos_passmulti');
                $this->data['pos_nocatalog'] = $this->global_model->getValorNumVariable('pos_nocatalog0'.$idcaja);
                $this->data['pos_svendedor'] = $pos_svendedor;
                $this->data['vendedores']    = ($pos_svendedor == 1) ? $this->ventas_model->getVendedoresActivosxSucursal($idcentro) : $this->ventas_model->getVendedoresActivos();
                $this->data['ucajera']       = $this->ventas_model->getUcajera($idcaja, $idcentro);
                
                $tipoBusca     = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $pos_searchmod = $this->global_model->getValorNumVariable('pos_searchmod');
                
                if($pos_searchmod == 1){
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_dxgrid', $this->data);
                }else{
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    #$this->load->view('mantenimiento_detallefacturaz_simple_key', $this->data);
                    $this->load->view('mantenimiento_detalle_facturaz_combos', $this->data);
                }
            }
        }

        function detallefacturazion_sn($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
                $this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
                
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $informacionFactura = $this->ventas_model->getDatosFactura($trannum);
                $this->data['informacion'] = $informacionFactura;
                
                foreach($informacionFactura as $info){
                    $idclase = $info->idclase;
                }
                
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $nombrevar = 'pos_chgpre0'.$idcentro;
                $this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
                $this->data['pos_cupon'] = $this->global_model->getValorTextoVariable('pos_cupon');
                $this->data['pos_maxglodiscount'] = $this->global_model->getValorNumVariable('pos_maxglodiscount');
                $this->data['pos_aplmaxdiscount'] = $this->global_model->getValorNumVariable('pos_aplmaxdiscount');
                $this->data['pos_emailreq'] = $this->global_model->getValorNumVariable('pos_emailreq');
                $this->data['clavedescuentos'] = $this->global_model->getValorNotasVariable('pos_maxglodiscount');
                $this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
                $this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
                $this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
                $this->data['pos_stockmode'] = $this->global_model->getValorNumVariable('pos_stockmode');
                $this->data['pos_precios'] = $this->global_model->getValorNumVariable('pos_precios');
                $this->data['send_print'] = $this->global_model->getValorNumVariable('pos_sendprint0'.$idcaja);
                $name_var = 'pos_easy0'.$idcaja;
                $this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
                $name_var2 = 'pos_cajafast0'.$idcaja;
                $this->data['pos_cajafast'] = $this->global_model->getValorNumVariable($name_var2);
                $this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $pos_searchmod = $this->global_model->getValorNumVariable('pos_searchmod');
                
                if($pos_searchmod == 1){
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    $this->load->view('mantenimiento_detallefacturaz_dxgrid', $this->data);
                }else{
                    if($tipoBusca == 1){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Interno"
                        );
                    }elseif($tipoBusca == 2){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Modelo"
                        );
                    }elseif($tipoBusca == 3){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código de Barra"
                        );
                    }elseif($tipoBusca == 4){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Código Xpos"
                        );
                    }elseif($tipoBusca == 5){
                        $array = array(
                            "gv_prodsearch" => $tipoBusca,
                            "gv_prodtext" => "Descripción"
                        );
                    }
                    $this->session->set_userdata($array);
                    
                    #$this->load->view('mantenimiento_detallefacturaz_simple_key', $this->data);
                    $this->load->view('mantenimiento_detalle_facturaz_stock', $this->data);
                }
            }
        }
		
		function anulacionVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('trannum');
				$this->load->model('ventas_model');
                $array = $this->ventas_model->setAnulacionVenta($idtrannum);
                echo json_encode($array);
			}
		}
		
		function anulacionVentaMotivo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$motivo = $this->input->post('motivo');
                
				$this->load->model('ventas_model');
                $array = $this->ventas_model->setanulacionVentaMotivo($trannum, $motivo);
                
                echo json_encode($array);
			}
		}

        function generarDescuentoGlobal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $descuento = $this->input->post('descuento');
                $idcatalogo = $this->input->post('idcatalogo');
                $modevn = $this->input->post('modevn');
                $filtrodatos = $this->input->post('filtrodatos');
                $max_pro = $this->input->post('max_pro');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('ventas_model'); $this->load->model('invtran_model');
                $this->ventas_model->generarDescuentoGlobal($trannum, $descuento, $max_pro);

                if($filtrodatos == 1){
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 2){
                    $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 3){
                    $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 4){
                    $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    } 
                    
                    $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }else if($filtrodatos == 5){
                    $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "upp" => $serv->upp,
                            "xpos" => $serv->xpos,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                                
                if($filtrodatos == 1){
                    $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                }
                
                if($filtrodatos != 4 && $filtrodatos != 5){
                    $i=0;
                    $items = array();
                    foreach($detalle as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }
                
                if($filtrodatos == 1){
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "upp" => $serv->upp,
                            "xpos" => $serv->xpos,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i,
                    "total" => $total
                );
                
                echo json_encode($array);
            }
        }

        function generarComisionGlobal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum     = $this->input->post('trannum');
                $comision    = $this->input->post('comision');
                $idcatalogo  = $this->input->post('idcatalogo');
                $modevn      = $this->input->post('modevn');
                $filtrodatos = $this->input->post('filtrodatos');
                $max_pro     = $this->input->post('max_pro');
                $opcion      = $this->session->userdata('opcionmenu');
                $idcentro    = ( $opcion == 1 ) ? $this->session->userdata('idcentroTemp') : $this->session->userdata('idcentrouser');
                
                $this->load->model('ventas_model'); $this->load->model('invtran_model');
                $this->ventas_model->generarComisionGlobal($trannum, $comision);

                if($filtrodatos == 1){
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 2){
                    $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 3){
                    $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 4){
                    $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    } 
                    
                    $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }else if($filtrodatos == 5){
                    $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "upp" => $serv->upp,
                            "xpos" => $serv->xpos,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                                
                if($filtrodatos == 1){
                    $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                }
                
                if($filtrodatos != 4 && $filtrodatos != 5){
                    $i=0;
                    $items = array();
                    foreach($detalle as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }
                
                if($filtrodatos == 1){
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "upp" => $serv->upp,
                            "xpos" => $serv->xpos,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i,
                    "total" => $total
                );
                
                echo json_encode($array);
            }
        }
        
        function revertirComisionGlobal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum     = $this->input->post('trannum');
                $idcatalogo  = $this->input->post('idcatalogo');
                $modevn      = $this->input->post('modevn');
                $filtrodatos = $this->input->post('filtrodatos');
                $max_pro     = $this->input->post('max_pro');
                $opcion      = $this->session->userdata('opcionmenu');
                $idcentro    = ( $opcion == 1 ) ? $this->session->userdata('idcentroTemp') : $this->session->userdata('idcentrouser');
                
                $this->load->model('ventas_model'); $this->load->model('invtran_model');
                $this->ventas_model->revertirComisionGlobal($trannum);

                if($filtrodatos == 1){
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 2){
                    $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 3){
                    $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 4){
                    $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    } 
                    
                    $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }else if($filtrodatos == 5){
                    $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "upp" => $serv->upp,
                            "xpos" => $serv->xpos,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                                
                if($filtrodatos == 1){
                    $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                }
                
                if($filtrodatos != 4 && $filtrodatos != 5){
                    $i=0;
                    $items = array();
                    foreach($detalle as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }
                
                if($filtrodatos == 1){
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "upp" => $serv->upp,
                            "xpos" => $serv->xpos,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i,
                    "total" => $total
                );
                
                echo json_encode($array);
            }
        }

        function aplicarCuponDescuento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $descuento = $this->input->post('descuento');
                $idcatalogo = $this->input->post('idcatalogo');
                $modevn = $this->input->post('modevn');
                $filtrodatos = $this->input->post('filtrodatos');
                $totalVenta = $this->input->post('totalVenta');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('ventas_model'); $this->load->model('invtran_model');
                $this->ventas_model->aplicarCuponDescuento($trannum, $descuento, $totalVenta);

                if($filtrodatos == 1){
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 2){
                    $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 3){
                    $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 4){
                    $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    } 
                    
                    $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }else if($filtrodatos == 5){
                    $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "upp" => $serv->upp,
                            "xpos" => $serv->xpos,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                                
                if($filtrodatos == 1){
                    $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                }
                
                if($filtrodatos != 4 && $filtrodatos != 5){
                    $i=0;
                    $items = array();
                    foreach($detalle as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "xpos" => $info->xpos,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }
                
                if($filtrodatos == 1){
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "upp" => $serv->upp,
                            "xpos" => $serv->xpos,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i,
                    "total" => $total
                );
                
                echo json_encode($array);
            }
        }

        function actualizarClaveDescuentos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $clavedescuento = $this->input->post('clavedescuento');

                $this->load->model('ventas_model');
                $array = $this->ventas_model->actualizarClaveDescuentos($clavedescuento);

                echo json_encode($array);
            }
        }
		
		function setRenumeracionDocumento(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$numero = $this->input->post('numero');
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
                
				$this->load->model('ventas_model');
                $array = $this->ventas_model->setRenumeracionDocumento($trannum, $numero);
                $idclase = $this->ventas_model->getIdClaseVenta($trannum);
                $numTipo = $this->ventas_model->getNumTipoTransaccion($idclase);
                
                if($numTipo == 1){ //Empresa
					$this->ventas_model->updateNumerosFacturasEmpresa($trannum);
				}else if($numTipo == 2){ //Sucursal
					$this->ventas_model->updateNumerosFacturasSucursal($trannum, $idcentro);
				}else if($numTipo == 3){ //Caja
					$this->ventas_model->updateNumerosFacturas($trannum, $idcentro, $idcaja);
				}
                
                echo json_encode($array);
			}
		}
		
		function getValidateExistRetencion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idclase = $this->input->post('idclase');
				
				$this->load->model('ventas_model');
				$infoExi = $this->ventas_model->getInformacionRetencionDef();
				$infoCFF = $this->ventas_model->getVerificacionCff($idclase);
				
				$array = array(
					"infoExist" => $infoExi,
					"infoCFF" => $infoCFF
				);
                echo json_encode($array);
			}
		}
		
		function updateAndInsertRetencion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$totalGravado = $this->input->post('totalGravado');
				$idcliente = $this->input->post('idcliente');
				$inputContribuyente = $this->input->post('inputContribuyente');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->updateAndInsertRetencion($idcliente, $trannum, $totalGravado, $inputContribuyente);
				
				echo json_encode($array);	
			}
		}
		
		function updateRegistroContribuyente(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$idcliente = $this->input->post('idcliente');
				$inputContribuyente = $this->input->post('inputContribuyente');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->updateRegistroContribuyenteCliente($trannum, $idcliente, $inputContribuyente);
				
				echo json_encode($array);				
			}
		}
		
		function getListadoClientesActivos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('ventas_model');
				$idauxidef = 2;
				$estado = 1;
                $array = $this->ventas_model->getListadoClientesFilter($idauxidef, $estado);
                echo json_encode($array);
			}
		}
		
		function validatePasswordAnulacion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$password = $this->input->post('password');
				$this->load->model('ventas_model');
                $array = $this->ventas_model->getValidatePassword($password);
                echo json_encode($array);
			}
		}
		
		function getDataProductoAgregadoVn(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idproducto = $this->input->post('idproducto');
				
				$this->load->model('ventas_model');
                $array = $this->ventas_model->getDataProductoVentaTran100k($idtrannum, $idproducto);

                echo json_encode($array);
			}
		}
		
		function getDataProductoAgregadoVnPrueba(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idproducto = $this->input->post('idproducto');
				
				$this->load->model('ventas_model');
                $array = $this->ventas_model->getDataProductoVentaTran100k($idtrannum, $idproducto);

                echo json_encode($array);
			}
		}
		
		function getDataProductoNuevoVn(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idproducto = $this->input->post('idproducto');
				
				$opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('invtran_model');
                $detalle = $this->invtran_model->getInventarioByProductoVN($idtrannum,$idcentro,$idproducto);

                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    $datos[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "upp" => $info->upp,
                        "tipo" => $info->tipo,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "precio" => $info->costounitario,
                        "idbin" => $info->idbin,
                        "idbatch" => $info->idbatch,
                        "precioventa" => $info->precioventa,
                        "idcatalogo" => $info->idcatalogo,
                        "tipotax" => $info->tipotax
                    );
                    $i++;
                }
                
                $array = array(
                    "datos" => $datos,
                );
                echo json_encode($array);
			}
		}
		
		function getListadoLineasVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$opcion = $this->session->userdata('opcionmenu');
				$idtrannum = $this->input->post('trannum');
				$this->load->model('invtran_model');
				$this->load->model('ventas_model');

                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
				
				$lineas = $this->invtran_model->getGruposInventario($idcentro);
				$cantid = $this->ventas_model->getCantidadesCatalogo($idtrannum, $idcentro);
				
				$i=0;
				$array = array();
				
				foreach($lineas as $data){
					foreach($cantid as $cant){
						if($data->idcatalogo == $cant->idcatalogo){
							$array[$i] = array(
								"idcatalogo" => $data->idcatalogo,
								"imagen" => $data->imagen,
								"descrip" => $data->descrip,
								"total" => $cant->cantidad
							);
						}		
					}
					$i++;
				}
				
                echo json_encode($array);
			}
		}
		
		function getListadoLineasVentaPrueba(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$opcion = $this->session->userdata('opcionmenu');
				$idtrannum = $this->input->post('trannum');
				$this->load->model('invtran_model');
				$this->load->model('ventas_model');

                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
				
				$lineas = $this->invtran_model->getGruposInventario($idcentro);
				$linSer = $this->invtran_model->getGruposServicios(4);
				$cantid = $this->ventas_model->getCantidadesCatalogo($idtrannum, $idcentro);
				$canSer = $this->ventas_model->getCantidadesCatalogoServices($idtrannum, 4);
				
				$i=0;
				$array = array();
				if($lineas != false){
					foreach($lineas as $data){
						foreach($cantid as $cant){
							if($data->idcatalogo == $cant->idcatalogo){
								$array[$i] = array(
									"idcatalogo" => $data->idcatalogo,
									"imagen" => $data->imagen,
									"descrip" => $data->descrip,
									"posicion" => $data->posicion,
									"total" => $cant->cantidad
								);
							}		
						}
						$i++;
					}
				}
				
				if($linSer != false){
					foreach($linSer as $data){
						foreach($canSer as $cant){
							if($data->idcatalogo == $cant->idcatalogo){
								$array[$i] = array(
									"idcatalogo" => $data->idcatalogo,
									"imagen" => $data->imagen,
									"descrip" => $data->descrip,
									"posicion" => $data->posicion,
									"total" => $cant->cantidad
								);
							}		
						}
						$i++;
					}	
				}
				
                $sortArray = array(); 
                
				foreach($array as $catalog){ 
					foreach($catalog as $key=>$value){ 
						if(!isset($sortArray[$key])){
							$sortArray[$key] = array(); 
						} 
						$sortArray[$key][] = $value; 
					} 
				}
				
				$orderby = "posicion";

				array_multisort($sortArray[$orderby], SORT_ASC, SORT_NUMERIC, $array); 
                
                echo json_encode($array);
			}
		}
		
		function getListadoLineasVentaSimple(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $vnLineas = $this->input->post('vnLineas');

				$opcion = $this->session->userdata('opcionmenu');
				$this->load->model('global_model');
				$this->load->model('invtran_model');

                $sMateriaP = $this->global_model->getValorNumVariable('pos_searchmp');

                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
				
                $lineas = $this->invtran_model->getGruposInventario($idcentro, $sMateriaP, $vnLineas);
				$linSer = $this->invtran_model->getGruposServicios(4, $idcentro, $vnLineas);
				
				$i=0;
				$array = array();
				if($lineas != false){
					foreach($lineas as $data){
                        $array[$i] = array(
                            "idcatalogo" => $data->idcatalogo,
                            "imagen" => $data->imagen,
                            "descrip" => strtoupper($data->descrip).' - '.strtoupper($data->departamento),
                            "posicion" => $data->posicion
                        );
                        $i++;
					}
				}
				
				if($linSer != false){
					foreach($linSer as $data){
                        $array[$i] = array(
                            "idcatalogo" => $data->idcatalogo,
                            "imagen" => $data->imagen,
                            "descrip" => strtoupper($data->descrip).' - '.strtoupper($data->departamento),
                            "posicion" => $data->posicion
                        );
                        $i++;
					}	
				}
				
				$sortArray = array(); 
                
				foreach($array as $catalog){ 
					foreach($catalog as $key=>$value){ 
						if(!isset($sortArray[$key])){
							$sortArray[$key] = array(); 
						} 
						$sortArray[$key][] = $value; 
					} 
				}
				
				$orderby = "posicion";
                
				array_multisort($sortArray[$orderby], SORT_ASC, SORT_NUMERIC, $array); 
				
				echo json_encode($array);
			}
		}
		
		function getListadoLineasVentaSimpleAlfabeticamente(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $vnLineas = $this->input->post('vnLineas');

				$opcion = $this->session->userdata('opcionmenu');
				$this->load->model('invtran_model');
                $this->load->model('global_model');

                $sMateriaP = $this->global_model->getValorNumVariable('pos_searchmp');

                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
				
				$lineas = $this->invtran_model->getGruposInventario($idcentro, $sMateriaP, $vnLineas);
				$linSer = $this->invtran_model->getGruposServicios(4, $idcentro, $vnLineas);
				
				$i=0;
				$array = array();
				if($lineas != false){
					foreach($lineas as $data){
                        $array[$i] = array(
                            "idcatalogo" => $data->idcatalogo,
                            "imagen" => $data->imagen,
                            "descrip" => strtoupper($data->descrip).' - '.strtoupper($data->departamento),
                            "posicion" => $data->posicion
                        );
                        $i++;
					}
				}
				
				if($linSer != false){
					foreach($linSer as $data){
                        $array[$i] = array(
                            "idcatalogo" => $data->idcatalogo,
                            "imagen" => $data->imagen,
                            "descrip" => strtoupper($data->descrip).' - '.strtoupper($data->departamento),
                            "posicion" => $data->posicion
                        );
                        $i++;
					}	
				}
				
				$sortArray = array(); 
                
				foreach($array as $catalog){ 
					foreach($catalog as $key=>$value){ 
						if(!isset($sortArray[$key])){
							$sortArray[$key] = array(); 
						} 
						$sortArray[$key][] = $value; 
					} 
				}
				
				$orderby = "descrip";
                
				array_multisort($sortArray[$orderby], SORT_ASC, SORT_STRING, $array); 
				
				echo json_encode($array);
			}
		}
		
		function getListadoMarcasVentaSimple(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$opcion = $this->session->userdata('opcionmenu');
				$this->load->model('global_model');
				$this->load->model('ventas_model');
				
                $sMateriaP = $this->global_model->getValorNumVariable('pos_searchmp');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
				
				$informacion = $this->ventas_model->getGruposInventarioMarcas($idcentro, $sMateriaP);
				
				$i=0;
				$array = array();
				if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "descrip" => $info->descrip
                        );
                        $i++;
					}
				}
				
				echo json_encode($array);
			}
		}
		
		function getListadoModelosVentaSimple(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$opcion = $this->session->userdata('opcionmenu');
				$this->load->model('global_model');
				$this->load->model('ventas_model');
				
                $sMateriaP = $this->global_model->getValorNumVariable('pos_searchmp');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
				
				$informacion = $this->ventas_model->getGruposInventarioModelos($idcentro, $sMateriaP);
				
				$i=0;
				$array = array();
				if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "descrip" => $info->descrip
                        );
                        $i++;
					}
				}
				
				echo json_encode($array);
			}
		}
		
		function getListadoServiciosVentaSimple(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$opcion = $this->session->userdata('opcionmenu');
				$this->load->model('invtran_model');
                
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
				
				$informacion = $this->invtran_model->getGruposServicios(4);
				
				$i=0;
				if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "idcatalogo" => $info->idcatalogo,
                            "imagen" => $info->imagen,
                            "descrip" => $info->descrip,
                            "posicion" => $info->posicion
                        );
                        $i++;
					}	
				}
				
				$sortArray = array(); 
                foreach($array as $infoServicios){ 
                    foreach($infoServicios as $key=>$value){ 
						if(!isset($sortArray[$key])){
							$sortArray[$key] = array(); 
						} 
						$sortArray[$key][] = $value; 
					} 
				}
				
				$orderby = "posicion";
                
				array_multisort($sortArray[$orderby], SORT_ASC, SORT_NUMERIC, $array); 
				
				echo json_encode($array);
			}
		}
        
        function getInventarioByCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('invtran_model');
                $detalle = $this->invtran_model->getInventarioByCatalog($idtrannum,$idcatalogo,$idcentro);
                $cantidades = $this->invtran_model->getCantidadesCatalogo($idtrannum, $idcentro);

                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    $datos[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "xpos" => $info->xpos,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "precio" => $info->costounitario,
                        "idbin" => $info->idbin,
                        "idbatch" => $info->idbatch,
                        "precioventa" => $info->precioventa,
                        "idcatalogo" => $info->idcatalogo,
                        "tipotax" => $info->tipotax
                    );
                    $i++;
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i,
                    "sumagrupos" => $cantidades
                );
                echo json_encode($array);
            }
        }
		
		function getInventarioByCatalogPrueba(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                $detalle = $this->invtran_model->getInventarioByCatalog($idtrannum,$idcatalogo,$idcentro);
				$servicios = $this->ventas_model->getListadoProductosServicios($idtrannum,$idcentro,$idcatalogo);
                $cantidades = $this->invtran_model->getCantidadesCatalogo($idtrannum, $idcentro);
				
                $i=0;
                $datos = array();
                foreach($detalle as $info){
					$datos[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
                        "xpos" => $info->xpos,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$i++;
                }
				
				foreach($servicios as $serv){
					$datos[$i] = array(
						"nameproducto" => $serv->descrip,
						"marca" => $serv->marca,
						"modelo" => $serv->modelo,
						"upc" => $serv->barcode,
						"notas" => $serv->notas,
						"idproducto" => $serv->idproducto,
						"tipo" => $serv->tipo,
						"um" => $serv->um,
                        "xpos" => $serv->xpos,
						"imagen" => $serv->imagen,
						"cantidad" => $serv->cantidad,
						"precio" => $serv->costounitario,
						"idbin" => $serv->idbin,
						"idbatch" => $serv->idbatch,
						"precioventa" => $serv->precioventa,
						"idcatalogo" => $serv->idcatalogo,
						"tipotax" => $serv->tipotax
					);
					$i++;
				}
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i,
                    "sumagrupos" => $cantidades
                );
                echo json_encode($array);
            }
        }
		
		function getInventarioByCatalogSimple(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum  = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $postInopera = $this->input->post('inopera');
                $inopera = isset($postInopera) ? $postInopera : 0;
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                $detalle = $this->invtran_model->getInventarioByCatalog($idtrannum,$idcatalogo,$idcentro,$inopera);
				$servicios = $this->ventas_model->getListadoProductosServicios($idtrannum,$idcentro,$idcatalogo);
				
                $i=0;
                $datos = array();
                foreach($detalle as $info){
					$datos[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
                        "upp" => $info->upp,
                        "xpos" => $info->xpos,
						"presenta" => $info->presenta,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$i++;
                }
				
				foreach($servicios as $serv){
					$datos[$i] = array(
						"nameproducto" => $serv->descrip,
						"marca" => $serv->marca,
						"modelo" => $serv->modelo,
						"upc" => $serv->barcode,
						"notas" => $serv->notas,
						"idproducto" => $serv->idproducto,
						"tipo" => $serv->tipo,
                        "upp" => $serv->upp,
                        "xpos" => $serv->xpos,
						"presenta" => $serv->presenta,
						"um" => $serv->um,
						"imagen" => $serv->imagen,
						"cantidad" => $serv->cantidad,
						"precio" => $serv->costounitario,
						"idbin" => $serv->idbin,
						"idbatch" => $serv->idbatch,
						"precioventa" => $serv->precioventa,
						"idcatalogo" => $serv->idcatalogo,
						"tipotax" => $serv->tipotax
					);
					$i++;
				}
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                echo json_encode($array);
            }
        }
		
		function getInventarioByServicioSimple(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('ventas_model');
                $servicios = $this->ventas_model->getInventarioByServicios($idtrannum, $idcentro);
                
                $i=0;
                $datos = array();
                foreach($servicios as $serv){
                    $datos[$i] = array(
                        "nameproducto" => $serv->descrip,
                        "marca" => $serv->marca,
                        "modelo" => $serv->modelo,
                        "upc" => $serv->barcode,
                        "notas" => $serv->notas,
                        "idproducto" => $serv->idproducto,
                        "tipo" => $serv->tipo,
                        "um" => $serv->um,
                        "upp" => $serv->upp,
                        "imagen" => $serv->imagen,
                        "cantidad" => $serv->cantidad,
                        "precio" => $serv->costounitario,
                        "idbin" => $serv->idbin,
                        "idbatch" => $serv->idbatch,
                        "precioventa" => $serv->precioventa,
                        "idcatalogo" => $serv->idcatalogo,
                        "tipotax" => $serv->tipotax
                    );
                    $i++;
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                echo json_encode($array);
            }
        }

        function getCantidadInventarioByServicios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ventas_model');
                $cantidad = $this->ventas_model->getCantidadInventarioByServicios();
                
                $array = array(
                    "cantidad" => $cantidad
                );
                echo json_encode($array);
            }
        }
		
		function getInventarioByMarcaSimple(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $descrip = $this->input->post('descrip');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('ventas_model');
                $informacion = $this->ventas_model->getInventarioByMarcas($idtrannum, $descrip, $idcentro);
				
                $i=0;
                $datos = array();
                foreach($informacion as $info){
					$datos[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
                        "upp" => $info->upp,
                        "xpos" => $info->xpos,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$i++;
                }
				
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                echo json_encode($array);
            }
        }
		
		function getInventarioByModeloSimple(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $descrip = $this->input->post('descrip');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('ventas_model');
                $informacion = $this->ventas_model->getInventarioByModelos($idtrannum, $descrip, $idcentro);
				
                $i=0;
                $datos = array();
                foreach($informacion as $info){
					$datos[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
                        "upp" => $info->upp,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$i++;
                }
				
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                echo json_encode($array);
            }
        }
		
		function getInventarioMasVendidos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('ventas_model');
                $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                
                $k=0;
                $inventario = array();
                foreach($inventariomore as $info){
					$inventario[$k] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
                        "upp" => $info->upp,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$k++;
                } 
				
				$inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
				foreach($inventariomore as $info){
					$inventario[$k] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
                        "upp" => $info->upp,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$k++;
                }
				
                $array = array(
                    "datos" => $inventario,
                    "cantidad" => $k
				);
                echo json_encode($array);
            }
        }
        
        function getDescuentosCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDescuentosProductos($idcatalogo);
                echo json_encode($array);
            }
        }
		
		function getDescuentosDisponiblesProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $idproducto = $this->input->post('idproducto');
                $this->load->model('ventas_model');
                
				$precio = 1;
				$promociones = $this->ventas_model->getPrecioPromocion($idproducto);
				$datos_des = $promociones;
				if($promociones == false){
					$descuento = $this->ventas_model->getDescuentoFichaProducto($idproducto);
					$datos_des = $descuento;
					$precio = 0;
					if($descuento == false){
						$descatalog = $this->ventas_model->getDescuentosProductos($idcatalogo);
						$datos_des = $descatalog;
						$precio = 0;
					}
				}
				
				$array = array(
					"precio" => $precio,
					"descuentos" => $datos_des
				);
				
				echo json_encode($array);
            }
        }
		
		function getDescuentosDisponiblesProducto2(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcps = $this->input->post('idcliente');
                $idcatalogo = $this->input->post('idcatalogo');
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('ventas_model');
                
				$precio = 1; $uniconv = 0; $precliente = 1;
                $desproducto = 0; $numeroMaxDesc = 0;
                
                $preciocliente = $this->ventas_model->getPrecioInvProMulti($idproducto, 9, $idcps);
                $uniconv       = $this->ventas_model->getUniconvInvProMulti($idproducto, 9, $idcps);
				$datos_des     = $preciocliente;

				if ( $preciocliente == false ) {
					$precio = 1; $uniconv = 0; $precliente = 0; $desproducto = 0;

					$promociones = $this->ventas_model->getPrecioPromocion($idproducto);
					$uniconv     = $this->ventas_model->getUniconvPrecioPromocion($idproducto);
                    $datos_des   = $promociones;

					if ( $promociones == false ) {
                        $precio = 0; $precliente = 0; $desproducto = 1;

						$descuento      = $this->ventas_model->getDescuentoFichaProducto($idproducto);
						$numeroMaxDesc  = $this->ventas_model->getDescuentoMaximoProducto($idproducto);
						$datos_des      = $descuento;
						
						if ( $descuento == false ) {
							$precio = 0; $precliente = 0; $desproducto = 0;
							
                            $descatalog = $this->ventas_model->getDescuentosProductos($idcatalogo);
							$datos_des  = $descatalog;
						}
					}
				}
				
				$array = array(
					"precio"        => $precio,
					"precliente"    => $precliente,
					"descuentos"    => $datos_des,
					"numeroMaxDesc" => $numeroMaxDesc * 1,
                    "uniconv"       => ($uniconv == 0) ? 1 : $uniconv,
                    "desproducto"   => $desproducto
				);
				
				echo json_encode($array);
            }
		}
		
		function getDescuentosDisponiblesOnlyProducto(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
				
                $this->load->model('ventas_model');
                $tipoProducto = $this->ventas_model->getTipoProducto($idproducto);
                $numeroMaxDesc = $this->ventas_model->getDescuentoMaximoProductosVariable("so_descuento");
                $dataDescuentos = $this->ventas_model->getDescuentosProductosByVariable("so_descuento");
                
				$array = array(
					"numeroMaxDesc" => $numeroMaxDesc * 1,
                    "tipoProducto" => $tipoProducto,
                    "dataDescuentos" => $dataDescuentos
				);
				
				echo json_encode($array);
            }
		}
		
		function getSo_Descuentos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ventas_model');
                $dataDescuentos = $this->ventas_model->getDescuentosProductosByVariable("so_descuento");
                
				$array = array(
				    "dataDescuentos" => $dataDescuentos
				);
				
				echo json_encode($array);
            }
		}

        function getDescuentosDisponiblesVariables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $idproducto = $this->input->post('idproducto');
                $idcps = $this->input->post('idcliente');
                $this->load->model('ventas_model');
                
                $precio = 1;
                $precliente = 1;
                $desproducto = 0;
                $preciocliente = $this->ventas_model->getPrecioInvProMulti($idproducto, 9, $idcps);
                $datos_des = $preciocliente;
                if($preciocliente == false){
                    $precio = 1;
                    $precliente = 0;
                    $desproducto = 0;
                    $promociones = $this->ventas_model->getPrecioPromocion($idproducto);
                    $datos_des = $promociones;
                    if($promociones == false){
                        $descuento = $this->ventas_model->getDescuentoFichaProductoVariable($idproducto);
                        $datos_des = $descuento;
                        $precio = 0;
                        $precliente = 0;
                        $desproducto = 1;
                        if($descuento == false){
                            $descatalog = $this->ventas_model->getDescuentosProductosVariable($idcatalogo);
                            $datos_des = $descatalog;
                            $precio = 0;
                            $precliente = 0;
                            $desproducto = 0;
                        }
                    }
                }
                
                $array = array(
                    "precio" => $precio,
                    "precliente" => $precliente,
                    "descuentos" => $datos_des,
                    "desproducto" => $desproducto
                );
                
                echo json_encode($array);
            }
        }
        
        function getEncargadoCentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getEncargadoCentro($idcentro);
                echo json_encode($array);
            }
        }
        
        function getEncargadoCentroFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $iduser = $this->session->userdata('iduser');

                $this->load->model('ventas_model');
                $array = $this->ventas_model->getEncargadoCentroFacturacion($iduser);
                
                echo json_encode($array);
            }
        }
		
		function updateEstatusTran100p(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('trannum');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->updateEstadoTran100p($idtrannum);
                echo json_encode($array);
            }
		}
		
		function updateMotivoEstatusPrint(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('trannum');
                $motivoPrint = $this->input->post('motivoPrint');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->updateEstadoMotivoTran100p($idtrannum, $motivoPrint);
                echo json_encode($array);
            }
		}
        
        function agregarProductoFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $idworker = $this->input->post('idworker');
                $idclase = $this->input->post('idclase');
                $descuento = $this->input->post('descuento');
                $notas = trim($this->input->post('notas'));
                
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->ventas_model->insertarProductoVenta($idproducto,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn);
                $this->invtran_model->deleteVenta100c($trannum);

                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                $cantidades = $this->invtran_model->getCantidadesCatalogo($trannum, $idcentro);
                //$servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
				
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "presenta" => $info->presenta,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "xpos" => $info->xpos,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "precio" => $info->costounitario,
                        "idbin" => $info->idbin,
                        "idbatch" => $info->idbatch,
                        "precioventa" => $info->precioventa,
                        "tipotax" => $info->tipotax
                    );
                    $i++;
                }
                /*
				foreach($servicios as $serv){
					$items[$i] = array(
						"nameproducto" => $serv->descrip,
						"marca" => $serv->marca,
						"modelo" => $serv->modelo,
						"upc" => $serv->barcode,
						"notas" => $serv->notas,
						"idproducto" => $serv->idproducto,
						"tipo" => $serv->tipo,
						"um" => $serv->um,
						"imagen" => $serv->imagen,
						"cantidad" => $serv->cantidad,
						"precio" => $serv->costounitario,
						"idbin" => $serv->idbin,
						"idbatch" => $serv->idbatch,
						"precioventa" => $serv->precioventa,
						"idcatalogo" => $serv->idcatalogo,
						"tipotax" => $serv->tipotax
					);
					$i++;
				}*/
                
				$total = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i,
                    "total" => $total,
                    "sumagrupos" => $cantidades
                );
                
                echo json_encode($array);
            }
        }
		
		function agregarProductoFacturacionPrueba(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $idworker = $this->input->post('idworker');
                $idclase = $this->input->post('idclase');
                $descuento = $this->input->post('descuento');
                $notas = trim($this->input->post('notas'));
                
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->ventas_model->insertarProductoVentaPrueba($idproducto,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn);
                $this->invtran_model->deleteVenta100c($trannum);

                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                $cantidades = $this->invtran_model->getCantidadesCatalogo($trannum, $idcentro);
				$servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
					$items[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
                        "xpos" => $info->xpos,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$i++;
                }
				
				foreach($servicios as $serv){
					$items[$i] = array(
						"nameproducto" => $serv->descrip,
						"marca" => $serv->marca,
						"modelo" => $serv->modelo,
						"upc" => $serv->barcode,
						"notas" => $serv->notas,
						"idproducto" => $serv->idproducto,
						"tipo" => $serv->tipo,
						"um" => $serv->um,
                        "xpos" => $serv->xpos,
						"imagen" => $serv->imagen,
						"cantidad" => $serv->cantidad,
						"precio" => $serv->costounitario,
						"idbin" => $serv->idbin,
						"idbatch" => $serv->idbatch,
						"precioventa" => $serv->precioventa,
						"idcatalogo" => $serv->idcatalogo,
						"tipotax" => $serv->tipotax
					);
					$i++;
				}
                
                $total = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                }
                
				$inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                $k=0;
                $inventario = array();
                foreach($inventariomore as $info){
					$inventario[$k] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$k++;
                }
				
				$inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
				foreach($inventariomore as $info){
					$inventario[$k] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$k++;
                }
				
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i,
                    "total" => $total,
                    "sumagrupos" => $cantidades,
					"inventario" => $inventario
                );
                
                echo json_encode($array);
			}
		}
		
		function agregarProductoFacturacionSimple(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $idworker = $this->input->post('idworker');
                $idclase = $this->input->post('idclase');
                $descuento = $this->input->post('descuento');
                $notas = trim($this->input->post('notas'));
                
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->ventas_model->insertarProductoVentaPrueba($idproducto,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn);
                $this->ventas_model->deleteVenta100c($trannum);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
					$items[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
                        "xpos" => $info->xpos,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$i++;
                }
				
				foreach($servicios as $serv){
					$items[$i] = array(
						"nameproducto" => $serv->descrip,
						"marca" => $serv->marca,
						"modelo" => $serv->modelo,
						"upc" => $serv->barcode,
						"notas" => $serv->notas,
						"idproducto" => $serv->idproducto,
						"tipo" => $serv->tipo,
						"um" => $serv->um,
                        "xpos" => $serv->xpos,
						"imagen" => $serv->imagen,
						"cantidad" => $serv->cantidad,
						"precio" => $serv->costounitario,
						"idbin" => $serv->idbin,
						"idbatch" => $serv->idbatch,
						"precioventa" => $serv->precioventa,
						"idcatalogo" => $serv->idcatalogo,
						"tipotax" => $serv->tipotax
					);
					$i++;
				}
                
                $total = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                }
                
				$array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i,
                    "total" => $total
                );
                
                echo json_encode($array);
			}
		}
        
        function agregarProductoFacturacionSimpleCambios(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
                $filtrodatos = $this->input->post('filtrodatos');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $idworker = $this->input->post('idworker');
                $idclase = $this->input->post('idclase');
                $descuento = $this->input->post('descuento');
                $notas = trim($this->input->post('notas'));
                
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->ventas_model->insertarProductoVentaPrueba($idproducto,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn);
                $this->ventas_model->deleteVenta100c($trannum);
                
                if($filtrodatos == 1){
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 2){
                    $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 3){
                    $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 4){
                    $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    } 
                    
                    $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }else if($filtrodatos == 5){
                    $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "xpos" => $serv->xpos,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                #$datos = $this->invtran_model->getDataTran100k($trannum);
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                #$cantidad = $this->invtran_model->getCantidad100k($trannum);
                #$unidades = $this->invtran_model->getUnidades100k($trannum);
                
                if($filtrodatos == 1){
                    $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                }
                
                if($filtrodatos != 4 && $filtrodatos != 5){
                    $i=0;
                    $items = array();
                    foreach($detalle as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }
                
				if($filtrodatos == 1){
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "xpos" => $serv->xpos,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
                
				$array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i,
                    "total" => $total
                );
                
                echo json_encode($array);
			}
		}

        function getDatosVentaFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }

                $postInopera = $this->input->post('inopera');
                $inopera = isset($postInopera) ? $postInopera : 0;

                $this->load->model('invtran_model');
                $array = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro, $inopera);
                echo json_encode($array);
            }
        }

        function agregarProductoFacturacionChangeUM(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r","\"", "'");
                $reemplazar = array("", "", "", "","","");

                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
                $filtrodatos = $this->input->post('filtrodatos');
                $uniconv = $this->input->post('uniconv');
                $barcodePro = $this->input->post('barcodePro');
                $ncatalog = is_null($this->input->post('ncatalog')) ? 0 : $this->input->post('ncatalog');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $idworker = $this->input->post('idworker');
                $idclase = $this->input->post('idclase');
                $descuento = $this->input->post('descuento');
                $notas = trim($this->input->post('notas'));
                $notas = str_replace($buscar, $reemplazar, $notas);

                $postInopera = $this->input->post('inopera');
                $inopera = isset($postInopera) ? $postInopera : 0;

                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->ventas_model->insertarProductoVentaUM($idproducto,$uniconv,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn,$barcodePro);
                $this->ventas_model->deleteVenta100c($trannum);
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro, $inopera);

                if ($ncatalog == 0) {
                    if($filtrodatos == 1){
                        $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro, $inopera);
                    }else if($filtrodatos == 2){
                        $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                    }else if($filtrodatos == 3){
                        $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                    }else if($filtrodatos == 4){
                        $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                        
                        $i=0;
                        $items = array();
                        foreach($inventariomore as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "upp" => $info->upp,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        } 
                        
                        $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                        foreach($inventariomore as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "upp" => $info->upp,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        }
                    }else if($filtrodatos == 5){
                        $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                        
                        $i=0;
                        $items = array();
                        foreach($servicios as $serv){
                            $items[$i] = array(
                                "nameproducto" => $serv->descrip,
                                "marca" => $serv->marca,
                                "modelo" => $serv->modelo,
                                "upc" => $serv->barcode,
                                "presenta" => $serv->presenta,
                                "notas" => $serv->notas,
                                "idproducto" => $serv->idproducto,
                                "tipo" => $serv->tipo,
                                "upp" => $serv->upp,
                                "um" => $serv->um,
                                "xpos" => $serv->xpos,
                                "imagen" => $serv->imagen,
                                "cantidad" => $serv->cantidad,
                                "precio" => $serv->costounitario,
                                "idbin" => $serv->idbin,
                                "idbatch" => $serv->idbatch,
                                "precioventa" => $serv->precioventa,
                                "idcatalogo" => $serv->idcatalogo,
                                "tipotax" => $serv->tipotax
                            );
                            $i++;
                        }
                    }
                    
                    if($filtrodatos == 1){
                        $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                    }
                    
                    if($filtrodatos != 4 && $filtrodatos != 5){
                        $i=0;
                        $items = array();
                        foreach($detalle as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "upp" => $info->upp,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        }
                    }
                    
                    if($filtrodatos == 1){
                        foreach($servicios as $serv){
                            $items[$i] = array(
                                "nameproducto" => $serv->descrip,
                                "marca" => $serv->marca,
                                "modelo" => $serv->modelo,
                                "upc" => $serv->barcode,
                                "presenta" => $serv->presenta,
                                "notas" => $serv->notas,
                                "idproducto" => $serv->idproducto,
                                "tipo" => $serv->tipo,
                                "um" => $serv->um,
                                "upp" => $serv->upp,
                                "xpos" => $serv->xpos,
                                "imagen" => $serv->imagen,
                                "cantidad" => $serv->cantidad,
                                "precio" => $serv->costounitario,
                                "idbin" => $serv->idbin,
                                "idbatch" => $serv->idbatch,
                                "precioventa" => $serv->precioventa,
                                "idcatalogo" => $serv->idcatalogo,
                                "tipotax" => $serv->tipotax
                            );
                            $i++;
                        }
                    }
                } else {
                    $i=0; $items = array();
                }
                
                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i,
                    "total" => $total
                );
                
                echo json_encode($array);
            }
        }
        
        function updateVenta100kSimple(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r","\"", "'");
                $reemplazar = array("", "", "", "","","");

                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $trannum = $this->input->post('idtrannum');

                $notas = trim($this->input->post('notas'));
                $notas = str_replace($buscar, $reemplazar, $notas);

                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
				$filtrodatos = $this->input->post('filtrodatos');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $precio = $this->input->post('precio');
                $descuento = $this->input->post('descuento');
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                $this->invtran_model->actualizarVenta100k($idrec, $trannum, $cantidad, $precio, $descuento, $notas, $tipotax, $pro_vende,$modevn);
                $this->ventas_model->deleteVenta100c($trannum);
                
                if($filtrodatos == 1){
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 2){
                    $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 3){
                    $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 4){
                    $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    } 
                    
                    $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }else if($filtrodatos == 5){
                    $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "xpos" => $serv->xpos,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                #$datos = $this->invtran_model->getDataTran100k($trannum);
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                #$cantidad = $this->invtran_model->getCantidad100k($trannum);
                #$unidades = $this->invtran_model->getUnidades100k($trannum);
                                
                if($filtrodatos == 1){
                    $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                }
                
                if($filtrodatos != 4 && $filtrodatos != 5){
                    $i=0;
                    $items = array();
                    foreach($detalle as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }
                
				if($filtrodatos == 1){
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "xpos" => $serv->xpos,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
				
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i,
                    "total" => $total
                );
                                
                echo json_encode($array);    
            }
		}

        function updateVentaUM(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r","\"", "'");
                $reemplazar = array("", "", "", "","","");

                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad'); 
                $idcatalogo = $this->input->post('idcatalogo');
                $trannum = $this->input->post('idtrannum');

                $notas = trim($this->input->post('notas'));
                $notas = str_replace($buscar, $reemplazar, $notas);

                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
                $filtrodatos = $this->input->post('filtrodatos');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $ncatalog = is_null($this->input->post('ncatalog')) ? 0 : $this->input->post('ncatalog');

                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }

                $postInopera = $this->input->post('inopera');
                $inopera = isset($postInopera) ? $postInopera : 0;
                
                $precio = $this->input->post('precio');
                $descuento = $this->input->post('descuento');
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                $this->ventas_model->actualizarVentaUM($idrec, $um, $uniconv, $trannum, $cantidad, $precio, $descuento, $notas, $tipotax, $pro_vende,$modevn);
                $this->ventas_model->deleteVenta100c($trannum);
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro, $inopera);
                
                if ($ncatalog == 0) {
                    if($filtrodatos == 1){
                        $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro, $inopera);
                    }else if($filtrodatos == 2){
                        $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                    }else if($filtrodatos == 3){
                        $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                    }else if($filtrodatos == 4){
                        $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                        
                        $i=0;
                        $items = array();
                        foreach($inventariomore as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "upp" => $info->upp,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        } 
                        
                        $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                        foreach($inventariomore as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "um" => $info->um,
                                "upp" => $info->upp,
                                "xpos" => $info->xpos,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        }
                    }else if($filtrodatos == 5){
                        $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                        
                        $i=0;
                        $items = array();
                        foreach($servicios as $serv){
                            $items[$i] = array(
                                "nameproducto" => $serv->descrip,
                                "marca" => $serv->marca,
                                "modelo" => $serv->modelo,
                                "upc" => $serv->barcode,
                                "presenta" => $serv->presenta,
                                "notas" => $serv->notas,
                                "idproducto" => $serv->idproducto,
                                "tipo" => $serv->tipo,
                                "um" => $serv->um,
                                "upp" => $serv->upp,
                                "xpos" => $serv->xpos,
                                "imagen" => $serv->imagen,
                                "cantidad" => $serv->cantidad,
                                "precio" => $serv->costounitario,
                                "idbin" => $serv->idbin,
                                "idbatch" => $serv->idbatch,
                                "precioventa" => $serv->precioventa,
                                "idcatalogo" => $serv->idcatalogo,
                                "tipotax" => $serv->tipotax
                            );
                            $i++;
                        }
                    }
                    
                    if($filtrodatos == 1){
                        $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                    }
                    
                    if($filtrodatos != 4 && $filtrodatos != 5){
                        $i=0;
                        $items = array();
                        foreach($detalle as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "um" => $info->um,
                                "upp" => $info->upp,
                                "xpos" => $info->xpos,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        }
                    }
                    
                    if($filtrodatos == 1){
                        foreach($servicios as $serv){
                            $items[$i] = array(
                                "nameproducto" => $serv->descrip,
                                "marca" => $serv->marca,
                                "modelo" => $serv->modelo,
                                "upc" => $serv->barcode,
                                "presenta" => $serv->presenta,
                                "notas" => $serv->notas,
                                "idproducto" => $serv->idproducto,
                                "tipo" => $serv->tipo,
                                "um" => $serv->um,
                                "upp" => $serv->upp,
                                "xpos" => $serv->xpos,
                                "imagen" => $serv->imagen,
                                "cantidad" => $serv->cantidad,
                                "precio" => $serv->costounitario,
                                "idbin" => $serv->idbin,
                                "idbatch" => $serv->idbatch,
                                "precioventa" => $serv->precioventa,
                                "idcatalogo" => $serv->idcatalogo,
                                "tipotax" => $serv->tipotax
                            );
                            $i++;
                        }
                    }
                } else {
                    $i=0; $items = array();
                }
                
                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i,
                    "total" => $total
                );
                                
                echo json_encode($array);    
            }
        }
        
        function deleteRegistroVentaSimple(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $filtrodatos = $this->input->post('filtrodatos');
                $ncatalog = is_null($this->input->post('ncatalog')) ? 0 : $this->input->post('ncatalog');
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }

                $postInopera = $this->input->post('inopera');
                $inopera = isset($postInopera) ? $postInopera : 0;
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                $this->invtran_model->deleteDataTran100k($idrec);
                $this->invtran_model->deleteVenta100c($trannum);
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro, $inopera);

                if ($ncatalog == 0) {
                    if($filtrodatos == 1){
                        $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro, $inopera);
                    }else if($filtrodatos == 2){
                        $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                    }else if($filtrodatos == 3){
                        $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                    }else if($filtrodatos == 4){
                        $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                        
                        $i=0;
                        $items = array();
                        foreach($inventariomore as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "upp" => $info->upp,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        } 
                        
                        $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                        foreach($inventariomore as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "upp" => $info->upp,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        }
                    }else if($filtrodatos == 5){
                        $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                        
                        $i=0;
                        $items = array();
                        foreach($servicios as $serv){
                            $items[$i] = array(
                                "nameproducto" => $serv->descrip,
                                "marca" => $serv->marca,
                                "modelo" => $serv->modelo,
                                "upc" => $serv->barcode,
                                "presenta" => $serv->presenta,
                                "notas" => $serv->notas,
                                "idproducto" => $serv->idproducto,
                                "tipo" => $serv->tipo,
                                "um" => $serv->um,
                                "xpos" => $serv->xpos,
                                "upp" => $serv->upp,
                                "imagen" => $serv->imagen,
                                "cantidad" => $serv->cantidad,
                                "precio" => $serv->costounitario,
                                "idbin" => $serv->idbin,
                                "idbatch" => $serv->idbatch,
                                "precioventa" => $serv->precioventa,
                                "idcatalogo" => $serv->idcatalogo,
                                "tipotax" => $serv->tipotax
                            );
                            $i++;
                        }
                    }
                    
                    if($filtrodatos == 1){
                        $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                    }
                    
                    if($filtrodatos != 4 && $filtrodatos != 5){
                        $i=0;
                        $items = array();
                        foreach($detalle as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "upp" => $info->upp,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        }
                    }
                    
                    if($filtrodatos == 1){
                        foreach($servicios as $serv){
                            $items[$i] = array(
                                "nameproducto" => $serv->descrip,
                                "marca" => $serv->marca,
                                "modelo" => $serv->modelo,
                                "upc" => $serv->barcode,
                                "presenta" => $serv->presenta,
                                "notas" => $serv->notas,
                                "idproducto" => $serv->idproducto,
                                "tipo" => $serv->tipo,
                                "um" => $serv->um,
                                "upp" => $serv->upp,
                                "xpos" => $serv->xpos,
                                "imagen" => $serv->imagen,
                                "cantidad" => $serv->cantidad,
                                "precio" => $serv->costounitario,
                                "idbin" => $serv->idbin,
                                "idbatch" => $serv->idbatch,
                                "precioventa" => $serv->precioventa,
                                "idcatalogo" => $serv->idcatalogo,
                                "tipotax" => $serv->tipotax
                            );
                            $i++;
                        }
                    }
                } else  { 
                    $i=0; $items = array();
                }

                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
				
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }
        }
        
        function getDatosSearch(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                $trannum = $this->input->post('idtrannum');

                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $detalle = $this->ventas_model->getDatosProductoSearch($prosearch, $dato, $idcentro, $trannum);
                if($detalle != 0){
                    $i=0;
					$agregado=0;
                    $items = array();
                    foreach($detalle as $info){
						if($info->existe == "0"){
							$items[$i] = array(
								"nameproducto" => $info->descrip,
								"marca" => $info->marca,
								"modelo" => $info->modelo,
								"presenta" => $info->presenta,
								"upc" => $info->barcode,
								"notas" => $info->notas,
								"idproducto" => $info->idproducto,
								"um" => $info->um,
                                "upp" => $info->upp,
                                "tipo" => $info->tipo,
								"imagen" => $info->imagen,
								"cantidad" => $info->cantidad,
								"precio" => $info->costounitario,
								"idbin" => $info->idbin,
								"idbatch" => $info->idbatch,
								"namecatalogo" => $info->namecatalogo,
								"precioventa" => $info->precioventa,
								"idcatalogo" => $info->idcatalogo,
								"tipotax" => $info->tipotax,
								"agregado" => 0
							);
							$i++;
						}else{
							$items[$i] = array(
								"nameproducto" => $info->descrip,
								"marca" => $info->marca,
								"modelo" => $info->modelo,
								"presenta" => $info->presenta,
								"upc" => $info->barcode,
								"notas" => $info->notas,
								"idproducto" => $info->idproducto,
								"um" => $info->um,
                                "upp" => $info->upp,
                                "tipo" => $info->tipo,
								"imagen" => $info->imagen,
								"cantidad" => $info->cantidad,
								"precio" => $info->costounitario,
								"idbin" => $info->idbin,
								"idbatch" => $info->idbatch,
								"namecatalogo" => $info->namecatalogo,
								"precioventa" => $info->precioventa,
								"idcatalogo" => $info->idcatalogo,
								"tipotax" => $info->tipotax,
								"agregado" => 1
							);
							$i++;
							$agregado = 1;
						}
                    }
                    if($agregado == 1 && $i == 1){
                        $datos = $this->invtran_model->getDataProductoVentaTran100k($trannum, $info->idproducto);
                        $array = array(
                            "error" => "2",
                            "datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
        }

        function getDatosSearchGrupo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $nGrupo   = $this->input->post('nGrupo');
                $opcion   = $this->session->userdata('opcionmenu');
                $idcentro = ($opcion == 1) ? $this->session->userdata('idcentroTemp') : $this->session->userdata('idcentrouser');
                $trannum  = $this->input->post('idtrannum');

                $this->load->model('ventas_model');
                $array = $this->ventas_model->getSearchProductoGrupo($nGrupo);

                echo json_encode($array);
            }
        }

        function getPrecioGrupo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $nGrupo = $this->input->post('nGrupo');
                $nCantidad = $this->input->post('nCantidad');

                $this->load->model('ventas_model');
                $array = $this->ventas_model->getPrecioGrupo($nGrupo, $nCantidad);

                echo json_encode($array);
            }
        }

        function getProductosGrupo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $nGrupo    = $this->input->post('nGrupo');
                $nMarca    = $this->input->post('nMarca');
                $nPresenta = $this->input->post('nPresenta');
                $opcion    = $this->session->userdata('opcionmenu');
                $idcentro  = ($opcion == 1) ? $this->session->userdata('idcentroTemp') : $this->session->userdata('idcentrouser');
                $trannum   = $this->input->post('trannum');

                $this->load->model('ventas_model');
                $array = $this->ventas_model->getProductosGrupo($nMarca, $nPresenta, $idcentro, $trannum);

                echo json_encode($array);
            }
        }
        
        /*
        function getDatosSearchFacturaz(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                $trannum = $this->input->post('idtrannum');

                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $detalle = $this->ventas_model->getDatosProductoSearchFacturaz($prosearch, $dato, $idcentro, $trannum);
                if($detalle != 0){
                    $i=0;
					$agregado=0;
                    $items = array();
                    foreach($detalle as $info){
						if($info->existe == "0"){
							$items[$i] = array(
								"nameproducto" => $info->descrip,
								"marca" => $info->marca,
								"modelo" => $info->modelo,
								"upc" => $info->barcode,
								"notas" => $info->notas,
								"idproducto" => $info->idproducto,
								"um" => $info->um,
                                "upp" => $info->upp,
                                "tipo" => $info->tipo,
								"imagen" => $info->imagen,
								"cantidad" => $info->cantidad,
								"precio" => $info->costounitario,
								"idbin" => $info->idbin,
								"idbatch" => $info->idbatch,
								"namecatalogo" => $info->namecatalogo,
								"precioventa" => $info->precioventa,
								"idcatalogo" => $info->idcatalogo,
								"tipotax" => $info->tipotax,
								"agregado" => 0
							);
							$i++;
						}else{
							$items[$i] = array(
								"nameproducto" => $info->descrip,
								"marca" => $info->marca,
								"modelo" => $info->modelo,
								"upc" => $info->barcode,
								"notas" => $info->notas,
								"idproducto" => $info->idproducto,
								"um" => $info->um,
                                "upp" => $info->upp,
                                "tipo" => $info->tipo,
								"imagen" => $info->imagen,
								"cantidad" => $info->cantidad,
								"precio" => $info->costounitario,
								"idbin" => $info->idbin,
								"idbatch" => $info->idbatch,
								"namecatalogo" => $info->namecatalogo,
								"precioventa" => $info->precioventa,
								"idcatalogo" => $info->idcatalogo,
								"tipotax" => $info->tipotax,
								"agregado" => 1
							);
							$i++;
							$agregado = 1;
						}
                    }
                    if($agregado == 1 && $i == 1){
                        $datos = $this->invtran_model->getDataProductoVentaTran100k($trannum, $info->idproducto);
                        $array = array(
                            "error" => "2",
                            "datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
        }
        */
        //SEARCH WITH SERVICES 2020-08-21
        
        function getDatosSearchFacturaz(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum   = $this->input->post('idtrannum');
                $prosearch = $this->input->post('prosearch');
                $dato      = $this->input->post('dato');
                $opcion    = $this->session->userdata('opcionmenu');
                $idcentro  = $opcion == 1 ? $this->session->userdata('idcentroTemp') : $this->session->userdata('idcentrouser');
                $postInopera = $this->input->post('inopera');
                $inopera = isset($postInopera) ? $postInopera : 0;

                $this->load->model('global_model');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                
                $sMateriaP = $this->global_model->getValorNumVariable('pos_searchmp');
                $infoProductos = $this->ventas_model->getDatosProductoSearchFacturaz($prosearch, $dato, $idcentro, $trannum, $sMateriaP, $inopera);
                $infoServicios = $this->ventas_model->getDatosServicioSearchFacturaz($prosearch, $dato, $idcentro, $trannum);

                $i=0; $agregado=0;
                $items = array();

                if($infoProductos != 0){
                    foreach($infoProductos as $infoPT){
						if($infoPT->existe == "0"){
							$items[$i] = array(
								"nameproducto" => $infoPT->descrip,
								"marca" => $infoPT->marca,
								"modelo" => $infoPT->modelo,
								"upc" => $infoPT->barcode,
								"notas" => $infoPT->notas,
								"idproducto" => $infoPT->idproducto,
								"um" => $infoPT->um,
								"presenta" => $infoPT->presenta,
                                "upp" => $infoPT->upp,
                                "xpos" => $infoPT->xpos,
                                "tipo" => $infoPT->tipo,
								"imagen" => $infoPT->imagen,
								"cantidad" => $infoPT->cantidad,
								"precio" => $infoPT->costounitario,
								"idbin" => $infoPT->idbin,
								"idbatch" => $infoPT->idbatch,
								"namecatalogo" => $infoPT->namecatalogo,
								"precioventa" => $infoPT->precioventa,
								"idcatalogo" => $infoPT->idcatalogo,
								"tipotax" => $infoPT->tipotax,
								"agregado" => 0
							);
							$i++;
						}else{
							$items[$i] = array(
								"nameproducto" => $infoPT->descrip,
								"marca" => $infoPT->marca,
								"modelo" => $infoPT->modelo,
								"upc" => $infoPT->barcode,
								"notas" => $infoPT->notas,
								"idproducto" => $infoPT->idproducto,
								"um" => $infoPT->um,
								"presenta" => $infoPT->presenta,
                                "upp" => $infoPT->upp,
                                "xpos" => $infoPT->xpos,
                                "tipo" => $infoPT->tipo,
								"imagen" => $infoPT->imagen,
								"cantidad" => $infoPT->cantidad,
								"precio" => $infoPT->costounitario,
								"idbin" => $infoPT->idbin,
								"idbatch" => $infoPT->idbatch,
								"namecatalogo" => $infoPT->namecatalogo,
								"precioventa" => $infoPT->precioventa,
								"idcatalogo" => $infoPT->idcatalogo,
								"tipotax" => $infoPT->tipotax,
								"agregado" => 1
							);
							$i++;
							$agregado = 1;
						}
                    }

                    if($infoServicios != 0){
                        foreach($infoServicios as $infoSV){
                            if($infoSV->existe == "0"){
                                $items[$i] = array(
                                    "nameproducto" => $infoSV->descrip,
                                    "marca" => $infoSV->marca,
                                    "modelo" => $infoSV->modelo,
                                    "upc" => $infoSV->barcode,
                                    "notas" => $infoSV->notas,
                                    "idproducto" => $infoSV->idproducto,
                                    "um" => $infoSV->um,
                                    "presenta" => $infoSV->presenta,
                                    "upp" => $infoSV->upp,
                                    "xpos" => $infoSV->xpos,
                                    "tipo" => $infoSV->tipo,
                                    "imagen" => $infoSV->imagen,
                                    "cantidad" => $infoSV->cantidad,
                                    "precio" => $infoSV->costounitario,
                                    "idbin" => $infoSV->idbin,
                                    "idbatch" => $infoSV->idbatch,
                                    "namecatalogo" => $infoSV->namecatalogo,
                                    "precioventa" => $infoSV->precioventa,
                                    "idcatalogo" => $infoSV->idcatalogo,
                                    "tipotax" => $infoSV->tipotax,
                                    "agregado" => 0
                                );
                                $i++;
                            }else{
                                $items[$i] = array(
                                    "nameproducto" => $infoSV->descrip,
                                    "marca" => $infoSV->marca,
                                    "modelo" => $infoSV->modelo,
                                    "upc" => $infoSV->barcode,
                                    "notas" => $infoSV->notas,
                                    "idproducto" => $infoSV->idproducto,
                                    "um" => $infoSV->um,
                                    "presenta" => $infoSV->presenta,
                                    "upp" => $infoSV->upp,
                                    "xpos" => $infoSV->xpos,
                                    "tipo" => $infoSV->tipo,
                                    "imagen" => $infoSV->imagen,
                                    "cantidad" => $infoSV->cantidad,
                                    "precio" => $infoSV->costounitario,
                                    "idbin" => $infoSV->idbin,
                                    "idbatch" => $infoSV->idbatch,
                                    "namecatalogo" => $infoSV->namecatalogo,
                                    "precioventa" => $infoSV->precioventa,
                                    "idcatalogo" => $infoSV->idcatalogo,
                                    "tipotax" => $infoSV->tipotax,
                                    "agregado" => 1
                                );
                                $i++;
                                $agregado = 1;
                            }
                        }

                        $array = array("error" => "0", "cantidad" => $i, "datos" => $items);
                    }else{
                        if($agregado == 1 && $i == 1){
                            $datos = $this->invtran_model->getDataProductoVentaTran100k($trannum, $infoPT->idproducto);
                            $array = array("error" => "2", "datos" => $datos);
                        }else{
                            $array = array("error" => "0", "cantidad" => $i, "datos" => $items);
                        }
                    }
                }else{
                    if($infoServicios != 0){
                        foreach($infoServicios as $infoSV){
                            if($infoSV->existe == "0"){
                                $items[$i] = array(
                                    "nameproducto" => $infoSV->descrip,
                                    "marca" => $infoSV->marca,
                                    "modelo" => $infoSV->modelo,
                                    "upc" => $infoSV->barcode,
                                    "notas" => $infoSV->notas,
                                    "idproducto" => $infoSV->idproducto,
                                    "um" => $infoSV->um,
                                    "presenta" => $infoSV->presenta,
                                    "upp" => $infoSV->upp,
                                    "xpos" => $infoSV->xpos,
                                    "tipo" => $infoSV->tipo,
                                    "imagen" => $infoSV->imagen,
                                    "cantidad" => $infoSV->cantidad,
                                    "precio" => $infoSV->costounitario,
                                    "idbin" => $infoSV->idbin,
                                    "idbatch" => $infoSV->idbatch,
                                    "namecatalogo" => $infoSV->namecatalogo,
                                    "precioventa" => $infoSV->precioventa,
                                    "idcatalogo" => $infoSV->idcatalogo,
                                    "tipotax" => $infoSV->tipotax,
                                    "agregado" => 0
                                );
                                $i++;
                            }else{
                                $items[$i] = array(
                                    "nameproducto" => $infoSV->descrip,
                                    "marca" => $infoSV->marca,
                                    "modelo" => $infoSV->modelo,
                                    "upc" => $infoSV->barcode,
                                    "notas" => $infoSV->notas,
                                    "idproducto" => $infoSV->idproducto,
                                    "um" => $infoSV->um,
                                    "presenta" => $infoSV->presenta,
                                    "upp" => $infoSV->upp,
                                    "xpos" => $infoSV->xpos,
                                    "tipo" => $infoSV->tipo,
                                    "imagen" => $infoSV->imagen,
                                    "cantidad" => $infoSV->cantidad,
                                    "precio" => $infoSV->costounitario,
                                    "idbin" => $infoSV->idbin,
                                    "idbatch" => $infoSV->idbatch,
                                    "namecatalogo" => $infoSV->namecatalogo,
                                    "precioventa" => $infoSV->precioventa,
                                    "idcatalogo" => $infoSV->idcatalogo,
                                    "tipotax" => $infoSV->tipotax,
                                    "agregado" => 1
                                );
                                $i++;
                                $agregado = 1;
                            }
                        }

                        if($agregado == 1 && $i == 1){
                            $datos = $this->invtran_model->getDataProductoVentaTran100k($trannum, $infoSV->idproducto);
                            $array = array("error" => "2", "datos" => $datos);
                        }else{
                            $array = array("error" => "0", "cantidad" => $i, "datos" => $items);
                        }
                    }else{
                        $array = array("error" => "1", "cantidad" => "0");
                    }
                }

                echo json_encode($array);
            }
        }
        

        function getDatosSearchFast(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $dato = $this->input->post('dato');
                $modevn = $this->input->post('modevn');
                $trannum = $this->input->post('trannum');
                $idworker = $this->input->post('idworker');
                $prosearch = $this->input->post('prosearch');
                $pro_vende = $this->input->post('idworker');
                $idcatalogo = $this->input->post('idcatalogo');
                $filtrodatos = $this->input->post('filtrodatos');
                $opcion = $this->session->userdata('opcionmenu');

                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }

                $this->load->model('ventas_model'); $this->load->model('invtran_model');
                $informacion = $this->ventas_model->getDatosProductoSearchFast($prosearch, $dato, $idcentro, $trannum);
                
                $c=0;
                $agregado=0; $sin_error=0; $um_find=0;
                if($informacion != 0){
                    #$datosProductos = array();
                    foreach($informacion as $info){
                        if($info->existe == "0"){
                            $idproducto = $info->idproducto; $uniconv = 1; $cantidad = (($info->nItems == 0) ? 1 : $info->nItems); $descuento = "0%";
                            $precio = $info->precioventa; $idbin = $info->idbin; $idbatch = $info->idbatch;
                            $um = $info->um; $notas = ""; $tipotax = $info->tipotax; $barcodePro = ( $prosearch == 3 ) ? $dato : $info->barcode;
                            
                            $datosProductos[$c] = array(
                                "nameproducto" => $info->descrip,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "tipotax" => $info->tipotax,
                                "upc" => $barcodePro,
                                "agregado" => 0
                            );

                            $c++;
                        }else{
                            $idrec = $info->idrec;
                            $idproducto = $info->idproducto; $uniconv = 1; $cantidad = abs($info->ingresado); $descuento = "0%";
                            $precio = $info->precioventa; $idbin = $info->idbin; $idbatch = $info->idbatch;
                            $um = $info->um; $notas = ""; $tipotax = $info->tipotax; $barcodePro = ( $prosearch == 3 ) ? $dato : $info->barcode;
                            
                            $datosProductos[$c] = array(
                                "nameproducto" => $info->descrip,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "tipotax" => $info->tipotax,
                                "upc" => $barcodePro,
                                "agregado" => 1
                            );

                            $c++;
                            $agregado = 1;
                        }
                    }

                    if($agregado == 1 && $c == 1){
                        #Actualizar Producto Facturación...
                        if($um_find == 0){
                            $cantidad = $cantidad + (($info->nItems == 0) ? 1 : $info->nItems);
                            $this->ventas_model->actualizarVentaUM($idrec,$um,$uniconv,$trannum,$cantidad,$precio,$descuento,$notas,$tipotax,$pro_vende,$modevn);
                            $this->ventas_model->deleteVenta100c($trannum);
                        }else{
                            $cantidad = $cantidad + (($info->nItems == 0) ? 1 : $info->nItems);
                            $this->ventas_model->actualizarVentaUM($idrec,$um,$uniconv,$trannum,$cantidad,$precio,$descuento,$notas,$tipotax,$pro_vende,$modevn);
                            $this->ventas_model->deleteVenta100c($trannum);
                        }
                    }else{
                        if($c == 1 && $um_find == 0){
                            #Agregar Producto Facturación...
                            $this->ventas_model->insertarProductoVentaUM($idproducto,$uniconv,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn,$barcodePro);
                            $this->ventas_model->deleteVenta100c($trannum);
                        }
                    }

                    if($um_find == 0){
                        $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                        
                        $total = 0; $cantidad = 0; $unidades = 0;
                        foreach($datos as $data){
                            $total = $total + $data->precioneto * abs($data->cantidad);
                            $cantidad = $cantidad + abs($data->cantidad);
                            $unidades++;
                        }
                        
                        $array = array(
                            "error" => "2",
                            "datos" => $datos,
                            "cantidad" => $unidades,
                            "unidades" => $cantidad,
                            "total" => $total
                        );

                        echo json_encode($array);
                    }else{
                        $array = array(
                            "error" => "3",
                            "um_find" => $um_find,
                            "infoProducto" => $datosProductos
                        );

                        echo json_encode($array);
                    }
                }else{
                    $array = array("error" => "1");
                    echo json_encode($array);
                }
            }
        }

        function getDatosSearchFastService(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $modevn = $this->input->post('modevn');
                $trannum = $this->input->post('trannum');
                $idworker = $this->input->post('idworker');
                $pro_vende = $this->input->post('idworker');
                $idcatalogo = $this->input->post('idcatalogo');
                $filtrodatos = $this->input->post('filtrodatos');
                $opcion = $this->session->userdata('opcionmenu');

                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }

                $this->load->model('ventas_model'); $this->load->model('invtran_model');
                $informacion = $this->ventas_model->getDatosSearchFastService($idproducto, $idcentro, $trannum);
                
                $c=0;
                $agregado=0; $sin_error=0; $um_find=0;
                if($informacion != 0){
                    #$datosProductos = array();
                    foreach($informacion as $info){
                        if($info->existe == "0"){
                            $idproducto = $info->idproducto; $uniconv = 1; $cantidad = 1; $descuento = "0%";
                            $precio = $info->precioventa; $idbin = $info->idbin; $idbatch = $info->idbatch;
                            $um = $info->um; $notas = ""; $tipotax = $info->tipotax; $barcodePro = $info->barcode;
                            
                            $datosProductos[$c] = array(
                                "nameproducto" => $info->descrip,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "tipotax" => $info->tipotax,
                                "upc" => $barcodePro,
                                "agregado" => 0
                            );

                            $c++;
                        }else{
                            $idrec = $info->idrec;
                            $idproducto = $info->idproducto; $uniconv = 1; $cantidad = abs($info->ingresado); $descuento = "0%";
                            $precio = $info->precioventa; $idbin = $info->idbin; $idbatch = $info->idbatch;
                            $um = $info->um; $notas = ""; $tipotax = $info->tipotax; $barcodePro = $info->barcode;
                            
                            $datosProductos[$c] = array(
                                "nameproducto" => $info->descrip,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "tipotax" => $info->tipotax,
                                "upc" => $barcodePro,
                                "agregado" => 1
                            );

                            $c++;
                            $agregado = 1;
                        }
                    }

                    if($agregado == 1 && $c == 1){
                        #Actualizar Producto Facturación...
                        if($um_find == 0){
                            $cantidad = $cantidad + 1;
                            $this->ventas_model->actualizarVentaUM($idrec,$um,$uniconv,$trannum,$cantidad,$precio,$descuento,$notas,$tipotax,$pro_vende,$modevn);
                            $this->ventas_model->deleteVenta100c($trannum);
                        }else{
                            $cantidad = $cantidad + 1;
                            $this->ventas_model->actualizarVentaUM($idrec,$um,$uniconv,$trannum,$cantidad,$precio,$descuento,$notas,$tipotax,$pro_vende,$modevn);
                            $this->ventas_model->deleteVenta100c($trannum);
                        }
                    }else{
                        if($c == 1 && $um_find == 0){
                            #Agregar Producto Facturación...
                            $this->ventas_model->insertarProductoVentaUM($idproducto,$uniconv,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn,$barcodePro);
                            $this->ventas_model->deleteVenta100c($trannum);
                        }
                    }

                    if($um_find == 0){
                        $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                        
                        $total = 0; $cantidad = 0; $unidades = 0;
                        foreach($datos as $data){
                            $total = $total + $data->precioneto * abs($data->cantidad);
                            $cantidad = $cantidad + abs($data->cantidad);
                            $unidades++;
                        }
                        
                        $array = array(
                            "error" => "2",
                            "datos" => $datos,
                            "cantidad" => $unidades,
                            "unidades" => $cantidad,
                            "total" => $total
                        );

                        echo json_encode($array);
                    }else{
                        $array = array(
                            "error" => "3",
                            "um_find" => $um_find,
                            "infoProducto" => $datosProductos
                        );

                        echo json_encode($array);
                    }
                }else{
                    $array = array("error" => "1");
                    echo json_encode($array);
                }
            }
        }

        function getDatosSearchInvpromulti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                $trannum = $this->input->post('idtrannum');

                $this->load->model('ventas_model'); $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $pos_precios = $this->global_model->getValorNumVariable('pos_precios');
                $detalle = $this->ventas_model->getDatosProductoSearch($prosearch, $dato, $idcentro, $trannum);
                
                if($detalle != 0){
                    $i=0; $k=0; $agregado=0;
                    $items = array(); $itemsMultiplePrecio = array();
                    
                    foreach($detalle as $info){
                        $itemsMultiplePrecio[$k] = array(
                            "id" => $info->precioventa * 1,
                            "descrip" => $info->precioventa * 1,
                            "idproducto" => $info->idproducto
                        );
                        $k++;
                        
                        $infoMultipleProduct = $this->ventas_model->getListadoMultiplesPrecios($info->idproducto, 1, 1);
                        
                        if($pos_precios == 0){
                            $precioVentaProducto = $info->precioventa;
                        }
                        
                        if($infoMultipleProduct != false){
                            if($pos_precios == 1){
                                foreach($infoMultipleProduct as $infoMulti){
                                    $precioVentaProducto = $infoMulti->precioventa;
                                    break;
                                }
                            }
                            
                            foreach($infoMultipleProduct as $infoMulti){
                                $itemsMultiplePrecio[$k] = array(
                                    "id" => $infoMulti->precioventa * 1,
                                    "descrip" => $infoMulti->precioventa * 1,
                                    "idproducto" => $info->idproducto
                                );
                                $k++;
                            }
                        }else{
                            if($pos_precios == 1){
                                $precioVentaProducto = $info->precioventa;
                            }
                        }
						
                        if($info->existe == "0"){
							$items[$i] = array(
								"nameproducto" => $info->descrip,
								"marca" => $info->marca,
								"modelo" => $info->modelo,
								"upc" => $info->barcode,
								"notas" => $info->notas,
								"idproducto" => $info->idproducto,
								"um" => $info->um,
								"imagen" => $info->imagen,
								"cantidad" => $info->cantidad,
								"despachado" => 0,
								"precio" => $info->costounitario,
								"idbin" => $info->idbin,
								"idbatch" => $info->idbatch,
								"namecatalogo" => $info->namecatalogo,
								"precioventa" => $precioVentaProducto * 1,
								"idcatalogo" => $info->idcatalogo,
								"tipotax" => $info->tipotax,
								"agregado" => 0
							);
							$i++;
						}else{
							$items[$i] = array(
								"nameproducto" => $info->descrip,
								"marca" => $info->marca,
								"modelo" => $info->modelo,
								"upc" => $info->barcode,
								"notas" => $info->notas,
								"idproducto" => $info->idproducto,
								"um" => $info->um,
								"imagen" => $info->imagen,
								"cantidad" => $info->cantidad,
								"despachado" => 0,
								"precio" => $info->costounitario,
								"idbin" => $info->idbin,
								"idbatch" => $info->idbatch,
								"namecatalogo" => $info->namecatalogo,
								"precioventa" => $precioVentaProducto * 1,
								"idcatalogo" => $info->idcatalogo,
								"tipotax" => $info->tipotax,
								"agregado" => 1
							);
							$i++;
							$agregado = 1;
						}
                    }
                    
                    if($agregado == 1 && $i == 1){
                        $datos = $this->invtran_model->getDataProductoVentaTran100k($trannum, $info->idproducto);
                        $array = array(
                            "error" => "2",
                            "datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items,
                            "multiplesPrecios" => $itemsMultiplePrecio
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
        }
		
		function getDatosSearchPrueba(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                $trannum = $this->input->post('idtrannum');

                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $detalle = $this->ventas_model->getDatosProductoSearchPrueba($prosearch, $dato, $idcentro, $trannum);
                if($detalle != 0){
                    $i=0;
					$agregado=0;
                    $items = array();
                    foreach($detalle as $info){
						if($info->existe == "0"){
							$items[$i] = array(
								"nameproducto" => $info->descrip,
								"marca" => $info->marca,
								"modelo" => $info->modelo,
								"upc" => $info->barcode,
								"notas" => $info->notas,
								"idproducto" => $info->idproducto,
								"um" => $info->um,
								"imagen" => $info->imagen,
								"cantidad" => $info->cantidad,
								"precio" => $info->costounitario,
								"idbin" => $info->idbin,
								"idbatch" => $info->idbatch,
								"namecatalogo" => $info->namecatalogo,
								"precioventa" => $info->precioventa,
								"idcatalogo" => $info->idcatalogo,
								"tipotax" => $info->tipotax,
								"tipo" => $info->tipo,
								"agregado" => 0
							);
							$i++;
						}else{
							$items[$i] = array(
								"nameproducto" => $info->descrip,
								"marca" => $info->marca,
								"modelo" => $info->modelo,
								"upc" => $info->barcode,
								"notas" => $info->notas,
								"idproducto" => $info->idproducto,
								"um" => $info->um,
								"imagen" => $info->imagen,
								"cantidad" => $info->cantidad,
								"precio" => $info->costounitario,
								"idbin" => $info->idbin,
								"idbatch" => $info->idbatch,
								"namecatalogo" => $info->namecatalogo,
								"precioventa" => $info->precioventa,
								"idcatalogo" => $info->idcatalogo,
								"tipotax" => $info->tipotax,
								"tipo" => $info->tipo,
								"agregado" => 1
							);
							$i++;
							$agregado = 1;
						}
                    }
                    if($agregado == 1 && $i == 1){
                        $datos = $this->invtran_model->getDataProductoVentaTran100kPrueba($trannum, $info->idproducto);
                        $array = array(
                            "error" => "2",
                            "datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
		}
        
        function updateDocumentoVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idclase = $this->input->post('idclase');
                $this->load->model('ventas_model');
                
                $array = $this->ventas_model->actualizarDocumentoVentas($idtrannum, $idclase);
                echo json_encode($array);
            }
        }
        
        function updateVendedorVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idworker = $this->input->post('idworker');
                $this->load->model('ventas_model');
                
                $array = $this->ventas_model->actualizarVendedorVentas($idtrannum, $idworker);
                echo json_encode($array);
            }
        }
        
        function getFormasdePago(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');
                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getFormasdePago($idclase);
                
                echo json_encode($array);
            }
        }
        
        function getTotalCancelado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $this->load->model('ventas_model');
                
                $array = $this->ventas_model->getTotalCanceladoVentas($idtrannum);
                echo json_encode(abs($array) * -1);
            }
        }
        
        function getDatosSucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getSucursales();
                echo json_encode($array);
            }
        }
        
        function getListadoCajas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');

                $this->load->model('ventas_model');
                $array = $this->ventas_model->getListadoCajas($idcentro);
                echo json_encode($array);
            }
        }
        
        function getDetallePagosVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $total = $this->input->post('totalVenta');
                $total = $total * 1;
                
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDetallePagosVentas($idtrannum);
                                
                $i=0;
                $array = array();
                foreach($datos as $info){
                    $pendiente = number_format($total, 2, '.', '') - number_format(abs($info->valor), 2, '.', '');
                    $array[$i] = array(
                        "idrec" => $info->idrec,
                        "imagen" => $info->imagen,
                        "descrip" => $info->descrip,
                        "t100descrip" => $info->t100descrip,
                        "notas" => $info->notas,
                        "valor" => $info->valor,
                        "pendiente" => number_format($pendiente, 2, '.', ',')
                    );
                    
                    $total = $total + $info->valor;
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
        function insertPagoVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $valor = $this->input->post('valor');
                $idclase = $this->input->post('idclase');
                $cajclase = $this->input->post('cajclase');
                $idworker = $this->input->post('idworker');
                $notas = trim($this->input->post('notas'));
                
                $this->load->model('ventas_model');
                $this->ventas_model->insertPagoVenta($trannum, $valor, $idclase, $cajclase, $idworker, $notas);
                $this->ventas_model->updateCCEstatus($trannum, 1);
                $datos = $this->ventas_model->getDetallePagosVentas($trannum);
                
                $total = $this->input->post('totalVenta');
                $total = $total * 1;

                $i=0; $cancelado=0;
                $informacion = array();
                foreach($datos as $info){
                    $pendiente = number_format($total, 2, '.', '') - number_format(abs($info->valor), 2, '.', '');
                    $informacion[$i] = array(
                        "idrec" => $info->idrec,
                        "imagen" => $info->imagen,
                        "descrip" => $info->descrip,
						"t100descrip" => $info->t100descrip,
						"notas" => $info->notas,
                        "valor" => $info->valor,
                        "pendiente" => number_format($pendiente, 2, '.', ',')
                    );
                    
                    $cancelado = $cancelado + $info->valor;
                    
                    $total = $total + $info->valor;
                    $i++;
                }
                
                $array = array(
                    "datos" => $informacion,
                    "totalCancelado" => abs($cancelado) * -1
                );
                
                echo json_encode($array);
            }
        }
        
        function insertPagoVentaUpdate(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $valor = $this->input->post('valor');
                $idclase = $this->input->post('idclase');
                $cajclase = $this->input->post('cajclase');
                $idworker = $this->input->post('idworker');
                $notas = trim($this->input->post('notas'));
                
                $this->load->model('ventas_model');
                $this->ventas_model->insertPagoVentaUpdate($trannum, $valor, $idclase, $cajclase, $idworker, $notas);
                $this->ventas_model->updateCCEstatus($trannum, 1);
                $datos = $this->ventas_model->getDetallePagosVentas($trannum);
                
                $total = $this->input->post('totalVenta');
                $total = $total * 1;

                $i=0; $cancelado=0;
                $informacion = array();
                foreach($datos as $info){
                    $pendiente = number_format($total, 2, '.', '') - number_format(abs($info->valor), 2, '.', '');
                    $informacion[$i] = array(
                        "idrec" => $info->idrec,
                        "imagen" => $info->imagen,
                        "descrip" => $info->descrip,
						"t100descrip" => $info->t100descrip,
						"notas" => $info->notas,
                        "valor" => $info->valor,
                        "pendiente" => number_format($pendiente, 2, '.', ',')
                    );
                    
                    $cancelado = $cancelado + $info->valor;
                    
                    $total = $total + $info->valor;
                    $i++;
                }
                
                $array = array(
                    "datos" => $informacion,
                    "totalCancelado" => abs($cancelado) * -1
                );
                
                echo json_encode($array);
            }
        }
        
        function insertCreditoPagoVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $valor = $this->input->post('valor');
                $idclase = $this->input->post('idclase');
                $cajclase = $this->input->post('cajclase');
                $idworker = $this->input->post('idworker');
                $idcps = $this->input->post('idcps');
                $notas = trim($this->input->post('notas'));
                
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                
                $this->ventas_model->insertCreditoPagoVenta($idtrannum, $valor, $idclase, $cajclase, $idworker, $notas, $idcps);
                #$total = $this->ventas_model->getTotalCanceladoVentas($idtrannum);
                $this->ventas_model->updateCCEstatus($idtrannum, 0);
                $datos = $this->ventas_model->getDetallePagosVentas($idtrannum);
                $data = $this->invtran_model->getDataTran100k($idtrannum);
                
                $total = 0;
                foreach($data as $t100k){
                    $precioneto = $t100k->precioneto + ($t100k->precioneto * ($t100k->tax1 / 100));
                    $total = $total + $precioneto * abs($t100k->cantidad);
                }
                
                $i=0; $cancelado=0;
                $informacion = array();
                foreach($datos as $info){
                    $pendiente = number_format($total, 2, '.', '') - number_format(abs($info->valor), 2, '.', '');
                    $informacion[$i] = array(
                        "idrec" => $info->idrec,
                        "imagen" => $info->imagen,
                        "descrip" => $info->descrip,
						"t100descrip" => $info->t100descrip,
						"notas" => $info->notas,
                        "valor" => $info->valor,
                        "pendiente" => number_format($pendiente, 2, '.', ',')
                    );
                    
                    $cancelado = $cancelado + $info->valor;
                    
                    $total = $total + $info->valor;
                    $i++;
                }
                
                $array = array(
                    "datos" => $informacion,
                    "totalCancelado" => abs($cancelado) * -1
                );
                echo json_encode($array);
            }
        }
        
        function deletePagoVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idrec = $this->input->post('idrec');
                $itemDescrip = $this->input->post('itemdescrip');
                
                $this->load->model('ventas_model');
                
				if($itemDescrip != 'P_RT'){
					$this->ventas_model->deleteRegistroPago($idrec, $idtrannum);
				}
                #$total = $this->ventas_model->getTotalCanceladoVentas($idtrannum);
				$this->ventas_model->updateCCEstatus($idtrannum, 0);
                $datos = $this->ventas_model->getDetallePagosVentas($idtrannum);
                
                $total = $this->input->post('totalVenta');
                $total = $total * 1;

                $i=0; $cancelado=0;
                $informacion = array();
                foreach($datos as $info){
                    $pendiente = number_format($total, 2, '.', '') - number_format(abs($info->valor), 2, '.', '');
                    $informacion[$i] = array(
                        "idrec" => $info->idrec,
                        "imagen" => $info->imagen,
                        "descrip" => $info->descrip,
						"t100descrip" => $info->t100descrip,
						"notas" => $info->notas,
                        "valor" => $info->valor,
                        "pendiente" => number_format($pendiente, 2, '.', ',')
                    );
                    
                    $cancelado = $cancelado + $info->valor;
                    
                    $total = $total - abs($info->valor);
                    $i++;
                }
                
                $array = array(
                    "datos" => $informacion,
                    "totalCancelado" => abs($cancelado) * -1
                );
                echo json_encode($array);
            }
        }
        
        function getClientesAutorizados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getListadoClientes($idcps, 1);
                
                $i=1;
                $array = array();
                
                $array[0] = array(
                    'idauxi' => '999999',
                    'descrip' => 'NUEVO CLIENTE'
                );
                
                foreach($datos as $info){
                    $array[$i] = array(
                        'idauxi' => $info->idauxi,
                        'descrip' => $info->descrip
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
        function getClientesNuevaVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('global_model');
                $this->load->model('ventas_model');
                
                $nombrevar = 'pos_grupocli0'.$idcentro;
				$grupoCliente = $this->global_model->getValorTextoVariable($nombrevar);
                
                if($grupoCliente == "0"){
                    $datos = $this->ventas_model->getListadoClientes($idcps, 1);
                }else{
                    $datos = $this->ventas_model->getListadoClientesGrupo($grupoCliente, 1);
                }
                
                $i=0;
                $array = array();
                
                if($datos != ""){
                    foreach($datos as $info){
                        $array[$i] = array(
                            'idauxi' => $info->idauxi,
                            'descrip' => $info->descrip,
                            'saldo' => $info->saldo
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function verificarCreditoCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');
                $total = $this->input->post('total');

                $this->load->model('ventas_model');
                $array = $this->ventas_model->verificarCreditoCliente($idcps, $total);
                echo json_encode($array);
            }
        }
        
        function getVerificaCreditoFiscal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');

                $this->load->model('ventas_model');
                $array = $this->ventas_model->verificarCreditoFiscal($idclase);
                echo json_encode($array);
            }
        }
        
		function getVerificaTicket(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');
				$this->load->model('ventas_model');
                $array = $this->ventas_model->verificaTicket($idclase);
                echo json_encode($array);
            }
		}
		
		function getVerificaTicketCierre(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');
                $idtrannum = $this->input->post('trannum');
				
				$opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
					$idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcaja = $this->session->userdata('idcajauser');
                }
				
				$this->load->model('ventas_model');
				$this->load->model('global_model');
                $ticket = $this->ventas_model->verificaTicket($idclase);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($idtrannum);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$url_print = $this->ventas_model->getFormatoPrintTransaccion($idclase);
				
				$showpprint = array(
					"show_pprint" => 0
				);
				$this->session->set_userdata($showpprint);
				$this->global_model->updateEstadoPrint($idtrannum);
                
				$array = array(
					'ticket' => $ticket,
                    'efectivo' => $efectivo,
					'datos_print' => $datosprint,
					'url_print' => $url_print
				);
				echo json_encode($array);
            }
		}
		
        function getSerieNumeroDocumento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }

                $this->load->model('ventas_model');
				$creditoFiscal = $this->ventas_model->verificarCreditoFiscal($idclase);
                $numTipo = $this->ventas_model->getNumTipoTransaccion($idclase);

				if($numTipo == 1){ //Empresa
					$serie = $this->ventas_model->getSerieDocumentoEmpresa($idclase);
					$numeros = $this->ventas_model->getNumerosDocumentoEmpresa($idclase);
                    $restantes = $this->ventas_model->getNumerosRestantesDocumentoEmpresa($idclase);
				}else if($numTipo == 2){ //Sucursal
					$serie = $this->ventas_model->getSerieDocumentoSucursal($idclase, $idcentro);
					$numeros = $this->ventas_model->getNumerosDocumentoSucursal($idclase, $idcentro);
                    $restantes = $this->ventas_model->getNumerosRestantesDocumentoSucursal($idclase, $idcentro);
				}else if($numTipo == 3){ //Caja
					$serie = $this->ventas_model->getSerieDocumento($idclase, $idcentro, $idcaja);
					$numeros = $this->ventas_model->getNumerosDocumento($idclase, $idcentro, $idcaja);
                    $restantes = $this->ventas_model->getNumerosRestantesDocumento($idclase, $idcentro, $idcaja);
				}
                
                $array = array(
                    'creditoFiscal' => $creditoFiscal,
                    'serie' => $serie,
                    'numero' => $numeros,
                    'restantes' => $restantes
                );
                echo json_encode($array);
            }
        }
        
        function getDatosClienteCF(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDatosToCFCliente($idcps);
                echo json_encode($array);
            }
        }
        
        function imprimirTicket(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ventas_model');
                $this->ventas_model->imprimirTicketVenta();
            }
        }
        
        function setAnulaciondeOrden(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->anulacionDeOrden($idtrannum);
                
                echo json_encode($array);
            }
        }
        
        function cerrarVentaCF(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $numserie = $this->input->post('numserie');
                $numdocu = $this->input->post('numdocu');
                $notas = trim($this->input->post('notas'));
                $referencia = $this->input->post('referencia');
                $contactoAdicional = $this->input->post('contactoAdicional');
                $dui = $this->input->post('dui');
                $nrc = $this->input->post('nrc');
                $nit = $this->input->post('nit');
                $tipocont = $this->input->post('tipocont');
                $giro = $this->input->post('giro');
                $direccion = $this->input->post('direccion');
                $telefono = $this->input->post('telefono');
                $idzip = $this->input->post('idzip');
                $idcps = $this->input->post('idcps');
                $correo = $this->input->post('correo');
                $descrip = $this->input->post('descrip');
                
				$opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
				
                $this->load->model('ventas_model');
                $this->load->model('global_model');
				$validate = $this->ventas_model->getValidateNumSerie($numserie, $numdocu, $idcentro, $idcaja);
				$efectivo = $this->ventas_model->verificaPagoEfectivo($idtrannum);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				if($validate != ""){
					$array = array(
						"validate" => false,
						"fecha" => date_format(date_create($validate), 'd/m/Y')
					);
					echo json_encode($array);
				}else{
					$this->ventas_model->cierreDeVentaCF($idtrannum, $numserie, $numdocu, $notas, $referencia, $nrc, $idcps, $contactoAdicional);
					if($idcps != 999999){
						$this->ventas_model->updateDatosClienteCF($idcps, $dui, $nrc, $nit, $tipocont, $giro, $direccion, $telefono, $idzip, $correo, $descrip);
					}else{
						$this->ventas_model->insertDatosClienteCF($idtrannum, $dui, $nrc, $nit, $tipocont, $giro, $direccion, $telefono, $idzip, $correo, $descrip);
					}
					
					$this->global_model->insertarRegTran100p($idtrannum);
					
					$idclase = $this->ventas_model->getIdClaseVenta($idtrannum);
					$numTipo = $this->ventas_model->getNumTipoTransaccion($idclase);
					
					if($numTipo == 1){ //Empresa
						$this->ventas_model->updateNumerosFacturasEmpresa($idtrannum);
					}else if($numTipo == 2){ //Sucursal
						$this->ventas_model->updateNumerosFacturasSucursal($idtrannum, $idcentro);
					}else if($numTipo == 3){ //Caja
						$this->ventas_model->updateNumerosFacturas($idtrannum, $idcentro, $idcaja);
					}
					
					$this->ventas_model->callTotaliza100($idtrannum, 1);
                    
                    $numeroUnico = $this->ventas_model->validacionFormularioUnico($idcaja, $idclase);
                    if($numeroUnico != 0){
                        $this->ventas_model->updateRegistroFormUnico($idtrannum, $numeroUnico);
                    }
					
					$showpprint = array(
						"show_pprint" => 0
                    );
                    $this->session->set_userdata($showpprint);
					$this->global_model->updateEstadoPrint($idtrannum);
					
					$url_print = $this->ventas_model->getFormatoPrintTransaccion($idclase);
					
					$array = array(
						"url_print" => $url_print,
						'efectivo' => $efectivo,
						'datos_print' => $datosprint
					);
					
					echo json_encode($array);
				}
            }
        }
		
		function insertNuevoCliente(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $descrip = $this->input->post('namecliente');
                $this->load->model('ventas_model');
				$idauxi = $this->ventas_model->insertNuevoClienteVN($descrip);
				echo json_encode($idauxi);
			}
		}
        
        function cerrarVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $numserie = $this->input->post('numserie');
                $numdocu = $this->input->post('numdocu');
                $notas = trim($this->input->post('notas'));
                $referencia = $this->input->post('referencia');
                $idcps = $this->input->post('idcps');
                $dui = $this->input->post('dui');
                $nrc = $this->input->post('nrc');
                $nit = $this->input->post('nit');
                $email = $this->input->post('email');
                $direccion = $this->input->post('direccion');
                $telefono = $this->input->post('telefono');
                $idzip = $this->input->post('idzip');
                $descrip = $this->input->post('descrip');
                
				$opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
				
                $this->load->model('ventas_model');
                $this->load->model('global_model');
				$validate = $this->ventas_model->getValidateNumSerie($numserie, $numdocu, $idcentro, $idcaja);
				
				if($validate != ""){
					$array = array(
						"validate" => false,
						"fecha" => date_format(date_create($validate), 'd/m/Y')
					);
					echo json_encode($array);
				}else{
					$this->ventas_model->cierreDeVenta($idtrannum, $numserie, $numdocu, $notas, $referencia, $idcps);
					if($idcps != 999999){
						$this->ventas_model->updateDatosClienteFF($idcps, $dui, $nrc, $nit, $email, $direccion, $telefono, $idzip, $descrip);
					}else{
						$this->ventas_model->insertDatosClienteFF($idtrannum,  $dui, $nrc, $nit, $email, $direccion, $telefono, $idzip, $descrip);
					}
					
					//$array = $this->ventas_model->updateDatosTran100k($idtrannum);
					
					$idclase = $this->ventas_model->getIdClaseVenta($idtrannum);
					$numTipo = $this->ventas_model->getNumTipoTransaccion($idclase);
					if($numTipo == 1){ //Empresa
						$this->ventas_model->updateNumerosFacturasEmpresa($idtrannum);
					}else if($numTipo == 2){ //Sucursal
						$this->ventas_model->updateNumerosFacturasSucursal($idtrannum, $idcentro);
					}else if($numTipo == 3){ //Caja
						$this->ventas_model->updateNumerosFacturas($idtrannum, $idcentro, $idcaja);
					}
                                        					
					$this->global_model->insertarRegTran100p($idtrannum);
					$array = $this->ventas_model->callTotaliza100($idtrannum, 1);
                    
                    $numeroUnico = $this->ventas_model->validacionFormularioUnico($idcaja, $idclase);
                    if($numeroUnico != 0){
                        $this->ventas_model->updateRegistroFormUnico($idtrannum, $numeroUnico);
                    }
                    
					$showpprint = array(
                        "show_pprint" => 1
                    );
					$this->session->set_userdata($showpprint);
					
					echo json_encode($array);
				}            
			}
        }
        
        function getInformacionCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');
                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getInformacionCtauxi($idcps);
                
                echo json_encode($array);
            }
        }
        
        function tran100report($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getOptionsByidapp($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->data['direccion'] = $direccion;
                $this->load->model('global_model');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->data['sucursales']  = $this->sucursal_model->getDataSucursales();
                $this->data['opcionmenu']  = $opcionmenu;
                $this->load->view('consulta_transacciones_sucursal', $this->data); 
            }
        }
        
        function datosVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idsucursal = $this->input->post('idsucursal');
                $idcentro = $this->input->post('idcentro');
                $fecha1 = $this->input->post('fecha1');
                $fecha2 = $this->input->post('fecha2');
                
                $this->load->model('ventas_model');
                $tipo = $this->ventas_model->verTipo($idcentro);
                
                if($tipo == "VN"){
                    $lista100 = $this->ventas_model->listaTran100VN($idcentro, $idsucursal, $fecha1, $fecha2);
                }else if($tipo == "CO"){
                    $lista100 = $this->ventas_model->listaTran100CO($idcentro, $idsucursal, $fecha1, $fecha2);
                }else if($tipo == "IN"){
                    $lista100 = $this->ventas_model->listaTran100IN($idcentro, $idsucursal, $fecha1, $fecha2);
                }
                
                $i=0;
                $array = array();
                if($lista100 != false){
                    foreach($lista100 as $ventas100){
                        $trannum = $ventas100->id;
                        if($tipo == "VN"){
                            $lista100k = $this->ventas_model->listaTran100kVN($trannum);
                        }else if($tipo == "CO"){
                            $lista100k = $this->ventas_model->listaTran100kCO($trannum);
                        }else if($tipo == "IN"){
                            $lista100k = $this->ventas_model->listaTran100kIN($trannum);
                        }
                        
                        $j=0; $formaPago = ""; $imagenPago = "";
                        $detallesTranK = array();
                        if($lista100k != false){
                            foreach($lista100k as $ventas100k){
                                $detallesTranK[$j] = array(
                                    "id" => $ventas100k->id,
                                    "codigo" => $ventas100k->codigo,
                                    "modelo" => $ventas100k->modelo,
                                    "descrip" => $ventas100k->descrip,
                                    "unidad" => $ventas100k->unidad,
                                    "ubicacion" => $ventas100k->ubicacion,
                                    "lote" => $ventas100k->lote,
                                    "cantidad" => abs($ventas100k->cantidad),
                                    "precio" => $ventas100k->precio,
                                    "total" => abs($ventas100k->total),
                                    "notas" => $ventas100k->notas,
                                    "idworker" => $ventas100k->idworker,
                                    "vendedor" => $ventas100k->vendedor,
                                );
                                $j++;
    
                                $formaPago = $ventas100k->formaPago;
                                $imagenPago = $ventas100k->imagenPago;
                            }
                        }
                        
                        $array[$i] = array(
                            "id" => $ventas100->id,
                            "fecha" => $ventas100->fecha,
                            "numero" => $ventas100->numero,
                            "cliente" => $ventas100->cliente,
                            "vendedor" => $ventas100->vendedor,
                            "notas" => $ventas100->notas,
                            "valor" => $ventas100->valor,
                            "formaPago" => $formaPago,
                            "imagenPago" => $imagenPago,
                            "detallesTranK" => $detallesTranK
                        );
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }
        
        function getTipos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idsucursal = $this->input->post('idsucursal');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getTipos($idsucursal);
                echo json_encode($array);
            }
        }
		
        function getTransaccionesCenterFechas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idsucursal = $this->input->post('idsucursal');
                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getTransaccionesCenterFechas($idsucursal, $fechaini, $fechafin);
                
                echo json_encode($array);
            }
        }
		
		function getFormatoPrintClase(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');
                $controlador = $this->session->userdata('controlador_vn');
                // $funcion = $this->session->userdata('funcion_vn');
				// $url = $controlador.'/'.$funcion.'/pprint';

				$url = $controlador.'/pprint';
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getFormatoPrintDef($idclase,$url);
				echo json_encode($array);
            }
		}

        function getFormatoPrintConsignacion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');
                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getFormatoPrintDef($idclase, 'Facturacion/pprint');
				echo json_encode($array);
            }
		}
		
		function getMesesVentas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
				
				$this->load->model('ventas_model');
                $datos = $this->ventas_model->getMesesVentasCerradas('VN', $idcentro, $idcaja);
				$i=0;
				$array = array();
				foreach($datos as $mes){
					$array[$i] = array(
						"id" => $mes->Anio."-".$mes->numMes,
						"descrip" => ucwords($mes->Mes)." ".$mes->Anio
					);
					$i++;
				}
				echo json_encode($array);
            }
		}
        
		function getFacturasCerradasToDev(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                $tipodoc = $this->input->post('tipodoc');
                $mes = $this->input->post('idmes');
                if($mes != ""){
					$fechaini = date('Y-m-01', strtotime($mes));
                    $fechafin = date('Y-m-t', strtotime($mes));
				}else{
					$fechaini = "";
					$fechafin = "";
				}
				
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosFacturacionesCerradasDev('VN', $idcentro, $idcaja, $fechaini, $fechafin, $tipodoc);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
					$detalle = $this->ventas_model->getDetalleFacturas($info->trannum);
                    
                    $j=0;
                    $detailFacturas = array();
                    
                    foreach($detalle as $data){
						$valtax1 = $data->precioneto * ($data->tax1 / 100);
                        $total = abs($data->cantidad) * $data->precioneto + $valtax1;
                        $detailFacturas[$j] = array(
                            "itemline" => $data->itemline,
                            "idproducto" => $data->idproducto,
                            "descrip" => $data->descrip,
                            "um" => $data->um,
                            "ubicacion" => $data->ubicacion,
                            "lote" => $data->lote,
                            "cantidad" => abs($data->cantidad),
                            "precio" => number_format($data->precioneto, 6, '.', ''),
                            "tax1" => number_format($valtax1, 6, '.', ''),
                            "total" => number_format($total, 2, '.', '')
                        );
                        $j++;
                    }
					
                    $totalVenta = $info->valventan + $info->valtax1;
                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "idclase" => $info->idclase,
                        "numeroserie" => $info->numeroserie,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "valventan" => number_format($totalVenta, 2, '.', ''),
						"estatus" => $info->estatus,
						"detailFacturas" => $detailFacturas
                    );
                    $i++;
                }
                
                echo json_encode($array);
			}
		}

        function getCreditosFiscalesDevoluciones() {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
                $idcaja   = $this->input->post('idcaja');
                $idauxi   = $this->input->post('idauxi');
                
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosCreditosCerradasDev('VN', $idcentro, $idcaja, $idauxi);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
					
                    $totalVenta = $info->valventan + $info->valtax1;
                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "idclase" => $info->idclase,
                        "numeroserie" => $info->numeroserie,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "valventan" => number_format($totalVenta, 2, '.', ''),
						"estatus" => $info->estatus
                    );
                    $i++;
                }
                
                echo json_encode($array);
			}
		}
		
		function getProductosDevolucion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('trannum');
				$dev_tot = $this->input->post('dev_tot');

                $this->load->model('ventas_model');
				$datos = $this->ventas_model->getListadoProductosDevolucion($idtrannum);
				$proSum = $this->ventas_model->getLstadoSumaProductosDev($idtrannum);
				
                $i=0;
				$array = array();
				foreach ($datos as $info) {
					$proAdd = 1;
					$valCantidad = abs($info->cantidad);
					foreach($proSum as $infoDev){
						if($info->itemline == $infoDev->itemline){
							if(abs($info->cantidad) == $infoDev->total){
								$proAdd = 0;
							}else if(abs($info->cantidad) > $infoDev->total){
								$valCantidad = abs($info->cantidad) - $infoDev->total;
							}
						}
					}
					
					if($proAdd == 1){
						$array[$i] = array(
							"idrec" => $info->idrec,
							"idproducto" => $info->idproducto,
							"descrip" => $info->descrip,
							"cantidad" => $valCantidad,
							"precioneto" => $info->precioneto + ($info->precioneto * ($info->tax1/100)),
							"cantdev" => ($dev_tot == 1) ? $valCantidad : 0
						);
						$i++;
					}
				}
				echo json_encode($array);
			}
		}
		
		function getTipoPagoVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('trannum');
                $this->load->model('ventas_model');
                $this->load->model('global_model');
				
				$idClase = $this->ventas_model->getIdClaseVenta($idtrannum);				
				$idClaseDev = $this->ventas_model->getIdClaseDevolucion($idClase);				
				$info = $this->ventas_model->getDatosFactura($idtrannum);
				$idclase = $this->input->post('idclase');
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }

                $useOrdenes = $this->global_model->getValorNumVariable('pos_ordenes0'.$idcaja);

                if ($useOrdenes == 1) {
                    $datos = $this->ventas_model->getTipoPagoRealVentaOrdenes($idtrannum);
                } else {
                    $datos = $this->ventas_model->getTipoPagoRealiVenta($idtrannum);
                }

				$serie = $this->ventas_model->getSerieDocumento($idClaseDev, $idcentro, $idcaja);
                $numeros = $this->ventas_model->getNumerosDocumento($idClaseDev, $idcentro, $idcaja);
                
                $array = array(
					'informa' => $info,
                    'serie' => $serie,
                    'numero' => $numeros,
					'datos' => $datos
                );
				echo json_encode($array);
			}
		}
		
		function insertNuevaDevolucion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$registros = $this->input->post('registros');
				$cantidades = $this->input->post('cantidades');
				$idpago = $this->input->post('idpago');
				$serie = $this->input->post('serie');
				$numero = $this->input->post('numero');
				$notas = trim($this->input->post('notas'));
				$valor = $this->input->post('valor');
				$fecha = $this->input->post('fecha');
				
				$opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
				
				$this->load->model('ventas_model');
				$this->load->model('global_model');
				$idClase = $this->ventas_model->getIdClaseVenta($idtrannum);				
				$idclasedev = $this->ventas_model->getIdClaseDevolucion($idClase);
				
				$iddevolucion = $this->ventas_model->insertDevolucionVenta($idtrannum,$registros,$idpago,$serie,$numero,$notas,$idcentro,$idcaja,$idclasedev,$cantidades,$valor,$fecha);
				
				$numTipo = $this->ventas_model->getNumTipoTransaccion($idclasedev);
				if($numTipo == 1){ //Empresa
					$this->ventas_model->updateNumerosFacturasEmpresa($iddevolucion);
				}else if($numTipo == 2){ //Sucursal
					$this->ventas_model->updateNumerosFacturasSucursal($iddevolucion, $idcentro);
				}else if($numTipo == 3){ //Caja
					$this->ventas_model->updateNumerosFacturas($iddevolucion, $idcentro, $idcaja);
				}
				
				$this->global_model->insertarRegTran100p($iddevolucion);
				$this->ventas_model->callTotaliza100($iddevolucion, 1);
				
				$array = array(
                    'trannum' => $iddevolucion,
                    'idclase' => $idclasedev
                );
				echo json_encode($array);
			}
		}
		
		function getInformacionClienteFre(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$tipo = $this->input->post('tipo');
                $idcliente = $this->input->post('idcliente');

				$this->load->model('ventas_model');
				$array = $this->ventas_model->getDatosClienteFrecuenteUpdate($tipo, $idcliente);	
				
				echo json_encode($array);
			}
		}
		
		function getVendedoresFrecuentes(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$this->load->model('ventas_model');
				$array = $this->ventas_model->getVendedoresFrecuentesSuc($idcentro);
				echo json_encode($array);
			}
		}
		
		function getVendedoresFrecuentes100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$this->load->model('ventas_model');
				$array = $this->ventas_model->getVendedoresFrecuentes100kSuc($idcentro);
				echo json_encode($array);
			}
		}
		
		function getVerificaTipoDevolucion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$tipodoc = $this->input->post('tipodoc');
				$this->load->model('ventas_model');
				$array = $this->ventas_model->getVerificaTipoDevolucion($tipodoc);
				echo json_encode($array);
			}
		}
    	
		function imprimirCorteZEpos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$fechaactual = $this->input->post('fechaactual');
				$idcentro = $this->input->post('idcentro');
				$idcaja = $this->input->post('idcaja');
				
				$this->load->model('ventas_model');$this->load->model('invtran_model');
                $this->load->model('sucursal_model');$this->load->model('caja_model');
				$this->load->model('global_model');
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$showpprint = array(
					"show_pprint" => 0
				);
				$this->session->set_userdata($showpprint);
				
				$array = array(
					"namecentro" => $namecentro,
					"namecaja" => $namecaja,
					"numcaja" => $numcaja,
					"razonsocial" => $RazonSocial,
					"nrf" => $NRF,
					"nit" => $NIT,
					"giro" => $GIRO,
					"direccion" => $direccion,
					"depto" => $depto,
					"telefono" => $telefono,
					"datos_print" => $datosprint,
					"documentos" => $documentos,
					"facturas" => $facturas
				);
				
				echo json_encode($array);
			}
		}
        
        function consolidadodatos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $mensaje = array(
                    'error' => 0,
                );
                $this->load->model('global_model');
                
				$this->data['direccion'] = $controlador;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->session->set_userdata($mensaje);
                $this->load->model('sucursal_model');
                $this->load->model('user_model');
                $this->data['sucursales'] = $this->sucursal_model->viewSucursales_activas_asc(1);
                $this->data['tipos'] = $this->sucursal_model->getTipo();
                $this->data['all_sucursales'] = $this->sucursal_model->viewSucursales_activas_asc();
                $this->data['derechos'] = $this->user_model->getDerechos();
                $this->load->view('mantenimiento_consolidadodatos', $this->data);
            }
        }

        
		
        function getSucursalesTipo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('sucursal_model');
                $tipocentro = $this->input->post('tipocentro');
                $sucursales = $this->sucursal_model->viewSucursalActiva_Tipo($tipocentro);
                
                $i=2;
                $array = array();
                
                $array[0] = array(
                    "dataField" => "encabezados",
                    "caption" => "",
                    "fixed" => true, 
                    "minWidth" => 150,
                    "width" => "auto",
                    "cssClass" => 'fechas',
                    "alignment" => 'right'
                );
                
                $array[1] = array(
                    "dataField" => "sumas",
                    "caption" => "SUMAS",
                    "fixed" => true, 
                    "width" => 100,
                    "cssClass" => 'montos',
                    "alignment" => 'right'
                );
                
                foreach($sucursales as $suc){
                    $array[$i] = array(
                        "dataField" => "suc_$suc->idcentro",
                        "caption" => $suc->descrip,
                        "minWidth" => 100,
                        "alignment" => 'right'
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
		
		function getVentasConsolidado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
				$tipocentro = $this->input->post('tipocentro');
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                
                
                $ventasFechas = $this->ventas_model->ventasConsolidadoFechas($fechaini,$fechafin);
                $ventasFechasHoras = $this->ventas_model->ventasConsolidadoFechasHoras($fechaini,$fechafin);
                $ventasFechasHorasdetalle = $this->ventas_model->ventasConsolidadoFechasHoras_Detalle($fechaini,$fechafin);
                $ventas = $this->ventas_model->ventasConsolidado($fechaini,$fechafin);
                $totales = $this->ventas_model->ventasConsolidado_Totales($fechaini,$fechafin);
                $sucursales = $this->sucursal_model->viewSucursalActiva_Tipo($tipocentro);
                $array = array();
                $i=0;
                foreach($ventasFechas as $vn){
                    $day = "";
                    switch($vn->dia){
                        case 0:
                            $day = "DOM-";
                            break;
                        case 1:
                            $day = "LUN-";
                            break;
                        case 2:
                            $day = "MAR-";
                            break;
                        case 3:
                            $day = "MIE-";
                            break;
                        case 4:
                            $day = "JUE-";
                            break;
                        case 5:
                            $day = "VIE-";
                            break;
                        case 6:
                            $day = "SAB-";
                            break;
                        default:
                            $day = "";
                            break;
                    }
                    
                    $array[$i] = array(
                        "ID" => str_replace('-', '', $vn->fecha),
                        "Head_ID" =>0,
                        "encabezados" => $day.date_format(date_create($vn->fecha), 'd/m/Y'),
                        "fecha" => date_format(date_create($vn->fecha), 'd-m-Y'),
						"dia" => $vn->dia,
                    );

                    $sum_fecha = 0;

                    foreach($sucursales as $suc){
                        foreach($ventas as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha ==$vn->fecha){
                                $array_detalle = array();
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($vnFech->totalVentas,2), 2, '.', ',')
                                );
                                $sum_fecha+=round($vnFech->totalVentas,2);
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }

                    $array_detalle = array(
                        "sumas" => $this->session->userdata('simboloMoneda').number_format(round($sum_fecha,2), 2, '.', ',')
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                }

                foreach($ventasFechasHoras as $horas){
                    $horas_text = '';
                    switch($horas->hora){
                        case 1:
                            $horas_text = "01:00 - 01:59 am";
                            break;
                        case 2:
                            $horas_text = "02:00 - 02:59 am";
                            break;
                        case 3:
                            $horas_text = "03:00 - 03:59 am";
                            break;
                        case 4:
                            $horas_text = "04:00 - 04:59 am";
                            break;
                        case 5:
                            $horas_text = "05:00 - 05:59 am";
                            break;
                        case 6:
                            $horas_text = "06:00 - 06:59 am";
                            break;
                        case 7:
                            $horas_text = "07:00 - 07:59 am";
                            break;
                        case 8:
                            $horas_text = "08:00 - 08:59 am";
                            break;
                        case 9:
                            $horas_text = "09:00 - 09:59 am";
                            break;
                        case 10:
                            $horas_text = "10:00 - 10:59 am";
                            break;
                        case 11:
                            $horas_text = "11:00 - 11:59 am";
                            break;
                        case 12:
                            $horas_text = "12:00 - 12:59 pm";
                            break;
                        case 13:
                            $horas_text = "01:00 - 01:59 pm";
                            break;
                        case 14:
                            $horas_text = "02:00 - 02:59 pm";
                            break;
                        case 15:
                            $horas_text = "03:00 - 03:59 pm";
                            break;
                        case 16:
                            $horas_text = "04:00 - 04:59 pm";
                            break;
                        case 17:
                            $horas_text = "05:00 - 05:59 pm";
                            break;
                        case 18:
                            $horas_text = "06:00 - 06:59 pm";
                            break;
                        case 19:
                            $horas_text = "07:00 - 07:59 pm";
                            break;
                        case 20:
                            $horas_text = "08:00 - 08:59 pm";
                            break;
                        case 21:
                            $horas_text = "09:00 - 09:59 pm";
                            break;
                        case 22:
                            $horas_text = "10:00 - 10:59 pm";
                            break;
                        case 23:
                            $horas_text = "11:00 - 11:59 pm";
                            break;
                        case 0:
                            $horas_text = "12:00 - 12:59 am";
                            break;
                        default:
                            $horas_text = "--otras--";
                            break;
                    }

                    $array[$i] = array(
                        "ID" =>str_replace('-', '', $horas->fecha).$horas->hora,
                        "Head_ID" => str_replace('-', '', $horas->fecha),
                        "encabezados" => $horas_text,
                        "fecha" => date_format(date_create($horas->fecha), 'd-m-Y'),
						"dia" => $horas->dia,
                    );

                    $sum_horas = 0;
                    foreach($sucursales as $suc){
                        foreach($ventasFechasHorasdetalle as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha == $horas->fecha && $vnFech->hora == $horas->hora){
                                $array_detalle = array();
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($vnFech->totalVentas,2), 2, '.', ',')
                                );
                                $sum_horas += round($vnFech->totalVentas,2);
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $array_detalle = array(
                        "sumas" => $this->session->userdata('simboloMoneda').number_format(round($sum_horas,2), 2, '.', ',')
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                }
                
                $array[$i] = array(
                    "ID" =>"totales",
                    "Head_ID" => 0,
                    "encabezados" => "TOTALES",
                    "class"=>"totales",
                );

                $total_neto = 0;
                foreach($sucursales as $suc){
                    foreach($totales as $tot){
                        if($suc->idcentro==$tot->idcentro){
                            $array_detalle = array();
                            $array_detalle = array(
                                "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($tot->totalVentas,2), 2, '.', ',')
                            );
                            $total_neto += round($tot->totalVentas,2);
                            $array[$i] = array_merge($array[$i], $array_detalle);
                        }
                    }
                }
                $array_detalle = array(
                    "sumas" => $this->session->userdata('simboloMoneda').number_format(round($total_neto,2), 2, '.', ',')
                );
                $array[$i] = array_merge($array[$i], $array_detalle);
                $i++;
                
                echo json_encode($array);
            }
        }
        
		function getTicketPromedio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                
                
                $ventasFechas = $this->ventas_model->ventasConsolidadoFechas($fechaini,$fechafin);
                $ventasFechasHoras = $this->ventas_model->ventasConsolidadoFechasHoras($fechaini,$fechafin);
                $ventasFechasHorasdetalle = $this->ventas_model->ventasConsolidadoFechasHoras_Detalle($fechaini,$fechafin);
                $ventas = $this->ventas_model->ventasConsolidado($fechaini,$fechafin);
                $totales = $this->ventas_model->ventasConsolidado_Totales($fechaini,$fechafin);
                $sucursales = $this->sucursal_model->viewSucursalActiva_Tipo(1);
                $array = array();
                $i=0;
                foreach($ventasFechas as $vn){
                    $day = "";
                    switch($vn->dia){
                        case 0:
                            $day = "DOM-";
                            break;
                        case 1:
                            $day = "LUN-";
                            break;
                        case 2:
                            $day = "MAR-";
                            break;
                        case 3:
                            $day = "MIE-";
                            break;
                        case 4:
                            $day = "JUE-";
                            break;
                        case 5:
                            $day = "VIE-";
                            break;
                        case 6:
                            $day = "SAB-";
                            break;
                        default:
                            $day = "";
                            break;
                    }
                    $array[$i] = array(
                        "ID" => str_replace('-', '', $vn->fecha),
                        "Head_ID" =>0,
                        "encabezados" => $day.date_format(date_create($vn->fecha), 'd/m/Y'),
                        "dia" => $vn->dia,
                    );
                    $sum_ventas = 0;
                    $sum_prom = 0;
                    foreach($sucursales as $suc){
                        foreach($ventas as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha ==$vn->fecha){
                                $array_detalle = array();
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($vnFech->totalVentas/$vnFech->totalHits,2), 2, '.', ',')
                                );
                                $sum_ventas+=round($vnFech->totalVentas,2);
                                $sum_prom+= $vnFech->totalHits;
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $array_detalle = array(
                        "sumas" => $this->session->userdata('simboloMoneda').number_format(round($sum_ventas/$sum_prom,2), 2, '.', ',')
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                }
                
                $array[$i] = array(
                    "ID" =>"totales",
                    "Head_ID" => 0,
                    "encabezados" => "TOTALES",
                    "class"=>"totales",
                );
                $total_vent= 0;
                $total_hits = 0;
                foreach($sucursales as $suc){
                    foreach($totales as $tot){
                        if($suc->idcentro==$tot->idcentro){
                            $array_detalle = array();
                            $array_detalle = array(
                                "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($tot->totalVentas/$tot->totalHits,2), 2, '.', ',')
                            );
                            $total_vent += round($tot->totalVentas,2);
                            $total_hits += $tot->totalHits;
                            $array[$i] = array_merge($array[$i], $array_detalle);
                        }
                    }
                }
                $array_detalle = array(
                    "sumas" => $this->session->userdata('simboloMoneda').number_format(round($total_vent/$total_hits,2), 2, '.', ',')
                );
                $array[$i] = array_merge($array[$i], $array_detalle);
                $i++;
                
                echo json_encode($array);
            }
        }
        
		function getClientesxDia(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                
                
                $ventasFechas = $this->ventas_model->ventasConsolidadoFechas($fechaini,$fechafin);
                $ventasFechasHoras = $this->ventas_model->ventasConsolidadoFechasHoras($fechaini,$fechafin);
                $ventasFechasHorasdetalle = $this->ventas_model->ventasConsolidadoFechasHoras_Detalle($fechaini,$fechafin);
                $ventas = $this->ventas_model->ventasConsolidado($fechaini,$fechafin);
                $totales = $this->ventas_model->ventasConsolidado_Totales($fechaini,$fechafin);
                $sucursales = $this->sucursal_model->viewSucursalActiva_Tipo(1);
                $array = array();
                $i=0;
                foreach($ventasFechas as $vn){
                    $day = "";
                    switch($vn->dia){
                        case 0:
                            $day = "DOM-";
                            break;
                        case 1:
                            $day = "LUN-";
                            break;
                        case 2:
                            $day = "MAR-";
                            break;
                        case 3:
                            $day = "MIE-";
                            break;
                        case 4:
                            $day = "JUE-";
                            break;
                        case 5:
                            $day = "VIE-";
                            break;
                        case 6:
                            $day = "SAB-";
                            break;
                        default:
                            $day = "";
                            break;
                    }
                    
                    $array[$i] = array(
                        "ID" => str_replace('-', '', $vn->fecha),
                        "Head_ID" =>0,
                        "encabezados" => $day.date_format(date_create($vn->fecha), 'd/m/Y'),
						"dia" => $vn->dia,
                    );
                    $sum_fecha = 0;
                    foreach($sucursales as $suc){
                        foreach($ventas as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha ==$vn->fecha){
                                $array_detalle = array();
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => $vnFech->totalHits
                                );
                                $sum_fecha+=$vnFech->totalHits;
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $array_detalle = array(
                        "sumas" => $sum_fecha
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                }
                foreach($ventasFechasHoras as $horas){
                    $horas_text = '';
                    switch($horas->hora){
                        case 1:
                            $horas_text = "01:00 - 01:59 am";
                            break;
                        case 2:
                            $horas_text = "02:00 - 02:59 am";
                            break;
                        case 3:
                            $horas_text = "03:00 - 03:59 am";
                            break;
                        case 4:
                            $horas_text = "04:00 - 04:59 am";
                            break;
                        case 5:
                            $horas_text = "05:00 - 05:59 am";
                            break;
                        case 6:
                            $horas_text = "06:00 - 06:59 am";
                            break;
                        case 7:
                            $horas_text = "07:00 - 07:59 am";
                            break;
                        case 8:
                            $horas_text = "08:00 - 08:59 am";
                            break;
                        case 9:
                            $horas_text = "09:00 - 09:59 am";
                            break;
                        case 10:
                            $horas_text = "10:00 - 10:59 am";
                            break;
                        case 11:
                            $horas_text = "11:00 - 11:59 am";
                            break;
                        case 12:
                            $horas_text = "12:00 - 12:59 pm";
                            break;
                        case 13:
                            $horas_text = "01:00 - 01:59 pm";
                            break;
                        case 14:
                            $horas_text = "02:00 - 02:59 pm";
                            break;
                        case 15:
                            $horas_text = "03:00 - 03:59 pm";
                            break;
                        case 16:
                            $horas_text = "04:00 - 04:59 pm";
                            break;
                        case 17:
                            $horas_text = "05:00 - 05:59 pm";
                            break;
                        case 18:
                            $horas_text = "06:00 - 06:59 pm";
                            break;
                        case 19:
                            $horas_text = "07:00 - 07:59 pm";
                            break;
                        case 20:
                            $horas_text = "08:00 - 08:59 pm";
                            break;
                        case 21:
                            $horas_text = "09:00 - 09:59 pm";
                            break;
                        case 22:
                            $horas_text = "10:00 - 10:59 pm";
                            break;
                        case 23:
                            $horas_text = "11:00 - 11:59 pm";
                            break;
                        case 0:
                            $horas_text = "12:00 - 12:59 am";
                            break;
                        default:
                            $horas_text = "--otras--";
                            break;
                    }

                    $array[$i] = array(
                        "ID" =>str_replace('-', '', $horas->fecha).$horas->hora,
                        "Head_ID" => str_replace('-', '', $horas->fecha),
                        "encabezados" => $horas_text,
						"dia" => $horas->dia,
                    );
                    $sum_horas = 0;
                    foreach($sucursales as $suc){
                        foreach($ventasFechasHorasdetalle as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha == $horas->fecha && $vnFech->hora == $horas->hora){
                                $array_detalle = array();
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => $vnFech->totalHits
                                );
                                $sum_horas += $vnFech->totalHits;
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $array_detalle = array(
                        "sumas" => $sum_horas
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                }
                
                $array[$i] = array(
                    "ID" =>"totales",
                    "Head_ID" => 0,
                    "encabezados" => "TOTALES",
                    "class"=>"totales",
                );
                $total_neto = 0;
                foreach($sucursales as $suc){
                    foreach($totales as $tot){
                        if($suc->idcentro==$tot->idcentro){
                            $array_detalle = array();
                            $array_detalle = array(
                                "suc_".$suc->idcentro => $tot->totalHits
                            );
                            $total_neto += $tot->totalHits;
                            $array[$i] = array_merge($array[$i], $array_detalle);
                        }
                    }
                }
                $array_detalle = array(
                    "sumas" => $total_neto
                );
                $array[$i] = array_merge($array[$i], $array_detalle);
                $i++;
                
                echo json_encode($array);
            }
        }
        
		function getCostoVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                
                
                $ventasFechas = $this->ventas_model->ventasConsolidadoFechas($fechaini,$fechafin);
                $ventasFechasHoras = $this->ventas_model->ventasConsolidadoFechasHoras($fechaini,$fechafin);
                $ventasFechasHorasdetalle = $this->ventas_model->ventasConsolidadoFechasHoras_Detalle($fechaini,$fechafin);
                $ventas = $this->ventas_model->ventasConsolidado($fechaini,$fechafin);
                $totales = $this->ventas_model->ventasConsolidado_Totales($fechaini,$fechafin);
                $sucursales = $this->sucursal_model->viewSucursalActiva_Tipo(1);
                $array = array();
                $i=0;
                foreach($ventasFechas as $vn){
                    
                    $day = "";
                    switch($vn->dia){
                        case 0:
                            $day = "DOM-";
                            break;
                        case 1:
                            $day = "LUN-";
                            break;
                        case 2:
                            $day = "MAR-";
                            break;
                        case 3:
                            $day = "MIE-";
                            break;
                        case 4:
                            $day = "JUE-";
                            break;
                        case 5:
                            $day = "VIE-";
                            break;
                        case 6:
                            $day = "SAB-";
                            break;
                        default:
                            $day = "";
                            break;
                    }
                    
                    
                    $array[$i] = array(
                        "ID" => str_replace('-', '', $vn->fecha),
                        "Head_ID" =>0,
                        "encabezados" => $day. date_format(date_create($vn->fecha), 'd/m/Y'),
						"dia" => $vn->dia,
                    );
                    $sum_fecha = 0;
                    foreach($sucursales as $suc){
                        foreach($ventas as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha ==$vn->fecha){
                                $array_detalle = array();
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($vnFech->totalCostos,2), 2, '.', ',')
                                );
                                $sum_fecha+=round($vnFech->totalCostos,2);
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $array_detalle = array(
                        "sumas" => $this->session->userdata('simboloMoneda').number_format(round($sum_fecha,2), 2, '.', ',')
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                }
                foreach($ventasFechasHoras as $horas){
                    $horas_text = '';
                    switch($horas->hora){
                        case 1:
                            $horas_text = "01:00 - 01:59 am";
                            break;
                        case 2:
                            $horas_text = "02:00 - 02:59 am";
                            break;
                        case 3:
                            $horas_text = "03:00 - 03:59 am";
                            break;
                        case 4:
                            $horas_text = "04:00 - 04:59 am";
                            break;
                        case 5:
                            $horas_text = "05:00 - 05:59 am";
                            break;
                        case 6:
                            $horas_text = "06:00 - 06:59 am";
                            break;
                        case 7:
                            $horas_text = "07:00 - 07:59 am";
                            break;
                        case 8:
                            $horas_text = "08:00 - 08:59 am";
                            break;
                        case 9:
                            $horas_text = "09:00 - 09:59 am";
                            break;
                        case 10:
                            $horas_text = "10:00 - 10:59 am";
                            break;
                        case 11:
                            $horas_text = "11:00 - 11:59 am";
                            break;
                        case 12:
                            $horas_text = "12:00 - 12:59 pm";
                            break;
                        case 13:
                            $horas_text = "01:00 - 01:59 pm";
                            break;
                        case 14:
                            $horas_text = "02:00 - 02:59 pm";
                            break;
                        case 15:
                            $horas_text = "03:00 - 03:59 pm";
                            break;
                        case 16:
                            $horas_text = "04:00 - 04:59 pm";
                            break;
                        case 17:
                            $horas_text = "05:00 - 05:59 pm";
                            break;
                        case 18:
                            $horas_text = "06:00 - 06:59 pm";
                            break;
                        case 19:
                            $horas_text = "07:00 - 07:59 pm";
                            break;
                        case 20:
                            $horas_text = "08:00 - 08:59 pm";
                            break;
                        case 21:
                            $horas_text = "09:00 - 09:59 pm";
                            break;
                        case 22:
                            $horas_text = "10:00 - 10:59 pm";
                            break;
                        case 23:
                            $horas_text = "11:00 - 11:59 pm";
                            break;
                        case 0:
                            $horas_text = "12:00 - 12:59 am";
                            break;
                        default:
                            $horas_text = "--otras--";
                            break;
                    }

                    $array[$i] = array(
                        "ID" =>str_replace('-', '', $horas->fecha).$horas->hora,
                        "Head_ID" => str_replace('-', '', $horas->fecha),
                        "encabezados" => $horas_text,
						"dia" => $horas->dia,
                    );
                    $sum_horas = 0;
                    foreach($sucursales as $suc){
                        foreach($ventasFechasHorasdetalle as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha == $horas->fecha && $vnFech->hora == $horas->hora){
                                $array_detalle = array();
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($vnFech->totalCostos,2), 2, '.', ',')
                                );
                                $sum_horas += round($vnFech->totalCostos,2);
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $array_detalle = array(
                        "sumas" => $this->session->userdata('simboloMoneda').number_format(round($sum_horas,2), 2, '.', ',')
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                }
                
                $array[$i] = array(
                    "ID" =>"totales",
                    "Head_ID" => 0,
                    "encabezados" => "TOTALES",
                    "class"=>"totales",
                );
                $total_neto = 0;
                foreach($sucursales as $suc){
                    foreach($totales as $tot){
                        if($suc->idcentro==$tot->idcentro){
                            $array_detalle = array();
                            $array_detalle = array(
                                "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($tot->totalCostos,2), 2, '.', ',')
                            );
                            $total_neto += round($tot->totalCostos,2);
                            $array[$i] = array_merge($array[$i], $array_detalle);
                        }
                    }
                }
                $array_detalle = array(
                    "sumas" => $this->session->userdata('simboloMoneda').number_format(round($total_neto,2), 2, '.', ',')
                );
                $array[$i] = array_merge($array[$i], $array_detalle);
                $i++;
                
                echo json_encode($array);
            }
        }
        
		function getUtilidad(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                
                
                $ventasFechas = $this->ventas_model->ventasConsolidadoFechas($fechaini,$fechafin);
                $ventasFechasHoras = $this->ventas_model->ventasConsolidadoFechasHoras($fechaini,$fechafin);
                $ventasFechasHorasdetalle = $this->ventas_model->ventasConsolidadoFechasHoras_Detalle($fechaini,$fechafin);
                $ventas = $this->ventas_model->ventasConsolidado($fechaini,$fechafin);
                $totales = $this->ventas_model->ventasConsolidado_Totales($fechaini,$fechafin);
                $sucursales = $this->sucursal_model->viewSucursalActiva_Tipo(1);
                $array = array();
                $i=0;
                foreach($ventasFechas as $vn){
                    
                    $day = "";
                    switch($vn->dia){
                        case 0:
                            $day = "DOM-";
                            break;
                        case 1:
                            $day = "LUN-";
                            break;
                        case 2:
                            $day = "MAR-";
                            break;
                        case 3:
                            $day = "MIE-";
                            break;
                        case 4:
                            $day = "JUE-";
                            break;
                        case 5:
                            $day = "VIE-";
                            break;
                        case 6:
                            $day = "SAB-";
                            break;
                        default:
                            $day = "";
                            break;
                    }
                    
                    
                    $array[$i] = array(
                        "ID" => str_replace('-', '', $vn->fecha),
                        "Head_ID" =>0,
                        "encabezados" => $day. date_format(date_create($vn->fecha), 'd/m/Y'),
						"dia" => $vn->dia,
                    );
                    $sum_fecha = 0;
                    foreach($sucursales as $suc){
                        foreach($ventas as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha ==$vn->fecha){
                                $array_detalle = array();
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round(($vnFech->totalVentas + $vnFech->totalCostos),2), 2, '.', ',')
                                );
                                $sum_fecha+=round(($vnFech->totalVentas + $vnFech->totalCostos),2);
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $array_detalle = array(
                        "sumas" => $this->session->userdata('simboloMoneda').number_format(round($sum_fecha,2), 2, '.', ',')
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                    //var_dump($array);
                }
                foreach($ventasFechasHoras as $horas){
                    $horas_text = '';
                    switch($horas->hora){
                        case 1:
                            $horas_text = "01:00 - 01:59 am";
                            break;
                        case 2:
                            $horas_text = "02:00 - 02:59 am";
                            break;
                        case 3:
                            $horas_text = "03:00 - 03:59 am";
                            break;
                        case 4:
                            $horas_text = "04:00 - 04:59 am";
                            break;
                        case 5:
                            $horas_text = "05:00 - 05:59 am";
                            break;
                        case 6:
                            $horas_text = "06:00 - 06:59 am";
                            break;
                        case 7:
                            $horas_text = "07:00 - 07:59 am";
                            break;
                        case 8:
                            $horas_text = "08:00 - 08:59 am";
                            break;
                        case 9:
                            $horas_text = "09:00 - 09:59 am";
                            break;
                        case 10:
                            $horas_text = "10:00 - 10:59 am";
                            break;
                        case 11:
                            $horas_text = "11:00 - 11:59 am";
                            break;
                        case 12:
                            $horas_text = "12:00 - 12:59 pm";
                            break;
                        case 13:
                            $horas_text = "01:00 - 01:59 pm";
                            break;
                        case 14:
                            $horas_text = "02:00 - 02:59 pm";
                            break;
                        case 15:
                            $horas_text = "03:00 - 03:59 pm";
                            break;
                        case 16:
                            $horas_text = "04:00 - 04:59 pm";
                            break;
                        case 17:
                            $horas_text = "05:00 - 05:59 pm";
                            break;
                        case 18:
                            $horas_text = "06:00 - 06:59 pm";
                            break;
                        case 19:
                            $horas_text = "07:00 - 07:59 pm";
                            break;
                        case 20:
                            $horas_text = "08:00 - 08:59 pm";
                            break;
                        case 21:
                            $horas_text = "09:00 - 09:59 pm";
                            break;
                        case 22:
                            $horas_text = "10:00 - 10:59 pm";
                            break;
                        case 23:
                            $horas_text = "11:00 - 11:59 pm";
                            break;
                        case 0:
                            $horas_text = "12:00 - 12:59 am";
                            break;
                        default:
                            $horas_text = "--otras--";
                            break;
                    }

                    $array[$i] = array(
                        "ID" =>str_replace('-', '', $horas->fecha).$horas->hora,
                        "Head_ID" => str_replace('-', '', $horas->fecha),
                        "encabezados" => $horas_text,
						"dia" => $horas->dia,
                    );
                    $sum_horas = 0;
                    foreach($sucursales as $suc){
                        foreach($ventasFechasHorasdetalle as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha == $horas->fecha && $vnFech->hora == $horas->hora){
                                $array_detalle = array();
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round(($vnFech->totalVentas - $vnFech->totalCostos),2), 2, '.', ',')
                                );
                                $sum_horas += round(($vnFech->totalVentas + $vnFech->totalCostos),2);
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $array_detalle = array(
                        "sumas" => $this->session->userdata('simboloMoneda').number_format(round($sum_horas,2), 2, '.', ',')
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                }
                
                $array[$i] = array(
                    "ID" =>"totales",
                    "Head_ID" => 0,
                    "encabezados" => "TOTALES",
                    "class"=>"totales",
                );
                $total_neto = 0;
                foreach($sucursales as $suc){
                    foreach($totales as $tot){
                        if($suc->idcentro==$tot->idcentro){
                            $array_detalle = array();
                            $array_detalle = array(
                                "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round(($tot->totalVentas + $tot->totalCostos),2), 2, '.', ',')
                            );
                            $total_neto += round(($tot->totalVentas + $tot->totalCostos),2);
                            $array[$i] = array_merge($array[$i], $array_detalle);
                        }
                    }
                }
                $array_detalle = array(
                    "sumas" => $this->session->userdata('simboloMoneda').number_format(round($total_neto,2), 2, '.', ',')
                );
                $array[$i] = array_merge($array[$i], $array_detalle);
                $i++;
                
                echo json_encode($array);
            }
        }
        
		function getMargen(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                
                
                $ventasFechas = $this->ventas_model->ventasConsolidadoFechas($fechaini,$fechafin);
                $ventasFechasHoras = $this->ventas_model->ventasConsolidadoFechasHoras($fechaini,$fechafin);
                $ventasFechasHorasdetalle = $this->ventas_model->ventasConsolidadoFechasHoras_Detalle($fechaini,$fechafin);
                $ventas = $this->ventas_model->ventasConsolidado($fechaini,$fechafin);
                $totales = $this->ventas_model->ventasConsolidado_Totales($fechaini,$fechafin);
                $sucursales = $this->sucursal_model->viewSucursalActiva_Tipo(1);
                $array = array();
                $i=0;
                foreach($ventasFechas as $vn){
                    
                    $day = "";
                    switch($vn->dia){
                        case 0:
                            $day = "DOM-";
                            break;
                        case 1:
                            $day = "LUN-";
                            break;
                        case 2:
                            $day = "MAR-";
                            break;
                        case 3:
                            $day = "MIE-";
                            break;
                        case 4:
                            $day = "JUE-";
                            break;
                        case 5:
                            $day = "VIE-";
                            break;
                        case 6:
                            $day = "SAB-";
                            break;
                        default:
                            $day = "";
                            break;
                    }
                    
                    
                    $array[$i] = array(
                        "ID" => str_replace('-', '', $vn->fecha),
                        "Head_ID" =>0,
                        "encabezados" => $day. date_format(date_create($vn->fecha), 'd/m/Y'),
						"dia" => $vn->dia,
                    );
                    $sum_fecha = 0;
                    $sum_suc = 0;
                    foreach($sucursales as $suc){
                        foreach($ventas as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha ==$vn->fecha){
                                $array_detalle = array();
                                $utilidad = $vnFech->totalVentas + $vnFech->totalCostos;
                                $margen=0;
                                if($vnFech->totalVentas!=0){
                                    $margen = ($utilidad/$vnFech->totalVentas)*100;
                                }else{
                                    $margen=0;
                                }
                                $sum_suc++;
                                $array_detalle = array(
                                    "suc_".$suc->idcentro =>number_format(round($margen,2), 2, '.', ','). "%"
                                );
                                $sum_fecha+=round($margen,2);
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $array_detalle = array(
                        "sumas" => ($sum_suc == 0) ? (number_format(0, 2, '.', ','))."%" : number_format(round($sum_fecha/$sum_suc,2), 2, '.', ','). "%"
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                }
                foreach($ventasFechasHoras as $horas){
                    $horas_text = '';
                    switch($horas->hora){
                        case 1:
                            $horas_text = "01:00 - 01:59 am";
                            break;
                        case 2:
                            $horas_text = "02:00 - 02:59 am";
                            break;
                        case 3:
                            $horas_text = "03:00 - 03:59 am";
                            break;
                        case 4:
                            $horas_text = "04:00 - 04:59 am";
                            break;
                        case 5:
                            $horas_text = "05:00 - 05:59 am";
                            break;
                        case 6:
                            $horas_text = "06:00 - 06:59 am";
                            break;
                        case 7:
                            $horas_text = "07:00 - 07:59 am";
                            break;
                        case 8:
                            $horas_text = "08:00 - 08:59 am";
                            break;
                        case 9:
                            $horas_text = "09:00 - 09:59 am";
                            break;
                        case 10:
                            $horas_text = "10:00 - 10:59 am";
                            break;
                        case 11:
                            $horas_text = "11:00 - 11:59 am";
                            break;
                        case 12:
                            $horas_text = "12:00 - 12:59 pm";
                            break;
                        case 13:
                            $horas_text = "01:00 - 01:59 pm";
                            break;
                        case 14:
                            $horas_text = "02:00 - 02:59 pm";
                            break;
                        case 15:
                            $horas_text = "03:00 - 03:59 pm";
                            break;
                        case 16:
                            $horas_text = "04:00 - 04:59 pm";
                            break;
                        case 17:
                            $horas_text = "05:00 - 05:59 pm";
                            break;
                        case 18:
                            $horas_text = "06:00 - 06:59 pm";
                            break;
                        case 19:
                            $horas_text = "07:00 - 07:59 pm";
                            break;
                        case 20:
                            $horas_text = "08:00 - 08:59 pm";
                            break;
                        case 21:
                            $horas_text = "09:00 - 09:59 pm";
                            break;
                        case 22:
                            $horas_text = "10:00 - 10:59 pm";
                            break;
                        case 23:
                            $horas_text = "11:00 - 11:59 pm";
                            break;
                        case 0:
                            $horas_text = "12:00 - 12:59 am";
                            break;
                        default:
                            $horas_text = "--otras--";
                            break;
                    }

                    $array[$i] = array(
                        "ID" =>str_replace('-', '', $horas->fecha).$horas->hora,
                        "Head_ID" => str_replace('-', '', $horas->fecha),
                        "encabezados" => $horas_text,
						"dia" => $horas->dia,
                    );
                    $sum_horas = 0;
                    $sum_suc = 0;
                    foreach($sucursales as $suc){
                        foreach($ventasFechasHorasdetalle as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha == $horas->fecha && $vnFech->hora == $horas->hora){
                                $array_detalle = array();
                                $utilidad = $vnFech->totalVentas + $vnFech->totalCostos;
                                $margen=0;
                                if($vnFech->totalVentas!=0){
                                    $margen = ($utilidad/$vnFech->totalVentas)*100;
                                }else{
                                    $margen=0;
                                }
                                $sum_suc++;
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => number_format(round($margen,2), 2, '.', ','). "%"
                                );
                                $sum_horas += round($margen,2);
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $sum_marg = 0;
                    if($sum_suc>0){
                        $sum_marg = $sum_horas/$sum_suc;
                    }
                    
                    
                    $array_detalle = array(
                        "sumas" => number_format(round($sum_marg,2), 2, '.', ','). "%"
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                }
                
                $array[$i] = array(
                    "ID" =>"totales",
                    "Head_ID" => 0,
                    "encabezados" => "PROMEDIOS",
                    "class"=>"totales",
                );
                $total_neto = 0;
                $cnt = 0;
                foreach($sucursales as $suc){
                    foreach($totales as $tot){
                        if($suc->idcentro==$tot->idcentro){
                            $array_detalle = array();
                            $utilidad = $tot->totalVentas + $tot->totalCostos;
                            $margen=0;
                            if($tot->totalVentas!=0){
                                $margen = ($utilidad/$tot->totalVentas)*100;
                            }else{
                                $margen=0;
                            }
                            $array_detalle = array(
                                "suc_".$suc->idcentro => number_format(round($margen,2), 2, '.', ','). "%"
                            );
                            $cnt++;
                            $total_neto += round($margen,2);
                            $array[$i] = array_merge($array[$i], $array_detalle);
                        }
                    }
                }
                $array_detalle = array(
                    "sumas" => number_format(round($total_neto/$cnt,2), 2, '.', ','). "%"
                );
                $array[$i] = array_merge($array[$i], $array_detalle);
                $i++;
                
                echo json_encode($array);
            }
        }
        
		function getIngresos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                
                
                $ventasFechas = $this->ventas_model->getTotalesIngresos($fechaini,$fechafin);
                $ventas = $this->ventas_model->getTotalesIngresosDetalle($fechaini,$fechafin);
                $totales = $this->ventas_model->getSumasIngresos($fechaini,$fechafin);
                $sucursales = $this->sucursal_model->viewSucursalActiva_Tipo(1);
                $array = array();
                $i=0;
                foreach($ventasFechas as $vn){
                    $day = "";
                    switch($vn->dia){
                        case 0:
                            $day = "DOM-";
                            break;
                        case 1:
                            $day = "LUN-";
                            break;
                        case 2:
                            $day = "MAR-";
                            break;
                        case 3:
                            $day = "MIE-";
                            break;
                        case 4:
                            $day = "JUE-";
                            break;
                        case 5:
                            $day = "VIE-";
                            break;
                        case 6:
                            $day = "SAB-";
                            break;
                        default:
                            $day = "";
                            break;
                    }
                    
                    $array[$i] = array(
                        "ID" => str_replace('-', '', $vn->fecha),
                        "Head_ID" =>0,
                        "encabezados" => $day.date_format(date_create($vn->fecha), 'd/m/Y'),
						"dia" => $vn->dia,
                    );
                    $sum_fecha = 0;
                    foreach($sucursales as $suc){
                        foreach($ventas as $vnFech){
                            if($suc->idcentro==$vnFech->idcentro && $vnFech->fecha ==$vn->fecha){
                                $array_detalle = array();
                                $array_detalle = array(
                                    "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($vnFech->totalVentas,2), 2, '.', ',')
                                );
                                $sum_fecha+=round($vnFech->totalVentas,2);
                                $array[$i] = array_merge($array[$i], $array_detalle);
                            }
                        }
                    }
                    $array_detalle = array(
                        "sumas" => "$".number_format(round($sum_fecha,2), 2, '.', ',')
                    );
                    $array[$i] = array_merge($array[$i], $array_detalle);
                    $i++;
                    
                    $getIngresos = $this->ventas_model->getIngresos($vn->fecha);
                    foreach($getIngresos as $ing){
                        $array[$i] = array(
                            "ID" =>str_replace('-', '', $ing->fecha).$ing->cajclase,
                            "Head_ID" => str_replace('-', '', $vn->fecha),
                            "encabezados" => $ing->formaPago,
							"dia" => $ing->dia,
                        );
                        $sum_horas = 0;
                        $getIngresosInfo = $this->ventas_model->getIngresosInfo($ing->fecha);
                        foreach($sucursales as $suc){
                            foreach($getIngresosInfo as $vnFech){
                                if($suc->idcentro==$vnFech->idcentro && $vnFech->cajclase == $ing->cajclase){
                                    $array_detalle = array();
                                    $array_detalle = array(
                                        "suc_".$suc->idcentro =>$this->session->userdata('simboloMoneda').number_format(round($vnFech->Promedio,2), 2, '.', ',')
                                    );
                                    $sum_horas += round($vnFech->Promedio,2);
                                    $array[$i] = array_merge($array[$i], $array_detalle);
                                }
                            }
                        }
                        $array_detalle = array(
                            "sumas" => $this->session->userdata('simboloMoneda').number_format(round($sum_horas,2), 2, '.', ',')
                        );
                        $array[$i] = array_merge($array[$i], $array_detalle);
                        $i++;
                    }
                    
                }
                
                
                $array[$i] = array(
                    "ID" =>"totales",
                    "Head_ID" => 0,
                    "encabezados" => "TOTALES",
                    "class"=>"totales",
                );
                $total_neto = 0;
                foreach($sucursales as $suc){
                    foreach($totales as $tot){
                        if($suc->idcentro==$tot->idcentro){
                            $array_detalle = array();
                            $array_detalle = array(
                                "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($tot->totalVentas,2), 2, '.', ',')
                            );
                            $total_neto += round($tot->totalVentas,2);
                            $array[$i] = array_merge($array[$i], $array_detalle);
                        }
                    }
                }
                $array_detalle = array(
                    "sumas" => $this->session->userdata('simboloMoneda').number_format(round($total_neto,2), 2, '.', ',')
                );
                $array[$i] = array_merge($array[$i], $array_detalle);
                $i++;
                
                $getIngresos = $this->ventas_model->getIngresosT($fechaini,$fechafin);
                    foreach($getIngresos as $ing){
                        $array[$i] = array(
                            "ID" =>"totales".$ing->cajclase,
                            "Head_ID" => "totales",
                            "encabezados" => $ing->formaPago,
                        );
                        $sum_horas = 0;
                        $getIngresosInfo = $this->ventas_model->getIngresosInfoT($fechaini,$fechafin);
                        foreach($sucursales as $suc){
                            foreach($getIngresosInfo as $vnFech){
                                if($suc->idcentro==$vnFech->idcentro && $vnFech->cajclase == $ing->cajclase){
                                    $array_detalle = array();
                                    $array_detalle = array(
                                        "suc_".$suc->idcentro => $this->session->userdata('simboloMoneda').number_format(round($vnFech->Promedio,2), 2, '.', ',')
                                    );
                                    $sum_horas += round($vnFech->Promedio,2);
                                    $array[$i] = array_merge($array[$i], $array_detalle);
                                }
                            }
                        }
                        $array_detalle = array(
                            "sumas" => $this->session->userdata('simboloMoneda').number_format(round($sum_horas,2), 2, '.', ',')
                        );
                        $array[$i] = array_merge($array[$i], $array_detalle);
                        $i++;
                    }
                echo json_encode($array);
            }
        }
        
        function getPieChart_CategoriasFecha(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $fecha = $this->input->post('fecha');
                $idcentro = $this->input->post('idcentro');
                
                $dateInput = explode('-',$fecha);
                $fechaini = $dateInput[2].'-'.$dateInput[1].'-'.$dateInput[0];
                
                
                
                $this->load->model('ventas_model');
                $data = $this->ventas_model->getCategoriasLineas($fechaini,$fechaini, $idcentro);
                $categorias = $this->ventas_model->getCate_ventas($fechaini,$fechaini, $idcentro);
                $pie = $this->ventas_model->getTotalesCategorias_consolidado($fechaini,$fechaini, $idcentro);

                $i1=0;
                $array1 = array();
                $i=0;
                $array2 = array();
                $k=0;
                $i1=0;
                foreach($data as $dat){
                    $array4 = array();
                    $arraycat[$i1]  = array();
                    $total = 0;
                    foreach($categorias as $cat){
                        $columna =  $cat->valueField;
                        $valor = $dat[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $total+=$tot;
                        $array4 = array(
                            $columna => round($tot,2)
                        );
                        $arraycat[$i1] = array_merge($arraycat[$i1], $array4);
                    } 
                   
                    $array2[$i1] = array(
                        "fecha" =>  $dat['fecha'],
                        "total"=> round($total,2)
                    );
                    $array1[$i1] = array_merge($array2[$i1],$arraycat[$i1]);
                      
                    $i1++;
                }
                
                
                $j=0;
                $i1=0;
                $array_pie = array();
                $array_data = array();
                $array4 = array();
                $total_categorias=0;

                foreach($pie as $in){
                    foreach($categorias as $cat){
                        $columna =  $cat->valueField;
                        $name =  $cat->name;
                        $valor = $in[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $total+=$tot;
                        $total_categorias+=$tot;
                        $array4 = array(
                            $columna => round($tot,2),
                            $name => $name,
                        );
                        $array_data = array_merge($array_data, $array4);
                    } 
                    
                    foreach($categorias as $cat){
                        $columna =  $cat->valueField;
                        $descrip =  $cat->name;
                        $valor = $in[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $tot= round($tot,2);
                        $array_pie[$j] = array(
                            "tipo" => $descrip,
                            "valor" => $tot,
                            "data" => $array_data,
                            "total_categorias" =>round($total_categorias,2)
                        );
                        $j++;
                    
                    }
                    
                }
                
                
                
                $array =  array(
                    "datos"=>$array1,
                    "pie"=>$array_pie
                );
                
                echo json_encode($array);
            }
        }
        
        function getPieChart_VendedoresFecha(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $fecha = $this->input->post('fecha');
                $idcentro = $this->input->post('idcentro');
                
                $dateInput = explode('-',$fecha);
                $fechaini = $dateInput[2].'-'.$dateInput[1].'-'.$dateInput[0];
                
                
                
                $this->load->model('ventas_model');
                $data = $this->ventas_model->getCategoriasLineas($fechaini,$fechaini, $idcentro);
                $categorias = $this->ventas_model->getCate_ventas($fechaini,$fechaini, $idcentro);
                $pie = $this->ventas_model->getTotalesCategorias_consolidado($fechaini,$fechaini, $idcentro);

                $i1=0;
                $array1 = array();
                $i=0;
                $array2 = array();
                $k=0;
                $i1=0;
                foreach($data as $dat){
                    $array4 = array();
                    $arraycat[$i1]  = array();
                    $total = 0;
                    foreach($categorias as $cat){
                        $columna =  $cat->valueField;
                        $valor = $dat[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $total+=$tot;
                        $array4 = array(
                            $columna => round($tot,2)
                        );
                        $arraycat[$i1] = array_merge($arraycat[$i1], $array4);
                    } 
                   
                    $array2[$i1] = array(
                        "fecha" =>  $dat['fecha'],
                        "total"=> round($total,2)
                    );
                    $array1[$i1] = array_merge($array2[$i1],$arraycat[$i1]);
                      
                    $i1++;
                }
                
                
                $j=0;
                $i1=0;
                $array_pie = array();
                $array_data = array();
                $array4 = array();
                $total_categorias=0;

                foreach($pie as $in){
                    foreach($categorias as $cat){
                        $columna =  $cat->valueField;
                        $name =  $cat->name;
                        $valor = $in[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $total+=$tot;
                        $total_categorias+=$tot;
                        $array4 = array(
                            $columna => round($tot,2),
                            $name => $name,
                        );
                        $array_data = array_merge($array_data, $array4);
                    } 
                    
                    foreach($categorias as $cat){
                        $columna =  $cat->valueField;
                        $descrip =  $cat->name;
                        $valor = $in[$columna];
                        if($valor==null){
                            $valor = 0;
                        }
                        $tot = abs($valor*1);
                        $tot= round($tot,2);
                        $array_pie[$j] = array(
                            "tipo" => $descrip,
                            "valor" => $tot,
                            "data" => $array_data,
                            "total_categorias" =>round($total_categorias,2)
                        );
                        $j++;
                    
                    }
                    
                }
                
                
                
                $array =  array(
                    "datos"=>$array1,
                    "pie"=>$array_pie
                );
                
                echo json_encode($array);
            }
        }
        
		function getListadoFormasDePago(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idpagos = $this->input->post('idpagos');
				
				$this->load->model('ventas_model');
				$informacion = $this->ventas_model->getFormasPagoVN('VN');
				
				$i=0;
				$array = array();
				
				foreach($informacion as $info){
					$find = strpos($idpagos, $info->cajclase);
					if($find === false){
						$array[$i] = array(
							"imagen" => $info->imagen,
							"cajclase" => $info->cajclase,
							"descrip" => $info->descrip,
							"alcuadre" => $info->alcuadre
						);
						$i++;
					}
				}
				
				echo json_encode($array);
			}
		}
		
		function crearArrayCorteX(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$datosGrid = $this->input->post('datosGrid');
                $cajclase = $this->input->post('cajclase');
                $descrip = $this->input->post('descrip');
                $totalmov = $this->input->post('totalmov');
                $total = $this->input->post('total');
				
				$i=0;
				$datos = array();
				$encontrado = 0;
				if($datosGrid != ""){
					$cont = count($datosGrid);
					for($i=0; $i<$cont; $i++){
						if($cajclase == $datosGrid[$i]['cajclase']){
							$encontrado = 1;
							$datos[$i] = array(
								"cajclase" => $datosGrid[$i]['cajclase'],
								"descrip" => $datosGrid[$i]['descrip'],
								"totalmov" => $totalmov,
								"total" => $total
							);
						}else{
							$datos[$i] = array(
								"cajclase" => $datosGrid[$i]['cajclase'],
								"descrip" => $datosGrid[$i]['descrip'],
								"totalmov" => $datosGrid[$i]['totalmov'],
								"total" => $datosGrid[$i]['total']
							);
						}
					}
				}
				
				if($encontrado == 0){
					$datos[$i] = array(
						"cajclase" => $cajclase,
						"descrip" => $descrip,
						"totalmov" => $totalmov,
						"total" => $total
					);
				}
				
				echo json_encode($datos);
			}
		}
		
		function insertarCorteX(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$fechaactual = $this->input->post('fechaactual');
				$idcentro = $this->input->post('idcentro');
				$idcaja = $this->input->post('idcaja');
				$datosPagos = $this->input->post('datosPagos');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->insertarRegistrosCorteX($fechaactual, $idcentro, $idcaja, $datosPagos);

				echo json_encode($array);
			}
		}

        //VERIFICA SI YA SE IMPRIMIO UN CORTE X
        function verificarImpresionCorteX(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcaja = $this->input->post('idcaja');
				$impreso = false;

				$this->load->model('ventas_model');

                $impreso = $this->ventas_model->verificarImpresionCorteX($idcaja);  
                
                //SI SE VERIFICA QUE YA SE IMPRIMIO
                //ACTUALIZA EL NUM X DE LA CAJA
                if($impreso){
                    $this->ventas_model->actualizarNumeroCorteX($idcaja);
                }

				echo json_encode($impreso);
			}
		}

        function actualizarNumeroCorteX(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcaja = $this->input->post('idcaja');
				
				$this->load->model('ventas_model');
			
                $numx = $this->ventas_model->actualizarNumeroCorteX($idcaja);    

				echo json_encode($numx);
			}
		}
		
		function getTipoModoCaja(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcaja = $this->input->post('idcaja');
				$idcentro = $this->input->post('idcentro');
				
				$this->load->model('ventas_model');
				$informacion = $this->ventas_model->getInformacionCajaFac($idcaja, $idcentro);
				
				if(strpos($informacion['notas'], '/') !== false){
					$datosPrint = explode("/", $informacion['notas']);
					$idPrint = $datosPrint[0];
					$namePrint = $datosPrint[1];
					$datosPrinter = 1;
				}else{
					$idPrint = "";
					$namePrint = ""; 
					$datosPrinter = ($informacion['notas'] == "") ? 0 : 1;
				}
				
				$array = array(
					'ucajera' => $informacion['ucajera'],
					'bfecha' => $informacion['bfecha'],
					'efecha' => $informacion['efecha'],
					'cajaopen' => $informacion['cajaopen'],
					'cajafecha' => $informacion['cajafecha'],
					'cajafondo' => $informacion['cajafondo'],
					'numx' => $informacion['numx'],
					'numz' => $informacion['numz'],
					'idprint' => $idPrint,
					'nameprint' => $namePrint,
					'datosPrinter' => $datosPrinter
				);
				
				echo json_encode($array);
			}
		}
		
		function crearAperturaDeCaja(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$idcaja = $this->input->post('idcaja');
				$fechaopen = $this->input->post('fechaopen');
				$observaciones = $this->input->post('observaciones');
				$fondocaja = $this->input->post('fondocaja');
				
				$this->load->model('ventas_model');
				$informacion = $this->ventas_model->insertAperturaDeCaja($idcentro, $idcaja, $fechaopen, $observaciones, $fondocaja);
				
				echo json_encode($informacion);
			}
		}
		
		function getInformacionTotalCortez(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$idcaja = $this->input->post('idcaja');
				$numz = $this->input->post('numz');
				
				$this->load->model('ventas_model');
				$informacion = $this->ventas_model->getInformacionTotalCorteZ($idcentro, $idcaja, $numz);
				
				$i=0;
				$array = array();
				foreach($informacion as $info){
					$array[$i] = array(
						"cajclase" => $info->cajclase,
						"descrip" => $info->descrip,
						"numx" => $info->numx,
						"total" => $info->total
					);
					
					$i++;
				}
				
				echo json_encode($array);
			}
		}
		
		function insertarCorteZ(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$fechaactual = $this->input->post('fechaactual');
				$idcentro = $this->input->post('idcentro');
				$idcaja = $this->input->post('idcaja');
				
				$this->load->model('ventas_model');
				$this->ventas_model->insertarRegistrosCorteZ($fechaactual, $idcentro, $idcaja);
                $this->ventas_model->actualizarCierreDeCaja($idcentro, $idcaja);
				$informacion = $this->ventas_model->getInformacionCajaFac($idcaja, $idcentro);
				
				$array = array(
					'numx' => $informacion['numx'],
					'numz' => $informacion['numz']
				);
				echo json_encode($array);
			}
		}
		
		function validateGenerateCorteX(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$fechaactual = $this->input->post('fechaactual');
				$idcentro = $this->input->post('idcentro');
				$idcaja = $this->input->post('idcaja');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->validateInsertCorteX($fechaactual, $idcentro, $idcaja);
				
				if($array == true){
					$this->ventas_model->insertAperturaGaveta($fechaactual, $idcentro, $idcaja);
				}
				
				echo json_encode($array);
			}
		}

        function validateIngresoCorteZ(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaactual = $this->input->post('fechaactual');
				$idcentro = $this->input->post('idcentro');
				$idcaja = $this->input->post('idcaja');
				
                $validate = 9;
				$this->load->model('ventas_model');
				$array = $this->ventas_model->validateInsertCorteX($fechaactual, $idcentro, $idcaja);
				if ( $array == true ) {
                    $array = $this->ventas_model->validateIngresoCorteZ($fechaactual, $idcentro, $idcaja);
                }else $validate = 0;

				if ( $array == true ) {
					$this->ventas_model->insertAperturaGaveta($fechaactual, $idcentro, $idcaja);
                    $validate = 1;
				}
				
				echo json_encode($validate);
            }
        }
		
		function getClientesConSucursal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcps = $this->input->post('idcps');
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
					$idcentro = $this->session->userdata('idcentroTemp');
				}else{
                    $idcentro = $this->session->userdata('idcentrouser');
				}
                
                $this->load->model('global_model');
                $this->load->model('ventas_model');
                
                $nombrevar = 'pos_grupocli0'.$idcentro;
				$grupoCliente = $this->global_model->getValorTextoVariable($nombrevar);
                
                if($grupoCliente == "0"){
                    $datos = $this->ventas_model->getListadoClientesPorSucursal($idcps, 1);
                }else{
                    $datos = $this->ventas_model->getListadoClientesPorSucursalGrupo($grupoCliente, 1);
                }
				
                $i=0;
                $array = array();
                
                if($datos != ""){
                    foreach($datos as $info){
                        $array[$i] = array(
                            'idauxi' => $info->idauxi,
                            'descrip' => $info->descrip,
                            'grupo' => $info->grupo,
                            'sucursal' => $info->sucursal,
                            'idcentrod' => $info->idrec,
                            'descripsearch' => $info->descripsearch,
                            'idrec' => $info->idrec,
                            'invclase' => $info->invclase,
                            'saldo' => $info->saldo
                        );
                        $i++;
                    }
                }
				
				echo json_encode($array);
			}
		}
		
		function getClientesConSucursalUpdate(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcps = $this->input->post('idcps');
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
					$idcentro = $this->session->userdata('idcentroTemp');
				}else{
                    $idcentro = $this->session->userdata('idcentrouser');
				}
                
                $this->load->model('global_model');
                $this->load->model('ventas_model');
                
                $nombrevar = 'pos_grupocli0'.$idcentro;
				$grupoCliente = $this->global_model->getValorTextoVariable($nombrevar);
                
                if($grupoCliente == "0"){
                    $datos = $this->ventas_model->getListadoClientesPorSucursalUpdate($idcps, 1);
                }else{
                    $datos = $this->ventas_model->getListadoClientesPorSucursalUpdateGrupo($grupoCliente, 1);
                }
                
                $i=0;
                $array = array();
                if($datos != ""){
                    foreach($datos as $info){
                        $array[$i] = array(
                            'idauxi' => $info->idauxi,
                            'descrip' => $info->descrip,
                            'grupo' => $info->grupo,
                            'sucursal' => $info->sucursal,
                            'idcentrod' => $info->idrec,
                            'descripsearch' => $info->descripsearch,
                            'idrec' => $info->idrec,
                            'saldo' => $info->saldo
                        );
                        $i++;
                    }
                }
				
				echo json_encode($array);
			}
		}
		
		function getClientesFacturacionUpdate(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcps = $this->input->post('idcps');
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
					$idcentro = $this->session->userdata('idcentroTemp');
				}else{
                    $idcentro = $this->session->userdata('idcentrouser');
				}
                
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getClientesFacturacionUpdate($idcps, 1);
                
                $i=0;
                $array = array();
                if($datos != ""){
                    foreach($datos as $info){
                        $array[$i] = array(
                            'idauxi' => $info->idauxi,
                            'descrip' => $info->descrip,
                            'descripsearch' => $info->descrip.' '.$info->nit.' '.$info->nrc.' '.$info->dui,
                            'grupo' => $info->grupo,
                            'idrec' => 0
                        );
                        $i++;
                    }
                }
				
				echo json_encode($array);
			}
        }
        
        function getClientesBusquedaFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcps = $this->input->post('idcps');
				$valor = $this->input->post('valor');
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
					$idcentro = $this->session->userdata('idcentroTemp');
				}else{
                    $idcentro = $this->session->userdata('idcentrouser');
				}
                
                $this->load->model('ventas_model');
                $informacion = $this->ventas_model->getClientesBusquedaFacturacion($idcps, $valor, 1);
                
                $i=0;
                $dataSource = array();
                if($informacion != ""){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            'idauxi' => $info->idauxi,
                            'descrip' => $info->descrip,
                            'nrc' => $info->nrc,
                            'direccion' => $info->direccion,
                            'direccion_c' => $info->direccion_c,
                            'descripsearch' => $info->descrip,
                            'grupo' => $info->grupo,
                            'idrec' => $info->idrec
                        );
                        $i++;
                    }
                }

                $array = array(
                    "informacion" => $dataSource,
                    "resultados" => $i
                );
				
				echo json_encode($array);
			}
        }
        
        function getClientesBusquedaCreacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcps = $this->input->post('idcps');
				$valor = $this->input->post('valor');
                                
                $this->load->model('ventas_model');
                $informacion = $this->ventas_model->getClientesBusquedaCreacion($idcps, $valor, 1);
                
                $i=0;
                $dataSource = array();
                if($informacion != ""){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            'idauxi' => $info->idauxi,
                            'descrip' => $info->descrip,
                            'nrc' => $info->nrc,
                            'nit' => $info->nit,
                            'dui' => $info->dui,
                            'telefono' => $info->telefono,
                            'correo' => $info->correo,
                            'idtipo' => (int) $info->idtipo,
                            'idzip' => $info->idzip,
                            'giro' => $info->giro,
                            'dte_giro' => $info->dte_giro,
                            'direccion' => $info->direccion,
                            'direccion_c' => $info->direccion_c,
                            'descripsearch' => $info->descrip,
                            'grupo' => $info->grupo,
                            'idrec' => $info->idrec
                        );
                        $i++;
                    }
                }

                $array = array(
                    "informacion" => $dataSource,
                    "resultados" => $i
                );
				
				echo json_encode($array);
			}
        }
        
        function getClientePredeterminado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcps    = $this->input->post('idcps');
				$idcentro = $this->input->post('idcentro');
                                
                $this->load->model('ventas_model');
                $informacion = $this->ventas_model->getClientePredeterminado($idcps, $idcentro, 1);
                
                $i=0;
                $dataSource = array();
                if($informacion != ""){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            'idauxi' => $info->idauxi,
                            'descrip' => $info->descrip,
                            'nrc' => $info->nrc,
                            'nit' => $info->nit,
                            'dui' => $info->dui,
                            'telefono' => $info->telefono,
                            'correo' => $info->correo,
                            'idtipo' => (int) $info->idtipo,
                            'idzip' => $info->idzip,
                            'giro' => $info->giro,
                            'dte_giro' => $info->dte_giro,
                            'direccion' => $info->direccion,
                            'direccion_c' => $info->direccion_c,
                            'descripsearch' => $info->descrip,
                            'grupo' => $info->grupo,
                            'idrec' => $info->idrec
                        );
                        $i++;
                    }
                }

                $array = array(
                    "informacion" => $dataSource,
                    "resultados" => $i
                );
				
				echo json_encode($array);
			}
        }
        
		function listadoCortesImpresiones(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$idcaja = $this->input->post('idcaja');
				
                $this->load->model('ventas_model');
				$datos = $this->ventas_model->getListadoCortesImpresiones($idcentro, $idcaja);
                
                $i=0;
                $array = array();
                foreach($datos as $info){
					if($info->tipo == 1){
						$descrip = "Corte X";
					}else if($info->tipo == 2){
						$descrip = "Corte Z";
					}else{
						$descrip = $info->descrip;
					}
                    $array[$i] = array(
						'hora' => $info->hora,
						'descrip' => $descrip,
						'idcentro' => $info->idcentro,
						'idcaja' => $info->idcaja,
                        'numx' => $info->numx,
                        'numz' => $info->numz,
                        'tipo' => $info->tipo,
                        'fecha' => $info->fecha
                    );
                    $i++;
                }
				
				echo json_encode($array);
			}
		}
        
        function getDirecMulti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');
                $this->load->model('auximulti_model');
                $this->load->model('auxi_model');
                $this->load->model('ventas_model');
                
                $array = $this->auximulti_model->viewAuximulti($idcps);
                $direccion_cliente = $this->auxi_model->getDirecAuxi($idcps);
                $last_venta = $this->ventas_model->getLastVenta($idcps);
                
                $infoCliente = $this->auxi_model->getInfoAuxi($idcps);
                $nombre = $infoCliente['descrip'];
                $correo = $infoCliente['correo'];
                
                $direcciones = array();
                $i=0;
                foreach($array as $a){
                    if($a->idgvar==2){
                        $direcciones[$i] = array(
                            "id"=>$a->idrec,
                            "descrip"=>$a->descrip
                        );        
                        $i++;
                    }
                }
                
                if($i==0){
                    if($direccion_cliente!=""){
                        $direcciones[$i] = array(
                            "id"=>"999999",
                            "descrip"=>$direccion_cliente
                        );        
                        $i++;
                    }
                }
                
                
                if($i==0){
                    $direcciones=null;
                }
                if($last_venta!=false){
                    $direccion="";
                    $tipodoc="";
                    $formapago="";
                    $vendedor="";
                    $referencia="";
                    $notas="";
                    foreach($last_venta as $last){
                        $tipodoc= $last->cli_notify;
                        $formapago=$last->cajclase;
                        $vendedor=$last->idworker;
                        $referencia=$last->referencia;
                        $notas=$last->notas;
                        $direccion=$last->dev_place;
                    }
                    $array_info = array (
                        "direcciones" =>$direcciones,
                        "tipodoc" =>$tipodoc,
                        "formapago" =>$formapago,
                        "vendedor" =>$vendedor,
                        "referencia" =>$referencia,
                        "notas" =>$notas,
                        "direccion" =>$direccion,
                        "nombre" => trim($nombre),
                        "correo" => trim($correo)
                    );
                }else{
                    $array_info = array (
                        "direcciones" =>$direcciones,
                        "tipodoc" =>null,
                        "formapago" =>null,
                        "vendedor" =>null,
                        "referencia" =>null,
                        "notas" =>null,
                        "direccion" =>null,
                        "nombre" => trim($nombre),
                        "correo" => trim($correo)
                    );
                }
                echo json_encode($array_info);
            }
        }
        
        function getDirecMultiUpdate(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $descrip = $this->input->post('descrip');
                $idcps = intval($this->input->post('id'));
                $this->load->model('auximulti_model');
                $this->load->model('auxi_model');
                $this->load->model('ventas_model');
                
                //$idcps = $this->auxi_model->getCodigoClienteByDescrip($descrip);
                
                if($idcps != false){
                    $array = $this->auximulti_model->viewAuximulti($idcps);
                    $direccion_cliente = $this->auxi_model->getDirecAuxi($idcps);
                    $last_venta = $this->ventas_model->getLastVenta($idcps);

                    $infoCliente = $this->auxi_model->getInfoAuxi($idcps);
                    $nombre = $infoCliente['descrip'];
                    $correo = $infoCliente['correo'];

                    $direcciones = array();
                    $i=0;
                    foreach($array as $a){
                        if($a->idgvar==2){
                            $direcciones[$i] = array(
                                "id"=>$a->idrec,
                                "descrip"=>$a->descrip,
                                "otro"=> $a->otro
                            );        
                            $i++;
                        }
                    }

                    if($i==0){
                        if($direccion_cliente!=""){
                            $direcciones[$i] = array(
                                "id"=>"999999",
                                "descrip"=>$direccion_cliente
                            );        
                            $i++;
                        }
                    }

                    if($i==0){
                        $direcciones=null;
                    }

                    if($last_venta!=false){
                        $direccion=""; $tipodoc=""; $formapago="";
                        $vendedor=""; $referencia=""; $notas="";

                        foreach($last_venta as $last){
                            $tipodoc= $last->cli_notify;
                            $formapago=$last->cajclase;
                            $vendedor=$last->idworker;
                            $referencia=$last->referencia;
                            $notas=$last->notas;
                            $direccion=$last->dev_place;
                        }

                        $array_info = array (
                            "idcps" => $idcps,
                            "direcciones" =>$direcciones,
                            "tipodoc" =>$tipodoc,
                            "formapago" =>$formapago,
                            "vendedor" =>$vendedor,
                            "referencia" =>$referencia,
                            "notas" =>$notas,
                            "direccion" =>$direccion,
                            "nombre" => trim($nombre),
                            "correo" => trim($correo),
                            "error" => 0
                        );
                    }else{
                        $array_info = array (
                            "idcps" => $idcps,
                            "direcciones" =>$direcciones,
                            "tipodoc" =>null,
                            "formapago" =>null,
                            "vendedor" =>null,
                            "referencia" =>null,
                            "notas" =>null,
                            "direccion" =>null,
                            "nombre" => trim($nombre),
                            "correo" => trim($correo),
                            "error" => 0
                        );
                    }
                }else{
                    $array_info = array(
                        "error" => 1
                    );
                }
                
                
                echo json_encode($array_info);
            }
        }
        
		function getListadoLineasOrdenesVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$tipopro = $this->input->post('tipopro');
				
                $this->load->model('compras_model');
				$lineas = $this->compras_model->getGruposOrdenCompra($tipopro);
                $cantid = $this->compras_model->getCantidadesCatalogoCompra($idtrannum, $tipopro);
                
                $i=0;
				$array = array();
				
				foreach($lineas as $data){
					foreach($cantid as $cant){
						if($data->idcatalogo == $cant->idcatalogo){
							$array[$i] = array(
								"idcatalogo" => $data->idcatalogo,
								"imagen" => trim($data->imagen),
								"descrip" => trim($data->descrip),
								"total" => $cant->cantidad
							);
						}		
					}
					$i++;
				}
				
                echo json_encode($array);
			}
		}
        
        function getDatosSearchOrdenes(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');
                $tipopro = $this->session->userdata('compras_tipopro');
                
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
                $detalle = $this->ventas_model->getDatosProductoSearchOrdenes($prosearch, $dato, $idcentro, $trannum, $tipopro);
                if($detalle != 0){
                    $i=0;
                    $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
						//validacion duplicidad
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "umorders" => $info->umorders,
                            "uniconv" => $info->uniconv,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "tipo" => (int)$info->tipo,
                            "namecatalogo" => $info->namecatalogo,
                            "precio" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "agregado" => $info->existe,
                        );
                        $i++;
                        if($info->existe == 1){
                            $agregado=1;
                        }   
                    }
                    $agregado = 0;
                    if($agregado == 1 && $i == 1){
						$datos = $this->compras_model->getDataOrders100Producto($trannum, $idcentro, $info->idproducto);
						$array = array(
                            "error" => "2",
							"datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
		}
        
		function getListadoProductosTipo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $tipopro = $this->input->post('tipopro');
                $idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('compras_model');
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, $tipopro);
				
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    //validacion duplicidad compras locales
                    $datos[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "tipotax" => $info->tipotax,
                        "tipo" => (int)$info->tipo,
                        "precio" => $info->precioventa,
                        "costouni" => $info->costouni
                    );
                    $i++;
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i,
                );
                echo json_encode($array);
			}
		}
        
        function verificar_ordenVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
				
                $data = $this->ventas_model->verifica_Orden($trannum);
				$list_productos = $this->compras_model->getDetail_products($trannum);
				$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
				
				$exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;
				$percepcion = 0;
				
                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        
                        if($key->tipotax==0){
                            $subtotal = $key->cantidad * $key->precioneto; 
                            $exento = $exento + $subtotal;
                        }else if($key->tipotax==13){
                            $subtotal = $key->cantidad * $key->precioneto; 
                            $gravado += $subtotal;      
                            $iva =  $iva + ($subtotal * ($key->tipotax/100));
                        }
                        $sub_total = $exento + $gravado + $iva;
                    }
                }
                $total = $sub_total;
               
				$array = array(
					"validate" => $data,
					"exento" => $exento,
					"gravado" => $gravado,
					"iva" => $iva,
					"percepcion" => $percepcion,
					"total" => $total
				);
				
                echo json_encode($array);
            } 
        }
        
        function validacionCotizacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $doc_exento = $this->input->post('exento');
                $trannum = $this->input->post('trannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
				
                $data = $this->ventas_model->verifica_Orden($trannum);
				$list_productos = $this->compras_model->getDetail_products($trannum);
				$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
				
				$exento = 0; $gravado = 0; $iva = 0;
                $total = 0; $sub_total = 0; $percepcion = 0; $descuento = 0;
				
                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        if($doc_exento == 1){
                            $subtotal = $key->cantidad * ($key->precioneto - ($key->precioneto * ($key->descuento/100)));
                            $descuento = $descuento + ($key->cantidad * ($key->precioneto * ($key->descuento / 100)));
                            $exento = $exento + $subtotal;
                        }else{
                            if($key->tipotax==0){
                                $subtotal = $key->cantidad * ($key->precioneto - ($key->precioneto * ($key->descuento/100)));
                                $descuento = $descuento + ($key->cantidad * ($key->precioneto * ($key->descuento / 100)));
                                $exento = $exento + $subtotal;
                            }else if($key->tipotax==13){
                                $subtotal = $key->cantidad * ($key->precioneto - ($key->precioneto * ($key->descuento/100))); 
                                $gravado += ($subtotal / (1+($key->tipotax / 100)));
                                $descuento = $descuento + ($key->cantidad * ($key->precioneto * ($key->descuento / 100)));
                                $iva =  $iva + ($subtotal - ($subtotal / (1+($key->tipotax / 100))));
                            }
                        }
                        
                        $sub_total = $sub_total + $key->cantidad * $key->precioneto;
                        
                        $total = $exento + $gravado + $iva;
                    }
                }
                
				$array = array(
					"validate" => $data,
					"exento" => $exento,
					"gravado" => $gravado,
					"iva" => $iva,
					"percepcion" => $percepcion,
					"descuento" => $descuento,
					"subtotal" => $sub_total,
					"total" => $total
				);
				
                echo json_encode($array);
            } 
        }
        
        function editarVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $fechaingreso = $this->input->post('fechaingreso');
                $notas = trim($this->input->post('notas'));
                $vendedor = $this->input->post('vendedor');
                $tipodocumento = $this->input->post('tipodocumento');
                $formapago = $this->input->post('formapago');
                $fechaentrega = $this->input->post('fechaentrega');
                $lugarentrega = $this->input->post('lugarentrega');
                $referencia = $this->input->post('referencia');
                $estado = $this->input->post('estado');
                $valorTotal = $this->input->post('valorTotal');
                $valordescuento = $this->input->post('valordescuento');
                $retencionTotal = $this->input->post('retencionTotal');
                $this->load->model('ventas_model');
                $query =  $this->ventas_model->updateDatosO_Venta($trannum, $fechaingreso, $vendedor, $tipodocumento, $formapago, $fechaentrega, $lugarentrega, $referencia, $notas, $estado, $valorTotal, $retencionTotal, $valordescuento);
				
                echo json_encode($query);
            }
        }
        #-------------- GET EMPLEADOS
        public function getEmpleados()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->load->model('empleado_model');
                $Datos = [];
                $datos = $this->empleado_model->viewEmple();
                if (count((array)$datos) > 0) {
                    foreach ($datos as $dato) {
                        $Datos[] = array(
                            'ID' => (int)$dato->idauxi,
                            'Name' => $dato->descrip
                        );
                    }
                }
                $datA[] = array('valido' => true, 'datos' => $Datos);
                echo json_encode($datA);
            }
        }
        function updateInformacionCotizacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $trannum = $this->input->post('trannum');
                $dirigido = trim($this->input->post('dirigido'));
                $correo = $this->input->post('correo');

                $data = array(
                    'cli_email' => $correo,
                    'dev_contact' => $dirigido,
                    'fecha' => $this->input->post('fecha'),
                    'dev_date' => $this->input->post('fecha'),
                    'idworker' => (int)$this->input->post('vendedor'),
                    'referencia' => trim($this->input->post('referencia')),
                    'notas' => trim($this->input->post('notas')),
                    'whodidit' => $this->session->userdata('iduser'),
                    'modifica' => $date->format('Y-m-d H:i:s'),
                );
                //print_r($data);
                //die();
                
                $this->load->model('ventas_model');
                //$query =  $this->ventas_model->updateInformacionCotizacion($trannum, $dirigido, $correo);
                if ($this->ventas_model->updateCotizacion($trannum, $data)) $query = true;
                else $query = false;
				
                echo json_encode($query);
            }
        }
        
        function getDataProductosOrden100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->getDatosOrden100k($idtrannum, $idcentro);
                foreach($array as $key=>$value){
                    $value->subtotal = number_format($value->cantidad * $value->preciotran,2,'.','');
                    $value->preciotran = number_format($value->preciotran, 6,'.','');

                }
				echo json_encode($array);
			}
		}
        
        function getStockProduct(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $this->load->model('invtran_model');
                $sucursales  = $this->invtran_model->get_stock_suc($idproducto);
                $array = array();
                $i=0;
                foreach($sucursales as $suc){
                    if($suc->cantidad>0){
                        $array[$i] = array(
                            "descrip"=>$suc->descrip,
                            "cantidad"=>$suc->cantidad,
                        );
                        $i++;    
                    }
                }
				echo json_encode($array);
			}
		}
        
        function getProductsLines(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                
                $itemline = $this->ventas_model->getLastItemLine($trannum);
                $sucursales = $this->invtran_model->get_stock_suc($idproducto);
                $i=0;
                $sucursales_array = array();
                foreach($sucursales as $suc){
                    //if($suc->cantidad > 0){
                        $sucursales_array[$i] = array(
                            "descrip" => $suc->descrip,
                            "cantidad" => $suc->cantidad,
                        );
                        $i++;    
                    //}
                }
                
                $array = array(
                    "kardex" => $sucursales_array,
                    "itemline" => $itemline
                );
				echo json_encode($array);
			}
		}
        
        function insertProductO100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$itemline = $this->input->post('itemline');
                $idcatalogo = $this->input->post('idcatalogo');
                $idproducto = $this->input->post('idproducto');
                $cantidad = $this->input->post('cantidad');
                $descuento= $this->input->post('descuento');
                $precio = $this->input->post('precio');
                $tipotax = $this->input->post('tipotax');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $notas = trim($this->input->post('notas'));
                $idcentro = $this->session->userdata('idcentrouser');
                $tipopro = $this->session->userdata('compras_tipopro');
                #   ACTULIZAR DESCRIPCION ORDERS 100K
                $tipo = (int)$this->input->post("tipoP");
                $NDescrip = $this->input->post("NDescrip");
                //-
                
                $this->load->model('compras_model');
                $this->load->model('ventas_model');
				
                $e = 0;
                $this->ventas_model->insertProOrders100kDescrip($idtrannum, $idproducto, $cantidad, $um, $uniconv, $precio, $tipotax, $notas,$itemline, $descuento, $NDescrip);

                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, $tipopro);
                $datos = $this->ventas_model->getDatosOrden100k($idtrannum,$idcentro);

                $i=0;
                $items = array();
                foreach($detalle as $info){
					//validacion duplicidad
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "tipotax" => $info->tipotax,
                        "tipo" => (int)$info->tipo,
                        "precio" => $info->precioventa,
                        "costouni" => $info->costouni
                    );
                    $i++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "e" => $e
                );
                
                echo json_encode($array);
			}
		}
        
		function updateOrders100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                $tipopro = $this->session->userdata('compras_tipopro');
                $cantidad = $this->input->post('cantidad');
                $descuento = $this->input->post('descuento');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $notas = trim($this->input->post('notas'));
                $precio = $this->input->post('precio');
                $itemline = $this->input->post('itemline');
                #   ACTULIZAR DESCRIPCION ORDERS 100K
                $tipo = (int)$this->input->post("tipoP");
                $NDescrip = $this->input->post("NDescrip");
                $olditemline = $this->input->post("olditemline");
                //-
                
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
                $this->load->model('dev_model');

                $this->dev_model->updateProdOrders100k($idtrannum, $idrec, $cantidad, $precio, $notas, $um, $uniconv, $itemline, $descuento, $olditemline);
                $e = 0;
                date_default_timezone_set('America/El_Salvador');
                $data = array(
                    'descrip' => $NDescrip,
                    'whodidit' => $this->session->userdata('iduser'),
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                $e = $this->ventas_model->UMDescripOrder100k($idrec, $data);
                $e = ($e) ? 1 : -1;//*/
				
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, $tipopro);
                $datos = $this->ventas_model->getDatosOrden100k($idtrannum,$idcentro);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "tipotax" => $info->tipotax,
                        "precio" => $info->precioventa,
                        "costouni" => $info->costouni
                    );
                    $i++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "e" => $e
                );
                
                echo json_encode($array);
			}
		}
        
        function deleteRegistroOrders(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                $tipopro = $this->session->userdata('compras_tipopro');
                
                $this->load->model('compras_model');
                $this->load->model('ventas_model');
                $this->compras_model->deleteDataOrders100($idtrannum, $idrec);
                
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, $tipopro);
                $datos = $this->ventas_model->getDatosOrden100k($idtrannum,$idcentro);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    //validacion duplicidad
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "tipotax" => $info->tipotax,
                        "precio" => $info->precioventa,
                        "costouni" => $info->costouni
                    );
                    $i++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                );
                                
                echo json_encode($array);
            }
		}
		
        function getAnexos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $array = array();
                $i=0;
                $this->load->model('ventas_model');
                $this->load->model('variable_model');
                $gvars = $this->variable_model->getVariablesNombre('so_anexos');
                $cant_ = $this->ventas_model->getCantAnexos($trannum);
                $cant_ = $cant_+1;
                foreach($gvars as $vars){
                    $hijos = $this->ventas_model->getAnexosHijosTipo(round($vars->valor_num));
                    
                    $array_hijos = array();
                    $j=0;
                    foreach($hijos as $hij){
                        $array_hijos[$j] = array(
                            "id" => round($vars->valor_num)."_".$hij->idrec,
                            "text" => $hij->descrip,
                            "padre" => $vars->descripcion,
                            "tipo" => $hij->tipo,
                            "notas" => $hij->notas,
                            "parentId"=>$hij->tipo,
                            "next_pos" =>$cant_
                        );
                        $j++;
                    }
                    $array[$i] = array(
                        "id" => round($vars->valor_num),
                        "text" =>$vars->descripcion,
                        "expanded" => false,
                        "tipo" => round($vars->valor_num),
                        "parentId"=>"0",
                        "items" =>$array_hijos
                    );
                    $i++;
                    
                }
                $detalle = $this->ventas_model->getAnexosHijos($trannum);
                $info = array(
                    "padres"=>$array,
                    "detalle"=>$detalle,
                );
                echo json_encode($info);
            }
        }
        
        function insertAnexo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $tipo = $this->input->post('tipo');
                $titulo = $this->input->post('titulo');
                $descrip = $this->input->post('descrip');
                $posicion = $this->input->post('posicion');
                $notas = $this->input->post('notas');

                
                $this->load->model('ventas_model');
                $this->load->model('variable_model');
                $insert = $this->ventas_model->insertAnexo($trannum,$tipo,$descrip,$posicion, $notas);
                $cant_ = $this->ventas_model->getCantAnexos($trannum);
                $cant_ = $cant_+1;
                $array = array();
                $i=0;
                $gvars = $this->variable_model->getVariablesNombre('so_anexos');
                foreach($gvars as $vars){
                    $hijos = $this->ventas_model->getAnexosHijosTipo(round($vars->valor_num));
                    
                    $array_hijos = array();
                    $j=0;
                    foreach($hijos as $hij){
                        $array_hijos[$j] = array(
                            "id" => round($vars->valor_num)."_".$hij->idrec,
                            "text" => $hij->descrip,
                            "padre" => $vars->descripcion,
                            "tipo" => $hij->tipo,
                            "notas" => $hij->notas,
                            "parentId"=>$hij->tipo,
                            "next_pos" =>$cant_
                        );
                        $j++;
                    }
                    if($tipo==round($vars->valor_num)){
                        $expand = true;
                    }else{
                        $expand = false;
                    }
                    $array[$i] = array(
                        "id" => round($vars->valor_num),
                        "text" =>$vars->descripcion,
                        "expanded" => $expand,
                        "tipo" => round($vars->valor_num),
                        "parentId"=>"0",
                        "items" =>$array_hijos
                    );
                    $i++;
                    
                }
                $detalle = $this->ventas_model->getAnexosHijos($trannum);
                $info = array(
                    "padres"=>$array,
                    "detalle"=>$detalle,
                );
                echo json_encode($info);
            }
            
        }
        
        function updateAnexo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $idrec = $this->input->post('idrec');
                $tipo = $this->input->post('tipo');
                $descrip = $this->input->post('descrip');
                $posicion = $this->input->post('posicion');
                $notas = $this->input->post('notas');

                $this->load->model('ventas_model');
                $this->load->model('variable_model');
                $cant_ = $this->ventas_model->getCantAnexos($trannum);
                $cant_ = $cant_+1;
                $update = $this->ventas_model->updateAnexo($trannum,$idrec,$tipo,$descrip,$posicion,$notas);
                $array = array();
                $i=0;
                $gvars = $this->variable_model->getVariablesNombre('so_anexos');
                foreach($gvars as $vars){
                    $hijos = $this->ventas_model->getAnexosHijosTipo(round($vars->valor_num));
                    
                    $array_hijos = array();
                    $j=0;
                    foreach($hijos as $hij){
                        $array_hijos[$j] = array(
                            "id" => round($vars->valor_num)."_".$hij->idrec,
                            "text" => $hij->descrip,
                            "padre" => $vars->descripcion,
                            "tipo" => $hij->tipo,
                            "notas" => $hij->notas,
                            "parentId"=>$hij->tipo,
                            "next_pos" =>$cant_
                        );
                        $j++;
                    }
                    if($tipo==round($vars->valor_num)){
                        $expand = true;
                    }else{
                        $expand = false;
                    }
                    $array[$i] = array(
                        "id" => round($vars->valor_num),
                        "text" =>$vars->descripcion,
                        "expanded" => $expand,
                        "tipo" => round($vars->valor_num),
                        "parentId"=>"0",
                        "items" =>$array_hijos
                    );
                    $i++;
                    
                }
                $detalle = $this->ventas_model->getAnexosHijos($trannum);
                $info = array(
                    "padres"=>$array,
                    "detalle"=>$detalle,
                );
                echo json_encode($info);
            }
            
        }
        
        function deleteAnexo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $tipo = $this->input->post('tipo');
                $idrec = $this->input->post('idrec');
                
                $this->load->model('ventas_model');
                $this->load->model('variable_model');
                $delete = $this->ventas_model->deleteAnexo($idrec);
                
                $cant_ = $this->ventas_model->getCantAnexos($trannum);
                $cant_ = $cant_+1;
                $array = array();
                $i=0;
                $gvars = $this->variable_model->getVariablesNombre('so_anexos');
                foreach($gvars as $vars){
                    $hijos = $this->ventas_model->getAnexosHijosTipo(round($vars->valor_num));
                    $array_hijos = array();
                    $j=0;
                    foreach($hijos as $hij){
                        $array_hijos[$j] = array(
                            "id" => round($vars->valor_num)."_".$hij->idrec,
                            "text" => $hij->descrip,
                            "padre" => $vars->descripcion,
                            "tipo" => $hij->tipo,
                            "notas" => $hij->notas,
                            "parentId"=>$hij->tipo,
                            "next_pos" =>$cant_
                        );
                        $j++;
                    }
                    if($tipo==round($vars->valor_num)){
                        $expand = true;
                    }else{
                        $expand = false;
                    }
                    $array[$i] = array(
                        "id" => round($vars->valor_num),
                        "text" =>$vars->descripcion,
                        "expanded" => $expand,
                        "tipo" => round($vars->valor_num),
                        "parentId"=>"0",
                        "items" =>$array_hijos
                    );
                    $i++;
                    
                }
                $detalle = $this->ventas_model->getAnexosHijos($trannum);
                $info = array(
                    "padres"=>$array,
                    "detalle"=>$detalle,
                );
                echo json_encode($info);
            }
        }
        
        function getTiposAnexos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('variable_model');
                $info = $this->variable_model->getVariablesNombre('so_anexos');
                echo json_encode($info);
            }
        }
        
        function getAnexosHijos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $tipo = $this->input->post('tipo');
                $this->load->model('ventas_model');
                $hijos = $this->ventas_model->getAnexosHijosTipo($tipo);
                echo json_encode($hijos);
            }
        }
        
        function insertEncabezadoAnexo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = 0;
                $tipo = $this->input->post('tipo');
                $titulo = $this->input->post('titulo');
                $descrip = $this->input->post('descrip');
                $posicion = 0;
                
                $this->load->model('ventas_model');
                $insert = $this->ventas_model->insertAnexo($trannum,$tipo,$titulo,$posicion, $descrip);
                $hijos = $this->ventas_model->getAnexosHijosTipo($tipo);
                echo json_encode($hijos);
            }
        }
        
        function updateEncabezadoAnexo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{
                $trannum = 0;
                $idrec = $this->input->post('idrec');
                $tipo = $this->input->post('tipo');
                $titulo = $this->input->post('titulo');
                $descrip = $this->input->post('descrip');
                $posicion =0;
                $this->load->model('ventas_model');
                $update = $this->ventas_model->updateAnexo($trannum,$idrec,$tipo,$titulo,$posicion,$descrip);
                $hijos = $this->ventas_model->getAnexosHijosTipo($tipo);
                echo json_encode($hijos);
            }
		}
        
		function canjes($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getOptionsByidapp($idApp);
                
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcionmenu' => $opcionmenu
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('global_model');
				$this->load->model('sucursal_model');
				$this->load->model('cliente_model');
				
				$funcion = $this->uri->segment(1);
                $direccion = $funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
				$this->data['clientes'] = $this->cliente_model->viewClienteActivo();
				
				$this->load->view('mantenimiento_canjes', $this->data);
			}
		}
		
		function getListadoCanjesProductos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				
				$this->load->model('ventas_model');
				$informacion = $this->ventas_model->getListaCanjesProductos($idcentro, 'CA');
				
				$i=0; $dataSource = array();
				
				if($informacion != false){
					foreach($informacion as $info){
						$dataSource[$i] = array(
							'trannum' => $info->trannum,
							'fecha' => $info->fecha,
							'descrip' => $info->descrip,
							'estatus' => $info->estatus,
							'val_pro' => $info->val_pro * 1,
							'val_tot' => $info->val_tot * 1,
							'val_anti' => $info->val_anti * 1
						);

						$i++;
					}
				}
				
				$array = array('dataSource' => $dataSource);
				
				echo json_encode($array);
			}
		}
		
		function insertNuevoCanje(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$idauxi = $this->input->post('idcliente');
				$fecha = $this->input->post('fecha');
				$observaciones = $this->input->post('observaciones');
				
				$idcentro_session = array(
                    'idcentro_session_canje' => $idcentro
                );
                $this->session->set_userdata($idcentro_session);
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->insertarNuevoCanje($idcentro, $idauxi, $fecha, $observaciones, 'CA');
				
				echo json_encode($array);
			}
		}
		
		function detalle_canjes($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('arap_model');
                
                $funcion = $this->uri->segment(1);
                $direccion = $funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $informacion = $this->ventas_model->getInformacionDetalleCanje($trannum);
                $this->data['informacion'] = $informacion;
				
				foreach($informacion as $info){
					$idcentro = $info->idcentro;
				}
				
				$idcentro_session = array(
                    'idcentro_session_canje' => $idcentro
                );
                $this->session->set_userdata($idcentro_session);
				
                $this->data['formaspago'] = $this->arap_model->formasPago_ar(-1);
                $this->data['formascargopago'] = $this->arap_model->formasPagoCargoDefault();
				$this->load->view('mantenimiento_detalle_canjes', $this->data);
			}
		}
		
		function getDatosProductosCanjeados(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$idcliente = $this->input->post('idcliente');
				$idcentro = $this->input->post('idcentro');
				
				$this->load->model('ventas_model');
				$datos_vendidos = $this->ventas_model->getInventarioProductosVendidos($idcliente);
				$datos_canjeados = $this->ventas_model->getListadoProductosCanjeados($trannum);
				$datos_entregados = $this->ventas_model->getListadoProductosEntregados($trannum, $idcentro);
				
                $i=0;
                $datosVendidos = array();
                foreach($datos_vendidos as $info_ven){
                    $precioneto = $info_ven->preciotran;
                    $valorDisponible = $info_ven->cantidad;
                    
                    if($info_ven->descuento != 0){
                        $valorDescuento = $precioneto * ($info_ven->descuento / 100);
                        $precioneto = $precioneto - $valorDescuento;
                    }
                    
					$precioneto = number_format($precioneto, 2, '.', ',');
					
                    if($datos_canjeados != false){
                        foreach($datos_canjeados as $info_can){
                            if($info_ven->idproducto == $info_can->idproducto && $precioneto == number_format($info_can->precioneto, 2, '.', ',')){
                                $valorDisponible = $valorDisponible - $info_can->cantidad;
                            }    
                        }
                    }
                    
                    if($valorDisponible > 0){
                        $datosVendidos[$i] = array(
                            "idproducto" => $info_ven->idproducto,
                            "nameproducto" => $info_ven->nameproducto,
                            "namemodelo" => $info_ven->namemodelo,
                            "modelo" => $info_ven->modelo,
                            "um" => $info_ven->um,
                            "idbin" => $info_ven->idbin,
                            "idbatch" => $info_ven->idbatch,
                            "descuento" => $info_ven->descuento,
                            "preciotran" => $precioneto,
                            "cantidad" => $valorDisponible,
                            "imagen" => $info_ven->imagen
                        );
                        $i++;
                    }
                }
                
				$array = array(
					"datos_canjeados" => $datos_canjeados,
					"datos_vendidos" => $datosVendidos,
					"datos_entregados" => $datos_entregados
				);
				
				echo json_encode($array);
			}
		}
		
		function insertarProductoDevolucion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$trannum = $this->input->post('trannum');
				$idcliente = $this->input->post('idcliente');
				$idproducto = $this->input->post('idproducto');
				$idbatch = $this->input->post('idbatch');
				$idbin = $this->input->post('idbin');
				$descrip = $this->input->post('descrip');
				$cantidad = $this->input->post('cantidad');
				$um = $this->input->post('um');
				$precioneto = $this->input->post('precioneto');
				$uniconv = $this->input->post('uniconv');
				$notas = trim($this->input->post('notas'));
				
				$this->load->model('ventas_model');
				
				$this->ventas_model->insertarProductoToCanje($trannum, $descrip, $idproducto, $precioneto, $cantidad, $uniconv, $idbin, $idbatch, $um, $notas);
				
                $datos_canjeados = $this->ventas_model->getListadoProductosCanjeados($trannum);
				$datos_vendidos = $this->ventas_model->getInventarioProductosVendidos($idcliente);
				$datos_entregados = $this->ventas_model->getListadoProductosEntregados($trannum, $idcentro);
				
				$i=0;
                $datosVendidos = array();
                foreach($datos_vendidos as $info_ven){
                    $precioneto = number_format($info_ven->preciotran, 2, '.', '');
                    $valorDisponible = $info_ven->cantidad;
                    
                    if($info_ven->descuento != 0){
                        $valorDescuento = $precioneto * ($info_ven->descuento/100);
                        $precioneto = $precioneto - $valorDescuento;
                        $precioneto = number_format($precioneto, 2, '.', '');
                    }
                    
                    if($datos_canjeados != false){
                        foreach($datos_canjeados as $info_can){
                            if($info_ven->idproducto == $info_can->idproducto && $precioneto == number_format($info_can->precioneto, 2, '.', '')){
                                $valorDisponible = $valorDisponible - $info_can->cantidad;
                            }    
                        }
                    }
                    
                    if($valorDisponible > 0){
                        $datosVendidos[$i] = array(
                            "idproducto" => $info_ven->idproducto,
                            "nameproducto" => $info_ven->nameproducto,
                            "namemodelo" => $info_ven->namemodelo,
                            "modelo" => $info_ven->modelo,
                            "um" => $info_ven->um,
                            "idbin" => $info_ven->idbin,
                            "idbatch" => $info_ven->idbatch,
                            "descuento" => $info_ven->descuento,
                            "preciotran" => $precioneto,
                            "cantidad" => $valorDisponible,
                            "imagen" => $info_ven->imagen
                        );
                        $i++;
                    }
                }
                
				$array = array(
					"datos_canjeados" => $datos_canjeados,
					"datos_vendidos" => $datosVendidos,
					"datos_entregados" => $datos_entregados
				);
				
				echo json_encode($array);
			}
		}
        
        function deleteRegistroCanjeProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$idcentro = $this->input->post('idcentro');
				$idcliente = $this->input->post('idcliente');
				$idrec = $this->input->post('idrec');
				
				$this->load->model('ventas_model');
				
                $this->ventas_model->deleteProductoToCanje($idrec);
				$datos_canjeados = $this->ventas_model->getListadoProductosCanjeados($trannum);
				$datos_vendidos = $this->ventas_model->getInventarioProductosVendidos($idcliente);
				$datos_entregados = $this->ventas_model->getListadoProductosEntregados($trannum, $idcentro);
				
				$i=0;
                $datosVendidos = array();
                foreach($datos_vendidos as $info_ven){
                    $precioneto = number_format($info_ven->preciotran, 2, '.', '');
                    $valorDisponible = $info_ven->cantidad;
                    
                    if($info_ven->descuento != 0){
                        $valorDescuento = $precioneto * ($info_ven->descuento/100);
                        $precioneto = $precioneto - $valorDescuento;
                        $precioneto = number_format($precioneto, 2, '.', '');
                    }
                    
                    if($datos_canjeados != false){
                        foreach($datos_canjeados as $info_can){
                            if($info_ven->idproducto == $info_can->idproducto && $precioneto == number_format($info_can->precioneto, 2, '.', '')){
                                $valorDisponible = $valorDisponible - $info_can->cantidad;
                            }    
                        }
                    }
                    
                    if($valorDisponible > 0){
                        $datosVendidos[$i] = array(
                            "idproducto" => $info_ven->idproducto,
                            "nameproducto" => $info_ven->nameproducto,
                            "namemodelo" => $info_ven->namemodelo,
                            "modelo" => $info_ven->modelo,
                            "um" => $info_ven->um,
                            "idbin" => $info_ven->idbin,
                            "idbatch" => $info_ven->idbatch,
                            "descuento" => $info_ven->descuento,
                            "preciotran" => $precioneto,
                            "cantidad" => $valorDisponible,
                            "imagen" => $info_ven->imagen
                        );
                        $i++;
                    }
                }
                
				$array = array(
					"datos_canjeados" => $datos_canjeados,
					"datos_vendidos" => $datosVendidos,
					"datos_entregados" => $datos_entregados
				);
				
				echo json_encode($array);
			}
        }
		
		function getInventarioToCanje(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('trannum');
				$idcentro = $this->input->post('idcentro');
                
                $this->load->model('ventas_model');
				$detalle = $this->ventas_model->getInventarioTotalToCanje($idtrannum, $idcentro);
				$datos_entregados = $this->ventas_model->getListadoProductosEntregados($idtrannum, $idcentro);
				
                $i=0;
                $datos_inventario = array();
                foreach($detalle as $info){
					$totInventario = $info->cantidad - $info->totalAgregados;
					if($totInventario > 0){
						$datos_inventario[$i] = array(
							"nameproducto" => $info->descrip,
							"namemodelo" => $info->descrip . " " . $info->modelo,
							"marca" => $info->marca,
							"modelo" => $info->modelo,
							"upc" => $info->barcode,
							"notas" => $info->notas,
							"idproducto" => $info->idproducto,
							"tipo" => $info->tipo,
							"um" => $info->um,
							"imagen" => $info->imagen,
							"cantidad" => $totInventario,
							"precio" => $info->costounitario,
							"idbin" => $info->idbin,
							"idbatch" => $info->idbatch,
							"precioventa" => $info->precioventa,
							"idcatalogo" => $info->idcatalogo,
							"tipotax" => $info->tipotax
						);
						$i++;
					}
                }
                
                $array = array(
					"datos_inventario" => $datos_inventario,
					"datos_entregados" => $datos_entregados
                );
                echo json_encode($array);
            }
        }
		
		function insertarProductoEntregado(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$trannum = $this->input->post('trannum');
				$idproducto = $this->input->post('idproducto');
				$idbatch = $this->input->post('idbatch');
				$idbin = $this->input->post('idbin');
				$descrip = $this->input->post('descrip');
				$cantidad = $this->input->post('cantidad');
				$um = $this->input->post('um');
				$precioneto = $this->input->post('precioneto');
				$uniconv = $this->input->post('uniconv');
				$notas = trim($this->input->post('notas'));
				
				$this->load->model('ventas_model');
				
				$this->ventas_model->insertarProductoToEntrega($trannum, $descrip, $idproducto, $precioneto, $cantidad, $uniconv, $idbin, $idbatch, $um, $notas);
				
				$datos_entregados = $this->ventas_model->getListadoProductosEntregados($trannum, $idcentro);
				$datos_inventario = $this->ventas_model->getInventarioTotalToCanje($trannum, $idcentro);
				
                $i=0;
                $datosInventario = array();
                foreach($datos_inventario as $info){
					$totInventario = $info->cantidad - $info->totalAgregados;
					
					if($totInventario > 0){
						$datosInventario[$i] = array(
							"nameproducto" => $info->descrip,
							"namemodelo" => $info->descrip . " " . $info->modelo,
							"marca" => $info->marca,
							"modelo" => $info->modelo,
							"upc" => $info->barcode,
							"notas" => $info->notas,
							"idproducto" => $info->idproducto,
							"tipo" => $info->tipo,
							"um" => $info->um,
							"imagen" => $info->imagen,
							"cantidad" => $totInventario,
							"precio" => $info->costounitario,
							"idbin" => $info->idbin,
							"idbatch" => $info->idbatch,
							"precioventa" => $info->precioventa,
							"idcatalogo" => $info->idcatalogo,
							"tipotax" => $info->tipotax
						);
						$i++;
					}
                }
                
				$array = array(
					"datos_inventario" => $datosInventario,
					"datos_entregados" => $datos_entregados
				);
				
				echo json_encode($array);
			}
		}
		
		function modificarProductoEntregado(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$trannum = $this->input->post('trannum');
				$idrec = $this->input->post('idrec');
				$cantidad = $this->input->post('cantidad');
				$precioneto = $this->input->post('precioneto');
				$notas = trim($this->input->post('notas'));
				
				$this->load->model('ventas_model');
				
				$this->ventas_model->updateProductoToEntrega($idrec, $precioneto, $cantidad, $notas);
				
				$datos_entregados = $this->ventas_model->getListadoProductosEntregados($trannum, $idcentro);
				$datos_inventario = $this->ventas_model->getInventarioTotalToCanje($trannum, $idcentro);
				
                $i=0;
                $datosInventario = array();
                foreach($datos_inventario as $info){
					$totInventario = $info->cantidad - $info->totalAgregados;
					
					if($totInventario > 0){
						$datosInventario[$i] = array(
							"nameproducto" => $info->descrip,
							"namemodelo" => $info->descrip . " " . $info->modelo,
							"marca" => $info->marca,
							"modelo" => $info->modelo,
							"upc" => $info->barcode,
							"notas" => $info->notas,
							"idproducto" => $info->idproducto,
							"tipo" => $info->tipo,
							"um" => $info->um,
							"imagen" => $info->imagen,
							"cantidad" => $totInventario,
							"precio" => $info->costounitario,
							"idbin" => $info->idbin,
							"idbatch" => $info->idbatch,
							"precioventa" => $info->precioventa,
							"idcatalogo" => $info->idcatalogo,
							"tipotax" => $info->tipotax
						);
						$i++;
					}
                }
                
				$array = array(
					"datos_inventario" => $datosInventario,
					"datos_entregados" => $datos_entregados
				);
				
				echo json_encode($array);
			}
		}
		
		function deleteProductoEntregado(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$trannum = $this->input->post('trannum');
				$idrec = $this->input->post('idrec');
				
				$this->load->model('ventas_model');
				
				$this->ventas_model->deleteProductoToEntrega($idrec);
				
				$datos_entregados = $this->ventas_model->getListadoProductosEntregados($trannum, $idcentro);
				$datos_inventario = $this->ventas_model->getInventarioTotalToCanje($trannum, $idcentro);
				
                $i=0;
                $datosInventario = array();
                foreach($datos_inventario as $info){
					$totInventario = $info->cantidad - $info->totalAgregados;
					
					if($totInventario > 0){
						$datosInventario[$i] = array(
							"nameproducto" => $info->descrip,
							"namemodelo" => $info->descrip . " " . $info->modelo,
							"marca" => $info->marca,
							"modelo" => $info->modelo,
							"upc" => $info->barcode,
							"notas" => $info->notas,
							"idproducto" => $info->idproducto,
							"tipo" => $info->tipo,
							"um" => $info->um,
							"imagen" => $info->imagen,
							"cantidad" => $totInventario,
							"precio" => $info->costounitario,
							"idbin" => $info->idbin,
							"idbatch" => $info->idbatch,
							"precioventa" => $info->precioventa,
							"idcatalogo" => $info->idcatalogo,
							"tipotax" => $info->tipotax
						);
						$i++;
					}
                }
                
				$array = array(
					"datos_inventario" => $datosInventario,
					"datos_entregados" => $datos_entregados
				);
				
				echo json_encode($array);
				
			}
		}
		
		function getListadoFacturasClienteToAbono(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idcliente = $this->input->post('idcliente');
				
				$this->load->model('ventas_model');
				$dataSource = $this->ventas_model->getListadoFacturasClienteToAbono($idcliente);
				
				echo json_encode($dataSource);
			}
		}
		
		function cerrarCanjeDeProductos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$idcliente = $this->input->post('idcliente');
				$valorRecibido = $this->input->post('valorrecibido');
				$valorEntregado = $this->input->post('valorentregado');
				$valorDiferencia = $this->input->post('valordiferencia');
				
				$trannum_ac = $this->input->post('trannumabono');
				$formaabono = $this->input->post('formaabono');
				$valorabono = $this->input->post('valorabono');
				$notasabono = $this->input->post('notasabono');
				
				$formacargo = $this->input->post('formacargo');
				$valorcargo = $this->input->post('valorcargo');
				$notascargo = $this->input->post('notascargo');
				
				$this->load->model('ventas_model');
				
				$idCargo = "";
				$idAbono = "";
				if($trannum_ac != ""){
					$idCargo = $this->ventas_model->insertarCargoAbonoFacturaCanje($trannum, $trannum_ac, $formacargo, $valorcargo, $notascargo, 'Cargo por Canje.');
					
					if($valorabono != "" || $valorabono != 0){
						$idAbono = $this->ventas_model->insertarCargoAbonoFacturaCanje($trannum, $trannum_ac, $formaabono, $valorabono, $notasabono, 'Abono por Canje.');
					}
					
					$this->ventas_model->callTotaliza100($trannum_ac, 1);
					$this->ventas_model->validateValDHTransaccion($trannum_ac);
				}
				
				$ids = explode(',', $this->session->userdata('opcionmenu'));
                $idclaseFavor = $ids[0];
                $idclaseContra = $ids[1];
				
				$idFavor = $this->ventas_model->insertAjusteFavorContraCanje($trannum, $idclaseFavor, 'Ajuste a favor, por canje de productos');
				$idContra = $this->ventas_model->insertAjusteFavorContraCanje($trannum, $idclaseContra, 'Ajuste en contra, por canje de productos');
				
				$this->ventas_model->insertDetalleAjusteFavorCanje($trannum, $idFavor, $idclaseFavor);
				$this->ventas_model->callTotaliza100($idFavor, 1);
				
				$this->ventas_model->insertDetalleAjusteContraCanje($trannum, $idContra, $idclaseContra);
				$this->ventas_model->callTotaliza100($idContra, 1);
				
				$arrayResult = $this->ventas_model->updateCierreCanje($trannum, $valorRecibido, $valorEntregado, $valorDiferencia, $idCargo, $idAbono, $idFavor, $idContra);
				echo json_encode($arrayResult);
			}
		}
        
		function setAnulacionCanjeProductos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->setAnulacionCanjeProductos($trannum);
				
				echo json_encode($array);
			}
		}
		
		function getDetalleCargoAbonoCierreCanje(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcargo_abono = $this->input->post("idcargoabono");
				$codigosCargosAbonos = explode(",", $idcargo_abono);
				$idrec_cargo = $codigosCargosAbonos[0];
				$idrec_abono = $codigosCargosAbonos[1];
				
				$detalle_cargo = ""; $detalle_abono = "";
				$info_cargo = array(); $info_abono = array();
				
				$this->load->model('ventas_model');
				
				if($idrec_cargo != ""){
					$info_cargo = $this->ventas_model->getInformacionCargoCanje($idrec_cargo);
					$detalle_cargo = "true";
				}
				if($idrec_abono != ""){
					$info_abono = $this->ventas_model->getInformacionAbonoCanje($idrec_abono);
					$detalle_abono = "true";
				}
				
				$array = array(
					"infocargo" => $info_cargo,
					"infoabono" => $info_abono,
					"info_cargo" => $detalle_cargo,
					"info_abono" => $detalle_abono
				);
				
				echo json_encode($array);
			}
		}
		
        function ventasVendedores($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $controlador = $this->uri->segment(1);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'controller_app' => $controlador,
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('scan_model');
                $this->load->model('user_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                
                $month = date('m');
                $year = date('Y');
                $firts_month = date('Y-m-d', mktime(0,0,0, $month, 1, $year));
                
				$this->data['first_tran'] = $this->scan_model->getFirstTran();
				$this->data['primera_fecha'] = $firts_month;
				$this->data['cant_config'] = $this->scan_model->getCantConfig($controlador);
                
                $this->load->model('ventas_model');
                				
				$derechos = $this->user_model->getDerechos();
                $permite_costo = 0;
                $permite_utilidad = 0;
                if($derechos!=""){
					$pos = strpos($derechos, "costo");
					if($pos !== false){
						if($pos>=0){
							$permite_costo=1;
						}   
					}
					$pos = strpos($derechos, "utilidad");
					if($pos !== false){
						if($pos>=0){
							$permite_utilidad=1;
						}   
					}
                    
                }
                $this->data['permite_costo'] = $permite_costo;
                $this->data['permite_utilidad'] = $permite_utilidad;
				
                $this->load->view('mantenimiento_ventasvendedores', $this->data); 
            }
        }

        function ventasProveedores($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $month         = date('m');
                $year          = date('Y');
                $firts_month   = date('Y-m-d', mktime(0,0,0, $month, 1, $year));
                $permite_costo = 0;
                $permite_utili = 0;

                $this->load->model('global_model'); $this->load->model('scan_model');
                $this->load->model('user_model');   $this->load->model('configuracion_model');
                
                $derechos = $this->user_model->getDerechos();
                $appName  = $this->configuracion_model->getAppName($idApp);

                $infoApp = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'controller_app' => $this->uri->segment(1),
                );
                $this->session->set_userdata($infoApp);
                
				$this->data['primera_fecha'] = $firts_month;
                $this->data['first_tran']    = $this->scan_model->getFirstTran();
				$this->data['cant_config']   = $this->scan_model->getCantConfig($this->uri->segment(1));
                $this->data['formatos']      = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                
                if ( $derechos != '' ) {
					$pos = strpos($derechos, "costo");
					$permite_costo = ( $pos !== false ) ? ( ( $pos >= 0 ) ? 1 : 0 ) : 0;
					
					$pos = strpos($derechos, "utilidad");
					$permite_utili = ( $pos !== false ) ? ( ( $pos >= 0 ) ? 1 : 0 ) : 0;
                }

                $this->data['permite_costo']    = $permite_costo;
                $this->data['permite_utilidad'] = $permite_utili;
				
                $this->load->view('mantenimiento_ventasproveedores', $this->data); 
            }
        }
        
        function getDatosVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '2048M');

                $fecha_ini = $this->input->post("fecha_ini");
                $fecha_fin = $this->input->post("fecha_fin");
                $permite_costo = $this->input->post("permite_costo");
                $permite_utilidad = $this->input->post("permite_utilidad");
                $this->load->model('scan_model');
                $this->load->model('user_model');
                $datos = $this->scan_model->getVentasxVendedores($fecha_ini,$fecha_fin);
			
				$array = array();
				$i = 0;
				if($datos!=false){
					foreach($datos as $dat){
						if(($permite_costo=="1" || $this->session->userdata("iduser")=="1") && ($permite_utilidad=="1" || $this->session->userdata("iduser")=="1")){
                            
                            $array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
                                "Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
                                "Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
                                "Proveedor_Codigo"    => $dat->CodigoProveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Caja"                => $dat->NameCaja,
								"numx"                => $dat->numx,
								"numz"                => $dat->numz,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
                                "Marca"               => $dat->Marca,
                                // "Forma_de_Pago"       => $dat->formaPago,
                                "Modelo"              => $dat->Modelo,
                                "Grupo_Cliente"       => $dat->Grupo,                                
                                "Proveedor_Grupo"     => $dat->GrupoProvee,                                
								"Costos"              => $dat->Costos,
                                "Utilidad"            => $dat->Ventas - $dat->Costos,
                                //"Margen"=>((($dat->Ventas - $dat->Costos) / $dat->Ventas) / $dat->Unidades) * 100
							);
							$i++;
						}else if(($permite_costo=="1" || $this->session->userdata("iduser")=="1") && ($permite_utilidad=="0" || $this->session->userdata("iduser")=="1")){
							$array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
                                "Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
                                "Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Caja"                => $dat->NameCaja,
								"numx"                => $dat->numx,
								"numz"                => $dat->numz,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
                                "Marca"               => $dat->Marca,
                                // "Forma_de_Pago"       => $dat->formaPago,
                                "Modelo"              => $dat->Modelo,
                                "Grupo_Cliente"       => $dat->Grupo, 
                                "Proveedor_Grupo"     => $dat->GrupoProvee,                                                               
								"Costos"              => $dat->Costos,
                                //"Margen"=>((($dat->Ventas - $dat->Costos) / $dat->Ventas) / $dat->Unidades) * 100
							);
							$i++;
						}else if(($permite_costo=="0" || $this->session->userdata("iduser")=="1") && ($permite_utilidad=="1" || $this->session->userdata("iduser")=="1")){
                            
                            $array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
                                "Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
                                "Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
                                "Proveedor_Codigo"    => $dat->CodigoProveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Caja"                => $dat->NameCaja,
								"numx"                => $dat->numx,
								"numz"                => $dat->numz,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
                                "Marca"               => $dat->Marca,
                                // "Forma_de_Pago"       => $dat->formaPago,
                                "Modelo"              => $dat->Modelo,
                                "Grupo_Cliente"       => $dat->Grupo,
                                "Proveedor_Grupo"     => $dat->GrupoProvee,
                                "Utilidad"            => $dat->Ventas - $dat->Costos
							);
							$i++;
						}else{
							$array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
								"Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
								"Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
								"Proveedor_Codigo"    => $dat->CodigoProveedor,
                                "Proveedor_Grupo"     => $dat->GrupoProvee,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Caja"                => $dat->NameCaja,
								"numx"                => $dat->numx,
								"numz"                => $dat->numz,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
								"Marca"               => $dat->Marca,
								// "Forma_de_Pago"       => $dat->formaPago,
								"Modelo"              => $dat->Modelo
							);
							$i++;
						}
					}
				}
                echo json_encode($array);
            }
        }
        
        function getDatosVentasProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '2048M');

                $fecha_ini        = $this->input->post("fecha_ini");
                $fecha_fin        = $this->input->post("fecha_fin");
                $idcps            = $this->session->userdata('idEmpleadoUser');
                $permite_costo    = $this->input->post("permite_costo");
                $permite_utilidad = $this->input->post("permite_utilidad");
                
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getVentasxProveedor($fecha_ini, $fecha_fin, $idcps);
			
				$array = array();
				$i = 0;
				if($datos!=false){
					foreach($datos as $dat){
						if(($permite_costo=="1" || $this->session->userdata("iduser")=="1") && ($permite_utilidad=="1" || $this->session->userdata("iduser")=="1")){
                            
                            $array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
                                "Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
                                "Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
                                "Marca"               => $dat->Marca,
                                "Modelo"              => $dat->Modelo,
                                "Grupo_Cliente"       => $dat->Grupo,                                
								"Costos"              => $dat->Costos,
                                "Utilidad"            => $dat->Ventas - $dat->Costos,
                                //"Margen"=>((($dat->Ventas - $dat->Costos) / $dat->Ventas) / $dat->Unidades) * 100
							);
							$i++;
						}else if(($permite_costo=="1" || $this->session->userdata("iduser")=="1") && ($permite_utilidad=="0" || $this->session->userdata("iduser")=="1")){
							$array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
                                "Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
                                "Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
                                "Marca"               => $dat->Marca,
                                "Modelo"              => $dat->Modelo,
                                "Grupo_Cliente"       => $dat->Grupo,                                                                
								"Costos"              => $dat->Costos,
                                //"Margen"=>((($dat->Ventas - $dat->Costos) / $dat->Ventas) / $dat->Unidades) * 100
							);
							$i++;
						}else if(($permite_costo=="0" || $this->session->userdata("iduser")=="1") && ($permite_utilidad=="1" || $this->session->userdata("iduser")=="1")){
                            
                            $array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
                                "Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
                                "Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
                                "Marca"               => $dat->Marca,
                                "Modelo"              => $dat->Modelo,
                                "Grupo_Cliente"       => $dat->Grupo,
                                "Utilidad"            => $dat->Ventas - $dat->Costos
							);
							$i++;
						}else{
							$array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
								"Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
								"Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
								"Marca"               => $dat->Marca,
								"Modelo"              => $dat->Modelo
							);
							$i++;
						}
					}
				}
                echo json_encode($array);
            }
        }

        function getExistenciasPorProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idprovee = $this->session->userdata('idEmpleadoUser');
				
                $this->load->model('ventas_model');
                $productos = $this->ventas_model->getExistenciasPorProveedor($idprovee);
                
                $array = array();
                foreach($productos as $pro){
                    $totalCajas = 0;
                    if($pro->tipo != 4){
                        if($pro->upp != 0){
                            $totalCajas = $pro->cantidad / $pro->upp;
                            if($totalCajas % 1 == 0){
                                $totalCajas = number_format($totalCajas);
                            }else{
                                $totalCajas = number_format($totalCajas, 2, '.', '');
                            }
                        }
                    }
					
                    $array[] = array(
                        "linea" => $pro->linea,
                        "departamento" => $pro->departamento,
                        "proveedor" => $pro->proveedor,
                        "id" => $pro->id,
                        "producto" => $pro->producto,
                        "marca" => $pro->marca,
                        "xpos" => $pro->xpos,
                        "presenta" => $pro->presenta,
                        "modelo" => $pro->modelo,
                        "um" => $pro->um,
                        "upp" => $pro->upp,
                        "cajas" => $totalCajas,
                        "imagen" => $pro->imagen,
                        "precioventa" => $pro->precioventa,
                        "barcode" => $pro->barcode,
                        "costounitario" => $pro->costounitario,
                        "subcosto" => ( round($pro->cantidad, 2) * $pro->costounitario ),
                        "cantidad" => round($pro->cantidad, 2),
                        "idnivel1" => $pro->idnivel1
                    );
                }
                
				echo json_encode($array);
            }
        }
		
        function getArregloConfig(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $id = $this->input->post("id");
                $this->load->model('scan_model');
                $datos = $this->scan_model->getArreglo_Config($id);
                echo json_encode($datos);
            }
        }
        
        function saveFields(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('scan_model');
                $fechaini = $this->input->post("fechaini");
                $fechafin = $this->input->post("fechafin");
                $array = $this->input->post("array");
                $descrip = $this->input->post("descrip");
                $datos = $this->scan_model->saveArray($descrip,$array,$fechaini,$fechafin);
                echo json_encode($datos);
            }
        }
     
        function editFields(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('scan_model');
                $idrec = $this->input->post("idrec");
                $array = $this->input->post("array");
                $fechaini = $this->input->post("fechaini");
                $fechafin = $this->input->post("fechafin");
                $descrip = $this->input->post("descrip");
                $datos = $this->scan_model->editArray($idrec,$descrip,$array,$fechaini,$fechafin);
                echo json_encode($idrec);
            }
        }
        
		function deleteFields(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('scan_model');
                $idrec = $this->input->post("idrec");
                $datos = $this->scan_model->deleteArray($idrec);
                echo json_encode($datos);
            }
        }
        
        function getFields(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('scan_model');
                $datos = $this->scan_model->getArrays();
                $array =array();
                $i=0;
                foreach($datos as $dat){
                    $array[$i] = array(
                        "id" => $dat->idrec,
                        "descrip" => $dat->descrip,
                        "arreglo" => unserialize($dat->arreglo),
                        "creadopor" => $dat->creadopor,
                        "fechaini" => $dat->fechaini,
                        "fechafin" => $dat->fechafin,
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
		
		function ContratosDeServicios($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('global_model');
				$this->load->model('sucursal_model');
				$this->load->model('cliente_model');
				$this->load->model('empleado_model');
				$this->load->model('ventas_model');
				
				$direccion = $this->uri->segment(1);
                $this->data['tiposContratos'] = $this->ventas_model->getListadoTiposContratos('ris_tipo');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
				$this->data['clientes'] = $this->cliente_model->viewClienteActivo();
				$this->data['empleados'] = $this->empleado_model->viewEmpleActivo();
				$this->data['servicios'] = $this->ventas_model->getListadoServiciosContratos(4);
				$this->data['comprobantes'] = $this->ventas_model->getListadoComprobantesContratos('VN');
				$this->data['pagos'] = $this->ventas_model->getListadoPagosContratos();
				
				$this->load->view('mantenimiento_contratos_servicios', $this->data);
			}
		}
		
		function getListadoContratosServicios(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$estado = $this->input->post('estado');
				$ristipo = $this->input->post('ristipo');
				$indexGrid = $this->input->post('indexGrid');
				
				$sessionContratos = array(
					'idSessionCentroContratos' => $idcentro,
					'idSessionEstadoContratos' => $estado,
					'idSessionIndex' => $indexGrid,
                );
                $this->session->set_userdata($sessionContratos);
				
				$this->load->model('ventas_model');
				$dataSource = $this->ventas_model->getListadoContratosServicios($idcentro, $estado, $ristipo);
				
				$i=0;
				$array = array();
				
				if($dataSource != false){
					foreach($dataSource as $info){
						$array[$i] = array(
							"trannum" => $info->trannum,
							"idcentro" => $info->idcentro,
							"idcaja" => $info->idcaja,
							"ris_tipo" => $info->ris_tipo,
							"referencia" => $info->referencia,
							"fecha" => $info->fecha,
							"fechaini" => $info->fechaini,
							"fechafin" => $info->fechafin,
							"idproducto" => $info->idproducto,
							"idcps" => $info->idcps,
							"idworker" => $info->idworker,
							"nrc" => $info->nrc,
							"nameCliente" => $info->nameCliente,
							"qstatus" => $info->qstatus,
							"descrip" => $info->descrip,
							"valor" => $info->valorPendiente * 1,
							"numpagos" => $info->numpagos,
							"idclase" => $info->idclase,
							"cajclase" => $info->cajclase,
							"anexos" => $info->anexos,
							"notas" => $info->notas,
							"estatus" => $info->estatus
						);
						$i++;
					}
				}
				
				echo json_encode($array);
			}
		}

        function updateEstadoProyecto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$qstatus = $this->input->post('n_qstatus');
				
				$this->load->model('ventas_model');
				echo json_encode($this->ventas_model->updateEstadoProyecto($trannum, $qstatus));
			}
        }
		
		function insertNuevoContrato(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$idcaja = $this->input->post('idcaja');
				$ristipo = $this->input->post('ristipo');
				$referencia = $this->input->post('referencia');
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
				$idproducto = $this->input->post('idproducto');
				$idcps = $this->input->post('idcps');
				$idworker = $this->input->post('idworker');
				$descrip = $this->input->post('descrip');
				$valor = $this->input->post('valor');
				$numpagos = $this->input->post('numpagos');
				$idclase = $this->input->post('idclase');
				$cajclase = $this->input->post('cajclase');
				$notas = trim($this->input->post('notas'));
				$primareserva = $this->input->post('primareserva');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->insertarNuevoContratoDeServicio($idcentro, $idcaja, $ristipo, $referencia, $fechaini, $fechafin, $idproducto, $idcps, $idworker, $descrip, $valor, $numpagos, $idclase, $cajclase, $notas, $primareserva);
				
				echo json_encode($array);
			}
		}
		
		function editarContrato(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
				$idworker = $this->input->post('idworker');
				$descrip = $this->input->post('descrip');
				$idclase = $this->input->post('idclase');
				$cajclase = $this->input->post('cajclase');
                $valor = $this->input->post('valor');
				$notas = trim($this->input->post('notas'));
                $referencia = $this->input->post('referencia');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->updateInfoContratoDeServicio($trannum, $fechaini, $fechafin, $idworker, $descrip, $idclase, $cajclase, $valor, $notas, $referencia);
				
				echo json_encode($array);
			}
		}
		
		function anulacionContrato(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->anulacionContratoDeServicio($trannum);
				
				echo json_encode($array);
			}
		}
		
		function detalleContratosServicios($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$resultAppName = array(
                    'namePage' => 'Detalle ' . $this->session->userdata('appName')
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('global_model');
				$this->load->model('sucursal_model');
				$this->load->model('cliente_model');
				$this->load->model('empleado_model');
				$this->load->model('ventas_model');
				
				$direccion = $this->uri->segment(1);
                $this->data['tiposContratos'] = $this->ventas_model->getListadoTiposContratos('ris_tipo');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
				$this->data['clientes'] = $this->cliente_model->viewClienteActivo();
				$this->data['empleados'] = $this->empleado_model->viewEmpleActivo();
				$this->data['servicios'] = $this->ventas_model->getListadoServiciosContratos(4);
				$this->data['comprobantes'] = $this->ventas_model->getListadoComprobantesContratos('VN');
				$this->data['pagos'] = $this->ventas_model->getListadoPagosContratos();
				$this->data['informacion'] = $this->ventas_model->getInformacionDatosContrato($trannum);
				
				$this->load->view('mantenimiento_detalle_contratos_servicios', $this->data);
			}
		}
		
		function getListadoCuotasIngresadas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				
				$this->load->model('ventas_model');
				$informacion = $this->ventas_model->getListadoCuotasIngresadas($trannum);
				
				$i = 0;
				$array = array();
				
				if($informacion != false){
					foreach($informacion as $info){
						$array[$i] = array(
							"barcode" => $info->barcode,
							"cantidad" => $info->cantidad,
							"costounitario" => $info->costounitario,
							"descuento" => $info->descuento,
							"idbatch" => $info->idbatch,
							"idbin" => $info->idbin,
							"idcentro" => $info->idcentro,
							"idclase" => $info->idclase,
							"idproducto" => $info->idproducto,
							"idrec" => $info->idrec,
							"idworker" => $info->idworker,
							"invcontrol" => $info->invcontrol,
							"itemline" => $info->itemline,
							"notas" => $info->notas,
							"preciotran" => $info->preciotran * 1,
							"precioneto" => $info->precioneto,
							"tax1" => $info->tax1,
							"tax2" => $info->tax2,
							"tax3" => $info->tax3,
							"tax4" => $info->tax4,
							"tax5" => $info->tax5,
							"trannum" => $info->trannum,
							"um" => $info->um,
							"uniconv" => $info->uniconv
						);
						$i++;
					}
				}
				
				echo json_encode($array);
			}
		}
		
		function createCuotasTemporales(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$idproducto = $this->input->post('idproducto');
				$descripcionCuota = $this->input->post('descrip');
				$numerocuotas = $this->input->post('numerocuotas');
				$tipocuotas = $this->input->post('tipocuotas');
				$fechaInicial = $this->input->post('fechaini');
				
				$tipoDescrip = 0;
				$infoResult = strpos($descripcionCuota, '#');
				if($infoResult !== false){
					$tipoDescrip = 1;
				}
				
				$infoResult = strpos($descripcionCuota, '&');
				if($infoResult !== false){
					$tipoDescrip = 2;
				}
				
				$this->load->model('ventas_model');
				$precioVenta = $this->ventas_model->getPrecioContrato($trannum);
				$informacion = $this->ventas_model->getListadoCuotasIngresadas($trannum);
				
				$numCuota = 0;
				$totalFacturado = 0;
				
				if($tipocuotas == 0){
					$tipocuotas = 1;
				}
				
				if($informacion != false){
					foreach($informacion as $info){
						$numCuota++;
						$totalFacturado =  $totalFacturado + $info->preciotran;
						$fechaInicial = $info->um;
					}
				}
				
				$saldoPendiente = $precioVenta - $totalFacturado;
				$valorCuota = $saldoPendiente / $numerocuotas;
				$valorCuota =  number_format($precioVenta, 2, '.', '');
				
				$k=0;
				$array = array();
				for($i=0; $i<$numerocuotas; $i++){
					$j = $i + 1;
					$fechaex = explode("-", $fechaInicial);
                    $month = $fechaex[0]."-".$fechaex[1];
					
					if($numCuota == 0){
						$primero = date('Y-m-d', strtotime("{$month}"));
						$aux = date('Y-m-d', strtotime("{$month}"));
					}else{
						$primero = date('Y-m-d', strtotime("{$month}  + ".$tipocuotas." month"));
						$aux = date('Y-m-d', strtotime("{$month} + ".$tipocuotas." month"));
					}
                    $fecvence = date('Y-m-d', strtotime("{$fechaInicial}"));
                    
					if($tipoDescrip == 1){
						$descripCuota = 'Cuota N° '.$j.'/'.$numerocuotas;
					}else if($tipoDescrip == 2){
						$partesFecha = explode('-', $primero);
						$descripCuota = "";
						
						if($tipocuotas == 1){
							switch($partesFecha[1]){
								case 1:
									$descripCuota = "Enero " . $partesFecha[0];
								break;

								case 2:
									$descripCuota = "Febrero " . $partesFecha[0];
								break;

								case 3:
									$descripCuota = "Marzo " . $partesFecha[0];
								break;

								case 4:
									$descripCuota = "Abril " . $partesFecha[0];
								break;

								case 5:
									$descripCuota = "Mayo " . $partesFecha[0];
								break;

								case 6:
									$descripCuota = "Junio " . $partesFecha[0];
								break;

								case 7:
									$descripCuota = "Julio " . $partesFecha[0];
								break;

								case 8:
									$descripCuota = "Agosto " . $partesFecha[0];
								break;

								case 9:
									$descripCuota = "Septiembre " . $partesFecha[0];
								break;

								case 10:
									$descripCuota = "Octubre " . $partesFecha[0];
								break;

								case 11:
									$descripCuota = "Noviembre " . $partesFecha[0];
								break;

								case 12:
									$descripCuota = "Diciembre " . $partesFecha[0];
								break;
							}
						}else{
							$mes = $partesFecha[1];
							
							for($m=0; $m<$tipocuotas; $m++){
								switch($mes){
									case 1:
										$descripCuota .= "Enero, ";
									break;

									case 2:
										$descripCuota .= "Febrero, ";
									break;

									case 3:
										$descripCuota .= "Marzo, ";
									break;

									case 4:
										$descripCuota .= "Abril, ";
									break;

									case 5:
										$descripCuota .= "Mayo, ";
									break;

									case 6:
										$descripCuota .= "Junio, ";
									break;

									case 7:
										$descripCuota .= "Julio, ";
									break;

									case 8:
										$descripCuota .= "Agosto, ";
									break;

									case 9:
										$descripCuota .= "Septiembre, ";
									break;

									case 10:
										$descripCuota .= "Octubre, ";
									break;

									case 11:
										$descripCuota .= "Noviembre, ";
									break;

									case 12:
										$descripCuota .= "Diciembre, ";
									break;
								}
								$mes = $mes + 1;
							}
							
							$descripCuota = substr($descripCuota, 0, -2);
						}
					}
					
					if($tipoDescrip == 1){
						$descripcionCuotaFinal = str_replace("#", $descripCuota, $descripcionCuota);
					}else if($tipoDescrip == 2){
						$descripcionCuotaFinal = str_replace("&", $descripCuota, $descripcionCuota);
					}else{
						$descripcionCuotaFinal = $descripcionCuota;
					}
					
					$array[$k] = array(
						"numcuota" => $j,
						"fecha" => $primero,
						"descrip" => $descripcionCuotaFinal,
						"valor" => $valorCuota
					);
					$k++;
					$fechaInicial = $aux;
					$numCuota = 1;
				}
				
				echo json_encode($array);
			}
		}
		
		function insertarCuotasToContrato(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$idproducto = $this->input->post('idproducto');
				$idcentro = $this->input->post('idcentro');
				$idclase = $this->input->post('idclase');
				$dataSource = $this->input->post('informacion');
				
				$this->load->model('ventas_model');
				$this->ventas_model->insertarCuotasToContrato($trannum,$idproducto,$idcentro,$idclase,$dataSource);
				
				$informacion = $this->ventas_model->getListadoCuotasIngresadas($trannum);
				
				$i = 0;
				$array = array();
				
				if($informacion != false){
					foreach($informacion as $info){
						$array[$i] = array(
							"barcode" => $info->barcode,
							"cantidad" => $info->cantidad,
							"costounitario" => $info->costounitario,
							"descuento" => $info->descuento,
							"idbatch" => $info->idbatch,
							"idbin" => $info->idbin,
							"idcentro" => $info->idcentro,
							"idclase" => $info->idclase,
							"idproducto" => $info->idproducto,
							"idrec" => $info->idrec,
							"idworker" => $info->idworker,
							"invcontrol" => $info->invcontrol,
							"itemline" => $info->itemline,
							"notas" => $info->notas,
							"preciotran" => $info->preciotran * 1,
							"precioneto" => $info->precioneto,
							"tax1" => $info->tax1,
							"tax2" => $info->tax2,
							"tax3" => $info->tax3,
							"tax4" => $info->tax4,
							"tax5" => $info->tax5,
							"trannum" => $info->trannum,
							"um" => $info->um,
							"uniconv" => $info->uniconv
						);
						$i++;
					}
				}
				
				echo json_encode($array);
			}
		}
		
		function updateRegistroCuotaIngresada(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
				$fecha = $this->input->post('fecha');
				$descrip = $this->input->post('descrip');
				$valor = $this->input->post('valor');
				$idproducto = $this->input->post('idproducto');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->updateRegistroCuotaIngresada($idrec,$fecha,$descrip,$valor,$idproducto);
				
				echo json_encode($array);
			}
		}
		
		function eliminarCuotaContrato(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
				$trannum = $this->input->post('trannum');
				
				$this->load->model('ventas_model');
				$this->ventas_model->deleteCuotaContrato($idrec);
				$informacion = $this->ventas_model->getListadoCuotasIngresadas($trannum);
				
				$i = 0;
				$array = array();
				
				if($informacion != false){
					foreach($informacion as $info){
						$array[$i] = array(
							"barcode" => $info->barcode,
							"cantidad" => $info->cantidad,
							"costounitario" => $info->costounitario,
							"descuento" => $info->descuento,
							"idbatch" => $info->idbatch,
							"idbin" => $info->idbin,
							"idcentro" => $info->idcentro,
							"idclase" => $info->idclase,
							"idproducto" => $info->idproducto,
							"idrec" => $info->idrec,
							"idworker" => $info->idworker,
							"invcontrol" => $info->invcontrol,
							"itemline" => $info->itemline,
							"notas" => $info->notas,
							"preciotran" => $info->preciotran * 1,
							"precioneto" => $info->precioneto,
							"tax1" => $info->tax1,
							"tax2" => $info->tax2,
							"tax3" => $info->tax3,
							"tax4" => $info->tax4,
							"tax5" => $info->tax5,
							"trannum" => $info->trannum,
							"um" => $info->um,
							"uniconv" => $info->uniconv
						);
						$i++;
					}
				}
				
				echo json_encode($array);
			}
		}
		
		function getListadoCuotasCobro(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$fecha = $this->input->post('fecha');
				
				$this->load->model('ventas_model');
				$informacion = $this->ventas_model->getListadoCuotasACobro($idcentro, $fecha);
				
				$i=0;
				$array = array();
				
				if($informacion != false){
					foreach($informacion as $info){
						$array[$i] = array(
							'idrec' => $info->idrec,
							'itemline' => $info->invcontrol . ' - ' . $info->itemline,
							'um' => $info->um,
							'nameCliente' => $info->namecliente,
							'notas' => $info->nameContrato.": ".$info->notas,
							'valor' => number_format($info->preciotran, 2, '.', '') * 1
						);
						
						$i++;
					}
				}
				
				echo json_encode($array);
			}
		}
		
		function updateEstadoCuotasToCobro(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idcuotas = $this->input->post('idcuotas');
				
				$this->load->model('ventas_model');
				$array = $this->ventas_model->updateEstadoCuotasToCobro($idcuotas);
				
				echo json_encode($array);
			}
		}
		
		function FacturacionDeContratos($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('global_model');
				$this->load->model('sucursal_model');
				$this->load->model('cliente_model');
				$this->load->model('empleado_model');
				$this->load->model('ventas_model');
				
				$direccion = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
				$this->data['documentos'] = $this->ventas_model->getListadoDocumentosCuotasAFacturar();
				$this->data['comprobantes'] = $this->ventas_model->getListadoComprobantesContratos('VN');
				
				$this->load->view('mantenimiento_facturas_contratos_servicios', $this->data);
			}
		}
        
        function getListadoCuotasAFacturar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$idclase = $this->input->post('documento');
                
				$this->load->model('ventas_model');
				$informacion = $this->ventas_model->getListadoCuotasAFacturar($idcentro, $idclase);
				
				$i=0;
				$array = array();
				
				if($informacion != false){
					foreach($informacion as $info){
						$array[$i] = array(
							'idrec' => $info->idrec,
							'idcentro' => $info->idcentro,
							'idproducto' => $info->idproducto,
							'idcliente' => $info->idcliente,
							'idvendedor' => $info->idvendedor,
							'itemline' => $info->itemline,
							'um' => $info->um,
							'documento' => $info->documento,
							'nameCliente' => $info->namecliente,
							'notas' => $info->notas,
							'optionNumber' => 'A',
							'formapago' => $info->formapago,
							'valor' => number_format($info->preciotran, 2, '.', '') * 1
						);
						$i++;
					}
				}
				
				echo json_encode($array);
			}
        }
		
		function getListadoCajasNumeradores(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
				$idclase = $this->input->post('idclase');
                $informacionGrid = $this->input->post('datosGrid');
				
				$i=0;
				$cont = count($informacionGrid);
				
				$serieAnt_a = "";
				$nameCliente_a = "";
				
				for($j=0; $j<$cont; $j++){
					if($informacionGrid[$j]['nameCliente'] == $nameCliente_a){
						if($informacionGrid[$j]['optionNumber'] == $serieAnt_a){
							$serieAnt_a = $informacionGrid[$j]['optionNumber'];
							$nameCliente_a = $informacionGrid[$j]['nameCliente'];
						}else{
							$i++;
							$serieAnt_a = $informacionGrid[$j]['optionNumber'];
							$nameCliente_a = $informacionGrid[$j]['nameCliente'];
						}
					}else{
						$i++;
						$serieAnt_a = $informacionGrid[$j]['optionNumber'];
						$nameCliente_a = $informacionGrid[$j]['nameCliente'];
					}
				}

                $this->load->model('ventas_model');
                $infoCajas = $this->ventas_model->getListadoCajas($idcentro);
				
				$k=0;
				foreach($infoCajas as $info_caja){
					if($k == 0){
						$idcaja = $info_caja->id;
						$k++;
					}
				}
				
				$numTipo = $this->ventas_model->getNumTipoTransaccion($idclase);
				if($numTipo == 1){ //Empresa
					$serie = $this->ventas_model->getSerieDocumentoEmpresa($idclase);
					$numeros = $this->ventas_model->getNumerosDocumentoEmpresa($idclase);
				}else if($numTipo == 2){ //Sucursal
					$serie = $this->ventas_model->getSerieDocumentoSucursal($idclase, $idcentro);
					$numeros = $this->ventas_model->getNumerosDocumentoSucursal($idclase, $idcentro);
				}else if($numTipo == 3){ //Caja
					$serie = $this->ventas_model->getSerieDocumento($idclase, $idcentro, $idcaja);
					$numeros = $this->ventas_model->getNumerosDocumento($idclase, $idcentro, $idcaja);
				}
                
				$numSuma = $i - 1;
				$numeroInicial = $numeros[0];
				$numeroFinal = $numeros[0] + $numSuma;
				
				$array = array(
					"infoCajas" => $infoCajas,
					"infoItems" => $i,
					'serieDocumento' => $serie,
					'numeroInicial' => $serie.$numeroInicial,
                    'numeroFinal' => $serie.$numeroFinal,
					'numIni' => $numeroInicial,
                    'numFin' => $numeroFinal
				);
				
                echo json_encode($array);
            }
        }
		
		function generateDocumentosTran100(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$fecha = $this->input->post('fecha');
				$idcentro = $this->input->post('idcentro');
				$idcaja = $this->input->post('idcaja');
				$idclase = $this->input->post('idclase');
				$serieDocumento = $this->input->post('serieDocumento');
				$numeroInicial = $this->input->post('numeroInicial');
				$numeroFinal = $this->input->post('numeroFinal');
                $informacionGrid = $this->input->post('datosGrid');
				
				$this->load->model('ventas_model');
				$this->ventas_model->insertDocumentosTran100($fecha, $idcentro, $idcaja, $idclase, $serieDocumento, $numeroInicial, $numeroFinal, $informacionGrid);
				$informacion = $this->ventas_model->getListadoCuotasAFacturar($idcentro, $idclase);
				
				$i=0;
				$array = array();
				if($informacion != false){
					foreach($informacion as $info){
						$array[$i] = array(
							'idrec' => $info->idrec,
							'idcentro' => $info->idcentro,
							'idproducto' => $info->idproducto,
							'idcliente' => $info->idcliente,
							'idvendedor' => $info->idvendedor,
							'itemline' => $info->itemline,
							'um' => $info->um,
							'documento' => $info->documento,
							'nameCliente' => $info->namecliente,
							'notas' => $info->notas,
							'optionNumber' => 'A',
							'formapago' => $info->formapago,
							'valor' => number_format($info->preciotran, 2, '.', '') * 1
						);
						$i++;
					}
				}
				
				echo json_encode($array);
			}
		}
		
		function regresarCuotaEstadoAnterior(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
				$idcentro = $this->input->post('idcentro');
				$idclase = $this->input->post('documento');
				
				$this->load->model('ventas_model');
				$this->ventas_model->cambiarEstadoAnteriorCuota($idrec);
				$informacion = $this->ventas_model->getListadoCuotasAFacturar($idcentro, $idclase);
				
				$i=0;
				$array = array();
				if($informacion != false){
					foreach($informacion as $info){
						$array[$i] = array(
							'idrec' => $info->idrec,
							'idcentro' => $info->idcentro,
							'idproducto' => $info->idproducto,
							'idcliente' => $info->idcliente,
							'idvendedor' => $info->idvendedor,
							'itemline' => $info->itemline,
							'um' => $info->um,
							'documento' => $info->documento,
							'nameCliente' => $info->namecliente,
							'notas' => $info->notas,
							'optionNumber' => 'A',
							'formapago' => $info->formapago,
							'valor' => number_format($info->preciotran, 2, '.', '') * 1
						);
						$i++;
					}
				}
				
				echo json_encode($array);
			}
		}
        
        function ExportacionDeVentas($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('sucursal_model'); $this->load->model('global_model');
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
                $this->data['rpagos_exportarventa'] = $this->global_model->getValorNumVariable('rpagos_exportarventa');
                $this->data['rpagos_dservice'] = $this->global_model->getValorNumVariable('rpagos_dservice');
                
                $this->load->view('mantenimiento_exportacion_ventas', $this->data);
            }
        }
        
        function reporteExportacionDeVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
				$desactivar_pagos = $this->input->post('pagos');
                $dservice=$this->input->post('dservice');
                
                $this->load->model('ventas_model');
                $infoVentas = $this->ventas_model->reporteExportacionVentas($idcentro, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                
                if($infoVentas != false){
                    $tranAnt=0;
                    foreach($infoVentas as $infovn){
                        
                        if($desactivar_pagos == 0){
                            if($tranAnt != $infovn->trannum){
                                $descripPagos = "";
                                $informaPagos = $this->ventas_model->getDatosPagosVentasTrannum($infovn->trannum);
                                if($informaPagos != false){
                                    foreach($informaPagos as $infoPago){
                                        $descripPagos .= $infoPago->descrip.", ";
                                    }
                                    $descripPagos = str_replace("Retención 1%", "", $descripPagos);
                                    $descripPagos = substr($descripPagos, 0, -2);   
                                }
                                
                                if($descripPagos == ""){
                                    $informaPagos = $this->ventas_model->getTipoPagoRealiVenta($infovn->trannum);
                                    if($informaPagos != false){
                                        foreach($informaPagos as $infoPago){
                                            $descripPagos .= $infoPago->descrip;
                                        }
                                    }
                                }
                            }
                        }

                        if($infovn->estatus == 9){
                            $valorComision = 0;
                        }else{
                            $valorComision = $infovn->comision;
                        }
                        
                        if($infovn->tipo == 4){
                            if($dservice == 1){
                                $nombreProducto = $infovn->nameProducto;
                            }else{
                                if($infovn->nameServicio != ""){
                                    $nombreProducto = $infovn->nameServicio;
                                }else{
                                    $nombreProducto = $infovn->nameProducto;
                                }
                            }
                        }else{
                            $nombreProducto = $infovn->nameProducto;
                        }
                        
                        if($desactivar_pagos == 0){
                            $array[$i] = array(
                                "idrec" => (int) $infovn->idrec,
                                "nameSucursal" => strtoupper($infovn->nameSucursal),
                                "nameCaja" => strtoupper($infovn->nameCaja),
                                "estatus" => $infovn->estatus,
                                "trannum" => $infovn->trannum,
                                "serienumero" => $infovn->serie.$infovn->numero,
                                "fecha" => $infovn->fecha,
                                "nameDocumento" => strtoupper($infovn->nameDocumento),
                                "itemline" => $infovn->itemline,
                                "um" => $infovn->um,
                                "marca" => strtoupper($infovn->marca),
                                "modelo" => strtoupper($infovn->modelo),
                                "nameLinea" => strtoupper($infovn->nameLinea),
                                "nameDepartamento" => strtoupper($infovn->nameDepartamento),
                                "idproducto" => $infovn->idproducto,
                                "nameProducto" => strtoupper($nombreProducto),
                                "nameCliente" => strtoupper($infovn->nameCliente),
                                "correoCliente" => $infovn->correoCliente,
                                "telefonoCliente" => $infovn->telefonoCliente,
                                "nrc" => $infovn->nrc,
                                "dui" => $infovn->dui,
                                "nit" => $infovn->nit,
                                "nameVendedor" => strtoupper($infovn->nameVendedor),
                                "nameProveedor" => strtoupper($infovn->nameProveedor),
                                "formaPago" => $descripPagos,
                                "descuento" => number_format($infovn->descuento, 2, '.', '')."%",
                                "comision" => number_format($valorComision, 2, '.', '')."%",
                                "costounitario" => $infovn->costounitario * $infovn->uniconv,
                                "costototal" => $infovn->costounitario * ($infovn->cantidad * -1 * $infovn->uniconv),
                                "precioneto" => $infovn->precioneto*1,
                                "subtotal" => $infovn->precioneto * ($infovn->cantidad * -1),
                                "iva_uni" => $infovn->precioneto * ($infovn->tax1 / 100),
                                "iva_total" => $infovn->precioneto * ($infovn->tax1 / 100)  * ($infovn->cantidad * -1),
                                "totalventa" => ($infovn->precioneto * ($infovn->tax1 / 100)  * ($infovn->cantidad * -1)) + $infovn->precioneto * ($infovn->cantidad * -1),
                                "totalcomision" => (($infovn->precioneto * ($infovn->tax1 / 100)  * ($infovn->cantidad * -1)) + $infovn->precioneto * ($infovn->cantidad * -1)) * ($valorComision / 100),
                                "cantidad" => $infovn->cantidad * -1,
                                "cantidadstock" => $infovn->cantidadstock,
                                "notas" => $infovn->notas,
                            );
                            $i++;
                        }else{
                            $array[$i] = array(
                                "idrec" =>(int) $infovn->idrec,
                                "nameSucursal" => strtoupper($infovn->nameSucursal),
                                "nameCaja" => strtoupper($infovn->nameCaja),
                                "estatus" => $infovn->estatus,
                                "trannum" => $infovn->trannum,
                                "serienumero" => $infovn->serie.$infovn->numero,
                                "fecha" => $infovn->fecha,
                                "nameDocumento" => strtoupper($infovn->nameDocumento),
                                "itemline" => $infovn->itemline,
                                "um" => $infovn->um,
                                "marca" => strtoupper($infovn->marca),
                                "modelo" => strtoupper($infovn->modelo),
                                "nameLinea" => strtoupper($infovn->nameLinea),
                                "nameDepartamento" => strtoupper($infovn->nameDepartamento),
                                "idproducto" => $infovn->idproducto,
                                "nameProducto" => strtoupper($nombreProducto),
                                "nameCliente" => strtoupper($infovn->nameCliente),
                                "correoCliente" => $infovn->correoCliente,
                                "telefonoCliente" => $infovn->telefonoCliente,
                                "nameVendedor" => strtoupper($infovn->nameVendedor),
                                "nameProveedor" => strtoupper($infovn->nameProveedor),
                                "descuento" => number_format($infovn->descuento, 2, '.', '')."%",
                                "comision" => number_format($valorComision, 2, '.', '')."%",
                                "costounitario" => $infovn->costounitario * $infovn->uniconv,
                                "costototal" => $infovn->costounitario * ($infovn->cantidad * -1 * $infovn->uniconv),
                                "precioneto" => $infovn->precioneto*1,
                                "subtotal" => $infovn->precioneto * ($infovn->cantidad * -1),
                                "iva_uni" => $infovn->precioneto * ($infovn->tax1 / 100),
                                "iva_total" => $infovn->precioneto * ($infovn->tax1 / 100)  * ($infovn->cantidad * -1),
                                "totalventa" => ($infovn->precioneto * ($infovn->tax1 / 100)  * ($infovn->cantidad * -1)) + $infovn->precioneto * ($infovn->cantidad * -1),
                                "totalcomision" => (($infovn->precioneto * ($infovn->tax1 / 100)  * ($infovn->cantidad * -1)) + $infovn->precioneto * ($infovn->cantidad * -1)) * ($valorComision / 100),
                                "cantidad" => $infovn->cantidad * -1,
                                "cantidadstock" => $infovn->cantidadstock,
                                "notas" => $infovn->notas,
                            );
                            $i++;
                        }
                        
                        $tranAnt = $infovn->trannum;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getListadoProductosVendidosRegalo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                $fecha = $this->input->post('fecha');
                
                $this->load->model('ventas_model'); 
                $informacion = $this->ventas_model->getListadoClientesProductosVentas($idcentro, $idcaja, $fecha);
                
                $i=0;
                $array = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        
                        if($info->imagen != ""){
                            $srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$info->imagen;
                            $gdImage = FCPATH.'img_cuentas/'.$this->session->userdata('diraccount')."/".$info->imagen;
                            if(file_exists($gdImage)){
                                $srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$info->imagen;
                            }else{
                                $srcImagen = base_url()."img/sinImagen.png";
                            }
                        }else{
                            $srcImagen = base_url()."img/sinImagen.png";
                        }
                        
                        if(abs($info->cantidad) > 1){
                            for($j=0; $j<abs($info->cantidad); $j++){
                                $array[$i] = array(
                                    "trannum" => strtoupper($info->trannum),
                                    "nameCliente" => $info->nameCliente,
                                    "nameProducto" => $info->nameProducto,
                                    "numero" => $info->numero,
                                    "serie" => $info->serie,
                                    "preciotran" => $info->preciotran,
                                    "cantidad" => 1,
                                    "idrec" => $info->idrec,
                                    "imagen" => $srcImagen
                                );
                                $i++;
                            }
                        }else{
                            $array[$i] = array(
                                "trannum" => strtoupper($info->trannum),
                                "nameCliente" => $info->nameCliente,
                                "nameProducto" => $info->nameProducto,
                                "numero" => $info->numero,
                                "serie" => $info->serie,
                                "preciotran" => $info->preciotran,
                                "cantidad" => abs($info->cantidad),
                                "idrec" => $info->idrec,
                                "imagen" => $srcImagen
                            );
                            $i++;
                        }
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function imprimirTicketDeRegalo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idrec = $this->input->post('idrec');
                
                $this->load->model('ventas_model'); $this->load->model('global_model');
				$this->load->model('sucursal_model'); $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $infoProducto = $this->ventas_model->getInformacionProductoTicket($idrec);
                
                
				foreach($infoProducto as $infoPro){
					$nameProducto = $infoPro->nameProducto;
					$idProducto = $infoPro->idproducto;
				}
                
				foreach($informacion as $info){
					$idcentro = $info->idcentro; 
					$idcaja = $info->idcaja;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				
                $array = array(
                    "razonsocial" => $RazonSocial,
                    "namecentro" => $namecentro,                
                    "tipodocumento" => strtoupper($info->descrip),                
                    "numdocumento" => $info->numero,                
                    "namevendedor" => strtoupper($info->nameVendedor),                
                    "datos_print" => $datosprint,
                    "nameProducto" => $nameProducto,
                    "idProducto" => $idProducto
                );
                
                echo json_encode($array);
            }
        }
        
        function getListadoMultiplesPrecios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('ventas_model'); 
                $array = $this->ventas_model->getListadoMultiplesPrecios($idproducto, 1, 1);
                
                echo json_encode($array);
            }
        }

        function getListadoMultiplesPreciosLP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idproducto  = $this->input->post('idproducto');
                $pos_lprecio = $this->input->post('pos_lprecio');
                $nlPrecios   = $this->input->post('nlPrecios');
                
                $this->load->model('ventas_model'); 
                $array = $this->ventas_model->getListadoMultiplesPreciosLP($idproducto, 1, 1, $pos_lprecio, $nlPrecios);
                
                echo json_encode($array);
            }
        }
        
        function getListadoCorrelativosDisponibles(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                
                $this->load->model('ventas_model'); 
                $fechas      = $this->ventas_model->getRangoFechasCaja($idcaja);
                $informacion = $this->ventas_model->getListadoTransaccionesDisponibles('VN', 1);

                $i=0;
                $correlativos = array();
                foreach($informacion as $info){
                    if($info->numtipo == 1){ //Empresa
                        $serie = $this->ventas_model->getSerieDocumentoEmpresa($info->invclase);
                        $numeros = $this->ventas_model->getInformacionNumerosDocumentoEmpresa($info->invclase);
                    }else if($info->numtipo == 2){ //Sucursal
                        $serie = $this->ventas_model->getSerieDocumentoSucursal($info->invclase, $idcentro);
                        $numeros = $this->ventas_model->getInformacionNumerosDocumentoSucursal($info->invclase, $idcentro);
                    }else if($info->numtipo == 3){ //Caja
                        $serie = $this->ventas_model->getSerieDocumento($info->invclase, $idcentro, $idcaja);
                        $numeros = $this->ventas_model->getInformacionNumerosDocumento($info->invclase, $idcentro, $idcaja);
                    }

                    if($numeros != false){
                        $diferencia = $numeros['hasta'] - $numeros['actual'];
                        $correlativos[$i] = array(
                            "tipodoc" => $info->descrip,
                            "serie" => $serie,
                            "ultimo" => $numeros['actual'],
                            "disponible" => $diferencia,
                        );
                        $i++;
                    }
                }

                $array = array(
                    "correlativos" => $correlativos,
                    "fechaini"     => $fechas['bfecha'],
                    "fechafin"     => $fechas['efecha']
                );
                
                echo json_encode($array);
            }
        }

        function verificacionKeyUsuario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $textoKey = $this->input->post('textoKey');
                
                $this->load->model('ventas_model'); 
                $array = $this->ventas_model->verificacionKeyUsuario($textoKey);
                
                echo json_encode($array);
            }
        }

        function verificacionCodeUsuario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idusuario = $this->input->post('idusuario');
                $textCode = $this->input->post('textCode');
                
                $this->load->model('ventas_model'); 
                $array = $this->ventas_model->verificacionCodeUsuario($idusuario, $textCode);
                
                echo json_encode($array);
            }
        }

        function getListadoVariablesFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idusuario = $this->input->post('idusuario');

                $this->load->model('ventas_model'); 
                $dataSource = $this->ventas_model->getListadoVariablesFacturacion($idusuario);
                
                $i=0;
                $array=array();

                foreach($dataSource as $info){
                    $array[$i] = array(
                        "idrnum" => $info->idrnum,
                        "nombre" => $info->nombre,
                        "descripcion" => $info->descripcion,
                        "valor_num" => $info->valor_num * 1,
                    );
                    $i++;
                }

                echo json_encode($array);
            }
        }

        function updateRegistroVariableSecurity(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $valor = $this->input->post('valor');
                $idrnum = $this->input->post('idrnum');
                $idusuario = $this->input->post('idusuario');

                $this->load->model('ventas_model'); 
                $this->ventas_model->updateRegistroVariableSecurity($idrnum, $valor, $idusuario);
                $dataSource = $this->ventas_model->getListadoVariablesFacturacion($idusuario);
                
                $i=0;
                $array=array();

                foreach($dataSource as $info){
                    $array[$i] = array(
                        "idrnum" => $info->idrnum,
                        "nombre" => $info->nombre,
                        "descripcion" => $info->descripcion,
                        "valor_num" => $info->valor_num * 1,
                    );
                    $i++;
                }

                echo json_encode($array);
            }
        }

        function getResumenVentasPorVendedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $idcaja = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('ventas_model');
                $informacion  = $this->ventas_model->getResumenVentasPorVendedor($fecha, $idcentro, $idcaja);

                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){

                        $totalOtros = $info->total - $info->efectivo - $info->tarjeta;

                        $dataSource[$i] = array(
                            "namevendedor" => $info->namevendedor,
                            "efectivo" => $info->efectivo * -1,
                            "tarjeta" => $info->tarjeta * -1,
                            "otros" => $totalOtros * -1,
                            "total" => $info->total * -1,
                            "numventas" => $info->numventas,
                            "undfacturadas" => $info->undfacturadas
                        );

                        $i++;
                    }
                }

                echo json_encode($dataSource);
            }
        }

        function getResumenVentasPorProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $idcaja = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('ventas_model');
                $informacion  = $this->ventas_model->getResumenVentasPorProducto($fecha, $idcentro, $idcaja);

                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){

                        $precioPromedio = $info->valconiva / $info->unidades;

                        $dataSource[$i] = array(
                            "idproducto" => $info->idproducto,
                            "modelo" => $info->modelo,
                            "marca" => $info->marca,
                            "namelinea" => $info->namelinea,
                            "descrip" => $info->descrip,
                            "unidades" => $info->unidades * -1,
                            "valsiniva" => $info->valsiniva * -1,
                            "valconiva" => $info->valconiva * -1,
                            "prepromedio" => $precioPromedio * -1,
                            "existencias" => $info->existencias
                        );

                        $i++;
                    }
                }

                echo json_encode($dataSource);
            }
        }
        #------------------------------------------------------ VENTAS POR CLIENTE ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        public function ventasXCliente($idApp)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $direccion = $this->uri->segment(1);
                $this->load->model('global_model');
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->load->view("mantenimiento_ventascliente", $this->data);
            }
        }
        #   GET CLIENTES
        public function getClientes()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('ventas_model');
                if ($datos = $this->ventas_model->getClientes()) {
                    $Datos = [];
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $Datos[] = array(
                                'ID' => $dato->idauxi,
                                'Name' => $dato->descrip,
                            );
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #   GET REGISTROS
        public function getVentasxCliente()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('ventas_model');
                $ID = $this->input->post("ID");
                $fi = $this->input->post("fechai");
                $ff = $this->input->post("fechaf");
                if ($datos = $this->ventas_model->getVentasxCliente($ID, $fi, $ff)) {
                    $Datos = [];
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $Datos[] = array(
                                'trannum' => $dato->trannum,
                                'sucursal' => $dato->sucursal,
                                'serien' => $dato->serie.'-'.$dato->numero,
                                'fecha' => $dato->fecha,
                                'ttransaccion' => $dato->ttransaccion,
                                'itemline' => $dato->itemline,
                                'codigo' => $dato->idproducto,
                                'producto' => $dato->producto,
                                'linea' => $dato->linea,
                                'cantidad' => $dato->cantidad,
                                'costo' => $dato->costounitario,
                                'preciou' => $dato->precioneto,
                                'iva' => ($dato->preciotran - $dato->precioneto),
                                //'preciot' => $dato->preciototal
                                'preciot' => $dato->cantidad * $dato->precioneto,
                                'vendedor' => $dato->vendedor,

                            );
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #------------------------------------------------------ FIN VENTAS POR CLIENTE ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #---------------------------- EMGG-------------------------
        #-------------------------------- Monitor Cuotas------------------------------------------
        // 20210323 17:52 EMGG
        
        function monitorcuotas($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                
                $funcion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($funcion);
                
                $this->load->view('monitor_cuotas', $this->data); 
            }
        }
        
        function getmonitorcuotas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fecha_ini = $this->input->post("fecha_ini");
                $fecha_fin = $this->input->post("fecha_fin");
                
                $this->load->model('ventas_model');                
                $informacion = $this->ventas_model->getmCuotas($fecha_ini, $fecha_fin);                
                
                $i=0;
                $tantos=1;
				$array = array();
				if($informacion!=false){
					foreach($informacion as $info){
						$array[$i] = array(                            
                            "Fecha"=>$info->Fecha,
                            "Cliente"=>$info->Cliente,
                            "Tipo de Contrato"=>$info->Tipo,   
                            "Servicio o Producto"=>$info->Descrip,                           
                            "Valor" => $info->Valor
                        );
                        $i++;
					}
				}
                                
                echo json_encode($array);
            }
        }
    
        #-----------------------------------------------------------------------------------------
        function getInformacionImeis() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('ventas_model');
                $infoSource = $this->ventas_model->getDataVentaTran100kIMEI($trannum, $idcentro);
                
                echo json_encode($infoSource);
            }
        }


        function buscarCodigoImei() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $codeIMEI = $this->input->post("imei");
                $trannum  = $this->input->post('trannum');
                $provende = $this->input->post('provende');
                $modevn   = $this->input->post('modevn');
                $idworker = $this->input->post('idworker');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('ventas_model');
                $result = $this->ventas_model->buscarCodigoImei($codeIMEI, $trannum, $provende, $modevn, $idworker, $idcentro);
                
                if ($result) {
                    $infoSource = $this->ventas_model->getDataVentaTran100kIMEI($trannum, $idcentro);

                    $array = array(
                        'infoSource' => $infoSource,
                        'result' => 1
                    );
				} else if ($result == 0) {
                    $array = array(
                        'result' => 0
                    );
                }
                                
                echo json_encode($array);
            }
        }

        function getInformacionCloseImei() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum     = $this->input->post('trannum');
                $idcatalogo  = $this->input->post('idcatalogo');
                $filtrodatos = $this->input->post('filtrodatos');
                $opcion      = $this->session->userdata('opcionmenu');
                
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                
                if($filtrodatos == 1){
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 2){
                    $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 3){
                    $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 4){
                    $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "presenta" => $info->presenta,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "upp" => $info->upp,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    } 
                    
                    $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "presenta" => $info->presenta,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "upp" => $info->upp,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }else if($filtrodatos == 5){
                    $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "presenta" => $serv->presenta,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "upp" => $serv->upp,
                            "xpos" => $serv->xpos,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                
                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
                
                if($filtrodatos == 1){
                    $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                }
                
                if($filtrodatos != 4 && $filtrodatos != 5){
                    $i=0;
                    $items = array();
                    foreach($detalle as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "presenta" => $info->presenta,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "upp" => $info->upp,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }
                
                if($filtrodatos == 1){
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "presenta" => $serv->presenta,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "upp" => $serv->upp,
                            "xpos" => $serv->xpos,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }
        }

        function deleteCodigoIMEI() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec       = $this->input->post("idrec");
                $codeIMEI    = $this->input->post("imei");
                $trannum     = $this->input->post('trannum');
                $idcentro    = $this->session->userdata('idcentrouser');
                $option      = $this->input->post('option');
                $idcatalogo  = $this->input->post('idcatalogo');
                $filtrodatos = $this->input->post('filtrodatos');
                $opcion      = $this->session->userdata('opcionmenu');

                $this->load->model('ventas_model');
                $this->ventas_model->deleteCodigoIMEI($idrec, $codeIMEI);
                
                if ($option == 1) {
                    $this->load->model('invtran_model');
                    
                    if($opcion == 1){
                        $idcentro = $this->session->userdata('idcentroTemp');
                    }else{
                        $idcentro = $this->session->userdata('idcentrouser');
                    }
                    
                    if($filtrodatos == 1){
                        $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                    }else if($filtrodatos == 2){
                        $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                    }else if($filtrodatos == 3){
                        $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                    }else if($filtrodatos == 4){
                        $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                        
                        $i=0;
                        $items = array();
                        foreach($inventariomore as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "upp" => $info->upp,
                                "xpos" => $info->xpos,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        } 
                        
                        $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                        foreach($inventariomore as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "upp" => $info->upp,
                                "xpos" => $info->xpos,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        }
                    }else if($filtrodatos == 5){
                        $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                        
                        $i=0;
                        $items = array();
                        foreach($servicios as $serv){
                            $items[$i] = array(
                                "nameproducto" => $serv->descrip,
                                "marca" => $serv->marca,
                                "modelo" => $serv->modelo,
                                "upc" => $serv->barcode,
                                "presenta" => $serv->presenta,
                                "notas" => $serv->notas,
                                "idproducto" => $serv->idproducto,
                                "tipo" => $serv->tipo,
                                "um" => $serv->um,
                                "upp" => $serv->upp,
                                "xpos" => $serv->xpos,
                                "imagen" => $serv->imagen,
                                "cantidad" => $serv->cantidad,
                                "precio" => $serv->costounitario,
                                "idbin" => $serv->idbin,
                                "idbatch" => $serv->idbatch,
                                "precioventa" => $serv->precioventa,
                                "idcatalogo" => $serv->idcatalogo,
                                "tipotax" => $serv->tipotax
                            );
                            $i++;
                        }
                    }
                    
                    $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                    
                    $total = 0; $cantidad = 0; $unidades = 0;
                    foreach($datos as $data){
                        $total = $total + $data->precioneto * abs($data->cantidad);
                        $cantidad = $cantidad + abs($data->cantidad);
                        $unidades++;
                    }
                    
                    if($filtrodatos == 1){
                        $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                    }
                    
                    if($filtrodatos != 4 && $filtrodatos != 5){
                        $i=0;
                        $items = array();
                        foreach($detalle as $info){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "presenta" => $info->presenta,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "tipo" => $info->tipo,
                                "upp" => $info->upp,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "tipotax" => $info->tipotax
                            );
                            $i++;
                        }
                    }
                    
                    if($filtrodatos == 1){
                        foreach($servicios as $serv){
                            $items[$i] = array(
                                "nameproducto" => $serv->descrip,
                                "marca" => $serv->marca,
                                "modelo" => $serv->modelo,
                                "upc" => $serv->barcode,
                                "presenta" => $serv->presenta,
                                "notas" => $serv->notas,
                                "idproducto" => $serv->idproducto,
                                "tipo" => $serv->tipo,
                                "um" => $serv->um,
                                "xpos" => $serv->xpos,
                                "upp" => $serv->upp,
                                "imagen" => $serv->imagen,
                                "cantidad" => $serv->cantidad,
                                "precio" => $serv->costounitario,
                                "idbin" => $serv->idbin,
                                "idbatch" => $serv->idbatch,
                                "precioventa" => $serv->precioventa,
                                "idcatalogo" => $serv->idcatalogo,
                                "tipotax" => $serv->tipotax
                            );
                            $i++;
                        }
                    }
                    
                    $infoSource = array(
                        "items" => $items,
                        "datos" => $datos,
                        "cantidad" => $unidades,
                        "unidades" => $cantidad,
                        "count" => $i
                    );
                } else if ($option == 0) {
                    $infoSource = $this->ventas_model->getDataVentaTran100kIMEI($trannum, $idcentro);
                }

                echo json_encode($infoSource);
            }
        }
        
        function getDatosIngresosEgresos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $optIG    = $this->input->post('optIG');
                $numx     = $this->input->post('numx');
                $numz     = $this->input->post('numz');
                $idcaja   = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('ventas_model');
                $infoig     = $this->ventas_model->getTiposIG($optIG);
                $infopagos  = $this->ventas_model->getFormasPagoOI($optIG);
                $datasource = $this->ventas_model->getDetalleCorteOI($optIG, $idcentro, $idcaja, $numx, $numz);


                $array = array(
                    'infoig'     => $infoig,
                    'infopagos'  => $infopagos,
                    'datasource' => $datasource,
                );

                echo json_encode($array);
            }
        }

        function insertComprobanteIG () {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $optIG    = $this->input->post('optIG');
                $fecha    = $this->input->post('fecha');
                $numx     = $this->input->post('numx');
                $numz     = $this->input->post('numz');
                $idcaja   = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');
                $valor    = $this->input->post('valor');
                $tipoIG   = $this->input->post('tipoIG');
                $cajclase = $this->input->post('cajclase');
                $concepto = $this->input->post('concepto');
                
                $this->load->model('ventas_model');
                $idrec = $this->ventas_model->insertComprobanteIG($optIG, $fecha, $numx, $numz, $idcaja, $idcentro, $valor, $tipoIG, $cajclase, $concepto);
                $datasource = $this->ventas_model->getDetalleCorteOI($optIG, $idcentro, $idcaja, $numx, $numz);


                $array = array(
                    'idrec' => $idrec,
                    'datasource' => $datasource
                );

                echo json_encode($array);
            }
        }

        function validatePasswordAnulacionIG () {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $optIG    = $this->input->post('optIG');
                $idrec    = $this->input->post('idrec');
                $password = $this->input->post('password');
                $numx     = $this->input->post('numx');
                $numz     = $this->input->post('numz');
                $idcaja   = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('ventas_model');
                $validate = $this->ventas_model->validatePasswordAnulacionIG($idrec, $password);
                $datasource = $this->ventas_model->getDetalleCorteOI($optIG, $idcentro, $idcaja, $numx, $numz);


                $array = array(
                    'validate' => $validate,
                    'datasource' => $datasource
                );

                echo json_encode($array);
            }
        }

        function getDetalleAniosCortesZ () {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcaja   = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDetalleAniosCortesZ($idcentro, $idcaja);

                echo json_encode($array);
            }
        }
        
        function getDetalleMesesCortesZ () {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcaja   = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');
                $idanio   = $this->input->post('idanio');
                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDetalleMesesCortesZ($idcentro, $idcaja, $idanio);

                echo json_encode($array);
            }
        }

        function reporteAuditoriaElectronica($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('invtran_model');
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $this->load->model('user_model');
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $fechaactual = $date->format('Y-m-d');
                
                $permite = 0;
                $derechos = $this->user_model->getDerechos();
                if($derechos != ""){
                    $pos = strpos($derechos, "costo");
                    if($pos !== false){
                        if($pos >= 0){
                            $permite=1;
                        }   
                    }
                }
                $appName = $this->configuracion_model->getAppName($idApp);
                
                $infoAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                $direccion = $this->uri->segment(1);
                
                $this->data['pos_referencia'] = $this->global_model->getValorNumVariable('pos_referencia');
                $this->data['fechaactual'] = $fechaactual;
                $this->data['sucursales']  = $this->invtran_model->getAllCentrosActivos();
                $this->data['permite_derechos'] = $permite;

                $this->load->view('mantenimiento_auditoria_electronica', $this->data);
            }
        }

        function getDetalleFechaCortesZ() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcaja   = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');
                $fechaini   = $this->input->post('fechaini')." 00:00:00";
                $fechafin   = $this->input->post('fechafin')." 23:59:99";

                
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getDetalleFechaCortesZ($idcentro, $idcaja, $fechaini, $fechafin);

                echo json_encode($array);
            }
        }

        function getDatosAuditoriaElectronica(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $idcaja   = $this->input->post('idcaja');
                $fecha = date_format(date_create($fechaini), 'dmY');
                $datosCinta = [];
                $this->load->model('ventas_model'); 

                $apertura = $this->ventas_model->getCodigoImpresion('A'.$idcentro.$idcaja.$fecha, 2); //Obtiene el dato de la apertura

                if(empty($apertura)){ echo json_encode(false); exit;} //si no existe el dato se detiene el proceso

                $datosCinta[0] = ["descrip" => "Apertura de Caja", "numtrans" => 0,"fecha"=>$apertura['ingresa']];

                $numz = $this->ventas_model->getDetalleFechaCortesZ($idcentro, $idcaja, $fechaini, $fechafin); //obtiene el num z 
                if(empty($numz)){ echo json_encode(false); exit;}

                $numx = $this->ventas_model->getDetalleFechaCortesX($idcentro, $idcaja, $fechaini, $fechafin,$numz['numz']);//obtiene el o los num x
                if(empty($numx)){ echo json_encode(false); exit;}

                $i = 1;
                foreach($numx as $x){
                    //para cada num x se buscan sus tickets relacionados
                    $tickets = $this->ventas_model->getDatosFacturacionesNumXZ('VN', $idcentro, $idcaja, $fechaini, $fechafin, $numz['numz'], $x['numx']);
                    if(!empty($tickets)){
                        $countx = count($tickets);
                    }else{
                        $countx = 0;
                    }
                    $corteX = $this->ventas_model->getCodigoImpresion('CX'.$idcentro.$idcaja.$numz['numz'].$x['numx'], 2); //se obtienen los datos de la impresion del corte x 

                    $datosCinta[$i] = ["descrip" => "Corte X #".$i, "numtrans" => $countx,"fecha"=>$corteX['ingresa']];
                    $i+=1;
                }

                $ultimoX = end($numx);
                $ultimoX = (int)$ultimoX['numx'] + 1; //al ultimo num x se le suma 1 para obtener el codigo de la impresion del corte z
                $corteZ = $this->ventas_model->getCodigoImpresion('CZ'.$idcentro.$idcaja.$numz['numz'].$ultimoX, 2);
                if(empty($corteZ)){ echo json_encode(false); exit;}

                $datosCinta[$i] = ["descrip" => "Corte Z #".$numz['numz'], "numtrans" => 0,"fecha"=>$corteZ['ingresa']];
                $respuesta= ["numz" =>$numz['numz'], "datos"=>$datosCinta ];
                echo json_encode($respuesta);
            }
        }

        function getDatosFacturasVentasDiarias(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $idcaja   = $this->input->post('idcaja');
                
                $this->load->model('variable_model');
                $this->load->model('ventas_model'); 
                $this->load->model('invtran_model');
                $this->load->model('dev_model');

				$porcentaje_iva = $this->variable_model->getValorIVA();
                $datos = $this->dev_model->getDatosFacturaciones('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    if($info->estatus!=0){
						$j = 0;
                        $valtax1 = 0;
                        $totalDescuento = 0;
                        $totalComision = 0;
                        $detailFacturas = array();
						$detalle = $this->invtran_model->getDetalleFacturas($info->trannum);
                        
						foreach($detalle as $data){
							$valtax1 = 0;
                            if( $info->exento == 0 ){
                                $valtax1 = $data->precioneto * ($data->tax1 / 100);
                            }else{
                                $valtax1 = 0;
                            }
                            
                            if($data->descuento != 0){
                                $totalDescuento = $totalDescuento + ((($data->preciotran / (1 + ($data->tax1/100))) -  $data->precioneto) * abs($data->cantidad));
                            }
                            
                            if($data->comision != 0){
                                $totalComision = $totalComision + (($data->preciotran * ($data->comision/100)) * abs($data->cantidad));
                            }
                            
                            $total = abs($data->cantidad) * ($data->precioneto + $valtax1);
                            
                            $j++;
                        }
						
                        $exento_doc = 0; $gravado_doc = 0; $iva_doc = $info->valtax1;
                        if($info->exento==1){
                            $exento_doc = $info->valventan;
                        }else{
                            if ( $porcentaje_iva != 0 ) {
                                $gravado_doc = ($info->valtax1 / ($porcentaje_iva/100));
                            } else  $gravado_doc = $info->valventan;

                            $exento_doc = number_format($info->valventan-$gravado_doc, 2, '.', '');
                        }

                        $totalVenta = $info->valventan + $iva_doc;

                        if(($info->idtipo == 3) && ($gravado_doc>=100)){
                            $reten = $gravado_doc * 0.01;
                            $retencion = '-'.$reten;
                            $totalVenta = $totalVenta-$reten;
                        }else{
                            $retencion = 0;
                        }
                        
                        $descripPagos = "";
                        $informaPagos = $this->ventas_model->getDatosPagosVentasTrannum($info->trannum);
                        
                        if($informaPagos != false){
                            foreach($informaPagos as $infoPago){
                                $descripPagos .= $infoPago->descrip.", ";
                            }
                            $descripPagos = str_replace("Retención 1%", "", $descripPagos);
                            $descripPagos = substr($descripPagos, 0, -2);   
                        }

                        if($descripPagos == ""){
                            $informaPagos = $this->ventas_model->getTipoPagoRealiVenta($info->trannum);
                            if($informaPagos != false){
                                foreach($informaPagos as $infoPago){
                                    $descripPagos .= $infoPago->descrip;
                                }
                            }
                        }

                        if($info->registro != ""){
                            $registro = $info->registro;
                        }else{
                            $registro = "SIN REGISTRO";
                        }

                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "fecha" => $info->fecha,
                            "tipodoc" => $info->tipodoc,
                            "seriedoc" => $info->serie,
                            "numeroserie" => $info->numero * 1,
                            "doc_dev" => $info->dev_serie.$info->dev_numero,
                            "nit" => $info->nit,
                            "numx" => $info->numx,
                            "numz" => $info->numz,
                            "registro" => $registro,
                            "namecliente" => $info->namecliente,
                            "idclienteauxi" => $info->idclienteauxi,
                            "namesucursal" => $info->namesucursal,
                            "namecaja" => $info->namecaja,
                            "namevendedor" => $info->namevendedor,
                            "valventan" => number_format($totalVenta, 6, '.', ''),
                            "exento" => number_format($exento_doc, 6, '.', ''),
                            "gravado" => number_format($gravado_doc, 6, '.', ''),
                            "iva" => number_format($iva_doc, 6, '.', ''),
                            "retencion" => number_format($retencion, 6, '.', ''),
                            "descuento" => number_format($totalDescuento, 6, '.', ''),
                            "comision" => number_format($totalComision, 6, '.', ''),
                            "estatus" => $info->estatus,
                            "formaPago" => $descripPagos,
                            "notas_fact" => $info->notas,
                            "referencia" => $info->referencia,
                            "valcosto" => number_format($info->valcosto * -1, 6, '.', '')
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }

        function crearCintaAuditoria(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                $this->load->model('ventas_model'); 
                $this->load->model('caja_model');	
                
                $datos = $this->input->post('datos');
                $datosBusqueda = $this->input->post('datosBusqueda');
                $numz = $this->input->post('numz');

                $datoscaja = $this->caja_model->getNameCaja($datosBusqueda['idcaja']);
                foreach($datoscaja as $caja){
                    $printerName = $caja->notas;
				}

                $fechaactual = date("dmY");
                $fecha = date_format(date_create($datosBusqueda['fechaini']), 'dmY');
                $acumuladoCodigo = "";

                //obtiene la apertura de caja
                $apertura = $this->ventas_model->getCodigoImpresion('A'.$datosBusqueda['idcentro'].$datosBusqueda['idcaja'].$fecha, 2);
                $acumuladoCodigo .= $apertura['notas'];
                $acumuladoCodigo = str_replace('0x0A0x0A0x0A0x0A0x0A', ' ', $acumuladoCodigo); //elimina los espacios al final de la apertura
                $acumuladoCodigo .= '0x0A-----------------------------------------------------0x0A';

                //obtiene un listado de los numx relacionados al num z dado
                $numx = $this->ventas_model->getDetalleFechaCortesX($datosBusqueda['idcentro'], $datosBusqueda['idcaja'], $datosBusqueda['fechaini'], $datosBusqueda['fechafin'], $numz);

                foreach($numx as $x){                    
                    // obtiene el trannum de los tickets de un mismo num x
                    $tickets = $this->ventas_model->getDatosFacturacionesNumXZ('VN', $datosBusqueda['idcentro'], $datosBusqueda['idcaja'], $datosBusqueda['fechaini'], $datosBusqueda['fechafin'], $numz, $x['numx']);
                    if(!empty($tickets)){
                        // si el listado de trannums no es vacio, obtiene los codigos de impresion relacionados
                        foreach($tickets as $ticket){
                            $impresionTicket = $this->ventas_model->getCodigoImpresion($ticket['trannum'], 1);
                            if($impresionTicket){
                                $indiceFullCut = strpos($impresionTicket['notas'], '0x1D0x560x1');
                                $acumuladoCodigo .= substr($impresionTicket['notas'], 0, $indiceFullCut);
                                $acumuladoCodigo .= '0x0A-----------------------------------------------------0x0A';
                            }
                        }
                    }
                    //obtiene el codigo de impresion del corte x 
                    $corteX = $this->ventas_model->getCodigoImpresion('CX'.$datosBusqueda['idcentro'].$datosBusqueda['idcaja'].$numz.$x['numx'], 2);
                    $acumuladoCodigo .=  $corteX['notas'];
                    $acumuladoCodigo .= '0x0A-----------------------------------------------------0x0A';

                }

                //obtiene el codigo de impresion del corte z
                $ultimoX = end($numx);
                $ultimoX = (int)$ultimoX['numx'] + 1; //al ultimo num x se le suma 1 para obtener el codigo de la impresion del corte z
                $cortez = $this->ventas_model->getCodigoImpresion('CZ'.$datosBusqueda['idcentro'].$datosBusqueda['idcaja'].$numz.$ultimoX, 2);
                $acumuladoCodigo .=  $cortez['notas'];


                //Se eliminan los espacios entre los tickets y cortes
                $acumuladoCodigo = str_replace('0x0A0x0A0x0A0x0A0x0A0x0A0x0A', ' ', $acumuladoCodigo);
                //se eliminan los fullcut
                $acumuladoCodigo = str_replace('0x1D0x560x1', ' ', $acumuladoCodigo);
                //se eliminan las pulsaciones a la caja
                $acumuladoCodigo = str_replace('0x1B0x700x00x190xFA', ' ', $acumuladoCodigo);

                //se adiciona el comando fullcut
                $acumuladoCodigo .= "0x0A0x0A0x0A0x0A". '0x1D'.'0x56'.'0x1';


                $trannum= "AE".$datosBusqueda['idcentro'].$datosBusqueda['idcaja'].$numz.$fechaactual; //Auditoria electronica

                $this->ventas_model->setCommandsPrint($trannum, $acumuladoCodigo, 2); //1 -> facturas 2->cortes
                echo json_encode($trannum);
                /*
                $printerName = "EPSON TM-m30";                
                header('Location: webclientprintvi:https://www.vgoxpos.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;*/
            }
        }

        function validacionClienteDocumento() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $field = $this->input->post('field');
                $registro = $this->input->post('registro');
                $idcliente = $this->input->post('idcliente');

                $this->load->model('ventas_model');
                $validate = $this->ventas_model->validacionClienteDocumento($field, $registro, $idcliente);

                echo json_encode($validate);
            }
        }

        function getValidacionCamposVenta() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');

                $this->load->model('ventas_model');
                echo json_encode($this->ventas_model->getValidacionCamposVenta($idclase));
            }
        }


        function creditosVentas($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('cliente_model');
                $this->load->model('arap_model');

                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $clientes = $this->cliente_model->viewClientesConLimite(1);
                $descrips = array_column($clientes, 'descrip');
			    array_multisort($descrips, SORT_ASC, $clientes);
                $this->data['clientes'] = $clientes;
                $this->data['formas_pago'] = $this->arap_model->formasPago_ar("-1");;

                
                $this->load->view('mantenimiento_creditos_ventas', $this->data);
            }
        }

        function getCreditosVentasCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $idauxi = $this->input->post('idauxi');
                $this->load->model('ventas_model');
                
                $arrayCreditos = [];
                $i = 0;
                $creditos = $this->ventas_model->getCreditosVentasCliente($idauxi);
                if($creditos){
                    $now = new DateTime();
                    $now = $now->format('Y-m-d');

                    foreach($creditos as $c){
                        $arrayCreditos[$i] = array(
                            "trannum" => $c->trannum,
                            "serienum" => $c->serie.$c->numero,
                            "fecha" => $c->fecha,
                            "tipoDoc" => $c->tipoDoc,
                            "saldoPendiente" => $c->valventan + $c->valtax1 + $c->valtax2 + $c->valtax3 + $c->valtax4 + $c->valtax5 + $c->valdh,
                            "dias" => $c->dias,
                            "idclase" => $c->idclase,

                        );
                        $i++;
                    }
                }
                
                echo json_encode($arrayCreditos);
            }   
        }

        function cancelarCreditosVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{

                $formapago = $this->input->post('formapago');
                $notas = $this->input->post('notas');
                $docs = $this->input->post('docs');
                $tipo = $this->input->post('tipo');
                $montoabono = $this->input->post('montoabono');

                $this->load->model('ventas_model');

                if($tipo != 0 && $montoabono > $docs["saldoPendiente"]){
                    $mensaje = "¡Error! El monto a abonar no puede ser mayor al saldo pendiente.";
                    echo json_encode(["resultado"=>false, "mensaje"=>$mensaje]);
                    exit;

                }
                
                $resultado = $this->ventas_model->cancelarCreditosVentas($montoabono,$formapago,$notas,$docs, $tipo);
                if($resultado){
                    if($tipo == 0){
                        foreach($docs as $doc){
                            $this->ventas_model->updateCCEstatus($doc["trannum"], 1);
                            $this->ventas_model->callTotaliza100($doc["trannum"], 1);
                        }
                    }else{
                        if($montoabono == $docs["saldoPendiente"]){
                            $this->ventas_model->updateCCEstatus($docs["trannum"], 1);
                        }
                        $this->ventas_model->callTotaliza100($docs["trannum"], 1);
                    }

                    $mensaje = "Los créditos de venta seleccionados se han cancelado con exito.";
                }else{
                    $mensaje = "¡Error! Hubo un error al cancelar los créditos de venta seleccionados.";
                }
                
                echo json_encode(["resultado"=>$resultado, "mensaje"=>$mensaje]);
            } 
        }

        //  BITACORA DE VENTAS
        function getListadoCajasBitacora(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');

                $this->load->model('ventas_model');
                $array = $this->ventas_model->getListadoCajasBitacora($idcentro);
                echo json_encode($array);
            }
        }

        function getDatosFacturasBitacoraVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $idcaja   = $this->input->post('idcaja');
                                
                $this->load->model('variable_model');
                $this->load->model('ventas_model'); 
                $this->load->model('invtran_model');
                $this->load->model('dev_model');

				$porcentaje_iva = $this->variable_model->getValorIVA();
                $datos = $this->ventas_model->getDatosFacturacionesBitacora('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    if($info->estatus!=0){
						$j = 0;
                        $valtax1 = 0;
                        $totalDescuento = 0;
                        $totalComision = 0;
                        $detailFacturas = array();
						$detalle = $this->invtran_model->getDetalleFacturas($info->trannum);
                        
                        
						foreach($detalle as $data){
							$valtax1 = 0;
                            if( $info->exento == 0 ){
                                $valtax1 = $data->precioneto * ($data->tax1 / 100);
                            }else{
                                $valtax1 = 0;
                            }
                            
                            if($data->descuento != 0){
                                $totalDescuento = $totalDescuento + ((($data->preciotran / (1 + ($data->tax1/100))) -  $data->precioneto) * abs($data->cantidad));
                            }
                            
                            if($data->comision != 0){
                                $totalComision = $totalComision + (($data->preciotran * ($data->comision/100)) * abs($data->cantidad));
                            }
                            
                            $total = abs($data->cantidad) * ($data->precioneto + $valtax1);
                       
                        }
						
                        $exento_doc = 0; $gravado_doc = 0; $iva_doc = $info->valtax1;
                        if($info->exento==1){
                            $exento_doc = $info->valventan;
                        }else{
                            if ( $porcentaje_iva != 0 ) {
                                $gravado_doc = ($info->valtax1 / ($porcentaje_iva/100));
                            } else  $gravado_doc = $info->valventan;

                            $exento_doc = number_format($info->valventan-$gravado_doc, 2, '.', '');
                        }

                        $totalVenta = $info->valventan + $iva_doc;

                        if(($info->idtipo == 3) && ($gravado_doc>=100)){
                            $reten = $gravado_doc * 0.01;
                            $retencion = '-'.$reten;
                            $totalVenta = $totalVenta-$reten;
                        }else{
                            $retencion = 0;
                        }
                        
                        $descripPagos = "";
                        $notasPago = "";
                        $informaPagos = $this->ventas_model->getDatosPagosVentasTrannum($info->trannum);
                        
                        if($informaPagos != false){
                            foreach($informaPagos as $infoPago){
                                $descripPagos .= $infoPago->descrip.", ";

                                if($infoPago->notasPago != "" && $infoPago->notasPago != false){
                                    $notasPago .= $infoPago->notasPago.", ";
                                }
                            }
                            $descripPagos = str_replace("Retención 1%", "", $descripPagos);
                            $descripPagos = substr($descripPagos, 0, -2);  

                            if($notasPago != ""){
                                $notasPago = substr($notasPago, 0, -2);   
                            }
                        }

                        if($descripPagos == ""){
                            $informaPagos = $this->ventas_model->getTipoPagoRealiVenta($info->trannum);
                            if($informaPagos != false){
                                foreach($informaPagos as $infoPago){
                                    $descripPagos .= $infoPago->descrip;

                                    if($infoPago->notasPago != "" && $infoPago->notasPago != false){
                                        $notasPago .= $infoPago->notasPago;
                                    }
                                }
                            }
                        }

                        if($info->registro != ""){
                            $registro = $info->registro;
                        }else{
                            $registro = "SIN REGISTRO";
                        }

                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "fecha" => $info->fecha,
                            "tipodoc" => $info->tipodoc,
                            "seriedoc" => $info->serie,
                            "numeroserie" => $info->numero * 1,
                            "doc_dev" => $info->dev_serie.$info->dev_numero,
                            "nit" => $info->nit,
                            "numx" => $info->numx,
                            "numz" => $info->numz,
                            "registro" => $registro,
                            "namecliente" => $info->namecliente,
                            "idclienteauxi" => $info->idclienteauxi,
                            "namesucursal" => $info->namesucursal,
                            "namecaja" => $info->namecaja,
                            "namecentro" => $info->namecentro,
                            "namevendedor" => $info->namevendedor,
                            "valventan" => number_format($totalVenta, 6, '.', ''),
                            "exento" => number_format($exento_doc, 6, '.', ''),
                            "gravado" => number_format($gravado_doc, 6, '.', ''),
                            "iva" => number_format($iva_doc, 6, '.', ''),
                            "retencion" => number_format($retencion, 6, '.', ''),
                            "descuento" => number_format($totalDescuento, 6, '.', ''),
                            "comision" => number_format($totalComision, 6, '.', ''),
                            //"detailFacturas" => $detailFacturas,
                            "estatus" => $info->estatus,
                            "formaPago" => $descripPagos,
                            "notasPago" => $notasPago,
                            "notas_fact" => $info->notas,
                            "referencia" => $info->referencia,
                            "valcosto" => number_format($info->valcosto * -1, 6, '.', ''),
                            "ingresa" => $info->ingresa,
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }

        //  VENTAS DIARIAS PIVOT
        function ventasdiarias(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $mensaje = array(
                    'error' => 0,
                );
                $this->load->model('global_model');
                
				$this->data['direccion'] = $controlador;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->session->set_userdata($mensaje);
                $this->load->model('sucursal_model');
                $this->load->model('user_model');
                $this->data['sucursales'] = $this->sucursal_model->viewSucursales_activas_asc(1);
                $this->data['tipos'] = $this->sucursal_model->getTipo();
                $this->data['all_sucursales'] = $this->sucursal_model->viewSucursales_activas_asc();

                $derechos = $this->user_model->getDerechos();
                $derechos = explode(",", $derechos);

                $permite_costos  = 0; 
                $permite_utilidad = 0;
                $permite_margen  = 0;

                /*
                if (in_array("costo", $derechos)) {
                    $permite_costos  = 1; 
                }

                if (in_array("utilidad", $derechos)) {
                    $permite_utilidad  = 1; 
                }

                if (in_array("margen", $derechos)) {
                    $permite_margen  = 1; 
                }
                */

                $permite_costos  = 1; 
                $permite_utilidad  = 1; 
                $permite_margen  = 1; 

                $this->data['permite_costos'] = $permite_costos;
                $this->data['permite_utilidad'] = $permite_utilidad;
                $this->data['permite_margen'] = $permite_margen;

                //$this->data['derechos'] = $this->user_model->getDerechos();
                $this->load->view('mantenimiento_ventasdiarias', $this->data);
            }
        }

        function getVentasDiarias(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '2048M');

                $fecha_ini = $this->input->post("fechaini");
                $fecha_fin = $this->input->post("fechafin");
                $permite_costo = $this->input->post("permite_costo");
                $permite_utilidad = $this->input->post("permite_utilidad");
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getVentasDiarias($fecha_ini,$fecha_fin);
				$array = array();
				$i = 0;
				if($datos!=false){
					foreach($datos as $dat){
						if(($permite_costo=="1" || $this->session->userdata("iduser")=="1") && ($permite_utilidad=="1" || $this->session->userdata("iduser")=="1")){
                            
                            $array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
                                "Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
                                "Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Caja"                => $dat->NameCaja,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
                                "Marca"               => $dat->Marca,
                                "Modelo"              => $dat->Modelo,
                                "Grupo_Cliente"       => $dat->Grupo,                                
								"Costos"              => $dat->Costos,
                                "Utilidad"            => $dat->Ventas - $dat->Costos,
                                //"Margen"=>((($dat->Ventas - $dat->Costos) / $dat->Ventas) / $dat->Unidades) * 100
							);
							$i++;
						}else if(($permite_costo=="1" || $this->session->userdata("iduser")=="1") && ($permite_utilidad=="0" || $this->session->userdata("iduser")=="1")){
							$array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
                                "Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
                                "Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Caja"                => $dat->NameCaja,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
                                "Marca"               => $dat->Marca,
                                "Modelo"              => $dat->Modelo,
                                "Grupo_Cliente"       => $dat->Grupo,                                                                
								"Costos"              => $dat->Costos,
                                //"Margen"=>((($dat->Ventas - $dat->Costos) / $dat->Ventas) / $dat->Unidades) * 100
							);
							$i++;
						}else if(($permite_costo=="0" || $this->session->userdata("iduser")=="1") && ($permite_utilidad=="1" || $this->session->userdata("iduser")=="1")){
                            
                            $array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
                                "Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
                                "Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Caja"                => $dat->NameCaja,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
                                "Marca"               => $dat->Marca,
                                "Modelo"              => $dat->Modelo,
                                "Grupo_Cliente"       => $dat->Grupo, 
                                "Utilidad"            => $dat->Ventas - $dat->Costos
							);
							$i++;
						}else{
							$array[$i] = array(
								"Fecha"               => $dat->Fecha,
								"Dia"                 => $dat->Dia,
								"Hora"                => $dat->Hora,
								"Cliente"             => $dat->Cliente,
                                "Sucursal_Cliente"    => $dat->Suc_Cliente,
								"Hits"                => $dat->Hits,
								"Vendedor"            => $dat->Vendedor,
								"Proveedor"           => $dat->Proveedor,
								"Línea"               => $dat->Línea,
								"Departamento"        => $dat->Departamento,
								"Tipo_de_Transaccion" => $dat->Transaccion,
								"Ventas"              => $dat->Ventas,
								"Unidades"            => $dat->Unidades,
								"Sucursal"            => $dat->Sucursal,
								"Caja"                => $dat->NameCaja,
								"Producto"            => "[".$dat->idproducto."] ".$dat->Producto,
								"XposProducto"        => "[".$dat->xpos."] ".$dat->Producto,
								"Marca"               => $dat->Marca,
								"Modelo"              => $dat->Modelo
							);
							$i++;
						}
					}
				}
                echo json_encode($array);
            }
        }

        function validateEstadoOrden () {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
                $estado  = $this->input->post("estado");
                
                $this->load->model('ventas_model');
                $result = $this->ventas_model->validateEstadoOrden($trannum, $estado);

                echo json_encode($result);
            }
        }

        function mantenimientoVentasVendedor($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);

                $this->load->model('global_model');
                
				$date = new DateTime();
                $fechaactual = $date->format('Y-m-d');
				
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['fechaactual'] = $fechaactual;
                $this->data['primerdia'] = date('Y-m-01');
                $this->data['ultimodia'] = date('Y-m-t');
                
				$this->load->view('mantenimiento_ventas_x_vendedor', $this->data);
            }
        }

        function getSucursalesPagosReporte(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ventas_model');
                $informacion = $this->ventas_model->getFormasPagoVN('VN');
				
				$pagos = array();
				foreach($informacion as $info){
					$pagos[] = array(
                        "id" => $info->cajclase,
                        "descrip" => $info->descrip
                    );
				}
                
                echo json_encode(array(
                    'sucursales' => $this->ventas_model->getSucursales(),
                    'pagos' => $pagos
                ));
            }
        }

        function getReporteVendedorVentasPagos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                
                $idpago   = $this->input->post('idpago');
                $idcentro = $this->input->post('idcentro');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcliente = $this->session->userdata('idaccount');

                $this->load->model('ventas_model');
                $datos   = $this->ventas_model->getReporteVendedorVentasPagos('VN', $idcentro, $idpago, $fechaini, $fechafin, $idcliente);
                $datosCR = $this->ventas_model->getReporteVendedorVentasPagosCredito('VN', $idcentro, $idpago, $fechaini, $fechafin, $idcliente);

                $merged = [];

                // Procesar primer arreglo
                if ($datos) {
                    if($this->session->userdata('idaccount') == "4618"){
                         foreach ($datos as $info) {
                            $xpos = $info->xpos;
                            $venta = (float) $info->venta;
                            $costo = (float) $info->costo;

                            $merged[$xpos] = [
                                "xpos" => $xpos,
                                "codigoempleado" => $info->idauxi,
                                "namevendedor" => $info->descrip,
                                "venta" => $venta,
                                "costo" => $costo,
                                "utilidad" => $venta - $costo,
                            ];
                        }       
                    }else{
                        foreach ($datos as $info) {
                            $idauxi = $info->idauxi;
                            $venta = (float) $info->venta;
                            $costo = (float) $info->costo;

                            $merged[$idauxi] = [
                                "xpos" => $info->xpos,
                                "codigoempleado" => $idauxi,
                                "namevendedor" => $info->descrip,
                                "venta" => $venta,
                                "costo" => $costo,
                                "utilidad" => $venta - $costo,
                            ];
                        }
                    }
                }

                // Procesar segundo arreglo
                if ($datosCR) {
                    if($this->session->userdata('idaccount') == "4618"){
                        foreach ($datosCR as $info) {
                            $xpos = $info->xpos;
                            $venta = (float) $info->venta;
                            $costo = (float) $info->costo;

                            if (isset($merged[$xpos])) {
                                $merged[$xpos]["venta"] += $venta;
                                $merged[$xpos]["costo"] += $costo;
                                $merged[$xpos]["utilidad"] = $merged[$xpos]["venta"] - $merged[$xpos]["costo"];
                            } else {
                                $merged[$xpos] = [
                                    "xpos" => $xpos,
                                    "codigoempleado" => $info->idauxi,
                                    "namevendedor" => $info->descrip,
                                    "venta" => $venta,
                                    "costo" => $costo,
                                    "utilidad" => $venta - $costo,
                                ];
                            }
                        }
                    }else{
                        foreach ($datosCR as $info) {
                            $idauxi = $info->idauxi;
                            $venta = (float) $info->venta;
                            $costo = (float) $info->costo;

                            if (isset($merged[$idauxi])) {
                                $merged[$idauxi]["venta"] += $venta;
                                $merged[$idauxi]["costo"] += $costo;
                                $merged[$idauxi]["utilidad"] = $merged[$idauxi]["venta"] - $merged[$idauxi]["costo"];
                            } else {
                                $merged[$idauxi] = [
                                    "xpos" => $info->xpos,
                                    "codigoempleado" => $idauxi,
                                    "namevendedor" => $info->descrip,
                                    "venta" => $venta,
                                    "costo" => $costo,
                                    "utilidad" => $venta - $costo,
                                ];
                            }
                        }
                    }
                }

                // Formatear resultado final
                $resultadoFinal = [];
                foreach ($merged as $item) {
                    $resultadoFinal[] = [
                        "xpos" => $item["xpos"],
                        "namevendedor" => $item["namevendedor"],
                        "codigoempleado" => $item["codigoempleado"],
                        "venta" => number_format($item["venta"], 2, '.', ''),
                        "costo" => number_format($item["costo"], 2, '.', ''),
                        "utilidad" => number_format($item["utilidad"], 2, '.', ''),
                    ];
                }

                
                echo json_encode(array(
                    'dataSource' => $resultadoFinal
                ));
            }
        }

        // GET INFORMACION CONTACTOS ADICONALES
        function getContactosAdicionalesCliente() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcliente = $this->input->post('idcps');

                $this->load->model('cliente_model');
                $contactos = $this->cliente_model->getRegistrosAdicionalj($idcliente, 2);

                echo json_encode($contactos);
            }
        }
    }
?>