<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
    class Variable extends CI_Controller {

		private $Tipos = array(
			array('ID' => 1, 'Name' => 'Número', 'campo' => 'valor_num'),
			array('ID' => 2, 'Name' => 'Texto', 'campo' => 'valor_txt'),
			array('ID' => 3, 'Name' => 'Fecha', 'campo' => 'valor_fecha'),
			array('ID' => 4, 'Name' => 'Lógico', 'campo' => 'valor_logico'),
			//array('ID' => 5, 'Name' => 'Memoria', 'campo' => '', 'disabled' => true),
		);
        
        function __construct(){
			parent::__construct();
        }
		private function validatePermiso() {
            $permiso = ($this->session->userdata("profile") != 1) ? false : true;
            /*if (chkPermisoEspecial([$this->session->userdata('iduser'), $this->session->userdata('idaccount')])) $permiso =  true;
            else if ($this->session->userdata("profile") != 1) $permiso = false;//*/
            //if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1) redirect('CerrarSesion');
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || !$permiso) redirect('CerrarSesion');
            else return true;
        }
        
        function newVariable(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])  || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
					'namePage' => 'Adicionar Variables'
				);
				$this->session->set_userdata($resultAppName);
				$this->load->view('new_variable');
			}
        }
        
		#	VARIABLES
        function verVariable(){
			if($this->validatePermiso()) {
				$resultAppName = array(
                    'namePage' => 'Variables'
                );
                $this->session->set_userdata($resultAppName);
				$this->load->model('variable_model');
				$this->load->model('global_model');
				$controlador = $this->uri->segment(1);
				$funcion = $this->uri->segment(2);
				$controladore = $this->uri->segment(1);
				$funcione = $this->uri->segment(2);
				$direccione = $controladore.'/'.$funcione;

				$data['direccion'] = $controlador.'/'.$funcion;   
				$data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccione);
				$data['Variables'] = $this->conversion(0);//$this->variable_model->viewVariable();
				$data['Nombres'] = $this->conversion(1);//$this->variable_model->verNombres();
				$data['TiposVariables'] = $this->Tipos;
				$this->load->view('mantenimiento_variable', $data);
			}
        }

		#	MULTIPLES OPCIONES
		public function multiOpciones()
		{
			if($this->validatePermiso()) {
				$opcion = (int)$this->input->post('opcion');
				date_default_timezone_set('America/El_Salvador');
				$this->load->model('variable_model');
				switch ($opcion) {
					case 0:#	SET VARIABLE
						$data = array(
							'nombre' => trim($this->input->post('nombre')),
							'descripcion' => trim($this->input->post('descripcion')),
							(''.$this->input->post('campo')) => $this->input->post('valor'),
							'valor_memo' => trim($this->input->post('notas')),
							'tipo_valor' => (int)$this->input->post('tvariable'),
							'filtro' => trim($this->input->post('filtro')),
							'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
						);
						if ($this->variable_model->multiOpciones(2, $data)) {
							$Variables = $this->conversion(0);
							$Nombres = $this->conversion(1);
							$datA[] = array(
								'valido' => true,
								'variables' => $Variables,
								'nombres' => $Nombres
							);
						} else $datA[] = array('valido' => false);
					break;
					case 1:#	GET VARIABLE
					break;
					case 2:#	UPDATE VARIABLE
						$ID = (int)$this->input->post('ID');
						$data = array(
							'nombre' => trim($this->input->post('nombre')),
							'descripcion' => trim($this->input->post('descripcion')),
							(''.$this->input->post('campo')) => $this->input->post('valor'),
							'valor_memo' => trim($this->input->post('notas')),
							'tipo_valor' => (int)$this->input->post('tvariable'),
							'filtro' => trim($this->input->post('filtro')),
							'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
						);
						/*print_r($data);
						die();//*/
						if ($this->variable_model->multiOpciones(4, [
							'ID' => $ID,
                            'data' => $data
						])) {
							$Variables = $this->conversion(0);
							$Nombres = $this->conversion(1);
							$datA[] = array(
								'valido' => true,
								'variables' => $Variables,
								'nombres' => $Nombres
							);
						} else $datA[] = array('valido' => false);
					break;
					case 3:#	DELETE VARIABLE
						$ID = (int)$this->input->post('ID');
						$this->variable_model->multiOpciones(5, $ID);
						$datA[] = array(
							'valido' => true,
							'variables' => $this->conversion(0),
							'nombres' => $this->conversion(1)
						);
					break;
					default:
						$datA[] = array('valido' => false);
					break;
				}
				echo json_encode($datA);
			}
		}
		private function conversion($opc, $extra= null)
		{
			$Datos = [];
			switch ($opc) {
				#	VARIABLES
				case 0:
					$datos = $this->variable_model->multiOpciones(0);
					if ($datos->num_rows() > 0) {
						foreach ($datos->result() as $dato) {
							switch ($dato->tipo_valor) {
								case 1:
									$valor = $dato->valor_num;
								break;
								case 2:
									$valor = $dato->valor_txt;
								break;
								case 3:
									$valor = $dato->valor_fecha;
								break;
								case 4:
									$valor = ($dato->valor_logico == 1) ? true : false;
								break;
								default:
									$valor = $dato->valor_txt;
								break;
							}
							$Datos[] = array(
								'key' => (int)$dato->idrnum,
								'nombre' => trim($dato->nombre),
								'descripcion' => trim($dato->descripcion),
								'valor' => $valor,
								'tipo' => (int)$dato->tipo_valor,
								'notas' => str_replace(array("\n", "\r", "\n\r"), " ", $dato->valor_memo),
								'filtro' => trim($dato->filtro)
							);
						}
					}
				break;
				#	NOMBRES DE VARIABLES
				case 1:
					$datos = $this->variable_model->multiOpciones(1);
					if ($datos->num_rows() > 0) {
						$Datos[] = array(
							'ID' => '-null',
							'Name' => '--TODOS--'
						);
						foreach ($datos->result() as $dato) {
							$Datos[] = array(
								'ID' => $dato->nombre,
								'Name' => $dato->nombre,
							);
						}
					}
				break;
			}
			return $Datos;
		}
		#-
        
        function variable_seleccionada(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$name = $this->input->post('nombre');
				$filter = array( 'var_selected' => $name);
				$this->session->set_userdata($filter);
				
				echo json_encode($this->session->userdata('var_selected'));
			}
        }
        
        function verColumnas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$filtro = $this->input->post('dato');
				$this->load->model('variable_model');
				$dtos = $this->variable_model->viewColumnas($filtro);
				
				echo json_encode($dtos);
			}
        }
        
        function registrarVariable(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				if($this->input->post()){
					$nombre = $this->input->post('nombre');
					$descrip = $this->input->post('descripcion');
					$tipo_variable = $this->input->post('tipo_variable');
					$valor = $this->input->post('valor');
					$notmemo = $this->input->post('notas_memo');
					$filtro = $this->input->post('filtro');
					$whodidit = $this->session->userdata('iduser');
					$option = $this->input->post('saveNext');
					
					$this->load->model('variable_model');
					$this->variable_model->insertVariable($nombre, $descrip, $tipo_variable, $valor, $option, $notmemo, $filtro, $whodidit);
				}else{
					$this->verVariable();
				}
			}
        }
        
        function modificarVariable($idrnum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])  || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
					'namePage' => 'Actualizar Variable N° '.$idrnum
				);
				$this->session->set_userdata($resultAppName);
				$this->load->model('variable_model');
				$data['regMod'] = $this->variable_model->callRegistro($idrnum);
				
				$this->load->view('form_update_variable', $data);
			}
        }
        
        function verColumnas2(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('variable_model');
				$filtro = $this->input->post('dato');
				$idrnum = $this->input->post('id');
				$gvars = $this->variable_model->viewCampSelect($idrnum);
				$dtos = $this->variable_model->viewColumnas($filtro);

				echo json_encode($dtos, $gvars);
			}
        }
		
        function actualizarVariable(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])  || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
				$idrnum = $this->input->post('idrnum');
				$nombre = $this->input->post('nombre');
				$descrip = $this->input->post('descripcion');
				$tipo_variable = $this->input->post('tipo_variable');
				$valor = $this->input->post('valor');
				$notmemo = $this->input->post('notas_memo');
				$filtro = $this->input->post('filtro');
				$whodidit = $this->session->userdata('iduser');
				
				$this->load->model('variable_model');
				$variable = $this->variable_model->updateVariable($idrnum, $nombre, $descrip, $tipo_variable, $valor, $notmemo,$filtro,$whodidit);
			}
        }
        
        function eliminarVariable(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])  || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
				$idvariable = $this->input->post('idvariable');
				
				$this->load->model('variable_model');
				$array = $this->variable_model->deleteVariable($idvariable);
				echo json_encode($array);
			}
        }
        
        function filtros_aplicados(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->session->unset_userdata('last_filter');
				$filtros = $this->input->post('filtros');
				$filter = array( 'last_filter' => $filtros );
				$this->session->set_userdata($filter);
				
				echo json_encode($this->session->userdata('last_filter'));
			}
		}
		
		function mantenimientoCameGvars($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
				$informacion = $this->configuracion_model->getOptionsByidapp($idApp);
				$infoVariables = explode(",", $informacion);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'tipoVariable' => $infoVariables[2],
                    'nameVariable' => $infoVariables[0],
                    'descripVariable' => $infoVariables[1],
                    'saveNextReg' => ""
                );
                $this->session->set_userdata($resultAppName);
				$this->load->model('variable_model');
				$this->load->model('global_model');
				
				$this->load->view('mantenimiento_variable_came');
			}
		}
		
		function getInformacionVariablesCame(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$descrip = $this->input->post('descrip');

				$this->load->model('variable_model');
				$informacion = $this->variable_model->getInformacionVariablesCame($descrip);

				$i=0;
				$array = array();
				if($informacion != false){
					foreach($informacion as $info){
						
						$valorVariable = "";
						if($info->tipo_valor == 1){
							$valorVariable = $info->valor_num;
						}elseif($info->tipo_valor == 2){
							$valorVariable = $info->valor_txt;
						}elseif($info->tipo_valor == 3){
							$valorVariable = $info->valor_fecha;
						}elseif($info->tipo_valor == 4){
							$valorVariable = $info->valor_logico;
						}

						$array[$i] = array(
							"idrnum" => $info->idrnum,
							"descripcion" => $info->descripcion,
							"valor" => $valorVariable,
							"valor_memo" => $info->valor_memo
						);
						
						$i++;
					}
				}

				echo json_encode($array);
			}
		}

		function adicionarCameGvars(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$resultAppName = array(
					'namePage' => 'Adicionar '. $this->session->userdata('descripVariable')
				);
				$this->session->set_userdata($resultAppName);
				
				if($this->session->userdata('tipoVariable') == 1){
					$this->load->model('variable_model');
					$this->data['valor'] = $this->variable_model->getNextValorNumVariable($this->session->userdata('nameVariable'));
				}
				$this->load->view('new_variable_came', $this->data);
			}
		}

		function adicionarVariable_Came(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				if($this->input->post()){
					$nombre = $this->session->userdata('nameVariable');
					$descrip = $this->input->post('descripcion');
					$tipo = $this->session->userdata('tipoVariable');
					$valor = $this->input->post('valor');
					$notas_memo = $this->input->post('notas_memo');
					$filtro = $this->input->post('filtro');
					
					$this->load->model('variable_model');
					$this->variable_model->adicionarVariable_Came($nombre, $descrip, $tipo, $valor, $notas_memo, $filtro);
					
					redirect('Came_Gvars/'.$this->session->userdata('iddApp'));
				}else{
					$this->mantenimientoCameGvars($this->session->userdata('iddApp'));
				}
			}
		}
		
		function actualizarCameGvars($idrnum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$resultAppName = array(
					'namePage' => 'Actualizar ' . $this->session->userdata('descripVariable')
				);
				$this->session->set_userdata($resultAppName);
				
				$this->load->model('variable_model');
				$informacion = $this->variable_model->callRegistro($idrnum);
				$this->data['informacion'] = $informacion;
				
				foreach($informacion as $info){
					if($info->tipo_valor == 1){
						$this->data['valor'] = $info->valor_num;
					}elseif($info->tipo_valor == 2){
						$this->data['valor'] = $info->valor_txt;
					}elseif($info->tipo_valor == 3){
						$this->data['valor'] = $info->valor_fecha;
					}elseif($info->tipo_valor == 4){
						$this->data['valor'] = $info->valor_logico;
					}
				}
				
				$this->load->view('form_update_variable_came', $this->data);
			}
		}

		function modificarVariable_Came(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idrnum = $this->input->post('idrnum');
				$descrip = $this->input->post('descripcion');
				$tipo = $this->session->userdata('tipoVariable');
				$valor = $this->input->post('valor');
				$notas_memo = $this->input->post('notas_memo');
				$filtro = $this->input->post('filtro');
				
				$this->load->model('variable_model');
				$variable = $this->variable_model->modificarVariable_Came($idrnum, $descrip, $tipo, $valor, $notas_memo, $filtro);
				
				redirect('Came_Gvars/'.$this->session->userdata('iddApp'));
			}
		}

		function eliminarVariableCame(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idvariable = $this->input->post('idvariable');
				
				$this->load->model('variable_model');
				$array = $this->variable_model->deleteVariable($idvariable);
				echo json_encode($array);
			}
		}

		//  IMPORTACION DE VARIABLE
        public function validacionImportarVariable(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('variable_model');
                $registros = $this->input->post("registros");
                

                $arrayRegistros = explode("\n", $registros);

                $valido = true;
                $arrayRespuesta = [];
                $conteo = 0;

                $departamentoActual = "¿123456!"; //Indica si hay un cambio de departamento
                foreach($arrayRegistros as $reg){
                    if($reg == ""){
                        $valido = false;

                        $arrayRespuesta[] = array(
                            'nombre' => "Datos vacíos",
                            'descrip' => "Datos vacíos",
                            'tipo_valor' => -1,
							'valor' =>"",
                        );
                        continue;
                    }

                    $dato = explode("|", $reg);

                    if(count($dato) != 4){
                        $valido = false;

                        $arrayRespuesta[] = array(
                            'nombre' => "Datos erroneos",
                            'descrip' => "Datos erroneos",
                            'tipo_valor' => -1,
							'valor' =>"",
                        );
                        continue;
                    }

                    $nombre = $dato[0];
                    $descrip = $dato[1];
					$tipo_valor = $dato[2];
                    $valor = $dato[3];

                    $tipo = 0;

                    if(count($dato) == 4 && $nombre != "" && $descrip != "" && $tipo_valor != "" && $valor != ""){
						if($tipo_valor != "1" && $tipo_valor != "2" && $tipo_valor != "3" && $tipo_valor != "4"){
							$arrayRespuesta[] = array(
								'nombre' => $nombre,
								'descrip' => $descrip,
								'tipo_valor' =>  -1,
								'valor' =>  "Tipo de valor no aceptado",
							);
	
							continue;
						}
                    }else{
                        $valido = false;
                        if($nombre == ""){
                            $nombre = "Datos Incompletos";
                        }

                        if($descrip == ""){
                            $descrip = "Datos Incompletos";
                        }

						if($tipo_valor == ""){
                            $tipo_valor = -1;
                        }

						if($valor == ""){
                            $valor = "Datos Incompletos";
                        }
                        
                        $arrayRespuesta[] = array(
                            'nombre' => $nombre,
                            'descrip' => $descrip,
                            'tipo_valor' =>  $tipo_valor,
							'valor' =>  $valor,
                        );

                        continue;
                    }

                    if($this->variable_model->existeVariable($nombre, $descrip)){
                        $arrayRespuesta[] = array(
                            'nombre' => $nombre,
                            'descrip' => $descrip." [REPETIDO]",
                            'tipo_valor' =>  -1,
							'valor' =>  $valor,
                        );

                        continue;
                    }

                    $arrayRespuesta[] = array(
                        'nombre' => $nombre,
						'descrip' => $descrip,
						'tipo_valor' =>  $this->Tipos[$tipo_valor-1]['Name'],
						'valor' =>  $valor,
                    );

                    $conteo++;
                }

                if($conteo == 0){
                    $valido = false;
                }

                $array[] = array('valido' => $valido, 'datos' => $arrayRespuesta);
                echo json_encode($array);
            }
        }

        public function importarVariable(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                
				//Si el registro es vacio, lo ignora
				$this->load->model('variable_model');
                $registros = $this->input->post("registros");
                

                $arrayRegistros = explode("\n", $registros);

                $arrayRespuesta = [];
                $conteo = 0;

                foreach($arrayRegistros as $reg){
					$valido = true;

                    if($reg == ""){
                        $valido = false;
						$conteo++;
                        continue;
                    }

                    $dato = explode("|", $reg);

                    if(count($dato) != 4){
                        $valido = false;
						$conteo++;
                        continue;
                    }

                    $nombre = $dato[0];
                    $descrip = $dato[1];
					$tipo_valor = $dato[2];
                    $valor = $dato[3];

                    if(count($dato) == 4 && $nombre != "" && $descrip != "" && $tipo_valor != "" && $valor != ""){
						if($tipo_valor != "1" && $tipo_valor != "2" && $tipo_valor != "3" && $tipo_valor != "4"){
							$valido = false;
							$conteo++;
							continue;
						}
                    }

                    if($this->variable_model->existeVariable($nombre, $descrip)){
						$valido = false;
						$conteo++;
						continue;
                    }

					if($valido){
						$resultado = $this->variable_model->importarVariable($nombre, $descrip,$tipo_valor,$valor);
						
						if(!$resultado){
							$valido = false;
							$conteo++;
							continue;
						}
					}


                }
				$Variables = $this->conversion(0);
				$Nombres = $this->conversion(1);

                if($conteo == 0){
                    $arrayResultado = array('valido'=>true, 'mensaje'=>'Se han importado las variables.', 'conteo'=>$conteo, 'variables'=>$Variables, 'nombres'=>$Nombres);
                }else{
                    $arrayResultado = array('valido'=>false, 'mensaje'=>'Hubo una o más variables que no han sido importadas.', 'conteo'=>$conteo, 'variables'=>$Variables, 'nombres'=>$Nombres);

                }
                echo json_encode($arrayResultado);
            }
        }
    }
?>