<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Tpedidos extends CI_Controller{
        
        function __construct(){
            parent::__construct();
        }
        
        function verPedidos($idapp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idapp);
				
                $resultAppName = array(
                    'iddApp' => $idapp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('tpedido_model'); $this->load->model('global_model');
                
                $direccion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                
                $this->load->view('pedidos/tpedido_pedidos', $this->data);
            }
        }
        
        function controlProduccion($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionesApp = $this->configuracion_model->getOptionsByidapp($idApp);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $direccion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['idclase'] = $opcionesApp;
                
                $this->load->view('mantenimiento_control_produccion', $this->data);
            }
        }
        
        function detalleControlProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $sucursal = $this->input->post('idcentro');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idclase = $this->input->post('idclase');
                
                $this->load->model('tpedido_model');
                $produccion = $this->tpedido_model->getDetalleProductosEntradaxCompra($sucursal,$fechaini,$fechafin,$idclase);
                
                $i=0;
                if(empty($produccion)){
                    $infoProduccion = array();
                }else{
                    foreach($produccion as $info){
                        $infoProduccion[$i] = array(
                            'trannum' => $info->trannum, 
                            'fecha' => $info->fechaingreso,
                            'hora' => $info->horaingreso,
                            'Whodidit' => $info->nameingresado,
                            'cod' => $info->idproducto,
                            'descrip' => $info->descrip,
                            'departamento' => $info->departamento,
                            'linea' => $info->linea,
                            'cant' => $info->cantidad,
                            'pedidonum' => $info->barcode,
                            'modelo' => $info->modelo
                        );
                        $i++;
                    }
                }
                
                echo json_encode($infoProduccion);
                
            }
        }
        
        function adicionarPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('mantenimiento_model');
                $this->data['sucursales'] = $this->mantenimiento_model->getSucursales();
                $this->load->view('pedidos/tpedido_adicionar', $this->data);        
            }
        }
        
        function getNamesProcentros(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->getTiposProcentros();
                echo json_encode($array);
            }
        }
        
        function getListadoSucursalesListas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->getListadoSucursalesListas($idcentro);
                
                echo json_encode($array);
            }
        }
        
        function getLineasProcentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idprocentro = $this->input->post('procentro');
                $this->load->model('tpedido_model');
                
                $array = $this->tpedido_model->getListLineas($idprocentro);
                echo json_encode($array);
            }
        }
        
        function getListProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $trannum = $this->input->post('trannum');
                $idaccount = $this->session->userdata('idacount');
                $idcenter = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->getListProductos($idcatalogo);
                $array2 = $this->tpedido_model->getAllTheProducts($idcatalogo);
                
                $dir = "temp_cuentas/temp_$idaccount";
                $name_archive = $idaccount."_PT_".$trannum."_".$idcenter.".txt";
                $texto = "";
                
                if(!file_exists($dir)){
                    mkdir("temp_cuentas/temp_$idaccount", 0755);        
                }
                
                if(file_exists($dir."/".$name_archive)){
                    $file = fopen($dir."/".$name_archive, "r");
                    while(!feof($file)) {
                        $texto .= fgets($file);
                    }
                    fclose($file);

                }else{
                    $file = fopen($dir."/".$name_archive, "a+");
                    fclose($file);
                }
                    
                $array = array(
                    "filter" => $array,
                    "all" => $array2,
                    "texto" => $texto
                );
                
                echo json_encode($array);
            }
        }
        
        function nextPageProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $pagina = $this->input->post('page');
                $trannum = $this->input->post('trannum');
                $idaccount = $this->session->userdata('idacount');
                $idcenter = $this->session->userdata('idcentrouser');
                $this->load->model('tpedido_model');
                  
                $array1 = $this->tpedido_model->getListPageProductos($idcatalogo, $pagina);
                $array2 = $this->tpedido_model->getAllTheProducts($idcatalogo);
                
                $name_archive = "temp_cuentas/temp_$idaccount/".$idaccount."_PT_".$trannum."_".$idcenter.".txt";
                
                $file = fopen($name_archive, "r");
                $texto = "";
                while(!feof($file)) {
                    $texto .= fgets($file);
                }
                fclose($file);
                
                $array = array(
                    "filter" => $array1,
                    "all" => $array2,
                    "texto" => $texto
                );
                
                echo json_encode($array);
            }
        }
        
        function prevPageProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $pagina = $this->input->post('page');
                $trannum = $this->input->post('trannum');
                $idaccount = $this->session->userdata('idacount');
                $idcenter = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                $array1 = $this->tpedido_model->getListPageProductos($idcatalogo, $pagina);
                $array2 = $this->tpedido_model->getAllTheProducts($idcatalogo);
                
                $name_archive = "temp_cuentas/temp_$idaccount/".$idaccount."_PT_".$trannum."_".$idcenter.".txt";
                
                $file = fopen($name_archive, "r");
                $texto = "";
                while(!feof($file)) {
                    $texto .= fgets($file);
                }
                fclose($file);
                
                $array = array(
                    "filter" => $array1,
                    "all" => $array2,
                    "texto" => $texto
                );
                
                echo json_encode($array);
            }
        }
        
        function registrarPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('tpedido_model');
                $procentro = $this->input->post('procentro');
                $notas = $this->input->post('notas');
                $fecha = $this->input->post('fecha');
                $idLista = $this->input->post('idlista');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
				$reemplazar = array("", "", "", "");
				$notas = str_replace($buscar, $reemplazar, $notas);

                $array = $this->tpedido_model->insertPedido($procentro, $notas, $fecha, $idcentro, $idLista);
                
                echo json_encode($array);   
            }
        }
        
        function getProductosProcentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $procentro = $this->input->post('procentro');
                $this->load->model('tpedido_model');

                $array = $this->tpedido_model->getProductosProcentro($procentro);
                echo json_encode($array);
            }
        }
        
        function actualizarPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('tpedido_model');
                
                $idtrannum = $this->input->post('idtrannum');
                $cliphone = $this->input->post('cliphone');
                $cliname = $this->input->post('cliname');
                $cliname = strtoupper($cliname);
                $cliemail = $this->input->post('cliemail');
                $notas = $this->input->post('notas');
                $fecha = date_format(date_create($this->input->post('devdate')), 'Y-m-d');
                $time = $this->input->post('devtime');
                $idsucursal = $this->input->post('idsucurentrega');
                $devcontact = $this->input->post('devcontact'); 
                $devphone = $this->input->post('devphone');
                $devdirec = $this->input->post('devdirec');
                $idcentro = $this->session->userdata('idcentrouser');

                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
				$reemplazar = array("", "", "", "");
				$notas = str_replace($buscar, $reemplazar, $notas);

                $this->tpedido_model->updatePedido($idtrannum, $cliphone, $cliname, $cliemail, $notas, $fecha, $time, $idsucursal, $devcontact, $devphone, $devdirec, $idcentro);
                
                $this->editar_pedido($idtrannum);
            }
        }
        
        function editar_pedido($trannum, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
				);
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model'); $this->load->model('tpedido_model');
                $this->load->model('global_model');
                
                $data_pedido = $this->tpedido_model->getDataPedido($trannum, $estado);
                $this->data['data_pedido'] = $data_pedido;
                
                foreach($data_pedido as $info){
                    $procentro = $info->procentro;    
                }
                
				$direccion = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['cantidad'] = $this->tpedido_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->tpedido_model->getUnidad100k($trannum);
                $this->data['claveReversar'] = $this->global_model->getValorTextoVariable('pdt_clave');
                $this->data['estado'] = $estado;
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                $procentro_id = array(
                    'procentro_id' => $procentro
                );
                $this->session->set_userdata($procentro_id);
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                $this->load->view('pedidos/tpedido_editar', $this->data);
            }
        }
		
		function getListGruposInventario(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
                $procentro = $this->input->post('procentro');
                
				$this->load->model('tpedido_model');
				$grupos = $this->tpedido_model->getGruposInventario($procentro);
				$cantidades = $this->tpedido_model->getCantidadesCatalogo($idtrannum);
				
				$i=0;
				$array = array();
				
				foreach($grupos as $info){
					foreach($cantidades as $cant){
						if($info->idcatalogo == $cant->idcatalogo){
							$array[$i] = array(
								"idcatalogo" => $info->idcatalogo,
								"descrip" => $info->descrip,
								"imagen" => $info->imagen,
								"total" => $cant->cantidad
							);	
							$i++;
						}
					}
				}
					
				echo json_encode($array);
			}
		}
		
		function getListGruposInventarioByLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
                $procentro = $this->input->post('procentro');
                $nameLista = $this->input->post('nameLista');
                $idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('tpedido_model');
				$grupos = $this->tpedido_model->getGruposInventarioByLista($nameLista, $procentro, $idcentro);
				$cantidades = $this->tpedido_model->getCantidadesByLista($idtrannum, $nameLista, $procentro, $idcentro);
				
				$i=0;
				$array = array();
				
				foreach($grupos as $info){
					foreach($cantidades as $cant){
                    	if($cant->idcatalogo == $info->idcatalogo){
                            if($cant->cantidad > 0){
			 				    $array[$i] = array(
                                    "idcatalogo" => $info->idcatalogo,
                                    "descrip" => $info->descrip,
                                    "imagen" => $info->imagen,
                                    "total" => $cant->cantidad
                                );	
                                $i++;
                            }
                        }
					}
				}
					
				echo json_encode($array);
			}
		}
        
        function getInventarioByCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $procentro = $this->input->post('procentro');
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('tpedido_model');
                $detalle = $this->tpedido_model->getInventarioByCatalog($idtrannum,$idcatalogo,$idcentro, $procentro);
                $cantidades = $this->tpedido_model->getCantidadesCatalogo($idtrannum);

                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "precio" => $info->costounitario,
                            "disponible" => $info->disponible,
                            "disprocentro" => $info->disprocentro,
                            "precioventa" => $info->precioventa
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i,
                    "sumagrupos" => $cantidades
                );
                echo json_encode($array);
            }
        }
		
		function getInventarioByLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $procentro = $this->input->post('procentro');
                $idcentro = $this->session->userdata('idcentrouser');
                $nameLista = $this->input->post('nombreLista');
				
				$this->load->model('tpedido_model');
				$detalle = $this->tpedido_model->getInventarioByLista($idtrannum, $idcentro, $procentro, $nameLista);
                
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "precio" => $info->costounitario,
                            //"disponible" => $info->disponible,
                            //"disprocentro" => $info->disprocentro,
                            "precioventa" => $info->precioventa
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                echo json_encode($array);
            }
        }
        
        function getListadoLineasPedidoBodega(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{				
				$this->load->model('tpedido_model'); 
				$lineas = $this->tpedido_model->getListadoLineasPedidoBodega();
				
				$i=0;
				$array = array();
				foreach($lineas as $data){
                    $array[$i] = array(
                        "idcatalogo" => $data->idcatalogo,
                        "descrip" => trim($data->descrip)
                    );

					$i++;
				}
				
                echo json_encode($array);
            }
        }
        
        function getInventarioSinLista(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $this->load->model('tpedido_model');
                $detalle = $this->tpedido_model->getInventarioSinLista($trannum, $idcatalogo);
				
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function getDatosPedido100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $procentro = $this->input->post('procentro');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->getDataOrder100k($idtrannum, $idcentro, $procentro);
                echo json_encode($array);
            }
        }
        
        function insertOrder100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $cantidad = $this->input->post('cantidad');
                $idproducto = $this->input->post('idproducto');
                $procentro = $this->input->post('procentro');
                $descrip = $this->input->post('descrip');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $notas = $this->input->post('notas');
                $nameLista = $this->input->post('nombreLista');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
				$reemplazar = array("", "", "", "");
				$notas = str_replace($buscar, $reemplazar, $notas);

                $this->load->model('tpedido_model');
                $this->tpedido_model->insertOrders100k($cantidad, $idproducto, $descrip, $um, $idcentro, $trannum, $precio, $notas);
                
                if($nameLista != ""){
                    $detalle = $this->tpedido_model->getInventarioByLista($trannum, $idcentro, $procentro, $nameLista);
                }else{
                    $detalle = $this->tpedido_model->getInventarioSinLista($trannum, $idcatalogo);
                }
                
                $datos = $this->tpedido_model->getDataOrder100k($trannum, $idcentro, $procentro);
                
                $cantidad = $this->tpedido_model->getCantidad100k($trannum);
                $unidades = $this->tpedido_model->getUnidad100k($trannum);
				
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
						$items[$i] = array(
							"nameproducto" => $info->descrip,
							"marca" => $info->marca,
							"modelo" => $info->modelo,
							"upc" => $info->barcode,
							"notas" => $info->notas,
							"idproducto" => $info->idproducto,
							"um" => $info->um,
							"imagen" => $info->imagen,
							"precio" => $info->costounitario,
							"precioventa" => $info->precioventa
						);
						$i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }
        }
        
        function nextProductoPedidos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $procentro = $this->input->post('procentro');
                $trannum = $this->input->post('idtrannum');
                $nameLista = $this->input->post('nombreLista');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
				if($nameLista != ""){
                    $detalle = $this->tpedido_model->getInventarioByLista($trannum, $idcentro, $procentro, $nameLista);
                }else{
                    $detalle = $this->tpedido_model->getInventarioSinLista($trannum, $idcatalogo);
                }
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
						$items[$i] = array(
							"nameproducto" => $info->descrip,
							"marca" => $info->marca,
							"modelo" => $info->modelo,
							"upc" => $info->barcode,
							"notas" => $info->notas,
							"idproducto" => $info->idproducto,
							"um" => $info->um,
							"imagen" => $info->imagen,
							"precio" => $info->costounitario,
							"precioventa" => $info->precioventa
						);
						$i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }
        }
        
        function deleteRegistro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $procentro = $this->input->post('procentro');
                $idcentro = $this->session->userdata('idcentrouser');
				$nameLista = $this->input->post('nombreLista');
				$idcatalogo = $this->input->post('idcatalogo');
				
                $this->load->model('tpedido_model');
                $this->tpedido_model->deleteDataOrder100k($idrec);
                
				if($nameLista != ""){
                    $detalle = $this->tpedido_model->getInventarioByLista($trannum, $idcentro, $procentro, $nameLista);
                }else{
                    $detalle = $this->tpedido_model->getInventarioSinLista($trannum, $idcatalogo);
                }

                $datos = $this->tpedido_model->getDataOrder100k($trannum, $idcentro, $procentro);
                $cantidad = $this->tpedido_model->getCantidad100k($trannum);
                $unidades = $this->tpedido_model->getUnidad100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
						$items[$i] = array(
							"nameproducto" => $info->descrip,
							"marca" => $info->marca,
							"modelo" => $info->modelo,
							"upc" => $info->barcode,
							"notas" => $info->notas,
							"idproducto" => $info->idproducto,
							"um" => $info->um,
							"imagen" => $info->imagen,
							"precio" => $info->costounitario,
							//"disponible" => $info->disponible,
							//"disprocentro" => $info->disprocentro,
							"precioventa" => $info->precioventa
						);
						$i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }
        }
		
		function getCantidadLineasUnidades(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                
				$this->load->model('tpedido_model');
                $cantidad = $this->tpedido_model->getCantidad100k($trannum);
                $unidades = $this->tpedido_model->getUnidad100k($trannum);
                
                $array = array(
					"cantidad" => $cantidad,
                    "unidades" => $unidades
                );
                                
                echo json_encode($array);
            }
		}
        
        function getEstadisticasProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $idproducto = $this->input->post('idproducto');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                $dias = $this->tpedido_model->getDiasEstadisticas('gv_statdays');
                
                $i=0;
                $total = 0;
                $numdias = 0;
                $estat = array();
                $fecha_actual = date("Y-m-d");
                
                for($j=0; $j<$dias; $j++){
                    $fecha = strtotime('-1 day', strtotime($fecha_actual));
                    $nFecha = date('Y-m-d', $fecha);

                    $datos = $this->tpedido_model->getEstadisticasProducto($idproducto, $idcentro, $nFecha);
                    if($datos != false){
                        $estat[$i] = array(
                            'fecha' => $datos['fecha'],
                            'cantidad' => number_format($datos['cantidad'])
                        );
                        $total = $total + number_format($datos['cantidad']);
                        $numdias++;
                    }else{
                        $estat[$i] = array(
                            'fecha' => date_format(date_create($nFecha), 'd/m/Y'),
                            'cantidad' => 0
                        );
                    }
                    
                    $fecha_actual = $nFecha;
                    $i++;
                }
                
                if($numdias != 0){
                    $promedio = round($total/$numdias);
                }else{
                    $promedio = 0;
                }
                
                $array = array(
                    'datos' => $estat,
                    'promedio' => $promedio
                );
                echo json_encode($array);
            }
        }
        
        function getDatosSearch(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');
                $procentro = $this->input->post('procentro');
                $idcatalogo = $this->input->post('idcatalogo');

                $this->load->model('tpedido_model');
                $detalle = $this->tpedido_model->getDatosProductoSearch($prosearch, $dato, $idcentro, $idcatalogo, $trannum, $procentro);
                if($detalle != 0){
                    $i=0;
                    $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
                        if($info->existe == "0"){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "precio" => $info->costounitario,
                                "disponible" => $info->disponible,
                                "disprocentro" => $info->disprocentro,
                                "precioventa" => $info->precioventa,
								"agregado" => 0
                            );
                            $i++;
                        }else{
							$items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "precio" => $info->costounitario,
                                "disponible" => $info->disponible,
                                "disprocentro" => $info->disprocentro,
                                "precioventa" => $info->precioventa,
								"agregado" => 1
                            );
                            $i++;
                            $agregado = 1;
                        }
                    }
                    if($agregado == 1 && $i == 1){
						$datos = $this->tpedido_model->getDataOrders100kProducto($trannum, $idcentro, $procentro, $info->idproducto);
						$array = array(
                            "error" => "2",
							"datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
        }
		
		function getProductAgregadoDetalle(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$idcentro = $this->session->userdata('idcentrouser');
                $idproducto = $this->input->post('idproducto');
                $procentro = $this->input->post('procentro');
				
				
				$this->load->model('tpedido_model');
				$datos = $this->tpedido_model->getDataOrders100kProducto($trannum, $idcentro, $procentro, $idproducto);
				echo json_encode($datos);
			}
		}
        
        function updateOrders100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $cantidad = $this->input->post('cantidad');
                $procentro = $this->input->post('procentro');
                $idcentro = $this->session->userdata('idcentrouser');
				$nameLista = $this->input->post('nombreLista');
				$idcatalogo = $this->input->post('idcatalogo');
				
                $this->load->model('tpedido_model');
                $this->tpedido_model->actualizarOrders100k($idrec, $cantidad);
                
				if($nameLista != ""){
                    $detalle = $this->tpedido_model->getInventarioByLista($trannum, $idcentro, $procentro, $nameLista);
                }else{
                    $detalle = $this->tpedido_model->getInventarioSinLista($trannum, $idcatalogo);
                }

                $datos = $this->tpedido_model->getDataOrder100k($trannum, $idcentro, $procentro);
                $cantidad = $this->tpedido_model->getCantidad100k($trannum);
                $unidades = $this->tpedido_model->getUnidad100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
						$items[$i] = array(
							"nameproducto" => $info->descrip,
							"marca" => $info->marca,
							"modelo" => $info->modelo,
							"upc" => $info->barcode,
							"notas" => $info->notas,
							"idproducto" => $info->idproducto,
							"um" => $info->um,
							"imagen" => $info->imagen,
							"precio" => $info->costounitario,
							"precioventa" => $info->precioventa
						);
						$i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function cerrarOrden100(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $fecha = $this->input->post('fecha');
                $fechaEntrega = $this->input->post('fechaEntrega');
                $notas = $this->input->post('notas');
                
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->closeOrden100($trannum, $fecha, $fechaEntrega, $notas, 1);
                
                echo json_encode($array);
            }
        }
        
        function validateSucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $user = $this->session->userdata("iduser");
                $fechac = $this->input->post("fecha");
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('tpedido_model');
                $result = $this->tpedido_model->validateUnaSucursal($user);
                $result2 = $this->tpedido_model->getCountPedidos($fechac, $idcentro, '0', 'IN');
                
                $array = array(
                    "validate" => $result,
                    "cnt" => $result2
                );
                
                echo json_encode($array);
            }
        }
        
        function getPedidosDate(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $fecha = $this->input->post("fecha");
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('tpedido_model');
                $data = $this->tpedido_model->getPedidosByDate($fecha, $idcentro, '0', 'IN');
                
                echo json_encode($data);
            }
        }
        
        function getDataProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idproducto = $this->input->post("idproducto");
                $trannum = $this->input->post('trannum');
                $idsave = $this->input->post('idsave');
                $cantidad = $this->input->post('cantidad');
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->getInformacionProducto($idproducto);
                
                $idaccount = $this->session->userdata('idacount');
                $idcenter = $this->session->userdata('idcentrouser');
                $name_archive = "temp_cuentas/temp_$idaccount/".$idaccount."_PT_".$trannum."_".$idcenter.".txt";
                /*ELIMINAR ARCHIVO:::::::: unlink('name+extension');
                */
                if(file_exists($name_archive)){
                    $file = fopen($name_archive, "r");
                    $texto = "";
                    $modify = 0;
                    while(!feof($file)){
                        $linea = fgets($file);
                        $txt_explode = explode('|', $linea);
                        if($txt_explode[0] == $idsave){
                            $new_txt = "$txt_explode[0]|$cantidad;\n";
                            $texto .= $new_txt;
                            $modify = 1;
                        }else{
                            $texto .= $linea;   
                        }
                    }
                    fclose($file);
                    
                    $file = fopen($name_archive, "w");
                    fwrite($file, $texto);
                    if($modify == 0){
                        fwrite($file,"$idsave|$cantidad;" . PHP_EOL);    
                    }
                    fclose($file);
                }else{
                    $file = fopen($name_archive, "a+");
                    fwrite($file, "$idsave|$cantidad;" . PHP_EOL);
                    fclose($file);
                }
                
                $file = fopen($name_archive, "r");
                $texto = "";
                while(!feof($file)) {
                    $texto .= fgets($file);
                }
                fclose($file);
                
                $array = array(
                    "filter" => $array,
                    "texto" => $texto
                );
                
                echo json_encode($array);
            }
        }
        
        function getDataArchive(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{    
                $trannum = $this->input->post('trannum');
                $procentro = $this->input->post('procentro');
                $this->load->model('tpedido_model');
                $lst_products = $this->tpedido_model->getLst_Producto($procentro);
                
                $idaccount = $this->session->userdata('idacount');
                $idcenter = $this->session->userdata('idcentrouser');
                $name_archive = "temp_cuentas/temp_$idaccount/".$idaccount."_PT_".$trannum."_".$idcenter.".txt";
                $file = fopen($name_archive, "r");
                $texto = "";
                while(!feof($file)) {
                    $texto .= fgets($file);
                }
                fclose($file);

                $array = array(
                    "texto" => $texto,
                    "invpro" => $lst_products
                );
                
                echo json_encode($array);
            }
        }
        
        function getDescripProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $this->load->model('tpedido_model');
                
                $descrip = $this->tpedido_model->getNameProduct($idproducto);
                
                echo json_encode($descrip);
            }
        }
        
        function getProductosLines(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idLinea = $this->input->post('idLinea');
                $this->load->model('tpedido_model');
                $data = $this->tpedido_model->get_productos_x_linea($idLinea);
                
                $trannum = $this->input->post('trannum');
                $idaccount = $this->session->userdata('idacount');
                $idcenter = $this->session->userdata('idcentrouser');
                $name_archive = "temp_cuentas/temp_$idaccount/".$idaccount."_PT_".$trannum."_".$idcenter.".txt";
                
                $file = fopen($name_archive, "r");
                $texto = "";
                while(!feof($file)) {
                    $texto .= fgets($file);
                }
                fclose($file);

                $array = array(
                    "texto" => $texto,
                    "inf" => $data
                );
                
                echo json_encode($array);
            }
        }
        
        function save_one_product(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idsave = $this->input->post('idsave');
                $cantidad = $this->input->post('cantidad');
                
                $idaccount = $this->session->userdata('idacount');
                $idcenter = $this->session->userdata('idcentrouser');
                $name_archive = "temp_cuentas/temp_$idaccount/".$idaccount."_PT_".$trannum."_".$idcenter.".txt";
                
                if(file_exists($name_archive)){
                    $file = fopen($name_archive, "r");
                    $texto = "";
                    $modify = 0;
                    while(!feof($file)){
                        $linea = fgets($file);
                        $txt_explode = explode('|', $linea);
                        if($txt_explode[0] == $idsave){
                            $new_txt = "$txt_explode[0]|$cantidad;\n";
                            $texto .= $new_txt;
                            $modify = 1;
                        }else{
                            $texto .= $linea;   
                        }
                    }
                    fclose($file);
                    
                    $file = fopen($name_archive, "w");
                    fwrite($file, $texto);
                    if($modify == 0){
                        fwrite($file,"$idsave|$cantidad;" . PHP_EOL);    
                    }
                    fclose($file);
                }else{
                    $file = fopen($name_archive, "a+");
                    fwrite($file, "$idsave|$cantidad;" . PHP_EOL);
                    fclose($file);
                }
                
                $file = fopen($name_archive, "r");
                $texto = "";
                while(!feof($file)){
                    $texto .= fgets($file);
                }
                fclose($file);
                
                $array = array(
                    "texto" => $texto
                );
                
                echo json_encode($array);
            }
        }
        
        function close_pedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{    
                $trannum = $this->input->post('trannum');
                $notas = $this->input->post('notas');
                $idaccount = $this->session->userdata('idacount');
                $idcenter = $this->session->userdata('idcentrouser');
                $name_archive = "temp_cuentas/temp_$idaccount/".$idaccount."_PT_".$trannum."_".$idcenter.".txt";
                
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->insertDataPedido($name_archive, $trannum, $notas);
                
                //::::::::ELIMINAR ARCHIVO::::::::
                unlink($name_archive);
                //::::::::::::::::::::::::::::::::
                echo json_encode($array);
            }
        }
        
        function get_pedidos_by_procentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $procentro = $this->input->post('procentro');
                $idcenter = $this->session->userdata('idcentrouser');
                $this->load->model('tpedido_model');
                $array_count = $this->tpedido_model->getCountPedidosByEstatus($procentro, $idcenter, 'IN');
                $array_data = $this->tpedido_model->getPedidosByProcentro($procentro, $idcenter, 'IN');
                $array = array(
                    "data_p" => $array_data,
                    "count" => $array_count
                );
                echo json_encode($array);
            }
        }
        
        function get_pedidos_by_estatus(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $procentro = $this->input->post('procentro');
                $estatus = $this->input->post('estatus');
                $idcenter = $this->session->userdata('idcentrouser');
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->getPedidosByEstatus($procentro, $estatus, $idcenter, 'IN');
                echo json_encode($array);
            }
        }
        
        function getPedidosByEstatus(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $procentro = $this->input->post('procentro');
                $estado = $this->input->post('estado');
                $idcenter = $this->session->userdata('idcentrouser');
                
                $centroSelected = array(
                    'idCentroPedidoSec' => $procentro
                );
                $this->session->set_userdata($centroSelected);
                
                $this->load->model('tpedido_model');
                $datos = $this->tpedido_model->getPedidosEstatus($procentro, $idcenter, 'IN', $estado);
                
                $i=0;
                $array = array();
                foreach($datos as $info){
                    
                    $j=0;
					$unidades = 0;
                    $detailorden = array();
                    
                    $detalle = $this->tpedido_model->getDetalleOrden100k($info->trannum);
                    if($detalle != false){
                        foreach($detalle as $det){
                            $j++;
                            $unidades = $unidades + number_format($det->cantidad, 2, '.', '');
                        }
                    }
                    
                    $array[$i] = array(
                        'estatus' => $info->estatus,
                        'trannum' => $info->trannum,
                        'fecha' => $info->fecha,
                        'dev_date' => $info->dev_date,
                        'dev_direc' => $info->dev_direc,
                        'notas' => $info->notas,
                        'lu' => $j.'/'.number_format($unidades),
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
        function getDetalleProductosPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$trannum = $this->input->post('trannum');
				
                $this->load->model('tpedido_model');
                $detalle = $this->tpedido_model->getDetalleOrden100k($trannum);
                
                echo json_encode($detalle);
            }
        }
        
        function setAnulaciondeOrden(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->anulacionDeOrden($trannum);
                echo json_encode($array);
            }
        }
        
        function regresarEstadoPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->regresarEstadoPedido($trannum);
                echo json_encode($array);
            }
        }
        
        function get_detalle_orden_view(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('tpedido_model');
                $data_hd = $this->tpedido_model->getDataPedido($trannum, 1);
                $data_dt = $this->tpedido_model->getDataDtPedido($trannum);
                $array = array(
                    "data_hd" => $data_hd,
                    "data_dt" => $data_dt
                );
                echo json_encode($array);
            }
        }
        
        function verControlProduccion($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('tpedido_model');
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $procentro = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'idprocentro' => $procentro
                );
                $this->session->set_userdata($resultAppName);
                $idcentro = $this->session->userdata('idcentrouser');
                $this->data['pedidos'] = $this->tpedido_model->getCountPedidosByCentro($procentro, 'IN');
                $this->data['catalogo'] = $this->tpedido_model->getLineasProcentro($procentro);
                $this->load->view('pedidos/tpedido_controlproduccion', $this->data);
            }
        }
        
        function getCountSolitProcentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('tpedido_model');
                $procentro = $this->session->userdata('idprocentro');
                $date_pedido = $this->input->post('fecha');
                $array = $this->tpedido_model->getCountProductosSolicitados($procentro, $date_pedido);
                echo json_encode($array);
            }
        }
        
        function getDetalleLinea(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('tpedido_model');
                $procentro = $this->input->post('procentro');
                $idcatalogo = $this->input->post('idcatalogo');
                $date_pedido = $this->input->post('fecha');
                $array1 = $this->tpedido_model->getPedidosByLineOrder100k($idcatalogo, $procentro);
                $array2 = $this->tpedido_model->getCountIndividualProductos($procentro, $idcatalogo);
                
                $array = array(
                    "detalle" => $array1,
                    "cantidad" => $array2
                );
                echo json_encode($array);
            }
        }
        
        function getSucursalesByProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $fecha = $this->input->post('fecha');
                $procentro = $this->session->userdata('idprocentro');
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->getNameSucursalesByProducto($idproducto, $fecha, $procentro);
                echo json_encode($array);
            }
        }
		
		function listadef($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('sucursal_model');
				$this->load->model('producto_model');
				
				$this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
				$this->data['tipos'] = $this->sucursal_model->getTiposSucursalesActivas();
				$this->data['productos'] = $this->producto_model->getProductosByEstatus(1);
				
				$this->load->view('pedidos/mantenimiento_listapedidos', $this->data);
			}
		}
		
		function getNombreListaProductos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('tpedido_model');
				
				$array = $this->tpedido_model->getListadoNombresListas();
				echo json_encode($array);
			}
		}
		
		function getListasProByCentro(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('tpedido_model');
				$idcentro = $this->input->post('idcentro');
				$datos = $this->tpedido_model->getListadoNombresListas();
					
				$i=0;
				$array = array();
				$total = count($datos);
				
				for($i=0; $i<$total; $i++){
					$cantidad = $this->tpedido_model->getCantidadProductoByListaCentro($datos[$i]['nameLista'], $idcentro);
					
					$array[$i] = array(
						"nameLista" => $datos[$i]['nameLista'],
						"cantidad" => $cantidad
					);
				}
				
				echo json_encode($array);
			}
		}
		
		function insertNombreLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$nombreLista = $this->input->post('nombreLista');
				$this->load->model('tpedido_model');
				
				$this->tpedido_model->insertNombresListas($nombreLista);
				$array = $this->tpedido_model->getListadoNombresListas();
				echo json_encode($array);
			}
		}
		
		function updateNombreLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$nombreLista = $this->input->post('nombreLista');
				$nombreanterior = $this->input->post('nombreanterior');
				
				$this->load->model('tpedido_model');
				$this->tpedido_model->updateNombresListas($nombreLista, $nombreanterior);
				$array = $this->tpedido_model->getListadoNombresListas();
				echo json_encode($array);
			}
		}
		
		function deleteNombreLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$nombreanterior = $this->input->post('nombreanterior');
				
				$this->load->model('tpedido_model');
				$dato = $this->tpedido_model->deleteNombresListas($nombreanterior);
				
				if($dato != 1){
					$array = $this->tpedido_model->getListadoNombresListas();
				}else{
					$array = 0;
				}
					
				echo json_encode($array);
			}
		}
        
        function insertProductoToLista(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$procentro = $this->input->post('procentro');
				$nombrelista = $this->input->post('nombrelista');
				$idproducto = $this->input->post('idproducto');
				$cantmin = $this->input->post('cantmin');
				$cantmax = $this->input->post('cantmax');
				$dias = $this->input->post('dias');
				$centros = $this->input->post('centros');
				$notas = $this->input->post('notas');
				
				$buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
				$reemplazar = array("", "", "", "");
				$notas = str_replace($buscar, $reemplazar, $notas);

				$this->load->model('tpedido_model');
				
				$validate = $this->tpedido_model->validateProductoToLista($procentro,$nombrelista,$idproducto);
				if($validate){
					$array = $this->tpedido_model->insertProductoLista($procentro,$nombrelista,$idproducto,$cantmin,$cantmax,$dias,$centros,$notas);
				}else{
					$array = false;
				}
                echo json_encode($array);
			}
        }
		
		function updateProductoLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idlista = $this->input->post('idlista');
				$procentro = $this->input->post('procentro');
				$nombrelista = $this->input->post('nombrelista');
				$idproducto = $this->input->post('idproducto');
				$cantmin = $this->input->post('cantmin');
				$cantmax = $this->input->post('cantmax');
				$dias = $this->input->post('dias');
				$centros = $this->input->post('centros');
				$notas = $this->input->post('notas');
				
				$buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
				$reemplazar = array("", "", "", "");
				$notas = str_replace($buscar, $reemplazar, $notas);

				$this->load->model('tpedido_model');
				
				$validate = $this->tpedido_model->validateProductoToLista($procentro,$nombrelista,$idproducto);
				//if($validate){
				$array = $this->tpedido_model->updateProductoLista($idlista,$procentro,$nombrelista,$idproducto,$cantmin,$cantmax,$dias,$centros,$notas);
				/*}else{
					$array = false;
				}*/
				echo json_encode($array);
			}
		}
		
		function deleteProductoLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idlista = $this->input->post('idlista');
				
				$this->load->model('tpedido_model');
				$array = $this->tpedido_model->deleteProductoLista($idlista);
                echo json_encode($array);
			}
		}
        
        function getProductosByLista(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$nombrelista = $this->input->post('nombrelista');
				
				$this->load->model('tpedido_model');
                if($nombrelista != "" && $idcentro != ""){
                    $datos = $this->tpedido_model->getListadoProductosByLista($idcentro,$nombrelista);
                    
                    $i=0;
                    $array = array();
                    foreach($datos as $info){
                        $dias = str_replace('1', 'Lun', $info->dias);
                        $dias = str_replace('2', 'Mar', $dias);
                        $dias = str_replace('3', 'Mie', $dias);
                        $dias = str_replace('4', 'Jue', $dias);
                        $dias = str_replace('5', 'Vie', $dias);
                        $dias = str_replace('6', 'Sab', $dias);
                        $dias = str_replace('7', 'Dom', $dias);
                        
                        $array[$i] = array(
                            "idlista" => $info->idlista,
                            "idproducto" => $info->idproducto,
                            "nameProducto" => $info->nameProducto,
                            "cantmin" => $info->cantmin,
                            "cantmax" => $info->cantmax,
                            "dias" => $dias
                        );
                        
                        $i++;
                    }
                }else{
                    $array = "error";
                }
                echo json_encode($array);
			}
        }
        
        function getDatosIngresadoProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idlista = $this->input->post('idlista');
                
				$this->load->model('tpedido_model');
				$this->load->model('sucursal_model');
                $datos = $this->tpedido_model->getInformacionProductoLista($idlista);
				$sucursales = $this->sucursal_model->viewSucursalActiva();
				$tipos = $this->sucursal_model->getTiposSucursalesActivas();
				
				foreach($datos as $info){
					$ids = explode(',', $info->allowedcentros);
					$total = count($ids);
					$idcentros = array();
				}
				
				$i=0;
				$centros = array();
				foreach($tipos as $tip){
					
					$items = array();
					$j=0;
					
					foreach($sucursales as $suc){
						if($tip->grupo == $suc->grupo){
							
							$open = false;
							for($k=0; $k<$total; $k++){
								if($suc->idcentro == $ids[$k]){
									$open = true;
								}
							}
							
							$items[$j] = array(
								"id" => $suc->idcentro,
								"text" => trim($suc->descrip),
								"idcentro" => $suc->idcentro,
								"descrip" => trim($suc->descrip),
								"selected" => $open,
							);
							$j++;
						}
					}
					
					$centros[$i] = array(
						"id" => trim($tip->tipo)."9999",
						"parentId" => 0,
						"text" => trim($tip->grupo),
						"expanded" => false,
						"items" => $items	
					);
					$i++;
				}
				/*
				foreach($datos as $info){
					$ids = explode(',', $info->allowedcentros);
					$total = count($ids);
					$idcentros = array();
					for($i=0; $i<$total; $i++){
						if($suc->idcentro == $ids[$i]){
							$open = true;
						}
						$idcentros[$i] = array(
							number_format($ids[$i])
						);
					}
				}*/
				
				$array = array(
					'datos' => $datos,
					'idcentros' => $centros
				);
				
                echo json_encode($array);
            }
        }
		
		function getListasDisponibles(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->input->post('procentro');
				
				$this->load->model('tpedido_model');
				$datos = $this->tpedido_model->getListasDisponiblesCentro($idcentro, $procentro);
				
				$i=0;
				$array = array();
				
				if($datos != false){
					foreach($datos as $info){
						$array[$i] = array(
							"id" => $info->invplista,
							"descrip" => $info->nombrelista
						);
						$i++;
					}
				}
				
				echo json_encode($array);
			}
		}
		
		function getSucursalesByTipo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$tipocentro = $this->input->post('tipocentro');
				
				$this->load->model('tpedido_model');
				$array = $this->tpedido_model->getSucursalesByTipoCentro($tipocentro);
				echo json_encode($array);
			}
        }
		
		function definicion_listas($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('sucursal_model');
				$this->load->model('producto_model');
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $this->data['name_sucursal'] = $this->sucursal_model->getNameCentro($this->session->userdata('idcentrouser'));
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['direccion'] = $controlador;  
				$this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
				$this->data['tipos'] = $this->sucursal_model->getTiposSucursalesActivas();
				$this->load->view('pedidos/mantenimiento_definicion_listas_update', $this->data);
			}
		}
		
		function definicion_listas_update($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('sucursal_model');
				$this->load->model('producto_model');
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $this->data['name_sucursal'] = $this->sucursal_model->getNameCentro($this->session->userdata('idcentrouser'));
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['direccion'] = $controlador;  
				$this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
				$this->data['tipos'] = $this->sucursal_model->getTiposSucursalesActivas();
				$this->load->view('pedidos/mantenimiento_definicion_listas_update', $this->data);
			}
		}
		
        function insert_ListaDef(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$name_lista = $this->input->post('text');
				$this->load->model('tpedido_model');
				
				$this->tpedido_model->insert_ListaDef($name_lista);
				$lista = $this->tpedido_model->getListasDefinidas();
				echo json_encode($lista);
			}
		}
		
		function update_ListaDef(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idrnum = $this->input->post('idrnum');
				$descripcion = $this->input->post('descripcion');
				$this->load->model('tpedido_model');
				
				$this->tpedido_model->update_ListaDef($idrnum,$descripcion);
				$lista = $this->tpedido_model->getListasDefinidas();
				echo json_encode($lista);
			}
		}
		
		function get_ListaDef(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('tpedido_model');
				$lista = $this->tpedido_model->getListasDefinidas();
				echo json_encode($lista);
			}
		}
		
        function insertNewLista(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$name_lista = $this->input->post('name_lista');
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->input->post('procentro');
                $clave_lista = $this->input->post('clave_lista');
				$dias = $this->input->post('dias');
				$listCentros = $this->input->post('listCentros');
                
				$this->load->model('tpedido_model');
                $existe = $this->tpedido_model->verificaExiste($name_lista,$idcentro,$procentro);
                if($existe==0){
                    $this->tpedido_model->insertNewLista($name_lista,$clave_lista,$procentro,$dias,$listCentros);
                    $information = $this->tpedido_model->getListasDefinidasCentro($idcentro,$procentro);
                    $j=0;
                    $lista = array();
                    foreach($information as $info){
                        $cadena_semana = "";
                        $lunes=false;
                        $martes=false;
                        $miercoles=false;
                        $jueves=false;
                        $viernes=false;
                        $sabado=false;
                        $domingo=false;
                        $dias_semana = explode(",", $info->dias);
                        $totalItems = count($dias_semana);
                        for($i=0; $i<$totalItems; $i++){
                            switch($dias_semana[$i]){
                                case 1:
                                    $lunes = true;
                                    $cadena_semana .=" Lunes, ";
                                    break;
                                case 2:
                                    $martes = true;
                                    $cadena_semana .=" Martes, ";
                                    break;
                                case 3:
                                    $miercoles = true;
                                    $cadena_semana .=" Miercoles, ";
                                    break;
                                case 4:
                                    $jueves = true;
                                    $cadena_semana .=" Jueves, ";
                                    break;
                                case 5:
                                    $viernes = true;
                                    $cadena_semana .=" Viernes, ";
                                    break;
                                case 6:
                                    $sabado = true;
                                    $cadena_semana .=" Sábado, ";
                                   break;
                                case 7:
                                    $domingo = true;
                                    $cadena_semana .=" Domingo, ";
                                    break;
                           }
                        }
                        if($cadena_semana!=""){
                            $cadena_semana = substr($cadena_semana, 0, -2);
                        }
                    
                        $lista[$j] = array(
                            "lunes" => $lunes,
                            "martes" => $martes,
                            "miercoles" => $miercoles,
                            "jueves" => $jueves,
                            "viernes" => $viernes,
                            "sabado" => $sabado,
                            "domingo" => $domingo,
                            "cadena_semana" => $cadena_semana,
                            "idrec" => $info->idrec,
                            "procentro" => $info->procentro,
                            "idcentro" => $info->idcentro,
                            "invplista" => $info->invplista,
                            "dias" => $info->dias,
                            "cantidad_products" => $info->cantidad_products,
                        );
                        $j++;
                    }
                }else{
                    $lista=false;
                }
                $array = array(
                    "existe" =>$existe,
                    "lista" =>$lista
                );
				
				echo json_encode($array);
			}
		}
		
        function updateNameLista(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idrec = $this->input->post('idrec');
				$name_lista = $this->input->post('name_lista');
				$last_name = $this->input->post('last_name');
				$clave = $this->input->post('clave_lista');
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->input->post('procentro');
				$dias = $this->input->post('dias');
				$listCentros = $this->input->post('listCentros');
                
				$this->load->model('tpedido_model');
                $sincambiar_name = $this->tpedido_model->verificaExisteSame($name_lista,$idrec);
                $name_lista = trim($name_lista);
                $last_name = trim($last_name);
                
                if($name_lista!=$last_name){
                    $existe = $this->tpedido_model->verificaExiste($name_lista,$idcentro,$procentro);  
                    if($existe==0){
                        $this->tpedido_model->updateLista($idrec,$name_lista,$clave,$dias,$idcentro,$procentro,$listCentros);
                    }
                }else{
                    $this->tpedido_model->updateLista($idrec,$name_lista,$clave,$dias,$idcentro,$procentro,$listCentros);
                    $existe=0;
                }
                
                $registro = $this->tpedido_model->getRegistroInfo($idrec);
                $cadena_semana = "";
                $name_lista = "";
                $dias_items = "";
                $clave_ = "";
                foreach($registro as $reg){
                    $name_lista = $reg->invplista;
                    $dias_items = $reg->dias;
                    $clave_ = $reg->clave;
                    $dias_semana = explode(",", $reg->dias);
                    $totalItems = count($dias_semana);
                    for($i=0; $i<$totalItems; $i++){
                        switch($dias_semana[$i]){
                            case 1:
                                $cadena_semana .=" Lunes, ";
                                break;
                            case 2:
                                $cadena_semana .=" Martes, ";
                                break;
                            case 3:
                                $cadena_semana .=" Miercoles, ";
                                break;
                            case 4:
                                $cadena_semana .=" Jueves, ";
                                break;
                            case 5:
                                $cadena_semana .=" Viernes, ";
                                break;
                            case 6:
                                $cadena_semana .=" Sábado, ";
                                break;
                            case 7:
                                $cadena_semana .=" Domingo, ";
                                break;
                        }
                    }
                    if($cadena_semana!=""){
                        $cadena_semana = substr($cadena_semana, 0, -2);
                    }
                }
                $array = array(
                    "existe" => $existe,
                    "name_lista" => $name_lista,
                    "cadena_semana" => $cadena_semana,
                    "dias" => $dias_items,
                    "clave" => $clave_,
                );
				echo json_encode($array);
			}
		}
		
		function getListasCentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idcentro = $this->session->userdata('idcentrouser');
				$procentro = $this->input->post('idcentro');
				$this->load->model('tpedido_model');
				$information = $this->tpedido_model->getListasDefinidasCentro($idcentro,$procentro);
                $j=0;
                $lista = array();
                if($information!=false){
                    foreach($information as $info){
                        $lunes=false;
                        $martes=false;
                        $miercoles=false;
                        $jueves=false;
                        $viernes=false;
                        $sabado=false;
                        $domingo=false;                        
                        $cadena_semana = "";
                        $dias_semana = explode(",", $info->dias);
                        $totalItems = count($dias_semana);
                        for($i=0; $i<$totalItems; $i++){
                           switch($dias_semana[$i]){
                                case 1:
                                    $lunes = true;
                                    $cadena_semana .=" Lunes, ";
                                    break;
                                case 2:
                                    $martes = true;
                                    $cadena_semana .=" Martes, ";
                                    break;
                                case 3:
                                    $miercoles = true;
                                    $cadena_semana .=" Miercoles, ";
                                    break;
                                case 4:
                                    $jueves = true;
                                    $cadena_semana .=" Jueves, ";
                                    break;
                                case 5:
                                    $viernes = true;
                                    $cadena_semana .=" Viernes, ";
                                    break;
                                case 6:
                                    $sabado = true;
                                    $cadena_semana .=" Sábado, ";
                                   break;
                                case 7:
                                    $domingo = true;
                                    $cadena_semana .=" Domingo, ";
                                    break;
                           }
                        }
                        if($cadena_semana!=""){
                            $cadena_semana = substr($cadena_semana, 0, -2);
                        }

                        $lista[$j] = array(
                            "cadena_semana" => $cadena_semana,
                            "lunes" => $lunes,
                            "martes" => $martes,
                            "miercoles" => $miercoles,
                            "jueves" => $jueves,
                            "viernes" => $viernes,
                            "sabado" => $sabado,
                            "domingo" => $domingo,
                            "idrec" => $info->idrec,
                            "procentro" => $info->procentro,
                            "idcentro" => $info->idcentro,
                            "invplista" => $info->invplista,
                            "dias" => $info->dias,
                            "cantidad_products" => $info->cantidad_products,
                        );
                        $j++;
                    }
                }
                
				echo json_encode($lista);
			}
		}
		
        function get_ListaDefDistint(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $procentro = $this->input->post("procentro");
				$this->load->model('tpedido_model');
				$lista = $this->tpedido_model->getListasDefinidasDistinct($procentro);
				echo json_encode($lista);
			}
		}
		
		function detalle_listas($idrec){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('configuracion_model');
                $resultAppName = array(
                    'namePage' => "Detalle de " . $this->session->userdata('appName'),
                );
                $this->session->set_userdata($resultAppName);
				$this->load->model('sucursal_model');
				$this->load->model('producto_model');
				$this->load->model('tpedido_model');
                $controlador = $this->uri->segment(1);
                $this->load->model('global_model');
                $registro = $this->tpedido_model->getRegistroInfo($idrec);
                $this->data['registro'] = $registro;
                $cadena_semana = "";
                $procentro_selected = 0;
                foreach($registro as $reg){
                    $procentro_selected = $reg->procentro;
                    $dias_semana = explode(",", $reg->dias);
                    $totalItems = count($dias_semana);
                    for($i=0; $i<$totalItems; $i++){
                        switch($dias_semana[$i]){
                            case 1:
                                $cadena_semana .=" Lunes, ";
                                break;
                            case 2:
                                $cadena_semana .=" Martes, ";
                                break;
                            case 3:
                                $cadena_semana .=" Miercoles, ";
                                break;
                            case 4:
                                $cadena_semana .=" Jueves, ";
                                break;
                            case 5:
                                $cadena_semana .=" Viernes, ";
                                break;
                            case 6:
                                $cadena_semana .=" Sábado, ";
                                break;
                            case 7:
                                $cadena_semana .=" Domingo, ";
                                break;
                        }
                    }
                    if($cadena_semana!=""){
                        $cadena_semana = substr($cadena_semana, 0, -2);
                    }
                }
                $array_procentro = array(
                    'procentro_selected' => $procentro_selected,
                );
                $this->session->set_userdata($array_procentro);
                $this->data['dias_semana'] = $cadena_semana;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['direccion'] = $controlador;  
				$this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
				$this->data['tipos'] = $this->sucursal_model->getTiposSucursalesActivas();
				$this->data['productos'] = $this->producto_model->getProductosByEstatus(1);
                $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo(1);
                $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo(1);
                
				$this->load->view('pedidos/mantenimiento_detalle_listas', $this->data);
			}
		}
        
        function getInformacionCentrosCompartidos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                
                $this->load->model('sucursal_model');
                $this->load->model('tpedido_model');
                
                $sucursales = $this->sucursal_model->viewSucursalActiva();
				$tipos = $this->sucursal_model->getTiposSucursalesActivas();
                $informacion = $this->tpedido_model->getRegistroInfo($idrec);
                
                foreach($informacion as $info){
                    $listadoSucursales = $info->tipo;
                    if($listadoSucursales != 0){
                        $itemsSelected = explode(",", $listadoSucursales);
                    }
                }
                
                $i=0;
                $array = array();
                
                foreach($tipos as $infoTipos){
                    $j=0;
                    $arrayInterno = array();
                    foreach($sucursales as $infoCentro){
                        if($this->session->userdata('idcentrouser') != $infoCentro->idcentro && trim($infoCentro->grupo) == trim($infoTipos->grupo)){
                            $valorSelected = false;
                            if($listadoSucursales != 0){
                                for($k=0; $k<count($itemsSelected) - 1; $k++){
                                    if($itemsSelected[$k] == $infoCentro->idcentro){
                                        $valorSelected = true;
                                    }
                                }
                            }
                            
                            $arrayInterno[$j] = array(
                                "id" => $infoCentro->idcentro,
                                "text" => trim($infoCentro->descrip),
                                "selected" => $valorSelected
                            );
                            $j++;
                        }
                    }

                    $array[$i] = array(
                        "id" => $infoTipos->tipo."9999",
                        "text" => trim($infoTipos->grupo),
                        "parentId" => 0,
                        "items" => $arrayInterno
                    );
                    $i++;
                }
                
                $dataSource = array(
                    "itemSelected" => $listadoSucursales,
                    "dataSource" => $array
                );
                
                echo json_encode($dataSource);
            }
        }
		
        function getProductsLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->input->post("procentro");
                $invplista = $this->input->post("invplista");
				$this->load->model('tpedido_model');
				$informacion = $this->tpedido_model->getListadoProductos($idcentro,$procentro,$invplista);
                $j=0;
                $array_datos = array();
                
                if($informacion!=false){
                    foreach($informacion as $info){
                        if($info->existe == 0){
                            $array_datos[$j] = array(
                                "idproducto" => $info->idproducto,
                                "descrip" => $info->descrip,
                                "costounitario" => $info->costounitario,
                                "idcatalogo" => $info->idcatalogo,
                                "linea" => $info->linea,
                                "nameproveedor" => $info->nameproveedor,
                                "modelo" => $info->modelo,
                                "um" => $info->um,
                                "precioventa" => $info->precioventa,
                                "marca" => $info->marca,
                                "tipotax" => $info->tipotax,
                            );

                            $j++;
                        }
                    }
                }
                echo json_encode($array_datos);
            }
        }
        
        function insertarProductosToLista(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $procentro = $this->input->post("procentro");
                $invplista = $this->input->post("invplista");
                $idproductos = $this->input->post("idproductos");
                $idcentro = $this->session->userdata('idcentrouser');
				$this->load->model('tpedido_model');
                $this->tpedido_model->insertarProductosByGrid($idcentro,$procentro,$invplista, $idproductos);
                $informacion = $this->tpedido_model->getListadoProductosLista($idcentro,$procentro,$invplista);
                $j=0;
                $array_datos = array();
                
                if($informacion!=false){
                    foreach($informacion as $info){
                        $array_datos[$j] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "costounitario" => $info->costounitario,
                            "idcatalogo" => $info->idcatalogo,
                            "linea" => $info->linea,
                            "nameproveedor" => $info->nameproveedor,
                            "modelo" => $info->modelo,
                            "um" => $info->um,
                            "precioventa" => $info->precioventa,
                            "marca" => $info->marca,
                            "tipotax" => $info->tipotax,
                            "cantmin" => $info->cantmin,
                            "cantmax" => $info->cantmax,
                            "idrec" => $info->idrec,
                            "procentro" => $procentro,
                            "idcentro" => $idcentro,
                            "invplista" => $invplista,
                        );
                        $j++;
                    }
                }
                $arreglo = array(
                    "informacion" =>$array_datos,
                    "cantidad" =>$j
                );
                echo json_encode($arreglo);
            }
        }
        
        function getProductsListaTabla(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->input->post("procentro");
                $invplista = $this->input->post("invplista");
				$this->load->model('tpedido_model');
                
				$informacion = $this->tpedido_model->getListadoProductosLista($idcentro,$procentro,$invplista);
                $j=0;
                $array_datos = array();
                if($informacion!=false){
                    foreach($informacion as $info){
                        
                        $array_datos[$j] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "costounitario" => $info->costounitario,
                            "idcatalogo" => $info->idcatalogo,
                            "linea" => $info->linea,
                            "nameproveedor" => $info->nameproveedor,
                            "modelo" => $info->modelo,
                            "um" => $info->um,
                            "precioventa" => $info->precioventa,
                            "marca" => $info->marca,
                            "tipotax" => $info->tipotax,
                            "cantmin" => $info->cantmin,
                            "cantmax" => $info->cantmax,
                            "notas" => $info->notas,
                            "idrec" => $info->idrec,
                            "procentro" => $procentro,
                            "idcentro" => $idcentro,
                            "invplista" => $invplista,
                            );
                            $j++;
                    }
                }
                $arreglo = array(
                    "informacion" =>$array_datos,
                    "cantidad" =>$j
                );
                echo json_encode($arreglo);
            }
        }

        function eliminarListaDePedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->input->post("procentro");
                $invplista = $this->input->post("invplista");
                
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->eliminarListaDePedido($idcentro,$procentro,$invplista);
                
                echo json_encode($array);
            }
        }
        
		function updateProductLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
				$idrec = $this->input->post('idrec');
				$procentro = $this->input->post('procentro');
				$invplista = $this->input->post('invplista');
				$idproducto = $this->input->post('idproducto');
				$cantmin = $this->input->post('cantmin');
				$cantmax = $this->input->post('cantmax');
				$notas = $this->input->post('notas');
				
				$buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
				$reemplazar = array("", "", "", "");
				$notas = str_replace($buscar, $reemplazar, $notas);

				$this->load->model('tpedido_model');
				
				$array = $this->tpedido_model->updateProductLista($idrec,$idproducto,$cantmin,$cantmax,$notas);
                $informacion = $this->tpedido_model->getListadoProductosLista($idcentro,$procentro,$invplista);
                $j=0;
                $array_datos = array();
                if($informacion!=false){
                    foreach($informacion as $info){
                       
                        $array_datos[$j] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "costounitario" => $info->costounitario,
                            "idcatalogo" => $info->idcatalogo,
                            "linea" => $info->linea,
                            "nameproveedor" => $info->nameproveedor,
                            "modelo" => $info->modelo,
                            "um" => $info->um,
                            "precioventa" => $info->precioventa,
                            "marca" => $info->marca,
                            "tipotax" => $info->tipotax,
                            "cantmin" => $info->cantmin,
                            "cantmax" => $info->cantmax,
                            "notas" => $info->notas,
                            "idrec" => $info->idrec,
                            "procentro" => $procentro,
                            "idcentro" => $idcentro,
                            "invplista" => $invplista,
                            );
                            $j++;
                    }
                }
                $arreglo = array(
                    "informacion" =>$array_datos,
                    "cantidad" =>$j
                );
                echo json_encode($arreglo);
			}
		}
        
		function deleteProductLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
				$idrec = $this->input->post('idrec');
				$procentro = $this->input->post('procentro');
				$invplista = $this->input->post('invplista');
				$this->load->model('tpedido_model');
				
				$array = $this->tpedido_model->deleteProductLista($idrec);
                $informacion = $this->tpedido_model->getListadoProductosLista($idcentro,$procentro,$invplista);
                $j=0;
                $array_datos = array();
                if($informacion!=false){
                    foreach($informacion as $info){
                        $cadena_semana = "";
                        $dias_semana = explode(",", $info->dias);
                        $totalItems = count($dias_semana);
                        $array_datos[$j] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "costounitario" => $info->costounitario,
                            "idcatalogo" => $info->idcatalogo,
                            "linea" => $info->linea,
                            "nameproveedor" => $info->nameproveedor,
                            "modelo" => $info->modelo,
                            "um" => $info->um,
                            "precioventa" => $info->precioventa,
                            "marca" => $info->marca,
                            "tipotax" => $info->tipotax,
                            "cantmin" => $info->cantmin,
                            "cantmax" => $info->cantmax,
                            "notas" => $info->notas,
                            "idrec" => $info->idrec,
                            "procentro" => $procentro,
                            "idcentro" => $idcentro,
                            "invplista" => $invplista,
                            );
                            $j++;
                    }
                }
                $arreglo = array(
                    "informacion" =>$array_datos,
                    "cantidad" =>$j
                );
                echo json_encode($arreglo);
			}
		}
        
        function getValidatePasswordLista(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->input->post('procentro');
				$nameLista = $this->input->post('nameLista');
                
                $this->load->model('tpedido_model');
				$array = $this->tpedido_model->getValidatePasswordLista($idcentro, $procentro, $nameLista);
                
                echo json_encode($array);
            }
        }
        
        function preparacionPedidos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $idclase = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'idclassPedido' => $idclase
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;
                $this->data['IDClase'] = $idclase;
                $this->load->view('pedidos/mantenimiento_preparacion_pedidos', $this->data);
            }
        }
        
        function getListadoLotesPedidos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                $informacion = $this->tpedido_model->getListadoLotesPedidos($idcentro, 'PP', $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->fecact == "0000-00-00"){
                            $fecact = "";
                        }else{
                            $fecact = $info->fecact;
                        }
                        
                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "estatus" => $info->estatus,
                            "fecha" => $info->fecha,
                            "fecact" => $info->fecact,
                            "notas" => trim($info->notas),
                            "totalPedidos" => $info->totalPedidos * 1
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getPedidosPorFechaToGrid(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $fecha = $this->input->post('fecha');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                $informacion = $this->tpedido_model->getPedidosPorFechaToGrid($idcentro, $fecha, 'IN');
                
                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "nameSucursal" => $info->nameSucursal,
                            "notas" => $info->notas,
                            "numProductos" => $info->totalProductos * 1
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getPedidosPorFechaToCalendar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                $informacion = $this->tpedido_model->getPedidosPorFechaToCalendar($idcentro, 'IN');
                
                $i=0;
                $items = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $startDate = $info->dev_date . ' 00:00:00';
                        $endDate = $info->dev_date . ' 23:59:59';
                        
                        $items[$i] = array(
                            "text" => $info->totalPedidos,
                            "fecha_item" => $info->dev_date,
                            "startDate" => $startDate,
                            "endDate" => $endDate
                        );
                        $i++;
                    }
                }
                
                echo json_encode($items);
            }
        }
        
        function insertarLoteDePreparacionPedidos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idordenes = $this->input->post('idordenes');
                $notas = $this->input->post('notas');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
				$reemplazar = array("", "", "", "");
				$notas = str_replace($buscar, $reemplazar, $notas);

                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->insertarLoteDePreparacionPedidos($idcentro, $idordenes, $notas);
                
                echo json_encode($array);
            }
        }
        
        function detallePreparacionPedidos($trannum, $IDClase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $resultAppName = array(
                    'namePage' => "Detalle de " . $this->session->userdata('appName'),
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('global_model'); $this->load->model('tpedido_model');
                
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['informacion'] = $this->tpedido_model->getInformacionLoteDePedido($trannum);
                $this->data['IDClase'] = $IDClase;
				$this->load->view('pedidos/mantenimiento_detalle_preparacion_pedidos', $this->data);
            }
        }
        
        function getPedidosProductosToGrid(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('tpedido_model');
                $informacion = $this->tpedido_model->getPedidosDetalleToGrid($trannum, 'IN');
                
                $i=0;
                $itemPedidos = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $itemPedidos[$i] = array(
                            "trannum" => $info->trannum,
                            "idcentro" => $info->idcentro,
                            "trannumTraslado" => $info->nrc,
                            "nameSucursal" => $info->nameSucursal,
                            "ordenados" => $info->totalProductos * 1,
                            "despachados" => $info->totalDespachados * 1,
                            "estatus" => $info->estatus
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "dataSourcePedidos" => $itemPedidos,
                    "totalPedidos" => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function getPedidosProcesadosByTrannum(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('tpedido_model');
                $informacion = $this->tpedido_model->getPedidosProcesadosByTrannum($trannum, 'IN');
                
                $i=0;
                $itemPedidos = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $itemPedidos[$i] = array(
                            "trannum" => $info->trannum,
                            "idcentro" => $info->idcentro,
                            "trannumTraslado" => $info->nrc,
                            "nameSucursal" => $info->nameSucursal,
                            "ordenados" => $info->totalProductos * 1,
                            "despachados" => $info->totalDespachados * 1,
                            "estatus" => $info->estatus
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "dataSourcePedidos" => $itemPedidos
                );
                
                echo json_encode($array);
            }
        }
        
        function getPedidosProductosByTrannum(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                $infoProductos = $this->tpedido_model->getProductosDetalleToGrid($trannum, $idcentro);
                
                $j=0;
                $itemProductos = array();
                if($infoProductos != false){
                    foreach($infoProductos as $infoPro){
                        $itemProductos[$j] = array(
                            "idrec" => $infoPro->idrec,
                            "idproducto" => $infoPro->idproducto,
                            "descrip" => $infoPro->descrip,
                            "um" => $infoPro->um,
                            "marca" => $infoPro->marca,
                            "modelo" => $infoPro->modelo,
                            "barcode" => $infoPro->barcode,
                            "idbatch" => $infoPro->idbatch,
                            "idbin" => $infoPro->idbin,
                            "costounitario" => $infoPro->costounitario,
                            "imagen" => $infoPro->imagen,
                            "cantidad" => number_format($infoPro->cantidad, 2, '.', '') * 1,
                            "despacho" => number_format($infoPro->despachado, 2, '.', '') * 1,
                            "disponible" => (number_format($infoPro->disponible, 2, '.', '') * 1) + (number_format($infoPro->despachado, 2, '.', '') * 1),
                            "estatus" => $infoPro->estatus
                        );
                        $j++;
                    }
                }
                
                if($j != 0){
                    $j = $j - 1;
                }
                
                $array = array(
                    "dataSourceProductos" => $itemProductos,
                    "cantidadProductos" => $j
                );
                
                echo json_encode($array);
            }
        }
        
        function getProductosProcesadosByTrannum(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                $infoProductos = $this->tpedido_model->getProductosProcesadosDetalleToGrid($trannum, $idcentro);
                
                $j=0;
                $itemProductos = array();
                if($infoProductos != false){
                    foreach($infoProductos as $infoPro){
                        $itemProductos[$j] = array(
                            "idrec" => $infoPro->idrec,
                            "idproducto" => $infoPro->idproducto,
                            "descrip" => $infoPro->descrip,
                            "um" => $infoPro->um,
                            "marca" => $infoPro->marca,
                            "modelo" => $infoPro->modelo,
                            "barcode" => $infoPro->barcode,
                            "idbatch" => $infoPro->idbatch,
                            "idbin" => $infoPro->idbin,
                            "costounitario" => $infoPro->costounitario,
                            "imagen" => $infoPro->imagen,
                            "cantidad" => number_format($infoPro->cantidad, 2, '.', '') * 1,
                            "despacho" => number_format($infoPro->despachado, 2, '.', '') * 1,
                            "disponible" => (number_format($infoPro->disponible, 2, '.', '') * 1) + (number_format($infoPro->despachado, 2, '.', '') * 1),
                            "estatus" => $infoPro->estatus
                        );
                        $j++;
                    }
                }
                
                if($j != 0){
                    $j = $j - 1;
                }
                
                $array = array(
                    "dataSourceProductos" => $itemProductos,
                    "cantidadProductos" => $j
                );
                
                echo json_encode($array);
            }
        }
        
        function updateRegistroProductoDespachado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $barcode = $this->input->post('barcode');
                $um = $this->input->post('um');
                $costounitario = $this->input->post('costounitario');
                $trannum = $this->input->post('trannum');
                $trannumPedido = $this->input->post('trannumPedido');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                
                $this->tpedido_model->updateRegistroDespachado($idrec, $cantidad, $idcentro, $idbatch, $idbin, $barcode, $um, $costounitario);
                $informacion = $this->tpedido_model->getPedidosDetalleToGrid($trannum, 'IN');
                $infoProductos = $this->tpedido_model->getProductosDetalleToGrid($trannumPedido, $idcentro);
                
                $i=0;
                $itemPedidos = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $itemPedidos[$i] = array(
                            "trannum" => $info->trannum,
                            "idcentro" => $info->idcentro,
                            "nameSucursal" => $info->nameSucursal,
                            "trannumTraslado" => $info->nrc,
                            "ordenados" => $info->totalProductos * 1,
                            "despachados" => $info->totalDespachados * 1,
                            "estatus" => $info->estatus
                        );
                        $i++;
                    }
                }
                
                $j=0;
                $itemProductos = array();
                if($infoProductos != false){
                    foreach($infoProductos as $infoPro){
                        $itemProductos[$j] = array(
                            "idrec" => $infoPro->idrec,
                            "idproducto" => $infoPro->idproducto,
                            "descrip" => $infoPro->descrip,
                            "um" => $infoPro->um,
                            "marca" => $infoPro->marca,
                            "modelo" => $infoPro->modelo,
                            "barcode" => $infoPro->barcode,
                            "idbatch" => $infoPro->idbatch,
                            "idbin" => $infoPro->idbin,
                            "costounitario" => $infoPro->costounitario,
                            "imagen" => $infoPro->imagen,
                            "cantidad" => number_format($infoPro->cantidad, 2, '.', '') * 1,
                            "despacho" => number_format($infoPro->despachado, 2, '.', '') * 1,
                            "disponible" => (number_format($infoPro->disponible, 2, '.', '') * 1) + (number_format($infoPro->despachado, 2, '.', '') * 1),
                            "estatus" => $infoPro->estatus
                        );
                        $j++;
                    }
                }
                
                if($j != 0){
                    $j = $j - 1;
                }
                
                $array = array(
                    "dataSourcePedidos" => $itemPedidos,
                    "dataSourceProductos" => $itemProductos,
                    "cantidadProductos" => $j
                );
                
                echo json_encode($array);
            }
        }
        
        function cerrarPedidoToTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $trannumPedido = $this->input->post('trannumPedido');
                $fecha = $this->input->post('fecha');
                $notas = $this->input->post('notas');
                $idcentro_despacho = $this->session->userdata('idcentrouser');
                $idcentro_entrega = $this->input->post('idcentro');
                //$idclase = $this->session->userdata('idclassPedido');
                $idclase = $this->input->post('idclase');
                
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
				$reemplazar = array("", "", "", "");
				$notas = str_replace($buscar, $reemplazar, $notas);

                $this->load->model('tpedido_model'); $this->load->model('invtran_model');
                $trannumTraslado = $this->tpedido_model->cerrarPedidoToTraslado($trannum, $fecha, $notas, $idclase, $idcentro_despacho, $idcentro_entrega);
                $this->invtran_model->callTotaliza100($trannumTraslado, 1);
                
                $informacion = $this->tpedido_model->getPedidosDetalleToGrid($trannumPedido, 'IN');
                $infoProductos = $this->tpedido_model->getProductosDetalleToGrid($trannum, $idcentro_despacho);
                
                $i=0;
                $itemPedidos = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $itemPedidos[$i] = array(
                            "trannum" => $info->trannum,
                            "idcentro" => $info->idcentro,
                            "trannumTraslado" => $info->nrc,
                            "nameSucursal" => $info->nameSucursal,
                            "ordenados" => $info->totalProductos * 1,
                            "despachados" => $info->totalDespachados * 1,
                            "estatus" => $info->estatus
                        );
                        $i++;
                    }
                }
                
                $j=0;
                $itemProductos = array();
                if($infoProductos != false){
                    foreach($infoProductos as $infoPro){
                        $itemProductos[$j] = array(
                            "idrec" => $infoPro->idrec,
                            "idproducto" => $infoPro->idproducto,
                            "descrip" => $infoPro->descrip,
                            "um" => $infoPro->um,
                            "marca" => $infoPro->marca,
                            "modelo" => $infoPro->modelo,
                            "barcode" => $infoPro->barcode,
                            "idbatch" => $infoPro->idbatch,
                            "idbin" => $infoPro->idbin,
                            "costounitario" => $infoPro->costounitario,
                            "imagen" => $infoPro->imagen,
                            "cantidad" => number_format($infoPro->cantidad, 2, '.', '') * 1,
                            "despacho" => number_format($infoPro->despachado, 2, '.', '') * 1,
                            "disponible" => (number_format($infoPro->disponible, 2, '.', '') * 1) + (number_format($infoPro->despachado, 2, '.', '') * 1),
                            "estatus" => $infoPro->estatus
                        );
                        $j++;
                    }
                }
                
                if($j != 0){
                    $j = $j - 1;
                }
                
                $array = array(
                    "dataSourcePedidos" => $itemPedidos,
                    "dataSourceProductos" => $itemProductos,
                    "cantidadProductos" => $j,
                    "totalPedidos" => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function cerrarPreparacionDePedidos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $fecha = $this->input->post('fecha');
                $fechaCierre = $this->input->post('fechaCierre');
                $notas = $this->input->post('notas');
                
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
				$reemplazar = array("", "", "", "");
				$notas = str_replace($buscar, $reemplazar, $notas);

                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->cerrarPreparacionDePedidos($trannum, $fecha, $fechaCierre, $notas);
                
                echo json_encode($array);
            }
        }
        
        function adicionarPedidosToLote(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idordenes = $this->input->post('idordenes');
                
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->adicionarPedidoToLoteDePreparacion($trannum, $idordenes);
                
                echo json_encode($array);
            }
        }
        
        function eliminarPedidoDeLotePreparacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->eliminarPedidoToLoteDePreparacion($trannum);
                
                echo json_encode($array);
            }
        }
        
        function getExistenciasPedidosABodega(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $procentro = $this->input->post('procentro');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                $cantidad_pro = $this->tpedido_model->getExistenciasProcentroPB($procentro, $idproducto);
                $cantidad_cen = $this->tpedido_model->getExistenciasCentroPB($idcentro, $idproducto);
                
                $array = array(
                    "disponible" => $cantidad_cen,
                    "disprocentro" => $cantidad_pro
                );
                echo json_encode($array);
            }
        }
        
        function getInformacionCierrePreparacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('tpedido_model');
                $informacion = $this->tpedido_model->getPedidosProcesadosByTrannum($trannum, 'IN');
                
                $i=0;
                $cantidadOrdenada = 0;
                $cantidadDespachada = 0;
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $infoProductos1 = $this->tpedido_model->getProductosDetalleToGrid($info->trannum, $idcentro);
                        $infoProductos2 = $this->tpedido_model->getProductosProcesadosDetalleToGrid($info->trannum, $idcentro);
                        
                        if($infoProductos1 != false){
                            foreach($infoProductos1 as $infoPro1){
                                $cantidadOrdenada = $cantidadOrdenada + $infoPro1->cantidad * 1;
                            }
                        }
                        
                        if($infoProductos2 != false){
                            foreach($infoProductos2 as $infoPro2){
                                $cantidadDespachada = $cantidadDespachada + $infoPro2->despachado * 1;
                            }
                        }
                        $i++;
                    }
                }
                
                $array = array(
                    "cantidadPedidos" => $i,
                    "cantidadOrdenada" => $cantidadOrdenada,
                    "cantidadDespachada" => $cantidadDespachada
                );
                
                echo json_encode($array);
            }
        }

        //FuncionBusqueda
        function getDatosSearchPedidosBodega(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $dato = $this->input->post('dato');
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
                $prosearch = number_format($this->input->post('prosearch'), 0);
                
                $this->load->model('tpedido_model');
                $detalle = $this->tpedido_model->getDatosSearchPedidosBodega($prosearch, $dato, $trannum);
                if($detalle != 0){
                    $i=0; $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
                        if($info->existe == 0){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "precio" => $info->costounitario,
                                "precioventa" => $info->precioventa,
                                "agregado" => 0
                            );
                        }else{
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "precio" => $info->costounitario,
                                "precioventa" => $info->precioventa,
                                "agregado" => 1
                            );
                            $agregado=1;
                        }
                        $i++;
                    }
                    
                    if($agregado == 1 && $i == 1){
						$datos = $this->tpedido_model->getInfoProductoPedidoBodega($trannum, $info->idproducto);
						$array = array(
                            "error" => "2",
							"datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                
                echo json_encode($array);
            }
        }

        function getDataProductoPedidoBodega(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('tpedido_model');
                $array = $this->tpedido_model->getDataProductoPedidoBodega($trannum, $idproducto);
                
                echo json_encode($array);
            }
        }

        function getListadoDetalleVentasProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $procentro = $this->input->post('procentro');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('tpedido_model');
                $informacion = $this->tpedido_model->getDataProductoPedidoBodega($trannum, $idcentro, $procentro, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->existe == 0){
                            $array[$i] = array(
                                "idproducto" => $info->idproducto,
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "linea" => $info->linea,
                                "precio" => $info->costounitario,
                                "uvendidas" => $info->uvendidas,
                                "cantidad" => $info->cantidad,
                                "saldob" => $info->saldob,
                                "ordenar" => 0
                            );
                            $i++;
                        }
                    }
                }

                echo json_encode($array);
            }
        }

        function insertarProductosAnalisisGrid(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $procentro = $this->input->post('procentro');
                $nameLista = $this->input->post('nombreLista');
                $idcentro = $this->session->userdata('idcentrouser');
                $infosource = $this->input->post('infosource');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $this->load->model('tpedido_model');
                $this->tpedido_model->insertarProductosAnalisiGrid($idcentro, $trannum, $infosource);

                if($nameLista != ""){
                    $detalle = $this->tpedido_model->getInventarioByLista($trannum, $idcentro, $procentro, $nameLista);
                }else{
                    $detalle = $this->tpedido_model->getInventarioSinLista($trannum, $idcatalogo);
                }

                $datos = $this->tpedido_model->getDataOrder100k($trannum, $idcentro, $procentro);
                
                $cantidad = $this->tpedido_model->getCantidad100k($trannum);
                $unidades = $this->tpedido_model->getUnidad100k($trannum);
                
                $j=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$j] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa
                        );
                        $j++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $j,
                );
                                
                echo json_encode($array);
            }
        }
    }
?>