<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Sucursal extends CI_Controller {
        
        function __construct(){
            parent::__construct();
        }
        
        function verSucursal($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);

                $this->load->model('configuracion_model');
                $result = $this->configuracion_model->confirmarAccesoApp($idApp);
                $result == true ?: redirect('CerrarSesion');

                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'chk_active' => 0,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('sucursal_model');
                $this->load->model('global_model');
                
                $this->data['sucursales'] = $this->sucursal_model->getDataSucursales();
                $this->data['tipos'] = $this->sucursal_model->getTipo();
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);

                $this->load->view('mantenimiento_center', $this->data);
            }
        }
        
        function newSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                // $this->load->model('configuracion_model');
                // $result = $this->configuracion_model->confirmarAccesoApp($this->session->userdata('iddApp'));
                // $result == true ?: redirect('CerrarSesion');

                $idtipo = $this->uri->segment(2);
                $idSucursal_slc = array(
                    'idSucursal_slc' => $idtipo,
                    'namePage' => "Adicionar ". $this->session->userdata('appName')
                );
                $this->session->set_userdata($idSucursal_slc);
                
                $this->load->model('sucursal_model');
                $this->data['tipo_sucursal'] = $this->sucursal_model->getTipo();
                $this->data['list_encargados'] = $this->sucursal_model->getListEncargadosSuc();
                $this->data['idTipo'] = $idtipo;
                $this->load->view('new_sucursal', $this->data);
            }
        }
        
        function registrarSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{    
                $descrip = $this->input->post('nombre');
                $tipo = $this->input->post('tipo_sucursal');
                $idauxi = $this->input->post('id_encargado');
                $xpos = $this->input->post('xpos');
                $esta = $this->input->post('estado');
                $not = $this->input->post('notas');
                $notas = str_replace(array("\n", "\r", "\n\r"), " ", $not);

                $option = $this->input->post('btnCiclica');
                $whodidit = $this->session->userdata('iduser');
                
                if($esta == "true"){
                        
                    $estado = 1;
                }else{
                    $estado = 0;
                }
                $this->load->model('sucursal_model');
                $this->sucursal_model->insertSucursal($descrip, $tipo, $idauxi, $xpos, $estado, $notas, $whodidit);
                if($option == 'true'){
                    $chk_active = array(
                        'chk_active' => 1,
                    );
                    $this->session->set_userdata($chk_active);
                    redirect('Adicionar_Sucursal_O_Bodega/'.$tipo);
                }else{
                    $chk_active = array(
                        'chk_active' => 0,
                    );
                    $this->session->set_userdata($chk_active);
                    redirect('Sucursales_Y_Bodegas/'.$this->session->userdata('iddApp'));
                }
            }
        }
        
        function modificarSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{   
                $idtipo = $this->uri->segment(2);
                $idcentro = $this->uri->segment(3);
                $this->load->model('sucursal_model');
                $this->load->model('location_model');
                $this->load->model('caja_model');
                
                 $idSucursal_slc = array(
                    'idSucursal_slc' => $idtipo,
                     'namePage' => 'Modificar '.$this->session->userdata('appName').' N°'.$idcentro,
                );
                $this->session->set_userdata($idSucursal_slc);
                
                $this->data['sucursal'] = $this->sucursal_model->callRegistro($idcentro);
                $this->data['tipo_sucursal'] = $this->sucursal_model->getTipo();
                $this->data['list_encargados'] = $this->sucursal_model->getListEncargadosSuc();
                $this->data['invLocations'] = $this->location_model->getLocationsByCentro($idcentro);
                $this->data['ctCajas'] = $this->caja_model->getCajasByCentro($idcentro);
                $this->data['tipo_location'] = $this->location_model->getTipo();
                $this->load->view('form_update_sucursal', $this->data);
            }
        }
        
        function actualizarSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{  
                $idcentro = $this->input->post('idcentro');
                $descrip = $this->input->post('nombre');
                $tipo = $this->input->post('tipo_sucursal');
                $idauxi = $this->input->post('id_encargado');
                $xpos = $this->input->post('xpos');
                $esta = $this->input->post('estado');
                $notas = $this->input->post('notas');
                $whodidit = $this->session->userdata('iduser');
                
                if($esta == "true"){
                        
                    $estado = 1;
                }else{
                    $estado = 0;
                        
                }
                
                $this->load->model('sucursal_model');
                $this->sucursal_model->updateSucursal($idcentro, $descrip, $tipo, $idauxi, $xpos, $estado, $notas, $whodidit);
                
                redirect('Sucursales_Y_Bodegas/'.$this->session->userdata('iddApp'));
            }
        }
        
        function eliminarSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $this->load->model('sucursal_model');
                $array = $this->sucursal_model->deleteSucursal($idcentro);
                echo json_encode($array);
            }
        }
        
        function getListEmpleados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxi = $this->input->post('idauxi');
                $this->load->model('sucursal_model');
                $array = $this->sucursal_model->getListNamesByAuxi($idauxi);
                echo json_encode($array);
            }
        }
        
        function getListNames(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxi = $this->input->post('idauxi');
                $this->load->model('sucursal_model');
                $array = $this->sucursal_model->getListNamesByAuxi($idauxi);
                echo json_encode($array);
            }
        }
        
        function set_tipo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('Inicio');
            }else{
                $idtipo = $this->input->post('dato');
                $tipo_suc = array(
                    'tip_slc_suc' => $idtipo
                );
                $this->session->set_userdata($tipo_suc);
                $array = true;
                echo json_encode($array);
            }
        }
		
        function getSucursalesTipo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipo = $this->input->post('tipo');
                $this->load->model('sucursal_model');
                $array = $this->sucursal_model->viewSucursalActiva_Tipo($tipo);
                echo json_encode($array);
            }
        }
        
        function getInfoExistencias_Sucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $sucursales = $this->input->post('sucursales');
                $this->load->model('sucursal_model');
                $productos = $this->sucursal_model->get_Existencias_Kardex_Suc($sucursales);
                $detalle = $this->sucursal_model->get_Detalle_Existencias_Suc($sucursales);
                
                $i=0;
                $array = array();
                foreach($productos as $pro){
                    //if($pro->cantidad!=0){
                        $detail_Ubicaciones = array();
                        $j=0;
                        foreach($detalle as $det){
                            //&& $det->cantidad!=0 
                            if($det->idproducto==$pro->id){
                                $detail_Ubicaciones[$j] = array(
                                    "idproducto" => $det->idproducto,
                                    "centro" => $det->centro,
                                    "ubicacion" => $det->ubicacion,
                                    "lote" => $det->lote,
                                    "cantidad" => $det->cantidad,
                                    "idbin" => $det->idbin,
                                    "idbatch" => $det->idbatch
                                );
                                $j++; 
                            }
                        }
                        $array[$i] = array(
                            "linea" => $pro->idcatalogo,
                            //"linea" => $pro->linea,
                            "id" => $pro->id,
                            "producto" => $pro->producto,
                            "marca" => $pro->marca,
                            "modelo" => $pro->modelo,
                            "um" => $pro->um,
                            "precioventa" => $pro->precioventa,
                            "cantidad" => $pro->cantidad,
                            "idnivel1" => $pro->idnivel1,
                            "detalle" =>$detail_Ubicaciones
                        );
                        $i++;
                    //}
                }
                $suc = $this->sucursal_model->viewSucursalActiva();
                $arraySuc = explode(",", $sucursales);
                $totRig = count($arraySuc);
                $totReal = $totRig;
                $names = "";
                $tot_sucursales = 0;
                $tot_names = 0;
                $cod_sucursales = "";
                for($i=0; $i<$totReal; $i++){
                    $rest = substr($arraySuc[$i], -1);
                    if($rest!="_"){
                        foreach($suc as $sucur){
                            if($sucur->idcentro==$arraySuc[$i]){
                                $names .= $sucur->descrip.",";
                                $tot_names++;
                                $cod_sucursales .= $sucur->idcentro.",";
                            }
                            $tot_sucursales++;
                        }
                    }else{
                        $id = substr($arraySuc[$i],0,-1);
                        $cod_sucursales .= $arraySuc[$i].",";
                        foreach($suc as $sucur){
                            if($sucur->tipo==$id){
                                $names .= $sucur->descrip.",";
                                $tot_names++;
                                $cod_sucursales .= $sucur->idcentro.",";
                            }
                        }
                    }
                }
                $names =  substr($names, 0, -1);
                if($tot_sucursales>=$tot_names){
                    $names=="Totales";
                }
                //$cod_sucursales = substr($cod_sucursales,0,-1);
                $result = array(
                    'datos' => $array,
                    'names' => $names,
                    'codigos' => $cod_sucursales
                );
                echo json_encode($result);
            }
        }
        
        function tipo_selected(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $id = $this->input->post('tiposuc');
                $idsuc_sele = array(
                    'idSucursal_slc' => $id,
                );
                $this->session->set_userdata($idsuc_sele);
                echo json_encode($id);
            }
        }
        
        function getExistenciasGeneralesComplete(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipoPro = $this->input->post('tipoPro');
                $categoria = $this->input->post('categoria');
                $sucursales = $this->input->post('sucursales');
				
                $this->load->model('sucursal_model');
                $productos = $this->sucursal_model->get_Existencias_Kardex_Suc($tipoPro,$categoria,$sucursales);
                
				$i=0;
                $array = array();
                foreach($productos as $pro){
                    $totalCajas = 0;
                    if($pro->tipo != 4){
                        if($pro->upp != 0){
                            $totalCajas = $pro->cantidad / $pro->upp;
                            if($totalCajas % 1 == 0){
                                $totalCajas = number_format($totalCajas);
                            }else{
                                $totalCajas = number_format($totalCajas, 2, '.', '');
                            }
                        }
                    }
					
                    $array[$i] = array(
                        "linea" => $pro->linea,
                        "departamento" => $pro->departamento,
                        "proveedor" => $pro->proveedor,
                        "id" => $pro->id,
                        "producto" => $pro->producto,
                        "marca" => $pro->marca,
                        "xpos" => $pro->xpos,
                        "modelo" => $pro->modelo,
                        "um" => $pro->um,
                        "upp" => $pro->upp,
                        "cajas" => $totalCajas,
                        "imagen" => $pro->imagen,
                        "precioventa" => $pro->precioventa,
                        "barcode" => $pro->barcode,
                        "costounitario" => $pro->costounitario,
                        "cantidad" => round($pro->cantidad,4),
                        "idnivel1" => $pro->idnivel1,
                        //"detalle" => $detail_Ubicaciones[],
                        "abrir" => 1
                    );
                    $i++;
                }
                
				echo json_encode($array);
            }
        }

        function getDetallePopupKardex(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipo = $this->input->post('tipoPro');
                $categoria = $this->input->post('categoria');
                $sucursales = $this->input->post('sucursales');
                $idproducto = $this->input->post('idproducto');
				
                $this->load->model('sucursal_model');
                $detalle = $this->sucursal_model->getDetalleExistenciasUbicacionesProducto($tipo,$categoria,$sucursales,$idproducto);
                
                $i=0;
                $array = array();
                foreach($detalle as $det){
                    $array[$i] = array(
                        "idproducto" => $det->idproducto,
                        "fcompra" => $det->fcompra,
                        "dias_lote" => $det->dias_lote,
                        "producto" => $det->producto,
                        "centro" => $det->centro,
                        "ubicacion" => $det->ubicacion,
                        "lote" => $det->lote,
                        "cantidad" => round($det->cantidad,2),
                        "idbin" => $det->idbin,
                        "idbatch" => $det->idbatch,
                        "abrir" => 0,
                        "marca" => $det->marca,
                        "modelo" => $det->modelo,
                        "xpos" => $det->xpos,
                        "um" => $det->um,   
                        "imagen" => $det->imagen,
                        "barcode" => $det->barcode,
                    );
                    $i++;
                }

                echo json_encode($array);
            }
        }
        //------------------------------------------------------------------------  SUCURSALES Y CENTROS --------------------------------------------------------------------------------------
        function verSucursalN($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);

                $this->load->model('configuracion_model');
                $result = $this->configuracion_model->confirmarAccesoApp($idApp);
                $result == true ?: redirect('CerrarSesion');

                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'chk_active' => 0,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('sucursal_model');
                $this->load->model('global_model');
                $this->load->model('user_model');
                
                $this->data['TSucursales'] = $this->sucursal_model->getTiposSucursales();
                //$this->data['Datos'] = $this->sucursal_model->getSucursalesCajasUbicaciones(-1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['userProfileAndRights'] = $this->user_model->getProfileAndRights();

                $this->load->view('mantenimiento_sucursal', $this->data);
            }
        }
        #   GET SUCURSALES CAJAS Y UBICACIONES
        public function getSucursalesCajasUbicaciones()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $Tipo = $this->input->post("tipo");
                $this->load->model('sucursal_model');
                $datos = $this->sucursal_model->getSucursalesCajasUbicaciones($Tipo);
                echo json_encode($datos);
            }
        }
        #   GET INFORMACIÓN DATA
        public function getData()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $TipoData = $this->input->post("tipoDato");
                $this->load->model('sucursal_model');
                $this->load->model('cliente_model');
                $deptos = $this->cliente_model->getData(1);
                switch ($TipoData) {
                    #   TO SUCURSALES
                    case 1:
                        if ($encargados = $this->sucursal_model->getData(1)) {
                            $Datos = [];
                            if ($encargados->num_rows() > 0) {
                                foreach ($encargados->result() as $dato) {
                                    $Datos[] = array(
                                        'ID' => (int)$dato->id,
                                        'Name' => $dato->descrip,
                                        'Tipo' => $dato->tipo
                                    );
                                }
                            }
                            if ($deptos->num_rows() > 0) {
                                foreach ($deptos->result() as $dato) {
                                    $Datos1[] = array(
                                        'ID' => $dato->idzip,
                                        'Name' => $dato->municipio,
                                        'Departamento' => $dato->depto
                                    );
                                }
                            }
                            if ($ID = $this->input->post("ID")) {
                                if ($dato = $this->sucursal_model->getSucursal($ID)) {
                                    $datA[] = array('valido' => true);
                                    $datA[] = array(
                                        'managers' => $Datos,
                                        'dato' => $this->ConvertDataSLC($dato, 1, $Datos1)
                                    );                                    
                                } else $datA[] = array('valido' => false, 'error' => 1);
                            } else {
                                $datA[] = array('valido' => true);
                                $datA[] = array(
                                    'managers' => $Datos,
                                    'deptos' => $Datos1
                                );
                            }
                        } else $datA[] = array('valido' => false, 'error' => 0);
                    break;
                    #   TO UBICACIONES
                    case 2:
                        if ($tips = $this->sucursal_model->getData(2)) {
                            $Datos = [];
                            if ($tips->num_rows() > 0) {
                                foreach ($tips->result() as $dato) {
                                    $Datos[] = array(
                                        'ID' => (int)$dato->id,
                                        'Name' => $dato->descrip
                                    );
                                }
                            }
                            if ($ID = $this->input->post("ID")) {
                                if ($dato = $this->sucursal_model->getLocation($ID)) {
                                    $datA[] = array('valido' => true);
                                    $datA[] = array(
                                        'tips' => $Datos,
                                        'dato' => $this->ConvertDataSLC($dato, 2)
                                    );
                                } else $datA[] = array('valido' => false, 'error' => 1);
                            } else {
                                $datA[] = array('valido' => true);
                                $datA[] = array(
                                    'tips' => $Datos
                                );
                            }
                        } else $datA[] = array('valido' => false, 'error' => 0);
                    break;
                    #   TO CAJAS
                    case 3:
                        $ID = $this->input->post('ID');
                        if ($dato = $this->sucursal_model->getCaja($ID)) {
                            $datA[] = array('valido' => true);
                            $datA[] = array(
                                'dato' => $this->ConvertDataSLC($dato, 3)
                            );
                        } else $datA[] = array('valido' => false, 'error' => 1);
                    break;
                }
                echo json_encode($datA);
            }
        }
        #   CONVERSION DE DATOS SUCURSAL UBICACION Y CAJA
        public function ConvertDataSLC($dato, $tipo, $Datos = array())
        {
            switch ($tipo) {
                #   SUCURSAL
                case 1:
                    $Dato = array(
                        'ID' => (int)$dato->idcentro,
                        'Descripcion' => $dato->descrip,
                        'codEstablecimientoMh' => $dato->codigomh,
                        'encargado' => (int)$dato->idcps,
                        'xpos' => $dato->xpos,
                        'direccion' => $dato->direccion,
                        'deptos' => $Datos,
                        'telefono' => $dato->telefono,
                        'idzip' => $dato->idzip,
                        'notas' => $dato->notas,
                        'estado' => (int)$dato->estatus,
                        'tip' => (int)$dato->tipo
                    );
                break;
                #   UBICACION
                case 2:
                    $Dato = array(
                        'ID' => (int)$dato->idbin,
                        'Descripcion' => $dato->descrip,
                        'tip' => (int)$dato->tipo,
                        'xpos' => $dato->xpos,
                        'notas' => $dato->notas,
                        'estado' => (int)$dato->estatus
                    );
                break;
                #   CAJA
                case 3:
                    $Dato = array(
                        'ID' => (int)$dato->idcaja,
                        'Descripcion' => $dato->descrip,
                        'codPuntoVentaMh' => $dato->codigomh,
                        'cuadre' => (int)$dato->ucajera,
                        'fi' => $dato->bfecha,
                        'ff' => $dato->efecha,
                        'fondo' => $dato->cajafondo,
                        'nautor' => $dato->resolucion,
                        'fautor' => $dato->fresolucion,
                        'detalle' => $dato->equipo,
                        'xpos' => $dato->xpos,
                        'notas' => $dato->notas,
                        'estado' => (int)$dato->estatus
                    );
                break;
            }
            return $Dato;
        }
        #   SET SUCURSAL
        public function setSucursal()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('sucursal_model');
                $this->load->model('cliente_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $data = array(
                    'descrip' => $this->input->post('nombre'),
                    'codigomh' => $this->input->post('codEstablecimientoMh'),
                    'tipo' => $Tipo,
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),
                    'direccion' => $this->input->post('direccion'),
                    'idzip' => (int)$this->input->post("departamento"),
                    'telefono' => $this->input->post('telefono'),
                    'idcps' => (int)$this->input->post('encargado'),
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($IDC = $this->sucursal_model->setSucursal($data)) {
                    $data = array(
                        'idcentro' => $IDC,
                        'descrip' => 'UBICACIÓN PREDETERMINADO',
                        'estatus' => 1,
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->sucursal_model->setLocation($data)) {
                        $datos = $this->sucursal_model->getSucursalesCajasUbicaciones($Tipo);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else $datA[] = array('valido' => false, 'tipo' => 2);
                } else $datA[] = array('valido' => false, 'tipo' => 1);
                echo json_encode($datA);
            }
        }
        #   UPDATE SUCURSAL
        public function updateSucursal()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('sucursal_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $ID = (int)$this->input->post("ID");
                $data = array(
                    'descrip' => $this->input->post('nombre'),
                    'codigomh' => $this->input->post('codEstablecimientoMh'),
                    'tipo' => (int)$this->input->post('idtip'),
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),
                    'direccion' => $this->input->post('direccion'),
                    'idzip' => trim($this->input->post("departamento")),
                    'telefono' => $this->input->post('telefono'),
                    'idcps' => (int)$this->input->post('encargado'),
                    'whodidit' => $this->session->userdata('iduser'),
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->sucursal_model->updateSucursalN($data, $ID)) {
                    $datos = $this->sucursal_model->getSucursalesCajasUbicaciones($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => 0);
                echo json_encode($datA);
            }   
        }

        public function updateSucursalNew()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('sucursal_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $ID = (int)$this->input->post("ID");
                $conteo = (int)$this->input->post("conteo");
                $dato = $this->sucursal_model->getSucursal($ID);
                if ($conteo > 0) {
                        $size = $_FILES['Archivo']['size'];
                        $ext = $_FILES['Archivo']['name'];
                        if (trim(strlen($dato->imagen)) > 0) {
                            $nombreActual = explode(".", $dato->imagen)[0];
                            if (strlen($nombreActual) > 0) $nombreold = $nombreActual;
                            //else $nombreold = $this->getUpdateNameImagen(pathinfo($ext, PATHINFO_EXTENSION), $tipo);
                        } //else $nombreold = $this->getUpdateNameImagen(pathinfo($ext, PATHINFO_EXTENSION), $tipo);
                        $nombrei = $nombreold.".".pathinfo($ext, PATHINFO_EXTENSION);
        
                        $config['upload_path']= "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $config['file_name'] = '123'.$nombrei;
                        $config['max_size'] = 200;
                        $this->load->library('upload',$config);
                        if ($this->upload->do_upload('Archivo')) {
                            $a = $this->upload->data();
                            $sen = true;
                        } else {
                            $sen = false;
                            $error = $this->upload->display_errors();
                            if (($size / 1024) > 200) $error = 'sizeImagen';
                        }
                    } else {
                        $nombrei = "".$dato->imagen;
                        $sen = true;
                    }
                $data = array(
                    'descrip' => $this->input->post('nombre'),
                    'tipo' => (int)$this->input->post('idtip'),
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),
                    'direccion' => $this->input->post('direccion'),
                    'telefono' => $this->input->post('telefono'),
                    'idcps' => (int)$this->input->post('encargado'),
                    'whodidit' => $this->session->userdata('iduser'),
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                    'imagen' => $nombrei,
                );
                if ($this->sucursal_model->updateSucursalN($data, $ID)){
                    $datos = $this->sucursal_model->getSucursalesCajasUbicacionesNew($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => 0);
                echo json_encode($datA);
            }   
        }
        #   BORRAR SUCURSAL
        public function delSucursal()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('sucursal_model');
                $Tipo = (int)$this->input->post("IDTipo");
                $ID = $this->input->post('ID');
                $valido = $this->sucursal_model->hasTransaccion(1, $ID);
                //print_r(array('vali' => $valido));
                if ($valido == 0) {
                    $this->sucursal_model->byeRegistro(1, $ID);
                    $datos = $this->sucursal_model->getSucursalesCajasUbicaciones($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => $valido);
                echo json_encode($datA);
            }
        }
        #   SET LOCACION
        public function setLocation()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('sucursal_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $data = array(
                    'idcentro' => (int)$this->input->post('IDCentro'),
                    'descrip' => $this->input->post('nombre'),
                    'tipo' => (int)$this->input->post('tip'),
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->sucursal_model->setLocation($data)) {
                    $datos = $this->sucursal_model->getSucursalesCajasUbicaciones($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => 1);
                echo json_encode($datA);
            }
        }
        #   UPDATE LOCACION
        public function updateLocation()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('sucursal_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $ID = (int)$this->input->post("ID");
                $data = array(
                    'descrip' => $this->input->post('nombre'),
                    'tipo' => (int)$this->input->post('tip'),
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),
                    'whodidit' => $this->session->userdata('iduser'),
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->sucursal_model->updateLocation($data, $ID)) {
                    $datos = $this->sucursal_model->getSucursalesCajasUbicaciones($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => 0);
                echo json_encode($datA);
            }
        }
        #   BORRAR LOCACION
        public function delLocation()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('sucursal_model');
                $Tipo = (int)$this->input->post("IDTipo");
                $ID = $this->input->post('ID');
                $valido = $this->sucursal_model->hasTransaccion(2, $ID);
                if ($valido == 0) {
                    $this->sucursal_model->byeRegistro(2, $ID);
                    $datos = $this->sucursal_model->getSucursalesCajasUbicaciones($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => 1);
                echo json_encode($datA);
            }
        }
        #   SET CAJA
        public function setCaja()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('sucursal_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $data = array(
                    'idcentro' => (int)$this->input->post('IDCentro'),
                    'descrip' => $this->input->post('nombre'),
                    'codigomh' => $this->input->post('codPuntoVentaMh'),
                    'ucajera' => ($this->input->post('cuadre') == 'true') ? 1 : 0,
                    'bfecha' => $this->input->post('fi'),
                    'efecha' => $this->input->post('ff'),
                    'cajafondo' => $this->input->post('fondo'),
                    'resolucion' => $this->input->post('nautor'),
                    'fresolucion' => $this->input->post('fautor'),
                    'equipo' => $this->input->post('detalle'),
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->sucursal_model->setCaja($data)) {
                    $datos = $this->sucursal_model->getSucursalesCajasUbicaciones($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => 1);
                echo json_encode($datA);
            }
        }
        #   UPDATE CAJA
        public function updateCaja()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('sucursal_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $ID = $this->input->post('ID');
                $data = array(
                    'descrip' => $this->input->post('nombre'),
                    'codigomh' => $this->input->post('CodPuntoVentaMh'),
                    'ucajera' => ($this->input->post('cuadre') == 'true') ? 1 : 0,
                    'bfecha' => $this->input->post('fi'),
                    'efecha' => $this->input->post('ff'),
                    'cajafondo' => $this->input->post('fondo'),
                    'resolucion' => $this->input->post('nautor'),
                    'fresolucion' => $this->input->post('fautor'),
                    'equipo' => $this->input->post('detalle'),
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),
                    'whodidit' => $this->session->userdata('iduser'),
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->sucursal_model->updateCaja($data, $ID)) {
                    $datos = $this->sucursal_model->getSucursalesCajasUbicaciones($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => 1);
                echo json_encode($datA);
            }
        }
        #   BORRAR CAJA
        public function delCaja()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('sucursal_model');
                $Tipo = (int)$this->input->post("IDTipo");
                $ID = $this->input->post('ID');
                $valido = $this->sucursal_model->hasTransaccion(3, $ID);
                if ($valido == 0) {
                    $this->sucursal_model->byeRegistro(3, $ID);
                    $datos = $this->sucursal_model->getSucursalesCajasUbicaciones($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => 1);
                echo json_encode($datA);
            }
        }

        #   GET NOMBRE DE IMAGEN PARA SUCURSAL QUE NO TENIA
        private function getUpdateNameImagen($ext, $tipo)
        {
            $valor = '';
            do {
                $conteo = $this->sucursal_model->getContImage($tipo);
                $valor = "imgProduct"."_".$conteo."_".rand(10,1000).".".$ext;
            } while (!$this->sucursal_model->validateNameImage($valor, $tipo));
            return explode(".", $valor)[0];
        }

        function verCentrosCosto($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);

                $this->load->model('configuracion_model');
                $result = $this->configuracion_model->confirmarAccesoApp($idApp);
                $result == true ?: redirect('CerrarSesion');

                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'chk_active' => 0,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('sucursal_model');
                $this->load->model('global_model');
                
                $this->data['TSucursales'] = $this->sucursal_model->getTiposSucursales();
                //$this->data['Datos'] = $this->sucursal_model->getSucursalesCajasUbicaciones(-1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);

                $this->load->view('mantenimiento_centrocosto', $this->data);
            }
        }

        public function getCentrosCosto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {                
                $this->load->model('sucursal_model');
                $datos = $this->sucursal_model->getCentrosCosto();
                $resultado = [];

                if($datos){
                    foreach($datos as $dato){
                        $tipoSuc = $this->sucursal_model->getTipoById($dato["tipo"]);
                        $resultado[] = array(
                            "idcentro" => $dato["idcentro"],
                            "descrip" => $dato["descrip"],
                            "xpos" => $dato["xpos"],
                            "estatusTxt" => ($dato["estatus"] == 1) ? 'Activo' : 'Inactivo',
                            "estatus" =>$dato["estatus"],
                            "tipo" => $dato["tipo"],
                            "tipoTxt" => $tipoSuc['descripcion'],
                            "notas" => $dato["notas"],

                        );
                    }   
                }
                echo json_encode($resultado);
            }
        }

        public function setCentroCosto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {    
                $descrip = trim($this->input->post("descrip"));
                $tipo = $this->input->post("tipo");
                $xpos = $this->input->post("xpos");
                $notas = $this->input->post("notas");
                $estatus = ($this->input->post('estado') == "true") ? 1 : 0;
                
                $this->load->model('sucursal_model');

                $existeDescrip = $this->sucursal_model->verificarDescripCentrosCosto($descrip);
                if($existeDescrip){
                    echo json_encode(["resultado" => false, "mensaje" => "¡Error! El nombre del centro de costo ingresado ya ha sido registrado previamente."]);
                    return false;
                }


                $resultado = $this->sucursal_model->setCentroCosto($descrip, $tipo, $xpos, $notas, $estatus);
                $mensaje = '';
                if($resultado){
                    $mensaje = "¡Se ha adicionado el centro de costo con éxito!";
                }else{
                    $mensaje = "Hubo un error inesperado al adicionar el centro de costo.";

                }
                echo json_encode(["resultado" => $resultado, "mensaje" => $mensaje]);
            }
        }

        public function updateCentroCosto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {    
                $idcentro = $this->input->post("idcentro");
                $descrip = trim($this->input->post("descrip"));
                $tipo = $this->input->post("tipo");
                $xpos = $this->input->post("xpos");
                $notas = $this->input->post("notas");
                $estatus = ($this->input->post('estado') == "true") ? 1 : 0;
                
                $this->load->model('sucursal_model');

                $existeDescrip = $this->sucursal_model->verificarDescripCentrosCosto($descrip, $idcentro);
                if($existeDescrip){
                    echo json_encode(["resultado" => false, "mensaje" => "¡Error! El nombre del centro de costo ingresado ya ha sido registrado previamente."]);
                    return false;
                }

                $resultado = $this->sucursal_model->updateCentroCosto($idcentro, $descrip, $tipo, $xpos, $notas, $estatus);
                $mensaje = '';
                if($resultado){
                    $mensaje = "¡Se ha modificado el centro de costo con éxito!";
                }else{
                    $mensaje = "Hubo un error inesperado al modificar el centro de costo.";

                }
                echo json_encode(["resultado" => $resultado, "mensaje" => $mensaje]);
            }
        }

        public function deleteCentroCosto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {    
                $idcentro = $this->input->post("idcentro");
                
                $this->load->model('sucursal_model');

                $ocupaCentro = $this->sucursal_model->verificarTransaccionesCentrosCosto($idcentro);
                if($ocupaCentro){
                    echo json_encode(["resultado" => false, "mensaje" => "¡Error! No se puede eliminar este registro ya que posee movimientos contables."]);
                    return false;
                }

                $resultado = $this->sucursal_model->deleteCentroCosto($idcentro);
                $mensaje = '';

                if($resultado){
                    $mensaje = "¡Se ha eliminado el centro de costo con éxito!";
                }else{
                    $mensaje = "Hubo un error inesperado al eliminar el centro de costo.";
                }

                echo json_encode(["resultado" => $resultado, "mensaje" => $mensaje]);
            }
        }
        //------------------------------------------------------------------------  FIN SUCURSALES Y CENTROS ----------------------------------------------------------------------------------
    }
?>