<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    require 'vendor/autoload.php';
                        
    use Firebase\JWT\JWT;
    class Scan extends CI_Controller {
        
        function __construct(){
            parent::__construct();
            date_default_timezone_set('America/El_Salvador');
        }
        private $Estados = array(
            'En Proceso' => 0,
            'Cerrado' => 1,
            'Anulado' => 9,
        );
        private $SJopciones = [
            array('ID' => 1, 'Name' => 'Código de Barra', 'valor' => false, 'v' => 'barcode', 'ncampo' => true),
            array('ID' => 2, 'Name' => 'Código Interno', 'valor' => false, 'v' => 'idproducto', 'ncampo' => true),
            array('ID' => 3, 'Name' => 'Código Xpos', 'valor' => false, 'v' => 'xpos', 'ncampo' => false),
            array('ID' => 4, 'Name' => 'Modelo', 'valor' => false, 'v' => 'modelo', 'ncampo' => false),
        ];
        private $SIopciones = [
            array('ID' => 1, 'Name' => 'Descripción', 'valor' => false, 'v' => 'descrip', 'ncampo' => false, 'int' => false),
            array('ID' => 2, 'Name' => 'Código Interno', 'valor' => false, 'v' => 'idproducto', 'ncampo' => true, 'int' => true),
            array('ID' => 3, 'Name' => 'Código de Barra', 'valor' => false, 'v' => 'barcode', 'ncampo' => true, 'int' => false),
            array('ID' => 4, 'Name' => 'Código Xpos', 'valor' => false, 'v' => 'xpos', 'ncampo' => false, 'int' => false),
            array('ID' => 5, 'Name' => 'Modelo', 'valor' => false, 'v' => 'modelo', 'ncampo' => false, 'int' => false),
            array('ID' => 6, 'Name' => 'Marca', 'valor' => false, 'v' => 'marca', 'ncampo' => false, 'int' => false),
        ];
        private $opcionesSpecial = [
            array('ID' => 1, 'Name' => 'Descripción', 'v' => 'descrip'),
            array('ID' => 2, 'Name' => 'Marca', 'v' => 'marca'),
            array('ID' => 3, 'Name' => 'Modelo', 'v' => 'modelo'),
            array('ID' => 4, 'Name' => 'Código Xpos', 'v' => 'xpos'),
        ];

        //tipos de proceso para goxscan
        private $arrayTipoProcesos = [
            array("id"=>1, "value"=>"Recuento Físico"),
            array("id"=>2, "value"=>"Recepción de Compra"),
            array("id"=>3, "value"=>"Envío a Sucursal"),
            array("id"=>4, "value"=>"Ordenes de Venta"),
            array("id"=>5, "value"=>"Validación de Inventario"),
            array("id"=>6, "value"=>"Cambios de Precio")
        ];

        private function validatePermiso() {
            $permiso = true;
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || !$permiso) redirect('CerrarSesion');
            else return true;
        }

        private $secretKey = 'AggE$26648';
        
        #   SCAN JOB NEW
        public function indexScanjob($idApp)
        {
            if ($this->validatePermiso()) {
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' =>$appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
				$controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['opcsbusqueda'] = $this->SJopciones;
                $this->data['factual'] = date_create()->format('Y-m-d');
                $this->load->view('mantenimiento_scanjobN', $this->data);
            }
        }
        #   SCAN JOB DETALLE
        public function indexSJDetalle($IDSJ)
        {
            if ($this->validatePermiso()) {
                if (is_numeric($IDSJ)) {
                    $this->load->model('scan_model');
                    $this->load->model('global_model');
                    if ($dato = $this->conversion(2, (int)$IDSJ)){
                        $resultAppName = array(
                            'namePage' => 'Detalle de '.$this->session->userdata('appName')
                        );
                        $controlador = $this->uri->segment(1);

                        $this->session->set_userdata($resultAppName);
                        $this->data['dato'] = $dato;
                        $this->data['opcsbusqueda'] = $this->SJopciones;
                        $this->data['opcsbusquedaSpecial'] = $this->opcionesSpecial;
                        $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                        $this->load->view('mantenimiento_scanjobNDetalle', $this->data);
                    } else echo "<h1>Scan Job No Encontradp</h1>";
                } else echo "<h1>Falta Parámetro Númerico</h1>";
            }
        }
        #   SKU INFO
        public function indexSkuinfo($idApp)
        {
            if ($this->validatePermiso()) {
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' =>$appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
				$controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['opcsbusqueda'] = $this->SIopciones;
                $this->load->view('mantenimiento_SkuInfo', $this->data);
            }
        }
        #   MULTIPLES OPCIONES
        public function multiOpciones()
        {
            if ($this->validatePermiso()) {
                $this->load->model('scan_model');
                $opcion = (int)$this->input->post('opcion');
                switch ($opcion) {
                    #   SCAN JOB
                    case 1:#    GET SCAN'S
                        $idcentro = (int)$this->input->post('centro');
                        $Datos = $this->conversion(1, $idcentro);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case 2:#    GET SUCURSALES
                        $Datos = [];
                        $datos = $this->scan_model->multiOpciones(2);
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                $Datos[] = array(
                                    'ID' => $dato->idcentro,
                                    'Name' => trim($dato->descrip)
                                );
                            }
                        }
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case 3:#    SET SCAN
                        $data = array(
                            'idcentro' => (int)$this->input->post('centro'),
                            'agrupa' => 'SJ',
                            'fecha' => $this->input->post('fecha'),
                            'nrc' => $this->input->post('capturar'),
                            'estatus' => 0,
                            'descrip' => trim($this->input->post('notas')),
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                        );
                        if ($SJ = $this->scan_model->multiOpciones(3, ['tbl' => 'orders_100', 'data' => $data])) $datA[] = array('valido' => true, 'sj' => $SJ);
                        else $datA[] = array('valido' => false);
                    break;
                    #   DETALLE
                    case 4:#    GET REGISTROS SCAN
                        $IDSJ = (int)$this->input->post('idsj');
                        $Datos = $this->conversion(3, $IDSJ);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case 5:#    SEARCH
                        $IDSJ = (int)$this->input->post('idsj');
                        $idcentro = (int)$this->input->post('idcentro');
                        $campo = (int)$this->input->post('campo');
                        $campo = array_search($campo, array_column($this->SJopciones, 'ID', 'v'));
                        $valor = $this->input->post('valor');
                        $texto = 'Producto no encontrado!';

                        $where = implode(' AND ', [
                            '('.$campo.' = "'.$valor.'")',
                            '((tipo = 1) OR (tipo = 2))',
                            '(estado = 1)'
                        ]);
                        $dato = $this->scan_model->multiOpciones(8, ['w' => $where, 'tbl' => 'invproducts']);//*/
                        //$dato = $this->scan_model->multiOpciones(8, ['campo' => $campo, 'ID' => $valor, 'tbl' => 'invproducts']);
                        $cfound = (count((array)$dato) > 0) ? true : false;
                        if (!$cfound) {
                            if ($campo == 'barcode') {
                                $where = implode(' AND ', [
                                    '((a.tipo = 1) OR (a.tipo = 2))',
                                    '(a.estado = 1)',
                                    '(b.idgvar = 2)',
                                    '(b.descrip = "'.$valor.'")'
                                ]);
                                $dato = $this->scan_model->multiOpciones(7, $where);
                            }
                        }
                        $cfound = (count((array)$dato) > 0) ? true : false;
                        if ($cfound) {
                            $permisoInv = $this->scan_model->multiOpciones(10, ['idp' => $dato->idproducto, 'idc' => $idcentro]);
                            $dato->pinv = $permisoInv;
                            if ($permisoInv !== false) {
                                $texto = trim($dato->descrip).'||'.number_format((float)$permisoInv, 2, '.', '').' '.trim($dato->um);
                                #   SEARCH SCAN
                                $where = implode(' AND ', [
                                    '(trannum = '.$IDSJ.')',
                                    '(idproducto = '.$dato->idproducto.')'
                                ]);
                                $dato->scan = $this->scan_model->multiOpciones(8, ['w' => $where, 'tbl' => 'orders_100k']);
                            } else {
                                $cfound = false;
                                $texto = 'Producto no ha sido ingresado a inventario en la Sucursal!';
                            }
                        }
                        $datA[] = array('valido' => $cfound, 'valor' => $texto, 'producto' => $dato);
                    break;
                    case 6:#    SET-UPDATE SEARCH
                        $IDSJ = (int)$this->input->post('idsj');
                        $ID = (int)$this->input->post('idscan');
                        $cantidad = (float)$this->input->post('cantidad');
                        $data = array(
                            'trannum' => $IDSJ,
                            'itemline' => $this->scan_model->multiOpciones(9, $IDSJ),
                            'idproducto' => (int)$this->input->post('idp'),
                            'cantidad' => $cantidad,
                            'notas' => date_create()->format('Y-m-d H:i:s').','.$cantidad,
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                        );
                        $proceso = false;
                        if ($ID == 0) {
                            $proceso = $this->scan_model->multiOpciones(3, ['data' => $data, 'tbl' => 'orders_100k']);
                        } else {
                            $data['modifica'] = $data['ingresa'];
                            $datold = $this->scan_model->multiOpciones(4, ['campo' => 'idrec', 'ID' => $ID, 'tbl' => 'orders_100k']);

                            $notas = $datold->notas;
                            if (strlen(trim($notas)) > 0) {
                                $notas = explode("\n", $notas);
                                $notas[] = $data['notas'];
                                $notas = implode("\n", $notas);
                            } else $notas = $data['notas'];

                            $data['cantidad'] = (float)$datold->cantidad + $cantidad;
                            $data['notas'] = $notas;

                            unset($data['ingresa']);
                            unset($data['itemline']);
                            $proceso = $this->scan_model->multiOpciones(5, ['campo' => 'idrec', 'ID' => $ID, 'data' => $data, 'tbl' => 'orders_100k']);
                        }
                        //print_r($data);
                        if ($proceso) {
                            $Datos = $this->conversion(3, $IDSJ);
                            $datA[] = array('valido' => true, 'datos' => $Datos);
                        } else $datA[] = array('valido' => false, 'texerror' => (($ID == 0) ? 'Error al Ingresar' : 'Error al Actualizar'));
                    break;
                    case 7:#    DELETE SCAN-REGISTRO
                        $IDSJ = (int)$this->input->post('idsj');
                        $ID = (int)$this->input->post('idscan');
                        $this->scan_model->multiOpciones(12, implode(' AND ', [
                            '(idproducto = '.$ID.')',
                            '(trannum = '.$IDSJ.')'
                        ]));
                        $Datos = $this->conversion(3, $IDSJ);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case 8:#    ACTUALIZAR SCAN
                        $IDSJ = (int)$this->input->post('idsj');
                        $estado = (int)$this->input->post('estado');
                        $data = array(
                            'estatus' => $estado,
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        if ($estado == 1) $data['fecact'] = date_create()->format('Y-m-d');
                        if ($this->scan_model->multiOpciones(5, ['campo' => 'trannum', 'ID' => $IDSJ, 'tbl' => 'orders_100', 'data' => $data])) $datA[] = array('valido' => true);
                        else $datA[] = array('valido' => false);
                    break;
                    case 9:#    SEARCH MULTIS
                        $IDSJ = (int)$this->input->post('idsj');
                        $idcentro = (int)$this->input->post('idcentro');
                        $campo = (int)$this->input->post('campo');
                        $campo = array_search($campo, array_column($this->opcionesSpecial, 'ID', 'v'));
                        $valor = $this->input->post('valor');

                        $where = implode(' AND ', [
                            '(a.'.$campo.' like "%'.$valor.'%")',
                            '((a.tipo = 1) OR (a.tipo = 2))',
                            '(a.estado = 1)',
                            '(b.idcentro = '.$idcentro.')',
                        ]);
                        $datos = $this->scan_model->multiOpciones(13, $where);
                        $Datos = [];
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                #   SEARCH SCAN
                                $where = implode(' AND ', [
                                    '(trannum = '.$IDSJ.')',
                                    '(idproducto = '.$dato->idproducto.')'
                                ]);
                                $dato->scan = $this->scan_model->multiOpciones(8, ['w' => $where, 'tbl' => 'orders_100k']);
                                $dato->pinv = number_format((float)$dato->pinv, 2, '.', '');
                                $Datos[] = (array)$dato;
                            }
                        }
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    #   SKU INFO
                    case 10:
                        $this->load->model('invtran_model');
                        $campo = (int)$this->input->post('campo');
                        $ncampo = (object)$this->SIopciones[array_search($campo, array_column($this->SIopciones, 'ID'))];
                        $campo = $ncampo->v;
                        $valor = $this->input->post('valor');
                        $Datos = [];

                        switch ($campo) {
                            case 'idproducto':
                                $dato = $this->scan_model->multiOpciones(4, ['campo' => $campo, 'ID' => (int)$valor, 'tbl' => 'invproducts']);
                                if (count((array)$dato) > 0) {
                                    $Datos[] = (array)$this->conversion(4, $dato);
                                }
                            break;
                            case 'barcode':
                                $where = implode(' AND ', [
                                    '('.$campo.' = "'.$valor.'")',
                                    '((tipo = 1) OR (tipo = 2))',
                                    '(estado = 1)'
                                ]);
                                $dato = $this->scan_model->multiOpciones(8, ['w' => $where, 'tbl' => 'invproducts']);//*/
                                $pfound = (count((array)$dato) > 0) ? true : false;
                                if (!$pfound) {
                                    $where = implode(' AND ', [
                                        '((a.tipo = 1) OR (a.tipo = 2))',
                                        '(a.estado = 1)',
                                        '(b.idgvar = 2)',
                                        '(b.descrip = "'.$valor.'")'
                                    ]);
                                    $dato = $this->scan_model->multiOpciones(7, $where);
                                    $pfound = (count((array)$dato) > 0) ? true : false;
                                }

                                if ($pfound) {
                                    $Datos[] = (array)$this->conversion(4, $dato);
                                }
                            break;
                            default:
                                $where = implode(' AND ', [
                                    '('.$campo.' like "%'.$valor.'%")',
                                    '((tipo = 1) OR (tipo = 2))',
                                    '(estado = 1)'
                                ]);
                                $datos = $this->scan_model->multiOpciones(14, $where);
                                if ($datos->num_rows() > 0) {
                                    foreach ($datos->result() as $dato) {
                                        $Datos[] = (array)$this->conversion(4, $dato);
                                    }
                                }//*/
                            break;
                        }
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    default:$datA[] = array('valido' => false);break;
                }
                echo json_encode($datA);
            }
        }
        private function conversion($opc, $extra = null)
        {
            $Datos = [];
            switch ($opc) {
                case 1:#    GET SCAN'S
                    $datos = $this->scan_model->multiOpciones(1, $extra);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $Datos[] = array(
                                'key' => $dato->trannum,
                                'titulo' => $dato->descrip,
                                'sucursal' => $dato->sucursal,
                                'fecha' => $dato->fecha,
                                'fechash' => date_create($dato->fecha)->format('d/m/Y'),
                                'estado' => array_search($dato->estatus, $this->Estados),
                            );
                        }
                    }
                break;
                case 2:#   CONVERT SCAN
                    $dato = $this->scan_model->multiOpciones(4.5, $extra);
                    if (count((array)$dato) > 0) {
                        $Datos = (object)array(
                            'trannum' => $dato->trannum,
                            'idcentro' => $dato->idcentro,
                            'sucursal' => $dato->sucursal,
                            'sdefault' => $dato->referencia,
                            'fecha' => $dato->fecha,
                            'fechav' => date_create($dato->fecha)->format('d/m/Y'),
                            'idestado' => (int)$dato->estatus,
                            'observaciones' => $dato->descrip,
                            'capturar' => array_search((int)$dato->referencia, array_column($this->SJopciones, 'ID', 'Name')),
                            'hinicio' => $dato->ingresa//date_create($dato->ingrea)->format('d/m/Y H:i:s'),
                        );
                    } else return false;
                break;
                #   DETALLE
                case 3:#    GET REGISTROS SCAN
                    $this->load->model('invtran_model');
                    $datos = $this->scan_model->multiOpciones(6, $extra);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $imagen = 'assets/img/sinImagen.png';
                            if (strlen(trim($dato->imagen)) > 0) {
                                $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                                if (file_exists($direccion.trim($dato->imagen))) $imagen = $direccion.trim($dato->imagen);
                            }
                            #   MULTIPLES BARRAS
                            $mbarras = $this->scan_model->multiOpciones(11, implode(' AND ', [
                                '(idproducto = '.$dato->idproducto.')',
                                '(idgvar = 2)'
                            ]));
                            if ($mbarras->num_rows() > 0) $barras = array_map(function ($var) {return array(
                                'ID' => $var->idrec,
                                'Name' => strtoupper($var->descrip)
                            );}, (array)$mbarras->result());
                            else $barras = '';
                            #   MULTIPLES PRECIOS
                            $mprecios = $this->scan_model->multiOpciones(11, implode(' AND ', [
                                '(idproducto = '.$dato->idproducto.')',
                                '(estatus = 1)',
                                '(idgvar = 1)'
                            ]));
                            if ($mprecios->num_rows() > 0) $precios = array_map(function ($var) {return array(
                                'ID' => $var->idrec,
                                'Name' => strtoupper($var->descrip),
                                'precio' => number_format((float)$var->precioventa, 2, '.', '')
                            );},(array)$mprecios->result());
                            else $precios = [];
                            #   HISTORIAL
                            $notas = [];
                            foreach (explode("\n", $dato->logs) as $key => $log) {
                                $log = explode(',', $log);
                                //print_r($log);
                                $notas[] = array(
                                    'ID' => $key,
                                    'Name' => date_create($log[0])->format('d/m/Y H:i:s'),
                                    'cant' => $log[1]
                                );
                            }
                            #   EXISTENCIAS
                            $sucursales = $this->invtran_model->get_stock_suc($dato->idproducto);
                            $existencias = [];
                            if (count((array)$sucursales) > 0) {
                                foreach ($sucursales as $centro) {
                                    $existencias[] = array(
                                        'ID' => $centro->idcentro,
                                        'Name' => strtoupper($centro->descrip),
                                        'cant' => number_format((float)$centro->cantidad, 2, '.', '')
                                    );
                                }
                            }

                            $Datos[] = array(
                                'key' => trim($dato->idproducto),
                                'titulo' => trim($dato->descrip),
                                'barcode' => trim($dato->barcode),
                                'modelo' => trim($dato->modelo),
                                'marca' => trim($dato->marca),
                                'um' => trim($dato->um),
                                'xpos' => trim($dato->xpos),
                                'cantidad' => number_format((float)$dato->cantidad, 4, '.', ''),
                                //'proveedor' => trim($dato->proveedor),
                                //'impuesto' => trim($dato->impuesto),
                                'costo' => number_format((float)$dato->costounitario, 2, '.', ''),
                                'precio' => number_format((float)$dato->precioventa, 2, '.', ''),
                                'imagen' => $imagen,
                                'barras' => $barras,
                                'precios' => $precios,
                                'notas' => $notas,
                                'existencias' => $existencias
                            );
                        }
                    }
                break;
                case 4:#    INFO PRODUCTO
                    $imagen = 'assets/img/sinImagen.png';
                    if (strlen(trim($extra->imagen)) > 0) {
                        $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                        if (file_exists($direccion.trim($extra->imagen))) $imagen = $direccion.trim($extra->imagen);
                    }

                    #   MULTIPLES BARRAS
                    $mbarras = $this->scan_model->multiOpciones(11, implode(' AND ', [
                        '(idproducto = '.$extra->idproducto.')',
                        '(idgvar = 2)'
                    ]));
                    if ($mbarras->num_rows() > 0) $barras = array_map(function ($var) {return array(
                        'ID' => $var->idrec,
                        'Name' => strtoupper($var->descrip)
                    );}, (array)$mbarras->result());
                    else $barras = '';
                    #   MULTIPLES PRECIOS
                    $mprecios = $this->scan_model->multiOpciones(11, implode(' AND ', [
                        '(idproducto = '.$extra->idproducto.')',
                        '(estatus = 1)',
                        '(idgvar = 1)'
                    ]));
                    if ($mprecios->num_rows() > 0) $precios = array_map(function ($var) {return array(
                        'ID' => $var->idrec,
                        'Name' => strtoupper($var->descrip),
                        'precio' => number_format((float)$var->precioventa, 2, '.', '')
                    );},(array)$mprecios->result());
                    else $precios = [];
                    
                    #   EXISTENCIAS
                    $sucursales = $this->invtran_model->get_stock_suc($extra->idproducto);
                    $existencias = [];
                    if (count((array)$sucursales) > 0) {
                        foreach ($sucursales as $centro) {
                            $existencias[] = array(
                                'ID' => $centro->idcentro,
                                'Name' => strtoupper($centro->descrip),
                                'cant' => number_format((float)$centro->cantidad, 2, '.', '')
                            );
                        }
                    } else $existencias = [];

                    $extra->costounitario = number_format((float)$extra->costounitario, 2, '.', '');
                    $extra->precioventa = number_format((float)$extra->precioventa, 2, '.', '');
                    $extra->imagen = $imagen;
                    $extra->barras = $barras;
                    $extra->precios = $precios;
                    $extra->existencias = $existencias;
                    $Datos = $extra;
                break;
            }
            return $Datos;
        }
        #-
        function scanJob($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' =>$appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
                $this->load->model('scan_model');
                $this->load->model('variable_model');
				$controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['lista_tareas'] = $this->variable_model->getVariablesNombre("scan_job");
                $this->data['ordenes'] = $this->scan_model->listScaners();
                $this->load->view('mantenimiento_scanjob', $this->data);
            }
        }
        
        function newTran(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $tipoT = $this->input->post('tipoT');
                $notas = $this->input->post('notas');
                $referencia = "SJ";
                $this->load->model('scan_model');
                $trannum = $this->scan_model->newTran($tipoT, $notas, $referencia);
                $list = $this->scan_model->listScaners();

                $array = array(
                    "lista" =>$list,
                    "trannum" =>$trannum
                );
                echo json_encode($array);
            }
        } 
        
        function getDatosSearchAjuste(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');

                $this->load->model('scan_model');
                $detalle = $this->scan_model->getDatosProductoSearch($prosearch, $dato);
                if($detalle != 0){
                    $i=0;
                    $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "idproducto" => $info->idproducto,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "barcode" => $info->barcode,
                            "um" => $info->um,
                            "notas" => $info->notas,
                            "precioventa" => $info->precioventa,
                            "imagen" => $info->imagen,
                        );
                        $i++;
                    }
                    $array = array(
                        "error" => "0",
                        "cantidad" => $i,
                        "datos" => $items
                    );
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
        }
        
        function insertProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idproduct = $this->input->post('idproduct'); 
                $cantidad = $this->input->post('cantidad'); 
                $this->load->model('scan_model');
                $insert = $this->scan_model->insertProduct($trannum,$idproduct,$cantidad);
                $info = $this->scan_model->getProducts($trannum);
                $cadena = "";
                if($info!=false){
                    foreach($info as $in){
                        if($in->idproducto % 1 == 0) {
                            $idproducto = round($in->idproducto);
                        }else{
                            $idproducto = round($in->idproducto,2);
                        } 
                        if($in->cantidad % 1 == 0) {
                                $cant = round($in->cantidad);
                            }else{
                                $cant = round($in->cantidad,2);
                            } 
                        $cadena.= $idproducto. ",". $cant."\n";
                    }
                }
                echo json_encode($cadena);
            }
        }
        
        function save_productsT(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $tipo_tarea = $this->input->post('tipo_tarea');
                $temporales = $this->input->post('temporales'); 
                $this->load->model('scan_model');
                $info = $this->scan_model->save_productsT($trannum, $temporales);
                $list = $this->scan_model->listScaners();
                $array = array(
                    "lista" =>$list,
                    "temporales" =>$temporales
                );
                
                echo json_encode($array);
            }
        }
        
        function getProductsTN(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('scan_model');
                $info = $this->scan_model->getProductsTN($trannum);
                echo json_encode($info);
            }
        }
        
        function insertProducts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $lista_pro = $this->input->post('lista_pro');
                $this->load->model('scan_model');
                $info = $this->scan_model->updateProducts($trannum,$lista_pro);
                $lista = $this->scan_model->getProducts($trannum);
                $info_orden = $this->scan_model->getInfoOrden($trannum);
                $lu="";
                foreach($info_orden as $det ){
                    $lu = $det->lineas."/".round($det->unidades);
                }
                $array = array(
                    "lista" =>$lista,
                    "lista_pro" =>$lista_pro,
                    "lu" =>$lu
                );
                echo json_encode($array);
            }
        }
        
        function getTransacciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('scan_model');
                $list = $this->scan_model->listScaners();
                
                $i=0;
                $ordenes = array();
                foreach($list as $ord){
                    $ordenes[$i] = array(
                        "trannum" => "$ord->trannum",
                        "fecha" => "$ord->fecha",
                        "cli_email" => round($ord->cli_email),
                        "dev_direc" => "$ord->dev_direc",
                        "referencia" => "$ord->referencia",
                        "lines100k" => "$ord->lines100k",
                        "notas" =>"$ord->notas",
                        "lu" => round($ord->lineas)."/".round($ord->unidades),
                    );
                    $i++;
                }
                echo json_encode($ordenes);
            }
        }
        
        function detalleScan2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('invtran_model');
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                  
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                $this->load->model('global_model');
                $this->load->model('scan_model');
                $this->load->model('variable_model');
                
				$controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['lista'] = $this->scan_model->getProducts($trannum);
                $this->data['infoOrden'] = $this->scan_model->getInfoOrden($trannum);
                $this->data['lista_tareas'] = $this->variable_model->getVariablesNombre("scan_job");
                $this->load->view('mantenimiento_detallescanjob', $this->data);
            }
        }
                
        function detalleScan($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $tipoProducto = $this->configuracion_model->getProCentro($this->session->userdata('iddApp'));
				
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum,
					'compras_tipopro' => ($tipoProducto == '') ? 1 : $tipoProducto,
                );
                $this->session->set_userdata($resultAppName);
                $controlador = $this->uri->segment(1);
                $direccion = $controlador;
				
				$this->load->model('ventas_model');$this->load->model('compras_model');$this->load->model('scan_model');
                $this->load->model('variable_model');$this->load->model('sucursal_model');
                $this->load->model('global_model');$this->load->model('invtran_model');$this->load->model('producto_model');
				
				
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['informacion'] = $this->scan_model->detalleScan($trannum);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['formas_pago'] = $this->compras_model->formasPago();
                $this->data['tipoDoc'] = $this->compras_model->tipoDoc();
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
                $this->data['estados_data'] = $this->variable_model->getVariablesNombre("po_stat");
                $this->data['correo_user'] = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
				$this->data['fab_envios'] = $this->global_model->getValorNumVariable('fab_envios');
			
                $tipopro = ($tipoProducto === '') ? 1 : $tipoProducto;
                $this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['periodos'] = $this->compras_model->getPeriodosCompras(1);
                $this->data['tipo_pro'] = $tipopro;
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipopro);
                $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipopro);
                $this->data['medidas'] = $this->producto_model->verUM();
                
				$tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }
                $this->session->set_userdata($array);
				
                $this->load->view('mantenimiento_detallescanjob2', $this->data);
            }
        }
                
        function getListadoComprasFechas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $fechaini = $this->input->post("fechaini");
                $fechafin = $this->input->post("fechafin");
                $this->load->model('compras_model');
                $datos = $this->compras_model->getListadoComprasFechas('CO', $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                foreach($datos as $info){
                    $linea = 0;
                    $canti = 0;
					
                    if($info->valcosto == null || $info->valcosto == ""){
                        $valcosto = 0;
                    }else{
                        $valcosto = number_format($info->valcosto, 2, '.', '');
                    }
                    
                    if($info->fecha4=="0000-00-00"){
                        $fechacierre  = "";
                    }else{
                        $fechacierre  = $info->fecha4;
                    }
                    
                    $informacion = $this->compras_model->getDetalleByEstatusCompraLocal($info->trannum, $info->estatus);
                    foreach($informacion as $cmp){
                        $linea++;
                        $canti+= $cmp->cantidad;
                    }
                    
                    $array[$i] = array(
						"trannum" => $info->trannum,
                        "fecha" => $info->fecha3,
                        "fecha1" => $info->fecha1,
                        "fecact" => $fechacierre,
                        "estatus" => $info->estatus,
                        "descrip" => $info->descrip,
                        "serie" => $info->serie.''.$info->numero,
                        "referencia" => $info->referencia,
                        "valventa" => $valcosto,
						"notas" => $info->notas,
						"lineaunidad" => $linea.'/'.number_format($canti)
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
        function importComprasScan(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $lista = $this->input->post("lista");
                $trannum = $this->input->post("trannum");
                $this->load->model('scan_model');
                $datos = $this->scan_model->importComprasScan($lista, $trannum);
                
                $cadena = $this->scan_model->getProductsTN($trannum);
                foreach($datos as $dat){
                    //$cadena.= $dat->idproducto .",".round($dat->cantidad)."_";
                    if($dat->cantidad % 1 == 0) {
                        $cant = round($dat->cantidad);
                    }else{
                        $cant = round($dat->cantidad,2);
                    } 
                    $cadena.= $dat->idproducto. ",". $cant."_";
                }
                $info = $this->scan_model->save_productsT($trannum, $cadena);
                
                $lista = $this->scan_model->getProducts($trannum);
                $info_orden = $this->scan_model->getInfoOrden($trannum);
                $lu="";
                foreach($info_orden as $det ){
                    $lu = $det->lineas."/".round($det->unidades);
                }
                $array = array(
                    "lista" =>$lista,
                    "lista_pro" =>$cadena,
                    "lu" =>$lu
                );
                
                echo json_encode($array);
            }
        }
		
		
		function getDataProductosOrden100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('scan_model');
				$array = $this->scan_model->getDatosOrden100k($idtrannum, $idcentro);
				echo json_encode($array);
			}
		}
		
		function insertProductO100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idproducto = $this->input->post('idproducto');
                $cantidad = $this->input->post('cantidad');
                $precio = $this->input->post('precio');
                $tipotax = $this->input->post('tipotax');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $notas = trim($this->input->post('notas'));
                $this->load->model('scan_model');
                $this->load->model('compras_model');
				$idcentro = $this->session->userdata('idcentrouser');
                $this->scan_model->insertProOrders100($idtrannum, $idproducto, $cantidad, $um, $uniconv, $precio, $tipotax, $notas);
                $detalle = $this->scan_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, 1);
                $datos = $this->scan_model->getDatosOrden100k($idtrannum,$idcentro);

                $i=0;
                $items = array();
                foreach($detalle as $info){
					$items[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"tipotax" => $info->tipotax,
						"precio" => round($info->precioventa,2),
						"costouni" => $info->costouni
					);
					$i++;
				}
				$lines = 0;
				$units = 0;
                if($datos!=false){
                    foreach($datos as $dat){
                        $lines++;
                        $units = $units + abs($dat->cantidad);
                    }
                }
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "lu" => $lines."/".$units
                );
                
                echo json_encode($array);
			}
		}
		
		function updateOrders100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$idrec = $this->input->post('idrec');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                $tipopro = $this->session->userdata('compras_tipopro');
                $cantidad = $this->input->post('cantidad');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $notas = trim($this->input->post('notas'));
                $precio = $this->input->post('precio');
				$this->load->model('scan_model');
                $this->load->model('compras_model');
				$idcentro = $this->session->userdata('idcentrouser');
                $this->scan_model->updateProdOrders100k($idtrannum, $idrec, $cantidad, $precio, $notas, $um, $uniconv);
				$detalle = $this->scan_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, 1);
                $datos = $this->scan_model->getDatosOrden100k($idtrannum,$idcentro);

                $i=0;
                $items = array();
                foreach($detalle as $info){
					$items[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"tipotax" => $info->tipotax,
						"precio" => round($info->precioventa,2),
						"costouni" => $info->costouni
					);
					$i++;
				}
				$lines = 0;
				$units = 0;
                if($datos!=false){
                    foreach($datos as $dat){
                        $lines++;
                        $units = $units + abs($dat->cantidad);
                    }
                }
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "lu" => $lines."/".$units
                );
                
                echo json_encode($array);
			}
		}
		
		function getluOrden100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('compras_model');
				$array = $this->compras_model->getDatosOrden100k($idtrannum, $idcentro);
                
                $lines = 0;
                $units = 0;
                if($datos!=false){
                    foreach($array as $dat){
                        $lines++;
                        $units = $units + abs($dat->cantidad);
                    }
                }
                $cadena = $lines ."/".$units;
				echo json_encode($cadena);
			}
		}
        
		function deleteRegistroOrders(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $this->load->model('scan_model');
                $this->scan_model->deleteDataOrders100($idtrannum, $idrec);
				$detalle = $this->scan_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, 1);
                $datos = $this->scan_model->getDatosOrden100k($idtrannum,$idcentro);

                $i=0;
                $items = array();
                foreach($detalle as $info){
					$items[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"tipotax" => $info->tipotax,
						"precio" => round($info->precioventa,2),
						"costouni" => $info->costouni
					);
					$i++;
				}
				$lines = 0;
				$units = 0;
                if($datos!=false){
                    foreach($datos as $dat){
                        $lines++;
                        $units = $units + abs($dat->cantidad);
                    }
                }
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "lu" => $lines."/".$units
                );
                
                echo json_encode($array);
            }
		}
		
		function getDatosSearchOrdenes(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');
                $tipopro = $this->session->userdata('compras_tipopro');
                
                $this->load->model('compras_model');
                $detalle = $this->compras_model->getDatosProductoSearchOrdenes($prosearch, $dato, $idcentro, $trannum, $tipopro);
                if($detalle != 0){
                    $i=0;
                    $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
						//validacion duplicidad
						if($info->existe == "0"){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "umorders" => $info->umorders,
                                "uniconv" => $info->uniconv,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "tipotax" => $info->tipotax,
                                "namecatalogo" => $info->namecatalogo,
                                "precio" => $info->precioventa,
                                "costouni" => $info->costouni,
								"agregado" => 0
                            );
                            $i++;
                        }else{
							$items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "umorders" => $info->umorders,
                                "uniconv" => $info->uniconv,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "tipotax" => $info->tipotax,
                                "namecatalogo" => $info->namecatalogo,
                                "precio" => $info->precioventa,
                                "costouni" => $info->costouni,
                                "agregado" => 1
                            );
                            $i++;
                            $agregado = 1;
                        }
					}
					if($agregado == 1 && $i == 1){
						$datos = $this->compras_model->getDataOrders100Producto($trannum, $idcentro, $info->idproducto);
						$array = array(
                            "error" => "2",
							"datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
		}
		
        function importComprasScanUpdate(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $lista = $this->input->post("lista");
                $trannum = $this->input->post("trannum");
                $idcatalogo = $this->input->post("idcatalogo");
                $this->load->model('scan_model');
                $datos = $this->scan_model->importComprasScanUpdate($lista, $trannum);
                $this->load->model('scan_model');
                $this->load->model('compras_model');
				$idcentro = $this->session->userdata('idcentrouser');
				$detalle = $this->scan_model->getInventarioByCatalogOrders($trannum,$idcatalogo,$idcentro, 1);
                $datos = $this->scan_model->getDatosOrden100k($trannum,$idcentro);

                $i=0;
                $items = array();
                foreach($detalle as $info){
					$items[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"tipotax" => $info->tipotax,
						"precio" => round($info->precioventa,2),
						"costouni" => $info->costouni
					);
					$i++;
				}
				$lines = 0;
				$units = 0;
                if($datos!=false){
                    foreach($datos as $dat){
                        $lines++;
                        $units = $units + abs($dat->cantidad);
                    }
                }
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "lu" => $lines."/".$units
                );
                
                echo json_encode($array);
            }
        }
		
		function getListadoProductosTipo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $tipopro = $this->input->post('tipopro');
                $idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('compras_model');
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, $tipopro);
				
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    //validacion duplicidad compras locales
					if($info->existe == "0"){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => round($info->precioventa,2),
                            "costouni" => $info->costouni
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i,
                );
                echo json_encode($array);
			}
		}

        function getRecuentosFinalizados(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $this->load->model('scan_model');

                $datos =  $this->scan_model->getRecuentosFinalizados($idcentro);
                $recuentos = [];

                if($datos){
                    foreach($datos as $dato){
                        $recuentos[] = array(
                            "trannum" => $dato['trannum'],
                            "descrip" => $dato['descrip'],
                            "sucursal" => $dato['sucursal'],
                            "fecha" => date_format(date_create($dato['fecha']),'d/m/Y'),
                            "estado" => array_search($dato['estatus'], $this->Estados),

                        );
                    }
                }

                echo json_encode(["recuentos"=>$recuentos]);
            }
        }

        function getProductosRecuentosConsolidados(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannums = $this->input->post('trannums');
                $trannums = str_replace("-", " OR a.trannum = ", $trannums);

                $this->load->model('scan_model');

                $datos =  $this->scan_model->getProductosRecuentosConsolidados($trannums);
                $productos = [];

                $lineas = 0;
                $unidades = 0;
                if($datos){
                    foreach($datos as $dato){
                        $productos[] = array(
                            "idproducto" => $dato['idproducto'],
                            "descrip" => $dato['descrip'],
                            "cant" => number_format($dato['cant'], 2, '.', ''),
                            "modelo" => $dato['modelo'],
                            "barcode" => $dato['barcode'],
                        );
                        $lineas++;
                        $unidades += number_format($dato['cant'], 2, '.', '');
                    }
                }

                echo json_encode(["productos"=>$productos, "lineas"=>$lineas, "unidades"=>$unidades]); 
            }
        }

        function formatoCsvRecuentos($trannums, $centro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannums = str_replace("-", " OR a.trannum = ", $trannums);
                $this->load->model('scan_model');

                $datos = $this->scan_model->getProductosRecuentosConsolidados($trannums);
                $resultado = true;
                $now = date_create()->format('Y_m_d');
                if($datos){
                    $fichero = "Recuento_Suc_".str_pad($centro, 3, "0", STR_PAD_LEFT).".txt";
                    $handle = fopen($fichero,'w+');
                    $texto = "";
                    foreach($datos as $dato){
                        $texto .= $dato['idproducto'].','.number_format($dato['cant'], 2, '.', '')."\r\n";
                    }

                    fwrite($handle,$texto);
                    fclose($handle);

                    if (file_exists($fichero)) {
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($fichero));
                        readfile($fichero);
                        unlink($fichero);
                        exit;
                    }
                }else{
                    $resultado = false;
                }
                
                echo json_encode($resultado);
            }
        }
 
        //GOXSCAN
        public function indexGeneradorTokens($idApp){
            if ($this->validatePermiso()) {
                $this->load->model('configuracion_model');
                $this->load->model('user_model');

                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' =>$appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
				$controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['factual'] = date_create()->format('Y-m-d');
                $this->data['tipo_procesos'] = $this->arrayTipoProcesos;
                $this->data['sucursales'] = $this->user_model->getListSucursales();

                $now = new DateTimeImmutable();
                $later = $now->modify('+7 day');

                $this->data['fecha_ini'] =  $now->format('Y-m-d');
                $this->data['fecha_fin'] =  $later->format('Y-m-d');

                $this->load->view('mantenimiento_generador_tokens', $this->data);
            }
        }

        public function getTokensGenerados(){
            if ($this->validatePermiso()) {
                $estado = $this->input->post('estado');
				
				$this->load->model('scan_model');
				$tokensGenerados = $this->scan_model->getTokensGenerados($estado);
                
				echo json_encode($tokensGenerados); //getListadoUsuarioUbicacionCentros
            }
        }
        
        private function generarToken($idcuenta, $idcentro, $iduser, $idrecuento, $fechaemision, $fechavence){
            $token = $idcuenta. $idcentro. $iduser. $idrecuento. new DateTimeImmutable($fechaemision). new DateTimeImmutable($fechavence);
            return $token;
        }
    }

?>