<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
    class Sadmin extends CI_Controller {
        
        function __construct(){
            parent::__construct();
        }
        
        function index(){
            $this->load->view("sadmin");
            
            $info_validate = array(
                'msg_error' => ''
            );

            $this->session->set_userdata($info_validate);
        }

        function sessionLog(){
            if($this->input->post()){
                $username = $this->input->post('username');
                $password = $this->input->post('password');

                $this->load->model('sadmin_model');
                $infoResult = $this->sadmin_model->validateUserLogin($username, $password);

                if($infoResult){
                    $info_validate = array(
                        'msg_error' => '',
                        'log_sadmin' => TRUE,
                        'log_sadmin_user' => $username,
                        'log_sadmin_pass' => $password
                    );
        
                    $this->session->set_userdata($info_validate);
                    redirect('sCuentas');
                }else{
                    $info_validate = array(
                        'msg_error' => '¡Error! Usuario ó Contraseña Incorrecto.'
                    );
        
                    $this->session->set_userdata($info_validate);
                    redirect('sadmin/');
                }
            }            
        }

        function cuentas(){
            if($this->session->userdata('log_sadmin') != TRUE){
                redirect('sadmin/');
            }else{
                $this->load->view("saccounts");
            }
        }

        function getListadoCuentas(){
            if($this->session->userdata('log_sadmin') != TRUE){
                redirect('sadmin/');
            }else{
                $this->load->model('sadmin_model');

                $array = array(
                    'totalDay' => $this->sadmin_model->getAllDayConnections(),
                    'totalAcc' => $this->sadmin_model->getTotalAccounts(),
                    'totalCon' => $this->sadmin_model->getTotalAccountsConnect(),
                    'listAcco' => $this->sadmin_model->getListadoCuentas(),
                    'dataHour' => $this->sadmin_model->getDetailHours()
                );

                echo json_encode($array);
            }
        }

        function getDetalleConexionesCuenta(){
            if($this->session->userdata('log_sadmin') != TRUE){
                redirect('sadmin/');
            }else{
                $idaccount = $this->input->post('idaccount');

                $this->load->model('sadmin_model');
                
                $array = array(
                    'totalDay'      => $this->sadmin_model->getDayConnections($idaccount),
                    'totalGlo'      => $this->sadmin_model->getGlobalConnections($idaccount),
                    'connections'   => $this->sadmin_model->getDetalleConnections($idaccount)
                );

                echo json_encode($array);
            }
        }

        function validateLoginSadmin(){
            // if($this->session->userdata('log_sadmin') != TRUE){
            //     redirect('sadmin/');
            // }else{
                $idaccount  = trim($this->input->post('idaccount'));
                $motivocon  = trim($this->input->post('notas'));
                $username   = $this->session->userdata('log_sadmin_user');
                $password   = $this->session->userdata('log_sadmin_pass');

                $this->load->model('sadmin_model');
                $array = $this->sadmin_model->loginSadmin($idaccount, $username, $password, $motivocon);
                
                echo json_encode($array);
            // }
        }

        function sAdminLogout(){
            $info_validate = array(
                'msg_error'         => '',
                'log_sadmin'        => FALSE,
                'log_sadmin_user'   => '',
                'log_sadmin_pass'   => ''
            );

            $this->session->unset_userdata($info_validate);
            $this->session->sess_destroy();
            session_destroy();
            
            redirect('sadmin/');
        }
    }
?>