<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    require 'vendor/autoload.php';
    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;

    class Project_Manager extends CI_Controller {

        function __construct() {
            parent::__construct();
        }

        function eliminarTildes($cadena){
            $cadena = str_replace(
                array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
                array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
                $cadena
            );

            $cadena = str_replace(
                array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
                array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
                $cadena
            );
            
            $cadena = str_replace(
                array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
                array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
                $cadena
            );

            $cadena = str_replace(
                array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
                array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
                $cadena
            );

            $cadena = str_replace(
                array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
                array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
                $cadena
            );

            $cadena = str_replace(
                array('ñ', 'Ñ', 'ç', 'Ç'),
                array('n', 'N', 'c', 'C'),
                $cadena
            );            

            return $cadena;
        }

        function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			$numero = trim($numero);
			if($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if($numero == 90)
						return "90";
					else if($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if($numero >= 80 && $numero <= 89){
					if($numero == 80)
						return "80";
					else if($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if($numero >= 70 && $numero <= 79){
					if($numero == 70)
						return "70";
					else if($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if($numero >= 60 && $numero <= 69){
					if($numero == 60)
						return "60";
					else if($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if($numero >= 50 && $numero <= 59){
					if($numero == 50)
						return "50";
					else if($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if($numero >= 40 && $numero <= 49){
					if($numero == 40)
						return "40";
					else if($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if($numero >= 30 && $numero <= 39){
					if($numero == 30)
						return "30";
					else if($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if($numero >= 20 && $numero <= 29){
					if($numero == 20)
						return "20";
					else if($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if($numero >= 10 && $numero <= 19){
					if($numero == 10)
						return "10";
					else if($numero == 11)
						return "11";
					else if($numero == 12)
						return "12";
					else if($numero == 13)
						return "13";
					else if($numero == 14)
						return "14";
					else if($numero == 15)
						return "15";
					else if($numero == 16)
						return "16";
					else if($numero == 17)
						return "17";
					else if($numero == 18)
						return "18";
					else if($numero == 19)
						return "19";
				}
			}else{
				return $this->unidad_centimos($numero);
			}
		}

		function unidad($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num = "nueve";
					break;
				}
				case 8:{
					$num = "ocho";
					break;
				}
				case 7:{
					$num = "siete";
					break;
				}
				case 6:{
					$num = "seis";
					break;
				}
				case 5:{
					$num = "cinco";
					break;
				}
				case 4:{
					$num = "cuatro";
					break;
				}
				case 3:{
					$num = "tres";
					break;
				}
				case 2:{
					$num = "dos";
					break;
				}
				case 1:{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			$numero = trim($numero);

			if($numero >= 90 && $numero <= 99){
				$num_letra = "noventa ";
				
				if($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}else if($numero >= 80 && $numero <= 89){
				$num_letra = "ochenta ";
				
				if($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}else if($numero >= 70 && $numero <= 79){
					$num_letra = "setenta ";

				if($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}else if($numero >= 60 && $numero <= 69){
				$num_letra = "sesenta ";

				if($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}else if($numero >= 50 && $numero <= 59){
				$num_letra = "cincuenta ";

				if($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}else if($numero >= 40 && $numero <= 49){
				$num_letra = "cuarenta ";

				if($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}else if($numero >= 30 && $numero <= 39){
				$num_letra = "treinta ";

				if($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}else if($numero >= 20 && $numero <= 29){
				if($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}else if($numero >= 10 && $numero <= 19){
				switch($numero){
					case 10:{
						$num_letra = "diez ";
						break;
					}
					case 11:{
						$num_letra = "once ";
						break;
					}
					case 12:{
						$num_letra = "doce ";
						break;
					}
					case 13:{
						$num_letra = "trece ";
						break;
					}
					case 14:{
						$num_letra = "catorce ";
						break;
					}
					case 15:{
						$num_letra = "quince ";
						break;
					}
					case 16:{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}else{
				$num_letra = $this->unidad($numero);
			}
			
			return $num_letra;
		}

		function centena($numero){
			$numero = trim($numero);
			if($numero >= 100){
				if ($numero >= 900 & $numero <= 999){
					$num_letra = "novecientos ";

					if($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}else if($numero >= 800 && $numero <= 899){
					$num_letra = "ochocientos ";

					if($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}else if($numero >= 700 && $numero <= 799){
					$num_letra = "setecientos ";

					if($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}else if($numero >= 600 && $numero <= 699){
					$num_letra = "seiscientos ";

					if($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}else if($numero >= 500 && $numero <= 599){
					$num_letra = "quinientos ";

					if($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}else if($numero >= 400 && $numero <= 499){
					$num_letra = "cuatrocientos ";

					if($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}else if($numero >= 300 && $numero <= 399){
					$num_letra = "trescientos ";

					if($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}else if($numero >= 200 && $numero <= 299){
					$num_letra = "doscientos ";

					if($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}else if($numero >= 100 && $numero <= 199){
					if($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}else{
				$num_letra = $this->decena($numero);
			}

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			$num_letra = $this->centena($parcial).$this->centimos();
			
			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial > 0){
				if($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}
		
		function millon(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";
			
			return $num_letras;
		}
		
		function convertir_a_letras($numero){
			global $importe_parcial;
			
			$numero = trim($numero);
			
			$importe_parcial = $numero;
			
			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
        private function validatePermiso() {
            $permiso = true;
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || !$permiso) redirect('CerrarSesion');
            else return true;
        }
        function console_log( $data ){
            echo '<script>';
            echo 'console.log('. json_encode( $data ) .')';
            echo '</script>';
        }
        function highlight_array($array, $name = 'var') {
            highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
        }

        #Project Manager
        function projectManager($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('sucursal_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'namePage' => $appName,
                    'appName' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $controladore = $this->uri->segment(1);
                //$funcione = $this->uri->segment(2);
                //$direccione = $controladore.'/'.$funcione;
                $direccione = $controladore;
                $varName = 'pm_tipos';
                $this->load->model('global_model');
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccione);
                $this->data['servicios'] = $this->global_model->getOpcionesVariable($varName);
                $this->data['tipos']  = $this->sucursal_model->getTipo();
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['centros']  = $this->sucursal_model->viewSucursal();
                
                //$this->load->view('project_manager_view', $this->data);
                $this->load->view('project_manager_view_new', $this->data);
            }
        }

        function getInfoClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('project_Manager_model');
                $informacion = $this->project_Manager_model->getInfoClientes();
    
                echo json_encode($informacion);
            }
        }

        function getInfoEmp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $cliente = $this->input->post('cliente');
                $this->load->model('project_Manager_model');
                $informacion = $this->project_Manager_model->getInfoEmp($cliente);
    
                echo json_encode($informacion);
            }
        }

        function getInfoEmpInterno(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('project_Manager_model');
                $informacion = $this->project_Manager_model->getInfoEmpInterno();
    
                echo json_encode($informacion);
            }
        }

        function getPmClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('project_Manager_model');
                $informacion = $this->project_Manager_model->getPmClientes();
    
                echo json_encode($informacion);
            }
        }

        function getProjectsByService(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idService = $this->input->post('service');
                $idAuxi = $this->input->post('client');
                //$status = $this->input->post('status');//

                $this->load->model('project_Manager_model');
                $informacion = $this->project_Manager_model->getProjectsByService($idService, $idAuxi/*, $status*/);
                $arrayResp = [];

                foreach($informacion as $info){
                    $assignaments = $this->project_Manager_model->getAssignedToProject($info->asignadoa);
                    $assignedWorkers = $this->project_Manager_model->getWorkerAssignedToProject($info->idworker);

                    switch($info->estado){
                        case 0:
                            $estado = 'Pendiente';
                        break;
                        case 1:
                            $estado = 'En Proceso';
                        break;
                        case 2:
                            $estado = 'Completado';
                        break;
                        default:
                            $estado = 'Pendiente';
                    }

                    $arrayResp[] = array(
                        'idrec' => $info->idrec,
                        'idcps' => $info->idcps,
                        'idservicio' => $info->idservicio,
                        'fase' => $info->fase,
                        'actividad' =>$info->actividad,
                        'asignado' => $assignaments,
                        'workers' => $assignedWorkers,
                        'assignCode' => $info->asignadoa,
                        'workerCode' => $info->idworker,
                        'estado' => $estado,
                        'estadoCode' => $info->estado,
                        'fechaIni' => $info->fechaini,
                        'fechaFin' => $info->fechafin,
                        'fechaCompletado' => ($info->fechaCompletado == '00/00/0000') ? '' : $info->fechaCompletado,
                        'notas' => $info->notas
                    );
                }
    
                echo json_encode($arrayResp);
            }
        }

        function setNewProject(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idcps = $this->input->post('cliente');
                $idservicio = $this->input->post('servicio');
                $fase = $this->input->post('fase');
                $actividad = $this->input->post('actividad');
                $asignado = $this->input->post('asignado');
                $worker = $this->input->post('worker');
                $estado = $this->input->post('estado');
                $fechaIni = $this->input->post('fechaIni');
                $fechaFin = $this->input->post('fechaFin');
                $notas = $this->input->post('notas');

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->setNewProject($idcps, $idservicio, $fase, $actividad, $asignado, $worker, $estado, $fechaIni, $fechaFin, $notas);

                if($dataResult){
                    $resultArray[] = array('valido' => true, 'datos' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => false);
                }

                echo json_encode($resultArray);
            }
        }

        function setMultiProjects(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idcps = $this->input->post('cliente');
                $idservicios = $this->input->post('sistemaServicio');

                $this->load->model('project_Manager_model');

                foreach($idservicios as $servicios) {
                    $dataResult =  $this->project_Manager_model->setMultiProjects($idcps, intval($servicios));
                }

                if($dataResult){
                    $resultArray[] = array('valido' => true, 'datos' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => false);
                }

                echo json_encode($resultArray);
            }
        }

        function updateProject(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idrec = $this->input->post('idrec');
                $idcps = $this->input->post('cliente');
                $idservicio = $this->input->post('servicio');
                $fase = $this->input->post('fase');
                $actividad = $this->input->post('actividad');
                $asignado = $this->input->post('asignado');
                $worker = $this->input->post('worker');
                $estado = $this->input->post('estado');
                $fechaIni = $this->input->post('fechaIni');
                $fechaFin = $this->input->post('fechaFin');
                $notas = $this->input->post('notas');

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->updateProject($idrec, $idcps, $idservicio, $fase, $actividad, $asignado, $worker, $estado, $fechaIni, $fechaFin, $notas);

                if($dataResult){
                    $resultArray[] = array('valido' => true, 'datos' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => false);
                }

                echo json_encode($resultArray);
            }
        }

        function setNewActivity(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idcps = $this->input->post('cliente');
                $idservicio = $this->input->post('servicio');
                $fase = $this->input->post('fase');
                $actividad = $this->input->post('actividad');
                $asignado = $this->input->post('asignado');
                $worker = $this->input->post('worker');
                $estado = $this->input->post('estado');
                $fechaIni = $this->input->post('fechaIni');
                $fechaFin = $this->input->post('fechaFin');
                $notas = $this->input->post('notas');

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->setNewActivity($idcps, $idservicio, $fase, $actividad, $asignado, $worker, $estado, $fechaIni, $fechaFin, $notas);

                if($dataResult){
                    $resultArray[] = array('valido' => true, 'datos' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => false);
                }

                echo json_encode($resultArray);
            }
        }

        function getPhasesActivities(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idService = $this->input->post('service');
                $idAuxi = $this->input->post('client');

                $this->load->model('project_Manager_model');
                $informacion = $this->project_Manager_model->getPhasesActivitiesByService($idService, $idAuxi);
                $arrayResp = [];

                foreach($informacion as $info){

                    $arrayResp[] = array(
                        'fase' => $info->fase,
                        'actividad' =>$info->actividad
                    );
                }
    
                echo json_encode($arrayResp);
            }
        }

        function setNewActivities(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idcps = $this->input->post('cliente');
                $idservicio = $this->input->post('servicio');
                $phasesActivities = $this->input->post('phasesActivities');
                $worker = $this->input->post('worker');
                $estado = $this->input->post('estado');
                $fechaIni = $this->input->post('fechaIni');
                $fechaFin = $this->input->post('fechaFin');

                $this->load->model('project_Manager_model');

                foreach($phasesActivities as $each){
                    $dataResult =  $this->project_Manager_model->setNewActivities($idcps, $idservicio, $each['fase'], $each['actividad'], $worker, $estado, $fechaIni, $fechaFin);
                }

                if($dataResult){
                    $resultArray[] = array('valido' => true, 'datos' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => false);
                }

                echo json_encode($resultArray);
            }
        }

        function addContact(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idcps = $this->input->post('cliente');
                $nombre = $this->input->post('nombre');
                $cargo = ($this->input->post('cargo') != null) ? $this->input->post('cargo') : '';
                $telefono = ($this->input->post('telefono') != null) ? $this->input->post('telefono') : '';
                $email = ($this->input->post('email') != null) ? $this->input->post('email') : '';
                $notas = ($this->input->post('notas') != null) ? $this->input->post('notas') : '';

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->addContact($idcps, $nombre, $cargo, $telefono, $email, $notas);

                if($dataResult){
                    $resultArray[] = array('valido' => true, 'datos' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => false);
                }

                echo json_encode($resultArray);
            }
        }

        function updateContact(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idContacto = $this->input->post('contacto');
                $idcps = $this->input->post('cliente');
                $nombre = $this->input->post('nombre');
                $cargo = $this->input->post('cargo');
                $telefono = $this->input->post('telefono');
                $email = $this->input->post('email');
                $notas = $this->input->post('notas');

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->updateContact($idContacto, $idcps, $nombre, $cargo, $telefono, $email, $notas);

                if($dataResult){
                    $resultArray[] = array('valido' => true, 'datos' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => false);
                }

                echo json_encode($resultArray);
            }
        }

        function deleteContact(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idContacto = $this->input->post('code');

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->deleteContact($idContacto);

                if($dataResult){
                    $resultArray[] = array('valido' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => $dataResult);
                }

                echo json_encode($resultArray);
            }
        }

        function deleteProject(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $recNumber = $this->input->post('code');

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->deleteProject($recNumber);

                if($dataResult){
                    $resultArray[] = array('valido' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => $dataResult);
                }

                echo json_encode($resultArray);
            }
        }

        function getSystemsOrServicesByClients(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idAuxi = $this->input->post('client');
                $varName = 'pm_tipos';

                $this->load->model('project_Manager_model');
                $this->load->model('global_model');
                $informacion = $this->project_Manager_model->getSystemsOrServicesByClients($idAuxi);
                $servicios = $this->global_model->getOpcionesVariable($varName);
                $arrayResp = [];

                //var_dump($servicios);
                foreach($informacion as $info){
                    foreach($servicios as $serv){
                        if ($info->idservicio == $serv['id']) {

                            switch($info->estado){
                                case 0:
                                    $estado = 'PENDIENTE';
                                break;
                                case 1:
                                    $estado = 'EN PROCESO';
                                break;
                                case 2:
                                    $estado = 'COMPLETADO';
                                break;
                                default:
                                    $estado = 'PENDIENTE';
                            }

                            $arrayResp[] = array(
                                'id' => $serv['id'],
                                'text' => $serv['descrip'],
                                'fechaIni' => ($info->fechaini == '0000-00-00') ? null : $info->fechaini,
                                'fechaFin' => ($info->fechafin == '0000-00-00') ? null : $info->fechafin,
                                'estado' => $estado,
                                'status' => $info->estado,
                                'rec' => $info->idrec,
                                'notas' => $info->notas
                            );
                        }
                    }

                }
    
                echo json_encode($arrayResp);
            }
        }

        function uploadFilesByClient1(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                // Check if the request has a file upload form data
                if (isset($_FILES['fileChunk']) && isset($_POST['chunkMetadata']) && isset($_POST['destinationDirectory'])) {
                    // Retrive and decode form data
                    $chunkMetadataJson = $_POST['chunkMetadata'];
                    $destinationDirJson = $_POST['destinationDirectory'];
                    $cliente = $this->input->post('cliente');
                    $project = $this->input->post('project');
                    
                    // Decode JSON data
                    $chunkMetadata = json_decode($chunkMetadataJson, true);
                    $destinationDirectory = json_decode($destinationDirJson, true);

                    if (!$chunkMetadata || !$destinationDirectory) {
                        echo $this->createResponse(false, null, 'Invalid metadata or destination directory', null);
                    }

                    // Ensure the file upload is valid
                    if ($_FILES['fileChunk']['error'] !== UPLOAD_ERR_OK) {
                        echo $this->createResponse(false, 500, 'File upload error', null);
                    }

                    // Retrive file chunk and save it
                    $fileChunk = $_FILES['fileChunk']['tmp_name'];
                    $fileName = $chunkMetadata['fileName'];
                    $uploadFileDir = FCPATH.'doc_adjuntos/archivos_'.$this->session->userdata('idaccount').'/'.$cliente.'/';
                    //public_html/versanet/doc_adjuntos
                    $destinationPath = $uploadFileDir . $fileName;

                    

                    // Check if the upload directory exists, if not, create it
                    // if (!is_dir($uploadFileDir)) {
                    //     mkdir($uploadFileDir, 0755, true);
                    // }

                    // if (!move_uploaded_file($fileChunk, $destinationPath)) {
                    //     echo $this->createResponse(false, 500, 'Faild to save file', null);
                    // }

                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");

                    $file_data = [
                        'idrecpm100' => 0,
                        'idcps' => $cliente,
                        'descrip' => strtoupper($project),
                        'archivo' => mb_convert_encoding($fileName, 'ISO-8859-1', 'UTF-8'),
                        'ingresa' => $fecha_actual,
                        'whodidit' => $this->session->userdata('iduser')
                    ];

                    // Save the file chunk
                    if ($this->saveFilesByClient1($fileChunk, $fileName, $uploadFileDir, ($chunkMetadata['index'] + 1), $chunkMetadata['totalCount'], $file_data, 0)) {
                        echo $this->createResponse(true, null, null, null);
                    } else {
                        echo $this->createResponse(false, 500, 'Faild to save file', null);
                    }

                    //echo $this->createResponse(true, null, null, null);
                } else {
                    echo $this->createResponse(false, 400, 'Missing required form data', null);
                }
            }
        }

        function saveFilesByClient1($file, $fileName, $destinationFolder, $index, $totalCount, $file_data, $fileOrAnexo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $path = $destinationFolder.$fileName;
                //-----------------------------------------
                $tempPath = $destinationFolder.'temp/'.$fileName.'_part_'.$index;

                if (!is_dir($destinationFolder.'temp/')) {
                    mkdir($destinationFolder.'temp/', 0777, true);
                }

                if (move_uploaded_file($file, $tempPath)) {
                    if($index == $totalCount) {
                        $filePath = $destinationFolder.'temp/'.$fileName.'_part_'.'*';
                        $fileParts = glob($filePath);
                        sort($fileParts, SORT_NATURAL);

                        if (!is_dir($destinationFolder)) {
                            mkdir($destinationFolder, 0777, true);
                        }

                        $finaleFile = fopen($path, 'w');

                        foreach ($fileParts as $filePart) {
                            $chunk = file_get_contents($filePart);
                            fwrite($finaleFile, $chunk);
                            unlink($filePart);
                        }

                        fclose($finaleFile);
                        rmdir($destinationFolder.'temp');

                        if ($fileOrAnexo == 0) {
                            $this->load->model('project_Manager_model');
                            $this->project_Manager_model->insertFilesByClients($file_data);
                        } else {
                            $this->load->model('project_Manager_model');
                            $this->project_Manager_model->insertAnexosFilesByClients($file_data);
                        }
                    }

                    return true;
                } else {
                    return false;
                }


                //-----------------------------------------

                // Ensure the destination folde exists
                // if (!is_dir($destinationFolder)) {
                //     mkdir($destinationFolder, 0777, true);
                // }

                // Move the upload file to the destination
                // if (move_uploaded_file($file, $path)) {
                //     return true;
                // } else {
                //     return false;
                // }
            }
        }

        function getFilesByClient1(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $destinationDirJson = $_POST['pathInfo'];
                $cliente = $this->input->post('cliente');
                $pathInfo = json_decode($destinationDirJson);
                $rootFolderName = FCPATH.'doc_adjuntos/archivos_'.$this->session->userdata('idaccount').'/'.$cliente.'/';
                $folderName = ($pathInfo === '') ? $rootFolderName : $pathInfo;
                $items = [];

                if (is_dir($folderName)) {
                    $dir = new DirectoryIterator($folderName);

                    foreach ($dir as $fileinfo) {
                        if ($fileinfo -> isDir() && !$fileinfo->isDot()) {
                            $items[] = [
                                'Key' => $fileinfo->getPathname(),
                                'IsDirectory' => true,
                                'dateModified' => date('d/m/Y', $fileinfo->getCTime()),
                                'Name' => $fileinfo->getFilename(),
                                'Size' => $fileinfo->getSize(),
                                'HasSubDirectories' => (new FilesystemIterator($fileinfo->getPathname(), FilesystemIterator::SKIP_DOTS))->valid()
                            ];
                        } elseif ($fileinfo->isFile()) {
                            $items[] = [
                                'Key' => $fileinfo->getPathname(),
                                'IsDirectory' => false,
                                'dateModified' => date('d/m/Y', $fileinfo->getCTime()),
                                'Name' => $fileinfo->getFilename(),
                                'Size' => $fileinfo->getSize(),
                                'HasSubDirectories' => false
                            ];
                        }
                    }
                }

                //var_dump($items);

                echo $this->createResponse(true, null, null, $items);
            }
        }

        function downloadFilesByClient1(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $name = $this->input->post('pathInfo');
                if (empty($name)) {
                    echo null;
                }
                
                //var_dump(json_decode($name));
                $items = json_decode($name, true);
                if (count($items) == 1) {
                    $filePath = $items[0];
                    if (file_exists($filePath)) {
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($filePath).'"');
                        readfile($filePath);
                        exit;
                    } else {
                        $zip = new ZipArchive();
                        http_response_code(404);
                        echo 'File not found';
                        exit;
                    }
                } else {
                    $zip = new ZipArchive();
                    $tempZipFile = tempnam(sys_get_temp_dir(), 'zip');
                    if ($zip->open($tempZipFile, ZipArchive::CREATE) !== true) {
                        http_response_code(500);
                        echo 'Unable to crete ZIP archive';
                        exit;
                    }

                    foreach($items as $filePath) {
                        if (file_exists($filePath)) {
                            $zip->addFile($filePath, basename($filePath));
                        }
                    }
                    $zip->close();

                    header('Content-Description: File Transfer');
                    header('Content-Type: application/zip');
                    header('Content-Disposition: attachment; filename="archivos.zip"');
                    header('Content-Length: ' . filesize($tempZipFile));
                    readfile($tempZipFile);
                    unlink($tempZipFile); // Remove the temporary file
                }
            }
        }

        function deleteFilesByClient1(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $destinationDirJson = $_POST['pathInfo'];
                $cliente = $this->input->post('cliente');
                $name_file = $this->input->post('name_file');
                $pathInfo = json_decode($destinationDirJson);
                //var_dump($pathInfo);

                $response = '';
                if (is_dir($pathInfo)) {
                    //Check if the directory is empty
                    if (count(glob("$pathInfo/*")) > 0) {
                        $response = $this->createResponse(false, 409, "You can't remove a directory with files or other directories", null);
                    } else {
                        // Remove the empty directory
                        if (rmdir($pathInfo)) {
                            $response = $this->createResponse(true, null, null, null, null);
                        } else {
                            $response = $this->createResponse(false, 500, "Failed to remove directory", null);
                        }
                    }
                } elseif (is_file($pathInfo)) {
                    // Delete the file
                    if (unlink($pathInfo)) {
                        $this->load->model('project_Manager_model');
                        $this->project_Manager_model->deleteFilesByClient(mb_convert_encoding($name_file, 'ISO-8859-1', 'UTF-8'), $cliente);

                        $response = $this->createResponse(true, null, null, null);
                    } else {
                        $response = $this->createResponse(false, 500, "Failed to delete file", null);
                    }
                } else {
                    // Path does not exist
                    $response = $this->createResponse(false, 404, "Path does not exist", null);
                }

                echo $response;
            }
        }

        function uploadAnexosFilesByClient(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                // Check if the request has a file upload form data
                if (isset($_FILES['fileChunk']) && isset($_POST['chunkMetadata']) && isset($_POST['destinationDirectory'])) {
                    // Retrive and decode form data
                    $chunkMetadataJson = $_POST['chunkMetadata'];
                    $destinationDirJson = $_POST['destinationDirectory'];
                    $cliente = $this->input->post('cliente');
                    $project = $this->input->post('project');
                    
                    // Decode JSON data
                    $chunkMetadata = json_decode($chunkMetadataJson, true);
                    $destinationDirectory = json_decode($destinationDirJson, true);

                    if (!$chunkMetadata || !$destinationDirectory) {
                        echo $this->createResponse(false, null, 'Invalid metadata or destination directory', null);
                    }

                    // Ensure the file upload is valid
                    if ($_FILES['fileChunk']['error'] !== UPLOAD_ERR_OK) {
                        echo $this->createResponse(false, 500, 'File upload error', null);
                    }

                    // Retrive file chunk and save it
                    $fileChunk = $_FILES['fileChunk']['tmp_name'];
                    $fileName = $chunkMetadata['fileName'];
                    $uploadFileDir = FCPATH.'doc_adjuntos/anexos_'.$this->session->userdata('idaccount').'/';
                    //public_html/versanet/doc_adjuntos
                    $destinationPath = $uploadFileDir . $fileName;

                    // Check if the upload directory exists, if not, create it
                    // if (!is_dir($uploadFileDir)) {
                    //     mkdir($uploadFileDir, 0755, true);
                    // }

                    // if (!move_uploaded_file($fileChunk, $destinationPath)) {
                    //     echo $this->createResponse(false, 500, 'Faild to save file', null);
                    // }

                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");

                    $file_data = [
                        'descrip' => strtoupper($project),
                        'archivo' => mb_convert_encoding($fileName, 'ISO-8859-1', 'UTF-8'),
                        'ingresa' => $fecha_actual,
                        'whodidit' => $this->session->userdata('iduser')
                    ];

                    // Save the file chunk
                    if ($this->saveFilesByClient1($fileChunk, $fileName, $uploadFileDir, ($chunkMetadata['index'] + 1), $chunkMetadata['totalCount'], $file_data, 1)) {
                        echo $this->createResponse(true, null, null, null);
                    } else {
                        echo $this->createResponse(false, 500, 'Faild to save file', null);
                    }                    

                    //return $this->createResponse(true, null, null, null);
                } else {
                    echo $this->createResponse(false, 400, 'Missing required form data', null);
                }
            }
        }

        function getAnexosFilesByClient(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $destinationDirJson = $_POST['pathInfo'];
                $cliente = $this->input->post('cliente');
                $pathInfo = json_decode($destinationDirJson);
                $rootFolderName = FCPATH.'doc_adjuntos/anexos_'.$this->session->userdata('idaccount').'/';
                $folderName = ($pathInfo === '') ? $rootFolderName : $pathInfo;
                $items = [];

                if (is_dir($folderName)) {
                    $dir = new DirectoryIterator($folderName);

                    foreach ($dir as $fileinfo) {
                        if ($fileinfo -> isDir() && !$fileinfo->isDot()) {
                            $items[] = [
                                'Key' => $fileinfo->getPathname(),
                                'IsDirectory' => true,
                                'dateModified' => date('d/m/Y', $fileinfo->getCTime()),
                                'Name' => $fileinfo->getFilename(),
                                'Size' => $fileinfo->getSize(),
                                'HasSubDirectories' => (new FilesystemIterator($fileinfo->getPathname(), FilesystemIterator::SKIP_DOTS))->valid()
                            ];
                        } elseif ($fileinfo->isFile()) {
                            $items[] = [
                                'Key' => $fileinfo->getPathname(),
                                'IsDirectory' => false,
                                'dateModified' => date('d/m/Y', $fileinfo->getCTime()),
                                'Name' => $fileinfo->getFilename(),
                                'Size' => $fileinfo->getSize(),
                                'HasSubDirectories' => false
                            ];
                        }
                    }
                }

                //var_dump($items);

                echo $this->createResponse(true, null, null, $items);
            }
        }

        function downloadAnexosFilesByClient(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $name = $this->input->post('pathInfo');
                if (empty($name)) {
                    echo null;
                }
                
                //var_dump(json_decode($name));
                $items = json_decode($name, true);
                if (count($items) == 1) {
                    $filePath = $items[0];
                    if (file_exists($filePath)) {
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($filePath).'"');
                        readfile($filePath);
                        exit;
                    } else {
                        $zip = new ZipArchive();
                        http_response_code(404);
                        echo 'File not found';
                        exit;
                    }
                } else {
                    $zip = new ZipArchive();
                    $tempZipFile = tempnam(sys_get_temp_dir(), 'zip');
                    if ($zip->open($tempZipFile, ZipArchive::CREATE) !== true) {
                        http_response_code(500);
                        echo 'Unable to crete ZIP archive';
                        exit;
                    }

                    foreach($items as $filePath) {
                        if (file_exists($filePath)) {
                            $zip->addFile($filePath, basename($filePath));
                        }
                    }
                    $zip->close();

                    header('Content-Description: File Transfer');
                    header('Content-Type: application/zip');
                    header('Content-Disposition: attachment; filename="archivos.zip"');
                    header('Content-Length: ' . filesize($tempZipFile));
                    readfile($tempZipFile);
                    unlink($tempZipFile); // Remove the temporary file
                }
            }
        }

        function deleteAnexosFilesByClient(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $destinationDirJson = $_POST['pathInfo'];
                $cliente = $this->input->post('cliente');
                $name_file = $this->input->post('name_file');
                $project = $this->input->post('project');
                $pathInfo = json_decode($destinationDirJson);
                //var_dump($pathInfo);

                $response = '';
                if (is_dir($pathInfo)) {
                    //Check if the directory is empty
                    if (count(glob("$pathInfo/*")) > 0) {
                        $response = createResponse(false, 409, "You can't remove a directory with files or other directories", null);
                    } else {
                        // Remove the empty directory
                        if (rmdir($pathInfo)) {
                            $response = $this->createResponse(true, null, null, null, null);
                        } else {
                            $response = $this->createResponse(false, 500, "Failed to remove directory", null);
                        }
                    }
                } elseif (is_file($pathInfo)) {
                    // Delete the file
                    if (unlink($pathInfo)) {
                         $this->load->model('project_Manager_model');
                         $this->project_Manager_model->deleteAnexosFilesByClient(mb_convert_encoding($name_file, 'ISO-8859-1', 'UTF-8'), $project);

                        $response = $this->createResponse(true, null, null, null);
                    } else {
                        $response = $this->createResponse(false, 500, "Failed to delete file", null);
                    }
                } else {
                    // Path does not exist
                    $response = $this->createResponse(false, 404, "Path does not exist", null);
                }

                echo $response;
            }
        }

        function createResponse($success, $errorCode, $errorText, $result){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                // Convert result to array if it's not null
                $resultArray = is_array($result) ? $result : [];

                // Create response array 
                $response = [
                    'success' => $success,
                    'errorCode' => $errorCode,
                    'errorText' => $errorText,
                    'result' => $resultArray
                ];

                // Convert response to JSON and set camelCase properties
                return json_encode($this->camelCaseKeys($response));
            }
        }

        function camelCaseKeys($array) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $result = [];
                foreach ($array as $key => $value) {
                    $camelCaseKey = lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', $key))));
                    $result[$camelCaseKey] = is_array($value) ? $this->camelCaseKeys($value) : $value;
                }
                return $result;
            }
        }

        function getNotesByClinet(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcps = $this->input->post('code');
                $this->load->model('project_Manager_model');
                $informacion = $this->project_Manager_model->getNotesByClinet($idcps);
    
                echo json_encode($informacion);
            }
        }

        function addClientNotes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idcps = $this->input->post('cliente');
                $titulo = $this->input->post('titulo');
                $detalle = $this->input->post('detalle');
                $fecha = $this->input->post('fecha');
                $asignados = ($this->input->post('asignados') != null) ? $this->input->post('asignados') : '';
                $fecha = explode('T', $fecha);

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->addClientNotes($idcps, $titulo, $detalle, $fecha[0], $asignados);

                if($dataResult){
                    $resultArray[] = array('valido' => true, 'datos' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => false);
                }

                echo json_encode($resultArray);
            }
        }

        function updateClientNotes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $notaCode = $this->input->post('notaCode');
                $idcps = $this->input->post('cliente');
                $titulo = $this->input->post('titulo');
                $detalle = $this->input->post('detalle');
                $fecha = $this->input->post('fecha');
                $asignados = $this->input->post('asignados');

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->updateClientNotes($notaCode, $idcps, $titulo, $detalle, $fecha, $asignados);

                if($dataResult){
                    $resultArray[] = array('valido' => true, 'datos' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => false);
                }

                echo json_encode($resultArray);
            }
        }

        function deleteClientNotes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idrec = $this->input->post('code');

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->deleteClientNotes($idrec);

                if($dataResult){
                    $resultArray[] = array('valido' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => $dataResult);
                }

                echo json_encode($resultArray);
            }
        }

        function checkGiroDteField(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->checkGiroDteField();

                if($dataResult){
                    $resultArray[] = array('existe' => $dataResult);
                }else{
                    $resultArray[] = array('existe' => $dataResult);
                }

                echo json_encode($resultArray);
            }
        }

        function updateProjectDateAndStatus(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('rec');
                $fechaIni = $this->input->post('fechaIni');
                $estado = $this->input->post('estado');
                $notas = $this->input->post('notas');

                $this->load->model('project_Manager_model');
                $dataResult = $this->project_Manager_model->updateProjectDateAndStatus($idrec, $fechaIni, $estado, $notas);

                echo json_encode($dataResult);
            }
        }

        function importContacts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('cliente_model');
                $this->load->model('project_Manager_model');

                $idauxi = $this->input->post('cliente');

                $datos = $this->cliente_model->getRegistrosAdicionalj($idauxi, 2);
                foreach($datos as $dato){
                    $idcps = $idauxi;
                    $nombre = $dato['nombre'];
                    $cargo = $dato['cargo'];
                    $telefono = $dato['telefono'];
                    $email = $dato['correo'];
                    $notas = $dato['notas'];
                    $result = $this->project_Manager_model->addContact($idcps, $nombre, $cargo, $telefono, $email, $notas);
                }

                echo json_encode($result);
            }
        }

        #Tasks Control
        function tasksControl($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('sucursal_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'namePage' => $appName,
                    'appName' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $controladore = $this->uri->segment(1);
                //$funcione = $this->uri->segment(2);
                //$direccione = $controladore.'/'.$funcione;
                $direccione = $controladore;
                $varName = 'pm_tipos';
                $this->load->model('global_model');
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccione);
                $this->data['servicios'] = $this->global_model->getOpcionesVariable($varName);
                $this->data['tipos']  = $this->sucursal_model->getTipo();
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['centros']  = $this->sucursal_model->viewSucursal();
                
                //$this->load->view('project_manager_view', $this->data);
                $this->load->view('tasks_control_view', $this->data);
            }
        }

        function getTasks(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idworker = $this->input->post('user');

                $this->load->model('project_Manager_model');
                $dataResult = $this->project_Manager_model->getTasks($idworker);

                foreach($dataResult as $data) {
                    switch((int) $data->estado) {
                        case 0:
                            $data->estadoStr = 'Pendiente';
                        break;
                        case 1:
                            $data->estadoStr = 'En Proceso';
                        break;
                        case 2:
                            $data->estadoStr = 'Completado';
                        break;
                        default:
                            $data->estadoStr = 'Pendiente';
                    }
                }

                echo json_encode($dataResult);
            }
        }

        function getUserName(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idworker = (int) $this->session->userdata('iduser');

                $this->load->model('user_model');
                $dataResult = $this->user_model->getDatosUsuario($idworker);

                $dataResult = array(
                    'user' => $dataResult['idcps'],
                    'descrip' => $dataResult['descrip']
                );

                echo json_encode($dataResult);
            }
        }

        function editTaskNotesAndStatus(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);

                $idrec = $this->input->post('idrec');
                $idcps = $this->input->post('cliente');
                $estado = $this->input->post('estado');
                $notas = $this->input->post('notas');

                $this->load->model('project_Manager_model');
                $dataResult =  $this->project_Manager_model->editTaskNotesAndStatus($idrec, $estado, $notas);

                if($dataResult){
                    $resultArray[] = array('valido' => true, 'datos' => $dataResult);
                }else{
                    $resultArray[] = array('valido' => false);
                }

                echo json_encode($resultArray);
            }
        }
    }
?>