<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require 'vendor/autoload.php';
                    
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

    class Producto extends CI_Controller {
        
        function __construct() {
            parent::__construct();
        }
        
        function verProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                $controlador = $this->uri->segment(1);
                $this->load->model('global_model');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['dat_Cat'] = $this->producto_model->viewCat();
                $this->data['dat_Subcat'] = $this->producto_model->viewSubcat();
                $this->data['listProcentro'] = $this->catalog_model->listProcentro();
                $this->data['lst_campos'] = $this->producto_model->getListaCamposProductsMulti();
                $this->load->view('mantenimiento_producto', $this->data);
                $est_sub = array(
                    'sub_est' => 1,
                );

                $this->session->set_userdata($est_sub);
            }
        }
       
        function newProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->uri->segment(2);
                if($idcatalogo!=null && $idcatalogo!=0 ){
                    $idCatalog_slc = array(
                        'idCatalog_slc' => $idcatalogo,
                        'namePage' => "Adicionar " .  $this->session->userdata('appName')
                    );
                    $this->session->set_userdata($idCatalog_slc);
                }
                $this->load->model('inicializacion_model');
                $this->load->model('user_model');
                $this->data['tam'] = $this->inicializacion_model->getTableTamano();
                
                $this->load->model('producto_model');
                $this->data['linea'] = $idcatalogo;
                $tipo = $this->session->userdata('tipo_pro_listado');
                if($tipo!="" && $tipo!=null){
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipo);
                     $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipo);
                }else{
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                     $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentos();
                }

                $derechos = $this->user_model->getDerechos();

                $permite = 0;
                if($derechos!=""){
                    $pos = strpos($derechos, "costo");
                    if($pos !== false){
                        if($pos>=0){
                            $permite=1;
                        }   
                    }
                }
                $this->data['permite_costo'] = $permite;                
                $this->data['tipo_pro'] = $tipo;
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['proveedor'] = $this->producto_model->getProvee();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['medidas'] = $this->producto_model->verUM();
                $this->data['marcas'] = $this->producto_model->verMarca();
                $this->data['presenta'] = $this->producto_model->verPresenta();
                $this->load->view('new_producto', $this->data);
            }
        }
        
        function verListaProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idApp = $this->uri->segment(2);
                $this->load->model('user_model');
                $this->load->model('configuracion_model');
                $result = $this->configuracion_model->confirmarAccesoApp($idApp);
                $result == true ?: redirect('CerrarSesion');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'tipo_pro_listado' => $opcionmenu
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('inicializacion_model'); $this->load->model('producto_model');
                $this->load->model('global_model'); $this->load->model('variable_model');
                
                $this->data['tam'] = $this->inicializacion_model->getTableTamano();
                //$this->data['productos'] = $this->producto_model->viewProductos();
                $this->data['tipos'] = $this->producto_model->getTipoProd();
                $this->data['ficha'] = $this->producto_model->viewFicha();
                $this->data['PName'] = $appName;
                $this->data['lineaPredeterminada'] = $this->variable_model->getLineaPred();
                $nombrevar = 'prod_factor';
                $this->data['prod_factor'] = $this->global_model->getValorNumVariable($nombrevar);
                $this->data['sy_webstore'] = $this->global_model->getValorNumVariable('sy_webstore');
                $this->data['prodCaracteristicas'] = $this->global_model->getValorNumVariable('mant_prodtabs');
                
                if($opcionmenu!="" && $opcionmenu!=null){
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($opcionmenu);
                    $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($opcionmenu);
                    $this->data['descrip_protipo'] = $this->variable_model->getDescripVar("gv_protipo", $opcionmenu);
                }else{
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                    $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentos();
                    $this->data['descrip_protipo']="TODOS";
                }
                
                $this->data['departamentosTipoProducto'] = $this->producto_model->getDepartamentosTipoProducto();
                $derechos = $this->user_model->getDerechos();
                
                $permite = 0;
                if($derechos!=""){
                    $pos = strpos($derechos, "costo");
                    if($pos !== false){
                        if($pos>=0){
                            $permite=1;
                        }   
                    }
                }
                $this->data['permite_costo'] = $permite;
                
                $producto_data = array(
                    'descrip_pro' => "",
                    'modelo' => "",
                    'marca' => "",
                    'barcode' => "",
                    'costounitario' => "",
                    'precioventa' => "",
                    'xpos' => "",
                    'tipo' => "",
                    'tipotax' => "",
                    'notas' => "",
                    'opt' => "0",
                    'um' => "",
                    'upp' => "",
                    'presenta' => "",
                    'tasaaran' => "",
                    'numaran' => "",
                    'codescrip' => "",
                    'comision' => "",
                    'descuento' => ""
                );
                $this->session->set_userdata($producto_data);
                $this->load->model('global_model');
				$controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->load->view('mantenimiento_promulti', $this->data);
            }
        }
        
        function verProductosDepar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $id = $this->input->post('iddepartamento');
                $estado = $this->input->post('estado');

                $this->load->model('producto_model');

                $fieldsExists = false;
                $fieldsArray = ['pro_color', 'pro_formato', 'pro_uso', 'pro_borde', 'pro_pasta', 'pro_acabado', 'pro_caras', 'pro_espesor', 'pro_aspecto', 'pro_talla', 'pro_m2caja', 'pro_m2peso', 'pro_cajapeso', 'pro_pei', 'pro_formageo'];
                foreach($fieldsArray as $field){
                    if($this->producto_model->verifyIfFieldExists($field, 'invproducts') == true){
                        $fieldsExists = true;
                    }else{
                        $fieldsExists = false;
                        break;
                    }
                }
               
                $array = $this->producto_model->getviewProductos($id,$estado, $fieldsExists);
                echo json_encode($array);
            }
        }
        function verProductosDeparGastos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $id = $this->input->post('iddepartamento');
                $estado = $this->input->post('estado');
               
                $this->load->model('producto_model');
                $array = $this->producto_model->getviewProductosGastos($id,$estado);
                
                echo json_encode($array);
            }
        }
        #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #------------------------------------------------------------------------------------ MANTENIMIENTO PRODUCTOS --------------------- J ---------------------------------------------------------------------------------------------------------------------------
        #   GET DATA
        public function getData()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else {
                $this->load->model('producto_model');
                $this->load->model('contabilidad_model');

                $tipo = (int)$this->input->post("tipo");
                switch ($tipo) {
                    #   PRODUCTO
                    #   MATERIA
                    #   INSUMO
                    case 1:
                    case 2:
                    case 3:
                        if (($medidas = $this->producto_model->getData(0)) &&
                            ($taxs = $this->producto_model->getData(1)) &&
                            ($marcas = $this->producto_model->getData(2)) &&
                            ($presentas = $this->producto_model->getData(3)) &&
                            ($proveedores = $this->producto_model->getData(4))) {
                            $Datos = [];
                            $Datos1 = [];
                            $Datos2 = [];
                            $Datos3 = [];
                            $Datos4 = [];
                            if ($medidas->num_rows() > 0) {
                                $cont = 0;
                                foreach ($medidas->result() as $dato) {
                                    $Datos[] = array(
                                        'ID' => $cont,
                                        'Name' => trim(str_replace(array("\n", "\r", "\n\r"), " ", $dato->um))
                                    );
                                    $cont++;
                                }
                            }
                            if ($taxs->num_rows() > 0) {
                                foreach ($taxs->result() as $dato) {
                                    $Datos1[] = array(
                                        'ID' => (int)$dato->valor_num,
                                        'Name' => trim(str_replace(array("\n", "\r", "\n\r"), " ", $dato->descripcion))
                                    );
                                }
                            }
                            if ($marcas->num_rows() > 0) {
                                $cont = 0;
                                foreach ($marcas->result() as $dato) {
                                    $Datos2[] = array(
                                        'Name' => trim(str_replace(array("\n", "\r", "\n\r"), " ", $dato->marca))
                                    );
                                    $cont++;
                                }
                            }
                            if ($presentas->num_rows() > 0) {
                                $cont = 0;
                                foreach ($presentas->result() as $dato) {
                                    $Datos3[] = array(
                                        'ID' => $cont,
                                        'Name' => trim(str_replace(array("\n", "\r", "\n\r"), " ", $dato->presenta))
                                    );
                                    $cont++;
                                }
                            }
                            if ($proveedores->num_rows() > 0) {
                                foreach ($proveedores->result() as $dato) {
                                    $Datos4[] = array(
                                        'ID' => (int)$dato->idauxi,
                                        'Name' => $dato->descrip
                                    );
                                }
                            }
                            if ($ID = $this->input->post("ID")) {
                                if ($dato = $this->producto_model->getProducto($ID)) {
                                    $datA[] = array('valido' => true);
                                    $datA[] = array(
                                        'medidas' => $Datos,
                                        'taxs' => $Datos1,
                                        'marcas' => $Datos2,
                                        'presentas' => $Datos3,
                                        'proveedores' => $Datos4,
                                        'dato' => $this->CDProducto($dato)
                                    );
                                } else $datA[] = array('valido' => false);
                            } else {
                                $datA[] = array('valido' => true);
                                $datA[] = array(
                                    'medidas' => $Datos,
                                    'taxs' => $Datos1,
                                    'marcas' => $Datos2,
                                    'presentas' => $Datos3,
                                    'proveedores' => $Datos4
                                );
                            }
                        } else $datA[] = array('valido' => false);
                    break;
                    #   SERVICIO
                    case 4:
                        if (($medidas = $this->producto_model->getData(0)) &&
                            ($taxs = $this->producto_model->getData(1))) {
                            $Datos = [];
                            $Datos1 = [];
                            if ($medidas->num_rows() > 0) {
                                $cont = 0;
                                foreach ($medidas->result() as $dato) {
                                    $Datos[] = array(
                                        'ID' => $cont,
                                        'Name' => trim(str_replace(array("\n", "\r", "\n\r"), " ", $dato->um))
                                    );
                                    $cont++;
                                }
                            }
                            if ($taxs->num_rows() > 0) {
                                foreach ($taxs->result() as $dato) {
                                    $Datos1[] = array(
                                        'ID' => (int)$dato->valor_num,
                                        'Name' => trim(str_replace(array("\n", "\r", "\n\r"), " ", $dato->descripcion))
                                    );
                                }
                            }
                            if ($ID = $this->input->post("ID")) {
                                if ($dato = $this->producto_model->getProducto($ID)) {
                                    $datA[] = array('valido' => true);
                                    $datA[] = array(
                                        'medidas' => $Datos,
                                        'taxs' => $Datos1,
                                        'dato' => $this->CDProducto($dato)
                                    );
                                } else $datA[] = array('valido' => false);
                            } else {
                                $datA[] = array('valido' => true);
                                $datA[] = array(
                                    'medidas' => $Datos,
                                    'taxs' => $Datos1
                                );
                            }
                        } else $datA[] = array('valido' => false);
                    break;
                    #   GASTOS
                    case 9:
                        $listaCatalogo = $this->producto_model->getCatalog();
                        $listaTax = $this->producto_model->getTipoTax();
                        $listaCuentas = $this->contabilidad_model->getCtCuentas(4, 3);
                        $listaMedidas = $this->producto_model->getDataUM(9);

                        $datA[] = array('valido' => true);

                        if ($ID = $this->input->post("ID")) {
                            $dato = $this->producto_model->getProducto($ID);
                            $datA[] = array('listaCatalogo'=>$listaCatalogo, 'listaTax'=>$listaTax, 'listaCuentas'=>$listaCuentas, 'listaUm'=>$listaMedidas, 'dato'=>$dato);

                        }else{
                            $datA[] = array('listaCatalogo'=>$listaCatalogo, 'listaTax'=>$listaTax, 'listaCuentas'=>$listaCuentas, 'listaUm'=>$listaMedidas);

                        }
                    break;
                }
                echo json_encode($datA);
            }
        }
        #   CONVERTIR DATA DE PRODUCTO
        private function CDProducto($dato)
        {
            $fieldsExists = false;
            $fieldsArray = ['pro_color', 'pro_formato', 'pro_uso', 'pro_borde', 'pro_pasta', 'pro_acabado', 'pro_caras', 'pro_espesor', 'pro_aspecto', 'pro_talla', 'pro_m2caja', 'pro_m2peso', 'pro_cajapeso', 'pro_pei', 'pro_formageo'];
            foreach($fieldsArray as $field){
                if($this->producto_model->verifyIfFieldExists($field, 'invproducts') == true){
                    $fieldsExists = true;
                }else{
                    $fieldsExists = false;
                    break;
                }
            }

            if($fieldsExists == true){
                $Dato = array(
                    'ID' => $dato->idproducto,
                    'descripcion' => $dato->descrip,
                    'modelo' => ($dato->modelo != null) ? $dato->modelo : '',
                    'marca' => $dato->marca,
                    'barcode' => ($dato->barcode != null) ? $dato->barcode : '',
                    'IDLinea' => $dato->idcatalogo,
                    'idproveedor' => (int)$dato->idprovee,
                    'costou' => $dato->costounitario,
                    'precio' => $dato->precioventa,
                    'tax' => (int)$dato->tipotax,
                    'noSujeto' => (int)$dato->nosujeta,
                    'comision' => ($dato->comision != null) ? $dato->comision : '',
                    'descuento'=> ($dato->descuento != null) ? $dato->descuento : '',
                    'um' => $dato->um,
                    'upp' => floatval($dato->upp),
                    'presenta' => ($dato->presenta != null) ? $dato->presenta : '',
                    'tasa' => ($dato->coarancel != null) ? $dato->coarancel : '',
                    'numeroA' => ($dato->copartida != null) ? $dato->copartida : '',
                    'descripA' => ($dato->codescrip != null) ? $dato->codescrip : '',
                    'estado' => (int)$dato->estado,
                    'xpos' => ($dato->xpos != null) ? $dato->xpos : '',
                    'notas' => ($dato->notas != null) ? $dato->notas : '',
                    'imagen' => $dato->imagen,

                    'proColor' => $dato->pro_color,
                    'proFormato' => $dato->pro_formato,
                    'proUso' => $dato->pro_uso,
                    'proBorde' => $dato->pro_borde,
                    'proPasta' => $dato->pro_pasta,
                    'proAcabado' => $dato->pro_acabado,
                    'proCaras' => $dato->pro_caras,
                    'proEspesor' => $dato->pro_espesor,
                    'proAspecto' => $dato->pro_aspecto,
                    'proTalla' => $dato->pro_talla,
                    'proM2Caja' => number_format($dato->pro_m2caja, 2, '.', ''),
                    'proM2Peso' => number_format($dato->pro_m2peso, 2, '.', ''),
                    'proPesoCaja' => number_format($dato->pro_cajapeso, 2, '.', ''),
                    'proPei' => $dato->pro_pei,
                    'proFormaGeo' => $dato->pro_formageo,
                );
            }else{
                $Dato = array(
                    'ID' => $dato->idproducto,
                    'descripcion' => $dato->descrip,
                    'modelo' => ($dato->modelo != null) ? $dato->modelo : '',
                    'marca' => $dato->marca,
                    'barcode' => ($dato->barcode != null) ? $dato->barcode : '',
                    'IDLinea' => $dato->idcatalogo,
                    'idproveedor' => (int)$dato->idprovee,
                    'costou' => $dato->costounitario,
                    'precio' => $dato->precioventa,
                    'tax' => (int)$dato->tipotax,
                    'noSujeto' => (int)$dato->nosujeta,
                    'comision' => ($dato->comision != null) ? $dato->comision : '',
                    'descuento'=> ($dato->descuento != null) ? $dato->descuento : '',
                    'um' => $dato->um,
                    'upp' => floatval($dato->upp),
                    'presenta' => ($dato->presenta != null) ? $dato->presenta : '',
                    'tasa' => ($dato->coarancel != null) ? $dato->coarancel : '',
                    'numeroA' => ($dato->copartida != null) ? $dato->copartida : '',
                    'descripA' => ($dato->codescrip != null) ? $dato->codescrip : '',
                    'estado' => (int)$dato->estado,
                    'xpos' => ($dato->xpos != null) ? $dato->xpos : '',
                    'notas' => ($dato->notas != null) ? $dato->notas : '',
                    'imagen' => $dato->imagen
                );
            }
            return $Dato;
        }
        #   SET PRODUCTO
        public function setProducto()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else {
                $this->load->model('producto_model');
                $conteo = (int)$this->input->post("conteo");
                $tipo = (int)$this->input->post("tipo");
                $Linea = $this->input->post('linea');
                date_default_timezone_set('America/El_Salvador');
                $sen = false;
                $error = '';
                if ($this->producto_model->LineaActiva($Linea)) {
                    if ($conteo > 0) {
                        $size = $_FILES['Archivo']['size'];
                        $ext = $_FILES['Archivo']['name'];
                        do {
                            $conteo = $this->producto_model->getContImage($tipo);
                            $nombrei = "imgProduct"."_".$conteo."_".rand(10,1000).".".pathinfo($ext, PATHINFO_EXTENSION);
                        } while (!$this->producto_model->validateNameImage($nombrei, $tipo));
                        $config['upload_path']= "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $config['file_name'] = $nombrei;
                        $config['max_size'] = 200;
                        $this->load->library('upload',$config);
                        if ($this->upload->do_upload('Archivo')) $sen = true;
                        else {
                            $sen = false;
                            $error = $this->upload->display_errors();
                            if (($size / 1024) > 200) $error = 'sizeImagen';
                        }//*/
                    } else {
                        $nombrei = '';
                        $sen = true;
                    }
                    if ($sen) {
                        $valido = true;
                        switch ($tipo) {
                            #   PRODUCTO
                            case 1:
                                $fieldsExists = false;
                                $fieldsArray = ['pro_color', 'pro_formato', 'pro_uso', 'pro_borde', 'pro_pasta', 'pro_acabado', 'pro_caras', 'pro_espesor', 'pro_aspecto', 'pro_talla', 'pro_m2caja', 'pro_m2peso', 'pro_cajapeso', 'pro_pei', 'pro_formageo'];
                                foreach($fieldsArray as $field){
                                    if($this->producto_model->verifyIfFieldExists($field, 'invproducts')){
                                        $fieldsExists = true;
                                    }else{
                                        $fieldsExists = false;
                                        break;
                                    }
                                }

                                if($fieldsExists == true){
                                    $data = array(
                                        'descrip' => $this->input->post('nombre'),
                                        'modelo' => $this->input->post('modelo'),
                                        'marca' => $this->input->post('marca'),
                                        'barcode' => $this->input->post('barcode'),
                                        'idcatalogo' => $Linea,
                                        'idprovee' => $this->input->post('idproveedor'),
                                        'costounitario' => $this->input->post('costo'),
                                        'precioventa' => $this->input->post('precio'),
                                        'tipo' => $tipo,
                                        'tipotax' => $this->input->post('impuesto'),
                                        'nosujeta' => $this->input->post('noSujeto'),
                                        'um' => $this->input->post('unidad'),
                                        'upp' => $this->input->post('upp'),
                                        'presenta' => $this->input->post('presenta'),
                                        'coarancel' => $this->input->post('tasa'),
                                        'copartida' => $this->input->post('numero'),
                                        'codescrip' => $this->input->post('descripcionA'),
                                        'comision' => $this->input->post('comision'),
                                        'descuento' => $this->input->post('descuento'),

                                        'pro_color' => ($this->input->post('color') == null) ? '' : $this->input->post('color'),
                                        'pro_formato' => ($this->input->post('formato') == null) ? '': $this->input->post('formato'),
                                        'pro_uso' => ($this->input->post('uso') == null) ? '': $this->input->post('uso'),
                                        'pro_borde' => ($this->input->post('borde') == null) ? '': $this->input->post('borde'),
                                        'pro_pasta' => ($this->input->post('pasta') == null) ? '': $this->input->post('pasta'),
                                        'pro_acabado' => ($this->input->post('acabado') == null) ? '': $this->input->post('acabado'),
                                        'pro_caras' => ($this->input->post('caras') == null) ? '': $this->input->post('caras'),
                                        'pro_espesor' => ($this->input->post('espesor') == null) ? '': $this->input->post('espesor'),
                                        'pro_aspecto' => ($this->input->post('aspecto') == null) ? '': $this->input->post('aspecto'),
                                        'pro_talla' => ($this->input->post('talla') == null) ? '': $this->input->post('talla'),
                                        'pro_m2caja' => ($this->input->post('m2Caja') == null) ? '': $this->input->post('m2Caja'),
                                        'pro_m2peso' => ($this->input->post('m2Peso') == null) ? '': $this->input->post('m2Peso'),
                                        'pro_cajapeso' => ($this->input->post('pesoCaja') == null) ? '': $this->input->post('pesoCaja'),
                                        'pro_pei' => ($this->input->post('pei') == null) ? '': $this->input->post('pei'),
                                        'pro_formageo' => ($this->input->post('formaGeo') == null) ? '': $this->input->post('formaGeo'),
    
                                        'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                                        'imagen' => $nombrei,
                                        'xpos' => $this->input->post("xpos"),
                                        'notas' => $this->input->post("notas"),
                                        'whodidit' => $this->session->userdata('iduser'),
                                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                    );
                                }else{
                                    $data = array(
                                        'descrip' => $this->input->post('nombre'),
                                        'modelo' => $this->input->post('modelo'),
                                        'marca' => $this->input->post('marca'),
                                        'barcode' => $this->input->post('barcode'),
                                        'idcatalogo' => $Linea,
                                        'idprovee' => $this->input->post('idproveedor'),
                                        'costounitario' => $this->input->post('costo'),
                                        'precioventa' => $this->input->post('precio'),
                                        'tipo' => $tipo,
                                        'tipotax' => $this->input->post('impuesto'),
                                        'nosujeta' => $this->input->post('noSujeto'),
                                        'um' => $this->input->post('unidad'),
                                        'upp' => $this->input->post('upp'),
                                        'presenta' => $this->input->post('presenta'),
                                        'coarancel' => $this->input->post('tasa'),
                                        'copartida' => $this->input->post('numero'),
                                        'codescrip' => $this->input->post('descripcionA'),
                                        'comision' => $this->input->post('comision'),
                                        'descuento' => $this->input->post('descuento'),
    
                                        'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                                        'imagen' => $nombrei,
                                        'xpos' => $this->input->post("xpos"),
                                        'notas' => $this->input->post("notas"),
                                        'whodidit' => $this->session->userdata('iduser'),
                                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                    );
                                }

                                if (strlen($this->input->post('barcode')) > 0) $valido = $this->producto_model->validateBarcode($this->input->post('barcode'));
                                else $valido = true;
                            break;
                            #   MATERIA
                            #   INSUMO
                            case 2:
                            case 3:
                                $data = array(
                                    'descrip' => $this->input->post('nombre'),
                                    'modelo' => $this->input->post('modelo'),
                                    'marca' => $this->input->post('marca'),
                                    'barcode' => $this->input->post('barcode'),
                                    'idcatalogo' => $Linea,
                                    'idprovee' => $this->input->post('idproveedor'),
                                    'costounitario' => $this->input->post('costo'),
                                    'tipo' => $tipo,
                                    'tipotax' => $this->input->post('impuesto'),
                                    'um' => $this->input->post('unidad'),
                                    'upp' => $this->input->post('upp'),
                                    'presenta' => $this->input->post('presenta'),
                                    'copartida' => $this->input->post('numero'),
                                    'coarancel' => $this->input->post('tasa'),

                                    'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                                    'imagen' => $nombrei,
                                    'xpos' => $this->input->post("xpos"),
                                    'notas' => $this->input->post("notas"),
                                    'whodidit' => $this->session->userdata('iduser'),
                                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                );
                                if (strlen($this->input->post('barcode')) > 0) $valido = $this->producto_model->validateBarcode($this->input->post('barcode'));
                                else $valido = true;
                            break;
                            #   SERVICIO
                            case 4:
                                $data = array(
                                    'descrip' => $this->input->post('nombre'),
                                    'modelo' => $this->input->post('modelo'),
                                    'barcode' => $this->input->post('barras'),
                                    'idcatalogo' => $Linea,
                                    'precioventa' => $this->input->post('precio'),
                                    'tipo' => $tipo,
                                    'tipotax' => $this->input->post('impuesto'),
                                    'nosujeta' => $this->input->post('noSujeto'),
                                    'um' => $this->input->post('unidad'),
                                    'upp' => ($this->input->post('upp') == "true") ? 1 : 0,
                                    'comision' => $this->input->post('comision'),
                                    'descuento' => $this->input->post('descuento'),
                                    'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                                    'imagen' => $nombrei,
                                    'xpos' => $this->input->post("xpos"),
                                    'notas' => $this->input->post("notas"),
                                    'whodidit' => $this->session->userdata('iduser'),
                                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                );
                            break;
                        }
                        if ($valido) {
                            if ($this->producto_model->setProducto($data)) {
                                $id = $this->input->post('Opcdepto');
                                $estado = $this->input->post('Opcestado');
                                $datos = $this->producto_model->getviewProductos($id,$estado);
                                $datA[] = array('valido' => true, 'datos' => $datos);
                            } else {
                                if ($conteo > 0) {
                                    $path = "img_cuentas/".$this->session->userdata('diraccount')."/".$nombrei;
                                    unlink($path);
                                }
                                $datA[] = array('valido' => false, 'sen' => $sen);
                            }
                        } else {
                            if ($conteo > 0) {
                                $path = "img_cuentas/".$this->session->userdata('diraccount')."/".$nombrei;
                                unlink($path);
                            }
                            $datA[] = array('valido' => false, 'sen' => $sen, 'error' => 'barcode');
                        }
                    } else $datA[] = array('valido' => false, 'sen' => $sen, 'error' => $error);
                } else $datA[] = array('valido' => false, 'sen' => $sen, 'error' => 'linea');
                echo json_encode($datA);
            }
        }
        public function setProductoGasto(){
            $this->load->model('producto_model');
            $datos = $this->input->post("datos");
            if($datos['estado'] == 'true'){
                $datos['estado'] = 1;
            }else{
                $datos['estado'] = 0;
            } 
            $datos['tipo'] = 9;
            $datos['whodidit'] = $this->session->userdata('iduser'); 
            $datos['ingresa'] = date_create()->format('Y-m-d H:i:s');
            $resultado = $this->producto_model->setProducto($datos);

            echo json_encode($resultado);
        }

        public function adicionarMultiplesGastos(){
            $this->load->model('producto_model');
            $datos = $this->input->post("datos");

            $datos['tipo'] = 9;
            $datos['whodidit'] = $this->session->userdata('iduser'); 
            $datos['ingresa'] = date_create()->format('Y-m-d H:i:s');
            $resultado = $this->producto_model->adicionarMultiplesGastos($datos);

            echo json_encode($resultado);
        }
        
        #   UPDATE PRODUCTO
        public function updateProducto()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else {
                $this->load->model('producto_model');
                $ID = $this->input->post("ID");
                $conteo = (int)$this->input->post("conteo");
                $tipo = (int)$this->input->post("tipo");
                $Linea = $this->input->post('linea');
                $dato = $this->producto_model->getProducto($ID);
                date_default_timezone_set('America/El_Salvador');
                $sen = false;
                $error = '';
                if ($this->producto_model->LineaActiva($Linea)) {
                    if ($conteo > 0) {
                        $size = $_FILES['Archivo']['size'];
                        $ext = $_FILES['Archivo']['name'];
                        if (trim(strlen($dato->imagen)) > 0) {
                            $nombreActual = explode(".", $dato->imagen)[0];
                            if (strlen($nombreActual) > 0) $nombreold = $nombreActual;
                            else $nombreold = $this->getUpdateNameImagen(pathinfo($ext, PATHINFO_EXTENSION), $tipo);
                        } else $nombreold = $this->getUpdateNameImagen(pathinfo($ext, PATHINFO_EXTENSION), $tipo);
                        $nombrei = $nombreold.".".pathinfo($ext, PATHINFO_EXTENSION);
        
                        $config['upload_path']= "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $config['file_name'] = '123'.$nombrei;
                        $config['max_size'] = 200;
                        $this->load->library('upload',$config);
                        if ($this->upload->do_upload('Archivo')) {
                            $a = $this->upload->data();
                            $sen = true;
                        } else {
                            $sen = false;
                            $error = $this->upload->display_errors();
                            if (($size / 1024) > 200) $error = 'sizeImagen';
                        }
                    } else {
                        $nombrei = "".$dato->imagen;
                        $sen = true;
                    }
                    if ($sen) {
                        $valido = true;
                        $validoEstado = false;
                        switch ($tipo) {
                            #   PRODUCTO
                            case 1:
                                $fieldsExists = false;
                                $fieldsArray = ['pro_color', 'pro_formato', 'pro_uso', 'pro_borde', 'pro_pasta', 'pro_acabado', 'pro_caras', 'pro_espesor', 'pro_aspecto', 'pro_talla', 'pro_m2caja', 'pro_m2peso', 'pro_cajapeso', 'pro_pei', 'pro_formageo'];
                                foreach($fieldsArray as $field){
                                    if($this->producto_model->verifyIfFieldExists($field, 'invproducts')){
                                        $fieldsExists = true;
                                    }else{
                                        $fieldsExists = false;
                                        break;
                                    }
                                }

                                if($fieldsExists == true){
                                    $data = array(
                                        'descrip' => $this->input->post('nombre'),
                                        'modelo' => $this->input->post('modelo'),
                                        'marca' => $this->input->post('marca'),
                                        'barcode' => $this->input->post('barcode'),
                                        'idcatalogo' => $Linea,
                                        'idprovee' => $this->input->post('idproveedor'),
                                        'costounitario' => $this->input->post('costo'),
                                        'precioventa' => $this->input->post('precio'),
                                        'tipotax' => $this->input->post('impuesto'),
                                        'nosujeta' => $this->input->post('noSujeto'),
                                        'um' => $this->input->post('unidad'),
                                        'upp' => $this->input->post('upp'),
                                        'presenta' => $this->input->post('presenta'),
                                        'copartida' => $this->input->post('numero'),
                                        'coarancel' => $this->input->post('tasa'),
                                        'codescrip' => $this->input->post('descripcionA'),
                                        'comision' => $this->input->post('comision'),
                                        'descuento' => $this->input->post('descuento'),

                                        'pro_color' => $this->input->post('color'),
                                        'pro_formato' => $this->input->post('formato'),
                                        'pro_uso' => $this->input->post('uso'),
                                        'pro_borde' => $this->input->post('borde'),
                                        'pro_pasta' => $this->input->post('pasta'),
                                        'pro_acabado' => $this->input->post('acabado'),
                                        'pro_caras' => $this->input->post('caras'),
                                        'pro_espesor' => $this->input->post('espesor'),
                                        'pro_aspecto' => $this->input->post('aspecto'),
                                        'pro_talla' => $this->input->post('talla'),
                                        'pro_m2caja' => $this->input->post('m2Caja'),
                                        'pro_m2peso' => $this->input->post('m2Peso'),
                                        'pro_cajapeso' => $this->input->post('pesoCaja'),
                                        'pro_pei' => $this->input->post('pei'),
                                        'pro_formageo' => $this->input->post('formaGeo'),

                                        'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                                        'imagen' => $nombrei,
                                        'xpos' => $this->input->post("xpos"),
                                        'notas' => $this->input->post("notas"),
                                        'whodidit' => $this->session->userdata('iduser'),
                                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                                    );
                                }else{
                                    $data = array(
                                        'descrip' => $this->input->post('nombre'),
                                        'modelo' => $this->input->post('modelo'),
                                        'marca' => $this->input->post('marca'),
                                        'barcode' => $this->input->post('barcode'),
                                        'idcatalogo' => $Linea,
                                        'idprovee' => $this->input->post('idproveedor'),
                                        'costounitario' => $this->input->post('costo'),
                                        'precioventa' => $this->input->post('precio'),
                                        'tipotax' => $this->input->post('impuesto'),
                                        'nosujeta' => $this->input->post('noSujeto'),
                                        'um' => $this->input->post('unidad'),
                                        'upp' => $this->input->post('upp'),
                                        'presenta' => $this->input->post('presenta'),
                                        'copartida' => $this->input->post('numero'),
                                        'coarancel' => $this->input->post('tasa'),
                                        'codescrip' => $this->input->post('descripcionA'),
                                        'comision' => $this->input->post('comision'),
                                        'descuento' => $this->input->post('descuento'),
                                        'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                                        'imagen' => $nombrei,
                                        'xpos' => $this->input->post("xpos"),
                                        'notas' => $this->input->post("notas"),
                                        'whodidit' => $this->session->userdata('iduser'),
                                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                                    );
                                }

                                if ((strlen($this->input->post('barcode')) > 0) && ($this->input->post('barcode') != $dato->barcode)) $valido = $this->producto_model->validateBarcode($this->input->post('barcode'));
                                else $valido = true;
                                $validoEstado = $this->producto_model->existeInventario($ID);
                            break;
                            #   MATERIA
                            #   INSUMO
                            case 2:
                            case 3:
                                $data = array(
                                    'descrip' => $this->input->post('nombre'),
                                    'modelo' => $this->input->post('modelo'),
                                    'marca' => $this->input->post('marca'),
                                    'barcode' => $this->input->post('barcode'),
                                    'idcatalogo' => $Linea,
                                    'idprovee' => $this->input->post('idproveedor'),
                                    'costounitario' => $this->input->post('costo'),
                                    'tipotax' => $this->input->post('impuesto'),
                                    'um' => $this->input->post('unidad'),
                                    'upp' => $this->input->post('upp'),
                                    'presenta' => $this->input->post('presenta'),
                                    'copartida' => $this->input->post('numero'),
                                    'coarancel' => $this->input->post('tasa'),

                                    'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                                    'imagen' => $nombrei,
                                    'xpos' => $this->input->post("xpos"),
                                    'notas' => $this->input->post("notas"),
                                    'whodidit' => $this->session->userdata('iduser'),
                                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                                );
                                if ((strlen($this->input->post('barcode')) > 0) && ($this->input->post('barcode') != $dato->barcode)) $valido = $this->producto_model->validateBarcode($this->input->post('barcode'));
                                else $valido = true;
                                $validoEstado = $this->producto_model->existeInventario($ID);
                            break;
                            #   SERVICIO
                            case 4:
                                $data = array(
                                    'descrip' => $this->input->post('nombre'),
                                    'modelo' => $this->input->post('modelo'),
                                    'barcode' => $this->input->post('barcode'),
                                    'idcatalogo' => $Linea,
                                    'precioventa' => $this->input->post('precio'),
                                    'tipo' => $tipo,
                                    'tipotax' => $this->input->post('impuesto'),
                                    'nosujeta' => $this->input->post('noSujeto'),
                                    'um' => $this->input->post('unidad'),
                                    'upp' => ($this->input->post('upp') == "true") ? 1 : 0,
                                    'comision' => $this->input->post('comision'),
                                    'descuento' => $this->input->post('descuento'),
                                    'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                                    'imagen' => $nombrei,
                                    'xpos' => $this->input->post("xpos"),
                                    'notas' => $this->input->post("notas"),
                                    'whodidit' => $this->session->userdata('iduser'),
                                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                                );
                                //$validoEstado = $this->producto_model->existeInventario($ID);
                                $validoEstado = false;
                            break;
                        }
                        if ($valido) {
                            if ($validoEstado && ($this->input->post('estado') == "false")) {
                                if ($conteo > 0) {
                                    $path = "img_cuentas/".$this->session->userdata('diraccount')."/123".$nombrei;
                                    unlink($path);
                                }
                                $datA[] = array('valido' => false, 'sen' => $sen, 'error' => 'estado');
                            } else {
                                if ($this->producto_model->updateProductoL($data, $ID)) {
                                    if ($conteo > 0) {
                                        if (trim(strlen($dato->imagen)) > 0) {
                                            $path = "img_cuentas/".$this->session->userdata('diraccount')."/".$dato->imagen;
                                            if (file_exists($path)) unlink($path);
                                        }
                                        rename($a['full_path'],$a['file_path'].$nombrei);
                                    }
                                    $id = $this->input->post('Opcdepto');
                                    $estado = $this->input->post('Opcestado');
                                    $datos = $this->producto_model->getviewProductos($id,$estado);
                                    $datA[] = array('valido' => true, 'datos' => $datos);
                                } else {
                                    if ($conteo > 0) {
                                        $path = "img_cuentas/".$this->session->userdata('diraccount')."/123".$nombrei;
                                        unlink($path);
                                    }
                                    $datA[] = array('valido' => false, 'sen' => $sen);
                                }
                            }
                        } else {
                            if ($conteo > 0) {
                                $path = "img_cuentas/".$this->session->userdata('diraccount')."/123".$nombrei;
                                unlink($path);
                            }
                            $datA[] = array('valido' => false, 'sen' => $sen, 'error' => 'barcode');
                        }
                    } else $datA[] = array('valido' => false, 'sen' => $sen, 'error' => $error);
                } else $datA[] = array('valido' => false, 'sen' => $sen, 'error' => 'linea');
                echo json_encode($datA);
            }
        }

        public function updateProductoGasto(){
            $this->load->model('producto_model');
            $datos = $this->input->post("datos");
            $idproducto = $this->input->post("idproducto");
            date_default_timezone_set('America/El_Salvador');

            if($datos['estado'] == 'true'){
                $datos['estado'] = 1;
            }else{
                $datos['estado'] = 0;
            } 
            $datos['tipo'] = 9;
            $datos['whodidit'] = $this->session->userdata('iduser'); 
            $datos['modifica'] = date_create()->format('Y-m-d H:i:s');
            $resultado = $this->producto_model->updateProductoL($datos, $idproducto);

            echo json_encode($resultado);
        }
        #   GET NOMBRE DE IMAGEN PARA PRODUCTO QUE NO TENIA
        private function getUpdateNameImagen($ext, $tipo)
        {
            $valor = '';
            do {
                $conteo = $this->producto_model->getContImage($tipo);
                $valor = "imgProduct"."_".$conteo."_".rand(10,1000).".".$ext;
            } while (!$this->producto_model->validateNameImage($valor, $tipo));
            return explode(".", $valor)[0];
        }
        public function multiOpciones()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else {
                $this->load->model('producto_model');
                $opcion = (int)$this->input->post("opcion");
                switch ($opcion) {
                    case 1:#    BORRAR PRODUCTO
                        $t = '';
                        $ID = (int)$this->input->post("ID");
                        $id = $this->input->post('Opcdepto');
                        $estado = $this->input->post('Opcestado');
                        $Linea = (int)$this->input->post('linea');
                        $datos = [];

                        if ($this->producto_model->LineaActiva($Linea)) {
                            if (!$this->producto_model->existeInventario($ID)) {
                                if (!$this->producto_model->validateFacturacion($ID)) {
                                    $this->producto_model->deleteProductoL($ID);
                                    $datos = $this->producto_model->getviewProductos($id,$estado);
                                } else $t = 'Error, No se puede eliminar || facturado anteriormente';
                            } else $t = 'Error, No se puede eliminar || con inventario';
                        } else $t = 'Error, No se puede eliminar || a una Linea Inactiva';

                        $datA[] = array('valido' => (($t != '') ? false : true), 'error' => $t, 'datos' => $datos);
                    break;
                    default:$datA[] = array('valido' => false);break;
                }
                echo json_encode($datA);
            }
        }
        #------------------------------------------------------------------------------------ FIN MANTENIMIENTO PRODUCTOS -----------------------------------------------------------------------------------------------------------------------------------------------
        #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #------------------------------------------------------------------------  IMPORTAR PRODUCTOS ----------------------------------------------------------------------------------
            public function importarProductos($idApp)
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('CerrarSesion');
                }else{
                    $controlador = $this->uri->segment(1);
                    $idApp = $this->uri->segment(2);

                    $this->load->model('configuracion_model');
                    $result = $this->configuracion_model->confirmarAccesoApp($idApp);
                    $result == true ?: redirect('CerrarSesion');
                    $opcionmenu = $this->configuracion_model->getProCentro($idApp);

                    $appName = $this->configuracion_model->getAppName($idApp);
                    $resultAppName = array(
                        'iddApp' => $idApp,
                        'appName' => $appName,
                        'namePage' => $appName
                    );
                    $this->session->set_userdata($resultAppName);
                    $this->load->model('global_model');
                    $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                    $this->data['OTipo'] = $opcionmenu;
                    //*/
                    $this->load->view('mantenimiento_ImportProductos', $this->data);
                }
            }
            #   IMPORTAR EXCEL PARA HOJAS
            public function getsheets()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('CerrarSesion');
                } else {
                    require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
                    //  Read your Excel workbook
                    try {
                        $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                        $Excel = $objReader->load($_FILES['file']['tmp_name']);
                    } catch(Exception $e) {
                        die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                    }
                    $Hojas = $Excel->getSheetNames();
                    $Datos = [];
                    foreach ($Hojas as $key => $dato) {
                        $Datos[] = array(
                            'ID' => $key,
                            'Name' => $dato
                        );
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                    echo json_encode($datA);
                }
            }
            #   IMPORTAR PRODUCTOS
            public function IProductos()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('CerrarSesion');
                } else {
                    $this->load->model('producto_model');
                    date_default_timezone_set('America/El_Salvador');
                    require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
                    //  Read your Excel workbook
                    try {
                        $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                        $Excel = $objReader->load($_FILES['file']['tmp_name']);
                    } catch(Exception $e) {
                        die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                    }
                    $hoja = (int)$this->input->post('hoja');
                    $idllave = (int)$this->input->post('llave');
                    $llave = '';
                    $config = $this->input->post('config');
                    $OTipo = (int)$this->input->post('OTipo');
                    #-
                    $CBarras = false;
                    $CPrecios = false;
                    //  Get worksheet dimensions
                    $Excel->setActiveSheetIndex($hoja);
                    $sheet = $Excel->setActiveSheetIndex($hoja);
                    $highestRow = $sheet->getHighestRow(); 
                    $highestColumn = $sheet->getHighestColumn();
                    #   GET LLAVE
                    $EstructuraT = [];
                    $EstructuraUsar = [];
                    $estructura = $this->producto_model->getSheets();
                    foreach ($estructura as $key => $dato) {
                        $dato->id = $key;
                        $EstructuraT[] = $dato;
                        if ($key == $idllave) {
                            $llave = $dato->name;
                        }
                    }
                    #   GET ESTRUCTURA A USAR
                    foreach (explode(';', $config) as $valor) {
                        $dato = explode('-', $valor);
                        //0-0
                        $campo = '';
                        $tipo = 'text';
                        foreach ($estructura as $value) {
                            if ($value->id == $dato[1]) {
                                $campo = $value->name;
                                $tipo = $value->type;
                                break;
                            }
                        }

                        if ($dato[1] == count($estructura)) $campo = 'barras';
                        else if ($dato[1] == (count($estructura) + 1)) $campo = 'precios';

                        if (($campo == 'barras') ||($campo == 'precios')) {
                            switch ($campo) {
                                case 'barras':
                                    $CBarras = true;
                                break;
                                case 'precios':
                                    $CPrecios = true;
                                break;
                            }
                        }

                        $EstructuraUsar[] = array (
                            'IDExcel' => $dato[0],
                            'IDTabla' => $dato[1],
                            'campo' => $campo,
                            'tipo' => $tipo
                        );
                    }
                    #   REESTRUCTURA DE DATOS
                    $Cabezeras = $sheet->rangeToArray('A' . 1 . ':' . $highestColumn . 1,NULL,TRUE,FALSE);
                    $Datos = [];
                    $DatosR = [];
                    for ($row = 2; $row <= $highestRow; $row++) {
                        $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
                        $Registro = [];
                        $RegistroR = [];
                        $PEstado = 'Nuevo';
                        foreach ($EstructuraUsar as $valor) {
                            $valorActual = $rowData[0][$valor['IDExcel']];
                            if ($valor['campo'] == 'idproducto') {
                                $VProducto = $this->producto_model->existeProductoID((int)$valorActual);
                                if ($VProducto != false) $PEstado = 'Actualizar';
                            }
                            if ($valor['tipo'] == 'text' || $valor['tipo'] == 'varchar') {
                                if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                                    $valorActual = '';
                                }
                            }
                            //if (($valor['campo'] != $llave) &&
                            //if (($valor['campo'] != 'barras') &&
                            if (($valor['campo'] != 'idproducto') &&
                                ($valor['campo'] != 'barras') &&
                                ($valor['campo'] != 'precios')
                            ) {
                                if ($valor['campo'] == 'barcode') {
                                    $valorActual = PHPExcel_Style_NumberFormat::toFormattedString($valorActual, "#");
                                }
                                $Registro[$valor['campo']] = $valorActual;
                            }
                            $RegistroR[$valor['campo']] = $valorActual;
                        }
                        $Registro['tipo'] = $OTipo;
                        $RegistroR['tipo'] = $OTipo;
                        $Datos[] = $Registro;
                        $RegistroR['estado'] = $PEstado;
                        $RegistroR['line'] = $row;
                        $DatosR[] = $RegistroR;
                    }
                    $conteoMalos = [];
                    foreach ($Datos as $key => $valor) {
                        if ($DatosR[$key]['estado'] == 'Nuevo') {
                            //$valor['idproducto'] = $DatosR[$key]['idproducto'];
                            $valor['estado'] = 1;
                            $valor['whodidit'] = $this->session->userdata('iduser');
                            $valor['ingresa'] = date_create()->format('Y-m-d H:i:s');
                            if ($ID = $this->producto_model->setIProducto($valor)) {
                                //print_r($valor);
                                if ($CBarras || $CPrecios) {
                                    if ($CBarras) {
                                        if ($DatosR[$key]['barras'] != null && strlen($DatosR[$key]['barras']) > 0) {
                                            foreach (explode(';', $DatosR[$key]['barras']) as $pos => $mbarra) {
                                                $data = array(
                                                    'idproducto' => $ID,
                                                    'idgvar' => 2,
                                                    'descrip' => $mbarra,
                                
                                                    'estatus' => 1,
                                                    'whodidit' => $this->session->userdata('iduser'),
                                                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                                );
                                                $this->producto_model->setOpcionMultiIP($data);
                                            }
                                        }
                                    }
                                    if ($CPrecios) {
                                        if ($DatosR[$key]['precios'] != null && strlen(trim($DatosR[$key]['precios'])) > 0) {
                                            foreach (explode(';', $DatosR[$key]['precios']) as $pos => $mprecio) {
                                                $dator = explode(',', $mprecio);
                                                $data = array(
                                                    'idproducto' => $ID,
                                                    'idgvar' => 1,
                                                    'descrip' => $dator[0],
                                                    'precioventa' => $dator[1],
                                                    'uniconv' => $dator[2],
                                                    'lowrange' => $dator[3],
                                                    'highrange' => $dator[4],
                                                    'estatus' => 1,
                                                    'whodidit' => $this->session->userdata('iduser'),
                                                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                                );
                                                $this->producto_model->setOpcionMultiIP($data);
                                            }
                                        }
                                    }
                                }
                            } else $conteoMalos[] = $valor['idproducto'];
                        } else {
                            $ID = $DatosR[$key]['idproducto'];
                            $valor['whodidit'] = $this->session->userdata('iduser');
                            $valor['modifica'] = date_create()->format('Y-m-d H:i:s');
                            if ($this->producto_model->updateIProducto($ID, $valor)) {
                                if ($CBarras || $CPrecios) {
                                    if ($CBarras) {
                                        if ($DatosR[$key]['barras'] != null && strlen($DatosR[$key]['barras']) > 0) {
                                            foreach (explode(';', $DatosR[$key]['barras']) as $pos => $mbarra) {
                                                $data = array(
                                                    'idproducto' => $ID,
                                                    'idgvar' => 2,
                                                    'descrip' => $mbarra,
                                
                                                    'estatus' => 1,
                                                    'whodidit' => $this->session->userdata('iduser'),
                                                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                                );
                                                $this->producto_model->setOpcionMultiIP($data);
                                            }
                                        }
                                    }
                                    if ($CPrecios) {
                                        if ($DatosR[$key]['precios'] != null && strlen(trim($DatosR[$key]['precios'])) > 0) {
                                            foreach (explode(';', $DatosR[$key]['precios']) as $pos => $mprecio) {
                                                $dator = explode(',', $mprecio);
                                                $conteo = $this->producto_model->conteoMultiPrecio($ID, $dator[0]);
                                                if ($conteo > 0) {
                                                    $IDP = $this->producto_model->getMultiPrecio($ID, $dator[0])->idrec;
                                                    #   update
                                                    $data = array(
                                                        'descrip' => $dator[0],
                                                        'precioventa' => $dator[1],
                                                        'uniconv' => $dator[2],
                                                        'lowrange' => $dator[3],
                                                        'highrange' => $dator[4],
                                                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                                                    );
                                                    $this->producto_model->updateOpcionMultiIP($IDP, $data);
                                                } else {
                                                    #   set
                                                    $data = array(
                                                        'idproducto' => $ID,
                                                        'idgvar' => 1,
                                                        'descrip' => $dator[0],
                                                        'precioventa' => $dator[1],
                                                        'uniconv' => $dator[2],
                                                        'lowrange' => $dator[3],
                                                        'highrange' => $dator[4],
                                                        'estatus' => 1,
                                                        'whodidit' => $this->session->userdata('iduser'),
                                                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                                    );
                                                    $this->producto_model->setOpcionMultiIP($data);
                                                }
                                            }
                                        }
                                    }
                                }
                            } else $conteoMalos[] = $valor['idproducto'];
                        }
                    }

                    $datA[] = array('valido' => ((count($conteoMalos) > 0) ? false : true), 'malos' => implode('-', $conteoMalos));
                    echo json_encode($datA);//*/
                }
            }
            #--------------- NUEVA VERSION
            public function getEstructuraN()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('CerrarSesion');
                } else {
                    $hoja = (int)$this->input->post('hoja');
                    # Opcion 0 - > Ingresar
                    # Opcion 1 - > Actualizar
                    $opcion = (int)$this->input->post('Opcion');
                    $OTipo = (int)$this->input->post('OTipo');
                    require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
                    //  Read your Excel workbook
                    try {
                        $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                        $Excel = $objReader->load($_FILES['file']['tmp_name']);
                    } catch(Exception $e) {
                        die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                    }
                    //  Get worksheet dimensions
                    $Excel->setActiveSheetIndex($hoja);
                    $sheet = $Excel->setActiveSheetIndex($hoja);
                    $highestRow = $sheet->getHighestRow(); 
                    $highestColumn = $sheet->getHighestColumn();
                    $Datos = [];
                    $DatosC = [];
                    $Columns = [];
                    $Requeridos = [];
                    $EstructuraT[] = array(
                        'ID' => -1,
                        'Name' => '  Vacio  ',
                        'permisollave' => false,
                        'notas' => '---Campo no se va a utilizar--',
                        'taken' => false
                    );
                    if ($highestRow >= 2) {
                        $Columnas = null;
                        for ($row = 1; $row <= 1; $row++){
                            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
                            $Columnas = $rowData[0];
                        }
                        #   MÁS DE 2 COLUMNAS (DESCRIP, IDCATALOGO Y TAX)
                        if (count($Columnas) > 2) {
                            $vacio = 0;
                            for ($i=0; $i < count($Columnas); $i++) {
                                if ($Columnas == null || strlen(trim($Columnas[$i])) == 0) {
                                    $vacio++;
                                }
                            }
                            if ($vacio == 0) {
                                $this->load->model('producto_model');
                                $estructura = $this->producto_model->getSheets();
                                #   GET ESTRUCTURA A USAR
                                foreach ($estructura as $key => $dato) {
                                    $notas = '';
                                    //$descripcionA = '';
                                    switch ($dato->name) {
                                        case 'idproducto':
                                            if ($opcion == 1) $Requeridos[] = $key;
                                            $notas = 'Código Interno';
                                        break;
                                        case 'descrip':
                                            $Requeridos[] = $key;
                                            $notas = 'Descripción';
                                        break;
                                        case 'modelo':
                                            $notas = 'Modelo';
                                        break;
                                        case 'marca':
                                            $notas = 'Marca';
                                        break;
                                        case 'barcode':
                                            $notas = 'Código de Barra';
                                        break;
                                        case 'idcatalogo':
                                            $Requeridos[] = $key;
                                            $notas = 'Código de la Línea';
                                        break;
                                        case 'idprovee':
                                            $notas = 'Código del Proveedor';
                                        break;
                                        case 'costounitario':
                                            $notas = 'Costo Unitario';
                                        break;
                                        case 'precioventa':
                                            $notas = 'Precio de Venta con IVA';
                                        break;
                                        case 'tipotax':
                                            $Requeridos[] = $key;
                                            $notas = 'Tipo de Impuesto';
                                        break;
                                        case 'um':
                                            $notas = 'Unidad de Medida';
                                        break;
                                        case 'upp':
                                            $notas = ($OTipo == 1) ? 'Unidades por Carton' : 'P';
                                        break;
                                        case 'presenta':
                                            $notas = 'Presentación';
                                        break;
                                        case 'coarancel':
                                            $notas = 'Tasa Arancelaria';
                                        break;
                                        case 'copartida':
                                            $notas = 'Número de Partida Arancelaria';
                                        break;
                                        case 'codescrip':
                                            $notas = 'Descripción Alterna';
                                        break;
                                        case 'comision':
                                            $notas = 'Comisión';
                                        break;
                                        case 'descuento':
                                            $notas = 'Descuento';
                                        break;
                                        case 'pro_color':
                                            $notas = 'Color';
                                        break;
                                        case 'xpos':
                                            $notas = 'Referencia del código XPOS';
                                        break;
                                        case 'notas':
                                            $notas = 'Notas';
                                        break;
                                    }
                                    if (($dato->name != 'tipo') &&
                                        ($dato->name != 'estado') &&
                                        ($dato->name != 'imagen') &&
                                        ($dato->name != 'idprecio') &&
                                        ($dato->name != 'whodidit') &&
                                        ($dato->name != 'ingresa') &&
                                        ($dato->name != 'modifica')
                                    ) {
                                        if ($opcion == 0) {
                                            if ($dato->name != 'idproducto') {
                                                $EstructuraT[] = array(
                                                    'ID' => $key,
                                                    'Name' => $dato->name,
                                                    'permisollave' => (($dato->name == 'idproducto') || ($dato->name == 'barcode') || ($dato->name == 'xpos') || ($dato->name == 'modelo')) ? true : false,
                                                    'notas' => $notas,
                                                    'taken' => false
                                                );
                                            }
                                        } else {
                                            $EstructuraT[] = array(
                                                'ID' => $key,
                                                'Name' => $dato->name,
                                                //'DA' => $descripcionA,
                                                'permisollave' => (($dato->name == 'idproducto') || ($dato->name == 'barcode') || ($dato->name == 'xpos') || ($dato->name == 'modelo')) ? true : false,
                                                'notas' => $notas,
                                                'taken' => false
                                            );
                                        }
                                    }
                                }
                                #   GENERAR COLUMNAS GRID
                                for ($i=0; $i < count($Columnas); $i++) {
                                    //$datoCol = str_replace(array("#", "/", "\\", "<", ">", "."), "", $Columnas[$i]);
                                    $datoCol = str_replace(array("."), "", $Columnas[$i]);
                                    //$datoCol = "".$Columnas[$i];
                                    $DatosC[] = array(
                                        'columna' => $datoCol,
                                        'idcolumnaT' => -1,
                                        'llave' => false,
                                    );
                                    $Columns[] = array(
                                        'dataField' => $datoCol,
                                        'datatype' => 'string',
                                        'caption' => $datoCol,
                                        'allowSorting' => false,
                                    );
                                }
                                $EstructuraT[] = array(
                                    'ID' => count($estructura),
                                    'Name' => '--Múltiples Barras--',
                                    'permisollave' => false,
                                    'notas' => 'Incluir Múltiples Barras',
                                    'taken' => false
                                );
                                $EstructuraT[] = array(
                                    'ID' => count($estructura) + 1,
                                    'Name' => '--Múltiples Precios--',
                                    'permisollave' => false,
                                    'notas' => 'Incluir Múltiples Precios',
                                    'taken' => false
                                );
                                #   GET DATOS GRID
                                for ($row = 2; $row <= $highestRow; $row++) {
                                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
                                    $datacolumna = $rowData[0];
                                    $dato = [];
                                    for ($i=0; $i < count($datacolumna); $i++) {
                                        $dato["".$DatosC[$i]['columna']] = ''.$datacolumna[$i];
                                    }
                                    $Datos[] = $dato;
                                }
                                $datA[] = array(
                                    'valido' => true,
                                    'datosColumnas' => $DatosC,//VIEJO para los datos
                                    'columnas' => $Columns,
                                    'datos' => $Datos,
                                    'estructura' => $EstructuraT,
                                    'requeridos' => $Requeridos// Campos requeridos
                                );
                            } else $datA[] = array('valido' => false, 'tipo' => -1);
                        } else $datA[] = array('valido' => false, 'tipo' => 0);
                    } else $datA[] = array('valido' => false, 'tipo' => 1);
                    echo json_encode($datA);
                }
            }
            public function validateIProductosN()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('CerrarSesion');
                } else {
                    $this->load->model('producto_model');
                    require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
                    //  Read your Excel workbook
                    try {
                        $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                        $Excel = $objReader->load($_FILES['file']['tmp_name']);
                    } catch(Exception $e) {
                        die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                    }
                    $hoja = (int)$this->input->post('hoja');
                    $idllave = (int)$this->input->post('llave');
                    $llave = '';
                    $config = $this->input->post('config');
                    $OTipo = (int)$this->input->post('OTipo');
                    # Opcion 0 - > Ingresar
                    # Opcion 1 - > Actualizar
                    $Opcion = (int)$this->input->post('Opcion');
                    # VARS Si vienen campos especiales
                    $CBarcode = false;
                    $CBarras = false;
                    $CPrecios = false;
                    //  Get worksheet dimensions
                    $Excel->setActiveSheetIndex($hoja);
                    $sheet = $Excel->setActiveSheetIndex($hoja);
                    $highestRow = $sheet->getHighestRow(); 
                    $highestColumn = $sheet->getHighestColumn();
                    #   GET LLAVE (nombre)
                    $EstructuraT = [];
                    $EstructuraUsar = [];
                    $estructura = $this->producto_model->getSheets();
                    foreach ($estructura as $key => $dato) {
                        $dato->id = $key;
                        $EstructuraT[] = $dato;
                        if ($key == $idllave) {
                            $llave = $dato->name;
                        }
                    }
                    #   GET ESTRUCTURA A USAR INTERNO
                    $conteoRequerido = 0;
                    $valorRequerido = ($Opcion == 0) ? 3 : 4; // si es ingreso no se toma en cuenta columna idproducto
                    foreach (explode(';', $config) as $valor) {
                        $dato = explode('-', $valor);
                        //0-0
                        $campo = '';
                        $tipo = 'text';
                        foreach ($estructura as $value) {
                            if ($value->id == $dato[1]) {
                                $campo = $value->name;
                                $tipo = $value->type;
                                break;
                            }
                        }
                        //  quizas tomar en cuenta opcion
                        if ((strtolower($campo) == 'idproducto') ||
                            (strtolower($campo) == 'descrip') ||
                            (strtolower($campo) == 'idcatalogo') ||
                            (strtolower($campo) == 'tipotax')
                        ) {
                            $conteoRequerido++;
                        }

                        if ($dato[1] == count($estructura)) $campo = 'barras';
                        else if ($dato[1] == (count($estructura) + 1)) $campo = 'precios';

                        if (($campo == 'barcode') ||
                            ($campo == 'barras') ||
                            ($campo == 'precios')
                        ) {
                            switch ($campo) {
                                case 'barcode':
                                    $CBarcode = true;
                                break;
                                case 'barras':
                                    $CBarras = true;
                                break;
                                case 'precios':
                                    $CPrecios = true;
                                break;
                            }
                        }

                        $EstructuraUsar[] = array (
                            'IDExcel' => $dato[0],
                            'IDTabla' => $dato[1],
                            'campo' => $campo,
                            'tipo' => $tipo
                        );
                    }
                    //print_r($EstructuraUsar);
                    $Headers = [];
                    $Datos = [];
                    #   VALIDACIÓN
                    if ($conteoRequerido == $valorRequerido) {
                        #   GET HEADERS PARA GRID
                        $Headers[] = array(
                            'dataField' => 'estado',
                            'caption' => 'Estado',
                            'datatype' => 'string',
                            'format' => '',
                            'aligment' => 'center',
                        );
                        for ($row = 1; $row <= 1; $row++) {
                            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
                            foreach ($EstructuraUsar as $value) {
                                $formato = '';
                                switch ($value['tipo']) {
                                    case 'int':
                                    case 'double':
                                    case 'float':
                                        $tipo = 'number';
                                        if($value['tipo'] != 'int') $formato = '#,##0.00';
                                    break;
                                    case 'varchar':
                                    case 'text':
                                        $tipo = 'string';
                                    break;
                                    case 'date':
                                        $tipo = 'date';
                                        $formato = 'dd/MM/yyyy';
                                    break;
                                    case 'datetime':
                                        $tipo = 'datetime';
                                        $formato = 'dd/MM/yyyy hh:mm:ss';
                                    break;
                                }
                                $Headers[] = array(
                                    'dataField' => $value['campo'],
                                    'caption' => (($value['campo'] == $llave) ? '[Key] ' : '').$rowData[0][$value['IDExcel']],
                                    'datatype' => $tipo,
                                    'format' => $formato,
                                    'alignment' => ($tipo == 'string') ? 'left' : 'center',
                                );//*/
                            }
                        }
                        #-
                        #   VALIDACION DATOS PRINCIPAL (GENERAL)
                        $Cabezeras = $sheet->rangeToArray('A' . 1 . ':' . $highestColumn . 1,NULL,TRUE,FALSE);
                        $CountError = 0;
                        $Llaves = [];
                        for ($row = 2; $row <= $highestRow; $row++) {
                            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
                            $Registro = [];
                            $error = [];
                            $Tipo = null;
                            $Catalogo = null;
                            $TCValido = true;
                            $PEstado = 'Nuevo';
                            $VProducto = null;
                            $VLLaves = [
                                //  MODELO
                                array(
                                    'ce' => false,// viene con error
                                    'vactual' => '',//valor actual del error
                                    'pose' => 0//posicion del error
                                ),
                                //  XPOS
                                array(
                                    'ce' => false,
                                    'vactual' => '',
                                    'pose' => 0
                                ),
                                //  BARCODE
                                array(
                                    'ce' => false,
                                    'vactual' => '',
                                    'pose' => 0
                                )
                            ];
                            
                            foreach ($EstructuraUsar as $valor) {
                                $valorActual = trim($rowData[0][$valor['IDExcel']]);
                                if ($valor['campo'] == $llave) {
                                    if ($valor['campo'] == 'barcode') {
                                        $valorActual = PHPExcel_Style_NumberFormat::toFormattedString($valorActual, "#");
                                    }
                                    $Llaves[] = trim($valorActual);
                                }
                                switch ($valor['tipo']) {
                                    case 'int':
                                        if (!is_numeric($valorActual)) {
                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo debe ser númerico';
                                        } else {
                                            if ((int)$valorActual < 0) {
                                                $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo debe ser mayor o igual a 0';
                                            } else {
                                                #   VALIDAR campos con referencias a otras tablas
                                                if (($valor['campo'] == 'idcatalogo') ||
                                                    ($valor['campo'] == 'idprovee') ||
                                                    ($valor['campo'] == 'tipo') ||
                                                    ($valor['campo'] == 'tipotax') ||
                                                    ($valor['campo'] == 'idproducto')
                                                )
                                                {
                                                    switch ($valor['campo']) {
                                                        case 'idcatalogo':
                                                            //echo "  aqui  ->";
                                                            if ((int)$valorActual == 0) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede ser valor 0';
                                                            } else {
                                                                $Catalogo = $this->producto_model->existeLineaID((int)$valorActual);
                                                                //print_r($Catalogo);
                                                                if (!$Catalogo) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-No existe esa Línea';
                                                                    $TCValido = false;
                                                                } else {
                                                                    if ($Catalogo->estado != 1) {
                                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-No se puede Agregar o Actualizar Producto a una Línea Inactiva';
                                                                    }
                                                                }
                                                            }
                                                        break;
                                                        case 'idprovee':
                                                            if ((int)$valorActual > 0) {
                                                                $VProveedor = $this->producto_model->existeProveedorID((int)$valorActual);
                                                                if (!$VProveedor) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-No existe ese Proveedor';
                                                                }
                                                            }
                                                        break;
                                                        /*case 'tipo':
                                                            if ((int)$valorActual == 0) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede tener valor 0';
                                                            } else {
                                                                //$Tipo = $valorActual;
                                                                $Tipo = $OTipo;
                                                                $VTipo = $this->producto_model->existeTProducto((int)$valorActual);
                                                                if (!$VTipo) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-No existe ese Tipo de Producto';
                                                                    $TCValido = false;
                                                                }
                                                            }
                                                        break;//*/
                                                        case 'tipotax':
                                                            if ((int)$valorActual == 0) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede tener valor 0';
                                                            } else {
                                                                $VtipoTax = $this->producto_model->existeTTax((int)$valorActual);
                                                                if (!$VtipoTax) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-No existe ese Tipo de Tax (Impuesto)';
                                                                }
                                                            }
                                                        break;
                                                        case 'idproducto':
                                                            if ((int)$valorActual == 0) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede tener valor 0';
                                                            } else {
                                                                $VProducto = $this->producto_model->existeProductoID((int)$valorActual);
                                                                if (!$VProducto) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-No existe ese Código de Producto';
                                                                }
                                                                //print_r($VProducto);
                                                                //if ($VProducto != false) $PEstado = 'Actualizar';
                                                                if ($Opcion == 1) $PEstado = 'Actualizar';
                                                            }
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                    break;
                                    case 'varchar':
                                    case 'text':
                                        if (strpos($valorActual, '"') != false) {
                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede llevar comilla doble';
                                        } else if (strpos($valorActual, "'") != false) {
                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede llevar comilla simple';
                                        } else if (strpos($valorActual, '\\') != false) {
                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede llevar pleca invertida';
                                        } else if (strpos($valorActual, "<") != false) {
                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede llevar signo <';
                                        } else if (strpos($valorActual, ">") != false) {
                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede llevar signo >';
                                        } else {
                                            //  VALIDAR CAMPOS CON PERMISO DE LLAVE y barras - precios
                                            if (($valor['campo'] == 'modelo') ||
                                                ($valor['campo'] == 'barcode') ||
                                                ($valor['campo'] == 'xpos') ||
                                                ($valor['campo'] == 'barras') ||
                                                ($valor['campo'] == 'precios')
                                            ) {
                                                switch ($valor['campo']) {
                                                    case 'barcode':
                                                        if ($llave == 'barcode') {
                                                            if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']].'-Código Barra no puede ser vacio y llave al mismo tiempo';
                                                            } else {
                                                                $valorActual = PHPExcel_Style_NumberFormat::toFormattedString($valorActual, "#");
                                                                $valorbar = preg_match("/^([-0-9a-zA-Z])+$/", $valorActual);
                                                                if (!$valorbar) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-Código de Barra debe ser alfanumérico-';
                                                                } else {
                                                                    $VBarcode = $this->producto_model->existeProductoBarcode(trim($valorActual));
                                                                    if ($VBarcode) {
                                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-Código Barra ya esta regisrado para otro producto';
                                                                        $VLLaves[2] = array(
                                                                            'ce' => true,
                                                                            'vactual' => trim($valorActual),
                                                                            'pose' => count($error) - 1
                                                                        );
                                                                    }
                                                                }
                                                            }
                                                        } else {
                                                            if ($valorActual != null && strlen($valorActual) > 0) {
                                                                /*print_r($valorActual);
                                                                echo "---";
                                                                //PHPExcel_Style_NumberFormat::toFormattedString($fvence, "YYYY-MM-DD");
                                                                var_dump($valorbar);
                                                                die();\s//*/
                                                                $valorActual = PHPExcel_Style_NumberFormat::toFormattedString($valorActual, "#");
                                                                $valorbar = preg_match("/^([-0-9a-zA-Z])+$/", $valorActual);

                                                                if (!$valorbar) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-Código de Barra debe ser alfanumérico.-';
                                                                } else {
                                                                    $VBarcode = $this->producto_model->existeProductoBarcode(trim($valorActual));
                                                                    if ($VBarcode) {
                                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-Código Barra ya esta regisrado para otro producto o servicio';
                                                                        $VLLaves[2] = array(
                                                                            'ce' => true,
                                                                            'vactual' => trim($valorActual),
                                                                            'pose' => count($error) - 1
                                                                        );
                                                                    }
                                                                }
                                                            }   
                                                        }
                                                    break;
                                                    case 'modelo':
                                                        if ($llave == 'modelo') {
                                                            if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']].'-Modelo no puede ser vacio y llave al mismo tiempo';
                                                            } else {
                                                                $VModelo = $this->producto_model->existeProductoModelo(trim($valorActual));
                                                                if ($VModelo) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-Modelo ya esta regisrado para otro producto';
                                                                    $VLLaves[0] = array(
                                                                        'ce' => true,
                                                                        'vactual' => trim($valorActual),
                                                                        'pose' => count($error) - 1
                                                                    );
                                                                }
                                                            }
                                                        }
                                                    break;
                                                    case 'xpos':
                                                        if ($llave == 'xpos') {
                                                            if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']].'-XPOS no puede ser vacio y llave al mismo tiempo';
                                                            } else {
                                                                $VModelo = $this->producto_model->existeProductoModelo(trim($valorActual));
                                                                if ($VModelo) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-XPOS ya esta regisrado para otro producto';
                                                                    $VLLaves[1] = array(
                                                                        'ce' => true,
                                                                        'vactual' => trim($valorActual),
                                                                        'pose' => count($error) - 1
                                                                    );
                                                                }
                                                            }
                                                        }
                                                    break;
                                                    case 'barras':
                                                        if ($valorActual != null && strlen($valorActual) > 0) {
                                                            foreach (explode(';', $valorActual) as $key => $value) {
                                                                $valorbar = preg_match("/^([-0-9a-zA-Z])+$/", $value);
                                                                if (!$valorbar) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-Pos.['.$key.'] Código de barra debe ser alfanumérico';
                                                                } else {
                                                                    $VBarcode = $this->producto_model->existeProductoBarcode(trim($value));
                                                                    if ($VBarcode) {
                                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-Código Multi Barra ['.$key.'] ya esta regisrado para otro producto o servicio';
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    break;
                                                    case 'precios':
                                                        if ($valorActual != null && strlen($valorActual) > 0) {
                                                            foreach (explode(';', $valorActual) as $key => $dprecio) {
                                                                $dprecio = explode(',', $dprecio);
                                                                if (count($dprecio) != 5) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']].'-Multi Precio ['.$key.'] parámetros incompletos';
                                                                } else {
                                                                    #   VALIDAR DESCRIPCION DE MULTI PRECIO
                                                                    if (($dprecio[0] == null) || (strlen(trim($dprecio[0])) == 0)) {
                                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-Multi Precio ['.$key.'] Descripción es requerida';
                                                                    }
                                                                    #   VALIDAR PRECIO DE MULTI PRECIO
                                                                    if (!is_numeric($dprecio[1])) {
                                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-Multi Precio ['.$key.'] Precio debe ser valor numérico';
                                                                    } else {
                                                                        if ((float)$dprecio[1] <= 0) {
                                                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Multi Precio ['.$key.'] Precio debe ser mayor que 0';
                                                                        }
                                                                    }
                                                                    #   VALIDAR UNDIAD DE MULTI PRECIO
                                                                    if (!is_numeric($dprecio[2])) {
                                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-Multi Precio ['.$key.'] Unidad de Conversión debe ser valor numérico';
                                                                    } else {
                                                                        if ((float)$dprecio[2] <= 0) {
                                                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Multi Precio ['.$key.'] Unidad de Conversión debe ser mayor que 0';
                                                                        }
                                                                    }
                                                                    #   VALIDAR MIN DE MULTI PRECIO
                                                                    if (!is_numeric($dprecio[3])) {
                                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-Multi Precio ['.$key.'] Valor Mínimo debe ser valor numérico';
                                                                    } else {
                                                                        if ((float)$dprecio[3] <= 0) {
                                                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Multi Precio ['.$key.'] Valor Mínimo debe ser mayor que 0';
                                                                        }
                                                                    }
                                                                    #   VALIDAR MAX DE MULTI PRECIO
                                                                    if (!is_numeric($dprecio[4])) {
                                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-Multi Precio ['.$key.'] Valor Máximo debe ser valor numérico';
                                                                    } else {
                                                                        if ((float)$dprecio[4] <= 0) {
                                                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Multi Precio ['.$key.'] Valor Máximo debe ser mayor que 0';
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    break;
                                                }
                                            }
                                        }
                                    break;
                                    case 'double':
                                    case 'float':
                                        $valorfd = preg_match("/^([0-9])+(\.[0-9]+)?$/", $valorActual);
                                        if (!$valorfd) {
                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo debe ser númerico';
                                        } else {
                                            if ((float)$valorActual < 0) {
                                                $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo debe ser mayor o igual a 0';
                                            }
                                        }
                                    break;
                                    break;
                                    case 'datetime':
                                    break;
                                    case 'date':
                                    break;
                                }
                                $Registro[$valor['campo']] = $valorActual;
                            }
                            $Tipo = $OTipo;
                            /*print_r($error);
                            die();//*/
                            #   Verificar que el tipo de producto del producto
                            #   y que el tipo de producto de la linea sean el mismo
                            if (($TCValido) && ($Catalogo != null) && 
                                ($Catalogo != false) && ($Tipo != null)
                            ) {
                                if ((int)$Tipo != (int)$Catalogo->tipo) {
                                    $error[] = 'Tipo de Producto del Producto y Tipo de Producto de la Línea, no coinciden';
                                }
                            }
                            #   SI se va a actualizar un producto y se pone el valor llave porque otros productos
                            #   lo llevan dara error porque se encontrar el valor con el mismo, por eso hay que quitar el error
                            if ($PEstado == 'Actualizar') {
                                if ($VLLaves[0]['ce'] == true && $llave == 'modelo') {
                                    if ($VProducto->modelo == $VLLaves[0]['vactual']) {
                                        unset($error[$VLLaves[0]['pose']]);
                                    }
                                }
                                if ($VLLaves[1]['ce'] == true && $llave == 'xpos') {
                                    if ($VProducto->xpos == $VLLaves[1]['vactual']) {
                                        unset($error[$VLLaves[1]['pose']]);
                                    }
                                }
                                if ($VLLaves[2]['ce'] == true) {
                                    if ($VProducto->barcode == $VLLaves[2]['vactual']) {
                                        unset($error[$VLLaves[2]['pose']]);
                                    }
                                }
                            }
                            $Registro['estado'] = $PEstado;
                            $Registro['line'] = $row;
                            $Registro['error'] = implode(';', $error);
                            $Registro['cerror'] = (count($error) > 0) ? true : false;
                            if (count($error) > 0) $CountError++;
                            $Datos[] = $Registro;
                        }
                        #   VALIDACION DATOS SECUNDARIA (LLAVE)
                        if ($CountError == 0) {
                            if (count($Datos) > 0) {
                                #   GET IDS - BARCODES - MUMTI PRECIOS
                                $IDS = [];
                                $Barcodes = [];
                                $Precios = [];
                                foreach ($Datos as $valor) {
                                    if ($Opcion == 1) $IDS[] = trim($valor['idproducto']);
                                    if ($valor['estado'] != 'Nuevo') {
                                    }
                                    if ($CBarcode || $CBarras || $CPrecios) {
                                        if ($CBarcode) {
                                            if ($valor['barcode'] != null && strlen($valor['barcode']) > 0) {
                                                $Barcodes[] = 'line-'.$valor['line'].'-'.$valor['barcode'];
                                            }
                                        }
                                        if ($CBarras) {
                                            if ($valor['barras'] != null && strlen($valor['barras']) > 0) {
                                                foreach (explode(';', $valor['barras']) as $key => $value) {
                                                    $Barcodes[] = 'multi-'.$key.'-'.$valor['line'].'-'.$value;
                                                }
                                            }
                                        }
                                        if ($CPrecios) {
                                            if ($valor['precios'] != null && strlen(trim($valor['precios'])) > 0) {
                                                foreach (explode(';', $valor['precios']) as $key => $value) {
                                                    $vprecio = explode(',', $value);
                                                    $Precios[] = $key.'-'.$valor['line'].'-'.$vprecio[0];
                                                }
                                            }
                                        }
                                    }
                                }
                                //print_r($Precios);
                                #   VALIDACION SEGUNDO GRADO
                                $DatosB = [];
                                foreach ($Datos as $valor) {
                                    #   VALIDAR IDS REPETIDOS
                                    $conteoRepetido = 0;
                                    if ($Opcion == 1) {
                                        foreach ($IDS as $ID) {
                                            if ($ID == $valor['idproducto']) {
                                                $conteoRepetido++;
                                                if ($conteoRepetido > 2) break;
                                            }
                                        }
                                        if ($conteoRepetido > 1) {
                                            $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                            $error[] = 'Código de Producto repetido';
                                            $valor['error'] = implode(';', $error);
                                            $valor['cerror'] = (count($error) > 0) ? true : false;
                                            if (count($error) > 0) $CountError++;
                                        }
                                        if ($valor['estado'] != 'Nuevo') {
                                        }
                                    }
                                    #   VALIDACION MODDELOS XPOS BARCODES
                                    $conteoRepetido = 0;
                                    switch ($llave) {
                                        case 'modelo':
                                            foreach ($Llaves as $valorllave) {
                                                if ($valorllave == $valor['modelo']) {
                                                    $conteoRepetido++;
                                                }
                                            }
                                            if ($conteoRepetido > 1) {
                                                $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                $error[] = 'Modelo viene repetido';
                                                $valor['error'] = implode(';', $error);
                                                $valor['cerror'] = (count($error) > 0) ? true : false;
                                                if (count($error) > 0) $CountError++;
                                            }
                                        break;
                                        case 'xpos':
                                            foreach ($Llaves as $valorllave) {
                                                if ($valorllave == $valor['xpos']) {
                                                    $conteoRepetido++;
                                                }
                                            }
                                            if ($conteoRepetido > 1) {
                                                $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                $error[] = 'Xpos viene repetido';
                                                $valor['error'] = implode(';', $error);
                                                $valor['cerror'] = (count($error) > 0) ? true : false;
                                                if (count($error) > 0) $CountError++;
                                            }
                                        break;
                                    }
                                    if ($CBarcode || $CBarras || $CPrecios) {
                                        if ($CBarcode) {
                                            if ($valor['barcode'] != null && strlen($valor['barcode']) > 0) {
                                                foreach ($Barcodes as $key => $value) {
                                                    $valores = explode('-', $value);
                                                    $ubicaicon = ($valores[0] == 'line') ? (' en la línea '.$valores[1]) : (' en la línea '.$valores[2].' en múltiple barra ['.$valores[1].']');
                                                    $valueBar = $valores[count($valores) - 1];
                                                    if ($valueBar == $valor['barcode']) {
                                                        if (($valores[0] == 'line') && ($valores[1] == $valor['line'])) {}
                                                        else {
                                                            $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                            $error[] = 'Código de Barra repetido'.$ubicaicon;
                                                            $valor['error'] = implode(';', $error);
                                                            $valor['cerror'] = (count($error) > 0) ? true : false;
                                                            if (count($error) > 0) $CountError++;//*/
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        if ($CBarras) {
                                            if ($valor['barras'] != null && strlen($valor['barras']) > 0) {
                                                foreach (explode(';', $valor['barras']) as $pos => $mbarra) {
                                                    foreach ($Barcodes as $key => $value) {
                                                        $valores = explode('-', $value);
                                                        $ubicaicon = ($valores[0] == 'line') ? (' en la línea '.$valores[1]) : (' en la línea '.$valores[2].' en múltiple barra ['.$valores[1].']');
                                                        $valueBar = $valores[count($valores) - 1];
                                                        if ($valueBar == $mbarra) {
                                                            if (($valores[0] == 'multi') && ($valores[1] == $pos) && ($valores[2] == $valor['line'])) {}
                                                            else {
                                                                $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                                $error[] = 'Código de Multi Barra['.$pos.'] repetido'.$ubicaicon;
                                                                $valor['error'] = implode(';', $error);
                                                                $valor['cerror'] = (count($error) > 0) ? true : false;
                                                                if (count($error) > 0) $CountError++;//*/
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        if ($CPrecios) {
                                            if ($valor['precios'] != null && strlen(trim($valor['precios'])) > 0) {
                                                foreach (explode(';', $valor['precios']) as $pos => $value) {
                                                    $valorPrecio = explode(',', $value);
                                                    foreach ($Precios as $Dprecio) {
                                                        $valores = explode('-', $Dprecio);
                                                        if ($valores[1] == $valor['line']) {
                                                            if ($valores[0] != $pos) {
                                                                $descripPrecio = $valores[2];
                                                                $ubicacion = ' en multi precio ['.$valores[0].']';
                                                                if ($descripPrecio == $valorPrecio[0]) {
                                                                    $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                                    $error[] = 'Multi Precio ['.$pos.'] Descripción repetida '.$ubicacion;
                                                                    $valor['error'] = implode(';', $error);
                                                                    $valor['cerror'] = (count($error) > 0) ? true : false;
                                                                    if (count($error) > 0) $CountError++;
                                                                }
                                                            }
                                                        }
                                                        //$ubicacion = ' en línea '.$valores[1].' en multi precio ['.$valores[0].']';
                                                        /*if ($descripPrecio == $valorPrecio[0]) {
                                                            if (($valores[1] == $valor['line']) && ($valores[0] == $pos)) {}
                                                            else {
                                                                $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                                $error[] = 'Multi Precio ['.$pos.'] Descripción repetida '.$ubicacion;
                                                                $valor['error'] = implode(';', $error);
                                                                $valor['cerror'] = (count($error) > 0) ? true : false;
                                                                if (count($error) > 0) $CountError++;
                                                            }
                                                        }//*/
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    #-//*/
                                    $DatosB[] = $valor;
                                }
                                $Datos = $DatosB;
                                //-
                            }
                        }
                        #-
                        $datA[] = array('valido' => (($CountError == 0) ? true : false), 'datos' => $Datos, 'headers' => $Headers, 'tipo' => 1);
                    } else $datA[] = array('valido' => false, 'datos' => $Datos, 'headers' => $Headers, 'tipo' => 0);
                    echo json_encode($datA);//*/
                }
            }
        #-
        #------------------------------------------------------------------------------------ CONFIGURACION DE OPERACIONES --------------------- J ----------------------------------------------------------------------------------------------------------------------
        #   GET GVARS
        public function getOpciones()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('producto_model');
                $valores = $this->input->post("valores");
                $ID = $this->input->post("ID");
                echo json_encode($this->producto_model->getOpciones($valores, $ID));
            }
        }
        #   GET REGISTROS MULTI
        public function getRegistrosMulti()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $ID = $this->input->post("ID");
                $valor = $this->input->post("valor");
                $datos = $this->producto_model->getRegistrosMulti($ID, $valor);
                switch ($valor) { 
                    case 6: 
                        $datos = array(
                            'datos' => $datos,
                            'proveedores' => $this->producto_model->getAuxiliaresMulti(1)
                        );
                    break;
                    case 9: 
                        $datos = array(
                            'datos' => $datos,
                            'clientes' => $this->producto_model->getAuxiliaresMulti(2)
                        );
                    break;
                    case 99: 
                        $datos = array(
                            'datos' => $datos,
                            'productos' => $this->producto_model->getProductosGrupo($ID)
                        );
                    break;
                };
                echo json_encode($datos);
            }

        }
        #   SET MULTI
        public function setOpcionMulti()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $ID = $this->input->post("ID");
                $valor = (int)$this->input->post("valor");
                date_default_timezone_set('America/El_Salvador');
                $data = array(
                    'idproducto' => ($valor == 99) ? 0 : $ID,
                    'idgvar' => $valor,
                    'descrip' => $this->input->post('descripcion'),
                    'estatus' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'askpwd' => ($this->input->post('askpwd') == "true") ? 1 : 0,
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                );
                $valido = false;
                $tipo = 0;
                $tip = 0;
                $nombrei = ''; 
                $er = '';
                switch ($valor) {
                    #  MULTIPLES PRECIOS
                    case 1:
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['lowrange'] = $this->input->post('min');
                        $data['highrange'] = $this->input->post('max');
                        $valido = true;
                    break;
                    #  CODIGOS BARRAS
                    case 2:
                        $valido = $this->producto_model->validateBarcode($this->input->post('descripcion'));//echo ($otro) ? 'true' : 'false';
                    break;
                    #  PROMOCIONES
                    case 3:
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['profecini'] = $this->input->post('fechai');
                        $data['profecfin'] = $this->input->post('fechaf');
                        $data['notas'] = $this->input->post('notas');
                        $valido = true;
                    break;
                    #  IMAGENES
                    case 4:
                        $tipo = 4;
                        $size = $_FILES['file']['size'];
                        $ext = $_FILES['file']['name'];
                        $conteo = $this->producto_model->getContOpcionMulti($ID, $valor);
                        $nombrei = "imgProMulti"."_".$conteo."_".rand(10,1000).".".pathinfo($ext, PATHINFO_EXTENSION);
                        $config['upload_path']= "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $config['file_name'] = $nombrei;
                        $config['max_size'] = 200;
                        //$config['max_size'] = 100;
                        $this->load->library('upload',$config);
                        if ($this->upload->do_upload('file')) {
                            $data['imagen'] = $nombrei;
                            $valido = true;
                            /*if (($size / 1024) > 200) {
                                $rutaImage = $this->upload->data();
                                $config['image_library'] = 'gd2';
                                $config['source_image'] = $rutaImage['full_path'];
                                $config['create_thumb'] = TRUE;
                                $config['maintain_ratio'] = TRUE;
                                $config['width'] = 300;
                                $config['height'] = 300;
                                //$this->load->library('image_lib', $config); 
                                //$this->image_lib->initialize($config);

                                $this->load->library('image_lib');
                                $this->image_lib->initialize($config);
                                $this->image_lib->clear();
                                if (!$this->image_lib->resize()) {
                                    $valido = false;
                                    $tip = 4.6;
                                    $er = $this->image_lib->display_errors();
                                }
                            }//*/
                        } else {
                            $valido = false;
                            $tip = 4.5;
                            $er = $this->upload->display_errors();
                            if (($size / 1024) > 200) $tip = 4.6;
                        }
                    break;
                    #  ESPECIFICACIONES
                    case 5:
                        $data['notas'] = $this->input->post('notas');
                        $valido = true;
                    break;
                    #  PROVEEDOR
                    case 6:
                        $data['idcps'] = $this->input->post('IDCliente');
                        $data['notas'] = $this->input->post('notas');
                        $valido = true;
                    break;
                    #  UNIDADES ALTERNAS
                    case 7:
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['notas'] = $this->input->post('notas');
                        $valido = true;
                    break;
                    #  PRECIOS POR CLIENTE
                    case 9:
                        $data['idcps'] = $this->input->post('IDCliente');
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['notas'] = $this->input->post('notas');
                        $valido = true;
                    break;
                    #  ENLACES EXTERNOS
                    case 10:
                        $data['notas'] = $this->input->post('notas');
                        $valido = true;
                    break;
                    # GRUPO DE PRECIOS
                    case 99:
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['lowrange'] = $this->input->post('min');
                        $data['highrange'] = $this->input->post('max');
                        $data['grupo'] = $this->input->post('grupo');
                        $valido = true;
                    break;
                };
                if ($valido) {
                    if ($this->producto_model->setOpcionMulti($data)) {
                        $datos = $this->producto_model->getRegistrosMulti($ID, $valor);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else {
                        $datA[] = array('valido' => false);
                        if ($tipo == 4 && strlen($nombrei) > 0) {
                            $path = "img_cuentas/".$this->session->userdata('diraccount')."/".$nombrei;
                            unlink($path);
                        }
                    }
                } else $datA[] = array('valido' => false, 'tipo' => $tipo, 'tip' => $tip, 'error' => $er);
                echo json_encode($datA);
            }
        }
        #   UPDATE MULTI
        public function updateOpcionMultiNew()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model'); 
                //RM Modification
                $applyToAll = $this->input->post("applyToAll") == "true";
                $precioAntiguo = $this->input->post("precioAntiguo");
                $IDothers = $this->input->post("IDothers"); 
                //var_dump($IDothers);
                //RM FIN
                $ID = $this->input->post("ID");
                $IDV = $this->input->post("IDV");
                $valor = (int)$this->input->post("valor");
                date_default_timezone_set('America/El_Salvador');
                $data = array(
                    'descrip' => $this->input->post('descripcion'),

                    'estatus' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                switch ($valor) {
                    case 1:
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['lowrange'] = $this->input->post('min');
                        $data['highrange'] = $this->input->post('max');
                    break;
                    case 2:
                    break;
                    case 3:
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['profecini'] = $this->input->post('fechai');
                        $data['profecfin'] = $this->input->post('fechaf');
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 4:
                    break;
                    case 5:
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 6:
                        $data['idcps'] = $this->input->post('IDCliente');
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 7:
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 9:
                        $data['idcps'] = $this->input->post('IDCliente');
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 10:
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 99:
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['lowrange'] = $this->input->post('min');
                        $data['highrange'] = $this->input->post('max');
                    break;
                };  
                /*if($applyToAll){ //RM agrege solo el if
                    if ($this->producto_model->updatePrecioLote($IDV, $valor, $precioAntiguo, $data['precioventa'])) { //RM original updateOpcionMulti($IDV, $data)
                        $datos = $this->producto_model->getRegistrosMulti($ID, $valor);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else $datA[] = array('valido' => false);
                    echo json_encode($datA);//
                    return; RM agrege el return
                } */
                
                if ($this->producto_model->updateOpcionMulti($IDV, $data)) { //RM original updateOpcionMulti($IDV, $data)
                    if($applyToAll){                                
                        foreach($IDothers as $IDV){                                  
                            $this->producto_model->updatePrecioLote($IDV, $valor, $precioAntiguo, $data['precioventa']);                                       
                        }                                                                  
                    }

                    $datos = $this->producto_model->getRegistrosMulti($ID, $valor);
                    $datA[] = array('valido' => true, 'datos' => $datos);  
                }   else $datA[] = array('valido' => false);
                    echo json_encode($datA);
                //
            }
        }

        public function updateOpcionMulti()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $ID = $this->input->post("ID");
                $IDV = $this->input->post("IDV");
                $valor = (int)$this->input->post("valor");
                date_default_timezone_set('America/El_Salvador');
                $data = array(
                    'descrip' => $this->input->post('descripcion'),
                    'askpwd' => ($this->input->post('askpwd') == "true") ? 1 : 0,
                    'estatus' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                switch ($valor) {
                    case 1:
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['lowrange'] = $this->input->post('min');
                        $data['highrange'] = $this->input->post('max');
                    break;
                    case 2:
                    break;
                    case 3:
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['profecini'] = $this->input->post('fechai');
                        $data['profecfin'] = $this->input->post('fechaf');
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 4:
                    break;
                    case 5:
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 6:
                        $data['idcps'] = $this->input->post('IDCliente');
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 7:
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 9:
                        $data['idcps'] = $this->input->post('IDCliente');
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 10:
                        $data['notas'] = $this->input->post('notas');
                    break;
                    case 99:
                        $data['precioventa'] = $this->input->post('precio');
                        $data['uniconv'] = $this->input->post('unidad');
                        $data['lowrange'] = $this->input->post('min');
                        $data['highrange'] = $this->input->post('max');
                    break;
                };  

                    if ($this->producto_model->updateOpcionMulti($IDV, $data)) { //RM original updateOpcionMulti($IDV, $data)
                        $datos = $this->producto_model->getRegistrosMulti($ID, $valor);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else $datA[] = array('valido' => false);
                    echo json_encode($datA);//*/                                     
            }
        }
        #   DELETE MULTI
        public function deleteOpcionMulti()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $IDV = $this->input->post("IDV");
                $valor = (int)$this->input->post("valor");
                if($valor == 4) {
                    $dato = $this->producto_model->getRegistroMultiIDV($IDV);
                    $path = "img_cuentas/".$this->session->userdata('diraccount')."/".$dato->imagen;
                    unlink($path);
                }
                $this->producto_model->deleteOpcionMulti($IDV);
                $datA[] = array('valido' => true);
                echo json_encode($datA);
            }
        }
        #----------------------------   IMPORTAR MULTIPLES PRECIOS
        public function IMPrecios()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                $Datos = [];
                $conteo = 0;
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    if (count($dator) != 6) {
                        $conteo++;
                        $datorr = array (
                            'descripcion' => 'Datos incompletos',
                            'tipo' => -1
                        );
                    } else {
                        $top5 = 0;
                        $producto = $this->producto_model->getProductoTPMulti($dator[0]);
                        if ((count((array)$producto) == 0) || (!is_numeric($dator[0]))) $top5 = 1;
                        else {
                            if ($dator[0] <= 0) $top5 = 1;
                            else {
                                if ((trim(strlen($dator[1])) == 0) || (strpos(trim($dator[1]), "'") !== false) || (strpos(trim($dator[1]), '"') !== false) || (strpos(trim($dator[1]), "\\") !== false) ) $top5 = 2;
                                else {
                                    //-
                                    if (!is_numeric($dator[2])) $top5 = 3;
                                    else {
                                        if ($dator[2] <= 0) $top5 = 3;
                                        else {
                                            if (!is_numeric($dator[3])) $top5 = 4;
                                            else {
                                                if ($dator[3] <= 0) $top5 = 4;
                                                else {
                                                    if (!is_numeric($dator[4])) $top5 = 5;
                                                    else {
                                                        if ($dator[4] <= 0) $top5 = 5;
                                                        else {
                                                            if (!is_numeric($dator[5])) $top5 = 6;
                                                            else {
                                                                if ($dator[5] <= 0) $top5 = 6;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    //-
                                }
                            }
                        }

                        if ($top5 != 0) $conteo++;
                        $datorr = array(
                            'codigo' => $dator[0],
                            'descripcion' => ($top5 == 1) ? '' : $producto->descrip,
                            'descripcionIMP' => $dator[1],
                            'precio' => $dator[2],
                            'unidad' => $dator[3],
                            'min' => $dator[4],
                            'max' => $dator[5],
                            'estado' => ($top5 != 0) ? '' : (($this->producto_model->getCountMultiDesIMP($dator[0], $dator[1]) > 0) ? 'Actualizar' : 'Nuevo') ,
                            'estatus' => ($top5 != 0) ? '' : (($this->producto_model->getCountMultiDesIMP($dator[0], $dator[1]) > 0) ? 1 : 0) ,
                            'tipo' => $top5
                        );
                    }
                    $Datos [] = $datorr;
                }
                $datA[] = array('valido' => (($conteo == 0) ? true : false), 'datos' => $Datos);
                echo json_encode($datA);
            }
        }
        public function setIMPrecios()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                date_default_timezone_set('America/El_Salvador');
                $conteomalos = 0;
                $malos = [];
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    $conteoR = $this->producto_model->getCountMultiDesIMP($dator[0], $dator[1]);
                    if ($conteoR > 0) {
                        //udpate
                        $ID = $this->producto_model->getRegistroMultiIDDescrip($dator[0], $dator[1])->idrec;
                        $data = array(
                            'descrip' => $dator[1],
                            'precioventa' => $dator[2],
                            'uniconv' => $dator[3],
                            'lowrange' => $dator[4],
                            'highrange' => $dator[5],
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                    } else {
                        //set
                        $data = array(
                            'idproducto' => $dator[0],
                            'idgvar' => 1,
                            'descrip' => $dator[1],
                            'precioventa' => $dator[2],
                            'uniconv' => $dator[3],
                            'lowrange' => $dator[4],
                            'highrange' => $dator[5],
                            'estatus' => 1,
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                        );
                    }
                    if ($conteoR > 0) {
                        if (!$this->producto_model->updateOpcionMulti($ID, $data)) {
                            $conteomalos++;
                            $malos[] = $dator[0].','.$dator[1];
                        }
                    } else {
                        if (!$this->producto_model->setOpcionMulti($data)) {
                            $conteomalos++;
                            $malos[] = $dator[0].','.$dator[1];
                        }
                    }
                }
                $malos = implode(";",$malos);
                $datA[] = array('valido' => ($conteomalos > 0) ? false : true, 'malos' => $malos);
                echo json_encode($datA);
            }
        }
        #----------------------------   IMPORTAR DESCUENTOS ARTICULO
        public function IPDescuentos()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                $Datos = [];
                $conteo = 0;
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    if (count($dator) != 2) {
                        $conteo++;
                        $datorr = array (
                            'descripcion' => 'Datos incompletos',
                            'tipo' => -1
                        );
                    } else {
                        $top2 = 0;
                        $producto = $this->producto_model->getProductoTPMulti($dator[0]);
                        if ((count((array)$producto) == 0) || (!is_numeric($dator[0]))) $top2 = 1;
                        else {
                            if ($dator[0] <= 0) $top2 = 1;
                            else {
                                if (!is_numeric($dator[1])) $top2 = 2;
                                else {
                                    if ($dator[1] < 0 || $dator[1] > 100) $top2 = 2;
                                }
                            }
                        }
                        if ($top2 != 0) $conteo++;
                        $datorr = array(
                            'codigo' => $dator[0],
                            'descripcion' => ($top2 == 1) ? '' : $producto->descrip,
                            'descuentoold' => ($top2 == 1) ? '' : $producto->descuento,
                            'descuentonew' => $dator[1],
                            //'estado' => ($top2 != 0) ? '' : (($this->producto_model->getCountMultiDesIMP($dator[0], $dator[1]) > 0) ? 'Actualizar' : 'Nuevo') ,
                            //'estatus' => ($top2 != 0) ? '' : (($this->producto_model->getCountMultiDesIMP($dator[0], $dator[1]) > 0) ? 1 : 0) ,
                            'tipo' => $top2
                        );
                    }
                    $Datos [] = $datorr;
                }
                $datA[] = array('valido' => (($conteo == 0) ? true : false), 'datos' => $Datos);
                echo json_encode($datA);
            }
        }
        public function setIPDescuentos()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                date_default_timezone_set('America/El_Salvador');
                $conteomalos = 0;
                $malos = [];
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    $ID = $dator[0];
                    $data = array(
                        'descuento' => $dator[1],
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if (!$this->producto_model->updateIPDescuentos($ID, $data)) {
                        $conteomalos++;
                        $malos[] = $dator[0];
                    }
                }
                $malos = implode(";",$malos);
                $datA[] = array('valido' => ($conteomalos > 0) ? false : true, 'malos' => $malos);
                echo json_encode($datA);
            }
        }
        #----------------------------   IMPORTAR AD VALOREM
        public function IPAValorem()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                $Datos = [];
                $conteo = 0;
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    if (count($dator) != 3) {
                        $conteo++;
                        $datorr = array (
                            'descripcion' => 'Datos incompletos',
                            'tipo' => -1
                        );
                    } else {
                        $top3 = 0;
                        $producto = $this->producto_model->getProductoTPMulti($dator[0]);
                        if ((count((array)$producto) == 0) || (!is_numeric($dator[0]))) $top3 = 1;
                        else {
                            if ($dator[0] <= 0) $top3 = 1;
                            else {
                                if (!is_numeric($dator[1])) $top3 = 2;
                                else {
                                    if ($dator[1] <= 0) $top3 = 2;
                                    else {
                                        if (!is_numeric($dator[2])) $top3 = 3;
                                        else {
                                            if ($dator[2] <= 0) $top3 = 3;
                                        }
                                    }
                                }
                            }
                        }
                        if ($top3 != 0) $conteo++;
                        $datorr = array(
                            'codigo' => $dator[0],
                            'descripcion' => ($top3 == 1) ? '' : $producto->descrip,
                            'advalorem' => $dator[1],
                            'precios' => $dator[2],
                            'tipo' => $top3
                        );
                    }
                    $Datos [] = $datorr;
                }
                $datA[] = array('valido' => (($conteo == 0) ? true : false), 'datos' => $Datos);
                echo json_encode($datA);
            }
        }
        public function setIPAValorem()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                date_default_timezone_set('America/El_Salvador');
                $conteomalos = 0;
                $malos = [];
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    $ID = $dator[0];
                    $data = array(
                        'copartida' => $dator[1],
                        'coarancel' => $dator[2],
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if (!$this->producto_model->updateIPDescuentos($ID, $data)) {
                        $conteomalos++;
                        $malos[] = $dator[0];
                    }
                }
                $malos = implode(";",$malos);
                $datA[] = array('valido' => ($conteomalos > 0) ? false : true, 'malos' => $malos);
                echo json_encode($datA);
            }
        }
        #----------------------------   IMPORTAR DESCUENTOS MARCA
        public function getIPDMarca()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $datos = $this->producto_model->getIPDMarca();
                $Datos = [];
                if ($datos->num_rows() > 0) {
                    $i = 0;
                    foreach ($datos->result() as $dato) {
                        $Datos[] = array(
                            'index' => $i,
                            'marca' => $dato->marca,
                            'cantidad' => $dato->cantidad,
                            'descuento' => 0,//$dato->descuento
                        );
                        $i++;
                    }
                }
                $datA[] = array('datos' => $Datos);
                echo json_encode($datA);
            }
        }
        public function setIPDMarca()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                date_default_timezone_set('America/El_Salvador');
                $conteomalos = 0;
                $malos = [];
                foreach (explode("IPDMj", $registros) as $registro) {
                    $dator = explode("IPDMRj", $registro);
                    $marca = $dator[0];
                    $data = array(
                        'descuento' => $dator[1],
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    /*echo $marca;
                    print_r($data);//*/
                    if (!$this->producto_model->updateIPDMarca($marca, $data)) {
                        $conteomalos++;
                        $malos[] = $dator[0];
                    }//*/
                }//*/
                $malos = implode(";",$malos);
                $datA[] = array('valido' => ($conteomalos > 0) ? false : true, 'malos' => $malos);
                echo json_encode($datA);
            }
        }
        #----------------------------   IMPORTAR MULTIPLES BARRAS
        public function IPBarras()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                $Datos = [];
                $conteo = 0;
                $Barras = [];
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    $Barras[] = trim($dator[1]);
                }
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    if (count($dator) != 2) {
                        $conteo++;
                        $datorr = array (
                            'descripcion' => 'Datos incompletos',
                            'tipo' => -1
                        );
                    } else {
                        $tipo = 0;
                        $indicacion = '';
                        $producto = $this->producto_model->getProducto($dator[0]);
                        if ((count((array)$producto) == 0) || (!is_numeric($dator[0]))) $tipo = 1;
                        else {
                            if (!is_numeric($dator[0])) $tipo = 1;
                            else {
                                if ((strlen(trim($dator[1])) == 0) || 
                                    (strpos(trim($dator[1]), "'") !== false) || 
                                    (strpos(trim($dator[1]), '"') !== false) || 
                                    (strpos(trim($dator[1]), "\\") !== false) 
                                )
                                {
                                    $tipo = 2;
                                    $indicacion = 'Caraceteres no aceptados';
                                } else {
                                    $valido = $this->producto_model->validateBarcode(trim($dator[1]));
                                    if (!$valido) {
                                        $dato = $this->producto_model->getProductobyBarcode(trim($dator[1]));
                                        $indicacion = '['.$dato->idproducto.'] '.$dato->descrip;
                                        $tipo = 3;
                                    } else {
                                        $cont = 0;
                                        foreach ($Barras as $valor) {
                                            if (trim($dator[1]) == $valor) $cont++;
                                        }
                                        if($cont > 1) {
                                            $indicacion = 'Código de Barra viene repetido';
                                            $tipo = 4;
                                        }
                                    }
                                }
                            }
                        }

                        if ($tipo != 0) $conteo++;
                        $datorr = array(
                            'codigo' => $dator[0],
                            'descripcion' => ($tipo == 0) ? $producto->descrip : $indicacion,//($tipo == 1) ? '' : (($tipo == 2) ? $indicacion : (($tipo == 3) ? $indicacion : $producto->descrip)),
                            'barcode' => trim($dator[1]),
                            'tipo' => $tipo
                        );
                    }
                    $Datos [] = $datorr;
                }
                $datA[] = array('valido' => (($conteo == 0) ? true : false), 'datos' => $Datos);
                echo json_encode($datA);
            }
        }
        public function setIPBarras()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                date_default_timezone_set('America/El_Salvador');
                $conteomalos = 0;
                $malos = [];
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    $ID = $dator[0];
                    $data = array(
                        'idproducto' => $ID,
                        'idgvar' => 2,
                        'descrip' => $dator[1],
    
                        'estatus' => 1,
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if (!$this->producto_model->setOpcionMulti($data)) {
                        $conteomalos++;
                        $malos[] = $dator[0];
                    }
                }
                $malos = implode(";",$malos);
                $datA[] = array('valido' => ($conteomalos > 0) ? false : true, 'malos' => $malos);
                echo json_encode($datA);
            }
        }
        #------------------------------------------------------------------------------------ FIN CONFIGURACIONN DE OPERACIONES -----------------------------------------------------------------------------------------------------------------------------------------
        #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        
        function getFactorProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
               
                $this->load->model('producto_model');
                $array = $this->producto_model->getFactorProducto($idproducto);
                
                echo json_encode($array);
            }
        }
        
        function modificarFactorConversion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $factor = $this->input->post('factor');
               
                $this->load->model('producto_model');
                $array = $this->producto_model->modificarFactorConversion($idproducto, $factor);

                echo json_encode($array);
            }
        }
        
        function verProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
               
                $this->load->model('producto_model');
                $array = $this->producto_model->viewProductos();
                echo json_encode($array);
            }
        }
        
        function getProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $pro = $this->input->post('pro');
                $this->load->model('producto_model');
                $array = $this->producto_model->viewIDproveedor($pro);
                echo json_encode($array);
            }
        }
        
        function registrarProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($this->input->post()){
                    $imagen = 'imagen';
                    $config['upload_path'] = "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $this->load->library('upload', $config);
                    $this->upload->do_upload($imagen);

                    $descrip = $this->input->post('descrip');
                    $modelo = $this->input->post('modelo');
                    $marca = $this->input->post('marca');
                    $barcode = $this->input->post('barcode');
                    $idcatalog = $this->input->post('idcatalogo');
                    $idprovee = $this->input->post('idprovee');
                    $idprov = $this->input->post('idprov');
                    $preUn = $this->input->post('preUni');
                    $preVe = $this->input->post('preVen');
                    $tipo = $this->input->post('tipo_producto');
                    $tipTax = $this->input->post('tipo_tax');
                    $estado = $this->input->post('estado');
                    $xpos = $this->input->post('xpos');
                    $notas = $this->input->post('notas');
                    $option = $this->input->post('saveNext');
                    $whodidit = $this->session->userdata('iduser');
                    $img = $this->input->post('imgen');
                    $um = $this->input->post('um');
                    $upp = $this->input->post('upp');
                    $presenta = $this->input->post('presenta');
                    $comision = $this->input->post('comision');
                    $descuento = $this->input->post('descuento');
                    $codescrip = $this->input->post('codescrip');
                    $numaran = $this->input->post('numaran');
                    $tasaaran = $this->input->post('tasaaran');
                    $this->load->model('producto_model');
                    $this->producto_model->insertProducto($descrip, $modelo, $marca, $barcode, $idcatalog, $idprovee, $idprov, $preUn, $preVe, $tipo, $tipTax, $estado, $xpos, $notas, $option, $whodidit, $img, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran);
                }else{
                    $this->verLocation();
                }
            }
        }
        
        function registrarProducto2(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $des = $this->input->post('descrip');
                $descrip = str_replace(array("\n", "\r", "\n\r"), " ", $des);
                $modelo = $this->input->post('modelo');
                $marca = $this->input->post('marca');
                $barcode = $this->input->post('barcode');
                $idcatalog = $this->input->post('idcatalogo');
                $idprovee = $this->input->post('idprovee');
                $preUn = $this->input->post('preUni');
                $preVe = $this->input->post('preVen');
                $tipo = $this->input->post('tipo_producto');
                $tipTax = $this->input->post('tipo_tax');
                $esta = $this->input->post('estado');
                $xpos = $this->input->post('xpos');
                $not = $this->input->post('notas');
                $notas = str_replace(array("\n", "\r", "\n\r"), " ", $not);
                $whodidit = $this->session->userdata('iduser');
                $img = $this->input->post('imgen');
                $um = $this->input->post('um');
                $upp = $this->input->post('upp');
                $presenta = $this->input->post('presenta');
                $comision = $this->input->post('comision');
                $descuento = $this->input->post('descuento');
                $codescrip = $this->input->post('codescrip');
                $numaran = $this->input->post('numaran');
                $tasaaran = $this->input->post('tasaaran');
                
                if($esta == "true"){
                    $estado = 1;
                }else{
                    $estado = 0;
                }
                $this->load->model('producto_model');
                $nameimagen = $this->producto_model->insertProducto2($descrip, $modelo, $marca, $barcode, $idcatalog, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $xpos, $notas, $whodidit, $img, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran);
                $imgSplit = explode(".", $nameimagen);
                $archivo = 'archivo';
                $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                $config['file_name'] = $imgSplit[0];
                $config['over_write'] = "TRUE";
                $config['allowed_types'] = "gif|jpg|jpeg|png";
                $this->load->library('upload', $config);
                $this->upload->do_upload($archivo); 
                redirect('Productos/'.$this->session->userdata('iddApp'));
            }
        }
        
        function registrarProducto3(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $des = $this->input->post('descrip');
                $descrip = str_replace(array("\n", "\r", "\n\r"), " ", $des);
                $modelo = $this->input->post('modelo');
                $marca = $this->input->post('marca');
                $barcode = $this->input->post('barcode');
                $idcatalog = $this->input->post('idcatalogo');
                $idprovee = $this->input->post('idprovee');
                $preUn = $this->input->post('preUni');
                $preVe = $this->input->post('preVen');
                $tipo = $this->input->post('tipo_producto');
                $tipTax = $this->input->post('tipo_tax');
                $esta = $this->input->post('estado');
                $xpos = $this->input->post('xpos');
                $not = $this->input->post('notas');
                $notas = str_replace(array("\n", "\r", "\n\r"), " ", $not);
                $whodidit = $this->session->userdata('iduser');
                $img = $this->input->post('imgen');
                $um = $this->input->post('um');
                $upp = $this->input->post('upp');
                $presenta = $this->input->post('presenta');
                $comision = $this->input->post('comision');
                $descuento = $this->input->post('descuento');
                $codescrip = $this->input->post('codescrip');
                $numaran = $this->input->post('numaran');
                $tasaaran = $this->input->post('tasaaran');
                if($esta == "true"){
                    $estado = 1;
                }else{
                    $estado = 0;
                }
                
                $this->load->model('producto_model');
                $nameimagen = $this->producto_model->insertProducto2($descrip, $modelo, $marca, $barcode, $idcatalog, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $xpos, $notas, $whodidit, $img, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran);
                $imgSplit = explode(".", $nameimagen);
                $archivo = 'archivo';
                $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                $config['file_name'] = $imgSplit[0];
                $config['over_write'] = "TRUE";
                $config['allowed_types'] = "gif|jpg|jpeg|png";
                $this->load->library('upload', $config);
                $this->upload->do_upload($archivo); 
                echo json_encode(true);
            }
        }
        
        function modificarProducto($idprod, $id){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('producto_model');
                $this->data['prod_dat'] = $this->producto_model->callRegistro($idprod);
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['proveedor'] = $this->producto_model->getProvee();
                $this->data['catalogo'] = $id;
                $this->data['dat_cat'] = $this->producto_model->viewDatsub($id);
                $this->load->view('form_update_producto', $this->data);
            }
        }
        
        function modificarProducto2(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->uri->segment(2);
                $idprod = $this->uri->segment(3);
                $pagina = $this->uri->segment(4);
                $idCatalog_slc = array(
                    'idCatalog_slc' => $idcatalogo,
                    'namePage' => "Modificación de  " .  $this->session->userdata('appName')." ID:". $idprod
                );
                $this->session->set_userdata($idCatalog_slc);
                
                $idPagina = array(
                    'idPagina' => $pagina,
                );
                $this->session->set_userdata($idPagina);
                
                $this->load->model('inicializacion_model');
                $this->load->model('user_model');
                $this->data['tam'] = $this->inicializacion_model->getTableTamano();
                
              
                $this->load->model('cliente_model');
                $this->load->model('producto_model');
                $this->load->model('variable_model');
                $this->data['prod_dat'] = $this->producto_model->callRegistro($idprod);
               
                $linea = $this->producto_model->callLinea($idprod);
                $this->data['permisos'] = $this->producto_model->viewPermisos($linea);
                $tipo = $this->session->userdata('tipo_pro_listado');
                if($tipo!="" && $tipo!=null){
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipo);
                    $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipo);
                }else{
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                    $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentos();
                }

                $derechos = $this->user_model->getDerechos();

                $permite = 0;
                if($derechos!=""){
                    $pos = strpos($derechos, "costo");
                    if($pos !== false){
                        if($pos>=0){
                            $permite=1;
                        }   
                    }
                }
                $this->data['permite_costo'] = $permite;
                
                $this->data['tipo_pro'] = $tipo;
                
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['proveedor'] = $this->producto_model->getProvee();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['medidas'] = $this->producto_model->verUM();
                $this->data['unidadesmed'] = $this->producto_model->verUnidades();
                $this->data['marcas'] = $this->producto_model->verMarca();
                $this->data['vars'] = $this->producto_model->verVars();
                $this->data['vars2'] = $this->producto_model->verVarsPro($idprod);
                $this->data['clientes'] =$this->cliente_model->viewClienteActivo();
                $this->data['clientesFrecuentes'] =$this->cliente_model->viewClientesFrecuentesProducto($idprod);
                $this->data['multi'] = $this->producto_model->verMulti($idprod);
                $this->data['idproducto'] = $idprod;
                $this->data['presenta'] = $this->producto_model->verPresenta();
               
                $this->load->view('form_update_producto2', $this->data);
            }
        }
        
        function verProveedores(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
               
                $this->load->model('producto_model');
                $array = $this->producto_model->getProvee();
                echo json_encode($array);
            }
        }
         
        function verUnidadesMedida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
               
                $this->load->model('producto_model');
                $array = $this->producto_model->verUnidades();
                echo json_encode($array);
            }
        }
        
        function actualizarProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($this->input->post()){
                    $option = $this->input->post("save");
                    if($option == "copy"){
                        $descrip = $this->input->post('descrip');
                        $modelo = $this->input->post('modelo');
                        $marca = $this->input->post('marca');
                        $barcode = $this->input->post('barcode');
                        $idcatalog = $this->input->post('idcatalogo');
                        $idprovee = $this->input->post('idprovee');
                        $preUn = $this->input->post('preUni');
                        $preVe = $this->input->post('preVen');
                        $tipo = $this->input->post('tipo_producto');
                        $tipTax = $this->input->post('tipo_tax');
                        $estado = $this->input->post('estado');
                        $xpos = $this->input->post('xpos');
                        $notas = $this->input->post('notas');
                        $um = $this->input->post('um');
                        $upp = $this->input->post('upp');
                        $presenta = $this->input->post('presenta');
                        $comision = $this->input->post('comision');
                        $descuento = $this->input->post('descuento');
                        $codescrip = $this->input->post('codescrip');
                        $numaran = $this->input->post('numaran');
                        $tasaaran = $this->input->post('tasaaran');
                        $this->load->model('producto_model');
                        $this->producto_model->copiarProducto($descrip, $modelo, $marca, $barcode, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $notas, $xpos, $idcatalog, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran);
                    }else{
                        $imagen = 'imagen';
                        $config['upload_path'] = "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->do_upload($imagen);

                        $idprod = $this->input->post('idprod');
                        $descrip = $this->input->post('descrip');
                        $modelo = $this->input->post('modelo');
                        $marca = $this->input->post('marca');
                        $barcode = $this->input->post('barcode');
                        $idcatalog = $this->input->post('idcatalogo');
                        $idprovee = $this->input->post('idprovee');
                        $preUn = $this->input->post('preUni');
                        $preVe = $this->input->post('preVen');
                        $tipo = $this->input->post('tipo_producto');
                        $tipTax = $this->input->post('tipo_tax');
                        $estado = $this->input->post('estado');
                        $xpos = $this->input->post('xpos');
                        $notas = $this->input->post('notas');
                        $ingresa = $this->input->post('ingresa');
                        $whodidit = $this->session->userdata('iduser');
                        $img = $this->input->post('imgen');
                        $um = $this->input->post('um');
                        $upp = $this->input->post('upp');
                        $presenta = $this->input->post('presenta');
                        $comision = $this->input->post('comision');
                        $descuento = $this->input->post('descuento');
                        $codescrip = $this->input->post('codescrip');
                        $numaran = $this->input->post('numaran');
                        $tasaaran = $this->input->post('tasaaran');
                        $this->load->model('producto_model');
                        $this->producto_model->updateProducto($idprod, $descrip, $modelo, $marca, $barcode, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $notas, $xpos, $ingresa, $whodidit, $img, $idcatalog, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran);
                    }                
                }else{
                    $this->verProducto();
                }
            }
        }
        
        function actualizarProducto2(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $des = $this->input->post('descrip');
                $descrip = str_replace(array("\n", "\r", "\n\r"), " ", $des);
                $modelo = $this->input->post('modelo');
                $marca = $this->input->post('marca');
                $barcode = $this->input->post('barcode');
                $idcatalog = $this->input->post('idcatalogo');
                $idprovee = $this->input->post('idprovee');
                $preUn = $this->input->post('preUni');
                $preVe = $this->input->post('preVen');
                $tipo = $this->input->post('tipo_producto');
                $tipTax = $this->input->post('tipo_tax');
                $esta = $this->input->post('estado');
                $xpos = $this->input->post('xpos');
                $notas = $this->input->post('notas');
                $whodidit = $this->session->userdata('iduser');
                $img = $this->input->post('imgen');
                $imagen = $this->input->post('img');
                $imga = $this->input->post('imga');
                $um = $this->input->post('um');
                $upp = $this->input->post('upp');
                $presenta = $this->input->post('presenta');
                $comision = $this->input->post('comision');
                $descuento = $this->input->post('descuento');
                $codescrip = $this->input->post('codescrip');
                $numaran = $this->input->post('numaran');
                $tasaaran = $this->input->post('tasaaran');
                
                if($esta == "true"){
                        
                    $estado = 1;
                }else{
                    $estado = 0;
                        
                }
                
                
                $this->load->model('producto_model');
                $nameimagen =  $this->producto_model->updateProducto2($idproducto, $descrip, $modelo, $marca, $barcode, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $notas, $xpos,  $whodidit, $img, $imagen, $imga, $idcatalog, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran);
                
                $imgSplit = explode(".", $nameimagen);
                
                $archivo = 'archivo';
                $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                $config['file_name'] = $imgSplit[0];
                $config['over_write'] = "TRUE";
                $config['allowed_types'] = "gif|jpg|jpeg|png";
                $this->load->library('upload', $config);
                $this->upload->do_upload($archivo); 
                 
                redirect('Productos/'.$this->session->userdata('iddApp'));
            }
        }
        
        function actualizarProducto3(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $des = $this->input->post('descrip');
                $descrip = str_replace(array("\n", "\r", "\n\r"), " ", $des);
                $modelo = $this->input->post('modelo');
                $marca = $this->input->post('marca');
                $barcode = $this->input->post('barcode');
                $idcatalog = $this->input->post('idcatalogo');
                $idprovee = $this->input->post('idprovee');
                $preUn = $this->input->post('preUni');
                $preVe = $this->input->post('preVen');
                $tipo = $this->input->post('tipo_producto');
                $tipTax = $this->input->post('tipo_tax');
                $esta = $this->input->post('estado');
                $xpos = $this->input->post('xpos');
                $notas = $this->input->post('notas');
                $whodidit = $this->session->userdata('iduser');
                $img = $this->input->post('imgen');
                $imagen = $this->input->post('img');
                $imga = $this->input->post('imga');
                $um = $this->input->post('um');
                $upp = $this->input->post('upp');
                $presenta = $this->input->post('presenta');
                $comision = $this->input->post('comision');
                $descuento = $this->input->post('descuento');
                $codescrip = $this->input->post('codescrip');
                $numaran = $this->input->post('numaran');
                $tasaaran = $this->input->post('tasaaran');
                
				if($esta == "true"){
                    $estado = 1;
                }else{
                    $estado = 0;
                }
                
                $this->load->model('producto_model');
				
				if($estado == 0){
					$validateInventario = $this->producto_model->validateInventarioProducto($idproducto);
				}else{
					$validateInventario = 0;
				}
				
				if($validateInventario == 0){
					$errorUpdate = 0;
					$nameimagen =  $this->producto_model->updateProducto2($idproducto, $descrip, $modelo, $marca, $barcode, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $notas, $xpos,  $whodidit, $img, $imagen, $imga, $idcatalog, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran);

					$imgSplit = explode(".", $nameimagen);

					$archivo = 'archivo';
					$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
					$config['file_name'] = $imgSplit[0];
					$config['over_write'] = "TRUE";
					$config['allowed_types'] = "gif|jpg|jpeg|png";
					$this->load->library('upload', $config);
					$this->upload->do_upload($archivo);
				}else{
					$errorUpdate = 1;
				}
                
				$array = array(
					"errorUpdate" => $errorUpdate
				);
				
				
                echo json_encode($array);
            }
        }
        
        function actualizarInformacionServicio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $des = $this->input->post('descrip');
                $descrip = str_replace(array("\n", "\r", "\n\r"), " ", $des);
                $modelo = $this->input->post('modelo');
                $marca = $this->input->post('marca');
                $barcode = $this->input->post('barcode');
                $idcatalog = $this->input->post('idcatalogo');
                $idprovee = $this->input->post('idprovee');
                $preUn = $this->input->post('preUni');
                $preVe = $this->input->post('preVen');
                $tipo = $this->input->post('tipo_producto');
                $tipTax = $this->input->post('tipo_tax');
                $esta = $this->input->post('estado');
                $xpos = $this->input->post('xpos');
                $notas = $this->input->post('notas');
                $whodidit = $this->session->userdata('iduser');
                $img = $this->input->post('imgen');
                $imagen = $this->input->post('img');
                $imga = $this->input->post('imga');
                $um = $this->input->post('um');
                $upp = $this->input->post('upp');
                $presenta = $this->input->post('presenta');
                $comision = $this->input->post('comision');
                $descuento = $this->input->post('descuento');
                $codescrip = $this->input->post('codescrip');
                $numaran = $this->input->post('numaran');
                $tasaaran = $this->input->post('tasaaran');
                
				if($esta == "true"){
                    $estado = 1;
                }else{
                    $estado = 0;
                }
                
				if($upp == "true"){
                    $upp = 1;
                }else{
                    $upp = 0;
                }
                
                $this->load->model('producto_model');
				
				if($estado == 0){
					$validateInventario = $this->producto_model->validateInventarioProducto($idproducto);
				}else{
					$validateInventario = 0;
				}
				
				if($validateInventario == 0){
					$errorUpdate = 0;
					$nameimagen =  $this->producto_model->updateProducto2($idproducto, $descrip, $modelo, $marca, $barcode, $idprovee, $preUn, $preVe, $tipo, $tipTax, $estado, $notas, $xpos,  $whodidit, $img, $imagen, $imga, $idcatalog, $um, $upp, $presenta, $comision, $descuento, $codescrip, $numaran, $tasaaran);

					$imgSplit = explode(".", $nameimagen);

					$archivo = 'archivo';
					$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
					$config['file_name'] = $imgSplit[0];
					$config['over_write'] = "TRUE";
					$config['allowed_types'] = "gif|jpg|jpeg|png";
					$this->load->library('upload', $config);
					$this->upload->do_upload($archivo);
				}else{
					$errorUpdate = 1;
				}
                
				$array = array(
					"errorUpdate" => $errorUpdate
				);
				
				
                echo json_encode($array);
            }
        }
        
        function saveBarra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
               
                $idproducto = $this->input->post('idproducto');
                $idgvar = $this->input->post('idgvarb');
                $barcodeb = $this->input->post('barcodeb');
                $estadob = $this->input->post('estadob');
                $whodidit = $this->session->userdata('iduser');
                
                $this->load->model('producto_model');
                
                $this->producto_model->insertBarra($idproducto,$idgvar,$barcodeb,$estadob,$whodidit);
                
                $vars = $this->producto_model->verVars();
                $multi = $this->producto_model->verMulti($idproducto);
                
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                
                
                $datos = array();
                
                $i = 0;
                
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                     foreach($arraay as $fil){ 
                                       if($fil == $va->idrnum){
                    $j = 0;
                    $datosSupIn = array();
                    foreach($multi as $mul){
                        if($mul->idgvar == $va->valor_num){
                            $datosSupIn[$j] = array(
                                "id" => "$mul->idrec",
                                "text" => "$mul->descrip",
                                "orden" => "$mul->askpwd",
                                "titulo" => "$mul->descrip",
                                "precio" => "$mul->precioventa",
                                "unidad" => "$mul->uniconv",
                                "estado" => "$mul->estatus",
                                "fechaini" => "$mul->profecini",
                                "fechafin" => "$mul->profecfin",
                                "idcps" => "$mul->idcps",
                                "imagen" => "$mul->imagen",
                                "notas" => "$mul->notas",
                                "parentId" => "$mul->idgvar",
                                "expanded" => "true"
                            );
                            $j++;
                        }
                         
                    }
                    
                    $datosSupIn[$j] = array(
                        "id" => "0_".round($va->valor_num, 0),
                        "iconSrc" => base_url()."img/add2.png"
                    );
                    
                    $datosIn[$i] = array(
                        "id" => "0_0_".round($va->valor_num, 0),
                        "parentId" => "0",
                        "text" => "$va->descripcion",
                        "items" => $datosSupIn
                    );
                    
                    $i++;
                }}}
                $datos = $datosIn;
                echo json_encode($datos);
            }
        }
        
        function saveUnidad(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
               
                $idproducto = $this->input->post('idproducto');
                $idgvar = $this->input->post('idgvar');
                $unidadcon = $this->input->post('unidadcon');
                $unidadconver = $this->input->post('unidadconver');
                $estadoun = $this->input->post('estadoun');
                $whodidit = $this->session->userdata('iduser');
                
                $this->load->model('producto_model');
                
                $this->producto_model->insertUnidad($idproducto,$idgvar,$unidadcon,$unidadconver,$estadoun,$whodidit);
                
                $vars = $this->producto_model->verVars();
                $multi = $this->producto_model->verMulti($idproducto);
                
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                
                
                $datos = array();
                
                $i = 0;
                
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                     foreach($arraay as $fil){ 
                                       if($fil == $va->idrnum){
                    $j = 0;
                    $datosSupIn = array();
                    foreach($multi as $mul){
                        if($mul->idgvar == $va->valor_num){
                            $datosSupIn[$j] = array(
                                "id" => "$mul->idrec",
                                "text" => "$mul->descrip",
                                "orden" => "$mul->askpwd",
                                "titulo" => "$mul->descrip",
                                "precio" => "$mul->precioventa",
                                "unidad" => "$mul->uniconv",
                                "estado" => "$mul->estatus",
								"fechaini" => "$mul->profecini",
                                "fechafin" => "$mul->profecfin",
                                "idcps" => "$mul->idcps",
                                "imagen" => "$mul->imagen",
                                "notas" => "$mul->notas",
                                "parentId" => "$mul->idgvar",
                                "expanded" => "true"
                            );
                            $j++;
                        }
                         
                    }
                    
                    $datosSupIn[$j] = array(
                        "id" => "0_".round($va->valor_num, 0),
                        "iconSrc" => base_url()."img/add2.png"
                    );
                    
                    $datosIn[$i] = array(
                        "id" => "0_0_".round($va->valor_num, 0),
                        "parentId" => "0",
                        "text" => "$va->descripcion",
                        "items" => $datosSupIn
                    );
                    
                    $i++;
                }}}
                $datos = $datosIn;
                echo json_encode($datos);
            }
        }
        
        function actualizarUnidad(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
               
                $idrec = $this->input->post('idrec');
                $idproducto = $this->input->post('idproducto');
                $idgvar = $this->input->post('idgvar');
                $unidadcon = $this->input->post('unidadcon');
                $unidadconver = $this->input->post('unidadconver');
                $estadoun = $this->input->post('estadoun');
                $whodidit = $this->session->userdata('iduser');
                
                $this->load->model('producto_model');
                
                $this->producto_model->updateUnidad($idrec,$idproducto,$idgvar,$unidadcon,$unidadconver,$estadoun,$whodidit);
                
                $vars = $this->producto_model->verVars();
                $multi = $this->producto_model->verMulti($idproducto);
                
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                
                
                $datos = array();
                
                $i = 0;
                
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                     foreach($arraay as $fil){ 
                                       if($fil == $va->idrnum){
                    $j = 0;
                    $datosSupIn = array();
                    foreach($multi as $mul){
                        if($mul->idgvar == $va->valor_num){
                            $datosSupIn[$j] = array(
                                "id" => "$mul->idrec",
                                "text" => "$mul->descrip",
                                "orden" => "$mul->askpwd",
                                "titulo" => "$mul->descrip",
                                "precio" => "$mul->precioventa",
                                "unidad" => "$mul->uniconv",
								"fechaini" => "$mul->profecini",
                                "fechafin" => "$mul->profecfin",
                                "estado" => "$mul->estatus",
                                "idcps" => "$mul->idcps",
                                "imagen" => "$mul->imagen",
                                "notas" => "$mul->notas",
                                "parentId" => "$mul->idgvar",
                                "expanded" => "true"
                            );
                            $j++;
                        }
                         
                    }
                    
                    $datosSupIn[$j] = array(
                        "id" => "0_".round($va->valor_num, 0),
                        "iconSrc" => base_url()."img/add2.png"
                    );
                    
                    $datosIn[$i] = array(
                        "id" => "0_0_".round($va->valor_num, 0),
                        "parentId" => "0",
                        "text" => "$va->descripcion",
                        "items" => $datosSupIn
                    );
                    
                    $i++;
                }}}
                $datos = $datosIn;
                echo json_encode($datos);
            }
        }
        
        function saveProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproductopro = $this->input->post('idproductopro');
                $idgvarpro = $this->input->post('idgvarpro');
                $proveedoral = $this->input->post('proveedoral');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('producto_model');
                $this->producto_model->insertProveedor($idproductopro,$idgvarpro,$proveedoral,$whodidit);
                $vars = $this->producto_model->verVars();
                $multi = $this->producto_model->verMulti($idproductopro);
                $linea = $this->producto_model->callLinea($idproductopro);
                $permisos = $this->producto_model->viewPermisos($linea);
                $datos = array();
                $i = 0;
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                    foreach($arraay as $fil){ 
                        if($fil == $va->idrnum){
                            $j = 0;
                            $datosSupIn = array();
                            $datosSupIn[$j] = array(
                                "id" => "0_".round($va->valor_num, 0),
                                "iconSrc" => base_url()."img/add2.png",
                                "padre" => "$va->descripcion",
                            );
                            $j++;
                            foreach($multi as $mul){
                                if($mul->idgvar == $va->valor_num){
                                    $datosSupIn[$j] = array(
                                        "id" => "$mul->idrec",
                                        "text" => "$mul->descrip",
                                        "orden" => "$mul->askpwd",
                                        "titulo" => "$mul->descrip",
                                        "precio" => "$mul->precioventa",
                                        "fechaini" => "$mul->profecini",
                                        "fechafin" => "$mul->profecfin",
                                        "unidad" => "$mul->uniconv",
                                        "estado" => "$mul->estatus",
                                        "idcps" => "$mul->idcps",
                                        "imagen" => "$mul->imagen",
                                        "notas" => "$mul->notas",
                                        "askpwd" => "$mul->askpwd",
                                        "parentId" => "$mul->idgvar",
                                        "expanded" => "true",
                                        "padre" => "$va->descripcion",
                                    );
                                    $j++;
                                }       
                            }
                            $datosIn[$i] = array(
                                "id" => "0_0_".round($va->valor_num, 0),
                                "parentId" => "0",
                                "text" => "$va->descripcion",
                                "items" => $datosSupIn
                            );
                            $i++;
                        }
                    }
                }
                $datos = $datosIn;
                echo json_encode($datos);
            }
        }
        
        function savePrecio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgvarp = $this->input->post('idgvarp');
                $idproducto = $this->input->post('idproducto');
                $descrip_ap = $this->input->post('descrip_ap');
                $precio_ap = $this->input->post('precio_ap');
                $uc_ap = $this->input->post('uc_ap');
                $pass = $this->input->post('sol_pass_ap');
                $notas = $this->input->post('notas_ap');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('producto_model');
                if($pass=="false" || $pass==false){
                    $password = 0;
                }else{
                    $password = 1;
                }
                $idpromulti = $this->producto_model->insertPrecio($idgvarp,$idproducto,$descrip_ap,$precio_ap,$uc_ap,$password,$notas,$whodidit);
                $img = $this->input->post('imgen_ap');
                $imagen = $this->input->post('img_ap');
                $imga = $this->input->post('imga_ap');
                
                $nameimagen = "Img_promulti_".$idpromulti;
                $imgSplit = explode(".", $img);
                $nameimagen2 = "Img_promulti_".$idpromulti.".".$imgSplit[1];
                
                
                $archivo = 'add_img_precio';
                $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                $config['file_name'] = $nameimagen;
                $config['over_write'] = "TRUE";
                $config['allowed_types'] = "gif|jpg|jpeg|png";
                $this->load->library('upload', $config);
                if($this->upload->do_upload($archivo)){
                   $update = $this->producto_model->updateImgPrecio($idpromulti,$nameimagen2,$whodidit);
                }
                $vars = $this->producto_model->verVars();
                $multi = $this->producto_model->verMulti($idproducto);
                
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                $datos = array();
                $i = 0;
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                    foreach($arraay as $fil){ 
                        if($fil == $va->idrnum){
                            $j = 0;
                            $datosSupIn = array();
                            $datosSupIn[$j] = array(
                                "id" => "0_".round($va->valor_num, 0),
                                "iconSrc" => base_url()."img/add2.png",
                                "padre" => "$va->descripcion",
                            );
                            $j++;
                            foreach($multi as $mul){
                                if($mul->idgvar == $va->valor_num){
                                    $datosSupIn[$j] = array(
                                        "id" => "$mul->idrec",
                                        "text" => "$mul->descrip",
                                        "orden" => "$mul->askpwd",
                                        "titulo" => "$mul->descrip",
                                        "precio" => "$mul->precioventa",
                                        "fechaini" => "$mul->profecini",
                                        "fechafin" => "$mul->profecfin",
                                        "unidad" => "$mul->uniconv",
                                        "estado" => "$mul->estatus",
                                        "idcps" => "$mul->idcps",
                                        "imagen" => "$mul->imagen",
                                        "notas" => "$mul->notas",
                                        "askpwd" => "$mul->askpwd",
                                        "parentId" => "$mul->idgvar",
                                        "expanded" => "true",
                                        "padre" => "$va->descripcion",
                                        
                                    );
                                    $j++;
                                }
                            }
                            $datosIn[$i] = array(
                                "id" => "0_0_".round($va->valor_num, 0),
                                "parentId" => "0",
                                "text" => "$va->descripcion",
                                "items" => $datosSupIn
                            );
                            $i++;
                        }
                    }
                }
                $datos = $datosIn;
                echo json_encode($datos);
            }
        }
        
        function savePrecioPromocion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idproducto = $this->input->post('idproducto');
                $idgvar = $this->input->post('idgvar');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $precio = $this->input->post('precio');
                $estado = $this->input->post('estado');
                
				$this->load->model('producto_model');
				$this->producto_model->insertPrecioPromocion($idproducto, $idgvar, $fechaini, $fechafin, $precio, $estado);
                
				$vars = $this->producto_model->verVars();
                $multi = $this->producto_model->verMulti($idproducto);
				$linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                
				$i=0;
                $datos = array();
                $array = explode(",", $permisos);
				
				foreach($vars as $va){
					foreach($array as $fil){
						if($fil == $va->idrnum){
							$j = 0;
							$datosSupIn = array();
                            $datosSupIn[$j] = array(
								"id" => "0_".round($va->valor_num, 0),
								"iconSrc" => base_url()."img/add2.png",
                                "padre" => "$va->descripcion",
							);
                            $j++;
							foreach($multi as $mul){
								if($mul->idgvar == $va->valor_num){
									$datosSupIn[$j] = array(
										"id" => "$mul->idrec",
										"text" => "$mul->descrip",
										"orden" => "$mul->askpwd",
										"titulo" => "$mul->descrip",
										"precio" => "$mul->precioventa",
										"fechaini" => "$mul->profecini",
										"fechafin" => "$mul->profecfin",
										"unidad" => "$mul->uniconv",
                                        "askpwd" => "$mul->askpwd",
                                        "padre" => "$va->descripcion",
										"estado" => "$mul->estatus",
										"idcps" => "$mul->idcps",
										"imagen" => "$mul->imagen",
										"notas" => "$mul->notas",
										"parentId" => "$mul->idgvar",
										"expanded" => "true"
									);
									$j++;
								}
							}
                            $datosIn[$i] = array(
								"id" => "0_0_".round($va->valor_num, 0),
								"parentId" => "0",
								"text" => "$va->descripcion",
								"items" => $datosSupIn
							);
							$i++;
						}
					}
				}
                
				echo json_encode($datosIn);
			}
        }
		
		function editPrecioPromocion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idpreciopromo = $this->input->post('idpreciopromo');
				$idproducto = $this->input->post('idproducto');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $precio = $this->input->post('precio');
                $estado = $this->input->post('estado');
                
				$this->load->model('producto_model');
				$this->producto_model->updatePrecioPromocion($idpreciopromo, $idproducto, $fechaini, $fechafin, $precio, $estado);
                
				$vars = $this->producto_model->verVars();
                $multi = $this->producto_model->verMulti($idproducto);
				$linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                
				$i=0;
                $datos = array();
                $array = explode(",", $permisos);
				
				foreach($vars as $va){
					foreach($array as $fil){
						if($fil == $va->idrnum){
							$j = 0;
							$datosSupIn = array();
							foreach($multi as $mul){
								if($mul->idgvar == $va->valor_num){
									$datosSupIn[$j] = array(
										"id" => "$mul->idrec",
										"text" => "$mul->descrip",
										"orden" => "$mul->askpwd",
										"titulo" => "$mul->descrip",
										"precio" => "$mul->precioventa",
										"fechaini" => "$mul->profecini",
										"fechafin" => "$mul->profecfin",
										"unidad" => "$mul->uniconv",
										"estado" => "$mul->estatus",
										"idcps" => "$mul->idcps",
										"imagen" => "$mul->imagen",
										"notas" => "$mul->notas",
										"parentId" => "$mul->idgvar",
										"expanded" => "true"
									);
									$j++;
								}
							}
                    
							$datosSupIn[$j] = array(
								"id" => "0_".round($va->valor_num, 0),
								"iconSrc" => base_url()."img/add2.png"
							);
							
							$datosIn[$i] = array(
								"id" => "0_0_".round($va->valor_num, 0),
								"parentId" => "0",
								"text" => "$va->descripcion",
								"items" => $datosSupIn
							);
							$i++;
						}
					}
				}
                
				echo json_encode($datosIn);
			}
		}
        
        function modImagen(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if(isset($_FILES["adimagenu"])){
                   
                    $file = $_FILES["adimagenu"];
                    $nombre = $file["name"];
                    $idgvar = $_POST["idgvariu"];
                    $idproducto = $_POST["idproductoiu"];
                    $id = $_POST["idimg"];
                    $imagenau =  $_POST["imagenau"];
                    $viejaimagen =  $_POST["viejaimagen"];
                    $nameimagenv = $_POST["namimagenu"]; 
                    $nameimagenn = $_POST["nameimagenu"];
                    $numeroimagen = $_POST["numeroimagen"];
                    $whodidit = $this->session->userdata('iduser');
                   
                   
                    $this->load->model('producto_model');
                   
                    if($nameimagenn == "" ){
                       
                        if($numeroimagen == "1"){
                           
                            $imgSplit = explode(".", $viejaimagen);
                            $nuevonombre = $imgSplit[0];
                    
                            $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                            $config['file_name'] = $nuevonombre;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "gif|jpg|jpeg|png";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);
                            if($this->upload->do_upload('adimagenu')){ 
                                $this->producto_model->updateImagen($idproducto,$idgvar,$nameimagenv,$viejaimagen,$whodidit,$id);
                            }else{
                                echo $this->upload->display_errors();
                            }
                           
                        }else{
                            $this->producto_model->updateImagen($idproducto,$idgvar,$nameimagenv,$viejaimagen,$whodidit,$id);
                        }
                       
                    }else if($nameimagenn != ""){
                       
                       
                        if($numeroimagen == "1"){
                           
                            $name =  preg_replace('[\s+]','',$nameimagenn);
                            $imgSplit = explode(".", $nombre);
                            $nombreimagen = $name.$idproducto;
                            $nombreimagn = $name.$idproducto.".".$imgSplit[1];
                       
                            $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                            $config['file_name'] = $nombreimagen;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "gif|jpg|jpeg|png";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);
                               
                            if($this->upload->do_upload('adimagenu')){
                               
                                $this->producto_model->updateImagen($idproducto,$idgvar,$nameimagenn,$nombreimagn,$whodidit,$id);
                            }else{
                                echo $this->upload->display_errors();
                            }
                        }else{
                           $this->producto_model->updateImagen($idproducto,$idgvar,$nameimagenn,$viejaimagen,$whodidit,$id);
                               
                        }
                       
                    }
                   
                    $vars = $this->producto_model->verVars();
                    $multi = $this->producto_model->verMulti($idproducto);
                    
                    $linea = $this->producto_model->callLinea($idproducto);
                    $permisos = $this->producto_model->viewPermisos($linea);
                
                
                    $datos = array();

                    $i = 0;

                    $arraay = explode(",", $permisos);
                    foreach($vars as $va){
                         foreach($arraay as $fil){ 
                                           if($fil == $va->idrnum){
                        $j = 0;
                        $datosSupIn = array();
                        foreach($multi as $mul){
                            if($mul->idgvar == $va->valor_num){
                                $datosSupIn[$j] = array(
                                    "id" => "$mul->idrec",
                                    "text" => "$mul->descrip",
                                    "orden" => "$mul->askpwd",
                                    "titulo" => "$mul->descrip",
                                    "precio" => "$mul->precioventa",
									"fechaini" => "$mul->profecini",
									"fechafin" => "$mul->profecfin",
                                    "unidad" => "$mul->uniconv",
                                    "estado" => "$mul->estatus",
                                    "idcps" => "$mul->idcps",
                                    "imagen" => "$mul->imagen",
                                    "notas" => "$mul->notas",
                                    "parentId" => "$mul->idgvar",
                                    "expanded" => "true"
                                );
                                $j++;
                            }

                        }

                        $datosSupIn[$j] = array(
                            "id" => "0_".round($va->valor_num, 0),
                            "iconSrc" => base_url()."img/add2.png"
                        );

                        $datosIn[$i] = array(
                            "id" => "0_0_".round($va->valor_num, 0),
                            "parentId" => "0",
                            "text" => "$va->descripcion",
                            "items" => $datosSupIn
                        );

                        $i++;
                    }}}
                    $datos = $datosIn;
                    echo json_encode($datos);
                    
                }
            }
                   
        }
        
        function saveDatos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
               if(isset($_FILES["archivod"])){
                   $file = $_FILES["archivod"];
                   $nombre = $file["name"];
                   $idgvar = $_POST["idgvard"];
                   $idproducto = $_POST["idproductod"];
                   $namearchivo = $_POST["namearchivo"];
                   $notas = $_POST["notasd"];
                   $name =  preg_replace('[\s+]','',$namearchivo);
                   $whodidit = $this->session->userdata('iduser');
                   $imgSplit = explode(".", $nombre);
                   $nombrearchivo = $name.$idproducto;
                   $nombrearchiv = $name.$idproducto.".".$imgSplit[1];
                   
                 //  $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                   $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                   $config['file_name'] = $nombrearchivo;
                   $config['over_write'] = "TRUE";
                   $config['allowed_types'] = "*";
                   $this->load->library('upload', $config);
                   $this->upload->initialize($config);
               
                       
                   $this->load->model('producto_model');
                   $this->producto_model->insertDatos($idproducto,$idgvar,$namearchivo,$nombrearchiv,$notas,$whodidit);

                   $vars = $this->producto_model->verVars();
                   $multi = $this->producto_model->verMulti($idproducto);

                   $linea = $this->producto_model->callLinea($idproducto);
                   $permisos = $this->producto_model->viewPermisos($linea);
                
                
                   $datos = array();

                   $i = 0;

                    $arraay = explode(",", $permisos);
                    foreach($vars as $va){
                         foreach($arraay as $fil){ 
                                           if($fil == $va->idrnum){
                        $j = 0;
                        $datosSupIn = array();
                        foreach($multi as $mul){
                            if($mul->idgvar == $va->valor_num){
                                $datosSupIn[$j] = array(
                                    "id" => "$mul->idrec",
                                    "text" => "$mul->descrip",
                                    "orden" => "$mul->askpwd",
                                    "titulo" => "$mul->descrip",
                                    "precio" => "$mul->precioventa",
									"fechaini" => "$mul->profecini",
									"fechafin" => "$mul->profecfin",
                                    "unidad" => "$mul->uniconv",
                                    "estado" => "$mul->estatus",
                                    "idcps" => "$mul->idcps",
                                    "imagen" => "$mul->imagen",
                                    "notas" => "$mul->notas",
                                    "parentId" => "$mul->idgvar",
                                    "expanded" => "true"
                                );
                                $j++;
                            }

                        }

                        $datosSupIn[$j] = array(
                            "id" => "0_".round($va->valor_num, 0),
                            "iconSrc" => base_url()."img/add2.png"
                        );

                        $datosIn[$i] = array(
                            "id" => "0_0_".round($va->valor_num, 0),
                            "parentId" => "0",
                            "text" => "$va->descripcion",
                            "items" => $datosSupIn
                        );

                        $i++;
                    }}}
                    $datos = $datosIn;
                    echo json_encode($datos);
               }
            }
                
        }
        
        function modDatos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                   
                if(isset($_FILES["archivodu"])){
                   
                    $file = $_FILES["archivodu"];
                    $nombre = $file["name"];
                    $idgvar = $_POST["idgvardu"];
                    $idproducto = $_POST["idproductodu"];
                    $id = $_POST["iddatos"];
                    $namearchivo =  $_POST["namearchivou"];
                    $notas = $_POST["notasdu"];
                    $titulo = $_POST["tituloguarda"];
                    $notag = $_POST["notasguarda"];
                    $archivoguarda = $_POST["archivoguarda"];
                    $numerodatos = $_POST["numerodatos"];
                        
                   
                   
                    $whodidit = $this->session->userdata('iduser');
                   
                   
                    $this->load->model('producto_model');
                   
                    if($namearchivo == "" && $notas == "" ){
                        
                          
                        
                        if($numerodatos == "1"){
                            $imgSplit = explode(".", $archivoguarda);
                               
                           // $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                            $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                            $config['file_name'] = $imgSplit[0];
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "*";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);
                             
                            if($this->upload->do_upload('archivodu')){ 
                                $this->producto_model->updateDatos($idproducto,$idgvar,$titulo,$archivoguarda,$notag,$whodidit,$id);
                            }else{
                                echo $this->upload->display_errors();
                            }
                             
                             
                        }else{
                            $this->producto_model->updateDatos($idproducto,$idgvar,$titulo,$archivoguarda,$notag,$whodidit,$id);
                                 
                        }  

                    }else if($namearchivo != "" && $notas == ""){
                        if($numerodatos == "1"){
                            
                            $name =  preg_replace('[\s+]','',$namearchivo);
                            $imgSplit = explode(".", $nombre);
                            $nombrearchivo = $name.$idproducto;
                            $nombrearchiv = $name.$idproducto.".".$imgSplit[1];
                           // $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                            $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                            $config['file_name'] = $nombrearchivo;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "*";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);
                             
                             if($this->upload->do_upload('archivodu')){
                                 $this->producto_model->updateDatos($idproducto,$idgvar,$namearchivo,$nombrearchiv,$notag,$whodidit,$id);
                             }else{
                                 echo $this->upload->display_errors();
                             }
                        }else{
                            $name =  preg_replace('[\s+]','',$namearchivo);
                            $imgSplit = explode(".", $archivoguarda);
                            $nombrearchivo = $name.$idproducto;
                            $nombrearchiv = $name.$idproducto.".".$imgSplit[1];
                            
                            $this->producto_model->updateDatos($idproducto,$idgvar,$namearchivo,$archivoguarda,$notag,$whodidit,$id);
                          
                        }
                        
                    }else if($namearchivo == "" && $notas != ""){
                       
                        
                            if($numerodatos == "1"){
                            
                                $imgSplit = explode(".", $archivoguarda);
                             
                                //$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                                $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                                $config['file_name'] = $imgSplit[0];
                                $config['over_write'] = "TRUE";
                                $config['allowed_types'] = "*";
                                $this->load->library('upload', $config);
                                $this->upload->initialize($config);
                            
                                if($this->upload->do_upload('archivodu')){
                                    $this->producto_model->updateDatos($idproducto,$idgvar,$titulo,$archivoguarda,$notas,$whodidit,$id);
                                }else{
                                    echo $this->upload->display_errors();
                                }
                            }else{
                            
                                $this->producto_model->updateDatos($idproducto,$idgvar,$titulo,$archivoguarda,$notas,$whodidit,$id);
                        
                            }
                       
                    }else if($namearchivo != "" && $notas != ""){
                        
                       if($numerodatos == "1"){
                             
                           $name =  preg_replace('[\s+]','',$namearchivo);
                           $imgSplit = explode(".", $nombre);
                           $nombrearchivo = $name.$idproducto;
                           $nombrearchiv = $name.$idproducto.".".$imgSplit[1];
                       
                            
                           //$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                           $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                           $config['file_name'] = $nombrearchivo;
                           $config['over_write'] = "TRUE";
                           $config['allowed_types'] = "*";
                           $this->load->library('upload', $config);
                           $this->upload->initialize($config);
                            
                           if($this->upload->do_upload('archivodu')){
                               $this->producto_model->updateDatos($idproducto,$idgvar,$namearchivo,$nombrearchiv,$notas,$whodidit,$id);
                           }else{
                               echo $this->upload->display_errors();
                           }
                       }else{
                           $name =  preg_replace('[\s+]','',$namearchivo);
                           $imgSplit = explode(".", $archivoguarda);
                           $nombrearchivo = $name.$idproducto;
                           $nombrearchiv = $name.$idproducto.".".$imgSplit[1];
                           $this->producto_model->updateDatos($idproducto,$idgvar,$namearchivo,$archivoguarda,$notas,$whodidit,$id);
                       }
                    }
                   
                    $vars = $this->producto_model->verVars();
                    $multi = $this->producto_model->verMulti($idproducto);
                
                    $linea = $this->producto_model->callLinea($idproducto);
                    $permisos = $this->producto_model->viewPermisos($linea);
                
                
                    $datos = array();

                    $i = 0;

                    $arraay = explode(",", $permisos);
                    foreach($vars as $va){
                         foreach($arraay as $fil){ 
                                           if($fil == $va->idrnum){
                        $j = 0;
                        $datosSupIn = array();
                        foreach($multi as $mul){
                            if($mul->idgvar == $va->valor_num){
                                $datosSupIn[$j] = array(
                                    "id" => "$mul->idrec",
                                    "text" => "$mul->descrip",
                                    "orden" => "$mul->askpwd",
                                    "titulo" => "$mul->descrip",
                                    "precio" => "$mul->precioventa",
									"fechaini" => "$mul->profecini",
									"fechafin" => "$mul->profecfin",
                                    "unidad" => "$mul->uniconv",
                                    "estado" => "$mul->estatus",
                                    "idcps" => "$mul->idcps",
                                    "imagen" => "$mul->imagen",
                                    "notas" => "$mul->notas",
                                    "parentId" => "$mul->idgvar",
                                    "expanded" => "true"
                                );
                                $j++;
                            }

                        }

                        $datosSupIn[$j] = array(
                            "id" => "0_".round($va->valor_num, 0),
                            "iconSrc" => base_url()."img/add2.png"
                        );

                        $datosIn[$i] = array(
                            "id" => "0_0_".round($va->valor_num, 0),
                            "parentId" => "0",
                            "text" => "$va->descripcion",
                            "items" => $datosSupIn
                        );

                        $i++;
                    }}}
                    $datos = $datosIn;
                    echo json_encode($datos);

                }
            }
                
        }
        
        function modBarra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
               
                $idproducto = $this->input->post('idproductobu');
                $idgvar = $this->input->post('idgvarbu');
                $barcodeb = $this->input->post('barcodebu');
                $estadob = $this->input->post('estadobu');
                $whodidit = $this->session->userdata('iduser');
                $id = $this->input->post('idb');
                
            
                $this->load->model('producto_model');
                
                $this->producto_model->updateBarra($idproducto,$idgvar,$barcodeb,$estadob,$whodidit, $id); 
                
                
                $vars = $this->producto_model->verVars();
                $multi = $this->producto_model->verMulti($idproducto);
                
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                
                
                $datos = array();
                
                $i = 0;
                
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                     foreach($arraay as $fil){ 
                                       if($fil == $va->idrnum){
                    $j = 0;
                    $datosSupIn = array();
                    foreach($multi as $mul){
                        if($mul->idgvar == $va->valor_num){
                            $datosSupIn[$j] = array(
                                "id" => "$mul->idrec",
                                "text" => "$mul->descrip",
                                "orden" => "$mul->askpwd",
                                "titulo" => "$mul->descrip",
                                "precio" => "$mul->precioventa",
								"fechaini" => "$mul->profecini",
                                "fechafin" => "$mul->profecfin",
                                "unidad" => "$mul->uniconv",
                                "estado" => "$mul->estatus",
                                "idcps" => "$mul->idcps",
                                "imagen" => "$mul->imagen",
                                "notas" => "$mul->notas",
                                "parentId" => "$mul->idgvar",
                                "expanded" => "true"
                            );
                            $j++;
                        }
                         
                    }
                    
                    $datosSupIn[$j] = array(
                        "id" => "0_".round($va->valor_num, 0),
                        "iconSrc" => base_url()."img/add2.png"
                    );
                    
                    $datosIn[$i] = array(
                        "id" => "0_0_".round($va->valor_num, 0),
                        "parentId" => "0",
                        "text" => "$va->descripcion",
                        "items" => $datosSupIn
                    );
                    
                    $i++;
                }}}
                $datos = $datosIn;
                echo json_encode($datos);
            }
        }
        
        function modProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
               
                $idproductoprou = $this->input->post('idproductoprou');
                $idgvarprou = $this->input->post('idgvarprou');
                $proveedoru = $this->input->post('proveedoru');
                $whodidit = $this->session->userdata('iduser');
                $idpro = $this->input->post('idpro');
                
                $this->load->model('producto_model');
                
                $this->producto_model->updateProveedor($idproductoprou,$idgvarprou,$proveedoru,$whodidit, $idpro); 
                $vars = $this->producto_model->verVars();
                $multi = $this->producto_model->verMulti($idproductoprou);
                
                $linea = $this->producto_model->callLinea($idproductoprou);
                $permisos = $this->producto_model->viewPermisos($linea);
                
                
                $datos = array();
                
                $i = 0;
                
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                     foreach($arraay as $fil){ 
                                       if($fil == $va->idrnum){
                    $j = 0;
                    $datosSupIn = array();
                    foreach($multi as $mul){
                        if($mul->idgvar == $va->valor_num){
                            $datosSupIn[$j] = array(
                                "id" => "$mul->idrec",
                                "text" => "$mul->descrip",
                                "orden" => "$mul->askpwd",
                                "titulo" => "$mul->descrip",
                                "precio" => "$mul->precioventa",
								"fechaini" => "$mul->profecini",
                                "fechafin" => "$mul->profecfin",
                                "unidad" => "$mul->uniconv",
                                "estado" => "$mul->estatus",
                                "idcps" => "$mul->idcps",
                                "imagen" => "$mul->imagen",
                                "notas" => "$mul->notas",
                                "parentId" => "$mul->idgvar",
                                "expanded" => "true"
                            );
                            $j++;
                        }
                         
                    }
                    
                    $datosSupIn[$j] = array(
                        "id" => "0_".round($va->valor_num, 0),
                        "iconSrc" => base_url()."img/add2.png"
                    );
                    
                    $datosIn[$i] = array(
                        "id" => "0_0_".round($va->valor_num, 0),
                        "parentId" => "0",
                        "text" => "$va->descripcion",
                        "items" => $datosSupIn
                    );
                    
                    $i++;
                }}}
                $datos = $datosIn;
                echo json_encode($datos);
            }
        }
        
        function modPrecio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $id = $this->input->post('idp');
                $idgvarp = $this->input->post('idgvarpu');
                $idproducto = $this->input->post('idproductpu');
                $descrip_ap = $this->input->post('descrip_ap');
                $precio_ap = $this->input->post('precio_ap');
                $uc_ap = $this->input->post('uc_ap');
                $pass = $this->input->post('sol_pass_ap');
                $notas = $this->input->post('notas_ap');
                $estado = $this->input->post('estado_ap');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('producto_model');
                if($pass=="false" || $pass==false){
                    $pass = 0;
                }else{
                    $pass = 1;
                }if($estado=="false" || $estado==false){
                    $estado = 0;
                }else{
                    $estado = 1;
                }
                $cambia = $this->input->post('cambia');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('producto_model');
                $this->producto_model->updatePrecio($id,$idgvarp,$idproducto,$descrip_ap,$precio_ap,$uc_ap,$pass,$notas,$estado,$whodidit);
                
                if($cambia==1){
                    $img = $this->input->post('imgen_ap');
                    $imagen = $this->input->post('img_ap');
                    $imga = $this->input->post('imga_ap');

                    $nameimagen = "Img_promulti_".$id;
                    $imgSplit = explode(".", $img);
                    $nameimagen2 = "Img_promulti_".$id.".".$imgSplit[1];
                    $archivo = 'add_img_precio';
                    $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['file_name'] = $nameimagen;
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $this->load->library('upload', $config);
                    if($this->upload->do_upload($archivo)){
                       $update = $this->producto_model->updateImgPrecio($id,$nameimagen2,$whodidit);
                    }
                }
                
                $vars = $this->producto_model->verVars();
                $multi = $this->producto_model->verMulti($idproducto);
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                $datos = array();
                $i = 0;
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                    foreach($arraay as $fil){ 
                        if($fil == $va->idrnum){
                            $j = 0;
                            $datosSupIn = array();
                            $datosSupIn[$j] = array(
                                "id" => "0_".round($va->valor_num, 0),
                                "iconSrc" => base_url()."img/add2.png",
                                "padre" => "$va->descripcion",
                            );
                            $j++;
                            foreach($multi as $mul){
                                if($mul->idgvar == $va->valor_num){
                                    $datosSupIn[$j] = array(
                                        "id" => "$mul->idrec",
                                        "text" => "$mul->descrip",
                                        "orden" => "$mul->askpwd",
                                        "titulo" => "$mul->descrip",
                                        "precio" => "$mul->precioventa",
                                        "fechaini" => "$mul->profecini",
                                        "fechafin" => "$mul->profecfin",
                                        "unidad" => "$mul->uniconv",
                                        "estado" => "$mul->estatus",
                                        "idcps" => "$mul->idcps",
                                        "imagen" => "$mul->imagen",
                                        "notas" => "$mul->notas",
                                        "parentId" => "$mul->idgvar",
                                        "expanded" => "true",
                                        "askpwd" => "$mul->askpwd",
                                        "padre" => "$va->descripcion",
                                    );
                                    $j++;
                                }   
                            }
                            $datosIn[$i] = array(
                                "id" => "0_0_".round($va->valor_num, 0),
                                "parentId" => "0",
                                "text" => "$va->descripcion",
                                "items" => $datosSupIn
                            );
                            $i++;
                        }
                    }
                }
                $datos = $datosIn;
                echo json_encode($datos);
            }
        }
        
        function eliminarProducto($id, $idcatalog){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('producto_model');
                $this->producto_model->deleteProducto($id, $idcatalog);
            }
        }
        
        function verMarcas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('producto_model');
                $result = $this->producto_model->verMarca();
                echo json_encode($result);
            }
        }
        
        function verMarcasLinea(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                
                $this->load->model('producto_model');
                $result = $this->producto_model->verMarcasLinea($idcatalogo);
                echo json_encode($result);
            }
        }
        
        function verUM(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('producto_model');
                $result = $this->producto_model->verUM();
                echo json_encode($result);
            }
        }
        
        function updateSelected(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $valor = $this->input->post('valor');
                if($valor!=0 && $valor!=null){
                    $array = array(
                        'cat_selected' => $valor
                    );
                    $this->session->set_userdata($array);
                }
               

                echo json_encode($valor);
            }
        }
        
        function save_multiproduct(){
             if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $cadena = $this->input->post('dato_txt');
                $idcatalogo = $this->input->post('idcatalogo');
                $this->load->model('producto_model');                
                $array = $this->producto_model->saveMultiproductData($cadena, $idcatalogo);
                echo json_encode($array);
            }
        }
        
        function get_multiproduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $this->load->model('producto_model');                
                $array = $this->producto_model->getMultiProductData($idcatalogo);
                echo json_encode($array);
            }
        }
        
        function igallery($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcion_vista' =>$opcionmenu
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('producto_model');
                $this->data['departamentos'] = $this->producto_model->viewLineas();
                $this->data['marcas'] = $this->producto_model->verMarca();
                $this->load->view('mantenimiento_igalleria', $this->data);
            }
        }
        
        function igallery2($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcion_vista' =>$opcionmenu
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('producto_model');
                $this->data['departamentos'] = $this->producto_model->viewLineas();
                $this->data['marcas'] = $this->producto_model->verMarca();
                $this->load->view('mantenimiento_igalleria2', $this->data);
            }
        }
        
        function getProducts_linea(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idlinea = $this->input->post('idlinea');
                $this->load->model('producto_model');                
                $pro = $this->producto_model->viewProductos_Linea($idlinea);
                $cant = $this->producto_model->getCant_pro_linea($idlinea);
                $marcas = $this->producto_model->viewProductos_Marcas($idlinea);
                
                $mar = array();
                $i=0;
                foreach($marcas as $m){
                    if($m->text==""){
                        
                    }else{
                        $mar[$i] = array(
                            "id" => $m->id,
                            "text" => $m->text
                        );
                        $i++;
                    }
                }
                
                
                $array = array('pro'=>$pro, 'cant'=>$cant, 'marcas'=>$mar);
                echo json_encode($array);
            }
        }
        
        function getProducts_marca(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $marca = $this->input->post('marca');
                $this->load->model('producto_model');                
                $pro = $this->producto_model->viewProductos_Marca($marca);
                $cant = $this->producto_model->getCant_pro_marca($marca);
                $lineas = $this->producto_model->getLineasByMarca($marca);
                
                $array = array('pro'=>$pro, 'cant'=>$cant, 'lineas'=>$lineas);
                echo json_encode($array);
            }
        }
        
        function getProducts_linea_Filtrados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idlinea = $this->input->post('idlinea');
                $marcas = $this->input->post('marcas');
                $this->load->model('producto_model');                
                if(trim($marcas)==""){
                    $pro = $this->producto_model->viewProductos_Linea($idlinea);
                    $cant = $this->producto_model->getCant_pro_linea($idlinea);
                }else{
                    $pro = $this->producto_model->viewProductos_Linea_Marcas($idlinea,$marcas);
                    $cant = $this->producto_model->getCant_pro_linea_Marca($idlinea,$marcas); 
                }
                $array = array('pro'=>$pro, 'cant'=>$cant);
                echo json_encode($array);
            }
        }
        
        function getProducts_marca_Filtrados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $lineas = $this->input->post('lineas');
                $marca = $this->input->post('marca');
                $this->load->model('producto_model');                
                $pro = $this->producto_model->viewProductos_Marcas_Lineas($marca,$lineas);
                $cant = $this->producto_model->getCant_pro_Marca_Lineas($marca,$lineas); 
                $array = array('pro'=>$pro, 'cant'=>$cant);
                echo json_encode($array);
            }
        }
        
        function modImagenProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if(isset($_FILES["imagen"])){
                    $file = $_FILES["imagen"];
                    $nombre = $file["name"];
                    $idproducto = $_POST["idproduct"];
                    $viejaimagen = $_POST["viejaimagen"];
                    $linea = $_POST["lineaactual"];
                    
                    $whodidit = $this->session->userdata('iduser');
                    $this->load->model('producto_model');
                   
                    if($nombre == ""){
                        $ingreso=0;
                    }else{
                        if($nombre != ""){
                            $imgSplit = explode(".", $nombre);
                            $ext = end($imgSplit);
                            $nombreimagen = "imgProduct_".$idproducto;
                            $nombreimagen2 = "imgProduct_".$idproducto.".".$ext;
                            $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                            $config['file_name'] = $nombreimagen;
                            $config['over_write'] = "TRUE";
                            //$config['allowed_types'] = "*";
                            $config['allowed_types'] = "gif|jpg|jpeg|png";
                            $config['max_size'] = 200;
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);

                            if($this->upload->do_upload('imagen')){
                                if($viejaimagen!=""){
                                    if (file_exists("img_cuentas/".$this->session->userdata('diraccount')."/".$viejaimagen)) {
                                        unlink("img_cuentas/".$this->session->userdata('diraccount')."/".$viejaimagen);
                                    }    
                                }
                                $this->producto_model->updateProductImagen($idproducto,$nombreimagen2,$whodidit);
                            }else{
                                echo $this->upload->display_errors();
                                die();
                            }
                        }
                    }
                    $pro = $this->producto_model->viewProductos_Linea($linea);
                    
                    echo json_encode($pro);
                }
            }
        }
		
		function modImagenProductGaleria(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				if(isset($_FILES["img"])){
					
					$this->load->library('image_lib');
					$file = $_FILES["img"];
                    $nombre = $file["name"];
                    $idproducto = $_POST["idproduct"];
                    $linea = $_POST["lineaactual"];
                    
                    $whodidit = $this->session->userdata('iduser');
                    $this->load->model('producto_model');
					$direccion = "";
                    if($nombre == ""){
                        $ingreso=0;
                    }else{
						$this->producto_model->deleteProductImagen($idproducto,$whodidit);
						$imgSplit = explode(".", $nombre);
						$ext = end($imgSplit);
						$nombreimagen = "imgProduct_".$idproducto;
						$nombreimagen2 = "imgProduct_".$idproducto.".".$ext;
						$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
						$direccion = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$nombreimagen2;
						$config['file_name'] = $nombreimagen;
						$config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
						$this->load->library('upload', $config);
						$this->upload->initialize($config);	
						if($this->upload->do_upload('img')){
							$this->producto_model->updateProductImagen($idproducto,$nombreimagen2,$whodidit);
							$image_data = $this->upload->data();
							$config['image_library'] = 'gd2';
							$config['source_image'] = $image_data['full_path']; //get original image
							$config['maintain_ratio'] = TRUE;
							$config['width'] = 500;
							$config['height'] = 500;
							
							$this->load->library('image_lib', $config);

							$this->image_lib->clear();
							$this->image_lib->initialize($config);
							
							if (!$this->image_lib->resize()) {
								$this->handle_error($this->image_lib->display_errors());
							}else{
								
							}
						}else{
							//echo $this->upload->display_errors();
						}
                    }
                    $pro = $this->producto_model->viewProductos_Linea($linea);
                    echo json_encode($pro);
                }
            }
        }
     
        function delImagenProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $_POST["idproduct"];
                $linea = $_POST["lineaactual"];
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('producto_model');
                $this->producto_model->deleteProductImagen($idproducto,$whodidit);
                $pro = $this->producto_model->viewProductos_Linea($linea);
                echo json_encode($pro);
            }
        }
        
        function depto_selected(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $id = $this->input->post('idCatalogo');
                $idCatalog_slc = array(
                    'idCatalog_slc2' => $id,
                );
                $this->session->set_userdata($idCatalog_slc);
                echo json_encode($id);
            }
        }
        
        function getInfoMulti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idvar = $this->input->post('idvar');
                $idproducto = $this->input->post('idproducto');
                $this->load->model('producto_model');
                $result = $this->producto_model->getInfoMulti($idvar,$idproducto);
                echo json_encode($result);
            }
        }
        
        function getInfoMultiAndPrimary(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idvar = $this->input->post('idvar');
                $idproducto = $this->input->post('idproducto');
                $this->load->model('producto_model');
                $result = $this->producto_model->getInfoMultiAndPrimary($idvar,$idproducto);
                echo json_encode($result);
            }
        }
        
        function addPromulti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgvar = $this->input->post('idgvar');
                $idproducto = $this->input->post('idproducto');
                $idcps = $this->input->post('idcps');
                $descrip = $this->input->post('descrip');
                $precioventa = $this->input->post('precioventa');
                $uniconv = $this->input->post('uniconv');
                $notas = $this->input->post('notas');
                $estatus = $this->input->post('estatus');
                $lowrange = $this->input->post('lowrange');
                $highrange = $this->input->post('highrange');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('producto_model');
                $idpromulti = $this->producto_model->insertProMulti($idgvar,$idproducto,$idcps,$descrip,$precioventa,$uniconv,$notas,$estatus,$whodidit,$lowrange,$highrange,$fechaini,$fechafin);
                $vars = $this->producto_model->verVarsPro($idproducto);
                $multi = $this->producto_model->verMulti($idproducto);
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                $datos = array();
                $i = 0;
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                    foreach($arraay as $fil){ 
                        if($fil == $va->idrnum){
                            $datosIn[$i] = array(
                                "id" => round($va->valor_num, 0),
                                "parentId" => "0",
                                "text" => "$va->descripcion",
                                "cant"=> "$va->cant",
								"valor_memo"=> "$va->valor_memo",
                            );
                            $i++;
                        }
                    }
                }
                $datos = $datosIn;
                $lista_tabla = $this->producto_model->getInfoMulti($idgvar,$idproducto);
                $params = array();
                $params=array(
                    "tabla"=>$lista_tabla,
                    "lista"=>$datos
                );
                echo json_encode($params);
            }
        }
		
        function addPromulti_extras(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgvar = $this->input->post('idgvar');
                $idproducto = $this->input->post('idproducto');
                $idcps = $this->input->post('idcps');
                $descrip = $this->input->post('descrip');
                $precioventa = $this->input->post('precioventa');
                $uniconv = $this->input->post('uniconv');
                $notas = $this->input->post('notas');
                $estatus = $this->input->post('estatus');
                $lowrange = $this->input->post('lowrange');
                $highrange = $this->input->post('highrange');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('producto_model');
                $idpromulti = $this->producto_model->insertProMulti_extras($idgvar,$idproducto,$idcps,$descrip,$precioventa,$uniconv,$notas,$estatus,$whodidit,$lowrange,$highrange,$fechaini,$fechafin);
                $vars = $this->producto_model->verVarsPro($idproducto);
                $multi = $this->producto_model->verMulti($idproducto);
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                $datos = array();
                $i = 0;
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                    foreach($arraay as $fil){ 
                        if($fil == $va->idrnum){
                            $datosIn[$i] = array(
                                "id" => round($va->valor_num, 0),
                                "parentId" => "0",
                                "text" => "$va->descripcion",
                                "cant"=> "$va->cant",
                                "valor_memo"=> "$va->valor_memo",
                            );
                            $i++;
                        }
                    }
                }
                $datos = $datosIn;
                $lista_tabla = $this->producto_model->getInfoMulti($idgvar,$idproducto);
                $params = array();
                $params=array(
                    "tabla"=>$lista_tabla,
                    "lista"=>$datos
                );
                echo json_encode($params);
            }
        }
		
        function updatePromulti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgvar = $this->input->post('idgvar');
                $idproducto = $this->input->post('idproducto');
                $idrec = $this->input->post('idrec');
                $idcps = $this->input->post('idcps');
                $descrip = $this->input->post('descrip');
                $precioventa = $this->input->post('precioventa');
                $uniconv = $this->input->post('uniconv');
                $notas = $this->input->post('notas');
                $estatus = $this->input->post('estatus');
                $lowrange = $this->input->post('lowrange');
                $highrange = $this->input->post('highrange');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('producto_model');
                $idpromulti = $this->producto_model->updatePromulti($idrec,$idgvar,$idproducto,$idcps,$descrip,$precioventa,$uniconv,$notas,$estatus,$whodidit,$lowrange,$highrange,$fechaini,$fechafin);
                $vars = $this->producto_model->verVarsPro($idproducto);
                $multi = $this->producto_model->verMulti($idproducto);
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                $datos = array();
                $i = 0;
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                    foreach($arraay as $fil){ 
                        if($fil == $va->idrnum){
                            $datosIn[$i] = array(
                                "id" => round($va->valor_num, 0),
                                "parentId" => "0",
                                "text" => "$va->descripcion",
                                "cant"=> "$va->cant",
								"valor_memo"=> "$va->valor_memo",
                            );
                            $i++;
                        }
                    }
                }
                $datos = $datosIn;
                $lista_tabla = $this->producto_model->getInfoMulti($idgvar,$idproducto);
                $params = array();
                $params=array(
                    "tabla"=>$lista_tabla,
                    "lista"=>$datos
                );
                echo json_encode($params);
            }
        }
        
		function deleteProMulti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idgvar = $this->input->post('idgvar');
                $idproducto = $this->input->post('idproducto');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('producto_model');
                $idpromulti = $this->producto_model->deletePromulti($idrec);
                $vars = $this->producto_model->verVarsPro($idproducto);
                $multi = $this->producto_model->verMulti($idproducto);
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                $datos = array();
                $i = 0;
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                    foreach($arraay as $fil){ 
                        if($fil == $va->idrnum){
                            $datosIn[$i] = array(
                                "id" => round($va->valor_num, 0),
                                "parentId" => "0",
                                "text" => "$va->descripcion",
                                "cant"=> "$va->cant",
								"valor_memo"=> "$va->valor_memo",
                            );
                            $i++;
                        }
                    }
                }
                $datos = $datosIn;
                $lista_tabla = $this->producto_model->getInfoMulti($idgvar,$idproducto);
                $params = array();
                $params=array(
                    "tabla"=>$lista_tabla,
                    "lista"=>$datos
                );
                echo json_encode($params);
            }
        }
        
        function verifyCodBarra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgvar = $this->input->post('idgvar');
                $idproducto = $this->input->post('idproducto');
                $descrip = $this->input->post('descrip');
                $this->load->model('producto_model');
                $cant = $this->producto_model->verifyCodiBarra($idgvar,$idproducto,$descrip);
                $cant2 = $this->producto_model->verifyCodiBarraTodos($idgvar,$idproducto,$descrip);
                $cant = $cant+$cant2;
                $lista_tabla = $this->producto_model->getInfoMulti($idgvar,$idproducto);
                $params = array();
                $params=array(
                    "tabla"=>$lista_tabla,
                    "cantidad"=>$cant
                );
                echo json_encode($params);
                
            }
        }
		
        function existeCodBarra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $barcode = $this->input->post('barcode');
                $this->load->model('producto_model');
                $permite = $this->producto_model->existeCodBarra($barcode);
                echo json_encode($permite);
            }
        }
		
        function verUmPromulti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgvar = 7;
                $this->load->model('producto_model');
                $um_list = $this->producto_model->verUmPromulti(7);
                echo json_encode($um_list);
                
            }
        }
        
		function saveImagen(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if(isset($_FILES["adimagen2"])){
                    $file = $_FILES["adimagen2"];
                    $nombre = $file["name"];
                    $idgvar =4;
                    $idproducto = $_POST["idproductoi"];
                    $nameimagen = $_POST["nombrei2"];
                    $whodidit = $this->session->userdata('iduser');
                    $this->load->model('producto_model');
                    if($nombre != ""){
                        $id_img = $this->producto_model->insertImagen($idproducto,$idgvar,$nameimagen,"",$whodidit);
                        $name =  preg_replace('[\s+]','',$nameimagen);
                        $imgSplit = explode(".", $nombre);
                        $nombreimagen = "Img_promulti_".$id_img;
                        $nombreimagn = "Img_promulti_".$id_img.".".$imgSplit[1];
                        $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['file_name'] = $nombreimagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        if($this->upload->do_upload('adimagen2')){ 
                            $id_img = $this->producto_model->update_img($id_img,$nombreimagn);      
                        }else{
                            $id_img = $this->producto_model->deletePromulti($id_img);          
                        }
                    }
                    
                    $vars = $this->producto_model->verVarsPro($idproducto);
                    $multi = $this->producto_model->verMulti($idproducto);
                    $linea = $this->producto_model->callLinea($idproducto);
                    $permisos = $this->producto_model->viewPermisos($linea);
                    $datos = array();
                    $i = 0;
                    $arraay = explode(",", $permisos);
                    foreach($vars as $va){
                        foreach($arraay as $fil){ 
                            if($fil == $va->idrnum){
                                $datosIn[$i] = array(
                                    "id" => round($va->valor_num, 0),
                                    "parentId" => "0",
                                    "text" => "$va->descripcion",
                                    "cant"=> "$va->cant",
									"valor_memo"=> "$va->valor_memo",
                                );
                                $i++;
                            }
                        }
                    }
                    $datos = $datosIn;
                    $lista_tabla = $this->producto_model->getInfoMulti($idgvar,$idproducto);
                    $lista = $this->producto_model->getInfoTile($idgvar,$idproducto);
                    $params = array();
                    $params=array(
                        "tile"=>$lista,
                        "lista"=>$datos
                    );
                    echo json_encode($params);

                }
            }
        }
        
        function modImgPromulti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if(isset($_FILES["imagen_update"])){
                    $file = $_FILES["imagen_update"];
                    $nombre = $file["name"];
                    $idgvar =4;
                    $idrec_img = $_POST["idrec_img"];
                    $idproducto = $_POST["idproductoi"];
                    $nombreimagen_descrip = $_POST["nombrei2"];
                    $nameimagen = $_POST["namimagenu"];
                    $viejaimagen = $_POST["viejaimagen"];
                    $whodidit = $this->session->userdata('iduser');
                    $this->load->model('producto_model');
                    if($nameimagen != $viejaimagen){
                        if (file_exists("img_cuentas/".$this->session->userdata('diraccount')."/".$viejaimagen)) {
                            unlink("img_cuentas/".$this->session->userdata('diraccount')."/".$viejaimagen);
                        }
                        $this->producto_model->updateImagen($idproducto,4,$nombreimagen_descrip,"",$whodidit,$idrec_img);
                        $name =  preg_replace('[\s+]','',$nameimagen);
                        $imgSplit = explode(".", $nombre);
                        $nombreimagen = "Img_promulti_".$idrec_img;
                        $nombreimagn = "Img_promulti_".$idrec_img.".".$imgSplit[1];
                        $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['file_name'] = $nombreimagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        if($this->upload->do_upload('imagen_update')){ 
                            $id_img = $this->producto_model->update_img($idrec_img,$nombreimagn);      
                        }
                    }else{
                        $this->producto_model->updateImagen($idproducto,4,$nombreimagen_descrip,$viejaimagen,$whodidit,$idrec_img);
                    }
                    
                    $vars = $this->producto_model->verVarsPro($idproducto);
                    $multi = $this->producto_model->verMulti($idproducto);
                    $linea = $this->producto_model->callLinea($idproducto);
                    $permisos = $this->producto_model->viewPermisos($linea);
                    $datos = array();
                    $i = 0;
                    $arraay = explode(",", $permisos);
                    foreach($vars as $va){
                        foreach($arraay as $fil){ 
                            if($fil == $va->idrnum){
                                $datosIn[$i] = array(
                                    "id" => round($va->valor_num, 0),
                                    "parentId" => "0",
                                    "text" => "$va->descripcion",
                                    "cant"=> "$va->cant",
									"valor_memo"=> "$va->valor_memo",
                                );
                                $i++;
                            }
                        }
                    }
                    $datos = $datosIn;
                    $lista_tabla = $this->producto_model->getInfoMulti($idgvar,$idproducto);
                    $lista = $this->producto_model->getInfoTile($idgvar,$idproducto);
                    $params = array();
                    $params=array(
                        "tile"=>$lista,
                        "lista"=>$datos
                    );
                    echo json_encode($params);

                }
            }
        }
        
        function deleteImgMulti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('producto_model');
                $idgvar=4;
                $idproducto = $this->input->post("idproducto");
                $idrec = $this->input->post("idrec");
                $idpromulti = $this->producto_model->deletePromulti($idrec);
                $vars = $this->producto_model->verVarsPro($idproducto);
                $multi = $this->producto_model->verMulti($idproducto);
                $linea = $this->producto_model->callLinea($idproducto);
                $permisos = $this->producto_model->viewPermisos($linea);
                $datos = array();
                $i = 0;
                $arraay = explode(",", $permisos);
                foreach($vars as $va){
                    foreach($arraay as $fil){ 
                        if($fil == $va->idrnum){
                            $datosIn[$i] = array(
                                "id" => round($va->valor_num, 0),
                                "parentId" => "0",
                                "text" => "$va->descripcion",
                                "cant"=> "$va->cant",
								"valor_memo"=> "$va->valor_memo",
							);
                            $i++;
                        }
                    }
                }
                $datos = $datosIn;
                $lista_tabla = $this->producto_model->getInfoMulti($idgvar,$idproducto);
                $lista = $this->producto_model->getInfoTile($idgvar,$idproducto);
                $params = array();
                $params=array(
                    "tile"=>$lista,
                    "lista"=>$datos
                );
                echo json_encode($params);  
            }
        }
        
        function getInfoTile(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgvar = $this->input->post('idvar');
                $idproducto = $this->input->post('idproducto');
                $descrip = $this->input->post('descrip');
                $this->load->model('producto_model');
                $lista = $this->producto_model->getInfoTile($idgvar,$idproducto);
                echo json_encode($lista);
            }
        }
        
		function getBarcodesProducts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $codigo = $this->input->post('codigo');
                $this->load->model('producto_model');
                $info = $this->producto_model->getProductosCodBarra($codigo);
                echo json_encode($info);
            }
        }
        
		function getBarcodesTipoPro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $codigo = $this->input->post('codigo');
                $tipo = $this->input->post('tipo');
                $this->load->model('producto_model');
                $info = $this->producto_model->getProductosCodBarraTipo($codigo,$tipo);
                echo json_encode($info);
            }
        }
        
        function copiarProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $datasource = $this->input->post("datasource");
                $this->load->model('producto_model');
                $idcatalogo = $this->producto_model->insertCopiaProduct($datasource);
                $productos = $this->producto_model->getviewProductos($idcatalogo, 1);
                echo json_encode($productos);
            }
        }
		
		function uploadArchivoProductos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				if(isset($_FILES["inputArchivo"])){
                    $infoFile = $_FILES["inputArchivo"];
                    $nameDocument = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    
                    if($nameDocument != ""){
                        $nameDocument = trim($nameDocument);
                        
                        $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                        $config['file_name'] = $nameDocument;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('inputArchivo')){
                            $this->load->model('producto_model');
                            $dataSource = $this->producto_model->validateIngresoDeFacturas($documentTemp, $nameDocument);
                            $error = 0;
                            unlink("./doc_cuentas/".$this->session->userdata('dirDocuments')."/". $nameDocument);
                        }else{
                            $dataSource = '';
                            $error = 2;
                            $totalErrores = 1;
                        }
                    }else{
						$dataSource = '';
						$error = 1;
                        $totalErrores = 1;
					}
                }else{
                    $dataSource = '';
                    $error = 1;
                    $totalErrores = 1;
                }
                
                $array = array(
                    "dataSource" => $dataSource,
                    "error" => $error,
                );
                echo json_encode($array);
			}
		}
        
        function newMateriaPrima(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->uri->segment(2);
                if($idcatalogo!=null && $idcatalogo!=0 ){
                    $idCatalog_slc = array(
                        'idCatalog_slc' => $idcatalogo,
                        'namePage' => "Adicionar " .  $this->session->userdata('appName')
                    );
                    $this->session->set_userdata($idCatalog_slc);
                }
                $this->load->model('inicializacion_model');
                $this->data['tam'] = $this->inicializacion_model->getTableTamano();
                
                $this->load->model('producto_model');
                $this->data['linea'] = $idcatalogo;
                $tipo = $this->session->userdata('tipo_pro_listado');
                if($tipo!="" && $tipo!=null){
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipo);
                     $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipo);
                }else{
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                     $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentos();
                }
                
                $this->data['tipo_pro'] = $tipo;
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['proveedor'] = $this->producto_model->getProvee();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['medidas'] = $this->producto_model->verUM();
                $this->data['marcas'] = $this->producto_model->verMarca();
                $this->data['presenta'] = $this->producto_model->verPresenta();
                $this->load->view('new_materia_prima', $this->data);
            }
        }
             
        function modificarMateriaPrima(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->uri->segment(2);
                $idprod = $this->uri->segment(3);
                $pagina = $this->uri->segment(4);
                $idCatalog_slc = array(
                    'idCatalog_slc' => $idcatalogo,
                    'namePage' => "Modificación de  " .  $this->session->userdata('appName')." ID:". $idprod
                );
                $this->session->set_userdata($idCatalog_slc);
                
                $idPagina = array(
                    'idPagina' => $pagina,
                );
                $this->session->set_userdata($idPagina);
                
                $this->load->model('inicializacion_model');
                $this->data['tam'] = $this->inicializacion_model->getTableTamano();
                
              
                $this->load->model('cliente_model');
                $this->load->model('producto_model');
                $this->load->model('variable_model');
                $this->data['prod_dat'] = $this->producto_model->callRegistro($idprod);
               
                $linea = $this->producto_model->callLinea($idprod);
                $this->data['permisos'] = $this->producto_model->viewPermisos($linea);
                $tipo = $this->session->userdata('tipo_pro_listado');
                if($tipo!="" && $tipo!=null){
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipo);
                    $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipo);
                }else{
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                    $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentos();
                }
                
                $this->data['tipo_pro'] = $tipo;
                
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['proveedor'] = $this->producto_model->getProvee();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['medidas'] = $this->producto_model->verUM();
                $this->data['unidadesmed'] = $this->producto_model->verUnidades();
                $this->data['marcas'] = $this->producto_model->verMarca();
                $this->data['vars'] = $this->producto_model->verVars();
                $this->data['vars2'] = $this->producto_model->verVarsPro($idprod);
                $this->data['clientes'] =$this->cliente_model->viewClienteActivo();
                $this->data['clientesFrecuentes'] =$this->cliente_model->viewClientesFrecuentesProducto($idprod);
                $this->data['multi'] = $this->producto_model->verMulti($idprod);
                $this->data['idproducto'] = $idprod;
                $this->data['presenta'] = $this->producto_model->verPresenta();
               
                $this->load->view('form_update_materia_prima', $this->data);
            }
        }
   
        function newInsumo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->uri->segment(2);
                if($idcatalogo!=null && $idcatalogo!=0 ){
                    $idCatalog_slc = array(
                        'idCatalog_slc' => $idcatalogo,
                        'namePage' => "Adicionar " .  $this->session->userdata('appName')
                    );
                    $this->session->set_userdata($idCatalog_slc);
                }
                $this->load->model('inicializacion_model');
                $this->data['tam'] = $this->inicializacion_model->getTableTamano();
                
                $this->load->model('producto_model');
                $this->data['linea'] = $idcatalogo;
                $tipo = $this->session->userdata('tipo_pro_listado');
                if($tipo!="" && $tipo!=null){
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipo);
                     $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipo);
                }else{
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                     $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentos();
                }
                
                $this->data['tipo_pro'] = $tipo;
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['proveedor'] = $this->producto_model->getProvee();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['medidas'] = $this->producto_model->verUM();
                $this->data['marcas'] = $this->producto_model->verMarca();
                $this->data['presenta'] = $this->producto_model->verPresenta();
                $this->load->view('new_insumo', $this->data);
            }
        }
        
        function modificarInsumo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->uri->segment(2);
                $idprod = $this->uri->segment(3);
                $pagina = $this->uri->segment(4);
                $idCatalog_slc = array(
                    'idCatalog_slc' => $idcatalogo,
                    'namePage' => "Modificación de  " .  $this->session->userdata('appName')." ID:". $idprod
                );
                $this->session->set_userdata($idCatalog_slc);
                
                $idPagina = array(
                    'idPagina' => $pagina,
                );
                $this->session->set_userdata($idPagina);
                
                $this->load->model('inicializacion_model');
                $this->data['tam'] = $this->inicializacion_model->getTableTamano();
                
              
                $this->load->model('cliente_model');
                $this->load->model('producto_model');
                $this->load->model('variable_model');
                $this->data['prod_dat'] = $this->producto_model->callRegistro($idprod);
               
                $linea = $this->producto_model->callLinea($idprod);
                $this->data['permisos'] = $this->producto_model->viewPermisos($linea);
                $tipo = $this->session->userdata('tipo_pro_listado');
                if($tipo!="" && $tipo!=null){
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipo);
                    $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipo);
                }else{
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                    $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentos();
                }
                
                $this->data['tipo_pro'] = $tipo;
                
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['proveedor'] = $this->producto_model->getProvee();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['medidas'] = $this->producto_model->verUM();
                $this->data['unidadesmed'] = $this->producto_model->verUnidades();
                $this->data['marcas'] = $this->producto_model->verMarca();
                $this->data['vars'] = $this->producto_model->verVars();
                $this->data['vars2'] = $this->producto_model->verVarsPro($idprod);
                $this->data['clientes'] =$this->cliente_model->viewClienteActivo();
                $this->data['clientesFrecuentes'] =$this->cliente_model->viewClientesFrecuentesProducto($idprod);
                $this->data['multi'] = $this->producto_model->verMulti($idprod);
                $this->data['idproducto'] = $idprod;
                $this->data['presenta'] = $this->producto_model->verPresenta();
               
                $this->load->view('form_update_insumo', $this->data);
            }
        }
        
        function newServicio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->uri->segment(2);
                if($idcatalogo!=null && $idcatalogo!=0 ){
                    $idCatalog_slc = array(
                        'idCatalog_slc' => $idcatalogo,
                        'namePage' => "Adicionar " .  $this->session->userdata('appName')

                    );
                    $this->session->set_userdata($idCatalog_slc);
                }
                $this->load->model('inicializacion_model');
                $this->data['tam'] = $this->inicializacion_model->getTableTamano();
                
                $this->load->model('producto_model');
                $this->data['linea'] = $idcatalogo;
                $tipo = $this->session->userdata('tipo_pro_listado');
                if($tipo!="" && $tipo!=null){
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipo);
                     $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipo);
                }else{
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                     $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentos();
                }
                
                $this->data['tipo_pro'] = $tipo;
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['proveedor'] = $this->producto_model->getProvee();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['medidas'] = $this->producto_model->verUM();
                $this->data['marcas'] = $this->producto_model->verMarca();
                $this->data['presenta'] = $this->producto_model->verPresenta();
                $this->load->view('new_servicio', $this->data);
            }
        }
        
        function modificarServicio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->uri->segment(2);
                $idprod = $this->uri->segment(3);
                $pagina = $this->uri->segment(4);
                $idCatalog_slc = array(
                    'idCatalog_slc' => $idcatalogo,
                    'namePage' => "Modificación de  " .  $this->session->userdata('appName')." ID:". $idprod
                );
                $this->session->set_userdata($idCatalog_slc);
                
                $idPagina = array(
                    'idPagina' => $pagina,
                );
                $this->session->set_userdata($idPagina);
                
                $this->load->model('inicializacion_model');
                $this->data['tam'] = $this->inicializacion_model->getTableTamano();
                
              
                $this->load->model('cliente_model');
                $this->load->model('producto_model');
                $this->load->model('variable_model');
                $this->data['prod_dat'] = $this->producto_model->callRegistro($idprod);
               
                $linea = $this->producto_model->callLinea($idprod);
                $this->data['permisos'] = $this->producto_model->viewPermisos($linea);
                $tipo = $this->session->userdata('tipo_pro_listado');
                if($tipo!="" && $tipo!=null){
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipo);
                    $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipo);
                }else{
                    $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                    $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentos();
                }
                
                $this->data['tipo_pro'] = $tipo;
                
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['proveedor'] = $this->producto_model->getProvee();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['medidas'] = $this->producto_model->verUM();
                $this->data['unidadesmed'] = $this->producto_model->verUnidades();
                $this->data['marcas'] = $this->producto_model->verMarca();
                $this->data['vars'] = $this->producto_model->verVars();
                $this->data['vars2'] = $this->producto_model->verVarsPro($idprod);
                $this->data['clientes'] =$this->cliente_model->viewClienteActivo();
                $this->data['clientesFrecuentes'] =$this->cliente_model->viewClientesFrecuentesProducto($idprod);
                $this->data['multi'] = $this->producto_model->verMulti($idprod);
                $this->data['idproducto'] = $idprod;
                $this->data['presenta'] = $this->producto_model->verPresenta();
               
                $this->load->view('form_update_servicio', $this->data);
            }
        }
        
        function reclasificarProductoCatalogo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $idcatalogo = $this->input->post('idcatalogo');
                $tipoproducto = $this->input->post('tipoproducto');
                $departamento = $this->input->post('departamento');
                
                $this->load->model('producto_model');
                $this->producto_model->reclasificarProductoCatalogo($idproducto, $idcatalogo, $tipoproducto);
                $array = $this->producto_model->getviewProductos($departamento, 1);
                
                echo json_encode($array);
            }
        }
        
        function getProductsLinea(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idlinea = $this->input->post('linea');
                $this->load->model('producto_model');                
                $pro = $this->producto_model->viewProductos_Linea($idlinea);
                $cant = $this->producto_model->getCant_pro_linea($idlinea);
                $array = array('pro'=>$pro, 'cant'=>$cant);
                echo json_encode($array);
            }
        }
        
        function verificaExisteProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgvar = $this->input->post('idgvar');
                $idproducto = $this->input->post('idproducto');
                $idcps = $this->input->post('idcps');
                $this->load->model('producto_model');                
                $existe = $this->producto_model->verificaExisteProveedor($idgvar, $idproducto, $idcps);
                
                $lista_tabla = $this->producto_model->getInfoMulti($idgvar,$idproducto);
                $params=array(
                    "datos"=>$lista_tabla,
                    "existe"=>$existe
                );
                echo json_encode($params);
            }
        }
        
        function mantenimiento_exportar_productos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                $this->data['catalogo'] = $this->catalog_model->getLineasAgrupadas();
                $this->data['departamentos'] = $this->catalog_model->viewCatalogL1();
                $this->data['lineas'] = $this->catalog_model->viewCatalogL2();
                $this->load->view('mantenimiento_exportar_productos', $this->data);
            }
        }
		
        function getMultiplesPreciosReport(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $categorias = $this->input->post('categorias');
                $this->load->model('producto_model');
                $this->load->model('variable_model');
                $this->load->model('auxi_model');

                $datos = $this->producto_model->getMaestroCategorias($categorias);
                $array = array();
                $i=0;
                if($datos!=false){
                    foreach($datos as $dat){
                        $estado="";
                        if($dat->estado==1){
                            $estado = "Activo";
                        }else{
                            $estado = "Inactivo";
                        }
                        
                        $array[$i] = array(
							"tipo_registro"=>"Ficha",
                            "idproducto"=>$dat->idproducto,
                            "descrip"=>$dat->descrip,
                            "modelo"=>$dat->modelo,
                            "marca"=>$dat->marca,
                            "barcode"=>$dat->barcode,
                            "idcatalogo"=>$dat->idcatalogo,
                            "idproveedor"=>$dat->idprovee,
                            "barcode"=>$dat->barcode,
                            "barcode"=>$dat->barcode,
                            "nameDepartamento"=>$dat->nameDepartamento,
                            "nameLinea"=>$dat->nameLinea,
                            "nameProveedor"=>$dat->nameProveedor,
                            "costounitario"=>$dat->costounitario,
                            "precioventa"=>$dat->precioventa,
                            "tipo"=>$dat->tipo,
                            "tipotax"=>$dat->tipotax,
                            "um"=>$dat->um,
                            "descuento"=>$dat->descuento,
                            "xpos"=>$dat->xpos,
                            "estado"=>$estado,
                            "notas"=>$dat->notas,
                        );
                        $i++;
                    }
                }
                echo json_encode($array);
            }
        }

        function getMaestroCategoriasMultiples(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $categorias = $this->input->post('categorias');
                $this->load->model('producto_model');
                $this->load->model('variable_model');
                $this->load->model('auxi_model');

                $datos = $this->producto_model->getMaestroCategoriasMultiples($categorias);
                $array = array();
                $i=0;
                if($datos!=false){
					foreach($datos as $multi){
						$estatus="";
						if($multi->estatus==1){
							$estatus = "Activo";
						}else{
							$estatus = "Inactivo";
						}
						if($multi->askpwd==1){
							$askpwd = "Si";
						}else{
							$askpwd = "No";
						}
						$name_cliente = "";
									
						if($multi->idcps != 0){
							$name_cliente = $this->auxi_model->getNameAuxi($multi->idcps);
						}
									
						$array[$i] = array(
							"tipo_registro"=>"Multi",
							"idproducto"=>$multi->idproducto,
							"descrip"=>$multi->descrip,
							"modelo"=>$multi->modelo,
							"marca"=>$multi->marca,
							"barcode"=>$multi->barcode,
							"idcatalogo"=>$multi->idcatalogo,
							"idproveedor"=>$multi->idprovee,
							"barcode"=>$multi->barcode,
							"nameDepartamento"=>$multi->nameDepartamento,
							"nameLinea"=>$multi->nameLinea,
							"nameProveedor"=>$multi->nameProveedor,
							"costounitario"=>$multi->costounitario,	
							"precioventa"=>$multi->precioventa,
							"tipo"=>$multi->tipo,
							"tipotax"=>$multi->tipotax,
							"um"=>$multi->um,
							"descuento"=>$multi->descuento,
							"xpos"=>$multi->xpos,
							"notas"=>$multi->notas,
							"descrip_multi"=>$multi->mdescrip,
							"idcps_multi"=>$name_cliente,
							"precioventa_multi"=>$multi->precioventamulti,
							"tipo_multi"=>$multi->tipoMulti,
							"uniconv_multi"=>$multi->uniconv,
							"lowrange_multi"=>$multi->lowrange,
							"highrange_multi"=>$multi->highrange,
							"askpwd_multi"=>$askpwd,
							"profecini_multi"=>$multi->profecini,
							"profecfin_multi"=>$multi->profecfin,
							"estatus_multi"=>$multi->estatus,
						);
						$i++;
					}
				}
				echo json_encode($array);
			}
        }
		
        function mantenimiento_consulta_libros($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
				$opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
					'books_catalog' =>$opcionmenu
                );
                $this->session->set_userdata($resultAppName);
				$this->load->model('global_model');
				$controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
				$this->data['catalog_list'] = $opcionmenu;
                $this->load->view('mantenimiento_consulta_libros', $this->data);
            }
        }
        
		function getConsultaLibros(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
                $categorias = $this->input->post('catalogo');
				$this->load->model('producto_model');
				$array = array();
				$i=0;
				$data = $this->producto_model->getConsultaLibros($categorias);
				if($data!=false){
					foreach($data as $dat){						
						$array[$i] = array(
							"idproducto"=> $dat->idproducto,
							"descrip"=> $dat->descrip,
							"xpos"=> $dat->xpos,
							"saldo"=> $dat->saldo,
							"autor"=> $this->producto_model->getAutor($dat->idproducto),
							"edicion"=> $this->producto_model->getEdicion($dat->idproducto),
							"editorial"=> $this->producto_model->getEditorial($dat->idproducto),
						);
						$i++;
					}
				}
				echo json_encode($array);
			 }
		}
		
		function updateDatosLibros(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
                $categorias = $this->input->post('catalogo');
                $idproducto = $this->input->post('idproducto');
                $autor = $this->input->post('autor');
                $edicion = $this->input->post('edicion');
                $editorial = $this->input->post('editorial');
				$this->load->model('producto_model');
				$array = array();
				$i=0;
				$data = $this->producto_model->getConsultaLibros($categorias);
				if($data!=false){
					foreach($data as $dat){		
						if($dat->idproducto == $idproducto){
							$this->producto_model->updateDatosLibros($idproducto,$autor,$edicion,$editorial);
							$array[$i] = array(
								"idproducto"=> $dat->idproducto,
								"descrip"=> $dat->descrip,
								"xpos"=> $dat->xpos,
								"saldo"=> $dat->saldo,
								"autor"=> $autor,
								"edicion"=> $edicion,
								"editorial"=> $editorial,
							);
							$i++;
						}else{
							$array[$i] = array(
								"idproducto"=> $dat->idproducto,
								"descrip"=> $dat->descrip,
								"xpos"=> $dat->xpos,
								"saldo"=> $dat->saldo,
								"autor"=> $this->producto_model->getAutor($dat->idproducto),
								"edicion"=> $this->producto_model->getEdicion($dat->idproducto),
								"editorial"=> $this->producto_model->getEditorial($dat->idproducto),
							);
							$i++;
						}
						
					}
				}
				echo json_encode($array);
			 }
		}		
		
		function getInvetarioProducto(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				$this->load->model('producto_model');
                $idproducto = $this->input->post('idproducto');
				$datos = $this->producto_model->getInventarioProducto($idproducto);
				echo json_encode($datos);
				
			}
        }
        
        function importacionDeProductos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->view('mantenimiento_product_import');
            }
        }

        function getDetalleInformacionBusqueda(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $datosBusqueda = $this->input->post("informacion");
                $filtroBusqueda = $this->input->post("filtro");
                
                $infoSearch = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $infoChanged = array(";", ";", ";", ";");
                $datosBusqueda = str_replace($infoSearch, $infoChanged, $datosBusqueda);

                $this->load->model('producto_model');

                $array = array();
                $dataBusqueda = explode(";", $datosBusqueda);
                for($i=0; $i<count($dataBusqueda); $i++){

                    $informacion = $this->producto_model->getInformacionBusquedaProducto($dataBusqueda[$i], $filtroBusqueda);
                    if($informacion != false){
                        $array[$i] = array(
                            "id" => $informacion['idproducto'],
                            "producto" => $informacion['descrip'],
                            "departamento" => $informacion['departamento'],
                            "linea" => $informacion['linea'],
                            "marca" => $informacion['marca'],
                            "barcode" => $informacion['barcode'],
                            "modelo" => $informacion['modelo'],
                            "um" => $informacion['um'],
                            "costounitario" => $informacion['costounitario'],
                        );
                    }else{
                        $info_idproducto = 0; $info_modelo = "N/A"; $info_barcode = "N/A";
                        if($filtroBusqueda == "idproducto"){
                            $info_idproducto = $dataBusqueda[$i];
                        }else if($filtroBusqueda == "modelo"){
                            $info_modelo = $dataBusqueda[$i];
                        }else if($filtroBusqueda == "barcode"){
                            $info_barcode = $dataBusqueda[$i];
                        }
                        
                        $array[$i] = array(
                            "id" => $info_idproducto,
                            "producto" => "PRODUCTO NO EXISTE",
                            "departamento" => "N/A",
                            "linea" => "N/A",
                            "marca" => "N/A",
                            "modelo" => $info_modelo,
                            "barcode" => $info_barcode,
                            "um" => "N/A",
                            "costounitario" => 0,
                        );
                    }
                }

                echo json_encode($array);
            }
        }

        function getListadoBarrasProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('producto_model');
                $array = $this->producto_model->getListadoBarrasProducto($idproducto);
                
				echo json_encode($array);
            }
        }

        function insertBarcodeProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgvar = $this->input->post('idgvar');
                $barcode = $this->input->post('barcode');
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('producto_model');
                $infoBarcode = $this->producto_model->validateBarcodeEnProductos($barcode);

                $errorBarcode = 1;
                if(count($infoBarcode) == 0){
                    $errorBarcode = 0;
                    $this->producto_model->insertBarcodeProducto($idgvar, $barcode, $idproducto);
                }

                $infoBarras = $this->producto_model->getListadoBarrasProducto($idproducto);
                
                $dataSource = array(
                    "errorBarcode" => $errorBarcode,
                    "infoErrores" => $infoBarcode,
                    "infoBarras" => $infoBarras
                );

				echo json_encode($dataSource);
            }
        }

        function deleteBarcodeProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('producto_model');
                $this->producto_model->deleteBarcodeProducto($idrec);
                $array = $this->producto_model->getListadoBarrasProducto($idproducto);
                
				echo json_encode($array);
            }
        }

        function getMultiplesPreciosToInventory(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproduct = $this->input->post('idproducto');
                $this->load->model('producto_model');
                $multiplesPrecios=$this->producto_model->getMultiplesPreciosToInventory($idproduct);
                $i=0;
                foreach($multiplesPrecios as $multi){
                    $multiplesPreciosArray[$i] = array(
                        "descrip" => $multi->descrip,
                        "precioventa" => $multi->precioventa
                    );
                    $i++; 
                }

                echo json_encode($multiplesPreciosArray);
            }
        }

        function getInformacionWebStore(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');

                $this->load->model('producto_model');
                $array = $this->producto_model->getInformacionWebStore($idproducto);
                
                echo json_encode($array);
            }
        }

        function modificarInformacionWebStore(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $medidas = $this->input->post('medidas');
                $tamano = $this->input->post('tamano');
                $piezas = $this->input->post('piezas');
                $color = $this->input->post('color');
                $forma = $this->input->post('forma');
                $notas = $this->input->post('notas');
                $peso = $this->input->post('peso');

                $this->load->model('producto_model');
                $array = $this->producto_model->modificarInformacionWebStore($idproducto, $medidas, $tamano, $piezas, $color, $forma, $notas, $peso);
                
                echo json_encode($array);
            }
        }

        //FORMATO IMPORTACION PRODUCTOS
        function plantillaImportacionProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                // require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                $objPHPExcel = new Spreadsheet();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Formato Importador de Movimientos") // Titulo
                ->setSubject("Formato Importador de Movimientos") //Asunto
                ->setDescription("Formato Importador de Movimientos") //Descripción
                ->setKeywords("Formato Importador de Movimientos") //Etiquetas
                ->setCategory("Formato Importador de Movimientos"); //Categorias

                $objPHPExcel->setActiveSheetIndex(0);
                $default_border = array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => array('argb' => "000")
                );

                $style_header_rojo = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ),
                    'borders' => [
						'allBorders' => [
							'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							'color' => ['argb' => '000000'],
						],
					],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'd32f2f',
						],
                    ),
                    'font' => array(
                        'bold' => true,
						'color' => array('rgb' => 'FFFFFF'), 
                        'size' => 9,
                        'name' => 'Arial'
                    )
                );

                $style_header_azul= array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ),
                    'borders' => [
						'allBorders' => [
							'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							'color' => ['argb' => '000000'],
						],
					],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => '004ba0',
						],
                    ),
                    'font' => array(
                        'bold' => true,
						'color' => array('rgb' => 'FFFFFF'), 
                        'size' => 9,
                        'name' => 'Arial'
                    )
                );
                $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(20);

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(25); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(18); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(18); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(18); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(18); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(18); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(25); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(25); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(25); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(25); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(25);
                $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(25); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(25); 

                $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'N° Correlativo Linea');
                $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Tipo de Bien');
                $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Descripción del Producto (Máx. 120 Caracteres)');
                $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Referencia Xpos');
                $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Marca');
                $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Código de Barras');
                $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Unidad de Medida');
                $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Id Línea');
                $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Id Proveedor');
                $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Costo Unitario');
                $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Precio de Venta IVA Incluído');
                $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Impuesto Sobre Venta');
                $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Unidades Por Cartón');
                $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Presentación');
                $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'Comisión');
                $objPHPExcel->getActiveSheet()->SetCellValue('R1', '% Descuento');
                $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'Partida Arancelaria');
                $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'Tasa Arancelaria');

                $objPHPExcel->getActiveSheet()->getStyle("A1:C1")->applyFromArray( $style_header_rojo );
                $objPHPExcel->getActiveSheet()->getStyle("D1:H1")->applyFromArray( $style_header_azul );
                $objPHPExcel->getActiveSheet()->getStyle("I1:N1")->applyFromArray( $style_header_rojo );
                $objPHPExcel->getActiveSheet()->getStyle("O1:T1")->applyFromArray( $style_header_azul );

                $objPHPExcel->getActiveSheet()->getStyle('A:A')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('B:B')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('D:D')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('I:I')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('K:K')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('L:L')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                $objPHPExcel->getActiveSheet()->getStyle('M:M')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                $objPHPExcel->getActiveSheet()->getStyle('N:N')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('O:O')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('Q:Q')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('R:R')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('S:S')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('T:T')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );

                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="Plantilla_Importacion_Productos.xlsx"');
                header('Cache-Control: max-age=0');
                $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
                $objWriter->save('php://output'); 
            }
        }

        function validarArchivoImportacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('producto_model');

                try {
                    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);                    
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                
                $objPHPExcel->setActiveSheetIndex(0); 
                $sheet         = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow    = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();

                $resultado = [];
                $totalErrores = 0;
                $numLineaError = 0;
                $lineaActual = 1;
                $mensajeResultado = "";

                //arrays para validacion de campos unicos
                $descripsIngresados = [];
                $idsIngresados = [];
                $xposIngresados = [];
                $barcodesIngresados = [];

                //si el archivo ocupado no posee productos
                if($highestRow <= 1){
                    $totalErrores = 1;
                    $mensajeResultado = "¡Error! El archivo ocupado no posee productos para importar.";

                    echo json_encode(["resultado"=>$resultado, "totalErrores"=>$totalErrores, "mensajeResultado"=>$mensajeResultado]);//*/
                    return false;
                }

                #   VALIDACION PRIMARIA
                for ($row = 2; $row <= $highestRow; $row++) {
                    $hasError = false;
                    $mensajeError = "";

                    $rowData = $sheet->rangeToArray('A' . $row . ':T' . $row,NULL,TRUE,FALSE);
                    $rowData = $rowData[0];


                    $pro = array(
                        "numLinea" => trim($rowData[0]),
                        "tipo"   => trim($rowData[1]),
                        "descrip"   => trim($rowData[2]),

                        "idproducto" => trim($rowData[3]),
                        "xpos"      => trim($rowData[4]),
                        "marca"     => trim($rowData[5]),
                        "modelo"    => trim($rowData[6]),
                        "barcode"    => trim($rowData[7]),

                        "um"        => trim($rowData[8]),
                        "idcatalogo"     => trim($rowData[9]),
                        "idprovee"    => trim($rowData[10]),
                        "costounitario"    => trim($rowData[11]),
                        "precioventa"   => trim($rowData[12]),
                        "tipotax"       => trim($rowData[13]),

                        "upp"       => trim($rowData[14]),
                        "presenta"     => trim($rowData[15]),
                        "comision"      => trim($rowData[16]),
                        "descuento"      => trim($rowData[17]),
                        "copartida"  => trim($rowData[18]),
                        "coarancel"  => trim($rowData[19]),
                        "msjerror" => "",
                    );

                    // si no se han ingresado los campos requeridos se salta al siguiente producto
                    //if(!($pro["numLinea"] && $pro["tipo"] && $pro["descrip"] && $pro["idproducto"] && $pro["xpos"] && $pro["marca"] && $pro["modelo"] && $pro["barcode"] && $pro["um"] && $pro["idcatalogo"] && $pro["idprovee"] && $pro["costounitario"] != null && $pro["precioventa"] != null && $pro["tipotax"] != null && $pro["upp"] != null && $pro["presenta"] && $pro["comision"] != null && $pro["descuento"] != null && $pro["copartida"] != null && $pro["coarancel"] != null)){
                    if(!($pro["numLinea"] && $pro["descrip"] && $pro["um"] && $pro["idcatalogo"] && $pro["idprovee"] && $pro["costounitario"] != null && $pro["precioventa"] != null && $pro["tipotax"] != null)){
                        $mensajeError .= "-Uno o más datos requeridos no han sido ingresados.\n";
                        $mensajeError .= "-Número de linea: ".($row-1)."\n";
                        $totalErrores++;
                        $numLineaError++;


                        $pro["msjerror"] = $mensajeError;
                        $resultado[] = $pro;

                        continue;
                    }

                    //NUMERO CORRELATIVO DE LINEA
                        //if($pro["numLinea"] == ''){
                            //$mensajeError .= "-El número correlativo de línea esta vacío\n";
                            //$totalErrores++;
                            //$numLineaError++;
                        //}
                    //

                    //  TIPO DE PRODUCTO
                        //if($pro["tipo"] != 1 && $pro["tipo"] != 2 && $pro["tipo"] != 4)  {
                            //$mensajeError .= "-El tipo de producto deber ser 1, 2  o  4.\n";
                            //$totalErrores++;
                            //$numLineaError++;
                        //}
                    //
                
                    //  DESCRIPCION
                        //descripcion muy larga
                        if(strlen($pro["descrip"]) > 120)  {
                            $mensajeError .= "-La descripción del producto no puede ser mayor a 120 caracteres.\n";
                            $totalErrores++;
                            $numLineaError++;
                        //descripcion ya existe en el sistema
                        }else if($this->producto_model->existeProductoDescrip($pro["descrip"])){
                            $mensajeError .= "-La descripción del producto ya fue previamente registrada en el sistema.\n";
                            $totalErrores++;
                            $numLineaError++;
                        //descripcion ya existe en el archivo
                        }else if(in_array($pro["descrip"], $descripsIngresados)){
                            $mensajeError .= "-La descripción del producto ya existe en el archivo.\n";
                            $totalErrores++;
                            $numLineaError++;
                        }else{
                            $descripsIngresados[] = $pro["descrip"];
                        }
                    //

                    //  CODIGO PRO
                        //realiza las validaciones solo si se ha ingresado algo
                        if($pro['idproducto']){
                            //codigo existe
                            $existe = $this->producto_model->existeProductoID($pro["idproducto"]);
                            if(!$existe)  {
                                $mensajeError .= "-El código interno ingresado no existe.\n";
                                $totalErrores++;
                                $numLineaError++;
                            //descripcion ya existe en el archivo
                            }else if(in_array($pro["idproducto"], $idsIngresados)){
                                $mensajeError .= "-El código del producto ya existe en el archivo.\n";
                                $totalErrores++;
                                $numLineaError++;
                            }else{
                                $idsIngresados[] = $pro["idproducto"];
                            }
                        }
                       
                    //

                    //XPOS
                        //realiza las validaciones solo si se ha ingresado algo
                        if($pro["xpos"]){
                            //xpos ya existe
                            $existe = $this->producto_model->existeProductoXpos($pro["xpos"]);
                            if($existe){
                                $mensajeError .= "-La referencia Xpos ya fue previamente registrada en el sistema.\n";
                                $totalErrores++;
                                $numLineaError++;
                            //xpos ya existe en el archivo
                            }else if(in_array($pro["xpos"], $xposIngresados)){
                                $mensajeError .= "-La referencia Xpos ya existe en el archivo.\n";
                                $totalErrores++;
                                $numLineaError++;
                            }else{
                                $xposIngresados[] = $pro["xpos"];
                            }
                        }
                    //
                    
                    //BARRAS
                        //realiza las validaciones solo si se ha ingresado algo
                        if($pro["barcode"]){
                            //cod barras ya existe
                            $existe = $this->producto_model->existeProductoBarcode($pro["barcode"]);
                            if($existe){
                                $mensajeError .= "-El código de barras ya fue previamente registrado en el sistema.\n";
                                $totalErrores++;
                                $numLineaError++;
                                //cod barras ya existe en el archivo
                            }else if(in_array($pro["barcode"], $barcodesIngresados)){
                                $mensajeError .= "-El código de barras ya existe en el archivo.\n";
                                $totalErrores++;
                                $numLineaError++;
                            }else{
                                $barcodesIngresados[] = $pro["barcode"];
                            }
                        } 
                    //

                    //LINEA
                        //linea existe
                        $existe = $this->producto_model->existeLineaID($pro["idcatalogo"]);
                        if(!$existe){
                            $mensajeError .= "-La línea ingresada no existe.\n";
                            $totalErrores++;
                            $numLineaError++;
                        }
                    //

                    //PROVEEDOR
                        //proveedor existe
                        $existe = $this->producto_model->existeProveedorID($pro["idprovee"]);
                        if(!$existe){
                            $mensajeError .= "-El proveedor ingresado no existe.\n";
                            $totalErrores++;
                            $numLineaError++;
                        }
                    //

                    //COSTO UNITARIO                           
                        if( !is_numeric($pro["costounitario"]) || $pro["costounitario"] <= 0 ){
                            $mensajeError .= "-El costo unitario debe ser un número mayor a cero.\n";
                            $totalErrores++;
                            $numLineaError++;
                        }
                    //

                    //PRECIO VENTA                          
                        if( !is_numeric($pro["precioventa"]) || $pro["precioventa"] <= 0 ){
                            $mensajeError .= "-El precio de venta debe ser un número mayor a cero.\n";
                            $totalErrores++;
                            $numLineaError++;
                        }
                    //

                    //impuesto                         
                        if( !is_numeric($pro["tipotax"]) || $pro["tipotax"] < 0 ){
                            $mensajeError .= "-El impuesto sobre venta debe ser un número mayor o igual a cero.\n";
                            $totalErrores++;
                            $numLineaError++;
                        }
                    //

                    //UPC                         
                        if( $pro["upp"]){ 
                            if( !is_numeric($pro["upp"]) || $pro["upp"] < 0 ){
                                $mensajeError .= "-Las unidades por cartón debe ser un número mayor a cero.\n";
                                $totalErrores++;
                                $numLineaError++;
                            }
                        }
                    //

                    //comision                         
                        if( $pro["comision"]){ 
                            if( !is_numeric($pro["comision"]) || $pro["comision"] < 0 ){
                                $mensajeError .= "-La comisión debe ser un número mayor o igual a cero.\n";
                                $totalErrores++;
                                $numLineaError++;
                            }
                        }
                    //

                    //descuento
                        if( $pro["descuento"]){ 
                            if( !is_numeric($pro["descuento"]) || $pro["descuento"] < 0 ){
                                $mensajeError .= "-El descuento debe ser un número mayor o igual a cero.\n";
                                $totalErrores++;
                                $numLineaError++;
                            }
                        }
                    //

                    //tasa arancelaria                         
                        if( $pro["coarancel"]){ 
                            if( !is_numeric($pro["coarancel"]) || $pro["coarancel"] < 0 ){
                                $mensajeError .= "-La tasa arancelaria debe ser un número mayor o igual a cero.\n";
                                $totalErrores++;
                                $numLineaError++;
                            }
                        }
                    //

                    //Numero de linea de error
                    if($numLineaError >= 1){
                        $mensajeError .= "-Número de línea ".($row-1)."\n";
                    }
                    
                    $pro["msjerror"] = $mensajeError;
                    $resultado[] = $pro;

                    $lineaActual++;
                    $numLineaError = 0;
                }

                if($totalErrores == 0){
                    $mensajeResultado = "¡Todos los productos se han validado exitosamente!";
                }else{
                    $mensajeResultado = "¡Uno o más productos presentan errores de validación!";
                }
                    
                echo json_encode(["resultado"=>$resultado, "totalErrores"=>$totalErrores, "mensajeResultado"=>$mensajeResultado]);//*/
            }
        }

        function importarArchivoImportacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('producto_model');

                try {
                    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);                    
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                
                $objPHPExcel->setActiveSheetIndex(0); 
                $sheet         = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow    = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();

                $productos = [];
                #   VALIDACION PRIMARIA
                for ($row = 2; $row <= $highestRow; $row++) {
                    $hasError = false;
                    $mensajeError = "";

                    $rowData = $sheet->rangeToArray('A' . $row . ':T' . $row,NULL,TRUE,FALSE);
                    $rowData = $rowData[0];

                    //se arma el array con la info de los productos
                    $pro = array(
                        "tipo"   => trim($rowData[1]),
                        "descrip"   => trim($rowData[2]),

                        "idproducto"      => trim($rowData[3]),
                        "xpos"      => trim($rowData[4]),
                        "marca"     => trim($rowData[5]),
                        "modelo"    => trim($rowData[6]),
                        "barcode"    => trim($rowData[7]),

                        "um"        => trim($rowData[8]),
                        "idcatalogo"     => trim($rowData[9]),
                        "idprovee"    => trim($rowData[10]),
                        "costounitario"    => trim($rowData[11]),
                        "precioventa"   => trim($rowData[12]),
                        "tipotax"       => trim($rowData[13]),

                        "upp"       => trim($rowData[14]),
                        "presenta"     => trim($rowData[15]),
                        "comision"      => trim($rowData[16]),
                        "descuento"      => trim($rowData[17]),
                        "copartida"  => trim($rowData[18]),
                        "coarancel"  => trim($rowData[19]),
                    );
                    $pro = array_filter($pro);
                    $productos[] = $pro;
                }
                //var_dump($productos);
                $resultado = $this->producto_model->importarArrayProductos($productos);
                $mensaje = "";
                if($resultado){
                    $mensaje = "!Los productos han sido importados exitosamente!";
                }else{
                    $mensaje = "¡Error! Ocurrió un problema inesperado al subir el archivo. No se importó ningún producto.";
                }
                    
                echo json_encode(["resultado"=>$resultado['esValido'], "mensaje"=> $mensaje]);//*/
            }
        }

        //obtiene la informacion del archivo de productos
        function plantillaImportacionProductosCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{

                try {
                    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);                    
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                
                $objPHPExcel->setActiveSheetIndex(0); 
                $sheet         = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow    = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();

                $productos = [];
                #   VALIDACION PRIMARIA
                for ($row = 2; $row <= $highestRow; $row++) {
                    $hasError = false;
                    $mensajeError = "";

                    $rowData = $sheet->rangeToArray('A' . $row . ':T' . $row,NULL,TRUE,FALSE);
                    $rowData = $rowData[0];

                    //se arma el array con la info de los productos
                    $pro = array(
                        "tipo"   => trim($rowData[1]),
                        "descrip"   => trim($rowData[2]),

                        "idproducto"      => trim($rowData[3]),
                        "xpos"      => trim($rowData[4]),
                        "marca"     => trim($rowData[5]),
                        "modelo"    => trim($rowData[6]),
                        "barcode"    => trim($rowData[7]),

                        "um"        => trim($rowData[8]),
                        "idcatalogo"     => trim($rowData[9]),
                        "idprovee"    => trim($rowData[10]),
                        "costounitario"    => trim($rowData[11]),
                        "precioventa"   => trim($rowData[12]),
                        "tipotax"       => trim($rowData[13]),

                        "upp"       => trim($rowData[14]),
                        "presenta"     => trim($rowData[15]),
                        "comision"      => trim($rowData[16]),
                        "descuento"      => trim($rowData[17]),
                        "copartida"  => trim($rowData[18]),
                        "coarancel"  => trim($rowData[19]),
                    );
                    $pro = array_filter($pro);
                    $productos[] = $pro;
                }

                echo json_encode($productos);
            }
        }

        //genera el archivo para compra
        function generateComprasFile(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                // require_once APPPATH . 'libraries/Classes/PHPExcel.php';

                $productos = $this->input->post('info');
                $pro = json_decode($productos, true);

                $objPHPExcel = new Spreadsheet();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Formato generador de compra") // Titulo
                ->setSubject("Formato generador de compra") //Asunto
                ->setDescription("Formato generador de compra") //Descripción
                ->setKeywords("Formato generador de compra") //Etiquetas
                ->setCategory("Formato generador de compra"); //Categorias

                $objPHPExcel->setActiveSheetIndex(0);

                $default_border = array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => array('argb' => "000")
                );

                $style_header_rojo = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ),
                    'borders' => [
						'allBorders' => [
							'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							'color' => ['argb' => '000000'],
						],
					],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'd32f2f',
						],
                    ),
                    'font' => array(
                        'bold' => true,
						'color' => array('rgb' => 'FFFFFF'), 
                        'size' => 9,
                        'name' => 'Arial'
                    )
                );

                $style_header_azul= array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ),
                    'borders' => [
						'allBorders' => [
							'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							'color' => ['argb' => '000000'],
						],
					],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => '004ba0',
						],
                    ),
                    'font' => array(
                        'bold' => true,
						'color' => array('rgb' => 'FFFFFF'), 
                        'size' => 9,
                        'name' => 'Arial'
                    )
                );
                $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(20);

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50); 
                //$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(50); 

                //$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'N Correlativo Linea');
                $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Cod. Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Cod. Barras');
                $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Descripción del Producto');

                $aux = 2;
                foreach ($pro as $producto) {
                    if(!isset($producto['idproducto'])) $producto['idproducto'] = '';
                    if(!isset($producto['barcode'])) $producto['barcode'] = '';
                    if(!isset($producto['descrip'])) $producto['descrip'] = '';
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$aux, $producto['idproducto']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$aux, $producto['barcode']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$aux, $producto['descrip']);
                    //var_dump($producto['idproducto']." -> ".$aux." - ".$producto['descrip']." -> ".$aux);
                    $aux++;
                }

                //Llenar Informacion del excel

                $objPHPExcel->getActiveSheet()->getStyle("A1:C1")->applyFromArray( $style_header_rojo );

                $objPHPExcel->getActiveSheet()->getStyle('A:A')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('B:B')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                //$objPHPExcel->getActiveSheet()->getStyle('C:C')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );

                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="Archivo Compra.csv"');
                //header('Content-Disposition: attachment;filename="Archivo Compra.xlsx"');
                header('Cache-Control: max-age=0');
                $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Csv');
                //$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
                $objWriter->setUseBOM(true);// para archivos csv
                $objWriter->setEnclosureRequired(false);// para archivos csv
                $objWriter->save('php://output');

            }
        }

        //Actualizar precio de venta para multiples productos
        public function getProductoByCodigo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                $Datos = [];
                $conteo = 0;
                $newPrice = [];
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    $newPrice[] = trim($dator[0]);
                }
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    if (count($dator) <= 1 || $dator[0] == '' || $dator[1] == '') {
                        $conteo++;
                        $datorr = array (
                            'descripcion' => 'Datos incompletos',
                            'tipo' => -1
                        );
                    } else {
                        $tipo = 0;
                        $indicacion = '';
                        $producto = $this->producto_model->getProducto(trim($dator[0]));
                        //print_r($producto);
                        if ((count((array)$producto) == 0) || (!is_numeric(trim($dator[0])))) $tipo = 1;
                        else {
                            if (!is_numeric(trim($dator[0]))) $tipo = 1;
                            else {
                                if ((strlen(trim($dator[1])) == 0) || (strpos(trim($dator[1]), "'") !== false) || (strpos(trim($dator[1]), '"') !== false) || (strpos(trim($dator[1]), "\\") !== false)){
                                    $tipo = 2;
                                    $indicacion = 'Caraceteres no aceptados';
                                } else {
                                    if (count((array)$producto) <= 0) {
                                        //$dato = $this->producto_model->getProductobyBarcode(trim($dator[1]));
                                        $indicacion = '['.$producto->idproducto.'] '.$producto->descrip;
                                        $tipo = 3;
                                    } else {
                                        $cont = 0;
                                        foreach ($newPrice as $valor) {
                                            if (trim($dator[0]) == $valor) $cont++;
                                        }
                                        if($cont > 1) {
                                            $indicacion = 'Codigo de Producto repetido';
                                            $tipo = 4;
                                        }
                                        if($producto->costounitario >= trim(str_replace(' ', '', $dator[1]))) $tipo = 5;
                                    }
                                }
                            }
                        }

                        if ($tipo != 0) $conteo++;
                        $datorr = array(
                            'codigo' => trim($dator[0]),
                            'descripcion' => ($tipo == 0) ? $producto->descrip : $indicacion,//($tipo == 1) ? '' : (($tipo == 2) ? $indicacion : (($tipo == 3) ? $indicacion : $producto->descrip)),
                            'precioVenta' => ($tipo == 0) ? number_format($producto->precioventa, 2) : 0,
                            'precioNuevo' => number_format(trim(str_replace(' ', '', $dator[1])), 2),
                            'tipo' => $tipo
                        );
                    }
                    $Datos [] = $datorr;
                }
                $datA[] = array('valido' => (($conteo == 0) ? true : false), 'datos' => $Datos);
                echo json_encode($datA);
            }
        }

        public function updateProductPrice(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                date_default_timezone_set('America/El_Salvador');
                $conteomalos = 0;
                $malos = [];
                //print_r($registros);
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    $ID = $dator[0];
                    $data = array(
                        'precioventa' => number_format(trim(str_replace(' ', '', $dator[1])), 2),
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    //print_r($data);
                    if (!$this->producto_model->updateProductPrice($data, $ID)) {
                        $conteomalos++;
                        $malos[] = $dator[0];
                    }
                }
                $malos = implode(";",$malos);
                $datA[] = array('valido' => ($conteomalos > 0) ? false : true, 'malos' => $malos);
                //print_r($datA);
                echo json_encode($datA);
            }
        }

        //Actualizar piezas por fardo
        public function validateActUppData()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                $Datos = [];
                $conteo = 0;
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    if (count($dator) < 3 || $dator[0] == '' || $dator[1] == '') {
                        $conteo++;
                        $datorr = array (
                            'codigo' => $dator[0],
                            'descripcion' => 'Datos incompletos',
                            'upp' => '',
                            'newUpp' => $dator[1],
                            'notas' => '',
                            'error' => 1
                        );

                        $Datos [] = $datorr;
                    } else {
                        $lastElement = array_slice($dator, 2);
                        $dator[2] = implode(', ',$lastElement);
                        $dator = array_splice($dator, 0, 3);

                        $producto = $this->producto_model->getProductUpdateUpp($dator[0]);
                        if ( $producto != null ) {
                            if (!is_numeric($dator[1])) {
                                $datorr = array(
                                    'codigo' => $dator[0],
                                    'descripcion' => 'UPC ingresado no es valido',
                                    'upp' => $producto->upp,
                                    'newUpp' => $dator[1],
                                    'notas' => $dator[2],
                                    'error' => 2
                                );
                                $conteo++;
                            } else {
                                $datorr = array(
                                    'codigo' => $dator[0],
                                    'descripcion' => $producto->descrip,
                                    'upp' => $producto->upp,
                                    'newUpp' => $dator[1],
                                    'notas' => $dator[2],
                                    'error' => 0
                                );
                            }
    
                            $Datos [] = $datorr;
                        } else {
                            $datorr = array(
                                'codigo' => $dator[0],
                                'descripcion' => 'Producto no encontrado',
                                'upp' => '',
                                'newUpp' => $dator[1],
                                'notas' => $dator[2],
                                'error' => 2
                            );

                            $conteo++;
                            $Datos [] = $datorr;
                        }
                    }
                }
                $datA[] = array('valido' => (($conteo == 0) ? true : false), 'datos' => $Datos);
                echo json_encode($datA);
            }
        }
        
        public function setActUpp()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('producto_model');
                $registros = $this->input->post("registros");
                //var_dump($registros);
                
                date_default_timezone_set('America/El_Salvador');
                $conteomalos = 0;
                $malos = [];
                foreach (explode("\n", $registros) as $registro) {
                    $dator = explode(",", $registro);
                    //udpate
                    $data = array(
                        'upp' => $dator[1],
                        'notas' => $dator[2],
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                        'whodidit' => $this->session->userdata('iduser')
                    );

                    if (!$this->producto_model->updateProductUpp($dator[0], $data)) {
                        $conteomalos++;
                        $malos[] = $dator[0].','.$dator[1];
                    }
                }
                $malos = implode(";",$malos);
                $datA[] = array('valido' => ($conteomalos > 0) ? false : true, 'malos' => $malos);
                echo json_encode($datA);
            }
        }
    }
?>