<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
    require 'vendor/autoload.php';
                        
    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
    use PhpOffice\PhpSpreadsheet\Shared\Date;

    class Produccion extends CI_Controller{
        
        function __construct() {
            parent::__construct();
        }

        function ordenDeProduccion($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $infoApps = $this->configuracion_model->getOptionsByidapp($idApp);
                $appOptions = explode(",", $infoApps);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'tipoProducto' => $appOptions[0],
                    'idCentroOP' => $appOptions[1],
                    'idCatalogoProductos' => $appOptions[4]
                );
                $this->session->set_userdata($resultAppName);
                
                $direccion = $this->uri->segment(1);
				$idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('global_model');
                $this->load->model('compras_model');
                
                $this->data['idcentro_produccion'] = $appOptions[1];
                $this->data['idproveedor_produccion'] = $appOptions[2];
                $this->data['idclase_produccion'] = $appOptions[3];
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['nameSucursal'] = $this->configuracion_model->getNameCentroPasteles($appOptions[1]);
				$this->data['descrip'] = $this->compras_model->getDescripTipoPro($appOptions[0]);
                $this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['compras'] = $this->compras_model->getTiposCompras("CO");
                $this->data['proveedores_ordenes'] = $this->compras_model->getListadopProveedoresOrdenes("CO", $appOptions[0], $idcentro);
                $this->data['periodos'] = $this->compras_model->getPeriodosCompras(1);
                
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days"));
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;
                
                $this->load->view('pedidos/mantenimiento_orden_produccion', $this->data);
            }
        }
        
        function getListadoOrdenesDeProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$idclase = $this->input->post('idclase');
                $idcentro = $this->input->post('idcentro');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $tipoProducto = $this->session->userdata('tipoProducto');

                $this->load->model('compras_model');
                $this->load->model('produccion_model');
                $datos = $this->produccion_model->getListadoOrdenesDeProduccion('CO', $tipoProducto, $idcentro, $idclase, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                foreach($datos as $info){
                    $linea = 0; $canti = 0;
					if($info->valcosto == null || $info->valcosto == ""){
                        $valcosto = 0;
                    }else{
                        $valcosto = number_format($info->valcosto, 2, '.', '');
                    }
                    
                    if($info->fecha4=="0000-00-00"){
                        $fechacierre  = "";
                    }else{
                        $fechacierre  = $info->fecha4;
                    }
                    
                    $informacion = $this->compras_model->getDetalleLineasCompraLocal($info->trannum, $info->estatus);
                    foreach($informacion as $cmp){
                        $linea++;
                        $canti+= $cmp->cantidad;
                    }
                    
                    $array[$i] = array(
						"trannum" => $info->trannum,
                        "fecha" => $info->fecha3,
                        "fecact" => $fechacierre,
                        "estatus" => $info->estatus,
                        "descrip" => $info->descrip,
                        "serie" => $info->serie.''.$info->numero,
                        "referencia" => $info->referencia,
                        "valventa" => $valcosto,
						"notas" => $info->notas,
						"lineaunidad" => $linea.'/'.number_format($canti)
                    );
                    $i++;
                }
                    
                echo json_encode($array);
            }
        }
        
        function getListadoLotesDePreparacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getListadoLotesDePreparacion($idcentro, 'PP');
                
                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => $info->trannum,
                            "descrip" => "Lote Preparación N° " . $info->trannum . " " . $info->fecha
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getListadoLotesPreparacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idCentroOP');
                
                $this->load->model('compras_model'); $this->load->model('produccion_model');
                
                $datos = $this->compras_model->getInformacionOrden($trannum);
                $informacion = $this->produccion_model->getListadoLotesDePreparacion($idcentro, 'PP');
                
                foreach($datos as $inf){
                    $notas = $inf->notas;
                }
                
                $codLotes = explode(",", $notas);
                
                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        
                        $insert = 0;
                        for($j=0; $j<count($codLotes); $j++){
                            if($codLotes[$j] == $info->trannum){
                                $insert = 1;
                            }
                        }
                        
                        if($insert == 0){
                            $array[$i] = array(
                                "id" => $info->trannum,
                                "text" => "Lote Preparación N° " . $info->trannum . " " . $info->fecha
                            );
                            $i++;
                        }
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getDatosProductosOrdenProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                
                $this->load->model('produccion_model');
                $infoProductos = $this->produccion_model->getDatosProductosOrdenProduccion($trannum);
                
                $i=0;
                $array = array();
                foreach($infoProductos as $info){
                    $datosMaster = $this->produccion_model->getListMovimientoProductoProduccion($info->idproducto, $trannum);
                    
                    if($info->cantidad != 0){
                        $porcentaje = ($info->producidos / $info->cantidad) * 100;
                    }else{
                        $porcentaje = 0;
                    }

                    $array[$i] = array(
                        "xpos" => $info->xpos,
                        "costouni" => $info->costouni,
                        "precioventa" => $info->precioventa,
                        "tipotax" => $info->tipotax,
                        "idrec" => $info->idrec,
                        "uniconv" => $info->uniconv,
                        "umkt" => $info->umkt,
                        "itemline" => $info->itemline,
                        "idcatalogo" => $info->idcatalogo,
                        "descrip" => $info->descrip,
                        "imagen" => $info->imagen,
                        "modelo" => $info->modelo,
                        "um" => $info->um,
                        "marca" => $info->marca,
                        "idproducto" => $info->idproducto,
                        "barcode" => $info->barcode,
                        "notas" => $info->notas,
                        "cantidad" => $info->cantidad,
                        "preciotran" => $info->preciotran,
                        "subtotal" => $info->subtotal,
                        "descuento" => $info->descuento,
                        "precioneto" => $info->precioneto,
                        "modNotas" => $info->modNotas,
                        "linea" => $info->linea,
                        "producidos" => $info->producidos,
                        "estatus" => $info->estatus,
                        "nivel" => 0,
                        "porcentaje" => number_format($porcentaje, 2, '.', ',') . "%",
                        "detalleProducto" => $datosMaster
                    );
                    
                    $i++;
                }
                                
                echo json_encode($array);
            }
        }
        
        function generarOrdenDeProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $idclase = $this->input->post('idclase');
                $fecha = $this->input->post('fecha');
                $idproveedor = $this->input->post('idproveedor');
                $tipoProducto = $this->session->userdata('tipoProducto');
                $lotesPreparacion = $this->input->post('idlotes');
                $solicita = $this->input->post('solicita');
                
                $this->load->model('produccion_model');
                $trannum = $this->produccion_model->generarOrdenDeProduccion($idcentro, $idclase, $fecha, $idproveedor, $tipoProducto, $lotesPreparacion, $solicita);
                
                echo json_encode($trannum);
            }
        }
        
        function informacionOrdenDeProduccion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum,
                    'tipoprod' => $this->session->userdata('tipoProducto')
                );
                $this->session->set_userdata($resultAppName);
                
                $tipopro = $this->session->userdata('tipoProducto');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $this->load->model('invtran_model'); $this->load->model('global_model');
                $this->load->model('variable_model'); $this->load->model('producto_model');
                				
                $direccion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['cantidades'] = $this->compras_model->getCantidadesTran100kt($trannum);
                $this->data['unidades'] = $this->compras_model->getUnidadesTran100kt($trannum);
                $this->data['tipo_pro'] = $tipopro;
                $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
                $this->data['informacion'] = $this->compras_model->getInformacionOrden($trannum);
                $this->data['productos'] = $this->compras_model->getProductosTempOrden($trannum);
                
                $this->load->view('pedidos/mantenimiento_detalle_orden_produccion', $this->data); 
            }
        }

        function getTotalesDetalleProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('compras_model');
                $cantidades = $this->compras_model->getCantidadesTran100kt($trannum);
                $unidades   = $this->compras_model->getUnidadesTran100kt($trannum);

                echo json_encode([
                    "cantidades" => $cantidades,
                    "unidades"   => number_format($unidades, 0, '.', ',')
                ]);
            }   
        }
        
        function getDetalleProductosLista(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post("trannum");
                $idcatalogo = $this->session->userdata('idCatalogoProductos');
				
                $this->load->model('produccion_model');
				$informacion = $this->produccion_model->getDetalleProductosLista($trannum, $idcatalogo);
                $j=0;
                $array_datos = array();
                
                if($informacion!=false){
                    foreach($informacion as $info){
                        if($info->existe == 0){
                            $array_datos[$j] = array(
                                "idproducto" => $info->idproducto,
                                "descrip" => $info->descrip,
                                "costounitario" => $info->costounitario,
                                "idcatalogo" => $info->idcatalogo,
                                "linea" => $info->linea,
                                "modelo" => $info->modelo,
                                "um" => $info->um,
                                "precioventa" => $info->precioventa,
                                "marca" => $info->marca,
                                "tipotax" => $info->tipotax
                            );

                            $j++;
                        }
                    }
                }
                
                echo json_encode($array_datos);
            }
        }
        
        function insertarProductosOrdenProduccion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idproductos = $this->input->post('idproductos');
                
                $this->load->model('compras_model'); $this->load->model('produccion_model');
                
				if(trim($idproductos)!=""){
                    $array_string = explode(", ", $idproductos);
                    if(count($array_string)==0){
                        $insert = $this->compras_model->insertProCompraLocal($trannum,trim($array_string));
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $insert = $this->compras_model->insertProCompraLocal($trannum,trim($array_string[$i]));
                        }
                    }
                }
                
                $infoProductos = $this->produccion_model->getDatosProductosOrdenProduccion($trannum);
                
                $i=0;
                $datos = array();
                foreach($infoProductos as $info){
                    $datosMaster = $this->produccion_model->getListMovimientoProductoProduccion($info->idproducto, $trannum);
                    
                    if($info->cantidad != 0){
                        $porcentaje = ($info->producidos / $info->cantidad) * 100;
                    }else{
                        $porcentaje = 0;
                    }

                    $datos[$i] = array(
                        "xpos" => $info->xpos,
                        "costouni" => $info->costouni,
                        "precioventa" => $info->precioventa,
                        "tipotax" => $info->tipotax,
                        "idrec" => $info->idrec,
                        "uniconv" => $info->uniconv,
                        "umkt" => $info->umkt,
                        "itemline" => $info->itemline,
                        "idcatalogo" => $info->idcatalogo,
                        "descrip" => $info->descrip,
                        "imagen" => $info->imagen,
                        "modelo" => $info->modelo,
                        "um" => $info->um,
                        "marca" => $info->marca,
                        "idproducto" => $info->idproducto,
                        "barcode" => $info->barcode,
                        "notas" => $info->notas,
                        "cantidad" => $info->cantidad,
                        "preciotran" => $info->preciotran,
                        "subtotal" => $info->subtotal,
                        "descuento" => $info->descuento,
                        "precioneto" => $info->precioneto,
                        "modNotas" => $info->modNotas,
                        "estatus" => $info->estatus,
                        "linea" => $info->linea,
                        "producidos" => $info->producidos,
                        "nivel" => 0,
                        "porcentaje" => number_format($porcentaje, 2, '.', ',') . "%",
                        "detalleProducto" => $datosMaster
                    );
                    
                    $i++;
                }
                
                $cantidad = $this->compras_model->getCantidadesTran100kt($trannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($trannum);
                                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades)
                );
                
                echo json_encode($array);
            }
        }
        
        function updateRegistroProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $cantidad = $this->input->post('cantidad');
                
                $this->load->model('compras_model'); $this->load->model('produccion_model');
                $this->produccion_model->updateRegistroProduccion($idrec, $cantidad);
                
                $infoProductos = $this->produccion_model->getDatosProductosOrdenProduccion($trannum);
                
                $i=0;
                $datos = array();
                foreach($infoProductos as $info){
                    $datosMaster = $this->produccion_model->getListMovimientoProductoProduccion($info->idproducto, $trannum);
                    
                    if($info->cantidad != 0){
                        $porcentaje = ($info->producidos / $info->cantidad) * 100;
                    }else{
                        $porcentaje = 0;
                    }

                    $datos[$i] = array(
                        "xpos" => $info->xpos,
                        "costouni" => $info->costouni,
                        "precioventa" => $info->precioventa,
                        "tipotax" => $info->tipotax,
                        "idrec" => $info->idrec,
                        "uniconv" => $info->uniconv,
                        "umkt" => $info->umkt,
                        "itemline" => $info->itemline,
                        "idcatalogo" => $info->idcatalogo,
                        "descrip" => $info->descrip,
                        "imagen" => $info->imagen,
                        "modelo" => $info->modelo,
                        "um" => $info->um,
                        "marca" => $info->marca,
                        "idproducto" => $info->idproducto,
                        "barcode" => $info->barcode,
                        "notas" => $info->notas,
                        "cantidad" => $info->cantidad,
                        "preciotran" => $info->preciotran,
                        "subtotal" => $info->subtotal,
                        "descuento" => $info->descuento,
                        "precioneto" => $info->precioneto,
                        "modNotas" => $info->modNotas,
                        "linea" => $info->linea,
                        "estatus" => $info->estatus,
                        "producidos" => $info->producidos,
                        "nivel" => 0,
                        "porcentaje" => number_format($porcentaje, 2, '.', ',') . "%",
                        "detalleProducto" => $datosMaster
                    );
                    
                    $i++;
                }
                
                $cantidad = $this->compras_model->getCantidadesTran100kt($trannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($trannum);
                                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades)
                );
                
                echo json_encode($array);
            }
        }
        
        function updateRegistroDetalleProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec        = $this->input->post('idrec');
                $trannum      = $this->input->post('idtrannum');
                $idcentro     = $this->input->post('idcentro');
                $idproducto   = $this->input->post('idproducto');
                $cantidad     = $this->input->post('cantidad');
                $cantidad_ant = $this->input->post('cantidad_ant');
                
                $this->load->model('compras_model'); $this->load->model('produccion_model');
                $existencia = $this->produccion_model->getExistenciasProducto($idproducto, $idcentro);

                $infoA    = $cantidad_ant - $cantidad;
                $infoB    = $existencia   - $infoA;
                $validate = ($infoB > 0) ? 1 : 0;

                if($validate == 1){
                    $this->produccion_model->updateRegistroDetalleProduccion($idrec, $cantidad);
                }
                
                $infoProductos = $this->produccion_model->getDatosProductosOrdenProduccion($trannum);
                
                $i=0;
                $datos = array();
                foreach($infoProductos as $info){
                    $datosMaster = $this->produccion_model->getListMovimientoProductoProduccion($info->idproducto, $trannum);
                    
                    if($info->cantidad != 0){
                        $porcentaje = ($info->producidos / $info->cantidad) * 100;
                    }else{
                        $porcentaje = 0;
                    }

                    $datos[$i] = array(
                        "xpos" => $info->xpos,
                        "costouni" => $info->costouni,
                        "precioventa" => $info->precioventa,
                        "tipotax" => $info->tipotax,
                        "idrec" => $info->idrec,
                        "uniconv" => $info->uniconv,
                        "umkt" => $info->umkt,
                        "itemline" => $info->itemline,
                        "idcatalogo" => $info->idcatalogo,
                        "descrip" => $info->descrip,
                        "imagen" => $info->imagen,
                        "modelo" => $info->modelo,
                        "um" => $info->um,
                        "marca" => $info->marca,
                        "idproducto" => $info->idproducto,
                        "barcode" => $info->barcode,
                        "notas" => $info->notas,
                        "cantidad" => $info->cantidad,
                        "preciotran" => $info->preciotran,
                        "subtotal" => $info->subtotal,
                        "descuento" => $info->descuento,
                        "precioneto" => $info->precioneto,
                        "modNotas" => $info->modNotas,
                        "estatus" => $info->estatus,
                        "linea" => $info->linea,
                        "producidos" => $info->producidos,
                        "nivel" => 0,
                        "porcentaje" => number_format($porcentaje, 2, '.', ',') . "%",
                        "detalleProducto" => $datosMaster
                    );
                    
                    $i++;
                }
                
                $cantidad = $this->compras_model->getCantidadesTran100kt($trannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($trannum);
                                
                $array = array(
                    "datos"       => $datos,
                    "cantidad"    => $cantidad,
                    "unidades"    => number_format($unidades),
                    "existencia"  => $existencia,
                    "infoA"       => $infoA,
                    "infoB"       => $infoB,
                    "resultado"   => $validate
                );
                
                echo json_encode($array);
            }
        }

        function cambioEstadoOrdenProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('produccion_model');
                $array = $this->produccion_model->cambioEstadoOrdenProduccion($trannum);

                echo json_encode($array);
            }
        }
        
        function eliminarRegistroProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                
                $this->load->model('compras_model'); $this->load->model('produccion_model');
                $this->produccion_model->eliminarRegistroProduccion($idrec);
                
                $infoProductos = $this->produccion_model->getDatosProductosOrdenProduccion($trannum);
                
                $i=0;
                $datos = array();
                foreach($infoProductos as $info){
                    $datosMaster = $this->produccion_model->getListMovimientoProductoProduccion($info->idproducto, $trannum);
                    
                    if($info->cantidad != 0){
                        $porcentaje = ($info->producidos / $info->cantidad) * 100;
                    }else{
                        $porcentaje = 0;
                    }

                    $datos[$i] = array(
                        "xpos" => $info->xpos,
                        "costouni" => $info->costouni,
                        "precioventa" => $info->precioventa,
                        "tipotax" => $info->tipotax,
                        "idrec" => $info->idrec,
                        "uniconv" => $info->uniconv,
                        "umkt" => $info->umkt,
                        "itemline" => $info->itemline,
                        "idcatalogo" => $info->idcatalogo,
                        "descrip" => $info->descrip,
                        "imagen" => $info->imagen,
                        "modelo" => $info->modelo,
                        "um" => $info->um,
                        "marca" => $info->marca,
                        "idproducto" => $info->idproducto,
                        "barcode" => $info->barcode,
                        "notas" => $info->notas,
                        "cantidad" => $info->cantidad,
                        "preciotran" => $info->preciotran,
                        "subtotal" => $info->subtotal,
                        "descuento" => $info->descuento,
                        "precioneto" => $info->precioneto,
                        "modNotas" => $info->modNotas,
                        "estatus" => $info->estatus,
                        "linea" => $info->linea,
                        "producidos" => $info->producidos,
                        "nivel" => 0,
                        "porcentaje" => number_format($porcentaje, 2, '.', ',') . "%",
                        "detalleProducto" => $datosMaster
                    );
                    
                    $i++;
                }
                
                $cantidad = $this->compras_model->getCantidadesTran100kt($trannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($trannum);
                                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades)
                );
                
                echo json_encode($array);
            }
        }
        
        function eliminarRegistroProduccionPrincipal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                
                $this->load->model('compras_model'); $this->load->model('produccion_model');
                $this->produccion_model->eliminarRegistroProduccionPrincipal($idrec);
                
                $infoProductos = $this->produccion_model->getDatosProductosOrdenProduccion($trannum);
                
                $i=0;
                $datos = array();
                foreach($infoProductos as $info){
                    $datosMaster = $this->produccion_model->getListMovimientoProductoProduccion($info->idproducto, $trannum);
                    
                    if($info->cantidad != 0){
                        $porcentaje = ($info->producidos / $info->cantidad) * 100;
                    }else{
                        $porcentaje = 0;
                    }

                    $datos[$i] = array(
                        "xpos" => $info->xpos,
                        "costouni" => $info->costouni,
                        "precioventa" => $info->precioventa,
                        "tipotax" => $info->tipotax,
                        "idrec" => $info->idrec,
                        "uniconv" => $info->uniconv,
                        "umkt" => $info->umkt,
                        "itemline" => $info->itemline,
                        "idcatalogo" => $info->idcatalogo,
                        "descrip" => $info->descrip,
                        "imagen" => $info->imagen,
                        "modelo" => $info->modelo,
                        "um" => $info->um,
                        "marca" => $info->marca,
                        "idproducto" => $info->idproducto,
                        "barcode" => $info->barcode,
                        "notas" => $info->notas,
                        "cantidad" => $info->cantidad,
                        "preciotran" => $info->preciotran,
                        "subtotal" => $info->subtotal,
                        "descuento" => $info->descuento,
                        "precioneto" => $info->precioneto,
                        "modNotas" => $info->modNotas,
                        "estatus" => $info->estatus,
                        "linea" => $info->linea,
                        "producidos" => $info->producidos,
                        "nivel" => 0,
                        "porcentaje" => number_format($porcentaje, 2, '.', ',') . "%",
                        "detalleProducto" => $datosMaster
                    );
                    
                    $i++;
                }
                
                $cantidad = $this->compras_model->getCantidadesTran100kt($trannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($trannum);
                                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades)
                );
                
                echo json_encode($array);
            }
        }
        
        function anularOrdenProduccion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$trannum = $this->input->post('trannum');
                
				$this->load->model('produccion_model');
                $array = $this->produccion_model->anularOrdenProduccion($trannum);
				
				echo json_encode($array);
			}
		}
        
        function cierreOrdenProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
				$this->load->model('produccion_model');
                $datos = $this->produccion_model->getDatosProductosOrdenProduccion($trannum);
				
                $ordenados = 0; $producidos = 0;
                foreach($datos as $info){
                    $ordenados = $ordenados + $info->cantidad;
                    $producidos = $producidos + $info->producidos;
                }
                
                $porcentaje = ($producidos / $ordenados) * 100;
                
                $array = array(
                    "porcentaje" => number_format($porcentaje, 2, '.', ','),
                    "producidos" => $producidos
                );
				
                echo json_encode($array);
            }
        }
        
        function updateEstadoCierreProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
				$this->load->model('produccion_model');
                $array = $this->produccion_model->updateEstadoCierreProduccion($trannum);
				
                echo json_encode($array);
            }
        }
        
        function insertarLotesDePreparacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $codigos = $this->input->post('codigos');
                
                $this->load->model('produccion_model');
                $array = $this->produccion_model->insertarLotesDePreparacion($trannum, $codigos);
				
                echo json_encode($array);
            }
        }
        
        function calendarioDePedidos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('global_model');
                $direccion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['centros_colors'] = $this->global_model->getDetalleCentrosColors();
                
                $this->load->view('pedidos/mantenimiento_calendario_produccion', $this->data);
            }
        }
        
        function getEncabezadosDePedidos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getEncabezadosDePedidos($idcentro);
				
                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        
                        $date = new DateTime($info->fentrega);
                        
                        $cantidadFecha = $this->produccion_model->getCantidadDeProductosCentro($idcentro, $info->procentro, $date->format('d'), $date->format('m'), $date->format('Y'));
                        
                        $array[$i] = array(
                            "idrec" => $info->idrec,
                            "idyear" => $info->idyear,
                            "idmonth" => $info->idmonth,
                            "text" => $cantidadFecha."/".$info->posibles,
                            "namecentro" => strtoupper($info->nameProduccion),
                            "startDate" => $info->fentrega . ' 00:00:00',
                            "endDate" => $info->fentrega . ' 23:59:59',
                            "fentrega" => $date->format('d/m/Y'),
                            "dateIni" => $info->fpedidoini,
                            "dateFin" => $info->fpedidofin,
                            "bcolor" => $info->bcolor,
                            "fcolor" => $info->fcolor,
                            "procentro" => $info->procentro,
                            "notas" => $info->notas,
                            "estado" => $info->estado
                        );
                        
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getDatosProduccionCalendario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getEncabezadosDePedidos($idcentro);
				
                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        
                        $date = new DateTime($info->fentrega);
                        
                        $cantidadFecha = $this->produccion_model->getCantidadDeProductosCentro($idcentro, $info->procentro, $date->format('d'), $date->format('m'), $date->format('Y'));
                        
                        $array[$i] = array(
                            "idrec" => $info->idrec,
                            "idyear" => $info->idyear,
                            "idmonth" => $info->idmonth,
                            "text" => $cantidadFecha."/".$info->posibles,
                            "namecentro" => strtoupper($info->nameProduccion),
                            "startDate" => $info->fentrega . ' 00:00:00',
                            "endDate" => $info->fentrega . ' 23:59:59',
                            "fentrega" => $date->format('d/m/Y'),
                            "dateIni" => $info->fpedidoini,
                            "dateFin" => $info->fpedidofin,
                            "bcolor" => $info->bcolor,
                            "fcolor" => $info->fcolor,
                            "procentro" => $info->procentro,
                            "notas" => $info->notas
                        );
                        
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getListadoProductosAgrupados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idyear = $this->input->post('idyear');
                $idmonth = $this->input->post('idmonth');
                $procentro = $this->input->post('procentro');
                $dayCalendar = $this->input->post('dayCalendar');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getListadoProductosAgrupados($procentro, $idcentro, $dayCalendar, $idyear, $idmonth);
				
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "item" => $i + 1,
                            "idregistro" => $info->idregistro,
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "linea" => $info->linea,
                            "procentro" => $info->procentro,
                            "cantidad" => $info->cantidad,
                            "presenta" => $info->presenta,
                            "imagen" => $info->imagen
                        );
                        
                        $i++;
                    }
                }
                
                $array = array(
                    'info' => $dataSource,
                    'total' => $i
                );
                
                echo json_encode($array);
            }
        }

        function getListadoProductosAgrupadosModificacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idyear = $this->input->post('idyear');
                $idmonth = $this->input->post('idmonth');
                $procentro = $this->input->post('procentro');
                $dayCalendar = $this->input->post('dayCalendar');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getListadoProductosAgrupadosModificacion($procentro, $idcentro, $dayCalendar, $idyear, $idmonth, $idrec);
				
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "item" => $i + 1,
                            "idregistro" => $info->idregistro,
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "linea" => $info->linea,
                            "procentro" => $info->procentro,
                            "cantidad" => $info->cantidad,
                            "id_cambio" => $info->id_cambio,
                            "cantidad_aj" => $info->cantidad_aj,
                            "cantidad_nv" => $info->cantidad + (($info->cantidad_aj == '') ? 0 : $info->cantidad_aj),
                            "notas_mod" => $info->notas_mod,
                            "presenta" => $info->presenta,
                            "imagen" => $info->imagen
                        );
                        
                        $i++;
                    }
                }
                
                $array = array(
                    'info' => $dataSource,
                    'total' => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function agregarProductosCalendario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $dataSource = $this->input->post('dataSource');
                $dayCalendar = $this->input->post('dayCalendar');
                
                $this->load->model('produccion_model');
                $array = $this->produccion_model->agregarProductosCalendario($dataSource, $dayCalendar);
				
                echo json_encode($array);
            }
        }
        
        function updateRegistroCalendario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->input->post('procentro');
                $cantidad = $this->input->post('cantidad');
                $idproducto = $this->input->post('idproducto');
                $dayCalendar = $this->input->post('dayCalendar');
                
                $this->load->model('produccion_model');
                $this->produccion_model->updateRegistroCalendario($idrec, $cantidad, $dayCalendar);
				$informacion = $this->produccion_model->getOnlyDataCalendarioProductos($procentro, $idcentro, $dayCalendar);
				
                $i=0;
                $array=array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "linea" => $info->linea,
                            "procentro" => $info->procentro,
                            "cantidad" => $info->cantidad
                        );
                        
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }

        function updateRegistroCalendarioModificado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $id_cambio = $this->input->post('id_cambio');
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->input->post('procentro');
                $cantidad = $this->input->post('cantidad');
                $cantidad_aj = $this->input->post('cantidad_aj');
                $idproducto = $this->input->post('idproducto');
                $idyear = $this->input->post('idyear');
                $idmonth = $this->input->post('idmonth');
                $dayCalendar = $this->input->post('dayCalendar');
                $notas = $this->input->post('notas');
                
                $this->load->model('produccion_model');
                $this->produccion_model->updateRegistroCalendarioModificado($id_cambio, $idproducto, $idcentro, $idrec, $cantidad, $cantidad_aj, $notas);
				$informacion = $this->produccion_model->getOnlyDataCalendarioProductosModificado($procentro, $idcentro, $idyear, $idmonth, $dayCalendar, $idrec);
				
                $i=0;
                $dataSource=array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "item" => $i + 1,
                            "idregistro" => $info->idregistro,
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "linea" => $info->linea,
                            "procentro" => $info->procentro,
                            "cantidad" => $info->cantidad,
                            "id_cambio" => $info->id_cambio,
                            "cantidad_aj" => $info->cantidad_aj,
                            "cantidad_nv" => $info->cantidad + $info->cantidad_aj,
                            "notas_mod" => $info->notas_mod,
                            "presenta" => $info->presenta,
                            "imagen" => $info->imagen
                        );
                        
                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }
        
        function validateTokenModificacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $procentro = $this->input->post('procentro');
                $infoToken = $this->input->post('infoToken');
                $idproducto = $this->input->post('idproducto');
                $dayCalendar = $this->input->post('dayCalendar');
                $motivoChange = $this->input->post('motivo');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $reemplazar = array("", "", "", "");
                $motivoChange = str_replace($buscar, $reemplazar, $motivoChange);
                
                $this->load->model('produccion_model');
                $array = $this->produccion_model->validateTokenModificacion($idrec, $infoToken);
                if($array == true){
                    $this->produccion_model->updateRegistroCalendarioToken($idregistro, $cantidad, $dayCalendar, $motivoChange, $infoToken, $idrec);
                }
                
                echo json_encode($array);
            }
        }
        
        function saveProductoOrdenProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idyear = $this->input->post('idyear');
                $idmonth = $this->input->post('idmonth');
                $cantidad = $this->input->post('cantidad');
                $procentro = $this->input->post('procentro');
                $idproducto = $this->input->post('idproducto');
                $dayCalendar = $this->input->post('dayCalendar');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $this->produccion_model->updateRegistroCalendario($idrec, $cantidad, $dayCalendar);
                $informacion = $this->produccion_model->getListadoProductosAgrupados($procentro, $idcentro, $dayCalendar, $idyear, $idmonth);
				
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "item" => $i + 1,
                            "idregistro" => $info->idregistro,
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "linea" => $info->linea,
                            "procentro" => $info->procentro,
                            "cantidad" => $info->cantidad,
                            "presenta" => $info->presenta,
                            "imagen" => $info->imagen
                        );
                        
                        $i++;
                    }
                }
                
                $array = array(
                    'info' => $dataSource,
                    'total' => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function getDatosReporteCalendarioProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $mes = $this->input->post('mes');
                $year = $this->input->post('year');
                $numini = $this->input->post('numini');
                $numfin = $this->input->post('numfin');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getDatosReporteCalendarioProduccion($idcentro, $mes, $year);
				
                $dataSourceColumnas = array();
                
                $dataSourceColumnas[0] = array(
                    "allowGrouping" => false,
                    "allowEditing" => false,
                    "allowFiltering" => false,
                    "dataField" => "idproducto",
                    "caption" => "Cod",
                    "alignment" => "center",
                    "dataType" => "number",
                    "fixed" => true,
                    "width" => 80
                );
                
                $dataSourceColumnas[1] = array(
                    "allowGrouping" => false,
                    "allowEditing" => false,
                    "dataField" => "descrip",
                    "allowHeaderFiltering" => false,
                    "caption" => "Descripción",
                    "fixed" => true
                );
                
                $dataSourceColumnas[2] = array(
                    "allowGrouping" => true,
                    "allowEditing" => false,
                    "dataField" => "linea",
                    "caption" => "Linea",
                    "groupIndex" => 1
                );
                
                $dataSourceColumnas[3] = array(
                    "allowGrouping" => true,
                    "allowEditing" => false,
                    "dataField" => "namecentro",
                    "caption" => "Centro de Producción",
                    "groupIndex" => 0,
                    "groupCellTemplace" => "function(cellElement, cellInfo){
                        cellElement.attr('style', 'padding:2px;');
                        cellElement.append(cellInfo.text);
                    }"
                );
                
                $n=4;
                for($i=$numini; $i<=$numfin; $i++){
                    if(strlen($i) == 1){
                        $txtnum = "0".$i;
                    }else{
                        $txtnum = $i;
                    }
                    
                    $dataSourceColumnas[$n] = array(
                        "allowGrouping" => false,
                        "allowEditing" => false,
                        "allowFiltering" => false,
                        "dataField" => "dia".$txtnum,
                        "caption" => $txtnum."/".$mes,
                        "alignment" => "center",
                        "dataType" => "number",
                        "width" => 50
                    );
                    $n++;
                }
                
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "namecentro" => $info->namecentro,
                            "linea" => $info->linea,
                            "dia01" => $info->dia01 == 0 ? "" : $info->dia01,
                            "dia02" => $info->dia02 == 0 ? "" : $info->dia02,
                            "dia03" => $info->dia03 == 0 ? "" : $info->dia03,
                            "dia04" => $info->dia04 == 0 ? "" : $info->dia04,
                            "dia05" => $info->dia05 == 0 ? "" : $info->dia05,
                            "dia06" => $info->dia06 == 0 ? "" : $info->dia06,
                            "dia07" => $info->dia07 == 0 ? "" : $info->dia07,
                            "dia08" => $info->dia08 == 0 ? "" : $info->dia08,
                            "dia09" => $info->dia09 == 0 ? "" : $info->dia09,
                            "dia10" => $info->dia10 == 0 ? "" : $info->dia10,
                            "dia11" => $info->dia11 == 0 ? "" : $info->dia11,
                            "dia12" => $info->dia12 == 0 ? "" : $info->dia12,
                            "dia13" => $info->dia13 == 0 ? "" : $info->dia13,
                            "dia14" => $info->dia14 == 0 ? "" : $info->dia14,
                            "dia15" => $info->dia15 == 0 ? "" : $info->dia15,
                            "dia16" => $info->dia16 == 0 ? "" : $info->dia16,
                            "dia17" => $info->dia17 == 0 ? "" : $info->dia17,
                            "dia18" => $info->dia18 == 0 ? "" : $info->dia18,
                            "dia19" => $info->dia19 == 0 ? "" : $info->dia19,
                            "dia20" => $info->dia20 == 0 ? "" : $info->dia20,
                            "dia21" => $info->dia21 == 0 ? "" : $info->dia21,
                            "dia22" => $info->dia22 == 0 ? "" : $info->dia22,
                            "dia23" => $info->dia23 == 0 ? "" : $info->dia23,
                            "dia24" => $info->dia24 == 0 ? "" : $info->dia24,
                            "dia25" => $info->dia25 == 0 ? "" : $info->dia25,
                            "dia26" => $info->dia26 == 0 ? "" : $info->dia26,
                            "dia27" => $info->dia27 == 0 ? "" : $info->dia27,
                            "dia28" => $info->dia28 == 0 ? "" : $info->dia28,
                            "dia29" => $info->dia29 == 0 ? "" : $info->dia29,
                            "dia30" => $info->dia30 == 0 ? "" : $info->dia30,
                            "dia31" => $info->dia31 == 0 ? "" : $info->dia31,
                        );
                        
                        $i++;
                    }
                }
                
                $array = array(
                    'informacion' => $dataSource,
                    'columnas' => $dataSourceColumnas
                );
                
                echo json_encode($array);
            }
        }
        
        function calendarioProduccion($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $infoApps = $this->configuracion_model->getOptionsByidapp($idApp);
                $appOptions = explode(",", $infoApps);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'idproveedor_cp' => $appOptions[0],
                    'idclase_cp' => $appOptions[1]
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('global_model');
                $direccion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['centros_colors'] = $this->global_model->getDetalleCentrosColors();
                
                $this->load->view('pedidos/mantenimiento_datos_produccion', $this->data);                 
            }
        }
        
        function getDatosProduccionCalendar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getDatosProduccionCalendar($idcentro);
				
                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        
                        $date = new DateTime($info->fentrega);
                        
                        $cantidadFecha = $this->produccion_model->getCantidadDeProductosCentro($idcentro, $info->procentro, $date->format('d'), $date->format('m'), $date->format('Y'));
                        
                        $array[$i] = array(
                            "idrec" => $info->idrec,
                            "idyear" => $info->idyear,
                            "idmonth" => $info->idmonth,
                            "trannum" => $info->trannum,
                            "namecentro" => strtoupper($info->nameProduccion),
                            "startDate" => $info->fentrega . ' 00:00:00',
                            "endDate" => $info->fentrega . ' 23:59:59',
                            "fentrega" => $date->format('d/m/Y'),
                            "fentrega2" => $info->fentrega,
                            "dateIni" => $info->fpedidoini,
                            "dateFin" => $info->fpedidofin,
                            "tokenid" => $info->tokenid,
                            "tokenini" => $info->tokenini,
                            "tokenfin" => $info->tokenfin,
                            "bcolor" => $info->bcolor,
                            "fcolor" => $info->fcolor,
                            "procentro" => $info->procentro,
                            "estado" => $info->estado,
                            "notas" => $info->notas
                        );
                        
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getDiasCentroProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $array = $this->produccion_model->getDiasCentroProduccion($idcentro);
                
                echo json_encode($array);
            }            
        }
        
        function insertarDatosCalendario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $dias = $this->input->post('inputDias');
                $inputHora = $this->input->post('inputHora');
                $inputFechaIni = $this->input->post('inputFechaIni');
                $inputFechaFin = $this->input->post('inputFechaFin');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $array = $this->produccion_model->insertarDatosCalendario($inputHora,$inputFechaIni,$inputFechaFin,$idcentro, $dias);
                
                echo json_encode($array);
            }
        }
        
        function getDatosReporteCalendarioProduccionConsolidado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $mes = $this->input->post('mes');
                $year = $this->input->post('year');
                $numini = $this->input->post('numini');
                $numfin = $this->input->post('numfin');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getDatosReporteCalendarioProduccionConsolidado($idcentro, $mes, $year);
				
                $dataSourceColumnas = array();
                
                $dataSourceColumnas[0] = array(
                    "allowGrouping" => false,
                    "allowEditing" => false,
                    "allowFiltering" => false,
                    "dataField" => "idproducto",
                    "caption" => "Cod",
                    "alignment" => "center",
                    "dataType" => "number",
                    "fixed" => true,
                    "width" => 80
                );
                
                $dataSourceColumnas[1] = array(
                    "allowGrouping" => false,
                    "allowEditing" => false,
                    "dataField" => "descrip",
                    "allowHeaderFiltering" => false,
                    "fixed" => true,
                    "caption" => "Descripción"
                );
                
                $dataSourceColumnas[2] = array(
                    "allowGrouping" => true,
                    "allowEditing" => false,
                    "dataField" => "linea",
                    "caption" => "Linea",
                    "groupIndex" => 1
                );
                
                $dataSourceColumnas[3] = array(
                    "allowGrouping" => true,
                    "allowEditing" => false,
                    "dataField" => "namecentro",
                    "caption" => "Centro de Producción",
                    "groupIndex" => 0,
                    "groupCellTemplace" => "function(cellElement, cellInfo){
                        cellElement.attr('style', 'padding:2px;');
                        cellElement.append(cellInfo.text);
                    }"
                );
                
                $n=4;
                for($i=$numini; $i<=$numfin; $i++){
                    if(strlen($i) == 1){
                        $txtnum = "0".$i;
                    }else{
                        $txtnum = $i;
                    }
                    
                    $dataSourceColumnas[$n] = array(
                        "allowGrouping" => false,
                        "allowEditing" => false,
                        "allowFiltering" => false,
                        "dataField" => "dia".$txtnum,
                        "caption" => $txtnum."/".$mes,
                        "alignment" => "center",
                        "dataType" => "number",
                        "width" => 50
                    );
                    $n++;
                }
                
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "namecentro" => $info->namecentro,
                            "linea" => $info->linea,
                            "dia01" => $info->dia01 == 0 ? "" : $info->dia01,
                            "dia02" => $info->dia02 == 0 ? "" : $info->dia02,
                            "dia03" => $info->dia03 == 0 ? "" : $info->dia03,
                            "dia04" => $info->dia04 == 0 ? "" : $info->dia04,
                            "dia05" => $info->dia05 == 0 ? "" : $info->dia05,
                            "dia06" => $info->dia06 == 0 ? "" : $info->dia06,
                            "dia07" => $info->dia07 == 0 ? "" : $info->dia07,
                            "dia08" => $info->dia08 == 0 ? "" : $info->dia08,
                            "dia09" => $info->dia09 == 0 ? "" : $info->dia09,
                            "dia10" => $info->dia10 == 0 ? "" : $info->dia10,
                            "dia11" => $info->dia11 == 0 ? "" : $info->dia11,
                            "dia12" => $info->dia12 == 0 ? "" : $info->dia12,
                            "dia13" => $info->dia13 == 0 ? "" : $info->dia13,
                            "dia14" => $info->dia14 == 0 ? "" : $info->dia14,
                            "dia15" => $info->dia15 == 0 ? "" : $info->dia15,
                            "dia16" => $info->dia16 == 0 ? "" : $info->dia16,
                            "dia17" => $info->dia17 == 0 ? "" : $info->dia17,
                            "dia18" => $info->dia18 == 0 ? "" : $info->dia18,
                            "dia19" => $info->dia19 == 0 ? "" : $info->dia19,
                            "dia20" => $info->dia20 == 0 ? "" : $info->dia20,
                            "dia21" => $info->dia21 == 0 ? "" : $info->dia21,
                            "dia22" => $info->dia22 == 0 ? "" : $info->dia22,
                            "dia23" => $info->dia23 == 0 ? "" : $info->dia23,
                            "dia24" => $info->dia24 == 0 ? "" : $info->dia24,
                            "dia25" => $info->dia25 == 0 ? "" : $info->dia25,
                            "dia26" => $info->dia26 == 0 ? "" : $info->dia26,
                            "dia27" => $info->dia27 == 0 ? "" : $info->dia27,
                            "dia28" => $info->dia28 == 0 ? "" : $info->dia28,
                            "dia29" => $info->dia29 == 0 ? "" : $info->dia29,
                            "dia30" => $info->dia30 == 0 ? "" : $info->dia30,
                            "dia31" => $info->dia31 == 0 ? "" : $info->dia31,
                        );
                        
                        $i++;
                    }
                }
                
                $array = array(
                    'informacion' => $dataSource,
                    'columnas' => $dataSourceColumnas
                );
                
                echo json_encode($array);
            }
        }
        
        function updateDatosCalendario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $estado = $this->input->post('estado');
                $trannum = $this->input->post('trannum');
                $inputFechaIni = $this->input->post('inputFechaIni');
                $inputFechaFin = $this->input->post('inputFechaFin');
                $inputFechaEntrega = $this->input->post('inputFechaEntrega');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $array = $this->produccion_model->updateDatosCalendario($idrec, $inputFechaIni, $inputFechaFin, $inputFechaEntrega, $idcentro, $estado, $trannum);
                
                echo json_encode($array);
            }
        }
        
        function generarTokenControl(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->generarTokenControl($idrec);
                
                $array = array(
                    "infoToken" => $informacion['tokenid'],
                    "fechaini" => $informacion['tokenini'],
                    "fechafin" => $informacion['tokenfin']
                );
                
                echo json_encode($array);
            }
        }

        function detalleCambiosPendientesProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->detalleCambiosPendientesProduccion($trannum);
				
                $i=0;
                $dataSource=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "id_cambio" => $info->id_cambio,
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "canto" => $info->canto,
                            "cantidad" => $info->cantidad,
                            "sucursal" => $info->sucursal,
                        );
                        
                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }

        function detalleCambiosProcesadosProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->detalleCambiosProcesadosProduccion($trannum);
				
                $i=0;
                $dataSource=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "id_cambio" => $info->id_cambio,
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "canto" => $info->canto,
                            "cantidad" => $info->cantidad,
                            "sucursal" => $info->sucursal,
                        );
                        
                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }

        function autorizarCambiosProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcambios = $this->input->post('idcambios');

                $this->load->model('produccion_model');
                $this->produccion_model->autorizarCambiosProduccion($trannum, $idcambios);
				$informacion = $this->produccion_model->detalleCambiosPendientesProduccion($trannum);
				
                $i=0;
                $dataSource=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "id_cambio" => $info->id_cambio,
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "canto" => $info->canto,
                            "cantidad" => $info->cantidad,
                            "sucursal" => $info->sucursal,
                        );
                        
                        $i++;
                    }
                }

                echo json_encode($dataSource);
            }
        }
        
        function actualizarCantidadesOrdenadas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('produccion_model');
                $this->produccion_model->actualizarCantidadesOrdenadas($trannum);
                $infoProductos = $this->produccion_model->getDatosProductosOrdenProduccion($trannum);
                
                $i=0;
                $array = array();
                foreach($infoProductos as $info){
                    $datosMaster = $this->produccion_model->getListMovimientoProductoProduccion($info->idproducto, $trannum);
                    
                    if($info->cantidad != 0){
                        $porcentaje = ($info->producidos / $info->cantidad) * 100;
                    }else{
                        $porcentaje = 0;
                    }

                    $array[$i] = array(
                        "xpos" => $info->xpos,
                        "costouni" => $info->costouni,
                        "precioventa" => $info->precioventa,
                        "tipotax" => $info->tipotax,
                        "idrec" => $info->idrec,
                        "uniconv" => $info->uniconv,
                        "umkt" => $info->umkt,
                        "itemline" => $info->itemline,
                        "idcatalogo" => $info->idcatalogo,
                        "descrip" => $info->descrip,
                        "imagen" => $info->imagen,
                        "modelo" => $info->modelo,
                        "um" => $info->um,
                        "marca" => $info->marca,
                        "idproducto" => $info->idproducto,
                        "barcode" => $info->barcode,
                        "notas" => $info->notas,
                        "cantidad" => $info->cantidad,
                        "preciotran" => $info->preciotran,
                        "subtotal" => $info->subtotal,
                        "descuento" => $info->descuento,
                        "precioneto" => $info->precioneto,
                        "modNotas" => $info->modNotas,
                        "linea" => $info->linea,
                        "producidos" => $info->producidos,
                        "estatus" => $info->estatus,
                        "nivel" => 0,
                        "porcentaje" => number_format($porcentaje, 2, '.', ',') . "%",
                        "detalleProducto" => $datosMaster
                    );
                    
                    $i++;
                }
                                
                echo json_encode($array);
            }
        }

        function monitorDePedidos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $direccion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				
                $this->load->view('mantenimiento_monitor_pedidos');
            }
        }

        function monitorDeEnvios($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionesApp = $this->configuracion_model->getOptionsByidapp($idApp);
                $infoApp = explode(",", $opcionesApp);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $direccion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['idclase'] = $infoApp[0];
				$this->data['tipoProducto'] = $infoApp[1];
				
                $this->load->view('mantenimiento_monitor_envios', $this->data);
            }
        }

        function getInformacionMovimientosPedidos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $idcentro = $this->input->post('idcentro');
                $fecha = $this->input->post('fecha');
                $date = new DateTime($fecha);
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getDetalleProductosMonitorPedidos($idcentro, $date->format('d'), $date->format('m'), $date->format('Y'));

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion AS $info){
                        if($info->cantidades != 0){
                            $array[$i] = array(
                                "producto" => "[".$info->idproducto."] " .$info->producto,
                                "modelo" => $info->modelo,
                                "departamento" => $info->departamento,
                                "linea" => $info->linea,
                                "cantidades" => $info->cantidades,
                                "sucnombre" => $info->sucnombre
                            );
                            $i++;
                        }
                    }
                }

                echo json_encode($array);
            }
        }

        function getInformacionMovimientosEnvios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $idclase = $this->input->post('idclase');
                $idcentro = $this->input->post('idcentro');
                $tipoProducto = $this->input->post('tipoProducto');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getInformacionMovimientosEnvios($idcentro, $idclase, $tipoProducto, 0);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion AS $info){
                        if($info->cantidades != 0){
                            $array[$i] = array(
                                "producto" => $info->producto,
                                "modelo" => $info->modelo,
                                "departamento" => $info->departamento,
                                "linea" => $info->linea,
                                "cantidades" => $info->cantidades,
                                "sucnombre" => $info->sucnombre
                            );
                            $i++;
                        }
                    }
                }

                echo json_encode($array);
            }
        }

        function ordenesAjustesPedidos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionesApp = $this->configuracion_model->getOptionsByidapp($idApp);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->view('mantenimiento_ordenes_ajustes_pedidos');
            }
        }

        function getFechasCentrosProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('produccion_model');
                $array = $this->produccion_model->getFechasCentrosProduccion();
                
                echo json_encode($array);
            }
        }

        function getInformacionOrdenadoProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $fecha = $this->input->post('fecha');

                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getInformacionOrdenadoProduccion($idcentro, $fecha);

                $i=0;
                $array = array();

                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(

                        );

                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function mantenimientoCP($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $direccion = $this->uri->segment(1);

                $this->load->model('global_model');
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                

                $this->load->model('produccion_model');
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->load->view('mantenimiento_cp', $this->data);
            }
        }

        function mantenimientoComponentes($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $direccion = $this->uri->segment(1);

                $this->load->model('global_model');
                $this->load->model('produccion_model');
                $this->load->model('configuracion_model');

                $appName     = $this->configuracion_model->getAppName($idApp);
                $opcionesApp = $this->configuracion_model->getOptionsByidapp($idApp);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);

                $this->data['formatos']     = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['opcionNoEdit'] = ( $opcionesApp == '' ) ? 0 : 1;
                $this->load->view('mantenimiento_cp_combos', $this->data);
            }
        }

        function getListadoProductosVariables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getListadoProductosVariables('CP');

                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $infoDropdown = $this->produccion_model->getOpcionesProdMulti("30");
                        $infoComponentes = $this->produccion_model->getListadoComponentes("30", $info->idproducto);
                        
                        $dataSource[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "um" => $info->um,
                            "nameLinea" => $info->nameLinea,
                            "modelo" => $info->modelo,
                            "marca" => $info->marca,
                            "tipo" => $info->tipo,
                            "detalleComponentes" => $infoComponentes,
                            "infoDropdown" => $infoDropdown
                        );
                        $i++;
                    }
                }

                echo json_encode($dataSource);
            }
        }

        function getListadoProductosCP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idgvar = $this->input->post('idgvar');
                $codigoProducto = $this->input->post('codigoProducto');
                $tipoProducto = $this->input->post('tipoProductos');

                $this->load->model('produccion_model');
                $array = $this->produccion_model->getListadoProductosCP($idgvar, $tipoProducto, $codigoProducto);
                
                echo json_encode($array);
            }
        }

        function getListadoProductosComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $codigoProducto = $this->input->post('codigoProducto');
                $tipoProducto = $this->input->post('tipoProductos');

                $this->load->model('produccion_model');
                $array = $this->produccion_model->getListadoProductosComponentes($tipoProducto, $codigoProducto);
                
                echo json_encode($array);
            }
        }

        function getListadoProductosCombos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $codigoProducto = $this->input->post('codigoProducto');
                $tipoProducto = $this->input->post('tipoProductos');

                $this->load->model('produccion_model');
                $array = $this->produccion_model->getListadoProductosCombos($tipoProducto, $codigoProducto);
                
                echo json_encode($array);
            }
        }

        function insertarInformacionCP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idrnum = $this->input->post('idrnum');
                $idproducto = $this->input->post('idproducto');
                $informacion = $this->input->post('informacion');
                
                $this->load->model('produccion_model');
                $this->produccion_model->insertarInformacionCP($idrnum, $idproducto, $informacion);
                $informacion = $this->produccion_model->getListadoProductosVariables('CP');

                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $infoDropdown = $this->produccion_model->getOpcionesProdMulti("30");
                        $infoComponentes = $this->produccion_model->getListadoComponentes("30", $info->idproducto);
                        
                        $dataSource[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "um" => $info->um,
                            "nameLinea" => $info->nameLinea,
                            "modelo" => $info->modelo,
                            "marca" => $info->marca,
                            "tipo" => $info->tipo,
                            "detalleComponentes" => $infoComponentes,
                            "infoDropdown" => $infoDropdown
                        );
                        $i++;
                    }
                }

                echo json_encode($dataSource);
            }
        }

        function insertarInformacionComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idrnum     = $this->input->post('idrnum');
                $idproducto = $this->input->post('idproducto');
                $idinsert   = $this->input->post('idinsert');
                $cantidad   = $this->input->post('cantidad');
                $tipoComp   = $this->input->post('tipoComponente');
                
                $this->load->model('produccion_model');
                $this->produccion_model->insertarInformacionComponentes($idrnum, $idproducto, $idinsert, $cantidad, $tipoComp);

                if($tipoComp == 1){
                    $array = $this->produccion_model->getListadoComponentes("30", $idproducto);
                }else if($tipoComp == 2){
                    $array = $this->produccion_model->getListadoCombos("30", $idproducto);
                }

                echo json_encode($array);
            }
        }

        function updateListadoProductosComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $idproducto = $this->input->post('codigoProducto');
                
                $this->load->model('produccion_model');
                $this->produccion_model->updateListadoProductosComponentes($idrec, $cantidad);
                $array = $this->produccion_model->getListadoComponentes("30", $idproducto);

                echo json_encode($array);
            }
        }

        function eliminarInformacionCP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                
                $this->load->model('produccion_model');
                $this->produccion_model->eliminarInformacionCP($idrec);
                $informacion = $this->produccion_model->getListadoProductosVariables('CP');

                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $infoDropdown = $this->produccion_model->getOpcionesProdMulti("30");
                        $infoComponentes = $this->produccion_model->getListadoComponentes("30", $info->idproducto);
                        
                        $dataSource[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "um" => $info->um,
                            "nameLinea" => $info->nameLinea,
                            "modelo" => $info->modelo,
                            "marca" => $info->marca,
                            "tipo" => $info->tipo,
                            "detalleComponentes" => $infoComponentes,
                            "infoDropdown" => $infoDropdown
                        );
                        $i++;
                    }
                }

                echo json_encode($dataSource);
            }
        }

        function eliminarInformacionComponente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('produccion_model');

                $this->produccion_model->eliminarInformacionCP($idrec);
                $array = $this->produccion_model->getListadoComponentes("30", $idproducto);

                echo json_encode($array);
            }
        }
        
        function eliminarInformacionCombo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcombo = $this->input->post('idcombo');
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('produccion_model');

                $this->produccion_model->eliminarInformacionCombo($idcombo, $idproducto);
                $array = $this->produccion_model->getListadoCombos("30", $idproducto);

                echo json_encode($array);
            }
        }

        function validateDatosProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $tipoIngreso = $this->input->post('tipoIngreso');
                $string_insert = $this->input->post('productos');
                
                $datoRemplazo = array("_", "_", "_", "_");
                $datoBusqueda = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $string_insert = str_replace($datoBusqueda, $datoRemplazo, $string_insert);
                
                $cant_errores=0; $cadena_lineas="";
                $this->load->model('produccion_model');
                
                if($tipoIngreso == 1){
                    //Codigo con Costo
                    $cadena_errores = 0;
                    $array_string = explode("_", $string_insert);

                    for($i=0; $i<count($array_string); $i++){
                        $array_producto = explode(",", $array_string[$i]);
                        if(count($array_producto) == 2){
                            $insert = $this->produccion_model->verifyInsertProduct($array_producto[0]);
                            
                            switch($insert){
                                case 0:
                                    break;
                                case 1:
                                    $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                    $cant_errores++;
                                    break;
                                default:
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                            $cant_errores++;
                        }
                    }
                }else if($tipoIngreso == 2){
                    //Barcode con Costo
                    $cadena_errores = 0;
                    $array_string = explode("_", $string_insert);

                    for($i=0; $i<count($array_string); $i++){
                        $array_producto = explode(",", $array_string[$i]);
                        if(count($array_producto) == 2){
                            $insert = $this->produccion_model->verifyInsertProductCodBarra($array_producto[0]);
                            
                            switch($insert){
                                case 0:
                                    break;
                                case 1:
                                    $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                    $cant_errores++;
                                    break;
                                default:
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                            $cant_errores++;
                        }
                    }
                }else if($tipoIngreso == 3){
                    //Modelo con Costo
                    $cadena_errores = 0;
                    $array_string = explode("_", $string_insert);

                    for($i=0; $i<count($array_string); $i++){
                        $array_producto = explode(",", $array_string[$i]);
                        if(count($array_producto) == 2){
                            $insert = $this->produccion_model->verifyInsertProductModelo($array_producto[0]);
                            
                            switch($insert){
                                case 0:
                                    break;
                                case 1:
                                    $cant_errores++;
                                    $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                    break;
                                default:
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                            $cant_errores++;
                        }
                    }
                }else if($tipoIngreso == 4){
                    //Codigo Xpos con Costo
                    $cadena_errores = 0;
                    $array_string = explode("_", $string_insert);
                    
                    for($i=0; $i<count($array_string); $i++){
                        $array_producto = explode(",", $array_string[$i]);
                        if(count($array_producto) == 2){
                            $insert = $this->produccion_model->verifyInsertProductXPOS($array_producto[0]);
                            
                            switch($insert){
                                case 0:
                                    break;
                                case 1:
                                    $cant_errores++;
                                    $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                    break;
                                default:
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                            $cant_errores++;
                        }
                    }
                }else{
                    $cant_errores++;
                    $cadena_lineas = "TIPOS DE INGRESO EN MANTENIMIENTO";
                }
                
                $array_send = array(
                    "errores" => $cant_errores,
                    "mensaje" => $cadena_lineas
                );
                
                echo json_encode($array_send);
            }
        }

        function importarProductosToComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $idrnum = $this->input->post('idrnum');
                $idproducto = $this->input->post('idproducto');
                $tipoIngreso = $this->input->post('tipoIngreso');
                $string_insert = $this->input->post('productos');

                $datoBusqueda = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $datoRemplazo = array("_", "_", "_", "_");
                $string_insert = str_replace($datoBusqueda, $datoRemplazo, $string_insert);
                
                $this->load->model('produccion_model');
                
                if($tipoIngreso == 1){
                    $array_string = explode("_", $string_insert);

                    for($i=0; $i<count($array_string); $i++){
                        $array_producto = explode(",", $array_string[$i]);
                        if(count($array_producto) == 2){
                            $insert = $this->produccion_model->insertLineComponente($array_producto[0], $array_producto[1], $idproducto, $idrnum);
                        }
                    }
                }else if($tipoIngreso == 2){
                    $array_string = explode("_", $string_insert);

                    for($i=0; $i<count($array_string); $i++){
                        $array_producto = explode(",", $array_string[$i]);
                        if(count($array_producto) == 2){
                            $insert = $this->produccion_model->insertLineComponenteCodBarra($array_producto[0], $array_producto[1], $idproducto, $idrnum);
                        }
                    }
                }else if($tipoIngreso == 3){
                    $array_string = explode("_", $string_insert);

                    for($i=0; $i<count($array_string); $i++){
                        $array_producto = explode(",", $array_string[$i]);
                        if(count($array_producto) == 2){
                            $insert = $this->produccion_model->insertLineComponenteModelo($array_producto[0], $array_producto[1], $idproducto, $idrnum);
                        }
                    }
                }else if($tipoIngreso == 4){
                    $array_string = explode("_", $string_insert);

                    for($i=0; $i<count($array_string); $i++){
                        $array_producto = explode(",", $array_string[$i]);
                        if(count($array_producto) == 2){
                            $insert = $this->produccion_model->insertLineComponenteXPOS($array_producto[0], $array_producto[1], $idproducto, $idrnum);
                        }
                    }
                }
                
                $array = $this->produccion_model->getListadoComponentes("30", $idproducto);

                echo json_encode($array);
            }
        }

        function getTextoExportacionProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $tipoIngreso = $this->input->post('tipoIngreso');
                
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getTextoExportacionProductos($idproducto, $tipoIngreso);

                $datoBusqueda = array("_", "_", "_", "_");
                $datoRemplazo = array(chr(13).chr(10), "\r\n", "\n", "\r");
                
                $informacion = str_replace($datoBusqueda, $datoRemplazo, $informacion);

                echo json_encode($informacion);
            }
        }

        function getListadoLineasComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getListadoLineasComponentes('CP');

                
                $i=1;
                $array = array();
                $array[0]= array(
                    "id" => 'TODO',
                    "descrip" => 'TODOS',
                );
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => $info->idcatalogo,
                            "descrip" => strtoupper($info->descrip),
                        );
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function getListadoProductosLineaCP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');

                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getListadoProductosLineaCP($idcatalogo);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => $info->idproducto,
                            "descrip" => strtoupper($info->descrip),
                            "linea" => strtoupper($info->linea),
                            "imagen" => $info->imagen,
                            "modelo" => $info->modelo,
                            "um" => $info->um,
                            "precioventa" => $info->precioventa,
                            "numcomponentes" => $this->produccion_model->getListadoComponentesCount($info->idproducto),
                            "estado" => $info->estado,

                        );
                        $i++;
                    }
                }

               
                echo json_encode($array);
            }
        }

        function getListadoProductosLineaCPSearch(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $descrip = $this->input->post('descrip');
                $idcatalogo = $this->input->post('idcatalogo');

                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getListadoProductosLineaCPSearch($idcatalogo, $descrip);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => $info->idproducto,
                            "descrip" => strtoupper($info->descrip),
                            "imagen" => $info->imagen,
                            "modelo" => $info->modelo,
                            "um" => $info->um,
                            "precioventa" => $info->precioventa,
                        );
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function getListadoComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idproducto = $this->input->post('idproducto');

                $this->load->model('produccion_model');
                $array = $this->produccion_model->getListadoComponentes("30", $idproducto);

                echo json_encode($array);
            }
        }

        function getListadoCombos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idproducto = $this->input->post('idproducto');

                $this->load->model('produccion_model');
                $array = $this->produccion_model->getListadoCombos("30", $idproducto);

                echo json_encode($array);
            }
        }

        //Modulo Tecleña...
        function empaquetadoDeProductos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $datosClases = $this->configuracion_model->getProCentro($idApp);
                $idclases = explode(",", $datosClases);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'idclase_empaque' => $idclases[0],
                    'idclase_cierre' => $idclases[1]
                );
                $this->session->set_userdata($resultAppName);
                
                $direccion = $this->uri->segment(1);
                $this->load->model('global_model'); $this->load->model('invtran_model');
                $this->load->model('compras_model');
                $this->data['formatos']      = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['transacciones'] = $this->invtran_model->getTiposinout($idclases[0]);
                $this->data['empleados']     = $this->compras_model->getListProveedores(3);

                $this->load->view('mantenimiento_empaque_productos', $this->data);
            }
        }

        function detalleEmpaquetadoProductos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $direccion = $this->uri->segment(1);

                $this->load->model('invtran_model');
                $this->load->model('global_model'); $this->load->model('compras_model');
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getInformacionConversion($trannum);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                
                $this->session->set_userdata($array);

                $this->load->view('mantenimiento_detalle_empaquetado_productos', $this->data);
            }
        }

        function insertarOrdenEmpaque(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $fecha = $this->input->post('fecha');
                $notas = $this->input->post('notas');
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $reemplazar = array("", "", "", "");
                $notas = str_replace($buscar, $reemplazar, $notas);

                $idcps = $this->input->post('idcps');
                $idclase = $this->input->post('idclase');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('produccion_model');
                $array = $this->produccion_model->insertarOrdenEmpaque($idcentro, $fecha, $idcps, $idclase, $notas);

                echo json_encode($array);
            }
        }

        function getEmpaquesDeProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idclase = $this->session->userdata('idclase_empaque');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('produccion_model');
                $array = $this->produccion_model->getEmpaquesDeProducto($idcentro, $idclase);

                echo json_encode($array);
            }
        }

        function getListadoLineasEmpaques(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('produccion_model');
                $lineas = $this->produccion_model->getGroupsProductosEmpaques($trannum);
                
                $i=0;
                $array = array();
                foreach($lineas as $data){
                    $array[$i] = array(
                        "idcatalogo" => $data->idcatalogo,
                        "imagen" => trim($data->imagen),
                        "descrip" => trim($data->descrip)
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }

        function getInventarioEmpaque(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('produccion_model');
                $detalle = $this->produccion_model->getInventarioEmpaque($trannum, $idcentro);
                
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    if($info->existe == 0){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "existe" => $info->existe
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                echo json_encode($array);
            }
        }

        function getDatosEmpaqueProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getDatosEmpaqueProductos($trannum);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "itemline" => $info->itemline,
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "descripcion" => $info->descrip,
                            "cantidad" => abs($info->cantidad)
                        );
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function insertarProductoEmpaque(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $tipotax = $this->input->post('tipotax');
                $idproducto = $this->input->post('idproducto');
                $cantidad = $this->input->post('cantidad');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $idcentro = $this->session->userdata('idcentrouser');
                $idclase = $this->session->userdata('idclase_empaque');

                $this->load->model('produccion_model');
                $this->produccion_model->insertarProductoEmpaque($trannum,$um,$precio,$uniconv,$tipotax,$cantidad,$idproducto,$idcentro,$idclase);
                $informacion = $this->produccion_model->getDatosEmpaqueProductos($trannum);
                $infoLineas = $this->produccion_model->getInventarioEmpaque($trannum, $idcentro);
                
                $j=0;
                $datos = array();
                foreach($infoLineas as $info){
                    if($info->existe == 0){
                        $datos[$j] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "existe" => $info->existe
                        );
                        $j++;
                    }
                }

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "itemline" => $info->itemline,
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "descripcion" => $info->descrip,
                            "cantidad" => abs($info->cantidad)
                        );
                        $i++;
                    }
                }

                $dataSource = array(
                	"infoLineas" => $datos,
                	"infoGrid" => $array,
                    "cantidad" => $j
                );
                echo json_encode($dataSource);
            }
        }

        function eliminarProductoEmpaque(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
            	$idrec = $this->input->post('idrec');
            	$trannum = $this->input->post('trannum');
            	$idcentro = $this->session->userdata('idcentrouser');

            	$this->load->model('produccion_model');
                $this->produccion_model->eliminarProductoEmpaque($idrec);
                $informacion = $this->produccion_model->getDatosEmpaqueProductos($trannum);
                $infoLineas = $this->produccion_model->getInventarioEmpaque($trannum, $idcentro);
                
                $j=0;
                $datos = array();
                foreach($infoLineas as $info){
                    if($info->existe == 0){
                        $datos[$j] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "existe" => $info->existe
                        );
                        $j++;
                    }
                }

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "itemline" => $info->itemline,
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "descripcion" => $info->descrip,
                            "cantidad" => abs($info->cantidad)
                        );
                        $i++;
                    }
                }

                $dataSource = array(
                	"infoLineas" => $datos,
                	"infoGrid" => $array,
                    "cantidad" => $j
                );
                echo json_encode($dataSource);
            }
        }

        function getDetalleComponentesEmpaque(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $estado = $this->input->post('estado');
                $trannum = $this->input->post('trannum');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getDetalleComponentesEmpaque($trannum, $idcentro, $estado);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "tipoproducto" => $info->tipoproducto,
                            "um" => $info->um,
                            "cantidad" => number_format($info->cantidad, 2, '.', '') * 1,
                            "saldo" => number_format($info->saldo, 2, '.', '') * 1
                        );

                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function getTotalesEmpaques(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('produccion_model');
                $informacion1 = $this->produccion_model->getDatosEmpaqueProductos($trannum);
                $informacion2 = $this->produccion_model->getDetalleComponentesEmpaque($trannum, $idcentro, 0);

                $total1 = 0; $total2 = 0;
                if($informacion1 != false){
                    foreach($informacion1 as $info1){
                        $total1 = $total1 + abs($info1->cantidad);
                    }
                }

                $error=0;
                if($informacion2 != false){
                    foreach($informacion2 as $info2){
                        if(abs($info2->cantidad) > abs($info2->saldo)){
                            $error=1;
                        }

                        $total2 = $total2 + abs($info2->cantidad);
                    }
                }

                $dataSource = array(
                    "error" => $error,
                	"total1" => $total1,
                	"total2" => $total2
                );
                echo json_encode($dataSource);
            }
        }

        function cerrarEmpacadoProductos(){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $notas = $this->input->post('notas');
                $trannum = $this->input->post('trannum');
                $idworker = $this->input->post('idworker');
                $idclase = $this->session->userdata('idclase_cierre');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('produccion_model');
                
                $this->produccion_model->updateEntradaEmpaque($trannum, $idcentro, $notas);
                $trannumcierre = $this->produccion_model->insertarRegistroCierreEmpaque($idclase, $idworker, $idcentro);
                $array = $this->produccion_model->generarDetalleSalidaEmpaque($trannumcierre, $trannum, $idclase, $idcentro);

                echo json_encode($array);
            }
        }

        function anulacionEmpacado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('produccion_model');
                $array = $this->produccion_model->anulacionEmpacado($trannum);
                
                echo json_encode($array);
            }
        }

        function analisisDeProduccion($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $idclase = $this->configuracion_model->getProCentro($idApp);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                
                $direccion = $this->uri->segment(1);
                $this->load->model('global_model'); 
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['idclase'] = $idclase;

                $this->load->view('mantenimiento_analisis_de_produccion', $this->data);
            }
        }

        function getAnalisisProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $fechaIni = $this->input->post('fecha_ini');
                $fechafin = $this->input->post('fecha_fin');
                $idclase = $this->input->post('idclase');

                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getAnalisisProducto($fechaIni, $fechafin, $idclase);
                //var_dump($informacion);
                $i=0;
                $array = array();
                if($informacion){
                    foreach($informacion as $info){                        
                        /*switch($info->month){
                            case 1:
                                $info->month = "Enero";
                                break;
                            case 2:
                                $info->month = "Febrero";
                                break;
                            case 3:
                                $info->month = "Marzo";
                                break;
                            case 4:
                                $info->month = "Abril";
                                break;
                            case 5:
                                $info->month = "Mayo";
                                break;
                            case 6:
                                $info->month = "Junio";
                                break;
                            case 7:
                                $info->month = "Julio";
                                break;
                            case 8:
                                $info->month = "Agosto";
                                break;
                            case 9:
                                $info->month = "Septiembre";
                                break;
                            case 10:
                                $info->month = "Octubre";
                                break;
                            case 11:
                                $info->month = "Noviembre";
                                break;
                            case 12:
                                $info->month = "Diciembre";
                                break;
                        }*/
                        $array[$i] = array(
                            "departamento" => $info->departamento,
                            "descrip" => "[". $info->idproducto . "] ". strtoupper($info->descrip),
                            "linea" => strtoupper($info->linea),                       
                            "cantidad" => $info->cantidad,
                            //"fecha" => $info->fecha,
                            "fecha" => $info->year."/".$info->month,
                            "costo_Unitario" => $info->costounitario,);
                        $i++;
                    }
                }

               
                echo json_encode($array);
            }
        }

        function importarPedidoExcel($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                
                $direccion = $this->uri->segment(1);
                $this->load->model('global_model'); $this->load->model('invtran_model');
                $this->load->model('compras_model');
                $this->data['formatos']      = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['empleados']     = $this->compras_model->getListProveedores(3);

                $this->load->view('importar_pedido_excel', $this->data);
            }
        }

        function getCentrosProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('produccion_model');
                $informacion = $this->produccion_model->getCentrosProduccion();

                echo json_encode($informacion);
            }
        }

        function validarArchivoExcel() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $this->load->model('producto_model');
                $this->load->model('sucursal_model');
                $fecha = $this->input->post('fecha');

                try {
                    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);                    
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                
                $objPHPExcel->setActiveSheetIndex(0); 
                $sheet         = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow    = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();

                $productos = [];
                $totalErrores = 0;
                $lineaActual = 1;
                $mensajeResultado = "";
                $item = 0;

                //si el archivo ocupado no posee productos
                if($highestRow <= 1){
                    $totalErrores = 1;
                    $mensajeResultado = "¡Error! El archivo ocupado no posee productos para importar.";

                    echo json_encode(["resultado"=>$resultado, "totalErrores"=>$totalErrores, "mensajeResultado"=>$mensajeResultado]);//*/
                    return false;
                }

                #   VALIDACION PRIMARIA
                for ($row = 2; $row <= $highestRow; $row++) {
                    $hasError = false;
                    $mensajeError = "";
                    $item++;

                    $rowData = $sheet->rangeToArray('A' . $row . ':E' . $row, NULL, TRUE, FALSE);
                    $rowData = $rowData[0];

                    //se arma el array con la info de los productos

                    if (trim($rowData[0]) == "" && trim($rowData[1]) == "" && trim($rowData[2]) == "" && trim($rowData[3]) == "" && trim($rowData[4]) == "") {
                        continue;
                    }

                    if (strtoupper($rowData[0]) == strtoupper("Fecha") && strtoupper($rowData[1]) == strtoupper("Codigo_Sucursal") && strtoupper($rowData[2]) == strtoupper("Codigo_producto") && strtoupper($rowData[3]) == strtoupper("Descripcion_Producto") && strtoupper($rowData[4]) == strtoupper("Cantidad")) {
                        continue;
                    }

                    $cell = $sheet->getCell('A' . $row);
                    if (\PhpOffice\PhpSpreadsheet\Shared\Date::isDateTime($cell)) {
                        $fechaExcel = $cell->getValue();
                        $fechaFormato = Date::excelToDateTimeObject($fechaExcel)->format('Y-m-d');
                    } else {
                        $fechaFormato = trim($cellValue);
                    }

                    if ($fecha == $fechaFormato) {
                        $pro = array(
                            "numItem" => $item,
                            "fecha"   => trim($fechaFormato),
                            "codSucursal"  => trim($rowData[1]),
                            "codProducto"  => trim($rowData[2]),
                            "descripcion"  => trim($rowData[3]),
                            "cantidad"     => (int) trim($rowData[4]),
                        );

                        $existe = $this->producto_model->existeProductoID($pro["codProducto"]);
                        if(!$existe)  {
                            $mensajeError .= "-El código interno ingresado no existe.\n";
                            $totalErrores++;
                            $pro["error"] = $mensajeError;
                        } else { 
                            if ($existe->estado != 1) {
                                $mensajeError .= "-El producto ingresado no está activo.\n";
                                $totalErrores++;
                                $pro["error"] = $mensajeError;
                            }
                        }

                        $existeSuc = $this->sucursal_model->getSucursal($pro["codSucursal"]);
                        if(!$existeSuc)  {
                            $mensajeError .= "-La sucursal ingresada no existe.\n";
                            $totalErrores++;
                            $pro["error"] = $mensajeError;
                        }

                        if (!isset($pro["error"])) {
                            $pro["error"] = "";
                        }

                        $productos[] = $pro;
                    } else {
                        $totalErrores++;
                        $mensajeResultado = "¡La fecha del documento no coincide con la fecha seleccionada!";
                        echo json_encode(["resultado"=>$productos, "totalErrores"=>$totalErrores, "mensaje"=> $mensajeResultado]);
                        exit;
                    }

                    //$pro = array_filter($pro);
                    
                }
                //var_dump($productos);
                if($totalErrores == 0){
                    $mensajeResultado = "¡Todos los productos se han validado exitosamente!";
                }else{
                    $mensajeResultado = "¡Uno o más productos presentan errores de validación!";
                }
                    
                echo json_encode(["resultado"=>$productos, "totalErrores"=>$totalErrores, "mensaje"=> $mensajeResultado]);//*/
            }
        }

        function updateInfoProducts() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $productos = json_decode($this->input->post('data'), true);
                $centroProduccion = $this->input->post('centro');
                $response = '';

                foreach($productos as $producto) {
                    $fecha = explode("-",$producto['fecha']);
                    $codSucursal = $producto['codSucursal'];
                    $codProducto = $producto['codProducto'];
                    $cantidad = $producto['cantidad'];

                    if($cantidad > 0){
                        $response = $this->produccion_model->updateCantidadProductos($centroProduccion, $fecha, $codSucursal, $codProducto, $cantidad);
                    }else{
                        continue;
                    }
                    
                }

                echo json_encode(array("resultado"=>true));
            }
        }

        function ponerDiaCero() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $centroProduccion = $this->input->post('centro');
                $fecha = $this->input->post('fecha');
                $fechaArr = explode("-",$fecha);

                $response = $this->produccion_model->ponerDiaCero($centroProduccion, $fechaArr);

                echo json_encode(array("resultado"=>$response));
            }
        }

        function getUserInfo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idUser = $this->input->post('idUser');
                $this->load->model('user_model');
                $response = $this->user_model->getDatosUsuario($idUser);

                if ($response == false){
                    $data = array(
                        "sucursal" => ''
                    );
                } else {
                    $data = array(
                        "sucursal" => $response['idcentro']
                    );
                }


                echo json_encode($data);
            }
        }

    }
?>