<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Ppasteles extends CI_Controller{
        
        function __construct(){
            parent::__construct();
        }
        
        function verComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->load->model('componente_model');
                $this->data['tipoComponentes'] = $this->componente_model->getTipoComponentes();
                $this->data['componentesData'] = $this->componente_model->getDataComponentes();
                $this->load->view('mantenimiento_componente', $this->data);
            }
        }
        
        function newComponente($tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipo = $this->uri->segment(2);
				$resultAppName = array(
                    'namePage' => 'Adicionar '.$this->session->userdata('appName')
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('componente_model');
                $this->data['tipoComponentes'] = $this->componente_model->getTipoComponentes();
                $this->data['centroProduccion'] = $this->componente_model->getCentroProduccion();
                $this->data['grupos'] = $this->componente_model->getGruposComponenteDEV($tipo);
                $this->data['selected'] =$tipo;
                $this->load->view('new_componente',$this->data);
            }
        }
        
		function getGrupos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $id = $this->input->post('id');
                $this->load->model('componente_model');
                $grupos = $this->componente_model->getGruposComponenteDEV($id);
                if($grupos != ""){
                    $datos = array();
                    $i = 0;
                    $arraay = explode(",", $grupos);
                    foreach($arraay as $key){
                        $datos[$i] = array("descrip" => trim($key),);  
                        $i++;
                    }
                }else{
                    $datos = array("descrip" => "");
                }
                echo json_encode($datos);
            }
        }
		
        function updateGrupo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $cadena="";
                $nuevo = $this->input->post('nuevo');
                $viejo = $this->input->post('viejo');
                $id = $this->input->post('id');
                $this->load->model('componente_model');
                $cadena = $this->componente_model->getGruposComponenteDEV($id);
                $resultado="";
                $cant=0;
                $arrayPag = explode(",", $cadena);
                $totRig = count($arrayPag);
                $totReal = $totRig;
                for($i=0; $i<$totReal; $i++){
                    if($cant==0){
                        if(trim($arrayPag[$i]) == trim($viejo)){
                            $resultado =  trim($nuevo);
                        }else{
                            $resultado =  trim($arrayPag[$i]);
                        }
                    }else{
                        if(trim($arrayPag[$i]) == trim($viejo)){
                            $resultado .=  ",".trim($nuevo);
                        }else{
                            $resultado .=  ",".trim($arrayPag[$i]);
                        }
                    }    
                    $cant++;                    
                }
                $done  = $this->componente_model->updateGrupos($resultado,$id); 
                echo json_encode($done);
            }
        }
		
        function updateGrupoNuevo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $cadena="";
                $nuevo = $this->input->post('nuevo');
                $id = $this->input->post('id');
                $this->load->model('componente_model');
                $cadena = $this->componente_model->getGruposComponenteDEV($id);
                $resultado = trim($cadena).','.trim($nuevo);
                $done= $this->componente_model->updateGrupos($resultado,$id); 
                echo json_encode($done);
            }
        }
		
        function updateGrupoEliminar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $cadena="";
                $cant=0;
                $resultado="";
                $eliminado = $this->input->post('eliminado');
                $id = $this->input->post('id');
                $this->load->model('componente_model');
                $cadena = $this->componente_model->getGruposComponenteDEV($id);
                $arrayPag = explode(",", $cadena);
                $totRig = count($arrayPag);
                $totReal = $totRig;
                for($i=0; $i<$totReal; $i++){
                    if($cant==0){
                        if($arrayPag[$i] != $eliminado){
                            $resultado =  trim($arrayPag[$i]);
                        }
                    }else{
                        if($arrayPag[$i] != $eliminado){
                            $resultado .= ",".trim($arrayPag[$i]);
                        }
                    }   
                    $cant++;                    
                }
                $done= $this->componente_model->updateGrupos($resultado,$id); 
                echo json_encode($done);
            }
        }
        
        function registrarComponente(){
            if($this->input->post()){
                $tipoCmpt = $this->input->post('tipocmpt');
                $descrip = $this->input->post('descrip');
                $img = $this->input->post('imgen');
                $price = $this->input->post('price');
                $procentro = $this->input->post('procentro');
                $estado = $this->input->post('estatus');
                $grupo = $this->input->post('grupo');
                $askname = $this->input->post('askname');

                if($askname==true||$askname=="true" ){
                    $askname=1;
                }else{
                    $askname=0;
                }
                if($estado==true||$estado=="true" ){
                    $estado=1;
                }else{
                    $estado=0;
                }
                $nameImagen = "";

                
                if(isset($_FILES["imagenes"])){

                    $path_parts = pathinfo($_FILES["imagenes"]["name"]);

                    $date = new DateTime();
                    $date = $date->getTimestamp();
                    $nameImagen = str_replace(" ", "_", $path_parts['filename'])."_".$date.'.'.$path_parts['extension']; //Nombre unico para archivo
                    $config['upload_path'] = "img_cuentas/" . $this->session->userdata('diraccount') . "/";
                    $config['file_name'] = $nameImagen;
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "*";

                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);
                    $this->upload->do_upload("imagenes");
                }
                    
                $whodidit = $this->session->userdata('iduser');
                $option = $this->input->post('saveNext');
                
                $this->load->model('componente_model');
                $resultado = $this->componente_model->insertComponente($tipoCmpt, $descrip, $nameImagen, $price, $procentro, $estado, $grupo, $askname, $whodidit);
                echo json_encode($resultado);

            }else{
                echo json_encode(false);

            }
        }
        
        function modificarComponente(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $id = $this->uri->segment(2);
				$resultAppName = array(
                    'namePage' => 'Actualizar '.$this->session->userdata('appName').' N°'.$id
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('componente_model');
                $dataComponente = $this->componente_model->getRegistro($id);
                $this->data['dataComponente'] = $dataComponente;
                $this->data['centroProduccion'] = $this->componente_model->getCentroProduccion();
                $this->data['tipoComponentes'] = $this->componente_model->getTipoComponentes();
                foreach($dataComponente as $key){
                    $this->data['grupos'] = $this->componente_model->getGruposComponenteDEV($key->numTipo);  
                    $this->data['selected'] =$key->numTipo;
                }
                $this->load->view('form_update_componente',$this->data);
            }
        }
        
        function eliminarComponente(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
				$idcomponente = $this->input->post('idcomponente');
				
                $this->load->model('componente_model');
                $array = $this->componente_model->deleteComponente($idcomponente);
				
				echo json_encode($array);
            }
        }
        
        function actualizarComponente(){
            if($this->input->post()){
                $idcmpt = $this->input->post('idcmpt');
                $tipoCmpt = $this->input->post('tipocmpt');
                $descrip = $this->input->post('descrip');
                $img = $this->input->post('imgen');
                $price = $this->input->post('price');
                $procentro = $this->input->post('procentro');
                $estado = $this->input->post('estatus');
                $grupo = $this->input->post('grupo');
                $askname = $this->input->post('askname');
                $img_original = $this->input->post('img_original');

                if($askname=="true"){
                    $askname=1;
                }else if($askname=="false"){
                    $askname=0;
                }
                if($estado=="true"){
                    $estado=1;
                }else if($estado=="false"){
                    $estado=0;
                }
                $whodidit = $this->session->userdata('iduser');
                $nameImagen = "";

                if($this->input->post('cambia_img')!=0){
                    if(isset($_FILES["imagenes"])){
                        $path_parts = pathinfo($_FILES["imagenes"]["name"]);

                        $date = new DateTime();
                        $date = $date->getTimestamp();
                        $nameImagen = str_replace(" ", "_", $path_parts['filename'])."_".$date.'.'.$path_parts['extension']; //Nombre unico para archivo
                        $config['upload_path'] = "img_cuentas/" . $this->session->userdata('diraccount') . "/";
                        $config['file_name'] = $nameImagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";

                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        $this->upload->do_upload("imagenes");
                    }else{
                        $nameImagen = $img_original;
                    }
                }else{
                    $nameImagen = $img_original;
                }

                $this->load->model('componente_model');
                $resultado = $this->componente_model->updateComponente($idcmpt, $tipoCmpt, $descrip, $nameImagen, $price, $procentro, $estado, $grupo, $askname, $whodidit);
                echo json_encode($resultado);
            }else{
                echo json_encode(false);
            }
        }
        
        function verPedidos($idApp){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $idcentro = $this->session->userdata('idcentrouser');
                $this->data['pedidos'] = $this->mantenimiento_model->getPedidosClientes_ordenes($idcentro,0);
                $this->data['calendarioPedidos'] = $this->mantenimiento_model->getPedidorxFecha($idcentro, 1);
                $this->data['datosimpresoras'] = $this->mantenimiento_model->getInformacionImpresoras('pas_idprinters');
                
                $this->load->view("pedidos/pedidos_ordenes_en_proceso",$this->data);
            }   
        }
        
        function calendarioEntregas(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
				$idcentro = $this->session->userdata('idcentrouser');
                $datos = $this->mantenimiento_model->getPedidorxFecha($idcentro, 1);
                
                $i=0;
                $array = array();
                foreach($datos as $info){
                    $array[$i] = array(
                        "text" => $info->TotalConfirmados,
                        "ownerId" => 1,
                        "startDate" => $info->dev_date,
                        "endDate" => $info->dev_date
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }   
        }
        
        function adicionar_pedido_old(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
                    'namePage' => 'Adicionar '.$this->session->userdata('appName')
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('mantenimiento_model');
				
                $this->data['arrayNotify'] = $this->mantenimiento_model->getDatosVariables('pas_notify');
                $this->data['sucursales'] = $this->mantenimiento_model->getSucursales();
                $this->data['porcioneslist'] = $this->mantenimiento_model->getOptionsCK(8);
                $this->data['vendedores'] = $this->mantenimiento_model->getListadoVendedores();
                
                $this->load->view("pedidos/adicionar_pedido", $this->data);
            }
        }

        //Kevin 20200501 Modificaciones....
        function adicionar_pedido(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
                    'namePage' => 'Adicionar '.$this->session->userdata('appName')
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('mantenimiento_model');
                $this->load->model('configuracion_model');

                $this->configuracion_model->initGvarsPass('pas_origen', 'Facebook', 1);    //20200501
                $this->configuracion_model->initGvarsPass('pas_origen', 'Instagram', 2);   //20200501
                $this->configuracion_model->initGvarsPass('pas_origen', 'Telefono', 3);    //20200501
                $this->configuracion_model->initGvarsPass('pas_origen', 'Whatsapp', 4);    //20200501
                $this->configuracion_model->initGvarsPass('pas_delivery', 'Sucursal', 1);  //20200501
                $this->configuracion_model->initGvarsPass('pas_delivery', 'Domicilio', 2); //20200501
                $this->configuracion_model->initGvarsPass('pas_delivery', 'Hugo', 3);      //20200501
				
                $this->data['arrayNotify'] = $this->mantenimiento_model->getDatosVariables('pas_notify');
                $this->data['pas_origen'] = $this->mantenimiento_model->getDatosVariablesPas('pas_origen');
                $this->data['sucursales'] = $this->mantenimiento_model->getSucursales();
                $this->data['porcioneslist'] = $this->mantenimiento_model->getOptionsCK(8);
                $this->data['vendedores'] = $this->mantenimiento_model->getListadoVendedores();
                
                $this->load->view("pedidos/adicionar_pedido_upt", $this->data);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function verPedidosPasteles($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $usuariosP = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp'  => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);

                $idcentro = $this->session->userdata('idcentrouser');
                $url_page = $this->uri->segment(1) . '/' . $this->uri->segment(2);

                $this->load->model('mantenimiento_model'); $this->load->model('global_model');
                $this->load->model('configuracion_model'); $this->load->model('ppasteles_model');

                $this->configuracion_model->initGvarsPass('pas_origen', 'Facebook',    1); //20200501
                $this->configuracion_model->initGvarsPass('pas_origen', 'Instagram',   2); //20200501
                $this->configuracion_model->initGvarsPass('pas_origen', 'Telefono',    3); //20200501
                $this->configuracion_model->initGvarsPass('pas_origen', 'Whatsapp',    4); //20200501
                $this->configuracion_model->initGvarsPass('pas_delivery', 'Sucursal',  1); //20200501
                $this->configuracion_model->initGvarsPass('pas_delivery', 'Domicilio', 2); //20200501
                $this->configuracion_model->initGvarsPass('pas_delivery', 'Hugo',      3); //20200501
                
                $itemUsuario = explode(',', $usuariosP);
                
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($url_page);
                $this->data['calendarioPedidos'] = $this->mantenimiento_model->getPedidorxFecha($idcentro, 1);
                $this->data['vendedores'] = $this->mantenimiento_model->getListadoVendedores();
                $this->data['pas_origen'] = $this->mantenimiento_model->getDatosVariablesPas('pas_origen');
                $this->data['datosimpresoras'] = $this->mantenimiento_model->getInformacionImpresoras('pas_idprinters');
                $this->data['documentos'] = $this->ppasteles_model->getDocumentosDeVenta();
                $this->data['formaspago'] = $this->ppasteles_model->getFormasDePago();
                $this->data['allowPermiso'] = (in_array($this->session->userdata('iduser'), $itemUsuario)) ? 1 : 0;

                $this->load->view("pedidos/mantenimiento_pastelesencargo", $this->data);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getInformacionCalendarioPedidos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->getInformacionCalendarioPedidos($idcentro, 1);
                
                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getFormasDePagoDisponibles() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->getFormasDePagoDisponibles($idclase);

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getGruposPorciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ppasteles_model');
                $informacion = $this->ppasteles_model->getGruposOpcionesPasteles(8);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => $info->grupo,
                            "title" => $info->grupo
                        );
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getOpcionesPorciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $grupo = $this->input->post('grupo');

                $this->load->model('ppasteles_model');
                $informacion = $this->ppasteles_model->getListadoOpcionesPasteles(8, $grupo);

                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $array[$i] = array(
                        "id" => $info->idcmpt,
                        "descrip" => $info->descrip,
                        "imagen" => $info->imagen
                    );
                    $i++;
                }

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getListadoPedidosPasteles(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('ppasteles_model');
                $informacion = $this->ppasteles_model->getListadoPedidosPasteles($idcentro, 0);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){

                        $hora = date("g:i a", strtotime($info->dev_time));
                        if(trim(ucwords($info->dev_date2)) == ''){
                            $fechaentrega = "";
                        }else{
                            $fechaentrega = trim(ucwords($info->dev_date2)).", ".trim(strtoupper($hora));
                        }

                        $array[$i] = array(
                            "numero" => $info->numero,
                            "descrip" => $info->cli_name,
                            "telefono" => $info->cli_phone,
                            "fechapedido" => $info->date,
                            "fechaentrega" => $fechaentrega,
                            "valventa" => $info->val_venta
                        );
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function deletePedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numpedido');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('ppasteles_model');
                $this->ppasteles_model->eliminarPedido($numero);
                $informacion = $this->ppasteles_model->getListadoPedidosPasteles($idcentro, 0);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $hora = date("g:i a", strtotime($info->dev_time));
                        if(trim(ucwords($info->dev_date2)) == ''){
                            $fechaentrega = "";
                        }else{
                            $fechaentrega = trim(ucwords($info->dev_date2)).", ".trim(strtoupper($hora));
                        }

                        $array[$i] = array(
                            "numero" => $info->numero,
                            "descrip" => $info->cli_name,
                            "telefono" => $info->cli_phone,
                            "fechapedido" => $info->date,
                            "fechaentrega" => $fechaentrega,
                            "valventa" => $info->val_venta
                        );
                        $i++;
                    }
                }

                echo json_encode($array);

            }
        }

        //Kevin Cienfuegos Modificaciones...
		function adicionarPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Adicionar '.$this->session->userdata('appName')
                );
                $this->session->set_userdata($resultAppName);

                $urlPage = $this->uri->segment(1) . '/' . $this->uri->segment(2);

                $this->load->model('mantenimiento_model'); $this->load->model('global_model');

                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($urlPage);
                $this->data['vendedores'] = $this->mantenimiento_model->getListadoVendedores();
                $this->data['pas_origen'] = $this->mantenimiento_model->getDatosVariablesPas('pas_origen');

                $this->load->view("pedidos/pastelesencargo_adicionar", $this->data);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function adicionarEncabezadoPastel(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $origen      = $this->input->post('origen');
                $vendedor    = $this->input->post('vendedor');
                $telefono    = $this->input->post('telefono');
                $nombre      = $this->input->post('nombre');
                $email       = $this->input->post('email');
                $telefono2   = $this->input->post('telefono2');
                $documento   = $this->input->post('documento');
                $porciones   = $this->input->post('porciones');
                $tortas      = $this->input->post('tortas');
                $lugar       = $this->input->post('lugar');
                $contacto    = $this->input->post('contacto');
                $direccion   = $this->input->post('direccion');
                $telefonodev = $this->input->post('telefonodev');
                $idcentrodev = $this->input->post('idcentrodev');
                $idcentro    = $this->session->userdata('idcentrouser');

                $this->load->model('ppasteles_model');
                $numero = $this->ppasteles_model->adicionarEncabezadoPastel($origen, $vendedor, $telefono, $nombre, $email, $telefono2, $documento, $porciones, $tortas, $idcentro, $lugar, $direccion, $telefonodev, $contacto, $idcentrodev);

                if($numero != 0){
                    if($tortas != 0){
                        $this->ppasteles_model->adicionarNuevaTortaPastel($numero, $tortas);
                    }
                }else{
                    $numero = false;
                }

                echo json_encode($numero);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function editarPedido($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
         		$resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$numero
                );
                $this->session->set_userdata($resultAppName);

                $urlPage = $this->uri->segment(1) . '/' . $this->uri->segment(2);

                $this->load->model('global_model');
                $this->load->model('ppasteles_model'); $this->load->model('mantenimiento_model');

                //Funciones.-
                $this->data['documentos']      = $this->ppasteles_model->getDocumentosDeVenta();
                $this->data['vendedores']      = $this->mantenimiento_model->getListadoVendedores();
                $this->data['infopedido']      = $this->ppasteles_model->getInformacionPedido($numero);
                $this->data['formatos']        = $this->global_model->getFormatosImpresionGrid($urlPage);
                $this->data['pas_limithp']     = $this->global_model->getValorTextoVariable('pas_limithp');
                $this->data['pas_origen']      = $this->mantenimiento_model->getDatosVariablesPas('pas_origen');
                $this->data['diasminpedido']   = $this->mantenimiento_model->getMinimoDiasPedidos('pas_pdias');
                $this->data['pas_delivery']    = $this->mantenimiento_model->getDatosVariablesPas('pas_delivery');
                $this->data['notasvalidate']   = $this->mantenimiento_model->getNotasRequeridas('pas_notas');
                $this->data['sucursales']      = $this->ppasteles_model->getListadoSucursales();
                $this->data['datosimpresoras'] = $this->mantenimiento_model->getInformacionImpresoras('pas_idprinters');
                $this->data['txtPosiciones']   = (($this->mantenimiento_model->getNameOptionsCK(9) == false) ? 0 : $this->mantenimiento_model->getNameOptionsCK(9));
                $this->data['txtFormas']       = (($this->mantenimiento_model->getNameOptionsCK(10) == false) ? 0 : $this->mantenimiento_model->getNameOptionsCK(10));
                $this->data['txtRellenos']     = (($this->mantenimiento_model->getNameOptionsCK(13) == false) ? 0 : $this->mantenimiento_model->getNameOptionsCK(13));
                $this->data['txtSabores']      = (($this->mantenimiento_model->getNameOptionsCK(11) == false) ? 0 : $this->mantenimiento_model->getNameOptionsCK(11));
                $this->data['txtBanos']        = (($this->mantenimiento_model->getNameOptionsCK(12) == false) ? 0 : $this->mantenimiento_model->getNameOptionsCK(12));
                $this->data['txtCoberturas']   = (($this->mantenimiento_model->getNameOptionsCK(14) == false) ? 0 : $this->mantenimiento_model->getNameOptionsCK(14));
                $this->data['txtColores']      = (($this->mantenimiento_model->getNameOptionsCK(15) == false) ? 0 : $this->mantenimiento_model->getNameOptionsCK(15));

                $this->load->view("pedidos/pastelesencargo_editar", $this->data);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function modificarInfoCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero    = $this->input->post('numero');
                $vendedor  = $this->input->post('vendedor');
                $origen    = $this->input->post('origen');
                $cliphone  = $this->input->post('cliphone');
                $cliname   = $this->input->post('cliname');
                $cliemail  = $this->input->post('cliemail');
                $cliphone2 = $this->input->post('cliphone2');
                $documento = $this->input->post('documento');
                $numtortas = $this->input->post('numtortas');
                $porciones = $this->input->post('porciones');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->modificarInfoCliente($numero, $vendedor, $origen, $cliphone, $cliname, $cliemail, $cliphone2, $documento, $numtortas, $porciones);

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getListadoHorasPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $hora = 6; $hora_m = 6;
                $minuto = "00";

                $array = array();
                for($i=0; $i<33; $i++){
                    $hora_p = str_pad($hora, 2, '0', STR_PAD_LEFT);
                    $hora_m < 12 ? $ampm = 'AM' : $ampm = 'PM';

                    $array[$i] = array(
                        "id" =>  str_pad($hora_m, 2, '0', STR_PAD_LEFT) . ':' . $minuto . ':00',
                        "descrip" => $hora_p . ':' . $minuto . ' ' . $ampm
                    );
                    
                    if($minuto == '30'){
                        $hora++; $hora_m++;
                        $hora == 13 ? $hora = 1 : '';
                    }

                    $minuto == '00' ? $minuto = '30' : $minuto = '00';
                }

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function modificarEntregaPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero    = $this->input->post('numero');
                $fecha     = $this->input->post('fecha');
                $hora      = $this->input->post('hora');
                $lugar     = $this->input->post('lugar');
                $sucursal  = $this->input->post('sucursal');
                $idcentro  = $this->input->post('idcentro');
                $preguntar = $this->input->post('preguntar');
                $telefono  = $this->input->post('telefono');
                $direccion = $this->input->post('direccion');
                
                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->modificarEntregaPedido($numero, $fecha, $hora, $lugar, $sucursal, $idcentro, $preguntar, $telefono, $direccion);

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getDatosTortas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->getDatosTortas($numero);

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getGruposComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtipo = $this->input->post('idtipo');
                
                $this->load->model('ppasteles_model');
                $informacion = $this->ppasteles_model->getGruposComponentes($idtipo);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => $info->grupo,
                            "title" => $info->grupo
                        );
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getOpcionesComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $grupo = $this->input->post('grupo');
                $idtipo = $this->input->post('idtipo');

                $this->load->model('ppasteles_model');
                $informacion = $this->ppasteles_model->getOpcionesComponentes($grupo, $idtipo);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => $info->idcmpt,
                            "descrip" => $info->descrip,
                            "imagen" => $info->imagen,
                            "price" => $info->price
                        );
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function modificarInfoTorta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero    = $this->input->post('numero');
                $forma     = $this->input->post('forma');
                $sabor     = $this->input->post('sabor');
                $bano      = $this->input->post('bano');
                $color     = $this->input->post('color');
                $notas     = $this->input->post('notas');
                $montaje   = $this->input->post('montaje');
                $relleno   = $this->input->post('relleno');
                $cobertura = $this->input->post('cobertura');
                $itemline  = $this->input->post('itemline');
                
                $this->load->model('ppasteles_model');
                $this->ppasteles_model->modificarInfoTorta($numero, $itemline, $forma, $sabor, $bano, $color, $notas, $montaje, $relleno, $cobertura);
                $infoTortas = $this->ppasteles_model->getDatosTortas($numero);
                $validatePedido = $this->ppasteles_model->validateTortasCompletas($numero);
                
                $array = array(
                    'infoTortas' => $infoTortas,
                    'validatePedido' => $validatePedido
                );
                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getInformacionDedicatorias(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');

                $this->load->model('ppasteles_model');
                $infoDedic = $this->ppasteles_model->getInformacionDedicatoria($numero);
                $infoFotos = $this->ppasteles_model->getInformacionFotos($numero);

                $array = array(
                    "dedicatoria" => $infoDedic,
                    "fotos" => $infoFotos
                );

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function modificarInformacionDedicatoria(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero      = $_POST['numero'];
                $imgCatalogo = $_POST['idCatalogo'];
                $txtCatalogo = $_POST['txtCatalogo'];
                $txtDedicato = $_POST['txtDedicato'];

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->modificarInformacionDedicatoria($numero, $imgCatalogo, $txtCatalogo, $txtDedicato);

                for($i=1; $i<=4; $i++){
                    if(isset($_FILES["imgFile" . $i])){
                        $infoFile = $_FILES["imgFile" . $i];
                        $nameImagen = $infoFile["name"];
                        $documentTemp = $infoFile['tmp_name'];
                        
                        if($nameImagen != ""){
                            $nameImagen = str_replace(" ", "_", $nameImagen);
                            
                            $config['upload_path'] = "img_cuentas/" . $this->session->userdata('diraccount') . "/";
                            $config['file_name'] = $nameImagen;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "*";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);
                            
                            if($this->upload->do_upload('imgFile' . $i)){
                                // INICIO PRUEBAS REDIMENSIONAR IMAGEN 
                                /*
                                $image_data = $this->upload->data();
                                $config['image_library'] = 'gd2';
                                $config['source_image'] = $image_data['full_path']; //get original image
                                $config['maintain_ratio'] = TRUE;
                                $config['width'] = 300;
                                $config['height'] = 350;
                                $this->load->library('image_lib', $config);

                                $this->image_lib->resize();
                                */
                                //  FIN PRUEBAS
                             
                                $notasImagen = $this->input->post('notasFoto' . $i);
                                $this->ppasteles_model->updateImagenPastel($numero, $nameImagen, $notasImagen, $i);
                            }
                        }
                    }
                }

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getInformacionAccesoriosBases(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');
                $tipo = $this->input->post('tipo');

                $this->load->model('ppasteles_model');
                
                $i=0;
                for($j=1; $j<=12; $j++){
                    $info_acba = $this->ppasteles_model->getInformacionAccesorioBase($numero, $j, $tipo);
                    $array[$i] = array(
                        "id" => $info_acba == false ? $j : $info_acba['itemline'],
                        "imagen"   => $info_acba == false ? '' : $info_acba['imagen'],
                        "descrip"  => $info_acba == false ? 'Item #' . $j : $info_acba['descrip'],
                        "cantidad" => $info_acba == false ? 0 . $j : $info_acba['qty'],
                        "precio"   => $info_acba == false ? 0 . $j : $info_acba['price'],
                        "exist"    => $info_acba == false ? false : true
                    );
                    $i++;
                }

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function insertarAccBasPastel(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');
                $tipo = $this->input->post('idtipo');
                $idcmpt = $this->input->post('idcmpt');
                $cantidad = $this->input->post('cantidad');
                $precio = $this->input->post('precio');
                $notas = $this->input->post('notas');
                $item = $this->input->post('item');

                $this->load->model('ppasteles_model');
                $this->ppasteles_model->insertarAccBasPastel($numero, $tipo, $idcmpt, $cantidad, $precio, $notas, $item);

                $i=0;
                for($j=1; $j<=12; $j++){
                    $info_acba = $this->ppasteles_model->getInformacionAccesorioBase($numero, $j, $tipo);
                    $array[$i] = array(
                        "id" => $info_acba == false ? $j : $info_acba['itemline'],
                        "imagen"   => $info_acba == false ? '' : $info_acba['imagen'],
                        "descrip"  => $info_acba == false ? 'Item #' . $j : $info_acba['descrip'],
                        "cantidad" => $info_acba == false ? 0 . $j : $info_acba['qty'],
                        "precio"   => $info_acba == false ? 0 . $j : $info_acba['price'],
                        "exist"    => $info_acba == false ? false : true
                    );
                    $i++;
                }

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getInformacionGeneral() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->getInformacionGeneral($numero);
                
                echo json_encode($array);
            }
        }
        
        //Kevin Cienfuegos Modificaciones...
        function getInformacionEntrega() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');
                
                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->getInformacionEntrega($numero);
                
                echo json_encode($array);
            }
        }
        
        //Kevin Cienfuegos Modificaciones...
        function eliminarFotoPastel() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');
                $numfoto = $this->input->post('numfoto');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->eliminarFotoPastel($numero, $numfoto);
                
                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function elminarTortaPedido() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');
                $numTorta = $this->input->post('numTorta');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->elminarTortaPedido($numero, $numTorta);
                
                echo json_encode($array);
            }
        }
        
        //Kevin Cienfuegos Modificaciones...
        function adicionarTortaPedido() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->adicionarTortaPedido($numero);
                
                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function eliminarComponenteAB() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');
                $itemline = $this->input->post('itemline');
                $tipoAB = $this->input->post('tipoAB');

                $this->load->model('ppasteles_model');
                $this->ppasteles_model->eliminarComponenteAB($numero, $itemline, $tipoAB);
                
                $i=0;
                for($j=1; $j<=12; $j++){
                    $info_acba = $this->ppasteles_model->getInformacionAccesorioBase($numero, $j, $tipoAB);
                    $array[$i] = array(
                        "id" => $info_acba == false ? $j : $info_acba['itemline'],
                        "imagen"  => $info_acba == false ? '' : $info_acba['imagen'],
                        "descrip" => $info_acba == false ? 'Item #' . $j : $info_acba['descrip'],
                        "exist"   => $info_acba == false ? false : true
                    );
                    $i++;
                }

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getInformacionTotales() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->getInformacionTotales($numero);

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function confirmarOrdenPedido() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');
                $valPastel = $this->input->post('valPastel');
                $valEnvio = $this->input->post('valEnvio');
                $valAcces = $this->input->post('valAcces');
                $valBases = $this->input->post('valBases');
                $valRefund = $this->input->post('valRefund');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->confirmarOrdenPedido($numero, $valPastel, $valEnvio, $valAcces, $valBases, $valRefund);

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getDetallePedidoComp() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');

                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->getDetallePedidoComp($numero);

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getDetalleComprobantesPago(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numPedido = $this->input->post('numPedido');
                
                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->getListadoComprobantesPago($numPedido, 6);
                
                echo json_encode($array);
            }  
        }

        //Kevin Cienfuegos Modificaciones...
        function uploadComprobanteImgPago(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $_POST['numeroPedido'];
                $formapago    = $_POST['inputFormasPago'];
                $valor        = $_POST['inputValComp'];
				
				if(isset($_FILES["imgComprobante"])){
                	$file = $_FILES["imgComprobante"];
					$nombre = $file["name"];
                  	
					if($nombre != ""){
                        $datosFoto1 = $_POST['nameImagenComprobante'];
                        $formatoImagen1 = explode(".", $datosFoto1);
                        $nombre_imagen1 = 'abonoComprobante'.rand().'.'.$formatoImagen1[1];
                        
                    	$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
						$config['file_name'] = $nombre_imagen1;
						$config['over_write'] = "TRUE";
                       	$config['allowed_types'] = "gif|jpg|jpeg|png";
						$this->load->library('upload', $config);
						$this->upload->initialize($config);
                      	
						if($this->upload->do_upload('imgComprobante')){ 
                            $this->load->model('ppasteles_model');
							$this->ppasteles_model->insertComprobantePago($numero, $formapago, $valor, $nombre_imagen1);
                            
                            $infoData = $this->ppasteles_model->getDetallePedidoComp($numero);
                            $infoComp = $this->ppasteles_model->getListadoComprobantesPago($numero, 6);

                            $array = array(
                                'info' => $infoData,
                                'dataSource' => $infoComp
                            );

                            echo json_encode($array);
						}else{
							echo json_encode(false);
						}
					}
				}
			}
		}

        //Kevin Cienfuegos Modificaciones...
        function eliminarComprobantePago(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero   = $this->input->post('numero');
                $itemline = $this->input->post('itemline');
                $valor    = $this->input->post('valor');

				$this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->eliminarComprobantePago($numero, $itemline, 6, $valor);
                $infoData = $this->ppasteles_model->getDetallePedidoComp($numero);
                $infoComp = $this->ppasteles_model->getListadoComprobantesPago($numero, 6);

                $array = array(
                    'info' => $infoData,
                    'dataSource' => $infoComp
                );

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function generarCopiaPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');
                $cantidad = $this->input->post('cantidad');
                
                $this->load->model('ppasteles_model');
                $array = $this->ppasteles_model->generarCopiaPedido($numero, $cantidad);
                echo json_encode($array);
            }
        }

        function ordenesConfirmadasNuevo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('ppasteles_model');
                $informacion = $this->ppasteles_model->getPedidosConfirmadosGrid($idcentro, 1);
				
				$i=0;
				$array = array();
				foreach($informacion as $info){
					$hora = date("g:i a", strtotime($info->dev_time));
					$array[$i] = array(
						"numero" => trim($info->numero),
						"descrip" => trim($info->cli_name),
						"telefono" => $info->cli_phone,
						"fechapedido" => $info->date,
						"fechaentrega" => $info->dev_date,
						"horaentrega" => $hora,
						"valventa" => $info->val_venta * 1,
						"valpendiente" => ($info->val_venta - $info->val_anti) * 1,
					);
					$i++;
				}
				
                echo json_encode($array);
            }
		}

        //Kevin Cienfuegos Modificaciones...
        function getListadoPedidosConfirmadosFecha(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('ppasteles_model');
                $informacion = $this->ppasteles_model->getListadoPedidosConfirmadosFecha($idcentro, 1, $fecha);
                $i=0;
				$array = array();
				foreach($informacion as $info){
					$hora = date("g:i a", strtotime($info->dev_time));
					$array[$i] = array(
						"numero" => trim($info->numero),
						"descrip" => trim($info->cli_name),
						"telefono" => $info->cli_phone,
						"fechapedido" => $info->date,
						"fechaentrega" => $info->dev_date,
						"horaentrega" => $hora,
						"valventa" => $info->val_venta * 1,
						"valpendiente" => ($info->val_venta - $info->val_anti) * 1,
					);
					$i++;
				}

                echo json_encode($array);
            }
        }

        //Kevin Cienfuegos Modificaciones...
        function getOpcionesDedicatorias() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ppasteles_model');
                $mensajes = $this->ppasteles_model->getOpcionesMensajesDedicatoria(16);
                $posiciones = $this->ppasteles_model->getOpcionesPosicionDedicatoria(16);

                $array = array(
                    'mensajes' => $mensajes,
                    'posiciones' => $posiciones
                );

                echo json_encode($array);
            }
        }
        
        function getGruposByTipoComponente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtipo = $this->input->post('idtipo');

                $this->load->model('componente_model');
                $grupos = $this->componente_model->getGruposByTipoComponente($idtipo);

                echo json_encode($grupos);
            }
        }

        function getComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{

                $this->load->model('componente_model');
                $componentes = $this->componente_model->getDataComponentes();

                echo json_encode($componentes);
            }
        }
       
        //------------------------------------------------------------------------------------------------------------
        function registrarPedido(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $cliphone = $this->input->post('cliphone');
                $cliname = $this->input->post('cliname');
                $idworker = $this->input->post('vendedor');
                $cliname = strtoupper($cliname);
                $cliemail = $this->input->post('cliemail');
                $cliphone1 = $this->input->post('cliphone1');
                $devnotes = $this->input->post('devnotes');
                $cktortas = $this->input->post('cktortas');
                $ckslices = $this->input->post('ckslices');
                $origen = $this->input->post('origen');
				
                $dev_place = $this->input->post('dev_place');
                $dev_direc = $this->input->post('devdirec');
                $dev_phone = $this->input->post('devphone');
                $dev_contact = $this->input->post('devcontact');
                $dev_idcentro = $this->input->post('dev_idcentro');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $ingreso = $this->mantenimiento_model->adicionar_pro_hd(1,date('Y-m-d'),$idcentro,1,0,$cliphone,$cliname,$cliphone1,$cliemail,$devnotes,$cktortas,$ckslices,$idworker,$dev_place,$dev_direc,$dev_phone,$dev_contact,$dev_idcentro,$origen);
				    
                if($ingreso['ingreso']==1){
                    if($ingreso['numero']==0){
                        redirect('ppasteles/pedidos_ordenes_en_proceso');
                    }else{
                        if($cktortas>0){
                            for ($i=0; $i < $cktortas; $i++){ 
                                $itemMayor = $this->mantenimiento_model->getNumItemByType($ingreso['numero'],1);
                                $n = $itemMayor + 1;
                                $this->mantenimiento_model->adicionar_pro_dt_new($ingreso['numero'],$n,'9904',1,0,'',0,0,0,0,0,0,0);
                            }
                        }
                        redirect('ppasteles/editar_pedido/'.$ingreso['numero']);
                    }
				}else{
                    $this->load->view("pedidos/adicionar_pedido");
                }
            }
        }
		
		function registrarPedidoNuevo(){
			if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $cliphone = $this->input->post('cliphone');
                $cliname = $this->input->post('cliname');
                $cliname = strtoupper($cliname);
                $cliemail = $this->input->post('cliemail');
                $cliphone1 = $this->input->post('cliphone1');
                $devnotes = $this->input->post('devnotes');
                $cktortas = $this->input->post('cktortas');
                $ckslices = $this->input->post('ckslices');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $ingreso = $this->mantenimiento_model->adicionar_pro_hd(1,date('Y-m-d'),$idcentro,1,0,$cliphone,$cliname,$cliphone1,$cliemail,$devnotes,$cktortas,$ckslices,3);
				    
                if($ingreso['ingreso']==1){
                    if($ingreso['numero']==0){
                        echo json_encode(false);
                    }else{
                        if($cktortas>0){
                            for ($i=0; $i < $cktortas; $i++){ 
                                $itemMayor = $this->mantenimiento_model->getNumItemByType($ingreso['numero'],1);
                                $n = $itemMayor + 1;
                                $this->mantenimiento_model->adicionar_pro_dt_new($ingreso['numero'],$n,'9904',1,0,'',0,0,0,0,0,0,0);
                            }
                        }
						echo json_encode($ingreso['numero']);
					}
				}else{
					echo json_encode(false);
                }
            }
		}
        
        function buscar_cliente_telefono(){
            $cliphone = $this->input->post('cliphone');
            $this->load->model('mantenimiento_model');
            $coincidencia = $this->mantenimiento_model->buscar_cliente_telefono($cliphone);

            if($coincidencia==false){
                $nombre = "";
                $email = "";
                $cli_phone1 = "";
                $cli_notify = "";
                $dev_place = "";
                $dev_direc = "";
                $dev_phone = "";
                $dev_contact = "";
                $dev_notes = "";
            }else{
                $nombre = $coincidencia['cli_name'];
                $email = $coincidencia['cli_email'];
                $cli_phone1 = $coincidencia['cli_phone1'];
                $cli_notify = $coincidencia['cli_notify'];
                $dev_place = $coincidencia['dev_place'];
                $dev_direc = $coincidencia['dev_direc'];
                $dev_phone = $coincidencia['dev_phone'];
                $dev_contact = $coincidencia['dev_contact'];
                $dev_notes = $coincidencia['dev_notes'];
            }

            $array = array(
                'cliname'=>$nombre, 
                'cliemail'=>$email,
                'cli_phone1'=>$cli_phone1,
                'cli_notify'=>$cli_notify,
                'dev_place'=>$dev_place,
                'dev_direc'=>$dev_direc,
                'dev_phone'=>$dev_phone,
                'dev_contact'=>$dev_contact,
                'dev_notes'=>$dev_notes
            );
            
            echo json_encode($array);
        }
		
		function searchInformacionEntregaCliente(){
			$cliphone = $this->input->post('cliphone');
            
			$this->load->model('mantenimiento_model');
			$informacion = $this->mantenimiento_model->searchInformacionEntregaCliente($cliphone);
			
			$i=0;
			$array = array();
            
			if($informacion != false){
				foreach($informacion as $info){
					$array[$i] = array(
						'numero' => $info->numero, 
						'cliname' => $info->cli_name, 
						'cliemail' => $info->cli_email,
						'cli_phone1' => $info->cli_phone1,
						'cli_notify' => $info->cli_notify,
						'dev_place' => $info->dev_place,
						'dev_direc' => $info->dev_direc,
						'dev_phone' => $info->dev_phone,
						'dev_contact' => $info->dev_contact,
						'dev_place' => $info->dev_place,
						'dev_idcentro' => $info->dev_idcentro,
						'dev_notes' => $info->dev_notes
					);
					$i++;
				}
            }
			
			echo json_encode($array);
		}
        
        function buscarNumeroPorciones(){
            $this->load->model('mantenimiento_model');
            $Result = $this->mantenimiento_model->getOptionsCK(8);
            $Result2 = $this->mantenimiento_model->getGroupOptionsCK(8);
            $array = array(
                'porciones'=>$Result, 
                'grupo'=>$Result2
            );
            echo json_encode($array);
        }
        
        function saveValPastelPorcion(){
            $this->load->model('mantenimiento_model');
            $numorder = $this->input->post('numorder');
            $idtipo = $this->input->post('idporcion');
            $array = $this->mantenimiento_model->updateValPastelByPorcion($numorder, $idtipo);
            echo json_encode($array);
        }
        
        function editar_pedido($numero){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
         		$resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$numero
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('global_model'); $this->load->model('mantenimiento_model');
                $this->load->model('configuracion_model');

                $this->configuracion_model->initGvarsPass('pas_origen', 'Facebook', 1);    //20200501
                $this->configuracion_model->initGvarsPass('pas_origen', 'Instagram', 2);   //20200501
                $this->configuracion_model->initGvarsPass('pas_origen', 'Telefono', 3);    //20200501
                $this->configuracion_model->initGvarsPass('pas_origen', 'Whatsapp', 4);    //20200501
                $this->configuracion_model->initGvarsPass('pas_delivery', 'Sucursal', 1);  //20200501
                $this->configuracion_model->initGvarsPass('pas_delivery', 'Domicilio', 2); //20200501
                $this->configuracion_model->initGvarsPass('pas_delivery', 'Hugo', 3);      //20200501
				
                
                $this->data['pas_origen'] = $this->mantenimiento_model->getDatosVariablesPas('pas_origen');
                $this->data['pas_delivery'] = $this->mantenimiento_model->getDatosVariablesPas('pas_delivery');
                
                $this->data['registro'] = $this->mantenimiento_model->get_pedido_pro_hd($numero);
                $this->data['sucursales'] = $this->mantenimiento_model->getSucursales();
                $this->data['arrayNotify'] = $this->mantenimiento_model->getDatosVariables('pas_notify');
				$this->data['vendedores'] = $this->mantenimiento_model->getListadoVendedores();
				
                $this->data['arrayPasteles'] = $this->mantenimiento_model->getPasteles2($numero,1);
                $this->data['numTortas'] = count($this->data['arrayPasteles']);
                $tortasCompletas = $this->mantenimiento_model->getTortasCompletas2($numero,1);
                $this->data['itemMenor'] = $this->mantenimiento_model->getTortaMenor($numero);
                
                $this->data['listSelect'] = $this->mantenimiento_model->get_pasteles_list_for_select($numero,1);
                
                $this->data['porcioneslist'] = $this->mantenimiento_model->getOptionsCK(8);
                $this->data['groupPos'] = $this->mantenimiento_model->getGroupOptionsCK(9);
                $this->data['posicioneslist'] = $this->mantenimiento_model->getOptionsCK(9);
                $this->data['namePosiciones'] = $this->mantenimiento_model->getNameOptionsCK(9);
                $this->data['groupForm'] = $this->mantenimiento_model->getGroupOptionsCK(10);
                $this->data['formaslist'] = $this->mantenimiento_model->getOptionsCK(10);
                $this->data['nameFormas'] = $this->mantenimiento_model->getNameOptionsCK(10);
                $this->data['groupRel'] = $this->mantenimiento_model->getGroupOptionsCK(13);
                $this->data['rellenoslist'] = $this->mantenimiento_model->getOptionsCK(13);
                $this->data['nameRellenos'] = $this->mantenimiento_model->getNameOptionsCK(13);
                $this->data['groupSab'] = $this->mantenimiento_model->getGroupOptionsCK(11);
                $this->data['saboreslist'] = $this->mantenimiento_model->getOptionsCK(11);
                $this->data['nameSabores'] = $this->mantenimiento_model->getNameOptionsCK(11);
                $this->data['groupBan'] = $this->mantenimiento_model->getGroupOptionsCK(12);
                $this->data['banoslist'] = $this->mantenimiento_model->getOptionsCK(12);
                $this->data['nameBanos'] = $this->mantenimiento_model->getNameOptionsCK(12);
                $this->data['groupCob'] = $this->mantenimiento_model->getGroupOptionsCK(14);
                $this->data['coberturaslist'] = $this->mantenimiento_model->getOptionsCK(14);
                $this->data['nameCoberturas'] = $this->mantenimiento_model->getNameOptionsCK(14);
                $this->data['groupCol'] = $this->mantenimiento_model->getGroupOptionsCK(15);
                $this->data['coloreslist'] = $this->mantenimiento_model->getOptionsCK(15);
                $this->data['nameColores'] = $this->mantenimiento_model->getNameOptionsCK(15);
                $this->data['nameAccesorios'] = $this->mantenimiento_model->getNameOptionsCK(1);
                $this->data['nameBases'] = $this->mantenimiento_model->getNameOptionsCK(2);
                $this->data['notasReqe'] = $this->mantenimiento_model->getNotasRequeridas('pas_notas');
                $this->data['diasminimopedidos'] = $this->mantenimiento_model->getMinimoDiasPedidos('pas_pdias');
                $this->data['datosimpresoras'] = $this->mantenimiento_model->getInformacionImpresoras('pas_idprinters');
                $this->data['numeroPedidoPastel'] = $numero;
                //---------------------------------------------------------------------------------
                //---------------------------------------------------------------------------------
                $this->data['arrayAccesoriosBases'] = $this->mantenimiento_model->get_Accesorios_Bases_Pedido($numero);
                $this->data['totalAcc'] = $this->mantenimiento_model->getPrice($numero,2);
                $this->data['totalBac'] = $this->mantenimiento_model->getPrice($numero,3);
                $this->data['reembolsable'] = $this->mantenimiento_model->getReembolsable($numero);
                $this->data['pas_limithp'] = $this->global_model->getValorTextoVariable('pas_limithp');

                $this->load->view("pedidos/editar_pedido2", $this->data);
            }
        }
        
        function editar_pedido2($numero){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
         		$resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$numero
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('mantenimiento_model');
                
                $this->data['registro'] = $this->mantenimiento_model->get_pedido_pro_hd($numero);
                $this->data['sucursales'] = $this->mantenimiento_model->getSucursales();
                $this->data['arrayNotify'] = $this->mantenimiento_model->getDatosVariables('pas_notify');
				$this->data['vendedores'] = $this->mantenimiento_model->getListadoVendedores();
				
                $this->data['arrayPasteles'] = $this->mantenimiento_model->getPasteles2($numero,1);
                $this->data['numTortas'] = count($this->data['arrayPasteles']);
                $tortasCompletas = $this->mantenimiento_model->getTortasCompletas2($numero,1);
                $this->data['itemMenor'] = $this->mantenimiento_model->getTortaMenor($numero);
                
                $this->data['listSelect'] = $this->mantenimiento_model->get_pasteles_list_for_select($numero,1);
                
                $this->data['porcioneslist'] = $this->mantenimiento_model->getOptionsCK(8);
                $this->data['groupPos'] = $this->mantenimiento_model->getGroupOptionsCK(9);
                $this->data['posicioneslist'] = $this->mantenimiento_model->getOptionsCK(9);
                $this->data['namePosiciones'] = $this->mantenimiento_model->getNameOptionsCK(9);
                $this->data['groupForm'] = $this->mantenimiento_model->getGroupOptionsCK(10);
                $this->data['formaslist'] = $this->mantenimiento_model->getOptionsCK(10);
                $this->data['nameFormas'] = $this->mantenimiento_model->getNameOptionsCK(10);
                $this->data['groupRel'] = $this->mantenimiento_model->getGroupOptionsCK(13);
                $this->data['rellenoslist'] = $this->mantenimiento_model->getOptionsCK(13);
                $this->data['nameRellenos'] = $this->mantenimiento_model->getNameOptionsCK(13);
                $this->data['groupSab'] = $this->mantenimiento_model->getGroupOptionsCK(11);
                $this->data['saboreslist'] = $this->mantenimiento_model->getOptionsCK(11);
                $this->data['nameSabores'] = $this->mantenimiento_model->getNameOptionsCK(11);
                $this->data['groupBan'] = $this->mantenimiento_model->getGroupOptionsCK(12);
                $this->data['banoslist'] = $this->mantenimiento_model->getOptionsCK(12);
                $this->data['nameBanos'] = $this->mantenimiento_model->getNameOptionsCK(12);
                $this->data['groupCob'] = $this->mantenimiento_model->getGroupOptionsCK(14);
                $this->data['coberturaslist'] = $this->mantenimiento_model->getOptionsCK(14);
                $this->data['nameCoberturas'] = $this->mantenimiento_model->getNameOptionsCK(14);
                $this->data['groupCol'] = $this->mantenimiento_model->getGroupOptionsCK(15);
                $this->data['coloreslist'] = $this->mantenimiento_model->getOptionsCK(15);
                $this->data['nameColores'] = $this->mantenimiento_model->getNameOptionsCK(15);
                $this->data['nameAccesorios'] = $this->mantenimiento_model->getNameOptionsCK(1);
                $this->data['nameBases'] = $this->mantenimiento_model->getNameOptionsCK(2);
                $this->data['notasReqe'] = $this->mantenimiento_model->getNotasRequeridas('pas_notas');
                $this->data['diasminimopedidos'] = $this->mantenimiento_model->getMinimoDiasPedidos('pas_pdias');
                //---------------------------------------------------------------------------------
                //---------------------------------------------------------------------------------
                $this->data['arrayAccesoriosBases'] = $this->mantenimiento_model->get_Accesorios_Bases_Pedido($numero);
                $this->data['totalAcc'] = $this->mantenimiento_model->getPrice($numero,2);
                $this->data['totalBac'] = $this->mantenimiento_model->getPrice($numero,3);
                $this->data['reembolsable'] = $this->mantenimiento_model->getReembolsable($numero);
                
                $this->load->view("pedidos/editar_pedido", $this->data);
            }
        }
		
		function editar_pedidoNuevo($numero){
			if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
         
                $this->load->model('mantenimiento_model');
                
                $this->data['registro'] = $this->mantenimiento_model->get_pedido_pro_hd($numero);
                $this->data['sucursales'] = $this->mantenimiento_model->getSucursales();
                $this->data['arrayNotify'] = $this->mantenimiento_model->getDatosVariables('pas_notify');
                $this->data['arrayPasteles'] = $this->mantenimiento_model->getPasteles2($numero,1);
                $this->data['numTortas'] = count($this->data['arrayPasteles']);
                $tortasCompletas = $this->mantenimiento_model->getTortasCompletas2($numero,1);
                $this->data['itemMenor'] = $this->mantenimiento_model->getTortaMenor($numero);
                $this->data['listSelect'] = $this->mantenimiento_model->get_pasteles_list_for_select($numero,1);
                $this->data['notasReqe'] = $this->mantenimiento_model->getNotasRequeridas('pas_notas');
                $this->data['arrayAccesoriosBases'] = $this->mantenimiento_model->get_Accesorios_Bases_Pedido($numero);
                $this->data['totalAcc'] = $this->mantenimiento_model->getPrice($numero,2);
                $this->data['totalBac'] = $this->mantenimiento_model->getPrice($numero,3);
                $this->data['namePosiciones'] = $this->mantenimiento_model->getNameOptionsCK(9);
                $this->data['nameFormas'] = $this->mantenimiento_model->getNameOptionsCK(10);
                $this->data['nameRellenos'] = $this->mantenimiento_model->getNameOptionsCK(13);
                $this->data['nameSabores'] = $this->mantenimiento_model->getNameOptionsCK(11);
                $this->data['nameBanos'] = $this->mantenimiento_model->getNameOptionsCK(12);
                $this->data['nameCoberturas'] = $this->mantenimiento_model->getNameOptionsCK(14);
				$this->data['nameColores'] = $this->mantenimiento_model->getNameOptionsCK(15);
                $this->data['nameAccesorios'] = $this->mantenimiento_model->getNameOptionsCK(1);
                $this->data['nameBases'] = $this->mantenimiento_model->getNameOptionsCK(2);
                $this->data['reembolsable'] = $this->mantenimiento_model->getReembolsable($numero);
                
				$this->load->view("pedidos/pastelesencargo_editar", $this->data);
            }
        }

        function getFilterTiposComponentes(){
            $idtipo = $this->input->post('idcomponente');
            $filter = $this->input->post('grupo');
            $this->load->model('mantenimiento_model');
            $array = $this->mantenimiento_model->getFilterOptionsCK($idtipo, $filter);
            echo json_encode($array);
        }
        
        function actualizarDetallePedido(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numPedido = $this->input->post('numPedido');
                $fecha = date_format(date_create($this->input->post('fecha')), 'Y-m-d');
                $hora = $this->input->post('hora');
                $lugar = $this->input->post('lugar');
                $sucurentrega = $this->input->post('sucurentrega');
                $idsucurentrega = $this->input->post('idsucurentrega');
                $preguntar = $this->input->post('preguntar');
                $telefono = $this->input->post('telefono');
                $direc = $this->input->post('direc');
                $whodidit = $this->session->userdata('iduser');
                
                $this->load->model('mantenimiento_model');
                
                if($lugar == 1){
                    if($sucurentrega == ""){
                        $error = "FALSE1";
                        echo json_encode($error);
                    }else{
                        $SQLResult = $this->mantenimiento_model->updateDetallePedido($numPedido, $fecha, $hora, $lugar, $sucurentrega, $idsucurentrega, "", "", "", $whodidit);
                        echo json_encode($SQLResult);
                    }
                }elseif($lugar == 2){
                    if($preguntar == "" || $telefono == "" || $direc == ""){
                        $error = "FALSE2";
                        echo json_encode($error);
                    }else{
                        $SQLResult = $this->mantenimiento_model->updateDetallePedido($numPedido, $fecha, $hora, $lugar, "", "", $preguntar, $telefono, $direc, $whodidit);
                        echo json_encode($SQLResult);
                    }
                }else{
                    $error = "FALSE3";
                    echo json_encode($error);
                }
            }
        }
		
		function actualizarDetallePedido_Nuevo(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numPedido = $this->input->post('numPedido');
                $fecha = $this->input->post('fecha');
                $hora = $this->input->post('hora');
                $lugar = $this->input->post('lugar');
                $sucurentrega = $this->input->post('sucurentrega');
                $idsucurentrega = $this->input->post('idsucurentrega');
                $preguntar = $this->input->post('preguntar');
                $telefono = $this->input->post('telefono');
                $direc = $this->input->post('direc');
                $whodidit = $this->session->userdata('iduser');
                
                $this->load->model('mantenimiento_model');
                
                if($lugar == 1){
                    if($sucurentrega == ""){
                        $error = "FALSE1";
                        echo json_encode($error);
                    }else{
                        $SQLResult = $this->mantenimiento_model->updateDetallePedido($numPedido, $fecha, $hora, $lugar, $sucurentrega, $idsucurentrega, "", "", "", $whodidit);
                        echo json_encode($SQLResult);
                    }
                }elseif($lugar == 2){
                    if($preguntar == "" || $telefono == "" || $direc == ""){
                        $error = "FALSE2";
                        echo json_encode($error);
                    }else{
                        $SQLResult = $this->mantenimiento_model->updateDetallePedido($numPedido, $fecha, $hora, $lugar, "", "", $preguntar, $telefono, $direc, $whodidit);
                        echo json_encode($SQLResult);
                    }
                }else{
                    $error = "FALSE3";
                    echo json_encode($error);
                }
            }
        }
        
        function obtenerDatos(){
            $numPedido = $this->input->post('numPedido');
            $this->load->model('mantenimiento_model');
            $SQLResult = $this->mantenimiento_model->getDatosPed($numPedido);
            echo json_encode($SQLResult);
        }
        
        function actualizarpedido(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numPedido = $this->input->post('numPedido');
                $cliphone = $this->input->post('cliphone');
                $cliname = $this->input->post('cliname');
                $idworker = $this->input->post('vendedor');
                $origen = $this->input->post('origen');
                $cliname = strtoupper($cliname);
                $cliemail = $this->input->post('cliemail');
                $cliphone1 = $this->input->post('cliphone1');
                $devnotes = $this->input->post('devnotes');
                $cktortas = $this->input->post('cktortas');
                $ckslices = $this->input->post('ckslices');
                
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('mantenimiento_model');
                $this->mantenimiento_model->actualizarpro_hd($numPedido, $cliphone,$cliname,$cliphone1,$cliemail,$devnotes,$cktortas,$ckslices,$idworker,$origen);
                $this->mantenimiento_model->updateValPastelByPorcion($numPedido, $ckslices);
                
                redirect('ppasteles/editar_pedido/'.$numPedido);
            }
        }
        
        function actualizarSolicitudPedido(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numPedido = $this->input->post('numPedido');
                $cliphone = $this->input->post('cliphone');
                $cliname = $this->input->post('cliname');
                $cliname = strtoupper($cliname);
                $cliemail = $this->input->post('cliemail');
                $cliphone1 = $this->input->post('cliphone1');
                $devnotes = $this->input->post('devnotes');
                $cktortas = $this->input->post('cktortas');
                $ckslices = $this->input->post('ckslices');
                $idworker = $this->input->post('vendedor');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('mantenimiento_model');
                $this->load->model('produccion_model');
                $this->mantenimiento_model->actualizarpro_hd($numPedido, $cliphone,$cliname,$cliphone1,$cliemail,$devnotes,$cktortas,$ckslices,$idworker,3);
                $result = $this->produccion_model->setSolitCambio($numPedido,$this->session->userdata('idrec_solit'));
                
                if($result == 1){
                    $savedSolit = array(
                        'savedSolit' => 1
                    );
                }
                $this->session->set_userdata($savedSolit);
                redirect('ppasteles/vercontrolproduccion/'.$this->session->userdata('iddApp'));
				$estatusCambio = array(
                    'estatusCambio' => 0,
                    'idrec_solit' => "",
                    'savedSolit' => 0
                );
                $this->session->set_userdata($estatusCambio);
            }
        }
        
        function saveDataTorta(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $tipopro = 1;
                $numero = $this->input->post('numOrd');
                $itemline = $this->input->post('itmLine');
                $notas = $this->input->post('detDecoracion');
                $ck_shape = $this->input->post('idForr');
                $ck_flavor = $this->input->post('idSab');
                $ck_bath = $this->input->post('idBan');
                $ck_filling = $this->input->post('idRel');
                $ck_covering = $this->input->post('idCob');
                $ck_color = $this->input->post('idCol');
                $posicion = $this->input->post('idPos');
                
                $tx_position = $this->input->post('namePos');
                $tx_shape = $this->input->post('nameForr');
                $tx_flavor = $this->input->post('nameSab');
                $tx_bath = $this->input->post('nameBan');
                $tx_filling = $this->input->post('nameRel');
                $tx_covering = $this->input->post('nameCob');
                $tx_color = $this->input->post('nameCol');
                
                $this->load->model('mantenimiento_model');
                $resultado = $this->mantenimiento_model->editar_pro_dt($numero,$tipopro,$itemline,$notas,$ck_shape,$ck_flavor,$ck_bath,$ck_filling,$ck_covering,$ck_color,$posicion,$tx_position,$tx_shape,$tx_flavor,$tx_bath,$tx_filling,$tx_covering,$tx_color);

                //Elaboración de proceso de verificación del completado de las tortas ordenadas...
                
                $complete = $this->mantenimiento_model->getCompleteCake($tipopro, $numero);
                
                /*--------------------------------------------------------------------------------*/
                
                echo json_encode($complete);
            }
        }
        
        function verifyComplete(){
            $tipopro = 1;
            $numero = $this->input->post('numOrd');
            $this->load->model('mantenimiento_model');
            $complete = $this->mantenimiento_model->getCompleteCake($tipopro, $numero);
            echo json_encode($complete);
        }
        
        function getInfTorta(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numOrd');
                $itemLn = $this->input->post('itemLine');
                
                $this->load->model('mantenimiento_model');
                $dataCake = $this->mantenimiento_model->getDataTrt($numero, $itemLn);
                
                echo json_encode($dataCake);
            }
        }
        
        function getInfTortaTotal(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numOrd');
                
                $this->load->model('mantenimiento_model');
                $dataCake = $this->mantenimiento_model->getDataTrtTotal($numero);
                
                echo json_encode($dataCake);
            }
        }
        
        function equalizeTorta(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numOrd');
                $itemLnCake = $this->input->post('numCake');
                $cakesToCopy = $this->input->post('registr');
                
                $this->load->model('mantenimiento_model');
                $dataCake = $this->mantenimiento_model->applyEqualize($numero, $itemLnCake, $cakesToCopy);
                
                echo json_encode($dataCake);
            }
        }
        
        function deleteTorta(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numOrd');
                $itemLnCake = $this->input->post('numCake');
                
                $this->load->model('mantenimiento_model');
                $dataCake = $this->mantenimiento_model->deleteCakee($numero, $itemLnCake);
                
                echo json_encode($dataCake);
            }
        }
        
        function insertTorta(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numOrd');
                
                $this->load->model('mantenimiento_model');
                $dataCake = $this->mantenimiento_model->insertCakee($numero);
                echo json_encode($dataCake);
            }
        }
        
        function getGrupCakes(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $nameGrup = $this->input->post('nameGrup');
                
                $this->load->model('mantenimiento_model');
                $dataCake = $this->mantenimiento_model->getListGrupCakes($nameGrup, 40);
                echo json_encode($dataCake);
            }
        }
        
        function CakePorPages(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $nameGrup = $this->input->post('nameGrup');
                $page = $this->input->post('page');
                
                $this->load->model('mantenimiento_model');
                $dataCake = $this->mantenimiento_model->getListGroupPages($page, $nameGrup, 40);
                echo json_encode($dataCake);
            }
        }
        
        function menuCakesPages(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $nameGrup = $this->input->post('nameGrup');
                $page = $this->input->post('page');
                
                $this->load->model('mantenimiento_model');
                $dataCake = $this->mantenimiento_model->getMenuGrupCakes($page, $nameGrup, 40);
                echo json_encode($dataCake);
            }
        }
        
        function textsDedicatorias(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                
                $dataTxt = $this->mantenimiento_model->getOptionsCK_Mensajes(16);
                echo json_encode($dataTxt);
            }
        }
        
        function posicionDedicatorias(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                
                $dataTxt = $this->mantenimiento_model->getOptionsCK_Posicion(16);
                echo json_encode($dataTxt);
            }
        }
        
        function grupoCatalogCakes(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                
                $dataGrup = $this->mantenimiento_model->getGrupCakes(40);
                echo json_encode($dataGrup);
            }
        }
        
        function setImgDedicatorias(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $upload_folder = "img_cuentas/".$this->session->userdata('diraccount');
                
				$nombre_archivo = $_FILES['imagen1']['name'];
				if(file_exists($nombre_archivo)){
					$tmp_archivo  = $_FILES['imagen1']['tmp_name'];
					$archivador = $upload_folder.'/'.$nombre_archivo;
					move_uploaded_file($tmp_archivo, $archivador);	
				}
                
                $nombre_archivo2 = $_FILES['imagen2']['name'];
                if(file_exists($nombre_archivo2)){
					$tmp_archivo2  = $_FILES['imagen2']['tmp_name'];
					$archivador2 = $upload_folder.'/'.$nombre_archivo2;
					move_uploaded_file($tmp_archivo2, $archivador2);
				}
                
				$nombre_archivo3 = $_FILES['imagen3']['name'];
                if(file_exists($nombre_archivo3)){
					$tmp_archivo3  = $_FILES['imagen3']['tmp_name'];
					$archivador3 = $upload_folder.'/'.$nombre_archivo3;
					move_uploaded_file($tmp_archivo3, $archivador3);
				}
                
				$nombre_archivo4 = $_FILES['imagen4']['name'];
                if(file_exists($nombre_archivo4)){
					$tmp_archivo4  = $_FILES['imagen4']['tmp_name'];
					$archivador4 = $upload_folder.'/'.$nombre_archivo4;
					move_uploaded_file($tmp_archivo4, $archivador4);
				}
                
                $return = TRUE;
				echo json_encode($return);
            }
        }
		
		function setImgDedicatorias2(){
			if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero_orden = $_POST['numPedDed'];
				$this->load->model('mantenimiento_model');

				if(isset($_FILES["files1"])){
                	$file = $_FILES["files1"];
					$nombre = $file["name"];
                  	
					if($nombre != ""){
                        $datosFoto1 = $_POST['imgONE'];
                        $formatoImagen1 = explode(".", $datosFoto1);
                        $nombre_imagen1 = 'imagen1_'.$numero_orden.'.'.$formatoImagen1[1];
                        
                    	$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
						$config['file_name'] = $nombre_imagen1;
						$config['over_write'] = "TRUE";
                       	$config['allowed_types'] = "gif|jpg|jpeg|png";
						$this->load->library('upload', $config);
						$this->upload->initialize($config);
                      	
						if($this->upload->do_upload('files1')){ 
                            // INICIO PRUEBAS REDIMENSIONAR IMAGEN
                            /* 

                            $image_data = $this->upload->data();
                            $config['image_library'] = 'gd2';
                            $config['source_image'] = $image_data['full_path']; //get original image
                            $config['maintain_ratio'] = TRUE;
                            $config['width'] = 300;
                            $config['height'] = 350;
                            $this->load->library('image_lib', $config);

                            $this->image_lib->resize();
                            //  FIN PRUEBAS
                            */
							$txtImg1 = $_POST['txtImg1'];
							$numOrd = $_POST['numPedDed'];
							$this->mantenimiento_model->insertDataDedicatoriaFotoUnica($numOrd, $nombre_imagen1, $txtImg1, 1);
						}else{
							echo $this->upload->display_errors();
						}
					}
				}
				
				if(isset($_FILES["files2"])){
                	$file = $_FILES["files2"];
					$nombre = $file["name"];
                  	
					if($nombre != ""){
                        $datosFoto2 = $_POST['imgTWO'];
                        $formatoImagen2 = explode(".", $datosFoto2);
                        $nombre_imagen2 = 'imagen2_'.$numero_orden.'.'.$formatoImagen2[1];
                        
                    	$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
						$config['file_name'] = $nombre_imagen2;
						$config['over_write'] = "TRUE";
                       	$config['allowed_types'] = "gif|jpg|jpeg|png";
						$this->load->library('upload', $config);
						$this->upload->initialize($config);
                      	
						if($this->upload->do_upload('files2')){ 
                            // INICIO PRUEBAS REDIMENSIONAR IMAGEN
                            /* 

                            $image_data = $this->upload->data();
                            $config['image_library'] = 'gd2';
                            $config['source_image'] = $image_data['full_path']; //get original image
                            $config['maintain_ratio'] = TRUE;
                            $config['width'] = 300;
                            $config['height'] = 350;
                            $this->load->library('image_lib', $config);

                            $this->image_lib->resize();
                            //  FIN PRUEBAS
                            */
							$txtImg2 = $_POST['txtImg2'];
							$numOrd = $_POST['numPedDed'];
							$this->mantenimiento_model->insertDataDedicatoriaFotoUnica($numOrd, $nombre_imagen2, $txtImg2, 2);
						}else{
							echo $this->upload->display_errors();
						}
					}
				}
				
				if(isset($_FILES["files3"])){
                	$file = $_FILES["files3"];
					$nombre = $file["name"];
                  	
					if($nombre != ""){
                        $datosFoto3 = $_POST['imgTHREE'];
                        $formatoImagen3 = explode(".", $datosFoto3);
                        $nombre_imagen3 = 'imagen3_'.$numero_orden.'.'.$formatoImagen3[1];
                        
                    	$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
						$config['file_name'] = $nombre_imagen3;
						$config['over_write'] = "TRUE";
                       	$config['allowed_types'] = "gif|jpg|jpeg|png";
						$this->load->library('upload', $config);
						$this->upload->initialize($config);
                      	
						if($this->upload->do_upload('files3')){ 
                            // INICIO PRUEBAS REDIMENSIONAR IMAGEN
                            /* 

                            $image_data = $this->upload->data();
                            $config['image_library'] = 'gd2';
                            $config['source_image'] = $image_data['full_path']; //get original image
                            $config['maintain_ratio'] = TRUE;
                            $config['width'] = 300;
                            $config['height'] = 350;
                            $this->load->library('image_lib', $config);

                            $this->image_lib->resize();
                            //  FIN PRUEBAS
                            */
							$txtImg3 = $_POST['txtImg3'];
							$numOrd = $_POST['numPedDed'];
							$this->mantenimiento_model->insertDataDedicatoriaFotoUnica($numOrd, $nombre_imagen3, $txtImg3, 3);
						}else{
							echo $this->upload->display_errors();
						}
					}
				}
				
				if(isset($_FILES["files4"])){
                	$file = $_FILES["files4"];
					$nombre = $file["name"];
                  	
					if($nombre != ""){
                        $datosFoto4 = $_POST['imgFOUR'];
                        $formatoImagen4 = explode(".", $datosFoto4);
                        $nombre_imagen4 = 'imagen4_'.$numero_orden.'.'.$formatoImagen4[1];
                        
                    	$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
						$config['file_name'] = $nombre_imagen4;
						$config['over_write'] = "TRUE";
                       	$config['allowed_types'] = "gif|jpg|jpeg|png";
						$this->load->library('upload', $config);
						$this->upload->initialize($config);
                      	
						if($this->upload->do_upload('files4')){ 
                            // INICIO PRUEBAS REDIMENSIONAR IMAGEN 
                            /*

                            $image_data = $this->upload->data();
                            $config['image_library'] = 'gd2';
                            $config['source_image'] = $image_data['full_path']; //get original image
                            $config['maintain_ratio'] = TRUE;
                            $config['width'] = 300;
                            $config['height'] = 350;
                            $this->load->library('image_lib', $config);

                            $this->image_lib->resize();
                            //  FIN PRUEBAS
                            */
							$txtImg4 = $_POST['txtImg4'];
							$numOrd = $_POST['numPedDed'];
							$this->mantenimiento_model->insertDataDedicatoriaFotoUnica($numOrd, $nombre_imagen4, $txtImg4, 4);
						}else{
							echo $this->upload->display_errors();
						}
					}
				}
				
				echo json_encode(true);
			}
		}
        
        function setTxtDedicatorias(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                     
                $IMG1 = $this->input->post('nameImg1');
                $IMG2 = $this->input->post('nameImg2');
                $IMG3 = $this->input->post('nameImg3');
                $IMG4 = $this->input->post('nameImg4');
                $txtImg1 = $this->input->post('txtImg1');
                $txtImg2 = $this->input->post('txtImg2');
                $txtImg3 = $this->input->post('txtImg3');
                $txtImg4 = $this->input->post('txtImg4');
                $nameCatalog = $this->input->post('nameCatalog');
                $txtDedicatoria = $this->input->post('txtDedicatoria');
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $rst = $this->mantenimiento_model->insertDataDedicatorias($numOrd, $IMG1, $IMG2, $IMG3, $IMG4, $nameCatalog, $txtDedicatoria, $txtImg1, $txtImg2, $txtImg3, $txtImg4);
                echo json_encode($rst);
            }
        }
		
		function setTxtDedicatorias2(){
			if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $nameCatalog = $this->input->post('nameCatalog');
                $notasCatalogo = $this->input->post('notasCatalogo');
                $txtDedicatoria = $this->input->post('txtDedicatoria');
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $rst = $this->mantenimiento_model->insertDataDedicatoriasOnly($numOrd, $nameCatalog, $txtDedicatoria, $notasCatalogo);
                echo json_encode($rst);
            }
		}
		
		function setTxtDedicatoriasMod(){
			if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $nameCatalog = $this->input->post('nameCatalog');
                $notasCatalogo = $this->input->post('notasCatalogo');
                $txtDedicatoria = $this->input->post('txtDedicatoria');
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $rst = $this->mantenimiento_model->insertDataDedicatoriasModificacion($numOrd, $nameCatalog, $txtDedicatoria, $notasCatalogo);
                echo json_encode($rst);
            }
		}
        
        function getDataDedicatoria(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                
                $rst = $this->mantenimiento_model->getDatosPed($numero);
                $rst2 = $this->mantenimiento_model->getDatosFotos($numero);
                $array = array(
                    'dataFotos' => $rst2,
                    'dataDedicatoria' => $rst
                );
                echo json_encode($array);
            }    
        }
        
        function getAllCatalog(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $rst = $this->mantenimiento_model->getAllCatalog(40);
                echo json_encode($rst);
            }  
        }
        
        function getAccesoriosCakes(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getOptionsCK(1);
                $result2 = $this->mantenimiento_model->getGroupOptionsCK(1);
                $array = array(
                    'grupos' => $result2,
                    'accesorios' => $result
                );
                echo json_encode($array);
            }  
        }
        
        function setAccesorios(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numOrd = $this->input->post('numOrd');
                $idcmpt = $this->input->post('idcmpt');
                $cantidad = $this->input->post('cantidad');
                $price = $this->input->post('price');
                $notas = $this->input->post('notas');
                
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->insertAccesorioCake($numOrd, $idcmpt, $cantidad, $price, 2, '9904', $notas);
                echo json_encode($result);
            }  
        }
        
        function getDataAccCakes(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getDataAccCakes($numOrd, 2);
                echo json_encode($result);
            }  
        }
        
        function deleteAccCake(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $itmLine = $this->input->post('itmLine');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->deleteAcake($numOrd, $itmLine, 2);
                echo json_encode($result);
            } 
        }
        
        function sumTotAcc(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getsumacake($numOrd, 2);
                echo json_encode($result);
            }
        }
        
        function saveAcomplete(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->saveAcomplete($numOrd);
                echo json_encode($result);
            }
        }
        
        function getDataBasesCakes(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getDataBasesCakes($numOrd, 3);
                echo json_encode($result);
            }  
        }
        
        function deleteBasesCake(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $itmLine = $this->input->post('itmLine');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->deleteBcake($numOrd, $itmLine, 3);
                echo json_encode($result);
            } 
        }
        
        function getBasesCakes(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getOptionsCK(2);
                $result2 = $this->mantenimiento_model->getGroupOptionsCK(2);
                $array = array(
                    'grupos' => $result2,
                    'bases' => $result
                );
                echo json_encode($array);
            }  
        }
        
        function setBases(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numOrd = $this->input->post('numOrd');
                $idcmpt = $this->input->post('idcmpt');
                $cantidad = $this->input->post('cantidad');
                $price = $this->input->post('price');
                $notas = $this->input->post('notas');
                $baseRefun = $this->input->post('baseRefun');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->insertBasesCake($numOrd, $idcmpt, $cantidad, $price, 3, '9904', $notas, $baseRefun);
                echo json_encode($result);
            }  
        }
        
        function sumTotBases(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getsumacake($numOrd, 3);
                echo json_encode($result);
            }
        }
        
        function saveBcomplete(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->saveBcomplete($numOrd);
                echo json_encode($result);
            }
        }
        
        function sumaDeTotalesAccesorios(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getSumaTotalesACakes($numOrd, 2);
                echo json_encode($result);
            }
        }
        
        function sumaDeTotalesBases(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getSumaTotalesBCakes($numOrd, 3);
                echo json_encode($result);
            }
        }
        
        function sumaDeTotalesRefun(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getSumaTotalesRefunCakes($numOrd, 3);
                echo json_encode($result);
            }
        }
        
        function setPricePastel(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $valPastel = $this->input->post('valPastel');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->setPrecioCake($numOrd, $valPastel);
                echo json_encode($result);
            }
        }
        
        function setPriceEnvio(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $valEnvio = $this->input->post('valEnvio');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->setPrecioEnvio($numOrd, $valEnvio);
                echo json_encode($result);
            }
        }
        
        function getInfoPriceCake(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getDatosPed($numOrd);
                echo json_encode($result);
            }
        }
        
        function setPriceAnticipo(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $valAnt = $this->input->post('valAnt');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->setPrecioAnticipo($numOrd, $valAnt);
                echo json_encode($result);
            }
        }
        
        function confirmarOrden(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $valVenta = $this->input->post('valVenta');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->confirmarOrdenPedido($numOrd, $valVenta);
                echo json_encode($result);
            }
        }
        
        function cambiarValorTotalPastel(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numero = $this->input->post('numero');
                $valorventa = $this->input->post('valorVenta');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->cambiarValorTotalPastel($numero, $valorventa);
                echo json_encode($result);
            }
        }
        
        function confirmar2Orden(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $valVenta = $this->input->post('valVenta');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->confirmarOrden2Pedido($numOrd, $valVenta);
                echo json_encode($result);
            }
        }
        
        function datosConfirmOrden(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->getDatosPed($numOrd);
                echo json_encode($result);
            }
        }
                
        function eliminarPedido(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->deletePedido($numOrd);
                echo json_encode($result);
            }
        }
        
        function copiarPedido(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{ 
                $numOrd = $this->input->post('numOrd');
                $numCopy = $this->input->post('cantCopy');
                $this->load->model('mantenimiento_model');
                $result = $this->mantenimiento_model->duplicatePedido($numOrd, $numCopy);
                echo json_encode($result);
            }
        }
        
        function ordenesConfirmadas(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $idcentro = $this->session->userdata('idcentrouser');
                $result = $this->mantenimiento_model->getPedidosConfirmados($idcentro, 1);
                echo json_encode($result);
            }
        }
        
        function getPedidosFechas(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $idcentro = $this->session->userdata('idcentrouser');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $informacion = $this->mantenimiento_model->getPedidosFechas($idcentro, 1, $fechaini, $fechafin);

                #F10
                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        switch($info->estado){
                            case 0:
                                $estado = "En Proceso";
                            break;
                            case 1:
                                $estado = "Confirmado";
                            break;
                            case 3:
                                $estado = "Producido";
                            break;
                            case 4:
                                $estado = "En Ruta";
                            break;
                            case 8:
                                $estado = "Entregado";
                            break;
                            case 9:
                                $estado = "Anulado";
                            break;
                        }

                        $array[$i] = array(
                            "numero" => $info->numero,
                            "date" => $info->date,
                            "dev_date" => $info->dev_date,
                            "cli_name" => $info->cli_name,
                            "dev_direc" => $info->dev_direc,
                            "origen" => $info->origen,
                            "cli_phone" => $info->cli_phone,
                            "vendedor" => $info->vendedor,
                            "val_venta" => $info->val_venta,
                            "estado" => $estado
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function generarSolicitudCambio(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $numPedido = $this->input->post('numPedido');
                $detail = $this->input->post('detail');
                $Result = $this->mantenimiento_model->setSolicitudCambio($numPedido, $detail, 1);
                echo json_encode($Result);
            }  
        }
        
        function generarSolicitudAnulacion(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $numPedido = $this->input->post('numPedido');
                $detail = $this->input->post('detail');
                $Result = $this->mantenimiento_model->setSolicitudAnulacion($numPedido, $detail, 2);
                echo json_encode($Result);
            }  
        }
        
        function ordenesConfirmadasxFecha(){
            $this->load->model('mantenimiento_model');
            $idcentro = $this->session->userdata('idcentrouser');
            $fecha = $this->input->post('fechaPedido');
            $result = $this->mantenimiento_model->getPedidosConfirmadosxFecha($idcentro, 1, $fecha);
            echo json_encode($result);
        }
        
        function historyChangesOrden(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $numPedido = $this->input->post('numPedido');
                $Result = $this->mantenimiento_model->getHistoryPedido($numPedido);
                echo json_encode($Result);
            }  
        }
        
        function getListadoComprobantesPago(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numPedido = $this->input->post('numPedido');
                
                $this->load->model('mantenimiento_model');
                $array = $this->mantenimiento_model->getListadoComprobantesPago($numPedido, 6);
                
                echo json_encode($array);
            }  
        }

        function uploadComprobantePago(){
			if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero_orden = $_POST['numeroPedido'];
                $formapago    = $_POST['formaComprobante'];
                $valor        = $_POST['montoComprobante'];
				$this->load->model('mantenimiento_model');

				if(isset($_FILES["files4"])){
                	$file = $_FILES["files4"];
					$nombre = $file["name"];
                  	
					if($nombre != ""){
                        $datosFoto1 = $_POST['imgFOUR'];
                        $formatoImagen1 = explode(".", $datosFoto1);
                        $nombre_imagen1 = 'abonoComprobante'.rand().'.'.$formatoImagen1[1];
                        
                    	$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
						$config['file_name'] = $nombre_imagen1;
						$config['over_write'] = "TRUE";
                       	$config['allowed_types'] = "gif|jpg|jpeg|png";
						$this->load->library('upload', $config);
						$this->upload->initialize($config);
                      	
						if($this->upload->do_upload('files4')){ 
							$this->mantenimiento_model->insertComprobantePago($numero_orden, $formapago, $valor, $nombre_imagen1);
						}else{
							echo json_encode(false);
						}
					}
				}

				echo json_encode(true);
			}
		}

        function deleteComprobantePago(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numero');
                $itemline = $this->input->post('itemline');
                $tipopro = $this->input->post('tipopro');
                $valor = $this->input->post('valor');

				$this->load->model('mantenimiento_model');
                $array = $this->mantenimiento_model->deleteComprobantePago($numero, $itemline, $tipopro, $valor);

                echo json_encode($array);
            }
        }
        
        function verDetailOrdenOld(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numPedido');
                $this->load->model('mantenimiento_model');
                $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

            if(is_array($products) && $products!=false){
                $sucursal = strtoupper($products['descrip']);
                $pedido = $products['numero'];
                $cli_name = $products['cli_name'];
                $cli_phone = $products['cli_phone'];
                $date = date_format(date_create($products['date']),'d/m/Y');
                $dev_date2 = ucwords($products['dev_date2']);
                $dev_time = date("g:i a", strtotime($products['dev_time']));
                $tfecha = ucwords($products['tfecha']);
                $val_venta = $products['val_venta'];
                $val_anti = $products['val_anti'];
                $val_refund = $products['val_refund'];
                $tpastel = $products['val_pastel'];
                $taccesorios = $products['val_acc'];
                $tbases = $products['val_bases'];
                $tenvio = $products['val_envio'];

                $cli_email = $products['cli_email'];
                $dev_place = $products['dev_place'];
                $notas_obser = $products['notas'];
                $dev_notes = $products['dev_notes'];

                $imagen = $products['pastel_fotos'];
                $catreference = $products['catreference'];
                $dedicamsg = $products['dedicamsg'];
                
                $dev_contact = $products['dev_contact'];
                $dev_phone = $products['dev_phone'];

                $lugar = "";
                $tlugar = "";
                if($dev_place==1){
                    $lugar = $products['dev_direc'];
                    $tlugar = $products['dev_direc'];
                }elseif($dev_place==2){
                    $lugar = $products['dev_direc'];
                    $tlugar = "DOMICILIO";
                }elseif ($dev_place==3) {
                    $lugar = "Recoger en Producción";
                }

                $cktortas = $products['ck_tortas'];
                $ckslices = $products['porciones'];

                $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                $tamano = strlen($pedido);
                $codbar = "";
                
                if($tamano==1){
                    $codbar = "00000".$pedido;
                }elseif($tamano==2){
                    $codbar = "0000".$pedido;
                }elseif($tamano==3){
                    $codbar = "000".$pedido;
                }elseif($tamano==4){
                    $codbar = "00".$pedido;
                }elseif($tamano==5){
                    $codbar = "0".$pedido;
                }elseif($tamano==6){
                    $codbar = $pedido;
                }
            }else{
                redirect('pedidos_clientes/pasteles_al_gusto/');
            }

            $estructura = '<table style="width:100%;">
                            <tr>
                                <td></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                            </tr>
                          </table>';


            $estructura .= '<br><table style="width:100%;">
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                            /*if(isset($imagen) and $imagen!=""){
                                $estructura .= '<img style="min-width: 25%; max-height: 300px;" src="data:image/png;base64,'.base64_encode($imagen).'">';
                            }*/

                                
            $estructura .='     </td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Orden N°</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E; width:10%;">Fecha</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Sucursal</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$pedido.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000; width:10%;">'.$date.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$sucursal.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Nombre del cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Telefono</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Correo</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$cli_name.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$cli_phone.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$cli_email.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Fecha de entrega</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E; width:10%;">Hora</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$dev_date2.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000; width:10%;">'.$dev_time.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$lugar.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Contacto</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Telefono</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$dev_contact.'</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$dev_phone.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Tipo de documento de venta</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Número de Porciones</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$dev_notes.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000; width:10%;">'.$cktortas.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$ckslices.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Diseño</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Dedicatoria</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$catreference.'</td>
                                <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 12px; color:#000000;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';

            if($arrayPasteles!=false){
                $i=1;
                $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Tortas </td>
                                        <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:94.5%;"></td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                    </tr>';
                foreach($arrayPasteles as $key => $value){
                    $estructura .= '
                            <tr>
                                <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                            </tr>
                            <tr>
                                <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                            </tr>';
                    $i++;
                }
                $estructura .= '</table>';
            }

            if($arrayAccesorios!=false){
                $i=0;
                $i = count($arrayAccesorios);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                    $i = count($arrayAccesorios);
                    foreach($arrayAccesorios as $key => $value){
                            
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';
            }  

            if($arrayBases!=false){
                $i=0;
                $i = count($arrayBases);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayBases) and $arrayBases!=false){
                    $i = count($arrayBases);
                    foreach($arrayBases as $key => $value){
                        
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';

            }    

            $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';
                
                echo json_encode($estructura);
            }
        }

        function verDetailOrden() {
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('numPedido');

                $this->load->model('mantenimiento_model');
                $products = $this->mantenimiento_model->getDataCake_for_ticket($trannum);
                
                if(is_array($products) && $products!=false){
                    $pedido = $products['numero'];
                    $estado = $products['estado'];
                    $cli_name = $products['cli_name'];
                    $name_vendedor = $products['name_vendedor'];
                    $cli_phone = $products['cli_phone'];
                    $dev_date2 = ucwords($products['dev_date2']);
                    $dev_time = date("g:i a", strtotime($products['dev_time']));
                    
                    $val_venta = $products['val_venta'];
                    $val_anti = $products['val_anti'];
                    $val_pastel = $products['val_pastel'];
                    $val_envio = $products['val_envio'];

                    $estadoPago = ($val_anti < $val_venta) ? 'Pendiente' : 'Pagado';

                    $origenPedido = $products['origenPedido'];
                    $dev_place = $products['dev_place'];
                    $notas_obser = $products['notas'];
                    $dev_notes = $products['dev_notes'];

                    $catreference = $products['catreference'];
                    $dedicamsg = $products['dedicamsg'];

                    $lugar = "";
                    
                    if($dev_place==1){
                        $lugar = $products['dev_direc'];
                    }elseif($dev_place==2){
                        $lugar = $products['dev_direc'];
                    }elseif ($dev_place==3){
                        $lugar = "Hugo";
                    }

                    $cktortas = $products['ck_tortas'];
                    $ckslices = $products['porciones'];
                    
                    $arrayPasteles = $this->mantenimiento_model->getPasteles($trannum, 1);
                    $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($trannum, 2);
                    $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($trannum, 3);

                }
                
                if($catreference != ""){
                    $fotoCatalogo = $this->mantenimiento_model->getNameImagenPastelCatalogo($catreference);
                }

                switch ($estado) {
                    case 1:
                        $nameEstado = "CONFIRMADO";
                        break;
                    case 2:
                        $nameEstado = "AGENDADO";
                        break;
                    case 3:
                        $nameEstado = "PRODUCIDO";
                        break;
                    case 4:
                        $nameEstado = "EN RUTA";
                        break;
                    case 8:
                        $nameEstado = "ENTREGADO";
                        break;
                    default:
                        break;
                }
                
                /*$estructura = '<body style="padding:10px;">
                <table style="width:100%;">
                    <tr>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;"><img id="imgLogo" width="150" height="100" src="'.$this->session->userdata('nameImgEmpresa').'" style="margin-top:0px;"></td>
                        <td></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 20px; color:#000; padding-right:15px; line-height:20px;">PEDIDO DE PASTEL<br>N°'.$pedido.'<br><strong style="font-size:15px;">'.$nameEstado.'</strong></td>
                    </tr>
                </table>';*/
                $contentHTML = '';

                // $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12">';
                //     $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold; text-align:right;">'.$nameEstado.'</h5>';
                // $contentHTML .= '</div>';

                $contentHTML .= '<div class="col-xs-12 col-sm-6 col-md-6" style="padding-right: 5px;">';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="background-color:#000; color:#FFF;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold; text-align:center; color:#FFF;">DATOS DEL CLIENTE</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px; margin-top:5px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;"><strong>N° de Orden:</strong> '.$trannum.'</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold;">Metodo de Pedido:</h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;">'.strtoupper($origenPedido).'</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold;">Nombre de Cliente:</h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;">'.strtoupper($cli_name).'</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold;">Teléfono:</h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;">'.$cli_phone.'</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold;">Fecha de Entrega:</h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;">'.$dev_date2.', '.$dev_time.'</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold;">Forma de Pago:</h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;">'.strtoupper($dev_notes).'</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;"><strong>Estado de Pago:</strong> ' . $estadoPago . '</h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;"></h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px; margin-top:10px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold;">Lugar de Entrega:</h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;">'.strtoupper($lugar).'</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold;">Atendido Por:</h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;">'.strtoupper($name_vendedor).'</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px; margin-top:10px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:14px; font-weight:bold;">Desgloce de Cobro:</h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:13px; text-align:right;">Valor del Pastel: <strong>$'.number_format(round($val_pastel, 2), 2, '.', ',').'</strong></h5>';

                        if($accesorios!=false){
                            foreach($accesorios as $key => $value){
                                $contentHTML .= '<h5 style="margin-bottom:0px; font-size:13px; text-align:right;">'.ucfirst(strtolower($value['descrip'])).': <strong>$'.str_pad(number_format(($value['price'] * $value['qty']), 2), 5, ' ', STR_PAD_LEFT).'</strong></h5>';
                            }
                        }
                        
                        if($bases != false){
                            foreach($bases as $key => $value){
                                $contentHTML .= '<h5 style="margin-bottom:0px; font-size:13px; text-align:right;">'.ucfirst(strtolower($value['descrip'])).': <strong>$'.str_pad(number_format(($value['price'] * $value['qty']), 2), 5, ' ', STR_PAD_LEFT).'</strong></h5>';
                            }
                        }

                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:13px; text-align:right;">Envió: <strong>$'.str_pad(number_format($val_envio, 2), 5, ' ', STR_PAD_LEFT).'</strong></h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; margin-top:10px; font-size:14px; font-weight:bold; text-align:right;">Total: $'.str_pad(number_format($val_venta, 2), 5, ' ', STR_PAD_LEFT).'</h5>';
                    $contentHTML .= '</div>';
                $contentHTML .= '</div>';
                $contentHTML .= '<div class="col-xs-12 col-sm-6 col-md-6" style="padding-left:  5px;">';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="background-color:#000; color:#FFF;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold; text-align:center; color:#FFF;">DATOS DEL PASTEL</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px; margin-top:5px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;"><strong>Tamaño:</strong> '.$cktortas.'-'.$ckslices.'</h5>';
                    $contentHTML .= '</div>';
                    $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px; margin-top:5px;">';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px; font-weight:bold;">Posición de la Dedicatoria:</h5>';
                        $contentHTML .= '<h5 style="margin-bottom:0px; font-size:12px;">'.$dedicamsg.'</h5>';
                    $contentHTML .= '</div>';

                if(isset($fotoCatalogo) and $fotoCatalogo!=""){
                    //$estructura .= '<td rowspan="14" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;"><img style="min-width: 25%; max-height: 300px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$fotoCatalogo.'"></td>';
                }
                                
                if($arrayPasteles!=false){
                    $i=1;
                    foreach($arrayPasteles as $key => $value){
                        $contentHTML .= '
                        <div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">
                            <h5 style="margin-bottom:0px; font-size:12px;">&nbsp;&nbsp;<strong>Forma de la Torta:</strong> '.$value['tx_shape'].'</h5>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">
                            <h5 style="margin-bottom:0px; font-size:12px;">&nbsp;&nbsp;<strong>Sabor de la Torta:</strong> '.$value['tx_flavor'].'</h5>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">
                            <h5 style="margin-bottom:0px; font-size:12px;">&nbsp;&nbsp;<strong>Baño/Remojo:</strong> '.$value['tx_bath'].'</h5>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">
                            <h5 style="margin-bottom:0px; font-size:12px;">&nbsp;&nbsp;<strong>Relleno:</strong> '.$value['tx_filling'].'</h5>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">
                            <h5 style="margin-bottom:0px; font-size:12px;">&nbsp;&nbsp;<strong>Cobertura:</strong> '.$value['tx_covering'].'</h5>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;">
                            <h5 style="margin-bottom:0px; font-size:12px;">&nbsp;&nbsp;<strong>Descripción del Pastel:</strong></h5>
                            <h5 style="margin-bottom:0px; font-size:12px;">&nbsp;&nbsp;'.ucwords($value['notas']).'</h5>
                        </div>';
                        $i++;
                    }
                }
                
                $contentHTML .= '</div>';                
                $contentHTML .= '<div class="col-xs-12 col-sm-12 col-md-12" style="padding:0px;"></div>';
                
                $datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 1);
                if ($datosimagen != false) {
                    $nombre_fichero = APPPATH . '../img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'];
                    if (file_exists($nombre_fichero)) {
                        $contentHTML .= '<div class="col-xs-12 col-sm-4 col-md-4" style="text-align:center;"><img style="min-width: 100%; max-width:100%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">'.$datosimagen['notas'].'</div>';
                    }
                }

                $datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 2);
                if ($datosimagen != false) {
                    $nombre_fichero = APPPATH . '../img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'];
                    if (file_exists($nombre_fichero)) {
                        $contentHTML .= '<div class="col-xs-12 col-sm-4 col-md-4" style="text-align:center;"><img style="min-width: 100%; max-width:100%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">'.$datosimagen['notas'].'</div>';
                    }
                }

                $datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 3);
                if ($datosimagen != false) {
                    $nombre_fichero = APPPATH . '../img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'];
                    if (file_exists($nombre_fichero)) {
                        $contentHTML .= '<div class="col-xs-12 col-sm-4 col-md-4" style="text-align:center;"><img style="min-width: 100%; max-width:100%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">'.$datosimagen['notas'].'</div>';
                    }
                }

                $datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 4);
                if ($datosimagen != false) {
                    $nombre_fichero = APPPATH . '../img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'];
                    if (file_exists($nombre_fichero)) {
                        $contentHTML .= '<div class="col-xs-12 col-sm-4 col-md-4" style="text-align:center;"><img style="min-width: 100%; max-width:100%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">'.$datosimagen['notas'].'</div>';
                    }
                }
                                
                echo json_encode($contentHTML);
            }
        }
        
        function verControlProduccion($idApp){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->data['calendarioPedidos'] = $this->mantenimiento_model->getPedidosAll(1);
                $this->load->view("pedidos/mantenimiento_controlproduccion",$this->data);
                $estatusCambio = array(
                    'estatusCambio' => 0,
                    'idrec_solit' => "",
                    'savedSolit' => 0
                );
                $this->session->set_userdata($estatusCambio);
            }   
        }
        
        function busquedaDeOrdenes($idApp){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->view("pedidos/mantenimiento_busqueda_ordenes");
            }   
        }
        
        function verControlProduccionUpdate($idApp){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('mantenimiento_model');
                $this->data['calendarioPedidos'] = $this->mantenimiento_model->getPedidosAll(1);
                
				$this->load->view("pedidos/pedidos_controlproduccion",$this->data);
                $estatusCambio = array(
                    'estatusCambio' => 0,
                    'idrec_solit' => "",
                    'savedSolit' => 0
                );
                $this->session->set_userdata($estatusCambio);
            }   
        }
        
        function allConfirmadasxFecha(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $fecha = $this->input->post('fechaPedido');
                $result = $this->mantenimiento_model->getAllPedidosConfirmadosxFecha(1, $fecha);
                echo json_encode($result);
            }
        }
        
        function allConfirmadasxDomicilio(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('mantenimiento_model');
                $fecha = $this->input->post('fechaPedido');
                $result = $this->mantenimiento_model->getAllPedidosConfirmadosxDomicilioa(1, $fecha);
                echo json_encode($result);
            }
        }
        
        function changePedidosToProducidos($fecha){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $QueryResult = $this->produccion_model->changeEstadoToProducidos($fecha, 1);
                if($QueryResult == 1){
                    redirect('ppasteles/verControlProduccion/'.$this->session->userdata('iddApp'));
                }
            }
        }
        
        function changePedidosToRuta($fecha){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $QueryResult = $this->produccion_model->changeEstadoToRuta($fecha, 1);
                if($QueryResult == 1){
                    redirect('ppasteles/verControlProduccion/'.$this->session->userdata('iddApp'));
                }
            }
        }
        
        function changePedidosToEntregados($fecha){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $QueryResult = $this->produccion_model->changeEstadoToEntregados($fecha, 1);
                if($QueryResult == 1){
                    redirect('ppasteles/verControlProduccion/'.$this->session->userdata('iddApp'));
                }
            }
        }
        
        function getSolicitudesToCambio(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $QueryResult = $this->produccion_model->getSolicitudesCambio();
                echo json_encode($QueryResult);
            }
        }
        
        function getAnulaciones(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $QueryResult = $this->produccion_model->getAnulaciones();
                echo json_encode($QueryResult);
            }
        }
        
        function searchOrdersClient(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $search = $this->input->post('search');
                
                $this->load->model('mantenimiento_model');
                $informacion = $this->mantenimiento_model->getSearchOrders($search);
                
                $i=0;
                $array = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "estado" => $info->estado,
                            "numero" => $info->numero,
                            "dev_date" => $info->dev_date,
                            "dev_date" => $info->dev_date,
                            "dev_time" => $info->dev_time,
                            "cli_name" => $info->cli_name,
                            "cli_phone" => $info->cli_phone,
                            "val_venta" => $info->val_venta * 1
                        );
                        
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function setAnulacionOrden(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $numero = $this->input->post('numero');
                $idrec = $this->input->post('idrec');
                $result = $this->produccion_model->anularOrden($numero, $idrec);
                echo json_encode($result);
            }
        }
        
        function solicitud_cambio($numero, $idrec){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
                    'namePage' => 'Solicitud de Cambio N°'.$numero
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('mantenimiento_model');
                
                $this->data['registro'] = $this->mantenimiento_model->get_pedido_pro_hd($numero);
                $this->data['sucursales'] = $this->mantenimiento_model->getSucursales();
                $this->data['arrayNotify'] = $this->mantenimiento_model->getDatosVariables('pas_notify');
				$this->data['vendedores'] = $this->mantenimiento_model->getListadoVendedores();
				
                $this->data['arrayPasteles'] = $this->mantenimiento_model->getPasteles2($numero,1);
                $this->data['numTortas'] = count($this->data['arrayPasteles']);
                $tortasCompletas = $this->mantenimiento_model->getTortasCompletas2($numero,1);
                $this->data['itemMenor'] = $this->mantenimiento_model->getTortaMenor($numero);
                
                $this->data['listSelect'] = $this->mantenimiento_model->get_pasteles_list_for_select($numero,1);
                
                $this->data['porcioneslist'] = $this->mantenimiento_model->getOptionsCK(8);
                $this->data['groupPos'] = $this->mantenimiento_model->getGroupOptionsCK(9);
                $this->data['posicioneslist'] = $this->mantenimiento_model->getOptionsCK(9);
                $this->data['namePosiciones'] = $this->mantenimiento_model->getNameOptionsCK(9);
                $this->data['groupForm'] = $this->mantenimiento_model->getGroupOptionsCK(10);
                $this->data['formaslist'] = $this->mantenimiento_model->getOptionsCK(10);
                $this->data['nameFormas'] = $this->mantenimiento_model->getNameOptionsCK(10);
                $this->data['groupRel'] = $this->mantenimiento_model->getGroupOptionsCK(13);
                $this->data['rellenoslist'] = $this->mantenimiento_model->getOptionsCK(13);
                $this->data['nameRellenos'] = $this->mantenimiento_model->getNameOptionsCK(13);
                $this->data['groupSab'] = $this->mantenimiento_model->getGroupOptionsCK(11);
                $this->data['saboreslist'] = $this->mantenimiento_model->getOptionsCK(11);
                $this->data['nameSabores'] = $this->mantenimiento_model->getNameOptionsCK(11);
                $this->data['groupBan'] = $this->mantenimiento_model->getGroupOptionsCK(12);
                $this->data['banoslist'] = $this->mantenimiento_model->getOptionsCK(12);
                $this->data['nameBanos'] = $this->mantenimiento_model->getNameOptionsCK(12);
                $this->data['groupCob'] = $this->mantenimiento_model->getGroupOptionsCK(14);
                $this->data['coberturaslist'] = $this->mantenimiento_model->getOptionsCK(14);
                $this->data['nameCoberturas'] = $this->mantenimiento_model->getNameOptionsCK(14);
                $this->data['groupCol'] = $this->mantenimiento_model->getGroupOptionsCK(15);
                $this->data['coloreslist'] = $this->mantenimiento_model->getOptionsCK(15);
                $this->data['nameColores'] = $this->mantenimiento_model->getNameOptionsCK(15);
                $this->data['nameAccesorios'] = $this->mantenimiento_model->getNameOptionsCK(1);
                $this->data['nameBases'] = $this->mantenimiento_model->getNameOptionsCK(2);
                $this->data['notasReqe'] = $this->mantenimiento_model->getNotasRequeridas('pas_notas');
                $this->data['diasminimopedidos'] = $this->mantenimiento_model->getMinimoDiasPedidos('pas_pdias');
                $this->data['datosimpresoras'] = $this->mantenimiento_model->getInformacionImpresoras('pas_idprinters');
                $this->data['numeroPedidoPastel'] = $numero;
                
                $this->data['arrayAccesoriosBases'] = $this->mantenimiento_model->get_Accesorios_Bases_Pedido($numero);
                $this->data['totalAcc'] = $this->mantenimiento_model->getPrice($numero,2);
                $this->data['totalBac'] = $this->mantenimiento_model->getPrice($numero,3);
                $this->data['reembolsable'] = $this->mantenimiento_model->getReembolsable($numero);
                $this->data['mensajeCambio'] = $this->mantenimiento_model->getSolicitudDeCambio($idrec);
                
                $estatusCambio = array(
                    'estatusCambio' => 1,
                    'idrec_solit' => $idrec,
                    'savedSolit' => 0
                );
                $this->session->set_userdata($estatusCambio);
                
                $this->load->view("pedidos/solicitud_cambio", $this->data);
            }
        }
        
        function getEstatusOrden(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $numero = $this->input->post('numero');
                $result = $this->produccion_model->getEstadoOrden($numero);
                echo json_encode($result);
            }
        }
        
        function savedSolitCambio($numero){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('produccion_model');
                $result = $this->produccion_model->setSolitCambio($numero,$this->session->userdata('idrec_solit'));
                if($result == 1){
                    $savedSolit = array(
                        'savedSolit' => 1
                    );
                }
                $this->session->set_userdata($savedSolit);
                redirect('ppasteles/vercontrolproduccion/'.$this->session->userdata('iddApp'));
                $estatusCambio = array(
                    'estatusCambio' => 0,
                    'idrec_solit' => "",
                    'savedSolit' => 0
                );
                $this->session->set_userdata($estatusCambio);
            }
        }
        
        function definirTipoComponente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipo = $this->input->post('idTipo');
                $session_memo = array(
                    'filterTipoComponente' => $tipo
                );
                $this->session->set_userdata($session_memo);
                echo json_encode(true);
            }
        }
        
        function listapedidos($idApp){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
				$controladore = $this->uri->segment(1);
                $funcione = $this->uri->segment(2);
                $direccione = $controladore.'/'.$funcione;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccione);
                $this->load->view('mantenimiento_listadopedidos', $this->data);
            }
        }
		
		function cambioEstadoPedidos($idApp){
			if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
				$this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                
				$infoDatos = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoDatos);
				
                $this->load->model('global_model');
                
                $direccion = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                
				$this->load->view('pedidos/mantenimiento_cambio_estado_pedidos', $this->data);
			}
		}
		
		function getListadoPedidosPorEstado(){
			if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '2048M');
                
				$estado = $this->input->post('estado');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('ppasteles_model');
                
                if($estado != 0){
                    $informacion = $this->ppasteles_model->getListadoPedidosPorEstado($idcentro, $estado);
                }else{
                    $informacion = $this->ppasteles_model->getListadoPedidosTodos($idcentro, $estado);
                }
				
				$i=0;
				$itemsPedidos = array();
				
				if($informacion != false){
					foreach($informacion as $info){
						$hora = date("g:i A", strtotime($info->dev_time));
						
						$itemsPedidos[$i] = array(
							"numero" => trim($info->numero),
							"descrip" => trim($info->cli_name),
							"lugarentrega" => trim($info->dev_direc),
							"telefono" => $info->cli_phone,
							"fechapedido" => $info->date,
							"horaentrega" => $hora,
							"fechaentrega" => $info->dev_date,
							"fechahoramovimiento" => $info->fechachg.' '.$info->timechg,
							"valventa" => trim($info->val_venta) * 1,
							"estado" => $info->estado
						);
						
						$i++;
					}
				}
				
				$array = array(
					"itemsPedidos" => $itemsPedidos
				);
				
				echo json_encode($array);
			}
		}
		
		function cambiarEstadoPedidosPasteles(){
			if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
				$idPedidos = $this->input->post('idPedidos');
				$actualEstado = $this->input->post('actualEstado');
				$nextEstado = $this->input->post('nextEstado');
				
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('ppasteles_model');
				$this->ppasteles_model->cambiarEstadoPedidosPasteles($idPedidos, $nextEstado);
				
                if($actualEstado != 0){
                    $informacion = $this->ppasteles_model->getListadoPedidosPorEstado($idcentro, $actualEstado);
                }else{
                    $informacion = $this->ppasteles_model->getListadoPedidosTodos($idcentro, $actualEstado);
                }
				
				$i=0;
				$itemsPedidos = array();
				
				if($informacion != false){
					foreach($informacion as $info){
						$hora = date("g:i a", strtotime($info->dev_time));
						
						$itemsPedidos[$i] = array(
							"numero" => trim($info->numero),
							"descrip" => trim($info->cli_name),
							"lugarentrega" => trim($info->dev_direc),
							"telefono" => $info->cli_phone,
							"fechapedido" => $info->date,
							"horaentrega" => $hora,
							"fechaentrega" => $info->dev_date,
							"fechahoramovimiento" => $info->fechachg.' '.$info->timechg,
							"valventa" => trim($info->val_venta) * 1,
							"estado" => $info->estado
						);
						
						$i++;
					}
				}
				
				$array = array(
					"itemsPedidos" => $itemsPedidos
				);
				
				echo json_encode($array);
			}
		}
        
        function informacionPedidoPasteles(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
                $numero = $this->input->post('numeroPedido');
                
                $this->load->model('mantenimiento_model');
                $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);
                
                $sucursal = strtoupper($products['descrip']);
                $pedido = $products['numero'];
                $cli_name = $products['cli_name'];
                $name_vendedor = $products['name_vendedor'];
				$name_usuario = $products['name_usuario'];
                $cli_phone = $products['cli_phone'];
                $date = date_format(date_create($products['date']),'d/m/Y');
                $dev_date2 = ucwords($products['dev_date2']);
                $dev_time = date("g:i a", strtotime($products['dev_time']));
                $tfecha = ucwords($products['tfecha']);
                $val_venta = $products['val_venta'];
                $val_anti = $products['val_anti'];
                $val_refund = $products['val_refund'];
                $tpastel = $products['val_pastel'];
                $taccesorios = $products['val_acc'];
                $tbases = $products['val_bases'];
                $tenvio = $products['val_envio'];
                $cli_email = $products['cli_email'];
                $dev_place = $products['dev_place'];
                $notas_obser = $products['notas'];
                $dev_notes = $products['dev_notes'];
                $imagen = $products['pastel_fotos'];
                $catreference = $products['catreference'];
                $dedicamsg = $products['dedicamsg'];
                $dev_contact = $products['dev_contact'];
                $dev_phone = $products['dev_phone'];
                $lugar = "";
                $tlugar = "";
                
                if($dev_place==1){
                    $lugar = $products['dev_direc'];
                    $tlugar = $products['dev_direc'];
                }elseif($dev_place==2){
                    $lugar = $products['dev_direc'];
                    $tlugar = "DOMICILIO";
                }elseif ($dev_place==3) {
                    $lugar = "Recoger en Producción";
                }
                
                $cktortas = $products['ck_tortas'];
                $ckslices = $products['porciones'];
                
                $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
                
                if($catreference != ""){
                    $fotoCatalogo = $this->mantenimiento_model->getNameImagenPastelCatalogo($catreference);
                }

                
                $estructura = '
                <table style="width:100%;">
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td rowspan="14" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';
                
                if(isset($fotoCatalogo) and $fotoCatalogo!=""){
                    $estructura .= '<img style="min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$fotoCatalogo.'">';
                }
                
                $estructura .='
                        </td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Orden N°</td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E; width:10%;">Fecha</td>
                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Sucursal</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$pedido.'</td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000; width:10%;">'.$date.'</td>
                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$sucursal.'</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Nombre del cliente</td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Telefono</td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Correo</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$cli_name.'</td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$cli_phone.'</td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$cli_email.'</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Fecha de entrega</td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E; width:10%;">Hora</td>
                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$dev_date2.'</td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000; width:10%;">'.$dev_time.'</td>
                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$lugar.'</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Contacto</td>
                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Telefono</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$dev_contact.'</td>
                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$dev_phone.'</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Tipo de documento de venta</td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Número de Porciones</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$dev_notes.'</td>
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000; width:10%;">'.$cktortas.'</td>
                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$ckslices.'</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Diseño</td>
                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 12px; color:#6E6E6E;">Dedicatoria</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td style="text-align:left; vertical-align:middle; font-size: 12px; color:#000000;">'.$catreference.'</td>
                        <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 12px; color:#000000;">'.$dedicamsg.'</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Vendedor</td>
                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Usuario</td>
                    </tr>
                    <tr style="border-collapse:separate; border-spacing:12px;">
                        <td colspan="2" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.strtoupper($name_vendedor).'</td>
                        <td colspan="2" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.strtoupper($name_usuario).'</td>
                    </tr>
                </table>';
                
                if($arrayPasteles != false){
                    $i=1;
                    $estructura .= '
                    <table style="width:100%;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;"><br></td>
                        </tr>
                    </table>
                    <table style="width:100%;">
                        <tr>
                            <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:5.5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">&nbsp;&nbsp;Tortas </td>
                            <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:94.5%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5.5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">N°</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Posición</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Forma</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Sabor</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Baño</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Relleno</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Cobertura</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:13.5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Color</td>
                        </tr>';
                    
                    foreach($arrayPasteles as $key => $value){
                        $estructura .= '
                        <tr>
                            <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                            <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                            <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                            <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                            <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                            <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                            <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                            <td style="text-align:center; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                        </tr>
                        <tr>
                            <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                        </tr>';
                        $i++;
                    }
                    $estructura .= '</table>';
                }
                
                if($arrayAccesorios != false){
                    $i=0;
                    $i = count($arrayAccesorios);
                    
                    $estructura .= '
                    <table style="width:100%;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;"><br></td>
                        </tr>
                    </table>
                    <table style="width:100%;">
                        <tr>
                            <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">&nbsp;&nbsp;Accesorios </td>
                            <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:90%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">N°</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:65%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Descripción</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Cantidad</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Precio $</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Subtotal $</td>
                        </tr>';
                    
                    $i2=1;
                    if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                        $i = count($arrayAccesorios);
                        foreach($arrayAccesorios as $key => $value){
                            $estructura.= '
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                            </tr>';
                            $i2++;  
                        }
                    }
                    
                    $estructura .= '</table>';
                }
                
                if($arrayBases!=false){
                    $i=0;
                    $i = count($arrayBases);
                    $estructura .= '
                    <table style="width:100%;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;"><br></td>
                        </tr>
                    </table>
                    <table style="width:100%;">
                        <tr>
                            <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">&nbsp;&nbsp;Bases </td>
                            <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:90%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">N°</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:65%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Descripción</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Cantidad</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Precio $</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%; background-color:'.$this->session->userdata('FHBackground').'; color:'.$this->session->userdata('FHFontColor').'; border: 1px solid #6E6E6E;">Subtotal $</td>
                        </tr>';
                    
                    $i2=1;
                    if(is_array($arrayBases) and $arrayBases!=false){
                        $i = count($arrayBases);
                        foreach($arrayBases as $key => $value){
                            $estructura.= '
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                            </tr>';
                            $i2++;  
                        }
                    }
                    
                    $estructura .= '</table>';
                }    
                
                $estructura .= '
                <table style="width:100%;">
                    <tr>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;"><br></td>
                    </tr>
                </table>
                <table style="width:100%;">
                    <tr>
                        <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                    </tr>
                </table>';
                
                echo json_encode($estructura);
            }
        }

        function regresarPedidoEnProceso(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
				$idPedidos = $this->input->post('numero');
								
				$this->load->model('ppasteles_model');
				$result = $this->ppasteles_model->regresarPedidoEnProceso($idPedidos);
				
                echo json_encode($result);
			}
        }

        function actualizarValorPastel(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
				$idPedidos = $this->input->post('numero');
                $valPas = $this->input->post('valPas');
                $valPas = number_format($valPas, 2, ".", "");

                $valEnv = $this->input->post('valEnv');
                $valEnv = number_format($valEnv, 2, ".", "");
								
				$this->load->model('ppasteles_model');
				$result = $this->ppasteles_model->actualizarValorPastel($idPedidos, $valPas, $valEnv);
				
                echo json_encode($result);
			}
        }

        //  BUSQUEDA DE PEDIDO
        function visualizarOrdenes($idApp){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
				$this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                
				$infoDatos = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoDatos);        
				$this->load->view('pedidos/mantenimiento_visualizar_ordenes');
			}
        }
        function verificarOrdenExiste(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('CerrarSesion');
            }else{
				$idOrden = $this->input->post('idOrden');
             
								
				$this->load->model('ppasteles_model');
				$result = $this->ppasteles_model->verificarOrdenExiste($idOrden);
				
                echo json_encode($result);
			}
        }
    }
