<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
    class Otrabajo extends CI_Controller{
        
        function __construct() {
            parent::__construct();
        }

        function tiposOrdenesTrabajo($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $fechaactual = $date->format('Y-m-d');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                
                $infoAppName = array(
                    'iddApp' => "",
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $this->data['fechaactual'] = $fechaactual;
                $this->load->view('mantenimiento_tipos_ordenes_trabajo', $this->data);
            }
        }

        function getTiposOrdenes() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('otrabajo_model');
                
                $tipos = $this->otrabajo_model->getTiposOrdenes();
                foreach($tipos as $key => $value){
                    if($value['pro_tipos'] != "" && $value['pro_tipos'] != null){
                        $arrayPros = explode(",", $value['pro_tipos']);
                        $nombresPro = "";

                        foreach($arrayPros as $pro){
                            $nombresPro .= number_format($pro, 2).",";
                        }

                        $tipos[$key]['tiposprostr'] = substr($nombresPro,0,-1);
                    }
                }
               
                echo json_encode($tipos);
            }
        }

        function getInfoTipoOrden() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('variable_model');
                $this->load->model('user_model');
                
                $productos = (array) $this->variable_model->getVariablesNombre("gv_protipo");
                $usuarios = $this->user_model->getActiveUsers();
             
                echo json_encode(["productos"=>$productos, "usuarios"=>$usuarios]);
            }
        }

        function adicionarTipoOrden() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $datos = $this->input->post('datos');
                $this->load->model('otrabajo_model');
                
                $this->otrabajo_model->adicionarTipoOrden($datos);

                echo json_encode(null);
            }
        }

        function modificarTipoOrden() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $wotype = $this->input->post('wotype');
                $datos = $this->input->post('datos');
                $this->load->model('otrabajo_model');
                
                $this->otrabajo_model->modificarTipoOrden($wotype, $datos);

                echo json_encode(null);
            }
        }

        function cotizacionesOrdenes($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('otrabajo_model');
                $this->load->model('configuracion_model');
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $appName = $this->configuracion_model->getAppName($idApp);
                
                $infoAppName = array(
                    'iddApp' => "",
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                $this->data['tipotrabajo'] = $this->otrabajo_model->getTiposOrdenesTrabajo();
                $this->data['vendedores']  = $this->otrabajo_model->getListadoVendedores();
                $this->data['ot_idworker'] = ($this->session->userdata('ot_wotype') == '') ? 0 : $this->session->userdata('ot_idworker');
                $this->data['ot_wotype']   = ($this->session->userdata('ot_wotype') == '') ? 0 : $this->session->userdata('ot_wotype');
                $this->load->view('mantenimiento_ordenes_de_trabajo', $this->data);
            }
        }
        
        function cotizacionesOrdenesAdmin($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('otrabajo_model');
                $this->load->model('configuracion_model');
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $appName = $this->configuracion_model->getAppName($idApp);
                
                $infoAppName = array(
                    'iddApp' => "",
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                $this->data['tipotrabajo'] = $this->otrabajo_model->getTiposOrdenesTrabajo();
                $this->data['vendedores']  = $this->otrabajo_model->getListadoVendedores();
                $this->data['ot_idworker'] = ($this->session->userdata('ot_wotype') == '') ? 0 : $this->session->userdata('ot_idworker');
                $this->data['ot_wotype']   = ($this->session->userdata('ot_wotype') == '') ? 0 : $this->session->userdata('ot_wotype');
                $this->load->view('mantenimiento_ordenes_de_trabajo_admin', $this->data);
            }
        }

        function getDetalleCotizaciones() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $type     = $this->input->post('type');
                $idworker = $this->input->post('idworker');
                $estados  = $this->input->post('estados');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');

                $this->load->model('otrabajo_model');

                echo json_encode($this->otrabajo_model->getDetalleCotizaciones($type, $idworker, $estados, $fechaini, $fechafin));
            }
        }
        
        function getDataFormulario() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('otrabajo_model');

                echo json_encode(array(
                    'infoClientes'   => $this->otrabajo_model->getInformacionClientes(),
                    'infoVendedores' => $this->otrabajo_model->getInformacionVendedores(),
                    'infoOrigen'     => $this->otrabajo_model->getInformacionOrigen(),
                    'infoDocumentos' => $this->otrabajo_model->getInformacionDocumentosVN()
                ));
            }
        }

        function getInformacionFormasPago() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->getInformacionFormasPago($idclase));
            }
        }

        function getInfoCotizacionCliente() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxi = $this->input->post('idauxi');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->getInfoCotizacionCliente($idauxi));
            }
        }

        function insertOrdenDeTrabajo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $type     = $this->input->post('type');
                $idcps    = $this->input->post('idcps');
                $fecha    = $this->input->post('fecha');
                $contacto = $this->input->post('contacto');
                $idworker = $this->input->post('idworker');
                $idorigen = $this->input->post('idorigen');
                $idclase  = $this->input->post('idclase');
                $idpago   = $this->input->post('idpago');
                $descrip  = $this->input->post('descrip');
                $notas    = $this->input->post('notas');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->insertOrdenDeTrabajo($type, $idcps, $fecha, $contacto, $idworker, $idorigen, $idclase, $idpago, $descrip, $notas));
            }
        }
        
        function updateOrdenDeTrabajo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $fecha    = $this->input->post('fecha');
                $contacto = $this->input->post('contacto');
                $idworker = $this->input->post('idworker');
                $idorigen = $this->input->post('idorigen');
                $idclase  = $this->input->post('idclase');
                $idpago   = $this->input->post('idpago');
                $ponum    = $this->input->post('ponum');
                $podata   = $this->input->post('podata');
                $descrip  = $this->input->post('descrip');
                $notas    = $this->input->post('notas');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->updateOrdenDeTrabajo($trannum, $fecha, $contacto, $idworker, $idorigen, $idclase, $idpago, $ponum, $podata, $descrip, $notas));
            }
        }

        function detalleCotizacionesOrdenes($trannum, $idworker, $wotype) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->session->set_userdata(array(
                    'namePage'    => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum,
                    'ot_idworker' => $idworker,
                    'ot_wotype'   => $wotype
                ));
                
                $this->load->model('global_model');
                $this->load->model('otrabajo_model');
				
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                $this->data['informacion'] = $this->otrabajo_model->getDetalleInformacion($trannum);
                
                $this->load->view('mantenimiento_detalle_ordentrabajo', $this->data); 
            }
        }
        
        function detalleCotizacionesOrdenesAdmin($trannum, $idworker, $wotype) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->session->set_userdata(array(
                    'namePage'    => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum,
                    'ot_idworker' => $idworker,
                    'ot_wotype'   => $wotype
                ));
                
                $this->load->model('global_model');
                $this->load->model('otrabajo_model');
				
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                $this->data['informacion'] = $this->otrabajo_model->getDetalleInformacion($trannum);
                
                $this->load->view('mantenimiento_detalle_ordentrabajo_admin', $this->data); 
            }
        }

        function getListadoLineasOrdenes() {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$wotype  = $this->input->post('wotype');
				
                $this->load->model('otrabajo_model');
				$lineas = $this->otrabajo_model->getGruposLineasOrdenes($wotype);
                $cantid = $this->otrabajo_model->getCantidadesLineaCatalogo($trannum, $wotype);
                
                $i=0;
				$array = array();
				
				foreach($lineas as $data){
					foreach($cantid as $cant){
						if($data->idcatalogo == $cant->idcatalogo){
							$array[$i] = array(
								"idcatalogo" => $data->idcatalogo,
								"imagen" => trim($data->imagen),
								"descrip" => trim($data->descrip),
								"total" => $cant->cantidad
							);
						}		
					}
					$i++;
				}
				
                echo json_encode($array);
			}
		}

        function getListadoProductosTipo() {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum    = $this->input->post('trannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $wotype     = $this->input->post('wotype');
                $idcentro   = $this->session->userdata('idcentrouser');
				
				$this->load->model('otrabajo_model');
                $detalle = $this->otrabajo_model->getInventarioByCatalogo($trannum, $idcatalogo, $idcentro, $wotype);
				
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    $datos[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "tipotax" => $info->tipotax,
                        "tipo" => (int) $info->tipo,
                        "precio" => $info->precioventa,
                        "costounitario" => $info->costounitario
                    );
                    $i++;
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i,
                );
                echo json_encode($array);
			}
		}

        function getDetalleProductosOrden() {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum  = $this->input->post('trannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('otrabajo_model');
				$array = $this->otrabajo_model->getDetalleProductosOrden($trannum, $idcentro);
				echo json_encode($array);
			}
		}

        function getDataForm() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcps    = $this->input->post('idcps');
				$trannum  = $this->input->post('trannum');
				
				$this->load->model('otrabajo_model');
				
				echo json_encode(array(
                    'dataIVA'   => $this->otrabajo_model->getListadoIVA(),
                    'dataGrupo' => $this->otrabajo_model->getListadoGrupos($trannum),
                    'dataLugar' => $this->otrabajo_model->getListadoLugares($idcps)
                ));
			}
        }

        function adicionarProducto() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $nameImagen = '';
                if(isset($_FILES["imgFile"])){
                    $infoFile = $_FILES["imgFile"];
                    $nameImagen = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    
                    if($nameImagen != ""){
                        $nameImagen = str_replace(" ", "_", $nameImagen);
                        
                        $config['upload_path'] = "img_cuentas/" . $this->session->userdata('diraccount') . "/";
                        $config['file_name'] = $nameImagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if(!$this->upload->do_upload('imgFile')){
                            $nameImagen = '';
                        }
                    }
                }

                $trannum     = $this->input->post('trannum');
                $idproducto  = $this->input->post('idproducto');
                $um          = $this->input->post('um');
                $descrip     = $this->input->post('descrip');
                $cantidad    = $this->input->post('cantidad');
                $precioventa = $this->input->post('precioventa');
                $descuento   = $this->input->post('descuento');
                $tax1        = $this->input->post('tax1');
                $agrupa      = $this->input->post('agrupa');
                $fecha       = $this->input->post('fecha');
                $delivery    = $this->input->post('delivery');
                $ldescrip    = $this->input->post('ldescrip');
                $notas       = $this->input->post('notas');
                $pdf         = $this->input->post('pdf');
                $movimiento  = $this->input->post('movimiento');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->adicionarProducto($trannum, $idproducto, $um, $descrip, $cantidad, $precioventa, $descuento, $tax1, $agrupa, $fecha, $delivery, $ldescrip, $notas, $pdf, $movimiento, $nameImagen));
            }
        }
        
        function modificarProducto() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $nameImagen = '';
                if(isset($_FILES["imgFile"])){
                    $infoFile = $_FILES["imgFile"];
                    $nameImagen = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    
                    if($nameImagen != ""){
                        $nameImagen = str_replace(" ", "_", $nameImagen);
                        
                        $config['upload_path'] = "img_cuentas/" . $this->session->userdata('diraccount') . "/";
                        $config['file_name'] = $nameImagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if(!$this->upload->do_upload('imgFile')){
                            $nameImagen = '';
                        }
                    }
                }

                $idrec       = $this->input->post('idrec');
                $itemline    = $this->input->post('itemline');
                $descrip     = $this->input->post('descrip');
                $cantidad    = $this->input->post('cantidad');
                $precioventa = $this->input->post('precioventa');
                $descuento   = $this->input->post('descuento');
                $tax1        = $this->input->post('tax1');
                $agrupa      = $this->input->post('agrupa');
                $fecha       = $this->input->post('fecha');
                $delivery    = $this->input->post('delivery');
                $ldescrip    = $this->input->post('ldescrip');
                $notas       = $this->input->post('notas');
                $pdf         = $this->input->post('pdf');
                $movimiento  = $this->input->post('movimiento');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->modificarProducto($idrec, $descrip, $itemline, $cantidad, $precioventa, $descuento, $tax1, $agrupa, $fecha, $delivery, $ldescrip, $notas, $pdf, $movimiento, $nameImagen));
            }
        }

        function eliminarProducto() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                
                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->eliminarProducto($idrec));
            }
        }

        function anexosCotizacionesOrdenes($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $fechaactual = $date->format('Y-m-d');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                
                $infoAppName = array(
                    'iddApp' => "",
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                $this->data['fechaactual'] = $fechaactual;
                $this->load->view('mantenimiento_anexos_cotizaciones_ordenes', $this->data);
            }
        }

        function getListadoAnexos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('otrabajo_model');
                
                $anexos = $this->otrabajo_model->getListadoAnexos();
         
                echo json_encode($anexos);
            }
        }
        
        function getInformacionAnexos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('otrabajo_model');
                echo json_encode(array(
                    'infoAnexos' => $this->otrabajo_model->getInfoListadoAnexos($trannum),
                    'detaAnexos' => $this->otrabajo_model->getDetalleAnexos($trannum),
                ));
            }
        }

        function adicionarAnexoCoti() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idanexo = $this->input->post('idanexo');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->adicionarAnexoCoti($trannum, $idanexo));
            }
        }

        function eliminarAnexoCoti() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idorden = $this->input->post('idorden');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->eliminarAnexoCoti($trannum, $idorden));
            }
        }
        
        function modificaAnexoCoti() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $idanexos = $this->input->post('idanexos');

                $this->load->model('otrabajo_model');
                $this->otrabajo_model->modificaAnexoCoti($trannum, $idanexos);

                echo json_encode($this->otrabajo_model->getDetalleAnexos($trannum));
            }
        }

        function getListadoMotivos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $estado = $this->input->post('estado');
                
                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->getListadoMotivosMov($estado));
            }
        }

        function getCierreCotizacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->getDetalleInformacion($trannum));
            }
        }
        
        function getCierreCotizacionFacturada() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('otrabajo_model');
                $informacion = $this->otrabajo_model->getDetalleInformacion($trannum);

                echo json_encode(array(
                    'data' => $informacion,
                    'documentos' => $this->otrabajo_model->getDetalleDocumentosFacturados($informacion[0]->idauxi)
                ));
            }
        }

        function getInformacionFacturadas() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('otrabajo_model');
                $this->load->model('variable_model');
                $this->load->model('invtran_model');

				$porcentaje_iva = $this->variable_model->getValorIVA();
                $datos = $this->otrabajo_model->getDatosFacturaciones($trannum);
                
                $i=0;
                $array = array();
                
                if ($datos !== false) {
                    foreach ($datos as $info) {
                        if ($info->estatus!=0) {
                            $valtax1 = 0;
                            $detalle = $this->invtran_model->getDetalleFacturas($info->trannum);
                            
                            $j = 0;
                            $detailFacturas = array();
                            foreach ($detalle as $data) {
                                $valtax1 = 0;
                                if ($info->exento == 0) {
                                    $valtax1 = $data->precioneto * ($data->tax1 / 100);
                                } else {
                                    $valtax1 = 0;
                                }
                                                            
                                $total = abs($data->cantidad) * ($data->precioneto + $valtax1);
                                
                                $detailFacturas[$j] = array(
                                    "itemline"   => $data->itemline,
                                    "idproducto" => $data->idproducto,
                                    "descrip"    => $data->descrip,
                                    "notas"      => $data->notas,
                                    "um"         => $data->um,
                                    "modelo"     => $data->modelo,
                                    "barcode"    => $data->barcode,
                                    "ubicacion"  => $data->ubicacion,
                                    "lote"       => $data->lote,
                                    "cantidad"   => abs($data->cantidad),
                                    "precio"     => $this->session->userdata("simboloMoneda").number_format($data->precioneto, 6, '.', ','),
                                    "tax1"       => $this->session->userdata("simboloMoneda").number_format($valtax1, 6, '.', ','),
                                    "total"      => $this->session->userdata("simboloMoneda").number_format($total, 2, '.', ',')
                                );
                                $j++;
                            }
                            
                            $exento_doc = 0; $gravado_doc = 0; $iva_doc = $info->valtax1;
                            if ($info->exento==1) {
                                $exento_doc = $info->valventan;
                            } else {
                                if ( $porcentaje_iva != 0 ) {
                                    $gravado_doc = ($info->valtax1 / ($porcentaje_iva/100));
                                } else  $gravado_doc = $info->valventan;

                                $exento_doc = number_format($info->valventan-$gravado_doc, 2, '.', '');
                            }

                            $totalVenta = $info->valventan + $iva_doc;

                            if (($info->idtipo == 3) && ($gravado_doc>=100)) {
                                $reten = $gravado_doc * 0.01;
                                $retencion  = '-'.$reten;
                                $totalVenta = $totalVenta-$reten;
                            } else {
                                $retencion = 0;
                            }

                            $array[$i] = array(
                                "trannum"        => $info->trannum,
                                "fecha"          => $info->fecha,
                                "tipodoc"        => $info->tipodoc,
                                "seriedoc"       => $info->serie,
                                "numeroserie"    => $info->numero * 1,
                                "namevendedor"   => $info->namevendedor,
                                "valventan"      => number_format($totalVenta, 6, '.', ''),
                                "exento"         => number_format($exento_doc, 6, '.', ''),
                                "gravado"        => number_format($gravado_doc, 6, '.', ''),
                                "iva"            => number_format($iva_doc, 6, '.', ''),
                                "retencion"      => number_format($retencion, 6, '.', ''),
                                "referencia"     => $info->referencia,
                                "detailFacturas" => $detailFacturas,
                            );
                            $i++;
                        }
                    }
                }
                
                echo json_encode($array);
            }
        }

        function updateEstadoCotizacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum   = $this->input->post('trannum');
                $estado_a  = $this->input->post('estado_a');
                $estado_n  = $this->input->post('estado_n');
                $motivo    = $this->input->post('motivo');
                $ponum     = $this->input->post('ponum');
                $podata    = $this->input->post('podata');
                $formapago = ($this->input->post('formapago') !== null) ? $this->input->post('formapago') : '';
                $infopago  = ($this->input->post('infopago') !== null) ? $this->input->post('infopago') : '';
                
                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->updateEstadoCotizacion($trannum, $estado_a, $estado_n, $motivo, $ponum, $podata, $formapago, $infopago));
            }
        }
        
        function updateEstadoCotizacionFacturada() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum    = $this->input->post('trannum');
                $estado_a   = $this->input->post('estado_a');
                $estado_n   = $this->input->post('estado_n');
                $documentos = $this->input->post('documentos');
                
                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->updateEstadoCotizacionFacturada($trannum, $estado_a, $estado_n, $documentos));
            }
        }
        
        function sendCorreoCotizacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $de      = $this->input->post('de');
                $para    = $this->input->post('para');
                $cc      = $this->input->post('cc');
                $asunto  = $this->input->post('asunto');
                $mensaje = $this->input->post('mensaje');
                
                //$this->load->model('otrabajo_model');
                //echo json_encode($this->otrabajo_model->updateEstadoCotizacion($trannum, $estado_a, $estado_n, $motivo));

                $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
                $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
                $cabeceras .= 'To: <'.$para.'>' . "\r\n";
                $cabeceras .= 'From: <'.$de.'>' . "\r\n";
                if ($cc != '') $cabeceras .= 'Cc: '. $cc . "\r\n";
                
                echo json_encode(mail($para, utf8_decode($asunto), utf8_decode($mensaje), $cabeceras));
            }
        }

        function controlOrdenesDeTrabajo($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('otrabajo_model');
                $this->load->model('configuracion_model');
                                
                $appName = $this->configuracion_model->getAppName($idApp);
                
                $infoAppName = array(
                    'iddApp' => "",
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                $this->load->view('mantenimiento_control_ordenes_de_trabajo', $this->data);
            }
        }

        function getDetalleControl() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->getDetalleControl());
            }
        }

        function getDetalleOT() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->getDetalleOT($trannum));
            }
        }

        function consumoDeMateriales($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('otrabajo_model');
                $this->load->model('configuracion_model');
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $month     = $date->format('m');
                $year      = $date->format('Y');
                $fecha_ini = date('Y-m-d', mktime(0,0,0, $month, 1, $year));
                $fecha_fin = $date->format('Y-m-d');
                
                $appName   = $this->configuracion_model->getAppName($idApp);
                $optCodigo = $this->configuracion_model->getProCentro($idApp);

                $infCodigos = explode(",", $optCodigo);

                $infoAppName = array(
                    'iddApp' => "",
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $this->data['valFechaIni'] = $fecha_ini;
				$this->data['valFechafin'] = $fecha_fin;
                $this->data['idConsumo'] = $infCodigos[0];
                $this->data['idReintegro'] = $infCodigos[1];
                $this->data['transacciones'] = $this->otrabajo_model->getTransaccionesConsumos($optCodigo);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                $this->load->view('mantenimiento_consumo_de_materiales', $this->data);
            }
        }

        function getInformacionConsumos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $estado = $this->input->post('estado');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idConsumo = $this->input->post('idConsumo');
                $idReintegro = $this->input->post('idReintegro');
                
                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->getInformacionConsumos($estado, $fechaini, $fechafin, $idConsumo, $idReintegro));
            }
        }

        function insertNuevoConsumo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fecha   = $this->input->post('fecha');
                $wonum   = $this->input->post('wonum');
                $notas   = $this->input->post('notas');
                $idclase = $this->input->post('idclase');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->insertNuevoConsumo($fecha, $wonum, $notas, $idclase));
            }
        }

        function detalleConsumoMateriales($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                $this->load->model('configuracion_model'); $this->load->model('otrabajo_model');
                
                $informacion = $this->otrabajo_model->getDetalleConsumo($trannum);
                
				$this->data['formatos']      = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1).'/'.$this->uri->segment(2));
                $this->data['informacion']   = $informacion;
                $this->data['transacciones'] = $this->otrabajo_model->getTransaccionesConsumos($informacion[0]->idclase);
                $this->data['cantidad']      = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades']      = $this->invtran_model->getUnidades100k($trannum);
                                
                $this->data['sumaPT'] = $this->global_model->getValorNumVariablePro('gv_protipo', 1);
                $this->data['sumaMP'] = $this->global_model->getValorNumVariablePro('gv_protipo', 2);
                $this->data['sumaIS'] = 0;
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }
                
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detalle_consumo_de_materiales', $this->data);
            }
        }

        function getDetalleProductosEnviados() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $wonum   = $this->input->post('wonum');
                $trannum = $this->input->post('trannum');

                $this->load->model('otrabajo_model');
                $detalle = $this->otrabajo_model->getDetalleProductosEnviados($wonum, $trannum);

                $i=0;
                $items = array();
                foreach ($detalle as $info) {
                    if ($info->existe == "0" && $info->cantidad > 0) {
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca"        => $info->marca,
                            "modelo"       => $info->modelo,
                            "upc"          => $info->barcode,
                            "upp"          => $info->upp,
                            "notas"        => $info->notas,
                            "idproducto"   => $info->idproducto,
                            "um"           => $info->um,
                            "imagen"       => $info->imagen,
                            "cantidad"     => $info->cantidad,
                            "precio"       => $info->costounitario,
                            "idbin"        => $info->idbin,
                            "idbatch"      => $info->idbatch,
                            "xpos"         => $info->xpos
                        );
                        $i++;
                    }
                }

                echo json_encode(array(
                    "datos"    => $items
                ));
            }
        }

        function getDetalleProductosConsumo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $wonum    = $this->input->post('wonum');
                $inopera  = $this->input->post('inopera');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->getDetalleProductosConsumo($trannum, $wonum, $inopera, $idcentro));
            }
        }

        function adicionarRegistroConsumo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum       = $this->input->post('trannum');
                $wonum         = $this->input->post('wonum');
                $inopera       = $this->input->post('inopera');
                $idproducto    = $this->input->post('idproducto');
                $cantidad      = $this->input->post('cantidad');
                $idcatalogo    = $this->input->post('idcatalogo');
                $um            = $this->input->post('um');
                $notas         = $this->input->post('notas');
                $idclase       = $this->input->post('idclase');
                $costounitario = $this->input->post('costounitario');
                $idcentro      = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $this->load->model('otrabajo_model');
                
                $this->otrabajo_model->adicionarRegistroConsumo($trannum, $idclase, $idcentro, $inopera, $idproducto, $cantidad, $um, $costounitario, $notas);
                
                if ($inopera == 1) {
                    $detalle = $this->otrabajo_model->getDetalleProductosEnviados($wonum, $trannum);
                } else {
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }

                $datos   = $this->otrabajo_model->getDetalleProductosConsumo($trannum, $wonum, $inopera, $idcentro);
                
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach ($detalle as $info) {
                    if ($info->existe == "0" && $info->cantidad > 0) {
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca"        => $info->marca,
                            "modelo"       => $info->modelo,
                            "upc"          => $info->barcode,
                            "upp"          => $info->upp,
                            "notas"        => $info->notas,
                            "idproducto"   => $info->idproducto,
                            "um"           => $info->um,
                            "imagen"       => $info->imagen,
                            "cantidad"     => $info->cantidad,
                            "precio"       => $info->costounitario,
                            "idbin"        => $info->idbin,
                            "idbatch"      => $info->idbatch,
                            "xpos"         => $info->xpos
                        );
                        $i++;
                    }
                }
                
                echo json_encode(array(
                    "items"    => $items,
                    "datos"    => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count"    => $i
                ));
            }            
        }

        function modificarRegistroConsumo() {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
                redirect('CerrarSesion');
            } else {
                $trannum    = $this->input->post('trannum');
                $wonum      = $this->input->post('wonum');
                $idrec      = $this->input->post('idrec');
                $cantidad   = $this->input->post('cantidad');
                $inopera    = $this->input->post('inopera');
                $notas      = $this->input->post('notas');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro   = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $this->load->model('otrabajo_model');
                
                $this->otrabajo_model->modificarRegistroConsumo($idrec, $cantidad, $inopera, $notas);
                
                if ($inopera == 1) {
                    $detalle = $this->otrabajo_model->getDetalleProductosEnviados($wonum, $trannum);
                } else {
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }

                $datos   = $this->otrabajo_model->getDetalleProductosConsumo($trannum, $wonum, $inopera, $idcentro);
                
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                                
                $i=0;
                $items = array();
                foreach ($detalle as $info) {
                    if ($info->existe == "0" && $info->cantidad > 0) {
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca"        => $info->marca,
                            "modelo"       => $info->modelo,
                            "upc"          => $info->barcode,
                            "upp"          => $info->upp,
                            "notas"        => $info->notas,
                            "idproducto"   => $info->idproducto,
                            "um"           => $info->um,
                            "imagen"       => $info->imagen,
                            "cantidad"     => $info->cantidad,
                            "precio"       => $info->costounitario,
                            "idbin"        => $info->idbin,
                            "idbatch"      => $info->idbatch,
                            "xpos"         => $info->xpos
                        );
                        $i++;
                    }
                }
                
                echo json_encode(array(
                    "items"    => $items,
                    "datos"    => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count"    => $i
                ));
            }            
        }

        function eliminarRegistroConsumo() {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
                redirect('CerrarSesion');
            } else {
                $trannum    = $this->input->post('trannum');
                $wonum      = $this->input->post('wonum');
                $idrec      = $this->input->post('idrec');
                $inopera    = $this->input->post('inopera');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro   = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $this->load->model('otrabajo_model');
                
                $this->otrabajo_model->eliminarRegistroConsumo($idrec);
                
                if ($inopera == 1) {
                    $detalle = $this->otrabajo_model->getDetalleProductosEnviados($wonum, $trannum);
                } else {
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }

                $datos   = $this->otrabajo_model->getDetalleProductosConsumo($trannum, $wonum, $inopera, $idcentro);
                
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                                
                $i=0;
                $items = array();
                foreach ($detalle as $info) {
                    if ($info->existe == "0" && $info->cantidad > 0) {
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca"        => $info->marca,
                            "modelo"       => $info->modelo,
                            "upc"          => $info->barcode,
                            "upp"          => $info->upp,
                            "notas"        => $info->notas,
                            "idproducto"   => $info->idproducto,
                            "um"           => $info->um,
                            "imagen"       => $info->imagen,
                            "cantidad"     => $info->cantidad,
                            "precio"       => $info->costounitario,
                            "idbin"        => $info->idbin,
                            "idbatch"      => $info->idbatch,
                            "xpos"         => $info->xpos
                        );
                        $i++;
                    }
                }
                
                echo json_encode(array(
                    "items"    => $items,
                    "datos"    => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count"    => $i
                ));
            }
        }

        function setAnulacionConsumo() {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				
                $this->load->model('invtran_model');
				echo json_encode($this->invtran_model->setAnulacionConsumo($trannum, 9));
			}
		}

        function cerrarConsumo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $notas   = trim($this->input->post('notas'));
                
                $this->load->model('invtran_model');
                $this->load->model('otrabajo_model');
                
                $array = $this->otrabajo_model->cerrarConsumo($trannum, $notas);
                $this->invtran_model->callTotaliza100($trannum, 1);
				
                echo json_encode($array);
            }
        }

        function updateControlOT() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec    = $this->input->post('idrec');
                $notas    = $this->input->post('notas');
                $idworker = $this->input->post('idworker');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->updateControlOT($idrec, $notas, $idworker));
            }
        }

        function moveItemControl() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $estado_a = $this->input->post('estado_a');
                $estado_n = $this->input->post('estado_n');
                $motivo   = $this->input->post('motivo');
                $fecha    = $this->input->post('fecha');

                $this->load->model('otrabajo_model');
                $this->otrabajo_model->moveItemControl($trannum, $estado_a, $estado_n, $motivo, $fecha);
                echo json_encode($this->otrabajo_model->getDetalleControl());
            }
        }

        function updateRegistroControl() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec    = $this->input->post('idrec');
                $idworker = $this->input->post('idworker');
                $notas    = $this->input->post('notas');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->updateRegistroControl($idrec, $idworker, $notas));
            }
        }

        function analisisConsumoDeMateriales($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('otrabajo_model');
                $this->load->model('configuracion_model');
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $month     = $date->format('m');
                $year      = $date->format('Y');
                $fecha_ini = date('Y-m-d', mktime(0,0,0, $month, 1, $year));
                $fecha_fin = $date->format('Y-m-d');
                
                $appName   = $this->configuracion_model->getAppName($idApp);
                $optCodigo = $this->configuracion_model->getProCentro($idApp);

                $infCodigos = explode(",", $optCodigo);

                $infoAppName = array(
                    'iddApp' => "",
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $this->data['fechaIni'] = $fecha_ini;
				$this->data['fechafin'] = $fecha_fin;
                $this->data['idConsumo'] = $infCodigos[0];
                $this->data['idReintegro'] = $infCodigos[1];
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                $this->load->view('mantenimiento_analisis_consumos', $this->data);
            }
        }

        function getDatosAnalisisConsumos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaIni = $this->input->post('fechaIni');
                $fechaFin = $this->input->post('fechaFin');
                $idConsumo = $this->input->post('idConsumo');
                $idReintegro = $this->input->post('idReintegro');

                $this->load->model('otrabajo_model');
                echo json_encode($this->otrabajo_model->getDatosAnalisisConsumos($fechaIni, $fechaFin, $idConsumo, $idReintegro));
            }
        }

        //ANEXOS A COTIZACION
        function adicionarAnexo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $datos = $this->input->post('datos');
                $this->load->model('otrabajo_model');
                
                $this->otrabajo_model->adicionarAnexo($datos);

                echo json_encode(null);
            }
        }

        function modificarAnexo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idanexo = $this->input->post('idanexo');
                $datos = $this->input->post('datos');
                $this->load->model('otrabajo_model');
                
                $this->otrabajo_model->modificarAnexo($idanexo, $datos);

                echo json_encode(null);
            }
        }

        function getImagenesAnexos() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('otrabajo_model');
                
                $imagenes = array_diff(scandir('img_cuentas/'.$this->session->userdata('diraccount').'/imgCotis'), array('..', '.'));

                echo json_encode($imagenes);
            }
        }

        function subirImagenAnexo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $bandera = true;
                $filename = "";

                if(isset($_FILES["adjunto0"])){
                    if($_FILES['adjunto0']['size'] > 1024*1024*2) {
                        $bandera = false;
                        $mensaje = "El archivo excede el tamaño máximo de 2MB.";
                    }

                    $extension = mime_content_type($_FILES["adjunto0"]["tmp_name"]);
                    $allowed_file_types = ['image/png', 'image/jpeg', 'image/bmp'];
                    if (!in_array($extension, $allowed_file_types)) {
                        $bandera = false;
                        $mensaje = "El archivo posee una extensión no permitida.";
                    }    
                                
                }else{
                    $bandera = false;
                    $mensaje = "No se ha seleccionado ningún archivo para subir.";
                }

                if($bandera){
                    $path_parts = pathinfo($_FILES["adjunto0"]['name']);
                    $nameImagen = str_replace(" ", "_", $path_parts['filename']).'.'.$path_parts['extension']; //Nombre unico para archivo
                    $config['upload_path'] = "img_cuentas/" . $this->session->userdata('diraccount') . "/imgCotis";
                    $config['file_name'] = $nameImagen;
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "*";
    
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);
                    $this->upload->do_upload('adjunto0');
                    $mensaje = "La imagén se ha subido exitosamente.";
                    $filename = $nameImagen;
                }
                $respuesta = array("bandera"=>$bandera, "mensaje"=>$mensaje, "filename"=>$filename);
                echo json_encode($respuesta);
            }
        }

        function cambiosDeEstados($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('otrabajo_model');
                $this->load->model('configuracion_model');
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $appName = $this->configuracion_model->getAppName($idApp);
                
                $infoAppName = array(
                    'iddApp' => "",
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                $this->data['tipotrabajo'] = $this->otrabajo_model->getTiposOrdenesTrabajo();
                $this->data['vendedores']  = $this->otrabajo_model->getListadoVendedores();
                $this->data['estadosOT']   = $this->otrabajo_model->getDiferentesCambiosEstados();
                $this->data['ot_idworker'] = ($this->session->userdata('ot_wotype') == '') ? 0 : $this->session->userdata('ot_idworker');
                $this->data['ot_wotype']   = ($this->session->userdata('ot_wotype') == '') ? 0 : $this->session->userdata('ot_wotype');
                $this->load->view('mantenimiento_ordenes_cambio_de_estados', $this->data);
            }
        }

        function getDetalleCotizacionesEstados() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $type     = $this->input->post('type');
                $idworker = $this->input->post('idworker');
                $estado_a = $this->input->post('estado_a');
                $estado_n = $this->input->post('estado_n');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');

                $this->load->model('otrabajo_model');

                echo json_encode($this->otrabajo_model->getDetalleCotizacionesEstados($type, $idworker, $estado_a, $estado_n, $fechaini, $fechafin));
            }
        }
    }
?>