<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Login extends CI_Controller{

        function __construct(){
            parent::__construct();
        }
        
        function index(){
            $accFail = array(
                'failEstatus' => 0,
                'failVencimi' => 0,
                'failAccount' => 0
            );
            $this->session->set_userdata($accFail);

            $this->load->view('accountGoXpos');
        }
        
        function loginGoXpos($idaccount = 0){

            if($idaccount == 0){
                redirect('');
            }
            
            $this->load->model('Login_model');

            $this->data['idaccount']   = $idaccount;
            $this->data['informacion'] = $this->Login_model->getInformacionAccount($idaccount);
            $this->data['logoAccount'] = $this->Login_model->getImagenLogoAccount($idaccount);
            $this->load->view('loginGoXpos', $this->data);

            $failLogin = array(
                'Cuenta' => 0,
                'usseR'  => 0,
            );
            $this->session->set_userdata($failLogin);
        }
        
        function iniciar_sesion(){
            $this->load->view('accountGoXpos');
            
            $accFail = array(
                'failEstatus' => 0,
                'failVencimi' => 0,
                'failAccount' => 0,
            );

            $this->session->set_userdata($accFail);
        }
        
        function loginUser(){
            if($this->input->post()){
                $idaccount  = trim($this->input->post('inputAccount'));
                $username   = $this->input->post('inputUsername');
                $password   = $this->input->post('inputPassword');
                $infoToken  = $this->input->post('infoTokenGoXpos');
                
                $cuenta_data = array(
                    'idacount' => $idaccount,
                    'nombreLoginUser' => $username
                );
                $this->session->set_userdata($cuenta_data);
                
				$this->load->model('Login_model');
				$infoResult = $this->Login_model->loginUpdate($idaccount, $username, $password, $infoToken);
				
                if($infoResult){
                    $usuario_data = array(
                        'logueado' => 'TRUE',
                        'logueado2' => TRUE
                    );

                    $this->session->set_userdata($usuario_data);
                    
                    redirect('Login/logueado');
                }else{
                    redirect('GoXpos/'.$idaccount);
                }
            }else{
                redirect('GoXpos/'.$idaccount);
            }
        }

        function validacionAccount(){
            if($this->input->post()){
                $idaccount  = trim($this->input->post('inputAccount'));
                
                $this->load->model('Login_model');
				$validAccount = $this->Login_model->validacionAccount($idaccount);
				
                if($validAccount){
                    $poServer = strpos(base_url(), $this->session->userdata('server_name'));
                    
                    if($poServer !== false){
                        redirect('GoXpos/'.$idaccount);
                    }else{
                        header('Location: http://'.$this->session->userdata('server_name').'/GoXpos/'.$idaccount);
                    }
                }else{
                    $this->iniciar_sesion();
                }
            }else{
                $this->iniciar_sesion();
            }
        }
        
        function logueado(){
            if($this->session->userdata('logueado') == 'TRUE'){
                redirect('Bienvenidos');
            }else{
                redirect('Login/iniciar_sesion');
            }
        }
        
        function backMenu(){
			$namePage = array('namePage' => 'Bienvenido/a '. $this->session->userdata('nameEmpleadoUser'));  
            $this->session->set_userdata($namePage);
			
            $user = $this->session->userdata('iduser');
            
            $this->load->model('Mensajes_model');
            
            $this->data['totMensajes'] = $this->Mensajes_model->getNewMensajes($user);
            $this->data['mensajes'] = $this->Mensajes_model->getMensajes($user);
            $this->data['dataContactos'] = $this->Mensajes_model->getContactos($user);
			            
			$this->load->view('homeInicio', $this->data);
        }
        
        function cerrar_sesion(){
            $idaccount = $this->session->userdata('idaccount');

            $usuario_data = array(
                'logueado' => 'FALSE',
                'logueado2' => FALSE,
                'idCatalogo_slc' => '',
                'idcentroTemp' => '',
                'idcajaTemp' => '',
                'fechaini' => '',
                'fechafin' => '',
                'procentro_id' => ''
            );
            unset($_SESSION['menuSite']);
            unset($_SESSION['appsSite']);
            unset($_SESSION['menuType']);
            unset($_SESSION['userPerm']);
            unset($_SESSION['dataSourceConsulta']);
			$this->session->unset_userdata($usuario_data);
			
            if($this->session->userdata('log_sadmin') != TRUE){
                $this->session->sess_destroy();
                if(session_start()){
                    session_destroy();
                }
                redirect('GoXpos/'.$idaccount);
            }else{
                echo "<script languaje='javascript' type='text/javascript'>window.close();</script>";
            }
        }
        
        function cambiarPerfil(){
			$namePage = array(
                'namePage' => 'Actualizar Perfil'
            );
			$this->session->set_userdata($namePage);
			
            $id = $this->session->userdata('iduser');
            $this->load->model('User_model');
            $data['user'] = $this->User_model->callRegistro($id);
            $this->load->view('cambiar_perfil', $data);
            
            $datE = array(
                'antError' => 0,
                'cncError' => 0,
                'crcTod' => 0,
                'cntError' => 0 
            );
            $this->session->set_userdata($datE);
        }
		
		function validateLogeo(){
			date_default_timezone_set('America/El_Salvador');
			$date = new DateTime();
			
			$hora_login = $date->format('H:i');
			$horaIni = $this->session->userdata('horaini');
			$horaFin = $this->session->userdata('horafin');
			
			if($horaIni == "00:00" && $horaFin == "00:00"){
				$array = true;
			}else{
                // Verifica si la hora actual está dentro del rango permitido
                if ($horaIni <= $horaFin) {
                    // Rango horario normal, sin paso de medianoche
                    if ($hora_login >= $horaIni && $hora_login <= $horaFin) {
                        $array = true;
                    } else {
                        $array = false;
                    }
                } else {
                    // Rango horario que incluye el paso de medianoche
                    if ($hora_login >= $horaIni || $hora_login <= $horaFin) {
                        $array = true;
                    } else {
                        $array = false;
                    }
                }
			}
			
			echo json_encode($array);
		}
    }
?>