<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    require 'vendor/autoload.php';

    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

    class Iva extends CI_Controller {
        
        function __construct(){
            parent::__construct();
            
            date_default_timezone_set('America/El_Salvador');
        }
        
        function book01() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'opcionmenu' => $opcionmenu,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);

                $this->load->model('sucursal_model');
                $this->load->model('transacciones_model');
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva_Tipo(1);
                $this->data['all_sucursales'] = $this->sucursal_model->viewSucursales_activas_asc();
                //$this->data['tipos_doc'] = $this->transacciones_model->getDefinicionesIvaBook(1);
                $this->data['tipos_doc'] = $this->transacciones_model->getTransaccionesBook($opcionmenu);
                $this->load->model('global_model');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
				$this->data['opcionmenu'] = $opcionmenu;
                $seleccionadas = str_replace(",", "_", $opcionmenu);
                $this->data['seleccionadas'] = $seleccionadas;
                $this->load->view('mantenimiento_book01', $this->data);
            }
        }
        
        function book02(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'opcionmenu' => $opcionmenu,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('sucursal_model');
                $this->load->model('transacciones_model');
                $this->data['tipos_doc'] = $this->transacciones_model->getTransaccionesBook($opcionmenu);
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva_Tipo(1);
                $this->data['all_sucursales'] = $this->sucursal_model->viewSucursales_activas_asc();
                $this->load->model('global_model');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['opcionmenu'] = $opcionmenu;
                $seleccionadas = str_replace(",", "_", $opcionmenu);
                $this->data['seleccionadas'] = $seleccionadas;
                $this->load->view('mantenimiento_book02', $this->data);
            }
        }
        
        function book03(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'opcionmenu' => $opcionmenu,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('sucursal_model');
                $this->load->model('transacciones_model');
                $this->data['tipos_doc'] = $this->transacciones_model->getTransaccionesBook($opcionmenu);
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva_Tipo(1);
                $this->data['all_sucursales'] = $this->sucursal_model->viewSucursales_activas_asc();
                $this->load->model('global_model');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['opcionmenu'] = $opcionmenu;
                $seleccionadas = str_replace(",", "_", $opcionmenu);
                $this->data['seleccionadas'] = $seleccionadas;
                $this->load->view('mantenimiento_book03', $this->data);
            }
        }  
        
        function getVentasCF(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);

                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $formatos = $this->input->post('formatos');
                
                $this->load->model('iva_model');
                $this->load->model('invtran_model');
                $information = $this->iva_model->getVentasC($fechaini,$fechafin,$idcentro,$formatos);
                
                $i=0;
                $array = array();
                foreach($information as $info){
                    #$exento=0; $gravado=0;
                    #if($info->exento==1){
                        #$exento = $info->valventan;
                    #}else{
                        //$gravado = ($info->valtax1 / 0.13);
                        //$exento = $info->valventan-$gravado;
                        #$gravado = $info->valventan;
                    #}
                    $total = 0; $totalGravado = 0; $totalExento = 0;
                    $totalIVA = 0; $invexento = $info->exento;
                    
                    $productos = $this->invtran_model->getDataTran100kIva($info->trannum);
                    
                    foreach($productos as $pro){
                        if($pro->tipotax != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * ($pro->cantidad * -1));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * ($pro->cantidad * -1));
                            $totalGravado = $totalGravado + $pro->precioneto * ($pro->cantidad * -1);
                        }else if($pro->tipotax != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * ($pro->cantidad * -1)));
                            $totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
                        }else if($pro->tipotax == 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
                            $totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
                        }else if($pro->tipotax == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
                            $totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
                        }
                    }
                    
                    $array[$i] = array(
                        "idcentro"      => $info->idcentro,
                        "idcaja"        => $info->idcaja,
                        "clase"         => $info->idclaxpos,
                        "trannum"       => $info->trannum,
                        "fecha"         => $info->fecha,
                        "estatus"       => $info->estatus,
                        "numeroserie"   => $info->numeroserie,
                        "serie"         => $info->serie,
                        "numero"        => $info->numero,
                        "numz"          => $info->numz,
                        "invclase"      => $info->invclase,
                        "exento"        => $totalExento,
                        "gravado"       => $totalGravado + $totalIVA,
                        "gravadoNoIva"  => $totalGravado,
                        "valIva"        => $info->valtax1,
                        "nrc"           => $info->nrc,
                        "tipodoc"       => $info->tipodoc,
                        "namecliente"   => $info->namecliente,
                        "namevendedor"  => $info->namevendedor,
                        "total"         => $total
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
        function getVentasC(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $formatos = $this->input->post('formatos');
                
                $this->load->model('iva_model');
                $this->load->model('invtran_model');
                $information = $this->iva_model->getVentasContribuyentes($fechaini,$fechafin,$idcentro,$formatos);
                
                $array = array();
                $i=0;
                
                foreach($information as $info){
                    #$exento=0; $gravado=0; $retencion=0;
                    #if($info->exento==1){
                        #$exento = $info->valventan;
                    #}else{
                        #$gravado = $info->valventan;
                    #}
                    #$iva=$info->valtax1;
                    
                    $total = 0; $totalGravado = 0; $totalExento = 0;
                    $totalIVA = 0; $invexento = $info->exento; $retencion = 0;
                    
                    $productos = $this->invtran_model->getDataTran100kIva($info->trannum);
                    
                    foreach($productos as $pro){
                        if($pro->tipotax != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * ($pro->cantidad * -1));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * ($pro->cantidad * -1));
                            $totalGravado = $totalGravado + $pro->precioneto * ($pro->cantidad * -1);
                        }else if($pro->tipotax != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * ($pro->cantidad * -1)));
                            $totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
                        }else if($pro->tipotax== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
                            $totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
                        }else if($pro->tipotax == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
                            $totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
                        }
                    }

                    if(($info->idtipo == 3) && ($totalGravado >= 100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = number_format(round($reten, 4), 2);
                        $total = $total - $reten;
                    }
                    
                    $array[$i] = array(
                        "idcentro"      => $info->idcentro,
                        "idcaja"        => $info->idcaja, 
                        "clase"         => $info->idclaxpos, 
                        "numz"          => $info->numz, 
                        "trannum"       => $info->trannum,
                        "fecha"         => $info->fecha,
                        "estatus"       => $info->estatus,
                        "numeroserie"   => $info->numeroserie,
                        "serie"         => $info->serie,
                        "numero"        => $info->numero,
                        "invclase"      => $info->invclase,
                        #"exento"        => $exento,
                        "exento"        => $totalExento,
                        #"gravado"       => $gravado,
                        "gravado"       => $totalGravado,
                        "nosujetas"     => 0,
                        #"iva"           => $iva,
                        "iva"           => $totalIVA,
                        "nrc"           => $info->nrc,
                        "tipodoc"       => $info->tipodoc,
                        "namecliente"   => $info->namecliente,
                        "namevendedor"  => $info->namevendedor,
                        "retencion"     => $retencion,
                        "total"         => $total
                    );
                    $i++;
                }

                echo json_encode($array);
            }
        }
        
        function getCompras(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $formatos = $this->input->post('formatos');
                $this->load->model('iva_model');
                $information = $this->iva_model->getComprasContribuyentesIva($fechaini,$fechafin,$idcentro,$formatos);
                
                $array = array();
                $i=0;
                
                foreach($information as $info){
                    $exento=0;
                    $gravado=0;
                    if($info->exento==1){
                        $exento = $info->valcosto;
                    }else{
                        $gravado = $info->valcosto;
                    }
                    $iva=$info->valtax1;
                    
                    $array[$i] = array(
                        "trannum"=>$info->trannum,
                        "fecha"=>$info->fecha,
                        "estatus"=>$info->estatus,
                        "numeroserie"=>$info->numeroserie,
                        "serie"=>$info->serie,
                        "numero"=>$info->numero,
                        "invclase"=>$info->invclase,
                        "exento"=>$exento,
                        "gravado"=>$gravado,
                        "nosujetas"=>0,
                        "iva"=>$iva,
                        "nrc"=>$info->nrc,
                        "tipodoc"=>$info->tipodoc,
                        "namecliente"=>$info->namecliente,
                        "namevendedor"=>$info->namevendedor,
                        "total"=>$exento+$gravado+$iva,
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
        function mantenimientoIvaCentral($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('configuracion_model');
                
                $appName    = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);

                $resultAppName = array(
                    'iddApp'   => $idApp,
                    'appName'  => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);

                $this->data['ivac_dte'] = ( $opcionmenu == '' ) ? 0 : $opcionmenu;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
				$this->load->view('mantenimiento_iva_central', $this->data);
            }
        }

        function getPeriodosIVA(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('iva_model');
                $array = $this->iva_model->getPeriodosIVA();

                echo json_encode($array);
            }
        }

        function insertPeriodo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $namePeriodo = $this->input->post('namePeriodo');
                $notaPeriodo = $this->input->post('notaPeriodo');

                $this->load->model('iva_model');
                if($this->iva_model->insertPeriodo($namePeriodo, $notaPeriodo)){
                    $array = $this->iva_model->getPeriodosIVA();
                } else $array = false;

                echo json_encode($array);
            }
        }

        function getDatosDocumentos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idano      = $this->input->post('idano');
                $idlibro    = $this->input->post('idlibro');
                $idanomes   = $this->input->post('idanomes');
                $dteDocumen = $this->input->post('dteDocumen');

                $this->load->model('iva_model');
                $array = $this->iva_model->getDatosDocumentos($idano, $idanomes, $idlibro, $dteDocumen);

                echo json_encode($array);
            }
        }
        
        function updatePeriodo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ivPeriodo   = $this->input->post('ivPeriodo');
                $namePeriodo = $this->input->post('namePeriodo');
                $notaPeriodo = $this->input->post('notaPeriodo');

                $this->load->model('iva_model');
                if($this->iva_model->updatePeriodo($ivPeriodo, $namePeriodo, $notaPeriodo)){
                    $array = $this->iva_model->getPeriodosIVA();
                } else $array = false;

                echo json_encode($array);
            }
        }

        function deletePeriodo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ivPeriodo   = $this->input->post('ivPeriodo');
                $namePeriodo = $this->input->post('namePeriodo');

                $this->load->model('iva_model');
                if($this->iva_model->deletePeriodo($ivPeriodo, $namePeriodo)){
                    $array = $this->iva_model->getPeriodosIVA();
                } else $array = false;

                echo json_encode($array);
            }
        }

        function getDocumentosLibro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idLibro = $this->input->post('idLibro');
                $dteDocumen = $this->input->post('dteDocumen');

                $this->load->model('iva_model');
                $documentos = $this->iva_model->getDocumentosLibro($idLibro, $dteDocumen);
                $sucursales = $this->iva_model->getSucursalesDocumento();
                
                $array = array(
                    "documentos" => $documentos,
                    "sucursales" => $sucursales
                );
                
                echo json_encode($array);
            }
        }
        
        function getDocumentosLibroExcel(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idLibro = $this->input->post('idLibro');
                $dteDocumen = $this->input->post('dteDocumen');

                $this->load->model('iva_model');
                $documentos = $this->iva_model->getDocumentosLibro($idLibro, $dteDocumen);
                $sucursales = ($idLibro == 3 || $idLibro == 4) ? $this->iva_model->getSucursalesDocumento() : $this->iva_model->getSucursalesDocumentoImport();
                
                $array = array(
                    "documentos" => $documentos,
                    "sucursales" => $sucursales
                );
                
                echo json_encode($array);
            }
        }
        
        function getAuxiliaresLibroExcel(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idLibro = $this->input->post('idLibro');

                $this->load->model('iva_model');
                $idauxidef  = ($idLibro == 3 || $idLibro == 4) ? '1' : '2';
                $auxiliares = $this->iva_model->getClientesProveedoresDocumentos($idauxidef);
                
                $array = array(
                    "auxiliares" => $auxiliares,
                );
                
                echo json_encode($array);
            }
        }
        
        function getDocumentosLibroImport(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idLibro  = $this->input->post('idLibro');
                $isTicket = $this->input->post('isTicket');

                $this->load->model('iva_model');
                $documentos = $this->iva_model->getDocumentosLibroImport($idLibro, $isTicket);
                $sucursales = $this->iva_model->getSucursalesDocumento();
                
                $array = array(
                    "documentos" => $documentos,
                    "sucursales" => $sucursales
                );
                
                echo json_encode($array);
            }
        }
        
        function getDocumentosLibroCSV(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idLibro  = $this->input->post('idLibro');
                $dteDocumen  = $this->input->post('dteDocumen');
                
                $this->load->model('iva_model');
                $documentos = $this->iva_model->getDocumentosLibroCSV($idLibro, $dteDocumen);
                $sucursales = $this->iva_model->getSucursalesDocumento();
                
                $array = array(
                    "documentos" => $documentos,
                    "sucursales" => $sucursales
                );
                
                echo json_encode($array);
            }
        }

        function getCajaSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');

                $this->load->model('iva_model');
                $array = $this->iva_model->getCajaSucursal($idcentro);

                echo json_encode($array);
            }
        }

        function getCamposFormulario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ivclase   = $this->input->post('ivclase');
                $idauxidef = $this->input->post('idauxidef');

                $this->load->model('iva_model');
                $formulario = $this->iva_model->getCamposFormulario($ivclase);
                $clienprove = $this->iva_model->getClientesProveedoresDocumentos($idauxidef);

                $array = array(
                    "formulario" => $formulario,
                    "clienprove" => $clienprove
                );

                echo json_encode($array);
            }
        }

        function getInfoResolucionSerie(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idlibro = $this->input->post('idlibro');
                $ivclase = $this->input->post('ivclase');
                $idauxi  = $this->input->post('idauxi');
                $idano   = $this->input->post('idano');

                $this->load->model('iva_model');
                $array = $this->iva_model->getInfoResolucionSerie($idano, $idlibro, $ivclase ,$idauxi);

                echo json_encode($array);
            }
        }

        function saveDatosDocumento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $dteDoc = $this->input->post('dteDocumentos');

                $this->load->model('iva_model');
                $filedExist = $this->iva_model->checkIfDocClaseFieldExists($this->input->post('idano'));

                $doc_tipo = ($this->input->post('doc_tipo') == false) ? 0 : $this->input->post('doc_tipo'); 

                if($filedExist == true){

                    $cGeneracion = ($this->input->post('codGeneracionDTE') == false) ? '' : $this->input->post('codGeneracionDTE');

                    $infoSource = array(
                        'idanomes'   => $this->input->post('idanomes'), 
                        'idlibro'    => $this->input->post('idlibro'),
                        'ivclase'    => $this->input->post('ivclase'),
                        'idcentro'   => $this->input->post('idcentro'),
                        'idcaja'     => $this->input->post('idcaja'),
                        'fecha'      => date_create()->format('Y-m-d'),
                        'doc_tipo'   => ($this->input->post('doc_tipo') == false) ? 0 : $this->input->post('doc_tipo'),
                        'doc_clase'  => ($this->input->post('doc_clase') == false) ? '' : $this->input->post('doc_clase'),
                        'doc_fecha'  => $this->input->post('doc_fecha'),
                        'doc_res'    => trim($this->input->post('doc_res')),
                        'doc_serie'  => trim($this->input->post('doc_serie')),
                        'doc_numero' => ( $doc_tipo == 1 ) ? $cGeneracion : trim($this->input->post('doc_numero')),
                        //'doc_numero' => trim($this->input->post('doc_numero')),
                        'doc_funico' => trim($this->input->post('doc_funico')),
                        'referencia' => trim($this->input->post('referencia')),
                        'idcps'      => $this->input->post('idcps'),
                        'notas'      => ( $dteDoc == 1 ) ? $this->input->post('dataDocumento') : $this->input->post('notas'),
                        'valor0'     => $this->input->post('valor0'),
                        'valor1'     => $this->input->post('valor1'),
                        'valor2'     => $this->input->post('valor2'),
                        'valor3'     => $this->input->post('valor3'),
                        'valor4'     => $this->input->post('valor4'),
                        'valor5'     => $this->input->post('valor5'),
                        'valor6'     => $this->input->post('valor6'),
                        'valor7'     => $this->input->post('valor7'),
                        'valor8'     => $this->input->post('valor8'),
                        'valor9'     => $this->input->post('valor9'),
                        'valor10'    => $this->input->post('valor10'),
                        'valor11'    => $this->input->post('valor11'),
                        'valor12'    => $this->input->post('valor12'),
                        'valor13'    => $this->input->post('valor13'),
                        'valor14'    => $this->input->post('valor14'),
                        'valor15'    => $this->input->post('valor15'),
                        'valor16'    => $this->input->post('valor16'),
                        'valor17'    => $this->input->post('valor17'),
                        'valor18'    => $this->input->post('valor18'),
                        'valor19'    => $this->input->post('valor19'),
                        'valor20'    => $this->input->post('valor20'),
                        'origen'     => 'Iva_Central.Editor',
                        'estatus'    => 1,
                        'whodidit'   => $this->session->userdata('iduser'),
                        'ingresa'    => date_create()->format('Y-m-d H:i:s'),
                    );
                }else {
                    $infoSource = array(
                        'idanomes'   => $this->input->post('idanomes'), 
                        'idlibro'    => $this->input->post('idlibro'),
                        'ivclase'    => $this->input->post('ivclase'),
                        'idcentro'   => $this->input->post('idcentro'),
                        'idcaja'     => $this->input->post('idcaja'),
                        'fecha'      => date_create()->format('Y-m-d'),
                        'doc_fecha'  => $this->input->post('doc_fecha'),
                        'doc_res'    => trim($this->input->post('doc_res')),
                        'doc_serie'  => trim($this->input->post('doc_serie')),
                        'doc_numero' => trim($this->input->post('doc_numero')),
                        'doc_funico' => trim($this->input->post('doc_funico')),
                        'referencia' => trim($this->input->post('referencia')),
                        'idcps'      => $this->input->post('idcps'),
                        'notas'      => ( $dteDoc == 1 ) ? $this->input->post('dataDocumento') : $this->input->post('notas'),
                        'valor0'     => $this->input->post('valor0'),
                        'valor1'     => $this->input->post('valor1'),
                        'valor2'     => $this->input->post('valor2'),
                        'valor3'     => $this->input->post('valor3'),
                        'valor4'     => $this->input->post('valor4'),
                        'valor5'     => $this->input->post('valor5'),
                        'valor6'     => $this->input->post('valor6'),
                        'valor7'     => $this->input->post('valor7'),
                        'valor8'     => $this->input->post('valor8'),
                        'valor9'     => $this->input->post('valor9'),
                        'valor10'    => $this->input->post('valor10'),
                        'valor11'    => $this->input->post('valor11'),
                        'valor12'    => $this->input->post('valor12'),
                        'valor13'    => $this->input->post('valor13'),
                        'valor14'    => $this->input->post('valor14'),
                        'valor15'    => $this->input->post('valor15'),
                        'valor16'    => $this->input->post('valor16'),
                        'valor17'    => $this->input->post('valor17'),
                        'valor18'    => $this->input->post('valor18'),
                        'valor19'    => $this->input->post('valor19'),
                        'valor20'    => $this->input->post('valor20'),
                        'origen'     => 'Iva_Central.Editor',
                        'estatus'    => 1,
                        'whodidit'   => $this->session->userdata('iduser'),
                        'ingresa'    => date_create()->format('Y-m-d H:i:s'),
                    );
                }

                $array = $this->iva_model->saveDatosDocumento($infoSource, $this->input->post('idano'));
                
                if ($doc_tipo == 1) {
                    if ($array != false) {
                        $numControlDTE    = ($this->input->post('numControlDTE') == false) ? '' : $this->input->post('numControlDTE');
                        $codGeneracionDTE = ($this->input->post('codGeneracionDTE') == false) ? '' : $this->input->post('codGeneracionDTE');
                        $selloRecepcion   = ($this->input->post('selloRecepcion') == false) ? '' : $this->input->post('selloRecepcion');

                        $this->load->model('dte_model');
                        $this->dte_model->updateDatosDTE($array, $numControlDTE, $codGeneracionDTE, $selloRecepcion, '', '', '', 1, 1, $this->input->post('idano'));
                    }
                }

                if ( $dteDoc == 1 ) {
                    $idclase = $this->input->post('invclase');
                    
                    $numTipo = $this->iva_model->getNumTipoTransaccion($idclase);
                    if ( $numTipo == 1) {            //Empresa
                        $this->iva_model->updateNumerosFacturasEmpresa($idclase);
                    } else if ( $numTipo == 2 ) {    //Sucursal
                        $this->iva_model->updateNumerosFacturasSucursal($idclase, $this->input->post('idcentro'));
                    } else if ( $numTipo == 3 ) {    //Caja
                        $this->iva_model->updateNumerosFacturas($idclase, $this->input->post('idcentro'), $this->input->post('idcaja'));
                    }
                }

                echo json_encode($array);
            }
        }
        
        function updateDatosDocumento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $dteDoc = $this->input->post('dteDocumentos');
                
                $this->load->model('iva_model');
                $filedExist = $this->iva_model->checkIfDocClaseFieldExists($this->input->post('idano'));

                $doc_tipo = ($this->input->post('doc_tipo') == false) ? 0 : $this->input->post('doc_tipo'); 

                if($filedExist == true){
                    $infoSource = array(
                        'idanomes'   => $this->input->post('idanomes'), 
                        'idlibro'    => $this->input->post('idlibro'),
                        'ivclase'    => $this->input->post('ivclase'),
                        'idcentro'   => $this->input->post('idcentro'),
                        'idcaja'     => $this->input->post('idcaja'),
                        'doc_fecha'  => $this->input->post('doc_fecha'),
                        'doc_res'    => trim($this->input->post('doc_res')),
                        'doc_serie'  => trim($this->input->post('doc_serie')),
                        'doc_numero' => trim($this->input->post('doc_numero')),
                        'doc_funico' => trim($this->input->post('doc_funico')),
                        'doc_tipo'   => ($this->input->post('doc_tipo') == false) ? '' : $this->input->post('doc_tipo'),
                        'doc_clase'  => ($this->input->post('doc_clase') == false) ? '' : $this->input->post('doc_clase'),
                        'referencia' => trim($this->input->post('referencia')),
                        'idcps'      => $this->input->post('idcps'),
                        'notas'      => ( $dteDoc == 1 ) ? $this->input->post('dataDocumento') : $this->input->post('notas'),
                        'valor0'     => $this->input->post('valor0'),
                        'valor1'     => $this->input->post('valor1'),
                        'valor2'     => $this->input->post('valor2'),
                        'valor3'     => $this->input->post('valor3'),
                        'valor4'     => $this->input->post('valor4'),
                        'valor5'     => $this->input->post('valor5'),
                        'valor6'     => $this->input->post('valor6'),
                        'valor7'     => $this->input->post('valor7'),
                        'valor8'     => $this->input->post('valor8'),
                        'valor9'     => $this->input->post('valor9'),
                        'valor10'    => $this->input->post('valor10'),
                        'valor11'    => $this->input->post('valor11'),
                        'valor12'    => $this->input->post('valor12'),
                        'valor13'    => $this->input->post('valor13'),
                        'valor14'    => $this->input->post('valor14'),
                        'valor15'    => $this->input->post('valor15'),
                        'valor16'    => $this->input->post('valor16'),
                        'valor17'    => $this->input->post('valor17'),
                        'valor18'    => $this->input->post('valor18'),
                        'valor19'    => $this->input->post('valor19'),
                        'valor20'    => $this->input->post('valor20'),
                        'whodidit'   => $this->session->userdata('iduser'),
                        'modifica'   => date_create()->format('Y-m-d H:i:s'),
                    );
                }else {
                    $infoSource = array(
                        'idanomes'   => $this->input->post('idanomes'), 
                        'idlibro'    => $this->input->post('idlibro'),
                        'ivclase'    => $this->input->post('ivclase'),
                        'idcentro'   => $this->input->post('idcentro'),
                        'idcaja'     => $this->input->post('idcaja'),
                        'doc_fecha'  => $this->input->post('doc_fecha'),
                        'doc_res'    => trim($this->input->post('doc_res')),
                        'doc_serie'  => trim($this->input->post('doc_serie')),
                        'doc_numero' => trim($this->input->post('doc_numero')),
                        'doc_funico' => trim($this->input->post('doc_funico')),
                        'referencia' => trim($this->input->post('referencia')),
                        'idcps'      => $this->input->post('idcps'),
                        'notas'      => ( $dteDoc == 1 ) ? $this->input->post('dataDocumento') : $this->input->post('notas'),
                        'valor0'     => $this->input->post('valor0'),
                        'valor1'     => $this->input->post('valor1'),
                        'valor2'     => $this->input->post('valor2'),
                        'valor3'     => $this->input->post('valor3'),
                        'valor4'     => $this->input->post('valor4'),
                        'valor5'     => $this->input->post('valor5'),
                        'valor6'     => $this->input->post('valor6'),
                        'valor7'     => $this->input->post('valor7'),
                        'valor8'     => $this->input->post('valor8'),
                        'valor9'     => $this->input->post('valor9'),
                        'valor10'    => $this->input->post('valor10'),
                        'valor11'    => $this->input->post('valor11'),
                        'valor12'    => $this->input->post('valor12'),
                        'valor13'    => $this->input->post('valor13'),
                        'valor14'    => $this->input->post('valor14'),
                        'valor15'    => $this->input->post('valor15'),
                        'valor16'    => $this->input->post('valor16'),
                        'valor17'    => $this->input->post('valor17'),
                        'valor18'    => $this->input->post('valor18'),
                        'valor19'    => $this->input->post('valor19'),
                        'valor20'    => $this->input->post('valor20'),
                        'whodidit'   => $this->session->userdata('iduser'),
                        'modifica'   => date_create()->format('Y-m-d H:i:s'),
                    );
                }

                if ($doc_tipo == 1) {
                    if ($this->input->post('dteCodigo') != '' && $this->input->post('dteCodigo') != '0') {
                        $idDTE = $this->input->post('dteCodigo');
                        $numControlDTE    = ($this->input->post('numeroControl') == false) ? '' : $this->input->post('numeroControl');
                        $codGeneracionDTE = ($this->input->post('codigoGeneracion') == false) ? '' : $this->input->post('codigoGeneracion');
                        $selloRecepcion   = ($this->input->post('selloRecibido') == false) ? '' : $this->input->post('selloRecibido');
    
                        $this->load->model('dte_model');
                        $this->dte_model->modificarInformacionDTE($numControlDTE, $codGeneracionDTE, $selloRecepcion, $idDTE);
                    } else {
                        $numControlDTE    = ($this->input->post('numeroControl') == false) ? '' : $this->input->post('numeroControl');
                        $codGeneracionDTE = ($this->input->post('codigoGeneracion') == false) ? '' : $this->input->post('codigoGeneracion');
                        $selloRecepcion   = ($this->input->post('selloRecibido') == false) ? '' : $this->input->post('selloRecibido');
    
                        $this->load->model('dte_model');
                        $this->dte_model->updateDatosDTE($this->input->post('idrec'), $numControlDTE, $codGeneracionDTE, $selloRecepcion, '', '', '', 1, 1, $this->input->post('idano'));
                    }
                }

                $array = $this->iva_model->updateDatosDocumento($infoSource, $this->input->post('idano'), $this->input->post('idrec'), $doc_tipo);

                echo json_encode($array);
            }
        }

        function deleteDocumento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('iva_model');
                $array = $this->iva_model->deleteDocumento($this->input->post('idrec'), $this->input->post('idano'));
                
                echo json_encode($array);
            }
        }

        function getDatosAuxiliar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxidef = $this->input->post('idauxidef');
                
                $this->load->model('iva_model');
                $tiposauxiliar = $this->iva_model->getTiposAuxiliar($idauxidef);
                $departamentos = $this->iva_model->getDepartamentosMunicipio();
                $infogiros     = $this->iva_model->getGirosContribuyentes();

                $array = array(
                    'tiposauxiliar' => $tiposauxiliar,
                    'departamentos' => $departamentos,
                    'infogiros'     => $infogiros
                );

                echo json_encode($array);
            }
        }

        function getDatosAuxiliarById(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxidef = $this->input->post('idauxidef');
                $idauxi = $this->input->post('idauxi');

                $this->load->model('auxi_model');
                $this->load->model('iva_model');

                $auxi = $this->auxi_model->getInfoAuxi($idauxi);
                $tiposauxiliar = $this->iva_model->getTiposAuxiliar($idauxidef);
                $departamentos = $this->iva_model->getDepartamentosMunicipio();
                $infogiros     = $this->iva_model->getGirosContribuyentes();

                $array = array(
                    'auxi' => $auxi,
                    'tiposauxiliar' => $tiposauxiliar,
                    'departamentos' => $departamentos,
                    'infogiros'     => $infogiros
                );

                echo json_encode($array);
            }
        }

        function saveDatosAuxiliar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $infoSource = array(
                    'descrip'   => trim($this->input->post('descrip')),
                    'idauxidef' => $this->input->post('idauxidef'),
                    'direccion' => trim($this->input->post('direccion')),
                    'idzip'     => $this->input->post('idzip'),
                    'fechain'   => date_create()->format('Y-m-d'),
                    'nrc'       => trim($this->input->post('nrc')),
                    'dui'       => trim($this->input->post('dui')),
                    'nit'       => trim($this->input->post('nit')),
                    'giro'      => $this->input->post('giro'),
                    'idtipo'    => $this->input->post('idtipo'),
                    'estado'    => 1,
                    'whodidit'  => $this->session->userdata('iduser'),
                    'ingresa'   => date_create()->format('Y-m-d H:i:s'),
                );

                $this->load->model('iva_model');
                
                $mensaje = "";
                $existe = $this->iva_model->verificaExisteAuxiliar($this->input->post('nit'), $this->input->post('nrc'));

                if($existe){
                    $mensaje = "¡Error! Ya existe un registro con ese NIT o NRC.";
                    echo json_encode(["mensaje"=>$mensaje, "resultado"=>false]);
                    return null;
                }

                $array = $this->iva_model->saveDatosAuxiliar($infoSource);

                if($array){
                    $mensaje = '¡Contribuyente adicionado correctamente!';
                }else{
                    $mensaje = '!Ha ocurrido un error con el ingreso del registro!';
                }

                echo json_encode(["mensaje"=>$mensaje, "resultado"=>$array]);
            }
        }

        function updateDatosAuxiliar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $infoSource = array(
                    'descrip'   => trim($this->input->post('descrip')),
                    'idauxidef' => $this->input->post('idauxidef'),
                    'direccion' => trim($this->input->post('direccion')),
                    'idzip'     => $this->input->post('idzip'),
                    'nrc'       => trim($this->input->post('nrc')),
                    'dui'       => trim($this->input->post('dui')),
                    'nit'       => trim($this->input->post('nit')),
                    'giro'      => $this->input->post('giro'),
                    'idtipo'    => $this->input->post('idtipo'),
                    'whodidit'  => $this->session->userdata('iduser'),
                    'modifica'   => date_create()->format('Y-m-d H:i:s'),
                );

                $this->load->model('iva_model');
                $mensaje = "";
                $existe = $this->iva_model->verificaExisteAuxiliar($this->input->post('nit'), $this->input->post('nrc'), $this->input->post('idauxi'));

                if($existe){
                    $mensaje = "¡Error! Ya existe un registro con ese NIT o NRC.";
                    echo json_encode(["mensaje"=>$mensaje, "resultado"=>false]);
                    return null;
                }

                $array = $this->iva_model->updateDatosAuxiliar($infoSource, $this->input->post('idauxi'));
                
                if($array){
                    $mensaje = '¡Contribuyente editado correctamente!';
                }else{
                    $mensaje = '!Ha ocurrido un error con la modificación del registro!';
                }

                echo json_encode(["mensaje"=>$mensaje, "resultado"=>$array]);
            }
        }

        function getDatosGoXposImport(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclases = $this->input->post('idclases');
                $idcentro = $this->input->post('idcentro');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $isticket = $this->input->post('isticket');
                $idlibro  = $this->input->post('idlibro');
                $idano    = $this->input->post('idano');

                $this->load->model('iva_model');

                switch ($idlibro) {
                    case 1:
                        if ( $isticket == 1 ) {
                            $array = $this->iva_model->getDatosGoXposImportTickets($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin);
                        } else {
                            $array = $this->iva_model->getDatosGoXposImportVentasCF($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin);
                        }
                        break;
                    case 2:
                        $array = $this->iva_model->getDatosGoXposImportVentasCCF($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin);
                        break;
                    case 3:
                        if ( $isticket == 2 ) {
                            $array = $this->iva_model->getDatosGoXposImportGastosCCF($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin);
                        } else {
                            $array = $this->iva_model->getDatosGoXposImportComprasCCF($idlibro, $idano, $idclases, $idcentro, $fechaini, $fechafin);
                        }
                        break;
                    case 4:
                        $array[] = false;
                        break;
                    default:
                        $array[] = false;
                        break;
                }
                
                echo json_encode($array);
            }
        }

        function imporDatosGoXpos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclases = $this->input->post('idclases');
                $idcentro = $this->input->post('idcentro');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $isticket = $this->input->post('isticket');
                $idlibro  = $this->input->post('idlibro');
                $codemes  = $this->input->post('codemes');
                $idano    = $this->input->post('idano');
                $idoperacion = $this->input->post('idoperacion');
                $idingreso = $this->input->post('idingreso');
                
                $this->load->model('iva_model');

                switch ($idlibro) {
                    case 1:
                        if ( $isticket == 1 ) {
                            $array = $this->iva_model->goXposImportTickets($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin);
                        } else {
                            $array = $this->iva_model->goXposImportVentasCF($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin, $idoperacion, $idingreso);
                        }
                        break;
                    case 2:
                        $array = $this->iva_model->goXposImportVentasCCF($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin, $idoperacion, $idingreso);
                        break;
                    case 3:
                        if ( $isticket == 2 ) {
                            $array = $this->iva_model->goXposImportGastosCCF($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin);
                        } else {
                            $array = $this->iva_model->goXposImportComprasCCF($idlibro, $idano, $codemes, $idclases, $idcentro, $fechaini, $fechafin);
                        }
                        break;
                    case 4:
                        $array[] = false;
                        break;
                    default:
                        $array[] = false;
                        break;
                }
                
                echo json_encode($array);
            }
        }

        function inicializarLibro() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $password = $this->input->post('password');
                $idano    = $this->input->post('idano');
                $idanomes = $this->input->post('idanomes');
                $idlibro  = $this->input->post('idlibro');
                
                $this->load->model('iva_model');
                
                echo json_encode($this->iva_model->inicializarLibro($password, $idano, $idanomes, $idlibro));
            }
        }

        function verificarFormatoImpresion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ivclase = $this->input->post('ivclase');
                
                $this->load->model('iva_model');
                echo json_encode($this->iva_model->verificarFormatoImpresion($ivclase));
            }
        }

        function getAuxiliarPorDocumento($auxiliarNRC, $auxiliarNIT, $auxiliarDUI) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('iva_model');
                return json_encode($this->iva_model->getAuxiliarPorDocumento($auxiliarNRC, $auxiliarNIT, $auxiliarDUI));
            }
        }

        function informacionArchivoImportacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                try {
                    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);                    
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                
                $tipolibro = $this->input->post('tipoLibro');

                $objPHPExcel->setActiveSheetIndex(0); 
                
                $sheet         = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow    = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();

                if ($highestRow > 2) {
                    $Datos = [];
                    $arraySucursales = [];
                    $arrayDocumentos = [];
                    $arrayAuxiliares = [];

                    for ($row = 2; $row <= $highestRow; $row++) {
                        $rowData = $sheet->rangeToArray('A' . $row . ':N' . $row,NULL,TRUE,FALSE);
                        $rowData = $rowData[0];
                        
                        $nameDocumento = strtoupper(trim($rowData[0]));
                        $nameSucursal  = strtoupper(trim($rowData[1]));
                        $nameCaja      = strtoupper(trim($rowData[2]));
                        
                        $nameAuxiliar  = strtoupper(trim($rowData[9]));
                        $auxiliarNRC   = trim($rowData[10]);
                        $auxiliarNIT   = trim($rowData[11]);
                        $auxiliarDUI   = trim($rowData[12]);

                        $arraySucursales[] = ($tipolibro == 3) ? array('nameSucursal' => $nameSucursal) : array('nameSucursal' => $nameSucursal .' / '. $nameCaja);
                        $arrayDocumentos[] = array('nameDocumento' => $nameDocumento);
                        $arrayAuxiliares[] = array('descrip' => $nameAuxiliar, 'nrc' => $auxiliarNRC, 'nit' => $auxiliarNIT, 'dui' => $auxiliarDUI, 'idauxi' => (int) $this->getAuxiliarPorDocumento($auxiliarNRC, $auxiliarNIT, $auxiliarDUI));
                    }
                    
                    $uSucursales = array_merge(array_unique($arraySucursales, SORT_REGULAR));
                    $uDocumentos = array_merge(array_unique($arrayDocumentos, SORT_REGULAR));
                    $uAuxiliares = array_merge(array_unique($arrayAuxiliares, SORT_REGULAR));

                    $datA[] = array('valido' => true, 'tipo' => 1, 'sucursales' => $uSucursales, 'documentos' => $uDocumentos, 'auxiliares' => $uAuxiliares);
                } else $datA[] = array('valido' => false, 'tipo' => 0);
                echo json_encode($datA);
            }
        }

        function validarDatosArchivoImportacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                try {
                    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);                    
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                
                $objPHPExcel->setActiveSheetIndex(0); 
                $tipolibro = $this->input->post('tipoLibro');
                $maxdate = $this->input->post('maxdate');
                $mindate = "";

                if($tipolibro == "1" || $tipolibro == "2"){
                    $mindate = $this->input->post('mindate');
                }else{
                    $mindate = date('YYYY-MM-DD', strtotime("-2 months", strtotime($this->input->post('mindate'))));
                }
                $sheet         = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow    = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();
                if ($highestRow > 2) {
                  
                    $Datos = [];
                    $i = 0;
                    $countError = 0;
                    $mensaje = "";

                    #   VALIDACION PRIMARIA
                    for ($row = 2; $row <= $highestRow; $row++) {
                        $i++;

                        $rowData = $sheet->rangeToArray('A' . $row . ':AC' . $row,NULL,TRUE,FALSE);
                        $rowData = $rowData[0];
                        
                        $nameDocumento = strtoupper(trim($rowData[0]));
                        $nameSucursal  = strtoupper(trim($rowData[1]));
                        $nameCaja      = strtoupper(trim($rowData[2]));

                        $docfecha  = trim($rowData[3]);
                        $docfecha  = \PhpOffice\PhpSpreadsheet\Style\NumberFormat::toFormattedString($docfecha, "YYYY-MM-DD");
                        $docResolucion  = strtoupper(trim($rowData[4]));
                        $docSerie  = strtoupper(trim($rowData[5]));
                        $docNum  = trim($rowData[6]);
                        $docFormUnico  = trim($rowData[7]);
                        $docNumCaja  = trim($rowData[8]);

                        $nameAuxiliar  = strtoupper(trim($rowData[9]));
                        $auxiliarNRC   = trim($rowData[10]);
                        $auxiliarNIT   = trim($rowData[11]);
                        $auxiliarDUI   = trim($rowData[12]);

                        $grav               = (float)trim($rowData[13]);
                        $exen               = (float)trim($rowData[14]);
                        $nsuj               = (float)trim($rowData[15]);
                        $reten              = (float)trim($rowData[16]);
                        $importgrav         = (float)trim($rowData[17]);
                        $importexen         = (float)trim($rowData[18]);
                        $reten2p            = (float)trim($rowData[19]);
                        $reteniva           = (float)trim($rowData[20]);
                        $importgravservicio = (float)trim($rowData[21]);
                        $internagrav        = (float)trim($rowData[22]);
                        $internaexen        = (float)trim($rowData[23]);
                        $montosuj           = (float)trim($rowData[24]);
                        $vtafranca          = (float)trim($rowData[25]);
                        $cotrans            = (float)trim($rowData[26]);
                        $fovial             = (float)trim($rowData[27]);
                        $iva                = (float)trim($rowData[28]);
                        $total = "";
                        $error = 0;

                        //validacion de fecha
                        //compra/dlc => 3 meses atras del mes del libro actual | venta => mes del libro
                        if((strtotime($docfecha) <= strtotime($maxdate)) && (strtotime($docfecha) >= strtotime($mindate))){
                            $total = $grav + $exen + $nsuj + $reten + $importgrav + $importexen + $reten2p + $reteniva + $importgravservicio + $internagrav + $internaexen + $montosuj + $vtafranca + $cotrans + $fovial + $iva;
                        }else { 
                            //$total = "La fecha del documento se encuentra fuera del rango de tiempo del libro IVA actual.\n";
                            $total = 0;
                            $nameDocumento = "La fecha del documento se encuentra fuera del rango de tiempo del libro IVA actual.";
                            $error++;
                            $countError++;
                        }

                        $Datos[]= array(
                            "num" => $i,
                            "docsuc" => $nameSucursal,
                            "doccaja" => $nameCaja,
                            "docfecha" => $docfecha,
                            "docname" => $nameDocumento,
                            "docnum" => $docSerie.$docNum,
                            "auxname" => $nameAuxiliar,
                            "total" => $total,
                            "error" => $error,
                        );
                    }

                    if($countError == 0){
                        $mensaje = "¡Los movimientos a importar se han validado correctamente!";
                    }else{
                        $mensaje = "¡Alerta! Uno o más movimientos presentan errores.";
                    }
                    $resultado = array("valido"=> true, "datos"=>$Datos, "mensaje"=>$mensaje, "countError" => $countError);
                } else $resultado = array("valido"=> false, "datos"=>[], "mensaje"=>"¡Error! El archivo debe contener al menos un movimiento a ser importado.", "countError" => 1);
                echo json_encode($resultado);
            }
        }

        function insertarDatosArchivoImportacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                try {
                    $inputFileType  = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader      = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel    = $objReader->load($_FILES['file']['tmp_name']);                    
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }

                $objPHPExcel->setActiveSheetIndex(0);
                
                $idlibro  = $this->input->post('idLibro');
                $codeYear = $this->input->post('codeYear');
                $codeMes  = $this->input->post('codeMes');

                $arraySucursales = json_decode($this->input->post('arraySucursales'));
                $arrayDocumentos = json_decode($this->input->post('arrayDocumentos'));
                $arrayAuxiliares = json_decode($this->input->post('arrayAuxiliares'));
                //var_dump($this->input->post('arrayAuxiliares'));

                $this->load->model('iva_model');
                
                $sheet         = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow    = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();
                
                if ($highestRow > 2) {
                  
                    $Datos = [];
                    $i = 0;
                    $countError = 0;
                    $mensaje = "";

                    #   VALIDACION PRIMARIA
                    for ($row = 2; $row <= $highestRow; $row++) {
                        $i++; $total = 0;

                        $rowData = $sheet->rangeToArray('A' . $row . ':AC' . $row, NULL, TRUE, FALSE);
                        $rowData = $rowData[0];
                        
                        $nameDocumento = strtoupper(trim($rowData[0]));
                        $nameSucursal  = strtoupper(trim($rowData[1]));
                        $nameCaja      = strtoupper(trim($rowData[2]));

                        $nameCajaSucur = ($idlibro == 3) ? $nameSucursal : $nameSucursal .' / '. $nameCaja;

                        $docfecha      = trim($rowData[3]);
                        $docfecha      = \PhpOffice\PhpSpreadsheet\Style\NumberFormat::toFormattedString($docfecha, "YYYY-MM-DD");
                        $docResolucion = strtoupper(trim($rowData[4]));
                        $docSerie      = strtoupper(trim($rowData[5]));
                        $docNum        = trim($rowData[6]);
                        $docFormUnico  = trim($rowData[7]);
                        $docNumCaja    = trim($rowData[8]);

                        $nameAuxiliar  = strtoupper(trim($rowData[9]));
                        $auxiliarNRC   = trim($rowData[10]);
                        $auxiliarNIT   = trim($rowData[11]);
                        $auxiliarDUI   = trim($rowData[12]);

                        $grav          = (float)trim($rowData[13]);
                        $exen          = (float)trim($rowData[14]);
                        $nsuj          = (float)trim($rowData[15]);
                        $reten         = (float)trim($rowData[16]);
                        $importgrav    = (float)trim($rowData[17]);
                        $importexen    = (float)trim($rowData[18]);
                        $reten2p       = (float)trim($rowData[19]);
                        $reteniva      = (float)trim($rowData[20]);
                        $importgravser = (float)trim($rowData[21]);
                        $internagrav   = (float)trim($rowData[22]);
                        $internaexen   = (float)trim($rowData[23]);
                        $montosuj      = (float)trim($rowData[24]);
                        $vtafranca     = (float)trim($rowData[25]);
                        $cotrans       = (float)trim($rowData[26]);
                        $fovial        = (float)trim($rowData[27]);
                        $iva           = (float)trim($rowData[28]);
                        
                        $idCentro     = ($idlibro == 3) ? $arraySucursales->{''.$nameCajaSucur.''} : $this->iva_model->getSucursalByCaja($arraySucursales->{''.$nameCajaSucur.''});
                        $idCaja       = ($idlibro == 3) ? 0 : $arraySucursales->{''.$nameCajaSucur.''};
                        $idDocumento  = $arrayDocumentos->{''.$nameDocumento.''};
                        $idAuxiliar   = $arrayAuxiliares->{''.$nameAuxiliar.''};

                        $infoInsert = array(
                            'idanomes'   => $codeMes,
                            'idlibro'    => (int) $idlibro,
                            'ivclase'    => (int) $idDocumento,
                            'idcentro'   => (int) $idCentro,
                            'idcaja'     => (int) $idCaja,
                            'fecha'      => date_create()->format('Y-m-d'),
                            'doc_fecha'  => $docfecha,
                            'doc_res'    => $docResolucion,
                            'doc_serie'  => $docSerie,
                            'doc_numero' => $docNum,
                            'idcps'      => $idAuxiliar,
                            'valor0'     => $iva,
                            'valor1'     => $grav,
                            'valor2'     => $exen,
                            'valor3'     => $nsuj,
                            'valor4'     => $reten,
                            'valor5'     => $importgrav,
                            'valor6'     => $importexen,
                            'valor7'     => $reten2p,
                            'valor8'     => $reteniva,
                            'valor9'     => $importgravser,
                            'valor10'    => $internagrav,
                            'valor11'    => $internaexen,
                            'valor12'    => $montosuj,
                            'valor13'    => $vtafranca,
                            'valor14'    => $cotrans,
                            'valor15'    => $fovial,
                            'estatus'    => 1,
                            'origen'     => 'Iva_Central.ImportExternos',
                            'whodidit'   => $this->session->userdata('iduser'),
                            'ingresa'    => date_create()->format('Y-m-d H:i:s'),
                        );
                        
                        $this->iva_model->insertarDatosArchivoImportacion($codeYear, $infoInsert);
                    }

                    if ($countError == 0) {
                        $mensaje = "¡Registros importados correctamente!";
                    } else {
                        $mensaje = "¡Alerta! Uno o más movimientos presentan errores.";
                    }
                    $resultado = array("valido" => true, "datos" => $Datos, "mensaje" => $mensaje, "countError" => $countError);

                } else $resultado = array("valido" => false, "datos" => [], "mensaje" => "¡Error! El archivo debe contener al menos un movimiento a ser importado.", "countError" => 1);

                echo json_encode($resultado);
            }
        }

        function getSerieNumeroDocumento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase  = $this->input->post('idclase');
                $idcentro = $this->input->post('idcentro');
                $idcaja   = $this->input->post('idcaja');
                
                $this->load->model('ventas_model');
				$numTipo = $this->ventas_model->getNumTipoTransaccion($idclase);

				if ( $numTipo == 1 ) {          //Empresa
					$nSerie   = $this->ventas_model->getSerieDocumentoEmpresa($idclase);
					$nNumeros = $this->ventas_model->getNumerosDocumentoEmpresa($idclase);
                    $nResta   = $this->ventas_model->getNumerosRestantesDocumentoEmpresa($idclase);
				} else if ( $numTipo == 2 ) {   //Sucursal
					$nSerie   = $this->ventas_model->getSerieDocumentoSucursal($idclase, $idcentro);
					$nNumeros = $this->ventas_model->getNumerosDocumentoSucursal($idclase, $idcentro);
                    $nResta   = $this->ventas_model->getNumerosRestantesDocumentoSucursal($idclase, $idcentro);
				} else if ( $numTipo == 3 ) {   //Caja
					$nSerie   = $this->ventas_model->getSerieDocumento($idclase, $idcentro, $idcaja);
					$nNumeros = $this->ventas_model->getNumerosDocumento($idclase, $idcentro, $idcaja);
                    $nResta   = $this->ventas_model->getNumerosRestantesDocumento($idclase, $idcentro, $idcaja);
				}
                
                echo json_encode(array(
                    'nSerie'   => $nSerie,
                    'nNumeros' => $nNumeros,
                    'nResta'   => $nResta
                ));
            }
        }

        function getAuxiliaresPendientes() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB')){
                redirect('CerrarSesion');
            } else {
                $idano = $this->input->post('idano');
                $idanomes = $this->input->post('idanomes');
                $idlibro = $this->input->post('idlibro');

                $this->load->model('iva_model');
                $result = $this->iva_model->getAuxiliaresPendientes($idano, $idanomes, $idlibro);

                echo json_encode($result);
            }
        }

        function generarAuxiliares() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idano = $this->input->post('idano');
                $idanomes = $this->input->post('idanomes');
                $idlibro = $this->input->post('idlibro');

                $this->load->model('iva_model');
                $result = $this->iva_model->generarAuxiliares($idano, $idanomes, $idlibro);

                echo json_encode($result);
            }
        }

        public function validacionArchivoJSON() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                try {
                    $data     = file_get_contents($_FILES['file']['tmp_name']);
                    $fileJSON = json_decode($data, true);
                    
                    $infoJSON = $fileJSON['identificacion'];
                    
                    $codigoGeneracion = $infoJSON['codigoGeneracion'];
                    $numeroControl    = $infoJSON['numeroControl'];

                    if ( isset($fileJSON['respuestaHacienda']) ) {
                        $infoMH = $fileJSON['respuestaHacienda'];
                        $selloRecibido = $infoMH['selloRecibido'];
                    } else if ( isset($fileJSON['responseMH']) ) {
                        $infoMH = $fileJSON['responseMH'];
                        $selloRecibido = $infoMH['selloRecibido'];
                    } else if ( isset($fileJSON['selloRecibido']) ) {
                        $selloRecibido = $fileJSON['selloRecibido'];
                    } else if ( isset($fileJSON['sello']) ) {
                        $selloRecibido = $fileJSON['sello'];
                    } else {
                        $selloRecibido = "";
                    }

                    echo json_encode(array(
                        'totalErrores'     => 0,
                        'mensajeResultado' => 'Carga de Datos Exitosa',
                        'codigoGeneracion' => $codigoGeneracion,
                        'numeroControl'    => $numeroControl,
                        'selloRecibido'    => $selloRecibido,
                        'fechaEmision'     => $infoJSON['fecEmi'],
                    ));
                } catch(Exception $e) {
                    echo json_encode(array(
                        'totalErrores'      => 1,
                        'mensajeResultado'  => 'Lo sentimos pero ha ocurrido un error cargando la información.'
                    ));
                }
            }
        }

        #   GET TIPO DE OPERACION RENTA IVA
        public function getTipoDeOperacionRentaIVA()
        {
            $this->load->model('iva_model');
            $response = $this->iva_model->getTipoDeOperacionRentaIVA();

            echo json_encode($response); 
        }

        #   GET TIPO DE INGRESO RENTA IVA
        public function getTipoDeIngresoRentaIVA()
        {
            $this->load->model('iva_model');
            $response = $this->iva_model->getTipoDeIngresoRentaIVA();

            echo json_encode($response); 
        }
    }
?>