<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Invtran extends CI_Controller {
        
        function __construct(){
            parent::__construct(); 
        }

        function highlight_array($array, $name = 'var') {
            highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
        }
        
        function envioOld($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $idclase = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'idclass' => $idclase
                );
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->session->set_userdata($resultAppName);
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');
                $this->data['tipos'] = $this->sucursal_model->getTipo();
                $this->data['tcenters_cd'] = $this->invtran_model->getCentrosDistribucion($idcentro);
                $this->data['tcenters'] = $this->invtran_model->getAllCentrosActivos();
                $this->data['data_info'] = $this->invtran_model->getDataTran100($idclase);
                $this->load->view('mantenimiento_invenvios', $this->data); 
            }
        }
        
        function envio($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('configuracion_model');
                $this->load->model('sucursal_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $idclase = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'idclass' => $idclase
                );
                $this->session->set_userdata($resultAppName);
                
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->load->model('global_model'); $this->load->model('invtran_model');
                $this->data['idcentro']  = $this->session->userdata('idcentrouser');
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['idclasetraslado'] = $idclase;
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 
                $this->data['valFechaIni'] = $fecha_ini;
				$this->data['valFechafin'] = $fecha_fin;
                
                //validacion fecha de envios
                $permiteFechasAnteriores = $this->global_model->getValorNumVariable("inv_enviodate");
                $this->data['permiteFechasAnteriores'] = $permiteFechasAnteriores;

               
                $this->load->view('mantenimiento_invenvios_update', $this->data); 
            }
        }
		
        function getSucursalesToTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getSucursalesDestino($idcentro);
                echo json_encode($array);
            }
        }
		
        function getUbicacionesSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('invtran_model');
                $dataUbicaciones = $this->invtran_model->getUbicacionesSucursal($idcentro);
                $nameEncargado = $this->invtran_model->getEncargadoSucursal($idcentro);
                
                $array = array(
                    "dataSourceUbi" => $dataUbicaciones,
                    "nameEncargado" => $nameEncargado
                );
                echo json_encode($array);
            }
        }
        
		function getPendientesImpresionTraslados(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //$idclase = $this->session->userdata('idclass');
                $idclase = $this->input->post('idclass');
                $estado = 0;
				
                $this->load->model('invtran_model');
                $datos = $this->invtran_model->getDataTran100Impresion($estado, $idclase);
                
                $i=0;
                $items = array();
                foreach($datos as $info){
					$items[$i] = array(
						"trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "destino" => $info->idcentrod,
                    );
                    $i++;
                }
                
				if($i == 0){
					$i = "0";
				}
				
				$array = array(
					"cantidad" => $i,
					"datos" => $items
				);
                echo json_encode($array);
			}
		}
        
        function getInformacionTraslados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclase  = $this->input->post('idclase');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $estado   = $this->input->post('estado');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getInformacionTraslados($idcentro, $idclase, $fechaini, $fechafin, $estado);
                
                $i=0;
                $dataSource = array();
                
                foreach($informacion as $info){
                    if($info->tranref==0){
                        $valorReferencia = '';
                    }else{
                        $valorReferencia = $info->tranref;
                    }
                    
                    $dataSource[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha1" => $info->fecha1,
                        "fecha2" => $info->fecha2,
                        "referencia" => $info->referencia,
                        "tranref" => $valorReferencia,
                        "idcentrod" => $info->idcentrod,
                        "lines100k" => $info->lines100k,
                        "estatus" => $info->estatus,
                        "elaboradopor" => $info->elaboradopor,                        
                    );
                    $i++;
                }
                
                echo json_encode($dataSource);
            }
        }
        
        function newTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('sucursal_model');
                $this->data['tipos'] = $this->sucursal_model->getTipo();
                $this->load->view('new_invenvios', $this->data);
            }
        }
        
        function getListaCentros(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtipo = $this->input->post('idtipo');
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getDataListaCentros($idtipo);
                echo json_encode($array);
            }
        }
        
        function registrarTenvio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $fecha = $this->input->post('fecha');
                $idclase = $this->session->userdata('idclass');
                $idcps = $this->input->post('idcps');
                $idcentrod = $this->input->post('idcentrod');
                $observaciones = $this->input->post('observaciones');
                
                $this->load->model('invtran_model');
                $this->invtran_model->insertTenvio($idcentro, $fecha, $idclase, $idcps, $idcentrod, $observaciones);
                redirect('invtran/envio/'.$this->session->userdata('iddApp'));
            }
        }
        
        function getUbicacion_Encargado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro =  $this->input->post('idcentrod');

                $this->load->model('invtran_model');
                $encargado= $this->invtran_model->getencargado_centro($idcentro);
                $ubicacion = $this->invtran_model->getubicacion_centro($idcentro);
                $array = array(
                    "encargado" => $encargado,
                    "ubicaciones" => $ubicacion
                );
                echo json_encode($array);
            }
        }
        
        function registrarTenvioAjax(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $fecha = $this->input->post('fecha');
                $idclase = $this->session->userdata('idclass');
                $notas = trim($this->input->post('notas'));
                $idcentrod = $this->input->post('idcentrod');
                $referencia = $this->input->post('referencia');

                $this->load->model('invtran_model');
                $this->invtran_model->insertTenvioAjax($idcentro, $fecha, $idclase, $notas, $idcentrod, $referencia);
                $data = $this->invtran_model->getDataTran100_center($this->session->userdata('idclass'), $this->session->userdata('idcentrouser'));
                echo json_encode($data);
            }
        }
        
        function insertNuevoTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $idclase = $this->input->post('idclase');
                $fecha = $this->input->post('fecha');
                $notas = trim($this->input->post('notas'));
                $idcentrod = $this->input->post('idcentro');
                $referencia = $this->input->post('referencia');
                $idcps = $this->input->post('idcps');
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->insertNuevoTraslado($idcentro, $fecha, $idclase, $notas, $idcentrod, $referencia, $idcps);
                echo json_encode($array);
            }
        }
        
        function verificarCentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentrod = $this->input->post('idcentrod');

                $this->load->model('invtran_model');
                $idcps= $this->invtran_model->getidps_centro($idcentrod);
                $ubicaciones = $this->invtran_model->getubicaciones_centro($idcentrod);
                
                $array = array(
                    "idcps" => $idcps,
                    "ubicaciones" => $ubicaciones
                );
                echo json_encode($array);
            }
        }
        //CAMBIADA POR OSCAR AVELAR 2020-01-07
        function verDetalleOrdenAnterior($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                $this->load->model('configuracion_model'); $this->load->model('sucursal_model');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getDetallePedido($idtrannum);
                $this->data['catalogo'] = $this->global_model->getCatalogoPrincipal();
                $this->data['detalle'] = $this->invtran_model->getDataTran100k($idtrannum);
                $this->data['detalle_export'] = $this->invtran_model->getDataTran100k_envios($idtrannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($idtrannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($idtrannum);
                $infoSourceMP = $this->invtran_model->getSumaInventarioMateriaPrima($idcentro);
                $infoSourceIS = $this->invtran_model->getSumaInventarioInsumos($idcentro);
                
                $sumaMP=0; $sumaIS=0;
                if($infoSourceMP != false){
                    foreach($infoSourceMP as $infoMP){
                        $sumaMP = $sumaMP + number_format($infoMP->cantidad, 2, '.', '');
                    }
                }
                
                if($infoSourceIS != false){
                    foreach($infoSourceIS as $infoIS){
                        $sumaIS = $sumaIS + number_format($infoIS->cantidad, 2, '.', '');
                    }
                }
                
                $this->data['sumaMP']  = $sumaMP;
                $this->data['sumaIS']  = $sumaIS;
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['idclasetraslado'] = $this->configuracion_model->getProCentro($this->session->userdata('iddApp'));
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('form_detalle_inv_mod', $this->data);
            }
        }
        //CAMBIADA POR OSCAR AVELAR 2020-01-07
        function verDetalleOrdenOscar($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                $this->load->model('configuracion_model'); $this->load->model('sucursal_model');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getDetallePedido($idtrannum);
                $this->data['catalogo'] = $this->global_model->getCatalogoPrincipal();
                $this->data['detalle'] = $this->invtran_model->getDataTran100k($idtrannum);
                $this->data['detalle_export'] = $this->invtran_model->getDataTran100k_envios($idtrannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($idtrannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($idtrannum);
                $infoSourceMP = $this->invtran_model->getSumaInventarioMateriaPrima($idcentro);
                $infoSourceIS = $this->invtran_model->getSumaInventarioInsumos($idcentro);
                $infoSourcePT = $this->invtran_model->getSumaInventarioProductoTerminado($idcentro);
                
                $sumaMP=0; $sumaIS=0; $sumaPT=0;
                if($infoSourceMP != false){
                    foreach($infoSourceMP as $infoMP){
                        $sumaMP = $sumaMP + number_format($infoMP->cantidad, 2, '.', '');
                    }
                }
                
                if($infoSourceIS != false){
                    foreach($infoSourceIS as $infoIS){
                        $sumaIS = $sumaIS + number_format($infoIS->cantidad, 2, '.', '');
                    }
                }
                if($infoSourcePT != false){
                    foreach($infoSourcePT as $infoPT){
                        $sumaPT = $sumaPT + number_format($infoPT->cantidad, 2, '.', '');
                    }
                }
                
                $this->data['sumaPT'] = $sumaPT;
                $this->data['sumaMP'] = $sumaMP;
                $this->data['sumaIS'] = $sumaIS;
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['idclasetraslado'] = $this->configuracion_model->getProCentro($this->session->userdata('iddApp'));
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('form_detalle_inv_mod', $this->data);
            }
        }

        //Update Ivan Cienfuegos 2020-02-12
        function verDetalleOrden($idtrannum, $idclase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                $this->load->model('configuracion_model'); $this->load->model('sucursal_model');
                $this->load->model('ventas_model');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $direccion = $this->uri->segment(1).'/'.$this->uri->segment(2);

				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getDetallePedido($idtrannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($idtrannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($idtrannum);
                
                $sumaPT = $this->global_model->getValorNumVariablePro('gv_protipo', 1);
                $sumaMP = $this->global_model->getValorNumVariablePro('gv_protipo', 2);
                $sumaIS = $this->global_model->getValorNumVariablePro('gv_protipo', 3);
                $po_lotescp = $this->global_model->getValorNumVariable('po_lotescp');
                
                $this->data['sumaPT'] = $sumaPT;
                $this->data['sumaMP'] = $sumaMP;
                $this->data['sumaIS'] = $sumaIS;
                $this->data['po_lotescp'] = $po_lotescp;
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['idclasetraslado'] = $idclase;
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);

                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }
                
                $this->session->set_userdata($array);
                
                $this->load->view('form_detalle_inv_mod_grid', $this->data);
            }
        }
        
        function verDetalleOrdenMod($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getDetallePedido($idtrannum);
                $this->data['catalogo'] = $this->global_model->getCatalogoPrincipal();
                $this->data['detalle'] = $this->invtran_model->getDataTran100k($idtrannum);
                $this->data['detalle_export'] = $this->invtran_model->getDataTran100k_envios($idtrannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($idtrannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($idtrannum);
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('form_detalle_inv_mod', $this->data);
            }
        }
        
        function verDetalleOrdenVieja($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getDetallePedido($idtrannum);
                $this->data['catalogo'] = $this->global_model->getCatalogoPrincipal();
                $this->data['detalle'] = $this->invtran_model->getDataTran100k($idtrannum);
                $this->data['detalle_export'] = $this->invtran_model->getDataTran100k_envios($idtrannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($idtrannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($idtrannum);
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('form_detalle_inv', $this->data);
            }
        }
		
		function setAnulacionTraslado(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$estado = 9;
				
                $this->load->model('invtran_model');
				$array = $this->invtran_model->setAnulacionEnvio($idtrannum, $estado);
				echo json_encode($array);
			}
		}
        
        function getInventarioByCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('invtran_model');
                $detalle = $this->invtran_model->getInventarioByCatalog($idtrannum,$idcatalogo,$idcentro);
                //$cantidades = $this->invtran_model->getCantidadesCatalogo($idtrannum, $idcentro);

                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "xpos" => $info->xpos,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "lote100k" => $info->lote100k,
                            "fechaCad" => $info->fechacp,
                            "multiaux" => $info->multiaux
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                    #"sumagrupos" => $cantidades
                );
                echo json_encode($array);
            }
        }
        
        function getInventarioByCatalogSalida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $detalle = $this->invtran_model->getInventarioByCatalog($idtrannum,$idcatalogo,$idcentro);
                
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "xpos" => $info->xpos,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "lote100k" => $info->lote100k,
                            "fechaCad" => $info->fechacp,
                            "multiaux" => $info->multiaux
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                echo json_encode($array);
            }
        }
        
        function getListadoLineasEnvio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $lineas = $this->invtran_model->getGruposInventarioEnvio($idtrannum, $idcentro);
                
                $i=0;
				$array = array();
				
				foreach($lineas as $data){
					$array[$i] = array(
						"idcatalogo" => $data->idcatalogo,
						"imagen" => $data->imagen,
						"descrip" => trim($data->descrip),
						"total" => $data->cantidad
					);
					$i++;
				}
				
                echo json_encode($array);
            }
        }
        
        function getListadoLineasEnvioPT(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $lineas = $this->invtran_model->getGruposInventarioProductoTerminado($idtrannum, $idcentro);
                
                $i=0;
				$array = array();
				if($lineas != false){
                    foreach($lineas as $data){
                        $array[$i] = array(
                            "idcatalogo" => $data->idcatalogo,
                            "imagen" => $data->imagen,
                            "descrip" => trim($data->descrip)
                            //"total" => $data->cantidad
                        );
                        $i++;
                    }
                }
				
                echo json_encode($array);
            }
        }
        
        function getListadoLineasEnvioMP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $lineas = $this->invtran_model->getGruposInventarioMateriaPrima($idtrannum, $idcentro);
                
                $i=0;
				$array = array();
				
				foreach($lineas as $data){
					$array[$i] = array(
						"idcatalogo" => $data->idcatalogo,
						"imagen" => $data->imagen,
						"descrip" => trim($data->descrip)
						//"total" => $data->cantidad
					);
					$i++;
				}
				
                echo json_encode($array);
            }
        }
        
        function getListadoLineasEnvioIS(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $lineas = $this->invtran_model->getGruposInventarioInsumos($idtrannum, $idcentro);
                
                $i=0;
				$array = array();
				
				foreach($lineas as $data){
					$array[$i] = array(
						"idcatalogo" => $data->idcatalogo,
						"imagen" => $data->imagen,
						"descrip" => trim($data->descrip)
						//"total" => $data->cantidad
					);
					$i++;
				}
				
                echo json_encode($array);
            }
        }
        
        function getListadoLineasSalidas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $lineas = $this->invtran_model->getListadoLineasSalidas($idcentro);
                
                $i=0;
				$array = array();
				
				foreach($lineas as $data){
					$array[$i] = array(
						"idcatalogo" => $data->idcatalogo,
						"imagen" => $data->imagen,
						"descrip" => trim($data->descrip)
					);
					$i++;
				}
				
                echo json_encode($array);
            }
        }
		
		function getListadoLineasAjuste(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
				$lineas = $this->invtran_model->getGruposAjuste($idcentro);
                //$cantid = $this->invtran_model->getCantidadesCatalogoAjuste($idtrannum, $idcentro);
                
                $i=0;
				$array = array();
				
				foreach($lineas as $data){
					//foreach($cantid as $cant){
						//if($data->idcatalogo == $cant->idcatalogo){
							$array[$i] = array(
								"idcatalogo" => $data->idcatalogo,
								"imagen" => $data->imagen,
								"descrip" => $data->descrip
								//"total" => $cant->cantidad
							);
						//}		
					//}
					$i++;
				}
				
                echo json_encode($array);
            }
		}
        
        function getInventarioByCatalogAjuste(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($idtrannum);
                $detalle = $this->invtran_model->getInventarioByCatalogAjuste($idtrannum,$idcatalogo,$idcentro,$fechaIngresaRF);
                
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function getLoteBatchProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getBatchLoteProducto($idproducto, $idcentro);
                echo json_encode($array);
            }
        }
        
        function getDatosTraslado100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getDataTran100k($idtrannum);
                echo json_encode($array);
            }
        }
        
        function getDetalleTraslados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getDetalleTraslado($trannum, $idcentro);
                //print_r($array);
                echo json_encode($array);
            }
        }
        
        function getDetalleTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getDetalleTraslado($trannum, $idcentro);
                echo json_encode($array);
            }
        }
        
        function getDatosSalida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getDatosSalida($trannum);
                echo json_encode($array);
            }
        }
                
        function getDataAjuste100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');                
                $this->load->model('invtran_model');
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($idtrannum);
                $array = $this->invtran_model->getDataAjuste100k($idtrannum, $fechaIngresaRF);
                echo json_encode($array);
            }
        }
                
        function getDetalleAjusteDeInventario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getDetalleAjusteDeInventario($idtrannum);
                echo json_encode($array);
            }
        }
        
        function getDataAjusteFavor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');                
                $this->load->model('invtran_model');
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $array = $this->invtran_model->getDataAjusteFavor($trannum, $fechaIngresaRF);
                echo json_encode($array);
            }
        }
        
        function getDataAjusteContra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');                
                $this->load->model('invtran_model');
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $array = $this->invtran_model->getDataAjusteContra($trannum, $fechaIngresaRF);
                echo json_encode($array);
            }
        }
        
        function getDataAjusteSinAjuste(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');                
                $this->load->model('invtran_model'); 
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $array = $this->invtran_model->getDataAjusteSinAjuste($trannum, $fechaIngresaRF);
                echo json_encode($array);
            }
        }
        
        function getDetalleStock(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getDataStockProducto($idproducto, $idcentro);
                echo json_encode($array);
            }
        }
        
        function deleteRegistro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $this->invtran_model->deleteDataTran100k($idrec);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                //$cantidades = $this->invtran_model->getCantidadesCatalogo($trannum, $idcentro);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                    //"sumagrupos" => $cantidades
                );
                                
                echo json_encode($array);
            }
        }
        
        function deleteRegistroTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $this->invtran_model->deleteDataTran100k($idrec);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDetalleTraslado($trannum, $idcentro);
                
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "lote100k" => $info->lote100k,
                            "fechaCad" => $info->fechacp,
                            "multiaux" => $info->multiaux
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }
        }
        
        function eliminarRegistroSalida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $this->invtran_model->deleteDataTran100k($idrec);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDatosSalida($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "lote100k" => $info->lote100k,
                            "fechaCad" => $info->fechacp,
                            "multiaux" => $info->multiaux
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }
        }
        
        function deleteRegistroVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('invtran_model');
                $this->invtran_model->deleteDataTran100k($idrec);
                $this->invtran_model->deleteVenta100c($trannum);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                $cantidades = $this->invtran_model->getCantidadesCatalogo($trannum, $idcentro);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "precio" => $info->costounitario,
                        "idbin" => $info->idbin,
                        "idbatch" => $info->idbatch,
                        "precioventa" => $info->precioventa,
                        "tipotax" => $info->tipotax
                    );
                    $i++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i,
                    "sumagrupos" => $cantidades
                );
                                
                echo json_encode($array);
            }
        }
		
		function deleteRegistroVentaPrueba(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                $this->invtran_model->deleteDataTran100k($idrec);
                $this->invtran_model->deleteVenta100c($trannum);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                $cantidades = $this->invtran_model->getCantidadesCatalogo($trannum, $idcentro);
				$servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
					$items[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$i++;
                }
				
				foreach($servicios as $serv){
					$items[$i] = array(
						"nameproducto" => $serv->descrip,
						"marca" => $serv->marca,
						"modelo" => $serv->modelo,
						"upc" => $serv->barcode,
						"notas" => $serv->notas,
						"idproducto" => $serv->idproducto,
						"tipo" => $serv->tipo,
						"um" => $serv->um,
						"imagen" => $serv->imagen,
						"cantidad" => $serv->cantidad,
						"precio" => $serv->costounitario,
						"idbin" => $serv->idbin,
						"idbatch" => $serv->idbatch,
						"precioventa" => $serv->precioventa,
						"idcatalogo" => $serv->idcatalogo,
						"tipotax" => $serv->tipotax
					);
					$i++;
				}
				
				$inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                $k=0;
                $inventario = array();
                foreach($inventariomore as $info){
					$inventario[$k] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$k++;
                }
				
				$inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
				foreach($inventariomore as $info){
					$inventario[$k] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$k++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i,
                    "sumagrupos" => $cantidades,
					"inventario" => $inventario
                );
                                
                echo json_encode($array);
            }
        }
		
		function deleteRegistroVentaSimple(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                $this->invtran_model->deleteDataTran100k($idrec);
                $this->invtran_model->deleteVenta100c($trannum);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
					$items[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$i++;
                }
				
				foreach($servicios as $serv){
					$items[$i] = array(
						"nameproducto" => $serv->descrip,
						"marca" => $serv->marca,
						"modelo" => $serv->modelo,
						"upc" => $serv->barcode,
						"notas" => $serv->notas,
						"idproducto" => $serv->idproducto,
						"tipo" => $serv->tipo,
						"um" => $serv->um,
						"imagen" => $serv->imagen,
						"cantidad" => $serv->cantidad,
						"precio" => $serv->costounitario,
						"idbin" => $serv->idbin,
						"idbatch" => $serv->idbatch,
						"precioventa" => $serv->precioventa,
						"idcatalogo" => $serv->idcatalogo,
						"tipotax" => $serv->tipotax
					);
					$i++;
				}
				
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }
        }
        
        function insertTran100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $idcentro = $this->session->userdata('idcentrouser');
                $idclase = $this->session->userdata('idclass');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $inopera = $this->global_model->getInopera_invdef($idclase);
                $invcontrol = $this->global_model->getInvControlSite($idcentro);
                
                $this->invtran_model->insertTraslado100k($cantidad, $idbatch, $idbin, $idproducto, $um, $idcentro, $invcontrol, $inopera, $trannum, $idclase, $precio);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                //$cantidades = $this->invtran_model->getCantidadesCatalogo($trannum, $idcentro);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "xpos" => $info->xpos,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                    //"sumagrupos" => $cantidades
                );
                
                echo json_encode($array);
            }            
        }
        
        function insertRegistroTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $notas = $this->input->post('notas');
                $idcentro = $this->session->userdata('idcentrouser');
                //$idclase = $this->session->userdata('idclass');
                $idclase = $this->input->post('idclass');
                $fechaCaducidad = $this->input->post('fechaCaducidad');
                $loteProduccion = $this->input->post('loteProduccion');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $inopera = $this->global_model->getInopera_invdef($idclase);
                $invcontrol = $this->global_model->getInvControlSite($idcentro);
                
                $this->invtran_model->insertTraslado100k($cantidad, $idbatch, $idbin, $idproducto, $um, $idcentro, $invcontrol, $inopera, $trannum, $idclase, $precio, $notas, $fechaCaducidad, $loteProduccion);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDetalleTraslado($trannum, $idcentro);
                
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "xpos" => $info->xpos,
                            "idbatch" => $info->idbatch,
                            "lote100k" => $info->lote100k,
                            "fechaCad" => $info->fechacp,
                            "multiaux" => $info->multiaux
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                
                echo json_encode($array);
            }            
        }
        
        function ingresarProductoPorSalida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $idcentro = $this->session->userdata('idcentrouser');
                //$idclase = $this->session->userdata('idclass');
                $idclase = $this->input->post("idclass");
                $fechaCaducidad = $this->input->post('fechaCaducidad');
                $loteProduccion = $this->input->post('loteProduccion');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $inopera = $this->global_model->getInopera_invdef($idclase);
                $invcontrol = $this->global_model->getInvControlSite($idcentro);
                
                $this->invtran_model->insertTraslado100k($cantidad, $idbatch, $idbin, $idproducto, $um, $idcentro, $invcontrol, $inopera, $trannum, $idclase, $precio, '', $fechaCaducidad, $loteProduccion);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDatosSalida($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "xpos" => $info->xpos,
                            "idbatch" => $info->idbatch,
                            "lote100k" => $info->lote100k,
                            "fechaCad" => $info->fechacp,
                            "multiaux" => $info->multiaux
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }            
        }
        
        function updateRegistroSalida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $cantidad = $this->input->post('cantidad');
                $trannum = $this->input->post('idtrannum');
                $idrec = $this->input->post('idrec');
                $idcentro = $this->session->userdata('idcentrouser');
                //$idclase = $this->session->userdata('idclass');
                $idclase = $this->input->post("idclass");
                $fechaCaducidad = $this->input->post('fechaCaducidad');
                $loteProduccion = $this->input->post('loteProduccion');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $inopera = $this->global_model->getInopera_invdef($idclase);
                
                $this->invtran_model->updateRegistroSalida($idrec, $cantidad, $inopera, $fechaCaducidad, $loteProduccion);
                                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDatosSalida($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "xpos" => $info->xpos,
                            "idbatch" => $info->idbatch,
                            "lote100k" => $info->lote100k,
                            "fechaCad" => $info->fechacp,
                            "multiaux" => $info->multiaux
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }            
        }
        
        function updateTran100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                $idclase = $this->session->userdata('idclass');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $this->invtran_model->updateTraslado100k($idrec, $cantidad);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                //$cantidades = $this->invtran_model->getCantidadesCatalogo($trannum, $idcentro);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                    //"sumagrupos" => $cantidades
                );
                                
                echo json_encode($array);
            }            
        }
        
        function updateRegistroTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                //$idclase = $this->session->userdata('idclass');
                $notas = $this->input->post('notas');
                $idclase = $this->input->post('idclass');
                $fechaCaducidad = $this->input->post('fechaCaducidad');
                $loteProduccion = $this->input->post('loteProduccion');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $this->invtran_model->updateTraslado100k($idrec, $cantidad, $notas, $fechaCaducidad, $loteProduccion);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                $datos = $this->invtran_model->getDetalleTraslado($trannum, $idcentro);
                                
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "upp" => $info->upp,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "lote100k" => $info->lote100k,
                            "fechaCad" => $info->fechacp,
                            "multiaux" => $info->multiaux
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }            
        }
        
        function getDetalleTran100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('invtran_model');
                
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                $notas = $this->invtran_model->getNotasTrann100($trannum);
                $referencia = $this->invtran_model->getReferenciaTrann100($trannum);
                
                $array = array(
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "notas" => $notas,
                    "referencia" => $referencia
                );
                
                echo json_encode($array);
            }
        }

        //---------------------------------
        function getLotes100kProducts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idProduct = $this->input->post('idProducto');
                $this->load->model('invtran_model');

                $info = $this->invtran_model->getLotes100kProducts($idProduct);
                
                echo json_encode($info);
            }
        }

        function getSaldoProductoByLote(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idProduct = $this->input->post('idProducto');
                $lote100k = $this->input->post('lote100k');
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('invtran_model');
                $detalle = $this->invtran_model->getSaldoProductoByLote($idtrannum, $idcatalogo, $idcentro, $idProduct, $lote100k);

                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    $datos = array(
                        "cantidad" => $info->cantidad,
                    );
                }
                
                echo json_encode($datos);
            }
        }
        //---------------------------------
        
        function set_tipo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtipo = $this->input->post('dato');
                $tipo_suc = array(
                    'tip_cd_suc' => $idtipo
                );
                $this->session->set_userdata($tipo_suc);
                $array = true;
                echo json_encode($array);
            }
        }
        
        function cerrarTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $notas = trim($this->input->post('notas'));
                $idcentrod = $this->input->post('idcentrod');
                $fecha = $this->input->post('fecha');
                $referencia = trim($this->input->post('referencia'));
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                
                $array = $this->invtran_model->cambiarEstadoTraslado($trannum, $notas, $referencia, $idcentrod, $fecha);
                
                $this->invtran_model->callTotaliza100($trannum, 1);
				$this->global_model->insertarRegTran100p($trannum);
                
                echo json_encode($array);
            }
        }
        
        function cerrarConsignacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $notas = trim($this->input->post('notas'));
                $referencia = trim($this->input->post('referencia'));
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                
                $array = $this->invtran_model->cerrarConsignacion($trannum, $notas, $referencia);
                
                $this->invtran_model->callTotaliza100($trannum, 1);
				$this->global_model->insertarRegTran100p($trannum);
                
                echo json_encode($array);
            }
        }
        
        function cerrarSalidaInventario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $notas = trim($this->input->post('notas'));
                $referencia = trim($this->input->post('referencia'));
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                
                $array = $this->invtran_model->cerrarSalidaInventario($trannum, $notas, $referencia);
                
                $this->invtran_model->callTotaliza100($trannum, 1);
				$this->global_model->insertarRegTran100p($trannum);
                
                echo json_encode($array);
            }
        }
        
        function recepcion($idapp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('global_model');
                $this->load->model('configuracion_model');

                $appName = $this->configuracion_model->getAppName($idapp);
                $idclase = $this->configuracion_model->getProCentro($idapp);
                
                $infoAppName = array(
                    'iddApp' => $idapp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 
                $idcentro = $this->session->userdata('idcentrouser');
                $direccion = $this->uri->segment(1).'/'.$this->uri->segment(2);

                $this->load->model('invtran_model');

				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['val_idclase'] = $idclase;
                $this->data['valFechaIni'] = $fecha_ini;
				$this->data['valFechafin'] = $fecha_fin;
				
                $this->load->view('mantenimiento_invrecepcion', $this->data); 
            } 
        }

        function getListadoRecepcionDeTraslados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $pendientes = $this->invtran_model->getTrasladosPendientes($idcentro, $fechaini, $fechafin);
                $recibidos = $this->invtran_model->getTrasladosRecibidos($idcentro, $idclase, $fechaini, $fechafin);

                $i=0;
                $dataSource = array();
                foreach($recibidos as $key){
                    if($key->estatus == 1){
                        $estatus = "Pendiente"; 
                    }elseif($key->estatus == 2){
                        $estatus = "Recibido";
                    }elseif($key->estatus == 9){
                        $estatus = "Anulado";
                    }

                    $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
                    $reemplazar = array("", "", "", "");
                    $notas = str_replace($buscar, $reemplazar, $key->notas);

                    $dataSource[$i] = array(
                        "trannum" => $key->trannum,
                        "tranref" => $key->tranref,
                        "fecha" => $key->fecha,
                        "fecact" => $key->fecact,
                        "estatus" => $estatus,
                        "idcentrod" => $key->idcentrod,
                        "notas" => trim(strtoupper($notas)),
                        "lines100k" => $key->lines100k,
                        "recibidopor" => $key->recibidopor
                    );

                    $i++;
                }

                foreach($pendientes as $key){
                    if($key->estatus == 1){
                        $estatus = "Pendiente"; 
                    }elseif($key->estatus == 2){
                        $estatus = "Recibido";
                    }elseif($key->estatus == 9){
                        $estatus = "Anulado";
                    }
                    
                    $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
                    $reemplazar = array("", "", "", "");
                    $notas = str_replace($buscar, $reemplazar, $key->notas);
                    
                    $dataSource[$i] = array(
                        "trannum" => $key->trannum,
                        "tranref" => $key->tranref,
                        "fecha" => $key->fecact,
                        "fecact" => '',
                        "estatus" => $estatus,
                        "idcentrod" => $key->centrocd,
                        "notas" => trim(strtoupper($notas)),
                        "lines100k" => $key->lines100k,
                        "recibidopor" => ''
                    );
                    $i++;
                }

                echo json_encode($dataSource);
            }
        }
        
        function detalle_recepcion($trannum, $idClase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('invtran_model');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $direccion = $this->uri->segment(1).'/'.$this->uri->segment(2);
                
                $this->data['idrecepcion'] = $idClase;
                $this->data['info'] = $this->invtran_model->getDetallePedido($trannum);
                $this->data['detalle'] = $this->invtran_model->getDataTran100k($trannum);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $po_lotescp = $this->global_model->getValorNumVariable('po_lotescp');
                $this->data['po_lotescp'] = $po_lotescp;
				
                $inv_chkenvio = $this->global_model->getValorNumVariable("inv_chkenvio");
                if($inv_chkenvio==0){
                    $this->load->view('mantenimiento_invrecepcion_detalle', $this->data); 
                }else{
                    $this->load->view('mantenimiento_invrecepcion_detalle_verifica', $this->data); 
                }
            } 
        }
        
        function getDetalleRecepcion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('trannum');
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $array = array(
                    "informacion" => $informacion,
                    "detalle" => $detalle
                );
                
                echo json_encode($array);
            }
        }
        
        function getProductosRecepcion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('trannum');
                $this->load->model('invtran_model');
                $detalle = $this->invtran_model->getDetalleAjuste100k($idtrannum);
                echo json_encode($detalle);
            }
        }
        
        function recibirTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum    = $this->input->post('trannum');
                $idclase      = $this->input->post('idrecepcion');
                $calificacion = $this->input->post('calificacion');
                $notas_calificacion = $this->input->post('notas_calificacion');
                
                $this->load->model('global_model');
                $this->load->model('invtran_model');
                
                $idcentro = $this->invtran_model->getidcentroRecepcion($idtrannum);
                $idbin    = $this->invtran_model->getIdBin($idcentro);
                $idcode   = $this->invtran_model->setRecepcionHD($idtrannum, $idclase, $calificacion, $notas_calificacion);
                $this->invtran_model->setRecepcionDT($idtrannum, $idcode, $idclase, $idbin);
                $this->invtran_model->callTotaliza100($idcode, 2);
                $informacion = $this->invtran_model->getDetallePedido($idcode);
				
                echo json_encode($informacion);
            }
        }
        
        function consultaProductos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('producto_model');
                $this->data['dat_Cat'] = $this->producto_model->viewCat();
                $this->data['dat_Subcat'] = $this->producto_model->viewSubcat();
				
                $this->load->view('mantenimiento_consultaproductos', $this->data);
            }
        }
        
        function getInventarioProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getInventarioProductos($idcatalogo, $idcentro);
				
                echo json_encode($array);
            }
        }
        
        function getLotesProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getLotesProductos($idproducto);
				
                echo json_encode($array);
            }
        }
        
        function getProductoSearch(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $search = $this->input->post('search');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getLotesProductosSearch($search, $idcatalogo);
				
                echo json_encode($array);
            }
        }
        
        function getDatosSearch(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');

                $this->load->model('invtran_model');
                $detalle = $this->invtran_model->getDatosProductoSearch($prosearch, $dato, $idcentro, $trannum);
                if($detalle != 0){
                    $i=0;
                    $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
                        if($info->existe == "0"){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "upp" => $info->upp,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "namecatalogo" => $info->namecatalogo,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
                                "lote100k" => $info->lote100k,
                                "multiaux" => $info->multiaux,
                                "fechaCad" => $info->fechacp,
                                "agregado" => 0
                            );
                            $i++;
                        }else{
							$idrec = $this->invtran_model->getIdrecProducto($trannum, $info->idproducto);
							$ingresado = $this->invtran_model->getCantidadProducto($trannum, $info->idproducto, $idcentro);
							$preciotran = $this->invtran_model->getPreciotranProducto($idrec);
							
                            $items[$i] = array(
                                "idrec" => $idrec,
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "upp" => $info->upp,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "xpos" => $info->xpos,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "namecatalogo" => $info->namecatalogo,
                                "precioventa" => $info->precioventa,
                                "preciotran" => $preciotran,
                                "idcatalogo" => $info->idcatalogo,
                                "ingresada" => $ingresado,
                                "lote100k" => $info->lote100k,
                                "fechaCad" => $info->fechacp,
                                "multiaux" => $info->multiaux,
                                "agregado" => 1
                            );
                            $i++;
                            $agregado = 1;
                            $idproductoAdd = $info->idproducto;
                        }
                    }
                    if($agregado == 1){
                        $itemlineproducto = $this->invtran_model->getItemlineProducto($trannum, $idproductoAdd);
						$array = array(
                            "error" => "2",
                            "itemline" => $itemlineproducto,
							"cantidad" => $i,
                            "datos" => $items
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
				
                echo json_encode($array);
            }
        }
		
		function getDatosSearchAjuste(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');

                $this->load->model('invtran_model');
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $detalle = $this->invtran_model->getDatosProductoSearchAjuste($prosearch, $dato, $idcentro, $trannum, $fechaIngresaRF);
                if($detalle != 0){
                    $i=0;
                    $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
                        if($info->existe == "0"){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "saldoproducto" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "namecatalogo" => $info->namecatalogo,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
								"agregado" => 0
                            );
                            $i++;
                        }else{
							$items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "saldoproducto" => $info->cantidad,
                                "precio" => $info->costounitario,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "namecatalogo" => $info->namecatalogo,
                                "precioventa" => $info->precioventa,
                                "idcatalogo" => $info->idcatalogo,
								"agregado" => 1
                            );
                            $i++;
                            $agregado = 1;
                        }
                    }
                    if($agregado == 1 && $i == 1){
                        $datos = $this->invtran_model->getDataAjusteProducto100k($trannum, $info->idproducto);
                        $array = array(
                            "error" => "2",
                            "datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
				
                echo json_encode($array);
            }
        }
		
		function getDatosOnlySearchScanJob(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');
				
                $this->load->model('invtran_model');
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $infomacion = $this->invtran_model->getDatosProductoSearchAjuste($prosearch, $dato, $idcentro, $trannum, $fechaIngresaRF);
				
				if($infomacion != 0){
                    $i=0; $array_info = array();
                    foreach($infomacion as $info){
						
						$array_info[$i] = array(
							"nameproducto" => $info->descrip,
							"marca" => $info->marca,
							"modelo" => $info->modelo,
							"upc" => $info->barcode,
							"notas" => $info->notas,
							"idproducto" => $info->idproducto,
							"um" => $info->um,
							"imagen" => $info->imagen,
							"cantidad" => $info->cantidad,
							"precio" => $info->costounitario,
							"idbin" => $info->idbin,
							"idbatch" => $info->idbatch,
							"namecatalogo" => $info->namecatalogo,
							"precioventa" => $info->precioventa,
							"idcatalogo" => $info->idcatalogo
						);
						$i++;
					}
					
					$error_msg = 0;
					$array = array(
						"error" => $error_msg,
						"datos" => $array_info
					);
                }else{
                    $array = array(
                        "error" => "1"
                    );
                }
				
                echo json_encode($array);
            }
		}
		
		function insertProductoScanJobTxt(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                $numero = $this->input->post('numero');
                $idproducto = $this->input->post('idproducto');
                $cantidad = $this->input->post('cantidad');
				
				$this->load->model('invtran_model');
				$this->invtran_model->insertarProductoAjusteScanJob($trannum, $idproducto, $cantidad, $numero);
				
				$codes = $this->invtran_model->getInformacionScanGrid($trannum, $numero);
				$informacion = $this->invtran_model->getListadoGeneralesProductos($idcentro);
				
				$info = explode(";", $codes); $totalScan = count($info);
				
				$i=0;
				$dataSource = array();
				
				foreach($informacion as $infoProductos){
					$infoCantidad = 0;
					$infoAgregado = 0;
					if($codes != ""){
						for($j=0; $j<$totalScan; $j++){
							$infoProd = explode(",", $info[$j]);
							if($infoProd[0] == $infoProductos->idproducto){
								$infoCantidad = $infoProd[1];
								$infoAgregado = 1;
							}
						}
					}
					
					$dataSource[$i] = array(
						"nameLinea" => $infoProductos->nameLinea,
						"idproducto" => $infoProductos->idproducto,
						"descrip" => $infoProductos->descrip,
						"um" => $infoProductos->um,
						"marca" => $infoProductos->marca,
						"imagen" => $infoProductos->imagen,
						"modelo" => $infoProductos->modelo,
						"barcode" => $infoProductos->barcode,
						"inventario" => $infoProductos->cantidad,
						"cantidad" => $infoCantidad,
						"info_estado" => $infoAgregado
					);
					$i++;
				}
				
				$array = array(
					"dataSource" => $dataSource
				);
				
				echo json_encode($array);
			}
		}
		
		function deleteProductoScanJobTxt(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                $numero = $this->input->post('numero');
                $idproducto = $this->input->post('idproducto');
                
				$this->load->model('invtran_model');
				$this->invtran_model->deleteProductoAjusteScanJob($trannum, $idproducto, $numero);
				
				$codes = $this->invtran_model->getInformacionScanGrid($trannum, $numero);
				$informacion = $this->invtran_model->getListadoGeneralesProductos($idcentro);
				
				$info = explode(";", $codes); $totalScan = count($info);
				
				$i=0;
				$dataSource = array();
				
				foreach($informacion as $infoProductos){
					$infoCantidad = 0;
					$infoAgregado = 0;
					if($codes != ""){
						for($j=0; $j<$totalScan; $j++){
							$infoProd = explode(",", $info[$j]);
							if($infoProd[0] == $infoProductos->idproducto){
								$infoCantidad = $infoProd[1];
								$infoAgregado = 1;
							}
						}
					}
					
					$dataSource[$i] = array(
						"nameLinea" => $infoProductos->nameLinea,
						"idproducto" => $infoProductos->idproducto,
						"descrip" => $infoProductos->descrip,
						"um" => $infoProductos->um,
						"marca" => $infoProductos->marca,
						"imagen" => $infoProductos->imagen,
						"modelo" => $infoProductos->modelo,
						"barcode" => $infoProductos->barcode,
						"inventario" => $infoProductos->cantidad,
						"cantidad" => $infoCantidad,
						"info_estado" => $infoAgregado
					);
					$i++;
				}
				
				$array = array(
					"dataSource" => $dataSource
				);
				
				echo json_encode($array);
			}
		}
		
		function getDatosSearchScanJob(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $numero = $this->input->post('numero');
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');
                $cantidad = $this->input->post('cantidad');

                $this->load->model('invtran_model');
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $infomacion = $this->invtran_model->getDatosProductoSearchAjuste($prosearch, $dato, $idcentro, $trannum, $fechaIngresaRF);
				
				if($infomacion != 0){
                    $i=0; $array_info = array();
                    foreach($infomacion as $info){
						
						$array_info[$i] = array(
							"nameproducto" => $info->descrip,
							"marca" => $info->marca,
							"modelo" => $info->modelo,
							"upc" => $info->barcode,
							"notas" => $info->notas,
							"idproducto" => $info->idproducto,
							"um" => $info->um,
							"imagen" => $info->imagen,
							"cantidad" => $info->cantidad,
							"precio" => $info->costounitario,
							"idbin" => $info->idbin,
							"idbatch" => $info->idbatch,
							"xpos" => $info->xpos,
							"namecatalogo" => $info->namecatalogo,
							"precioventa" => $info->precioventa,
							"idcatalogo" => $info->idcatalogo
						);
						$i++;
					}
					
					$idproducto = $info->idproducto;
					$this->invtran_model->insertarProductoAjusteScanJob($trannum, $idproducto, $cantidad, $numero);
					$error_msg = 0;
					
					$array = array(
						"error" => $error_msg,
						"datos" => $array_info
					);
                }else{
                    $array = array(
                        "error" => "1"
                    );
                }
				
                echo json_encode($array);
            }
		}
		
		function getDatosSearchScanJobTran100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');

                $this->load->model('invtran_model');
                $infomacion = $this->invtran_model->getProductoTrasladoScan($prosearch, $dato, $idcentro);
				
                if($infomacion != 0){
                    $i=0; $array_info = array();
                    foreach($infomacion as $info){
						
						$inforegis = $this->invtran_model->getInformacionScanGridTraslado($trannum);
						$datasource = explode(";", $inforegis);
						$var_i = count($datasource);
						$var_disponible = 1;
						
						if($inforegis != ""){
							for($j=0; $j<$var_i; $j++){
								$infoProd = explode(",", $datasource[$j]);
								if($infoProd[0] == $info->idproducto){
									if($infoProd[1] == number_format($info->cantidad)){
										$var_disponible = 0;
									}
								}
							}
						}
						
						if($var_disponible == 1){
							$array_info[$i] = array(
								"nameproducto" => $info->descrip,
								"marca" => $info->marca,
								"modelo" => $info->modelo,
								"upc" => $info->barcode,
								"notas" => $info->notas,
								"idproducto" => $info->idproducto,
								"um" => $info->um,
								"imagen" => $info->imagen,
								"cantidad" => $info->cantidad,
								"precio" => $info->costounitario,
								"idbin" => $info->idbin,
								"idbatch" => $info->idbatch,
								"xpos" => $info->xpos,
								"namecatalogo" => $info->namecatalogo,
								"precioventa" => $info->precioventa,
								"idcatalogo" => $info->idcatalogo
							);
							$i++;
						}
                    }
					
					if($var_disponible == 1){
						$idproducto = $info->idproducto;
						$this->invtran_model->insertarProductoTrasladoScanJob($trannum, $idproducto, 1);
						$error_msg = 0;
					}else{
						$error_msg = 2;
					}
					
					$array = array(
						"error" => $error_msg,
						"datos" => $array_info
					);
                }else{
                    $array = array(
                        "error" => "1"
                    );
                }
				
                echo json_encode($array);
            }
		}
		
		function getDatosScanGrid(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$numero = $this->input->post('numero');
				
				$this->load->model('invtran_model');
				$codes = $this->invtran_model->getInformacionScanGrid($trannum, $numero);
				
				$info = explode(";", $codes);
				$cantidad = count($info);
				$informacion = array();
				$totuni = 0; $i=0;
				
				if($codes != ""){
					for($i=0; $i<$cantidad; $i++){
						$infoProd = explode(",", $info[$i]);
						$descrip = $this->invtran_model->getNameProductoByCodigo($infoProd[0]);	
						$informacion[$i] = array(
							"idproducto" => $infoProd[0],
							"descrip" => $descrip,
							"cantidad" => $infoProd[1]
						);
						
						$totuni = $totuni + $infoProd[1];
					}
				}
				
				$array = array(
					"datos" => $informacion,
					"lineas" => $i,
					"unidades" => $totuni
				);
				
				echo json_encode($array);
            }
		}
		
		function getInformacionProductosScan(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$numero = $this->input->post('numero');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('invtran_model');
				$codes = $this->invtran_model->getInformacionScanGrid($trannum, $numero);
				$informacion = $this->invtran_model->getListadoGeneralesProductos($idcentro);
				
				$info = explode(";", $codes); $cantidad = count($info);
				
				$i=0;
				$dataSource = array();
				
				foreach($informacion as $infoProductos){
					$infoCantidad = 0;
					$infoAgregado = 0;
					if($codes != ""){
						for($j=0; $j<$cantidad; $j++){
							$infoProd = explode(",", $info[$j]);
							if($infoProd[0] == $infoProductos->idproducto){
								$infoCantidad = $infoProd[1];
								$infoAgregado = 1;
							}
						}
					}
					
					$dataSource[$i] = array(
						"nameLinea" => $infoProductos->nameLinea,
						"idproducto" => $infoProductos->idproducto,
						"descrip" => $infoProductos->descrip,
						"um" => $infoProductos->um,
						"marca" => $infoProductos->marca,
						"imagen" => $infoProductos->imagen,
						"modelo" => $infoProductos->modelo,
						"barcode" => $infoProductos->barcode,
						"inventario" => $infoProductos->cantidad,
						"cantidad" => $infoCantidad,
						"info_estado" => $infoAgregado
					);
					$i++;
				}
				
				$array = array(
					"dataSource" => $dataSource
				);
				
				echo json_encode($array);
            }
		}
		
		function getDatosScanGridTraslado(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('invtran_model');
				$codes = $this->invtran_model->getInformacionScanGridTraslado($trannum);
				
				$info = explode(";", $codes); $cantidad = count($info);
				$informacion = array(); $totuni = 0; $i=0;
				
				if($codes != ""){
					for($i=0; $i<$cantidad; $i++){
						$infoProd = explode(",", $info[$i]);
						$descrip = $this->invtran_model->getNameProductoByCodigo($infoProd[0]);
						$disponible = $this->invtran_model->getSaldoProductoByCodigo($infoProd[0], $idcentro);
						
						$informacion[$i] = array(
							"idproducto" => $infoProd[0],
							"descrip" => substr($descrip, 0, 30),
							"cantidad" => $infoProd[1],
							"disponible" => $disponible
						);
						
						$totuni = $totuni + $infoProd[1];
					}
				}
				
				$array = array(
					"datos" => $informacion,
					"lineas" => $i,
					"unidades" => $totuni
				);
				
				echo json_encode($array);
            }
		}
		
		function setClearScanJobTraslado(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('invtran_model');
				$this->invtran_model->clearDatosScanTraslado($trannum);
				$codes = $this->invtran_model->getInformacionScanGridTraslado($trannum);
				
				$info = explode(";", $codes); $cantidad = count($info);
				$informacion = array(); $totuni = 0; $i=0;
				
				if($codes != ""){
					for($i=0; $i<$cantidad; $i++){
						$infoProd = explode(",", $info[$i]);
						$descrip = $this->invtran_model->getNameProductoByCodigo($infoProd[0]);
						$disponible = $this->invtran_model->getSaldoProductoByCodigo($infoProd[0], $idcentro);
						
						$informacion[$i] = array(
							"idproducto" => $infoProd[0],
							"descrip" => substr($descrip, 0, 30),
							"cantidad" => $infoProd[1],
							"disponible" => $disponible
						);
						
						$totuni = $totuni + $infoProd[1];
					}
				}
				
				$array = array(
					"datos" => $informacion,
					"lineas" => $i,
					"unidades" => $totuni
				);
				
				echo json_encode($array);
            }
		}
		
		function setClearScanJob(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$numero = $this->input->post('numero');
				
				$this->load->model('invtran_model');
				$this->invtran_model->clearDatosScan($trannum, $numero);
				$codes = $this->invtran_model->getInformacionScanGrid($trannum, $numero);
				
				$info = explode(";", $codes);
				$cantidad = count($info);
				$informacion = array();
				$totuni = 0;
				$i=0;
				
				if($codes != ""){
					for($i=0; $i<$cantidad; $i++){
						$infoProd = explode(",", $info[$i]);
						$descrip = $this->invtran_model->getNameProductoByCodigo($infoProd[0]);
						
						$informacion[$i] = array(
							"idproducto" => $infoProd[0],
							"descrip" => substr($descrip, 0, 30),
							"cantidad" => $infoProd[1]
						);
						
						$totuni = $totuni + $infoProd[1];
					}
				}
				
				$array = array(
					"datos" => $informacion,
					"lineas" => $i,
					"unidades" => $totuni
				);
				
				echo json_encode($array);
            }
		}
		
		function setClearScanJobTxt(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$numero = $this->input->post('numero');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('invtran_model');
				$this->invtran_model->clearDatosScan($trannum, $numero);
				
				$codes = $this->invtran_model->getInformacionScanGrid($trannum, $numero);
				$informacion = $this->invtran_model->getListadoGeneralesProductos($idcentro);
				
				$info = explode(";", $codes); $cantidad = count($info);
				
				$i=0;
				$dataSource = array();
				
				foreach($informacion as $infoProductos){
					$infoCantidad = 0;
					$infoAgregado = 0;
					if($codes != ""){
						for($j=0; $j<$cantidad; $j++){
							$infoProd = explode(",", $info[$j]);
							if($infoProd[0] == $infoProductos->idproducto){
								$infoCantidad = $infoProd[1];
								$infoAgregado = 1;
							}
						}
					}
					
					$dataSource[$i] = array(
						"nameLinea" => $infoProductos->nameLinea,
						"idproducto" => $infoProductos->idproducto,
						"descrip" => $infoProductos->descrip,
						"um" => $infoProductos->um,
						"marca" => $infoProductos->marca,
						"imagen" => $infoProductos->imagen,
						"modelo" => $infoProductos->modelo,
						"barcode" => $infoProductos->barcode,
						"inventario" => $infoProductos->cantidad,
						"cantidad" => $infoCantidad,
						"info_estado" => $infoAgregado
					);
					$i++;
				}
				
				$array = array(
					"dataSource" => $dataSource
				);
				
				echo json_encode($array);
            }
		}
		
		function setCantidadNuevaScanTraslado(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$idproducto = $this->input->post('idproducto');
				$cantidad = $this->input->post('cantidad');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('invtran_model');
				$this->invtran_model->setNuevaCantidadScanTraslado($trannum, $cantidad, $idproducto);
				$codes = $this->invtran_model->getInformacionScanGridTraslado($trannum);
				
				$info = explode(";", $codes); $cantidad = count($info);
				$informacion = array(); $totuni = 0; $i=0;
				
				if($codes != ""){
					for($i=0; $i<$cantidad; $i++){
						$infoProd = explode(",", $info[$i]);
						$descrip = $this->invtran_model->getNameProductoByCodigo($infoProd[0]);
						$disponible = $this->invtran_model->getSaldoProductoByCodigo($infoProd[0], $idcentro);
						
						$informacion[$i] = array(
							"idproducto" => $infoProd[0],
							"descrip" => substr($descrip, 0, 30),
							"cantidad" => $infoProd[1],
							"disponible" => $disponible
						);
						
						$totuni = $totuni + $infoProd[1];
					}
				}
				
				$array = array(
					"datos" => $informacion,
					"lineas" => $i,
					"unidades" => $totuni
				);
				
				echo json_encode($array);
            }
		}
		
		function setCantidadNuevaScan(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$idproducto = $this->input->post('idproducto');
				$cantidad = $this->input->post('cantidad');
				$numero = $this->input->post('numero');
				
				$this->load->model('invtran_model');
				$this->invtran_model->setNuevaCantidadScan($trannum, $cantidad, $idproducto, $numero);
				$codes = $this->invtran_model->getInformacionScanGrid($trannum, $numero);
				
				$info = explode(";", $codes);
				$cantidad = count($info);
				$informacion = array();
				$totuni = 0;
				$i=0;
				
				if($codes != ""){
					for($i=0; $i<$cantidad; $i++){
						$infoProd = explode(",", $info[$i]);
						$descrip = $this->invtran_model->getNameProductoByCodigo($infoProd[0]);	
						$informacion[$i] = array(
							"idproducto" => $infoProd[0],
							"descrip" => substr($descrip, 0, 30),
							"cantidad" => $infoProd[1]
						);
						
						$totuni = $totuni + $infoProd[1];
					}
				}
				
				$array = array(
					"datos" => $informacion,
					"lineas" => $i,
					"unidades" => $totuni
				);
				
				echo json_encode($array);
            }
		}
		
		function getScanJobsUtilizados(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				
				$this->load->model('invtran_model');
				$informacion = $this->invtran_model->getScanJobsUtilizados($trannum);
				
				echo json_encode($informacion);
            }
		}
		
		function getProductAgregadoDetalleAjuste(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idproducto = $this->input->post('idproducto');
				$trannum = $this->input->post('idtrannum');
				
				$this->load->model('invtran_model');
				$array = $this->invtran_model->getDataAjusteProducto100k($trannum, $idproducto);
				
				echo json_encode($array);
			}
		}
        
        function getProductoSearchAll(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $search = $this->input->post('search');
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getLotesProductosSearchAll($search);
				
                echo json_encode($array);
            }
        }
        
        function validateLocation(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getValidateLocationByCentro($idcentro);
				
                echo json_encode($array);
            }
        }
        
        function consultasaldos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
				$this->load->model('producto_model');$this->load->model('user_model');
                $this->load->model('invtran_model');$this->load->model('sucursal_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                
             
                $controlador = $this->uri->segment(1);
                $this->data['direccion'] = $controlador;
                $this->data['opcion_tipo'] = $opcionmenu;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['tipos']  = $this->sucursal_model->getTipo();
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['centros']  = $this->sucursal_model->viewSucursal();
                $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                $this->data['lineas'] = $this->producto_model->viewLineas();
				$this->data['tipos_search'] = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $derechos = $this->user_model->getDerechos();
                $permite = 0;
                if($derechos!=""){
                    $pos = strpos($derechos, "costo");
                    if($pos !== false){
                        if($pos>=0){
                            $permite=1;
                        }   
                    }
                    
                }
                $this->data['permite_costo'] = $permite;
                
                $this->load->view('mantenimiento_consultasaldos', $this->data);
            }
        }
        
        function consultasaldos2($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                
             
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->data['direccion'] = $direccion;
                $this->data['opcion_tipo'] = $opcionmenu;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->load->model('producto_model');$this->load->model('user_model');
                $this->load->model('invtran_model');$this->load->model('sucursal_model');
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['tipos']  = $this->sucursal_model->getTipo();
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['centros']  = $this->sucursal_model->viewSucursal();
                $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                $this->data['lineas'] = $this->producto_model->viewLineas();
                $derechos = $this->user_model->getDerechos();
                $permite = 0;
                if($derechos!=""){
                    $pos = strpos($derechos, "costo");
                    if($pos !== false){
                        if($pos>=0){
                            $permite=1;
                        }   
                    }
                    
                }
                $this->data['permite_costo'] = $permite;
                
                $this->load->view('mantenimiento_consultasaldos2', $this->data);
            }
        }
        
        function getInfoExistencias(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $this->load->model('invtran_model');
                $productos = $this->invtran_model->get_Existencias_Kardex();
                $detalle = $this->invtran_model->get_Detalle_Existencias();
                $i=0;
                $array = array();
                foreach($productos as $pro){
                    //if($pro->cantidad!=0){
                        $detail_Ubicaciones = array();
                        $j=0;
                        foreach($detalle as $det){
                            //&& $det->cantidad!=0 
                            if($det->idproducto==$pro->id){
                                $detail_Ubicaciones[$j] = array(
                                    "idproducto" => $det->idproducto,
                                    "centro" => $det->centro,
                                    "ubicacion" => $det->ubicacion,
                                    "lote" => $det->lote,
                                    "cantidad" => $det->cantidad,
                                    "idbin" => $det->idbin,
                                    "idbatch" => $det->idbatch
                                );
                                $j++; 
                            }

                        }
                        $array[$i] = array(
                            "linea" => $pro->linea,
                            "id" => $pro->id,
                            "producto" => $pro->producto,
                            "marca" => $pro->marca,
                            "modelo" => $pro->modelo,
                            "um" => $pro->um,
                            "precioventa" => $pro->precioventa,
                            "cantidad" => $pro->cantidad,
                            "idnivel1" => $pro->idnivel1,
                            "detalle" =>$detail_Ubicaciones
                        );
                        $i++;
                    //}
                }
                echo json_encode($array);
            }
        }
		
        function getInfoExistenciasDepartamento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idlinea1 = $this->input->post("idlinea1");
                $this->load->model('invtran_model');
                if($idlinea1==0){
                    $productos = $this->invtran_model->get_Existencias_Kardex();
                }else{
                    $productos = $this->invtran_model->get_Existencias_Kardex_Departamento($idlinea1);
                }
                $detalle = $this->invtran_model->get_Detalle_Existencias();

                $i=0;
                $array = array();
                foreach($productos as $pro){
                    $detail_Ubicaciones = array();
                    $j=0;
                    foreach($detalle as $det){
                        if($det->idproducto==$pro->id){
                            $detail_Ubicaciones[$j] = array(
                                "idproducto" => $det->idproducto,
                                "centro" => $det->centro,
                                "ubicacion" => $det->ubicacion,
                                "lote" => $det->lote,
                                "cantidad" => $det->cantidad,
                                "idbin" => $det->idbin,
                                "idbatch" => $det->idbatch
                            );
                            $j++; 
                        }       
                    }
                    $array[$i] = array(
                        //"linea" => $pro->idcatalogo,
                        "linea" => $pro->linea,
                        "id" => $pro->id,
                        "producto" => $pro->producto,
                        "marca" => $pro->marca,
                        "modelo" => $pro->modelo,
                        "um" => $pro->um,
                        "precioventa" => $pro->precioventa,
                        "cantidad" => $pro->cantidad,
                        "idnivel1" => $pro->idnivel1,
                        "detalle" =>$detail_Ubicaciones
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
		function getMovProduct(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idbin = $this->input->post('idbin');
                $idbatch = $this->input->post('idbatch');
                $this->load->model('invtran_model');
                $movimientos = $this->invtran_model->getMovProduct($idbin,$idbatch);
                $cant_t = 0;
                $saldo = 0;
                $i=0;
                $array = array();
                foreach($movimientos as $mov){
                    $cant_t = $mov->cantidad * $mov->uniconv;
                    $saldo += ($mov->cantidad * $mov->uniconv);
					$vendedor_producto =  $this->invtran_model->getVendedorProducto($mov->trannum, $mov->idrec);
                    $mostrar_column = "";
                    switch($mov->agrupa){
                        case "CO":
                            $mostrar_column = $mov->cliente_proveedor;
                            break;
                        case "IN":
                            $mostrar_column = $mov->o_d;
                            break;
                        case "VN":
                            $mostrar_column = $mov->cliente_proveedor;
                            break;
                    }
                    
                    $array[$i] = array(
                        "agrupa" => $mov->agrupa,
                        "fecha" => $mov->fecha,
                        "fecact" => $mov->fecact,
                        "notas_doc" => $mov->notas_doc,
                        "referencia_doc" => $mov->referencia_doc,
                        "trannum" => $mov->trannum,
                        "o_d" => $mostrar_column,
                        "descrip" => $mov->descrip,
                        "marca" => $mov->marca,
                        "num" => $mov->num,
                        "um" => $mov->um,
                        "idrec" => $mov->idrec,
                        "itemline" => $mov->itemline,
                        "usuario" => $mov->usuario,
                        "ingresa" => $mov->ingresa,
                        "modifica" => $mov->modifica,
                        "suma_salidas" => $mov->suma_salidas,
                        "cantidad" => number_format($cant_t, 4, '.', ''),
                        "saldo" => number_format($saldo, 4, '.', ''),
                        "vendedor_producto" => $vendedor_producto,
                        "nameidworker" => $mov->nameidworker,
                        "notas" => $mov->notas,
                        "costounitario" => $mov->costounitario,
                        "preciotran" => $mov->preciotran,
                        "precioneto" => $mov->precioneto,
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
        function getSimpleMovProduct(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idbin = $this->input->post('idbin');
                $idbatch = $this->input->post('idbatch');
                $this->load->model('invtran_model');
                $movimientos = $this->invtran_model->getSimpleMovProduct($idbin,$idbatch);
                $cant_t = 0;
                $saldo = 0;
                $i=0;
                $array = array();
                foreach($movimientos as $mov){
                    $cant_t = $mov->cantidad * $mov->uniconv;
                    $saldo += ($mov->cantidad * $mov->uniconv);
                    
                    $vendedor_producto =  $this->invtran_model->getVendedorProducto($mov->trannum, $mov->idrec);
                    
                    $mostrar_column = "";
                    switch($mov->agrupa){
                        case "CO":
                            $mostrar_column = $mov->nombreAuxi;
                            break;
                        case "IN":
                            $mostrar_column = $mov->o_d;
                            break;
                        case "VN":
                            $mostrar_column = $mov->nombreAuxi;
                            break;
                    }
                    $array[$i] = array(
                        //"agrupa" => $mov->agrupa,
                        "fecha" => $mov->fecha,
                        //"fecact" => $mov->fecact,
                        //"notas_doc" => $mov->notas_doc,
                        //"referencia_doc" => $mov->referencia_doc,
                        "trannum" => $mov->trannum,
                        //"o_d" => $mostrar_column,
                        "descrip" => $mov->descrip,
                        //"marca" => $mov->marca,
                        "num" => $mov->num,
                        "um" => $mov->um,
                        "idrec" => $mov->idrec,
                        //"itemline" => $mov->itemline,
                        //"usuario" => $mov->usuario,
                        "ingresa" => $mov->ingresa,
                        //"modifica" => $mov->modifica,
                        "suma_salidas" => $mov->suma_salidas,
                        "cantidad" => number_format($cant_t, 4, '.', ''),
                        "saldo" => number_format($saldo, 4, '.', ''),
                        "vendedor_producto" => $vendedor_producto,
                        //"nameidworker" => $mov->nameidworker,
                        //"notas" => $mov->notas,
                        "costounitario" => $mov->costounitario,
                        "preciotran" => $mov->preciotran,
                        "precioneto" => $mov->precioneto,
                        "nombreAuxi" => $mostrar_column,
                        "notasM" => $mov->notasM,
                        "notasHD" => $mov->notasHD,
                        "estatus" => $mov->estatus,


                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }

        function getMoreDetailKardex(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                
                $this->load->model('invtran_model');
                $movimientos = $this->invtran_model->getMoreDetailKardex( $idrec );

                $i=0;
                $array = array();
                foreach($movimientos as $mov){
                    $vendedor_producto =  $this->invtran_model->getVendedorProducto($mov->trannum, $mov->idrec);
                    $mostrar_column = "";
                    
                    switch($mov->agrupa){
                        case "CO":
                            $mostrar_column = $mov->cliente_proveedor;
                            break;
                        case "IN":
                            $mostrar_column = $mov->o_d;
                            break;
                        case "VN":
                            $mostrar_column = $mov->cliente_proveedor;
                            break;
                    }
                    
                    $array[$i] = array(
                        "agrupa" => $mov->agrupa,
                        "fecha" => $mov->fecha,
                        "fecact" => $mov->fecact,
                        "notas_doc" => $mov->notas_doc,
                        "referencia_doc" => $mov->referencia_doc,
                        "trannum" => $mov->trannum,
                        "o_d" => $mostrar_column,
                        "descrip" => $mov->descrip,
                        "marca" => $mov->marca,
                        "num" => $mov->num,
                        "um" => $mov->um,
                        "idrec" => $mov->idrec,
                        "itemline" => $mov->itemline,
                        "usuario" => $mov->usuario,
                        "ingresa" => $mov->ingresa,
                        "modifica" => $mov->modifica,
                        "vendedor_producto" => $vendedor_producto,
                        "nameidworker" => $mov->nameidworker,
                        "notas" => $mov->notas,
                        "costounitario" => $mov->costounitario,
                        "preciotran" => $mov->preciotran,
                        "precioneto" => $mov->precioneto,
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
		function getMovProductPeriodo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $idcentro = $this->input->post('idcentro');
                $desde = $this->input->post('desde');
                $hasta = $this->input->post('hasta');
                $this->load->model('invtran_model');
                
                $inicial = $this->invtran_model->getMovProductInicial($idproducto,$idcentro,$desde,$hasta);
                $movimientos = $this->invtran_model->getMovProductPeriodo($idproducto,$idcentro,$desde,$hasta);
                $cant_t = 0;
                $saldo = 0;
                $i=0;
                $array = array();
                foreach($inicial as $ini){
                    $cant_t = $ini->subtotal;
                    $saldo += $ini->subtotal;
                    $mostrar_column = "";
                    
                    $array[$i] = array(
                        "agrupa" => "",
                        "fecha" => "",
                        "fecact" => "",
                        "notas_doc" => 0,
                        "referencia_doc" =>0,
                        "trannum" => 0,
                        "o_d" => "-",
                        "descrip" => "SALDO INICIAL",
                        "marca" => "",
                        "num" => "",
                        "um" => "",
                        "suma_salidas" => $ini->suma_salidas,
                        "cantidad" => round($cant_t,2),
                        "saldo" => round($saldo,2),
                        "vendedor_producto" => "",
                        "notas" => "",
                    );
                    $i++;
                }
                foreach($movimientos as $mov){
                    $cant_t = $mov->cantidad * $mov->uniconv;
                    $saldo += ($mov->cantidad * $mov->uniconv);
					$vendedor_producto =  $this->invtran_model->getVendedorProducto($mov->trannum, $mov->idrec);
                    $mostrar_column = "";
                    switch($mov->agrupa){
                        case "CO":
                            $mostrar_column = $mov->cliente_proveedor;
                            break;
                        case "IN":
                            $mostrar_column = $mov->o_d;
                            break;
                        case "VN":
                            $mostrar_column = $mov->cliente_proveedor;
                            break;
                    }
                    
                    $array[$i] = array(
                        "agrupa" => $mov->agrupa,
                        "fecha" => $mov->fecha,
                        "fecact" => $mov->fecact,
                        "notas_doc" => $mov->notas_doc,
                        "referencia_doc" => $mov->referencia_doc,
                        "trannum" => $mov->trannum,
                        "o_d" => $mostrar_column,
                        "descrip" => $mov->descrip,
                        "marca" => $mov->marca,
                        "num" => $mov->num,
                        "um" => $mov->um,
                        "idrec" => $mov->idrec,
                        "itemline" => $mov->itemline,
                        "usuario" => $mov->usuario,
                        "ingresa" => $mov->ingresa,
                        "modifica" => $mov->modifica,
                        "suma_salidas" => $mov->suma_salidas,
                        "cantidad" => round($cant_t,2),
                        "saldo" => round($saldo,2),
                        "vendedor_producto" => $vendedor_producto,
                        "notas" => $mov->notas,
                        "preciotran" => $mov->preciotran,
                        "precioneto" => $mov->precioneto,
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
        function getMovProduct_location(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idbin = $this->input->post('idbin');
                $idbatch = $this->input->post('idbatch');
                $this->load->model('invtran_model');
                $movimientos = $this->invtran_model->getMovProduct($idbin,$idbatch);
                $i=0;
                $array = array();
                foreach($movimientos as $mov){
                    
                    if($i==0){
                        $saldo=$mov->cantidad;
                    }else{
                        $saldo+=$mov->cantidad;
                    }
                    
					if($saldo % 1 == 0) {
						$saldo = round($saldo);
					}else{
						$saldo = round($saldo,2);
					}
                	
                    if($mov->cantidad % 1 == 0) {
						$cantidad = round($mov->cantidad);
					}else{
						$cantidad = round($mov->cantidad,2);
					}
                    $array[$i] = array(
                        "fecha" => $mov->fecha,
                        "trannum" => $mov->trannum,
                        "descrip" => $mov->descrip,
                        "tipomov" => $mov->invclase,
                        "num" => $mov->num,
                        "cantidad" => $cantidad,
                        "saldo" => $saldo,
                    );
                    $i++;
                }
                $tipos = $this->invtran_model->getDistictMov($idbin,$idbatch);
                $array_tipos = array();
                $i=1;
                $array_tipos[0] = array(
                    "ID" => "0",
                    "text" => "--TODOS--"
                );
                foreach($tipos as $t){
                    $array_tipos[$i] = array(
                        "ID" => $t->invclase,
                        "text" => $t->descrip
                    );
                    $i++;
                }
                
                $info = array(
                    "data" => $array,
                    "tipos" => $array_tipos,
                );
                
                echo json_encode($info);
            }
        }
        
        function getInventariosSucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idsucursales = $this->input->post('id_sucursales');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');
                $inventario = $this->invtran_model->getInventarioSucursales($idsucursales);
                $sucursales = $this->sucursal_model->viewSucursal();
                
                $array = array(
                    "inventario" => $inventario,
                    "sucursales" => $sucursales
                );
				
                echo json_encode($array);
            }
        }
       
        function ajustes($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $idclases = $this->configuracion_model->getOptionsByidapp($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'idclass' => $idclases
                );
                $this->session->set_userdata($resultAppName);
                
                $infoClases = explode(",", $idclases);
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['id_favor'] = $infoClases[0];
				$this->data['id_contra'] = $infoClases[1];
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;

                $this->load->view('mantenimiento_ajustesinv', $this->data);
            }
        }
        
        function adicionarAjuste(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $notas = trim($this->input->post('notas'));
                $referencia = $this->input->post('referencia');
                $recuento = $this->input->post('recuento');
                $id_favor = $this->input->post('id_favor');
                $id_contra = $this->input->post('id_contra');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model'); $this->load->model('tpedido_model');
                $validate = $this->invtran_model->validateInsertAjuste($idcentro, 99, 0);

                if($validate == true){
                    if($recuento == 1){
                        $validate2 = $this->invtran_model->validateInsertAjusteTransacciones($idcentro, 0);
                        if($validate2 == true){
                            $validate2 = $this->tpedido_model->getCountListadoLotesPedidos($idcentro, 'PP');
                        }
                        
                        if($validate2 == true){
                            $idajuste = $this->invtran_model->insertarAjusteInv($fecha, $notas, $idcentro, 99, $referencia, $recuento, $id_favor, $id_contra);
                            $array = array(
                                "idajuste" => $idajuste
                            );
                        }else{
                            $infoPendientes = $this->invtran_model->getDatosTransaccionesPendientes($idcentro, 0);
                            
                            $i=0;
                            $datosPendientes = array();
                            
                            if($infoPendientes != false){
                                foreach($infoPendientes as $info){
                                    $datosPendientes[$i] = array(
                                        "trannum" => $info->trannum,
                                        "agrupa" => $info->agrupa,
                                        "descrip" => $info->descrip,
                                        "fecha" => $info->fecha
                                    );
                                    
                                    $i++;
                                }
                            }
                            
                            $infoPreparacion = $this->tpedido_model->getInformacionListadoLotesPedidos($idcentro, 'PP');
                            
                            if($infoPreparacion != false){
                                foreach($infoPreparacion as $info){
                                    $datosPendientes[$i] = array(
                                        "trannum" => $info->trannum,
                                        "agrupa" => 'PP',
                                        "descrip" => 'Preparacion de Pedidos',
                                        "fecha" => $info->fecha
                                    );
                                    
                                    $i++;
                                }
                            }
                            
                            $array = array(
                                "error" => 2,
                                "datos" => $datosPendientes
                            );
                        }
                    }else{
                        $idajuste = $this->invtran_model->insertarAjusteInv($fecha, $notas, $idcentro, 99, $referencia, $recuento, $id_favor, $id_contra);
                        $array = array(
                            "idajuste" => $idajuste
                        );   
                    }   
                }else{
					$array = array(
						"error" => 0
					);
                }
                
                echo json_encode($array);
            }
        }

        function adicionarPlusAjuste(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $notas = trim($this->input->post('notas'));
                $referencia = $this->input->post('referencia');
                $recuento = $this->input->post('recuento');
                $id_favor = $this->input->post('id_favor');
                $id_contra = $this->input->post('id_contra');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model'); $this->load->model('tpedido_model');
                $validate = $this->invtran_model->validateInsertAjuste($idcentro, 99, 0);
                if($validate == true){
                    $idajuste = $this->invtran_model->insertarAjusteInv($fecha, $notas, $idcentro, 99, $referencia, $recuento, $id_favor, $id_contra);
                    $array = array(
                        "idajuste" => $idajuste
                    );
                }else{
					$array = array(
						"error" => 0
					);
                }
                
                echo json_encode($array);
            }
        }
        
        function getDatosDeAjustes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $datos = $this->invtran_model->getDatosAjustesInv($idcentro, 99, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                if($datos != false){
                    foreach($datos as $info){
                        $trannumAjustes = "";
                        
                        if($info->cli_email != ""){
                            $infonums = explode(",", $info->cli_email);
                            if(count($infonums) == 1){
                                $trannumAjustes = $infonums[0];
                            }else{
                                $trannumAjustes = $infonums[0]." / ".$infonums[1];
                            }
                        }
                        
                        if($info->cli_notify == 0){
                            $tipoajuste = "Parcial";
                        }else{
                            $tipoajuste = "Total";
                        }

                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "fecha" => $info->fecha,
                            "referencia" => $info->referencia,
                            "tipoajuste" => $tipoajuste,
                            "notas" => $info->notas,
                            "estatus" => $info->estatus,
                            "ajustesnum" => $trannumAjustes,
                            "lineas" => $info->lines100k,
                            "iduser" => $info->user
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getProductsAjuste(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
                
                $this->load->model('invtran_model');
                $datos = $this->invtran_model->getDetailAjusteMaster($trannum);
                echo json_encode($datos);
            }
        }
		
		function getPendientesImpresionAjuste(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclases = $this->session->userdata('idclass');
                
				$numclases = explode(',', $idclases);
                $this->load->model('invtran_model');
				$datos = $this->invtran_model->getPendientesImpresionAjustes($numclases[0], $numclases[1], 0);
                    
				$i=0;
				$detalle = array();
				foreach($datos as $data){
					$detalle[$i] = array(
						"trannum" => $data->trannum,
						"descrip" => $data->tipoajuste,
					);
					$i++;
				}
				
				$array = array(
					"datos" => $detalle,
					"cantidad" => $i
				);
				echo json_encode($array);
            }
		}
        
        function verDetAjusteInvUpdate($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getInformacionAjuste($idtrannum);
                $this->data['dispositivo'] = $this->global_model->detectarDispositivo();
                $nameVariable = 'rf_clave0'.$idcentro;
                $this->data['rf_clave'] = $this->global_model->getValorTextoVariable($nameVariable);
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                $this->load->view('mantenimiento_detalle_ajusteinv_chg', $this->data);
            }
        }
        
        function verDetAjusteInv($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getInformacionAjuste($idtrannum);
                $this->data['dispositivo'] = $this->global_model->detectarDispositivo();
                $nameVariable = 'rf_clave0'.$idcentro;
                $this->data['rf_clave'] = $this->global_model->getValorTextoVariable($nameVariable);
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }
                $this->session->set_userdata($array);
                $this->load->view('mantenimiento_detalle_ajusteinv_mod', $this->data);
            }
        }

        function verDetAjusteInv2($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getInformacionAjuste($idtrannum);
                $this->data['dispositivo'] = $this->global_model->detectarDispositivo();
                $nameVariable = 'rf_clave0'.$idcentro;
                $this->data['rf_clave'] = $this->global_model->getValorTextoVariable($nameVariable);
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                $this->load->view('mantenimiento_detalle_ajusteinv_mod2', $this->data);
            }
        }
        
        function insertOrders_100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $sistema = $this->input->post('sistema');
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $notas = trim($this->input->post('notas'));
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $this->invtran_model->insertAjuste100k($sistema, $cantidad, $idbatch, $idbin, $idproducto, $um, $trannum, $precio, $notas);
                
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $detalle = $this->invtran_model->getInventarioByCatalogAjuste($trannum,$idcatalogo,$idcentro, $fechaIngresaRF);
                
                $filtro = $this->input->post('filtro');
                switch($filtro){
                    case 1:
                        $datos = $this->invtran_model->getDataAjusteSinAjuste($trannum, $fechaIngresaRF);
                        break;
                    case 2:
                        $datos = $this->invtran_model->getDataAjusteContra($trannum, $fechaIngresaRF);
                        break;
                    case 3:
                        $datos = $this->invtran_model->getDataAjusteFavor($trannum, $fechaIngresaRF);
                        break;
                    case 4:
                        $datos = $this->invtran_model->getDataAjuste100k($trannum, $fechaIngresaRF);
                        break;
                    default:
                        $datos = $this->invtran_model->getDataAjuste100k($trannum, $fechaIngresaRF);
                }
                                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $i
                );
                                
                echo json_encode($array);    
            }
        }
        
        function deleteRegistroAjuste(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $this->invtran_model->deleteDataOrders100k($idrec);
                
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $detalle = $this->invtran_model->getInventarioByCatalogAjuste($trannum,$idcatalogo,$idcentro,$fechaIngresaRF);
                
                $filtro = $this->input->post('filtro');
                switch($filtro){
                    case 1:
                        $datos = $this->invtran_model->getDataAjusteSinAjuste($trannum, $fechaIngresaRF);
                        break;
                    case 2:
                        $datos = $this->invtran_model->getDataAjusteContra($trannum, $fechaIngresaRF);
                        break;
                    case 3:
                        $datos = $this->invtran_model->getDataAjusteFavor($trannum, $fechaIngresaRF);
                        break;
                    case 4:
                        $datos = $this->invtran_model->getDataAjuste100k($trannum, $fechaIngresaRF);
                        break;
                    default:
                        $datos = $this->invtran_model->getDataAjuste100k($trannum, $fechaIngresaRF);
                }
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $i
                );
                                
                echo json_encode($array);
            }
        }
        
        function updateOrders_100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $cantSistema = $this->input->post('cantSistema');
                $notas = trim($this->input->post('notas'));
                $idcatalogo = $this->input->post('idcatalogo');
                $trannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');                
                $this->invtran_model->updateAjuste100k($idrec, $cantidad, $cantSistema, $notas);
                
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $detalle = $this->invtran_model->getInventarioByCatalogAjuste($trannum,$idcatalogo,$idcentro,$fechaIngresaRF);
                
                $filtro = $this->input->post('filtro');
                switch($filtro){
                    case 1:
                        $datos = $this->invtran_model->getDataAjusteSinAjuste($trannum, $fechaIngresaRF);
                        break;
                    case 2:
                        $datos = $this->invtran_model->getDataAjusteContra($trannum, $fechaIngresaRF);
                        break;
                    case 3:
                        $datos = $this->invtran_model->getDataAjusteFavor($trannum, $fechaIngresaRF);
                        break;
                    case 4:
                        $datos = $this->invtran_model->getDataAjuste100k($trannum, $fechaIngresaRF);
                        break;
                    default:
                        $datos = $this->invtran_model->getDataAjuste100k($trannum, $fechaIngresaRF);
                }
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
					"cantidad" => $i
                );
                                
                echo json_encode($array);    
            }
        }
        
        function updateVenta100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $trannum = $this->input->post('idtrannum');
                $notas = trim($this->input->post('notas'));
                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
				
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $precio = $this->input->post('precio');
                $descuento = $this->input->post('descuento');
                
                $this->load->model('invtran_model');                
                $this->invtran_model->actualizarVenta100k($idrec, $trannum, $cantidad, $precio, $descuento, $notas, $tipotax,$pro_vende,$modevn);
                $this->invtran_model->deleteVenta100c($trannum);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                $cantidades = $this->invtran_model->getCantidadesCatalogo($trannum, $idcentro);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "precio" => $info->costounitario,
                        "idbin" => $info->idbin,
                        "idbatch" => $info->idbatch,
                        "precioventa" => $info->precioventa,
                        "tipotax" => $info->tipotax
                    );
                    $i++;
                }
                
                $total = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i,
                    "total" => $total,
                    "sumagrupos" => $cantidades
                );
                                
                echo json_encode($array);    
            }
        }
		
		function updateVenta100kPrueba(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $trannum = $this->input->post('idtrannum');
                $notas = trim($this->input->post('notas'));
                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
				
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $precio = $this->input->post('precio');
                $descuento = $this->input->post('descuento');
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                $this->invtran_model->actualizarVenta100k($idrec, $trannum, $cantidad, $precio, $descuento, $notas, $tipotax, $pro_vende,$modevn);
                $this->invtran_model->deleteVenta100c($trannum);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                $cantidades = $this->invtran_model->getCantidadesCatalogo($trannum, $idcentro);
				$servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
					$items[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$i++;
                }
				
				foreach($servicios as $serv){
					$items[$i] = array(
						"nameproducto" => $serv->descrip,
						"marca" => $serv->marca,
						"modelo" => $serv->modelo,
						"upc" => $serv->barcode,
						"notas" => $serv->notas,
						"idproducto" => $serv->idproducto,
						"tipo" => $serv->tipo,
						"um" => $serv->um,
						"imagen" => $serv->imagen,
						"cantidad" => $serv->cantidad,
						"precio" => $serv->costounitario,
						"idbin" => $serv->idbin,
						"idbatch" => $serv->idbatch,
						"precioventa" => $serv->precioventa,
						"idcatalogo" => $serv->idcatalogo,
						"tipotax" => $serv->tipotax
					);
					$i++;
				}
                
                $total = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                }
                
				$inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                $k=0;
                $inventario = array();
                foreach($inventariomore as $info){
					$inventario[$k] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$k++;
                }
				
				$inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
				foreach($inventariomore as $info){
					$inventario[$k] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$k++;
                }
				
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i,
                    "total" => $total,
                    "sumagrupos" => $cantidades,
					"inventario" => $inventario
                );
                                
                echo json_encode($array);    
            }
		}
		
		function updateVenta100kSimple(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $trannum = $this->input->post('idtrannum');
                $notas = trim($this->input->post('notas'));
                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
				
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $precio = $this->input->post('precio');
                $descuento = $this->input->post('descuento');
                
                $this->load->model('invtran_model');
                $this->load->model('ventas_model');
                $this->invtran_model->actualizarVenta100k($idrec, $trannum, $cantidad, $precio, $descuento, $notas, $tipotax, $pro_vende,$modevn);
                $this->ventas_model->deleteVenta100c($trannum);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
					$items[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"tipo" => $info->tipo,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"precio" => $info->costounitario,
						"idbin" => $info->idbin,
						"idbatch" => $info->idbatch,
						"precioventa" => $info->precioventa,
						"idcatalogo" => $info->idcatalogo,
						"tipotax" => $info->tipotax
					);
					$i++;
                }
				
				foreach($servicios as $serv){
					$items[$i] = array(
						"nameproducto" => $serv->descrip,
						"marca" => $serv->marca,
						"modelo" => $serv->modelo,
						"upc" => $serv->barcode,
						"notas" => $serv->notas,
						"idproducto" => $serv->idproducto,
						"tipo" => $serv->tipo,
						"um" => $serv->um,
						"imagen" => $serv->imagen,
						"cantidad" => $serv->cantidad,
						"precio" => $serv->costounitario,
						"idbin" => $serv->idbin,
						"idbatch" => $serv->idbatch,
						"precioventa" => $serv->precioventa,
						"idcatalogo" => $serv->idcatalogo,
						"tipotax" => $serv->tipotax
					);
					$i++;
				}
                
                $total = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                }
				
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i,
                    "total" => $total
                );
                                
                echo json_encode($array);    
            }
		}
        
        function getDatosCierreAjuste(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $datos = $this->invtran_model->getDataAjuste100k($trannum, $fechaIngresaRF);
				
				$cantFavor = 0; $cantContra = 0; $uniFavor = 0;
                $uniContra = 0; $costoFavor = 0; $costoContra = 0;
                $costoInv = 0; $cantInv = 0; $uniInv = 0;
				
                foreach($datos as $info){
					$cantAjuste = $info->cantrp - $info->cantidad;
                    if($cantAjuste >= 0){
                        $cantFavor++;
                        $uniFavor = $uniFavor + $cantAjuste;
                        $valorFav =  $cantAjuste * $info->precioneto;
                        $costoFavor = $costoFavor + $valorFav;
                    }else{
                        $cantContra++;
                        $uniContra = $uniContra + $cantAjuste;
                        $valorCon =  $cantAjuste * $info->precioneto;
                        $costoContra = $costoContra + $valorCon;
                    }
                    
                    $costoInv = $costoInv + ($info->cantidad * $info->precioneto);
                    $cantInv++;
                    $uniInv = $uniInv + $info->cantidad;
                }
                
				$array = array(
                    "cantFavor" => $cantFavor,
                    "cantContra" => $cantContra,
                    "uniFavor" => $uniFavor,
                    "uniContra" => $uniContra,
                    "costoContra" => $costoContra,
                    "costoFavor" => $costoFavor,
                    "costoInv" => $costoInv,
                    "cantInv" => $cantInv,
                    "uniInv" => $uniInv
                );
                                
                echo json_encode($array);    
            }
        }
        
        function getValidateAjusteTipo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $tiporecuento = $this->input->post('tiporecuento');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
				
				if($tiporecuento == 1){
					$pendientes = $this->invtran_model->getProductosPendientesAjuste($trannum, $idcentro);
				}
				
				$i=0;
				$informacion = array();
				if($tiporecuento == 1){
					foreach($pendientes as $inf){
						if($inf->existe == "0"){
							if($inf->cantidad != 0){
								//$fecmov = $this->invtran_model->getFechaDeUltimoMovimiento($inf->idproducto, $idcentro);
								
								$informacion[$i] = array(
									"idproducto" => $inf->idproducto,
									"nameproducto" => $inf->descrip,
									"marca" => $inf->marca,
									"modelo" => $inf->modelo,
									"cantidad" => $inf->cantidad,
                                    //"fecha" => $fecmov,
                                    "nameLinea" => $inf->nameLinea
								);
								$i++;
							}
						}
					}
				}
				
                $array = array(
					"tiporec" => $tiporecuento,
					"cantidad" => $i,
					"informacion" => $informacion
                );
                                
                echo json_encode($array);    
            }
        }
        
        function validateImportacionDatos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $listadoProductos = $this->input->post('informacion');
                $tipoIngreso = $this->input->post('tipoingreso');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                
                $infoErrores = "";
                $numErrores = 0;
                
                $datoBusqueda = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $datoRemplazo = array("_", "_", "_", "_");
                $listadoProductos = str_replace($datoBusqueda, $datoRemplazo, $listadoProductos);
                
                if($tipoIngreso == 1){
                    //CODIGO INTERNO
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==2){
                            $insert = $this->invtran_model->verificarExistenciaProductoCodigo($array_producto[0], $idcentro);
                            switch($insert){
                                case 1:
                                    $infoErrores .= "El producto con código: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $numErrores++;
                                    break;
                            }
                        }else{
                            $infoErrores .= "Datos incompletos.";
                            $numErrores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);

                            if(count($array_producto)==2){

                                if($array_producto[1] < 0){
                                    $infoErrores .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una existencia actual negativa. <br>";
                                    $numErrores++;
                                    continue;
                                }

                                $insert = $this->invtran_model->verificarExistenciaProductoCodigo($array_producto[0], $idcentro);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $infoErrores .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $numErrores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $infoErrores .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $numErrores++;
                            }
                        }
                    }
                }else if($tipoIngreso == 2){
                    //CODIGO DE BARRAS
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==2){
                            
                            $insert = $this->invtran_model->verificarExistenciaProductoBarras($array_producto[0], $idcentro);
                            switch($insert){
                                case 1:
                                    $infoErrores .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $numErrores++;
                                    break;
                            }
                        }else{
                            $infoErrores .= "Datos incompletos.";
                            $numErrores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==2){

                                if($array_producto[1] < 0){
                                    $infoErrores .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una existencia actual negativa. <br>";
                                    $numErrores++;
                                    continue;
                                }

                                $insert = $this->invtran_model->verificarExistenciaProductoBarras($array_producto[0], $idcentro);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $infoErrores .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $numErrores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $infoErrores .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $numErrores++;
                            }
                        }
                    }
                }else if($tipoIngreso == 3){
                    //MODELO
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==2){
                            $insert = $this->invtran_model->verificarExistenciaProductoModelo($array_producto[0], $idcentro);
                            switch($insert){
                                case 1:
                                    $infoErrores .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $numErrores++;
                                    break;
                            }
                        }else{
                            $infoErrores .= "Datos incompletos.";
                            $numErrores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==2){

                                if($array_producto[1] < 0){
                                    $infoErrores .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una existencia actual negativa. <br>";
                                    $numErrores++;
                                    continue;
                                }

                                $insert = $this->invtran_model->verificarExistenciaProductoModelo($array_producto[0], $idcentro);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $infoErrores .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $numErrores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $infoErrores .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $numErrores++;
                            }
                        }
                    }
                }else if($tipoIngreso == 4){
                    //XPOS
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==2){
                            $insert = $this->invtran_model->verificarExistenciaProductoXpos($array_producto[0], $idcentro);
                            switch($insert){
                                case 1:
                                    $infoErrores .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $numErrores++;
                                    break;
                            }
                        }else{
                            $infoErrores .= "Datos incompletos.";
                            $numErrores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==2){

                                if($array_producto[1] < 0){
                                    $infoErrores .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una existencia actual negativa. <br>";
                                    $numErrores++;
                                    continue;
                                }

                                $insert = $this->invtran_model->verificarExistenciaProductoXpos($array_producto[0], $idcentro);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $infoErrores .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $numErrores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $infoErrores .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $numErrores++;
                            }
                        }
                    }
                }else{
                    $numErrores++;
                    $infoErrores = "TIPOS DE INGRESO EN MANTENIMIENTO";
                }
                
                $array_send = array(
                    "errores" => $numErrores,
                    "mensaje" => $infoErrores,
                );
                
                echo json_encode($array_send);
            }
        }

        function validateImportacionDatosTraslados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $listadoProductos = $this->input->post('informacion');
                $tipoIngreso = $this->input->post('tipoingreso');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                
                $infoErrores = "";
                $numErrores = 0;
                
                $datoBusqueda = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $datoRemplazo = array("_", "_", "_", "_");
                $listadoProductos = str_replace($datoBusqueda, $datoRemplazo, $listadoProductos);
                
                $arrayProductos = array();

                if($tipoIngreso == 1){
                    //CODIGO INTERNO
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==2){
                            $insert = $this->invtran_model->verificarExistenciaProductoCodigo($array_producto[0], $idcentro);
                            switch($insert){
                                case 1:
                                    $infoErrores .= "El producto con código: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    //$numErrores++;
                                    $infoNuevo = array(
                                        "idproducto" => $array_producto[0],
                                        "descrip"    => "PRODUCTO CODIGO " . $array_producto[0] . " NO ENCONTRADO",
                                        "info_txt"   => $array_producto[0].",".$array_producto[1],
                                        "cantidad"   => 0,
                                        "saldo"      => 0
                                    );

                                    $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                break;
                                case 0:
                                    $infoNuevo = $this->invtran_model->getSaldoProducto($array_producto[0], $array_producto[1], 'idproducto', $idcentro);
                                    $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                break;
                            }
                        }else{
                            $infoErrores .= "Datos incompletos.";
                            $numErrores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==2){
                                if($array_producto[1] < 0){
                                    $infoErrores .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $infoNuevo = array(
                                        "idproducto" => $array_producto[0],
                                        "descrip"    => "CANTIDAD NEGATIVA INGRESADA",
                                        "info_txt"   => $array_producto[0].",".$array_producto[1],
                                        "cantidad"   => 0,
                                        "saldo"      => 0
                                    );

                                    $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    continue;
                                }

                                $insert = $this->invtran_model->verificarExistenciaProductoCodigo($array_producto[0], $idcentro);
                                switch($insert){
                                    case 1:
                                        $infoErrores .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        //$numErrores++;
                                        $infoNuevo = array(
                                            "idproducto" => $array_producto[0],
                                            "descrip"    => "PRODUCTO CODIGO " . $array_producto[0] . " NO ENCONTRADO",
                                            "info_txt"   => $array_producto[0].",".$array_producto[1],
                                            "cantidad"   => 0,
                                            "saldo"      => 0
                                        );
    
                                        $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    break;
                                    case 0:
                                        $infoNuevo = $this->invtran_model->getSaldoProducto($array_producto[0], $array_producto[1], 'idproducto', $idcentro);
                                        $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    break;
                                }
                            }else{
                                $infoErrores .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $numErrores++;
                            }
                        }
                    }
                }else if($tipoIngreso == 2){
                    //CODIGO DE BARRAS
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==2){
                            $insert = $this->invtran_model->verificarExistenciaProductoBarras($array_producto[0], $idcentro);
                            switch($insert){
                                case 1:
                                    $infoErrores .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $numErrores++;
                                    break;
                                case 0:
                                    $infoSaldo = $this->invtran_model->getSaldoProducto($array_producto[0], $array_producto[1], 'barcode', $idcentro);

                                    switch($infoSaldo){
                                        case 0:
                                            $infoErrores .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> no tiene saldo suficiente para ser ingresado.";
                                            $numErrores++;
                                            break;
                                        default:
                                            array_push($arrayProductos, $infoSaldo);
                                            break;
                                    }
                                    break;
                            }
                        }else{
                            $infoErrores .= "Datos incompletos.";
                            $numErrores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==2){

                                if($array_producto[1] < 0){
                                    $infoErrores .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $infoNuevo = array(
                                        "idproducto" => $array_producto[0],
                                        "descrip"    => "CANTIDAD NEGATIVA INGRESADA",
                                        "info_txt"   => $array_producto[0].",".$array_producto[1],
                                        "cantidad"   => 0,
                                        "saldo"      => 0
                                    );

                                    $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    continue;
                                }

                                $insert = $this->invtran_model->verificarExistenciaProductoBarras($array_producto[0], $idcentro);
                                switch($insert){
                                    case 1:
                                        $infoErrores .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        //$numErrores++;
                                        $infoNuevo = array(
                                            "idproducto" => $array_producto[0],
                                            "descrip"    => "PRODUCTO CODIGO " . $array_producto[0] . " NO ENCONTRADO",
                                            "info_txt"   => $array_producto[0].",".$array_producto[1],
                                            "cantidad"   => 0,
                                            "saldo"      => 0
                                        );
    
                                        $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    break;
                                    case 0:
                                        $infoNuevo = $this->invtran_model->getSaldoProducto($array_producto[0], $array_producto[1], 'barcode', $idcentro);
                                        $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    break;
                                }
                            }else{
                                $infoErrores .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $numErrores++;
                            }
                        }
                    }
                }else if($tipoIngreso == 3){
                    //MODELO
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==2){
                            $insert = $this->invtran_model->verificarExistenciaProductoModelo($array_producto[0], $idcentro);
                            switch($insert){
                                case 1:
                                    $infoErrores .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    //$numErrores++;
                                    $infoNuevo = array(
                                        "idproducto" => $array_producto[0],
                                        "descrip"    => "PRODUCTO CODIGO " . $array_producto[0] . " NO ENCONTRADO",
                                        "info_txt"   => $array_producto[0].",".$array_producto[1],
                                        "cantidad"   => 0,
                                        "saldo"      => 0
                                    );

                                    $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                break;
                                case 0:
                                    $infoNuevo = $this->invtran_model->getSaldoProducto($array_producto[0], $array_producto[1], 'modelo', $idcentro);
                                    $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                break;
                            }
                        }else{
                            $infoErrores .= "Datos incompletos.";
                            $numErrores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==2){

                                if($array_producto[1] < 0){
                                    $infoErrores .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $infoNuevo = array(
                                        "idproducto" => $array_producto[0],
                                        "descrip"    => "CANTIDAD NEGATIVA INGRESADA",
                                        "info_txt"   => $array_producto[0].",".$array_producto[1],
                                        "cantidad"   => 0,
                                        "saldo"      => 0
                                    );

                                    $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    continue;
                                }


                                $insert = $this->invtran_model->verificarExistenciaProductoModelo($array_producto[0], $idcentro);
                                switch($insert){
                                    case 1:
                                        $infoErrores .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        //$numErrores++;
                                        $infoNuevo = array(
                                            "idproducto" => $array_producto[0],
                                            "descrip"    => "PRODUCTO CODIGO " . $array_producto[0] . " NO ENCONTRADO",
                                            "info_txt"   => $array_producto[0].",".$array_producto[1],
                                            "cantidad"   => 0,
                                            "saldo"      => 0
                                        );
    
                                        $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    break;
                                    case 0:
                                        $infoNuevo = $this->invtran_model->getSaldoProducto($array_producto[0], $array_producto[1], 'modelo', $idcentro);
                                        $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    break;
                                }
                            }else{
                                $infoErrores .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $numErrores++;
                            }
                        }
                    }
                }else if($tipoIngreso == 4){
                    //XPOS
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==2){
                            $insert = $this->invtran_model->verificarExistenciaProductoXpos($array_producto[0], $idcentro);
                            switch($insert){
                                case 1:
                                    $infoErrores .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    //$numErrores++;
                                    $infoNuevo = array(
                                        "idproducto" => $array_producto[0],
                                        "descrip"    => "PRODUCTO CODIGO " . $array_producto[0] . " NO ENCONTRADO",
                                        "info_txt"   => $array_producto[0].",".$array_producto[1],
                                        "cantidad"   => 0,
                                        "saldo"      => 0
                                    );

                                    $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                break;
                                case 0:
                                    $infoNuevo = $this->invtran_model->getSaldoProducto($array_producto[0], $array_producto[1], 'xpos', $idcentro);
                                    $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                break;
                            }
                        }else{
                            $infoErrores .= "Datos incompletos.";
                            $numErrores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==2){

                                if($array_producto[1] < 0){
                                    $infoErrores .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $infoNuevo = array(
                                        "idproducto" => $array_producto[0],
                                        "descrip"    => "CANTIDAD NEGATIVA INGRESADA",
                                        "info_txt"   => $array_producto[0].",".$array_producto[1],
                                        "cantidad"   => 0,
                                        "saldo"      => 0
                                    );

                                    $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    continue;
                                }

                                $insert = $this->invtran_model->verificarExistenciaProductoXpos($array_producto[0], $idcentro);
                                switch($insert){
                                    case 1:
                                        $infoErrores .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        //$numErrores++;
                                        $infoNuevo = array(
                                            "idproducto" => $array_producto[0],
                                            "descrip"    => "PRODUCTO CODIGO " . $array_producto[0] . " NO ENCONTRADO",
                                            "info_txt"   => $array_producto[0].",".$array_producto[1],
                                            "cantidad"   => 0,
                                            "saldo"      => 0
                                        );
    
                                        $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    break;
                                    case 0:
                                        $infoNuevo = $this->invtran_model->getSaldoProducto($array_producto[0], $array_producto[1], 'xpos', $idcentro);
                                        $arrayProductos = $this->getInfoProductsGrid($arrayProductos, $infoNuevo);
                                    break;
                                }
                            }else{
                                $infoErrores .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $numErrores++;
                            }
                        }
                    }
                }else{
                    $numErrores++;
                    $infoErrores = "TIPOS DE INGRESO EN MANTENIMIENTO";
                }
                
                $array_send = array(
                    "errores" => $numErrores,
                    "mensaje" => $infoErrores,
                    "informacion" => $arrayProductos
                );
                
                echo json_encode($array_send);
            }
        }
        
        /*
        function deleteProductoImportacionTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $listadoProductos = $this->input->post('informacion');
                $tipoIngreso = $this->input->post('tipoingreso');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                
                $infoErrores = "";
                $numErrores = 0;
                
                $datoBusqueda = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $datoRemplazo = array("_", "_", "_", "_");
                $listadoProductos = str_replace($datoBusqueda, $datoRemplazo, $listadoProductos);
            }
        }*/

        function getInfoProductsGrid($infoProductos, $newProducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $i=0; $append=0;
                $array = array();
                //echo print_r($infoProductos);
                if(count($infoProductos) != 0){
                    //echo $newProducto['idproducto'];
                    for($j=0; $j<count($infoProductos); $j++){
                        //echo $infoProductos[$j]['idproducto'];

                        if($infoProductos[$j]['idproducto'] == $newProducto['idproducto']){
                            $array[$i] = array(
                                "idproducto" => $infoProductos[$j]['idproducto'],
                                "descrip" => $infoProductos[$j]['descrip'],
                                "cantidad" => $infoProductos[$j]['cantidad'] + $newProducto['cantidad'],
                                "info_txt" => $infoProductos[$j]['info_txt'],
                                "saldo" => $infoProductos[$j]['saldo']
                            );

                            $append=1;
                        }else{
                            $array[$i] = array(
                                "idproducto" => $infoProductos[$j]['idproducto'],
                                "descrip" => $infoProductos[$j]['descrip'],
                                "cantidad" => $infoProductos[$j]['cantidad'],
                                "info_txt" => $infoProductos[$j]['info_txt'],
                                "saldo" => $infoProductos[$j]['saldo']
                            );
                        }
                        $i++;
                    }

                    if($append == 0){
                        $array[$i] = array(
                            "idproducto" => $newProducto['idproducto'],
                            "descrip" => $newProducto['descrip'],
                            "cantidad" => $newProducto['cantidad'],
                            "info_txt" => $newProducto['info_txt'],
                            "saldo" => $newProducto['saldo']
                        );
                    }
                }else{
                    $array[$i] = array(
                        "idproducto" => $newProducto['idproducto'],
                        "descrip" => $newProducto['descrip'],
                        "cantidad" => $newProducto['cantidad'],
                        "info_txt" => $newProducto['info_txt'],
                        "saldo" => $newProducto['saldo']
                    );
                }

                return $array;
            }
        }
        
        function generarImportacionDatos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $listadoProductos = $this->input->post('informacion');
                $tipoIngreso = $this->input->post('tipoingreso');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                
                $datoBusqueda = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $datoRemplazo = array("_", "_", "_", "_");
                $listadoProductos = str_replace($datoBusqueda, $datoRemplazo, $listadoProductos);
                
                if($tipoIngreso == 1){
                    //CODIGO INTERNO
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        $insert = $this->invtran_model->insertarProductoAjusteImportado($array_producto[0], $array_producto[1], 'idproducto', $trannum, $idcentro, $fechaIngresaRF);
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            $insert = $this->invtran_model->insertarProductoAjusteImportado($array_producto[0], $array_producto[1], 'idproducto', $trannum, $idcentro, $fechaIngresaRF);
                        }
                    }
                }else if($tipoIngreso == 2){
                    //CODIGO DE BARRAS
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        $insert = $this->invtran_model->insertarProductoAjusteImportado($array_producto[0], $array_producto[1], 'barcode', $trannum, $idcentro, $fechaIngresaRF);
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            $insert = $this->invtran_model->insertarProductoAjusteImportado($array_producto[0], $array_producto[1], 'barcode', $trannum, $idcentro, $fechaIngresaRF);
                        }
                    }
                }else if($tipoIngreso == 3){
                    //MODELO
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        $insert = $this->invtran_model->insertarProductoAjusteImportado($array_producto[0], $array_producto[1], 'modelo', $trannum, $idcentro, $fechaIngresaRF);
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            $insert = $this->invtran_model->insertarProductoAjusteImportado($array_producto[0], $array_producto[1], 'modelo', $trannum, $idcentro, $fechaIngresaRF);
                        }
                    }
                }else if($tipoIngreso == 4){
                    //XPOS
                    $array_string = explode("_", $listadoProductos);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        $insert = $this->invtran_model->insertarProductoAjusteImportado($array_producto[0], $array_producto[1], 'xpos', $trannum, $idcentro, $fechaIngresaRF);
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            $insert = $this->invtran_model->insertarProductoAjusteImportado($array_producto[0], $array_producto[1], 'xpos', $trannum, $idcentro, $fechaIngresaRF);
                        }
                    }
                }
                
                $detalle = $this->invtran_model->getInventarioByCatalogAjuste($trannum, $idcatalogo, $idcentro, $fechaIngresaRF);
                $datos = $this->invtran_model->getDataAjuste100k($trannum, $fechaIngresaRF);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $i
                );
                                
                echo json_encode($array);
            }
        }
        
        function generarImportacionDatosTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum     = $this->input->post('trannum');
                $idcatalogo  = $this->input->post('idcatalogo');
                $informacion = $this->input->post('informacion');
                $tipoIngreso = $this->input->post('tipoingreso');
                $idclase     = $this->input->post('idclass');
                $idcentro    = $this->session->userdata('idcentrouser');
                //$idclase     = $this->session->userdata('idclass');
                
                $this->load->model('global_model');
                $this->load->model('invtran_model');
                
                $inopera    = $this->global_model->getInopera_invdef($idclase);
                $invcontrol = $this->global_model->getInvControlSite($idcentro);
                
                //$datoBusqueda     = array(chr(13).chr(10), "\r\n", "\n", "\r");
                //$datoRemplazo     = array("_", "_", "_", "_");
                //$listadoProductos = str_replace($datoBusqueda, $datoRemplazo, $listadoProductos);
                
                if($tipoIngreso == 1){
                    $nameDato = 'idproducto';
                }else if($tipoIngreso == 2){
                    $nameDato = 'idproducto';
                }else if($tipoIngreso == 3){
                    $nameDato = 'modelo';
                }else if($tipoIngreso == 4){
                    $nameDato = 'idproducto';
                }
                
                //$array_string = explode("_", $informacion);
                if(count($informacion)==1){
                    //$array_producto = explode(",", $array_string);
                    $insert = $this->invtran_model->insertarProductoTrasladoImportado($informacion[0]['idproducto'], $informacion[0]['cantidad'], $nameDato, $trannum, $idcentro, $idclase, $inopera, $invcontrol);
                }else{
                    for($i=0; $i<count($informacion); $i++){
                        $insert = $this->invtran_model->insertarProductoTrasladoImportado($informacion[$i]['idproducto'], $informacion[$i]['cantidad'], $nameDato, $trannum, $idcentro, $idclase, $inopera, $invcontrol);
                    }
                }
                
                $datos    = $this->invtran_model->getDetalleTraslado($trannum, $idcentro);
                $detalle  = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "xpos" => $info->xpos,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );

                echo json_encode($array);
            }
        }

        function generarImportacionDatosSalidas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum     = $this->input->post('trannum');
                $idcatalogo  = $this->input->post('idcatalogo');
                $informacion = $this->input->post('informacion');
                $tipoIngreso = $this->input->post('tipoingreso');
                $idclase     = $this->input->post('idclass');
                $idcentro    = $this->session->userdata('idcentrouser');
                //$idclase     = $this->session->userdata('idclass');
                
                $this->load->model('global_model');
                $this->load->model('invtran_model');
                
                $inopera    = $this->global_model->getInopera_invdef($idclase);
                $invcontrol = $this->global_model->getInvControlSite($idcentro);
                
                //$datoBusqueda     = array(chr(13).chr(10), "\r\n", "\n", "\r");
                //$datoRemplazo     = array("_", "_", "_", "_");
                //$listadoProductos = str_replace($datoBusqueda, $datoRemplazo, $listadoProductos);
                
                if($tipoIngreso == 1){
                    $nameDato = 'idproducto';
                }else if($tipoIngreso == 2){
                    $nameDato = 'barcode';
                }else if($tipoIngreso == 3){
                    $nameDato = 'modelo';
                }else if($tipoIngreso == 4){
                    $nameDato = 'xpos';
                }
                
                //$array_string = explode("_", $informacion);
                if(count($informacion)==1){
                    //$array_producto = explode(",", $array_string);
                    $insert = $this->invtran_model->insertarProductoTrasladoImportado($informacion[0]['idproducto'], $informacion[0]['cantidad'], $nameDato, $trannum, $idcentro, $idclase, $inopera, $invcontrol);
                }else{
                    for($i=0; $i<count($informacion); $i++){
                        $insert = $this->invtran_model->insertarProductoTrasladoImportado($informacion[$i]['idproducto'], $informacion[$i]['cantidad'], $nameDato, $trannum, $idcentro, $idclase, $inopera, $invcontrol);
                    }
                }
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDatosSalida($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "xpos" => $info->xpos,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );

                echo json_encode($array);
            }
        }
        
        function getInformacionIngresadaArchivo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $infoFile = $_FILES["inputArchivo"];
				$nameDocument = $infoFile["name"];
				$documentTemp = $infoFile['tmp_name'];
                
				$config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
				$config['file_name'] = $nameDocument;
				$config['over_write'] = "TRUE";
				$config['allowed_types'] = "*";
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
                        
				if($this->upload->do_upload('inputArchivo')){
					$this->load->model('invtran_model');
					$dataSource = $this->invtran_model->getInformacionIngresadaArchivo($documentTemp);
					
					unlink("./doc_cuentas/".$this->session->userdata('dirDocuments')."/". $nameDocument);
				}
				
				echo json_encode($dataSource);
            }
        }
        
        function cerrarAjusteInv(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $notas = trim($this->input->post('notas'));
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');                
                $this->load->model('global_model');                
                $infoSource = $this->invtran_model->getInformacionRecuentoFisico($trannum);
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
                $datos = $this->invtran_model->getDataAjuste100k($trannum, $fechaIngresaRF);
                $ajusteFavor = 0; $ajusteContra = 0;
                
                foreach($datos as $info){
                    $cantAjuste = $info->cantrp - $info->cantidad;
                    if($cantAjuste > 0){
                        $ajusteFavor++;
                    }else{
                        $ajusteContra++;
                    }
                }
                
                $ids = explode(',', $infoSource['id_clases']);
                $idclaseFavor = $ids[0];
                $idclaseContra = $ids[1];
                $idFavor = "";
                $idContra = "";
                
                if($ajusteFavor > 0){
                    $idFavor = $this->invtran_model->insertAjusteFavorContra($trannum, $infoSource['idcentro'], $idclaseFavor, $notas);
                    $this->invtran_model->insertDetalleAjusteFavor($idFavor, $datos, $infoSource['idcentro'], $idclaseFavor, $infoSource['idbin'], $fechaIngresaRF);
                    $this->invtran_model->callTotaliza100($idFavor, 1);
					$this->global_model->insertarRegTran100p($idFavor);
                }
                
                if($ajusteContra > 0){
                    $idContra = $this->invtran_model->insertAjusteFavorContra($trannum, $infoSource['idcentro'], $idclaseContra, $notas);
                    $this->invtran_model->insertDetalleAjusteContra($idContra, $datos, $infoSource['idcentro'], $idclaseContra, $infoSource['idbin'], $fechaIngresaRF);
                    $this->invtran_model->callTotaliza100($idContra, 1);
					$this->global_model->insertarRegTran100p($idContra);
                }
                
                $idsorder = "";
                if($idFavor != ""){
                    $idsorder = $idFavor;
                    if($idContra != ""){
                        $idsorder = $idsorder.",".$idContra;
                    }
                }else{
                    if($idContra != ""){
                        $idsorder = $idContra;
                    }
                }
                
                $array = $this->invtran_model->updateEstatusOrder_100($trannum, $infoSource['idcentro'], $idsorder, $notas, 1);
                echo json_encode($array);
            }
        }
        
        function consultainv($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $this->data['direccion'] = $controlador.'/'.$funcion;
                $this->load->model('producto_model');
                $this->load->model('invtran_model');
                $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                $this->data['lineas'] = $this->producto_model->viewLineas();
                $this->data['proveedores'] = $this->producto_model->getProvee();
                $this->data['marcas'] = $this->producto_model->verMarca();
              
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                  
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_consultasucursales', $this->data);
            }
        }
        
        function getProducts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idlinea = $this->input->post('idlinea');
                $this->load->model('invtran_model');                
                $pro = $this->invtran_model->viewProductos_Linea($idlinea);
                echo json_encode($pro);
            }
        }
        
        function getProductsLinea(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $lineas = $this->input->post('lineas');
                $this->load->model('catalog_model');
                $this->load->model('invtran_model');                
                $lista="";
                if($lineas!=""){
                    $array = explode(",", $lineas);
                    $cant = count($array);
                    $total = $cant - 1;
                    if($total==0){
                        $cat = $this->catalog_model->callRegistro($lineas);
                        foreach($cat as $c){
                            $lista .= $c->descrip; 
                        }
                    }else if($total>0){
                        for($i=0; $i<=$total; $i++){
                            $pro = $array[$i];
                            if($i==0){
                                $cat = $this->catalog_model->callRegistro($pro);
                                foreach($cat as $c){
                                    $lista .= $c->descrip; 
                                }
                                
                            }else if($i==1){
                                $lista .= " y otros."; 
                            }
                        }
                    }
                }else{
                    $lista = "";
                }
                
                $pro = $this->invtran_model->viewProductos_Linea($lineas);
                //$marc = $this->invtran_model->viewProductos_Linea_distinct($lineas);
                $marc = $this->invtran_model->getDistinctMarcas_lineas($lineas);
                $lista_provee = $this->invtran_model->getDistinctProvee_lineas($lineas);
                $can_pro=0;
                $lista_pro = "";
                foreach($pro as $p){
                    $can_pro++;
                    $lista_pro.=$p->idproduct.',';
                }
                $lista .= " ($can_pro)";
                $array = array(
                    "datos" => $pro,
                    "lineas" => $lista,
                    "lista_products" => $lista_pro,
                    "lista_marcas" => $marc,
                    "lista_provee" =>$lista_provee
                );
                echo json_encode($array);
            }
        }
        
        function getProductsProvee(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $proveedores = $this->input->post('proveedores');
                $this->load->model('proveedor_model');
                $this->load->model('invtran_model');    
                $lista="";
                if($proveedores!=""){
                    $array = explode(",", $proveedores);
                    $cant = count($array);
                    $total = $cant - 1;
                    if($total==0){
                        $pro = $this->proveedor_model->callRegistro2($proveedores);
                        foreach($pro as $p){
                            $lista .= $p->descrip; 
                        }
                    }else if($total>0){
                        for($i=0; $i<=$total; $i++){
                            $pro = $array[$i];
                            if($i==0){
                                $pro = $this->proveedor_model->callRegistro2($pro);
                                foreach($pro as $p){
                                    $lista .= $p->descrip.','; 
                                }
                                
                            }else if($i==1){
                                $lista .= " y otros."; 
                            }
                        }
                    }
                }else{
                    $lista = "";
                }
                $pro = $this->invtran_model->viewProductos_Provee($proveedores);
                $mar = $this->invtran_model->getDistinctMarcas_provee($proveedores);
                $lines = $this->invtran_model->getDistinctLineas_provee($proveedores);
                $can_pro=0;
                $lista_pro = "";
                foreach($pro as $p){
                    $can_pro++;
                    $lista_pro.=$p->idproduct.',';
                }
                $lista .= " ($can_pro)";
                $array = array(
                    "datos" => $pro,
                    "provee" => $lista,
                    "lista_products" => $lista_pro,
                    "lista_marcas" => $mar,
                    "lista_cat" => $lines
                );
                echo json_encode($array);
            }
        }
        
        function getProductsMarca(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $lista="";
                $this->load->model('invtran_model'); 
                $marcas = $this->input->post('marcas');
                if($marcas!=""){
                    $array = explode(", ", $marcas);
                    $cant = count($array);
                    $total = $cant - 1;
                    if($total==0){
                        $lista .= $marcas;
                    }else if($total>0){
                        for($i=0; $i<=$total; $i++){
                            $mar = $array[$i];
                            if($i==0){
                                $lista .= $mar;
                            }else if($i==1){
                                $lista .= " y otros."; 
                            }
                        }
                    }
                }else{
                    $lista = "";
                }             
                $pro = $this->invtran_model->viewProductos_Marcas($marcas);
                $cat = $this->invtran_model->getDistinctLineas_marcas($marcas);
                $provee = $this->invtran_model->getDistinctProvee_marcas($marcas);
                $can_pro=0;
                $lista_pro = "";
               
                foreach($pro as $m){
                    $can_pro++;
                    $lista_pro.= $m->idproduct.',';
                }
                $lista .= " ($can_pro)";
                $array = array(
                    "datos" => $pro,
                    "marcas" => $lista,
                    "lista_products" => $lista_pro,
                    "lista_cat" => $cat,
                    "lista_pro" => $provee,
                );
                echo json_encode($array);
            }
        }
        
        function getLotesProducto_selected(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getLotesProducto_selected($idproducto);
                echo json_encode($array);
            }
        }
        
        function filtros_personalizados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $primer_filtro_linea = $this->input->post('primer_filtro_linea');
                $primer_filtro_provee = $this->input->post('primer_filtro_provee');
                $primer_filtro_marca = $this->input->post('primer_filtro_marca');
                $filter_mar_selected = $this->input->post('filter_mar_selected');
                $filter_pro_selected = $this->input->post('filter_pro_selected');
                $filter_lines_selected = $this->input->post('filter_lines_selected');
                $this->load->model('invtran_model');
                $pro = $this->invtran_model->getProducts_filter($primer_filtro_linea, $primer_filtro_provee, $primer_filtro_marca, $filter_mar_selected, $filter_pro_selected, $filter_lines_selected);
                echo json_encode($pro);
            }
        }
        
        function valueinv(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,

                );
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $this->data['opcion_tipo'] = $opcionmenu;
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->load->model('sucursal_model');
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->load->model('producto_model');
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->load->view('mantenimiento_invvalorizado', $this->data);
            }
        }
        
        function getInvValorizado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idsucursal = $this->input->post('idsucursal');
                $tipopro = $this->input->post('tipopro');
                $this->load->model('invtran_model');
                if($idsucursal==999999){
                    $departamentos = $this->invtran_model->getInvValorizado_Dept_AllSucursales($tipopro);
                    $dataLineas = $this->invtran_model->getInvValorizado_Lineas_AllSucursales();
                    $costo_total = 0;

                    $i=0;
                    $array = array();
                    if($departamentos!=false){
                        foreach($departamentos as $dep_cont){
                            $costo_total += $dep_cont->costo;
                        }
                        foreach($departamentos as $dep){
                            $sum = 0;
                            $j=0;
                            $porcentaje_linea = 0;
                            $detailDepto = array();
                            foreach($dataLineas as $data){
                                $porcentaje_linea = ($data->costo/$dep->costo)*100;
                                if($data->idnivel1==$dep->idcatalogo){
                                    $detailDepto[$j] = array(
                                        "idcatalogo" => $data->idcatalogo,
                                        "linea" => $data->linea,
                                        "costo" => $data->costo,
                                        "saldo" => $data->saldo,
                                        "venta" => $data->venta,
                                        "unidades"=>$data->cant,
                                        "participacion"=>round($porcentaje_linea,2). "%",
                                    );
                                    $j++;
                                    $sum += $data->cant;
                                }
                                
                            }
                            $porcentaje = ($dep->costo/$costo_total)*100;
                            $array[$i] = array(
                                "idcatalogo" => $dep->idcatalogo,
                                "departamento" => $dep->descrip,
                                "costo" => $dep->costo,
                                "saldo" => $dep->saldo,
                                "venta" => $dep->venta,
                                "unidades"=> $sum,
                                "participacion"=> round($porcentaje,2). "%",
                                "detailDepto" => $detailDepto
                            );
                            $i++;
                        }
                    }else{
                        $array=false;
                    }
                }else{
                    $departamentos = $this->invtran_model->getInvValorizado_Dept($idsucursal, $tipopro);
                    $dataLineas = $this->invtran_model->getInvValorizado_Lineas($idsucursal);
                    $costo_total = 0;
                    $i=0;
                    $array = array();
                    if($departamentos!=false){
                        foreach($departamentos as $dep_cont){
                            $costo_total += $dep_cont->costo;
                        }
                        foreach($departamentos as $dep){
                            $j=0;
                            $porcentaje_linea = 0;
                            $detailDepto = array();
                            foreach($dataLineas as $data){
                                $porcentaje_linea = ($data->costo/$dep->costo)*100;
                                if($data->idnivel1==$dep->idcatalogo){
                                    $detailDepto[$j] = array(
                                        "idcatalogo" => $data->idcatalogo,
                                        "linea" => $data->linea,
                                        "costo" => $data->costo,
                                        "saldo" => $data->saldo,
                                        "venta" => $data->venta,
                                        "unidades"=>$data->unidades,
                                        "participacion"=>round($porcentaje_linea,2). "%",
                                    );
                                    $j++;
                                }
                            }
                            $porcentaje = ($dep->costo/$costo_total)*100;
                            $array[$i] = array(
                                "idcatalogo" => $dep->idcatalogo,
                                "departamento" => $dep->descrip,
                                "costo" => $dep->costo,
                                "saldo" => $dep->saldo,
                                "venta" => $dep->venta,
                                "unidades"=> $dep->unidades,
                                "participacion"=> round($porcentaje,2). "%",
                                "detailDepto" => $detailDepto
                            );
                            $i++;
                        }
                    }else{
                        $array=false;
                    }
                }
                
                echo json_encode($array);
            }
        }
		
		function insertarProductosScanToTraslado(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');                
				$idcatalogo = $this->input->post('idcatalogo');
				
                $this->load->model('invtran_model');
				$this->load->model('global_model');
				$codes = $this->invtran_model->getInformacionScanGridTraslado($trannum);
				
				$infoCod = explode(";", $codes);
				$total = count($infoCod);
				
				if($codes != ""){
					for($i=0; $i<$total; $i++){
						$infoProd = explode(",", $infoCod[$i]);
						$idproducto = $infoProd[0];
						$cantidad = $infoProd[1];
						$detalle = $this->invtran_model->getInformacionProductoToTraslado($idproducto, $idcentro, $trannum);
						
						foreach($detalle as $info){
							if($info->existe == "0"){
								$idbatch = $info->idbatch;
								$idbin = $info->idbin;
								$idproducto = $info->idproducto;
								$precio = $info->costounitario;
								$um = $info->um;
								$idcentro = $this->session->userdata('idcentrouser');
                                //$idclase = $this->session->userdata('idclass');
                                $idclase = $this->input->post('idclass');
								$inopera = $this->global_model->getInopera_invdef($idclase);
								$invcontrol = $this->global_model->getInvControlSite($idcentro);

								$this->invtran_model->insertTraslado100k($cantidad, $idbatch, $idbin, $idproducto, $um, $idcentro, $invcontrol, $inopera, $trannum, $idclase, $precio);
							}else{
								$idrec = $this->invtran_model->getCodigoRegistroTran_100k($idproducto, $trannum);
								$cantidad_anterior = $this->invtran_model->getCantidadRegistroTran100k($idproducto, $trannum);
								
								$cantidad = $cantidad_anterior + $cantidad;
								$this->invtran_model->updateTraslado100k($idrec, $cantidad);
							}
						}
					}
				}
				
                $this->invtran_model->closeLoteScanTraslado($trannum);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDetalleTraslado($trannum, $idcentro);
                
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "xpos" => $info->xpos,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
				
                echo json_encode($array);
			}
		}
		
		function insertarProductosScanToAjuste(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$numero = $this->input->post('numero');
				$idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('invtran_model');
				$codes = $this->invtran_model->getInformacionScanGrid($trannum, $numero);
				
				$infoCod = explode(";", $codes);
				$total = count($infoCod);
				
				if($codes != ""){
					for($i=0; $i<$total; $i++){
						$infoProd = explode(",", $infoCod[$i]);
						$idproducto = $infoProd[0];
						$cantidad = $infoProd[1];
						$detalle = $this->invtran_model->getInformacionProductoToAjuste($idproducto, $idcentro, $trannum);
						
						foreach($detalle as $info){
							if($info->existe == "0"){
								$sistema = $info->cantidad;
								$idbatch = $info->idbatch;
								$idbin = $info->idbin;
								$idproducto = $info->idproducto;
								$precio = $info->costounitario;
								$um = $info->um;
								$notas = "Producto agregado desde Scan Job";
								
								$this->invtran_model->insertAjuste100k($sistema, $cantidad, $idbatch, $idbin, $idproducto, $um, $trannum, $precio, $notas);
							}else{
								$sistema = $info->cantidad;
								$notas = "Producto actualizado desde Scan Job";
								$infoRegistro = $this->invtran_model->getCodigoRegistro100k($idproducto, $trannum);
								
                                $idrec = $infoRegistro['idrec'];
                                $cantidad_anterior = $infoRegistro['cantrp'];
                                
								$cantidad = $cantidad_anterior + $cantidad;
								$this->invtran_model->updateAjuste100k($idrec, $cantidad, $sistema, $notas);
							}
						}
					}
				}
				
                $array = $this->invtran_model->closeLoteScanAjuste($trannum, $numero);
                				
                echo json_encode($array);
			}
		}
		
		function insertarProductosAjustadosCero(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$idproductos = $this->input->post('idproductos');
				$idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('invtran_model');
				
				$id_productos = explode(",", $idproductos);
				$total = count($id_productos);
				
				if($idproductos != ""){
					for($i=0; $i<$total; $i++){
						$idproducto = $id_productos[$i];
						$cantidad = 0;
						$detalle = $this->invtran_model->getInformacionProductoToAjuste($idproducto, $idcentro, $trannum);
						
						foreach($detalle as $info){
							if($info->existe == "0"){
								$sistema = $info->cantidad;
								$idbatch = $info->idbatch;
								$idbin = $info->idbin;
								$idproducto = $info->idproducto;
								$precio = $info->costounitario;
								$um = $info->um;
								$notas = "999999";
								
								$this->invtran_model->insertAjuste100k($sistema, $cantidad, $idbatch, $idbin, $idproducto, $um, $trannum, $precio, $notas);
							}
						}
					}
					
					$pendientes = $this->invtran_model->getProductosPendientesAjuste($trannum, $idcentro);
					
					$i=0;
					$informacion = array();
					foreach($pendientes as $inf){
						if($inf->existe == "0"){
							if($inf->cantidad != 0){
								$fecmov = $this->invtran_model->getFechaDeUltimoMovimiento($inf->idproducto, $idcentro);
								
								$informacion[$i] = array(
									"idproducto" => $inf->idproducto,
									"nameproducto" => $inf->descrip,
									"marca" => $inf->marca,
									"modelo" => $inf->modelo,
									"cantidad" => $inf->cantidad,
									"fecha" => $fecmov
								);
								$i++;
							}
						}
					}
					
					$array = array(
						"informacion" => $informacion,
						"cantidad" => $i
					);
				}else{
					$array = false;
				}
				
				echo json_encode($array);
			}
		}
		
		function insertarProductosAjustadosIguales(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$idproductos = $this->input->post('idproductos');
				$idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('invtran_model');
				
				$id_productos = explode(",", $idproductos);
				$total = count($id_productos);
				
				if($idproductos != ""){
					for($i=0; $i<$total; $i++){
						$idproducto = $id_productos[$i];
						$detalle = $this->invtran_model->getInformacionProductoToAjuste($idproducto, $idcentro, $trannum);
							
						foreach($detalle as $info){
							if($info->existe == "0"){
								$sistema = $info->cantidad;
								$cantidad = $info->cantidad;
								$idbatch = $info->idbatch;
								$idbin = $info->idbin;
								$idproducto = $info->idproducto;
								$precio = $info->costounitario;
								$um = $info->um;
								$notas = "999999";
								
								$this->invtran_model->insertAjuste100k($sistema, $cantidad, $idbatch, $idbin, $idproducto, $um, $trannum, $precio, $notas);
							}
						}
					}
					
					$pendientes = $this->invtran_model->getProductosPendientesAjuste($trannum, $idcentro);
					
					$i=0;
					$informacion = array();
					foreach($pendientes as $inf){
						if($inf->existe == "0"){
							if($inf->cantidad != 0){
								$fecmov = $this->invtran_model->getFechaDeUltimoMovimiento($inf->idproducto, $idcentro);
								
								$informacion[$i] = array(
									"idproducto" => $inf->idproducto,
									"nameproducto" => $inf->descrip,
									"marca" => $inf->marca,
									"modelo" => $inf->modelo,
									"cantidad" => $inf->cantidad,
									"fecha" => $fecmov
								);
								$i++;
							}
						}
					}
					
					$array = array(
						"informacion" => $informacion,
						"cantidad" => $i
					);
				}else{
					$array = false;
				}
				
				echo json_encode($array);
			}
		}
		
		function eliminarRegistrosOption(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$this->load->model('invtran_model');
				$array = $this->invtran_model->eliminarRegistrosOption($trannum);
				
				echo json_encode($array);
			}
		}
		
		function anularRecuentoFisico(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('idtrannum');
				$idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
				$array = $this->invtran_model->anularRecuentoFisico($trannum, $idcentro);
				
				echo json_encode($array);
			}
		}
		
		function generarRecalculadoRecuento(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum    = $this->input->post('trannum');
				$idcentro   = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $fechaIngresaRF = $this->invtran_model->getFechaIngresaRF($trannum);
				$array = $this->invtran_model->generarRecalculadoRecuento($trannum, $idcentro, $fechaIngresaRF);
				
				echo json_encode($array);
			}
		}
        
        function minmax(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->load->model('sucursal_model');
                $this->data['sucursales']  = $this->sucursal_model->viewSucursales_activas_asc();
                $this->load->view('mantenimiento_repedido', $this->data);
            }    
        }
        
        function get_repedido_list(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
				$sucursal = $this->input->post('sucursal');
				$this->load->model('invtran_model');
				$array = array();
                $i=0;
                $information = $this->invtran_model->get_repedido_list($fechaini,$fechafin,$sucursal);
                $dStart = new DateTime($fechaini);
                $dEnd  = new DateTime($fechafin);
                $dDiff = $dStart->diff($dEnd);
                $diffInDays = (int)$dDiff->format("%r%a");
                $diffInDays=$diffInDays+1;
                $porcentaje=0;
                $ultimo=0;
                $total_clientes = 0;
                if($information!=false){
                    foreach($information as $inf){
                        $total_clientes+=$inf->hits;
                    }
                }
                
                $arrayProvee = [];
                $diferente  ="";
                if($information!=false){
                    foreach($information as $info){
                        if($diferente==""){
                            $diferente.= "  invproducts.idproducto !=".$info->idproducto;
                        }else{
                            $diferente.= " AND invproducts.idproducto !=".$info->idproducto;
                        }

                        $precioprom=0;
                        $stock = 0;
                        
                        if(abs($info->Total)!=0 && round(abs($info->Total)/$diffInDays, 2) != 0){
                            $precioprom = abs($info->precioprom)/abs($info->Total);
                            $stock = $info->inv_actual/round(abs($info->Total)/$diffInDays, 2);
                        }else{
                            $precioprom=0;
                            $stock = $info->inv_actual/$diffInDays;
                        }

                        $porcentaje =  ($info->hits/$total_clientes)*100;
                        $ultimo +=$porcentaje;
                        if($ultimo<80){
                            $categoria= "A";
                        }else if($ultimo>=80 and $ultimo<95){
                            $categoria="B";
                        }else{
                            $categoria="C";
                        }
                        
                        $costo_unitario = $this->invtran_model->getBatchProducto($info->idproducto);
                        //$nameproveedor  = $this->invtran_model->getNameProveedorCompra($info->idproducto);

                        $array[$i] = array(
                            "position" => $i+1,
                            "descrip" => $info->descrip,
                            "nameSucursal" => $info->nameSucursal,
                            "modelo" => $info->modelo,
                            "marca" => $info->marca,
                            "barcode" => $info->barcode,
                            "departamento" => $info->departamento,
                            "linea" => $info->linea,
                            "imagen" => $info->imagen,
                            "idproducto" => (int) $info->idproducto,
                            "idproveedor" => $info->idproveedor,
                            "nameproveedor" => $info->nameproveedor,
                            "comisionproveedor" => $info->comisionproveedor,
                            "Total" => abs($info->Total),
                            "hits" => $info->hits,
                            "precioprom" => $precioprom,
                            "ventatotal" => number_format(abs($info->precioprom), 2, '.', ''),
                            "totaliva" => number_format(abs($info->totalIVA), 2, '.', ''),
                            "totalvn" => number_format(abs($info->totalvn), 2, '.', ''),
                            "inv_actual" => $info->inv_actual,
                            "avg" =>round(abs($info->Total)/$diffInDays, 2),
                            "stock" =>round($stock),
                            "porcentaje" =>$porcentaje,
                            "suma" =>round($ultimo,2),
                            "categoria" =>$categoria,
                            "costo_unitario" => number_format($costo_unitario, 4, '.', ''),
                            "costo_total" => number_format(number_format($costo_unitario, 4, '.', '') * $info->inv_actual, 2, '.', ''),
                            "xpos" => $info->xpos,
                            "proyeccion" => $info->upp,
                            "ingresosPeriodo" => $info->ingresosPeriodo,
                            "descuento" => $info->descuento,
                            "precioreg" => $info->precioreg


                        );
                        if(abs($info->Total) > 0){
                            $nameProvedor = ($info->grupoProveedor == '')? $info->nameproveedor : $info->nameproveedor.' ('.mb_strtoupper($info->grupoProveedor).')';
                            $arrayProvee[] = array("idproveedor" => $info->idproveedor,"nameproveedor" => $nameProvedor,"comisionproveedor" => $info->comisionproveedor);
                        }
                        $i++;
                    }
                }
                $information2 = $this->invtran_model->getInventarioProDiferentes($sucursal,$diferente);
                if($information2!=false){
                    foreach($information2 as $info2){
                        $costo_unitario = $this->invtran_model->getBatchProducto($info2->idproducto);
                        $array[$i] = array(
                            "position" => $i+1,
                            "descrip" => $info2->descrip,
                            "nameSucursal" => $info2->nameSucursal,
                            "modelo" => $info2->modelo,
                            "barcode" => $info2->barcode,
                            "marca" => $info2->marca,
                            "linea" => $info2->linea,
                            "departamento" => $info2->departamento,
                            "ventatotal" => 0,
                            "totaliva" => 0,
                            "totalvn" => 0,
                            "hits" =>0,
                            "Total" => 0,
                            "imagen" => $info2->imagen,
                            "idproducto" => $info2->idproducto,
                            "nameproveedor" => $info2->nameproveedor,
                            "inv_actual" => $info2->cantidad,
                            "stock" => "9999",
                            "costo_unitario" => number_format($costo_unitario, 4, '.', ''),
                            "costo_total" => number_format(number_format($costo_unitario, 4, '.', '') * $info2->cantidad, 2, '.', ''),
                        );
                        $i++; 
                    }
                }
                $arrayProvee = array_map("unserialize", array_unique(array_map("serialize", $arrayProvee)));
                $names = array_column($arrayProvee, 'nameproveedor');
                array_multisort($names, SORT_ASC, $arrayProvee);


                echo json_encode([$array, $arrayProvee]);
			}
        }
       
        function get_repedido_sucursales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
				$sucursal = $this->input->post('sucursal');
				$idproducto = $this->input->post('idproducto');
				$this->load->model('invtran_model');
				$array = array();
                $i=0;
                $sucursales  = $this->invtran_model->get_stock_suc($idproducto);
                
                foreach($sucursales as $suc){
                    
                    $ventas = $this->invtran_model->get_repedido_sucursales($fechaini,$fechafin,$suc->idcentro,$idproducto);
                    
                    $array[$i] = array(
                        "idcentro" => $suc->idcentro,
                        "centerName" => $suc->descrip,
                        "inventario" => $suc->cantidad,
                        "ventas" => abs($ventas),
                    );
                    $i++;
                }
                
                echo json_encode($array);
			}
        }
		
		function inoutmp($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
				$idclase = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
					'idclass' => $idclase
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('global_model');
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				
                $this->load->view('mantenimiento_inoutmp', $this->data);
			}
		}
		
		function getSucursalesInOut(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('sucursal_model');
				$ids = explode(",", $this->session->userdata('idclass'));
				$array = $this->sucursal_model->getSucursalesInOutGroup($ids[0]);
				
				echo json_encode($array);
			}
		}
		
		function getUbicacionesBySucursal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				
				$this->load->model('sucursal_model');
				$array = $this->sucursal_model->getUbicacionesBySucursal($idcentro);
				
				echo json_encode($array);
			}
		}
		
		function getInvdefInOut(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idclases = $this->session->userdata('idclass');
				
				$this->load->model('invtran_model');
				$array = $this->invtran_model->getInvdefInOut($idclases);
				
				echo json_encode($array);
			}
		}
		
		function getInformacionInOut(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idclases = $this->session->userdata('idclass');
				
				$this->load->model('invtran_model');
				$array = $this->invtran_model->getInformacionInOut($idclases);
				
				echo json_encode($array);
			}
		}
		
		function insertInOut(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$fecha = $this->input->post('fecha');
				$referencia = $this->input->post('referencia');
				$idcentro = $this->input->post('idcentro');
				$idbin = $this->input->post('idbin');
				$idclase = $this->input->post('idclase');
				$notas = trim($this->input->post('notas'));
				
				$this->load->model('invtran_model');
				$array = $this->invtran_model->insertRegistroInOut($fecha, $referencia, $idcentro, $idbin, $idclase, $notas);
				echo json_encode($array);
			}
		}
		
		function verdetalleinoutmp($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N° '.$trannum
                );
                $this->session->set_userdata($resultAppName);
				$this->load->model('invtran_model');
				$this->load->model('global_model');
				
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['informacion'] = $this->invtran_model->getRegistroInOut($trannum);
				$this->data['catalogo'] = $this->global_model->getCatalogoPrincipal();
                $this->data['detalle'] = $this->invtran_model->getDataTran100k($trannum);
				$this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
				$this->load->view('mantenimiento_detalle_inoutmp', $this->data);
			}
		}
		
		function getSucursaLocationByTrannum(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$ids = explode(",", $this->session->userdata('idclass'));
				$tipocentro = $ids[0];
				
				$this->load->model('invtran_model');
				$array = $this->invtran_model->getSucursalByTrannum($trannum, $tipocentro);
				echo json_encode($array);
			}
		}
        
        function rep_vendia($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);

                $this->load->model('ventas_model'); $this->load->model('global_model');
                $this->load->model('invtran_model'); $this->load->model('user_model');
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $fechaactual = $date->format('Y-m-d');
                
                $permite = 0;
                $derechos = $this->user_model->getDerechos();
                if($derechos != ""){
                    $pos = strpos($derechos, "costo");
                    if($pos !== false){
                        if($pos >= 0){
                            $permite=1;
                        }   
                    }
                }
				
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
				$this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $this->data['newcliente'] = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
                $this->data['pos_referencia'] = $this->global_model->getValorNumVariable('pos_referencia');
                $this->data['fechaactual'] = $fechaactual;
                $this->data['permite_derechos'] = $permite;
				
				$idcentro = $this->session->userdata('idcentrouser');
				$this->load->view('mantenimiento_rep_ventasdiarias', $this->data);
            }
        }

        function rep_vendiaCesc($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('invtran_model');
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$fechaactual = $date->format('Y-m-d');
				
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
				$this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $this->data['newcliente'] = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
                $this->data['fechaactual'] = $fechaactual;
				
				$idcentro = $this->session->userdata('idcentrouser');
				$this->load->view('mantenimiento_rep_ventasdiarias_Cesc', $this->data);
            }
        }
        
        function getDatosFacturasVentasDiarias(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $idcaja   = $this->input->post('idcaja');
                
                $datosTemp = array(
                    'idcentroTemp' => $idcentro,
                    'idcajaTemp' => $idcaja,
                    'fechaini' => $fechaini,
                    'fechafin' => $fechafin
                );
                $this->session->set_userdata($datosTemp);
                
                $this->load->model('variable_model');
                $this->load->model('ventas_model'); $this->load->model('invtran_model');
				$porcentaje_iva = $this->variable_model->getValorIVA();
                $datos = $this->invtran_model->getDatosFacturaciones('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    if($info->estatus!=0){
						$j = 0;
                        $valtax1 = 0;
                        $totalDescuento = 0;
                        $totalComision = 0;
                        $detailFacturas = array();
						$detalle = $this->invtran_model->getDetalleFacturas($info->trannum);
                        
						foreach($detalle as $data){
							$valtax1 = 0;
                            if( $info->exento == 0 ){
                                $valtax1 = $data->precioneto * ($data->tax1 / 100);
                            }else{
                                $valtax1 = 0;
                            }
                            
                            if($data->descuento != 0){
                                $totalDescuento = $totalDescuento + ((($data->preciotran / (1 + ($data->tax1/100))) -  $data->precioneto) * abs($data->cantidad));
                            }
                            
                            if($data->comision != 0){
                                $totalComision = $totalComision + (($data->preciotran * ($data->comision/100)) * abs($data->cantidad));
                            }
                            
                            $total = abs($data->cantidad) * ($data->precioneto + $valtax1);
                            
							$detailFacturas[$j] = array(
                                "itemline" => $data->itemline,
                                "idproducto" => $data->idproducto,
                                "descrip" => $data->descrip,
                                "notas" => $data->notas,
                                "um" => $data->um,
                                "modelo" => $data->modelo,
                                "barcode" => $data->barcode,
                                "ubicacion" => $data->ubicacion,
                                "lote" => $data->lote,
                                "cantidad" => abs($data->cantidad),
                                "precio" => $this->session->userdata("simboloMoneda").number_format($data->precioneto, 6, '.', ','),
                                "tax1" => $this->session->userdata("simboloMoneda").number_format($valtax1, 6, '.', ','),
                                "total" => $this->session->userdata("simboloMoneda").number_format($total, 2, '.', ',')
                            );
                            $j++;
                        }
						
                        $exento_doc = 0; $gravado_doc = 0; $iva_doc = $info->valtax1;
                        if($info->exento==1){
                            $exento_doc = $info->valventan;
                        }else{
                            if ( $porcentaje_iva != 0 ) {
                                $gravado_doc = ($info->valtax1 / ($porcentaje_iva/100));
                            } else  $gravado_doc = $info->valventan;

                            $exento_doc = number_format($info->valventan-$gravado_doc, 2, '.', '');
                        }

                        $totalVenta = $info->valventan + $iva_doc;

                        if(($info->idtipo == 3) && ($gravado_doc>=100)){
                            $reten = $gravado_doc * 0.01;
                            $retencion = '-'.$reten;
                            $totalVenta = $totalVenta-$reten;
                        }else{
                            $retencion = 0;
                        }
                        
                        $descripPagos = "";
                        $informaPagos = $this->ventas_model->getDatosPagosVentasTrannum($info->trannum);
                        
                        if($informaPagos != false){
                            foreach($informaPagos as $infoPago){
                                $descripPagos .= $infoPago->descrip.", ";
                            }
                            $descripPagos = str_replace("Retención 1%", "", $descripPagos);
                            $descripPagos = substr($descripPagos, 0, -2);   
                        }

                        if($descripPagos == ""){
                            $informaPagos = $this->ventas_model->getTipoPagoRealiVenta($info->trannum);
                            if($informaPagos != false){
                                foreach($informaPagos as $infoPago){
                                    $descripPagos .= $infoPago->descrip;
                                }
                            }
                        }

                        if($info->registro != ""){
                            $registro = $info->registro;
                        }else{
                            $registro = "SIN REGISTRO";
                        }

                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "fecha" => $info->fecha,
                            "tipodoc" => $info->tipodoc,
                            "seriedoc" => $info->serie,
                            "numeroserie" => $info->numero * 1,
                            "doc_dev" => $info->dev_serie.$info->dev_numero,
                            "nit" => $info->nit,
                            "numx" => $info->numx,
                            "numz" => $info->numz,
                            "registro" => $registro,
                            "namecliente" => $info->namecliente,
                            "namesucursal" => $info->namesucursal,
                            "namecaja" => $info->namecaja,
                            "namevendedor" => $info->namevendedor,
                            "valventan" => number_format($totalVenta, 6, '.', ''),
                            "exento" => number_format($exento_doc, 6, '.', ''),
                            "gravado" => number_format($gravado_doc, 6, '.', ''),
                            "iva" => number_format($iva_doc, 6, '.', ''),
                            "retencion" => number_format($retencion, 6, '.', ''),
                            "descuento" => number_format($totalDescuento, 6, '.', ''),
                            "comision" => number_format($totalComision, 6, '.', ''),
                            "detailFacturas" => $detailFacturas,
                            "estatus" => $info->estatus,
                            "formaPago" => $descripPagos,
                            "notas_fact" => $info->notas,
                            "referencia" => $info->referencia,
                            "valcosto" => number_format($info->valcosto * -1, 6, '.', '')
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }

        function getDatosFacturasVentasDiariasCesc(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                
                $datosTemp = array(
                    'idcentroTemp' => $idcentro,
                    'idcajaTemp' => $idcaja,
                    'fechaini' => $fechaini,
                    'fechafin' => $fechafin
                );
                $this->session->set_userdata($datosTemp);
                
                $this->load->model('variable_model');
                $this->load->model('ventas_model'); $this->load->model('invtran_model');
				$porcentaje_iva = $this->variable_model->getValorIVA();
                $datos = $this->invtran_model->getDatosFacturacionesCESC('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    if($info->estatus!=0){
						$j = 0; $valtax1 = 0;
                        $totalDescuento = 0; $totalComision = 0; $totalcesc = 0;
                        $detailFacturas = array();
						$detalle = $this->invtran_model->getDetalleFacturas($info->trannum);
                        
						foreach($detalle as $data){
							$valtax1 = 0;
                            if($info->exento==0){
                                $valtax1 = $data->precioneto * ($data->tax1 / 100);
                            }else{
                                $valtax1 = 0;
                            }
                            
                            if($data->descuento != 0){
                                $totalDescuento = $totalDescuento + ((($data->preciotran / (1 + ($data->tax1/100))) -  $data->precioneto) * abs($data->cantidad));
                            }
                            
                            if($data->comision != 0){
                                $totalComision = $totalComision + (($data->precioneto * ($data->comision/100)) * abs($data->cantidad));
                            }
                            
                            $total = abs($data->cantidad) * ($data->precioneto + $valtax1);

                            //CESC---------------------------    
                            if($data->tax1 == 18){
                                $totalcesc = $totalcesc + (number_format(round($data->precioneto * abs($data->cantidad), 2), 2 ,'.','') * 0.05);
                            }
                            //------------------------------- 
                            
							$detailFacturas[$j] = array(
                                "itemline" => $data->itemline,
                                "idproducto" => $data->idproducto,
                                "descrip" => $data->descrip,
                                "notas" => $data->notas,
                                "um" => $data->um,
                                "ubicacion" => $data->ubicacion,
                                "lote" => $data->lote,
                                "cantidad" => abs($data->cantidad),
                                "precio" => $this->session->userdata("simboloMoneda").number_format($data->precioneto, 6, '.', ','),
                                "tax1" => $this->session->userdata("simboloMoneda").number_format($valtax1, 6, '.', ','),
                                "total" => $this->session->userdata("simboloMoneda").number_format($total, 2, '.', ',')
                            );
                            $j++;
                        }
						
						if($info->exento == 0){
							$totalTax1 = $info->valtax1;
						}else{
							$totalTax1 = 0;
						}
                    
                        $exento_doc = 0;
                        $gravado_doc = 0;

                        if($info->exento==1){
                            $exento_doc = $info->valventan;
                        }else{
                            if($porcentaje_iva != 0){
                                $gravado_doc = ($info->valtax1 / ($porcentaje_iva/100));
                            }
                            $gravado_doc = $info->valventan;
                            $exento_doc = round($info->valventan-$gravado_doc);
                        }
                        $iva_doc = ($info->valtax1 - $totalcesc);
                        $totalVenta = $info->valventan + $iva_doc + $totalcesc;
                        
                        $descripPagos = "";
                        $informaPagos = $this->ventas_model->getDatosPagosVentasTrannum($info->trannum);
                        
                        if($informaPagos != false){
                            foreach($informaPagos as $infoPago){
                                $descripPagos .= $infoPago->descrip.", ";
                            }
                            $descripPagos = str_replace("Retención 1%", "", $descripPagos);
                            $descripPagos = substr($descripPagos, 0, -2);   
                        }

                        if($descripPagos == ""){
                            $informaPagos = $this->ventas_model->getTipoPagoRealiVenta($info->trannum);
                            if($informaPagos != false){
                                foreach($informaPagos as $infoPago){
                                    $descripPagos .= $infoPago->descrip;
                                }
                            }
                        }

                        if($info->registro != ""){
                            $registro = $info->registro;
                        }else{
                            $registro = "SIN REGISTRO";
                        }
                        
                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "fecha" => $info->fecha,
                            "tipodoc" => $info->tipodoc,
                            "numeroserie" => $info->numero,
                            "registro" => $registro,
                            "namecliente" => $info->namecliente,
                            "namevendedor" => $info->namevendedor,
                            "valventan" => number_format(round($totalVenta,2), 2, '.', ''),
                            "exento" => number_format(round($exento_doc,2), 2, '.', ''),
                            "gravado" => number_format(round($gravado_doc,2), 2, '.', ''),
                            "iva" => number_format(round($iva_doc,2), 2, '.', ''),
                            "descuento" => number_format(round($totalDescuento,2), 2, '.', ''),
                            "comision" => number_format(round($totalComision,2), 2, '.', ''),
                            "detailFacturas" => $detailFacturas,
                            "estatus" => $info->estatus,
                            "formaPago" => $descripPagos,
                            "notas_fact" => $info->notas,
                            "totalcesc" => number_format(round($totalcesc,2), 2, '.', '')
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function salidas($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opciones' => $opcionmenu,
                );
                $this->session->set_userdata($resultAppName);

                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');
                $this->load->model('compras_model');
                $this->data['opciones'] = $opcionmenu;
                $this->data['salidas'] = $this->invtran_model->getTiposinout($opcionmenu);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;

                $this->load->view('mantenimiento_salidas', $this->data); 
            }
        }

        function getListadoOtrasSalidas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclases = $this->input->post('idclases');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $estado   = $this->input->post('estado');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getListadoOtrasSalidas($idclases, $idcentro, $fechaini, $fechafin, $estado);

                $i=0;
                $array = array();

                if($informacion != false){
                    foreach($informacion as $in){
                        $array[$i] = array(
                            "trannum" => $in->trannum,
                            "idcentro" => $in->idcentro,
                            "fecha" => $in->fecha,
                            "fecha1" => $in->fecha1,
                            "lines100k" => $in->lines100k,
                            "notas" => $in->notas,
                            "estatus" => $in->estatus,
                            "tipo" => $in->tipo
                        );
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }
        
        function registrarSalida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $clases = $this->session->userdata('opciones');
                $idcentro = $this->session->userdata('idcentrouser');
                $fecha = $this->input->post('fecha');
                $idcps = $this->input->post('idcps');
                $idclase = $this->input->post('idclase');
                $notas = $this->input->post('notas');
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $reemplazar = array("", "", "", "");
                $notas = str_replace($buscar, $reemplazar, $notas);
                
                $this->load->model('invtran_model');
                $trannum = $this->invtran_model->insertSalida($idcentro, $fecha, $idclase, $notas,$idcps);
                
                echo json_encode($trannum);
            }
        }
        
        function verDetalleSalida($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $informacion = $this->invtran_model->getDetalleSalida($idtrannum);
                $this->data['informacion'] = $informacion; 
                $this->data['catalogo'] = $this->global_model->getCatalogoPrincipal();
                $this->data['detalle'] = $this->invtran_model->getDataTran100k($idtrannum);
                $this->data['detalle_export'] = $this->invtran_model->getDataTran100k_envios($idtrannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($idtrannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($idtrannum);
                
                foreach($informacion as $inf){
                    $idclase= $inf->idclase;
                }
                $resultAppName = array(
                    'idclass' => $idclase,
                );
                $this->session->set_userdata($resultAppName);
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                if($tipoBusca==null || $tipoBusca==false){
                    $tipoBusca=1;
                }
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('form_detalle_salida', $this->data);
            }
        }
        
        // Versión obsoleta
        function informacionSalidaProductos_Delete($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $direccion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $informacion = $this->invtran_model->getDetalleSalida($idtrannum);
                $this->data['informacion'] = $informacion; 
                $this->data['catalogo'] = $this->global_model->getCatalogoPrincipal();
                $this->data['detalle'] = $this->invtran_model->getDataTran100k($idtrannum);
                $this->data['detalle_export'] = $this->invtran_model->getDataTran100k_envios($idtrannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($idtrannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($idtrannum);
                
                foreach($informacion as $inf){
                    $idclase= $inf->idclase;
                }
                $resultAppName = array(
                    'idclass' => $idclase,
                );
                $this->session->set_userdata($resultAppName);
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                if($tipoBusca==null || $tipoBusca==false){
                    $tipoBusca=1;
                }
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detalle_salida', $this->data);
            }
        }
        
        //Modificado 20200219 I.C.
        function informacionSalidaProductos($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $idcentro = $this->session->userdata('idcentrouser');
                $direccion = $this->uri->segment(1);
                $po_lotescp = $this->global_model->getValorNumVariable('po_lotescp');
                $informacion = $this->invtran_model->getDetalleSalida($idtrannum);

				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $informacion;
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($idtrannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($idtrannum);
                $this->data['po_lotescp'] = $po_lotescp;
                
                foreach($informacion as $inf){
                    $idclase= $inf->idclase;
                }
                
                $resultAppName = array(
                    'idclass' => $idclase,
                );
                $this->data['id_class'] = $idclase;
                $this->session->set_userdata($resultAppName);
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                if($tipoBusca==null || $tipoBusca==false){
                    $tipoBusca=1;
                }
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detalle_salida_grid', $this->data);
            }
        }
		
        function getInfoSalida(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('invtran_model');
				$idtrannum = $this->input->post("idtrannum");
				$informacion = $this->invtran_model->getDetalleSalida2($idtrannum);
				$array = array(
					"centrocd" => $informacion['centrocd'],
					"encargadod" => $informacion['encargadod'],
					"tipoSalida" => $informacion['tipoSalida'],
				);
				echo json_encode($array);
			 }
		}
		
        function comp_inv($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opciones' => $opcionmenu,
                );
                $direccion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->session->set_userdata($resultAppName);
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('invtran_model');
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->load->view('mantenimiento_comprobacion_inv', $this->data); 
            }
        }
        
        function comp_inv_g($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opciones' => $opcionmenu,
                );
                $direccion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->session->set_userdata($resultAppName);
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('invtran_model');
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->load->view('mantenimiento_comprobacion_inv_g', $this->data); 
            }
        }

		function getComprobacionInv_(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $desde    = $this->input->post('desde');
                $hasta    = $this->input->post('hasta');
                $tipoPro  = $this->input->post('tipoPro');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getComInvDate($tipoPro, $idcentro, $desde, $hasta);
                
                $i=0;
                $array = array();
                foreach ( $informacion as $in ) {
                    $inv_disponible = 0; $inv_actual = 0; $costo_total = 0; $cadena_costo_total = 0;
                    
                    $inv_disponible = $in->saldoinicial + $in->compras + $in->ajustes;
                    $inv_actual     = $in->saldoinicial + $in->compras + $in->ajustes + $in->ventas;
                    //$costoinicial   = ( $in->saldoinicial == 0 ) ? 0 : $in->ini_costoco + $in->ini_costoajvn;
                    $costoinicial   = $in->ini_costoco + $in->ini_costoajvn;
                    $costo_total    = $costoinicial + $in->costocompras + $in->costoajustes + $in->costoventas;
                    $cadena_costo_unitario = $in->costo_ficha;
                    
                    //$cadena_costo_total    = $costo_total;
                    if ( $inv_actual != 0 ) {
                        $cadena_costo_total    = $costo_total;
                        $cadena_costo_unitario = $costo_total / $inv_actual;
                    }
                    
                    if ( $inv_disponible  != 0 || $inv_actual != 0 || $in->compras != 0 || $in->ajustes  != 0 || $in->venta != 0 ) {
                        $array[$i] = array(
                            'idproducto'        => $in->idproducto,
                            'cantidad'          => $in->cantidad,
                            'producto'          => $in->producto,
                            'marca'             => $in->marca,
                            'um'                => $in->um,
                            'modelo'            => $in->modelo,
                            'linea'             => $in->linea,
                            'departamento'      => $in->departamento,
                            'saldoinicial'      => $in->saldoinicial,
                            'compras'           => $in->compras,
                            'ajustes'           => $in->ajustes,
                            'inv_disponible'    => $inv_disponible,
                            'ventas'            => ABS($in->ventas),
                            'costosaldoinicial' => ( $in->saldoinicial == 0 ) ? 0 : $in->ini_costoco + $in->ini_costoajvn,
                            'inv_final'         => $inv_actual,
                            'costototal'        => $cadena_costo_total,
                            'costounitario'     => $cadena_costo_unitario,
                            'costocompras'      => $in->costocompras,
                            'costoajustes'      => $in->costoajustes,
                            'costoventas'       => $in->costoventas
                        );

                        $i++;
                    }
                }

                echo json_encode($array);
			}
		}

        function getComprobacionInv(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipo      = $this->input->post('tipoPro');
                $idcentro  = $this->input->post('idcentro');
                $fechaini  = $this->input->post('fechaini');
                $fechafin  = $this->input->post('fechafin');
                $offset    = $this->input->post('offset');
                $limit     = $this->input->post('limit');
                $resultado = [];

                $this->load->model('invtran_model');
                $totalReg = $this->invtran_model->getTotalRegistrosInformeInventario($tipo);
                $informacion = $this->invtran_model->getDatosReporteInformeInventario($offset, $limit, $tipo);

                foreach($informacion as $info) {
                    $saldoInicial = $this->invtran_model->getSaldoInicialInformeIN($info->idproducto, $idcentro, $fechaini);
                    $invCompras   = $this->invtran_model->getEntradasCOInformeIN($info->idproducto, $idcentro, $fechaini, $fechafin);
                    $invAjustes = $this->invtran_model->getEntraSalINInformeIN($info->idproducto, $idcentro, $fechaini, $fechafin);

                    $invDisponible = $saldoInicial + $invCompras + $invAjustes;

                    $resultado[] = array(
                        'idproducto'        => $info->idproducto,
                        'producto'          => $info->descrip,
                        'marca'             => $info->marca,
                        'um'                => $info->um,
                        'modelo'            => $info->modelo,
                        'linea'             => $info->linea,
                        'departamento'      => $info->departamento,
                        'saldoinicial'      => $saldoInicial,
                        'compras'           => $invCompras,
                        'ajustes'           => $invAjustes,
                        'inv_disponible'    => $invDisponible,
                        'ventas'            => $this->invtran_model->getSalidasVNInformeIN($info->idproducto, $idcentro, $fechaini, $fechafin),
                        'costosaldoinicial' => $this->invtran_model->getCostoUnitarioIniInformeIN($info->idproducto, $idcentro, $fechaini),
                        'inv_final'          => $this->invtran_model->getSaldoFinalInformeIN($info->idproducto, $idcentro, $fechafin),
                        'costototal'        => $this->invtran_model->getValorTotalInformeIN($info->idproducto, $idcentro, $fechafin),
                        'costounitario'     => $this->invtran_model->getCostoUnitarioInformeIN($info->idproducto, $idcentro, $fechafin),
                        'costocompras'      => $this->invtran_model->getCostoUnitarioCOInformeIN($info->idproducto, $idcentro, $fechaini, $fechafin),
                        'costoajustes'      => $this->invtran_model->getCostoUnitarioINInformeIN($info->idproducto, $idcentro, $fechaini, $fechafin),
                        'costoventas'       => $this->invtran_model->getCostoUnitarioVNInformeIN($info->idproducto, $idcentro, $fechaini, $fechafin),
                    );
                }
                
                echo json_encode(array(
                    'total' => $totalReg,
                    'data' => $resultado
                ));
            }
        }

        function getComprobacionInvGeneral(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipo      = $this->input->post('tipoPro');
                $fechaini  = $this->input->post('fechaini');
                $fechafin  = $this->input->post('fechafin');
                $offset    = $this->input->post('offset');
                $limit     = $this->input->post('limit');
                $resultado = [];

                $this->load->model('invtran_model');
                $totalReg = $this->invtran_model->getTotalRegistrosInformeInventario($tipo);
                $informacion = $this->invtran_model->getDatosReporteInformeInventario($offset, $limit, $tipo);

                foreach($informacion as $info) {
                    $saldoInicial = $this->invtran_model->getSaldoInicialInformeIN($info->idproducto, 0, $fechaini);
                    $invCompras   = $this->invtran_model->getEntradasCOInformeIN($info->idproducto, 0, $fechaini, $fechafin);
                    $invAjustes = $this->invtran_model->getEntraSalINInformeIN($info->idproducto, 0, $fechaini, $fechafin);

                    $invDisponible = $saldoInicial + $invCompras + $invAjustes;

                    $resultado[] = array(
                        'idproducto'        => $info->idproducto,
                        'producto'          => $info->descrip,
                        'proveedor'         => $info->proveedor,
                        'marca'             => $info->marca,
                        'um'                => $info->um,
                        'modelo'            => $info->modelo,
                        'linea'             => $info->linea,
                        'departamento'      => $info->departamento,
                        'saldoinicial'      => $saldoInicial,
                        'compras'           => $invCompras,
                        'ajustes'           => $invAjustes,
                        'inv_disponible'    => $invDisponible,
                        'ventas'            => $this->invtran_model->getSalidasVNInformeIN($info->idproducto, 0, $fechaini, $fechafin),
                        'costosaldoinicial' => $this->invtran_model->getCostoUnitarioIniInformeIN($info->idproducto, 0, $fechaini),
                        'inv_final'         => $this->invtran_model->getSaldoFinalInformeIN($info->idproducto, 0, $fechafin),
                        'costototal'        => $this->invtran_model->getValorTotalInformeIN($info->idproducto, 0, $fechafin),
                        'costounitario'     => $this->invtran_model->getCostoUnitarioInformeIN($info->idproducto, 0, $fechafin),
                        'costocompras'      => $this->invtran_model->getCostoUnitarioCOInformeIN($info->idproducto, 0, $fechaini, $fechafin),
                        'costoajustes'      => $this->invtran_model->getCostoUnitarioINInformeIN($info->idproducto, 0, $fechaini, $fechafin),
                        'costoventas'       => $this->invtran_model->getCostoUnitarioVNInformeIN($info->idproducto, 0, $fechaini, $fechafin),
                    );
                }
                
                echo json_encode(array(
                    'total' => $totalReg,
                    'data' => $resultado
                ));
            }
        }
 		
		function kardex_142($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->session->userdata('idcentrouser');
                
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('sucursal_model'); $this->load->model('producto_model');
				$this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
				$this->data['productos'] = $this->producto_model->getProductosByEstatusCatalogo();
                
                $this->load->view('mantenimiento_kardex', $this->data); 
            }
		}
		
		function getInformacionKardexByProducto(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idproducto = $this->input->post('idproducto');
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
				$idcentro = $this->input->post('idcentro');
				
				$partesFechas = explode("-", $fechaini);
				$idano = $partesFechas[0];
				$idmes = $partesFechas[1];
				
				$this->load->model('invtran_model');
				$inventarioInicial = $this->invtran_model->getInventarioInicialProductoKardex($idproducto, $idcentro, $idano, $idmes);
				$informacion = $this->invtran_model->getDetalleKardexByProducto($idproducto, $fechaini, $fechafin, $idcentro);
				
				$i=0;
				$dataSource = array();
				
				foreach($inventarioInicial as $info){
					$costounitario = 0;
					$cantidadinicial = number_format($info->cantidad);
					$costoinicial = number_format($info->costo, 2);
					
					if($cantidadinicial != 0){
						$costounitario = number_format($info->costo, 2, '.', '')/number_format($info->cantidad);
					}
					
					$dataSource[$i] = array(
						"fecha" => '',
						"numero" => '',
						"documento" => 'INICIAL',
						"transaccion" => '',
						"proveedorcliente" => '',
						"cantidad_entrada" => '',
						"costo_entrada" => '',
						"total_entrada" => '',
						"cantidad_salida" => '',
						"costo_salida" => '',
						"total_salida" => '',
						"cantidad_existencia" => $cantidadinicial,
						"costo_existencia" => $costounitario,
						"total_existencia" => $costoinicial,
					);
					
					$i++;
				}
				
				$cantidad_existencia = number_format($info->cantidad);
				$costo_existencia = number_format($costounitario, 2);
				$total_existencia = number_format($info->costo, 2);
				
				foreach($informacion as $info){
					$costounitario = 0;
					
					if($info->agrupa == 'VN'){
						$valAgrupa = 'VENTA';
					}else if($info->agrupa == 'IN'){
						$valAgrupa = 'INVENTARIO';
					}else if($info->agrupa == 'CO'){
						$valAgrupa = 'COMPRA';
					}
					
					$cantidad_entrada = '';
					$costo_entrada = '';
					$total_entrada = '';
					$cantidad_salida = '';
					$costo_salida = '';
					$total_salida = '';
					
					
					if($info->inopera == 1){
						$totalEntrada = number_format(abs($info->cantidad)) * number_format($info->costounitario, 2);
						
						$cantidad_entrada = number_format(abs($info->cantidad));
						$costo_entrada = number_format($info->costounitario, 2) * 1;
						$costo_entrada = $costo_entrada;
						$total_entrada = $totalEntrada;
						
						$cantidad_existencia = $cantidad_existencia + $cantidad_entrada;
						$total_existencia = $total_existencia + $total_entrada;
						$costo_existencia = $total_existencia / $cantidad_existencia;
					}else if($info->inopera == -1){
						$totalSalida = number_format(abs($info->cantidad)) * number_format($info->costounitario, 2);
						
						$cantidad_salida = number_format(abs($info->cantidad));
						$costo_salida = number_format($info->costounitario, 2) * 1;
						$costo_salida = $costo_salida;
						$total_salida = $totalSalida;
						
						$cantidad_existencia = $cantidad_existencia - $cantidad_salida;
						$costo_existencia = $costo_existencia;
						$total_existencia = $total_existencia - $total_salida;
					}
					
					$dataSource[$i] = array(
						"fecha" => $info->fecha,
						"numero" => $info->numerodoc,
						"documento" => $info->descrip,
						"transaccion" => $valAgrupa,
						"proveedorcliente" => $info->proveedorcliente,
						"cantidad_entrada" => $cantidad_entrada,
						"costo_entrada" => $costo_entrada,
						"total_entrada" => $total_entrada,
						"cantidad_salida" => $cantidad_salida,
						"costo_salida" => $costo_salida,
						"total_salida" => $total_salida,
						"cantidad_existencia" => $cantidad_existencia,
						"costo_existencia" => $costo_existencia,
						"total_existencia" => $total_existencia,
					);
					
					$i++;
				}
				
				echo json_encode($dataSource);
			}
		}
        
        function getInventarioByCatalogo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->input->post('idcentro');
                $this->load->model('invtran_model');
                if($idcentro==999999){
                    $datos = $this->invtran_model->getInventarioProductosTodos($idcatalogo);
                    $array = array();
                    $i=0;

                    if($datos!=false){
                        foreach($datos as $dat){
                            $ext_local = $dat->ExistenciasLocales;
                            if($ext_local!=0){
                                $array[$i] = array(
                                    "idproducto" => $dat->idproducto,
                                    "ExistenciasLocales" => round($ext_local),
                                    "descrip" => $dat->descrip,
                                    "marca" => $dat->marca,
                                    "barcode" => $dat->barcode,
                                    "um" => $dat->um,
                                    "precioventa" => $dat->precioventa,
                                    "costounitario" => $dat->costounitario,
                                    "subtotal" => $dat->costounitario*round($ext_local),
                                    "modelo" => $dat->modelo,
                                );
                                $i++;
                            }
                        }
                    }
                }else{
                    $datos = $this->invtran_model->getInventarioProductos($idcatalogo, $idcentro);
                    $array = array();
                    $i=0;

                    if($datos!=false){
                        foreach($datos as $dat){
                            if($dat->ExistenciasLocales>0 && $dat->ExistenciasLocales!=null){
                                $array[$i] = array(
                                    "idproducto" => $dat->idproducto,
                                    "ExistenciasLocales" => round($dat->ExistenciasLocales),
                                    "descrip" => $dat->descrip,
                                    "marca" => $dat->marca,
                                    "barcode" => $dat->barcode,
                                    "um" => $dat->um,
                                    "precioventa" => $dat->precioventa,
                                    "costounitario" => $dat->costounitario,
                                    "subtotal" => $dat->costounitario*round($dat->ExistenciasLocales),
                                    "modelo" => $dat->modelo,
                                );
                                $i++;
                            }
                        }
                    }
                }
                
				
                echo json_encode($array);
            }
        }
        
        function folderDePrecios($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                
                $appInformacion = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($appInformacion);
                
                $this->load->model('global_model');
                $this->load->model('invtran_model');
                
                $direccion = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['tcenters'] = $this->invtran_model->getAllCentrosActivos();
                
                $this->load->view('mantenimiento_folder_de_precios', $this->data);
            }
        }
        
        function getListadoFolderDePrecios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $agrupa = 'VP';
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getListadoFolderDePrecios($agrupa);
				
                $i=0;
                $array = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        
                        if($info->fecact == '0000-00-00'){
                            $fecha_actualizacion = "";
                        }else{
                            $fecha_actualizacion = $info->fecact;
                        }
                        
                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "descrip" => $info->descrip,
                            "fecha" => $info->fecha,
                            "fecact" => $fecha_actualizacion,
                            "notas" => $info->notas,
                            "lineaunidad" => "0/0",
                            "estatus" => $info->estatus
                        );
                        
                        $i++;
                    }
                }
                echo json_encode($array);
            }
        }
        
        function insertarFolderDePrecios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $descrip = $this->input->post('descripcion');
                $tipo = $this->input->post('tipo');
                $notas = $this->input->post('notas');
                $idcentro = $this->session->userdata('idcentrouser');
                $agrupa = 'VP';
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->insertNuevoFolderPrecios($fecha, $descrip, $tipo, $notas, $idcentro, $agrupa);
                
                echo json_encode($array);
            }
        }
        
        function detalleFolderDePrecios($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                
				$direccion = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getInformacionOrdenFolder($trannum);
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detalle_folder_de_precios', $this->data);
            }
        }
        
        function getListadoLineasFolders(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
				
				$this->load->model('invtran_model'); 
				$infoCatalogo = $this->invtran_model->getGroupsProductosFolders();
				$infoCantidad = $this->invtran_model->getSumProductosFolders($trannum);
				
				$i=0;
				$array = array();
				
				foreach($infoCatalogo as $info){
					foreach($infoCantidad as $infoCant){
						if($info->idcatalogo == $infoCant->idcatalogo){
							$array[$i] = array(
								"idcatalogo" => $info->idcatalogo,
								"imagen" => trim($info->imagen),
								"descrip" => trim($info->descrip),
								"total" => $infoCant->total
							);
						}
					}
					$i++;
				}
				
                echo json_encode($array);
            }
		}
        
        function getInventarioByCatalogFolders(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $this->load->model('invtran_model');
                $detalle = $this->invtran_model->getInventarioByCatalogFolders($idtrannum, $idcatalogo);
                $cantidades = $this->invtran_model->getCantidadesCatalogoFolders($idtrannum);
				
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    if($info->existe == 0){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "tipotax" => $info->tipotax,
                            "precioventa" => $info->precioventa,
                            "descuento" => $info->descuento,
                            "costounitario" => $info->costounitario
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i,
                    "sumagrupos" => $cantidades
                );
                echo json_encode($array);
            }
        }
        
        function getListadoPorcentajes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getListadoPorcentajes('pos_pdescuento');
                
                $listDescuentos = explode(',', $informacion);
                $totalDescuentos = count($listDescuentos);
                
                $array = array();
                for($i=0; $i<$totalDescuentos; $i++){
					$array[$i] = array(
						"id" => $listDescuentos[$i],
						"descrip" => $listDescuentos[$i]
					);
                }
                
                echo json_encode($array);
            }
        }
        
        function insertarProductoToFolderPrecios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idproducto = $this->input->post('idproducto');
                $precio = $this->input->post('precio');
                $descuento = $this->input->post('descuento');
                $um = $this->input->post('um');
                $notas = $this->input->post('notas');
                
                $this->load->model('invtran_model');
                $this->invtran_model->insertarProductoToFolderPrecios($trannum, $idproducto, $precio, $descuento, $um, $notas);
                $infoGeneral = $this->invtran_model->getDatosFolderDePrecios($trannum);
                
                $array = array(
                    "datos" => $infoGeneral
                );
                echo json_encode($array);
            }
        }
        
        function updateProductoToFolderPrecios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idrec = $this->input->post('idrec');
                $precio = $this->input->post('precio');
                $descuento = $this->input->post('descuento');
                $notas = $this->input->post('notas');
                
                $this->load->model('invtran_model');
                $this->invtran_model->updateProductoToFolderPrecios($idrec, $precio, $descuento, $notas);
                $infoGeneral = $this->invtran_model->getDatosFolderDePrecios($trannum);
                
                $array = array(
                    "datos" => $infoGeneral
                );
                echo json_encode($array);
            }
        }
        
        function getDatosFolderDePrecios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getDatosFolderDePrecios($trannum);
                
                echo json_encode($array);
            }
        }
        
        function eliminarRegistroFolderDePrecios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $idrec = $this->input->post('idrec');
                
                $this->load->model('invtran_model');
                $this->invtran_model->eliminarProductoToFolderPrecios($idrec);
                $infoGeneral = $this->invtran_model->getDatosFolderDePrecios($trannum);
                
                $array = array(
                    "datos" => $infoGeneral
                );
                
                echo json_encode($array);
            }
        }
        
        function getSearchProductoFolderPrecios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $proSearch = $this->input->post('prosearch');
                $datoSearch = $this->input->post('dato');
                $trannum = $this->input->post('idtrannum');
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getSearchProductoFolderPrecios($proSearch, $datoSearch, $trannum);
                
                $i=0;
                $agregado=0;
                $items = array();
                
                if($informacion != 0){
                    foreach($informacion as $info){
						if($info->existe == "0"){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "tipotax" => $info->tipotax,
                                "namecatalogo" => $info->namecatalogo,
                                "precioventa" => $info->precioventa,
                                "costounitario" => $info->costounitario,
                                "descuento" => $info->descuento,
								"agregado" => 0
                            );
                            $i++;
                        }else{
							$items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "tipotax" => $info->tipotax,
                                "namecatalogo" => $info->namecatalogo,
                                "precioventa" => $info->precioventa,
                                "costounitario" => $info->costounitario,
                                "descuento" => $info->descuento,
                                "agregado" => 1
                            );
                            $i++;
                            $agregado = 1;
                        }
                    }
                    
                    if($agregado == 1 && $i == 1){
						$datos = $this->invtran_model->getInformacionProductoOrders100k($trannum, $info->idproducto);
						$array = array(
                            "error" => "2",
							"datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
        }
        
        function getInformacionProductoAgregadoFolder(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->getInformacionProductoOrders100k($trannum, $idproducto);
                echo json_encode($array);
            }
        }
        
        function insertarProductosToFolderGrid(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idproductos = $this->input->post('idproductos');
                
                $this->load->model('invtran_model');
                $this->invtran_model->insertarProductoToFolderPreciosByGrid($trannum, $idproductos);
                
                $infoGeneral = $this->invtran_model->getDatosFolderDePrecios($trannum);
                $informacion = $this->invtran_model->getListadoProductosToFolder($trannum);
                
                $j=0;
                $array_datos = array();
                if($informacion != false){
                    foreach($informacion as $infoGrid){
                        if($infoGrid->existe == 0){
                            $array_datos[$j] = array(
                                "idproducto" => $infoGrid->idproducto,
                                "descrip" => $infoGrid->descrip,
                                "costounitario" => $infoGrid->costounitario,
                                "idcatalogo" => $infoGrid->idcatalogo,
                                "linea" => $infoGrid->linea,
                                "nameproveedor" => $infoGrid->nameproveedor,
                                "modelo" => $infoGrid->modelo,
                                "um" => $infoGrid->um,
                                "precioventa" => $infoGrid->precioventa,
                                "marca" => $infoGrid->marca,
                                "tipotax" => $infoGrid->tipotax,
                            );

                            $j++;
                        }
                    }
                }
                
                $array = array(
                    "datos" => $infoGeneral,
                    "informacion" => $array_datos
                );
                
                echo json_encode($array);
            }
        }
        
        function getListadoMarcasProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('producto_model');
                $marcas = $this->producto_model->verMarca();
                
                $array = array(
                    "marcas" => $marcas,
                );
                
                echo json_encode($array);
            }
        }
        
        function getListadoProductosMarca(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $marca = $this->input->post('marca');
                $idtrannum = $this->input->post('idtrannum');
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getProductosPorMarca($marca, $idtrannum);
                
                $j=0;
                $array_datos = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->existe == 0){
                            $array_datos[$j] = array(
                                "idproducto" => $info->idproducto,
                                "descrip" => $info->descrip,
                                "costounitario" => $info->costounitario,
                                "idcatalogo" => $info->idcatalogo,
                                "linea" => $info->linea,
                                "modelo" => $info->modelo,
                                "um" => $info->um,
                                "precioventa" => $info->precioventa,
                                "tipotax" => $info->tipotax
                            );
                            $j++;
                        }
                    }
                }
                
                echo json_encode($array_datos);
            }
        }
        
        function getListadoProductosToFolder(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getListadoProductosToFolder($idtrannum);
                
                $j=0;
                $array_datos = array();
                
                if($informacion!=false){
                    foreach($informacion as $info){
                        if($info->existe == 0){
                            $array_datos[$j] = array(
                                "idproducto" => $info->idproducto,
                                "descrip" => $info->descrip,
                                "costounitario" => $info->costounitario,
                                "idcatalogo" => $info->idcatalogo,
                                "linea" => $info->linea,
                                "nameproveedor" => $info->nameproveedor,
                                "modelo" => $info->modelo,
                                "um" => $info->um,
                                "precioventa" => $info->precioventa,
                                "marca" => $info->marca,
                                "tipotax" => $info->tipotax,
                            );

                            $j++;
                        }
                    }
                }
                
                echo json_encode($array_datos);
            }
        }
        
        function getProductosCatalogo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $idtrannum = $this->input->post('idtrannum');
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getProductosPorDepartamento($idcatalogo, $idtrannum);
                
                $j=0;
                $array_datos = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->existe == 0){
                            $array_datos[$j] = array(
                                "idproducto" => $info->idproducto,
                                "descrip" => $info->descrip,
                                "costounitario" => $info->costounitario,
                                "idcatalogo" => $info->idcatalogo,
                                "linea" => $info->linea,
                                "modelo" => $info->modelo,
                                "um" => $info->um,
                                "precioventa" => $info->precioventa,
                                "marca" => $info->marca,
                                "tipotax" => $info->tipotax
                            );

                            $j++;
                        }
                    }
                }
                
                echo json_encode($array_datos);
            }
        }
        
        function compras_linea(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,

                );
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $this->data['opcion_tipo'] = $opcionmenu;
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->load->model('sucursal_model');
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->load->model('producto_model');
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->load->view('mantenimiento_compras_linea', $this->data);
            }
        }

        function getSucursalesAjuste(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('sucursal_model');
                $sucursales = $this->sucursal_model->viewSucursalesActivas();

                echo json_encode($sucursales);
            }
        }
        
        function getComprasLinea(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idsucursal = $this->input->post('idsucursal');
                $tipopro = $this->input->post('tipopro');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getComprasDepto($idsucursal, $tipopro, $fechaini, $fechafin);
                
                $array = array();
                $i=0;
                 $array_lineas = array();
                        $j=0;
                if($informacion!=false){
                    $sum_total = 0;
                    foreach($informacion as $inf){
                        $sum_total += $inf->costoTotal;
                    }
                    //lineas
                    foreach($informacion as $inf){
                        
                        if($sum_total>0){
                            $part = $inf->costoTotal / $sum_total;
                        }else{
                            $part = 0;
                        }
                        $informacion_lineas = $this->invtran_model->getComprasLineas($idsucursal,$inf->iddepartamento, $tipopro, $fechaini, $fechafin);
                        if($informacion_lineas!=false){
                            $sum_total_lineas = 0;
                            foreach($informacion_lineas as $inf_linea){
                                $sum_total_lineas += $inf_linea->costoTotal;
                            }
                            foreach($informacion_lineas as $inf_linea){
                                if($sum_total_lineas>0){
                                    $part_lin = $inf_linea->costoTotal / $sum_total_lineas;
                                }else{
                                    $part_lin = 0;
                                }
                                $array_lineas[$j] =array(
                                    "iddepartamento" =>$inf->iddepartamento,
                                    "departamento" =>$inf->departamento,
                                    "participacion_padre" =>round((($part)* 100),2) ."%",
                                    "idlinea" =>$inf_linea->idlinea,
                                    "linea" =>$inf_linea->linea,
                                    "cantidadTotal" =>$inf_linea->cantidadTotal,
                                    "unidadesTotal" => round($inf_linea->unidadesTotal,0),
                                    "costoTotal" =>$inf_linea->costoTotal,
                                    "participacion" => round((($part_lin)* 100),2) ."%"
                                );
                                $j++;
                            }
                        }
                        
                        $array[$i] =array(
                            "tipomov" =>$inf->tipomov,
                            "iddepartamento" =>$inf->iddepartamento,
                            "departamento" =>$inf->departamento,
                            "cantidadTotal" =>$inf->cantidadTotal,
                            "costoTotal" =>$inf->costoTotal,
                            "participacion" => round((($part)* 100),2) ."%",
                            "lineas" => $array_lineas,
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array_lineas);
            }
        }
        
        function getKardexCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idsucursal = $this->input->post('idsucursal');
                $tipopro = $this->input->post('tipopro');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idlinea = $this->input->post('idlinea');
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getProductsLineaCO($idsucursal, $tipopro, $fechaini, $fechafin,$idlinea);
                echo json_encode($informacion);
            }
        }
        
        function compras_proveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,

                );
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $this->data['opcion_tipo'] = $opcionmenu;
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
                $this->load->model('producto_model');
                $this->load->model('sucursal_model');
				$this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->load->view('mantenimiento_compras_proveedores', $this->data);
            }
        }
        
        function getComprasProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipopro = $this->input->post('tipopro');
                $idcentro = $this->input->post('idcentro');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getComprasProveedorUpdate($tipopro, $idcentro, $fechaini, $fechafin);
                $array = array();
                $i=0;
                if($informacion!=false){
                    //lineas
                    foreach($informacion as $inf){
                        if($inf->costoProveedor>0){
                            $part = $inf->costoTotal / $inf->costoProveedor;
                        }else{
                            $part = 0;
                        }
                        $array[$i] =array(
                            "transaccion" =>$inf->transaccion,
                            "trannum" =>$inf->trannum,
                            "numDoc" =>$inf->serie.$inf->numero,
                            "fecha" =>$inf->fecha,
                            "idproveedor" =>$inf->idproveedor,
                            "proveedor" =>$inf->proveedor,
                            "cantidadTotal" =>round($inf->cantidadTotal,0),
                            "unidadesTotal" =>round($inf->unidadesTotal,0),
                            "costoTotal" =>$inf->costoTotal,
                            "participacion" => round((($part)* 100),2) ."%",
                        );
                        $i++;
                    }
                }
                echo json_encode($array);
            }
        }
        
        function getProductosCOProvee(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $proveedor = $this->input->post("name_provee");
                $tipopro = $this->input->post("tipopro");
                $fechaini = $this->input->post("fechaini");
                $fechafin = $this->input->post("fechafin");
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getProductosCOProvee($proveedor, $tipopro, $fechaini, $fechafin);
                $array = array();
                $i=0;
                if($informacion!=false){
                    foreach($informacion as $inf){
                        $array[$i] =array(
                            "descrip" =>$inf->descrip,
                            "trannum" =>$inf->trannum,
                            "numDoc" =>$inf->serie.$inf->numero,
                            "idproducto" =>$inf->idproducto,
                            "fecha" =>$inf->fecha,
                            "modelo" =>$inf->modelo,
                            "um" =>$inf->um,
                            "costounitario" =>$inf->costounitario,
                            "cantidad" =>round($inf->cantidad,0),
                            "subtotal" =>$inf->subtotal,
                        );
                        $i++;
                    }
                }
                echo json_encode($array);
            }
        }
        
        function getProductosCOTran(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
                $tipopro = $this->input->post("tipopro");
                $fechaini = $this->input->post("fechaini");
                $fechafin = $this->input->post("fechafin");
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getProductosCOTran($trannum, $tipopro, $fechaini, $fechafin);
                $array = array();
                $i=0;
                if($informacion!=false){
                    foreach($informacion as $inf){
                        $array[$i] =array(
                            "descrip" =>$inf->descrip,
                            "trannum" =>$inf->trannum,
                            "numDoc" =>$inf->serie.$inf->numero,
                            "idproducto" =>$inf->idproducto,
                            "fecha" =>$inf->fecha,
                            "modelo" =>$inf->modelo,
                            "um" =>$inf->um,
                            "costounitario" =>$inf->costounitario,
                            "cantidad" =>round($inf->cantidad,0),
                            "subtotal" =>$inf->subtotal,
                        );
                        $i++;
                    }
                }
                echo json_encode($array);
            }
        }
        
        function updateCantidadRecibidaProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
                $idrec = $this->input->post("idrec");
                $cantidad = $this->input->post("cantidad");
                
                $this->load->model('invtran_model');
                $actualiza = $this->invtran_model->updateCantidadRecibidaProduct($trannum, $idrec, $cantidad);
                $cant = $this->invtran_model->getCantPendiente($trannum);
                echo json_encode($cant);
            }
        }

        function getNotasRecepcion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
                $this->load->model('invtran_model');
                $data = $this->invtran_model->getNotasRecepcion($trannum);
                $cant = 0;
                $cadena = "Los siguientes productos se recibieron con diferencias: ";
                foreach($data as $dat){
                    if(abs($dat->barcode)!=abs($dat->cantidad)){
                        $cant++;
                        $cadena.= "Codigo: ". $dat->idproducto." | ".$dat->descrip."
                            Envio: ". round(abs($dat->cantidad),2)." | Rec: ".$dat->barcode." | Dif: ". round(abs($dat->cantidad) - $dat->barcode,2).".";
                    }
                }
                $arreglo = array(
                    "cantidad" =>$cant,
                    "cadena" =>$cadena,
                );
                
                echo json_encode($arreglo);
            }
        }

        function conversionDeProductos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $datosClases = $this->configuracion_model->getProCentro($idApp);
                $idclases = explode(",", $datosClases);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'idclaseconversion' => $idclases[0],
                    'idclasecierre' => $idclases[1]
                );
                $this->session->set_userdata($resultAppName);
                
                $direccion = $this->uri->segment(1);
                $this->load->model('global_model'); $this->load->model('invtran_model');
                $this->load->model('compras_model');
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['transacciones'] = $this->invtran_model->getTiposinout($idclases[0]);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);

                $this->load->view('mantenimiento_conversion_productos', $this->data);
            }
        }

        function getConversionesDeProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->session->userdata('idclaseconversion');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $array = $this->invtran_model->getConversionesDeProducto($idcentro, $idclase);

                echo json_encode($array);
            }
        }

        function insertarConversionProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $notas = $this->input->post('notas');
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $reemplazar = array("", "", "", "");
                $notas = str_replace($buscar, $reemplazar, $notas);
                
                $idcps = $this->input->post('idcps');
                $idclase = $this->input->post('idclase');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $array = $this->invtran_model->insertarConversionProducto($idcentro, $fecha, $idcps, $idclase, $notas);

                echo json_encode($array);
            }
        }

        function detalleConversionProductos($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $direccion = $this->uri->segment(1);

                $this->load->model('invtran_model');
                $this->load->model('global_model'); $this->load->model('compras_model');
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getInformacionConversion($trannum);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }
                
                $this->session->set_userdata($array);

                $this->load->view('mantenimiento_detalle_conversion_productos', $this->data);
            }
        }

        function getDatosConversionProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getDatosConversionProductos($trannum);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $cantidadA = 0;$cantidadB = 0;$cantidadC = 0;$cantidadD = 0;$cantidadE = 0;

                        $partesNotas = explode(";", $info->notas);
                        $informacionA = explode(",", $partesNotas[0]);

                        $cantidadA = $informacionA[1];

                        $array[$i] = array(
                            "itemline" => $info->itemline,
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "descripcion" => $info->descrip,
                            "cantidad" => abs($info->cantidad),
                            "cantidad_a" => $cantidadA,
                            "cantidad_b" => $cantidadB,
                            "cantidad_c" => $cantidadC,
                            "cantidad_d" => $cantidadD,
                            "cantidad_e" => $cantidadE
                        );
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function getListadoLineasConversion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('invtran_model'); 
                $lineas = $this->invtran_model->getGroupsProductosConversiones($trannum);
                
                $i=0;
                $array = array();                
                foreach($lineas as $data){
                    $array[$i] = array(
                        "idcatalogo" => $data->idcatalogo,
                        "imagen" => trim($data->imagen),
                        "descrip" => trim($data->descrip)
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }

        function getInventarioByCatalogConversiones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('invtran_model');
                $detalle = $this->invtran_model->getInventarioByCatalogConversion($trannum, $idcatalogo, $idcentro);
                
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    if($info->totalProductos > 0 && $info->existe == 0){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "mur" => $info->mur,
                            "sst" => $info->sst,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "existe" => $info->existe
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                echo json_encode($array);
            }
        }

        function getProductosToConversion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('invtran_model');
                $barcodeProd = $this->invtran_model->getBarcodeProducto($idproducto);
                $informacion = $this->invtran_model->getProductosToConversion($idproducto);

                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $array[$i] = array(
                        "idproducto" => $info->idproducto,
                        "descrip" => $info->descrip,
                        "cantidad" => 0,
                        "um" => $info->um,
                        "mur" => $info->mur,
                        "sst" => $info->sst,
                        "barcode" => $info->barcode,
                        "costounitario" => $info->costounitario,
                        "subtotal" => $info->costounitario
                    );
                    $i++;
                }

                $data = array(
                    "informacion" => $array,
                    "barcodeproducto" => $barcodeProd
                );
                echo json_encode($data);
            }
        }

        function insertarProductoConversion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $trannum = $this->input->post('trannum');
                $tipotax = $this->input->post('tipotax');
                $idproducto = $this->input->post('idproducto');
                $cantidad = $this->input->post('cantidad');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $cantidadA = $this->input->post('cantidadA');
                $factorA = $this->input->post('factorA');
                $idproductoA = $this->input->post('idproductoA');
                $idcentro = $this->session->userdata('idcentrouser');
                $idclase = $this->session->userdata('idclaseconversion');

                $this->load->model('invtran_model');
                $this->invtran_model->insertarProductoConversion($trannum,$um,$precio,$idcatalogo,$uniconv,$tipotax,$cantidad,$idproducto,$cantidadA,$factorA,$idproductoA,$idcentro,$idclase);
                $informacion = $this->invtran_model->getDatosConversionProductos($trannum);
                $infoLineas = $this->invtran_model->getInventarioByCatalogConversion($trannum, $idcatalogo, $idcentro);
                
                $j=0;
                $datos = array();
                foreach($infoLineas as $info){
                    if($info->totalProductos > 0 && $info->existe == 0){
                        $datos[$j] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "mur" => $info->mur,
                            "sst" => $info->sst,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "existe" => $info->existe
                        );
                        $j++;
                    }
                }

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $cantidadA = 0;$cantidadB = 0;$cantidadC = 0;$cantidadD = 0;$cantidadE = 0;

                        $partesNotas = explode(";", $info->notas);
                        $informacionA = explode(",", $partesNotas[0]);
                        
                        $cantidadA = $informacionA[1];
                        
                        $array[$i] = array(
                            "itemline" => $info->itemline,
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "descripcion" => $info->descrip,
                            "cantidad" => abs($info->cantidad),
                            "cantidad_a" => $cantidadA,
                            "cantidad_b" => $cantidadB,
                            "cantidad_c" => $cantidadC,
                            "cantidad_d" => $cantidadD,
                            "cantidad_e" => $cantidadE
                        );
                        $i++;
                    }
                }

                $dataSource = array(
                	"infoLineas" => $datos,
                	"infoGrid" => $array,
                    "cantidad" => $j
                );
                echo json_encode($dataSource);
            }
        }

        function eliminarProductoConvertido(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            	$idrec = $this->input->post('idrec');
            	$trannum = $this->input->post('trannum');
            	$idcatalogo = $this->input->post('idcatalogo');
            	$idcentro = $this->session->userdata('idcentrouser');

            	$this->load->model('invtran_model');
                $this->invtran_model->eliminarProductoConvertido($idrec);
                $informacion = $this->invtran_model->getDatosConversionProductos($trannum);
				$infoLineas = $this->invtran_model->getInventarioByCatalogConversion($trannum, $idcatalogo, $idcentro);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $cantidadA = 0;$cantidadB = 0;$cantidadC = 0;$cantidadD = 0;$cantidadE = 0;

                        $partesNotas = explode(";", $info->notas);
                        $informacionA = explode(",", $partesNotas[0]);
                        
                        $cantidadA = $informacionA[1];
                        
                        $array[$i] = array(
                            "itemline" => $info->itemline,
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "descripcion" => $info->descrip,
                            "cantidad" => abs($info->cantidad),
                            "cantidad_a" => $cantidadA,
                            "cantidad_b" => $cantidadB,
                            "cantidad_c" => $cantidadC,
                            "cantidad_d" => $cantidadD,
                            "cantidad_e" => $cantidadE
                        );
                        $i++;
                    }
                }

                $j=0;
                $datos = array();
                foreach($infoLineas as $info){
                    if($info->totalProductos > 0 && $info->existe == 0){
                        $datos[$j] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "mur" => $info->mur,
                            "sst" => $info->sst,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "existe" => $info->existe
                        );
                        $j++;
                    }
                }

                $dataSource = array(
                	"infoLineas" => $datos,
                	"infoGrid" => $array,
                    "cantidad" => $j
                );
                echo json_encode($dataSource);
            }
        }

        function getDatosSearchConversion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $dato = $this->input->post('dato');
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
                $prosearch = number_format($this->input->post('prosearch'), 0);
                
                $this->load->model('invtran_model');
                $detalle = $this->invtran_model->getDatosProductoSearchConversion($prosearch, $dato, $idcentro, $trannum);
                if($detalle != 0){
                    $i=0; $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
						$items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "namecatalogo" => $info->namecatalogo,
                            "precioventa" => $info->precioventa,
                            "precio" => $info->costounitario,
                            "costouni" => $info->costouni,
                            "mur" => $info->mur,
                            "sst" => $info->sst,
							"agregado" => 0
                        );
                        $i++;
                    }
                    if($agregado == 1 && $i == 1){
						$array = array("error" => "2");
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }

                echo json_encode($array);
            }
        }

        function cerrarConversionProductos(){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $notas = $this->input->post('notas');
                $trannum = $this->input->post('trannum');
                $idclase = $this->session->userdata('idclasecierre');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                
                $this->invtran_model->updateCierreConversion($trannum, $notas);
                $trannumCierre = $this->invtran_model->insertarRegistroCierreConversion($idclase, $idcentro);
                $array = $this->invtran_model->updateBinBatchConversion($trannumCierre, $trannum, $idclase);

                echo json_encode($array);
            }
        }
        
        function exportacionMovimientosInventario($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('configuracion_model');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp'   => $idApp,
                    'appName'  => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
				$this->data['formatos']   = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                $this->load->view('mantenimiento_exportacion_inventario', $this->data);
            }
        }
        
        function inputListadoTransacciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('invtran_model');
                $infoDatos = $this->invtran_model->getListadoTransaccionesAgrupadas('VN');
                
                $j=0;
                $itemsDef = array();
                foreach($infoDatos as $infoClases){
                    $itemsDef[$j] = array(
                        "id" => $infoClases->invclase,
                        "descrip" => $infoClases->descrip
                    );
                    $j++;
                }
                
                $array[0] = array(
                    "id" => "9991",
                    "descrip" => "Ventas",
                    "items" => $itemsDef
                );
                
                $infoDatos = $this->invtran_model->getListadoTransaccionesAgrupadas('CO');
                
                $j=0;
                $itemsDef = array();
                foreach($infoDatos as $infoClases){
                    $itemsDef[$j] = array(
                        "id" => $infoClases->invclase,
                        "descrip" => $infoClases->descrip
                    );
                    $j++;
                }
                
                $array[1] = array(
                    "id" => "9992",
                    "descrip" => "Compras",
                    "items" => $itemsDef
                );
                
                $infoDatos = $this->invtran_model->getListadoTransaccionesAgrupadas('IN');
                
                $j=0;
                $itemsDef = array();
                foreach($infoDatos as $infoClases){
                    $itemsDef[$j] = array(
                        "id" => $infoClases->invclase,
                        "descrip" => $infoClases->descrip
                    );
                    $j++;
                }
                
                $array[2] = array(
                    "id" => "9993",
                    "descrip" => "Inventario",
                    "items" => $itemsDef
                );
                
                echo json_encode($array);
            }
        }
        
        function reporteExportacionDeMovimientos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
                $idcentro = $this->input->post('idcentro');
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
                $idtransacciones = $this->input->post('idclases');
                
                $this->load->model('invtran_model');
                $infoMovimientos = $this->invtran_model->reporteExportacionDeMovimientos($idrec, $idcentro, $idtransacciones, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                if($infoMovimientos != false){
                    foreach($infoMovimientos as $infovn){
                        if($infovn->nameVendedor == null || $infovn->nameVendedor == ""){
                            $nameGestor = $infovn->nameGestor;
                        }else{
                            $nameGestor = $infovn->nameVendedor;
                        }
                        
                        if($infovn->tipo == 4){
                            $nameProducto = (($infovn->notasProducto == '') ? $infovn->nameProducto : $infovn->notasProducto);
                        }else{
                            $nameProducto = $infovn->nameProducto;
                        }
                        
                        $array[$i] = array(
                            "idrec" => $infovn->idrec,
                            "nameSucursal" => strtoupper($infovn->nameSucursal),
                            "nameCaja" => strtoupper($infovn->nameCaja),
                            "estatus" => $infovn->estatus,
                            "trannum" => $infovn->trannum,
                            "serienumero" => $infovn->serie.$infovn->numero,
                            "notas" => $infovn->notas,
                            "fecha" => $infovn->fecha,
                            "nameDocumento" => strtoupper($infovn->nameDocumento),
                            "origen_destino" => strtoupper($infovn->origen_destino),
                            "itemline" => $infovn->itemline,
                            "um" => $infovn->um,
                            "marca" => strtoupper($infovn->marca),
                            "modelo" => strtoupper($infovn->modelo),
                            "nameLinea" => strtoupper($infovn->nameLinea),
                            "nameDepartamento" => strtoupper($infovn->nameDepartamento),
                            "idproducto" => $infovn->idproducto,
                            "nameProducto" => strtoupper($nameProducto),
                            "notasProducto" => strtoupper($infovn->notasProducto),
                            "nameCliente" => strtoupper($infovn->nameCliente),
                            "nameVendedor" => strtoupper($nameGestor),
                            "tipo" => $infovn->tipoProducto,
                            "nameProveedor" => strtoupper($infovn->nameProveedor),
                            "costounitario" => ($infovn->costounitario * $infovn->uniconv) * $infovn->inopera,
                            "costototal" => $infovn->costounitario * ($infovn->cantidad * $infovn->uniconv),
                            "precioneto" => ($infovn->precioneto * 1) * $infovn->inopera,
                            "utilidad" => ($infovn->precioneto * 1 != 0) ? (($infovn->precioneto * 1) - ($infovn->costounitario * $infovn->uniconv)) : 0,
                            "subtotal" => $infovn->precioneto * ($infovn->cantidad),
                            "iva_uni" => ($infovn->precioneto * ($infovn->tax1 / 100)) * $infovn->inopera,
                            "iva_total" => $infovn->precioneto * ($infovn->tax1 / 100)  * ($infovn->cantidad),
                            "comision" => (($infovn->precioneto * ($infovn->tax1 / 100)  * ($infovn->cantidad)) + $infovn->precioneto * ($infovn->cantidad)) * ($infovn->comision / 100),
                            "totalventa" => ($infovn->precioneto * ($infovn->tax1 / 100)  * ($infovn->cantidad)) + $infovn->precioneto * ($infovn->cantidad),
                            "cantidad" => $infovn->cantidad,
                            "cantidadReal" => ($infovn->cantidad * $infovn->uniconv),
                            //"cantidadstock" => $this->invtran_model->getCantidadStock($infovn->idproducto, $infovn->idcentro),
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }

        function mantenimientoDescargaMP($idapp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('global_model');
                $this->load->model('configuracion_model');
                
                $appName = $this->configuracion_model->getAppName($idapp);
                $idclase = $this->configuracion_model->getProCentro($idapp);
                
                $infoAppName = array(
                    'iddApp' => $idapp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $idcentro = $this->session->userdata('idcentrouser');
                $direccion = $this->uri->segment(1);
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 

                $this->load->model('invtran_model');
                $this->load->model('sucursal_model'); $this->load->model('compras_model');
                
                $this->data['idClase'] = $idclase;
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['sucursales'] = $this->invtran_model->getAllCentrosActivos();
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);

                $this->load->view('mantenimiento_descarga_mp', $this->data);
            }
        }

        function getListadoDescargaMP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getListadoDescargaMP($idclase, $idcentro, $fechaini, $fechafin);

                echo json_encode($informacion);
            }
        }

        function insertarDescargaMP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaIni');
                $fechafin = $this->input->post('fechaFin');
                $notas = $this->input->post('notas');
                $idclase = $this->input->post('idclase');
                $idworker = $this->input->post('idworker');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $validate = $this->invtran_model->validateDescargaMP($fechaini, $fechafin, $idclase, $idcentro);
                
                $trannum = 0;
                if($validate == 0){
                    $trannum = $this->invtran_model->insertarDescargaMP($fechaini, $fechafin, $idclase, $idcentro, $idworker, $notas);
                }

                $array = array(
                    "trannum" => $trannum,
                    "validate" => $validate
                );

                echo json_encode($array);
            }
        }
        
        function detalleDescargaMP($trannum, $idClase){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $infoAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N° '.$trannum
                );
                $this->session->set_userdata($infoAppName);
                
                $direccion = $this->uri->segment(1);
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('global_model'); $this->load->model('compras_model');
                $this->load->model('invtran_model');
                
                $this->data['idClase'] = $idClase;
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['informacion'] = $this->invtran_model->getInformacionDescargaMP($trannum);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);

                $this->load->view('mantenimiento_detalle_descarga_mp', $this->data);
            }
        }

        function getDetalleCombosDescarga(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getDetalleCombosDescarga($fechaini, $fechafin, $idcentro);

                echo json_encode($informacion);
            }
        }

        function getDetalleComponentesCombosDescarga(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $estado = $this->input->post('estado');
                $trannum = $this->input->post('trannum');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getDetalleComponentesCombosDescarga($trannum, $fechaini, $fechafin, $idcentro, $estado);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "tipoproducto" => $info->tipoproducto,
                            "um" => $info->um,
                            "cantidad" => number_format($info->cantidad, 2, '.', '') * 1,
                            "saldo" => number_format($info->saldo, 2, '.', '') * 1
                        );

                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function validateCajasFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->validateCajasFacturacion($fechafin, $idcentro);

                $i=0; $validate=0;
                $infoSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->idrec != 0){
                            $estado = "Cerrada";
                        }else{
                            $vApertura = $this->invtran_model->validateAperturaCajaFacturacion($fechafin, $idcentro, $info->idcaja);

                            $estado = (($vApertura == 0) ? "Cerrada" : "Abierta");
                            $validate = (($vApertura == 0) ? 0 : 1);
                        }

                        $infoSource[$i] = array(
                            "descrip" => $info->descrip,
                            "estado" => $estado
                        );

                        $i++;
                    }
                }

                $array = array(
                    "informacion" => $infoSource,
                    "validate" => $validate
                );

                echo json_encode($array);
            }
        }

        function cerrarDescargaMP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $notas = $this->input->post('notas');
                $estado = $this->input->post('estado');
                $trannum = $this->input->post('trannum');
                $idclase = $this->input->post('idclase');
                $idworker = $this->input->post('idworker');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getDetalleComponentesCombosDescarga($trannum, $fechaini, $fechafin, $idcentro, $estado);
                                
                $validate=0;
                if($informacion != false){
                    foreach($informacion as $info){
                        if((number_format($info->cantidad, 2, '.', '') * 1) > (number_format($info->saldo, 2, '.', '') * 1)){
                            $validate=1;
                        }
                    }
                }
                
                if($validate == 0){
                    $this->invtran_model->cerrarDescargaMP($trannum, $fechaini, $fechafin, $idcentro, $idclase, $idworker, $notas);
                }

                $array = array(
                    "validate" => $validate
                );

                echo json_encode($array);
            }
        }

        function anularDescargaComponentes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->anularDescargaComponentes($trannum);

                echo json_encode($array);
            }
        }
        
        function reporteAdValorem($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $idauto  = $this->configuracion_model->getProCentro($idApp);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);

                $this->load->model('global_model');
				
                $controlador = $this->uri->segment(1);
                $this->data['idauto'] = ($idauto === '') ? 12 : $idauto;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                
                $this->load->view('mantenimiento_ad_valorem', $this->data);
            }
        }

        function getDatosDepartamentosAD(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('invtran_model');
                
                $idDepartamentos = $this->global_model->getValorTextoVariable('ad_valoremdpto');
                $array = $this->invtran_model->getDepartamentosByID($idDepartamentos);

                echo json_encode($array);
            }
        }

        function generarReporteADValorem(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $idcatalogo = $this->input->post('idcatalogo');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idautoconsumo = $this->input->post('idautoconsumo');

                $this->load->model('global_model');
                $this->load->model('invtran_model');
                
                $informacion = $this->invtran_model->generarReporteADValorem($idcentro, $idcatalogo, $fechaini, $fechafin, $idautoconsumo);
                
                $i=0; $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $inicial      = ($info->inicial == '') ? 0 : $info->inicial;
                        $compras      = ($info->compras == '') ? 0 : $info->compras;
                        $ventas       = ($info->ventas  == '') ? 0 : $info->ventas * -1;
                        $autoconsumo  = ($info->autoconsumo  == '') ? 0 : $info->autoconsumo * -1;
                        $devoluciones = ($info->devoluciones == '') ? 0 : $info->devoluciones;
                        $u_sujetas    = $ventas  + $autoconsumo + $devoluciones;
                        $final        = $inicial + $compras - $ventas - $autoconsumo + $devoluciones;
                        $precioneto   = ($u_sujetas == 0) ? number_format($info->vprecioneto, 2, '.', '') : number_format($info->vprecioneto, 2, '.', '') / $u_sujetas;
                        $diferencial  = number_format($precioneto, 2, '.', '') - number_format(($info->coarancel / (1 +($info->tipotax / 100))), 2, '.', '');

                        $valtax = (int) $info->copartida;
                        $valtax = ($valtax * 1) / 100;
                        /*
                            $array[$i] = array(
                                "idproducto"    => $info->idproducto,
                                "descrip"       => $info->descrip,
                                "linea"         => $info->linea,
                                "modelo"        => $info->modelo,
                                "um"            => $info->um,
                                "coarancel"     => ($info->coarancel / (1 +($info->tipotax / 100))),
                                "cantidad"      => $info->cantidad,
                                "porcentaje"    => $info->copartida . "%",
                                "precioneto"    => number_format($precioneto, 2, '.', ''),
                                "diferencial"   => number_format($diferencial, 2, '.', ''),
                                "basevalorem"   => number_format($diferencial, 2, '.', '') * $info->cantidad,
                                "impuestoad"    => number_format((number_format($diferencial, 2, '.', '') * $info->cantidad) * $valTax, 4, '.', '')
                            );
                        */

                        $array[$i] = array(
                            "idproducto"    => $info->idproducto,
                            "descrip"       => $info->descrip,
                            "um"            => $info->um,
                            "coarancel"     => ($info->coarancel / (1 + ($info->tipotax / 100))),
                            "precioneto"    => number_format($precioneto,  2, '.', ''),
                            "diferencial"   => number_format($diferencial, 2, '.', ''),
                            "inventario"    => $inicial,
                            "compras"       => $compras,
                            "disponible"    => $inicial + $compras,
                            "exporta"       => 0,
                            "ventas"        => $ventas,
                            "autoconsumo"   => $autoconsumo,
                            "faltantes"     => 0,
                            "devoluciones"  => $devoluciones,
                            "final"         => $final,
                            "u_sujetas"     => $u_sujetas,
                            "linea"         => $info->linea,
                            "modelo"        => $info->modelo,
                            "basevalorem"   => number_format($diferencial, 2, '.', '') * $u_sujetas,
                            "porcentaje"    => $info->copartida . "%",
                            "impuestoad"    => number_format((number_format($diferencial, 2, '.', '') * $u_sujetas) * $valtax, 4, '.', '')
                        );
    
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }
        
        #GoXpos
        function descargaComponentesOC($idapp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->load->model('global_model');
                $this->load->model('configuracion_model');
                
                $appName = $this->configuracion_model->getAppName($idapp);
                $opciones = $this->configuracion_model->getProCentro($idapp);
                
                $infoAppName = array(
                    'iddApp' => $idapp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $direccion = $this->uri->segment(1);
                
                $this->load->model('invtran_model');
                $this->load->model('compras_model');
                $this->load->model('sucursal_model');
                
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 
                $valores = explode(',', $opciones);

                $this->data['estado_oc']   = $valores[0];
                $this->data['idClase']     = $valores[1];
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;
                $this->data['empleados']   = $this->compras_model->getListProveedores(3);
                $this->data['sucursales']  = $this->invtran_model->getAllCentrosActivos();
                $this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($direccion);

                $this->load->view('mantenimiento_descarga_comp_oc', $this->data);
            }
        }

        #GoXpos
        function detalleDescargaComponentesOC($trannum, $idClase, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $infoAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N° '.$trannum
                );
                $this->session->set_userdata($infoAppName);
                
                $direccion = $this->uri->segment(1);
                
                $this->load->model('global_model'); $this->load->model('compras_model');
                $this->load->model('invtran_model');
                
                $this->data['idClase']     = $idClase;
                $this->data['estado_oc']   = $estado;
                $this->data['empleados']   = $this->compras_model->getListProveedores(3);
                $this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->invtran_model->getInformacionDescargaMP($trannum);

                $this->load->view('mantenimiento_detalle_descarga_comp_oc', $this->data);
            }
        }

        #GoXpos
        function insertarDescargaOC(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $notas = $this->input->post('notas');
                $idclase = $this->input->post('idclase');
                $idworker = $this->input->post('idworker');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('invtran_model');
                $trannum = $this->invtran_model->insertarDescargaOC($fecha, $idclase, $idcentro, $idworker, $notas);

                $array = array(
                    "trannum" => $trannum
                );

                echo json_encode($array);
            }
        }

        #GoXpos
        function getListadoOrdenesToDescarga() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $idcentro = $this->input->post('idcentro');
                $estado   = $this->input->post('estado');

                $this->load->model('invtran_model');
                $array = $this->invtran_model->getListadoOrdenesToDescarga($trannum, $idcentro, $estado);

                echo json_encode($array);
            }
        }
        
        #GoXpos
        function getListadoOrdenesInDescarga() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');

                $this->load->model('invtran_model');
                $array = $this->invtran_model->getListadoOrdenesInDescarga($trannum);

                echo json_encode($array);
            }
        }
        
        #GoXpos
        function getDetalleComponentesProductosDescarga() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $estado   = $this->input->post('estado');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getDetalleComponentesProductosDescarga($trannum, $estado, $idcentro);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "tipoproducto" => $info->tipoproducto,
                            "um" => $info->um,
                            "cantidad" => number_format($info->cantidad, 2, '.', '') * 1,
                            "saldo" => number_format($info->saldo, 2, '.', '') * 1
                        );

                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        #GoXpos
        function setOrdenesDescargaOC() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $ids_oc   = $this->input->post('ids_oc');
                $estado   = $this->input->post('estado');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('invtran_model');
                $this->invtran_model->setOrdenesDescargaOC($trannum, $ids_oc);
                $ordenes     = $this->invtran_model->getListadoOrdenesInDescarga($trannum);
                $informacion = $this->invtran_model->getDetalleComponentesProductosDescarga($trannum, $estado, $idcentro);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "tipoproducto" => $info->tipoproducto,
                            "um" => $info->um,
                            "cantidad" => number_format($info->cantidad, 2, '.', '') * 1,
                            "saldo" => number_format($info->saldo, 2, '.', '') * 1
                        );

                        $i++;
                    }
                }

                $dataSource = array(
                    'ordenes' => $ordenes,
                    'detalle' => $array
                );

                echo json_encode($dataSource);
            }
        }

        #GoXpos
        function cancelarOrdenDescarga() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $idorder  = $this->input->post('idorder');
                $estado   = $this->input->post('estado');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('invtran_model');
                $this->invtran_model->cancelarOrdenDescarga($idorder);
                $ordenes     = $this->invtran_model->getListadoOrdenesInDescarga($trannum);
                $informacion = $this->invtran_model->getDetalleComponentesProductosDescarga($trannum, $estado, $idcentro);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "tipoproducto" => $info->tipoproducto,
                            "um" => $info->um,
                            "cantidad" => number_format($info->cantidad, 2, '.', '') * 1,
                            "saldo" => number_format($info->saldo, 2, '.', '') * 1
                        );

                        $i++;
                    }
                }

                $dataSource = array(
                    'ordenes' => $ordenes,
                    'detalle' => $array
                );

                echo json_encode($dataSource);
            }
        }

        #GoXpos
        function cerrarDescargaOC() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $idclase  = $this->input->post('idclase');
                $idworker = $this->input->post('idworker');
                $idcentro = $this->input->post('idcentro');
                $estado   = $this->input->post('estado');
                $notas    = $this->input->post('notas');

                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getDetalleComponentesProductosDescarga($trannum, $estado, $idcentro);
                                
                $validate=0;
                if($informacion != false){
                    foreach($informacion as $info){
                        if(($info->cantidad * 1) > ($info->saldo * 1)){
                            $validate=1;
                        }
                    }
                }
                
                if($validate == 0){
                    $this->invtran_model->cerrarDescargaOC($trannum, $idcentro, $idclase, $idworker, $notas);
                }

                $array = array(
                    "validate" => $validate
                );

                echo json_encode($array);
            }
        }

        #GoXpos
        function anularDescargaOC() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('invtran_model');
                $array = $this->invtran_model->anularDescargaOC($trannum);

                echo json_encode($array);
            }
        }

        #Repoorte de Existencias F983.
        function reporteExistenciasF983($idapp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('configuracion_model');
                
                $appName = $this->configuracion_model->getAppName($idapp);
                
                $infoAppName = array(
                    'iddApp' => $idapp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $direccion = $this->uri->segment(1);
                
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['sucursales']    = $this->sucursal_model->viewSucursalActiva();
                $this->data['formatos']      = $this->global_model->getFormatosImpresionGrid($direccion);

                $this->load->view('mantenimiento_reporte_f983', $this->data);
            }
        }
        
        #Repoorte de Existencias F983.
        function reporteInformeInventario($idapp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                // $this->load->model('producto_model');
                $this->load->model('configuracion_model');
                
                $appName = $this->configuracion_model->getAppName($idapp);
                
                $infoAppName = array(
                    'iddApp' => $idapp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $direccion = $this->uri->segment(1);
                
                // $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['sucursales']    = $this->sucursal_model->viewSucursalActiva();
                $this->data['formatos']      = $this->global_model->getFormatosImpresionGrid($direccion);

                $this->load->view('mantenimiento_reporte_informe_inventario', $this->data);
            }
        }

        function getComprasXProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproveedor = $this->input->post('idproveedor');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $this->load->model('invtran_model');
                $informacion = $this->invtran_model->getComprasProveedorUpdate($fechaini, $fechafin, $idproveedor);
                
                echo json_encode($informacion);
            }
        }

        #   BITACORA DE VENTAS
        
        function bitacora_ventas($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);

                $this->load->model('ventas_model'); $this->load->model('global_model');
                $this->load->model('invtran_model'); $this->load->model('user_model');
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $fechaactual = $date->format('Y-m-d');
                
                $permite = 0;
                $derechos = $this->user_model->getDerechos();
                if($derechos != ""){
                    $pos = strpos($derechos, "costo");
                    if($pos !== false){
                        if($pos >= 0){
                            $permite=1;
                        }   
                    }
                }
				
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
				$this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $this->data['newcliente'] = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
                $this->data['pos_referencia'] = $this->global_model->getValorNumVariable('pos_referencia');
                $this->data['fechaactual'] = $fechaactual;
                $this->data['primerdia'] = date('Y-m-01'); // hard-coded '01' for first day
                $this->data['ultimodia'] = date('Y-m-t');
                $this->data['permite_derechos'] = $permite;
				
				$idcentro = $this->session->userdata('idcentrouser');
				$this->load->view('mantenimiento_bitacora_ventas', $this->data);
            }
        }

        #   LISTADO DE TRANSACCIONES DE UN COMPONENTE
        function getTransaccionesPorComponente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcomponente = $this->input->post('idcomponente');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('invtran_model');
                $resultado = $this->invtran_model->getTransaccionesPorComponente($idcomponente, $fechaini, $fechafin, $idcentro);
                
                $transacciones = [];
                if($resultado){
                    foreach($resultado as $res){
                        $cantidad = number_format(abs($res->uniconv * $res->cantidad), 2, '.', '');
                        $serie = $res->serie.$res->numero;
                        $transacciones[] = array(
                            "trannum" => $res->trannum,
                            "serienum" => $serie,
                            "combo" => $res->descrip,
                            "cantidad" => $cantidad,
                            "worker" => $res->idworker
                        );
                    }
                }

                echo json_encode($transacciones);
            }
        }

        #Repoorte de Existencias F142
        function reporteExistenciasF142($idapp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->load->model('global_model');
                $this->load->model('producto_model');
                $this->load->model('configuracion_model');
                
                $appName  = $this->configuracion_model->getAppName($idapp);
                $tipoprod = $this->configuracion_model->getOptionsByidapp($idapp);

                $infoAppName = array(
                    'iddApp' => $idapp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($infoAppName);
                
                $itemsProd = $this->producto_model->viewProductosOrdenadosReporte_F142($tipoprod);

                foreach ( $itemsProd as $key=>$value ) {
                    $itemsProd[$key]['producto'] = '['.$value['id'].'] '.$value['descrip'];
                }
                
                $this->data['fechaactual'] = $date->format('Y-m-d');
                $this->data['productos']   = $itemsProd;
                $this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));

                $this->load->view('mantenimiento_reporte_f142', $this->data);
            }
        }

        function getDatosF142(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro  = $this->input->post('idcentro');
                $productos = $this->input->post('idproducto');
                $fechaini  = $this->input->post('fechaini');
                $fechafin  = $this->input->post('fechafin');

                $this->load->model('auxi_model');
                $this->load->model('invtran_model');
                $this->load->model('producto_model');

                $arrayIdProducto = explode("-", $productos);
                $resultado = [];

                foreach($arrayIdProducto as $idproducto){
                    //DATOS INICIALES

                    $costopromedio = 0;
                    $saldoInicialValores = 0;
                    $saldoInicialUnidades = 0;
                    $i = 1;

                    //TOTALES
                    $totalEntradas = 0;
                    $totalSalidas = 0;
                    $totalDebe = 0;
                    $totalHaber = 0;
                    $transaccionesIniciales = $this->invtran_model->getDatosPreviosF142($idcentro, $idproducto, $fechaini);
                    $fichaProducto = $this->producto_model->getProducto($idproducto);
                    $nombreProducto = strtoupper($fichaProducto->descrip);

                    //$this->highlight_array($fichaProducto);
                    foreach($transaccionesIniciales as $tran){
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                    

                        //SALIDA
                        if($tran['inopera'] == -1){
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            //$totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorHaber;
                            //$totalHaber += $valorHaber;

                        
                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            //$totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            //$totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];

                            if($tran['agrupa'] == 'CO'){
                                $nacionalidadData = $this->auxi_model->getNacionalidadAuxi($tran['idcps']);

                                if (is_array($nacionalidadData) && array_key_exists('pais', $nacionalidadData)) {
                                    $nacionalidad = $nacionalidadData['pais'];
                                }

                                if (is_array($nacionalidadData) && array_key_exists('descrip', $nacionalidadData)) {
                                    $descripProveedor = $nacionalidadData['descrip'];
                                }
                            }
                        }
                    }

                    if($saldoInicialUnidades != 0){
                        $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                    }

                    //SALDO INICIAL
                    $resultado[] = array(
                        "no" => $i,
                        "trannum" =>  '',
                        "idproducto" =>  '',
                        "tipoprod" =>  '',
                        "fecha" =>'',
                        "numDoc" => '',
                        "tipoDoc" => 'Saldo Inicial',
                        "descripProveedor" => '',
                        "nacionalidad" => '',
                        "precioUnitario" => '',
                        "costoUnitario" => $costopromedio,
                        "unidadEntrada" => '',
                        "unidadSalida" => '',
                        "unidadSaldo" => $saldoInicialUnidades,
                        "valorEntrada" => '',
                        "valorSalida" => '',
                        "valorSaldo" => $saldoInicialValores,
                        "agrupa" => '',
                        "nombreProducto" => $nombreProducto

                    );

                    //DATOS DE LAS TRANSACCIONES
                    $transacciones = $this->invtran_model->getDatosF142($idcentro, $idproducto, $fechaini, $fechafin);

                    if ($transacciones != false) {
                        foreach($transacciones as $tran){
                            $i++;
                            $unidadEntrada = 0;
                            $unidadSalida = 0;
    
                            $valorDebe = 0;
                            $valorHaber = 0;
                            $precioUnitario = 0;
                            $nacionalidad = '';
                            $descripProveedor = '';
    
                            //calculo del costo promedio 
                            //se toman los saldos del registro anterior
                            if($saldoInicialUnidades != 0){
                                $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                            }
    
                            //SALIDA
                            if($tran['inopera'] == -1){ 
                                //if ($costopromedio == 0) {
                                    $costopromedio = $tran['costounitario'];
                                //}

                                //Unidades
                                $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                                $saldoInicialUnidades += $unidadSalida;
                                $totalSalidas += $unidadSalida;
    
                                //Valores
                                $valorHaber = $tran['cantidad']*$tran['uniconv']*$costopromedio;
                                $saldoInicialValores += $valorHaber;
                                $totalHaber += $valorHaber;
    
                            //ENTRADA
                            }else{  
                                //Unidades
                                $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                                $saldoInicialUnidades += $unidadEntrada;
                                $totalEntradas += $unidadEntrada;
    
                                //Valores
                                if($tran['agrupa'] == 'CO'){
                                    $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['preciotran'];
                                }else{
                                    $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                                }

                                $saldoInicialValores += $valorDebe; 
                                $totalDebe += $valorDebe;
    
                                $precioUnitario = $tran['preciotran'];
                                $costopromedio = $tran['costounitario'];
    
                                if($tran['agrupa'] == 'CO'){
                                    //DATOS DEL PROVEEDOR SI ES COMPRA
                                    $nacionalidadData = $this->auxi_model->getNacionalidadAuxi($tran['idcps']);

                                    if (is_array($nacionalidadData) && array_key_exists('pais', $nacionalidadData)) {
                                        $nacionalidad = $nacionalidadData['pais'];
                                    }

                                    if (is_array($nacionalidadData) && array_key_exists('descrip', $nacionalidadData)) {
                                        $descripProveedor = $nacionalidadData['descrip'];
                                    }
                                }
                            }
    
                            $resultado[] = array(
                                "no" => $i,
                                "trannum" =>  $tran['trannum'],
                                "idproducto" =>  $tran['idproducto'],
                                "tipoprod" =>  $tran['tipoprod'],
                                "fecha" => $tran['fecha'],
                                "numDoc" => $tran['serie'].$tran['numero'],
                                "tipoDoc" => $tran['descripDoc'],
                                "descripProveedor" => $descripProveedor,
                                "nacionalidad" => $nacionalidad,
                                "precioUnitario" => $precioUnitario,
                                "costoUnitario" => $costopromedio,
                                "unidadEntrada" => abs($unidadEntrada),
                                "unidadSalida" => abs($unidadSalida),
                                "unidadSaldo" => $saldoInicialUnidades,
                                "valorEntrada" => abs($valorDebe),
                                "valorSalida" => abs($valorHaber),
                                "valorSaldo" => $saldoInicialValores,
                                "agrupa" => $tran['agrupa'],
                                "nombreProducto" => $nombreProducto
    
                            );
                        }
                    }

                    //SALDO FINAL
                    $i++;
                    $resultado[] = array(
                        "no" => $i,
                        "trannum" =>  '',
                        "idproducto" =>  '',
                        "tipoprod" =>  '',
                        "fecha" => $fechafin,
                        "numDoc" => '',
                        "tipoDoc" => 'Saldo Final',
                        "descripProveedor" => '',
                        "nacionalidad" => '',
                        "precioUnitario" => 0,
                        "costoUnitario" => 0,
                        "unidadEntrada" => abs($totalEntradas),
                        "unidadSalida" => abs($totalSalidas),
                        "unidadSaldo" => $saldoInicialUnidades,
                        "valorEntrada" => abs($totalDebe),
                        "valorSalida" => abs($totalHaber),
                        "valorSaldo" => $saldoInicialValores,
                        "agrupa" => '',
                        "nombreProducto" => $nombreProducto

                    );
                }
                
                echo json_encode($resultado);
            }
        }

        function getDatosF142New(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $productos = $this->input->post('idproducto');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $offset   = $this->input->post('offset');

                $this->load->model('invtran_model');
                $this->load->model('producto_model');
                $this->load->model('auxi_model');

                $arrayIdProducto = explode("-", $productos);
                $resultado = [];

                foreach($arrayIdProducto as $idproducto){
                    //DATOS INICIALES

                    $costopromedio = 0;
                    $saldoInicialValores = 0;
                    $saldoInicialUnidades = 0;
                    $i = 1;

                    //TOTALES
                    $totalEntradas = 0;
                    $totalSalidas = 0;
                    $totalDebe = 0;
                    $totalHaber = 0;
                    $transaccionesIniciales = $this->invtran_model->getDatosPreviosF142($idcentro, $idproducto, $fechaini);
                    $fichaProducto = $this->producto_model->getProducto($idproducto);
                    $nombreProducto = strtoupper($fichaProducto->descrip);

                    //$this->highlight_array($fichaProducto);
                    foreach($transaccionesIniciales as $tran){
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                    

                        //SALIDA
                        if($tran['inopera'] == -1){
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            //$totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorHaber;
                            //$totalHaber += $valorHaber;

                        
                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            //$totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            //$totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];

                            if($tran['agrupa'] == 'CO'){
                                $nacionalidadData = $this->auxi_model->getNacionalidadAuxi($tran['idcps']);

                                if (is_array($nacionalidadData) && array_key_exists('pais', $nacionalidadData)) {
                                    $nacionalidad = $nacionalidadData['pais'];
                                }

                                if (is_array($nacionalidadData) && array_key_exists('descrip', $nacionalidadData)) {
                                    $descripProveedor = $nacionalidadData['descrip'];
                                }
                            }
                        }
                    }

                    if($saldoInicialUnidades != 0){
                        $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                    }

                    //SALDO INICIAL
                    $resultado[] = array(
                        "no" => $i,
                        "trannum" =>  '',
                        "fecha" =>'',
                        "numDoc" => '',
                        "tipoDoc" => 'Saldo Inicial',
                        "descripProveedor" => '',
                        "nacionalidad" => '',
                        "precioUnitario" => '',
                        "costoUnitario" => $costopromedio,
                        "unidadEntrada" => '',
                        "unidadSalida" => '',
                        "unidadSaldo" => $saldoInicialUnidades,
                        "valorEntrada" => '',
                        "valorSalida" => '',
                        "valorSaldo" => $saldoInicialValores,
                        "agrupa" => '',
                        "nombreProducto" => $nombreProducto

                    );

                    //DATOS DE LAS TRANSACCIONES
                    $transacciones = $this->invtran_model->getDatosF142($idcentro, $idproducto, $fechaini, $fechafin, $offset);

                    if ($transacciones != false) {
                        foreach($transacciones as $tran){
                            $i++;
                            $unidadEntrada = 0;
                            $unidadSalida = 0;
    
                            $valorDebe = 0;
                            $valorHaber = 0;
                            $precioUnitario = 0;
                            $nacionalidad = '';
                            $descripProveedor = '';
    
                            //calculo del costo promedio 
                            //se toman los saldos del registro anterior
                            if($saldoInicialUnidades != 0){
                                $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                            }
    
                            //SALIDA
                            if($tran['inopera'] == -1){ 
                                //Unidades
                                $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                                $saldoInicialUnidades += $unidadSalida;
                                $totalSalidas += $unidadSalida;
    
                                //Valores
                                $valorHaber = $tran['cantidad']*$tran['uniconv']*$costopromedio;
                                $saldoInicialValores += $valorHaber;
                                $totalHaber += $valorHaber;
    
                            //ENTRADA
                            }else{  
                                //Unidades
                                $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                                $saldoInicialUnidades += $unidadEntrada;
                                $totalEntradas += $unidadEntrada;
    
                                //Valores
                                $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                                $saldoInicialValores += $valorDebe; 
                                $totalDebe += $valorDebe;
    
                                $precioUnitario = $tran['costounitario'];
    
                                if($tran['agrupa'] == 'CO'){
                                    //DATOS DEL PROVEEDOR SI ES COMPRA
                                    $nacionalidadData = $this->auxi_model->getNacionalidadAuxi($tran['idcps']);

                                    if (is_array($nacionalidadData) && array_key_exists('pais', $nacionalidadData)) {
                                        $nacionalidad = $nacionalidadData['pais'];
                                    }

                                    if (is_array($nacionalidadData) && array_key_exists('descrip', $nacionalidadData)) {
                                        $descripProveedor = $nacionalidadData['descrip'];
                                    }
                                }
                            }
    
                            $resultado[] = array(
                                'offset' => $offset,
                                "no" => $i,
                                "trannum" =>  $tran['trannum'],
                                "fecha" => $tran['fecha'],
                                "numDoc" => $tran['serie'].$tran['numero'],
                                "tipoDoc" => $tran['descripDoc'],
                                "descripProveedor" => $descripProveedor,
                                "nacionalidad" => $nacionalidad,
                                "precioUnitario" => $precioUnitario,
                                "costoUnitario" => $costopromedio,
                                "unidadEntrada" => abs($unidadEntrada),
                                "unidadSalida" => abs($unidadSalida),
                                "unidadSaldo" => $saldoInicialUnidades,
                                "valorEntrada" => abs($valorDebe),
                                "valorSalida" => abs($valorHaber),
                                "valorSaldo" => $saldoInicialValores,
                                "agrupa" => $tran['agrupa'],
                                "nombreProducto" => $nombreProducto
    
                            );
                        }
                    }

                    //SALDO FINAL
                    $i++;
                    $resultado[] = array(
                        "no" => $i,
                        "trannum" =>  '',
                        "fecha" => $fechafin,
                        "numDoc" => '',
                        "tipoDoc" => 'Saldo Final',
                        "descripProveedor" => '',
                        "nacionalidad" => '',
                        "precioUnitario" => 0,
                        "costoUnitario" => 0,
                        "unidadEntrada" => abs($totalEntradas),
                        "unidadSalida" => abs($totalSalidas),
                        "unidadSaldo" => $saldoInicialUnidades,
                        "valorEntrada" => abs($totalDebe),
                        "valorSalida" => abs($totalHaber),
                        "valorSaldo" => $saldoInicialValores,
                        "agrupa" => '',
                        "nombreProducto" => $nombreProducto

                    );
                }
                

                //$this->highlight_array($resultado);
                echo json_encode($resultado);
            }
        }
        
        function getDatosReporteInformeInventario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro  = $this->input->post('idcentro');
                $fechaini  = $this->input->post('fechaini');
                $fechafin  = $this->input->post('fechafin');
                $offset    = $this->input->post('offset');
                $limit     = $this->input->post('limit');
                $resultado = [];

                $this->load->model('invtran_model');
                $totalReg = $this->invtran_model->getTotalRegistrosInformeInventario();
                $informacion = $this->invtran_model->getDatosReporteInformeInventario($offset, $limit);

                foreach($informacion as $info) {
                    $resultado[] = array(
                        'codigoProveedor'  => $info->codigoProveedor,
                        'proveedor'     => $info->proveedor,
                        'grupoProvee'   => $info->grupoProvee,
                        'departamento'  => $info->departamento,
                        'linea'         => $info->linea,
                        'idproducto'    => $info->idproducto,
                        'modelo'        => $info->modelo,
                        'marca'         => $info->marca,
                        'descrip'       => $info->descrip,
                        'um'            => $info->um,
                        'tipo'          => $info->tipo,
                        'precioventa'   => $info->precioventa,
                        'saldo_inicial' => $this->invtran_model->getSaldoInicialInformeIN($info->idproducto, $idcentro, $fechaini),
                        'entradas'      => $this->invtran_model->getEntradasInformeIN($info->idproducto, $idcentro, $fechaini, $fechafin),
                        'salidas'       => $this->invtran_model->getSalidasInformeIN($info->idproducto, $idcentro, $fechaini, $fechafin),
                        'costounitario' => $this->invtran_model->getCostoUnitarioInformeIN($info->idproducto, $idcentro, $fechafin),
                        'saldo_final'   => $this->invtran_model->getSaldoFinalInformeIN($info->idproducto, $idcentro, $fechafin),
                        'valor'         => $this->invtran_model->getValorTotalInformeIN($info->idproducto, $idcentro, $fechafin),
                    );
                }
                
                echo json_encode(array(
                    'total' => $totalReg,
                    'data' => $resultado
                ));
            }
        }

        function informeInventarioConsigna($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('configuracion_model');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);

                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['primerdia'] = date('Y-m-01'); // hard-coded '01' for first day
                $this->data['ultimodia'] = date('Y-m-t');
                
                $this->load->view('mantenimiento_informe_inventario_consigna', $this->data);
            }
        }

        function getDatosReporteInformeInventarioConsigna(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro  = $this->input->post('idcentro');
                $fechaini  = $this->input->post('fechaini');
                $fechafin  = $this->input->post('fechafin');
                $offset    = $this->input->post('offset');
                $limit     = $this->input->post('limit');
                $resultado = [];

                $this->load->model('invtran_model');
                $totalReg = $this->invtran_model->getTotalRegistrosInformeInventario();
                $informacion = $this->invtran_model->getDatosReporteInformeInventarioConsigna($idcentro);

                foreach($informacion as $info) {
                    $resultado[] = array(
                        'namesucursal'     => $info->namesucursal,
                        'namedepartamento' => $info->namedepartamento,
                        'namelinea'        => $info->namelinea,
                        'idproducto'       => $info->idproducto,
                        'modelo'           => $info->modelo,
                        'nameproducto'     => $info->nameproducto,
                        'namecliente'      => $info->namecliente,
                        'saldo_inicial'    => $this->invtran_model->getSaldoInicialInformeINCon($info->idproducto, $info->idcps, $idcentro, $fechaini, $info->idcps_branch),
                        'entradas'         => $this->invtran_model->getEntradasInformeINCon($info->idproducto, $info->idcps, $idcentro, $fechaini, $fechafin, $info->idcps_branch),
                        'salidas'          => $this->invtran_model->getSalidasInformeINCon($info->idproducto, $info->idcps, $idcentro, $fechaini, $fechafin, $info->idcps_branch),
                        'costounitario'    => $this->invtran_model->getCostoUnitarioInformeINCon($info->idproducto, $info->idcps, $idcentro, $fechafin, $info->idcps_branch),
                        'saldo_final'      => $this->invtran_model->getSaldoFinalInformeINCon($info->idproducto, $info->idcps, $idcentro, $fechafin, $info->idcps_branch),
                        'valor'            => $this->invtran_model->getValorTotalInformeINCon($info->idproducto, $info->idcps, $idcentro, $fechafin, $info->idcps_branch),
                    );
                }
                
                echo json_encode(array(
                    'total' => $totalReg,
                    'data' => $resultado
                ));
            }
        }
	}
?>