<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

    class Invtools extends CI_Controller {
        
        function __construct(){
            parent::__construct();
        }

		function highlight_array($array, $name = 'var') {
            highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
        }
        
        function mantenimiento_min_max($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
				$this->load->model('producto_model');
				$this->load->model('user_model');
                $this->load->model('invtran_model');
				$this->load->model('sucursal_model');
				$this->load->model('compras_model');
                $appName = $this->configuracion_model->getAppName($idApp);
				$opcionmenu = $this->configuracion_model->getProCentro($idApp);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
					'opcionmenu' => $opcionmenu,
                );
                $this->session->set_userdata($resultAppName);
				$this->data['opcion_tipo'] = $opcionmenu;
                $controlador = $this->uri->segment(1);
                $direccion = $controlador;
                $this->data['direccion'] = $direccion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['tipos']  = $this->sucursal_model->getTipo();
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['centros']  = $this->sucursal_model->viewSucursal();
                $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
                $this->data['lineas'] = $this->producto_model->viewLineas();
				$this->data['tipos_search'] = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
				$this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
                $this->load->view('mantenimiento_minmax', $this->data);
            }
        }
		
        function getListProducts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				
				$tipoPro 	= $this->input->post('tipoPro');
                $idsucursal = $this->input->post('idsucursal');
                $idcatalogo = $this->input->post('idcatalogo');
				
				$this->load->model('invtran_model');
				$this->load->model('invtools_model');
                
				$productos  = $this->invtools_model->getProducts($tipoPro, $idsucursal, $idcatalogo);
				
				$i=0;
				$array = array();
				if($productos!=false){
					foreach($productos as $pro){
						$idrec_minmax=0;
						$reorder_point="";
						$reorder_qty="";
						$reorder_last_review="";
						$reorder_notas="";
						$review_cycle = "";
						if($pro->existe==1){
							$reorder = $this->invtools_model->getInfoMinmax($pro->id,$idsucursal);
							if($reorder!=false){
								$idrec_minmax = $reorder['idrec'];
								$reorder_point = $reorder['reorder_point'];
								$reorder_qty = $reorder['reorder_qty'];
								$reorder_notas = $reorder['notas'];
								$reorder_last_review = $reorder['last_review'];
								$review_cycle = $reorder['review_cycle'];

							}
						}
						$proveedor = ($pro->proveedor != null) ? $pro->proveedor : $this->invtran_model->getNameProveedorCompra($pro->id);
						$array[$i] = array(
							"id" => $pro->id,
							"imagen" => $pro->imagen,
							"producto" => $pro->producto,
							"idcatalogo" => $pro->idcatalogo,
							"linea" => $pro->linea,
							"departamento" => $pro->departamento,
							"marca" => $pro->marca,
							"barcode" => $pro->barcode,
							"modelo" => $pro->modelo,
							"um" => $pro->um,
							"upp" => (int)$pro->upp,
							"precioventa" => $pro->precioventa,
							"costounitario" => $pro->costounitario,
							"xpos" => $pro->xpos,
							"cantidad" => $pro->cantidad,
							"existe" => $pro->existe,	
							"reorder_idrec" => $idrec_minmax,	
							"reorder_point" => $reorder_point,//($reorder_point == 0) ? '' : $reorder_point,	
							"reorder_qty" => $reorder_qty,	
							"reorder_notas" => $reorder_notas,	
							"reorder_last_review" => $reorder_last_review,
							"review_cycle" => $review_cycle,
							"proveedor" => $proveedor,
							"pedir" => ($pro->cantidad < $reorder_point) ? ($reorder_qty - $pro->cantidad) : ''
						);
						$i++;
					}
				}
				echo json_encode($array);
            }
        }

        function insertMinMax(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('invtools_model');
                $idproducto = $this->input->post('idproducto');
				$idcatalogo = $this->input->post('idcatalogo');
                $idrec = $this->input->post('reorder_idrec');
                $tipoPro = $this->input->post('tipoPro');
                $idsucursal = $this->input->post('idsucursal');
                $puntoreorden = $this->input->post('puntoreorden');
                $cantidad_reorden = $this->input->post('cantidad_reorden');
				$review_cycle = $this->input->post('review_cycle');

                $notas = $this->input->post('notas');
				$insert = $this->invtools_model->insert_update_MinMax($idrec,$idproducto,$idsucursal,$puntoreorden,$cantidad_reorden, $notas, $review_cycle);
				echo json_encode($insert);
            }
        }
		
        function getMovimientoProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				
				$this->load->model('invtools_model');
                $idproducto = $this->input->post('idproducto');
				$idsucursal = $this->input->post('idsucursal');
				$tipoPro = $this->input->post('tipoPro');

				$list_transacciones = $this->session->userdata('opcionmenu');
				$fecha_actual = date("Y-m-d H:i:s");
				$actual = strtotime($fecha_actual);

				switch(date("N")){
					case 1:
						$week8 = date("Y-m-d", strtotime("+6 days", $actual));
						break;
					case 2:
						$week8 = date("Y-m-d", strtotime("+5 days", $actual));
						break;
					case 3:
						$week8 = date("Y-m-d", strtotime("+4 days", $actual));
						break;
					case 4:
						$week8 = date("Y-m-d", strtotime("+3 days", $actual));
						break;
					case 5:
						$week8 = date("Y-m-d", strtotime("+2 days", $actual));
						break;
					case 6:
						$week8 = date("Y-m-d", strtotime("+1 days", $actual));
						break;
					case 7:
						$week8 = date("Y-m-d", strtotime($actual));
						break;
				}
				
				$final = strtotime($week8);			
				$week7 = date("Y-m-d", strtotime("-1 week", $final));
				$week6 = date("Y-m-d", strtotime("-2 week", $final));
				$week5 = date("Y-m-d", strtotime("-3 week", $final));
				$week4 = date("Y-m-d", strtotime("-4 week", $final));
				$week3 = date("Y-m-d", strtotime("-5 week", $final));
				$week2 = date("Y-m-d", strtotime("-6 week", $final));
				$week1 = date("Y-m-d", strtotime("-7 week", $final));
				$week0 = date("Y-m-d", strtotime("-8 week", $final));
				
				$week8_ini = date("d/m/Y", strtotime("-6 days", $final));
				$week8_fin = date("d/m/Y", $final);
				
				$week7_ini = date("d/m/Y", strtotime("-13 days", $final));
				$week7_fin = date("d/m/Y", strtotime("-7 days", $final));
				
				$week6_ini = date("d/m/Y", strtotime("-20 days", $final));
				$week6_fin = date("d/m/Y", strtotime("-14 days", $final));
				
				$week5_ini = date("d/m/Y", strtotime("-27 days", $final));
				$week5_fin = date("d/m/Y", strtotime("-21 days", $final));
				
				$week4_ini = date("d/m/Y", strtotime("-34 days", $final));
				$week4_fin = date("d/m/Y", strtotime("-28 days", $final));
				
				$week3_ini = date("d/m/Y", strtotime("-41 days", $final));
				$week3_fin = date("d/m/Y", strtotime("-35 days", $final));
				
				$week2_ini = date("d/m/Y", strtotime("-48 days", $final));
				$week2_fin = date("d/m/Y", strtotime("-42 days", $final));
				
				$week1_ini = date("d/m/Y", strtotime("-55 days", $final));
				$week1_fin = date("d/m/Y", strtotime("-49 days", $final));
				
				
							
				$consumototal = 0;	
				$promedio = 0;	
				$datos = $this->invtools_model->getMovimientoProduct($idproducto,$idsucursal,$tipoPro,$week8,$week7,$week6,$week5,$week4,$week3,$week2,$week1,$week0);
				$array = array();
				if($datos!=false){
					$consumototal = abs($datos["week1"])+abs($datos["week2"])+abs($datos["week3"])+abs($datos["week4"])+abs($datos["week5"])+abs($datos["week6"])+abs($datos["week7"])+abs($datos["week8"]);
					$promedio = round($consumototal/8,2);
					$array[0] = array(
						"semana" => "1",
						"cant" => 1* abs($datos["week1"]),
						"promedio" => $promedio,
						"data" => array(
							"semana" => "1",
							"promedio" => $promedio,
							"inicio" => $week1_ini,
							"fin" => $week1_fin,
							"cant" => 1* abs($datos["week1"]),
						)
					);
					$array[1] = array(
						"semana" => "2",
						"cant" => 1* abs($datos["week2"]),
						"data" => array(
							"semana" => "2",
							"promedio" => $promedio,
							"inicio" => $week2_ini,
							"fin" => $week2_fin,
							"cant" => 1* abs($datos["week2"]),
						)
					);
					$array[2] = array(
						"semana" => "3",
						"cant" => 1* abs($datos["week3"]),
						"data" => array(
							"semana" => "3",
							"promedio" => $promedio,
							"inicio" => $week3_ini,
							"fin" => $week3_fin,
							"cant" => 1* abs($datos["week3"]),
						)
					);
					$array[3] = array(
						"semana" => "4",
						"cant" => 1* abs($datos["week4"]),
						"data" => array(
							"semana" => "4",
							"promedio" => $promedio,
							"inicio" => $week4_ini,
							"fin" => $week4_fin,
							"cant" => 1* abs($datos["week4"]),
						)
					);
					$array[4] = array(
						"semana" => "5",
						"cant" => 1* abs($datos["week5"]),
						"data" => array(
							"semana" => "5",
							"promedio" => $promedio,
							"inicio" => $week5_ini,
							"fin" => $week5_fin,
							"cant" => 1* abs($datos["week5"]),
						)
					);
					$array[5] = array(
						"semana" => "6",
						"cant" => 1* abs($datos["week6"]),
						"data" => array(
							"semana" => "6",
							"promedio" => $promedio,
							"inicio" => $week6_ini,
							"fin" => $week6_fin,
							"cant" => 1* abs($datos["week6"]),
						)
					);
					$array[6] = array(
						"semana" => "7",
						"cant" => 1* abs($datos["week7"]),
						"data" => array(
							"semana" => "7",
							"promedio" => $promedio,
							"inicio" => $week7_ini,
							"fin" => $week7_fin,
							"cant" => 1* abs($datos["week7"]),
						)
					);
					$array[7] = array(
						"semana" => "8",
						"cant" => 1* abs($datos["week8"]),
						"promedio" => $promedio,
						"data" => array(
							"semana" => "8",
							"promedio" => $promedio,
							"inicio" => $week8_ini,
							"fin" => $week8_fin,
							"cant" => 1* abs($datos["week8"]),
						)
					);
				}
				
				$array_echo = array(
					"chart" =>$array,
					"consumototal" =>$consumototal,
					"promedio" =>$promedio,
				);
				echo json_encode($array_echo);
            }
		}
		#------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		#	GENERAR MOVIMIENTO DE PRODUCTOS EN N CANTIDAD DE DIAS
		public function getMovsProducto()
		{
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            } else {
				date_default_timezone_set('America/El_Salvador');
				$this->load->model('invtools_model');
                $IDProducto = (int)$this->input->post('idproducto');
				$IDSucursal = (int)$this->input->post('idsucursal');
				$tipopro = (int)$this->input->post('tipoPro');

				$list_transacciones = $this->session->userdata('opcionmenu');

				$fi = date("Y-m-d");
				$Dias = 7;
				$Dias = (int)$this->input->post('dias');
				$ff = date('Y-m-d', strtotime($fi. ' - '.($Dias - 1).' days'));
				$dias = array(
					'Domingo' => 1,
					'Lunes' => 2,
					'Martes' => 3,
					'Miércoles' => 4,
					'Jueves' => 5,
					'Viernes' => 6,
					'Sábado' => 7,
				);

				//Obtiene una matriz compuesta de los N dias atras de la fecha actual
				$Datos = [];
				for ($i = 0; $i < $Dias; $i++) { 
					$object = new stdClass();
					$object->fecha = date('Y-m-d', strtotime($ff. ' + '.$i.' days'));
					$object->cantidad = 0.00;
					$object->dia = $i + 1;
					$object->diaT = array_search(date('N', strtotime($object->fecha)), $dias);
					$object->fecha2 = date('d/m/Y', strtotime($object->fecha));
					$Datos[] = $object;//*/
				}				

				//Obtiene el movimiento por ventas agrupado por fechas del item
				$datos = $this->invtools_model->getMovsVenta($IDProducto, $IDSucursal, $ff, $fi, $tipopro);
				$TotalT = 0;
				$CompraT = 0;

				foreach ($Datos as $daton) { 
					//Obtiene el inventario para cada uno de los dias de la matriz de fechas
					$inventario = $this->invtools_model->getMovsInventario($IDProducto, $IDSucursal, $daton->fecha);
					$daton->inventario = round((($inventario->inventario > 0) ? $inventario->inventario : 0), 2);

					//Obtiene las compras para cada uno de los dias de la matriz de fechas
					$compra = $this->invtools_model->getMovsCompra($IDProducto, $IDSucursal, $daton->fecha);
					$daton->compra = round((($compra->compra > 0) ? $compra->compra : 0), 2);
					$CompraT += $daton->compra;
					if ($datos->num_rows() > 0) {
						foreach ($datos->result() as $dato) {
							if ($dato->fecha == $daton->fecha) {
								$daton->cantidad = abs(round($dato->saldo, 2));
								$TotalT += $daton->cantidad;
								break; 
							}
						}
					}
				}

				$PromT = round(($TotalT / $Dias), 2);
				$datA[] = array('valido' => true, 'datos' => $Datos, 'total' => $TotalT, 'comprat' => $CompraT, 'prom' => $PromT);
				echo json_encode($datA);
			}
		}
		#	REPORTE
		public function RMinMax($IDTipo, $IDSucursal, $IDDepartamento)
		{
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            } else {
				if ( ($IDTipo != null && is_numeric($IDTipo)) &&
					($IDSucursal != null && is_numeric($IDSucursal)) &&
					($IDDepartamento != null && is_numeric($IDDepartamento))
				) {
                    $this->load->model('invtools_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    //$this->load->model('dev_model');
					date_default_timezone_set('America/El_Salvador');
					$colorborder = '#737373';
					$empresa = trim($this->session->userdata('descrip'));
                    $usuario = $this->session->userdata('userLog');
                    if ($IDDepartamento != 0) {
                        $depto = $this->global_model->getDataDepartamento($IDDepartamento);
                        $TDepartamento = $depto->descrip;
                    } else $TDepartamento = '--TODOS--';
                    $sucursal = $this->global_model->getDataSucursal($IDSucursal);
                    $TSucursal = $sucursal->descripcion.' / '.$sucursal->descrip;
					$this->load->library('Pdfconta');
					$pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
					$header = '
						<table style="width: 100%;" >
							<tr style="font-size: 15px; font-family: sans-serif;">
								<td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
							</tr>
							<tr style="font-size: 16px; font-family: sans-serif;">
								<td style="width: 100%; text-align: center;"><strong>Productos bajo Reorden</strong></td>
							</tr>
						</table>
						<table style="width: 100%; font-size: 10px;">
							<tr><td style="text-align: center; font-size: 5px;"></td></tr>
							<tr>
								<td style="width: 100%; text-align: left; font-size: 13px;"><strong>Tipo: </strong>'.$this->global_model->getDescripcionTipoProducto($IDTipo).'</td>
                            </tr>
                            <tr>
								<td style="width: 100%; text-align: left; font-size: 13px;"><strong>Sucursal: </strong>'.$TSucursal.'</td>
							</tr>
                            <tr>
								<td style="width: 100%; text-align: left; font-size: 13px;"><strong>Departamento: </strong>'.$TDepartamento.'</td>
                            </tr>
                            <tr><td style="text-align: center; font-size: 5px;"></td></tr>
                            <tr>
                                <td style="background-color: '.$colorborder.'; color: white; width: 8%; line-height: 25px; font-weight: bold; font-size: 10px;">Código</td>
                                <td style="background-color: '.$colorborder.'; color: white; width: 56%; line-height: 25px; font-weight: bold; font-size: 10px;">Descripción</td>
                                <td style="background-color: '.$colorborder.'; color: white; width: 8%; line-height: 25px; font-weight: bold; font-size: 10px;">UM</td>
                                <td style="background-color: '.$colorborder.'; color: white; width: 7%; line-height: 25px; font-weight: bold; font-size: 10px;">Saldo</td>
                                <td style="background-color: '.$colorborder.'; color: white; width: 7%; font-weight: bold; font-size: 10px;">Punto Reorden</td>
                                <td style="background-color: '.$colorborder.'; color: white; width: 7%; font-weight: bold; font-size: 10px;">Cantidad Reorden</td>
                                <td style="background-color: '.$colorborder.'; color: white; width: 7%; font-weight: bold; font-size: 10px;">Cantidad Pedir</td>
                            </tr>
                        </table>
                    ';
					$pdf->setHtmlHeader($header);
					$dataFooter = '
						<table style="width=100%; border-top: 1px solid black; margin: 0px; padding: 0px;">
							<tr style="font-size: 10px;">
								<td style="width:33%; text-align: left;">'.date_create()->format('d/m/Y H:i:s A').'</td>
								<td style="width:34%; text-align: center;">'.$usuario.'</td>
								<td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
							</tr>
						</table>
					';
					$pdf->setHtmlFooter($dataFooter);
					$pdf->SetCreator(PDF_CREATOR);
					$pdf->SetAuthor('Versanet Sistemas');
					$pdf->SetTitle('Reporte de Productos bajo Reorden');
					$pdf->SetSubject('Reporte de Productos bajo Reorden');
					$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
					$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
					$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
					$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
					$pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
					$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
					$pdf->setFontSubsetting(true);
					$pdf->setPageOrientation('P');
					$pdf->SetFont('Helvetica', '', 7, '', true);
					//$pdf->SetMargins(4, 40, 4, 0);
					$pdf->SetMargins(5, 40, 5, 0);// left top right
					$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
					$pdf->SetFooterMargin(0, 0, 0, 0);
					$pdf->AddPage('p', 'LETTER');
                    $html = '
                        <table style="width: 100%; font-size: 10px;">
                            <tr><td style="text-align: center; font-size: 0px;">HOLA</td></tr>
                    ';
                    $Datos = null;
                    /*if ($this->session->userdata("idaccount") == "090294") {
                        $datos = $this->invtools_model->getProducts($IDTipo,$IDSucursal,$IDDepartamento);
                        if ($datos != false) {
                            foreach ($datos as $dato) {
                                $idrec_minmax=0;
                                $reorder_point="";
                                $reorder_qty="";
                                $reorder_last_review="";
                                $reorder_notas="";
                                if($dato->existe==1){
                                    $reorder = $this->invtools_model->getInfoMinmax($dato->id, $IDSucursal);
                                    if($reorder!=false){
                                        $idrec_minmax = $reorder['idrec'];
                                        $reorder_point = $reorder['reorder_point'];
                                        $reorder_qty = $reorder['reorder_qty'];
                                        $reorder_notas = $reorder['notas'];
                                        $reorder_last_review = $reorder['last_review'];
                                    }
                                }
                                if ($dato->cantidad < $reorder_point) {
                                    $html .= '
                                        <tr>
                                            <td style="width: 8%; font-size: 10px;">'.$dato->id.'</td>
                                            <td style="width: 56%; font-size: 10px; text-align: left;">'.$dato->producto.'</td>
                                            <td style="width: 8%; font-size: 10px; text-align: left;">'.$dato->um.'</td>
                                            <td style="width: 7%; font-size: 10px;">'.round($dato->cantidad, 2).'</td>
                                            <td style="width: 7%; font-size: 10px;">'.round($reorder_point, 2).'</td>
                                            <td style="width: 7%; font-size: 10px;">'.round($reorder_qty, 2).'</td>
                                            <td style="width: 7%; font-size: 10px;">'.($reorder_qty - $dato->cantidad).'</td>
                                        </tr>
                                    ';
                                }
                            }
                        }
                    } else {}//*/
                    $datos = $this->invtools_model->getProducts($IDTipo,$IDSucursal,$IDDepartamento);
                    if ($datos != false) {
                        foreach ($datos as $dato) {
                            $idrec_minmax=0;
                            $reorder_point="";
                            $reorder_qty="";
                            $reorder_last_review="";
                            $reorder_notas="";
                            if($dato->existe==1){
                                $reorder = $this->invtools_model->getInfoMinmax($dato->id, $IDSucursal);
                                if($reorder!=false){
                                    $idrec_minmax = $reorder['idrec'];
                                    $reorder_point = $reorder['reorder_point'];
                                    $reorder_qty = $reorder['reorder_qty'];
                                    $reorder_notas = $reorder['notas'];
                                    $reorder_last_review = $reorder['last_review'];
                                }
                            }
                            if ($dato->cantidad < $reorder_point) {
                                $proveedor = ($dato->proveedor != null) ? $dato->proveedor : $this->invtran_model->getNameProveedorCompra($dato->id);
                                $Datos[] = array(
                                    'id' => $dato->id,
                                    'producto' => $dato->producto,
                                    'um' => $dato->um,
                                    'cantidad' => $dato->cantidad,
                                    'reorden_punto' => $reorder_point,
                                    'reorden_cant' => $reorder_qty,
                                    'pedir' => ($reorder_qty - $dato->cantidad),
                                    'proveedor' => $proveedor
                                );//*/
                            }
                        }
                    }
                    if ($Datos != null) {
                        $proveedor  = array_column($Datos, 'proveedor');
                        $producto = array_column($Datos, 'producto');
                        array_multisort($proveedor, SORT_ASC, $producto, SORT_ASC, $Datos);
                        $valor = $Datos[0]['proveedor'];
                        $html .= '
                            <tr>
                                <td style="width: 100%; font-weight: bold; text-align: left; font-size: 11px; border-bottom: 1px solid black;">'.$valor.'</td>
                            </tr>
                        ';
                        foreach ($Datos as $dato) {
                            if ($valor == $dato['proveedor']) {
                                $html .= '
                                    <tr>
                                        <td style="width: 8%; font-size: 10px;">'.$dato['id'].'</td>
                                        <td style="width: 56%; font-size: 10px; text-align: left;">'.$dato['producto'].'</td>
                                        <td style="width: 8%; font-size: 10px; text-align: left;">'.$dato['um'].'</td>
                                        <td style="width: 7%; font-size: 10px;">'.round($dato['cantidad'], 2).'</td>
                                        <td style="width: 7%; font-size: 10px;">'.round($dato['reorden_punto'], 2).'</td>
                                        <td style="width: 7%; font-size: 10px;">'.round($dato['reorden_cant'], 2).'</td>
                                        <td style="width: 7%; font-size: 10px;">'.$dato['pedir'].'</td>
                                    </tr>
                                ';
                            } else {
                                $valor = $dato['proveedor'];
                                $html .= '
                                    <tr>
                                        <td style="width: 100%; font-weight: bold; text-align: left; font-size: 11px; border-bottom: 1px solid black;">'.$valor.'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 8%; font-size: 10px;">'.$dato['id'].'</td>
                                        <td style="width: 56%; font-size: 10px; text-align: left;">'.$dato['producto'].'</td>
                                        <td style="width: 8%; font-size: 10px; text-align: left;">'.$dato['um'].'</td>
                                        <td style="width: 7%; font-size: 10px;">'.round($dato['cantidad'], 2).'</td>
                                        <td style="width: 7%; font-size: 10px;">'.round($dato['reorden_punto'], 2).'</td>
                                        <td style="width: 7%; font-size: 10px;">'.round($dato['reorden_cant'], 2).'</td>
                                        <td style="width: 7%; font-size: 10px;">'.$dato['pedir'].'</td>
                                    </tr>
                                ';
                            }
                            //$html .= '';
                        }
                    }
                    
                    $html .= '</table>';
					$pdf->writeHTML($html, true, 0, false, false, 0);
					$nombre_archivo = utf8_decode("ReporteBajoReorden.pdf");
					$pdf->Output($nombre_archivo, 'I');
				} else echo "<h1>Parámetro Incorecto</h1>";
			}
		}
		#-
		#------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		
		function getDistribucionConsumo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				date_default_timezone_set('America/El_Salvador');
				
				$this->load->model('invtools_model');
                $idproducto = $this->input->post('idproducto');
				$idsucursal = $this->input->post('idsucursal');
				$tipoPro = $this->input->post('tipoPro');

				$list_transacciones = $this->session->userdata('opcionmenu');
				$fecha_actual = date("Y-m-d H:i:s");
				$actual = strtotime($fecha_actual);
				$inicial = date("Y-m-d", strtotime("-8 week", $actual));
				$final = date("Y-m-d", strtotime($fecha_actual));
				$datos = $this->invtools_model->getDistribucionConsumo($idproducto,$idsucursal,$tipoPro,$inicial,$final);
				echo json_encode($datos);
				
			}
		}
        
        function generacionResultadoSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentros = $this->input->post('idcentros');
                $estados = $this->input->post('estados');
                $criterios = $this->input->post('criterios');
                $descrip = $this->input->post('descrip');
                $departamento = $this->input->post('departamento');
                $linea = $this->input->post('linea');
                $proveedor = $this->input->post('proveedor');
                $marca = $this->input->post('marca');
                $modelo = $this->input->post('modelo');
                $barcode = $this->input->post('barcode');
                $xpos = $this->input->post('xpos');
                $idproducto = $this->input->post('idproducto');
                $um = $this->input->post('um');
                $precioventa = $this->input->post('precioventa');
                
                $this->load->model('invtools_model');
                $informacion = $this->invtools_model->getResultadoExistencias($idcentros, $estados, $criterios, $descrip, $departamento, $linea, $proveedor, $marca, $modelo, $barcode, $xpos, $idproducto, $um, $precioventa);
                
                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "id" => $info->idproducto,
                            "producto" => $info->nombreProducto,
                            "sucursal" => $info->sucursal,
                            "linea" => $info->nameLinea,
                            "marca" => $info->marca,
                            "barcode" => $info->barcode,
                            "xpos" => $info->xpos,
                            "modelo" => $info->modelo,
                            "um" => $info->um,
                            "costounitario" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "cantidad" => $info->cantidad
                        );
                        
                        $i++;
                    }
                }
                
                $_SESSION['dataSourceConsulta'] = $informacion;
                
                $array = array(
                    "dataSource" => $dataSource,
                    "total" => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function generarConsultaExistencias(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $permite = 0;
                
                $this->load->model('user_model');
                $this->load->model('invtran_model');
                
                $derechos = $this->user_model->getDerechos();
                if($derechos!=""){
                    $pos = strpos($derechos, "costo");
                    if($pos !== false){
                        if($pos >= 0){
                            $permite=1;
                        }   
                    }
                }
                
                $this->data['permite_costo'] = $permite;
                $this->data['tipos_search'] = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $this->data['dataSource'] = $_SESSION['dataSourceConsulta'];
                $this->load->view('mantenimiento_consulta_existencias', $this->data);
            }
		}
		
		function generarConsultaExistenciasM($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);

				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
				$this->session->set_userdata($resultAppName);
				
				$this->load->model('user_model'); $this->load->model('compras_model');
                $this->load->model('invtran_model'); $this->load->model('producto_model');
                
                $permite = 0;
                $derechos = $this->user_model->getDerechos();
                if($derechos != ""){
                    $pos = strpos($derechos, "costo");
                    if($pos !== false){
                        if($pos >= 0){
                            $permite=1;
                        }   
                    }
                }
                
                $this->data['permite_costo'] = $permite;
                $this->data['lineas'] = $this->producto_model->viewLineas();
				$this->data['departamentos'] = $this->producto_model->viewDepartamentos();
				$this->data['tipos_search'] = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
				$this->data['proveedores'] = $this->compras_model->getListProveedores(1);
				$this->data['tipoProductos'] = $this->producto_model->getTipoProd();
                $this->data['medidas'] = $this->producto_model->verUM();
                $this->data['marcas'] = $this->producto_model->verMarca();
				
                $this->load->view('mantenimiento_consulta_existencias_m', $this->data);
            }
		}

		function generacionNuevoResultadoSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentros = $this->input->post('idcentros');
                $estados = $this->input->post('estados');
                $criterios = $this->input->post('criterios');
                $descrip = $this->input->post('descrip');
                $departamento = $this->input->post('departamento');
                $linea = $this->input->post('linea');
                $proveedor = $this->input->post('proveedor');
                $marca = $this->input->post('marca');
                $modelo = $this->input->post('modelo');
                $barcode = $this->input->post('barcode');
                $xpos = $this->input->post('xpos');
                $idproducto = $this->input->post('idproducto');
                $um = $this->input->post('um');
                $precioventa = $this->input->post('precioventa');
                $saldoproductos = $this->input->post('saldoproductos');
                $tiposProductos = $this->input->post('tiposProductos');
                
                $this->load->model('invtools_model');
                $informacion = $this->invtools_model->getResultadoExistenciasMod($idcentros, $estados, $criterios, $descrip, $departamento, $linea, $proveedor, $marca, $modelo, $barcode, $xpos, $idproducto, $um, $precioventa, $tiposProductos);
                
                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
						if($saldoproductos == 0){
							$dataSource[$i] = array(
								"id" => $info->idproducto,
								"producto" => $info->nombreProducto,
								"sucursal" => $info->sucursal,
								"linea" => $info->nameLinea,
								"marca" => $info->marca,
								"barcode" => $info->barcode,
								"idbatch" => $info->idbatch,
								"idbin" => $info->idbin,
								"xpos" => $info->xpos,
								"modelo" => $info->modelo,
								"um" => $info->um,
								"costounitario" => $info->costounitario,
								"precioventa" => $info->precioventa,
								"cantidad" => $info->cantidad
							);
							
							$i++;
						}else{
							if($info->cantidad > 0){
								$dataSource[$i] = array(
									"id" => $info->idproducto,
									"producto" => $info->nombreProducto,
									"sucursal" => $info->sucursal,
									"linea" => $info->nameLinea,
									"marca" => $info->marca,
									"barcode" => $info->barcode,
									"idbatch" => $info->idbatch,
									"idbin" => $info->idbin,
									"xpos" => $info->xpos,
									"modelo" => $info->modelo,
									"um" => $info->um,
									"costounitario" => $info->costounitario,
									"precioventa" => $info->precioventa,
									"cantidad" => $info->cantidad
								);
								
								$i++;	
							}
						}
                    }
                }
                
                $_SESSION['dataSourceConsulta'] = $informacion;
                
                $array = array(
                    "dataSource" => $dataSource,
                    "total" => $i
                );
                
                echo json_encode($array);
            }
		}
		
		function getListadoLineasFiltradas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				
			}
		}

		function getDisponibilidadProducto(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$opcion = $this->input->post('opcion');
				$idproducto = $this->input->post('idproducto');

				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->getDisponibilidadProducto($idproducto, $opcion);
				
				$i=0;
				$array = array();
				foreach($informacion as $info){
					$array[$i] = array(
						"descrip" => $info->descrip,
						"cantidad" => $info->cantidad * 1
					);

					$i++;
				}

				echo json_encode($array);
			}
		}

		function getEstadisticaProducto(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$opcion = $this->input->post('opcion');
				$idproducto = $this->input->post('idproducto');

				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->getEstadisticaProducto($idproducto, $opcion);
				
				$i=0;
				$array = array();
				foreach($informacion as $info){
					$array[$i] = array(
						"descrip" => $info->descrip,
						"cantidad" => $info->cantidad * 1
					);

					$i++;
				}

				echo json_encode($array);
			}
		}

		function controlDeCierres($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				$idclase = $this->configuracion_model->getProCentro($idApp);

				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
				$this->session->set_userdata($resultAppName);
				
				$this->data['idclase'] = $idclase;
				$this->load->view('mantenimiento_control_cierre', $this->data);
			}
		}

		function getInformacionControlDeCierres(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->getInformacionControlDeCierres();
				
				$i=0;
				$array = array();
				if($informacion != false){
					foreach($informacion as $info){
						$array[$i] = array(
							"ccontrol" => $info->ccontrol,
							"descrip" => $info->descrip,
							"estatus" => $info->estatus,
							"fecact" => $info->fecact,
							"fecha" => $info->fecha
						);

						$i++;
					}
				}

				echo json_encode($array);
			}
		}

		function generarNuevoControlDeCierre(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$fecha = $this->input->post('fecha');
				$notas = $this->input->post('notas');
				$descrip = $this->input->post('descrip');

				$this->load->model('invtools_model');
				$ccontrol = $this->invtools_model->generarNuevoControlDeCierre($fecha, $notas, $descrip);
				#$numCode = str_pad($ccontrol, 4, "0", STR_PAD_LEFT);

				$code100 = $this->invtools_model->getCreateTableInformation('tran_100');
				$code100k = $this->invtools_model->getCreateTableInformation('tran_100k');
				$code100c = $this->invtools_model->getCreateTableInformation('tran_100c');
				$code100z = $this->invtools_model->getCreateTableInformation('tran_100z');
				
				$this->invtools_model->replaceCreateTableInformation($code100, 'tran_100', 'temp_100');
				$this->invtools_model->replaceCreateTableInformation($code100k, 'tran_100k', 'temp_100k');
				$this->invtools_model->replaceCreateTableInformation($code100c, 'tran_100c', 'temp_100c');
				$this->invtools_model->replaceCreateTableInformation($code100z, 'tran_100z', 'temp_100z');

				echo json_encode($ccontrol);
			}
		}

		function detalleControlDeCierres($ccontrol, $idclase){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
                    'namePage' => 'Detalle ' . $this->session->userdata('appName')
                );
				$this->session->set_userdata($resultAppName);

				$this->load->model('invtools_model');
				$this->data['informacion'] = $this->invtools_model->informacionControlCierres($ccontrol);
				$this->data['idclase'] = $idclase;
				
				$this->load->view('mantenimiento_detalle_control_cierre', $this->data);
			}
		}

		function getControlDetalleCierre(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ccontrol = $this->input->post('ccontrol');
				
				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->getControlDetalleCierre($ccontrol);

				$i=0;
				$array = array();
				if($informacion != false){
					foreach($informacion as $info){
						if($info->estatus == 0){
							$estado = "Sin Procesar";
						}else{
							$estado = "Procesado";
						}

						$array[$i] = array(
							"idrec" => $info->idrec,
							"idcentro" => $info->idcentro,
							"descrip" => $info->descrip,
							"totrecs" => $info->totrecs,
							"prorecs" => $info->prorecs,
							"estado" => $estado,
							"estatus" => $info->estatus
						);

						$i++;
					}
				}

				echo json_encode($array);
			}
		}

		function getInformacionProductosControl(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');

				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->getInformacionProductosControl($idcentro);
				
				$array = array(
					"totalRegistros" => count($informacion),
					"dataSource" => $informacion
				);

				echo json_encode($array);
			}
		}

		function insertarProductosControlCierre(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
				$idclase = $this->input->post('idclase');
				$idcentro = $this->input->post('idcentro');
				$ccontrol = $this->input->post('ccontrol');
				$numitems = $this->input->post('numitems');
				$productSource = $this->input->post('productSource');
				
				$this->load->model('invtools_model'); $this->load->model('ventas_model');
				$trannum = $this->invtools_model->generarEncabezadoControlDeInventario($idcentro, $idclase, $ccontrol);
				$numProcesados = $this->invtools_model->generarDetalleControlDeInventario($trannum, $idcentro, $idclase, $ccontrol, $productSource);
				$this->ventas_model->callTotaliza100($trannum, 1);
				$this->invtools_model->updateProcesoCierreCentro($idrec, $numitems, $numProcesados);

				$informacion = $this->invtools_model->getControlDetalleCierre($ccontrol);

				$i=0;
				$array = array();
				if($informacion != false){
					foreach($informacion as $info){
						if($info->estatus == 0){
							$estado = "Sin Procesar";
						}else{
							$estado = "Procesado";
						}

						$array[$i] = array(
							"idrec" => $info->idrec,
							"idcentro" => $info->idcentro,
							"descrip" => $info->descrip,
							"totrecs" => $info->totrecs,
							"prorecs" => $info->prorecs,
							"estado" => $estado,
							"estatus" => $info->estatus
						);

						$i++;
					}
				}

				echo json_encode($array);
			}
		}

		function generarExcelControlCierre(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
				$idclase = $this->input->post('idclase');
				$idcentro = $this->input->post('idcentro');
				$ccontrol = $this->input->post('ccontrol');
				$numitems = $this->input->post('numitems');
				$productSource = $this->input->post('productSource');
				
				$this->load->model('invtools_model');
				$numProcesados = $this->invtools_model->generarExcelControlCierre($idcentro);
				$this->invtools_model->updateProcesoCierreCentro($idrec, $numitems, $numProcesados);

				$informacion = $this->invtools_model->getControlDetalleCierre($ccontrol);

				$i=0;
				$array = array();
				if($informacion != false){
					foreach($informacion as $info){
						if($info->estatus == 0){
							$estado = "Sin Procesar";
						}else{
							$estado = "Procesado";
						}

						$array[$i] = array(
							"idrec" => $info->idrec,
							"idcentro" => $info->idcentro,
							"descrip" => $info->descrip,
							"totrecs" => $info->totrecs,
							"prorecs" => $info->prorecs,
							"estado" => $estado,
							"estatus" => $info->estatus
						);

						$i++;
					}
				}

				echo json_encode($array);
			}
		}

		function getSucursalesFiltradas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				
				$this->load->model('sucursal_model');
                $infoSucursales = $this->sucursal_model->viewSucursalActiva();
                
                $i=0;
                $array = array();
                foreach($infoSucursales as $info){
					if($info->idcentro != $idcentro){
						$array[$i] = array(
							"id" => $info->idcentro,
							"descrip" => strtoupper(trim($info->descrip)),
							"grupo" => strtoupper(trim($info->grupo))
						);
						$i++;
					}
                }
                
                echo json_encode($array);
			}
		}

		function virtualizacionDeSucursal($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				$informacion = $this->configuracion_model->getProCentro($idApp);
				$id_clases = explode(",", $informacion);

				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
				$this->session->set_userdata($resultAppName);
				
				$this->data['traslado'] = $id_clases[0];
				$this->data['recepcion'] = $id_clases[1];
				$this->load->view('mantenimiento_virtualizacion', $this->data);
			}
		}

		function getInformacionControlVirtualizacion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->getInformacionControlVirtualizacion();
				
				$i=0;
				$array = array();
				if($informacion != false){
					foreach($informacion as $info){
						$array[$i] = array(
							"ccontrol" => $info->ccontrol,
							"descrip" => $info->descrip,
							"estatus" => $info->estatus,
							"fecact" => $info->fecact,
							"fecha" => $info->fecha
						);

						$i++;
					}
				}

				echo json_encode($array);
			}
		}

		function generarVirtualizacionDeSucursal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$fecha = $this->input->post('fecha');
				$notas = $this->input->post('notas');
				$descrip = $this->input->post('descrip');
				$idcentro = $this->input->post('idcentro');
				$idcentrod = $this->input->post('idcentrod');

				$this->load->model('invtools_model');
				$ccontrol = $this->invtools_model->generarNuevaVirtualizacionSucursal($idcentro, $idcentrod, $fecha, $notas, $descrip);
				
				echo json_encode($ccontrol);
			}
		}

		function detalleVirtualizacionSucursal($ccontrol, $traslado, $recepcion){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
                    'namePage' => 'Detalle ' . $this->session->userdata('appName')
                );
				$this->session->set_userdata($resultAppName);

				$this->data['traslado'] = $traslado;
				$this->data['recepcion'] = $recepcion;
				
				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->informacionVirtualizacion($ccontrol);
				
				foreach($informacion as $info){
					$idcentrod = $info->idcentrod;
				}

				$this->data['informacion'] = $informacion;
				$this->data['infoCajas'] = $this->invtools_model->informacionCajas($idcentrod);
				
				$this->load->view('mantenimiento_detalle_virtualizacion', $this->data);
			}
		}

		function validacionTransacciones(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$fecha = $this->input->post('fecha');
				$notas = $this->input->post('notas');
				$descrip = $this->input->post('descrip');
				$idcentro = $this->input->post('idcentro');
				$idcentrod = $this->input->post('idcentrod');

				$this->load->model('invtran_model');
				$this->load->model('tpedido_model'); $this->load->model('invtools_model');

                $validate = $this->invtran_model->validateInsertVirtualizacion($idcentro, 0);
                if($validate == true){

					$validate2 = $this->invtran_model->validateInsertAjusteTransacciones($idcentro, 0);
                    if($validate2 == true){
                        $validate2 = $this->tpedido_model->getCountListadoLotesPedidos($idcentro, 'PP');
                    }
                    
                    if($validate2 == true){
						$ccontrol = $this->invtools_model->generarNuevaVirtualizacionSucursal($idcentro, $idcentrod, $fecha, $notas, $descrip);
						
						$array = array(
							"ccontrol" => $ccontrol
						);
					}else{
						$infoPendientes = $this->invtran_model->getDatosTransaccionesPendientes($idcentro, 0);
                        
                        $i=0;
                        $datosPendientes = array();
                        
                        if($infoPendientes != false){
                            foreach($infoPendientes as $info){
                                $datosPendientes[$i] = array(
                                    "trannum" => $info->trannum,
                                    "agrupa" => $info->agrupa,
                                    "descrip" => $info->descrip,
                                    "fecha" => $info->fecha
                                );
                                
                                $i++;
                            }
                        }
                        
                        $infoPreparacion = $this->tpedido_model->getInformacionListadoLotesPedidos($idcentro, 'PP');
                        
                        if($infoPreparacion != false){
                            foreach($infoPreparacion as $info){
                                $datosPendientes[$i] = array(
                                    "trannum" => $info->trannum,
                                    "agrupa" => 'PP',
                                    "descrip" => 'Preparacion de Pedidos',
                                    "fecha" => $info->fecha
                                );
                                
                                $i++;
                            }
                        }
                        
						$array = array(
							"error" => 2,
							"datos" => $datosPendientes
						);
					}
                }else{
					$array = array(
						"error" => 0
					);
				}
				
				echo json_encode($array);
			}
		}

		function generarAnulacionTransaccion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$idcentro = $this->input->post('idcentro');

				$this->load->model('invtran_model');
				$this->load->model('tpedido_model'); $this->load->model('invtools_model');
				
				$this->invtools_model->generarAnulacionTransaccion($trannum, 9);
				$infoPendientes = $this->invtran_model->getDatosTransaccionesPendientes($idcentro, 0);
                        
				$i=0; $itemsPendientes=0;
				$datosPendientes = array();
				
				if($infoPendientes != false){
					foreach($infoPendientes as $info){
						$datosPendientes[$i] = array(
							"trannum" => $info->trannum,
							"agrupa" => $info->agrupa,
							"descrip" => $info->descrip,
							"fecha" => $info->fecha
						);
						
						$i++; $itemsPendientes++;
					}
				}
				
				$infoPreparacion = $this->tpedido_model->getInformacionListadoLotesPedidos($idcentro, 'PP');
				
				if($infoPreparacion != false){
					foreach($infoPreparacion as $info){
						$datosPendientes[$i] = array(
							"trannum" => $info->trannum,
							"agrupa" => 'PP',
							"descrip" => 'Preparacion de Pedidos',
							"fecha" => $info->fecha
						);
						
						$i++; $itemsPendientes++;
					}
				}
				
				$array = array(
					"error" => 2,
					"datos" => $datosPendientes,
					"itemsPendientes" => $itemsPendientes
				);

				echo json_encode($array);
			}
		}

		function getInformacionDetalleCajas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ccontrol = $this->input->post('ccontrol');

				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->getInformacionDetalleCajas($ccontrol, 1);
				
				echo json_encode($informacion);
			}
		}

		function getInformacionDetalleUsuarios(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ccontrol = $this->input->post('ccontrol');

				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->getInformacionDetalleUsuarios($ccontrol, 2);
				
				echo json_encode($informacion);
			}
		}

		function updateInformacionDetalleCajas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
				$idcajad = $this->input->post('idcajad');
				$ccontrol = $this->input->post('ccontrol');

				$this->load->model('invtools_model');
				$this->invtools_model->updateInformacionDetalleCajas($idrec, $idcajad);
				$informacion = $this->invtools_model->getInformacionDetalleCajas($ccontrol, 1);
				
				echo json_encode($informacion);
			}
		}

		function getInformacionDetalleInventario(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');

				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->getInformacionDetalleInventario($idcentro);

				echo json_encode($informacion);
			}
		}

		function updateInformacionDetalleUsuarios(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
				$estado = $this->input->post('estado');
				$ccontrol = $this->input->post('ccontrol');

				$this->load->model('invtools_model');
				$this->invtools_model->updateInformacionDetalleUsuarios($idrec, $estado);
				$informacion = $this->invtools_model->getInformacionDetalleUsuarios($ccontrol, 2);
				
				echo json_encode($informacion);
			}
		}

		function getInformacionDetalleVariables(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ccontrol = $this->input->post('ccontrol');

				$this->load->model('invtools_model');
				$informacion = $this->invtools_model->getInformacionDetalleVariables($ccontrol, 3);
				
				echo json_encode($informacion);
			}
		}

		function updateInformacionVariable(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
				$estado = $this->input->post('estado');
				$ccontrol = $this->input->post('ccontrol');

				$this->load->model('invtools_model');
				$this->invtools_model->updateInformacionVariable($idrec, $estado);
				$informacion = $this->invtools_model->getInformacionDetalleVariables($ccontrol, 3);
				
				echo json_encode($informacion);
			}
		}

		function getInformacionTotalResumen(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$ccontrol = $this->input->post('ccontrol');

				$this->load->model('invtools_model');
				$totalCajas = $this->invtools_model->getTotalResumenCajas($ccontrol);
				$totalUsuarios = $this->invtools_model->getTotalResumenUsuarios($ccontrol);
				$totalVariables = $this->invtools_model->getTotalResumenVariables($ccontrol);

				$array = array(
					"totalCajas" => $totalCajas,
					"totalUsuarios" => $totalUsuarios,
					"totalVariables" => $totalVariables
				);

				echo json_encode($array);
			}
		}

		function procesarVirtualizacionSucursal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$fecha = $this->input->post('fecha');
				$ccontrol = $this->input->post('ccontrol');
				$idcentro = $this->input->post('idcentro');
				$idcentrod = $this->input->post('idcentrod');
				$traslado = $this->input->post('traslado');
				$recepcion = $this->input->post('recepcion');

				$this->load->model('invtools_model');
				$trannum = $this->invtools_model->generarTrannumTraslado($traslado, $idcentro, $idcentrod, $fecha);
				//$

				//$informacion = $this->invtools_model->
			}
		}

		//FORMATO IMPORTACION MINIMO, MAXIMO
        function plantillaImportacionRegistros(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                
                // require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                $objPHPExcel = new Spreadsheet();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Formato Importador de Movimientos") // Titulo
                ->setSubject("Formato Importador de Movimientos") //Asunto
                ->setDescription("Formato Importador de Movimientos") //Descripción
                ->setKeywords("Formato Importador de Movimientos") //Etiquetas
                ->setCategory("Formato Importador de Movimientos"); //Categorias

                $objPHPExcel->setActiveSheetIndex(0);
                $default_border = array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => array('argb' => "000")
                );

                $style_header_rojo = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ),
                    'borders' => [
						'allBorders' => [
							'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							'color' => ['argb' => '000000'],
						],
					],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'd32f2f',
						],
                    ),
                    'font' => array(
                        'bold' => true,
						'color' => array('rgb' => 'FFFFFF'), 
                        'size' => 9,
                        'name' => 'Arial'
                    )
                );

                $style_header_azul= array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ),
                    'borders' => [
						'allBorders' => [
							'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							'color' => ['argb' => '000000'],
						],
					],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => '004ba0',
						],
                    ),
                    'font' => array(
                        'bold' => true,
						'color' => array('rgb' => 'FFFFFF'), 
                        'size' => 9,
                        'name' => 'Arial'
                    )
                );
                $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(20);

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(25); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(18);

                $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'N° Correlativo Linea');
                $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'idCentro');
                $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'idProducto');
                $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Punto_reorden');
                $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Cantidad_reorden');

                $objPHPExcel->getActiveSheet()->getStyle("A1:E1")->applyFromArray( $style_header_azul );
                //$objPHPExcel->getActiveSheet()->getStyle("C1:D1")->applyFromArray( $style_header_rojo );

                $objPHPExcel->getActiveSheet()->getStyle('A:A')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('B:B')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('C:C')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('D:D')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );
                $objPHPExcel->getActiveSheet()->getStyle('E:E')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER );

                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="Plantilla_Importacion_MinimosMaximos.xlsx"');
                header('Cache-Control: max-age=0');
                $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
                $objWriter->save('php://output');
            }
        }

        function validarArchivoImportacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('invtools_model');

                try {
                    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);                    
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }

				$idSucursal = $this->input->post('idSucursal');
                
                $objPHPExcel->setActiveSheetIndex(0); 
                $sheet         = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow    = $sheet->getHighestRow();
                $highestColumn = $sheet->getHighestColumn();

                $resultado = [];
                $totalErrores = 0;
                $lineaActual = 1;
                $mensajeResultado = "";

                //arrays para validacion de campos unicos
                $descripsIngresados = [];
                $idsIngresados = [];
                $xposIngresados = [];
                $barcodesIngresados = [];

                //si el archivo ocupado no posee productos
                if($highestRow <= 1){
                    $totalErrores = 1;
                    $mensajeResultado = "¡Error! El archivo ocupado no posee registros para importar.";

                    echo json_encode(["resultado"=>$resultado, "totalErrores"=>$totalErrores, "mensajeResultado"=>$mensajeResultado]);//*/
                    return false;
                }

                #   VALIDACION PRIMARIA
                for ($row = 2; $row <= $highestRow; $row++) {
                    $hasError = false;
                    $mensajeError = "";

                    $rowData = $sheet->rangeToArray('A' . $row . ':E' . $row,NULL,TRUE,FALSE);
                    $rowData = $rowData[0];


                    $reg = array(
						"numLinea" => trim($rowData[0]),
                        "idcentro" => trim($rowData[1]),
                        "idproducto" => trim($rowData[2]),
						"reorder_point" => trim($rowData[3]),
                        "reorder_qty" => trim($rowData[4]),
						"msjerror" => "",
                    );

                    // si no se han ingresado los campos requeridos se salta al siguiente producto
                    if(!($reg["idcentro"] && $reg["idproducto"] && $reg["reorder_point"] && $reg["reorder_qty"]!= null)){
                        $mensajeError .= "-Uno o más datos requeridos no han sido ingresados.\n";
                        $totalErrores++;

                        $reg["msjerror"] = $mensajeError;
                        $resultado[] = $reg;

                        continue;
                    }

					// valida si el idcentro coincide con el id de la sucursal en la que se encuetra
					//if($reg["idcentro"] != $idSucursal){
						//$mensajeError .= "-Código de centro incorrecto.\n";
                        //$totalErrores++;

                        //$reg["msjerror"] = $mensajeError;
                        //$resultado[] = $reg;

						//continue;
					//}
					// NUMERO LINEA CORRELATIVO
						if($reg['numLinea'] == ''){
							$mensajeError .= "-El número correlativo de línea esta vacío.\n";
                            $totalErrores++;
						}
					//

                    // CODIGO CENTRO
                        //realiza las validaciones solo si se ha ingresado algo
                        if($reg['idcentro']){
                            //codigo existe
                            //$existe = $this->invtools_model->existeCentroID($reg["idcentro"]);
                            //if(!$existe)  {
                                //$mensajeError .= "-El código de centro ingresado no existe.\n";
                                //$totalErrores++;
                            //descripcion ya existe en el archivo
                            //}else if(in_array($reg["idcentro"], $idcentroIngresados)){
                                //$mensajeError .= "-El código de centro ya existe en el archivo.\n";
                                //$totalErrores++;
                            //}else{
                                $idcentroIngresados[] = $reg["idcentro"];
                            //}
                        }
                       
                    //

                    // CODIGO PRO
                        //realiza las validaciones solo si se ha ingresado algo
                        if($reg['idproducto']){
                            //codigo existe
                            //$existe = $this->invtools_model->existeProductoID($reg["idproducto"]);
                            //if(!$existe)  {
                                //$mensajeError .= "-El código de producto ingresado no existe.\n";
                                //$totalErrores++;
                            //descripcion ya existe en el archivo
                            //}else if(in_array($reg["idproducto"], $idproductoIngresados)){
                                //$mensajeError .= "-El código del producto ya existe en el archivo.\n";
                                //$totalErrores++;
                            //}else{
                                $idproductoIngresados[] = $reg["idproducto"];
                            //}
                        }
                       
                    //
					
                    // PUNTO REORDEN
                        //realiza las validaciones solo si se ha ingresado algo
                        if($reg["reorder_point"]){
                            //reorder_point ya existe
                            //$existe = $this->producto_model->existeProductoXpos($reg["reorder_point"]);
                            //if($existe){
                                //$mensajeError .= "-La referencia reorder_point ya fue previamente registrada en el sistema.\n";
                                //$totalErrores++;
                            //reorder_point ya existe en el archivo
                            //}else if(in_array($reg["reorder_point"], $reorder_pointIngresados)){
                                //$mensajeError .= "-La referencia reorder_point ya existe en el archivo.\n";
                                //$totalErrores++;
                            //}else{
                                $reorder_pointIngresados[] = $reg["reorder_point"];
                            //}
                        }
                    //
                    
                    // CANTIDAD REORDEN
                        //realiza las validaciones solo si se ha ingresado algo
                        if($reg["reorder_qty"]){
                            //reorder_qty ya existe
                            //$existe = $this->producto_model->existeProductoBarcode($reg["reorder_qty"]);
                            //if($existe){
                                //$mensajeError .= "-El reorder_qty ya fue previamente registrado en el sistema.\n";
                                //$totalErrores++;
                                //cod barras ya existe en el archivo
                            //}else if(in_array($reg["reorder_qty"], $reorder_qtyIngresados)){
                                //$mensajeError .= "-El reorder_qty ya existe en el archivo.\n";
                                //$totalErrores++;
                            //}else{
                                $reorder_qtyIngresados[] = $reg["reorder_qty"];
                            //}
                        } 
                    //
                    
                    $reg["msjerror"] = $mensajeError;
                    $resultado[] = $reg;

                    $lineaActual++;
                }

                if($totalErrores == 0){
                    $mensajeResultado = "¡Todos los registros se han validado exitosamente!";
                }else{
					//$mensajeResultado = "¡Uno o más registros presentan errores de validación!";
					$mensajeResultado = $mensajeError;
				}
                    
                echo json_encode(["resultado"=>$resultado, "totalErrores"=>$totalErrores, "mensajeResultado"=>$mensajeResultado]);//*/
            }
        }

        function importarArchivoImportacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('invtools_model');

                try {
                    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);                    
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                
                $objPHPExcel->setActiveSheetIndex(0); 
                $sheet         = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow    = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();

                $registros = [];
                #   VALIDACION PRIMARIA
                for ($row = 2; $row <= $highestRow; $row++) {
                    $hasError = false;
                    $mensajeError = "";

                    $rowData = $sheet->rangeToArray('A' . $row . ':E' . $row,NULL,TRUE,FALSE);
                    $rowData = $rowData[0];

                    //se arma el array con la info de los registros
                    $reg = array(
                        "idcentro" => trim($rowData[1]),
                        "idproducto" => trim($rowData[2]),
						"reorder_point" => trim($rowData[3]),
                        "reorder_qty" => trim($rowData[4]),
						"msjerror" => "",
                    );
                    $reg = array_filter($reg);
                    $registros[] = $reg;
                }
                //var_dump($registros);
                $resultado = $this->invtools_model->importarArrayProductos($registros);
                $mensaje = "";
                if($resultado){
					//print_r($resultado);
                    $mensaje = "!Los registros han sido importados exitosamente!";
                }else{
                    $mensaje = "¡Error! Ocurrió un problema inesperado al subir el archivo. No se importó ningún registro.";
                }
                    
                echo json_encode(["resultado"=>$resultado['esValido'], "mensaje"=> $mensaje]);//*/
            }
        }
	}
?>