<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Inicializacion extends CI_Controller {
        
        function __construct(){
            parent::__construct();
        }
         
        function setInit(){
            $this->load->model('inicializacion_model');
            $data['tablas'] = $this->inicializacion_model->getTables();
            $this->load->view('set_inicializacion', $data);
        }
        
        function vaciarDatos(){
            if ($this->input->post()) {
            $tablesName = $this->input->post("tablasNam");
            $this->load->model('inicializacion_model');
            $this->inicializacion_model->truncateTables($tablesName);
            redirect('inicializacion/setInit');
                 } else {
                $this->setInit();
            }
        }   
        
        function exportarExcel(){
            $tablesName = $this->input->post("tablasNam");
            $this->load->model('inicializacion_model');
            $this->inicializacion_model->exportExcel($tablesName);
        }
        
        function exportarSQL_Data(){
            $tablesName = $this->input->post("tablasNam");
            $this->load->model('inicializacion_model');
            $this->inicializacion_model->exportSQL_Data($tablesName);
        }
        
        function exportarSQL(){
            $tablesName = $this->input->post("tablasNam");
            $this->load->model('inicializacion_model');
            $this->inicializacion_model->exportSQL($tablesName);
        }
        
        function exportarData(){
            $tablesName = $this->input->post("tablasNam");
            $this->load->model('inicializacion_model');
            $this->inicializacion_model->exportData($tablesName);
        }
        
        function pdfTable($tableName){
            $this->load->model('inicializacion_model');
            $tableStr = $this->inicializacion_model->getTableStr($tableName);
            $tableComent = $this->inicializacion_model->getTableComent($tableName);
            
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'Letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas, Xpos Online');
            $pdf->SetTitle('Estructura de la Tabla '.strtoupper($tableName));
            $pdf->SetSubject('Estructura Tabla');
            
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->SetFont('helvetica', '', 9, '', true);
            
            $pdf->AddPage();
            $tableHTML = '<img height="50px" width="200px" src="'.base_url().'img/LogoVS.png">';
            $tableHTML .= '<h2 style="font-style: normal;">Estructura de la Tabla <strong style="color:#2C82C9;">'.strtoupper($tableName).'</strong></h2>';
            $tableHTML .= '<h4 style="">'.strtoupper($tableComent).'</h4>';
            $tableHTML .= '<table>';
            $tableHTML .= '<thead><tr style="background-color:#1967be; color:white;">';
            $tableHTML .= '<th style="width:10%; border-left-style: solid; border-bottom-style:solid; border-color: black;"><br><br>Posicion</th>';
            $tableHTML .= '<th style="width:30%; border-left-style: solid; border-bottom-style:solid; border-color: black;"><br><br>Campo</th>';
            $tableHTML .= '<th style="width:30%; border-left-style: solid; border-bottom-style:solid; border-color: black;"><br><br>Tipo de Dato</th>';
            $tableHTML .= '<th style="width:30%; border-left-style: solid; border-right-style: solid; border-bottom-style:solid; border-color: black;"><br><br>Comentarios</th></tr></thead><tbody>';
            
            foreach($tableStr as $columData){
                $tableHTML .= '<tr>';
                $tableHTML .= '<td style="width:10%; border-left-style: solid; border-bottom-style:solid;"><h5><br />'.$columData->ORDINAL_POSITION.'</h5></td>';
                $tableHTML .= '<td style="width:30%; border-left-style: solid; border-bottom-style:solid; text-align:left;"><h5><br />&nbsp;&nbsp;&nbsp;&nbsp;'.$columData->COLUMN_NAME.'</h5></td>';
                $tableHTML .= '<td style="width:30%; border-left-style: solid; border-bottom-style:solid;"><h5><br />'.$columData->COLUMN_TYPE.'</h5></td>';
                $tableHTML .= '<td style="width:30%; border-left-style: solid; border-right-style: solid; border-bottom-style:solid;"><h5><br />'.$columData->COLUMN_COMMENT.'</h5></td>';
                $tableHTML .= '</tr>';
            }
            $tableHTML .= '</tbody></table>';
            
            $html = $tableHTML;
            
            $estilos = '
            <style type="text/css">
                th{
                    text-align: center;
                    font-weight: bold;
                    border-style: solid;
                    height: 40px;
                }
            
                td{
                    text-align: center;
                    height: 25px;
                    border-color: black;
                }
                
                thead{
                    border-style: solid;
                    border-color: black;
                }
                
                h5{
                    font-style: normal;
                }
            </style>';

            $pdf->writeHTML($estilos.$html, true, 0, false, false, 0);
            $nombre_archivo = utf8_decode("Prueba.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }
    }
?>