<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Ims extends CI_Controller {
        
        function __construct(){
            parent::__construct();
        }
        function highlight_array($array, $name = 'var') {
            highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
        }

        function moduloIMS($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ims_model');
                $this->data['modulos'] = $this->ims_model->getModulos();
                $this->data['deptos'] = $this->ims_model->getDeptos();
                $this->data['fases'] = $this->ims_model->getFases();

                
                $this->load->view('mantenimiento_ims', $this->data); 
            }
        }

        function getProcesos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $valorModulo = $this->input->post('modulo');

                $this->load->model('ims_model');
                $datos = $this->ims_model->getProcesos($valorModulo);
                
                echo json_encode($datos);
            }
        }

        function adicionarProceso(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $modulo = $this->input->post('modulo');
                $fase = $this->input->post('fase');
                $descrip = $this->input->post('descrip');
                $depto = $this->input->post('depto');
                $tipo = $this->input->post('tipo');
                $this->load->model('ims_model');

                $valido = true;
                $mensaje = "";

                if($modulo == "" || $modulo == null){
                    $valido = false;
                    $mensaje = "¡Error! El módulo del proceso es requerido.";
                }elseif($fase == "" || $fase == null){
                    $valido = false;
                    $mensaje = "¡Error! La fase del proceso es requerida.";
                }elseif($descrip == "" || $descrip == null){
                    $valido = false;
                    $mensaje = "¡Error! La descripción del proceso es requerida.";
                }elseif($depto == "" || $depto == null){
                    $valido = false;
                    $mensaje = "¡Error! Es necesario elegir al menos un departamento del proceso.";
                }
                elseif( $this->ims_model->validarExisteProceso($modulo, $fase, $descrip, $depto, $tipo)){
                    $valido = false;
                    $mensaje = "¡Error! Ya existe un proceso con esos datos.";
                }

                if($valido){
                    $valido = $this->ims_model->adicionarProceso($modulo, $fase, $descrip, $depto, $tipo);

                    if($valido){
                        $mensaje = "Se ha adicionado el proceso con exito";
                    }else{
                        $mensaje = "Hubo un error al adicionar el proceso.";

                    }
                }
                
                echo json_encode(["valido"=>$valido, "mensaje"=>$mensaje]);
            }
        }

        function modificarProceso(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idproceso = $this->input->post('idproceso');
                $modulo = $this->input->post('modulo');
                $fase = $this->input->post('fase');
                $descrip = $this->input->post('descrip');
                $depto = $this->input->post('depto');
                $tipo = $this->input->post('tipo');
                $estado = $this->input->post('estado');
                $contenido = $this->input->post('contenido');
                $enlaces = $this->input->post('enlaces');

                $this->load->model('ims_model');

                $valido = true;
                $mensaje = "";

                if($modulo == "" || $modulo == null){
                    $valido = false;
                    $mensaje = "¡Error! El módulo del proceso es requerido.";
                }elseif($fase == "" || $fase == null){
                    $valido = false;
                    $mensaje = "¡Error! La fase del proceso es requerida.";
                }elseif($descrip == "" || $descrip == null){
                    $valido = false;
                    $mensaje = "¡Error! La descripción del proceso es requerida.";
                }elseif($depto == "" || $depto == null){
                    $valido = false;
                    $mensaje = "¡Error! Es necesario elegir al menos un departamento del proceso.";
                }
                elseif($estado == "" || $estado == null){
                    $valido = false;
                    $mensaje = "¡Error! El estado del proceso es requerido.";
                }
                elseif( $this->ims_model->validarExisteProceso($idproceso, $modulo, $fase, $descrip, $depto, $tipo) ){
                    $valido = false;
                    $mensaje = "¡Error! Ya existe un proceso con esos datos.";
                }

                if($valido){

                    if($estado){
                        $estado = 1;
                    }else{
                        $estado = 0;
                    }

                    $valido = $this->ims_model->modificarProceso($idproceso, $modulo, $fase, $descrip, $depto, $tipo, $estado, $contenido, $enlaces);

                    if($valido){
                        $mensaje = "¡Se ha adicionado el proceso con exito!";
                    }else{
                        $mensaje = "Hubo un error al adicionar el proceso.";
                    }
                }
                
                echo json_encode(["valido"=>$valido, "mensaje"=>$mensaje]);
            }
        }

        function reporteIMS($idmodulo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle("Orden de Producción");
                $pdf->SetSubject("Orden de Producción");

                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 6, '', true);
                $pdf->SetAutoPageBreak(TRUE, 5);
              
                $inicioY = 16;

                $this->load->model('ims_model');
                $this->load->model('variable_model');

                $modulo = $this->variable_model->callRegistro($idmodulo);
                $procesos = $this->ims_model->getProcesos($modulo[0]->descripcion);    

                $header = '<table style="width:100%; padding:0;">';
                $header .= '<tr>';
                $header .= '<td style="text-align: center; width: 30%; padding: 0; font-weight: bold"></td>';
                $header .= '<td style="text-align: center; width: 40%; padding: 0; font-weight: bold">'.$modulo[0]->descripcion.'</td>';
                $header .= '<td style="text-align: right; width: 30%; padding: 0; font-weight: bold; font-size: 20px"></td>';
                $header .= '</tr>';
                $header .= '</table>';

                $pdf->SetPrintHeader(true);
                $pdf->SetMargins(8, $inicioY, 8, true);
                $pdf->setHtmlHeader($header);

                
                $tablaProductos = '
                    <table style="width:100%; border:1px solid black;">
                ';
                
                // DESGLOSE PRODUCTOS
                

                $fases = array_column($procesos, 'fase');
                array_multisort($fases, SORT_ASC, $procesos);

                //$this->highlight_array($procesos);
            
                $faseActual = "¿¿??¿¿??";
                if($procesos){
                    foreach($procesos as $pro){
                        if($faseActual != $pro['fase']){
                            $faseActual = $pro['fase'];
                            $tablaProductos .= '
                            <tr style="line-height: 4mm; font-size: 10px; ">
                                <td colspan = 2  style="width: 100%; text-align: center; font-weight: bold; border: 1px solid black; line-height: 8mm">Fase: '.$faseActual.'</td>
                            </tr>';
                            
                        }

                        $html = trim(html_entity_decode($pro['gohtml']));
                        //var_dump($html);

                        $tablaProductos .= '
                            <tr style="line-height: 4mm; font-size: 9px; ">
                                <td style="width: 50%; text-align: justify; border-bottom: 1px solid black;  line-height: 6mm">'.$pro['descrip'].'</td>
                                <td style="width: 50%; text-align: right; border-bottom: 1px solid black; line-height: 6mm">Departamentos: '.$pro['deptos'].'</td>

                            </tr>
                            <tr style="line-height: 4mm; font-size: 8px; ">
                                <td style="width: 100%; text-align: justify; border-bottom: 1px solid black;">'.$html.' </td>

                            </tr>';
                    }
                }
               
                
                $tablaProductos .= '</table>';
                //$this->highlight_array($html);
                //$this->highlight_array($tablaProductos);


                
                //$contenido = $tablaInfo.$tablaProductos;
                //$contenido = $tablaInfo.$tablaProductos;

                $pdf->addPage('P', 'LETTER');
                $pdf->SetY( $inicioY );            
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');       
                
                $nombre_archivo = utf8_decode("Reporte_IMS.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
    }
?>