<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

    require 'vendor/autoload.php';
            
    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
    
	class Gerencia extends CI_Controller{
		
        function __construct(){
            parent::__construct();
            date_default_timezone_set('America/El_Salvador');
        }
        private $clave = '$EgGa8466-2$/';
        private function validatePermiso() {
            $permiso = true;
            if ($this->session->userdata('logueado2') == FALSE || $this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || !$permiso) redirect('CerrarSesion');
            else return true;
        }
        function usuarios($idApp){
            if($this->validatePermiso()) {
                date_default_timezone_set('America/El_Salvador');
				$controlador = $this->uri->segment(1);
				$funcion = $this->uri->segment(2);
				$control_app = strtolower($controlador);
				
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $result = $this->configuracion_model->confirmarAccesoApp($idApp);
                $result == true ?: redirect('CerrarSesion');

				$appName = $this->configuracion_model->getAppName($idApp);
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
					'controlapp' => $control_app
                );
				$this->session->set_userdata($resultAppName);
				//$this->data['direccion'] = $controlador.'/'.$funcion;//
				$direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['factual'] = date_create()->format('Y-m-d');
				$this->load->view('gerencia_mantenimiento_usuario', $this->data);
			}
		}
        #   MULTIPLES OPCIONES
        public function multiOpciones()
        {
            if($this->validatePermiso()) {
                $this->load->model('gerencia_model');
                $this->load->model('user_model');

                $opcion = (int)$this->input->post('opcion');
                switch ($opcion) {
                    case -1:#	GET USUARIOS
                        $Datos = $this->conversion(-1, ((int)$this->input->post('estadoUser')));
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case 1:#	SET USUARIO
                        date_default_timezone_set('America/El_Salvador');
                        $conteo = (int)$this->input->post("conteo");
                        $sen = false;
                        $error = '';
                        if ($conteo > 0) {
                            $size = $_FILES['Archivo']['size'];
                            $ext = $_FILES['Archivo']['name'];
                            $nombrei = $this->conversion(1, [
                                'extension' => pathinfo($ext, PATHINFO_EXTENSION)
                            ]).'.'.pathinfo($ext, PATHINFO_EXTENSION);
                            $config['upload_path']= "img_cuentas/".$this->session->userdata('diraccount')."/";
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "gif|jpg|jpeg|png";
                            $config['file_name'] = $nombrei;
                            $config['max_size'] = 200;
                            $this->load->library('upload',$config);
                            if ($this->upload->do_upload('Archivo')) $sen = true;
                            else {
                                $sen = false;
                                $error = $this->upload->display_errors();
                                if (($size / 1024) > 200) $error = 'sizeImagen';
                            }
                        } else {
                            $nombrei = '';
                            $sen = true;
                        }
                        if ($sen) {
                            $correo = trim($this->input->post('correo'));
                            $usuario = trim($this->input->post('usuario'));
                            $contra = trim($this->input->post('password'));
                            $contra = md5($this->clave.$contra);
                            $estado = (int)$this->input->post('estado');
                            $data = array(
                                'descrip' => trim($this->input->post('nombre')),
                                'username' => $usuario,
                                'password' => $contra,
                                'idaccount' => $this->session->userdata('idaccount'),
                                'issuedate' => $this->input->post('finicial'),
                                'duedate' => $this->input->post('ffinal'),
                                //'lastlogin' => '',
                                'profile' => (int)$this->input->post('perfil'),
                                'derechos' => trim($this->input->post('derechos')),
                                'idcentro' => (int)$this->input->post('sucursal'),
                                'idcaja' => (int)$this->input->post('caja'),
                                'idcps' => (int)$this->input->post('empleado'),
                                'menug' => 0,
                                'telefonos' => '',
                                'correo1' => $correo,
                                'correo2' => '',
                                'estado' => $estado,
                                'imagen' => $nombrei,
                                'notas' => trim($this->input->post('notas')),
                                'whodidit' => $this->session->userdata('iduser'),
                                'ingresa' => date_create()->format('Y-m-d H:i:s'),
                            );
                            $ID = $this->gerencia_model->multiOpciones(7, $data);
                            $action = "Registro de usuario";
						    $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Campo</td>
                                                <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Iduser</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$ID.'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Descrip</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['descrip'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Username</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$usuario.'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Issuedate</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['issuedate'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Duedate</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['duedate'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Profile</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['profile'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Derechos</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['derechos'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Idcentro</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['idcentro'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Idcaja</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['idcaja'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Idcps</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['idcps'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Correo</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['correo1'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Estado</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['estado'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Notas</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['notas'].'</td>
                                            </tr>';
						    $values .= "</tabla>";

						    $this->user_model->auditoriaUsuarios($ID,$action,$values);

                            if ($ID) {
                                $this->conversion(2, [
                                    'opcion' => 0,
                                    'ID' => $ID,
                                    'aplicaciones' => trim($this->input->post('aplicaciones'))
                                ]);

                                if(trim($this->input->post('aplicaciones')) != ""){
                                    $permisosArray = $this->user_model->getUsersAppsHistorial(trim($this->input->post('aplicaciones')));
                                    $action = "Asignación de Permisos";
                                    $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Campo</td>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor</td>
                                                    </tr>';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px">Núm. de Permisos</td>
                                                        <td style="border: 1px solid black; padding: 5px">'.$permisosArray['count'].'</td>
                                                    </tr>';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px">Permisos</td>
                                                        <td style="border: 1px solid black; padding: 5px">'.$permisosArray['resultado'].'</td>
                                                    </tr>';
                                    $values .= "</tabla>";
    
                                    $this->user_model->auditoriaUsuarios($ID,$action,$values);
                                }
                                $this->load->model('global_model');
                                $razon_social = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                                $nombre_comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                                $correo_inst = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                                
                                /*$this->load->library('email');
                                //$this->load->library('My_PHPMailer');
                                $this->email->from($correo_inst, $nombre_comercial);
                                $this->email->to($correo);
                                $this->email->subject("DATOS DE ACCESO");
                                $this->email->set_mailtype("html");
                                $body ="<h1>".$nombre_comercial."</h1>";
                                $body .= "<h2>Ahora tienes acceso a: <br> ".base_url()."</h2>";
                                $body .= "<h3>Número de Cuenta: ".$this->session->userdata('idaccount')."</h3>";
                                $body .= "<h3>Usuario: ".$usuario."</h3>";
                                $body .= "<h3>Contraseña: ".$contra."</h3>";
                                $this->email->message($body);
                                $tipo = ($this->email->send()) ? 0 : 1;//*/
                                $body ="<h1>".$nombre_comercial."</h1>";
                                $body .= "<h2>Ahora tienes acceso a: <br> ".base_url()."</h2>";
                                $body .= "<h3>Número de Cuenta: ".$this->session->userdata('idaccount')."</h3>";
                                $body .= "<h3>Usuario: ".$usuario."</h3>";
                                $body .= "<h3>Contraseña: ".$contra."</h3>";
                                $tipo = ($this->conversion(3, [
                                    'correoOrigen' => $correo_inst,
                                    'nombre' => $nombre_comercial,
                                    'correoDestino' => $correo,
                                    'asunto' => 'DATOS DE ACCESO',
                                    'mensaje' => $body
                                ])) ? 0 : 1;

                                $Datos = $this->conversion(-1, ((int)$this->input->post('estadoUser')));
                                $datA[] = array('valido' => true, 'datos' => $Datos, 'tipo' => $tipo);
                            } else {
                                if ($conteo > 0) {
                                    $path = "img_cuentas/".$this->session->userdata('diraccount')."/".$nombrei;
                                    unlink($path);
                                }
                                $datA[] = array('valido' => false, 'sen' => $sen, 'error' => '');
                            }
                        } else $datA[] = array('valido' => false, 'sen' => $sen, 'error' => $error);
                    break;
                    case 2:#	GET PERFFILES, EMPLEADOS, CAJAS, APLICACIONES
                        $perfiles = [];
                        $empleados = [];
                        $cajas = [];
                        $aplicaciones = [];
                        $datos = $this->gerencia_model->multiOpciones(1);
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                if ((int)$dato->valor_num != 1) {
                                    $perfiles [] = array(
                                        'ID' => (int)$dato->valor_num,
                                        'Name' => trim($dato->descripcion)
                                    );
                                }
                            }
                        }
                        $datos = $this->gerencia_model->multiOpciones(2);
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                $empleados[] = array(
                                    'ID' => $dato->idauxi,
                                    'Name' => trim($dato->descrip),
                                    'correo' => trim($dato->correo)
                                );
                            }
                        }
                        $datos = $this->gerencia_model->multiOpciones(3);
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $key => $dato) {
                                $cajas[] = array(
                                    'ID' => ($dato->idcaja != null) ? (int)$dato->idcaja : ($dato->idcentro.'.'.$key),
                                    'Name' => $dato->descrip,
                                    'idcentro' => (int)$dato->idcentro,
                                    'sucursal' => $dato->sucursal,
                                    'isc' => ($dato->idcaja != null) ? true : false
                                );
                            }
                        }
                        $datos = $this->gerencia_model->multiOpciones(4);
                        if ($datos->num_rows() > 0) {
                            $hijos = [];
                            $datos = $datos->result();
                            $nombre = $datos[0]->menu;
                            foreach ($datos as $key => $dato) {
                                if ($nombre != $dato->menu) {
                                    $aplicaciones[] = array(
                                        'ID' => ($key - 1).'_'.$datos[$key - 1]->idapp.'_'.count($hijos),
                                        'Name' => $datos[$key -1]->menu,
                                        'expanded' => false,
                                        'items' => $hijos,
                                    );
                                    $hijos = [];
                                    $nombre = $dato->menu;
                                }
                                $hijos[] = array(
                                    'ID' => $dato->idapp,//$key.'_'.$dato->idapp,
                                    'Name' => $dato->descrip,
                                    'code' => $dato->idapp
                                );
                            }
                            $aplicaciones[] = array(
                                'ID' => count($datos).'_'.$datos[count($datos) - 1]->idapp.'_'.count($hijos),
                                'Name' => $datos[count($datos) -1]->menu,
                                'expanded' => false,
                                'items' => $hijos,
                            );
                        }
                        $datA[] = array(
                            'valido' => true,
                            'perfiles' => $perfiles,
                            'empleados' => $empleados,
                            'cajas' => $cajas,
                            'aplicaciones' => $aplicaciones,
                        );
                        //print_r($this->session->userdata());
                    break;
                    case 3:#	UPDATE USUARIO
                        date_default_timezone_set('America/El_Salvador');
                        $conteo = (int)$this->input->post("conteo");
                        $ID = (int)$this->input->post('ID');
                        $dato = $this->gerencia_model->multiOpciones(8, $ID);
                        $sen = false;
                        $error = '';
                        if ($conteo > 0) {
                            $size = $_FILES['Archivo']['size'];
                            $ext = $_FILES['Archivo']['name'];

                            if (strlen(trim($dato->imagen)) > 0) $nombreold = explode(".", $dato->imagen)[0];
                            else $nombreold = $this->conversion(1, [
                                'extension' => pathinfo($ext, PATHINFO_EXTENSION)
                            ]);
                            $nombrei = $nombreold.".".pathinfo($ext, PATHINFO_EXTENSION);
                            $config['upload_path']= "img_cuentas/".$this->session->userdata('diraccount')."/";
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "gif|jpg|jpeg|png";
                            $config['file_name'] = '123'.$nombrei;
                            $config['max_size'] = 200;
                            $this->load->library('upload',$config);
                            if ($this->upload->do_upload('Archivo')) {
                                $a = $this->upload->data();
                                $sen = true;
                            } else {
                                $sen = false;
                                $error = $this->upload->display_errors();
                                if (($size / 1024) > 200) $error = 'sizeImagen';
                            }
                        } else {
                            $nombrei = $dato->imagen;
                            $sen = true;
                        }
                        if ($sen) {
                            $oldValues = $this->user_model->getDatosUsuario($ID);

                            $correo = trim($this->input->post('correo'));
                            $usuario = trim($this->input->post('usuario'));
                            $estado = (int)$this->input->post('estado');
                            $data = array(
                                'descrip' => trim($this->input->post('nombre')),
                                'username' => $usuario,
                                'issuedate' => $this->input->post('finicial'),
                                'duedate' => $this->input->post('ffinal'),
                                //'lastlogin' => '',
                                'profile' => (int)$this->input->post('perfil'),
                                'derechos' => trim($this->input->post('derechos')),
                                'idcentro' => (int)$this->input->post('sucursal'),
                                'idcaja' => (int)$this->input->post('caja'),
                                'idcps' => (int)$this->input->post('empleado'),
                                'correo1' => $correo,
                                'estado' => $estado,
                                'imagen' => $nombrei,
                                'notas' => trim($this->input->post('notas')),
                                'whodidit' => $this->session->userdata('iduser'),
                                'modifica' => date_create()->format('Y-m-d H:i:s'),
                            );
                            if ($this->gerencia_model->multiOpciones(9, [
                                'ID' => $ID,
                                'data' => $data
                            ])) {
                                if ($conteo > 0) {
                                    if (strlen(trim($dato->imagen)) > 0) {
                                        $path = "img_cuentas/".$this->session->userdata('diraccount')."/".trim($dato->imagen);
                                        if (file_exists($path)) unlink($path);
                                    }
                                    rename($a['full_path'],$a['file_path'].$nombrei);
                                }

                                $action = "Modificación de usuario";
							    $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Campo</td>
                                                    <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor Anterior</td>
                                                    <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor Nuevo</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Descrip</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['descrip'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['descrip'].'</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Username</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['username'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['username'].'</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Duedate</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['duedate'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['duedate'].'</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Profile</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['profile'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['profile'].'</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Derechos</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['derechos'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['derechos'].'</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Idcentro</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['idcentro'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['idcentro'].'</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Idcaja</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['idcaja'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['idcaja'].'</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Idcps</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['idcps'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['idcps'].'</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Correo</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['correo1'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['correo1'].'</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Estado</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['estado'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['estado'].'</td>
                                                </tr>';
                                    $values .= '<tr>
                                                    <td style="border: 1px solid black; padding: 5px">Notas</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$oldValues['notas'].'</td>
                                                    <td style="border: 1px solid black; padding: 5px">'.$data['notas'].'</td>
                                                    </tr>';
                                $values .= '</tabla>';

                                $this->user_model->auditoriaUsuarios($ID,$action,$values);
                                //Activacion/inactivacion de cuenta
                                if($oldValues['estado'] != $data['notas']){
                                    if($oldValues['estado'] == 1 && $data['estado'] == 0){
                                        $action = "Inactivación de cuenta";
                                        $this->user_model->auditoriaUsuarios($ID,$action,"");
                                    }

                                    if($oldValues['estado'] == 0 && $data['estado'] == 1){
                                        $action = "Activación de cuenta";
                                        $this->user_model->auditoriaUsuarios($ID,$action,"");
                                    }
                                }
 
                                if ($estado == 1) {
                                    //	
                                    if(trim($this->input->post('aplicaciones')) != ""){
                                        $permisosArray = $this->user_model->getUsersAppsHistorial(trim($this->input->post('aplicaciones')));
                                        $oldPermisosArray = $this->user_model->getUsersAppsHistorialById($ID);
    
                                        $action = "Modificación de permisos";
                                        $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                            $values .= '<tr>
                                                            <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor</td>
                                                            <td style="border: 1px solid black; padding: 5px; font-weight: bold;"># de Permisos</td>
                                                            <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Permisos</td>
                                                        </tr>';
                                            $values .= '<tr>
                                                            <td style="border: 1px solid black; padding: 5px">Valor Anterior</td>
                                                            <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['count'].'</td>
                                                            <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['resultado'].'</td>
                                                        </tr>';
                                            $values .= '<tr>
                                                            <td style="border: 1px solid black; padding: 5px">Valor Nuevo</td>
                                                            <td style="border: 1px solid black; padding: 5px">'.$permisosArray['count'].'</td>
                                                            <td style="border: 1px solid black; padding: 5px">'.$permisosArray['resultado'].'</td>
                                                        </tr>';
                                        $values .= "</tabla>";
        
                                        $this->user_model->auditoriaUsuarios($ID,$action,$values);
                                    }else{	//Se deshabilitan todos los permisos
                                        $oldPermisosArray = $this->user_model->getUsersAppsHistorialById($ID);
        
                                        $action = "Modificación de permisos";
                                        $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                            $values .= '<tr>
                                                            <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor</td>
                                                            <td style="border: 1px solid black; padding: 5px; font-weight: bold;"># de Permisos</td>
                                                            <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Permisos</td>
                                                        </tr>';
                                            $values .= '<tr>
                                                            <td style="border: 1px solid black; padding: 5px">Valor Anterior</td>
                                                            <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['count'].'</td>
                                                            <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['resultado'].'</td>
                                                        </tr>';
                                            $values .= '<tr>
                                                            <td style="border: 1px solid black; padding: 5px">Valor Nuevo</td>
                                                            <td style="border: 1px solid black; padding: 5px">0</td>
                                                            <td style="border: 1px solid black; padding: 5px">-</td>
                                                        </tr>';
                                        $values .= "</tabla>";
        
                                        $this->user_model->auditoriaUsuarios($ID,$action,$values);
                                    }
    
                                    $this->conversion(2, [
                                        'opcion' => 1,
                                        'ID' => $ID,
                                        'aplicaciones' => trim($this->input->post('aplicaciones'))
                                    ]);
    
                                } else{ 
    
                                    $oldPermisosArray = $this->user_model->getUsersAppsHistorialById($ID);
        
                                    $action = "Modificación de permisos";
                                    $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor</td>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;"># de Permisos</td>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Permisos</td>
                                                    </tr>';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px">Valor Anterior</td>
                                                        <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['count'].'</td>
                                                        <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['resultado'].'</td>
                                                    </tr>';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px">Valor Nuevo</td>
                                                        <td style="border: 1px solid black; padding: 5px">0</td>
                                                        <td style="border: 1px solid black; padding: 5px">-</td>
                                                    </tr>';
                                    $values .= "</tabla>";
        
                                    $this->user_model->auditoriaUsuarios($ID,$action,$values);
                                    $this->user_model->multiOpciones(11, $ID);
                                }

                                $Datos = $this->conversion(-1, ((int)$this->input->post('estadoUser')));
                                $datA[] = array('valido' => true, 'datos' => $Datos);
                            } else {
                                if ($conteo > 0) {
                                    $path = "img_cuentas/".$this->session->userdata('diraccount')."/123".$nombrei;
                                    unlink($path);
                                }
                                $datA[] = array('valido' => false, 'sen' => $sen, 'error' => '');
                            }
                        } else $datA[] = array('valido' => false, 'sen' => $sen, 'error' => $error);
                    break;
                    case 4:#	NUEVA CONTRASEÑA
                        date_default_timezone_set('America/El_Salvador');
                        $ID = (int)$this->input->post('ID');
                        if($ID == 2 && $this->session->userdata('iduser') != 1 && $this->session->userdata('iduser') != 2){
                            $datA[] = array('valido' => false);
                            echo json_encode($datA);
                            return null;
                        }
                        $dato = $this->gerencia_model->multiOpciones(8, $ID);
                        $contra = trim($this->input->post('password'));
                        $contra = md5($this->clave.$contra);
                        $data = array(
                            'password' => $contra,
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        if ($this->gerencia_model->multiOpciones(9, [
                            'ID' => $ID,
                            'data' => $data
                        ])){ 
                            $datA[] = array('valido' => true);                                
                            $this->user_model->auditoriaUsuarios($ID,"Reinicio de contraseña","");
                        }
                        else $datA[] = array('valido' => false);
                    break;
                    case 5:#   RESTRINGUIR
                        date_default_timezone_set('America/El_Salvador');
                        $ID = (int)$this->input->post('ID');
                        $dato = $this->gerencia_model->multiOpciones(8, $ID);

                        $derechos = (strlen(trim($dato->derechos)) == 0) ? 'restricted' : $dato->derechos.',restricted';
                        $data = array(
                            'derechos' => $derechos,
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        if ($this->gerencia_model->multiOpciones(9, [
                            'ID' => $ID,
                            'data' => $data
                        ])) {
                            $idaccount = $this->session->userdata('idaccount');
                            $nameempre = $this->session->userdata('descrip');

                            $consonants = array(",", " ", ".", "b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "ñ", "p", "q", "r", "s", "t", "v", "w", "x", "y", "z",
                                ",", " ", ".", "B", "C", "D", "F", "G", "H", "J", "K", "L", "M", "N", "Ñ", "P", "Q", "R", "S", "T", "V", "W", "X", "Y", "Z");
                            $infoEmpresa = str_replace($consonants, "", $nameempre);
                            $token = md5($idaccount.$infoEmpresa.$this->clave);

                            $Datos = $this->conversion(-1, ((int)$this->input->post('estadoUser')));
                            $datA[] = array('valido' => true, 'token' => $token, 'datos' => $Datos);
                        } else $datA[] = array('valido' => false);
                    break;
                    #   HORARIOS
                    case 6:#    GET HORARIOS
                        $Datos = $this->conversion(4);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case 7:#    GET SUCURSALES
                        $Datos = [];
                        $datos = $this->gerencia_model->multiOpciones(14);
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                $Datos[] = array(
                                    'ID' => $dato->idcentro,
                                    'Name' => trim($dato->descrip)
                                );
                            }
                        }
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case 8:#    UPDATE HORARIO
                        $ID = (int)$this->input->post('ID');
                        $IDPerfil = (int)$this->input->post('idperfil');
                        $restringir = (int)$this->input->post('restringir');
                        $permisocaja = (int)$this->input->post('permiso');
                        $data = array(
                            'dow1' => trim($this->input->post('domingo')),
                            'dow2' => trim($this->input->post('lunes')),
                            'dow3' => trim($this->input->post('martes')),
                            'dow4' => trim($this->input->post('miercoles')),
                            'dow5' => trim($this->input->post('jueves')),
                            'dow6' => trim($this->input->post('viernes')),
                            'dow7' => trim($this->input->post('sabado')),
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        
                        if ($this->gerencia_model->multiOpciones(16, ['ID' => $ID, 'data' => $data])) {
                            #   ACTUALIZAR VARIABLE PERFIL
                                $where = implode(' AND ', ['(nombre = "gv_profile")', '(valor_num = '.$IDPerfil.')']);
                                $filtro = $this->gerencia_model->multiOpciones(17, ['where' => $where])->filtro;
        
                                if (strpos($filtro, 'no_mostrar_totales') === false) {
                                    if (strlen($filtro) == 0) $filtro = '(no_mostrar_totales:'.$restringir.')';
                                    else $filtro .= ',(no_mostrar_totales:'.$restringir.')';
                                } else $filtro = str_replace(array("(no_mostrar_totales:0)", "(no_mostrar_totales:1)"), ('(no_mostrar_totales:'.$restringir.')'), $filtro);
        
                                if (strpos($filtro, 'mostrar_resumen') === false) {
                                    if (strlen($filtro) == 0) $filtro = '(mostrar_resumen:'.$permisocaja.')';
                                    else $filtro .= ',(mostrar_resumen:'.$permisocaja.')';
                                } else $filtro = str_replace(array("(mostrar_resumen:0)", "(mostrar_resumen:1)"), '(mostrar_resumen:'.$permisocaja.')', $filtro);
        
                                $datav = array(
                                    'filtro' => $filtro,
                                    'valor_memo' => trim($this->input->post('centros')),
                                    'whodidit' => $this->session->userdata('iduser'),
                                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                                );
                                $this->gerencia_model->multiOpciones(18, ['where' => $where, 'data' => $datav]);
                            #-
                            $Datos = $this->conversion(4);
                            $datA[] = array('valido' => true, 'datos' => $Datos);
                        } else $datA[] = array('valido' => false);//*/
                    break;
                    default:$datA[] = array('valido' => false);break;
                }
                echo json_encode($datA);
            }
        }
        function setUsuario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $this->load->model('user_model');
                $this->load->model('gerencia_model');
    
                $conteo = (int)$this->input->post("conteo");
                $sen = false;
                $error = '';
                if ($conteo > 0) {
                    $size = $_FILES['Archivo']['size'];
                    $ext = $_FILES['Archivo']['name'];
                    $nombrei = $this->conversion(1, [
                        'extension' => pathinfo($ext, PATHINFO_EXTENSION)
                    ]).'.'.pathinfo($ext, PATHINFO_EXTENSION);
                    $config['upload_path']= "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $config['file_name'] = $nombrei;
                    $config['max_size'] = 200;
                    $this->load->library('upload',$config);
                    if ($this->upload->do_upload('Archivo')) $sen = true;
                    else {
                        $sen = false;
                        $error = $this->upload->display_errors();
                        if (($size / 1024) > 200) $error = 'sizeImagen';
                    }
                } else {
                    $nombrei = '';
                    $sen = true;
                }
    
                if ($sen) {
                    $correo = trim($this->input->post('correo'));
                    $usuario = trim($this->input->post('usuario'));
                    $contra = trim($this->input->post('password'));
                    $contra = md5($this->clave.$contra);
                    $estado = (int)$this->input->post('estado');
                    $data = array(
                        'descrip' => trim($this->input->post('nombre')),
                        'username' => $usuario,
                        'password' => $contra,
                        'idaccount' => $this->session->userdata('idaccount'),
                        'issuedate' => $this->input->post('finicial'),
                        'duedate' => $this->input->post('ffinal'),
                        //'lastlogin' => '',
                        'profile' => (int)$this->input->post('perfil'),
                        'derechos' => trim($this->input->post('derechos')),
                        'idcentro' => (int)$this->input->post('sucursal'),
                        'idcaja' => (int)$this->input->post('caja'),
                        'idcps' => (int)$this->input->post('empleado'),
                        'menug' => 0,
                        'telefonos' => '',
                        'correo1' => $correo,
                        'correo2' => '',
                        'estado' => $estado,
                        'imagen' => $nombrei,
                        'notas' => trim($this->input->post('notas')),
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
    
                    $ID = $this->user_model->multiOpciones(7, $data);
                    if ($ID) {
                        $this->conversion(2, [
                            'opcion' => 0,
                            'ID' => $ID,
                            'aplicaciones' => trim($this->input->post('aplicaciones'))
                        ]);
    
                        $action = "Registro de usuario";
                        $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Campo</td>
                                            <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Iduser</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$ID.'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Descrip</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['descrip'].'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Username</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$usuario.'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Issuedate</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['issuedate'].'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Duedate</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['duedate'].'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Profile</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['profile'].'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Derechos</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['derechos'].'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Idcentro</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['idcentro'].'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Idcaja</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['idcaja'].'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Idcps</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['idcps'].'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Correo</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['correo1'].'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Estado</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['estado'].'</td>
                                        </tr>';
                            $values .= '<tr>
                                            <td style="border: 1px solid black; padding: 5px">Notas</td>
                                            <td style="border: 1px solid black; padding: 5px">'.$data['notas'].'</td>
                                        </tr>';
                        $values .= "</tabla>";
    
                        $this->user_model->auditoriaUsuarios($ID,$action,$values);
    
                        if(trim($this->input->post('aplicaciones')) != ""){
                            $permisosArray = $this->user_model->getUsersAppsHistorial(trim($this->input->post('aplicaciones')));
                            $action = "Asignación de Permisos";
                            $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Campo</td>
                                                <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Núm. de Permisos</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$permisosArray['count'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Permisos</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$permisosArray['resultado'].'</td>
                                            </tr>';
                            $values .= "</tabla>";
    
                            $this->user_model->auditoriaUsuarios($ID,$action,$values);
                        }
    
                        $this->load->model('global_model');
                        $razon_social = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nombre_comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $correo_inst = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                        
                        $body ="<h1>".$nombre_comercial."</h1>";
                        $body .= "<h2>Ahora tienes acceso a: <br> ".base_url()."</h2>";
                        $body .= "<h3>Número de Cuenta: ".$this->session->userdata('idaccount')."</h3>";
                        $body .= "<h3>Usuario: ".$usuario."</h3>";
                        $body .= "<h3>Contraseña: ".$contra."</h3>";
                        $tipo = ($this->conversion(3, [
                            'correoOrigen' => $correo_inst,
                            'nombre' => $nombre_comercial,
                            'correoDestino' => $correo,
                            'asunto' => 'DATOS DE ACCESO',
                            'mensaje' => $body
                        ])) ? 0 : 1;
    
                        $Datos = $this->conversion(-1, ((int)$this->input->post('estadoUser')));
                        $datA[] = array('valido' => true, 'datos' => $Datos, 'tipo' => $tipo);
                    } else {
                        if ($conteo > 0) {
                            $path = "img_cuentas/".$this->session->userdata('diraccount')."/".$nombrei;
                            unlink($path);
                        }
                        $datA[] = array('valido' => false, 'sen' => $sen, 'error' => '');
                    }
                } else $datA[] = array('valido' => false, 'sen' => $sen, 'error' => $error);
    
                echo json_encode($datA);
            }
        }
        
        function updateUsuario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $this->load->model('user_model');
                $this->load->model('gerencia_model');
    
                $conteo = (int)$this->input->post("conteo");
                $ID = (int)$this->input->post('ID');

                if($ID == 2 && $this->session->userdata('iduser') != 1 && $this->session->userdata('iduser') != 2){
                    $datA[] = array('valido' => false, 'sen' => '', 'error' => 'permiso');
                    echo json_encode($datA);
                    return null;
                }

                $dato = $this->user_model->multiOpciones(8, $ID);
                $sen = false;
                $error = '';
                if ($conteo > 0) {
                    $size = $_FILES['Archivo']['size'];
                    $ext = $_FILES['Archivo']['name'];
    
                    if (strlen(trim($dato->imagen)) > 0) $nombreold = explode(".", $dato->imagen)[0];
                    else $nombreold = $this->conversion(1, [
                        'extension' => pathinfo($ext, PATHINFO_EXTENSION)
                    ]);
                    $nombrei = $nombreold.".".pathinfo($ext, PATHINFO_EXTENSION);
                    $config['upload_path']= "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $config['file_name'] = '123'.$nombrei;
                    $config['max_size'] = 200;
                    $this->load->library('upload',$config);
                    if ($this->upload->do_upload('Archivo')) {
                        $a = $this->upload->data();
                        $sen = true;
                    } else {
                        $sen = false;
                        $error = $this->upload->display_errors();
                        if (($size / 1024) > 200) $error = 'sizeImagen';
                    }
                } else {
                    $nombrei = $dato->imagen;
                    $sen = true;
                }
                if ($sen) {
                    $oldValues = $this->user_model->getDatosUsuario($ID);
    
                    $correo = trim($this->input->post('correo'));
                    $usuario = trim($this->input->post('usuario'));
                    $estado = (int)$this->input->post('estado');
                    $data = array(
                        'descrip' => trim($this->input->post('nombre')),
                        'username' => $usuario,
                        'issuedate' => $this->input->post('finicial'),
                        'duedate' => $this->input->post('ffinal'),
                        //'lastlogin' => '',
                        'profile' => (int)$this->input->post('perfil'),
                        'derechos' => trim($this->input->post('derechos')),
                        'idcentro' => (int)$this->input->post('sucursal'),
                        'idcaja' => (int)$this->input->post('caja'),
                        'idcps' => (int)$this->input->post('empleado'),
                        'correo1' => $correo,
                        'estado' => $estado,
                        'imagen' => $nombrei,
                        'notas' => trim($this->input->post('notas')),
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->user_model->multiOpciones(9, [
                        'ID' => $ID,
                        'data' => $data
                    ])) {
                        if ($conteo > 0) {
                            if (strlen(trim($dato->imagen)) > 0) {
                                $path = "img_cuentas/".$this->session->userdata('diraccount')."/".trim($dato->imagen);
                                if (file_exists($path)) unlink($path);
                            }
                            rename($a['full_path'],$a['file_path'].$nombrei);
                        }
                        $arrayDatosNuevos = array(
                            'descrip' => trim($this->input->post('nombre')),
                            'username' => $usuario,
                            'duedate' => $this->input->post('ffinal'),
                            'profile' => (int)$this->input->post('perfil'),
                            'derechos' => trim($this->input->post('derechos')),
                            'idcentro' => (int)$this->input->post('sucursal'),
                            'idcaja' => (int)$this->input->post('caja'),
                            'idcps' => (int)$this->input->post('empleado'),
                            'correo1' => $correo,
                            'estado' => $estado,
                            'notas' => trim($this->input->post('notas')),
                        );
                        $arrayDatosViejos = array(
                            'descrip' => $oldValues['descrip'],
                            'username' => $oldValues['username'],
                            'duedate' => $oldValues['duedate'],
                            'profile' => $oldValues['profile'],
                            'derechos' => $oldValues['derechos'],
                            'idcentro' => $oldValues['idcentro'],
                            'idcaja' => $oldValues['idcaja'],
                            'idcps' => $oldValues['idcps'],
                            'correo1' => $oldValues['correo1'],
                            'estado' => $oldValues['estado'],
                            'notas' => $oldValues['notas'],
                        );
                        //Solamente registra en la tabla de auditoria si los datos cambias
                        if($arrayDatosNuevos != $arrayDatosViejos){
                            $action = "Modificación de usuario";
                            $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Campo</td>
                                                <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor Anterior</td>
                                                <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor Nuevo</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Descrip</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['descrip'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['descrip'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Username</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['username'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['username'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Duedate</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['duedate'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['duedate'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Profile</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['profile'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['profile'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Derechos</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['derechos'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['derechos'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Idcentro</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['idcentro'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['idcentro'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Idcaja</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['idcaja'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['idcaja'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Idcps</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['idcps'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['idcps'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Correo</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['correo1'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['correo1'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Estado</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['estado'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['estado'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Notas</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldValues['notas'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$data['notas'].'</td>
                                            </tr>';
                            $values .= '</tabla>';
        
                            $this->user_model->auditoriaUsuarios($ID,$action,$values);
                        }
                    
                        //Activacion/inactivacion de cuenta
                        if($oldValues['estado'] != $data['notas']){
                            if($oldValues['estado'] == 1 && $data['estado'] == 0){
                                $action = "Inactivación de cuenta";
                                $this->user_model->auditoriaUsuarios($ID,$action,"");
                            }
    
                            if($oldValues['estado'] == 0 && $data['estado'] == 1){
                                $action = "Activación de cuenta";
                                $this->user_model->auditoriaUsuarios($ID,$action,"");
                            }
                        }
    
                        if ($estado == 1) {
                            //	
                            if(trim($this->input->post('aplicaciones')) != ""){
                                $permisosArray = $this->user_model->getUsersAppsHistorial(trim($this->input->post('aplicaciones')));
                                $oldPermisosArray = $this->user_model->getUsersAppsHistorialById($ID);
    
                                if($permisosArray != $oldPermisosArray ){
                                    $action = "Modificación de permisos";
                                    $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor</td>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;"># de Permisos</td>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Permisos</td>
                                                    </tr>';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px">Valor Anterior</td>
                                                        <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['count'].'</td>
                                                        <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['resultado'].'</td>
                                                    </tr>';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px">Valor Nuevo</td>
                                                        <td style="border: 1px solid black; padding: 5px">'.$permisosArray['count'].'</td>
                                                        <td style="border: 1px solid black; padding: 5px">'.$permisosArray['resultado'].'</td>
                                                    </tr>';
                                    $values .= "</tabla>";
        
                                    $this->user_model->auditoriaUsuarios($ID,$action,$values);
                                }
                            }else{	//Se deshabilitan todos los permisos
                                $oldPermisosArray = $this->user_model->getUsersAppsHistorialById($ID);
    
                                if($oldPermisosArray['count'] != 0){
                                    $action = "Modificación de permisos";
                                    $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor</td>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;"># de Permisos</td>
                                                        <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Permisos</td>
                                                    </tr>';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px">Valor Anterior</td>
                                                        <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['count'].'</td>
                                                        <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['resultado'].'</td>
                                                    </tr>';
                                        $values .= '<tr>
                                                        <td style="border: 1px solid black; padding: 5px">Valor Nuevo</td>
                                                        <td style="border: 1px solid black; padding: 5px">0</td>
                                                        <td style="border: 1px solid black; padding: 5px">-</td>
                                                    </tr>';
                                    $values .= "</tabla>";
        
                                    $this->user_model->auditoriaUsuarios($ID,$action,$values);
                                }
                                
                            }
    
                            $this->conversion(2, [
                                'opcion' => 1,
                                'ID' => $ID,
                                'aplicaciones' => trim($this->input->post('aplicaciones'))
                            ]);
    
                        } else{ 
    
                            $oldPermisosArray = $this->user_model->getUsersAppsHistorialById($ID);
    
                            $action = "Modificación de permisos";
                            $values = '<table style="border: 1px solid black; border-collapse: collapse;">';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Valor</td>
                                                <td style="border: 1px solid black; padding: 5px; font-weight: bold;"># de Permisos</td>
                                                <td style="border: 1px solid black; padding: 5px; font-weight: bold;">Permisos</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Valor Anterior</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['count'].'</td>
                                                <td style="border: 1px solid black; padding: 5px">'.$oldPermisosArray['resultado'].'</td>
                                            </tr>';
                                $values .= '<tr>
                                                <td style="border: 1px solid black; padding: 5px">Valor Nuevo</td>
                                                <td style="border: 1px solid black; padding: 5px">0</td>
                                                <td style="border: 1px solid black; padding: 5px">-</td>
                                            </tr>';
                            $values .= "</tabla>";
    
                            $this->user_model->auditoriaUsuarios($ID,$action,$values);
                            $this->user_model->multiOpciones(11, $ID);
                        }
    
                        $Datos = $this->conversion(-1, ((int)$this->input->post('estadoUser')));
                        $datA[] = array('valido' => true, 'datos' => $Datos);
    
                    } else {
                        if ($conteo > 0) {
                            $path = "img_cuentas/".$this->session->userdata('diraccount')."/123".$nombrei;
                            if (file_exists($path)) unlink($path);
                        }
                        $datA[] = array('valido' => false, 'sen' => $sen, 'error' => '');
                    }
                } else $datA[] = array('valido' => false, 'sen' => $sen, 'error' => $error);
    
                echo json_encode($datA);
            }
        }

        private function conversion($opc, $extra = null)
        {
            $Datos = [];
            switch ($opc) {
                case -1:#	GET USUARIOS
                    $datos = $this->gerencia_model->multiOpciones(-1, $extra);
                    if ($datos->num_rows() > 0) {
                        foreach($datos->result() as $dato) {
                            $imagen = 'assets/img/sinImagen.png';
                            if (strlen(trim($dato->imagen)) > 0) {
                                $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                                if (file_exists($direccion.trim($dato->imagen))) $imagen = $direccion.trim($dato->imagen);
                            }
                            $aplicaciones = $this->gerencia_model->multiOpciones(12, $dato->iduser);
                            if ($aplicaciones->num_rows() > 0) $aplicaciones = implode(',', array_map(function($o) {return $o->idapp;}, (array)$aplicaciones->result()));
                            else $aplicaciones = '';
                            $Datos[] = array(
                                'key' => $dato->iduser,
                                'nombre' => trim($dato->descrip),
                                'finicial' => $dato->fi,
                                'ffinal' => $dato->ff,
                                'usuario' => trim($dato->username),
                                'idempleado' => $dato->idcps,
                                'derechos' => trim($dato->derechos),
                                'correo' => trim($dato->correo1),
                                'notas' => trim($dato->notas),
                                'idsucursal' => $dato->idcentro,
                                'idcaja' => $dato->idcaja,
                                'idperfil' => $dato->profile,
                                'aplicaciones' => $aplicaciones,
                                'estado' => $dato->estado,
                                'imagen' => $imagen,
                                'last' => ($dato->last == '0000-00-00 00:00:00') ? '' : $dato->last,
                                'sucursal' => $dato->sucursal,
                                'caja' => $dato->caja
                            );
                        }
                    }
                break;
                case 1:#   GET NAME IMAGEN
                    $ext = $extra['extension'];
                    $valor = '';
                    $i = 0;
                    do {
                        $conteo = $this->gerencia_model->multiOpciones(5);
                        $valor = "imgUsuario_".$conteo."_".rand(10,1000).".".$ext;
                        $i++;
                        if ($i >= 100) {
                            $valor = "imgUsuarioTemp_".$i."_".$conteo."_".rand(10,1000).".".$ext;
                            break;
                        }
                    } while (!$this->gerencia_model->multiOpciones(6, $valor));
                    return explode(".", $valor)[0];
                break;
                case 2:#   PERMISOS DE APLICACIONES
                    $opcion = $extra['opcion'];
                    $apps = $extra['aplicaciones'];
                    $ID = $extra['ID'];
                    $olds = [];

                    if ($opcion == 1) {
                        $appsOld = $this->gerencia_model->multiOpciones(12, $ID);
					    if ($appsOld->num_rows() > 0) $olds = $appsOld->result();
                        $this->gerencia_model->multiOpciones(11, $ID);
                    }
                    if (strlen($apps) > 0) {
                        $apps = explode(",", $apps);
                        foreach ($apps as $idapp) {
                            $permiso = '';
                            $data = array(
                                'iduser' => $ID,
                                'idapp' => (int)$idapp,
                                'estado' => 1,
                                'issuedate' => date_create()->format('Y-m-d H:i:s'),
                                'whodidit' => $this->session->userdata('iduser'),
                                'ingresa' => date_create()->format('Y-m-d H:i:s'),
                            );
                            if (($this->gerencia_model->multiOpciones(12.5)) && ($opcion == 1) && (count($olds) > 0)) {
                                $found = array_search((int)$idapp, array_column($olds, 'idapp'));
                                if ($found !== false) $permiso = $olds[$found]->permisos;
                                $data['permisos'] = $permiso;
                            }
                            $this->gerencia_model->multiOpciones(10, $data);
                        }
                    }
                break;
                case 3:#	ENVIAR CORREO
                    $this->load->library('email');
                    //$this->load->library('My_PHPMailer');
                    $this->email->from($extra['correoOrigen'], $extra['nombre']);
                    $this->email->to($extra['correoDestino']);
                    $this->email->subject($extra['asunto']);
                    $this->email->set_mailtype("html");
                    $this->email->message($extra['mensaje']);
                    $Datos = ($this->email->send()) ? true : false;
                break;
                case 4:#    GET HORARIOS
                    $datos = $this->gerencia_model->multiOpciones(13);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $restringir = (strpos($dato->filtro, '(no_mostrar_totales:1)') === false) ? false : true;
                            $permiso = (strpos($dato->filtro, '(mostrar_resumen:1)') === false) ? false : true;
                            $Datos[] = array(
                                'key' => $dato->idrec,
                                'idperfil' => $dato->profile,
                                'perfil' => trim($dato->perfil),
                                'domingo' => $dato->dow1,
                                'lunes' => $dato->dow2,
                                'martes' => $dato->dow3,
                                'miercoles' => $dato->dow4,
                                'jueves' => $dato->dow5,
                                'viernes' => $dato->dow6,
                                'sabado' => $dato->dow7,
                                'centros' => $dato->memo,
                                'permiso' => $permiso,
                                'restringir' => $restringir
                            );
                        }
                    }
                break;
            }
            return $Datos;
        }
        #-
		
		function getUsuariosFilter(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$estado = $this->input->post('estado');
				
				$this->load->model('gerencia_model');
				$result = $this->gerencia_model->getUsuariosFiltrados($estado);
                
				echo json_encode($result);
			}
		}
		
		function adicionarusuario(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$datosPage = array(
					'namePage' => 'Adicionar '.$this->session->userdata('appName')
				);
				$this->session->set_userdata($datosPage);

				$this->load->model('gerencia_model');
				$this->load->model('user_model');
				
				$this->data['asesores'] = $this->gerencia_model->getListEmpleados();
				$this->data['profile'] = $this->user_model->getProfile();
				$this->data['sucursales'] = $this->user_model->getSucursales();
				
				$this->load->view('gerencia_nuevo_usuario', $this->data);
			}
		}
		
		function insertUsuario(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($this->input->post()){
					$grafico = $this->input->post('saveNext'); 
					if($grafico == "true"){ $menug = 1; }else{$menug = 0;}

					$perfil = $this->input->post('perfil');
					$des = $this->input->post('descrip');
					$descrip = str_replace(array("\n", "\r", "\n\r"), " ", $des);
					$sucursal = $this->input->post('sucursal');
					$cajas = $this->input->post('cajas');
					$empleado = $this->input->post('empleado');
					$derecho = $this->input->post('derecho');
					$usuario = $this->input->post('usuario');
					$contra = $this->input->post('contra');
					$correo = $this->input->post('correo');
					$alterno = $this->input->post('alterno');
					$telefonos = $this->input->post('telefonos');
					$esta = $this->input->post('estado');
					$idaccount = $this->session->userdata('idaccount');
					$issuedate = $this->input->post('emision');
					$duedate = $this->input->post('vencimiento');
					$not = $this->input->post('notas');
					$notas = str_replace(array("\n", "\r", "\n\r"), " ", $not);
					$img = $this->input->post('imgen');

					if($esta == "true"){$estado = 1;}else{$estado = 0;}

					$this->load->model('global_model');
					$this->load->model('gerencia_model');
					
					$razon_social = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
					$nombre_comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
					$correo_inst = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);

					$this->load->library('email');
					$this->email->from($correo_inst, $nombre_comercial);
					$this->email->to($correo);
					$this->email->subject("DATOS DE ACCESO");
					$this->email->set_mailtype("html");
					$body ="<h1>".$nombre_comercial."</h1>";
					$body .= "<h2>Ahora tienes acceso a: <br> http://www.goxpos.com</h2>";
					$body .= "<h3>Número de Cuenta: ".$this->session->userdata('idaccount')."</h3>";
					$body .= "<h3>Usuario: ".$usuario."</h3>";
					$body .= "<h3>Contraseña: ".$contra."</h3>";
					$this->email->message($body);

					if($this->email->send()){
						$nameimagen = $this->gerencia_model->insertUser($empleado, $menug,$perfil,$descrip,$sucursal,$cajas,$derecho,$usuario,$contra,$correo,$alterno,$telefonos,$estado,$notas,$img,$idaccount,$issuedate,$duedate); 
						$imgSplit = explode(".", $nameimagen);
						$archivo = 'imagenes';
						$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
						$config['file_name'] = $imgSplit[0];
						$config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $config['max_size'] = 200;
						$this->load->library('upload', $config);
						$this->upload->do_upload($archivo); 
					}else{
						$nameimagen = $this->gerencia_model->insertUser($empleado, $menug,$perfil,$descrip,$sucursal,$cajas,$derecho,$usuario,$contra,$correo,$alterno,$telefonos,$estado,$notas,$img,$idaccount,$issuedate,$duedate); 
						$imgSplit = explode(".", $nameimagen);
						$archivo = 'imagenes';
						$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
						$config['file_name'] = $imgSplit[0];
						$config['over_write'] = "TRUE";
						$config['allowed_types'] = "gif|jpg|jpeg|png";
                        $config['max_size'] = 200;
                        $this->load->library('upload', $config);
						$this->upload->do_upload($archivo); 
					}
					
					redirect('Usuarios/'.$this->session->userdata('iddApp'));
				}
			}
		}
		
		function actualizarusuario($iduser){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$datosPage = array(
					'namePage' => 'Actualizar '.$this->session->userdata('appName').' N°'.$iduser
				);
				$this->session->set_userdata($datosPage);
				
				$this->load->model('user_model');$this->load->model('gerencia_model');
				$this->load->model("apps_model");$this->load->model("derechos_model");
				
				$this->data['iduser'] = $iduser; 
				$this->data['infoApps'] = $this->derechos_model->viewApps($iduser); 
				$this->data['menuName'] = $this->apps_model->viewMenu();
				$this->data['profile'] = $this->user_model->getProfile();
				$this->data['asesores'] = $this->gerencia_model->getListEmpleados();
				$this->data['sucursales'] = $this->user_model->getSucursales();
				$this->data['detalles'] = $this->user_model->callRegistro($iduser);
				$sucursal = $this->user_model->callSucursal($iduser);
				$this->data['cajas'] = $this->user_model->viewCajas($sucursal);
				$permisos = $this->user_model->getUsersApps($iduser);
				$this->data['permisos'] = $permisos;

				$cadena=",";
				$cant=0;
				foreach ($permisos as $per){
					if($per->ValorPermiso==1){
						$cadena .= $per->idapp.",";
						$cant++;
					}
				}
				$this->data['apps_permisos'] = $cadena;
				
				$this->load->view('gerencia_actualizar_usuario', $this->data);
			}
		}
		
		function updateUsuarioOld(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				if($this->input->post()){
					$grafico = $this->input->post('saveNext'); 
					if($grafico == "true"){$menug = 1;}else{$menug = 0;}
					
					$id = $this->input->post('iduser');
					$lista_permisos = $this->input->post('lista');
					$inputLista = $this->input->post('inputLista');
					$perfil = $this->input->post('perfil');
					$des = $this->input->post('descrip');
					$descrip = str_replace(array("\n", "\r", "\n\r"), " ", $des);
					$sucursal = $this->input->post('sucursal');
					$cajas = $this->input->post('cajas');
					$derecho = $this->input->post('derecho');
					$usuario = $this->input->post('usuario');
					$correo = $this->input->post('correo');
					$alterno = $this->input->post('alterno');
					$telefonos = $this->input->post('telefonos');
					$esta = $this->input->post('estado');
					$idaccount = $this->session->userdata('idaccount');
					$empleado = $this->input->post('empleado');
					$issuedate = $this->input->post('emision');
					$duedate = $this->input->post('vencimiento');
					$not = $this->input->post('notas');
					$notas = str_replace(array("\n", "\r", "\n\r"), " ", $not);
					$img = $this->input->post('imgen');
					$imagen = $this->input->post('img');
					$imga = $this->input->post('imga');
					
					if($esta == "true"){$estado = 1;}else{$estado = 0;}
					
					$this->load->model('gerencia_model');
					$nameimagen = $this->gerencia_model->updateUser($id,$menug,$perfil,$descrip,$sucursal,$cajas,$derecho,$usuario,$correo,$alterno,$telefonos,$estado,$notas,$img, $imagen, $imga,$idaccount,$issuedate,$duedate,$empleado,$inputLista);
					$imgSplit = explode(".", $nameimagen);
					
					$archivo = 'imagenes';
					$config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
					$config['file_name'] = $imgSplit[0];
					$config['over_write'] = "TRUE";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $config['max_size'] = 200;
					$this->load->library('upload', $config);
					$this->upload->do_upload($archivo); 

                    redirect('Usuarios/'.$this->session->userdata('iddApp'));
				}
			}
		}
		
		function numeradores($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $result = $this->configuracion_model->confirmarAccesoApp($idApp);
                $result == true ?: redirect('CerrarSesion');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model("transacciones_model");
                $this->data['tipoNum'] = $this->transacciones_model->getTiposRegistros();
                
                $this->load->view('mantenimiento_user_numeradores', $this->data);
            }
		}
        
        function ver_schedules(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $idApp = $this->uri->segment(2);
                
                $this->load->model('configuracion_model');

                $result = $this->configuracion_model->confirmarAccesoApp($idApp);
                $result == true ?: redirect('CerrarSesion');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('gerencia_model');
				
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['lista'] = $this->gerencia_model->getSchedules();
                
                $this->load->view('mantenimiento_schedules', $this->data);
            }
        }
		
        function ver_schedules_admin(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $this->load->model('configuracion_model');
                $resultAppName = array(
                    'namePage' => 'Horarios De Acceso'
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->load->view('mantenimiento_schedules_admin', $this->data);
            }
        }
		
        function form_update_schedule(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $id = $this->uri->segment(2);
                $this->load->model('gerencia_model'); $this->load->model('user_model');
                $this->data['info'] = $this->gerencia_model->getSchedulesInfo($id);
                $tipo = $this->gerencia_model->getTipoPerfilSchedule($id);
                
                $array_info = array(
					'namePage' => 'Modificar horario para '.$tipo
				);
				$this->session->set_userdata($array_info);
                
                $this->data['id'] = $id;
                $informacion = $this->gerencia_model->getSchedulesInfo($id);
                $this->data['info'] = $informacion;

                foreach($informacion as $info){
                    $cadenaPermisos = $info->filtro;
                    $txtPermiso   = '(no_mostrar_totales:1)';
                    $txtResumen   = '(mostrar_resumen:1)';

                    $findPermiso1 = strpos($cadenaPermisos, $txtPermiso);
                    if($findPermiso1 === false){
                        $permisoValores = 0;
                        $colorPermiso = "CCCCCC";
                    }else{
                        $permisoValores = 1;
                        $colorPermiso = "1B70E0";
                    }

                    $findResumen = strpos($cadenaPermisos, $txtResumen);
                    if($findResumen === false){
                        $permisoResumen = 0;
                        $colorResumen = "CCCCCC";
                    }else{
                        $permisoResumen = 1;
                        $colorResumen = "1B70E0";
                    }
                }

                $this->data['permisoValores'] = $permisoValores;
                $this->data['permisoResumen'] = $permisoResumen;
                $this->data['colorPermiso'] = $colorPermiso;
                $this->data['colorResumen'] = $colorResumen;
                $this->data['sucursales'] = $this->user_model->getListSucursales();
                $this->load->view('form_update_schedule', $this->data);
            }
        }
		
        function form_update_schedule_admin(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')  || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
				$id = $this->uri->segment(2);
                
                $this->load->model('user_model');
                $this->load->model('gerencia_model');
                $tipo = $this->gerencia_model->getTipoPerfilSchedule($id);
                
                $arrayInfo = array(
					'namePage' => 'Modificar horario para '.$tipo
				);
				$this->session->set_userdata($arrayInfo);
                
                $this->data['id'] = $id;
                $informacion = $this->gerencia_model->getSchedulesInfo($id);
                $this->data['info'] = $informacion;

                foreach($informacion as $info){
                    $cadenaPermisos = $info->filtro;
                    $txtPermiso   = '(no_mostrar_totales:1)';
                    $txtResumen   = '(mostrar_resumen:1)';

                    $findPermiso1 = strpos($cadenaPermisos, $txtPermiso);
                    if($findPermiso1 === false){
                        $permisoValores = 0;
                        $colorPermiso = "CCCCCC";
                    }else{
                        $permisoValores = 1;
                        $colorPermiso = "1B70E0";
                    }

                    $findResumen = strpos($cadenaPermisos, $txtResumen);
                    if($findResumen === false){
                        $permisoResumen = 0;
                        $colorResumen = "CCCCCC";
                    }else{
                        $permisoResumen = 1;
                        $colorResumen = "1B70E0";
                    }
                }

                $this->data['permisoValores'] = $permisoValores;
                $this->data['permisoResumen'] = $permisoResumen;
                $this->data['colorPermiso'] = $colorPermiso;
                $this->data['colorResumen'] = $colorResumen;
                $this->data['sucursales'] = $this->user_model->getListSucursales();
                $this->load->view('form_update_schedule_admin', $this->data);
            }
        }
        
        function saveSchedule(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $domingo = $this->input->post('domingo');
                $lunes = $this->input->post('lunes');
                $martes = $this->input->post('martes');
                $miercoles = $this->input->post('miercoles');
                $jueves = $this->input->post('jueves');
                $viernes = $this->input->post('viernes');
                $sabado = $this->input->post('sabado');
                $sucursales = $this->input->post('sucursales');
                $permisoVentas = $this->input->post('permisoVentas');
                $permisoResumen = $this->input->post('permisoResumen');
				
                $this->load->model('gerencia_model');
				$result = $this->gerencia_model->saveSchedule($idrec,$domingo,$lunes,$martes,$miercoles,$jueves,$viernes,$sabado,$sucursales,$permisoVentas,$permisoResumen);
				
                echo json_encode($result);
            }
        }
        
        function importarFacturas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
				redirect('CerrarSesion');
            }else{
				$resultAppName = array(
                    'appName' => 'Importación de Ventas',
                    'namePage' => 'Importación de Ventas'
				);
				$this->session->set_userdata($resultAppName);

				$this->load->view('mantenimiento_importacion_facturas');
			}
        }
        function descargarFormatoArchivoFacturas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $objPHPExcel = new Spreadsheet();
				$objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Formato_Facturas") // Titulo
                ->setSubject("Formato_Facturas") //Asunto
                ->setDescription("Formato_Facturas") //Descripción
                ->setKeywords("Formato_Facturas") //Etiquetas
                ->setCategory("Formato_Facturas"); //Categorias
				$objPHPExcel->setActiveSheetIndex(0);

                $style_titulo = array(
					'alignment' => array(
						'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
					),
					'font'  => array(
						'bold' => true,
						'color' => array('rgb' => '000'),
						'size'  => 10,
						'name'  => 'Calibri'
					),
					'fill' => [
						'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'A6A6A6',
						],
					],
                    'borders' => [
						'allBorders' => [
							'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							'color' => ['argb' => '000000'],
						],
					],
				);

                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(17); 
                $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(50);
                $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(17);
                $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(50);
				$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(17);

				$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'IDCENTRO');
				$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'IDCAJA');
				$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'IDCLASE');
				$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'CAJCLASE');
				$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'SERIE');
				$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'NÚMERO');
				$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'FECHA');
				$objPHPExcel->getActiveSheet()->SetCellValue('H1', 'IDPRODUCTO');
				$objPHPExcel->getActiveSheet()->SetCellValue('I1', 'DESCRIPCIÓN DEL ARTÍCULO');
				$objPHPExcel->getActiveSheet()->SetCellValue('J1', 'IDWORKER');
                $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'IDCPS');
				$objPHPExcel->getActiveSheet()->SetCellValue('L1', 'NOMBRE DEL CLIENTE');
				$objPHPExcel->getActiveSheet()->SetCellValue('M1', 'PRECIOTRAN');
				$objPHPExcel->getActiveSheet()->SetCellValue('N1', 'CANTIDAD');
				$objPHPExcel->getActiveSheet()->SetCellValue('O1', 'UNICONV');
				$objPHPExcel->getActiveSheet()->SetCellValue('P1', 'TAX1');
				$objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'NÚM X');
				$objPHPExcel->getActiveSheet()->SetCellValue('R1', 'NÚM Y');
				$objPHPExcel->getActiveSheet()->SetCellValue('S1', 'NÚM Z');

                $objPHPExcel->getActiveSheet()->getStyle('A1:S1')->applyFromArray($style_titulo);
                $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
                $objPHPExcel->getActiveSheet()->getStyle('G')->getNumberFormat()->setFormatCode("yyyy-mm-dd");


                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header('Content-Disposition: attachment;filename="Formato_Facturas.xlsx"');
				header('Cache-Control: max-age=0');
				$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
				$objWriter->save('php://output'); 
				exit;
            }
        }
        function uploadArchivoFacturas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if(isset($_FILES["inputArchivo"])){
                    $infoFile = $_FILES["inputArchivo"];
                    $nameDocument = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    
                    if($nameDocument != ""){
                        $nameDocument = trim($nameDocument);
                        
                        $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                        $config['file_name'] = $nameDocument;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('inputArchivo')){
                            $this->load->model('gerencia_model');
                            $dataSource = $this->gerencia_model->validateIngresoDeFacturas($documentTemp, $nameDocument);
                            $error = 0;
                            unlink("./doc_cuentas/".$this->session->userdata('dirDocuments')."/". $nameDocument);
                        }else{
                            $dataSource = '';
                            $error = 2;
                            $totalErrores = 1;
                        }
                    }else{
						$dataSource = '';
						$error = 1;
                        $totalErrores = 1;
					}
                }else{
                    $dataSource = '';
                    $error = 1;
                    $totalErrores = 1;
                }
                
                $array = array(
                    "dataSource" => $dataSource,
                    "error" => $error,
                );
                echo json_encode($array);
            }
        }
		
		function insertarFacturasTran_100(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$infoFile = $_FILES["inputArchivo"];
				$nameDocument = $infoFile["name"];
				$documentTemp = $infoFile['tmp_name'];
                
				$config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
				$config['file_name'] = $nameDocument;
				$config['over_write'] = "TRUE";
				$config['allowed_types'] = "*";
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
                        
				if($this->upload->do_upload('inputArchivo')){
					$this->load->model('gerencia_model');
					$dataSource = $this->gerencia_model->insertRegistrosDeFacturas($documentTemp, $nameDocument);
					
					unlink("./doc_cuentas/".$this->session->userdata('dirDocuments')."/". $nameDocument);
				}
				
				echo json_encode($dataSource);
			}
		}
        
        function ticket_solicitudes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Solicitud de Servicios'
				);
				$this->session->set_userdata($resultAppName);
                
                $this->load->model('media_model');
                
                $this->data['estados'] = $this->media_model->getListadoEstadosTickets();
                $this->data['modulos'] = $this->media_model->getListadoModulosTickets();
                $this->data['tipos'] = $this->media_model->getListadoTiposTickets();
                
				$this->load->view('mantenimiento_support_ticket', $this->data);
            }
        }
        
        function getListadoTicketsCuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d");
                
                $idcuenta = trim($this->session->userdata('idaccount'));
                $iduser = $this->session->userdata('iduser');
                
                $this->load->model('media_model');
                $informacion = $this->media_model->getListadoTicketsCuenta($idcuenta, $iduser);
                
                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $date1 = new DateTime($info->fecha);
                        $date2 = new DateTime($fecha_actual);
                        $diferencia = $date1->diff($date2);

                        $dataSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idaccount" => $info->idaccount,
                            "estado" => $info->estado,
                            "fecha" => $info->fecha,
                            "idgestion" => $info->idgestion,
                            "descrip" => $info->descrip,
                            "categoria" => $info->categoria,
                            "gestion" => $info->categoria.' / '.$info->gestion,
                            "nameCuenta" => $info->nameCuenta,
                            "user_name" => $info->user_name,
                            "prioridad" => $info->prioridad,
                            "facturable" => $info->facturable,
                            "valor" => $info->valor * 1,
                            "dias" => $diferencia->days,
                            "idticket_parent" => 0,
                            "idnivel" => 0
                        );
                        $i++;
                        
                        $info_detalle = $this->media_model->getDetalleRegistroSolicitud($info->idticket);

                        if($info_detalle != false){
                            foreach($info_detalle as $infodet){
                                $dataSource[$i] = array(
                                    "idticket" => $info->idticket.'_'.$infodet->itemline,
                                    "fecha" => $infodet->ingresa_format,
                                    "idsubgestion" => $infodet->idsubgestion,
                                    "descrip" => $infodet->notas,
                                    "gestion" => $infodet->nameSubgestion,
                                    "idticket_parent" => $info->idticket,
                                    "idnivel" => 1
                                );
        
                                $i++;
                            }
                        }
                    }
                }
                
                echo json_encode($dataSource);
            }
        }
        
        function insertarNuevoTicket(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d");
                
                $estado = $_POST['inputEstados'];
                $id_cuenta = $_POST['inputCodigoCuenta'];
                $solicitado_por = $_POST['inputSolicitadoPor'];
                $modulo = $_POST['inputModulo'];
                $tipo_solicitud = $_POST['inputSolicitud'];
                $fecha = $_POST['inputFecha'];
                $fecha_requerida = $_POST['inputFechaRequerida'];
                $observaciones = $_POST['inputDetalleSolicitud'];
                
                $idcuenta = trim($this->session->userdata('idaccount'));
                $descrip_adjuntos = ""; $msg_error = "";
                
                if(isset($_FILES["input_img_1"])){
                    $File_Adj = $_FILES["input_img_1"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('input_img_1')){
                            $descrip_adjuntos = $name_archivo_update;
                        }else{
                            $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                            echo $msg_error;
                        }
                    }
                }
                
                if(isset($_FILES["input_img_2"])){
                    $File_Adj = $_FILES["input_img_2"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('input_img_2')){
                            if($descrip_adjuntos != ""){
                                $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                            }else{
                                $descrip_adjuntos = $name_archivo_update;
                            }
                        }else{
                            $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                            echo $msg_error;
                        }
                    }
                }
                
                if(isset($_FILES["input_img_3"])){
                    $File_Adj = $_FILES["input_img_3"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('input_img_3')){
                            if($descrip_adjuntos != ""){
                                $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                            }else{
                                $descrip_adjuntos = $name_archivo_update;
                            }
                        }else{
                            $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                        }
                    }
                }
                
                if(isset($_FILES["input_img_4"])){
                    $File_Adj = $_FILES["input_img_4"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('input_img_4')){
                            if($descrip_adjuntos != ""){
                                $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                            }else{
                                $descrip_adjuntos = $name_archivo_update;
                            }
                        }else{
                            $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                        }
                    }
                }
                
                $this->load->model('media_model');
                $this->media_model->insertarRegistroTicket($estado, $id_cuenta, $solicitado_por, $modulo, $tipo_solicitud, $fecha, $fecha_requerida, $observaciones, $descrip_adjuntos);
                $informacion = $this->media_model->getListadoTicketsCuenta($idcuenta);
                
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $date1 = new DateTime($info->fecha);
                        $date2 = new DateTime($fecha_actual);
                        $diferencia = $date1->diff($date2);

                        $dataSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idaccount" => $info->idaccount,
                            "estado" => $info->estado,
                            "fecha" => $info->fecha,
                            "fecha_vence" => $info->fecha_vence,
                            "solicitadox" => $info->solicitadox,
                            "modulo" => $info->modulo,
                            "idgestion" => $info->idgestion,
                            "descrip" => $info->descrip,
                            "dias" => $diferencia->days,
                            "adjuntos" => $info->adjuntos
                        );

                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }
        
        function actualizarNuevoTicket(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d");
                
                $idticket = $_POST['idticket'];
                $estado = $_POST['inputEstados'];
                $modulo = $_POST['inputModulo'];
                $tipo_solicitud = $_POST['inputSolicitud'];
                $fecha_requerida = $_POST['inputFechaRequerida'];
                $observaciones = $_POST['inputDetalleSolicitud'];
                $data_adjuntos = $_POST['data_adjuntos'];
                $update_adjuntos = $_POST['update_adjuntos'];
				
				$idcuenta = trim($this->session->userdata('idaccount'));
                $descrip_adjuntos = ""; $msg_error = "";
                
                if($update_adjuntos == 1){
                    if(isset($_FILES["input_img_1"])){
                        $File_Adj = $_FILES["input_img_1"];
                        $nombre_adjunto = $File_Adj["name"];

                        if($nombre_adjunto != ""){
                            $nameExplode = explode(".", $nombre_adjunto);
                            $name_archivo = trim($nameExplode[0]);
                            $name_archivo_update = $name_archivo.".".$nameExplode[1];

                            $config['upload_path'] =  "doc_adjuntos/";
                            $config['file_name'] = $name_archivo;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "*";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);

                            if($this->upload->do_upload('input_img_1')){
                                $descrip_adjuntos = $name_archivo_update;
                            }else{
                                $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                                echo $msg_error;
                            }
                        }
                    }

                    if(isset($_FILES["input_img_2"])){
                        $File_Adj = $_FILES["input_img_2"];
                        $nombre_adjunto = $File_Adj["name"];

                        if($nombre_adjunto != ""){
                            $nameExplode = explode(".", $nombre_adjunto);
                            $name_archivo = trim($nameExplode[0]);
                            $name_archivo_update = $name_archivo.".".$nameExplode[1];

                            $config['upload_path'] =  "doc_adjuntos/";
                            $config['file_name'] = $name_archivo;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "*";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);

                            if($this->upload->do_upload('input_img_2')){
                                if($descrip_adjuntos != ""){
                                    $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                                }else{
                                    $descrip_adjuntos = $name_archivo_update;
                                }
                            }else{
                                $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                                echo $msg_error;
                            }
                        }
                    }

                    if(isset($_FILES["input_img_3"])){
                        $File_Adj = $_FILES["input_img_3"];
                        $nombre_adjunto = $File_Adj["name"];

                        if($nombre_adjunto != ""){
                            $nameExplode = explode(".", $nombre_adjunto);
                            $name_archivo = trim($nameExplode[0]);
                            $name_archivo_update = $name_archivo.".".$nameExplode[1];

                            $config['upload_path'] =  "doc_adjuntos/";
                            $config['file_name'] = $name_archivo;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "*";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);

                            if($this->upload->do_upload('input_img_3')){
                                if($descrip_adjuntos != ""){
                                    $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                                }else{
                                    $descrip_adjuntos = $name_archivo_update;
                                }
                            }else{
                                $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                            }
                        }
                    }

                    if(isset($_FILES["input_img_4"])){
                    $File_Adj = $_FILES["input_img_4"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('input_img_4')){
                            if($descrip_adjuntos != ""){
                                $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                            }else{
                                $descrip_adjuntos = $name_archivo_update;
                            }
                        }else{
                            $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                        }
                    }
                }
                }
				
                if($update_adjuntos == 0){
					$descrip_adjuntos = $data_adjuntos;
				}
				
                $this->load->model('media_model');
                $this->media_model->actualizarRegistroTicket($idticket, $estado, $modulo, $tipo_solicitud, $fecha_requerida, $observaciones, $descrip_adjuntos);
                $informacion = $this->media_model->getListadoTicketsCuenta($idcuenta);
                
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $date1 = new DateTime($info->fecha);
                        $date2 = new DateTime($fecha_actual);
                        $diferencia = $date1->diff($date2);

                        $dataSource[$i] = array(
                            "idticket" => $info->idticket,
                            "estado" => $info->estado,
                            "fecha" => $info->fecha,
                            "solicitadox" => $info->solicitadox,
                            "idgestion" => $info->idgestion,
                            "descrip" => $info->descrip,
                            "dias" => $diferencia->days,
                        );

                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }
        
        function actualizarEnvioNuevoTicket(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d");
                
                $idticket = $_POST['idticket'];
                $estado = $_POST['inputEstados'];
                $modulo = $_POST['inputModulo'];
                $tipo_solicitud = $_POST['inputSolicitud'];
                $fecha_requerida = $_POST['inputFechaRequerida'];
                $observaciones = $_POST['inputDetalleSolicitud'];
                $data_adjuntos = $_POST['data_adjuntos'];
				$update_adjuntos = $_POST['update_adjuntos'];
                
                $idcuenta = trim($this->session->userdata('idaccount'));
                $descrip_adjuntos = ""; $msg_error = "";
                
                if($update_adjuntos == 1){
                    if(isset($_FILES["input_img_1"])){
                        $File_Adj = $_FILES["input_img_1"];
                        $nombre_adjunto = $File_Adj["name"];

                        if($nombre_adjunto != ""){
                            $nameExplode = explode(".", $nombre_adjunto);
                            $name_archivo = trim($nameExplode[0]);
                            $name_archivo_update = $name_archivo.".".$nameExplode[1];

                            $config['upload_path'] =  "doc_adjuntos/";
                            $config['file_name'] = $name_archivo;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "*";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);

                            if($this->upload->do_upload('input_img_1')){
                                $descrip_adjuntos = $name_archivo_update;
                            }else{
                                $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                                echo $msg_error;
                            }
                        }
                    }
                    
                    if(isset($_FILES["input_img_2"])){
                        $File_Adj = $_FILES["input_img_2"];
                        $nombre_adjunto = $File_Adj["name"];

                        if($nombre_adjunto != ""){
                            $nameExplode = explode(".", $nombre_adjunto);
                            $name_archivo = trim($nameExplode[0]);
                            $name_archivo_update = $name_archivo.".".$nameExplode[1];

                            $config['upload_path'] =  "doc_adjuntos/";
                            $config['file_name'] = $name_archivo;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "*";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);

                            if($this->upload->do_upload('input_img_2')){
                                if($descrip_adjuntos != ""){
                                    $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                                }else{
                                    $descrip_adjuntos = $name_archivo_update;
                                }
                            }else{
                                $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                                echo $msg_error;
                            }
                        }
                    }
                    
                    if(isset($_FILES["input_img_3"])){
                        $File_Adj = $_FILES["input_img_3"];
                        $nombre_adjunto = $File_Adj["name"];

                        if($nombre_adjunto != ""){
                            $nameExplode = explode(".", $nombre_adjunto);
                            $name_archivo = trim($nameExplode[0]);
                            $name_archivo_update = $name_archivo.".".$nameExplode[1];

                            $config['upload_path'] =  "doc_adjuntos/";
                            $config['file_name'] = $name_archivo;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "*";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);

                            if($this->upload->do_upload('input_img_3')){
                                if($descrip_adjuntos != ""){
                                    $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                                }else{
                                    $descrip_adjuntos = $name_archivo_update;
                                }
                            }else{
                                $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                            }
                        }
                    }
                    
                    if(isset($_FILES["input_img_4"])){
                    $File_Adj = $_FILES["input_img_4"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('input_img_4')){
                            if($descrip_adjuntos != ""){
                                $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                            }else{
                                $descrip_adjuntos = $name_archivo_update;
                            }
                        }else{
                            $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                        }
                    }
                }
                }
				
                if($update_adjuntos == 0){
					$descrip_adjuntos = $data_adjuntos;
				}
				
                $this->load->model('media_model');
                $this->media_model->actualizarRegistroEnvioTicket($idticket, $estado, $modulo, $tipo_solicitud, $fecha_requerida, $observaciones, $descrip_adjuntos);
                $informacion = $this->media_model->getListadoTicketsCuenta($idcuenta);
                
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $date1 = new DateTime($info->fecha);
                        $date2 = new DateTime($fecha_actual);
                        $diferencia = $date1->diff($date2);

                        $dataSource[$i] = array(
                           "idticket" => $info->idticket,
                            "idaccount" => $info->idaccount,
                            "estado" => $info->estado,
                            "fecha" => $info->fecha,
                            "fecha_vence" => $info->fecha_vence,
                            "solicitadox" => $info->solicitadox,
                            "modulo" => $info->modulo,
                            "idgestion" => $info->idgestion,
                            "descrip" => $info->descrip,
                            "dias" => $diferencia->days,
                            "adjuntos" => $info->adjuntos
                        );

                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }
        
        function insertarEnvioNuevoTicket(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d");
                
                $estado = $_POST['inputEstados'];
                $id_cuenta = $_POST['inputCodigoCuenta'];
                $solicitado_por = $_POST['inputSolicitadoPor'];
                $modulo = $_POST['inputModulo'];
                $tipo_solicitud = $_POST['inputSolicitud'];
                $fecha = $_POST['inputFecha'];
                $fecha_requerida = $_POST['inputFechaRequerida'];
                $observaciones = $_POST['inputDetalleSolicitud'];
                
                $idcuenta = trim($this->session->userdata('idaccount'));
                $descrip_adjuntos = ""; $msg_error = "";
                
                if(isset($_FILES["input_img_1"])){
                    $File_Adj = $_FILES["input_img_1"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('input_img_1')){
                            $descrip_adjuntos = $name_archivo_update;
                        }else{
                            $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                            echo $msg_error;
                        }
                    }
                }
                
                if(isset($_FILES["input_img_2"])){
                    $File_Adj = $_FILES["input_img_2"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('input_img_2')){
                            if($descrip_adjuntos != ""){
                                $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                            }else{
                                $descrip_adjuntos = $name_archivo_update;
                            }
                        }else{
                            $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                            echo $msg_error;
                        }
                    }
                }
                
                if(isset($_FILES["input_img_3"])){
                    $File_Adj = $_FILES["input_img_3"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('input_img_3')){
                            if($descrip_adjuntos != ""){
                                $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                            }else{
                                $descrip_adjuntos = $name_archivo_update;
                            }
                        }else{
                            $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                        }
                    }
                }
                
                if(isset($_FILES["input_img_4"])){
                    $File_Adj = $_FILES["input_img_4"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('input_img_4')){
                            if($descrip_adjuntos != ""){
                                $descrip_adjuntos = $descrip_adjuntos.",".$name_archivo_update;
                            }else{
                                $descrip_adjuntos = $name_archivo_update;
                            }
                        }else{
                            $msg_error = "Error, al subir adjunto (".$name_archivo.")";
                        }
                    }
                }
                
                $this->load->model('media_model');
                $this->media_model->insertarRegistroEnvioTicket($estado, $id_cuenta, $solicitado_por, $modulo, $tipo_solicitud, $fecha, $fecha_requerida, $observaciones, $descrip_adjuntos);
                $informacion = $this->media_model->getListadoTicketsCuenta($idcuenta);
                
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $date1 = new DateTime($info->fecha);
                        $date2 = new DateTime($fecha_actual);
                        $diferencia = $date1->diff($date2);

                        $dataSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idaccount" => $info->idaccount,
                            "estado" => $info->estado,
                            "fecha" => $info->fecha,
                            "fecha_vence" => $info->fecha_vence,
                            "solicitadox" => $info->solicitadox,
                            "modulo" => $info->modulo,
                            "idgestion" => $info->idgestion,
                            "descrip" => $info->descrip,
                            "dias" => $diferencia->days,
                            "adjuntos" => $info->adjuntos
                        );

                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }
        
        function getListadoTicketsCuentaCalendario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcuenta = trim($this->session->userdata('idaccount'));
                
                $this->load->model('media_model');
                $informacion = $this->media_model->getListadoTicketsCuenta($idcuenta);
                
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "text" => $info->descrip,
                            "startDate" => $info->fecha . ' 00:00:00',
                            "endDate" => $info->fecha . ' 23:59:59'
                        );

                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }
        
        function mantenimiento_tickets_soporte($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
				);
				$this->session->set_userdata($resultAppName);
                
                $this->load->model('media_model');
                
                $this->data['estados'] = $this->media_model->getListadoEstadosTickets();
                $this->data['modulos'] = $this->media_model->getListadoModulosTickets();
                $this->data['tipos'] = $this->media_model->getListadoTiposTickets();
                
				$this->load->view('mantenimiento_support_general', $this->data);
            }
        }
        
        function getListadoTicketsGeneral(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d");
                
                $idcuenta = trim($this->session->userdata('idaccount'));
                
                $this->load->model('media_model');
                $informacion = $this->media_model->getListadoTicketsGeneral($idcuenta);
                
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $date1 = new DateTime($info->fecha);
                        $date2 = new DateTime($fecha_actual);
                        $diferencia = $date1->diff($date2);
						
                        $dataSource[$i] = array(
                            "idticket" => $info->idticket * 1,
                            "nameempresa" => $info->nameempresa,
                            "estado" => $info->estado * 1,
                            "fecha" => $info->fecha,
                            "solicitadox" => $info->solicitadox,
                            "idgestion" => $info->idgestion * 1,
                            "fecha_vence" => $info->fecha_vence,
                            "modulo" => $info->modulo * 1,
                            "descrip" => $info->descripsoli,
                            "adjuntos" => $info->adjuntos,
                            "dias" => $diferencia->days,
                            "idaccount" => $info->idaccount,
                            "nameempresa" => $info->nameempresa
                        );
						
                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }
        
        function getListadoTicketsGeneralCalendario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcuenta = trim($this->session->userdata('idaccount'));
                
                $this->load->model('media_model');
                $informacion = $this->media_model->getListadoTicketsGeneral($idcuenta);
                
                $i=0;
                $dataSource = array();
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "text" => $info->descripsoli,
                            "nameempresa" => $info->nameempresa,
                            "startDate" => $info->fecha . ' 00:00:00',
                            "endDate" => $info->fecha . ' 23:59:59'
                        );
						
                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }
		
		function importacionDatos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
					'appName' => 'Migracion De Datos',
                    'namePage' => 'Migracion De Datos'
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('gerencia_model');
				$this->data['tablas_system'] = $this->gerencia_model->getListadoTablasSystem();
				
				$this->load->view('mantenimiento_importacion_datos', $this->data);
			}
		}
		
		function generarEstructuraExcel(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$name_table = $this->input->post('name_table');
				
				$this->load->model('gerencia_model');
				$this->gerencia_model->getEstructuraExcelTable($name_table);
			}
		}
		
		function getListadoHojasArchivo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$infoFile = $_FILES["inputArchivo"];
				$nameDocument = $infoFile["name"];
				$documentTemp = $infoFile['tmp_name'];
                
				$config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
				$config['file_name'] = $nameDocument;
				$config['over_write'] = "TRUE";
				$config['allowed_types'] = "*";
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
                        
				if($this->upload->do_upload('inputArchivo')){
					$this->load->model('gerencia_model');
					$dataSource = $this->gerencia_model->getListadoHojasArchivo($documentTemp);
					
					$data_Source = array();
					$total = count($dataSource);
					
					for($i=0; $i<$total; $i++){
						$data_Source[$i] = array(
							"id" => $i,
							"text" => $dataSource[$i]
						);
					}
					
					unlink("./doc_cuentas/".$this->session->userdata('dirDocuments')."/". str_replace(' ', '_', $nameDocument));
				}
				
				echo json_encode($data_Source);
			}
		}
		
		function getListadoMatchColumnas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$indexSheet = $_POST["sheetSelection"];
				$nameTable = $_POST["name_table_pos"];
				
				$infoFile = $_FILES["inputArchivo"];
				$nameDocument = $infoFile["name"];
				$documentTemp = $infoFile['tmp_name'];
                
				$config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
				$config['file_name'] = $nameDocument;
				$config['over_write'] = "TRUE";
				$config['allowed_types'] = "*";
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
                        
				if($this->upload->do_upload('inputArchivo')){
					$this->load->model('gerencia_model');
					$dataSource = $this->gerencia_model->getListadoMatchColumnasTablaHoja($documentTemp, $indexSheet, $nameTable);
					
					unlink("./doc_cuentas/".$this->session->userdata('dirDocuments')."/". str_replace(' ', '_', $nameDocument));
				}
				
				echo json_encode($dataSource);
			}
		}
		
		function insertDatosByOption(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$indexSheet = $_POST["sheetSelection"];
				$nameTable = $_POST["name_table_pos"];
				$optionSelection = $_POST["optionSelection"];
				$primaryKey = $_POST["primaryKey"];
				
				$infoFile = $_FILES["inputArchivo"];
				$nameDocument = $infoFile["name"];
				$documentTemp = $infoFile['tmp_name'];
                
				$config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
				$config['file_name'] = $nameDocument;
				$config['over_write'] = "TRUE";
				$config['allowed_types'] = "*";
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
                        
				if($this->upload->do_upload('inputArchivo')){
					$this->load->model('gerencia_model');
                    
					if($optionSelection == 0){
                        if($primaryKey == ""){
                            $dataSource = $this->gerencia_model->insertarDatosImportacionExcel($documentTemp, $indexSheet, $nameTable);
                        }else{
                            $dataSource = $this->gerencia_model->insertarDatosImportacionExcelPrimaryKey($documentTemp, $indexSheet, $nameTable, $primaryKey);
                        }
					}
					
					unlink("./doc_cuentas/".$this->session->userdata('dirDocuments')."/". str_replace(' ', '_', $nameDocument));
				}
				
				echo json_encode($dataSource);
			}
		}
        
        function registrosPorTabla(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
					'appName' => 'Reporte de Tablas',
                    'namePage' => 'Reporte de Tablas'
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('gerencia_model');
				$this->load->view('mantenimiento_registros_tablas');
			}
        }
        
        function reporteTablas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $array = array();
                $i=0;
                $fecha_ini = $this->input->post("fechaini");
                $fecha_fin = $this->input->post("fechafin");
                $this->load->model('gerencia_model');
                
                $dataSource = $this->gerencia_model->registrosTablas();
                foreach($dataSource as $data){
                    $num_rows = $this->gerencia_model->num_rows_mes($data->table_name,$fecha_ini,$fecha_fin);
                    if($data->table_rows>0){
                        $porcentaje = ($num_rows/$data->table_rows) * 100;
                    }else{
                        $porcentaje = 0;    
                    }
                    $array[$i] = array(
                        "table_comment" => $data->table_comment,
                        "table_name" => $data->table_name,
                        "table_rows" => $data->table_rows,
                        "data_length" => ($data->data_length/1000),
                        "rows_mes" => $num_rows,
                        "crecimiento" => round($porcentaje,2)
                    );
                    $i++;
                }
                
                
				echo json_encode($array);
			}
		}
        
        function documentosEnLinea($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model("transacciones_model");
                $this->data['tipoNum'] = $this->transacciones_model->getTiposRegistros();
                
                $this->load->view('mantenimiento_docs_en_linea', $this->data);
            }
		}
        
		function mantenimiento_numeradores($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model("transacciones_model");
                $this->load->model('user_model');$this->load->model('caja_model');
                $this->data['sucursales'] = $this->user_model->getSucursales();
                $this->data['cajas'] = $this->caja_model->viewCajasCentros();
                $this->data['tipoNum'] = $this->transacciones_model->getTiposRegistros();
                $this->data['grupos'] = $this->transacciones_model->getGruposNumeradores();
                $this->load->view('mantenimiento_user_numeradores_update', $this->data);
            }
        }
        
        function adicionarSolicitudServicio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d");

                $iduser = $this->session->userdata('iduser');
                $inputFecha = $this->input->post('inputFecha');
                $infoSolicitud = $this->input->post('infoSolicitud');
                $idgestion = $this->input->post('inputSolicitud');
                $idcuenta = trim($this->session->userdata('idaccount'));

                $this->load->model('media_model');
                $this->media_model->adicionarSolicitudServicio($inputFecha, $infoSolicitud, $idgestion, $iduser, $idcuenta);
                $informacion = $this->media_model->getListadoTicketsCuenta($idcuenta, $iduser);
                
                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $date1 = new DateTime($info->fecha);
                        $date2 = new DateTime($fecha_actual);
                        $diferencia = $date1->diff($date2);

                        $dataSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idaccount" => $info->idaccount,
                            "estado" => $info->estado,
                            "fecha" => $info->fecha,
                            "idgestion" => $info->idgestion,
                            "descrip" => $info->descrip,
                            "categoria" => $info->categoria,
                            "gestion" => $info->gestion,
                            "nameCuenta" => $info->nameCuenta,
                            "user_name" => $info->user_name,
                            "dias" => $diferencia->days
                        );

                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }

        function getDetalleRegistroSolicitud(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idticket = $this->input->post('idticket');
                
                $this->load->model('media_model');
                $array = $this->media_model->getDetalleRegistroSolicitud($idticket);
                
                echo json_encode($array);
            }
        }

        function adicionarDetalleComentario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d");
                
                $idticket = $this->input->post('idticket');
                $comentario = $this->input->post('comentario');
                $iduser = $this->session->userdata('iduser');
                $idcuenta = trim($this->session->userdata('idaccount'));
                
                $this->load->model('media_model');
                $this->media_model->adicionarDetalleComentario($idticket, $comentario);
                $informacion = $this->media_model->getListadoTicketsCuenta($idcuenta, $iduser);
                
                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $date1 = new DateTime($info->fecha);
                        $date2 = new DateTime($fecha_actual);
                        $diferencia = $date1->diff($date2);

                        $dataSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idaccount" => $info->idaccount,
                            "estado" => $info->estado,
                            "fecha" => $info->fecha,
                            "idgestion" => $info->idgestion,
                            "descrip" => $info->descrip,
                            "categoria" => $info->categoria,
                            "gestion" => $info->categoria.' / '.$info->gestion,
                            "nameCuenta" => $info->nameCuenta,
                            "user_name" => $info->user_name,
                            "prioridad" => $info->prioridad,
                            "facturable" => $info->facturable,
                            "valor" => $info->valor * 1,
                            "dias" => $diferencia->days,
                            "idticket_parent" => 0,
                            "idnivel" => 0
                        );
                        $i++;
                        
                        $info_detalle = $this->media_model->getDetalleRegistroSolicitud($info->idticket);

                        if($info_detalle != false){
                            foreach($info_detalle as $infodet){
                                $dataSource[$i] = array(
                                    "idticket" => ' '.$infodet->itemline,
                                    "fecha" => $infodet->ingresa_format,
                                    "idsubgestion" => $infodet->idsubgestion,
                                    "descrip" => $infodet->notas,
                                    "gestion" => $infodet->nameSubgestion,
                                    "idticket_parent" => $info->idticket,
                                    "idnivel" => 1
                                );
        
                                $i++;
                            }
                        }
                    }
                }
                
                echo json_encode($dataSource);
            }
        }

        function insertarNuevoAdjuntoSolicitud(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d");
                
                $idticket = $_POST['idTicketAdjunto'];
                $iduser = $this->session->userdata('iduser');
                $idcuenta = trim($this->session->userdata('idaccount'));

                if(isset($_FILES["inputAdjuntos"])){
                    $File_Adj = $_FILES["inputAdjuntos"];
                    $nombre_adjunto = $File_Adj["name"];
                    
                    if($nombre_adjunto != ""){
                        $nameExplode = explode(".", $nombre_adjunto);
                        $name_archivo = trim($nameExplode[0]);
                        $name_archivo_update = $name_archivo.".".$nameExplode[1];
                        
                        $config['upload_path'] =  "doc_adjuntos/";
                        $config['file_name'] = $name_archivo;
                        $config['over_write'] = "TRUE";
						$config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('inputAdjuntos')){
                            $descripAdjuntos = $name_archivo_update;
                            $tipoError = 'success';
                            $mensaje = '¡Archivo adjuntado correctamente!';
                            
                            $this->load->model('media_model');
                            $this->media_model->adicionarDetalleAdjunto($idticket, $descripAdjuntos);
                            $informacion = $this->media_model->getListadoTicketsCuenta($idcuenta, $iduser);
                            
                            $i=0;
                            $dataSource = array();
                            if($informacion != false){
                                foreach($informacion as $info){
                                    $date1 = new DateTime($info->fecha);
                                    $date2 = new DateTime($fecha_actual);
                                    $diferencia = $date1->diff($date2);

                                    $dataSource[$i] = array(
                                        "idticket" => $info->idticket,
                                        "idaccount" => $info->idaccount,
                                        "estado" => $info->estado,
                                        "fecha" => $info->fecha,
                                        "idgestion" => $info->idgestion,
                                        "descrip" => $info->descrip,
                                        "categoria" => $info->categoria,
                                        "gestion" => $info->categoria.' / '.$info->gestion,
                                        "nameCuenta" => $info->nameCuenta,
                                        "user_name" => $info->user_name,
                                        "prioridad" => $info->prioridad,
                                        "facturable" => $info->facturable,
                                        "valor" => $info->valor * 1,
                                        "dias" => $diferencia->days,
                                        "idticket_parent" => 0,
                                        "idnivel" => 0
                                    );
                                    $i++;
                                    
                                    $info_detalle = $this->media_model->getDetalleRegistroSolicitud($info->idticket);

                                    if($info_detalle != false){
                                        foreach($info_detalle as $infodet){
                                            $dataSource[$i] = array(
                                                "idticket" => ' '.$infodet->itemline,
                                                "fecha" => $infodet->ingresa_format,
                                                "idsubgestion" => $infodet->idsubgestion,
                                                "descrip" => $infodet->notas,
                                                "gestion" => $infodet->nameSubgestion,
                                                "idticket_parent" => $info->idticket,
                                                "idnivel" => 1
                                            );
                    
                                            $i++;
                                        }
                                    }
                                }
                            }
                            
                            $infoSource = array(
                                "dataSource" => $dataSource,
                                "tipoError" => $tipoError,
                                "mensaje" => $mensaje
                            );
                            echo json_encode($dataSource);
                        }else{
                            $tipoError = 'error';
                            $mensaje = "¡Error!, No se ha podido adjuntar el archivo (".$name_archivo.")";

                            $infoSource = array(
                                "tipoError" => $tipoError,
                                "mensaje" => $mensaje
                            );
                            echo json_encode($dataSource);
                        }
                    }
                }
            
            }
        }

        function incomingRequest($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model("media_model"); $this->load->model("cliente_model");
                $this->data['clientes'] = $this->cliente_model->viewClienteActivo();
                $this->data['empleados'] = $this->cliente_model->verVendedoresActivo();
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;
                
                $this->load->view('mantenimiento_incoming_request', $this->data);
            }
        }

        function incomingRequest2(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'appName' => 'Registro De Tickets De Servicio',
                    'namePage' => 'Registro De Tickets De Servicio'
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model("media_model"); $this->load->model("cliente_model");
                $this->data['clientes'] = $this->cliente_model->viewClienteActivo();
                $this->data['empleados'] = $this->cliente_model->verVendedoresActivo();
                
                $this->load->view('mantenimiento_incoming_request', $this->data);
            }
        }

        function getTiposServicios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('media_model');
                $informacion = $this->media_model->getTiposServicios();

                echo json_encode($informacion);
            }
        }

        function getSubsTiposServicios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgestion = $this->input->post('idgestion');

                $this->load->model('media_model');
                $informacion = $this->media_model->getSubsTiposServicios($idgestion);

                echo json_encode($informacion);
            }
        }

        function getInformacionPopupTicket(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgestion = $this->input->post('idgestion');

                $this->load->model('media_model'); $this->load->model("cliente_model");
                $infocli   = $this->cliente_model->viewClienteActivo();
                $infoemp   = $this->cliente_model->verVendedoresActivo();
                $gestiones = $this->media_model->getSubsTiposServicios($idgestion);

                $i=0;
                $empleados=array();
                if($infoemp != false){
                    foreach($infoemp as $infoe){
                        $empleados[$i] = array(
                            "id" => $infoe->idauxi,
                            "descrip" => $infoe->descrip
                        );
                        $i++;
                    }
                }

                $i=0;
                $clientes=array();
                if($infocli != false){
                    foreach($infocli as $infoc){
                        $clientes[$i] = array(
                            "id" => $infoc->idauxi,
                            "descrip" => $infoc->descrip
                        );
                        $i++;
                    }
                }

                $array = array(
                    "clientes" => $clientes,
                    "empleados" => $empleados,
                    "gestiones" => $gestiones
                );

                echo json_encode($array);
            }
        }

        function getListadoSolicitudesPorEstado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $estado = $this->input->post('estado');

                $this->load->model('media_model');
                $informacion = $this->media_model->getListadoSolicitudesPorEstado($estado);
                
                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){

                        $dataSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idaccount" => $info->idaccount,
                            "estado" => $info->estado,
                            "fecha" => $info->fecha,
                            "idgestion" => $info->idgestion,
                            "descrip" => $info->descrip,
                            "categoria" => $info->categoria,
                            "gestion" => $info->categoria.' / '.$info->gestion,
                            "nameCuenta" => $info->nameCuenta,
                            "user_name" => $info->user_name,
                            "prioridad" => $info->prioridad,
                            "facturable" => $info->facturable,
                            "valor" => $info->valor * 1
                        );
                        $i++;
                    }
                }
                
                echo json_encode($dataSource);
            }
        }
        #----------------   ANALISIS DE TICKETS
        public function vgincomingRequest()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $resultAppName = array(
                    'namePage' => 'análisis de tickets'
                );
                date_default_timezone_set('America/El_Salvador');
			    $fecha = date_create()->format('Y-m-d');
                $ff = ((new DateTime($fecha))->modify('-10 day'))->format('Y-m-d');
                $this->session->set_userdata($resultAppName);
                $direccion = $this->uri->segment(1);
                $this->load->model('global_model');
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['fecha'] = $fecha;
                $this->data['fechaf'] = $ff;
                $this->load->view("mantenimiento_incoming_requestPiv", $this->data);
            }
        }

        function getDetalleSolicitudesTicket(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_act = date("Y-m-d");

                $fecha_ini = $this->input->post('fechaini');
                $fecha_fin = $this->input->post('fechafin');

                $this->load->model('media_model'); $this->load->model("auxi_model");
                $informacion = $this->media_model->getDetalleSolicitudesTicket($fecha_ini, $fecha_fin);

                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $nameCliente = $this->auxi_model->getDescripcionAuxi($info->idaccount);
                        $numCuenta = $this->auxi_model->getCuentaAuxi($info->idaccount);
                        $nameWorker = $this->auxi_model->getDescripcionAuxi($info->idworker);
                        $nameContacto = $this->auxi_model->getDescripcionContaco($info->user_name);
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($info->whodidit);

                        if($info->estado == 2 || $info->estado == 9){
                            $dias = date_diff(new DateTime($info->fecha), new DateTime($info->fcierre));
                        }else{
                            $dias = date_diff(new DateTime($info->fecha), new DateTime($fecha_act));
                        }

                        if($info->prioridad == 0){
                            $namePrioridad = "Baja";
                        }else if($info->prioridad == 1){
                            $namePrioridad = "Media";
                        }else if($info->prioridad == 2){
                            $namePrioridad = "Alta";
                        }else if($info->prioridad == 3){
                            $namePrioridad = "Muy Alta";
                        }

                        $dataSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idgestion" => $info->idgestion,
                            "id_gestion" => $info->id_gestion,
                            "sistema" => $info->sistema,
                            "idaccount" => $info->idaccount,
                            "numcuenta" => $numCuenta,
                            "idcontacto" => $info->user_name,
                            "user_name" => $nameCliente,
                            "nameContacto" => $nameContacto,
                            "fecha" => $info->fecha,
                            "fecha2" => $info->fecha2,
                            "fcierre" => $info->fcierre,
                            "hora" => $info->hora,
                            "descrip" => $info->descrip,
                            "prioridad" => $info->prioridad,
                            "idworker" => $info->idworker,
                            "name_asignado" => $nameWorker,
                            "estado" => $info->estado,
                            "gestion" => $info->gestion,
                            "name_gestion" => $info->name_gestion,
                            "printable" => $info->printable,
                            "namePrioridad" => $namePrioridad,
                            "notas" => $info->notas,
                            "ingresado" => $nameIngresado,
                            "option" => $this->media_model->getCountCommentsTickets($info->idticket),
                            "dias" => $dias->days
                        );
                        $i++;
                    }
                }

                $array = array(
                    "informacion" => $dataSource,
                    "numeroTickets" => $i
                );

                echo json_encode($array);
            }
        }

        function adicionarTicket(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_act = date("Y-m-d");

                $fecha     = $this->input->post('fecha');
                $gestion   = $this->input->post('gestion');
                $sistema   = $this->input->post('sistema');
                $cliente   = $this->input->post('cliente');
                $contacto  = $this->input->post('contacto');
                $asignado  = $this->input->post('asignado');
                $solicitud = $this->input->post('solicitud');
                $fecha_ini = $this->input->post('fechaini');
                $fecha_fin = $this->input->post('fechafin');
                
                $this->load->model('media_model'); $this->load->model("auxi_model");
                
                $idticket = $this->media_model->adicionarTicket($fecha, $gestion, $sistema, $cliente, $contacto, $asignado, $solicitud);
                $informacion = $this->media_model->getDetalleSolicitudesTicket($fecha_ini, $fecha_fin);

                $i=0; $position=0;
                $infoSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $nameCliente = $this->auxi_model->getDescripcionAuxi($info->idaccount);
                        $numCuenta = $this->auxi_model->getCuentaAuxi($info->idaccount);
                        $nameWorker = $this->auxi_model->getDescripcionAuxi($info->idworker);
                        $nameContacto = $this->auxi_model->getDescripcionContaco($info->user_name);
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($info->whodidit);

                        $dias = date_diff(new DateTime($info->fecha), new DateTime($fecha_act));

                        if($info->prioridad == 0){
                            $namePrioridad = "Baja";
                        }else if($info->prioridad == 1){
                            $namePrioridad = "Media";
                        }else if($info->prioridad == 2){
                            $namePrioridad = "Alta";
                        }else if($info->prioridad == 3){
                            $namePrioridad = "Muy Alta";
                        }

                        $infoSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idgestion" => $info->idgestion,
                            "id_gestion" => $info->id_gestion,
                            "sistema" => $info->sistema,
                            "idaccount" => $info->idaccount,
                            "numcuenta" => $numCuenta,
                            "idcontacto" => $info->user_name,
                            "user_name" => $nameCliente,
                            "nameContacto" => $nameContacto,
                            "fecha" => $info->fecha,
                            "fecha2" => $info->fecha2,
                            "fcierre" => $info->fcierre,
                            "hora" => $info->hora,
                            "descrip" => $info->descrip,
                            "prioridad" => $info->prioridad,
                            "idworker" => $info->idworker,
                            "name_asignado" => $nameWorker,
                            "estado" => $info->estado,
                            "gestion" => $info->gestion,
                            "name_gestion" => $info->name_gestion,
                            "printable" => $info->printable,
                            "namePrioridad" => $namePrioridad,
                            "notas" => $info->notas,
                            "ingresado" => $nameIngresado,
                            "option" => $this->media_model->getCountCommentsTickets($info->idticket),
                            "dias" => $dias->days
                        );
                        
                        if($info->idticket == $idticket){
                            $position = $i;
                        }

                        $i++;
                    }
                }

                $array = array(
                    "sourceTickets" => $infoSource,
                    "position" => $position,
                );

                echo json_encode($array);
            }
        }
        
        function adicionarTicketSimple(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_act = date("Y-m-d");

                $fecha     = $this->input->post('fecha');
                $gestion   = $this->input->post('gestion');
                $sistema   = $this->input->post('sistema');
                $cliente   = $this->input->post('cliente');
                $contacto  = $this->input->post('contacto');
                $asignado  = $this->input->post('asignado');
                $solicitud = $this->input->post('solicitud');
                
                $this->load->model('media_model'); $this->load->model("auxi_model");
                
                $idticket = $this->media_model->adicionarTicket($fecha, $gestion, $sistema, $cliente, $contacto, $asignado, $solicitud);
                $informacion = $this->media_model->getDetalleSolicitudTicket($idticket);

                $i=0;
                $infoSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $nameCliente = $this->auxi_model->getDescripcionAuxi($info->idaccount);
                        $numCuenta = $this->auxi_model->getCuentaAuxi($info->idaccount);
                        $nameWorker = $this->auxi_model->getDescripcionAuxi($info->idworker);
                        $nameContacto = $this->auxi_model->getDescripcionContaco($info->user_name);
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($info->whodidit);

                        $dias = date_diff(new DateTime($info->fecha), new DateTime($fecha_act));

                        if($info->prioridad == 0){
                            $namePrioridad = "Baja";
                        }else if($info->prioridad == 1){
                            $namePrioridad = "Media";
                        }else if($info->prioridad == 2){
                            $namePrioridad = "Alta";
                        }else if($info->prioridad == 3){
                            $namePrioridad = "Muy Alta";
                        }

                        $infoSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idgestion" => $info->idgestion,
                            "id_gestion" => $info->id_gestion,
                            "idaccount" => $info->idaccount,
                            "numcuenta" => $numCuenta,
                            "idcontacto" => $info->user_name,
                            "user_name" => $nameCliente,
                            "nameContacto" => $nameContacto,
                            "fecha" => $info->fecha,
                            "fecha2" => $info->fecha2,
                            "fcierre" => $info->fcierre,
                            "hora" => $info->hora,
                            "descrip" => $info->descrip,
                            "prioridad" => $info->prioridad,
                            "idworker" => $info->idworker,
                            "name_asignado" => $nameWorker,
                            "estado" => $info->estado,
                            "gestion" => $info->gestion,
                            "name_gestion" => $info->name_gestion,
                            "printable" => $info->printable,
                            "namePrioridad" => $namePrioridad,
                            "notas" => $info->notas,
                            "ingresado" => $nameIngresado,
                            "dias" => $dias->days
                        );
                        
                        $i++;
                    }
                }

                echo json_encode($infoSource);
            }
        }

        function modificarTicket(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_act = date("Y-m-d");

                $idticket  = $this->input->post('idticket');
                $gestion   = $this->input->post('gestion');
                $fecha   = $this->input->post('fecha');
                $sistema   = $this->input->post('sistema');
                $cliente   = $this->input->post('cliente');
                $contacto  = $this->input->post('contacto');
                $asignado  = $this->input->post('asignado');
                $solicitud = $this->input->post('solicitud');
                $fecha_ini = $this->input->post('fechaini');
                $fecha_fin = $this->input->post('fechafin');
                
                $this->load->model('media_model'); $this->load->model("auxi_model");
                
                $this->media_model->modificarTicket($idticket, $gestion, $fecha, $sistema, $cliente, $contacto, $asignado, $solicitud);
                $informacion = $this->media_model->getDetalleSolicitudesTicket($fecha_ini, $fecha_fin);

                $i=0; $position=0;
                $infoSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $nameCliente = $this->auxi_model->getDescripcionAuxi($info->idaccount);
                        $numCuenta = $this->auxi_model->getCuentaAuxi($info->idaccount);
                        $nameWorker = $this->auxi_model->getDescripcionAuxi($info->idworker);
                        $nameContacto = $this->auxi_model->getDescripcionContaco($info->user_name);
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($info->whodidit);

                        $dias = date_diff(new DateTime($info->fecha), new DateTime($fecha_act));

                        if($info->prioridad == 0){
                            $namePrioridad = "Baja";
                        }else if($info->prioridad == 1){
                            $namePrioridad = "Media";
                        }else if($info->prioridad == 2){
                            $namePrioridad = "Alta";
                        }else if($info->prioridad == 3){
                            $namePrioridad = "Muy Alta";
                        }

                        $infoSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idgestion" => $info->idgestion,
                            "id_gestion" => $info->id_gestion,
                            "sistema" => $info->sistema,
                            "idaccount" => $info->idaccount,
                            "numcuenta" => $numCuenta,
                            "idcontacto" => $info->user_name,
                            "user_name" => $nameCliente,
                            "nameContacto" => $nameContacto,
                            "fecha" => $info->fecha,
                            "fecha2" => $info->fecha2,
                            "fcierre" => $info->fcierre,
                            "hora" => $info->hora,
                            "descrip" => $info->descrip,
                            "prioridad" => $info->prioridad,
                            "idworker" => $info->idworker,
                            "name_asignado" => $nameWorker,
                            "estado" => $info->estado,
                            "gestion" => $info->gestion,
                            "name_gestion" => $info->name_gestion,
                            "printable" => $info->printable,
                            "namePrioridad" => $namePrioridad,
                            "notas" => $info->notas,
                            "ingresado" => $nameIngresado,
                            "option" => $this->media_model->getCountCommentsTickets($info->idticket),
                            "dias" => $dias->days
                        );

                        if($info->idticket == $idticket){
                            $position = $i;
                        }

                        $i++;
                    }
                }

                $array = array(
                    "sourceTickets" => $infoSource,
                    "position" => $position,
                );

                echo json_encode($array);
            }
        }

        function updateEstadoTicket(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_act = date("Y-m-d");

                $idticket  = $this->input->post('idticket');
                $estado    = $this->input->post('estado');
                $notas     = $this->input->post('notas');
                $fecha_ini = $this->input->post('fechaini');
                $fecha_fin = $this->input->post('fechafin');
                
                $this->load->model('media_model'); $this->load->model("auxi_model");
                
                $this->media_model->updateEstadoTicket($idticket, $estado, $notas);
                $informacion = $this->media_model->getDetalleSolicitudesTicket($fecha_ini, $fecha_fin);

                $i=0;
                $infoSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $nameCliente = $this->auxi_model->getDescripcionAuxi($info->idaccount);
                        $numCuenta = $this->auxi_model->getCuentaAuxi($info->idaccount);
                        $nameWorker = $this->auxi_model->getDescripcionAuxi($info->idworker);
                        $nameContacto = $this->auxi_model->getDescripcionContaco($info->user_name);
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($info->whodidit);

                        $dias = date_diff(new DateTime($info->fecha), new DateTime($fecha_act));

                        if($info->prioridad == 0){
                            $namePrioridad = "Baja";
                        }else if($info->prioridad == 1){
                            $namePrioridad = "Media";
                        }else if($info->prioridad == 2){
                            $namePrioridad = "Alta";
                        }else if($info->prioridad == 3){
                            $namePrioridad = "Muy Alta";
                        }
                        
                        $infoSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idgestion" => $info->idgestion,
                            "id_gestion" => $info->id_gestion,
                            "sistema" => $info->sistema,
                            "idaccount" => $info->idaccount,
                            "numcuenta" => $numCuenta,
                            "idcontacto" => $info->user_name,
                            "user_name" => $nameCliente,
                            "nameContacto" => $nameContacto,
                            "fecha" => $info->fecha,
                            "fecha2" => $info->fecha2,
                            "fcierre" => $info->fcierre,
                            "hora" => $info->hora,
                            "descrip" => $info->descrip,
                            "prioridad" => $info->prioridad,
                            "idworker" => $info->idworker,
                            "name_asignado" => $nameWorker,
                            "estado" => $info->estado,
                            "gestion" => $info->gestion,
                            "name_gestion" => $info->name_gestion,
                            "printable" => $info->printable,
                            "namePrioridad" => $namePrioridad,
                            "notas" => $info->notas,
                            "ingresado" => $nameIngresado,
                            "option" => $this->media_model->getCountCommentsTickets($info->idticket),
                            "dias" => $dias->days
                        );

                        $i++;
                    }
                }

                $array = array(
                    "sourceTickets" => $infoSource
                );

                echo json_encode($array);
            }
        }

        function getInformacionHistorialTickets(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idticket = $this->input->post('idticket');

                $this->load->model('media_model'); $this->load->model('auxi_model');
                $informacion = $this->media_model->getInformacionHistorialTickets($idticket);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($info->whodidit);
    
                        $array[$i] = array(
                            "idrec" => $info->idrec,
                            "idticket" => $info->idticket,
                            "idsubgestion" => $info->idsubgestion,
                            "descrip" => $info->descrip,
                            "notas" => $info->notas,
                            "whodidit" => $info->whodidit,
                            "ingresa" => $info->ingresa,
                            "ingresado" => $nameIngresado,
                        );
                        $i++;
                    }
                }           

                echo json_encode($array);
            }
        }

        function uploadCommentAttachment(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $error = 0;
                $id_ticket = $_POST['idTicket'];
                $comentarios = $_POST['inputComentarios'];

                $this->load->model('media_model'); $this->load->model('auxi_model');
                
                if(isset($_FILES["inputAttachment"])){
                    $infoFile = $_FILES["inputAttachment"];
                    $nameDocument = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    
                    if($nameDocument != ""){
                        $nameDocument = trim($nameDocument);
                        
                        $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                        $config['file_name'] = $nameDocument;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('inputAttachment')){
                            $this->media_model->insertarInformacionAdjunto($nameDocument, $id_ticket);
                            $error = 1;
                        }
                    }
                }

                if($error == 0){
                    $this->media_model->insertarComentarioTicket($id_ticket, $comentarios);
                }

                $informacion = $this->media_model->getInformacionHistorialTickets($id_ticket);

                $i=0;
                $infoSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($info->whodidit);
    
                        $infoSource[$i] = array(
                            "idrec" => $info->idrec,
                            "idticket" => $info->idticket,
                            "idsubgestion" => $info->idsubgestion,
                            "descrip" => $info->descrip,
                            "notas" => $info->notas,
                            "whodidit" => $info->whodidit,
                            "ingresa" => $info->ingresa,
                            "ingresado" => $nameIngresado,
                        );
                        $i++;
                    }
                }                

                $array = array(
                    "infoSource" => $infoSource,
                    "error" => $error
                );
                echo json_encode($array);
            }
        }

        function servicestypemaintance(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'appName' => 'Mantenimiento de Servicios',
                    'namePage' => 'Mantenimiento de Servicios'
                );
                $this->session->set_userdata($resultAppName);
                //$this->load->model("media_model"); $this->load->model("cliente_model");
                //$this->data['clientes'] = $this->cliente_model->viewClienteActivo();
                //$this->data['empleados'] = $this->cliente_model->verVendedoresActivo();
                $this->load->view('mantenimiento_services_type');
            }
        }

        function getServiceParents(){
            $this->load->model('media_model');
            $parents = $this->media_model->getParentsServicesType();
                       
            echo json_encode($parents);
        }

        function getServicesTypeList(){
            $this->load->model('media_model');
            $parents = $this->media_model->getParentsServicesType();

            $array_childrens = array();
            $j=0;

            //$this->highlight_array($parents);
            if($parents!=false){
                foreach($parents as $par){
                    $childrens = $this->media_model->getChildsServicesType($par->idgestion);

                    if($childrens!=false){
                        foreach($childrens as $child){
                            if($child->estado == 0){
                                $array_childrens[$j] = array(
                                    "idgestion"=>$child->idgestion,
                                    "nivel"=>$child->nivel,
                                    "idnivel1"=>$child->idnivel1,
                                    "descrip"=>$child->descrip,
                                    "links"=>$child->links,
                                    "prioridad"=>$child->prioridad,
                                    "facturable"=>$child->facturable,
                                    "valor"=>$child->valor,
                                    "printable"=>$child->printable,
                                    "grupo"=>$child->grupo,
                                    "estado" => $child->estado,
                                    "visibletoclient"=>$child->visibletoclient,
                                    "servicio"=>'SERVICIO INACTIVO',
                                );
                            }else{
                                $array_childrens[$j] = array(
                                    "idgestion"=>$child->idgestion,
                                    "nivel"=>$child->nivel,
                                    "idnivel1"=>$child->idnivel1,
                                    "descrip"=>$child->descrip,
                                    "links"=>$child->links,
                                    "prioridad"=>$child->prioridad,
                                    "facturable"=>$child->facturable,
                                    "valor"=>$child->valor,
                                    "printable"=>$child->printable,
                                    "grupo"=>$child->grupo,
                                    "estado" => $child->estado,
                                    "visibletoclient"=>$child->visibletoclient,
                                    "servicio"=>$par->descrip,
                                );
                            }

                            $j++;
                        }     
                    }
                }
            }

            echo json_encode($array_childrens);
        }

        function getServicesTypeListAllTime(){
            $this->load->model('media_model');
            $parents = $this->media_model->getParentsServicesType();
            
            $array = array();
            $i=0;
            
            if($parents!=false){
                foreach($parents as $par){
                    $childrens = $this->media_model->getChildsServicesType($par->idgestion);
                    $array_childrens = array();
                    $j=0;

                    if($childrens!=false){
                        foreach($childrens as $child){
                            $array_childrens[$j] = array(
                                "idgestion"=>$child->idgestion,
                                "nivel"=>$child->nivel,
                                "idnivel1"=>$child->idnivel1,
                                "descrip"=>$child->descrip,
                                "links"=>$child->links,
                                "prioridad"=>$child->prioridad,
                                "facturable"=>$child->facturable,
                                "valor"=>$child->valor,
                                "printable"=>$child->printable,
                                "grupo"=>$child->grupo,
                                "visibletoclient"=>$child->visibletoclient,
                            );
                            $j++;
                        }     
                    }
                    $array[$i] = array(
                        "idgestion"=>$par->idgestion,
                        "nivel"=>$par->nivel,
                        "idnivel1"=>$par->idnivel1,
                        "descrip"=>$par->descrip,
                        "childrens"=>$array_childrens,
                        "grupo"=>$par->grupo,
                    );
                    $i++;
                }
                
            }
            return $array;
        }
        
        function insertGestion(){

            $titulo = $this->input->post("titulo");
            $grupo = $this->input->post("grupo");

            $this->load->model('media_model');
            $insertGestion = $this->media_model->insertGestion($titulo,$grupo);
            
            $array = $this->getServicesTypeListAllTime();

            echo json_encode($array);

        }

        function insertService(){

            $idnivel1 = $this->input->post("idgestion");
            $descrip = $this->input->post("descrip");
            $grupo = $this->input->post("grupo");
            $detalle = $this->input->post("detalle");
            $fac = $this->input->post("facturable");
            $impri = $this->input->post("imprimible");
            $visi = $this->input->post("visible");
            $prioridad = $this->input->post("prioridad");
            $valor = $this->input->post("valor");
            
            if($fac == 'true'){
                $facturable=1;
            }else{
                $facturable=0;
            }
            
            if($impri == 'true'){
                $imprimible=1;
            }else{
                $imprimible=0;
            }
            
            if($visi == 'true'){
                $visible=1;
            }else{
                $visible=0;
            }

            $this->load->model('media_model');
            $insertService = $this->media_model->insertService($idnivel1,$descrip,$grupo,$detalle,$facturable,$imprimible,$visible,$prioridad,$valor);
            
            $array = $this->getServicesTypeListAllTime();

            echo json_encode($array);

        }

        function updateGestion(){

            $idgestion = $this->input->post("idgestion");
            $descrip = $this->input->post("descrip");
            $grupo = $this->input->post("grupo");
            
            $this->load->model('media_model');
            $updateGestion = $this->media_model->updateGestion($idgestion,$descrip,$grupo);
            
            $array = $this->getServicesTypeList();

            echo($array);
        }

        function updateService(){

            $idgestion = $this->input->post("idgestion");
            $descrip = $this->input->post("descrip");
            $grupo = $this->input->post("grupo");
            $detalle = $this->input->post("detalle");
            $fac = $this->input->post("facturable");
            $impri = $this->input->post("imprimible");
            $visi = $this->input->post("visible");
            $prioridad = $this->input->post("prioridad");
            $valor = $this->input->post('valor');
            $estado = $this->input->post('estado');
            $nivel1 = $this->input->post('nivel1');

            if($estado == 'true'){
                $estado=1;
            }else{
                $estado=0;
            }

            if($fac == 'true'){
                $facturable=1;
            }else{
                $facturable=0;
            }
            
            if($impri == 'true'){
                $imprimible=1;
            }else{
                $imprimible=0;
            }
            
            if($visi == 'true'){
                $visible=1;
            }else{
                $visible=0;
            }

            $this->load->model('media_model');

            $updateService = $this->media_model->updateService($idgestion,$descrip,$grupo,$detalle,$facturable,$imprimible,$visible,$prioridad,$valor,$estado, $nivel1);
            
            echo json_encode($updateService);
        }

        function sendBusqueda(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idgestion = $this->input->post("tipo_Gestion");
                $busqueda = $this->input->post("search");

                $resultAppName = array(
                    'appName' => 'Resultados de Busqueda',
                    'namePage' => 'Resultados de Busqueda'
                );
                $this->session->set_userdata($resultAppName);
                
                $dataSource = array(
                    "idgestion" => $idgestion,
                    "busqueda" => $busqueda
                );

                $this->session->set_userdata($dataSource);

                echo json_encode(true);
            }
        }

        function openNewTabBusqueda(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model("media_model"); $this->load->model("cliente_model");
                $this->data['clientes'] = $this->cliente_model->viewClienteActivo();
                $this->data['empleados'] = $this->cliente_model->verVendedoresActivo();
                $this->load->view('resultados_de_busqueda', $this->data);
            }
        }

        function getResultadosDeBusqueda(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_act = date("Y-m-d");

                $idgestion = $this->session->userdata('idgestion');
                $busqueda = $this->session->userdata("busqueda");

                $arrayGestiones= explode(",", $idgestion);

                $this->load->model('media_model'); $this->load->model('auxi_model');
                $informacion = $this->media_model->getBusquedaResultados($busqueda, $arrayGestiones);
                
                $i=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $nameCliente = $this->auxi_model->getDescripcionAuxi($info->idaccount);
                        $numCuenta = $this->auxi_model->getCuentaAuxi($info->idaccount);
                        $nameWorker = $this->auxi_model->getDescripcionAuxi($info->idworker);
                        $nameContacto = $this->auxi_model->getDescripcionContaco($info->user_name);
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($info->whodidit);

                        $dias = date_diff(new DateTime($info->fecha), new DateTime($fecha_act));

                        if($info->prioridad == 0){
                            $namePrioridad = "Baja";
                        }else if($info->prioridad == 1){
                            $namePrioridad = "Media";
                        }else if($info->prioridad == 2){
                            $namePrioridad = "Alta";
                        }else if($info->prioridad == 3){
                            $namePrioridad = "Muy Alta";
                        }

                        $dataSource[$i] = array(
                            "idticket" => $info->idticket,
                            "idgestion" => $info->idgestion,
                            "id_gestion" => $info->id_gestion,
                            "idaccount" => $info->idaccount,
                            "numcuenta" => $numCuenta,
                            "idcontacto" => $info->user_name,
                            "user_name" => $nameCliente,
                            "nameContacto" => $nameContacto,
                            "fecha" => $info->fecha,
                            "fecha2" => $info->fecha2,
                            "hora" => $info->hora,
                            "descrip" => $info->descrip,
                            "prioridad" => $info->prioridad,
                            "idworker" => $info->idworker,
                            "name_asignado" => $nameWorker,
                            "estado" => $info->estado,
                            "gestion" => $info->gestion,
                            "name_gestion" => $info->name_gestion,
                            "printable" => $info->printable,
                            "namePrioridad" => $namePrioridad,
                            "notas" => $info->notas,
                            "ingresado" => $nameIngresado,
                            "dias" => $dias->days
                        );
                        $i++;
                    }
                }

                echo json_encode($dataSource);   
            }
        }
        #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #------------------------------------------------------------------  MENSAJES------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        function mensajesClientes($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $appInformacion = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($appInformacion);
                
                $funcion = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($funcion);

                $this->load->view('mantenimiento_mensajes_clientes', $this->data);
            }
        }
        #   GET MENSAJES
        function getMensajes(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');
                    $mensajes = $this->media_model->getMensajes();        
                    foreach ($mensajes as $mensaje) {
                        $status = $mensaje->estado == 1 ? 'Publicado' : 'Inactivo';
                        $MensajeS[] = array(
                            'estado' => $status, 
                            'id' => $mensaje->idrec,
                            'fecha' => $mensaje->fecha,
                            'titulo' => $mensaje->descrip,
                            'mensaje' => $mensaje->mensaje
                        );
                    }
                echo json_encode($MensajeS);
                }
                else{
                    show_404();
                }
            }
        }
        #   FIN GET MENSAJES
        #   GET CUENTAS
        function getCuentas(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');
                    if ($cuentas = $this->media_model->getCuentas()) {
                        $datA[] = array('valido' => true);
                        $datA[] = $cuentas;
                    } else $datA[] = array('valido' => false);
                    echo json_encode($datA);
                } else show_404();
            }
        }
        #   FIN GET CUENTAS
        #   SET MENSAJE = NEUVO MENSAJE
        function setMensaje(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');

                    date_default_timezone_set('America/El_Salvador');
                    $ahora = date_create()->format('Y-m-d H:i:s');

                    $data = array(
                        'descrip' => $this->input->post("titulo"), 
                        'fecha' => $this->input->post("fecha"), 
                        'mensaje' => $this->input->post("mensaje"), 
                        'cuentas' => $this->input->post("cuentas"), 
                        'estado' => ($this->input->post("estado") == "true") ? 1 : 0,
                        'whodidit' => $this->session->userdata('iduser'), 
                        'ingresa' => $ahora
                    );
                    //echo json_encode($this->input->post());
                    if ($dato = $this->media_model->setMensaje($data)) {
                        $datA[] = array('valido' => true);
                        $datA[] = $dato;
                    } else $datA[] = array('valido' => false);
                    echo json_encode($datA);
                } else show_404();
            }
        }
        #   FIN SET MENSAJE
        #   GET MENSAJE
        function getMensaje(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    //echo json_encode($this->input->post());
                    $this->load->model('media_model');
                    $id = $this->input->post("ID");
                    if ($dato = $this->media_model->getMensaje($id)) {
                        $datA[] = array('valido' => true);
                        $datA[] = $dato;
                    } else $datA[] = array('valido' => false);
                    echo json_encode($datA);
                } else show_404();
            }
        }
        #   FIN GET MENSAJE
        #   UPDATE MENSAJE
        function updateMensaje(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');
                    
                    date_default_timezone_set('America/El_Salvador');
                    $update = date_create()->format('Y-m-d H:i:s');

                    $data = array(
                        'ID' => $this->input->post("ID"),
                        'descrip' => $this->input->post("titulo"), 
                        'fecha' => $this->input->post("fecha"), 
                        'mensaje' => $this->input->post("mensaje"), 
                        'cuentas' => $this->input->post("cuentas"), 
                        'estado' => ($this->input->post("estado") == "true") ? 1 : 0,
                        'modifica' => $update
                    );
                    if ($dato = $this->media_model->updateMensaje($data)) {
                        $datA[] = array('valido' => true);
                        $datA[] = $dato;
                    } else $datA[] = array('valido' => false);
                    echo json_encode($datA);
                } else show_404();
            }
        }
        #   FIN UPDATE MENSAJE
        #------------------------------------------------------------------ FIN MENSAJES--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #------------------------------------------------------------------ TICKETS DIRECT -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        public function mis_ticketsG()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else $this->load->view('mantenimiento_TicketsD');
        }
        #   GET GESTORES
        public function getGestoresT()
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');
                    $Datos = [];
                    $datos = $this->media_model->getGestoresT(3);
                    if ($datos->num_rows() > 0){
                        foreach ($datos->result() as $dato) {
                            $Datos[] = array(
                                'ID' => $dato->id,
                                'Name' => $dato->descrip
                            );
                        }
                    }
                    $datA[] = array('datos' => $Datos);
                    echo json_encode($datA);
                } else show_404();
            }
        }
        #   GET TICKETES POR GESTOR
        public function getRegistrosT()
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d H:i:s');
                $this->load->model('media_model');
                $prioridad = array(
                    'Baja' => 0,
                    'Media' => 1,
                    'Alta' => 2,
                    'Muy Alta' => 3
                );
                $Datos = [];
                $datos = $this->media_model->getRegistrosT($this->input->post("ID"));
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $f1 = ($dato->estado == 0 || $dato->estado == 1) ? new DateTime($ahora) : new DateTime($dato->fecha);
                        $f2 = ($dato->estado == 0 || $dato->estado == 1) ? new DateTime($dato->fecha) : new DateTime($dato->fcierre);
                        $diferencia = $f1->diff($f2);

                        $cuenta = $this->media_model->getAuxiT($dato->idaccount);
                        $Datos[] = array(
                            'numero' => $dato->idticket,
                            'prioridad' => array_search($dato->prioridad, $prioridad),
                            'dias' => $diferencia->days,
                            'lin1' => $cuenta->descrip, // nombre cliente
                            'lin2' => $dato->ngestion, // gestion
                            'lin3'=> $dato->descrip, // descripcion

                            'idticket' => $dato->idticket,
                            'idaccount' => $dato->idaccount,
                            'idcontacto' => $dato->user_name,
                            'idworker' => $dato->idworker,
                            'idgestion' => $dato->idgestion,
                            'id_gestion' => $dato->id_gestion,
                            'gestion' => $dato->gestion,
                            'fecha' => $dato->fecha,
                            'user_name' => $cuenta->descrip,
                            'descrip' => $dato->descrip,
                            'notas' => $dato->notas,
                            'sistema' => $dato->sistema,

                            //'id' => $dato->iduser.'-'.$dato->idworker
                            'id' => $dato->iduser.'-'.$dato->idworker
                        );
                    }
                }
                echo json_encode($Datos);
            }
        }
        #   CLIENTES Y GESTORES
        public function getDataCET()
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $this->load->model('media_model');
                $Datos = []; #clientes
                $Datos1 = []; #empleados
                $datos = $this->media_model->getGestoresT(2);
                if ($datos->num_rows() > 0) {
                    foreach($datos->result() as $dato) {
                        $Datos[] = array(
                            'id' => $dato->id,
                            'descrip' => $dato->descrip,
                        );
                    }
                }
                $datos1 = $this->media_model->getGestoresT(3);
                if ($datos1->num_rows() > 0) {
                    foreach($datos1->result() as $dato) {
                        $Datos1[] = array(
                            'id' => $dato->id,
                            'descrip' => $dato->descrip,
                        );
                    }
                }
                $datA[] = array('clientes' => $Datos, 'empleados' => $Datos1);
                echo json_encode($datA);
            }
        }
        #------------------------------------------------------------------ TICKETS PDF -----------------------------------------
        public function TicketReporte ($ID = null)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($ID != null && is_numeric($ID)) {
                    $this->load->model('media_model');
                    $this->load->model("auxi_model");
                    $Ticket = $this->media_model->getTiketInfo($ID);
                    if (count((array)$Ticket) > 0) {
                        $empresa = $this->media_model->nombreEmpresa()->valor_memo;
                        $nameCliente = $this->auxi_model->getDescripcionAuxi($Ticket->idaccount);
                        $nameVendedor = $this->auxi_model->getDescripcionAuxi($Ticket->idworker);
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($Ticket->whodidit);
                        $numCuenta = $this->auxi_model->getCuentaAuxi($Ticket->idaccount);
                        $this->load->library('Pdf');
                        $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
						$pdf->SetCreator(PDF_CREATOR);
						$pdf->SetTitle('Ticket Reporte');
						$pdf->SetMargins(10, 5, 10);//lef top right
						$pdf->SetFont('helvetica', '', 9);
						$pdf->AddPage('P', 'LETTER');//p vertical l horizontal
                        //datos
                        $inicio = 0;
                        $colorborder = '#737373';
                        //$Ticket->descrip = $Ticket->descrip.'dfsaddfjsdlkqwpri dfasdfasdfa sfa sdl kjjgh FGJKDFSLGJDFLKGJDFKLS clxyjkgnjallk65432169-';
                        #   2 lineas
                        //$Ticket->descrip = $Ticket->descrip.'dsddddddfasdfasdfasfasdlkjjghjdkljagdhkgjnvjklchfdjagyjdnlckkclxyjkgnjallk6543216967567';
                        #   735
                        //$Ticket->descrip = $Ticket->descrip.'dfsaddfjsdlkqwpri dfasdfasdfa sfa sdl kjjgh FGJKDFSLGJDFLKGJDFKLS clxyjkgnjallk65432169- dasFAsdfasdfasdfdsgkjlsdajfoiwueoie   fFKLSADJKLVJASDKLJKLKDFJADKDFD\\NDdsffdfsgdfggfdsFADSFJ2525522';
                        #   3 lineas
                        //128 - maximo letras por fila
                        /*echo '<br>-'.strlen($Ticket->descrip);
                        echo '<br>-'.(strlen($Ticket->descrip) / 129);
                        /*echo '<br>-'.round(strlen($Ticket->descrip) / 129).'<hr>';
                        echo '<br>-'.round(strlen($Ticket->descrip) / 129, 0, PHP_ROUND_HALF_UP);//*/
                        $texto = explode("\n", $Ticket->descrip);
                        $valorbreak = count($texto) -1;
                        $inicio += $valorbreak;

                        $Ticket->descrip = implode("<br>", $texto);
                        $texto = str_replace("<br>", "", $Ticket->descrip);
                        foreach (explode("<br>", $Ticket->descrip) as $fila) {
                            $valor = (strlen($fila) / 129);
                            $valor2 = round($valor, 0, PHP_ROUND_HALF_UP);
                            $aumento = ($valor >= 1) ? $valor2 : 0;
                            $inicio += $aumento;
                        }
                        /*$valor = (strlen($texto) / 129);
                        $valor2 = round($valor, 0, PHP_ROUND_HALF_UP);
                        $inicio = ($valor >= 1) ? $valor2 : 0;//*/
                        //echo "<hr>".'v1-'.$valor.'-i-'.$inicio.'-v2-'.$valor2;
						$html = '
                            <table style="width: 100%;" >
                                <tr style="font-size: 15px; font-family: sans-serif;">
                                    <td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                                </tr>
                                <tr style="font-size: 14px; font-family: sans-serif;">
                                    <td style="width: 100%; text-align: center;"><strong>'.$nameCliente.' Cta: '.$numCuenta.'</strong></td>
                                </tr>
                                <tr><td style="line-height: 5px;"></td></tr>
                                <tr style="text-align: center;">
                                    <td style="width: 10%; border: 1px solid '.$colorborder.';"><strong>Fecha</strong></td>
                                    <td style="width: 10%; border: 1px solid '.$colorborder.';"><strong>Hora</strong></td>
                                    <td style="width: 10%; border: 1px solid '.$colorborder.';"><strong>Número</strong></td>
                                    <td style="width: 35%; border: 1px solid '.$colorborder.';"><strong>Asignado a:</strong></td>
                                    <td style="width: 35%; border: 1px solid '.$colorborder.';"><strong>Ingresado por:</strong></td>
                                </tr>
                                <tr style="text-align: center;">
                                    <td style="width: 10%; border: 1px solid '.$colorborder.';">'.date_format(date_create($Ticket->fecha), "d/m/Y").'</td>
                                    <td style="width: 10%; border: 1px solid '.$colorborder.';">'.date_format(date_create($Ticket->fecha), "H:i:s").'</td>
                                    <td style="width: 10%; border: 1px solid '.$colorborder.';">'.$Ticket->idticket.'</td>
                                    <td style="width: 35%; text-align: left; border: 1px solid '.$colorborder.';">'.$nameVendedor.'</td>
                                    <td style="width: 35%; text-align: left; border: 1px solid '.$colorborder.';">'.$nameIngresado.'</td>
                                </tr>
                                <tr><td style="line-height: 5px;"></td></tr>
                                <tr>
                                    <td style="width: 100%; font-size: 13px; text-align: center;"><strong>'.$Ticket->tipoServicio.'</strong></td>
                                </tr>
                                <tr>
                                    <td style="width: 100%; font-size: 13px; text-align: center;">'.$Ticket->ngestion.'</td>
                                </tr>
                                <tr><td style="line-height: 5px;"></td></tr>
                                <tr>
                                    <td style="width: 100%; font-size: 10px; border: 1px solid '.$colorborder.';">'.$Ticket->descrip.'</td>
                                </tr>
                        ';
                        for ($i = $inicio; $i < 36; $i++) {
                            //$html .='<tr><td style="font-size: 10px; border: 1px solid black;"> '.$i.'-'.$inicio.'</td></tr>';
                            $html .='<tr><td style="font-size: 13px; border: 1px solid '.$colorborder.';"> </td></tr>';
                        }
                        $html .= '</table>';
						$pdf->writeHTML($html);
						$pdf->lastPage();
						$pdf->Output();
                    } else echo "<h1>Ticket No existe</h1>";
                } else echo "<h1>Parámetro Incorecto</h1>";
            }
        }
        #------------------------------------------------------------------ FIN TICKETS DIRECT -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #------------------------------------------------------------------ BUSQ. CONTACTOS DIRECT ---------------------------------------------------------------------------------------------------------------------------------------------------------------------
        #   GET EMPRESAS DE CONTACTOS
        public function getEBCDirect()
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $Datos = [];
                $this->load->model('auxi_model');
                $datos = $this->auxi_model->getEmpresasECP();
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $Datos[] = array(
                            'ID' => (int)$dato->idauxi,
                            'Name' => $dato->descrip,
                            'tipo' => (int)$dato->idauxidef
                        );
                    }
                }
                echo json_encode($Datos);
            }
        }
        #   GET CONTACTOS POR NOMBRE O CARGO
        public function getBContactosD()
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $nombre = $this->input->post("nombre");
                $this->load->model('auximulti_model');
                $Datos = [];
                //empleados - 3
                //contacts clientes - 2
                //contacts proveedores - 1
                $datos = $this->auximulti_model->getCClientesProveedoresByDescripAOtro($nombre);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $Datos[] = array(
                            'ID' => (int)$dato->idrec,
                            'tipo' => (int)$dato->idauxidef,
                            'nombre' => $dato->otro,
                            'idempresa' => (int)$dato->idauxi,
                            'empresa' => $dato->empresa,
                            'telefono' => $dato->telefono,
                            'correo' => $dato->correo,
                            'cargo' => $dato->descrip
                        );
                    }
                }
                echo json_encode($Datos);
            }
        }
        #   SET CONTACTO
        public function setBContactosD()
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else { 
                $this->load->model('auximulti_model');
                date_default_timezone_set('America/El_Salvador');
                $data = array(
                    'idauxi' => $this->input->post("idempresa"),
                    'idgvar' => 2,
                    'descrip' => $this->input->post("cargo"),
                    'telefono' => $this->input->post("telefono"),
                    'correo' => $this->input->post("correo"),
                    'otro' => $this->input->post("nombre"),
                    'estatus' => 1, 
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($id = $this->auximulti_model->setBContactosD($data)) $datA[] = array('valido' => true, 'id' => $id);
                else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #   UPDATE CONTACTO
        public function updateBContactosD() {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $this->load->model('auximulti_model');
                date_default_timezone_set('America/El_Salvador');
                $ID = $this->input->post("ID");
                $data = array(
                    'idauxi' => $this->input->post("idempresa"),
                    'descrip' => $this->input->post("cargo"),
                    'telefono' => $this->input->post("telefono"),
                    'correo' => $this->input->post("correo"),
                    'otro' => $this->input->post("nombre"),
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->auximulti_model->updateBContactosD($data, $ID)) $datA[] = array('valido' => true);
                else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #   CHANGE ESTADO CONTACTO
        public function deleteBContactosD()
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $this->load->model('auximulti_model');
                date_default_timezone_set('America/El_Salvador');
                $ID = $this->input->post("ID");
                $data = array(
                    'estatus' => 0,
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->auximulti_model->updateBContactosD($data, $ID)) $datA[] = array('valido' => true);
                else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #------------------------------------------------------------------ FIN BUSQ. CONTACTOS DIRECT -----------------------------------------------------------------------------------------------------------------------------------------------------------------
        #---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        function brochureManager($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $appInformacion = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($appInformacion);
                
                $funcion = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($funcion);

                $this->load->view('mantenimiento_brochure_manager', $this->data);
            }
        }

        function getListadoProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('gerencia_model');
                $informacion = $this->gerencia_model->getListadoProductos(1);

                echo json_encode($informacion);
            }
        }

        function getInformacionBrochureProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');

                $this->load->model('gerencia_model');
                $informacion = $this->gerencia_model->getInformacionBrochureProducto($idproducto);

                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->notas != ""){
                            $estado = 1;
                        }else{
                            $estado = 0;
                        }

                        $array[$i] = array(
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "posicion" => $info->idcps,
                            "descrip" => $info->descrip,
                            "notas" => $info->notas,
                            "tipo" => $info->uniconv,
                            "estado" => $estado
                        );
                        
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function getListadoItemsBrochure(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $nameGvar = 'brochure_item';

                $this->load->model('gerencia_model');
                $array = $this->gerencia_model->getListadoItemsBrochure($nameGvar);

                echo json_encode($array);
            }
        }

        function insertInformacionBrochure(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $items = $this->input->post('items');
                $idproducto = $this->input->post('idproducto');

                $this->load->model('gerencia_model');
                $this->gerencia_model->insertInformacionBrochure($items, $idproducto);
                $informacion = $this->gerencia_model->getInformacionBrochureProducto($idproducto);

                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->notas != ""){
                            $estado = 1;
                        }else{
                            $estado = 0;
                        }

                        $array[$i] = array(
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "posicion" => $info->idcps,
                            "descrip" => $info->descrip,
                            "notas" => $info->notas,
                            "tipo" => $info->uniconv,
                            "estado" => $estado
                        );
                        
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function updateInformacionBrochure(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $texto = $this->input->post('texto');
                $nombre = $this->input->post('nombre');
                $posicion = $this->input->post('posicion');
                $idproducto = $this->input->post('idproducto');

                $this->load->model('gerencia_model');
                $this->gerencia_model->updateInformacionBrochure($idrec, $texto, $nombre, $posicion);
                $informacion = $this->gerencia_model->getInformacionBrochureProducto($idproducto);

                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->notas != ""){
                            $estado = 1;
                        }else{
                            $estado = 0;
                        }

                        $array[$i] = array(
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "posicion" => $info->idcps,
                            "descrip" => $info->descrip,
                            "notas" => $info->notas,
                            "tipo" => $info->uniconv,
                            "estado" => $estado
                        );
                        
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function updateImagenBrochure(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $error=0;
                $idrec = $_POST['idrec'];
                $idproducto = $_POST['idproducto'];
                
                $this->load->model('gerencia_model');
                
                if(isset($_FILES["inputFileImg"])){
                    $infoFile = $_FILES["inputFileImg"];
                    $nameDocument = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    
                    if($nameDocument != ""){
                        $nameDocument = str_replace(" ", "_", $nameDocument);
                        
                        $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                        $config['file_name'] = $nameDocument;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('inputFileImg')){
                            $this->gerencia_model->updateImagenBrochure($idrec, $nameDocument);
                            $error=1;
                        }
                    }
                }

                $informacion = $this->gerencia_model->getInformacionBrochureProducto($idproducto);

                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->notas != ""){
                            $estado = 1;
                        }else{
                            $estado = 0;
                        }

                        $array[$i] = array(
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "posicion" => $info->idcps,
                            "descrip" => $info->descrip,
                            "notas" => $info->notas,
                            "tipo" => $info->uniconv,
                            "estado" => $estado
                        );
                        
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function eliminarElementoBrochure(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idproducto = $this->input->post('idproducto');
                $notas = $this->input->post('notas');
                $tipo = $this->input->post('tipo');
                
                $this->load->model('gerencia_model');
                $this->gerencia_model->eliminarElementoBrochure($idrec);

                if($tipo == 2){
                    if($notas != ""){
                        unlink("./doc_cuentas/".$this->session->userdata('dirDocuments')."/". $notas);
                    }
                }

                $informacion = $this->gerencia_model->getInformacionBrochureProducto($idproducto);

                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->notas != ""){
                            $estado = 1;
                        }else{
                            $estado = 0;
                        }

                        $array[$i] = array(
                            "idrec" => $info->idrec,
                            "idproducto" => $info->idproducto,
                            "posicion" => $info->idcps,
                            "descrip" => $info->descrip,
                            "notas" => $info->notas,
                            "tipo" => $info->uniconv,
                            "estado" => $estado
                        );
                        
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        //JORGE RIVERA 20200312
        function controlDeLicencias($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $appInformacion = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($appInformacion);
                
                $funcion = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($funcion);

                $this->load->view('mantenimiento_control_licencias', $this->data);
            }
        }

        #   GET EMPRESAS    DEPARTAMENTO    
        public function getData(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');
                    if ($empresas = $this->media_model->getData(1)) {
                        if ($departamentos = $this->media_model->getData(2)) {
                            $datA[] = array('valido' => true);
                            //print_r($empresas);
                            $cont = 0;
                            foreach ($empresas as $empresa) {
                                $EmpresaS[] = array(
                                    'id' => "".$cont++,
                                    'empresa' => $empresa->empresa
                                );
                            }

                            $cont = 0;
                            foreach ($departamentos as $departamento) {
                                $DepartamentoS[] = array(
                                    'id' => "".$cont++,
                                    'departamento' => $departamento->depto
                                );
                            }

                            $datA[] = $EmpresaS;
                            $datA[] = $DepartamentoS;
                        } else {
                            $datA[] = array('valido' => false);
                            $datA[] = array('tipo' => 'departamentos');
                            # surgio error en el modelo - departamento
                        }
                    }else{
                        $datA[] = array('valido' => false);
                        $datA[] = array('tipo' => 'empresas');
                        # surgio error en el modelo - empresas
                    }
                    echo json_encode($datA);
                }
                else{
                    show_404();
                }
            }  
        }
        #   FIN GET EMPRESAS    DEPARTAMENTO    
        #
        #   GET LICENCIAS
        public function getLicencias(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');
                    $licencias = $this->media_model->getLicencias();
                    echo json_encode($licencias);
                }
                else{
                    show_404();
                }
            }
        }
        #   FIN GET LICENCIAS
        #
        #   SET LICENCIA
        public function setLicencia(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');
                    
                    date_default_timezone_set('America/El_Salvador');
                    $ahora = date_create()->format('Y-m-d H:i:s');
                    $data = array(
                        'empresa' => $this->input->post("razon"), 
                        'sucursal' => $this->input->post("sucursal"), 
                        'fecha' => $this->input->post("fecha"), 
                        'idcaja' => $this->input->post("caja"), 
                        'nit' => $this->input->post("nit"),
                        'idregiva' => $this->input->post('nrc'),
                        'giro' => $this->input->post('giro'), 
                        'direccion' => $this->input->post('direccion'), 
                        'depto' => $this->input->post('departamento'), 
                        'marca' => $this->input->post('marca'), 
                        'modelo' => $this->input->post('modelo'), 
                        'serie' => $this->input->post('serie'), 
                        'rfecha' => $this->input->post('Rfecha'), 
                        'rnumero' => $this->input->post('resolucion'),
                        'cartel'=> '',
                        'notas' => $this->input->post('notas'),
                        'estado' => $this->input->post('estado'), 
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => $ahora
                    );
                    if ($dato = $this->media_model->setLicencia($data)) {
                        $datA[] = array('valido' => true);
                        $datA[] = $dato;
                    }else{
                        $datA[] = array('valido' => false);
                        # surgio error en el modelo
                    }
                    echo json_encode($datA);
                }
                else{
                    show_404();
                }
            }
        }
        #   FIN SET LICENCIA
        #
        #   GET LICENCIA
        public function getLicencia(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');
                    $id = $this->input->post("ID");
                    if ($dato = $this->media_model->getLicencia($id)) {
                        $cont = 0;
                        if ($sucursales = $this->media_model->getDataEmpresa($dato->empresa, 2)) {
                            foreach ($sucursales as $sucursal) {
                                $SucursaleS[] = array(
                                    'id' => "".$cont++,
                                    'sucursal' => $sucursal->sucursal
                                );
                            }
                        }
                        
                        $datA[] = array('valido' => true);                    
                        $datA[] = $dato;
                        $datA[] = ($cont == 0) ? [] : $SucursaleS;
                    }else{
                        $datA[] = array('valido' => false);
                        # surgio error en el modelo
                    }
                    echo json_encode($datA);
                }
                else{
                    show_404();
                }
            }
        }
        #   FIN GET LICENCIA
        #
        #   UPDATE LICENCIA
        public function updateLicencia(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');
                    
                    date_default_timezone_set('America/El_Salvador');
                    $ahora = date_create()->format('Y-m-d H:i:s');
                    $data = array(
                        'ID' => $this->input->post("licencia"), 
                        'empresa' => $this->input->post("razon"), 
                        'sucursal' => $this->input->post("sucursal"),
                        'idcaja' => $this->input->post("caja"), 
                        'nit' => $this->input->post("nit"),
                        'idregiva' => $this->input->post('nrc'),
                        'giro' => $this->input->post('giro'), 
                        'direccion' => $this->input->post('direccion'), 
                        'depto' => $this->input->post('departamento'), 
                        'marca' => $this->input->post('marca'), 
                        'modelo' => $this->input->post('modelo'), 
                        'serie' => $this->input->post('serie'), 
                        'rfecha' => $this->input->post('Rfecha'), 
                        'rnumero' => $this->input->post('resolucion'),
                        'notas' => $this->input->post('notas'),
                        'estado' => $this->input->post('estado'),
                        'update' => $ahora
                    );
                    if ($dato = $this->media_model->updateLicencia($data)) {
                        $datA[] = array('valido' => true);
                        $datA[] = $dato;
                    }else{
                        $datA[] = array('valido' => false);
                        # surgio error en el modelo
                    }
                    echo json_encode($datA);
                }
                else{
                    show_404();
                }
            }
        }
        #   FIN UPDATE LICENCIA
        #
        #   GET DATA EMPRESA
        public function getDataEmpresa(){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                if ($this->input->is_ajax_request()) {
                    $this->load->model('media_model');
                    $empresa = $this->input->post("empresa");
                    //echo "-".$empresa;
                    
                    if ($datos = $this->media_model->getDataEmpresa($empresa, 1)) {
                        $cont = 0;
                        if ($sucursales = $this->media_model->getDataEmpresa($empresa, 2)) {
                            foreach ($sucursales as $sucursal) {
                                $SucursaleS[] = array(
                                    'id' => "".$cont++,
                                    'sucursal' => $sucursal->sucursal
                                );
                            }
                        }
                        $datA[] = array('valido' => true);
                        $datA[] = $datos;
                        $datA[] = ($cont == 0) ? [] : $SucursaleS;
                    }else{
                        $datA[] = array('valido' => false);
                        $datA[] = array('valor' => 'Error al cargar datos de empresa');
                        # surgio error en el modelo
                    }
                    echo json_encode($datA);
                }
                else{
                    show_404();
                }
            }
        }
        #   FIN GET DATA EMPRESA
        #

        //CREADO POR OSCAR AVELAR
        function reporteCortesDeCaja($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->view('reporte_cortes_de_caja');
            }
        }

        function getInfoCortes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaInicial = $this->input->post('fechaini');
                $fechaFinal = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('gerencia_model');
                $infoCortes=$this->gerencia_model->getInfoCortes($fechaInicial,$fechaFinal,$idcentro);

                $i=0;
                $array=array();
                $diferencia=0;
                if($infoCortes != false){
                    foreach($infoCortes as $info){
                        $diferencia=($info->valorusr-$info->valorsys);
                        $array[$i] = array(
                            "sucursal" => $info->centro,
                            "caja" => $info->caja,
                            "numz" => $info->numz,
                            "numx" => $info->numx,
                            "fecha" => $info->fecha,
                            //"grupo" => $info->caja . ' || Z ' . $info->numz . ' X ' . $info->numx,
                            "titulo" => $info->corte,
                            "formaPago" => $info->formaPago,
                            "valorSistema" => $info->valorsys,
                            "valorUsuario" => $info->valorusr,
                            "diferencia" => $diferencia,
                            "usuario" => $info->usuario,
                            "fechaHora" => $info->fechaHora,
                            "tipo" => $info->tipo,
                            "id_centro" => $info->id_centro,
                            "id_caja" => $info->id_caja,
                        );
                        $i++;
                    }
                }   
                echo json_encode($array);
            }
        }

        function getInfoPagos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $numz = $this->input->post('numz');
                $numx = $this->input->post('numx');
                $tipo = $this->input->post('tipo');
                $caja = $this->input->post('caja');
                $sucursal = $this->input->post('sucursal');

                $this->load->model('gerencia_model');
                $infoPagos=$this->gerencia_model->getInfoPagos($numz,$numx,$tipo,$caja,$sucursal);

                $i=0;
                $array=array();
                if($infoPagos != false){
                    foreach($infoPagos as $info){
                        if($info->inopera==-1){
                            $total = $info->total;
                        }else{
                            $total = ($info->total * -1);
                        }
                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "notas" => $info->notas,
                            "valor" => $info->valor,
                            "vuelto" => $info->vuelto,
                            "total" => $total,
                            "ingresa" => $info->ingresa,
                        );
                        $i++;
                    }
                }   
                echo json_encode($array);
            }
        }

        function getInformacionHistorialAdjunto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcobro = $this->input->post('idcobro');

                $this->load->model('gerencia_model'); $this->load->model('auxi_model');
                $informacion = $this->gerencia_model->getInformacionHistorialAjunto($idcobro);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($info->whodidit);
    
                        $array[$i] = array(
                            "idrec" => $info->idrec,
                            "trannum" => $info->trannum,
                            "descrip" => $info->descrip,
                            "comentario" => $info->comentario,
                            "whodidit" => $info->whodidit,
                            "ingresa" => $info->fecha,
                            "ingresado" => $nameIngresado,
                        );
                        $i++;
                    }
                }           

                echo json_encode($array);
            }
        }

        function uploadAttachment(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $id_cobro = $_POST['idCobro'];
                $comentarios = $_POST['inputComentarios'];
                $this->load->model('gerencia_model'); $this->load->model('auxi_model');
                
                if(isset($_FILES["inputAttachment"])){
                    $infoFile = $_FILES["inputAttachment"];
                    $nameDocument = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    $error=0;

                    if($nameDocument != ""){
                        $nameDocument = trim($nameDocument);
                        
                        $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                        $config['file_name'] = $nameDocument;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('inputAttachment')){
                            $insertarAdjunto=$this->gerencia_model->insertarAdjunto($nameDocument, $id_cobro, $comentarios);       
                            $error=1;
                        }
                    }
                }
                if($error == 0){
                    $insertarOnlyComment=$this->gerencia_model->insertarOnlyComment($id_cobro, $comentarios);
                } 

                $informacion = $this->gerencia_model->getInformacionHistorialAjunto($id_cobro);

                $i=0;
                $infoSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $nameIngresado = $this->auxi_model->getDescripcionUsuario($info->whodidit);
    
                        $infoSource[$i] = array(
                            "idrec" => $info->idrec,
                            "trannum" => $info->trannum,
                            "descrip" => $info->descrip,
                            "comentario" => $info->comentario,
                            "whodidit" => $info->whodidit,
                            "ingresa" => $info->fecha,
                            "ingresado" => $nameIngresado,
                        );
                        $i++;
                    }
                }                

                $array = array(
                    "infoSource" => $infoSource,
                );
                echo json_encode($array);
            }
        }

        function setRestriccionUsuario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $iduser = $this->input->post('iduser');

                $this->load->model('gerencia_model');
                $infoToken = $this->gerencia_model->setRestriccionUsuario($iduser);
                /*
                $infoCadena  = '<script src="' . base_url() . 'js/js_devexpress/jquery-3.1.0.min.js"></script>';
                $infoCadena .= '
                <script type="text/javascript">
                    if(typeof(Storage) !== "undefined"){
                        localStorage.setItem("infoTokenGoXpos", "' . $infoToken . '");';
                        $array = array("message", "Locale Storage Generado");
                $infoCadena .= '
                    }else{';
                        $array = array("message", "No se puede generar el Locale Storage");
                $infoCadena .= '}
                </script>';
                
                echo $infoCadena;*/
                echo json_encode($infoToken);
            }
        }

        function getTiposSistema(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('media_model');

                $informacion = $this->media_model->getTiposSistema();

                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            'id' => $info->descrip,
                            'descrip' => $info->descrip
                        );
                        
                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        /* ESCALAR CASO */
        function escalarCaso(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_act = date("Y-m-d");
                $ticket = $this->input->post('info');
                $agente = $this->input->post('nuevoagente');
                $motivo = $this->input->post('motivo');

                $this->load->model('media_model'); $this->load->model("auxi_model");
                $nombreAgente = $this->auxi_model->getDescripcionAuxi($agente);
                $descripcion = "Agente: " . $nombreAgente . "  -  # de Ticket: " . $ticket['idticket']. "\nMotivo de Escalación: \n".$motivo."\nDescripción: \n" . $ticket['descrip'];

                //crea un ticket con la misma informacion
                $this->media_model->adicionarTicketEscalado($ticket['fecha'], $ticket['idgestion'], $ticket['sistema'], $ticket['idaccount'], $ticket['idcontacto'], $agente, $descripcion, $ticket['idticket']); 
                //actualiza el estado del ticket anterior
                $this->media_model->updateEstadoTicket($ticket['idticket'],3, $motivo); 

                echo json_encode($descripcion);
            }
        }
	}
?>