<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Formas extends CI_Controller {
        
        function __construct(){
            parent::__construct();
            date_default_timezone_set('America/El_Salvador');
        }
        private function validatePermiso() {
            $permiso = ($this->session->userdata("profile") != 1) ? false : true;
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || !$permiso) redirect('CerrarSesion');
            else return true;
        }
        
        function verFormas(){
            if($this->validatePermiso()) {
				$varsess = array(
					'namePage' => 'Formatos de Impresión'
				);
				$this->session->set_userdata($varsess);
                $this->load->model('global_model');
                //$this->load->model('formas_model');

				$controlador = $this->uri->segment(1);
                //$funcion = $this->uri->segment(2);
                //$direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                //$this->data['formas'] = $this->formas_model->viewFormas();
                
                $this->load->view('mantenimiento_formas', $this->data); 
            }
        }
        #	MULTIPLES OPCIONES
		public function multiOpciones()
		{
			if($this->validatePermiso()) {
				$opcion = (int)$this->input->post('opcion');
				date_default_timezone_set('America/El_Salvador');
				$this->load->model('formas_model');
				switch ($opcion) {
                    case 1:#    GET FORMATOS
                        $Datos = $this->conversion(0);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case 2:#    SET-UPDATE FORMATO
                        $ID = (int)$this->input->post('ID');
                        $data = array(
                            'descrip' => trim($this->input->post('nombre')),
                            'appname' => trim($this->input->post('app')),
                            'formname' => trim($this->input->post('funcion')),
                            'askpwd' => (int)$this->input->post('ask'),
                            'gvarpwd' => trim($this->input->post('nvariable')),
                            'appoptions' => trim($this->input->post('parametros')),
                            'imagen' => trim($this->input->post('imagen')),
                            'notas' => trim($this->input->post('notas')),
                            'estado' => (int)$this->input->post('estado'),
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        if ($ID == 0) {
                            $data['ingresa'] = $data['modifica'];
                            unset($data['modifica']);
                            $proceso = $this->formas_model->multiOpciones(2, $data);
                        } else $proceso = $this->formas_model->multiOpciones(4, ['ID' => $ID, 'data' => $data]);
                        if ($proceso) {
                            $Datos = $this->conversion(0);
                            $datA[] = array('valido' => true, 'datos' => $Datos);
                        } else $datA[] = array('valido' => false, 'texerror' => (($ID == 0) ? 'Error al Ingresar' : 'Error al Actualizar'));
                    break;
                    case 3:#    DELETE FORMATO
                        $ID = (int)$this->input->post('ID');
                        $this->formas_model->multiOpciones(5, $ID);
                        $Datos = $this->conversion(0);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    default:$datA[] = array('valido' => false);break;
				}
				echo json_encode($datA);
			}
		}
        private function conversion($opc, $extra= null)
        {
            $Datos = [];
            $datos = $this->formas_model->multiOpciones(1);
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'key' => $dato->idform,
                        'titulo' => trim($dato->descrip),
                        'app' => trim($dato->appname),
                        'formulario' => trim($dato->formname),
                        'notas' => trim($dato->notas),
                        'ask' => $dato->askpwd,
                        'gvar' => trim($dato->gvarpwd),
                        'parametros' => trim($dato->appoptions),
                        'imagen' => trim($dato->imagen),
                        'estado' => $dato->estado
                    );
                }
            }
            return $Datos;
        }
        #-

        function nuevaForma(){
            if($this->validatePermiso()) {
				$varsess = array(
					'namePage' => 'Adicionar Formatos de Impresión'
				);
				$this->session->set_userdata($varsess);
                $this->load->model('formas_model');
                
                $this->data['formas'] = $this->formas_model->viewFormas();
                $this->load->view('new_formas', $this->data); 
            }
        }
        function saveForma(){
            if($this->validatePermiso()) {
                if($this->input->post()){
                    $imagen = 'imagen';
                    $config['upload_path'] = "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $this->load->library('upload', $config);
                    $this->upload->do_upload($imagen);
                    //$nameimg = $config['file_name']; 
                    $img_name = $this->input->post('img_name');
                    $appname = $this->input->post('appname');
                    $descrip = $this->input->post('descrip');
                    $formname = $this->input->post('formname');
                    $askpwd = $this->input->post('askpwd');
                    $parametros = $this->input->post('parametros');
                    $icono_select = $this->input->post('icono_select');
                    if($askpwd=="true"){
                        $askpwd=1;
                    }else{
                        $askpwd=0;
                    }
                    
                    $gvarpwd = $this->input->post('gvarpwd');
                    $imagn = $this->input->post('imagen');
                    $notas = $this->input->post('notas');
                    $estado = $this->input->post('estado');
                    if($estado=="true"){
                        $estado=1;
                    }else{
                        $estado=0;
                    }
                    $whodidit = $this->session->userdata('iduser');

                    $this->load->model('formas_model');

                    $query = $this->formas_model->insertarForma($appname,$descrip,$formname,$askpwd,$gvarpwd,$img_name,$notas,$parametros,$icono_select,$estado,$whodidit);
                        if($query==1){
                        redirect('x_Formatos_De_Impresion');
                        }
                }else{
                    redirect('x_Formatos_De_Impresion');
                }
            }
        }
        function modificar_formas($idrow){
            if($this->validatePermiso()) {
				$varsess = array(
					'namePage' => 'Actualizar Formato de Impresión N° '.$idrow
				);
				$this->session->set_userdata($varsess);
				$this->load->model('formas_model');
                $this->data['formas'] = $this->formas_model->detalleFormas($idrow);
                
                $this->load->view('form_update_formas', $this->data); 
            }
        }
        function updateForma(){
            if($this->validatePermiso()) {
                if($this->input->post()){
                    $imagen = 'imagen';
                    $config['upload_path'] = "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $this->load->library('upload', $config);
                    $this->upload->do_upload($imagen);
                    
                    $idform = $this->input->post('idform');
                    $appname = $this->input->post('appname');
                    $descrip = $this->input->post('descrip');
                    $formname = $this->input->post('formname');
                    $img_name = $this->input->post('img_name');
                    $askpwd = $this->input->post('askpwd');
                    $icono_select = $this->input->post('icono_select');
                    $parametros = $this->input->post('parametros');
                    if($askpwd=="true"){
                        $askpwd=1;
                    }else{
                        $askpwd=0;
                    }
                    $gvarpwd = $this->input->post('gvarpwd');
                    $imagn = $this->input->post('imagen');
                    $notas = $this->input->post('notas');
                    $estado = $this->input->post('estado');
                    if($estado=="true"){
                        $estado=1;
                    }else{
                        $estado=0;
                    }
                    $whodidit = $this->session->userdata('iduser');

                    $this->load->model('formas_model');

                    $query = $this->formas_model->updateForma($idform,$appname,$descrip,$formname,$askpwd,$gvarpwd,$img_name,$notas,$parametros,$icono_select,$estado,$whodidit);
                        if($query==1){
                        redirect('x_Formatos_De_Impresion');
                    }
                    }else{

                    }
            }
        }
        function deleteFormas($idform){
              if($this->validatePermiso()) {
                $this->load->model("formas_model");
                $this->formas_model->deleteForma($idform);
            }
        }
    }

?>