<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');  

class Folder extends CI_Controller {
    
    function __construct(){
        parent::__construct();
    }   
    
    function folderDePrecios($idApp){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $appInformacion = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($appInformacion);
                    
            $this->load->model('global_model');$this->load->model('invtran_model');
            $this->load->model('sucursal_model');$this->load->model('ventas_model');
            $this->load->model('cliente_model');
                    
            $direccion = $this->uri->segment(1);
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['tcenters'] = $this->invtran_model->getAllCentrosActivos();
            $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
            $this->data['formas_pago']  = $this->ventas_model->getFormasPagoVN('VN');
            $this->data['grupos'] = $this->cliente_model->viewGrupo();
            $this->load->view('mantenimiento_folder_de_precios', $this->data);
        }
    }
    
    function insertarFolder(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $tipo = $this->input->post("tipo");
            $fechaini = $this->input->post("fechaini");
            $fechafin = $this->input->post("fechafin");
            $descrip = $this->input->post("descrip");
            $idcentros = $this->input->post("idcentros");
            $pagos = $this->input->post("pagos");
            $gruposclientes = $this->input->post("gruposclientes");
            $descuentosP = $this->input->post("descuentosP");
            $descuentosR = $this->input->post("descuentosR");
            $clave = $this->input->post("clave");
            $notas = $this->input->post("notas");
            $this->load->model('folder_model');
            $insert  = $this->folder_model->insertFolder($tipo,$fechaini,$fechafin,$descrip,$idcentros,$pagos,$gruposclientes,$descuentosP,$descuentosR,$clave,$notas);
            $lista = $this->folder_model->getFoldersTipo($tipo);
            echo json_encode($lista);
        }
    }
    
    function updateFolder(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $foldernum = $this->input->post("foldernum");
            $fechaini = $this->input->post("fechaini");
            $fechafin = $this->input->post("fechafin");
            $descrip = $this->input->post("descrip");
            $idcentros = $this->input->post("idcentros");
            $pagos = $this->input->post("pagos");
            $gruposclientes = $this->input->post("gruposclientes");
            $descuentosP = $this->input->post("descuentosP");
            $descuentosR = $this->input->post("descuentosR");
            $clave = $this->input->post("clave");
            $notas = $this->input->post("notas");
            $this->load->model('folder_model');
            $this->load->model('ventas_model');
            $this->load->model('sucursal_model');
            $update = $this->folder_model->updateFolder($foldernum,$fechaini,$fechafin,$descrip,$idcentros,$pagos,$gruposclientes,$descuentosP,$descuentosR,$clave,$notas);
         
            $informacion = $this->folder_model->getInformacionFolder($foldernum);
            $formas_pago = $this->ventas_model->formasPago();
            $sucursales =  $this->sucursal_model->viewSucursalActiva();
            $cadena_pagos = "";
            $cadena_sucursales = "";

            foreach($informacion as $info){
                $array = explode(',', $info->pagos);
                $total = count($array);
                for($i=0; $i<$total; $i++){
                    foreach($formas_pago as $form){
                        if($array[$i] == $form->cajclase){
                            $cadena_pagos .=$form->descrip.",";
                        }
                    }
                }
                
                $array = explode(',', $info->idcentros);
                $total = count($array);
                for($i=0; $i<$total; $i++){
                    foreach($sucursales as $suc){
                        if($array[$i] == $suc->idcentro){
                            $cadena_sucursales .=$suc->descrip.",";
                        }
                    }
                }
                $cadena_pagos = substr($cadena_pagos, 0, -1);
                $cadena_sucursales = substr($cadena_sucursales, 0, -1);
                $array_post = array(
                    "formas_pago_per" => $cadena_pagos,
                    "sucursales_per" => $cadena_sucursales,
                    "descrip" => $info->descrip,
                    "fechaini" =>  date_format(date_create($info->fechaini), 'd-m-Y'),
                    "fechafin" =>  date_format(date_create($info->fechafin), 'd-m-Y'),
                    "grupos" =>  $info->grupoclientes,
                    "descuentos_p" =>  $info->descuentos_p,
                    "descuentos_r" =>  $info->descuentos_r,
                    "notas" =>  $info->notas,
                );
            }
            echo json_encode($array_post);
        }
    }
    
    function getFoldersTipo(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $tipo = $this->input->post("tipo");
            $this->load->model('folder_model');
            $lista = $this->folder_model->getFoldersTipo($tipo);
            echo json_encode($lista);
        }
    }
    
    function getInfoFolder(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $foldernum = $this->input->post("foldernum");
            $this->load->model('folder_model');
            $info = $this->folder_model->getInformacionFolder($foldernum);
            echo json_encode($info);
        }
    }
    
    function detalleFolderDePrecios($foldernum){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $resultAppName = array(
                'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$foldernum
            );
            $this->session->set_userdata($resultAppName);
            $idcentro = $this->session->userdata('idcentrouser');
            $this->load->model('invtran_model'); $this->load->model('global_model'); $this->load->model('folder_model');
            $this->load->model('ventas_model');$this->load->model('sucursal_model');$this->load->model('cliente_model');
                    
            $this->data['tcenters'] = $this->invtran_model->getAllCentrosActivos();
            $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
            $this->data['formas_pago']  = $this->ventas_model->getFormasPagoVN('VN');
            $this->data['grupos'] = $this->cliente_model->viewGrupo();
            
            $direccion = $this->uri->segment(1);
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $informacion = $this->folder_model->getInformacionFolder($foldernum);
            $this->data['informacion'] =$informacion;
            $formas_pago = $this->ventas_model->formasPago();
            $sucursales =  $this->sucursal_model->viewSucursalActiva();
            $cadena_pagos = "";
            $cadena_sucursales = "";

            foreach($informacion as $info){
                
                $array = explode(',', $info->pagos);
                $total = count($array);
                for($i=0; $i<$total; $i++){
                    foreach($formas_pago as $form){
                        if($array[$i] == $form->cajclase){
                            $cadena_pagos .=$form->descrip.",";
                        }
                    }
                }
                
                $array = explode(',', $info->idcentros);
                $total = count($array);
                for($i=0; $i<$total; $i++){
                    foreach($sucursales as $suc){
                        if($array[$i] == $suc->idcentro){
                            $cadena_sucursales .=$suc->descrip.",";
                        }
                    }
                }
            }
            $cadena_pagos = substr($cadena_pagos, 0, -1);
            $cadena_sucursales = substr($cadena_sucursales, 0, -1);
            $this->data['formas_pago_per'] =$cadena_pagos;
            $this->data['sucursales_per'] =$cadena_sucursales;
            
            $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
            if($tipoBusca == 1){
                $array = array(
                    "gv_prodsearch" => $tipoBusca,
                    "gv_prodtext" => "Código Interno"
                );
            }elseif($tipoBusca == 2){
                $array = array(
                    "gv_prodsearch" => $tipoBusca,
                    "gv_prodtext" => "Modelo"
                );
            }elseif($tipoBusca == 3){
                $array = array(
                    "gv_prodsearch" => $tipoBusca,
                    "gv_prodtext" => "Código de Barra"
                );
            }elseif($tipoBusca == 4){
                $array = array(
                    "gv_prodsearch" => $tipoBusca,
                    "gv_prodtext" => "Código Xpos"
                );
            }
            $this->session->set_userdata($array);
            $this->load->view('mantenimiento_detalle_folder_de_precios', $this->data);
        }
    }  
    
    function getDatosFolderDePrecios(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $foldernum = $this->input->post("foldernum");
            $this->load->model('folder_model');
            $lista = $this->folder_model->getDatosFolderDePrecios($foldernum);
            $array = array();
            $i=0;
            if($lista!=false){
                foreach($lista as $list){
                    $array_detalle = array();
                    $array[$i] = array(
                        "idrec" => $list->idrec,
                        "descrip" => $list->descrip,
                        "marca" => $list->marca,
                        "modelo" => $list->modelo,
                        "linea" => $list->linea,
                        "nameproveedor" => $list->nameproveedor,
                        "idproducto" => $list->idproducto,
                        "precioventa" => $list->precioventa,
                        "precioactual" => $list->precioactual,
                        "detalle" => $array_detalle
                    );
                    $i++;
                }
            }
            echo json_encode($array);
        }
    }
    
    function insertarProductosToFolderGrid(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $foldernum = $this->input->post('foldernum');
            $idproductos = $this->input->post('idproductos');
            $this->load->model('folder_model');
            $this->folder_model->insertarProductoToFolderPreciosByGrid($foldernum, $idproductos);
            $lista = $this->folder_model->getDatosFolderDePrecios($foldernum);
            $array = array();
            $i=0;
            if($lista!=false){
                foreach($lista as $list){
                    $array_detalle = array();
                    $array[$i] = array(
                        "idrec" => $list->idrec,
                        "descrip" => $list->descrip,
                        "marca" => $list->marca,
                        "modelo" => $list->modelo,
                        "linea" => $list->linea,
                        "nameproveedor" => $list->nameproveedor,
                        "idproducto" => $list->idproducto,
                        "precioventa" => $list->precioventa,
                        "precioactual" => $list->precioactual,
                        "detalle" => $array_detalle
                    );
                    $i++;
                }
            }
            echo json_encode($array);
        }
    }    
        
    function updatePrecioProducto(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $foldernum = $this->input->post('foldernum');
            $idrec = $this->input->post('idrec');
            $nuevoprecio = $this->input->post('nuevoprecio');
            $this->load->model('folder_model');
            $this->folder_model->updatePrecioProducto($foldernum, $idrec, $nuevoprecio);
            $lista = $this->folder_model->getDatosFolderDePrecios($foldernum);
            $array = array();
            $i=0;
            if($lista!=false){
                foreach($lista as $list){
                    $array_detalle = array();
                    $array[$i] = array(
                        "idrec" => $list->idrec,
                        "descrip" => $list->descrip,
                        "marca" => $list->marca,
                        "modelo" => $list->modelo,
                        "linea" => $list->linea,
                        "nameproveedor" => $list->nameproveedor,
                        "idproducto" => $list->idproducto,
                        "precioventa" => $list->precioventa,
                        "precioactual" => $list->precioactual,
                        "detalle" => $array_detalle
                    );
                    $i++;
                }
            }
            echo json_encode($array);
        }
    }    
    
    function updateMultiplesPrecios(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $foldernum = $this->input->post('foldernum');
            $productos = $this->input->post('productos');
            $nuevoprecio = $this->input->post('nuevoprecio');
            $this->load->model('folder_model');
            $this->folder_model->updateMultiplesPrecios($foldernum, $productos, $nuevoprecio);
            $lista = $this->folder_model->getDatosFolderDePrecios($foldernum);
            $array = array();
            $i=0;
            if($lista!=false){
                foreach($lista as $list){
                    $array_detalle = array();
                    $array[$i] = array(
                        "idrec" => $list->idrec,
                        "descrip" => $list->descrip,
                        "marca" => $list->marca,
                        "modelo" => $list->modelo,
                        "linea" => $list->linea,
                        "nameproveedor" => $list->nameproveedor,
                        "idproducto" => $list->idproducto,
                        "precioventa" => $list->precioventa,
                        "precioactual" => $list->precioactual,
                        "detalle" => $array_detalle
                    );
                    $i++;
                }
            }
            echo json_encode($array);
        }
    }    
    
    function incrementarPorcentaje(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $foldernum = $this->input->post('foldernum');
            $productos = $this->input->post('productos');
            $tipo = $this->input->post('tipo');
            $porcentaje = $this->input->post('porcentaje');
            $this->load->model('folder_model');
            $this->folder_model->incrementarPorcentaje($foldernum, $tipo, $productos, $porcentaje);
            $lista = $this->folder_model->getDatosFolderDePrecios($foldernum);
            $array = array();
            $i=0;
            if($lista!=false){
                foreach($lista as $list){
                    $array_detalle = array();
                    $array[$i] = array(
                        "idrec" => $list->idrec,
                        "descrip" => $list->descrip,
                        "marca" => $list->marca,
                        "modelo" => $list->modelo,
                        "linea" => $list->linea,
                        "nameproveedor" => $list->nameproveedor,
                        "idproducto" => $list->idproducto,
                        "precioventa" => $list->precioventa,
                        "precioactual" => $list->precioactual,
                        "detalle" => $array_detalle
                    );
                    $i++;
                }
            }
            echo json_encode($array);
        }
    }    
    
    function deleteProducto(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $foldernum = $this->input->post('foldernum');
            $idrec = $this->input->post('idrec');
            $this->load->model('folder_model');
            $this->folder_model->deleteProducto($idrec);
            $lista = $this->folder_model->getDatosFolderDePrecios($foldernum);
            $array = array();
            $i=0;
            if($lista!=false){
                foreach($lista as $list){
                    $array_detalle = array();
                    $array[$i] = array(
                        "idrec" => $list->idrec,
                        "descrip" => $list->descrip,
                        "marca" => $list->marca,
                        "modelo" => $list->modelo,
                        "linea" => $list->linea,
                        "nameproveedor" => $list->nameproveedor,
                        "idproducto" => $list->idproducto,
                        "precioventa" => $list->precioventa,
                        "precioactual" => $list->precioactual,
                        "detalle" => $array_detalle
                    );
                    $i++;
                }
            }
            echo json_encode($array);
        }
    }    
    
    function getListadoProductosToFolder(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $foldernum = $this->input->post('foldernum');
                    
            $this->load->model('folder_model');
            $informacion = $this->folder_model->getListadoProductosToFolder($foldernum);
                    
            $j=0;
            $array_datos = array();
                    
            if($informacion!=false){
                foreach($informacion as $info){
                    if($info->existe == 0){
                        $array_datos[$j] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "costounitario" => $info->costounitario,
                            "idcatalogo" => $info->idcatalogo,
                            "linea" => $info->linea,
                            "nameproveedor" => $info->nameproveedor,
                            "modelo" => $info->modelo,
                            "um" => $info->um,
                            "precioventa" => $info->precioventa,
                            "marca" => $info->marca,
                            "tipotax" => $info->tipotax,
                        );          
                        $j++;
                    }
                }
            }
            echo json_encode($array_datos);
        }
    }
    
    function activarFolder(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $foldernum = $this->input->post('foldernum');
            $this->load->model('folder_model');
            $this->folder_model->activarFolder($foldernum);
            echo json_encode(true);
        }
    }    
    
}
?>