<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

    class Dte extends CI_Controller {
        
        function __construct() {
            parent::__construct();
            
            date_default_timezone_set('America/El_Salvador');

            $this->load->model('dte_model');
            $this->load->model('global_model');

            $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

            if (!$this->session->userdata('tokenJson')) {
                $this->getTokenDTE();
            }

            if (!$this->session->userdata('dteSendEmail') || !$this->session->userdata('dteSendPrint')) {
                if ( $dteSucursal == 0 ) {
                    $dteSendEmail = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 12);
                    $dteSendPrint = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 13);
                    $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                } else {
                    $dteSendEmail = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$this->session->userdata('idcentrouser'), 12);
                    $dteSendPrint = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$this->session->userdata('idcentrouser'), 13);
                    $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$this->session->userdata('idcentrouser'), 5);
                }

                $this->session->set_userdata('dteSendEmail', ($dteSendEmail == '' ? 0 : $dteSendEmail));
                $this->session->set_userdata('dteSendPrint', ($dteSendPrint == '' ? 1 : $dteSendPrint));
                $this->session->set_userdata('codAmbiente', $codAmbiente);
            }
        }

        function getTokenDTE() {

            $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

            if ( $dteSucursal == 0 ) {
                $nit         = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $codAmbiente = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                $pwdApi      = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 7);
            } else {
                $nit         = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$this->session->userdata('idcentrouser'), 4);
                $codAmbiente = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$this->session->userdata('idcentrouser'), 5);
                $pwdApi      = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$this->session->userdata('idcentrouser'), 7);
            }

            //NOTE: AUTORIZACION API MH
            
            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/seguridad/auth" : "https://api.dtes.mh.gob.sv/seguridad/auth";

            $RestApi = curl_init();
            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/x-www-form-urlencoded'
            ));
            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
            curl_setopt($RestApi, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($RestApi, CURLOPT_POSTFIELDS, 'user='.str_replace('-', '', $nit).'&pwd='.$pwdApi);

            $Resolve = curl_exec($RestApi);
            
            curl_close($RestApi);

            $resultToken = json_decode($Resolve, true);

            if( $resultToken['status'] == 'OK' ) {
                $tokenJson = $resultToken['body']['token'];

                $this->session->set_userdata('tokenJson', $tokenJson);
            }else{
                echo json_encode($resultToken);
            }
        }

        function valorEnLetras($x) {
            $I7 = " ";
            $I9 = " ";
            if ($x<0) { $signo = "menos ";} 
            else      { $signo = "";} 
            $x = abs ($x); 
            $C1 = $x; 

            $G6 = floor($x/(1000000));  // 7 y mas 

            $E7 = floor($x/(100000)); 
            $G7 = $E7-$G6*10;   // 6 

            $E8 = floor($x/1000); 
            $G8 = $E8-$E7*100;   // 5 y 4 

            $E9 = floor($x/100); 
            $G9 = $E9-$E8*10;  //  3 

            $E10 = floor($x); 
            $G10 = $E10-$E9*100;  // 2 y 1 


            $G11 = round(($x-$E10)*100,0);  // Decimales 
            ////////////////////// 

            $H6 = $this->unidades($G6); 

            if($G7==1 AND $G8==0) { $H7 = "Cien "; } 
            else {    $H7 = $this->decenas($G7); } 

            $H8 = $this->unidades($G8); 

            if($G9==1 AND $G10==0) { $H9 = "Cien "; } 
            else {    $H9 = $this->decenas($G9); } 

            $H10 = $this->unidades($G10); 

            if($G11 < 10) { $H11 = "0".$G11; } 
            else { $H11 = $G11; } 

            ///////////////////////////// 
                if($G6==0) { $I6=" "; } 
            elseif($G6==1) { $I6="Millón "; } 
                    else { $I6="Millones "; } 

            if ($G8==0 AND $G7==0) { $I8=" "; } 
                    else { $I8="Mil "; } 

            $I10 = ""; 
            $I11 = "/100 US DOLARES ";

            $C3 = $signo.$H6.$I6.$H7.$I7.$H8.$I8.$H9.$I9.$H10.$I10.$H11.$I11; 

            return $C3; //Retornar el resultado 
        }

        function unidades($u) {
            if ($u==0)  {$ru = " ";} 
            elseif ($u==1)  {$ru = "Un ";} 
            elseif ($u==2)  {$ru = "Dos ";} 
            elseif ($u==3)  {$ru = "Tres ";} 
            elseif ($u==4)  {$ru = "Cuatro ";} 
            elseif ($u==5)  {$ru = "Cinco ";} 
            elseif ($u==6)  {$ru = "Seis ";} 
            elseif ($u==7)  {$ru = "Siete ";} 
            elseif ($u==8)  {$ru = "Ocho ";} 
            elseif ($u==9)  {$ru = "Nueve ";} 
            elseif ($u==10) {$ru = "Diez ";} 

            elseif ($u==11) {$ru = "Once ";} 
            elseif ($u==12) {$ru = "Doce ";} 
            elseif ($u==13) {$ru = "Trece ";} 
            elseif ($u==14) {$ru = "Catorce ";} 
            elseif ($u==15) {$ru = "Quince ";} 
            elseif ($u==16) {$ru = "Dieciseis ";} 
            elseif ($u==17) {$ru = "Decisiete ";} 
            elseif ($u==18) {$ru = "Dieciocho ";} 
            elseif ($u==19) {$ru = "Diecinueve ";} 
            elseif ($u==20) {$ru = "Veinte ";} 

            elseif ($u==21) {$ru = "Veintiun ";} 
            elseif ($u==22) {$ru = "Veintidos ";} 
            elseif ($u==23) {$ru = "Veintitres ";} 
            elseif ($u==24) {$ru = "Veinticuatro ";} 
            elseif ($u==25) {$ru = "Veinticinco ";} 
            elseif ($u==26) {$ru = "Veintiseis ";} 
            elseif ($u==27) {$ru = "Veintisiente ";} 
            elseif ($u==28) {$ru = "Veintiocho ";} 
            elseif ($u==29) {$ru = "Veintinueve ";} 
            elseif ($u==30) {$ru = "Treinta ";} 

            elseif ($u==31) {$ru = "Treinta y un ";} 
            elseif ($u==32) {$ru = "Treinta y dos ";} 
            elseif ($u==33) {$ru = "Treinta y tres ";} 
            elseif ($u==34) {$ru = "Treinta y cuatro ";} 
            elseif ($u==35) {$ru = "Treinta y cinco ";} 
            elseif ($u==36) {$ru = "Treinta y seis ";} 
            elseif ($u==37) {$ru = "Treinta y siete ";} 
            elseif ($u==38) {$ru = "Treinta y ocho  ";} 
            elseif ($u==39) {$ru = "Treinta y nueve ";} 
            elseif ($u==40) {$ru = "Cuarenta ";} 

            elseif ($u==41) {$ru = "Cuarenta y un ";} 
            elseif ($u==42) {$ru = "Cuarenta y dos ";} 
            elseif ($u==43) {$ru = "Cuarenta y tres ";} 
            elseif ($u==44) {$ru = "Cuarenta y cuatro ";} 
            elseif ($u==45) {$ru = "Cuarenta y cinco ";} 
            elseif ($u==46) {$ru = "Cuarenta y seis ";} 
            elseif ($u==47) {$ru = "Cuarenta y siete ";} 
            elseif ($u==48) {$ru = "Cuarenta y ocho  ";} 
            elseif ($u==49) {$ru = "Cuarenta y nueve ";} 
            elseif ($u==50) {$ru = "Cincuenta ";} 

            elseif ($u==51) {$ru = "Cincuenta y un ";} 
            elseif ($u==52) {$ru = "Cincuenta y dos ";} 
            elseif ($u==53) {$ru = "Cincuenta y tres ";} 
            elseif ($u==54) {$ru = "Cincuenta y cuatro ";} 
            elseif ($u==55) {$ru = "Cincuenta y cinco ";} 
            elseif ($u==56) {$ru = "Cincuenta y seis ";} 
            elseif ($u==57) {$ru = "Cincuenta y siete ";} 
            elseif ($u==58) {$ru = "Cincuenta y ocho  ";} 
            elseif ($u==59) {$ru = "Cincuenta y nueve ";} 
            elseif ($u==60) {$ru = "Sesenta ";} 

            elseif ($u==61) {$ru = "Sesenta y un ";} 
            elseif ($u==62) {$ru = "Sesenta y dos ";} 
            elseif ($u==63) {$ru = "Sesenta y tres ";} 
            elseif ($u==64) {$ru = "Sesenta y cuatro ";} 
            elseif ($u==65) {$ru = "Sesenta y cinco ";} 
            elseif ($u==66) {$ru = "Sesenta y seis ";} 
            elseif ($u==67) {$ru = "Sesenta y siete ";} 
            elseif ($u==68) {$ru = "Sesenta y ocho  ";} 
            elseif ($u==69) {$ru = "Sesenta y nueve ";} 
            elseif ($u==70) {$ru = "Setenta ";} 

            elseif ($u==71) {$ru = "Setenta y un ";} 
            elseif ($u==72) {$ru = "Setenta y dos ";} 
            elseif ($u==73) {$ru = "Setenta y tres ";} 
            elseif ($u==74) {$ru = "Setenta y cuatro ";} 
            elseif ($u==75) {$ru = "Setenta y cinco ";} 
            elseif ($u==76) {$ru = "Setenta y seis ";} 
            elseif ($u==77) {$ru = "Setenta y siete ";} 
            elseif ($u==78) {$ru = "Setenta y ocho  ";} 
            elseif ($u==79) {$ru = "Setenta y nueve ";} 
            elseif ($u==80) {$ru = "Ochenta ";} 

            elseif ($u==81) {$ru = "Ochenta y un ";} 
            elseif ($u==82) {$ru = "Ochenta y dos ";} 
            elseif ($u==83) {$ru = "Ochenta y tres ";} 
            elseif ($u==84) {$ru = "Ochenta y cuatro ";} 
            elseif ($u==85) {$ru = "Ochenta y cinco ";} 
            elseif ($u==86) {$ru = "Ochenta y seis ";} 
            elseif ($u==87) {$ru = "Ochenta y siete ";} 
            elseif ($u==88) {$ru = "Ochenta y ocho  ";} 
            elseif ($u==89) {$ru = "Ochenta y nueve ";} 
            elseif ($u==90) {$ru = "Noventa ";} 

            elseif ($u==91) {$ru = "Noventa y un ";} 
            elseif ($u==92) {$ru = "Noventa y dos ";} 
            elseif ($u==93) {$ru = "Noventa y tres ";} 
            elseif ($u==94) {$ru = "Noventa y cuatro ";} 
            elseif ($u==95) {$ru = "Noventa y cinco ";} 
            elseif ($u==96) {$ru = "Noventa y seis ";} 
            elseif ($u==97) {$ru = "Noventa y siete ";} 
            elseif ($u==98) {$ru = "Noventa y ocho  ";} 
            else            {$ru = "Noventa y nueve ";} 
            return $ru; //Retornar el resultado 
        }

        function decenas($d) {
            if ($d==0)  {$rd = "";} 
            elseif ($d==1)  {$rd = "Ciento ";} 
            elseif ($d==2)  {$rd = "Doscientos ";} 
            elseif ($d==3)  {$rd = "Trescientos ";} 
            elseif ($d==4)  {$rd = "Cuatrocientos ";} 
            elseif ($d==5)  {$rd = "Quinientos ";} 
            elseif ($d==6)  {$rd = "Seiscientos ";} 
            elseif ($d==7)  {$rd = "Setecientos ";} 
            elseif ($d==8)  {$rd = "Ochocientos ";} 
            else            {$rd = "Novecientos ";} 
            return $rd; //Retornar el resultado 
        }

        function getCambiosDte() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                echo json_encode(array(
                    'itemsDte'   => $this->dte_model->getTotalRegistrosDTE(),
                    'dteCorreo'  => $this->dte_model->getTotalEnviosCorreo()
                ));
            }
        }

        function getDatosDocumentosVentas() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                
                $idcaja   = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                                
                $this->load->model('dev_model');
                $this->load->model('ventas_model'); 
                $this->load->model('invtran_model');
                $this->load->model('variable_model');

				$percentIVA = $this->variable_model->getValorIVA();
                $datos      = $this->dte_model->getDatosFacturacionesBitacora('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                $itemsDte   = $this->dte_model->getTotalRegistrosDTE();
                $dteCorreo  = $this->dte_model->getTotalEnviosCorreo();
                
                $tipoContribuyente = $this->global_model->getDatoTipoContribuyenteEmp('g_empdatos', 10);
                
                $i=0;
                $array = array();
                
                foreach ( $datos as $info ) {
                    if ( $info->estatus!=0 ) {
						$j = 0;
                        $valtax1 = 0; $totalDescuento = 0; $totalComision = 0;
						
                        $detalle = $this->invtran_model->getDetalleFacturas($info->trannum);
                        
                        $detailFacturas = array();
						foreach ( $detalle as $data ) {
							$valtax1 = 0;
                            if ( $info->exento == 0 ) {
                                $valtax1 = $data->precioneto * ($data->tax1 / 100);
                            } else {
                                $valtax1 = 0;
                            }
                            
                            if ( $data->descuento != 0 ) {
                                $totalDescuento = $totalDescuento + ((($data->preciotran / (1 + ($data->tax1/100))) -  $data->precioneto) * abs($data->cantidad));
                            }
                            
                            if ( $data->comision != 0 ) {
                                $totalComision = $totalComision + (($data->preciotran * ($data->comision/100)) * abs($data->cantidad));
                            }
                            
                            $total = abs($data->cantidad) * ($data->precioneto + $valtax1);                       
                        }
						
                        $valPercepcion = 0; $valRetencion = 0;
                        $exento_doc = 0; $gravado_doc = 0; $iva_doc = $info->valtax1;
                        if ( $info->exento == 1 ) {
                            $exento_doc = $info->valventan;
                        } else {
                            if ( $percentIVA != 0 ) {
                                $gravado_doc = ( $info->valtax1 / ( $percentIVA / 100 ) );
                            } else  $gravado_doc = $info->valventan;

                            $exento_doc = number_format($info->valventan-$gravado_doc, 2, '.', '');
                        }

                        $totalVenta = $info->valventan + $iva_doc;

                        if ( intval($tipoContribuyente) == 1 ) {
                            if ( $info->idtipo != 3 ) {
                                if ( $gravado_doc >= 100 ) {
                                    $valPercepcion = $gravado_doc * 0.01;
                                }
                            }
                        } else {
                            if ( $info->idtipo == 3 ) {
                                if ( $gravado_doc >= 100 ) {
                                    $valRetencion = $gravado_doc * 0.01;
                                }
                            }
                        }
    
                        if ( $valRetencion != 0 ) {
                            $totalVenta = $totalVenta - number_format($valRetencion, 2 , '.', '');
                        }
    
                        if ($valPercepcion != 0) {
                            $totalVenta = $totalVenta + number_format($valPercepcion, 2 , '.', '');
                        }
                        
                        $descripPagos = "";
                        $notasPago    = "";
                        $informaPagos = $this->dev_model->getDatosPagosVentasTrannum($info->trannum);
                        
                        if ( $informaPagos != false ) {
                            foreach ( $informaPagos as $infoPago ) {
                                $descripPagos .= $infoPago->descrip.", ";

                                if ( $infoPago->notasPago != "" && $infoPago->notasPago != false ) {
                                    $notasPago .= $infoPago->notasPago.", ";
                                }
                            }
                            
                            $descripPagos = str_replace("Retención 1%", "", $descripPagos);
                            $descripPagos = substr($descripPagos, 0, -2);  

                            if ( $notasPago != "" ) {
                                $notasPago = substr($notasPago, 0, -2);   
                            }
                        }

                        if ( $descripPagos == "" ) {
                            $informaPagos = $this->dev_model->getTipoPagoRealiVenta($info->trannum);
                            if ( $informaPagos != false ) {
                                foreach ( $informaPagos as $infoPago ) {
                                    $descripPagos .= $infoPago->descrip;

                                    if ( $infoPago->notasPago != "" && $infoPago->notasPago != false ) {
                                        $notasPago .= $infoPago->notasPago;
                                    }
                                }
                            }
                        }

                        if ( $info->registro != "" ) {
                            $registro = $info->registro;
                        } else {
                            $registro = "SIN REGISTRO";
                        }

                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "fecha" => $info->fecha,
                            "tipodoc" => $info->tipodoc,
                            "iddte" => $info->iddte,
                            "seriedoc" => $info->serie,
                            "numeroserie" => $info->numero * 1,
                            "doc_dev" => $info->dev_serie.$info->dev_numero,
                            "nit" => $info->nit,
                            "dui" => $info->dui,
                            "numx" => $info->numx,
                            "numz" => $info->numz,
                            "registro" => $registro,
                            "namecliente" => $info->namecliente,
                            "emailCliente" => $info->emailCliente,
                            "giro" => $info->giroDTE,
                            "idclienteauxi" => $info->idclienteauxi,
                            "namesucursal" => $info->namesucursal,
                            "namecaja" => $info->namecaja,
                            "namecentro" => $info->namecentro,
                            "namevendedor" => $info->namevendedor,
                            "valventan" => number_format($totalVenta, 6, '.', ''),
                            "exento" => number_format($exento_doc, 6, '.', ''),
                            "gravado" => number_format($gravado_doc, 6, '.', ''),
                            "iva" => number_format($iva_doc, 6, '.', ''),
                            "retencion" => number_format($valRetencion, 6, '.', ''),
                            "percepcion" => number_format($valPercepcion, 6, '.', ''),
                            "descuento" => number_format($totalDescuento, 6, '.', ''),
                            "comision" => number_format($totalComision, 6, '.', ''),
                            "cgeneracion" => $info->cgeneracion,
                            "srecepcion" => $info->srecepcion,
                            "ncontrol" => $info->ncontrol,
                            "estadoDte" => ($info->cgeneracion != '' && $info->estatus == 9) ? 'ANULADO' : ($info->cgeneracion != '' ? 'PROCESADO' : 'PENDIENTE'),
                            "email_send" => $info->email_send,
                            "estatus" => $info->estatus,
                            "formaPago" => $descripPagos,
                            "notasPago" => $notasPago,
                            "notas_fact" => $info->notas,
                            "referencia" => $info->referencia,
                            "valcosto" => number_format($info->valcosto * -1, 6, '.', ''),
                            "ingresa" => $info->ingresa,
                        );
                        $i++;
                    }
                }
                
                echo json_encode(array(
                    'dataSource' => $array,
                    'itemsDte'   => $itemsDte,
                    'dteCorreo'  => $dteCorreo
                ));
            }
        }

        function comprobanteCreditoFiscalDTE($trannum, $infoJSON = false) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum);
                
                if (!$infoDTE) {
                    $fecha = new DateTime();
                    $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum);

                    if ($this->session->userdata('codAmbiente') == '01') {
                        $rSerie = strpos($infoDoc->serie, 'DTE');
                        if ( $rSerie === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que no es un DTE');
                            exit;
                        }

                        $dateD = date_create($infoDoc->fecha);
                        $dYear = substr(date_format($dateD, 'Y'), 2, 2);
                        $rYear = strpos($infoDoc->serie, $dYear);
                        if ( $rYear === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que contiene una serie de otro año');
                            exit;
                        }
                    }

                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

                    if ( $dteSucursal == 0 ) {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                        
                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);
                        
                        $tipoContribuyente = $this->global_model->getDatoTipoContribuyenteEmp('g_empdatos', 10);
                    } else {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);
                        
                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);
                        
                        $tipoContribuyente = $this->global_model->getDatoTipoContribuyenteEmp('g_empdatos_0'.$infoDoc->idcentro, 10);
                    }
                    
                    $docRelacionado  = false;
                    $otrosDocumentos = false;
                    $ventaTercero    = false;
                    $docApendice     = ($infoDoc->referencia != "") ? true : false;

                    $fileDteJson = new stdClass();

                    //NOTE: Identificacion JSON
                    if ($codAmbiente == '00') {
                        $numControl  = 'DTE-03-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad(rand(1000, 5000), 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "CCF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8A5486".str_pad(rand(1000, 5000), 6, '0', STR_PAD_LEFT);
                    } else {
                        $numControl  = 'DTE-03-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "CCF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                    }
                    
                    $fileDteJson->identificacion = array(
                        'version'           => 3,
                        'ambiente'          => $codAmbiente, // '00',    // CAT-001
                        'tipoDte'           => '03',    // CAT-002
                        'numeroControl'     => $numControl,
                        'codigoGeneracion'  => $cGeneracion,
                        'tipoModelo'        => 1,       // CAT-003
                        'tipoOperacion'     => 1,       // CAT-004
                        'tipoContingencia'  => null,    // CAT-005
                        'motivoContin'      => null,
                        'fecEmi'            => ($codAmbiente == '00') ? $fecha->format('Y-m-d') : $infoDoc->fecha, // YYYY-MM-DD
                        'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                        'tipoMoneda'        => 'USD'
                    );

                    //NOTE: Documentos Relacionados JSON (Opcional Segun Requerimientos)

                    if ($docRelacionado) {
                        $fileDteJson->documentoRelacionado = array(
                            'tipoDocumento'     => '', // CAT-002
                            'tipoGeneracion'    => '', // CAT-007
                            'numeroDocumento'   => '',
                            'fechaEmision'      => ''
                        );
                    } else $fileDteJson->documentoRelacionado = null;
                    
                    //NOTE: Emisor JSON
                    
                    $fileDteJson->emisor = array(
                        'nit'                 => ''.str_replace('-', '', $NIT).'',
                        'nrc'                 => ''.str_replace('-', '', $NRC).'',
                        'nombre'              => strtoupper($razonSocial),
                        // 'codActividad'        => '46510', // CAT-019
                        // 'codActividad'        => '47300', // CAT-019
                        'codActividad'        => $cActividad, // CAT-019
                        'descActividad'       => strtoupper($GIRO), // CAT-019
                        'nombreComercial'     => strtoupper($nComercial),
                        'tipoEstablecimiento' => '02', // CAT-009
                        'direccion' => array(
                            'departamento'    => ($infoDoc->iddeptodtesuc == 0) ? $cDepartamento : $infoDoc->iddeptodtesuc, // CAT-012
                            'municipio'       => ($infoDoc->idmunidtesuc == 0) ? $cMunicipio : $infoDoc->idmunidtesuc, // CAT-013
                            'complemento'     => ($infoDoc->direccionsucursal == "") ? strtoupper($direccion) : $infoDoc->direccionsucursal
                        ),
                        'telefono'            => str_replace('-', '', $telefono),
                        'codEstable'          => ''.strtoupper($infoDoc->centromh).'',
                        'codEstableMH'        => ''.strtoupper($infoDoc->centromh).'',
                        'codPuntoVentaMH'     => ''.strtoupper($infoDoc->cajamh).'',
                        'codPuntoVenta'       => ''.strtoupper($infoDoc->cajamh).'',
                        'correo'              => $correoEl,
                    );
                    
                    //NOTE: Receptor JSON
                    if ($codAmbiente == '00') {
                        $fileDteJson->receptor = array(
                            //'tipoDocumento'    => '', // CAT-022
                            'nit'              => ''.str_replace('-', '', '0614-210889-101-8').'',
                            'nrc'              => ''.str_replace('-', '', '8466-2').'',
                            'nombre'           => 'EMPRESAS GOMEZ GUATEMALA S.A. DE C.V.',
                            'nombreComercial'  => null,
                            'codActividad'     => '46510', // CAT-019
                            'descActividad'    => 'Venta al por mayor de computadoras, equipo periférico y programas informáticos', // CAT-019
                            'direccion' => array(
                                'departamento' => '06', // CAT-012
                                'municipio'    => '14',  // CAT-013
                                'complemento'  => 'Final 67 Avenida Sur y Pasaje Carbonell, N° 2A, Colonia Roma, San Salvador, El Salvador'
                            ),
                            'telefono'         => '25143094',
                            'correo'           => 'dte@versanetsa.com'
                        );
                    } else {
                        $fileDteJson->receptor = array(
                            //'tipoDocumento'    => '', // CAT-022
                            'nit'              => ''.str_replace('-', '', $infoDoc->nit).'',
                            'nrc'              => ''.str_replace('-', '', $infoDoc->nrc).'',
                            'nombre'           => $infoDoc->nameCliente,
                            'nombreComercial'  => null,
                            'codActividad'     => ($infoDoc->dte_giro == '' ? '47739' : $infoDoc->dte_giro), // CAT-019
                            'descActividad'    => ($infoDoc->dte_giro == '' ? 'Venta al por menor de otros productos n.c.p.' : $infoDoc->dte_giro_des), // CAT-019
                            'direccion' => array(
                                'departamento' => $infoDoc->iddeptodte, // CAT-012
                                'municipio'    => $infoDoc->idmunidte,  // CAT-013
                                'complemento'  => $infoDoc->direccion
                            ),
                            'telefono'         => ($infoDoc->telefono == '' ? '00000000' : str_replace('-', '', $infoDoc->telefono)),
                            'correo'           => ($infoDoc->correo == '' ? 'correo@correo.com' : $infoDoc->correo)
                        );
                    }
                    
                    //NOTE: Otros Documentos Asociados
                    
                    if ($otrosDocumentos) {
                        $fileDteJson->otrosDocumentos = array(
                            'codDocAsociado'   => '',
                            'descDocumento'    => '',
                            'detalleDocumento' => '',
                            'medico' => array(
                                'nombre'            => '',
                                'nit'               => '',
                                'docIdentificacion' => '',
                                'tipoServicio'      => '',
                            )
                        );
                    } else $fileDteJson->otrosDocumentos = null;
                                    
                    //NOTE: Ventas por Cuenta de Terceros
                    
                    if ($ventaTercero) {
                        $fileDteJson->ventaTercero = array(
                            'nit'    => '',
                            'nombre' => '',
                        );
                    } else $fileDteJson->ventaTercero = null;

                    //NOTE: Cuerpo del Documento (ForEach Items)
                    
                    $infoProductos = $this->dte_model->getDetalleProductosJSON($trannum);

                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0; $i=1; $valRetencion = 0;
                    $invexento = $infoDoc->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0; $valPercepcion = 0;
                    $vnNoSujeta = 0; $totalNoSujeta = 0;

                    $dteProductos = array();
                    foreach($infoProductos as $infoPro) {

                        if ($infoPro->tax1 != 0 && $invexento == 0) {
                            $total        = $total + (($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100))) * abs($infoPro->cantidad));
                            $totalIVA     = $totalIVA + (($infoPro->precioneto * ($infoPro->tax1 / 100)) * abs($infoPro->cantidad));
                            $totalGravado = $totalGravado + $infoPro->precioneto * abs($infoPro->cantidad);
                            
                            $vnExenta   = 0;
                            $vnNoSujeta = 0;
                            $vnGravada  = number_format(round($infoPro->precioneto * abs($infoPro->cantidad), 4), 4, '.', '');

                        } else if ( $infoPro->tax1 == 0 && $infoPro->nosujeta == 1) {
                            $total         = $total + (($infoPro->precioneto) * abs($infoPro->cantidad));
                            $totalNoSujeta = $totalNoSujeta + $infoPro->precioneto * abs($infoPro->cantidad);
                            
                            $vnNoSujeta = number_format(round($infoPro->precioneto * abs($infoPro->cantidad), 4), 4, '.', '');
                            $vnExenta   = 0;
                            $vnGravada  = 0;
                        } else {
                            $total       = $total + (($infoPro->precioneto) * abs($infoPro->cantidad));
                            $totalExento = $totalExento + $infoPro->precioneto * abs($infoPro->cantidad);
                            
                            $vnExenta   = number_format(round($infoPro->precioneto * abs($infoPro->cantidad), 4), 4, '.', '');
                            $vnGravada  = 0;
                            $vnNoSujeta = 0;
                        }

                        $preciouni = $infoPro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($infoPro->descuento != 0 && $infoPro->descuento != "" && $vnGravada != ""){
                            $discount =  ($infoPro->descuento/100) * $vnGravada;
                        }
                        
                        if($infoPro->vnNotas != ""){
                            $notas = strtoupper(trim($infoPro->vnNotas));
                        }else{
                            $notas = "";
                        }

                        if($infoPro->tipo == "4") {
                            $idpro = "";
                            $nombrepro = strtoupper(trim($notas));

                            if ( $nombrepro == '' ) {
                                $nombrepro = strtoupper(trim($infoPro->descrip));
                            }
                        }else{
                            $idpro = $infoPro->idproducto;
                            $nombrepro = strtoupper(trim($infoPro->descrip)).' '.$notas;
                        }

                        if ($infoPro->precioneto != 0) {
                            $dteProductos[] = array(
                                'numItem'         => $i,
                                'tipoItem'        => 1, // CAT-011 CAT-015
                                'numeroDocumento' => null,
                                'cantidad'        => abs($infoPro->cantidad),
                                'codigo'          => $infoPro->idproducto,
                                'codTributo'      => null,  // CAT-015
                                'uniMedida'       => 59, // CAT-014
                                'descripcion'     => strtoupper($nombrepro),
                                'precioUni'       => (float) round($infoPro->precioneto, 6),
                                'montoDescu'      => 0,
                                'ventaNoSuj'      => (float) round($vnNoSujeta, 4),
                                'ventaExenta'     => (float) round($vnExenta, 4),
                                'ventaGravada'    => (float) round($vnGravada, 4),
                                'tributos'        => ($vnGravada != 0) ? ['20'] : null, // CAT-015
                                'psv'             => 0,
                                'noGravado'       => 0,
                            );

                            $i++;
                        }
                    }

                    $fileDteJson->cuerpoDocumento = $dteProductos;
                    
                    $totalOperacion = $total;

                    if ( intval($tipoContribuyente) == 1 ) {
                        if ( $infoDoc->idtipo != 3 ) {
                            if ( $totalGravado >= 100 ) {
                                $valPercepcion = $totalGravado * 0.01;
                            }
                        }
                    } else {
                        if ( $infoDoc->idtipo == 3 ) {
                            if ( $totalGravado >= 100 ) {
                                $valRetencion = $totalGravado * 0.01;
                            }
                        }
                    }

                    if ( $valRetencion != 0 ) {
                        $total = $total - number_format($valRetencion, 2 , '.', '');
                    }

                    if ($valPercepcion != 0) {
                        $total = $total + number_format($valPercepcion, 2 , '.', '');
                    }

                    $tributos = array(
                        'codigo'      => '20', // CAT-015
                        'descripcion' => 'Impuesto al Valor Agregado 13%', // CAT-015
                        'valor'       => (float) number_format($totalIVA, 2, '.', ''),
                    );

                    $idPagoDTE = $this->dte_model->getFormaDePagoDocumento($trannum);

                    $pagos = array(
                        'codigo'     => $idPagoDTE,
                        'montoPago'  => (float) round($total, 2),
                        'referencia' => '',
                        'plazo'      => ($idPagoDTE == '13') ? '01' : null,
                        'periodo'    => ($idPagoDTE == '13') ? intval($infoDoc->dias) : null,
                    );

                    //NOTE: Resumen
                    $fileDteJson->resumen = array(
                        'totalNoSuj'          => (float) round($totalNoSujeta, 2),
                        'totalExenta'         => (float) round($totalExento, 2),
                        'totalGravada'        => (float) round($totalGravado, 2),
                        'subTotalVentas'      => (float) round($totalGravado + $totalExento + $totalNoSujeta, 2),
                        'descuNoSuj'          => 0,
                        'descuExenta'         => 0,
                        'descuGravada'        => 0,
                        'porcentajeDescuento' => 0,
                        'totalDescu'          => 0,
                        'tributos'            => ($totalGravado != 0) ? [$tributos] : null,
                        'subTotal'            => (float) round($totalGravado + $totalExento + $totalNoSujeta, 2),
                        'ivaRete1'            => (float) round($valRetencion, 2),
                        'ivaPerci1'           => (float) round($valPercepcion, 2),
                        'reteRenta'           => 0,
                        'montoTotalOperacion' => (float) round($totalOperacion, 2),
                        'totalNoGravado'      => 0,
                        'totalPagar'          => (float) round($total, 2),
                        'totalLetras'         => $this->valorEnLetras(round($total, 2)),
                        // 'totalIva'            => 0,
                        'saldoFavor'          => 0,
                        'condicionOperacion'  => ($idPagoDTE == '13') ? 2 : 1,
                        'pagos'               => [$pagos],
                        'numPagoElectronico'  => null
                    );

                    //NOTE: Extensión
                    $fileDteJson->extension = array(
                        'nombEntrega' => null, //'',
                        'docuEntrega'   => null, //'',
                        'nombRecibe'    => null, //'',
                        'docuRecibe'    => null, //'',
                        'observaciones' => null, //'',
                        'placaVehiculo' => null, //'',
                    );
                    
                    //NOTE: Apéndice
                    
                    if ($docApendice) {
                        $datoApendice = array();

                        $datoApendice[] = array(
                            'campo'    => 'OrdenCompra',
                            'etiqueta' => 'Número de orden de compra',
                            'valor'    => ''.$infoDoc->referencia.'',
                        );

                        $fileDteJson->apendice = $datoApendice;
                    } else $fileDteJson->apendice = null;

                    // echo json_encode($fileDteJson);

                    //NOTE: Sello Recepción recibido....

                    try {
                        //NOTE: FIRMAR DOCUMENTO JSON

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/");
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Content-Type:application/json'
                        ));
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit"         => ''.str_replace('-', '', $NIT).'',
                            "activo"      => true,
                            "passwordPri" => $pwdPrivate,
                            "dteJson"     => $fileDteJson
                        )));
                        
                        $Resolve = curl_exec($RestApi);

                        // print_r($Resolve);
                        curl_close($RestApi);

                        $resultFirma = json_decode($Resolve, true);
                        
                        if( $resultFirma['status'] == 'OK' ){

                            //NOTE: AUTORIZACION API MH
                            $docJsonFirmado = $resultFirma['body'];

                            if ($infoJSON) {
                                return $jsonFiles = array(
                                    'fileDteJson' => $fileDteJson,
                                    'docJsonFirmado' => $docJsonFirmado
                                );
                            }

                            //NOTE: RECEPCION DE DOCUMENTO MH
                            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/recepciondte" : "https://api.dtes.mh.gob.sv/fesv/recepciondte";

                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_CONNECTTIMEOUT, 5); // Tiempo máximo para conectar (5 segundos)
                            curl_setopt($RestApi, CURLOPT_TIMEOUT, 10);  // Tiempo máximo para la solicitud completa (10 segundos)
                            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Authorization: ' . $this->session->userdata('tokenJson'),
                                'Content-Type:application/json',
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "ambiente"  => $codAmbiente,
                                "idEnvio"   => $trannum,
                                "version"   => 3,
                                "tipoDte"   => "03",
                                "documento" => $docJsonFirmado,
                                "codigoGeneracion" => $cGeneracion
                            )));

                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultMH = json_decode($Resolve, true);

                            if ($resultMH['estado'] == 'PROCESADO') {
                                // print_r($Resolve);
                                // if ($codAmbiente == '01') {
                                    $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH));
                                // }

                                $msgSuccess = 'Código Generación: '.$resultMH['codigoGeneracion'].'<br>Sello Recibido: '.$resultMH['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum, 0, $this->session->userdata('dteSendPrint'), $this->session->userdata('dteSendEmail'));
                            } else {
                                // echo json_encode($fileDteJson);
                                // print_r($Resolve);
                                $detErrores = implode(",", $resultMH['observaciones']);
                                $msgError   = $resultMH['descripcionMsg'].'<br>Errores: '.$detErrores;

                                echo $this->sweetAlertError('DTE Presenta Errores', 'Código Generación: '.$cGeneracion.'<br>'.$msgError, $trannum);
                            }
                        } else {
                            echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum);
                }
                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function facturaConsumidorFinalDTE($trannum, $infoJSON = false) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum);

                if (!$infoDTE) {
                    $fecha = new DateTime();
                    $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum);

                    if ($this->session->userdata('codAmbiente') == '01') {
                        $rSerie = strpos($infoDoc->serie, 'DTE');
                        if ( $rSerie === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que no es un DTE');
                            exit;
                        }

                        $dateD = date_create($infoDoc->fecha);
                        $dYear = substr(date_format($dateD, 'Y'), 2, 2);
                        $rYear = strpos($infoDoc->serie, $dYear);
                        if ( $rYear === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que contiene una serie de otro año');
                            exit;
                        }
                    }
                    
                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

                    if ( $dteSucursal == 0 ) {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                        
                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);

                        $tipoContribuyente = $this->global_model->getDatoTipoContribuyenteEmp('g_empdatos', 10);
                    } else {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);
                        
                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);

                        $tipoContribuyente = $this->global_model->getDatoTipoContribuyenteEmp('g_empdatos_0'.$infoDoc->idcentro, 10);
                    }

                    $docRelacionado  = false;
                    $otrosDocumentos = false;
                    $ventaTercero    = false;
                    $docApendice     = false;

                    $fileDteJson = new stdClass();

                    //NOTE: Identificacion JSON

                    if ($codAmbiente == '00') {
                        $numControl  = 'DTE-01-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad(rand(1000, 5000), 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "FCF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8A5486".str_pad(rand(1000, 5000), 6, '0', STR_PAD_LEFT);
                    } else {
                        $numControl  = 'DTE-01-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "FCF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                    }
                    
                    $datetime1 = date_create($infoDoc->fecha);
                    $datetime2 = $fecha->format('Y-m-d');

                    $tipoModelo  = ( $datetime1->format('Y-m-d') != $datetime2 ) ? 2 : 1;

                    $fileDteJson->identificacion = array(
                        'version'           => 1,
                        'ambiente'          => $codAmbiente,        // CAT-001
                        'tipoDte'           => '01',                // CAT-002
                        'numeroControl'     => $numControl,
                        'codigoGeneracion'  => $cGeneracion,
                        'tipoModelo'        => 1, //intval($tipoModelo), // CAT-003
                        'tipoOperacion'     => 1,                   // CAT-004
                        'tipoContingencia'  => null,                // CAT-005
                        'motivoContin'      => null,
                        'fecEmi'            => ($codAmbiente == '00') ? $fecha->format('Y-m-d') : $infoDoc->fecha, // YYYY-MM-DD
                        'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                        'tipoMoneda'        => 'USD'
                    );

                    //NOTE: Documentos Relacionados JSON (Opcional Segun Requerimientos)

                    if ($docRelacionado) {
                        $fileDteJson->documentoRelacionado = array(
                            'tipoDocumento'     => '', // CAT-002
                            'tipoGeneracion'    => '', // CAT-007
                            'numeroDocumento'   => '',
                            'fechaEmision'      => ''
                        );
                    } else $fileDteJson->documentoRelacionado = null;
                    
                    //NOTE: Emisor JSON
                    
                    $fileDteJson->emisor = array(
                        'nit'                 => ''.str_replace('-', '', $NIT).'',
                        'nrc'                 => ''.str_replace('-', '', $NRC).'',
                        'nombre'              => strtoupper($razonSocial),
                        'codActividad'        => $cActividad, // CAT-019
                        'descActividad'       => strtoupper($GIRO), // CAT-019
                        'nombreComercial'     => strtoupper($nComercial),
                        'tipoEstablecimiento' => '02', // CAT-009
                        'direccion' => array(
                            'departamento'    => ($infoDoc->iddeptodtesuc == 0) ? $cDepartamento : $infoDoc->iddeptodtesuc, // CAT-012
                            'municipio'       => ($infoDoc->idmunidtesuc == 0) ? $cMunicipio : $infoDoc->idmunidtesuc, // CAT-013
                            'complemento'     => ($infoDoc->direccionsucursal == "") ? strtoupper($direccion) : $infoDoc->direccionsucursal
                        ),
                        'telefono'            => str_replace('-', '', $telefono),
                        'codEstable'          => ''.strtoupper($infoDoc->centromh).'',
                        'codEstableMH'        => ''.strtoupper($infoDoc->centromh).'',
                        'codPuntoVentaMH'     => ''.strtoupper($infoDoc->cajamh).'',
                        'codPuntoVenta'       => ''.strtoupper($infoDoc->cajamh).'',
                        'correo'              => $correoEl,
                    );
                    
                    //NOTE: Receptor JSON
                    
                    $tipoDocumento = ($infoDoc->dui == '') ? (($infoDoc->nit == '') ? null : '36') : '13';

                    $infoDUI = str_replace('-', '', $infoDoc->dui);
                    $numeroDUI = substr($infoDUI, 0, -1).'-'.substr($infoDUI, 8, 9);

                    if ($codAmbiente == '00') {
                        $fileDteJson->receptor = array(
                            'tipoDocumento'    => '13', // CAT-022
                            'numDocumento'     => '05468527-6',
                            'nrc'              => null,
                            'nombre'           => 'KEVIN IVAN CIENFUEGOS ORELLANA',
                            'codActividad'     => null,
                            'descActividad'    => null,
                            'direccion'        => null,
                            'telefono'         => '22564532',
                            'correo'           => 'correo@correo.com'
                        );
                    } else {
                        $fileDteJson->receptor = array(
                            'tipoDocumento'    => $tipoDocumento, // CAT-022
                            'numDocumento'     => ($tipoDocumento == null) ? null : (($tipoDocumento == '13') ? ''.$numeroDUI.'' : ''.str_replace('-', '', $infoDoc->nit).''),
                            'nrc'              => ($infoDoc->nrc == '') ? null : ''.str_replace('-', '', $infoDoc->nrc).'',
                            'nombre'           => $infoDoc->nameCliente,
                            'codActividad'     => ($infoDoc->dte_giro == '' ? null : $infoDoc->dte_giro), // CAT-019
                            'descActividad'    => ($infoDoc->dte_giro == '' ? null : $infoDoc->dte_giro_des), // CAT-019
                            //'codActividad'     => null,
                            //'descActividad'    => null,
                            'direccion' => array(
                                'departamento' => $infoDoc->iddeptodte, // CAT-012
                                'municipio'    => $infoDoc->idmunidte,  // CAT-013
                                'complemento'  => ($infoDoc->direccion == "") ? "SAN SALVADOR" : $infoDoc->direccion,
                            ),
                            'telefono'         => ($infoDoc->telefono == '' ? null : str_replace('-', '', $infoDoc->telefono)),
                            'correo'           => ($infoDoc->correo == '' ? null : $infoDoc->correo)
                        );
                    }
                    
                    //NOTE: Otros Documentos Asociados
                    
                    if ($otrosDocumentos) {
                        $fileDteJson->otrosDocumentos = array(
                            'codDocAsociado'   => '',
                            'descDocumento'    => '',
                            'detalleDocumento' => '',
                            'medico' => array(
                                'nombre'            => '',
                                'nit'               => '',
                                'docIdentificacion' => '',
                                'tipoServicio'      => '',
                            )
                        );
                    } else $fileDteJson->otrosDocumentos = null;
                                    
                    //NOTE: Ventas por Cuenta de Terceros
                    
                    if ($ventaTercero) {
                        $fileDteJson->ventaTercero = array(
                            'nit'    => '',
                            'nombre' => '',
                        );
                    } else $fileDteJson->ventaTercero = null;

                    //NOTE: Cuerpo del Documento (ForEach Items)
                    
                    $infoProductos = $this->dte_model->getDetalleProductosJSON($trannum);

                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0; $i=1; $valRetencion = 0; $totalNoSujeta = 0;
                    $invexento = $infoDoc->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0; $vnNoSujeta = 0;

                    $dteProductos = array();
                    foreach($infoProductos as $infoPro) {
                        if ($infoPro->tax1 != 0 && $invexento == 0) {
                            $total        = $total + (($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100))) * abs($infoPro->cantidad));
                            $totalIVA     = $totalIVA + (($infoPro->precioneto * ($infoPro->tax1 / 100)) * abs($infoPro->cantidad));
                            $totalGravado = $totalGravado + (($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100))) * abs($infoPro->cantidad));
                            
                            $vnExenta   = 0;
                            $vnNoSujeta = 0;
                            $vnGravada  = number_format(round(($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100))) * abs($infoPro->cantidad), 6), 6, '.', '');
                        } else if ($infoPro->tax1 == 0 && $infoPro->nosujeta == 1) { 
                            $total         = $total + (($infoPro->precioneto) * abs($infoPro->cantidad));
                            $totalNoSujeta = $totalNoSujeta + $infoPro->precioneto * abs($infoPro->cantidad);
                            
                            $vnNoSujeta = number_format(round($infoPro->precioneto * abs($infoPro->cantidad), 6), 6, '.', '');
                            $vnExenta   = 0;
                            $vnGravada  = 0;
                        } else {
                            $total       = $total + (($infoPro->precioneto) * abs($infoPro->cantidad));
                            $totalExento = $totalExento + $infoPro->precioneto * abs($infoPro->cantidad);
                            
                            $vnExenta   = number_format(round($infoPro->precioneto * abs($infoPro->cantidad), 6), 6, '.', '');
                            $vnGravada  = 0;
                            $vnNoSujeta = 0;
                        }

                        $preciouni = ($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100)));
                        $preciouni = number_format(abs($preciouni), 6 ,'.','');
                        
                        if($infoPro->descuento != 0 && $infoPro->descuento != "" && $vnGravada != ""){
                            $discount =  ($infoPro->descuento/100) * $vnGravada;
                        }
                        
                        if($infoPro->vnNotas != ""){
                            $notas = strtoupper(trim($infoPro->vnNotas));
                        }else{
                            $notas = "";
                        }

                        if($infoPro->tipo == "4"){
                            $idpro = "";
                            $nombrepro = strtoupper(trim($notas));

                            if ( $nombrepro == '' ) {
                                $nombrepro = strtoupper(trim($infoPro->descrip));
                            }
                        }else{
                            $idpro = $infoPro->idproducto;
                            $nombrepro = strtoupper(trim($infoPro->descrip)).' '.$notas;
                        }
                        
                        if ($infoPro->precioneto != 0) {
                            $dteProductos[] = array(
                                'numItem'         => $i,
                                'tipoItem'        => 1, // CAT-011 CAT-015
                                'numeroDocumento' => null,
                                'cantidad'        => abs($infoPro->cantidad),
                                'codigo'          => $infoPro->idproducto,
                                'codTributo'      => null,  // CAT-015
                                'uniMedida'       => 59, // CAT-014
                                'descripcion'     => strtoupper($nombrepro),
                                'precioUni'       => (float) number_format($preciouni, 6, '.', ''),
                                'montoDescu'      => 0,
                                'ventaNoSuj'      => (float) number_format($vnNoSujeta, 6, '.', ''),
                                'ventaExenta'     => (float) number_format($vnExenta, 6, '.', ''),
                                'ventaGravada'    => (float) number_format($vnGravada, 6, '.', ''),
                                'tributos'        => null, // CAT-015
                                'psv'             => 0,
                                'noGravado'       => 0,
                                'ivaItem'         => ($vnGravada != 0) ? (float) number_format((($infoPro->precioneto * ($infoPro->tax1 / 100)) * abs($infoPro->cantidad)), 6, '.', '') : 0,
                            );

                            $i++;
                        }
                    }

                    $fileDteJson->cuerpoDocumento = $dteProductos;

                    $totalOperacion = $total;

                    if ( intval($tipoContribuyente) == 0 ) {
                        if ( $infoDoc->idtipo == 3 ) {
                            if ( ($totalGravado / 1.13) >= 100 ) {
                                $valRetencion = ($totalGravado / 1.13) * 0.01;
                            }
                        }
                    }

                    if ( $valRetencion != 0 ) {
                        $total = $total - number_format($valRetencion, 2 , '.', '');
                    }
                    
                    $tributos = array(
                        'codigo'      => '20', // CAT-015
                        'descripcion' => 'Impuesto al Valor Agregado 13%', // CAT-015
                        'valor'       => (float) number_format($totalIVA, 2, '.', ''),
                    );

                    $idPagoDTE = $this->dte_model->getFormaDePagoDocumento($trannum);

                    $pagos = array(
                        'codigo'     => $idPagoDTE,
                        'montoPago'  => (float) number_format($total, 2, '.', ''),
                        'referencia' => '',
                        'plazo'      => ($idPagoDTE == '13') ? '01' : null,
                        'periodo'    => ($idPagoDTE == '13') ? intval($infoDoc->dias) : null,
                    );

                    //NOTE: Resumen
                    $fileDteJson->resumen = array(
                        'totalNoSuj'          => (float) round($totalNoSujeta, 2),
                        'totalExenta'         => (float) round($totalExento, 2),
                        'totalGravada'        => (float) round($totalGravado, 2),
                        'subTotalVentas'      => (float) round($totalExento + $totalGravado + $totalNoSujeta, 2),
                        'descuNoSuj'          => 0,
                        'descuExenta'         => 0,
                        'descuGravada'        => 0,
                        'porcentajeDescuento' => 0,
                        'totalDescu'          => 0,
                        'tributos'            => null,
                        'subTotal'            => (float) round($totalExento + $totalGravado + $totalNoSujeta, 2),
                        'ivaRete1'            => (float) round($valRetencion, 2),
                        'reteRenta'           => 0,
                        'montoTotalOperacion' => (float) round($totalOperacion, 2),
                        'totalNoGravado'      => 0,
                        'totalPagar'          => (float) round($total, 2),
                        'totalLetras'         => $this->valorEnLetras(round($total, 2)),
                        'totalIva'            => (float) round($totalIVA, 2),
                        'saldoFavor'          => 0,
                        'condicionOperacion'  => ($idPagoDTE == '13') ? 2 : 1,
                        'pagos'               => [$pagos],
                        'numPagoElectronico'  => null
                    );

                    //NOTE: Extensión
                    $fileDteJson->extension = array(
                        'nombEntrega' => null, //'',
                        'docuEntrega'   => null, //'',
                        'nombRecibe'    => null, //'',
                        'docuRecibe'    => null, //'',
                        'observaciones' => null, //'',
                        'placaVehiculo' => null, //'',
                    );
                    
                    //NOTE: Apéndice
                    
                    if ($docApendice) {
                        $fileDteJson->apendice = array(
                            'campo'    => '',
                            'etiqueta' => '',
                            'valor'    => '',
                        );
                    } else $fileDteJson->apendice = null;

                    //NOTE: Sello Recepción recibido....

                    try {
                        //NOTE: FIRMAR DOCUMENTO JSON

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/");
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Content-Type:application/json'
                        ));
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit"         => ''.str_replace('-', '', $NIT).'',
                            "activo"      => true,
                            "passwordPri" => $pwdPrivate,
                            "dteJson"     => $fileDteJson
                        )));
                        
                        $Resolve = curl_exec($RestApi);

                        curl_close($RestApi);

                        $resultFirma = json_decode($Resolve, true);
                        
                        if( $resultFirma['status'] == 'OK' ){

                            $docJsonFirmado = $resultFirma['body'];

                            if ($infoJSON) {
                                return $jsonFiles = array(
                                    'fileDteJson' => $fileDteJson,
                                    'docJsonFirmado' => $docJsonFirmado
                                );
                            }

                            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/recepciondte" : "https://api.dtes.mh.gob.sv/fesv/recepciondte";
                            
                            //NOTE: RECEPCION DE DOCUMENTO MH

                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_CONNECTTIMEOUT, 5); // Tiempo máximo para conectar (5 segundos)
                            curl_setopt($RestApi, CURLOPT_TIMEOUT, 10);  // Tiempo máximo para la solicitud completa (10 segundos)
                            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Authorization: ' . $this->session->userdata('tokenJson'),
                                'Content-Type:application/json',
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "ambiente"  => $codAmbiente,
                                "idEnvio"   => $trannum,
                                "version"   => 1,
                                "tipoDte"   => "01",
                                "documento" => $docJsonFirmado,
                                "codigoGeneracion" => $cGeneracion
                            )));

                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultMH = json_decode($Resolve, true);

                            if ($resultMH['estado'] == 'PROCESADO') {
                                // print_r($Resolve);
                                // if ($codAmbiente == '01') {
                                    $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH));
                                // }
                                $msgSuccess = 'Código Generación: '.$resultMH['codigoGeneracion'].'<br>Sello Recibido: '.$resultMH['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum, 0, $this->session->userdata('dteSendPrint'), $this->session->userdata('dteSendEmail'));
                            } else {
                                // echo json_encode($fileDteJson);
                                // print_r($Resolve);
                                $detErrores = implode(",", $resultMH['observaciones']);
                                $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                                echo $this->sweetAlertError('DTE Presenta Errores', 'Código Generación: '.$cGeneracion.'<br>'.$msgError, $trannum);
                            }
                        } else {
                            echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum);
                }
                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function facturaDeExportacionDTE($trannum, $infoJSON = false) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum);

                if (!$infoDTE) {
                    $fecha = new DateTime();
                    $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum);

                    if ($this->session->userdata('codAmbiente') == '01') {
                        $rSerie = strpos($infoDoc->serie, 'DTE');
                        if ( $rSerie === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que no es un DTE');
                            exit;
                        }

                        $dateD = date_create($infoDoc->fecha);
                        $dYear = substr(date_format($dateD, 'Y'), 2, 2);
                        $rYear = strpos($infoDoc->serie, $dYear);
                        if ( $rYear === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que contiene una serie de otro año');
                            exit;
                        }
                    }
                    
                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    
                    if ( $dteSucursal == 0 ) {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                        
                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);
                    } else {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);
                        
                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);
                    }

                    $otrosDocumentos = false;
                    $ventaTercero    = false;
                    $docApendice     = false;

                    $fileDteJson = new stdClass();

                    //NOTE: Identificacion JSON
                    if ($codAmbiente == '00') {
                        $numControl  = 'DTE-11-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad(rand(1000, 5000), 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "FE0".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8A5486".str_pad(rand(1000, 5000), 6, '0', STR_PAD_LEFT);
                    } else {
                        $numControl  = 'DTE-11-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "FE0".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                    }
                    
                    $fileDteJson->identificacion = array(
                        'version'           => 1,
                        'ambiente'          => $codAmbiente,    // CAT-001
                        'tipoDte'           => '11',    // CAT-002
                        'numeroControl'     => $numControl,
                        'codigoGeneracion'  => $cGeneracion,
                        'tipoModelo'        => 1,       // CAT-003
                        'tipoOperacion'     => 1,       // CAT-004
                        'tipoContingencia'  => null,    // CAT-005
                        'motivoContigencia' => null,
                        'fecEmi'            => ($codAmbiente == '00') ? $fecha->format('Y-m-d') : $infoDoc->fecha, // YYYY-MM-DD
                        'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                        'tipoMoneda'        => 'USD'
                    );                   
                    
                    //NOTE: Emisor JSON
                    
                    $fileDteJson->emisor = array(
                        'nit'                 => ''.str_replace('-', '', $NIT).'',
                        'nrc'                 => ''.str_replace('-', '', $NRC).'',
                        'nombre'              => strtoupper($razonSocial),
                        'codActividad'        => $cActividad, // CAT-019
                        'descActividad'       => strtoupper($GIRO), // CAT-019
                        'nombreComercial'     => strtoupper($nComercial),
                        'tipoEstablecimiento' => '02', // CAT-009
                        'direccion' => array(
                            'departamento'    => ($infoDoc->iddeptodtesuc == 0) ? $cDepartamento : $infoDoc->iddeptodtesuc, // CAT-012
                            'municipio'       => ($infoDoc->idmunidtesuc == 0) ? $cMunicipio : $infoDoc->idmunidtesuc, // CAT-013
                            'complemento'     => ($infoDoc->direccionsucursal == "") ? strtoupper($direccion) : $infoDoc->direccionsucursal
                        ),
                        'telefono'            => str_replace('-', '', $telefono),
                        'codEstable'          => ''.strtoupper($infoDoc->centromh).'',
                        'codEstableMH'        => ''.strtoupper($infoDoc->centromh).'',
                        'codPuntoVentaMH'     => ''.strtoupper($infoDoc->cajamh).'',
                        'codPuntoVenta'       => ''.strtoupper($infoDoc->cajamh).'',
                        'tipoItemExpor'       => 2, // 1,2,3
                        'recintoFiscal'       => null, //
                        'regimen'             => null, //
                        'correo'              => $correoEl,
                    );
                    
                    //NOTE: Receptor JSON
                    
                    // $tipoDocumento = ($infoDoc->dui == '') ? '36' : '13';
                    $tipoDocumento = '37';
                    if ($codAmbiente == '00') {
                        $fileDteJson->receptor = array(
                            'tipoDocumento'    => $tipoDocumento, // CAT-022
                            'numDocumento'     => '054685276',
                            'nombre'           => 'KEVIN IVAN CIENFUEGOS ORELLANA',
                            'nombreComercial'  => null,
                            'codPais'          => '9483',
                            'nombrePais'       => 'GUATEMALA',
                            'complemento'      => 'DIRECCION DE PRUEBA',
                            'tipoPersona'      => 1, //1, 2
                            'descActividad'    => 'GIRO DE PRUEBA FACTURACION', // CAT-019
                            'telefono'         => '22564532',
                            'correo'           => 'correo@correo.com'
                        );
                    } else {
                        $fileDteJson->receptor = array(
                            'tipoDocumento'    => $tipoDocumento, // CAT-022
                            'numDocumento'     => ($infoDoc->dui == '') ? ''.str_replace('-', '', $infoDoc->nit).'' : ''.str_replace('-', '', $infoDoc->dui).'',
                            'nombre'           => $infoDoc->nameCliente,
                            'nombreComercial'  => null,
                            'codPais'          => $infoDoc->idpaisdte,
                            'nombrePais'       => $infoDoc->pais,
                            'complemento'      => $infoDoc->direccion,
                            'tipoPersona'      => 1, //1, 2
                            'descActividad'    => ($infoDoc->dte_giro == '' ? 'Venta al por menor de otros productos n.c.p.' : $infoDoc->dte_giro_des), // CAT-019
                            'telefono'         => ($infoDoc->telefono == '' ? null : ''.str_replace('-', '', $infoDoc->telefono).''),
                            'correo'           => ($infoDoc->correo == '' ? 'correo@correo.com' : $infoDoc->correo)
                        );
                    }
                    
                    //NOTE: Otros Documentos Asociados
                    
                    if ($otrosDocumentos) {
                        $fileDteJson->otrosDocumentos = array(
                            'codDocAsociado'   => '',
                            'descDocumento'    => '',
                            'detalleDocumento' => '',
                            'medico' => array(
                                'nombre'            => '',
                                'nit'               => '',
                                'docIdentificacion' => '',
                                'tipoServicio'      => '',
                            )
                        );
                    } else $fileDteJson->otrosDocumentos = null;
                                    
                    //NOTE: Ventas por Cuenta de Terceros
                    
                    if ($ventaTercero) {
                        $fileDteJson->ventaTercero = array(
                            'nit'    => '',
                            'nombre' => '',
                        );
                    } else $fileDteJson->ventaTercero = null;

                    //NOTE: Cuerpo del Documento (ForEach Items)
                    
                    $infoProductos = $this->dte_model->getDetalleProductosJSON($trannum);

                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0; $i=1;
                    $invexento = $infoDoc->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                    $totalSeguro = 0; $totalFlete = 0; $nPro = 0;

                    $dteProductos = array();
                    foreach($infoProductos as $infoPro) {
                        $nPro    = 0;
                        $cFlete  = strpos($infoPro->descrip, 'FLETE');
                        $cSeguro = strpos($infoPro->descrip, 'SEGURO');

                        if ($infoPro->tax1 != 0 && $invexento == 0) {
                            $total        = $total + (($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100))) * abs($infoPro->cantidad));
                            $totalIVA     = $totalIVA + (($infoPro->precioneto * ($infoPro->tax1 / 100)) * abs($infoPro->cantidad));
                            $totalGravado = $totalGravado + (($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100))) * abs($infoPro->cantidad));
                            
                            $vnExenta  = 0;
                            $vnGravada = number_format(round(($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100))) * abs($infoPro->cantidad), 4), 4, '.', '');

                            $preciouni = ($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100)));
                            $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        } else {
                            $total = $total + ((round($infoPro->precioneto, 6)) * abs($infoPro->cantidad));

                            if ( $cFlete !== false ) {
                                $nPro = 1;
                                $totalFlete = $totalFlete + number_format(round(round($infoPro->precioneto, 2) * abs($infoPro->cantidad), 2), 2, '.', '');
                            } else if ( $cSeguro !== false ) {
                                $nPro = 1;
                                $totalSeguro = $totalSeguro + number_format(round(round($infoPro->precioneto, 2) * abs($infoPro->cantidad), 2), 2, '.', '');
                            } else {
                                $totalExento = $totalExento + round($infoPro->precioneto, 6) * abs($infoPro->cantidad);
                            
                                $vnExenta  = number_format(round(round($infoPro->precioneto, 6) * abs($infoPro->cantidad), 6), 6, '.', '');
                                $vnGravada = 0;

                                $preciouni = $infoPro->precioneto;
                                $preciouni = number_format(abs($preciouni), 6 ,'.','');
                            }
                        }

                        if($infoPro->descuento != 0 && $infoPro->descuento != "" && $vnGravada != ""){
                            $discount =  ($infoPro->descuento/100) * $vnGravada;
                        }
                        
                        if($infoPro->vnNotas != ""){
                            $notas = strtoupper(trim($infoPro->vnNotas));
                        }else{
                            $notas = "";
                        }

                        if($infoPro->tipo == "4"){
                            $idpro = "";
                            $nombrepro = strtoupper(trim($notas));
                            
                            if ( $nombrepro == '' ) {
                                $nombrepro = strtoupper(trim($infoPro->descrip));
                            }
                        }else{
                            $idpro = $infoPro->idproducto;
                            $nombrepro = strtoupper(trim($infoPro->descrip)).' '.$notas;
                        }

                        if ($infoPro->precioneto != 0) {
                            if ($nPro == 0) {
                                $dteProductos[] = array(
                                    'numItem'         => $i,
                                    'cantidad'        => abs($infoPro->cantidad),
                                    'codigo'          => $infoPro->idproducto,
                                    'uniMedida'       => 59, // CAT-014
                                    'descripcion'     => strtoupper($nombrepro),
                                    'precioUni'       => (float) number_format($preciouni, 6, '.', ''),
                                    'montoDescu'      => 0,
                                    'ventaGravada'    => (float) number_format($vnExenta, 6, '.', ''),
                                    'tributos'        => ['C3'], // CAT-015
                                    'noGravado'       => 0,
                                );
    
                                $i++;
                            }
                        }
                    }

                    $fileDteJson->cuerpoDocumento = $dteProductos;
                    
                    $idPagoDTE = $this->dte_model->getFormaDePagoDocumento($trannum);

                    $pagos = array(
                        'codigo'     => $idPagoDTE,
                        'montoPago'  => (float) number_format($total, 2, '.', ''),
                        'referencia' => '',
                        'plazo'      => ($idPagoDTE == '13') ? '01' : null,
                        'periodo'    => ($idPagoDTE == '13') ? intval($infoDoc->dias) : null,
                    );

                    //NOTE: Resumen
                    $fileDteJson->resumen = array(
                        'totalGravada'        => (float) number_format($totalExento, 2, '.', ''),
                        'descuento'           => 0,
                        'porcentajeDescuento' => 0,
                        'totalDescu'          => 0,
                        'seguro'              => (float) number_format($totalSeguro, 2, '.', ''),
                        'flete'                => (float) number_format($totalFlete, 2, '.', ''),
                        'montoTotalOperacion' => (float) number_format($total, 2, '.', ''),
                        'totalNoGravado'      => 0,
                        'totalPagar'          => (float) number_format($total, 2, '.', ''),
                        'totalLetras'         => $this->valorEnLetras(number_format($total, 2, '.', '')),
                        'condicionOperacion'  => ($idPagoDTE == '13') ? 2 : 1,
                        'pagos'               => [$pagos],
                        'numPagoElectronico'  => null,
                        'codIncoterms'        => null,
                        'descIncoterms'       => null,
                        'observaciones'       => null
                    );
                    
                    //NOTE: Apéndice
                    
                    if ($docApendice) {
                        $fileDteJson->apendice = array(
                            'campo'    => '',
                            'etiqueta' => '',
                            'valor'    => '',
                        );
                    } else $fileDteJson->apendice = null;

                    //NOTE: Sello Recepción recibido....

                    try {
                        //NOTE: FIRMAR DOCUMENTO JSON

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/"); //Por Empresa
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Content-Type:application/json'
                        ));
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit"         => ''.str_replace('-', '', $NIT).'',
                            "activo"      => true,
                            "passwordPri" => $pwdPrivate,
                            "dteJson"     => $fileDteJson
                        )));
                        
                        $Resolve = curl_exec($RestApi);

                        // print_r($Resolve);
                        
                        curl_close($RestApi);

                        $resultFirma = json_decode($Resolve, true);
                        
                        if( $resultFirma['status'] == 'OK' ){

                            //NOTE: AUTORIZACION API MH
                            $docJsonFirmado = $resultFirma['body'];

                            if ($infoJSON) {
                                return $jsonFiles = array(
                                    'fileDteJson' => $fileDteJson,
                                    'docJsonFirmado' => $docJsonFirmado
                                );
                            }

                            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/recepciondte" : "https://api.dtes.mh.gob.sv/fesv/recepciondte";
                            
                            //NOTE: RECEPCION DE DOCUMENTO MH

                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_CONNECTTIMEOUT, 5); // Tiempo máximo para conectar (5 segundos)
                            curl_setopt($RestApi, CURLOPT_TIMEOUT, 10);  // Tiempo máximo para la solicitud completa (10 segundos)
                            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Authorization: ' . $this->session->userdata('tokenJson'),
                                'Content-Type:application/json',
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "ambiente"  => $codAmbiente,
                                "idEnvio"   => $trannum,
                                "version"   => 1,
                                "tipoDte"   => "11",
                                "documento" => $docJsonFirmado,
                                "codigoGeneracion" => $cGeneracion
                            )));

                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultMH = json_decode($Resolve, true);

                            if ($resultMH['estado'] == 'PROCESADO') {
                                // print_r($Resolve);
                                // if ($codAmbiente == '01') {
                                    $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH));
                                // }
                                $msgSuccess = 'Código Generación: '.$resultMH['codigoGeneracion'].'<br>Sello Recibido: '.$resultMH['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum, 0, $this->session->userdata('dteSendPrint'), $this->session->userdata('dteSendEmail'));
                            } else {
                                // echo json_encode($fileDteJson);
                                // print_r($Resolve);
                                $detErrores = implode(",", $resultMH['observaciones']);
                                $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                                echo $this->sweetAlertError('DTE Presenta Errores', 'Código Generación: '.$cGeneracion.'<br>'.$msgError, $trannum);
                            }
                        } else {
                            echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum);
                }
                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function facturaSujetoExcluidoDTE($idrec, $idYear, $infoJSON = false) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $infoDTE = $this->dte_model->validateExistDocumentDte($idrec, 1, $idYear);
                
                if ( !$infoDTE ) {
                    $fecha   = new DateTime();
                    $infoDoc = $this->dte_model->getDatosIvaCentralJSON($idrec, $idYear);

                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    
                    if ( $dteSucursal == 0 ) {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);
                    } else {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);
                    }

                    $docRelacionado  = false;
                    $otrosDocumentos = false;
                    $ventaTercero    = false;
                    $docApendice     = false;

                    $fileDteJson = new stdClass();

                    //NOTE: Identificacion JSON
                    if ($codAmbiente == '00') {
                        $numControl  = 'DTE-14-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad(rand(1000, 5000), 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "EEF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8A5486".str_pad(rand(1000, 5000), 6, '0', STR_PAD_LEFT);
                    } else {
                        $numControl  = 'DTE-14-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->doc_numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "EEF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);
                    }
                    
                    $fileDteJson->identificacion = array(
                        'version'           => intval(1),
                        'ambiente'          => $codAmbiente,    // CAT-001
                        'tipoDte'           => '14',            // CAT-002
                        'numeroControl'     => $numControl,
                        'codigoGeneracion'  => $cGeneracion,
                        'tipoModelo'        => 1,               // CAT-003
                        'tipoOperacion'     => 1,               // CAT-004
                        'tipoContingencia'  => null,            // CAT-005
                        'motivoContin'      => null,
                        'fecEmi'            => ($codAmbiente == '00') ? $fecha->format('Y-m-d') : $infoDoc->fecha, // YYYY-MM-DD
                        'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                        'tipoMoneda'        => 'USD'
                    );
                    
                    //NOTE: Emisor JSON
                    
                    $fileDteJson->emisor = array(
                        'nit'                 => ''.str_replace('-', '', $NIT).'',
                        'nrc'                 => ''.str_replace('-', '', $NRC).'',
                        'nombre'              => strtoupper($razonSocial),
                        'codActividad'        => $cActividad, // CAT-019
                        'descActividad'       => strtoupper($GIRO), // CAT-019
                        // 'nombreComercial'     => strtoupper($nComercial),
                        // 'tipoEstablecimiento' => '02', // CAT-009
                        'direccion' => array(
                            'departamento'    => $cDepartamento, // CAT-012
                            'municipio'       => $cMunicipio, // CAT-013
                            'complemento'     => strtoupper($direccion)
                        ),
                        'telefono'            => str_replace('-', '', $telefono),
                        'codEstable'          => ''.strtoupper($infoDoc->centromh).'',
                        'codEstableMH'        => ''.strtoupper($infoDoc->centromh).'',
                        'codPuntoVentaMH'     => ''.strtoupper($infoDoc->cajamh).'',
                        'codPuntoVenta'       => ''.strtoupper($infoDoc->cajamh).'',
                        'correo'              => $correoEl,
                    );
                    
                    //NOTE: Receptor JSON
                    
                    $tipoDocumento = ($infoDoc->dui == '') ? '36' : '13';
                    
                    if ($codAmbiente == '00') {
                        $fileDteJson->sujetoExcluido = array(
                            'tipoDocumento'    => '13', // CAT-022
                            'numDocumento'     => '054685276',
                            'nombre'           => 'KEVIN IVAN CIENFUEGOS ORELLANA',
                            'codActividad'     => '47739', // CAT-019
                            'descActividad'    => 'Venta al por menor de otros productos n.c.p.', // CAT-019
                            'direccion' => array(
                                'departamento' => '06', // CAT-012
                                'municipio'    => '14',  // CAT-013
                                'complemento'  => 'DIRECCION DE PRUEBA'
                            ),
                            'telefono'         => null,
                            'correo'           => null
                        );
                    } else {
                        if ($tipoDocumento == '36') {
                            $fileDteJson->sujetoExcluido = array(
                                'tipoDocumento'    => $tipoDocumento, // CAT-022
                                'numDocumento'     => str_replace('-', '', $infoDoc->nit),
                                'nrc'              => null,
                                'nombre'           => $infoDoc->nameCliente,
                                'codActividad'     => ($infoDoc->dte_giro == '' ? '47739' : $infoDoc->dte_giro), // CAT-019
                                'descActividad'    => ($infoDoc->dte_giro == '' ? 'Venta al por menor de otros productos n.c.p.' : $infoDoc->dte_giro_des), // CAT-019
                                'direccion' => array(
                                    'departamento' => $infoDoc->iddeptodte, // CAT-012
                                    'municipio'    => $infoDoc->idmunidte,  // CAT-013
                                    'complemento'  => $infoDoc->direccion
                                ),
                                'telefono'         => ($infoDoc->telefono == '' ? null : str_replace('-', '', $infoDoc->telefono)),
                                'correo'           => ($infoDoc->correo == '' ? null : $infoDoc->correo)
                            );
                        } else {
                            $fileDteJson->sujetoExcluido = array(
                                'tipoDocumento'    => $tipoDocumento, // CAT-022
                                'numDocumento'     => str_replace('-', '', $infoDoc->dui),
                                'nombre'           => $infoDoc->nameCliente,
                                'codActividad'     => ($infoDoc->dte_giro == '' ? '47739' : $infoDoc->dte_giro), // CAT-019
                                'descActividad'    => ($infoDoc->dte_giro == '' ? 'Venta al por menor de otros productos n.c.p.' : $infoDoc->dte_giro_des), // CAT-019
                                'direccion' => array(
                                    'departamento' => $infoDoc->iddeptodte, // CAT-012
                                    'municipio'    => $infoDoc->idmunidte,  // CAT-013
                                    'complemento'  => $infoDoc->direccion
                                ),
                                'telefono'         => ($infoDoc->telefono == '' ? null : str_replace('-', '', $infoDoc->telefono)),
                                'correo'           => ($infoDoc->correo == '' ? null : $infoDoc->correo)
                            );
                        }
                    }
                    
                    //NOTE: Cuerpo del Documento (ForEach Items)                    

                    $total = 0; $i=1;
                    $arrayProductos = explode(";", $infoDoc->notas);

                    $dteProductos = array();
                    for($j=0; $j<count($arrayProductos)-1; $j++) {
                        $infoPro = explode("|", $arrayProductos[$j]);

                        $dteProductos[] = array(
                            'numItem'         => $i,
                            'tipoItem'        => 3, // CAT-011 CAT-015
                            'cantidad'        => (float) $infoPro[1],
                            'codigo'          => null,
                            'uniMedida'       => 99, // CAT-014
                            'descripcion'     => strtoupper($infoPro[0]),
                            'precioUni'       => (float) round($infoPro[2], 4),
                            'montoDescu'      => 0,
                            'compra'          => (float) round((round($infoPro[2], 4) * round($infoPro[1], 2)), 4),
                        );

                        $total += (round($infoPro[2], 4) * round($infoPro[1], 2));
                        $i++;
                    }

                    $fileDteJson->cuerpoDocumento = $dteProductos;
                    
                    $rRenta = abs($infoDoc->valor16);

                    if ($rRenta != 0) {
                        $subTotal = $total - $rRenta;
                    } else $subTotal = $total;

                    $pagos = array(
                        'codigo'     => '01',
                        'montoPago'  => (float) round($subTotal, 2),
                        'referencia' => '',
                        'plazo'      => null,
                        'periodo'    => null,
                    );

                    //NOTE: Resumen
                    $fileDteJson->resumen = array(
                        'totalCompra'         => (float) round($total, 2),
                        'descu'               => 0,
                        'totalDescu'          => 0,
                        'subTotal'            => (float) round($total, 2),
                        'ivaRete1'            => 0,
                        'reteRenta'           => (float) round($rRenta, 2),
                        'totalPagar'          => (float) round($subTotal, 2),
                        'totalLetras'         => $this->valorEnLetras(round($subTotal, 2)),
                        'condicionOperacion'  => 1,
                        'pagos'               => [$pagos],
                        'observaciones'       => null
                    );
                    
                    //NOTE: Apéndice
                    
                    if ($docApendice) {
                        $fileDteJson->apendice = array(
                            'campo'    => '',
                            'etiqueta' => '',
                            'valor'    => '',
                        );
                    } else $fileDteJson->apendice = null;

                    // echo json_encode($fileDteJson);

                    //NOTE: Sello Recepción recibido....

                    try {
                        //NOTE: FIRMAR DOCUMENTO JSON

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/"); //Por Empresa
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Content-Type:application/json'
                        ));
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit"         => ''.str_replace('-', '', $NIT).'',
                            "activo"      => true,
                            "passwordPri" => $pwdPrivate,
                            "dteJson"     => $fileDteJson
                        )));
                        
                        $Resolve = curl_exec($RestApi);
                        
                        curl_close($RestApi);

                        $resultFirma = json_decode($Resolve, true);
                        
                        if( $resultFirma['status'] == 'OK' ){

                            $docJsonFirmado = $resultFirma['body'];

                            if ($infoJSON) {
                                return $jsonFiles = array(
                                    'fileDteJson' => $fileDteJson,
                                    'docJsonFirmado' => $docJsonFirmado
                                );
                            }
                            
                            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/recepciondte" : "https://api.dtes.mh.gob.sv/fesv/recepciondte";

                            //NOTE: RECEPCION DE DOCUMENTO MH

                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Authorization: ' . $this->session->userdata('tokenJson'),
                                'Content-Type:application/json',
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "ambiente"  => $codAmbiente,
                                "idEnvio"   => $idrec,
                                "version"   => intval(1),
                                "tipoDte"   => "14",
                                "documento" => $docJsonFirmado,
                                "codigoGeneracion" => $cGeneracion
                            )));

                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultMH = json_decode($Resolve, true);

                            if ($resultMH['estado'] == 'PROCESADO') {
                                // print_r($Resolve);
                                if ($codAmbiente == '01') {
                                    $this->dte_model->updateDatosDTE($idrec, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH), 1, 1, $idYear);
                                }
                                $msgSuccess = 'Código Generación: '.$resultMH['codigoGeneracion'].'<br>Sello Recibido: '.$resultMH['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $idrec, $idYear);
                            } else {
                                // echo json_encode($docJsonFirmado);
                                // print_r($Resolve);
                                $detErrores = implode(",", $resultMH['observaciones']);
                                $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                                echo $this->sweetAlertError('DTE Presenta Errores', $msgError);
                            }
                        } else {
                            echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $idrec, $idYear);
                }

                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function comprobanteDeRetencion($idrec, $idYear) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $infoDTE = $this->dte_model->validateExistDocumentDte($idrec, 1, $idYear);
                
                if ( !$infoDTE ) {
                    $fecha   = new DateTime();
                    $infoDoc = $this->dte_model->getDatosIvaCentralJSON($idrec, $idYear);

                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    
                    if ( $dteSucursal == 0 ) {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);
                    } else {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);
                    }

                    $docRelacionado  = false;
                    $otrosDocumentos = false;
                    $ventaTercero    = false;
                    $docApendice     = false;

                    $fileDteJson = new stdClass();

                    //NOTE: Identificacion JSON

                    if ($codAmbiente == '00') {
                        $numControl  = 'DTE-07-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad(rand(1000, 5000), 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "C0C".$nCodGenera."-4368-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8A5486".str_pad(rand(1000, 5000), 6, '0', STR_PAD_LEFT);
                    } else {
                        $numControl  = 'DTE-07-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->doc_numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "C0C".$nCodGenera."-4368-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);
                    }
                    
                    $fileDteJson->identificacion = array(
                        'version'           => 1,
                        'ambiente'          => $codAmbiente,    // CAT-001
                        'tipoDte'           => '07',            // CAT-002
                        'numeroControl'     => $numControl,
                        'codigoGeneracion'  => $cGeneracion,
                        'tipoModelo'        => 1,               // CAT-003
                        'tipoOperacion'     => 1,               // CAT-004
                        'tipoContingencia'  => null,            // CAT-005
                        'motivoContin'      => null,
                        'fecEmi'            => ($codAmbiente == '00') ? $fecha->format('Y-m-d') : $infoDoc->fecha, // YYYY-MM-DD
                        'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                        'tipoMoneda'        => 'USD'
                    );
                    
                    //NOTE: Emisor JSON

                    $fileDteJson->emisor = array(
                        'nit'                 => ''.str_replace('-', '', $NIT).'',
                        'nrc'                 => ''.str_replace('-', '', $NRC).'',
                        'nombre'              => strtoupper($razonSocial),
                        'codActividad'        => $cActividad, // CAT-019
                        'descActividad'       => strtoupper($GIRO), // CAT-019
                        'nombreComercial'     => strtoupper($nComercial),
                        'tipoEstablecimiento' => '02', // CAT-009
                        'direccion' => array(
                            'departamento'    => $cDepartamento, // CAT-012
                            'municipio'       => $cMunicipio, // CAT-013
                            'complemento'     => strtoupper($direccion)
                        ),
                        'telefono'            => str_replace('-', '', $telefono),
                        'codigo'              => null,
                        'codigoMH'            => null,
                        'puntoVentaMH'        => null,
                        'puntoVenta'          => null,
                        'correo'              => $correoEl,
                    );
                                        
                    $tipoDocumento = ($infoDoc->nit == '') ? '13' : '36';
                    
                    //NOTE: Receptor JSON
                    
                    $fileDteJson->receptor = array(
                        'tipoDocumento'    => $tipoDocumento, // CAT-022
                        'numDocumento'     => ($tipoDocumento == '36') ? ''.str_replace('-', '', $infoDoc->nit).'' : ''.str_replace('-', '', $infoDoc->dui).'',
                        'nrc'              => ($infoDoc->nrc == '') ? null : ''.str_replace('-', '', $infoDoc->nrc).'',
                        'nombre'           => $infoDoc->nameCliente,
                        'nombreComercial'  => $infoDoc->nameCliente,
                        'codActividad'     => ($infoDoc->dte_giro == '' ? '47739' : $infoDoc->dte_giro), // CAT-019
                        'descActividad'    => ($infoDoc->dte_giro == '' ? 'Venta al por menor de otros productos n.c.p.' : $infoDoc->dte_giro_des), // CAT-019
                        'direccion' => array(
                            'departamento' => $infoDoc->iddeptodte, // CAT-012
                            'municipio'    => $infoDoc->idmunidte,  // CAT-013
                            'complemento'  => $infoDoc->direccion
                        ),
                        'telefono'         => ($infoDoc->telefono == '' ? '00000000' : str_replace('-', '', $infoDoc->telefono)),
                        'correo'           => ($infoDoc->correo == '' ? 'correo@correo.com' : $infoDoc->correo)
                    );

                    $totalMonto = 0; $totalRete = 0; $i=1;
                    $arrayDocumentos = explode(";", $infoDoc->notas);

                    $dteDocumentos = array();
                    for($j=0; $j<count($arrayDocumentos)-1; $j++) {
                        $infoCuepo = explode("|", $arrayDocumentos[$j]);

                        $dteDocumentos[] = array(
                            'numItem'           => $i,
                            'tipoDte'           => '03',
                            'tipoDoc'           => (strlen(trim($infoCuepo[1])) == 36) ? 2 : 1,
                            'numDocumento'      => ''.trim($infoCuepo[1]).'',
                            'fechaEmision'      => $infoCuepo[0],
                            'montoSujetoGrav'   => round(number_format($infoCuepo[2], 2, '.', ''), 2),
                            'codigoRetencionMH' => '22',
                            'ivaRetenido'       => round(number_format($infoCuepo[3], 2, '.', ''), 2),
                            'descripcion'       => ''
                        );
                        
                        $i++;
                        $totalMonto += round(number_format($infoCuepo[2], 2, '.', ''), 2);
                        $totalRete  += round(number_format($infoCuepo[3], 2, '.', ''), 2);
                    }
                        
                    //NOTE: Cuerpo Documento
                    $fileDteJson->cuerpoDocumento = $dteDocumentos;

                    //NOTE: Resumen
                    $fileDteJson->resumen = array(
                        'totalSujetoRetencion'   => round(number_format($totalMonto, 2, '.', ''), 2),
                        'totalIVAretenido'       => round(number_format($totalRete, 2, '.', ''), 2),
                        'totalIVAretenidoLetras' => $this->valorEnLetras(round(number_format($totalRete, 2, '.', ''), 2)),
                    );

                    //NOTE: Extensión
                    $fileDteJson->extension = null;
                    
                    //NOTE: Apéndice                    
                    if ($docApendice) {
                        $fileDteJson->apendice = array(
                            'campo'    => '',
                            'etiqueta' => '',
                            'valor'    => '',
                        );
                    } else $fileDteJson->apendice = null;

                    //NOTE: Sello Recepción recibido....

                    // echo json_encode($fileDteJson);

                    try {
                        //NOTE: FIRMAR DOCUMENTO JSON

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/"); //Por Empresa
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Content-Type:application/json'
                        ));
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit"         => ''.str_replace('-', '', $NIT).'',
                            "activo"      => true,
                            "passwordPri" => $pwdPrivate,
                            "dteJson"     => $fileDteJson
                        )));
                        
                        $Resolve = curl_exec($RestApi);

                        curl_close($RestApi);

                        $resultFirma = json_decode($Resolve, true);
                        
                        if( $resultFirma['status'] == 'OK' ){

                            $docJsonFirmado = $resultFirma['body'];

                            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/recepciondte" : "https://api.dtes.mh.gob.sv/fesv/recepciondte";
                            
                            //NOTE: RECEPCION DE DOCUMENTO MH

                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_CONNECTTIMEOUT, 5); // Tiempo máximo para conectar (5 segundos)
                            curl_setopt($RestApi, CURLOPT_TIMEOUT, 10);  // Tiempo máximo para la solicitud completa (10 segundos)
                            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Authorization: ' . $this->session->userdata('tokenJson'),
                                'Content-Type:application/json',
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "ambiente"  => $codAmbiente,
                                "idEnvio"   => $idrec,
                                "version"   => 1,
                                "tipoDte"   => "07",
                                "documento" => $docJsonFirmado,
                                "codigoGeneracion" => $cGeneracion
                            )));

                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultMH = json_decode($Resolve, true);

                            if ($resultMH['estado'] == 'PROCESADO') {
                                // print_r($Resolve);
                                // if ($codAmbiente == '01') {
                                    $this->dte_model->updateDatosDTE($idrec, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH), 1, 1, $idYear);
                                // }
                                $msgSuccess = 'Código Generación: '.$resultMH['codigoGeneracion'].'<br>Sello Recibido: '.$resultMH['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $idrec, $idYear);
                            } else {
                                // echo json_encode($fileDteJson);
                                // print_r($Resolve);

                                $detErrores = implode(",", $resultMH['observaciones']);
                                $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                                echo $this->sweetAlertError('DTE Presenta Errores', $msgError);
                            }
                        } else {
                            echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $idrec, $idYear);
                }

                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function comprobanteDeRetencion13($idrec, $idYear) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $infoDTE = $this->dte_model->validateExistDocumentDte($idrec, 1, $idYear);
                
                if ( !$infoDTE ) {
                    $fecha   = new DateTime();
                    $infoDoc = $this->dte_model->getDatosIvaCentralJSON($idrec, $idYear);

                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    
                    if ( $dteSucursal == 0 ) {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);
                    } else {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);
                    }

                    $docRelacionado  = false;
                    $otrosDocumentos = false;
                    $ventaTercero    = false;
                    $docApendice     = false;

                    $fileDteJson = new stdClass();

                    //NOTE: Identificacion JSON

                    if ($codAmbiente == '00') {
                        $numControl  = 'DTE-07-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad(rand(1000, 5000), 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "C0C".$nCodGenera."-4368-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8A5486".str_pad(rand(1000, 5000), 6, '0', STR_PAD_LEFT);
                    } else {
                        $numControl  = 'DTE-07-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->doc_numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "C0C".$nCodGenera."-4368-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);
                    }
                    
                    $fileDteJson->identificacion = array(
                        'version'           => 1,
                        'ambiente'          => $codAmbiente,    // CAT-001
                        'tipoDte'           => '07',            // CAT-002
                        'numeroControl'     => $numControl,
                        'codigoGeneracion'  => $cGeneracion,
                        'tipoModelo'        => 1,               // CAT-003
                        'tipoOperacion'     => 1,               // CAT-004
                        'tipoContingencia'  => null,            // CAT-005
                        'motivoContin'      => null,
                        'fecEmi'            => ($codAmbiente == '00') ? $fecha->format('Y-m-d') : $infoDoc->fecha, // YYYY-MM-DD
                        'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                        'tipoMoneda'        => 'USD'
                    );
                    
                    //NOTE: Emisor JSON

                    $fileDteJson->emisor = array(
                        'nit'                 => ''.str_replace('-', '', $NIT).'',
                        'nrc'                 => ''.str_replace('-', '', $NRC).'',
                        'nombre'              => strtoupper($razonSocial),
                        'codActividad'        => $cActividad, // CAT-019
                        'descActividad'       => strtoupper($GIRO), // CAT-019
                        'nombreComercial'     => strtoupper($nComercial),
                        'tipoEstablecimiento' => '02', // CAT-009
                        'direccion' => array(
                            'departamento'    => $cDepartamento, // CAT-012
                            'municipio'       => $cMunicipio, // CAT-013
                            'complemento'     => strtoupper($direccion)
                        ),
                        'telefono'            => str_replace('-', '', $telefono),
                        'codigo'              => null,
                        'codigoMH'            => null,
                        'puntoVentaMH'        => null,
                        'puntoVenta'          => null,
                        'correo'              => $correoEl,
                    );
                                        
                    $tipoDocumento = ($infoDoc->nit == '') ? '13' : '36';
                    
                    //NOTE: Receptor JSON
                    
                    $fileDteJson->receptor = array(
                        'tipoDocumento'    => $tipoDocumento, // CAT-022
                        'numDocumento'     => ($tipoDocumento == '36') ? ''.str_replace('-', '', $infoDoc->nit).'' : ''.str_replace('-', '', $infoDoc->dui).'',
                        'nrc'              => ($infoDoc->nrc == '') ? null : ''.str_replace('-', '', $infoDoc->nrc).'',
                        'nombre'           => $infoDoc->nameCliente,
                        'nombreComercial'  => $infoDoc->nameCliente,
                        'codActividad'     => ($infoDoc->dte_giro == '' ? '47739' : $infoDoc->dte_giro), // CAT-019
                        'descActividad'    => ($infoDoc->dte_giro == '' ? 'Venta al por menor de otros productos n.c.p.' : $infoDoc->dte_giro_des), // CAT-019
                        'direccion' => array(
                            'departamento' => $infoDoc->iddeptodte, // CAT-012
                            'municipio'    => $infoDoc->idmunidte,  // CAT-013
                            'complemento'  => $infoDoc->direccion
                        ),
                        'telefono'         => ($infoDoc->telefono == '' ? '00000000' : str_replace('-', '', $infoDoc->telefono)),
                        'correo'           => ($infoDoc->correo == '' ? 'correo@correo.com' : $infoDoc->correo)
                    );

                    $totalMonto = 0; $totalRete = 0; $i=1;
                    $arrayDocumentos = explode(";", $infoDoc->notas);

                    $dteDocumentos = array();
                    for($j=0; $j<count($arrayDocumentos)-1; $j++) {
                        $infoCuepo = explode("|", $arrayDocumentos[$j]);

                        $dteDocumentos[] = array(
                            'numItem'           => $i,
                            'tipoDte'           => '03',
                            'tipoDoc'           => (strlen(trim($infoCuepo[1])) == 36) ? 2 : 1,
                            'numDocumento'      => ''.trim($infoCuepo[1]).'',
                            'fechaEmision'      => $infoCuepo[0],
                            'montoSujetoGrav'   => round(number_format($infoCuepo[2], 2, '.', ''), 2),
                            'codigoRetencionMH' => 'C4',
                            'ivaRetenido'       => round(number_format($infoCuepo[3], 2, '.', ''), 2),
                            'descripcion'       => ''
                        );
                        
                        $i++;
                        $totalMonto += round(number_format($infoCuepo[2], 2, '.', ''), 2);
                        $totalRete  += round(number_format($infoCuepo[3], 2, '.', ''), 2);
                    }
                        
                    //NOTE: Cuerpo Documento
                    $fileDteJson->cuerpoDocumento = $dteDocumentos;

                    //NOTE: Resumen
                    $fileDteJson->resumen = array(
                        'totalSujetoRetencion'   => round(number_format($totalMonto, 2, '.', ''), 2),
                        'totalIVAretenido'       => round(number_format($totalRete, 2, '.', ''), 2),
                        'totalIVAretenidoLetras' => $this->valorEnLetras(round(number_format($totalRete, 2, '.', ''), 2)),
                    );

                    //NOTE: Extensión
                    $fileDteJson->extension = null;
                    
                    //NOTE: Apéndice                    
                    if ($docApendice) {
                        $fileDteJson->apendice = array(
                            'campo'    => '',
                            'etiqueta' => '',
                            'valor'    => '',
                        );
                    } else $fileDteJson->apendice = null;

                    //NOTE: Sello Recepción recibido....

                    // echo json_encode($fileDteJson);

                    try {
                        //NOTE: FIRMAR DOCUMENTO JSON

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/"); //Por Empresa
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Content-Type:application/json'
                        ));
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit"         => ''.str_replace('-', '', $NIT).'',
                            "activo"      => true,
                            "passwordPri" => $pwdPrivate,
                            "dteJson"     => $fileDteJson
                        )));
                        
                        $Resolve = curl_exec($RestApi);

                        curl_close($RestApi);

                        $resultFirma = json_decode($Resolve, true);
                        
                        if( $resultFirma['status'] == 'OK' ){

                            $docJsonFirmado = $resultFirma['body'];

                            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/recepciondte" : "https://api.dtes.mh.gob.sv/fesv/recepciondte";
                            
                            //NOTE: RECEPCION DE DOCUMENTO MH

                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Authorization: ' . $this->session->userdata('tokenJson'),
                                'Content-Type:application/json',
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "ambiente"  => $codAmbiente,
                                "idEnvio"   => $idrec,
                                "version"   => 1,
                                "tipoDte"   => "07",
                                "documento" => $docJsonFirmado,
                                "codigoGeneracion" => $cGeneracion
                            )));

                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultMH = json_decode($Resolve, true);

                            if ($resultMH['estado'] == 'PROCESADO') {
                                // print_r($Resolve);
                                // if ($codAmbiente == '01') {
                                    $this->dte_model->updateDatosDTE($idrec, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH), 1, 1, $idYear);
                                // }
                                $msgSuccess = 'Código Generación: '.$resultMH['codigoGeneracion'].'<br>Sello Recibido: '.$resultMH['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $idrec, $idYear);
                            } else {
                                // echo json_encode($fileDteJson);
                                // print_r($Resolve);

                                $detErrores = implode(",", $resultMH['observaciones']);
                                $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                                echo $this->sweetAlertError('DTE Presenta Errores', $msgError);
                            }
                        } else {
                            echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $idrec, $idYear);
                }

                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function notaDeCreditoDTE($trannum, $infoJSON = false) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum);

                if (!$infoDTE) {
                    $fecha   = new DateTime();
                    $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum);

                    if ($this->session->userdata('codAmbiente') == '01') {
                        $rSerie = strpos($infoDoc->serie, 'DTE');
                        if ( $rSerie === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que no es un DTE');
                            exit;
                        }

                        $dateD = date_create($infoDoc->fecha);
                        $dYear = substr(date_format($dateD, 'Y'), 2, 2);
                        $rYear = strpos($infoDoc->serie, $dYear);
                        if ( $rYear === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que contiene una serie de otro año');
                            exit;
                        }
                    }
                    
                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    
                    if ( $dteSucursal == 0 ) {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);

                        $tipoContribuyente = $this->global_model->getDatoTipoContribuyenteEmp('g_empdatos', 10);
                    } else {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);

                        $tipoContribuyente = $this->global_model->getDatoTipoContribuyenteEmp('g_empdatos_0'.$infoDoc->idcentro, 10);
                    }

                    $docRelacionado  = true;
                    $otrosDocumentos = false;
                    $ventaTercero    = false;
                    $docApendice     = false;

                    $fileDteJson = new stdClass();

                    //NOTE: Identificacion JSON
                    if ($codAmbiente == '00') {
                        $numControl  = 'DTE-05-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad(rand(1000, 5000), 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "C4F".$nCodGenera."-9836-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-764A38".str_pad(rand(1000, 5000), 6, '0', STR_PAD_LEFT);
                    } else {
                        $numControl  = 'DTE-05-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "C4F".$nCodGenera."-9836-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                    }
                    
                    $fileDteJson->identificacion = array(
                        'version'           => 3,
                        'ambiente'          => $codAmbiente,    // CAT-001
                        'tipoDte'           => '05',    // CAT-002
                        'numeroControl'     => $numControl,
                        'codigoGeneracion'  => $cGeneracion,
                        'tipoModelo'        => 1,       // CAT-003
                        'tipoOperacion'     => 1,       // CAT-004
                        'tipoContingencia'  => null,    // CAT-005
                        'motivoContin'      => null,
                        'fecEmi'            => ($codAmbiente == '00') ? $fecha->format('Y-m-d') : $infoDoc->fecha, // YYYY-MM-DD
                        'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                        'tipoMoneda'        => 'USD'
                    );

                    //NOTE: Documentos Relacionados JSON (Opcional Segun Requerimientos)

                    if ($docRelacionado) {
                        if ($codAmbiente == '00') {
                            $tipoGeneracion    = 1;
                            $tipoDocumento     = '03';
                            $numeroDocumentoRe = '25DS000C4F000';
                            $fechaEmi          = $fecha->format('Y-m-d');
                        } else {
                            if ($infoDoc->tranref == 0) {

                                $infoDocNC = explode('|', $infoDoc->notas);

                                $tipoGeneracion    = 1;
                                $tipoDocumento     = '03';
                                $numeroDocumentoRe = $infoDocNC[2];
                                $fechaEmi          = $infoDocNC[1];
                            } else {
                                $infoDTE = $this->dte_model->validateExistDocumentDte($infoDoc->tranref);

                                if (!$infoDTE) {
                                    $infoDocRe = $this->dte_model->getInfoDocRelacionado($infoDoc->tranref);
                                    
                                    $tipoGeneracion    = 1;
                                    $tipoDocumento     = '03';
                                    $numeroDocumentoRe = $infoDocRe->numeroDocumento;
                                    $fechaEmi          = $infoDocRe->fecha;
                                } else {
                                    $infoDocJSON  = json_decode($infoDTE->json_doc, true);
                                    $jsonIdentifi = $infoDocJSON['identificacion'];

                                    $tipoGeneracion    = 2;
                                    $tipoDocumento     = $jsonIdentifi['tipoDte'];
                                    $numeroDocumentoRe = $jsonIdentifi['codigoGeneracion'];
                                    $fechaEmi          = $jsonIdentifi['fecEmi'];
                                }
                            }
                        }

                        $fileDteJson->documentoRelacionado = [array(
                            'tipoDocumento'     => $tipoDocumento, // CAT-002
                            'tipoGeneracion'    => $tipoGeneracion,    // CAT-007
                            'numeroDocumento'   => $numeroDocumentoRe,
                            'fechaEmision'      => $fechaEmi
                        )];
                    } else $fileDteJson->documentoRelacionado = null;
                    
                    //NOTE: Emisor JSON
                    
                    $fileDteJson->emisor = array(
                        'nit'                 => ''.str_replace('-', '', $NIT).'',
                        'nrc'                 => ''.str_replace('-', '', $NRC).'',
                        'nombre'              => strtoupper($razonSocial),
                        'codActividad'        => $cActividad, // CAT-019
                        'descActividad'       => strtoupper($GIRO), // CAT-019
                        'nombreComercial'     => strtoupper($nComercial),
                        'tipoEstablecimiento' => '02', // CAT-009
                        'direccion' => array(
                            'departamento'    => ($infoDoc->iddeptodtesuc == 0) ? $cDepartamento : $infoDoc->iddeptodtesuc, // CAT-012
                            'municipio'       => ($infoDoc->idmunidtesuc == 0) ? $cMunicipio : $infoDoc->idmunidtesuc, // CAT-013
                            'complemento'     => ($infoDoc->direccionsucursal == "") ? strtoupper($direccion) : $infoDoc->direccionsucursal
                        ),
                        'telefono'            => str_replace('-', '', $telefono),
                        'correo'              => $correoEl,
                    );
                    
                    //NOTE: Receptor JSON
                    
                    if ($codAmbiente == '00') {
                        $fileDteJson->receptor = array(
                            //'tipoDocumento'    => '', // CAT-022
                            'nit'              => ''.str_replace('-', '', '0614-210889-101-8').'',
                            'nrc'              => ''.str_replace('-', '', '8466-2').'',
                            'nombre'           => 'EMPRESAS GOMEZ GUATEMALA S.A. DE C.V.',
                            'nombreComercial'  => null,
                            'codActividad'     => '46510', // CAT-019
                            'descActividad'    => 'Venta al por mayor de computadoras, equipo periférico y programas informáticos', // CAT-019
                            'direccion' => array(
                                'departamento' => '06', // CAT-012
                                'municipio'    => '14',  // CAT-013
                                'complemento'  => 'Final 67 Avenida Sur y Pasaje Carbonell, N° 2A, Colonia Roma, San Salvador, El Salvador'
                            ),
                            'telefono'         => '25143094',
                            'correo'           => 'dte@versanetsa.com'
                        );
                    } else {
                        $fileDteJson->receptor = array(
                            //'tipoDocumento'    => '', // CAT-022
                            'nit'              => ''.str_replace('-', '', $infoDoc->nit).'',
                            'nrc'              => ''.str_replace('-', '', $infoDoc->nrc).'',
                            'nombre'           => $infoDoc->nameCliente,
                            'nombreComercial'  => null,
                            'codActividad'     => ($infoDoc->dte_giro == '' ? '47739' : $infoDoc->dte_giro), // CAT-019
                            'descActividad'    => ($infoDoc->dte_giro == '' ? 'Venta al por menor de otros productos n.c.p.' : $infoDoc->dte_giro_des), // CAT-019
                            'direccion' => array(
                                'departamento' => $infoDoc->iddeptodte, // CAT-012
                                'municipio'    => $infoDoc->idmunidte,  // CAT-013
                                'complemento'  => $infoDoc->direccion
                            ),
                            'telefono'         => ($infoDoc->telefono == '' ? '00000000' : str_replace('-', '', $infoDoc->telefono)),
                            'correo'           => ($infoDoc->correo == '' ? 'correo@correo.com' : $infoDoc->correo)
                        );
                    }
                                                    
                    //NOTE: Ventas por Cuenta de Terceros
                    
                    if ($ventaTercero) {
                        $fileDteJson->ventaTercero = array(
                            'nit'    => '',
                            'nombre' => '',
                        );
                    } else $fileDteJson->ventaTercero = null;

                    //NOTE: Cuerpo del Documento (ForEach Items)
                    
                    $infoProductos = $this->dte_model->getDetalleProductosJSON($trannum);

                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0; $i=1; $valRetencion = 0;
                    $invexento = $infoDoc->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0; $valPercepcion = 0;

                    $dteProductos = array();
                    foreach($infoProductos as $infoPro) {

                        if ($infoPro->tax1 != 0 && $invexento == 0) {
                            $total        = $total + (($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100))) * abs($infoPro->cantidad));
                            $totalIVA     = $totalIVA + (($infoPro->precioneto * ($infoPro->tax1 / 100)) * abs($infoPro->cantidad));
                            $totalGravado = $totalGravado + $infoPro->precioneto * abs($infoPro->cantidad);
                            
                            $vnExenta  = 0;
                            $vnGravada = number_format(round($infoPro->precioneto * abs($infoPro->cantidad), 4), 4, '.', '');

                        } else {
                            $total       = $total + (($infoPro->precioneto) * abs($infoPro->cantidad));
                            $totalExento = $totalExento + $infoPro->precioneto * abs($infoPro->cantidad);
                            
                            $vnExenta  = number_format(round($infoPro->precioneto * abs($infoPro->cantidad), 4), 4, '.', '');
                            $vnGravada = 0;
                        }

                        $preciouni = $infoPro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($infoPro->descuento != 0 && $infoPro->descuento != "" && $vnGravada != ""){
                            $discount =  ($infoPro->descuento/100) * $vnGravada;

                        }
                        
                        if($infoPro->vnNotas != ""){
                            $notas = strtoupper(trim($infoPro->vnNotas));
                        }else{
                            $notas = "";
                        }

                        if($infoPro->tipo == "4"){
                            $idpro = "";
                            $nombrepro = strtoupper(trim($notas));

                            if ( $nombrepro == '' ) {
                                $nombrepro = strtoupper(trim($infoPro->descrip));
                            }
                        }else{
                            $idpro = $infoPro->idproducto;
                            $nombrepro = strtoupper(trim($infoPro->descrip)).' '.$notas;
                        }

                        $sumacantidad = (number_format(abs($infoPro->cantidad), 2 ,'.','') - number_format(abs($infoPro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($infoPro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($infoPro->cantidad), 0 ,'.','');

                        if ($infoPro->precioneto != 0) {
                            $dteProductos[] = array(
                                'numItem'         => $i,
                                'tipoItem'        => 1, // CAT-011 CAT-015
                                'numeroDocumento' => $numeroDocumentoRe,
                                'cantidad'        => abs($infoPro->cantidad),
                                'codigo'          => $infoPro->idproducto,
                                'codTributo'      => null,  // CAT-015
                                'uniMedida'       => 59, // CAT-014
                                'descripcion'     => strtoupper($nombrepro),
                                'precioUni'       => (float) round($infoPro->precioneto * 1, 6),
                                'montoDescu'      => 0,
                                'ventaNoSuj'      => 0,
                                'ventaExenta'     => (float) round($vnExenta * 1, 4),
                                'ventaGravada'    => (float) round($vnGravada * 1, 4),
                                'tributos'        => ($vnGravada != 0) ? ['20'] : null, // CAT-015
                            );

                            $i++;
                        }
                    }

                    $fileDteJson->cuerpoDocumento = $dteProductos;

                    $totalOperacion = $total;

                    if ( intval($tipoContribuyente) == 1 ) {
                        if ( $infoDoc->idtipo != 3 ) {
                            if ( $totalGravado >= 100 ) {
                                $valPercepcion = $totalGravado * 0.01;
                            }
                        }
                    } else {
                        if ( $infoDoc->idtipo == 3 ) {
                            if ( $totalGravado >= 100 ) {
                                $valRetencion = $totalGravado * 0.01;
                            }
                        }
                    }

                    if ( $valRetencion != 0 ) {
                        $total = $total - number_format($valRetencion, 2 , '.', '');
                    }

                    if ($valPercepcion != 0) {
                        $total = $total + number_format($valPercepcion, 2 , '.', '');
                    }
                    
                    $tributos = array(
                        'codigo'      => '20', // CAT-015
                        'descripcion' => 'Impuesto al Valor Agregado 13%', // CAT-015
                        'valor'       => (float) number_format($totalIVA, 2, '.', ''),
                    );

                    $idPagoDTE = $this->dte_model->getFormaDePagoDocumento($trannum);

                    $pagos = array(
                        'codigo'     => $idPagoDTE,
                        'montoPago'  => (float) round($total, 2),
                        'referencia' => '',
                        'plazo'      => ($idPagoDTE == '13') ? '01' : null,
                        'periodo'    => ($idPagoDTE == '13') ? intval($infoDoc->dias) : null,
                    );

                    //NOTE: Resumen
                    $fileDteJson->resumen = array(
                        'totalNoSuj'          => 0,
                        'totalExenta'         => (float) number_format($totalExento, 2, '.', ''),
                        'totalGravada'        => (float) number_format($totalGravado, 2, '.', ''),
                        'subTotalVentas'      => (float) number_format($totalGravado + $totalExento, 2, '.', ''),
                        'descuNoSuj'          => 0,
                        'descuExenta'         => 0,
                        'descuGravada'        => 0,
                        // 'porcentajeDescuento' => 0,
                        'totalDescu'          => 0,
                        'tributos'            => ($totalGravado != 0) ? [$tributos] : null,
                        'subTotal'            => (float) number_format($totalGravado + $totalExento, 2, '.', ''),
                        'ivaRete1'            => (float) round($valRetencion, 2),
                        'ivaPerci1'           => (float) round($valPercepcion, 2),
                        'reteRenta'           => 0,
                        'montoTotalOperacion' => (float) round($total, 2),
                        // 'totalNoGravado'      => 0,
                        // 'totalPagar'          => (float) number_format($total, 2, '.', ''),
                        'totalLetras'         => $this->valorEnLetras(number_format($total, 2, '.', '')),
                        // 'totalIva'            => 0,
                        // 'saldoFavor'          => 0,
                        'condicionOperacion'  => 1,
                        // 'pagos'               => [$pagos],
                        // 'numPagoElectronico'  => null
                    );

                    //NOTE: Extensión
                    $fileDteJson->extension = array(
                        'nombEntrega' => null, //'',
                        'docuEntrega'   => null, //'',
                        'nombRecibe'    => null, //'',
                        'docuRecibe'    => null, //'',
                        'observaciones' => null, //'',
                        // 'placaVehiculo' => null, //'',
                    );
                    
                    //NOTE: Apéndice
                    
                    if ($docApendice) {
                        $fileDteJson->apendice = array(
                            'campo'    => '',
                            'etiqueta' => '',
                            'valor'    => '',
                        );
                    } else $fileDteJson->apendice = null;

                    //NOTE: Sello Recepción recibido....

                    try {
                        //NOTE: FIRMAR DOCUMENTO JSON

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/"); //Por Empresa
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Content-Type:application/json'
                        ));
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit"         => ''.str_replace('-', '', $NIT).'',
                            "activo"      => true,
                            "passwordPri" => $pwdPrivate,
                            "dteJson"     => $fileDteJson
                        )));
                        
                        $Resolve = curl_exec($RestApi);

                        curl_close($RestApi);

                        $resultFirma = json_decode($Resolve, true);
                        
                        if( $resultFirma['status'] == 'OK' ){

                            //NOTE: AUTORIZACION API MH
                            $docJsonFirmado = $resultFirma['body'];

                            if ($infoJSON) {
                                return $jsonFiles = array(
                                    'fileDteJson' => $fileDteJson,
                                    'docJsonFirmado' => $docJsonFirmado
                                );
                            }

                            //NOTE: RECEPCION DE DOCUMENTO MH

                            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/recepciondte" : "https://api.dtes.mh.gob.sv/fesv/recepciondte";
                            
                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_CONNECTTIMEOUT, 5); // Tiempo máximo para conectar (5 segundos)
                            curl_setopt($RestApi, CURLOPT_TIMEOUT, 10);  // Tiempo máximo para la solicitud completa (10 segundos)
                            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Authorization: ' . $this->session->userdata('tokenJson'),
                                'Content-Type:application/json',
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "ambiente"  => $codAmbiente,
                                "idEnvio"   => $trannum,
                                "version"   => 3,
                                "tipoDte"   => "05",
                                "documento" => $docJsonFirmado,
                                "codigoGeneracion" => $cGeneracion
                            )));

                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultMH = json_decode($Resolve, true);

                            if ($resultMH['estado'] == 'PROCESADO') {
                                // print_r($Resolve);
                                // if ($codAmbiente == '01') {
                                    $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH));
                                // }
                                $msgSuccess = 'Código Generación: '.$resultMH['codigoGeneracion'].'<br>Sello Recibido: '.$resultMH['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum, 0,  $this->session->userdata('dteSendPrint'), $this->session->userdata('dteSendEmail'));
                            } else {
                                // echo json_encode($fileDteJson);
                                // print_r($Resolve);
                                $detErrores = implode(",", $resultMH['observaciones']);
                                $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                                echo $this->sweetAlertError('DTE Presenta Errores', 'Código Generación: '.$cGeneracion.'<br>'.$msgError, $trannum);
                            }
                        } else {
                            echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum);
                }

                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function notaDeDebitoDTE($trannum, $infoJSON = false) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum);

                if (!$infoDTE) {
                    $fecha   = new DateTime();
                    $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum);

                    if ($this->session->userdata('codAmbiente') == '01') {
                        $rSerie = strpos($infoDoc->serie, 'DTE');
                        if ( $rSerie === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que no es un DTE');
                            exit;
                        }

                        $dateD = date_create($infoDoc->fecha);
                        $dYear = substr(date_format($dateD, 'Y'), 2, 2);
                        $rYear = strpos($infoDoc->serie, $dYear);
                        if ( $rYear === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que contiene una serie de otro año');
                            exit;
                        }
                    }
                    
                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    
                    if ( $dteSucursal == 0 ) {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);
                    } else {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);
                    }

                    $docRelacionado  = true;
                    $otrosDocumentos = false;
                    $ventaTercero    = false;
                    $docApendice     = false;

                    $fileDteJson = new stdClass();

                    //NOTE: Identificacion JSON
                    if ($codAmbiente == '00') {
                        $numControl  = 'DTE-06-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad(rand(1000, 5000), 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "DEB".$nCodGenera."-3276-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-764A38".str_pad(rand(1000, 5000), 6, '0', STR_PAD_LEFT);
                    } else {
                        $numControl  = 'DTE-06-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "DEB".$nCodGenera."-3276-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                    }

                    $fileDteJson->identificacion = array(
                        'version'           => 3,
                        'ambiente'          => $codAmbiente,    // CAT-001
                        'tipoDte'           => '06',    // CAT-002
                        'numeroControl'     => $numControl,
                        'codigoGeneracion'  => $cGeneracion,
                        'tipoModelo'        => 1,       // CAT-003
                        'tipoOperacion'     => 1,       // CAT-004
                        'tipoContingencia'  => null,    // CAT-005
                        'motivoContin'      => null,
                        'fecEmi'            => ($codAmbiente == '00') ? $fecha->format('Y-m-d') : $infoDoc->fecha, // YYYY-MM-DD
                        'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                        'tipoMoneda'        => 'USD'
                    );

                    //NOTE: Documentos Relacionados JSON (Opcional Segun Requerimientos)

                    if ($docRelacionado) {
                        if ($codAmbiente == '00') {
                            $tipoGeneracion    = 1;
                            $tipoDocumento     = '03';
                            $numeroDocumentoRe = '25DS000C4F000';
                            $fechaEmi          = $fecha->format('Y-m-d');
                        } else {
                            if ($infoDoc->tranref == 0) {

                                $infoDocNC = explode('|', $infoDoc->notas);

                                $tipoGeneracion    = 1;
                                $tipoDocumento     = '03';
                                $numeroDocumentoRe = $infoDocNC[2];
                                $fechaEmi          = $infoDocNC[1];
                            } else {
                                $infoDTE = $this->dte_model->validateExistDocumentDte($infoDoc->tranref);

                                if (!$infoDTE) {
                                    $infoDocRe = $this->dte_model->getInfoDocRelacionado($infoDoc->tranref);
                                    
                                    $tipoGeneracion    = 1;
                                    $tipoDocumento     = '03';
                                    $numeroDocumentoRe = $infoDocRe->numeroDocumento;
                                    $fechaEmi          = $infoDocRe->fecha;
                                } else {
                                    $infoDocJSON  = json_decode($infoDTE->json_doc, true);
                                    $jsonIdentifi = $infoDocJSON['identificacion'];

                                    $tipoGeneracion    = 2;
                                    $tipoDocumento     = $jsonIdentifi['tipoDte'];
                                    $numeroDocumentoRe = $jsonIdentifi['codigoGeneracion'];
                                    $fechaEmi          = $jsonIdentifi['fecEmi'];
                                }
                            }
                        }

                        $fileDteJson->documentoRelacionado = [array(
                            'tipoDocumento'     => $tipoDocumento, // CAT-002
                            'tipoGeneracion'    => $tipoGeneracion,    // CAT-007
                            'numeroDocumento'   => $numeroDocumentoRe,
                            'fechaEmision'      => $fechaEmi
                        )];
                    } else $fileDteJson->documentoRelacionado = null;
                    
                    //NOTE: Emisor JSON
                    
                    $fileDteJson->emisor = array(
                        'nit'                 => ''.str_replace('-', '', $NIT).'',
                        'nrc'                 => ''.str_replace('-', '', $NRC).'',
                        'nombre'              => strtoupper($razonSocial),
                        'codActividad'        => $cActividad, // CAT-019
                        'descActividad'       => strtoupper($GIRO), // CAT-019
                        'nombreComercial'     => strtoupper($nComercial),
                        'tipoEstablecimiento' => '02', // CAT-009
                        'direccion' => array(
                            'departamento'    => ($infoDoc->iddeptodtesuc == 0) ? $cDepartamento : $infoDoc->iddeptodtesuc, // CAT-012
                            'municipio'       => ($infoDoc->idmunidtesuc == 0) ? $cMunicipio : $infoDoc->idmunidtesuc, // CAT-013
                            'complemento'     => ($infoDoc->direccionsucursal == "") ? strtoupper($direccion) : $infoDoc->direccionsucursal
                        ),
                        'telefono'            => str_replace('-', '', $telefono),
                        'correo'              => $correoEl,
                    );
                    
                    //NOTE: Receptor JSON
                    if ($codAmbiente == '00') {
                        $fileDteJson->receptor = array(
                            //'tipoDocumento'    => '', // CAT-022
                            'nit'              => ''.str_replace('-', '', '0614-210889-101-8').'',
                            'nrc'              => ''.str_replace('-', '', '8466-2').'',
                            'nombre'           => 'EMPRESAS GOMEZ GUATEMALA S.A. DE C.V.',
                            'nombreComercial'  => null,
                            'codActividad'     => '46510', // CAT-019
                            'descActividad'    => 'Venta al por mayor de computadoras, equipo periférico y programas informáticos', // CAT-019
                            'direccion' => array(
                                'departamento' => '06', // CAT-012
                                'municipio'    => '14',  // CAT-013
                                'complemento'  => 'Final 67 Avenida Sur y Pasaje Carbonell, N° 2A, Colonia Roma, San Salvador, El Salvador'
                            ),
                            'telefono'         => '25143094',
                            'correo'           => 'dte@versanetsa.com'
                        );
                    } else {
                        $fileDteJson->receptor = array(
                            //'tipoDocumento'    => '', // CAT-022
                            'nit'              => ''.str_replace('-', '', $infoDoc->nit).'',
                            'nrc'              => ''.str_replace('-', '', $infoDoc->nrc).'',
                            'nombre'           => $infoDoc->nameCliente,
                            'nombreComercial'  => null,
                            'codActividad'     => ($infoDoc->dte_giro == '' ? '47739' : $infoDoc->dte_giro), // CAT-019
                            'descActividad'    => ($infoDoc->dte_giro == '' ? 'Venta al por menor de otros productos n.c.p.' : $infoDoc->dte_giro_des), // CAT-019
                            'direccion' => array(
                                'departamento' => $infoDoc->iddeptodte, // CAT-012
                                'municipio'    => $infoDoc->idmunidte,  // CAT-013
                                'complemento'  => $infoDoc->direccion
                            ),
                            'telefono'         => ($infoDoc->telefono == '' ? '00000000' : str_replace('-', '', $infoDoc->telefono)),
                            'correo'           => ($infoDoc->correo == '' ? 'correo@correo.com' : $infoDoc->correo)
                        );
                    }
                                    
                    //NOTE: Ventas por Cuenta de Terceros
                    
                    if ($ventaTercero) {
                        $fileDteJson->ventaTercero = array(
                            'nit'    => '',
                            'nombre' => '',
                        );
                    } else $fileDteJson->ventaTercero = null;

                    //NOTE: Cuerpo del Documento (ForEach Items)
                    
                    $infoProductos = $this->dte_model->getDetalleProductosJSON($trannum);

                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0; $i=1;
                    $invexento = $infoDoc->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;

                    $dteProductos = array();
                    foreach($infoProductos as $infoPro) {

                        if ($infoPro->tax1 != 0 && $invexento == 0) {
                            $total        = $total + (($infoPro->precioneto + ($infoPro->precioneto * ($infoPro->tax1 / 100))) * abs($infoPro->cantidad));
                            $totalIVA     = $totalIVA + (($infoPro->precioneto * ($infoPro->tax1 / 100)) * abs($infoPro->cantidad));
                            $totalGravado = $totalGravado + $infoPro->precioneto * abs($infoPro->cantidad);
                            
                            $vnExenta  = 0;
                            $vnGravada = number_format(round($infoPro->precioneto * abs($infoPro->cantidad), 4), 4, '.', '');

                        } else {
                            $total       = $total + (($infoPro->precioneto) * abs($infoPro->cantidad));
                            $totalExento = $totalExento + $infoPro->precioneto * abs($infoPro->cantidad);
                            
                            $vnExenta  = number_format(round($infoPro->precioneto * abs($infoPro->cantidad), 4), 4, '.', '');
                            $vnGravada = 0;
                        }

                        $preciouni = $infoPro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($infoPro->descuento != 0 && $infoPro->descuento != "" && $vnGravada != ""){
                            $discount =  ($infoPro->descuento/100) * $vnGravada;

                        }
                        
                        if($infoPro->vnNotas != ""){
                            $notas = strtoupper(trim($infoPro->vnNotas));
                        }else{
                            $notas = "";
                        }

                        if($infoPro->tipo == "4"){
                            $idpro = "";
                            $nombrepro = strtoupper(trim($notas));

                            if ( $nombrepro == '' ) {
                                $nombrepro = strtoupper(trim($infoPro->descrip));
                            }
                        }else{
                            $idpro = $infoPro->idproducto;
                            $nombrepro = strtoupper(trim($infoPro->descrip)).' '.$notas;
                        }

                        $sumacantidad = (number_format(abs($infoPro->cantidad), 2 ,'.','') - number_format(abs($infoPro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($infoPro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($infoPro->cantidad), 0 ,'.','');

                        if ($infoPro->precioneto != 0) {
                            $dteProductos[] = array(
                                'numItem'         => $i,
                                'tipoItem'        => 1, // CAT-011 CAT-015
                                'numeroDocumento' => $numeroDocumentoRe,
                                'cantidad'        => abs($infoPro->cantidad),
                                'codigo'          => $infoPro->idproducto,
                                'codTributo'      => null,  // CAT-015
                                'uniMedida'       => 59, // CAT-014
                                'descripcion'     => strtoupper($nombrepro),
                                'precioUni'       => (float) round($infoPro->precioneto * 1, 4),
                                'montoDescu'      => 0,
                                'ventaNoSuj'      => 0,
                                'ventaExenta'     => (float) round($vnExenta * 1, 2),
                                'ventaGravada'    => (float) round($vnGravada * 1, 2),
                                'tributos'        => ['20'], // CAT-015
                            );

                            $i++;
                        }
                    }

                    $fileDteJson->cuerpoDocumento = $dteProductos;
                    
                    $tributos = array(
                        'codigo'      => '20', // CAT-015
                        'descripcion' => 'Impuesto al Valor Agregado 13%', // CAT-015
                        'valor'       => (float) number_format($totalIVA, 2, '.', ''),
                    );

                    $idPagoDTE = $this->dte_model->getFormaDePagoDocumento($trannum);

                    $pagos = array(
                        'codigo'     => $idPagoDTE,
                        'montoPago'  => (float) round($total, 2),
                        'referencia' => '',
                        'plazo'      => ($idPagoDTE == '13') ? '01' : null,
                        'periodo'    => ($idPagoDTE == '13') ? intval($infoDoc->dias) : null,
                    );

                    //NOTE: Resumen
                    $fileDteJson->resumen = array(
                        'totalNoSuj'          => 0,
                        'totalExenta'         => (float) number_format($totalExento, 2, '.', ''),
                        'totalGravada'        => (float) number_format($totalGravado, 2, '.', ''),
                        'subTotalVentas'      => (float) number_format($totalGravado + $totalExento, 2, '.', ''),
                        'descuNoSuj'          => 0,
                        'descuExenta'         => 0,
                        'descuGravada'        => 0,
                        // 'porcentajeDescuento' => 0,
                        'totalDescu'          => 0,
                        'tributos'            => [$tributos],
                        'subTotal'            => (float) number_format($totalGravado, 2, '.', ''),
                        'ivaRete1'            => 0,
                        'ivaPerci1'           => 0,
                        'reteRenta'           => 0,
                        'montoTotalOperacion' => (float) number_format($total, 2, '.', ''),
                        // 'totalNoGravado'      => 0,
                        // 'totalPagar'          => (float) number_format($total, 2, '.', ''),
                        'totalLetras'         => $this->valorEnLetras(number_format($total, 2, '.', '')),
                        // 'totalIva'            => 0,
                        // 'saldoFavor'          => 0,
                        'condicionOperacion'  => 1,
                        // 'pagos'               => [$pagos],
                        'numPagoElectronico'  => null
                    );

                    //NOTE: Extensión
                    $fileDteJson->extension = array(
                        'nombEntrega' => null, //'',
                        'docuEntrega'   => null, //'',
                        'nombRecibe'    => null, //'',
                        'docuRecibe'    => null, //'',
                        'observaciones' => null, //'',
                        // 'placaVehiculo' => null, //'',
                    );
                    
                    //NOTE: Apéndice
                    
                    if ($docApendice) {
                        $fileDteJson->apendice = array(
                            'campo'    => '',
                            'etiqueta' => '',
                            'valor'    => '',
                        );
                    } else $fileDteJson->apendice = null;

                    //NOTE: Sello Recepción recibido....

                    try {
                        //NOTE: FIRMAR DOCUMENTO JSON

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/"); //Por Empresa
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Content-Type:application/json'
                        ));
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit"         => ''.str_replace('-', '', $NIT).'',
                            "activo"      => true,
                            "passwordPri" => $pwdPrivate,
                            "dteJson"     => $fileDteJson
                        )));
                        
                        $Resolve = curl_exec($RestApi);

                        curl_close($RestApi);

                        $resultFirma = json_decode($Resolve, true);
                        
                        if( $resultFirma['status'] == 'OK' ){

                            //NOTE: AUTORIZACION API MH
                            $docJsonFirmado = $resultFirma['body'];

                            if ($infoJSON) {
                                return $jsonFiles = array(
                                    'fileDteJson' => $fileDteJson,
                                    'docJsonFirmado' => $docJsonFirmado
                                );
                            }

                            //NOTE: RECEPCION DE DOCUMENTO MH
                            
                            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/recepciondte" : "https://api.dtes.mh.gob.sv/fesv/recepciondte";
                            
                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_CONNECTTIMEOUT, 5); // Tiempo máximo para conectar (5 segundos)
                            curl_setopt($RestApi, CURLOPT_TIMEOUT, 10);  // Tiempo máximo para la solicitud completa (10 segundos)
                            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Authorization: ' . $this->session->userdata('tokenJson'),
                                'Content-Type:application/json',
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "ambiente"  => $codAmbiente,
                                "idEnvio"   => $trannum,
                                "version"   => 3,
                                "tipoDte"   => "06",
                                "documento" => $docJsonFirmado,
                                "codigoGeneracion" => $cGeneracion
                            )));

                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultMH = json_decode($Resolve, true);

                            if ($resultMH['estado'] == 'PROCESADO') {
                                // print_r($Resolve);
                                // if ($codAmbiente == '01') {
                                    $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH));
                                // }
                                $msgSuccess = 'Código Generación: '.$resultMH['codigoGeneracion'].'<br>Sello Recibido: '.$resultMH['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum, 0, $this->session->userdata('dteSendPrint'), $this->session->userdata('dteSendEmail'));
                            } else {
                                // echo json_encode($fileDteJson);
                                // print_r($Resolve);
                                $detErrores = implode(",", $resultMH['observaciones']);
                                $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                                echo $this->sweetAlertError('DTE Presenta Errores', 'Código Generación: '.$cGeneracion.'<br>'.$msgError, $trannum);
                            }
                        } else {
                            echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum);
                }

                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function notaDeRemisionDTE($trannum, $optDoc = 0) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum);

                if (!$infoDTE) {
                    $fecha   = new DateTime();
                    $infoDoc = $this->dte_model->getDatosFacturacionJSONRemi($trannum);

                    if ($this->session->userdata('codAmbiente') == '01') {
                        $dateD = date_create($infoDoc->fecha);
                        $dYear = substr(date_format($dateD, 'Y'), 2, 2);
                        $rYear = strpos($fecha->format('Y-m-d'), $dYear);
                        if ( $rYear === false ) {
                            echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que contiene una serie de otro año');
                            exit;
                        }
                    }
                    
                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    
                    if ( $dteSucursal == 0 ) {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);
                    } else {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);

                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);
                    }

                    $docRelacionado  = false;
                    $otrosDocumentos = false;
                    $ventaTercero    = false;
                    $docApendice     = false;

                    $fileDteJson = new stdClass();

                    //NOTE: Identificacion JSON
                    if ($codAmbiente == '00') {
                        $numControl  = 'DTE-04-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad(rand(1000, 5000), 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "CD5".$nCodGenera."-3276-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-764A38".str_pad(rand(1000, 5000), 6, '0', STR_PAD_LEFT);
                    } else {
                        $numControl  = 'DTE-04-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($trannum, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "CD5".$nCodGenera."-3276-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($trannum, 6, '0', STR_PAD_LEFT);
                    }

                    $fileDteJson->identificacion = array(
                        'version'           => 3,
                        'ambiente'          => $codAmbiente,    // CAT-001
                        'tipoDte'           => '04',    // CAT-002
                        'numeroControl'     => $numControl,
                        'codigoGeneracion'  => $cGeneracion,
                        'tipoModelo'        => 1,       // CAT-003
                        'tipoOperacion'     => 1,       // CAT-004
                        'tipoContingencia'  => null,    // CAT-005
                        'motivoContin'      => null,
                        'fecEmi'            => ($codAmbiente == '00') ? $fecha->format('Y-m-d') : $infoDoc->fecha, // YYYY-MM-DD
                        'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                        'tipoMoneda'        => 'USD'
                    );

                    //NOTE: Documentos Relacionados JSON (Opcional Segun Requerimientos)

                    if ($docRelacionado) {
                        if ($codAmbiente == '00') {
                            $tipoGeneracion    = 1;
                            $tipoDocumento     = '03';
                            $numeroDocumentoRe = '25DS000C4F000';
                            $fechaEmi          = $fecha->format('Y-m-d');
                        } else {
                            $infoDTE = $this->dte_model->validateExistDocumentDte($infoDoc->tranref);

                            if (!$infoDTE) {
                                $infoDocRe = $this->dte_model->getInfoDocRelacionado($infoDoc->tranref);
                                
                                $tipoGeneracion    = 1;
                                $tipoDocumento     = '03';
                                $numeroDocumentoRe = $infoDocRe->numeroDocumento;
                                $fechaEmi          = $infoDocRe->fecha;
                            } else {
                                $infoDocJSON  = json_decode($infoDTE->json_doc, true);
                                $jsonIdentifi = $infoDocJSON['identificacion'];

                                $tipoGeneracion    = 2;
                                $tipoDocumento     = $jsonIdentifi['tipoDte'];
                                $numeroDocumentoRe = $jsonIdentifi['codigoGeneracion'];
                                $fechaEmi          = $jsonIdentifi['fecEmi'];
                            }
                        }

                        $fileDteJson->documentoRelacionado = [array(
                            'tipoDocumento'     => $tipoDocumento, // CAT-002
                            'tipoGeneracion'    => $tipoGeneracion,    // CAT-007
                            'numeroDocumento'   => $numeroDocumentoRe,
                            'fechaEmision'      => $fechaEmi
                        )];
                    } else $fileDteJson->documentoRelacionado = null;
                    
                    //NOTE: Emisor JSON
                    
                    $fileDteJson->emisor = array(
                        'nit'                 => ''.str_replace('-', '', $NIT).'',
                        'nrc'                 => ''.str_replace('-', '', $NRC).'',
                        'nombre'              => strtoupper($razonSocial),
                        'codActividad'        => $cActividad, // CAT-019
                        'descActividad'       => strtoupper($GIRO), // CAT-019
                        'nombreComercial'     => strtoupper($nComercial),
                        'codEstable'          => ''.strtoupper($infoDoc->centromh).'',
                        'codEstableMH'        => ''.strtoupper($infoDoc->centromh).'',
                        'codPuntoVentaMH'     => ''.strtoupper($infoDoc->cajamh).'',
                        'codPuntoVenta'       => ''.strtoupper($infoDoc->cajamh).'',
                        'tipoEstablecimiento' => '02', // CAT-009
                        'direccion' => array(
                            'departamento'    => ($infoDoc->iddeptodtesuc == 0) ? $cDepartamento : $infoDoc->iddeptodtesuc, // CAT-012
                            'municipio'       => ($infoDoc->idmunidtesuc == 0) ? $cMunicipio : $infoDoc->idmunidtesuc, // CAT-013
                            'complemento'     => ($infoDoc->direccionsucursal == "") ? strtoupper($direccion) : $infoDoc->direccionsucursal
                        ),
                        'telefono'            => str_replace('-', '', $telefono),
                        'correo'              => $correoEl,
                    );

                    $tipoDocumento = ($infoDoc->dui == '') ? (($infoDoc->nit == '') ? null : '36') : '13';

                    $infoDUI = str_replace('-', '', $infoDoc->dui);
                    $numeroDUI = substr($infoDUI, 0, -1).'-'.substr($infoDUI, 8, 9);
                    
                    //NOTE: Receptor JSON
                    if ($codAmbiente == '00') {
                        $fileDteJson->receptor = array(
                            'tipoDocumento'    => '36', // CAT-022
                            'numDocumento'     => '06142108891018',
                            'nrc'              => ''.str_replace('-', '', '8466-2').'',
                            'nombre'           => 'EMPRESAS GOMEZ GUATEMALA S.A. DE C.V.',
                            'nombreComercial'  => null,
                            'codActividad'     => '46510', // CAT-019
                            'descActividad'    => 'Venta al por mayor de computadoras, equipo periférico y programas informáticos', // CAT-019
                            'direccion' => array(
                                'departamento' => '06', // CAT-012
                                'municipio'    => '14',  // CAT-013
                                'complemento'  => 'Final 67 Avenida Sur y Pasaje Carbonell, N° 2A, Colonia Roma, San Salvador, El Salvador'
                            ),
                            'telefono'         => '25143094',
                            'correo'           => 'dte@versanetsa.com',
                            'bienTitulo'       => ''
                        );
                    } else {
                        if ($optDoc == 0) {
                            $fileDteJson->receptor = array(
                                'tipoDocumento'    => $tipoDocumento, // CAT-022
                                'numDocumento'     => ($tipoDocumento == null) ? null : (($tipoDocumento == '13') ? ''.$numeroDUI.'' : ''.str_replace('-', '', $infoDoc->nit).''),
                                'nrc'              => ($infoDoc->nrc == '') ? null : ''.str_replace('-', '', $infoDoc->nrc).'',
                                'nombre'           => $infoDoc->nameCliente,
                                'nombreComercial'  => null,
                                'codActividad'     => ($infoDoc->dte_giro == '' ? '47739' : $infoDoc->dte_giro), // CAT-019
                                'descActividad'    => ($infoDoc->dte_giro == '' ? 'Venta al por menor de otros productos n.c.p.' : $infoDoc->dte_giro_des), // CAT-019
                                'direccion' => array(
                                    'departamento' => $infoDoc->iddeptodte, // CAT-012
                                    'municipio'    => $infoDoc->idmunidte,  // CAT-013
                                    'complemento'  => $infoDoc->direccion
                                ),
                                'telefono'         => ($infoDoc->telefono == '' ? '00000000' : str_replace('-', '', $infoDoc->telefono)),
                                'correo'           => ($infoDoc->correo == '' ? 'correo@correo.com' : $infoDoc->correo),
                                'bienTitulo'       => '03'
                            );
                        } else {
                            $fileDteJson->receptor = array(
                                'tipoDocumento'    => '36', // CAT-022
                                'numDocumento'     => ''.str_replace('-', '', $NIT).'',
                                'nrc'              => ''.str_replace('-', '', $NRC).'',
                                'nombre'           => strtoupper($razonSocial),
                                'codActividad'        => $cActividad, // CAT-019
                                'descActividad'       => strtoupper($GIRO), // CAT-019
                                'nombreComercial'     => strtoupper($nComercial),
                                'direccion' => array(
                                    'departamento' => $infoDoc->iddeptodtesuc, // CAT-012
                                    'municipio'    => $infoDoc->idmunidtesuc,  // CAT-013
                                    'complemento'  => strtoupper($infoDoc->direcciondestino)
                                ),
                                'telefono'            => str_replace('-', '', $telefono),
                                'correo'              => $correoEl,
                                'bienTitulo'       => '04'
                            );
                        }
                    }
                                    
                    //NOTE: Ventas por Cuenta de Terceros
                    
                    if ($ventaTercero) {
                        $fileDteJson->ventaTercero = array(
                            'nit'    => '',
                            'nombre' => '',
                        );
                    } else $fileDteJson->ventaTercero = null;

                    //NOTE: Cuerpo del Documento (ForEach Items)
                    
                    $infoProductos = $this->dte_model->getDetalleProductosJSON($trannum);

                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0; $i=1;
                    $invexento = $infoDoc->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;

                    $dteProductos = array();
                    foreach($infoProductos as $infoPro) {
                        if ($optDoc == 0) {
                            if ($infoPro->tipotax != 0) {
                                $proPrecioNeto = ($infoPro->preciotran / (1 + ($infoPro->tipotax / 100)));
                            } else {
                                $proPrecioNeto = $infoPro->preciotran;
                            }
                        } else {
                            if ($infoPro->tipotax != 0) {
                                $proPrecioNeto = ($infoPro->precioventa / (1 + ($infoPro->tipotax / 100)));
                            } else {
                                $proPrecioNeto = $infoPro->precioventa;
                            }
                        }
                        
                        if ($infoPro->tipotax != 0 && $invexento == 0) {
                            $total        = $total + (($proPrecioNeto + ($proPrecioNeto * ($infoPro->tipotax / 100))) * abs($infoPro->cantidad));
                            $totalIVA     = $totalIVA + (($proPrecioNeto * ($infoPro->tipotax / 100)) * abs($infoPro->cantidad));
                            $totalGravado = $totalGravado + $proPrecioNeto * abs($infoPro->cantidad);
                            
                            $vnExenta  = 0;
                            $vnGravada = number_format(round($proPrecioNeto * abs($infoPro->cantidad), 8), 8, '.', '');

                        } else {
                            $total       = $total + (($proPrecioNeto) * abs($infoPro->cantidad));
                            $totalExento = $totalExento + $proPrecioNeto * abs($infoPro->cantidad);
                            
                            $vnExenta  = number_format(round($proPrecioNeto * abs($infoPro->cantidad), 8), 8, '.', '');
                            $vnGravada = 0;
                        }

                        $preciouni = $proPrecioNeto;
                        $preciouni = number_format(abs($preciouni), 8 ,'.','');
                        if($infoPro->descuento != 0 && $infoPro->descuento != "" && $vnGravada != ""){
                            $discount =  ($infoPro->descuento/100) * $vnGravada;
                        }
                        
                        if($infoPro->vnNotas != ""){
                            $notas = strtoupper(trim($infoPro->vnNotas));
                        }else{
                            $notas = "";
                        }

                        $idpro = $infoPro->idproducto;
                        $nombrepro = strtoupper(trim($infoPro->descrip)).' '.$notas;

                        if ($proPrecioNeto != 0) {
                            $dteProductos[] = array(
                                'numItem'         => $i,
                                'tipoItem'        => 1, // CAT-011 CAT-015
                                'numeroDocumento' => null, //$numeroDocumentoRe,
                                'cantidad'        => abs($infoPro->cantidad),
                                'codigo'          => $infoPro->idproducto,
                                'codTributo'      => null,  // CAT-015
                                'uniMedida'       => 59, // CAT-014
                                'descripcion'     => strtoupper($nombrepro),
                                'precioUni'       => (float) round($proPrecioNeto * 1, 8),
                                'montoDescu'      => 0,
                                'ventaNoSuj'      => 0,
                                'ventaExenta'     => (float) round($vnExenta * 1, 8),
                                'ventaGravada'    => (float) round($vnGravada * 1, 8),
                                'tributos'        => ($vnGravada != 0) ? ['20'] : null, // CAT-015
                            );

                            $i++;
                        }
                    }

                    $fileDteJson->cuerpoDocumento = $dteProductos;
                    
                    $tributos = array(
                        'codigo'      => '20', // CAT-015
                        'descripcion' => 'Impuesto al Valor Agregado 13%', // CAT-015
                        'valor'       => (float) number_format($totalIVA, 2, '.', ''),
                    );

                    $idPagoDTE = $this->dte_model->getFormaDePagoDocumento($trannum);

                    $pagos = array(
                        'codigo'     => $idPagoDTE,
                        'montoPago'  => (float) round($total, 2),
                        'referencia' => '',
                        'plazo'      => ($idPagoDTE == '13') ? '01' : null,
                        'periodo'    => ($idPagoDTE == '13') ? intval($infoDoc->dias) : null,
                    );

                    //NOTE: Resumen
                    $fileDteJson->resumen = array(
                        'totalNoSuj'          => 0,
                        'totalExenta'         => (float) number_format($totalExento, 2, '.', ''),
                        'totalGravada'        => (float) number_format($totalGravado, 2, '.', ''),
                        'subTotalVentas'      => (float) number_format($totalGravado + $totalExento, 2, '.', ''),
                        'descuNoSuj'          => 0,
                        'descuExenta'         => 0,
                        'descuGravada'        => 0,
                        'porcentajeDescuento' => 0,
                        'totalDescu'          => 0,
                        'tributos'            => ($totalGravado != 0) ? [$tributos] : null,
                        'subTotal'            => (float) number_format($totalGravado + $totalExento , 2, '.', ''),
                        // 'ivaRete1'            => 0,
                        // 'ivaPerci1'           => 0,
                        // 'reteRenta'           => 0,
                        'montoTotalOperacion' => (float) number_format($total, 2, '.', ''),
                        // 'totalNoGravado'      => 0,
                        // 'totalPagar'          => (float) number_format($total, 2, '.', ''),
                        'totalLetras'         => $this->valorEnLetras(number_format($total, 2, '.', '')),
                        // 'totalIva'            => 0,
                        // 'saldoFavor'          => 0,
                        // 'condicionOperacion'  => 1,
                        // 'pagos'               => [$pagos],
                        // 'numPagoElectronico'  => null
                    );

                    //NOTE: Extensión
                    $fileDteJson->extension = array(
                        'nombEntrega' => null, //'',
                        'docuEntrega'   => null, //'',
                        'nombRecibe'    => null, //'',
                        'docuRecibe'    => null, //'',
                        'observaciones' => null, //'',
                        // 'placaVehiculo' => null, //'',
                    );
                    
                    //NOTE: Apéndice
                    
                    if ($docApendice) {
                        $fileDteJson->apendice = array(
                            'campo'    => '',
                            'etiqueta' => '',
                            'valor'    => '',
                        );
                    } else $fileDteJson->apendice = null;

                    //NOTE: Sello Recepción recibido....

                    try {
                        //NOTE: FIRMAR DOCUMENTO JSON

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/"); //Por Empresa
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Content-Type:application/json'
                        ));
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit"         => ''.str_replace('-', '', $NIT).'',
                            "activo"      => true,
                            "passwordPri" => $pwdPrivate,
                            "dteJson"     => $fileDteJson
                        )));
                        
                        $Resolve = curl_exec($RestApi);

                        curl_close($RestApi);

                        $resultFirma = json_decode($Resolve, true);
                        
                        if( $resultFirma['status'] == 'OK' ){

                            //NOTE: AUTORIZACION API MH

                            $docJsonFirmado = $resultFirma['body'];

                            //NOTE: RECEPCION DE DOCUMENTO MH
                            
                            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/recepciondte" : "https://api.dtes.mh.gob.sv/fesv/recepciondte";
                            
                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Authorization: ' . $this->session->userdata('tokenJson'),
                                'Content-Type:application/json',
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "ambiente"  => $codAmbiente,
                                "idEnvio"   => $trannum,
                                "version"   => 3,
                                "tipoDte"   => "04",
                                "documento" => $docJsonFirmado,
                                "codigoGeneracion" => $cGeneracion
                            )));

                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultMH = json_decode($Resolve, true);

                            if ($resultMH['estado'] == 'PROCESADO') {
                                // print_r($Resolve);
                                if ($codAmbiente == '01') {
                                    $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH));
                                }
                                $msgSuccess = 'Código Generación: '.$resultMH['codigoGeneracion'].'<br>Sello Recibido: '.$resultMH['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum, 0, $this->session->userdata('dteSendPrint'), $this->session->userdata('dteSendEmail'));
                            } else {
                                // echo json_encode($fileDteJson);
                                // print_r($Resolve);
                                $detErrores = implode(",", $resultMH['observaciones']);
                                $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                                echo $this->sweetAlertError('DTE Presenta Errores', 'Código Generación: '.$cGeneracion.'<br>'.$msgError, $trannum);
                            }
                        } else {
                            echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum);
                }

                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function anulacionDTE($trannum, $idYear = 0) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {

                $msgCorreo = '';
                $email = 1;
                if ($email == 1) {
                    $msgCorreo = '<br><br><strong style=\'color:#97CE68;\'>Por favor espere hasta la confirmación de el envió de correo electrónico</strong>';
                }

                $idTable = ($idYear == 0) ? 0 : 1;

                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, $idTable, $idYear, 1);
                
                if ($infoDTE) {

                    $infoInval = $this->dte_model->validateInvalidDocumentDte($trannum, $idTable, $idYear);
                    
                    if (!$infoInval) {
                        $fecha   = new DateTime();
                        if ( $idTable == 1 ) {
                            $infoDoc = $this->dte_model->getDatosIvaCentralJSON($trannum, $idYear);
                        } else {
                            $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum);

                            if ($this->session->userdata('codAmbiente') == '01') {
                                $rSerie = strpos($infoDoc->serie, 'DTE');
                                if ( $rSerie === false ) {
                                    echo $this->sweetAlertError('Error de Documento', 'No se puede anular este documento por que no es un DTE');
                                    exit;
                                }

                                // $dYear = substr($fecha->format('Y'), 2, 2);
                                // $rYear = strpos($infoDoc->serie, $dYear);
                                // if ( $rYear === false ) {
                                //     echo $this->sweetAlertError('Error de Documento', 'No se puede generar este documento por que contiene una serie de otro año');
                                //     exit;
                                // }
                            }
                        }
                        
                        $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    
                        if ( $dteSucursal == 0 ) {
                            $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                            $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                            
                            $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                            $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                            $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                            $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                            $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                            $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                            
                            $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                            $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                            $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                            $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                            $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                            $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                            $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);
                            $duiAnulacion  = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 10);
                            $nomAnulacion  = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 11);
                        } else {
                            $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                            $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                            
                            $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                            $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                            $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                            $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                            $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                            $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);
                            
                            $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                            $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                            $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                            $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                            $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                            $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                            $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);
                            $duiAnulacion  = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 10);
                            $nomAnulacion  = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 11);
                        }

                        $fileDteJson = new stdClass();

                        //NOTE: Identificacion JSON
                        if ( $idTable == 1 ) {
                            $numControl  = 'ANULACION-'.str_pad($infoDoc->doc_numero, 15, '0', STR_PAD_LEFT);
                            $cGeneracion = "CCA".$nCodGenera."-9876-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-".$fecha->format('Y')."38".str_pad($trannum, 6, '0', STR_PAD_LEFT);
                        } else {
                            $numControl  = 'ANULACION-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                            $cGeneracion = "CCA".$nCodGenera."-9720-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-".$fecha->format('Y')."38".str_pad($trannum, 6, '0', STR_PAD_LEFT);
                        }

                        //NOTE: Documento JSON..
                        $infoDocJSON  = json_decode($infoDTE->json_doc, true);
                        $jsonIdentifi = $infoDocJSON['identificacion'];
                        $infoResumen  = $infoDocJSON['resumen'];
                        
                        $fileDteJson->identificacion = array(
                            'version'          => 2,
                            'ambiente'         => $codAmbiente,            // CAT-001
                            'codigoGeneracion' => $cGeneracion,
                            'fecAnula'         => $jsonIdentifi['fecEmi'], // YYYY-MM-DD
                            'horAnula'         => $fecha->format('H:i:s'), // HH:MM:SS
                        );

                        //NOTE: Emisor JSON
                        $fileDteJson->emisor = array(
                            'nit'                 => ''.str_replace('-', '', $NIT).'',
                            'nombre'              => strtoupper($razonSocial),
                            'nomEstablecimiento'  => strtoupper($nComercial),
                            'tipoEstablecimiento' => '02', // CAT-009
                            'telefono'            => str_replace('-', '', $telefono),
                            'codEstable'          => null,
                            'codEstableMH'        => ( $codAmbiente == "00") ? 'S001' : null,
                            'codPuntoVentaMH'     => ( $codAmbiente == "00") ? 'P001' : null,
                            'codPuntoVenta'       => null,
                            'correo'              => $correoEl,
                        );

                        if ( $jsonIdentifi['tipoDte'] == '03' ) {
                            if ($codAmbiente == '00') {
                                $jsonTributos  = $infoResumen['tributos'];
                                $montoIva      = number_format($jsonTributos[0]['valor'], 2, '.', '');
                                $infoReceptor  = $infoDocJSON['receptor'];
                                $tipoDocumento = ($infoDoc->nit == '') ? '37' : '36';
                                $numDocumento  = ($tipoDocumento == '36') ? ''.str_replace('-', '', $infoDoc->nit).'' : ''.str_replace('-', '', $infoDoc->nrc).'';
                            } else {
                                $jsonTributos  = $infoResumen['tributos'];
                                $montoIva      = number_format($jsonTributos[0]['valor'], 2, '.', '');
                                $infoReceptor  = $infoDocJSON['receptor'];
                                $tipoDocumento = ($infoDoc->nit == '') ? '37' : '36';
                                $numDocumento  = ($tipoDocumento == '36') ? ''.str_replace('-', '', $infoDoc->nit).'' : ''.str_replace('-', '', $infoDoc->nrc).'';
                            }
                        } else if ( $jsonIdentifi['tipoDte'] == '01' ) {
                            $montoIva      = number_format($infoResumen['totalIva'], 2, '.', '');
                            $infoReceptor  = $infoDocJSON['receptor'];
                            $tipoDocumento = $infoReceptor['tipoDocumento'];
                            $numDocumento  = $infoReceptor['numDocumento'];
                        } else if ( $jsonIdentifi['tipoDte'] == '14' ) {
                            $montoIva      = 0;
                            $infoReceptor  = $infoDocJSON['sujetoExcluido'];
                            $tipoDocumento = $infoReceptor['tipoDocumento'];
                            $numDocumento  = $infoReceptor['numDocumento'];
                        } else if ( $jsonIdentifi['tipoDte'] == '07' ) {
                            $montoIva      = 0;
                            $infoReceptor  = $infoDocJSON['receptor'];
                            $tipoDocumento = $infoReceptor['tipoDocumento'];
                            $numDocumento  = $infoReceptor['numDocumento'];
                        } else if ( $jsonIdentifi['tipoDte'] == '11' ) {
                            $montoIva      = 0;
                            $infoReceptor  = $infoDocJSON['receptor'];
                            $tipoDocumento = $infoReceptor['tipoDocumento'];
                            $numDocumento  = $infoReceptor['numDocumento'];
                        } else if ( $jsonIdentifi['tipoDte'] == '05' ) {
                            $jsonTributos  = $infoResumen['tributos'];
                            $montoIva      = number_format($jsonTributos[0]['valor'], 2, '.', '');
                            $infoReceptor  = $infoDocJSON['receptor'];
                            $tipoDocumento = ($infoDoc->nit == '') ? '37' : '36';
                            $numDocumento  = ($tipoDocumento == '36') ? ''.str_replace('-', '', $infoDoc->nit).'' : ''.str_replace('-', '', $infoDoc->nrc).'';
                        } else if ( $jsonIdentifi['tipoDte'] == '15' ) {
                            $montoIva      = 0;
                            $infoReceptor  = $infoDocJSON['donante'];
                            $tipoDocumento = $infoReceptor['tipoDocumento'];
                            $numDocumento  = $infoReceptor['numDocumento'];
                        } else {
                            $jsonTributos  = $infoResumen['tributos'];
                            $montoIva      = number_format($jsonTributos[0]['valor'], 2, '.', '');
                        }

                        $fileDteJson->documento = array(
                            "tipoDte"           => $jsonIdentifi['tipoDte'],
                            "codigoGeneracion"  => $infoDTE->cgeneracion,
                            "selloRecibido"     => $infoDTE->srecepcion,
                            "numeroControl"     => $infoDTE->ncontrol,
                            "fecEmi"            => $jsonIdentifi['fecEmi'],
                            "montoIva"          => (float) number_format($montoIva, 2, '.', ''),
                            "codigoGeneracionR" => null,
                            "tipoDocumento"     => $tipoDocumento,
                            'numDocumento'      => $numDocumento,
                            'nombre'            => $infoDoc->nameCliente,
                            'telefono'          => ($infoDoc->telefono == '' ? null : str_replace('-', '', $infoDoc->telefono)),
                            'correo'            => ($infoDoc->correo == '' ? 'correo@correo.com' : $infoDoc->correo)
                        );

                        //NOTE: Motivo Anulación JSON...
                        $fileDteJson->motivo = array(
                            "tipoAnulacion"     => 2,
                            "motivoAnulacion"   => "Error de documento",
                            "nombreResponsable" => $nomAnulacion,
                            "tipDocResponsable" => "13",
                            "numDocResponsable" => $duiAnulacion,
                            "nombreSolicita"    => $nomAnulacion,
                            "tipDocSolicita"    => "13",
                            "numDocSolicita"    => $duiAnulacion
                        );

                        try {
                            //NOTE: FIRMAR DOCUMENTO JSON
                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/"); //Por Empresa
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Content-Type:application/json'
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "nit"         => ''.str_replace('-', '', $NIT).'',
                                "activo"      => true,
                                "passwordPri" => $pwdPrivate,
                                "dteJson"     => $fileDteJson
                            )));
                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultFirma = json_decode($Resolve, true);
                            
                            if ( $resultFirma['status'] == 'OK' ) {
                                //NOTE: AUTORIZACION API MH
                                $docJsonFirmado = $resultFirma['body'];

                                //NOTE: RECEPCION DE DOCUMENTO MH
                                $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/anulardte" : "https://api.dtes.mh.gob.sv/fesv/anulardte";

                                $RestApi = curl_init();
                                curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                                curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                                curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                                curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                    'Authorization: ' . $this->session->userdata('tokenJson'),
                                    'Content-Type:application/json',
                                ));
                                curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                    "ambiente"  => $codAmbiente,
                                    "idEnvio"   => $trannum,
                                    "version"   => 2,
                                    "documento" => $docJsonFirmado,
                                )));

                                $Resolve = curl_exec($RestApi);
                                curl_close($RestApi);

                                $resultMH = json_decode($Resolve, true);

                                if ($resultMH['estado'] == 'PROCESADO') {
                                    $this->dte_model->anulacionDTE($trannum, $infoDTE->ncontrol);
                                    if ( $idTable == 0 ) {
                                        if ( $codAmbiente == "01" ) {
                                            $this->dte_model->setAnulacionVenta($trannum);
                                        }
                                    }
                                    $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH), 1, $idTable, $idYear, 1);
                                    
                                    $contentJS = '';
                                    // $contentJS .= '<script src="'.base_url().'node_modules/sweetalert2/dist/sweetalert2.all.min.js"></script>';
                                    $contentJS .= '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
                                    $contentJS .= '<body></body>';

                                    $contentJS .= '<script type="text/JavaScript">';
                                        $contentJS .= 'Swal.fire({';
                                            $contentJS .= 'icon:  "success",';
                                            $contentJS .= 'title: "<h4 style=\'font-family: sans-serif !important; margin:0px;\'>DTE Anulado Correctamente</h4>",';
                                            $contentJS .= 'html:  "<h5 style=\'font-family: sans-serif !important; margin:0px;\'>Código Generación: '.$resultMH['codigoGeneracion'].' <br> Sello Recibido: '.$resultMH['selloRecibido'].'</h5>'.$msgCorreo.'",';
                                            $contentJS .= 'allowOutsideClick: false,';
                                            $contentJS .= 'allowEscapeKey: false,';
                                            $contentJS .= 'confirmButtonText: \'Cerrar\',';
                                            $contentJS .= 'preConfirm: function(e){ window.close(); },';
                                        $contentJS .= '})';
                                    $contentJS .= '</script>';

                                    echo $contentJS;

                                    $contentJS1 = '<script type="text/JavaScript">';
                                    // if ($this->session->userdata('idaccount') != '45357159') {
                                
                                        if ($email == 1 ) {
                                            $contentJS1 .= 'setTimeout(function(){ window.location.href = \''.base_url().'dev/electronicBills/'.$trannum.'/'.$idYear.'/1'.'\'; }, 8000);';
                                        }
                                    // }
                                    $contentJS1 .= '</script>';
                                    
                                    echo $contentJS1;
                                } else {
                                    $detErrores = implode(",", $resultMH['observaciones']);
                                    $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                                    echo $this->sweetAlertError('DTE Presenta Errores', 'Código Generación: '.$cGeneracion.'<br>'.$msgError);
                                }
                            } else {
                                echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                            }
                        } catch(SoapFault $e) {
                            echo "CATCH: " . $e->faultstring;
                        }
                    } else {
                        $contentJS = '';
                        // $contentJS .= '<script src="'.base_url().'node_modules/sweetalert2/dist/sweetalert2.all.min.js"></script>';
                        $contentJS .= '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
                        $contentJS .= '<body></body>';

                        $contentJS .= '<script type="text/JavaScript">';
                            $contentJS .= 'Swal.fire({';
                                $contentJS .= 'icon:  "success",';
                                $contentJS .= 'title: "<h4 style=\'font-family: sans-serif !important; margin:0px;\'>DTE Anulado Correctamente</h4>",';
                                $contentJS .= 'html:  "<h5 style=\'font-family: sans-serif !important; margin:0px;\'>Código Generación: '.$infoInval->cgeneracion.' <br> Sello Recibido: '.$infoInval->srecepcion.'</h5>'.$msgCorreo.'",';
                                $contentJS .= 'allowOutsideClick: false,';
                                $contentJS .= 'allowEscapeKey: false,';
                                $contentJS .= 'confirmButtonText: \'Cerrar\',';
                                $contentJS .= 'preConfirm: function(e){ window.close(); },';
                            $contentJS .= '})';
                        $contentJS .= '</script>';

                        echo $contentJS;

                        $contentJS1 = '<script type="text/JavaScript">';
                        // if ($this->session->userdata('idaccount') != '45357159') {
                    
                            if ($email == 1 ) {
                                $contentJS1 .= 'setTimeout(function(){ window.location.href = \''.base_url().'dev/electronicBills/'.$trannum.'/'.$idYear.'/1'.'\'; }, 8000);';
                            }
                        // }
                        $contentJS1 .= '</script>';

                        echo $contentJS1;
                    }
                } else {
                    $contentJS = '';
                    // $contentJS .= '<script src="'.base_url().'node_modules/sweetalert2/dist/sweetalert2.all.min.js"></script>';
                    $contentJS .= '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
                    $contentJS .= '<body></body>';

                    $contentJS .= '<script type="text/JavaScript">';
                        $contentJS .= 'Swal.fire({';
                            $contentJS .= 'icon:  "error",';
                            $contentJS .= 'title: "<h4 style=\'font-family: sans-serif !important; margin:0px;\'>ERROR ANULACIÓN</h4>",';
                            $contentJS .= 'html:  "<h5 style=\'font-family: sans-serif !important; margin:0px;\'>No se puede anular un documento sin emitir.</h5>",';
                            $contentJS .= 'allowOutsideClick: false,';
                            $contentJS .= 'allowEscapeKey: false,';
                            $contentJS .= 'confirmButtonText: \'Cerrar\',';
                            $contentJS .= 'preConfirm: function(e){ window.close(); },';
                        $contentJS .= '})';
                    $contentJS .= '</script>';

                    echo $contentJS;
                }

                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function contingenciaDTE($trannum) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $fecha = new DateTime();
                $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum);
                
                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    
                if ( $dteSucursal == 0 ) {
                    $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                    $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                    
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                    $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                    $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                    $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                    
                    $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                    $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                    $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                    $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                    $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                    $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                    $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);
                    $duiAnulacion  = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 10);
                    $nomAnulacion  = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 11);
                } else {
                    $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                    $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                    
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                    $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                    $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                    $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                    $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);
                    
                    $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                    $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                    $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                    $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                    $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                    $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                    $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);
                    $duiAnulacion  = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 10);
                    $nomAnulacion  = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 11);
                }

                $docRelacionado  = true;
                $otrosDocumentos = false;
                $ventaTercero    = false;
                $docApendice     = false;

                $fileDteJson = new stdClass();
                
                $numControl  = 'CONTINGENCIA-'.str_pad($trannum, 15, '0', STR_PAD_LEFT);
                $cGeneracion = "C0CFB21E-9836-".rand(1000, 9999)."-785E-764A38".str_pad($trannum, 6, '0', STR_PAD_LEFT);
                
                //NOTE: Identificacion JSON
                $fileDteJson->identificacion = array(
                    'version'           => 3,
                    'ambiente'          => $codAmbiente,    // CAT-001
                    'codigoGeneracion'  => $cGeneracion,
                    'fTransmision'      => $fecha->format('Y-m-d'), // YYYY-MM-DD
                    'hTransmision'      => $fecha->format('H:i:s'), // HH:MM:SS
                );

                //NOTE: Emisor JSON
                $fileDteJson->emisor = array(
                    'nit'                  => ''.str_replace('-', '', $NIT).'',
                    'nombre'               => strtoupper($razonSocial),
                    'tipoEstablecimiento'  => '02', // CAT-009
                    'telefono'             => str_replace('-', '', $telefono),
                    'codEstableMH'         => null,
                    'codPuntoVenta'        => null,
                    'correo'               => $correoEl,
                    "nombreResponsable"    => $nomAnulacion,
                    "tipoDocResponsable"   => "13",
                    "numeroDocResponsable" => $duiAnulacion,
                );
                
                //NOTE: Documento Receptor JSON
                $cGeneracionC = "CFC9B21E-4268-".rand(1000, 9999)."-785E-8A5486".str_pad($trannum, 6, '0', STR_PAD_LEFT);

                $fileDteJson->detalleDTE = [array(
                    "noItem"            => 1,
                    "codigoGeneracion"  => $cGeneracionC,
                    "tipoDoc"           => "01"
                )];
                
                //NOTE: Documento Receptor JSON
                $fileDteJson->motivo = array(
                    "fInicio"            => $fecha->format('Y-m-d'),
                    "fFin"               => $fecha->format('Y-m-d'),
                    "hInicio"            => $fecha->format('H:m:s'),
                    "hFin"               => $fecha->format('H:m:s'),
                    "tipoContingencia"   =>	2,
                    "motivoContingencia" => "Error en sistema de envio DTE"
                );

                // echo json_encode($fileDteJson);

                //NOTE: Sello Recepción recibido....
                try {
                    //NOTE: FIRMAR DOCUMENTO JSON
                    $RestApi = curl_init();
                    curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/"); //Por Empresa
                    curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                        'Content-Type:application/json'
                    ));
                    curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                        "nit"         => ''.str_replace('-', '', $NIT).'',
                        "activo"      => true,
                        "passwordPri" => $pwdPrivate,
                        "dteJson"     => $fileDteJson
                    )));
                    
                    $Resolve = curl_exec($RestApi);

                    // print_r($Resolve);
                    
                    curl_close($RestApi);

                    $resultFirma = json_decode($Resolve, true);
                    
                    if( $resultFirma['status'] == 'OK' ){

                        //NOTE: AUTORIZACION API MH
                        $docJsonFirmado = $resultFirma['body'];

                        //NOTE: RECEPCION DE DOCUMENTO MH
                        $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/contingencia" : "https://api.dtes.mh.gob.sv/fesv/contingencia";

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Authorization: ' . $this->session->userdata('tokenJson'),
                            'Content-Type:application/json',
                        ));
                        // curl_setopt($RestApi, CURLOPT_CUSTOMREQUEST, "POST");
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit" => ''.str_replace('-', '', $NIT).'',
                            "documento" => $docJsonFirmado,
                        )));

                        $Resolve = curl_exec($RestApi);
                        curl_close($RestApi);

                        $resultMH = json_decode($Resolve, true);

                        if ($resultMH['estado'] == 'RECIBIDO') {
                            // print_r($Resolve);
                            // $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH));

                            $contentJS = '';
                            // $contentJS .= '<script src="'.base_url().'node_modules/sweetalert2/dist/sweetalert2.all.min.js"></script>';
                            $contentJS .= '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
                            $contentJS .= '<body></body>';

                            $contentJS .= '<script type="text/JavaScript">';
                                $contentJS .= 'Swal.fire({';
                                    $contentJS .= 'icon:  "success",';
                                    $contentJS .= 'title: "<h4 style=\'font-family: sans-serif !important; margin:0px;\'>DTE Contingencia Generada Correctamente</h4>",';
                                    $contentJS .= 'html:  "<h5 style=\'font-family: sans-serif !important; margin:0px;\'>Sello Recibido: '.$resultMH['selloRecibido'].'</h5>",';
                                    $contentJS .= 'allowOutsideClick: false,';
                                    $contentJS .= 'allowEscapeKey: false,';
                                    $contentJS .= 'confirmButtonText: \'Cerrar\',';
                                    $contentJS .= 'preConfirm: function(e){ window.close(); },';
                                $contentJS .= '})';
                            $contentJS .= '</script>';

                            echo $contentJS;
                        } else {
                            // print_r($Resolve);
                            $detErrores = implode(",", $resultMH['observaciones']);
                            $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                            echo $this->sweetAlertError('DTE Presenta Errores', 'Código Generación: '.$cGeneracion.'<br>'.$msgError);
                        }
                    } else {
                        echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                    }
                    
                    // if($resultado->return->valido){
                        
                    // }else{
                    //     echo "ERROR: " . $resultado->return->descripcion;
                    // }
                } catch(SoapFault $e) {
                    echo "CATCH: " . $e->faultstring;
                }

                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        //TODO: Pendiente de Configurar
        function comprobanteDeLiquidacionDTE($trannum) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }

        function comprobanteDeDonacionDTE($trannum, $infoJSON = false) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                 $infoDTE = $this->dte_model->validateExistDocumentDte($trannum);

                if (!$infoDTE) {
                    $fecha = new DateTime();
                    $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum);
                    
                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    
                    if ( $dteSucursal == 0 ) {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                        
                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 8);

                        $tipoContribuyente = $this->global_model->getDatoTipoContribuyenteEmp('g_empdatos', 10);
                    } else {
                        $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 3);
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 5);
                        
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 2);
                        $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 6);
                        $deptoMuni   = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 7);
                        $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 9);
                        $correoEl    = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 11);
                        
                        $cActividad    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 1);
                        $cDepartamento = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 2);
                        $cMunicipio    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 3);
                        $nCodGenera    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                        $pwdPrivate    = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 6);
                        $urlFirmador   = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 8);

                        $tipoContribuyente = $this->global_model->getDatoTipoContribuyenteEmp('g_empdatos_0'.$infoDoc->idcentro, 10);
                    }

                    $docRelacionado  = false;
                    $otrosDocumentos = false;
                    $ventaTercero    = false;
                    $docApendice     = false;

                    $fileDteJson = new stdClass();

                    //NOTE: Identificacion JSON

                    if ($codAmbiente == '00') {
                        $numControl  = 'DTE-15-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad(rand(1000, 5000), 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "CDD".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8A5486".str_pad(rand(1000, 5000), 6, '0', STR_PAD_LEFT);
                    } else {
                        $numControl  = 'DTE-15-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "CDD".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                    }
                    
                    $datetime1 = date_create($infoDoc->fecha);
                    $datetime2 = $fecha->format('Y-m-d');

                    $tipoModelo  = ( $datetime1->format('Y-m-d') != $datetime2 ) ? 2 : 1;

                    $fileDteJson->identificacion = array(
                        'version'           => 1,
                        'ambiente'          => $codAmbiente,        // CAT-001
                        'tipoDte'           => '15',                // CAT-002
                        'numeroControl'     => $numControl,
                        'codigoGeneracion'  => $cGeneracion,
                        'tipoModelo'        => 1, //intval($tipoModelo), // CAT-003
                        'tipoOperacion'     => 1,
                        'fecEmi'            => ($codAmbiente == '00') ? $fecha->format('Y-m-d') : $infoDoc->fecha, // YYYY-MM-DD
                        'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                        'tipoMoneda'        => 'USD'
                    );

                    //NOTE: Emisor JSON
                    
                    $fileDteJson->donatario = array(
                        'tipoDocumento'       => '36', // CAT-022
                        'numDocumento'        => ''.str_replace('-', '', $NIT).'',
                        'nrc'                 => ($NRC == '') ? null : ''.str_replace('-', '', $NRC).'',
                        'nombre'              => strtoupper($razonSocial),
                        'codActividad'        => $cActividad, // CAT-019
                        'descActividad'       => strtoupper($GIRO), // CAT-019
                        'nombreComercial'     => strtoupper($nComercial),
                        'tipoEstablecimiento' => '02', // CAT-009
                        'direccion' => array(
                            'departamento'    => ($infoDoc->iddeptodtesuc == 0) ? $cDepartamento : $infoDoc->iddeptodtesuc, // CAT-012
                            'municipio'       => ($infoDoc->idmunidtesuc == 0) ? $cMunicipio : $infoDoc->idmunidtesuc, // CAT-013
                            'complemento'     => ($infoDoc->direccionsucursal == "") ? strtoupper($direccion) : $infoDoc->direccionsucursal
                        ),
                        'telefono'            => str_replace('-', '', $telefono),
                        'codEstable'          => ''.strtoupper($infoDoc->centromh).'',
                        'codEstableMH'        => ''.strtoupper($infoDoc->centromh).'',
                        'codPuntoVentaMH'     => ''.strtoupper($infoDoc->cajamh).'',
                        'codPuntoVenta'       => ''.strtoupper($infoDoc->cajamh).'',
                        'correo'              => $correoEl,
                    );
                    
                    //NOTE: Receptor JSON
                    
                    $tipoDocumento = ($infoDoc->dui == '') ? (($infoDoc->nit == '') ? null : '36') : '13';

                    $infoDUI = str_replace('-', '', $infoDoc->dui);
                    $numeroDUI = substr($infoDUI, 0, -1).'-'.substr($infoDUI, 8, 9);

                    if ($codAmbiente == '00') {
                        $fileDteJson->donante = array(
                            'tipoDocumento'    => '13', // CAT-022
                            'numDocumento'     => '05468527-6',
                            'nrc'              => null,
                            'nombre'           => 'KEVIN IVAN CIENFUEGOS ORELLANA',
                            'codActividad'     => null,
                            'descActividad'    => null,
                            'direccion'        => null,
                            'telefono'         => '22564532',
                            'correo'           => 'correo@correo.com',
                            'codDomiciliado'   => 2,
                            'codPais'          => '9300',
                        );
                    } else {
                        if ($infoDoc->idpaisdte == '9300') {
                            $fileDteJson->donante = array(
                                'tipoDocumento'    => $tipoDocumento, // CAT-022
                                'numDocumento'     => ($tipoDocumento == null) ? null : (($tipoDocumento == '13') ? ''.$numeroDUI.'' : ''.str_replace('-', '', $infoDoc->nit).''),
                                'nrc'              => ($infoDoc->nrc == '') ? null : ''.str_replace('-', '', $infoDoc->nrc).'',
                                'nombre'           => $infoDoc->nameCliente,
                                'codActividad'     => ($infoDoc->dte_giro == '' ? null : $infoDoc->dte_giro), // CAT-019
                                'descActividad'    => ($infoDoc->dte_giro == '' ? null : $infoDoc->dte_giro_des), // CAT-019
                                'direccion' => array(
                                    'departamento' => $infoDoc->iddeptodte, // CAT-012
                                    'municipio'    => $infoDoc->idmunidte,  // CAT-013
                                    'complemento'  => ($infoDoc->direccion == "") ? "SAN SALVADOR" : $infoDoc->direccion,
                                ),
                                'telefono'         => ($infoDoc->telefono == '' ? null : str_replace('-', '', $infoDoc->telefono)),
                                'correo'           => ($infoDoc->correo == '' ? null : $infoDoc->correo),
                                'codDomiciliado'   => 1,
                                'codPais'          => ''.$infoDoc->idpaisdte.'',
                            );
                        } else {
                            $fileDteJson->donante = array(
                                'tipoDocumento'    => '37', // CAT-022
                                'numDocumento'     => ''.str_replace('-', '', $infoDoc->nit).'',
                                'nrc'              => null,
                                'nombre'           => $infoDoc->nameCliente,
                                'codActividad'     => null,
                                'descActividad'    => null,
                                'direccion'        => null,
                                'telefono'         => ($infoDoc->telefono == '' ? null : str_replace('-', '', $infoDoc->telefono)),
                                'correo'           => ($infoDoc->correo == '' ? null : $infoDoc->correo),
                                'codDomiciliado'   => 2,
                                'codPais'          => ''.$infoDoc->idpaisdte.'',
                            );
                        }
                    }
                    
                    //NOTE: Otros Documentos Asociados
                    
                    $otrosDocs[] = array(
                        'codDocAsociado'   => 1,
                        'descDocumento'    => 'Comprobante Donación',
                        'detalleDocumento' => 'Comprobante Donación',
                    );

                    $fileDteJson->otrosDocumentos = $otrosDocs;

                    //NOTE: Cuerpo del Documento (ForEach Items)
                    
                    $infoProductos = $this->dte_model->getDetalleProductosJSONDonacion($trannum);

                    $total = 0;
                    $dteProductos = array();
                    foreach($infoProductos as $infoPro) {
                        $total = $total + (($infoPro->preciotran) * abs($infoPro->cantidad));
                        
                        $dteProductos[] = array(
                            'numItem'         => 1,
                            'tipoDonacion'    => intval($infoDoc->notas),
                            'cantidad'        => abs($infoPro->cantidad),
                            'codigo'          => null,
                            'uniMedida'       => 99, // CAT-014
                            'descripcion'     => strtoupper($infoPro->notas),
                            'valorUni'        => (float) number_format($infoPro->preciotran, 4, '.', ''),
                            'depreciacion'    => 0,
                            'valor'           => (float) number_format($infoPro->preciotran, 4, '.', ''),
                        );
                    }

                    $fileDteJson->cuerpoDocumento = $dteProductos;

                    $itemsPagos[] = array(
                        'codigo' => null,
                        'montoPago' => 0,
                        'referencia' => null,
                    );

                    //NOTE: Resumen
                    $fileDteJson->resumen = array(
                        'valorTotal'  => (float) round($total, 2),
                        'totalLetras' => $this->valorEnLetras(round($total, 2)),
                        'pagos'       => $itemsPagos,
                    );

                    //NOTE: Apéndice
                    
                    if ($docApendice) {
                        $fileDteJson->apendice = array(
                            'campo'    => '',
                            'etiqueta' => '',
                            'valor'    => '',
                        );
                    } else $fileDteJson->apendice = null;

                    //NOTE: Sello Recepción recibido....

                    try {
                        //NOTE: FIRMAR DOCUMENTO JSON

                        $RestApi = curl_init();
                        curl_setopt($RestApi, CURLOPT_URL, "http://".$urlFirmador.":9000/firmardocumento/");
                        curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                            'Content-Type:application/json'
                        ));
                        curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                            "nit"         => ''.str_replace('-', '', $NIT).'',
                            "activo"      => true,
                            "passwordPri" => $pwdPrivate,
                            "dteJson"     => $fileDteJson
                        )));
                        
                        $Resolve = curl_exec($RestApi);

                        curl_close($RestApi);

                        $resultFirma = json_decode($Resolve, true);
                        
                        if( $resultFirma['status'] == 'OK' ){

                            $docJsonFirmado = $resultFirma['body'];

                            if ($infoJSON) {
                                return $jsonFiles = array(
                                    'fileDteJson' => $fileDteJson,
                                    'docJsonFirmado' => $docJsonFirmado
                                );
                            }

                            $urlApi = ( $codAmbiente == "00") ? "https://apitest.dtes.mh.gob.sv/fesv/recepciondte" : "https://api.dtes.mh.gob.sv/fesv/recepciondte";
                            
                            //NOTE: RECEPCION DE DOCUMENTO MH

                            $RestApi = curl_init();
                            curl_setopt($RestApi, CURLOPT_URL, $urlApi);
                            curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($RestApi, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                            curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                                'Authorization: ' . $this->session->userdata('tokenJson'),
                                'Content-Type:application/json',
                            ));
                            curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                                "ambiente"  => $codAmbiente,
                                "idEnvio"   => $trannum,
                                "version"   => 1,
                                "tipoDte"   => "15",
                                "documento" => $docJsonFirmado,
                                "codigoGeneracion" => $cGeneracion
                            )));

                            $Resolve = curl_exec($RestApi);
                            curl_close($RestApi);

                            $resultMH = json_decode($Resolve, true);

                            if ($resultMH['estado'] == 'PROCESADO') {
                                // print_r($Resolve);
                                // if ($codAmbiente == '01') {
                                    $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMH['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMH));
                                // }
                                $msgSuccess = 'Código Generación: '.$resultMH['codigoGeneracion'].'<br>Sello Recibido: '.$resultMH['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum, 0, $this->session->userdata('dteSendPrint'), $this->session->userdata('dteSendEmail'));
                            } else {
                                // echo json_encode($fileDteJson);
                                // print_r($Resolve);
                                $detErrores = implode(",", $resultMH['observaciones']);
                                $msgError   = $resultMH['descripcionMsg'].' <br> Errores: '.$detErrores;

                                echo $this->sweetAlertError('DTE Presenta Errores', 'Código Generación: '.$cGeneracion.'<br>'.$msgError);
                            }
                        } else {
                            echo $this->sweetAlertError('Firma Electrónica', $resultFirma['body']['mensaje'], $trannum);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum);
                }
            }
        }

        //TODO: Pendiente de Configurar
        function documentoDeLiquidacionContableDTE($trannum) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }

        function popupSweetAlert($trannum) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $idPagoDTE = $this->dte_model->getFormaDePagoDocumento($trannum);

                $contentJS = '';
                // $contentJS .= '<script src="'.base_url().'node_modules/sweetalert2/dist/sweetalert2.all.min.js"></script>';
                $contentJS .= '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
                $contentJS .= '<body></body>';
                
                // $contentJS .= '<script type="text/JavaScript">';
                //     $contentJS .= 'Swal.fire({';
                //         $contentJS .= 'icon:  "error",';
                //         $contentJS .= 'title: "<h4 style=\'font-family: sans-serif !important; margin:0px;\'>DTE Presenta Errores</h4>",';
                //         $contentJS .= 'html:  "<h6 style=\'font-family: sans-serif !important; margin:0px;\'>DOCUMENTO JSON NO CUMPLE ESQUEMA <br> Errores: ERROR ERROR ERROR</h6>",';
                //         $contentJS .= 'confirmButtonText: \'Reenviar Documento\',';
                //         $contentJS .= 'denyButtonText: \'Cancelar\',';
                //         $contentJS .= 'showCancelButton: false,';
                //         $contentJS .= 'showDenyButton: true,';
                //         $contentJS .= 'preConfirm: function(e){ location.reload(); },';
                //         $contentJS .= 'preDeny: function(e){ window.close(); }';
                //     $contentJS .= '})';
                // $contentJS .= '</script>';

                $contentJS .= '<script type="text/JavaScript">';
                    $contentJS .= 'Swal.fire({';
                        $contentJS .= 'icon:  "success",';
                        $contentJS .= 'title: "<h5 style=\'font-family: sans-serif !important; margin:0px;\'>DTE Presentado Correctamente '.$idPagoDTE.'</h5>",';
                        $contentJS .= 'allowOutsideClick: false,';
                        $contentJS .= 'allowEscapeKey: false,';
                        $contentJS .= 'confirmButtonText: \'Generar PDF\',';
                        $contentJS .= 'showCancelButton: true,';
                        $contentJS .= 'cancelButtonText: \'Cancelar\',';
                        $contentJS .= 'preConfirm: function(e){ window.location.href = \''.base_url().'dev/electronicBills/'.$trannum.'\'; },';
                    $contentJS .= '})';
                $contentJS .= '</script>';

                echo $contentJS;
            }
        }

        function sweetAlertError($title, $bodyMsg, $trannum = 0) {
            $contentJS = '';
            // $contentJS .= '<script src="'.base_url().'node_modules/sweetalert2/dist/sweetalert2.all.min.js"></script>';
            $contentJS .= '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
            $contentJS .= '<body></body>';
            
            $contentJS .= '<script type="text/JavaScript">';
                $contentJS .= 'Swal.fire({';
                    $contentJS .= 'icon:  "error",';
                    $contentJS .= 'title: "<h4 style=\'font-family: sans-serif !important; margin:0px;\'>'.$title.'</h4>",';
                    $contentJS .= 'html:  "<h5 style=\'font-family: sans-serif !important; margin:0px;\'>'.$bodyMsg.'</h5>",';
                    $contentJS .= 'allowOutsideClick: false,';
                    $contentJS .= 'allowEscapeKey: false,';
                    $contentJS .= 'confirmButtonText: \'Reenviar Documento\',';
                    $contentJS .= 'showDenyButton: true,';
                    $contentJS .= 'denyButtonText: \'Cancelar\',';
                    //if ($this->session->userdata('idaccount') == '4618' || $this->session->userdata('idaccount') == '1858540' || $this->session->userdata('idaccount') == '2585TIENDAS') {
                    $contentJS .= 'cancelButtonText: \'Ticket Temporal\',';
                    $contentJS .= 'showCancelButton: true,';
                    //}
                    $contentJS .= 'preConfirm: function(e){ location.reload(); },';
                    $contentJS .= 'preDeny: function(e){ window.close(); }';
                $contentJS .= '}).then(( result ) => {';
                    $contentJS .= 'if(result.isDismissed) {';
                        //if ($this->session->userdata('idaccount') == '4618' || $this->session->userdata('idaccount') == '1100831' || $this->session->userdata('idaccount') == '2585TIENDAS') {
                        $contentJS .= 'window.location.href = \''.base_url().'dte/ventaTicketTemporal/'.$trannum.'\';';
                        $contentJS .= 'setTimeout(function(){ window.close(); }, 8000);';
                        // } else {
                        //     $contentJS .= 'setTimeout(function(){ window.close(); }, 2000);';
                        // }
                    $contentJS .= '}';
                $contentJS .= '});';
            $contentJS .= '</script>';

            return $contentJS;
        }
        #M4n0s!
        function sweetAlertSuccess($title, $bodyMsg, $trannum, $idyear = 0, $print = 0, $email = 0) {
            $msgCorreo = '';
            if ($email == 1) {
                $msgCorreo = '<br><br><strong style=\'color:#97CE68;\'>Por favor espere hasta la confirmación de el envió de correo electrónico</strong>';
            }

            $serverName = $this->session->userdata('server_name');

            $contentJS = '';
            // $contentJS .= '<script src="'.base_url().'node_modules/sweetalert2/dist/sweetalert2.all.min.js"></script>';
            $contentJS .= '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
            $contentJS .= '<body></body>';

            $contentJS .= '<script type="text/JavaScript">';
                $contentJS .= 'Swal.fire({';
                    $contentJS .= 'icon:  "success",';
                    $contentJS .= 'title: "<h4 style=\'font-family: sans-serif !important; margin:0px;\'>'.$title.'</h4>",';
                    $contentJS .= 'html:  "<h5 style=\'font-family: sans-serif !important; margin:0px;\'>'.$bodyMsg.$msgCorreo.'</h5>",';
                    $contentJS .= 'allowOutsideClick: false,';
                    $contentJS .= 'allowEscapeKey: false,';
                    $contentJS .= 'confirmButtonText: \'Generar PDF\',';
                    $contentJS .= 'denyButtonText: \'Cerrar\',';
                    $contentJS .= 'cancelButtonText: \'Imprimir Comprobante\',';
                    $contentJS .= 'showCancelButton: true,';
                    $contentJS .= 'showDenyButton: true,';
                    
                    if ( $idyear == 0 ) {
                        $contentJS .= 'preConfirm: function(e){ window.location.href = \''.base_url().'dev/electronicBills/'.$trannum.'\'; },';
                    } else {
                        $contentJS .= 'preConfirm: function(e){ window.location.href = \''.base_url().'dev/electronicBills/'.$trannum.'/'.$idyear.'\'; },';
                    }
                    
                    $contentJS .= 'preDeny: function(e){ window.close(); }';
                $contentJS .= '}).then(( result ) => {';
                    $contentJS .= 'if(result.isDismissed) {';
                        $contentJS .= 'window.location.href = \''.base_url().'dev/ticketDTEnoFiscal/'.$trannum.'\';';
                        if ($this->session->userdata('idaccount') == '4618' || $this->session->userdata('idaccount') == '1100831' || $this->session->userdata('idaccount') == '2585TIENDAS') {
                            $contentJS .= 'setTimeout(function(){ window.close(); }, 8000);';
                        } else {
                            $contentJS .= 'setTimeout(function(){ window.close(); }, 2000);';
                        }
                    $contentJS .= '}';
                $contentJS .= '});';
                
                // if ($this->session->userdata('idaccount') != '45357159') {
                    
                    if ($email == 1 ) {
                        $contentJS .= 'setTimeout(function(){ window.location.href = \''.base_url().'dev/electronicBills/'.$trannum.'/'.$idyear.'/1'.'\'; }, 8000);';
                    }
                    
                    if ($print == 1) {
                        $contentJS .= 'setTimeout(function(){ window.location.href = \''.base_url().'dev/ticketDTEnoFiscal/'.$trannum.'\'; }, 2000);';
                    }
                // }
            $contentJS .= '</script>';

            return $contentJS;
        }

        function recuperacionInformacionDTE($trannum, $cDTE, $idYear = 0, $idTable = 0) {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, $idTable, $idYear);

                if (!$infoDTE) {
                    $fecha = new DateTime();

                    if ($idTable == 1) {
                        $infoDoc = $this->dte_model->getDatosIvaCentralJSON($trannum, $idYear);
                    } else {
                        $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum);
                    }
                    
                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

                    if ( $dteSucursal == 0 ) {
                        $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                        $nCodGenera  = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                        $codAmbiente = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                    } else {
                        $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                        $nCodGenera  = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                        $codAmbiente = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                    }

                    if ( $cDTE == '01' ) { // Factura Consumidor Final
                        $numControl  = 'DTE-01-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "FCF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);

                        $infoResJSON = $this->facturaConsumidorFinalDTE($trannum, true);
                    } else if ( $cDTE == '03' ) { // Comprobante de Credito Fiscal
                        $numControl  = 'DTE-03-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "CCF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);

                        $infoResJSON = $this->comprobanteCreditoFiscalDTE($trannum, true);
                    } else if ( $cDTE == '04' ) { // Nota de Remisión
                        $numControl  = 'DTE-04-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "CD5".$nCodGenera."-3276-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                    } else if ( $cDTE == '05' ) { // Nota de Crédito
                        $numControl  = 'DTE-05-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "C4F".$nCodGenera."-9836-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);

                        $infoResJSON = $this->notaDeCreditoDTE($trannum, true);
                    } else if ( $cDTE == '06' ) { // Nota de Debito
                        $numControl  = 'DTE-06-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "DEB".$nCodGenera."-3276-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);

                        $infoResJSON = $this->notaDeDebitoDTE($trannum, true);
                    } else if ( $cDTE == '11' ) { // Factura de Exportación
                        $numControl  = 'DTE-11-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "EEF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);

                        $infoResJSON = $this->facturaDeExportacionDTE($trannum, true);
                    } else if ( $cDTE == '7' ) { // Comprobante de Retención 13%
                        $numControl  = 'DTE-07-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->doc_numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "C0C".$nCodGenera."-4368-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);
                    } else if ( $cDTE == '14' ) { // Factura de Sujeto Excluido
                        $numControl  = 'DTE-14-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->doc_numero, 15, '0', STR_PAD_LEFT);
                        $cGeneracion = "EEF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);

                        $infoResJSON = $this->facturaSujetoExcluidoDTE($trannum, $idYear, true);
                    }

                    $fileDteJson    = $infoResJSON['fileDteJson'];
                    $docJsonFirmado = $infoResJSON['docJsonFirmado'];

                    try {
                        $urlApi = "https://api.dtes.mh.gob.sv/fesv/recepcion/consultadte/";
                        
                        //NOTE: CONSULTA DE DOCUMENTO MH
                        $RestApiC = curl_init();
                        curl_setopt($RestApiC, CURLOPT_URL, $urlApi);
                        curl_setopt($RestApiC, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($RestApiC, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
                        curl_setopt($RestApiC, CURLOPT_HTTPHEADER, array(
                            'Authorization: ' . $this->session->userdata('tokenJson'),
                            'Content-Type:application/json',
                        ));
                        curl_setopt($RestApiC, CURLOPT_POSTFIELDS, json_encode(array(
                            "nitEmisor" => ''.str_replace('-', '', $NIT).'',
                            "tdte" => $cDTE,
                            "codigoGeneracion" => $cGeneracion
                        )));
                        
                        $ResolveC = curl_exec($RestApiC);
                        curl_close($RestApiC);

                        $resultMHC = json_decode($ResolveC, true);

                        //var_dump($resultMHC);
                        
                        if ( isset($resultMHC['estado']) ) {
                            if ($resultMHC['estado'] == 'PROCESADO') {
                                // if ($codAmbiente == '01') {
                                    if ($idTable == 1) {
                                        $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMHC['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMHC), 1, 1, $idYear);
                                    } else {
                                        $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $resultMHC['selloRecibido'], json_encode($fileDteJson), $docJsonFirmado, json_encode($resultMHC));
                                    }

                                // }
                                $msgSuccess = 'Código Generación: '.$resultMHC['codigoGeneracion'].'<br>Sello Recibido: '.$resultMHC['selloRecibido'];
                                echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum, 0, 1);
                            } else {
                                $msgError = preg_replace("/[\r\n|\n|\r]+/", " ", $resultMHC['descripcionMsg']);
    
                                echo $this->sweetAlertError('Error', $msgError);
                            }
                        } else {
                            // var_dump($ResolveC);

                            $msgError = 'Propiedad de respuesta indefinidad';
    
                            echo $this->sweetAlertError('DTE API Presenta Error', $msgError);
                        }
                    } catch(SoapFault $e) {
                        echo "CATCH: " . $e->faultstring;
                    }
                } else {
                    $msgSuccess = 'Código Generación: '.$infoDTE->cgeneracion.'<br>Sello Recibido: '.$infoDTE->srecepcion;
                    echo $this->sweetAlertSuccess('DTE Presentado Correctamente', $msgSuccess, $trannum);
                }
            }
        }

        function eliminarTildes($cadena) {
            $cadena = str_replace(
                array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
                array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
                $cadena
            );

            $cadena = str_replace(
                array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
                array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
                $cadena
            );

            $cadena = str_replace(
                array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
                array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
                $cadena
            );

            $cadena = str_replace(
                array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
                array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
                $cadena
            );

            $cadena = str_replace(
                array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
                array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
                $cadena
            );

            $cadena = str_replace(
                array('ñ', 'Ñ', 'ç', 'Ç'),
                array('n', 'N', 'c', 'C'),
                $cadena
            );

            return $cadena;
        }

        function ventaTicketTemporal($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $this->eliminarTildes($info->direccioncentro);
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NombreComercial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 2));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
            
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontDoubleHeight;

                //$cmds .= $comandosTM->insertarImagenNV('20','20');

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= wordwrap(trim($NombreComercial), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontNormal;
                $cmds .= wordwrap(trim($direccionSuc), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim(strtoupper($namecentro)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(strtoupper($namecaja)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(strtoupper($GIRO)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'COMPROBANTE CONTINGENCIA #'.$info->numero;
                $cmds .= comandosTM::LineFeed;
                
                //$cmds .= wordwrap(trim(strtoupper("CLIENTE: ".$cliente)), 48, comandosTM::LineFeed);
                //$cmds .= comandosTM::LineFeed;

                //if(strlen($cliente)>45){
                    //$cmds .= substr($cliente, 45, 90);
                    //$cmds .= comandosTM::LineFeed;
                //}

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;

                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($pro->descrip);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(1);
                        $cmds .= $comandosTM->padText($pro->idproducto, 7, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($pro->descrip);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(1);
                        $cmds .= $comandosTM->padText($pro->idproducto, 7, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;
                
                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= $comandosTM->pad(10);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $tipoPago = $dtpagos->cajclase;

                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($this->eliminarTildes($info->nameVendedor));
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= comandosTM::FullCut;

                $serverName = $this->session->userdata('server_name');
                if($serverName != 'www.goxpos.com'){
                    $serverName = substr($serverName, 0, -9);
                }

                if($printerName != ''){
                    $datosPrinter = explode('/', $printerName);
                }

                if(count($datosPrinter) > 1){
                    $printerIp = $datosPrinter[0];
                    $this->ventas_model->setCommandsPrint($trannum, $cmds);
                    header('Location: webclientprintvi:http://'.$serverName.'/WebClientPrint/impresion.php?docType=1&tipoImpresion=3&printerIp='.$printerIp.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                    exit;
                }else{
                    $this->ventas_model->setCommandsPrint($trannum, $cmds);
                    header('Location: webclientprintvi:http://'.$serverName.'/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                    exit;
                }
            }
        }

        function recuperacionInfoManualDTE() {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $trannum = $this->input->post('trannum');
                $cDTE = $this->input->post('iddte');
                $idYear = 0;
                $idTable = 0;

                $fecha = new DateTime();

                if ($idTable == 1) {
                    $infoDoc = $this->dte_model->getDatosIvaCentralJSON($trannum, $idYear);
                } else {
                    $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum, $idYear);
                }
                
                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

                if ( $dteSucursal == 0 ) {
                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $nCodGenera  = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                    $codAmbiente = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                } else {
                    $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                    $nCodGenera  = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                    $codAmbiente = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                }

                if ( $cDTE == '01' ) { // Factura Consumidor Final
                    $numControl  = 'DTE-01-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "FCF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == '03' ) { // Comprobante de Credito Fiscal
                    $numControl  = 'DTE-03-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "CCF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == '04' ) { // Nota de Remisión
                    $numControl  = 'DTE-04-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "CD5".$nCodGenera."-3276-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == '05' ) { // Nota de Crédito
                    $numControl  = 'DTE-05-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "C4F".$nCodGenera."-9836-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == '06' ) { // Nota de Debito
                    $numControl  = 'DTE-06-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "DEB".$nCodGenera."-3276-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == '11' ) { // Factura de Exportación
                    $numControl  = 'DTE-11-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "EEF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == 7 ) { // Factura de Exportación
                    $numControl  = 'DTE-07-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->doc_numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "C0C".$nCodGenera."-4368-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == 14 ) { // Factura de Exportación
                    $numControl  = 'DTE-14-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->doc_numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "EEF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);
                }

                echo json_encode(array(
                    'numControl' => $numControl,
                    'cGeneracion' => $cGeneracion,
                ));
            }
        }

        function guardarInformacionRecuperacion() {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $trannum     = $this->input->post('trannum');
                $cDTE        = $this->input->post('iddte');
                $numControl  = $this->input->post('numControl');
                $cGeneracion = $this->input->post('cGeneracion');
                $sRecepcion  = $this->input->post('sRecepcion');
                $idYear      = 0;
                $idTable     = 0;

                $fecha = new DateTime();

                if ($idTable == 1) {
                    $infoDoc = $this->dte_model->getDatosIvaCentralJSON($trannum, $idYear);
                } else {
                    $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum, $idYear);
                }
                
                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

                if ( $dteSucursal == 0 ) {
                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $nCodGenera  = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 4);
                    $codAmbiente = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
                } else {
                    $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$infoDoc->idcentro, 4);
                    $nCodGenera  = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 4);
                    $codAmbiente = $this->global_model->getDatosGeneralesEmp('dte_empdatos_0'.$infoDoc->idcentro, 5);
                }

                if ( $cDTE == '01' ) { // Factura Consumidor Final
                    $infoResJSON = $this->facturaConsumidorFinalDTE($trannum, true);
                } else if ( $cDTE == '03' ) { // Comprobante de Credito Fiscal
                    $infoResJSON = $this->comprobanteCreditoFiscalDTE($trannum, true);
                } else if ( $cDTE == '04' ) { // Nota de Remisión
                    $numControl  = 'DTE-04-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "CD5".$nCodGenera."-3276-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == '05' ) { // Nota de Crédito
                    $infoResJSON = $this->notaDeCreditoDTE($trannum, true);
                } else if ( $cDTE == '06' ) { // Nota de Debito
                    $numControl  = 'DTE-06-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "DEB".$nCodGenera."-3276-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-7".$fecha->format('Y')."8".str_pad($infoDoc->numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == '11' ) { // Factura de Exportación
                    $numControl  = 'DTE-11-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "EEF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == 7 ) { // Factura de Exportación
                    $numControl  = 'DTE-07-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->doc_numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "C0C".$nCodGenera."-4368-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);
                } else if ( $cDTE == 14 ) { // Factura de Exportación
                    $numControl  = 'DTE-14-'.strtoupper($infoDoc->centromh).strtoupper($infoDoc->cajamh).'-'.str_pad($infoDoc->doc_numero, 15, '0', STR_PAD_LEFT);
                    $cGeneracion = "EEF".$nCodGenera."-4268-".str_pad($infoDoc->idcentro, 4, '0', STR_PAD_LEFT)."-".str_pad($infoDoc->idcaja, 4, '0', STR_PAD_LEFT)."-8".$fecha->format('Y')."6".str_pad($infoDoc->doc_numero, 6, '0', STR_PAD_LEFT);
                }

                $fileDteJson    = $infoResJSON['fileDteJson'];
                $docJsonFirmado = $infoResJSON['docJsonFirmado'];

                if ($idTable == 1) {
                    $result = $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $sRecepcion, json_encode($fileDteJson), $docJsonFirmado, '', 1, 1, $idYear);
                } else {
                    $result = $this->dte_model->updateDatosDTE($trannum, $numControl, $cGeneracion, $sRecepcion, json_encode($fileDteJson), $docJsonFirmado, '');
                }

                echo json_encode($result);
            }
        }

        function generarArchivoZip() {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $trannums  = $this->input->post('trannum');
                $tempFiles = [];

                $this->load->model('dev_model');

                $zip = new ZipArchive();
                $zipPath = tempnam(sys_get_temp_dir(), 'dtezip_') . '.zip';

                if ($zip->open($zipPath, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== TRUE) {
                    exit;
                }

                foreach ($trannums as $i => $trannum) {
                    // 1. Generación del PDF
                    $infoPdfPath = $this->creditoFiscalElectronicBills($trannum);

                    if (file_exists($infoPdfPath['path'])) {
                        $zip->addFile($infoPdfPath['path'], utf8_decode($infoPdfPath['name'].".pdf"));
                        $tempFiles[] = $infoPdfPath['path'];
                    }

                    // 2. Generación del JSON
                    $informacion = $this->dev_model->electronicBills($trannum);

                    if (!empty($informacion)) {
                        foreach ($informacion as $info) {
                            $jsonInfo = $info['jsonDoc'];
                            if (!empty($jsonInfo)) {
                                $jsonContent = json_encode($jsonInfo, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
                                $jsonPath = tempnam(sys_get_temp_dir(), 'json_') . '.json';
                                file_put_contents($jsonPath, $jsonContent);
                                $zip->addFile($jsonPath, $infoPdfPath['name'].".json");
                                $tempFiles[] = $jsonPath;
                            }
                        }
                    }
                }

                $zip->close();

                // 3. Descargar ZIP
                header('Content-Type: application/zip');
                header('Content-Disposition: attachment; filename="dte_documentos.zip"');
                header('Content-Length: ' . filesize($zipPath));
                ob_clean();
                flush();
                readfile($zipPath);

                // 4. Limpiar archivos temporales
                unlink($zipPath);
                foreach ($tempFiles as $file) {
                    @unlink($file);
                }

                exit;
            }
        }

        function creditoFiscalElectronicBills($trannum, $idYear = 0, $docToSend = 0){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('dev_model');
                $this->load->model('dte_model');
                $this->load->model('global_model');
                $this->load->model('pedclientes_model');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Documento Tributario Electrónico');
                $pdf->SetSubject('Documento Tributario Electrónico');
                $pdf->SetMargins(7.5, 15, 9, true);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetAutoPageBreak(TRUE, 7);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('helvetica', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                $x = 3;
                $y = 3;

                $informacion = $this->dev_model->electronicBills($trannum, $idYear);

                foreach ($informacion as $info) {
                    $jsonInfo = $info['jsonDoc'];
                    $sRecepcion = $info['sRecepcion'];
                    $respHacienda = $info['respHacienda'];
                    $firmaJson = $info['firmaJson'];
                }

                if (isset($jsonInfo['identificacion'])) $identificacion = $jsonInfo['identificacion'];
                if (isset($jsonInfo['documentoRelacionado'])) $documentoRelacionado = $jsonInfo['documentoRelacionado'];
                if (isset($jsonInfo['emisor'])) $emisor = $jsonInfo['emisor'];
                if (isset($emisor['direccion'])) $direcEmisor = $emisor['direccion'];
                if (isset($jsonInfo['receptor'])) $receptor = $jsonInfo['receptor'];
                if (isset($jsonInfo['sujetoExcluido'])) $sujetoExcluido = $jsonInfo['sujetoExcluido'];
                if (isset($receptor['direccion'])) $direcReceptor = $receptor['direccion'];
                if (isset($sujetoExcluido['direccion'])) $direcRsujetoExcluido = $sujetoExcluido['direccion'];
                if (isset($jsonInfo['ventaTercero'])) $ventaTercero = $jsonInfo['ventaTercero'];
                if (isset($jsonInfo['cuerpoDocumento'])) $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
                if (isset($jsonInfo['resumen'])) $resumen = $jsonInfo['resumen'];
                if (isset($resumen['tributos'])) $tributos  = $resumen['tributos']; else $tributos = array();
                if (isset($jsonInfo['extension'])) $extension = $jsonInfo['extension'];
                if (isset($jsonInfo['apendice'])) $apendice = $jsonInfo['apendice'];
                $tipoDocumento = '';
                $nameVendedor = '';
                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                $infoFact = $this->ventas_model->getDatosFactura($trannum);

                foreach ($infoFact as $info) {
                    $idClase = $info->idclase;
                    $nameSucursal = $info->nameSucursal;
                    $nameVendedor = $info->nameVendedor;
                    $referenciaOT = $info->referencia;
                    $idCliente = (int) $info->idcliente;
                    $idCentro = (int) $info->idcentro;
                    $extension['observaciones'] = $info->notas;
                }

                if ( $dteSucursal == 0 ) {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                    $nameImagen = $this->pedclientes_model->getnameImg();
                } else {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 10);
                    $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0'.$idCentro);
                }

                $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
                $modeloFacturacion = explode(" ", $modFac['descrip']);
                $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
                $tipoTransmision = explode(" ", $tipoTrans['descrip']);
                $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
                $tipoDocumento = $identificacion['tipoDte'];

                $sucursalInfo = $this->sucursal_model->getSucursal($idCentro);

                if ($sucursalInfo != false || $sucursalInfo != null) {
                    if ($sucursalInfo->direccion != '') {
                        $direcEmisor['complemento'] = $sucursalInfo->direccion;
                    }

                    if ($sucursalInfo->telefono != '') {
                        $emisor['telefono'] = $sucursalInfo->telefono;
                    }
                }

                /* --- INICIO SECCION CABECERAS --- */
                $emisorEstab = array();
                if (isset($emisor['tipoEstablecimiento'])) {
                        $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
                }

                if (!isset($emisorEstab['descrip'])) $emisorEstab['descrip'] = '';

                $imgHeader1Hght = '20px';
                if($this->session->userdata('idaccount') == '1937326') {
                    $imgHeader1Hght = '73px';
                }

                if($this->session->userdata('idaccount') == '90476') {
                    $imgHeader1Hght = '15px';
                    if ($idCentro == 2) {
                        $nameImagen = 'BostonLogo.png';
                    }
                }

                $fontSize = '9.5px';
                if($this->session->userdata('idaccount') == '1784550') {
                    $fontSize = '8.5px';
                }

                if($this->session->userdata('idaccount') == '2922210'){
                    $header1 = '
                        <table style="width:100%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height: 25px;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; text-decoration: underline;">'.substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. '.substr($emisor['telefono'].' Sucursal: '.$nameSucursal, 0, 44).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: '.substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: '.substr($emisor['nit'], 0, 19).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: '.substr($emisor['nrc'], 0, 19).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: '.substr($nameVendedor, 0, 40).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: '.$trannum.'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height: 49px;"></td>
                            </tr>';
                        $header1 .= '</table>';
                } else{
                    $header1 = '
                        <table style="width:100%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: '.$imgHeader1Hght.';"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">'.substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$fontSize.'; width:100%;">'.substr(mb_strtoupper($direcEmisor['complemento']), 0, 112).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. '.substr($emisor['telefono'].' Sucursal: '.$nameSucursal, 0, 44).'</td>
                            </tr>';
                            if($this->session->userdata('idaccount') == '2585TIENDAS'){
                                $header1 .=
                                    '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">facturacionelectronica@laiberica.net</td>
                                    </tr>';

                            }else{
                                $header1 .= 
                                    '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                                    </tr>';
                            }
                        $header1 .=
                            '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: '.substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: '.substr($emisor['nit'], 0, 19).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: '.substr($emisor['nrc'], 0, 19).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: '.substr($nameVendedor, 0, 40).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: '.$trannum.'</td>
                            </tr>';
                        $header1 .= '</table>';
                }

                $header2 = '
                    <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['numeroControl'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . $identificacion['version'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($tipoTransmision[array_key_last($tipoTransmision)]) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . date_format(date_create($identificacion['fecEmi']), "d/m/Y") . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . date_format(date_create($identificacion['horEmi']), "h:i:s A") . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

                $nControlP = explode('-', $identificacion['numeroControl']);

                $header2 .= '
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . (int) $nControlP[3] . '</td>
                        </tr>';
                $header2 .= '</table>';

                $qrCode = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                            
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            
                        </td>
                        <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            
                        </td>
                    </tr>
                </table>';

                $qrCode2 = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?data=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D' . $identificacion['ambiente'] . '%26codGen%3D' . $identificacion['codigoGeneracion'] . '%26fechaEmi%3D' . $identificacion['fecEmi'] . '&size=79x79" />
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $identificacion['codigoGeneracion'] . '&size=60x60" />
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $sRecepcion . '&size=60x60" />
                        </td>
                        <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $identificacion['numeroControl'] . '&size=60x60" />
                        </td>
                    </tr>
                </table>';

                if (isset($direcReceptor)) {
                        $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'], $direcReceptor['departamento']);
                        $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
                } else {
                        $receptorMun = array();
                        $receptorDep = array();
                }

                if (isset($direcRsujetoExcluido)) {
                        $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'], $direcRsujetoExcluido['departamento']);
                        $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
                } else {
                        $sujetoExcluidoMun = array();
                        $sujetoExcluidoDep = array();
                }

                $receptorDoc = array();
                if (isset($receptor['tipoDocumento'])) {
                        if ($receptor['tipoDocumento'] != '') {
                                $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'], 'CAT-022');
                        }
                }

                $sujetoExcluidoDoc = array();
                if (isset($sujetoExcluido['tipoDocumento'])) {
                        if ($sujetoExcluido['tipoDocumento'] != '') {
                                $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'], 'CAT-022');
                        }
                }

                if (!isset($receptorDoc['descrip'])) {
                        $receptorDoc['descrip'] = 'Doc. Identificación';
                }

                if (!isset($sujetoExcluidoDoc['descrip'])) {
                        $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
                }

                if (!isset($receptor['nombreComercial'])) {
                        $receptor['nombreComercial'] = '';
                }

                if (!isset($direcReceptor['complemento'])) {
                        $direcReceptor['complemento'] = '';
                }

                if (!isset($direcRsujetoExcluido['complemento'])) {
                        $direcRsujetoExcluido['complemento'] = '';
                }

                if (!isset($receptor['correo'])) {
                        $receptor['correo'] = '';
                }

                $condicionPago = array();
                if (isset($resumen['condicionOperacion'])) {
                        if ($resumen['condicionOperacion'] != '') {
                                $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'], 'CAT-016');
                        }
                } else {
                        $condicionPago['descrip'] = '';
                }

                if (!isset($extension['observaciones'])) {
                        $extension['observaciones'] = '';
                }

                if (!isset($extension['nombEntrega'])) {
                        $extension['nombEntrega'] = '';
                }

                if (!isset($extension['docuEntrega'])) {
                        $extension['docuEntrega'] = '';
                }

                if (!isset($extension['nombRecibe'])) {
                        $extension['nombRecibe'] = '';
                }

                if (!isset($extension['docuRecibe'])) {
                        $extension['docuRecibe'] = '';
                }

                $direcFontSize = '8px';
                
                if (strlen($direcReceptor['complemento']) > 89) {
                    $direcFontSize = '7.5px';
                }

                $ordenString = '';
                if ($this->session->userdata('idaccount') == '291862') {
                    $ordenString = 'Orden:';
                } else {
                    $referenciaOT = '';
                }

                $header3 = '
                    <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">'. $ordenString .'</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.8px; width:16%;">'.trim($referenciaOT).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$direcFontSize.'; width:59%;">' . mb_strtoupper($direcReceptor['complemento'], 'UTF-8') . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                        $header3 .= '
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                        break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">';
                foreach ($receptorDep as $depto) {
                        $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                        break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Moneda:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19) . '</td>
                        </tr>
                </table>';

                $header = '<table style="width:100%; margin:0; padding:0;">
                                <tr>
                                                <td rowspan="2" style="width: 40%;">' . $header1 . '</td>
                                                <td style="margin:0; padding:0; width: 60%;">' . $header2 . '</td>
                                </tr>
                                <tr>
                                                <td style="margin:0; padding:0;">' . $qrCode . '</td>
                                </tr>
                                <tr>
                                                <td colspan="2" style="margin:0; padding:0;">' . $header3 . '</td>
                                </tr>
                </table>';

                //$pdf->setPrintHeader(true);
                //$pdf->setHTMLHeader($header);

                $qrCodeLabel = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <p>Portal de Hacienda</p>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <p>Cód. Generación</p>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <p>Sello Recibido</p>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <p>N° de Control</p>
                        </td>
                    </tr>
                </table>';

                $pdf->SetXY(4.5 + $x, 10.5 + $y);
                $pdf->writeHTML($header, true, false, true, false, '');

                $pdf->SetXY(86.5 + $x, 57 + $y);
                $pdf->writeHTML($qrCodeLabel, true, false, true, false, '');

                /* --- FIN SECCION CABECERAS --- */

                //INICIO CUERPO DE DOCUMENTO CREDITO FISCAL
                /* --- INICIO SECCION PRODUCTOS --- */

                $cantLines = 0;
                $lineasPorProducto = 0;
                foreach($cuerpoDocumento as $body){
                    $lineasPorProducto = ceil(strlen($body['descripcion']) / 57);
                    $cantLines += $lineasPorProducto;
                }

                if ($cantLines <= 40) {
                    $cantPages = 1;
                } elseif ($cantLines > 40 && $cantLines <= 113) {
                    $cantPages = 2;
                } else {
                    $cantPages = (ceil(abs($cantLines - 113) / 65)) + 2;
                }

                $numProd = 0;
                $maxlines = 40;

                $docLines = count($cuerpoDocumento);
                if ($docLines <= 40) {
                    $maxlines = 40;
                } else {
                    if ($docLines > 40 && $docLines <= 113) {
                        if ($docLines <= 44) {
                            $maxlines = 40;
                        } else {
                            $maxlines = 48;
                        }
                    } else if ($docLines > 113) {
                        $maxlines = 48;
                    }
                }

                $stop_index = $maxlines;
                $aux2 = 1;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                //$invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $invexento = 0;
                $vnExenta = 0;
                $vnGravada = 0;
                $numProd = 0; //linea echa para poder visualizar el pdf
                $ivaCesc = 0;
                $cesc = 0;
                $lineasOcupa = 0;
                $totalDesc = 0;
                $discount = 0;

                $bodyDoc = '
                <table style="width:100%; padding:0px;">
                <thead>
                    <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:4.5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No. Item</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5.5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Código</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:46%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:8%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                    </tr>
                </thead>';

                foreach ($productos as $pro) {
                        //if($numProd < $maxlines){
                        /*$ventaNosj = number_format(floatval($body['ventaNoSuj']), 4, '.', ',');
                        $ventaExenta = number_format(floatval($body['ventaExenta']), 4, '.', ',');
                        if($ventaNosj == '0'){
                                        $ventaNosj = '';
                        }
                        if($ventaExenta == '0'){
                                        $ventaExenta = '';
                        }*/

                        if ($pro->tax1 != 0 && $invexento == 0) {
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "";
                                //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                        } else if ($pro->tax1 != 0 && $invexento == 1) {
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                        } else if ($pro->tax1 == 0 && $invexento == 0) {
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                        } else if ($pro->tax1 == 0 && $invexento == 1) {
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                        }

                        $ivaSepa = 1 + ($pro->tax1 / 100);
                        $preciouni = $pro->precioneto;
                        if ($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != "") {
                                $discount =  ($pro->descuento / 100) * $preciouni;
                                $totalDesc += $discount * abs($pro->cantidad);
                        }

                        if ($pro->notas != "") {
                                $notas = strtoupper(trim($pro->notas));
                        } else {
                                $notas = "";
                        }

                        if ($pro->tipo == "4") {
                                $idpro = "";
                                $nombrepro = strtoupper(trim($notas));

                                if ( $nombrepro == '' ) {
                                    $nombrepro = strtoupper(trim($pro->descrip));
                                }
                        } else {
                                $idpro = $pro->idproducto;
                                $nombrepro = strtoupper(trim($pro->descrip)).' '.$notas;
                        }

                        $sumacantidad = (number_format(abs($pro->cantidad), 4, '.', '') - number_format(abs($pro->cantidad), 0, '.', ''));
                        if ($sumacantidad != 0) $cantidadPro = number_format(abs($pro->cantidad), 2, '.', '');
                        else $cantidadPro = number_format(abs($pro->cantidad), 0, '.', '');

                        if ($numProd >= $stop_index) {
                                $breakValue = 'always';
                                $numProd = 0;
                                $aux2++;
                        } else {
                                $breakValue = 'avoid';
                        }

                        $wrapped = wordwrap(trim(mb_strtoupper($nombrepro, 'UTF-8')), 57, '<br>');

                        $bodyDoc .= '<tr style="width:100%; padding:0px; page-break-before: ' . $breakValue . ';">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:4.5%;">' . $pro->itemline . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5.5%;">' . $cantidadPro . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $pro->idproducto . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">' . $wrapped . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($preciouni, 6, '.', '') . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $vnExenta . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $vnGravada . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                        </tr>';

                        if ($aux2 > 1 && $aux2 <= $cantPages) {
                            $stop_index = 65;
                        }

                        $totalDesc = 0;
                        $numProd += ceil(strlen($nombrepro) / 57);
                        //$numProd++;
                        //}
                }

                if ($cantPages > 1) {
                    $maxlines = 65;
                }

                for ($i = $numProd; $i < $maxlines; $i++) {
                    $bodyDoc .= '
                    <tr>
                        <td style="font-size: 9px; text-align:center; width:100%;"></td>
                    </tr>';
                }
                //$bodyDoc .='</table>';

                //$pdf->SetXY( 4.5 + $x, 93.5 + $y );
                //$pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                <table style="width:100%; padding:0px; border: 0.1px solid #000; margin: 0px;">
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%; border-top: 0.1px solid #000;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%; border-top: 0.1px solid #000;">' . trim($resumen['totalLetras']) . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                    </tr>';
                if ($extension['observaciones'] == '') {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                        </tr>';
                } else if (strlen(trim($extension['observaciones'])) <= 86) {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                        </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                        </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                        </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                        </tr>';
                } else {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%; border-bottom: 0.1px solid #000;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                        </tr>';
                }

                $extention .= '
                </table>';

                //$pdf->SetXY( 4.5, 210 );
                //$pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; margin: 0px;">
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total descuentos</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalDescu'], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>';
                foreach ($tributos as $trib) {
                        $totals .= '
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>';

                    $resumen['subTotal'] = floatval($trib["valor"]) + floatval($resumen['subTotal']);
                }
                $totals .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total otros montos no afectos</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%; border-bottom: 0.1px solid #000;">TOTAL A PAGAR</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-bottom: 0.1px solid #000;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                        </tr>
                </table>';

                //$pdf->SetXY( 128.4, 210 );
                //$pdf->writeHTML($totals, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                //$pdf->SetXY( 4.5, 265 );
                //$pdf->writeHTML($message, true, false, true, false, '');

                $bodyDoc .= '
                    <tr style="width:100%; margin: 0px; padding: 0px;">
                        <td style="width:60%; margin: 0px; padding: 0px; text-align: left;">' . $extention . '</td>
                        <td style="width:40%; margin: 0px; padding: 0px; text-align: left;">' . $totals . '</td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:1%; margin: 0px; padding: 0px;"></td>
                        <td style="width:99%; margin: 0px; padding: 0px;">' . $message . '</td>
                    </tr>
                </table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                // FIN CUERPO DE DOCUMENTO CREDITO FISCAL

                /* --- GENERACION DE PDF --- */

                $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'] . '.pdf');
                //$fullpath = $_SERVER['DOCUMENT_ROOT'] . "/" . $nombre_archivo;
                
                $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT']."dte_files", '/') . "/";
                
                if (!is_dir($destinationFolder)) {
                    mkdir($destinationFolder, 0777, true);
                }

                $fullpath = $destinationFolder.$nombre_archivo;

                /*
                *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
                *D: send to the browser and force a file download with the name given by name.
                *F: save to a local server file with the name given by name.
                *S: return the document as a string. name is ignored.
                *FI: equivalent to F + I option
                *FD: equivalent to F + D option
                */

                $pdf->Output($fullpath, 'F');
                
                return array(
                    'name' => $identificacion['codigoGeneracion'],
                    'path' => $fullpath,
                );
            }
        }
    }
?>