<?php if (!defined('BASEPATH'))
    exit('No direct script access allowed');

require 'vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\Label\Label;
use Endroid\QrCode\Logo\Logo;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;

class Dev extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
    }

    function eliminarTildes($cadena)
    {
        $cadena = str_replace(
            array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
            array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
            $cadena
        );

        $cadena = str_replace(
            array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
            array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
            $cadena
        );

        $cadena = str_replace(
            array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
            array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
            $cadena
        );

        $cadena = str_replace(
            array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
            array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
            $cadena
        );

        $cadena = str_replace(
            array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
            array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
            $cadena
        );

        $cadena = str_replace(
            array('ñ', 'Ñ', 'ç', 'Ç'),
            array('n', 'N', 'c', 'C'),
            $cadena
        );

        return $cadena;
    }

    function centimos()
    {
        global $importe_parcial;

        $importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
        if ($importe_parcial > 0) {
            $num_letra = " con " . $this->decena_centimos($importe_parcial);
        } else {
            $num_letra = " 00";
        }
        return $num_letra;
    }

    function unidad_centimos($numero)
    {
        $numero = trim($numero);
        switch ($numero) {
            case 9: {
                $num_letra = "9";
                break;
            }
            case 8: {
                $num_letra = "8";
                break;
            }
            case 7: {
                $num_letra = "7";
                break;
            }
            case 6: {
                $num_letra = "6";
                break;
            }
            case 5: {
                $num_letra = "5";
                break;
            }
            case 4: {
                $num_letra = "4";
                break;
            }
            case 3: {
                $num_letra = "3";
                break;
            }
            case 2: {
                $num_letra = "2";
                break;
            }
            case 1: {
                $num_letra = "1";
                break;
            }
        }
        return $num_letra;
    }

    function decena_centimos($numero)
    {
        $numero = trim($numero);
        if ($numero >= 10) {
            if ($numero >= 90 && $numero <= 99) {
                if ($numero == 90)
                    return "90";
                else if ($numero == 91)
                    return "91";
                else
                    return "9" . $this->unidad_centimos($numero - 90);
            }
            if ($numero >= 80 && $numero <= 89) {
                if ($numero == 80)
                    return "80";
                else if ($numero == 81)
                    return "81";
                else
                    return "8" . $this->unidad_centimos($numero - 80);
            }
            if ($numero >= 70 && $numero <= 79) {
                if ($numero == 70)
                    return "70";
                else if ($numero == 71)
                    return "71";
                else
                    return "7" . $this->unidad_centimos($numero - 70);
            }
            if ($numero >= 60 && $numero <= 69) {
                if ($numero == 60)
                    return "60";
                else if ($numero == 61)
                    return "61";
                else
                    return "6" . $this->unidad_centimos($numero - 60);
            }
            if ($numero >= 50 && $numero <= 59) {
                if ($numero == 50)
                    return "50";
                else if ($numero == 51)
                    return "51";
                else
                    return "5" . $this->unidad_centimos($numero - 50);
            }
            if ($numero >= 40 && $numero <= 49) {
                if ($numero == 40)
                    return "40";
                else if ($numero == 41)
                    return "41";
                else
                    return "4" . $this->unidad_centimos($numero - 40);
            }
            if ($numero >= 30 && $numero <= 39) {
                if ($numero == 30)
                    return "30";
                else if ($numero == 91)
                    return "31";
                else
                    return "3" . $this->unidad_centimos($numero - 30);
            }
            if ($numero >= 20 && $numero <= 29) {
                if ($numero == 20)
                    return "20";
                else if ($numero == 21)
                    return "21";
                else
                    return "2" . $this->unidad_centimos($numero - 20);
            }
            if ($numero >= 10 && $numero <= 19) {
                if ($numero == 10)
                    return "10";
                else if ($numero == 11)
                    return "11";
                else if ($numero == 12)
                    return "12";
                else if ($numero == 13)
                    return "13";
                else if ($numero == 14)
                    return "14";
                else if ($numero == 15)
                    return "15";
                else if ($numero == 16)
                    return "16";
                else if ($numero == 17)
                    return "17";
                else if ($numero == 18)
                    return "18";
                else if ($numero == 19)
                    return "19";
            }
        } else {
            return $this->unidad_centimos($numero);
        }
    }

    function unidad($numero)
    {
        $numero = trim($numero);
        switch ($numero) {
            case 9: {
                $num = "nueve";
                break;
            }
            case 8: {
                $num = "ocho";
                break;
            }
            case 7: {
                $num = "siete";
                break;
            }
            case 6: {
                $num = "seis";
                break;
            }
            case 5: {
                $num = "cinco";
                break;
            }
            case 4: {
                $num = "cuatro";
                break;
            }
            case 3: {
                $num = "tres";
                break;
            }
            case 2: {
                $num = "dos";
                break;
            }
            case 1: {
                $num = "uno";
                break;
            }
        }
        return $num;
    }

    function decena($numero)
    {
        $numero = trim($numero);

        if ($numero >= 90 && $numero <= 99) {
            $num_letra = "noventa ";

            if ($numero > 90)
                $num_letra = $num_letra . "y " . $this->unidad($numero - 90);
        } else if ($numero >= 80 && $numero <= 89) {
            $num_letra = "ochenta ";

            if ($numero > 80)
                $num_letra = $num_letra . "y " . $this->unidad($numero - 80);
        } else if ($numero >= 70 && $numero <= 79) {
            $num_letra = "setenta ";

            if ($numero > 70)
                $num_letra = $num_letra . "y " . $this->unidad($numero - 70);
        } else if ($numero >= 60 && $numero <= 69) {
            $num_letra = "sesenta ";

            if ($numero > 60)
                $num_letra = $num_letra . "y " . $this->unidad($numero - 60);
        } else if ($numero >= 50 && $numero <= 59) {
            $num_letra = "cincuenta ";

            if ($numero > 50)
                $num_letra = $num_letra . "y " . $this->unidad($numero - 50);
        } else if ($numero >= 40 && $numero <= 49) {
            $num_letra = "cuarenta ";

            if ($numero > 40)
                $num_letra = $num_letra . "y " . $this->unidad($numero - 40);
        } else if ($numero >= 30 && $numero <= 39) {
            $num_letra = "treinta ";

            if ($numero > 30)
                $num_letra = $num_letra . "y " . $this->unidad($numero - 30);
        } else if ($numero >= 20 && $numero <= 29) {
            if ($numero == 20)
                $num_letra = "veinte ";
            else
                $num_letra = "veinti" . $this->unidad($numero - 20);
        } else if ($numero >= 10 && $numero <= 19) {
            switch ($numero) {
                case 10: {
                    $num_letra = "diez ";
                    break;
                }
                case 11: {
                    $num_letra = "once ";
                    break;
                }
                case 12: {
                    $num_letra = "doce ";
                    break;
                }
                case 13: {
                    $num_letra = "trece ";
                    break;
                }
                case 14: {
                    $num_letra = "catorce ";
                    break;
                }
                case 15: {
                    $num_letra = "quince ";
                    break;
                }
                case 16: {
                    $num_letra = "dieciseis ";
                    break;
                }
                case 17: {
                    $num_letra = "diecisiete ";
                    break;
                }
                case 18: {
                    $num_letra = "dieciocho ";
                    break;
                }
                case 19: {
                    $num_letra = "diecinueve ";
                    break;
                }
            }
        } else {
            $num_letra = $this->unidad($numero);
        }

        return $num_letra;
    }

    function centena($numero)
    {
        $numero = trim($numero);
        if ($numero >= 100) {
            if ($numero >= 900 & $numero <= 999) {
                $num_letra = "novecientos ";

                if ($numero > 900)
                    $num_letra = $num_letra . $this->decena($numero - 900);
            } else if ($numero >= 800 && $numero <= 899) {
                $num_letra = "ochocientos ";

                if ($numero > 800)
                    $num_letra = $num_letra . $this->decena($numero - 800);
            } else if ($numero >= 700 && $numero <= 799) {
                $num_letra = "setecientos ";

                if ($numero > 700)
                    $num_letra = $num_letra . $this->decena($numero - 700);
            } else if ($numero >= 600 && $numero <= 699) {
                $num_letra = "seiscientos ";

                if ($numero > 600)
                    $num_letra = $num_letra . $this->decena($numero - 600);
            } else if ($numero >= 500 && $numero <= 599) {
                $num_letra = "quinientos ";

                if ($numero > 500)
                    $num_letra = $num_letra . $this->decena($numero - 500);
            } else if ($numero >= 400 && $numero <= 499) {
                $num_letra = "cuatrocientos ";

                if ($numero > 400)
                    $num_letra = $num_letra . $this->decena($numero - 400);
            } else if ($numero >= 300 && $numero <= 399) {
                $num_letra = "trescientos ";

                if ($numero > 300)
                    $num_letra = $num_letra . $this->decena($numero - 300);
            } else if ($numero >= 200 && $numero <= 299) {
                $num_letra = "doscientos ";

                if ($numero > 200)
                    $num_letra = $num_letra . $this->decena($numero - 200);
            } else if ($numero >= 100 && $numero <= 199) {
                if ($numero == 100)
                    $num_letra = "cien ";
                else
                    $num_letra = "ciento " . $this->decena($numero - 100);
            }
        } else {
            $num_letra = $this->decena($numero);
        }

        return $num_letra;
    }

    function cien()
    {
        global $importe_parcial;

        $parcial = 0;
        $car = 0;

        while (substr($importe_parcial, 0, 1) == 0)
            $importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

        if ($importe_parcial >= 1 && $importe_parcial <= 9.99)
            $car = 1;
        else if ($importe_parcial >= 10 && $importe_parcial <= 99.99)
            $car = 2;
        else if ($importe_parcial >= 100 && $importe_parcial <= 999.99)
            $car = 3;

        $parcial = substr($importe_parcial, 0, $car);
        $importe_parcial = substr($importe_parcial, $car);

        $num_letra = $this->centena($parcial) . $this->centimos();

        return $num_letra;
    }

    function cien_mil()
    {
        global $importe_parcial;

        $parcial = 0;
        $car = 0;

        while (substr($importe_parcial, 0, 1) == 0)
            $importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

        if ($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
            $car = 1;
        else if ($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
            $car = 2;
        else if ($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
            $car = 3;

        $parcial = substr($importe_parcial, 0, $car);
        $importe_parcial = substr($importe_parcial, $car);

        if ($parcial > 0) {
            if ($parcial == 1)
                $num_letra = "mil ";
            else
                $num_letra = $this->centena($parcial) . " mil ";
        }

        return $num_letra;
    }

    function millon()
    {
        global $importe_parcial;

        $parcial = 0;
        $car = 0;

        while (substr($importe_parcial, 0, 1) == 0)
            $importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

        if ($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
            $car = 1;
        else if ($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
            $car = 2;
        else if ($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
            $car = 3;

        $parcial = substr($importe_parcial, 0, $car);
        $importe_parcial = substr($importe_parcial, $car);

        if ($parcial == 1)
            $num_letras = "un millón ";
        else
            $num_letras = $this->centena($parcial) . " millones ";

        return $num_letras;
    }

    function convertir_a_letras($numero)
    {
        global $importe_parcial;

        $numero = trim($numero);

        $importe_parcial = $numero;

        if ($numero < 1000000000) {
            if ($numero >= 1000000 && $numero <= 999999999.99)
                $num_letras = $this->millon() . $this->cien_mil() . $this->cien();
            else if ($numero >= 1000 && $numero <= 999999.99)
                $num_letras = $this->cien_mil() . $this->cien();
            else if ($numero >= 1 && $numero <= 999.99)
                $num_letras = $this->cien();
            else if ($numero >= 0.01 && $numero <= 0.99) {
                if ($numero == 0.01)
                    $num_letras = "un céntimo";
                else
                    $num_letras = $this->convertir_a_letras(($numero * 100) . "/100") . " centavos";
            }
        }
        return $num_letras;
    }
    private function validatePermiso()
    {
        $permiso = true;
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || !$permiso)
            redirect('CerrarSesion');
        else
            return true;
    }
    function console_log($data)
    {
        echo '<script>';
        echo 'console.log(' . json_encode($data) . ')';
        echo '</script>';
    }
    function highlight_array($array, $name = 'var')
    {
        highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
    }

    #------------------------------------------------------------------------  IMPORTAR PRODUCTOS ----------------------------------------------------------------------------------
    public function importarProductos($idApp)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $controlador = $this->uri->segment(1);
            $idApp = $this->uri->segment(2);

            $this->load->model('configuracion_model');
            $result = $this->configuracion_model->confirmarAccesoApp($idApp);
            $result == true ?: redirect('CerrarSesion');
            $opcionmenu = $this->configuracion_model->getProCentro($idApp);

            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
            $this->data['OTipo'] = $opcionmenu;
            //*/
            $this->load->view('mantenimiento_ImportProductos', $this->data);
        }
    }
    #   IMPORTAR EXCEL PARA HOJAS
    public function getsheets()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
            //  Read your Excel workbook
            try {
                $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $Excel = $objReader->load($_FILES['file']['tmp_name']);
            } catch (Exception $e) {
                die('Error loading file "' . pathinfo($_FILES['file']['tmp_name'], PATHINFO_BASENAME) . '": ' . $e->getMessage());
            }
            $Hojas = $Excel->getSheetNames();
            $Datos = [];
            foreach ($Hojas as $key => $dato) {
                $Datos[] = array(
                    'ID' => $key,
                    'Name' => $dato
                );
            }
            $datA[] = array('valido' => true, 'datos' => $Datos);
            echo json_encode($datA);
        }
    }
    #   GET ESTRUCTURA EXCEL Y TABLA
    public function getEstructura()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $hoja = (int) $this->input->post('hoja');
            require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
            //  Read your Excel workbook
            try {
                $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $Excel = $objReader->load($_FILES['file']['tmp_name']);
            } catch (Exception $e) {
                die('Error loading file "' . pathinfo($_FILES['file']['tmp_name'], PATHINFO_BASENAME) . '": ' . $e->getMessage());
            }
            //  Get worksheet dimensions
            $Excel->setActiveSheetIndex($hoja);
            $sheet = $Excel->setActiveSheetIndex($hoja);
            $highestRow = $sheet->getHighestRow();
            $highestColumn = $sheet->getHighestColumn();
            $Datos = [];
            $EstructuraT[] = array(
                'ID' => -1,
                'Name' => '',
                'permisollave' => false
            );
            if ($highestRow >= 2) {
                $Columnas = null;
                for ($row = 1; $row <= 1; $row++) {
                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
                    $Columnas = $rowData[0];
                }
                if (count($Columnas) > 4) {
                    $this->load->model('dev_model');
                    $estructura = $this->dev_model->getSheets();//*/
                    $Last = 0;
                    foreach ($estructura as $key => $dato) {
                        $columna = (($key + 1) <= count($Columnas)) ? $Columnas[$key] : '';
                        //$llave = (strpos(strtolower($dato->name), 'id') !== false) ? true : false;
                        $Datos[] = array(
                            'columna' => $columna,
                            'idcolumnaT' => $key,
                            'columnaT' => $dato->name,
                            'llave' => ($key == 0) ? true : false,
                        );
                        $EstructuraT[] = array(
                            'ID' => $key,
                            'Name' => $dato->name,
                            'permisollave' => (($dato->name == 'idproducto') || ($dato->name == 'barcode') || ($dato->name == 'xpos') || ($dato->name == 'modelo')) ? true : false
                        );
                        $Last = $key + 1;
                    }
                    if ($Last < count($Columnas)) {
                        for ($i = $Last; $i < count($Columnas); $i++) {
                            $Datos[] = array(
                                'columna' => $Columnas[$i],
                                'idcolumnaT' => -1,
                                'columnaT' => '',
                                'llave' => false,
                            );
                        }
                    }
                    $EstructuraT[] = array(
                        'ID' => count($EstructuraT) - 1,
                        'Name' => '--Múltiples Barras--',
                        'permisollave' => false,
                    );
                    $EstructuraT[] = array(
                        'ID' => count($EstructuraT) - 1,
                        'Name' => '--Múltiples Precios--',
                        'permisollave' => false,
                    );
                    $datA[] = array('valido' => true, 'datos' => $Datos, 'backu' => $Datos, 'estructura' => $EstructuraT);
                } else
                    $datA[] = array('valido' => false, 'tipo' => 0);
            } else
                $datA[] = array('valido' => false, 'tipo' => 1);

            echo json_encode($datA);//*/
        }
    }
    #   LECTURA DE CONFIGURACION VALIDACION
    public function validateIProductos()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $this->load->model('dev_model');
            require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
            //  Read your Excel workbook
            try {
                $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $Excel = $objReader->load($_FILES['file']['tmp_name']);
            } catch (Exception $e) {
                die('Error loading file "' . pathinfo($_FILES['file']['tmp_name'], PATHINFO_BASENAME) . '": ' . $e->getMessage());
            }
            $hoja = (int) $this->input->post('hoja');
            $idllave = (int) $this->input->post('llave');
            $llave = '';
            $config = $this->input->post('config');
            $OTipo = (int) $this->input->post('OTipo');

            #
            $CBarcode = false;
            $CBarras = false;
            $CPrecios = false;
            //  Get worksheet dimensions
            $Excel->setActiveSheetIndex($hoja);
            $sheet = $Excel->setActiveSheetIndex($hoja);
            $highestRow = $sheet->getHighestRow();
            $highestColumn = $sheet->getHighestColumn();
            #   GET LLAVE
            $EstructuraT = [];
            $EstructuraUsar = [];
            $estructura = $this->dev_model->getSheets();
            foreach ($estructura as $key => $dato) {
                $dato->id = $key;
                $EstructuraT[] = $dato;
                if ($key == $idllave) {
                    $llave = $dato->name;
                }
            }
            //print_r($estructura);
            #   GET ESTRUCTURA A USAR
            $conteoRequerido = 0;
            foreach (explode(';', $config) as $valor) {
                $dato = explode('-', $valor);
                //0-0
                $campo = '';
                $tipo = 'text';
                foreach ($estructura as $value) {
                    if ($value->id == $dato[1]) {
                        $campo = $value->name;
                        $tipo = $value->type;
                        break;
                    }
                }
                if (
                    (strtolower($campo) == 'idproducto') ||
                    (strtolower($campo) == 'descrip') ||
                    (strtolower($campo) == 'idcatalogo') ||
                    (strtolower($campo) == 'tipotax')
                ) {
                    $conteoRequerido++;
                }

                if ($dato[1] == count($estructura))
                    $campo = 'barras';
                else if ($dato[1] == (count($estructura) + 1))
                    $campo = 'precios';

                if (
                    ($campo == 'barcode') ||
                    ($campo == 'barras') ||
                    ($campo == 'precios')
                ) {
                    switch ($campo) {
                        case 'barcode':
                            $CBarcode = true;
                            break;
                        case 'barras':
                            $CBarras = true;
                            break;
                        case 'precios':
                            $CPrecios = true;
                            break;
                    }
                }

                $EstructuraUsar[] = array(
                    'IDExcel' => $dato[0],
                    'IDTabla' => $dato[1],
                    'campo' => $campo,
                    'tipo' => $tipo
                );
            }
            //print_r($EstructuraUsar);
            $Headers = [];
            $Datos = [];
            if ($conteoRequerido == 4) {
                #   GET HEADERS PARA GRID
                $Headers[] = array(
                    'dataField' => 'estado',
                    'caption' => 'Estado',
                    'datatype' => 'string',
                    'format' => '',
                    'aligment' => 'center',
                );
                for ($row = 1; $row <= 1; $row++) {
                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
                    foreach ($EstructuraUsar as $value) {
                        $formato = '';
                        switch ($value['tipo']) {
                            case 'int':
                            case 'double':
                            case 'float':
                                $tipo = 'number';
                                if ($value['tipo'] != 'int')
                                    $formato = '#,##0.00';
                                break;
                            case 'varchar':
                            case 'text':
                                $tipo = 'string';
                                break;
                            case 'date':
                                $tipo = 'date';
                                $formato = 'dd/MM/yyyy';
                                break;
                            case 'datetime':
                                $tipo = 'datetime';
                                $formato = 'dd/MM/yyyy hh:mm:ss';
                                break;
                        }
                        $Headers[] = array(
                            'dataField' => $value['campo'],
                            'caption' => (($value['campo'] == $llave) ? '[Key] ' : '') . $rowData[0][$value['IDExcel']],
                            'datatype' => $tipo,
                            'format' => $formato,
                            'alignment' => ($tipo == 'string') ? 'left' : 'center',
                        );//*/
                    }
                }
                #-
                #   VALIDACION DATOS PRINCIPAL (GENERAL)
                $Cabezeras = $sheet->rangeToArray('A' . 1 . ':' . $highestColumn . 1, NULL, TRUE, FALSE);
                $CountError = 0;
                $Llaves = [];
                for ($row = 2; $row <= $highestRow; $row++) {
                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
                    $Registro = [];
                    $error = [];
                    $Tipo = null;
                    $Catalogo = null;
                    $TCValido = true;
                    $PEstado = 'Nuevo';
                    $VProducto = null;
                    $VLLaves = [
                        //  MODELO
                        array(
                            'ce' => false,
                            'vactual' => '',
                            'pose' => 0
                        ),
                        //  XPOS
                        array(
                            'ce' => false,
                            'vactual' => '',
                            'pose' => 0
                        ),
                        //  BARCODE
                        array(
                            'ce' => false,
                            'vactual' => '',
                            'pose' => 0
                        )
                    ];

                    foreach ($EstructuraUsar as $valor) {
                        $valorActual = $rowData[0][$valor['IDExcel']];
                        if ($valor['campo'] == $llave) {
                            $Llaves[] = trim($valorActual);
                        }
                        switch ($valor['tipo']) {
                            case 'int':
                                if (!is_numeric($valorActual)) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo debe ser númerico';
                                } else {
                                    if ((int) $valorActual < 0) {
                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo debe ser mayor o igual a 0';
                                    } else {
                                        if (
                                            ($valor['campo'] == 'idcatalogo') ||
                                            ($valor['campo'] == 'idprovee') ||
                                            ($valor['campo'] == 'tipo') ||
                                            ($valor['campo'] == 'tipotax') ||
                                            ($valor['campo'] == 'idproducto')
                                        ) {
                                            switch ($valor['campo']) {
                                                case 'idcatalogo':
                                                    if ((int) $valorActual == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede ser valor 0';
                                                    } else {
                                                        $Catalogo = $this->dev_model->existeLineaID((int) $valorActual);
                                                        if (!$Catalogo) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-No existe esa Línea';
                                                            $TCValido = false;
                                                        } else {
                                                            if ($Catalogo->estado != 1) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-No se puede Agregar o Actualizar Producto a una Línea Inactiva';
                                                            }
                                                        }
                                                    }
                                                    break;
                                                case 'idprovee':
                                                    if ((int) $valorActual > 0) {
                                                        $VProveedor = $this->dev_model->existeProveedorID((int) $valorActual);
                                                        if (!$VProveedor) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-No existe ese Proveedor';
                                                        }
                                                    }
                                                    break;
                                                /*case 'tipo':
                                                    if ((int)$valorActual == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede tener valor 0';
                                                    } else {
                                                        //$Tipo = $valorActual;
                                                        $Tipo = $OTipo;
                                                        $VTipo = $this->dev_model->existeTProducto((int)$valorActual);
                                                        if (!$VTipo) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-No existe ese Tipo de Producto';
                                                            $TCValido = false;
                                                        }
                                                    }
                                                break;//*/
                                                case 'tipotax':
                                                    if ((int) $valorActual == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede tener valor 0';
                                                    } else {
                                                        $VtipoTax = $this->dev_model->existeTTax((int) $valorActual);
                                                        if (!$VtipoTax) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-No existe ese Tipo de Tax (Impuesto)';
                                                        }
                                                    }
                                                    break;
                                                case 'idproducto':
                                                    if ((int) $valorActual == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede tener valor 0';
                                                    } else {
                                                        $VProducto = $this->dev_model->existeProductoID((int) $valorActual);
                                                        //print_r($VProducto);
                                                        if ($VProducto != false)
                                                            $PEstado = 'Actualizar';
                                                    }
                                                    break;
                                            }
                                        }
                                    }
                                }
                                break;
                            case 'varchar':
                            case 'text':
                                if (strpos($valorActual, '"') != false) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede llevar comilla doble';
                                } else if (strpos($valorActual, "'") != false) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede llevar comilla simple';
                                } else if (strpos($valorActual, '\\') != false) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede llevar pleca invertida';
                                } else if (strpos($valorActual, "<") != false) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede llevar signo <';
                                } else if (strpos($valorActual, ">") != false) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede llevar signo >';
                                } else {
                                    if (
                                        ($valor['campo'] == 'modelo') ||
                                        ($valor['campo'] == 'barcode') ||
                                        ($valor['campo'] == 'xpos') ||
                                        ($valor['campo'] == 'barras') ||
                                        ($valor['campo'] == 'precios')
                                    ) {
                                        switch ($valor['campo']) {
                                            case 'barcode':
                                                if ($llave == 'barcode') {
                                                    if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código Barra no puede ser vacio y llave al mismo tiempo';
                                                    } else {
                                                        $valorbar = preg_match("/^([0-9a-zA-Z])+$/", $valorActual);
                                                        if (!$valorbar) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código de Barra debe ser alfanumérico';
                                                        } else {
                                                            $VBarcode = $this->dev_model->existeProductoBarcode(trim($valorActual));
                                                            if ($VBarcode) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código Barra ya esta regisrado para otro producto';
                                                                $VLLaves[2] = array(
                                                                    'ce' => true,
                                                                    'vactual' => trim($valorActual),
                                                                    'pose' => count($error) - 1
                                                                );
                                                            }
                                                        }
                                                    }
                                                } else {
                                                    if ($valorActual != null && strlen($valorActual) > 0) {
                                                        $valorbar = preg_match("/^([0-9a-zA-Z])+$/", $valorActual);
                                                        if (!$valorbar) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código de Barra debe ser alfanumérico';
                                                        } else {
                                                            $VBarcode = $this->dev_model->existeProductoBarcode(trim($valorActual));
                                                            if ($VBarcode) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código Barra ya esta regisrado para otro producto';
                                                                $VLLaves[2] = array(
                                                                    'ce' => true,
                                                                    'vactual' => trim($valorActual),
                                                                    'pose' => count($error) - 1
                                                                );
                                                            }
                                                        }
                                                    }
                                                }
                                                break;
                                            case 'modelo':
                                                if ($llave == 'modelo') {
                                                    if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Modelo no puede ser vacio y llave al mismo tiempo';
                                                    } else {
                                                        $VModelo = $this->dev_model->existeProductoModelo(trim($valorActual));
                                                        if ($VModelo) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Modelo ya esta regisrado para otro producto';
                                                            $VLLaves[0] = array(
                                                                'ce' => true,
                                                                'vactual' => trim($valorActual),
                                                                'pose' => count($error) - 1
                                                            );
                                                        }
                                                    }
                                                }
                                                break;
                                            case 'xpos':
                                                if ($llave == 'xpos') {
                                                    if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-XPOS no puede ser vacio y llave al mismo tiempo';
                                                    } else {
                                                        $VModelo = $this->dev_model->existeProductoModelo(trim($valorActual));
                                                        if ($VModelo) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-XPOS ya esta regisrado para otro producto';
                                                            $VLLaves[1] = array(
                                                                'ce' => true,
                                                                'vactual' => trim($valorActual),
                                                                'pose' => count($error) - 1
                                                            );
                                                        }
                                                    }
                                                }
                                                break;
                                            case 'barras':
                                                if ($valorActual != null && strlen($valorActual) > 0) {
                                                    foreach (explode(';', $valorActual) as $key => $value) {
                                                        $valorbar = preg_match("/^([0-9a-zA-Z])+$/", $value);
                                                        if (!$valorbar) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Pos.[' . $key . '] Código de barra debe ser alfanumérico';
                                                        } else {
                                                            $VBarcode = $this->dev_model->existeProductoBarcode(trim($value));
                                                            if ($VBarcode) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código Multi Barra [' . $key . '] ya esta regisrado para otro producto';
                                                            }
                                                        }
                                                    }
                                                }
                                                break;
                                            case 'precios':
                                                if ($valorActual != null && strlen($valorActual) > 0) {
                                                    foreach (explode(';', $valorActual) as $key => $dprecio) {
                                                        $dprecio = explode(',', $dprecio);
                                                        if (count($dprecio) != 5) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] parámetros incompletos';
                                                        } else {
                                                            #   VALIDAR DESCRIPCION DE MULTI PRECIO
                                                            if (($dprecio[0] == null) || (strlen(trim($dprecio[0])) == 0)) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Descripción es requerida';
                                                            }
                                                            #   VALIDAR PRECIO DE MULTI PRECIO
                                                            if (!is_numeric($dprecio[1])) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Precio debe ser valor numérico';
                                                            } else {
                                                                if ((float) $dprecio[1] <= 0) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Precio debe ser mayor que 0';
                                                                }
                                                            }
                                                            #   VALIDAR UNDIAD DE MULTI PRECIO
                                                            if (!is_numeric($dprecio[2])) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Unidad de Conversión debe ser valor numérico';
                                                            } else {
                                                                if ((float) $dprecio[2] <= 0) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Unidad de Conversión debe ser mayor que 0';
                                                                }
                                                            }
                                                            #   VALIDAR MIN DE MULTI PRECIO
                                                            if (!is_numeric($dprecio[3])) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Valor Mínimo debe ser valor numérico';
                                                            } else {
                                                                if ((float) $dprecio[3] <= 0) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Valor Mínimo debe ser mayor que 0';
                                                                }
                                                            }
                                                            #   VALIDAR MAX DE MULTI PRECIO
                                                            if (!is_numeric($dprecio[4])) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Valor Máximo debe ser valor numérico';
                                                            } else {
                                                                if ((float) $dprecio[4] <= 0) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Valor Máximo debe ser mayor que 0';
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                break;
                                        }
                                    }
                                }
                                break;
                            case 'double':
                            case 'float':
                                $valorfd = preg_match("/^([0-9])+(\.[0-9]+)?$/", $valorActual);
                                if (!$valorfd) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo debe ser númerico';
                                } else {
                                    if ((float) $valorActual < 0) {
                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo debe ser mayor o igual a 0';
                                    }
                                }
                                break;
                                break;
                            case 'datetime':
                                break;
                            case 'date':
                                break;
                        }
                        $Registro[$valor['campo']] = $valorActual;
                    }
                    $Tipo = $OTipo;
                    if (
                        ($TCValido) && ($Catalogo != null) &&
                        ($Catalogo != false) && ($Tipo != null)
                    ) {
                        if ((int) $Tipo != (int) $Catalogo->tipo) {
                            $error[] = 'Tipo de Producto del Producto y Tipo de Producto de la Línea, no coinciden';
                        }
                    }
                    if ($PEstado == 'Actualizar') {
                        if ($VLLaves[0]['ce'] == true && $llave == 'modelo') {
                            if ($VProducto->modelo == $VLLaves[0]['vactual']) {
                                unset($error[$VLLaves[0]['pose']]);
                            }
                        }
                        if ($VLLaves[1]['ce'] == true && $llave == 'xpos') {
                            if ($VProducto->xpos == $VLLaves[1]['vactual']) {
                                unset($error[$VLLaves[1]['pose']]);
                            }
                        }
                        if ($VLLaves[2]['ce'] == true) {
                            if ($VProducto->barcode == $VLLaves[2]['vactual']) {
                                unset($error[$VLLaves[2]['pose']]);
                            }
                        }
                    }
                    $Registro['estado'] = $PEstado;
                    $Registro['line'] = $row;
                    $Registro['error'] = implode(';', $error);
                    $Registro['cerror'] = (count($error) > 0) ? true : false;
                    if (count($error) > 0)
                        $CountError++;
                    $Datos[] = $Registro;
                }
                #   VALIDACION DATOS SECUNDARIA (LLAVE)
                if ($CountError == 0) {
                    if (count($Datos) > 0) {
                        #   GET IDS - BARCODES - MUMTI PRECIOS
                        $IDS = [];
                        $Barcodes = [];
                        $Precios = [];
                        foreach ($Datos as $valor) {
                            $IDS[] = trim($valor['idproducto']);
                            if ($valor['estado'] != 'Nuevo') {
                            }
                            if ($CBarcode || $CBarras || $CPrecios) {
                                if ($CBarcode) {
                                    if ($valor['barcode'] != null && strlen($valor['barcode']) > 0) {
                                        $Barcodes[] = 'line-' . $valor['line'] . '-' . $valor['barcode'];
                                    }
                                }
                                if ($CBarras) {
                                    if ($valor['barras'] != null && strlen($valor['barras']) > 0) {
                                        foreach (explode(';', $valor['barras']) as $key => $value) {
                                            $Barcodes[] = 'multi-' . $key . '-' . $valor['line'] . '-' . $value;
                                        }
                                    }
                                }
                                if ($CPrecios) {
                                    if ($valor['precios'] != null && strlen(trim($valor['precios'])) > 0) {
                                        foreach (explode(';', $valor['precios']) as $key => $value) {
                                            $vprecio = explode(',', $value);
                                            $Precios[] = $key . '-' . $valor['line'] . '-' . $vprecio[0];
                                        }
                                    }
                                }
                            }
                        }
                        //print_r($Precios);
                        #   VALIDACION SEGUNDO GRADO
                        $DatosB = [];
                        foreach ($Datos as $valor) {
                            #   VALIDAR IDS REPETIDOS
                            $conteoRepetido = 0;
                            foreach ($IDS as $ID) {
                                if ($ID == $valor['idproducto']) {
                                    $conteoRepetido++;
                                }
                            }
                            if ($conteoRepetido > 1) {
                                $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                $error[] = 'Código de Producto repetido';
                                $valor['error'] = implode(';', $error);
                                $valor['cerror'] = (count($error) > 0) ? true : false;
                                if (count($error) > 0)
                                    $CountError++;
                            }
                            if ($valor['estado'] != 'Nuevo') {
                            }
                            #   VALIDACION MODDELOS XPOS BARCODES
                            $conteoRepetido = 0;
                            switch ($llave) {
                                case 'modelo':
                                    foreach ($Llaves as $valorllave) {
                                        if ($valorllave == $valor['modelo']) {
                                            $conteoRepetido++;
                                        }
                                    }
                                    if ($conteoRepetido > 1) {
                                        $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                        $error[] = 'Modelo viene repetido';
                                        $valor['error'] = implode(';', $error);
                                        $valor['cerror'] = (count($error) > 0) ? true : false;
                                        if (count($error) > 0)
                                            $CountError++;
                                    }
                                    break;
                                case 'xpos':
                                    foreach ($Llaves as $valorllave) {
                                        if ($valorllave == $valor['xpos']) {
                                            $conteoRepetido++;
                                        }
                                    }
                                    if ($conteoRepetido > 1) {
                                        $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                        $error[] = 'Xpos viene repetido';
                                        $valor['error'] = implode(';', $error);
                                        $valor['cerror'] = (count($error) > 0) ? true : false;
                                        if (count($error) > 0)
                                            $CountError++;
                                    }
                                    break;
                            }
                            if ($CBarcode || $CBarras || $CPrecios) {
                                if ($CBarcode) {
                                    if ($valor['barcode'] != null && strlen($valor['barcode']) > 0) {
                                        foreach ($Barcodes as $key => $value) {
                                            $valores = explode('-', $value);
                                            $ubicaicon = ($valores[0] == 'line') ? (' en la línea ' . $valores[1]) : (' en la línea ' . $valores[2] . ' en múltiple barra [' . $valores[1] . ']');
                                            $valueBar = $valores[count($valores) - 1];
                                            if ($valueBar == $valor['barcode']) {
                                                if (($valores[0] == 'line') && ($valores[1] == $valor['line'])) {
                                                } else {
                                                    $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                    $error[] = 'Código de Barra repetido' . $ubicaicon;
                                                    $valor['error'] = implode(';', $error);
                                                    $valor['cerror'] = (count($error) > 0) ? true : false;
                                                    if (count($error) > 0)
                                                        $CountError++;//*/
                                                }
                                            }
                                        }
                                    }
                                }
                                if ($CBarras) {
                                    if ($valor['barras'] != null && strlen($valor['barras']) > 0) {
                                        foreach (explode(';', $valor['barras']) as $pos => $mbarra) {
                                            foreach ($Barcodes as $key => $value) {
                                                $valores = explode('-', $value);
                                                $ubicaicon = ($valores[0] == 'line') ? (' en la línea ' . $valores[1]) : (' en la línea ' . $valores[2] . ' en múltiple barra [' . $valores[1] . ']');
                                                $valueBar = $valores[count($valores) - 1];
                                                if ($valueBar == $mbarra) {
                                                    if (($valores[0] == 'multi') && ($valores[1] == $pos) && ($valores[2] == $valor['line'])) {
                                                    } else {
                                                        $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                        $error[] = 'Código de Multi Barra[' . $pos . '] repetido' . $ubicaicon;
                                                        $valor['error'] = implode(';', $error);
                                                        $valor['cerror'] = (count($error) > 0) ? true : false;
                                                        if (count($error) > 0)
                                                            $CountError++;//*/
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                if ($CPrecios) {
                                    if ($valor['precios'] != null && strlen(trim($valor['precios'])) > 0) {
                                        foreach (explode(';', $valor['precios']) as $pos => $value) {
                                            $valorPrecio = explode(',', $value);
                                            foreach ($Precios as $Dprecio) {
                                                $valores = explode('-', $Dprecio);
                                                if ($valores[1] == $valor['line']) {
                                                    if ($valores[0] != $pos) {
                                                        $descripPrecio = $valores[2];
                                                        $ubicacion = ' en multi precio [' . $valores[0] . ']';
                                                        if ($descripPrecio == $valorPrecio[0]) {
                                                            $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                            $error[] = 'Multi Precio [' . $pos . '] Descripción repetida ' . $ubicacion;
                                                            $valor['error'] = implode(';', $error);
                                                            $valor['cerror'] = (count($error) > 0) ? true : false;
                                                            if (count($error) > 0)
                                                                $CountError++;
                                                        }
                                                    }
                                                }
                                                //$ubicacion = ' en línea '.$valores[1].' en multi precio ['.$valores[0].']';
                                                /*if ($descripPrecio == $valorPrecio[0]) {
                                                    if (($valores[1] == $valor['line']) && ($valores[0] == $pos)) {}
                                                    else {
                                                        $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                        $error[] = 'Multi Precio ['.$pos.'] Descripción repetida '.$ubicacion;
                                                        $valor['error'] = implode(';', $error);
                                                        $valor['cerror'] = (count($error) > 0) ? true : false;
                                                        if (count($error) > 0) $CountError++;
                                                    }
                                                }//*/
                                            }
                                        }
                                    }
                                }
                            }
                            #-//*/
                            $DatosB[] = $valor;
                        }
                        $Datos = $DatosB;
                        //-
                        #   VALIDAR MODELOS XPOS Y BARCODES
                        /*if ($CountError == 0) {
                            $DatosB = [];
                            foreach ($Datos as $valor) {
                                $conteoRepetido = 0;
                                switch ($llave) {
                                    case 'barcode':
                                    break;
                                    case 'modelo':
                                        foreach ($Llaves as $valorllave) {
                                            if ($valorllave == $valor['modelo']) {
                                                $conteoRepetido++;
                                            }
                                        }
                                        if ($conteoRepetido > 1) {
                                            $error = explode(';', $valor['error']);
                                            if(count($error) > 0) $error = [];
                                            $error[] = 'Modelo viene repetido';
                                            $valor['error'] = implode(';', $error);
                                            $valor['cerror'] = (count($error) > 0) ? true : false;
                                            if (count($error) > 0) $CountError++;
                                        }
                                    break;
                                    case 'xpos':
                                        foreach ($Llaves as $valorllave) {
                                            if ($valorllave == $valor['xpos']) {
                                                $conteoRepetido++;
                                            }
                                        }
                                        if ($conteoRepetido > 1) {
                                            $error = explode(';', $valor['error']);
                                            if(count($error) > 0) $error = [];
                                            $error[] = 'Xpos viene repetido';
                                            $valor['error'] = implode(';', $error);
                                            $valor['cerror'] = (count($error) > 0) ? true : false;
                                            if (count($error) > 0) $CountError++;
                                        }
                                    break;
                                }
                                $DatosB[] = $valor;
                            }
                        }//*/
                    }
                }
                #-
                $datA[] = array('valido' => (($CountError == 0) ? true : false), 'datos' => $Datos, 'headers' => $Headers, 'tipo' => 1);
            } else
                $datA[] = array('valido' => false, 'datos' => $Datos, 'headers' => $Headers, 'tipo' => 0);
            echo json_encode($datA);//*/
        }
    }
    #   IMPORTAR PRODUCTOS
    public function IProductos()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $this->load->model('dev_model');
            date_default_timezone_set('America/El_Salvador');
            require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
            //  Read your Excel workbook
            try {
                $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $Excel = $objReader->load($_FILES['file']['tmp_name']);
            } catch (Exception $e) {
                die('Error loading file "' . pathinfo($_FILES['file']['tmp_name'], PATHINFO_BASENAME) . '": ' . $e->getMessage());
            }
            $hoja = (int) $this->input->post('hoja');
            $idllave = (int) $this->input->post('llave');
            $llave = '';
            $config = $this->input->post('config');
            $OTipo = (int) $this->input->post('OTipo');
            #-
            $CBarras = false;
            $CPrecios = false;
            //  Get worksheet dimensions
            $Excel->setActiveSheetIndex($hoja);
            $sheet = $Excel->setActiveSheetIndex($hoja);
            $highestRow = $sheet->getHighestRow();
            $highestColumn = $sheet->getHighestColumn();
            #   GET LLAVE
            $EstructuraT = [];
            $EstructuraUsar = [];
            $estructura = $this->dev_model->getSheets();
            foreach ($estructura as $key => $dato) {
                $dato->id = $key;
                $EstructuraT[] = $dato;
                if ($key == $idllave) {
                    $llave = $dato->name;
                }
            }
            #   GET ESTRUCTURA A USAR
            foreach (explode(';', $config) as $valor) {
                $dato = explode('-', $valor);
                //0-0
                $campo = '';
                $tipo = 'text';
                foreach ($estructura as $value) {
                    if ($value->id == $dato[1]) {
                        $campo = $value->name;
                        $tipo = $value->type;
                        break;
                    }
                }

                if ($dato[1] == count($estructura))
                    $campo = 'barras';
                else if ($dato[1] == (count($estructura) + 1))
                    $campo = 'precios';

                if (($campo == 'barras') || ($campo == 'precios')) {
                    switch ($campo) {
                        case 'barras':
                            $CBarras = true;
                            break;
                        case 'precios':
                            $CPrecios = true;
                            break;
                    }
                }

                $EstructuraUsar[] = array(
                    'IDExcel' => $dato[0],
                    'IDTabla' => $dato[1],
                    'campo' => $campo,
                    'tipo' => $tipo
                );
            }
            #   REESTRUCTURA DE DATOS
            $Cabezeras = $sheet->rangeToArray('A' . 1 . ':' . $highestColumn . 1, NULL, TRUE, FALSE);
            $Datos = [];
            $DatosR = [];
            for ($row = 2; $row <= $highestRow; $row++) {
                $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
                $Registro = [];
                $RegistroR = [];
                $PEstado = 'Nuevo';
                foreach ($EstructuraUsar as $valor) {
                    $valorActual = $rowData[0][$valor['IDExcel']];
                    if ($valor['campo'] == 'idproducto') {
                        $VProducto = $this->dev_model->existeProductoID((int) $valorActual);
                        if ($VProducto != false)
                            $PEstado = 'Actualizar';
                    }
                    if ($valor['tipo'] == 'text' || $valor['tipo'] == 'varchar') {
                        if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                            $valorActual = '';
                        }
                    }
                    //if (($valor['campo'] != $llave) &&
                    //if (($valor['campo'] != 'barras') &&
                    if (
                        ($valor['campo'] != 'idproducto') &&
                        ($valor['campo'] != 'barras') &&
                        ($valor['campo'] != 'precios')
                    ) {
                        $Registro[$valor['campo']] = $valorActual;
                    }
                    $RegistroR[$valor['campo']] = $valorActual;
                }
                $Registro['tipo'] = $OTipo;
                $RegistroR['tipo'] = $OTipo;
                $Datos[] = $Registro;
                $RegistroR['estado'] = $PEstado;
                $RegistroR['line'] = $row;
                $DatosR[] = $RegistroR;
            }
            $conteoMalos = [];
            foreach ($Datos as $key => $valor) {
                if ($DatosR[$key]['estado'] == 'Nuevo') {
                    //$valor['idproducto'] = $DatosR[$key]['idproducto'];
                    $valor['estado'] = 1;
                    $valor['whodidit'] = $this->session->userdata('iduser');
                    $valor['ingresa'] = date_create()->format('Y-m-d H:i:s');
                    if ($ID = $this->dev_model->setIProducto($valor)) {
                        //print_r($valor);
                        if ($CBarras || $CPrecios) {
                            if ($CBarras) {
                                if ($DatosR[$key]['barras'] != null && strlen($DatosR[$key]['barras']) > 0) {
                                    foreach (explode(';', $DatosR[$key]['barras']) as $pos => $mbarra) {
                                        $data = array(
                                            'idproducto' => $ID,
                                            'idgvar' => 2,
                                            'descrip' => $mbarra,

                                            'estatus' => 1,
                                            'whodidit' => $this->session->userdata('iduser'),
                                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                        );
                                        $this->dev_model->setOpcionMulti($data);
                                    }
                                }
                            }
                            if ($CPrecios) {
                                if ($DatosR[$key]['precios'] != null && strlen(trim($DatosR[$key]['precios'])) > 0) {
                                    foreach (explode(';', $DatosR[$key]['precios']) as $pos => $mprecio) {
                                        $dator = explode(',', $mprecio);
                                        $data = array(
                                            'idproducto' => $ID,
                                            'idgvar' => 1,
                                            'descrip' => $dator[0],
                                            'precioventa' => $dator[1],
                                            'uniconv' => $dator[2],
                                            'lowrange' => $dator[3],
                                            'highrange' => $dator[4],
                                            'estatus' => 1,
                                            'whodidit' => $this->session->userdata('iduser'),
                                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                        );
                                        $this->dev_model->setOpcionMulti($data);
                                    }
                                }
                            }
                        }
                    } else
                        $conteoMalos[] = $valor['idproducto'];
                } else {
                    $ID = $DatosR[$key]['idproducto'];
                    $valor['whodidit'] = $this->session->userdata('iduser');
                    $valor['modifica'] = date_create()->format('Y-m-d H:i:s');
                    if ($this->dev_model->updateIProducto($ID, $valor)) {
                        if ($CBarras || $CPrecios) {
                            if ($CBarras) {
                                if ($DatosR[$key]['barras'] != null && strlen($DatosR[$key]['barras']) > 0) {
                                    foreach (explode(';', $DatosR[$key]['barras']) as $pos => $mbarra) {
                                        $data = array(
                                            'idproducto' => $ID,
                                            'idgvar' => 2,
                                            'descrip' => $mbarra,

                                            'estatus' => 1,
                                            'whodidit' => $this->session->userdata('iduser'),
                                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                        );
                                        $this->dev_model->setOpcionMulti($data);
                                    }
                                }
                            }
                            if ($CPrecios) {
                                if ($DatosR[$key]['precios'] != null && strlen(trim($DatosR[$key]['precios'])) > 0) {
                                    foreach (explode(';', $DatosR[$key]['precios']) as $pos => $mprecio) {
                                        $dator = explode(',', $mprecio);
                                        $conteo = $this->dev_model->conteoMultiPrecio($ID, $dator[0]);
                                        if ($conteo > 0) {
                                            $IDP = $this->dev_model->getMultiPrecio($ID, $dator[0])->idrec;
                                            #   update
                                            $data = array(
                                                'descrip' => $dator[0],
                                                'precioventa' => $dator[1],
                                                'uniconv' => $dator[2],
                                                'lowrange' => $dator[3],
                                                'highrange' => $dator[4],
                                                'modifica' => date_create()->format('Y-m-d H:i:s'),
                                            );
                                            $this->dev_model->updateOpcionMulti($IDP, $data);
                                        } else {
                                            #   set
                                            $data = array(
                                                'idproducto' => $ID,
                                                'idgvar' => 1,
                                                'descrip' => $dator[0],
                                                'precioventa' => $dator[1],
                                                'uniconv' => $dator[2],
                                                'lowrange' => $dator[3],
                                                'highrange' => $dator[4],
                                                'estatus' => 1,
                                                'whodidit' => $this->session->userdata('iduser'),
                                                'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                            );
                                            $this->dev_model->setOpcionMulti($data);
                                        }
                                    }
                                }
                            }
                        }
                    } else
                        $conteoMalos[] = $valor['idproducto'];
                }
            }

            $datA[] = array('valido' => ((count($conteoMalos) > 0) ? false : true), 'malos' => implode('-', $conteoMalos));
            echo json_encode($datA);//*/
        }
    }
    #--------------- NUEVA VERSION
    public function getEstructuraN()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $hoja = (int) $this->input->post('hoja');
            # Opcion 0 - > Ingresar
            # Opcion 1 - > Actualizar
            $opcion = (int) $this->input->post('Opcion');
            $OTipo = (int) $this->input->post('OTipo');
            require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
            //  Read your Excel workbook
            try {
                $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $Excel = $objReader->load($_FILES['file']['tmp_name']);
            } catch (Exception $e) {
                die('Error loading file "' . pathinfo($_FILES['file']['tmp_name'], PATHINFO_BASENAME) . '": ' . $e->getMessage());
            }
            //  Get worksheet dimensions
            $Excel->setActiveSheetIndex($hoja);
            $sheet = $Excel->setActiveSheetIndex($hoja);
            $highestRow = $sheet->getHighestRow();
            $highestColumn = $sheet->getHighestColumn();
            $Datos = [];
            $DatosC = [];
            $Columns = [];
            $Requeridos = [];
            $EstructuraT[] = array(
                'ID' => -1,
                'Name' => '  Vacio  ',
                'permisollave' => false,
                'notas' => '---Campo no se va a utilizar--',
                'taken' => false
            );
            if ($highestRow >= 2) {
                $Columnas = null;
                for ($row = 1; $row <= 1; $row++) {
                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
                    $Columnas = $rowData[0];
                }
                #   MÁS DE 2 COLUMNAS (DESCRIP, IDCATALOGO Y TAX)
                if (count($Columnas) > 2) {
                    $vacio = 0;
                    for ($i = 0; $i < count($Columnas); $i++) {
                        if ($Columnas == null || strlen(trim($Columnas[$i])) == 0) {
                            $vacio++;
                        }
                    }
                    if ($vacio == 0) {
                        $this->load->model('dev_model');
                        $estructura = $this->dev_model->getSheets();
                        #   GET ESTRUCTURA A USAR
                        foreach ($estructura as $key => $dato) {
                            $notas = '';
                            //$descripcionA = '';
                            switch ($dato->name) {
                                case 'idproducto':
                                    if ($opcion == 1)
                                        $Requeridos[] = $key;
                                    $notas = 'Código Interno';
                                    break;
                                case 'descrip':
                                    $Requeridos[] = $key;
                                    $notas = 'Descripción';
                                    break;
                                case 'modelo':
                                    $notas = 'Modelo';
                                    break;
                                case 'marca':
                                    $notas = 'Marca';
                                    break;
                                case 'barcode':
                                    $notas = 'Código de Barra';
                                    break;
                                case 'idcatalogo':
                                    $Requeridos[] = $key;
                                    $notas = 'Código de la Línea';
                                    break;
                                case 'idprovee':
                                    $notas = 'Código del Proveedor';
                                    break;
                                case 'costounitario':
                                    $notas = 'Costo Unitario';
                                    break;
                                case 'precioventa':
                                    $notas = 'Precio de Venta con IVA';
                                    break;
                                case 'tipotax':
                                    $Requeridos[] = $key;
                                    $notas = 'Tipo de Impuesto';
                                    break;
                                case 'um':
                                    $notas = 'Unidad de Medida';
                                    break;
                                case 'upp':
                                    $notas = ($OTipo == 1) ? 'Unidades por Carton' : 'P';
                                    break;
                                case 'presenta':
                                    $notas = 'Presentación';
                                    break;
                                case 'coarancel':
                                    $notas = 'Tasa Arancelaria';
                                    break;
                                case 'copartida':
                                    $notas = 'Número de Partida Arancelaria';
                                    break;
                                case 'codescrip':
                                    $notas = 'Descripción Alterna';
                                    break;
                                case 'comision':
                                    $notas = 'Comisión';
                                    break;
                                case 'descuento':
                                    $notas = 'Descuento';
                                    break;
                                case 'pro_color':
                                    $notas = 'Color';
                                    break;
                                case 'xpos':
                                    $notas = 'Referencia del código XPOS';
                                    break;
                                case 'notas':
                                    $notas = 'Notas';
                                    break;
                            }
                            if (
                                ($dato->name != 'tipo') &&
                                ($dato->name != 'estado') &&
                                ($dato->name != 'imagen') &&
                                ($dato->name != 'idprecio') &&
                                ($dato->name != 'whodidit') &&
                                ($dato->name != 'ingresa') &&
                                ($dato->name != 'modifica')
                            ) {
                                if ($opcion == 0) {
                                    if ($dato->name != 'idproducto') {
                                        $EstructuraT[] = array(
                                            'ID' => $key,
                                            'Name' => $dato->name,
                                            'permisollave' => (($dato->name == 'idproducto') || ($dato->name == 'barcode') || ($dato->name == 'xpos') || ($dato->name == 'modelo')) ? true : false,
                                            'notas' => $notas,
                                            'taken' => false
                                        );
                                    }
                                } else {
                                    $EstructuraT[] = array(
                                        'ID' => $key,
                                        'Name' => $dato->name,
                                        //'DA' => $descripcionA,
                                        'permisollave' => (($dato->name == 'idproducto') || ($dato->name == 'barcode') || ($dato->name == 'xpos') || ($dato->name == 'modelo')) ? true : false,
                                        'notas' => $notas,
                                        'taken' => false
                                    );
                                }
                            }
                        }
                        #   GENERAR COLUMNAS GRID
                        for ($i = 0; $i < count($Columnas); $i++) {
                            //$datoCol = str_replace(array("#", "/", "\\", "<", ">", "."), "", $Columnas[$i]);
                            $datoCol = str_replace(array("."), "", $Columnas[$i]);
                            //$datoCol = "".$Columnas[$i];
                            $DatosC[] = array(
                                'columna' => $datoCol,
                                'idcolumnaT' => -1,
                                'llave' => false,
                            );
                            $Columns[] = array(
                                'dataField' => $datoCol,
                                'datatype' => 'string',
                                'caption' => $datoCol,
                                'allowSorting' => false,
                            );
                        }
                        $EstructuraT[] = array(
                            'ID' => count($estructura),
                            'Name' => '--Múltiples Barras--',
                            'permisollave' => false,
                            'notas' => 'Incluir Múltiples Barras',
                            'taken' => false
                        );
                        $EstructuraT[] = array(
                            'ID' => count($estructura) + 1,
                            'Name' => '--Múltiples Precios--',
                            'permisollave' => false,
                            'notas' => 'Incluir Múltiples Precios',
                            'taken' => false
                        );
                        #   GET DATOS GRID
                        for ($row = 2; $row <= $highestRow; $row++) {
                            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
                            $datacolumna = $rowData[0];
                            $dato = [];
                            for ($i = 0; $i < count($datacolumna); $i++) {
                                $dato["" . $DatosC[$i]['columna']] = '' . $datacolumna[$i];
                            }
                            $Datos[] = $dato;
                        }
                        $datA[] = array(
                            'valido' => true,
                            'datosColumnas' => $DatosC,//VIEJO para los datos
                            'columnas' => $Columns,
                            'datos' => $Datos,
                            'estructura' => $EstructuraT,
                            'requeridos' => $Requeridos// Campos requeridos
                        );
                    } else
                        $datA[] = array('valido' => false, 'tipo' => -1);
                } else
                    $datA[] = array('valido' => false, 'tipo' => 0);
            } else
                $datA[] = array('valido' => false, 'tipo' => 1);
            echo json_encode($datA);
        }
    }
    public function validateIProductosN()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $this->load->model('dev_model');
            require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
            //  Read your Excel workbook
            try {
                $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $Excel = $objReader->load($_FILES['file']['tmp_name']);
            } catch (Exception $e) {
                die('Error loading file "' . pathinfo($_FILES['file']['tmp_name'], PATHINFO_BASENAME) . '": ' . $e->getMessage());
            }
            $hoja = (int) $this->input->post('hoja');
            $idllave = (int) $this->input->post('llave');
            $llave = '';
            $config = $this->input->post('config');
            $OTipo = (int) $this->input->post('OTipo');
            # Opcion 0 - > Ingresar
            # Opcion 1 - > Actualizar
            $Opcion = (int) $this->input->post('Opcion');
            # VARS Si vienen campos especiales
            $CBarcode = false;
            $CBarras = false;
            $CPrecios = false;
            //  Get worksheet dimensions
            $Excel->setActiveSheetIndex($hoja);
            $sheet = $Excel->setActiveSheetIndex($hoja);
            $highestRow = $sheet->getHighestRow();
            $highestColumn = $sheet->getHighestColumn();
            #   GET LLAVE (nombre)
            $EstructuraT = [];
            $EstructuraUsar = [];
            $estructura = $this->dev_model->getSheets();
            foreach ($estructura as $key => $dato) {
                $dato->id = $key;
                $EstructuraT[] = $dato;
                if ($key == $idllave) {
                    $llave = $dato->name;
                }
            }
            #   GET ESTRUCTURA A USAR INTERNO
            $conteoRequerido = 0;
            $valorRequerido = ($Opcion == 0) ? 3 : 4; // si es ingreso no se toma en cuenta columna idproducto
            foreach (explode(';', $config) as $valor) {
                $dato = explode('-', $valor);
                //0-0
                $campo = '';
                $tipo = 'text';
                foreach ($estructura as $value) {
                    if ($value->id == $dato[1]) {
                        $campo = $value->name;
                        $tipo = $value->type;
                        break;
                    }
                }
                //  quizas tomar en cuenta opcion
                if (
                    (strtolower($campo) == 'idproducto') ||
                    (strtolower($campo) == 'descrip') ||
                    (strtolower($campo) == 'idcatalogo') ||
                    (strtolower($campo) == 'tipotax')
                ) {
                    $conteoRequerido++;
                }

                if ($dato[1] == count($estructura))
                    $campo = 'barras';
                else if ($dato[1] == (count($estructura) + 1))
                    $campo = 'precios';

                if (
                    ($campo == 'barcode') ||
                    ($campo == 'barras') ||
                    ($campo == 'precios')
                ) {
                    switch ($campo) {
                        case 'barcode':
                            $CBarcode = true;
                            break;
                        case 'barras':
                            $CBarras = true;
                            break;
                        case 'precios':
                            $CPrecios = true;
                            break;
                    }
                }

                $EstructuraUsar[] = array(
                    'IDExcel' => $dato[0],
                    'IDTabla' => $dato[1],
                    'campo' => $campo,
                    'tipo' => $tipo
                );
            }
            //print_r($EstructuraUsar);
            $Headers = [];
            $Datos = [];
            #   VALIDACIÓN
            if ($conteoRequerido == $valorRequerido) {
                #   GET HEADERS PARA GRID
                $Headers[] = array(
                    'dataField' => 'estado',
                    'caption' => 'Estado',
                    'datatype' => 'string',
                    'format' => '',
                    'aligment' => 'center',
                );
                for ($row = 1; $row <= 1; $row++) {
                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
                    foreach ($EstructuraUsar as $value) {
                        $formato = '';
                        switch ($value['tipo']) {
                            case 'int':
                            case 'double':
                            case 'float':
                                $tipo = 'number';
                                if ($value['tipo'] != 'int')
                                    $formato = '#,##0.00';
                                break;
                            case 'varchar':
                            case 'text':
                                $tipo = 'string';
                                break;
                            case 'date':
                                $tipo = 'date';
                                $formato = 'dd/MM/yyyy';
                                break;
                            case 'datetime':
                                $tipo = 'datetime';
                                $formato = 'dd/MM/yyyy hh:mm:ss';
                                break;
                        }
                        $Headers[] = array(
                            'dataField' => $value['campo'],
                            'caption' => (($value['campo'] == $llave) ? '[Key] ' : '') . $rowData[0][$value['IDExcel']],
                            'datatype' => $tipo,
                            'format' => $formato,
                            'alignment' => ($tipo == 'string') ? 'left' : 'center',
                        );//*/
                    }
                }
                #-
                #   VALIDACION DATOS PRINCIPAL (GENERAL)
                $Cabezeras = $sheet->rangeToArray('A' . 1 . ':' . $highestColumn . 1, NULL, TRUE, FALSE);
                $CountError = 0;
                $Llaves = [];
                for ($row = 2; $row <= $highestRow; $row++) {
                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
                    $Registro = [];
                    $error = [];
                    $Tipo = null;
                    $Catalogo = null;
                    $TCValido = true;
                    $PEstado = 'Nuevo';
                    $VProducto = null;
                    $VLLaves = [
                        //  MODELO
                        array(
                            'ce' => false,// viene con error
                            'vactual' => '',//valor actual del error
                            'pose' => 0//posicion del error
                        ),
                        //  XPOS
                        array(
                            'ce' => false,
                            'vactual' => '',
                            'pose' => 0
                        ),
                        //  BARCODE
                        array(
                            'ce' => false,
                            'vactual' => '',
                            'pose' => 0
                        )
                    ];

                    foreach ($EstructuraUsar as $valor) {
                        $valorActual = $rowData[0][$valor['IDExcel']];
                        if ($valor['campo'] == $llave) {
                            $Llaves[] = trim($valorActual);
                        }
                        switch ($valor['tipo']) {
                            case 'int':
                                if (!is_numeric($valorActual)) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo debe ser númerico';
                                } else {
                                    if ((int) $valorActual < 0) {
                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo debe ser mayor o igual a 0';
                                    } else {
                                        #   VALIDAR campos con referencias a otras tablas
                                        if (
                                            ($valor['campo'] == 'idcatalogo') ||
                                            ($valor['campo'] == 'idprovee') ||
                                            ($valor['campo'] == 'tipo') ||
                                            ($valor['campo'] == 'tipotax') ||
                                            ($valor['campo'] == 'idproducto')
                                        ) {
                                            switch ($valor['campo']) {
                                                case 'idcatalogo':
                                                    //echo "  aqui  ->";
                                                    if ((int) $valorActual == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede ser valor 0';
                                                    } else {
                                                        $Catalogo = $this->dev_model->existeLineaID((int) $valorActual);
                                                        //print_r($Catalogo);
                                                        if (!$Catalogo) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-No existe esa Línea';
                                                            $TCValido = false;
                                                        } else {
                                                            if ($Catalogo->estado != 1) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-No se puede Agregar o Actualizar Producto a una Línea Inactiva';
                                                            }
                                                        }
                                                    }
                                                    break;
                                                case 'idprovee':
                                                    if ((int) $valorActual > 0) {
                                                        $VProveedor = $this->dev_model->existeProveedorID((int) $valorActual);
                                                        if (!$VProveedor) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-No existe ese Proveedor';
                                                        }
                                                    }
                                                    break;
                                                /*case 'tipo':
                                                    if ((int)$valorActual == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']].'-Campo no puede tener valor 0';
                                                    } else {
                                                        //$Tipo = $valorActual;
                                                        $Tipo = $OTipo;
                                                        $VTipo = $this->dev_model->existeTProducto((int)$valorActual);
                                                        if (!$VTipo) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']].'-No existe ese Tipo de Producto';
                                                            $TCValido = false;
                                                        }
                                                    }
                                                break;//*/
                                                case 'tipotax':
                                                    if ((int) $valorActual == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede tener valor 0';
                                                    } else {
                                                        $VtipoTax = $this->dev_model->existeTTax((int) $valorActual);
                                                        if (!$VtipoTax) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-No existe ese Tipo de Tax (Impuesto)';
                                                        }
                                                    }
                                                    break;
                                                case 'idproducto':
                                                    if ((int) $valorActual == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede tener valor 0';
                                                    } else {
                                                        $VProducto = $this->dev_model->existeProductoID((int) $valorActual);
                                                        if (!$VProducto) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-No existe ese Código de Producto';
                                                        }
                                                        //print_r($VProducto);
                                                        //if ($VProducto != false) $PEstado = 'Actualizar';
                                                        if ($Opcion == 1)
                                                            $PEstado = 'Actualizar';
                                                    }
                                                    break;
                                            }
                                        }
                                    }
                                }
                                break;
                            case 'varchar':
                            case 'text':
                                if (strpos($valorActual, '"') != false) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede llevar comilla doble';
                                } else if (strpos($valorActual, "'") != false) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede llevar comilla simple';
                                } else if (strpos($valorActual, '\\') != false) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede llevar pleca invertida';
                                } else if (strpos($valorActual, "<") != false) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede llevar signo <';
                                } else if (strpos($valorActual, ">") != false) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo no puede llevar signo >';
                                } else {
                                    //  VALIDAR CAMPOS CON PERMISO DE LLAVE y barras - precios
                                    if (
                                        ($valor['campo'] == 'modelo') ||
                                        ($valor['campo'] == 'barcode') ||
                                        ($valor['campo'] == 'xpos') ||
                                        ($valor['campo'] == 'barras') ||
                                        ($valor['campo'] == 'precios')
                                    ) {
                                        switch ($valor['campo']) {
                                            case 'barcode':
                                                if ($llave == 'barcode') {
                                                    if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código Barra no puede ser vacio y llave al mismo tiempo';
                                                    } else {
                                                        $valorbar = preg_match("/^([0-9a-zA-Z])+$/", $valorActual);
                                                        if (!$valorbar) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código de Barra debe ser alfanumérico';
                                                        } else {
                                                            $VBarcode = $this->dev_model->existeProductoBarcode(trim($valorActual));
                                                            if ($VBarcode) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código Barra ya esta regisrado para otro producto';
                                                                $VLLaves[2] = array(
                                                                    'ce' => true,
                                                                    'vactual' => trim($valorActual),
                                                                    'pose' => count($error) - 1
                                                                );
                                                            }
                                                        }
                                                    }
                                                } else {
                                                    if ($valorActual != null && strlen($valorActual) > 0) {
                                                        $valorbar = preg_match("/^([0-9a-zA-Z])+$/", $valorActual);
                                                        if (!$valorbar) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código de Barra debe ser alfanumérico';
                                                        } else {
                                                            $VBarcode = $this->dev_model->existeProductoBarcode(trim($valorActual));
                                                            if ($VBarcode) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código Barra ya esta regisrado para otro producto o servicio';
                                                                $VLLaves[2] = array(
                                                                    'ce' => true,
                                                                    'vactual' => trim($valorActual),
                                                                    'pose' => count($error) - 1
                                                                );
                                                            }
                                                        }
                                                    }
                                                }
                                                break;
                                            case 'modelo':
                                                if ($llave == 'modelo') {
                                                    if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Modelo no puede ser vacio y llave al mismo tiempo';
                                                    } else {
                                                        $VModelo = $this->dev_model->existeProductoModelo(trim($valorActual));
                                                        if ($VModelo) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Modelo ya esta regisrado para otro producto';
                                                            $VLLaves[0] = array(
                                                                'ce' => true,
                                                                'vactual' => trim($valorActual),
                                                                'pose' => count($error) - 1
                                                            );
                                                        }
                                                    }
                                                }
                                                break;
                                            case 'xpos':
                                                if ($llave == 'xpos') {
                                                    if ($valorActual == null || strlen(trim($valorActual)) == 0) {
                                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-XPOS no puede ser vacio y llave al mismo tiempo';
                                                    } else {
                                                        $VModelo = $this->dev_model->existeProductoModelo(trim($valorActual));
                                                        if ($VModelo) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-XPOS ya esta regisrado para otro producto';
                                                            $VLLaves[1] = array(
                                                                'ce' => true,
                                                                'vactual' => trim($valorActual),
                                                                'pose' => count($error) - 1
                                                            );
                                                        }
                                                    }
                                                }
                                                break;
                                            case 'barras':
                                                if ($valorActual != null && strlen($valorActual) > 0) {
                                                    foreach (explode(';', $valorActual) as $key => $value) {
                                                        $valorbar = preg_match("/^([0-9a-zA-Z])+$/", $value);
                                                        if (!$valorbar) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Pos.[' . $key . '] Código de barra debe ser alfanumérico';
                                                        } else {
                                                            $VBarcode = $this->dev_model->existeProductoBarcode(trim($value));
                                                            if ($VBarcode) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Código Multi Barra [' . $key . '] ya esta regisrado para otro producto o servicio';
                                                            }
                                                        }
                                                    }
                                                }
                                                break;
                                            case 'precios':
                                                if ($valorActual != null && strlen($valorActual) > 0) {
                                                    foreach (explode(';', $valorActual) as $key => $dprecio) {
                                                        $dprecio = explode(',', $dprecio);
                                                        if (count($dprecio) != 5) {
                                                            $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] parámetros incompletos';
                                                        } else {
                                                            #   VALIDAR DESCRIPCION DE MULTI PRECIO
                                                            if (($dprecio[0] == null) || (strlen(trim($dprecio[0])) == 0)) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Descripción es requerida';
                                                            }
                                                            #   VALIDAR PRECIO DE MULTI PRECIO
                                                            if (!is_numeric($dprecio[1])) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Precio debe ser valor numérico';
                                                            } else {
                                                                if ((float) $dprecio[1] <= 0) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Precio debe ser mayor que 0';
                                                                }
                                                            }
                                                            #   VALIDAR UNDIAD DE MULTI PRECIO
                                                            if (!is_numeric($dprecio[2])) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Unidad de Conversión debe ser valor numérico';
                                                            } else {
                                                                if ((float) $dprecio[2] <= 0) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Unidad de Conversión debe ser mayor que 0';
                                                                }
                                                            }
                                                            #   VALIDAR MIN DE MULTI PRECIO
                                                            if (!is_numeric($dprecio[3])) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Valor Mínimo debe ser valor numérico';
                                                            } else {
                                                                if ((float) $dprecio[3] <= 0) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Valor Mínimo debe ser mayor que 0';
                                                                }
                                                            }
                                                            #   VALIDAR MAX DE MULTI PRECIO
                                                            if (!is_numeric($dprecio[4])) {
                                                                $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Valor Máximo debe ser valor numérico';
                                                            } else {
                                                                if ((float) $dprecio[4] <= 0) {
                                                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Multi Precio [' . $key . '] Valor Máximo debe ser mayor que 0';
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                break;
                                        }
                                    }
                                }
                                break;
                            case 'double':
                            case 'float':
                                $valorfd = preg_match("/^([0-9])+(\.[0-9]+)?$/", $valorActual);
                                if (!$valorfd) {
                                    $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo debe ser númerico';
                                } else {
                                    if ((float) $valorActual < 0) {
                                        $error[] = $Cabezeras[0][$valor['IDExcel']] . '-Campo debe ser mayor o igual a 0';
                                    }
                                }
                                break;
                                break;
                            case 'datetime':
                                break;
                            case 'date':
                                break;
                        }
                        $Registro[$valor['campo']] = $valorActual;
                    }
                    $Tipo = $OTipo;
                    /*print_r($error);
                    die();//*/
                    #   Verificar que el tipo de producto del producto
                    #   y que el tipo de producto de la linea sean el mismo
                    if (
                        ($TCValido) && ($Catalogo != null) &&
                        ($Catalogo != false) && ($Tipo != null)
                    ) {
                        if ((int) $Tipo != (int) $Catalogo->tipo) {
                            $error[] = 'Tipo de Producto del Producto y Tipo de Producto de la Línea, no coinciden';
                        }
                    }
                    #   SI se va a actualizar un producto y se pone el valor llave porque otros productos
                    #   lo llevan dara error porque se encontrara el valor con el mismo, por eso hay que quitar el error
                    if ($PEstado == 'Actualizar') {
                        if ($VLLaves[0]['ce'] == true && $llave == 'modelo') {
                            if ($VProducto->modelo == $VLLaves[0]['vactual']) {
                                unset($error[$VLLaves[0]['pose']]);
                            }
                        }
                        if ($VLLaves[1]['ce'] == true && $llave == 'xpos') {
                            if ($VProducto->xpos == $VLLaves[1]['vactual']) {
                                unset($error[$VLLaves[1]['pose']]);
                            }
                        }
                        if ($VLLaves[2]['ce'] == true) {
                            if ($VProducto->barcode == $VLLaves[2]['vactual']) {
                                unset($error[$VLLaves[2]['pose']]);
                            }
                        }
                    }
                    $Registro['estado'] = $PEstado;
                    $Registro['line'] = $row;
                    $Registro['error'] = implode(';', $error);
                    $Registro['cerror'] = (count($error) > 0) ? true : false;
                    if (count($error) > 0)
                        $CountError++;
                    $Datos[] = $Registro;
                }
                #   VALIDACION DATOS SECUNDARIA (LLAVE)
                if ($CountError == 0) {
                    if (count($Datos) > 0) {
                        #   GET IDS - BARCODES - MUMTI PRECIOS
                        $IDS = [];
                        $Barcodes = [];
                        $Precios = [];
                        foreach ($Datos as $valor) {
                            if ($Opcion == 1)
                                $IDS[] = trim($valor['idproducto']);
                            if ($valor['estado'] != 'Nuevo') {
                            }
                            if ($CBarcode || $CBarras || $CPrecios) {
                                if ($CBarcode) {
                                    if ($valor['barcode'] != null && strlen($valor['barcode']) > 0) {
                                        $Barcodes[] = 'line-' . $valor['line'] . '-' . $valor['barcode'];
                                    }
                                }
                                if ($CBarras) {
                                    if ($valor['barras'] != null && strlen($valor['barras']) > 0) {
                                        foreach (explode(';', $valor['barras']) as $key => $value) {
                                            $Barcodes[] = 'multi-' . $key . '-' . $valor['line'] . '-' . $value;
                                        }
                                    }
                                }
                                if ($CPrecios) {
                                    if ($valor['precios'] != null && strlen(trim($valor['precios'])) > 0) {
                                        foreach (explode(';', $valor['precios']) as $key => $value) {
                                            $vprecio = explode(',', $value);
                                            $Precios[] = $key . '-' . $valor['line'] . '-' . $vprecio[0];
                                        }
                                    }
                                }
                            }
                        }
                        //print_r($Precios);
                        #   VALIDACION SEGUNDO GRADO
                        $DatosB = [];
                        foreach ($Datos as $valor) {
                            #   VALIDAR IDS REPETIDOS
                            $conteoRepetido = 0;
                            if ($Opcion == 1) {
                                foreach ($IDS as $ID) {
                                    if ($ID == $valor['idproducto']) {
                                        $conteoRepetido++;
                                    }
                                }
                                if ($conteoRepetido > 1) {
                                    $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                    $error[] = 'Código de Producto repetido';
                                    $valor['error'] = implode(';', $error);
                                    $valor['cerror'] = (count($error) > 0) ? true : false;
                                    if (count($error) > 0)
                                        $CountError++;
                                }
                                if ($valor['estado'] != 'Nuevo') {
                                }
                            }
                            #   VALIDACION MODDELOS XPOS BARCODES
                            $conteoRepetido = 0;
                            switch ($llave) {
                                case 'modelo':
                                    foreach ($Llaves as $valorllave) {
                                        if ($valorllave == $valor['modelo']) {
                                            $conteoRepetido++;
                                        }
                                    }
                                    if ($conteoRepetido > 1) {
                                        $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                        $error[] = 'Modelo viene repetido';
                                        $valor['error'] = implode(';', $error);
                                        $valor['cerror'] = (count($error) > 0) ? true : false;
                                        if (count($error) > 0)
                                            $CountError++;
                                    }
                                    break;
                                case 'xpos':
                                    foreach ($Llaves as $valorllave) {
                                        if ($valorllave == $valor['xpos']) {
                                            $conteoRepetido++;
                                        }
                                    }
                                    if ($conteoRepetido > 1) {
                                        $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                        $error[] = 'Xpos viene repetido';
                                        $valor['error'] = implode(';', $error);
                                        $valor['cerror'] = (count($error) > 0) ? true : false;
                                        if (count($error) > 0)
                                            $CountError++;
                                    }
                                    break;
                            }
                            if ($CBarcode || $CBarras || $CPrecios) {
                                if ($CBarcode) {
                                    if ($valor['barcode'] != null && strlen($valor['barcode']) > 0) {
                                        foreach ($Barcodes as $key => $value) {
                                            $valores = explode('-', $value);
                                            $ubicaicon = ($valores[0] == 'line') ? (' en la línea ' . $valores[1]) : (' en la línea ' . $valores[2] . ' en múltiple barra [' . $valores[1] . ']');
                                            $valueBar = $valores[count($valores) - 1];
                                            if ($valueBar == $valor['barcode']) {
                                                if (($valores[0] == 'line') && ($valores[1] == $valor['line'])) {
                                                } else {
                                                    $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                    $error[] = 'Código de Barra repetido' . $ubicaicon;
                                                    $valor['error'] = implode(';', $error);
                                                    $valor['cerror'] = (count($error) > 0) ? true : false;
                                                    if (count($error) > 0)
                                                        $CountError++;//*/
                                                }
                                            }
                                        }
                                    }
                                }
                                if ($CBarras) {
                                    if ($valor['barras'] != null && strlen($valor['barras']) > 0) {
                                        foreach (explode(';', $valor['barras']) as $pos => $mbarra) {
                                            foreach ($Barcodes as $key => $value) {
                                                $valores = explode('-', $value);
                                                $ubicaicon = ($valores[0] == 'line') ? (' en la línea ' . $valores[1]) : (' en la línea ' . $valores[2] . ' en múltiple barra [' . $valores[1] . ']');
                                                $valueBar = $valores[count($valores) - 1];
                                                if ($valueBar == $mbarra) {
                                                    if (($valores[0] == 'multi') && ($valores[1] == $pos) && ($valores[2] == $valor['line'])) {
                                                    } else {
                                                        $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                        $error[] = 'Código de Multi Barra[' . $pos . '] repetido' . $ubicaicon;
                                                        $valor['error'] = implode(';', $error);
                                                        $valor['cerror'] = (count($error) > 0) ? true : false;
                                                        if (count($error) > 0)
                                                            $CountError++;//*/
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                if ($CPrecios) {
                                    if ($valor['precios'] != null && strlen(trim($valor['precios'])) > 0) {
                                        foreach (explode(';', $valor['precios']) as $pos => $value) {
                                            $valorPrecio = explode(',', $value);
                                            foreach ($Precios as $Dprecio) {
                                                $valores = explode('-', $Dprecio);
                                                if ($valores[1] == $valor['line']) {
                                                    if ($valores[0] != $pos) {
                                                        $descripPrecio = $valores[2];
                                                        $ubicacion = ' en multi precio [' . $valores[0] . ']';
                                                        if ($descripPrecio == $valorPrecio[0]) {
                                                            $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                            $error[] = 'Multi Precio [' . $pos . '] Descripción repetida ' . $ubicacion;
                                                            $valor['error'] = implode(';', $error);
                                                            $valor['cerror'] = (count($error) > 0) ? true : false;
                                                            if (count($error) > 0)
                                                                $CountError++;
                                                        }
                                                    }
                                                }
                                                //$ubicacion = ' en línea '.$valores[1].' en multi precio ['.$valores[0].']';
                                                /*if ($descripPrecio == $valorPrecio[0]) {
                                                    if (($valores[1] == $valor['line']) && ($valores[0] == $pos)) {}
                                                    else {
                                                        $error = (strlen($valor['error']) > 0) ? explode(';', $valor['error']) : [];
                                                        $error[] = 'Multi Precio ['.$pos.'] Descripción repetida '.$ubicacion;
                                                        $valor['error'] = implode(';', $error);
                                                        $valor['cerror'] = (count($error) > 0) ? true : false;
                                                        if (count($error) > 0) $CountError++;
                                                    }
                                                }//*/
                                            }
                                        }
                                    }
                                }
                            }
                            #-//*/
                            $DatosB[] = $valor;
                        }
                        $Datos = $DatosB;
                        //-
                    }
                }
                #-
                $datA[] = array('valido' => (($CountError == 0) ? true : false), 'datos' => $Datos, 'headers' => $Headers, 'tipo' => 1);
            } else
                $datA[] = array('valido' => false, 'datos' => $Datos, 'headers' => $Headers, 'tipo' => 0);
            echo json_encode($datA);//*/
        }
    }
    #-
    #   CONSULTA RAPIDA
    public function testingICK($idApp)
    {
        if ($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(2);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['opcion'] = 0;
            $this->load->view('testing_multi', $this->data);
        }
    }
    #   IMPORTAR TABLAS
    public function importTables($idApp)
    {
        if ($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(2);
            $this->load->model('global_model');
            $this->load->model('dev_model');
            //print_r($this->dev_model->multiOpciones(2));

            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['opcion'] = 1;
            $this->load->view('testing_multi', $this->data);
        }
    }
    public function multiOpciones()
    {
        if ($this->validatePermiso()) {
            $this->load->model('dev_model');
            $opcion = (int) $this->input->post('opcion');
            switch ($opcion) {
                case 1:#    CONSULTA RAPIDA
                    $consulta = trim($this->input->post('consulta'));
                    $datos = $this->dev_model->multiOpciones(1, $consulta);
                    $datA = array('valido' => true, 'datos' => $datos);
                    break;
                case 2:
                    break;
                default:
                    $datA = array('valido' => false);
                    break;
            }
            echo json_encode($datA);
        }
    }

    public function listadoFormasPagos()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $agrupa = $this->input->post('agrupa');

            $this->load->model('ventas_model');
            $informacion = $this->ventas_model->getFormasPagoVN($agrupa);

            echo json_encode($informacion);
        }
    }

    // 31/1/22
    // rep ventas diarias
    // controlador: ventas

    public function peticionesVentasDiarias()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $tipo = $this->input->post('tipo');
            $datos = $this->input->post('datos');
            $trannum = $this->input->post('trannum');


            $this->load->model('dev_model');
            $resultado = $this->dev_model->peticionesVentasDiarias($tipo, $datos, $trannum);

            echo json_encode($resultado);
        }
    }

    function getDatosFacturasVentasDiarias()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $fechaini = $this->input->post('fechaini');
            $fechafin = $this->input->post('fechafin');
            $idcentro = $this->input->post('idcentro');
            $idcaja = $this->input->post('idcaja');

            $this->load->model('variable_model');
            $this->load->model('ventas_model');
            $this->load->model('invtran_model');
            $this->load->model('dev_model');
            $this->load->model('global_model');

            $tipoContribuyente = $this->global_model->getDatoTipoContribuyenteEmp('g_empdatos', 10);
            $porcentaje_iva = $this->variable_model->getValorIVA();
            $datos = $this->dev_model->getDatosFacturaciones('VN', $idcentro, $idcaja, $fechaini, $fechafin);

            $posVentaOrden = $this->global_model->getValorNumVariable('pos_ventaorden');

            $i = 0;
            $array = array();

            foreach ($datos as $info) {
                if ($info->estatus != 0) {
                    $j = 0;
                    $valtax1 = 0;
                    $totalDescuento = 0;
                    $totalComision = 0;
                    $totalRecargo = 0;
                    $detailFacturas = array();
                    $detalle = $this->invtran_model->getDetalleFacturas($info->trannum);

                    foreach ($detalle as $data) {
                        $valtax1 = 0;
                        if ($info->exento == 0) {
                            $valtax1 = $data->precioneto * ($data->tax1 / 100);
                        } else {
                            $valtax1 = 0;
                        }

                        if ($data->descuento != 0) {
                            $totalDescuento = $totalDescuento + ((($data->preciotran / (1 + ($data->tax1 / 100))) - $data->precioneto) * abs($data->cantidad));
                        }

                        if ($data->comision != 0) {
                            $totalComision = $totalComision + (($data->preciotran * ($data->comision / 100)) * abs($data->cantidad));
                        }

                        if ($data->tax3 != 0) {
                            $totalRecargo = $totalRecargo + ($data->tax3 * abs($data->cantidad));
                        }

                        $total = abs($data->cantidad) * ($data->precioneto + $valtax1);

                        $detailFacturas[$j] = array(
                            "itemline" => $data->itemline,
                            "idproducto" => $data->idproducto,
                            "descrip" => $data->descrip,
                            "notas" => $data->notas,
                            "um" => $data->um,
                            "modelo" => $data->modelo,
                            "barcode" => $data->barcode,
                            "ubicacion" => $data->ubicacion,
                            "lote" => $data->lote,
                            "cantidad" => abs($data->cantidad),
                            "precio" => $this->session->userdata("simboloMoneda") . number_format($data->precioneto, 6, '.', ','),
                            "tax1" => $this->session->userdata("simboloMoneda") . number_format($valtax1, 6, '.', ','),
                            "tax3" => $this->session->userdata('simboloMoneda') . ($data->tax3 * abs($data->cantidad)),
                            "total" => $this->session->userdata("simboloMoneda") . number_format($total, 2, '.', ',')
                        );
                        $j++;
                    }

                    $exento_doc = 0;
                    $gravado_doc = 0;
                    $iva_doc = $info->valtax1;
                    if ($info->exento == 1) {
                        $exento_doc = $info->valventan;
                    } else {
                        if ($porcentaje_iva != 0) {
                            $gravado_doc = ($info->valtax1 / ($porcentaje_iva / 100));
                        } else
                            $gravado_doc = $info->valventan;

                        $exento_doc = number_format($info->valventan - $gravado_doc, 2, '.', '');
                    }

                    $totalVenta = $info->valventan + $iva_doc;

                    if (intval($tipoContribuyente) == 0) {
                        if (($info->idtipo == 3) && ($gravado_doc >= 100)) {
                            $reten = $gravado_doc * 0.01;
                            $retencion = '-' . $reten;
                            $totalVenta = $totalVenta - $reten;
                        } else if (($info->idtipo == 3) && ($gravado_doc <= -100)) {
                            $reten = $gravado_doc * 0.01;
                            $retencion = abs($reten);
                            $totalVenta = $totalVenta - $reten;
                        } else {
                            $retencion = 0;
                        }
                    } else
                        $retencion = 0;

                    $descripPagos = "";
                    $notasPago = "";

                    if ($posVentaOrden == 1) {
                        $informaPagos = $this->ventas_model->getTipoPagoRealVentaOrdenes($info->trannum);
                    } else {
                        $informaPagos = $this->ventas_model->getTipoPagoRealiVenta($info->trannum);
                    }

                    if ($informaPagos != false) {
                        foreach ($informaPagos as $infoPago) {
                            $descripPagos .= $infoPago->descrip . ', ';
                            $notasPago = $infoPago->notasPago;
                        }
                    }

                    $descripPagos = substr($descripPagos, 0, -2);

                    if ($descripPagos == "") {
                        $informaPagos = $this->ventas_model->getDatosPagosVentasTrannum($info->trannum);

                        if ($informaPagos != false) {
                            foreach ($informaPagos as $infoPago) {
                                $descripPagos .= $infoPago->descrip . ", ";

                                if ($infoPago->notasPago != "" && $infoPago->notasPago != false) {
                                    $notasPago .= $infoPago->notasPago . ", ";
                                }
                            }
                            $descripPagos = str_replace("Retención 1%", "", $descripPagos);
                            $descripPagos = substr($descripPagos, 0, -2);

                            if ($notasPago != "") {
                                $notasPago = substr($notasPago, 0, -2);
                            }
                        }
                    }

                    if ($info->registro != "") {
                        $registro = $info->registro;
                    } else {
                        $registro = "SIN REGISTRO";
                    }

                    $origenArr = $this->global_model->getOpcionesVariable('wo_origen');
                    foreach ($origenArr as $infoOrigen) {
                        if ($info->origen == $infoOrigen['id']) {
                            $origen = $infoOrigen['descrip'];
                            break;
                        } else {
                            $origen = "Sin Origen";
                        }
                    }

                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "seriedoc" => $info->serie,
                        "numeroserie" => $info->numero * 1,
                        "doc_dev" => $info->dev_serie . $info->dev_numero,
                        "nit" => $info->nit,
                        "numx" => $info->numx,
                        "numz" => $info->numz,
                        "registro" => $registro,
                        "namecliente" => $info->namecliente,
                        "idclienteauxi" => $info->idclienteauxi,
                        "namesucursal" => $info->namesucursal,
                        "namecaja" => $info->namecaja,
                        "namevendedor" => $info->namevendedor,
                        "valventan" => number_format($totalVenta, 6, '.', ''),
                        "exento" => number_format($exento_doc, 6, '.', ''),
                        "gravado" => number_format($gravado_doc, 6, '.', ''),
                        "iva" => number_format($iva_doc, 6, '.', ''),
                        "retencion" => number_format($retencion, 6, '.', ''),
                        "descuento" => number_format($totalDescuento, 6, '.', ''),
                        "comision" => number_format($totalComision, 6, '.', ''),
                        "valtax3" => number_format($totalRecargo, 6, '.', ''),
                        "detailFacturas" => $detailFacturas,
                        "estatus" => $info->estatus,
                        "formaPago" => ($descripPagos == false) ? '' : $descripPagos,
                        "notasPago" => $notasPago,
                        "notas_fact" => $info->notas,
                        "referencia" => $info->referencia,
                        "valcosto" => number_format($info->valcosto * -1, 6, '.', ''),
                        "ingresa" => $info->ingresa,
                        "user" => $info->user,
                        "origen" => $origen,
                    );
                    $i++;
                }
            }

            echo json_encode($array);
        }
    }

    // 1/2/22
    // credito fiscal agrupado
    // controlador: reports_84662

    //CREDITO FISCAL IMAGE OPC-1
    function comprobanteCreditoFiscalImg($itemsPrt)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
            $pdf->SetHeaderMargin(0, 0, 0, 0);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Comprobante Credito Fiscal');
            $pdf->SetSubject('Comprobante Credito Fiscal');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetMargins(0, 0, 0, 0);
            $pdf->SetAutoPageBreak(TRUE);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            $pdf->addPage('P', 'LETTER');
            error_reporting(0);

            //Set Background Image.-
            //$img_file = base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/imgBackCCF.png';
            //$pdf->Image($img_file, 0, 0, 235, 300, '', '', '', false, 300, '', false, false, 0);

            $this->load->model('global_model');
            $this->load->model('ventas_model');
            $this->load->model('invtran_model');
            $this->load->model('acs_model');
            $this->load->model('empleado_model');

            $estructura = '';
            $itemsPrint = explode("_", $itemsPrt);
            $totalItems = count($itemsPrint);
            $ultimoItem = $totalItems - 1;

            for ($lm = 0; $lm < $totalItems; $lm++) {
                $trannum = $itemsPrint[$lm];
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                foreach ($informacion as $info) {
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $info->nameCliente;
                    $idcps = $info->idcps;
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $info->direccion;
                    $giro = $info->giro;
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']) . ', ' . trim($zip_info['depto']);
                }

                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);
                $infoCobros = $this->ventas_model->getInformacionCobros($idcps);
                $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $numCuotas = $this->acs_model->numCuotas($info->idcps);
                /*
                foreach($productos as $pro){
                    echo '<pre>' , var_dump($pro) , '</pre>';
                }*/
                $findRetencion = 0;
                $valRetencion = 0;
                $cadena_trannum = str_pad($trannum, 5, "0", STR_PAD_LEFT);

                //<td style="font-size:16px; text-align:center; width:25%; color:red;">N° ' . str_pad($numeroRecibo, 4, "0", STR_PAD_LEFT) . '</td>
                $primerHeader = '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size: 5px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:  left; width:67%;"></td>
								<td style="font-size:16px; text-align:center; width:25%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:60%;">' . strtoupper($cliente) . '</td>
								<td style="font-size:12px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:60%;">' . $direccion . '</td>
								<td style="font-size:10px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:11px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:55%;">' . trim($depto_municipio) . '</td>
								<td style="font-size:10px; text-align:left; width:14%;"></td>
								<td style="font-size: 9px; color:red; font-weight: bold; text-align:left; width:35%;"rowspan="3"><br><br><img style="float:left;" src="' . base_url() . 'barcode.php?text=' . $cadena_trannum . '&size=16&width=100&orientation=horizontal&codetype=code128b"><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N°' . $info->numero . '</td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:40%;"><strong>Registro Fiscal:</strong> ' . $nrc . ' <strong>NIT:</strong> ' . $nit . '</td>
								<td style="font-size:10px; text-align:left; width:29%;"><strong>Fecha:</strong> ' . $fechaRecibo . '</td>
								<td style="font-size:10px; text-align:left; width: 1%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:9px; text-align:left; width:69%;"><strong>Giro:</strong> ' . substr(strtoupper($giro), 0, 76) . '</td>
							</tr>
						</tbody>
					</table>';

                $tablaProductos = '
					<table style="width:100%; padding:0px;">
						<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
							<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:60%;">Descripción del Producto</td>
							<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
							<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
							<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
							<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td>
						</tr>';

                $total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
                $vnExenta = 0;
                $vnGravada = 0;
                $numProd = 0;
                $arrayProductos = array();
                $acumuladoTotal = $acumuladoPrecioUni = 0;
                $numKey = 1;
                foreach ($productos as $pro) {
                    if ($numProd < $maxlines) {
                        if ($pro->preciotran != 0 || $pro->tipo != 1) {
                            if ($pro->tax1 != 0 && $invexento == 0) {
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = 0;
                                $vnGravada = number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            } else if ($pro->tax1 != 0 && $invexento == 1) {
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            } else if ($pro->tax1 == 0 && $invexento == 0) {
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            } else if ($pro->tax1 == 0 && $invexento == 1) {
                                $total = $total + (($pro->precioneto) * Math . abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }

                            $preciouni = $pro->precioneto;

                            if ($pro->notas == "") {
                                $descripProducto = $pro->descrip;
                            } else {
                                $descripProducto = $pro->notas;
                            }


                            if ($pro->notas == "##") {
                                $tablaProductos .= '
									<tr style="width:100%; padding:0px;">
										<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 0px; width:100%;"></td>
									</tr>';
                            } else {


                                if ($pro->barcode == "") {
                                    if (!array_key_exists($pro->itemline, $arrayProductos)) {
                                        if ($pro->preciotran != 0 || $pro->tipo != 4) {
                                            $cantidadPro = abs($pro->cantidad);
                                            $preciouniPro = $preciouni;
                                            $totalPro = $vnGravada + $vnExenta;
                                        } else {
                                            $cantidadPro = '';
                                            $preciouniPro = '';
                                            $totalPro = '';
                                        }

                                        //se inserta un elemento con una llave autogenerada
                                        $arrayProductos['eGGa' . $numKey]->descrip = $descripProducto;
                                        $arrayProductos['eGGa' . $numKey]->cantidad = $cantidadPro;
                                        $arrayProductos['eGGa' . $numKey]->preciouni = $preciouniPro;
                                        $arrayProductos['eGGa' . $numKey]->total = $totalPro;
                                        $numKey += 1;

                                    } elseif (array_key_exists($pro->itemline, $arrayProductos)) {

                                        if ($pro->preciotran != 0 || $pro->tipo != 4) {
                                            $cantidadPro = abs($pro->cantidad);
                                            $preciouniPro = $preciouni;
                                            $totalPro = $vnGravada + $vnExenta;
                                        } else {
                                            $cantidadPro = '';
                                            $preciouniPro = '';
                                            $totalPro = '';
                                        }

                                        //los datos del producto combo se suman al elemento del array acumulado de los productos
                                        $arrayProductos[$pro->itemline]->descrip = $descripProducto;
                                        $arrayProductos[$pro->itemline]->cantidad = $cantidadPro;
                                        $arrayProductos[$pro->itemline]->preciouni += $totalPro;
                                        $arrayProductos[$pro->itemline]->total += $totalPro;
                                    }
                                }

                                //es un producto normal, o un item de combo
                                if ($pro->barcode != "") {

                                    //producto normal o primer item de combo
                                    if (!array_key_exists($pro->barcode, $arrayProductos)) {
                                        if ($pro->preciotran != 0 || $pro->tipo != 4) {
                                            $cantidadPro = abs($pro->cantidad);
                                            $preciouniPro = $preciouni;
                                            $totalPro = $vnGravada + $vnExenta;
                                        } else {
                                            $cantidadPro = '';
                                            $preciouniPro = '';
                                            $totalPro = '';
                                        }

                                        $arrayProductos[$pro->barcode]->descrip = $descripProducto;
                                        $arrayProductos[$pro->barcode]->cantidad = $cantidadPro;
                                        $arrayProductos[$pro->barcode]->preciouni = $totalPro;
                                        $arrayProductos[$pro->barcode]->total = $totalPro;

                                        //producto normal o primer item de combo
                                    } elseif (array_key_exists($pro->barcode, $arrayProductos)) {
                                        if ($pro->preciotran != 0 || $pro->tipo != 4) {
                                            $cantidadPro = abs($pro->cantidad);
                                            $preciouniPro = $preciouni;
                                            $totalPro = $vnGravada + $vnExenta;
                                        } else {
                                            $cantidadPro = '';
                                            $preciouniPro = '';
                                            $totalPro = '';
                                        }

                                        $arrayProductos[$pro->barcode]->descrip = $descripProducto;
                                        $arrayProductos[$pro->barcode]->cantidad = $cantidadPro;
                                        $arrayProductos[$pro->barcode]->preciouni += $totalPro;
                                        $arrayProductos[$pro->barcode]->total += $totalPro;
                                    }
                                }
                            }
                        }
                    }
                }

                foreach ($arrayProductos as $pro) {
                    $tablaProductos .= '
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:60%;">' . $pro->descrip . '</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">' . $pro->cantidad . '</td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">' . number_format(round($pro->preciouni, 2), 2, '.', '') . '</td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">' . number_format(round($pro->total, 2), 2, '.', '') . '</td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
                        </tr>';

                    $numLetras = strlen($pro->descrip);
                    $modLetras = $numLetras / 90;
                    $numSumL = ceil($modLetras);
                    $numProd = $numProd + $numSumL;
                }

                for ($i = $numProd; $i < 9; $i++) {
                    $tablaProductos .= '
							<tr style="width:100%; padding:0px;">
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:100%;"></td>
							</tr>';
                }
                $tablaProductos .= '</table>';
                $totalGravIva = $totalGravado + $totalIVA;

                if ($clienteTipo == 3) {
                    if ($totalGravado >= 100) {
                        $findRetencion = 1;
                        $valRetencion = $totalGravado * 0.01;
                    }
                }

                if ($valRetencion != 0) {
                    $total = $total - $valRetencion;
                }

                $numero = number_format(round($total, 2), 2, '.', '');
                $TotalLetras = $this->convertir_a_letras($numero);

                $tablaTotales = "<table>";
                if ($findRetencion == 0) {
                    $tablaTotales .= '
							<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
								<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
								<td style=" border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:1%;" rowspan="2"></td>
								<td style=" border-top: 1px solid black; border-bottom: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:32%; padding:2px;" rowspan="2"><b>Son: </b> ' . strtoupper($TotalLetras) . '/100 US DOLARES</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">Vta Exentas</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">Vta Gravadas</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">IVA 13%</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">Total</td>
								<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
							</tr>
							<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">$' . number_format(round($totalExento, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">$' . number_format(round($totalGravado, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">$' . number_format(round($totalIVA, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">$' . number_format(round($total, 2), 2, '.', '') . '</td>
								<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:9px; width:3%;" rowspan="2"></td>
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:9px; width:90%; padding:2px;">Depósitos o pagos con transferencia bancaria: Banco Agricola Cuenta Corriente N°: 522-036312-6</td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:100%;"></td>
							</tr>
						</table>';
                } else {
                    $tablaTotales .= '
							<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
								<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
								<td style=" border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:1%;" rowspan="2"></td>
								<td style=" border-top: 1px solid black; border-bottom: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:32%; padding:2px;" rowspan="2"><b>Son: </b> ' . strtoupper($TotalLetras) . '/100 US DOLARES</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:13.125%;">Vta Exentas</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:13.125%;">Vta Gravadas</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:8.25%;">IVA 13%</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:8.25%;">Ret 1%</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">Total</td>
								<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
							</tr>
							<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:13.125%;">$' . number_format(round($totalExento, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:13.125%;">$' . number_format(round($totalGravado, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:8.25%;">$' . number_format(round($totalIVA, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:8.25%;">-$' . number_format(round($valRetencion, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">$' . number_format(round($total, 2), 2, '.', '') . '</td>
								<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:9px; width:3%;" rowspan="2"></td>
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:9px; width:90%; padding:2px;">Depósitos o pagos con transferencia bancaria: Banco Agricola Cuenta Corriente N°: 522-036312-6</td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:100%;"></td>
							</tr>
						</table>';
                }

                //Segunda Copia
                $segundoHeader = '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size: 5px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size: 3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:  left; width:67%;"></td>
								<td style="font-size:16px; text-align:center; width:25%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:60%;">' . trim(strtoupper($cliente)) . '</td>
								<td style="font-size:12px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:60%;">' . trim($direccion) . '</td>
								<td style="font-size:10px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:11px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:55%;">' . trim($depto_municipio) . '</td>
								<td style="font-size:10px; text-align:left; width:14%;"></td>
								<!--<td style="font-size: 9px; color:red; font-weight: bold; text-align:left; width:35%;"rowspan="3"><br><br><img style="float:left;" src="' . base_url() . 'application/controllers/barcode.php?text=' . $cadena_trannum . '&size=16&width=100&orientation=horizontal&codetype=code128b"><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N°' . $info->numero . '</td>-->
								<td style="font-size: 9px; color:red; font-weight: bold; text-align:left; width:35%;"rowspan="3"><br><br>&nbsp;&nbsp;&nbsp;Orden N°: ' . $cadena_trannum . '<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N°' . $info->numero . '</td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:40%;"><strong>Registro Fiscal:</strong> ' . $nrc . ' <strong>NIT:</strong> ' . $nit . '</td>
								<td style="font-size:10px; text-align:left; width:29%;"><strong>Fecha:</strong> ' . $fechaRecibo . '</td>
								<td style="font-size:10px; text-align:left; width: 1%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:9px; text-align:left; width:69%;"><strong>Giro:</strong> ' . strtoupper($giro) . '</td>
							</tr>
						</tbody>
					</table>';

                //Tercera Copia
                $tercerHeader = '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size: 7px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size: 4px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:  left; width:67%;"></td>
								<td style="font-size:16px; text-align:center; width:25%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:60%;">' . trim(strtoupper($cliente)) . '</td>
								<td style="font-size:12px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:60%;">' . trim($direccion) . '</td>
								<td style="font-size:10px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:11px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:55%;">' . trim($depto_municipio) . '</td>
								<td style="font-size:10px; text-align:left; width:14%;"></td>
								<td style="font-size: 9px; color:red; font-weight: bold; text-align:left; width:35%;"rowspan="3"><br><br><img style="float:left;" src="' . base_url() . 'Barcode.php?text=' . $cadena_trannum . '&size=16&width=100&orientation=horizontal&codetype=code128b"><br>&nbsp;Orden N°: ' . $cadena_trannum . '&nbsp;&nbsp;&nbsp;N°' . $info->numero . '</td>
								<!--<td style="font-size: 9px; color:red; font-weight: bold; text-align:left; width:35%;"rowspan="3"><br><br>&nbsp;&nbsp;&nbsp;Orden N°: ' . $cadena_trannum . '<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N°' . $info->numero . '</td>-->
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:40%;"><strong>Registro Fiscal:</strong> ' . $nrc . ' <strong>NIT:</strong> ' . $nit . '</td>
								<td style="font-size:10px; text-align:left; width:29%;"><strong>Fecha:</strong> ' . $fechaRecibo . '</td>
								<td style="font-size:10px; text-align:left; width: 1%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:9px; text-align:left; width:69%;"><strong>Giro:</strong> ' . strtoupper($giro) . '</td>
							</tr>
						</tbody>
					</table>';
            }
            $estructura = $primerHeader . $tablaProductos . $tablaTotales;
            $estructura .= $segundoHeader . $tablaProductos . $tablaTotales;
            $estructura .= $tercerHeader . $tablaProductos . $tablaTotales;
            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $nombre_archivo = utf8_decode("CreditoFiscal.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }
    }

    //CREDITO FISCAL IMAGE OPC-1
    function comprobanteCreditoFiscalImgOriginal($itemsPrt)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
            $pdf->SetHeaderMargin(0, 0, 0, 0);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Comprobante Credito Fiscal');
            $pdf->SetSubject('Comprobante Credito Fiscal');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetMargins(0, 0, 0, 0);
            $pdf->SetAutoPageBreak(TRUE);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            $pdf->addPage('P', 'LETTER');

            //Set Background Image.-
            //$img_file = base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/imgBackCCF.png';
            //$pdf->Image($img_file, 0, 0, 235, 300, '', '', '', false, 300, '', false, false, 0);

            $this->load->model('global_model');
            $this->load->model('ventas_model');
            $this->load->model('invtran_model');
            $this->load->model('acs_model');
            $this->load->model('empleado_model');

            $estructura = '';
            $itemsPrint = explode("_", $itemsPrt);
            $totalItems = count($itemsPrint);
            $ultimoItem = $totalItems - 1;

            for ($lm = 0; $lm < $totalItems; $lm++) {
                $trannum = $itemsPrint[$lm];
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                foreach ($informacion as $info) {
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $info->nameCliente;
                    $idcps = $info->idcps;
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $info->direccion;
                    $giro = $info->giro;
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']) . ', ' . trim($zip_info['depto']);
                }

                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);
                $infoCobros = $this->ventas_model->getInformacionCobros($idcps);
                $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $numCuotas = $this->acs_model->numCuotas($info->idcps);
                /*
                foreach($productos as $pro){
                    echo '<pre>' , var_dump($pro) , '</pre>';
                }*/
                $findRetencion = 0;
                $valRetencion = 0;
                $cadena_trannum = str_pad($trannum, 5, "0", STR_PAD_LEFT);

                //<td style="font-size:16px; text-align:center; width:25%; color:red;">N° ' . str_pad($numeroRecibo, 4, "0", STR_PAD_LEFT) . '</td>
                $primerHeader = '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size: 5px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:  left; width:67%;"></td>
								<td style="font-size:16px; text-align:center; width:25%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:60%;">' . strtoupper($cliente) . '</td>
								<td style="font-size:12px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:60%;">' . $direccion . '</td>
								<td style="font-size:10px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:11px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:55%;">' . trim($depto_municipio) . '</td>
								<td style="font-size:10px; text-align:left; width:14%;"></td>
								<td style="font-size: 9px; color:red; font-weight: bold; text-align:left; width:35%;"rowspan="3"><br><br><img style="float:left;" src="' . base_url() . 'barcode.php?text=' . $cadena_trannum . '&size=16&width=100&orientation=horizontal&codetype=code128b"><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N°' . $info->numero . '</td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:40%;"><strong>Registro Fiscal:</strong> ' . $nrc . ' <strong>NIT:</strong> ' . $nit . '</td>
								<td style="font-size:10px; text-align:left; width:29%;"><strong>Fecha:</strong> ' . $fechaRecibo . '</td>
								<td style="font-size:10px; text-align:left; width: 1%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:9px; text-align:left; width:69%;"><strong>Giro:</strong> ' . substr(strtoupper($giro), 0, 76) . '</td>
							</tr>
						</tbody>
					</table>';

                $tablaProductos = '
					<table style="width:100%; padding:0px;">
						<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
							<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:60%;">Descripción del Producto</td>
							<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
							<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
							<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
							<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td>
						</tr>';

                $total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
                $vnExenta = 0;
                $vnGravada = 0;
                $numProd = 0;
                foreach ($productos as $pro) {
                    if ($numProd < $maxlines) {
                        if ($pro->preciotran != 0 || $pro->tipo != 1) {
                            if ($pro->tax1 != 0 && $invexento == 0) {
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = 0;
                                $vnGravada = number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            } else if ($pro->tax1 != 0 && $invexento == 1) {
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            } else if ($pro->tax1 == 0 && $invexento == 0) {
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            } else if ($pro->tax1 == 0 && $invexento == 1) {
                                $total = $total + (($pro->precioneto) * Math . abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }

                            $preciouni = $pro->precioneto;

                            if ($pro->notas == "") {
                                $descripProducto = $pro->descrip;
                            } else {
                                $descripProducto = $pro->notas;
                            }

                            $numLetras = strlen($descripProducto);

                            if ($pro->notas == "##") {
                                $tablaProductos .= '
									<tr style="width:100%; padding:0px;">
										<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 0px; width:100%;"></td>
									</tr>';
                            } else {

                                if ($pro->preciotran != 0 || $pro->tipo != 4) {
                                    $preciouniPro = number_format(round($preciouni, 2), 2, '.', '');
                                    $totalPro = number_format(round($vnGravada + $vnExenta, 2), 2, '.', '');
                                    $cantidadPro = abs($pro->cantidad);
                                } else {
                                    $preciouniPro = '';
                                    $totalPro = '';
                                    $cantidadPro = '';
                                }

                                $tablaProductos .= '
									<tr style="width:100%; padding:0px;">
										<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
										<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:60%;">' . $descripProducto . '</td>
										<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">' . $cantidadPro . '</td>
										<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">' . $preciouniPro . '</td>
										<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">' . $totalPro . '</td>
										<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
									</tr>';
                                $modLetras = $numLetras / 90;
                                $numSumL = ceil($modLetras);
                                $numProd = $numProd + $numSumL;

                            }
                        }
                    }
                }

                for ($i = $numProd; $i < 9; $i++) {
                    $tablaProductos .= '
							<tr style="width:100%; padding:0px;">
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:100%;"></td>
							</tr>';
                }
                $tablaProductos .= '</table>';
                $totalGravIva = $totalGravado + $totalIVA;

                if ($clienteTipo == 3) {
                    if ($totalGravado >= 100) {
                        $findRetencion = 1;
                        $valRetencion = $totalGravado * 0.01;
                    }
                }

                if ($valRetencion != 0) {
                    $total = $total - $valRetencion;
                }

                $numero = number_format(round($total, 2), 2, '.', '');
                $TotalLetras = $this->convertir_a_letras($numero);

                $tablaTotales = "<table>";
                if ($findRetencion == 0) {
                    $tablaTotales .= '
							<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
								<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
								<td style=" border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:1%;" rowspan="2"></td>
								<td style=" border-top: 1px solid black; border-bottom: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:32%; padding:2px;" rowspan="2"><b>Son: </b> ' . strtoupper($TotalLetras) . '/100 US DOLARES</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">Vta Exentas</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">Vta Gravadas</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">IVA 13%</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">Total</td>
								<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
							</tr>
							<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">$' . number_format(round($totalExento, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">$' . number_format(round($totalGravado, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">$' . number_format(round($totalIVA, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">$' . number_format(round($total, 2), 2, '.', '') . '</td>
								<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:9px; width:3%;" rowspan="2"></td>
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:9px; width:90%; padding:2px;">Depósitos o pagos con transferencia bancaria: Banco Agricola Cuenta Corriente N°: 522-036312-6</td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:100%;"></td>
							</tr>
						</table>';
                } else {
                    $tablaTotales .= '
							<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
								<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
								<td style=" border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:1%;" rowspan="2"></td>
								<td style=" border-top: 1px solid black; border-bottom: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:32%; padding:2px;" rowspan="2"><b>Son: </b> ' . strtoupper($TotalLetras) . '/100 US DOLARES</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:13.125%;">Vta Exentas</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:13.125%;">Vta Gravadas</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:8.25%;">IVA 13%</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:8.25%;">Ret 1%</td>
								<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">Total</td>
								<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
							</tr>
							<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:13.125%;">$' . number_format(round($totalExento, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:13.125%;">$' . number_format(round($totalGravado, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:8.25%;">$' . number_format(round($totalIVA, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:8.25%;">-$' . number_format(round($valRetencion, 2), 2, '.', '') . '</td>
								<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:14.25%;">$' . number_format(round($total, 2), 2, '.', '') . '</td>
								<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:9px; width:3%;" rowspan="2"></td>
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:9px; width:90%; padding:2px;">Depósitos o pagos con transferencia bancaria: Banco Agricola Cuenta Corriente N°: 522-036312-6</td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:100%;"></td>
							</tr>
						</table>';
                }

                //Segunda Copia
                $segundoHeader = '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size: 5px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size: 3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:  left; width:67%;"></td>
								<td style="font-size:16px; text-align:center; width:25%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:60%;">' . trim(strtoupper($cliente)) . '</td>
								<td style="font-size:12px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:60%;">' . trim($direccion) . '</td>
								<td style="font-size:10px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:11px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:55%;">' . trim($depto_municipio) . '</td>
								<td style="font-size:10px; text-align:left; width:14%;"></td>
								<!--<td style="font-size: 9px; color:red; font-weight: bold; text-align:left; width:35%;"rowspan="3"><br><br><img style="float:left;" src="' . base_url() . 'application/controllers/barcode.php?text=' . $cadena_trannum . '&size=16&width=100&orientation=horizontal&codetype=code128b"><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N°' . $info->numero . '</td>-->
								<td style="font-size: 9px; color:red; font-weight: bold; text-align:left; width:35%;"rowspan="3"><br><br>&nbsp;&nbsp;&nbsp;Orden N°: ' . $cadena_trannum . '<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N°' . $info->numero . '</td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:40%;"><strong>Registro Fiscal:</strong> ' . $nrc . ' <strong>NIT:</strong> ' . $nit . '</td>
								<td style="font-size:10px; text-align:left; width:29%;"><strong>Fecha:</strong> ' . $fechaRecibo . '</td>
								<td style="font-size:10px; text-align:left; width: 1%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:9px; text-align:left; width:69%;"><strong>Giro:</strong> ' . strtoupper($giro) . '</td>
							</tr>
						</tbody>
					</table>';

                //Tercera Copia
                $tercerHeader = '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size: 7px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size: 4px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:  left; width:67%;"></td>
								<td style="font-size:16px; text-align:center; width:25%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:60%;">' . trim(strtoupper($cliente)) . '</td>
								<td style="font-size:12px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:60%;">' . trim($direccion) . '</td>
								<td style="font-size:10px; text-align:left; width:37%;"></td>
							</tr>
							<tr>
								<td style="font-size:11px; text-align:left; width:3%;"></td>
								<td style="font-size:11px; text-align:left; width:55%;">' . trim($depto_municipio) . '</td>
								<td style="font-size:10px; text-align:left; width:14%;"></td>
								<td style="font-size: 9px; color:red; font-weight: bold; text-align:left; width:35%;"rowspan="3"><br><br><img style="float:left;" src="' . base_url() . 'Barcode.php?text=' . $cadena_trannum . '&size=16&width=100&orientation=horizontal&codetype=code128b"><br>&nbsp;Orden N°: ' . $cadena_trannum . '&nbsp;&nbsp;&nbsp;N°' . $info->numero . '</td>
								<!--<td style="font-size: 9px; color:red; font-weight: bold; text-align:left; width:35%;"rowspan="3"><br><br>&nbsp;&nbsp;&nbsp;Orden N°: ' . $cadena_trannum . '<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N°' . $info->numero . '</td>-->
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:10px; text-align:left; width:40%;"><strong>Registro Fiscal:</strong> ' . $nrc . ' <strong>NIT:</strong> ' . $nit . '</td>
								<td style="font-size:10px; text-align:left; width:29%;"><strong>Fecha:</strong> ' . $fechaRecibo . '</td>
								<td style="font-size:10px; text-align:left; width: 1%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:3%;"></td>
								<td style="font-size:9px; text-align:left; width:69%;"><strong>Giro:</strong> ' . strtoupper($giro) . '</td>
							</tr>
						</tbody>
					</table>';
            }
            $estructura = $primerHeader . $tablaProductos . $tablaTotales;
            $estructura .= $segundoHeader . $tablaProductos . $tablaTotales;
            $estructura .= $tercerHeader . $tablaProductos . $tablaTotales;
            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $nombre_archivo = utf8_decode("CreditoFiscal.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }
    }

    // 3/2/22
    // rep compras locales
    // controlador: compras
    function getListadoComprasLocales()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $tipopro = $this->input->post('tipoproducto');
            $fechaini = $this->input->post('fechaini');
            $fechafin = $this->input->post('fechafin');
            $estado = $this->input->post('estado');
            $idcentro = $this->session->userdata('idcentrouser');

            $this->load->model('compras_model');
            $this->load->model('dev_model');

            $datos = $this->dev_model->getListadoOrdenes('CO', $tipopro, $idcentro, $fechaini, $fechafin, $estado);
            /*highlight_string("<?php\n\$data =\n" . var_export($datos, true) . ";\n?>");*/
            $i = 0;
            $array = array();
            foreach ($datos as $info) {
                $linea = 0;
                $canti = 0;

                if ($info->valcosto == null || $info->valcosto == "") {
                    $valcosto = 0;
                } else {
                    $valcosto = number_format($info->valcosto, 2, '.', '');
                }

                if ($info->fecha4 == "0000-00-00") {
                    $fechacierre = "";
                } else {
                    $fechacierre = $info->fecha4;
                }

                $informacion = $this->compras_model->getDetalleLineasCompraLocal($info->trannum, $info->estatus);
                foreach ($informacion as $cmp) {
                    $linea++;
                    $canti += $cmp->cantidad;
                }
                //serie/ num /proveedor /fecha /resolucion /tipocompra/ notas
                $array[$i] = array(
                    "trannum" => $info->trannum,
                    "fecha" => $info->fecha3,
                    "fecact" => $fechacierre,
                    "estatus" => $info->estatus,
                    "documento" => $info->documento,
                    "descrip" => $info->descrip,
                    "serie" => $info->serie . '' . $info->numero,
                    "referencia" => $info->referencia,
                    "valventa" => $valcosto,
                    "notas" => $info->notas,
                    "lineaunidad" => $linea . '/' . number_format($canti),
                    "username" => $info->username,
                    "serieDoc" => $info->serie,
                    "numeroDoc" => $info->numero,
                    "idDoc" => $info->idclase,
                    "idProveedor" => $info->idproveedor
                );
                $i++;
            }

            echo json_encode($array);
        }
    }

    // 4/2/22
    // cambios agrupacion tickets
    // controlador: gerencia
    function getServicesTypeList()
    {
        $this->load->model('media_model');
        $parents = $this->media_model->getParentsServicesType();

        $array_childrens = array();
        $j = 0;

        //$this->highlight_array($parents);
        if ($parents != false) {
            foreach ($parents as $par) {
                $childrens = $this->media_model->getChildsServicesType($par->idgestion);

                if ($childrens != false) {
                    foreach ($childrens as $child) {
                        if ($child->estado == 0) {
                            $array_childrens[$j] = array(
                                "idgestion" => $child->idgestion,
                                "nivel" => $child->nivel,
                                "idnivel1" => $child->idnivel1,
                                "descrip" => $child->descrip,
                                "links" => $child->links,
                                "prioridad" => $child->prioridad,
                                "facturable" => $child->facturable,
                                "valor" => $child->valor,
                                "printable" => $child->printable,
                                "grupo" => $child->grupo,
                                "estado" => $child->estado,
                                "visibletoclient" => $child->visibletoclient,
                                "servicio" => 'SERVICIO INACTIVO',
                            );
                        } else {
                            $array_childrens[$j] = array(
                                "idgestion" => $child->idgestion,
                                "nivel" => $child->nivel,
                                "idnivel1" => $child->idnivel1,
                                "descrip" => $child->descrip,
                                "links" => $child->links,
                                "prioridad" => $child->prioridad,
                                "facturable" => $child->facturable,
                                "valor" => $child->valor,
                                "printable" => $child->printable,
                                "grupo" => $child->grupo,
                                "estado" => $child->estado,
                                "visibletoclient" => $child->visibletoclient,
                                "servicio" => $par->descrip,
                            );
                        }

                        $j++;
                    }
                }
            }
        }

        echo json_encode($array_childrens);
    }

    function updateService()
    {

        $idgestion = $this->input->post("idgestion");
        $descrip = $this->input->post("descrip");
        $grupo = $this->input->post("grupo");
        $detalle = $this->input->post("detalle");
        $fac = $this->input->post("facturable");
        $impri = $this->input->post("imprimible");
        $visi = $this->input->post("visible");
        $prioridad = $this->input->post("prioridad");
        $valor = $this->input->post('valor');
        $estado = $this->input->post('estado');
        $nivel1 = $this->input->post('nivel1');

        if ($estado == 'true') {
            $estado = 1;
        } else {
            $estado = 0;
        }

        if ($fac == 'true') {
            $facturable = 1;
        } else {
            $facturable = 0;
        }

        if ($impri == 'true') {
            $imprimible = 1;
        } else {
            $imprimible = 0;
        }

        if ($visi == 'true') {
            $visible = 1;
        } else {
            $visible = 0;
        }

        $this->load->model('media_model');
        $this->load->model('dev_model');

        $updateService = $this->dev_model->updateService($idgestion, $descrip, $grupo, $detalle, $facturable, $imprimible, $visible, $prioridad, $valor, $estado, $nivel1);

        echo json_encode($updateService);
    }

    function getServiceParents()
    {
        $this->load->model('media_model');
        $parents = $this->media_model->getParentsServicesType();

        echo json_encode($parents);
    }

    function updateGestion()
    {

        $idgestion = $this->input->post("idgestion");
        $descrip = $this->input->post("descrip");
        $grupo = $this->input->post("grupo");

        $this->load->model('media_model');
        $updateGestion = $this->media_model->updateGestion($idgestion, $descrip, $grupo);

        $array = $this->getServicesTypeList();

        echo ($array);
    }

    // 5/2/22
    // cambiar itemline
    // controlador: ventas

    function updateOrders100k()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $idrec = $this->input->post('idrec');
            $idtrannum = $this->input->post('idtrannum');
            $idcatalogo = $this->input->post('idcatalogo');
            $idcentro = $this->session->userdata('idcentrouser');
            $tipopro = $this->session->userdata('compras_tipopro');
            $cantidad = $this->input->post('cantidad');
            $descuento = $this->input->post('descuento');
            $um = $this->input->post('um');
            $uniconv = $this->input->post('uniconv');
            $notas = trim($this->input->post('notas'));
            $precio = $this->input->post('precio');
            $itemline = $this->input->post('itemline');
            #   ACTULIZAR DESCRIPCION ORDERS 100K
            $tipo = (int) $this->input->post("tipoP");
            $NDescrip = $this->input->post("NDescrip");
            $olditemline = $this->input->post("olditemline");
            //-

            $this->load->model('ventas_model');
            $this->load->model('compras_model');
            $this->load->model('dev_model');

            $this->dev_model->updateProdOrders100k($idtrannum, $idrec, $cantidad, $precio, $notas, $um, $uniconv, $itemline, $descuento, $olditemline);
            $e = 0;
            date_default_timezone_set('America/El_Salvador');
            $data = array(
                'descrip' => $NDescrip,
                'whodidit' => $this->session->userdata('iduser'),
                'modifica' => date_create()->format('Y-m-d H:i:s'),
            );
            $e = $this->ventas_model->UMDescripOrder100k($idrec, $data);
            $e = ($e) ? 1 : -1;//*/

            $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum, $idcatalogo, $idcentro, $tipopro);
            $datos = $this->ventas_model->getDatosOrden100k($idtrannum, $idcentro);

            $i = 0;
            $items = array();
            foreach ($detalle as $info) {
                $items[$i] = array(
                    "nameproducto" => $info->descrip,
                    "marca" => $info->marca,
                    "modelo" => $info->modelo,
                    "upc" => $info->barcode,
                    "notas" => $info->notas,
                    "idproducto" => $info->idproducto,
                    "um" => $info->um,
                    "imagen" => $info->imagen,
                    "cantidad" => $info->cantidad,
                    "tipotax" => $info->tipotax,
                    "precio" => $info->precioventa,
                    "costouni" => $info->costouni
                );
                $i++;
            }

            $array = array(
                "items" => $items,
                "datos" => $datos,
                "count" => $i,
                "e" => $e
            );

            echo json_encode($array);
        }
    }

    // 8/2/22
    // escalar caso
    // controlador: gerencia
    function escalarCaso()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            date_default_timezone_set('America/El_Salvador');
            $fecha_act = date("Y-m-d");
            $ticket = $this->input->post('info');
            $agente = $this->input->post('nuevoagente');
            $motivo = $this->input->post('motivo');

            $this->load->model('media_model');
            $this->load->model("auxi_model");
            $nombreAgente = $this->auxi_model->getDescripcionAuxi($agente);
            $descripcion = "Agente: " . $nombreAgente . "  -  # de Ticket: " . $ticket['idticket'] . "\nMotivo de Escalación: \n" . $motivo . "\nDescripción: \n" . $ticket['descrip'];

            //crea un ticket con la misma informacion
            $this->media_model->adicionarTicketEscalado($ticket['fecha'], $ticket['idgestion'], $ticket['sistema'], $ticket['idaccount'], $ticket['idcontacto'], $agente, $descripcion, $ticket['idticket']);
            //actualiza el estado del ticket anterior
            $this->media_model->updateEstadoTicket($ticket['idticket'], 3, $motivo);

            echo json_encode($descripcion);
        }
    }

    // 10/2/22
    // mantenimiento gastos
    // controlador: ??
    function getAuxiByUseAuxi()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            date_default_timezone_set('America/El_Salvador');
            $useauxi = $this->input->post('useauxi');
            $info = explode(",", $useauxi);

            $this->load->model('auxi_model');
            $auxis = $this->auxi_model->getAuxiByUseAuxi($info[0], $info[1]);


            echo json_encode($auxis);
        }
    }

    // 04/04/22
    // anexos de cotizacion de ordenes
    // controlador: otrabajo
    function getListadoAnexos()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $this->load->model('otrabajo_model');

            $anexos = $this->otrabajo_model->getListadoAnexos();

            echo json_encode($anexos);
        }
    }

    function adicionarAnexo()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $datos = $this->input->post('datos');
            $this->load->model('dev_model');

            $this->dev_model->adicionarAnexo($datos);

            echo json_encode(null);
        }
    }

    function modificarAnexo()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $idanexo = $this->input->post('idanexo');
            $datos = $this->input->post('datos');
            $this->load->model('dev_model');

            $this->dev_model->modificarAnexo($idanexo, $datos);

            echo json_encode(null);
        }
    }

    function verificacionContraMantenimiento()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            $password = $this->input->post('password');

            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            //var_dump('84662#'.str_pad($date->format('i'), 2, "0", STR_PAD_LEFT));
            if (strval($password) == '84662#' . str_pad($date->format('i'), 2, "0", STR_PAD_LEFT)) {
                echo json_encode(true);
            } else {
                echo json_encode(false);

            }
        }
    }


    function getProductList()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('CerrarSesion');
        } else {
            date_default_timezone_set('America/El_Salvador');
            $limite = $this->input->post('limite');
            /*$info = explode(",", $useauxi);*/

            $this->load->model('dev_model');
            $products = $this->dev_model->getProductList($limite);


            echo json_encode($products);
        }
    }

    // 18/02/2023
    // Valorizacion de inventario
    public function valorizacionDeInventario($idApp)
    {
        if ($this->validatePermiso()) {
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();

            $this->load->model('global_model');
            $this->load->model('configuracion_model');

            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);

            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));

            $this->load->view('mantenimiento_valorizacion_de_inventario', $this->data);
        }
    }

    function getDatosSucursales()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $this->load->model('dev_model');
            $array = $this->dev_model->getSucursales();
            echo json_encode($array);
        }
    }

    function getDatosInventarioValorizadoProducto()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {

            // $request_body = file_get_contents('php://input');
            // $data = json_decode($request_body);

            $fechafin = $this->input->post('fechafin');
            $sucursal = $this->input->post('sucursal');
            $offset = $this->input->post('offset');

            // echo $offset;


            $this->load->model('dev_model');

            echo json_encode(array(
                'offset' => $offset,
                'dataSource' => $this->dev_model->getInventarioValorizadoProducto($fechafin, $sucursal, $offset),
                'numRows' => $this->dev_model->getCantidadItemsProducto()
            ));
        }
    }

    //Mantenimiento de Catalogo
    function mantenimiento_det_catalogo($idApp)
    {
        if ($this->validatePermiso()) {
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();

            $this->load->model('global_model');
            $this->load->model('configuracion_model');

            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);

            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));

            $this->load->view('mantenimiento_det_catalogo', $this->data);
        }
    }

    function getDatosCatalogo()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {

            $idcatalogo = $this->input->post('idcatalogo');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->getDetCatalogo($idcatalogo));
        }
    }

    function getIdDatosCatalogo()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {

            $this->load->model('dev_model');
            $array = $this->dev_model->getIdCatalogo();
            //print_r($array);
            echo json_encode($array);
        }
    }

    function modificarCatalogo()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {

            $idrec = $this->input->post('idrec');
            $idcatalogo = $this->input->post('idcatalogo');
            $descripcion = $this->input->post('descrip');
            $codigo = $this->input->post('codigo');
            $tipo = $this->input->post('tipo');
            $notas = $this->input->post('notas');
            $estado = $this->input->post('estado');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->updateDetCatalogo($idrec, $idcatalogo, $descripcion, $codigo, $tipo, $notas, $estado));
        }
    }

    function setCatalogo()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {

            $idcatalogo = $this->input->post('idcatalogo');
            $descripcion = $this->input->post('descrip');
            $codigo = $this->input->post('codigo');
            $tipo = $this->input->post('tipo');
            $notas = $this->input->post('notas');
            $estado = $this->input->post('estado');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->setDetCatalogo($idcatalogo, $descripcion, $codigo, $tipo, $notas, $estado));
        }
    }

    function deleteCatalogo()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {

            $idrec = $this->input->post('idrec');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->deleteDetCatalogo($idrec));
        }
    }

    function getTipoById()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {

            $idcatalogo = $this->input->post('idcatalogo');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->getTipoById($idcatalogo));
        }
    }

    //mantenimiento Generador Pruebas DTE
    function administrador_dte($idApp)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $opcionmenu = $this->configuracion_model->getProCentro($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName,
            );
            $this->session->set_userdata($resultAppName);

            $this->load->model('ventas_model');
            $this->load->model('global_model');
            $this->load->model('invtran_model');
            $this->load->model('user_model');

            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            $fechaactual = $date->format('Y-m-d');

            $permite = 0;
            $derechos = $this->user_model->getDerechos();
            if ($derechos != "") {
                $pos = strpos($derechos, "costo");
                if ($pos !== false) {
                    if ($pos >= 0) {
                        $permite = 1;
                    }
                }
            }

            $controlador = $this->uri->segment(1);
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
            $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
            $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
            $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
            $this->data['newcliente'] = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
            $this->data['pos_referencia'] = $this->global_model->getValorNumVariable('pos_referencia');
            $this->data['opcionRecManual'] = $this->global_model->getValorNumVariable('dte_recmanual');
            $this->data['codAmbiente'] = $this->global_model->getDatosGeneralesEmp('dte_empdatos', 5);
            $this->data['fechaactual'] = $fechaactual;
            $this->data['primerdia'] = date('Y-m-01'); // hard-coded '01' for first day
            $this->data['ultimodia'] = date('Y-m-t');
            $this->data['permite_derechos'] = $permite;
            $this->data['user_perfil_derechos'] = $this->user_model->getProfileAndRights();

            $idcentro = $this->session->userdata('idcentrouser');
            $this->load->view('mantenimiento_administrador_dte', $this->data);
        }
    }

    function getDatosFacturasBitacoraVentas()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $fechaini = $this->input->post('fechaini');
            $fechafin = $this->input->post('fechafin');
            $idcentro = $this->input->post('idcentro');
            $idcaja = $this->input->post('idcaja');

            $this->load->model('variable_model');
            $this->load->model('ventas_model');
            $this->load->model('invtran_model');
            $this->load->model('dev_model');

            $porcentaje_iva = $this->variable_model->getValorIVA();
            $datos = $this->dev_model->getDatosFacturacionesBitacora('VN', $idcentro, $idcaja, $fechaini, $fechafin);

            $i = 0;
            $array = array();

            foreach ($datos as $info) {
                if ($info->estatus != 0) {
                    $j = 0;
                    $valtax1 = 0;
                    $totalDescuento = 0;
                    $totalComision = 0;
                    $detailFacturas = array();
                    $detalle = $this->invtran_model->getDetalleFacturas($info->trannum);


                    foreach ($detalle as $data) {
                        $valtax1 = 0;
                        if ($info->exento == 0) {
                            $valtax1 = $data->precioneto * ($data->tax1 / 100);
                        } else {
                            $valtax1 = 0;
                        }

                        if ($data->descuento != 0) {
                            $totalDescuento = $totalDescuento + ((($data->preciotran / (1 + ($data->tax1 / 100))) - $data->precioneto) * abs($data->cantidad));
                        }

                        if ($data->comision != 0) {
                            $totalComision = $totalComision + (($data->preciotran * ($data->comision / 100)) * abs($data->cantidad));
                        }

                        $total = abs($data->cantidad) * ($data->precioneto + $valtax1);

                    }

                    $exento_doc = 0;
                    $gravado_doc = 0;
                    $iva_doc = $info->valtax1;
                    if ($info->exento == 1) {
                        $exento_doc = $info->valventan;
                    } else {
                        if ($porcentaje_iva != 0) {
                            $gravado_doc = ($info->valtax1 / ($porcentaje_iva / 100));
                        } else
                            $gravado_doc = $info->valventan;

                        $exento_doc = number_format($info->valventan - $gravado_doc, 2, '.', '');
                    }

                    $totalVenta = $info->valventan + $iva_doc;

                    if (($info->idtipo == 3) && ($gravado_doc >= 100)) {
                        $reten = $gravado_doc * 0.01;
                        $retencion = '-' . $reten;
                        $totalVenta = $totalVenta - $reten;
                    } else {
                        $retencion = 0;
                    }

                    $descripPagos = "";
                    $notasPago = "";
                    $informaPagos = $this->dev_model->getDatosPagosVentasTrannum($info->trannum);

                    if ($informaPagos != false) {
                        foreach ($informaPagos as $infoPago) {
                            $descripPagos .= $infoPago->descrip . ", ";

                            if ($infoPago->notasPago != "" && $infoPago->notasPago != false) {
                                $notasPago .= $infoPago->notasPago . ", ";
                            }
                        }
                        $descripPagos = str_replace("Retención 1%", "", $descripPagos);
                        $descripPagos = substr($descripPagos, 0, -2);

                        if ($notasPago != "") {
                            $notasPago = substr($notasPago, 0, -2);
                        }
                    }

                    if ($descripPagos == "") {
                        $informaPagos = $this->dev_model->getTipoPagoRealiVenta($info->trannum);
                        if ($informaPagos != false) {
                            foreach ($informaPagos as $infoPago) {
                                $descripPagos .= $infoPago->descrip;

                                if ($infoPago->notasPago != "" && $infoPago->notasPago != false) {
                                    $notasPago .= $infoPago->notasPago;
                                }
                            }
                        }
                    }

                    if ($info->registro != "") {
                        $registro = $info->registro;
                    } else {
                        $registro = "SIN REGISTRO";
                    }

                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "seriedoc" => $info->serie,
                        "numeroserie" => $info->numero * 1,
                        "doc_dev" => $info->dev_serie . $info->dev_numero,
                        "nit" => $info->nit,
                        "numx" => $info->numx,
                        "numz" => $info->numz,
                        "registro" => $registro,
                        "namecliente" => $info->namecliente,
                        "idclienteauxi" => $info->idclienteauxi,
                        "namesucursal" => $info->namesucursal,
                        "namecaja" => $info->namecaja,
                        "namecentro" => $info->namecentro,
                        "namevendedor" => $info->namevendedor,
                        "valventan" => number_format($totalVenta, 6, '.', ''),
                        "exento" => number_format($exento_doc, 6, '.', ''),
                        "gravado" => number_format($gravado_doc, 6, '.', ''),
                        "iva" => number_format($iva_doc, 6, '.', ''),
                        "retencion" => number_format($retencion, 6, '.', ''),
                        "descuento" => number_format($totalDescuento, 6, '.', ''),
                        "comision" => number_format($totalComision, 6, '.', ''),
                        //"detailFacturas" => $detailFacturas,
                        "estatus" => $info->estatus,
                        "formaPago" => $descripPagos,
                        "notasPago" => $notasPago,
                        "notas_fact" => $info->notas,
                        "referencia" => $info->referencia,
                        "valcosto" => number_format($info->valcosto * -1, 6, '.', ''),
                        "ingresa" => $info->ingresa,
                    );
                    $i++;
                }
            }

            echo json_encode($array);
        }
    }

    //Herramientas de Inventario
    function herramientas_inventario($idApp)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('login/cerrar_sesion');
        } else {
            $this->load->model('configuracion_model');
            $this->load->model('global_model');
            $this->load->model('producto_model');
            $this->load->model('user_model');
            $this->load->model('invtran_model');
            $this->load->model('sucursal_model');
            $this->load->model('compras_model');
            $this->load->model('catalog_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $opcionmenu = $this->configuracion_model->getProCentro($idApp);

            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName,
                'opcionmenu' => $opcionmenu,
            );
            $this->session->set_userdata($resultAppName);
            $this->data['opcion_tipo'] = $opcionmenu;
            $controlador = $this->uri->segment(1);
            $direccion = $controlador;
            $this->data['direccion'] = $direccion;
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
            $this->data['tipos'] = $this->sucursal_model->getTipo();
            $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
            $this->data['centros'] = $this->sucursal_model->viewSucursal();
            $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
            $this->data['lineas'] = $this->producto_model->viewLineas();
            $this->data['tipos_search'] = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
            $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
            $this->data['TProductos'] = $this->catalog_model->getTiposProductos();
            $this->data['listProcentro'] = $this->catalog_model->getData(1)->result();
            $this->load->view('herramientas_inventario', $this->data);
        }
    }

    function herramientas_importar_combos()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])) {
            redirect('login/cerrar_sesion');
        } else {
            $this->load->model('global_model');
            $this->load->model('producto_model');
            $this->load->model('invtran_model');
            $this->load->model('sucursal_model');
            $this->load->model('compras_model');
            $this->load->model('catalog_model');

            $resultAppName = array(
                'appName' => 'Importador de Combos',
                'namePage' => 'Importador de Combos',
            );
            $this->session->set_userdata($resultAppName);

            $direccion = $this->uri->segment(1);
            $this->data['direccion'] = $direccion;
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
            $this->data['tipos'] = $this->sucursal_model->getTipo();
            $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
            $this->data['centros'] = $this->sucursal_model->viewSucursal();
            $this->data['departamentos'] = $this->producto_model->viewDepartamentos();
            $this->data['lineas'] = $this->producto_model->viewLineas();
            $this->data['tipos_search'] = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
            $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
            $this->data['TProductos'] = $this->catalog_model->getTiposProductos();
            $this->data['listProcentro'] = $this->catalog_model->getData(1)->result();
            $this->load->view('mantenimiento_importar_combos', $this->data);
        }
    }

    //Mantenimiento de Orden de Ingreso

    private $Estados = array(
        'En Proceso' => 0,
        'Cerrado' => 1,
        'Anulado' => 9,
    );
    private $SJopciones = [
        array('ID' => 1, 'Name' => 'Código de Barra', 'valor' => false, 'v' => 'barcode', 'ncampo' => true),
        array('ID' => 2, 'Name' => 'Código Interno', 'valor' => false, 'v' => 'idproducto', 'ncampo' => true),
        array('ID' => 3, 'Name' => 'Código Xpos', 'valor' => false, 'v' => 'xpos', 'ncampo' => false),
        array('ID' => 4, 'Name' => 'Modelo', 'valor' => false, 'v' => 'modelo', 'ncampo' => false),
    ];
    private $SIopciones = [
        array('ID' => 1, 'Name' => 'Descripción', 'valor' => false, 'v' => 'descrip', 'ncampo' => false, 'int' => false),
        array('ID' => 2, 'Name' => 'Código Interno', 'valor' => false, 'v' => 'idproducto', 'ncampo' => true, 'int' => true),
        array('ID' => 3, 'Name' => 'Código de Barra', 'valor' => false, 'v' => 'barcode', 'ncampo' => true, 'int' => false),
        array('ID' => 4, 'Name' => 'Código Xpos', 'valor' => false, 'v' => 'xpos', 'ncampo' => false, 'int' => false),
        array('ID' => 5, 'Name' => 'Modelo', 'valor' => false, 'v' => 'modelo', 'ncampo' => false, 'int' => false),
        array('ID' => 6, 'Name' => 'Marca', 'valor' => false, 'v' => 'marca', 'ncampo' => false, 'int' => false),
    ];
    private $opcionesSpecial = [
        array('ID' => 1, 'Name' => 'Descripción', 'v' => 'descrip'),
        array('ID' => 2, 'Name' => 'Marca', 'v' => 'marca'),
        array('ID' => 3, 'Name' => 'Modelo', 'v' => 'modelo'),
        array('ID' => 4, 'Name' => 'Código Xpos', 'v' => 'xpos'),
    ];

    #   ORDEN DE INGRESO NEW
    public function indexOrdenIngreso($idApp)
    {
        if ($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $this->load->model('global_model');
            $controlador = $this->uri->segment(1);
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
            $this->data['opcsbusqueda'] = $this->SJopciones;
            $this->data['factual'] = date_create()->format('Y-m-d');
            $this->load->view('mantenimiento_orden_ingreso', $this->data);
        }
    }

    public function containerNumber()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $this->load->model('dev_model');

            $currentYear = $this->input->post('currentYear');
            $idcentro = $this->input->post('centro');

            $startDate = $currentYear . '-01-01';
            $finishDate = $currentYear . '-12-31';
            $rowsQty = $this->dev_model->getCountOfContainers($startDate, $finishDate);

            if ($rowsQty <= 9) {
                $consecutiveNumber = $currentYear . '0' . ($rowsQty + 1);
            } else {
                $consecutiveNumber = $currentYear . ($rowsQty + 1);
            }
            //print_r($consecutiveNumber);

            $array = array();
            $array = array("consecutiveNumber" => $consecutiveNumber);

            echo json_encode($array);
        }
    }

    public function setOrdenIngreso()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $containerNumber = $this->input->post('containerNumber');
            $fecha = $this->input->post('fechaIngreso');
            $packageQty = $this->input->post('packageQty');
            $totalWgt = $this->input->post('totalWgt');
            $shippingInfo = $this->input->post('shippingInfo');
            $notas = $this->input->post('notas');
            $idcentro = $this->input->post('centro');
            $agrupa = 'OI';
            $estado = 0;

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->setOrdenIngreso($idcentro, $containerNumber, $fecha, $packageQty, $totalWgt, $shippingInfo, $notas, $estado, $agrupa);

            if ($dataResult) {
                $resultArray[] = array('valido' => true, 'datos' => $dataResult);
            } else {
                $resultArray[] = array('valido' => false);
            }

            echo json_encode($resultArray);
        }
    }

    function getOrdenIngreso()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $idcentro = $this->input->post('centro');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->getOrdenIngreso($idcentro));
        }
    }

    function setRegistroPorBulto()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $trannum = $this->input->post('trannum');
            $itemLine = $this->input->post('itemLine');
            $tipo = 0;
            //$idcentro = $this->input->post('centro');
            $peso = 0;

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->setRegistroPorBulto($trannum, $itemLine, $peso, $tipo);

            if ($dataResult) {
                $resultArray[] = array('valido' => true, 'datos' => $dataResult);
            } else {
                $resultArray[] = array('valido' => false);
            }

            echo json_encode($resultArray);
        }
    }

    function getRegistrosPorBulto()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $trannum = $this->input->post('trannum');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->getRegistrosPorBulto($trannum));
        }
    }

    function updatePackageWgt()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $idrec = $this->input->post('idrec');
            $peso = $this->input->post('tasa');

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->updatePackageWgt($idrec, $peso);

            if ($dataResult) {
                $resultArray[] = array('valido' => true, 'datos' => $dataResult);
            } else {
                $resultArray[] = array('valido' => false);
            }

            echo json_encode($resultArray);
        }
    }

    #ORDEN DE REVISION
    function indexOrdenRevision($idApp)
    {
        if ($this->validatePermiso()) {
            $this->load->model('global_model');
            $this->load->model('compras_model');
            $this->load->model('configuracion_model');

            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);

            $controlador = $this->uri->segment(1);
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
            $this->data['opcsbusqueda'] = $this->SJopciones;
            $this->data['compras'] = $this->compras_model->getTiposCompras('CO');
            $this->data['proveedores'] = $this->compras_model->getListProveedores(1);
            $this->data['factual'] = date_create()->format('Y-m-d');

            $this->load->view('mantenimiento_orden_revision', $this->data);
        }
    }

    function getInfoContainer()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $idcentro = $this->input->post('centro');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->getInfoContainer($idcentro));
        }
    }

    function getDepartments()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $idcentro = $this->input->post('centro');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->getDepartments($idcentro));
        }
    }

    function getProducts()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $idcentro = $this->input->post('centro');
            $idcatalogo = $this->input->post('idcatalogo');
            $itemLine = $this->input->post('itemLine');
            $transNumber = $this->input->post('transNumber');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->getProducts($idcentro, $idcatalogo, $itemLine, $transNumber));
        }
    }

    function setPackageProducts()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $trannum = $this->input->post('transNumber');
            $itemLine = $this->input->post('itemLine');
            $idProduct = $this->input->post('idProduct');
            $descrip = $this->input->post('descrip');
            $cantidad = $this->input->post('cantidad');
            $um = $this->input->post('um');
            $precioNeto = $this->input->post('precioNeto');

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->setPackageProducts($trannum, $itemLine, $idProduct, $descrip, $cantidad, $um, $precioNeto);

            if ($dataResult) {
                $resultArray[] = array('valido' => true, 'datos' => $dataResult);
            } else {
                $resultArray[] = array('valido' => false);
            }

            echo json_encode($resultArray);
        }
    }

    function getProductQuantity()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $transNumber = $this->input->post('transNumber');
            $itemLine = $this->input->post('itemLine');
            $productId = $this->input->post('idProduct');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->getProductQuantity($itemLine, $transNumber, $productId));
        }
    }

    function updatePackageProductsOnDetails()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $trannum = $this->input->post('transNumber');
            $itemLine = $this->input->post('itemLine');
            $idProduct = $this->input->post('idProduct');
            $cantidad = $this->input->post('cantidad');

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->updatePackageProductsOnDetails($trannum, $itemLine, $idProduct, $cantidad);

            if ($dataResult) {
                $resultArray[] = array('valido' => true, 'datos' => $dataResult);
            } else {
                $resultArray[] = array('valido' => false);
            }

            echo json_encode($resultArray);
        }
    }

    function deleteProductQtyOnDetails()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $trannum = $this->input->post('transNumber');
            $itemLine = $this->input->post('itemLine');
            $idProduct = $this->input->post('idProduct');

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->deleteProductQtyOnDetails($trannum, $itemLine, $idProduct);

            if ($dataResult) {
                $resultArray[] = array('valido' => $dataResult);
            } else {
                $resultArray[] = array('valido' => $dataResult);
            }

            echo json_encode($resultArray);
        }
    }

    function getPackageInformation()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $trannum = $this->input->post('transNumber');
            $itemLine = $this->input->post('itemLine');

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->getPackageInformation($trannum, $itemLine);

            if ($dataResult) {
                $resultArray = array('valido' => true, 'datos' => $dataResult);
            } else {
                $resultArray = array('valido' => false, 'datos' => false);
            }

            echo json_encode($resultArray);
        }
    }

    function updateProductQuantity()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $recNumber = $this->input->post('recNumber');
            $cantidad = $this->input->post('cantidad');

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->updateProductQuantity($recNumber, $cantidad);

            if ($dataResult) {
                $resultArray[] = array('valido' => true, 'datos' => $dataResult);
            } else {
                $resultArray[] = array('valido' => false);
            }

            echo json_encode($resultArray);
        }
    }

    function deleteProducts()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $recNumber = $this->input->post('recNumber');

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->deleteProducts($recNumber);

            if ($dataResult) {
                $resultArray[] = array('valido' => $dataResult);
            } else {
                $resultArray[] = array('valido' => $dataResult);
            }

            echo json_encode($resultArray);
        }
    }

    function verifyIfProductsCanBeUpdated()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $idcentro = $this->input->post('centro');
            $transNumber = $this->input->post('transNumber');

            $this->load->model('dev_model');
            echo json_encode($this->dev_model->verifyIfProductsCanBeUpdated($idcentro, $transNumber));
        }
    }

    function updateContainerStatus()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);

            $transNumber = $this->input->post('transNumber');
            $status = $this->input->post('status');

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->updateContainerStatus($transNumber, $status);

            if ($dataResult) {
                $resultArray[] = array('valido' => true, 'datos' => $dataResult);
            } else {
                $resultArray[] = array('valido' => false);
            }

            echo json_encode($resultArray);
        }
    }

    function generarCompraPacas()
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            $trannum = $this->input->post('trannum');
            $itemline = $this->input->post('itemline');
            $nameContainer = $this->input->post('nameContainer');
            $fecha = $this->input->post('fecha');
            $proveedor = $this->input->post('proveedor');
            $tipoCompra = $this->input->post('tipoCompra');
            $notas = $this->input->post('notas');

            $this->load->model('dev_model');
            $dataResult = $this->dev_model->generarCompraPacas($trannum, $itemline, $nameContainer, $fecha, $proveedor, $tipoCompra, $notas);

            if ($dataResult[0]) {
                $resultArray = array('valido' => true, 'datos' => $dataResult);
            } else {
                $resultArray = array('valido' => false, 'datos' => $dataResult[1]);
            }

            echo json_encode($resultArray);
        }
    }

    #PDF Facturacion Electronica
    function electronicBillsOld($trannum, $idYear = 0, $docToSend = 0)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('login/cerrar_sesion');
        } else {
            $this->load->model('dev_model');
            $this->load->model('dte_model');
            $this->load->model('global_model');
            $this->load->model('pedclientes_model');
            $this->load->model('ventas_model');

            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Documento Tributario Electrónico');
            $pdf->SetSubject('Documento Tributario Electrónico');
            $pdf->SetMargins(7.5, 15, 9, true);
            $pdf->SetAutoPageBreak(TRUE, 7);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
            $pdf->SetFont('helvetica', '', 7.5, '', true);
            $pdf->addPage('P', 'LETTER');

            $x = 3;
            $y = 3;

            $informacion = $this->dev_model->electronicBills($trannum, $idYear);

            foreach ($informacion as $info) {
                $jsonInfo = $info['jsonDoc'];
                $sRecepcion = $info['sRecepcion'];
                $respHacienda = $info['respHacienda'];
                $firmaJson = $info['firmaJson'];
            }

            if (isset($jsonInfo['identificacion']))
                $identificacion = $jsonInfo['identificacion'];
            if (isset($jsonInfo['documentoRelacionado']))
                $documentoRelacionado = $jsonInfo['documentoRelacionado'];
            if (isset($jsonInfo['emisor']))
                $emisor = $jsonInfo['emisor'];
            if (isset($emisor['direccion']))
                $direcEmisor = $emisor['direccion'];
            if (isset($jsonInfo['receptor']))
                $receptor = $jsonInfo['receptor'];
            if (isset($jsonInfo['sujetoExcluido']))
                $sujetoExcluido = $jsonInfo['sujetoExcluido'];
            if (isset($receptor['direccion']))
                $direcReceptor = $receptor['direccion'];
            if (isset($sujetoExcluido['direccion']))
                $direcRsujetoExcluido = $sujetoExcluido['direccion'];
            if (isset($jsonInfo['ventaTercero']))
                $ventaTercero = $jsonInfo['ventaTercero'];
            if (isset($jsonInfo['cuerpoDocumento']))
                $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
            if (isset($jsonInfo['resumen']))
                $resumen = $jsonInfo['resumen'];
            if (isset($resumen['tributos']))
                $tributos = $resumen['tributos'];
            if (isset($jsonInfo['extension']))
                $extension = $jsonInfo['extension'];
            if (isset($jsonInfo['apendice']))
                $apendice = $jsonInfo['apendice'];
            $tipoDocumento = '';

            $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $nComercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
            $categoria = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
            $nameImagen = $this->pedclientes_model->getnameImg();
            $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
            $modeloFacturacion = explode(" ", $modFac['descrip']);
            $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
            $tipoTransmision = explode(" ", $tipoTrans['descrip']);
            $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
            $tipoDocumento = $identificacion['tipoDte'];
            $nameVendedor = '';

            if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                $infoFact = $this->dev_model->getTipoDocumentoTablaIVA($trannum, $idYear);
                $idClase = $infoFact->doc_tipo;
            } else {
                $infoFact = $this->ventas_model->getDatosFactura($trannum);
                foreach ($infoFact as $info) {
                    $idClase = $info->idclase;
                    $nameSucursal = $info->nameSucursal;
                    $nameVendedor = $info->nameVendedor;
                    if ($tipoDocumento == '03') {
                        $extension['observaciones'] = $info->notas;
                    }
                }
            }


            if ($this->session->userdata('idaccount') == '45357159') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalDTE/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalDTE/' . $trannum . '/' . $idYear . '/' . $docToSend);
            }

            if ($this->session->userdata('idaccount') == '1100831') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
            }

            if ($this->session->userdata('idaccount') == '2703140') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
            }

            if ($this->session->userdata('idaccount') == '2305582') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
            }

            if ($this->session->userdata('idaccount') == '593230') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);
            }

            if ($tipoDocumento == '01')
                redirect(base_url() . 'Dev/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend);

            /* --- INICIO SECCION CABECERAS --- */

            $emisorEstab = array();
            if (isset($emisor['tipoEstablecimiento'])) {
                $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
            }

            if (!isset($emisorEstab['descrip']))
                $emisorEstab['descrip'] = '';

            if ($this->session->userdata('idaccount') == '2922210') {
                $header1 = '
                        <table style="width:40%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height:0px;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%; text-decoration: underline;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112) . '</td>
                            </tr>';
                if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'], 0, 49) . '</td>
                                </tr>';
                } else {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                                </tr>';
                }
                $header1 .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                            </tr>';
                if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 50) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 50) . '</td>
                                </tr>';
                } else {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                                </tr>';
                }
                $header1 .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                            </tr>';
                if ($tipoDocumento == '11') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Recinto Fiscal: ' . substr($emisor['recintoFiscal'], 0, 35) . '</td>
                                            </tr>
                                            <tr style="width:100%; padding:0px;">
                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Regimen de Exportación: ' . substr($emisor['regimen'], 0, 32) . '</td>
                                            </tr>';
                }
                $header1 .= '</table>';
            } else {
                $header1 = '
                        <table style="width:40%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; text-align:left;"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="' . FCPATH . 'img_cuentas/' . $this->session->userdata('diraccount') . '/' . $nameImagen . '"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112) . '</td>
                            </tr>';
                if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'], 0, 49) . '</td>
                                </tr>';
                } else {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                                </tr>';
                }
                $header1 .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                            </tr>';
                if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 50) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 50) . '</td>
                                </tr>';
                } else {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                                </tr>';
                }
                $header1 .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                            </tr>';
                if ($tipoDocumento == '11') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Recinto Fiscal: ' . substr($emisor['recintoFiscal'], 0, 35) . '</td>
                                            </tr>
                                            <tr style="width:100%; padding:0px;">
                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Regimen de Exportación: ' . substr($emisor['regimen'], 0, 32) . '</td>
                                            </tr>';
                }
                $header1 .= '</table>';
            }

            $pdf->SetXY(4.5 + $x, 10.5 + $y);
            $pdf->writeHTML($header1, true, false, true, false, '');

            $header2 = '
                    <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['numeroControl'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]) . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . $identificacion['version'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($tipoTransmision[array_key_last($tipoTransmision)]) . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . date_format(date_create($identificacion['fecEmi']), "d/m/Y") . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . date_format(date_create($identificacion['horEmi']), "h:i:s A") . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

            $nControlP = explode('-', $identificacion['numeroControl']);

            $header2 .= '
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . (int) $nControlP[3] . '</td>
                            </tr>';
            $header2 .= '</table>';

            $pdf->SetXY(95 + $x, 10.5 + $y);
            $pdf->writeHTML($header2, true, false, true, false, '');

            // * 98x98 is the size of the QR image you want to generate.
            // * the data is the url-encoded string you want to change into a QR code.
            // * URL to create the url-encoded -> https://developers.google.com/chart/interactive/docs/querylanguage?hl=es-419#plainText
            // * the choe is the (optional) encoding.
            // * URL con la api anterior <img src="https://chart.googleapis.com/chart?chs=98x98&cht=qr&chl=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D'.$identificacion['ambiente'].'%26codGen%3D'.$identificacion['codigoGeneracion'].'%26fechaEmi%3D'.$identificacion['fecEmi'].'" title="Link to Google.com" />
            // * URL con la api anterior <img src="https://api.qrserver.com/v1/create-qr-code/?data=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D'.$identificacion['ambiente'].'%26codGen%3D'.$identificacion['codigoGeneracion'].'%26fechaEmi%3D'.$identificacion['fecEmi'].'&size=79x79" />
            // * URL con la api anterior <img src="https://api.qrserver.com/v1/create-qr-code/?data='.$identificacion['codigoGeneracion'].'&size=60x60" />
            // * URL con la api anterior <img src="https://api.qrserver.com/v1/create-qr-code/?data='.$sRecepcion.'&size=60x60" />
            // * URL con la api anterior <img src="https://api.qrserver.com/v1/create-qr-code/?data='.$identificacion['numeroControl'].'&size=60x60" />

            // Data to encode in the QR code
            //$urlQR = "https://admin.factura.gob.sv/consultaPublica?ambiente=".$identificacion['ambiente']."&codGen=".$identificacion['codigoGeneracion']."&fechaEmi=".$identificacion['fecEmi']."";

            /*$qrCode = '
            <table style="width:100%; padding:0px;">
                <tr style="width:100%; padding:0px;">
                    <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                        <img src="https://chart.googleapis.com/chart?chs=98x98&cht=qr&chl=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D'.$identificacion['ambiente'].'%26codGen%3D'.$identificacion['codigoGeneracion'].'%26fechaEmi%3D'.$identificacion['fecEmi'].'" />
                    </td>
                    <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                        <br><br>
                        <img src="https://chart.googleapis.com/chart?chs=96x96&cht=qr&chl='.$identificacion['codigoGeneracion'].'" />
                    </td>
                    <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                        <br><br>
                        <img src="https://chart.googleapis.com/chart?chs=96x96&cht=qr&chl='.$sRecepcion.'" />
                    </td>
                    <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                        <br><br>
                        <img src="https://chart.googleapis.com/chart?chs=96x96&cht=qr&chl='.$identificacion['numeroControl'].'" />
                    </td>
                </tr>
            </table>';*/

            // Generate QR code
            //$qrCodeText = 'https://example.com'; // URL or any text you want to encode

            $qrCode = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                                <img src="https://api.qrserver.com/v1/create-qr-code/?data=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D' . $identificacion['ambiente'] . '%26codGen%3D' . $identificacion['codigoGeneracion'] . '%26fechaEmi%3D' . $identificacion['fecEmi'] . '&size=79x79" />
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $identificacion['codigoGeneracion'] . '&size=60x60" />
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $sRecepcion . '&size=60x60" />
                            </td>
                            <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $identificacion['numeroControl'] . '&size=60x60" />
                            </td>
                        </tr>
                    </table>';

            $pdf->SetXY(95 + $x, 40.5 + $y);
            $pdf->writeHTML($qrCode, true, false, true, false, '');
            $qrCodeLabel = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <p>Portal de Hacienda</p>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <p>Cód. Generación</p>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <p>Sello Recibido</p>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <p>N° de Control</p>
                            </td>
                        </tr>
                    </table>';

            $pdf->SetXY(95 + $x, 59.5 + $y);
            $pdf->writeHTML($qrCodeLabel, true, false, true, false, '');

            if (isset($direcReceptor)) {
                //$receptorMun = $this->dte_model->getDescripCodigoDTE($direcReceptor['municipio'],'CAT-013');
                $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'], $direcReceptor['departamento']);
                //var_dump($receptorMun);
                //$receptorDep = $this->dte_model->getDescripCodigoDTE($direcReceptor['departamento'],'CAT-012');
                $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
            } else {
                $receptorMun = array();
                $receptorDep = array();
            }

            if (isset($direcRsujetoExcluido)) {
                //$receptorMun = $this->dte_model->getDescripCodigoDTE($direcReceptor['municipio'],'CAT-013');
                $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'], $direcRsujetoExcluido['departamento']);
                //var_dump($receptorMun);
                //$receptorDep = $this->dte_model->getDescripCodigoDTE($direcReceptor['departamento'],'CAT-012');
                $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
            } else {
                $sujetoExcluidoMun = array();
                $sujetoExcluidoDep = array();
            }

            $receptorDoc = array();
            if (isset($receptor['tipoDocumento'])) {
                if ($receptor['tipoDocumento'] != '') {
                    $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'], 'CAT-022');
                }
            }

            $sujetoExcluidoDoc = array();
            if (isset($sujetoExcluido['tipoDocumento'])) {
                if ($sujetoExcluido['tipoDocumento'] != '') {
                    $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'], 'CAT-022');
                }
            }

            if (!isset($receptorDoc['descrip'])) {
                $receptorDoc['descrip'] = 'Doc. Identificación';
            }

            if (!isset($sujetoExcluidoDoc['descrip'])) {
                $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
            }

            if (!isset($receptor['nombreComercial'])) {
                $receptor['nombreComercial'] = '';
            }

            if (!isset($direcReceptor['complemento'])) {
                $direcReceptor['complemento'] = '';
            }

            if (!isset($direcRsujetoExcluido['complemento'])) {
                $direcRsujetoExcluido['complemento'] = '';
            }

            if (!isset($receptor['correo'])) {
                $receptor['correo'] = '';
            }

            $condicionPago = array();
            if (isset($resumen['condicionOperacion'])) {
                if ($resumen['condicionOperacion'] != '') {
                    $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'], 'CAT-016');
                }
            } else {
                $condicionPago['descrip'] = '';
            }

            if (!isset($extension['observaciones'])) {
                $extension['observaciones'] = '';
            }

            if (!isset($extension['nombEntrega'])) {
                $extension['nombEntrega'] = '';
            }

            if (!isset($extension['docuEntrega'])) {
                $extension['docuEntrega'] = '';
            }

            if (!isset($extension['nombRecibe'])) {
                $extension['nombRecibe'] = '';
            }

            if (!isset($extension['docuRecibe'])) {
                $extension['docuRecibe'] = '';
            }

            $header3 = '';
            //$tipoDocumento ='14';
            // header3
            if ($tipoDocumento == '03') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:87%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 78) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($direcReceptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                    $header3 .= '
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorDep as $depto) {
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Moneda:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19) . '</td>
                                </tr>
                            </table>';
            }
            if ($tipoDocumento == '01') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Nombre Comercial:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($receptor['nombreComercial'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">' . $receptorDoc['descrip'] . ':</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['numDocumento'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Correo:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">NRC:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . mb_substr(mb_strtoupper($direcReceptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Teléfono:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                    if (!isset($muni['municipio']))
                        $muni['municipio'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Municipio:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Forma pago:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorDep as $depto) {
                    if (!isset($depto['depto']))
                        $depto['depto'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Departamento:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Moneda:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19) . '</td>
                                </tr>
                            </table>';
            }
            if ($tipoDocumento == '11') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Nombre Comercial:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($receptor['nombreComercial'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">' . $receptorDoc['descrip'] . ':</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['numDocumento'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Act. Económica:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr($receptor['descActividad'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">País destino:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nombrePais'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . mb_substr(mb_strtoupper($receptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                </tr>
                            </table>';
            }
            if ($tipoDocumento == '05') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($direcReceptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                    if (!isset($muni['municipio']))
                        $muni['municipio'] = '';
                    $header3 .= '
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorDep as $depto) {
                    if (!isset($depto['depto']))
                        $depto['depto'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '</tr></table>';
            }
            if ($tipoDocumento == '14') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">' . $sujetoExcluidoDoc['descrip'] . ':</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr($sujetoExcluido['numDocumento'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Teléfono:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($sujetoExcluido['telefono'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . mb_substr(mb_strtoupper($direcRsujetoExcluido['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($sujetoExcluidoMun as $muni) {
                    if (!isset($muni['municipio']))
                        $muni['municipio'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Municipio:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                    break;
                }
                $header3 .= '</tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($sujetoExcluidoDep as $depto) {
                    if (!isset($depto['depto']))
                        $depto['depto'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Departamento:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                    break;
                }
                $header3 .= '</tr>
                            </table>';
            }
            if ($tipoDocumento == '06') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($direcReceptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                    if (!isset($muni['municipio']))
                        $muni['municipio'] = '';
                    $header3 .= '
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorDep as $depto) {
                    if (!isset($depto['depto']))
                        $depto['depto'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '</tr></table>';
            }
            if ($tipoDocumento == '07') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Nombre Comercial:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($receptor['nombreComercial'], 'UTF-8'), 0, 64) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">' . $receptorDoc['descrip'] . ':</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['numDocumento'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($direcReceptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                    if (!isset($muni['municipio'])) {
                        $muni['municipio'] = '';
                    }
                    $header3 .= '
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '</tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorDep as $depto) {
                    if (!isset($depto['depto'])) {
                        $depto['depto'] = '';
                    }
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '</tr></table>';
            }

            // header3

            if ($tipoDocumento == '11') {
                $pdf->SetXY(4.5 + $x, 75.5 + $y);
                $pdf->writeHTML($header3, true, false, true, false, '');
            } else {
                $pdf->SetXY(4.5 + $x, 70.5 + $y);
                $pdf->writeHTML($header3, true, false, true, false, '');
            }


            /* --- FIN SECCION CABECERAS --- */

            //$tipoDocumento = '01';

            if ($tipoDocumento == '03') {
                // INICIO CUERPO DE DOCUMENTO CREDITO FISCAL

                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No. Item</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Código</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:44%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $ventaNosj = number_format(floatval($body['ventaNoSuj']), 4, '.', ',');
                        $ventaExenta = number_format(floatval($body['ventaExenta']), 4, '.', ',');
                        if ($ventaNosj == '0') {
                            $ventaNosj = '';
                        }
                        if ($ventaExenta == '0') {
                            $ventaExenta = '';
                        }
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . $body['codigo'] . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:43%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($body['precioUni'], 6, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaNosj . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaExenta . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format(floatval($body['ventaGravada']), 4, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:62%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>';
                if ($extension['observaciones'] == '') {
                    $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>';
                } else if (strlen(trim($extension['observaciones'])) <= 86) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                            </tr>';
                }

                $extention .= '
                        </table>';

                $pdf->SetXY(4.5 + $x, 230 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total descuentos</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalDescu'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';
                foreach ($tributos as $trib) {
                    $totals .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                </tr>';
                }
                $totals .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total otros montos no afectos</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL A PAGAR</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 230 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 262 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //$pdf->setHtmlFooter($extention.$totals);
                //$pdf->setPrintFooter(true);

                // FIN CUERPO DE DOCUMENTO CREDITO FISCAL
            }

            if ($tipoDocumento == '01') {
                //INICIO CUERPO DE DOCUMENTO FACTURA CONSUMIDOR FINAL
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                $maxlines = 15;

                $bodyDoc = '
                            <table style="width:55%; padding:0px; border: 0.1px solid #000">
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9.8%; border: 0.1px solid #000; background-color: #CFCFCF;">N°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:12%; border: 0.1px solid #000; background-color: #CFCFCF;">Cantidad</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9.8%; border: 0.1px solid #000; background-color: #CFCFCF;">Unidad</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:53%; border: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:15.4%; border: 0.1px solid #000; background-color: #CFCFCF;">Precio unitario</th>
                                </tr>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $ventaNosj = number_format(floatval($body['ventaNoSuj']), 2, '.', ',');
                        $ventaExenta = number_format(floatval($body['ventaExenta']), 2, '.', ',');
                        if ($ventaNosj == '0') {
                            $ventaNosj = '';
                        }
                        if ($ventaExenta == '0') {
                            $ventaExenta = '';
                        }
                        $bodyDoc .= '<tr style="width:55%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:9.8%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:12%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:9.8%;">' . $body['tipoItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:0.2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:52.8%;">' . trim($body['descripcion']) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:15.2%;">' . number_format($body['precioUni'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:0.2%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < $maxlines){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; ">
                            <tr style="width:100%; padding:0px;">
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:30%; border: 0.1px solid #000; background-color: #CFCFCF;">Otros montos no afectos</th>
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:23.8%; border: 0.1px solid #000; background-color: #CFCFCF;">Descuento por ítem</th>
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:15.4%; border: 0.1px solid #000; background-color: #CFCFCF;">Ventas No Sujetas</th>
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:15.4%; border: 0.1px solid #000; background-color: #CFCFCF;">Ventas Exentas</th>
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:15.4%; border: 0.1px solid #000; background-color: #CFCFCF;">Ventas Gravadas</th>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:52.9%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Suma de Ventas:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format(floatval($resumen['totalGravada']), 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:100%;"></th>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Sumatoria de Ventas:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Monto global Desc., Rebajas y otras ventas no<br>sujetas:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['descuNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Monto global Desc., Rebajas y otras ventas<br>exentas:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['descuExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Monto global Desc., Rebajas y otras ventas<br>gravadas:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['descuGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Nombre del:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['descuGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>';
                if (isset($tributos)) {
                    foreach ($tributos as $trib) {
                        $totals .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">' . $trib["descripcion"] . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                                    </tr>';
                    }
                }
                $totals .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Sub - Total:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">IVA Retenido:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Retencion Renta:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['reteRenta'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Monto Total de la Operación:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Total Otros Montos No Afectos:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Total A Pagar:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(116.2 + $x, 93.5 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:100%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Valor en letras:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:81%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . trim($resumen['totalLetras']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Observaciones</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:81%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . substr(trim($extension['observaciones']), 0, 50) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Nombre entrega:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%; border-top: 0.1px solid #000; background-color: #CFCFCF;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 50) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; background-color: #CFCFCF;">No Documento:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:21%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . $extension['docuEntrega'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Nombre recibe:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 50) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">No Documento:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:21%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . $extension['docuRecibe'] . '</td>
                            </tr>
                        </table>';

                $pdf->SetXY(4.5 + $x, 240 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 257 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                /* --- FIN SECCION PRODUCTOS --- */
                //FIN CUERPO DE DOCUMENTO FACTURA CONSUMIDOR FINAL
            }

            if ($tipoDocumento == '05') {
                //INICIO CUERPO DE DOCUMENTO NOTA DE CREDITO
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">N°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:44%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descuento por Item</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $ventaNosj = number_format(floatval($body['ventaNoSuj']), 4, '.', ',');
                        $ventaExenta = number_format(floatval($body['ventaExenta']), 4, '.', ',');
                        if ($ventaNosj == '0') {
                            $ventaNosj = '';
                        }
                        if ($ventaExenta == '0') {
                            $ventaExenta = '';
                        }
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:43%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($body['precioUni'], 6, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . $body['montoDescu'] . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaNosj . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaExenta . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format(floatval($body['ventaGravada']), 4, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:62%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>';
                if ($extension['observaciones'] == '') {
                    $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>';
                } else if (strlen(trim($extension['observaciones'])) <= 86) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                            </tr>';
                }

                $extention .= '
                        </table>';

                $pdf->SetXY(4.5 + $x, 230 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas no sujetas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas exentas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas gravadas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';
                foreach ($tributos as $trib) {
                    $totals .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                </tr>';
                }
                $totals .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['montoTotalOperacion'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL A PAGAR</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['montoTotalOperacion'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 230 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 265 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //$pdf->setHtmlFooter($extention.$totals);
                //$pdf->setPrintFooter(true);

                //FIN CUERPO DE DOCUMENTO NOTA DE CREDITO
            }

            if ($tipoDocumento == '11') {
                //INICIO CUERPO DE DOCUMENTO FACTURAS DE EXPORTACION
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:6%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cantidad</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:54%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:7%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descuento por Item</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Otros Montos no Afectos</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas Afectas</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $montoDescu = number_format(floatval($body['montoDescu']), 2, '.', ',');
                        $noGravado = number_format(floatval($body['noGravado']), 2, '.', ',');
                        if ($montoDescu == '0') {
                            $montoDescu = '';
                        }
                        if ($noGravado == '0') {
                            $noGravado = '';
                        }
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:53%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($body['precioUni'], 2, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:7%;">' . $montoDescu . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . $noGravado . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format(floatval($body['ventaGravada']), 2, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:62%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:30%;">Condición de la Operación</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:69%;">' . substr(mb_strtoupper($condicionPago['descrip'], 'UTF-8'), 0, 35) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:25%;">Descripción Incoterms</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:74%;">' . substr(mb_strtoupper($resumen['descIncoterms'], 'UTF-8'), 0, 40) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>';
                if ($resumen['observaciones'] == '') {
                    $extention .= '
                                    <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                    </tr>
                                    <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                    </tr>';
                } else if (strlen(trim($resumen['observaciones'])) <= 86) {
                    $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($resumen['observaciones']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>';
                } else if (strlen(trim($resumen['observaciones'])) > 86 && strlen(trim($resumen['observaciones'])) <= 172) {
                    $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . substr(trim($resumen['observaciones']), 0, 172) . '</td>
                                </tr>';
                }

                $extention .= '
                        </table>';

                $pdf->SetXY(4.5 + $x, 230 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%; border-top: 0.1px solid #000;">Total de Operaciones Afectas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000;">' . number_format($resumen['montoTotalOperacion'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto Global de Descuento</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalDescu'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Seguro</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['seguro'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Flete</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['flete'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total otros montos no afectos</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL A PAGAR</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 230 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 262 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //FIN CUERPO DE DOCUMENTO FACTURAS DE EXPORTACION
            }

            if ($tipoDocumento == '14') {
                //INICIO CUERPO DE DOCUMENTO FACTURA SUJETO EXCLUIDO
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:6%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">N°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:6%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:57%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:11%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descuento por Item</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas $</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . number_format($body['precioUni'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;">' . $body['montoDescu'] . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . number_format(floatval($body['compra']), 2, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:62%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:30%;">Condición de la Operación</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:69%;">' . substr(mb_strtoupper($condicionPago['descrip'], 'UTF-8'), 0, 35) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . substr(trim($resumen['observaciones']), 0, 86) . '</td>
                                </tr>
                        </table>';

                $pdf->SetXY(4.5 + $x, 230 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%; border-top: 0.1px solid #000;">Suma total de operaciones</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-top: 0.1px solid #000;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000;">' . number_format($resumen['totalCompra'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL A PAGAR</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 230 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 262 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //$pdf->setHtmlFooter($extention.$totals);
                //$pdf->setPrintFooter(true);

                //FIN CUERPO DE DOCUMENTO FACTURA SUJETO EXCLUIDO
            }

            if ($tipoDocumento == '06') {
                //INICIO CUERPO DE DOCUMENTO NOTA DE DEBITO
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">N°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:39%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descuento por Item</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $ventaNosj = number_format(floatval($body['ventaNoSuj']), 2, '.', ',');
                        $ventaExenta = number_format(floatval($body['ventaExenta']), 2, '.', ',');
                        if ($ventaNosj == '0') {
                            $ventaNosj = '';
                        }
                        if ($ventaExenta == '0') {
                            $ventaExenta = '';
                        }
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:38%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($body['precioUni'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . $body['montoDescu'] . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaNosj . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaExenta . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format(floatval($body['ventaGravada']), 2, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:62%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>';
                if ($extension['observaciones'] == '') {
                    $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>';
                } else if (strlen(trim($extension['observaciones'])) <= 86) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                            </tr>';
                }

                $extention .= '
                        </table>';

                $pdf->SetXY(4.5 + $x, 230 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas no sujetas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas exentas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas gravadas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';
                foreach ($tributos as $trib) {
                    $totals .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                </tr>';
                }
                $totals .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL A PAGAR</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 230 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 262 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //$pdf->setHtmlFooter($extention.$totals);
                //$pdf->setPrintFooter(true);

                //FIN CUERPO DE DOCUMENTO NOTA DE DEBITO
            }

            if ($tipoDocumento == '07') {
                //INICIO CUERPO DE DOCUMENTO COMPROBANTE DE RETENCIÓN
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">N°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:12%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Tipo Doc. Relacionado</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:13%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">N° del Doc. Relacionado</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Fecha del Doc.</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:40%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripcion</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:11%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Monto Sujeto a Retención</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">IVA Retenido</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $relacDoc = $this->dte_model->getDescripCodigoDTE($body['tipoDte'], 'CAT-022');
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;">' . $relacDoc['descrip'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:13%;">' . $body['numDocumento'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . date_format(date_create($body['fechaEmision']), "d/m/Y") . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;">' . $body['montoSujetoGrav'] . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . number_format(floatval($body['ivaRetenido']), 2, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 96.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:100%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Valor en letras:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:81%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . trim($resumen['totalIVAretenidoLetras']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Observaciones</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:81%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . substr(trim($extension['observaciones']), 0, 50) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Nombre entrega:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%; border-top: 0.1px solid #000; background-color: #CFCFCF;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 50) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; background-color: #CFCFCF;">No Documento:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:21%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . $extension['docuEntrega'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Nombre recibe:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 50) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">No Documento:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:21%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . $extension['docuRecibe'] . '</td>
                            </tr>
                        </table>';

                $pdf->SetXY(4.5 + $x, 233 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%; border-top: 0.1px solid #000;">Total Monto Sujeto a Retención</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-top: 0.1px solid #000;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000;">' . number_format($resumen['totalSujetoRetencion'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL IVA RETENIDO</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['totalIVAretenido'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 233 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 262 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //$pdf->setHtmlFooter($extention.$totals);
                //$pdf->setPrintFooter(true);
                //FIN CUERPO DE DOCUMENTO COMPROBANTE DE RETENCIÓN
            }

            /* --- GENERACION DE PDF --- */

            $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'] . '.pdf');
            //$fullpath = $_SERVER['DOCUMENT_ROOT']."/".$nombre_archivo;

            $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT'] . "dte_files", '/') . "/";

            if (!is_dir($destinationFolder)) {
                mkdir($destinationFolder, 0777, true);
            }

            $fullpath = $destinationFolder . $nombre_archivo;

            /*
             *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
             *D: send to the browser and force a file download with the name given by name.
             *F: save to a local server file with the name given by name.
             *S: return the document as a string. name is ignored.
             *FI: equivalent to F + I option
             *FD: equivalent to F + D option
             */

            //$docToSend = 1;

            if ($docToSend == 0) {
                $pdf->Output($nombre_archivo, 'I');
            } else {
                $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                //$pdf->Output($nombre_archivo, 'I');

                if ($infoDoc->correo != '') {
                    $pdf->Output($fullpath, 'F');
                    $docIntern = (int) $nControlP[3];
                    $emiDate = date_format(date_create($identificacion['fecEmi']), "d/m/Y");

                    if (isset($receptor['nombre']))
                        $nameCliente = mb_strtoupper($receptor['nombre'], 'UTF-8');
                    if (isset($sujetoExcluido['nombre']))
                        $nameCliente = mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8');

                    $jsonFile = $this->createJsonFile($jsonInfo, $identificacion['codigoGeneracion'], $respHacienda, $firmaJson);
                    $response = $this->sendEmailWithPdf($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear);
                    if ($response == true) {
                        $title = 'Correo Enviado';
                        $bodyMsg = 'DTE enviado exitosamente a la direccion de correo <b style=\'color: #79bd53;\'>' . $infoDoc->correo . '</b>';
                        $type = 'success';
                        echo $this->closeTabFunction($title, $bodyMsg, $type);
                    } else {
                        $title = 'Error de Envio';
                        $bodyMsg = 'DTE no pudo ser enviado a la dirección de correo <b style=\'color: #f27474;\'>' . $infoDoc->correo . '</b>';
                        $type = 'error';
                        echo $this->closeTabFunction($title, $bodyMsg, $type);
                    }
                } else {
                    $title = 'Error de Envio';
                    $bodyMsg = 'DTE no pudo ser enviado debido a que el cliente no tiene dirección de correo registrada en el sistema.';
                    $type = 'error';
                    echo $this->closeTabFunction($title, $bodyMsg, $type);
                }
            }
        }
    }
    // Modificacion Hecha para cambiar el correo de iberica en DTE RM
    function electronicBills($trannum, $idYear = 0, $docToSend = 0, $docToSave = 0)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('login/cerrar_sesion');
        } else {
            $this->load->model('dev_model');
            $this->load->model('dte_model');
            $this->load->model('global_model');
            $this->load->model('pedclientes_model');
            $this->load->model('ventas_model');
            $this->load->model('sucursal_model');

            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Documento Tributario Electrónico');
            $pdf->SetSubject('Documento Tributario Electrónico');
            $pdf->SetMargins(7.5, 15, 9, true);
            $pdf->SetAutoPageBreak(TRUE, 7);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
            $pdf->SetFont('helvetica', '', 7.5, '', true);
            $pdf->addPage('P', 'LETTER');

            $x = 3;
            $y = 3;

            $informacion = $this->dev_model->electronicBills($trannum, $idYear);

            foreach ($informacion as $info) {
                $jsonInfo = $info['jsonDoc'];
                $sRecepcion = $info['sRecepcion'];
                $respHacienda = $info['respHacienda'];
                $firmaJson = $info['firmaJson'];
            }

            if (isset($jsonInfo['identificacion']))
                $identificacion = $jsonInfo['identificacion'];
            if (isset($jsonInfo['documentoRelacionado']))
                $documentoRelacionado = $jsonInfo['documentoRelacionado'];
            if (isset($jsonInfo['emisor']))
                $emisor = $jsonInfo['emisor'];
            if (isset($emisor['direccion']))
                $direcEmisor = $emisor['direccion'];
            if (isset($jsonInfo['receptor']))
                $receptor = $jsonInfo['receptor'];
            if (isset($jsonInfo['sujetoExcluido']))
                $sujetoExcluido = $jsonInfo['sujetoExcluido'];
            if (isset($receptor['direccion']))
                $direcReceptor = $receptor['direccion'];
            if (isset($sujetoExcluido['direccion']))
                $direcRsujetoExcluido = $sujetoExcluido['direccion'];
            if (isset($jsonInfo['ventaTercero']))
                $ventaTercero = $jsonInfo['ventaTercero'];
            if (isset($jsonInfo['cuerpoDocumento']))
                $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
            if (isset($jsonInfo['resumen']))
                $resumen = $jsonInfo['resumen'];
            if (isset($resumen['tributos']))
                $tributos = $resumen['tributos'];
            if (isset($jsonInfo['extension']))
                $extension = $jsonInfo['extension'];
            if (isset($jsonInfo['apendice']))
                $apendice = $jsonInfo['apendice'];

            $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
            $modeloFacturacion = explode(" ", $modFac['descrip']);
            $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
            $tipoTransmision = explode(" ", $tipoTrans['descrip']);
            $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
            $tipoDocumento = $identificacion['tipoDte'];
            $nameVendedor = '';

            if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                $infoFact = $this->dev_model->getTipoDocumentoTablaIVA($trannum, $idYear);
                //$idClase = $infoFact->doc_tipo;
                $idClase = $infoFact->invclase;
                $diasCredito = " ";
                $idCentro = (int) $infoFact->idcentro;
                $idCliente = (int) $infoFact->idcps;
            } else {
                $infoFact = $this->ventas_model->getDatosFactura($trannum);
                foreach ($infoFact as $info) {
                    $idClase = $info->idclase;
                    $nameSucursal = $info->nameSucursal;
                    $nameVendedor = $info->nameVendedor;
                    $diasCredito = $info->dias . ' dias';
                    $referenciaOT = $info->referencia;
                    $idCentro = (int) $info->idcentro;
                    if ($tipoDocumento == '03') {
                        $extension['observaciones'] = $info->notas;
                    }
                }
            }

            $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

            if ($dteSucursal == 0) {
                $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                $nComercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                $categoria = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                $nameImagen = $this->pedclientes_model->getnameImg();
            } else {
                $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0' . $idCentro, 1);
                $nComercial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0' . $idCentro, 2);
                $categoria = $this->global_model->getDatosGeneralesEmp('g_empdatos_0' . $idCentro, 10);
                $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0' . $idCentro);
            }

            if ($this->session->userdata('idaccount') == '45357159') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalDTE/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalDTE/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '1100831') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '4618') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '06')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaDeRemisionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '2703140') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '2305582') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend) . '/' . $docToSave;
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '1094521') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend) . '/' . $docToSave;
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '593230') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '2696198') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '1858540') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '2213241') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '1490796') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '2737721') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '2662484') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '2817515') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '41904') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '2835956') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '239470') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '1784550') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '11')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if ($this->session->userdata('idaccount') == '3306740') {
                if ($tipoDocumento == '01')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '03')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
                if ($tipoDocumento == '05')
                    redirect(base_url() . $this->session->userdata('dirReports') . '/reports/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            }

            if($this->session->userdata('idaccount') == '460443'){
                if($tipoDocumento == '01') redirect(base_url().$this->session->userdata('dirReports').'/reports/facturaConsumidorFinalElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                if($tipoDocumento == '03') redirect(base_url().$this->session->userdata('dirReports').'/reports/creditoFiscalElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                if($tipoDocumento == '05') redirect(base_url().$this->session->userdata('dirReports').'/reports/notaCreditoElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                //if($tipoDocumento == '11') redirect(base_url().$this->session->userdata('dirReports').'/reports/facturaExportacionElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
            }

            if($this->session->userdata('idaccount') == '2389132'){
                if($tipoDocumento == '01') redirect(base_url().$this->session->userdata('dirReports').'/reports/facturaConsumidorFinalElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                if($tipoDocumento == '03') redirect(base_url().$this->session->userdata('dirReports').'/reports/creditoFiscalElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                if($tipoDocumento == '05') redirect(base_url().$this->session->userdata('dirReports').'/reports/notaCreditoElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                //if($tipoDocumento == '11') redirect(base_url().$this->session->userdata('dirReports').'/reports/facturaExportacionElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
            }

            if($this->session->userdata('idaccount') == '3114780'){
                if($tipoDocumento == '01') redirect(base_url().$this->session->userdata('dirReports').'/reports/facturaConsumidorFinalElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                if($tipoDocumento == '03') redirect(base_url().$this->session->userdata('dirReports').'/reports/creditoFiscalElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                if($tipoDocumento == '05') redirect(base_url().$this->session->userdata('dirReports').'/reports/notaCreditoElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                if($tipoDocumento == '11') redirect(base_url().$this->session->userdata('dirReports').'/reports/facturaExportacionElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
            }

            if($this->session->userdata('idaccount') == '2355876'){
                if($tipoDocumento == '01') redirect(base_url().$this->session->userdata('dirReports').'/reports/facturaConsumidorFinalElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                if($tipoDocumento == '03') redirect(base_url().$this->session->userdata('dirReports').'/reports/creditoFiscalElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                if($tipoDocumento == '05') redirect(base_url().$this->session->userdata('dirReports').'/reports/notaCreditoElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
                if($tipoDocumento == '11') redirect(base_url().$this->session->userdata('dirReports').'/reports/facturaExportacionElectronicBills/'.$trannum.'/'.$idYear.'/'.$docToSend);
            }

            if ($tipoDocumento == '01')
                redirect(base_url() . 'Dev/facturaConsumidorFinalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            if ($tipoDocumento == '03')
                redirect(base_url() . 'Dev/creditoFiscalElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            if ($tipoDocumento == '05')
                redirect(base_url() . 'Dev/notaCreditoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            if ($tipoDocumento == '11')
                redirect(base_url() . 'Dev/facturaExportacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend) . '/' . $docToSave;
            if ($tipoDocumento == '15')
                redirect(base_url() . 'Dev/comprobanteDonacionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            if ($tipoDocumento == '04')
                redirect(base_url() . 'Dev/notaDeRemisionElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);
            if ($tipoDocumento == '06')
                redirect(base_url() . 'Dev/notaDebitoElectronicBills/' . $trannum . '/' . $idYear . '/' . $docToSend . '/' . $docToSave);

            if ($this->session->userdata('idaccount') == '90476') {
                //$imgHeader1Hght = '15px';
                if ($idCentro == 2) {
                    $nameImagen = 'BostonLogo.png';
                }
            }

            $sucursalInfo = $this->sucursal_model->getSucursal($idCentro);

            if ($sucursalInfo != false || $sucursalInfo != null) {
                if ($sucursalInfo->direccion != '') {
                    $direcEmisor['complemento'] = $sucursalInfo->direccion;
                }

                if ($sucursalInfo->telefono != '') {
                    $emisor['telefono'] = $sucursalInfo->telefono;
                }
            }

            /* --- INICIO SECCION CABECERAS --- */

            $emisorEstab = array();
            if (isset($emisor['tipoEstablecimiento'])) {
                $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
            }

            if (!isset($emisorEstab['descrip']))
                $emisorEstab['descrip'] = '';

            if ($this->session->userdata('idaccount') == '2922210') {
                $header1 = '
                        <table style="width:40%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height:0px;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%; text-decoration: underline;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112) . '</td>
                            </tr>';
                if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'], 0, 49) . '</td>
                                </tr>';
                } else {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                                </tr>';
                }
                $header1 .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                            </tr>';
                if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 50) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 50) . '</td>
                                </tr>';
                } else {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                                </tr>';
                }
                $header1 .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                            </tr>';
                if ($tipoDocumento == '11') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Recinto Fiscal: ' . substr($emisor['recintoFiscal'], 0, 35) . '</td>
                                            </tr>
                                            <tr style="width:100%; padding:0px;">
                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Regimen de Exportación: ' . substr($emisor['regimen'], 0, 32) . '</td>
                                            </tr>';
                }
                $header1 .= '</table>';
            } else {
                $header1 = '
                        <table style="width:40%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; text-align:left;"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="' . FCPATH . 'img_cuentas/' . $this->session->userdata('diraccount') . '/' . $nameImagen . '"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.5px; width:100%;">' . substr(mb_strtoupper($direcEmisor['complemento']), 0, 112) . '</td>
                            </tr>';
                if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'], 0, 49) . '</td>
                                </tr>';
                } else {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                                </tr>';
                }
                if ($this->session->userdata('idaccount') == '2585TIENDAS') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">facturacionelectronica@laiberica.net</td>
                            </tr>';
                } else {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                            </tr>';
                }
                $header1 .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                            </tr>';
                if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 50) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 50) . '</td>
                                </tr>';
                } else {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                                </tr>';
                }
                $header1 .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                            </tr>';
                if ($tipoDocumento == '11') {
                    $header1 .= '<tr style="width:100%; padding:0px;">
                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Recinto Fiscal: ' . substr($emisor['recintoFiscal'], 0, 35) . '</td>
                                            </tr>
                                            <tr style="width:100%; padding:0px;">
                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Regimen de Exportación: ' . substr($emisor['regimen'], 0, 32) . '</td>
                                            </tr>';
                }
                $header1 .= '</table>';
            }

            $pdf->SetXY(4.5 + $x, 10.5 + $y);
            $pdf->writeHTML($header1, true, false, true, false, '');

            $header2 = '
                    <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['numeroControl'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]) . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . $identificacion['version'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($tipoTransmision[array_key_last($tipoTransmision)]) . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . date_format(date_create($identificacion['fecEmi']), "d/m/Y") . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . date_format(date_create($identificacion['horEmi']), "h:i:s A") . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

            $nControlP = explode('-', $identificacion['numeroControl']);

            $header2 .= '
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . (int) $nControlP[3] . '</td>
                            </tr>';
            $header2 .= '</table>';

            $pdf->SetXY(95 + $x, 10.5 + $y);
            $pdf->writeHTML($header2, true, false, true, false, '');

            // * 98x98 is the size of the QR image you want to generate.
            // * the data is the url-encoded string you want to change into a QR code.
            // * URL to create the url-encoded -> https://developers.google.com/chart/interactive/docs/querylanguage?hl=es-419#plainText
            // * the choe is the (optional) encoding.
            // * URL con la api anterior <img src="https://chart.googleapis.com/chart?chs=98x98&cht=qr&chl=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D'.$identificacion['ambiente'].'%26codGen%3D'.$identificacion['codigoGeneracion'].'%26fechaEmi%3D'.$identificacion['fecEmi'].'" title="Link to Google.com" />
            // * URL con la api anterior <img src="https://api.qrserver.com/v1/create-qr-code/?data=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D'.$identificacion['ambiente'].'%26codGen%3D'.$identificacion['codigoGeneracion'].'%26fechaEmi%3D'.$identificacion['fecEmi'].'&size=79x79" />
            // * URL con la api anterior <img src="https://api.qrserver.com/v1/create-qr-code/?data='.$identificacion['codigoGeneracion'].'&size=60x60" />
            // * URL con la api anterior <img src="https://api.qrserver.com/v1/create-qr-code/?data='.$sRecepcion.'&size=60x60" />
            // * URL con la api anterior <img src="https://api.qrserver.com/v1/create-qr-code/?data='.$identificacion['numeroControl'].'&size=60x60" />

            // Data to encode in the QR code
            //$urlQR = "https://admin.factura.gob.sv/consultaPublica?ambiente=".$identificacion['ambiente']."&codGen=".$identificacion['codigoGeneracion']."&fechaEmi=".$identificacion['fecEmi']."";

            // Generate QR code
            //$qrCodeText = 'https://example.com'; // URL or any text you want to encode

            $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT'] . "dte_files", '/') . "/";

            $portalMHImg = $destinationFolder . $identificacion['codigoGeneracion'] . '-MH.png';
            $codGeneracionImg = $destinationFolder . $identificacion['codigoGeneracion'] . '.png';
            $selloRecibidoImg = $destinationFolder . $sRecepcion . '.png';
            $numeroControlImg = $destinationFolder . $identificacion['numeroControl'] . '.png';

            if (!is_dir($destinationFolder)) {
                mkdir($destinationFolder, 0777, true);
            }

            $this->createQrImage('https://admin.factura.gob.sv/consultaPublica?ambiente=' . $identificacion['ambiente'] . '&codGen=' . $identificacion['codigoGeneracion'] . '&fechaEmi=' . $identificacion['fecEmi'], 'Portal de Hacienda', $portalMHImg);
            $this->createQrImage($identificacion['codigoGeneracion'], 'Cód. Generación', $codGeneracionImg);
            $this->createQrImage($sRecepcion, 'Sello Recibido', $selloRecibidoImg);
            $this->createQrImage($identificacion['numeroControl'], 'N° de Control', $numeroControlImg);

            $qrCode = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                                <img src="' . $portalMHImg . '" style="height: 95px;"/>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="' . $codGeneracionImg . '" style="height: 75px;"/>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="' . $selloRecibidoImg . '" style="height: 75px;"/>
                            </td>
                            <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="' . $numeroControlImg . '" style="height: 75px;"/>
                            </td>
                        </tr>
                    </table>';

            $pdf->SetXY(95 + $x, 40.5 + $y);
            $pdf->writeHTML($qrCode, true, false, true, false, '');

            if (isset($direcReceptor)) {
                //$receptorMun = $this->dte_model->getDescripCodigoDTE($direcReceptor['municipio'],'CAT-013');
                $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'], $direcReceptor['departamento']);
                //var_dump($receptorMun);
                //$receptorDep = $this->dte_model->getDescripCodigoDTE($direcReceptor['departamento'],'CAT-012');
                $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
            } else {
                $receptorMun = array();
                $receptorDep = array();
            }

            if (isset($direcRsujetoExcluido)) {
                //$receptorMun = $this->dte_model->getDescripCodigoDTE($direcReceptor['municipio'],'CAT-013');
                $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'], $direcRsujetoExcluido['departamento']);
                //var_dump($receptorMun);
                //$receptorDep = $this->dte_model->getDescripCodigoDTE($direcReceptor['departamento'],'CAT-012');
                $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
            } else {
                $sujetoExcluidoMun = array();
                $sujetoExcluidoDep = array();
            }

            $receptorDoc = array();
            if (isset($receptor['tipoDocumento'])) {
                if ($receptor['tipoDocumento'] != '') {
                    $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'], 'CAT-022');
                }
            }

            $sujetoExcluidoDoc = array();
            if (isset($sujetoExcluido['tipoDocumento'])) {
                if ($sujetoExcluido['tipoDocumento'] != '') {
                    $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'], 'CAT-022');
                }
            }

            if (!isset($receptorDoc['descrip'])) {
                $receptorDoc['descrip'] = 'Doc. Identificación';
            }

            if (!isset($sujetoExcluidoDoc['descrip'])) {
                $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
            }

            if (!isset($receptor['nombreComercial'])) {
                $receptor['nombreComercial'] = '';
            }

            if (!isset($direcReceptor['complemento'])) {
                $direcReceptor['complemento'] = '';
            }

            if (!isset($direcRsujetoExcluido['complemento'])) {
                $direcRsujetoExcluido['complemento'] = '';
            }

            if (!isset($receptor['correo'])) {
                $receptor['correo'] = '';
            }

            $condicionPago = array();
            if (isset($resumen['condicionOperacion'])) {
                if ($resumen['condicionOperacion'] != '') {
                    $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'], 'CAT-016');
                }
            } else {
                $condicionPago['descrip'] = '';
            }

            if (!isset($extension['observaciones'])) {
                $extension['observaciones'] = '';
            }

            if (!isset($extension['nombEntrega'])) {
                $extension['nombEntrega'] = '';
            }

            if (!isset($extension['docuEntrega'])) {
                $extension['docuEntrega'] = '';
            }

            if (!isset($extension['nombRecibe'])) {
                $extension['nombRecibe'] = '';
            }

            if (!isset($extension['docuRecibe'])) {
                $extension['docuRecibe'] = '';
            }

            $header3 = '';
            //$tipoDocumento ='14';
            // header3
            if ($tipoDocumento == '03') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:87%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 78) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($direcReceptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                    $header3 .= '
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                if ($this->session->userdata('idaccount') == '2922210') {
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;' . substr($condicionPago['descrip'], 0, 19) . ' ' . $diasCredito . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                } else {
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                }
                foreach ($receptorDep as $depto) {
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Moneda:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19) . '</td>
                                </tr>
                            </table>';
            }
            if ($tipoDocumento == '01') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Nombre Comercial:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($receptor['nombreComercial'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">' . $receptorDoc['descrip'] . ':</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['numDocumento'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Correo:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">NRC:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . mb_substr(mb_strtoupper($direcReceptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Teléfono:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                    if (!isset($muni['municipio']))
                        $muni['municipio'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Municipio:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Forma pago:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorDep as $depto) {
                    if (!isset($depto['depto']))
                        $depto['depto'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Departamento:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Moneda:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19) . '</td>
                                </tr>
                            </table>';
            }
            if ($tipoDocumento == '11') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Nombre Comercial:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($receptor['nombreComercial'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">' . $receptorDoc['descrip'] . ':</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['numDocumento'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Act. Económica:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr($receptor['descActividad'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">País destino:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nombrePais'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . mb_substr(mb_strtoupper($receptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                </tr>
                            </table>';
            }
            if ($tipoDocumento == '05') {
                $ordenString = '';
                if ($this->session->userdata('idaccount') == '291862') {
                    $ordenString = 'Orden:';
                } else {
                    $referenciaOT = '';
                }
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">' . $ordenString . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.8px; width:16%;">' . trim($referenciaOT) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($direcReceptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                    if (!isset($muni['municipio']))
                        $muni['municipio'] = '';
                    $header3 .= '
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorDep as $depto) {
                    if (!isset($depto['depto']))
                        $depto['depto'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '</tr></table>';
            }
            if ($tipoDocumento == '14') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">' . $sujetoExcluidoDoc['descrip'] . ':</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr($sujetoExcluido['numDocumento'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Teléfono:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($sujetoExcluido['telefono'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . mb_substr(mb_strtoupper($direcRsujetoExcluido['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($sujetoExcluidoMun as $muni) {
                    if (!isset($muni['municipio']))
                        $muni['municipio'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Municipio:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                    break;
                }
                $header3 .= '</tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($sujetoExcluidoDep as $depto) {
                    if (!isset($depto['depto']))
                        $depto['depto'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Departamento:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                    break;
                }
                $header3 .= '</tr>
                            </table>';
            }
            if ($tipoDocumento == '06') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($direcReceptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                    if (!isset($muni['municipio']))
                        $muni['municipio'] = '';
                    $header3 .= '
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorDep as $depto) {
                    if (!isset($depto['depto']))
                        $depto['depto'] = '';
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '</tr></table>';
            }
            if ($tipoDocumento == '07') {
                $header3 .= '
                            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Nombre Comercial:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">' . substr(mb_strtoupper($receptor['nombreComercial'], 'UTF-8'), 0, 64) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">' . $receptorDoc['descrip'] . ':</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['numDocumento'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($direcReceptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorMun as $muni) {
                    if (!isset($muni['municipio'])) {
                        $muni['municipio'] = '';
                    }
                    $header3 .= '
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '</tr>
                                <tr style="width:100%; padding:0px;">';
                foreach ($receptorDep as $depto) {
                    if (!isset($depto['depto'])) {
                        $depto['depto'] = '';
                    }
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                    break;
                }
                $header3 .= '</tr></table>';
            }

            // header3

            if ($tipoDocumento == '11') {
                $pdf->SetXY(4.5 + $x, 75.5 + $y);
                $pdf->writeHTML($header3, true, false, true, false, '');
            } else {
                $pdf->SetXY(4.5 + $x, 70.5 + $y);
                $pdf->writeHTML($header3, true, false, true, false, '');
            }


            /* --- FIN SECCION CABECERAS --- */

            //$tipoDocumento = '01';

            if ($tipoDocumento == '03') {
                // INICIO CUERPO DE DOCUMENTO CREDITO FISCAL

                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No. Item</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Código</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:44%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $ventaNosj = number_format(floatval($body['ventaNoSuj']), 4, '.', ',');
                        $ventaExenta = number_format(floatval($body['ventaExenta']), 4, '.', ',');
                        if ($ventaNosj == '0') {
                            $ventaNosj = '';
                        }
                        if ($ventaExenta == '0') {
                            $ventaExenta = '';
                        }
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . $body['codigo'] . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:43%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($body['precioUni'], 6, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaNosj . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaExenta . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format(floatval($body['ventaGravada']), 4, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:62%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>';
                if ($extension['observaciones'] == '') {
                    $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>';
                } else if (strlen(trim($extension['observaciones'])) <= 86) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                            </tr>';
                }

                $extention .= '
                        </table>';

                $pdf->SetXY(4.5 + $x, 230 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total descuentos</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalDescu'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';
                foreach ($tributos as $trib) {
                    $totals .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                </tr>';
                }
                $totals .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total otros montos no afectos</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL A PAGAR</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 230 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 262 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //$pdf->setHtmlFooter($extention.$totals);
                //$pdf->setPrintFooter(true);

                // FIN CUERPO DE DOCUMENTO CREDITO FISCAL
            }

            if ($tipoDocumento == '01') {
                //INICIO CUERPO DE DOCUMENTO FACTURA CONSUMIDOR FINAL
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                $maxlines = 15;

                $bodyDoc = '
                            <table style="width:55%; padding:0px; border: 0.1px solid #000">
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9.8%; border: 0.1px solid #000; background-color: #CFCFCF;">N°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:12%; border: 0.1px solid #000; background-color: #CFCFCF;">Cantidad</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9.8%; border: 0.1px solid #000; background-color: #CFCFCF;">Unidad</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:53%; border: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:15.4%; border: 0.1px solid #000; background-color: #CFCFCF;">Precio unitario</th>
                                </tr>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $ventaNosj = number_format(floatval($body['ventaNoSuj']), 2, '.', ',');
                        $ventaExenta = number_format(floatval($body['ventaExenta']), 2, '.', ',');
                        if ($ventaNosj == '0') {
                            $ventaNosj = '';
                        }
                        if ($ventaExenta == '0') {
                            $ventaExenta = '';
                        }
                        $bodyDoc .= '<tr style="width:55%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:9.8%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:12%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:9.8%;">' . $body['tipoItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:0.2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:52.8%;">' . trim($body['descripcion']) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:15.2%;">' . number_format($body['precioUni'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:0.2%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < $maxlines){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; ">
                            <tr style="width:100%; padding:0px;">
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:30%; border: 0.1px solid #000; background-color: #CFCFCF;">Otros montos no afectos</th>
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:23.8%; border: 0.1px solid #000; background-color: #CFCFCF;">Descuento por ítem</th>
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:15.4%; border: 0.1px solid #000; background-color: #CFCFCF;">Ventas No Sujetas</th>
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:15.4%; border: 0.1px solid #000; background-color: #CFCFCF;">Ventas Exentas</th>
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:15.4%; border: 0.1px solid #000; background-color: #CFCFCF;">Ventas Gravadas</th>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:52.9%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Suma de Ventas:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format(floatval($resumen['totalGravada']), 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:100%;"></th>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Sumatoria de Ventas:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Monto global Desc., Rebajas y otras ventas no<br>sujetas:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['descuNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Monto global Desc., Rebajas y otras ventas<br>exentas:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['descuExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Monto global Desc., Rebajas y otras ventas<br>gravadas:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['descuGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Nombre del:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['descuGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>';
                if (isset($tributos)) {
                    foreach ($tributos as $trib) {
                        $totals .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">' . $trib["descripcion"] . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                                    </tr>';
                    }
                }
                $totals .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Sub - Total:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">IVA Retenido:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Retencion Renta:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['reteRenta'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Monto Total de la Operación:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Total Otros Montos No Afectos:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:83.7%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Total A Pagar:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(116.2 + $x, 93.5 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:100%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Valor en letras:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:81%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . trim($resumen['totalLetras']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Observaciones</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:81%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . substr(trim($extension['observaciones']), 0, 50) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Nombre entrega:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%; border-top: 0.1px solid #000; background-color: #CFCFCF;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 50) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; background-color: #CFCFCF;">No Documento:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:21%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . $extension['docuEntrega'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Nombre recibe:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 50) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">No Documento:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:21%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . $extension['docuRecibe'] . '</td>
                            </tr>
                        </table>';

                $pdf->SetXY(4.5 + $x, 240 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 257 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                /* --- FIN SECCION PRODUCTOS --- */
                //FIN CUERPO DE DOCUMENTO FACTURA CONSUMIDOR FINAL
            }

            if ($tipoDocumento == '05') {
                //INICIO CUERPO DE DOCUMENTO NOTA DE CREDITO
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">N°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:44%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descuento por Item</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $ventaNosj = number_format(floatval($body['ventaNoSuj']), 4, '.', ',');
                        $ventaExenta = number_format(floatval($body['ventaExenta']), 4, '.', ',');
                        if ($ventaNosj == '0') {
                            $ventaNosj = '';
                        }
                        if ($ventaExenta == '0') {
                            $ventaExenta = '';
                        }
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:43%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($body['precioUni'], 6, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . $body['montoDescu'] . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaNosj . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaExenta . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format(floatval($body['ventaGravada']), 4, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:62%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>';
                if ($extension['observaciones'] == '') {
                    $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>';
                } else if (strlen(trim($extension['observaciones'])) <= 86) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                            </tr>';
                }

                $extention .= '
                        </table>';

                $pdf->SetXY(4.5 + $x, 230 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas no sujetas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas exentas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas gravadas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';
                foreach ($tributos as $trib) {
                    $totals .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                </tr>';
                }
                $totals .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['montoTotalOperacion'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL A PAGAR</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['montoTotalOperacion'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 230 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 265 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //$pdf->setHtmlFooter($extention.$totals);
                //$pdf->setPrintFooter(true);

                //FIN CUERPO DE DOCUMENTO NOTA DE CREDITO
            }

            if ($tipoDocumento == '11') {
                //INICIO CUERPO DE DOCUMENTO FACTURAS DE EXPORTACION
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:6%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cantidad</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:54%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:7%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descuento por Item</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Otros Montos no Afectos</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas Afectas</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $montoDescu = number_format(floatval($body['montoDescu']), 2, '.', ',');
                        $noGravado = number_format(floatval($body['noGravado']), 2, '.', ',');
                        if ($montoDescu == '0') {
                            $montoDescu = '';
                        }
                        if ($noGravado == '0') {
                            $noGravado = '';
                        }
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:53%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($body['precioUni'], 2, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:7%;">' . $montoDescu . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . $noGravado . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format(floatval($body['ventaGravada']), 2, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:62%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:30%;">Condición de la Operación</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:69%;">' . substr(mb_strtoupper($condicionPago['descrip'], 'UTF-8'), 0, 35) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:25%;">Descripción Incoterms</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:74%;">' . substr(mb_strtoupper($resumen['descIncoterms'], 'UTF-8'), 0, 40) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>';
                if ($resumen['observaciones'] == '') {
                    $extention .= '
                                    <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                    </tr>
                                    <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                    </tr>';
                } else if (strlen(trim($resumen['observaciones'])) <= 86) {
                    $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($resumen['observaciones']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>';
                } else if (strlen(trim($resumen['observaciones'])) > 86 && strlen(trim($resumen['observaciones'])) <= 172) {
                    $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . substr(trim($resumen['observaciones']), 0, 172) . '</td>
                                </tr>';
                }

                $extention .= '
                        </table>';

                $pdf->SetXY(4.5 + $x, 230 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%; border-top: 0.1px solid #000;">Total de Operaciones Afectas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000;">' . number_format($resumen['montoTotalOperacion'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto Global de Descuento</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalDescu'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Seguro</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['seguro'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Flete</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['flete'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total otros montos no afectos</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL A PAGAR</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 230 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 262 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //FIN CUERPO DE DOCUMENTO FACTURAS DE EXPORTACION
            }

            if ($tipoDocumento == '14') {
                //INICIO CUERPO DE DOCUMENTO FACTURA SUJETO EXCLUIDO
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:6%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">N°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:6%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:57%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:11%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descuento por Item</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas $</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . number_format($body['precioUni'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;">' . $body['montoDescu'] . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . number_format(floatval($body['compra']), 2, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:62%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:30%;">Condición de la Operación</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:69%;">' . substr(mb_strtoupper($condicionPago['descrip'], 'UTF-8'), 0, 35) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . substr(trim($resumen['observaciones']), 0, 86) . '</td>
                                </tr>
                        </table>';

                $pdf->SetXY(4.5 + $x, 230 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%; border-top: 0.1px solid #000;">Suma total de operaciones</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-top: 0.1px solid #000;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000;">' . number_format($resumen['totalCompra'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>

                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Impuesto Sobre la Renta</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['reteRenta'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>

                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL A PAGAR</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 230 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 262 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //$pdf->setHtmlFooter($extention.$totals);
                //$pdf->setPrintFooter(true);

                //FIN CUERPO DE DOCUMENTO FACTURA SUJETO EXCLUIDO
            }

            if ($tipoDocumento == '06') {
                //INICIO CUERPO DE DOCUMENTO NOTA DE DEBITO
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">N°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:39%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descuento por Item</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $ventaNosj = number_format(floatval($body['ventaNoSuj']), 2, '.', ',');
                        $ventaExenta = number_format(floatval($body['ventaExenta']), 2, '.', ',');
                        if ($ventaNosj == '0') {
                            $ventaNosj = '';
                        }
                        if ($ventaExenta == '0') {
                            $ventaExenta = '';
                        }
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['cantidad'] . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:38%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($body['precioUni'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . $body['montoDescu'] . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaNosj . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaExenta . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format(floatval($body['ventaGravada']), 2, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:62%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>';
                if ($extension['observaciones'] == '') {
                    $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>';
                } else if (strlen(trim($extension['observaciones'])) <= 86) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>';
                } else {
                    $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                            </tr>';
                }

                $extention .= '
                        </table>';

                $pdf->SetXY(4.5 + $x, 230 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas no sujetas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuNoSuj'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas exentas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuExenta'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas gravadas</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuGravada'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';
                foreach ($tributos as $trib) {
                    $totals .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                </tr>';
                }
                $totals .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL A PAGAR</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 230 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 262 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //$pdf->setHtmlFooter($extention.$totals);
                //$pdf->setPrintFooter(true);

                //FIN CUERPO DE DOCUMENTO NOTA DE DEBITO
            }

            if ($tipoDocumento == '07') {
                //INICIO CUERPO DE DOCUMENTO COMPROBANTE DE RETENCIÓN
                /* --- INICIO SECCION PRODUCTOS --- */

                $numProd = 0;
                //$maxlines = 18;
                $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);

                $bodyDoc = '
                            <table style="width:100%; padding:0px;">
                            <thead>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">N°</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:12%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Tipo Doc. Relacionado</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:13%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">N° del Doc. Relacionado</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Fecha del Doc.</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:40%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripcion</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:11%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Monto Sujeto a Retención</th>
                                    <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">IVA Retenido</th>
                                </tr></thead>';

                foreach ($cuerpoDocumento as $body) {
                    if ($numProd < $maxlines) {
                        $relacDoc = $this->dte_model->getDescripCodigoDTE($body['tipoDte'], 'CAT-022');
                        $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">' . $body['numItem'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;">' . $relacDoc['descrip'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:13%;">' . $body['numDocumento'] . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . date_format(date_create($body['fechaEmision']), "d/m/Y") . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;">' . trim(mb_strtoupper($body['descripcion'], 'UTF-8')) . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;">' . $body['montoSujetoGrav'] . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">' . number_format(floatval($body['ivaRetenido']), 2, '.', ',') . '</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                        </tr>';
                        $numProd++;
                    }
                }
                /*while($numProd < 20){
                    $bodyDoc .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>';
                    $numProd++;
                }*/
                $bodyDoc .= '</table>';

                $pdf->SetXY(4.5 + $x, 96.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- FIN SECCION PRODUCTOS --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:100%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Valor en letras:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:81%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . trim($resumen['totalIVAretenidoLetras']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Observaciones</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:81%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . substr(trim($extension['observaciones']), 0, 50) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Nombre entrega:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%; border-top: 0.1px solid #000; background-color: #CFCFCF;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 50) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-top: 0.1px solid #000; background-color: #CFCFCF;">No Documento:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:21%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . $extension['docuEntrega'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">Nombre recibe:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 50) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">No Documento:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:21%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . $extension['docuRecibe'] . '</td>
                            </tr>
                        </table>';

                $pdf->SetXY(4.5 + $x, 233 + $y);
                $pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                        <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%; border-top: 0.1px solid #000;">Total Monto Sujeto a Retención</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-top: 0.1px solid #000;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000;">' . number_format($resumen['totalSujetoRetencion'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%;">TOTAL IVA RETENIDO</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%;">' . number_format($resumen['totalIVAretenido'], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                        </table>';

                $pdf->SetXY(128.1 + $x, 233 + $y);
                $pdf->writeHTML($totals, true, false, true, false, '');

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                $pdf->SetXY(4.5 + $x, 262 + $y);
                $pdf->writeHTML($message, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */
                //$pdf->setHtmlFooter($extention.$totals);
                //$pdf->setPrintFooter(true);
                //FIN CUERPO DE DOCUMENTO COMPROBANTE DE RETENCIÓN
            }

            /* --- GENERACION DE PDF --- */

            $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'] . '.pdf');
            $fullpath = $destinationFolder . $nombre_archivo;

            /*
             *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
             *D: send to the browser and force a file download with the name given by name.
             *F: save to a local server file with the name given by name.
             *S: return the document as a string. name is ignored.
             *FI: equivalent to F + I option
             *FD: equivalent to F + D option
             */

            //$docToSend = 1;

            if ($docToSave == 0) {
                if ($docToSend == 0) {
                    $pdf->Output($nombre_archivo, 'I');

                    if (file_exists($portalMHImg))
                        unlink($portalMHImg);
                    if (file_exists($codGeneracionImg))
                        unlink($codGeneracionImg);
                    if (file_exists($selloRecibidoImg))
                        unlink($selloRecibidoImg);
                    if (file_exists($numeroControlImg))
                        unlink($numeroControlImg);
                } else {
                    $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                    //$pdf->Output($nombre_archivo, 'I');

                    if ($infoDoc->correo != '') {
                        $pdf->Output($fullpath, 'F');
                        $docIntern = (int) $nControlP[3];
                        $emiDate = date_format(date_create($identificacion['fecEmi']), "d/m/Y");

                        if (isset($receptor['nombre']))
                            $nameCliente = mb_strtoupper($receptor['nombre'], 'UTF-8');
                        if (isset($sujetoExcluido['nombre']))
                            $nameCliente = mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8');

                        $jsonFile = $this->createJsonFile($jsonInfo, $identificacion['codigoGeneracion'], $respHacienda, $firmaJson);

                        if (file_exists($portalMHImg))
                            unlink($portalMHImg);
                        if (file_exists($codGeneracionImg))
                            unlink($codGeneracionImg);
                        if (file_exists($selloRecibidoImg))
                            unlink($selloRecibidoImg);
                        if (file_exists($numeroControlImg))
                            unlink($numeroControlImg);

                        if ($tipoDocumento == '07') {
                            $response = $this->sendEmailWithPdfResend($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalSujetoRetencion'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);
                        } else {
                            //$response = $this->sendEmailWithPdf($nombre_archivo,$fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear);
                            $response = $this->sendEmailWithPdfResend($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);
                        }

                        if ($response == true) {
                            $title = 'Correo Enviado';
                            $bodyMsg = 'DTE enviado exitosamente a la direccion de correo <b style=\'color: #79bd53;\'>' . $infoDoc->correo . '</b>';
                            $type = 'success';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        } else {
                            $title = 'Error de Envio';
                            $bodyMsg = 'DTE no pudo ser enviado a la dirección de correo <b style=\'color: #f27474;\'>' . $infoDoc->correo . '</b>';
                            $type = 'error';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        }
                    } else {
                        $title = 'Error de Envio';
                        $bodyMsg = 'DTE no pudo ser enviado debido a que el cliente no tiene dirección de correo registrada en el sistema.';
                        $type = 'error';
                        echo $this->closeTabFunction($title, $bodyMsg, $type);
                    }
                }
            } else {
                $pdf->Output($fullpath, 'F');

                if (file_exists($portalMHImg))
                    unlink($portalMHImg);
                if (file_exists($codGeneracionImg))
                    unlink($codGeneracionImg);
                if (file_exists($selloRecibidoImg))
                    unlink($selloRecibidoImg);
                if (file_exists($numeroControlImg))
                    unlink($numeroControlImg);

                return $fullpath;
            }
        }
    }

    #PDF Facturacion Electronica Credito Fiscal
    function creditoFiscalElectronicBillsOld4($trannum, $idYear = 0, $docToSend = 0, $docToSave = 0)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('login/cerrar_sesion');
        } else {
            $this->load->model('dev_model');
            $this->load->model('dte_model');
            $this->load->model('global_model');
            $this->load->model('pedclientes_model');
            $this->load->model('ventas_model');
            $this->load->model('invtran_model');
            $this->load->model('sucursal_model');

            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Documento Tributario Electrónico');
            $pdf->SetSubject('Documento Tributario Electrónico');
            $pdf->SetMargins(7.5, 15, 9, true);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetAutoPageBreak(TRUE, 7);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
            $pdf->SetFont('helvetica', '', 7.5, '', true);
            $pdf->addPage('P', 'LETTER');

            $x = 3;
            $y = 3;

            $informacion = $this->dev_model->electronicBills($trannum, $idYear);

            foreach ($informacion as $info) {
                $jsonInfo = $info['jsonDoc'];
                $sRecepcion = $info['sRecepcion'];
                $respHacienda = $info['respHacienda'];
                $firmaJson = $info['firmaJson'];
                $statusDoc = $info['status'];
            }

            if (isset($jsonInfo['identificacion']))
                $identificacion = $jsonInfo['identificacion'];
            if (isset($jsonInfo['documentoRelacionado']))
                $documentoRelacionado = $jsonInfo['documentoRelacionado'];
            if (isset($jsonInfo['emisor']))
                $emisor = $jsonInfo['emisor'];
            if (isset($emisor['direccion']))
                $direcEmisor = $emisor['direccion'];
            if (isset($jsonInfo['receptor']))
                $receptor = $jsonInfo['receptor'];
            if (isset($jsonInfo['sujetoExcluido']))
                $sujetoExcluido = $jsonInfo['sujetoExcluido'];
            if (isset($receptor['direccion']))
                $direcReceptor = $receptor['direccion'];
            if (isset($sujetoExcluido['direccion']))
                $direcRsujetoExcluido = $sujetoExcluido['direccion'];
            if (isset($jsonInfo['ventaTercero']))
                $ventaTercero = $jsonInfo['ventaTercero'];
            if (isset($jsonInfo['cuerpoDocumento']))
                $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
            if (isset($jsonInfo['resumen']))
                $resumen = $jsonInfo['resumen'];
            if (isset($resumen['tributos']))
                $tributos = $resumen['tributos'];
            else
                $tributos = array();
            if (isset($jsonInfo['extension']))
                $extension = $jsonInfo['extension'];
            if (isset($jsonInfo['apendice']))
                $apendice = $jsonInfo['apendice'];
            $tipoDocumento = '';
            $nameVendedor = '';
            $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
            $infoFact = $this->ventas_model->getDatosFactura($trannum);

            foreach ($infoFact as $info) {
                $idClase = $info->idclase;
                $nameSucursal = $info->nameSucursal;
                $nameVendedor = $info->nameVendedor;
                $referenciaOT = $info->referencia;
                $idCliente = (int) $info->idcliente;
                $idCentro = (int) $info->idcentro;
                $extension['observaciones'] = $info->notas;
            }

            if ($dteSucursal == 0) {
                $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                $nComercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                $categoria = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                $nameImagen = $this->pedclientes_model->getnameImg();
            } else {
                $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0' . $idCentro, 1);
                $nComercial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0' . $idCentro, 2);
                $categoria = $this->global_model->getDatosGeneralesEmp('g_empdatos_0' . $idCentro, 10);
                $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0' . $idCentro);
            }

            $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
            $modeloFacturacion = explode(" ", $modFac['descrip']);
            $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
            $tipoTransmision = explode(" ", $tipoTrans['descrip']);
            $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
            $tipoDocumento = $identificacion['tipoDte'];

            $sucursalInfo = $this->sucursal_model->getSucursal($idCentro);

            if ($sucursalInfo != false || $sucursalInfo != null) {
                if ($sucursalInfo->direccion != '') {
                    $direcEmisor['complemento'] = $sucursalInfo->direccion;
                }

                if ($sucursalInfo->telefono != '') {
                    $emisor['telefono'] = $sucursalInfo->telefono;
                }
            }

            /* --- INICIO SECCION CABECERAS --- */
            $emisorEstab = array();
            if (isset($emisor['tipoEstablecimiento'])) {
                $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
            }

            if (!isset($emisorEstab['descrip']))
                $emisorEstab['descrip'] = '';

            $imgHeader1Hght = '20px';
            if ($this->session->userdata('idaccount') == '1937326') {
                $imgHeader1Hght = '73px';
            }

            if ($this->session->userdata('idaccount') == '90476') {
                $imgHeader1Hght = '15px';
                if ($idCentro == 2) {
                    $nameImagen = 'BostonLogo.png';
                }
            }

            $fontSize = '9.5px';
            if ($this->session->userdata('idaccount') == '1784550') {
                $fontSize = '8.5px';
            }

            if ($this->session->userdata('idaccount') == '2922210') {
                $header1 = '
                            <table style="width:100%; padding:0px;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="padding:0px;margin:0px;width:100%; line-height: 25px;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; text-decoration: underline;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="padding:0px;margin:0px;width:100%; line-height: 49px;"></td>
                                </tr>';
                $header1 .= '</table>';
            } else {
                $header1 = '
                            <table style="width:100%; padding:0px;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: ' . $imgHeader1Hght . ';"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="' . FCPATH . 'img_cuentas/' . $this->session->userdata('diraccount') . '/' . $nameImagen . '"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: ' . $fontSize . '; width:100%;">' . substr(mb_strtoupper($direcEmisor['complemento']), 0, 112) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                                </tr>';
                if ($this->session->userdata('idaccount') == '2585TIENDAS') {
                    $header1 .=
                        '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">facturacionelectronica@laiberica.net</td>
                                        </tr>';

                } else {
                    $header1 .=
                        '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                                        </tr>';
                }
                $header1 .=
                    '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                                </tr>';
                $header1 .= '</table>';
            }

            $header2 = '
                        <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['numeroControl'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . $identificacion['version'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($tipoTransmision[array_key_last($tipoTransmision)]) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . date_format(date_create($identificacion['fecEmi']), "d/m/Y") . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . date_format(date_create($identificacion['horEmi']), "h:i:s A") . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

            $nControlP = explode('-', $identificacion['numeroControl']);

            $header2 .= '
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . (int) $nControlP[3] . '</td>
                            </tr>';
            $header2 .= '</table>';

            $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT'] . "dte_files", '/') . "/";

            $portalMHImg = $destinationFolder . $identificacion['codigoGeneracion'] . '-MH.png';
            $codGeneracionImg = $destinationFolder . $identificacion['codigoGeneracion'] . '.png';
            $selloRecibidoImg = $destinationFolder . $sRecepcion . '.png';
            $numeroControlImg = $destinationFolder . $identificacion['numeroControl'] . '.png';

            if (!is_dir($destinationFolder)) {
                mkdir($destinationFolder, 0777, true);
            }

            $this->createQrImage('https://admin.factura.gob.sv/consultaPublica?ambiente=' . $identificacion['ambiente'] . '&codGen=' . $identificacion['codigoGeneracion'] . '&fechaEmi=' . $identificacion['fecEmi'], 'Portal de Hacienda', $portalMHImg);
            $this->createQrImage($identificacion['codigoGeneracion'], 'Cód. Generación', $codGeneracionImg);
            $this->createQrImage($sRecepcion, 'Sello Recibido', $selloRecibidoImg);
            $this->createQrImage($identificacion['numeroControl'], 'N° de Control', $numeroControlImg);

            $qrCode = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                                <img src="' . $portalMHImg . '" style="height: 95px;"/>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="' . $codGeneracionImg . '" style="height: 75px;"/>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="' . $selloRecibidoImg . '" style="height: 75px;"/>
                            </td>
                            <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="' . $numeroControlImg . '" style="height: 75px;"/>
                            </td>
                        </tr>
                    </table>';

            if (isset($direcReceptor)) {
                $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'], $direcReceptor['departamento']);
                $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
            } else {
                $receptorMun = array();
                $receptorDep = array();
            }

            if (isset($direcRsujetoExcluido)) {
                $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'], $direcRsujetoExcluido['departamento']);
                $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
            } else {
                $sujetoExcluidoMun = array();
                $sujetoExcluidoDep = array();
            }

            $receptorDoc = array();
            if (isset($receptor['tipoDocumento'])) {
                if ($receptor['tipoDocumento'] != '') {
                    $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'], 'CAT-022');
                }
            }

            $sujetoExcluidoDoc = array();
            if (isset($sujetoExcluido['tipoDocumento'])) {
                if ($sujetoExcluido['tipoDocumento'] != '') {
                    $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'], 'CAT-022');
                }
            }

            if (!isset($receptorDoc['descrip'])) {
                $receptorDoc['descrip'] = 'Doc. Identificación';
            }

            if (!isset($sujetoExcluidoDoc['descrip'])) {
                $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
            }

            if (!isset($receptor['nombreComercial'])) {
                $receptor['nombreComercial'] = '';
            }

            if (!isset($direcReceptor['complemento'])) {
                $direcReceptor['complemento'] = '';
            }

            if (!isset($direcRsujetoExcluido['complemento'])) {
                $direcRsujetoExcluido['complemento'] = '';
            }

            if (!isset($receptor['correo'])) {
                $receptor['correo'] = '';
            }

            $condicionPago = array();
            if (isset($resumen['condicionOperacion'])) {
                if ($resumen['condicionOperacion'] != '') {
                    $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'], 'CAT-016');
                }
            } else {
                $condicionPago['descrip'] = '';
            }

            if (!isset($extension['observaciones'])) {
                $extension['observaciones'] = '';
            }

            if (!isset($extension['nombEntrega'])) {
                $extension['nombEntrega'] = '';
            }

            if (!isset($extension['docuEntrega'])) {
                $extension['docuEntrega'] = '';
            }

            if (!isset($extension['nombRecibe'])) {
                $extension['nombRecibe'] = '';
            }

            if (!isset($extension['docuRecibe'])) {
                $extension['docuRecibe'] = '';
            }

            $direcFontSize = '8px';

            if (strlen($direcReceptor['complemento']) > 89) {
                $direcFontSize = '7.5px';
            }

            $ordenString = '';
            if ($this->session->userdata('idaccount') == '291862') {
                $ordenString = 'Orden:';
            } else {
                $referenciaOT = '';
            }

            $header3 = '
                        <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">' . $ordenString . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.8px; width:16%;">' . trim($referenciaOT) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: ' . $direcFontSize . '; width:59%;">' . mb_strtoupper($direcReceptor['complemento'], 'UTF-8') . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">';
            foreach ($receptorMun as $muni) {
                $header3 .= '
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                break;
            }
            $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">';
            foreach ($receptorDep as $depto) {
                $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                break;
            }
            $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Moneda:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19) . '</td>
                            </tr>
                    </table>';

            $header = '<table style="width:100%; margin:0; padding:0;">
                                    <tr>
                                                    <td rowspan="2" style="width: 40%;">' . $header1 . '</td>
                                                    <td style="margin:0; padding:0; width: 60%;">' . $header2 . '</td>
                                    </tr>
                                    <tr>
                                                    <td style="margin:0; padding:0;">' . $qrCode . '</td>
                                    </tr>
                                    <tr>
                                                    <td colspan="2" style="margin:0; padding:0;">' . $header3 . '</td>
                                    </tr>
                    </table>';

            //$pdf->setPrintHeader(true);
            //$pdf->setHTMLHeader($header);

            $pdf->SetXY(4.5 + $x, 10.5 + $y);
            $pdf->writeHTML($header, true, false, true, false, '');

            /* --- FIN SECCION CABECERAS --- */

            //INICIO CUERPO DE DOCUMENTO CREDITO FISCAL
            /* --- INICIO SECCION PRODUCTOS --- */

            $cantLines = 0;
            $lineasPorProducto = 0;
            foreach ($cuerpoDocumento as $body) {
                $lineasPorProducto = ceil(strlen($body['descripcion']) / 57);
                $cantLines += $lineasPorProducto;
            }

            if ($cantLines <= 40) {
                $cantPages = 1;
            } elseif ($cantLines > 40 && $cantLines <= 113) {
                $cantPages = 2;
            } else {
                $cantPages = (ceil(abs($cantLines - 113) / 65)) + 2;
            }

            $numProd = 0;
            $maxlines = 40;

            $docLines = count($cuerpoDocumento);
            if ($docLines <= 40) {
                $maxlines = 40;
            } else {
                if ($docLines > 40 && $docLines <= 113) {
                    if ($docLines <= 44) {
                        $maxlines = 40;
                    } else {
                        $maxlines = 48;
                    }
                } else if ($docLines > 113) {
                    $maxlines = 48;
                }
            }

            $stop_index = $maxlines;
            $aux2 = 1;

            $productos = $this->invtran_model->getDataTran100k($trannum);
            $total = 0;
            $totalGravado = 0;
            $totalExento = 0;
            $totalIVA = 0;
            //$invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
            $invexento = 0;
            $vnExenta = 0;
            $vnGravada = 0;
            $numProd = 0; //linea echa para poder visualizar el pdf
            $ivaCesc = 0;
            $cesc = 0;
            $lineasOcupa = 0;
            $totalDesc = 0;
            $discount = 0;

            $bodyDoc = '
                    <table style="width:100%; padding:0px;">
                    <thead>
                        <tr style="width:100%; padding:0px;">
                                        <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:4.5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No. Item</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5.5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Código</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:46%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:8%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                        </tr>
                    </thead>';

            foreach ($productos as $pro) {
                //if($numProd < $maxlines){
                /*$ventaNosj = number_format(floatval($body['ventaNoSuj']), 4, '.', ',');
                $ventaExenta = number_format(floatval($body['ventaExenta']), 4, '.', ',');
                if($ventaNosj == '0'){
                                $ventaNosj = '';
                }
                if($ventaExenta == '0'){
                                $ventaExenta = '';
                }*/

                if ($pro->tax1 != 0 && $invexento == 0) {
                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                    $vnExenta = "";
                    //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                } else if ($pro->tax1 != 0 && $invexento == 1) {
                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                    $vnGravada = "";
                } else if ($pro->tax1 == 0 && $invexento == 0) {
                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                    $vnGravada = "";
                } else if ($pro->tax1 == 0 && $invexento == 1) {
                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                    $vnGravada = "";
                }

                $ivaSepa = 1 + ($pro->tax1 / 100);
                $preciouni = $pro->precioneto;
                if ($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != "") {
                    $discount = ($pro->descuento / 100) * $preciouni;
                    $totalDesc += $discount * abs($pro->cantidad);
                }

                if ($pro->notas != "") {
                    $notas = strtoupper(trim($pro->notas));
                } else {
                    $notas = "";
                }

                if ($pro->tipo == "4") {
                    $idpro = "";
                    $nombrepro = strtoupper(trim($notas));

                    if ($nombrepro == '') {
                        $nombrepro = strtoupper(trim($pro->descrip));
                    }
                } else {
                    $idpro = $pro->idproducto;
                    $nombrepro = strtoupper(trim($pro->descrip)) . ' ' . $notas;
                }

                $sumacantidad = (number_format(abs($pro->cantidad), 4, '.', '') - number_format(abs($pro->cantidad), 0, '.', ''));
                if ($sumacantidad != 0)
                    $cantidadPro = number_format(abs($pro->cantidad), 2, '.', '');
                else
                    $cantidadPro = number_format(abs($pro->cantidad), 0, '.', '');

                if ($numProd >= $stop_index) {
                    $breakValue = 'always';
                    $numProd = 0;
                    $aux2++;
                } else {
                    $breakValue = 'avoid';
                }

                $wrapped = wordwrap(trim(mb_strtoupper($nombrepro, 'UTF-8')), 57, '<br>');

                $bodyDoc .= '<tr style="width:100%; padding:0px; page-break-before: ' . $breakValue . ';">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:4.5%;">' . $pro->itemline . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5.5%;">' . $cantidadPro . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $pro->idproducto . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">' . $wrapped . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($preciouni, 6, '.', '') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $vnExenta . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $vnGravada . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                            </tr>';

                if ($aux2 > 1 && $aux2 <= $cantPages) {
                    $stop_index = 65;
                }

                $totalDesc = 0;
                $numProd += ceil(strlen($nombrepro) / 57);
                //$numProd++;
                //}
            }

            if ($cantPages > 1) {
                $maxlines = 65;
            }

            for ($i = $numProd; $i < $maxlines; $i++) {
                $bodyDoc .= '
                        <tr>
                            <td style="font-size: 9px; text-align:center; width:100%;"></td>
                        </tr>';
            }
            //$bodyDoc .='</table>';

            //$pdf->SetXY( 4.5 + $x, 93.5 + $y );
            //$pdf->writeHTML($bodyDoc, true, false, true, false, '');

            /* --- INICIO SECCION TOTALES --- */

            /* --- INICIO SECCION EXTENSION --- */

            $extention = '
                    <table style="width:100%; padding:0px; border: 0.1px solid #000; margin: 0px;">
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%; border-top: 0.1px solid #000;">Valor en letras:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%; border-top: 0.1px solid #000;">' . trim($resumen['totalLetras']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                        </tr>';
            if ($extension['observaciones'] == '') {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
            } else if (strlen(trim($extension['observaciones'])) <= 86) {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
            } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
            } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
            } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
            } else {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%; border-bottom: 0.1px solid #000;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                            </tr>';
            }

            $extention .= '
                    </table>';

            //$pdf->SetXY( 4.5, 210 );
            //$pdf->writeHTML($extention, true, false, true, false, '');

            /* --- INICIO SECCION TOTALES --- */

            $totals = '
                    <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; margin: 0px;">
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total descuentos</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalDescu'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>';
            foreach ($tributos as $trib) {
                $totals .= '
                            <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';

                $resumen['subTotal'] = floatval($trib["valor"]) + floatval($resumen['subTotal']);
            }
            $totals .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total otros montos no afectos</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%; border-bottom: 0.1px solid #000;">TOTAL A PAGAR</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-bottom: 0.1px solid #000;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                            </tr>
                    </table>';

            //$pdf->SetXY( 128.4, 210 );
            //$pdf->writeHTML($totals, true, false, true, false, '');

            /* --- FIN SECCION TOTALES --- */

            $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
            //$pdf->SetXY( 4.5, 265 );
            //$pdf->writeHTML($message, true, false, true, false, '');

            $bodyDoc .= '
                        <tr style="width:100%; margin: 0px; padding: 0px;">
                            <td style="width:60%; margin: 0px; padding: 0px; text-align: left;">' . $extention . '</td>
                            <td style="width:40%; margin: 0px; padding: 0px; text-align: left;">' . $totals . '</td>
                        </tr>
                        <tr style="width:100%;">
                            <td style="width:1%; margin: 0px; padding: 0px;"></td>
                            <td style="width:99%; margin: 0px; padding: 0px;">' . $message . '</td>
                        </tr>
                    </table>';

            $pdf->SetXY(4.5 + $x, 93.5 + $y);
            $pdf->writeHTML($bodyDoc, true, false, true, false, '');

            // FIN CUERPO DE DOCUMENTO CREDITO FISCAL

            /* --- GENERACION DE PDF --- */

            $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'] . '.pdf');
            $fullpath = $destinationFolder . $nombre_archivo;

            if ($statusDoc == 9) {
                // AGREGAR MARCA DE AGUA "ANULADO"
                $pdf->StartTransform();
                $pdf->Rotate(45, $pdf->getPageWidth() / 2, $pdf->getPageHeight() / 2);
                $pdf->SetFont('helvetica', 'B', 60);
                $pdf->SetTextColor(255, 0, 0);
                $pdf->SetAlpha(0.1);
                $pdf->Text(32, 150, 'ANULADO');
                $pdf->SetAlpha(1);
                $pdf->StopTransform();
            }

            /*
             *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
             *D: send to the browser and force a file download with the name given by name.
             *F: save to a local server file with the name given by name.
             *S: return the document as a string. name is ignored.
             *FI: equivalent to F + I option
             *FD: equivalent to F + D option
             */

            if ($docToSave == 0) {

                if ($docToSend == 0) {
                    $pdf->Output($nombre_archivo, 'I');

                    if (file_exists($portalMHImg))
                        unlink($portalMHImg);
                    if (file_exists($codGeneracionImg))
                        unlink($codGeneracionImg);
                    if (file_exists($selloRecibidoImg))
                        unlink($selloRecibidoImg);
                    if (file_exists($numeroControlImg))
                        unlink($numeroControlImg);
                } else {
                    $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                    //$pdf->Output($nombre_archivo, 'I');

                    if ($infoDoc->correo != '') {
                        $pdf->Output($fullpath, 'F');
                        $docIntern = (int) $nControlP[3];
                        $emiDate = date_format(date_create($identificacion['fecEmi']), "d/m/Y");

                        if (isset($receptor['nombre']))
                            $nameCliente = mb_strtoupper($receptor['nombre'], 'UTF-8');
                        if (isset($sujetoExcluido['nombre']))
                            $nameCliente = mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8');

                        $jsonFile = $this->createJsonFile($jsonInfo, $identificacion['codigoGeneracion'], $respHacienda, $firmaJson);

                        if (file_exists($portalMHImg))
                            unlink($portalMHImg);
                        if (file_exists($codGeneracionImg))
                            unlink($codGeneracionImg);
                        if (file_exists($selloRecibidoImg))
                            unlink($selloRecibidoImg);
                        if (file_exists($numeroControlImg))
                            unlink($numeroControlImg);

                        switch ($this->session->userdata('idaccount')) {
                            case '1490796':
                            case '4618':
                            case '2585TIENDAS':
                            //case '2815622':
                            case '1708':
                            case '3406536':
                            case '2535420':
                            case '2154998':
                            case '776777':
                            case '3338933':
                            case '2539313':
                            case '3317013':
                            case '1492935':
                                $response = $this->sendEmailWithPdf($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear);
                                break;
                            default:
                                $response = $this->sendEmailWithPdfResend($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);
                        }

                        if ($response == true) {
                            $title = 'Correo Enviado';
                            $bodyMsg = 'DTE enviado exitosamente a la direccion de correo <b style=\'color: #79bd53;\'>' . $infoDoc->correo . '</b>';
                            $type = 'success';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        } else {
                            $title = 'Error de Envio';
                            $bodyMsg = 'DTE no pudo ser enviado a la dirección de correo <b style=\'color: #f27474;\'>' . $infoDoc->correo . '</b>';
                            $type = 'error';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        }
                    } else {
                        $title = 'Error de Envio';
                        $bodyMsg = 'DTE no pudo ser enviado debido a que el cliente no tiene dirección de correo registrada en el sistema.';
                        $type = 'error';
                        echo $this->closeTabFunction($title, $bodyMsg, $type);
                    }
                }
            } else {
                $pdf->Output($fullpath, 'F');

                if (file_exists($portalMHImg))
                    unlink($portalMHImg);
                if (file_exists($codGeneracionImg))
                    unlink($codGeneracionImg);
                if (file_exists($selloRecibidoImg))
                    unlink($selloRecibidoImg);
                if (file_exists($numeroControlImg))
                    unlink($numeroControlImg);

                return $fullpath;
            }
        }
    }

    function creditoFiscalElectronicBills($trannum, $idYear = 0, $docToSend = 0, $docToSave = 0)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
        } else {
                $this->load->model('dev_model');
                $this->load->model('dte_model');
                $this->load->model('global_model');
                $this->load->model('pedclientes_model');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');
                $this->load->model('empleado_model');

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Documento Tributario Electrónico');
                $pdf->SetSubject('Documento Tributario Electrónico');
                $pdf->SetMargins(7.5, 15, 9, true);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetAutoPageBreak(TRUE, 7);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('helvetica', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                $x = 3;
                $y = 3;

                $informacion = $this->dev_model->electronicBills($trannum, $idYear);

                foreach ($informacion as $info) {
                        $jsonInfo = $info['jsonDoc'];
                        $sRecepcion = $info['sRecepcion'];
                        $respHacienda = $info['respHacienda'];
                        $firmaJson = $info['firmaJson'];
                        $statusDoc = $info['status'];
                }

                if (isset($jsonInfo['identificacion'])) $identificacion = $jsonInfo['identificacion'];
                if (isset($jsonInfo['documentoRelacionado'])) $documentoRelacionado = $jsonInfo['documentoRelacionado'];
                if (isset($jsonInfo['emisor'])) $emisor = $jsonInfo['emisor'];
                if (isset($emisor['direccion'])) $direcEmisor = $emisor['direccion'];
                if (isset($jsonInfo['receptor'])) $receptor = $jsonInfo['receptor'];
                if (isset($jsonInfo['sujetoExcluido'])) $sujetoExcluido = $jsonInfo['sujetoExcluido'];
                if (isset($receptor['direccion'])) $direcReceptor = $receptor['direccion'];
                if (isset($sujetoExcluido['direccion'])) $direcRsujetoExcluido = $sujetoExcluido['direccion'];
                if (isset($jsonInfo['ventaTercero'])) $ventaTercero = $jsonInfo['ventaTercero'];
                if (isset($jsonInfo['cuerpoDocumento'])) $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
                if (isset($jsonInfo['resumen'])) $resumen = $jsonInfo['resumen'];
                if (isset($resumen['tributos'])) $tributos  = $resumen['tributos']; else $tributos = array();
                if (isset($jsonInfo['extension'])) $extension = $jsonInfo['extension'];
                if (isset($jsonInfo['apendice'])) $apendice = $jsonInfo['apendice'];
                $tipoDocumento = '';
                $nameVendedor = '';
                $arrayFormasDePago = [];
                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                $infoFact = $this->ventas_model->getDatosFactura($trannum);
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
                $creditoPago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);

                foreach ($infoFact as $info) {
                    $idClase = $info->idclase;
                    $nameSucursal = $info->nameSucursal;
                    $nameVendedor = $info->nameVendedor;
                    $referenciaOT = $info->referencia;
                    $idCliente = (int) $info->idcliente;
                    $idCentro = (int) $info->idcentro;
                    $extension['observaciones'] = $info->notas;
                    $sucursalCliente = $info->nombre_c;
                    $direccionCliente = ($info->direccion_c == '') ? $info->direccion : $info->direccion_c;
                    $correoCliente = $info->correo_c;
                    $diasCliente = $info->dias;
                    if( $creditoPago != "" && $diasCliente > 0){
                        $diasCredito = $info->dias.' dias';
                    }else{
                        $diasCredito = '';
                    }
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip_c);
                }


                $municipioCliente = trim($zip_info['municipio']);
                $deptoCliente = trim($zip_info['depto']); 

                if ( $dteSucursal == 0 ) {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                    $nameImagen = $this->pedclientes_model->getnameImg();
                } else {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 10);
                    $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0'.$idCentro);
                }

                if (count($detailPagos) > 0) {
                    foreach ($detailPagos as $key => $dtpagos) {
                        $arrayFormasDePago[$key] = trim($dtpagos->namePago);
                    }
    
                    $condicionPago['descrip'] = implode(", ", $arrayFormasDePago);
                }

                $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
                $modeloFacturacion = explode(" ", $modFac['descrip']);
                $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
                $tipoTransmision = explode(" ", $tipoTrans['descrip']);
                $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
                $tipoDocumento = $identificacion['tipoDte'];

                $sucursalInfo = $this->sucursal_model->getSucursal($idCentro);

                if ($sucursalInfo != false || $sucursalInfo != null) {
                    if ($sucursalInfo->direccion != '') {
                        $deptoMuniDist = $this->dev_model->getDeptoMuniDistritoDTE($sucursalInfo->idzip);

                        if ($deptoMuniDist != false || $deptoMuniDist != null) {
                            $direcEmisor['complemento'] = $sucursalInfo->direccion.', '.$deptoMuniDist[0]->distrito.', '.$deptoMuniDist[0]->municipio.', '.$deptoMuniDist[0]->depto;
                        } else {
                            $direcEmisor['complemento'] = $sucursalInfo->direccion;
                        }

                    }

                    if ($sucursalInfo->telefono != '') {
                        $emisor['telefono'] = $sucursalInfo->telefono;
                    }
                }

                /* --- INICIO SECCION CABECERAS --- */
                $emisorEstab = array();
                if (isset($emisor['tipoEstablecimiento'])) {
                        $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
                }

                if (!isset($emisorEstab['descrip'])) $emisorEstab['descrip'] = '';

                $imgHeader1Hght = '20px';
                if($this->session->userdata('idaccount') == '1937326') {
                    $imgHeader1Hght = '73px';
                }

                if($this->session->userdata('idaccount') == '90476') {
                    $imgHeader1Hght = '15px';
                    if ($idCentro == 2) {
                        $nameImagen = 'BostonLogo.png';
                    }
                }

                $fontSize = '9px';
                if($this->session->userdata('idaccount') == '1784550') {
                    $fontSize = '8.5px';
                }

                if($this->session->userdata('idaccount') == '2922210'){
                    $header1 = '
                        <table style="width:100%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height: 25px;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; text-decoration: underline;">'.substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. '.substr($emisor['telefono'].' Sucursal: '.$nameSucursal, 0, 44).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: '.substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: '.substr($emisor['nit'], 0, 19).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: '.substr($emisor['nrc'], 0, 19).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: '.substr($nameVendedor, 0, 40).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: '.$trannum.'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height: 49px;"></td>
                            </tr>';
                        $header1 .= '</table>';
                } else{
                    $header1 = '
                        <table style="width:100%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: '.$imgHeader1Hght.';"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">'.substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$fontSize.'; width:100%;">'.substr(mb_strtoupper($direcEmisor['complemento']), 0, 120).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. '.substr($emisor['telefono'].' Sucursal: '.$nameSucursal, 0, 44).'</td>
                            </tr>';
                            if($this->session->userdata('idaccount') == '2585TIENDAS'){
                                $header1 .=
                                    '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">facturacionelectronica@laiberica.net</td>
                                    </tr>';

                            }else{
                                $header1 .= 
                                    '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                                    </tr>';
                            }
                        $header1 .=
                            '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: '.substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: '.substr($emisor['nit'], 0, 19).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: '.substr($emisor['nrc'], 0, 19).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: '.substr($nameVendedor, 0, 40).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: '.$trannum.'</td>
                            </tr>';
                        $header1 .= '</table>';
                }

                $header2 = '
                    <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['numeroControl'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . $identificacion['version'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($tipoTransmision[array_key_last($tipoTransmision)]) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . date_format(date_create($identificacion['fecEmi']), "d/m/Y") . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . date_format(date_create($identificacion['horEmi']), "h:i:s A") . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

                $nControlP = explode('-', $identificacion['numeroControl']);

                $header2 .= '
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . (int) $nControlP[3] . '</td>
                        </tr>';
                $header2 .= '</table>';

                $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT']."dte_files", '/') . "/";

                $portalMHImg = $destinationFolder.$identificacion['codigoGeneracion'].'-MH.png';
                $codGeneracionImg = $destinationFolder.$identificacion['codigoGeneracion'].'.png';
                $selloRecibidoImg = $destinationFolder.$sRecepcion.'.png';
                $numeroControlImg = $destinationFolder.$identificacion['numeroControl'].'.png';
                
                if (!is_dir($destinationFolder)) {
                    mkdir($destinationFolder, 0777, true);
                }

                $this->createQrImage('https://admin.factura.gob.sv/consultaPublica?ambiente=' . $identificacion['ambiente'] . '&codGen=' . $identificacion['codigoGeneracion'] . '&fechaEmi=' . $identificacion['fecEmi'], 'Portal de Hacienda', $portalMHImg);
                $this->createQrImage($identificacion['codigoGeneracion'], 'Cód. Generación', $codGeneracionImg);
                $this->createQrImage($sRecepcion, 'Sello Recibido', $selloRecibidoImg);
                $this->createQrImage($identificacion['numeroControl'], 'N° de Control', $numeroControlImg);

                $qrCode = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                            <img src="' . $portalMHImg . '" style="height: 95px;"/>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="' . $codGeneracionImg . '" style="height: 75px;"/>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="' . $selloRecibidoImg . '" style="height: 75px;"/>
                        </td>
                        <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="' . $numeroControlImg . '" style="height: 75px;"/>
                        </td>
                    </tr>
                </table>';

                if (isset($direcReceptor)) {
                        $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'], $direcReceptor['departamento']);
                        $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
                } else {
                        $receptorMun = array();
                        $receptorDep = array();
                }

                if (isset($direcRsujetoExcluido)) {
                        $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'], $direcRsujetoExcluido['departamento']);
                        $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
                } else {
                        $sujetoExcluidoMun = array();
                        $sujetoExcluidoDep = array();
                }

                $receptorDoc = array();
                if (isset($receptor['tipoDocumento'])) {
                        if ($receptor['tipoDocumento'] != '') {
                                $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'], 'CAT-022');
                        }
                }

                $sujetoExcluidoDoc = array();
                if (isset($sujetoExcluido['tipoDocumento'])) {
                        if ($sujetoExcluido['tipoDocumento'] != '') {
                                $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'], 'CAT-022');
                        }
                }

                if (!isset($receptorDoc['descrip'])) {
                        $receptorDoc['descrip'] = 'Doc. Identificación';
                }

                if (!isset($sujetoExcluidoDoc['descrip'])) {
                        $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
                }

                if (!isset($receptor['nombreComercial'])) {
                        $receptor['nombreComercial'] = '';
                }

                if (!isset($direcReceptor['complemento'])) {
                        $direcReceptor['complemento'] = '';
                }

                if (!isset($direcRsujetoExcluido['complemento'])) {
                        $direcRsujetoExcluido['complemento'] = '';
                }

                if (!isset($receptor['correo'])) {
                        $receptor['correo'] = '';
                }

                $condicionPago = array();
                if (isset($resumen['condicionOperacion'])) {
                        if ($resumen['condicionOperacion'] != '') {
                                $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'], 'CAT-016');
                        }
                } else {
                        $condicionPago['descrip'] = '';
                }

                if (count($detailPagos) > 0) {
                    foreach ($detailPagos as $key => $dtpagos) {
                        $arrayFormasDePago[$key] = trim($dtpagos->namePago);
                    }
    
                    $condicionPago['descrip'] = implode(", ", $arrayFormasDePago);
                }

                if (!isset($extension['observaciones'])) {
                        $extension['observaciones'] = '';
                }

                if (!isset($extension['nombEntrega'])) {
                        $extension['nombEntrega'] = '';
                }

                if (!isset($extension['docuEntrega'])) {
                        $extension['docuEntrega'] = '';
                }

                if (!isset($extension['nombRecibe'])) {
                        $extension['nombRecibe'] = '';
                }

                if (!isset($extension['docuRecibe'])) {
                        $extension['docuRecibe'] = '';
                }

                $direcFontSize = '8px';
                
                if (strlen($direcReceptor['complemento']) > 89) {
                    $direcFontSize = '7.5px';
                }

                $ordenString = '';
                switch($this->session->userdata('idaccount')) {
                    case '291862':
                    case '2922210':
                        $ordenString = 'Orden:';
                    break;
                    case '1828465':
                        $ordenString = 'Referencia:';
                        $referenciaOT = mb_substr(trim($referenciaOT), 0, 20, 'UTF-8');
                    break;
                    default:
                        $referenciaOT = '';
                }

                if ($this->session->userdata('idaccount') == '3246049') {
                    if ($diasCliente <= 3) {
                        $condicionPago['descrip'] = 'Contado';
                    } else {
                        $condicionPago['descrip'] = 'Crédito';
                    }
                }
                
                $sucursalClienteFontSize = '9px';
                $razonSocialFontSize = '9px';

                if( $sucursalCliente != '') {
                    if(strlen($sucursalCliente) > 54) {
                        $sucursalClienteFontSize = '8px';
                    }
                }

                if (strlen($receptor['nombre']) > 54) {
                    $razonSocialFontSize = '8px';
                }

                $header3 = '
                    <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$razonSocialFontSize.'; width:54%;">' . mb_substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 60, 'UTF-8').'</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">'. $ordenString .'</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.8px; width:16%;">'.trim($referenciaOT).'</td>
                        </tr>';
                        if( $sucursalCliente != '') {
                            $header3 .= '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9.8px; width:13%;">Nombre comercial:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$sucursalClienteFontSize.'; width:54%;">' . mb_substr(mb_strtoupper($sucursalCliente, 'UTF-8'), 0, 60, 'UTF-8').'</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.8px; width:16%;"></td>
                            </tr>';
                        }
                        $header3 .= '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(($correoCliente == '') ? $receptor['correo'] : $correoCliente, 0, 64) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$direcFontSize.'; width:59%;">' . mb_strtoupper($direccionCliente, 'UTF-8') . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($municipioCliente, 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td><td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 7px; width:16%;">' . substr(mb_strtoupper($condicionPago['descrip'], 'UTF-8'), 0, 19). ' '.$diasCredito.'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($deptoCliente, 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Moneda:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19) . '</td>
                        </tr>
                </table>';

                $header = '<table style="width:100%; margin:0; padding:0;">
                                <tr>
                                                <td rowspan="2" style="width: 40%;">' . $header1 . '</td>
                                                <td style="margin:0; padding:0; width: 60%;">' . $header2 . '</td>
                                </tr>
                                <tr>
                                                <td style="margin:0; padding:0;">' . $qrCode . '</td>
                                </tr>
                                <tr>
                                                <td colspan="2" style="margin:0; padding:0;">' . $header3 . '</td>
                                </tr>
                </table>';

                //$pdf->setPrintHeader(true);
                //$pdf->setHTMLHeader($header);

                $pdf->SetXY(4.5 + $x, 10.5 + $y);
                $pdf->writeHTML($header, true, false, true, false, '');

                /* --- FIN SECCION CABECERAS --- */

                //INICIO CUERPO DE DOCUMENTO CREDITO FISCAL
                /* --- INICIO SECCION PRODUCTOS --- */

                $cantLines = 0;
                $lineasPorProducto = 0;
                foreach($cuerpoDocumento as $body){
                    if ($this->session->userdata('idaccount') == '1828465') {
                        $infoExtraProTran100k = $this->dte_model->getInfoExtraProductoTran100k($trannum, $body['codigo']);
                        if ($infoExtraProTran100k->notas != '') {
                            $body['descripcion'] = trim($infoExtraProTran100k->notas);
                        }
                    }

                    $lineasPorProducto = ceil(strlen($body['descripcion']) / 57);
                    $cantLines += $lineasPorProducto;
                }

                if ($cantLines <= 40) {
                    $cantPages = 1;
                } elseif ($cantLines > 40 && $cantLines <= 113) {
                    $cantPages = 2;
                } else {
                    $cantPages = (ceil(abs($cantLines - 113) / 65)) + 2;
                }

                $numProd = 0;
                $maxlines = 40;

                $docLines = count($cuerpoDocumento);
                if ($docLines <= 40) {
                    $maxlines = 40;
                } else {
                    if ($docLines > 40 && $docLines <= 113) {
                        if ($docLines <= 44) {
                            $maxlines = 40;
                        } else {
                            $maxlines = 48;
                        }
                    } else if ($docLines > 113) {
                        $maxlines = 48;
                    }
                }

                $stop_index = $maxlines;
                $aux2 = 1;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                //$invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $invexento = 0;
                $vnExenta = 0;
                $vnGravada = 0;
                $numProd = 0; //linea echa para poder visualizar el pdf
                $ivaCesc = 0;
                $cesc = 0;
                $lineasOcupa = 0;
                $totalDesc = 0;
                $discount = 0;

                $codigomodeloHeader = '';
                if ($this->session->userdata('idaccount') == '3131999'){
                    $codigomodeloHeader = 'Modelo';
                }else{
                    $codigomodeloHeader = 'Código';
                }

                $bodyDoc = '
                <table style="width:100%; padding:0px;">
                <thead>
                    <tr style="width:100%; padding:0px;">
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:4.5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">No. Item</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5.5%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">'.$codigomodeloHeader.'</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:46%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:8%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                    </tr>
                </thead>';

                foreach ($productos as $key => $pro) {
                        //if($numProd < $maxlines){

                        if ($pro->tax1 != 0 && $invexento == 0) {
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "";
                                //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                        } else if ($pro->tax1 != 0 && $invexento == 1) {
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                        } else if ($pro->tax1 == 0 && $invexento == 0) {
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                        } else if ($pro->tax1 == 0 && $invexento == 1) {
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                        }

                        $ivaSepa = 1 + ($pro->tax1 / 100);
                        $preciouni = $pro->precioneto;
                        if ($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != "") {
                                $discount =  ($pro->descuento / 100) * $preciouni;
                                $totalDesc += $discount * abs($pro->cantidad);
                        }

                        if ($pro->notas != "") {
                                $notas = strtoupper(trim($pro->notas));
                        } else {
                                $notas = "";
                        }

                        if ($pro->tipo == "4") {
                                $idpro = "";
                                $nombrepro = strtoupper(trim($notas));

                                if ( $nombrepro == '' ) {
                                    $nombrepro = strtoupper(trim($pro->descrip));
                                }
                        } else {
                                $idpro = $pro->idproducto;
                                $nombrepro = strtoupper(trim($pro->descrip)).' '.$notas;
                        }

                        $sumacantidad = (number_format(abs($pro->cantidad), 4, '.', '') - number_format(abs($pro->cantidad), 0, '.', ''));
                        if ($sumacantidad != 0) $cantidadPro = number_format(abs($pro->cantidad), 2, '.', '');
                        else $cantidadPro = number_format(abs($pro->cantidad), 0, '.', '');

                        if ($numProd >= $stop_index) {
                                $breakValue = 'always';
                                $numProd = 0;
                                $aux2++;
                        } else {
                                $breakValue = 'avoid';
                        }

                        if ($statusDoc == 9) {
                            $cantidadPro = $cuerpoDocumento[$key]['cantidad'];
                            $preciouni = number_format(floatval($cuerpoDocumento[$key]['precioUni']), 6, '.', '');
                            $vnGravada = number_format(floatval($cuerpoDocumento[$key]['ventaGravada']), 4, '.', ',');
                            $vnExenta = number_format(floatval($cuerpoDocumento[$key]['ventaExenta']), 4, '.', ',');
                            if($vnGravada == '0'){
                                $vnGravada = '';
                            }
                            if($vnExenta == '0'){
                                $vnExenta = '';
                            }
                        }

                        if ($this->session->userdata('idaccount') == '1828465') {
                            if ($pro->notas != '') {
                                $nombrepro = mb_strtoupper(trim($pro->notas), 'UTF-8');
                            }
                        }

                        
                        $infoExtraPro = $this->dte_model->getInfoExtraProducto($pro->idproducto);
                        $codigomodelo = $pro->idproducto;
                        if ($this->session->userdata('idaccount') == '3131999'){
                            $codigomodelo = $infoExtraPro->modelo;
                        }
                        

                        $wrapped = wordwrap(trim(mb_strtoupper($nombrepro, 'UTF-8')), 57, '<br>');

                        $bodyDoc .= '<tr style="width:100%; padding:0px; page-break-before: ' . $breakValue . ';">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:4.5%;">' . $pro->itemline . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5.5%;">' . $cantidadPro . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $codigomodelo . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">' . $wrapped . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($preciouni, 6, '.', '') . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $vnExenta . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $vnGravada . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                        </tr>';

                        if ($aux2 > 1 && $aux2 <= $cantPages) {
                            $stop_index = 65;
                        }

                        //$totalDesc = 0;
                        $numProd += ceil(strlen($nombrepro) / 57);
                        //$numProd++;
                        //}
                }

                if ($cantPages > 1) {
                    $maxlines = 65;
                }

                for ($i = $numProd; $i < $maxlines; $i++) {
                    $bodyDoc .= '
                    <tr>
                        <td style="font-size: 9px; text-align:center; width:100%;"></td>
                    </tr>';
                }
                //$bodyDoc .='</table>';

                //$pdf->SetXY( 4.5 + $x, 93.5 + $y );
                //$pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                <table style="width:100%; padding:0px; border: 0.1px solid #000; margin: 0px;">
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%; border-top: 0.1px solid #000;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%; border-top: 0.1px solid #000;">' . trim($resumen['totalLetras']) . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                    </tr>';
                if ($extension['observaciones'] == '') {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                        </tr>';
                } else if (strlen(trim($extension['observaciones'])) <= 86) {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                        </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                        </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                        </tr>';
                } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                        </tr>';
                } else {
                        $extention .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%; border-bottom: 0.1px solid #000;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                        </tr>';
                }

                $extention .= '
                </table>';

                //$pdf->SetXY( 4.5, 210 );
                //$pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; margin: 0px;">
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total descuentos</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($totalDesc, 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>';
                foreach ($tributos as $trib) {
                        $totals .= '
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>';

                    $resumen['subTotal'] = floatval($trib["valor"]) + floatval($resumen['subTotal']);
                }
                $totals .= '
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total otros montos no afectos</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%; border-bottom: 0.1px solid #000;">TOTAL A PAGAR</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-bottom: 0.1px solid #000;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                        </tr>
                </table>';

                //$pdf->SetXY( 128.4, 210 );
                //$pdf->writeHTML($totals, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                //$pdf->SetXY( 4.5, 265 );
                //$pdf->writeHTML($message, true, false, true, false, '');

                $bodyDoc .= '
                    <tr style="width:100%; margin: 0px; padding: 0px;">
                        <td style="width:60%; margin: 0px; padding: 0px; text-align: left;">' . $extention . '</td>
                        <td style="width:40%; margin: 0px; padding: 0px; text-align: left;">' . $totals . '</td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:1%; margin: 0px; padding: 0px;"></td>
                        <td style="width:99%; margin: 0px; padding: 0px;">' . $message . '</td>
                    </tr>
                </table>';

                $pdf->SetXY(4.5 + $x, 96.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                // FIN CUERPO DE DOCUMENTO CREDITO FISCAL

                // AGREGAR MARCA DE AGUA "ANULADO"
                if ($statusDoc == 9) {
                    $pdf->StartTransform();
                    $pdf->Rotate(45, $pdf->getPageWidth() / 2, $pdf->getPageHeight() / 2);
                    $pdf->SetFont('helvetica', 'B', 60);
                    $pdf->SetTextColor(255, 0, 0);
                    $pdf->SetAlpha(0.1);
                    $pdf->Text(32, 145, 'ANULADO');
                    $pdf->SetAlpha(1);
                    $pdf->StopTransform();
                }

                /* --- GENERACION DE PDF --- */

                $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'] . '.pdf');
                $fullpath = $destinationFolder.$nombre_archivo;

                /*
                *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
                *D: send to the browser and force a file download with the name given by name.
                *F: save to a local server file with the name given by name.
                *S: return the document as a string. name is ignored.
                *FI: equivalent to F + I option
                *FD: equivalent to F + D option
                */

            if ($docToSave == 0) {

                if ($docToSend == 0) {
                        $pdf->Output($nombre_archivo, 'I');

                        if(file_exists($portalMHImg)) unlink($portalMHImg);
                        if(file_exists($codGeneracionImg)) unlink($codGeneracionImg);
                        if(file_exists($selloRecibidoImg)) unlink($selloRecibidoImg);
                        if(file_exists($numeroControlImg)) unlink($numeroControlImg);
                } else {
                        $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                        //$pdf->Output($nombre_archivo, 'I');

                        if ($infoDoc->correo != '') {
                                $pdf->Output($fullpath, 'F');
                                $docIntern = (int) $nControlP[3];
                                $emiDate = date_format(date_create($identificacion['fecEmi']), "d/m/Y");

                                if (isset($receptor['nombre'])) $nameCliente = mb_strtoupper($receptor['nombre'], 'UTF-8');
                                if (isset($sujetoExcluido['nombre'])) $nameCliente = mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8');

                                $jsonFile = $this->createJsonFile($jsonInfo, $identificacion['codigoGeneracion'], $respHacienda, $firmaJson);

                                if ($this->session->userdata('idaccount') == '334340') {
                                    $infoDoc->correo = ($correoCliente == '') ? $infoDoc->correo : $correoCliente;
                                }

                                if(file_exists($portalMHImg)) unlink($portalMHImg);
                                if(file_exists($codGeneracionImg)) unlink($codGeneracionImg);
                                if(file_exists($selloRecibidoImg)) unlink($selloRecibidoImg);
                                if(file_exists($numeroControlImg)) unlink($numeroControlImg);

                                switch($this->session->userdata('idaccount')) {
                                    case '1490796':
                                    case '4618':
                                    case '2585TIENDAS':
                                    //case '2815622':
                                    case '1708':
                                    case '3406536':
                                    case '2535420':
                                    case '2154998':
                                    case '776777':
                                    case '3338933':
                                    case '2539313':
                                    case '3317013':
                                    case '1492935':
                                        if ($statusDoc == 9) {
                                            $response = $this->sendEmailWithPdfAnulado($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear);
                                        } else {
                                            $response = $this->sendEmailWithPdf($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear);
                                        }
                                    break;
                                    default:
                                        if ($statusDoc == 9) {
                                            $response = $this->sendEmailWithPdfResendAnulado($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);
                                        } else {
                                            $response = $this->sendEmailWithPdfResend($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);
                                        }
                                }

                                if ($response == true) {
                                        $title = 'Correo Enviado';
                                        $bodyMsg = 'DTE enviado exitosamente a la direccion de correo <b style=\'color: #79bd53;\'>' . $infoDoc->correo . '</b>';
                                        $type = 'success';
                                        echo $this->closeTabFunction($title, $bodyMsg, $type);
                                } else {
                                        $title = 'Error de Envio';
                                        $bodyMsg = 'DTE no pudo ser enviado a la dirección de correo <b style=\'color: #f27474;\'>' . $infoDoc->correo . '</b>';
                                        $type = 'error';
                                        echo $this->closeTabFunction($title, $bodyMsg, $type);
                                }
                        } else {
                                $title = 'Error de Envio';
                                $bodyMsg = 'DTE no pudo ser enviado debido a que el cliente no tiene dirección de correo registrada en el sistema.';
                                $type = 'error';
                                echo $this->closeTabFunction($title, $bodyMsg, $type);
                        }
                }
            } else {
                $pdf->Output($fullpath, 'F');

                if(file_exists($portalMHImg)) unlink($portalMHImg);
                if(file_exists($codGeneracionImg)) unlink($codGeneracionImg);
                if(file_exists($selloRecibidoImg)) unlink($selloRecibidoImg);
                if(file_exists($numeroControlImg)) unlink($numeroControlImg);

                return $fullpath;
            }
        }
    }

    function notaCreditoElectronicBills($trannum, $idYear = 0, $docToSend = 0, $docToSave = 0)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('login/cerrar_sesion');
        } else {
            $this->load->model('dev_model');
            $this->load->model('dte_model');
            $this->load->model('global_model');
            $this->load->model('pedclientes_model');
            $this->load->model('ventas_model');
            $this->load->model('invtran_model');
            $this->load->model('sucursal_model');
            $this->load->model('empleado_model');

            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Documento Tributario Electrónico');
            $pdf->SetSubject('Documento Tributario Electrónico');
            $pdf->SetMargins(7.5, 15, 9, true);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetAutoPageBreak(TRUE, 7);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
            $pdf->SetFont('helvetica', '', 7.5, '', true);
            $pdf->addPage('P', 'LETTER');

            $x = 3;
            $y = 3;

            $informacion = $this->dev_model->electronicBills($trannum, $idYear);

            foreach ($informacion as $info) {
                $jsonInfo = $info['jsonDoc'];
                $sRecepcion = $info['sRecepcion'];
                $respHacienda = $info['respHacienda'];
                $firmaJson = $info['firmaJson'];
                $statusDoc = $info['status'];
            }

            if (isset($jsonInfo['identificacion']))
                $identificacion = $jsonInfo['identificacion'];
            if (isset($jsonInfo['documentoRelacionado']))
                $documentoRelacionado = $jsonInfo['documentoRelacionado'];
            if (isset($jsonInfo['emisor']))
                $emisor = $jsonInfo['emisor'];
            if (isset($emisor['direccion']))
                $direcEmisor = $emisor['direccion'];
            if (isset($jsonInfo['receptor']))
                $receptor = $jsonInfo['receptor'];
            if (isset($jsonInfo['sujetoExcluido']))
                $sujetoExcluido = $jsonInfo['sujetoExcluido'];
            if (isset($receptor['direccion']))
                $direcReceptor = $receptor['direccion'];
            if (isset($sujetoExcluido['direccion']))
                $direcRsujetoExcluido = $sujetoExcluido['direccion'];
            if (isset($jsonInfo['ventaTercero']))
                $ventaTercero = $jsonInfo['ventaTercero'];
            if (isset($jsonInfo['cuerpoDocumento']))
                $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
            if (isset($jsonInfo['resumen']))
                $resumen = $jsonInfo['resumen'];
            if (isset($resumen['tributos']))
                $tributos = $resumen['tributos'];
            else
                $tributos = array();
            if (isset($jsonInfo['extension']))
                $extension = $jsonInfo['extension'];
            if (isset($jsonInfo['apendice']))
                $apendice = $jsonInfo['apendice'];
            $tipoDocumento = '';
            $nameVendedor = '';
            $arrayFormasDePago = [];
            $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
            $infoFact = $this->ventas_model->getDatosFactura($trannum);
            $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
            //var_dump($documentoRelacionado);
            $referenciaOT = $documentoRelacionado[0]['numeroDocumento'];
            $fecEmisionDocRelacionado = $documentoRelacionado[0]['fechaEmision'];

            foreach ($infoFact as $info) {
                $idClase = $info->idclase;
                $nameSucursal = $info->nameSucursal;
                $nameVendedor = $info->nameVendedor;
                if ($this->session->userdata('idaccount') == '291862' || $this->session->userdata('idaccount') == '1828465') {
                    $referenciaOT = $info->referencia;
                }
                $idCliente = (int) $info->idcliente;
                $idCentro = (int) $info->idcentro;
                $extension['observaciones'] = $info->notas;
                $sucursalCliente = $info->nombre_c;
                $direccionCliente = ($info->direccion_c == '') ? $info->direccion : $info->direccion_c;
                $correoCliente = $info->correo_c;
                $diasCliente = $info->dias;

                $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip_c);
            }

            $municipioCliente = trim($zip_info['municipio']);
            $deptoCliente = trim($zip_info['depto']); 

            if ($dteSucursal == 0) {
                $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                $nComercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                $categoria = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                $nameImagen = $this->pedclientes_model->getnameImg();
            } else {
                $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0' . $idCentro, 1);
                $nComercial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0' . $idCentro, 2);
                $categoria = $this->global_model->getDatosGeneralesEmp('g_empdatos_0' . $idCentro, 10);
                $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0' . $idCentro);
            }

            $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
            $modeloFacturacion = explode(" ", $modFac['descrip']);
            $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
            $tipoTransmision = explode(" ", $tipoTrans['descrip']);
            $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
            $tipoDocumento = $identificacion['tipoDte'];

            $sucursalInfo = $this->sucursal_model->getSucursal($idCentro);

            if ($sucursalInfo != false || $sucursalInfo != null) {
                if ($sucursalInfo->direccion != '') {
                    $deptoMuniDist = $this->dev_model->getDeptoMuniDistritoDTE($sucursalInfo->idzip);

                    if ($deptoMuniDist != false || $deptoMuniDist != null) {
                        $direcEmisor['complemento'] = $sucursalInfo->direccion.', '.$deptoMuniDist[0]->distrito.', '.$deptoMuniDist[0]->municipio.', '.$deptoMuniDist[0]->depto;
                    } else {
                        $direcEmisor['complemento'] = $sucursalInfo->direccion;
                    }

                }

                if ($sucursalInfo->telefono != '') {
                    $emisor['telefono'] = $sucursalInfo->telefono;
                }
            }

            /* --- INICIO SECCION CABECERAS --- */
            $emisorEstab = array();
            if (isset($emisor['tipoEstablecimiento'])) {
                $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
            }

            if (!isset($emisorEstab['descrip']))
                $emisorEstab['descrip'] = '';

            $imgHeader1Hght = '20px';
            if ($this->session->userdata('idaccount') == '1937326') {
                $imgHeader1Hght = '73px';
            }

            if ($this->session->userdata('idaccount') == '90476') {
                $imgHeader1Hght = '15px';
                if ($idCentro == 2) {
                    $nameImagen = 'BostonLogo.png';
                }
            }

            $fontSize = '8.8px';
            if ($this->session->userdata('idaccount') == '1784550') {
                $fontSize = '8.5px';
            }

            if ($this->session->userdata('idaccount') == '2922210') {
                $header1 = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height: 25px;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; text-decoration: underline;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height: 49px;"></td>
                        </tr>
                    </table>';
            } else {
                $header1 = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: ' . $imgHeader1Hght . ';"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="' . FCPATH . 'img_cuentas/' . $this->session->userdata('diraccount') . '/' . $nameImagen . '"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: ' . $fontSize . '; width:100%;">' . substr(mb_strtoupper($direcEmisor['complemento']), 0, 112) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                        </tr>';
                if ($this->session->userdata('idaccount') == '2585TIENDAS') {
                    $header1 .=
                        '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">facturacionelectronica@laiberica.net</td>
                                </tr>';
                } else {
                    $header1 .=
                        '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                                </tr>';
                }
                $header1 .=
                    '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                        </tr>
                    </table>';
            }

            $header2 = '
                <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['numeroControl'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]) . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . $identificacion['version'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($tipoTransmision[array_key_last($tipoTransmision)]) . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . date_format(date_create($identificacion['fecEmi']), "d/m/Y") . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . date_format(date_create($identificacion['horEmi']), "h:i:s A") . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

            $nControlP = explode('-', $identificacion['numeroControl']);

            $header2 .= '
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . (int) $nControlP[3] . '</td>
                    </tr>
                </table>';

            $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT'] . "dte_files", '/') . "/";

            $portalMHImg = $destinationFolder . $identificacion['codigoGeneracion'] . '-MH.png';
            $codGeneracionImg = $destinationFolder . $identificacion['codigoGeneracion'] . '.png';
            $selloRecibidoImg = $destinationFolder . $sRecepcion . '.png';
            $numeroControlImg = $destinationFolder . $identificacion['numeroControl'] . '.png';

            if (!is_dir($destinationFolder)) {
                mkdir($destinationFolder, 0777, true);
            }

            $this->createQrImage('https://admin.factura.gob.sv/consultaPublica?ambiente=' . $identificacion['ambiente'] . '&codGen=' . $identificacion['codigoGeneracion'] . '&fechaEmi=' . $identificacion['fecEmi'], 'Portal de Hacienda', $portalMHImg);
            $this->createQrImage($identificacion['codigoGeneracion'], 'Cód. Generación', $codGeneracionImg);
            $this->createQrImage($sRecepcion, 'Sello Recibido', $selloRecibidoImg);
            $this->createQrImage($identificacion['numeroControl'], 'N° de Control', $numeroControlImg);

            $qrCode = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                            <img src="' . $portalMHImg . '" style="height: 95px;"/>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="' . $codGeneracionImg . '" style="height: 75px;"/>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="' . $selloRecibidoImg . '" style="height: 75px;"/>
                        </td>
                        <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="' . $numeroControlImg . '" style="height: 75px;"/>
                        </td>
                    </tr>
                </table>';

            if (isset($direcReceptor)) {
                $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'], $direcReceptor['departamento']);
                $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
            } else {
                $receptorMun = array();
                $receptorDep = array();
            }

            if (isset($direcRsujetoExcluido)) {
                $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'], $direcRsujetoExcluido['departamento']);
                $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
            } else {
                $sujetoExcluidoMun = array();
                $sujetoExcluidoDep = array();
            }

            $receptorDoc = array();
            if (isset($receptor['tipoDocumento'])) {
                if ($receptor['tipoDocumento'] != '') {
                    $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'], 'CAT-022');
                }
            }

            $sujetoExcluidoDoc = array();
            if (isset($sujetoExcluido['tipoDocumento'])) {
                if ($sujetoExcluido['tipoDocumento'] != '') {
                    $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'], 'CAT-022');
                }
            }

            if (!isset($receptorDoc['descrip'])) {
                $receptorDoc['descrip'] = 'Doc. Identificación';
            }

            if (!isset($sujetoExcluidoDoc['descrip'])) {
                $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
            }

            if (!isset($receptor['nombreComercial'])) {
                $receptor['nombreComercial'] = '';
            }

            if (!isset($direcReceptor['complemento'])) {
                $direcReceptor['complemento'] = '';
            }

            if (!isset($direcRsujetoExcluido['complemento'])) {
                $direcRsujetoExcluido['complemento'] = '';
            }

            if (!isset($receptor['correo'])) {
                $receptor['correo'] = '';
            }

            $condicionPago = array();
            if (isset($resumen['condicionOperacion'])) {
                if ($resumen['condicionOperacion'] != '') {
                    $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'], 'CAT-016');
                }
            } else {
                $condicionPago['descrip'] = '';
            }

            if (count($detailPagos) > 0) {
                foreach ($detailPagos as $key => $dtpagos) {
                    $arrayFormasDePago[$key] = trim($dtpagos->namePago);
                }
                
                $condicionPago['descrip'] = implode(", ", $arrayFormasDePago);
            }

            if (!isset($extension['observaciones'])) {
                $extension['observaciones'] = '';
            }

            if (!isset($extension['nombEntrega'])) {
                $extension['nombEntrega'] = '';
            }

            if (!isset($extension['docuEntrega'])) {
                $extension['docuEntrega'] = '';
            }

            if (!isset($extension['nombRecibe'])) {
                $extension['nombRecibe'] = '';
            }

            if (!isset($extension['docuRecibe'])) {
                $extension['docuRecibe'] = '';
            }

            $direcFontSize = '8px';

            if (strlen($direcReceptor['complemento']) > 89) {
                $direcFontSize = '7.5px';
            }

            // if ($this->session->userdata('idaccount') == '291862') {
            //     $ordenString = 'Orden:';
            //     $nombreWidth = '54%';
            // } else {
            //     $ordenString = 'Referencia:';
            //     $nombreWidth = '59%';
            // }

            switch($this->session->userdata('idaccount')) {
                case '291862':
                    $ordenString = 'Orden:';
                    $nombreWidth = '54%';
                break;
                case '1828465':
                    $ordenString = 'Referencia:';
                    $nombreWidth = '59%';
                    $referenciaOT = mb_substr(trim($referenciaOT), 0, 20, 'UTF-8');
                break;
                default:
                    $ordenString = 'Referencia:';
                    $nombreWidth = '59%';
            }

            if ($this->session->userdata('idaccount') == '3246049') {
                if ($diasCliente <= 3) {
                    $condicionPago['descrip'] = 'Contado';
                } else {
                    $condicionPago['descrip'] = 'Crédito';
                }
            }

            $sucursalClienteFontSize = '8.8px';
            $razonSocialFontSize = '9px';
            $referenciaFontSize = '7.9px';
            if ($this->session->userdata('idaccount') == '291862' || $this->session->userdata('idaccount') == '1828465') {
                $referenciaFontSize = '9.5px';
            }

            if( $sucursalCliente != '') {
                if(strlen($sucursalCliente) > 54) {
                    $sucursalClienteFontSize = '8px';
                }
            }

            if (strlen($receptor['nombre']) > 54) {
                $razonSocialFontSize = '8px';
            }

            $header3 = '
            <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
            
                <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$razonSocialFontSize.'; width:54%;">' . mb_substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 60, 'UTF-8').'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8.5%;">'. $ordenString .'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$referenciaFontSize.'; width:22.5%;">'.trim($referenciaOT).'</td>
                </tr>';
                //if( $sucursalCliente != '') {
                    $header3 .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9.8px; width:13%;">Nombre comercial:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$sucursalClienteFontSize.'; width:54%;">' . mb_substr(mb_strtoupper($sucursalCliente, 'UTF-8'), 0, 60, 'UTF-8').'</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Fec. emisión:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.8px; width:16%;">'.date_format(date_create($fecEmisionDocRelacionado), "d/m/Y").'</td>
                    </tr>';
                //}
                $header3 .= '<tr style="width:100%; padding:0px;">
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                </tr>
                <tr style="width:100%; padding:0px;">
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(($correoCliente == '') ? $receptor['correo'] : $correoCliente, 0, 64) . '</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                </tr>
                <tr style="width:100%; padding:0px;">
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$direcFontSize.'; width:59%;">' . mb_strtoupper($direccionCliente, 'UTF-8') . '</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                </tr>
                <tr style="width:100%; padding:0px;">
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($municipioCliente, 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td><td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:16%;">' . substr($condicionPago['descrip'], 0, 25) . '</td>
                </tr>
                <tr style="width:100%; padding:0px;">
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($deptoCliente, 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Moneda:</td>
                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19) . '</td>
                </tr>
            </table>';

            $header = '
                <table style="width:100%; margin:0; padding:0;">
                    <tr>
                            <td rowspan="2" style="width: 40%;">' . $header1 . '</td>
                            <td style="margin:0; padding:0; width: 60%;">' . $header2 . '</td>
                    </tr>
                    <tr>
                            <td style="margin:0; padding:0;">' . $qrCode . '</td>
                    </tr>
                    <tr>
                            <td colspan="2" style="margin:0; padding:0;">' . $header3 . '</td>
                    </tr>
                </table>';

            //$pdf->setPrintHeader(true);
            //$pdf->setHTMLHeader($header);

            $pdf->SetXY(4.5 + $x, 10.5 + $y);
            $pdf->writeHTML($header, true, false, true, false, '');

            /* --- FIN SECCION CABECERAS --- */

            //INICIO CUERPO DE DOCUMENTO CREDITO FISCAL
            /* --- INICIO SECCION PRODUCTOS --- */

            //$cuerpoDocumento2 = array();
            // for($i = 0; $i < 114; $i++){
            //     $cuerpoDocumento[$i] = $cuerpoDocumento[0];
            //     $cuerpoDocumento[$i]['numItem'] = $i;
            // }

            $cantLines = 0;
            $lineasPorProducto = 0;
            foreach ($cuerpoDocumento as $body) {
                if ($this->session->userdata('idaccount') == '1828465') {
                    $infoExtraProTran100k = $this->dte_model->getInfoExtraProductoTran100k($trannum, $body['codigo']);
                    if ($infoExtraProTran100k->notas != '') {
                        $body['descripcion'] = trim($infoExtraProTran100k->notas);
                    }
                }

                $lineasPorProducto = ceil(strlen($body['descripcion']) / 57);
                $cantLines += $lineasPorProducto;
            }

            if ($cantLines <= 40) {
                $cantPages = 1;
            } elseif ($cantLines > 40 && $cantLines <= 113) {
                $cantPages = 2;
            } else {
                $cantPages = (ceil(abs($cantLines - 113) / 65)) + 2;
            }

            $numProd = 0;
            $maxlines = 40;

            $docLines = count($cuerpoDocumento);
            if ($docLines <= 40) {
                $maxlines = 40;
            } else {
                if ($docLines > 40 && $docLines <= 113) {
                    if ($docLines <= 44) {
                        $maxlines = 40;
                    } else {
                        $maxlines = 48;
                    }
                } else if ($docLines > 113) {
                    $maxlines = 48;
                }
            }

            $stop_index = $maxlines;
            $aux2 = 1;

            //$productos = $this->invtran_model->getDataTran100k($trannum);
            $total = 0;
            $totalGravado = 0;
            $totalExento = 0;
            $totalIVA = 0;
            //$invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
            $invexento = 0;
            $vnExenta = 0;
            $vnGravada = 0;
            $numProd = 0; //linea echa para poder visualizar el pdf
            $ivaCesc = 0;
            $cesc = 0;
            $lineasOcupa = 0;
            $totalDesc = 0;
            $discount = 0;
            $codigomodeloHeader = '';

            if ($this->session->userdata('idaccount') == '3131999') {
                $codigomodeloHeader = 'Modelo';
            }else {
                $codigomodeloHeader = 'Código';
            }

            $bodyDoc = '
                <table style="width:100%; padding:0px;">
                <thead>
                    <tr style="width:100%; padding:0px;">
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:4.5%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No. Item</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5.5%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">'.$codigomodeloHeader.'</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:46%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:8%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-top: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                    </tr>
                </thead>';

            foreach ($cuerpoDocumento as $body) {
                //if($numProd < $maxlines){
                $ventaNosj = number_format(floatval($body['ventaNoSuj']), 4, '.', ',');
                $ventaExenta = number_format(floatval($body['ventaExenta']), 4, '.', ',');
                if ($ventaNosj == '0') {
                    $ventaNosj = '';
                }
                if ($ventaExenta == '0') {
                    $ventaExenta = '';
                }

                if ($numProd >= $stop_index) {
                    $breakValue = 'always';
                    $numProd = 0;
                    $aux2++;
                } else {
                    $breakValue = 'avoid';
                }

                if ($this->session->userdata('idaccount') == '1828465') {
                    $infoExtraProTran100k = $this->dte_model->getInfoExtraProductoTran100k($trannum, $body['codigo']);
                    if ($infoExtraProTran100k->notas != '') {
                        $body['descripcion'] = mb_strtoupper(trim($infoExtraProTran100k->notas), 'UTF-8');
                    }
                }

                $codigomodelo = $body['codigo'];
                $infoExtraPro = $this->dte_model->getInfoExtraProducto($body['codigo']);
                if ($this->session->userdata('idaccount') == '3131999') {
                    $codigomodelo = $infoExtraPro->modelo;
                }

                $wrapped = wordwrap(trim(mb_strtoupper($body['descripcion'], 'UTF-8')), 57, '<br>');

                $bodyDoc .= '<tr style="width:100%; padding:0px; page-break-before: ' . $breakValue . ';">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:4.5%;">' . $body['numItem'] . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5.5%;">' . $body['cantidad'] . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $codigomodelo . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">' . $wrapped . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($body['precioUni'], 6, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;">' . $ventaNosj . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $ventaExenta . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format(floatval($body['ventaGravada']), 4, '.', ',') . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                        </tr>';

                if ($aux2 > 1 && $aux2 <= $cantPages) {
                    $stop_index = 65;
                }

                $totalDesc = 0;
                $numProd += ceil(strlen($body['descripcion']) / 57);
                //$numProd++;
                //}
            }

            if ($cantPages > 1) {
                $maxlines = 65;
            }

            for ($i = $numProd; $i < $maxlines; $i++) {
                $bodyDoc .= '
                    <tr>
                        <td style="font-size: 9px; text-align:center; width:100%;"></td>
                    </tr>';
            }
            //$bodyDoc .='</table>';

            //$pdf->SetXY( 4.5 + $x, 93.5 + $y );
            //$pdf->writeHTML($bodyDoc, true, false, true, false, '');

            /* --- INICIO SECCION TOTALES --- */

            /* --- INICIO SECCION EXTENSION --- */

            $extention = '
                        <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%; border-top: 0.1px solid #000;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%; border-top: 0.1px solid #000;">' . trim($resumen['totalLetras']) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>';
            if ($extension['observaciones'] == '') {
                $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                                </tr>';
            } else if (strlen(trim($extension['observaciones'])) <= 86) {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
            } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
            } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
            } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
            } else {
                $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%; border-bottom: 0.1px solid #000;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                            </tr>';
            }

            $extention .= '</table>';

            //$pdf->SetXY( 4.5, 210 );
            //$pdf->writeHTML($extention, true, false, true, false, '');

            /* --- INICIO SECCION TOTALES --- */

            $totals = '
                <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas no sujetas</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuNoSuj'], 2, '.', ',') . '</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas exentas</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuExenta'], 2, '.', ',') . '</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas gravadas</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['descuGravada'], 2, '.', ',') . '</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>';
            foreach ($tributos as $trib) {
                $totals .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';
            }
            $totals .= '
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['montoTotalOperacion'], 2, '.', ',') . '</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%; border-bottom: 0.1px solid #000;">TOTAL A PAGAR</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-bottom: 0.1px solid #000;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%; border-bottom: 0.1px solid #000;">' . number_format($resumen['montoTotalOperacion'], 2, '.', ',') . '</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                    </tr>
                </table>';

            //$pdf->SetXY( 128.4, 210 );
            //$pdf->writeHTML($totals, true, false, true, false, '');

            /* --- FIN SECCION TOTALES --- */

            $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
            //$pdf->SetXY( 4.5, 265 );
            //$pdf->writeHTML($message, true, false, true, false, '');

            $bodyDoc .= '
                    <tr style="width:100%; margin: 0px; padding: 0px;">
                            <td style="width:60%; margin: 0px; padding: 0px; text-align: left;">' . $extention . '</td>
                            <td style="width:40%; margin: 0px; padding: 0px; text-align: left;">' . $totals . '</td>
                    </tr>
                    <tr style="width:100%;">
                            <td style="width:1%; margin: 0px; padding: 0px;"></td>
                            <td style="width:99%; margin: 0px; padding: 0px;">' . $message . '</td>
                    </tr>
                </table>';

            $pdf->SetXY(4.5 + $x, 96.5 + $y);
            $pdf->writeHTML($bodyDoc, true, false, true, false, '');

            // FIN CUERPO DE DOCUMENTO CREDITO FISCAL

            // AGREGAR MARCA DE AGUA "ANULADO"
            if ($statusDoc == 9) {
                $pdf->StartTransform();
                $pdf->Rotate(45, $pdf->getPageWidth() / 2, $pdf->getPageHeight() / 2);
                $pdf->SetFont('helvetica', 'B', 60);
                $pdf->SetTextColor(255, 0, 0);
                $pdf->SetAlpha(0.1);
                $pdf->Text(32, 145, 'ANULADO');
                $pdf->SetAlpha(1);
                $pdf->StopTransform();
            }

            /* --- GENERACION DE PDF --- */

            $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'] . '.pdf');
            $fullpath = $destinationFolder . $nombre_archivo;

            /*
             *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
             *D: send to the browser and force a file download with the name given by name.
             *F: save to a local server file with the name given by name.
             *S: return the document as a string. name is ignored.
             *FI: equivalent to F + I option
             *FD: equivalent to F + D option
             */

            if ($docToSave == 0) {

                if ($docToSend == 0) {
                    $pdf->Output($nombre_archivo, 'I');

                    if (file_exists($portalMHImg))
                        unlink($portalMHImg);
                    if (file_exists($codGeneracionImg))
                        unlink($codGeneracionImg);
                    if (file_exists($selloRecibidoImg))
                        unlink($selloRecibidoImg);
                    if (file_exists($numeroControlImg))
                        unlink($numeroControlImg);
                } else {
                    $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                    //$pdf->Output($nombre_archivo, 'I');

                    if ($infoDoc->correo != '') {
                        $pdf->Output($fullpath, 'F');
                        $docIntern = (int) $nControlP[3];
                        $emiDate = date_format(date_create($identificacion['fecEmi']), "d/m/Y");

                        if (isset($receptor['nombre']))
                            $nam