<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Dte extends CI_Controller {
        
        function __construct(){
            parent::__construct();
            
            date_default_timezone_set('America/El_Salvador');

            $this->load->model('dte_model');
            $this->load->model('global_model');

            // $fileDteJsson = {"identificacion":{"version":3,"ambiente":"00","tipoDte":"03","numeroControl":"DTE-03-00000000-000000000000300","codigoGeneracion":"CF89B21E-4268-4711-785E-8A54866B1764","tipoModelo":1,"tipoOperacion":1,"tipoContingencia":null,"motivoContin":null,"fecEmi":"2023-05-02","horEmi":"09:58:30","tipoMoneda":"USD"},"documentoRelacionado":null,"emisor":{"nit":"06142108891018","nrc":"84662","nombre":"EMPRESAS GOMEZ GUATEMALA S.A. de C.V.","codActividad":"46510","descActividad":"Venta al por mayor de computadoras, equipo periférico y programas informáticos","nombreComercial":null,"tipoEstablecimiento":"02","direccion":{"departamento":"06","municipio":"14","complemento":"Final 67 Avenida Sur y Pasaje Carbonell, N° 2A, Colonia Roma, San Salvador, El Salvador"},"telefono":"25143094","correo":"info@versanetsa.com","codEstableMH":null,"codEstable":null,"codPuntoVentaMH":null,"codPuntoVenta":null},"receptor":{"nit":"06142202141014","nrc":"2311904","nombre":"AGROINDUSTRIAS SAN ANDRES, S.A. DE C.V.","codActividad":"46375","descActividad":"Venta al por mayor de productos lácteos","nombreComercial":null,"direccion":{"departamento":"05","municipio":"11","complemento":"CALLE JOSE CIRIACO LOPEZ, 1AV. SUR #11B, BARRIO EL CENTRO"},"telefono":"22887565","correo":"agroindustrias@correo.com"},"otrosDocumentos":null,"ventaTercero":null,"cuerpoDocumento":[{"numItem":1,"tipoItem":2,"numeroDocumento":null,"codigo":null,"codTributo":null,"descripcion":"Suscripción Anual Sistema en linea GoXpos Starter.","cantidad":1,"uniMedida":59,"precioUni":900,"montoDescu":0,"ventaNoSuj":0,"ventaExenta":0, "ventaGravada":900,"tributos":["20"],"psv":0,"noGravado":0}],"resumen":{"totalNoSuj":0,"totalExenta":0,"totalGravada":900,"subTotalVentas":900,"descuNoSuj":0,"descuExenta":0,"descuGravada":0,"porcentajeDescuento":0,"totalDescu":0,"tributos":[{"codigo":"20","descripcion":"Impuesto al Valor Agregado 13%","valor":117}],"subTotal":900,"ivaPerci1":0,"ivaRete1":0,"reteRenta":0,"montoTotalOperacion":1017, "totalNoGravado":0,"totalPagar":1017,"totalLetras":"MIL DIECISIETE DÓLARES ","saldoFavor":0,"condicionOperacion":1,"pagos":[{"codigo":"01","montoPago":1017,"plazo":null,"referencia":"","periodo":null}],"numPagoElectronico":null},"extension":{"nombEntrega":null,"docuEntrega":null,"nombRecibe":null,"docuRecibe":null,"observaciones":null,"placaVehiculo":null},"apendice":null};
        }

        function comprobanteCreditoFiscalDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $fecha = new DateTime();
                $infoDoc = $this->dte_model->getDatosFacturacionJSON($trannum);
                
                $NRC  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                
                $nComercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $direccion  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $deptoMuni  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);

                $docRelacionado  = false;
                $otrosDocumentos = false;
                $ventaTercero    = false;

                $fileDteJson = new stdClass();

                //NOTE: Identificacion JSON
                
                $fileDteJson->identificacion = array(
                    'version'           => 3,
                    'ambiente'          => '00',    // CAT-001
                    'tipoDTE'           => '03',    // CAT-002
                    'numeroControl'     => 'DTE-03-00000000-'.str_pad($trannum, 15, '0', STR_PAD_LEFT),
                    'codigoGeneracion'  => 'CF89B21E-4268-4711-785E-8A54866B1764',
                    'tipoModelo'        => 1,       // CAT-003
                    'tipoOperacion'     => 1,       // CAT-004
                    'tipoContingencia'  => null,    // CAT-005
                    'motivoContin'      => null,
                    'fecEmi'            => $fecha->format('Y-m-d'), // YYYY-MM-DD
                    'horEmi'            => $fecha->format('H:i:s'), // HH:MM:SS
                    'tipoMoneda'        => 'USD'
                );

                //NOTE: Documentos Relacionados JSON (Opcional Segun Requerimientos)

                if ($docRelacionado) {
                    $fileDteJson->documentoRelacionado = array(
                        'tipoDocumento'     => '', // CAT-002
                        'tipoGeneracion'    => '', // CAT-007
                        'numeroDocumento'   => '',
                        'fechaEmision'      => ''
                    );
                } else $fileDteJson->documentoRelacionado = null;
                
                //NOTE: Emisor JSON
                
                $fileDteJson->emisor = array(
                    'nit'                 => ''.str_replace('-', '', $NIT).'',
                    'nrc'                 => ''.str_replace('-', '', $NRC).'',
                    'nombre'              => 'EMPRESAS GOMEZ GUATEMALA S.A. de C.V.',
                    'codActividad'        => '46510', // CAT-019
                    'descActividad'       => strtoupper($GIRO), // CAT-019
                    'nombreComercial'     => strtoupper($nComercial),
                    'tipoEstablecimiento' => '02', // CAT-009
                    'direccion' => array(
                        'departamento'    => '06', // CAT-012
                        'municipio'       => '14', // CAT-013
                        'complemento'     => strtoupper($direccion)
                    ),
                    'telefono'            => str_replace('-', '', $telefono),
                    'codEstableMH'        => NULL,
                    'codPuntoVentaMH'     => NULL,
                    'codPuntoVenta'       => '',
                    'correo'              => 'info@versanetsa.com',
                );
                
                //NOTE: Receptor JSON
                
                $fileDteJson->receptor = array(
                    //'tipoDocumento'    => '', // CAT-022
                    'nit'              => ''.str_replace('-', '', $infoDoc->nit).'',
                    'nrc'              => ''.str_replace('-', '', $infoDoc->nrc).'',
                    'nombre'           => $infoDoc->nameCliente,
                    'codActividad'     => '46375', // CAT-019
                    'descActividad'    => 'Venta al por mayor de productos lácteos', // CAT-019
                    'direccion' => array(
                        'departamento' => '05', // CAT-012
                        'municipio'    => '11', // CAT-013
                        'complemento'  => $infoDoc->direccion
                    ),
                    'telefono'         => ''.str_replace('-', '', $infoDoc->telefono).'',
                    'correo'           => $infoDoc->correo
                );
                
                //NOTE: Otros Documentos Asociados
                
                if ($otrosDocumentos) {
                    $fileDteJson->otrosDocumentos = array(
                        'codDocAsociado'   => '',
                        'descDocumento'    => '',
                        'detalleDocumento' => '',
                        'medico' => array(
                            'nombre'            => '',
                            'nit'               => '',
                            'docIdentificacion' => '',
                            'tipoServicio'      => '',
                        )
                    );
                } else $fileDteJson->otrosDocumentos = null;
                                
                //NOTE: Ventas por Cuenta de Terceros
                
                if ($ventaTercero) {
                    $fileDteJson->ventaTercero = array(
                        'nit'    => '',
                        'nombre' => '',
                    );
                } else $fileDteJson->ventaTercero = null;

                //NOTE: Cuerpo del Documento (ForEach Items)
                
                $fileDteJson->cuerpoDocumento = array(
                    'numItem'         => 0,
                    'tipoItem'        => '', // CAT-011 CAT-015
                    'numeroDocumento' => '',
                    'cantidad'        => 0,
                    'codigo'          => '',
                    'codTributo'      => '',  // CAT-015
                    'uniMedida'       => 0, // CAT-014
                    'descripcion'     => '',
                    'precioUni'       => 0,
                    'montoDesc'       => 0,
                    'ventaNoSuj'      => 0,
                    'ventaExenta'     => 0,
                    'ventaGravada'    => 0,
                    'tributos'        => '', // CAT-015
                    'psv'             => 0,
                    'noGravado'       => 0,
                    'ivaItem'         => 0,
                );
                
                //NOTE: Resumen
                $fileDteJson->resumen = array(
                    'totalNoSuj'          => 0,
                    'totalExenta'         => 0,
                    'totalGravada'        => 0,
                    'subTotalVentas'      => 0,
                    'descuNoSuj'          => 0,
                    'descuExenta'         => 0,
                    'descuGravada'        => 0,
                    'porcentajeDescuento' => 0,
                    'totalDescu'          => 0,
                    'tributos' => array(
                        'codigo'      => '', // CAT-015
                        'descripcion' => '', // CAT-015
                        'valor'       => 0,
                    ),
                    'subTotal'            => 0,
                    'ivaRete1'            => 0,
                    'reteRenta'           => 0,
                    'montoTotalOperacion' => 0,
                    'totalNoGravado'      => 0,
                    'totalPagar'          => 0,
                    'totalLetras'         => '',
                    'totalIva'            => 0,
                    'saldoFavor'          => 0,
                    'condicionOperacion'  => 0,
                    'pagos' => array(
                        'codigo'     => '',
                        'montoPago'  => 0,
                        'referencia' => '',
                        'plazo'      => '',
                        'periodo'    => 0,
                    ),
                    'numPagoElectronico'  => null
                );
                
                //NOTE: Extensión
                $fileDteJson->extension = array(
                    'nombreEntrega' => null, //'',
                    'docuEntrega'   => null, //'',
                    'nombRecibe'    => null, //'',
                    'docuRecibe'    => null, //'',
                    'observaciones' => null, //'',
                    'placaVehiculo' => null, //'',
                );
                
                //NOTE: Apéndice
                $fileDteJson->apendice = null;

                // $fileDteJson->apendice = array(
                //     'campo'    => '',
                //     'etiqueta' => '',
                //     'valor'    => '',
                // );

                echo json_encode($fileDteJson);

                $docJson = json_encode($fileDteJson);

                //NOTE: Sello Recepción recibido....

                // try{
                //     //NOTE: FIRMAR DOCUMENTO JSON

                //     $RestApi = curl_init();
                //     curl_setopt($RestApi, CURLOPT_URL, "http://localhost:8113/firmardocumento/");
                //     // curl_setopt($RestApi, CURLOPT_URL, "https://goxconta.com/docker/crt26648/firmardocumento/"); //Por Empresa
                //     curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                //     curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                //         'Content-Type:application/json'
                //     ));
                //     curl_setopt($RestApi, CURLOPT_CUSTOMREQUEST, "POST");
                //     curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                //         "nit" => "06142108891018",
                //         "activo" => true,
                //         "passwordPri" => "Agge#210889",
                //         "dteJson" => json_encode($docJson)
                //     )));

                //     //eyJhbGciOiJSUzUxMiJ9.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.jdpAsCyI77KrOGh8e4awHOcnXrXgwW8rPv8knauWdyrOspX76E3ze-LQ8qSkY0Myg2Ti_7OqWbjSP0qVuCfjbtWnueFCW8DFLDW2WvgBYtgJXR3vzONnwfD8ldDku_QYseV8oZh45jWLcFGJXke2gk_adLvTYenWgNxnoBKOnIm0BrIOWderixONm2KlmFPB9yp4RwPvN9Um9-imu3PenBtYu2PtZV8iADDMNq0mqU-HBaQqJUrIjxaL-O7VH2ltjy5dqAzA1T_UoYzdjI23KYGaTwU9UDskqFVKrLvHF4M4yrzHC2F5iraGCm4OBMmrfXhInwJBa_LqQY_OT1y2cA

                //     $Resolve = curl_exec($RestApi);
                //     curl_close($RestApi);

                //     $resultFirma = json_decode($Resolve, true);
                    
                //     if( $resultFirma['status'] == 'OK' ){

                //         //NOTE: AUTORIZACION API MH

                //         $docJsonFirmado = $resultFirma['body'];

                //         $RestApi = curl_init();
                //         curl_setopt($RestApi, CURLOPT_URL, "https://apitest.dtes.mh.gob.sv/seguridad/auth");
                //         curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                //         curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                //             'Content-Type:application/json'
                //         ));
                //         curl_setopt($RestApi, CURLOPT_CUSTOMREQUEST, "POST");
                //         curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                //             'user' => '06142108891018',
                //             'pwd'  => 'Nelito#1932'
                //         )));

                //         $Resolve = curl_exec($RestApi);
                //         curl_close($RestApi);

                //         $resultToken = json_decode($Resolve, true);

                //         if( $resultToken['status'] == 'OK' ){
                //             $tokenJson = $resultToken['token'];

                //             //NOTE: RECEPCION DE DOCUMENTO MH

                //             $RestApi = curl_init();
                //             curl_setopt($RestApi, CURLOPT_URL, "https://apitest.dtes.mh.gob.sv/fesv/recepciondte");
                //             curl_setopt($RestApi, CURLOPT_RETURNTRANSFER, true);
                //             curl_setopt($RestApi, CURLOPT_HTTPHEADER, array(
                //                 'Content-Type:application/json',
                //                 'Authorization: ' . $tokenJson
                //             ));
                //             curl_setopt($RestApi, CURLOPT_CUSTOMREQUEST, "POST");
                //             curl_setopt($RestApi, CURLOPT_POSTFIELDS, json_encode(array(
                //                 "ambiente"  => "00",
                //                 "idEnvio"   => "1001",
                //                 "version"   => 3,
                //                 "tipoDte"   => "03",
                //                 "documento" => $docJsonFirmado,
                //                 "codigoGeneracion" => "CF89B21E-4268-4711-785E-8A54866B1764"
                //             )));

                //             $Resolve = curl_exec($RestApi);
                //             curl_close($RestApi);

                //             $resultMH = json_decode($Resolve, true);

                //         }else{
                //             echo json_encode($resultToken);
                //         }
                //     }
                //     /*
                //     if($resultado->return->valido){
                        
                //     }else{
                //         echo "ERROR: " . $resultado->return->descripcion;
                //     }
                //     */
                // }catch(SoapFault $e){
                //     echo "CATCH: " . $e->faultstring;
                // }

                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function facturaConsumidorFinalDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();

                //NOTE: Identificacion JSON
                $contentJSON['identificacion'] = array('version', 3);
                $contentJSON['identificacion'] = array('ambiente', '00'); // CAT-001
                $contentJSON['identificacion'] = array('tipoDTE', '03'); // CAT-002
                $contentJSON['identificacion'] = array('numeroControl', 'DTE-01-12345678-000000000000001');
                $contentJSON['identificacion'] = array('codigoGeneracion', '');
                $contentJSON['identificacion'] = array('tipoModelo', ''); // CAT-003
                $contentJSON['identificacion'] = array('tipoOperacion', ''); // CAT-004
                $contentJSON['identificacion'] = array('tipoContingencia', ''); // CAT-005
                $contentJSON['identificacion'] = array('motivoContin', '');
                $contentJSON['identificacion'] = array('fecEmi', ''); // YYYY-MM-DD
                $contentJSON['identificacion'] = array('horEmi', ''); // HH:MM:SS
                $contentJSON['identificacion'] = array('tipoMoneda', 'USD');
                
                //NOTE: Documentos Relacionados JSON (Opcional Segun Requerimientos)
                $contentJSON['documentoRelacionado'] = array('tipoDocumento', ''); // CAT-002
                $contentJSON['documentoRelacionado'] = array('tipoGeneracion', ); // CAT-007
                $contentJSON['documentoRelacionado'] = array('numeroDocumento', '');
                $contentJSON['documentoRelacionado'] = array('fechaEmision', '');
                
                //NOTE: Emisor JSON
                $contentJSON['emisor'] = array('nit', '');
                $contentJSON['emisor'] = array('nrc', '');
                $contentJSON['emisor'] = array('nombre', '');
                $contentJSON['emisor'] = array('codActividad', ''); // CAT-019
                $contentJSON['emisor'] = array('descActividad', ''); // CAT-019
                $contentJSON['emisor'] = array('nombreComercial', '');
                $contentJSON['emisor'] = array('tipoEstablecimiento', ''); // CAT-009
                $contentJSON['emisor']['direccion'] = array('departamento', ''); // CAT-012
                $contentJSON['emisor']['direccion'] = array('municipio', ''); // CAT-013
                $contentJSON['emisor']['direccion'] = array('complemento', '');
                $contentJSON['emisor'] = array('telefono', '');
                $contentJSON['emisor'] = array('codEstableMH', NULL);
                $contentJSON['emisor'] = array('codPuntoVentaMH', NULL);
                $contentJSON['emisor'] = array('codPuntoVenta', '');
                $contentJSON['emisor'] = array('correo', '');
                
                //NOTE: Receptor JSON
                $contentJSON['receptor'] = array('tipoDocumento', ''); // CAT-022
                $contentJSON['receptor'] = array('numeroDocumento', '');
                $contentJSON['receptor'] = array('nrc', '');
                $contentJSON['receptor'] = array('nombre', '');
                $contentJSON['receptor'] = array('codActividad', ''); // CAT-019
                $contentJSON['receptor'] = array('descActividad', ''); // CAT-019
                $contentJSON['receptor']['direccion'] = array('departamento', ''); // CAT-012
                $contentJSON['receptor']['direccion'] = array('municipio', ''); // CAT-013
                $contentJSON['receptor']['direccion'] = array('complemento', '');
                $contentJSON['receptor'] = array('telefono', '');
                $contentJSON['receptor'] = array('correo', '');
                
                //NOTE: Otros Documentos Asociados
                $contentJSON['otrosDocumentos'] = array('codDocAsociado', '');
                $contentJSON['otrosDocumentos'] = array('descDocumento', '');
                $contentJSON['otrosDocumentos'] = array('detalleDocumento', '');
                $contentJSON['otrosDocumentos']['medico'] = array('nombre', '');
                $contentJSON['otrosDocumentos']['medico'] = array('nit', '');
                $contentJSON['otrosDocumentos']['medico'] = array('docIdentificacion', '');
                $contentJSON['otrosDocumentos']['medico'] = array('tipoServicio', '');
                
                //NOTE: Ventas por Cuenta de Terceros
                $contentJSON['ventaTercero'] = array('nit', '');
                $contentJSON['ventaTercero'] = array('nombre', '');
                
                //NOTE: Cuerpo del Documento (ForEach Items)
                $contentJSON['cuerpoDocumento'] = array('numItem', 0);
                $contentJSON['cuerpoDocumento'] = array('tipoItem', ''); // CAT-011 CAT-015
                $contentJSON['cuerpoDocumento'] = array('numeroDocumento', '');
                $contentJSON['cuerpoDocumento'] = array('cantidad', 0);
                $contentJSON['cuerpoDocumento'] = array('codigo', '');
                $contentJSON['cuerpoDocumento'] = array('codTributo', '');  // CAT-015
                $contentJSON['cuerpoDocumento'] = array('uniMedida', 0); // CAT-014
                $contentJSON['cuerpoDocumento'] = array('descripcion', '');
                $contentJSON['cuerpoDocumento'] = array('precioUni', 0);
                $contentJSON['cuerpoDocumento'] = array('montoDesc', 0);
                $contentJSON['cuerpoDocumento'] = array('ventaNoSuj', 0);
                $contentJSON['cuerpoDocumento'] = array('ventaExenta', 0);
                $contentJSON['cuerpoDocumento'] = array('ventaGravada', 0);
                $contentJSON['cuerpoDocumento'] = array('tributos', ''); // CAT-015
                $contentJSON['cuerpoDocumento'] = array('psv', 0);
                $contentJSON['cuerpoDocumento'] = array('noGravado', 0);
                $contentJSON['cuerpoDocumento'] = array('ivaItem', 0);
                
                //NOTE: Resumen
                $contentJSON['resumen'] = array('totalNoSuj', 0);
                $contentJSON['resumen'] = array('totalExenta', 0);
                $contentJSON['resumen'] = array('totalGravada', 0);
                $contentJSON['resumen'] = array('subTotalVentas', 0);
                $contentJSON['resumen'] = array('descuNoSuj', 0);
                $contentJSON['resumen'] = array('descuExenta', 0);
                $contentJSON['resumen'] = array('descuGravada', 0);
                $contentJSON['resumen'] = array('porcentajeDescuento', 0);
                $contentJSON['resumen'] = array('totalDescu', 0);
                $contentJSON['resumen']['tributos'] = array('codigo', ''); // CAT-015
                $contentJSON['resumen']['tributos'] = array('descripcion', ''); // CAT-015
                $contentJSON['resumen']['tributos'] = array('valor', 0);
                $contentJSON['resumen'] = array('subTotal', 0);
                $contentJSON['resumen'] = array('ivaRete1', 0);
                $contentJSON['resumen'] = array('reteRenta', 0);
                $contentJSON['resumen'] = array('montoTotalOperacion', 0);
                $contentJSON['resumen'] = array('totalNoGravado', 0);
                $contentJSON['resumen'] = array('totalPagar', 0);
                $contentJSON['resumen'] = array('totalLetras', '');
                $contentJSON['resumen'] = array('totalIva', 0);
                $contentJSON['resumen'] = array('saldoFavor', 0);
                $contentJSON['resumen'] = array('condicionOperacion', 0);
                $contentJSON['resumen']['pagos'] = array('codigo', '');
                $contentJSON['resumen']['pagos'] = array('montoPago', 0);
                $contentJSON['resumen']['pagos'] = array('referencia', '');
                $contentJSON['resumen']['pagos'] = array('plazo', '');
                $contentJSON['resumen']['pagos'] = array('periodo', 0);
                $contentJSON['resumen'] = array('numPagoElectronico', '');
                
                //NOTE: Extensión
                $contentJSON['extension'] = array('nombreEntrega', '');
                $contentJSON['extension'] = array('docuEntrega', '');
                $contentJSON['extension'] = array('nombRecibe', '');
                $contentJSON['extension'] = array('docuRecibe', '');
                $contentJSON['extension'] = array('observaciones', '');
                $contentJSON['extension'] = array('placaVehiculo', '');
                
                //NOTE: Apéndice
                $contentJSON['apendice'] = array('campo', '');
                $contentJSON['apendice'] = array('etiqueta', '');
                $contentJSON['apendice'] = array('valor', '');

                //NOTE: Sello Recepción recibido....

                //NOTE: (A) Debe reflejarse en Versión Legible.
                //NOTE: (B) Debe  reflejarse en Versión Legible, siempre que sea requerido por el negocio, giro, operación, monto u otras condiciones.
                //NOTE: (C) No seré requerida su visualización y/o colocación en la Versión Legible.
                //NOTE: (D) Cuando no se haga uso, deberá colocarse el nombre de la sección/campo en la Versión Legible, seguido de un guion.
            }
        }

        function facturaDeExportacionDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }

        function facturaSujetoExcluidoDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }

        function notaDeCreditoDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }

        function notaDeDebitoDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }

        function notaDeRemisionDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }

        function anulacionDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }

        function comprobanteDeLiquidacionDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }

        function comprobanteDeDonacionDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }

        function documentoDeLiquidacionContableDET($trannum){
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $informacion = $this->ventas_model->getDatosFactura($trannum);

                $contentJSON = array();
            }
        }
    }
?>