<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Definicioniva extends CI_Controller {
        
        function __construct(){
            parent::__construct();
        }
        private $SeleccionCheques = [
            array('nombre' => 'askcentro', 'valor' => false, 'texto' => 'Sucursal'),
            array('nombre' => 'askcaja', 'valor' => false, 'texto' => 'Caja'),
            array('nombre' => 'asknit', 'valor' => false, 'texto' => 'Contribuyente'),
            array('nombre' => 'askres', 'valor' => false, 'texto' => 'Número de Resolución'),
            array('nombre' => 'askserie', 'valor' => false, 'texto' => 'Serie'),
            array('nombre' => 'askfunico', 'valor' => false, 'texto' => '# Formulario único'),
            array('nombre' => 'askref', 'valor' => false, 'texto' => 'Referencia'),
        ];
        private $Valores = [
            array('ID' => 0, 'Name' => 'IVA'),
            array('ID' => 1, 'Name' => 'Gravados Internos'),
            array('ID' => 2, 'Name' => 'Exentos Internos'),
            array('ID' => 3, 'Name' => 'No Sujetas Internos'),
            array('ID' => 4, 'Name' => 'Retención/Percepción'),
            array('ID' => 5, 'Name' => 'Importar/Exportar Gravados'),
            array('ID' => 6, 'Name' => 'Importar/Exportar Exentos'),
            array('ID' => 7, 'Name' => 'Retención 2%'),
            array('ID' => 8, 'Name' => 'Retención IVA del 13%'),
            array('ID' => 9, 'Name' => 'Importar/Exportar Gravados Servicios'),
            array('ID' => 10, 'Name' => 'Internaciones/Exportar Gravadas'),
            array('ID' => 11, 'Name' => 'Internaciones/Exportar Exentas'),
            array('ID' => 12, 'Name' => 'Monto Sujeto'),
            array('ID' => 13, 'Name' => 'Venta Zona Franca'),
            array('ID' => 14, 'Name' => 'Cotrans'),
            array('ID' => 15, 'Name' => 'Fovial'),
            array('ID' => 16, 'Name' => 'Retención 10%'),
            array('ID' => 17, 'Name' => 'Valor 17 - No Definido'),
            array('ID' => 18, 'Name' => 'Valor 18 - No Definido'),
            array('ID' => 19, 'Name' => 'Valor 19 - No Definido'),
            array('ID' => 20, 'Name' => 'Valor 20 - No Definido'),
        ];
        private $Libros = [
            array('id' => 1, 'text' => 'Libros Venta Consumidor Final', 'tipotransaccion' => 'VN'),
            array('id' => 2, 'text' => 'Libro Ventas Contribuyente', 'tipotransaccion' => 'VN'),
            array('id' => 3, 'text' => 'Libro de Compras', 'tipotransaccion' => 'CO'),
            array('id' => 4, 'text' => 'Documentos Contables de Liquidación', 'tipotransaccion' => 'CO'),
        ];
        private function validatePermiso() {
            $permiso = ($this->session->userdata("profile") != 1) ? false : true;
            /*if (chkPermisoEspecial([$this->session->userdata('iduser'), $this->session->userdata('idaccount')])) $permiso =  true;
            else if ($this->session->userdata("profile") != 1) $permiso = false;//*/
            //if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1) redirect('CerrarSesion');
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || !$permiso) redirect('CerrarSesion');
            else return true;
        }
        public function definicionIvaCentral()
        {
            if($this->validatePermiso()) {
                //$this->load->model('configuracion_model');
                $resultAppName = array(
                    'appName' => 'Definición IVA Central',
                    'namePage' => 'Definición IVA Central'
                );
                $this->session->set_userdata($resultAppName);
                $this->data['SeleccionCheques'] = $this->SeleccionCheques;
                $this->data['Libros'] = $this->Libros;
                $this->load->view("mantenimiento_definicion_ivacentral", $this->data);
            }
        }
        #   GET DATA GENERAL
        public function multiOpciones()
        {
            if($this->validatePermiso()) {
                $this->load->model('definicioniva_model');
                $opcion = (int)$this->input->post('opcion');
                switch ($opcion) {
                    # GET TIPOS DE LIBROS
                    case 1:
                        $Datos = $this->conversion(1, (int)$this->input->post('tipo'));
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    #   GET TRANSACCIONES AUXILIARES USUARIOS
                    case 2:
                        $tipotransaccion = $this->input->post('tipotransaccion');
                        $Transacciones = [];
                        $TAuxiliares = [];
                        $Usuarios = [];
                        $dato = null;
                        $datos = $this->definicioniva_model->multiOpciones(2, $tipotransaccion);
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                $Transacciones[] = array(
                                    'ID' => $dato->invclase,
                                    'Name' => trim($dato->descrip)
                                );
                            }
                        }
                        $datos = $this->definicioniva_model->multiOpciones(3);
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                $TAuxiliares[] = array(
                                    'ID' => (int)$dato->valor_num,
                                    'Name' => trim($dato->descripcion)
                                );
                            }
                        }
                        $datos = $this->definicioniva_model->multiOpciones(4);
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                $Usuarios[] = array(
                                    'ID' => $dato->iduser,
                                    'Name' => trim($dato->descrip)
                                );
                            }
                        }
                        $ivclase = $this->input->post('ID');
                        $forms = $this->definicioniva_model->getFormsByIvClase($ivclase);

                        if ($ID = $this->input->post('ID')) {
                            $ID = (int)$ID;
                            $dato = $this->conversion(2, $ID);
                        }

                        $datA[] = array(
                            'valido' => true,
                            'transacciones' => $Transacciones,
                            'auxiliares' => $TAuxiliares,
                            'usuarios' => $Usuarios,
                            'dato' => $dato,
                            'forms' => $forms,
                        );
                    break;
                    #   GET FORMULARIOS DE DEFINICION
                    case 3:
                        $ID = (int)$this->input->post('ID');
                        $datA[] = $this->conversion(3, $ID);
                    break;
                    #   RESETEO DE UBICACIONES
                    case 4:
                        $IDkey = (int)$this->input->post('IDkey');
                        $ubicaciones = explode(",", trim($this->input->post('ubicaciones')));
                        if (count($ubicaciones) > 0) {
                            foreach ($ubicaciones as $ubicaciond) {
                                $ubicacion = explode("-", $ubicaciond);
                                $data = array(
                                    'orden' => (int)$ubicacion[1],
                                    'whodidit' => $this->session->userdata('iduser'),
                                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                                );
                                $this->definicioniva_model->multiOpciones(12, [
                                    'ID' => (int)$ubicacion[0],
                                    'data' => $data
                                ]);
                            }
                        }
                        $datA[] = $this->conversion(3, $IDkey);
                    break;
                    default:
                        $datA[] = array('valido' => false);
                    break;
                }
                echo json_encode($datA);
            }
        }
        #   SET DEFINICION
        public function setDefinicionIva()
        {
            if($this->validatePermiso()) {
                date_default_timezone_set('America/El_Salvador');
                $this->load->model('definicioniva_model');
                $Tipo = (int)$this->input->post('tipo');
                $data = array(
                    'descrip' => trim($this->input->post('nombre')),
                    'idlibro' => $Tipo,
                    'doc_clase' => (int)$this->input->post('clasedoc'),
                    'doc_tipo' => (int)$this->input->post('tipodoc'),
                    'ivopera' => (int)$this->input->post('oiva'),
                    'asknit' => (int)$this->input->post('asknit'),
                    'askres' => (int)$this->input->post('askres'),
                    'askserie' => (int)$this->input->post('askserie'),
                    'askcentro' => (int)$this->input->post('askcentro'),
                    'askcaja' => (int)$this->input->post('askcaja'),
                    'askfunico' => (int)$this->input->post('askfunico'),
                    'askref' => (int)$this->input->post('askref'),
                    'adays' => (int)$this->input->post('periodo'),
                    'tasaiva' => $this->input->post('tasaiva'),
                    'tasarp' => $this->input->post('tasarp'),
                    'tasaisr' => $this->input->post('tasar'),
                    'invclase' => (int)$this->input->post('transaccion'),
                    'idauxidef' => trim($this->input->post('auxiliares')),
                    'ausers' => trim($this->input->post('usuarios')),
                    'defaultfld' => trim($this->input->post('deffld')),
                    'xpos' => trim($this->input->post('xpos')),
                    'estatus' => (int)$this->input->post('estado'),
                    'notas' => trim($this->input->post('notas')),
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->definicioniva_model->multiOpciones(5, $data)) {
                    $Datos = $this->conversion(1, $Tipo);
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #   UPDATE DEFINICION
        public function updateDefinicionIva()
        {
            if($this->validatePermiso()) {
                date_default_timezone_set('America/El_Salvador');
                $this->load->model('definicioniva_model');
                $Tipo = (int)$this->input->post('tipo');
                $ID = (int)$this->input->post('ID');
                $data = array(
                    'descrip' => trim($this->input->post('nombre')),
                    'idlibro' => $Tipo,
                    'doc_clase' => (int)$this->input->post('clasedoc'),
                    'doc_tipo' => (int)$this->input->post('tipodoc'),
                    'ivopera' => (int)$this->input->post('oiva'),
                    'asknit' => (int)$this->input->post('asknit'),
                    'askres' => (int)$this->input->post('askres'),
                    'askserie' => (int)$this->input->post('askserie'),
                    'askcentro' => (int)$this->input->post('askcentro'),
                    'askcaja' => (int)$this->input->post('askcaja'),
                    'askfunico' => (int)$this->input->post('askfunico'),
                    'askref' => (int)$this->input->post('askref'),
                    'adays' => (int)$this->input->post('periodo'),
                    'tasaiva' => $this->input->post('tasaiva'),
                    'tasarp' => $this->input->post('tasarp'),
                    'tasaisr' => $this->input->post('tasar'),
                    'invclase' => (int)$this->input->post('transaccion'),
                    'idauxidef' => trim($this->input->post('auxiliares')),
                    'ausers' => trim($this->input->post('usuarios')),
                    'defaultfld' => trim($this->input->post('deffld')),
                    'xpos' => trim($this->input->post('xpos')),
                    'estatus' => (int)$this->input->post('estado'),
                    'notas' => trim($this->input->post('notas')),
                    'whodidit' => $this->session->userdata('iduser'),
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->definicioniva_model->multiOpciones(7, [
                    'ID' => $ID,
                    'data' => $data
                ])) {
                    $Datos = $this->conversion(1, $Tipo);
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #   DELETE DEFINICION
        public function byeDefinicionIva()
        {
            if($this->validatePermiso()) {
                $this->load->model('definicioniva_model');
                $Tipo = (int)$this->input->post('tipo');
                $ID = (int)$this->input->post('ID');
                $valido = true;
                if ($valido) {
                    $this->definicioniva_model->multiOpciones(8, $ID);
                    $Datos = $this->conversion(1, $Tipo);
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #   SET HIJO DEFINICION
        public function setDefinicionIvaSon()
        {
            if($this->validatePermiso()) {
                date_default_timezone_set('America/El_Salvador');
                $this->load->model('definicioniva_model');
                $IDkey = (int)$this->input->post('IDkey');
                $data = array(
                    'ivclase' => $IDkey,
                    'orden' => (int)$this->input->post('orden'),
                    'titulo' => trim($this->input->post('nombre')),
                    'askvalor' => (int)$this->input->post('valor'),
                    'requerido' => (int)$this->input->post('requerido'),
                    'valopera' => (int)$this->input->post('ovalor'),
                    'minval' => $this->input->post('min'),
                    'maxval' => $this->input->post('max'),
                    'controltype' => (int)$this->input->post('tipocontrol'),
                    'estatus' => (int)$this->input->post('estado'),
                    'notas' => trim($this->input->post('notas')),
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->definicioniva_model->multiOpciones(11, $data)) {
                    $datA[] = $this->conversion(3, $IDkey);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #   UPDATE HIJO DEFINICION
        public function updateDefinicionIvaSon()
        {
            if($this->validatePermiso()) {
                date_default_timezone_set('America/El_Salvador');
                $this->load->model('definicioniva_model');
                $IDkey = (int)$this->input->post('IDkey');
                $ID = (int)$this->input->post('ID');
                $data = array(
                    'orden' => (int)$this->input->post('orden'),
                    'titulo' => trim($this->input->post('nombre')),
                    'askvalor' => (int)$this->input->post('valor'),
                    'requerido' => (int)$this->input->post('requerido'),
                    'valopera' => (int)$this->input->post('ovalor'),
                    'minval' => $this->input->post('min'),
                    'maxval' => $this->input->post('max'),
                    'controltype' => (int)$this->input->post('tipocontrol'),
                    'estatus' => (int)$this->input->post('estado'),
                    'notas' => trim($this->input->post('notas')),
                    'whodidit' => $this->session->userdata('iduser'),
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->definicioniva_model->multiOpciones(12, [
                    'ID' => $ID,
                    'data' => $data
                ])) {
                    $datA[] = $this->conversion(3, $IDkey);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #   DELETE HIJO DEFINICION
        public function byeDefinicionIvaSon()
        {
            if($this->validatePermiso()) {
                $this->load->model('definicioniva_model');
                $IDkey = (int)$this->input->post('IDkey');
                $ID = (int)$this->input->post('ID');
                $valido = true;
                if ($valido) {
                    $this->definicioniva_model->multiOpciones(13, $ID);
                    $datA[] = $this->conversion(3, $IDkey);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        private function conversion($opc, $extra = null)
        {
            $Datos = [];
            switch ($opc) {
                # GET TIPOS DE LIBROS
                case 1:
                    $datos = $this->definicioniva_model->multiOpciones(1, $extra);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $Datos[] = array(
                                'key' => $dato->ivclase,
                                'documento' => trim($dato->descrip),
                                'operacion' => ($dato->ivopera == 1) ? '+' : '-',
                                'estado' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo'
                            );
                        }
                    }
                break;
                #   RESETEO DE DEFINICION
                case 2:
                    $dato = $this->definicioniva_model->multiOpciones(6, $extra);
                    if (count((array)$dato) > 0) {
                        $Datos =  array(
                            'ID' => $dato->ivclase,
                            'nombre' => trim($dato->descrip),
                            'clasedoc' => $dato->doc_clase,
                            'tipodoc' => $dato->doc_tipo,
                            'oiva' => $dato->ivopera,
                            'asknit' => $dato->asknit,
                            'askres' => $dato->askres,
                            'askserie' => $dato->askserie,
                            'askcentro' => $dato->askcentro,
                            'askcaja' => $dato->askcaja,
                            'askfunico' => $dato->askfunico,
                            'askref' => $dato->askref,
                            'tasaiva' => $dato->tasaiva,
                            'tasarp' => $dato->tasarp,
                            'tasar' => $dato->tasaisr,
                            'periodo' => $dato->adays,
                            'transaccion' => $dato->invclase,
                            'auxiliares' => (trim($dato->idauxidef) != '0') ? trim($dato->idauxidef) : '',
                            'usuarios' => $dato->ausers,
                            'defaultfld' => $dato->defaultfld,
                            'xpos' => $dato->xpos,
                            'estado' => $dato->estatus,
                            'notas' => $dato->notas
                        );
                    } else $Datos = null;
                break;
                #   GET FORMULARIOS DE DEFINICION
                case 3:
                    $datos = $this->definicioniva_model->multiOpciones(9, $extra);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $Datos[] = array(
                                'key' => $dato->idrec,
                                'orden' => (int)$dato->orden,
                                'titulo' => trim($dato->titulo),
                                'valor' => array_search((int)$dato->askvalor, array_column($this->Valores, 'ID', 'Name')),
                                'vvalor' => $dato->askvalor,
                                'requerido' => $dato->requerido,
                                'ovalor' => $dato->valopera,
                                'min' => $dato->minval,
                                'max' => $dato->maxval,
                                'tipocontrol' => $dato->controltype,
                                'estado' => $dato->estatus,
                                'notas' => trim($dato->notas)
                            );
                            $valorfound = array_search((int)$dato->askvalor, array_column($this->Valores, 'ID'));
                            if ($valorfound !== false) $this->Valores[$valorfound]['disabled'] = true;//*/
                        }
                    }
                    $Datos = array(
                        'valido' => true,
                        'datos' => $Datos,
                        'valores' => $this->Valores,
                        'numero' => $this->definicioniva_model->multiOpciones(10, $extra),
                    );
                break;
                #   DISEÑO TO REPORTE
                case 4:
                    $papa = $extra['papa'];
                    $hijos = $extra['hijos'];
                    $html = '';
                    $selects = [];
                    $search = array('á', 'é', 'í', 'ó', 'ú');
                    $replace = array('Á', 'É', 'Í', 'Ó', 'Ú');
                    foreach ($this->SeleccionCheques as $select) {
                        if ($papa->{$select['nombre']} == 1) $selects[] = strtoupper(str_replace($search, $replace, $select['texto']));
                    }
                    $html.= trim('
                        <tr style="font-weight: bold;">
                            <td style="width: 5%; text-align: center;">'.$papa->ivclase.'</td>
                            <td style="width: 95%;">'.strtoupper($papa->descrip).'</td>
                        </tr>
                        <tr style="">
                            <td style="width: 10%; font-size: 9px;"></td>
                            <td style="width: 45%; font-size: 9px;">'.implode('', [
                                '<b>Operacion: </b>'.(($papa->ivopera == 1) ? 'SUMA' : 'RESTA').'<br>',
                                ((count($selects) > 0) ? ('<b>Seleccionar: </b>'.implode(',', $selects).'<br>') : ''),
                                (($papa->transaccion != null) ? ('<b>Transaccion: </b>'.$papa->transaccion) : '')
                            ]).'</td>
                            <td style="width: 45%; font-size: 9px;">'.implode('', [
                                '<b>Tasa IVA: </b>'.$papa->tasaiva.'<br>',
                                '<b>Tasa Retención/Percepción: </b>'.$papa->tasarp.'<br>',
                                '<b>Tasa ISR: </b>'.$papa->tasaisr.'<br>',
                            ]).'</td>
                        </tr>
                    ');
                    if (count($hijos) > 0) $html.= '<tr><td style="width:100%; border-bottom: 1px solid black; line-height: 4px;"></td></tr>'.implode('', $hijos);
                    $Datos = $html;
                break;
            }
            return $Datos;
        }
        #   REPORTE DE LIBROS
        public function RLibro($Tipo = null)
        {
            if($this->validatePermiso()) {
                if (($Tipo != null) && (is_numeric($Tipo))) {
                    $posicion = array_search((int)$Tipo, array_column($this->Libros, 'id'));
                    if ($posicion !== false) {
                        $Tipo = (int)$Tipo;
                        $Libro = $this->Libros[$posicion];
                        $this->load->model('definicioniva_model');
                        $this->load->library('Pdfconta');
                        $empresa = $this->definicioniva_model->getValores()->valor_memo;
                        $usuario = $this->session->userdata('userLog');
                        $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
                        #   HEADER TEST
                        $dataHeader = '
                            <table style="width:100%;">
                                <tr style="font-size: 15px; font-family: sans-serif;">
                                    <td style="width:10%;"></td>
                                    <td style="width:80%; text-align: center;"><strong>'.$empresa.'</strong></td>
                                    <td style="width:10%;"></td>
                                </tr>
                                <tr style="font-size: 15px; font-family: sans-serif;">
                                    <td style="width:10%;"></td>
                                    <td style="width:80%; text-align: center;"><strong>REPORTE DE '.strtoupper($Libro['text']).'</strong></td>
                                    <td style="width:10%;"></td>
                                </tr>
                                <tr style="line-height: 10px;"><td></td></tr>
                            </table>
                        ';
                        $pdf->setHtmlHeader($dataHeader);
                        #   FOOTER TEST
                        date_default_timezone_set('America/El_Salvador');
                        $dataFooter = '
                            <table style="width=100%; border-top: 1px solid black; margin: 0px; padding: 0px;">
                                <tr style="font-size: 10px;">
                                    <td style="width:33%; text-align: left;">'.date_create()->format('d/m/Y H:i:s A').'</td>
                                    <td style="width:34%; text-align: center;">'.$usuario.'</td>
                                    <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                                </tr>
                            </table>
                        ';
                        $pdf->setHtmlFooter($dataFooter);
                        $pdf->SetCreator(PDF_CREATOR);
                        $pdf->SetAuthor('Versanet Sistemas');
                        $pdf->SetTitle('Reporte de '.$Libro['text']);
                        $pdf->SetSubject('Reporte de Libro');
                        $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                        //$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                        //$pdf->setPrintHeader(false);
                        //$pdf->setPrintFooter(true);
                        $pdf->SetMargins(5, 27, 5, 0);
                        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
                        //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                        $pdf->SetFont('helvetica', '', 9);
                        $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
                        $html = '';
                        $datos = $this->definicioniva_model->multiOpciones(-3, $Tipo);
                        if ($datos->num_rows() > 0) {
                            $hijos = [];
                            $papa = $datos->result()[0];
                            $html.= '<table style="width=100%;">';
                            foreach ($datos->result() as $dato) {
                                if ($papa->ivclase != $dato->ivclase) {
                                    $html.= $this->conversion(4, [
                                        'papa' => $papa,
                                        'hijos' => $hijos
                                    ]);
                                    $papa = $dato;
                                    $hijos = [];
                                }
                                if ($dato->orden != null) {
                                    $hijos[] = trim('
                                        <tr style="">
                                            <td style="width: 10%; font-size: 9px;"></td>
                                            <td style="width: 5%; font-size: 9px; text-align: center;">'.$dato->orden.'</td>
                                            <td style="width: 45%; font-size: 9px;">'.$dato->titulo.'</td>
                                            <td style="width: 40%; font-size: 9px;">'.array_search($dato->askvalor, array_column($this->Valores, 'ID', 'Name')).'</td>
                                        </tr>
                                    ');
                                }
                            }
                            #   LAST DEFINIICION
                                $papa = $datos->result()[$datos->num_rows() - 1];
                                $html.= $this->conversion(4, [
                                    'papa' => $papa,
                                    'hijos' => $hijos
                                ]);
                            #-
                            $html.= '</table>';
                        }
                        $pdf->writeHTML($html);
                        //$pdf->writeHTML($html, true, 0, true, 0);
                        $pdf->lastPage();
                        $pdf->Output(utf8_decode('Reporte de '.$Libro['text'].'.pdf'), 'I');
                    } else echo "<h1>Parámetros Incorrecto</h1>";
                } else echo "<h1>Parámetros no validos</h1>";
            }
        }
    }
?>