<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Cpedidos extends CI_Controller{
        
        function __construct(){
            parent::__construct();
        }
        
        function verPedidos($idapp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('pedclientes_model');
                $appName = $this->configuracion_model->getAppName($idapp);
                $procentro = $this->configuracion_model->getProCentro($idapp);
                $resultAppName = array(
                    'iddApp' => $idapp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'idprocentro' => $procentro
                );
                $this->session->set_userdata($resultAppName);
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->session->userdata('idprocentro');
                $this->data['pedidos'] = $this->pedclientes_model->getPedidos($idcentro, 0, $procentro, 'VN');
                $this->load->view('pedidos/pedidos_pasteleria', $this->data);
            }
        }
        
        function adicionar_pedido(){
            if($this->session->userdata('logueado') == 'FALSE'){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->model('mantenimiento_model');
                $this->data['sucursales'] = $this->mantenimiento_model->getSucursales();
                $this->load->view("pedidos/cpedido_adicionar",$this->data);
            }
        }
        
        function buscar_cliente_telefono(){
            $cliphone = $this->input->post('cliphone');
            $this->load->model('pedclientes_model');
            $coincidencia = $this->pedclientes_model->buscar_cliente_telefono($cliphone);

            if($coincidencia==false){
                $nombre = "";
                $email = "";
                $cli_phone1 = "";
                $cli_notify = "";
                $dev_place = "";
                $dev_direc = "";
                $dev_phone = "";
                $dev_contact = "";
                $dev_notes = "";
            }else{
                $nombre = $coincidencia['descrip'];
                $email = $coincidencia['cli_email'];
                $dev_place = $coincidencia['dev_place'];
                $dev_direc = $coincidencia['dev_direc'];
                $dev_phone = $coincidencia['dev_phone'];
                $dev_contact = $coincidencia['dev_contact'];
            }

            $array = array(
                'cliname'=>$nombre, 
                'cliemail'=>$email,
                'dev_place'=>$dev_place,
                'dev_direc'=>$dev_direc,
                'dev_phone'=>$dev_phone,
                'dev_contact'=>$dev_contact
            );
            
            echo json_encode($array);
        }
        
        function registrarPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('pedclientes_model');
                
                $cliphone = $this->input->post('cliphone');
                $cliname = $this->input->post('cliname');
                $cliname = strtoupper($cliname);
                $cliemail = $this->input->post('cliemail');
                $notas = $this->input->post('notas');
                $fecha = date_format(date_create($this->input->post('devdate')), 'Y-m-d');
                $time = $this->input->post('devtime');
                $place = $this->input->post('devplace');
                $idsucursal = $this->input->post('idsucurentrega');
                $devcontact = $this->input->post('devcontact'); 
                $devphone = $this->input->post('devphone');
                $devdirec = $this->input->post('devdirec');
                $option = $this->input->post('saveNext');
                $procentro = trim($this->session->userdata('idprocentro'));
                $idcentro = $this->session->userdata('idcentrouser');
                $numero = $this->pedclientes_model->insertPedido($cliphone, $procentro, $cliname, $cliemail, $notas, $fecha, $time, $place, $idsucursal, $devcontact, $devphone, $devdirec, $idcentro);
                
                if($option == 1){
                    $continue = array(
                        'continue' => 1
                    );
                    $this->session->set_userdata($continue);
                }
                
                if($numero != 0){
                    $this->editar_pedido($numero);
                    $continue = array(
                        'continue' => 0
                    );
                    $this->session->set_userdata($continue);
				}else{
                    $this->load->view("pedidos/adicionar_pedido");
                    $continue = array(
                        'continue' => 0
                    );
                    $this->session->set_userdata($continue);
                }   
            }
        }
        
        function actualizarPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('pedclientes_model');
                
                $cliphone = $this->input->post('cliphone');
                $idTrannum = $this->input->post('idTrannum');
                $cliname = $this->input->post('cliname');
                $cliname = strtoupper($cliname);
                $cliemail = $this->input->post('cliemail');
                $notas = $this->input->post('notas');
                $fecha = date_format(date_create($this->input->post('devdate')), 'Y-m-d');
                $time = $this->input->post('devtime');
                $place = $this->input->post('devplace');
                $idsucursal = $this->input->post('idsucurentrega');
                $devcontact = $this->input->post('devcontact'); 
                $devphone = $this->input->post('devphone');
                $devdirec = $this->input->post('devdirec');
                $procentro = trim($this->session->userdata('idprocentro'));
                $idcentro = $this->session->userdata('idcentrouser');
                $numero = $this->pedclientes_model->updateRegPedido($idTrannum, $cliphone, $procentro, $cliname, $cliemail, $notas, $fecha, $time, $place, $idsucursal, $devcontact, $devphone, $devdirec, $idcentro);
                
                if($numero != 0){
                    $this->editar_pedido($numero);
				}else{
                    $this->load->view("pedidos/adicionar_pedido");
                }   
            }
        }
        
        function editar_pedido($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('mantenimiento_model');
                $this->load->model('pedclientes_model');
                $this->data['sucursales'] = $this->mantenimiento_model->getSucursales();
                $this->data['data_pedido'] = $this->pedclientes_model->getDataPedido($numero, 0);
                $this->load->view('pedidos/cpedido_editar', $this->data);
            }
        }
        
        function searchProducts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $valFind = $this->input->post('valFind');
                $procentro = trim($this->session->userdata('idprocentro'));
                
                $this->load->model('pedclientes_model');
                $SearchResult = $this->pedclientes_model->findProducts($valFind, $procentro);
                
                echo json_encode($SearchResult);
            }
        }
        
        function getProductSelect(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $itemLine = $this->input->post('itemLine');
                $trannum = $this->input->post('trannum');
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('pedclientes_model');
                $SearchResult = $this->pedclientes_model->getDataProducto($itemLine, $trannum, $idproducto);
                $ResultData = $this->pedclientes_model->getDataProduct($trannum);
                
                $array = array(
                    "dataSelect" => $SearchResult,
                    "dataAll" => $ResultData
                );
                
                echo json_encode($array);
            }
        }
        
        function nextProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $id = $this->input->post('idrec');
                $this->load->model('pedclientes_model');
                $SearchResult = $this->pedclientes_model->getDataNextProducto($id);
                
                $array = array(
                    "dataSelect" => $SearchResult
                );
                
                echo json_encode($array);
            }
        }
        
        function previousProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $id = $this->input->post('idrec');
                $this->load->model('pedclientes_model');
                $SearchResult = $this->pedclientes_model->getDataPreviousProducto($id);
                
                $array = array(
                    "dataSelect" => $SearchResult
                );
                
                echo json_encode($array);
            }
        }
        function setProductsOrden(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $productArray = $this->input->post('products');
                $trannum = $this->input->post('idcontrol');
                
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->setDataProductOrden($productArray, $trannum);
                
                echo json_encode($ResultData);
            }
        }
        
        function getProOrden(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('idcontrol');
                
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->getDataProduct($trannum);
                
                echo json_encode($ResultData);
            }
        }
        
        function updateDataPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $notas = $this->input->post('notas');
                $cantidad = $this->input->post('cantidad');
                $trannum = $this->input->post('trannum');
                
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->updatePedido($idrec, $trannum, $notas, $cantidad);
                
                echo json_encode($ResultData);
            }
        }
        
        function eliminarProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('trannum');
                
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->deleteProductoPedido($idrec, $trannum);
                
                echo json_encode($ResultData);
            }
        }
        
        function getPricePedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idpedido = $this->input->post('idpedido');
                
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->getDataProduct100($idpedido);
                
                echo json_encode($ResultData);
            }
        }
        
        function setPriceEnvio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $valEnvio = $this->input->post('valEnvio');
                    
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->updateValEnvio($idtrannum, $valEnvio);
                    
                echo json_encode($ResultData);
            }
        }
        
        function updatePriceVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $valVenta = $this->input->post('valVenta');
                    
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->updateValVenta($idtrannum, $valVenta);
                    
                echo json_encode($ResultData);
            }
        }
        
        function setPriceAnticipo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $valAnt = $this->input->post('valAnt');
                    
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->updateValAnticipo($idtrannum, $valAnt);
                    
                echo json_encode($ResultData);
            }
        }
        
        function confirmarOrden(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $valAnt = $this->input->post('valAnt');
                    
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->getDataPedido($idtrannum, 0);
                $ResultCantidades = $this->pedclientes_model->getCantidades($idtrannum);
                
                $array = array(
                    "dataResult" => $ResultData,
                    "dataCantidad" => $ResultCantidades
                );
                
                echo json_encode($array);
            }
        }
        
        function updateEstadoOrden(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $valVenta = $this->input->post('valVenta');
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->setConfirmacionOrden($idtrannum, $valVenta);
                echo json_encode($ResultData);
            }
        }
        
        function getListProductCero(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('trannum');
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->getDataListProductCero($idtrannum);
                echo json_encode($ResultData);
            }
        }
        
        function deleteProductEmpty(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $this->load->model('pedclientes_model');
                $ResultData = $this->pedclientes_model->deleteSinCantidad($idtrannum);
                echo json_encode($ResultData);
            }
        }
        
        function searchProductsCode(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $search = $this->input->post('val_search');
                $procentro = trim($this->session->userdata('idprocentro'));
                
                $this->load->model('pedclientes_model');
                $array = $this->pedclientes_model->searchProductCode($search, $procentro);
                
                echo json_encode($array);
            }
        }
        
        function insertFindProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $name = $this->input->post('namePro');
                $idproducto = $this->input->post('idPro');
                $cantidad = $this->input->post('cantPro');
                $notas = $this->input->post('notas');
                $precio = $this->input->post('precio');
                
                $this->load->model('pedclientes_model');
                $array = $this->pedclientes_model->ingresarProducto($trannum, $name, $idproducto, $cantidad, $notas, $precio);
                
                echo json_encode($array);
            }
        }
        
        function pedidosConfirmados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->session->userdata('idprocentro');
                
                $this->load->model('pedclientes_model');
                $data = $this->pedclientes_model->getDataPedidos($idcentro, 1, $procentro);
                
                echo json_encode($data);
            }
        }
        
        function pedidosRuta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->session->userdata('idprocentro');
                
                $this->load->model('pedclientes_model');
                $data = $this->pedclientes_model->getDataPedidos($idcentro, 4, $procentro);
                
                echo json_encode($data);
            }
        }
        
        function pedidosRecibidos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->session->userdata('idprocentro');
                
                $this->load->model('pedclientes_model');
                $data = $this->pedclientes_model->getDataPedidos($idcentro, 5, $procentro);
                
                echo json_encode($data);
            }
        }
        
        function pedidosEntregados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $procentro = $this->session->userdata('idprocentro');
                
                $this->load->model('pedclientes_model');
                $data = $this->pedclientes_model->getDataPedidos($idcentro, 8, $procentro);
                
                echo json_encode($data);
            }
        }
        
        function eliminarPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $numero = $this->input->post('numero');
                
                $this->load->model('pedclientes_model');
                $data = $this->pedclientes_model->deletePedido($numero);
                
                echo json_encode($data);
            }
        }
        
        function verDetalle(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('pedclientes_model');
                
                $dataPedido = $this->pedclientes_model->getDataPedidoArray($trannum, 1);
                $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                $name = $this->pedclientes_model->getnameImg();

                $sucursal = strtoupper($dataPedido['pedidoSuc']);
                $pedido = $dataPedido['trannum'];
                $date = date_format(date_create($dataPedido['fecha']),'d/m/Y');
                $cli_name = $dataPedido['descrip'];
                $cli_phone = $dataPedido['cli_phone'];
                $cli_email = $dataPedido['cli_email'];
                $notas = $dataPedido['notas'];
                $dev_date = ucwords($dataPedido['fechaPedido']);
                $dev_time = date("g:i a", strtotime($dataPedido['dev_time']));
                if($dataPedido['dev_place'] == 1){
                    $lugar = $dataPedido['nameSucursal'];
                }else{
                    $lugar = $dataPedido['dev_direc'];    
                }
                $dev_contact = $dataPedido['dev_contact'];
                $dev_phone =$dataPedido['dev_phone'];
                $valPedido = $dataPedido['val_pro'];
                $valEnvio = $dataPedido['val_envio'];
                $valVenta = $dataPedido['val_tot'];
                $valAnti = $dataPedido['val_anti'];


                $estructura = '<table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:12px; text-align:right;">ORDEN DE PEDIDO<br>'.strtoupper($this->session->userdata('appName')).'</td>
                                    </tr>
                                </table><br>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:70%;">Nombre de Cliente:</td>
                                        <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:30%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:70%;">'.$cli_name.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:12px; text-align:right; width:15%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:70%;">Teléfono: <strong>'.$cli_phone.'</strong>&nbsp;&nbsp;Correo: <strong>'.$cli_email.'</strong></td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Sucursal</td>
                                        <td style="font-size:10px; text-align:right; width:15%; border: 1px solid #6E6E6E;">'.$sucursal.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:70%;"></td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:15%; border: 1px solid #6E6E6E; color:#0B486B;">'.$trannum.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:70%;"></td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:15%; border: 1px solid #6E6E6E;">$'.$valVenta.'</td>
                                    </tr>
                                </table>';

                 $estructura .= '<br><div class="row"><div class="col-xs-12 col-md-12 col-sm-12">
                                    <div class="col-xs-12 col-sm-12 col-md-12" style="font-size:12px; text-align:left; background-color:#E8E8E8; font-weight: bold; border: 1px solid #6E6E6E;">Detalles de entrega</div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:left; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</div>
                                    <div class="col-xs-5 col-sm-5 col-md-5" style="font-size:12px; text-align:left; border: 1px solid #6E6E6E;">'.$dev_date.'</div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:left; font-weight: bold; border: 1px solid #6E6E6E;">Hora</div>
                                    <div class="col-xs-5 col-sm-5 col-md-5" style="font-size:12px; text-align:left; border: 1px solid #6E6E6E;">'.$dev_time.'</div>
                                    
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:left; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</div>
                                    <div class="col-xs-11 col-sm-11 col-md-11" style="font-size:12px; text-align:left; border: 1px solid #6E6E6E;">'.$lugar.'</div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:left; font-weight: bold; border: 1px solid #6E6E6E;">Contacto</div>
                                    <div class="col-xs-5 col-sm-5 col-md-5" style="font-size:12px; text-align:left; border: 1px solid #6E6E6E;">'.$dev_contact.'</div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:left; font-weight: bold; border: 1px solid #6E6E6E;">Teléfono</div>
                                    <div class="col-xs-5 col-sm-5 col-md-5" style="font-size:12px; text-align:left; border: 1px solid #6E6E6E;">'.$dev_phone.'</div>
                                    
                                    <div class="col-xs-12 col-sm-12 col-md-12" style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Detalle del Pedido</div>
                                    
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:center; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</div>
                                    <div class="col-xs-6 col-sm-6 col-md-6" style="font-size:12px; text-align:left;  font-weight: bold;">Descripción del Producto</div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:left;  font-weight: bold;" >Notas</div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:right; font-weight: bold;">Precio</div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</div>';
                foreach($list_producto as $key){
                    $subtotal = $key->cantidad * $key->precioneto;
                    $estructura .= '<div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:center; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</div>
                                    <div class="col-xs-6 col-sm-6 col-md-6" style="font-size:12px; text-align:left;">'.$key->descrip.'</div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:9px; text-align:left;">'.$key->notas.'</div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:right;">$'.number_format($key->precioneto, 2, '.', '').'</div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; border-right: 1px solid #6E6E6E;">$'.number_format($subtotal, 2, '.', '').'</div>';
                            }
                    $estructura .= '<div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:center; border-left: 1px solid #6E6E6E;">&nbsp;</div>
                                    <div class="col-xs-6 col-sm-6 col-md-6" style="font-size:12px; text-align:left;"></div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:left;"></div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; font-weight: bold;">Sub-total</div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; border-right: 1px solid #6E6E6E;">$'.$valPedido.'</div>
                                    
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:center; border-left: 1px solid #6E6E6E;">&nbsp;</div>
                                    <div class="col-xs-6 col-sm-6 col-md-6" style="font-size:12px; text-align:left;"></div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:left;"></div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; font-weight: bold;">Envio</div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; border-right: 1px solid #6E6E6E;">$'.$valEnvio.'</div>
                                    
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:center; border-left: 1px solid #6E6E6E;">&nbsp;</div>
                                    <div class="col-xs-6 col-sm-6 col-md-6" style="font-size:12px; text-align:left;"></div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:left;"></div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; font-weight: bold;">Suma</div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; border-right: 1px solid #6E6E6E;">$'.$valVenta.'</div>
                                    
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:center; border-left: 1px solid #6E6E6E;">&nbsp;</div>
                                    <div class="col-xs-6 col-sm-6 col-md-6" style="font-size:12px; text-align:left;"></div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:left;"></div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; font-weight: bold;">Anticipo</div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; border-right: 1px solid #6E6E6E;">$'.$valAnti.'</div>
                                    
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:center; border-left: 1px solid #6E6E6E;">&nbsp;</div>
                                    <div class="col-xs-6 col-sm-6 col-md-6" style="font-size:12px; text-align:left;"></div>
                                    <div class="col-xs-1 col-sm-1 col-md-1" style="font-size:12px; text-align:left;"></div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; font-weight: bold;">Pendiente</div>
                                    <div class="col-xs-2 col-sm-2 col-md-2" style="font-size:12px; text-align:right; border-right: 1px solid #6E6E6E;">$'.number_format(round(($valVenta-$valAnti), 2),2).'</div>';
                    
                    $estructura .= '<div class="col-xs-12 col-sm-12 col-md-12" style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</div>
                                    <div class="col-xs-12 col-sm-12 col-md-12" style="font-size:12px; text-align:left; height:60px; border: 1px solid #6E6E6E;">'.$notas.'</div>
                                    <div><div>';
                    
                
                echo json_encode($estructura);
            }
        }
        
    }
?>