<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require 'vendor/autoload.php';
                    
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Contabilidad extends CI_Controller{ 
    
    private $Grupos = [
        array('ID' => 1, 'text' => 'Activo'),
        array('ID' => 2, 'text' => 'Pasivo'),
        array('ID' => 3, 'text' => 'Patrimonio'), 
        array('ID' => 4, 'text' => 'Deudoras'),
        array('ID' => 5, 'text' => 'Acreedoras'),
        array('ID' => 6, 'text' => 'Liquidadora'),
        array('ID' => 7, 'text' => 'Orden a Favor'),
        array('ID' => 8, 'text' => 'Orden en Contra'),
        array('ID' => 9, 'text' => 'Todas'),
    ];
    private $TControles = array(
        array('ID' => 0, 'Name' => 'Ninguno', 'permiso' => ''),
        array('ID' => 1, 'Name' => 'Banco', 'permiso' => '1'),
        array('ID' => 2, 'Name' => 'CxC/CxP', 'permiso' => '1,2'),
        array('ID' => 3, 'Name' => 'Impuesto', 'permiso' => '1,2'),
        array('ID' => 4, 'Name' => 'Inventario', 'permiso' => '1'),
        array('ID' => 5, 'Name' => 'Activo Fijo', 'permiso' => '1'),
        array('ID' => 6, 'Name' => 'Utilidades del Ejercicio', 'permiso' => '3'),
        array('ID' => 7, 'Name' => 'Pérdidas del Ejercicio', 'permiso' => '3'),
        array('ID' => 10, 'Name' => 'Ingresos de Operación', 'permiso' => '5'),
        array('ID' => 11, 'Name' => 'Rebaja y Devoluciones S/Ventas', 'permiso' => '4,5'),
        array('ID' => 12, 'Name' => 'Otros Ingresos', 'permiso' => '5'),
        array('ID' => 20, 'Name' => 'Costos de Ventas', 'permiso' => '4'),
        array('ID' => 25, 'Name' => 'Gastos de Ventas', 'permiso' => '4'),
        array('ID' => 40, 'Name' => 'Gastos de Administración', 'permiso' => '4'),
        array('ID' => 41, 'Name' => 'Gastos No Operativos', 'permiso' => '4'),
        array('ID' => 30, 'Name' => 'Ingresos No Operativos', 'permiso' => '5'),
    );
    private $meses = array(
        'enero' => 1,
        'febrero' => 2,
        'marzo' => 3,
        'abril' => 4,
        'mayo' => 5,
        'junio' => 6,
        'julio' => 7,
        'agosto' => 8,
        'septiembre' => 9,
        'octubre' => 10,
        'noviembre' => 11,
        'diciembre' => 12,
    );
    private $TiposCuentas = array(
        'Totalizadora' => 1,
        'Acumuladora' => 2,
        'Movimiento' => 3,
    );
    #   OPCIONES DE CONTROL DE BANCOS
    private $OpcionesBancos = array(
        array('ID' => 0, 'Name' => 'Cheque', 'icon' => 'box'),
        array('ID' => 1, 'Name' => 'Remesa', 'icon' => 'fa fa-credit-card'),
        array('ID' => 2, 'Name' => 'Transferencia', 'icon' => 'fa fa-forward'),
        array('ID' => 3, 'Name' => 'Notas de Abono', 'icon' => 'selectall'),
        array('ID' => 4, 'Name' => 'Notas de Cargo', 'icon' => 'selectall'),
        array('ID' => 10, 'Name' => 'Salir', 'icon' => 'close'),
    );
    #   OPCIONES DE ASISTENTE CONTABLE
    private $OpcionesAC = [
        array('icon' => 'bookmark', 'text' => 'Emisión de Quedan', 'opcion' => 0, 'variable' => 'conta_acquedan', 'developed' => true),
        array('icon' => 'bookmark', 'text' => 'Pagos a Proveedores', 'opcion' => 1, 'variable' => 'conta_acpagosp', 'developed' => true),
        array('icon' => 'bookmark', 'text' => 'Abonos de Clientes', 'opcion' => 2, 'variable' => 'conta_acabonosc', 'developed' => true),
        array('icon' => 'bookmark', 'text' => 'Gastos', 'opcion' => 3, 'variable' => 'conta_acgastos', 'developed' => false),
        array('icon' => 'bookmark', 'text' => 'Depositos', 'opcion' => 4, 'variable' => 'conta_acdepos', 'developed' => false),
        array('icon' => 'bookmark', 'text' => 'Transferencias', 'opcion' => 5, 'variable' => 'conta_actransfer', 'developed' => false),
    ];
    private $EstadosPartidas = array(
        'En Elaboración' => 0,
        'Actualizada' => 1,
        'Anulada' => 9,
    );
    private $Tiposcontribuyentes =  array(
        '' => 0,
        'Pequeño' => 1,
        'Mediano' => 3,
        'Grande' => 4,
        'Otro' => 5,
    );
    
    function __construct(){
        parent::__construct();
        date_default_timezone_set('America/El_Salvador');
    }
    private function validatePermiso() {
        $permiso = true;
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || !$permiso) redirect('CerrarSesion');
        else return true;
    }

    #------------------------------------------------------     CATALOGO DE CUENTAS ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     CATALOGO DE CUENTAS MEJORA --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function verificarCuentaExiste(){
        $this->load->model('contabilidad_model');
        $cuenta = $this->input->post("cuenta");
        $respuesta = $this->contabilidad_model->verificarCuentaExiste($cuenta);
        echo json_encode($respuesta); 
    }
    function highlight_array($array, $name = 'var') {
        highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
    }

    public function indexCuentasN($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $this->load->model('contabilidad_model');

            $this->iniciarUReportes();
            $appName = $this->configuracion_model->getAppName($idApp);

            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['controles'] = $this->TControles;
            $this->data['proyectos'] = $this->contabilidad_model->getProyectos();
            $arrayTipos1 = array_slice($this->TiposCuentas,1);
            $arrayTipos = [];
            foreach($arrayTipos1 as $key => $value){
                $arrayTipos[] = array(
                    "id" => $value,
                    "tipo" => $key,
                );
            }
            
            $this->data['tipos'] = $arrayTipos;
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->load->view("mantenimiento_Cat_CuentasN", $this->data);
        }
    }
    #   GET CUENTAS
    public function getCuentasN()
    {
        if($this->validatePermiso()) {
            $grupo = (int)$this->input->post("grupo") + 1;
            $this->load->model('contabilidad_model');
            $datos = $this->contabilidad_model->getCuentasN($grupo);
            echo json_encode($datos);
        }
    }
    #   GET CUENTAS DETALLE
    public function getCuentasDetalleN()
    {
        if($this->validatePermiso()) {
            $padre = $this->input->post("padre");
            $this->load->model('contabilidad_model');
            $datos = $this->contabilidad_model->getCuentasDetalleN($padre);
            echo json_encode($datos);
        }
    }
    #   GET DATA GENERAL 
    public function getDataC()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            if (($cauxs = $this->contabilidad_model->getDataC(0)) &&
                ($cprovs = $this->contabilidad_model->getDataC(1)) &&
                ($centros = $this->contabilidad_model->getDataC(2)) &&
                ($users = $this->contabilidad_model->getDataC(3)))
            {
                $Datos1 = [];
                $arrayAux = [];
                $arrayPro = [];
                $Datos2 = [];
                $Datos3 = [];
                $cont = 0;
                if ($cauxs->num_rows() > 0) {
                    foreach ($cauxs->result() as $dato) {
                        $cuenta = "1".','.(int)$dato->valor_num;
                        $arrayAux[] = array(
                            'ID' => "".$cont,
                            'tipo' => 1,
                            'valor' => (int)$dato->valor_num,
                            'Name' => $dato->descripcion,
                            'aux' => $cuenta,
                        );
                        $cont++;
                    }
                }
                if ($cprovs->num_rows() > 0) {
                    foreach ($cprovs->result() as $dato) {
                        $cuenta = "2".','.(int)$dato->valor_num;

                        $arrayPro[] = array(
                            'ID' => "".$cont,
                            'tipo' => 2,
                            'valor' => (int)$dato->valor_num,
                            'Name' => $dato->descripcion,
                            'aux' => $cuenta,
                        );
                        $cont++;
                    }
                }
                $Datos1[] = array("key"=>"Auxiliares", "items"=> $arrayAux);
                $Datos1[] = array("key"=>"Productos", "items"=> $arrayPro);

                if ($centros->num_rows() > 0) {
                    foreach ($centros->result() as $dato) {
                        $Datos2[] = array(
                            'ID' => $dato->idcentro,
                            'Name' => $dato->descrip,
                            'tipo' => $dato->tipo
                        );
                    }
                }
                if ($users->num_rows() > 0) {
                    foreach ($users->result() as $dato) {
                        $Datos3[] = array(
                            'ID' => $dato->iduser,
                            'Name' => $dato->descrip
                        );
                    }
                }

                //Obtiene las etiquetas existentes en el listado de cuentas
                $etiquetas = $this->contabilidad_model->getDataC(4);
                $arrayEtiquetas = [];
                foreach($etiquetas as $eti){
                    //Convierte cada string separado por coma a array
                    $arrayExplode = explode(",", $eti['xpos']);
                    //Adiciona cada etiqueta individual al array 
                    foreach($arrayExplode as $item){
                        if($item != ""){
                            $arrayEtiquetas[] = $item;
                        }
                    } 
                }
                //Elimina todas las etiquetas repetidas
                $arrayEtiquetas = array_unique($arrayEtiquetas);

                if ($ID = $this->input->post("ID")) {
                    if ($cuenta = $this->contabilidad_model->getCuentaN((int)$ID)) {
                        $datA[] = array(
                            'valido' => true,
                            'auxs' => $Datos1,
                            'centros' => $Datos2,
                            'users' => $Datos3,
                            'cuenta' => $cuenta,
                            'etiquetas' => $arrayEtiquetas

                        );
                    } else $datA[] = array('valido' => false, 'tipo' => 1);
                } else {
                    $datA[] = array(
                        'valido' => true,
                        'auxs' => $Datos1,
                        'centros' => $Datos2,
                        'users' => $Datos3,
                        'etiquetas' => $arrayEtiquetas

                    );
                }
            } else $datA[] = array('valido' => false, 'tipo' => 0);
            echo json_encode($datA);
        }
    }


    #   SET CUENTA
    public function setCuentaN()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            date_default_timezone_set('America/El_Salvador');
            if ($this->contabilidad_model->ValidationCuenta($this->input->post("codigo")) == 0) {
                switch ((int)$this->input->post("tipo")) {
                    case 1:
                        $data = array(
                            'idctcuenta' => $this->input->post("codigo"), 
                            'descrip' => $this->input->post("titulo"), 
                            'tipocuenta' => (int)$this->input->post("tipo"),
                            'catgrupo' => (int)$this->input->post("grupo"), 
                            'ctcontrol' => 0,
                            'askidproyecto' => 0,
                            'xpos' => $this->input->post('xpos'),
                            'notas' => $this->input->post('notas'),
                            'balview' => ($this->input->post("mostrar") == "true") ? 1 : 0,
                            'estatus' => 1,
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                        );
                    break;
                    case 2:
                        $data = array(
                            'idctcuenta' => $this->input->post("codigo"), 
                            'descrip' => $this->input->post("titulo"), 
                            'tipocuenta' => (int)$this->input->post("tipo"),
                            'ctmayoriza' => $this->input->post("mayor"),
                            'catgrupo' => (int)$this->input->post("grupo"), 
                            'ctcontrol' => 0,
                            'askidproyecto' => 0,
                            'xpos' => $this->input->post('xpos'),
                            'notas' => $this->input->post('notas'),
                            'balview' => ($this->input->post("mostrar") == "true") ? 1 : 0,
                            'estatus' => 1,
                            'whodidit' => $this->session->userdata('iduser'), 
                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                        );
                    break;
                    case 3:
                        $data = array(
                            'idctcuenta' => $this->input->post("codigo"), 
                            'descrip' => $this->input->post("titulo"), 
                            'tipocuenta' => (int)$this->input->post("tipo"),
                            'ctmayoriza' => $this->getMayor($this->input->post("mayor")),
                            'catgrupo' => (int)$this->input->post("grupo"),
                            'ctcontrol' => (int)$this->input->post('tcontrol'),
                            'useauxi' => $this->input->post('auxiliar'),
                            'askidcentro' => $this->input->post('ccostos'),
                            'askidproyecto' => (int)$this->input->post('cproyecto'),
                            'allowed_users' => $this->input->post('users'),
                            'xpos' => $this->input->post('xpos'),
                            'notas' => $this->input->post('notas'),
                            'balview' => ($this->input->post("mostrar") == "true") ? 1 : 0,
                            'estatus' => ($this->input->post("estado") == "true") ? 1 : 0,
                            'whodidit' => $this->session->userdata('iduser'), 
                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                        );
                    break;
                }
                if ($this->contabilidad_model->setCuenta($data)) {
                    $grupo = ((int)$this->input->post("all") == 8) ? 9 : (int)$this->input->post("grupo");
                    $cuentas = $this->contabilidad_model->getCuentasN($grupo);
                    $cuentasN = (((int)$this->input->post("tipo")) == 3) ? $this->contabilidad_model->getCuentasDetalleN($this->input->post("mayor")) : null;
                    $datA[] = array('valido' => true, 'datos' => $cuentas, 'details' => $cuentasN);
                } else $datA[] = array('valido' => false, 'tipo' => 2);
            } else $datA[] = array('valido' => false, 'tipo' => 1);
            echo json_encode($datA);
        }
    }
    #   GET CUENTA
    public function getCuentaN()
    {
        if($this->validatePermiso()) {
            $ID = (int)$this->input->post("ID");
            $this->load->model('contabilidad_model');

            if ($dato = $this->contabilidad_model->getCuentaN($ID)) {
                //Obtiene las etiquetas existentes en el listado de cuentas
                $etiquetas = $this->contabilidad_model->getDataC(4);
                $arrayEtiquetas = [];
                foreach($etiquetas as $eti){
                    //Convierte cada string separado por coma a array
                    $arrayExplode = explode(",", $eti['xpos']);
                    //Adiciona cada etiqueta individual al array 
                    foreach($arrayExplode as $item){
                        if($item != ""){
                            $arrayEtiquetas[] = $item;
                        }
                    } 
                }
                //Elimina todas las etiquetas repetidas
                $arrayEtiquetas = array_unique($arrayEtiquetas);

                $datA[] = array(
                    'valido' => true, 
                    'cuenta' => $dato,
                    'etiquetas' => $arrayEtiquetas

                );

            } else $datA[] = array(
                'valido' => false, 
                'tipo' => 0
            );
            echo json_encode($datA);
        }
    }
    #   UPDATE CUENTA
    public function updateCuentaN()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            date_default_timezone_set('America/El_Salvador');
            $ID = $this->input->post("ID");
            $tipo = 0;
            switch ((int)$this->input->post("tipo")) {
                case 1:
                    $data = array(
                        'descrip' => $this->input->post("titulo"),
                        'xpos' => $this->input->post('xpos'),
                        'notas' => $this->input->post('notas'),
                        'balview' => ($this->input->post("mostrar") == "true") ? 1 : 0,
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s')
                    );
                    $valido = true;
                break;
                case 2:
                    $data = array(
                        'descrip' => $this->input->post("titulo"),
                        'xpos' => $this->input->post('xpos'),
                        'notas' => $this->input->post('notas'),
                        'balview' => ($this->input->post("mostrar") == "true") ? 1 : 0,
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s')
                    );
                    $valido = true;
                break;
                case 3:
                    $versionOld = $this->contabilidad_model->multiplesContabilidad(1, $ID);
                    $nestado = ($this->input->post("estado") == "true") ? 1 : 0;
                    $nauxi = $this->input->post('auxiliar');
                    $ntcontrol = (int)$this->input->post('tcontrol');

                    //Verifica si existen cambios a realizar, o si el perfil del usuario es admin
                    if (($nestado != $versionOld->estatus) || ($nauxi != $versionOld->useauxi) || ($ntcontrol != $versionOld->ctcontrol)) {
                        $cambios = '';
                        if ($nestado != $versionOld->estatus) $cambios .= '1';
                        if ($nauxi != $versionOld->useauxi) $cambios .= ',2';
                        if ($ntcontrol != $versionOld->ctcontrol) $cambios .= ',3';
                        $tipo = $this->contabilidad_model->opcionesCuentasN(0, [
                            'cuenta' => $versionOld->idctcuenta,
                            'cambios' => $cambios
                        ]);

                        
                        if ($tipo != 0) $valido = false;
                        else $valido = true;
                    } else $valido = true;

                    if (((int)$this->session->userdata('opcionAdministrador') == 1) ||
                    (int)$this->session->userdata('iduser') == 1) {
                        $valido = true;
                    }
                    
                    $data = array(
                        'descrip' => $this->input->post("titulo"),
                        'ctcontrol' => $ntcontrol,
                        'useauxi' => $nauxi,
                        'askidcentro' => $this->input->post('ccostos'),
                        'askidproyecto' => (int)$this->input->post('cproyecto'),
                        'allowed_users' => $this->input->post('users'),
                        'xpos' => $this->input->post('xpos'),
                        'notas' => $this->input->post('notas'),
                        'balview' => ($this->input->post("mostrar") == "true") ? 1 : 0,
                        'estatus' => $nestado,
                        'xpos' => $this->input->post('xpos'),
                        'notas' => $this->input->post('notas'),
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s')
                    );
                break;
            }
            if ($valido) {
                if ($this->contabilidad_model->updateCuenta($data, $ID)) {
                    $grupo = ((int)$this->input->post("all") == 8) ? 9 : (int)$this->input->post("grupo");
                    $cuentas = $this->contabilidad_model->getCuentasN($grupo);
                    $cuentasN = (((int)$this->input->post("tipo")) == 3) ? $this->contabilidad_model->getCuentasDetalleN($this->input->post("mayor")) : null;
                    $datA[] = array('valido' => true, 'datos' => $cuentas, 'details' => $cuentasN);
                } else $datA[] = array('valido' => false, 'tipo' => $tipo);
            } else $datA[] = array('valido' => false, 'tipo' => $tipo);
            echo json_encode($datA);
        }
    }

    public function updateMayoriza(){
        $this->load->model('contabilidad_model');

        $datosCuenta = $this->input->post("datosCuenta"); //Datos de la cuenta a modificar
        $mayoriza = $this->input->post("mayoriza");//idctcuenta de la cuenta que sera la mayoriza

        /*
        if($datos['tipoCuenta'] == "3"){
            $mayoriza = $this->getMayor($idCuenta);
        }else{
            $mayoriza = $idCuenta;
        }
        */
        //Validaciones varias
        $tipo = $this->contabilidad_model->opcionesCuentasN(0, [
            'cuenta' => $datosCuenta['cuenta'],
            'cambios' => ''
        ]);

        //Valida si la cuenta elegida no posee hijos
        if($tipo == 0 && $this->contabilidad_model->cuentaPoseeHijos($datosCuenta['cuenta'])){
            $tipo = 5;
        }

        //Valida si las cuentas del mayoriza existen
        if($tipo == 0){
            $arrayMayoriza = explode(",",$mayoriza);

            $cuentasNoExisten = "";
            foreach($arrayMayoriza as $num){
                if(!$this->contabilidad_model->verificarCuentaExiste($num)){
                    $cuentasNoExisten .= $num . ",";
                    $tipo = 6;
                }
            }
            if($tipo == 6){
                $cuentasNoExisten = substr($cuentasNoExisten, 0, -1);
            }
        }

        //Valida si la cuenta no se esta mayorizando a si misma
        if($tipo == 0){
            $arrayMayoriza = explode(",",$mayoriza);

            foreach($arrayMayoriza as $num){
                if($num == $datosCuenta['cuenta']){
                    $tipo = 7;
                }
            }
        }

        if($tipo == 0){
            $resultado = $this->contabilidad_model->updateMayoriza($datosCuenta['id'], $mayoriza);
            $mensaje = "La cuenta se ha modificado con exito";
        }else{
            $resultado = false;
            switch($tipo){
                case 1:
                    $mensaje = "No se puede modificar porque la cuenta está relacionada en Tipos de Partidas.";
                break;
                case 2:
                    $mensaje = "No se puede modificar porque la cuenta posee movimientos en Proceso o Actualizados.";
                break;
                case 3:
                    $mensaje = "No se puede modificar porque la cuenta está relacionada en el Asistente Contable.";
                break;
                case 4:
                    $mensaje = "No se puede modificar porque la cuenta tiene saldo pendiente.";
                break;
                case 5:
                    $mensaje = "No se puede modificar ya que la cuenta mayoriza a otra.";
                break;
                case 6:
                    $mensaje = "No se puede modificar ya que una de las cuentas ingresadas no existe: " . $cuentasNoExisten;
                break;
                case 6:
                    $mensaje = "La cuenta no puede mayorizarse a sí misma.";
                break;
            }
        }
        echo json_encode(['resultado'=>$resultado, 'mensaje'=>$mensaje]);

    }
    #   ERASE CUENTA
    public function delCuentaN()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $Codigo = $this->input->post("codigo");
            $tipo = (int)$this->input->post("tipo");
            $eliminado = $this->contabilidad_model->delCuentaN($Codigo, $tipo);
            if ($eliminado == -1) {
                $grupo = ((int)$this->input->post("all") == 8) ? 9 : (int)$this->input->post("grupo");
                $cuentas = $this->contabilidad_model->getCuentasN($grupo);
                $cuentasN = (((int)$this->input->post("tipo")) == 3) ? $this->contabilidad_model->getCuentasDetalleN($this->input->post("mayor")) : null;
                $datA[] = array('valido' => true, 'datos' => $cuentas, 'details' => $cuentasN);
            } else $datA[] = array('valido' => false, 'tipo' => $eliminado);
            echo json_encode($datA);
        }
    }
    #-------------------------------------------------------------- EXCEL MEJORA
        #   VISTA
        public function indexCuentasXN()
        {
            if($this->validatePermiso()) {
                $resultAppName = array(
                    'namePage' => 'Importación De '.$this->session->userdata('appName')
                );
                $this->session->set_userdata($resultAppName);
                $direccion = $this->uri->segment(1);
                $this->load->model('global_model');
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->load->view("mantenimiento_Cat_CuentasXN", $this->data);
            }
        }
        #   FORMATO
        public function FormatoCuentasN()
        {
            if($this->validatePermiso()) {
                require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                $objPHPExcel    =   new PHPExcel();
                $objPHPExcel->setActiveSheetIndex(0);
                $default_border = array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => substr($this->session->userdata('FHBackground'),1))
                    //'color' => array('rgb'=>'1006A3')
                );
                $style_header = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                        'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                    ),
                    'borders' => array(
                        'allborders' => $default_border,
                        /*'bottom' => $default_border,
                        'left' => $default_border,
                        'top' => $default_border,
                        'right' => $default_border,//*/
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => substr($this->session->userdata('FHBackground'),1))
                        //'color' => array('rgb'=>'E1E0F7'),
                    ),
                    'font' => array(
                        'bold' => true,
                        'color' => array('rgb' => substr($this->session->userdata('FHFontColor'),1)),
                        'size' => 9,
                        'name' => 'Arial'
                    )
                );
                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(65);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(12);
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);

                $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Cuenta');
                $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Titulo de la Cuenta');
                $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Grupo');
                $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Tipo de Cuenta');
                $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Mostrar en Balance');
                //$objPHPExcel->getActiveSheet()->getStyle("A1:H1")->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->getStyle("A1:E1")->applyFromArray( $style_header );

                $objWriter  =   new PHPExcel_Writer_Excel2007($objPHPExcel);
                header('Content-Type: application/vnd.ms-excel'); //mime type
                header('Content-Disposition: attachment;filename="Formato_Cuentas.xlsx"'); //tell browser what's the file name
                header('Cache-Control: max-age=0'); //no cache
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');  
                $objWriter->save('php://output');
            }
        }
        #   LEER FORMATO - VALIDACION
        public function LeerCuentasN()
        {
            if($this->validatePermiso()) {
                require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
                //  Read your Excel workbook
                try {
                    $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                $this->load->model('contabilidad_model');
                if ($this->contabilidad_model->CatalogoHasCuentas() == 0) {
                    $minCaracteres = $this->contabilidad_model->CantCaracteres()->valor_num;
                    //  Get worksheet dimensions
                    $objPHPExcel->setActiveSheetIndex(0); 
                    $sheet = $objPHPExcel->setActiveSheetIndex(0);
                    $highestRow = $sheet->getHighestRow(); 
                    $highestColumn = $sheet->getHighestColumn();
                    $Grupos = array(
                        'Activo' => 1,
                        'Pasivo' => 2,
                        'Patrimonio' => 3,
                        'Deudora' => 4,
                        'Acreedora' => 5,
                        'Liquidadora' => 6,
                        'Orden a favor' => 7,
                        'Orden en contra' => 8,
                    );
                    if ($highestRow > 2) {
                        #   GET ENCABEZADOS
                        $Encabezados = [];
                        for ($row = 1; $row <= 1; $row++) {
                            $rowData = $sheet->rangeToArray('A' . $row . ':E' . $row,NULL,TRUE,FALSE);
                            $rowData = $rowData[0];
                            $Encabezados[] = $rowData[0];
                            $Encabezados[] = $rowData[1];
                            $Encabezados[] = $rowData[2];
                            $Encabezados[] = $rowData[3];
                            $Encabezados[] = $rowData[4];
                        }
                        #   GET ÚLTIMA FILA
                        $final = 0;
                        for ($row = 2; $row <= $highestRow; $row++) {
                            $rowData = $sheet->rangeToArray('A' . $row . ':E' . $row,NULL,TRUE,FALSE);
                            $rowData = $rowData[0];
                            if (trim($rowData[0]) == "*** Final") {
                                $final = $row;
                                break;
                            }
                        }
                        if ($final > 0) {
                            $CountError = 0;
                            $Datos = [];
                            #   VALIDACIÓN PRINCIPAL
                            $AllCuentas = []; // line-cuenta
                            $Mayorizas = 0;
                            for ($row = 2; $row < $final; $row++) {
                                $rowData = $sheet->rangeToArray('A' . $row . ':E' . $row,NULL,TRUE,FALSE);
                                $rowData = $rowData[0];
                                $error = [];
                                
                                $cuenta = trim($rowData[0]);
                                $AllCuentas[] = $row.'-'.$cuenta;
                                $titulo = trim($rowData[1]);
                                $grupo = trim($rowData[2]);
                                $grupoT = array_search((int)$grupo, $Grupos);
                                $tipo = trim($rowData[3]);
                                $tipov = true;
                                $mostrar = trim($rowData[4]);
                                $mostrarv = true;
    
                                #   tipo
                                if (!is_numeric($tipo)) {
                                    $error[] = $Encabezados[3].'-Campo debe ser numérico';
                                    $tipov = false;
                                } else {
                                    if ((int)$tipo < 1 || (int)$tipo > 3) {
                                        $error[] = $Encabezados[3].'-Tipo de cuenta debe ser (1, 2 o 3)';
                                        $tipov = false;
                                    }
                                }
    
                                #  Titulo
                                if (strpos($titulo, '"') != false) {
                                    $error[] = $Encabezados[1].'-Campo no puede llevar comilla doble';
                                } else if (strpos($titulo, "'") != false) {
                                    $error[] = $Encabezados[1].'-Campo no puede llevar comilla simple';
                                } else if (strpos($titulo, '\\') != false) {
                                    $error[] = $Encabezados[1].'-Campo no puede llevar pleca invertida';
                                } else if (strpos($titulo, "<") != false) {
                                    $error[] = $Encabezados[1].'-Campo no puede llevar signo <';
                                } else if (strpos($titulo, ">") != false) {
                                    $error[] = $Encabezados[1].'-Campo no puede llevar signo >';
                                }
                                #   grupo
                                if ($grupoT == false) {
                                    $error[] = $Encabezados[2].'-Grupo no existe';
                                }
                                
                                #   cuenta
                                if ($cuenta == null || strlen(trim($cuenta)) == 0) {
                                    $error[] = $Encabezados[0].'-Campo es requerido, no puede ir vacío';
                                } else {
                                    if ($tipov) {
                                        switch ((int)$tipo) {
                                            case 1:
                                                if (!is_numeric($cuenta)) {
                                                    $error[] = $Encabezados[0].'-Cuenta Totalizadora debe ser numérica valor de 0 a 9';
                                                } else {
                                                    if ((int)$cuenta < 1 || (int)$cuenta > 9) {
                                                        $error[] = $Encabezados[0].'-Cuenta solo puede ser valor de 0 a 9';
                                                    }
                                                }
                                            break;
                                            case 2:
                                                $valor = preg_match("/^([1-9]){1}([0-9])+$/", $cuenta);
                                                if (!$valor) {
                                                    $error[] = $Encabezados[0].'-Cuenta Acumuladora mal escrita debe ser númerica';
                                                }
                                            break;
                                            case 3:
                                                $valor = preg_match("/^([1-9]){1}([0-9])+(R?)$/", $cuenta);
                                                if (!$valor) {
                                                    $error[] = $Encabezados[0].'-Cuenta Movimiento mal escrita';
                                                }
                                            break;
                                        }
                                    }
                                }
                                #   mostrar
                                if (!is_numeric($mostrar)) {
                                    $error[] = $Encabezados[4].'-Campo debe ser numérico (0 = No, 1 = Si)';
                                    $mostrarv = false;
                                } else {
                                    if ((int)$mostrar < 0 || (int)$mostrar > 1) {
                                        $error[] = $Encabezados[4].'-Campo debe ser (0 = No, 1 = Si)';
                                        $mostrarv = false;
                                    }
                                }
    
                                $Datos[] = array(
                                    'cuenta' => $cuenta,
                                    'titulo' => $titulo,
                                    'grupo' => ($grupoT == false) ? $grupo : $grupoT,
                                    'grupon' => (int)$grupo,
                                    'tipo' => (!$tipov) ? $tipo : (((int)$tipo == 1) ? 'Totalizadora' : (((int)$tipo == 2) ? 'Acumuladora' : 'Movimiento')),
                                    'tipon' => (int)$tipo,
                                    'mostrar' => (!$mostrarv) ? $mostrar : (((int)$mostrar == 0) ? 'No' : 'Si'),
                                    'mayor' => '',
                                    'line' => $row,
                                    'error' => implode(';', $error),
                                    'cerror' => (count($error) > 0) ? true : false,
                                );
                                if (count($error) > 0) $CountError++;
                            }
                            #   VALIDACION SECUNDARIA
                            $DatosB = [];
                            for ($i=0; $i < 8; $i++) { 
                                $Total[] = 0;
                            }
                            foreach ($Datos as $dato) {
                                #   CUENTA REPETIDA
                                $conteo = 0;
                                $fila = 0;
                                foreach ($AllCuentas as $cuenta) {
                                    $vcomparar = explode('-', $cuenta);
                                    if ($vcomparar[1] == $dato['cuenta'] && (int)$vcomparar[0] != (int)$dato['line']) {
                                        $conteo++;
                                        $fila = $vcomparar[0];
                                    }
                                }
                                if ($conteo > 0) {
                                    $error = (strlen($dato['error']) > 0) ? explode(';', $dato['error']) : [];
                                    $error[] = 'Cuenta viene repetida en la línea '.$fila;
                                    $dato['error'] = implode(';', $error);
                                    $dato['cerror'] = (count($error) > 0) ? true : false;
                                    if (count($error) > 0) $CountError++;
                                }
                                if ($dato['tipon'] == 1) {
                                    $Total[$dato['grupon'] - 1]++;
                                }
                                $DatosB[] = $dato;
                            }
                            $Datos = $DatosB;
                            #   VALIDACION DE 3° NIVEL
                            if ($CountError == 0) {
                                $DatosC = [];
                                foreach ($Datos as $dato) {
                                    if ($dato['tipon'] == 1 && $Total[$dato['grupon'] -1] > 1) {
                                        $error = (strlen($dato['error']) > 0) ? explode(';', $dato['error']) : [];
                                        $error[] = 'Cuenta Totalizadora viene repetida en el mismo grupo '.$dato['grupo'];
                                        $dato['error'] = implode(';', $error);
                                        $dato['cerror'] = (count($error) > 0) ? true : false;
                                        if (count($error) > 0) $CountError++;
                                    }
                                    $DatosC[] = $dato;
                                }
                                $Datos = $DatosC;
                            }

                            #   GENERANDO MAYORIZAS
                            $sen = 0;
                            if ($CountError == 0) {
                                $sen = 1;
                                #   CONSEGUIR EL CATALOGO
                                # 1 - Activo
                                # 2 - Pasivo
                                # 3 - Patrimonio
                                # 4 - Deudora
                                # 5 - Acreedora
                                # 6 - Liquidadora
                                # 7 - O. favor
                                # 8 - O. contra
                                $Catalogo = [];
                                for ($i=0; $i < 8; $i++) { 
                                    $Catalogo[] = array(
                                        'padre' => '',
                                        'all' => []
                                    );
                                }
                                foreach ($Datos as $dato) {
                                    if ($dato['tipon'] != 1) {
                                        $Catalogo[$dato['grupon'] - 1]['all'][] = array(
                                            'cuenta' => $dato['cuenta'],
                                            'tipo' => $dato['tipon'],
                                            'padre' => $Catalogo[$dato['grupon'] - 1]['padre']
                                        );   
                                    } else {
                                        $Catalogo[$dato['grupon'] - 1]['padre'] = $dato['cuenta'];
                                    }
                                }
                                #   GET MAYORIZA
                                for ($i=0; $i < count($Catalogo); $i++) { 
                                    $Catalogo[$i]['all'] = $this->getLPadre($Catalogo[$i]['all'], $Catalogo[$i]['padre']);
                                }
                                #   ASIGNAR MAYORIZA
                                $DatosB = [];
                                foreach ($Datos as $dato) {
                                    foreach ($Catalogo[$dato['grupon'] - 1]['all'] as $cata) {
                                        if ($dato['cuenta'] == $cata['cuenta']) {
                                            $dato['mayor'] = $cata['padre'];
                                            $Mayorizas++;
                                            break;
                                        }
                                    }
                                    $DatosB[] = $dato;
                                }
                                $Datos = $DatosB;//*/
                            }

                            if ($sen == 1) {
                                if ($Mayorizas == 0) $CountError++;
                                $datA[] = array('valido' => (($CountError == 0) ? true : false), 'datos' => $Datos, 'tipo' => 2);
                            } else $datA[] = array('valido' => (($CountError == 0) ? true : false), 'datos' => $Datos, 'tipo' => 1);
                        } else $datA[] = array('valido' => false, 'tipo' => -2);
                    } else $datA[] = array('valido' => false, 'tipo' => 0);
                } else $datA[] = array('valido' => false, 'tipo' => -1);
                echo json_encode($datA);
                #-
            }
        }
        #   OBTENER EL ULTIMO PADRE DE CADA CUENTA
        private function getLPadre($all, $Origin)
        {
            $cuentas1 = $all;
            $cuentas2 = $all;
            foreach ($cuentas1 as $valor1) {
                foreach ($cuentas2 as $key => $valor2) {
                    if (strlen($valor1['cuenta']) < strlen($valor2['cuenta'])) {
                        $star = substr($valor2['cuenta'], 0, strlen($valor1['cuenta'])) == $valor1['cuenta'];
                        if ($star) {
                            $add = false;
                            if ($valor2['tipo'] == 3) {
                                if ($valor1['tipo'] != 3) $add = true;
                            } else {
                                if ($valor1['tipo'] != 3) $add = true;
                            }
                            if ($add) $cuentas2[$key]['padre'] = $valor1['cuenta'];
                        }
                    }
                }
            }
            #   FORMATEAR (only de Movimiento)
            $alls1 = $cuentas2;
            $alls2 = $cuentas2;
            $allB = [];
            foreach ($alls1 as $valor1) {
                if ($valor1['tipo'] == 3) {
                    $padre = [];
                    $padre[] = $valor1['padre'];
                    $padreaActual = $valor1['padre'];
                    do {
                        $cambio = 0;
                        foreach ($alls2 as $valor2) {
                            if ($valor2['cuenta'] == $padreaActual && $valor2['tipo'] != 3) {
                                $padre[] = $valor2['padre'];
                                $cambio = ($valor2['padre'] == $Origin) ? 0 : 1;
                                $padreaActual = $valor2['padre'];
                                break;
                            }
                        }
                    } while ($cambio == 1);
                    $valor1['padre'] = implode(",", $padre);
                }
                $allB[] = $valor1;
            }
            return $allB;
        }
        #   IMPORTAR CATALOGO
        public function ExcelCuentasN()
        {
            if($this->validatePermiso()) {
                require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
                //  Read your Excel workbook
                try {
                    $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                //  Get worksheet dimensions
                $objPHPExcel->setActiveSheetIndex(0); 
                $sheet = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();
                #   PROCESAR
                #   GET LAST FILA
                $final = 0;
                $Datos = [];
                for ($row = 2; $row <= $highestRow; $row++) {
                    $rowData = $sheet->rangeToArray('A' . $row . ':E' . $row,NULL,TRUE,FALSE);
                    $rowData = $rowData[0];
                    if (trim($rowData[0]) == "*** Final") {
                        $final = $row;
                        break;
                    }
                }
                for ($row = 2; $row < $final; $row++) {
                    $rowData = $sheet->rangeToArray('A' . $row . ':E' . $row,NULL,TRUE,FALSE);
                    $rowData = $rowData[0];

                    $cuenta = trim($rowData[0]);
                    $titulo = trim($rowData[1]);
                    $grupo = (int)trim($rowData[2]);
                    $tipo = (int)trim($rowData[3]);
                    $mostrar = (int)trim($rowData[4]);
                    $Datos[] = array(
                        'cuenta' => $cuenta,
                        'titulo' => $titulo,
                        'grupo' => $grupo,
                        'tipo' => $tipo,
                        'mostrar' => $mostrar,
                        'mayor' => '',
                    );
                }
                #   CONSEGUIR EL CATALOGO
                # 1 - Activo
                # 2 - Pasivo
                # 3 - Patrimonio
                # 4 - Deudora
                # 5 - Acreedora
                # 6 - Liquidadora
                # 7 - O. favor
                # 8 - O. contra
                $Catalogo = [];
                for ($i=0; $i < 8; $i++) { 
                    $Catalogo[] = array(
                        'padre' => '',
                        'all' => []
                    );
                }
                foreach ($Datos as $dato) {
                    if ($dato['tipo'] != 1) {
                        $Catalogo[$dato['grupo'] - 1]['all'][] = array(
                            'cuenta' => $dato['cuenta'],
                            'tipo' => $dato['tipo'],
                            'padre' => $Catalogo[$dato['grupo'] - 1]['padre']
                        );   
                    } else {
                        $Catalogo[$dato['grupo'] - 1]['padre'] = $dato['cuenta'];
                    }
                }
                #   GET MAYORIZA
                for ($i=0; $i < count($Catalogo); $i++) { 
                    $Catalogo[$i]['all'] = $this->getLPadre($Catalogo[$i]['all'], $Catalogo[$i]['padre']);
                }
                #   ASIGNAR MAYORIZA
                $DatosB = [];
                foreach ($Datos as $dato) {
                    foreach ($Catalogo[$dato['grupo'] - 1]['all'] as $cata) {
                        if ($dato['cuenta'] == $cata['cuenta']) {
                            $dato['mayor'] = $cata['padre'];
                            break;
                        }
                    }
                    $DatosB[] = $dato;
                }
                $Datos = $DatosB;
                $error = [];
                $conteo = 0;
                foreach ($Datos as $dato) {
                    $data = array(
                        'idctcuenta' => $dato['cuenta'],
                        'descrip' => $dato['titulo'],
                        'tipocuenta' => $dato['tipo'],
                        'ctmayoriza' => $dato['mayor'],
                        'catgrupo' => $dato['grupo'],
                        'ctcontrol' => 0,
                        'useauxi' => '',
                        'askidcentro' => '',
                        'askidproyecto' => '',
                        'allowed_users' => '',
                        'balview' => $dato['mostrar'],
                        'xpos' => '',
                        'estatus' => 1,
                        'notas' => '',
                        'whodidit' => $this->session->userdata('iduser'), 
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
                    //print_r($data);
                    if(!$this->contabilidad_model->setCuenta($data)){
                        $conteo++;
                        $error[] = $dato['cuenta'];
                    }//*/
                }
                echo json_encode(array(
                    'valido' => ($conteo > 0) ? false : true,
                    'error' => implode('-', $error)
                ));
                #-
            }
        }
    #-
    #-------------------------------------------------------------- MIGRACION CUENTA
        public function indexMigracionCuentas($idApp)
        {
            if($this->validatePermiso()) {
                $this->load->model('global_model');
                $this->load->model('configuracion_model');
                $this->load->model('contabilidad_model');
                //$this->multiplesContabilidad(12, 'ctcuenta');
                $this->iniciarUReportes();
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $direccion = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
                $this->data['TAuxiliares'] = $this->multiplesContabilidad(6);
                $this->data['CatGrupos'] = $this->Grupos;

                $this->contabilidad_model->multiOpcionesMigracionCC(2, $this->multiplesContabilidad(4));
                $this->load->view("mantenimiento_Cat_Cuentas_Migracion", $this->data);
            }
        }
        #   MULTIOPCIONES MIGRACION
        public function multiOpcionesMigracionCC()
        {
            if($this->validatePermiso()) {
                $this->load->model('contabilidad_model');
                $opcion = (int)$this->input->post('opcion');
                switch ($opcion) {
                    case -3:#   GET LOS ULTIMOS 2 REGISTROS AUX - USADOS
                        $datos = $this->contabilidad_model->multiOpcionesMigracionCC(6, $this->multiplesContabilidad(4));
                        if ($datos->num_rows() > 0) {
                            $Datos = array_map(function ($o) {return $o->useauxi;}, (array)$datos->result());
                            $datA[] = array('valido' => true, 'datos' => implode(";", $Datos));
                        } else $datA[] = array('valido' => true, 'datos' => '');
                    break;
                    case -2:#   VALIDACION INICIO
                        $Datos = $this->conversionMigracion(1, 1);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case -1:#   LEET TXT
                        $datos = $this->contabilidad_model->multiOpcionesMigracionCC(1, [
                            'tabla' => 'ctcuenta',
                            'tipo' => 1
                        ]);
                        if ($datos->num_rows() == 0) {
                            $datos = $this->contabilidad_model->multiOpcionesMigracionCC(1, [
                                'tabla' => $this->multiplesContabilidad(4),
                                'tipo' => 2
                            ]);
                            $valido = ($datos === true) ? true : (($datos->num_rows() == 0) ? true : false);
                            if ($valido) {
                                #   TXT
                                    $registros = trim($this->input->post("registros"));
                                    $registros = explode("\n", $registros);
                                    if (count($registros) > 0) {
                                        $conteo = 0;
                                        foreach ($registros as $registro) {
                                            $registro = explode(";", trim($registro));
                                            $data = array(
                                                'idctcuenta' => trim($registro[0]),
                                                'descrip' => trim($registro[1]),
                                                'ctmayoriza' => '',
                                                'catgrupo' => 0,
                                                'ctcontrol' => 0,
                                                'useauxi' => '',
                                                'askidcentro' => '',
                                                'askidproyecto' => '',
                                                'xpos' => '',
                                                'estatus' => 0,
                                                'notas' => '',
                                                'balview' => 0,
                                                'allowed_users' => '',
                                                'whodidit' => $this->session->userdata('iduser'), 
                                                'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                            );
                                            if (!$this->multiplesContabilidad(8, ['tabla' => $this->multiplesContabilidad(4), 'data' => $data])) $conteo++;
                                        }
                                        $Datos = $this->conversionMigracion(1, 1);
                                        $datA[] = array('valido' => true, 'datos' => $Datos, 'conteo' => $conteo);
                                    } else $datA[] = array('valido' => false, 'tipo' => 3);
                                #-
                            } else $datA[] = array('valido' => false, 'tipo' => 2);
                        } else $datA[] = array('valido' => false, 'tipo' => 1);
                    break;
                    case 1:#   LECTURA CUENTAS
                        $datos = $this->contabilidad_model->multiOpcionesMigracionCC(1, [
                            'tabla' => 'ctcuenta',
                            'tipo' => 1
                        ]);
                        if ($datos->num_rows() == 0) {
                            $datos = $this->contabilidad_model->multiOpcionesMigracionCC(1, [
                                'tabla' => $this->multiplesContabilidad(4),
                                'tipo' => 2
                            ]);
                            $valido = ($datos === true) ? true : (($datos->num_rows() == 0) ? true : false);
                            if ($valido) {
                                #-  EXCEL
                                    require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
                                    //  Read your Excel workbook
                                    try {
                                        $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                                        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                                        $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);
                                    } catch(Exception $e) {
                                        die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                                    }
                                    //  Get worksheet dimensions
                                    $objPHPExcel->setActiveSheetIndex(0); 
                                    $sheet = $objPHPExcel->setActiveSheetIndex(0);
                                    $highestRow = $sheet->getHighestRow(); 
                                    $highestColumn = $sheet->getHighestColumn();
                                    if ($highestRow > 2) {
                                        #   GET ÚLTIMA FILA
                                        $final = 0;
                                        for ($row = 2; $row <= $highestRow; $row++) {
                                            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn. $row,NULL,TRUE,FALSE);
                                            $rowData = $rowData[0];
                                            if (substr(trim($rowData[0]), 0, 3) === "***") {
                                                $final = $row;
                                                break;
                                            }
                                        }
                                        if ($final > 2) {
                                            #   LECTURA
                                                date_default_timezone_set('America/El_Salvador');
                                                $conteo = 0;
                                                for ($row = 2; $row < $final; $row++) {
                                                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn. $row,NULL,TRUE,FALSE);
                                                    $rowData = $rowData[0];
                                                    $cuenta = trim($rowData[0]);
                                                    $titulo = trim($rowData[1]);
                                                    $data = array(
                                                        'idctcuenta' => $cuenta,
                                                        'descrip' => $titulo,
                                                        'ctmayoriza' => '',
                                                        'catgrupo' => 0,
                                                        'ctcontrol' => 0,
                                                        'useauxi' => '',
                                                        'askidcentro' => '',
                                                        'askidproyecto' => '',
                                                        'xpos' => '',
                                                        'estatus' => 0,
                                                        'notas' => '',
                                                        'balview' => 0,
                                                        'allowed_users' => '',
                                                        'whodidit' => $this->session->userdata('iduser'), 
                                                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                                    );
                                                    if (!$this->multiplesContabilidad(8, ['tabla' => $this->multiplesContabilidad(4), 'data' => $data])) $conteo++;
                                                }
                                                $Datos = $this->conversionMigracion(1, 1);
                                                $datA[] = array('valido' => true, 'datos' => $Datos, 'conteo' => $conteo);
                                            #-
                                        } else $datA[] = array('valido' => false, 'tipo' => 4);
                                    } else $datA[] = array('valido' => false, 'tipo' => 3);
                                #-
                            } else $datA[] = array('valido' => false, 'tipo' => 2);
                        } else $datA[] = array('valido' => false, 'tipo' => 1);
                    break;
                    case 2:#   GET DATA
                        $Tipos = array_map(function($o, $key) {return array('ID' => $o, 'Name' => $key);}, $this->TiposCuentas, array_keys($this->TiposCuentas));
                        $multi = (int)$this->input->post('multi');
                        if ($multi != 0) $datA[] = array('valido' => true,'tipos' => $Tipos);
                        else {
                            $Centros = $this->multiplesContabilidad(5);
                            $TAuxiliares = $this->multiplesContabilidad(6);
                            $datA[] = array(
                                'valido' => true,
                                'centros' => $Centros,
                                'tipos' => $Tipos,
                                'grupos' => array_map(function($o) {$dis = ($o['ID'] == count($this->Grupos)) ? true : false; return array('ID' => $o['ID'], 'Name' => $o['text'], 'disabled' => $dis, 'visible' => !$dis);}, $this->Grupos),
                                'tiposcontroles' => $this->TControles,
                                'tiposauxiliares' => $TAuxiliares,
                                //'cantidad' => (int)$this->multiplesContabilidad(7, ['campo' => 'nombre', 'valor' => 'conta_maxcta'])->valor_num
                            );
                        }
                    break;
                    case 3:#   SET-UDPATE MIGRACION
                        $ID = (int)$this->input->post('ID');
                        $status = trim($this->input->post('estado'));
                        $status = (strlen($status) > 0) ? ((int)$status) : 1;
                        date_default_timezone_set('America/El_Salvador');
                        $data = array(
                            'idctcuenta' => $this->input->post('cuenta'),
                            'descrip' => $this->input->post('titulo'),
                            'tipocuenta' => (int)$this->input->post('tipo'),
                            'catgrupo' => (int)$this->input->post('grupo'),
                            'ctcontrol' => (int)$this->input->post('control'),
                            'useauxi' => $this->input->post('auxiliar'),
                            'askidcentro' => $this->input->post('usecentro'),
                            'balview' => (int)$this->input->post('mostrar'),
                            'estatus' => $status,
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        if ($ID == 0) {
                            unset($data['modifica']);
                            $data['ingresa'] = date_create()->format('Y-m-d H:i:s');
                            $proceso = $this->multiplesContabilidad(8, ['tabla' => $this->multiplesContabilidad(4), 'data' => $data]);
                        } else {
                            $proceso = $this->multiplesContabilidad(10, ['campo' => 'idrec', 'valor' => (int)$ID, 'data' => $data, 'tabla' => $this->multiplesContabilidad(4)]);
                        }
                        if ($proceso) {
                            $Datos = $this->conversionMigracion(1, 1);
                            $datA[] = array('valido' => true, 'datos' => $Datos);
                        } else $datA[] = array('valido' => false, 'texerror' => (($ID == 0) ? 'Error al Ingresar' : 'Error al Actualizar'));
                    break;
                    case 4:#   DELETE CUENTA
                        $ID = (int)$this->input->post('ID');
                        $this->multiplesContabilidad(11, ['campo' => 'idrec', 'valor' => (int)$ID, 'tabla' => $this->multiplesContabilidad(4)]);
                        $Datos = $this->conversionMigracion(1, 1);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case 5:#   BORRAR REGISTROS DE MIGRACION
                        $this->multiplesContabilidad(12, $this->multiplesContabilidad(4));
                        $Datos = $this->conversionMigracion(1, 1);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    case 6:#   CAMBIAR CUENTA A AUXILIAR
                        $ID = (int)$this->input->post('ID');
                        $data = array(
                            'tipocuenta' => 0,
                            'catgrupo' => 0,
                            'ctcontrol' => 0,
                            'useauxi' => '',
                            'askidcentro' => '',
                            'balview' => 0,
                            'estatus' => 3,
                            'useauxi' => trim($this->input->post('auxiliar')),
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        if ($this->multiplesContabilidad(10, ['campo' => 'idrec', 'valor' => (int)$ID, 'data' => $data, 'tabla' => $this->multiplesContabilidad(4)])) {
                            $Datos = $this->conversionMigracion(1, 1);
                            $datA[] = array('valido' => true, 'datos' => $Datos);
                        } else $datA[] = array('valido' => false);
                    break;
                    case 7:#   CAMBIAR CUENTAS A AUXILIAR
                        $cuentas = explode(",", trim($this->input->post('ctas')));
                        $conteo = 0;
                        foreach ($cuentas as $cuenta) {
                            $data = array(
                                'tipocuenta' => 0,
                                'catgrupo' => 0,
                                'ctcontrol' => 0,
                                'useauxi' => '',
                                'askidcentro' => '',
                                'balview' => 0,
                                'estatus' => 3,
                                'useauxi' => trim($this->input->post('auxiliar')),
                                'whodidit' => $this->session->userdata('iduser'),
                                'modifica' => date_create()->format('Y-m-d H:i:s'),
                            );
                            if (!$this->multiplesContabilidad(10, ['campo' => 'idrec', 'valor' => (int)$cuenta, 'data' => $data, 
                                'tabla' => $this->multiplesContabilidad(4)
                            ])) $conteo++;
                        }
                        if ($conteo == 0) {
                            $Datos = $this->conversionMigracion(1, 1);
                            $datA[] = array('valido' => true, 'datos' => $Datos);
                        } else $datA[] = array('valido' => false);
                    break;
                    case 8:#   GET ID CONTRA
                        $contra = $this->conversionMigracion(2, 2);
                        $datA[] = array('valido' => true, 'id' => $contra);
                    break;
                    case 9:#   PROCESOS DE MIGRACION
                        $contra = $this->conversionMigracion(2, 1);
                        $comparar = trim($this->input->post('pass'));
                        if ($contra == $comparar) {
                            $datos = $this->contabilidad_model->multiOpcionesMigracionCC(1, [
                                'tabla' => $this->multiplesContabilidad(4),
                                'tipo' => 2
                            ]);
                            $setvalido = true;
                            if ($datos !== true) {
                                if ($datos->num_rows() > 0) {
                                    $datos = $this->contabilidad_model->multiOpcionesMigracionCC(4, $this->multiplesContabilidad(4));
                                    if ($datos->num_rows() > 0) {
                                        foreach ($datos->result() as $dato) {
                                            $dato->idrec = 0;
                                            $dato->estatus = 1;
                                            $data = (array)$dato;
                                            if ($setvalido) $this->multiplesContabilidad(8, ['tabla' => 'ctcuenta', 'data' => $data]);
                                        }
                                    }
                                    $datos = $this->contabilidad_model->multiOpcionesMigracionCC(5, $this->multiplesContabilidad(4));
                                    if ($datos->num_rows() > 0) {
                                        foreach ($datos->result() as $dato) {
                                            $separacion = explode(",", $dato->useauxi);
                                            $idtabla = (int)$separacion[0];
                                            if ($idtabla == 1) {
                                                $data = array(
                                                    'descrip' => $dato->descrip,
                                                    'idauxidef' => (int)$separacion[1],
                                                    'estado' => 1,
                                                    'notas' => '',
                                                    'whodidit' => $this->session->userdata('iduser'), 
                                                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                                );
                                            } else {
                                                /*$data = array(
                                                    'descrip' => $dato->descrip,
                                                    'tipo' => (int)$separacion[1],
                                                    'estado' => 1,
                                                    'notas' => '',
                                                    'whodidit' => $this->session->userdata('iduser'), 
                                                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                                                );//*/
                                            }
                                            if (!$this->contabilidad_model->multiOpcionesMigracionCC(8, ['descrip' => $dato->descrip, 'idaux' => (int)$separacion[1]])) {
                                                if ($setvalido) $this->multiplesContabilidad(8, ['tabla' => 'ctauxi', 'data' => $data]);
                                            }
                                        }
                                    }
                                }
                            }
                            $Datos = $this->conversionMigracion(1, 1);
                            $datA[] = array('valido' => true, 'datos' => $Datos);
                        } else $datA[] = array('valido' => false, /*'d' => $contra.'-123@'//*/);
                    break;
                    case 10:#   REGLA DE ASIGNACION
                        $ancho = (int)$this->input->post('a');
                        $tipo = (int)$this->input->post('t');
                        $datos = $this->contabilidad_model->multiOpcionesMigracionCC(7, ['a' => $ancho, 't' => $this->multiplesContabilidad(4)]);
                        if ($datos->num_rows() > 0) {
                            $Grupos = array_filter($this->Grupos, function ($o) {return $o['ID'] != count($this->Grupos);});
                            foreach ($datos->result() as $dato) {
                                $gfound = array_search((int)$dato->idctcuenta[0], array_column($Grupos, 'ID'));
                                if ($gfound !== false) {
                                    $data = array(
                                        'ctcontrol' => 0,
                                        'useauxi' => '',
                                        'askidcentro' => '',
                                        'catgrupo' => $Grupos[$gfound]['ID'],
                                        'tipocuenta' => $tipo,
                                        'estatus' => 1,
                                        'whodidit' => $this->session->userdata('iduser'),
                                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                                    );
                                    //print_r($data);
                                    $this->multiplesContabilidad(10, ['campo' => 'idrec', 'valor' => (int)$dato->idrec, 'data' => $data, 'tabla' => $this->multiplesContabilidad(4)]);
                                }
                            }
                        }
                        $Datos = $this->conversionMigracion(1, 1);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    break;
                    default:$datA[] = array('valido' => false);break;
                }
                echo json_encode($datA);
            }
        }
        private function conversionMigracion($opc, $extra = null)
        {
            $Datos = [];
            switch ($opc) {
                #   CONVERSION DE DATOS MIGRACION
                case 1:
                    #   MIGRACION ENABLED
                    $datosO = $this->contabilidad_model->multiOpcionesMigracionCC(1, [
                        'tabla' => 'ctcuenta',
                        'tipo' => 1
                    ]);
                    $validoM = ($datosO->num_rows() == 0) ? true : false;

                    $datos = $this->contabilidad_model->multiOpcionesMigracionCC(1, [
                        'tabla' => $this->multiplesContabilidad(4),
                        'tipo' => 2
                    ]);
                    if ($datos !== true) {
                        if ($datos->num_rows() > 0) {
                            $conteoError = 0;
                            #   VALIDACION 1° NIVEL
                            $Grupos = array_filter($this->Grupos, function ($o) { return $o['ID'] != count($this->Grupos);});
                            foreach ($datos->result() as $dato) {
                                $error = [];
                                $etemp = [];

                                if (strpos(trim($dato->descrip), '"') != false) {
                                    $error[] = 'Titulo no puede llevar comilla doble';
                                } else if (strpos(trim($dato->descrip), "'") != false) {
                                    $error[] = 'Titulo no puede llevar comilla simple';
                                } else if (strpos(trim($dato->descrip), '\\') != false) {
                                    $error[] = 'Titulo no puede llevar pleca invertida';
                                } else if (strpos(trim($dato->descrip), "<") != false) {
                                    $error[] = 'Titulo no puede llevar signo <';
                                } else if (strpos(trim($dato->descrip), ">") != false) {
                                    $error[] = 'Titulo no puede llevar signo >';
                                }
                                $etemp = $error;

                                $tipo = array_search($dato->tipocuenta, $this->TiposCuentas);
                                if ($tipo === false) $error[] = 'Tipo de Cuenta no válido';

                                $grupo = array_search($dato->catgrupo, array_column($Grupos, 'ID', 'text'));
                                if ($grupo === false) $error[] = 'Grupo no válido';

                                if ($tipo !== false) {
                                    if (trim($dato->idctcuenta) == 0) $error[] = 'Código cuenta no puede ir vacío';
                                    else {
                                        switch ($dato->tipocuenta) {
                                            case 1:
                                                if (!is_numeric($dato->idctcuenta)) {
                                                    $error[] = 'Cuenta Totalizadora debe ser numérica valor de 0 a 9';
                                                } else {
                                                    if ((int)$dato->idctcuenta < 1 || (int)$dato->idctcuenta > 9) {
                                                        $error[] = 'Cuenta solo puede ser valor de 0 a 9';
                                                    }
                                                }
                                            break;
                                            case 2:
                                                $valor = preg_match("/^([1-9]){1}([0-9])+$/", $dato->idctcuenta);
                                                if (!$valor) $error[] = 'Cuenta Acumuladora mal escrita debe ser númerica';
                                            break;
                                            case 3:
                                                $valor = preg_match("/^([1-9]){1}([0-9])+(R?)$/", $dato->idctcuenta);
                                                if (!$valor) $error[] = 'Cuenta Movimiento mal escrita';
                                            break;
                                        }
                                    }
                                }

                                if ($dato->estatus == 3) $error = $etemp;
                                switch ($dato->tipocuenta) {
                                    case 1:
                                        $bcolor = '#5578aa';//339933
                                    break;
                                    case 2:
                                        $bcolor = '#899dc2';//5fb95f
                                    break;
                                    case 3:
                                        $bcolor = '#abbad4';//83c983
                                    break;
                                    default:
                                        $bcolor = '';
                                        if ($dato->estatus == 3) $bcolor = '#cdd6e5';//'#a6d8a6';
                                    break;
                                }

                                $Datos[] = array(
                                    'key' => $dato->idrec,
                                    'cuenta' => ($dato->estatus != 3) ? trim($dato->idctcuenta) : '',
                                    'ancho' => strlen(trim($dato->idctcuenta)),
                                    'titulo' => trim($dato->descrip),
                                    'idtipo' => $dato->tipocuenta,
                                    'tipo' => ($tipo === false) ? '' : $tipo,
                                    'idgrupo' => $dato->catgrupo,
                                    'grupo' => ($grupo === false) ? '' : $grupo,
                                    'bcolor' => $bcolor,

                                    'idcontrol' => $dato->ctcontrol,
                                    'usecentro' => trim($dato->askidcentro),
                                    'idauxiliar' => trim($dato->useauxi),
                                    'mostrar' => $dato->balview,
                                    'estado' => $dato->estatus,
                                    'error' => implode(',', $error),
                                    'auxiliar' => $dato->auxi
                                );
                                if (count($error) > 0) $conteoError++;
                            }
                            //usort($Datos, function($a, $b) {return strcmp($a['cuenta'], $b['cuenta']);});
                            #   VALIDACION 2° NIVEL
                            $cuentasM = array_filter($Datos, function ($o) {return $o['estado'] != 3;});
                            if (count($cuentasM) > 0) {
                                $cuentas = array_map(function ($o) {return $o['cuenta'];}, $cuentasM);
                                $d = array_count_values($cuentas);
                                foreach ($cuentasM as $dato) {
                                    $error = (strlen(trim($dato['error'])) > 0) ? explode(',', $dato['error']) : [];
                                    if ($d[$dato['cuenta']] > 1) $error[] = 'Cuenta Repetida';
    
                                    $key = array_search($dato['key'], array_column($Datos, 'key'));
                                    $Datos[$key]['error'] = implode(',', $error);
                                    if (count($error) > 0) $conteoError++;
                                }
                            }
                            #   VALIDACION DE 3° NIVEL
                            foreach ($Grupos as $grupo) {
                                $grupos = $grupo['ID'];
                                $countGrupos = array_values(array_filter($cuentasM, function ($o) use ($grupos) {return $o['idgrupo'] == $grupos;}));
                                if (count($countGrupos) > 0) {
                                    $cuenta = $countGrupos[0];
                                    $error = (strlen(trim($cuenta['error'])) > 0) ? explode(',', $cuenta['error']) : [];
                                    $countTiposGrupos = array_filter($cuentasM, function ($o) use ($grupos) {return (($o['idgrupo'] == $grupos) && ($o['idtipo'] == 1));});
                                    if (count($countTiposGrupos) == 0) $error[] = 'Cuenta Totalizadora no existe para el Grupo '.$grupo['text'];    
                                    else if (count($countTiposGrupos) > 1) $error[] = 'Cuenta Totalizadora Repetida; debe ser única';

                                    $key = array_search($cuenta['key'], array_column($Datos, 'key'));
                                    $Datos[$key]['error'] = implode(',', $error);
                                    if (count($error) > 0) $conteoError++;
                                }
                            }
                            #   ASIGNACION DE ESTADO
                            $Datos = array_map(function ($o) {$o['estatu'] = ($o['estado'] == 0) ? 'Pendiente' : ((strlen($o['error']) > 0) ? 'Error' : 'Procesada'); return $o;}, $Datos);
                            $Datos = array('datos' => $Datos, 'migracion' => $validoM);
                            #   GENERACION DE MAYORIZAS
                            if ($extra == 2) {
                                if ($conteoError == 0) {
                                    if (count($cuentasM) > 0) {
                                        #   CREAANDO CATALOGO
                                        $Catalogo = [];
                                        foreach ($Grupos as $grupo) {
                                            $grupos = $grupo['ID'];
                                            $primer = array_values(array_filter($cuentasM, function ($o) use ($grupos) {return (($o['idgrupo'] == $grupos) && ($o['idtipo'] == 1));}));
                                            if (count($primer) == 1) {
                                                $padre = $primer[0]['cuenta'];
                                                $all = array_values(array_filter($cuentasM, function ($o) use ($grupos) {return (($o['idgrupo'] == $grupos) && ($o['idtipo'] != 1));}));
                                                $all = array_map(function($o) use ($padre) {return array('cuenta' => $o['cuenta'], 'tipo' => $o['idtipo'], 'padre' => $padre);}, $all);
                                                $Catalogo[$grupo['ID']] = array(
                                                    'padre' => $padre,
                                                    'all' => $all
                                                );
                                            }
                                        }
                                        #   GET-SET MAYORIZA
                                        foreach ($Catalogo as $key => $catalogo) {
                                            $Catalogo[$key]['all'] = $this->getLPadre($catalogo['all'], $catalogo['padre']);
                                        }
                                        foreach ($Catalogo as $catalogo) {
                                            foreach ($catalogo['all'] as $cuenta) {
                                                $data = array(
                                                    'ctmayoriza' => $cuenta['padre'],
                                                    'whodidit' => $this->session->userdata('iduser'),
                                                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                                                );
                                                $this->contabilidad_model->multiplesContabilidad(4, [
                                                    'campo' => 'idctcuenta', 'valor' => $cuenta['cuenta'],
                                                    'tabla' => $this->multiplesContabilidad(4), 'data' => $data
                                                ]);
                                            }
                                        }
                                    }
                                }
                                $Datos = (object)array('datos' => $Datos, 'valido' => (($conteoError > 0) ? false : true));
                            }
                        } else $Datos = array('datos' => $Datos, 'migracion' => $validoM);
                    } else $Datos = array('datos' => $Datos, 'migracion' => $validoM);
                break;
                #   GET CONTRA
                case 2:
                    $contra = $this->multiplesContabilidad(7, ['campo' => 'nombre', 'valor' => 'rf_clave01']);
                    if ($extra == 1) {
                        if (count((array)$contra) > 0) $contra = trim($contra->valor_txt);
                        else $contra = trim($this->session->userdata('iduser').'-'.$this->session->userdata('idaccount'));
                    } else {
                        if (count((array)$contra) > 0) $contra = (int)$contra->idrnum;
                        else $contra = 0;
                    }
                    $Datos = $contra;
                break;
            }
            return $Datos;
        }
        #   VALIDAR EJECUTAR MIGRACION
        public function validaMigracion()
        {
            if($this->validatePermiso()) {
                $this->load->model('contabilidad_model');
                $Datos = $this->conversionMigracion(1, 2);
                if (count((array)$Datos->datos) > 0) $datA[] = array('valido' => $Datos->valido, 'datos' => $Datos->datos, 'tipo' => 2);
                else $datA[] = array('valido' => false, 'tipo' => 1);//*/
                echo json_encode($datA);
            }
        }
    #-
    private function getMayor($mayor)
    {
        $texto[] = $mayor;
        $i = 0;
        do {
            $dato = $this->contabilidad_model->getInfoPadre($mayor);
            $valorM = explode(',', $dato->ctmayoriza)[0];
            $mayor = $valorM;
            //print_r($dato);
            $i++;
            if($dato->tipocuenta != 1) $texto[] = $valorM;
            if ($i == 100) {
                break;
            }
        } while ($dato->tipocuenta != 1);//*/
        //die();
        return implode(",", $texto);
    }
    #------------------------------------------------------     FIN CATALOGO DE CUENTAS MEJORA ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------VERIFCACION
    #   VERIFICAR MAYORIZAS
    public function VerificarMayor()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $grupo = (int)$this->input->post("grupo") + 1;
                echo json_encode($this->MayorizaError($grupo));
            } else show_404();
        }
    }
    private function MayorizaError($grupo)
    {
        $Datos = null;
        $conteo = 0;
        $malos = 0;
        $cuentas = $this->contabilidad_model->getCuentasG($grupo);
        if($cuentas->num_rows() > 0) {
            $conteo++;
            foreach($cuentas->result() as $dato) {
                $valor = '';
                $error = "";
                $mayor = explode(",", $dato->ctmayoriza)[0];

                if($dato->tipocuenta == 1){
                    if(strlen($dato->ctmayoriza) > 0) $error = 'No debe tener mayoriza';
                }else{
                    if(($dato->tipocuenta == 2) && (!preg_match('/^([1-9]){1}([0-9]?)+$/', $dato->ctmayoriza))){
                        $error = 'Mayoriza debe ser solo númerico ('.$dato->ctmayoriza.')';
                    }else{
                        $valormayor = ($dato->tipocuenta == 2) ? $dato->ctmayoriza : $mayor;

                        if(strlen($valormayor) >= strlen($dato->idctcuenta)) $error = 'Código debe ser más largo que mayoriza ('.$dato->ctmayoriza.')';
                        else{
                            if(substr($dato->idctcuenta, 0 , strlen($valormayor)) !== $valormayor) $error = 'Código no inicia como mayoriza ('.$dato->ctmayoriza.')';
                            else{
                                if($dato->tipocuenta == 3){
                                    $valor = $this->getMayor($mayor);
                                    if($valor != $dato->ctmayoriza) $error = 'Mayoriza actual ('.$dato->ctmayoriza.') mal escrito';
                                }
                            }
                        }
                    }
                }
                if(strlen($error) > 0) {
                    $Datos[] = array(
                        'IDR' => $dato->idrec,
                        'ID' => $dato->idctcuenta,
                        'Name' => $dato->descrip,
                        'mayor' => $dato->ctmayoriza,
                        'tipo' => (int)$dato->tipocuenta,
                        'valor' => $valor,
                        'error' => $error,
                    );
                    $malos++;
                }
            }
        }
        $datA[] = array('valido' => ($malos > 0) ? true : false, 'datos' => $Datos, 'conteo' => $conteo);
        return $datA;
    }
    #   FIN VERIFICAR MAYORIZAS
    #   CORREGIR MAYORIZA
    public function corregirMayor()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                //echo json_encode($datA);
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $modifica = date_create()->format('Y-m-d H:i:s');
                $grupo = (int)$this->input->post("grupo") + 1;
                $cuenta = $this->input->post("cuenta");
                $mayor = $this->input->post("mayor");
                $dcuenta = $this->contabilidad_model->getCuentaC($cuenta);
                if (count($dcuenta) > 0){
                    $mayorvalido = 0;
                    $error = "";
                    switch ($dcuenta->tipocuenta) {
                        case 1:
                            if(strlen(trim($mayor)) > 0){
                                $mayorvalido++;
                                $error = 'No debe tener mayoriza, debe ser un campo vacío';
                            }
                        break;
                        case 2:
                            if(!preg_match('/^([1-9]){1}([0-9]?)+$/', $mayor)){
                                $mayorvalido++;
                                $error = 'Mayoriza debe ser solo númerico';
                            } else{
                                if(strlen($cuenta) <= strlen($mayor)){
                                    $mayorvalido++;
                                    $error = 'Mayoriza muy largo, debe ser más corto que la cuenta';
                                } else{
                                    if(substr($cuenta, 0, strlen($mayor)) !== $mayor){
                                        $mayorvalido++;
                                        $error = 'Mayoriza no es la parte inicial de la cuenta';
                                    }else{
                                        if($this->contabilidad_model->ValidationCuenta2($mayor) == 0){
                                            $mayorvalido++;
                                            $error = 'Mayoriza no existe';
                                        }
                                    }
                                }
                            }
                        break;
                        case 3:
                            $padres = explode(',', $mayor);
                            $padrePrimero = $padres[0];
                            if(!preg_match('/^([1-9]){1}([0-9]?)+$/', $padrePrimero)){
                                $mayorvalido++;
                                $error = 'Mayoriza ('.$padrePrimero.') debe ser solo númerico';
                            }else{
                                if(strlen($cuenta) <= strlen($padrePrimero)){
                                    $mayorvalido++;
                                    $error = 'Mayoriza ('.$padrePrimero.') muy largo, debe ser más corto que la cuenta';
                                } else{
                                    if(substr($cuenta, 0, strlen($padrePrimero)) !== $padrePrimero){
                                        $mayorvalido++;
                                        $error = 'Mayoriza ('.$padrePrimero.') no es la parte inicial de la cuenta';
                                    }else{
                                        if($this->contabilidad_model->ValidationCuenta2($padrePrimero) == 0){
                                            $mayorvalido++;
                                            $error = 'Mayoriza ('.$padrePrimero.') no existe';
                                        } else {
                                            $padresError = null;
                                            foreach ($padres as $padre) {
                                                if(!preg_match('/^([1-9]){1}([0-9]?)+$/', $padre)) $padresError[] = $padre;
                                            }
                                            if($padresError != null) {
                                                $mayorvalido++;
                                                $error = 'Los Mayorizas ('.implode(',', $padresError).') deben ser cada uno númerico';
                                            } else{
                                                foreach ($padres as $padre) {
                                                    if($this->contabilidad_model->ValidationCuenta2($padre) == 0) $padresError[] = $padre;
                                                }
                                                if($padresError != null){
                                                    $mayorvalido++;
                                                    $error = 'Los Mayorizas ('.implode(',', $padresError).') no existen';
                                                } else{
                                                    foreach ($padres as $padre) {
                                                        $dpadre = $this->contabilidad_model->getCuentaC($padre);
                                                        if($dcuenta->catgrupo != $dpadre->catgrupo) $padresError[] = $padre;
                                                    }
                                                    if($padresError != null){
                                                        $mayorvalido++;
                                                        $error = 'Los Mayorizas ('.implode(',', $padresError).') no son del mismo grupo de la cuenta';
                                                    } else{
                                                        //-
                                                        $padreBase = explode(",", $dcuenta->ctmayoriza)[0];
                                                        $sugerencia = $this->getMayor($padreBase);
                                                        if($mayor == $sugerencia){
                                                            $resultado = $this->sugerenciaValido($padreBase);
                                                            if(strlen($resultado) > 0) {
                                                                $mayorvalido++;
                                                                $error = 'Mayoriza ('.$resultado.') tiene conflictos, revisar primero esa cuenta';
                                                            }
                                                        } else {
                                                            $mayorvalido++;
                                                            $error = 'Mayoriza no válido';
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        break;
                    }
                    if($mayorvalido == 0){
                        $data = array(
                            'ctmayoriza' => $mayor,
                            'modifica' => $modifica,
                        );
                        //if(false){
                        if ($this->contabilidad_model->updateCuenta($data, $dcuenta->idrec)){
                            $datA[] = array('valid_up' => true);
                            $datA[] = $this->MayorizaError($grupo);
                        } else $datA[] = array('valid_up' => false, 'tipo' => (int)3);
                    } else $datA[] = array('valid_up' => false, 'tipo' => (int)2, 'error' => $error);
                } else $datA[] = array('valid_up' => false, 'tipo' => (int)1);
                echo json_encode($datA);
            } else show_404();
        }
    }
    private function sugerenciaValido($padreBase)
    {
        $resultado = "";
        $dpadreBase = $this->contabilidad_model->getCuentaC($padreBase);
        if($dpadreBase->tipocuenta == 1) {
            if(strlen(trim($dpadreBase->ctmayoriza)) > 0) $resultado = $padreBase;
            else $resultado = "";
        } else {
            $codigo = $dpadreBase->idctcuenta;
            $padre = $dpadreBase->ctmayoriza;
            if(!preg_match('/^([1-9]){1}([0-9]?)+$/', $padre)) $resultado = $padreBase;
            else{
                if(strlen($codigo) <= strlen($padre)) $resultado = $padreBase;
                else{
                    if(substr($codigo, 0, strlen($padre)) !== $padre) $resultado = $padreBase;
                    else{
                        if($this->contabilidad_model->ValidationCuenta2($padre) == 0) $resultado = $padreBase;
                        else {
                            $resultado = $this->sugerenciaValido($padre);
                        }
                    }
                }
            }
        }
        return $resultado;
    }
    #   FIN CORREGIR MAYORIZA
    #   ACTULIZAR BALVIEW
    public function updateCuentaBG()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $modifica = date_create()->format('Y-m-d H:i:s');
                $ID = $this->input->post("ID");
                $valor = ($this->input->post("valor") == 'true') ? false : true;
                if ($this->contabilidad_model->updateCuenta(array('balview' => $valor, 'modifica' => $modifica), $ID)) {
                    $grupo = ((int)$this->input->post("all") == 8 ) ? 9 : (int)$this->input->post("grupo");
                    $cuentas = $this->contabilidad_model->getCuentas($grupo);
                    $datA[] = array('valido' => true);
                    $datA[] = $cuentas;
                } else {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al actualizar");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN ACTULIZAR BALVIEW
    #   REFPORTE DE CUENTA
    public function RCuentasOld($Grupo = null)
    {
        if($this->validatePermiso()) {
            if ($Grupo != null) {
                if (is_numeric($Grupo)) {
                    $Grupo = (int)$Grupo;
                    if ($Grupo >= 0 && $Grupo < 9) {
                        $titulo = ['Activo', 'Pasivo', 'Patrimonio', 'Deudoras', 'Acreedoras', 'Liquidadoras', 'Orden a Favor', 'Orden en Contra', 'Todas'];
                        $titulo = $titulo[$Grupo];
                        //$control = ['', 'Banco', 'CxC/CxP', 'Impuesto', 'Inventario', 'Activo Fijo', 'Utilidades ejercicio', 'Perdidas ejercicio'];
                        $Grupo = (int)$Grupo + 1;
                        $this->load->model('contabilidad_model');
                        $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
                        $usuario = $this->session->userdata('userLog');
                        //if (($cuentas = $this->contabilidad_model->getCuentas($Grupo)) != false) { 
                            $cuentas = $this->contabilidad_model->getCuentasNR($Grupo);
                            //---------------------------------------   REPORTE  ---------------------------------------
                            $this->load->library('Pdfconta');
                            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
                            //$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
                            #   HEADER TEST
                            $dataHeader = '
                                <table style="width=100%; ">
                                    <tr style="font-size: 15px; font-family: sans-serif;">
                                        <td style="width:10%;"></td>
                                        <td style="width:80%; text-align: center;"><strong>'.$empresa.'</strong></td>
                                        <td style="width:10%;"></td>
                                    </tr>
                                    <tr style="font-size: 15px; font-family: sans-serif;">
                                        <td style="width:10%;"></td>
                                        <td style="width:80%; text-align: center;"><strong>CATÁLOGO DE CUENTAS</strong></td>
                                        <td style="width:10%;"></td>
                                    </tr>
                                    <tr style="line-height: 10px;">
                                        <td></td>
                                    </tr>
                                    <tr style="font-size: 10px; line-height: 15px; text-align: center;">
                                        <td style="width: 12%; border: 1px solid black"><strong>Cuenta</strong></td>
                                        <td style="width: 59%; border: 1px solid black"><strong>Titulo</strong></td>
                                        <td style="width: 18%; border: 1px solid black"><strong>Tipo de Control</strong></td>
                                        <td style="width: 11%; border: 1px solid black"><strong>Mayoriza</strong></td>
                                    </tr>
                                </table>
                            ';
                            $pdf->setHtmlHeader($dataHeader);
                            #   FOOTER TEST
                            date_default_timezone_set('America/El_Salvador');
                            $dataFooter = '
                                <table style="width=100%; border-top: 1px solid black; margin: 0px; padding: 0px;">
                                    <tr style="font-size: 10px;">
                                        <td style="width:33%; text-align: left;">'.date_create()->format('d/m/Y H:i:s A').'</td>
                                        <td style="width:34%; text-align: center;">'.$usuario.'</td>
                                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                                    </tr>
                                </table>
                            ';
                            $pdf->setHtmlFooter($dataFooter);
                            $pdf->SetCreator(PDF_CREATOR);
                            $pdf->SetTitle('Catálogo de Cuentas-'.$titulo);
                            //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);                
                            //$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                            //$pdf->setPrintHeader(false);
                            //$pdf->setPrintFooter(true);
                            $pdf->SetMargins(5, 27, 5, 0);
                            //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
                            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                            $pdf->SetFont('helvetica', '', 9);
                            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
                            #   HEADER - LISTADO
                            $html = '<table style="width=100%;">';
                            #   LISTADO
                            foreach ($cuentas as $cuenta) {
                                if ((int)$cuenta['tipoCuenta'] == 3) {
                                    $html .= '
                                        <tr style="font-size: 9px; line-height: 12px; text-align: left; ">
                                            <td style="width: 12%; ">'.$cuenta['cuenta'].'</td>
                                            <td style="width: 59%; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$cuenta['titulo'].'</td>
                                            <td style="width: 18%; font-size: 9px; text-align: center; ">'.(((int)$cuenta['control'] == 0) ? '' : $cuenta['controlTx']).'</td>
                                            <td style="width: 11%; font-size: 5px;">'.$cuenta['mayoriza'].'</td>
                                        </tr>
                                    ';
                                } else {
                                    $html .= '
                                        <tr style="font-size: 9px; line-height: 12px; text-align: left; ">
                                            <td style="width: 12%; "><strong>'.$cuenta['cuenta'].'</strong></td>
                                            <td style="width: 59%; "><strong>'.$cuenta['titulo'].'</strong></td>
                                            <td style="width: 18%; font-size: 9px; text-align: center; "><strong> </strong></td>
                                            <td style="width: 11%; font-size: 5px;">'.$cuenta['mayoriza'].'</td>
                                        </tr>
                                    ';
                                }
                            }
                            $html .= '</table>';
                            $pdf->writeHTML($html);
                            //$pdf->writeHTML($html, true, 0, true, 0);
                            $pdf->lastPage();
                            $pdf->Output();
                            //---------------------------------------   FIN REPORTE  ---------------------------------------
                        //} else echo "<h1>Grupo sin datos</h1>";
                    } else echo "<h1>Parámetro incorrecto</h1>";
                } else echo "<h1>Parámetro incorrecto</h1>";
            } else echo "<h1>Falta Parámetro de Grupo</h1>";
        }
    }

    public function RCuentas($Grupo, $tipoct){
        if($this->validatePermiso()) {
            if ($Grupo != null) {
                if (is_numeric($Grupo)) {
                    $Grupo = (int)$Grupo;
                    if ($Grupo >= 0 && $Grupo < 9) {
                        $titulo = ['Activo', 'Pasivo', 'Patrimonio', 'Deudoras', 'Acreedoras', 'Liquidadoras', 'Orden a Favor', 'Orden en Contra', 'Todas'];
                        $titulo = $titulo[$Grupo];
                        //$control = ['', 'Banco', 'CxC/CxP', 'Impuesto', 'Inventario', 'Activo Fijo', 'Utilidades ejercicio', 'Perdidas ejercicio'];
                        $Grupo = (int)$Grupo + 1;
                        $this->load->model('contabilidad_model');
                        $this->load->model('auxi_model');

                        $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
                        $usuario = $this->session->userdata('userLog');
                        //if (($cuentas = $this->contabilidad_model->getCuentas($Grupo)) != false) { 
                            $cuentas = $this->contabilidad_model->getCuentasNR($Grupo);
                            //---------------------------------------   REPORTE  ---------------------------------------
                            $this->load->library('Pdfconta');
                            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
                            //$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
                            #   HEADER TEST
                            $dataHeader = '
                                <table style="width=100%; ">
                                    <tr style="font-size: 15px; font-family: sans-serif;">
                                        <td style="width:10%;"></td>
                                        <td style="width:80%; text-align: center;"><strong>'.$empresa.'</strong></td>
                                        <td style="width:10%;"></td>
                                    </tr>
                                    <tr style="font-size: 15px; font-family: sans-serif;">
                                        <td style="width:10%;"></td>
                                        <td style="width:80%; text-align: center;"><strong>CATÁLOGO DE CUENTAS</strong></td>
                                        <td style="width:10%;"></td>
                                    </tr>
                                    <tr style="line-height: 10px;">
                                        <td></td>
                                    </tr>

                                    <tr style="font-size: 8px; line-height: 12px; text-align: center;">
                                        <td style="width: 7%;  line-height: 25px;  border: 1px solid black"><strong>Cuenta</strong></td>
                                        <td style="width: 22%;  line-height: 25px;  border: 1px solid black"><strong>Titulo</strong></td>
                                        <td style="width: 6%; border: 1px solid black"><strong>Tipo de Cuenta</strong></td>
                                        <td style="width: 11%; line-height: 25px; border: 1px solid black"><strong>Tipo de Control</strong></td>
                                        <td style="width: 10%; line-height: 25px; border: 1px solid black"><strong>Auxiliar</strong></td>
                                        <td style="width: 6%; border: 1px solid black"><strong>Centro de Costos</strong></td>
                                        <td style="width: 6%; border: 1px solid black"><strong>Control de Projectos</strong></td>
                                        <td style="width: 6%; border: 1px solid black"><strong>Mostrar en Balance</strong></td>
                                        <td style="width: 11%; line-height: 25px; border: 1px solid black"><strong>Etiquetas</strong></td>
                                        <td style="width: 10%; line-height: 25px; border: 1px solid black"><strong>Mayoriza</strong></td>
                                        <td style="width: 5%; line-height: 25px; border: 1px solid black"><strong>Estado</strong></td>
                                    </tr>
                                </table>
                            ';
                            $pdf->setHtmlHeader($dataHeader);
                            #   FOOTER TEST
                            date_default_timezone_set('America/El_Salvador');
                            $dataFooter = '
                                <table style="width=100%; border-top: 1px solid black; margin: 0px; padding: 0px;">
                                    <tr style="font-size: 10px;">
                                        <td style="width:33%; text-align: left;">'.date_create()->format('d/m/Y H:i:s A').'</td>
                                        <td style="width:34%; text-align: center;">'.$usuario.'</td>
                                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                                    </tr>
                                </table>
                            ';
                            $pdf->setHtmlFooter($dataFooter);
                            $pdf->SetCreator(PDF_CREATOR);
                            $pdf->SetTitle('Catálogo de Cuentas - '.$titulo);
                            //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);                
                            //$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                            //$pdf->setPrintHeader(false);
                            //$pdf->setPrintFooter(true);
                            $pdf->SetMargins(5, 30.9, 5, 0);
                            //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
                            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                            $pdf->SetFont('helvetica', '', 9);
                            $pdf->AddPage('L', 'LETTER');//p vertical l horizontal
                            #   HEADER - LISTADO
                            $html = '<table style="width=100%;">';

                            #   LISTADO
                            foreach ($cuentas as $cuenta) {
                                if ((int)$cuenta['tipoCuenta'] == 3) {
                                    $auxi = "";
                                    if($cuenta['useauxi'] != ""){
                                        $temp = explode(",", $cuenta['useauxi']);
                                        
                                        if($temp[0]=="1"){
                                            $auxi = $this->contabilidad_model->getTipoSubAuxi($temp[1]);
                                        }
                                    }
                                    $html .= '
                                        <tr style="font-size: 7.5px; text-align: left; line-height: 3.8mm">
                                            <td style="border: 1px solid #bdbdbd;width: 7%;">'.$cuenta['cuenta'].'</td>
                                            <td style="border: 1px solid #bdbdbd;width: 22%;">'.$cuenta['titulo'].'</td>
                                            <td style="border: 1px solid #bdbdbd;width: 6%; text-align: center;">'.$cuenta['tipoCuenta'].'</td>
                                            <td style="border: 1px solid #bdbdbd;width: 11%;  text-align: center;">'.(((int)$cuenta['control'] == 0) ? '' : $cuenta['controlTx']).'</td>
                                            <td style="border: 1px solid #bdbdbd;width: 10%; text-align: center;">'.$auxi.'</td>
                                            <td style="border: 1px solid #bdbdbd;width: 6%; text-align: center;">'.(($cuenta['askcentro']) ? 'X' : '').'</td>
                                            <td style="border: 1px solid #bdbdbd;width: 6%; text-align: center;">'.(($cuenta['askproyecto']) ? 'X' : '').'</td>
                                            <td style="border: 1px solid #bdbdbd;width: 6%; text-align: center;">'.(($cuenta['mostrarBG']) ? 'X' : '').'</td>
                                            <td style="border: 1px solid #bdbdbd;width: 11%;">'.$cuenta['etiqueta'].'</td>
                                            <td style="border: 1px solid #bdbdbd;width: 10%;">'.$cuenta['mayoriza'].'</td>
                                            <td style="border: 1px solid #bdbdbd;width: 5%; text-align: center;">'.$cuenta['estadoTx'].'</td>
                                        </tr>
                                    ';
                                }else if((int)$cuenta['tipoCuenta'] != 3 && $tipoct == 0) {
                                    $html .= '
                                        <tr style="font-size: 7.5px; text-align: left; line-height: 3.8mm">
                                            <td style="border: 1px solid #bdbdbd;width: 7%;"><strong>'.$cuenta['cuenta'].'</strong></td>
                                            <td style="border: 1px solid #bdbdbd;width: 22%;"><strong>'.$cuenta['titulo'].'</strong></td>
                                            <td style="border: 1px solid #bdbdbd;width: 6%; text-align: center;"><strong>'.$cuenta['tipoCuenta'].'</strong></td>
                                            <td style="border: 1px solid #bdbdbd;width: 11%;"><strong></strong></td>
                                            <td style="border: 1px solid #bdbdbd;width: 10%;"><strong></strong></td>
                                            <td style="border: 1px solid #bdbdbd;width: 6%; text-align: center;"><strong></strong></td>
                                            <td style="border: 1px solid #bdbdbd;width: 6%; text-align: center;"><strong></strong></td>
                                            <td style="border: 1px solid #bdbdbd;width: 6%; text-align: center;"><strong></strong></td>
                                            <td style="border: 1px solid #bdbdbd;width: 11%;"><strong></strong></td>
                                            <td style="border: 1px solid #bdbdbd;width: 10%;"><strong>'.$cuenta['mayoriza'].'</strong></td>
                                            <td style="border: 1px solid #bdbdbd;width: 5%; text-align: center;"><strong>'.$cuenta['estadoTx'].'</strong></td>
                                        </tr>                                    ';
                                }
                            }
                            $html .= '</table>';
                            $pdf->writeHTML($html);
                            //$pdf->writeHTML($html, true, 0, true, 0);
                            $pdf->lastPage();
                            $pdf->Output();
                            //---------------------------------------   FIN REPORTE  ---------------------------------------
                        //} else echo "<h1>Grupo sin datos</h1>";
                    } else echo "<h1>Parámetro incorrecto</h1>";
                } else echo "<h1>Parámetro incorrecto</h1>";
            } else echo "<h1>Falta Parámetro de Grupo</h1>";
        }
    }
    #   FIN REFPORTE DE CUENTA

    #------------------------------------------------------     FIN CATALOGO DE CUENTAS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     TIPOS DE PARTIDAS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function indexTPartidas($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $this->load->model('contabilidad_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);

            $direccion = $this->uri->segment(1);
            $validoTCA = $this->contabilidad_model->VTPartidasCA();
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->data['valido'] = $validoTCA;
            $this->load->view("mantenimiento_TPartidas", $this->data);
        }
    }
    #   GET TIPOS DE PARTIDAS
    public function getTPartidas()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                echo json_encode($this->contabilidad_model->getTPartidas());
            } else show_404();
        }
    }
    #   FIN GET TIPOS DE PARTIDAS
    #   GET CUENTAS Y USUARIOS - CUENTA
    public function getDataTP()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $cuentas = $this->contabilidad_model->getCuentas3();
                $usuarios = $this->contabilidad_model->getUsuarios();
                $Cuentas = null;
                $Usuarios = null;
                if ($cuentas->num_rows() > 0) {
                    foreach ($cuentas->result() as $cuenta) {
                        $Cuentas[] = array(
                            'ID' => $cuenta->idctcuenta,
                            'name' => $cuenta->descrip
                        );
                    }
                }
                if ($usuarios->num_rows() > 0) {
                    foreach ($usuarios->result() as $usuario) {
                        $Usuarios[] = array(
                            'ID' => $usuario->iduser,
                            'name' => $usuario->descrip
                        );
                    }
                }
                #   GET CUENTA POR ID
                if ($ID = $this->input->post("ID")) {
                    if ($TPartida = $this->contabilidad_model->getTPartida((int)$ID)) {
                        $datA[] = array('valido' => true);
                        $datA[] = $Cuentas;
                        $datA[] = $Cuentas;
                        $datA[] = $Usuarios;
                        $datA[] = $Usuarios;
                        $datA[] = $TPartida;
                    } else {
                        $datA[] = array('valido' => false);
                        $datA[] = array('mjs' => "error al traer TPartida");
                    }
                } else {
                    $datA[] = array('valido' => true);
                    $datA[] = $Cuentas;
                    $datA[] = $Cuentas;
                    $datA[] = $Usuarios;
                    $datA[] = $Usuarios;
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN GET CUENTAS Y USUARIOS - CUENTA
    #   SET TIPO DE PARTIDA
    public function setTPartida()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d H:i:s');
                $data = array(
                    'descrip' => $this->input->post("descripcion"),
                    'assisted_entry' => ((strlen($this->input->post("debe")) > 0) || (strlen($this->input->post("haber")) > 0)) ? 1 : 0,
                    'debe_ct' => $this->input->post("debe"),
                    'haber_ct' => $this->input->post("haber"),
                    'periodos' => $this->input->post("periodos"),
                    'allowed_users' => $this->input->post('permisos'),
                    'voiding_users' => $this->input->post('anulacion'),
                    'allowed_ctmulti' => $this->input->post('archivos'),
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post("estado") == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => $ahora
                );
                if ($this->contabilidad_model->setTPartida($data)){
                    $datos = $this->contabilidad_model->getTPartidas();
                    $datA[] = array('valido' => true);
                    $datA[] = $datos;
                } else {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al guardar");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN SET TIPO DE PARTIDA
    #   UPDATE TIPO DE PARTIDA
    public function updateTPartida()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $modifica = date_create()->format('Y-m-d H:i:s');
                $ID = $this->input->post("ID");
                $data = array(
                    'descrip' => $this->input->post("descripcion"),
                    'assisted_entry' => ((strlen($this->input->post("debe")) > 0) || (strlen($this->input->post("haber")) > 0)) ? 1 : 0,
                    'debe_ct' => $this->input->post("debe"),
                    'haber_ct' => $this->input->post("haber"),
                    'periodos' => $this->input->post("periodos"),
                    'allowed_users' => $this->input->post('permisos'),
                    'voiding_users' => $this->input->post('anulacion'),
                    'allowed_ctmulti' => $this->input->post('archivos'),
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post("estado") == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),
                    'modifica' => $modifica
                );
                if ($this->contabilidad_model->updateTPartida($data, $ID)){
                    $datos = $this->contabilidad_model->getTPartidas();
                    $datA[] = array('valido' => true);
                    $datA[] = $datos;
                } else {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al actualizar");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN UPDATE TIPO DE PARTIDA
    #   BORRAR TIPO DE PARTIDA
    public function eraseTPartida()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $ID = $this->input->post("ID");
                if ($this->contabilidad_model->eraseTPartida($ID)){
                    $datos = $this->contabilidad_model->getTPartidas();
                    $datA[] = array('valido' => true);
                    $datA[] = $datos;
                } else {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "errorPadre");
                }
                echo json_encode($datA);//*/
            } else show_404();
        }
    }
    #   FIN BORRAR TIPO DE PARTIDA
    #   REPORTE DE PARTIDA
    public function RTPartidas()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $this->session->userdata('userLog');
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $dataHeader = '
                <table style="width=100%; ">
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width:10%;"></td>
                        <td style="width:80%; text-align: center;"><strong>'.$empresa.'</strong></td>
                        <td style="width:10%;"></td>
                    </tr>
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width:10%;"></td>
                        <td style="width:80%; text-align: center;"><strong>TIPOS DE PARTIDAS</strong></td>
                        <td style="width:10%;"></td>
                    </tr>
                    <tr style="line-height: 10px;">
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr style="font-size: 10px; line-height: 15px; text-align: center;">
                        <td style="width: 10%; border: 1px solid black"><strong>ID Tipo</strong></td>
                        <td style="width: 90%; border: 1px solid black"><strong>Titulo</strong></td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlHeader($dataHeader);
            date_default_timezone_set('America/El_Salvador');
            $dataFooter = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="font-size: 10px;">
                        <td style="width:33%; text-align: left;">'.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;">'.$usuario.'</td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($dataFooter);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Tipos de Partidas');
            $pdf->SetMargins(16, 27, 16);
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
            $html ='';
            $html .= '<table style="width=100%; ">';
            $datos = $this->contabilidad_model->getTPartidas();
            if ($datos != null) {
                #   LISTADO
                foreach ($datos as $dato) {
                    $html .= '
                        <tr style="font-size: 10px; line-height: 12px; text-align: left; ">
                            <td style="width: 10%; text-align: center;">'.$dato['id'].'</td>
                            <td style="width: 90%; ">&nbsp;&nbsp;'.$dato['titulo'].'</td>
                        </tr>';
                }
            }
            $html .= '</table>';
            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }
    #   FIN REPORTE DE PARTIDA
    #------------------------------------------------------     FIN TIPOS DE PARTIDAS -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     PERIODOS CONTABLES ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function indexPeriodos($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);

            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);

            $direccion = $this->uri->segment(1);

            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->load->view("mantenimiento_PeriodosC", $this->data);
        }
    }
    #   GET PERIODOS
    public function getPeriodos()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                echo json_encode($this->contabilidad_model->getPeriodos());
            } else show_404();
        }
    }
    #   FIN GET PERIODOS
    #   SET PERIODO
    public function setPeriodo()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d H:i:s');
                if ($this->contabilidad_model->ValidationPeriodo($this->input->post("year")) == 0) {
                    $data = array(
                        'descrip' => $this->input->post("descripcion"),
                        'idyear' => (int)$this->input->post("year"),
                        'fechaini' => $this->input->post("fi"),
                        'fechafin' => $this->input->post("ff"),
                        'meses' => (int)$this->input->post("meses"),
                        'xpos' => $this->input->post('xpos'),
                        'estatus' => ($this->input->post("estado") == "true") ? 1 : 0,
                        'notas' => $this->input->post('notas'),
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => $ahora
                    );
                    if ($this->contabilidad_model->setPeriodo($data)){
                        $datos = $this->contabilidad_model->getPeriodos();
                        $datA[] = array('valido' => true);
                        $datA[] = $datos;
                    } else {
                        $datA[] = array('valido' => false);
                        $datA[] = array('mjs' => "error al guardar");
                    }
                } else {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => 'errorYear');
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN SET PERIODO
    #   GET PERIODO
    public function getPeriodo()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $ID = $this->input->post("ID");
                if($Data = $this->contabilidad_model->getPeriodo((int)$ID)){
                    $datA[] = array('valido' => true);
                    $datA[] = $Data;
                } else $datA[] = array('valido' => false, 'mjs' => "error al traer Periodo");
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN GET PERIODO
    #   UPDATE PERIODO
    public function updatePeriodo()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $modifica = date_create()->format('Y-m-d H:i:s');
                $ID = $this->input->post("ID");
                $meses = (int)$this->input->post("meses");
                $dato = $this->contabilidad_model->getPeriodo((int)$ID);
                $data = array(
                    'descrip' => $this->input->post("descripcion"),
                    //'idyear' => (int)$this->input->post("year"),
                    'fechaini' => $this->input->post("fi"),
                    'fechafin' => $this->input->post("ff"),
                    'meses' => $meses,
                    'mes00' => ($meses == 14) ? (int)$dato->mes00 : 0,
                    'mes13' => ($meses != 12) ? (int)$dato->mes13 : 0,
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post("estado") == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),
                    'modifica' => $modifica
                );
                if ($this->contabilidad_model->updatePeriodo($data, $ID)){
                    $datos = $this->contabilidad_model->getPeriodos();
                    $datA[] = array('valido' => true);
                    $datA[] = $datos;
                } else $datA[] = array('valido' => false, 'mjs' => "error al actualizar");
                echo json_encode($datA);
            } else show_404();
        }
    }
    public function updatePeriodoM()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $modifica = date_create()->format('Y-m-d H:i:s');
                $ID = $this->input->post("ID");
                $IDm = $this->input->post("idm");
                $data = array(
                    'mes'.$IDm => ($this->input->post("valor") == "true") ? 1 : 0,
                    'modifica' => $modifica
                );
                if ($this->contabilidad_model->updatePeriodo($data, $ID)) {
                    $datA[] = array('valido' => true);
                } else {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al actualizar");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN UPDATE PERIODO
    #   REPORTES DE PERIODOS
    public function RPeriodos()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $usuario = $this->session->userdata('userLog');
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $dataHeader = '
                <table style="width=100%; ">
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width:10%;"></td>
                        <td style="width:80%; text-align: center;"><strong>'.$empresa.'</strong></td>
                        <td style="width:10%;"></td>
                    </tr>
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width:10%;"></td>
                        <td style="width:80%; text-align: center;"><strong>PERÍODOS CONTABLES</strong></td>
                        <td style="width:10%;"></td>
                    </tr>
                    <tr style="line-height: 10px;">
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr style="font-size: 10px; line-height: 15px; text-align: center;">
                        <td style="width: 10%; border: 1px solid black"><strong>Año</strong></td>
                        <td style="width: 60%; border: 1px solid black"><strong>Descripción</strong></td>
                        <td style="width: 15%; border: 1px solid black"><strong>Fecha Inicio</strong></td>
                        <td style="width: 15%; border: 1px solid black"><strong>Fecha Final</strong></td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlHeader($dataHeader);
            date_default_timezone_set('America/El_Salvador');
            $dataFooter = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="font-size: 10px;">
                        <td style="width:33%; text-align: left;">'.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;">'.$usuario.'</td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($dataFooter);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Períodos Contables');
            $pdf->SetMargins(16, 27, 16);
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
            $html = '';
            $html .= '<table style="width=100%; ">';
            $datos = $this->contabilidad_model->getPeriodos();
            if (count($datos) > 0) {
                foreach ($datos as $dato) {
                    $html .= '
                        <tr style="font-size: 10px; line-height: 12px; text-align: left; ">
                            <td style="width: 10%; text-align: center;">'.$dato['idy'].'</td>
                            <td style="width: 60%; ">&nbsp;'.$dato['titulo'].'</td>
                            <td style="width: 15%; text-align: center;">'.date_format(date_create($dato['fecha_ini']), 'd/m/Y').'</td>
                            <td style="width: 15%; text-align: center;">'.date_format(date_create($dato['fecha_fin']), 'd/m/Y').'</td>
                        </tr>';
                }
                //(new DateTime($fechai))->format('d/m/Y')
            }
            $html .= '</table>';
            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }
    #   REPORTES DE PERIODOS
    #------------------------------------------------------     FIN PERIODOS CONTABLES ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     CUENTAS AUXILIARES ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function indexCAuxiliares($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);

            $direccion = $this->uri->segment(1);

            $this->load->model('global_model');
            $this->load->model('variable_model');

            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $variable = $this->variable_model->getTextVar("conta_subauxi");
            $this->data['subauxi'] = (int)$variable['valor_num'];

            $this->load->view("mantenimiento_CAuxiliares", $this->data);
        }
    }
    #------------------------------------------------------     CUENTAS AUXILIARES MEJORA
    public function indexCAuxiliaresN($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);

            $direccion = $this->uri->segment(1);

            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->load->view("mantenimiento_CAuxiliaresN", $this->data);
        }
    }
    #   GET DATA
    public function getDataCAN() {
        if($this->validatePermiso()) {
            $opcion = (int)$this->input->post('opcion');
            $this->load->model('contabilidad_model');
            switch ($opcion) {
                #   LOAD LOS TIPOS AUXILIARES
                case 0:
                    $datos = $this->contabilidad_model->getDataCAN($opcion, null);
                    $Datos = [];
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $Datos[] = array(
                                'ID' => (int)$dato->valor_num,
                                'Name' => ucfirst(strtolower($dato->descripcion)),
                                'tipo' => (int)$dato->filtro,
                            );
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                break;
                #   GET CUENTAS AUXILIARES
                case 1:
                    $IDAuxi = (int)$this->input->post('ID');
                    $Datos = $this->getconversionCA($IDAuxi);
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                break;
            }
            echo json_encode($datA);
        }
    }
    private function getconversionCA($extra)
    {
        $Datos = [];
        $datos = $this->contabilidad_model->getDataCAN(1, $extra);
        if ($datos->num_rows() > 0) {
            foreach($datos->result() as $dato) {
                $Datos[] = array(
                    'key' => (int)$dato->idauxi,
                    'titulo' => $dato->descrip,
                    'grupo' => $dato->grupo,
                    'nrc' => $dato->nrc,
                    'nit' => $dato->nit,
                    'estatus' => $dato->estado,
                    'estado' => ($dato->estado == 1) ? 'Activo' : 'Inactivo',
                    'telefono' => $dato->telefono,
                    'correo' => $dato->correo,
                    'direccion' => $dato->direccion,

                    'giro' => $dato->giro,
                    'idtipo' => $dato->idtipo,
                    'tipo' => array_search($dato->idtipo, $this->Tiposcontribuyentes),
                    'limite' => $dato->limite,
                    'dias' => $dato->dias
                );
            }
        }
        return $Datos;
    }
    #------------------------------------------------------     FIN CUENTAS AUXILIARES MEJORA
    #   LOAD LOS TIPOS AUXILIARES
    public function loadAuxis()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                echo json_encode($this->contabilidad_model->loadAuxis());
            } else show_404();
        }
    }
    #   FIN LOAD LOS TIPOS AUXILIARES
    #   GET CUENTAS AUXILIARES
    public function getCAuxiliares()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                if ($this->input->post("auxi")) {
                    //echo "-";
                    if ($datos = $this->contabilidad_model->getCAuxiliares((int)$this->input->post("auxi"))) {
                        echo json_encode($datos);
                    } else echo json_encode(null);
                } else echo json_encode(null);
            } else show_404();
        }
    }
    #   FIN GET CUENTAS AUXILIARES
    #   GET DATA CA - GRUPOS - GIRO - LIMITE - DIAS - TIPO CONTRIBUYENTE - DEPARTAMENTO - VENDEDOR
    public function getDataCA()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                switch ((int)$this->input->post("tipo")) {
                    case 1:
                        if($grupoS = $this->contabilidad_model->getDataCA(1, null, (int)$this->input->post("auxi"))){
                            if($vendedorS = $this->contabilidad_model->getDataCA(2)){
                                if($departamentoS = $this->contabilidad_model->getDataCA(3)){
                                    if($giroS = $this->contabilidad_model->getDataCA(4)){
                                        if($limiteS = $this->contabilidad_model->getDataCA(5)){
                                            if($diaS = $this->contabilidad_model->getDataCA(6)){
                                                //------------------------------------------------------------------------------------------------
                                                $cont = 0;
                                                $GrupoS = null;
                                                if($grupoS->num_rows() > 0){
                                                    foreach ($grupoS->result() as $dato) {
                                                        $GrupoS[] = array(
                                                            'ID' => "".$cont,
                                                            'Name' => $dato->grupo
                                                        );
                                                        $cont++;
                                                    }
                                                }
                                                foreach ($vendedorS as $dato) {
                                                    $VendedorS[] = array(
                                                        'ID' => $dato->idauxi,
                                                        'Name' => $dato->descrip
                                                    );
                                                }
                                                foreach ($departamentoS as $dato) {
                                                    $DepartamentoS[] = array(
                                                        'ID' => $dato->idzip,
                                                        'Name' => $dato->municipio,
                                                        'Departamento' => $dato->depto
                                                    );
                                                }
                                                $cont = 0;
                                                $GiroS = null;
                                                if($giroS->num_rows() > 0){
                                                    foreach ($giroS->result() as $dato) {
                                                        $GiroS[] = array(
                                                            'ID' => "".$cont,
                                                            'Name' => $dato->giro
                                                        );
                                                        $cont++;
                                                    }
                                                }
                                                $cont = 0;
                                                $LimiteS = null;
                                                if($limiteS->num_rows() > 0){
                                                    foreach ($limiteS->result() as $dato) {
                                                        $LimiteS[] = array(
                                                            'ID' => "".$cont,
                                                            'Name' => $dato->limite
                                                        );
                                                        $cont++;
                                                    }
                                                }
                                                $cont = 0;
                                                $DiaS = null;
                                                if($diaS->num_rows() > 0){
                                                    foreach ($diaS->result() as $dato) {
                                                        $DiaS[] = array(
                                                            'ID' => "".$cont,
                                                            'Name' => $dato->dias
                                                        );
                                                        $cont++;
                                                    }
                                                }
                                                //------------------------------------------------------------------------------------------------
                                                #   GET CUENTA POR ID
                                                if ($ID = $this->input->post("ID")) {
                                                    if ($DataOne = $this->contabilidad_model->getDataCA(7, (int)$ID)) {
                                            
                                                        $datA[] = array('valido' => true);
                                                        $datA[] = $GrupoS;
                                                        $datA[] = $VendedorS;
                                                        $datA[] = $DepartamentoS;
                                                        $datA[] = $GiroS;
                                                        $datA[] = $LimiteS;
                                                        $datA[] = $DiaS;
                                                        $datA[] = $DataOne;
                                                    } else{
                                                        $datA[] = array('valido' => false);
                                                        $datA[] = array('mjs' => "error al traer CA");
                                                    }
                                                } else{
                                                    $datA[] = array('valido' => true);
                                                    $datA[] = $GrupoS;
                                                    $datA[] = $VendedorS;
                                                    $datA[] = $DepartamentoS;
                                                    $datA[] = $GiroS;
                                                    $datA[] = $LimiteS;
                                                    $datA[] = $DiaS;
                                                }
                                                //------------------------------------------------------------------------------------------------
                                            } else{
                                                $datA[] = array('valido' => false);
                                                $datA[] = array('mjs' => "error al traer dias");
                                            }
                                        } else{
                                            $datA[] = array('valido' => false);
                                            $datA[] = array('mjs' => "error al traer limite");
                                        }
                                    } else{
                                        $datA[] = array('valido' => false);
                                        $datA[] = array('mjs' => "error al traer giro");
                                    }
                                } else{
                                    $datA[] = array('valido' => false);
                                    $datA[] = array('mjs' => "error al traer departamento");
                                }
                            } else{
                                $datA[] = array('valido' => false);
                                $datA[] = array('mjs' => "error al traer vendedor");
                            }
                        } else{
                            $datA[] = array('valido' => false);
                            $datA[] = array('mjs' => "error al traer grupos");
                        }
                    break;
                    case 2:
                    case 3:
                    case 4:
                        if($grupoS = $this->contabilidad_model->getDataCA(1, null, (int)$this->input->post("auxi"))){
                            $cont = 0;
                            $GrupoS = null;
                            if($grupoS->num_rows() > 0){
                                foreach ($grupoS->result() as $dato) {
                                    $GrupoS[] = array(
                                        'ID' => "".$cont,
                                        'Name' => $dato->grupo
                                    );
                                    $cont++;
                                }
                            }
                            //------------------------------------------------------------------------------------------------
                            #   GET CUENTA POR ID
                            if ($ID = $this->input->post("ID")) {
                                if ($DataOne = $this->contabilidad_model->getDataCA(7, (int)$ID)) {
                        
                                    $datA[] = array('valido' => true);
                                    $datA[] = $GrupoS;
                                    $datA[] = $DataOne;
                                }
                                else{
                                    $datA[] = array('valido' => false);
                                    $datA[] = array('mjs' => "error al traer CA");
                                }
                            } else{
                                $datA[] = array('valido' => true);
                                $datA[] = $GrupoS;
                            }
                            //------------------------------------------------------------------------------------------------
                        } else{
                            $datA[] = array('valido' => false);
                            $datA[] = array('mjs' => "error al traer grupos");
                        }
                    break;
                    
                }
                /*if ((int)$this->input->post("tipo") == 1) {
                } else if ((int)$this->input->post("tipo") == 2) {
                }*/
                

                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN GET DATA CA - GRUPOS - GIRO - LIMITE - DIAS - TIPO CONTRIBUYENTE - DEPARTAMENTO - VENDEDOR
    #   SET CUENTA AUXILIADORA
    public function setCA()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d H:i:s');
                switch ((int)$this->input->post("tipo")) {
                    case 1:
                        $data = array(
                            'descrip' => $this->input->post("nombre"),
                            'idauxidef' => (int)$this->input->post("auxi"),
                            'telefono' => $this->input->post("telefono"),
                            'correo' => $this->input->post("correo"),
                            'direccion' => $this->input->post("direccion"),
                            'idzip' => (int)$this->input->post("departamento"),
                            'fechain' => substr($ahora, 0, 10),
                            'nrc' => $this->input->post("nrc"),
                            'nit' => $this->input->post("nit"),
                            'giro' => $this->input->post("giro"),
                            'grupo' => $this->input->post("grupo"),
                            'limite' => $this->input->post("limite"),
                            'dias' => (int)$this->input->post("dia"),
                            'xpos' => $this->input->post('xpos'),
                            'idcps' => (int)$this->input->post("vendedor"),
                            'idtipo' => (int)$this->input->post("tipoContri"),
                            'sidauxidef' => $this->input->post("subAuxi"),
                            'estado' => ($this->input->post("estado") == "true") ? 1 : 0,
                            'notas' => $this->input->post('notas'),
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => $ahora
                        );
                    break;
                    case 2:
                        $data = array(
                            'descrip' => $this->input->post("nombre"),
                            'idauxidef' => (int)$this->input->post("auxi"),
                            'telefono' => $this->input->post("telefono"),
                            'correo' => $this->input->post("correo"),
                            'direccion' => $this->input->post("direccion"),

                            'fechain' => substr($ahora, 0, 10),
                            'grupo' => $this->input->post("grupo"),
                            'sidauxidef' => $this->input->post("subAuxi"),

                            'xpos' => $this->input->post('xpos'),
                            'estado' => ($this->input->post("estado") == "true") ? 1 : 0,
                            'notas' => $this->input->post('notas'),
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => $ahora
                        );
                    break;
                    case 3: 
                        $data = array(
                            'descrip' => $this->input->post("nombre"),
                            'idauxidef' => (int)$this->input->post("auxi"),

                            'telefono' => $this->input->post("telefono"),
                            'correo' => $this->input->post("correo"),

                            'nrc' => $this->input->post("nrc"),
                            'nit' => $this->input->post("nit"),

                            'fechain' => $this->input->post("fechain"),
                            'grupo' => $this->input->post("grupo"),
                            'giro' => $this->input->post("giro"),
                            'limite' => $this->input->post("limite"),
                            'sidauxidef' => $this->input->post("subAuxi"),

                            'estado' => ($this->input->post("estado") == "true") ? 1 : 0,
                            'notas' => $this->input->post('notas'),
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => $ahora
                        );
                    break;
                    case 4: 
                        $data = array(
                            'descrip' => $this->input->post("nombre"),
                            'idauxidef' => (int)$this->input->post("auxi"),

                            'grupo' => $this->input->post("grupo"),
                            'sidauxidef' => $this->input->post("subAuxi"),

                            'xpos' => $this->input->post('xpos'),
                            'estado' => ($this->input->post("estado") == "true") ? 1 : 0,
                            'notas' => $this->input->post('notas'),
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => $ahora
                        );
                    break;
                }
                if ($this->contabilidad_model->setCA($data)){
                    $datos = $this->contabilidad_model->getCAuxiliares((int)$this->input->post("auxi"));
                    $datA[] = array('valido' => true);
                    $datA[] = $datos;
                } else{
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al guardar");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN SET CUENTA AUXILIADORA
    #   IMPORTAR MULTIPELS CUENTAS
    public function addMCuentasA() {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $this->load->model('variable_model');
            date_default_timezone_set('America/El_Salvador');
            $Tipo = (int)$this->input->post("tipo");
            $Auxi = (int)$this->input->post("auxi");
            $Cuentas = $this->input->post("cuentas");
            $conteo = 0;
            $IDP = $this->variable_model->getTextVar("gv_zip");
            $IDP = (int)$IDP['valor_num'];
            foreach (explode("\n", $Cuentas) as $nombre) {
                $data = array(
                    'descrip' => $nombre,
                    'idauxidef' => $Auxi,
                    'idzip' => $IDP,
                    'grupo' => '',
                    'estado' => 1,
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s')
                );
                if (!$this->contabilidad_model->setCA($data)) $conteo++;
            }
            //$Datos = [];
            $Datos = $this->contabilidad_model->getCAuxiliares($Auxi);
            $datA[] = array('valido' => (($conteo == 0) ? true : false), 'datos' => $Datos);
            echo json_encode($datA);
        }
    }
    #   UPDATE CUENTA AUXILIADORA
    public function updateCA() {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $modifica = date_create()->format('Y-m-d H:i:s');
                $modi = date_create()->format('Y-m-d');
                $ID = $this->input->post("ID");
                switch ((int)$this->input->post("tipo")) {
                    case 1:
                        $data = array(
                            'descrip' => $this->input->post("nombre"),
                            'idauxidef' => (int)$this->input->post("auxi"),
                            'telefono' => $this->input->post("telefono"),
                            'correo' => $this->input->post("correo"),
                            'direccion' => $this->input->post("direccion"),
                            'idzip' => (int)$this->input->post("departamento"),

                            'nrc' => $this->input->post("nrc"),
                            'nit' => $this->input->post("nit"),
                            'giro' => $this->input->post("giro"),
                            'grupo' => $this->input->post("grupo"),
                            'nit' => $this->input->post("nit"),
                            'limite' => $this->input->post("limite"),
                            'dias' => (int)$this->input->post("dia"),
                            'xpos' => $this->input->post('xpos'),
                            'idcps' => (int)$this->input->post("vendedor"),
                            'idtipo' => (int)$this->input->post("tipoContri"),
                            'sidauxidef' => $this->input->post("subAuxi"),

                            'estado' => ($this->input->post("estado") == "true") ? 1 : 0,
                            'notas' => $this->input->post('notas'),
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => $modifica
                        );
                    break;
                    case 2:
                        $data = array(
                            'descrip' => $this->input->post("nombre"),
                            'idauxidef' => (int)$this->input->post("auxi"),
                            'telefono' => $this->input->post("telefono"),
                            'correo' => $this->input->post("correo"),
                            'direccion' => $this->input->post("direccion"),

                            'grupo' => $this->input->post("grupo"),
                            'sidauxidef' => $this->input->post("subAuxi"),

                            'xpos' => $this->input->post('xpos'),
                            'estado' => ($this->input->post("estado") == "true") ? 1 : 0,
                            'notas' => $this->input->post('notas'),
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => $modifica
                        );
                    break;
                    case 3:
                        $data = array(
                            'descrip' => $this->input->post("nombre"),
                            'telefono' => $this->input->post("telefono"),
                            'correo' => $this->input->post("correo"),

                            'fechain' => $this->input->post("fechain"),
                            'nrc' => $this->input->post("nrc"),
                            'nit' => $this->input->post("nit"),

                            'giro' => $this->input->post("giro"),
                            'grupo' => $this->input->post("grupo"),
                            'limite' => $this->input->post("limite"),
                            'sidauxidef' => $this->input->post("subAuxi"),

                            'estado' => ($this->input->post("estado") == "true") ? 1 : 0,
                            'notas' => $this->input->post('notas'),
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => $modifica
                        );
                    break;
                    case 4: 
                        $data = array(
                            'descrip' => $this->input->post("nombre"),
                            'grupo' => $this->input->post("grupo"),
                            'sidauxidef' => $this->input->post("subAuxi"),

                            'xpos' => $this->input->post('xpos'),
                            'estado' => ($this->input->post("estado") == "true") ? 1 : 0,
                            'notas' => $this->input->post('notas'),
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => $modifica
                        );
                    break;
                }
                if ($this->contabilidad_model->updateCA($data, $ID)){
                    $datos = $this->contabilidad_model->getCAuxiliares((int)$this->input->post("auxi"));
                    $datA[] = array('valido' => true);
                    $datA[] = $datos;
                }else{
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al guardar");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    public function updateCAI() {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            date_default_timezone_set('America/El_Salvador');
            $ID = (int)$this->input->post("ID");
            $tipo = (int)$this->input->post("tipo");
            $auxi = (int)$this->input->post("auxi");
            $direccion = "img_cuentas/".$this->session->userdata('diraccount')."/";
            $size = $_FILES['Archivo']['size'];
            $ext = $_FILES['Archivo']['name'];
            //echo json_encode($datA);
            $dato = $this->contabilidad_model->getDataCA(7, $ID);
            $tiene = (strlen(trim($dato->imagen)) > 0) ? true : false;
            if ($tiene) {
                $tiene = (file_exists($direccion.trim($dato->imagen))) ? true : false;
            }
            
            if ($tiene) {
                $nombreActual = explode(".", $dato->imagen)[0];
                $nombreold = $nombreActual;
                //echo "tiene";
            } else {
                do {
                    $conteo = $this->contabilidad_model->getDataCA(8, $auxi, null);
                    $nombreold = "imgAuxiliar".$auxi."_".$conteo."_".rand(10,1000);
                    $nombresearch = $nombreold.".".pathinfo($ext, PATHINFO_EXTENSION);

                    $validacion = $this->contabilidad_model->getDataCA(9, $nombresearch, null);
                } while ($validacion == -1);
                //echo "ntiene";
            }
            $nombrei = $nombreold.".".pathinfo($ext, PATHINFO_EXTENSION);
            $config['upload_path']= $direccion;
            $config['over_write'] = "TRUE";
            $config['allowed_types'] = "gif|jpg|jpeg|png|JPG|PNG";
            $config['file_name'] = '123'.$nombrei;
            $config['max_size'] = 200;
            $this->load->library('upload',$config);
            $terror = 0;
            if ($this->upload->do_upload('Archivo')) {
                $sen = true;
                $error = '';
                $a = $this->upload->data();
            } else {
                $sen = false;
                $error = $this->upload->display_errors();
                if (($size / 1024) > 200) $terror = 'sizeImagen';
            }
            //echo "--".$nombrei;
            if ($sen) {
                $data = array(
                    'imagen' => $nombrei,
                    'whodidit' => $this->session->userdata('iduser'),
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->contabilidad_model->updateCA($data, $ID)){
                    if ($tiene) {
                        $path = $direccion.trim($dato->imagen);
                        unlink($path);
                    }
                    rename($a['full_path'],$a['file_path'].$nombrei);
                    $datos = $this->contabilidad_model->getCAuxiliares($auxi);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else {
                    $path = $direccion.'123'.$nombrei;
                    unlink($path);
                }
            } else $datA[] = array('valido' => false, 'error' => $error, 'tipo' => $terror);
            echo json_encode($datA);
        }
    }
    #   FIN UPDATE CUENTA AUXILIADORA
    #   REPORTE DE CUENTAS AUXILIARES
    public function RCAuxiliares($auxiliar = null)
    {
        if($this->validatePermiso()) {
            if ($auxiliar != null) {
                if (is_numeric($auxiliar)) {
                    $this->load->model('contabilidad_model');
                    $auxis = $this->contabilidad_model->loadAuxis();
                    if ($auxis != null) {
                        foreach ($auxis as $auxi) {
                            if ($auxi['ID'] == $auxiliar) {
                                $nombreCuenta = $auxi['Name'];
                                $Filtro = $auxi['filtro'];
                                break;
                            }
                        }
                        if (isset($nombreCuenta)) {
                            if ($datos = $this->contabilidad_model->getCAuxiliares((int)$auxiliar)) {
                                $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
                                $usuario = $this->session->userdata('userLog');
                                //---------------------------------------   REPORTE  ---------------------------------------
                                $this->load->library('Pdfconta');
                                $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
                                $dataHeader = '
                                    <table style="width=100%; ">
                                        <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                                            <td style="width:10%;"></td>
                                            <td style="width:80%; text-align: center;"><strong>'.$empresa.'</strong></td>
                                            <td style="width:10%;"></td>
                                        </tr>
                                        <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                                            <td style="width:10%;"></td>
                                            <td style="width:80%; text-align: center;"><strong>CUENTA AUXILIAR TIPO '.strtoupper($nombreCuenta).'</strong></td>
                                            <td style="width:10%;"></td>
                                        </tr>
                                        <tr style="line-height: 10px;">
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>';
                                switch ((int)$Filtro) {
                                    case 1:
                                        $dataHeader .= '
                                                <tr style="font-size: 10px; line-height: 15px; text-align: center;">
                                                    <td style="width: 8%; border: 1px solid black"><strong>ID</strong></td>
                                                    <td style="width: 42%; border: 1px solid black"><strong>Titulo</strong></td>
                                                    <td style="width: 19%; border: 1px solid black"><strong>Grupo</strong></td>
                                                    <td style="width: 12%; border: 1px solid black"><strong>NRC</strong></td>
                                                    <td style="width: 18%; border: 1px solid black"><strong>NIT</strong></td>
                                                </tr>
                                            </table>
                                        ';
                                    break;
                                    case 2:
                                    case 4:
                                        $dataHeader .= '
                                                <tr style="font-size: 10px; line-height: 15px; text-align: center;">
                                                    <td style="width: 10%; border: 1px solid black"><strong>ID</strong></td>
                                                    <td style="width: 70%; border: 1px solid black"><strong>Titulo</strong></td>
                                                    <td style="width: 20%; border: 1px solid black"><strong>Grupo</strong></td>
                                                </tr>
                                            </table>
                                        ';
                                    break;
                                    case 3:
                                        $dataHeader .= '
                                                <tr style="font-size: 10px; line-height: 15px; text-align: center;">
                                                    <td style="width: 8%; border: 1px solid black"><strong>ID</strong></td>
                                                    <td style="width: 43%; border: 1px solid black"><strong>Titulo</strong></td>
                                                    <td style="width: 15%; border: 1px solid black"><strong>Grupo</strong></td>
                                                    <td style="width: 19%; border: 1px solid black"><strong>Marca</strong></td>
                                                    <td style="width: 15%; border: 1px solid black"><strong>Modelo</strong></td>
                                                </tr>
                                            </table>
                                        ';
                                    break;
                                }
                                $pdf->setHtmlHeader($dataHeader);
                                date_default_timezone_set('America/El_Salvador');
                                $dataFooter = '
                                    <table style="width=100%; border-top: 1px solid black;">
                                        <tr style="font-size: 10px;">
                                            <td style="width:33%; text-align: left;">'.date_create()->format('d/m/Y H:i:s A').'</td>
                                            <td style="width:34%; text-align: center;">'.$usuario.'</td>
                                            <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                                        </tr>
                                    </table>
                                ';
                                $pdf->setHtmlFooter($dataFooter);
                                $pdf->SetFooterMargin(-15);
                                $pdf->SetCreator(PDF_CREATOR);
                                $pdf->SetTitle('Cuenta Auxiliar-'.$nombreCuenta);
                                $pdf->SetMargins(16, 27, 16);
                                $pdf->SetFont('helvetica', '', 9);
                                $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
                                #   TITULO
                                $html = '';
                                switch ((int)$Filtro) {
                                    case 1:
                                        #   HEADER - LISTADO
                                        $html .= '<table style="width=100%; ">';
                                        #   LISTADO
                                        foreach ($datos as $dato) {
                                            $html .= '
                                            <tr style="font-size: 10px; line-height: 12px; text-align: left; ">
                                                <td style="width: 8%; text-align: center;">'.$dato['id'].'</td>
                                                <td style="width: 42%; ">'.$dato['titulo'].'</td>
                                                <td style="width: 19%; ">'.$dato['grupo'].'</td>
                                                <td style="width: 12%; ">'.$dato['nrc'].'</td>
                                                <td style="width: 18%; ">'.$dato['nit'].'</td>
                                            </tr>';
                                        }
                                    break;
                                    case 2:
                                    case 4:
                                        #   HEADER - LISTADO
                                        $html .= '<table style="width=100%; ">';
                                        #   LISTADO
                                        foreach ($datos as $dato) {
                                            $html .= '
                                            <tr style="font-size: 10px; line-height: 12px; text-align: left; ">
                                                <td style="width: 10%; text-align: center;">'.$dato['id'].'</td>
                                                <td style="width: 70%; ">'.$dato['titulo'].'</td>
                                                <td style="width: 20%; ">'.$dato['grupo'].'</td>
                                            </tr>';
                                        }
                                    break;
                                    case 3:
                                        #   HEADER - LISTADO
                                        $html .= '<table style="width=100%; ">';
                                        #   LISTADO
                                        foreach ($datos as $dato) {
                                            $html .= '
                                            <tr style="font-size: 10px; line-height: 12px; text-align: left; ">
                                                    <td style="width: 8%; text-align: center;">'.$dato['id'].'</td>
                                                <td style="width: 43%; ">'.$dato['titulo'].'</td>
                                                <td style="width: 15%; ">'.$dato['grupo'].'</td>
                                                <td style="width: 19%; ">'.$dato['telefono'].'</td>
                                                <td style="width: 15%; ">'.$dato['correo'].'</td>
                                            </tr>';
                                        }
                                    break;
                                }
                                $html .= '</table>';
                                $pdf->writeHTML($html);
                                //$pdf->writeHTML($html, true, 0, true, 0);
                                $pdf->lastPage();
                                $pdf->Output();
                            } else echo "<h1>Cuenta Auxiliar sin datos</h1>";
                        } else echo "<h1>Auxiliar no definido</h1>";
                    } else echo "<h1>No hay Auxiliares</h1>";
                } else echo "<h1>Parámetro Incorrecto</h1>";
            } else echo "<h1>Falta Parámetro Auxiliar</h1>";
        }
    }
    #   REPORTE DE CUENTAS AUXILIARES
    #-------------------------------------------------------------- TIPOS AUXILIAR
    public function indexTA()
    {
        if($this->validatePermiso()) {
            $resultAppName = array(
                'namePage' => 'Tipos de Auxiliares'//$this->session->userdata('appName')
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->load->view("mantenimiento_TAuxiliares", $this->data);
        }
    }
    public function loadTAuxis()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                if ($datos = $this->contabilidad_model->loadTAuxis()) {
                    $Datos = null;
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $filtros = array(
                                'Personas' => 1,
                                'Cajas / Bancos' => 2,
                                'Activos Fijos' => 3,
                                'Gastos' => 4,
                            );
                            $filtros = array_search($dato->filtro, $filtros);
                            $Datos[] =  array(
                                'ID' => $dato->idrnum,
                                'titulo' => ' '.$dato->descripcion,
                                'valorN' => $dato->valor_num,
                                'filtro' => $dato->filtro,
                                'filtros' => $filtros
                            );
                        }
                    }
                    //$datA[] = array('valido' => true);
                    $datA = $Datos;
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    public function setTAuxis()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d H:i:s');

                $valorn = $this->contabilidad_model->lastValor_num();
                $valorn = ($valorn >= 10) ? ($valorn + 1) : 10;
                $titulo = $this->input->post("titulo");
                $tipo = (int)$this->input->post("tipo");
                $data = array(
                    'descripcion' => $titulo,
                    'valor_num' => $valorn,
                    'filtro' => $tipo,
                    'tipo_valor' => 1,
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => $ahora
                );
                /*print_r($this->input->post());
                die();//*/
                $datA[] = array('valido' => ($this->contabilidad_model->setTAuxis($data)) ? true : false);
                echo json_encode($datA);
            } else show_404();
        }
    }
    public function getTAuxi()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $ID = $this->input->post("ID");
                $dato = $this->contabilidad_model->getTAuxi($ID);
                $datA[] = array('valido' => ($dato) ? true: false, 'dato' => $dato);
                echo json_encode($datA);
            } else show_404();
        }
    }
    public function updateTAuxis()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d H:i:s');
                $ID = $this->input->post("ID");
                $titulo = $this->input->post("titulo");
                $tipo = (int)$this->input->post("tipo");
                $data = array(
                    'descripcion' => $titulo,
                    'filtro' => $tipo,
                    'modifica' => $ahora
                );
                /*print_r($data);
                die();//*/
                $datA[] = array('valido' => ($this->contabilidad_model->updateTAuxis($data, $ID)) ? true : false);
                echo json_encode($datA);
            } else show_404();
        }
    }
    #-------------------------------------------------------------- FIN TIPOS AUXILIAR
    #-------------------------------------------------------------- EXCEL 
    public function indexCAuxiliaresX($Auxi = null)
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $auxis = $this->contabilidad_model->loadAuxis();
            if ($auxis != null) {
                foreach ($auxis as $auxi) {
                    if ($auxi['ID'] == $Auxi) {
                        $nombreCuenta = ucfirst(strtolower($auxi['Name']));
                        $Filtro = $auxi['filtro'];
                        break;
                    }
                }
                if (isset($nombreCuenta)) {
                    //- app
                    $resultAppName = array(
                        'namePage' => 'Importación De '.$this->session->userdata('appName').' - '.$nombreCuenta
                    );
                    $this->session->set_userdata($resultAppName);
                    $direccion = $this->uri->segment(1);
                    $this->load->model('global_model');
                    $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                    //-
                    $otro = array(
                        'ID' => $Auxi,
                        'nombre' => $nombreCuenta,
                        'filtro' => $Filtro
                    );
                    $this->data['Auxiliar'] = $otro;
                    $this->load->view("mantenimiento_CAuxiliaresX", $this->data);
                } else echo "<h1>Tipo de Auxiliar no existe</h1>";
            } else echo "<h1>No hay Tipos de Auxiliares</h1>";
        }
    }
    public function LeerCAuxiliares()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
                //  Read your Excel workbook
                try {
                    $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                $this->load->model('contabilidad_model');
                //date_default_timezone_set('America/El_Salvador');
                //  Get worksheet dimensions
                $objPHPExcel->setActiveSheetIndex(0); 
                $sheet = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();
                //echo $highestRow."--".$highestColumn;
                $ID = $this->input->post("ID");
                $filtro = (int)$this->input->post("filtro");
                $contribuyentes =  array(
                    1 => 'Pequeño',
                    2 => 'Mediano',
                    3 => 'Grande',
                    4 => 'Otro'
                );
                /*$this->contabilidad_model->getEPDMov(null);
                //die();//*/

                switch ($filtro) {
                    case 1:
                        if ($highestRow > 1) {
                            $grupos = $this->contabilidad_model->getDataCA(1, null, $ID);
                            if ($grupos->num_rows() > 0) {
                                for ($row = 2; $row <= $highestRow; $row++){
                                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
                                    $mjs = "Lin.".$row."-";
                                    $error = 0;
                                    
                
                                    $grupoTx = ucfirst(strtolower((string)$rowData[0][0]));
                                    $cont = 0;
                                    foreach ($grupos->result() as $value) {
                                        if (ucfirst(strtolower($value->grupo)) == $grupoTx) {
                                            $grupoTx = $value->grupo;
                                            $cont++;
                                            break;
                                        }
                                    }
                                    $titulo = trim((string)$rowData[0][1]);
                                    $telefono = (string)$rowData[0][2];
                                    $correo = (string)$rowData[0][3];
                                    $direccion = (string)$rowData[0][4];

                                    $dui = (string)$rowData[0][5];
                                    $nit = (string)$rowData[0][6];

                                    $actividad = (string)$rowData[0][7];
                                    $tipoTx = ucfirst(strtolower(trim((string)$rowData[0][8])));
                                    $tipo = array_search($tipoTx, $contribuyentes);
                                    $limite = (int)$rowData[0][9];
                                    $dias = (int)$rowData[0][10];
                                    $xpos = (string)$rowData[0][11];

                                    if($cont == 0){
                                        $error++;
                                        $mjs .= "Grupo no existe";
                                    }
                                    if (strlen($titulo) == 0) {
                                        $error++;
                                        $mjs .= "Sin titulo";
                                    }

                                    $valor = preg_match("/^([0-9]){4}+(-?)+([0-9]){4}+$/", $telefono);
                                    if (!$valor) {
                                        $error++;
                                        $mjs .= "Teléfono mal escrito";
                                    }

                                    $valor = $correo;
                                    if (!filter_var($valor, FILTER_VALIDATE_EMAIL) && (strlen($valor) > 0)) {
                                        $error++;
                                        $mjs .= "Correo inválido";
                                    }
                                    if ($limite < 0) {
                                        $error++;
                                        $mjs .= "Límite negativo";
                                    }
                                    if ($dias < 0) {
                                        $error++;
                                        $mjs .= "Días negativo";
                                    }
                                    if (strlen($tipoTx) > 0 && $tipo == false) {
                                        $error++;
                                        $mjs .= "Tipo contribuyente inválido";
                                    }

                                    $Datos[] = array(
                                        'grupo'=> $grupoTx,
                                        'titulo' => $titulo,
                                        'telefono' => $telefono,
                                        'correo' => $correo,
                                        'direccion' => $direccion,
                                        'dui' => $dui,
                                        'nit' => $nit,
                                        'actividad' => $actividad,
                                        'tipoTx' => $tipoTx,
                                        'tipo' => $tipo,
                                        'limite' => $limite,
                                        'dias' => $dias,
                                        'xpos' => $xpos,

                                        'error' => $error,
                                        'comentario' => $mjs
                                    );
                                }
                                echo json_encode(array('valido' => true, 'datos' => $Datos));
                            } else echo json_encode(array('valido' => false, 'tipo' => 1));
                        } else echo json_encode(array('valido' => false, 'tipo' => 0));
                    break;
                    case 2:
                        if ($highestRow > 1) {
                            $grupos = $this->contabilidad_model->getDataCA(1, null, $ID);
                            if ($grupos->num_rows() > 0) {
                                for ($row = 2; $row <= $highestRow; $row++){
                                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
                                    $mjs = "Lin.".$row."-";
                                    $error = 0;

                                    $grupoTx = ucfirst(strtolower((string)$rowData[0][0]));
                                    $cont = 0;
                                    foreach ($grupos->result() as $value) {
                                        if (ucfirst(strtolower($value->grupo)) == $grupoTx) {
                                            $grupoTx = $value->grupo;
                                            $cont++;
                                            break;
                                        }
                                    }
                                    $titulo = trim((string)$rowData[0][1]);
                                    $telefono = trim((string)$rowData[0][2]);
                                    $correo = trim((string)$rowData[0][3]);
                                    $direccion = (string)$rowData[0][4];
                                    $xpos = trim((string)$rowData[0][5]);

                                    if($cont == 0){
                                        $error++;
                                        $mjs .= "Grupo no existe ";
                                    }
                                    if (strlen($titulo) == 0) {
                                        $error++;
                                        $mjs .= "Sin titulo ";
                                    }
                                    if (strlen($telefono) > 0) {
                                        $valor = preg_match("/^([0-9]){4}+(-?)+([0-9]){4}+$/", $telefono);
                                        if (!$valor) {
                                            $error++;
                                            $mjs .= "Teléfono mal escrito ";
                                        }
                                    }
                                    $valor = $correo;
                                    if (!filter_var($valor, FILTER_VALIDATE_EMAIL) && (strlen($valor) > 0)) {
                                        $error++;
                                        $mjs .= "Correo inválido ";
                                    }

                                    $Datos[] = array(
                                        'grupo'=> $grupoTx,
                                        'titulo' => $titulo,
                                        'telefono' => $telefono,
                                        'correo' => $correo,
                                        'direccion' => $direccion,
                                        'xpos' => $xpos,

                                        'error' => $error,
                                        'comentario' => $mjs
                                    );
                                }
                                echo json_encode(array('valido' => true, 'datos' => $Datos));
                            } else echo json_encode(array('valido' => false, 'tipo' => 1));
                        } else echo json_encode(array('valido' => false, 'tipo' => 0));
                    break;
                    case 3:
                        if ($highestRow > 1) {
                            $grupos = $this->contabilidad_model->getDataCA(1, null, $ID);
                            if ($grupos->num_rows() > 0) {
                                for ($row = 2; $row <= $highestRow; $row++){
                                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
                                    $mjs = "Lin.".$row."-";
                                    $error = 0;
                                    $grupoTx = ucfirst(strtolower((string)$rowData[0][0]));
                                    $giro = trim((string)$rowData[0][1]);
                                    $titulo = trim((string)$rowData[0][2]);
                                    $telefono = trim((string)$rowData[0][3]);
                                    $correo = trim((string)$rowData[0][4]);
                                    $dui = trim((string)$rowData[0][5]);
                                    $limite = (int)$rowData[0][6];
                                    $fechain = trim((string)$rowData[0][7]);
                                    $fechain = PHPExcel_Style_NumberFormat::toFormattedString($fechain, "YYYY-MM-DD");
                                    $nit = trim((string)$rowData[0][8]);
                                    
                                    $cont = 0;
                                    foreach ($grupos->result() as $value) {
                                        if (ucfirst(strtolower($value->grupo)) == $grupoTx) {
                                            $grupoTx = $value->grupo;
                                            $cont++;
                                            break;
                                        }
                                    }
                                    if($cont == 0){
                                        $error++;
                                        $mjs .= "Clasificación no existe";
                                    }
                                    if (strlen($titulo) == 0) {
                                        $error++;
                                        $mjs .= "Sin titulo";
                                    }
                                    if ($limite < 0) {
                                        $error++;
                                        $mjs .= "Valor de adquisición negativo";
                                    }
                                    if (strlen($fechain) > 0) {
                                        //$valor = preg_match("/^([0-9]){2}+(\/)+([0-9]){2}+(\/)+([0-9]){4}+$/", $fechain);
                                        $valor = preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechain);
                                        if (!$valor) {
                                            $error++;
                                            $mjs .= "Fecha mal escrita";
                                        }else{
                                            $fec = explode("-", $fechain);
                                            //print_r($fec);
                                            // mes dia año
                                            if (!checkdate($fec[1], $fec[2], $fec[0])) {
                                                $error++;
                                                $mjs .= "Fecha no existe";
                                            }
                                        }
                                    }

                                    $Datos[] = array(
                                        'grupo'=> $grupoTx,
                                        'giro'=> $giro,
                                        'titulo' => $titulo,
                                        'telefono' => $telefono,
                                        'correo' => $correo,
                                        'dui' => $dui,
                                        'limite' => $limite,
                                        'fecha' => $fechain,
                                        'nit' => $nit,
                                        'xpos' => '',

                                        'error' => $error,
                                        'comentario' => $mjs
                                    );
                                }
                                echo json_encode(array('valido' => true, 'datos' => $Datos));
                            } else echo json_encode(array('valido' => false, 'tipo' => 1));
                        } else echo json_encode(array('valido' => false, 'tipo' => 0));
                    break;
                    case 4:
                        if ($highestRow > 1) {
                            $grupos = $this->contabilidad_model->getDataCA(1, null, $ID);
                            if ($grupos->num_rows() > 0) {
                                for ($row = 2; $row <= $highestRow; $row++){
                                    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
                                    $mjs = "Lin.".$row."-";
                                    $error = 0;

                                    $grupoTx = ucfirst(strtolower((string)$rowData[0][0]));
                                    $cont = 0;
                                    foreach ($grupos->result() as $value) {
                                        if (ucfirst(strtolower($value->grupo)) == $grupoTx) {
                                            $grupoTx = $value->grupo;
                                            $cont++;
                                            break;
                                        }
                                    }
                                    $titulo = trim((string)$rowData[0][1]);
                                    $xpos = trim((string)$rowData[0][2]);

                                    if($cont == 0){
                                        $error++;
                                        $mjs .= "Grupo no existe ";
                                    }
                                    if (strlen($titulo) == 0) {
                                        $error++;
                                        $mjs .= "Sin titulo ";
                                    }

                                    $Datos[] = array(
                                        'grupo'=> $grupoTx,
                                        'titulo' => $titulo,
                                        'xpos' => $xpos,

                                        'error' => $error,
                                        'comentario' => $mjs
                                    );
                                }
                                echo json_encode(array('valido' => true, 'datos' => $Datos));
                            } else echo json_encode(array('valido' => false, 'tipo' => 1));
                        } else echo json_encode(array('valido' => false, 'tipo' => 0));
                    break;
                }
            }
        }
    }
    public function FormatoCAuxiliares($Filtro) {
        if($this->validatePermiso()) {
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            //require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
            $objPHPExcel    =   new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $default_border = array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb'=>'1006A3')
            );
            $style_header = array(
                'borders' => array(
                    'bottom' => $default_border,
                    'left' => $default_border,
                    'top' => $default_border,
                    'right' => $default_border,
                ),
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb'=>'E1E0F7'),
                ),
                'font' => array(
                    'bold' => true,
                'size' => 12,
                )
            );
            switch ($Filtro) {
                case 1:
                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(25);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);
        
                    $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Grupo');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Titulo / Nombre');
                    $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Teléfono');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Correo');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Direccion');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'DUI / NRC');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'NIT');

                    $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Act. Económica');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Tipo de Contribuyente');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Limite');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Días');
                    $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Xpos');
                    //$objPHPExcel->getActiveSheet()->getStyle("A1:H1")->getFont()->setBold(true);
                    $objPHPExcel->getActiveSheet()->getStyle("A1:L1")->applyFromArray( $style_header );
                break;
                case 2:
                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(40);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
        
                    $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Grupo');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Titulo / Nombre');
                    $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Teléfono');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Correo');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Direccion');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Xpos');
                    //$objPHPExcel->getActiveSheet()->getStyle("A1:H1")->getFont()->setBold(true);
                    $objPHPExcel->getActiveSheet()->getStyle("A1:F1")->applyFromArray( $style_header );
                break;
                case 3:
                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(40);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
        
                    $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Clasificación');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Sub-Clasificación');
                    $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Titulo / Nombre');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Marca');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Modelo');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Serie');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Valor Adquisición');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Fecha de Compra');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Tag #');
                    //$objPHPExcel->getActiveSheet()->getStyle("A1:H1")->getFont()->setBold(true);
                    $objPHPExcel->getActiveSheet()->getStyle("A1:I1")->applyFromArray( $style_header );
                break;
                case 4:
                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(50);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
        
                    $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Grupo');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Titulo / Nombre');
                    $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Xpos');
                    //$objPHPExcel->getActiveSheet()->getStyle("A1:H1")->getFont()->setBold(true);
                    $objPHPExcel->getActiveSheet()->getStyle("A1:C1")->applyFromArray( $style_header );
                break;
            }
            $objWriter  =   new PHPExcel_Writer_Excel2007($objPHPExcel);
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="Formato_Cuentas_Auxiliares.xlsx"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');  
            $objWriter->save('php://output');
        }
    }
    /*public function ExcelCAuxiliares1()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
                
            date_default_timezone_set('America/El_Salvador');
            $ahora = date_create()->format('Y-m-d H:i:s');
            $Filtro = (int)$this->input->post('filtro');
            $ID = $this->input->post('ID');
            $conteo = 0;
            $mensaje = "";
            
            $valores = $this->input->post('valores');
            foreach ($valores as $valor) {
                $data = array(
                    'descrip' => $valor['titulo'],
                    'idauxidef' => $ID,
                    'grupo' => $valor['grupo'],

                    'xpos' => $valor['xpos'],
                    'estado' => 1,
                    'whodidit' => $this->session->userdata('iduser'), 
                    'ingresa' => $ahora,
                );
                switch ($Filtro) {
                    case 1:
                        $data['telefono'] = $valor['telefono'];
                        $data['correo'] = $valor['correo'];
                        $data['direccion'] = $valor['direccion'];
                        $data['nrc'] = $valor['dui'];
                        $data['nit'] = $valor['nit'];
                        $data['fechain'] = substr($ahora, 0, 10);
                        $data['giro'] = $valor['actividad'];
                        $data['limite'] = $valor['limite'];
                        $data['dias'] = $valor['dias'];
                        $data['idtipo'] = $valor['tipo'];
                    break;
                    case 2:
                        $data['telefono'] = $valor['telefono'];
                        $data['correo'] = $valor['correo'];
                        $data['direccion'] = $valor['direccion'];
                    break;
                    case 3:
                        $data['giro'] = $valor['giro'];
                        $data['telefono'] = $valor['telefono'];
                        $data['correo'] = $valor['correo'];
                        $data['nrc'] = $valor['dui'];
                        $data['nit'] = $valor['nit'];
                        $data['limite'] = $valor['limite'];
                        $data['fechain'] = $valor['fecha'];
                    break;
                    case 4:
                    break;
                }
                //$conteo++;
                //print_r($data);
                if ($this->contabilidad_model->setCA($data)){
                    $conteo++;
                } else{
                    $mensaje .= $valor['titulo'];
                }
            }
            echo json_encode(array(
                'valido' => ($conteo > 0) ? true : false,
                'mensaje' => $mensaje
            ));
        }
    }//*/
    public function ExcelCAuxiliares() {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            require_once APPPATH . 'libraries/Classes/PHPExcel/IOFactory.php';
            //  Read your Excel workbook
            try {
                $inputFileType = PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);
            } catch(Exception $e) {
                die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
            }
            $this->load->model('contabilidad_model');
            //date_default_timezone_set('America/El_Salvador');
            //  Get worksheet dimensions
            $objPHPExcel->setActiveSheetIndex(0); 
            $sheet = $objPHPExcel->setActiveSheetIndex(0);
            $highestRow = $sheet->getHighestRow(); 
            $highestColumn = $sheet->getHighestColumn();
            //echo $highestRow."--".$highestColumn;
                
            date_default_timezone_set('America/El_Salvador');
            $ahora = date_create()->format('Y-m-d H:i:s');
            $Filtro = (int)$this->input->post('filtro');
            $ID = $this->input->post('ID');
            $contribuyentes =  array(
                1 => 'Pequeño',
                2 => 'Mediano',
                3 => 'Grande',
                4 => 'Otro'
            );
            $conteo = 0;
            $mensaje = "";
            for ($row = 2; $row <= $highestRow; $row++){
                $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
                switch ($Filtro) {
                    case 1:
                        $grupos = $this->contabilidad_model->getDataCA(1, null, $ID);
                        $grupoTx = ucfirst(strtolower((string)$rowData[0][0]));
                        foreach ($grupos->result() as $value) {
                            if (ucfirst(strtolower($value->grupo)) == $grupoTx) {
                                $grupoTx = $value->grupo;
                                break;
                            }
                        }
                        $titulo = trim((string)$rowData[0][1]);
                        $telefono = (string)$rowData[0][2];
                        $correo = (string)$rowData[0][3];
                        $direccion = (string)$rowData[0][4];

                        $dui = (string)$rowData[0][5];
                        $nit = (string)$rowData[0][6];

                        $actividad = (string)$rowData[0][7];
                        $tipoTx = ucfirst(strtolower(trim((string)$rowData[0][8])));
                        $tipo = array_search($tipoTx, $contribuyentes);
                        $limite = (int)$rowData[0][9];
                        $dias = (int)$rowData[0][10];
                        $xpos = (string)$rowData[0][11];
                        $data = array(
                            'descrip' => $titulo,
                            'idauxidef' => $ID,
                            'grupo' => $grupoTx,
                            'xpos' => $xpos,
                            'estado' => 1,
                            'whodidit' => $this->session->userdata('iduser'), 
                            'ingresa' => $ahora,
                        );
                        $data['telefono'] = $telefono;
                        $data['correo'] = $correo;
                        $data['direccion'] = $direccion;
                        $data['nrc'] = $dui;
                        $data['nit'] = $nit;
                        $data['fechain'] = substr($ahora, 0, 10);
                        $data['giro'] = $actividad;
                        $data['limite'] = $limite;
                        $data['dias'] = $dias;
                        $data['idtipo'] = $tipo;
                    break;
                    case 2:
                        $grupos = $this->contabilidad_model->getDataCA(1, null, $ID);
                        $grupoTx = ucfirst(strtolower((string)$rowData[0][0]));
                        $titulo = trim((string)$rowData[0][1]);
                        $telefono = trim((string)$rowData[0][2]);
                        $correo = trim((string)$rowData[0][3]);
                        $direccion = (string)$rowData[0][4];
                        $xpos = trim((string)$rowData[0][5]);
                        foreach ($grupos->result() as $value) {
                            if (ucfirst(strtolower($value->grupo)) == $grupoTx) {
                                $grupoTx = $value->grupo;
                                break;
                            }
                        }
                        $data = array(
                            'descrip' => $titulo,
                            'idauxidef' => $ID,
                            'grupo' => $grupoTx,
                            'xpos' => $xpos,
                            'estado' => 1,
                            'whodidit' => $this->session->userdata('iduser'), 
                            'ingresa' => $ahora,
                        );
                        $data['telefono'] = $telefono;
                        $data['correo'] = $correo;
                        $data['direccion'] = $direccion;
                    break;
                    break;
                    case 3:
                        $grupos = $this->contabilidad_model->getDataCA(1, null, $ID);
                        $grupoTx = ucfirst(strtolower((string)$rowData[0][0]));
                        $giro = trim((string)$rowData[0][1]);
                        $titulo = trim((string)$rowData[0][2]);
                        $telefono = trim((string)$rowData[0][3]);
                        $correo = trim((string)$rowData[0][4]);
                        $dui = trim((string)$rowData[0][5]);
                        $limite = (int)$rowData[0][6];
                        $fechain = trim((string)$rowData[0][7]);
                        $fechain = PHPExcel_Style_NumberFormat::toFormattedString($fechain, "YYYY-MM-DD");
                        $nit = trim((string)$rowData[0][8]);
                        foreach ($grupos->result() as $value) {
                            if (ucfirst(strtolower($value->grupo)) == $grupoTx) {
                                $grupoTx = $value->grupo;
                                break;
                            }
                        }
                        $data = array(
                            'descrip' => $titulo,
                            'idauxidef' => $ID,
                            'grupo' => $grupoTx,
                            'xpos' => $xpos,
                            'estado' => 1,
                            'whodidit' => $this->session->userdata('iduser'), 
                            'ingresa' => $ahora,
                        );
                        $data['giro'] = $giro;
                        $data['telefono'] = $telefono;
                        $data['correo'] = $correo;
                        $data['nrc'] = $dui;
                        $data['nit'] = $nit;
                        $data['limite'] = $limite;
                        $data['fechain'] = $fechain;
                    break;
                    case 4:
                        $grupos = $this->contabilidad_model->getDataCA(1, null, $ID);
                        $grupoTx = ucfirst(strtolower((string)$rowData[0][0]));
                        $titulo = trim((string)$rowData[0][1]);
                        $xpos = trim((string)$rowData[0][2]);
                        foreach ($grupos->result() as $value) {
                            if (ucfirst(strtolower($value->grupo)) == $grupoTx) {
                                $grupoTx = $value->grupo;
                                break;
                            }
                        }
                        $data = array(
                            'descrip' => $titulo,
                            'idauxidef' => $ID,
                            'grupo' => $grupoTx,
                            'xpos' => $xpos,
                            'estado' => 1,
                            'whodidit' => $this->session->userdata('iduser'), 
                            'ingresa' => $ahora,
                        );
                    break;
                }
                //print_r($data);
                if ($this->contabilidad_model->setCA($data)){
                    $conteo++;
                } else{
                    $mensaje .= $valor['titulo'];
                }//*/
            }
            echo json_encode(array(
                'valido' => ($conteo > 0) ? true : false,
                'mensaje' => $mensaje
            ));
        }
    }
    #-------------------------------------------------------------- FIN EXCEL
    #----------------------CA-------------------------     FIN CUENTAS AUXILIARES -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     PROYECTOS -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function indexProyectos($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);

            $direccion = $this->uri->segment(1);

            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->load->view("mantenimiento_Proyectos", $this->data);
        }
    }
    #   GET PROYECTOS
    public function getProyectos()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                echo json_encode($this->contabilidad_model->getProyectos());
                //print_r($this->session->userdata());
            } else show_404();
        }
    }
    #   FIN GET PROYECTOS
    #   GET PROYECTOS - CLIENTES
    public function getPClientes()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                if ($datos = $this->contabilidad_model->getPClientes()) {
                    //------------------------------------------------------------------------------------------------
                    #   GET CUENTA POR ID
                    if ($ID = $this->input->post("ID")) {
                        if ($dato = $this->contabilidad_model->getProyecto((int)$ID)) {
                
                            $datA[] = array('valido' => true);
                            $datA[] = $datos;
                            $datA[] = $dato;
                        } else {
                            $datA[] = array('valido' => false);
                            $datA[] = array('mjs' => "error al traer Proyecto");
                        }
                    } else {
                        $datA[] = array('valido' => true);
                        $datA[] = $datos;
                    }
                    //------------------------------------------------------------------------------------------------                    
                } else {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al traer clientes");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN GET PROYECTOS - CLIENTES
    #   SET PROYECTOS
    public function setProyecto()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d H:i:s');
                $data = array(
    
                    'descrip' => $this->input->post("descripcion"),
                    
                    'idcps' => (int)$this->input->post("cliente"),
                    'fechaini' => $this->input->post("fi"),
                    'fechafin' => $this->input->post("ff"),
                    
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post("estado") == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),

                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => $ahora
                );
                //print_r($data);
                //die();
                $resultado = $this->contabilidad_model->setProyecto($data);
                if ($resultado){
                    if($this->input->post('xpos') == 1){
                        $this->contabilidad_model->setProyectoPredeterminado($resultado);
                    }

                    $datos = $this->contabilidad_model->getProyectos();
                    $datA[] = array('valido' => true);
                    $datA[] = $datos;
                }
                else{
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al guardar");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN SET PROYECTOS
    #   UPDATE PROYECTO
    public function updateProyecto()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $modifica = date_create()->format('Y-m-d H:i:s');
                $ID = $this->input->post("ID");
                $data = array(
                    'descrip' => $this->input->post("descripcion"),
                    
                    'idcps' => (int)$this->input->post("cliente"),
                    'fechaini' => $this->input->post("fi"),
                    'fechafin' => $this->input->post("ff"),
                    
                    'xpos' => $this->input->post('xpos'),
                    'estatus' => ($this->input->post("estado") == "true") ? 1 : 0,
                    'notas' => $this->input->post('notas'),

                    'modifica' => $modifica
                );
                if ($this->contabilidad_model->updateProyecto($data, $ID)) {
                    if($this->input->post('xpos') == 1){
                        $this->contabilidad_model->setProyectoPredeterminado($ID);
                    }
                    $datos = $this->contabilidad_model->getProyectos();
                    $datA[] = array('valido' => true);
                    $datA[] = $datos;
                } else {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al actualizar");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN UPDATE PROYECTO
    #   REPORTE DE PROYECTOS
    public function RProyectos()
    {
        if($this->validatePermiso()) {
            $this->load->library('Pdf');
            $this->load->model('contabilidad_model');
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $usuario = $this->session->userdata('userLog');
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $dataHeader = '
                <table style="width=100%; ">
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width:10%;"></td>
                        <td style="width:80%; text-align: center;"><strong>'.$empresa.'</strong></td>
                        <td style="width:10%;"></td>
                    </tr>
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width:10%;"></td>
                        <td style="width:80%; text-align: center;"><strong>PROYECTOS</strong></td>
                        <td style="width:10%;"></td>
                    </tr>
                    <tr style="line-height: 10px;">
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr style="font-size: 10px; line-height: 15px; text-align: center;">
                        <td style="width: 8%; border: 1px solid black"><strong>ID</strong></td>
                        <td style="width: 34%; border: 1px solid black"><strong>Nombre del Proyecto</strong></td>
                        <td style="width: 34%; border: 1px solid black"><strong>Cliente</strong></td>
                        <td style="width: 12%; border: 1px solid black"><strong>Inicia</strong></td>
                        <td style="width: 12%; border: 1px solid black"><strong>Finaliza</strong></td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlHeader($dataHeader);
            date_default_timezone_set('America/El_Salvador');
            $dataFooter = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="font-size: 10px;">
                        <td style="width:33%; text-align: left;">'.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;">'.$usuario.'</td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($dataFooter);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Proyectos');
            $pdf->SetMargins(16, 27, 16);
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
            $html = '';
            $html .= '<table style="width=100%; ">';
            $datos = $this->contabilidad_model->getProyectos();
            if ($datos != null) {
                foreach ($datos as $dato) {
                    $html .= '
                        <tr style="font-size: 10px; line-height: 12px; text-align: left; ">
                            <td style="width: 8%; text-align: center;">'.$dato['id'].'</td>
                            <td style="width: 34%; ">'.$dato['titulo'].'</td>
                            <td style="width: 34%; ">'.$dato['cliente'].'</td>
                            <td style="width: 12%; text-align: center;">'.$dato['inicia'].'</td>
                            <td style="width: 12%; text-align: center;">'.$dato['finaliza'].'</td>
                        </tr>';
                }
                //(new DateTime($fechai))->format('d/m/Y')
            }
            $html .= '</table>';
            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }
    #   REPORTE DE PROYECTOS
    #------------------------------------------------------     FIN PROYECTOS ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     EDITOR DE PARTIDAS ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function indexEPartidas($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);

            $direccion = $this->uri->segment(1);

            $this->load->model('global_model');
            $this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos']    = $this->configuracion_model->getApps($idApp);
            $this->data['numPartidas'] = $this->global_model->getValorNumVariable('ct_numpartidas');
            $this->load->view("mantenimiento_Editor_Partidas", $this->data);
        }
    }
    #   LOAD AÑOS
    public function loadYears()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $datos = $this->contabilidad_model->loadYears();
                echo json_encode($datos);
            } else show_404();
        }
    }
    #   GET EDITOR DE PARTIDAS
    public function getEPartidas()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                if (!$year = $this->input->post("year")) {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "falta variable año");
                } else {
                    if (!$month = $this->input->post("month")) {
                        $datA[] = array('valido' => false);
                        $datA[] = array('mjs' => "falta variable año");
                    } else {
                        if ($datos = $this->contabilidad_model->getEPartidas($year, $month)) {
                            $datA[] = array('valido' => true);
                            $datA[] = $datos;
                        }else{
                            $datA[] = array('valido' => false);
                            $datA[] = array('mjs' => "sin datos");
                        }
                    }
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   GET TIPOS DE PARTIDA TO EDIT
    public function getTPartidasEdit()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                
                /*if (!$year = $this->input->post("year")) {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "falta variable año");
                } else {
                }*/
                if (!$month = $this->input->post("month")) {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "falta variable año");
                } else {
                    $datos = $this->contabilidad_model->getTPartidasEdit($month);
                    $datA[] = array('valido' => true);
                    $datA[] = $datos;
                    /*if ($datos = $this->contabilidad_model->getTPartidasEdit($month)) {
                        $datA[] = array('valido' => true);
                        $datA[] = $datos;
                    } else $datA[] = array('valido' => false);//*/
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   SET EDITOR DE PARTIDAS
    public function setEPartidas()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $year = $this->input->post("year");

                $month = $this->input->post("month");
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d H:i:s');

                $data = array(
                    'idyear' => (int)$year,
                    'idptipo' => (int)$this->input->post("tipoP"),
                    'idsite' => (int)$this->session->userdata('idcentrouser'),
                    'descrip' => $this->input->post("descripcion"),
                    'fecha' => $this->input->post("fecha"),

                    'referencia' => $this->input->post("referencia"),
                    'origen' => "Editor de Partidas",
                                        
                    'estatus' => 0,
                    'chg_log' => $ahora.",".$this->session->userdata('iduser').",Inserción;",
                    'notas' => $this->input->post('notas'),

                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => $ahora
                );
                //print_r($data);
                //die();
                if ($valor = $this->contabilidad_model->setEPartidas($data)){
                    $datA[] = array('valido' => true, 'numero' => $valor);
                }
                else{
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al guardar");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   GET EDITOR DE PARTIDA
    public function getEPartida()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $ID = $this->input->post("ID");
                if ($dato = $this->contabilidad_model->getEPartida($ID)) {
                    $datA[] = array('valido' => true, 'dato' => $dato);
                } else {
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "sin datos");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   UPDATE EDITOR DE PARTIDA
    public function updateEPartida()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $modifica = date_create()->format('Y-m-d H:i:s');
                $ID = $this->input->post("ID");
                $data = array(
                    'descrip' => $this->input->post("descripcion"),
                    'fecha' => $this->input->post("fecha"),
                    'referencia' => $this->input->post('referencia'),
                    'chg_log' => $this->contabilidad_model->getHistoricoEP($ID).$modifica.",".$this->session->userdata('iduser').",Actualización;",
                    'modifica' => $modifica
                );
                if ($this->contabilidad_model->updateEPartida($data, $ID)){
                    
                    //$datos = $this->contabilidad_model->getProyectos();
                    $datA[] = array('valido' => true, 'datos' => $data);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   MUILTI OPCIONES EDITOR PARTIDAS
    public function multiEPartida()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $opcion = (int)$this->input->post('opcion');
            switch ($opcion) {
                #   ADD/REMOVE FAVORITOS
                case 0:    
                    date_default_timezone_set('America/El_Salvador');
                    $ID = $this->input->post("ID");
                    $fav = ((int)$this->input->post('fav') == 0) ? 1 : 0;
                    $data = array(
                        'idsite' => $fav,
                        //'chg_log' => $this->contabilidad_model->getHistoricoEP($ID).date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Actualización;",
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s')
                    );
                    if ($this->contabilidad_model->updateEPartida($data, $ID)){
                        $datA[] = array('valido' => true, 'fav' => $fav);
                    } else $datA[] = array('valido' => false);
                break;
            }
            echo json_encode($datA);
        }
    }
    #------------------------------------------------------     EDITOR DE PARTIDAS  DETALLE
    #   EDITOR PARTIDAS DETALLE
    public function indexEPDetalle($id = null)
    {
        if($this->validatePermiso()) {
            if ($id != null) {
                if (is_numeric($id)) {
                    $this->load->model('contabilidad_model');
                    $this->load->model('variable_model');

                    if ($datao = $this->contabilidad_model->getEPDetalle((int)$id)) {
                        $resultAppName = array(
                            'namePage' => 'Detalle '.$this->session->userdata('appName')
                        );
                        $this->session->set_userdata($resultAppName);
                        $direccion = $this->uri->segment(1);
                        $this->load->model('global_model');
                        $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                        //--------------------------------------------------------------------------------------------------
                        //print_r($datao);
                        $idtab = 0;
                        $opcionesTabs = [];
                        if ((strlen($datao->debe_ct) > 0 || strlen($datao->haber_ct) > 0) && $datao->assisted_entry == 1) {
                            $opcionesTabs[] = array(
                                'id' => $idtab,
                                'text' => 'Asistente Contable',
                                'tipo' => 0
                            );
                            $idtab++;
                        }
                        $Cuentas = null;
                        $cuentas = $this->contabilidad_model->getCuentas3();
                        if ($cuentas->num_rows() > 0) {
                            foreach ($cuentas->result() as $cuenta) {
                                $permiso = $this->multiplesContabilidad(1, $cuenta->allowed_users);
                                $Cuentas[] = array(
                                    'ID' => $cuenta->idctcuenta,
                                    'Name' => $cuenta->descrip,
                                    'IDR' => $cuenta->idrec,
                                    'Grupo' => $cuenta->catgrupo,
                                    'Control' => $cuenta->ctcontrol,
                                    'Auxi'=> $cuenta->useauxi,
                                    'Centro' => $cuenta->askidcentro,
                                    'Proyecto' => $cuenta->askidproyecto,
                                    'permiso' => $permiso,
                                );
                            }
                        }
                        $opcionesTabs[] = array(
                            'id' => $idtab,
                            'text' => 'Catálogo de Cuentas',
                            'tipo' => 1
                        );
                        $fechaPartes = explode("-", $datao->fecha);
                        $periodo = $this->contabilidad_model->getPeriodoM($datao->idyear);
                        switch ($fechaPartes[1]) {
                            //meses
                            case '01':
                                /*if ($fechaPartes[2] == '01') $datao->permiso = ($periodo->mes00 == 0) ? false : true;
                                else $datao->permiso = ($periodo->mes01 == 0) ? false : true;//*/
                                $datao->permiso = (bool)$periodo->mes01;
                            break;
                            case '02':
                                $datao->permiso = ($periodo->mes02 == 0) ? false : true;
                            break;
                            case '03':
                                $datao->permiso = ($periodo->mes03 == 0) ? false : true;
                            break;
                            case '04':
                                $datao->permiso = ($periodo->mes04 == 0) ? false : true;
                            break;
                            case '05':
                                //$datao->permiso = ($periodo->mes05 == 0) ? false : true;
                                $datao->permiso = (bool)$periodo->mes05;
                            break;
                            case '06':
                                $datao->permiso = ($periodo->mes06 == 0) ? false : true;
                            break;
                            case '07':
                                $datao->permiso = ($periodo->mes07 == 0) ? false : true;
                            break;
                            case '08':
                                $datao->permiso = ($periodo->mes08 == 0) ? false : true;
                            break;
                            case '09':
                                $datao->permiso = ($periodo->mes09 == 0) ? false : true;
                            break;
                            case '10':
                                $datao->permiso = ($periodo->mes10 == 0) ? false : true;
                            break;
                            case '11':
                                $datao->permiso = ($periodo->mes11 == 0) ? false : true;
                            break;
                            case '12':
                                /*if ($fechaPartes[2] == '31') $datao->permiso = ($periodo->mes13 == 0) ? false : true;
                                else $datao->permiso = ($periodo->mes12 == 0) ? false : true;//*/
                                $datao->permiso = (bool)$periodo->mes12;
                            break;
                        }//*/

                        if ($datao->permiso) {
                            $porigen = explode("/", $datao->origen);
                            if ((strpos($porigen[0], 'AC_') !== false) && ((int)$porigen[1] == 0)) {
                                $datao->permiso = false;
                            }
                        }
                        if ($datao->estatus == 0) {
                            $datos = $this->contabilidad_model->multiEPartida(0);
                            if ($datos->num_rows() > 0) {
                                foreach ($datos->result() as $key => $dato) {
                                    $subcuentas = [];
                                    $subdatos = $this->contabilidad_model->multiEPartida(1, $dato->pnumero);
                                    if ($subdatos->num_rows() > 0) {
                                        foreach ($subdatos->result() as $subdato) {
                                            $permiso = $this->multiplesContabilidad(1, $subdato->allowed_users);
                                            $subcuentas[] = array(
                                                'ID' => $subdato->idctcuenta,
                                                'Name' => $subdato->descrip,
                                                'IDR' => $subdato->idrec,
                                                'Grupo' => $subdato->catgrupo,
                                                'Control' => $subdato->ctcontrol,
                                                'Auxi'=> $subdato->useauxi,
                                                'Centro' => $subdato->askidcentro,
                                                'Proyecto' => $subdato->askidproyecto,
                                                'permiso' => $permiso,
                                            );
                                        }
                                    }
                                    $opcionesTabs[] = array(
                                        'id' => count($opcionesTabs),
                                        'text' => 'Modelo '.($key + 1),
                                        'tipo' => 2,
                                        'subcuentas' => $subcuentas
                                    );
                                }
                            }
                        }

                        $allowed_users = explode(",",$datao->allowed_users);
                        $permisoTipoPartida = !in_array($this->session->userdata('iduser'), $allowed_users);
                        
                        $datao->estado = array_search($datao->estatus, $this->EstadosPartidas);
                        $this->data['tabs'] = $opcionesTabs;
                        $this->data['dato'] = $datao;
                        $this->data['cuentas3'] = $Cuentas;
                        //print_r($cuentas);
                        //if($datao->estado != 'Actualizada'){
                            //$this->data['ctas'] = $this->contabilidad_model->getEPDSnoDatosAnulados($datao->pnumero);
                        //}else{
                        //if($datao->estado != 'Actualizada'){
                            //$datao->pnumero = 10000000 - $datao->pnumero;
                        //}
                        $this->data['ctas'] = $this->contabilidad_model->getEPDS($datao->pnumero);
                        //}
                        $this->data['opcion1'] = $this->OpcionesBancos;
                        $this->data['permisoTipoP'] = $permisoTipoPartida;
                        $variable = $this->variable_model->getTextVar("conta_subauxi");
                        $this->data['subauxi'] = (int)$variable['valor_num'];

                        $this->load->view("mantenimiento_EPDetalle", $this->data);
                    } else echo "<h1>Partida no existe</h1>";
                } else echo "<h1>Parámetro Incorrecto</h1>";
            } else echo "<h1>Falta Parámetro Número</h1>";
        }   
    }
    #   GET DATA EDITOR PARTIDA DETALLE
    public function getEPDetalleData()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                if ($proyectos = $this->contabilidad_model->getProyectosActivos()) {
                    if ($centroS = $this->contabilidad_model->getCentros()) {
                        $Proyectos = [];
                        if ($proyectos->num_rows() > 0) {
                            foreach ($proyectos->result() as $dato) {
                                $Proyectos[] = array(
                                    'ID' => $dato->Idproject,
                                    'Name' => $dato->descrip
                                );
                            }
                        }
                        foreach ($centroS as $centro) {
                            $CentroS[] = array(
                                'ID' => $centro->idcentro,
                                'Name' => $centro->descrip,
                            );
                        }
                        //----------------------------------------------------------------------------------------------------------------------------
                        if (!$auxi = $this->input->post('auxi')) {
                            $datA[] = array('valido' => true);
                            $datA[] = $Proyectos;
                            $datA[] = $CentroS;
                        } else{
                            $cuentaID = $this->input->post("cuentaID");
                            $control = (int)$this->input->post("control");
                            $opcion = (int)$this->input->post("opcion");
                            if ($control == 2 && $opcion != 0) {
                                $cont = false;
                                if ($ctas = $this->contabilidad_model->getAuxsUse($cuentaID)) {
                                    foreach ($ctas as $value) {
                                        $cuenta = explode(",", $value->idtabla.",".$value->idauxi);
                                        /*print_r($value);
                                        print_r($cuenta);//*/
                                        // $cont = false;
                                        foreach ($this->contabilidad_model->getCtasAuxs2($cuenta) as $dato) {
                                            // print_r($dato);
                                            $subauxiTemp = "";
                                            if (property_exists($dato, 'subauxi')){
                                                $subauxiTemp = $dato->subauxi;
                                            }

                                            $Auxs[] = array(
                                                'ID' => $dato->id,
                                                'Name' => $dato->descrip,
                                                'Tipo' => $cuenta[0],
                                                'SubAuxi' => $subauxiTemp,

                                            );
                                            $cont = true;
                                        }
                                    }
                                }
                            } else {
                                foreach (explode(";", $auxi) as $value) {
                                    $cuenta = explode(",", $value);
                                    $cont = false;
                                    foreach ($this->contabilidad_model->getCtasAuxs($cuenta) as $dato) {
                                        $subauxiTemp = "";
                                        if (property_exists($dato, 'subauxi')){
                                            $subauxiTemp = $dato->subauxi;
                                        }
                                        
                                        $Auxs[] = array(
                                            'ID' => $dato->id,
                                            'Name' => $dato->descrip,
                                            'Tipo' => $cuenta[0],
                                            'SubAuxi' => $subauxiTemp,

                                        );
                                        $cont = true;
                                    }
                                }
                            }
                            $datA[] = array('valido' => true);
                            $datA[] = $Proyectos;
                            $datA[] = $CentroS;
                            $datA[] = ($cont) ? $Auxs : null;
                            $datA[] = $this->contabilidad_model->getProyectoPredeterminado();

                        }
                        //----------------------------------------------------------------------------------------------------------------------------
                    } else {
                        $datA[] = array('valido' => false);
                        $datA[] = array('mjs' => "error al traer los centros de costos Activos");
                    }
                } else{
                    $datA[] = array('valido' => false);
                    $datA[] = array('mjs' => "error al traer Proyectos Activos");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   LOAD GESTORES - TIPO DOCS
    public function getEPDGestores()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $cont = false;
                foreach ($this->contabilidad_model->getGestores() as $dato) {
                    $Datos[] = array(
                        'ID' => $dato->id,
                        'Name' => $dato->descrip
                    );
                    $cont = true;
                }
                $cont2 = false;
                foreach ($this->contabilidad_model->getTipoDocs(1) as $dato) {
                    $Datos2[] = array(
                        'ID' => $dato->id,
                        'Name' => $dato->descrip,
                        'Tipo' => 'Ventas'
                    );
                    $cont2 = true;
                }
                foreach ($this->contabilidad_model->getTipoDocs(2) as $dato) {
                    $Datos2[] = array(
                        'ID' => $dato->id,
                        'Name' => $dato->descrip,
                        'Tipo' => 'Compras'
                    );
                    $cont2 = true;
                }
                foreach ($this->contabilidad_model->getTipoDocs(3) as $dato) {
                    $Datos2[] = array(
                        'ID' => $dato->id,
                        'Name' => $dato->descrip,
                        'Tipo' => 'Otros'
                    );
                    $cont2 = true;
                }
                $datA[] = array('gestores' => ($cont) ? $Datos : null);
                $datA[] =  ($cont2) ? $Datos2 : null;
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   GET SERIES
    public function getEPDSeries()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $cont = false;
                $contador = 0;
                foreach ($this->contabilidad_model->getSeries($this->input->post("auxi"), $this->input->post("idcuenta"), $this->input->post("tipodoc")) as $dato) {
                    $Datos[] = array(
                        'ID' => $contador,
                        'Name' => $dato->descrip
                    );
                    $cont = true;
                    $contador++;
                }
                $datA[] = array('series' => ($cont) ? $Datos : null);
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   GET DIAS CTAUXI
    public function getEPDDias()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $cont = ($reso = $this->contabilidad_model->getEPDDias(explode(",", $this->input->post("auxi"))[1])) ? true : false;
                $datA[] = array('dias' => ($cont) ? $reso : 0);
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   GET AC - ABONOS Y CARGOS
    public function getAC()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $opcion = (int)$this->input->post("opcion");
                $auxi = $this->input->post("auxi");
                $idcuenta = $this->input->post("idc");
                $grupo = (int)$this->input->post("grupo");
                $datos = $this->contabilidad_model->getAC($idcuenta, $auxi);
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d');
                $Datos = null;
                foreach ($datos as $dato) {
                    $f1 = new DateTime($ahora);
                    $f2 = new DateTime($dato->doc_emision);
                    $dias = $f1->diff($f2);
                    //print_r($dias);
                    //$saldo = ($grupo == 1) ? $dato->debe - $dato->haber : $dato->haber -$dato->debe;
                    $saldo = $this->getSTC($grupo, $dato->debe, $dato->haber);
                    $Datos[] = array(
                        'ID' => $dato->idrec,
                        'descrip' => $dato->descrip,
                        'serie' => $dato->doc_serie,
                        'numero' => $dato->doc_numero,
                        'emision' => $dato->doc_emision,
                        'vence' => $dato->doc_vence,
                        'gestor' => $dato->doc_idworker,
                        'doc' => $dato->doc_type,
                        'dias' => $dias->days,
                        'debe' => round($dato->debe, 2),
                        'haber' => round($dato->haber, 2),
                        'saldo' => round($saldo, 2),
                        'titulo' => $dato->doc_type,
                        //'titulo' => ($opcion == 1) ? 'Abono' : 'Cargo',
                        'valor' => '',
                    );
                }//*/

                //print_r($this->input->post());
                $datA[] = $Datos;
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   SET EDITOR PARTIDA DETALLE
    public function setEPDetalle()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d H:i:s');
                /*$dato = $this->contabilidad_model->getEPDMov($this->input->post("p_numero"));
                print_r($dato);
                die();//*/
                $data = array(
                    "pnumero" => $this->input->post("p_numero"),
                    "itemline" => $this->contabilidad_model->getCountMov($this->input->post("p_numero")) + 1,
                    "fecha" => $this->input->post("p_fecha"),
                    "idctcuenta" => $this->input->post("cuentaID"),
                );
                $cont = false;
                $auxiliar = $this->input->post("auxiliar");
                if(strlen($auxiliar) > 0) $data['idtabla'] = explode(",", $auxiliar)[0];
                if(strlen($auxiliar) > 0) $data['idauxi'] = explode(",", $auxiliar)[1]; 
                if(strlen($this->input->post("centro")) > 0) $data['idcentro'] = $this->input->post("centro");
                if(strlen($this->input->post("proyecto")) > 0) $data['idproject'] = $this->input->post("proyecto");
                switch ((int)$this->input->post("control")) {
                    /*case 0:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                    case 7:
                    break;//*/
                    case 1:
                        if ((int)$this->input->post("tipoValor") == 1) $data['debe'] = $this->input->post("valor");
                        else $data['haber'] = $this->input->post("valor");
                        $data['doc_type'] = $this->input->post('tipoDoc');
                        $data['doc_serie'] = $this->input->post('serie');
                        $data['doc_numero'] = $this->input->post('numero');
                        $cont = $this->contabilidad_model->validateNumero($this->input->post("cuentaID"),$auxiliar,$this->input->post("tipoDoc"),$this->input->post("serie"),$this->input->post("numero"), null);
                    break;
                    case 2:
                        if ((int)$this->input->post("opcion") == 0) {
                            if ((int)$this->input->post("tipoValor") == 1) $data['debe'] = $this->input->post("valor");
                            else $data['haber'] = $this->input->post("valor");
                            $data['doc_type'] = $this->input->post('tipoDoc');
                            $data['doc_serie'] = $this->input->post('serie');
                            $data['doc_numero'] = $this->input->post('numero');
                            $data['doc_emision'] = $this->input->post("fechai");
                            $data['doc_vence'] = $this->input->post("fechaf");
                            $data['doc_idworker'] = (int)$this->input->post("gestor");
                            $cont = $this->contabilidad_model->validateNumero($this->input->post("cuentaID"),$auxiliar,$this->input->post("tipoDoc"),$this->input->post("serie"),$this->input->post("numero"), null);
                        }
                    break;
                    default:
                        if ((int)$this->input->post("tipoValor") == 1) $data['debe'] = $this->input->post("debe");
                        else $data['haber'] = $this->input->post("haber");
                        $cont = true;
                    break;
                }
                $data['descrip'] = $this->input->post("descripcion");
                $data['sidauxidef'] = $this->input->post("sidauxidef");
                $data['chg_log'] = $ahora.",".$this->session->userdata('iduser').",Inserción;";
                $data['estatus'] = (int)$this->input->post("estatus");
                $data['whodidit'] = $this->session->userdata('iduser');
                $data['ingresa'] = $ahora;
                //$data['cont'] = "-".(string)$cont;

                /*print_r($data);
                die();//*/
                //$cont = false;
                if ($cont) {
                    if ($valor = $this->contabilidad_model->setEPDetalle($data)){
                        $datA[] = array(
                            'valido' => true,
                            'datos' => $this->contabilidad_model->getEPDS($this->input->post("p_numero"))
                        );
                    } else{
                        $datA[] = array('valido' => false, 'tipo' => 0);
                        $datA[] = array('mjs' => "error al guardar");
                    }
                } else {
                    $datA[] = array('valido' => false, 'tipo' => 1);
                    $datA[] = array('mjs' => "error de numero");
                }
                
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   SET EDITOR DE PARTIDA DETALLE - ABONOS Y CARGOS
    public function setEPDetalleAC()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d H:i:s');

                $pnumero = $this->input->post("p_numero");
                $fecha = $this->input->post("p_fecha");
                $IDC = $this->input->post("cuentaID");
                $auxiliar = $this->input->post("auxiliar");
                $centro = $this->input->post("centro");
                $proyecto = $this->input->post("proyecto");
                $tipoValor = (int)$this->input->post("tipoValor");
                $estatus = (int)$this->input->post("estatus");
                $controlnum = $this->input->post("controlnum");

                $valores = $this->input->post('valores');
                //print_r($valores);
                /*$this->contabilidad_model->getEPDMov($this->input->post("p_numero"));
                die();//*/
                foreach ($valores as $valor) {
                    //$valor['titulo'];
                    $data = array(
                        'pnumero' => $pnumero,
                        "itemline" => $this->contabilidad_model->getCountMov($pnumero) + 1,
                        "fecha" => $fecha,
                        "idctcuenta" => $IDC,
                    );
                    if(strlen($auxiliar) > 0) $data['idtabla'] = explode(",", $auxiliar)[0];
                    if(strlen($auxiliar) > 0) $data['idauxi'] = explode(",", $auxiliar)[1]; 
                    //if(strlen($auxiliar) > 0) $data['idauxi'] = $auxiliar;
                    if(strlen($centro) > 0) $data['idcentro'] = $centro;
                    if(strlen($proyecto) > 0) $data['idproject'] = $proyecto;
                    if ($tipoValor == 1) $data['debe'] = $valor['valor'];
                    else $data['haber'] = $valor['valor'];

                    $data['doc_type'] = $valor['doc'];
                    $data['doc_serie'] = $valor['serie'];
                    $data['doc_numero'] = $valor['numero'];

                    $data['doc_emision'] = $valor['emision'];
                    $data['doc_vence'] = $valor['vence'];
                    $data['doc_idworker'] = $valor['gestor'];
                    $data['doc_controlnum'] = $controlnum;

                    $data['descrip'] = $valor['titulo'];
                    $data['chg_log'] = $ahora.",".$this->session->userdata('iduser').",Inserción;";
                    $data['estatus'] = $estatus;
                    $data['whodidit'] = $this->session->userdata('iduser');
                    $data['ingresa'] = $ahora;
                    //print_r($data);
                    $this->contabilidad_model->setEPDetalle($data);
                }
                $datA[] = array(
                    'valido' => true,
                    'datos' => $this->contabilidad_model->getEPDS($this->input->post("p_numero"))
                );
                echo json_encode($datA);//*/
            } else show_404();
        }
    }
    #   UPDATE EDITOR DE PARTIDA DETALLE
    public function updateEPDetalle()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $update = date_create()->format('Y-m-d H:i:s');
                /*$dato = $this->contabilidad_model->getEPDMov($this->input->post("p_numero"));
                print_r($dato);
                die();//*/
                $data = array();
                $cont = false;
                $id = $this->input->post("ID");
                $auxiliar = $this->input->post("auxiliar");
                switch ((int)$this->input->post("control")) {
                    /*case 0:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                    case 7:
                    break;//*/
                    case 1:
                        if ((int)$this->input->post("tipoValor") == 1) $data['debe'] = $this->input->post("valor");
                        else $data['haber'] = $this->input->post("valor");
                        $data['doc_serie'] = $this->input->post('serie');
                        $data['doc_numero'] = $this->input->post('numero');
                        $cont = $this->contabilidad_model->validateNumero($this->input->post("cuentaID"),$auxiliar,$this->input->post("tipoDoc"),$this->input->post("serie"),$this->input->post("numero"), $id);
                    break;
                    case 2:
                        if ((int)$this->input->post("opcion") == 0) {
                            if ((int)$this->input->post("tipoValor") == 1) $data['debe'] = $this->input->post("valor");
                            else $data['haber'] = $this->input->post("valor");
                            
                            $data['doc_serie'] = $this->input->post('serie');
                            $data['doc_numero'] = $this->input->post('numero');
                            $data['doc_emision'] = $this->input->post("fechai");
                            $data['doc_vence'] = $this->input->post("fechaf");
                            $data['doc_idworker'] = (int)$this->input->post("gestor");
                            $cont = $this->contabilidad_model->validateNumero($this->input->post("cuentaID"),$this->input->post("auxiliar"),$this->input->post("tipoDoc"),$this->input->post("serie"),$this->input->post("numero"), $id);
                        }
                        else{
                            if ((int)$this->input->post("tipoValor") == 1) $data['debe'] = $this->input->post("valor");
                            else $data['haber'] = $this->input->post("valor");
                            $cont = true;
                        }
                    break;
                    default:
                        if(strlen($auxiliar) > 0) $data['idtabla'] = explode(",", $auxiliar)[0];
                        if(strlen($auxiliar) > 0) $data['idauxi'] = explode(",", $auxiliar)[1];
                        //if(strlen($this->input->post("auxiliar")) > 0) $data['idauxi'] = $this->input->post("auxiliar");
                        if(strlen($this->input->post("centro")) > 0) $data['idcentro'] = $this->input->post("centro");
                        if(strlen($this->input->post("proyecto")) > 0) $data['idproject'] = $this->input->post("proyecto");//*/
                        $data['debe'] = $this->input->post("debe");
                        $data['haber'] = $this->input->post("haber");
                        $cont = true;
                    break;
                }
                $data['descrip'] = $this->input->post("descripcion");
                $data['sidauxidef'] = $this->input->post("sidauxidef");
                $data['chg_log'] = $this->contabilidad_model->getHistoricoEPD($id).$update.",".$this->session->userdata('iduser').",Actualización;";
                $data['whodidit'] = $this->session->userdata('iduser');
                $data['modifica'] = $update;
                if ($cont) {
                    if ($valor = $this->contabilidad_model->updateEPDetalle($data, $id)){
                        $datA[] = array(
                            'valido' => true,
                            'datos' => $this->contabilidad_model->getEPDS($this->input->post("p_numero"))
                        );
                    } else{
                        $datA[] = array('valido' => false, 'tipo' => 0);
                        $datA[] = array('mjs' => "error al actualizar");
                    }
                } else {
                    $datA[] = array('valido' => false, 'tipo' => 1);
                    $datA[] = array('mjs' => "error de numero");
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   ANULAR MOVIMIENTO
    public function byeEPDetalle()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $ID = $this->input->post("ID");
                $pnumero = $this->input->post("p_numero");
                $IDTP = $this->input->post("IDTP");

                if ($this->contabilidad_model->byeEPDetalle($ID, $IDTP, $pnumero)){
                    $datA[] = array(
                        'valido' => true,
                        'datos' => $this->contabilidad_model->getEPDS($pnumero)
                    );
                } else{
                    $datA[] = array('valido' => false, 'tipo' => 0);
                    $datA[] = array('mjs' => "error al eliminar");
                }
                echo json_encode($datA);//*/
            } else show_404();
        }
    }
    #   CERRAR PARTIDA  - ACTUALIZAR
    public function cerrarEPartida()
    {
        if($this->validatePermiso()) {
            //pnumero
            //estado actual 0
            //nuevo estado  1
            //id user
            $pnumero = $this->input->post("p_numero");
            $actual = $this->input->post("estado");
            $this->load->model('contabilidad_model');
            if ($this->contabilidad_model->cerrarEPartida($pnumero, $actual, 1,$this->session->userdata('iduser'))) {
                $datA[] = array('valido' => true);
            } else $datA[] = array('valido' => false);
            echo json_encode($datA);
        }
    }
    #   DESACTUALIZAR PARTIDA - DESACTUALIZAR
    public function abrirEPartida()
    {
        if($this->validatePermiso()) {
            //pnumero
            //estado actual 1
            //nuevo estado  0
            //id user
            $pnumero = $this->input->post("p_numero");
            $actual = $this->input->post("estado");
            $IDTP = $this->input->post("IDTP");
            $this->load->model('contabilidad_model');

            if ($this->contabilidad_model->havePermiso($IDTP)) {
                /*$datA[] = array(
                    'valido' => true,
                );//*/
                if ($this->contabilidad_model->cerrarEPartida($pnumero, $actual, 0,$this->session->userdata('iduser'))) {
                    $datA[] = array(
                        'valido' => true,
                    );
                } else {
                    $datA[] = array(
                        'valido' => false,
                        'tipo' => 1
                    );
                }//*/
            } else $datA[] = array('valido' => false, 'tipo' => 0);
            echo json_encode($datA);
        }
    }
    #   ANULAR PARTIDA
    public function anularEPartida()
    {
        if($this->validatePermiso()) {
            //pnumero
            //estado actual 1
            //nuevo estado  0
            //id user
            $pnumero = $this->input->post("p_numero");
            $IDTP = $this->input->post("IDTP");
            $this->load->model('contabilidad_model');
            if ($this->contabilidad_model->havePermiso($IDTP)) {
                /*$datA[] = array(
                    'valido' => true,
                );//*/
                if ($this->contabilidad_model->anularEPartida($pnumero, $this->session->userdata('iduser'))) {
                    ///anularEPartida
                    $datA[] = array(
                        'valido' => true,
                    );
                } else {
                    $datA[] = array(
                        'valido' => false,
                        'tipo' => 1
                    );
                }//*/
            } else $datA[] = array('valido' => false, 'tipo' => 0);
            echo json_encode($datA);
        }
    }
    #   GET DESCRIPTCION ALL CUENTA
    public function getDescripcionsCuenta()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $cuenta = $this->input->post("cuenta");
                if($datos = $this->contabilidad_model->getInfoCuentaAll($cuenta)){
                    $Datos = null;
                    if($datos->num_rows() > 0){
                        $datos = array_slice($datos->result(), -5, 5);
                        foreach($datos as $dato){
                            $Datos[] = array(
                                'ID' => $dato->idrec,
                                'text' => $dato->descrip
                            );
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else{
                    $datA[] = array('valido' => false);
                }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   MULTI OPCIONES EDITOR DETALLE
    public function multiEPDetalle()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $opcion = (int)$this->input->post('opcion');
            switch ($opcion) {
                case 1:#   TIPOS AUXILIARES
                    $Datos = $this->multiplesContabilidad(13);
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                break;
                case 2:#   CUENTAS AUXILIARES
                    $IDAuxi = (int)$this->input->post('idauxi');
                    $Datos = $this->conversionMultiEPDetalle(1, $IDAuxi);
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                break;
                case 3:#   GET DATA MULTIPLE
                    $IDAuxi = (int)$this->input->post('idauxi');
                    $filtro = (int)$this->input->post('filtro');
                    #  GRUPOS - GRIO - LIMITE - DIAS
                    $Grupos = $this->multiplesContabilidad(14, ['multi' => 1, 'where' => 'idauxidef = '.$IDAuxi, 'campo' => 'grupo']);
                    $datA[] = array('valido' => true, 'grupos' => $Grupos);
                    if ($filtro == 1) {
                        $idpais = $this->multiplesContabilidad(7, ['campo' => 'nombre', 'valor' => 'gv_zip']);
                        $idpais = (count((array)$idpais) > 0) ? (string)(int)$idpais->valor_num : 0;
                        $datA[0]['gestores'] = $this->multiplesContabilidad(15, 3);
                        $datA[0]['deptos'] = $this->multiplesContabilidad(14, ['multi' => 2, 'idauxi' => $IDAuxi]);
                        $datA[0]['giros'] = $this->multiplesContabilidad(14, ['multi' => 1, 'where' => '', 'campo' => 'giro']);
                        $datA[0]['limites'] = $this->multiplesContabilidad(14, ['multi' => 1, 'where' => '', 'campo' => 'limite']);
                        $datA[0]['dias'] = $this->multiplesContabilidad(14, ['multi' => 1, 'where' => '', 'campo' => 'dias']);
                        $datA[0]['idz'] = $idpais;
                    }
                break;
                case 4:#   SET- UPDATE AUXILIAR
                    $ID = (int)$this->input->post('ID');
                    $IDAuxi = (int)$this->input->post('idauxi');
                    $filtro = (int)$this->input->post('filtro');
                    $fi = trim($this->input->post("fechain"));
                    $fi = ($fi == '') ? date_create()->format('Y-m-d') : $fi;
                    $data = array(
                        'descrip' => trim($this->input->post('nombre')),
                        'idauxidef' => $IDAuxi,
                        'telefono' => trim($this->input->post('telefono')),
                        'correo' => trim($this->input->post('correo')),
                        'direccion' => trim($this->input->post('direccion')),
                        'idzip' => (int)$this->input->post('departamento'),
                        'fechain' => $fi,
                        'nrc' => trim($this->input->post('dui')),
                        'nit' => trim($this->input->post('nit')),
                        'giro' => trim($this->input->post('giro')),
                        'grupo' => trim($this->input->post('grupo')),
                        'limite' => (float)$this->input->post('limite'),
                        'dias' => (int)$this->input->post('dia'),
                        'xpos' => trim($this->input->post('xpos')),
                        'idcps' => (int)$this->input->post('vendedor'),
                        'idtipo' => (int)$this->input->post('tcontribuyente'),
                        'estado' => 1,
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($ID == 0) {
                        $data['ingresa'] = $data['modifica'];
                        unset($data['modifica']);
                        $proceso = $this->multiplesContabilidad(8, ['tabla' => 'ctauxi', 'data' => $data]);
                    } else {
                        if ($filtro != 3) unset($data['fechain']);
                        unset($data['estado']);
                        //$proceso = false;
                        $proceso = $this->multiplesContabilidad(10, ['campo' => 'idauxi', 'valor' => (int)$ID, 'data' => $data, 'tabla' => 'ctauxi']);
                    }
                    //print_r($data);
                    if ($proceso) {
                        $Datos = $this->conversionMultiEPDetalle(1, $IDAuxi);
                        $datA[] = array('valido' => true, 'datos' => $Datos);
                    } else $datA[] = array('valido' => false, 'texerror' => (($ID == 0) ? 'Error al Ingresar' : 'Error al Actualizar'));//*/
                break;
                case 5:#   REORDENAMIENTO MOVIMIENTOS
                    $pnumero = (int)$this->input->post("pnumero");
                    $movs = explode(",", trim($this->input->post('movs')));
                    if (count($movs) > 0) {
                        foreach ($movs as $movd) {
                            $mov = explode("-", $movd);
                            $data = array(
                                'itemline' => (int)$mov[1],
                                //'chg_log' => $this->contabilidad_model->getHistoricoEPD((int)$mov[0]).date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Actualización;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'modifica' => date_create()->format('Y-m-d H:i:s'),
                            );
                            $this->multiplesContabilidad(10, ['campo' => 'idrec', 'valor' => (int)$mov[0], 'data' => $data, 'tabla' => 'ct_100d']);
                        }
                    }
                    $datA[] = array('valido' => true,'datos' => $this->contabilidad_model->getEPDS($pnumero));
                break;
                case 6:#   CARGAR SALDOS
                    $tipo = (int)$this->input->post('tipo');
                    $idyear = (int)$this->input->post('idyear');
                    $Datos = [];
                    if ($tipo == 0) {
                        $datos = $this->contabilidad_model->multiEPDetalle(2, ['idyear' => $idyear]);
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                $Datos[] = array(
                                    'cuenta' => $dato->idctcuenta.'-'.$dato->descrip.'/'.$dato->auxi,
                                    'debe' => $dato->haber,
                                    'haber' => $dato->debe,
                                );
                            }
                        }
                    } else {
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                break;
                default:
                    $datA[] = array('valido' => false);
                break;
            }
            echo json_encode($datA);
        }
    }
    private function conversionMultiEPDetalle($opc, $extra = null)
    {
        $Datos = [];
        switch ($opc) {
            case 1:#   CUENTAS AUXILIARES
                $datos = $this->contabilidad_model->multiEPDetalle(1, $extra);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $Datos[] = array(
                            'key' => (int)$dato->idauxi,
                            'grupo' => trim($dato->grupo),
                            'titulo' => trim($dato->descrip),
                            'vendedor' => $dato->idcps,
                            'telefono' => trim($dato->telefono),
                            'correo' => trim($dato->correo),
                            'direccion' => trim($dato->direccion),
                            'pais' => $dato->idzip,
                            'dui' => trim($dato->nrc),
                            'nit' => trim($dato->nit),
                            'giro' => trim($dato->giro),
                            'fechain' => $dato->fechain,
                            'tcontribuyente' => $dato->idtipo,
                            'limite' => $dato->limite,
                            'dia' => $dato->dias,
                            'xpos' => trim($dato->xpos),
                            'notas' => trim($dato->notas)
                        );
                    }
                }
            break;
        }
        return $Datos;
    }
    #-------------------------------------------------------------- IMPORTADOR DE MOVIMIENTOS
        #   GET FORMATO
        public function getFormatoIM()
        {
            if($this->validatePermiso()) {
                                
                // require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                $objPHPExcel = new Spreadsheet();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Formato Importador de Movimientos") // Titulo
                ->setSubject("Formato Importador de Movimientos") //Asunto
                ->setDescription("Formato Importador de Movimientos") //Descripción
                ->setKeywords("Formato Importador de Movimientos") //Etiquetas
                ->setCategory("Formato Importador de Movimientos"); //Categorias

                $objPHPExcel->setActiveSheetIndex(0);
                $default_border = array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => array('argb' => "000")
                );
                $style_header = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ),
                    'borders' => [
						'allBorders' => [
							'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							'color' => ['argb' => '000000'],
						],
					],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'FFFFFF',
						],
                    ),
                    'font' => array(
                        'bold' => true,
						'color' => array('rgb' => '000000'),
                        'size' => 9,
                        'name' => 'Arial'
                    )
                );
                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15); # 0- cuenta
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(50); # 1- titulo
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(12); # 2- aux
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(12); # 3- centro
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(12); # 4- proyecto
                $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(50); # 5- descripcion
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(16); # 6- tipo doc
                $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(12); # 7- serie
                $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12); # 8- numero
                $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15); # 9- f. emision
                $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15); # 10- f. vence
                $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(12); # 11- gestor
                $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(12); # 12- debe
                $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(12); # 13- haber
                $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(25); # 14- ID Subauxiliar 1
                $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(25); # 15- ID Subauxiliar 2
                $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(25); # 16- ID Subauxiliar 3
                $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(25); # 17- ID Subauxiliar 4
                $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(25); # 18- ID Subauxiliar 5


                $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Cuenta');
                $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Titulo de la Cuenta');
                $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'ID Auxiliar');
                $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'ID Centro');
                $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'ID Proyecto');
                $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Descripción del Movimiento');
                $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Tipo de Documento');
                $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Serie');
                $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Numero');
                $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Fecha emisión');
                $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Fecha vencimiento');
                $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'ID Gestor');
                $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Debe');
                $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Haber');
                $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'ID Etiqueta Presupuesto 1');
                $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'ID Etiqueta Presupuesto 2');
                $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'ID Etiqueta Presupuesto 3');
                $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'ID Etiqueta Presupuesto 4');
                $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'ID Etiqueta Presupuesto 5');

                //$objPHPExcel->getActiveSheet()->getStyle("A1:H1")->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->getStyle("A1:S1")->applyFromArray( $style_header );

                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="Importar_Movimientos.xlsx"');
                header('Cache-Control: max-age=0');
                $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
                $objWriter->save('php://output'); 
            }
        }
        #   VALIDACION DE IMPORTACION
        public function readIMoves()
        {
            if($this->validatePermiso()) {
                try {
                    //var_dump(PHPExcel_IOFactory::identify($_FILES['file']['tmp_name']));

                    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);
                    
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                //$this->load->model('contabilidad_model');
                $this->load->model('contabilidad_model');
                //  Get worksheet dimensions
                $objPHPExcel->setActiveSheetIndex(0); 
                $sheet = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();

                if ($highestRow > 2) {
                    #   GET ENCABEZADOS
                    $Encabezados = [];
                    for ($row = 1; $row <= 1; $row++) {
                        $rowData = $sheet->rangeToArray('A' . $row . ':S' . $row,NULL,TRUE,FALSE);
                        $rowData = $rowData[0];
                        $Encabezados[] = $rowData[0];
                        $Encabezados[] = $rowData[1];
                        $Encabezados[] = $rowData[2];
                        $Encabezados[] = $rowData[3];
                        $Encabezados[] = $rowData[4];
                        $Encabezados[] = $rowData[5];
                        $Encabezados[] = $rowData[6];
                        $Encabezados[] = $rowData[7];
                        $Encabezados[] = $rowData[8];
                        $Encabezados[] = $rowData[9];
                        $Encabezados[] = $rowData[10];
                        $Encabezados[] = $rowData[11];
                        $Encabezados[] = $rowData[12];
                        $Encabezados[] = $rowData[13];
                        $Encabezados[] = $rowData[14];
                        $Encabezados[] = $rowData[15];
                        $Encabezados[] = $rowData[16];
                        $Encabezados[] = $rowData[17];
                        $Encabezados[] = $rowData[18];
                    }

                    #   GET ÚLTIMA FILA
                    $final = 0;
                    for ($row = 2; $row <= $highestRow; $row++) {
                        $rowData = $sheet->rangeToArray('A' . $row . ':S' . $row,NULL,TRUE,FALSE);
                        $rowData = $rowData[0];
                        if (trim($rowData[0]) == "*** Final") {
                            $final = $row;
                            break;
                        }
                    }
                    if ($final > 0) {
                        $CountError = 0;
                        $Datos = [];
                        #   VALIDACION PRIMARIA
                        for ($row = 2; $row < $final; $row++) {
                            $rowData = $sheet->rangeToArray('A' . $row . ':S' . $row,NULL,TRUE,FALSE);
                            $rowData = $rowData[0];
                            $error = [];
                            
                            $cuenta = trim($rowData[0]);
                            $titulo = trim($rowData[1]);
                            $idauxi = trim($rowData[2]);
                            $tauxi = '';
                            $idcentro = trim($rowData[3]);
                            $tcentro = '';
                            $idproyecto = trim($rowData[4]);
                            $tproyecto = '';
                            $descripcionMov = trim($rowData[5]);
                            $tipoDoc = trim($rowData[6]);
                            $ttipoDoc = '';
                            $serie = trim($rowData[7]);
                            $numero = trim($rowData[8]);
                            $femision = trim($rowData[9]);
                            $femision = \PhpOffice\PhpSpreadsheet\Style\NumberFormat::toFormattedString($femision, "YYYY-MM-DD");
                            $fvence = trim($rowData[10]);
                            $fvence = \PhpOffice\PhpSpreadsheet\Style\NumberFormat::toFormattedString($fvence, "YYYY-MM-DD");
                            $idgestor = trim($rowData[11]);
                            $tgestor = '';
                            $debe = trim($rowData[12]);
                            $haber = trim($rowData[13]);
                            $idsubauxi1 = trim($rowData[14]);
                            $idsubauxi2 = trim($rowData[15]);
                            $idsubauxi3 = trim($rowData[16]);
                            $idsubauxi4 = trim($rowData[17]);
                            $idsubauxi5 = trim($rowData[18]);

                            //Si el valor del debe y el haber es cero se salta ese registro
                            if(($debe == "" && $haber == "") || ($debe == 0 && $haber == 0) ){
                                continue;
                            }

                            #   Cuenta
                            $DCuenta = $this->contabilidad_model->getCuenta3($cuenta);
                            if (count((array)$DCuenta) > 0) {
                                $TipoValor = 0;

                                #   VALIDAR SI PUEDE USAR ESA CUENTA
                                $permiso = true;
                                if (strlen(trim($DCuenta->allowed_users)) > 0) {
                                    foreach (explode(",", $DCuenta->allowed_users) as $malo) {
                                        if ($malo == $this->session->userdata('iduser')) {
                                            $permiso = false;
                                            break;
                                        }
                                    }
                                }
                                if ($permiso) {
                                    #  VIENE DEBE Y HABER
                                    $ndebe = true;
                                    if (strlen($debe) == 0 || $debe == null) $ndebe = false;
                                    $nhaber = true;
                                    if (strlen($haber) == 0 || $haber == null) $nhaber = false;

                                    #   SI CENTRO ES REQUISITO
                                    if (strlen($DCuenta->askidcentro) > 0) {
                                        if (!is_numeric($idcentro)) {
                                            $error[] = $Encabezados[3].'-Campo debe ser numérico';
                                        } else {
                                            if ((int)$idcentro > 0) {
                                                $Centros = $this->contabilidad_model->getDataC(2);
                                                if ($Centros->num_rows() > 0) {
                                                    $found = 0;
                                                    foreach ($Centros->result() as $centro) {
                                                        if ($centro->idcentro == (int)$idcentro) {
                                                            $tcentro = '-'.$centro->descrip;
                                                            $found = 1;
                                                            break;
                                                        }
                                                    }
                                                    if ($found == 1) {
                                                        $foundc = 0;
                                                        foreach (explode(',', $DCuenta->askidcentro) as $centrod) {
                                                            if ((int)$centrod == (int)$idcentro) {
                                                                $foundc = 1;
                                                                break;
                                                            }
                                                        }
                                                        if ($foundc == 0) $error[] = $Encabezados[3].'-Centro no esta definido para esa Cuenta';
                                                    } else $Encabezados[3].'-No existe ese Centro con ese ID';
                                                } else $error[] = $Encabezados[2].'-No hay Centros activos creados';
                                            } else $error[] = $Encabezados[3].'-Valor no puede ser cero ni negativo';
                                        }
                                    }
                                    #   SI TIENE CONTROL DE PROYECTOS
                                    if ((int)$DCuenta->askidproyecto == 1) {
                                        if (is_numeric($idproyecto) && (int)$idproyecto > 0) {
                                            $Proyectos = $this->contabilidad_model->getProyectosActivos();
                                            if ($Proyectos->num_rows() > 0) {
                                                $found = 0;
                                                foreach ($Proyectos->result() as $proyecto) {
                                                    if ($proyecto->Idproject == (int)$idproyecto) {
                                                        $tproyecto = '-'.$proyecto->descrip;
                                                        $found = 1;
                                                        break;
                                                    }
                                                }
                                                if ($found == 0) $error[] = $Encabezados[4].'-No existe Proyecto con ese ID';
                                            } else $error[] = $Encabezados[4].'-No hay Proyectos activos';
                                        }
                                    }
                                    #   SERIE Y NUMERO
                                    if ($DCuenta->ctcontrol == 1 || $DCuenta->ctcontrol == 2) {
                                        # NUMERO
                                        $vnumero = (is_numeric($numero) && (int)$numero > 0) ? true : false;
                                        if (!$vnumero) $error[] = $Encabezados[8].'-Número debe ser valor numérico positivo';
                                        # SERIE
                                        $vserie = false;
                                        if (strlen($serie) > 0 && $serie != null) {
                                            $vserie = preg_match("/^([0-9A-Z])+$/", strtoupper($serie));
                                            if (!$vserie) $error[] = $Encabezados[7].'-Serie debe ser alfanumérico';
                                        } else $error[] = $Encabezados[7].'-Serie es requerida para esta Cuenta';
                                    }

                                    switch ($DCuenta->ctcontrol) {
                                        /*case 0:
                                        case 3:
                                        case 4:
                                        case 5:
                                        case 6:
                                        case 7:
                                        break;//*/
                                        case 1:
                                            #   SI AUXILIAR ES REQUISITO
                                            if (strlen($DCuenta->useauxi) > 0) {
                                                if (!is_numeric($idauxi)) {
                                                    $error[] = $Encabezados[2].'-Campo debe ser numérico';
                                                } else {
                                                    if ((int)$idauxi > 0) {
                                                        $Auxs = $this->contabilidad_model->getCtasAuxs(explode(',', $DCuenta->useauxi));
                                                        if (count($Auxs) > 0) {
                                                            $found  = 0;
                                                            foreach ($Auxs as $auxiliar) {
                                                                if ($auxiliar->id == $idauxi) {
                                                                    $tauxi = '-'.$auxiliar->descrip;
                                                                    $found = 1;
                                                                    break;
                                                                }
                                                            }
                                                            if ($found == 0) $error[] = $Encabezados[2].'-No existe Auxiliar definido activo con ese ID';
                                                        } else $error[] = $Encabezados[2].'-No hay Auxiliares activos definido para esta Cuenta';
                                                    } else $error[] = $Encabezados[2].'-Valor no puede ser cero ni negativo';
                                                }
                                            }
                                            #   TIPO DOCUMENTO
                                            if (strlen($tipoDoc) > 0 && $tipoDoc != null) {
                                                $foundtd = 0;
                                                $IDOpcion = 0;
                                                foreach ($this->OpcionesBancos as $opcionb) {
                                                    if ($opcionb['ID'] != 10) {
                                                        if (strtolower($opcionb['Name']) == strtolower($tipoDoc)) {
                                                            $ttipoDoc = $opcionb['Name'];
                                                            $IDOpcion = $opcionb['ID'];
                                                            $foundtd = 1;
                                                            break;
                                                        }
                                                    }
                                                }
                                                if ($foundtd == 0) $error[] = $Encabezados[6].'-Tipo de documento no admitido para esta Cuenta';
                                                else {
                                                    #   VALIDAR SERIE Y NUMERO
                                                    if ($vserie && $vnumero) {
                                                        $gaux = explode(',',$DCuenta->useauxi)[0].','.$idauxi;
                                                        $vserien = $this->contabilidad_model->validateNumero($cuenta, $gaux, $ttipoDoc, $serie, $numero, null);
                                                        if (!$vserien) $error[] = $Encabezados[8].'-Número ya existente';
                                                    }
                                                    #   VALIDAR DEBE Y HABER
                                                    if ($DCuenta->catgrupo == 1) {
                                                        switch ($IDOpcion) {
                                                            case 0:
                                                            case 2:
                                                            case 4:
                                                                $TipoValor = 2;//haber
                                                                if (!$nhaber) $error[] = $Encabezados[13].'-Campo es requerido';
                                                                else {
                                                                    $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                    if (!$vhaber) $error[] = $Encabezados[13].'-Campo debe ser númerico positivo';
                                                                    else {
                                                                        if ((float)$haber <= 0) $error[] = $Encabezados[13].'-Campo debe ser mayor que 0';
                                                                    }
                                                                }
                                                            break;
                                                            case 1:
                                                            case 3:
                                                                $TipoValor = 1;//debe
                                                                if (!$ndebe) $error[] = $Encabezados[12].'-Campo es requerido';
                                                                else {
                                                                    $vdebe = preg_match("/^([0-9])+(\.[0-9]+)?$/", $debe);
                                                                    if (!$vdebe) $error[] = $Encabezados[12].'-Campo debe ser númerico positivo';
                                                                    else {
                                                                        if ((float)$debe <= 0) $error[] = $Encabezados[12].'-Campo debe ser mayor que 0';
                                                                    }
                                                                }
                                                            break;
                                                        }
                                                    } else {
                                                        if (!$nhaber) $error[] = $Encabezados[13].'-Campo es requerido';
                                                        else {
                                                            $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                            if (!$vhaber) $error[] = $Encabezados[13].'-Campo debe ser númerico positivo';
                                                            else {
                                                                if ((float)$haber <= 0) $error[] = $Encabezados[13].'-Campo debe ser mayor que 0';
                                                            }
                                                        }
                                                    }
                                                }
                                            } else $error[] = $Encabezados[6].'-Tipo de documento es requerido para esta Cuenta';
                                        break;
                                        case 2:
                                            #   FECHA EMISION
                                            $valemision = false;
                                            if (strlen($femision) > 0 && $femision != null) {
                                                $vfemision = preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $femision);
                                                if (!$vfemision) $error[] = $Encabezados[9].'-Fecha emisión mal escrita';
                                                else {
                                                    $tfemision = explode('-', $femision);
                                                    if (!checkdate($tfemision[1], $tfemision[2], $tfemision[0])) $error[] = $Encabezados[9].'-Fecha emisión no existe';
                                                    else $valemision = true;
                                                }
                                            } else $error[] = $Encabezados[9].'-Fecha emisión es requerida';
                                            #   TIPO DE DOCUMENTO
                                            if (strlen($tipoDoc) > 0 && $tipoDoc != null) {
                                                $TiposDocs = [];
                                                $foundtd = 0;
                                                $ACOpcion = 0;
                                                if (strtolower($tipoDoc) == 'abono') {
                                                    $foundtd = 1;
                                                    $ACOpcion = 1;
                                                } else if (strtolower($tipoDoc) == 'cargo') {
                                                    $foundtd = 1;
                                                    $ACOpcion = 2;
                                                } else {
                                                    $TiposDocsC = $this->contabilidad_model->getTipoDocs(1);
                                                    if (count($TiposDocsC) > 0) {
                                                        foreach ($TiposDocsC as $tdoc) {
                                                            $TiposDocs[] = $tdoc;
                                                        }
                                                    }
                                                    $TiposDocsC = $this->contabilidad_model->getTipoDocs(2);
                                                    if (count($TiposDocsC) > 0) {
                                                        foreach ($TiposDocsC as $tdoc) {
                                                            $TiposDocs[] = $tdoc;
                                                        }
                                                    }
                                                }
                                                #   NUEVO DOCUMENTO
                                                if ($foundtd == 0) {
                                                    if (count($TiposDocs) > 0) {
                                                        foreach ($TiposDocs as $tdoc) {
                                                            if (strtolower($tipoDoc) == strtolower($tdoc->descrip)) {
                                                                $foundtd = 1;
                                                                $ttipoDoc = $tdoc->descrip;
                                                                break;
                                                            }
                                                        }
                                                        if ($foundtd == 0) $error[] = $Encabezados[6].'-Tipo de documento no existe';
                                                        else {
                                                            #   VALIDAR DEBE Y HABER
                                                            switch ($DCuenta->catgrupo) {
                                                                case 1:
                                                                    if (!$ndebe) $error[] = $Encabezados[12].'-Campo es requerido';
                                                                    else {
                                                                        $vdebe = preg_match("/^([0-9])+(\.[0-9]+)?$/", $debe);
                                                                        if (!$vdebe) $error[] = $Encabezados[12].'-Campo debe ser númerico positivo';
                                                                        else {
                                                                            if ((float)$debe <= 0) $error[] = $Encabezados[12].'-Campo debe ser mayor que 0';
                                                                        }
                                                                    }
                                                                break;
                                                                case 2:
                                                                    if (!$nhaber) $error[] = $Encabezados[13].'-Campo es requerido';
                                                                    else {
                                                                        $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                        if (!$vhaber) $error[] = $Encabezados[13].'-Campo debe ser númerico positivo';
                                                                        else {
                                                                            if ((float)$haber <= 0) $error[] = $Encabezados[13].'-Campo debe ser mayor que 0';
                                                                        }
                                                                    }
                                                                break;
                                                                default:
                                                                    if (!$nhaber) $error[] = $Encabezados[13].'-Campo es requerido';
                                                                    else {
                                                                        $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                        if (!$vhaber) $error[] = $Encabezados[13].'-Campo debe ser númerico positivo';
                                                                        else {
                                                                            if ((float)$haber <= 0) $error[] = $Encabezados[13].'-Campo debe ser mayor que 0';
                                                                        }
                                                                    }
                                                                break;
                                                            }
                                                            #   FECHA VENCIMIENTO
                                                            $valvence = false;
                                                            if (strlen($fvence) > 0 && $fvence != null) { 
                                                                $vfvence = preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fvence);
                                                                if (!$vfvence) $error[] = $Encabezados[10].'-Fecha vencimiento mal escrita';
                                                                else {
                                                                    $tfvence = explode('-', $fvence);
                                                                    if (!checkdate($tfvence[1], $tfvence[2], $tfvence[0])) $error[] = $Encabezados[10].'-Fecha vencimeinto no existe';
                                                                    else $valvence = true;
                                                                }
                                                            } else $error[] = $Encabezados[10].'-Fecha vencimiento es requerida';
                                                            #   VALIDAR FECHA VENCIMIENTO SEA MAYOR O IGUAL A FECHA EMISION
                                                            if ($valemision && $valvence) {
                                                                $vtfemision = new DateTime($femision);
                                                                $vtfvence = new DateTime($fvence);
                                                                if ($vtfvence < $vtfemision) $Encabezados[10].'-Fecha vencimiento deber ser mayor o igual a Fecha Emisión';
                                                            }
                                                            #   SI AUXILIAR ES REQUISITO
                                                            if (strlen($DCuenta->useauxi) > 0) {
                                                                if (!is_numeric($idauxi)) {
                                                                    $error[] = $Encabezados[2].'-Campo debe ser numérico';
                                                                } else {
                                                                    if ((int)$idauxi > 0) {
                                                                        $Auxs = $this->contabilidad_model->getCtasAuxs(explode(',', $DCuenta->useauxi));
                                                                        if (count($Auxs) > 0) {
                                                                            $found  = 0;
                                                                            foreach ($Auxs as $auxiliar) {
                                                                                if ($auxiliar->id == $idauxi) {
                                                                                    $tauxi = '-'.$auxiliar->descrip;
                                                                                    $found = 1;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            if ($found == 0) $error[] = $Encabezados[2].'-No existe Auxiliar definido con ese ID';
                                                                        } else $error[] = $Encabezados[2].'-No hay Auxiliares activos definido para esta Cuenta';//*/
                                                                    } else $error[] = $Encabezados[2].'-Valor no puede ser cero ni negativo';
                                                                }
                                                            }
                                                            #   VALIDAR SERIE-NUMERO CUANDO SEA NEW DOC
                                                            if ($vserie && $vnumero) {
                                                                $gaux = explode(',',$DCuenta->useauxi)[0].','.$idauxi;
                                                                $vserien = $this->contabilidad_model->validateNumero($cuenta, $gaux, $ttipoDoc, $serie, $numero, null);
                                                                if (!$vserien) $error[] = $Encabezados[8].'-Número ya existente';
                                                            }
                                                            #   GESTOR
                                                            $found = 0;
                                                            if ((is_numeric($idgestor) && (int)$idgestor > 0)) {
                                                                $Gestores = $this->contabilidad_model->getGestores();
                                                                if (count($Gestores) > 0) {
                                                                    foreach ($Gestores as $gestor) {
                                                                        if ((int)$idgestor == $gestor->id) {
                                                                            $found = 1;
                                                                            $tgestor = '-'.$gestor->descrip;
                                                                            break;
                                                                        }
                                                                    }
                                                                    if($found == 0) $error[] = $Encabezados[11].'-No existe Gestor activo con ese ID';
                                                                } else $error[] = $Encabezados[11].'-No hay Gestores activos creados';
                                                            } else $error[] = $Encabezados[11].'-Campo debe ser un valor numérico positivo';
                                                        }
                                                    } else $error[] = $Encabezados[6].'-Tipos de documentos no estan definidos/creados';
                                                } 
                                                #   ABONO O CARGO
                                                else {
                                                    #   VALIDAR DEBE Y HABER
                                                    $valmonto = false;
                                                    $monto = 0;
                                                    $Emonto = '';
                                                    switch ($DCuenta->catgrupo) {
                                                        case 1:
                                                            if ($ACOpcion == 1) {
                                                                if (!$nhaber) $error[] = $Encabezados[13].'-Campo es requerido';
                                                                else {
                                                                    $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                    if (!$vhaber) $error[] = $Encabezados[13].'-Campo debe ser númerico positivo';
                                                                    else {
                                                                        if ((float)$haber <= 0) $error[] = $Encabezados[13].'-Campo debe ser mayor que 0';
                                                                        else {
                                                                            $valmonto = true;
                                                                            $monto = $haber;
                                                                        }
                                                                    }
                                                                }
                                                                $Emonto = $Encabezados[13];
                                                            } else {
                                                                if (!$ndebe) $error[] = $Encabezados[12].'-Campo es requerido';
                                                                else {
                                                                    $vdebe = preg_match("/^([0-9])+(\.[0-9]+)?$/", $debe);
                                                                    if (!$vdebe) $error[] = $Encabezados[12].'-Campo debe ser númerico positivo';
                                                                    else {
                                                                        if ((float)$debe <= 0) $error[] = $Encabezados[12].'-Campo debe ser mayor que 0';
                                                                        else {
                                                                            $valmonto = true;
                                                                            $monto = $debe;
                                                                        }
                                                                    }
                                                                }
                                                                $Emonto = $Encabezados[12];
                                                            }
                                                        break;
                                                        case 2:
                                                            if ($ACOpcion == 1) {
                                                                if (!$ndebe) $error[] = $Encabezados[12].'-Campo es requerido';
                                                                else {
                                                                    $vdebe = preg_match("/^([0-9])+(\.[0-9]+)?$/", $debe);
                                                                    if (!$vdebe) $error[] = $Encabezados[12].'-Campo debe ser númerico positivo';
                                                                    else {
                                                                        if ((float)$debe <= 0) $error[] = $Encabezados[12].'-Campo debe ser mayor que 0';
                                                                        else {
                                                                            $valmonto = true;
                                                                            $monto = $debe;
                                                                        }
                                                                    }
                                                                }
                                                                $Emonto = $Encabezados[12];
                                                            } else {
                                                                if (!$nhaber) $error[] = $Encabezados[13].'-Campo es requerido';
                                                                else {
                                                                    $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                    if (!$vhaber) $error[] = $Encabezados[13].'-Campo debe ser númerico positivo';
                                                                    else {
                                                                        if ((float)$haber <= 0) $error[] = $Encabezados[13].'-Campo debe ser mayor que 0';
                                                                        else {
                                                                            $valmonto = true;
                                                                            $monto = $haber;
                                                                        }
                                                                    }
                                                                }
                                                                $Emonto = $Encabezados[13];
                                                            }
                                                        break;
                                                    }

                                                    #   SI AUXILIAR ES REQUISITO
                                                    $foundAux  = 0;
                                                    $rarray = [];
                                                    if (strlen($DCuenta->useauxi) > 0) {
                                                        if (!is_numeric($idauxi)) {
                                                            $error[] = $Encabezados[2].'-Campo debe ser numérico';
                                                        } else {
                                                            if ((int)$idauxi > 0) {
                                                                $AuxialresUsados = $this->contabilidad_model->getAuxsUse($DCuenta->useauxi);
                                                                
                                                                if ($AuxialresUsados != false) {
                                                                    foreach ($AuxialresUsados as $auxusado) {
                                                                        if ($auxusado->idauxi == (int)$idauxi) {
                                                                            $foundAux = 1;
                                                                            $rarray = [$auxusado->idtabla, $auxusado->idauxi];
                                                                            $dataAuxusuado = $this->contabilidad_mdoel->getCtasAuxs2($rarray);
                                                                            if (count($dataAuxusuado) > 0) $tauxi = '-'.$dataAuxusuado[0]->descrip;
                                                                            break;
                                                                        }
                                                                    }
                                                                    if ($foundAux == 0) $error[] = $Encabezados[2].'-No existe Auxiliar definido con ese ID';
                                                                } else $error[] = $Encabezados[2].'-No hay Auxiliares para Abono o Cargo para esta Cuenta';//*/
                                                            } else $error[] = $Encabezados[2].'-Valor no puede ser cero ni negativo';
                                                        }
                                                    }
                                                    #   VALIDAR SI EXISTE ESE DOCUMENTO A ABONAR O CARGAR
                                                    if ($foundAux == 1) {
                                                        $ACfound = 0;
                                                        $DataAC = [];
                                                        $tarray = implode(',', $rarray);
                                                        $getMovesAC = $this->contabilidad_model->getAC($cuenta, $tarray);
                                                        if ($getMovesAC != false) {
                                                            foreach ($getMovesAC as $movimiento) {
                                                                if (($movimiento->doc_serie == $serie) &&
                                                                ($movimiento->numero == $numero) &&
                                                                ($movimiento->doc_emision == $femision)) {
                                                                    $ACfound = 1;
                                                                    $DataAC = $movimiento;
                                                                    break;
                                                                }
                                                            }
                                                        }
                                                        if ($ACfound == 1) {
                                                            if ($valmonto) {
                                                                $saldo = $this->getSTC($DCuenta->catgrupo, $DataAC->debe, $DataAC->haber);
                                                                if ($ACOpcion == 1) {
                                                                    if ((float)$monto <= 0 || (float)$monto > $saldo) $error[] = $Emonto.'-Monto a Abono debe ser menor que el Saldo y mayor que 0';
                                                                } else {
                                                                    if ((float)$monto <= 0) $error[] = $Emonto.'-Monto a Cargo debe ser mayor que 0';
                                                                }
                                                            }
                                                        } else $error[] = 'No existe Abono o Cargo con ese Auxiliar, Serie, Número y Fecha de Emisión';
                                                    }
                                                }
                                            } else $error[] = $Encabezados[6].'-Tipo de documento es requerido para esta Cuenta';
                                        break;
                                        default:
                                            #   SI AUXILIAR ES REQUISITO
                                            if (strlen($DCuenta->useauxi) > 0) {
                                                if (!is_numeric($idauxi)) {
                                                    $error[] = $Encabezados[2].'-Campo debe ser numérico';
                                                } else {
                                                    if ((int)$idauxi > 0) {
                                                        $Auxs = $this->contabilidad_model->getCtasAuxs(explode(',', $DCuenta->useauxi));

                                                        if (count($Auxs) > 0) {
                                                            $found  = 0;
                                                            foreach ($Auxs as $auxiliar) {
                                                                if ($auxiliar->id == $idauxi) {
                                                                    $tauxi = '-'.$auxiliar->descrip;
                                                                    $found = 1;
                                                                    break;
                                                                }
                                                            }
                                                            if ($found == 0) $error[] = $Encabezados[2].'-No existe Auxiliar definido con ese ID';
                                                        } else $error[] = $Encabezados[2].'-No hay Auxiliares activos definido para esta Cuenta';
                                                    } else $error[] = $Encabezados[2].'-Valor no puede ser cero ni negativo';
                                                }
                                            }
                                            #   DEBE Y HABER
                                            if ($ndebe && $nhaber) {
                                                $error[] = $Encabezados[12].'-No puede haber valor en el debe y haber al mismo tiempo';
                                                $error[] = $Encabezados[13].'-No puede haber valor en el debe y haber al mismo tiempo';
                                            } else {
                                                if ($ndebe) {
                                                    $TipoValor = 1;
                                                    $vdebe = preg_match("/^([0-9])+(\.[0-9]+)?$/", $debe);
                                                    if (!$vdebe) $error[] = $Encabezados[12].'-Valor debe ser númerico';
                                                    else {
                                                        if ((float)$debe <= 0) $error[] = $Encabezados[12].'-Valor debe ser númerico positivo';
                                                    }
                                                } else if ($nhaber) {
                                                    $TipoValor = 2;
                                                    $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                    if (!$vhaber) $error[] = $Encabezados[13].'-Valor debe ser númerico';
                                                    else {
                                                        if ((float)$haber <= 0) $error[] = $Encabezados[13].'-Valor debe ser númerico positivo';
                                                    }
                                                } else {
                                                    $error[] = $Encabezados[12].'-Para esta cuenta debe ingresar un valor en el debe o haber';
                                                    $error[] = $Encabezados[13].'-Para esta cuenta debe ingresar un valor en el debe o haber';
                                                }
                                            }
                                        break;
                                    }
                                } else $error[] = $Encabezados[0].'-Cuenta de Movimiento (Acceso Restringuido)';
                            } else $error[] = $Encabezados[0].'-Cuenta de Movimiento no existe';
                            
                            #   Descripcion del movimiento
                            if (strlen($descripcionMov) > 0) {
                                if (strpos($descripcionMov, '"') != false) {
                                    $error[] = $Encabezados[5].'-Campo no puede llevar comilla doble';
                                } else if (strpos($descripcionMov, "'") != false) {
                                    $error[] = $Encabezados[5].'-Campo no puede llevar comilla simple';
                                } else if (strpos($descripcionMov, '\\') != false) {
                                    $error[] = $Encabezados[5].'-Campo no puede llevar pleca invertida';
                                } else if (strpos($descripcionMov, "<") != false) {
                                    $error[] = $Encabezados[5].'-Campo no puede llevar signo <';
                                } else if (strpos($descripcionMov, ">") != false) {
                                    $error[] = $Encabezados[5].'-Campo no puede llevar signo >';
                                }
                            } else $error[] = $Encabezados[5].'-Descripción del movimiento es requerido';

                            if(strlen($idsubauxi1) > 0){
                                $temp = $this->contabilidad_model->getDescripSubauxis($idsubauxi1); 
                                if($temp){
                                    $idsubauxi1 = $temp['descrip'];
                                }else{
                                    $error[] = $Encabezados[14].'-La EP no existe';
                                }
                            }

                            if(strlen($idsubauxi2) > 0){
                                $temp = $this->contabilidad_model->getDescripSubauxis($idsubauxi2); 
                                if($temp){
                                    $idsubauxi2 = $temp['descrip'];
                                }else{
                                    $error[] = $Encabezados[15].'-La EP no existe';
                                }
                            }

                            if(strlen($idsubauxi3) > 0){
                                $temp = $this->contabilidad_model->getDescripSubauxis($idsubauxi3); 
                                if($temp){
                                    $idsubauxi3 = $temp['descrip'];
                                }else{
                                    $error[] = $Encabezados[16].'-La EP no existe';
                                }
                            }

                            if(strlen($idsubauxi4) > 0){
                                $temp = $this->contabilidad_model->getDescripSubauxis($idsubauxi4); 
                                if($temp){
                                    $idsubauxi4 = $temp['descrip'];
                                }else{
                                    $error[] = $Encabezados[17].'-La EP no existe';
                                }
                            }

                            if(strlen($idsubauxi5) > 0){
                                $temp = $this->contabilidad_model->getDescripSubauxis($idsubauxi5); 
                                if($temp){
                                    $idsubauxi5 = $temp['descrip'];
                                }else{
                                    $error[] = $Encabezados[18].'-La EP no existe';
                                }
                            }

                            $Datos[] = array(
                                'cuenta' => $cuenta,
                                'titulo' => $titulo,
                                'auxiliar' => $idauxi.$tauxi,
                                'centro' => $idcentro.$tcentro,
                                'proyecto' => $idproyecto.$tproyecto, 
                                'descripcion' => $descripcionMov,
                                'tipo_doc' => $tipoDoc,
                                'serien' => $serie.'-'.$numero,
                                'gestor' => $idgestor.$tgestor,
                                'femision' => $femision,
                                'debe' => $debe,
                                'haber' => $haber,
                                'idsubauxi1' => $idsubauxi1,
                                'idsubauxi2' => $idsubauxi2,
                                'idsubauxi3' => $idsubauxi3,
                                'idsubauxi4' => $idsubauxi4,
                                'idsubauxi5' => $idsubauxi5,

                                'line' => $row,
                                'error' => implode(';', $error),
                                'cerror' => (count($error) > 0) ? true : false,
                            );
                            if (count($error) > 0) $CountError++;//*/
                        }
                        $datA[] = array('valido' => (($CountError == 0) ? true : false), 'datos' => $Datos, 'tipo' => 1);
                    } else $datA[] = array('valido' => false, 'tipo' => -1);
                } else $datA[] = array('valido' => false, 'tipo' => 0);

                echo json_encode($datA);//*/
            }
        }
        #   IMPORTAR MOVIMEINTOS
        public function importEPDetalle()
        {
            if($this->validatePermiso()) {
                //  Read your Excel workbook
                try {
                    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($_FILES['file']['tmp_name']);
                    $objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($_FILES['file']['tmp_name']);
                } catch(Exception $e) {
                    die('Error loading file "'.pathinfo($_FILES['file']['tmp_name'],PATHINFO_BASENAME).'": '.$e->getMessage());
                }
                //$this->load->model('contabilidad_model');
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $PNumero = (int)$this->input->post('IDP');
                $PFecha = $this->input->post('PFecha');
                $PEstatus = $this->input->post('PEstatus');
                //  Get worksheet dimensions
                $objPHPExcel->setActiveSheetIndex(0); 
                $sheet = $objPHPExcel->setActiveSheetIndex(0);
                $highestRow = $sheet->getHighestRow(); 
                $highestColumn = $sheet->getHighestColumn();
                #   GET ÚLTIMA FILA
                $final = 0;
                for ($row = 2; $row <= $highestRow; $row++) {
                    $rowData = $sheet->rangeToArray('A' . $row . ':S' . $row,NULL,TRUE,FALSE);
                    $rowData = $rowData[0];
                    if (trim($rowData[0]) == "*** Final") {
                        $final = $row;
                        break;
                    }
                }
                #   GET MOVIMIENTOS
                $Datos = [];
                for ($row = 2; $row < $final; $row++) {
                    $rowData = $sheet->rangeToArray('A' . $row . ':S' . $row,NULL,TRUE,FALSE);
                    $rowData = $rowData[0];

                    $cuenta = trim($rowData[0]);
                    $idauxi = trim($rowData[2]);
                    $idcentro = trim($rowData[3]);
                    $idproyecto = trim($rowData[4]);
                    $descripcionMov = trim($rowData[5]);
                    $tipoDoc = trim($rowData[6]);
                    $ttipoDoc = '';
                    $serie = trim($rowData[7]);
                    $numero = trim($rowData[8]);
                    $femision = trim($rowData[9]);
                    $femision = \PhpOffice\PhpSpreadsheet\Style\NumberFormat::toFormattedString($femision, "YYYY-MM-DD");
                    $fvence = trim($rowData[10]);
                    $fvence = \PhpOffice\PhpSpreadsheet\Style\NumberFormat::toFormattedString($fvence, "YYYY-MM-DD");
                    $idgestor = trim($rowData[11]);
                    $debe = trim($rowData[12]);
                    $haber = trim($rowData[13]);
                    $idsubauxi1 = trim($rowData[14]);
                    $idsubauxi2 = trim($rowData[15]);
                    $idsubauxi3 = trim($rowData[16]);
                    $idsubauxi4 = trim($rowData[17]);
                    $idsubauxi5 = trim($rowData[18]);

                    $arraysubauxis = array($idsubauxi1, $idsubauxi2, $idsubauxi3, $idsubauxi4,$idsubauxi5);
                    $arraysubauxis = array_filter($arraysubauxis);
                    $arraysubauxis = implode(",", $arraysubauxis);
                    $Movimiento = [];
                    #   Cuenta
                    $DCuenta = $this->contabilidad_model->getCuenta3($cuenta);
                    $Movimiento['idctcuenta'] = $cuenta;
                    #   Centro
                    if (strlen($DCuenta->askidcentro) > 0) {
                        $Movimiento['idcentro'] = (int)$idcentro;
                    } else $Movimiento['idcentro'] = 0;
                    #   proyecto
                    if ((int)$DCuenta->askidproyecto == 1) {
                        if (is_numeric($idproyecto) && (int)$idproyecto > 0) {
                            $Movimiento['idproject'] = (int)$idproyecto;
                        } else $Movimiento['idproject'] = (int)$idproyecto;
                    }
                    #   Descripción del movimiento
                    $Movimiento['descrip'] = $descripcionMov;
                    #   DEMAS
                    #  VIENE DEBE Y HABER
                    $ndebe = true;
                    if (strlen($debe) == 0 || $debe == null) $ndebe = false;
                    $nhaber = true;
                    if (strlen($haber) == 0 || $haber == null) $nhaber = false;
                    switch ($DCuenta->ctcontrol) {
                        /*case 0:
                        case 3:
                        case 4:
                        case 5:
                        case 6:
                        case 7:
                        break;//*/
                        case 1:
                            $IDOpcion = 0;
                            $Movimiento['idtabla'] = explode(',', $DCuenta->useauxi)[0];
                            $Movimiento['idauxi'] = $idauxi;
                            foreach ($this->OpcionesBancos as $opcionb) {
                                if ($opcionb['ID'] != 10) {
                                    if (strtolower($opcionb['Name']) == strtolower($tipoDoc)) {
                                        $ttipoDoc = $opcionb['Name'];
                                        $IDOpcion = $opcionb['ID'];
                                        break;
                                    }
                                }
                            }
                            if ($DCuenta->catgrupo == 1) {
                                switch ($IDOpcion) {
                                    case 0:
                                    case 2:
                                    case 4:
                                        $Movimiento['haber'] = $haber;
                                    break;
                                    case 1:
                                    case 3:
                                        $Movimiento['debe'] = $debe;
                                    break;
                                }
                            } else $Movimiento['haber'] = $haber;
                            $Movimiento['doc_type'] = $ttipoDoc;
                            $Movimiento['doc_serie'] = $serie;
                            $Movimiento['doc_numero'] = $numero;
                        break;
                        case 2:
                            $Movimiento['doc_emision'] = $femision;
                            #   ABONO O CARGO
                            if (strtolower($tipoDoc) == 'abono' || strtolower($tipoDoc) == 'cargo') {
                                $ACOpcion = (strtolower($tipoDoc) == 'abono') ? 1 : 2;
                                $Movimiento['doc_controlnum'] = ($ACOpcion == 1) ? 'Abono' : 'Cargo';
                                #   GET AUXS USADOS
                                $AuxialresUsados = $this->contabilidad_model->getAuxsUse($DCuenta->useauxi);
                                foreach ($AuxialresUsados as $auxusado) {
                                    if ($auxusado->idauxi == (int)$idauxi) {
                                        $rarray = [$auxusado->idtabla, $auxusado->idauxi];
                                        break;
                                    }
                                }
                                #   GET ABONO O CARGO
                                $DataAC = [];
                                $rarray = [];
                                $tarray = implode(',', $rarray);
                                $getMovesAC = $this->contabilidad_model->getAC($cuenta, $tarray);
                                foreach ($getMovesAC as $movimiento) {
                                    if (($movimiento->doc_serie == $serie) &&
                                    ($movimiento->numero == $numero) &&
                                    ($movimiento->doc_emision == $femision)) {
                                        $DataAC = $movimiento;
                                    }
                                }
                                # LLenando informacion
                                $Movimiento['idauxi'] = $idauxi;
                                $Movimiento['idtabla'] = $rarray[0];
                                $Movimiento['doc_type'] = $DataAC->doc_type;
                                $Movimiento['doc_serie'] = $DataAC->doc_serie;
                                $Movimiento['doc_numero'] = $DataAC->doc_numero;
                                $Movimiento['doc_vence'] = $DataAC->doc_vence;
                                $Movimiento['doc_idworker'] = $DataAC->doc_idworker;

                                switch ($DCuenta->catgrupo) {
                                    case 1:
                                        if ($ACOpcion == 1) $Movimiento['haber'] = $haber;
                                        else $Movimiento['debe'] = $debe;
                                    break;
                                    case 2:
                                        if ($ACOpcion == 1) $Movimiento['debe'] = $debe;
                                        else $Movimiento['haber'] = $haber;
                                    break;
                                }
                            } # NEW DOCUMENTO
                            else {
                                $Movimiento['idauxi'] = $idauxi;
                                $Movimiento['idtabla'] = explode(',', $DCuenta->useauxi)[0];
                                $Movimiento['doc_serie'] = $serie;
                                $Movimiento['doc_numero'] = $numero;
                                $Movimiento['doc_idworker'] = $idgestor;
                                $Movimiento['doc_vence'] = $fvence;
                                $TiposDocs = [];
                                $TiposDocsC = $this->contabilidad_model->getTipoDocs(1);
                                if (count($TiposDocsC) > 0) {
                                    foreach ($TiposDocsC as $tdoc) {
                                        $TiposDocs[] = $tdoc;
                                    }
                                }
                                $TiposDocsC = $this->contabilidad_model->getTipoDocs(2);
                                if (count($TiposDocsC) > 0) {
                                    foreach ($TiposDocsC as $tdoc) {
                                        $TiposDocs[] = $tdoc;
                                    }
                                }
                                foreach ($TiposDocs as $tdoc) {
                                    if (strtolower($tipoDoc) == strtolower($tdoc->descrip)) {
                                        $ttipoDoc = $tdoc->descrip;
                                        break;
                                    }
                                }
                                $Movimiento['doc_type'] = $ttipoDoc;
                                switch ($DCuenta->catgrupo) {
                                    case 1:
                                        # Debe
                                        $Movimiento['debe'] = $debe;
                                    break;
                                    case 2:
                                        # Haber
                                        $Movimiento['haber'] = $haber;
                                    break;
                                }
                            }
                        break;
                        default:
                            if (strlen($DCuenta->useauxi) > 0) {
                                $Movimiento['idtabla'] = explode(',', $DCuenta->useauxi)[0];
                                $Movimiento['idauxi'] = $idauxi;
                            }
                            if ($ndebe) $Movimiento['debe'] = $debe;
                            else $Movimiento['haber'] = $haber;
                        break;
                    }
                    #Extras
                    $Movimiento['sidauxidef'] = $arraysubauxis;

                    $Movimiento['pnumero'] = $PNumero;
                    //$Movimiento['itemline'] = $this->contabilidad_model->getCountMov($PNumero) + 1;
                    $Movimiento['fecha'] = $PFecha;
                    $Movimiento['chg_log'] = date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;";
                    $Movimiento['estatus'] = $PEstatus;
                    $Movimiento['whodidit'] = $this->session->userdata('iduser');
                    $Movimiento['ingresa'] = date_create()->format('Y-m-d H:i:s');
                    $Datos[] = $Movimiento;
                }
                /*
                $error = [];
                $conteo = 0;
                foreach ($Datos as $dato) {
                    $data = $dato;
                    $data['itemline'] = $this->contabilidad_model->getCountMov($PNumero) + 1;

                    if(!$this->contabilidad_model->setEPDetalle($data)){
                        $conteo++;
                        $error[] = $dato['idctcuenta'];
                    }
                }
                */
                $resultado = $this->contabilidad_model->importarArrayMovimientos($Datos,$PNumero);

                echo json_encode(array(
                    'valido' => $resultado['esValido'],
                    'error' => implode('-', $resultado['arrayErrores']),
                    'datosG' => $this->contabilidad_model->getEPDS($PNumero)
                ));
            }
        }
    #-
    #-------------------------------------------------------------- IMPORTADR PARTIDAS TXT
        #   VALIDACION DE IMPORTACION
        public function readIMovesTxt()
        {
            if($this->validatePermiso()) {
                $year = $this->input->post('year');
                $month = $this->input->post('month');
                //$d = (new DateTime($idyear.'-'.$month.'-01'))->format('t');
                $this->load->model('contabilidad_model');
                $Datos = [];
                $Registros = trim($this->input->post('registros'));
                $conteoError = 0;
                foreach (explode("\n", $Registros) as $key => $registro) {
                    if (count(explode(";", trim($registro))) == 18) {
                        $dato = explode(";", trim($registro));
                        //print_r($dato);
                        $error = [];
                        $idtipop = trim($dato[0]);
                        $ttipop = '';
                        $fecha = trim($dato[1]);
                        $referencia = trim($dato[2]);
                        $descripcion = trim($dato[3]);

                        $cuenta = trim($dato[4]);
                        $idauxi = trim($dato[6]);
                        $tauxi = '';
                        $idcentro = trim($dato[7]);
                        $tcentro = '';
                        $idproyecto = trim($dato[8]);
                        $tproyecto = '';
                        $dmovimiento = trim($dato[9]);
                        $tipodoc = trim($dato[10]);
                        $ttipodoc = '';
                        $serie = trim($dato[11]);
                        $numero = trim($dato[12]);
                        $femision = trim($dato[13]);
                        $fvence = trim($dato[14]);
                        $idgestor = trim($dato[15]);
                        $tgestor = '';
                        $debe = trim($dato[16]);
                        $haber = trim($dato[17]);

                        if (is_numeric($idtipop) && (int)$idtipop > 0) {
                            $DTipoPartida = $this->contabilidad_model->getTPartida($idtipop);
                            if (count((array)$DTipoPartida) > 0) {
                                $ttipop = '-'.$DTipoPartida->descrip;
                                if (strlen($fecha) > 0) {
                                    $vfecha = preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fecha);
                                    if (!$vfecha) $error[] = 'Fecha-Fecha está mal escrita';
                                    else {
                                        $tfecha = explode('-', $fecha);
                                        if (!checkdate($tfecha[1], $tfecha[2], $tfecha[0])) $error[] = 'Fecha-Fecha no existe';
                                        else {
                                            if ((int)$tfecha[0] == (int)$year) {
                                                if ((int)$tfecha[1] == (int)$month) {
                                                    #-  VALIDAR TIPO DE PARTIDA
                                                    $permiso = true;
                                                    $mfound = false;
                                                    if (strlen(trim($DTipoPartida->allowed_users)) > 0) {
                                                        foreach (explode(',', $DTipoPartida->allowed_users) as $idmalo) {
                                                            if ($idmalo == $this->session->userdata('iduser')) {
                                                                $permiso = false;
                                                                break;
                                                            }
                                                        }
                                                        if ($permiso) {
                                                            if (strlen(trim($DTipoPartida->periodos)) > 0) {
                                                                foreach (explode(',', $DTipoPartida->periodos) as $periodo) {
                                                                    if ($periodo == $tfecha[1]) {
                                                                        $mfound = true;
                                                                        break;
                                                                    }
                                                                }
                                                            } else $error[] = 'Tipo de Partida-El Tipo de Partida no posee Periodos Permitidos';
                                                        } else $error[] = 'Tipo de Partida-Acceso Restringuido';
                                                    } else {
                                                        if (strlen(trim($DTipoPartida->periodos)) > 0) {
                                                            foreach (explode(',', $DTipoPartida->periodos) as $periodo) {
                                                                if ($periodo == $tfecha[1]) {
                                                                    $mfound = true;
                                                                    break;
                                                                }
                                                            }
                                                        } else $error[] = 'Tipo de Partida-El Tipo de Partida no posee Periodos Permitidos';
                                                    }
                                                    #   SI TIENE PERMISO Y SI EL TIPO PARTIDA TIENE ESE PERIODO PERMITIDO
                                                    if ($permiso) {
                                                        if ($mfound) {
                                                            #   VALIDAR REFERENCIA Y DESCRIPCION
                                                            $vreferencia = false;
                                                            $vdescripcion = false;
                                                            if (strlen($referencia) > 0) $vreferencia = true;
                                                            else $error[] = 'Refrencia-Campo es requerido';
                                                            if (strlen($descripcion) > 0) $vdescripcion = true;
                                                            else $error[] = 'Refrencia-Campo es requerido';

                                                            if ($vreferencia && $vdescripcion) {
                                                                #   SI LA CUENTA EXISTE 
                                                                $DCuenta = $this->contabilidad_model->getCuenta3($cuenta);
                                                                if (count((array)$DCuenta) > 0) {
                                                                    #   VALIDAR SI PUEDE USAR ESA CUENTA
                                                                    $permisocuenta = true;
                                                                    if (strlen(trim($DCuenta->allowed_users)) > 0) {
                                                                        foreach (explode(',', $DCuenta->allowed_users) as $malo) {
                                                                            if ($malo == $this->session->userdata('iduser')) {
                                                                                $permisocuenta = false;
                                                                                break;
                                                                            }
                                                                        }
                                                                    }
                                                                    if ($permisocuenta) {
                                                                        $ndebe = true;
                                                                        if ($debe == "0" || strlen($debe) == 0) $ndebe = false;
                                                                        $nhaber = true;
                                                                        if ($haber == "0" || strlen($haber) == 0) $nhaber = false;

                                                                        #   VALIDANDO CENTRO DE COSTOS
                                                                        if (strlen(trim($DCuenta->askidcentro)) > 0) {
                                                                            if (!is_numeric($idcentro)) $error[] = 'CC. Costos-Campo debe ser numérico';
                                                                            else {
                                                                                if ((int)$idcentro > 0) {
                                                                                    $Centros = $this->contabilidad_model->getDataC(2);
                                                                                    if ($Centros->num_rows() > 0) {
                                                                                        $found = false;
                                                                                        foreach ($Centros->result() as $centro) {
                                                                                            if ($centro->idcentro == (int)$idcentro) {
                                                                                                $tcentro = '-'.$centro->descrip;
                                                                                                $found = true;
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        if ($found) {
                                                                                            $cfound = false;
                                                                                            foreach (explode(',', $DCuenta->askidcentro) as $centrod) {
                                                                                                if ((int)$centrod == (int)$idcentro) {
                                                                                                    $cfound = true;
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            if (!$cfound) $error[] = 'CC.Costos-No esta definido en los CC Costos de la Cuenta';
                                                                                        } else $error[] = 'CC.Costos-No exiiste Centro con ese ID';
                                                                                    } else $error[] = 'CC.Costos-No hay Centros activos creados';
                                                                                } else $error[] = 'CC. Costos-Campo no puede ser cero ni negativo';
                                                                                
                                                                            }
                                                                        }
                                                                        #   VALIDANDO CONTROL DE PROYECTO
                                                                        if ((int)$DCuenta->askidproyecto == 1) {
                                                                            if (is_numeric($idproyecto) && (int)$idproyecto > 0) {
                                                                                $Proyectos = $this->contabilidad_model->getProyectosActivos();
                                                                                if ($Proyectos->num_rows() > 0) {
                                                                                    $found = false;
                                                                                    foreach ($Proyectos->result() as $proyecto) {
                                                                                        if ($proyecto->Idproject == (int)$idproyecto) {
                                                                                            $tproyecto = '-'.$proyecto->descrip;
                                                                                            $found = true;
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                } else $error[] = 'Proyecto-No hay proyectos activos';
                                                                            }
                                                                        }
                                                                        #   SERIE Y NUMERO
                                                                        if ($DCuenta->ctcontrol == 1 || $DCuenta->ctcontrol == 2) {
                                                                            #   NUMERO
                                                                            $vnumero = (is_numeric($numero) && (int)$numero > 0) ? true : false;
                                                                            if (!$vnumero) $error[] = 'Número-Número debe ser valor numérico positivo';
                                                                            #   SERIE
                                                                            $vserie = false;
                                                                            if (strlen($serie) > 0) {
                                                                                $vserie = preg_match("/^([0-9A-Z])+$/", strtoupper($serie));
                                                                                if (!$vserie) $error[] = 'Serie-Campo debe ser alfanumérico';
                                                                            } else $error[] = 'Serie-Campo requerido para esta Cuenta';
                                                                        }

                                                                        #   VALIDACION PRINCIPAL
                                                                        switch ($DCuenta->ctcontrol) {
                                                                            /*case 0:
                                                                            case 3:
                                                                            case 4:
                                                                            case 5:
                                                                            case 6:
                                                                            case 7:
                                                                            break;//*/
                                                                            case 1:
                                                                                #   VALIDANDO AUXILIAR
                                                                                if (!is_numeric($idauxi) || (int)$idauxi <= 0) $error[] = 'Auxiliar-Campo debe ser valor numérico positivo';
                                                                                else {
                                                                                    $Auxs = $this->contabilidad_model->getCtasAuxs(explode(',', $DCuenta->useauxi));
                                                                                    if (count($Auxs) > 0) {
                                                                                        $found = false;
                                                                                        foreach ($Auxs as $auxiliar) {
                                                                                            if ($auxiliar->id == $idauxi) {
                                                                                                $tauxi = '-'.$auxiliar->descrip;
                                                                                                $found = true;
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        if (!$found) $error[] = 'Auxiliar-No existe Auxiliar definidio con ese ID';
                                                                                    } else $error[] = 'Auxiliar-No hay Auxiliares Activos definidos por esta Cuenta';
                                                                                }
                                                                                #   VALIDACION TIPO DOCUMENTO
                                                                                if (strlen($tipodoc) > 0) {
                                                                                    $foundtd = false;
                                                                                    $IDOpcion = 0;
                                                                                    foreach ($this->OpcionesBancos as $opcion) {
                                                                                        if ($opcion['ID'] != 10) {
                                                                                            if (strtolower($opcion['Name']) == strtolower($tipodoc)) {
                                                                                                $ttipodoc = $opcion['Name'];
                                                                                                $IDOpcion = $opcion['ID'];
                                                                                                $foundtd = true;
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    if(!$foundtd) $error[] = 'Tipo de Documento-Tipo de Documento no admitido para esta Cuenta';
                                                                                    else {
                                                                                        #   VALIDACION SERIE Y NUMERO
                                                                                        if ($vserie && $vnumero) {
                                                                                            $gaux = explode(',', $DCuenta->useauxi)[0].','.$idauxi;
                                                                                            $vserien = $this->contabilidad_model->validateNumero($cuenta, $gaux, $ttipodoc, $serie, $numero, null);
                                                                                            if (!$vserien) $error[] = 'Número-Número ya existente';
                                                                                        }
                                                                                        #   VALIDACION DEBE Y HABER
                                                                                        if ($DCuenta->catgrupo == 1) {
                                                                                            switch ($IDOpcion) {
                                                                                                case 0:
                                                                                                case 2:
                                                                                                case 4:
                                                                                                    if (!$nhaber) $error[] = 'Haber-Campo es requerido';
                                                                                                    else {
                                                                                                        $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                                                        if(!$vhaber) $error[] = 'Haber-Campo debe ser numérico';
                                                                                                        else {
                                                                                                            if ((float)$haber <= 0) $error[] = 'Haber-Campor debe ser mayor que 0';
                                                                                                        }
                                                                                                    }
                                                                                                break;
                                                                                                case 1:
                                                                                                case 3:
                                                                                                    if (!$ndebe) $error[] = 'Debe-Campo es requerido';
                                                                                                    else {
                                                                                                        $vdebe = preg_match("/^([0-9])+(\.[0-9]+)?$/", $debe);
                                                                                                        if (!$vdebe) $error[] = 'Debe-Campo debe ser numérico';
                                                                                                        else {
                                                                                                            if ((float)$debe <= 0) $error[] = 'Debe-Campo deb ser mayor que 0';
                                                                                                        }
                                                                                                    }
                                                                                                break;
                                                                                            }
                                                                                        } else {
                                                                                            #   SI NO ES ACTIVO SE COMPORTARA COMO HABER
                                                                                            if (!$nhaber) $error[] = 'Haber-Campo es requerido';
                                                                                            else {
                                                                                                $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                                                if(!$vhaber) $error[] = 'Haber-Campo debe ser numérico';
                                                                                                else {
                                                                                                    if((float)$haber <= 0) $error[] = 'Haber-Campo debe ser mayor que 0';
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                } else $error[] = 'Tipo de Documento-Campo es requerido para esta cuenta';
                                                                            break;
                                                                            case 2:
                                                                                #   FECHA EMISION
                                                                                $valemision = false;
                                                                                if (strlen($femision) > 0) {
                                                                                    $vfemision = preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $femision);
                                                                                    if (!$vfemision) $error[] = 'Fecha Emisión-Fecha mal escrita';
                                                                                    else {
                                                                                        $tfemision = explode('-', $femision);
                                                                                        if (!checkdate($tfemision[1], $tfemision[2], $tfemision[0])) $error[] = 'Fecha Emisión-Fecha no existe';
                                                                                        else $valemision = true;
                                                                                    }
                                                                                } else $error[] = 'Fecha Emisión-Campo es requerido';
                                                                                #   TIPO DE DOCUMENTO
                                                                                if (strlen($tipodoc) > 0) {
                                                                                    $TiposDocs = [];
                                                                                    $foundtd = 0;
                                                                                    $ACOpcion = 0;
                                                                                    if (strtolower($tipodoc) == 'abono') {
                                                                                        $foundtd = 1;
                                                                                        $ACOpcion = 1;
                                                                                    } else if (strtolower($tipodoc) == 'abono') {
                                                                                        $foundtd = 1;
                                                                                        $ACOpcion = 2;
                                                                                    } else {
                                                                                        $TiposDocsC = $this->contabilidad_model->getTipoDocs(1);
                                                                                        if (count($TiposDocsC) > 0) {
                                                                                            foreach ($TiposDocsC as $tdoc) {
                                                                                                $TiposDocs[] = $tdoc;
                                                                                            }
                                                                                        }
                                                                                        $TiposDocsC = $this->contabilidad_model->getTipoDocs(2);
                                                                                        if (count($TiposDocsC) > 0) {
                                                                                            foreach ($TiposDocsC as $tdoc) {
                                                                                                $TiposDocs[] = $tdoc;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    #   NUEVO DOCUMENTO
                                                                                    if ($foundtd == 0) {
                                                                                        if (count($TiposDocs) > 0) {
                                                                                            foreach ($TiposDocs as $tdoc) {
                                                                                                if (strtolower($tipodoc) == strtolower($tdoc->descrip)) {
                                                                                                    $foundtd = 1;
                                                                                                    $ttipoDoc = $tdoc->descrip;
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            if ($foundtd == 0) $error[] = 'Tipo de Documento-Tipo de Documento no existe';
                                                                                            else {
                                                                                                #   VALIDAR DEBE Y HABER
                                                                                                switch ($DCuenta->catgrupo) {
                                                                                                    case 1:
                                                                                                        if (!$ndebe) $error[] = 'Debe-Campo es requerido';
                                                                                                        else {
                                                                                                            $vdebe = preg_match("/^([0-9])+(\.[0-9]+)?$/", $debe);
                                                                                                            if (!$vdebe) $error[] = 'Debe-Campo debe ser numérico';
                                                                                                            else {
                                                                                                                if ((float)$debe <= 0) $error[] = 'Debe-Campo de ser mayor que 0';
                                                                                                            }
                                                                                                        }
                                                                                                    break;
                                                                                                    case 2:
                                                                                                        if (!$nhaber) $error[] = 'Haber-Campo es requerido';
                                                                                                        else {
                                                                                                            $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                                                            if (!$vhaber) $error[] = 'Haber-Campo debe ser numérico';
                                                                                                            else {
                                                                                                                if ((float)$haber <= 0) $error[] = 'Haber-Campo debe ser mayor que 0';
                                                                                                            }
                                                                                                        }
                                                                                                    break;
                                                                                                    default:
                                                                                                        if (!$nhaber) $error[] = 'Haber-Campo es requerido';
                                                                                                        else {
                                                                                                            $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                                                            if (!$vhaber) $error[] = 'Haber-Campo debe ser numérico';
                                                                                                            else {
                                                                                                                if ((float)$haber <= 0) $error[] = 'Haber-Campo debe ser mayor que 0';
                                                                                                            }
                                                                                                        }
                                                                                                    break;
                                                                                                }
                                                                                                #   FECHA VENCIMIENTO
                                                                                                $valvence = false;
                                                                                                if (strlen($fvence) > 0) {
                                                                                                    $vfvence = preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fvence);
                                                                                                    if (!$vfvence) $error[] = 'Fecha Vencimiento-Fecha mal escrita';
                                                                                                    else {
                                                                                                        $tfvence = explode('-', $fvence);
                                                                                                        if (!checkdate($tfvence[1], $tfvence[2], $tfvence[0])) $error[] = 'Fecha Vencimiento-Fecha no existe';
                                                                                                        else $valvence = true;
                                                                                                    }
                                                                                                } else $error[] = 'Fecha Vencimiento-Campo es requerido';
                                                                                                #   VALIDAR FECHA VENCIMIENTO SEA MAYOR O IGUAL A FECHA EMISION
                                                                                                if ($valemision && $valvence) {
                                                                                                    $vtfemision = new DateTime($femision);
                                                                                                    $vtfvence = new DateTime($fvence);
                                                                                                    if ($vtfvence < $vtfemision) $error[] = 'Fecha Vencimiento-Fecha vencimiento debe ser mayor o igual a la Fecha emisión';
                                                                                                }
                                                                                                #   SI AUXILIAR ES REQUISITO
                                                                                                if (!is_numeric($idauxi) || (int)$idauxi <= 0) $error[] = 'Auxiliar-Campo debe ser valor numérico postivio';
                                                                                                else {
                                                                                                    $Auxs = $this->contabilidad_model->getCtasAuxs(explode(',', $DCuenta->useauxi));
                                                                                                    if (count($Auxs) > 0) {
                                                                                                        $found  = false;
                                                                                                        foreach ($Auxs as $auxiliar) {
                                                                                                            if ($auxiliar->id == $idauxi) {
                                                                                                                $tauxi = '-'.$auxiliar->descrip;
                                                                                                                $found = true;
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        if (!$found) $error[] = 'Auxiliar-No existe Axuliar definido con ese ID';
                                                                                                    } else $error[] = 'Auxiliar-No hay Auxiliares activos definidos para esta Cuenta';
                                                                                                }
                                                                                                #   VALIDAR SERIE-NUMERO CUANDO SEA NEW DOC
                                                                                                if ($vserie && $vnumero) {
                                                                                                    $gaux = explode(',',$DCuenta->useauxi)[0].','.$idauxi;
                                                                                                    $vserien = $this->contabilidad_model->validateNumero($cuenta, $gaux, $ttipoDoc, $serie, $numero, null);
                                                                                                    if (!$vserien) $error[] = 'Número-Número ya existente';
                                                                                                }
                                                                                                #   VALIDANDO GESTOR
                                                                                                if (!is_numeric($idgestor) || (int)$idgestor <= 0) $error[] = 'Gestor-Campo es requerido';
                                                                                                else {
                                                                                                    $Gestores = $this->contabilidad_model->getGestores();
                                                                                                    if (count($Gestores) > 0) {
                                                                                                        $found = false;
                                                                                                        foreach ($Gestores as $gestor) {
                                                                                                            if ((int)$idgestor == $gestor->id) {
                                                                                                                $found = true;
                                                                                                                $tgestor = '-'.$gestor->descrip;
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        if (!$found) $error[] = 'Gestor-No existe Gestor activo con ese ID';
                                                                                                    } else $error[] = 'Gestor-No hay gestores activos creados';
                                                                                                }
                                                                                            }
                                                                                        } else $error[] = 'Tipo de Documento-Tipos de documentos no estan definidos/creados';
                                                                                    }
                                                                                    #   ABONO O CARGO
                                                                                    else {
                                                                                        #   VALIDAR DEBE Y HABER
                                                                                        $valmonto = false;
                                                                                        $monto = 0;
                                                                                        $Emonto = '';
                                                                                        switch ($DCuenta->catgrupo) {
                                                                                            case 1:
                                                                                                if ($ACOpcion == 1) {
                                                                                                    if (!$nhaber) $error[] = 'Haber-Campo es requerido';
                                                                                                    $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                                                    if (!$vhaber) $error[] = 'Haber-Campor debe ser numérico';
                                                                                                    else {
                                                                                                        if ((float)$haber <= 0) $error[] = 'Haber-Campo debe ser mayor que 0';
                                                                                                        else {
                                                                                                            $valmonto = true;
                                                                                                            $monto = $haber;
                                                                                                        }
                                                                                                    }
                                                                                                    $Emonto = 'Haber';
                                                                                                } else {
                                                                                                    if (!$ndebe) $error[] = 'Debe-Campo es requerido';
                                                                                                    $vdebe = preg_match("/^([0-9])+(\.[0-9]+)?$/", $debe);
                                                                                                    if (!$vdebe) $error[] = 'Debe-Campo debe ser numérico';
                                                                                                    else {
                                                                                                        if ((float)$debe <= 0) $error[] = 'Campo debe ser mayor que 0';
                                                                                                        else {
                                                                                                            $valmonto = true;
                                                                                                            $monto = $debe;
                                                                                                        }
                                                                                                    }
                                                                                                    $Emonto = 'Debe';
                                                                                                }
                                                                                            break;
                                                                                            case 2:
                                                                                                if ($ACOpcion == 1) {
                                                                                                    if (!$ndebe) $error[] = 'Debe-Campo es requerido';
                                                                                                    $vdebe = preg_match("/^([0-9])+(\.[0-9]+)?$/", $debe);
                                                                                                    if (!$vdebe) $error[] = 'Debe-Campo debe ser numérico';
                                                                                                    else {
                                                                                                        if ((float)$debe <= 0) $error[] = 'Campo debe ser mayor que 0';
                                                                                                        else {
                                                                                                            $valmonto = true;
                                                                                                            $monto = $debe;
                                                                                                        }
                                                                                                    }
                                                                                                    $Emonto = 'Debe';
                                                                                                } else {
                                                                                                    if (!$nhaber) $error[] = 'Haber-Campo es requerido';
                                                                                                    $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                                                    if (!$vhaber) $error[] = 'Haber-Campor debe ser numérico';
                                                                                                    else {
                                                                                                        if ((float)$haber <= 0) $error[] = 'Haber-Campo debe ser mayor que 0';
                                                                                                        else {
                                                                                                            $valmonto = true;
                                                                                                            $monto = $haber;
                                                                                                        }
                                                                                                    }
                                                                                                    $Emonto = 'Haber';
                                                                                                }
                                                                                            break;
                                                                                        }
                                                                                        #   SI AUXILIAR ES REQUISITO
                                                                                        $foundAux  = false;
                                                                                        $rarray = [];
                                                                                        if (!is_numeric($idauxi) || (int)$idauxi <= 0) $error[] = 'Auxiliar-Campo debe ser valor numérico positivo';
                                                                                        else {
                                                                                            $AuxialresUsados = $this->contabilidad_model->getAuxsUse($DCuenta->useauxi);
                                                                                            if ($AuxialresUsados != false) {
                                                                                                foreach ($AuxialresUsados as $auxusado) {
                                                                                                    if ($auxusado->idauxi == (int)$idauxi) {
                                                                                                        $foundAux = true;
                                                                                                        $rarray = [$auxusado->idtabla, $auxusado->idauxi];
                                                                                                        $dataAuxusuado = $this->contabilidad_mdoel->getCtasAuxs2($rarray);
                                                                                                        if (count($dataAuxusuado) > 0) $tauxi = '-'.$dataAuxusuado[0]->descrip;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                if (!$foundAux) $error[] = 'No existe Auxiliar definido con ese ID';
                                                                                            } else $error[] = 'Auxliar-No hay Auxiliares para Abono o Cargo para esta Cuenta';
                                                                                        }
                                                                                        #   VALIDAR SI EXISTE ESE DOCUMENTO A ABONAR O CARGAR
                                                                                        if ($foundAux) {
                                                                                            $ACfound = false;
                                                                                            $DataAC = [];
                                                                                            $tarray = implode(',', $rarray);
                                                                                            $getMovesAC = $this->contabilidad_model->getAC($cuenta, $tarray);
                                                                                            if ($getMovesAC != false) {
                                                                                                foreach ($getMovesAC as $movimiento) {
                                                                                                    if (($movimiento->doc_serie == $serie) &&
                                                                                                    ($movimiento->numero == $numero) &&
                                                                                                    ($movimiento->doc_emision == $femision)) {
                                                                                                        $ACfound = true;
                                                                                                        $DataAC = $movimiento;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                            if ($ACfound) {
                                                                                                if ($valmonto) {
                                                                                                    $saldo = $this->getSTC($DCuenta->catgrupo, $DataAC->debe, $DataAC->haber);
                                                                                                    if ($ACOpcion == 1) {
                                                                                                        if ((float)$monto <= 0 || (float)$monto > $saldo) $error[] = $Emonto.'-Monto a Abono debe ser menor que el saldo y mayor que 0';
                                                                                                    } else {
                                                                                                        if ((float)$monto <= 0) $error[] = $Emonto.'-Monto a Cargo debe ser mayor que 0';
                                                                                                    }
                                                                                                }
                                                                                            } else $error[] = 'No existe Abono o Cargo con ese ese Auxiliar, Serie, Número y Fecha de emisión';
                                                                                        }
                                                                                    }
                                                                                } else $error[] = 'Tipo de Documento-Campo es requerido';
                                                                            break;
                                                                            default:
                                                                                #   SI AUXILIAR ES REQUISITO
                                                                                if (strlen($DCuenta->useauxi) > 0) {
                                                                                    #   VALIDANDO SI VIENE AUXILIAR
                                                                                    if (!is_numeric($idauxi) || (int)$idauxi <= 0) $error[] = 'Auxiliar-Campo debe ser valor numérico positivo';
                                                                                    else {
                                                                                        $Auxs = $this->contabilidad_model->getCtasAuxs(explode(',', $DCuenta->useauxi));
                                                                                        if (count($Auxs) > 0) {
                                                                                            $found = false;
                                                                                            foreach ($Auxs as $auxiliar) {
                                                                                                if ($auxiliar->id == $idauxi) {
                                                                                                    $tauxi = '-'.$auxiliar->descrip;
                                                                                                    $found = true;
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            if (!$found) $error[] = 'Auxiliar-No existe Auxiliar definidio con ese ID';
                                                                                        } else $error[] = 'Auxiliar-No hay Auxiliares Activos definidos por esta Cuenta';
                                                                                    }
                                                                                }
                                                                                #   VALIDANDO DEBE Y HABER
                                                                                if ($ndebe && $nhaber) {
                                                                                    $error[] = 'Debe-No puede haber valor en el debe y haber al mismo tiempo';
                                                                                    $error[] = 'Haber-No puede haber valor en el debe y haber al mismo tiempo';
                                                                                } else {
                                                                                    if ($ndebe) {
                                                                                        $vdebe = preg_match("/^([0-9])+(\.[0-9]+)?$/", $debe);
                                                                                        if (!$vdebe) $error[] = 'Debe-Valor debe ser numérico';
                                                                                        else {
                                                                                            if ((float)$debe <= 0) $error[] = 'Debe-Valor debe ser numérico positivo';
                                                                                        }
                                                                                    } else if ($nhaber) {
                                                                                        $vhaber = preg_match("/^([0-9])+(\.[0-9]+)?$/", $haber);
                                                                                        if (!$vhaber) $error[] = 'Debe-Valor debe ser numérico';
                                                                                        else {
                                                                                            if ((float)$haber <= 0) $error[] = 'Debe-Valor debe ser numérico positivo';
                                                                                        }
                                                                                    } else {
                                                                                        $error[] = 'Debe-Para esta cuenta debe ingresar un valor en el debe o haber';
                                                                                        $error[] = 'Haber-Para esta cuenta debe ingresar un valor en el debe o haber';
                                                                                    }
                                                                                }
                                                                            break;
                                                                        }

                                                                        #-
                                                                    } else $error[] = 'Cuenta-Cuenta de Movimiento (Acceso Restringuido)';
                                                                    
                                                                } else $error[] = 'Cuenta-Cuenta de Movimiento no existe';
                                                                #   Descipcion del movimiento
                                                                if (strlen($dmovimiento) == 0) $error[] = 'Descripcion del Movimiento-Campo requerido';
                                                            }
                                                        } else $error[] = 'Tipo de Partida-Tipo Partida no contiene este periodo permitido';
                                                    }
                                                    #-
                                                } else $error[] = 'Fecha-Fecha no esta en el mes elegido';
                                            } else $error[] = 'Fecha-Fecha no esta en el año elegido';
                                        }
                                    }
                                } else $error[] = 'Fecha-Campo es requerido';
                            } else $error[] = 'Tipo de Partida-No existe un Tipo de Partida con ese código';
                        } else $error[] = 'Tipo de Partida-Campo de ser un valor númerico positivo';
                        
                        $Datos[] = array(
                            'codetp' => $idtipop.$ttipop,
                            'fecha' => $fecha,
                            'referencia' => $referencia,
                            'descripcion' => $descripcion,
                            'cuenta' => $cuenta,
                            'idauxi' => $idauxi.$tauxi,
                            'idcentro' => $idcentro.$tcentro,
                            'idproyecto' => $idproyecto.$tproyecto,
                            'dmovimiento' => $dmovimiento,
                            'tipodoc' => $tipodoc,
                            'serien' => implode('-', array($serie, $numero)),
                            'femision' => $femision,
                            'fvence' => $fvence,
                            'idgestor' => $idgestor.$tgestor,
                            'debe' => $debe,
                            'haber' => $haber,

                            'line' => $key + 1,
                            'error' => implode(';', $error),
                            'cerror' => (count($error) > 0) ? true : false,
                        );
                        if (count($error) > 0) $conteoError++;
                    } else {
                        $conteoError++;
                        $Datos[] = array(
                            'codetp' => '',
                            'fecha' => '',
                            'referencia' => '',
                            'descripcion' => 'Parámetros incompletos',
                            'cuenta' => '',
                            'idauxi' => '',
                            'idcentro' => '',
                            'idproyecto' => '',
                            'dmovimiento' => '',
                            'tipodoc' => '',
                            'serien' => '',
                            'femision' => '',
                            'fvence' => '',
                            'idgestor' => '',
                            'debe' => '',
                            'haber' => '',
                            'cerror' => true,
                            'error' => 'Parámetros incompletos',
                        );
                    }//*/
                }
                $datA[] = array('valido' => (($conteoError == 0) ? true : false), 'datos' => $Datos);
                echo json_encode($datA);
            }
        }
        #   IMPORTAR PARTIDAS
        public function importPartidasTxt()
        {
            if($this->validatePermiso()) {
                $year = $this->input->post('year');
                $month = $this->input->post('month');
                //$d = (new DateTime($idyear.'-'.$month.'-01'))->format('t');
                $this->load->model('contabilidad_model');
                date_default_timezone_set('America/El_Salvador');
                $Datos = [];
                $Registros = trim($this->input->post('registros'));

                $DSPartida = explode(";", trim(explode("\n", $Registros)[0]));
                $DPartida = array(
                    'ID' => 0,
                    'referencia' => trim($DSPartida[2]),
                    'fecha' => trim($DSPartida[1]),
                );
                $data = array(
                    'idyear' => $year,
                    'idptipo' => (int)trim($DSPartida[0]),
                    'idsite' => $this->session->userdata('idcentrouser'),
                    'descrip' => trim($DSPartida[3]),
                    'fecha' => trim($DSPartida[1]),
                    'referencia' => $DPartida['referencia'],
                    'origen' => 'Importador TxT',
                    'estatus' => 0,
                    'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                    'notas' => '',
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s')
                );
                $error = [];
                $conteo = 0;
                $valpartida = false;
                if ($ID = $this->contabilidad_model->setEPartidas($data)) {
                    /*print_r($data);
                    $ID = 0;
                    if (true) {//*/
                    $valpartida = true;
                    $DPartida['ID'] = $ID;
                } else {
                    $conteo++;
                    $error[] = $DPartida['referencia'];
                }
                foreach (explode("\n", $Registros) as $registro) {
                    $dato = explode(";", trim($registro));
                    $idtipop = trim($dato[0]);
                    $fecha = trim($dato[1]);
                    $referencia = trim($dato[2]);
                    $descripcion = trim($dato[3]);
                    $cuenta = trim($dato[4]);
                    $idauxi = trim($dato[6]);
                    $idcentro = trim($dato[7]);
                    $idproyecto = trim($dato[8]);
                    $dmovimiento = trim($dato[9]);
                    $tipodoc = trim($dato[10]);
                    $ttipodoc = '';
                    $serie = trim($dato[11]);
                    $numero = trim($dato[12]);
                    $femision = trim($dato[13]);
                    $fvence = trim($dato[14]);
                    $idgestor = trim($dato[15]);
                    $debe = trim($dato[16]);
                    $haber = trim($dato[17]);

                    if ($referencia != $DPartida['referencia']) {
                        $data = array(
                            'idyear' => $year,
                            'idptipo' => (int)$idtipop,
                            'idsite' => $this->session->userdata('idcentrouser'),
                            'descrip' => $descripcion,
                            'fecha' => $fecha,
                            'referencia' => $referencia,
                            'origen' => 'Importador TxT',
                            'estatus' => 0,
                            'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                            'notas' => '',
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s')
                        );
                        if ($ID = $this->contabilidad_model->setEPartidas($data)) {
                            /*print_r($data);
                            $ID = 0;
                            if (true) {//*/
                            $valpartida = true;
                            $DPartida['ID'] = $ID;
                            $DPartida['fecha'] = $fecha;
                            $DPartida['referencia'] = $referencia;
                        } else {
                            $valpartida = false;
                            $conteo++;
                            $error[] = $referencia;
                        }
                    }

                    if ($valpartida) {
                        $data = array(
                            'pnumero' => $DPartida['ID'],
                            'itemline' => $this->contabilidad_model->getCountMov($DPartida['ID']) + 1,
                            'fecha' => $DPartida['fecha'],
                            'idctcuenta' => $cuenta,
                            'idcentro' => (int)$idcentro,
                            'idproject' => (int)$idproyecto,
                            'descrip' => $dmovimiento,
                            'estatus' => 0,
                            'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s')
                        );
                        $DCuenta = $this->contabilidad_model->getCuenta3($cuenta);
                        #  VIENE DEBE Y HABER
                        $ndebe = true;
                        if ($debe == "0") $ndebe = false;
                        $nhaber = true;
                        if ($haber == "0") $nhaber = false;//*/
                        switch ($DCuenta->ctcontrol) {
                            /*case 0:
                            case 3:
                            case 4:
                            case 5:
                            case 6:
                            case 7:
                            break;//*/
                            case 1:
                                $data['idtabla'] = (int)explode(',', $DCuenta->useauxi)[0];
                                $data['idauxi'] = $idauxi;
                                $data['doc_serie'] = $serie;
                                $data['doc_numero'] = $numero;
                                $IDOpcion = 0;
                                foreach ($this->OpcionesBancos as $opcion) {
                                    if ($opcion['ID'] != 10) {
                                        if (strtolower($opcion['Name']) == strtolower($tipodoc)) {
                                            $IDOpcion = $opcion['ID'];
                                            $ttipodoc = $opcion['Name'];
                                            break;
                                        }
                                    }
                                }
                                if ($DCuenta->catgrupo == 1) {
                                    switch ($IDOpcion) {
                                        case 0:
                                        case 2:
                                        case 4:
                                            $data['haber'] = $haber;
                                        break;
                                        case 1:
                                        case 3:
                                            $data['debe'] = $debe;
                                        break;
                                    }
                                } else $data['haber'] = $haber;
                                $data['doc_type'] = $ttipodoc;
                            break;
                            case 2:
                                $data['doc_emision'] = $femision;
                                #   ABONO O CARGO
                                if (strtolower($tipodoc) == 'abono' || strtolower($tipodoc) == 'cargo') {
                                    $ACOpcion = (strtolower($tipodoc) == 'abono') ? 1 : 2;
                                    $data['doc_controlnum'] = ($ACOpcion == 1) ? 'Abono' : 'Cargo';
                                    #   GET AUXS USADOS
                                    $AuxialresUsados = $this->contabilidad_model->getAuxsUse($DCuenta->useauxi);
                                    foreach ($AuxialresUsados as $auxusado) {
                                        if ($auxusado->idauxi == (int)$idauxi) {
                                            $rarray = [$auxusado->idtabla, $auxusado->idauxi];
                                            break;
                                        }
                                    }
                                    #   GET ABONO O CARGO
                                    $DataAC = [];
                                    $rarray = [];
                                    $tarray = implode(',', $rarray);
                                    $getMovesAC = $this->contabilidad_model->getAC($cuenta, $tarray);
                                    foreach ($getMovesAC as $movimiento) {
                                        if (($movimiento->doc_serie == $serie) &&
                                        ($movimiento->numero == $numero) &&
                                        ($movimiento->doc_emision == $femision)) {
                                            $DataAC = $movimiento;
                                        }
                                    }
                                    $data['idauxi'] = $idauxi;
                                    $data['idtabla'] = $rarray[0];
                                    $data['doc_type'] = $DataAC->doc_type;
                                    $data['doc_serie'] = $DataAC->doc_serie;
                                    $data['doc_numero'] = $DataAC->doc_numero;
                                    $data['doc_vence'] = $DataAC->doc_vence;
                                    $data['doc_idworker'] = $DataAC->doc_idworker;
                                    switch ($DCuenta->catgrupo) {
                                        case 1:
                                            if ($ACOpcion == 1) $data['haber'] = $haber;
                                            else $data['debe'] = $debe;
                                        break;
                                        case 2:
                                            if ($ACOpcion == 1) $data['debe'] = $debe;
                                            else $data['haber'] = $haber;
                                        break;
                                    }
                                } # NEW DOCUMENTO
                                else {
                                    $data['idauxi'] = $idauxi;
                                    $data['idtabla'] = explode(',', $DCuenta->useauxi)[0];
                                    $data['doc_serie'] = $serie;
                                    $data['doc_numero'] = $numero;
                                    $data['doc_idworker'] = $idgestor;
                                    $data['doc_vence'] = $fvence;
                                    $TiposDocs = [];
                                    $TiposDocsC = $this->contabilidad_model->getTipoDocs(1);
                                    if (count($TiposDocsC) > 0) {
                                        foreach ($TiposDocsC as $tdoc) {
                                            $TiposDocs[] = $tdoc;
                                        }
                                    }
                                    $TiposDocsC = $this->contabilidad_model->getTipoDocs(2);
                                    if (count($TiposDocsC) > 0) {
                                        foreach ($TiposDocsC as $tdoc) {
                                            $TiposDocs[] = $tdoc;
                                        }
                                    }
                                    foreach ($TiposDocs as $tdoc) {
                                        if (strtolower($tipodoc) == strtolower($tdoc->descrip)) {
                                            $ttipodoc = $tdoc->descrip;
                                            break;
                                        }
                                    }
                                    $data['doc_type'] = $ttipodoc;
                                    switch ($DCuenta->catgrupo) {
                                        case 1:
                                            # Debe
                                            $data['debe'] = $debe;
                                        break;
                                        case 2:
                                            # Haber
                                            $data['haber'] = $haber;
                                        break;
                                    }
                                }
                            break;
                            default:
                                if (strlen(trim($DCuenta->useauxi)) > 0) {
                                    $data['idauxi'] = (int)$idauxi;
                                    $data['idtabla'] = (int)explode(',', $DCuenta->useauxi)[0];
                                }
                                $data['debe'] = $debe;
                                $data['haber'] = $haber;
                            break;
                        }
                        if(!$this->contabilidad_model->setEPDetalle($data)){
                            /*print_r($data);
                            if (true) {//*/
                            $conteo++;
                            $error[] = implode('-', array($DPartida['referencia'], $data['idctcuenta']));
                        }
                    }
                }
                echo json_encode(array(
                    'valido' => ($conteo > 0) ? false : true,
                    'error' => implode(',', $error),
                    'datos' => $datos = $this->contabilidad_model->getEPartidas($year, $month)
                ));
                #--
            }
        }
    #-
    #-------------------------------------------------------------- RECONSTRUCCION DE SALDOS
        #   GET PARTIDAS ACTUALIZADAS
        public function getAPartidas()
        {
            if($this->validatePermiso()) {
                $this->load->model('contabilidad_model');
                $Datos = $this->contabilidad_model->getAPartidas();
                $datA[] = array('valido' => true, 'datos' => $Datos);
                echo json_encode($datA);
            }
        }
        #   LIMPIANDO SALDOS
        public function clearSaldos()
        {
            if($this->validatePermiso()) {
                $this->load->model('contabilidad_model');
                $this->contabilidad_model->clearSaldos();
                $datA[] = array('valido' => true);
                echo json_encode($datA);
            }
        }
        #   RECONSTRUYENDO SALDO
        public function rebuildSaldo()
        {
            if($this->validatePermiso()) {
                $this->load->model('contabilidad_model');

                $datos = $this->contabilidad_model->getAPartidas(1);
                foreach ($datos->result() as $partida) {
                    $this->contabilidad_model->cerrarEPartida($partida->pnumero, 0, 1,$this->session->userdata('iduser'));
                    $data = array(
                        'fecact' => $partida->fecact,
                        'chg_log' => $partida->chg_log
                    );
                    $this->multiplesContabilidad(10, ['campo' => 'pnumero', 'valor' => $partida->pnumero, 'data' => $data, 'tabla' => 'ct_100']);
                }
                $datA[] = array('valido' => true);
                echo json_encode($datA);
            }
        }
    #-
    #   -------------------------------------------------------------------------- REPORTES ***
    public function EPReporte($ID = null, $tipo = null)
    {
        if($this->validatePermiso()) {
            if ($ID != null && $tipo != null) {
                if (is_numeric($ID)) {
                    $this->load->model('contabilidad_model');
                    if ($dato = $this->contabilidad_model->getEPDetalle((int)$ID)) {
                        $status = array(
                            'En Elaboración' => 0,
                            'Actualizada' => 1,
                            'Anulada' => 9,
                        );
                        $dato->estado = array_search($dato->estatus, $status);
                        switch ($tipo) {
                            case 1:                                                                                           
                                $this->formato1($dato);                            
                            break;
                            case 2:
                                $this->formato2($dato);
                            break;
                            case 3:
                                $this->formato3($dato);
                            break;
                            case 4:
                                $this->formato4($dato);
                            break;
                            default: 
                                show_404();
                            break;
                        }
                    } else echo "<h1>Partida no existe</h1>";
                } else echo "<h1>Parámetro ID Incorrecto</h1>";
            } else echo "<h1>Faltan Parámetros</h1>";
        }
    }

    private function formato1($Dato)
    {
        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $this->session->userdata('userLog');
            $header = '
                <table style="width=100%; ">
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                    </tr>
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width: 100%; text-align: center;"><strong>'.$Dato->tipoP.'</strong></td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlHeader($header);
            //header
            $footer = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="line-height: 10px;"><td></td></tr>
                    <tr style="font-size: 9px;">
                        <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;"></td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($footer);
            //footer
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Detalle de Partida - Formato Simple');
            $pdf->SetMargins(10, 20, 10);// left top right
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
            
            $html = '';
            $html .= '
                <table style="width=100%; font-family: Arial;">
                    <tr style="text-align: center;">
                        <td style="width: 10%; border: 1px solid black;"><strong>Fecha</strong></td>
                        <td style="width: 9%; border: 1px solid black;"><strong>Número</strong></td>
                        <td style="width: 16%; border: 1px solid black;"><strong>Referencia</strong></td>
                        <td style="width: 9%; border: 1px solid black;"><strong>Cor. Mes.</strong></td>
                        <td style="width: 13%; border: 1px solid black;"><strong>Estado</strong></td>
                        <td style="width: 43%; border: 1px solid black;"><strong>Concepto</strong></td>
                    </tr>
                    <tr style="text-align: center;">
                        <td style="width: 10%; border: 1px solid black;">'.date_format(date_create($Dato->fecha), "d/m/Y").'</td>
                        <td style="width: 9%; border: 1px solid black;">'.$Dato->pnumero.'</td>
                        <td style="width: 16%; border: 1px solid black;">'.$Dato->referencia.'</td>
                        <td style="width: 9%; border: 1px solid black;">'.$Dato->num_mes.'</td>
                        <td style="width: 13%; border: 1px solid black;">'.$Dato->estado.'</td>
                        <td style="width: 43%; text-align: left; border: 1px solid black;">'.$Dato->descrip.'</td>
                    </tr>
                    <tr style="text-align: center; line-height: 17px; font-family: Minion;">
                        <td style="width: 12%; border: 1px solid black;" ><strong>Cuenta</strong></td>
                        <td style="width: 32%; border: 1px solid black;" ><strong>Titulo de la Cuenta</strong></td>
                        <td style="width: 32%; border: 1px solid black;" ><strong>Descripción del Movimiento</strong></td>
                        <td style="width: 12%; border: 1px solid black;" ><strong>Debe</strong></td>
                        <td style="width: 12%; border: 1px solid black;" ><strong>Haber</strong></td>
                    </tr>
                    <tr style="line-height: 1px;"><td></td></tr>
                </table>
                ';
            //datos
            $debe = 0;
            $haber = 0;
            $registros = $this->contabilidad_model->getEPRegistroR($Dato->pnumero);
            if ($registros->num_rows() > 0) {
                $html .= '<table>';
                foreach ($registros->result() as $valor) {
                    if ($valor->estatus == 1) {
                        $extra = array(
                            'idauxi' => '',
                            'auxi' => '',
                            'idcentro' => '',
                            'centro' => '',
                        );
                        if ($valor->idtabla != 0) {
                            $auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
                            $extra['idauxi'] = $valor->idauxi;
                            $extra['auxi'] = $auxi->descrip;
                        }
                        $extra2 = '';
                        if ($valor->idcentro != 0) {
                            $centro = $this->contabilidad_model->getCentro($valor->idcentro);
                            $extra2 = '
                                <tr>
                                    <td style="width: 11%; font-size: 8px; text-align: right;">'.$valor->idcentro.'</td>
                                    <td style="width: 1%;"></td>
                                    <td style="width: 88%; font-size: 8px;">'.$centro->descrip.'</td>
                                </tr>
                            ';
                        }
                        $vdebe = number_format((float)$valor->debe, 2, '.', '');
                        $vhaber = number_format((float)$valor->haber, 2, '.', '');
                        if(strlen($valor->doc_type) > 0 && strlen($valor->doc_serie) > 0 && strlen($valor->doc_numero) > 0){
                            $html .= '
                                <tr>
                                    <td style="width: 12%;">'.$valor->idctcuenta.'</td>
                                    <td style="width: 64%;">'.$valor->descripct.'</td>
                                    <td style="width: 12%; text-align: right;">'.( ( $valor->debe > 0) ? $vdebe : '' ).'</td>
                                    <td style="width: 12%; text-align: right;">'.( ( $valor->haber > 0) ? $vhaber : '' ).'</td>
                                </tr>
                                <tr>
                                    <td style="width: 11%; font-size: 8px; text-align: right;">'.$extra['idauxi'].'</td>
                                    <td style="width: 1%;"></td>
                                    <td style="width: 32%; font-size: 8px;">'.$extra['auxi'].'</td>
                                    <td style="width: 32%; font-size: 8px;">'.$valor->descrip.'<br>'.$valor->doc_type.' N° '.$valor->doc_serie.'-'.$valor->doc_numero.'</td>
                                    <td style="width: 12%; text-align: right;"></td>
                                    <td style="width: 12%; text-align: right;"></td>
                                </tr>
                            ';
                        }else{
                            $html .= '
                                <tr>
                                    <td style="width: 12%;">'.$valor->idctcuenta.'</td>
                                    <td style="width: 64%;">'.$valor->descripct.'</td>
                                    <td style="width: 12%; text-align: right;">'.( ( $valor->debe > 0) ? $vdebe : '' ).'</td>
                                    <td style="width: 12%; text-align: right;">'.( ( $valor->haber > 0) ? $vhaber : '' ).'</td>
                                </tr>
                                <tr>
                                    <td style="width: 11%; font-size: 8px; text-align: right;">'.$extra['idauxi'].'</td>
                                    <td style="width: 1%;"></td>
                                    <td style="width: 32%; font-size: 8px;">'.$extra['auxi'].'</td>
                                    <td style="width: 32%; font-size: 8px;">'.$valor->descrip.'</td>
                                    <td style="width: 12%; text-align: right;"></td>
                                    <td style="width: 12%; text-align: right;"></td>
                                </tr>
                            ';
                        }
                        $html .= $extra2;
                        $debe += $valor->debe;
                        $haber += $valor->haber;
                    }
                }
                $html .= '</table>';
            }
            //  fin
            $html .= '
                <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                <table style="width=100%; padding-top: 2px; border-top: 1px solid black; font-family: Calibri;">
                    <tr style="text-align: right;">
                        <td style="width: 76%;" ><strong>TOTALES</strong></td>
                        <td style="width: 12%;" ><strong>'.number_format((float)$debe, 2, '.', '').'</strong></td>
                        <td style="width: 12%;" ><strong>'.number_format((float)$haber, 2, '.', '').'</strong></td>
                    </tr>
                </table>
                <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                <table style="width=100%;">
                    <tr style="font-size: 8px;">
                        <td style="width: 19%; text-align: center;">'.$usuario.'</td>
                        <td style="width: 81%;"></td>
                    </tr>
                    <tr>
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Contador</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Revisado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Auditoria</td>
                    </tr>
                </table>
                ';

            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }

    private function formato4($Dato)
    {
        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $this->session->userdata('userLog');
            $header = '
                <table style="width=100%; ">
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                    </tr>
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width: 100%; text-align: center;"><strong>'.$Dato->tipoP.'</strong></td>
                    </tr>
                </table>
            ';

            $pdf->setHtmlHeader($header);
            //header
            $footer = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="line-height: 10px;"><td></td></tr>
                    <tr style="font-size: 9px;">
                        <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;"></td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($footer);
            //footer
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Detalle de Partida - Formato Simple');
            $pdf->SetMargins(10, 20, 10);// left top right
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
            
            $html = '';
            $html .= '
                <table style="width=100%; font-family: Arial;">
                    <tr style="text-align: center;">
                        <td style="width: 10%; border: 1px solid black;"><strong>Fecha</strong></td>
                        <td style="width: 9%; border: 1px solid black;"><strong>Número</strong></td>
                        <td style="width: 16%; border: 1px solid black;"><strong>Referencia
                        </strong></td>
                        
                        <td style="width: 13%; border: 1px solid black;"><strong>Estado</strong></td>
                        <td style="width: 52%; border: 1px solid black;"><strong>Concepto</strong></td>
                    </tr>
                    <tr style="text-align: center;">
                        <td style="width: 10%; border: 1px solid black;">'.date_format(date_create($Dato->fecha), "d/m/Y").'</td>
                        <td style="width: 9%; border: 1px solid black;">'.$Dato->pnumero.'</td>
                        <td style="width: 16%; border: 1px solid black;">'.$Dato->referencia.'</td>
                        
                        <td style="width: 13%; border: 1px solid black;">'.$Dato->estado.'</td>
                        <td style="width: 52%; text-align: left; border: 1px solid black;">'.$Dato->descrip.'</td>
                    </tr>
                    <tr style="text-align: center; line-height: 17px; font-family: Minion;">
                        <td style="width: 12%; border: 1px solid black;" ><strong>Cuenta</strong></td>
                        <td style="width: 30%; border: 1px solid black;" ><strong>Descripcion del movimiento</strong></td>
                        <td style="width: 5%; border: 1px solid black;" ><strong>CC</strong></td>
                        <td style="width: 13%; border: 1px solid black;" ><strong>Referencia</strong></td>
                        <td style="width: 10%; border: 1px solid black;" ><strong>Detalle</strong></td>
                        <td style="width: 10%; border: 1px solid black;" ><strong>Parciales</strong></td>
                        <td style="width: 10%; border: 1px solid black;" ><strong>Debe</strong></td>

                        <td style="width: 10%; border: 1px solid black;" ><strong>Haber</strong></td>
                    </tr>
                    <tr style="line-height: 1px;"><td></td></tr>
                </table>
                ';
                
            //datos
            $debe = 0;
            $haber = 0;
            $sumaFor = 0;
            $registros = $this->contabilidad_model->getEPRegistroROrderByCtCuenta($Dato->pnumero);
            $TotalAmount = $this->contabilidad_model->getEPRegistroROrderByCtCuentaSumaTotal($Dato->pnumero);
            $idCuentaActual = 0;
            $totalSumCuenta = 0;
            $isFirstAccount = false;
            $cuentaArray = [];
            if ($registros->num_rows() > 0) {
                $html .= '<table>';

                foreach(  $registros->result() as $valor ){
                    $cuentaArray[] = $valor->idctcuenta;
                }

                $parcialesCuenta = array_count_values($cuentaArray);

                foreach ($registros->result() as $valor) {                                       
                    if ($valor->estatus == 1) {
                        $extra = array(
                            'idauxi' => '',
                            'auxi' => '',
                            'idcentro' => '',
                            'centro' => '',
                        );
                        $totalDebe = 0;
                        $totalHaber = 0;
                        foreach($TotalAmount->result() as $Amount){
                            if( $valor->idctcuenta == $Amount->idctcuenta){
                                $totalDebe = $Amount->total_debe;
                                $totalHaber = $Amount->total_haber;
                                break;
                            }
                        }                        
                        
                        // end RM funcion 
                        $referenciaXpos = ''; // creado RM

                        if ($valor->idtabla != 0) {
                            $auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
                            $extra['idauxi'] = $valor->idauxi;
                            $extra['auxi'] = $auxi->descrip;
                            $referenciaXpos = $auxi->xpos; // creado RM
                        }

                        if (empty($referenciaXpos)) {
                            $referenciaXpos = $extra['idauxi'];
                        }

                        $extra2 = '';
                        if ($valor->idcentro != 0) {
                            $centro = $this->contabilidad_model->getCentro($valor->idcentro);
                            $extra2 = '
                                <tr>
                                    <td style="width: 11%; font-size: 8px; text-align: right;">'.$valor->idcentro.'</td>
                                    <td style="width: 1%;"></td>
                                    <td style="width: 88%; font-size: 8px;">'.$centro->descrip.'</td>
                                </tr>
                            ';
                        }

                        $parciales = 0;
                        $SumaPorCuenta = 0;
                        $detalle = 0;                     
                        $vdebe = number_format((float)$valor->debe, 2, '.', '');
                        $vhaber = number_format((float)$valor->haber, 2, '.', '');
                        if ($idCuentaActual !== $valor->idctcuenta) {
                            $idCuentaActual = $valor->idctcuenta;
                            //$totalSumCuenta = $totalSumCuenta + $valor->idctcuenta;
                            $isFirstAccount = true;
                        } else {
                            //$totalSumCuenta = 0;
                            $isFirstAccount = false;
                        }

                        if(strlen($valor->doc_type) > 0 && strlen($valor->doc_serie) > 0 && strlen($valor->doc_numero) > 0){

                            if( $vdebe > 0){
                                $detalle = $vdebe;
                            }elseif( $vhaber > 0){
                                $detalle = $vhaber;
                            }

                            if( $totalDebe  > 0){
                                $parciales = $totalDebe;
                            }elseif( $totalHaber > 0){
                                $parciales = $totalHaber;
                            }
                            
                            if($parcialesCuenta[$valor->idctcuenta]>1 && $isFirstAccount){   
                                $html .= '

                                    <tr>
                                        <td style="width: 12%; text-align: left; font-weight: bold;">'.$valor->idctcuenta.'</td>
                                        <td style="width: 30%; font-weight: bold;">'.mb_strtoupper(strtoupper($valor->descripct), 'UTF-8').'</td> 
                                        <td style="width: 5%; text-align: center;"></td>
                                        <td style="width: 13%;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"> '.(( $parcialesCuenta[$valor->idctcuenta] > 1 ) ? $parciales : '').'</td>
                                        <td style="width: 10%; text-align: right;">'.( ( $totalDebe > 0 && $isFirstAccount === true ) ? $totalDebe : '' ).'</td>
                                        <td style="width: 10%; text-align: right;">'.( ($totalHaber > 0 && $isFirstAccount === true ) ? $totalHaber : '' ).'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 12%;">'.(!empty($referenciaXpos) ? $valor->idctcuenta.'.'.$referenciaXpos : $valor->idctcuenta ).'</td>
                                        <td style="width: 30%;">'.$valor->descrip.'</td> 
                                        <td style="width: 5%; text-align: center;"></td>
                                        <td style="width: 13%;">'.$Dato->referencia.'</td>
                                        <td style="width: 10%; text-align: right;">'.$detalle.'</td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                    </tr>
                                    <tr>
                                        <td style="width: 12%; font-size: 8px; text-align: right;"></td>
                                        <td style="width: 30%; font-size: 8px;"></td>
                                        <td style="width: 5%; text-align: center;"> </td>
                                        <td style="width: 13%; font-size: 8px;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                    </tr>';
                            }else{
                                $html .= '
                                <tr>
                                    <td style="width: 12%;">'.(!empty($referenciaXpos) ? $valor->idctcuenta.'.'.$referenciaXpos : $valor->idctcuenta ).'</td>
                                    <td style="width: 30%;">'.$valor->descrip.'</td> 
                                    <td style="width: 5%; text-align: center;"></td>
                                    <td style="width: 13%;">'.$Dato->referencia.'</td>
                                    <td style="width: 10%; text-align: right;">'.$detalle.'</td>
                                    <td style="width: 10%; text-align: right;"></td>
                                    <td style="width: 10%; text-align: right;">'.( ( $totalDebe > 0 && $isFirstAccount === true ) ? $totalDebe : '' ).'</td>
                                    <td style="width: 10%; text-align: right;">'.( ($totalHaber > 0 && $isFirstAccount === true ) ? $totalHaber : '' ).'</td>
                                </tr>
                                <tr>
                                    <td style="width: 12%; font-size: 8px; text-align: right;"></td>
                                    <td style="width: 30%; font-size: 8px;">'.$valor->doc_type.' N° '.$valor->doc_serie.'-'.$valor->doc_numero.'</td>
                                    <td style="width: 5%; text-align: center;"></td>
                                    <td style="width: 13%; text-align: right;"></td>
                                    <td style="width: 10%; text-align: right;"></td>
                                    <td style="width: 10%; text-align: right;"></td>
                                    <td style="width: 10%; text-align: right;"></td>
                                    <td style="width: 10%; text-align: right;"></td>
                                </tr>';
                            }

                            }else{
                               if( $vdebe > 0){
                                $detalle = $vdebe;
                               }elseif( $vhaber > 0){
                                $detalle = $vhaber;
                               }

                               if( $totalDebe  > 0){
                                $parciales = $totalDebe;
                                }elseif( $totalHaber > 0){
                                $parciales = $totalHaber;
                                }
                                if($parcialesCuenta[$valor->idctcuenta]>1 && $isFirstAccount){   
                                $html .= '
                                    <tr>
                                       <td style="width: 12%; text-align: left; font-weight: bold;">'.$valor->idctcuenta.'</td>
                                       <td style="width: 30%; font-weight: bold;">'.mb_strtoupper(strtoupper($valor->descripct), 'UTF-8').'</td>
                                       <td style="width: 5%; text-align: center;"> </td>
                                       <td style="width: 13%;"></td>
                                       <td style="width: 10%; text-align: right;"></td>
                                       <td style="width: 10%; text-align: right;">'.$parciales.'</td>
                                       <td style="width: 10%; text-align: right;">'.( ( $totalDebe > 0 && $isFirstAccount === true ) ? $totalDebe : '' ).'</td>
                                       <td style="width: 10%; text-align: right;">'.( ($totalHaber > 0 && $isFirstAccount === true ) ? $totalHaber : '' ).'</td>
                                   </tr>
                                   <tr>
                                       <td style="width: 12%;">'.(!empty($referenciaXpos) ? $valor->idctcuenta.'.'.$referenciaXpos : $valor->idctcuenta ).'</td>
                                       <td style="width: 30%;">'.$valor->descrip.'</td>
                                       <td style="width: 5%; text-align: center;"></td>
                                       <td style="width: 13%;">'.$Dato->referencia.'</td>
                                       <td style="width: 10%; text-align: right;">'.$detalle.'</td>
                                       <td style="width: 10%; text-align: right;"></td>
                                       <td style="width: 10%; text-align: right;"></td>
                                       <td style="width: 10%; text-align: right;"></td>                                    
                                   </tr>
                                   <tr>
                                        <td style="width: 12%; font-size: 8px; text-align: right;"></td>
                                        <td style="width: 30%; font-size: 8px;"></td>
                                        <td style="width: 5%; text-align: center;"> </td>
                                        <td style="width: 13%; font-size: 8px;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                    </tr>';
                                } else {
                                    $html .= '
                                    <tr>
                                       <td style="width: 12%;">'.(!empty($referenciaXpos) ? $valor->idctcuenta.'.'.$referenciaXpos : $valor->idctcuenta ).'</td>
                                       <td style="width: 30%;">'.$valor->descrip.'</td>
                                       <td style="width: 5%; text-align: center;"></td>
                                       <td style="width: 13%;">'.$Dato->referencia.'</td>
                                       <td style="width: 10%; text-align: right;">'.$detalle.'</td>
                                       <td style="width: 10%; text-align: right;"></td>
                                       <td style="width: 10%; text-align: right;">'.( ( $totalDebe > 0 && $isFirstAccount === true ) ? $totalDebe : '' ).'</td>
                                       <td style="width: 10%; text-align: right;">'.( ($totalHaber > 0 && $isFirstAccount === true ) ? $totalHaber : '' ).'</td>                                    
                                    </tr>
                                    <tr>
                                        <td style="width: 12%; font-size: 8px; text-align: right;"></td>
                                        <td style="width: 30%; font-size: 8px;"></td>
                                        <td style="width: 5%; text-align: center;"> </td>
                                        <td style="width: 13%; font-size: 8px;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                        <td style="width: 10%; text-align: right;"></td>
                                    </tr>';
                                }
                            }
                        $html .= $extra2;
                        $debe += $valor->debe;
                        $haber += $valor->haber;
                        
                    }
                }
                $html .= '</table>';
            }

            //  fin
            $html .= '
                <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                <table style="width=100%; padding-top: 2px; border-top: 1px solid black; font-family: Calibri;">
                    <tr style="text-align: right;">
                        <td style="width: 76%;" ><strong>TOTALES</strong></td>
                        <td style="width: 12%;" ><strong>'.number_format((float)$debe, 2, '.', '').'</strong></td>
                        <td style="width: 12%;" ><strong>'.number_format((float)$haber, 2, '.', '').'</strong></td>
                    </tr>
                </table>
                <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                <table style="width=100%;">
                    <tr style="font-size: 8px;">
                        <td style="width: 19%; text-align: center;">'.$usuario.'</td>
                        <td style="width: 81%;"></td>
                    </tr>
                    <tr>
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Contador</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Revisado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Auditoria</td>
                    </tr>
                </table>
                ';

            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }

    private function formato2($Dato)
    {

        set_time_limit(0);
        ini_set('memory_limit', '640M');

        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $this->session->userdata('userLog');
            $header = '
                <table style="width=100%; ">
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width:10%;"></td>
                        <td style="width:80%; text-align: center;"><strong>'.$empresa.'</strong></td>
                        <td style="width:10%;"></td>
                    </tr>
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width:10%;"></td>
                        <td style="width:80%; text-align: center;"><strong>'.$Dato->tipoP.'</strong></td>
                        <td style="width:10%;"></td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlHeader($header);
            //header
            $footer = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="line-height: 10px;"><td></td></tr>
                    <tr style="font-size: 9px;">
                        <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;"></td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($footer);
            //footer
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Detalle de Partida - Formato 2');
            $pdf->SetMargins(10, 20, 10);// left top right
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
            //
            $html = '';
            $html .= '
                <table style="width=100%; font-family: Arial;">
                    <tr style="text-align: center;">
                        <td style="width: 10%; border: 1px solid black;"><strong>Fecha</strong></td>
                        <td style="width: 9%; border: 1px solid black;"><strong>Número</strong></td>
                        <td style="width: 16%; border: 1px solid black;"><strong>Referencia</strong></td>
                        <td style="width: 9%; border: 1px solid black;"><strong>Cor. Mes.</strong></td>
                        <td style="width: 13%; border: 1px solid black;"><strong>Estado</strong></td>
                        <td style="width: 43%; border: 1px solid black;"><strong>Concepto</strong></td>
                    </tr>
                    <tr style="text-align: center;">
                        <td style="width: 10%; border: 1px solid black;">'.date_format(date_create($Dato->fecha), "d/m/Y").'</td>
                        <td style="width: 9%; border: 1px solid black;">'.$Dato->pnumero.'</td>
                        <td style="width: 16%; border: 1px solid black;">'.$Dato->referencia.'</td>
                        <td style="width: 9%; border: 1px solid black;">'.$Dato->num_mes.'</td>
                        <td style="width: 13%; border: 1px solid black;">'.$Dato->estado.'</td>
                        <td style="width: 43%; text-align: left; border: 1px solid black;">'.$Dato->descrip.'</td>
                    </tr>
                    <tr style="text-align: center; line-height: 12px; font-family: Minion;">
                        <td style="width: 7%; border-left: 1px solid black; border-right: 1px solid black;" ><strong>#</strong></td>
                        <td style="width: 63%; border-right: 1px solid black;" ></td>
                        <td style="width: 15%; border-right: 1px solid black;" ></td>
                        <td style="width: 15%; border-right: 1px solid black;" ></td>
                    </tr>
                    <tr style="text-align: center; line-height: 10px; font-family: Minion;">
                        <td style="width: 7%; border-bottom: 1px solid black; border-left: 1px solid black; border-right: 1px solid black; height: 12px;" ><strong>Linea</strong></td>
                        <td style="width: 63%; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong>Descripción del Movimiento</strong></td>
                        <td style="width: 15%; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong>Debe</strong></td>
                        <td style="width: 15%; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong>Haber</strong></td>
                    </tr>
                    <tr style="line-height: 1px;"><td></td></tr>
                </table>';
            //datos
            $debe = 0;
            $haber = 0;
            $datos = $this->contabilidad_model->getEPRegistroRG($Dato->pnumero);
            if($datos->num_rows() > 0){
                $html .= '<table>';
                foreach($datos->result() as $dato){
                    $html .= '
                        <tr>
                            <td style="width: 70%; font-weight: bold; text-decoration: underline;">'.$dato->idctcuenta.' '.$dato->descripct.'</td>
                        </tr>
                    ';
                    $datos2 = $this->contabilidad_model->getEPDbyC($dato->idctcuenta, $Dato->pnumero);
                    if($datos2->num_rows() > 0){
                        foreach($datos2->result() as $dato2){
                            $vdebe = $this->session->userdata('simboloMoneda').number_format((float)$dato2->debe, 2, '.', '');
                            $vhaber = $this->session->userdata('simboloMoneda').number_format((float)$dato2->haber, 2, '.', '');
                            if(strlen($dato->doc_type) > 0 && strlen($dato->doc_serie) > 0 && strlen($dato->doc_numero) > 0){
                                $html .= '
                                <tr>
                                    <td style="width: 7%; text-align: center;" >'.$dato2->itemline.'</td>
                                    <td style="width: 63%;" >'.$dato2->descrip.'<br>'.$dato->doc_type.' N° '.$dato->doc_serie.'-'.$dato->doc_numero.'</td>
                                    <td style="width: 15%; text-align: right;" >'.(($dato2->debe > 0) ? $vdebe : '').'</td>
                                    <td style="width: 15%; text-align: right;" >'.(($dato2->haber > 0) ? $vhaber : '').'</td>
                                </tr>
                            ';
                            }else{
                                $html .= '
                                <tr>
                                    <td style="width: 7%; text-align: center;" >'.$dato2->itemline.'</td>
                                    <td style="width: 63%;" >'.$dato2->descrip.'</td>
                                    <td style="width: 15%; text-align: right;" >'.(($dato2->debe > 0) ? $vdebe : '').'</td>
                                    <td style="width: 15%; text-align: right;" >'.(($dato2->haber > 0) ? $vhaber : '').'</td>
                                </tr>
                            ';
                            }
                            if(($dato2->idcentro != 0) || ($dato2->idtabla != 0)){
                                if($dato2->idtabla != 0){
                                    $html .= '
                                        <tr>
                                            <td style="width: 7%;" ></td>
                                            <td style="width: 63%;" >Auxiliar: '.$dato2->idauxi.'-'.$this->contabilidad_model->getResponsable($dato2->idauxi, $dato2->idtabla)->descrip.'</td>
                                        </tr>
                                    ';
                                }
                                if($dato2->idcentro != 0){
                                    $html .= '
                                        <tr>
                                            <td style="width: 7%;" ></td>
                                            <td style="width: 63%;" >Centro de Costos: '.$dato2->idcentro.'-'.$this->contabilidad_model->getCentro($dato2->idcentro)->descrip.'</td>
                                        </tr>
                                    ';
                                }
                            }
                            $debe += $dato2->debe;
                            $haber += $dato2->haber;
                        }
                    }
                }
                $html .= '</table>';
            }
            //  fin
            $html .= '
                <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                <table style="width=100%; padding-top: 2px; border-top: 1px solid black; font-family: Calibri;">
                    <tr style="text-align: right;">
                        <td style="width: 68%; font-size: 10px; font-family: monospace;" ><strong>TOTALES</strong></td>
                        <td style="width: 2%;" ></td>
                        <td style="width: 15%;" ><strong>'.$this->session->userdata('simboloMoneda').number_format((float)$debe, 2, '.', '').'</strong></td>
                        <td style="width: 15%;" ><strong>'.$this->session->userdata('simboloMoneda').number_format((float)$haber, 2, '.', '').'</strong></td>
                    </tr>
                </table>
                <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                <table style="width=100%;">
                    <tr style="font-size: 8px;">
                        <td style="width: 32%; text-align: center;">'.$usuario.'</td>
                        <td style="width: 68%;"></td>
                    </tr>
                    <tr>
                        <td style="width: 32%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                        <td style="width: 3%;"></td>
                        <td style="width: 31%; border-top: 1px solid black; text-align: center;">Revisado</td>
                        <td style="width: 3%;"></td>
                        <td style="width: 31%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                    </tr>
                </table>
                ';
            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }
    private function formato3($Dato)
    {
        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            //$empresa = 'DEMO XPRESSCT';
            $usuario = $this->session->userdata('userLog');
            $header = '
                <table style="width=100%; ">
                    <tr style="font-size: 14px; font-family: monospace, Gadget, sans-serif;">
                        <td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                    </tr>
                    <tr style="font-size: 15px; font-family: Gadget, sans-serif;">
                        <td style="width: 100%; text-align: center;"><strong>'.$Dato->tipoP.'</strong></td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlHeader($header);
            //header
            $footer = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="line-height: 10px;"><td></td></tr>
                    <tr style="font-size: 9px;">
                        <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;"></td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($footer);
            //footer
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Detalle de Partida - Formato 3');
            $pdf->SetMargins(10, 20, 10);// left top right
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
            //
            $html = '';
            $html .= '
                <table style="width=100%; font-family: Arial;">
                    <tr style="text-align: center;">
                        <td style="width: 10%; border-left: 1px solid black; border-top: 1px solid black; border-right: 1px solid black;"><strong style="text-transform: uppercase;" >Fecha</strong></td>
                        <td style="width: 9%; border-top: 1px solid black; border-right: 1px solid black;"><strong style="text-transform: uppercase;" >Número</strong></td>
                        <td style="width: 14%; border-top: 1px solid black; border-right: 1px solid black;"><strong style="text-transform: uppercase;" >Referencia</strong></td>
                        <td style="width: 10%;  border-top: 1px solid black; border-right: 1px solid black;"><strong>COR. MES</strong></td>
                        <td style="width: 13%; border-top: 1px solid black; border-right: 1px solid black;"><strong style="text-transform: uppercase;" >Estado</strong></td>
                        <td style="width: 44%; border-top: 1px solid black; border-right: 1px solid black; text-align: left;"><strong style="text-transform: uppercase;" >Concepto</strong></td>
                    </tr>
                    <tr style="text-align: center;">
                        <td style="width: 10%; border-left: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;">'.date_format(date_create($Dato->fecha), "d/m/Y").'</td>
                        <td style="width: 9%; border-bottom: 1px solid black; border-right: 1px solid black;">'.$Dato->pnumero.'</td>
                        <td style="width: 14%; border-bottom: 1px solid black; border-right: 1px solid black;">'.$Dato->referencia.'</td>
                        <td style="width: 10%; border-bottom: 1px solid black; border-right: 1px solid black;">'.$Dato->num_mes.'</td>
                        <td style="width: 13%; border-bottom: 1px solid black; border-right: 1px solid black;">'.$Dato->estado.'</td>
                        <td style="width: 44%; text-align: left; border-bottom: 1px solid black; border-right: 1px solid black;">'.$Dato->descrip.'</td>
                    </tr>
                    <tr style="line-height: 2px;"><td></td></tr>
                    <tr style="text-align: center; line-height: 12px; font-size: 8px; font-family: Minion;">
                        <td style="width: 11%; border-top: 1px solid black; border-left: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Cuenta</strong></td>
                        <td style="width: 33%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Descripción del Movimiento</strong></td>
                        <td style="width: 5%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >CC</strong></td>
                        <td style="width: 11%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Referencia</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Detalle</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Parciales</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Debe</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Haber</strong></td>
                    </tr>
                    <tr style="line-height: 1px;"><td></td></tr>
                </table>
                ';
            //datos
            $debe = 0;
            $haber = 0;
            //  fin
            $html .= '
                <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                <table style="width=100%; padding-top: 2px; border-top: 1px solid black; font-family: Calibri;">
                    <tr style="text-align: right;">
                        <td style="width: 76%; font-size: 10px; font-family: monospace;" ><strong>TOTALES</strong></td>
                        <td style="width: 2%;" ></td>
                        <td style="width: 11%;" ><strong>'.number_format((float)$debe, 2, '.', '').'</strong></td>
                        <td style="width: 11%;" ><strong>'.number_format((float)$haber, 2, '.', '').'</strong></td>
                    </tr>
                </table>
                <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                <table style="width=100%;">
                    <tr style="font-size: 8px;">
                        <td style="width: 19%; text-align: center;">'.$usuario.'</td>
                        <td style="width: 81%;"></td>
                    </tr>
                    <tr style="font-family: Courier;">
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Contador</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Revisado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Auditoria</td>
                    </tr>
                </table>
                ';
            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }

    public function EPReporteLote($tipo, $ids){
        if($this->validatePermiso()) {

            $arrayIds = explode("-", $ids);
            switch ($tipo) {
                case 1:
                    $this->formato1Lote($arrayIds);
                break;
                case 2:
                    $this->formato2Lote($arrayIds);
                break;
                case 3:
                    //$this->formato3Lote($arrayIds);
                break;
                default: 
                    return false;
                break;
            }
        }
    } 

    private function formato1Lote($arrayIds)
    {
        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta('P', 'mm', 'LETTER', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle("Detalle de Partidas - Formato Simple");
            $pdf->SetSubject("Detalle de Partidas - Formato Simple");

            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
            $pdf->SetFont('helvetica', '', 9);
            $pdf->SetMargins(10, 20, 10, true);
            $pdf->SetAutoPageBreak(TRUE, 16);

            //footer del documento
            $footer = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="line-height: 10px;"><td></td></tr>
                    <tr style="font-size: 11px;">
                        <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;"></td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($footer);


            $this->load->model('contabilidad_model');

            $status = array(
                'En Elaboración' => 0,
                'Actualizada' => 1,
                'Anulada' => 9,
            );
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $this->session->userdata('userLog');

            foreach($arrayIds as $id){
                if($partida = $this->contabilidad_model->getEPDetalle((int)$id)){
                    $partida->estado = array_search($partida->estatus, $status);
                    //$this->highlight_array($dato);

                    //header de la partida
                    //cambia cada vez que se cambia de partida
                    $header = '
                        <table style="width=100%; ">
                            <tr style="font-size: 19px; font-family: "Arial Black", Gadget, sans-serif;">
                                <td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                            </tr>
                            <tr style="font-size: 19px; font-family: "Arial Black", Gadget, sans-serif;">
                                <td style="width: 100%; text-align: center;"><strong>'.$partida->tipoP.'</strong></td>
                            </tr>
                        </table>
                    ';
                    $pdf->setHtmlHeader($header);        
                    $pdf->SetPrintHeader(true);

                    //cuerpo de la partida
                    $htmlPartida = '';
                    $htmlPartida .= '
                        <table style="width=100%; font-family: Arial;">
                            <tr style="text-align: center;">
                                <td style="width: 10%; border: 1px solid black;"><strong>Fecha</strong></td>
                                <td style="width: 9%; border: 1px solid black;"><strong>Número</strong></td>
                                <td style="width: 16%; border: 1px solid black;"><strong>Referencia</strong></td>
                                <td style="width: 9%; border: 1px solid black;"><strong>Cor. Mes.</strong></td>
                                <td style="width: 13%; border: 1px solid black;"><strong>Estado</strong></td>
                                <td style="width: 43%; border: 1px solid black;"><strong>Concepto</strong></td>
                            </tr>
                            <tr style="text-align: center;">
                                <td style="width: 10%; border: 1px solid black;">'.date_format(date_create($partida->fecha), "d/m/Y").'</td>
                                <td style="width: 9%; border: 1px solid black;">'.$partida->pnumero.'</td>
                                <td style="width: 16%; border: 1px solid black;">'.$partida->referencia.'</td>
                                <td style="width: 9%; border: 1px solid black;">'.$partida->num_mes.'</td>
                                <td style="width: 13%; border: 1px solid black;">'.$partida->estado.'</td>
                                <td style="width: 43%; text-align: left; border: 1px solid black;">'.$partida->descrip.'</td>
                            </tr>
                            <tr style="text-align: center; line-height: 17px; font-family: Minion;">
                                <td style="width: 12%; border: 1px solid black;" ><strong>Cuenta</strong></td>
                                <td style="width: 32%; border: 1px solid black;" ><strong>Titulo de la Cuenta</strong></td>
                                <td style="width: 32%; border: 1px solid black;" ><strong>Descripción del Movimiento</strong></td>
                                <td style="width: 12%; border: 1px solid black;" ><strong>Debe</strong></td>
                                <td style="width: 12%; border: 1px solid black;" ><strong>Haber</strong></td>
                            </tr>
                            <tr style="line-height: 1px;"><td></td></tr>
                        </table>
                    ';

                    //desglose de registros
                    $debe = 0;
                    $haber = 0;
                    $registros = $this->contabilidad_model->getEPRegistroR($partida->pnumero);
                    if ($registros->num_rows() > 0) {
                        $htmlPartida .= '<table>';
                        foreach ($registros->result() as $valor) {
                            if ($valor->estatus == 1) {
                                $extra = array(
                                    'idauxi' => '',
                                    'auxi' => '',
                                    'idcentro' => '',
                                    'centro' => '',
                                );
                                if ($valor->idtabla != 0) {
                                    $auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
                                    $extra['idauxi'] = $valor->idauxi;
                                    $extra['auxi'] = $auxi->descrip;
                                }
                                $extra2 = '';
                                if ($valor->idcentro != 0) {
                                    $centro = $this->contabilidad_model->getCentro($valor->idcentro);
                                    $extra2 = '
                                        <tr>
                                            <td style="width: 11%; font-size: 10px; text-align: right;">'.$valor->idcentro.'</td>
                                            <td style="width: 1%;"></td>
                                            <td style="width: 88%; font-size: 10px;">'.$centro->descrip.'</td>
                                        </tr>
                                    ';
                                }
                                $vdebe = number_format((float)$valor->debe, 2, '.', '');
                                $vhaber = number_format((float)$valor->haber, 2, '.', '');
                                $htmlPartida .= '
                                    <tr>
                                        <td style="width: 12%;">'.$valor->idctcuenta.'</td>
                                        <td style="width: 64%;">'.$valor->descripct.'</td>
                                        <td style="width: 12%; text-align: right;">'.( ( $valor->debe > 0) ? $vdebe : '' ).'</td>
                                        <td style="width: 12%; text-align: right;">'.( ( $valor->haber > 0) ? $vhaber : '' ).'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 11%; font-size: 10px; text-align: right;">'.$extra['idauxi'].'</td>
                                        <td style="width: 1%;"></td>
                                        <td style="width: 32%; font-size: 10px;">'.$extra['auxi'].'</td>
                                        <td style="width: 32%; font-size: 10px;">'.$valor->descrip.'</td>
                                        <td style="width: 12%; text-align: right;"></td>
                                        <td style="width: 12%; text-align: right;"></td>
                                    </tr>
                                ';
                                $htmlPartida .= $extra2;
                                $debe += $valor->debe;
                                $haber += $valor->haber;
                            }
                        }
                        $htmlPartida .= '</table>';
                        $htmlPartida .= '
                            <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                            <table style="width=100%; padding-top: 2px; border-top: 1px solid black; font-family: Calibri;">
                                <tr style="text-align: right;">
                                    <td style="width: 76%;" ><strong>TOTALES</strong></td>
                                    <td style="width: 12%;" ><strong>'.number_format((float)$debe, 2, '.', '').'</strong></td>
                                    <td style="width: 12%;" ><strong>'.number_format((float)$haber, 2, '.', '').'</strong></td>
                                </tr>
                            </table>
                            <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                            <table style="width=100%;">
                                <tr style="font-size: 10px;">
                                    <td style="width: 19%; text-align: center;">'.$usuario.'</td>
                                    <td style="width: 81%;"></td>
                                </tr>
                                <tr>
                                    <td style="width: 19%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                                    <td style="width: 2%;"></td>
                                    <td style="width: 18%; border-top: 1px solid black; text-align: center;">Contador</td>
                                    <td style="width: 2%;"></td>
                                    <td style="width: 18%; border-top: 1px solid black; text-align: center;">Revisado</td>
                                    <td style="width: 2%;"></td>
                                    <td style="width: 18%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                                    <td style="width: 2%;"></td>
                                    <td style="width: 19%; border-top: 1px solid black; text-align: center;">Auditoría</td>
                                </tr>
                            </table>
                        ';

                        $pdf->addPage('P', 'LETTER');
                        $pdf->SetY( 20 );            
                        $pdf->writeHTML($htmlPartida, true, false, true, false, ''); 
                    }
                }else{
                    continue;
                }
                
            }

            $nombre_archivo = utf8_decode("Detalle_Partidas.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }
    }
    private function formato2Lote($arrayIds)
    {
        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta('P', 'mm', 'LETTER', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle("Detalle de Partidas - Formato 2");
            $pdf->SetSubject("Detalle de Partidas - Formato 2");

            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
            $pdf->SetFont('helvetica', '', 9);
            $pdf->SetMargins(10, 20, 10, true);
            $pdf->SetAutoPageBreak(TRUE, 16);
            
            //footer del documento
            $footer = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="line-height: 10px;"><td></td></tr>
                    <tr style="font-size: 11px;">
                        <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;"></td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($footer);


            $this->load->model('contabilidad_model');

            $status = array(
                'En Elaboración' => 0,
                'Actualizada' => 1,
                'Anulada' => 9,
            );
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $this->session->userdata('userLog');

            foreach($arrayIds as $id){
                if($partida = $this->contabilidad_model->getEPDetalle((int)$id)){
                    $partida->estado = array_search($partida->estatus, $status);
                    //$this->highlight_array($dato);

                    //header de la partida
                    //cambia cada vez que se cambia de partida
                    $header = '
                        <table style="width=100%; ">
                            <tr style="font-size: 19px; font-family: "Arial Black", Gadget, sans-serif;">
                                <td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                            </tr>
                            <tr style="font-size: 19px; font-family: "Arial Black", Gadget, sans-serif;">
                                <td style="width: 100%; text-align: center;"><strong>'.$partida->tipoP.'</strong></td>
                            </tr>
                        </table>
                    ';
                    $pdf->setHtmlHeader($header);        
                    $pdf->SetPrintHeader(true);

                    //cuerpo de la partida
                    $htmlPartida = '';
                    $htmlPartida .= '
                        <table style="width=100%; font-family: Arial;">
                            <tr style="text-align: center;">
                                <td style="width: 10%; border: 1px solid black;"><strong>Fecha</strong></td>
                                <td style="width: 9%; border: 1px solid black;"><strong>Número</strong></td>
                                <td style="width: 16%; border: 1px solid black;"><strong>Referencia</strong></td>
                                <td style="width: 9%; border: 1px solid black;"><strong>Cor. Mes.</strong></td>
                                <td style="width: 13%; border: 1px solid black;"><strong>Estado</strong></td>
                                <td style="width: 43%; border: 1px solid black;"><strong>Concepto</strong></td>
                            </tr>
                            <tr style="text-align: center;">
                                <td style="width: 10%; border: 1px solid black;">'.date_format(date_create($partida->fecha), "d/m/Y").'</td>
                                <td style="width: 9%; border: 1px solid black;">'.$partida->pnumero.'</td>
                                <td style="width: 16%; border: 1px solid black;">'.$partida->referencia.'</td>
                                <td style="width: 9%; border: 1px solid black;">'.$partida->num_mes.'</td>
                                <td style="width: 13%; border: 1px solid black;">'.$partida->estado.'</td>
                                <td style="width: 43%; text-align: left; border: 1px solid black;">'.$partida->descrip.'</td>
                            </tr>
                            <tr style="text-align: center; line-height: 20px; font-family: Minion;">
                                <td style="width: 7%; border-bottom: 1px solid black; border-left: 1px solid black; border-right: 1px solid black; height: 12px;" ><strong># Linea</strong></td>
                                <td style="width: 63%; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong>Descripción del Movimiento</strong></td>
                                <td style="width: 15%; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong>Debe</strong></td>
                                <td style="width: 15%; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong>Haber</strong></td>
                            </tr>
                            <tr style="line-height: 1px;"><td></td></tr>
                        </table>
                    ';

                    //desglose de registros
                    $debe = 0;
                    $haber = 0;
                    $registros = $this->contabilidad_model->getEPRegistroRG($partida->pnumero);
                    if($registros->num_rows() > 0){
                        $htmlPartida .= '<table>';
                        foreach($registros->result() as $dato){
                            $htmlPartida .= '
                                <tr>
                                    <td style="width: 70%; font-weight: bold; ">'.$dato->idctcuenta.' - '.$dato->descripct.'</td>
                                </tr>
                            ';
                            $datos2 = $this->contabilidad_model->getEPDbyC($dato->idctcuenta, $partida->pnumero);
                            if($datos2->num_rows() > 0){
                                foreach($datos2->result() as $dato2){
                                    $vdebe = $this->session->userdata('simboloMoneda').number_format((float)$dato2->debe, 2, '.', '');
                                    $vhaber = $this->session->userdata('simboloMoneda').number_format((float)$dato2->haber, 2, '.', '');
                                    $htmlPartida .= '
                                        <tr>
                                            <td style="width: 7%; text-align: center;" >'.$dato2->itemline.'</td>
                                            <td style="width: 63%;" >'.$dato2->descrip.'</td>
                                            <td style="width: 15%; text-align: right;" >'.(($dato2->debe > 0) ? $vdebe : '').'</td>
                                            <td style="width: 15%; text-align: right;" >'.(($dato2->haber > 0) ? $vhaber : '').'</td>
                                        </tr>
                                    ';
                                    if(($dato2->idcentro != 0) || ($dato2->idtabla != 0)){
                                        if($dato2->idtabla != 0){
                                            $htmlPartida .= '
                                                <tr>
                                                    <td style="width: 7%;" ></td>
                                                    <td style="width: 63%;" >Auxiliar: '.$dato2->idauxi.'-'.$this->contabilidad_model->getResponsable($dato2->idauxi, $dato2->idtabla)->descrip.'</td>
                                                </tr>
                                            ';
                                        }
                                        if($dato2->idcentro != 0){
                                            $htmlPartida .= '
                                                <tr>
                                                    <td style="width: 7%;" ></td>
                                                    <td style="width: 63%;" >Centro de Costos: '.$dato2->idcentro.'-'.$this->contabilidad_model->getCentro($dato2->idcentro)->descrip.'</td>
                                                </tr>
                                            ';
                                        }
                                    }
                                    $debe += $dato2->debe;
                                    $haber += $dato2->haber;
                                }
                            }
                        }
                        $htmlPartida .= '</table>';
                        $htmlPartida .= '
                        <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                        <table style="width=100%; padding-top: 2px; border-top: 1px solid black; font-family: Calibri;">
                            <tr style="text-align: right;">
                                <td style="width: 68%; font-size: 10px;" ><strong>TOTALES</strong></td>
                                <td style="width: 2%;" ></td>
                                <td style="width: 15%;" ><strong>'.$this->session->userdata('simboloMoneda').number_format((float)$debe, 2, '.', '').'</strong></td>
                                <td style="width: 15%;" ><strong>'.$this->session->userdata('simboloMoneda').number_format((float)$haber, 2, '.', '').'</strong></td>
                            </tr>
                        </table>
                        <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                        <table style="width=100%;">
                            <tr style="font-size: 10px;">
                                <td style="width: 32%; text-align: center;">'.$usuario.'</td>
                                <td style="width: 68%;"></td>
                            </tr>
                            <tr>
                                <td style="width: 32%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                                <td style="width: 3%;"></td>
                                <td style="width: 31%; border-top: 1px solid black; text-align: center;">Revisado</td>
                                <td style="width: 3%;"></td>
                                <td style="width: 31%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                            </tr>
                        </table>
                        ';
                        
                        $pdf->addPage('P', 'LETTER');
                        $pdf->SetY( 20 );            
                        $pdf->writeHTML($htmlPartida, true, false, true, false, ''); 
                    }
                }else{
                    continue;
                }
                
            }

            $nombre_archivo = utf8_decode("Detalle_Partidas.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }
    }
    private function formato3Lote($arrayIds)
    {
        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            //$empresa = 'DEMO XPRESSCT';
            $usuario = $this->session->userdata('userLog');
            $header = '
                <table style="width=100%; ">
                    <tr style="font-size: 14px; font-family: monospace, Gadget, sans-serif;">
                        <td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                    </tr>
                    <tr style="font-size: 15px; font-family: Gadget, sans-serif;">
                        <td style="width: 100%; text-align: center;"><strong>'.$Dato->tipoP.'</strong></td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlHeader($header);
            //header
            $footer = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="line-height: 10px;"><td></td></tr>
                    <tr style="font-size: 9px;">
                        <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;"></td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($footer);
            //footer
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Detalle de Partida - Formato 3');
            $pdf->SetMargins(10, 20, 10);// left top right
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
            //
            $html = '';
            $html .= '
                <table style="width=100%; font-family: Arial;">
                    <tr style="text-align: center;">
                        <td style="width: 10%; border-left: 1px solid black; border-top: 1px solid black; border-right: 1px solid black;"><strong style="text-transform: uppercase;" >Fecha</strong></td>
                        <td style="width: 9%; border-top: 1px solid black; border-right: 1px solid black;"><strong style="text-transform: uppercase;" >Número</strong></td>
                        <td style="width: 14%; border-top: 1px solid black; border-right: 1px solid black;"><strong style="text-transform: uppercase;" >Referencia</strong></td>
                        <td style="width: 10%;  border-top: 1px solid black; border-right: 1px solid black;"><strong>COR. MES</strong></td>
                        <td style="width: 13%; border-top: 1px solid black; border-right: 1px solid black;"><strong style="text-transform: uppercase;" >Estado</strong></td>
                        <td style="width: 44%; border-top: 1px solid black; border-right: 1px solid black; text-align: left;"><strong style="text-transform: uppercase;" >Concepto</strong></td>
                    </tr>
                    <tr style="text-align: center;">
                        <td style="width: 10%; border-left: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;">'.date_format(date_create($Dato->fecha), "d/m/Y").'</td>
                        <td style="width: 9%; border-bottom: 1px solid black; border-right: 1px solid black;">'.$Dato->pnumero.'</td>
                        <td style="width: 14%; border-bottom: 1px solid black; border-right: 1px solid black;">'.$Dato->referencia.'</td>
                        <td style="width: 10%; border-bottom: 1px solid black; border-right: 1px solid black;">'.$Dato->num_mes.'</td>
                        <td style="width: 13%; border-bottom: 1px solid black; border-right: 1px solid black;">'.$Dato->estado.'</td>
                        <td style="width: 44%; text-align: left; border-bottom: 1px solid black; border-right: 1px solid black;">'.$Dato->descrip.'</td>
                    </tr>
                    <tr style="line-height: 2px;"><td></td></tr>
                    <tr style="text-align: center; line-height: 12px; font-size: 8px; font-family: Minion;">
                        <td style="width: 11%; border-top: 1px solid black; border-left: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Cuenta</strong></td>
                        <td style="width: 33%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Descripción del Movimiento</strong></td>
                        <td style="width: 5%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >CC</strong></td>
                        <td style="width: 11%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Referencia</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Detalle</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Parciales</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Debe</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Haber</strong></td>
                    </tr>
                    <tr style="line-height: 1px;"><td></td></tr>
                </table>
                ';
            //datos
            $debe = 0;
            $haber = 0;
            //  fin
            $html .= '
                <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                <table style="width=100%; padding-top: 2px; border-top: 1px solid black; font-family: Calibri;">
                    <tr style="text-align: right;">
                        <td style="width: 76%; font-size: 10px; font-family: monospace;" ><strong>TOTALES</strong></td>
                        <td style="width: 2%;" ></td>
                        <td style="width: 11%;" ><strong>'.number_format((float)$debe, 2, '.', '').'</strong></td>
                        <td style="width: 11%;" ><strong>'.number_format((float)$haber, 2, '.', '').'</strong></td>
                    </tr>
                </table>
                <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                <table style="width=100%;">
                    <tr style="font-size: 8px;">
                        <td style="width: 19%; text-align: center;">'.$usuario.'</td>
                        <td style="width: 81%;"></td>
                    </tr>
                    <tr style="font-family: Courier;">
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Contador</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Revisado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Auditoria</td>
                    </tr>
                </table>
                ';
            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }

    
    #   -------------------------------------------------------------------------- CONCENTRACION DIARIA
    public function EPReportes($fecha = null, $tipo = null) {
        if($this->validatePermiso()) {
            if ($fecha != null && $tipo != null) {
                $valido = 0;
                if (preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fecha)) {
                    $di = explode("-", $fecha);
                    if(checkdate($di[1], $di[2], $di[0])) {
                        $valido = 1;
                    }
                }
                if ($valido == 1){
                    $this->load->model('contabilidad_model');
                    $datos = $this->contabilidad_model->getEPartidasDate1($fecha);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato){
                            $status = array(
                                'En Elaboración' => 0,
                                'Actualizada' => 1,
                                'Anulada' => 9,
                            );
                            $dato->estado = array_search($dato->estatus, $status);
                        }
                        switch ($tipo) {
                            case 1:
                                $this->formatos1($datos->result());
                            break;
                            case 2:
                                $this->formatos2($datos->result());
                            break;
                            case 3:
                                $this->formatos3($datos->result());
                            break;
                            default: 
                                show_404();
                            break;
                        }
                    }
                } else echo "<h1>Parámetro Fecha Incorrecto</h1>";
            } else echo "<h1>Faltan Parámetros</h1>";
            ////<br pagebreak="true"/>
        }
    }
    private function formatos1_old($Datos)
    {
        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $this->session->userdata('userLog');
            foreach ($Datos as $Dato) {
                $html = '';
                $header = '
                    <table style="width=100%; ">
                        <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                            <td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                        </tr>
                        <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                            <td style="width: 100%; text-align: center;"><strong>'.$Dato->TPartida.'</strong></td>
                        </tr>
                    </table>
                ';
                $pdf->setHtmlHeader($header);
                //header
                $footer = '
                    <table style="width=100%; border-top: 1px solid black;">
                        <tr style="line-height: 10px;"><td></td></tr>
                        <tr style="font-size: 9px;">
                            <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                            <td style="width:34%; text-align: center;"></td>
                            <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                        </tr>
                    </table>
                ';
                $pdf->setHtmlFooter($footer);
                //footer
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetTitle('Detalle de Partidas - Formato Simple');
                $pdf->SetMargins(10, 20, 10);// left top right
                $pdf->SetFont('helvetica', '', 9);
                $pdf->AddPage('P', 'LETTER');//p vertical l horizontal//*/
                //datos
                $html .= '
                    <table style="width=100%; font-family: Arial;">
                        <tr style="text-align: center;">
                            <td style="width: 10%; border: 1px solid black;"><strong>Fecha</strong></td>
                            <td style="width: 9%; border: 1px solid black;"><strong>Número</strong></td>
                            <td style="width: 16%; border: 1px solid black;"><strong>Referencia</strong></td>
                            <td style="width: 13%; border: 1px solid black;"><strong>Estado</strong></td>
                            <td style="width: 52%; border: 1px solid black;"><strong>Concepto</strong></td>
                        </tr>
                        <tr style="text-align: center;">
                            <td style="width: 10%; border: 1px solid black;">'.date_format(date_create($Dato->fecha), "d/m/Y").'</td>
                            <td style="width: 9%; border: 1px solid black;">'.$Dato->pnumero.'</td>
                            <td style="width: 16%; border: 1px solid black;">'.$Dato->referencia.'</td>
                            <td style="width: 13%; border: 1px solid black;">'.$Dato->estado.'</td>
                            <td style="width: 52%; text-align: left; border: 1px solid black;">'.$Dato->descrip.'</td>
                        </tr>
                        <tr style="text-align: center; line-height: 17px; font-family: Minion;">
                            <td style="width: 12%; border: 1px solid black;" ><strong>Cuenta</strong></td>
                            <td style="width: 32%; border: 1px solid black;" ><strong>Titulo de la Cuenta</strong></td>
                            <td style="width: 32%; border: 1px solid black;" ><strong>Descripción del Movimiento</strong></td>
                            <td style="width: 12%; border: 1px solid black;" ><strong>Debe</strong></td>
                            <td style="width: 12%; border: 1px solid black;" ><strong>Haber</strong></td>
                        </tr>
                        <tr style="line-height: 1px;"><td></td></tr>
                    </table>
                ';
                $debe = 0;
                $haber = 0;
                $registros = $this->contabilidad_model->getEPRegistroR($Dato->pnumero);
                if ($registros->num_rows() > 0) {
                    $html .= '<table>';
                    foreach ($registros->result() as $valor) {
                        if ($valor->estatus == 1) {
                            $extra = array(
                                'idauxi' => '',
                                'auxi' => '',
                                'idcentro' => '',
                                'centro' => '',
                            );
                            if ($valor->idtabla != 0) {
                                $auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
                                $extra['idauxi'] = $valor->idauxi;
                                $extra['auxi'] = $auxi->descrip;
                            }
                            $extra2 = '';
                            if ($valor->idcentro != 0) {
                                $centro = $this->contabilidad_model->getCentro($valor->idcentro);
                                $extra2 = '
                                    <tr>
                                        <td style="width: 11%; font-size: 8px; text-align: right;">'.$valor->idcentro.'</td>
                                        <td style="width: 1%;"></td>
                                        <td style="width: 88%; font-size: 8px;">'.$centro->descrip.'</td>
                                    </tr>
                                ';
                            }
                            $vdebe = number_format((float)$valor->debe, 2, '.', '');
                            $vhaber = number_format((float)$valor->haber, 2, '.', '');
                            $html .= '
                                <tr>
                                    <td style="width: 12%;">'.$valor->idctcuenta.'</td>
                                    <td style="width: 64%;">'.$valor->descripct.'</td>
                                    <td style="width: 12%; text-align: right;">'.( ( $valor->debe > 0) ? $vdebe : '' ).'</td>
                                    <td style="width: 12%; text-align: right;">'.( ( $valor->haber > 0) ? $vhaber : '' ).'</td>
                                </tr>
                                <tr>
                                    <td style="width: 11%; font-size: 8px; text-align: right;">'.$extra['idauxi'].'</td>
                                    <td style="width: 1%;"></td>
                                    <td style="width: 32%; font-size: 8px;">'.$extra['auxi'].'</td>
                                    <td style="width: 32%; font-size: 8px;">'.$valor->descrip.'</td>
                                    <td style="width: 12%; text-align: right;"></td>
                                    <td style="width: 12%; text-align: right;"></td>
                                </tr>
                            ';
                            $html .= $extra2;
                            $debe += $valor->debe;
                            $haber += $valor->haber;
                        }
                    }
                    $html .= '</table>';
                }
                //  fin
                $html .= '
                    <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                    <table style="width=100%; padding-top: 2px; border-top: 4px solid black; font-family: Calibri;">
                        <tr style="text-align: right;">
                            <td style="width: 76%;" ><strong>TOTALES</strong></td>
                            <td style="width: 12%;" ><strong>'.number_format((float)$debe, 2, '.', '').'</strong></td>
                            <td style="width: 12%;" ><strong>'.number_format((float)$haber, 2, '.', '').'</strong></td>
                        </tr>
                    </table>
                    <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                    <table style="width=100%;">
                        <tr style="font-size: 8px;">
                            <td style="width: 19%; text-align: center;">'.$usuario.'</td>
                            <td style="width: 81%;"></td>
                        </tr>
                        <tr>
                            <td style="width: 19%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                            <td style="width: 2%;"></td>
                            <td style="width: 18%; border-top: 1px solid black; text-align: center;">Contador</td>
                            <td style="width: 2%;"></td>
                            <td style="width: 18%; border-top: 1px solid black; text-align: center;">Revisado</td>
                            <td style="width: 2%;"></td>
                            <td style="width: 18%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                            <td style="width: 2%;"></td>
                            <td style="width: 19%; border-top: 1px solid black; text-align: center;">Auditoria</td>
                        </tr>
                    </table>
                ';
                $pdf->writeHTML($html);
                $pdf->lastPage();
            }
            $pdf->Output();
        }
    }
    private function formatos1($Datos){
        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $this->session->userdata('userLog');
            $header = '
                <table style="width=100%; ">
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                    </tr>
                </table>
                <table style="width=100%; font-family: Arial;">
                    <tr style="text-align: center; line-height: 17px; font-family: Minion;">
                        <td style="width: 12%; border: 1px solid black;" ><strong>Cuenta</strong></td>
                        <td style="width: 32%; border: 1px solid black;" ><strong>Titulo de la Cuenta</strong></td>
                        <td style="width: 32%; border: 1px solid black;" ><strong>Descripción del Movimiento</strong></td>
                        <td style="width: 12%; border: 1px solid black;" ><strong>Debe</strong></td>
                        <td style="width: 12%; border: 1px solid black;" ><strong>Haber</strong></td>
                    </tr>
                    <tr style="line-height: 1px;"><td></td></tr>
                </table>
            ';
            $pdf->setHtmlHeader($header);
            //header
            $footer = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="line-height: 10px;"><td></td></tr>
                    <tr style="font-size: 9px;">
                        <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;"></td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($footer);
            //footer
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Detalle de Partidas - Formato Simple');
            $pdf->SetMargins(10, 20, 10);// left top right
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal//*/
            //datos
            $html = '';
            $debeT = 0;
            $haberT = 0;
            foreach ($Datos as $Dato) {
                $html .= '
                    <table style="width=100%; ">
                        <tr style="font-size: 11px;">
                            <td style="width: 10%;"></td>
                            <td style="width: 90%; text-align: left;"><strong>'.$Dato->TPartida.'</strong></td>
                        </tr>
                    </table>
                ';
                $registros = $this->contabilidad_model->getEPRegistroR($Dato->pnumero);
                if ($registros->num_rows() > 0) {
                    $debe = 0;
                    $haber = 0;
                    $html .= '<table>';
                    foreach ($registros->result() as $valor) {
                        if ($valor->estatus == 1) {
                            $extra = array(
                                'idauxi' => '',
                                'auxi' => '',
                                'idcentro' => '',
                                'centro' => '',
                            );
                            if ($valor->idtabla != 0) {
                                $auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
                                $extra['idauxi'] = $valor->idauxi;
                                $extra['auxi'] = $auxi->descrip;
                            }
                            $extra2 = '';
                            if ($valor->idcentro != 0) {
                                $centro = $this->contabilidad_model->getCentro($valor->idcentro);
                                $extra2 = '
                                    <tr>
                                        <td style="width: 11%; font-size: 8px; text-align: right;">'.$valor->idcentro.'</td>
                                        <td style="width: 1%;"></td>
                                        <td style="width: 88%; font-size: 8px;">'.$centro->descrip.'</td>
                                    </tr>
                                ';
                            }
                            $vdebe = number_format((float)$valor->debe, 2, '.', '');
                            $vhaber = number_format((float)$valor->haber, 2, '.', '');
                            $html .= '
                                <tr>
                                    <td style="width: 12%;">'.$valor->idctcuenta.'</td>
                                    <td style="width: 64%;">'.$valor->descripct.'</td>
                                    <td style="width: 12%; text-align: right;">'.( ( $valor->debe > 0) ? $vdebe : '' ).'</td>
                                    <td style="width: 12%; text-align: right;">'.( ( $valor->haber > 0) ? $vhaber : '' ).'</td>
                                </tr>
                                <tr>
                                    <td style="width: 11%; font-size: 8px; text-align: right;">'.$extra['idauxi'].'</td>
                                    <td style="width: 1%;"></td>
                                    <td style="width: 32%; font-size: 8px;">'.$extra['auxi'].'</td>
                                    <td style="width: 32%; font-size: 8px;">'.$valor->descrip.'</td>
                                    <td style="width: 12%; text-align: right;"></td>
                                    <td style="width: 12%; text-align: right;"></td>
                                </tr>
                            ';
                            $html .= $extra2;
                            $debe += $valor->debe;
                            $haber += $valor->haber;
                        }
                    }
                    $html .= '
                            <tr>
                                <td style="width: 64%; text-align: right;"></td>
                                <td style="width: 12%; text-align: right; font-weight: bold; border-top: 1px solid black;">TOTALES</td>
                                <td style="width: 12%; text-align: right; border-top: 1px solid black;">'.number_format((float)$debe, 2, '.', '').'</td>
                                <td style="width: 12%; text-align: right; border-top: 1px solid black;">'.number_format((float)$haber, 2, '.', '').'</td>
                            </tr>
                        </table>
                    ';
                    $debeT += $debe;
                    $haberT += $haber;
                }//*/
            }
            //  fin
            $html .= '
                <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                <table style="width=100%; padding-top: 2px; border-top: 4px solid black; font-family: Calibri;">
                    <tr style="text-align: right;">
                        <td style="width: 76%;" ><strong>TOTALES</strong></td>
                        <td style="width: 12%;" ><strong>'.number_format((float)$debeT, 2, '.', '').'</strong></td>
                        <td style="width: 12%;" ><strong>'.number_format((float)$haberT, 2, '.', '').'</strong></td>
                    </tr>
                </table>
                <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                <table style="width=100%;">
                    <tr style="font-size: 8px;">
                        <td style="width: 19%; text-align: center;">'.$usuario.'</td>
                        <td style="width: 81%;"></td>
                    </tr>
                    <tr>
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Contador</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Revisado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Auditoria</td>
                    </tr>
                </table>
            ';
            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }
    private function formatos2($Datos)
    {
        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $this->session->userdata('userLog');
            $header = '
                <table style="width=100%; ">
                    <tr style="font-size: 15px; font-family: "Arial Black", Gadget, sans-serif;">
                        <td style="width:10%;"></td>
                        <td style="width:80%; text-align: center;"><strong>'.$empresa.'</strong></td>
                        <td style="width:10%;"></td>
                    </tr>
                </table>
                <table style="width=100%; font-family: Arial;">
                    <tr style="text-align: center; line-height: 12px; font-family: Minion;">
                        <td style="width: 7%; border-top: 1px solid black; border-left: 1px solid black; border-right: 1px solid black;" ><strong>#</strong></td>
                        <td style="width: 63%; border-top: 1px solid black; border-right: 1px solid black;" ></td>
                        <td style="width: 15%; border-top: 1px solid black; border-right: 1px solid black;" ></td>
                        <td style="width: 15%; border-top: 1px solid black; border-right: 1px solid black;" ></td>
                    </tr>
                    <tr style="text-align: center; line-height: 10px; font-family: Minion;">
                        <td style="width: 7%; border-bottom: 1px solid black; border-left: 1px solid black; border-right: 1px solid black; height: 12px;" ><strong>Linea</strong></td>
                        <td style="width: 63%; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong>Descripción del Movimiento</strong></td>
                        <td style="width: 15%; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong>Debe</strong></td>
                        <td style="width: 15%; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong>Haber</strong></td>
                    </tr>
                    <tr style="line-height: 1px;"><td></td></tr>
                </table>
            ';
            $pdf->setHtmlHeader($header);
            //header
            $footer = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="line-height: 10px;"><td></td></tr>
                    <tr style="font-size: 9px;">
                        <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;"></td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($footer);
            //footer
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Detalle de Partidas - Formato 2');
            $pdf->SetMargins(10, 20, 10);// left top right
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
            //
            //datos
            $html = '';
            $debeT = 0;
            $haberT = 0;
            foreach ($Datos as $Dato) {
                $html .= '
                    <table style="width=100%; ">
                        <tr style="font-size: 11px;">
                            <td style="width: 10%;"></td>
                            <td style="width: 90%; text-align: left;"><strong>'.$Dato->TPartida.'</strong></td>
                        </tr>
                    </table>
                ';
                $datos = $this->contabilidad_model->getEPRegistroRG($Dato->pnumero);
                if($datos->num_rows() > 0){
                    $debeST = 0;
                    $haberST = 0;
                    $html .= '<table>';
                    foreach($datos->result() as $dato){
                        $debe = 0;
                        $haber = 0;
                        $html .= '
                            <tr>
                                <td style="width: 70%; font-weight: bold; text-decoration: underline;">'.$dato->idctcuenta.' '.$dato->descripct.'</td>
                            </tr>
                        ';
                        $datos2 = $this->contabilidad_model->getEPDbyC($dato->idctcuenta, $Dato->pnumero);
                        if($datos2->num_rows() > 0) {
                            foreach($datos2->result() as $dato2){
                                $vdebe = $this->session->userdata('simboloMoneda').number_format((float)$dato2->debe, 2, '.', '');
                                $vhaber = $this->session->userdata('simboloMoneda').number_format((float)$dato2->haber, 2, '.', '');
                                $html .= '
                                    <tr>
                                        <td style="width: 7%; text-align: center;" >'.$dato2->itemline.'</td>
                                        <td style="width: 63%;" >'.$dato2->descrip.'</td>
                                        <td style="width: 15%; text-align: right;" >'.(($dato2->debe > 0) ? $vdebe : '').'</td>
                                        <td style="width: 15%; text-align: right;" >'.(($dato2->haber > 0) ? $vhaber : '').'</td>
                                    </tr>
                                ';
                                if(($dato2->idcentro != 0) || ($dato2->idtabla != 0)){
                                    if($dato2->idtabla != 0){
                                        $html .= '
                                            <tr>
                                                <td style="width: 7%;" ></td>
                                                <td style="width: 63%;" >Auxiliar: '.$dato2->idauxi.'-'.$this->contabilidad_model->getResponsable($dato2->idauxi, $dato2->idtabla)->descrip.'</td>
                                            </tr>
                                        ';
                                    }
                                    if($dato2->idcentro != 0){
                                        $html .= '
                                            <tr>
                                                <td style="width: 7%;" ></td>
                                                <td style="width: 63%;" >Centro de Costos: '.$dato2->idcentro.'-'.$this->contabilidad_model->getCentro($dato2->idcentro)->descrip.'</td>
                                            </tr>
                                        ';
                                    }
                                }
                                $debe += $dato2->debe;
                                $haber += $dato2->haber;
                            }
                        }
                        $debeST += $debe;
                        $haberST += $haber;
                    }
                    $debeT += $debeST;
                    $haberT += $haberST;
                    $html .= '
                            <tr>
                                <td style="width: 58%; text-align: right;"></td>
                                <td style="width: 12%; text-align: right; font-weight: bold; border-top: 1px solid black;">TOTALES</td>
                                <td style="width: 15%; text-align: right; border-top: 1px solid black;">'.$this->session->userdata('simboloMoneda').number_format((float)$debeST, 2, '.', '').'</td>
                                <td style="width: 15%; text-align: right; border-top: 1px solid black;">'.$this->session->userdata('simboloMoneda').number_format((float)$haberST, 2, '.', '').'</td>
                            </tr>
                        </table>
                    ';
                }
            }
            //  fin
            $html .= '
                <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                <table style="width=100%; padding-top: 2px; border-top: 4px solid black; font-family: Calibri;">
                    <tr style="text-align: right;">
                        <td style="width: 68%; font-size: 10px; font-family: monospace;" ><strong>TOTALES</strong></td>
                        <td style="width: 2%;" ></td>
                        <td style="width: 15%;" ><strong>'.$this->session->userdata('simboloMoneda').number_format((float)$debeT, 2, '.', '').'</strong></td>
                        <td style="width: 15%;" ><strong>'.$this->session->userdata('simboloMoneda').number_format((float)$haberT, 2, '.', '').'</strong></td>
                    </tr>
                </table>
                <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                <table style="width=100%;">
                    <tr style="font-size: 8px;">
                        <td style="width: 32%; text-align: center;">'.$usuario.'</td>
                        <td style="width: 68%;"></td>
                    </tr>
                    <tr>
                        <td style="width: 32%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                        <td style="width: 3%;"></td>
                        <td style="width: 31%; border-top: 1px solid black; text-align: center;">Revisado</td>
                        <td style="width: 3%;"></td>
                        <td style="width: 31%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                    </tr>
                </table>
                ';
            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }
    private function formatos3($Datos)
    {
        if($this->validatePermiso()) {
            $this->load->library('Pdfconta');
            $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
            $usuario = $this->session->userdata('userLog');
            $header = '
                <table style="width=100%; ">
                    <tr style="font-size: 14px; font-family: monospace, Gadget, sans-serif;">
                        <td style="width: 100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                    </tr>
                </table>
                <table style="width=100%; font-family: Arial;">
                    <tr style="line-height: 2px;"><td></td></tr>
                    <tr style="text-align: center; line-height: 12px; font-size: 8px; font-family: Minion;">
                        <td style="width: 11%; border-top: 1px solid black; border-left: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Cuenta</strong></td>
                        <td style="width: 33%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Descripción del Movimiento</strong></td>
                        <td style="width: 5%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >CC</strong></td>
                        <td style="width: 11%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Referencia</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Detalle</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Parciales</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Debe</strong></td>
                        <td style="width: 10%; border-top: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black;" ><strong style="text-transform: uppercase;" >Haber</strong></td>
                    </tr>
                    <tr style="line-height: 1px;"><td></td></tr>
                </table>
            ';
            $pdf->setHtmlHeader($header);
            //header
            $footer = '
                <table style="width=100%; border-top: 1px solid black;">
                    <tr style="line-height: 10px;"><td></td></tr>
                    <tr style="font-size: 9px;">
                        <td style="width:33%; text-align: left;">Fecha de Impresión '.date_create()->format('d/m/Y H:i:s A').'</td>
                        <td style="width:34%; text-align: center;"></td>
                        <td style="width:33%; text-align: right;">Página Nº: '.$pdf->getAliasNumPage().'</td>
                    </tr>
                </table>
            ';
            $pdf->setHtmlFooter($footer);
            //footer
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetTitle('Detalle de Partida - Formato 3');
            $pdf->SetMargins(10, 20, 10);// left top right
            $pdf->SetFont('helvetica', '', 9);
            $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
            //
            //datos
            $html = '';
            $debeT = 0;
            $haberT = 0;
            foreach ($Datos as $Dato) {
                $html .= '
                    <table style="width=100%; ">
                        <tr style="font-size: 11px;">
                            <td style="width: 10%;"></td>
                            <td style="width: 90%; text-align: left;"><strong>'.$Dato->TPartida.'</strong></td>
                        </tr>
                    </table>
                ';
            }
            //  fin
            $html .= '
                <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
                <table style="width=100%; padding-top: 2px; border-top: 4px solid black; font-family: Calibri;">
                    <tr style="text-align: right;">
                        <td style="width: 76%; font-size: 10px; font-family: monospace;" ><strong>TOTALES</strong></td>
                        <td style="width: 2%;" ></td>
                        <td style="width: 11%;" ><strong>'.number_format((float)$debeT, 2, '.', '').'</strong></td>
                        <td style="width: 11%;" ><strong>'.number_format((float)$haberT, 2, '.', '').'</strong></td>
                    </tr>
                </table>
                <table style="width=100%;"><tr style="line-height: 20px;"><td></td></tr></table>
                <table style="width=100%;">
                    <tr style="font-size: 8px;">
                        <td style="width: 19%; text-align: center;">'.$usuario.'</td>
                        <td style="width: 81%;"></td>
                    </tr>
                    <tr style="font-family: Courier;">
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Hecho por</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Contador</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Revisado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 18%; border-top: 1px solid black; text-align: center;">Autorizado</td>
                        <td style="width: 2%;"></td>
                        <td style="width: 19%; border-top: 1px solid black; text-align: center;">Auditoria</td>
                    </tr>
                </table>
                ';
            $pdf->writeHTML($html);
            $pdf->lastPage();
            $pdf->Output();
        }
    }
    #   FIN REPORTE
    #------------------------------------------------------     FIN EDITOR DE PARTIDAS  DETALLE
    #------------------------------------------------------     FIN EDITOR DE PARTIDAS ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     EDITOR PARTIDAS DE CIERRE Y APERTURA ANUAL-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function indexEPartidasCA($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $this->load->model('contabilidad_model');
            date_default_timezone_set('America/El_Salvador');
            $appName = $this->configuracion_model->getAppName($idApp);
            
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);

            /*$Datos = [];
            $datos = $this->contabilidad_model->getPeriodosSimple();
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'ID' => (int)$dato->idyear,
                        'Name' => $dato->descrip,
                    );
                }
            }//*/

            $validoTCA = $this->contabilidad_model->VTPartidasCA();
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->data['valido'] = $validoTCA;

            //$this->data['PCierres'] = $Datos;
            //$this->data['PAperturas'] = $Datos;
            $this->data['YActual'] = date_create()->format('Y');
            $this->load->view("mantenimiento_PCApertura", $this->data);//*/
        }
    }
    #   GET PROCESOS
    public function getProcesosPCA()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $Datos = $this->contabilidad_model->getProcesos();
            $datA[] = array('valido' => true, 'datos' => $Datos);
            echo json_encode($datA);
        }
    }
    #   GET ALL PERIODOS
    public function getAllPeriodosC()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $Datos = [];
            $datos = $this->contabilidad_model->getPeriodosSimple();
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'ID' => (int)$dato->idyear,
                        'Name' => $dato->descrip,
                    );
                }
            }
            $datA[] = array('valido' => true, 'datosc' => $Datos, 'datosa' => $Datos);
            echo json_encode($datA);
        }
    }
    #   GET PARTIDAS EN PROCESO IN AÑO ESPECIFICO
    public function getPartidasInP()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $IDyear = (int)$this->input->post('idyear');
            $datos = $this->contabilidad_model->getPartidasInP($IDyear);
            $Datos = [];
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'numero' => $dato->pnumero,
                        'tpartida' => $dato->descrip
                    );
                }
            }
            $datA[] = array('valido' => true, 'datos' => $Datos);
            echo json_encode($datA);
        }
    }
    #   SET PROCESO
    public function setProcesoPCA()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $PCierre = (int)$this->input->post('pcierre');
            $PApertura = (int)$this->input->post('papertura');
            date_default_timezone_set('America/El_Salvador');
            $valido = $this->contabilidad_model->procesoCAValido($PCierre);
            if ($valido) {
                $data = array(
                    'idyear_cierre' => $PCierre,
                    'idyear_apertura' => $PApertura,
                    'descrip' => trim($this->input->post('nombre')),
                    'fecha' => date_create()->format('Y-m-d'),
                    'estatus' => 0,
                    'notas' => '',
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s')
                );
                if ($this->contabilidad_model->setProcesoPCA($data)) {
                    $Datos = $this->contabilidad_model->getProcesos();
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else $datA[] = array('valido' => false, 'tipo' => 1);
            } else $datA[] = array('valido' => false, 'tipo' => 0);
            echo json_encode($datA);
        }
    }
    #   GET CUENTAS ACTUAILZADAS IN Y
    public function getRSCActualizadasInY()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $PCierre = (int)$this->input->post('pcierre');
            $tipo = (int)$this->input->post('tipo');
            $cpartidas = $this->contabilidad_model->getPartidasAInY($PCierre);
            if ($cpartidas->num_rows() > 0) {
                $datos = $this->contabilidad_model->getRSCActualizadasInY($PCierre, $tipo);
                $Datos = [];
                switch ($tipo) {
                    #   LIQUIDACION INGRESOS/EGRESOS - CIERRE
                    case 0:
                    case 1:
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $dato) {
                                $registros = $this->contabilidad_model->getRegistrosACInY($PCierre, $dato->cuenta, $dato->ctcontrol);
                                if ($registros->num_rows() > 0) {
                                    foreach ($registros->result() as $registro) {
                                        $auxiliar = ($registro->idtabla != 0) ? ($this->contabilidad_model->getResponsable($registro->idauxi, $registro->idtabla)->descrip) : '';
                                        $centro = ($registro->idcentro != 0) ? ($this->contabilidad_model->getCentro($registro->idcentro)->descrip) : '';
                                        $proyecto = ($registro->idproject != 0) ? ($this->contabilidad_model->getProyecto($registro->idproject)->descrip) : '';
                                        $saldo = $this->getSTC($dato->catgrupo, $registro->debe, $registro->haber);
                                        $Datos[] = array(
                                            'cuenta' => $dato->cuenta,
                                            'ncuenta' => $dato->ncuenta,
                                            'auxiliar' => $auxiliar,
                                            'centro' => $centro,
                                            'proyecto' => $proyecto,
                                            'documento' => $registro->doc_type,
                                            'serien' => (strlen(trim($registro->doc_serie)) > 0) ? (implode('-', array($registro->doc_serie, $registro->doc_numero))) : '',
                                            'saldo' => $saldo
                                        );
                                    }
                                }
                            }
                        }
                    break;
                }
                $datA[] = array('valido' => true, 'datos' => $Datos);
            } else $datA[] = array('valido' => false, 'tipo' => 0);
            echo json_encode($datA);
        }
    }
    #   UPDATE PROCESO

    #------------------------------------------------------     FIN EDITOR DE PARTIDAS DE CIERRE Y APERTURA ANUAL ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     ASISTENTE CONTABLE ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function indexAContable($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $this->load->model('contabilidad_model');
            date_default_timezone_set('America/El_Salvador');
            $appName = $this->configuracion_model->getAppName($idApp);
            
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);

            //print_r($this->session->userdata('opcionAdministrador'));
            //array_map(function($o) { return $o['descripcion'].' '.number_format($o['precio'], 2, '.', '');}, $multiprecios);
            $OpcionesAC = [];
            foreach ($this->OpcionesAC as $opcionAC) {
                $opcionAC = (object)$opcionAC;
                $config = $this->contabilidad_model->multiplesContabilidad(0, [
                    'nombre' => $opcionAC->variable,
                    'descripcion' => $opcionAC->text
                ]);
                if (count((array)$config) > 0) {
                    $sinconfig = false;
                    if (strlen(trim($config->filtro)) > 0) {
                        $buenos = explode(",", trim($config->filtro));
                        $permiso = false;
                        foreach ($buenos as $bueno) {
                            if ((int)$bueno == (int)$this->session->userdata('iduser')) {
                                $permiso = true;
                                break;
                            }
                        }
                    } else $permiso = false;
                    $opcionAC->text = (strlen(trim($config->descripcion)) > 0) ? trim($config->descripcion) : $opcionAC->text;
                } else {
                    $permiso = false;
                    $sinconfig = true;
                }
                if (!$permiso && !$sinconfig && $opcionAC->developed) {
                    if (((int)$this->session->userdata('opcionAdministrador') == 1) ||
                    (int)$this->session->userdata('iduser') == 1) {
                        $permiso = true;
                    }
                }

                if (!$permiso) {
                    $opcionAC->disabled = true;
                    $opcionAC->visible = false;
                } else {
                    $opcionAC->disabled = false;
                    $opcionAC->visible = true;
                }
                $OpcionesAC[] = array(
                    'icon' => $opcionAC->icon,
                    'text' => $opcionAC->text,
                    'opcion' => (int)$opcionAC->opcion,
                    'visible' => $opcionAC->visible,
                    'disabled' => $opcionAC->disabled
                );
            }

            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->data['OpcionesAC'] = $OpcionesAC;
            $this->data['factual'] = date_create()->format('Y-m-d');
            $this->load->view("mantenimiento_AContable", $this->data);
        }
    }
    #   GET ASISTENTES CONTABLES
    public function getEAContable()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $OpcionAC = (int)$this->input->post('opcion');
            $Datos = [];
            switch ($OpcionAC) {
                #   QUEDAN
                case 0:
                    $conteoEE = 0;
                    $datos = $this->contabilidad_model->getEAContable($OpcionAC);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $estate = (int)explode("/", $dato->origen)[1];
                            if ($estate == 0) $conteoEE++;
                            $Datos[] = array(
                                'numero' => (int)$dato->pnumero,
                                'ntpartida' => $dato->ntpartida,
                                'fecha' => $dato->fecha,
                                'titulo' => $dato->descrip,
                                'estado' => array_search($estate, $this->EstadosPartidas),
                                'conteo' => $this->contabilidad_model->getACDetalle(0, $dato->pnumero)->num_rows(),
                                'cuadre' => (float)$this->contabilidad_model->getDataPartida(3, $dato->pnumero),
                            );
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos, 'conteoEE' => $conteoEE);
                break;
                #   PAGOS
                case 1:
                    $datos = $this->contabilidad_model->getEAContable($OpcionAC);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $estate = (int)explode("/", $dato->origen)[1];
                            $Datos[] = array(
                                'numero' => (int)$dato->pnumero,
                                'ntpartida' => $dato->ntpartida,
                                'fecha' => $dato->fecha,
                                'titulo' => $dato->descrip,
                                'estado' => array_search($estate, $this->EstadosPartidas)
                            );
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                break;
                #   ABONOS
                case 2:
                    $datos = $this->contabilidad_model->getEAContable($OpcionAC);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $estate = (int)explode("/", $dato->origen)[1];
                            $Datos[] = array(
                                'numero' => (int)$dato->pnumero,
                                'ntpartida' => $dato->ntpartida,
                                'fecha' => $dato->fecha,
                                'titulo' => $dato->descrip,
                                'estado' => array_search($estate, $this->EstadosPartidas)
                            );
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                break;
                #   GASTOS
                case 3:
                break;
                #   DEPOSITOS
                case 4:
                break;
                #   TRANSFERENCIAS
                case 5:
                break;
            }
            echo json_encode($datA);
        }
    }
    #   VALIDAR CONFIGURACION DE ASIST. CONTABLE
    public function validateVAC()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $OpcionAC = (int)$this->input->post('opcion');
            $opcionData = (object)$this->OpcionesAC[array_search($OpcionAC, array_column($this->OpcionesAC, 'opcion'))];
            $valido = $this->contabilidad_model->validateVAC($OpcionAC, $opcionData->variable);
            switch ($OpcionAC) {
                case 0:
                    $dtpartida = '';
                    //if ($valido == -2 || $valido == 7) {
                    if ($valido == 7) {
                        $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);
                        $tpartida = $this->contabilidad_model->getTPartida((int)$config->valor_txt);
                        $dtpartida = $tpartida->descrip;
                    }
                    $datA[] = array('valido' => $valido, 'dtpartida' => $dtpartida);
                break;
                case 1:
                    $Datos = [];
                    if ($valido == 7) {
                        $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);
                        $pconfig = explode(",", $config->valor_memo);
                        $pconfig = $pconfig[0];
                        $dparteconfig = explode("(", $pconfig);
                        preg_match_all("/\\((.*?)\\)/", "(".$dparteconfig[1], $founds);
                        $listaCuentasCxP = explode(";", implode("", $founds[1]));
                        $CuentasCxP = $this->contabilidad_model->getACDetalleData(-2, $listaCuentasCxP);
                        if ($CuentasCxP->num_rows() > 0) {
                            foreach ($CuentasCxP->result() as $dato) {
                                if ($this->multiplesContabilidad(1, $dato->malos)) {
                                    $auxiliares = $this->contabilidad_model->getACDetalleData(4, explode(",", $dato->useauxi));
                                    if ($auxiliares->num_rows() > 0) {
                                        foreach ($auxiliares->result() as $auxiliar) {
                                            /*$documentosPendientes = $this->contabilidad_model->getACDetalleData(-3, [
                                                'idcuenta' => $dato->idctcuenta,
                                                'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                'idauxi' => (int)$auxiliar->id
                                            ]);
                                            if ($documentosPendientes->num_rows() > 0) {//*/
                                            $documentoTotalPendiente = $this->contabilidad_model->getACDetalleData(-3.5, [
                                                'idcuenta' => $dato->idctcuenta,
                                                'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                'idauxi' => (int)$auxiliar->id
                                            ]);
                                            if (count((array)$documentoTotalPendiente) > 0) {
                                                $saldo = $this->getSTC($dato->catgrupo, $documentoTotalPendiente->debe, $documentoTotalPendiente->haber);
                                                $Datos[] = array(
                                                    'idcuenta' => $dato->idctcuenta,
                                                    'cuenta' => $dato->descrip,
                                                    'ID' => (int)$auxiliar->id,
                                                    'Name' => $auxiliar->descrip,
                                                    'saldo' => number_format((float)$saldo, 2, '.', ',')
                                                );
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    $datA[] = array('valido' => $valido, 'datos' => $Datos);
                break;
                case 2:
                    $Datos = [];
                    if ($valido == 7) {
                        $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);
                        $pconfig = explode(",", $config->valor_memo);
                        preg_match_all("/\\((.*?)\\)/", $pconfig[0], $founds);
                        $listaCuentasCxC = explode(";", implode("", $founds[1]));
                        $CuentasCxC = $this->contabilidad_model->getACDetalleData(-2, $listaCuentasCxC);
                        if ($CuentasCxC->num_rows() > 0) {
                            foreach ($CuentasCxC->result() as $dato) {
                                if ($this->multiplesContabilidad(1, $dato->malos)) {
                                    $auxiliares = $this->contabilidad_model->getACDetalleData(4, explode(",", $dato->useauxi));
                                    if ($auxiliares->num_rows() > 0) {
                                        foreach ($auxiliares->result() as $auxiliar) {
                                            /*$documentosPendientes = $this->contabilidad_model->getACDetalleData(-3, [
                                                'idcuenta' => $dato->idctcuenta,
                                                'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                'idauxi' => (int)$auxiliar->id
                                            ]);
                                            if ($documentosPendientes->num_rows() > 0) {//*/
                                            $documentoTotalPendiente = $this->contabilidad_model->getACDetalleData(-3.5, [
                                                'idcuenta' => $dato->idctcuenta,
                                                'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                'idauxi' => (int)$auxiliar->id
                                            ]);
                                            if (count((array)$documentoTotalPendiente) > 0) {
                                                $saldo = $this->getSTC($dato->catgrupo, $documentoTotalPendiente->debe, $documentoTotalPendiente->haber);
                                                $Datos[] = array(
                                                    'idcuenta' => $dato->idctcuenta,
                                                    'cuenta' => $dato->descrip,
                                                    'ID' => (int)$auxiliar->id,
                                                    'Name' => $auxiliar->descrip,
                                                    'saldo' => number_format((float)$saldo, 2, '.', ',')
                                                );
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    $datA[] = array('valido' => $valido, 'datos' => $Datos);
                break;
                case 3:
                break;
                case 4:
                break;
                case 5:
                break;    
            }
            echo json_encode($datA);
        }
    }
    #   SET OPCION ASIST. CONTABLE
    public function setAContable()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $OpcionAC = (int)$this->input->post('opcion');
            $opcionData = (object)$this->OpcionesAC[array_search($OpcionAC, array_column($this->OpcionesAC, 'opcion'))];
            $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);
            switch ($OpcionAC) {
                case 0:
                    $fecha = $this->input->post('fecha');
                    $tfecha = explode('-', $fecha);
                    $propiedadesValidas = $this->multipleOpcionesAC(1, [
                        'fecha' => $fecha,
                        'config' => $config
                    ]);

                    if ($propiedadesValidas == 1) {
                        $cPartidas = $this->contabilidad_model->getDataAContable(0, $fecha);
                        if ($cPartidas == 0) {
                            date_default_timezone_set('America/El_Salvador');
                            $data = array(
                                'idyear' => $tfecha[0],
                                'idptipo' => (int)$config->valor_txt,
                                'idsite' => $this->session->userdata('idcentrouser'),
                                'descrip' => $this->input->post('nombre'),
                                'fecha' => $fecha,

                                'origen' => "AC_Quedan/0",
                                'estatus' => 0,
                                'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'ingresa' => date_create()->format('Y-m-d H:i:s')
                            );
                            //if (true) {$valor = 1;
                            if ($valor = $this->contabilidad_model->setEPartidas($data)){
                                $datA[] = array('valido' => true, 'numero' => $valor);
                            } else $datA[] = array('valido' => false, 'tipo' => -6);
                        } else $datA[] = array('valido' => false, 'tipo' => -5);
                    } else $datA[] = array('valido' => false, 'tipo' => (int)$propiedadesValidas);
                break;
                case 1:
                    $fecha = $this->input->post('fecha');
                    $idauxi = (int)$this->input->post("idauxi");
                    $idcuenta = trim($this->input->post("idcuenta"));
                    $tfecha = explode('-', $fecha);
                    $propiedadesValidas = $this->multipleOpcionesAC(1, [
                        'fecha' => $fecha,
                        'config' => $config
                    ]);
                    if ($propiedadesValidas == 1) {
                        date_default_timezone_set('America/El_Salvador');
                        $data = array(
                            'idyear' => $tfecha[0],
                            'idptipo' => (int)$config->valor_txt,
                            'idsite' => $this->session->userdata('idcentrouser'),
                            'descrip' => $this->input->post('nombre'),
                            'fecha' => $fecha,

                            'origen' => "AC_Pagos/0/".$idauxi."/".$idcuenta,
                            'estatus' => 0,
                            'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s')
                        );
                        if ($valor = $this->contabilidad_model->setEPartidas($data)){
                            $datA[] = array('valido' => true, 'numero' => $valor);
                        } else $datA[] = array('valido' => false, 'tipo' => -5);
                    } else $datA[] = array('valido' => false, 'tipo' => (int)$propiedadesValidas);
                break;
                case 2:
                    $fecha = $this->input->post('fecha');
                    $idauxi = (int)$this->input->post("idauxi");
                    $idcuenta = trim($this->input->post("idcuenta"));
                    $tfecha = explode('-', $fecha);
                    $propiedadesValidas = $this->multipleOpcionesAC(1, [
                        'fecha' => $fecha,
                        'config' => $config
                    ]);
                    if ($propiedadesValidas == 1) {
                        date_default_timezone_set('America/El_Salvador');
                        $data = array(
                            'idyear' => $tfecha[0],
                            'idptipo' => (int)$config->valor_txt,
                            'idsite' => $this->session->userdata('idcentrouser'),
                            'descrip' => $this->input->post('nombre'),
                            'fecha' => $fecha,

                            'origen' => "AC_Abonos/0/".$idauxi."/".$idcuenta,
                            'estatus' => 0,
                            'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s')
                        );
                        if ($valor = $this->contabilidad_model->setEPartidas($data)){
                            $datA[] = array('valido' => true, 'numero' => $valor);
                        } else $datA[] = array('valido' => false, 'tipo' => -5);
                    } else $datA[] = array('valido' => false, 'tipo' => (int)$propiedadesValidas);
                break;
                case 3:
                break;
                case 4:
                break;
                case 5:
                break;   
            }
            echo json_encode($datA);
        }   
    }
    #   CONFIG DETALLE
    public function configAContable()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $OpcionAC = (int)$this->input->post('opcion');
            $OpcionMulti = (int)$this->input->post('OpcionMulti');
            $opcionData = (object)$this->OpcionesAC[array_search($OpcionAC, array_column($this->OpcionesAC, 'opcion'))];
            switch ($OpcionAC) {
                case 0:
                    if ($OpcionMulti == 0) {#   CERRAR
                        $pnumero = (int)$this->input->post('pnumero');
                        $partida = $this->contabilidad_model->getDataPartida(0, $pnumero);
                        $porigen = explode("/", $partida->origen);
                        date_default_timezone_set('America/El_Salvador');
                        $data = array(
                            'origen' => $porigen[0].'/1',
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s')
                        );
                        if ($this->contabilidad_model->updateEPartida($data, $pnumero)) $datA[] = array('valido' => true);
                        else $datA[] = array('valido' => false);
                    } else if ($OpcionMulti == 1) {# GET PERMISOS
                        $data = (object)$this->multipleOpcionesAC(0, $OpcionAC);
                        $datA[] = array(
                            'valido' => true,
                            'usuariosin' => $data->usuariosin,
                            'usuariocon' => $data->usuariocon
                        );
                    } else if ($OpcionMulti == 2) {#   UPDATE PERMISOS
                        $usuarios = trim($this->input->post("usuarios"));
                        $data = array(
                            'filtro' => $usuarios,
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        $extra = [
                            'opcion' => $OpcionAC,
                            'data' => $data,
                            'nombre' => $opcionData->variable,
                        ];
                        if ($this->contabilidad_model->multiplesOpcionesAC(0, $extra)) $datA[] = array('valido' => true);
                        else $datA[] = array('valido' => false);
                    } else {#
                    }
                break;
                case 1:
                    if ($OpcionMulti == 0) {#   CERRAR
                        $pnumero = (int)$this->input->post('pnumero');
                        $control = (int)$this->input->post('control');
                        $opcionControl = (int)$this->input->post('opcioncontrol');

                        $cuenta = $this->input->post('idcuenta');
                        $idtabla = (int)$this->input->post('idtabla');
                        $idauxi = (int)$this->input->post('idauxi');
                        $tipodoc = $this->input->post('tipodoc');
                        $serie = trim($this->input->post("serie"));
                        $numero = trim($this->input->post("numero"));
                        $valido = true;
                        if ($control == 1) {
                            $extra = [
                                'cuenta' => $cuenta,
                                'idtabla' => $idtabla,
                                'idauxi' => $idauxi,
                                'tipodoc' => $tipodoc,
                                'serie' => $serie,
                                'numero' => $numero,
                            ];
                            /*$extra = [
                                'cuenta' => '21101',//$cuenta,
                                'idtabla' => 1,//$idtabla,
                                'idauxi' => 638,//$idauxi,
                                'tipodoc' => 'Compras Locales (CCF)',//$tipodoc,
                                'serie' => '19DS000C',//$serie,
                                'numero' => '1836',//$numero,
                            ];//*/
                            $valnumero = $this->contabilidad_model->getACDetalleData(7, $extra);
                            $valido = ($valnumero == 0) ? true : false;
                        }
                        if ($valido) {
                            //die();
                            $partida = $this->contabilidad_model->getDataPartida(0, $pnumero);
                            $porigen = explode("/", $partida->origen);
                            $porigen[1] = '1';
                            $porigen = implode("/", $porigen);
                            date_default_timezone_set('America/El_Salvador');
                            $data = array(
                                'pnumero' => $pnumero,
                                "itemline" => $this->contabilidad_model->getCountMov($pnumero) + 1,
                                'fecha' => $this->input->post('pfecha'),
                                'idctcuenta' => $cuenta,
                                'idtabla' => $idtabla,
                                'idauxi' => $idauxi,
                                'idcentro' => (int)$this->input->post('idcentro'),
                                'idproject' => (int)$this->input->post('idproyecto'),
                                'descrip' => trim($this->input->post('descripcion')),
                                'doc_type' => $tipodoc,
                                'doc_serie' => $serie,
                                'doc_numero' => $numero,
                                'estatus' => 0,
                                'haber' => $this->input->post('valor'),
                                'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'ingresa' => date_create()->format('Y-m-d H:i:s'),
                            );
                            if ($this->contabilidad_model->setEPDetalle($data)) {
                                $data = array(
                                    'origen' => $porigen,
                                    'whodidit' => $this->session->userdata('iduser'),
                                    'modifica' => date_create()->format('Y-m-d H:i:s')
                                );
                                if ($this->contabilidad_model->updateEPartida($data, $pnumero)) $datA[] = array('valido' => true);
                                else $datA[] = array('valido' => false, 'tipo' => -1);
                            } else $datA[] = array('valido' => false, 'tipo' => 0);//*/
                        } else $datA[] = array('valido' => false, 'tipo' => -2);
                    } else if ($OpcionMulti == 1) {# GET PERMISOS
                        $data = (object)$this->multipleOpcionesAC(0, $OpcionAC);
                        $datA[] = array(
                            'valido' => true,
                            'usuariosin' => $data->usuariosin,
                            'usuariocon' => $data->usuariocon
                        );
                    } else if ($OpcionMulti == 2) {#   UPDATE PERMISOS
                        $usuarios = trim($this->input->post("usuarios"));
                        $data = array(
                            'filtro' => $usuarios,
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        $extra = [
                            'opcion' => $OpcionAC,
                            'data' => $data,
                            'nombre' => $opcionData->variable,
                        ];
                        if ($this->contabilidad_model->multiplesOpcionesAC(0, $extra)) $datA[] = array('valido' => true);
                        else $datA[] = array('valido' => false);
                    } else if ($OpcionMulti == 3) {#   CAMBIAR DE AUXILIAR
                        $opcionData = (object)$this->OpcionesAC[array_search($OpcionAC, array_column($this->OpcionesAC, 'opcion'))];
                        $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);

                        $fecha = $this->input->post('fecha');
                        $pnumero = (int)$this->input->post('pnumero');
                        $idauxi = (int)$this->input->post("idauxi");
                        $idcuenta = trim($this->input->post("idcuenta"));
                        $tfecha = explode('-', $fecha);
                        $propiedadesValidas = $this->multipleOpcionesAC(1, [
                            'fecha' => $fecha,
                            'config' => $config
                        ]);
                        if ($propiedadesValidas == 1) {
                            date_default_timezone_set('America/El_Salvador');
                            $data = array(
                                'idyear' => $tfecha[0],
                                'idptipo' => (int)$config->valor_txt,
                                'idsite' => $this->session->userdata('idcentrouser'),
                                'descrip' => trim($this->input->post('nombre')),
                                'fecha' => $fecha,
    
                                'origen' => "AC_Pagos/0/".$idauxi."/".$idcuenta,
                                'estatus' => 0,
                                //'chg_log' => $this->contabilidad_model->getHistoricoEP($pnumero).date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Actualización;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'modifica' => date_create()->format('Y-m-d H:i:s')
                            );
                            if ($this->contabilidad_model->updateEPartida($data, $pnumero)) {
                                #-
                                $datos = (object)$this->multipleOpcionesAC(2, [
                                    'opcionData' => $opcionData,
                                    'porigen' => explode("/", $data['origen']),
                                    'config' => $config,
                                    'partida' => $this->contabilidad_model->getEPDetalle((int)$pnumero),
                                ]);
                                $datA[] = array(
                                    'valido' => true,
                                    'partida' => $datos->objecto,
                                    'cuentas' => $datos->Cuentas,
                                    'estructura' => $datos->Estructura
                                );
                                #-
                            } else $datA[] = array('valido' => false, 'tipo' => -5);
                        } else $datA[] = array('valido' => false, 'tipo' => (int)$propiedadesValidas);
                    } else {#   ANULAR PARTIDA
                        $pnumero = (int)$this->input->post('pnumero');
                        $extra = $this->input->post('extra');
                        $pextra = explode("-", $extra);
                        $Datos = $this->conversionGetACDetalle(1, array(
                            'opcion' => 0,
                            'extra' => $pextra,
                            'pnumero' => $pnumero,
                        ));
                        if (count($Datos) == 0) {
                            date_default_timezone_set('America/El_Salvador');
                            $partida = $this->contabilidad_model->getDataPartida(0, $pnumero);
                            $porigen = explode("/", $partida->origen);
                            $porigen[1] = '9';
                            $data = array(
    
                                'origen' => implode("/", $porigen),
                                'estatus' => 9,
                                'chg_log' => $this->contabilidad_model->getHistoricoEP($pnumero).date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Anulada;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'modifica' => date_create()->format('Y-m-d H:i:s')
                            );
                            if ($this->contabilidad_model->updateEPartida($data, $pnumero)) $datA[] = array('valido' => true);
                            else $datA[] = array('valido' => false, 'tipo' => 0);  
                        } else $datA[] = array('valido' => false, 'tipo' => 0);
                    }
                break;
                case 2:
                    if ($OpcionMulti == 0) {#   CERRAR
                        $pnumero = (int)$this->input->post('pnumero');
                        $control = (int)$this->input->post('control');
                        $opcionControl = (int)$this->input->post('opcioncontrol');

                        $cuenta = $this->input->post('idcuenta');
                        $idtabla = (int)$this->input->post('idtabla');
                        $idauxi = (int)$this->input->post('idauxi');
                        $tipodoc = $this->input->post('tipodoc');
                        $serie = trim($this->input->post("serie"));
                        $numero = trim($this->input->post("numero"));
                        $valido = true;

                        if ($control == 1) {
                            $extra = [
                                'cuenta' => $cuenta,
                                'idtabla' => $idtabla,
                                'idauxi' => $idauxi,
                                'tipodoc' => $tipodoc,
                                'serie' => $serie,
                                'numero' => $numero,
                            ];
                            $valnumero = $this->contabilidad_model->getACDetalleData(7, $extra);
                            $valido = ($valnumero == 0) ? true : false;
                        }

                        if ($valido) {
                            $partida = $this->contabilidad_model->getDataPartida(0, $pnumero);
                            $porigen = explode("/", $partida->origen);
                            $porigen[1] = '1';
                            $porigen = implode("/", $porigen);
                            date_default_timezone_set('America/El_Salvador');
                            $data = array(
                                'pnumero' => $pnumero,
                                "itemline" => $this->contabilidad_model->getCountMov($pnumero) + 1,
                                'fecha' => $this->input->post('pfecha'),
                                'idctcuenta' => $cuenta,
                                'idtabla' => $idtabla,
                                'idauxi' => $idauxi,
                                'idcentro' => (int)$this->input->post('idcentro'),
                                'idproject' => (int)$this->input->post('idproyecto'),
                                'descrip' => trim($this->input->post('descripcion')),
                                'doc_type' => $tipodoc,
                                'doc_serie' => $serie,
                                'doc_numero' => $numero,
                                'estatus' => 0,
                                'debe' => $this->input->post('valor'),
                                'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'ingresa' => date_create()->format('Y-m-d H:i:s'),
                            );
                            if ($this->contabilidad_model->setEPDetalle($data)) {
                                $data = array(
                                    'origen' => $porigen,
                                    'whodidit' => $this->session->userdata('iduser'),
                                    'modifica' => date_create()->format('Y-m-d H:i:s')
                                );
                                if ($this->contabilidad_model->updateEPartida($data, $pnumero)) $datA[] = array('valido' => true);
                                else $datA[] = array('valido' => false, 'tipo' => -1);
                            } else $datA[] = array('valido' => false, 'tipo' => 0);//*/
                        } else $datA[] = array('valido' => false, 'tipo' => -2);
                    } else if ($OpcionMulti == 1) {# GET PERMISOS
                        $data = (object)$this->multipleOpcionesAC(0, $OpcionAC);
                        $datA[] = array(
                            'valido' => true,
                            'usuariosin' => $data->usuariosin,
                            'usuariocon' => $data->usuariocon
                        );
                    } else if ($OpcionMulti == 2) {#   UPDATE PERMISOS
                        $usuarios = trim($this->input->post("usuarios"));
                        $data = array(
                            'filtro' => $usuarios,
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        $extra = [
                            'opcion' => $OpcionAC,
                            'data' => $data,
                            'nombre' => $opcionData->variable,
                        ];
                        if ($this->contabilidad_model->multiplesOpcionesAC(0, $extra)) $datA[] = array('valido' => true);
                        else $datA[] = array('valido' => false);
                    } else if ($OpcionMulti == 3) {#   CAMBIAR DE AUXILIAR
                        $opcionData = (object)$this->OpcionesAC[array_search($OpcionAC, array_column($this->OpcionesAC, 'opcion'))];
                        $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);

                        $fecha = $this->input->post('fecha');
                        $pnumero = (int)$this->input->post('pnumero');
                        $idauxi = (int)$this->input->post("idauxi");
                        $idcuenta = trim($this->input->post("idcuenta"));
                        $tfecha = explode('-', $fecha);
                        $propiedadesValidas = $this->multipleOpcionesAC(1, [
                            'fecha' => $fecha,
                            'config' => $config
                        ]);
                        if ($propiedadesValidas == 1) {
                            date_default_timezone_set('America/El_Salvador');
                            $data = array(
                                'idyear' => $tfecha[0],
                                'idptipo' => (int)$config->valor_txt,
                                'idsite' => $this->session->userdata('idcentrouser'),
                                'descrip' => trim($this->input->post('nombre')),
                                'fecha' => $fecha,
    
                                'origen' => "AC_Abonos/0/".$idauxi."/".$idcuenta,
                                'estatus' => 0,
                                //'chg_log' => $this->contabilidad_model->getHistoricoEP($pnumero).date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Actualización;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'modifica' => date_create()->format('Y-m-d H:i:s')
                            );
                            if ($this->contabilidad_model->updateEPartida($data, $pnumero)) {
                                #-
                                $datos = (object)$this->multipleOpcionesAC(2, [
                                    'opcionData' => $opcionData,
                                    'porigen' => explode("/", $data['origen']),
                                    'config' => $config,
                                    'partida' => $this->contabilidad_model->getEPDetalle((int)$pnumero),
                                ]);
                                $datA[] = array(
                                    'valido' => true,
                                    'partida' => $datos->objecto,
                                    'cuentas' => $datos->Cuentas,
                                    'estructura' => $datos->Estructura
                                );
                                #-
                            } else $datA[] = array('valido' => false, 'tipo' => -5);
                        } else $datA[] = array('valido' => false, 'tipo' => (int)$propiedadesValidas);
                    } else {#   ANULAR PARTIDA
                        $pnumero = (int)$this->input->post('pnumero');
                        $extra = $this->input->post('extra');
                        $pextra = explode("-", $extra);
                        $Datos = $this->conversionGetACDetalle(1, array(
                            'opcion' => 0,
                            'extra' => $pextra,
                            'pnumero' => $pnumero,
                        ));
                        if (count($Datos) == 0) {
                            date_default_timezone_set('America/El_Salvador');
                            $partida = $this->contabilidad_model->getDataPartida(0, $pnumero);
                            $porigen = explode("/", $partida->origen);
                            $porigen[1] = '9';
                            $data = array(
    
                                'origen' => implode("/", $porigen),
                                'estatus' => 9,
                                'chg_log' => $this->contabilidad_model->getHistoricoEP($pnumero).date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Anulada;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'modifica' => date_create()->format('Y-m-d H:i:s')
                            );
                            if ($this->contabilidad_model->updateEPartida($data, $pnumero)) $datA[] = array('valido' => true);
                            else $datA[] = array('valido' => false, 'tipo' => 0);  
                        } else $datA[] = array('valido' => false, 'tipo' => 0);
                    }
                break;
                case 3:
                break;
                case 4:
                break;
                case 5:
                break;
            }
            echo json_encode($datA);
        }
    }
    private function multipleOpcionesAC($opc, $data = null)
    {
        $Datos = [];
        switch ($opc) {
            #   GET USUARIOS CON Y SIN ACCESO A LAS OPCIONES DEL ASISTENTE CONTABLE
            case 0:
                $opcionData = (object)$this->OpcionesAC[array_search($data, array_column($this->OpcionesAC, 'opcion'))];
                $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);
                $buenos = [];
                if (strlen(trim($config->filtro)) > 0) $buenos = explode(",", trim($config->filtro));
                $UsuarioSin = [];
                $UsuarioCon = [];
                $datos = $this->contabilidad_model->getACDetalleData(-4);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        if (count($buenos) > 0) {
                            $found = array_search($dato->iduser, $buenos);
                            /*var_dump($found);
                            print_r([
                                'f' => $found,
                                'id' => $dato->iduser
                            ]);//*/
                            if ($found !== false) {
                                $UsuarioCon[] = array(
                                    'ID' => (int)$dato->iduser,
                                    'Name' => $dato->descrip
                                );
                            } else {
                                $UsuarioSin[] = array(
                                    'ID' => (int)$dato->iduser,
                                    'Name' => $dato->descrip
                                );    
                            }
                        } else {
                            $UsuarioSin[] = array(
                                'ID' => (int)$dato->iduser,
                                'Name' => $dato->descrip
                            );
                        }
                    }
                }
                if (count($UsuarioSin) > 0 || count ($UsuarioCon) > 0) {
                    if (count($UsuarioSin) > 0) usort($UsuarioSin, function($a, $b) {return strcmp($a['Name'], $b['Name']);});
                    if (count($UsuarioCon) > 0) usort($UsuarioCon, function($a, $b) {return strcmp($a['Name'], $b['Name']);});
                }

                $Datos = [
                    'usuariosin' => $UsuarioSin,
                    'usuariocon' => $UsuarioCon
                ];
            break;
            #   VALIDACION PARA INSERTAR UNA OPCION CONTABLE
            case 1:
                $config = $data['config'];
                $fecha = $data['fecha'];
                $tfecha = explode('-', $fecha);

                $periodo = $this->contabilidad_model->getPeriodoM($tfecha[0]);
                if (count((array)$periodo) > 0) {
                    if ($periodo->estatus == 1) {
                        if ((int)$periodo->{'mes'.$tfecha[1]} == 1) {
                            $tpartida = $this->contabilidad_model->getTPartida((int)$config->valor_txt);
                            if ($this->multiplesContabilidad(2, $tpartida->allowed_users)) {
                                
                                if ($this->multiplesContabilidad(3, [
                                    'periodos' => $tpartida->periodos,
                                    'mes' => $tfecha[1]
                                ])) {
                                    $Datos = 1; #   TODO BIEN0
                                } else $Datos = -4; // SI TIENE ESE PERIODO EN EL TIPO DE PARTIDA
                            } else $Datos = -3; // SI TIENE PERMISO DE USAR TIPO DE PARTIDA
                        } else $Datos = -2; // SI TIENE ESE CIERRE MENSUAL ABIERTO
                    } else $Datos = -1; // SI ESTA ACTIVO EL PERIODO
                } else $Datos = 0; // SI EXISTE PERIODO CONTABLE
            break;
            #   GET ESTRUCTURA INICIAL DE DETALLE
            case 2:
                $opcionData = $data['opcionData'];
                $porigen = $data['porigen'];
                $config = $data['config'];
                $partida = $data['partida'];
                $Cuentas = [];
                $Estructura = [];
                $objecto = new stdClass();
                $objecto->pnumero = $partida->pnumero;
                $objecto->fecha = $partida->fecha;
                $objecto->vfecha = date_format(date_create($partida->fecha), "d/m/Y");
                $objecto->idtpartida = $partida->idptipo;
                $objecto->tpartida = $partida->tipoP;
                $objecto->referencia = $partida->referencia;
                $objecto->descripcion = $partida->descrip;
                $objecto->estatus = $partida->estatus;
                $objecto->estado = array_search($porigen[1], $this->EstadosPartidas);

                $objecto->debe = $partida->debe;
                $objecto->haber = $partida->haber;
                $objecto->extra = '';

                switch ((int)$opcionData->opcion) {
                    case 0:
                    break;
                    case 1:
                        $IDAuxi = (int)$porigen[2];
                        $IDCuenta = $porigen[3];
                        $datacuenta = $this->contabilidad_model->getCuenta3($IDCuenta);
                        $IDTabla = explode(",", $datacuenta->useauxi)[0];
                        $extra = [
                            $IDCuenta,
                            $IDTabla,
                            $IDAuxi
                        ];
                        $objecto->extra = implode("-", $extra);

                        #   CUENTAS DE DESTINO - FORMAS DE PAGO - TREE VIEW
                        $pconfig = explode(",", $config->valor_memo);
                        preg_match_all("/\\((.*?)\\)/", $pconfig[1], $dconfig);
                        $cuentas = explode(";", implode("", $dconfig[1]));
                        $cuentas = $this->contabilidad_model->getACDetalleData(-1, $cuentas);
                        $default = 'assets/img/sinImagen.png';

                        if ($cuentas->num_rows() > 0) {
                            foreach ($cuentas->result() as $dato) {
                                if ($this->multiplesContabilidad(1, $dato->malos)) {
                                    $items = [];
                                    if (strlen(trim($dato->useauxi)) > 0) {
                                        $auxiliares = $this->contabilidad_model->getACDetalleData(4, explode(",", $dato->useauxi));
                                        if ($auxiliares->num_rows() > 0) {
                                            foreach ($auxiliares->result() as $auxiliar) {
                                                $itemdata = array(
                                                    'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.$auxiliar->id,
                                                    'text' => $auxiliar->descrip
                                                );
                                                $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                                                if (strlen($auxiliar->imagen) > 0) $found = $auxiliar->imagen;    
                                                else {
                                                    $direccion = $default;
                                                    $found = '';
                                                }

                                                $imagen = base_url().$direccion.$found;
                                                if (!file_exists($direccion.$found)) $imagen = base_url().$default;


                                                if ($dato->ctcontrol == 1) {
                                                    $pay1 = (object)$this->OpcionesBancos[0];
                                                    $pay2 = (object)$this->OpcionesBancos[2];
                                                    $itemdata['items'] = [
                                                        array(
                                                            'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.(int)explode(",", $dato->useauxi)[0].'-'.$auxiliar->id.'-'.$pay1->ID,
                                                            'text' => $pay1->Name,
                                                            'icon' => $pay1->icon,
                                                            'opcion' => $pay1->ID,
                                                            'opcBanco' => true,
                                                            'idcuenta' => $dato->idctcuenta,
                                                            'usec' => $dato->askidcentro,
                                                            'usep' => (int)$dato->askidproyecto,
                                                            'control' => (int)$dato->ctcontrol,
                                                            'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                            'idauxi' => (int)$auxiliar->id,
                                                            'imagen' => $imagen
                                                        ),
                                                        array(
                                                            'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.(int)explode(",", $dato->useauxi)[0].'-'.$auxiliar->id.'-'.$pay2->ID,
                                                            'text' => $pay2->Name,
                                                            'icon' => $pay2->icon,
                                                            'opcion' => $pay2->ID,
                                                            'opcBanco' => true,
                                                            'idcuenta' => $dato->idctcuenta,
                                                            'usec' => $dato->askidcentro,
                                                            'usep' => (int)$dato->askidproyecto,
                                                            'control' => (int)$dato->ctcontrol,
                                                            'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                            'idauxi' => (int)$auxiliar->id,
                                                            'imagen' => $imagen
                                                        ),
                                                    ];

                                                } else {
                                                    $itemdata['opcion'] = 0;
                                                    $itemdata['icon'] = 'money';
                                                    $itemdata['usec'] = $dato->askidcentro;
                                                    $itemdata['usep'] = (int)$dato->askidproyecto;
                                                    $itemdata['control'] = (int)$dato->ctcontrol;
                                                    $itemdata['idtabla'] = (int)explode(",", $dato->useauxi)[0];
                                                    $itemdata['idauxi'] = (int)$auxiliar->id;
                                                    $itemdata['imagen'] = $imagen;
                                                }

                                                $items[] = $itemdata;
                                            }
                                        }
                                    } else {
                                        $items[] = array(
                                            'id' => $dato->idrec.'-'.$dato->idctcuenta,
                                            'text' => 'Vale de Caja',
                                            'icon' => 'square',
                                            'opcion' => 0,
                                            'idcuenta' => $dato->idctcuenta,
                                            'usec' => $dato->askidcentro,
                                            'usep' => (int)$dato->askidproyecto,
                                            'control' => (int)$dato->ctcontrol,
                                            'idtabla' => null,
                                            'imagen' => base_url().$default
                                        );
                                    }

                                    $Cuentas[] = array(
                                        'id' => $dato->idctcuenta,
                                        'text' => $dato->descrip,
                                        'items' => $items,
                                        'expanded' => true,
                                    );
                                }
                            }
                        }

                        $valorTotal = $this->contabilidad_model->getDataPartida(1, array(
                            'pnumero' => $partida->pnumero,
                            'idcuenta' => $IDCuenta,
                            'idtabla' => $IDTabla,
                            'idauxi' => $IDAuxi
                        ));
                        $objecto->total = $valorTotal;
                        $objecto->totalv = number_format((float)$valorTotal, 2, '.', ',');
                        $objecto->totalLetras = trim($this->valorEnLetras($valorTotal));
                        if ($partida->estatus == 0 && $porigen[1] == "0") $objecto->permiso = true;
                        else {
                            $movimientoFinal = $this->contabilidad_model->getDataPartida(2, array(
                                'pnumero' => $partida->pnumero,
                                'monto' => $valorTotal,
                            ));
                            if (count((array)$movimientoFinal) > 0) {
                                $objecto->givefinal = true;
                                $Centros = [];
                                $Proyectos = [];
                                $hcentro = $movimientoFinal->askidcentro;
                                $hproyecto = $movimientoFinal->askidproyecto;
                                if (strlen(trim($hcentro)) > 0 || $movimientoFinal->idcentro != 0) {
                                    $hcentro = $movimientoFinal->idcentro;
                                    $centros = $this->contabilidad_model->getACDetalleData(1, $hcentro);
                                    if ($centros->num_rows() > 0) {
                                        foreach ($centros->result() as $centro) {
                                            $Centros[] = array(
                                                'ID' => (int)$centro->idcentro,
                                                'Name' => $centro->descrip,
                                            );
                                        }
                                    }
                                }
                                if ($hproyecto == 1 || $movimientoFinal->idproject != 0) {
                                    $proyectos = $this->contabilidad_model->getACDetalleData(2);
                                    if ($proyectos->num_rows() > 0) {
                                        foreach ($proyectos->result() as $proyecto) {
                                            $Proyectos[] = array(
                                                'ID' => (int)$proyecto->Idproject,
                                                'Name' => $proyecto->descrip
                                            );
                                        }
                                    }
                                }
                                $formaPay = 'Vale de Caja';
                                $opcionControl = 0;
                                $imagen = base_url().$default;
                                if ($movimientoFinal->idtabla != 0) {
                                    $auxiliar = $this->contabilidad_model->getResponsable($movimientoFinal->idauxi, $movimientoFinal->idtabla);
                                    $formaPay = $auxiliar->descrip;
                                    $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                                    if (strlen(trim($auxiliar->imagen)) > 0) {
                                        if (file_exists($direccion.trim($auxiliar->imagen))) $imagen = base_url().$direccion.$auxiliar->imagen;
                                    }
                                    if ($movimientoFinal->idtabla == 1) {
                                        foreach ($this->OpcionesBancos as $opcionBanco) {
                                            $opcionBanco = (object)$opcionBanco;
                                            if ($opcionBanco->Name == $movimientoFinal->doc_type) {
                                                $opcionControl = $opcionBanco->ID;
                                                break;
                                            }
                                        }
                                    }
                                }

                                $objecto->movfinal = array(
                                    'tipodoc' => $movimientoFinal->doc_type,
                                    'opcioncontrol' => (int)$opcionControl,
                                    'descripcion' => $movimientoFinal->descrip,
                                    'idcentro' => (int)$movimientoFinal->idcentro,
                                    'idproyecto' => (int)$movimientoFinal->idproject,
                                    'centros' => $Centros,
                                    'proyectos' => $Proyectos,
                                    'serie' => $movimientoFinal->doc_serie,
                                    'numero' => $movimientoFinal->doc_numero,
                                    'formaPay' => $formaPay,
                                    'imagen' => $imagen
                                );
                            } else $objecto->givefinal = false;
                            $objecto->permiso = false;
                        }

                        if ($objecto->permiso) {
                            $Estructura = $this->conversionGetACDetalle(1, array(
                                'opcion' => 1,
                                'extra' => $extra,
                                'pnumero' => $objecto->pnumero,
                            ));
                        }
                        $Datos = array(
                            'Cuentas' => $Cuentas,
                            'Estructura' => $Estructura,
                            'objecto' => $objecto
                        );//*/
                    break;
                    case 2:
                        $IDAuxi = (int)$porigen[2];
                        $IDCuenta = $porigen[3];
                        $datacuenta = $this->contabilidad_model->getCuenta3($IDCuenta);
                        $IDTabla = explode(",", $datacuenta->useauxi)[0];
                        $extra = [
                            $IDCuenta,
                            $IDTabla,
                            $IDAuxi
                        ];
                        $objecto->extra = implode("-", $extra);
                        $default = 'assets/img/sinImagen.png';

                        if ($partida->estatus == 0 && $porigen[1] == "0") $objecto->permiso = true;
                        else $objecto->permiso = false;

                        if ($objecto->permiso) {
                            $Estructura = $this->conversionGetACDetalle(2, array(
                                'opcion' => 1,
                                'extra' => explode("-", $objecto->extra),
                                'pnumero' => $objecto->pnumero,
                            ));
                            #   CUENTAS DE DESTINO - FORMAS DE PAGO - TREE VIEW
                            $pconfig = explode(",", $config->valor_memo);
                            preg_match_all("/\\((.*?)\\)/", $pconfig[1], $dconfig);
                            $cuentas = explode(";", implode("", $dconfig[1]));
                            $cuentas = $this->contabilidad_model->getACDetalleData(-1, $cuentas);
                            
                            if ($cuentas->num_rows() > 0) {
                                foreach ($cuentas->result() as $dato) {
                                    if ($this->multiplesContabilidad(1, $dato->malos)) {
                                        $items = [];
                                        if (strlen(trim($dato->useauxi)) > 0) {
                                            $auxiliares = $this->contabilidad_model->getACDetalleData(4, explode(",", $dato->useauxi));
                                            if ($auxiliares->num_rows() > 0) {
                                                foreach ($auxiliares->result() as $auxiliar) {
                                                    $itemdata = array(
                                                        'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.$auxiliar->id,
                                                        'text' => $auxiliar->descrip
                                                    );
                                                    $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                                                    if (strlen($auxiliar->imagen) > 0) $found = $auxiliar->imagen;    
                                                    else {
                                                        $direccion = $default;
                                                        $found = '';
                                                    }

                                                    $imagen = base_url().$direccion.$found;
                                                    if (!file_exists($direccion.$found)) $imagen = base_url().$default;


                                                    if ($dato->ctcontrol == 1) {
                                                        $pay1 = (object)$this->OpcionesBancos[1];
                                                        $pay2 = (object)$this->OpcionesBancos[3];
                                                        $itemdata['items'] = [
                                                            array(
                                                                'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.(int)explode(",", $dato->useauxi)[0].'-'.$auxiliar->id.'-'.$pay1->ID,
                                                                'text' => $pay1->Name,
                                                                'icon' => $pay1->icon,
                                                                'opcion' => $pay1->ID,
                                                                'opcBanco' => true,
                                                                'idcuenta' => $dato->idctcuenta,
                                                                'usec' => $dato->askidcentro,
                                                                'usep' => (int)$dato->askidproyecto,
                                                                'control' => (int)$dato->ctcontrol,
                                                                'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                                'idauxi' => (int)$auxiliar->id,
                                                                'imagen' => $imagen
                                                            ),
                                                            array(
                                                                'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.(int)explode(",", $dato->useauxi)[0].'-'.$auxiliar->id.'-'.$pay2->ID,
                                                                'text' => $pay2->Name,
                                                                'icon' => $pay2->icon,
                                                                'opcion' => $pay2->ID,
                                                                'opcBanco' => true,
                                                                'idcuenta' => $dato->idctcuenta,
                                                                'usec' => $dato->askidcentro,
                                                                'usep' => (int)$dato->askidproyecto,
                                                                'control' => (int)$dato->ctcontrol,
                                                                'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                                'idauxi' => (int)$auxiliar->id,
                                                                'imagen' => $imagen
                                                            ),
                                                        ];

                                                    } else {
                                                        $itemdata['opcion'] = 0;
                                                        $itemdata['icon'] = 'money';
                                                        $itemdata['usec'] = $dato->askidcentro;
                                                        $itemdata['usep'] = (int)$dato->askidproyecto;
                                                        $itemdata['control'] = (int)$dato->ctcontrol;
                                                        $itemdata['idtabla'] = (int)explode(",", $dato->useauxi)[0];
                                                        $itemdata['idauxi'] = (int)$auxiliar->id;
                                                        $itemdata['imagen'] = $imagen;
                                                    }

                                                    $items[] = $itemdata;
                                                }
                                            }
                                        } else {
                                            $items[] = array(
                                                'id' => $dato->idrec.'-'.$dato->idctcuenta,
                                                'text' => 'Vale de Caja',
                                                'icon' => 'square',
                                                'opcion' => 0,
                                                'idcuenta' => $dato->idctcuenta,
                                                'usec' => $dato->askidcentro,
                                                'usep' => (int)$dato->askidproyecto,
                                                'control' => (int)$dato->ctcontrol,
                                                'idtabla' => null,
                                                'imagen' => base_url().$default
                                            );
                                        }

                                        $Cuentas[] = array(
                                            'id' => $dato->idctcuenta,
                                            'text' => $dato->descrip,
                                            'items' => $items,
                                            'expanded' => true,
                                        );
                                    }
                                }
                            }
                        } else {
                            $valorTotal = $this->contabilidad_model->getDataPartida(4, array(
                                'pnumero' => $partida->pnumero,
                                'idcuenta' => $IDCuenta,
                                'idtabla' => $IDTabla,
                                'idauxi' => $IDAuxi
                            ));
                            $movimientoFinal = $this->contabilidad_model->getDataPartida(5, array(
                                'pnumero' => $partida->pnumero,
                                'monto' => $valorTotal,
                            ));
                            $objecto->givefinal = false;
                            if (count((array)$movimientoFinal) > 0) {
                                $objecto->givefinal = true;
                                $formaPay = 'Vale de Caja';
                                $opcionControl = 0;
                                $imagen = base_url().$default;
                                if ($movimientoFinal->idtabla != 0) {
                                    $auxiliar = $this->contabilidad_model->getResponsable($movimientoFinal->idauxi, $movimientoFinal->idtabla);
                                    $formaPay = $auxiliar->descrip;
                                    $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                                    if (strlen(trim($auxiliar->imagen)) > 0) {
                                        if (file_exists($direccion.trim($auxiliar->imagen))) $imagen = base_url().$direccion.$auxiliar->imagen;
                                    }
                                    if ($movimientoFinal->idtabla == 1) {
                                        foreach ($this->OpcionesBancos as $opcionBanco) {
                                            $opcionBanco = (object)$opcionBanco;
                                            if ($opcionBanco->Name == $movimientoFinal->doc_type) {
                                                $opcionControl = $opcionBanco->ID;
                                                break;
                                            }
                                        }
                                    }
                                }
                                $objecto->movfinal = array(
                                    'tipodoc' => $movimientoFinal->doc_type,
                                    'opcioncontrol' => (int)$opcionControl,
                                    'descripcion' => $movimientoFinal->descrip,
                                    'idcentro' => (int)$movimientoFinal->idcentro,
                                    'idproyecto' => (int)$movimientoFinal->idproject,
                                    'centro' => $movimientoFinal->centro,
                                    'proyecto' => $movimientoFinal->proyecto,
                                    'serie' => $movimientoFinal->doc_serie,
                                    'numero' => $movimientoFinal->doc_numero,
                                    'formaPay' => $formaPay,
                                    'imagen' => $imagen,
                                );
                            }
                        }
                        $Datos = array(
                            'Cuentas' => $Cuentas,
                            'Estructura' => $Estructura,
                            'objecto' => $objecto
                        );
                    break;
                }
            break;
        }
        return $Datos;
    }
    #------------------------------------------------------     ASISTENTE CONTABLE DETALLE
    public function indexACDetalle($pnumero)
    {
        if($this->validatePermiso()) {
            if ($pnumero != null) {
                if (is_numeric($pnumero)) {
                    $this->load->model('contabilidad_model');
                    $partida = $this->contabilidad_model->getEPDetalle((int)$pnumero);
                    if (count((array)$partida) > 0) {
                        date_default_timezone_set('America/El_Salvador');
                        $direccion = $this->uri->segment(1);
                        $this->load->model('global_model');
                        $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                        $porigen = explode("/", $partida->origen);
                        
                        $objecto = new stdClass();
                        $objecto->pnumero = $partida->pnumero;
                        $objecto->fecha = $partida->fecha;
                        $objecto->vfecha = date_format(date_create($partida->fecha), "d/m/Y");
                        $objecto->idtpartida = $partida->idptipo;
                        $objecto->tpartida = $partida->tipoP;
                        $objecto->referencia = $partida->referencia;
                        $objecto->descripcion = $partida->descrip;
                        $objecto->estatus = $partida->estatus;
                        $objecto->estado = array_search($porigen[1], $this->EstadosPartidas);
                        $objecto->debe = $partida->debe;
                        $objecto->haber = $partida->haber;
                        $objecto->extra = '';//*/
                        
                        $this->data['factual'] = date_create()->format('Y-m-d');
                        $Cuentas = [];
                        $Estructura = [];
                        switch ($porigen[0]) {
                            case 'AC_Quedan': # 0
                                $titulo = 'emisión de quedan';
                                $this->data['Opcion'] = 0;
                                $opcionData = (object)$this->OpcionesAC[array_search(0, array_column($this->OpcionesAC, 'opcion'))];

                                $valorTotal = $this->contabilidad_model->getACDetalleData(8, $partida->pnumero);

                                $objecto->total = $valorTotal;
                                $objecto->vtotal = number_format((float)$valorTotal, 2, '.', ',');
                                
                                if ($partida->estatus == 0 && $porigen[1] == "0") $objecto->permiso = true;
                                else $objecto->permiso = false;

                                #  CUENTAS DEL SELECT AUX 
                                $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);
                                $pconfig = explode(",", $config->valor_memo)[0];
                                preg_match_all("/\\((.*?)\\)/", $pconfig, $founds);
                                $lcuentas = explode(";", implode("", $founds[1]));
                                $cuentas = $this->contabilidad_model->getACDetalleData(-1, $lcuentas);
                                if ($cuentas->num_rows() > 0) {
                                    foreach ($cuentas->result() as $keycuenta => $cuenta) {
                                        if ($this->multiplesContabilidad(1, $cuenta->malos)) {
                                            if (strlen($cuenta->useauxi) > 0) {
                                                $auxiliares = $this->contabilidad_model->getACDetalleData(4, explode(",", $cuenta->useauxi));
                                                if ($auxiliares->num_rows() > 0) {
                                                    foreach ($auxiliares->result() as $auxiliar) {
                                                        $Estructura[] = array(
                                                            'ID' => $keycuenta.'_'.$auxiliar->id,
                                                            'Name' => $auxiliar->descrip,
                                                            'tipo' => $cuenta->descrip,
                                                            'cuenta' => $cuenta->idctcuenta,
                                                            'usec' => $cuenta->askidcentro,
                                                            'usep' => (int)$cuenta->askidproyecto,
                                                            'idtabla' => (int)explode(",", $cuenta->useauxi)[0],
                                                            'idauxi' => (int)$auxiliar->id,
                                                        );
                                                    }
                                                }
                                            } else {
                                                $Estructura[] = array(
                                                    'ID' => $keycuenta.'_'.$cuenta->idctcuenta,
                                                    'Name' => $cuenta->descrip,
                                                    'tipo' => $cuenta->descrip,
                                                    'cuenta' => $cuenta->idctcuenta,
                                                    'usec' => $cuenta->askidcentro,
                                                    'usep' => (int)$cuenta->askidproyecto,
                                                    'idtabla' => null,
                                                    'idauxi' => 0,
                                                );
                                            }
                                        }
                                    }
                                }
                            break;
                            case 'AC_Pagos': # 1
                                $titulo = 'pagos a proveedores';
                                $this->data['Opcion'] = 1;
                                $opcionData = (object)$this->OpcionesAC[array_search(1, array_column($this->OpcionesAC, 'opcion'))];
                                $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);

                                /*$IDAuxi = (int)$porigen[2];
                                $IDCuenta = $porigen[3];
                                $datacuenta = $this->contabilidad_model->getCuenta3($IDCuenta);
                                $IDTabla = explode(",", $datacuenta->useauxi)[0];
                                $extra = [
                                    $IDCuenta,
                                    $IDTabla,
                                    $IDAuxi
                                ];
                                $objecto->extra = implode("-", $extra);

                                #   CUENTAS DE DESTINO - FORMAS DE PAGO - TREE VIEW
                                $pconfig = explode(",", $config->valor_memo);
                                preg_match_all("/\\((.*?)\\)/", $pconfig[1], $dconfig);
                                $cuentas = explode(";", implode("", $dconfig[1]));
                                $cuentas = $this->contabilidad_model->getACDetalleData(-1, $cuentas);
                                $default = 'assets/img/sinImagen.png';

                                if ($cuentas->num_rows() > 0) {
                                    foreach ($cuentas->result() as $dato) {
                                        if ($this->multiplesContabilidad(1, $dato->malos)) {
                                            $items = [];
                                            if (strlen(trim($dato->useauxi)) > 0) {
                                                $auxiliares = $this->contabilidad_model->getACDetalleData(4, explode(",", $dato->useauxi));
                                                if ($auxiliares->num_rows() > 0) {
                                                    foreach ($auxiliares->result() as $auxiliar) {
                                                        $itemdata = array(
                                                            'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.$auxiliar->id,
                                                            'text' => $auxiliar->descrip
                                                        );
                                                        $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                                                        if (strlen($auxiliar->imagen) > 0) $found = $auxiliar->imagen;    
                                                        else {
                                                            $direccion = $default;
                                                            $found = '';
                                                        }

                                                        $imagen = base_url().$direccion.$found;
                                                        if (!file_exists($direccion.$found)) $imagen = base_url().$default;


                                                        if ($dato->ctcontrol == 1) {
                                                            $pay1 = (object)$this->OpcionesBancos[0];
                                                            $pay2 = (object)$this->OpcionesBancos[2];
                                                            $itemdata['items'] = [
                                                                array(
                                                                    'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.(int)explode(",", $dato->useauxi)[0].'-'.$auxiliar->id.'-'.$pay1->ID,
                                                                    'text' => $pay1->Name,
                                                                    'icon' => $pay1->icon,
                                                                    'opcion' => $pay1->ID,
                                                                    'opcBanco' => true,
                                                                    'idcuenta' => $dato->idctcuenta,
                                                                    'usec' => $dato->askidcentro,
                                                                    'usep' => (int)$dato->askidproyecto,
                                                                    'control' => (int)$dato->ctcontrol,
                                                                    'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                                    'idauxi' => (int)$auxiliar->id,
                                                                    'imagen' => $imagen
                                                                ),
                                                                array(
                                                                    'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.(int)explode(",", $dato->useauxi)[0].'-'.$auxiliar->id.'-'.$pay2->ID,
                                                                    'text' => $pay2->Name,
                                                                    'icon' => $pay2->icon,
                                                                    'opcion' => $pay2->ID,
                                                                    'opcBanco' => true,
                                                                    'idcuenta' => $dato->idctcuenta,
                                                                    'usec' => $dato->askidcentro,
                                                                    'usep' => (int)$dato->askidproyecto,
                                                                    'control' => (int)$dato->ctcontrol,
                                                                    'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                                    'idauxi' => (int)$auxiliar->id,
                                                                    'imagen' => $imagen
                                                                ),
                                                            ];

                                                        } else {
                                                            $itemdata['opcion'] = 0;
                                                            $itemdata['icon'] = 'money';
                                                            $itemdata['usec'] = $dato->askidcentro;
                                                            $itemdata['usep'] = (int)$dato->askidproyecto;
                                                            $itemdata['control'] = (int)$dato->ctcontrol;
                                                            $itemdata['idtabla'] = (int)explode(",", $dato->useauxi)[0];
                                                            $itemdata['idauxi'] = (int)$auxiliar->id;
                                                            $itemdata['imagen'] = $imagen;
                                                        }

                                                        $items[] = $itemdata;
                                                    }
                                                }
                                            } else {
                                                $items[] = array(
                                                    'id' => $dato->idrec.'-'.$dato->idctcuenta,
                                                    'text' => 'Vale de Caja',
                                                    'icon' => 'square',
                                                    'opcion' => 0,
                                                    'idcuenta' => $dato->idctcuenta,
                                                    'usec' => $dato->askidcentro,
                                                    'usep' => (int)$dato->askidproyecto,
                                                    'control' => (int)$dato->ctcontrol,
                                                    'idtabla' => null,
                                                    'imagen' => base_url().$default
                                                );
                                            }

                                            $Cuentas[] = array(
                                                'id' => $dato->idctcuenta,
                                                'text' => $dato->descrip,
                                                'items' => $items,
                                                'expanded' => true,
                                            );
                                        }
                                    }
                                }

                                $valorTotal = $this->contabilidad_model->getDataPartida(1, array(
                                    'pnumero' => $partida->pnumero,
                                    'idcuenta' => $IDCuenta,
                                    'idtabla' => $IDTabla,
                                    'idauxi' => $IDAuxi
                                ));
                                $objecto->total = $valorTotal;
                                $objecto->totalv = number_format((float)$valorTotal, 2, '.', ',');
                                $objecto->totalLetras = trim($this->valorEnLetras($valorTotal));
                                if ($partida->estatus == 0 && $porigen[1] == "0") $objecto->permiso = true;
                                else {
                                    $movimientoFinal = $this->contabilidad_model->getDataPartida(2, array(
                                        'pnumero' => $partida->pnumero,
                                        'monto' => $valorTotal,
                                    ));
                                    if (count((array)$movimientoFinal) > 0) {
                                        $objecto->givefinal = true;
                                        $Centros = [];
                                        $Proyectos = [];
                                        $hcentro = $movimientoFinal->askidcentro;
                                        $hproyecto = $movimientoFinal->askidproyecto;
                                        if (strlen(trim($hcentro)) > 0 || $movimientoFinal->idcentro != 0) {
                                            $hcentro = $movimientoFinal->idcentro;
                                            $centros = $this->contabilidad_model->getACDetalleData(1, $hcentro);
                                            if ($centros->num_rows() > 0) {
                                                foreach ($centros->result() as $centro) {
                                                    $Centros[] = array(
                                                        'ID' => (int)$centro->idcentro,
                                                        'Name' => $centro->descrip,
                                                    );
                                                }
                                            }
                                        }
                                        if ($hproyecto == 1 || $movimientoFinal->idproject != 0) {
                                            $proyectos = $this->contabilidad_model->getACDetalleData(2);
                                            if ($proyectos->num_rows() > 0) {
                                                foreach ($proyectos->result() as $proyecto) {
                                                    $Proyectos[] = array(
                                                        'ID' => (int)$proyecto->Idproject,
                                                        'Name' => $proyecto->descrip
                                                    );
                                                }
                                            }
                                        }
                                        $formaPay = 'Vale de Caja';
                                        $opcionControl = 0;
                                        $imagen = base_url().$default;
                                        if ($movimientoFinal->idtabla != 0) {
                                            $auxiliar = $this->contabilidad_model->getResponsable($movimientoFinal->idauxi, $movimientoFinal->idtabla);
                                            $formaPay = $auxiliar->descrip;
                                            $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                                            if (strlen(trim($auxiliar->imagen)) > 0) {
                                                if (file_exists($direccion.trim($auxiliar->imagen))) $imagen = base_url().$direccion.$auxiliar->imagen;
                                            }
                                            if ($movimientoFinal->idtabla == 1) {
                                                foreach ($this->OpcionesBancos as $opcionBanco) {
                                                    $opcionBanco = (object)$opcionBanco;
                                                    if ($opcionBanco->Name == $movimientoFinal->doc_type) {
                                                        $opcionControl = $opcionBanco->ID;
                                                        break;
                                                    }
                                                }
                                            }
                                        }

                                        $objecto->movfinal = array(
                                            'tipodoc' => $movimientoFinal->doc_type,
                                            'opcioncontrol' => (int)$opcionControl,
                                            'descripcion' => $movimientoFinal->descrip,
                                            'idcentro' => (int)$movimientoFinal->idcentro,
                                            'idproyecto' => (int)$movimientoFinal->idproject,
                                            'centros' => $Centros,
                                            'proyectos' => $Proyectos,
                                            'serie' => $movimientoFinal->doc_serie,
                                            'numero' => $movimientoFinal->doc_numero,
                                            'formaPay' => $formaPay,
                                            'imagen' => $imagen
                                        );
                                    } else $objecto->givefinal = false;
                                    $objecto->permiso = false;
                                }

                                if ($objecto->permiso) {
                                    $Estructura = $this->conversionGetACDetalle(1, array(
                                        'opcion' => 1,
                                        'extra' => $extra,
                                        'pnumero' => $objecto->pnumero,
                                    ));
                                }//*/
                                $datos = (object)$this->multipleOpcionesAC(2, [
                                    'opcionData' => $opcionData,
                                    'porigen' => $porigen,
                                    'config' => $config,
                                    'partida' => $partida,
                                ]);
                                $objecto = $datos->objecto;
                                $Cuentas = $datos->Cuentas;
                                $Estructura = $datos->Estructura;
                            break;
                            case 'AC_Abonos': # 2
                                $titulo = 'abonos de clientes';
                                $this->data['Opcion'] = 2;
                                $opcionData = (object)$this->OpcionesAC[array_search(2, array_column($this->OpcionesAC, 'opcion'))];
                                $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);
                                /*$IDAuxi = (int)$porigen[2];
                                $IDCuenta = $porigen[3];
                                $datacuenta = $this->contabilidad_model->getCuenta3($IDCuenta);
                                $IDTabla = explode(",", $datacuenta->useauxi)[0];
                                $extra = [
                                    $IDCuenta,
                                    $IDTabla,
                                    $IDAuxi
                                ];
                                $objecto->extra = implode("-", $extra);
                                $default = 'assets/img/sinImagen.png';

                                if ($partida->estatus == 0 && $porigen[1] == "0") $objecto->permiso = true;
                                else $objecto->permiso = false;

                                if ($objecto->permiso) {
                                    $Estructura = $this->conversionGetACDetalle(2, array(
                                        'opcion' => 1,
                                        'extra' => explode("-", $objecto->extra),
                                        'pnumero' => $objecto->pnumero,
                                    ));
                                    #   CUENTAS DE DESTINO - FORMAS DE PAGO - TREE VIEW
                                    $pconfig = explode(",", $config->valor_memo);
                                    preg_match_all("/\\((.*?)\\)/", $pconfig[1], $dconfig);
                                    $cuentas = explode(";", implode("", $dconfig[1]));
                                    $cuentas = $this->contabilidad_model->getACDetalleData(-1, $cuentas);
                                    
                                    if ($cuentas->num_rows() > 0) {
                                        foreach ($cuentas->result() as $dato) {
                                            if ($this->multiplesContabilidad(1, $dato->malos)) {
                                                $items = [];
                                                if (strlen(trim($dato->useauxi)) > 0) {
                                                    $auxiliares = $this->contabilidad_model->getACDetalleData(4, explode(",", $dato->useauxi));
                                                    if ($auxiliares->num_rows() > 0) {
                                                        foreach ($auxiliares->result() as $auxiliar) {
                                                            $itemdata = array(
                                                                'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.$auxiliar->id,
                                                                'text' => $auxiliar->descrip
                                                            );
                                                            $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                                                            if (strlen($auxiliar->imagen) > 0) $found = $auxiliar->imagen;    
                                                            else {
                                                                $direccion = $default;
                                                                $found = '';
                                                            }
    
                                                            $imagen = base_url().$direccion.$found;
                                                            if (!file_exists($direccion.$found)) $imagen = base_url().$default;
    
    
                                                            if ($dato->ctcontrol == 1) {
                                                                $pay1 = (object)$this->OpcionesBancos[1];
                                                                $pay2 = (object)$this->OpcionesBancos[3];
                                                                $itemdata['items'] = [
                                                                    array(
                                                                        'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.(int)explode(",", $dato->useauxi)[0].'-'.$auxiliar->id.'-'.$pay1->ID,
                                                                        'text' => $pay1->Name,
                                                                        'icon' => $pay1->icon,
                                                                        'opcion' => $pay1->ID,
                                                                        'opcBanco' => true,
                                                                        'idcuenta' => $dato->idctcuenta,
                                                                        'usec' => $dato->askidcentro,
                                                                        'usep' => (int)$dato->askidproyecto,
                                                                        'control' => (int)$dato->ctcontrol,
                                                                        'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                                        'idauxi' => (int)$auxiliar->id,
                                                                        'imagen' => $imagen
                                                                    ),
                                                                    array(
                                                                        'id' => $dato->idrec.'-'.$dato->idctcuenta.'-'.(int)explode(",", $dato->useauxi)[0].'-'.$auxiliar->id.'-'.$pay2->ID,
                                                                        'text' => $pay2->Name,
                                                                        'icon' => $pay2->icon,
                                                                        'opcion' => $pay2->ID,
                                                                        'opcBanco' => true,
                                                                        'idcuenta' => $dato->idctcuenta,
                                                                        'usec' => $dato->askidcentro,
                                                                        'usep' => (int)$dato->askidproyecto,
                                                                        'control' => (int)$dato->ctcontrol,
                                                                        'idtabla' => (int)explode(",", $dato->useauxi)[0],
                                                                        'idauxi' => (int)$auxiliar->id,
                                                                        'imagen' => $imagen
                                                                    ),
                                                                ];
    
                                                            } else {
                                                                $itemdata['opcion'] = 0;
                                                                $itemdata['icon'] = 'money';
                                                                $itemdata['usec'] = $dato->askidcentro;
                                                                $itemdata['usep'] = (int)$dato->askidproyecto;
                                                                $itemdata['control'] = (int)$dato->ctcontrol;
                                                                $itemdata['idtabla'] = (int)explode(",", $dato->useauxi)[0];
                                                                $itemdata['idauxi'] = (int)$auxiliar->id;
                                                                $itemdata['imagen'] = $imagen;
                                                            }
    
                                                            $items[] = $itemdata;
                                                        }
                                                    }
                                                } else {
                                                    $items[] = array(
                                                        'id' => $dato->idrec.'-'.$dato->idctcuenta,
                                                        'text' => 'Vale de Caja',
                                                        'icon' => 'square',
                                                        'opcion' => 0,
                                                        'idcuenta' => $dato->idctcuenta,
                                                        'usec' => $dato->askidcentro,
                                                        'usep' => (int)$dato->askidproyecto,
                                                        'control' => (int)$dato->ctcontrol,
                                                        'idtabla' => null,
                                                        'imagen' => base_url().$default
                                                    );
                                                }
    
                                                $Cuentas[] = array(
                                                    'id' => $dato->idctcuenta,
                                                    'text' => $dato->descrip,
                                                    'items' => $items,
                                                    'expanded' => true,
                                                );
                                            }
                                        }
                                    }
                                } else {
                                    $valorTotal = $this->contabilidad_model->getDataPartida(4, array(
                                        'pnumero' => $partida->pnumero,
                                        'idcuenta' => $IDCuenta,
                                        'idtabla' => $IDTabla,
                                        'idauxi' => $IDAuxi
                                    ));
                                    $movimientoFinal = $this->contabilidad_model->getDataPartida(5, array(
                                        'pnumero' => $partida->pnumero,
                                        'monto' => $valorTotal,
                                    ));
                                    $objecto->givefinal = false;
                                    if (count((array)$movimientoFinal) > 0) {
                                        $objecto->givefinal = true;
                                        $formaPay = 'Vale de Caja';
                                        $opcionControl = 0;
                                        $imagen = base_url().$default;
                                        if ($movimientoFinal->idtabla != 0) {
                                            $auxiliar = $this->contabilidad_model->getResponsable($movimientoFinal->idauxi, $movimientoFinal->idtabla);
                                            $formaPay = $auxiliar->descrip;
                                            $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                                            if (strlen(trim($auxiliar->imagen)) > 0) {
                                                if (file_exists($direccion.trim($auxiliar->imagen))) $imagen = base_url().$direccion.$auxiliar->imagen;
                                            }
                                            if ($movimientoFinal->idtabla == 1) {
                                                foreach ($this->OpcionesBancos as $opcionBanco) {
                                                    $opcionBanco = (object)$opcionBanco;
                                                    if ($opcionBanco->Name == $movimientoFinal->doc_type) {
                                                        $opcionControl = $opcionBanco->ID;
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                        $objecto->movfinal = array(
                                            'tipodoc' => $movimientoFinal->doc_type,
                                            'opcioncontrol' => (int)$opcionControl,
                                            'descripcion' => $movimientoFinal->descrip,
                                            'idcentro' => (int)$movimientoFinal->idcentro,
                                            'idproyecto' => (int)$movimientoFinal->idproject,
                                            'centro' => $movimientoFinal->centro,
                                            'proyecto' => $movimientoFinal->proyecto,
                                            'serie' => $movimientoFinal->doc_serie,
                                            'numero' => $movimientoFinal->doc_numero,
                                            'formaPay' => $formaPay,
                                            'imagen' => $imagen,
                                        );
                                    }
                                }//*/
                                $datos = (object)$this->multipleOpcionesAC(2, [
                                    'opcionData' => $opcionData,
                                    'porigen' => $porigen,
                                    'config' => $config,
                                    'partida' => $partida,
                                ]);
                                $objecto = $datos->objecto;
                                $Cuentas = $datos->Cuentas;
                                $Estructura = $datos->Estructura;
                            break;
                            case 'AC_Gastos': # 3
                                $titulo = 'gastos';
                                $this->data['Opcion'] = 3;
                                $opcionData = (object)$this->OpcionesAC[array_search(3, array_column($this->OpcionesAC, 'opcion'))];
                            break;
                            case 'AC_Depos': # 4
                                $titulo = 'depositos';
                                $this->data['Opcion'] = 4;
                                $opcionData = (object)$this->OpcionesAC[array_search(4, array_column($this->OpcionesAC, 'opcion'))];
                            break;
                            case 'AC_Transfers': # 5
                                $titulo = 'transferencias';
                                $this->data['Opcion'] = 5;
                                $opcionData = (object)$this->OpcionesAC[array_search(5, array_column($this->OpcionesAC, 'opcion'))];
                            break;
                            default:
                                redirect('Inicio');
                            break;
                        }
                        $this->data['partida'] = $objecto;
                        $this->data['Cuentas'] = $Cuentas;
                        $this->data['Estructura'] = $Estructura;
                        $resultAppName = array(
                            'namePage' => 'Detalle de '.$titulo
                        );
                        $this->session->set_userdata($resultAppName);
                        $this->load->view("mantenimiento_ACDetalle", $this->data);

                    } else echo "<h1>Partida no existe</h1>";
                } else echo "<h1>Parámetro Incorrecto</h1>";
            } else echo "<h1>Falta Parámetro Número</h1>";
        }
    }
    #   GET ASISTENTE CONTABLE DETALLE
    public function getACDetalle()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $OpcionAC = $this->input->post('opcion');
            $pnumero = $this->input->post('pnumero');
            switch ($OpcionAC) {
                case 0:
                    $Datos = (object)$this->conversionGetACDetalle(0, [
                        'opcion' => 0,
                        'pnumero' => $pnumero,
                    ]);
                    $datA[] = array('valido' => true, 'datos' => $Datos->datos, 'cuadre' => (float)$Datos->cuadre);
                break;
                case 1:
                    $extra = $this->input->post("extra");
                    $pextra = explode("-", $extra);
                    $Datos = $this->conversionGetACDetalle(1, array(
                        'opcion' => 0,
                        'extra' => $pextra,
                        'pnumero' => $pnumero,
                    ));
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                break;
                case 2:
                    $extra = $this->input->post("extra");
                    $pextra = explode("-", $extra);
                    $Datos = (object)$this->conversionGetACDetalle(2, array(
                        'opcion' => 0,
                        'extra' => $pextra,
                        'pnumero' => $pnumero,
                    ));
                    $datA[] = array(
                        'valido' => true,
                        'datos' => $Datos->datos,
                        'total' => $Datos->valorTotal,
                        'totalLetras' => $Datos->totalLetras
                    );
                break;
                case 3:
                break;
                case 4:
                break;
                case 5:
                break;
            }
            echo json_encode($datA);
        }
    }
    private function conversionGetACDetalle($opc, $datos)
    {
        $Datos = [];
        switch ($opc) {
            case 0:
                $data = (object)$datos;
                $pnumero = $data->pnumero;
                if ($data->opcion == 0) { # TABS QUEDANS
                    $datos = $this->contabilidad_model->getACDetalle(0, $pnumero);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $Datos[] = array(
                                'key' => (int)$dato->idrec,
                                'text' => $dato->doc_serie.'-'.$dato->doc_numero,
                                'icon' => ((float)$dato->haber == (float)$dato->totaldebe) ? 'inactivefolder' : 'folder',
                                'valor' => (float)$dato->haber,
                                'debe' => (float)$dato->totaldebe,
                                'documento' => trim($dato->proveedor.' '.$dato->doc_type).' N°: ',
                                'valorv' => number_format((float)$dato->haber, 2, '.', ',')
                            );
                        }
                    }
                    $Datos = array (
                        'datos' => $Datos,
                        'cuadre' => $this->contabilidad_model->getDataPartida(3, $pnumero)
                    );
                } else {#   INFORMACION DE QUEDAN
                    $ID = $data->controlnum;
                    #   GET PRODUCTOS/GASTOS-IMPUESTOS
                    $opcionData = (object)$this->OpcionesAC[array_search(0, array_column($this->OpcionesAC, 'opcion'))];
                    $config = $this->contabilidad_model->getConfigAContable($opcionData->variable);
                    $pconfig = explode(",", $config->valor_memo);
                    preg_match_all("/\\((.*?)\\)/", $pconfig[0], $founds);
                    $CDestinos = explode(";", implode("", $founds[1]));
                    $datos = $this->contabilidad_model->getACDetalleData(13, [
                        'pnumero' => $pnumero,
                        'controlnum' => $ID,
                        'IDS' => $CDestinos
                    ]);
                    $Destinos = [];
                    $TotalDestinos = 0;
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $responsable = '';
                            if ($dato->idtabla != 0) {
                                $responsable = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                                $responsable = $responsable->descrip;
                            }
                            $Destinos[] = array(
                                'key' => (int)$dato->idrec,
                                'cuenta' => $dato->idctcuenta,
                                'tcuenta' => $dato->cuenta,
                                'idcentro' => (int)$dato->idcentro,
                                'idproyecto' => (int)$dato->idproject,
                                'usec' => $dato->usec,
                                'usep' => (int)$dato->usep,
                                'idauxi' => (int)$dato->idauxi,
                                'idtabla' => (int)$dato->idtabla,
                                'tauxi' => $responsable,
        
                                'descripcion' => $dato->descrip,
                                'debe' => (float)$dato->debe,
                                'haber' => (float)$dato->haber,
                                'valor' => (float)$dato->debe,
                            );
                            $TotalDestinos += $dato->debe;
                        }
                    }

                    preg_match_all("/\\((.*?)\\)/", $pconfig[1], $founds);
                    $CImpuestos = explode(";", implode("", $founds[1]));
                    $Impuestos = [];
                    $impuestos = $datos = $this->contabilidad_model->getACDetalleData(15, [
                        'pnumero' => $pnumero,
                        'controlnum' => $ID,
                        'IDS' => $CImpuestos
                    ]);
                    if ($impuestos->num_rows() > 0) {
                        foreach ($impuestos->result() as $impuesto) {
                            $Impuestos[] = array(
                                'idcuenta' => $impuesto->idctcuenta,
                                'cuenta' => $impuesto->cuenta,

                                'key' => (int)$impuesto->idrec,
                                'descripcion' => $impuesto->descripcion,
                                'usec' => $impuesto->usec,
                                'usep' => (int)$impuesto->usep,
                                'useauxi' => $impuesto->useauxi,
                                'idtabla' => $impuesto->idtabla,
                                'idauxi' => (int)$impuesto->idauxi,
                                'idcentro' => (int)$impuesto->idcentro,
                                'idproyecto' => (int)$impuesto->idproject,
                                'valor' => $this->devolverMonto_NaturalezaCuenta($impuesto->catgrupo, $impuesto->debe, $impuesto->haber)
                            );
                        }
                    }
                    

                    $quedan = $this->contabilidad_model->getACDetalleData(14, $ID);
                    $Quedan = array(
                        'Key' => (int)$ID,
                        'cuenta' => $quedan->idctcuenta,
                        'descripcion' => $quedan->descrip,
                        'idtabla' => (int)$quedan->idtabla,
                        'idauxi' => (int)$quedan->idauxi,
                        'tauxi' => $quedan->tauxi,
                        'dias' => (int)$quedan->dias,
                        'direccion' => $quedan->direccion,
                        'telefono' => $quedan->telefono,
                        'idcentro' => (int)$quedan->idcentro,
                        'centro' => $quedan->centro,
                        'idproyecto' => (int)$quedan->idproject,
                        'proyecto' => $quedan->proyecto,
                        'usec' => $quedan->usec,
                        'usep' => (int)$quedan->usep,
                        'idgestor' => (int)$quedan->doc_idworker,
                        
                        'tipodoc' => $quedan->doc_type,
                        'nresolucion' => $quedan->doc_datos,
                        'serie' => $quedan->doc_serie,
                        'numero' => $quedan->doc_numero,
                        'femision' => $quedan->doc_emision,
                        'fvence' => $quedan->doc_vence,
                        'subtotal' => (float)$TotalDestinos,
                        'totaldebe' => (float)$quedan->totaldebe,
                        'valor' => (float)$quedan->haber,
                        'maximo' => ((float)$quedan->haber - (float)$quedan->totaldebe),
                        //'maximo' => 0,
                        'valorletras' => trim($this->valorEnLetras($quedan->haber)),
                        'impuestos' => $Impuestos,
                    );

                    $DestinosUse = [];
                    $destinsuse = $this->contabilidad_model->getACDetalleData(10, [
                        'IDQuedanA' => $ID,
                        'cuenta' => $quedan->idctcuenta,
                        'idtabla' => $quedan->idtabla,
                        'idauxi' => $quedan->idauxi,
                        'IDS' => $CDestinos
                    ]);
                    if ($destinsuse->num_rows() > 0) {
                        foreach ($destinsuse->result() as $key => $dato) {
                            $responsable = '';
                            if ($dato->idtabla != 0) {
                                $responsable = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                                $responsable = $responsable->descrip;
                            }
                            $descripcion = $this->contabilidad_model->getACDetalleData(11, [
                                'IDQuedanA' => $ID,
                                'cuenta' => $dato->idctcuenta,
                                'idtabla' => $dato->idtabla,
                                'idauxi' => $dato->idauxi,
                                'cuentaPadre' => $quedan->idctcuenta,
                                'idtablaPadre' => $quedan->idtabla,
                                'idauxiPadre' => $quedan->idauxi,
                            ]);//*/
                            $DestinosUse[] = array(
                                //'f' => $dato->fecha,
                                //'ID' => $key.'-'.$dato->pnumero.'-'.$dato->serie.'--'.$dato->numero,
                                'ID' => $key,
                                'Name' => $dato->cuenta,
                                'idcuenta' => $dato->idctcuenta,
                                'idtabla' => (int)$dato->idtabla,
                                'idauxi' => (int)$dato->idauxi,
                                'tauxi' => $responsable,
                                'descripcion' => $descripcion->descrip
                                //'avalor' => (float)$dato->debe
                            );
                        }
                    }
                    $Quedan['destinosuse'] = $DestinosUse; //*/

                    $Datos = array(
                        'datos' => $Destinos,
                        'quedan' => $Quedan,
                    );
                }
            break;
            case 1:
                $opcmulti = (int)$datos['opcion'];
                $pextra = $datos['extra'];
                if ($opcmulti == 0) { # Datos
                    $datacuenta = $this->contabilidad_model->getCuenta3($pextra[0]);
                    $datosabono = $this->contabilidad_model->getACDetalle(1, array(
                        'pnumero' => $datos['pnumero'],
                        'idcuenta' => $pextra[0],
                        'idtabla' => $pextra[1],
                        'idauxi' =>  $pextra[2]
                    ));
                    if ($datosabono->num_rows() > 0) {
                        foreach ($datosabono->result() as $dato) {
                            $Datos[] = array(
                                'key' => (int)$dato->idrec,
                                'usec' => $datacuenta->askidcentro,
                                'usep' => (int)$datacuenta->askidproyecto,
                                'itemline' => (int)$dato->itemline,
                                'titulo' => $dato->descrip,
                                'idcuenta' => $dato->idctcuenta,
                                'idtabla' => (int)$dato->idtabla,
                                'idauxi' => (int)$dato->idauxi,
                                'idcentro' => (int)$dato->idcentro,
                                'idproject' => (int)$dato->idproject,
                                'femision' => $dato->doc_emision,
                                'serien' => $dato->doc_serie.'-'.$dato->doc_numero,
                                'valor' => $dato->debe
                            );
                        }
                    }
                } else { # Lista
                    $datacuenta = $this->contabilidad_model->getCuenta3($pextra[0]);
                    $documentos = $this->contabilidad_model->getDataAContable(1, array(
                        'idcuenta' => $pextra[0],
                        'idtabla' => (int)$pextra[1],
                        'idauxi' => (int)$pextra[2],
                        'pnumero' => $datos['pnumero'],
                    ));
                    if ($documentos->num_rows() > 0) {
                        foreach ($documentos->result() as $documento) {
                            $saldo = $this->getSTC($datacuenta->catgrupo, $documento->debe, $documento->haber);
                            if ((float)$saldo > 0.00) {
                                $Datos[] = array(
                                    'ID' => (int)$documento->idrec,
                                    'Name' => $documento->doc_serie.'-'.$documento->doc_numero,
                                    'usec' => $datacuenta->askidcentro,
                                    'usep' => (int)$datacuenta->askidproyecto,
                                    'tipodoc' => $documento->doc_type,
                                    'serie' => $documento->doc_serie,
                                    'numero' => $documento->doc_numero,
                                    'femision' => $documento->doc_emision,
                                    'fvence' => $documento->doc_vence,
                                    'idgestor' => (int)$documento->doc_idworker,
                                    'femisionv' => date_create($documento->doc_emision)->format('d/m/Y'),
                                    'saldo' => (float)$saldo,
                                    'saldov' => number_format((float)$saldo, 2, '.', ','),
                                );
                            }
                        }
                    }
                }
            break;
            case 2:
                $opcmulti = (int)$datos['opcion'];
                $pextra = $datos['extra'];
                $datacuenta = $this->contabilidad_model->getCuenta3($pextra[0]);
                if ($opcmulti == 0) {#  Datos
                    $datosabono = $this->contabilidad_model->getACDetalle(2, array(
                        'pnumero' => $datos['pnumero'],
                        'idcuenta' => $pextra[0],
                        'idtabla' => (int)$pextra[1],
                        'idauxi' =>  (int)$pextra[2]
                    ));
                    if ($datosabono->num_rows() > 0) {
                        foreach ($datosabono->result() as $dato) {
                            $Datos[] = array(
                                'key' => (int)$dato->idrec,
                                'usec' => $datacuenta->askidcentro,
                                'usep' => (int)$datacuenta->askidproyecto,
                                'itemline' => (int)$dato->itemline,
                                'titulo' => $dato->descrip,
                                'idcuenta' => $dato->idctcuenta,
                                'idtabla' => (int)$dato->idtabla,
                                'idauxi' => (int)$dato->idauxi,
                                'idcentro' => (int)$dato->idcentro,
                                'idproject' => (int)$dato->idproject,
                                'femision' => $dato->doc_emision,
                                'serien' => $dato->doc_serie.'-'.$dato->doc_numero,
                                'valor' => $dato->haber
                            );
                        }
                    }
                    $valorTotal = $this->contabilidad_model->getDataPartida(4, array(
                        'pnumero' => $datos['pnumero'],
                        'idcuenta' => $pextra[0],
                        'idtabla' => $pextra[1],
                        'idauxi' => $pextra[2]
                    ));
                    $Datos = array(
                        'datos' => $Datos,
                        'valorTotal' => number_format((float)$valorTotal, 2, '.', ','),
                        'totalLetras' => trim($this->valorEnLetras($valorTotal))
                    );
                } else {#   Lista
                    $documentos = $this->contabilidad_model->getDataAContable(2, array(
                        'pnumero' => $datos['pnumero'],
                        'idcuenta' => $pextra[0],
                        'idtabla' => (int)$pextra[1],
                        'idauxi' => (int)$pextra[2]
                    ));
                    if ($documentos->num_rows() > 0) {
                        foreach ($documentos->result() as $documento) {
                            $saldo = $this->getSTC($datacuenta->catgrupo, $documento->debe, $documento->haber);
                            if ((float)$saldo > 0.00) {
                                $Datos[] = array(
                                    'ID' => $documento->idrec,
                                    'Name' => $documento->doc_serie.'-'.$documento->doc_numero,
                                    'usec' => $datacuenta->askidcentro,
                                    'usep' => (int)$datacuenta->askidproyecto,
                                    'tipodoc' => $documento->doc_type,
                                    'serie' => $documento->doc_serie,
                                    'numero' => $documento->doc_numero,
                                    'femision' => $documento->doc_emision,
                                    'fvence' => $documento->doc_vence,
                                    'idgestor' => (int)$documento->doc_idworker,
                                    'femisionv' => date_create($documento->doc_emision)->format('d/m/Y'),
                                    'saldo' => (float)$saldo,
                                    'saldov' => number_format((float)$saldo, 2, '.', ','),
                                );
                            }
                        }
                    }
                }
            break;
            case 3:
            break;
            case 4:
            break;
            case 5:
            break;
        }
        return $Datos;
    }
    #   GET DATA
    public function getACDetalleData()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $OpcionAC = (int)$this->input->post('opcion');
            $OpcionMulti = (int)$this->input->post('OpcionMulti');
            switch ($OpcionAC) {
                case 0:
                    #   AUXLIARES - DOCUMENTOS - GESTORES
                    if ($OpcionMulti == 0) {
                        $Auxis = [];
                        $TDocs = [];
                        $Gestores = [];
                        #   AUXILIARES DE CUENTAS G2 - T2
                        $cauxis = $this->contabilidad_model->getACDetalleData(0);
                        if ($cauxis->num_rows() > 0) {
                            $cont = 0;
                            foreach ($cauxis->result() as $dato) {
                                if ($this->multiplesContabilidad(1, $dato->malos)) {
                                    $pauxi = explode(",", $dato->useauxi);
                                    //$auxis = $this->contabilidad_model->getCtasAuxs($pauxi);
                                    $auxis = $this->contabilidad_model->getACDetalleData(4, $pauxi);
                                    if ($auxis->num_rows() > 0) {
                                        foreach ($auxis->result() as $auxi) {
                                            $Auxis[] = array(
                                                'ID' => $cont,
                                                'idtabla' => (int)$pauxi[0],
                                                'idauxi' => (int)$auxi->id,
                                                'Name' => $auxi->descrip,
                                                'dias' => (int)$auxi->dias,
                                                'cuenta' => $dato->idctcuenta.' - '.$dato->descrip,
                                                'idcuenta' => $dato->idctcuenta,
                                                'ccentro' => $dato->askidcentro,
                                                'cproyecto' => (int)$dato->askidproyecto
                                            );
                                            $cont++;
                                        }
                                    }
                                }
                            }
                        }
                        #   TIPOS DE DOCUMENTOS VN - CO
                        $tdocumentos = $this->contabilidad_model->getACDetalleData(3);
                        if ($tdocumentos->num_rows() > 0) {
                            foreach ($tdocumentos->result() as $key => $tdocumento) {
                                $TDocs[] = array(
                                    'ID' => $tdocumento->id,
                                    'Name' => $tdocumento->descrip,
                                    'Tipo' => array_search($tdocumento->grupo, array('Compras' => 'CO', 'Ventas' => 'VN'))
                                );
                            }
                        }
                        #   GESTORES
                        $gestores = $this->contabilidad_model->getACDetalleData(5);
                        if ($gestores->num_rows() > 0) {
                            foreach ($gestores->result() as $gestor) {
                                $Gestores[] = array(
                                    'ID' => (int)$gestor->id,
                                    'Name' => $gestor->descrip
                                );
                            }
                        }

                        $datA[] = array(
                            'valido' => true,
                            'auxis' => $Auxis,
                            'tdocumentos' => $TDocs,
                            'gestores' => $Gestores
                        );
                    } else if ($OpcionMulti == 1) { #  CENTROS Y PROYECTOS
                        $Centros = [];
                        $Proyectos = [];
                        $hcentro = $this->input->post('centro');
                        $hproyecto = (int)$this->input->post('proyecto');
                        if (strlen(trim($hcentro)) > 0) {
                            $centros = $this->contabilidad_model->getACDetalleData(1, $hcentro);
                            if ($centros->num_rows() > 0) {
                                foreach ($centros->result() as $centro) {
                                    $Centros[] = array(
                                        'ID' => (int)$centro->idcentro,
                                        'Name' => $centro->descrip,
                                    );
                                }
                            }
                        }
                        if ($hproyecto == 1) {
                            $proyectos = $this->contabilidad_model->getACDetalleData(2);
                            if ($proyectos->num_rows() > 0) {
                                foreach ($proyectos->result() as $proyecto) {
                                    $Proyectos[] = array(
                                        'ID' => (int)$proyecto->Idproject,
                                        'Name' => $proyecto->descrip
                                    );
                                }
                            }
                        }
                        $datA[] = array(
                            'valido' => true,
                            'proyectos' => $Proyectos,
                            'centros' => $Centros
                        );
                    } else if ($OpcionMulti == 2) { #  SERIES - RESOLUCIONES = CUENTA AUXI TIPO DOC
                        $Series = [];
                        $NResoluciones = [];
                        $extra = [
                            'cuenta' => $this->input->post('cuenta'),
                            'idtabla' => $this->input->post('idtabla'),
                            'idauxi' => $this->input->post('auxi'),
                            'tipodoc' => $this->input->post('tipodoc')
                        ];
                        $series = $this->contabilidad_model->getACDetalleData(6, $extra);
                        if ($series->num_rows() > 0) {
                            foreach ($series->result() as $key => $serie) {
                                $Series[] = array(
                                    'ID' => $key,
                                    'Name' => $serie->descrip
                                );
                            }
                        }
                        $nresoluciones = $this->contabilidad_model->getACDetalleData(16, $extra);
                        if ($nresoluciones->num_rows() > 0) {
                            foreach ($nresoluciones->result() as $key => $dato) {
                                $NResoluciones[] = array(
                                    'ID' => $key,
                                    'Name' => $dato->nresolucion
                                );
                            }
                        }
                        $datA[] = array(
                            'valido' => true,
                            'series' => $Series,
                            'nresoluciones' => $NResoluciones
                        );
                    } else if ($OpcionMulti == 3) {#   GET REGISTROS DE UN DOCUMENTO
                        $pnumero = (int)$this->input->post('pnumero');
                        $ID = (int)$this->input->post('ID');
                        $Datos = (object)$this->conversionGetACDetalle(0, [
                            'opcion' => 1,
                            'pnumero' => $pnumero,
                            'controlnum' => $ID
                        ]);
                        $datA[] = array(
                            'valido' => true,
                            'datos' => $Datos->datos,
                            'quedan' => $Datos->quedan
                        );
                    } else {#   AUXILIARES - CENTROS - PROYECTOS DE CUENTA
                        $Centros = [];
                        $Proyectos = [];
                        $Auxiliares = [];
                        $hcentro = $this->input->post('centro');
                        $hproyecto = (int)$this->input->post('proyecto');
                        $hauxi = $this->input->post('useauxi');
                        if (strlen(trim($hcentro)) > 0) {
                            $centros = $this->contabilidad_model->getACDetalleData(1, $hcentro);
                            if ($centros->num_rows() > 0) {
                                foreach ($centros->result() as $centro) {
                                    $Centros[] = array(
                                        'ID' => (int)$centro->idcentro,
                                        'Name' => $centro->descrip,
                                    );
                                }
                            }
                        }
                        if ($hproyecto == 1) {
                            $proyectos = $this->contabilidad_model->getACDetalleData(2);
                            if ($proyectos->num_rows() > 0) {
                                foreach ($proyectos->result() as $proyecto) {
                                    $Proyectos[] = array(
                                        'ID' => (int)$proyecto->Idproject,
                                        'Name' => $proyecto->descrip
                                    );
                                }
                            }
                        }
                        if (strlen($hauxi) > 0) {
                            $auxiliares = $this->contabilidad_model->getACDetalleData(4, explode(",", $hauxi));
                            if ($auxiliares->num_rows() > 0) {
                                foreach ($auxiliares->result() as $auxiliar) {
                                    $Auxiliares[] = array(
                                        'ID' => (int)$auxiliar->id,
                                        'Name' => $auxiliar->descrip,
                                        'idtabla' => (int)explode(",", $hauxi)[0],
                                    );
                                }
                            }
                        }
                        $datA[] = array(
                            'valido' => true,
                            'proyectos' => $Proyectos,
                            'centros' => $Centros,
                            'auxiliares' => $Auxiliares
                        );
                    }
                break;
                case 1:
                break;
                case 2:
                break;
                case 3:
                break;
                case 4:
                break;
                case 5:
                break;
            }
            echo json_encode($datA);
        }
    }
    #   SET DETALLE
    public function setACDetalle()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $OpcionAC = (int)$this->input->post('opcion');
            $OpcionMulti = (int)$this->input->post('OpcionMulti');
            switch ($OpcionAC) {
                case 0:
                    if ($OpcionMulti == 0) {#   NUEVO DOCUMENTO
                        $pnumero = (int)$this->input->post('pnumero');
                        $cuenta = $this->input->post('cuenta');
                        $idtabla = (int)$this->input->post('idtabla');
                        $idauxi = (int)$this->input->post('idauxi');
                        $tipodoc = $this->input->post('tipodoc');
                        $serie = $this->input->post('serie');
                        $numero = $this->input->post('numero');
                        $extra = [
                            'cuenta' => $cuenta,
                            'idtabla' => $idtabla,
                            'idauxi' => $idauxi,
                            'tipodoc' => $tipodoc,
                            'serie' => $serie,
                            'numero' => $numero,
                        ];
                        $valnumero = $this->contabilidad_model->getACDetalleData(7, $extra);
                        if ($valnumero == 0) {
                            date_default_timezone_set('America/El_Salvador');
                            $data = array(
                                'pnumero' => $pnumero,
                                "itemline" => $this->contabilidad_model->getCountMov($pnumero) + 1,
                                'fecha' => $this->input->post('pfecha'),
                                'idctcuenta' => $cuenta,
                                'idtabla' => $idtabla,
                                'idauxi' => $idauxi,
                                'idcentro' => (int)$this->input->post('idcentro'),
                                'idproject' => (int)$this->input->post('idproyecto'),
                                'descrip' => trim($this->input->post('nombre')),
                                'doc_type' => $tipodoc,
                                'doc_serie' => $serie,
                                'doc_numero' => $numero,
                                'doc_emision' => $this->input->post('emision'),
                                'doc_vence' => $this->input->post('vence'),
                                'doc_idworker' => (int)$this->input->post('gestor'),
                                'doc_datos' => trim($this->input->post('nresolucion')),
                                'estatus' => 0,
                                'haber' => $this->input->post('valor'),
                                'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'ingresa' => date_create()->format('Y-m-d H:i:s'),
                            );
                            if ($ID = $this->contabilidad_model->setEPDetalle($data)) {

                                $Datos = (object)$this->conversionGetACDetalle(0, [
                                    'opcion' => 0,
                                    'pnumero' => $pnumero,
                                ]);

                                $datA[] = array(
                                    'valido' => true, 
                                    'datos' => $Datos->datos,
                                    'cuadre' => (float)$Datos->cuadre,
                                    'ID' => (int)$ID,
                                );

                            } else $datA[] = array('valido' => false, 'tipo' => 0);//*/
                        } else $datA[] = array('valido' => false, 'tipo' => 1);
                    } else if ($OpcionMulti == 1) {# 1 DESTINO / IMPUESTO
                        $pnumero = (int)$this->input->post('pnumero');
                        $cuenta = $this->input->post('cuenta');
                        $idtabla = (int)$this->input->post('idtabla');
                        $idauxi = (int)$this->input->post('idauxi');
                        $controlnum = $this->input->post('controlnum');
                        date_default_timezone_set('America/El_Salvador');
                        $data = array(
                            'pnumero' => $pnumero,
                            "itemline" => $this->contabilidad_model->getCountMov($pnumero) + 1,
                            'fecha' => $this->input->post('pfecha'),
                            'idctcuenta' => $cuenta,
                            'idtabla' => $idtabla,
                            'idauxi' => $idauxi,
                            'idcentro' => (int)$this->input->post('idcentro'),
                            'idproject' => (int)$this->input->post('idproyecto'),
                            'descrip' => trim($this->input->post('nombre')),
                            'doc_controlnum' => $controlnum,
                            'estatus' => 0,
                            'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                        );
                        $impuesto = (int)$this->input->post('impuesto');
                        if ($impuesto == 1) {
                            $datacuenta = $this->contabilidad_model->getCuenta3($cuenta);
                            switch ($datacuenta->catgrupo) {
                                case 1:
                                case 4:
                                    $valor = 'debe';
                                break;
                                case 2:
                                case 3:
                                case 5:
                                    $valor = 'haber';
                                break;
                                default:
                                    $valor = 'debe';
                                break;
                            }
                        } else $valor = 'debe';
                        $data[$valor] = $this->input->post('valor');
                        if ($this->contabilidad_model->setEPDetalle($data)) {
                            $Datos = (object)$this->conversionGetACDetalle(0, [
                                'opcion' => 0,
                                'pnumero' => $pnumero,
                            ]);

                            $datA[] = array(
                                'valido' => true, 
                                'datos' => $Datos->datos,
                                'cuadre' => $Datos->cuadre,
                                'ID' => (int)$controlnum,
                            );

                        } else $datA[] = array('valido' => false, 'tipo' => 0);
                    } else {# 2 COPIA DE ESTRUCTURA
                        $pnumero = (int)$this->input->post('pnumero');
                        $controlnumCopy = $this->input->post('controlnumCopy');
                        $controlnum = $this->input->post('controlnum');
                        $estructura = $this->contabilidad_model->getACDetalleData(12, $controlnumCopy);
                        date_default_timezone_set('America/El_Salvador');
                        $conteo = 0;
                        foreach ($estructura->result() as $hijo) {
                            $data = array(
                                'pnumero' => $pnumero,
                                "itemline" => $this->contabilidad_model->getCountMov($pnumero) + 1,
                                'fecha' => $this->input->post('pfecha'),
                                'idctcuenta' => $hijo->idctcuenta,
                                'idtabla' => $hijo->idtabla,
                                'idauxi' => $hijo->idauxi,
                                'idcentro' => $hijo->idcentro,
                                'idproject' => $hijo->idproject,
                                'descrip' => $hijo->descrip,
                                'doc_controlnum' => $controlnum,
                                'estatus' => 0,
                                'debe' => 0,
                                'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'ingresa' => date_create()->format('Y-m-d H:i:s'),
                            );
                            if (!$this->contabilidad_model->setEPDetalle($data)) $conteo++;
                        }
                        #-
                        $Datos = (object)$this->conversionGetACDetalle(0, [
                            'opcion' => 0,
                            'pnumero' => $pnumero,
                        ]);

                        $datA[] = array(
                            'valido' => true, 
                            'datos' => $Datos->datos,
                            'cuadre' => (float)$Datos->cuadre,
                            'ID' => (int)$controlnum,
                            'conteo' => (int)$conteo
                        );
                    }
                break;
                case 1:
                    $pnumero = (int)$this->input->post('pnumero');
                    $extra = $this->input->post('extra');
                    $pextra = explode("-", $extra);

                    $cuenta = $pextra[0];
                    $idtabla = (int)$pextra[1];
                    $idauxi = (int)$pextra[2];
                    date_default_timezone_set('America/El_Salvador');
                    $data = array(
                        'pnumero' => $pnumero,
                        "itemline" => $this->contabilidad_model->getCountMov($pnumero) + 1,
                        'fecha' => $this->input->post('pfecha'),
                        'idctcuenta' => $cuenta,
                        'idtabla' => $idtabla,
                        'idauxi' => $idauxi,
                        'idcentro' => (int)$this->input->post('idcentro'),
                        'idproject' => (int)$this->input->post('idproyecto'),
                        'descrip' => trim($this->input->post('nombre')),
                        'doc_type' => $this->input->post('tipodoc'),
                        'doc_serie' => $this->input->post('serie'),
                        'doc_numero' => $this->input->post('numero'),
                        'doc_emision' => $this->input->post('femision'),
                        'doc_vence' => $this->input->post('fvence'),
                        'doc_idworker' => (int)$this->input->post('idgestor'),
                        'doc_controlnum' => "Abono",
                        'estatus' => 0,
                        'debe' => $this->input->post('valor'),
                        'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($ID = $this->contabilidad_model->setEPDetalle($data)) {
                        $Datos = $this->conversionGetACDetalle(1, array(
                            'opcion' => 0,
                            'extra' => $pextra,
                            'pnumero' => $pnumero,
                        ));
                        $Documentos = $this->conversionGetACDetalle(1, array(
                            'opcion' => 1,
                            'extra' => $pextra,
                            'pnumero' => $pnumero,
                        ));
                        $valorTotal = $this->contabilidad_model->getDataPartida(1, array(
                            'pnumero' => $pnumero,
                            'idcuenta' => $cuenta,
                            'idtabla' => $idtabla,
                            'idauxi' => $idauxi
                        ));
                        $totalLetras = trim($this->valorEnLetras($valorTotal));
                        
                        $datA[] = array(
                            'valido' => true,
                            'datos' => $Datos,
                            'documentos' => $Documentos,
                            'total' => number_format((float)$valorTotal, 2, '.', ','),
                            'totalLetras' => $totalLetras
                        );

                    } else $datA[] = array('valido' => false, 'tipo' => 0);//*/
                break;
                case 2:
                    $pnumero = (int)$this->input->post('pnumero');
                    $extra = $this->input->post('extra');
                    $pextra = explode("-", $extra);

                    $cuenta = $pextra[0];
                    $idtabla = (int)$pextra[1];
                    $idauxi = (int)$pextra[2];
                    date_default_timezone_set('America/El_Salvador');
                    $data = array(
                        'pnumero' => $pnumero,
                        "itemline" => $this->contabilidad_model->getCountMov($pnumero) + 1,
                        'fecha' => $this->input->post('pfecha'),
                        'idctcuenta' => $cuenta,
                        'idtabla' => $idtabla,
                        'idauxi' => $idauxi,
                        'idcentro' => (int)$this->input->post('idcentro'),
                        'idproject' => (int)$this->input->post('idproyecto'),
                        'descrip' => trim($this->input->post('nombre')),
                        'doc_type' => $this->input->post('tipodoc'),
                        'doc_serie' => $this->input->post('serie'),
                        'doc_numero' => $this->input->post('numero'),
                        'doc_emision' => $this->input->post('femision'),
                        'doc_vence' => $this->input->post('fvence'),
                        'doc_idworker' => (int)$this->input->post('idgestor'),
                        'doc_controlnum' => "Abono",
                        'estatus' => 0,
                        'haber' => $this->input->post('valor'),
                        'chg_log' => date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Inserción;",
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($ID = $this->contabilidad_model->setEPDetalle($data)) {
                        $Datos = (object)$this->conversionGetACDetalle(2, array(
                            'opcion' => 0,
                            'extra' => $pextra,
                            'pnumero' => $pnumero,
                        ));
                        $Documentos = $this->conversionGetACDetalle(2, array(
                            'opcion' => 1,
                            'extra' => $pextra,
                            'pnumero' => $pnumero,
                        ));
                        $datA[] = array(
                            'valido' => true,
                            'datos' => $Datos->datos,
                            'documentos' => $Documentos,
                            'total' => $Datos->valorTotal,
                            'totalLetras' => $Datos->totalLetras
                        );

                    } else $datA[] = array('valido' => false, 'tipo' => 0);//*/
                break;
                case 3:
                break;
                case 4:
                break;
                case 5:
                break;
            }
            echo json_encode($datA);
        }
    }
    #   UPDATE DETALLE
    public function updateACDetalle()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $OpcionAC = (int)$this->input->post('opcion');
            $OpcionMulti = (int)$this->input->post('OpcionMulti');
            switch ($OpcionAC) {
                case 0:
                    $pnumero = (int)$this->input->post('pnumero');
                    $cuenta = $this->input->post('cuenta');
                    $ID = (int)$this->input->post('ID');
                    $controlnum = (int)$this->input->post('controlnum');
                    if ($OpcionMulti == 0) {#    UPDATE COMPRA
                        $idtabla = (int)$this->input->post('idtabla');
                        $idauxi = (int)$this->input->post('idauxi');
                        $tipodoc = $this->input->post('tipodoc');
                        $serie = $this->input->post('serie');
                        $numero = $this->input->post('numero');
                        $extra = [
                            'cuenta' => $cuenta,
                            'idtabla' => $idtabla,
                            'idauxi' => $idauxi,
                            'tipodoc' => $tipodoc,
                            'serie' => $serie,
                            'numero' => $numero,
                            'ID' => $ID
                        ];
                        $valnumero = $this->contabilidad_model->getACDetalleData(7, $extra);
                        if ($valnumero == 0) {
                            date_default_timezone_set('America/El_Salvador');
                            $data = array(
                                'idctcuenta' => $cuenta,
                                'idtabla' => $idtabla,
                                'idauxi' => $idauxi,
                                'idcentro' => (int)$this->input->post('idcentro'),
                                'idproject' => (int)$this->input->post('idproyecto'),
                                'descrip' => trim($this->input->post('nombre')),
                                'doc_type' => trim($tipodoc),
                                'doc_serie' => trim($serie),
                                'doc_numero' => trim($numero),
                                'doc_emision' => $this->input->post('emision'),
                                'doc_vence' => $this->input->post('vence'),
                                'doc_idworker' => $this->input->post('gestor'),
                                'doc_datos' => trim($this->input->post('nresolucion')),
                                'haber' => $this->input->post('valor'),
                                'chg_log' => $this->contabilidad_model->getHistoricoEPD($ID).date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Actualización;",
                                'whodidit' => $this->session->userdata('iduser'),
                                'modifica' => date_create()->format('Y-m-d H:i:s'),
                            );
                            if ($this->contabilidad_model->updateEPDetalle($data, $ID)) {
                                $Datos = (object)$this->conversionGetACDetalle(0, [
                                    'opcion' => 0,
                                    'pnumero' => $pnumero,
                                ]);

                                $datA[] = array(
                                    'valido' => true, 
                                    'datos' => $Datos->datos,
                                    'cuadre' => (float)$Datos->cuadre,
                                    'ID' => (int)$ID,
                                );


                            } else $datA[] = array('valido' => false, 'tipo' => 0);
                        } else $datA[] = array('valido' => false, 'tipo' => 1);
                    } else if ($OpcionMulti == 1) {#     UPDATE DESTION / IMPUESTO
                        date_default_timezone_set('America/El_Salvador');
                        $data = array(
                            'descrip' => $this->input->post('nombre'),
                            'idtabla' => (int)$this->input->post('idtabla'),
                            'idauxi' => (int)$this->input->post('idauxi'),
                            'idcentro' => (int)$this->input->post('idcentro'),
                            'idproject' => (int)$this->input->post('idproyecto'),
                            //'debe' => $this->input->post('valor'),
                            'chg_log' => $this->contabilidad_model->getHistoricoEPD($ID).date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Actualización;",
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        $impuesto = (int)$this->input->post('impuesto');
                        if ($impuesto == 1) {
                            $datacuenta = $this->contabilidad_model->getCuenta3($cuenta);
                            switch ($datacuenta->catgrupo) {
                                case 1:
                                case 4:
                                    $valor = 'debe';
                                break;
                                case 2:
                                case 3:
                                case 5:
                                    $valor = 'haber';
                                break;
                                default:
                                    $valor = 'debe';
                                break;
                            }
                        } else $valor = 'debe';
                        $data[$valor] = $this->input->post('valor');
                        if ($this->contabilidad_model->updateEPDetalle($data, $ID)) {
                            $Datos = (object)$this->conversionGetACDetalle(0, [
                                'opcion' => 0,
                                'pnumero' => $pnumero,
                            ]);

                            $datA[] = array(
                                'valido' => true, 
                                'datos' => $Datos->datos,
                                'cuadre' => (float)$Datos->cuadre,
                                'ID' => (int)$controlnum,
                            );
                        } else $datA[] = array('valido' => false, 'tipo' => 0);
                    } else {#   ANULAR
                        $IDTpartida = (int)$this->input->post('IDTP');
                        $valido = true ;
                        $primero = ($this->input->post("primer")) ? true : false;
                        if (!$primero) $valido = true;
                        else {
                            /*$hijos = $this->contabilidad_model->getACDetalleData(9, array(
                                'pnumero' => $pnumero,
                                'controlnum' => $ID
                            ));
                            $valido = ($hijos->num_rows() == 0) ? true : false;//*/
                            $valido = true;
                            $estructura = $this->contabilidad_model->getACDetalleData(12, $ID);
                            if ($estructura->num_rows() > 0) {
                                foreach ($estructura->result() as $dato) {
                                    if (!$this->contabilidad_model->byeEPDetalle($dato->idrec, $IDTpartida)) $valido = false;
                                }
                            }
                        }
                        if ($valido) {
                            if ($this->contabilidad_model->byeEPDetalle($ID, $IDTpartida)) {
                                $Datos = (object)$this->conversionGetACDetalle(0, [
                                    'opcion' => 0,
                                    'pnumero' => $pnumero,
                                ]);
                                $datA[] = array(
                                    'valido' => true, 
                                    'datos' => $Datos->datos,
                                    'cuadre' => (float)$Datos->cuadre,
                                    'ID' => (int)$controlnum,
                                );
                            } else $datA[] = array('valido' => false, 'tipo' => 0);
                        } else $datA[] = array('valido' => false, 'tipo' => -1);
                    }
                break;
                case 1:
                    $pnumero = (int)$this->input->post('pnumero');
                    $ID = (int)$this->input->post('ID');
                    $extra = $this->input->post('extra');
                    $pextra = explode("-", $extra);

                    $cuenta = $pextra[0];
                    $idtabla = (int)$pextra[1];
                    $idauxi = (int)$pextra[2];

                    if ($OpcionMulti == 0) {#   EDITAR DESCRIPCION
                        date_default_timezone_set('America/El_Salvador');
                        $data = array(
                            'descrip' => $this->input->post('nombre'),
                            'chg_log' => $this->contabilidad_model->getHistoricoEPD($ID).date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Actualización;",
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        if ($this->contabilidad_model->updateEPDetalle($data, $ID)) {
                            $Datos = $this->conversionGetACDetalle(1, array(
                                'opcion' => 0,
                                'extra' => $pextra,
                                'pnumero' => $pnumero,
                            ));
                            $datA[] = array('valido' => true, 'datos' => $Datos);
                        } else $datA[] = array('valido' => false);
                    } else {#   ANULAR
                        $IDTpartida = (int)$this->input->post('IDTP');
                        if ($this->contabilidad_model->byeEPDetalle($ID, $IDTpartida)){

                            $Datos = $this->conversionGetACDetalle(1, array(
                                'opcion' => 0,
                                'extra' => $pextra,
                                'pnumero' => $pnumero,
                            ));
                            $Documentos = $this->conversionGetACDetalle(1, array(
                                'opcion' => 1,
                                'extra' => $pextra,
                                'pnumero' => $pnumero,
                            ));
                            $valorTotal = $this->contabilidad_model->getDataPartida(1, array(
                                'pnumero' => $pnumero,
                                'idcuenta' => $cuenta,
                                'idtabla' => $idtabla,
                                'idauxi' => $idauxi
                            ));
                            $totalLetras = trim($this->valorEnLetras($valorTotal));
                            $datA[] = array(
                                'valido' => true,
                                'datos' => $Datos,
                                'documentos' => $Documentos,
                                'total' => number_format((float)$valorTotal, 2, '.', ','),
                                'totalLetras' => $totalLetras
                            );
                        } else $datA[] = array('valido' => false, 'tipo' => 0);
                    }
                break;
                case 2:
                    $pnumero = (int)$this->input->post('pnumero');
                    $ID = (int)$this->input->post('ID');
                    $extra = $this->input->post('extra');
                    $pextra = explode("-", $extra);

                    $cuenta = $pextra[0];
                    $idtabla = (int)$pextra[1];
                    $idauxi = (int)$pextra[2];
                    if ($OpcionMulti == 0) {#   EDITAR DESCRIPCION
                        date_default_timezone_set('America/El_Salvador');
                        $data = array(
                            'descrip' => $this->input->post('nombre'),
                            'chg_log' => $this->contabilidad_model->getHistoricoEPD($ID).date_create()->format('Y-m-d H:i:s').",".$this->session->userdata('iduser').",Actualización;",
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        if ($this->contabilidad_model->updateEPDetalle($data, $ID)) {
                            $Datos = (object)$this->conversionGetACDetalle(2, array(
                                'opcion' => 0,
                                'extra' => $pextra,
                                'pnumero' => $pnumero,
                            ));
                            $datA[] = array(
                                'valido' => true,
                                'datos' => $Datos->datos,
                            );
                        } else $datA[] = array('valido' => false);
                    } else {#   ANULAR
                        $IDTpartida = (int)$this->input->post('IDTP');
                        if ($this->contabilidad_model->byeEPDetalle($ID, $IDTpartida)){
                            $Datos = (object)$this->conversionGetACDetalle(2, array(
                                'opcion' => 0,
                                'extra' => $pextra,
                                'pnumero' => $pnumero,
                            ));
                            $Documentos = $this->conversionGetACDetalle(2, array(
                                'opcion' => 1,
                                'extra' => $pextra,
                                'pnumero' => $pnumero,
                            ));
                            $datA[] = array(
                                'valido' => true,
                                'datos' => $Datos->datos,
                                'documentos' => $Documentos,
                                'total' => $Datos->valorTotal,
                                'totalLetras' => $Datos->totalLetras
                            );
                        } else $datA[] = array('valido' => false, 'tipo' => 0);
                    }
                break;
            }
            echo json_encode($datA);
        }
    }
    #------------------------------------------------------  REPORTES
    public function RAContable($Opcion = null, $OpcionMulti = null, $pnumero = null, $extra = null)
    {
        if($this->validatePermiso()) {
            if ($Opcion != null && $OpcionMulti != null && $pnumero != null && $extra != null) {
                if (is_numeric($Opcion) && is_numeric($OpcionMulti) && is_numeric($pnumero)) {
                    $this->load->model('contabilidad_model');
                    switch ($Opcion) {
                        case 0:
                            $send = [
                                'pnumero' => $pnumero,
                                'extra' => $extra
                            ];
                            $this->RGAContable($OpcionMulti, $send);
                        break;
                        default:
                            show_404();
                        break;
                    }
                } else echo "<br><h1>Parámetros Incorrectos</h1>";
            } else echo "<br><h1>Faltan Parámetros</h1>";
        }
    }
    private function RGAContable($opc, $extra)
    {
        switch ($opc) {
            case 0:
                $this->load->library('Pdfconta');
                $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Quedan');
                $pdf->SetSubject('Reporte de Quedan');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);

                $pdf->SetMargins(5, 5, 5, 0);// left top right
                //$pdf->SetFont('helvetica', '', 9);
                $pdf->SetFont('helvetica', '', 7, '', true);
                $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
                
                if ($extra['extra'] == '0') {
                    $datos = $this->contabilidad_model->getDataRAContable(0, $extra['pnumero']);
                    $padres = $this->contabilidad_model->getACDetalle(0, $extra['pnumero']);
                    $IDControlnums = [];
                    foreach ($padres->result() as $padre) {
                        $IDControlnums[] = '(a.idrec = '.$padre->idrec.')';
                    }
                } else {
                    $IDControlnums = explode('_', $extra['extra']);
                    foreach ($IDControlnums as $key => $valor) {
                        $IDControlnums[$key] = '(a.idrec = '.$valor.')';
                    }
                    $datos = $this->contabilidad_model->getDataRAContable(1, array(
                        'pnumero' => $extra['pnumero'],
                        'IDS' => $IDControlnums
                    ));
                }
                $partida = $this->contabilidad_model->getDataPartida(0, $extra['pnumero']);
                $pfecha = explode("-", $partida->fecha);
                $departamento = trim($this->contabilidad_model->getDataRAContable(3, 7));
                switch($pfecha[1]){
                    case 1:
                        $mes = "ENERO";
                        break;
                    case 2:
                        $mes = "FEBRERO";
                        break;
                    case 3:
                        $mes = "MARZO";
                        break;
                    case 4:
                        $mes = "ABRIL";
                        break;
                    case 5:
                        $mes = "MAYO";
                        break;
                    case 6:
                        $mes = "JUNIO";
                        break;
                    case 7:
                        $mes = "JULIO";
                        break;
                    case 8:
                        $mes = "AGOSTO";
                        break;
                    case 9:
                        $mes = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes = "OCTUBRE";
                        break;
                    case 11:
                        $mes = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes = "DICIEMBRE";
                        break;
                    default:
                        $mes="";
                    break;
                }
                $autor = $this->contabilidad_model->getAutor($partida->whodidit);

                $estructura = [];
                $imagen = $this->session->userdata('nameImgEmpresa');
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $proveedor = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                        $informacion = [
                            trim($this->contabilidad_model->getDataRAContable(3, 1)),
                            trim($this->contabilidad_model->getDataRAContable(3, 6)),
                            trim('Tel. '.$this->contabilidad_model->getDataRAContable(3, 9)),
                        ];

                        $documentos = $this->contabilidad_model->getDataRAContable(4, array(
                            'pnumero' => $extra['pnumero'],
                            'idtabla' => $dato->idtabla,
                            'idauxi' => $dato->idauxi,
                            'IDS' => $IDControlnums
                        ));
                        $docs = '';
                        $total = 0;
                        $titulo = '
                            <tr>
                                <td style="width: 40%; border-bottom: 1px solid black; text-align: left; font-size: 12px;">A Favor de</td>
                                <td style="width: 25%; border-bottom: 1px solid black; text-align: left; font-size: 12px;">Tipo de Documento</td>
                                <td style="width: 20%; border-bottom: 1px solid black; text-align: left; font-size: 12px;">Número</td>
                                <td style="width: 15%; border-bottom: 1px solid black; text-align: left; font-size: 12px;">Valor</td>
                            </tr>
                        ';
                        $documentosTotal = $documentos->num_rows();
                        $valorM = 1;
                        if ($documentosTotal > $valorM){
                            $titulo = '
                            <tr>
                                <td style="width: 30%; border-bottom: 1px solid black; text-align: left; font-size: 12px;">A Favor de</td>
                                <td style="width: 10%; border-bottom: 1px solid black; text-align: left; font-size: 12px;">Referencia</td>
                                <td style="width: 25%; border-bottom: 1px solid black; text-align: left; font-size: 12px;">Tipo de Documento</td>
                                <td style="width: 20%; border-bottom: 1px solid black; text-align: left; font-size: 12px;">Número</td>
                                <td style="width: 15%; border-bottom: 1px solid black; text-align: left; font-size: 12px;">Valor</td>
                            </tr>
                        ';
                        }
                        foreach ($documentos->result() as $documento) {
                            $total += $documento->haber;
                            $docs .= '
                                <tr>
                                    <td style="width: '.(($documentosTotal > $valorM) ? '30' : '40').'%; text-align: left; font-size: 11px;">'.$proveedor->descrip.'</td>
                                    '.trim((($documentosTotal > $valorM) ? ('<td style="width: 10%; text-align: center; font-size: 11px;">'.$documento->idrec.'</td>') : '' )).'
                                    <td style="width: 25%; text-align: left; font-size: 12px; ">'.$documento->doc_type.'</td>
                                    <td style="width: 20%; text-align: left; font-size: 12px; ">'.implode('-', [$documento->doc_serie, $documento->doc_numero]).'</td>
                                    <td style="width: 15%; text-align: right; font-size: 12px; ">'.$this->session->userdata('simboloMoneda').' '.number_format((float)$documento->haber, 2, '.', ',').'</td>
                                </tr>
                            ';
                        }
                        $docs.= '
                            <tr><td style="width: 100%; font-size: 5px;">&nbsp;</td></tr>
                            <tr>
                                <td style="width: 83%; text-align: right; font-size: 12px; font-weight: bold;">Total a Pagar&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                <td style="width: 2%; text-align: left; font-size: 12px; font-weight: bold;">'.$this->session->userdata('simboloMoneda').'</td>
                                <td style="width: 15%; text-align: right; font-size: 12px; font-weight: bold; border-bottom: 1px solid black;">'.number_format((float)$total, 2, '.', ',').'</td>
                            </tr>
                        ';
                        $html = '
                            <table style="width: 100%;">
                                <tr>
                                    <td style="width: 30%;"><img style="border: 0.5px solid black;" src="'.$imagen.'"> </td>
                                    <td style="width: 60%; font-size: 12px; text-align: left;">'.trim(implode("<br>", $informacion)).'</td>
                                    <td style="width: 10%; font-size: 12px; text-align: center; line-height: 28px;">'.trim(implode("<br>", [
                                        '<b>QUEDAN</b>',
                                        'N°<span style="text-decoration: underline;">'.$dato->idrec.'</span>'
                                    ])).'</td>
                                </tr>
                                <tr><td style="width: 100%; font-size: 15px;">&nbsp;</td></tr>
                                '.trim($titulo).'
                                <tr><td style="width: 100%; font-size: 10px;">&nbsp;</td></tr>
                                '.trim($docs).'
                                <tr><td style="width: 100%; font-size: 10px;">&nbsp;</td></tr>
                                <tr>
                                    <td style="width: 60%; text-align: left; font-size: 12px; "></td>
                                    <td style="width: 40%; text-align: right; font-size: 12px;">'.$departamento.', '.$pfecha[2].' de '.ucfirst(strtolower($mes)).' de '.$pfecha[0].'</td>
                                </tr>
                                <tr><td style="width: 100%; font-size: 15px;">&nbsp;</td></tr>
                                <tr>
                                    <td style="width: 70%; text-align: right; font-size: 12px;">F.</td>
                                    <td style="width: 30%; border-bottom: 1px solid black; font-size: 12px;"></td>
                                </tr>
                            </table>
                        ';
                        $separador = '
                            <table style="width: 100%;">
                                <tr><td style="width: 100%; font-size: 5px; border-bottom: 1px dashed black; ">&nbsp;</td></tr>
                                <tr><td style="width: 100%; font-size: 10px;">&nbsp;</td></tr>
                            </table>
                        ';
                        $primero = '
                            <table style="width: 100%;">
                                <tr>
                                    <td style="width: 70%; text-align: left; font-size: 11px;">Original - Proveedor</td>
                                    <td style="width: 30%;  font-size: 12px;">('.$autor.')</td>
                                </tr>
                            </table>
                        ';
                        $segundo = '
                            <table style="width: 100%;">
                                <tr>
                                    <td style="width: 70%; text-align: left; font-size: 11px;">Copia - Contabiliad</td>
                                    <td style="width: 30%;  font-size: 12px;">('.$autor.')</td>
                                </tr>
                            </table>
                        ';
                        $html .= $primero.trim($separador).$html.$segundo.trim($separador);
                        $estructura[] = $html;
                    }
                    $estructura = implode('<br pagebreak="true"/>', $estructura);
                }
                $pdf->writeHTML($estructura);
                $pdf->lastPage();
                $pdf->Output();
            break;
        }
    }

    #------------------------------------------------------     FIN ASISTENTE CONTABLE DETALLE
    #------------------------------------------------------     FIN ASISTENTE CONTABLE -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     EXPORTAR DE COMPRAS ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function indexECompras($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $this->load->model('contabilidad_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->data['cuentasCxCP'] = $this->global_model->getOpcionesVariable('conta_exp');//$this->converECompras(1);
            $this->data['fecha'] = date_create()->format('Y-m-\0\1');
            $this->load->view("mantenimiento_CExportar_Compras", $this->data);//*/
        }
    }
    #    NUEVO EXPORT COMPRAS
    public function getExportCompras()
    {
        if ($this->validatePermiso()) {
            $this->load->model('contabilidad_model');

            $fechai   = $this->input->post('fi');
            $fechaf   = $this->input->post('ff');
            $iExport  = $this->input->post('exp');
            $iPartida = $this->input->post('pta');

            $Data = [];
            $datos    = $this->contabilidad_model->getListadoPartidas($iPartida, $fechai, $fechaf);
            $opciones = $this->contabilidad_model->getListadoFuncionesExport($iExport);

            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $info) {
                    
                    $valGravadas = 0; $fovial=0; $cotranss=0; $iva=0; $percepcion=0;
                    if ($opciones->num_rows() > 0) {
                        foreach ($opciones->result() as $opc) {
                            
                            $opcValue = $this->contabilidad_model->multiFuncionesExport($info->pnumero, $opc->funcion, $opc->dh, $opc->idcuenta, $opc->idauxi);
                            switch ($opc->funcion) {
                                case 'getDatosCompra':
                                    //$this->db_b->select("b.doc_emision, b.doc_serie, b.doc_numero, c.descrip, c.nrc");
                                    $doc = $opcValue;
                                    break;
                                case 'getComprasGravadas':
                                    $valGravadas = $valGravadas + $opcValue;
                                    break;
                                case 'getTotalCuenta':
                                    if($opc->descrip == 'FOVIAL'){
                                        $fovial = $opcValue;
                                    }else if($opc->descrip == 'COTRANS'){
                                        $cotranss = $opcValue;
                                    }
                                    break;
                                case 'getIvaCompras':
                                    if($opc->descrip == 'IVA'){
                                        $iva = $opcValue;
                                    }else if($opc->descrip == 'Percepción'){
                                        $percepcion = ($opcValue * -1);
                                    }
                                    break;
                                default:
                                    break;
                            }
                        }
                    }

                    
                    $Data[] = array(
                        'pnumero' => $info->pnumero * 1,
                        'Fecha' => ( $doc != false ) ? $doc->doc_emision : '',
                        'Serie' => ( $doc != false ) ? $doc->doc_serie : '',
                        'Numero' => ( $doc != false ) ? $doc->doc_numero : '',
                        'Nombre_Contribuyente' => ( $doc != false ) ? $doc->descrip : '',
                        'NRC' => ( $doc != false ) ? $doc->nrc : '',
                        'Gravadas' => number_format($valGravadas, 4, '.', '') * 1,
                        'Fovial' => number_format($fovial, 4, '.', '') * 1,
                        'Cotranss' => number_format($cotranss, 4, '.', '') * 1,
                        'IVA' => number_format($iva, 4, '.', '') * 1,
                        'Percepcion' => number_format($percepcion, 4, '.', '') * 1,
                        'Total' => number_format((number_format($valGravadas, 4, '.', '') + number_format($fovial, 4, '.', '') + number_format($cotranss, 4, '.', '') + number_format($iva, 4, '.', '') + number_format($percepcion, 4, '.', '') + number_format($percepcion, 4, '.', '')), 2, '.', '') * 1,
                    );
                }
            }

            echo json_encode($Data);
        }
    }
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #    MULTI OPCIONES
    public function multiECompras()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $opcion = (int)$this->input->post('opcion');
            switch ($opcion) {
                /*case 2:#    GET CUENTAS DE IMPUESTO
                    $Datos = [];
                    $datos = $this->contabilidad_model->multiECompras(2);
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $Datos[] = array(
                                'ID' => $dato->idctcuenta,
                                'Name' => $dato->descrip
                            );
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                break;//*/
                case 3:#    CONSULTAR COMPRAS
                    $fi = $this->input->post('fi');
                    $ff = $this->input->post('ff');
                    $cta = $this->input->post('cta');
                    $ctr = $this->input->post('ctr');
                    $ctiva = $this->input->post('ctiva');
                    $Datos = $this->converECompras(2, ['fi' => $fi, 'ff' => $ff, 'cta' => $cta, 'ctr' => $ctr, 'ctiva' => $ctiva]);
                    $datA[] = array('valido' => true, 'datos' => $Datos->datos, 'im' => $Datos->im);
                break;
                case 4:#    EXPORTAR COMPRAS
                    $this->load->helper('download');
                    //$data = str_replace("\n\r", "\r\n", $this->input->post('rcompras'));//implode("\r\n", $Datos->datos);
                    $data = implode("\r\n", explode("||", $this->input->post('rcompras')));//implode("\r\n", $Datos->datos);
                    $name = 'Export_Compras.txt';
                    //echo $data;
                    force_download($name, $data, TRUE);
                    die();
                break;
                default:
                    $datA[] = array('valido' => false);
                break;
            }
            echo json_encode($datA);
        }
    }
    private function converECompras($opc, $extra = null)
    {
        $Datos = [];
        switch ($opc) {
            case 1:
                $datos = $this->contabilidad_model->multiECompras(1);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $Datos[] = array(
                            'ID' => $dato->idctcuenta,
                            'Name' => $dato->idctcuenta.'-'.$dato->descrip
                        );
                    }
                }
                return $Datos;
            break;
            case 2:#    GET COMPRAS
                $fi = $extra['fi'];
                $ff = $extra['ff'];
                $cuenta = $extra['cta'];
                $ctr = $extra['ctr'];
                $ctiva = $extra['ctiva'];
                $datos = $this->contabilidad_model->multiECompras(3, ['fi' => $fi, 'ff' => $ff, 'cta' => $cuenta]);
                $im = [];
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $pr = 0.01; $piva = 0.13;
                        $porcentajes = 1 + (($dato->idtipo == 3) ? ($pr + $piva) : $piva);
                        $gtempo = $dato->vtotal / $porcentajes;
                        $imr = $gtempo * $pr;
                        $imiva = $gtempo * $piva;
                        if (($dato->idtipo != 3) || ($dato->idtipo == 3 && $gtempo < 100)) {
                            $g = $dato->vtotal / (1 + $piva);
                            $imr = 0;
                            $imiva = $g * $piva;
                        }
                        $Datos[] = array(
                            'npartida' => (int)$dato->pnumero,
                            'idproveedor' => $dato->idauxi,
                            'proveedor' => $dato->proveedor,
                            'nrc' => $dato->nrc,
                            'nit' => $dato->nit,
                            'direccion' => $dato->direccion,
                            'municipio' => $dato->municipio,
                            'departamento' => $dato->departamento,
                            'giro' => $dato->giro,
                            'xpos' => $dato->xposcentro,
                            'fecha' => $dato->doc_emision,
                            'serie' => $dato->doc_serie,
                            'numero' => $dato->doc_numero,
                            'compra' => (float)($dato->vtotal - $imr - $imiva),
                            'retencion' => (float)$imr,
                            'iva' => (float)$imiva,
                            'vtotal' => (float)$dato->vtotal
                        );
                    }
                }
                $Datos = (object)array('datos' => $Datos, 'im' => $im);
                return $Datos;
            break;
        }
    }
    #------------------------------------------------------     FIN EXPORTAR DE COMPRAS ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     ANALISIS DE CARTERA ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function AnalizaCxC($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->load->view("mantenimiento_AnalisisCxC", $this->data);//*/
        }
    }
    #   LOAD CUENTAS
    public function loadCxC()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $datos = $this->contabilidad_model->getCtasA();
                $Datos = null;
                if ($datos) {
                    if ($datos->num_rows() > 0) {
                        foreach ($datos->result() as $dato) {
                            $Datos[] = array(
                                'ID' => $dato->idctcuenta,
                                'Name' => $dato->descrip,
                                'grupo' => $dato->catgrupo,
                            );//*/
                        }
                    }
                    $datA[] = array(
                        'valido' => true,
                        'datos' => $Datos,
                    );
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   LOAD LOS TIPOS AUXILIARES
    public function loadAnaliza()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $valores = $this->input->post("valores");
                $idctcuenta = $valores["ID"];
                $catgrupo = (int)$valores["grupo"];
                $registros = $this->contabilidad_model->getCtasA2($idctcuenta);
                $Total = 0;
                $Datos = null;
                if ($registros->num_rows() > 0) {
                    $total1 = 0;
                    $total2 = 0;
                    $total3 = 0;
                    $total4 = 0;
                    $total5 = 0;
                    $dato1 = [];
                    $dato2 = [];
                    $dato3 = [];
                    $dato4 = [];
                    $dato5 = [];

                    date_default_timezone_set('America/El_Salvador');
                    $ahora = date_create()->format('Y-m-d');
                    foreach ($registros->result() as $value) {
                        //$total = ($catgrupo == 1) ? ($value->debe - $value->haber) : ($value->haber - $value->debe);
                        $total = $this->getSTC($catgrupo, $value->debe, $value->haber);
                        $f1 = new DateTime($ahora);
                        $f2 = new DateTime($value->doc_emision);
                        $dias = $f1->diff($f2);
                        $tdias = $dias->days;
                        if ($tdias >= 0 && $tdias < 31) {
                            $texto1 = "0 - 30 (";
                            $total1 += $total;
                            $tipo = 0;
                        } else if ($tdias >= 31 && $tdias < 61) {
                            $texto2 = "31 - 60 (";
                            $total2 += $total;
                            $tipo = 1;
                        } else if ($tdias >= 61 && $tdias < 91) {
                            $texto3 = "61 - 90 (";
                            $total3 += $total;
                            $tipo = 2;
                        } else if ($tdias >= 91 && $tdias < 121) {
                            $texto4 = "91 - 120 (";
                            $total4 += $total;
                            $tipo = 3;
                        } else{
                            $texto5 = "121  +(";
                            $total5 += $total;
                            $tipo = 4;
                        }

                        $datos = $this->contabilidad_model->getCtasA3($idctcuenta, $value->doc_type, $value->doc_serie, $value->doc_numero, $value->idtabla, $value->idauxi);
                        foreach ($datos->result() as $dato) {
                            $responsable = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                            //$saldo = ($catgrupo == 1) ? ($dato->debe - $dato->haber) : ($dato->haber - $dato->debe);
                            $saldo = $this->getSTC($catgrupo, $dato->debe, $dato->haber);
                            $datoa = array(
                                'id' => $value->idrec,
                                'debe' => $value->debe,
                                'haber' => $value->haber,
                                'saldo' => number_format((float)$saldo, 2, '.', ''),
                                'responsable' => $responsable->descrip
                            );
                            switch ($tipo) {
                                case 0:
                                    $dato1[] = $datoa;
                                break;
                                case 1:
                                    $dato2[] = $datoa;
                                break;
                                case 2:
                                    $dato3[] = $datoa;
                                break;
                                case 3:
                                    $dato4[] = $datoa;
                                break;
                                case 4:
                                    $dato5[] = $datoa;
                                break;
                            }
                        }//*/
                    }
                    if(count($dato1) > 0){
                        $dato1 = array(
                            'total' => number_format((float)$total1, 2, '.', ''),
                            'texto' => $texto1.$this->session->userdata('simboloMoneda').number_format((float)$total1, 2, '.', '').")",
                            'acorde' => $dato1
                        );
                    }
                    if(count($dato2) > 0){
                        $dato2 = array(
                            'total' => number_format((float)$total2, 2, '.', ''),
                            'texto' => $texto2.$this->session->userdata('simboloMoneda').number_format((float)$total2, 2, '.', '').")",
                            'acorde' => $dato2
                        );
                    }
                    if(count($dato3) > 0){
                        $dato3 = array(
                            'total' => number_format((float)$total3, 2, '.', ''),
                            'texto' => $texto3.$this->session->userdata('simboloMoneda').number_format((float)$total3, 2, '.', '').")",
                            'acorde' => $dato3
                        );
                    }
                    if(count($dato4) > 0){
                        $dato4 = array(
                            'total' => number_format((float)$total4, 2, '.', ''),
                            'texto' => $texto4.$this->session->userdata('simboloMoneda').number_format((float)$total4, 2, '.', '').")",
                            'acorde' => $dato4
                        );
                    }
                    if(count($dato5) > 0){
                        $dato5 = array(
                            'total' => number_format((float)$total5, 2, '.', ''),
                            'texto' => $texto5.$this->session->userdata('simboloMoneda').number_format((float)$total5, 2, '.', '').")",
                            'acorde' => $dato5
                        );
                    }
                    if(count($dato1) > 0) $Datos[] = $dato1;
                    if(count($dato2) > 0) $Datos[] = $dato2;
                    if(count($dato3) > 0) $Datos[] = $dato3;
                    if(count($dato4) > 0) $Datos[] = $dato4;
                    if(count($dato5) > 0) $Datos[] = $dato5;
                    $Total = $total1 + $total2 + $total3 + $total4 + $total5;
                    /*$Datos[] = array(
                        'debe' => $value->debe,
                        'haber' => $value->haber,
                        'total' => number_format((float)$total, 2, '.', ''),
                        'dias' => $tdias,
                        //'responsable' => $responsable->descrip
                        //'acorde' => ,
                        'texto' => $texto.$this->session->userdata('simboloMoneda').number_format((float)$total, 2, '.', '').")",
                        'tipo' => $tipo
                    );//*/
                }

                $Total = number_format((float)$Total, 2, '.', '');
                $datA[] = array(
                    'valido' => true,
                    'datos' => $Datos,
                    'total' => $this->session->userdata('simboloMoneda')." ".number_format((float)$Total, 2, '.', '')
                );
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   GET REGISTROS DE CUENTA
    /*public function loadRegistros()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $valores = $this->input->post("valores");
                $idctcuenta = $valores["ID"];
                $catgrupo = (int)$valores["grupo"];
                $Datos = null;
                $registros = $this->contabilidad_model->getRegistros($idctcuenta);
                if ($registros->num_rows() > 0) {
                    foreach ($registros->result() as $dato) {
                        $responsable = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                        $saldo = ($catgrupo == 1) ? ($dato->debe - $dato->haber) : ($dato->haber - $dato->debe);
                        $Datos[] = array(
                            'responsable' => $responsable->descrip,
                            'numero_doc' => $dato->pnumero,
                            'serie' => $dato->doc_serie ."-".$dato->doc_numero,
                            'fecha' => $dato->doc_emision,
                            'cierre' => $dato->doc_vence,
                            'saldo' => $saldo,
                            'acorde' => null
                        );
                    }
                    usort($Datos, function($a, $b) {return strcmp($a['responsable'], $b['responsable']);});
                }
                $datA[] = array(
                    'valido' => true,
                    'datos' => $Datos,
                    'otro' => $this->prueba($idctcuenta, $catgrupo)
                );
                echo json_encode($datA);
            } else{
                show_404();
            }
        }
    }//*/
    /*public function prueba($cuenta, $grupo)
    {
        //return $registros = $this->contabilidad_model->getCtasA2($cuenta)->result();
        date_default_timezone_set('America/El_Salvador');
        $ahora = date_create()->format('Y-m-d');
        $Datos = null;
        $datos = $this->contabilidad_model->getCtasB1($cuenta);
        if ($datos->num_rows() > 0) {
            foreach ($datos->result() as $dato) {
                $f1 = new DateTime($ahora);
                $f2 = new DateTime($dato->doc_emision);
                $diferencia = $f1->diff($f2);
                $dias = $diferencia->days;

                $saldo = ($grupo == 1) ? ($dato->debe - $dato->haber) : ($dato->haber - $dato->debe);
                
                $datos2 = $this->contabilidad_model->getCtasB2($dato->idrec, $cuenta, $dato->doc_type, $dato->doc_serie, $dato->doc_numero, $dato->idtabla, $dato->idauxi);
                $movimientos = null;
                if ($datos2->num_rows() > 0) {
                    foreach ($datos2->result() as $valor) {
                        $value = ($grupo == 1) ? ($valor->debe - $valor->haber) : ($valor->haber - $valor->debe);
                        $movimientos[] = array(
                            'descripcion' => $valor->descrip,
                            'control' => $valor->doc_controlnum,
                            'fecha' => $valor->doc_emision,
                            'partida' => $valor->pnumero,
                            'autor' => $this->contabilidad_model->getAutor($valor->whodidit),
                            'valor' => abs($value),
                        );
                    }
                }

                $Datos[] = array(
                    'responsable' => $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla)->descrip,
                    'control' => $dato->control,
                    'numero_doc' => $dato->pnumero,
                    'serie' => $dato->doc_serie ."-".$dato->doc_numero,
                    'fecha' => $dato->doc_emision,
                    'cierre' => $dato->doc_vence,
                    'dias' => $dias,
                    'saldo' => $saldo,
                    'acorde' => $movimientos,
                );
            }
            usort($Datos, function($a, $b) {return strcmp($a['responsable'], $b['responsable']);});
        }
        return $Datos;
    }
    //*/
    public function loadRegistros()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $valores = $this->input->post("valores");
                $cuenta = $valores["ID"];
                $grupo = (int)$valores["grupo"];
                
                date_default_timezone_set('America/El_Salvador');
                $ahora = date_create()->format('Y-m-d');
                $Datos = null;
                $datos = $this->contabilidad_model->getCtasB1($cuenta);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $f1 = new DateTime($ahora);
                        $f2 = new DateTime($dato->doc_emision);
                        $diferencia = $f1->diff($f2);
                        $dias = $diferencia->days;

                        //$saldo = ($grupo == 1) ? ($dato->debe - $dato->haber) : ($dato->haber - $dato->debe);
                        $saldo = $this->getSTC($grupo, $dato->debe, $dato->haber);
                        
                        $datos2 = $this->contabilidad_model->getCtasB2($dato->idrec, $cuenta, $dato->doc_type, $dato->doc_serie, $dato->doc_numero, $dato->idtabla, $dato->idauxi);
                        $movimientos = null;
                        if ($datos2->num_rows() > 0) {
                            foreach ($datos2->result() as $valor) {
                                //$value = ($grupo == 1) ? ($valor->debe - $valor->haber) : ($valor->haber - $valor->debe);
                                $value = $this->getSTC($grupo, $valor->debe, $valor->haber);
                                $movimientos[] = array(
                                    'descripcion' => $valor->descrip,
                                    'control' => $valor->doc_controlnum,
                                    'fecha' => $valor->fecha,
                                    'partida' => $valor->pnumero,
                                    'autor' => $this->contabilidad_model->getAutor($valor->whodidit),
                                    'valor' => abs($value),
                                );
                            }
                        }
                        $Datos[] = array(
                            'responsable' => $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla)->descrip,
                            'control' => $dato->control,
                            'numero_doc' => $dato->pnumero,
                            'serie' => $dato->doc_serie ."-".$dato->doc_numero,
                            'fecha' => $dato->doc_emision,
                            'cierre' => $dato->doc_vence,
                            'dias' => $dias,
                            'saldo' => $saldo,
                            'acorde' => $movimientos,
                        );
                    }
                    usort($Datos, function($a, $b) {return strcmp($a['responsable'], $b['responsable']);});
                }
                $datA[] = array(
                    'valido' => true,
                    'datos' => $Datos,
                );
                echo json_encode($datA);
            } else show_404();
        }
    }
    #------------------------------------------------------     FIN ANALISIS DE CARTERA ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------    CONSULTA GENERAL CUENTAS  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------   BALANCE DE COMPROBACION
    public function Consulta_General_Cuentas($idApp)
    {
        if($this->validatePermiso()) {
            //echo "hola";
            $this->load->model('configuracion_model');
            $this->iniciarUReportes();
            $appName = $this->configuracion_model->getAppName($idApp);
            
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'Conta_jB1' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);

            $direccion = $this->uri->segment(1);

            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->load->view("mantenimiento_BComprobacion", $this->data);//*/
        }
    }
    #   GET HISTORIAL MONEY------------------MEJORA
    public function getHistorialN()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $fechai = $this->input->post("fechai");
            $fechaf = $this->input->post("fechaf");
            $Datos = [];
            if ($datos = $this->contabilidad_model->getAllCuentas()) {
                if ($datos->num_rows() > 0) {
                    $Datos1 = $datos->result();
                    $Datos2 = $this->contabilidad_model->getAllCuentas3();

                    $haySaldos = $this->contabilidad_model->existensaldos();
                    if (($Datos2->num_rows() > 0) && ($haySaldos > 0)) {
                        foreach ($Datos1 as $dato1) {
                            $dato1->old = 0;
                            $dato1->debe = 0;
                            $dato1->haber = 0;
                            $dato1->saldo = 0;
                        }
                        foreach ($Datos2->result() as $cuenta) {
                            $registros = $this->contabilidad_model->getSaldoCuenta($cuenta->idctcuenta, $fechaf);
                            //var_dump($registros->result());
                            if ($registros->num_rows() > 0) {
                                foreach ($registros->result() as $registro) {

                                    $registro->debe = floatval(number_format($registro->debe, 2, '.', ''));
                                    $registro->haber = floatval(number_format($registro->haber, 2, '.', ''));

                                    $min = new DateTime($fechai);
                                    $fecha = new DateTime($registro->fecha);
                                    if ($fecha >= $min) {
                                        $old = 0;
                                        $debe = $registro->debe;
                                        $haber = $registro->haber;
                                        //$saldo = ($cuenta->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                        $saldo = floatval(number_format($this->getSTC($cuenta->catgrupo, $registro->debe, $registro->haber), 2, '.', ''));
                                        //ingresar el saldo
                                    } else{
                                        //$old = ($cuenta->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                        $old = floatval(number_format($this->getSTC($cuenta->catgrupo, $registro->debe, $registro->haber), 2, '.', ''));
                                        $debe = 0;
                                        $haber = 0;
                                        $saldo = 0;
                                    }
                                    foreach ($Datos1 as $dato1) {
                                        if ($dato1->idctcuenta == $cuenta->idctcuenta) {
                                            $dato1->old += $old;
                                            $dato1->saldo += $saldo;
                                            $dato1->debe += $debe;
                                            $dato1->haber += $haber;
                                            foreach (explode(",", $cuenta->ctmayoriza) as $padre) {
                                                foreach ($Datos1 as $daton) {
                                                    if($daton->idctcuenta == $padre) {
                                                        $daton->old += $old;
                                                        $daton->saldo += $saldo;
                                                        $daton->debe += $debe;
                                                        $daton->haber += $haber;
                                                        break;
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                    }//*/
                                }
                            }
                        }
                        
                        # - Recorrido Final
                        foreach ($Datos1 as $dato) {
                            $HijosA = null;
                            if($dato->tipocuenta == 3){
                                $registrosA = $this->contabilidad_model->getAllAuxs($dato->idctcuenta, $fechaf);
                                if($registrosA->num_rows() > 0){
                                    $HijosR = null;
                                    foreach($registrosA->result() as $hijoA){
                                        if($hijoA->idtabla != 0){
                                            $hijoA->old = 0;
                                            $hijoA->debe = 0;
                                            $hijoA->haber = 0;
                                            $hijoA->saldo = 0;
                                            $HijosR[] = $hijoA;
                                        }
                                    }

                                    if($HijosR != null){
                                        foreach ($HijosR as $hijor) {
                                            $registrosR = $this->contabilidad_model->getSaldoAuxi($dato->idctcuenta, $fechaf, $hijor->idtabla, $hijor->idauxi);
                                            if($registrosR->num_rows() > 0){
                                                foreach ($registrosR->result() as $registroR) {
                                                    $registroR->debe = floatval(number_format($registroR->debe, 2, '.', ''));
                                                    $registroR->haber = floatval(number_format($registroR->haber, 2, '.', ''));

                                                    $min = new DateTime($fechai);
                                                    $fecha = new DateTime($registroR->fecha);
                                                    if ($fecha >= $min) {
                                                        $old = 0;
                                                        $debe = $registroR->debe;
                                                        $haber = $registroR->haber;
                                                        //$saldo = ($dato->catgrupo == 1) ? ($registroR->debe - $registroR->haber) : ($registroR->haber - $registroR->debe);
                                                        $saldo = floatval(number_format($this->getSTC($dato->catgrupo, $registroR->debe, $registroR->haber), 2, '.', ''));
                                                    } else{
                                                        //$old = ($dato->catgrupo == 1) ? ($registroR->debe - $registroR->haber) : ($registroR->haber - $registroR->debe);
                                                        $old = floatval(number_format($this->getSTC($dato->catgrupo, $registroR->debe, $registroR->haber), 2, '.', ''));
                                                        $debe = 0;
                                                        $haber = 0;
                                                        $saldo = 0;
                                                    }
                                                    foreach ($HijosR as $hijoR) {
                                                        if( ($hijoR->idtabla == $hijor->idtabla) && ($hijoR->idauxi == $hijor->idauxi) ){
                                                            $hijoR->old +=  floatval(number_format($old, 2, '.', ''));
                                                            $hijoR->debe += $debe;
                                                            $hijoR->haber += $haber;
                                                            $hijoR->saldo += floatval(number_format($saldo, 2, '.', ''));
                                                            break;
                                                        }
                                                    }//*/
                                                }
                                            }
                                        }
                                        foreach ($HijosR as $hijoA) {
                                            /*print_r($this->contabilidad_model->getResponsable($hijoA->idauxi, $hijoA->idtabla));
                                            if (count($this->contabilidad_model->getResponsable($hijoA->idauxi, $hijoA->idtabla)) > 0) {
                                                echo "-----------------";
                                            } else echo "+++++".$hijoA->idauxi.'*'.$hijoA->idtabla.'*'.$hijoA->fecha.'*'.$dato->idctcuenta;//*/
                                            $responsable = $this->contabilidad_model->getResponsable($hijoA->idauxi, $hijoA->idtabla);
                                            if($hijoA->idtabla == "1"){
                                                $grupo = $responsable->grupo;
                                            }else{
                                                $grupo = "";
                                            }
                                            $xpos = $responsable->xpos;
                                            $idvisible = (strlen(trim($xpos)) > 0) ? $xpos : $hijoA->idauxi;
                                            $HijosA[] = array(
                                                'idt' => $hijoA->idtabla,
                                                'id' => $hijoA->idauxi,
                                                'auxi' => $hijoA->idtabla.'/'.$hijoA->idauxi,
                                                'auxiliar' => $responsable->descrip,
                                                'grupo' => $grupo,
                                                'old' => floatval(number_format($hijoA->old, 2, '.', '')),
                                                'debe' => $hijoA->debe,
                                                'haber' => $hijoA->haber,
                                                'saldo' => floatval(number_format($hijoA->old + $hijoA->saldo, 2, '.', '')),
                                                'idvisible' => $idvisible,
                                                'ext' => $hijoA->lastpnumero,
                                                'idc' => $hijoA->idcentro
                                            );
                                        }//*/
                                    }
                                    //if($HijosA != null) usort($HijosA, function($a, $b) {return strcmp($a['auxiliar'], $b['auxiliar']);});
                                    if($HijosA != null) usort($HijosA, function($a, $b) {return strcmp($a['idvisible'], $b['idvisible']);});
                                }
                            }
                            $Datos[] = array(
                                'cuenta' => $dato->idctcuenta,
                                'titulo' => $dato->descrip,
                                'tipo' => $dato->tipocuenta,
                                'tipoTx' => array_search($dato->tipocuenta, $this->TiposCuentas),
                                'old' => floatval(number_format($dato->old, 2, '.', '')),
                                'debe' => $dato->debe,
                                'haber' => $dato->haber,
                                'saldo' => floatval(number_format($dato->old + $dato->saldo, 2, '.', '')),
                                'Fechai' => $fechai,
                                'Fechaf' => $fechaf,
                                //'hijos' => $HijosA,
                                'isauxi' => false,
                                'auxi' => '',
                                'grupo' => '',
                                'idt' => '',
                                'id' => '',
                                'idvisible' => '',
                                'idc' => '',
                            );
                            if ($HijosA != null) {
                                foreach ($HijosA as $hijoA) {
                                    $Datos[] = array(
                                        'cuenta' => $dato->idctcuenta,//.'.'.$hijoA['idvisible'],
                                        'tipo' => '-1',
                                        'tipoTx' => 'Auxiliar',
                                        'titulo' => $hijoA['auxiliar'],
                                        'old' => floatval(number_format($hijoA['old'], 2, '.', '')),
                                        'debe' => $hijoA['debe'],
                                        'haber' => $hijoA['haber'],
                                        'saldo' => floatval(number_format($hijoA['saldo'], 2, '.', '')),
                                        'Fechai' => $fechai,
                                        'Fechaf' => $fechaf,
                                        'isauxi' => true,
                                        'auxi' => $hijoA['auxi'],
                                        'grupo' => $hijoA['grupo'],
                                        'idt' => $hijoA['idt'],
                                        'id' => $hijoA['id'],
                                        'idc' => ($hijoA['idc'] == 0) ? '' : $hijoA['idc'],
                                        'idvisible' => $hijoA['idvisible'],
                                        'cuentah' => $dato->idctcuenta
                                    );
                                }
                            }
                        }
                    } else {
                        foreach ($Datos1 as $dato) {
                            $Datos[] = array(
                                'cuenta' => $dato->idctcuenta,
                                'titulo' => $dato->descrip,
                                'tipo' => $dato->tipocuenta,
                                'tipoTx' => array_search($dato->tipocuenta, $this->TiposCuentas),
                                'old' => 0,
                                'debe' => 0,
                                'haber' => 0,
                                'saldo' => 0,
                                'Fechai' => $fechai,
                                'Fechaf' => $fechaf,
                                'isauxi' => false,
                                'auxi' => '',
                                'grupo' => '',
                                'idt' => '',
                                'id' => '',
                                'idvisible' => '',
                                'idc' => ''
                            );
                        }
                    }
                }
                $datA[] = array('valido' => true, 'datos' => $Datos);
            } else $datA[] = array('valido' => false);

            echo json_encode($datA);
        }
    }
    #------------------
    #   GET HSITORIAL MONEY
    public function getHistorial()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $fechai = $this->input->post("fechai");
                $fechaf = $this->input->post("fechaf");
                $Datos = null;
                $Errores = "";//Variable para mensajes de error
                $cuentasError = [];
                if ($datos = $this->contabilidad_model->getAllCuentas()) {
                    if ($datos->num_rows() > 0) {
                        $Datos1 = $datos->result();
                        $Datos2 = $this->contabilidad_model->getAllCuentas3();
                        $haySaldos = $this->contabilidad_model->existensaldos();
                        if (($Datos2->num_rows() > 0) && ($haySaldos > 0)) {
                            foreach ($Datos1 as $dato1) {
                                $dato1->old = 0;
                                $dato1->debe = 0;
                                $dato1->haber = 0;
                                $dato1->saldo = 0;
                            }
                            foreach ($Datos2->result() as $cuenta) {
                                $registros = $this->contabilidad_model->getSaldoCuenta($cuenta->idctcuenta, $fechaf);
                                //print_r($registros->result());
                                if ($registros->num_rows() > 0) {
                                    foreach ($registros->result() as $registro) {
                                        $min = new DateTime($fechai);
                                        $fecha = new DateTime($registro->fecha);
                                        if ($fecha >= $min) {
                                            $old = 0;
                                            $debe = $registro->debe;
                                            $haber = $registro->haber;
                                            //$saldo = ($cuenta->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                            $saldo = $this->getSTC($cuenta->catgrupo, $registro->debe, $registro->haber);
                                            //ingresar el saldo
                                        } else{
                                            //$old = ($cuenta->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                            $old = $this->getSTC($cuenta->catgrupo, $registro->debe, $registro->haber);
                                            $debe = 0;
                                            $haber = 0;
                                            $saldo = 0;
                                        }
                                        foreach ($Datos1 as $dato1) {
                                            if ($dato1->idctcuenta == $cuenta->idctcuenta) {
                                                $dato1->old += $old;
                                                $dato1->saldo += $saldo;
                                                $dato1->debe += $debe;
                                                $dato1->haber += $haber;
                                                foreach (explode(",", $cuenta->ctmayoriza) as $padre) {
                                                    foreach ($Datos1 as $daton) {
                                                        if($daton->idctcuenta == $padre) {
                                                            $daton->old += $old;
                                                            $daton->saldo += $saldo;
                                                            $daton->debe += $debe;
                                                            $daton->haber += $haber;
                                                            break;
                                                        }
                                                    }
                                                }
                                                break;
                                            }
                                        }//*/
                                    }
                                }
                            }
                            /*print_r($Datos1);
                            die();//*/
                            foreach ($Datos1 as $dato) {
                                $HijosA = null;
                                if($dato->tipocuenta == 3){
                                    $registrosA = $this->contabilidad_model->getAllAuxs($dato->idctcuenta, $fechaf);
                                    if($registrosA->num_rows() > 0){
                                        $HijosR = null;
                                        foreach($registrosA->result() as $hijoA){
                                            if($hijoA->idtabla != 0){
                                                $hijoA->old = 0;
                                                $hijoA->debe = 0;
                                                $hijoA->haber = 0;
                                                $hijoA->saldo = 0;
                                                $HijosR[] = $hijoA;
                                            }
                                        }
                                        if($HijosR != null){
                                            foreach ($HijosR as $hijor) {
                                                $registrosR = $this->contabilidad_model->getSaldoAuxi($dato->idctcuenta, $fechaf, $hijor->idtabla, $hijor->idauxi);
                                                if($registrosR->num_rows() > 0){
                                                    foreach ($registrosR->result() as $registroR) {
                                                        $min = new DateTime($fechai);
                                                        $fecha = new DateTime($registroR->fecha);
                                                        if ($fecha >= $min) {
                                                            $old = 0;
                                                            $debe = $registroR->debe;
                                                            $haber = $registroR->haber;
                                                            //$saldo = ($dato->catgrupo == 1) ? ($registroR->debe - $registroR->haber) : ($registroR->haber - $registroR->debe);
                                                            $saldo = $this->getSTC($dato->catgrupo, $registroR->debe, $registroR->haber);
                                                        } else{
                                                            //$old = ($dato->catgrupo == 1) ? ($registroR->debe - $registroR->haber) : ($registroR->haber - $registroR->debe);
                                                            $old = $this->getSTC($dato->catgrupo, $registroR->debe, $registroR->haber);
                                                            $debe = 0;
                                                            $haber = 0;
                                                            $saldo = 0;
                                                        }
                                                        foreach ($HijosR as $hijoR) {
                                                            if( ($hijoR->idtabla == $hijor->idtabla) && ($hijoR->idauxi == $hijor->idauxi) ){
                                                                $hijoR->old +=  $old;
                                                                $hijoR->debe += $debe;
                                                                $hijoR->haber += $haber;
                                                                $hijoR->saldo += $saldo;
                                                                break;
                                                            }
                                                        }//*/
                                                    }
                                                }
                                            }
                                            foreach ($HijosR as $hijoA) {
                                                /*print_r($this->contabilidad_model->getResponsable($hijoA->idauxi, $hijoA->idtabla));
                                                if (count($this->contabilidad_model->getResponsable($hijoA->idauxi, $hijoA->idtabla)) > 0) {
                                                    echo "-----------------";
                                                } else echo "+++++".$hijoA->idauxi.'*'.$hijoA->idtabla.'*'.$hijoA->fecha.'*'.$dato->idctcuenta;//*/
                                                $auxiliarExiste = $this->contabilidad_model->getResponsable($hijoA->idauxi, $hijoA->idtabla);
                                                
                                                if($auxiliarExiste == null){
                                                    //Cuentas con error del libro auxiliar
                                                    $Errores = 'Cuenta con error en asignación de auxiliar.';
                                                    $cuentasError[] = array(
                                                        'idcuenta' => $dato->idctcuenta,
                                                        'descripcion' => $dato->descrip,
                                                        'mensajeError' => $Errores
                                                    );
                                                }else{
                                                    $HijosA[] = array(
                                                        'idt' => $hijoA->idtabla,
                                                        'id' => $hijoA->idauxi,
                                                        'auxi' => $hijoA->idtabla.'/'.$hijoA->idauxi,
                                                        'auxiliar' => $auxiliarExiste->descrip,
                                                        'old' => $hijoA->old,
                                                        'debe' => $hijoA->debe,
                                                        'haber' => $hijoA->haber,
                                                        'saldo' => $hijoA->old + $hijoA->saldo,
                                                        'ext' => $hijoA->lastpnumero
                                                    );
                                                }
                                            }//*/
                                        }
                                        if($HijosA != null) usort($HijosA, function($a, $b) {return strcmp($a['auxiliar'], $b['auxiliar']);});
                                    }
                                }
                                $Datos[] = array(
                                    'cuenta' => $dato->idctcuenta,
                                    'titulo' => $dato->descrip,
                                    'tipo' => $dato->tipocuenta,
                                    'tipoTx' => array_search($dato->tipocuenta, $this->TiposCuentas),
                                    'old' => $dato->old,
                                    'debe' => $dato->debe,
                                    'haber' => $dato->haber,
                                    'saldo' => $dato->old + $dato->saldo,
                                    'hijos' => $HijosA,
                                    'Fechai' => $fechai,
                                    'Fechaf' => $fechaf
                                );
                            }//*/
                        } else {
                            foreach ($Datos1 as $dato) {
                                $Datos[] = array(
                                    'cuenta' => $dato->idctcuenta,
                                    'titulo' => $dato->descrip,
                                    'tipo' => $dato->tipocuenta,
                                    'tipoTx' => array_search($dato->tipocuenta, $this->TiposCuentas),
                                    'old' => 0,
                                    'debe' => 0,
                                    'haber' => 0,
                                    'saldo' => 0,
                                    'hijos' => null,
                                    'Fechai' => $fechai,
                                    'Fechaf' => $fechaf
                                );
                            }
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos, 'cuentasError' => $cuentasError);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN GET HISTORIAL MONEY
    #------------------------------------------------------------------- GRAFICOS
    #   GET HISTORIAL GRAFICO   CUENTA
    public function getHistorialCbyM()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $cuenta = $this->input->post("cuenta");
                $fechai = $this->input->post("fechai");
                $fechaf = $this->input->post("fechaf");
                $f1 = new DateTime($fechai);
                $f2 = new DateTime($fechaf);
                $datacuenta = $this->contabilidad_model->getCuentaC($cuenta);
                
                if (count((array)$datacuenta) > 0) {
                    $fdif = $f1->diff($f2);//->m
                    $Datos = null;
                    $Total = 0;
                    $mi = (int)$f1->format('m');
                    $mf = (int)$f1->format('m') + (($fdif->y) * 12) + $fdif->m;
                    $ai = (int)$f1->format('Y');
                    $cambio = 0;
                    $valorcambio = $cambio * 12;
                    for ($i = $mi; $i <= $mf; $i++) {
                        $idmes = $i - $valorcambio;
                        $object = new stdClass();
                        $object->idyear = $ai;
                        $object->idmes = $idmes;
                        $object->mes = substr(ucfirst(array_search($idmes, $this->meses)), 0, 3);
                        $object->total = 0.00;
                        $Datos[] = $object;
                        if(($idmes % 12) == 0){
                            $ai++;
                            $cambio++;
                            $valorcambio = $cambio * 12;
                        }
                    }
                    //-
                    if ($datacuenta->tipocuenta != 3) {
                        $hijos = $this->contabilidad_model->getCuentasG($datacuenta->catgrupo);
                        if($hijos->num_rows() > 0){
                            $Hijos = null;
                            foreach($hijos->result() as $hijo){
                                if($hijo->tipocuenta == 3){
                                    foreach(explode(",", $hijo->ctmayoriza) as $padrehijo){
                                        if($padrehijo == $datacuenta->idctcuenta) $Hijos[] = $hijo;
                                    }
                                }
                            }
                            if($Hijos != null){
                                foreach($Hijos as $hijo){
                                    $registros = $this->contabilidad_model->getSaldoCuentabyM($hijo->idctcuenta, $fechai, $fechaf);
                                    foreach($registros->result() as $registro){
                                        //$total = ($hijo->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                        $total = $this->getSTC($hijo->catgrupo, $registro->debe, $registro->haber);
                                        foreach($Datos as $dato){
                                            if (($dato->idyear == (int)$registro->idyear) && ($dato->idmes == (int)$registro->idmes)) {
                                                $dato->total += $total;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        $registros = $this->contabilidad_model->getSaldoCuentabyM($cuenta, $fechai, $fechaf);
                        if($registros->num_rows() > 0){
                            foreach($registros->result() as $registro){
                                //$total = ($datacuenta->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                $total = $this->getSTC($datacuenta->catgrupo, $registro->debe, $registro->haber);
                                foreach($Datos as $dato){
                                    if (($dato->idyear == (int)$registro->idyear) && ($dato->idmes == (int)$registro->idmes)) {
                                        $dato->total += $total;
                                    }
                                }
                            }
                        }
                    }
                    foreach($Datos as $dato){
                        //$dato->total = number_format((float)$dato->total, 2, '.', '');
                        $Total += $dato->total;
                        $dato->total = (float)(($dato->total > 0.00) ? number_format((float)$dato->total, 2, '.', '') : $dato->total);
                        if($cambio > 0){
                            $dato->mes = $dato->mes.'-'.$dato->idyear;
                            //$dato->mes = ($fdif->y > 0) ? $dato->mes.'-'.$dato->idyear : $dato->mes;
                        }
                    }
                    $datA[] = array(
                        'valido' => true,
                        'datos' => $Datos,
                        'total' => number_format((float)$Total, 2, '.', ','),
                        'fd' => $fdif
                    );
                } else { $datA[] = array('valido' => false); }
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   GET HISTORIAL GRAFICO AUXILIAR
    public function getHistorialAbyM()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $cuenta = $this->input->post("cuenta");
                $fechai = $this->input->post("fechai");
                $fechaf = $this->input->post("fechaf");
                $idtabla = $this->input->post("idtabla");
                $idauxi = $this->input->post("idauxi");
                $f1 = new DateTime($fechai);
                $f2 = new DateTime($fechaf);
                $datacuenta = $this->contabilidad_model->getCuentaC($cuenta);
                
                if (count((array)$datacuenta) > 0) {
                    $Datos = null;
                    $Total = 0;
                    if($datacuenta->tipocuenta == 3){
                        $fdif = $f1->diff($f2);//->m
                        $mi = (int)$f1->format('m');
                        $mf = (int)$f1->format('m') + (($fdif->y) * 12) + $fdif->m;
                        $ai = (int)$f1->format('Y');
                        $cambio = 0;
                        $valorcambio = $cambio * 12;
                        for ($i = $mi; $i <= $mf; $i++) {
                            $idmes = $i - $valorcambio;
                            $object = new stdClass();
                            $object->idyear = $ai;
                            $object->idmes = $idmes;
                            $object->mes = ucfirst(array_search($idmes, $this->meses));
                            $object->total = 0.00;
                            $Datos[] = $object;
                            if(($idmes % 12) == 0){
                                $ai++;
                                $cambio++;
                                $valorcambio = $cambio * 12;
                            }
                        }
                        //-
                        $registros = $this->contabilidad_model->getSaldoAuxibyM($cuenta, $idtabla, $idauxi, $fechai, $fechaf);
                        if($registros->num_rows() > 0){
                            foreach($registros->result() as $registro){
                                //$total = ($datacuenta->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                $total = $this->getSTC($datacuenta->catgrupo, $registro->debe, $registro->haber);
                                foreach($Datos as $dato){
                                    if (($dato->idyear == (int)$registro->idyear) && ($dato->idmes == (int)$registro->idmes)) {
                                        $dato->total += $total;
                                    }
                                }
                            }
                        }
                        foreach ($Datos as $dato) {
                            $Total += $dato->total;
                        }
                    }
                    $datA[] = array(
                        'valido' => true,
                        'total' => number_format((float)$Total, 2, '.', ','),
                        'datos' => $Datos,
                    );
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            } else show_404();
        }
    }
    #------------------------------------------------------------------- DETALLE
    #   GET REGISROS HISTORIAL POR CUENTA
    public function RConsultaGC($cuenta = null, $fechai = null, $fechaf = null)
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $datacuenta = $this->contabilidad_model->ValidationCuenta($cuenta);
            $valido = 0;
            $nombre = '';
            $datos = null;
            if($datacuenta == 1) {
                $nombre = $this->contabilidad_model->getCuentaC($cuenta)->descrip;
                if (preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechai) && preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechaf)) {
                    $di = explode("-", $fechai);
                    $df = explode("-", $fechaf);
                    if(checkdate($di[1], $di[2], $di[0]) && checkdate($df[1], $df[2], $df[0])) {
                        $valido = 1;
                        $datos = $this->getHistorialCuenta($cuenta, $fechai, $fechaf);
                    }
                }
            }

            $resultAppName = array(
                'namePage' => 'movimiento de la cuenta  '.$cuenta.' - '.$nombre
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->load->model('configuracion_model');
            $this->data['valido'] = $valido;
            $this->data['Registros'] = $datos;
            $this->data['Tipo'] = 0;
            $this->load->view("mantenimiento_RCGeneralC", $this->data);
        }
    }

    public function getHistorialCuentaBalanceComprobacion(){
        $cuenta = $this->input->post('cuenta');
        $fechai = $this->input->post('fechai');
        $fechaf = $this->input->post('fechaf');

        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $datacuenta = $this->contabilidad_model->ValidationCuenta($cuenta);

            if($datacuenta == 1) {
                if (preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechai) && preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechaf)) {
                    $di = explode("-", $fechai);
                    $df = explode("-", $fechaf);
                    if(checkdate($di[1], $di[2], $di[0]) && checkdate($df[1], $df[2], $df[0])) {
                        $datos = $this->getHistorialCuenta($cuenta, $fechai, $fechaf);
                    }
                }
            }

            echo json_encode($datos);
        }
    }
    
    public function getHistorialCuentaBalanceComprobacionSaldo(){
        $cuenta = $this->input->post('cuenta');
        $fechai = $this->input->post('fechai');
        $fechaf = $this->input->post('fechaf');
        $old    = $this->input->post('old');

        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $datacuenta = $this->contabilidad_model->ValidationCuenta($cuenta);

            if($datacuenta == 1) {
                if (preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechai) && preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechaf)) {
                    $di = explode("-", $fechai);
                    $df = explode("-", $fechaf);
                    if(checkdate($di[1], $di[2], $di[0]) && checkdate($df[1], $df[2], $df[0])) {
                        $datos = $this->getHistorialCuentaSaldo($cuenta, $fechai, $fechaf, $old);
                    }
                }
            }

            echo json_encode($datos);
        }
    }

    private function getHistorialCuenta($cuenta, $fechai, $fechaf)
    {
        $DataC = $this->contabilidad_model->getCuentaC($cuenta);
        $Datos = null;
        if ($DataC->tipocuenta != 3) {
            $registros = $this->contabilidad_model->getRegistrosGC($DataC->catgrupo, $fechai, $fechaf, $DataC->tipocuenta);
            if ($registros->num_rows() > 0) {
                $Registros = null;
                foreach ($registros->result() as $dato) {
                    foreach(explode(",", $dato->ctmayoriza) as $padre){
                        if($padre == $cuenta)
                            $Registros [] = $dato;
                    }
                }
                if($Registros != null) {
                    foreach($Registros as $dato){
                        $TPartida = $this->contabilidad_model->getEPDetalle($dato->pnumero);
                        $serien = $dato->doc_serie.'-'.$dato->doc_numero;
                        if($dato->idtabla != 0){
                            $auxi = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                            $auxiDescrip = $auxi->descrip;

                            if($dato->idtabla == "1"){
                                $auxiGrupo = $auxi->grupo;
                            }else{
                                $auxiGrupo = "";
                            }

                        }else{
                            $auxi = '';
                            $auxiDescrip = '';
                            $auxiGrupo = "";

                        }
                        //'auxiliar' => ($dato->idtabla != 0) ? $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla)->descrip : '',

                        $Datos[] = array(
                            'id' => $dato->idrec,
                            'fecha' => $dato->fecha,
                            'TPartida' => $TPartida->tipoP,
                            'numero' => $dato->pnumero,
                            'linea' => $dato->itemline,
                            'cuenta' => $dato->idctcuenta,
                            'cuentaD' => $dato->cuentaD,
                            'titulo' => $dato->descrip,
                            'debe' => $dato->debe,
                            'haber' => $dato->haber,
                            'doc_type' => $dato->doc_type,
                            'chg_log' => $this->getArrayChangeLog($dato->chg_log),
                            'idauxi' => ($dato->idtabla != 0) ? $dato->idauxi : '',
                            'auxiliar' => $auxiDescrip,
                            'grupo' => $auxiGrupo,
                            'centro' => ($dato->idcentro != 0) ? $this->contabilidad_model->getCentro($dato->idcentro)->descrip : '',
                            'proyecto' => ($dato->idproject != 0) ? $this->contabilidad_model->getProyecto($dato->idproject)->descrip : '',
                            'serien' => (strlen($serien) > 1) ? $dato->doc_serie.'-'.$dato->doc_numero : ''
                        );
                    }
                }
            }
        } else {
            $registros = $this->contabilidad_model->getRegistrosGC($cuenta, $fechai, $fechaf, $DataC->tipocuenta);
            if($registros->num_rows() > 0){
                foreach($registros->result() as $dato){
                    $TPartida = $this->contabilidad_model->getEPDetalle($dato->pnumero);
                    $serien = $dato->doc_serie.'-'.$dato->doc_numero;

                    if($dato->idtabla != 0){
                        $auxi = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                        $auxiDescrip = $auxi->descrip;

                        if($dato->idtabla == "1"){
                            $auxiGrupo = $auxi->grupo;
                        }else{
                            $auxiGrupo = "";
                        }

                    }else{
                        $auxi = '';
                        $auxiDescrip = '';
                        $auxiGrupo = "";
                    }

                    $Datos[] = array(
                        'id' => $dato->idrec,
                        'fecha' => $dato->fecha,
                        'TPartida' => $TPartida->tipoP,
                        'numero' => $dato->pnumero,
                        'linea' => $dato->itemline,
                        'cuenta' => $dato->idctcuenta,
                        'cuentaD' => $dato->cuentaD,
                        'titulo' => $dato->descrip,
                        'debe' => $dato->debe,
                        'haber' => $dato->haber,
                        'doc_type' => $dato->doc_type,
                        'chg_log' => $this->getArrayChangeLog($dato->chg_log),
                        'idauxi' => ($dato->idtabla != 0) ? $dato->idauxi : '',
                        'auxiliar' => $auxiDescrip,
                        'grupo' => $auxiGrupo,
                        'idcentro' => ($dato->idcentro != 0) ? $dato->idcentro : '',
                        'centro' => ($dato->idcentro != 0) ? $this->contabilidad_model->getCentro($dato->idcentro)->descrip : '',
                        'proyecto' => ($dato->idproject != 0) ? $this->contabilidad_model->getProyecto($dato->idproject)->descrip : '',
                        'serien' => (strlen($serien) > 1) ? $dato->doc_serie.'-'.$dato->doc_numero : ''
                    );
                }
            }
        }
        return $Datos;
    }

    private function getHistorialCuentaSaldo($cuenta, $fechai, $fechaf, $old)
    {
        $DataC = $this->contabilidad_model->getCuentaC($cuenta);
        $Datos = null; $i = 0;
        if ($DataC->tipocuenta != 3) {
            $registros = $this->contabilidad_model->getRegistrosGC($DataC->catgrupo, $fechai, $fechaf, $DataC->tipocuenta);
            if ($registros->num_rows() > 0) {
                $Registros = null;
                foreach ($registros->result() as $dato) {
                    foreach(explode(",", $dato->ctmayoriza) as $padre){
                        if($padre == $cuenta)
                            $Registros [] = $dato;
                    }
                }
                if($Registros != null) {
                    foreach($Registros as $dato){
                        $TPartida = $this->contabilidad_model->getEPDetalle($dato->pnumero);
                        $serien = $dato->doc_serie.'-'.$dato->doc_numero;
                        if($dato->idtabla != 0){
                            $auxi = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                            $auxiDescrip = $auxi->descrip;

                            if($dato->idtabla == "1"){
                                $auxiGrupo = $auxi->grupo;
                            }else{
                                $auxiGrupo = "";
                            }

                        }else{
                            $auxi = '';
                            $auxiDescrip = '';
                            $auxiGrupo = "";

                        }
                        //'auxiliar' => ($dato->idtabla != 0) ? $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla)->descrip : '',

                        if ( $i== 0 ) {
                            $oldSaldo = $old;
                            $nSaldo = $oldSaldo + $this->getSTC($dato->catgrupo, $dato->debe, $dato->haber);
                            
                            $Datos[] = array(
                                'titulo' => 'Saldo Anterior',
                                'old' => '',
                                'debe' => '',
                                'haber' => '',
                                'saldo' => $oldSaldo,
                            );
                        } else {
                            $oldSaldo = $nSaldo;
                            $nSaldo = $oldSaldo + $this->getSTC($dato->catgrupo, $dato->debe, $dato->haber);
                        }

                        $Datos[] = array(
                            'id' => $dato->idrec,
                            'fecha' => $dato->fecha,
                            'TPartida' => $TPartida->tipoP,
                            'numero' => $dato->pnumero,
                            'linea' => $dato->itemline,
                            'cuenta' => $dato->idctcuenta,
                            'cuentaD' => $dato->cuentaD,
                            'titulo' => $dato->descrip,
                            'old' => $oldSaldo,
                            'debe' => $dato->debe,
                            'haber' => $dato->haber,
                            'saldo' => $nSaldo,
                            'doc_type' => $dato->doc_type,
                            'chg_log' => $this->getArrayChangeLog($dato->chg_log),
                            'idauxi' => ($dato->idtabla != 0) ? $dato->idauxi : '',
                            'auxiliar' => $auxiDescrip,
                            'grupo' => $auxiGrupo,
                            'centro' => ($dato->idcentro != 0) ? $this->contabilidad_model->getCentro($dato->idcentro)->descrip : '',
                            'proyecto' => ($dato->idproject != 0) ? $this->contabilidad_model->getProyecto($dato->idproject)->descrip : '',
                            'serien' => (strlen($serien) > 1) ? $dato->doc_serie.'-'.$dato->doc_numero : ''
                        );

                        $i++;
                    }
                }
            }
        } else {
            $registros = $this->contabilidad_model->getRegistrosGC($cuenta, $fechai, $fechaf, $DataC->tipocuenta);
            if($registros->num_rows() > 0){
                foreach($registros->result() as $dato){
                    $TPartida = $this->contabilidad_model->getEPDetalle($dato->pnumero);
                    $serien = $dato->doc_serie.'-'.$dato->doc_numero;

                    if($dato->idtabla != 0){
                        $auxi = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                        $auxiDescrip = $auxi->descrip;

                        if($dato->idtabla == "1"){
                            $auxiGrupo = $auxi->grupo;
                        }else{
                            $auxiGrupo = "";
                        }

                    }else{
                        $auxi = '';
                        $auxiDescrip = '';
                        $auxiGrupo = "";
                    }

                    if ( $i== 0 ) {
                        $oldSaldo = $old;
                        $nSaldo = $oldSaldo + $this->getSTC($dato->catgrupo, $dato->debe, $dato->haber);
                        
                        $Datos[] = array(
                            'titulo' => 'Saldo Anterior',
                            'old' => '',
                            'debe' => '',
                            'haber' => '',
                            'saldo' => $oldSaldo,
                        );
                    } else {
                        $oldSaldo = $nSaldo;
                        $nSaldo = $oldSaldo + $this->getSTC($dato->catgrupo, $dato->debe, $dato->haber);
                    }

                    $Datos[] = array(
                        'id' => $dato->idrec,
                        'fecha' => $dato->fecha,
                        'TPartida' => $TPartida->tipoP,
                        'numero' => $dato->pnumero,
                        'linea' => $dato->itemline,
                        'cuenta' => $dato->idctcuenta,
                        'cuentaD' => $dato->cuentaD,
                        'titulo' => $dato->descrip,
                        'old' => $oldSaldo,
                        'debe' => $dato->debe,
                        'haber' => $dato->haber,
                        'saldo' => $nSaldo,
                        'doc_type' => $dato->doc_type,
                        'chg_log' => $this->getArrayChangeLog($dato->chg_log),
                        'idauxi' => ($dato->idtabla != 0) ? $dato->idauxi : '',
                        'auxiliar' => $auxiDescrip,
                        'grupo' => $auxiGrupo,
                        'idcentro' => ($dato->idcentro != 0) ? $dato->idcentro : '',
                        'centro' => ($dato->idcentro != 0) ? $this->contabilidad_model->getCentro($dato->idcentro)->descrip : '',
                        'proyecto' => ($dato->idproject != 0) ? $this->contabilidad_model->getProyecto($dato->idproject)->descrip : '',
                        'serien' => (strlen($serien) > 1) ? $dato->doc_serie.'-'.$dato->doc_numero : ''
                    );

                    $i++;
                }
            }
        }
        return $Datos;
    }
    #   GET REGISROS HISTORIAL POR AUXILIAR
    public function RConsultaGA($cuenta = null, $idtabla = null, $idauxi = null, $fechai = null, $fechaf = null)
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $datacuenta = $this->contabilidad_model->ValidationCuenta($cuenta);
            $dataauxi = $this->contabilidad_model->getResponsable($idauxi, $idtabla);
            $valido = 0;
            $nombre = '';
            $nombreA = '';
            $datos = null;
            if(($datacuenta == 1) && (count((array)$dataauxi) > 0)){
                $data = $this->contabilidad_model->getCuentaC($cuenta);
                $nombre = $data->descrip;
                $nombreA = $dataauxi->descrip;
                if($data->tipocuenta == 3){
                    if (preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechai) && preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechaf)) {
                        $di = explode("-", $fechai);
                        $df = explode("-", $fechaf);
                        if(checkdate($di[1], $di[2], $di[0]) && checkdate($df[1], $df[2], $df[0])) {
                            $valido = 1;
                            $datos = $this->getHistorialAuxi($data, $idtabla, $idauxi, $fechai, $fechaf);
                        }
                    }
                }
            }
            $resultAppName = array(
                'namePage' => 'movimiento de la cuenta  '.$nombre.' - '.$nombreA
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->load->model('configuracion_model');
            $this->data['valido'] = $valido;
            $this->data['Registros'] = $datos;
            $this->data['Tipo'] = 1;
            $this->load->view("mantenimiento_RCGeneralC", $this->data);
        }
    }

    public function getHistorialAuxiBalanceComprobacion(){
        $cuenta = $this->input->post('cuenta');
        $idtabla = $this->input->post('idtabla');
        $idauxi = $this->input->post('idauxi');
        $fechai = $this->input->post('fechai');
        $fechaf = $this->input->post('fechaf');

        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $datacuenta = $this->contabilidad_model->ValidationCuenta($cuenta);
            $dataauxi = $this->contabilidad_model->getResponsable($idauxi, $idtabla);
        
            $datos = null;
            if(($datacuenta == 1) && (count((array)$dataauxi) > 0)){
                $data = $this->contabilidad_model->getCuentaC($cuenta);
                
                if($data->tipocuenta == 3){
                    if (preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechai) && preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechaf)) {
                        $di = explode("-", $fechai);
                        $df = explode("-", $fechaf);
                        if(checkdate($di[1], $di[2], $di[0]) && checkdate($df[1], $df[2], $df[0])) {
                            $datos = $this->getHistorialAuxi($data, $idtabla, $idauxi, $fechai, $fechaf);
                        }
                    }
                }
            }
            echo json_encode($datos);
        }
    }

    public function getHistorialAuxiBalanceComprobacionSaldo(){
        $cuenta  = $this->input->post('cuenta');
        $idtabla = $this->input->post('idtabla');
        $idauxi  = $this->input->post('idauxi');
        $fechai  = $this->input->post('fechai');
        $fechaf  = $this->input->post('fechaf');
        $old     = $this->input->post('old');

        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $datacuenta = $this->contabilidad_model->ValidationCuenta($cuenta);
            $dataauxi = $this->contabilidad_model->getResponsable($idauxi, $idtabla);
        
            $datos = null;
            if(($datacuenta == 1) && (count((array)$dataauxi) > 0)){
                $data = $this->contabilidad_model->getCuentaC($cuenta);
                
                if($data->tipocuenta == 3){
                    if (preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechai) && preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechaf)) {
                        $di = explode("-", $fechai);
                        $df = explode("-", $fechaf);
                        if(checkdate($di[1], $di[2], $di[0]) && checkdate($df[1], $df[2], $df[0])) {
                            $datos = $this->getHistorialAuxiSaldo($data, $idtabla, $idauxi, $fechai, $fechaf, $old);
                        }
                    }
                }
            }
            echo json_encode($datos);
        }
    }

    private function getHistorialAuxi($dataC, $idtabla, $idauxi, $fechai, $fechaf)
    {
        $Datos = null;
        $registros = $this->contabilidad_model->getRegistrosGA($dataC->idctcuenta, $fechai, $fechaf, $idtabla, $idauxi);
            if($registros->num_rows() > 0){
                foreach($registros->result() as $dato){
                    $TPartida = $this->contabilidad_model->getEPDetalle($dato->pnumero);
                    $serien = $dato->doc_serie.'-'.$dato->doc_numero;
                    if($dato->idtabla != 0){
                        $auxi = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                        $auxiDescrip = $auxi->descrip;

                        if($dato->idtabla == "1"){
                            $auxiGrupo = $auxi->grupo;
                        }else{
                            $auxiGrupo = "";
                        }

                    }else{
                        $auxi = '';
                        $auxiDescrip = '';
                        $auxiGrupo = "";
                    }

                    $Datos[] = array(
                        'id' => $dato->idrec,
                        'fecha' => $dato->fecha,
                        'TPartida' => $TPartida->tipoP,
                        'numero' => $dato->pnumero,
                        'linea' => $dato->itemline,
                        'cuenta' => $dato->idctcuenta,
                        'cuentaD' => $dato->cuentaD,
                        'titulo' => $dato->descrip,
                        'debe' => $dato->debe,
                        'haber' => $dato->haber,
                        'doc_type' => $dato->doc_type,
                        'chg_log' => $this->getArrayChangeLog($dato->chg_log),
                        'idauxi' => ($dato->idtabla != 0) ? $dato->idauxi : '',
                        'auxiliar' => $auxiDescrip,
                        'grupo' => $auxiGrupo,
                        'idcentro' => ($dato->idcentro != 0) ? $dato->idcentro : '',
                        'centro' => ($dato->idcentro != 0) ? $this->contabilidad_model->getCentro($dato->idcentro)->descrip : '',
                        'proyecto' => ($dato->idproject != 0) ? $this->contabilidad_model->getProyecto($dato->idproject)->descrip : '',
                        'serien' => (strlen($serien) > 1) ? $dato->doc_serie.'-'.$dato->doc_numero : ''
                    );
                }
            }
        return $Datos;
    }

    private function getHistorialAuxiSaldo($dataC, $idtabla, $idauxi, $fechai, $fechaf, $old)
    {
        $Datos = null; $i=0;
        $registros = $this->contabilidad_model->getRegistrosGA($dataC->idctcuenta, $fechai, $fechaf, $idtabla, $idauxi);
            if($registros->num_rows() > 0){
                foreach($registros->result() as $dato){
                    $TPartida = $this->contabilidad_model->getEPDetalle($dato->pnumero);
                    $serien = $dato->doc_serie.'-'.$dato->doc_numero;
                    if($dato->idtabla != 0){
                        $auxi = $this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla);
                        $auxiDescrip = $auxi->descrip;

                        if($dato->idtabla == "1"){
                            $auxiGrupo = $auxi->grupo;
                        }else{
                            $auxiGrupo = "";
                        }

                    }else{
                        $auxi = '';
                        $auxiDescrip = '';
                        $auxiGrupo = "";
                    }

                    if ( $i== 0 ) {
                        $oldSaldo = $old;
                        $nSaldo = $oldSaldo + $this->getSTC($dato->catgrupo, $dato->debe, $dato->haber);
                        
                        $Datos[] = array(
                            'titulo' => 'Saldo Anterior',
                            'old' => '',
                            'debe' => '',
                            'haber' => '',
                            'saldo' => $oldSaldo,
                        );
                    } else {
                        $oldSaldo = $nSaldo;
                        $nSaldo = $oldSaldo + $this->getSTC($dato->catgrupo, $dato->debe, $dato->haber);
                    }

                    $Datos[] = array(
                        'id' => $dato->idrec,
                        'fecha' => $dato->fecha,
                        'TPartida' => $TPartida->tipoP,
                        'numero' => $dato->pnumero,
                        'linea' => $dato->itemline,
                        'cuenta' => $dato->idctcuenta,
                        'cuentaD' => $dato->cuentaD,
                        'titulo' => $dato->descrip,
                        'old' => $oldSaldo,
                        'debe' => $dato->debe,
                        'haber' => $dato->haber,
                        'saldo' => $nSaldo,
                        'doc_type' => $dato->doc_type,
                        'chg_log' => $this->getArrayChangeLog($dato->chg_log),
                        'idauxi' => ($dato->idtabla != 0) ? $dato->idauxi : '',
                        'auxiliar' => $auxiDescrip,
                        'grupo' => $auxiGrupo,
                        'idcentro' => ($dato->idcentro != 0) ? $dato->idcentro : '',
                        'centro' => ($dato->idcentro != 0) ? $this->contabilidad_model->getCentro($dato->idcentro)->descrip : '',
                        'proyecto' => ($dato->idproject != 0) ? $this->contabilidad_model->getProyecto($dato->idproject)->descrip : '',
                        'serien' => (strlen($serien) > 1) ? $dato->doc_serie.'-'.$dato->doc_numero : ''
                    );

                    $i++;
                }
            }
        return $Datos;
    }

    function getArrayChangeLog($chg_log){
        $this->load->model('user_model');

        $chg_log = explode(";", $chg_log);
        $chg_log = array_filter($chg_log);

        $resultado = [];
        foreach($chg_log as $log){
            $dato = explode(",", $log);
            $usuario = $this->user_model->getDatosUsuario($dato[1])['descrip'];
            $resultado[] = ["fecha"=>$dato[0], "usuario"=>$usuario, "descrip"=>$dato[2]];
        }
        return $resultado;
    }
    #   FIN GET REGISROS HISTORIAL POR AUXILIAR
    #---------------------------------------------------------------   FIN BALANCE DE COMPROBACION
    #---------------------------------------------------------------   BALANCE GENERAL
    public function indexBGeneral($idApp)
    {
        if($this->validatePermiso()) {
            //echo "hola";
            $this->load->model('configuracion_model');
            $this->iniciarUReportes();
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'Conta_jB0' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->load->view("mantenimiento_BGeneral", $this->data);//*/
        }
    }
    #   GET HSITORIAL MONEY
    public function getHistorialBG()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $fechai = $this->input->post("fechai");
                $fechaf = $this->input->post("fechaf");
                $utilidad = $this->input->post("utilidad");
                $Datos = null;
                if ($datos = $this->contabilidad_model->getAllCuentas12345()) {
                    if ($datos->num_rows() > 0) {
                        $Datos1 = $datos->result();
                        $Datos2 = $this->contabilidad_model->getAllCuentas3_12345();
                        $haySaldos = $this->contabilidad_model->existensaldos_12345();
                        if (($Datos2->num_rows() > 0) && ($haySaldos > 0)) {
                            foreach ($Datos1 as $dato1) {
                                $dato1->old = 0;
                                $dato1->debe = 0;
                                $dato1->haber = 0;
                                $dato1->saldo = 0;
                            }
                            foreach ($Datos2->result() as $cuenta) {
                                $registros = $this->contabilidad_model->getSaldoCuenta($cuenta->idctcuenta, $fechaf);
                                if ($registros->num_rows() > 0) {
                                    foreach ($registros->result() as $registro) {
                                        $min = new DateTime($fechai);
                                        $fecha = new DateTime($registro->fecha);
                                        if ($fecha >= $min) {
                                            $old = 0;
                                            $debe = $registro->debe;
                                            $haber = $registro->haber;
                                            $saldo = $this->getSTC($cuenta->catgrupo, $registro->debe, $registro->haber);
                                            //ingresar el saldo
                                        } else {
                                            $old = $this->getSTC($cuenta->catgrupo, $registro->debe, $registro->haber);
                                            $debe = 0;
                                            $haber = 0;
                                            $saldo = 0;
                                        }
                                        foreach ($Datos1 as $dato1) {
                                            if ($dato1->idctcuenta == $cuenta->idctcuenta) {
                                                $dato1->old += $old;
                                                $dato1->saldo += $saldo;
                                                $dato1->debe += $debe;
                                                $dato1->haber += $haber;
                                                foreach (explode(",", $cuenta->ctmayoriza) as $padre) {
                                                    foreach ($Datos1 as $daton) {
                                                        if($daton->idctcuenta == $padre) {
                                                            $daton->old += $old;
                                                            $daton->saldo += $saldo;
                                                            $daton->debe += $debe;
                                                            $daton->haber += $haber;
                                                            break;
                                                        }
                                                    }
                                                }
                                                break;
                                            }
                                        }//*/
                                    }
                                }
                            }
                            foreach ($Datos1 as $dato) {
                                $dato->nsaldo = $dato->old + $dato->saldo;
                            }
                            //- UTILIDADES Y PERDIDAS
                            $hijo31 = $this->contabilidad_model->existe_padre_hijo_property(3, 3, 6);
                            $hijo32 = $this->contabilidad_model->existe_padre_hijo_property(3, 3, 7);
                            $padre4 = $this->contabilidad_model->existe_padre_hijo_property(1, 4, null);
                            $padre5 = $this->contabilidad_model->existe_padre_hijo_property(1, 5, null);//*/
                            if ($hijo31 && $hijo32 && $padre4 && $padre5) {
                                if($utilidad == 1){
                                    $valorpyg=0;//
                                    foreach ($Datos1 as $dato) {
                                        if ($dato->ctcontrol == 6 && $dato->tipocuenta == 3) $valorpyg += $dato->nsaldo;
                                        if ($dato->ctcontrol == 7 && $dato->tipocuenta == 3) $valorpyg += $dato->nsaldo;
                                    }

                                //-
                                
                                    if ($valorpyg = 0){
                                        $valor4 = 0; // DEUDORA
                                        $valor5 = 0; // ACREEDORA
                                        foreach ($Datos1 as $dato) {
                                            if ($dato->catgrupo == 4 && $dato->tipocuenta == 1) $valor4 = $dato->nsaldo;
                                            if ($dato->catgrupo == 5 && $dato->tipocuenta == 1) $valor5 = $dato->nsaldo;
                                        }
                                        $valor54 = $valor5 - $valor4;
                                        foreach ($Datos1 as $dato) {
                                            $control = ($valor54 > 0) ? 6 : 7;
                                            if ($dato->catgrupo == 3 && $dato->ctcontrol == $control && $dato->tipocuenta == 3) 
                                            {
                                                $vold = $dato->nsaldo;
                                                $dato->nsaldo = $valor54;
                                                foreach (explode(",", $dato->ctmayoriza) as $padre) {
                                                    foreach ($Datos1 as $daton) {
                                                        if($daton->idctcuenta == $padre) {
                                                            $daton->nsaldo = $daton->nsaldo - $vold;
                                                            $daton->nsaldo = $daton->nsaldo + $valor54;
                                                            break;
                                                        }
                                                    }
                                                }
                                                break;
                                            }
                                        }
                                    }
                                }else{
                                    $valor4 = 0; // DEUDORA
                                    $valor5 = 0; // ACREEDORA
                                    foreach ($Datos1 as $dato) {
                                        if ($dato->catgrupo == 4 && $dato->tipocuenta == 1) $valor4 = $dato->nsaldo;
                                        if ($dato->catgrupo == 5 && $dato->tipocuenta == 1) $valor5 = $dato->nsaldo;
                                    }
                                    $valor54 = $valor5 - $valor4;
                                    foreach ($Datos1 as $dato) {
                                        $control = ($valor54 > 0) ? 6 : 7;
                                        if ($dato->catgrupo == 3 && $dato->ctcontrol == $control && $dato->tipocuenta == 3) 
                                        {
                                            $vold = $dato->nsaldo;
                                            $dato->nsaldo = $valor54;
                                            foreach (explode(",", $dato->ctmayoriza) as $padre) {
                                                foreach ($Datos1 as $daton) {
                                                    if($daton->idctcuenta == $padre) {
                                                        $daton->nsaldo = $daton->nsaldo - $vold;
                                                        $daton->nsaldo = $daton->nsaldo + $valor54;
                                                        break;
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                    }
                                }
                                
                            }//*/
                            //-
                            foreach ($Datos1 as $dato) {
                                if (($dato->balview == 1) && ($dato->catgrupo == 1 || $dato->catgrupo == 2 || $dato->catgrupo == 3)) {
                                    $Datos[] = array(
                                        'cuenta' => $dato->idctcuenta,
                                        'titulo' => $dato->descrip,
                                        'tipo' => $dato->tipocuenta,
                                        'tipoTx' => array_search($dato->tipocuenta, $this->TiposCuentas),
                                        'old' => $dato->old,
                                        'debe' => $dato->debe,
                                        'haber' => $dato->haber,
                                        //'saldo' => $dato->old + $dato->saldo,
                                        'saldo' => $dato->nsaldo,
                                        'Fechai' => $fechai,
                                        'Fechaf' => $fechaf
                                    );
                                }
                            }
                        } else {
                            foreach ($Datos1 as $dato) {
                                if (($dato->balview == 1) && ($dato->catgrupo == 1 || $dato->catgrupo == 2 || $dato->catgrupo == 3)) {
                                    $Datos[] = array(
                                        'cuenta' => $dato->idctcuenta,
                                        'titulo' => $dato->descrip,
                                        'tipo' => $dato->tipocuenta,
                                        'tipoTx' => array_search($dato->tipocuenta, $this->TiposCuentas),
                                        'old' => 0,
                                        'debe' => 0,
                                        'haber' => 0,
                                        'saldo' => 0,
                                        'Fechai' => $fechai,
                                        'Fechaf' => $fechaf
                                    );
                                }
                            }
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN GET HSITORIAL MONEY
    #---------------------------------------------------------------   BALANCE LIBRO DIARIO MAYOR
    public function indexBLMayor($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $this->iniciarUReportes();
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'Conta_jB3' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->load->view("mantenimiento_BLMayor", $this->data);//*/
        }
    }
    #   GET HSITORIAL MONEY
    public function getHistorialBLM()
    {
        if($this->validatePermiso()) {
            if ($this->input->is_ajax_request()) {
                $this->load->model('contabilidad_model');
                $fechai = $this->input->post("fechai");
                $fechaf = $this->input->post("fechaf");
                $Datos = null;
                if ($datos = $this->contabilidad_model->getAllCuentas()) {
                    if ($datos->num_rows() > 0) {
                        $Datos1 = $datos->result();
                        $Datos2 = $this->contabilidad_model->getAllCuentas3();
                        $haySaldos = $this->contabilidad_model->existensaldos();
                        if (($Datos2->num_rows() > 0) && ($haySaldos > 0)) {
                            foreach ($Datos1 as $dato1) {
                                $dato1->old = 0;
                                $dato1->debe = 0;
                                $dato1->haber = 0;
                                $dato1->saldo = 0;

                                if ($dato1->ctmayoriza == "") {
                                    $dato1->nivel = 1;
                                } else {
                                    $cuentaMayoriza = explode(',', $dato1->ctmayoriza)[0];
                                    $dato1->nivel = $this->getAccontLevels($cuentaMayoriza, $Datos1);
                                }
                            }
                            foreach ($Datos2->result() as $cuenta) {
                                $registros = $this->contabilidad_model->getSaldoCuenta($cuenta->idctcuenta, $fechaf);
                                /*print_r($registros->result());//*/
                                if ($registros->num_rows() > 0) {
                                    foreach ($registros->result() as $registro) {
                                        $min = new DateTime($fechai);
                                        $fecha = new DateTime($registro->fecha);
                                        if ($fecha >= $min) {
                                            $old = 0;
                                            $debe = $registro->debe;
                                            $haber = $registro->haber;
                                            //$saldo = ($cuenta->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                            $saldo = $this->getSTC($cuenta->catgrupo, $registro->debe, $registro->haber);
                                            //ingresar el saldo
                                        } else{
                                            //$old = ($cuenta->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                            $old = $this->getSTC($cuenta->catgrupo, $registro->debe, $registro->haber);
                                            $debe = 0;
                                            $haber = 0;
                                            $saldo = 0;
                                        }
                                        foreach ($Datos1 as $dato1) {
                                            if ($dato1->idctcuenta == $cuenta->idctcuenta) {
                                                $dato1->old += $old;
                                                $dato1->saldo += $saldo;
                                                $dato1->debe += $debe;
                                                $dato1->haber += $haber;
                                                foreach (explode(",", $cuenta->ctmayoriza) as $padre) {
                                                    foreach ($Datos1 as $daton) {
                                                        if($daton->idctcuenta == $padre) {
                                                            $daton->old += $old;
                                                            $daton->saldo += $saldo;
                                                            $daton->debe += $debe;
                                                            $daton->haber += $haber;
                                                            break;
                                                        }
                                                    }
                                                }
                                                break;
                                            }
                                        }//*/
                                    }
                                }
                            }
                            /*print_r($Datos1);
                            die();//*/
                            foreach ($Datos1 as $dato) {
                                if ($dato->tipocuenta != 3) {
                                    $Datos[] = array(
                                        'cuenta' => $dato->idctcuenta,
                                        'nivelCuenta' => $dato->nivel,
                                        'titulo' => $dato->descrip,
                                        'tipo' => $dato->tipocuenta,
                                        'tipoTx' => array_search($dato->tipocuenta, $this->TiposCuentas),
                                        'old' => $dato->old,
                                        'debe' => $dato->debe,
                                        'haber' => $dato->haber,
                                        'saldo' => $dato->old + $dato->saldo,
                                        'Fechai' => $fechai,
                                        'Fechaf' => $fechaf
                                    );
                                }
                            }//*/
                        } else {
                            foreach ($Datos1 as $dato) {
                                if ($dato->tipocuenta != 3) {
                                    $Datos[] = array(
                                        'cuenta' => $dato->idctcuenta,
                                        'nivelCuenta' => $dato->nivel,
                                        'titulo' => $dato->descrip,
                                        'tipo' => $dato->tipocuenta,
                                        'tipoTx' => array_search($dato->tipocuenta, $this->TiposCuentas),
                                        'old' => 0,
                                        'debe' => 0,
                                        'haber' => 0,
                                        'saldo' => 0,
                                        'Fechai' => $fechai,
                                        'Fechaf' => $fechaf
                                    );
                                }
                            }
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            } else show_404();
        }
    }
    #   FIN GET HISTORIAL MONEY
    #---------------------------------------------------------------   BALANCE LIBRO AUXILIAR
    public function indexBLA($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $this->iniciarUReportes();
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'Conta_jB4' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->load->view("mantenimiento_BLAuxiliar", $this->data);//Vista*/
        }
    }
    #---------------------------------------------------------------   BALANCE ESTADO DE RESULTADOS
    public function indexBEResultados($idApp)
    {
        if($this->validatePermiso()) {
            $this->load->model('configuracion_model');
            $this->iniciarUReportes();
            $appName = $this->configuracion_model->getAppName($idApp);
            date_default_timezone_set('America/El_Salvador');
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'Conta_jB4' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            $direccion = $this->uri->segment(1);
            $this->load->model('global_model');
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
            $this->data['fecha'] = date_create()->format('Y-m-d');
            $this->load->view("mantenimiento_BEResultados", $this->data);//*/
        }
    }
    #   GET HISTORIAL MONEY
    public function getHistorialBER()
    {
        if($this->validatePermiso()) {
            $this->load->model('contabilidad_model');
            $fechai = $this->input->post("fechai");
            $fechaf = $this->input->post("fechaf");
            $VMagia = ((int)$this->input->post('magia') == 1) ? true : false;
            $Datos = [];
            if ($datos = $this->contabilidad_model->getRCuentas45($fechai, $fechaf, $VMagia)) {
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $saldo = $this->getSTC($dato->catgrupo, $dato->debe, $dato->haber);
                        $Datos[] = array(
                            'cuenta' => $dato->cuenta,
                            'fecha' => $dato->fecha,
                            'auxiliar' => ($dato->idtabla != 0) ? ($this->contabilidad_model->getResponsable($dato->idauxi, $dato->idtabla)->descrip) : '',
                            'centro' => ($dato->centro != null) ? $dato->centro : '',
                            'proyecto' => ($dato->proyecto != null) ? $dato->proyecto : '',
                            //'tipo' => ($dato->catgrupo == 4) ? '02-Costos/Gastos' : '01-Ingresos',
                            'tipo' => $dato->ctcontrol.'-'.array_search($dato->ctcontrol, array_column($this->TControles, 'ID', 'Name')),
                            'saldo' => ($dato->catgrupo == 4) ? (-1 * $saldo) : $saldo,
                        );
                    }
                    if ($VMagia) {
                        $datosT10 = $this->contabilidad_model->getRCuentasT10($fechai, $fechaf);
                        $datosT40 = $this->contabilidad_model->getRCuentasT40($fechai, $fechaf);
                        if (($datosT10->num_rows() > 0) && ($datosT40->num_rows() > 0)) {
                            $datosCentros = [];
                            
                            $datosT10 = $datosT10->result();
                            $datosT40 = $datosT40->result();
                            $datot10i = $datosT10[0];
        
                            $yearActual = $datot10i->idyear;
                            $mesActual = $datot10i->idmes;
                            $centroActual = $datot10i->idcentro;
                            $objectf = new stdClass();
                            $objectf->year = $yearActual;
                            $objectf->mes = $mesActual;
                            $objectf->periodo = $yearActual.'/'.$mesActual;
                            $objectf->total = 0;
                            $objectf->ncentros = [$centroActual];
                            $saldo = $this->getSTC($datot10i->catgrupo, $datot10i->debe, $datot10i->haber);
                            $ncsaldo = 'sc'.$centroActual;
                            $objectf->{$ncsaldo} = $saldo;
                            $objectf->id = 1;
                            $datosCentros[] = $objectf;
                            $posicion = 0;
        
                            foreach ($datosT10 as $datot10) {
                                $datot10->saldo = $this->getSTC($datot10->catgrupo, $datot10->debe, $datot10->haber);
                                if ($datot10->idyear != $yearActual || $datot10->idmes != $mesActual) {
                                    $posicion++;
                                    $yearActual = $datot10->idyear;
                                    $mesActual = $datot10->idmes;
                                    $centroActual = $datot10->idcentro;
                                    $objectf = new stdClass();
                                    $objectf->year = $yearActual;
                                    $objectf->mes = $mesActual;
                                    $objectf->periodo = $yearActual.'/'.$mesActual;
                                    $objectf->total = $datot10->saldo;
                                    $objectf->ncentros = [$centroActual];
                                    $ncsaldo = 'sc'.$centroActual;
                                    $objectf->{$ncsaldo} = $datot10->saldo;
                                    $objectf->id = $posicion + 1;
                                    $datosCentros[] = $objectf;
                                } else {
                                    $datosCentros[$posicion]->total += $datot10->saldo;
                                    if ($datot10->idcentro != $centroActual) {
                                        $datosCentros[$posicion]->ncentros[] = $datot10->idcentro;
                                        $ncsaldo = 'sc'.$datot10->idcentro;
                                        $datosCentros[$posicion]->{$ncsaldo} = $datot10->saldo;
                                    }
                                }
                            }
                            
                            foreach ($datosCentros as $datocentro) {
                                foreach ($datocentro->ncentros as $idcentro) {
                                    $saldo = $datocentro->{'sc'.$idcentro};
                                    $datocentro->{'psc'.$idcentro} = $saldo / $datocentro->total;
                                }
                            }
                            //print_r($datosCentros);
                            //print_r($datosT40);
                            //die();
                            $DCentros = [];
                            $Datos40 = [];
                            foreach ($datosCentros as $datocentro) {
                                $DCentros[] = array(
                                    'id' => $datocentro->id,
                                    'periodo' => $datocentro->periodo,
                                );
                            }
                            foreach ($datosT40 as $datot40) {
                                $datot40->saldo = $this->getSTC($datot40->catgrupo, $datot40->debe, $datot40->haber);
                                $posicion = array_search(($datot40->idyear.'/'.$datot40->idmes), array_column($DCentros, 'periodo', 'id'));
                                if ($posicion != false) {
                                    foreach ($datosCentros[$posicion - 1]->ncentros as $idcentro) {
                                        //($datot40->idyear.'-'.(($datot40->idmes < 10) ? ('0'.$datot40->idmes) : $datot40->idmes).'-01')
                                        $lastday = (new DateTime(($datot40->idyear.'-'.(($datot40->idmes < 10) ? ('0'.$datot40->idmes) : $datot40->idmes).'-01')))->format('t');
                                        $dcentro = $this->contabilidad_model->getCentro($idcentro);
                                        $porcentaje = $datosCentros[$posicion -1]->{'psc'.$idcentro};
                                        $Nsaldo = $porcentaje * $datot40->saldo;
                                        $Datos40[] = array(
                                            'cuenta' => $datot40->cuenta,
                                            'fecha' => ($datot40->idyear.'-'.(($datot40->idmes < 10) ? ('0'.$datot40->idmes) : $datot40->idmes)).'-'.$lastday,
                                            'auxiliar' => '',
                                            'centro' => (count((array)$dcentro) > 0) ? $dcentro->descrip : '',
                                            'proyecto' => '',
                                            'tipo' => '40-Proporción Gastos Administrativos',
                                            'saldo' => $Nsaldo
                                        );
                                    }
                                }
                            }
                            
                            if (count($Datos40) > 0) {
                                foreach ($Datos40 as $dato40) {
                                    $Datos[] = $dato40;
                                }
                            }//*/
                        }//*/
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else $datA[] = array('valido' => false, 'tipo' => 1);
            } else $datA[] = array('valido' => false, 'tipo' => 0);
            echo json_encode($datA);
        }
    }
    #   ----------------------------------------------------------------------- REPORTE
    public function ConsultaGeneralR($IDR = null, $fechai = null, $fechaf = null, $Opc = 0, $VAux = 1, $idAuxi = 0, $cUtilidad = 0)
    {
        if($this->validatePermiso()) {
            if ($IDR != null && $fechai != null && $fechaf != null && ($Opc == 0 || $Opc == 1)) {
                if (is_numeric($IDR)) {
                    $valido = false;
                    if (preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechai) && preg_match("/^([0-9]){4}+(-)+([0-9]){2}+(-)+([0-9]){2}+$/", $fechaf)) {
                        $di = explode("-", $fechai);
                        $df = explode("-", $fechaf);
                        if(checkdate($di[1], $di[2], $di[0]) && checkdate($df[1], $df[2], $df[0])) $valido = true;
                    }
                    if ($valido) {
                        $this->load->model('contabilidad_model');
                        switch ($IDR) {
                            //  BALANCE GENERAL
                            case 0:
                                $this->CGReporteBGNew($fechai, $fechaf, $Opc, $cUtilidad);
                            break;
                            //  BALANCE COMPROBACION
                            case 1:
                                //$this->CGReporte1($fechai, $fechaf, $Opc);
                                $this->CGReporte1($fechai, $fechaf, $Opc, $VAux);
                            break;
                            //  ESTADO Y RESULTADOS
                            case 2:
                                //$this->CGReporte2($fechai, $fechaf);
                            break;
                            //  BALANCE DE LIBRO DIARIO MAYOR
                            case 3: 
                                $this->CGReporte3($fechai, $fechaf, $Opc);
                            break;
                            //  BALANCE DE LIBRO AUXILIAR
                            case 4: 
                                $this->CGReporte4($fechai, $fechaf, $Opc);
                            break;
                            case 5: 
                                $this->CGReporte5($fechai, $fechaf, $Opc, $VAux, $idAuxi);
                                //$this->CGReporte5New($fechai, $fechaf, $Opc, $VAux, $idAuxi);
                            break;
                            //  BALANCE DE LIBRO DIARIO MAYOR POR NIVELES
                            case 6: 
                                $this->CGReporte3Levels($fechai, $fechaf, $Opc, $VAux);
                            break;
                            /*case 5: 
                                $this->CGReporteBG($fechai, $fechaf);
                            break;//*/
                            default: 
                                show_404();
                            break;
                        }
                    }
                } else echo "<h1>Parámetro ID Incorrecto</h1>";
            } else echo "<h1>Faltan Parámetros</h1>";
        }
    }
    private function CGReporte($fechai, $fechaf)
    {
        $this->load->library('Pdfconta');
        $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
        $usuario = $this->session->userdata('userLog');
        $ffPartes = explode("-", $fechaf);
        $txtFecha = strtoupper('al '.$ffPartes[2].' de '.array_search((int)$ffPartes[1], $this->meses).' de '.$ffPartes[0]);
        $header = '
            <table style="width=100%; ">
                <tr style="font-size: 15px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                </tr>
                <tr style="font-size: 12px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; font-weight: bold;" >'.strtoupper($this->session->userdata("Conta_jB0")).'</td>
                </tr>
                <tr style="font-size: 11px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; font-weight: bold;">'.$txtFecha.'</td>
                </tr>
                <tr style="font-size: 11px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; text-decoration: underline;"><strong>CIFRAS PRESENTADA EN DOLARES DE LOS ESTADOS UNIDOS DE AMERICA</strong></td>
                </tr>
            </table>
        ';
        $pdf->setHtmlHeader($header);
        //header
        /*$footer = '
            <table style="width=100%; border-top: 1px solid black;">
                <tr style="line-height: 10px;"><td></td></tr>
                <tr style="font-size: 9px;">
                </tr>
            </table>
        ';
        $pdf->setHtmlFooter($footer);//*/
        //footer
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetTitle(''.$this->session->userdata("Conta_jB0"));
        $pdf->SetMargins(10, 20, 10);// left top right
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
        
        $html = '';
        $html .= '
            <table style="width=100%; font-family: Arial;">
                <tr style="line-height: 25px;"><td></td></tr>
                <tr style="text-align: center; font-size: 13px;">
                    <td style="width: 50%; text-decoration: underline;"><strong>ACTIVO</strong></td>
                    <td style="width: 50%; text-decoration: underline;"><strong>PASIVO</strong></td>
                </tr>
            </table>
            ';
        //datos
        $activo = 0;
        $pasivo = 0;

        $datos1 = $this->contabilidad_model->getCuentasRBG_G14();
        $Datos1 = null;
        if ($datos1->num_rows() > 0) {
            $Datos1 = $datos1->result();
            $datos13 = $this->contabilidad_model->getCuentas3RBG_G14();
            if ($datos13->num_rows() > 0) {
                foreach ($Datos1 as $dato1) {
                    $dato1->old = 0;
                    $dato1->debe = 0;
                    $dato1->haber = 0;
                    $dato1->saldo = 0;
                    $dato1->existe = 0;
                }
                foreach($datos13->result() as $dato13) {
                    $saldos1 = $this->contabilidad_model->getSaldoCuenta($dato13->idctcuenta, $fechaf);
                    if ($saldos1->num_rows() > 0) {
                        foreach ($saldos1->result() as $saldo1) {
                            $min = new DateTime($fechai);
                            $fecha = new DateTime($saldo1->fecha);
                            if ($fecha >= $min) {
                                $old = 0;
                                $debe = $saldo1->debe;
                                $haber = $saldo1->haber;
                                $saldo = $this->getSTC($dato13->catgrupo, $saldo1->debe, $saldo1->haber);
                            } else {
                                $old = $this->getSTC($dato13->catgrupo, $saldo1->debe, $saldo1->haber);
                                $debe = 0;
                                $haber = 0;
                                $saldo = 0;
                            }
                            foreach ($Datos1 as $dato1) {
                                if ($dato1->idctcuenta == $dato13->idctcuenta) {
                                    $dato1->old += $old;
                                    $dato1->saldo += $saldo;
                                    $dato1->debe += $debe;
                                    $dato1->haber += $haber;
                                    foreach (explode(",", $dato13->ctmayoriza) as $padre) {
                                        foreach ($Datos1 as $daton) {
                                            if($daton->idctcuenta == $padre) {
                                                $daton->old += $old;
                                                $daton->saldo += $saldo;
                                                $daton->debe += $debe;
                                                $daton->haber += $haber;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                foreach ($Datos1 as $dato1) {
                    if ($dato1->tipocuenta == 1) {
                        $activo += ($dato1->old + $dato1->saldo);
                    }
                }
            }
            /*foreach($Datos1 as $dato1){
                if($dato1->tipocuenta == 3){
                    $saldos1 = $this->contabilidad_model->getSaldoCuenta($dato1->idctcuenta, $fechaf);
                    if($saldos1->num_rows() > 0){
                        $dato1->existe = 1;
                        foreach($saldos1->result() as $saldo1){
                            $min = new DateTime($fechai);
                            $fecha = new DateTime($saldo1->fecha);
                            if ($fecha >= $min) {
                                $old = 0;
                                $debe = $saldo1->debe;
                                $haber = $saldo1->haber;
                                //$saldo = ($dato1->catgrupo == 1) ? ($saldo1->debe - $saldo1->haber) : ($saldo1->haber - $saldo1->debe);
                                $saldo = $this->getSTC($dato1->catgrupo, $saldo1->debe, $saldo1->haber);
                            } else {
                                //$old = ($dato1->catgrupo == 1) ? ($saldo1->debe - $saldo1->haber) : ($saldo1->haber - $saldo1->debe);
                                $old = $this->getSTC($dato1->catgrupo, $saldo1->debe, $saldo1->haber);
                                $debe = 0;
                                $haber = 0;
                                $saldo = 0;
                            }
                            foreach ($Datos1 as $dato11) {
                                if ($dato11->idctcuenta == $dato1->idctcuenta) {
                                    $dato11->old += $old;
                                    $dato11->saldo += $saldo;
                                    $dato11->debe += $debe;
                                    $dato11->haber += $haber;
                                    foreach (explode(",", $dato1->ctmayoriza) as $padre) {
                                        foreach ($Datos1 as $daton) {
                                            if($daton->idctcuenta == $padre) {
                                                $daton->old += $old;
                                                $daton->saldo += $saldo;
                                                $daton->debe += $debe;
                                                $daton->haber += $haber;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }//*/
        }

        $datos2 = $this->contabilidad_model->getCuentasRBG_G235();
        $Datos2 = null;
        if ($datos2->num_rows() > 0) {
            $Datos2 = $datos2->result();
            $datos23 = $this->contabilidad_model->getCuentas3RBG_G235();
            if ($datos23->num_rows() > 0) {
                foreach ($Datos2 as $dato2) {
                    $dato2->old = 0;
                    $dato2->debe = 0;
                    $dato2->haber = 0;
                    $dato2->saldo = 0;
                    $dato2->existe = 0;
                }
                foreach ($datos23->result() as $dato23) {
                    $saldos2 = $this->contabilidad_model->getSaldoCuenta($dato23->idctcuenta, $fechaf);
                    if ($saldos2->num_rows() > 0) {
                        foreach ($saldos2->result() as $saldo2) {
                            $min = new DateTime($fechai);
                            $fecha = new DateTime($saldo2->fecha);
                            if ($fecha >= $min) {
                                $old = 0;
                                $debe = $saldo2->debe;
                                $haber = $saldo2->haber;
                                $saldo = $this->getSTC($dato23->catgrupo, $saldo2->debe, $saldo2->haber);
                            } else {
                                $old = $this->getSTC($dato23->catgrupo, $saldo2->debe, $saldo2->haber);
                                $debe = 0;
                                $haber = 0;
                                $saldo = 0;
                            }
                            foreach ($Datos2 as $dato2) {
                                if ($dato2->idctcuenta == $dato23->idctcuenta) {
                                    $dato2->old += $old;
                                    $dato2->saldo += $saldo;
                                    $dato2->debe += $debe;
                                    $dato2->haber += $haber;
                                    foreach (explode(",", $dato23->ctmayoriza) as $padre) {
                                        foreach ($Datos2 as $daton) {
                                            if($daton->idctcuenta == $padre) {
                                                $daton->old += $old;
                                                $daton->saldo += $saldo;
                                                $daton->debe += $debe;
                                                $daton->haber += $haber;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                foreach ($Datos2 as $dato2) {
                    if ($dato2->tipocuenta == 1) {
                        $pasivo += ($dato2->old + $dato2->saldo);
                    }
                }
            }
            /*foreach ($Datos2 as $dato2) {
                if($dato2->tipocuenta == 3){
                    $saldos2 = $this->contabilidad_model->getSaldoCuenta($dato2->idctcuenta, $fechaf);
                    if($saldos2->num_rows() > 0){
                        $dato2->existe = 1;
                        foreach($saldos2->result() as $saldo2){
                            $min = new DateTime($fechai);
                            $fecha = new DateTime($saldo2->fecha);
                            if ($fecha >= $min) {
                                $old = 0;
                                $debe = $saldo2->debe;
                                $haber = $saldo2->haber;
                                //$saldo = ($dato2->catgrupo == 1) ? ($saldo2->debe - $saldo2->haber) : ($saldo2->haber - $saldo2->debe);
                                $saldo = $this->getSTC($dato2->catgrupo, $saldo2->debe, $saldo2->haber);
                            } else {
                                //$old = ($dato2->catgrupo == 1) ? ($saldo2->debe - $saldo2->haber) : ($saldo2->haber - $saldo2->debe);
                                $old = $this->getSTC($dato2->catgrupo, $saldo2->debe, $saldo2->haber);
                                $debe = 0;
                                $haber = 0;
                                $saldo = 0;
                            }
                            foreach ($Datos2 as $dato22) {
                                if ($dato22->idctcuenta == $dato2->idctcuenta) {
                                    $dato22->old += $old;
                                    $dato22->saldo += $saldo;
                                    $dato22->debe += $debe;
                                    $dato22->haber += $haber;
                                    foreach (explode(",", $dato2->ctmayoriza) as $padre) {
                                        foreach ($Datos2 as $daton) {
                                            if($daton->idctcuenta == $padre) {
                                                $daton->old += $old;
                                                $daton->saldo += $saldo;
                                                $daton->debe += $debe;
                                                $daton->haber += $haber;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }//*/
        }
        
        if ($Datos1 != null || $Datos2 != null) {
            $html .= '
            <table style=" width: 100%;" >
                <tr>
                    <td style="width: 50%;">
                        <table sytle="width: 100%;">
            ';
            if ($Datos1 != null) {
                foreach ($Datos1 as $dato1) {
                    if ($dato1->balview == 1) {
                        $html .= '<tr>';
                        $monto = $dato1->old + $dato1->saldo;
                        $monto = number_format((float)$monto, 2, '.', ',');
                        switch($dato1->tipocuenta) {
                            case 1: 
                                $html .= '
                                    <td style="width: 77%; font-weight: bold;" >'.$dato1->descrip.'</td>
                                    <td style="width: 20%; font-weight: bold; text-align: right;" >'.$monto.'</td>
                                    <td style="width: 3%;" ></td>
                                ';
                            break;
                            case 2: 
                                $html .= '
                                    <td style="width: 2%;" ></td>
                                    <td style="width: 71%; font-weight: bold;" >'.$dato1->descrip.'</td>
                                    <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                    <td style="width: 3%;" ></td>
                                ';
                            break;
                            case 3: 
                                $html .= '
                                    <td style="width: 3%;" ></td>
                                    <td style="width: 70%;" >'.$dato1->descrip.'</td>
                                    <td style="width: 17%; text-align: right;" >'.$monto.'</td>
                                    <td style="width: 10%;" ></td>
                                ';
                            break;
                        };
                        $html .= '</tr>';
                    }
                }//*/
            }
            $html .= '
                        </table>
                    </td>
                    <td style="width: 50%;">
                        <table sytle="width: 100%;">
            ';
            if ($Datos2 != null) {
                foreach ($Datos2 as $dato2) {
                    if ($dato2->balview == 1) {
                        $html .= '<tr>';
                        $monto = $dato2->old + $dato2->saldo;
                        $monto = number_format((float)$monto, 2, '.', ',');
                        switch($dato2->tipocuenta) {
                            case 1: 
                                $html .= '
                                    <td style="width: 77%; font-weight: bold;" >'.$dato2->descrip.'</td>
                                    <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                    <td style="width: 3%;" ></td>
                                ';
                            break;
                            case 2: 
                                $html .= '
                                    <td style="width: 2%;" ></td>
                                    <td style="width: 71%; font-weight: bold;" >'.$dato2->descrip.'</td>
                                    <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                    <td style="width: 3%;" ></td>
                                ';
                            break;
                            case 3: 
                                $html .= '
                                    <td style="width: 3%;" ></td>
                                    <td style="width: 70%;" >'.$dato2->descrip.'</td>
                                    <td style="width: 17%; text-align: right;" > '.$monto.'</td>
                                    <td style="width: 10%;" ></td>
                                ';
                            break;
                        };
                        $html .= '</tr>';
                    }
                }//*/
            }
            $html .='
                        </table>
                    </td>
                </tr>
            </table>
            ';
        }
        //  fin
        $representantes = $this->contabilidad_model->Representantes();
        $html .= '
            <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
            <table style="width=100%; padding-top: 2px; font-family: Calibri;">
                <tr style="text-align: right;">
                    <td style="width: 50%;">
                        <table sytle="width: 100%;">
                            <tr>
                                <td style="width: 77%; font-weight: bold;" >TOTAL ACTIVO </td>
                                <td style="width: 20%; font-weight: bold;" >'.$this->session->userdata('simboloMoneda').number_format((float)$activo, 2, '.', ',').'</td>
                                <td style="width: 3%;" ></td>
                            </tr>
                        </table>
                    </td>
                    <td style="width: 50%;">
                        <table sytle="width: 100%;">
                            <tr>
                                <td style="width: 77%; font-weight: bold;" >TOTAL PASIVO Y PATRIMONIO </td>
                                <td style="width: 20%; font-weight: bold;" >'.$this->session->userdata('simboloMoneda').number_format((float)$pasivo, 2, '.', ',').'</td>
                                <td style="width: 3%;" ></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            <table style="width=100%;"><tr style="line-height: 30px;"><td></td></tr></table>
            <table style="width=100%;">
                <tr style="font-size: 8px; line-height: 13px;">
                    <td style="width: 31%; border-top: 1px solid black; text-align: center;"> '.$representantes[0].'</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; border-top: 1px solid black; text-align: center;"> '.$representantes[1].'</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; border-top: 1px solid black; text-align: center;"> '.$representantes[2].'</td>
                </tr>
                <tr>
                    <td style="width: 31%; text-align: center;">Representante Legal</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; text-align: center;">Contador</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; text-align: center;">Auditor</td>
                </tr>
            </table>
        ';
        $pdf->writeHTML($html);
        $pdf->lastPage();
        $pdf->Output();
    }
    private function CGReporte1_OLD($fechai, $fechaf, $Opc)
    {
        $this->load->library('Pdfconta');
        $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
        $usuario = $this->session->userdata('userLog');
        $ffPartes = explode("-", $fechaf);
        $txtFecha = strtoupper('al '.$ffPartes[2].' de '.array_search((int)$ffPartes[1], $this->meses).' de '.$ffPartes[0]);
        $header = '
            <table style="width=100%; ">
                <tr style="font-size: 15px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                </tr>
                <tr style="font-size: 12px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; font-weight: bold;" >'.strtoupper($this->session->userdata("Conta_jB1")).'</td>
                </tr>
                <tr style="font-size: 11px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; font-weight: bold;">'.$txtFecha.'</td>
                </tr>
                <tr style="font-size: 11px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; text-decoration: underline;"><strong>CIFRAS PRESENTADA EN DOLARES DE LOS ESTADOS UNIDOS DE AMERICA</strong></td>
                </tr>
            </table>
            <table style="width=100%; font-family: Arial;">
                <tr style="line-height: 10px;"><td></td></tr>
                <tr style="text-align: center; font-size: 10px; ">
                    <td style="width: 12%; font-weight: bold; border-top: 1px solid black; border-bottom: 1px solid black; border-left: 1px solid black; border-right: 1px solid black; line-height: 25px;" >Cuenta</td>
                    <td style="width: 44%; font-weight: bold; border-top: 1px solid black; border-bottom: 1px solid black; border-left: 1px solid black; line-height: 25px;" >Titulo de Cuenta</td>
                    <td style="width: 11%; font-weight: bold; border-top: 1px solid black; border-bottom: 1px solid black; border-left: 1px solid black;" >Saldo Anterior</td>
                    <td style="width: 11%; font-weight: bold; border-top: 1px solid black; border-bottom: 1px solid black; border-left: 1px solid black; line-height: 25px;" >Debe</td>
                    <td style="width: 11%; font-weight: bold; border-top: 1px solid black; border-bottom: 1px solid black; border-left: 1px solid black; line-height: 25px;" >Haber</td>
                    <td style="width: 11%; font-weight: bold; border-top: 1px solid black; border-bottom: 1px solid black; border-left: 1px solid black; border-right: 1px solid black;" >  Saldo Actual</td>
                </tr>
            </table>
        ';
        $pdf->setHtmlHeader($header);
        //header
        //footer
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetTitle(''.$this->session->userdata("Conta_jB1"));
        $pdf->SetMargins(10, 40, 10);// left top right
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
        
        //datos
        $debeF = 0;
        $haberF = 0;
        $html = '';
        $Datos = null;
        $datos = $this->contabilidad_model->getAllCuentas();
        if ($datos->num_rows() > 0) {
            $Datos1 = $datos->result();
            $Datos2 = $this->contabilidad_model->getAllCuentas3();
            $haySaldos = $this->contabilidad_model->existensaldos();
            if (($Datos2->num_rows() > 0) && ($haySaldos > 0)) { 
                foreach ($Datos1 as $dato1) {
                    $dato1->old = 0;
                    $dato1->debe = 0;
                    $dato1->haber = 0;
                    $dato1->saldo = 0;
                }
                foreach ($Datos2->result() as $cuenta) {
                    $registros = $this->contabilidad_model->getSaldoCuenta($cuenta->idctcuenta, $fechaf);
                    //print_r($registros->result());
                    if ($registros->num_rows() > 0) {
                        foreach ($registros->result() as $registro) {
                            $min = new DateTime($fechai);
                            $fecha = new DateTime($registro->fecha);
                            if ($fecha >= $min) {
                                $old = 0;
                                $debe = $registro->debe;
                                $haber = $registro->haber;
                                //$saldo = ($cuenta->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                $saldo = $this->getSTC($cuenta->catgrupo, $registro->debe, $registro->haber);
                                //ingresar el saldo
                            } else{
                                //$old = ($cuenta->catgrupo == 1) ? ($registro->debe - $registro->haber) : ($registro->haber - $registro->debe);
                                $old = $this->getSTC($cuenta->catgrupo, $registro->debe, $registro->haber);
                                $debe = 0;
                                $haber = 0;
                                $saldo = 0;
                            }
                            foreach ($Datos1 as $dato1) {
                                if ($dato1->idctcuenta == $cuenta->idctcuenta) {
                                    $dato1->old += $old;
                                    $dato1->saldo += $saldo;
                                    $dato1->debe += $debe;
                                    $dato1->haber += $haber;
                                    foreach (explode(",", $cuenta->ctmayoriza) as $padre) {
                                        foreach ($Datos1 as $daton) {
                                            if($daton->idctcuenta == $padre) {
                                                $daton->old += $old;
                                                $daton->saldo += $saldo;
                                                $daton->debe += $debe;
                                                $daton->haber += $haber;
                                            }
                                        }
                                    }
                                }
                            }//*/
                        }
                    }
                }
                //-
                foreach ($Datos1 as $dato) {
                    $dato->nsaldo = $dato->old + $dato->saldo; 
                    $Datos[] = $dato;
                }
            } else {
                foreach ($Datos1 as $dato) {
                    $dato->old = 0;
                    $dato->debe = 0;
                    $dato->haber = 0;
                    $dato->saldo = 0;
                    $dato->nsaldo = 0;
                    $Datos[] = $dato;
                }
            }
        }

        if ($Datos != null) {
            $html .= '<table style="width: 100%; " >';
            foreach ($Datos as $dato) {
                $VZero = ($Opc == 0) ? true : ((($dato->old != 0) || ($dato->debe != 0) || ($dato->haber != 0)) ? true : false);
                if ($VZero) {
                    $fuente = ($dato->tipocuenta != 3) ? 'font-weight: bold;' : '';
                    $html .= '
                        <tr>
                            <td style="width: 12%; '.$fuente.'" >'.$dato->idctcuenta.'</td>
                            <td style="width: 44%; '.$fuente.'" >'.$dato->descrip.'</td>
                            <td style="width: 11%; '.$fuente.' text-align: right;" >'.number_format((float)$dato->old, 2, '.', ',').'</td>
                            <td style="width: 11%; '.$fuente.' text-align: right;" >'.number_format((float)$dato->debe, 2, '.', ',').'</td>
                            <td style="width: 11%; '.$fuente.' text-align: right;" >'.number_format((float)$dato->haber, 2, '.', ',').'</td>
                            <td style="width: 11%; '.$fuente.' text-align: right;" >'.number_format((float)$dato->nsaldo, 2, '.', ',').'</td>
                        </tr>
                    ';
                    if ($dato->tipocuenta == 3) {
                        $debeF += $dato->debe;
                        $haberF += $dato->haber;
                    }
                }
            }
            $html .= '</table>';
        } //else $html .='<table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>';

        //  fin
        $representantes = $this->contabilidad_model->Representantes();
        $html .= '
            <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
            <table style="width=100%; padding-top: 2px; font-family: Calibri;">
                <tr style="text-align: right;">
                    <td style="width: 12%; font-weight: bold;"></td>
                    <td style="width: 44%; font-weight: bold;"></td>
                    <td style="width: 11%; font-weight: bold;">TOTALES</td>
                    <td style="width: 11%; font-weight: bold;" >'.$this->session->userdata('simboloMoneda').number_format((float)$debeF, 2, '.', ',').'</td>
                    <td style="width: 11%; font-weight: bold;" >'.$this->session->userdata('simboloMoneda').number_format((float)$haberF, 2, '.', ',').'</td>
                    <td style="width: 11%; font-weight: bold;"></td>
                </tr>
            </table>
            <table style="width=100%;"><tr style="line-height: 30px;"><td></td></tr></table>
            <table style="width=100%;">
                <tr style="font-size: 8px; line-height: 13px;">
                    <td style="width: 31%; border-top: 1px solid black; text-align: center;"> '.$representantes[0].'</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; border-top: 1px solid black; text-align: center;"> '.$representantes[1].'</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; border-top: 1px solid black; text-align: center;"> '.$representantes[2].'</td>
                </tr>
                <tr>
                    <td style="width: 31%; text-align: center;">Representante Legal</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; text-align: center;">Contador</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; text-align: center;">Auditor</td>
                </tr>
            </table>
        ';
        $pdf->writeHTML($html);
        $pdf->lastPage();
        $pdf->Output();
    }
    #-----
    private function CGReporteBGOld1($fechai, $fechaf, $Opc)
    {
        $this->load->library('Pdfconta');
        $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
        $usuario = $this->session->userdata('userLog');
        $ffPartes = explode("-", $fechaf);
        $txtFecha = strtoupper('al '.$ffPartes[2].' de '.array_search((int)$ffPartes[1], $this->meses).' de '.$ffPartes[0]);
        $header = '
            <table style="width=100%; ">
                <tr style="font-size: 15px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                </tr>
                <tr style="font-size: 12px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; font-weight: bold;" >'.strtoupper($this->session->userdata("Conta_jB0")).'</td>
                </tr>
                <tr style="font-size: 11px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; font-weight: bold;">'.$txtFecha.'</td>
                </tr>
                <tr style="font-size: 11px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; text-decoration: underline;"><strong>CIFRAS PRESENTADA EN '. (($this->session->userdata('idaccount') == 371571) ? 'CORDOBAS' : 'DOLARES DE LOS ESTADOS UNIDOS DE AMERICA') .'</strong></td>
                </tr>
            </table>
        ';
        $pdf->setHtmlHeader($header);
        //header
        /*$footer = '
            <table style="width=100%; border-top: 1px solid black;">
                <tr style="line-height: 10px;"><td></td></tr>
                <tr style="font-size: 9px;">
                </tr>
            </table>
        ';
        $pdf->setHtmlFooter($footer);//*/
        //footer
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetTitle(''.$this->session->userdata("Conta_jB0"));
        $pdf->SetMargins(10, 20, 10);// left top right
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
        
        $html = '';
        $html .= '
            <table style="width=100%; font-family: Arial;">
                <tr style="line-height: 25px;"><td></td></tr>
                <tr style="text-align: center; font-size: 13px;">
                    <td style="width: 50%; text-decoration: underline;"><strong>ACTIVO</strong></td>
                    <td style="width: 50%; text-decoration: underline;"><strong>PASIVO</strong></td>
                </tr>
            </table>
        ';
        //datos
        $activo = 0;
        $pasivo = 0;
        $DatosAll = $this->contabilidad_model->getCuentasRBG_G12345();
        $Datos = null;
        $hijo31 = $this->contabilidad_model->existe_padre_hijo_property(3, 3, 6);
        $hijo32 = $this->contabilidad_model->existe_padre_hijo_property(3, 3, 7);
        $padre4 = $this->contabilidad_model->existe_padre_hijo_property(1, 4, null);
        $padre5 = $this->contabilidad_model->existe_padre_hijo_property(1, 5, null);
        $Datos1 = [];
        $Datos2 = [];
        $Datos3 = [];
        if ($hijo31 && $hijo32 && $padre4 && $padre5) {
            if ($DatosAll->num_rows() > 0) {
                $Datos = $DatosAll->result();
                $datos = $this->contabilidad_model->getCuentas3RBG_G12345();
                if ($datos->num_rows() > 0) {
                    foreach ($Datos as $dato) {
                        $dato->old = 0;
                        $dato->debe = 0;
                        $dato->haber = 0;
                        $dato->saldo = 0;
                        $dato->existe = 0;
                    }
                    foreach ($datos->result() as $dato3) {
                        $saldos = $this->contabilidad_model->getSaldoCuenta($dato3->idctcuenta, $fechaf);
                        if ($saldos->num_rows() > 0) {
                            foreach ($saldos->result() as $saldo) {
                                $min = new DateTime($fechai);
                                $fecha = new DateTime($saldo->fecha);
                                if ($fecha >= $min) {
                                    $old = 0;
                                    $debe = $saldo->debe;
                                    $haber = $saldo->haber;
                                    $saldo = $this->getSTC($dato3->catgrupo, $saldo->debe, $saldo->haber);
                                } else {
                                    $old = $this->getSTC($dato3->catgrupo, $saldo->debe, $saldo->haber);
                                    $debe = 0;
                                    $haber = 0;
                                    $saldo = 0;
                                }
                                foreach ($Datos as $dato) {
                                    if ($dato->idctcuenta == $dato3->idctcuenta) {
                                        $dato->old += $old;
                                        $dato->saldo += $saldo;
                                        $dato->debe += $debe;
                                        $dato->haber += $haber;
                                        foreach (explode(",", $dato3->ctmayoriza) as $padre) {
                                            foreach ($Datos as $daton) {
                                                if($daton->idctcuenta == $padre) {
                                                    $daton->old += $old;
                                                    $daton->saldo += $saldo;
                                                    $daton->debe += $debe;
                                                    $daton->haber += $haber;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    foreach ($Datos as $dato) {
                        $dato->nsaldo = ($dato->old + $dato->saldo);
                    }
                    //-
                    $valor4 = 0; // DEUDORA
                    $valor5 = 0; // ACREEDORA
                    foreach ($Datos as $dato) {
                        if ($dato->catgrupo == 4 && $dato->tipocuenta == 1) $valor4 = $dato->nsaldo;
                        if ($dato->catgrupo == 5 && $dato->tipocuenta == 1) $valor5 = $dato->nsaldo;
                    }
                    $valor54 = $valor5 - $valor4;
                    foreach ($Datos as $dato) {
                        $control = ($valor54 > 0) ? 6 : 7;
                        if ($dato->catgrupo == 3 && $dato->ctcontrol == $control && $dato->tipocuenta == 3) 
                        {
                            $vold = $dato->nsaldo;
                            $dato->nsaldo = $valor54;
                            foreach (explode(",", $dato->ctmayoriza) as $padre) {
                                foreach ($Datos as $daton) {
                                    if($daton->idctcuenta == $padre) {
                                        $daton->nsaldo = $daton->nsaldo - $vold;
                                        $daton->nsaldo = $daton->nsaldo + $valor54;
                                        break;
                                    }
                                }
                            }
                            break;
                        }
                    }
                    //-
                    foreach ($Datos as $dato) {
                        switch ($dato->catgrupo) {
                            case 1:
                                $Datos1[] = $dato;
                                if ($dato->tipocuenta == 1) $activo += $dato->nsaldo;
                            break;
                            case 2:
                                $Datos2[] = $dato;
                                if ($dato->tipocuenta == 1) $pasivo += $dato->nsaldo;
                            break;
                            case 3:
                                $Datos3[] = $dato;
                                if ($dato->tipocuenta == 1) $pasivo += $dato->nsaldo;
                            break;
                        }
                    }
                    //echo $activo."<br>";
                    //echo $pasivo."<br>";
                }
            }
            #   DATOS
            if ($Datos != null) {
                $html .= '
                    <table style=" width: 100%;" >
                        <tr>
                            <td style="width: 50%;">
                                <table sytle="width: 100%;">
                ';
                if (count($Datos1) > 0) {
                    foreach ($Datos1 as $dato) {
                        $VZero = ($Opc == 0) ? true : (($dato->nsaldo != 0) ? true : false);
                        if ($dato->balview == 1 && $VZero) {
                            $html .= '<tr>';
                            $monto = $dato->nsaldo;
                            $monto = number_format((float)$monto, 2, '.', ',');
                            switch($dato->tipocuenta) {
                                case 1: 
                                    $html .= '
                                        <td style="width: 77%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; font-weight: bold; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 2: 
                                    $html .= '
                                        <td style="width: 2%;" ></td>
                                        <td style="width: 71%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 3: 
                                    $html .= '
                                        <td style="width: 3%;" ></td>
                                        <td style="width: 70%;" >'.$dato->descrip.'</td>
                                        <td style="width: 17%; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 10%;" ></td>
                                    ';
                                break;
                            };
                            $html .= '</tr>';
                        }
                    }
                }
                $html .= '
                                </table>
                            </td>
                            <td style="width: 50%;">
                                <table sytle="width: 100%;">
                ';
                if ((count($Datos2) > 0) || (count($Datos3) > 0)) {
                    foreach ($Datos2 as $dato) {
                        $VZero = ($Opc == 0) ? true : (($dato->nsaldo != 0) ? true : false);
                        if ($dato->balview == 1 && $VZero) {
                            $html .= '<tr>';
                            $monto = $dato->nsaldo;
                            $monto = number_format((float)$monto, 2, '.', ',');
                            switch($dato->tipocuenta) {
                                case 1: 
                                    $html .= '
                                        <td style="width: 77%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; font-weight: bold; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 2: 
                                    $html .= '
                                        <td style="width: 2%;" ></td>
                                        <td style="width: 71%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 3: 
                                    $html .= '
                                        <td style="width: 3%;" ></td>
                                        <td style="width: 70%;" >'.$dato->descrip.'</td>
                                        <td style="width: 17%; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 10%;" ></td>
                                    ';
                                break;
                            };
                            $html .= '</tr>';
                        }
                    }
                    $html .= '<tr><td style="width: 100%; text-decoration: underline; font-size: 12px; text-align: center;"><strong>PATRIMONIO</strong></td></tr>';
                    foreach ($Datos3 as $dato) {
                        $VZero = ($Opc == 0) ? true : (($dato->nsaldo != 0) ? true : false);
                        if ($dato->balview == 1 && $VZero) {
                            $html .= '<tr>';
                            $monto = $dato->nsaldo;
                            $monto = number_format((float)$monto, 2, '.', ',');
                            switch($dato->tipocuenta) {
                                case 1: 
                                    $html .= '
                                        <td style="width: 77%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; font-weight: bold; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 2: 
                                    $html .= '
                                        <td style="width: 2%;" ></td>
                                        <td style="width: 71%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 3: 
                                    $html .= '
                                        <td style="width: 3%;" ></td>
                                        <td style="width: 70%;" >'.$dato->descrip.'</td>
                                        <td style="width: 17%; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 10%;" ></td>
                                    ';
                                break;
                            };
                            $html .= '</tr>';
                        }
                    }
                }
                $html .='
                                </table>
                            </td>
                        </tr>
                    </table>
                ';
            }
        }else {
            $html .= '
                <table style="width=100%; font-family: Arial;">
                    <tr style="text-align: center; font-size: 13px;">
                        <td style="font-weight: bold; color: red;">*** No se pueden calcular utilidades o perdidas del periodo</td>
                    </tr>
                </table>
            ';
        }
        //  fin
        $representantes = $this->contabilidad_model->Representantes();
        $html .= '
            <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
            <table style="width=100%; padding-top: 2px; font-family: Calibri;">
                <tr style="text-align: right;">
                    <td style="width: 50%;">
                        <table sytle="width: 100%;">
                            <tr>
                                <td style="width: 73%; font-weight: bold;" >TOTAL ACTIVO </td>
                                <td style="width: 24%; font-weight: bold;" >'.$this->session->userdata('simboloMoneda').number_format((float)$activo, 2, '.', ',').'</td>
                                <td style="width: 3%;" ></td>
                            </tr>
                        </table>
                    </td>
                    <td style="width: 50%;">
                        <table sytle="width: 100%;">
                            <tr>
                                <td style="width: 73%; font-weight: bold;" >TOTAL PASIVO Y PATRIMONIO </td>
                                <td style="width: 24%; font-weight: bold;" >'.$this->session->userdata('simboloMoneda').number_format((float)$pasivo, 2, '.', ',').'</td>
                                <td style="width: 3%;" ></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            <table style="width=100%;"><tr style="line-height: 30px;"><td></td></tr></table>
            <table style="width=100%;">
                <tr style="font-size: 8px; line-height: 13px;">
                    <td style="width: 31%; border-top: 1px solid black; text-align: center;"> '.$representantes[0].'</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; border-top: 1px solid black; text-align: center;"> '.$representantes[1].'</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; border-top: 1px solid black; text-align: center;"> '.$representantes[2].'</td>
                </tr>
                <tr>
                    <td style="width: 31%; text-align: center;">Representante Legal</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; text-align: center;">Contador</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; text-align: center;">Auditor</td>
                </tr>
            </table>
        ';
        $pdf->writeHTML($html);
        $pdf->lastPage();
        $pdf->Output();
    }

    private function CGReporteBG($fechai, $fechaf, $Opc)
    {
        $this->load->library('Pdfconta');
        $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
        $usuario = $this->session->userdata('userLog');
        $ffPartes = explode("-", $fechaf);
        $txtFecha = strtoupper('al '.$ffPartes[2].' de '.array_search((int)$ffPartes[1], $this->meses).' de '.$ffPartes[0]);
        $header = '
            <table style="width=100%; ">
                <tr style="font-size: 15px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                </tr>
                <tr style="font-size: 12px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; font-weight: bold;" >'.strtoupper($this->session->userdata("Conta_jB0")).'</td>
                </tr>
                <tr style="font-size: 11px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; font-weight: bold;">'.$txtFecha.'</td>
                </tr>
                <tr style="font-size: 11px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; text-decoration: underline;"><strong>CIFRAS PRESENTADA '. (($this->session->userdata('idaccount') == 371571) ? 'CORDOBAS' : 'DOLARES DE LOS ESTADOS UNIDOS DE AMERICA') .'</strong></td>
                </tr>
            </table>
        ';
        $pdf->setHtmlHeader($header);
        //header
        /*$footer = '
            <table style="width=100%; border-top: 1px solid black;">
                <tr style="line-height: 10px;"><td></td></tr>
                <tr style="font-size: 9px;">
                </tr>
            </table>
        ';
        $pdf->setHtmlFooter($footer);//*/
        //footer
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetTitle(''.$this->session->userdata("Conta_jB0"));
        $pdf->SetMargins(10, 27, 10);// left top right
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
        
        $html = '';
        $html .= '
            <table style="width=100%; font-family: Arial;">
                <tr style="line-height: 25px;"><td></td></tr>
                <tr style="text-align: center; font-size: 13px;">
                    <td style="width: 50%; text-decoration: underline;"><strong>ACTIVO</strong></td>
                    <td style="width: 50%; text-decoration: underline;"><strong>PASIVO</strong></td>
                </tr>
            </table>
        ';
        //datos
        $activo = 0;
        $pasivo = 0;
        $DatosAll = $this->contabilidad_model->getCuentasRBG_G12345();
        $Datos = null;
        $hijo31 = $this->contabilidad_model->existe_padre_hijo_property(3, 3, 6);
        $hijo32 = $this->contabilidad_model->existe_padre_hijo_property(3, 3, 7);
        $padre4 = $this->contabilidad_model->existe_padre_hijo_property(1, 4, null);
        $padre5 = $this->contabilidad_model->existe_padre_hijo_property(1, 5, null);
        $Datos1 = [];
        $Datos2 = [];
        $Datos3 = [];
        if ($hijo31 && $hijo32 && $padre4 && $padre5) {
            if ($DatosAll->num_rows() > 0) {
                $Datos = $DatosAll->result();
                $datos = $this->contabilidad_model->getCuentas3RBG_G12345();
                if ($datos->num_rows() > 0) {
                    foreach ($Datos as $dato) {
                        $dato->old = 0;
                        $dato->debe = 0;
                        $dato->haber = 0;
                        $dato->saldo = 0;
                        $dato->existe = 0;
                    }
                    foreach ($datos->result() as $dato3) {
                        $saldos = $this->contabilidad_model->getSaldoCuenta($dato3->idctcuenta, $fechaf);
                        if ($saldos->num_rows() > 0) {
                            foreach ($saldos->result() as $saldo) {
                                $min = new DateTime($fechai);
                                $fecha = new DateTime($saldo->fecha);
                                if ($fecha >= $min) {
                                    $old = 0;
                                    $debe = $saldo->debe;
                                    $haber = $saldo->haber;
                                    $saldo = $this->getSTC($dato3->catgrupo, $saldo->debe, $saldo->haber);
                                } else {
                                    $old = $this->getSTC($dato3->catgrupo, $saldo->debe, $saldo->haber);
                                    $debe = 0;
                                    $haber = 0;
                                    $saldo = 0;
                                }
                                foreach ($Datos as $dato) {
                                    if ($dato->idctcuenta == $dato3->idctcuenta) {
                                        $dato->old += $old;
                                        $dato->saldo += $saldo;
                                        $dato->debe += $debe;
                                        $dato->haber += $haber;
                                        foreach (explode(",", $dato3->ctmayoriza) as $padre) {
                                            foreach ($Datos as $daton) {
                                                if($daton->idctcuenta == $padre) {
                                                    $daton->old += $old;
                                                    $daton->saldo += $saldo;
                                                    $daton->debe += $debe;
                                                    $daton->haber += $haber;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    foreach ($Datos as $dato) {
                        $dato->nsaldo = ($dato->old + $dato->saldo);
                    }
                    //-
                    $valor4 = 0; // DEUDORA
                    $valor5 = 0; // ACREEDORA
                    foreach ($Datos as $dato) {
                        if ($dato->catgrupo == 4 && $dato->tipocuenta == 1) $valor4 = $dato->nsaldo;
                        if ($dato->catgrupo == 5 && $dato->tipocuenta == 1) $valor5 = $dato->nsaldo;
                    }
                    $valor54 = $valor5 - $valor4;
                    foreach ($Datos as $dato) {
                        $control = ($valor54 > 0) ? 6 : 7;
                        if ($dato->catgrupo == 3 && $dato->ctcontrol == $control && $dato->tipocuenta == 3) 
                        {
                            $vold = $dato->nsaldo;
                            $dato->nsaldo = $valor54;
                            foreach (explode(",", $dato->ctmayoriza) as $padre) {
                                foreach ($Datos as $daton) {
                                    if($daton->idctcuenta == $padre) {
                                        $daton->nsaldo = $daton->nsaldo - $vold;
                                        $daton->nsaldo = $daton->nsaldo + $valor54;
                                        break;
                                    }
                                }
                            }
                            break;
                        }
                    }
                    //-
                    foreach ($Datos as $dato) {
                        switch ($dato->catgrupo) {
                            case 1:
                                $Datos1[] = $dato;
                                if ($dato->tipocuenta == 1) $activo += $dato->nsaldo;
                            break;
                            case 2:
                                $Datos2[] = $dato;
                                if ($dato->tipocuenta == 1) $pasivo += $dato->nsaldo;
                            break;
                            case 3:
                                $Datos3[] = $dato;
                                if ($dato->tipocuenta == 1) $pasivo += $dato->nsaldo;
                            break;
                        }
                    }
                    //echo $activo."<br>";
                    //echo $pasivo."<br>";
                }
            }
            #   DATOS
            if ($Datos != null) {
                $html .= '
                    <table style=" width: 100%;" >
                        <tr>
                            <td style="width: 50%;">
                                <table sytle="width: 100%;">
                ';
                if (count($Datos1) > 0) {
                    foreach ($Datos1 as $dato) {
                        $VZero = ($Opc == 0) ? true : (($dato->nsaldo != 0) ? true : false);
                        if ($dato->balview == 1 && $VZero) {
                            $html .= '<tr>';
                            $monto = $dato->nsaldo;
                            $monto = number_format((float)$monto, 2, '.', ',');
                            switch($dato->tipocuenta) {
                                case 1: 
                                    $html .= '
                                        <td style="width: 77%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; font-weight: bold; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 2: 
                                    $html .= '
                                        <td style="width: 2%;" ></td>
                                        <td style="width: 71%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 3: 
                                    $html .= '
                                        <td style="width: 3%;" ></td>
                                        <td style="width: 70%;" >'.$dato->descrip.'</td>
                                        <td style="width: 17%; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 10%;" ></td>
                                    ';
                                break;
                            };
                            $html .= '</tr>';
                        }
                    }
                }
                $html .= '
                                </table>
                            </td>
                            <td style="width: 50%;">
                                <table sytle="width: 100%;">
                ';
                if ((count($Datos2) > 0) || (count($Datos3) > 0)) {
                    foreach ($Datos2 as $dato) {
                        $VZero = ($Opc == 0) ? true : (($dato->nsaldo != 0) ? true : false);
                        if ($dato->balview == 1 && $VZero) {
                            $html .= '<tr>';
                            $monto = $dato->nsaldo;
                            $monto = number_format((float)$monto, 2, '.', ',');
                            switch($dato->tipocuenta) {
                                case 1: 
                                    $html .= '
                                        <td style="width: 77%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; font-weight: bold; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 2: 
                                    $html .= '
                                        <td style="width: 2%;" ></td>
                                        <td style="width: 71%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 3: 
                                    $html .= '
                                        <td style="width: 3%;" ></td>
                                        <td style="width: 70%;" >'.$dato->descrip.'</td>
                                        <td style="width: 17%; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 10%;" ></td>
                                    ';
                                break;
                            };
                            $html .= '</tr>';
                        }
                    }
                    $html .= '<tr><td style="width: 100%; text-decoration: underline; font-size: 12px; text-align: center;"><strong>PATRIMONIO</strong></td></tr>';
                    foreach ($Datos3 as $dato) {
                        $VZero = ($Opc == 0) ? true : (($dato->nsaldo != 0) ? true : false);
                        if ($dato->balview == 1 && $VZero) {
                            $html .= '<tr>';
                            $monto = $dato->nsaldo;
                            $monto = number_format((float)$monto, 2, '.', ',');
                            switch($dato->tipocuenta) {
                                case 1: 
                                    $html .= '
                                        <td style="width: 77%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; font-weight: bold; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 2: 
                                    $html .= '
                                        <td style="width: 2%;" ></td>
                                        <td style="width: 71%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 3: 
                                    $html .= '
                                        <td style="width: 3%;" ></td>
                                        <td style="width: 65%;" >'.$dato->descrip.'</td>
                                        <td style="width: 22%; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 10%;" ></td>
                                    ';
                                break;
                            };
                            $html .= '</tr>';
                        }
                    }
                }
                $html .='
                                </table>
                            </td>
                        </tr>
                    </table>
                ';
            }
        }else {
            $html .= '
                <table style="width=100%; font-family: Arial;">
                    <tr style="text-align: center; font-size: 13px;">
                        <td style="font-weight: bold; color: red;">*** No se pueden calcular utilidades o perdidas del periodo</td>
                    </tr>
                </table>
            ';
        }
        //  fin
        $representantes = $this->contabilidad_model->Representantes();
        $html .= '
            <table style="width=100%;"><tr style="line-height: 10px;"><td></td></tr></table>
            <table style="width=100%; padding-top: 2px; font-family: Calibri;">
                <tr style="text-align: right;">
                    <td style="width: 50%;">
                        <table sytle="width: 100%;">
                            <tr>
                                <td style="width: 73%; font-weight: bold;" >TOTAL ACTIVO </td>
                                <td style="width: 24%; font-weight: bold;" >'.$this->session->userdata('simboloMoneda').number_format((float)$activo, 2, '.', ',').'</td>
                                <td style="width: 3%;" ></td>
                            </tr>
                        </table>
                    </td>
                    <td style="width: 50%;">
                        <table sytle="width: 100%;">
                            <tr>
                                <td style="width: 73%; font-weight: bold;" >TOTAL PASIVO Y PATRIMONIO </td>
                                <td style="width: 24%; font-weight: bold;" >'.$this->session->userdata('simboloMoneda').number_format((float)$pasivo, 2, '.', ',').'</td>
                                <td style="width: 3%;" ></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            <table style="width=100%;"><tr style="line-height: 30px;"><td></td></tr></table>
            <table style="width=100%;">
                <tr style="font-size: 8px; line-height: 13px;">
                    <td style="width: 31%; border-top: 1px solid black; text-align: center;"> '.$representantes[0].'</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; border-top: 1px solid black; text-align: center;"> '.$representantes[1].'</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; border-top: 1px solid black; text-align: center;"> '.$representantes[2].'</td>
                </tr>
                <tr>
                    <td style="width: 31%; text-align: center;">Representante Legal</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; text-align: center;">Contador</td>
                    <td style="width: 3%;"></td>
                    <td style="width: 30%; text-align: center;">Auditor</td>
                </tr>
            </table>
        ';
        $pdf->writeHTML($html);
        $pdf->lastPage();
        $pdf->Output();
    }

    private function CGReporteBGNew($fechai, $fechaf, $Opc, $cUtilidad)
    {
        $this->load->library('Pdfconta');
        $pdf = new Pdfconta(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $empresa = $this->contabilidad_model->nombreEmpresa()->valor_memo;
        $usuario = $this->session->userdata('userLog');
        $ffPartes = explode("-", $fechaf);
        $txtFecha = strtoupper('al '.$ffPartes[2].' de '.array_search((int)$ffPartes[1], $this->meses).' de '.$ffPartes[0]);
        $header = '
            <table style="width=100%; ">
                <tr style="font-size: 15px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center;"><strong>'.$empresa.'</strong></td>
                </tr>
                <tr style="font-size: 12px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; font-weight: bold;" >'.strtoupper($this->session->userdata("Conta_jB0")).'</td>
                </tr>
                <tr style="font-size: 11px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; font-weight: bold;">'.$txtFecha.'</td>
                </tr>
                <tr style="font-size: 11px; font-family: Gadget, sans-serif;">
                    <td style="width:100%; text-align: center; text-decoration: underline;"><strong>CIFRAS PRESENTADA '. (($this->session->userdata('idaccount') == 371571) ? 'CORDOBAS' : 'DOLARES DE LOS ESTADOS UNIDOS DE AMERICA') .'</strong></td>
                </tr>
            </table>
        ';
        $pdf->setHtmlHeader($header);
        //header
        /*$footer = '
            <table style="width=100%; border-top: 1px solid black;">
                <tr style="line-height: 10px;"><td></td></tr>
                <tr style="font-size: 9px;">
                </tr>
            </table>
        ';
        $pdf->setHtmlFooter($footer);//*/
        //footer
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetTitle(''.$this->session->userdata("Conta_jB0"));
        $pdf->SetMargins(10, 27, 10);// left top right
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage('P', 'LETTER');//p vertical l horizontal
        
        $html = '';
        $html .= '
            <table style="width=100%; font-family: Arial;">
                <tr style="line-height: 25px;"><td></td></tr>
                <tr style="text-align: center; font-size: 13px;">
                    <td style="width: 50%; text-decoration: underline;"><strong>ACTIVO</strong></td>
                    <td style="width: 50%; text-decoration: underline;"><strong>PASIVO</strong></td>
                </tr>
            </table>
        ';
        //datos
        $activo = 0;
        $pasivo = 0;
        $DatosAll = $this->contabilidad_model->getCuentasRBG_G12345();
        $Datos = null;
        $hijo31 = $this->contabilidad_model->existe_padre_hijo_property(3, 3, 6);
        $hijo32 = $this->contabilidad_model->existe_padre_hijo_property(3, 3, 7);
        $padre4 = $this->contabilidad_model->existe_padre_hijo_property(1, 4, null);
        $padre5 = $this->contabilidad_model->existe_padre_hijo_property(1, 5, null);
        $Datos1 = [];
        $Datos2 = [];
        $Datos3 = [];
        if ($hijo31 && $hijo32 && $padre4 && $padre5) {
            if ($DatosAll->num_rows() > 0) {
                $Datos = $DatosAll->result();
                $datos = $this->contabilidad_model->getCuentas3RBG_G12345();
                if ($datos->num_rows() > 0) {
                    foreach ($Datos as $dato) {
                        $dato->old = 0;
                        $dato->debe = 0;
                        $dato->haber = 0;
                        $dato->saldo = 0;
                        $dato->existe = 0;
                    }
                    foreach ($datos->result() as $dato3) {
                        $saldos = $this->contabilidad_model->getSaldoCuenta($dato3->idctcuenta, $fechaf);
                        if ($saldos->num_rows() > 0) {
                            foreach ($saldos->result() as $saldo) {
                                $min = new DateTime($fechai);
                                $fecha = new DateTime($saldo->fecha);
                                if ($fecha >= $min) {
                                    $old = 0;
                                    $debe = $saldo->debe;
                                    $haber = $saldo->haber;
                                    $saldo = $this->getSTC($dato3->catgrupo, $saldo->debe, $saldo->haber);
                                } else {
                                    $old = $this->getSTC($dato3->catgrupo, $saldo->debe, $saldo->haber);
                                    $debe = 0;
                                    $haber = 0;
                                    $saldo = 0;
                                }
                                foreach ($Datos as $dato) {
                                    if ($dato->idctcuenta == $dato3->idctcuenta) {
                                        $dato->old += $old;
                                        $dato->saldo += $saldo;
                                        $dato->debe += $debe;
                                        $dato->haber += $haber;
                                        foreach (explode(",", $dato3->ctmayoriza) as $padre) {
                                            foreach ($Datos as $daton) {
                                                if($daton->idctcuenta == $padre) {
                                                    $daton->old += $old;
                                                    $daton->saldo += $saldo;
                                                    $daton->debe += $debe;
                                                    $daton->haber += $haber;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    foreach ($Datos as $dato) {
                        $dato->nsaldo = ($dato->old + $dato->saldo);
                    }
                    if($cUtilidad == 1){
                        $valorpyg=0;//
                        foreach ($Datos as $dato) {
                            if ($dato->ctcontrol == 6 && $dato->tipocuenta == 3) $valorpyg += $dato->nsaldo;
                            if ($dato->ctcontrol == 7 && $dato->tipocuenta == 3) $valorpyg += $dato->nsaldo;
                        }

                    //-
                    
                        if ($valorpyg = 0){
                            $valor4 = 0; // DEUDORA
                            $valor5 = 0; // ACREEDORA
                            foreach ($Datos as $dato) {
                                if ($dato->catgrupo == 4 && $dato->tipocuenta == 1) $valor4 = $dato->nsaldo;
                                if ($dato->catgrupo == 5 && $dato->tipocuenta == 1) $valor5 = $dato->nsaldo;
                            }
                            $valor54 = $valor5 - $valor4;
                            foreach ($Datos as $dato) {
                                $control = ($valor54 > 0) ? 6 : 7;
                                if ($dato->catgrupo == 3 && $dato->ctcontrol == $control && $dato->tipocuenta == 3) 
                                {
                                    $vold = $dato->nsaldo;
                                    $dato->nsaldo = $valor54;
                                    foreach (explode(",", $dato->ctmayoriza) as $padre) {
                                        foreach ($Datos as $daton) {
                                            if($daton->idctcuenta == $padre) {
                                                $daton->nsaldo = $daton->nsaldo - $vold;
                                                $daton->nsaldo = $daton->nsaldo + $valor54;
                                                break;
                                            }
                                        }
                                    }
                                    break;
                                }
                            }
                        }
                    }else{
                            $valor4 = 0; // DEUDORA
                            $valor5 = 0; // ACREEDORA
                            foreach ($Datos as $dato) {
                                if ($dato->catgrupo == 4 && $dato->tipocuenta == 1) $valor4 = $dato->nsaldo;
                                if ($dato->catgrupo == 5 && $dato->tipocuenta == 1) $valor5 = $dato->nsaldo;
                            }
                            $valor54 = $valor5 - $valor4;
                            foreach ($Datos as $dato) {
                                $control = ($valor54 > 0) ? 6 : 7;
                                if ($dato->catgrupo == 3 && $dato->ctcontrol == $control && $dato->tipocuenta == 3) 
                                {
                                    $vold = $dato->nsaldo;
                                    $dato->nsaldo = $valor54;
                                    foreach (explode(",", $dato->ctmayoriza) as $padre) {
                                        foreach ($Datos as $daton) {
                                            if($daton->idctcuenta == $padre) {
                                                $daton->nsaldo = $daton->nsaldo - $vold;
                                                $daton->nsaldo = $daton->nsaldo + $valor54;
                                                break;
                                            }
                                        }
                                    }
                                    break;
                                }
                            }
                    }
                    //-
                    foreach ($Datos as $dato) {
                        switch ($dato->catgrupo) {
                            case 1:
                                $Datos1[] = $dato;
                                if ($dato->tipocuenta == 1) $activo += $dato->nsaldo;
                            break;
                            case 2:
                                $Datos2[] = $dato;
                                if ($dato->tipocuenta == 1) $pasivo += $dato->nsaldo;
                            break;
                            case 3:
                                $Datos3[] = $dato;
                                if ($dato->tipocuenta == 1) $pasivo += $dato->nsaldo;
                            break;
                        }
                    }
                    //echo $activo."<br>";
                    //echo $pasivo."<br>";
                }
            }
            #   DATOS
            if ($Datos != null) {
                $html .= '
                    <table style=" width: 100%;" >
                        <tr>
                            <td style="width: 50%;">
                                <table sytle="width: 100%;">
                ';
                if (count($Datos1) > 0) {
                    foreach ($Datos1 as $dato) {
                        $VZero = ($Opc == 0) ? true : (($dato->nsaldo != 0) ? true : false);
                        if ($dato->balview == 1 && $VZero) {
                            $html .= '<tr>';
                            $monto = $dato->nsaldo;
                            $monto = number_format((float)$monto, 2, '.', ',');
                            switch($dato->tipocuenta) {
                                case 1: 
                                    $html .= '
                                        <td style="width: 77%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; font-weight: bold; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 2: 
                                    $html .= '
                                        <td style="width: 2%;" ></td>
                                        <td style="width: 71%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 3: 
                                    $html .= '
                                        <td style="width: 3%;" ></td>
                                        <td style="width: 70%;" >'.$dato->descrip.'</td>
                                        <td style="width: 17%; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 10%;" ></td>
                                    ';
                                break;
                            };
                            $html .= '</tr>';
                        }
                    }
                }
                $html .= '
                                </table>
                            </td>
                            <td style="width: 50%;">
                                <table sytle="width: 100%;">
                ';
                if ((count($Datos2) > 0) || (count($Datos3) > 0)) {
                    foreach ($Datos2 as $dato) {
                        $VZero = ($Opc == 0) ? true : (($dato->nsaldo != 0) ? true : false);
                        if ($dato->balview == 1 && $VZero) {
                            $html .= '<tr>';
                            $monto = $dato->nsaldo;
                            $monto = number_format((float)$monto, 2, '.', ',');
                            switch($dato->tipocuenta) {
                                case 1: 
                                    $html .= '
                                        <td style="width: 77%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; font-weight: bold; text-align: right;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 2: 
                                    $html .= '
                                        <td style="width: 2%;" ></td>
                                        <td style="width: 71%; font-weight: bold;" >'.$dato->descrip.'</td>
                                        <td style="width: 20%; text-align: right; font-weight: bold;" >'.$monto.'</td>
                                        <td style="width: 3%;" ></td>
                                    ';
                                break;
                                case 3: 
                                    $html .= '
                                        <td style="width: 3%;" ></td>
                        