<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Conta extends CI_Controller{
        
        function __construct(){
            parent::__construct();
        }
            
        function listaCatalogo($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $this->data['direccion'] = $controlador.'/'.$funcion;
                $this->session->set_userdata($resultAppName);
                $this->load->model('conta_model');
                $this->load->model('variable_model');
                $this->data['controles'] = $this->variable_model->getVariablesNombre("ct_control");
                $this->data['auxiliares'] = $this->variable_model->getVariablesNombre("auxi_def");
                $this->data['grupos'] = $this->variable_model->getVariablesNombre("ct_grupo");
                $this->data['cuentas'] = $this->conta_model->viewCuentas();
                
                $this->load->model('global_model');
                $controladore = $this->uri->segment(1);
                $funcione = $this->uri->segment(2);
                $direccione = $controladore.'/'.$funcione;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccione);
                
                $this->load->view('mantenimiento_catalogocuentas', $this->data); 
            }
        }
        
        function menu_selected(){
            $opcion = $this->input->post('opcion');
            $filter = array( 'opcion_conta' => $opcion );
            $this->session->set_userdata($filter);
            echo json_encode(true);
        }
        
        function verificarCuenta(){
            $cuenta = $this->input->post('cuenta');
            $this->load->model('conta_model');
            $existe = $this->conta_model->verificarCuenta($cuenta);
            echo json_encode($existe);
        }
        
        function getTotaliza(){
            $cuenta = $this->input->post('cuenta');
            $this->load->model('conta_model');
            $existe = $this->conta_model->getTotaliza($cuenta);
            echo json_encode($existe);
        }
        
        function addcatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $cicli = $this->uri->segment(3);
                
                if($cicli!=""){
                    $this->data['ciclica'] = true;
                }else{
                    $this->data['ciclica'] = false;
                }
                $this->load->model('conta_model');
                $this->load->model('variable_model');
                $this->data['grupos'] = $this->variable_model->getVariablesNombre("ct_grupo");
                $this->data['tipos_control'] = $this->variable_model->getVariablesNombre("ct_control");
                $this->data['auxiliares'] = $this->variable_model->getVariablesNombre("auxi_def");
                $this->data['opcion_conta'] = $this->session->userdata('opcion_conta');
                $this->data['num_cuenta'] = $this->session->userdata('num_cuenta');
                $tipo_cuenta = $this->session->userdata('tipo_cuenta');
                if($tipo_cuenta=="" || $tipo_cuenta==null || $tipo_cuenta==false){
                    $this->data['tipo_cuenta'] = 0;
                }else{
                    $this->data['tipo_cuenta'] = $tipo_cuenta;
                }
                $this->data['totalizara'] = $this->session->userdata('totalizara');
                $this->load->view('new_conta_cuenta', $this->data); 
            }
        }
        
        function registrar_cuentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $grupo = $this->input->post('grupo'); 
                $num_cuenta = $this->input->post('num_cuenta');
                $titulo_cuenta = $this->input->post('titulo_cuenta');
                $totalizara = $this->input->post('totalizara');
                $tipo_control = $this->input->post('tipo_control');
                $auxi = $this->input->post('auxi');
                $tipo_cuenta = $this->input->post('tipo_cuenta');
                $u_costos = $this->input->post('u_costos');
                $u_proyectos = $this->input->post('u_proyectos');
                $s_contrasena = $this->input->post('s_contrasena');
                $c_presupuesto = $this->input->post('c_presupuesto');
                $ciclica = $this->input->post('add_ciclica');
                $estado = $this->input->post('estado');
                $notas = $this->input->post('notas');
                $idfiltros = $this->input->post('idfiltros');
                
                $this->load->model('conta_model');
                $query = $this->conta_model->insertCuenta($grupo, $num_cuenta, $titulo_cuenta, $totalizara, $tipo_control, $auxi, $tipo_cuenta, $u_costos, $u_proyectos, $s_contrasena, $c_presupuesto, $estado, $notas, $idfiltros);
            
                if($query==1){
                    if($ciclica=="true"){
                        $new_num_cuenta = $num_cuenta+1;
                        $filter = array(
                            'num_cuenta' => $new_num_cuenta,
                            'tipo_cuenta' => $tipo_cuenta,
                            'totalizara' => $totalizara,
                        );
                        $this->session->set_userdata($filter);
                        redirect('conta/addcatalog/1');
                    }else{
                        $filter = array(
                            'tipo_cuenta' => 0,
                        );
                        $this->session->set_userdata($filter);
                        $this->session->unset_userdata('num_cuenta');
                        $this->session->unset_userdata('totalizara');
                        redirect('conta/listacatalogo/'.$this->session->userdata('iddApp'));
                    }
                    
                }else{
                    redirect('conta/addcatalog/');
                }
            }
        }
        
        function modificarCuenta($idcuenta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('conta_model');
                $this->load->model('variable_model');
                $this->data['idcuenta'] = $idcuenta;
                $informacion = $this->conta_model->getData($idcuenta);
                $this->data['registro'] = $informacion;
                $this->data['grupos'] = $this->variable_model->getVariablesNombre("ct_grupo");
                $this->data['tipos_control'] = $this->variable_model->getVariablesNombre("ct_control");
                $this->data['auxiliares'] = $this->variable_model->getVariablesNombre("auxi_def");
                
                foreach($informacion as $info){
                    $filtros = $info->filtro_sidauxi;
                }
                
                $idfiltros = "";
                $cant = 0;
                
                if($filtros != null || $filtros != ""){
                    $arrayFil = explode(",", $filtros);
                    $total = count($arrayFil);
                    
                    for($i=0; $i<$total; $i++){
                        if($cant==0){
                            $idfiltros =  " \"$arrayFil[$i]\"  ";
                        }else{
                            $idfiltros .= ","." \"$arrayFil[$i]\" ";
                        }   
                        $cant++;                    
                    }
                }
                
                $this->data['idfiltros'] = $idfiltros;
                $this->load->view("form_update_cuentas", $this->data);
            }
        }
        
        function actualizar_cuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $id_cuenta = $this->input->post('id_cuenta'); 
                $grupo = $this->input->post('grupo'); 
                $num_cuenta = $this->input->post('num_cuenta');
                $titulo_cuenta = $this->input->post('titulo_cuenta');
                $totalizara = $this->input->post('totalizara');
                $tipo_control = $this->input->post('tipo_control');
                $auxi = $this->input->post('auxi');
                $tipo_cuenta = $this->input->post('tipo_cuenta');
                $u_costos = $this->input->post('u_costos');
                $u_proyectos = $this->input->post('u_proyectos');
                $s_contrasena = $this->input->post('s_contrasena');
                $c_presupuesto = $this->input->post('c_presupuesto');
                $estado = $this->input->post('estado');
                $idfiltros = $this->input->post('idfiltros');

                $notas = $this->input->post('notas');
                $this->load->model('conta_model');
                
                $query = $this->conta_model->updateCuenta($id_cuenta, $grupo, $num_cuenta, $titulo_cuenta, $totalizara, $tipo_control, $auxi, $tipo_cuenta,$u_costos, $u_proyectos, $s_contrasena, $c_presupuesto, $estado, $notas, $idfiltros); 
                
                if($query==1){
                    redirect('conta/listacatalogo/'.$this->session->userdata('iddApp'));
                }else{
                    redirect('conta/modificarCuenta/'.$id_cuenta);
                }
            }
        }
        
        function listayears($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $this->data['direccion'] = $controlador.'/'.$funcion;
                $this->session->set_userdata($resultAppName);
                $this->load->model('conta_model');
                $this->data['periodos'] = $this->conta_model->getPeriodos();
                $this->load->view('mantenimiento_listayears', $this->data); 
            }
        }
        
        function newPeriodo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->view('new_periodo_contable'); 
            }
        }
        
        function registrar_periodo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $anio = $this->input->post('anio'); 
                $descrip = $this->input->post('descrip');
                $inicio = $this->input->post('inicio');
                $fin = $this->input->post('fin');
                $meses = $this->input->post('meses');
                $esta = $this->input->post('estado');
                $notas = $this->input->post('notas');
                
                if($esta == "true"){
                    $estado = 1;
                }else{
                    $estado = 0;
                }
                
                $this->load->model('conta_model');
                $query = $this->conta_model->insertPeriodo($anio, $descrip, $inicio, $fin, $meses, $estado, $notas); 
            
                if($query==1){
                    redirect('conta/listayears/'.$this->session->userdata('iddApp'));
                }else{
                    redirect('conta/newPeriodo/');
                }
            }
        }
        
        function verificarPeriodo(){
            $year = $this->input->post('year');
            $this->load->model('conta_model');
            $existe = $this->conta_model->verificarPeriodo($year);
            echo json_encode($existe);
        }
        
        function modificarPeriodo($anio){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('conta_model');
                $this->data['anio'] = $anio;
                $this->data['registro'] = $this->conta_model->getInfoPeriodo($anio);
                $this->load->view("form_update_periodo_contable", $this->data);
            }
        }
        
        function update_periodo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idanio = $this->input->post('idanio'); 
                $anio = $this->input->post('anio'); 
                $descrip = $this->input->post('descrip');
                $inicio = $this->input->post('inicio');
                $fin = $this->input->post('fin');
                $meses = $this->input->post('meses');
                $esta = $this->input->post('estado');
                $notas = $this->input->post('notas');
                
                if($esta == "true"){
                    $estado = 1;
                        
                }else{
                    $estado = 0;
                            
                }
                
                $this->load->model('conta_model');
                
                
                $query = $this->conta_model->updatePeriodo($idanio, $anio, $descrip, $inicio, $fin, $meses, $estado, $notas); 
            
                if($query==1){
                    redirect('conta/listayears/'.$this->session->userdata('iddApp'));
                }else{
                    redirect('conta/newPeriodo/'.$idanio);
                }
            }
        }
        
        function listactpdef($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $this->data['direccion'] = $controlador.'/'.$funcion;
                $this->session->set_userdata($resultAppName);
                $this->load->model('conta_model');
                $this->data['years'] = $this->conta_model->getPeriodos();
                
                $this->load->model('global_model');
                $controladore = $this->uri->segment(1);
                $funcione = $this->uri->segment(2);
                $direccione = $controladore.'/'.$funcione;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccione);
                $this->load->view('mantenimiento_lista_partidas', $this->data); 
            }
        }
        
        function getPartidas(){
            $this->load->model('conta_model');
            $idano = $this->input->post('idano'); 
            $partidas = $this->conta_model->getPartidas();
            
            $i=0;
            $array = array();
            foreach($partidas as $par){
                $idptipo  = $par->idptipo;
                /*
                $detalles = $this->conta_model->getctpnums($idptipo,$idano);
                $detallesArray = array();
                $j=0; 
                foreach($detalles as $detalle){
                    switch($detalle->idmes){
                        case 1:
                            $mes = "Enero";
                            break;
                        case 2:
                            $mes = "Febrero";
                            break;
                        case 3:
                            $mes = "Marzo";
                            break;
                        case 4:
                            $mes = "Abril";
                            break;
                        case 5:
                            $mes = "Mayo";
                            break;
                        case 6:
                            $mes = "Junio";
                            break;
                        case 7:
                            $mes = "Julio";
                            break;
                        case 8:
                            $mes = "Agosto";
                            break;
                        case 9:
                            $mes = "Septiembre";
                            break;
                        case 10:
                            $mes = "Octubre";
                            break;
                        case 11:
                            $mes = "Noviembre";
                            break;
                        case 12:
                            $mes = "Diciembre";
                            break;
                        case 0:
                            $mes = "Mes 0";
                            break;
                        case 13:
                            $mes = "Mes 13";
                            break;
                    }
                    $detallesArray[$j] = array(
                        "idano" => $detalle->idano,
                        "idmes" => $mes,
                        "idmes_" => $detalle->idmes,
                        "idptipo_1" => $detalle->idptipo,
                        "fechaini" => $detalle->fechaini,
                        "fechafin" => $detalle->fechafin,
                        "numero" => $detalle->numero,
                        "estado_1" => $detalle->estado,
                        "notas_1" => $detalle->notas
                    );
                    $j++;
                }*/
                $array[$i] = array(
                    "idptipo" => $idptipo,
                    "descrip" => $par->descrip,
                    "idform" => $par->forma,
                    "askpwd" => $par->askpwd,
                    "estado" => $par->estado,
                    "notas" => $par->notas
                );
                $i++;
            }
            echo json_encode($array);
        }
        
        function getCorrelativosPartida(){
            $this->load->model('conta_model');
            
            $idano = $this->input->post('idano'); 
            $idptipo = $this->input->post('idptipo'); 
            $partidas = $this->conta_model->getPartidas();
            
            $i=0;
            $array = array();
            $detalles = $this->conta_model->getctpnums($idptipo, $idano);
            foreach($detalles as $info){
                switch($info->idmes){
                    case 1:
                        $mes = "Enero";
                        break;
                    case 2:
                        $mes = "Febrero";
                        break;
                    case 3:
                        $mes = "Marzo";
                        break;
                    case 4:
                        $mes = "Abril";
                        break;
                    case 5:
                        $mes = "Mayo";
                        break;
                    case 6:
                        $mes = "Junio";
                        break;
                    case 7:
                        $mes = "Julio";
                        break;
                    case 8:
                        $mes = "Agosto";
                        break;
                    case 9:
                        $mes = "Septiembre";
                        break;
                    case 10:
                        $mes = "Octubre";
                        break;
                    case 11:
                        $mes = "Noviembre";
                        break;
                    case 12:
                        $mes = "Diciembre";
                        break;
                    case 0:
                        $mes = "Apertura";
                        break;
                    case 13:
                        $mes = "Cierre";
                        break;
                }
                
                $array[$i] = array(
                    "idano" => $info->idano,
                    "namemes" => $mes,
                    "idmes" => $info->idmes,
                    "idptipo" => $info->idptipo,
                    "tiponum" => $info->tiponum,
                    "numero" => $info->numero,
                    "estado" => $info->estado
                );
                $i++;
            }
            
            echo json_encode($array);
        }
        
        function newctpdef(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $this->data['direccion'] = $controlador.'/'.$funcion;
                $direc = $controlador.'/'.$funcion;
                $this->load->model('global_model');
                $this->data['formatos']  = $this->global_model->getFormatosImpresionResult($direc);
                $this->load->view('new_partida_contable', $this->data); 
            }
        }
        
        function modificarctpdef($idptipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $this->data['direccion'] = $controlador.'/'.$funcion;
                $direc = $controlador.'/'.$funcion;
                $this->load->model('global_model');
                $this->load->model('conta_model');
                $this->data['formatos']  = $this->global_model->getFormatosImpresionResult("conta/newctpdef");
                $informacion = $this->conta_model->getInformacionPartida($idptipo);
                
                $idMeses = ""; $idMeses2 = "";
                foreach($informacion as $info){
                    if($info->mes_0 == 1){
                        $idMeses .= ",0,";
                        $idMeses2 .= "0";
                    }
                    if($info->mes_1 == 1){
                        $idMeses .= ",1,";
                        $idMeses2 .= ",1";
                    }
                    if($info->mes_2 == 1){
                        $idMeses .= ",2,";
                        $idMeses2 .= ",2";
                    }
                    if($info->mes_3 == 1){
                        $idMeses .= ",3,";
                        $idMeses2 .= ",3";
                    }
                    if($info->mes_4 == 1){
                        $idMeses .= ",4,";
                        $idMeses2 .= ",4";
                    }
                    if($info->mes_5 == 1){
                        $idMeses .= ",5,";
                        $idMeses2 .= ",5";
                    }
                    if($info->mes_6 == 1){
                        $idMeses .= ",6,";
                        $idMeses2 .= ",6";
                    }
                    if($info->mes_7 == 1){
                        $idMeses .= ",7,";
                        $idMeses2 .= ",7";
                    }
                    if($info->mes_8 == 1){
                        $idMeses .= ",8,";
                        $idMeses2 .= ",8";
                    }
                    if($info->mes_9 == 1){
                        $idMeses .= ",9,";
                        $idMeses2 .= ",9";
                    }
                    if($info->mes_10 == 1){
                        $idMeses .= ",10,";
                        $idMeses2 .= ",10";
                    }
                    if($info->mes_11 == 1){
                        $idMeses .= ",11,";
                        $idMeses2 .= ",11";
                    }
                    if($info->mes_12 == 1){
                        $idMeses .= ",12,";
                        $idMeses2 .= ",12";
                    }
                    if($info->mes_13 == 1){
                        $idMeses .= ",13,";
                        $idMeses2 .= ",13";
                    }
                }
                
                $this->data['informacion']  = $informacion;
                $this->data['idMeses']  = $idMeses;
                $this->data['idMeses2']  = $idMeses2;
                $this->load->view('form_update_partida_contable', $this->data); 
            }
        }
        
        function registrarPartida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $saveNext = $this->input->post('saveNext'); 
                $tipo = $this->input->post('tipo');
                $formato = $this->input->post('formato');
                $s_contra = $this->input->post('s_contra');
                $correlativos = $this->input->post('correlativos');
                $inputMeses = $this->input->post('inputMeses');
                $esta = $this->input->post('estado');
                $notas = $this->input->post('notas');
                
                if($esta == "true"){
                    $estado = 1;
                }else{
                    $estado = 0;
                }
                
                $this->load->model('conta_model');
                $query = $this->conta_model->insertPartida($tipo, $formato, $s_contra, $correlativos, $inputMeses, $estado, $notas); 
            
                if($query==1){
                    if($saveNext=="true"){
                        redirect('conta/newctpdef');
                    }else{
                        redirect('conta/listactpdef/'.$this->session->userdata('iddApp'));   
                    }
                }else{
                    redirect('conta/newctpdef');
                }
            }
        }
        
        function actualizarPartida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idptipo = $this->input->post('idptipo');
                $tipo = $this->input->post('tipo');
                $formato = $this->input->post('formato');
                $s_contra = $this->input->post('s_contra');
                $correlativos = $this->input->post('correlativos');
                $inputMeses = $this->input->post('inputMeses');
                $esta = $this->input->post('estado');
                $notas = $this->input->post('notas');
                
                if($esta == "true"){
                    $estado = 1;
                }else{
                    $estado = 0;
                }
                
                $this->load->model('conta_model');
                $query = $this->conta_model->updatePartida($idptipo, $tipo, $formato, $s_contra, $correlativos, $inputMeses, $estado, $notas); 
                redirect('conta/listactpdef/'.$this->session->userdata('iddApp')); 
            }
        }
    
        function modificarNum($anio, $mes, $num, $idptipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('conta_model');
                $this->data['registro'] = $this->conta_model->getInfoNum($anio, $mes, $num);
                $this->data['anio'] = $anio;
                $this->data['mes'] = $mes;
                $this->data['num'] = $num;
                $this->data['idptipo'] = $idptipo;
                $this->load->view("form_update_numero_contable", $this->data);
            }
        }
        
        function update_num(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $last_num = $this->input->post('last_num'); 
                $idptipo = $this->input->post('idptipo'); 
                $anio = $this->input->post('anio'); 
                $mes = $this->input->post('mes');
                $f_inicio = $this->input->post('f_inicio');
                $f_fin = $this->input->post('f_fin');
                $numero = $this->input->post('numero');
                $esta = $this->input->post('estado');
                $notas = $this->input->post('notas');
            
                if($esta == "true"){
                    $estado = 1;
                }else{
                    $estado = 0;
                }
                
                $this->load->model('conta_model');
                $query = $this->conta_model->updateNum($last_num, $anio, $mes, $numero, $estado, $notas, $idptipo); 
            
                if($query==1){
                    redirect('conta/listactpdef/'.$this->session->userdata('iddApp'));
                }else{
                    $anio_id = $anio->format('Y');
                    redirect('conta/modificarNum/'.$anio_id."/".$mes."/".$last_num);
                }
            }
        }
        
        function updateCorrelativosPartida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idptipo = $this->input->post('idptipo');
                $idano = $this->input->post('idano');
                $idmes = $this->input->post('idmes');
                $numero = $this->input->post('numero');
                $estado = $this->input->post('estado');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->updateNumerosPartidas($idptipo,$idano,$idmes,$numero,$estado);
                
                echo json_encode($array);
            }
        }
        
        function listaproj($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $this->data['direccion'] = $controlador.'/'.$funcion;
                $this->session->set_userdata($resultAppName);
                $this->load->model('conta_model');
                $this->load->model('cliente_model');
                
                $this->data['clientes'] = $this->cliente_model->viewClienteA();
                $this->data['proyectos'] = $this->conta_model->viewProyectos();
                $this->load->view('mantenimiento_lista_proyectos', $this->data); 
            }
        }
        
        function insertProyecto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $desc = $this->input->post('desc'); 
                $cliente = $this->input->post('cliente'); 
                $fechain = $this->input->post('fechain');
                $fechafin = $this->input->post('fechafin');
                $esta = $this->input->post('estado');
                
                if($esta == "true"){
                    $estado = 1;
                        
                }else{
                    $estado = 0;
                            
                }
                
                $notas = $this->input->post('notas');
                $this->load->model('conta_model');
                
                $query = $this->conta_model->insertProyecto($desc, $cliente, $fechain, $fechafin, $estado, $notas); 
                $pro = $this->conta_model->viewProyectos();
                
                echo json_encode($pro);
            }
        }
        
        function updateProyecto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $id = $this->input->post('id'); 
                $desc = $this->input->post('desc'); 
                $cliente = $this->input->post('cliente'); 
                $fechain = $this->input->post('fechain');
                $fechafin = $this->input->post('fechafin');
                $esta = $this->input->post('estado');
                
                if($esta == "true"){
                    $estado = 1;
                }else{
                    $estado = 0;
                }
                
                $notas = $this->input->post('notas');
                $this->load->model('conta_model');
                
                $query = $this->conta_model->updateProyecto($id, $desc, $cliente, $fechain, $fechafin, $estado, $notas); 
                $pro = $this->conta_model->viewProyectos();
                
                echo json_encode($pro);
            } 
        }
            
        function imprimir(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->view('PrintZPL.php'); 
            }
        }
            
        function listaauxi($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('conta_model');
                $this->load->model('variable_model');
                $this->load->model('cliente_model');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $this->data['direccion'] = $controlador.'/'.$funcion;
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
                $this->data['tipos_Auxi'] = $this->variable_model->getVariablesNombre("gv_ctauxitipo");
                $this->data['gzip'] = $this->variable_model->getVariablesNombre("gv_zip");
                $this->data['auxiliares'] = $this->conta_model->getAuxiliares("auxi_def", 10);
                $this->load->view('mantenimiento_listaauxi', $this->data); 
            }
        }
        
        function getAllAuxi(){
            $this->load->model('conta_model');
            $auxiliares = $this->conta_model->getAuxiliares("auxi_def", 10);
            echo json_encode($auxiliares);
        }

        function newAuxi(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if(isset($_FILES["imagen"])){
                    $file = $_FILES["imagen"];
                    $nombre = $file["name"];
                    $tituloAuxi = $_POST["tituloAuxi"];
                    $tipoAuxi= $_POST["tipoAuxi"];
                    $whodidit = $this->session->userdata('iduser');
                    $this->load->model('conta_model');
                    $nombre = str_replace(" ", "", $nombre);
                    if($nombre != ""){
                        $idauxi = $this->conta_model->addNewAuxi("auxi_def",$tituloAuxi,$tipoAuxi,"",$whodidit);
                        $auxiliares = $this->conta_model->getAuxiliares("auxi_def", 10);
                        $imgSplit = explode(".", $nombre);
                        $imgNameSplit = trim($tituloAuxi);
                        $nombreimagen = trim("imgAuxi_".$idauxi);
                        $nombreimagen2 = "imgAuxi_".$idauxi.".".trim($imgSplit[1]);
                        $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['file_name'] = $nombreimagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        if($this->upload->do_upload('imagen')){
                            $update = $this->conta_model->updateImgAuxi($idauxi,$nombreimagen2);
                        }
                    }else{
                        $whodidit = $this->session->userdata('iduser');
                        $tituloAuxi = $_POST["tituloAuxi"];
                        $tipoAuxi= $_POST["tipoAuxi"];
                        $whodidit = $this->session->userdata('iduser');
                        $this->load->model('conta_model');
                        $subir = $this->conta_model->addNewAuxi("auxi_def",$tituloAuxi,$tipoAuxi,"",$whodidit);
                        $auxiliares = $this->conta_model->getAuxiliares("auxi_def", 10);
                    }
                }else{
                    $whodidit = $this->session->userdata('iduser');
                    $tituloAuxi = $_POST["tituloAuxi"];
                    $tipoAuxi= $_POST["tipoAuxi"];
                    $whodidit = $this->session->userdata('iduser');
                    $this->load->model('conta_model');
                    $subir = $this->conta_model->addNewAuxi("auxi_def",$tituloAuxi,$tipoAuxi,"",$whodidit);
                    $auxiliares = $this->conta_model->getAuxiliares("auxi_def", 10);
                }
                echo json_encode($auxiliares);
            }
        } 
        
        function newsubauxi(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $descrip = $_POST["descrip"];
                $telefono= $_POST["telefono"];
                $correo= $_POST["correo"];
                $direccion= $_POST["direccion"];
                $fechain= $_POST["fechain"];
                $dui= $_POST["dui"];
                $nit= $_POST["nit"];
                $giro= $_POST["giro"];
                $estado= $_POST["estado"];
                $notas= $_POST["notas"];
                $grupo = $_POST["grupo"];
                $idzip = $_POST["departamento"];
                $idauxidef = $_POST["idauxidef1"];
                $this->load->model('conta_model');
                $idauxi = $this->conta_model->insertCtauxi($descrip,$idauxidef, $telefono,$correo,$direccion,$idzip,$fechain,$dui,$nit,$giro,$grupo,$estado,$notas);
                
                if(isset($_FILES["imgpersona"])){
                    $file = $_FILES["imgpersona"];
                    $nombre = $file["name"];
                    if($nombre!=""){
                        $imgSplit = explode(".", $nombre);
                        $nombreimagen = trim("imgAuxi_".$idauxi);
                        $nombreimagen2 = "imgAuxi_".$idauxi.".".trim($imgSplit[1]);
                        if(file_exists("img_cuentas/".$this->session->userdata('diraccount')."/".$nombreimagen2)) // Debo saber si existe esta foto 
                        { 
                            unlink("img_cuentas/".$this->session->userdata('diraccount')."/".$nombreimagen2); 
                        } 
                        $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['file_name'] = $nombreimagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        if($this->upload->do_upload('imgpersona')){
                            $this->conta_model->updatePhotoName($idauxi, $nombreimagen2);
                        }else{

                        }
                    }
                }
                
                $listaauxi = $this->conta_model->getauxilist($idauxidef);
                echo json_encode($listaauxi);
            }
        }
        
        function updateSubauxiPersona(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //imgenpersonaup
                $idauxi = $_POST["idauxiupp"];
                $idauxidef = $_POST["idauxidefupp"];
                
                $descrip = $_POST["descripup"];
                $telefono= $_POST["telefonoup"];
                $correo= $_POST["correoup"];
                $direccion= $_POST["direccionup"];
                $fechain= $_POST["fechainup"];
                $dui= $_POST["duiup"];
                $nit= $_POST["nitup"];
                $giro= $_POST["giroup"];
                $estado= $_POST["estadoup"];
                $notas= $_POST["notasup"];
                $grupo = $_POST["grupoup"];
                $idzip = $_POST["departamentoup"];
                $this->load->model('conta_model');
                $upd = $this->conta_model->updateCtauxi($idauxi,$descrip,$telefono,$correo,$direccion,$idzip,$fechain,$dui,$nit,$giro,$grupo,$estado,$notas);
                $name_imglast = $this->conta_model->getImgAuxi($idauxi);

                
                if(isset($_FILES["imgpersonaup"])){
                    $file = $_FILES["imgpersonaup"];
                    $nombre = $file["name"];
                    if($nombre!=""){
                        $imgSplit = explode(".", $nombre);
                        $nombreimagen = trim("imgAuxi_".$idauxi);
                        $nombreimagen2 = "imgAuxi_".$idauxi.".".trim($imgSplit[1]);
                        if($name_imglast!=""){
                            if(file_exists("img_cuentas/".$this->session->userdata('diraccount')."/".$name_imglast)) // Debo saber si existe esta foto 
                            { 
                                unlink("img_cuentas/".$this->session->userdata('diraccount')."/".$name_imglast); 
                            }
                        }
                        
                        $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['file_name'] = $nombreimagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        if($this->upload->do_upload('imgpersonaup')){
                            $this->conta_model->updatePhotoName($idauxi, $nombreimagen2);
                        }else{

                        }
                    }
                }
                    
                $listaauxi = $this->conta_model->getauxilist2($idauxidef);
                echo json_encode($listaauxi);
            }
        }
        
        function updateSubauxiGastos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //imgenpersonaup
                $idauxi = $_POST["idauxiupg"];
                $idauxidef = $_POST["idauxidefupg"];
                
                $descrip = $_POST["descripupgasto"];
                $estado= $_POST["estadoupgasto"];
                $notas= $_POST["notasupgasto"];
                $grupo= $_POST["grupoupgasto"];

                $this->load->model('conta_model');
                $upd = $this->conta_model->updateCtauxi($idauxi,$descrip,"","","","","","","","",$grupo,$estado,$notas);
                
                $name_imglast = $this->conta_model->getImgAuxi($idauxi);

                
                if(isset($_FILES["imggastosup"])){
                    $file = $_FILES["imggastosup"];
                    $nombre = $file["name"];
                    if($nombre!=""){
                        $imgSplit = explode(".", $nombre);
                        $nombreimagen = trim("imgAuxi_".$idauxi);
                        $nombreimagen2 = "imgAuxi_".$idauxi.".".trim($imgSplit[1]);
                        if($name_imglast!=""){
                            if(file_exists("img_cuentas/".$this->session->userdata('diraccount')."/".$name_imglast)) // Debo saber si existe esta foto 
                            { 
                                unlink("img_cuentas/".$this->session->userdata('diraccount')."/".$name_imglast); 
                            }
                        }
                        
                        
                        $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['file_name'] = $nombreimagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        if($this->upload->do_upload('imggastosup')){
                            $this->conta_model->updatePhotoName($idauxi, $nombreimagen2);
                        }else{

                        }
                    }
                }
                    
                $listaauxi = $this->conta_model->getauxilist2($idauxidef);
                echo json_encode($listaauxi);
            }
        }
        
        function newsubauxigasto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $descrip = $_POST["descripgasto"];
                $estado= $_POST["estadogasto"];
                $notas= $_POST["notasgasto"];
                $grupo = $_POST["grupogasto"];
                $idauxidef = $_POST["idauxidef2"];
                $this->load->model('conta_model');
                $idauxi = $this->conta_model->insertCtauxi($descrip,$idauxidef, "","","","","","","","",$grupo,$estado,$notas);
                
                if(isset($_FILES["imggasto"])){
                    $file = $_FILES["imggasto"];
                    $nombre = $file["name"];
                    if($nombre!=""){
                        $imgSplit = explode(".", $nombre);
                        $nombreimagen = trim("imgAuxi_".$idauxi);
                        $nombreimagen2 = "imgAuxi_".$idauxi.".".trim($imgSplit[1]);
                    
                        if(file_exists("img_cuentas/".$this->session->userdata('diraccount')."/".$nombreimagen2)) // Debo saber si existe esta foto 
                        { 
                            unlink("img_cuentas/".$this->session->userdata('diraccount')."/".$nombreimagen2); 
                        } 
                        
                        $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['file_name'] = $nombreimagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        if($this->upload->do_upload('imggasto')){
                            $this->conta_model->updatePhotoName($idauxi, $nombreimagen2);
                        }
                    }
                }
                $listaauxi = $this->conta_model->getauxilist($idauxidef);
                echo json_encode($listaauxi);
            }
        }
        
        function getAuxiInfo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrnum = $this->input->post('idrnum'); 
                $this->load->model('conta_model');
                $info = $this->conta_model->getInfoAuxi($idrnum);
                $grupos = $this->conta_model->viewGrupo($idrnum);
                $listaauxi = $this->conta_model->getauxilist($idrnum);
                $datos = array();
                $i = 0;
                
                if($grupos!=null || $grupos!=""){
                    $array = explode(",", $grupos);
                    foreach($array as $key){
                        $datos[$i] = array(
                            "id"=>$i,
                            "descrip" => $key,
                        );  
                        $i++;
                    }
                }
                $array = array(
                    "grupos"=>$datos,
                    "info" =>$info,
                    "listaauxi"=>$listaauxi
                );
                
                echo json_encode($array);
            }
        }
            
        function updateAuxi(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if(isset($_FILES["imagen"])){
                    $file = $_FILES["imagen"];
                    $nombre = $file["name"];
                    $tituloAuxi = $_POST["tituloAuxi"];
                    $viejaimagen = $_POST["viejaimagen"];
                    $idrnum = $_POST["idrnum"];
                    $tipoAuxi= $_POST["tipoAuxi"];
                    $this->load->model('conta_model');
                    $nombre = str_replace(" ", "", $nombre);
                    if($nombre != ""){
                        $imgSplit = explode(".", $nombre);
                        $imgNameSplit = trim($tituloAuxi);
                        $aleatorio = rand(0, 999);
                        $nombreimagen = trim("imgAuxi_".trim($imgNameSplit).$idrnum."-".$aleatorio);
                        $nombreimagen2 = "imgAuxi_".trim($imgNameSplit).$idrnum."-".$aleatorio.".".trim($imgSplit[1]);
                        $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['file_name'] = $nombreimagen;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                                
                        if($this->upload->do_upload('imagen')){
                            $this->conta_model->updateAuxi($idrnum,$tituloAuxi,$tipoAuxi,$nombreimagen2);
                            $auxiliares = $this->conta_model->getAuxiliares("auxi_def", 10);
                        }else{
                            //echo $this->upload->display_errors();
                        }
                    }else{
                        $whodidit = $this->session->userdata('iduser');
                        $tituloAuxi = $_POST["tituloAuxi"];
                        $tipoAuxi= $_POST["tipoAuxi"];
                        $whodidit = $this->session->userdata('iduser');
                        $this->load->model('conta_model');
                        $subir = $this->conta_model->updateAuxi($idrnum,$tituloAuxi,$tipoAuxi,"");
                        $auxiliares = $this->conta_model->getAuxiliares("auxi_def", 10);
                    }
                }else{
                    $whodidit = $this->session->userdata('iduser');
                    $tituloAuxi = $_POST["tituloAuxi"];
                    $tipoAuxi= $_POST["tipoAuxi"];
                    $whodidit = $this->session->userdata('iduser');
                    $this->load->model('conta_model');
                    $subir = $this->conta_model->updateAuxi($idrnum,$tituloAuxi,$tipoAuxi,"");
                    $auxiliares = $this->conta_model->getAuxiliares("auxi_def", 10);
                }
                echo json_encode($auxiliares);
            }
        }
        
        function deletePhoto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrnum = $this->input->post('idrnum'); 
                $this->load->model('conta_model');
                $eliminar = $this->conta_model->deletePhoto($idrnum);
                $auxiliares = $this->conta_model->getAuxiliares("auxi_def", 10);
                echo json_encode($auxiliares);
            }
        }
        
        function deletePhotoAuxi(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxi = $this->input->post('idauxi'); 
                $idrnum = $this->input->post('idrnum'); 
                $this->load->model('conta_model');
                $name_imglast = $this->conta_model->deletePhotoAuxi($idauxi);
                if($name_imglast!=""){
                    if(file_exists("img_cuentas/".$this->session->userdata('diraccount')."/".$name_imglast)) // Debo saber si existe esta foto 
                    {    
                        unlink("img_cuentas/".$this->session->userdata('diraccount')."/".$name_imglast); 
                    }
                }
                
                $listaauxi = $this->conta_model->getauxilist($idrnum);
                echo json_encode($listaauxi);
            }
        }
        
        function viewGrupos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrnum = $this->input->post('idrnum'); 
                $this->load->model('conta_model');
                $grupos = $this->conta_model->viewGrupo($idrnum);
                $datos = array();
                $i = 0;
                
                if($grupos!=null || $grupos!=""){
                    $array = explode(",", $grupos);
                    foreach($array as $key){
                        if(trim($key)!=""){
                            $datos[$i] = array(
                                "descrip" => "$key",
                            );  
                            $i++;
                        }
                    }
                }
                $info = $this->conta_model->getInfoAuxi($idrnum);
                $array = array(
                    "grupos"=>$datos,
                    "info" =>$info
                );
                echo json_encode($array);
            }
        }
        
        function viewGruposUpd(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $valor_num = $this->input->post('idrnum'); 
                $this->load->model('conta_model');
                $grupos = $this->conta_model->viewGrupo2($valor_num);
                $idrnum = $this->conta_model->getIdrnum($valor_num);
                $datos = array();
                $i = 0;
                
                if($grupos!=null || $grupos!=""){
                    $array = explode(",", $grupos);
                    foreach($array as $key){
                        if(trim($key)!=""){
                            $datos[$i] = array(
                                "descrip" => "$key",
                            );  
                            $i++;
                        }
                    }
                }
                $info = $this->conta_model->getInfoAuxi($idrnum);
                $array = array(
                    "grupos"=>$datos,
                    "info" =>$info
                );
                echo json_encode($array);
            }
        }
        
        function updateGrupo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $cadena="";
                $nuevo = $this->input->post('nuevo');
                $viejo = $this->input->post('viejo');
                $this->load->model('conta_model');
                $idrnum = $this->input->post('idrnum'); 
                $cadena = $this->conta_model->viewGrupo($idrnum);
                $new_cadena ="";
                if($cadena!=null || $cadena!=""){
                    $array = explode(",", $cadena);
                    foreach($array as $key){
                        if(trim($key)==trim($viejo)){
                            if(trim($nuevo)!=""){
                                $new_cadena.=",".$nuevo;
                            }
                        }else{
                            if(trim($key)!=""){
                                $new_cadena.=",".$key;
                            }
                        }
                    }
                }
                $this->conta_model->updateGrupo($idrnum, $new_cadena); 
                echo json_encode(true);
            }
        }
        
        function newGrupo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $cadena="";
                $nuevo = $this->input->post('nuevo');
                $idrnum = $this->input->post('idrnum'); 
                $this->load->model('conta_model');
                $cadena = $this->conta_model->viewGrupo($idrnum);
                if(trim($cadena)=="" && trim($cadena)==null){
                    if(trim($nuevo)!=""){
                        $grupos = $nuevo;
                    }
                }else{
                    if(trim($nuevo)!=""){
                        $grupos = $cadena.','.$nuevo;
                    }
                }
                $this->conta_model->updateGrupo($idrnum,$grupos); 
                echo json_encode(true);
            }
        }
            
        function deleteGrupo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $eliminado = $this->input->post('eliminado');
                $idrnum = $this->input->post('idrnum'); 
                $this->load->model('conta_model');
                $cadena = $this->conta_model->viewGrupo($idrnum);
                        
                $new_cadena ="";
                if($cadena!=null || $cadena!=""){
                    $array = explode(",", $cadena);
                    foreach($array as $key){
                        if($key==$eliminado){
                        }else{
                            if(trim($new_cadena)!=""){
                                if(trim($key)!=""){
                                    $new_cadena.=",".$key;
                                }
                            }else{
                                if(trim($key)!=""){
                                    $new_cadena.=$key;
                                }
                            }
                        }
                    }
                }
                $this->conta_model->updateGrupo($idrnum,$new_cadena); 
                echo json_encode(true);
            }
        }
        
        function listaaplica($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
                $controladore = $this->uri->segment(1);
                $funcione = $this->uri->segment(2);
                $direccione = $controladore.'/'.$funcione;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccione);
                
                $this->load->view('mantenimiento_ctaplica', $this->data); 
            }   
        }
        
        function verAplicaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('conta_model');
                $array = $this->conta_model->viewAplicaciones();
                echo json_encode($array);
            }
        }
        
        function newct_aplica(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('conta_model');
                $this->data['tipos'] = $this->conta_model->viewTiposDef();
                $this->load->view('new_ctaplicaciones', $this->data);
            }
        }
        
        function registrar_ctApp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($this->input->post()){
                    $descrip = $this->input->post('descrip');
                    $esta = $this->input->post('estado');
                    $not = $this->input->post('notas');
                    $notas = str_replace(array("\n", "\r", "\n\r"), " ", $not);
                    $whodidit = $this->session->userdata('iduser');
                    $idptipo = $this->input->post('idptipo'); 
                    $iv = $this->input->post('retencion');
                    
                    if($iv== "true"){
                        
                        $iva = 1;
                    }else{
                        $iva = 0;
                        
                    }
                    
                    if($esta == "true"){
                        $estado = 1;
                    }else{
                        $estado = 0;
                    }
                    $this->load->model('conta_model');
                    $this->conta_model->insertApp($descrip,$idptipo,$notas,$whodidit,$estado,$iva); 
                }else{
                    $this->listaaplica($this->session->userdata('iddApp'));
                }
            }
        }
        
        function modificarCt_aplica($id){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('conta_model');
                $this->data['idaplica'] = $id;
                $this->data['datos'] = $this->conta_model->viewDatosAplica($id);
                $this->data['tipos'] = $this->conta_model->viewTiposDef();
                $this->load->view('mod_ctaplicaciones', $this->data);
            }
        }
        
        function update_ctApp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($this->input->post()){
                    $id = $this->input->post('idaplica');
                    $descrip = $this->input->post('descrip');
                    $esta = $this->input->post('estado');
                    $not = $this->input->post('notas');
                    $notas = str_replace(array("\n", "\r", "\n\r"), " ", $not);
                    $whodidit = $this->session->userdata('iduser');
                    $idptipo = $this->input->post('idptipo'); 
                    $iv = $this->input->post('retencion');
                    
                    if($iv== "true"){
                        
                        $iva = 1;
                    }else{
                        $iva = 0;
                        
                    }
                    
                    if($esta == "true"){
                        $estado = 1;
                    }else{
                        $estado = 0;
                    }
                    $this->load->model('conta_model');
                    $this->conta_model->updateApp($descrip,$idptipo,$notas,$whodidit,$estado,$iva,$id); 
                }else{
                    $this->listaaplica($this->session->userdata('iddApp'));
                }
            }
        }
        
        function detalleAplicacion($idaplica){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                
                $this->load->model('conta_model');
                $this->data['informacion'] = $this->conta_model->viewAplicacion($idaplica);
                $this->data['idaplica'] = $idaplica;
                $this->load->view('mantenimiento_detalle_aplicacion', $this->data);
            }
        }
        
        function getDatosaplica_100d(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idaplica = $this->input->post('idaplica');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getDataAplica_100d($idaplica);	
                echo json_encode($array);
            }
        }
        
        function deleteDetalleAp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idaplica = $this->input->post('idaplica');
                    
                $this->load->model('conta_model');
                $this->conta_model->deleteDataAplica_100d($idrec);
                $array = $this->conta_model->getDataAplica_100d($idaplica);
                echo json_encode($array);
            }
        }
        
        function listactbtipos($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
                $this->load->model('conta_model');
                $this->load->model('variable_model');
                $controladore = $this->uri->segment(1);
                $funcione = $this->uri->segment(2);
                $direccione = $controladore.'/'.$funcione;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccione);
                $this->data['controles'] = $this->variable_model->getVariablesNombre("ct_control");
                $this->data['cuentas'] = $this->conta_model->viewCuentas();
                
                $this->load->view('mantenimiento_listactbtipos', $this->data); 
            }   
        }
        
        function getAuxiliaresCuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcuenta = $this->input->post('idcuenta');
                $this->load->model('conta_model');
                $auxiliares = $this->conta_model->getAuxiliaresCuenta($idcuenta);
                echo json_encode($auxiliares);
            }
        }
        
        function getCorrelativos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxi = $this->input->post('idauxi');
                $this->load->model('conta_model');
                $Correlativos = $this->conta_model->getCorrelativos($idauxi);
                echo json_encode($Correlativos);
            }
        }
        
        function insertCorrelativo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxi = $this->input->post('idauxi');
                $idcuenta = $this->input->post('idcuenta');
                $tipoDoc = $this->input->post('tipoDoc');
                $serie = $this->input->post('serie');
                $desde = $this->input->post('desde');
                $hasta = $this->input->post('hasta');
                $actual = $this->input->post('actual');
                $reserva = $this->input->post('reserva');
                $form = $this->input->post('form');
                $aplica = $this->input->post('aplica');
                $bdate = $this->input->post('bdate');
                $edate = $this->input->post('edate');
                $estado = $this->input->post('estado');
                $notas = $this->input->post('notas');
                $this->load->model('conta_model');
                $insercion = $this->conta_model->insertCorrelativo($idauxi, $idcuenta, $tipoDoc, $serie, $desde, $hasta, $actual, $reserva, $form, $aplica, $bdate, $edate, $estado, $notas);
                
                $correlativos = $this->conta_model->getCorrelativos($idauxi);
                echo json_encode($correlativos);
            }
        }
        
        function updateCorrelativo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idbtipo = $this->input->post('idbtipo');
                $idauxi = $this->input->post('idauxi');
                $tipoDoc = $this->input->post('tipoDoc');
                $serie = $this->input->post('serie');
                $desde = $this->input->post('desde');
                $hasta = $this->input->post('hasta');
                $actual = $this->input->post('actual');
                $reserva = $this->input->post('reserva');
                $form = $this->input->post('form');
                $aplica = $this->input->post('aplica');
                $bdate = $this->input->post('bdate');
                $edate = $this->input->post('edate');
                $estado = $this->input->post('estado');
                $notas = $this->input->post('notas');
                $this->load->model('conta_model');
                $insercion = $this->conta_model->updateCorrelativo($idbtipo, $tipoDoc, $serie, $desde, $hasta, $actual, $reserva, $form, $aplica, $bdate, $edate, $estado, $notas);
                
                $correlativos = $this->conta_model->getCorrelativos($idauxi);
                echo json_encode($correlativos);
            }
        }
        
        function epartidas($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $controladore = $this->uri->segment(1);
                $funcione = $this->uri->segment(2);
                $direccione = $controladore.'/'.$funcione;
                
                $this->load->model('global_model');
                $this->load->model('conta_model');
                
                $this->data['years'] = $this->conta_model->getPeriodos();
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccione);
                $this->load->view('mantenimiento_epartidas', $this->data); 
            }   
        }
        
        function getPartidasLista(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $year = $this->input->post('idano');
                $idmes = $this->input->post('idmes');
                
                $this->load->model('conta_model');
                $partidas = $this->conta_model->getListadoPartidasMes($idmes, $year);
                
                $i=0;
                $array = array();
                foreach($partidas as $info){
                    $array[$i] = array(
                        "idptipo" => $info->idptipo,
                        "descrip" => $info->descrip,
                        "total" => $info->total
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
        function getNextNumeroPartidas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $year = $this->input->post('idano');
                $idmes = $this->input->post('idmes');
                $idptipo = $this->input->post('idptipo');
                
                $this->load->model('conta_model');
                $numero = $this->conta_model->getNextNumeroPartidas($idmes, $year, $idptipo);
                $datos = $this->conta_model->getFechasNumeroPartidas($idmes, $year, $idptipo);
                
                foreach($datos as $info){
                    $bfecha = $info->fechaini;
                    $efecha = $info->fechafin;
                }
                
                $array = array(
                    "numero" => $numero,
                    "bfecha" => $bfecha,
                    "efecha" => $efecha
                );
                
                echo json_encode($array);
            }
        }
        
        function insertRegistroConta100(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $idptipo = $this->input->post('idptipo');
                $numero = $this->input->post('numero');
                $fecha = $this->input->post('fecha');
                $referencia = $this->input->post('referencia');
                $descripcion = $this->input->post('descripcion');
                $estado = $this->input->post('estado');
                $notas = $this->input->post('notas');
                $year = $this->input->post('idano');
                $idmes = $this->input->post('idmes');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->insertRegistroConta100($idptipo, $numero, $fecha, $referencia, $descripcion, $estado, $notas, $year, $idmes, $idcentro);

                echo json_encode($array);
            }
        }
        
        function getRegistrosConta100(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idptipo = $this->input->post('idptipo');
                $year = $this->input->post('idano');
                $idmes = $this->input->post('idmes');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getRegistrosConta100($idptipo,$year, $idmes);

                echo json_encode($array);
            }
        }
        
        function detalle_epartidas($pnumero, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('conta_model');
                $this->data['yeartable'] = $year;
                $this->data['informacion'] = $this->conta_model->getDetailPartida($pnumero, $year);
                $this->data['totalDebe'] = $this->conta_model->getTotalDebePartida($pnumero, $year);
                $this->data['totalHaber'] = $this->conta_model->getTotalHaberPartida($pnumero, $year);
                $this->data['totalLineas'] = $this->conta_model->getTotalLineasPartida($pnumero, $year);
                $this->load->view('mantenimiento_detalle_epartida', $this->data);
            }
        }
        
        function getListadoCatalogoPartida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('conta_model');
                
                $data_cat1 = $this->conta_model->getListadoCatalogoPartida14();
                $data_cat2 = $this->conta_model->getListadoCatalogoPartida235();
                
                $array = array(
                    "ctgrupo14" => $data_cat1,
                    "ctgrupo235" => $data_cat2
                );
                
                echo json_encode($array);
            }
        }
        
        function getCatalogoByCuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcuenta = $this->input->post('idcuenta');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getCatalogoCuentasByCodigo($idcuenta);
                echo json_encode($array);
            }
        }
        
        function getDatosControlBancos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxidef = $this->input->post('idauxidef');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getAuxiliaresByAuxidef($idauxidef);
                echo json_encode($array);
            }
        }
        
        function getDatosAuxiliaresCuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxidef = $this->input->post('idauxidef');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getAuxiliaresByAuxidef($idauxidef);
                echo json_encode($array);
            }
        }
        
        function getDatosAuxiliaresUso(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxidef = $this->input->post('idauxidef');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getAuxiliaresByUso($idauxidef, $year);
                echo json_encode($array);
            }
        }
        
        function getDatosMovimientosCuentaAuxiliar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxi = $this->input->post('idauxi');
                $idcuenta = $this->input->post('idcuenta');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getMovimientosByAuxiCuenta($idauxi, $idcuenta);
                echo json_encode($array);
            }
        }
        
        function getDatosProyectos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('conta_model');
                $array = $this->conta_model->getListadoProyectos();
                echo json_encode($array);
            }
        }
        
        function getDatosSerieNumeroMovimiento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idbtipo = $this->input->post('idbtipo');
                
                $this->load->model('conta_model');
                $informacion = $this->conta_model->getCorrelativosMovimiento($idbtipo);
                
                $array = array();
                foreach($informacion as $info){
                    $total = $info->hasta - $info->actual;
                    if($total >= 10){
                        for($i=0; $i<10; $i++){
                            $numero = $info->actual + $i + 1;
                            $array[$i] = array(
                                "serienumero" => $info->serie."".$numero,
                                "sernum" => $info->serie."/".$numero
                            );
                        }
                    }else{
                        for($i=0; $i<$total; $i++){
                            $numero = $info->actual + $i + 1;
                            $array[$i] = array(
                                "serienumero" => $info->serie."".$numero,
                                "sernum" => $info->serie."/".$numero
                            );
                        }
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getInformacionContaDT(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $pnumero = $this->input->post('pnumero');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getInformacionContaDT($pnumero, $year);
                echo json_encode($array);
            }
        }
        
        function insertRegistroContaDT(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $pnumero = $this->input->post('pnumero');
                $idcuenta = $this->input->post('idcuenta');
                $idauxi = $this->input->post('idauxi');
                $descrip = $this->input->post('descrip');
                $idbtipo = $this->input->post('idbtipo');
                $serienumero = $this->input->post('serienumero');
                $valor = $this->input->post('valor');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->insertarRegistroContaDT($pnumero, $idcuenta, $idauxi, $descrip, $idbtipo, $serienumero, $valor, $year);
                echo json_encode($array);
            }
        }
        
        function updateRegistroContaDT(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $movnum = $this->input->post('movnum');
                $idauxi = $this->input->post('idauxi');
                $descrip = $this->input->post('descrip');
                $idbtipo = $this->input->post('idbtipo');
                $serienumero = $this->input->post('serienumero');
                $valor = $this->input->post('valor');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->updateRegistroContaDT($movnum, $idauxi, $descrip, $idbtipo, $serienumero, $valor, $year);
                echo json_encode($array);
            }
        }
        
        function insertRegistroControl0(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $pnumero = $this->input->post('pnumero');
                $idcuenta = $this->input->post('idcuenta');
                $idauxi = $this->input->post('idauxi');
                $descrip = $this->input->post('descrip');
                $idproyecto = $this->input->post('idproyecto');
                $idcentro = $this->input->post('idcentro');
                $notas = $this->input->post('notas');
                $debe = $this->input->post('debe');
                $haber = $this->input->post('haber');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->insertarRegistroControl0($pnumero, $idcuenta, $idauxi, $descrip, $idproyecto, $idcentro, $notas, $debe, $haber, $year);
                echo json_encode($array);
            }
        }
        
        function insertRegistroControl0ConAuxi(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $pnumero = $this->input->post('pnumero');
                $idcuenta = $this->input->post('idcuenta');
                $idauxi = $this->input->post('idauxi');
                $sidauxi = $this->input->post('sidauxi');
                $descrip = $this->input->post('descrip');
                $idproyecto = $this->input->post('idproyecto');
                $idcentro = $this->input->post('idcentro');
                $notas = $this->input->post('notas');
                $debe = $this->input->post('debe');
                $haber = $this->input->post('haber');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->insertarRegistroControl0ConAuxi($pnumero, $idcuenta, $idauxi, $sidauxi, $descrip, $idproyecto, $idcentro, $notas, $debe, $haber, $year);
                echo json_encode($array);
            }
        }
        
        function getTotalDatosPartida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $pnumero = $this->input->post('pnumero');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $totalDebe = $this->conta_model->getTotalDebePartida($pnumero, $year);
                $totalHaber = $this->conta_model->getTotalHaberPartida($pnumero, $year);
                $totalLineas = $this->conta_model->getTotalLineasPartida($pnumero, $year);
                
                $array = array(
                    "totalDebe" => number_format($totalDebe, 2, '.', ','),
                    "totalHaber" => number_format($totalHaber, 2, '.', ','),
                    "totalLineas" => number_format($totalLineas)
                );
                echo json_encode($array);
            }
        }
        
        function getDatosAutocomplete(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcuenta = $this->input->post('idcuenta');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $informacion = $this->conta_model->getInformacionAutocomplete($idcuenta, $year);
                if($informacion != false){
                    $i=0;
                    $array = array();
                    foreach($informacion as $info){
                        $array[$i] = array($info->descrip);
                        $i++;
                    }
                }else{
                    $array = $informacion;
                }
                echo json_encode($array);
            }
        }
        
        function getDatosAutocompleteSidauxi(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcuenta = $this->input->post('idcuenta');
                $sidauxi = $this->input->post('sidauxi');
                $year = $this->input->post('year');
                $idauxi = $this->input->post('idauxi');
                
                $this->load->model('conta_model');
                $informacion = $this->conta_model->getInformacionAutocompleteFiltrada($idcuenta, $sidauxi, $year, $idauxi);
                if($informacion != false){
                    $i=0;
                    $array = array();
                    foreach($informacion as $info){
                        $array[$i] = array($info->descrip);
                        $i++;
                    }
                }else{
                    $array = $informacion;
                }
                echo json_encode($array);
            }
        }
        
        function getDatosCentroCostos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('sucursal_model');
                $array = $this->sucursal_model->viewSucursalActiva();
                
                echo json_encode($array);
            }
        }
        
        function getResultadoAutocomplete(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $textComplete = $this->input->post('textComplete');
                $idcuenta = $this->input->post('idcuenta');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $informacion = $this->conta_model->getResultadoAutocomplete($textComplete, $idcuenta, $year);
                
                $i=0;
                foreach($informacion as $info){
                    $i++;
                }
                
                $array = array(
                    "cantidad" => $i,
                    "datos" => $informacion
                );
                echo json_encode($array);
            }
        }
        
        function deleteRegistroContaDT(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $movnum = $this->input->post('movnum');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->deleteRegistroContadt($movnum, $year);
                echo json_encode($array);
            }
        }
        
        function getCatalogoMasUsado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getCatalogoMasUsado($year);
                echo json_encode($array);
            }
        }
        
        function getDatosContactosAuxiliaresCuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $filtros = $this->input->post('filtros');
                $year = $this->input->post('year');
                
                $this->load->model('conta_model');
                if($filtros != "" || $filtros != null){
                    $array = $this->conta_model->getDatosContactosAuxiliaresCuenta($filtros, $year);
                }else{
                    $array = array();
                }
                echo json_encode($array);
            }
        }
        
        function getListadoFiltrosAuxiliar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idAuxis = $this->input->post('filtros');
                $array = array();
                
                $this->load->model('conta_model');
                
                if($idAuxis != null || $idAuxis != ""){
                    $arrayAuxis = explode(",", $idAuxis);
                    $total = count($arrayAuxis);
                    
                    for($i=0; $i<$total; $i++){
                        $descrip = $this->conta_model->getInformacionAuxiliarDef($arrayAuxis[$i]);
                        $array[$i] = array(
                            "idauxidef" => $arrayAuxis[$i],
                            "descrip" => $descrip
                        );
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getListadoFiltrosAuxiliarAll(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idAuxis = $this->input->post('filtros');
                $array = array();
                
                $this->load->model('conta_model');
                
                if($idAuxis != null || $idAuxis != ""){
                    $arrayAuxis = explode(",", $idAuxis);
                    $total = count($arrayAuxis);
                    
                    $array[0] = array(
                        "idauxidef" => $idAuxis,
                        "descrip" => "Todos"
                    );
                    $j=1;
                    for($i=0; $i<$total; $i++){
                        $descrip = $this->conta_model->getInformacionAuxiliarDef($arrayAuxis[$i]);
                        $array[$j] = array(
                            "idauxidef" => $arrayAuxis[$i],
                            "descrip" => $descrip
                        );
                        $j++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function insertContactoAuxiliar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idauxidef = $this->input->post('idauxidef');
                $descrip = $this->input->post('descrip');
                $duinrc = $this->input->post('duinrc');
                $nit = $this->input->post('nit');
                $telefono = $this->input->post('telefono');
                $correo = $this->input->post('correo');
                
                $this->load->model('conta_model');
                $idauxi = $this->conta_model->insertContactoAuxiliar($idauxidef, $descrip, $duinrc, $nit, $telefono, $correo);
                
                $array = array(
                    "idauxi" => $idauxi,
                    "descrip" => $descrip
                );
                
                echo json_encode($array);
            }
        }
        
        function getDatosFrecuentesContacto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcuenta = $this->input->post('idcuenta');
                $year = $this->input->post('year');
                $idauxidef = $this->input->post('idauxidef');
                $sidauxi = $this->input->post('sidauxi');
                
                $this->load->model('conta_model');
                $informacion = $this->conta_model->getFrecuentesContacto($idcuenta,$year,$idauxidef,$sidauxi);
                
                $i=0;
                $array = array();
                
                foreach($informacion as $info){
                    $tdh = 1;
                    if($info->debe == 0){
                        $tdh = 2;
                        $valor = $info->haber;
                    }
                    if($info->haber == 0){
                        $tdh = 1;
                        $valor = $info->debe;
                    }
                    
                    $array[$i] = array(
                        "descrip" => $info->descrip,
                        "centrocostos" => $info->centrocostos,
                        "proyecto" => $info->proyecto,
                        "valor" => $valor,
                        "idauxi" => $info->idauxi,
                        "idcentro" => $info->idcentro,
                        "idproject" => $info->idproject,
                        "tdh" => $tdh
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
        function generacionMovimientoContables($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $funcionName = $this->uri->segment(1);
                
                $this->load->model('global_model');$this->load->model('conta_model');
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($funcionName);
                $this->data['tipoFiltro'] = $this->conta_model->getTipoFiltroPartida();
                $this->data['AModulos'] = $this->configuracion_model->getApps($idApp);
                $this->load->view('mantenimiento_generacion_contabilidad', $this->data); 
            }
        }
        
        function getMovimientosContables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaInicial = $this->input->post('fechaini');
                $fechaFinal = $this->input->post('fechafin');
                $filtro = $this->input->post('filtro');

                $this->load->model('conta_model');
                $movContables = $this->conta_model->getMovimientosContables($filtro);
                
                $i=0;
                $array = array();
                foreach($movContables as $info){
                    $idclases = $info->idclases;
                    $cajclases = $info->cajclases;
                    $iddptos = $info->iddptos;
                    $idlineas = $info->idlineas;
                    $idcentros = $info->idcentros;
                    $idcajas = $info->idcajas;
                    
                    switch($info->funcion){
                        case "getPagos":
                            $infoConsulta = $this->conta_model->getPagos($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1,
                                        
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getPagoscxc":
                            $infoConsulta = $this->conta_model->getPagoscxc($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getIvaVentas":
                            $infoConsulta = $this->conta_model->getIvaVentas($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getVentasDpto":
                            $infoConsulta = $this->conta_model->getVentasDpto($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $iddptos, $idlineas);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getCostoVentas":
                            $infoConsulta = $this->conta_model->getCostoVentas($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $iddptos, $idlineas);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getCostoVentasMensual":
                            $infoConsulta = $this->conta_model->getCostoVentasMensual($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $iddptos, $idlineas);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getAbonosCxc":
                            $infoConsulta = $this->conta_model->getAbonosCxc($idcentros, $idcajas, $fechaInicial, $fechaFinal, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getRemesasCxc":
                            $infoConsulta = $this->conta_model->getRemesasCxc($idcentros, $idcajas, $fechaInicial, $fechaFinal, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getRetencion":
                            $infoConsulta = $this->conta_model->getRetencion($idcentros, $idcajas, $fechaInicial, $fechaFinal, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getComprasCxp":
                            $infoConsulta = $this->conta_model->getComprasCxp($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe  = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    if($data->clientexpos == ""){
                                        $id_auxi = $data->nrc;
                                    }else{
                                        $id_auxi = $data->clientexpos;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $id_auxi,
                                        "notas" => "",
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getComprasProv":
                            $infoConsulta = $this->conta_model->getComprasProv($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe  = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    if($data->clientexpos == ""){
                                        $id_auxi = $data->nrc;
                                    }else{
                                        $id_auxi = $data->clientexpos;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $id_auxi,
                                        "notas" => "",
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getGastosCxp":
                            $infoConsulta = $this->conta_model->getGastosCxp($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe  = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    if($data->clientexpos == ""){
                                        $id_auxi = $data->nrc;
                                    }else{
                                        $id_auxi = $data->clientexpos;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $id_auxi,
                                        "notas" => "",
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getComprasCxpE":
                            $infoConsulta = $this->conta_model->getComprasCxpE($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    if($data->clientexpos == ""){
                                        $id_auxi = $data->nrc;
                                    }else{
                                        $id_auxi = $data->clientexpos;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $id_auxi,
                                        "notas" => "",
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getGastosCxpE":
                            $infoConsulta = $this->conta_model->getGastosCxpE($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    if($data->clientexpos == ""){
                                        $id_auxi = $data->nrc;
                                    }else{
                                        $id_auxi = $data->clientexpos;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $id_auxi,
                                        "notas" => "",
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getComprasRet":
                            $infoConsulta = $this->conta_model->getComprasRet($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $descrip_gen = trim($info->descrip);
                                    $descrip_gen = str_replace("&", trim($data->namecliente), $descrip_gen);
                                    $descrip_gen = str_replace("#", "N°: " . $data->docnum, $descrip_gen);
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => $descrip_gen,
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getGastosRet":
                            $infoConsulta = $this->conta_model->getGastosRet($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $descrip_gen = trim($info->descrip);
                                    $descrip_gen = str_replace("&", trim($data->namecliente), $descrip_gen);
                                    $descrip_gen = str_replace("#", "N°: " . $data->docnum, $descrip_gen);
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => $descrip_gen,
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getIvaCompras":
                            $infoConsulta = $this->conta_model->getIvaCompras($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => "",
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getIvaGastos":
                            $infoConsulta = $this->conta_model->getIvaGastos($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => "",
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getComprasDpto":
                            $infoConsulta = $this->conta_model->getComprasDpto($idcentros, $fechaInicial, $fechaFinal, $idclases, $iddptos, $idlineas);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => "",
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getGastosDpto":
                            $infoConsulta = $this->conta_model->getGastosDpto($idcentros, $fechaInicial, $fechaFinal, $idclases, $iddptos, $idlineas);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => "",
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->descripcion),
                                        "idcuenta" => trim($data->xpos),
                                        "idauxi" => trim($data->idprovee),
                                        "notas" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getVentasCxc":
                            $infoConsulta = $this->conta_model->getVentasCxc($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $data->clientexpos,
                                        "notas" => "",
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format(abs($valorDebe), 2, '.', '') * 1,
                                        "haber" => number_format(abs($valorHaber), 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getDetAbonosCxc":
                            $infoConsulta = $this->conta_model->getDetAbonosCxc($idcentros, $fechaInicial, $fechaFinal, $idclases, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro"    => $data->idcentro,
                                        "namecentro"  => $data->namecentro,
                                        "namecaja"    => $data->namecaja,
                                        "partipo"     => $info->partipo,
                                        "centroxpos"  => $data->centroxpos,
                                        "cajaxpos"    => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja"      => $data->idcaja,
                                        "fecha"       => $data->fecha,
                                        "tipo"        => trim($info->tipo),
                                        "posicion"    => $info->posicion,
                                        "descrip"     => trim($info->descrip),
                                        "idcuenta"    => trim($info->idcuenta),
                                        "idauxi"      => $data->clientexpos,
                                        "notas"       => "",
                                        "docnum"      => $data->numero,
                                        "docfecha"    => $data->fecha,
                                        "docvence"    => $data->fecvence,
                                        "debe"        => number_format(abs($valorDebe), 2, '.', '') * 1,
                                        "haber"       => number_format(abs($valorHaber), 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        default:
                            break;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function getArchivoMovimientosContables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $informacionArchivo = $this->input->post('dataString');
                
                $archivoTxt = fopen("MovimientosContables.txt",'w+');
                fwrite($archivoTxt, $informacionArchivo);
                fclose($archivoTxt);
                    
                $docTxt = "MovimientosContables.txt";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }

        function mantenimientoGeneracionContable(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])  || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'appName' => 'Generación Contable',
                    'namePage' => 'Generación Contable'
                );
                $this->session->set_userdata($resultAppName);
                $funcionName = $this->uri->segment(1);
                
                $this->load->model('global_model'); $this->load->model('conta_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($funcionName);
                $this->data['tipoPartida'] = $this->conta_model->getTipoDePartida('conta_gen');
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
                $this->data['cajas'] = $this->caja_model->getListadoCajas();
                $this->data['transacciones'] = $this->conta_model->getListadoTransacciones();
                $this->data['formaspago'] = $this->conta_model->getListadoFormasDePago();
                $this->data['cuentasbanco'] = $this->conta_model->getListadoCuentasDeBanco();
                $this->data['departamentos'] = $this->conta_model->getListadoDepartamentos();
                $this->data['lineas'] = $this->conta_model->getListadoLineas();

                $this->load->view('mantenimiento_generacion_contable', $this->data); 
            }
        }

        function getListadoGeneracionContable(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipo_partida = $this->input->post('tipo_partida');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getListadoMovimientosContables($tipo_partida);

                echo json_encode($array);
            }
        }

        function getLastPosicionTipoPartida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipo_partida = $this->input->post('partipo');
                
                $this->load->model('conta_model');
                $array = $this->conta_model->getLastPosicionTipoPartida($tipo_partida);

                echo json_encode($array);
            }
        }

        function adicionarMovimientoContable(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $partipo = $this->input->post('partipo');
                $posicion = $this->input->post('posicion');
                $idcuenta = $this->input->post('idcuenta');
                $idauxi = $this->input->post('idauxi');
                $descrip = $this->input->post('descrip');
                $funcion = $this->input->post('funcion');
                $tipo = $this->input->post('tipo');
                $dh = $this->input->post('dh');
                $estado = $this->input->post('estado');
                $notas = $this->input->post('notas');
                $idcentros = $this->input->post('idcentros');
                $idcajas = $this->input->post('idcajas');
                $idclases = $this->input->post('idclases');
                $cajclases = $this->input->post('cajclases');
                $iddptos = $this->input->post('iddptos');
                $idlineas = $this->input->post('idlineas');
                
                $this->load->model('conta_model');
                $this->conta_model->adicionarMovimientoContable($partipo, $posicion, $idcuenta, $idauxi, $descrip, $funcion, $tipo, $dh, $estado, $notas, $idcentros, $idcajas, $idclases, $cajclases, $iddptos, $idlineas);
                $array = $this->conta_model->getListadoMovimientosContables($partipo);

                echo json_encode($array);
            }
        }

        function modificarMovimientoContable(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $partipo = $this->input->post('partipo');
                $posicion = $this->input->post('posicion');
                $idcuenta = $this->input->post('idcuenta');
                $idauxi = $this->input->post('idauxi');
                $descrip = $this->input->post('descrip');
                $funcion = $this->input->post('funcion');
                $tipo = $this->input->post('tipo');
                $dh = $this->input->post('dh');
                $estado = $this->input->post('estado');
                $notas = $this->input->post('notas');
                $idcentros = $this->input->post('idcentros');
                $idcajas = $this->input->post('idcajas');
                $idclases = $this->input->post('idclases');
                $cajclases = $this->input->post('cajclases');
                $iddptos = $this->input->post('iddptos');
                $idlineas = $this->input->post('idlineas');
                
                $this->load->model('conta_model');
                $this->conta_model->modificarMovimientoContable($idrec, $partipo, $posicion, $idcuenta, $idauxi, $descrip, $funcion, $tipo, $dh, $estado, $notas, $idcentros, $idcajas, $idclases, $cajclases, $iddptos, $idlineas);
                $array = $this->conta_model->getListadoMovimientosContables($partipo);

                echo json_encode($array);
            }
        }

        function eliminarGeneracionContable(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $partipo = $this->input->post('tipo_partida');
                
                $this->load->model('conta_model');
                $this->conta_model->eliminarGeneracionContable($idrec);
                $array = $this->conta_model->getListadoMovimientosContables($partipo);

                echo json_encode($array);
            }
        }

        function limpiarGeneracionContable(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $partipo = $this->input->post('tipo_partida');
                
                $this->load->model('conta_model');
                $this->conta_model->limpiarGeneracionContable($partipo);
                $array = $this->conta_model->getListadoMovimientosContables($partipo);

                echo json_encode($array);
            }
        }

        function getListadoTipoPartidas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $partipo = $this->input->post('partipo');
                
                $this->load->model('conta_model');
                $informacion = $this->conta_model->getTipoDePartida('conta_gen');

                $i=0;
                $array = array();

                foreach($informacion as $info){
                    if(number_format($partipo, 0) != number_format($info->valor_num, 0)){
                        $array[$i] = array(
                            "id" => number_format($info->valor_num, 0),
                            "descrip" => $info->descripcion
                        );

                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function copiarMovimientosContables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $partipo = $this->input->post('partipo');
                $copiapartida = $this->input->post('copiapartida');
                $idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                
                $this->load->model('conta_model');
                $this->conta_model->copiarMovimientosContables($partipo, $copiapartida, $idcentro, $idcaja);
                $array = $this->conta_model->getListadoMovimientosContables($partipo);

                echo json_encode($array);
            }
        }

        function copiarRegistroMovimientosContables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $partipo = $this->input->post('partipo');
                $cantidad = $this->input->post('cantidad');

                $this->load->model('conta_model');
                $this->conta_model->copiarRegistroMovimientosContables($idrec, $partipo, $cantidad);
                $array = $this->conta_model->getListadoMovimientosContables($partipo);

                echo json_encode($array);
            }
        }
        
        function getCajasFiltradas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentros = $this->input->post('idcentros');
                
                $this->load->model('conta_model');
                $informacion = $this->conta_model->getDetalleCajasFiltradas($idcentros);
                
                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => "".round($info->idcaja)."",
                            "text" => $info->descrip
                        );
                        $i++;
                    }
                }
                echo json_encode($array);
            }
        }
        
        function getLineasFiltradas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $iddepartamentos = $this->input->post('iddepartamentos');
                
                $this->load->model('conta_model');
                $informacion = $this->conta_model->getDetalleLineasFiltradas($iddepartamentos);
                
                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => "".round($info->idcatalogo)."",
                            "text" => $info->descrip. ' - ('.$info->tipoProducto.')'
                        );
                        $i++;
                    }
                }
                echo json_encode($array);
            }
        }

        function sendMovimientosGoXpress(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $filtro       = $this->input->post('filtro');
                $fechaInicial = $this->input->post('fechaini');
                $fechaFinal   = $this->input->post('fechafin');

                $this->load->model('conta_model');
                $movContables = $this->conta_model->getMovimientosContables($filtro);
                
                $i=0;
                $array = array();
                foreach($movContables as $info){
                    if($info->tipoPartida == 'detallado' || $info->tipoPartida == 'DETALLADO'){
                        $tipoP = 1;
                    }else{
                        $tipoP = 0;
                    }

                    $idclases = $info->idclases; $cajclases = $info->cajclases; $iddptos = $info->iddptos;
                    $idlineas = $info->idlineas; $idcentros = $info->idcentros; $idcajas = $info->idcajas;
                    
                    switch($info->funcion){
                        case "getPagos":
                            $infoConsulta = $this->conta_model->getPagos($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getPagoscxc":
                            $infoConsulta = $this->conta_model->getPagoscxc($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getIvaVentas":
                            $infoConsulta = $this->conta_model->getIvaVentas($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getVentasDpto":
                            $infoConsulta = $this->conta_model->getVentasDpto($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $iddptos, $idlineas);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getCostoVentas":
                            $infoConsulta = $this->conta_model->getCostoVentas($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $iddptos, $idlineas);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getCostoVentasMensual":
                            $infoConsulta = $this->conta_model->getCostoVentasMensual($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $iddptos, $idlineas);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getAbonosCxc":
                            $infoConsulta = $this->conta_model->getAbonosCxc($idcentros, $idcajas, $fechaInicial, $fechaFinal, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getRemesasCxc":
                            $infoConsulta = $this->conta_model->getRemesasCxc($idcentros, $idcajas, $fechaInicial, $fechaFinal, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getRetencion":
                            $infoConsulta = $this->conta_model->getRetencion($idcentros, $idcajas, $fechaInicial, $fechaFinal, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getComprasCxp":
                            $infoConsulta = $this->conta_model->getComprasCxp($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe  = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente) ." N°: " . $data->docnum,
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $data->idcps,
                                        "notas" => "",
                                        "namedocumento" => $data->namedocumento,
                                        "serie" => $data->serie,
                                        "numero" => $data->docnum,
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getComprasProv":
                            $infoConsulta = $this->conta_model->getComprasProv($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe  = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente) ." N°: " . $data->docnum,
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $data->idcps,
                                        "notas" => "",
                                        "namedocumento" => $data->namedocumento,
                                        "serie" => $data->serie,
                                        "numero" => $data->docnum,
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getComprasCxpE":
                            $infoConsulta = $this->conta_model->getComprasCxpE($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente) ." N°: " . $data->docnum,
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $data->idcps,
                                        "notas" => "",
                                        "namedocumento" => $data->namedocumento,
                                        "serie" => $data->serie,
                                        "numero" => $data->docnum,
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getComprasRet":
                            $infoConsulta = $this->conta_model->getComprasRet($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $descrip_gen = trim($info->descrip);
                                    $descrip_gen = str_replace("&", trim($data->namecliente), $descrip_gen);
                                    $descrip_gen = str_replace("#", "N°: " . $data->docnum, $descrip_gen);

                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => $descrip_gen,
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => $data->namedocumento,
                                        "serie" => $data->serie,
                                        "numero" => $data->docnum,
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getIvaCompras":
                            $infoConsulta = $this->conta_model->getIvaCompras($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => "",
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getComprasDpto":
                            $infoConsulta = $this->conta_model->getComprasDpto($idcentros, $fechaInicial, $fechaFinal, $idclases, $iddptos, $idlineas);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => "",
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getVentasCxc":
                            $infoConsulta = $this->conta_model->getVentasCxc($idcentros, $idcajas, $fechaInicial, $fechaFinal, $idclases, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => $data->namecaja,
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => $data->cajaxpos,
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $data->clientexpos,
                                        "notas" => "",
                                        "namedocumento" => $data->namedocumento,
                                        "serie" => $data->serie,
                                        "numero" => $data->docnum,
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format(abs($valorDebe), 2, '.', '') * 1,
                                        "haber" => number_format(abs($valorHaber), 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getDetAbonosCxc":
                            $infoConsulta = $this->conta_model->getDetAbonosCxc($idcentros, $fechaInicial, $fechaFinal, $idclases, $cajclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro"      => $data->idcentro,
                                        "namecentro"    => $data->namecentro,
                                        "namecaja"      => $data->namecaja,
                                        "partipo"       => $info->partipo,
                                        "centroxpos"    => $data->centroxpos,
                                        "cajaxpos"      => $data->cajaxpos,
                                        "descripcion"   => $info->descripcion,
                                        "idcaja"        => $data->idcaja,
                                        "fecha"         => $data->fecha,
                                        "tipo"          => trim($info->tipo),
                                        "posicion"      => $info->posicion,
                                        "descrip"       => trim($data->namecliente),
                                        "idcuenta"      => trim($info->idcuenta),
                                        "idauxi"        => $data->clientexpos,
                                        "notas"         => "",
                                        "namedocumento" => $data->namedocumento,
                                        "serie"         => $data->serie,
                                        "numero"        => $data->docnum,
                                        "docnum"        => $data->numero,
                                        "docfecha"      => $data->fecha,
                                        "docvence"      => $data->fecvence,
                                        "debe"          => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber"         => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getGastosCxp":
                            $infoConsulta = $this->conta_model->getGastosCxp($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe  = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $data->idcps,
                                        "notas" => "",
                                        "namedocumento" => $data->namedocumento,
                                        "serie" => $data->serie,
                                        "numero" => $data->docnum,
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getGastosCxpE":
                            $infoConsulta = $this->conta_model->getGastosCxpE($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                                                        
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->namecliente),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => $data->idcps,
                                        "notas" => "",
                                        "namedocumento" => $data->namedocumento,
                                        "serie" => $data->serie,
                                        "numero" => $data->docnum,
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getGastosRet":
                            $infoConsulta = $this->conta_model->getGastosRet($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $descrip_gen = trim($info->descrip);
                                    $descrip_gen = str_replace("&", trim($data->namecliente), $descrip_gen);
                                    $descrip_gen = str_replace("#", "N°: " . $data->docnum, $descrip_gen);
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => $data->idcaja,
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => $descrip_gen,
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => $data->namedocumento,
                                        "serie" => $data->serie,
                                        "numero" => $data->docnum,
                                        "docnum" => $data->numero,
                                        "docfecha" => $data->fecha,
                                        "docvence" => $data->fecvence,
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getIvaGastos":
                            $infoConsulta = $this->conta_model->getIvaGastos($idcentros, $fechaInicial, $fechaFinal, $idclases);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => "",
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($info->descrip),
                                        "idcuenta" => trim($info->idcuenta),
                                        "idauxi" => trim($info->idauxi),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1
                                    );
                                    $i++;
                                }
                            }
                            break;
                        case "getGastosDpto":
                            $infoConsulta = $this->conta_model->getGastosDpto($idcentros, $fechaInicial, $fechaFinal, $idclases, $iddptos, $idlineas);
                            if($infoConsulta != false){
                                foreach($infoConsulta as $data){
                                    $valorDebe = 0;
                                    $valorHaber = 0;
                                    if($info->dh == 1){
                                        $valorDebe = $data->valorTotal;
                                    }else{
                                        $valorHaber = $data->valorTotal;
                                    }
                                    
                                    $array[$i] = array(
                                        "idcentro" => $data->idcentro,
                                        "namecentro" => $data->namecentro,
                                        "namecaja" => "",
                                        "partipo" => $info->partipo,
                                        "centroxpos" => $data->centroxpos,
                                        "cajaxpos" => "",
                                        "descripcion" => $info->descripcion,
                                        "idcaja" => "",
                                        "fecha" => $data->fecha,
                                        "tipo" => trim($info->tipo),
                                        "posicion" => $info->posicion,
                                        "descrip" => trim($data->descripcion),
                                        "idcuenta" => trim($data->xpos),
                                        "idauxi" => trim($data->idprovee),
                                        "notas" => "",
                                        "namedocumento" => "",
                                        "serie" => "",
                                        "numero" => "",
                                        "docnum" => "0",
                                        "docfecha" => "0000-00-00",
                                        "docvence" => "0000-00-00",
                                        "debe" => number_format($valorDebe, 2, '.', '') * 1,
                                        "haber" => number_format($valorHaber, 2, '.', '') * 1,
                                    );
                                    $i++;
                                }
                            }
                            break;
                        default:
                            break;
                    }
                }
                
                $result = $this->conta_model->sendMovimientosGoXpress($array);
                
                echo json_encode($result);
            }
        }
    }
?>