<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
    class Consigna extends CI_Controller {
        
        function __construct(){
			parent::__construct();
        }
        
        function mantenimiento_consignaciones($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('configuracion_model');$this->load->model('global_model');
                $this->load->model('sucursal_model');$this->load->model('ventas_model');
                $this->load->model('variable_model');$this->load->model('cliente_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $controlador = $this->uri->segment(1);
                $data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                                
                $idcentro = $this->variable_model->getTextVar("con_idcentro");
                $idcentro = $idcentro['valor_num'];
               
                $data['sucursales'] =  $this->sucursal_model->viewSucursalById($idcentro);
                $data['sucursalconsigna'] =  $idcentro; 

                $data['sucursales_envio']  = $this->sucursal_model->viewSucursalActiva();
                $data['tipo'] = $this->global_model->getValorNumVariable('gv_tipo');
                $data['con_idauxidef'] = $this->global_model->getValorNumVariable('con_idauxidef');
                $data['con_fpago'] = $this->global_model->getValorNumVariable('con_fpago');
                $docs = $this->variable_model->getTextVar('con_fdocs');
                $data['con_fdocs'] = $docs['valor_txt'];
                
                $this->session->set_userdata($resultAppName);
				$controlador = $this->uri->segment(1);
				$data['nombres'] = $this->variable_model->verNombres();
                $data['gzips'] = $this->global_model->getZips();
                $data['grupos'] = $this->cliente_model->viewGrupo();
                $data['limites'] = $this->cliente_model->verLimites();
                $data['dias'] = $this->cliente_model->verDias();
                $data['actividades'] = $this->cliente_model->verActividades();
                $data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $data['formasPago']  = $this->ventas_model->getFormasPagoVN('VN');
                $zip_variable = $this->variable_model->getTextVar("gv_zip");
                $idzip = $zip_variable['valor_num'];
                $data['idzip_default'] = round($idzip);
				$this->load->view('mantenimiento_consignaciones', $data);
			}
        }
        
        function getClientesTipo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('consigna_model');
                $tipo = $this->input->post("tipo");
                $datos = $this->consigna_model->getClientesTipo($tipo);
                echo json_encode($datos);
                
			}
        }
        
        function getClientesGrouped(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('consigna_model');
                $tipo = $this->input->post("tipo");
                $datos = $this->consigna_model->getClientesTipo($tipo);
                $array = array();
                $i=0;
                if($datos != false){
                    foreach($datos as $dat){
                        if($dat->existe==1){
                            $sucursales = $this->consigna_model->getSucCliente($dat->idauxi);
                            if($sucursales!=false){
                                $array[$i] = array(
                                    "descrip" => $dat->descrip,
                                    "key" => $dat->descrip,
                                    "items" => $sucursales,
                                    "idauxi" => $dat->idauxi
                                );
                                $i++;
                            }
                        }
                    }
                }
                echo json_encode($array);
			}
        }
        
        function adicionarCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                if($this->input->post()){
                    $idauxi_def = $this->input->post('idauxidef'); 
                    $des = $this->input->post('descrip');
                    $descrip = str_replace(array("\n", "\r", "\n\r"), " ", $des);
                    $grupo = trim($this->input->post('grupo'));
                    $telefono = $this->input->post('telefono');
                    $correo = $this->input->post('correo');
                    $direccion = $this->input->post('direccion');
                    $departamento = $this->input->post('departament');
                    $ingreso = $this->input->post('ingreso');
                    $nrc = $this->input->post('nrc');
                    $nit = $this->input->post('nit');
                    $actividad = $this->input->post('actividad');
                    $contribuyente = $this->input->post('contribuyente');
                    $vendedor = $this->input->post('vendedor');
                    $limite = $this->input->post('limite');
                    $dias = $this->input->post('dias');
                    $esta = $this->input->post('estado');
                    $xpos = $this->input->post('xpos');
                    $not = $this->input->post('notas');
                    $notas = str_replace(array("\n", "\r", "\n\r"), " ", $not);
                    $whodidit = $this->session->userdata('iduser');
                    $img = $this->input->post('imgen');
                    $this->load->model('consigna_model');
                    $idcliente = $this->consigna_model->insertCliente($idauxi_def, $descrip, $grupo, $telefono, $correo, $direccion, $departamento, $ingreso, $nrc, $nit, $actividad, $contribuyente, $vendedor, $limite, $dias, $img, $esta, $notas, $xpos, $whodidit); 
                    if($img!=""){
                        $archivo = 'imagenes';
                        $imgSplit = explode(".", $img);
                        $nameImg = "imgCliente_".$idcliente.".".$imgSplit[1];
                        $imgSplit = explode(".", $nameImg);
                        $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['file_name'] = $imgSplit[0];
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        if($this->upload->do_upload($archivo)){
                            $datos = $this->consigna_model->getClientesTipo($idauxi_def);
                        }else{
                            $datos = $this->consigna_model->getClientesTipo($idauxi_def);
                        }
                    }
                    $datos = $this->consigna_model->getClientesTipo($idauxi_def);
                    echo json_encode($datos);
                }else{
                    echo json_encode(false);
                }
            }
        }
        
        function actualizaCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                if($this->input->post()){
                    $idcliente = $this->input->post('idauxi'); 
                    $idauxi_def = $this->input->post('idauxidef'); 
                    $des = $this->input->post('descrip');
                    $descrip = str_replace(array("\n", "\r", "\n\r"), " ", $des);
                    $grupo = trim($this->input->post('grupo'));
                    $telefono = $this->input->post('telefono');
                    $correo = $this->input->post('correo');
                    $direccion = $this->input->post('direccion');
                    $departamento = $this->input->post('departament');
                    $ingreso = $this->input->post('ingreso');
                    $nrc = $this->input->post('nrc');
                    $nit = $this->input->post('nit');
                    $actividad = $this->input->post('actividad');
                    $contribuyente = $this->input->post('contribuyente');
                    $vendedor = $this->input->post('vendedor');
                    $limite = $this->input->post('limite');
                    $dias = $this->input->post('dias');
                    $esta = $this->input->post('estado');
                    $xpos = $this->input->post('xpos');
                    $not = $this->input->post('notas');
                    $notas = str_replace(array("\n", "\r", "\n\r"), " ", $not);
                    $whodidit = $this->session->userdata('iduser');
                    $img = $this->input->post('imgen');
                    $this->load->model('consigna_model');
                    $this->consigna_model->updateCliente($idcliente, $idauxi_def, $descrip, $grupo, $telefono, $correo, $direccion, $departamento, $ingreso, $nrc, $nit, $actividad, $contribuyente, $vendedor, $limite, $dias, $img, $esta, $notas, $xpos, $whodidit); 
                    if($img!=""){
                        $archivo = 'imagenes';
                        $imgSplit = explode(".", $img);
                        $nameImg = "imgCliente_".$idcliente.".".$imgSplit[1];
                        $imgSplit = explode(".", $nameImg);
                        $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                        $config['file_name'] = $imgSplit[0];
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "gif|jpg|jpeg|png";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        if($this->upload->do_upload($archivo)){
                            $datos = $this->consigna_model->getClientesTipo($idauxi_def);
                        }else{
                            $datos = $this->consigna_model->getClientesTipo($idauxi_def);
                        }
                    }
                    $datos = $this->consigna_model->getClientesTipo($idauxi_def);
                    echo json_encode($datos);
                }else{
                    echo json_encode(false);
                }
            }
        }
        
        function getConsignacionesCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('consigna_model');
                $this->load->model('invtran_model');
                $idcentro = $this->input->post('idcentro'); 
                $idcliente = $this->input->post('idcliente'); 
                $idcps_branch = $this->input->post('idcps_branch'); 
                
                $recibidas = $this->consigna_model->getConsignacionesRecibidas($idcentro,$idcliente,$idcps_branch);
                $data = $this->consigna_model->getConsignacionesCliente($idcentro,$idcliente,$idcps_branch);
                $cantidad = $this->consigna_model->getCantPendCliente($idcentro,$idcliente,$idcps_branch);
                $inv_actual = $this->consigna_model->getCantInv($idcentro,$idcliente,$idcps_branch);
                $array_datos=array();
                $i=0;
                foreach($data as $dat){
                    $detalle = $this->invtran_model->getDataTran100k($dat->trannum);
                    $array_datos[$i] = array(
                        "trannum"=> $dat->trannum,
                        "tranref"=> $dat->tranref,
                        "idclase"=> $dat->idclase,
                        "fecha"=> $dat->fecha,
                        "fecact"=> $dat->fecact,
                        "fecha1"=> $dat->fecha1,
                        "estatus"=> $dat->estatus,
                        "lines100k"=> $dat->lines100k,
                        "lineas_unidades"=> $dat->lines100k."/".abs(round($dat->cantidad)),
                        "origen"=> $dat->origen,
                        "detalle"=>$detalle
                    );
                    $i++;
                }
                $array = array(
                    "data" => $array_datos,
                    "cantidad" => $cantidad,
                    "recibidas" => $recibidas,
                    "inv_actual" => $inv_actual,
                );
                echo json_encode($array);
            }
        }
        
        function getInventarioCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('consigna_model');
                $this->load->model('invtran_model');
                $idcentro = $this->input->post('idcentro'); 
                $idcliente = $this->input->post('idcliente');
                $idcps_branch = $this->input->post('idcps_branch'); 
                $data = $this->consigna_model->getInventarioCliente($idcentro,$idcliente,$idcps_branch);
                $array = array();
                $i=0;
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->cantidad!=0){
                            $array[$i] = array(
                                "tipo" => $dat->tipo,
                                "idrec" => $dat->idrec,
                                "barcode" => $dat->barcode,
                                "itemline" => $dat->itemline,
                                "descrip" => $dat->descrip,
                                "modelo" => $dat->modelo,
                                "um" => $dat->um,
                                "marca" => $dat->marca,
                                "idproducto" => $dat->idproducto,
                                "notas" => $dat->notas,
                                "cantidad" => $dat->cantidad,
                                "precioneto" => $dat->precioneto,
                                "preciotran" => $dat->preciotran,
                                "costounitario" => $dat->costounitario,
                                "descuento" => $dat->descuento,
                            );
                            $i++;
                        }
                    }
                }
                echo json_encode($array);
            }
        }
        
        function getConsignacionPendiente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('invtran_model');
                $this->load->model('consigna_model');
                $idcentro = $this->input->post('idcentro'); 
                $trannum = $this->input->post('trannum'); 
                $idcliente = $this->input->post('idcliente'); 
                $informacion = $this->invtran_model->getDetallePedido($trannum);
                $detalle = $this->invtran_model->getDataTran100k($trannum);
                $array = array(
                    "informacion" => $informacion,
                    "detalle" => $detalle
                );
                echo json_encode($array);
            }
        }
        
        function recibirEnvio(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('consigna_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $idcentro = $this->input->post('idcentro'); 
                $trannum = $this->input->post('trannum'); 
                $idcliente = $this->input->post('idcliente'); 
                $idcps_branch = $this->input->post('idcps_branch'); 
                $idclase = $this->global_model->getValorNumVariable('con_renvios');
                $inopera = $this->global_model->getInopera_invdef($idclase);
                $idbin = $this->invtran_model->getIdBin($idcentro);
                $idcode = $this->consigna_model->setRecepcionHD($trannum, $idclase, $idcliente);
                $this->consigna_model->setRecepcionDT($trannum, $idcode, $inopera, $idclase, $idbin);
                $this->invtran_model->callTotaliza100($idcode, 2);
                
                $recibidas = $this->consigna_model->getConsignacionesRecibidas($idcentro,$idcliente,$idcps_branch);
                $data = $this->consigna_model->getConsignacionesCliente($idcentro,$idcliente,$idcps_branch);
                $cantidad = $this->consigna_model->getCantPendCliente($idcentro,$idcliente,$idcps_branch);
                $inv_actual = $this->consigna_model->getCantInv($idcentro,$idcliente,$idcps_branch);
                $array_datos=array();
                $i=0;
                foreach($data as $dat){
                    $detalle = $this->invtran_model->getDataTran100k($dat->trannum);
                    $array_datos[$i] = array(
                        "trannum"=> $dat->trannum,
                        "tranref"=> $dat->tranref,
                        "idclase"=> $dat->idclase,
                        "fecha"=> $dat->fecha,
                        "fecact"=> $dat->fecact,
                        "fecha1"=> $dat->fecha1,
                        "estatus"=> $dat->estatus,
                        "lines100k"=> $dat->lines100k,
                        "lineas_unidades"=> $dat->lines100k."/".abs(round($dat->cantidad)),
                        "origen"=> $dat->origen,
                        "detalle"=>$detalle
                    );
                    $i++;
                }
                $array = array(
                    "data" => $array_datos,
                    "cantidad" => $cantidad,
                    "recibidas" => $recibidas,
                    "inv_actual" => $inv_actual,
                );
                echo json_encode($array);
            }
        }
        
        function getDevCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('consigna_model');
                $this->load->model('invtran_model');
                $idcentro = $this->input->post('idcentro'); 
                $idcliente = $this->input->post('idcliente');
                $idcps_branch = $this->input->post('idcps_branch'); 
                $data = $this->consigna_model->getDevCliente($idcentro,$idcliente,$idcps_branch);
                $array = array();
                $i=0;
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->cantidad!=0){
                            $array[$i] = array(
                                "tipo" => $dat->tipo,
                                "idrec" => $dat->idrec,
                                "barcode" => $dat->barcode,
                                "itemline" => $dat->itemline,
                                "descrip" => $dat->descrip,
                                "modelo" => $dat->modelo,
                                "um" => $dat->um,
                                "marca" => $dat->marca,
                                "idproducto" => $dat->idproducto,
                                "notas" => $dat->notas,
                                "cantidad" => $dat->cantidad,
                                "precioneto" => $dat->precioneto,
                                "preciotran" => $dat->preciotran,
                                "precioventa" => $dat->precioventa,
                                "costounitario" => $dat->costounitario,
                                "descuento" => $dat->descuento,
                                "tipotax" => $dat->tipotax,
                                "dev" => 0
                            );
                            $i++;
                        }
                    }
                }
                echo json_encode($array);
            }
        }
        
        function getRecuentoCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('consigna_model');
                $this->load->model('invtran_model');
                $idcentro = $this->input->post('idcentro'); 
                $idcliente = $this->input->post('idcliente'); 
                $idcps_branch = $this->input->post('idcps_branch');
                $data = $this->consigna_model->getDevCliente($idcentro,$idcliente,$idcps_branch);
                $array = array();
                $i=0;
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->cantidad!=0){
                            $array[$i] = array(
                                "tipo" => $dat->tipo,
                                "idrec" => $dat->idrec,
                                "barcode" => $dat->barcode,
                                "itemline" => $dat->itemline,
                                "descrip" => $dat->descrip,
                                "modelo" => $dat->modelo,
                                "um" => $dat->um,
                                "marca" => $dat->marca,
                                "idproducto" => $dat->idproducto,
                                "notas" => $dat->notas,
                                "cantidad" => $dat->cantidad,
                                "precioneto" => $dat->precioneto,
                                "preciotran" => $dat->preciotran,
                                "precioventa" => $dat->precioventa,
                                "costounitario" => $dat->costounitario,
                                "descuento" => $dat->descuento,
                                "tipotax" => $dat->tipotax,
                                "idbin" => $dat->idbin,
                                "idbatch" => $dat->idbatch,
                                "dev" => $dat->cantidad
                            );
                            $i++;
                        }
                    }
                }
                echo json_encode($array);
            }
        }
        
        function createDevolucion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('consigna_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $idcentro = $this->input->post('idCentroSalida'); 
                $idcentrod = $this->input->post('idCentroEntrada'); 
                $idcliente = $this->input->post('idcliente'); 
                $dataDevolver = $this->input->post('dataDevolver'); 
                $idcps_branch = $this->input->post('idcps_branch'); 
                $idclase = $this->global_model->getValorNumVariable('con_denvios');
                
                $trannum = $this->consigna_model->insertEnvio($idcentro, $idclase, $idcliente, $idcentrod,$idcps_branch);
                $inopera = $this->global_model->getInopera_invdef($idclase);
                $idbin = $this->invtran_model->getIdBin($idcentro);
                $products = $this->consigna_model->insertProducts($trannum, $idcentro, $idclase, $inopera, $idbin, $idcliente, $idcentrod, $dataDevolver);
                $this->invtran_model->callTotaliza100($trannum,1);
             
                $recibidas = $this->consigna_model->getConsignacionesRecibidas($idcentro,$idcliente,$idcps_branch);
                $data = $this->consigna_model->getConsignacionesCliente($idcentro,$idcliente,$idcps_branch);
                $cantidad = $this->consigna_model->getCantPendCliente($idcentro,$idcliente,$idcps_branch);
                $inv_actual = $this->consigna_model->getCantInv($idcentro,$idcliente,$idcps_branch);
                $array_datos=array();
                $i=0;
                foreach($data as $dat){
                    $detalle = $this->invtran_model->getDataTran100k($dat->trannum);
                    $array_datos[$i] = array(
                        "trannum"=> $dat->trannum,
                        "tranref"=> $dat->tranref,
                        "idclase"=> $dat->idclase,
                        "fecha"=> $dat->fecha,
                        "fecact"=> $dat->fecact,
                        "fecha1"=> $dat->fecha1,
                        "estatus"=> $dat->estatus,
                        "lines100k"=> $dat->lines100k,
                        "lineas_unidades"=> $dat->lines100k."/".abs(round($dat->cantidad)),
                        "origen"=> $dat->origen,
                        "detalle"=>$detalle
                    );
                    $i++;
                }
                $array = array(
                    "data" => $array_datos,
                    "cantidad" => $cantidad,
                    "recibidas" => $recibidas,
                    "inv_actual" => $inv_actual,
                );
                echo json_encode($array);
            }
        }
        
        function createFactura(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $fecha = $this->input->post('fecha');
                $idcentro = $this->input->post('idcentro');
                $idclase = $this->input->post('idclase');
                $idcliente = $this->input->post('idcliente');
                $cajclase = $this->input->post('cajclase');
                $idcps_branch = $this->input->post('idcps_branch');
                $data = $this->input->post('data');
                $descuento = $this->input->post('descuento');
                $notas = $this->input->post('notas');
                
                $this->load->model('consigna_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('ventas_model');
                
                $idworker = $this->ventas_model->getVendedorCliente($idcliente);
                $idcajaserie = $this->global_model->getValorNumVariable('con_cajafac');
                $trannum = $this->consigna_model->insertFactura($fecha, $idcentro, $idcajaserie, $idworker, $idclase, $cajclase, $idcliente, $idcps_branch, $notas);
                $inopera = $this->global_model->getInopera_invdef($idclase);
                $idbin = $this->invtran_model->getIdBin($idcentro);
                $products = $this->consigna_model->insertProductsFact($trannum, $fecha, $idcentro, $idclase, $cajclase, $inopera, $idbin, $idcliente, $idworker, $data, $descuento);
                $this->invtran_model->callTotaliza100($trannum,1);
                $this->global_model->insertarRegTran100p($trannum);
             
                $recibidas = $this->consigna_model->getConsignacionesRecibidas($idcentro, $idcliente, $idcps_branch);
                $data = $this->consigna_model->getConsignacionesCliente($idcentro, $idcliente, $idcps_branch);
                $cantidad = $this->consigna_model->getCantPendCliente($idcentro, $idcliente, $idcps_branch);
                $inv_actual = $this->consigna_model->getCantInv($idcentro, $idcliente, $idcps_branch);
                
                $i=0;
                $array_datos=array();
                foreach($data as $dat){
                    $detalle = $this->invtran_model->getDataTran100k($dat->trannum);
                    $array_datos[$i] = array(
                        "trannum"=> $dat->trannum,
                        "tranref"=> $dat->tranref,
                        "idclase"=> $dat->idclase,
                        "fecha"=> $dat->fecha,
                        "fecact"=> $dat->fecact,
                        "fecha1"=> $dat->fecha1,
                        "estatus"=> $dat->estatus,
                        "lines100k"=> $dat->lines100k,
                        "lineas_unidades"=> $dat->lines100k."/".abs(round($dat->cantidad)),
                        "origen"=> $dat->origen,
                        "detalle"=>$detalle
                    );
                    $i++;
                }
                
                $array = array(
                    "data" => $array_datos,
                    "cantidad" => $cantidad,
                    "recibidas" => $recibidas,
                    "inv_actual" => $inv_actual
                );
                echo json_encode($array);
            }
        }
        
        function getProductosOrdenados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('trannum');
                $this->load->model('consigna_model');
                $detalle = $this->consigna_model->getProducts($idtrannum);
                echo json_encode($detalle);
            }
        }
        
        function verGrupos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $tipo=$this->input->post("tipo");
                $this->load->model('consigna_model');
                $grupos = $this->consigna_model->viewGrupo($tipo);
                $datos = array();
                $i = 0;
                if($grupos != ""){
                    $datos = array();
                    $i = 0;
                    $arraay = explode(",", $grupos);
                    foreach($arraay as $key){
                        $datos[$i] = array(
                            "descrip" => "$key",
                        );   
                        $i++;
                    }
                }else{
                    $datos = array(
                        "descrip" => ""
                    );
                }
                echo json_encode($datos);
            }
        }
        
        function viewGrupos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $tipo = $this->input->post("tipo");
                $this->load->model('consigna_model');
                $grupos = $this->consigna_model->viewGrupo($tipo);
                $datos = array();
                $i = 0;
                if($grupos != ""){
                    $arraay = explode(",", $grupos);
                    foreach($arraay as $key){
                        $datos[$i] = array(
                            "ID" => "$key",
                            "Name" => "$key",
                        );   
                        $i++;
                    }
                }else{
                    $datos = array(
                        "ID" => "",
                        "Name" => "",
                    );
                }
                echo json_encode($datos);
            }
        }
        
        function updateGrupo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $cadena="";
                $nuevo = $this->input->post('nuevo');
                $viejo = $this->input->post('viejo');
                $tipo=$this->input->post("tipo");
                $this->load->model('consigna_model');
                $cadena = $this->consigna_model->viewGrupo($tipo);
                $resultado="";
                $cant=0;
                $arrayPag = explode(",", $cadena);
                $totRig = count($arrayPag);
                $totReal = $totRig;
                for($i=0; $i<$totReal; $i++){
                    if($cant==0){
                        if("$arrayPag[$i]" == "$viejo"){
                            $resultado =  "$nuevo";
                        }else{
                            $resultado =  "$arrayPag[$i]";
                        }
                    }else{
                        if("$arrayPag[$i]" == "$viejo"){
                            $resultado .=  ",$nuevo";
                        }else{
                            $resultado .=  ",$arrayPag[$i]";
                        }
                    }   
                    $cant++;                    
                }
                $this->consigna_model->updateGrupos($resultado, $tipo); 
                return true;
            }
        }
        
        function updateGrupoNuevo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $cadena="";
                $nuevo = $this->input->post('nuevo');
                $tipo= $this->input->post("tipo");
                $this->load->model('consigna_model');
                $cadena = $this->consigna_model->viewGrupo($tipo);
                $resultado = $cadena.', '.$nuevo;
                $this->consigna_model->updateGrupos($resultado, $tipo); 
                return true;
            }
        }
        
        function updateGrupoEliminar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $cadena="";
                $cant=0;
                $resultado="";
                $eliminado = $this->input->post('eliminado');
                $tipo=$this->input->post("tipo");
                $this->load->model('consigna_model');
                $cadena = $this->consigna_model->viewGrupo($tipo);
                
                $arrayPag = explode(",", $cadena);
                $totRig = count($arrayPag);
                $totReal = $totRig;
                for($i=0; $i<$totReal; $i++){
                    if($cant==0){
                        if($arrayPag[$i] != $eliminado){
                            $resultado =  $arrayPag[$i];
                        }
                    }else{
                        if($arrayPag[$i] != $eliminado){    
                            $resultado .= ",".$arrayPag[$i];
                        }
                    }   
                    $cant++;                    
                }
                $this->consigna_model->updateGrupos($resultado, $tipo); 
                return true;
            }
        }
        
        function createAjuste(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('consigna_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('ventas_model');
                $idcentro = $this->input->post('idcentro'); 
                $idcliente = $this->input->post('idcliente'); 
                $idcps_branch = $this->input->post('idcps_branch'); 
                $data = $this->input->post('dataAjuste'); 
                $ajusteFavor = $this->input->post('cantFavor'); 
                $ajusteContra = $this->input->post('cantContra'); 
                $idclaseFavor = $this->global_model->getValorNumVariable('con_idfavor');
                $idclaseContra = $this->global_model->getValorNumVariable('con_idcontra');
                $idworker = $this->ventas_model->getVendedorCliente($idcliente); 
                
                if($ajusteFavor > 0){
                    $idFavor = $this->consigna_model->insertAjusteFavorContra($idcentro,$idcliente,$idworker,$idclaseFavor,$idcps_branch);
                    $this->consigna_model->insertDetalleAjusteFavor($idFavor, $data, $idcentro, $idclaseFavor);
                    $this->invtran_model->callTotaliza100($idFavor, 1);
                }
                
                if($ajusteContra > 0){
                    $idContra = $this->consigna_model->insertAjusteFavorContra($idcentro,$idcliente,$idworker,$idclaseContra,$idcps_branch);
                    $this->consigna_model->insertDetalleAjusteContra($idContra, $data, $idcentro, $idclaseContra);
                    $this->invtran_model->callTotaliza100($idContra, 1);
                }
                
                $recibidas = $this->consigna_model->getConsignacionesRecibidas($idcentro,$idcliente,$idcps_branch);
                $data = $this->consigna_model->getConsignacionesCliente($idcentro,$idcliente,$idcps_branch);
                $cantidad = $this->consigna_model->getCantPendCliente($idcentro,$idcliente,$idcps_branch);
                $inv_actual = $this->consigna_model->getCantInv($idcentro,$idcliente,$idcps_branch);
                $array_datos=array();
                $i=0;
                foreach($data as $dat){
                    $detalle = $this->invtran_model->getDataTran100k($dat->trannum);
                    $array_datos[$i] = array(
                        "trannum"=> $dat->trannum,
                        "tranref"=> $dat->tranref,
                        "idclase"=> $dat->idclase,
                        "fecha"=> $dat->fecha,
                        "fecact"=> $dat->fecact,
                        "fecha1"=> $dat->fecha1,
                        "estatus"=> $dat->estatus,
                        "lines100k"=> $dat->lines100k,
                        "lineas_unidades"=> $dat->lines100k."/".abs(round($dat->cantidad)),
                        "origen"=> $dat->origen,
                        "detalle"=>$detalle
                    );
                    $i++;
                }
                $array = array(
                    "data" => $array_datos,
                    "cantidad" => $cantidad,
                    "recibidas" => $recibidas,
                    "inv_actual" => $inv_actual,

                );
                echo json_encode($array);
            }
        }
        
        function consignacionEnvioClientes($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('global_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $idclase = $this->configuracion_model->getProCentro($idApp);
                $con_idcentro = $this->global_model->getValorNumVariable('con_idcentro');
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'idclass' => $idclase,
                    'con_idcentro' => $con_idcentro
                );
                $this->session->set_userdata($resultAppName);
                
                $controlador = $this->uri->segment(1);
                $this->load->model('sucursal_model');
                $this->data['idcentro']  = $this->session->userdata('idcentrouser');
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['con_idcentro'] = $this->global_model->getValorNumVariable('con_idcentro');
                 
                $this->load->view('mantenimiento_invenvios_consigna', $this->data); 
            }
        }
        
        function getInformacionTraslados(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idclase = $this->session->userdata('idclass');
                $idcentro = $this->session->userdata('idcentrouser');
                $con_idcentro = $this->session->userdata('con_idcentro');
                
                $this->load->model('consigna_model');
                $informacion = $this->consigna_model->getInformacionTraslados($idcentro, $con_idcentro, $idclase);
                
                $i=0;
                $dataSource = array();
                
                foreach($informacion as $info){
                    $dataSource[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha1" => $info->fecha1,
                        "fecha2" => $info->fecha2,
                        "referencia" => $info->referencia,
                        "idcentrod" => $info->idcentrod,
                        "nameCliente" => $info->nameCliente,
                        "lugar_entrega" => $info->lugar_entrega,
                        "lines100k" => $info->lines100k,
                        "estatus" => $info->estatus
                    );
                    $i++;
                }
                
                echo json_encode($dataSource);
            }
        }
        
        function getConsignacionClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('consigna_model');
                $idauxidef = $this->global_model->getValorNumVariable('con_idauxidef');
                $informacion = $this->consigna_model->getListadoConsignacionesClientes($idauxidef);
                $i=0;
                $array = array();
                foreach($informacion as $info){
                    if($info->cant>0){
                        $array[$i] = array(
                            "id" => $info->idauxi,
                            "descrip" => $info->descrip
                        );
                        $i++;
                    }
                }
                echo json_encode($array);
            }
        }
        
        function insertNuevoTraslado(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $idclase = $this->session->userdata('idclass');
                $fecha = $this->input->post('fecha');
                $descuento = $this->input->post('descuento');
                $notas = trim($this->input->post('notas'));
                $idcentrod = $this->input->post('idcentro');
                $referencia = $this->input->post('referencia');
                $idcps = $this->input->post('idcps');
                $idcps_branch = $this->input->post('idcps_branch');
                
                $this->load->model('consigna_model');
                $array = $this->consigna_model->insertNuevoTraslado($idcentro, $fecha, $idclase, $descuento, $notas, $idcentrod, $referencia, $idcps, $idcps_branch);
                
                echo json_encode($array);
            }
        }
        
        function verDetalleOrden($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$idtrannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('consigna_model');
                $this->load->model('ventas_model');

                $informacionFactura = $this->ventas_model->getDatosFactura($idtrannum);

                foreach($informacionFactura as $info){
                    $idclase = $info->idclase;
                }
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                
                $idcentro = $this->session->userdata('idcentrouser');
                $direccion = $this->uri->segment(1);
                
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['informacion'] = $this->consigna_model->getDetallePedido($idtrannum);
                $this->data['catalogo'] = $this->global_model->getCatalogoPrincipal();
                $this->data['detalle'] = $this->invtran_model->getDataTran100k($idtrannum);
                $this->data['detalle_export'] = $this->invtran_model->getDataTran100k_envios($idtrannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($idtrannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($idtrannum);
                $this->data['con_precioventa'] = $this->global_model->getValorNumVariable("con_precioventa");
                
                $sumaPT = $this->global_model->getValorNumVariablePro('gv_protipo', 1);
                $sumaMP = $this->global_model->getValorNumVariablePro('gv_protipo', 2);
                $sumaIS = $this->global_model->getValorNumVariablePro('gv_protipo', 3);
                
                $this->data['sumaPT'] = $sumaPT;
                $this->data['sumaMP'] = $sumaMP;
                $this->data['sumaIS'] = $sumaIS;
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('form_detalle_inv_consigna', $this->data);
            }
        }

        function cerrarConsignacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $notas = trim($this->input->post('notas'));
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                $this->load->model('consigna_model');
                
                $array = $this->consigna_model->cerrarConsignacion($trannum, $notas);
                
                $this->invtran_model->callTotaliza100($trannum, 1);
				$this->global_model->insertarRegTran100p($trannum);
                
                echo json_encode($array);
            }
        }
        
        function getUbicacionesCliente(){
            $id = $this->input->post('id');
            $this->load->model('consigna_model');
            $array = $this->consigna_model->getUbicacionesCliente($id);
            echo json_encode($array);
        }
        
        
        function getInventarioGeneral(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('consigna_model');
                $idcentro = $this->input->post('idcentro'); 
                $data = $this->consigna_model->getInventarioClientes($idcentro);
                $array = array();
                $i=0;
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->cantidad!=0){
                            $array[$i] = array(
                                "idproducto" => $dat->idproducto,
                                "descrip" => $dat->descrip,
                                "modelo" => $dat->modelo,
                                "um" => $dat->um,
                                "marca" => $dat->marca,
                                "cantidad" => $dat->cantidad,
                                "cliente" => $dat->cliente,
                                "lugar_entrega" => $dat->lugar_entrega,
                                "vendedor" => $dat->vendedor,
                                "costounitario" => $dat->costounitario,
                                "subtotal" => $dat->cantidad*$dat->costounitario,
                            );
                            $i++;
                        }
                    }
                }
                echo json_encode($array);
            }
        }
        
        function getPreciosCompraLocal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post("trannum");
                $estado = $this->input->post("estado");
                $this->load->model('consigna_model');
                $j=0;
                $detail = array();
                $linea = 0;
                $canti = 0;
                $informacion = $this->consigna_model->getDetalleByEstatusCompraLocal($trannum);
                $statusFolder = $this->consigna_model->getStatusFolder($trannum);
                foreach($informacion as $cmp){
                    $detail[$j] = array(
                        "trannum" => $trannum,
                        "itemline" => $cmp->itemline,
                        "idproducto" => $cmp->idproducto,
                        "modelo" => $cmp->modelo,
                        "descrip" => $cmp->descrip,
                        "um" => $cmp->um,
                        "cantidad" => $cmp->cantidad,
                        "preciotran" => $cmp->costounitario * 1,
                        "precioventa" => $cmp->precioventa * 1,
                        "nuevoprecio" => $cmp->precioventaMulti * 1,
                        "idrec" => $cmp->idrec,
                    );
                    $j++;
                }
                
                $array = array(
                    "data" => $detail,
                    "estado" => $statusFolder,
                );
                echo json_encode($array);
            }
        }
        

        function updatePrecioMultiple(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post("idrec");
                $nuevoprecio = $this->input->post("nuevoprecio");
                $this->load->model('consigna_model');
                $update = $this->consigna_model->updatePrecioMultiple($idrec,$nuevoprecio);
                echo json_encode($update);
            }
        }
        
        function updateMultiplesPrecios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $productos = $this->input->post('productos');
                $nuevoprecio = $this->input->post('nuevoprecio');
                $detail = array();
                $j = 0;
                $this->load->model('consigna_model');
                $this->consigna_model->updateMultiplesPrecios($trannum, $productos, $nuevoprecio);
                $informacion = $this->consigna_model->getDetalleByEstatusCompraLocal($trannum);
                foreach($informacion as $cmp){
                    $detail[$j] = array(
                        "trannum" => $trannum,
                        "itemline" => $cmp->itemline,
                        "idproducto" => $cmp->idproducto,
                        "modelo" => $cmp->modelo,
                        "descrip" => $cmp->descrip,
                        "um" => $cmp->um,
                        "cantidad" => $cmp->cantidad,
                        "preciotran" => $cmp->costounitario * 1,
                        "precioventa" => $cmp->precioventa * 1,
                        "nuevoprecio" => $cmp->precioventaMulti * 1,
                        "idrec" => $cmp->idrec,
                    );
                    $j++;
                }
                
                echo json_encode($detail);
            }
        }    

        function incrementarPorcentaje(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $productos = $this->input->post('productos');
                $tipo = $this->input->post('tipo');
                $porcentaje = $this->input->post('porcentaje');
                $this->load->model('consigna_model');
                $this->consigna_model->incrementarPorcentaje($trannum, $tipo, $productos, $porcentaje);
                
                
                $informacion = $this->consigna_model->getDetalleByEstatusCompraLocal($trannum);
                $j = 0;
                $detail = array();
                foreach($informacion as $cmp){
                    $detail[$j] = array(
                        "trannum" => $trannum,
                        "itemline" => $cmp->itemline,
                        "idproducto" => $cmp->idproducto,
                        "modelo" => $cmp->modelo,
                        "descrip" => $cmp->descrip,
                        "um" => $cmp->um,
                        "cantidad" => $cmp->cantidad,
                        "preciotran" => $cmp->costounitario * 1,
                        "precioventa" => $cmp->precioventa * 1,
                        "nuevoprecio" => $cmp->precioventaMulti * 1,
                        "idrec" => $cmp->idrec,
                    );
                    $j++;
                }
                echo json_encode($detail);
            }
        }    

        function cerrarFolder(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post("trannum");
                $this->load->model('consigna_model');
                $update = $this->consigna_model->cerrarFolder($trannum);
                echo json_encode($update);
            }
        }
        
        function insertTran100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $cantidad = $this->input->post('cantidad');
                $idcatalogo = $this->input->post('idcatalogo');
                $idbatch = $this->input->post('idbatch');
                $idbin = $this->input->post('idbin');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $um = $this->input->post('um');
                $precioventa = $this->input->post('precioventa');
                $idcentro = $this->session->userdata('idcentrouser');
                $idclase = $this->session->userdata('idclass');
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                $this->load->model('consigna_model');
                
                $inopera = $this->global_model->getInopera_invdef($idclase);
                $invcontrol = $this->global_model->getInvControlSite($idcentro);
                
                $this->consigna_model->insertTraslado100k($cantidad, $idbatch, $idbin, $idproducto, $um, $idcentro, $invcontrol, $inopera, $trannum, $idclase, $precio, $precioventa);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "idbin" => $info->idbin,
                            "xpos" => $info->xpos,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                
                echo json_encode($array);
            }            
        }

        function updateTran100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $cantidad = $this->input->post('cantidad');
                $precioventa = $this->input->post('precioventa');
                $idcatalogo = $this->input->post('idcatalogo');
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                $idclase = $this->session->userdata('idclass');
                
                $this->load->model('invtran_model');
                $this->load->model('consigna_model');
                
                $this->consigna_model->updateTraslado100k($idrec, $cantidad, $precioventa);
                
                $detalle = $this->invtran_model->getInventarioByCatalog($trannum,$idcatalogo,$idcentro);
                $datos = $this->invtran_model->getDataTran100k($trannum);
                $cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => $unidades,
                    "count" => $i
                );
                                
                echo json_encode($array);
            }            
        }

        function getInventarioReporteConsigna(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('consigna_model');
                $fechaini = $this->input->post('fechaini'); 
                $fechafin = $this->input->post('fechafin'); 
                $idclientes = $this->input->post('clientes'); 
                $idcentro = $this->input->post('idcentro'); 

                $datos = $this->consigna_model->getDatosInventarioConsigna($idcentro, $fechaini, $fechafin, $idclientes);

                echo json_encode($datos);
            }
        }
        /*

        */
    }
?>