<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
    class Configuracion extends CI_Controller {
        
        function __construct(){
            parent::__construct();
        }
        
        function firstSettings(){
			date_default_timezone_set('America/El_Salvador');
			$fecha = new DateTime();
			
			$user = $this->session->userdata("iduser");
            $this->load->model("Configuracion_model");
            $this->load->model("Mensajes_model");
            $this->load->model('Sucursal_model');
            $this->load->model('Media_model');
            $this->load->model('Global_model');

            $tipoAdmin = $this->session->userdata('adminUser');
            
            $_SESSION['menuSite'] = $this->Configuracion_model->getMenu($user, $tipoAdmin);
            $_SESSION['appsSite'] = $this->Configuracion_model->getAplicaciones($user, $tipoAdmin);
            $_SESSION['listApps'] = $this->Configuracion_model->getListadoAplicaciones($user, $tipoAdmin);
            $_SESSION['menuType'] = $this->Configuracion_model->getTipoMenu($user, $tipoAdmin);
            $_SESSION['userPerm'] = $this->Configuracion_model->getPermisos($user);
            
            if($tipoAdmin == 0){
                //echo "1";
                $infoUsuario = $this->Configuracion_model->getEmpleadoId($user);
            }else{
                //echo "2";
                $this->load->model('Login_model');
                $infoUsuario = $this->Login_model->getInformacionUsuario($user);
            }
            
            $descrip     = $infoUsuario['descrip'];
            $idcps       = $infoUsuario['idcps'];
            $imagen      = $infoUsuario['imagen'];
            $derechos    = $infoUsuario['derechos'];
            $correo_user = $infoUsuario['correo1'];
            
			$permisoSucursal = 'multiSucursal';
			$resultBusqueda = strpos($derechos, $permisoSucursal);
			
			if($resultBusqueda !== false){
				$opcionSucursales = 1;
			}else{
				$opcionSucursales = 0;
			}
            
			$permisoAdmin = 'admin';
			$resultBusqueda2 = strpos($derechos, $permisoAdmin);
			
			if($resultBusqueda2 !== false){
				$opcionAdministrador = 1;
			}else{
				$opcionAdministrador = 0;
			}
            
			$permisoInventarios = 'adminInv';
			$resultBusqueda2 = strpos($derechos, $permisoInventarios);
			
			if($resultBusqueda2 !== false){
				$opcionInventarios = 1;
			}else{
				$opcionInventarios = 0;
            }
            
            $permisoCostos = 'costo';
			$resultCostos = strpos($derechos, $permisoCostos);
			
			if($resultCostos !== false){
				$opcionCostos = 1;
			}else{
				$opcionCostos = 0;
            }
            
            //Cambio de Precio Por Usuario 20200903 Iván Cienfuegos
            $cambioDePrecio  = 'chgPrecio';
			$resultChgPrecio = strpos($derechos, $cambioDePrecio);
			
			if($resultChgPrecio !== false){
				$opcionCambioPrecio = 1;
			}else{
				$opcionCambioPrecio = 0;
			}
			
            if($imagen == ""){
                $imagen = "sinFoto.jpg";
            }
            
            $empl_user = array('idEmpleadoUser' => $idcps, 'nameEmpleadoUser' => $descrip, 'imagenEmpleadoUser' => $imagen, 'emailUser' => $correo_user);
            $this->session->set_userdata($empl_user); 
            
            $namePage = array('namePage' => 'Bienvenido/a '. $descrip);  
            $this->session->set_userdata($namePage);
            
            if($tipoAdmin == 0){
                foreach($_SESSION['userPerm'] as $usuario){
                    $id = $usuario->idcentro;
                    $perfilUsuario = $usuario->profile;
                    
                    $nameCentro = $this->Configuracion_model->getNameCentroPasteles($id);
                    $nameCaja = $this->Configuracion_model->getNameCajaUser($user);
                    $idcajauser = $this->Configuracion_model->getIdCajaUser($user);
                    $idcps = $this->Configuracion_model->getIDCPSCenter($id);
                    $centros_profile = $this->Configuracion_model->getCentrosDelPerfil($perfilUsuario);
                    $permisos_profile = $this->Configuracion_model->getListadoPermisosFiltro($perfilUsuario);

                    $permisoTotalesFacturacion = 'no_mostrar_totales:1';
                    $resultBusquedaTot = strpos($permisos_profile, $permisoTotalesFacturacion);
                    
                    if($resultBusquedaTot !== false){
                        $opcionTotalesFactu = 0;
                    }else{
                        $opcionTotalesFactu = 1;
                    }

                    $permisoMotrarResumen = 'mostrar_resumen:1';
                    $resultResumen = strpos($permisos_profile, $permisoMotrarResumen);
                    
                    if($resultResumen !== false){
                        $opcionMostrarResumen = 1;
                    }else{
                        $opcionMostrarResumen = 0;
                    }
                
                    $idcentrouser = array(
                        'idcentrouser' => $id,
                        'perfiluser' => $perfilUsuario,
                        'nameCentroUser' => $nameCentro,
                        'idcps_center' => $idcps,
                        'nameCajaUser' => $nameCaja,
                        'idcajauser' => $idcajauser,
                        'idCatalogo_slc' => '',
                        'centros_profile' => $centros_profile,
                        'opcionSucursales' => $opcionSucursales,
                        'opcionAdministrador' => $opcionAdministrador,
                        'opcionInventarios' => $opcionInventarios,
                        'opcionTotalesFactu' => $opcionTotalesFactu,
                        'opcionMostrarResumen' => $opcionMostrarResumen,
                        'opcionCambioPrecio' => $opcionCambioPrecio,
                        'opcionCostos' => $opcionCostos,
                        'fechayhora' => $fecha->format('d/m/Y g:i A')
                    );
                }
            }else{
                $id = $infoUsuario['idcentro'];
                $perfilUsuario = $infoUsuario['profile'];
                
                $nameCentro = $this->Configuracion_model->getNameCentroPasteles($id);
                $nameCaja   = $this->Configuracion_model->getNameCajaUser($user);
                $idcajauser = $this->Configuracion_model->getIdCajaUser($user);
                $idcps      = $this->Configuracion_model->getIDCPSCenter($id);
                $centros_profile  = $this->Configuracion_model->getCentrosDelPerfil($perfilUsuario);
                $permisos_profile = $this->Configuracion_model->getListadoPermisosFiltro($perfilUsuario);

                $permisoTotalesFacturacion = 'no_mostrar_totales:1';
                $resultBusquedaTot = strpos($permisos_profile, $permisoTotalesFacturacion);
                
                if($resultBusquedaTot !== false){
                    $opcionTotalesFactu = 0;
                }else{
                    $opcionTotalesFactu = 1;
                }

                $permisoMotrarResumen = 'mostrar_resumen:1';
                $resultResumen = strpos($permisos_profile, $permisoMotrarResumen);
                
                if($resultResumen !== false){
                    $opcionMostrarResumen = 1;
                }else{
                    $opcionMostrarResumen = 0;
                }
            
                $idcentrouser = array(
                    'idcentrouser' => $id,
                    'perfiluser' => $perfilUsuario,
                    'nameCentroUser' => $nameCentro,
                    'idcps_center' => $idcps,
                    'nameCajaUser' => $nameCaja,
                    'idcajauser' => $idcajauser,
                    'idCatalogo_slc' => '',
                    'centros_profile' => $centros_profile,
                    'opcionSucursales' => $opcionSucursales,
                    'opcionAdministrador' => $opcionAdministrador,
                    'opcionInventarios' => $opcionInventarios,
                    'opcionTotalesFactu' => $opcionTotalesFactu,
                    'opcionMostrarResumen' => $opcionMostrarResumen,
                    'opcionCambioPrecio' => $opcionCambioPrecio,
                    'opcionCostos' => $opcionCostos,
                    'fechayhora' => $fecha->format('d/m/Y g:i A')
                );
            }

            $this->session->set_userdata($idcentrouser);
            
            $idcuenta = trim($this->session->userdata('idaccount'));

            $dirAcc = "img_".$idcuenta;
            $nombre_fichero = 'img_cuentas/'.$dirAcc;
            
            $dirAcc3 = "doc_".$idcuenta;
            $nombre_fichero3 = 'doc_cuentas/'.$dirAcc3;
            
            $dirAcc2 = "reports_".$idcuenta;
            $nombre_fichero2 = 'application/controllers/'.$dirAcc2;
            
            $dirAcc4 = "adjuntos_".$idcuenta;
            $nombre_fichero4 = 'doc_adjuntos/'.$dirAcc4;
            
            $dirCentralReport = "central_reports";
            $nombre_fichero_reports = 'application/controllers/'.$dirCentralReport;
            
            $dirAccount = array(
                'diraccount' => $dirAcc,
                'dirReports' => $dirAcc2,
                'dirDocuments' => $dirAcc3,
                'dirAdjuntos' => $dirAcc4,
                'dirCentralReport' => $dirCentralReport,
            );  
            
            $this->session->set_userdata($dirAccount);
            
            if(!file_exists($nombre_fichero3)){
                mkdir("doc_cuentas/$dirAcc3", 0755);
            }
            
            if(!file_exists($nombre_fichero)){
                mkdir("img_cuentas/$dirAcc", 0755);
            }

            if(!file_exists($nombre_fichero."/imgCotis")){
                mkdir($nombre_fichero."/imgCotis", 0755);
            }
            
            if(!file_exists($nombre_fichero2)){
                mkdir("application/controllers/$dirAcc2", 0755);
            }
            
            if(!file_exists($nombre_fichero4)){
                mkdir("doc_adjuntos/$dirAcc4", 0755);
            }
            
            if(!file_exists($nombre_fichero_reports)){
                mkdir("application/controllers/$dirCentralReport", 0755);
            }
            
            #CONFIGURACION DE TRANSACCION PARA RECEPCION DE TRASLADOS......
            $this->Configuracion_model->updateInvRecepciones();

            $hdBackColor = $this->Configuracion_model->getColorGvar('sy_hdcolor');
            $hdFontColor = $this->Configuracion_model->getColorGvar('sy_hdtittle');
            $LbFontColor = $this->Configuracion_model->getColorGvar('sy_formtf');
            $LbBackColor = $this->Configuracion_model->getColorGvar('sy_formtb');
            $FrBackColor = $this->Configuracion_model->getColorGvar('sy_formbk');
            $FHBackColor = $this->Configuracion_model->getColorGvar('sy_formhbk');
            $FHFontColor = $this->Configuracion_model->getColorGvar('sy_formhtf');
            $ImgMarkBack = $this->Configuracion_model->getColorGvar('sy_mainwt');
			$imgEmpresa  = $this->Configuracion_model->getImagenLogoEmpresa('g_empicon');
			$tipoDispositivo = $this->Configuracion_model->detectarDispositivo();
            
			if($imgEmpresa == "" || $imgEmpresa == null){
				$nameImgEmpresa = base_url()."assets/img/sinImagen.png";
			}else{
				$nombre_fichero = FCPATH.'img_cuentas/'.$this->session->userdata('diraccount')."/".$imgEmpresa;
				if(file_exists($nombre_fichero)){
					$nameImgEmpresa = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$imgEmpresa;
				}else{
					$nameImgEmpresa = base_url()."assets/img/sinImagen.png";
				}
			}
			
            $coloresSistema = array(
                'hdBackground' => $hdBackColor,
                'hdFontcolor' => $hdFontColor,
                'LbFontColor' => $LbFontColor,
                'LbBackground' => $LbBackColor,
                'FrBackground' => $FrBackColor,
                'FHFontColor' => $FHFontColor,
                'FHBackground' => $FHBackColor,
                'MainBackground' => $ImgMarkBack,
				'nameImgEmpresa' => $nameImgEmpresa,
                'tipoDispositivo' => $tipoDispositivo,
                'nitEmp' => $this->Global_model->getDatosGeneralesEmp('g_empdatos', 4),
                'nrcEmp' => $this->Global_model->getDatosGeneralesEmp('g_empdatos', 3),
            );
            $this->session->set_userdata($coloresSistema);
            
			//Funcion para la inicialización de gvars tipo num, parametros ('Nombre Gvar', 'Descripción', 'Valor')
			//$this->Configuracion_model->initGvarsNum('', '', 0);
			$this->Configuracion_model->initGvarsNum('pos_newcli', 'Facturación para clientes nuevos', 0); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Password para la anulación de facturas', 20170720); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Razon Social', 1); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Nombre comercial', 2); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Numero de Registro Fiscal', 3); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Numero de identificacion Tributaria', 4); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Giro', 5); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Direccion', 6); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Departamento y Municipio', 7); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Pais', 8); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Telefono', 9); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Tipo de Contribuyente', 10); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Correo Electronico', 11); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Nombre del Contador', 12); //20171016
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Numero de Inscripción del Contador', 13); //20171016
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Nombre del Auditor', 14); //20171016
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Numero de Inscripción del Auditor', 15); //20171016
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Nombre del Representante Legal', 16); //20171016
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Código Actividad Económica', 30); //20230508
			//$this->Configuracion_model->initGvarsNumEmp('g_empdatos', 'Código Actividad Económica', 30); //20230508
			#$this->Configuracion_model->initGvarsNum('pos_idclase', 'Transacción predeterminada para la facturación.', 0); //20170720
			$this->Configuracion_model->initGvarsNum('gv_zip', 'Departamento Municipio Por Defecto', 193); //20170720
			$this->Configuracion_model->initGvarsNum('pos_vendemode', 'Modalidad de captura de vendedor.', 0); //20170726
			$this->Configuracion_model->initGvarsNum('pos_devmeses', 'Meses permitidos para la devolución de ventas.', 3); //20180404
			$this->Configuracion_model->initGvarsNum('po_lotes', 'Permite las compras por lotes.', 0); //20180609
			$this->Configuracion_model->initGvarsNum('pos_maxglodiscount', 'Permite el descuento global en las ventas.', 0); //20180609
			$this->Configuracion_model->initGvarsNum('pos_aplmaxdiscount', 'Aplicar descuento máximo de producto.', 0); //20180609
            $this->Configuracion_model->initGvarsNum('pos_emailreq', 'Correo y Dui requerido.', 0); //20181101
            $this->Configuracion_model->initGvarsNum('pos_cajafast0'.$idcajauser, 'Caja Super Rápida.', 0); //20181115
            $this->Configuracion_model->initGvarsNum('pos_sendprint0'.$idcajauser, 'No mandar a imprimir.', 0); //20181115
            $this->Configuracion_model->initGvarsNum('pos_easy0'.$idcajauser, 'Modalidad venta rápida.', 0); //20181213
            $this->Configuracion_model->initGvarsNum('pos_secure', 'Comando configuración variables.', 0); //20181115
            $this->Configuracion_model->initGvarsNum('pos_idclase0'.$idcajauser, 'Clase predeterminada para caja.', 0); //20190703
            $this->Configuracion_model->initGvarsNum('po_retaceos', 'Permite retaceos en compras.', 0); //20190823
            $this->Configuracion_model->initGvarsNum('pos_prenoiva', 'Precios Sin IVA.', 0); //20210827
            $this->Configuracion_model->initGvarsNum('pos_ventaorden', 'Modalidad de venta ordenes.', 0); //20230721
            $this->Configuracion_model->initGvarsNum('pos_lprecio', 'Habilita seleccion de multiples precios por cliente.', 0); //20241119
            $this->Configuracion_model->initGvarsNum('mant_prodtabs', 'Caracteristicas del producto.', 3); //20240606
            
            $this->Configuracion_model->initGvarsNum('wo_num', 'Correlativo de Ordenes de Trabajo.', 0); //20220407
            $this->Configuracion_model->initGvarsNumEmpNew('wo_origen', 'Facebook', 1, '', ''); //20220407
            $this->Configuracion_model->initGvarsNumEmpNew('wo_origen', 'Instagram', 2, '', ''); //20220407
            $this->Configuracion_model->initGvarsNumEmpNew('wo_origen', 'Correo', 3, '', ''); //20220407
            $this->Configuracion_model->initGvarsNumEmpNew('wo_origen', 'WhatsApp', 4, '', ''); //20220407
            
			//Funcion para la inicialización de gvars tipo text, parametros ('Nombre Gvar', 'Descripción', 'Valor')
			//$this->Configuracion_model->initGvarsText('', '', '');
			$this->Configuracion_model->initGvarsText('po_notas', 'Notas en Ordenes de Compras', ' ');//20170814
			$this->Configuracion_model->initGvarsText('rf_clave0'.$id, 'Clave para el cierre de recuentos', '1234');//20170814
			$this->Configuracion_model->initGvarsText('cp_clave', 'Clave para autorización de pagos a proveedor', '1234');//20240506
			$this->Configuracion_model->initGvarsText('pos_qr_notas','Notas varias en formato de comprobante QR',''); //20250829
            $this->Configuracion_model->initGvarsNum('ivac_password', 'Clave para inicializar libros', 1234);//20220419 I.C.
            $this->Configuracion_model->initGvarsNum('eti_coordinit', 'Coordenada inicial para etiquetas', 14);//20220518 

            //Control de sub auxis en mantenimiento de auxiliares y editor de partidas
            $this->Configuracion_model->initGvarsNum('conta_subauxi', 'Utiliza subAuxiliares en Editor de Partidas', 0);//20221118 F.S
            
            $this->Configuracion_model->initGvarsNum('ct_apipais', 'Api Pais', 1);//20231101 I.C..
            
            $this->Configuracion_model->initGvarsNum('gSerieYear', 'Año de Actualización Correlativos DTE', 2024);//20241220 I.C..
            $this->Configuracion_model->initGvarsNum('dte_recmanual', 'Recuperación Manual de DTE', 0);//20250115 I.C..
            
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoo', 'Gravada', 1,'',1);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoo', 'No Gravada o Exenta', 2,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoo', 'Excluido o No Constituye Renta', 3,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoo', 'Periodo Tibutario Anterior Febrero 2024', 0,'',0);//20241217 I.C..
            
            $this->Configuracion_model->initGvarsNumEmpNew('iva_clas', 'Costo', 1,'',1);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_clas', 'Gasto', 2,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_clas', 'Periodo Tibutario Anterior Febrero 2024', 0,'',0);//20241217 I.C..
            
        
            $this->Configuracion_model->initGvarsNumEmpNew('iva_sect', 'Industria', 1,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_sect', 'Comercio', 2,'',1);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_sect', 'Agropecuaria', 3,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_sect', 'Servicios, Profesiones, Artes y Oficios', 4,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_sect', 'Periodo Tibutario Anterior Febrero 2024', 0,'',0);//20241217 I.C..

            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoc', 'Gastos de Venta sin Donación', 1,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoc', 'Gastos de Administración sin Donación', 2,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoc', 'Gastos Financieros sin Donación', 3,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoc', 'Costo Articulos Producidos/Comprados Importaciones/Internaciones', 4,'',0);
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoc', 'Costo Articulos Producidos/Comprados Interno', 5,'',1);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoc', 'Costos Indirectos de Fabricación', 6,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoc', 'Mano de Obra', 7,'',0);//20241217 I.C..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoc', 'Periodo Tibutario Anterior Febrero 2024', 0,'',0);//20241217 I.C..

            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoo_renta', 'Gravada', 1,'',1);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoo_renta', 'No Gravada o Exento', 2,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoo_renta', 'Excluido o no Constituye Renta', 3,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoo_renta', 'Mixta', 4,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoo_renta', 'Ingresos que ya fueron sujetos de retención en F910', 12,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoo_renta', 'Sujetos pasivos excluidos (art. 6 LISR) e ingresos que no constituyen hecho generador del ISR', 13,'',0);//20250206 C.B..

            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Profesiones, Artes y Oficios', 1,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Actividades de Servicios', 2,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Actividades Comerciales', 3,'',1);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Actividades Industriales', 4,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Actividades Agropecuarias', 5,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Utilidades y Dividendos', 6,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Exportaciones de bienes', 7,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Servicios Realizados en el Exterior y Utilizados en El Salvador', 8,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Exportaciones de servicios', 9,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Otras Rentas Gravables', 10,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Ingresos que ya fueron sujetos de retención en F910', 12,'',0);//20250206 C.B..
            $this->Configuracion_model->initGvarsNumEmpNew('iva_tipoi_renta', 'Sujetos pasivos excluidos (art. 6 LISR) e ingresos que no constituyen hecho generador del ISR', 13,'',0);//20250206 C.B..

            //verificacion existencia de campos primera vez
            $this->Configuracion_model->camposPrimeraVez();//20220425 Fernando Sigüenza
            $this->Configuracion_model->modifyTablecaj_def();//20230503
            $this->Configuracion_model->modifyTablegzips();//20230503
            $this->Configuracion_model->modifyFormatosImpresion();//20240820
            
            $this->Configuracion_model->createTableFacturacionElectronica();//20231009

            $this->Configuracion_model->validateCorrelativosDTE();//20241220 I.C.

            //$this->Configuracion_model->modifyTableconta_genfunc();//20230503
            //verificacion existencia tabla wpos
			$this->Media_model->existenciaTablas();//20220331 Fernando Sigüenza

            //Modificación Tablas (iva_table) (iva_2025)
            $this->Configuracion_model->modifyIvaTables();

            //Elimina archivos dte
            $this->deleteDteFilesOnServer();//20240201

            $this->data['totMensajes']      = $this->Mensajes_model->getNewMensajes($user);
            $this->data['mensajes']         = $this->Mensajes_model->getMensajes($user);
            $this->data['dataContactos']    = $this->Mensajes_model->getContactos($user);
			$this->data['sucursales']       = $this->Configuracion_model->getListadoSucursalesGrupoPerfil($centros_profile);
            
            $alertas_cuentas = $this->Configuracion_model->getListadoAlertasDeCuentas($this->session->userdata('idaccount'));
            $countAlertas=0;
            if($alertas_cuentas != false){
                $countAlertas=1;
            }

			$this->data['alertas_cuentas'] = $alertas_cuentas;
			$this->data['countAlertas'] = $countAlertas;
			$this->load->view("home", $this->data);
        }
        
        #Funcion de Configuración con Datos Actualizados.....
        /*
        function firstSettings(){
			date_default_timezone_set('America/El_Salvador');
			$fecha = new DateTime();
			
			$user = $this->session->userdata("iduser");
            $this->load->model("Configuracion_model");
            $this->load->model("Mensajes_model");
            $this->load->model('Sucursal_model');
            
            $_SESSION['menuSite'] = $this->Configuracion_model->getMenu($user);
            $_SESSION['appsSite'] = $this->Configuracion_model->getAplicaciones($user);
            $_SESSION['listApps'] = $this->Configuracion_model->getListadoAplicaciones($user);
            $_SESSION['menuType'] = $this->Configuracion_model->getTipoMenu($user);
            $_SESSION['userPerm'] = $this->Configuracion_model->getPermisos($user);
			
            $empleado = $this->Configuracion_model->getEmpleadoId($user);
            $descrip = $empleado['descrip'];
            $idcps = $empleado['idcps'];
            $imagen = $empleado['imagen'];
            $derechos = $empleado['derechos'];
            
			$permisoSucursal = 'multiSucursal';
			$resultBusqueda = strpos($derechos, $permisoSucursal);
			
			if($resultBusqueda !== false){
				$opcionSucursales = 1;
			}else{
				$opcionSucursales = 0;
			}
            
			$permisoAdmin = 'admin';
			$resultBusqueda2 = strpos($derechos, $permisoAdmin);
			
			if($resultBusqueda2 !== false){
				$opcionAdministrador = 1;
			}else{
				$opcionAdministrador = 0;
			}
            
			$permisoInventarios = 'adminInv';
			$resultBusqueda2 = strpos($derechos, $permisoInventarios);
			
			if($resultBusqueda2 !== false){
				$opcionInventarios = 1;
			}else{
				$opcionInventarios = 0;
            }
            
            $permisoCostos = 'costo';
			$resultCostos = strpos($derechos, $permisoCostos);
			
			if($resultCostos !== false){
				$opcionCostos = 1;
			}else{
				$opcionCostos = 0;
			}
			
            if($imagen == ""){
                $imagen = "sinFoto.jpg";
            }
            
            $empl_user = array('idEmpleadoUser' => $idcps, 'nameEmpleadoUser' => $descrip, 'imagenEmpleadoUser' => $imagen);  
            $this->session->set_userdata($empl_user); 
            
            $namePage = array('namePage' => 'Bienvenido/a '. $descrip);  
            $this->session->set_userdata($namePage);
            
            foreach($_SESSION['userPerm'] as $usuario){
                $id = $usuario->idcentro;
                $perfilUsuario = $usuario->profile;
                
                $nameCentro = $this->Configuracion_model->getNameCentroPasteles($id);
                $nameCaja = $this->Configuracion_model->getNameCajaUser($user);
                $idcajauser = $this->Configuracion_model->getIdCajaUser($user);
                $idcps = $this->Configuracion_model->getIDCPSCenter($id);
                $centros_profile = $this->Configuracion_model->getCentrosDelPerfil($perfilUsuario);
                $permisos_profile = $this->Configuracion_model->getListadoPermisosFiltro($perfilUsuario);

                $permisoTotalesFacturacion = 'no_mostrar_totales:1';
                $resultBusquedaTot = strpos($permisos_profile, $permisoTotalesFacturacion);
                
                if($resultBusquedaTot !== false){
                    $opcionTotalesFactu = 0;
                }else{
                    $opcionTotalesFactu = 1;
                }

                $permisoMotrarResumen = 'mostrar_resumen:1';
                $resultResumen = strpos($permisos_profile, $permisoMotrarResumen);
                
                if($resultResumen !== false){
                    $opcionMostrarResumen = 1;
                }else{
                    $opcionMostrarResumen = 0;
                }
            
                $idcentrouser = array(
                    'idcentrouser' => $id,
                    'perfiluser' => $perfilUsuario,
                    'nameCentroUser' => $nameCentro,
                    'idcps_center' => $idcps,
                    'nameCajaUser' => $nameCaja,
                    'idcajauser' => $idcajauser,
					'idCatalogo_slc' => '',
					'centros_profile' => $centros_profile,
					'opcionSucursales' => $opcionSucursales,
                    'opcionAdministrador' => $opcionAdministrador,
                    'opcionInventarios' => $opcionInventarios,
                    'opcionTotalesFactu' => $opcionTotalesFactu,
                    'opcionMostrarResumen' => $opcionMostrarResumen,
                    'opcionCostos' => $opcionCostos,
					'fechayhora' => $fecha->format('d/m/Y g:i A')
                );  
            }

            $this->session->set_userdata($idcentrouser);
            
            $dirAcc = "img_".trim($this->session->userdata('idaccount'));
            $nombre_fichero = 'img_cuentas/'.$dirAcc;
            
            $dirAcc3 = "doc_".trim($this->session->userdata('idaccount'));
            $nombre_fichero3 = 'doc_cuentas/'.$dirAcc3;
            
            $dirAcc2 = "reports_".trim($this->session->userdata('idaccount'));
            $nombre_fichero2 = 'application/controllers/'.$dirAcc2;
            
            $dirAcc4 = "adjuntos_".trim($this->session->userdata('idaccount'));
            $nombre_fichero4 = 'doc_adjuntos/'.$dirAcc4;
                        
            $dirCentralReport = "central_reports";
            $nombre_fichero_reports = 'application/controllers/'.$dirCentralReport;
                        
            $dirAccount = array(
                'diraccount' => $dirAcc,
                'dirReports' => $dirAcc2,
                'dirDocuments' => $dirAcc3,
                'dirAdjuntos' => $dirAcc4,
                'dirCentralReport' => $dirCentralReport,
               
            );  
            $this->session->set_userdata($dirAccount);
            
            if(!file_exists($nombre_fichero3)){
                mkdir("doc_cuentas/$dirAcc3", 0755);        
            }
            
            if(!file_exists($nombre_fichero)){
                mkdir("img_cuentas/$dirAcc", 0755);        
            }
            
            if(!file_exists($nombre_fichero2)){
                mkdir("application/controllers/$dirAcc2", 0755);        
            }
            
            if(!file_exists($nombre_fichero4)){
                mkdir("doc_adjuntos/$dirAcc4", 0755);        
            }
            
            if(!file_exists($nombre_fichero_reports)){
                mkdir("application/controllers/$dirCentralReport", 0755);        
            }
                        
            $hdBackColor = $this->Configuracion_model->getColorGvar('sy_hdcolor');
            $hdFontColor = $this->Configuracion_model->getColorGvar('sy_hdtittle');
            $LbFontColor = $this->Configuracion_model->getColorGvar('sy_formtf');
            $LbBackColor = $this->Configuracion_model->getColorGvar('sy_formtb');
            $FrBackColor = $this->Configuracion_model->getColorGvar('sy_formbk');
            $FHBackColor = $this->Configuracion_model->getColorGvar('sy_formhbk');
            $FHFontColor = $this->Configuracion_model->getColorGvar('sy_formhtf');
            $ImgMarkBack = $this->Configuracion_model->getColorGvar('sy_mainwt');
			$imgEmpresa = $this->Configuracion_model->getImagenLogoEmpresa('g_empicon');
			$tipoDispositivo = $this->Configuracion_model->detectarDispositivo();
            
			if($imgEmpresa == "" || $imgEmpresa == null){
				$nameImgEmpresa = base_url()."img/sinImagen.png";
			}else{
				$nombre_fichero = FCPATH.'img_cuentas/'.$this->session->userdata('diraccount')."/".$imgEmpresa;
				if(file_exists($nombre_fichero)){
					$nameImgEmpresa = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$imgEmpresa;
				}else{
					$nameImgEmpresa = base_url()."img/sinImagen.png";
				}
			}
			
            $coloresSistema = array(
                'hdBackground' => $hdBackColor,
                'hdFontcolor' => $hdFontColor,
                'LbFontColor' => $LbFontColor,
                'LbBackground' => $LbBackColor,
                'FrBackground' => $FrBackColor,
                'FHFontColor' => $FHFontColor,
                'FHBackground' => $FHBackColor,
                'MainBackground' => $ImgMarkBack,
				'nameImgEmpresa' => $nameImgEmpresa,
                'tipoDispositivo' => $tipoDispositivo
            );
            $this->session->set_userdata($coloresSistema);
            
			//Funcion para la inicialización de gvars tipo num, parametros ('Nombre Gvar', 'Descripción', 'Valor')
			//$this->Configuracion_model->initGvarsNum('', '', 0);
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Password para la anulación de facturas', 20170720); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Razon Social', 1); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Nombre comercial', 2); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Numero de Registro Fiscal', 3); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Numero de identificacion Tributaria', 4); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Giro', 5); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Direccion', 6); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Departamento y Municipio', 7); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Pais', 8); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Telefono', 9); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Tipo de Contribuyente', 10); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Correo Electronico', 11); //20170720
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Nombre del Contador', 12); //20171016
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Numero de Inscripción del Contador', 13); //20171016
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Nombre del Auditor', 14); //20171016
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Numero de Inscripción del Auditor', 15); //20171016
			$this->Configuracion_model->initGvarsNum('g_empdatos', 'Nombre del Representante Legal', 16); //20171016
            $this->Configuracion_model->initGvarsNum('gv_zip', 'Departamento Municipio Por Defecto', 193); //20170720
            $this->Configuracion_model->initGvarsNum('po_lotes', 'Permite las compras por lotes.', 0); //20180609
            $this->Configuracion_model->initGvarsNum('po_retaceos', 'Permite retaceos en compras.', 0); //20190823

            //Funcion para la inicialización de gvars tipo text, parametros ('Nombre Gvar', 'Descripción', 'Valor')
			//$this->Configuracion_model->initGvarsText('', '', '');
			$this->Configuracion_model->initGvarsText('po_notas', 'Notas en Ordenes de Compras', ' ');//20170814
            $this->Configuracion_model->initGvarsText('rf_clave0'.$id, 'Clave para el cierre de recuentos', '1234');//20170814
            
            #Variables Pos Facturación
			$this->Configuracion_model->initGvarsPosNums('pos_aplmaxdiscount', 'Aplicar descuento máximo de producto.', 0); //20180609
            $this->Configuracion_model->initGvarsPosNums('pos_clave', 'Password para la anulación de factura.', 201711); //20200206
			$this->Configuracion_model->initGvarsPosNums('pos_devmeses', 'Meses permitidos para la devolución de ventas.', 3); //20180404
            $this->Configuracion_model->initGvarsPosNums('pos_emailreq', 'Correo y Dui requerido.', 0); //20181101
			$this->Configuracion_model->initGvarsPosNums('pos_vendemode', 'Modalidad de captura de vendedor.', 0); //20170726
			$this->Configuracion_model->initGvarsPosNums('pos_maxglodiscount', 'Permite el descuento global en las ventas.', 0); //20180609
            $this->Configuracion_model->initGvarsPosNums('pos_secure', 'Comando configuración variables.', 0); //20181115
            $this->Configuracion_model->initGvarsPosNums('pos_newcli', 'Facturación para clientes nuevos', 0); //20170720
            $this->Configuracion_model->initGvarsPosNums('pos_referencia', 'Solicita referencia en facturación.', 0); //20170720
            $this->Configuracion_model->initGvarsPosNums('pos_multiprint', 'Permite impresión por lotes.', 0); //20170720
            #$this->Configuracion_model->initGvarsPosNums('pos_cupon', 'Cupones de descuento.', 0); //20170720
            $this->Configuracion_model->initGvarsPosNums('pos_sendprint0'.$idcajauser, 'No mandar a imprimir.', 0); //20181115
            $this->Configuracion_model->initGvarsPosNums('pos_cajafast0'.$idcajauser, 'Caja Super Rápida.', 0); //20181115
            $this->Configuracion_model->initGvarsPosNums('pos_idclase0'.$idcajauser, 'Clase predeterminada para caja.', 0); //20190703
            $this->Configuracion_model->initGvarsPosNums('pos_easy0'.$idcajauser, 'Modalidad venta rápida.', 0); //20181213
            
            $this->Configuracion_model->initGvarsPosNums('pos_cliente0'.$id, 'Cliente predeterminado para facturación.', 0); //20200206
            $this->Configuracion_model->initGvarsPosNums('pos_rprint0'.$id, 'Permite reimpresión.', 0); //20200206
            $this->Configuracion_model->initGvarsPosNums('pos_chgpre0'.$id, 'Permite cambio de precio.', 0); //20200206
            #$this->Configuracion_model->initGvarsPosNums('pos_passprecio'.$id, 'Clave cambio precio en ordenes de venta.', 0); //20200206
            
            $this->data['totMensajes'] = $this->Mensajes_model->getNewMensajes($user);
            $this->data['mensajes'] = $this->Mensajes_model->getMensajes($user);
            $this->data['dataContactos'] = $this->Mensajes_model->getContactos($user);
			$this->data['sucursales'] = $this->Configuracion_model->getListadoSucursalesGrupoPerfil($centros_profile);
            
            $countAlertas=0;
            $alertas_cuentas = $this->Configuracion_model->getListadoAlertasDeCuentas($this->session->userdata('idaccount'));
            
            if($alertas_cuentas != false){
                $countAlertas=1;
            }
            
            $this->data['alertas_cuentas'] = $alertas_cuentas;
			$this->data['countAlertas'] = $countAlertas;
            
            $this->load->view("home", $this->data);
        }
        */
        
        function phpEnDesarrollo(){
            $this->load->view("phpenproceso");
        }
		
		function nuevoMenu(){
            $this->load->view("nuevo_menu");
        }
        
        function configurarEstilo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
				$namePage = array(
					'namePage' => 'Personalizar Diseño',
				);  
				$this->session->set_userdata($namePage);
				
                $this->load->view("mantenimiento_estilo");
            }
        }
        
        function saveConfiguracion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $imgArchive = 'imgArchive';
                $config['upload_path'] = "img_cuentas/".$this->session->userdata('diraccount')."/";
                $config['allowed_types'] = "gif|jpg|jpeg|png";
                $this->load->library('upload', $config);
                $this->upload->do_upload($imgArchive);
                
                $navBackground = $this->input->post('txt-bgcolor');   
                $navFontColor = $this->input->post('txt-txcolor');
                $formHeadBackground = $this->input->post('txt-hdcolor');
                $formHeadFontColor = $this->input->post('txt-tittlecolor');
                $formLabelFontColor = $this->input->post('txt-labelcolor');
                $formLabelBackground = $this->input->post('txt-lbgcolor');
                $formBackground = $this->input->post('txt-fbgcolor');
                $nameArchive = $this->input->post('nameArchive');
                
                $this->load->model('Configuracion_model');
                $this->Configuracion_model->updateConfiguracionApp($navBackground, $navFontColor, $formHeadBackground, $formHeadFontColor, $formLabelFontColor, $formLabelBackground, $formBackground, $nameArchive);
            
                $coloresSistema = array(
                    'hdBackground' => $navBackground,
                    'hdFontcolor' => $navFontColor,
                    'LbFontColor' => $formLabelFontColor,
                    'LbBackground' => $formLabelBackground,
                    'FrBackground' => $formBackground,
                    'FHFontColor' => $formHeadFontColor,
                    'FHBackground' => $formHeadBackground,
                    'MainBackground' => $nameArchive
                );
                
                $this->session->set_userdata($coloresSistema);
                
                $this->configurarEstilo();
            }
        }
		
		function reasignarSucursalUsuario(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->input->post('idcentro');
				$idcaja   = $this->input->post('idcaja');
				$namecaja = $this->input->post('namecaja');
				
				$this->load->model('Configuracion_model');
				$nameCentro = $this->Configuracion_model->getNameCentroPasteles($idcentro);
                $idcps = $this->Configuracion_model->getIDCPSCenter($idcentro);
                //$nameCaja = $this->Configuracion_model->getNameCajaByIdcentro($idcentro);
                //$idcajauser = $this->Configuracion_model->getIdCajaByIdcentroUser($idcentro);
				
                $array = array(
                    'idcentrouser' => $idcentro,
                    'nameCentroUser' => $nameCentro,
                    'idcps_center' => $idcps,
                    'nameCajaUser' => $namecaja,
                    'idcajauser' => $idcaja
                );  
				$this->session->set_userdata($array);
				
				echo json_encode($array);
			}
        }
        
        function getValidateConfigEmail(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('Configuracion_model');
                $array = $this->Configuracion_model->getValidacionCorreoEmail();

                echo json_encode($array);
            }
        }
		
		function sendCorreoContactanos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$de = $_POST['inputContactoDe'];
				$para = $_POST['inputContactoPara'];
				$cc = $_POST['inputContactoCC'];
                $asunto = $_POST['inputContactoAsunto'];
                $mensaje = $_POST['inputContactoMensaje'];
                
                $fileAttach = 0; $errorAttach = 0;
                if(isset($_FILES["inputAdjuntoEmail"])){
                    $fileAttach = 1;
                    $infoFile = $_FILES["inputAdjuntoEmail"];
                    $nameDocument = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    
                    if($nameDocument != ""){
                        $nameDocument = str_replace(" ", "_", $nameDocument);
                        
                        $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                        $config['file_name'] = $nameDocument;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if(!$this->upload->do_upload('inputAdjuntoEmail')){
                           $errorAttach = 1;
                        }
                    }
                }

                $this->load->helper('path');
                $this->load->library('email');
				$this->email->from('info@versanetsa.com', 'GoXpos Contáctanos');
				
				if($cc != ""){
					$this->email->to($para.",info@versanetsa.com,goxpos.sistemas@versanetsa.com,".$cc);
				}else{
					$this->email->to($para.",info@versanetsa.com,goxpos.sistemas@versanetsa.com");
				}
				
				$this->email->subject($asunto);
				$this->email->set_mailtype("html");
				$body = "<h3>".$mensaje."</h3>";
				$body .= "<br><br><h4> Atte. ".$de."<br>".$this->session->userdata('descrip')."</h4>";
                $this->email->message($body);

                if($fileAttach == 1){
                    $path = set_realpath("./doc_cuentas/".$this->session->userdata('dirDocuments')."/");
                    $this->email->attach($path . $nameDocument);
                }
                
                if($fileAttach == 1){
                    if($errorAttach == 1){
                        $array_result = array(
                            "mensaje" => "Error, hay un problema con el archivo adjunto.",
                            "type" => "warning",
                        );

                        echo json_encode($array_result);
                    }else{
                        $emailSend = $this->email->send();    
                    }
                }else{
                    $emailSend = $this->email->send();
                }

				if($emailSend){
					$array_result = array(
						"mensaje" => "Correo enviado",
						"type" => "success",
					);
				}else{
					$array_result = array(
						"mensaje" => "Correo no enviado",
						"type" => "warning",
					);
				}
				
				echo json_encode($array_result);
			}
		}
		
		function sendCorreoContactanosTicket(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$de         = $_POST['inputContactoDe'];
				$para       = $_POST['inputContactoPara'];
				$cc         = $_POST['inputContactoCC'];
                $asunto     = $_POST['inputContactoAsunto'];
                $mensaje    = $_POST['inputContactoMensaje'];
                $idcliente  = $_POST['idCliente'];
                
                $fileAttach = 0; $errorAttach = 0;
                if(isset($_FILES["inputAdjuntoEmail"])){
                    $fileAttach = 1;
                    $infoFile = $_FILES["inputAdjuntoEmail"];
                    $nameDocument = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    
                    if($nameDocument != ""){
                        $nameDocument = str_replace(" ", "_", $nameDocument);
                        
                        $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                        $config['file_name'] = $nameDocument;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if(!$this->upload->do_upload('inputAdjuntoEmail')){
                           $errorAttach = 1;
                        }
                    }
                }

                $this->load->helper('path');
                $this->load->library('email');
				$this->email->from('info@versanetsa.com', 'GoXpos Contáctanos');
				
				if($cc != ""){
					$this->email->to($para.",info@versanetsa.com,goxpos.sistemas@versanetsa.com,".$cc);
				}else{
					$this->email->to($para.",info@versanetsa.com,goxpos.sistemas@versanetsa.com");
				}
				
				$this->email->subject($asunto);
				$this->email->set_mailtype("html");
				$body = "<h3>".$mensaje."</h3>";
				$body .= "<br><br><h4> Atte. ".$de."<br>".$this->session->userdata('descrip')."</h4>";
                $this->email->message($body);

                if($fileAttach == 1){
                    $path = set_realpath("./doc_cuentas/".$this->session->userdata('dirDocuments')."/");
                    $this->email->attach($path . $nameDocument);
                }
                
                if($fileAttach == 1){
                    if($errorAttach == 1){
                        $array_result = array(
                            "mensaje" => "Error, hay un problema con el archivo adjunto.",
                            "type" => "warning",
                        );

                        echo json_encode($array_result);
                    }else{
                        $emailSend = $this->email->send();    
                    }
                }else{
                    $emailSend = $this->email->send();
                }

				if($emailSend){
					$array_result = array(
						"mensaje" => "Correo enviado",
						"type" => "success",
					);
				}else{
					$array_result = array(
						"mensaje" => "Correo no enviado",
						"type" => "warning",
					);
				}
				
				echo json_encode($array_result);
			}
		}
		
		function getInformacionDeAyuda(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('media_model');
				$grupos = $this->media_model->getGrupos();
				/*$informacion = $this->media_model->getMediaInformation();
				$i=0;
				$array = array();
				foreach($grupos as $grup){
					$j=0;
					$items = array();
					foreach($informacion as $inf){
						if($inf->grupo == $grup->grupo){
							$items[$j] = array(
								"descrip" => $inf->descrip,
								"tipo" => $inf->tipo,
								"enlace" => $inf->enlace
							);
							$j++;	
						}
					}
					
					$array[$i] = array(
						"key" => $grup->grupo,
						"items" => $items
					);
					$i++;
				}
				echo json_encode($array);//*/
                $datos = $this->media_model->getMedia();
                $Datos = [];
                $Grupos = [];
                if (count((array)$grupos) > 0) {
                    foreach ($grupos as $key => $grupo) {
                        $Grupos[] = array(
                            'ID' => $key,
                            'Name' => trim($grupo->grupo)
                        );
                    }
                }
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        $Datos[] = array(
                            'ID' => $key,
                            'Name' => trim($dato->descrip),
                            'tipo' => $dato->tipo,
                            'autor' => trim($dato->autor),
                            'enlace' => trim($dato->enlace),
                            'grupo' => trim($dato->grupo),
                            'notas' => trim($dato->notas),
                            'frevision' => date_format(date_create($dato->frevision),"d / m / Y")
                        );
                    }
                }//*/
                $datA[] = array('valido' => true, 'grupos' => $Grupos,'datos' => $Datos);
                echo json_encode($datA);
			}
        }
        
        function confirmarLecturaNoticia(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
				
                $this->load->model('Configuracion_model');
                $array = $this->Configuracion_model->confirmarLecturaNoticia($idrec);

                echo json_encode($array);
            }
        }
		
        function getoldocs(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('Configuracion_model');
				$grupos = $this->Configuracion_model->getHeaderDocs();
				$hijos = $this->Configuracion_model->getCategoriasDocs();
				$i=0;
				$array = array();
                $iduser = $this->session->userdata("iduser");
                var_dump($hijos);
                foreach($grupos as $grup){
					$j=0;
					$items = array();
                    foreach($hijos as $inf){
                        $allow_edit= 0;
                        if($iduser!=1){
                            $usuarios = explode(",", $inf->writeusers);
                            $totUsers = count($usuarios);
                            $totUsers = $totUsers - 1;
                            if($usuarios!=""){
                                for($z=0; $z<=$totUsers; $z++){
                                    if(round($usuarios[$z]) == $iduser){
                                        $allow_edit = 1;
                                        break;
                                    }
                                }
                            }
                        }else{
                            $allow_edit = 1;
                        }
                        
						if($inf->idnivel1 == $grup->iddoc){
							$items[$j] = array(
								"iddoc" => $inf->iddoc,
								"fecha" => $inf->fecha,
								"nivel" => $inf->nivel,
								"idnivel1" => $inf->idnivel1,
								"descrip" => $inf->descrip,
								"key" => $inf->descrip,
								"version" => $inf->version,
								"doctipo" => $inf->doctipo,
								"archivo" => $inf->archivo,
								"perfiles" => $inf->perfiles,
								"usuarios" => $inf->usuarios,
								"writeusers" => $inf->writeusers,
								"idcreator" => $inf->idcreator,
								"allow_edit" => $allow_edit,
								"estado" => $inf->estatus,
							);
							$j++;	
						}
					}
					$array[$i] = array(
						"iddoc" => $grup->iddoc,
						"key" => $grup->descrip,
						"items" => $items
					);
					$i++;
				}
				echo json_encode($array);
			}
		}

        function getDocumentosEnLinea(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
				$grupos = $this->configuracion_model->getHeaderDocs();
                $arrayDocumentos = array();
                $j=0;

                if($grupos!=false){
                    foreach($grupos as $grupo){
                        $childrens = $this->configuracion_model->getDocsByCategoria($grupo->iddoc);

                        if($childrens!=false){
                            foreach($childrens as $child){
                                $arrayDocumentos[$j] = array(
                                    "iddoc"=>$child->iddoc,
                                    "fecha"=>$child->fecha,
                                    "nivel"=>$child->nivel,
                                    "idnivel1"=>$child->idnivel1,
                                    "descrip"=>$child->descrip,
                                    "version"=>$child->version,
                                    "doctipo"=>$child->doctipo,
                                    "archivo"=>$child->archivo,
                                    "perfiles"=>$child->perfiles,
                                    "usuarios"=>$child->usuarios,
                                    "writeusers" => $child->writeusers,
                                    "idcreator"=>$child->idcreator,
                                    "estatus"=>$child->estatus,
                                    "whodidit"=>$child->whodidit,
                                    "ingresa"=>$child->ingresa,
                                    "modifica"=>$child->modifica,
                                    "categoria"=>$grupo->descrip,
                                );
                                $j++;
                            }
                        }else{
                            $arrayDocumentos[$j] = array(
                                "iddoc"=>"",
                                "descrip"=>"Sin Documentos",
                                "categoria"=>$grupo->descrip,
                            );
                            $j++;  
                        }
                    }
                }
                echo json_encode($arrayDocumentos);
            }
        }
        
        function getCategoriasDocs(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('Configuracion_model');
				$grupos = $this->Configuracion_model->getHeaderDocs();
                echo json_encode($grupos);
			}
		}
        
        function addCatDocs(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $categoria = $this->input->post("categoria");
				$this->load->model('Configuracion_model');
				$insert = $this->Configuracion_model->insertHeaderDocs($categoria);
                $grupos = $this->Configuracion_model->getHeaderDocs();
				$hijos = $this->Configuracion_model->getCategoriasDocs();
				$array_docs = array();
				$i=0;
                $iduser = $this->session->userdata("iduser");
                foreach($grupos as $grup){
					$j=0;
					$items = array();
                    foreach($hijos as $inf){
                        $allow_edit= 0;
                        if($iduser!=1){
                            $usuarios = explode(",", $inf->writeusers);
                            $totUsers = count($usuarios);
                            $totUsers = $totUsers - 1;
                            if($usuarios!=""){
                                for($z=0; $z<=$totUsers; $z++){
                                    if(round($usuarios[$z]) == $iduser){
                                        $allow_edit = 1;
                                        break;
                                    }
                                }
                            }
                        }else{
                            $allow_edit = 1;
                        }
                        
						if($inf->idnivel1 == $grup->iddoc){
							$items[$j] = array(
								"iddoc" => $inf->iddoc,
								"fecha" => $inf->fecha,
								"nivel" => $inf->nivel,
								"idnivel1" => $inf->idnivel1,
								"descrip" => $inf->descrip,
								"key" => $inf->descrip,
								"version" => $inf->version,
								"doctipo" => $inf->doctipo,
								"archivo" => $inf->archivo,
								"perfiles" => $inf->perfiles,
								"usuarios" => $inf->usuarios,
								"writeusers" => $inf->writeusers,
								"idcreator" => $inf->idcreator,
								"allow_edit" => $allow_edit,
                                "estado" => $inf->estatus,
							);
							$j++;	
						}
					}
					$array_docs[$i] = array(
						"iddoc" => $grup->iddoc,
						"key" => $grup->descrip,
						"items" => $items
					);
					$i++;
				}
                $array = array(
                    "headers" => $grupos,
                    "documents" =>$array_docs
                );
                
				echo json_encode($array);
			}
		}

        function updateCatDocs(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $iddoc = $this->input->post("iddoc");
                $descrip = $this->input->post("descrip");
				$this->load->model('Configuracion_model');
				$update = $this->Configuracion_model->updateCatDocs($iddoc,$descrip);
				$grupos = $this->Configuracion_model->getHeaderDocs();
                $hijos = $this->Configuracion_model->getCategoriasDocs();
				$i=0;
				$array_docs = array();$array_docs = array();
                $iduser = $this->session->userdata("iduser");
                
                foreach($grupos as $grup){
					$j=0;
					$items = array();
                    foreach($hijos as $inf){
                        $allow_edit= 0;
                        if($iduser!=1){
                            $usuarios = explode(",", $inf->writeusers);
                            $totUsers = count($usuarios);
                            $totUsers = $totUsers - 1;
                            if($usuarios!=""){
                                for($z=0; $z<=$totUsers; $z++){
                                    if(round($usuarios[$z]) == $iduser){
                                        $allow_edit = 1;
                                        break;
                                    }
                                }
                            }
                        }else{
                            $allow_edit = 1;
                        }
                        
						if($inf->idnivel1 == $grup->iddoc){
							$items[$j] = array(
								"iddoc" => $inf->iddoc,
								"fecha" => $inf->fecha,
								"nivel" => $inf->nivel,
								"idnivel1" => $inf->idnivel1,
								"descrip" => $inf->descrip,
								"key" => $inf->descrip,
								"version" => $inf->version,
								"doctipo" => $inf->doctipo,
								"archivo" => $inf->archivo,
								"perfiles" => $inf->perfiles,
								"usuarios" => $inf->usuarios,
								"writeusers" => $inf->writeusers,
								"idcreator" => $inf->idcreator,
								"allow_edit" => $allow_edit,
                                "estado" => $inf->estatus,
							);
							$j++;	
						}
					}
					$array_docs[$i] = array(
						"iddoc" => $grup->iddoc,
						"key" => $grup->descrip,
						"items" => $items
					);
					$i++;
				}
                
                $array = array(
                    "headers" => $grupos,
                    "documents" =>$array_docs
                );
				echo json_encode($array);
			}
		}
        
        function getProfilesAndUsers(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('user_model');
				$this->load->model('gerencia_model');
				$profiles = $this->user_model->getProfile();
                $usuarios = $this->gerencia_model->getUsuariosFiltrados(1);
                $array_profiles = array();
                $i=0;
                if($profiles!=false){
                    foreach($profiles as $pro){
                        $array_profiles[$i] = array (
                            "id" => round($pro->valor_num),
                            "descrip" => $pro->descripcion,
                        );
                        $i++;
                    }
                }
                $array_users = array();
                $j=0;
                if($usuarios!=false){
                    foreach($usuarios as $user){
                        $array_users[$j] = array (
                            "id" => round($user->iduser),
                            "descrip" => $user->descrip,
                        );
                        $j++;
                    }
                }
                $array_writeusers = array();
                $k=0;
                if($usuarios!=false){
                    foreach($usuarios as $user){
                        if(round($user->iduser) != $this->session->userdata("iduser")){
                            $array_writeusers[$k] = array (
                                "id" => round($user->iduser),
                                "descrip" => $user->descrip,
                            );
                            $k++;
                        }
                    }
                }
                $array = array(
                    "profiles" => $array_profiles,
                    "users" => $array_users,
                    "writeusers" => $array_writeusers,
                );
                echo json_encode($array);
			}
		}
        
        function uploadFiles(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('Configuracion_model');
                if($this->input->post()){
                    $iddoc = $this->input->post('idnivel1');
                    $fecha = '';
                    $descrip = $this->input->post('descrip');
                    $doctype = 7;//$this->input->post('doc_doctype');
                    $doc_Version = ''; //$this->input->post('doc_Version');
                    $profiles_allowed = $this->input->post('perfiles');
                    $users_allowed = $this->input->post('usuarios');
                    $writeusers = $this->input->post('writeusers');
                    $doc = "";
                    $sube = "";

                    $estatus = $this->input->post('estatus');
                    if($estatus=="false"){
                        $estatus = 0;
                    }else{
                        $estatus = 1;
                    }

                    $doc = $this->input->post('archivo');
                    $new_iddoc = $this->Configuracion_model->insertDoc($iddoc, $fecha, $descrip, $doctype, $doc_Version, $profiles_allowed, $users_allowed, $writeusers, $doc, "", $estatus);
                }
                
                echo json_encode($new_iddoc);
            }
        }
        
        function getSourceUsers(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('user_model');
				$this->load->model('gerencia_model');
				$profiles = $this->user_model->getProfile();
                $usuarios = $this->gerencia_model->getUsuariosFiltrados(1);
                $array_profiles = array();
                $i=0;
                if($profiles!=false){
                    foreach($profiles as $pro){
                        $array_users = array();
                        $j=0;
                        if($usuarios!=false){
                            foreach($usuarios as $user){
                                if(round($pro->valor_num) == $user->profile){
                                    $array_users[$j] = array (
                                        "id" => round($user->iduser),
                                        "descrip" => $user->descrip,
                                    );
                                    $j++;
                                }
                            }
                        }
                        $array_profiles[$i] = array (
                            "id" => round($pro->valor_num)."_",
                            "descrip" => $pro->descripcion,
                            "items" => $array_users,
                            "idReal" =>round($pro->valor_num),
                        );
                        $i++;
                    }
                }
                echo json_encode($array_profiles);
			}
		}
        
        function getmydocs(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$this->load->model('Configuracion_model');
				$grupos = $this->Configuracion_model->getHeaderDocs();
				$hijos = $this->Configuracion_model->getCategoriasDocs();
				$i=0;
				$array = array();
                
                $perfiluser = $this->session->userdata("perfiluser");
                $iduser = $this->session->userdata("iduser");
                    
                foreach($grupos as $grup){
					$j=0;
					$items = array();
					foreach($hijos as $inf){
                        if($inf->idnivel1 == $grup->iddoc){
                            $allow_see = 0;
                            $profiles = explode(",", $inf->perfiles);
                            $totPer = count($profiles);
                            $totPer = $totPer - 1;
                            if($profiles!=""){
                                for($w=0; $w<=$totPer; $w++){
                                    if(round($profiles[$w]) == $perfiluser){
                                        $allow_see = 1;
                                        break;
                                    }
                                }
                            }
                            
                            if($allow_see==0){
                                $usuarios = explode(",", $inf->usuarios);
                                $totUsers = count($usuarios);
                                $totUsers = $totUsers - 1;
                                if($usuarios!=""){
                                    for($z=0; $z<=$totUsers; $z++){
                                        if(round($usuarios[$z]) == $iduser){
                                            $allow_see = 1;
                                            break;
                                        }
                                    }
                                }
                            }
                            
                            if(($allow_see == 1 || $iduser==1 || $iduser == $inf->idcreator) && $inf->estatus ==1 ){
                                $items[$j] = array(
                                    "iddoc" => $inf->iddoc,
                                    "fecha" => $inf->fecha,
                                    "nivel" => $inf->nivel,
                                    "idnivel1" => $inf->idnivel1,
                                    "descrip" => $inf->descrip,
                                    "key" => $inf->descrip,
                                    "version" => $inf->version,
                                    "doctipo" => $inf->doctipo,
                                    "archivo" => $inf->archivo,
                                    "perfiles" => $inf->perfiles,
                                    "usuarios" => $inf->usuarios,
                                    "writeusers" => $inf->writeusers,
                                    "idcreator" => $inf->idcreator,
                                    "estado" => $inf->estatus,
                                );
                                $j++;
                            }
						}
					}
                    if($j>0){
                        $array[$i] = array(
                            "iddoc" => $grup->iddoc,
                            "key" => $grup->descrip,
                            "items" => $items
                        );
                        $i++;
                    }
					
				}
				echo json_encode($array);
			}
		}
        
        function updateFileInfo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('Configuracion_model');
                if($this->input->post()){
                    $iddoc = $this->input->post('iddoc');
                    $idnivel1 = $this->input->post('idnivel1');
                    $fecha = '';
                    $descrip = $this->input->post('descrip');
                    $doctype = 7;//$this->input->post('doc_doctype');
                    $doc_Version = ''; //$this->input->post('doc_Version');
                    $profiles_allowed = $this->input->post('perfiles');
                    $users_allowed = $this->input->post('usuarios');
                    $writeusers = $this->input->post('writeusers');
                    $doc = "";
                    $sube = "";

                    $estatus = $this->input->post('estatus');
                    if($estatus=="false"){
                        $estatus = 0;
                    }else{
                        $estatus = 1;
                    }
                    $doc = $this->input->post('archivo');

                    $update_doc = $this->Configuracion_model->updateDoc($iddoc, $descrip, $profiles_allowed, $users_allowed, $writeusers, $doc, $estatus, $idnivel1); 
                }
                
                echo json_encode($update_doc);
            }
        }
        
        function getActiveUsersProfiles(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('user_model');
				$this->load->model('gerencia_model');
				$profiles = $this->user_model->getActiveUsersProfiles();
                
                echo json_encode($profiles);
			}
		}
        
        function getEditorsUpdate(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('gerencia_model');
                $users = $this->input->post("writeusers");
                $usuarios = $this->gerencia_model->getUsuariosFiltrados(1);
                $array_writeusers = array();
                $i=0;
                $cadena_users = array();
                $can_u = 0;
                if($usuarios!=false){
                    foreach($usuarios as $user){
                        if(round($user->iduser) != $this->session->userdata("iduser")){
                            $allow_edit = false;
                            $array_users = explode(",", $users);
                            $totUs = count($array_users);
                            if($array_users!=""){
                                for($x=0; $x<$totUs; $x++){
                                    if(round($array_users[$x]) == round($user->iduser)){
                                        $allow_edit = true;
                                        $cadena_users[$can_u] = $user->iduser;
                                        $can_u++;
                                        break;
                                    }
                                }
                            }
                            $array_writeusers[$i] = array (
                                "id" => $user->iduser,
                                "descrip" => $user->descrip,
                                "selected" =>$allow_edit
                            );
                            $i++;
                        }
                    }
                }
                $array = array(
                    "cadena" =>$cadena_users,
                    "array" =>$array_writeusers,
                );
                echo json_encode($array);
			}
		}
        
        function getUsuariosDocumento(){

        }
        function deleteDocumento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('Configuracion_model');
                $iddoc = $this->input->post("iddoc");
                
                $delete = $this->Configuracion_model->deleteDoc($iddoc);
                
                echo json_encode($delete);
            }
        }

        function setDatosPreviewDocumento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $titulo = $this->input->post("titulo");
                $contenido = $this->input->post("contenido");
                $_SESSION['previewDocumentoTitulo'] =$titulo;    
                $_SESSION['previewDocumentoContenido'] =$contenido;         
                echo json_encode(true);
            }
        }

        function previewDocumento(){
            $titulo = $_SESSION['previewDocumentoTitulo'];    
            $contenido = $_SESSION['previewDocumentoContenido'];   
                 
            $date_utc = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            $date_utc = date_format($date_utc, "d/m/Y h:i");    

            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle(strtoupper($titulo));
            $pdf->SetSubject(strtoupper($titulo));
            $pdf->SetMargins(10, 25, 10, true);

            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
            $pdf->SetFont('Helvetica', '', 8, '', true);
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $pdf->setPrintHeader(true); 
            $pdf->setPrintFooter(true);

            $header = "<table style='width:100%; padding:0px;'><tr>";
            $header .= '<td rowspan = 2 style="text-align: left;"><img src="https://vgoxpos.com/sistemas/assets/images/logo.png" alt="" width="200" height="60"/></td>';
            $header .= '<td style="text-align: right; font-weight: bold;">'.$titulo.'<br>'.$date_utc.'</td>';
            $header .= "</tr></table>";
            $pdf->setHtmlHeader($header);

            //$date_utc = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
            //$date_utc = date_format($date_utc, "d/m/Y h:i");
            //$footer = '<p style="text-align: center; font-size: 13px;"> Creado por: '.$resultado['autor'].'<br>'.$date_utc.'</p>';
            //$pdf->setHtmlFooter($footer);

            $pdf->addPage('P', 'LETTER');


            $pdf->SetXY( 15, 25 );
            $pdf->SetFont('helvetica', '', 9);
            $contenido = str_replace('data:image/png;base64,', '@', $contenido);
            $contenido = str_replace('data:image/jpeg;base64,', '@', $contenido);

            $contenido = str_replace('<table>', '<table style="max-width:100%;">', $contenido);

            $pdf->writeHTML($contenido, true, false, true, false, '');

            $nombre_archivo = utf8_decode(strtoupper($titulo).'.pdf');
            $pdf->Output($nombre_archivo, 'I');  
        }
        
        function getListadoSucursalesGrupo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('Sucursal_model');
                $infoSucursales = $this->Sucursal_model->viewSucursalActiva();
                
                $i=0;
                $array = array();
                foreach($infoSucursales as $info){
                    $array[$i] = array(
                        "id" => $info->idcentro,
                        "descrip" => strtoupper(trim($info->descrip)),
                        "grupo" => strtoupper(trim($info->grupo))
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
        function getListadoSucursalesGrupoPerfil(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $centros_profile = $this->session->userdata('centros_profile');

                $this->load->model('Configuracion_model');
                $infoSucursales = $this->Configuracion_model->getListadoSucursalesGrupoPerfil($centros_profile);
                
                $i=0;
                $array = array();
                foreach($infoSucursales as $info){
                    $array[$i] = array(
                        "id" => $info->idcentro,
                        "idcaja" => $info->idcaja,
                        "descrip" => strtoupper(trim($info->descrip)),
                        "namecaja" => strtoupper(trim($info->namecaja)),
                        "grupo" => strtoupper(trim($info->grupo))
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
        function generadorDatosSQL($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('Configuracion_model');
                $this->load->model('global_model');
                $this->load->model('user_model');
                $appName = $this->Configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->data['usuarios'] = $this->user_model->viewUserEdit();
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
				$this->data['informacion'] = $this->Configuracion_model->getListadoQuerys();
                $this->load->view('mantenimiento_generador_sql', $this->data);
            }
        }

        function updateUsuariosSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $usuarios = $this->input->post('usuarios');
                
                $this->load->model('Configuracion_model');
                $this->Configuracion_model->updateUsuariosSQL($idrec, $usuarios);
                $array = $this->Configuracion_model->getListadoQuerys();

                echo json_encode($array);
            }
        }
        
        function getInformacionConsultaSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                
                $this->load->model('Configuracion_model');
                $informacion = $this->Configuracion_model->getInformacionConsultaSQL($idrec);
                
                $infoRequerida = 0;
                //if($informacion['allowedusers'] == 1 || $informacion['askdaterange'] == 1 || $informacion['askcentro'] == 1 || $informacion['askcaja'] == 1){
                if($informacion['askdaterange'] == 1 || $informacion['askcentro'] == 1 || $informacion['askcaja'] == 1){
                    $infoRequerida = 1;
                }
                
                $array = array(
                    'infoRequerida' => $infoRequerida,
                    'allowedusers' => $informacion['allowedusers'],
                    'askdaterange' => $informacion['askdaterange'],
                    'askcentro' => $informacion['askcentro'],
                    'askcaja' => $informacion['askcaja']                    
                );
                
                echo json_encode($array);
            }
        }
        
        function ejecutarConsultaSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idcaja = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                
                $this->load->model('Configuracion_model');
                $dataSource = $this->Configuracion_model->ejecutarConsultaSQL($idrec, $idcentro, $idcaja, $fechaini, $fechafin);
                $infoSource = $this->Configuracion_model->getInformacionColumn($idrec);
                
                $array = array(
                    'dataSource' => $dataSource,
                    'infoSource' => $infoSource
                );
                
                echo json_encode($array);
            }
        }
        
        function ejecutarConsultaSQLSimple(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                
                $this->load->model('Configuracion_model');
                $dataSource = $this->Configuracion_model->ejecutarConsultaSQLSimple($idrec);
                $infoSource = $this->Configuracion_model->getInformacionColumn($idrec);
                
                $array = array(
                    'dataSource' => $dataSource,
                    'infoSource' => $infoSource
                );
                
                echo json_encode($array);
            }
        }
        
        function mantenimientoGeneradorSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'appName' => 'Mantenimiento Generador SQL',
                    'namePage' => 'Mantenimiento Generador SQL'
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('user_model');
                $this->data['usuarios'] = $this->user_model->viewUser();
				$this->load->view('mantenimiento_conf_generador_sql', $this->data);
            }
        }
        
        function getDataSourceConsultasSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipo = $this->input->post('tipo');
                
                $this->load->model('Configuracion_model');
                $array = $this->Configuracion_model->getDataSourceConsultasSQL($tipo);
                
                echo json_encode($array);
            }
        }
        
        function adicionarRegistroSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $descrip = $this->input->post('descrip');
                $tipo = $this->input->post('tipo');
                $centro = $this->input->post('centro');
                $caja = $this->input->post('caja');
                $periodo = $this->input->post('periodo');
                $notas = $this->input->post('notas');
                $estado = $this->input->post('estado');
                $usuarios = $this->input->post('usuarios');
                $consulta = $this->input->post('consulta');
                
                $this->load->model('Configuracion_model');
                $this->Configuracion_model->adicionarRegistroSQL($descrip, $tipo, $centro, $caja, $periodo, $notas, $estado, $usuarios, $consulta);
                $array = $this->Configuracion_model->getDataSourceConsultasSQL($tipo);
                
                echo json_encode($array);
            }
        }
        
        function actualizarRegistroSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $descrip = $this->input->post('descrip');
                $tipo = $this->input->post('tipo');
                $centro = $this->input->post('centro');
                $caja = $this->input->post('caja');
                $periodo = $this->input->post('periodo');
                $notas = $this->input->post('notas');
                $estado = $this->input->post('estado');
                $usuarios = $this->input->post('usuarios');
                
                $this->load->model('Configuracion_model');
                $this->Configuracion_model->actualizarRegistroSQL($idrec, $descrip, $tipo, $centro, $caja, $periodo, $notas, $estado, $usuarios);
                $array = $this->Configuracion_model->getDataSourceConsultasSQL($tipo);
                
                echo json_encode($array);
            }
        }
        
        function actualizarRegistroSQLConsulta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $descrip = $this->input->post('descrip');
                $tipo = $this->input->post('tipo');
                $centro = $this->input->post('centro');
                $caja = $this->input->post('caja');
                $periodo = $this->input->post('periodo');
                $notas = $this->input->post('notas');
                $estado = $this->input->post('estado');
                $usuarios = $this->input->post('usuarios');
                $consulta = $this->input->post('consulta');
                
                $this->load->model('Configuracion_model');
                $this->Configuracion_model->actualizarRegistroSQLConsulta($idrec, $descrip, $tipo, $centro, $caja, $periodo, $notas, $estado, $usuarios, $consulta);
                $array = $this->Configuracion_model->getDataSourceConsultasSQL($tipo);
                
                echo json_encode($array);
            }
        }
        
        function eliminarRegistroSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $tipo = $this->input->post('tipo');
                
                $this->load->model('Configuracion_model');
                $this->Configuracion_model->eliminarRegistroSQL($idrec);
                $array = $this->Configuracion_model->getDataSourceConsultasSQL($tipo);
                
                echo json_encode($array);
            }
        }

        function moduloActualizacionDatos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'appName' => "Consulta Base de Datos",
                    'namePage' => "Consulta Base de Datos"
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('inicializacion_model');
                $this->data['tablas'] = $this->inicializacion_model->getTablesOrderTable();

                $this->load->view('mantenimiento_actualizacion_sql', $this->data);
            }
        }

        function getInformacionCamposTablaSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $nameTable = $this->input->post('nameTable');
                
                $this->load->model('Configuracion_model');
                $informacion = $this->Configuracion_model->getInformacionCamposTablaSQL($nameTable);
                
                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => $info->columna,
                            "descrip" => $info->columna
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }

        function ejecutarBusquedaDatosSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $nameSearch = $this->input->post('nameSearch');
                $nameTable = $this->input->post('nameTable');
                $nameCampo = $this->input->post('nameCampo');
                $valorFiltro = $this->input->post('valorFiltro');

                $this->load->model('Configuracion_model');
                $dataSource = $this->Configuracion_model->ejecutarBusquedaDatosSQL($nameSearch, $nameTable, $nameCampo, $valorFiltro);
                
                $array = array(
                    'dataSource' => $dataSource
                );
                
                echo json_encode($array);
            }
        }

        function ejecutarCambiosDatosSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //VALORES
                $newValues = $this->input->post('newValues');
                $oldValues = $this->input->post('oldValues');
                $nameTable = $this->input->post('nameTable');

                $keyName = $this->input->post('keyName');
                $keyValue = $this->input->post('keyValue');
               

                //INFO DE PETICION
                $motivo = $this->input->post('motivo');
                $solicita = $this->input->post('solicita');
                $password = $this->input->post('password');

                //INFO DE BUSQUEDA
                $nameSearch = $this->input->post('nameSearch');
                $nameCampo = $this->input->post('nameCampo');
                $valorFiltro = $this->input->post('valorFiltro');

                $this->load->model('Configuracion_model');
                //SE REALIZA UNA UNICA VERIFICACION DE CONTRASEÑA PARA TODOS LOS CAMPOS
                $verificacion = $this->Configuracion_model->verificarContraCambiosSql($password);

                if($verificacion){
                    //SE MODIFICA LA INFORMACION A PARTIR DEL ARRAY DE LOS CAMPOS MODIFICADOS
                    foreach($newValues as $campo => $valor){
                        $valorAntColumna = $oldValues[$campo];
                        $result = $this->Configuracion_model->ejecutarCambiosDatosSQL($keyValue, $nameTable, $keyName, $campo, $valor, $valorAntColumna, $motivo, $solicita, $password);
                    }
                }
                //$result = $this->Configuracion_model->ejecutarCambiosDatosSQL($idCambio, $nameTable, $columnaCod, $nameColumna, $valorColumna, $valorAntColumna, $motivo, $solicita, $password);
                $dataSource = $this->Configuracion_model->ejecutarBusquedaDatosSQL($nameSearch, $nameTable, $nameCampo, $valorFiltro);
                
                echo json_encode(array(
                    'validate' => $verificacion,
                    'dataSource' => $dataSource
                ));
                
            }
        }

        function getDatosIngresadosVerificacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');

                echo json_encode(array(
                    'dataAgentes'   => $this->configuracion_model->getListadoAgentes(),
                    'dataGestiones' => $this->configuracion_model->getListadoGestiones()
                ));
            }
        }

        function insertDatosVerificacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $agente    = $this->input->post('agente');
                $solicitud = $this->input->post('solicitud');
                $notas     = $this->input->post('notas');

                $this->load->model('configuracion_model');
                echo json_encode($this->configuracion_model->insertDatosVerificacion($agente, $solicitud, $notas));
            }
        }

        function updateDatosVerificacion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $notas = $this->input->post('notas');

                $this->load->model('configuracion_model');
                echo json_encode($this->configuracion_model->updateDatosVerificacion($idrec, $notas));
            }
        }

        function validatePrimerIngreso() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $iduser = $this->session->userdata('iduser');
                
                $this->load->model('configuracion_model');
                echo json_encode($this->configuracion_model->getValidatePrimerIngreso($iduser));

            }
        }

        function validateCorrelativosDTE() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->load->model('configuracion_model');
                $this->configuracion_model->createCamposMH();
                echo json_encode($this->configuracion_model->validateCorrelativosDTE());
            }
        }

        /*
        function ejecutarCambiosDatosSQL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $motivo = $this->input->post('motivo');
                $solicita = $this->input->post('solicita');
                $idCambio = $this->input->post('idCambio');
                $nameTable = $this->input->post('nameTable');
                $columnaCod = $this->input->post('columnaCod');
                $nameColumna = $this->input->post('nameColumna');
                $valorColumna = $this->input->post('valorColumna');
                $valorAntColumna = $this->input->post('valorAntColumna');
                $nameSearch = $this->input->post('nameSearch');
                $nameCampo = $this->input->post('nameCampo');
                $password = $this->input->post('password');
                $valorFiltro = $this->input->post('valorFiltro');

                $this->load->model('Configuracion_model');
                $result = $this->Configuracion_model->ejecutarCambiosDatosSQL($idCambio, $nameTable, $columnaCod, $nameColumna, $valorColumna, $valorAntColumna, $motivo, $solicita, $password);
                $dataSource = $this->Configuracion_model->ejecutarBusquedaDatosSQL($nameSearch, $nameTable, $nameCampo, $valorFiltro);
                
                echo json_encode(array(
                    'validate' => $result,
                    'dataSource' => $dataSource
                ));
            }
        }*/

        function deleteDteFilesOnServer() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT']."/dte_files", '/') . "/";

                if (is_dir($destinationFolder)) {
                    $files = glob($destinationFolder."*.*");
                    
                    foreach($files as $file) {
                        unlink($file);
                    }
                }
            }
        }
    }
?>