<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Compras extends CI_Controller {
        
        function __construct() {
            parent::__construct();
        }
        
        function comprasLocales($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $tipopro = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'tipoprod' => $tipopro,
                    'tipo_producto_compra' => $tipopro
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('compras_model');
                $this->load->model('global_model');
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$idcentro = $this->session->userdata('idcentrouser');
                
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['descrip'] = $this->compras_model->getDescripTipoPro($tipopro);
                $this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['compras'] = $this->compras_model->getTiposCompras(($tipopro == 9) ? 'GA' : 'CO');
                $this->data['tiposProducto'] = $this->compras_model->getTiposDeProductos();
				$this->data['proveedores_ordenes'] = $this->compras_model->getListadopProveedoresOrdenes("CO", $tipopro, $idcentro);
                $this->data['periodos'] = $this->compras_model->getPeriodosCompras(1);
                $this->data['tipo_producto_compra'] = $tipopro;
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;
                
                $this->load->view('mantenimiento_compraslocales', $this->data); 
            }
        }

        function getListadoProveedoresGastos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $invclase = $this->input->post('invclase');

                $this->load->model('compras_model');
                $tipoAuxiliares = $this->compras_model->getTiposAuxiliaresGA($invclase);
                $informacion    = $this->compras_model->getListProveedores($tipoAuxiliares);
                
                $array = array();
                if ($informacion != false) {
                    foreach ($informacion as $info) {
                        $array[] = array(
                            'id' => $info->idauxi,
                            'descrip' => $info->descrip
                        );
                    }
                }

                echo json_encode($array);
            }
        }

        function validateTableDteExists(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('compras_model');
                $resposne = $this->compras_model->validateTableDteExists();
                return $resposne;
            }
        }
        
        function getListadoComprasLocales(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipopro  = $this->input->post('tipoproducto');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $estado   = $this->input->post('estado');
				$idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $datos = $this->compras_model->getListadoOrdenes(($tipopro == 9) ? 'GA' : 'CO', $tipopro, $idcentro, $fechaini, $fechafin, $estado);
                
                $i=0;
                $array = array();
                foreach($datos as $info){
                    $linea = 0; $canti = 0;
					
                    $gravado = number_format($info->valcosto , 2, ".", "");
                    $iva = number_format($info->valtax1+ $info->valtax2+ $info->valtax3+ $info->valtax4, 2, ".", "");
                    $subtotal = $info->valcosto + $info->valtax1+ $info->valtax2+ $info->valtax3+ $info->valtax4+ $info->valtax5;
                    $subtotal = number_format($subtotal , 2, ".", "");

                    if($info->valcosto == null || $info->valcosto == ""){
                        $valcosto = 0;
                    }else{
                        $valcosto = number_format($info->valcosto, 2, '.', '');
                    }
                    
                    if($info->fecha4 == "0000-00-00"){
                        $fechacierre  = "";
                    }else{
                        $fechacierre  = $info->fecha4;
                    }
                    
                    $informacion = $this->compras_model->getDetalleLineasCompraLocal($info->trannum, $info->estatus);
                    foreach($informacion as $cmp){
                        $linea++;
                        $canti+= $cmp->cantidad;
                    }
                    
                    $array[$i] = array(
						"trannum" => $info->trannum,
                        "fecha" => $info->fecha3,
                        "fecact" => $fechacierre,
                        "estatus" => $info->estatus,
                        "documento" => $info->documento,
                        "descrip" => $info->descrip,
                        "nrc" => $info->nrc,
                        "serie" => $info->serie.''.$info->numero,
                        "referencia" => $info->referencia,
                        "gravado" => $gravado,
                        "iva" => $iva,
                        "retper" => number_format($info->valtax5, 2, '.', ''),
                        "subtotal" => $subtotal,
                        "valventa" => $valcosto,
						"notas" => $info->notas,
                        "lineaunidad" => $linea.'/'.number_format($canti),
                        "username" => $info->username,
                        "numeroControl" => (isset($info->ncontrol)) ? $info->ncontrol : '',
                        "codidoGeneracion" => (isset($info->cgeneracion)) ? $info->cgeneracion : '',
                        "selloRecepcion" => (isset($info->srecepcion)) ? $info->srecepcion : '',
                    );
                    $i++;
                }
                    
                echo json_encode($array);
            }
        }
        
        function getDetalleCompraLocal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
                $estado = $this->input->post("estado");
                $this->load->model('compras_model');
                $j=0;
                $detail = array();
                $linea = 0;
                $canti = 0;
                $informacion = $this->compras_model->getDetalleByEstatusCompraLocal($trannum, $estado);
                foreach($informacion as $cmp){
                    $subtotal = $cmp->cantidad * $cmp->preciotran;
                    $preciotran = $cmp->preciotran * 1;
                    $detail[$j] = array(
                        "trannum" => $trannum,
                        "itemline" => $cmp->itemline,
                        "idproducto" => $cmp->idproducto,
                        "modelo" => $cmp->modelo,
                        "descrip" => $cmp->descrip,
                        "um" => $cmp->um,
                        "ubicacion" => $cmp->ubicacion,
                        "lote" => $cmp->lote,
                        "cantidad" => $cmp->cantidad,
                        "preciotran" => $preciotran,
                        "subtotal" => $subtotal
                    );
                    $j++;
                }
                echo json_encode($detail);
            }
        }
        
		function getPendientesImpresionCompras(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipopro = $this->input->post('tipoproducto');
                $idcentro = $this->session->userdata('idcentrouser');
                $estado = 0;
				
                $this->load->model('compras_model');
                $datos = $this->compras_model->getListadoImpresionOrdenes('CO', $estado, $tipopro, $idcentro);
                
                $i=0;
                $items = array();
                foreach($datos as $info){
					$items[$i] = array(
						"trannum" => $info->trannum,
                        "nameproveedor" => $info->descrip,
                        "numero" => $info->serie.''.$info->numero,
                    );
                    $i++;
                }
                
				if($i == 0){
					$i = "0";
				}
				
				$array = array(
					"cantidad" => $i,
					"datos" => $items
				);
                echo json_encode($array);
            }
        }
        
        function nuevacompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('compras_model');
                $this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['compras'] = $this->compras_model->getTiposCompras("CO");
                $this->data['periodos'] = $this->compras_model->getPeriodosCompras(1);
                $this->load->view('new_compralocal', $this->data); 
            }
        }
        
        function adicionarCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipoT = $this->input->post("tipoproT");
                $idproveedor = $this->input->post('idproveedor');
                $idtipo = $this->input->post('idtipo');
                $fecha = $this->input->post('fecha');
                $idperiodo = $this->input->post('idperiodo');
                $idsolicita = $this->input->post('idsolicita');
                $notas = trim($this->input->post('notas'));
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->adicionarCompralocal($idproveedor, $idtipo, $fecha, $idperiodo, $idsolicita, $notas, $idcentro, $tipoT);
                echo json_encode($array);
            }
        }
        
        /* SE MODIFICO FORMATO DE COMPRA LOCAL
        function detallecompragrid($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                //$tipopro = $this->session->userdata('tipoprod');
                $tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $this->load->model('producto_model');
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['compras'] = $this->compras_model->getTiposCompras("CO");
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['periodos'] = $this->compras_model->getPeriodosCompras(1);
                $this->data['cantidades'] = $this->compras_model->getCantidadesTran100kt($trannum);
                $this->data['unidades'] = $this->compras_model->getUnidadesTran100kt($trannum);
                $this->data['grupos'] = $this->compras_model->getGruposTipopro($idcentro, $tipopro);
                $this->data['tipo_pro'] = $tipopro;
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipopro);
                $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipopro);
                $this->data['medidas'] = $this->producto_model->verUM();
                $informacion = $this->compras_model->getInformacionOrden($trannum);
                $this->data['informacion'] = $informacion;
                
                foreach($informacion as $key){
                    $this->data['estatus'] = $key->estatus;
                }
                
                if($key->estatus == 0){
                    $this->data['productos'] = $this->compras_model->getProductosTempOrden($trannum); 
                }else{
                    $this->data['productos'] = $this->compras_model->getProductosOrden($trannum);   
                }
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $permite_adicionar = $this->variable_model->getTextVar('po_addprod');
                
                if($permite_adicionar!=false){
                    $this->data['permite_add'] = 1;
                }else{
                    $this->data['permite_add'] = 0;
                }
                
                $compraLotes = $this->variable_model->getTextVar('po_lotes');
                if($compraLotes != false){
                    $compra_Lotes = array(
                        "compraLote" => $compraLotes['valor_num']
                    );
                    $this->session->set_userdata($compra_Lotes);
                }else{
                    $compra_Lotes = array(
                        "compraLote" => 0
                    );
                    $this->session->set_userdata($compra_Lotes);
                }
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detalle_compra', $this->data); 
            }
        }
        */
        
        function detallecompra_ant($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $this->load->model('producto_model');
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['compras'] = $this->compras_model->getTiposCompras("CO");
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['periodos'] = $this->compras_model->getPeriodosCompras(1);
                $this->data['cantidades'] = $this->compras_model->getCantidadesTran100kt($trannum);
                $this->data['unidades'] = $this->compras_model->getUnidadesTran100kt($trannum);
                $this->data['grupos'] = $this->compras_model->getGruposTipopro($idcentro, $tipopro);
                $this->data['exenta_compra'] = $this->compras_model->getExentaCompra($trannum);
                $this->data['tipo_pro'] = $tipopro;
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipopro);
                $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipopro);
                $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
                $this->data['medidas'] = $this->producto_model->verUM();
                $informacion = $this->compras_model->getInformacionOrden($trannum);
                $this->data['informacion'] = $informacion;
                
                foreach($informacion as $key){
                    $this->data['estatus'] = $key->estatus;
                }
                
                if($key->estatus == 0){
                    $this->data['productos'] = $this->compras_model->getProductosTempOrden($trannum); 
                }else{
                    $this->data['productos'] = $this->compras_model->getProductosOrden($trannum);   
                }
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $permite_adicionar = $this->variable_model->getTextVar('po_addprod');
                
                if($permite_adicionar!=false){
                    $this->data['permite_add'] = 1;
                }else{
                    $this->data['permite_add'] = 0;
                }
                
                $compraLotes = $this->variable_model->getTextVar('po_lotes');
                if($compraLotes != false){
                    $compra_Lotes = array(
                        "compraLote" => $compraLotes['valor_num']
                    );
                    $this->session->set_userdata($compra_Lotes);
                }else{
                    $compra_Lotes = array(
                        "compraLote" => 0
                    );
                    $this->session->set_userdata($compra_Lotes);
                }
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detalle_compra_grid', $this->data); 
            }
        }

        function detallecompra($trannum, $tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum,
                    'tipo_producto_compra' => $tipopro
                );
                $this->session->set_userdata($resultAppName);
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('producto_model');
                $this->load->model('compras_model'); $this->load->model('invtran_model');
                $this->load->model('global_model'); $this->load->model('variable_model');
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['compras'] = $this->compras_model->getTiposCompras("CO");
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['periodos'] = $this->compras_model->getPeriodosCompras(1);
                $this->data['cantidades'] = $this->compras_model->getCantidadesTran100kt($trannum);
                $this->data['unidades'] = $this->compras_model->getUnidadesTran100kt($trannum);
                $this->data['grupos'] = $this->compras_model->getGruposTipopro($idcentro, $tipopro);
                $this->data['exenta_compra'] = $this->compras_model->getExentaCompra($trannum);
                $this->data['tipo_pro'] = $tipopro;
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipopro);
                $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipopro);
                $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
                $this->data['medidas'] = $this->producto_model->verUM();
                $this->data['po_retaceos'] = $this->global_model->getValorNumVariable('po_retaceos');
                $this->data['po_series']   = $this->global_model->getValorNumVariable('po_series');
                $this->data['po_lotescp']  = $this->global_model->getValorNumVariable('po_lotescp');
                $informacion = $this->compras_model->getInformacionOrden($trannum);
                $this->data['informacion'] = $informacion;
                
                foreach($informacion as $key){
                    $this->data['estatus'] = $key->estatus;
                    $idclase = $key->idclase;
                }

                $tipoAuxiliares = $this->compras_model->getTiposAuxiliaresGA($idclase);

                $this->data['proveedores'] = ($tipopro == 9) ? $this->compras_model->getListProveedores($tipoAuxiliares) : $this->compras_model->getListProveedores(1);
                
                if($key->estatus == 0){
                    $this->data['productos'] = $this->compras_model->getProductosTempOrden($trannum); 
                }else{
                    $this->data['productos'] = $this->compras_model->getProductosOrden($trannum);   
                }
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                $permite_adicionar = $this->variable_model->getTextVar('po_addprod');
                
                if($permite_adicionar!=false){
                    $this->data['permite_add'] = 1;
                }else{
                    $this->data['permite_add'] = 0;
                }
                
                $compraLotes = $this->variable_model->getTextVar('po_lotes');
                if($compraLotes != false){
                    $compra_Lotes = array(
                        "compraLote" => $compraLotes['valor_num']
                    );
                    $this->session->set_userdata($compra_Lotes);
                }else{
                    $compra_Lotes = array(
                        "compraLote" => 0
                    );
                    $this->session->set_userdata($compra_Lotes);
                }
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }else{
                    $array = array(
                        "gv_prodsearch" => 1,
                        "gv_prodtext" => "Código Interno"
                    );
                }
                
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detalle_compra_grid_2', $this->data); 
            }
        }

        function getListadoMenuGastos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipoGasto = $this->input->post('tipoGasto');

                $this->load->model('compras_model');
                $informacion = $this->compras_model->getListadoMenuGastos($tipoGasto);

                $i=0;
                $array = array();
                foreach($informacion as $info){
					$array[$i] = array(
						"id" => number_format($info->valor_num),
						"descrip" => $info->descripcion
					);
                    $i++;
                }

                echo json_encode($array);
            }
        }

        function getInformacionGastosExternosInternos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipoGasto = $this->input->post('tipoGasto');
                $trannum = $this->input->post('trannum');

                $this->load->model('compras_model');
                $informacion = $this->compras_model->getInformacionGastosExternosInternos($trannum, $tipoGasto);
                
                $i=0; $totalGastos = 0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "idrec" => $info->idrec,
                            "trannum" => $info->trannum,
                            "itemline" => $info->itemline,
                            "tipogasto" => $info->tipogasto,
                            "idgasto" => $info->idgasto,
                            "fecha" => $info->fecha,
                            "idprovee" => $info->idprovee,
                            "descrip" => $info->descrip,
                            "nameGasto" => $info->nameGasto,
                            "valgra" => number_format($info->valgra, 4, '.', ''),
                            "valexe" => number_format($info->valexe, 4, '.', ''),
                            "valrp" => number_format($info->valrp, 4, '.', ''),
                            "valiva" => number_format($info->valiva, 4, '.', ''),
                            "totalGasto" => $info->valgra + $info->valexe,
                            "totalGastoGeneral" => $info->valgra + $info->valexe + $info->valrp + $info->valiva,
                            "referencia" => $info->referencia,
                            "aplicagasto" => $info->aplicagasto,
                            "notas" => $info->notas
                        );
                        $i++;

                        $totalGastos = $totalGastos + ($info->valgra + $info->valexe);
                    }
                }

                $array = array(
                    "data" => $dataSource,
                    "totalGastos" => $totalGastos
                );

                echo json_encode($array);
            }
        }

        function adicionarGastoCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipoGasto = $this->input->post('tipoGasto');
                $idgasto = $this->input->post('idgasto');
                $proveedor = $this->input->post('proveedor');
                $trannum = $this->input->post('trannum');
                $fecha = $this->input->post('fecha');
                $documento = $this->input->post('documento');
                $descrip = $this->input->post('descrip');
                $notas = trim($this->input->post('notas'));
                $gravado = $this->input->post('gravado');
                $exento = $this->input->post('exento');
                $retencion = $this->input->post('retencion');
                $iva = $this->input->post('iva');

                $this->load->model('compras_model');
                $this->compras_model->adicionarGastoCompra($tipoGasto, $idgasto, $proveedor, $trannum, $fecha, $documento, $descrip, $notas, $gravado, $exento, $retencion, $iva);
                $informacion = $this->compras_model->getInformacionGastosExternosInternos($trannum, $tipoGasto);
                
                $i=0; $totalGastos=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "idrec" => $info->idrec,
                            "trannum" => $info->trannum,
                            "itemline" => $info->itemline,
                            "tipogasto" => $info->tipogasto,
                            "idgasto" => $info->idgasto,
                            "fecha" => $info->fecha,
                            "idprovee" => $info->idprovee,
                            "descrip" => $info->descrip,
                            "nameGasto" => $info->nameGasto,
                            "valgra" => number_format($info->valgra, 4, '.', ''),
                            "valexe" => number_format($info->valexe, 4, '.', ''),
                            "valrp" => number_format($info->valrp, 4, '.', ''),
                            "valiva" => number_format($info->valiva, 4, '.', ''),
                            "totalGasto" => $info->valgra + $info->valexe,
                            "totalGastoGeneral" => $info->valgra + $info->valexe + $info->valrp + $info->valiva,
                            "referencia" => $info->referencia,
                            "aplicagasto" => $info->aplicagasto,
                            "notas" => $info->notas
                        );
                        $i++;

                        $totalGastos = $totalGastos + ($info->valgra + $info->valexe);
                    }
                }

                $array = array(
                    "data" => $dataSource,
                    "totalGastos" => $totalGastos
                );

                echo json_encode($array);
            }
        }

        function modificarGastoCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipoGasto = $this->input->post('tipoGasto');
                $trannum = $this->input->post('trannum');
                $idrec = $this->input->post('idrec');
                $fecha = $this->input->post('fecha');
                $documento = $this->input->post('documento');
                $descrip = $this->input->post('descrip');
                $notas = trim($this->input->post('notas'));
                $gravado = $this->input->post('gravado');
                $exento = $this->input->post('exento');
                $retencion = $this->input->post('retencion');
                $iva = $this->input->post('iva');

                $this->load->model('compras_model');
                $this->compras_model->modificarGastoCompra($idrec, $fecha, $documento, $descrip, $notas, $gravado, $exento, $retencion, $iva);
                $informacion = $this->compras_model->getInformacionGastosExternosInternos($trannum, $tipoGasto);
                
                $i=0; $totalGastos=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "idrec" => $info->idrec,
                            "trannum" => $info->trannum,
                            "itemline" => $info->itemline,
                            "tipogasto" => $info->tipogasto,
                            "idgasto" => $info->idgasto,
                            "fecha" => $info->fecha,
                            "idprovee" => $info->idprovee,
                            "descrip" => $info->descrip,
                            "nameGasto" => $info->nameGasto,
                            "valgra" => number_format($info->valgra, 4, '.', ''),
                            "valexe" => number_format($info->valexe, 4, '.', ''),
                            "valrp" => number_format($info->valrp, 4, '.', ''),
                            "valiva" => number_format($info->valiva, 4, '.', ''),
                            "totalGasto" => $info->valgra + $info->valexe,
                            "totalGastoGeneral" => $info->valgra + $info->valexe + $info->valrp + $info->valiva,
                            "referencia" => $info->referencia,
                            "aplicagasto" => $info->aplicagasto,
                            "notas" => $info->notas
                        );
                        $i++;

                        $totalGastos = $totalGastos + ($info->valgra + $info->valexe);
                    }
                }

                $array = array(
                    "data" => $dataSource,
                    "totalGastos" => $totalGastos
                );

                echo json_encode($array);
            }
        }

        function eliminarGastoCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipoGasto = $this->input->post('tipoGasto');
                $trannum = $this->input->post('trannum');
                $idrec = $this->input->post('idrec');

                $this->load->model('compras_model');
                $this->compras_model->eliminarGastoCompra($idrec);
                $informacion = $this->compras_model->getInformacionGastosExternosInternos($trannum, $tipoGasto);
                
                $i=0; $totalGastos=0;
                $dataSource = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $dataSource[$i] = array(
                            "idrec" => $info->idrec,
                            "trannum" => $info->trannum,
                            "itemline" => $info->itemline,
                            "tipogasto" => $info->tipogasto,
                            "idgasto" => $info->idgasto,
                            "fecha" => $info->fecha,
                            "idprovee" => $info->idprovee,
                            "descrip" => $info->descrip,
                            "nameGasto" => $info->nameGasto,
                            "valgra" => number_format($info->valgra, 4, '.', ''),
                            "valexe" => number_format($info->valexe, 4, '.', ''),
                            "valrp" => number_format($info->valrp, 4, '.', ''),
                            "valiva" => number_format($info->valiva, 4, '.', ''),
                            "totalGasto" => $info->valgra + $info->valexe,
                            "totalGastoGeneral" => $info->valgra + $info->valexe + $info->valrp + $info->valiva,
                            "referencia" => $info->referencia,
                            "aplicagasto" => $info->aplicagasto,
                            "notas" => $info->notas
                        );
                        $i++;

                        $totalGastos = $totalGastos + ($info->valgra + $info->valexe);
                    }
                }

                $array = array(
                    "data" => $dataSource,
                    "totalGastos" => $totalGastos
                );

                echo json_encode($array);
            }
        }
		        
		function getListadoLineasCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
				//$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                //$this->uri->segment(4);
                $tipopro = $this->input->post("tipopro");
                
				$this->load->model('compras_model'); 
				$lineas = $this->compras_model->getGroupsProductosCompra($trannum, $tipopro);
				$cantid = $this->compras_model->getSumProductosCompra($trannum, $tipopro);
				
				$i=0;
				$array = array();
				
				foreach($lineas as $data){
					foreach($cantid as $cant){
						if($data->idcatalogo == $cant->idcatalogo){
							$array[$i] = array(
								"idcatalogo" => $data->idcatalogo,
								"imagen" => trim($data->imagen),
								"descrip" => mb_strtoupper(trim($data->descrip), 'UTF-8').' - '.mb_strtoupper(trim($data->departamento), 'UTF-8'),
								"total" => $cant->total
							);
						}		
					}
					$i++;
				}
				
                echo json_encode($array);
            }
		}
        
        #FuncionACopiar
        function getInventarioByCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum  = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro   = $this->session->userdata('idcentrouser');
                $tipopro    = $this->input->post("tipopro");
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                
                $this->load->model('compras_model');
                $useLote   = $this->compras_model->getLoteProdCatalogo($idcatalogo);
                $detalle    = $this->compras_model->getInventarioByCatalog($idtrannum,$idcatalogo,$idcentro, $tipopro);
                $cantidades = $this->compras_model->getCantidadesCatalogo($idtrannum, $idcentro, $tipopro);
				
                $i=0;
                $datos = array();
                foreach($detalle as $info){
					$datos[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"um" => $info->um,
						"xpos" => $info->xpos,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"presenta" => $info->presenta,
						"tipotax" => $info->tipotax,
						"precio" => $info->costounitario,
						"precioventa" => $info->precioventa,
						"costouni" => $info->costouni
					);
					$i++;
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i,
                    "sumagrupos" => $cantidades,
                    "useLote" => $useLote
                );

                echo json_encode($array);
            }
        }
        
        function getDatosCompraTran100kt(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('compras_model');
                $array = $this->compras_model->getDataTran100kt($idtrannum, $idcentro);

                echo json_encode($array);
            }
        }
        
        function getTotalSumatoriaPrecioneto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->getTotalSumatoriaPrecioneto($trannum);

                echo json_encode($array);
            }
        }
        
        function proratearCostosProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $valorFactor = $this->input->post('valorFactor');
                $valorGasto = $this->input->post('valorGasto');
                $idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('compras_model');
                $this->compras_model->proratearCostosProductos($trannum, $valorFactor, $valorGasto);
                $array = $this->compras_model->getDataTran100kt($trannum, $idcentro);
                
                echo json_encode($array);
            }
        }
        
        function revertirProrateoCostosProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('compras_model');
                $this->compras_model->revertirProrateoCostosProductos($trannum);
                $array = $this->compras_model->getDataTran100kt($trannum, $idcentro);
                
                echo json_encode($array);
            }
        }
        
        function getDatosCompraTran100ktEti(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('compras_model');
                $array = $this->compras_model->getDatosCompraTran100ktEti($idtrannum, $idcentro);

                echo json_encode($array);
            }
        }
		
		function getDatosCompraTran100kt_cant(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $cantidad = $this->input->post('cantidad');
                $idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('compras_model');
                $array = $this->compras_model->getDataTran100ktcant($idtrannum, $idcentro,$cantidad);

                echo json_encode($array);
            }
        }
        
        function getLastPrecioCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $array = $this->compras_model->getUltimoPrecioVenta($idproducto, $idcentro);

                echo json_encode($array);
            }
        }
        
        function getLastPrecioFechaCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $idcentro   = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $array = $this->compras_model->getUltimoPrecioFechaVenta($idproducto, $idcentro);

                echo json_encode($array);
            }
        }
        
        function getLastPrecioCompraUM(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $um = $this->input->post('um');
                $idproducto = $this->input->post('idproducto');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $array = $this->compras_model->getUltimoPrecioVentaUM($idproducto, $um, $idcentro);

                echo json_encode($array);
            }
        }
		
		function getUnidadesDeCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');

                $this->load->model('compras_model');
                $informacion = $this->compras_model->getUnidadDeCompraProducto($idproducto);
                $unidades = $this->compras_model->getUnidadesDeCompra($idproducto, 7);
				
				$i=0;
				$array = array();
				
				foreach($informacion as $info){
					$array[$i] = array(
						"id" => "1.000000",
						"descrip" => $info->um
					);
					$i++;
				}
				
				foreach($unidades as $uni){
					$array[$i] = array(
						"id" => "$uni->uniconv",
						"descrip" => $uni->descrip
					);
					$i++;
				}
				
                echo json_encode($array);
            }
		}
        
        #FuncionACopiar
        function insertTran100kt(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r","\"", "'");
                $reemplazar = array("", "", "", "","","");

                $um         = $this->input->post('um');
                $notas      = trim($this->input->post('notas'));
                $notas      = str_replace($buscar, $reemplazar, $notas);

                $precio     = $this->input->post('precio');
                $tipopro    = $this->input->post("tipopro");
                $tipotax    = $this->input->post('tipotax');
                $uniconv    = $this->input->post('uniconv');
                $cantidad   = $this->input->post('cantidad');
                $idcentro   = $this->session->userdata('idcentrouser');
                $idtrannum  = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idproducto = $this->input->post('idproducto');
                $lote       = $this->input->post('lote');
                $fechacp    = $this->input->post('fechacp');
                
                $this->load->model('compras_model');
                $insert = $this->compras_model->insertProTran100kt($idtrannum, $idproducto, $cantidad, $um, $uniconv, $precio, $tipotax, $notas, $lote, $fechacp);
                
                $datos    = $this->compras_model->getDataTran100kt($idtrannum, $idcentro);
                $detalle  = $this->compras_model->getInventarioByCatalog($idtrannum, $idcatalogo, $idcentro, $tipopro);
                $cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);

                $i=0;
                $items = array();
                foreach($detalle as $info){
                    $items[$i] = array(
                        'um'           => $info->um,
                        'upc'          => $info->barcode,
                        'xpos'         => $info->xpos,
                        'marca'        => $info->marca,
                        'notas'        => $info->notas,
                        'modelo'       => $info->modelo,
                        'imagen'       => $info->imagen,
                        'precio'       => $info->costounitario,
                        'tipotax'      => $info->tipotax,
                        'cantidad'     => $info->cantidad,
                        'presenta'     => $info->presenta,
                        'costouni'     => $info->costouni,
                        'idproducto'   => $info->idproducto,
                        'precioventa'  => $info->precioventa,
                        'nameproducto' => $info->descrip
                    );
                    $i++;
                }
                
                $array = array(
                    'items'    => $items,
                    'datos'    => $datos,
                    'count'    => $i,
                    'insert'   => $insert,
                    'cantidad' => $cantidad,
                    'unidades' => number_format($unidades)
                );
                
                echo json_encode($array);
            }
        }
                        
        function deleteRegistro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post("tipopro");
                
                $this->load->model('compras_model');
                $this->compras_model->deleteDataTran100kt($idrec);
                
                $detalle = $this->compras_model->getInventarioByCatalog($idtrannum, $idcatalogo, $idcentro, $tipopro);
                $datos = $this->compras_model->getDataTran100kt($idtrannum, $idcentro);
                $cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    //validacion duplicidad
					//if($info->existe == "0"){
                        // $items[$i] = array(
                        //     "nameproducto" => $info->descrip,
                        //     "marca" => $info->marca,
                        //     "modelo" => $info->modelo,
                        //     "upc" => $info->barcode,
                        //     "notas" => $info->notas,
                        //     "idproducto" => $info->idproducto,
                        //     "um" => $info->um,
                        //     "imagen" => $info->imagen,
                        //     "cantidad" => $info->cantidad,
                        //     "tipotax" => $info->tipotax,
                        //     "precio" => $info->costounitario
                        // );
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "presenta" => $info->presenta,
                            "precioventa" => $info->precioventa,
                            "precio" => $info->costounitario,
                            "costouni" => $info->costouni
                        );
                        $i++;
                    //}
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades),
                    "count" => $i
                );
                                
                echo json_encode($array);
            }
        }
                        
        function deleteRegistroDevolucion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post('tipoprod');
                $trannumReferencia = $this->input->post('trannumReferencia');
                
                $this->load->model('compras_model');
                $this->compras_model->deleteDataTran100k($idrec);
                
                if($trannumReferencia == 0){
                    $detalle = $this->compras_model->getInventarioByCatalogoDevoluciones($trannum, $idcatalogo, $idcentro, $tipopro);
                }else{
                    $detalle = $this->compras_model->getListadoProductosByReferencia($trannum, $trannumReferencia, $tipopro, $idcentro);
                }
                
                if($trannumReferencia == 0){
                    $datos = $this->compras_model->getDatosDevolucionesSobreCompra($trannum, $idcentro);
                }else{
                    $datos = $this->compras_model->getDatosDevolucionesSobreCompraReferencia($trannum, $trannumReferencia, $idcentro);
                }
                
                $cantidad = $this->compras_model->getTotalCantidades($trannum);
                $unidades = $this->compras_model->getTotalUnidades($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precioventa" => $info->precioventa,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precio" => $info->costounitario,
                            "costouni" => $info->costouni
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades),
                    "count" => $i
                );
                                
                echo json_encode($array);
            }
        }
        
        #FuncionACopiar
        function updateTran100kt(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r","\"", "'");
                $reemplazar = array("", "", "", "","","");

                $idrec = $this->input->post('idrec');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post("tipopro");

                $cantidad = $this->input->post('cantidad');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');

                $notas = trim($this->input->post('notas'));
                $notas = str_replace($buscar, $reemplazar, $notas);

                $precio = $this->input->post('precio');
                $lote = $this->input->post('lote');
                $fechacp = $this->input->post('fechacp');
                
                $this->load->model('compras_model');
                $this->compras_model->updateProdTran100kt($idrec, $cantidad, $precio, $notas, $um, $uniconv, $lote, $fechacp);
                
                $detalle = $this->compras_model->getInventarioByCatalog($idtrannum, $idcatalogo, $idcentro, $tipopro);
                $datos = $this->compras_model->getDataTran100kt($idtrannum, $idcentro);
                $cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    //validacion duplicidad
					//if($info->existe == "0"){
                        // $items[$i] = array(
                        //     "nameproducto" => $info->descrip,
                        //     "marca" => $info->marca,
                        //     "modelo" => $info->modelo,
                        //     "upc" => $info->barcode,
                        //     "notas" => $info->notas,
                        //     "idproducto" => $info->idproducto,
                        //     "um" => $info->um,
                        //     "imagen" => $info->imagen,
                        //     "cantidad" => $info->cantidad,
                        //     "tipotax" => $info->tipotax,
                        //     "precioventa" => $info->precioventa,
                        //     "precio" => $info->costounitario
                        // );
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "presenta" => $info->presenta,
                            "precioventa" => $info->precioventa,
                            "precio" => $info->costounitario,
                            "costouni" => $info->costouni
                        );
                        $i++;
                    //}
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades),
                    "count" => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function getDatosSearch(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = number_format($this->input->post('prosearch'), 0);
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post("tipopro");
                
                $this->load->model('compras_model');
                $detalle = $this->compras_model->getDatosProductoSearch($prosearch, $dato, $idcentro, $trannum, $tipopro);
                if($detalle != 0){
                    $i=0;
                    $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
						$items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "namecatalogo" => $info->namecatalogo,
                            "presenta" => $info->presenta,
                            "precioventa" => number_format($info->precioventa,2,'.',''),
                            "precio" => $info->costounitario,
                            "xpos" => $info->xpos,
                            "costouni" => $info->costouni,
							"agregado" => 0,
                            "useLote" => $info->useLote
                        );
                        $i++;
                    }
                    if($agregado == 1 && $i == 1){
						$datos = $this->compras_model->getDataTran100ktProducto($trannum, $idcentro, $info->idproducto);
						$array = array(
                            "error" => "2",
							"datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
        }
		
		function getDatosSearchOrdenes(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');
                //$tipopro = $this->session->userdata('compras_tipopro');
                $tipopro = $this->input->post('tipopro');
                
                $this->load->model('compras_model');
                $detalle = $this->compras_model->getDatosProductoSearchOrdenes($prosearch, $dato, $idcentro, $trannum, $tipopro);
                if($detalle != 0){
                    $i=0;
                    $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
						//validacion duplicidad
                        if($info->existe == "0"){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "umorders" => $info->umorders,
                                "uniconv" => $info->uniconv,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "tipotax" => $info->tipotax,
                                "namecatalogo" => $info->namecatalogo,
                                "precio" => $info->costounitario,
                                "precioventa" => $info->precioventa,
                                "costouni" => $info->costouni,
                                "periodo" => $info->periodo,
								"agregado" => 0
                            );
                            $i++;
                        }else{
							$items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "umorders" => $info->umorders,
                                "uniconv" => $info->uniconv,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "tipotax" => $info->tipotax,
                                "namecatalogo" => $info->namecatalogo,
                                "precio" => $info->costounitario,
                                "precioventa" => $info->precioventa,
                                "costouni" => $info->costouni,
                                "periodo" => $info->periodo,
                                "agregado" => 1
                            );
                            $i++;
                            $agregado = 1;
                        }
                    }
                    if($agregado == 1 && $i == 1){
						$datos = $this->compras_model->getDataOrders100Producto($trannum, $idcentro, $info->idproducto);
						$array = array(
                            "error" => "2",
							"datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
		}
		
		function getProductAgregadoDetalle(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');
                $idproducto = $this->input->post('idproducto');
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
				
				$this->load->model('compras_model');
				$datos = $this->compras_model->getDataTran100ktProducto($trannum, $idcentro, $idproducto);
				$array = array(
					"datos" => $datos
				);
				
				echo json_encode($array);
			}
		}
        
        function getCantidadProdProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');
                $idtrannum = $this->input->post('idtrannum');
                $tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $array = $this->compras_model->getCantidadProProvee($idcps, $idtrannum, $idcentro, $tipopro);
                
                echo json_encode($array);
            }
        }
		
        function getMarcasProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');
                $idtrannum = $this->input->post('idtrannum');
                $tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $this->load->model('producto_model');
                $marcas = $this->producto_model->verMarca();
                $array = array(
                    "marcas" =>$marcas,
                );
                echo json_encode($array);
            }
        }
        
        function getProductosMarca(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $marca = $this->input->post('marca');
                $idtrannum = $this->input->post('idtrannum');
                $tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $datos = $this->compras_model->getProMarca($marca, $idtrannum, $idcentro, $tipopro);
                
                $j=0;
                $array_datos = array();
                
                if($datos != false){
                    foreach($datos as $dat){
                        if($dat->total>0){
                            $costo = $dat->costounitario;
                            if($dat->lastprecio>0){
                                $costo = $dat->lastprecio;
                            }
                            $array_datos[$j] = array(
                                "idproducto" => $dat->idproducto,
                                "descrip" => $dat->descrip,
                                "costounitario" => $costo,
                                "idcatalogo" => $dat->idcatalogo,
                                "linea" => $dat->linea,
                                "modelo" => $dat->modelo,
                                "cantidad" => "0",
                                "um" => $dat->um,
                                "precioventa" => $dat->precioventa,
                                "tipotax" => $dat->tipotax,
                            );
                            $j++;
                        }
                    }
                }
                echo json_encode($array_datos);
            }
        }
		
        function getProductosCatalogo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $idtrannum = $this->input->post('idtrannum');
                $tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $datos = $this->compras_model->getProDepto($idcatalogo, $idtrannum, $idcentro, $tipopro);
                $array_datos = array();
                $j=0;
                if($datos!=false){
                    foreach($datos as $dat){
                        if($dat->total>0){
                            $costo = $dat->costounitario;
                            if($dat->lastprecio>0){
                                $costo = $dat->lastprecio;
                            }
                            $array_datos[$j] = array(
                                "idproducto" => $dat->idproducto,
                                "descrip" => $dat->descrip,
                                "costounitario" => $costo,
                                "idcatalogo" => $dat->idcatalogo,
                                "linea" => $dat->linea,
                                "modelo" => $dat->modelo,
                                "cantidad" => "0",
                                "um" => $dat->um,
                                "precioventa" => $dat->precioventa,
                                "marca" => $dat->marca,
                                "tipotax" => $dat->tipotax,
                            );
                            $j++;
                        }
                    }
                }
                echo json_encode($array_datos);
            }
        }
        
		function getProductosProvee(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproveedor = $this->input->post('idproveedor');
                $idtrannum = $this->input->post('idtrannum');
                $tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $datos = $this->compras_model->getProProvee($idproveedor, $idtrannum, $idcentro, $tipopro);
                $array_datos = array();
                $j=0;
                if($datos!=false){
                    foreach($datos as $dat){
                        if($dat->total>0){
                            $costo = $dat->costounitario;
                            if($dat->lastprecio>0){
                                $costo = $dat->lastprecio;
                            }
                            $array_datos[$j] = array(
                                "idproducto" => $dat->idproducto,
                                "descrip" => $dat->descrip,
                                "costounitario" => $costo,
                                "idcatalogo" => $dat->idcatalogo,
                                "linea" => $dat->linea,
                                "modelo" => $dat->modelo,
                                "cantidad" => "0",
                                "um" => $dat->um,
                                "precioventa" => $dat->precioventa,
                                "marca" => $dat->marca,
                                "tipotax" => $dat->tipotax,
                            );
                            $j++;
                        }
                    }
                }
                echo json_encode($array_datos);
            }
        }
		
		function insertProductosProveedor(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcps = $this->input->post('idcps');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('compras_model');
                $this->compras_model->insertProductsProveedor($idtrannum, $idcps, $tipopro, $idcentro);
                
                $detalle = $this->compras_model->getInventarioByCatalog($idtrannum, $idcatalogo, $idcentro, $tipopro);
                $datos = $this->compras_model->getDataTran100kt($idtrannum, $idcentro);
                $cantidades = $this->compras_model->getCantidadesCatalogo($idtrannum, $idcentro, $tipopro);
                $cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);

                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "costouni" => $info->costouni
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades),
                    "count" => $i,
                    "sumagrupos" => $cantidades
                );
                
                echo json_encode($array);
			}
		}
		
		function eliminarCantidadesCero(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('compras_model');
                $this->compras_model->deleteCantidadesCero($idtrannum);
                
                $detalle = $this->compras_model->getInventarioByCatalog($idtrannum, $idcatalogo, $idcentro, $tipopro);
                $datos = $this->compras_model->getDataTran100kt($idtrannum, $idcentro);
                $cantidades = $this->compras_model->getCantidadesCatalogo($idtrannum, $idcentro, $tipopro);
                $cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);

                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades),
                    "count" => $i,
                    "sumagrupos" => $cantidades
                );
                
                echo json_encode($array);
			}
		}
		
		function anulacionCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('trannum');
				$this->load->model('compras_model');
                $array = $this->compras_model->anularCompraLocal($idtrannum);
				
				echo json_encode($array);
			}
		}
		
        function eliminarCompraLocal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				
                $this->load->model('compras_model');
                $array = $this->compras_model->eliminarCompraLocal($trannum);
				
				echo json_encode($array);
			}
		}
		
		function anulacionDevolucionCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
				$this->load->model('compras_model');
                $array = $this->compras_model->anulacionDevolucionCompra($trannum);
				
				echo json_encode($array);
			}
		}
		
		function getValidateCompraLocal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('trannum');
				$exenta = $this->input->post('exento');

				$this->load->model('compras_model');
				$cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                $provee_tipo = $this->compras_model->getTipoProveedorCompra($idtrannum);
				$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
				
				if($cantidad <= 0){
					$error = 1;
					$array = array(
						'error' => $error
					);
				}else{
					$result = $this->compras_model->getValidateCantidadCero($idtrannum);
					if($result > 0){
						$error = 2;
						$array = array(
							'error' => $error
						);
					}else{
                        $result2 = $this->compras_model->getValidatePreciotranCero($idtrannum);
                        if($result2 > 0){
                            $error = 3;
                            $array = array(
                                'error' => $error
                            );
                        }else{
                            $informacion = $this->compras_model->getProductosTran_100ktClose($idtrannum);						
                            $fecVence = $this->compras_model->getFechaPagoCompra();
                            
                            $valExentas = 0; $valGravadas = 0;
                            $valIVA = 0; $valTotal = 0;
                            
                            foreach($informacion as $info){
                                if($exenta == 1){
                                    $valExentas = $valExentas + ($info->cantidad * $info->preciotran);
                                    
                                    $porcentajeIVA = ($info->tax1 / 100);
                                }else{
                                    if($info->tax1 == 0){
                                        $valExentas = $valExentas + ($info->cantidad * $info->preciotran);
                                    }else{
                                        $valIVA = $valIVA + (($info->cantidad * $info->preciotran) * ($info->tax1 / 100));
                                        $valGravadas = $valGravadas + ($info->cantidad * $info->preciotran);
                                    }
                                }
                            }
                            
                            $valExentas = round($valExentas, 6);
                            $valGravadas = round($valGravadas, 6);
                            //$valIVA = $valGravadas * $porcentajeIVA;
                            $valIVA = round($valIVA, 6);
                            
                            $valTotal = $valExentas + $valGravadas + $valIVA;
                            $percepcion = 0; $retencion = 0;

                            if($empper == 1){
                                if($provee_tipo != 3){
                                    if($valGravadas >= 100){
                                            $retencion = number_format($valGravadas, 6, '.', '') * 0.01;
                                            $valTotal = number_format($valTotal, 6, '.', '') - number_format($retencion, 6, '.', '');
                                    }else{
                                        $valTotal = number_format($valTotal, 6, '.', '');
                                    }
                                }else{
                                    $valTotal = number_format($valTotal, 6, '.', '');
                                }
                            }else{
                                if($provee_tipo == 3){
                                    if($valGravadas >= 100){
                                            $percepcion = number_format($valGravadas, 6, '.', '') * 0.01;
                                            $valTotal = number_format($valTotal, 6, '.', '') + number_format($percepcion, 6, '.', '');
                                    }else{
                                        $valTotal = number_format($valTotal, 6, '.', '');
                                    }
                                }else{
                                    $valTotal = number_format($valTotal, 6, '.', '');
                                }
                            }
                            
                            $valTotal = round($valTotal, 6);

                            $error = 4;
                            $array = array(
                                'error' => $error,
                                'valExentas' => number_format($valExentas, 4, '.', ','),
                                'valGravadas' => number_format($valGravadas, 4, '.', ','),
                                'valIVA' => number_format($valIVA, 4, '.', ','),
                                'valTotal' => number_format($valTotal, 2, '.', ','),
                                'fecvence' => $fecVence,
                                'retencion' => $retencion,
                                'percepcion' => $percepcion
                            );
                        }
					}
				}
				
				echo json_encode($array);
			}
		}
		
		function getTotalesCompraLocal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('trannum');
				
				$this->load->model('compras_model');
				$cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                $provee_tipo = $this->compras_model->getTipoProveedorCompra($idtrannum);
				$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
				
				if($cantidad <= 0){
					$error = 1;
					$array = array(
						'error' => $error
					);
				}else{
					$result = $this->compras_model->getValidateCantidadCero($idtrannum);
					if($result > 0){
						$error = 2;
						$array = array(
							'error' => $error
						);
					}else{
                        $result2 = $this->compras_model->getValidatePreciotranCero($idtrannum);
                        if($result2 > 0){
                            $error = 3;
                            $array = array(
                                'error' => $error
                            );
                        }else{
                            $informacion = $this->compras_model->getProductosTran_100ktClose($idtrannum);						
                            //$valorGastos = $this->compras_model->getValorGastos($idtrannum);
                            
                            $valExentas = 0; $valGravadas = 0;
                            $valIVA = 0; $valTotal = 0;

                            foreach($informacion as $info){
                                if($info->tax5 == 0){
                                    if($info->tax1 == 0){
                                        $valExentas = $valExentas + ($info->cantidad * $info->preciotran);
                                    }else{
                                        $sinIva = $info->preciotran * ($info->tax1 / 100);
                                        $valIVA = $valIVA + ($info->cantidad * ($sinIva));

                                        $valGravadas = $valGravadas + ($info->cantidad * $info->preciotran);
                                    }
                                }else{
                                    if($info->tax1 == 0){
                                        $valExentas = $valExentas + ($info->cantidad * $info->tax5);
                                    }else{
                                        $sinIva = $info->tax5 * ($info->tax1 / 100);
                                        $valIVA = $valIVA + ($info->cantidad * ($sinIva));

                                        $valGravadas = $valGravadas + ($info->cantidad * $info->tax5);
                                    }
                                }
                            }

                            $valTotal = $valExentas + $valGravadas + $valIVA;
                            $percepcion = 0; $retencion = 0;

                            if($empper == 1){
                                if($provee_tipo != 3){
                                    if($valGravadas >= 100){
                                            $retencion = number_format($valGravadas, 2, '.', '') * 0.01;
                                            $valTotal = number_format($valTotal, 2, '.', '') - number_format($retencion, 2, '.', '');
                                    }else{
                                        $valTotal = number_format($valTotal, 2, '.', '');
                                    }
                                }else{
                                    $valTotal = number_format($valTotal, 2, '.', '');
                                }
                            }else{
                                if($provee_tipo == 3){
                                    if($valGravadas >= 100){
                                            $percepcion = number_format($valGravadas, 2, '.', '') * 0.01;
                                            $valTotal = number_format($valTotal, 2, '.', '') + number_format($percepcion, 2, '.', '');
                                    }else{
                                        $valTotal = number_format($valTotal, 2, '.', '');
                                    }
                                }else{
                                    $valTotal = number_format($valTotal, 2, '.', '');
                                }
                            }

                            $error = 4;
                            $array = array(
                                'error' => $error,
                                'valExentas' => number_format($valExentas, 4, '.', ''),
                                'valGravadas' => number_format($valGravadas, 4, '.', ''),
                                'valIVA' => number_format($valIVA, 4, '.', ''),
                                'valTotal' => number_format($valTotal, 2, '.', ''),
                                //'valorGastos' => number_format($valorGastos, 2, '.', ''),
                                'retencion' => $retencion,
                                'percepcion' => $percepcion
                            );
                        }
					}
				}
				
				echo json_encode($array);
			}
        }
        
        function getTotalesCompraRetaceo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('trannum');
				
				$this->load->model('compras_model');
				$provee_tipo = $this->compras_model->getTipoProveedorCompra($idtrannum);
				$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
                
                $informacion = $this->compras_model->getProductosTran_100ktClose($idtrannum);						
                // $valorGastos = $this->compras_model->getValorGastos($idtrannum);
                $valorGastos = $this->compras_model->getValorGastosGravados($idtrannum);
                

                $valExentas = 0; $valGravadas = 0;
                $valIVA = 0; $valTotal = 0;
                foreach($informacion as $info){
                    if($info->tax5 == 0){
                        if($info->tax1 == 0){
                            $valExentas = $valExentas + ($info->cantidad * $info->preciotran);
                        }else{
                            $sinIva = $info->preciotran * ($info->tax1 / 100);
                            $valIVA = $valIVA + ($info->cantidad * ($sinIva));

                            $valGravadas = $valGravadas + ($info->cantidad * $info->preciotran);
                        }
                    }else{
                        if($info->tax1 == 0){
                            $valExentas = $valExentas + ($info->cantidad * $info->tax5);
                        }else{
                            $sinIva = $info->tax5 * ($info->tax1 / 100);
                            $valIVA = $valIVA + ($info->cantidad * ($sinIva));

                            $valGravadas = $valGravadas + ($info->cantidad * $info->tax5);
                        }
                    }
                }

                $valTotal = $valExentas + $valGravadas + $valIVA;
                $percepcion = 0; $retencion = 0;

                if($empper == 1){
                    if($provee_tipo != 3){
                        if($valGravadas >= 100){
                                $retencion = number_format($valGravadas, 2, '.', '') * 0.01;
                                $valTotal = number_format($valTotal, 2, '.', '') - number_format($retencion, 2, '.', '');
                        }else{
                            $valTotal = number_format($valTotal, 2, '.', '');
                        }
                    }else{
                        $valTotal = number_format($valTotal, 2, '.', '');
                    }
                }else{
                    if($provee_tipo == 3){
                        if($valGravadas >= 100){
                                $percepcion = number_format($valGravadas, 2, '.', '') * 0.01;
                                $valTotal = number_format($valTotal, 2, '.', '') + number_format($percepcion, 2, '.', '');
                        }else{
                            $valTotal = number_format($valTotal, 2, '.', '');
                        }
                    }else{
                        $valTotal = number_format($valTotal, 2, '.', '');
                    }
                }

                $array = array(
                    'valExentas' => number_format($valExentas, 4, '.', ''),
                    'valGravadas' => number_format($valGravadas, 4, '.', ''),
                    'valIVA' => number_format($valIVA, 4, '.', ''),
                    'valTotal' => number_format($valTotal, 2, '.', ''),
                    'valorGastos' => number_format($valorGastos, 2, '.', ''),
                    'retencion' => $retencion,
                    'percepcion' => $percepcion
                );
				
				echo json_encode($array);
			}
        }

        function getValorGastosIngresados() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('compras_model');
                echo json_encode($this->compras_model->getValorGastosIngresados($trannum));
            }
        }
		
		function getInformacionTotalesCompraLocal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('trannum');
                $exenta = $this->input->post('exento');
				
				$this->load->model('compras_model');
                $provee_tipo  = $this->compras_model->getTipoProveedorCompra($idtrannum);
                //$numreteperce = '';
				$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
                
                $informacion = $this->compras_model->getProductosTran_100ktClose($idtrannum);
                $fecvence = $this->compras_model->getFechaPagoCompra();
                
                $valExentas = 0; $valGravadas = 0;
                $valIVA = 0; $valTotal = 0;
                
                foreach($informacion as $info){
                    if($exenta == 1){
                        $valExentas = $valExentas + ($info->cantidad * $info->preciotran);
                    }else{
                        if($info->tax1 == 0){
                            $valExentas = $valExentas + ($info->cantidad * $info->preciotran);
                        }else{
                            $sinIva = $info->preciotran * ($info->tax1 / 100);
                            $valIVA = $valIVA + ($info->cantidad * ($sinIva));
                            
                            $valGravadas = $valGravadas + ($info->cantidad * $info->preciotran);
                        }
                    }
                }
                
                $valTotal = $valExentas + $valGravadas + $valIVA;
                $percepcion = 0; $retencion = 0;
                
                if($empper == 1){
                    if($provee_tipo != 3){
                        if($valGravadas >= 100){
                                $retencion = number_format($valGravadas, 2, '.', '') * 0.01;
                                $valTotal = number_format($valTotal, 2, '.', '') - number_format($retencion, 2, '.', '');
                        }else{
                            $valTotal = number_format($valTotal, 2, '.', '');
                        }
                    }else{
                        $valTotal = number_format($valTotal, 2, '.', '');
                    }
                }else{
                    if($provee_tipo == 3){
                        if($valGravadas >= 100){
                                $percepcion = number_format($valGravadas, 2, '.', '') * 0.01;
                                $valTotal = number_format($valTotal, 2, '.', '') + number_format($percepcion, 2, '.', '');
                        }else{
                            $valTotal = number_format($valTotal, 2, '.', '');
                        }
                    }else{
                        $valTotal = number_format($valTotal, 2, '.', '');
                    }
                }
                            
                $array = array(
                    'valExentas' => number_format($valExentas, 4, '.', ','),
                    'valGravadas' => number_format($valGravadas, 4, '.', ','),
                    'valIVA' => number_format($valIVA, 4, '.', ','),
                    'valTotal' => number_format($valTotal, 2, '.', ','),
                    'fecvence' => $fecvence,
                    'retencion' => $retencion,
                    'percepcion' => $percepcion,
                    //'numreteperce' => $numreteperce
                );
				
				echo json_encode($array);
			}
		}
		
		function cerrarCompraLocal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion'); 
            }else{
                $buscar = array(chr(13).chr(10), "\r\n", "\n", "\r","\"", "'");
                $reemplazar = array("", "", "", "","","");

				$idtrannum  = $this->input->post('idtrannum');
				$serie      = $this->input->post('serie');
				$fecha      = $this->input->post('fecha');
				$numero     = $this->input->post('numero');
				$fecvence   = $this->input->post('fecvence');
				$solicita   = $this->input->post('solicita');
                
				$notas      = trim($this->input->post('notas'));
                $notas      = str_replace($buscar, $reemplazar, $notas);

				$valorRetencion     = $this->input->post('valorRetencion');
				$numDocRetencion    = $this->input->post('numDocRetencion');
				$valorPercepcion    = $this->input->post('valorPercepcion');
				$numDocPercepcion   = $this->input->post('numDocPercepcion');
				$numautoriza        = $this->input->post('numautoriza');
				$po_series          = $this->input->post('po_series');
				$tipoProducto       = $this->input->post('tipoProducto');

                $tipoDocumento      = $this->input->post('tipoDocumento');
                $numControl         = $this->input->post('numControl');
                $codigoGeneracion   = $this->input->post('codigoGeneracion');
                $selloRecepcion     = $this->input->post('selloRecepcion');
				
				$this->load->model('compras_model');
				$this->load->model('global_model');
				$idclase = $this->compras_model->cerrarCompraLocal($idtrannum, $serie, $fecha, $numero, $fecvence, $notas, $valorRetencion, $valorPercepcion, $numautoriza);
				
                if ($tipoProducto != 4 && $tipoProducto != 9) {
                    if($this->session->userdata('compraLote') == 0){
                        $resultado = $this->compras_model->updateBinBatchCompraLocal($idtrannum, $idclase);
                    }else{
                        $resultado = $this->compras_model->updateBinBatchCompraLocalLotes($idtrannum, $idclase, $fecha);
                    }
                } else {
                    $resultado = $this->compras_model->cerrarCompraLocalGastos($idtrannum, $idclase);
                }
                
                if ($tipoProducto != 4 && $tipoProducto != 9 && $resultado[0]) {
                    $insertPrint=0;
                    if($valorRetencion != 0){
                        $this->compras_model->insertarRegTran100pRetencion($idtrannum, $numDocRetencion);
                    }else{
                        $insertPrint=1;
                        $this->global_model->insertarRegTran100p($idtrannum);
                    }
                    
                    if($valorPercepcion != 0){
                        $this->compras_model->insertarRegTran100pRetencion($idtrannum, $numDocPercepcion);
                    }else{
                        if($insertPrint == 0){
                            $this->global_model->insertarRegTran100p($idtrannum);
                        }
                    }
                    
                    if ($po_series == 1) { $this->compras_model->callImeictl(1, 0, '', $idtrannum, $this->session->userdata('iduser')); }                
                }

                if ( $tipoDocumento == 1 ) {
                    $this->load->model('dte_model');
                    $this->dte_model->updateDatosDTE($idtrannum, $numControl, $codigoGeneracion, $selloRecepcion, '', '', '');
                }
				
                if($resultado[0]){
                    if ($tipoProducto != 4 && $tipoProducto != 9) {
                        $array = $this->compras_model->callTotaliza100($idtrannum, 1);
                    } else $array = $this->compras_model->callTotalizaGastos($idtrannum, 1);
                }else{
                    $array = false;
                }
             

				echo json_encode(["resultado"=>$resultado[0], "mensaje"=>$resultado[1],"info"=>$array]);
                
			}
		}
        
		function updateDatosCompraLocal(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum             = $this->input->post('trannum');
				$autorizacion        = $this->input->post('autorizacion');
				$serie               = $this->input->post('serie');
				$numero              = $this->input->post('numero');
				$fecha               = $this->input->post('fecha');
				$fecvence            = $this->input->post('fecvence');
				$documentoRetencion  = $this->input->post('documentoRetencion');
				$documentoPercepcion = $this->input->post('documentoPercepcion');
				$notasCompra         = $this->input->post('notasCompra');
                $tipoDocumento       = $this->input->post('tipoDocumento');
                $idrecDTE            = $this->input->post('idrecDTE');
                $numControl          = $this->input->post('numeroControl');
                $codigoGeneracion    = $this->input->post('codigoGeneracion');
                $selloRecepcion      = $this->input->post('selloRecepcion');
				
				$this->load->model('compras_model');
				$array = $this->compras_model->updateDatosCompraLocal($trannum, $autorizacion, $serie, $fecha, $numero, $fecvence, $notasCompra);
				
				if($documentoRetencion != ""){
					$this->compras_model->updateTran100pRetencion($trannum, $documentoRetencion);
				}
				
				if($documentoPercepcion != ""){
					$this->compras_model->updateTran100pRetencion($trannum, $documentoPercepcion);
				}

                if ( $tipoDocumento == 1 ) {
                    $this->load->model('dte_model');
                    if ($idrecDTE != 0) {
                        $this->dte_model->modificarInformacionDTE($numControl, $codigoGeneracion, $selloRecepcion, $idrecDTE);
                    } else {
                        $this->dte_model->updateDatosDTE($trannum, $numControl, $codigoGeneracion, $selloRecepcion, '', '', '');
                    }
                }
				
				echo json_encode($array);
			}
		}
        
		function updateDatosRecepcionCompraPendiente(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$serie = $this->input->post('serie');
				$numero = $this->input->post('numero');
				$fecha = $this->input->post('fecha');
				$fecvence = $this->input->post('fecvence');
				$documentoRetencion = $this->input->post('documentoRetencion');
				$documentoPercepcion = $this->input->post('documentoPercepcion');
				$notasCompra = $this->input->post('notasCompra');
				
				$this->load->model('compras_model');
				$array = $this->compras_model->updateDatosRecepcionCompraPendiente($trannum, $serie, $fecha, $numero, $fecvence, $notasCompra);
				
				if($documentoRetencion != ""){
					$this->compras_model->updateTran100pRetencion($trannum, $documentoRetencion);
				}
				
				if($documentoPercepcion != ""){
					$this->compras_model->updateTran100pRetencion($trannum, $documentoPercepcion);
				}
				
				echo json_encode($array);
			}
		}
                
        function getValidateRecepcionCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('trannum');
				
				$this->load->model('compras_model');
				$cantidad = $this->compras_model->getCantidadesTran100k($idtrannum);
				if($cantidad <= 0){
					$error = 1;
					$array = array(
						'error' => $error
					);
				}else{
					$result = $this->compras_model->getValidateCantidadCero100k($idtrannum);
					if($result > 0){
						$error = 2;
						$array = array(
							'error' => $error
						);
					}else{
						$error = 3;
                        $fechaPago = $this->compras_model->getFechaPagoCompra();
						$array = array(
							'error' => $error,
                            'fechaPago' => $fechaPago
						);
					}
				}
				
				echo json_encode($array);
			}
		}
		
        function savecompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->session->userdata('idcentrouser');
                $idproveedor = $this->input->post('Proveedor');
                $idtipocompra = $this->input->post('tipocompra');
                $numdocumentfiscal = $this->input->post('numdocumento');
                $numserie = $this->input->post('numserie');
                $fechaingreso = $this->input->post('fechaingreso');
                $referencia = $this->input->post('referencia');
                $fechaemision = $this->input->post('fechaemision');
                $observaciones = $this->input->post('observaciones');
                $periodo = $this->input->post('periodo');
                $solicitadopor = $this->input->post('solicitadopor');
                
                $this->load->model('compras_model');
                
                $query = $this->compras_model->insertarCompraLocal($idcentro, $idproveedor, $idtipocompra, $numserie, $numdocumentfiscal, $fechaingreso, $referencia, $fechaemision, $observaciones, $periodo, $solicitadopor);
                redirect('compras/comprasLocales/'.$this->session->userdata('iddApp'));
            }
        }
        
        function productosPorProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');
                $trannum = $this->input->post('trannum');
                $this->load->model('compras_model');
                $dataSource = $this->compras_model->getProductosPorProveedor($idcps);
                $productos = $this->compras_model->getProductosTempOrden($trannum);
                $array = array(
                    'dataSource' => $dataSource,
                    'productos' => $productos
                );
                echo json_encode($array);
            }
        }
        
        function productosTodos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('compras_model');
                $dataSource = $this->compras_model->getProductosTodos();
                $productos = $this->compras_model->getProductosTempOrden($trannum);
                $array = array(
                    'dataSource' => $dataSource,
                    'productos' => $productos
                );
                echo json_encode($array);
            }
        }
        
        function adicionarProductosTemp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $codigos = $this->input->post('codigos');
                $trannum = $this->input->post('trannum');
                $this->load->model('compras_model');
                $array = $this->compras_model->adicionarProductosTemp($codigos, $trannum);
                echo json_encode($array);
            }
        }
        
        function updateCantidadTran100temp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $precioventa = $this->input->post('precioventa');
                $trannum = $this->input->post('trannum');
                $this->load->model('compras_model');
                $array = $this->compras_model->updateCantidadT100Temp($idrec, $cantidad, $precioventa, $trannum);
                echo json_encode($array);
            }
        }
        
        function getValidateProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipopro = $this->input->post('tipopro');
                $this->load->model('compras_model');
                
                $array = $this->compras_model->getValidateProductosTipo($tipopro);
                echo json_encode($array);
            }
        }
        
        function deleteProductoTemp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('trannum');
                $this->load->model('compras_model');
                $array = $this->compras_model->deleteProductoTemporal($idrec, $trannum);
                echo json_encode($array);
            }
        }
        
        function cntUnidades(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('compras_model');
                $numProductos = $this->compras_model->getnumProductos($trannum);
                $numUnidades = $this->compras_model->getnumUnidades($trannum);
                $array = array(
                    'numProductos' => $numProductos,
                    'numUnidades' => $numUnidades
                );
                echo json_encode($array);
            }
        }
        
        function verificar_Ceros(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('compras_model');
                $cant = $this->compras_model->get_Verifica_Orden($trannum);
                echo json_encode($cant);
            }
        }
        
        function cerrarCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $notas = trim($this->input->post('notas'));
                $this->load->model('compras_model');
                $idclase = $this->compras_model->updateEstatusCompra($trannum, 1, $notas);
                $array = $this->compras_model->trasladoTempToTran100k($trannum, $idclase);
                
                echo json_encode($array);
            }
        }
        
        function eliminarCompra($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('compras_model');
                $this->compras_model->deleteCompraHDTemp($trannum);
                $this->compras_model->deleteCompraDTTemp($trannum);
                
                redirect('compras/comprasLocales/'.$this->session->userdata('iddApp'));
            }
        }
        
        function editarDatosCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $tipoCompra = $this->input->post('tipoCompra');
                $fechaIngreso = $this->input->post('fechaIngreso');
                $fechaDocumento = $this->input->post('fechaDocumento');
                $observaciones = $this->input->post('notas');
                $referencia = $this->input->post('referencia');
                $numeroDocumento = $this->input->post('numeroDocumento');
                $solicitadoPor = $this->input->post('solicitadoPor');
                $periodoFiscal = $this->input->post('periodoFiscal');
                
                $this->load->model('compras_model');
                $this->compras_model->updateDatosCompra($trannum, $tipoCompra, $fechaIngreso, $fechaDocumento, $observaciones, $referencia, $numeroDocumento, $solicitadoPor, $periodoFiscal);
                $solicita = $this->compras_model->getSolicitaTran100($solicitadoPor);
                $tipoCompra = $this->compras_model->getTipoCompraTran100($tipoCompra);
                
                $array = array(
                    'solicita' => $solicita,
                    'tipocompra' => $tipoCompra
                );
                
                echo json_encode($array);
            }
        }
        
        function po_tran($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				
				$idproveedor = $this->uri->segment(4);

                $this->load->model('proveedor_model');
                $this->load->model('variable_model');
                $this->load->model('compras_model');
                $this->load->model('empleado_model');
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
				if($idproveedor==""){
                    $idproveedor=0;
                }
                $tipo_productos = $this->configuracion_model->getProCentro($idApp);
              
                if($tipo_productos != "" && $tipo_productos != "0"  && $tipo_productos != null){
					$tipoProducto = explode(",", $tipo_productos);
					$totalDatos = count($tipoProducto);
					$tipo_productos = $tipoProducto[0];
					
                    $tipo_name = $this->variable_model->getDescripVar('gv_protipo', $tipo_productos);
                    $cant = $this->compras_model->getProducts_type($tipo_productos);
                    if($cant>0){
                        $puede =1;
                    }else{
                        $puede=0;
                    }
					
					if($totalDatos > 1){
						$idClaseDespacho = $tipoProducto[1];
					}else{
						$idClaseDespacho = 0;
					}
                }else{
                    $tipo_productos = "0";
                    $tipo_name = "Productos";
                    $puede = 1;
					$idClaseDespacho = 0;
                }
                
                $this->data['add_orden'] = $puede;
                $arreglo = array(
                    'compras_tipopro' => $tipo_productos,
                    'compras_tipopro_descrip' => $tipo_name,
					'idClaseDespacho' => $idClaseDespacho
                );
                $this->session->set_userdata($arreglo);
                
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['compras_tipopro'] = $tipo_productos;
                $this->data['IDCDespacho'] = $idClaseDespacho;

				$this->data['idproveedor'] = $idproveedor;
                $this->data['proveedores'] = $this->proveedor_model->viewProveeActivos();
                $this->data['vendedores'] = $this->empleado_model->viewEmple();
                $this->data['formas_pago'] = $this->compras_model->formasPago();
                $this->data['tipoDoc'] = $this->compras_model->tipoDoc();
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
                $this->data['estados_data'] = $this->variable_model->getVariablesNombre("po_stat");
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 120 days")); 
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;
                
                $this->load->view('mantenimiento_ordenesdecompras', $this->data);
			}
        }
      
        function callRegistro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{  
                $this->load->model('compras_model');
                $ordenes = $this->compras_model->getOrdenes();
                echo json_encode($ordenes);
            }
        }
      
        function getListadoOrdenesDeCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->session->userdata('idcentrouser');
                $tipoproC = $this->input->post('compras_tipopro');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->getListadoOrdenesDeCompra($idcentro, $fechaini, $fechafin, $tipoproC);
                
                echo json_encode($array);
            }
        }
        
        function create_order(){
            $idcentrouser = $this->session->userdata('idcentrouser');
            $proveedor = $this->input->post('proveedor');
            $fechaingreso = $this->input->post('fechaingreso');
            $tipoDocumento = $this->input->post('tipoDocumento');
            $cajclase = $this->input->post('cajclase');
            $vendedor = $this->input->post('vendedor');
            $fechaentrega = $this->input->post('fechaentrega');
            $lugar_entrega = $this->input->post('lugar_entrega');
            $referencia = $this->input->post('referencia');
            $notas = trim($this->input->post('notas'));
            $products_provee = $this->input->post('products_provee');
            $whodidit = $this->session->userdata('iduser');
            $tipoproC = $this->input->post('compras_tipopro');
            $IDCDespacho = $this->input->post('IDCDespacho');
            $fechaDesdeHasta = $this->input->post('fechaDesdeHasta');
            $analisisProducto = $this->input->post('analisisProducto');

            $this->load->model('compras_model');
            $save = $this->compras_model->insertOrden($idcentrouser, $proveedor, $fechaingreso, $tipoDocumento, $cajclase, $vendedor, $fechaentrega, $lugar_entrega, $referencia, $notas, $whodidit,$products_provee, $tipoproC, $fechaDesdeHasta, $analisisProducto);
            if($save != 0){
                 $info = array(
                     'save' => $save,
                     'tipoproC' => $tipoproC,
                     'IDCDespacho' => $IDCDespacho
                 );
                 echo json_encode($info);
                //redirect('compras/detalleOrden/'.$save.'/'.$tipoproC.'/'.$IDCDespacho);
            }
        }

        function update_order(){

            $trannum = $this->input->post('trannum');
            $idcentrouser = $this->session->userdata('idcentrouser');
            $proveedor = $this->input->post('proveedor');
            $fechaingreso = $this->input->post('fechaingreso');
            $tipoDocumento = $this->input->post('tipoDocumento');
            $cajclase = $this->input->post('cajclase');
            $vendedor = $this->input->post('vendedor');
            $fechaentrega = $this->input->post('fechaentrega');
            $lugar_entrega = $this->input->post('lugar_entrega');
            $referencia = $this->input->post('referencia');
            $notas = trim($this->input->post('notas'));
            $products_provee = $this->input->post('products_provee');
            $whodidit = $this->session->userdata('iduser');
            $tipoproC = $this->input->post('compras_tipopro');
            $IDCDespacho = $this->input->post('IDCDespacho');
            $fechaDesdeHasta = $this->input->post('fechaDesdeHasta');
            $analisisProducto = $this->input->post('analisisProducto');

            $this->load->model('compras_model');
            $save = $this->compras_model->updateOrden($trannum, $idcentrouser, $proveedor, $fechaingreso, $tipoDocumento, $cajclase, $vendedor, $fechaentrega, $lugar_entrega, $referencia, $notas, $whodidit,$products_provee, $tipoproC, $fechaDesdeHasta, $analisisProducto);
            if($save != 0){
                 $info = array(
                     'save' => $save,
                     'tipoproC' => $tipoproC,
                     'IDCDespacho' => $IDCDespacho
                 );
                 echo json_encode($info);
                //redirect('compras/detalleOrden/'.$save.'/'.$tipoproC.'/'.$IDCDespacho);
            }
        }
        
		function detalleOrdenUpdate($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				
				$this->load->model('ventas_model');$this->load->model('compras_model');
                $this->load->model('variable_model');$this->load->model('sucursal_model');
                $this->load->model('global_model');$this->load->model('invtran_model');
				
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['informacion'] = $this->compras_model->detalleOrdenCompra($trannum);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['formas_pago'] = $this->compras_model->formasPago();
                $this->data['tipoDoc'] = $this->compras_model->tipoDoc();
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
                $this->data['estados_data'] = $this->variable_model->getVariablesNombre("po_stat");
                $this->data['correo_user'] = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
				
				$tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
				
                $this->load->view('mantenimiento_detalle_ordencompra', $this->data); 
            }
        }
		
		//Versión funcionando hasta 26062018.....
		function detalleOrdenOld($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum." (".$this->session->userdata('compras_tipopro_descrip'). ")"
                );
                $this->session->set_userdata($resultAppName);
                
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				
				$this->load->model('ventas_model');$this->load->model('compras_model');
                $this->load->model('variable_model');$this->load->model('sucursal_model');
                $this->load->model('global_model');$this->load->model('invtran_model');
				
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['informacion'] = $this->compras_model->detalleOrdenCompra($trannum);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['formas_pago'] = $this->compras_model->formasPago();
                $this->data['tipoDoc'] = $this->compras_model->tipoDoc();
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
                $this->data['estados_data'] = $this->variable_model->getVariablesNombre("po_stat");
                $this->data['correo_user'] = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
				
				$tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
				
                $this->load->view('mantenimiento_detalle_ordencompra_update', $this->data); 
            }
        }
		
		//Modificación para despacho de materias primas...
		function detalleOrden($trannum, $tipoproC, $IDCDespacho){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum." (".$this->session->userdata('compras_tipopro_descrip'). ")"
                );
                $this->session->set_userdata($resultAppName);
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				
				$this->load->model('ventas_model');$this->load->model('compras_model');
                $this->load->model('variable_model');$this->load->model('sucursal_model');$this->load->model('empleado_model');
                $this->load->model('global_model');$this->load->model('invtran_model');$this->load->model('producto_model');
				
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['informacion'] = $this->compras_model->detalleOrdenCompra($trannum);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['vendedores'] = $this->empleado_model->viewEmple();
                $this->data['formas_pago'] = $this->compras_model->formasPago();
                $this->data['tipoDoc'] = $this->compras_model->tipoDoc();
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
                $this->data['estados_data'] = $this->variable_model->getVariablesNombre("po_stat");
                $this->data['correo_user'] = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
				$this->data['fab_envios'] = $this->global_model->getValorNumVariable('fab_envios');
			
                $tipopro = $tipoproC;//$this->session->userdata('compras_tipopro');
                if($tipopro==null && $tipopro==false){
                    $tipopro=1;
                }
                $this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['periodos'] = $this->compras_model->getPeriodosCompras(1);
                $this->data['tipo_pro'] = $tipopro;
                $this->data['IDCDespacho'] = $IDCDespacho;

                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipopro);
                $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipopro);
                $this->data['medidas'] = $this->producto_model->verUM();
                
                $permite_adicionar = $this->variable_model->getTextVar('po_addprod');
                if($permite_adicionar!=false){
                    $this->data['permite_add'] = 1;
                }else{
                    $this->data['permite_add'] = 0;
                }
                
				$tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
				
                $this->load->view('mantenimiento_detalle_ordencompra_fab', $this->data); 
            }
        }
		
		function getDataProductosOrden100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('compras_model');
				$array = $this->compras_model->getDatosOrden100k($idtrannum, $idcentro);
				echo json_encode($array);
			}
		}

        function updateCantidadesRecibidas100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum= $this->input->post('idtrannum');
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('compras_model');
                $this->compras_model->updateCantidadesRecibidas100k($idtrannum);
                $array = $this->compras_model->getDatosOrden100k($idtrannum, $idcentro);
                echo json_encode($array);
            }
        }

        
		function getDetalleProductosOrdenCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('trannum');
				$idcentro = $this->input->post('idcentro');
				
				$this->load->model('compras_model');
				$array = $this->compras_model->getDatosOrden100k($idtrannum, $idcentro);
				echo json_encode($array);
			}
		}
        
		function savepro_correo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$idproveedor = $this->input->post('idproveedor');
				$correo = $this->input->post('correo');
				
				$this->load->model('compras_model');
				$result = $this->compras_model->save_correo_proveedor($trannum, $idproveedor,$correo);
				echo json_encode($result);
			}
		}
		
		function getListadoLineasOrdenesCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$tipopro = $this->input->post('tipopro');
				
                $this->load->model('compras_model');
				$lineas = $this->compras_model->getGruposOrdenCompra($tipopro);
                $cantid = $this->compras_model->getCantidadesCatalogoCompra($idtrannum, $tipopro);
                
                $i=0;
				$array = array();
				
				foreach($lineas as $data){
					foreach($cantid as $cant){
						if($data->idcatalogo == $cant->idcatalogo){
							$array[$i] = array(
								"idcatalogo" => $data->idcatalogo,
								"imagen" => trim($data->imagen),
								"descrip" => trim($data->descrip),
								"total" => $cant->cantidad
							);
						}		
					}
					$i++;
				}
				
                echo json_encode($array);
			}
		}
		
		function getListadoProductosTipo(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $tipopro = $this->input->post('tipopro');
                $idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('compras_model');
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, $tipopro);
				
                $i=0;
                $datos = array();
                foreach($detalle as $info){
                    //validacion duplicidad compras locales
					if($info->existe == "0"){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "xpos" => $info->xpos,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "periodo" => $info->periodo
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i,
                );
                echo json_encode($array);
			}
		}
		
		function insertProductO100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idproducto = $this->input->post('idproducto');
                $descrip = $this->input->post('descrip');
                $cantidad = $this->input->post('cantidad');
                $precio = $this->input->post('precio');
                $tipotax = $this->input->post('tipotax');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $notas = trim($this->input->post('notas'));
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('compras_tipopro');
                $tipopro = $this->input->post('tipopro');
                
                $this->load->model('compras_model');
                $this->compras_model->insertProductoOrders100($idtrannum, $idproducto, $descrip, $cantidad, $um, $uniconv, $precio, $tipotax, $notas);
                //$this->compras_model->insertProOrders100($idtrannum, $idproducto, $cantidad, $um, $uniconv, $precio, $tipotax, $notas);
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, $tipopro);
                $datos = $this->compras_model->getDatosOrden100k($idtrannum,$idcentro);

                $i=0;
                $items = array();
                foreach($detalle as $info){
					//validacion duplicidad
					if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "periodo" => $info->periodo,
                        );
                        $i++;
                    }
                }
                
                $lines = 0; $units = 0;
                if($datos!=false){
                    foreach($datos as $dat){
                        $lines++;
                        $units = $units + abs($dat->cantidad);
                    }
                }

                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "lu" => $lines."/".$units
                );
                
                echo json_encode($array);
			}
		}
		
		function updateOrders100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idrec = $this->input->post('idrec');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('compras_tipopro');
                $tipopro = $this->input->post('tipopro');

                $cantidad = $this->input->post('cantidad');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $notas = trim($this->input->post('notas'));
                $precio = $this->input->post('precio');
                
                $this->load->model('compras_model');
                $this->compras_model->updateProdOrders100k($idtrannum, $idrec, $cantidad, $precio, $notas, $um, $uniconv);
				
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, $tipopro);
                $datos = $this->compras_model->getDatosOrden100k($idtrannum,$idcentro);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
					if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "periodo" => $info->periodo,
                        );
                        $i++;
                    }
                }
                
                $lines = 0;
                $units = 0;
                if($datos!=false){
                    foreach($datos as $dat){
                        $lines++;
                        $units = $units + abs($dat->cantidad);
                    }
                }
     
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "lu" => $lines."/".$units
                );
                
                echo json_encode($array);
			}
		}
		        
		function getluOrden100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
				$this->load->model('compras_model');
				$array = $this->compras_model->getDatosOrden100k($idtrannum, $idcentro);
                
                $lines = 0;
                $units = 0;
                if($datos!=false){
                    foreach($array as $dat){
                        $lines++;
                        $units = $units + abs($dat->cantidad);
                    }
                }
                $cadena = $lines ."/".$units;
				echo json_encode($cadena);
			}
		}
                
		function deleteRegistroOrders(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('compras_tipopro');
                $tipopro = $this->input->post('tipopro');
                
                $this->load->model('compras_model');
                $this->compras_model->deleteDataOrders100($idtrannum, $idrec);
                
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, $tipopro);
                $datos = $this->compras_model->getDatosOrden100k($idtrannum,$idcentro);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    //validacion duplicidad
					if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "xpos" => $info->xpos,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precioventa" => $info->precioventa,
                            "precio" => $info->costounitario,
                            "periodo" => $info->periodo,
                        );
                        $i++;
                    }
                }
                
                $lines = 0;
                $units = 0;
                if($datos!=false){
                    foreach($datos as $dat){
                        $lines++;
                        $units = $units + abs($dat->cantidad);
                    }
                }
     
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "lu" => $lines."/".$units
                );
                                
                echo json_encode($array);
            }
		}
		
		function verificar_orders(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
				$idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
				
                $data = $this->ventas_model->verifica_Orden($trannum);
				$list_productos = $this->compras_model->getDetail_products($trannum);
				$det = $this->compras_model->detalleOrdenCompra2($trannum);
				$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
				$provee_tipo = $det['provee_tipo'];
				
				$valExentas = 0; $valGravadas = 0;
                $valIVA = 0; $valTotal = 0;
				
                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $info){
                        if($info->tipotax == 0){
                            $valExentas = $valExentas + ($info->cantidad * $info->precioneto);
                        }else{
                            $valIVA = $valIVA + (($info->cantidad * $info->precioneto) * ($info->tipotax / 100));
                            $valGravadas = $valGravadas + ($info->cantidad * $info->precioneto);
                        }
                    }
                }         
                
                $valExentas = number_format($valExentas, 6, '.', '');
                $valGravadas = number_format($valGravadas, 6, '.', '');
                $valIVA = number_format($valIVA, 6, '.', '');

                $valTotal = $valExentas + $valGravadas + $valIVA;
                $percepcion = 0; $retencion = 0;

                if($empper == 1){
                    if($provee_tipo != 3){
                        if($valGravadas >= 100){
                                $retencion = number_format($valGravadas, 6, '.', '') * 0.01;
                                $valTotal = number_format($valTotal, 6, '.', '') - number_format($retencion, 6, '.', '');
                        }else{
                            $valTotal = number_format($valTotal, 6, '.', '');
                        }
                    }else{
                        $valTotal = number_format($valTotal, 6, '.', '');
                    }
                }else{
                    if($provee_tipo == 3){
                        if($valGravadas >= 100){
                                $percepcion = number_format($valGravadas, 6, '.', '') * 0.01;
                                $valTotal = number_format($valTotal, 6, '.', '') + number_format($percepcion, 6, '.', '');
                        }else{
                            $valTotal = number_format($valTotal, 6, '.', '');
                        }
                    }else{
                        $valTotal = number_format($valTotal, 6, '.', '');
                    }
                }
				
				$array = array(
					"validate" => $data,
					"exento" => $valExentas,
					"gravado" => $valGravadas,
					"iva" => $valIVA,
					"retencion" => $retencion,
					"percepcion" => $percepcion,
					"total" => $valTotal
				);
				
                echo json_encode($array);
            } 
        }
		
		function validateInvsitesProveedor(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');
				
                $this->load->model('compras_model');
				$array = $this->compras_model->validateInvsitesProveedor($idcps);
				
				echo json_encode($array);
            }
		}
		
		function cantMaterialesOrdenConsolidado(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $dev_place = $this->input->post('dev_place');
				$idcentro = $this->input->post('idcentro');
				
                $this->load->model('fabrica_model');
                $this->load->model('invtran_model');
				
				$productos = $this->fabrica_model->cantMaterialesOrdenConsolidado($trannum, $dev_place);
				
				$i=0;
				$array = array();
				
				foreach($productos as $pro){
                    $cantidadActual = 0;
                    $infoActual = $this->invtran_model->getCantidadStockProducto($pro->idproducto, $idcentro);
                    
					if($infoActual != false){
						$cantidadActual = $infoActual;
                    }
                    
					$cantidadEnvio = 0;
					if($cantidadActual > 0){
						if($cantidadActual >= $pro->cantidad){
							$cantidadEnvio = $pro->cantidad;
						}else{
							$cantidadEnvio =  $cantidadActual;
						}
					}
					
					$array[$i] = array(
						"idproducto" => $pro->idproducto,
						"descrip" => $pro->descrip,
						"um" => $pro->um,
						"cant_requerida" => $pro->cantidad,
						"exist_actual" => round($cantidadActual),
						"cant_envio" => $cantidadEnvio
					);
					
					$i++;
                }
				
				echo json_encode($array);
            }
		}
        
		function insertarDespachoDeMateriales(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idCentroSalida = $this->input->post('idCentroSalida');
                $idCentroEntrada = $this->input->post('idCentroEntrada');
				$dataSource = $this->input->post('dataProductos');
                //$idclase = $this->session->userdata('idClaseDespacho');
                $idclase = $this->input->post("IDCDespacho");
                
				$notas = "Traslado por despacho de materias primas.";
				
                $this->load->model('fabrica_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
				
				$inopera = $this->global_model->getInopera_invdef($idclase);
                $invcontrol = $this->global_model->getInvControlSite($idCentroSalida);
                
               	$array = $this->invtran_model->insertNuevoTrasladoDespacho($idCentroSalida, $idclase, $notas, $idCentroEntrada, $trannum, $dataSource, $inopera, $invcontrol);
				echo json_encode($array);
			}
		}
		
        function getProductos_list(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('compras_model');
                $this->load->model('ventas_model');
                $cant = $this->compras_model->getCant_Products($trannum); 
                $lineanext = $this->compras_model->nextProduct($trannum); 
                $array = array(
                    "cant" => $cant,
                    "producto" => $lineanext
                );
                echo json_encode($array);
            }
        }
        
        function editarDatosCompra2(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $fechaingreso = $this->input->post('fechaingreso');
                $notas = trim($this->input->post('notas'));
                $vendedor = $this->input->post('vendedor');
                $tipodocumento = $this->input->post('tipodocumento');
                $formapago = $this->input->post('formapago');
                $fechaentrega = $this->input->post('fechaentrega');
                $lugarentrega = $this->input->post('lugarentrega');
                $referencia = $this->input->post('referencia');
                $estado = $this->input->post('estado');
                $valorTotal = $this->input->post('valorTotal');
                $retencionTotal = $this->input->post('retencionTotal');
                $percepcionTotal = $this->input->post('percepcionTotal');
                
                $this->load->model('compras_model');
                $query = $this->compras_model->updateDatosOrden_Compra($trannum, $fechaingreso, $vendedor, $tipodocumento, $formapago, $fechaentrega, $lugarentrega, $referencia, $notas, $estado, $valorTotal, $retencionTotal, $percepcionTotal);
				
				echo json_encode($query);
            }
        }
        
        function cambiarEstado($trannum){
            $estado = $this->input->post('estado_next');
            $this->load->model('ventas_model');
            $this->load->model('compras_model');
            $query = $this->compras_model->cambiarEstado($trannum,$estado);
            redirect('compras/po_tran/'.$this->session->userdata('iddApp'));
        }
        
        function getProductosPro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idproveedor = $this->input->post('idproveedor');
                $tipo_pro = $this->input->post('tipo_pro');
               
                $this->load->model('compras_model');
                $productos_list = $this->compras_model->getProductosDispoPro($trannum, $idproveedor, $tipo_pro);
               
                echo json_encode($productos_list);
            }
        }
		
		function getProductosProveedor(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idproveedor = $this->input->post('idproveedor');
                $tipo_pro = $this->input->post('tipo_pro');
				$idcentro = $this->session->userdata('idcentrouser');
                
				$this->load->model('compras_model');
				$detalle = $this->compras_model->getInventarioByProveedorOrders($trannum,$idproveedor,$idcentro,$tipo_pro);
				
				$i=0;
                $items = array();
                foreach($detalle as $info){
					if($info->existe == "0"){
						$idproducto = $info->idproducto * 1;
                        $items[$i] = array(
							"id" => $idproducto,
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => 0,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "costounitario" => $info->costounitario
                        );
                        $i++;
                    }
                }
               
                echo json_encode($items);
            }
		}
		
		function getHistorialCompraProvee(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idproveedor = $this->input->post('idproveedor');
                $tipo_pro = $this->input->post('tipo_pro');
				$idcentro = $this->session->userdata('idcentrouser');
                
				$this->load->model('compras_model');
				$detalle = $this->compras_model->getHistorialCompraProveedor($trannum,$idproveedor,$idcentro,$tipo_pro);
				
				$i=0;
                $items = array();
                foreach($detalle as $info){
					if($info->existe == "0"){
						$idproducto = $info->idproducto * 1;
						
                        $items[$i] = array(
							"id" => $idproducto,
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => 0,
							"tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "costounitario" => 0
                        );
                        $i++;
                    }
                }
               
                echo json_encode($items);
            }
		}
		
		function insertarProductosByDatagrid(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$idcatalogo = $this->input->post('idcatalogo');
				$idtrannum = $this->input->post('idtrannum');
				$idcentro = $this->session->userdata('idcentrouser');
				$informacion = $this->input->post('informacion');
				$idcentro = $this->session->userdata('idcentrouser');
                $tipopro = $this->session->userdata('compras_tipopro');
				
				$this->load->model('compras_model');
				
				$total = count($informacion);
				for($i=0; $i<$total; $i++){
					$idproducto = $informacion[$i]['idproducto'];
					$cantidad = $informacion[$i]['cantidad'];
					$precio = $informacion[$i]['costounitario'];
					$tipotax = $informacion[$i]['tipotax'];
					$um = $informacion[$i]['um'];
					$notas = "";
					$uniconv = 1;
					
					if($cantidad != 0 && $precio != 0 && $cantidad != "" && $precio != "" && $cantidad != "0" && $precio != "0"){
						$this->compras_model->insertProOrders100($idtrannum, $idproducto, $cantidad, $um, $uniconv, $precio, $tipotax, $notas);
					}
				}
				
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalogo,$idcentro, $tipopro);
                $datos = $this->compras_model->getDatosOrden100k($idtrannum,$idcentro);
                //$cantidades = $this->compras_model->getCantidadesCatalogo($idtrannum, $idcentro, $tipopro);
                //$cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                //$unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);

                $i=0;
                $items = array();
                foreach($detalle as $info){
					//validacion duplicidad
					if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    //"cantidad" => $cantidad,
                    //"unidades" => number_format($unidades),
                    "count" => $i,
                    //"sumagrupos" => $cantidades
                );
                
                echo json_encode($array);
			}
		}
       
        function createOrderProducts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $codigos = $this->input->post('codigos');
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
                $query =  $this->compras_model->createOrderProducts($trannum, $codigos);
                $data = $this->ventas_model->getOrdenDetails($trannum);
                $array = array(
                    "data" => $data
                );
                echo json_encode($array);
            }
        }
        
        function po_recibe_compras($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
				
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $this->load->model('global_model');
				
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['estados'] = $this->variable_model->getVariablesNombre("po_stat");
				$this->session->set_userdata($resultAppName);
                $this->load->view('mantenimiento_recepcioncompras', $this->data);
            }
        }
        
        function po_recibe($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $this->load->model('configuracion_model');

                $date = new DateTime();
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days"));

                $this->session->set_userdata(array(
                    'iddApp'   => $idApp,
                    'appName'  => $this->configuracion_model->getAppName($idApp),
                    'namePage' => $this->configuracion_model->getAppName($idApp)
                ));

                $optCodigo = $this->configuracion_model->getProCentro($idApp);

                $infCodigos = explode(",", $optCodigo);
				
                $this->data['idBusqueda']  = $infCodigos[0];
                $this->data['idCierre']    = $infCodigos[1];
                $this->data['valFechaIni'] = $fecha_ini;
				$this->data['valFechafin'] = $fecha_fin;
				$this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1).'/'.$this->uri->segment(2));
				$this->data['estados']     = $this->variable_model->getVariablesNombre("po_stat");
                
				$this->load->view('mantenimiento_recepcion_compras', $this->data);
            }
        }
        
        function getordenesautorizadas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $estado = 2;
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $listaordenes = $this->compras_model->listaOrdenesAutorizadas($idcentro, $estado);
                
                $i=0;
                $array = array();
                
                foreach($listaordenes as $order){
                    
                    $odtranum = $order->trannum;
                    $datos = $this->compras_model->getDetalleRecepciones($odtranum);
                    $numrecepciones = $this->compras_model->getNumeroRecepciones($odtranum);
                    $dtrecepciones = array();
                    $j=0; $estatus = 1;
                    foreach($datos as $tran){
                        if($tran->estatus == 0){
                            $estatus = 0;
                        }
                        
                        $valorcosto = $tran->valcosto + $tran->valtax1 + $tran->valtax2;
                        
                        $dtrecepciones[$j] = array(
                            "trannum" => $tran->trannum,
                            "fecha" => $tran->fecha,
                            "fecact" => $tran->fecact,
                            "serienumero" => $tran->serie."".$tran->numero,
                            "referencia" => $tran->referencia,
                            "valcosto" => "$".number_format($valorcosto, 4, '.', ','),
                            "ordtrannum" => $order->trannum,
                            "estatus" => $tran->estatus
                        );
                        $j++;
                    }
                    
                    $array[$i] = array(
                        "ordtrannum" => $order->trannum,
                        "fecact" => date_format(date_create($order->dev_date), 'Y-m-d'),
                        "horaact" => date_format(date_create($order->dev_time), 'h:i A'),
                        "nameproveedor" => $order->proveedor,
                        "trannum" => $order->trannum,
                        "namesolicita" => $order->solicita,
                        "recepciones" => $numrecepciones,
                        "estatus" => $estatus,
                        "estato_ord" => $order->estatus,
                        "dt_recepciones" => $dtrecepciones
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
        function validateOrdenDeCompra() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro   = $this->session->userdata('idcentrouser');
                $trannum    = $this->input->post('trannum');
                $idBusqueda = $this->input->post('idBusqueda');
                
                $this->load->model('compras_model');
                echo json_encode($this->compras_model->validateOrdenDeCompraAutorizada($trannum, $idBusqueda, $idcentro));
            }
        }
        
        function getListadoRecepcionesIngresadas() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $listOrdenes = $this->compras_model->getListaRecepcionesIngresadasUpdate($idcentro, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                foreach($listOrdenes as $info){
                    $valorcosto = $info->valcosto + $info->valtax1 + $info->valtax5;
                    //$recibidos = $this->compras_model->getCantidadDetalleProductosRecibidos($info->trannum);
                    
                    #$k=0; $unidades = 0;
                    #foreach($recibidos as $rec){
                    #    $unidades = $unidades + $rec->cantidad;
                    #    $k++;
                    #}
                    
                    if($info->fecact2 == "0000-00-00"){
                        $fecact2 = "";
                    }else{
                        $fecact2 = $info->fecact2;
                    }
                    
                    $array[$i] = array(
                        "estatus" => $info->estado_recepcion,
                        "trannum" => $info->trannum,
                        "ordtrannum" => $info->ordtrannum,
                        "fecact" => $info->fecact,
                        "fecact2" => $fecact2,
                        "serienumero" => $info->serie."".$info->numero,
                        "nameproveedor" => $info->proveedor,
                        "lineasunidades" => $info->lines100k."/".$info->unidades,
                        "valor" => $valorcosto,
                        "username" => $info->username,
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
        function insertRecepcionCompra() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ordtrannum = $this->input->post('ordtrannum');
                $this->load->model('compras_model');
                $array = $this->compras_model->adicionarRecepcionCompra($ordtrannum);
                
                echo json_encode($array);
            }
        }
        
        function detalle_porecibe($trannum, $idCierre) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('compras_model');
				
				$this->data['idCierre']      = $idCierre;
				$this->data['formatos']      = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1).'/'.$this->uri->segment(2));
                $this->data['details']       = $this->compras_model->getDetailsRecepcionCO($trannum);
				$this->data['tipo_doc']      = $this->compras_model->tipoDoc();
				$this->data['exenta_compra'] = $this->compras_model->getExentaCompra($trannum);
				$this->data['pos_descuento'] = $this->global_model->getValorNumVariable('po_descuento');
				$this->data['po_tolerancia'] = $this->global_model->getValorNumeroVariable('po_tolerancia');
                $this->data['po_paydates']   = $this->global_model->getValorTextoVariable('po_paydates');
				$this->data['numdecimales']  = $this->compras_model->getCantidadDecimales('po_decimales');
                
                $this->load->view('mantenimiento_detalle_recepcionco_update', $this->data);
            }
        }
        
        function detalle_porecibe_update($trannum, $ordtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('compras_model');
                $this->load->model('global_model');
				
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['details'] = $this->compras_model->getDetailsRecepcionCO($trannum);
				$this->data['tipo_doc'] = $this->compras_model->tipoDoc();
                $this->load->view('mantenimiento_detalle_recepcionco', $this->data);
            }
        }
		
		function getListadoLineasRecepcion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $ordtrannum = $this->input->post('ordtrannum');
				$this->load->model('compras_model'); 
				$array = $this->compras_model->getGroupsProductosOrd100k($trannum, $ordtrannum);
                echo json_encode($array);
            }
		}
        
        function getProductosOrden_100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $this->load->model('compras_model');
                $recibidos = $this->compras_model->getDetalleProductosRecibidos($idtrannum);
                
                $k=0;
                $unidades = 0;
                foreach($recibidos as $rec){
                    $unidades = $unidades + $rec->cantidad;
                    $k++;
                }
                
                $array = array(
                    "recibidos" => $recibidos,
                    "cantidad" => $k,
                    "cantidadunidades" => $unidades
                );
                echo json_encode($array);
            }
        }
        
        function anulacionRecepcionCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $ordernum = $this->input->post('ordernum');
                $trannum = $this->input->post('trannum');
                $this->load->model('compras_model');
                
                $array = $this->compras_model->anulacionRecepcionDeOrden($ordernum, $trannum);
                echo json_encode($array);
            }
        }
        
        function getProductosOrdenadosCatalogo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $ordtrannum = $this->input->post('ordtrannum');
                $idtrannum = $this->input->post('idtrannum');
                $this->load->model('compras_model');
                //$detalle = $this->compras_model->getDetalleProductosOrdenCatalog($ordtrannum,$idtrannum,$idcatalogo);
                $detalle = $this->compras_model->getDetalleProductosOrdenTodos($ordtrannum,$idtrannum,$idcatalogo);
                $cantidad = $this->compras_model->getDetalleProductosOrdenados($ordtrannum,$idtrannum);

                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->precioneto,
                            "tipotax" => $info->tipotax,
                            "cantrp" => $info->cantrp
                        );
                        $i++;
                    }
                }
                
                $j=0;
                
                foreach($cantidad as $cant){
                    if($cant->existe == "0"){
                        $j++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "cantidad" => $j
                );
                
                echo json_encode($array);
            }
        }
        
        function movedToTran100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->input->post('idcentro');
                $idtrannum = $this->input->post('idtrannum');
                $ordtrannum = $this->input->post('ordtrannum');
                $idproducto = $this->input->post('idproducto');
                $cantidad = $this->input->post('cantidad');
                $precio = $this->input->post('precio');
                $notas = trim($this->input->post('notas'));
                $tipotax = $this->input->post('tipotax');
                
                $this->load->model('compras_model');
                $this->compras_model->recibirProductoCompras($idcentro, $tipotax, $ordtrannum, $idtrannum, $idproducto, $cantidad, $precio, $notas);
                
                $recibidos = $this->compras_model->getDetalleProductosRecibidos($idtrannum);
                $detalle = $this->compras_model->getDetalleProductosOrdenTodos($ordtrannum,$idtrannum,$idcatalogo);
                $cantidad = $this->compras_model->getDetalleProductosOrdenados($ordtrannum,$idtrannum);
				
				$i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->precioneto,
                            "tipotax" => $info->tipotax,
                            "cantrp" => $info->cantrp
                        );
                        $i++;
                    }
                }
                
                $j=0;
                foreach($cantidad as $cant){
                    if($cant->existe == "0"){
                        $j++;
                    }
                }
                
                $k=0;
                $unidades = 0;
                foreach($recibidos as $rec){
                    $unidades = $unidades + $rec->cantidad;
                    $k++;
                }
                
                $array = array(
                    "ordenados" => $items,
                    "recibidos" => $recibidos,
                    "cantidadord" => $j,
                    "cantidadrec" => $k,
                    "cantidadunidades" => $unidades,
					"count" => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function deleteItemTran100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $idtrannum = $this->input->post('idtrannum');
                $ordtrannum = $this->input->post('ordtrannum');
                $idrec = $this->input->post('idrec');
                $this->load->model('compras_model');
                
                $this->compras_model->deleteItemTran_100k($idrec);
                $recibidos = $this->compras_model->getDetalleProductosRecibidos($idtrannum);
				$detalle = $this->compras_model->getDetalleProductosOrdenTodos($ordtrannum,$idtrannum,$idcatalogo);
                $cantidad = $this->compras_model->getDetalleProductosOrdenados($ordtrannum,$idtrannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->precioneto,
                            "tipotax" => $info->tipotax,
                            "cantrp" => $info->cantrp
                        );
                        $i++;
                    }
                }
                
                $j=0;
                foreach($cantidad as $cant){
                    if($cant->existe == "0"){
                        $j++;
                    }
                }
                
                $k=0;
                $unidades = 0;
                foreach($recibidos as $rec){
                    $unidades = $unidades + $rec->cantidad;
                    $k++;
                }
                
                $array = array(
                    "ordenados" => $items,
                    "recibidos" => $recibidos,
                    "cantidadord" => $j,
                    "cantidadrec" => $k,
                    "cantidadunidades" => $unidades,
					"count" => $i
                );
                echo json_encode($array);
            }
        }
        
        function getTotalesRecepcionCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idproveedor = $this->input->post('idproveedor');
                $idcentro = $this->input->post('idcentro');
                $ordtrannum = $this->input->post('ordtrannum');
                $exenta = $this->input->post('exenta');
                $this->load->model('compras_model');
                
                $datos = $this->compras_model->getProductosTotalizadores($idtrannum);
                $serie = $this->compras_model->getLastSerie($idcentro, $idproveedor, 'CO');
                $ordenados = $this->compras_model->getDetalleProductosOrdenados($ordtrannum,$idtrannum);
                
				$provee_tipo = $this->compras_model->getTipoProveedorCompra($idtrannum);
				$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
				
                $valExentas = 0; $valGravadas = 0;
                $valIVA = 0; $valTotal = 0; $totalCantidades = 0;
                $i = 0;
                foreach($datos as $info){
                    $totalCantidades = $totalCantidades + $info->cantidad;
                    
                    if($exenta == 1){
                        $valExentas = $valExentas + ($info->cantidad * $info->preciotran);

                        $porcentajeIVA = ($info->tax1 / 100);
                    }else{
                        if($info->tax1 == 0){
                            $valExentas = $valExentas + ($info->cantidad * $info->preciotran);

                            $porcentajeIVA = ($info->tax1 / 100);
                        }else{
                            $sinIva = $info->preciotran * ($info->tax1 / 100);

                            $porcentajeIVA = ($info->tax1 / 100);
                            $valGravadas = $valGravadas + ($info->cantidad * $info->preciotran);
                        }
                    }
                    
					$i++;
                }
                
                $valExentas = round($valExentas, 6);
                $valGravadas = round($valGravadas, 6);
                $valIVA = $valGravadas * $porcentajeIVA;
                $valIVA = round($valIVA, 6);

                $valTotal = $valExentas + $valGravadas + $valIVA;
				
				$totalUnidades = $totalCantidades;
				$totalLineas = $i;
				
                $cantord = 0; $cantrp = 0;
                foreach($ordenados as $ord){
                    $cantord = $cantord + $ord->cantidad;
                    $cantrp = $cantrp + $ord->cantrp;
                }
                
                $totalCantidades = $totalCantidades + $cantrp;
                $porcentaje = ($totalCantidades / $cantord) * 100;
                
                $totSumas = $valExentas + $valGravadas;
				$totSumas = number_format($totSumas, 6, '.', '');
                $retencion = 0; $percepcion = 0; $permiteRetencion = 0; $permitePercepcion = 0;
				
                if($empper == 1){
                    if($provee_tipo != 3){
                        $permiteRetencion = 1;
                        if($valGravadas >= 100){
                            $retencion = number_format($valGravadas, 6, '.', '') * 0.01;
                            $valTotal = number_format($valTotal, 6, '.', '') - number_format($retencion, 6, '.', '');
                        }else{
                            $valTotal = number_format($valTotal, 6, '.', '');
                        }
                    }else{
                        $valTotal = number_format($valTotal, 6, '.', '');
                    }
                }else{
                    if($provee_tipo == 3){
                        $permitePercepcion = 1;
                        if($valGravadas >= 100){
                            $percepcion = number_format($valGravadas, 6, '.', '') * 0.01;
                            $valTotal = number_format($valTotal, 6, '.', '') + number_format($percepcion, 6, '.', '');
                        }else{
                            $valTotal = number_format($valTotal, 6, '.', '');
                        }
                    }else{
                        $valTotal = number_format($valTotal, 6, '.', '');
                    }
                }
				
				
				$valTotal = number_format($valTotal, 6, '.', '');
				
                $array = array(
                    "exentacompra" => $exenta,
                    "totExento" => $valExentas,
                    "totGravado" => $valGravadas,
                    "totIva" => $valIVA,
                    "totSumas" => $totSumas,
                    "porcentaje" => $porcentaje,
                    "retencion" => $retencion,
					"percepcion" => $percepcion,
                    "totalUnidades" => $totalUnidades,
                    "totalLineas" => $totalLineas,
                    "lastSerie" => $serie,
					"totalFinal" => $valTotal,
					"permiteRetencion" => $permiteRetencion,
					"permitePercepcion" => $permitePercepcion
                );
                
                echo json_encode($array);
            }
        }
        
        function getInformacionTotalesRecepcionCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('trannum');
                $this->load->model('compras_model');
                
                $datos = $this->compras_model->getProductosTotalizadores($idtrannum);
                $provee_tipo = $this->compras_model->getTipoProveedorCompra($idtrannum);
				$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
				$fecVence = $this->compras_model->getFechaPagoCompra();
                
				$percepcion = 0;
                $totExento = 0; $totGravado = 0; $totsinIva = 0;
                $totSumas = 0; $iva = 0; $totalCantidades = 0;
                $i = 0;
                foreach($datos as $info){
                    $totalCantidades = $totalCantidades + $info->cantidad;
                    
                    if(number_format($info->tax1) == 0){
                        $totExento = $totExento + ($info->cantidad * $info->preciotran);
                    }
                    
                    if(number_format($info->tax1) != 0){
                        $totGravado = $totGravado + (($info->cantidad) * ($info->preciotran  * (1 + ($info->tax1 / 100))));
                        $totsinIva = $totsinIva + ($info->cantidad * $info->preciotran);
                    }
					
					$i++;
                }
				
				$totIva = $totGravado - $totsinIva;
                $totSumas = $totsinIva + $totExento;
				$totSumas = number_format($totSumas, 2, '.', '');
                $retencion = 0; $percepcion = 0; $permiteRetencion = 0; $permitePercepcion = 0;
				
				if($empper == 1){
					if($provee_tipo != 3){
						$permiteRetencion = 1;
						if($totsinIva >= 100){
							$retencion = number_format($totsinIva, 2, '.', '') * 0.01;
							$retencion = number_format($retencion, 2 , '.', '');
						}
					}
				}else{
					if($provee_tipo == 3){
						$permitePercepcion = 1;
						if($totsinIva >= 100){
							$percepcion = number_format($totsinIva, 2, '.', '') * 0.01;
							$percepcion = number_format($percepcion, 2 , '.', '');
						}
					}
				}
				
				if($empper == 1){
					$totalFinal = $totSumas + $totIva - $retencion;
				}else{
					$totalFinal = $totSumas + $totIva + $percepcion;
				}
				
				$totalFinal = number_format($totalFinal, 2, '.', '');
				
                $array = array(
                    "valExentas" => number_format($totExento, 4, '.', ''),
                    "valGravadas" => number_format($totsinIva, 4, '.', ''),
                    "valIVA" => number_format($totIva, 4, '.', ''),
                    "retencion" => number_format($retencion, 4, '.', ''),
					"percepcion" => number_format($percepcion, 4, '.', ''),
					"fecvence" => $fecVence,
                    "valTotal" => $totalFinal
				);
                
                echo json_encode($array);
            }
        }
        
        function cerrarRecepcionCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $ordtrannum = $this->input->post('ordtrannum');
                $idtrannum = $this->input->post('idtrannum');
                $tipoDoc = $this->input->post('tipoDoc');
                $numeroSerie = $this->input->post('numeroSerie');
                $numeroDoc = $this->input->post('numeroDoc');
                $fechaDoc = $this->input->post('fechaDoc');
                $notas = trim($this->input->post('notas'));
                $valtax1 = $this->input->post('valtax1');
                $valcosto = $this->input->post('valcosto');
                $close = $this->input->post('close_ord');
                $numDocRetencion = $this->input->post('numDocRetencion');
                $valorRetencion = $this->input->post('valorRetencion');
				
                $this->load->model('compras_model');
                $this->load->model('global_model');
                $this->compras_model->updateDatosRecepcionCompra($idtrannum, $ordtrannum, $tipoDoc, $numeroSerie, $numeroDoc, $fechaDoc, 1, $notas, $valtax1, $valcosto, $close, $valorRetencion);
				
				if($valorRetencion != 0){
					$this->compras_model->insertarRegTran100pRetencion($idtrannum, $numDocRetencion);
				}else{
					$this->global_model->insertarRegTran100p($idtrannum);
				}
				
				$array = $this->compras_model->updateBinBatchCompra($idtrannum, $ordtrannum);
                
				echo json_encode($array);
            }
        }
        
        function cerrarRecepcionCompraUpdate() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idCierre        = $this->input->post('idCierre');
                $ordtrannum      = $this->input->post('ordtrannum');
                $idtrannum       = $this->input->post('idtrannum');
                $tipoDoc         = $this->input->post('tipoDoc');
                $numeroSerie     = $this->input->post('numeroSerie');
                $numeroDoc       = $this->input->post('numeroDoc');
                $fechaDoc        = $this->input->post('fechaDoc');
                $fechaPago       = $this->input->post('fechaPago');
                $notas           = trim($this->input->post('notas'));
                $valtax1         = $this->input->post('valtax1');
                $valcosto        = $this->input->post('valcosto');
                $valdescuento    = $this->input->post('valdescuento');
                $subtotal        = $this->input->post('subtotal');
                $close           = $this->input->post('close_ord');
                $numDocRetencion = $this->input->post('numDocRetencion');
                $valorRetencion  = $this->input->post('valorRetencion');
                $valorPercepcion = $this->input->post('valorPercepcion');
                $numDocPercepcion = $this->input->post('numDocPercepcion');

                $tipoDocumento      = $this->input->post('tipoDocumento');
                $numControl         = $this->input->post('numControl');
                $codigoGeneracion   = $this->input->post('codigoGeneracion');
                $selloRecepcion     = $this->input->post('selloRecepcion');

                $this->load->model('global_model');
                $this->load->model('compras_model');
                $this->compras_model->updateDatosRecepcionCompraUpdate($idtrannum, $ordtrannum, $tipoDoc, $numeroSerie, $numeroDoc, $fechaDoc,$fechaPago, 1, $notas, $valtax1, $valcosto, $subtotal, $valdescuento, $close, $valorRetencion, $valorPercepcion, $idCierre);
				
				if ($valorRetencion != 0) {
					$this->compras_model->insertarRegTran100pRetencion($idtrannum, $numDocRetencion);
				} else {
					$this->global_model->insertarRegTran100p($idtrannum);
				}
				
				if ($valorPercepcion != 0) {
					$this->compras_model->insertarRegTran100pRetencion($idtrannum, $numDocPercepcion);
				} else {
					$this->global_model->insertarRegTran100p($idtrannum);
				}

                if ( $tipoDocumento == 1 ) {
                    $this->load->model('dte_model');
                    $this->dte_model->updateDatosDTE($idtrannum, $numControl, $codigoGeneracion, $selloRecepcion, '', '', '');
                }
				
				echo json_encode($this->compras_model->updateBinBatchCompra($idtrannum, $ordtrannum));
            }
        }
        
        function getProductosUp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $tipo_pro = $this->input->post('tipo_pro');
                   
                $this->load->model('compras_model');
                $productos_list = $this->compras_model->getProductosDispo($trannum, $tipo_pro);
               
                echo json_encode($productos_list);
            }
        }
        
        function deleteLineasCeros(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcatalogo = $this->input->post('idcatalogo');
				$idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('compras_tipopro');
                $tipopro = $this->input->post('tipopro');
                
				$this->load->model('compras_model');
                $delete = $this->compras_model->deleteLineasCeros($trannum);
                
                $detalle = $this->compras_model->getInventarioByCatalogOrders($trannum,$idcatalogo,$idcentro,$tipopro);
                $datos = $this->compras_model->getDatosOrden100k($trannum,$idcentro);
                //$cantidades = $this->compras_model->getCantidadesCatalogo($idtrannum, $idcentro, $tipopro);
                //$cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                //$unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    //validacion duplicidad
					if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precioventa" => $info->precioventa,
                            "precio" => $info->costounitario,
                            "periodo" => $info->periodo,
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    //"cantidad" => $cantidad,
                    //"unidades" => number_format($unidades),
                    "count" => $i,
                    //"sumagrupos" => $cantidades
                );
                                
                echo json_encode($array);
            }
        }
        
        function getOrdenProduct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idproducto = $this->input->post('idproducto');
                $this->load->model('compras_model');
                $data = $this->compras_model->getOrdenProduct($trannum, $idproducto);
                echo json_encode($data);
            }
        }
        
        function updateCantidadorders_100k(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $precioneto = $this->input->post('precioneto');
                $notas = trim($this->input->post('notas'));
                $trannum = $this->input->post('trannum');
                $this->load->model('ventas_model');
                $array = $this->ventas_model->updateCantidadorders_100k($idrec, $cantidad, $precioneto, $trannum,$notas);
                $data = $this->ventas_model->getOrdenDetails($trannum);
                echo json_encode($data);
            }
        }
        
        function getComprasUpdated(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $trannum = $this->input->post('trannum');
                $this->load->model('ventas_model');
                $data = $this->ventas_model->getOrdenDetails($trannum);
                echo json_encode($data);
            }
        }
        
        function getOrdenesRecibidas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $estado = 1;
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('compras_model');
                $datos = $this->compras_model->listaOrdenesRecibidas($idcentro, $estado);
                
				$i=0;
				$items = array();
				
				foreach($datos as $info){
					$items[$i] = array(
						"trannum" => $info->trannum,
						"nameproveedor" => $info->nameproveedor,
						"numero" => $info->serie."".$info->numero
					);
					$i++;
				}
				
				if($i == 0){
					$i = "0";
				}
				
				$array = array(
					"datos" => $items,
					"cantidad" => $i
				);
				
				echo json_encode($array);
            }
        }
        
        function getInfoOrden(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $idcps = $this->input->post('idcps');
                $compras_tipopro = $this->input->post('compras_tipopro');
                $this->load->model('compras_model');
                $data = $this->compras_model->getInfoOrden($idcps, $compras_tipopro);
                $cant = $this->compras_model->getCantProductos_proveedor($idcps, $compras_tipopro);
                
                  
                $array = array(
                    "datos" => $data,
                    "cant" => $cant
                );
                echo json_encode($array);
            }
        }
		
        function getPieChart(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                
                $dateInput = explode('/',$fechaini);
                $fechaini2 = $dateInput[2].'-'.$dateInput[1].'-'.$dateInput[0];
                
                $dateInput2 = explode('/',$fechafin);
                $fechafin2 = $dateInput2[2].'-'.$dateInput2[1].'-'.$dateInput2[0];
                
                
                $this->load->model('compras_model');
                $data = $this->compras_model->getLinesChartFechas($fechaini2,$fechafin2);
                $data_pie = $this->compras_model->getPieChartFechas($fechaini2,$fechafin2);
                
                $i=0;
                $array_info = array();
                foreach($data as $dat){
                    $venta = $dat->valventan *1;
                    $costo = abs($dat->valcosto) *1;
                    $hits = $dat->hits *1;
                    $array_info[$i] = array(
                        //"fecha" => $dat->fechaFormat,
                        "fecha" => $dat->fechaFormat2,
                        "valventan" => $venta,
                        "valcosto" => $costo,
                        "hits" => $hits,
                    );
                    $i++;
                }
                
                $j=0;
                $array_pie = array();
                foreach($data_pie as $dat){
                    $venta = $dat->valventan *1;
                    $costo = abs($dat->valcosto) *1;
                    $hits = $dat->hits *1;
                    
                    $array_data = array(
                        "venta" => $venta,
                        "costo" => $costo,
                        "clientes" => $hits
                    );
                    
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Venta",
                        "valor" => $venta,
                        "data" => $array_data
                    );
                    $j++;
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Costo",
                        "valor" => $costo,
                        "data" => $array_data
                    );
                    $j++;
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Clientes",
                        "valor" => $hits,
                        "data" => $array_data
                    );
                    $j++;
                }
                
                $array =  array(
                    "datos"=>$array_info,
                    "pie" =>$array_pie
                );
                
                
                echo json_encode($array);
            }
        }
        
        function get_estadisticas_all(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $this->load->model('ventas_model');
                $this->load->model('compras_model');
                $data = $this->compras_model->getAllVentas2();
                $data_pie = $this->compras_model->getTotalVentas_Pie();
                $primer_dia="";
                $i=0;
                $array_info = array();
                foreach($data as $dat){
                    
                    if($i==0){
                        $primer_dia=$dat->fechaFormat2;
                    }
                    
                    $venta = $dat->valventan *1;
                    $costo = abs($dat->valcosto) *1;
                    $hits = $dat->hits *1;
                    $array_info[$i] = array(
                        //"fecha" => $dat->fechaFormat,
                        "fecha" => $dat->fechaFormat2,
                        "valventan" => $venta,
                        "valcosto" => $costo,
                        "hits" => $hits,
                    );
                    $i++;
                }
                $j=0;
                $array_pie = array();
                foreach($data_pie as $dat){
                    $venta = $dat->valventan *1;
                    $costo = abs($dat->valcosto) *1;
                    $hits = $dat->hits *1;
                    
                    $array_data = array(
                        "venta" => $venta,
                        "costo" => $costo,
                        "clientes" => $hits
                    );
                    
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Venta",
                        "valor" => $venta,
                        "data" => $array_data
                    );
                    $j++;
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Costo",
                        "valor" => $costo,
                        "data" => $array_data
                    );
                    $j++;
                    $array_pie[$j] = array(
                        //"fecha" => $dat->fechaFormat,
                        "tipo" => "Clientes",
                        "valor" => $hits,
                        "data" => $array_data
                    );
                    $j++;
                }
                
                $array =  array(
                    "datos"=>$array_info,
                    "pie" =>$array_pie, 
                    "primer_dia" =>$primer_dia
                );
                
                echo json_encode($array);    
            }
        }
        
        function imprimirTicketEposFinal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('acs_model');
                $this->load->model('caja_model');
				
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                //$Comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$correo = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
				
                $informacion = $this->ventas_model->getDatosFactura($trannum);
				foreach($informacion as $info){
					$idcentro = $info->idcentro; 
					$idcaja = $info->idcaja;
					$nameCliente = $info->nameCliente;
                    $grupoCliente = $info->grupo;
                    $date = date_create($info->fecha);
                    $fechaTicket = date_format($date, 'd/m/Y');
                    $date2 = date_create($info->ingresa);
                    $fechaIngreso = date_format($date2, 'd/m/Y H:i a');
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);
                
				foreach($infoRes as $infres){
					$numres = $infres->resolucion;
					$fecres = $infres->fresolucion;
					$desder = $infres->serie.$infres->desde;
					$hastar = $infres->serie.$infres->hasta;
				}
				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
                
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;
                    $direccionCaja = $caja->equipo;
				}
                    
                $productos = $this->acs_model->getDataVenta100k($trannum);
				$detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
                
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                
                $array = array(
                    "razonsocial" => $RazonSocial,
                    "idcentro" => $idcentro,
                    "grupoCliente" =>$info->grupo,
                    "direccion" => $direccion,
                    "direccionCaja" => $direccionCaja,
                    "direccionCentro" => $info->direccioncentro,
                    "telefono" => $telefono,
                    "correo" => $correo,
                    "namecaja" => $namecaja,                
                    "namecentro" => $namecentro,                
                    "nrf" => $NRF,                
                    "nit" => $NIT,                
                    "giro" => $GIRO,                
                    "numres" => $numres,                
                    "fecres" => $fecres,                
                    "desder" => $desder,                
                    "hastar" => $hastar,                
                    "tipodocumento" => strtoupper($info->descrip),                
                    "numdocumento" => $info->numero,                
                    "productos" => $productos,                
                    "invexento" => $info->exento,                
                    "namevendedor" => strtoupper($info->nameVendedor),                
                    "datos_print" => $datosprint,                
                    "detallePagos" => $detailPagos,
                    "efectivo" => $efectivo,
                    "nameCliente" => $nameCliente,
                    "fechaticket" => $fechaTicket,
                    "fechaIngreso" => $fechaIngreso
                );
                
                echo json_encode($array);
            }
        }
        
        function session_data(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $cant = $this->input->post('cantidades');
                $array = array(
                    "cantidades" => $cant,
                );
                $this->session->set_userdata($array);
                echo json_encode(true);
            }
        }
        
        function uploadNewProducts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($this->input->post()){
                    $idtrannum = $this->input->post('idtrannum_insert');
                    $name_img = $this->input->post('imgen');
                    $marca = $this->input->post('input_marca');
                    $idcatalog = $this->input->post('input_catalogo');
                    $proveedor = $this->input->post('input_proveedor');
                    $tipopro = $this->input->post('input_tipopro');
                    $tipTax = $this->input->post('input_tipotax');
                    $um = $this->input->post('um');
                    $precioventa = $this->input->post('input_precioventa');
                    $idcentro = $this->session->userdata('idcentrouser');
                    $tipopro = $this->session->userdata('tipoprod');
                    //$tipopro = $this->session->userdata('tipo_producto_compra');
                    
                    $array_products = json_decode($this->input->post('arreglo_tile_hidden'));
                    $this->load->model('producto_model');
                    $this->load->model('compras_model');
                    if(isset($_FILES["archivo"])){
                        $file = $_FILES["archivo"];
                        $nombre = $file["name"];
                    }
                    foreach($array_products as $array){
                        $idproducto = $this->producto_model->insertProductCompra($array->producto, $array->costo_unitario, $array->modelo, $array->barcode, $marca, $idcatalog, $proveedor, $tipopro, $tipTax, $um, $precioventa,$name_img);
                        if($nombre!=""){
                            $imgSplit = explode(".", $nombre);
                            $nombreimagen = "imgProduct_".$idproducto;
                            $nombreimagen2 = "imgProduct_".$idproducto.".".$imgSplit[1];
                            $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                            $config['file_name'] = $nombreimagen;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "gif|jpg|jpeg|png";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);     
                            if($this->upload->do_upload('archivo')){
                                $this->producto_model->updateProductImagen($idproducto,$nombreimagen2,$this->session->userdata('iduser'));
                            }
                        }
                        $this->compras_model->insertProTran100kt($idtrannum, $idproducto, $array->cantidad, $um, 1, $array->costo_unitario, $tipTax, "");
                    }
                    
                    $detalle = $this->compras_model->getInventarioByCatalog($idtrannum, $idcatalog, $idcentro, $tipopro);
                    $datos = $this->compras_model->getDataTran100kt($idtrannum, $idcentro);
                    $cantidades = $this->compras_model->getCantidadesCatalogo($idtrannum, $idcentro, $tipopro);
                    $cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                    $unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);

                    $i=0;
                    $items = array();
                    foreach($detalle as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "costouni" => $info->costouni
                        );
                        $i++;
                    }

                    $array = array(
                        "items" => $items,
                        "datos" => $datos,
                        "cantidad" => $cantidad,
                        "unidades" => number_format($unidades),
                        "count" => $i,
                        "sumagrupos" => $cantidades
                    );
                    echo json_encode($array);
                }
            }
        }
        
        function uploadNewProductsOC(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                if($this->input->post()){
                    $idtrannum = $this->input->post('idtrannum_insert');
                    $name_img = $this->input->post('imgen');
                    $marca = $this->input->post('input_marca');
                    $idcatalog = $this->input->post('input_catalogo');
                    $proveedor = $this->input->post('input_proveedor');
                    $tipopro = $this->input->post('input_tipopro');
                    $tipTax = $this->input->post('input_tipotax');
                    $um = $this->input->post('um');
                    $precioventa = $this->input->post('input_precioventa');
                    $idcentro = $this->session->userdata('idcentrouser');
                    
                    $array_products = json_decode($this->input->post('arreglo_tile_hidden'));
                    $this->load->model('producto_model');
                    $this->load->model('compras_model');
                    if(isset($_FILES["archivo"])){
                        $file = $_FILES["archivo"];
                        $nombre = $file["name"];
                    }
                    foreach($array_products as $array){
                        $idproducto = $this->producto_model->insertProductCompra($array->producto, $array->costo_unitario, $array->modelo, $array->barcode, $marca, $idcatalog, $proveedor, $tipopro, $tipTax, $um, $precioventa,$name_img);
                        if($nombre!=""){
                            $imgSplit = explode(".", $nombre);
                            $nombreimagen = "imgProduct_".$idproducto;
                            $nombreimagen2 = "imgProduct_".$idproducto.".".$imgSplit[1];
                            $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                            $config['file_name'] = $nombreimagen;
                            $config['over_write'] = "TRUE";
                            $config['allowed_types'] = "gif|jpg|jpeg|png";
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);     
                            if($this->upload->do_upload('archivo')){
                                $this->producto_model->updateProductImagen($idproducto,$nombreimagen2,$this->session->userdata('iduser'));
                            }
                        }
                        $this->compras_model->insertProOrders100($idtrannum, $idproducto, $array->cantidad, $um, 1, $array->costo_unitario, $tipTax, "");
                    }
                    $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalog,$idcentro, $tipopro);
                    $datos = $this->compras_model->getDatosOrden100k($idtrannum,$idcentro);

                    $i=0;
                    $items = array();
                    foreach($detalle as $info){
                        //validacion duplicidad
                        if($info->existe == "0"){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "tipotax" => $info->tipotax,
                                "precio" => $info->costounitario,
                                "precioventa" => $info->precioventa,
                                "costouni" => $info->costouni
                            );
                            $i++;
                        }
                    }

                    $array = array(
                        "items" => $items,
                        "datos" => $datos,
                        "count" => $i
                    );
                    
                    echo json_encode($array);
                }
            }
        }
        
        function insertProductosMPL(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $array_insert = $this->input->post('array');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalog = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                $tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $this->load->model('compras_model');
                $insert = $this->compras_model->insertProductosMPL($idtrannum,$array_insert);
                $detalle = $this->compras_model->getInventarioByCatalog($idtrannum, $idcatalog, $idcentro, $tipopro);
                $datos = $this->compras_model->getDataTran100kt($idtrannum, $idcentro);
                $cantidades = $this->compras_model->getCantidadesCatalogo($idtrannum, $idcentro, $tipopro);
                $cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "tipotax" => $info->tipotax,
                        "precio" => $info->costounitario,
                        "costouni" => $info->costouni
                    );
                    $i++;
                }
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades),
                    "count" => $i,
                    "sumagrupos" => $cantidades
                );
                echo json_encode($array);
            }
        }
        
        function allowInsertProducts(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $tipo_ingreso = $this->input->post('tipo_ingreso');
                $string_insert = $this->input->post('productos');
                $idtrannum = $this->input->post('idtrannum');
                
                $datoBusqueda = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $datoRemplazo = array("_", "_", "_", "_");
                $string_insert = str_replace($datoBusqueda, $datoRemplazo, $string_insert);
                
                $cadena_lineas = ""; $cant_errores = 0;
                $this->load->model('compras_model');
                
                if($tipo_ingreso==1){
                    //CODIGO INTERNO CON COSTO
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 3){
                            $insert = $this->compras_model->verifyInsertProduct($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==3){

                                if($array_producto[1] < 0){
                                    $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $cant_errores++;
                                    continue;
                                }

                                $insert = $this->compras_model->verifyInsertProduct($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                }else if($tipo_ingreso == 2){
                    //CODIGO DE BARRAS CON COSTO
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 3){
                            $insert = $this->compras_model->verifyInsertProductCodBarra($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==3){

                                if($array_producto[1] < 0){
                                    $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $cant_errores++;
                                    continue;
                                }

                                $insert = $this->compras_model->verifyInsertProductCodBarra($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                }else if($tipo_ingreso == 3){
                    //MODELO CON COSTO
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 3){
                            $insert = $this->compras_model->verifyInsertProductModelo($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 3){

                                if($array_producto[1] < 0){
                                    $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $cant_errores++;
                                    continue;
                                }

                                $insert = $this->compras_model->verifyInsertProductModelo($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                }else if($tipo_ingreso == 4){
                    //CODIGO XPOS CON COSTO
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 3){
                            $insert = $this->compras_model->verifyInsertProductXPOS($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 3){

                                if($array_producto[1] < 0){
                                    $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $cant_errores++;
                                    continue;
                                }

                                $insert = $this->compras_model->verifyInsertProductXPOS($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                }else if($tipo_ingreso == 5){
                    //CODIGO INTERNO SIN COSTO
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 2){
                            $insert = $this->compras_model->verifyInsertProduct($idtrannum, $array_producto[0], $array_producto[1], 0);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                            
                            $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 1);
                            
                            if($costoProducto == false){
                                $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no tiene costo en su ficha de producto.";
                                $cant_errores++;
                            }
                            
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 2){

                                if($array_producto[1] < 0){
                                    $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $cant_errores++;
                                    continue;
                                }

                                $insert = $this->compras_model->verifyInsertProduct($idtrannum, $array_producto[0], $array_producto[1], 0);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                                
                                $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 1);
                                if($costoProducto == false){
                                    $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no tiene costo en su ficha de producto.";
                                    $cant_errores++;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                }else if($tipo_ingreso == 6){
                    //CODIGO DE BARRAS SIN COSTO
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 2){
                            $insert = $this->compras_model->verifyInsertProductCodBarra($idtrannum, $array_producto[0], $array_producto[1], 0);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                            
                            $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 2);
                            if($costoProducto == false){
                                $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no tiene costo en su ficha de producto.";
                                $cant_errores++;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 2){

                                if($array_producto[1] < 0){
                                    $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $cant_errores++;
                                    continue;
                                }

                                $insert = $this->compras_model->verifyInsertProductCodBarra($idtrannum, $array_producto[0], $array_producto[1], 0);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                                
                                $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 2);
                                if($costoProducto == false){
                                    $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no tiene costo en su ficha de producto.";
                                    $cant_errores++;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                }else if($tipo_ingreso == 7){
                    //MODELO SIN COSTO
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 2){
                            $insert = $this->compras_model->verifyInsertProductModelo($idtrannum, $array_producto[0], $array_producto[1], 0);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                            
                            $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 3);
                            if($costoProducto == false){
                                $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no tiene costo en su ficha de producto.";
                                $cant_errores++;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 2){

                                if($array_producto[1] < 0){
                                    $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $cant_errores++;
                                    continue;
                                }
                                
                                $insert = $this->compras_model->verifyInsertProductModelo($idtrannum, $array_producto[0], $array_producto[1], 0);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                                
                                $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 3);
                                if($costoProducto == false){
                                    $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no tiene costo en su ficha de producto.";
                                    $cant_errores++;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                }else if($tipo_ingreso == 8){
                    //CODIGO XPOS SIN COSTO
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 2){
                            $insert = $this->compras_model->verifyInsertProductXPOS($idtrannum, $array_producto[0], $array_producto[1], 0);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                            
                            $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 4);
                            if($costoProducto == false){
                                $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no tiene costo en su ficha de producto.";
                                $cant_errores++;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 2){

                                if($array_producto[1] < 0){
                                    $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque se ha digitado una cantidad negativa. <br>";
                                    $cant_errores++;
                                    continue;
                                }

                                $insert = $this->compras_model->verifyInsertProductXPOS($idtrannum, $array_producto[0], $array_producto[1], 0);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                                
                                $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 4);
                                if($costoProducto == false){
                                    $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no tiene costo en su ficha de producto.";
                                    $cant_errores++;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                }else{
                    $cant_errores++;
                    $cadena_lineas = "TIPOS DE INGRESO EN MANTENIMIENTO";
                }
                
                $array_send = array(
                    "errores" => $cant_errores,
                    "mensaje" => $cadena_lineas
                );
                
                echo json_encode($array_send);
            }
        }

        function importProductsCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $tipo_ingreso = $this->input->post('tipo_ingreso');
                $string_insert = $this->input->post('productos');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalog = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                $tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                
                $datoBusqueda = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $datoRemplazo = array("_", "_", "_", "_");
                $string_insert = str_replace($datoBusqueda, $datoRemplazo, $string_insert);
                
                $this->load->model('compras_model');
                
                if($tipo_ingreso == 1){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 3){
                            $insert = $this->compras_model->insertLineCompraLocal($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 3){
                                $insert = $this->compras_model->insertLineCompraLocal($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            }
                        }
                    }
                }else if($tipo_ingreso == 2){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 3){
                            $insert = $this->compras_model->insertLineCompraLocalCodBarra($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 3){
                                $insert = $this->compras_model->insertLineCompraLocalCodBarra($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            }
                        }
                    }
                }else if($tipo_ingreso == 3){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 3){
                            $insert = $this->compras_model->insertLineCompraLocalModelo($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 3){
                                $insert = $this->compras_model->insertLineCompraLocalModelo($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            }
                        }
                    }
                }else if($tipo_ingreso == 4){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 3){
                            $insert = $this->compras_model->insertLineCompraLocalXPOS($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 3){
                                $insert = $this->compras_model->insertLineCompraLocalXPOS($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            }
                        }
                    }
                }else if($tipo_ingreso == 5){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 2){
                            $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 1);
                            
                            if($costoProducto != false){
                                $insert = $this->compras_model->insertLineCompraLocal($idtrannum, $array_producto[0], $array_producto[1], $costoProducto);
                            }
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 2){
                                $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 1);
                                
                                if($costoProducto != false){
                                    $insert = $this->compras_model->insertLineCompraLocal($idtrannum, $array_producto[0], $array_producto[1], $costoProducto);
                                }
                            }
                        }
                    }
                }else if($tipo_ingreso == 6){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 2){
                            $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 2);
                            
                            if($costoProducto != false){
                                $insert = $this->compras_model->insertLineCompraLocalCodBarra($idtrannum, $array_producto[0], $array_producto[1], $costoProducto);
                            }
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 2){
                                $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 2);
                                
                                if($costoProducto != false){
                                    $insert = $this->compras_model->insertLineCompraLocalCodBarra($idtrannum, $array_producto[0], $array_producto[1], $costoProducto);
                                }
                            }
                        }
                    }
                }else if($tipo_ingreso == 7){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 2){
                            $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 3);
                            
                            if($costoProducto != false){
                                $insert = $this->compras_model->insertLineCompraLocalModelo($idtrannum, $array_producto[0], $array_producto[1], $costoProducto);
                            }
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 2){
                                $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 3);
                                
                                if($costoProducto != false){
                                    $insert = $this->compras_model->insertLineCompraLocalModelo($idtrannum, $array_producto[0], $array_producto[1], $costoProducto);
                                }
                            }
                        }
                    }
                }else if($tipo_ingreso == 8){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string) == 0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto) == 2){
                            $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 4);
                            
                            if($costoProducto != false){
                                $insert = $this->compras_model->insertLineCompraLocalXPOS($idtrannum, $array_producto[0], $array_producto[1], $costoProducto);
                            }
                        }
                    }else{
                        for($i=0; $i<count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto) == 2){
                                $costoProducto = $this->compras_model->getCostoProductoByFiltro($array_producto[0], 4);
                                
                                if($costoProducto != false){
                                    $insert = $this->compras_model->insertLineCompraLocalXPOS($idtrannum, $array_producto[0], $array_producto[1], $costoProducto);
                                }
                            }
                        }
                    }
                }
                
                $detalle = $this->compras_model->getInventarioByCatalog($idtrannum, $idcatalog, $idcentro, $tipopro);
                $datos = $this->compras_model->getDataTran100kt($idtrannum, $idcentro);
                
                $cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "xpos" => $info->xpos,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "tipotax" => $info->tipotax,
                        "precio" => $info->costounitario,
                        "costouni" => $info->costouni
                    );
                    $i++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades),
                    "count" => $i,
                    "array_string" => $array_string
                );
                
                echo json_encode($array);
            }
        }
        
        function importProductsIMEICompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum     = $this->input->post('trannum');
                $strDatos    = $this->input->post('strDatos');
                $tipoIngreso = $this->input->post('tipoIngreso');
                $idcatalog   = $this->input->post('idcatalogo');
                $idcentro    = $this->session->userdata('idcentrouser');
                $tipopro     = $this->session->userdata('tipoprod');

                $dB = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $dR = array("_", "_", "_", "_");
                $strDatos = str_replace($dB, $dR, $strDatos);
                
                $this->load->model('compras_model');
                
                if ($tipoIngreso == 1) {
                    $strArray = explode("_", $strDatos);
                    for($i=0; $i<count($strArray); $i++){
                        $infoProducto = explode(",", $strArray[$i]);
                        if(count($infoProducto) == 4){
                            $validate = $this->compras_model->insertIMEICompraLocal($trannum, $infoProducto[0], $infoProducto[1], $infoProducto[2], $infoProducto[3]);
                        }
                    }
                }

                $detalle = $this->compras_model->getInventarioByCatalog($trannum, $idcatalog, $idcentro, $tipopro);
                $datos   = $this->compras_model->getDataTran100kt($trannum, $idcentro);
                $cantidad = $this->compras_model->getCantidadesTran100kt($trannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($trannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "xpos" => $info->xpos,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "tipotax" => $info->tipotax,
                        "precio" => $info->costounitario,
                        "costouni" => $info->costouni
                    );
                    $i++;
                }
                
                $array = array(
                    'count'        => $i,
                    'items'        => $items,
                    'datos'        => $datos,
                    'cantidad'     => $cantidad,
                    'unidades'     => number_format($unidades),
                    'array_string' => $strArray
                );
                
                echo json_encode($array);
            }
        }

        function validateProductsIMEI(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $trannum     = $this->input->post('trannum');
                $strDatos    = $this->input->post('strDatos');
                $tipoIngreso = $this->input->post('tipoIngreso');
                
                $dB = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $dR = array("_", "_", "_", "_");
                $strDatos = str_replace($dB, $dR, $strDatos);
                
                $strError = ""; $i=0;
                $this->load->model('compras_model');
                
                if ($tipoIngreso == 1) {
                    $strArray = explode("_", $strDatos);
                    for($j=0; $j<count($strArray); $j++){
                        $infoProducto = explode(",", $strArray[$i]);
                        if(count($infoProducto) == 4){
                            $validate = $this->compras_model->validateProductsIMEI($infoProducto[0], $infoProducto[1], $infoProducto[2]);
                            switch($validate){
                                case 0:
                                    break;
                                case 1:
                                    $strError .= "El producto con modelo: <strong>'".$infoProducto[0]." ".$infoProducto[1]."'</strong> de la Línea: <strong>". ($j+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                    $i++;
                                    break;
                                case 2:
                                    $strError .= "El producto con IMEI: <strong>'".$infoProducto[2]."'</strong> de la Línea: <strong>". ($j+1) ."</strong> no puede ser ingresado porque ya existe. <br>";
                                    $i++;
                                    break;
                                default:
                                    break;
                            }
                        }else{
                            $strError .= "El producto de la Línea: <strong>'". ($j+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                            $i++;
                        }
                    }
                } else {
                    $i++;
                    $strError = "TIPOS DE INGRESO EN MANTENIMIENTO";
                }
                
                $array_send = array(
                    "errores" => $i,
                    "mensaje" => $strError
                );
                
                echo json_encode($array_send);
            }
        }
        
        function recostearCostosProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $trannum = $this->input->post('trannum');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->updateCostosUnitariosByBatchCompra($trannum);
                
                echo json_encode($array);
            }
        }
        
        function actualizarCostosProductosDesdeCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $trannum = $this->input->post('trannum');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->actualizarCostosProductosDesdeCompra($trannum);
                
                echo json_encode($array);
            }
        }
        
        function getProductsLista(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
				$this->load->model('compras_model');
				$informacion = $this->compras_model->getListadoProductos($trannum);
                $j=0;
                $array_datos = array();
                
                if($informacion!=false){
                    foreach($informacion as $info){
                        if($info->existe == 0){
                            $array_datos[$j] = array(
                                "idproducto" => $info->idproducto,
                                "descrip" => $info->descrip,
                                "costounitario" => $info->costounitario,
                                "idcatalogo" => $info->idcatalogo,
                                "linea" => $info->linea,
                                "nameproveedor" => $info->nameproveedor,
                                "modelo" => $info->modelo,
                                "um" => $info->um,
                                "precioventa" => $info->precioventa,
                                "marca" => $info->marca,
                                "tipotax" => $info->tipotax,
                            );

                            $j++;
                        }
                    }
                }
                echo json_encode($array_datos);
            }
        }
        
        function getProductsListaOC(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
                $tipopro = $this->input->post("tipopro");
                if($tipopro==false || $tipopro==null){
                    $tipopro=1;
                }
				$this->load->model('compras_model');
				$informacion = $this->compras_model->getListadoProductosOC($trannum,$tipopro);
                $j=0;
                $array_datos = array();
                
                if($informacion!=false){
                    foreach($informacion as $info){
                        if($info->existe == 0){
                            $array_datos[$j] = array(
                                "idproducto" => $info->idproducto,
                                "descrip" => $info->descrip,
                                "costounitario" => $info->costounitario,
                                "idcatalogo" => $info->idcatalogo,
                                "linea" => $info->linea,
                                "nameproveedor" => $info->nameproveedor,
                                "modelo" => $info->modelo,
                                "um" => $info->um,
                                "precioventa" => $info->precioventa,
                                "marca" => $info->marca,
                                "tipotax" => $info->tipotax,
                            );

                            $j++;
                        }
                    }
                }
                echo json_encode($array_datos);
            }
        }
        
        function getProductosHistorialProveedor(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
                $tipopro = $this->input->post("tipopro");
                $idproveedor = $this->input->post("idproveedor");
                
                if($tipopro==false || $tipopro==null){
                    $tipopro=1;
                }
				
                $this->load->model('compras_model');
				$informacion = $this->compras_model->getListadoProductosHistorial($trannum, $tipopro, $idproveedor);
                
                $j=0;
                $array_datos = array();
                
                if($informacion!=false){
                    foreach($informacion as $info){
                        if($info->existe == 0){
                            $array_datos[$j] = array(
                                "idproducto" => $info->idproducto,
                                "descrip" => $info->descrip,
                                "costounitario" => $info->costounitario,
                                "idcatalogo" => $info->idcatalogo,
                                "linea" => $info->linea,
                                "nameproveedor" => $info->nameproveedor,
                                "modelo" => $info->modelo,
                                "um" => $info->um,
                                "precioventa" => $info->precioventa,
                                "marca" => $info->marca,
                                "tipotax" => $info->tipotax,
                            );

                            $j++;
                        }
                    }
                }
                
                echo json_encode($array_datos);
            }
        }
        
        function insertarProductosToCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('trannum');
                $idcatalog = $this->input->post('idcatalogo');
                $idproductos = $this->input->post('idproductos');
                $idcentro = $this->session->userdata('idcentrouser');
                $tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $this->load->model('compras_model');
				
                if(trim($idproductos)!=""){
                    $array_string = explode(", ", $idproductos);
                    if(count($array_string)==0){
                        $insert = $this->compras_model->insertProCompraLocal($idtrannum,trim($array_string));
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $insert = $this->compras_model->insertProCompraLocal($idtrannum,trim($array_string[$i]));
                        }
                    }
                }
                
                $detalle = $this->compras_model->getInventarioByCatalog($idtrannum, $idcatalog, $idcentro, $tipopro);
                $datos = $this->compras_model->getDataTran100kt($idtrannum, $idcentro);
                $cantidades = $this->compras_model->getCantidadesCatalogo($idtrannum, $idcentro, $tipopro);
                $cantidad = $this->compras_model->getCantidadesTran100kt($idtrannum);
                $unidades = $this->compras_model->getUnidadesTran100kt($idtrannum);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "tipotax" => $info->tipotax,
                        "precio" => $info->costounitario,
                        "costouni" => $info->costouni
                    );
                    $i++;
                }
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades),
                    "count" => $i,
                    "sumagrupos" => $cantidades,
                );
                
                echo json_encode($array);
            }
        }
        
        function insertarProductosOC(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idtrannum = $this->input->post('trannum');
                $idcatalog = $this->input->post('idcatalogo');
                $idproductos = $this->input->post('idproductos');
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('compras_tipopro');
                $tipopro = $this->input->post('tipopro');

                $this->load->model('compras_model');
                $this->load->model('catalog_model');
				
                if(trim($idproductos)!=""){
                    $array_string = explode(", ", $idproductos);
                    if(count($array_string)==0){
                        $insert = $this->compras_model->insertProOC($idtrannum,trim($array_string));
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $insert = $this->compras_model->insertProOC($idtrannum,trim($array_string[$i]));
                        }
                    }
                }
                
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalog,$idcentro, $tipopro);
                $datos = $this->compras_model->getDatosOrden100k($idtrannum,$idcentro);
                $linea = $this->catalog_model->getNameCatalog($idcatalog);
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "costouni" => $info->costouni,
                            "periodo" => $info->periodo,
                        );
                        $i++;
                    }
                }
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "linea" => $linea,
                );
                
                echo json_encode($array);
            }
        }
        
        function allowInsertProductsOC(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $tipo_ingreso = $this->input->post('tipo_ingreso');
                $string_insert = $this->input->post('productos');
                $idtrannum = $this->input->post('idtrannum');
                $this->load->model('compras_model');
                $cadena_lineas = "";
                $cant_errores = 0;

                $datoBusqueda = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $datoRemplazo = array("_", "_", "_", "_");
                $string_insert = str_replace($datoBusqueda, $datoRemplazo, $string_insert);

                if($tipo_ingreso==1){
                    //codigo interno
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==3){
                            $insert = $this->compras_model->verifyInsertProductOC($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==3){
                                $insert = $this->compras_model->verifyInsertProductOC($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con código: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                }
                else if($tipo_ingreso==2){
                    //codigo de barras
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==3){
                            $insert = $this->compras_model->verifyInsertProductCodBarraOC($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==3){
                                $insert = $this->compras_model->verifyInsertProductCodBarraOC($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con código de barras: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                    
                }
                else if($tipo_ingreso==3){
                    //modelo
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==3){
                            $insert = $this->compras_model->verifyInsertProductModeloOC($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==3){
                                $insert = $this->compras_model->verifyInsertProductModeloOC($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con modelo: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                        
                }
                else if($tipo_ingreso==4){
                    //modelo
                    $array_string = explode("_", $string_insert);
                    $cadena_errores = 0;
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==3){
                            $insert = $this->compras_model->verifyInsertProductXPOSOC($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            switch($insert){
                                case 1:
                                    $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> no puede ser ingresado porque no existe o está inactivo.";
                                    $cant_errores++;
                                    break;
                            }
                        }else{
                            $cadena_lineas .= "Datos incompletos.";
                            $cant_errores++;
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==3){
                                $insert = $this->compras_model->verifyInsertProductXPOSOC($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                                switch($insert){
                                    case 0:
                                        break;
                                    case 1:
                                        $cadena_lineas .= "El producto con código XPOS: <strong>'".$array_producto[0]."'</strong> de la Línea: <strong>". ($i+1) ."</strong> no puede ser ingresado porque no existe o está inactivo. <br>";
                                        $cant_errores++;
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                $cadena_lineas .= "El producto de la Línea: <strong>'". ($i+1) ."'</strong> no puede ser ingresado porque tiene datos incompletos. <br>";
                                $cant_errores++;
                            }
                        }
                    }
                        
                }
                else{
                    $cant_errores++;
                    $cadena_lineas = "TIPOS DE INGRESO EN MANTENIMIENTO";
                }
                $array_send = array(
                    "errores" =>$cant_errores,
                    "mensaje" =>$cadena_lineas,
                );
                
                echo json_encode($array_send);
            }
        }
                                
        function importProductsCompraOC(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{ 
                $tipo_ingreso = $this->input->post('tipo_ingreso');
                $string_insert = $this->input->post('productos');
                $idtrannum = $this->input->post('idtrannum');
                $idcatalog = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('compras_tipopro');
                $tipopro = $this->input->post('tipopro');

                $datoBusqueda = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $datoRemplazo = array("_", "_", "_", "_");
                $string_insert = str_replace($datoBusqueda, $datoRemplazo, $string_insert);
                

                $this->load->model('compras_model');
                if($tipo_ingreso==1){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==3){
                            $insert = $this->compras_model->insertLineOC($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==3){
                                $insert = $this->compras_model->insertLineOC($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            }
                        }
                    }
                }else if($tipo_ingreso==2){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==3){
                            $insert = $this->compras_model->insertLineOCCodBarra($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==3){
                                $insert = $this->compras_model->insertLineOCCodBarra($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            }
                        }
                    }
                }else if($tipo_ingreso==3){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==3){
                            $insert = $this->compras_model->insertLineOCModelo($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==3){
                                $insert = $this->compras_model->insertLineOCModelo($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            }
                        }
                    }
                }else if($tipo_ingreso==4){
                    $array_string = explode("_", $string_insert);
                    if(count($array_string)==0){
                        $array_producto = explode(",", $array_string);
                        if(count($array_producto)==3){
                            $insert = $this->compras_model->insertLineOCXPOS($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                        }
                    }else{
                        for($i = 0; $i< count($array_string); $i++){
                            $array_producto = explode(",", $array_string[$i]);
                            if(count($array_producto)==3){
                                $insert = $this->compras_model->insertLineOCXPOS($idtrannum,$array_producto[0],$array_producto[1],$array_producto[2]);
                            }
                        }
                    }
                }
                
                $detalle = $this->compras_model->getInventarioByCatalogOrders($idtrannum,$idcatalog,$idcentro, $tipopro);
                $datos = $this->compras_model->getDatosOrden100k($idtrannum,$idcentro);
                
                $i=0;
                $items = array();
                foreach($detalle as $info){
                    $items[$i] = array(
                        "nameproducto" => $info->descrip,
                        "marca" => $info->marca,
                        "modelo" => $info->modelo,
                        "upc" => $info->barcode,
                        "notas" => $info->notas,
                        "idproducto" => $info->idproducto,
                        "um" => $info->um,
                        "imagen" => $info->imagen,
                        "cantidad" => $info->cantidad,
                        "tipotax" => $info->tipotax,
                        "precio" => $info->costounitario,
                        "precioventa" => $info->precioventa,
                        "costouni" => $info->costouni,
                        "periodo" => $info->periodo,
                    );
                    $i++;
                }
                $lines = 0;
                $units = 0;
                if($datos!=false){
                    foreach($datos as $dat){
                        $lines++;
                        $units = $units + abs($dat->cantidad);
                    }
                }
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "count" => $i,
                    "array_string" => $array_string,
                    "lu" => $lines."/".$units
                );
                echo json_encode($array);
            }
        }
        
        function verificaTranRef(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
                
                $this->load->model('compras_model');
				$existe = $this->compras_model->verificaTranRef($trannum);
                
                echo json_encode($existe);
            }
        }
        
        function anularOrdenCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post("trannum");
                
                $this->load->model('compras_model');
				$query = $this->compras_model->cambiarEstado($trannum,9);
                
                echo json_encode($query);
            }
        }
        
        function devolucionesSobreCompras($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $tipopro = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'tipoprod' => $tipopro,
                    'tipo_producto_devolucion' => $tipopro
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('compras_model'); $this->load->model('global_model');
                
				$controlador = $this->uri->segment(1);
				$idcentro = $this->session->userdata('idcentrouser');
                
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
				$this->data['descrip'] = $this->compras_model->getDescripTipoPro($tipopro);
                $this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['compras'] = $this->compras_model->getTiposComprasDevoluciones("CO");
                $this->data['proveedores_ordenes'] = $this->compras_model->getListadopProveedoresOrdenes("CO", $tipopro, $idcentro);
                $this->data['periodos'] = $this->compras_model->getPeriodosCompras(1);
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;
                $this->data['tipo_producto_devolucion'] = $tipopro;

                $this->load->view('mantenimiento_devoluciones_compras', $this->data); 
            }
        }
        
        function getListadoDevolucionesCompras(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post('tipoprod');
				$idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $datos = $this->compras_model->getListadoDevolucionesOrdenes('CO', $tipopro, $idcentro, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                foreach($datos as $info){
                    $linea = 0; $canti = 0;
					
                    if($info->valcosto == null || $info->valcosto == ""){
                        $valcosto = 0;
                    }else{
                        $valcosto = number_format(abs($info->valcosto), 2, '.', '') + number_format(abs($info->valtax1), 2, '.', '') + number_format($info->valtax5, 2, '.', '');
                    }
                    
                    if($info->fecha4=="0000-00-00"){
                        $fechacierre  = "";
                    }else{
                        $fechacierre  = $info->fecha4;
                    }
                    
                    $informacion = $this->compras_model->getDetalleDevolucionesCompra($info->trannum);
                    
                    foreach($informacion as $cmp){
                        $linea++;
                        $canti += abs($cmp->cantidad);
                    }
                    
                    $serieNumeroDocumento = "SIN DOCUMENTO";
                    $numDocumento = "";
                    if($info->tranref != 0){
                        $serieNumeroDocumento = $this->compras_model->getSerieNumeroDocumento($info->tranref);
                    }
                    
                    if($info->numero != 0){
                        $numDocumento = $info->serie.''.$info->numero;
                    }
                    
                    $array[$i] = array(
						"trannum" => $info->trannum,
                        "fecha" => $info->fecha3,
                        "fecact" => $fechacierre,
                        "estatus" => $info->estatus,
                        "descrip" => $info->descrip,
                        "serie" => $numDocumento,
                        "referencia" => $info->referencia,
                        "valventa" => $valcosto,
						"documentoReferencia" => $serieNumeroDocumento,
						"lineaunidad" => $linea.'/'.number_format($canti)
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
        function getPendientesImpresionDevolucionesCompras(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //$tipopro = $this->session->userdata('tipoprod');
                $tipopro = $this->input->post('tipoprod');
                $estado = 0;
				
                $this->load->model('compras_model');
                $datos = $this->compras_model->getListadoImpresionDevolucionOrdenes('CO', $estado, $tipopro);
                
                $i=0;
                $items = array();
                foreach($datos as $info){
					$items[$i] = array(
						"trannum" => $info->trannum,
                        "nameproveedor" => $info->descrip,
                        "numero" => $info->serie.''.$info->numero,
                    );
                    $i++;
                }
                
				if($i == 0){
					$i = "0";
				}
				
				$array = array(
					"cantidad" => $i,
					"datos" => $items
				);
                echo json_encode($array);
            }
        }
        
        function getListadoDocumentosComprasProveedores(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post('tipoprod');
				$idcentro = $this->session->userdata('idcentrouser');
                $idproveedor = $this->input->post("idproveedor");
                
                $this->load->model('compras_model');
                $informacion = $this->compras_model->getDocumentosComprasProveedores('CO', $tipopro, $idcentro, $idproveedor);
                
                $i=1;
                $array = array();
                
                $array[0] = array(
                    "id" => 0,
                    "descrip" => "SIN N° DE DOCUMENTO"
                );
                
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "id" => $info->trannum,
                            "descrip" => "N°".$info->serie."".$info->numero." ".$info->fechaFormateada." ".$this->session->userdata('simboloMoneda').number_format($info->valcosto, 2, '.', ',')
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function adicionarDevolucionSobreCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproveedor = $this->input->post('idproveedor');
                $idtipo = $this->input->post('idtipo');
                $fecha = $this->input->post('fecha');
                $idperiodo = $this->input->post('idperiodo');
                $idsolicita = $this->input->post('idsolicita');
                $idaplicado = $this->input->post('idaplicado');
                $notas = trim($this->input->post('notas'));
                $idcentro = $this->session->userdata('idcentrouser');
                $tipopro = $this->input->post('tipoprod');

                $this->load->model('compras_model');
                $array = $this->compras_model->adicionarDevolucionSobreCompra($idproveedor, $idtipo, $fecha, $idperiodo, $idsolicita, $idaplicado, $notas, $idcentro, $tipopro);
                
                echo json_encode($array);
            }
        }
        
        function detalleDevolucionesSobreCompras($trannum, $tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum,
                    'tipo_producto_devolucion' => $tipopro
                );
                $this->session->set_userdata($resultAppName);
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model'); $this->load->model('invtran_model');
                $this->load->model('global_model');
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['compras'] = $this->compras_model->getTiposCompras("CO");
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['cantidades'] = $this->compras_model->getTotalCantidades($trannum);
                $this->data['unidades'] = $this->compras_model->getTotalUnidades($trannum);
                $this->data['tipo_pro'] = $tipopro;
                $informacion = $this->compras_model->getInformacionOrden($trannum);
                $this->data['informacion'] = $informacion;
                $this->data['serieDocumentoRef'] = "";
                $this->data['numeroDocumentoRef'] = "";
                
                foreach($informacion as $key){
                    $this->data['estatus'] = $key->estatus;
                    $this->data['formasdePago'] = $this->compras_model->getFormasdePagoDevolucionesCompra($key->idclase);
                    $this->data['trannumProductos'] = $key->tranref;
                    
                    if($key->tranref != 0){
                        $this->data['serieDocumentoRef'] = $this->compras_model->getSerieDocumento($key->tranref);
                        $this->data['numeroDocumentoRef'] = $this->compras_model->getNumeroDocumento($key->tranref);
                    }
                }
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detalle_devolucion_compra', $this->data); 
            }
        }
        
        function getListadoProductosByReferencia(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $referencia = $this->input->post('referencia');
                $tipoproducto = $this->input->post('tipoproducto');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $informacion = $this->compras_model->getListadoProductosByReferencia($trannum, $referencia, $tipoproducto, $idcentro);
                
                $i=0;
                $datos = array();
                foreach($informacion as $info){
                    if($info->existe == "0"){
                        $datos[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precio" => $info->costounitario,
                            "precioventa" => $info->precioventa,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "costouni" => $info->costouni
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function getInventarioByCatalogoDevoluciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post('tipoprod');
                
                $this->load->model('compras_model');
                $detalle = $this->compras_model->getInventarioByCatalogoDevoluciones($trannum, $idcatalogo, $idcentro, $tipopro);
                
                $i=0;
                $datos = array();
                foreach($detalle as $info){
					$datos[$i] = array(
						"nameproducto" => $info->descrip,
						"marca" => $info->marca,
						"modelo" => $info->modelo,
						"upc" => $info->barcode,
						"notas" => $info->notas,
						"idproducto" => $info->idproducto,
						"um" => $info->um,
						"imagen" => $info->imagen,
						"cantidad" => $info->cantidad,
						"tipotax" => $info->tipotax,
						"precio" => $info->costounitario,
						"precioventa" => $info->precioventa,
                        "idbin" => $info->idbin,
                        "idbatch" => $info->idbatch,
						"costouni" => $info->costouni
					);
					$i++;
                }
                
                $array = array(
                    "datos" => $datos,
                    "cantidad" => $i
                );
                
                echo json_encode($array);
            }
        }
        
        function insertarProductoDevolucionCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idproducto = $this->input->post('idproducto');
                $cantidad = $this->input->post('cantidad');
                $precio = $this->input->post('precio');
                $tipotax = $this->input->post('tipotax');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $idbin = $this->input->post('idbin');
                $idbatch = $this->input->post('idbatch');
                $notas = trim($this->input->post('notas'));
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post('tipoprod');
                $trannumReferencia = $this->input->post('trannumReferencia');
                
                $this->load->model('compras_model');
                $this->load->model('invtran_model');
                
                $sinInv = 0;

                $invActual = $this->invtran_model->getExistenciasProducto($idproducto, $idcentro, null);
               
                //Valida que el producto tenga existencias 
                if($invActual['cantidad'] <= 0){
                    $sinInv = 1;
                }

                //verifica si el producto posee existencias suficientes
                if($cantidad > $invActual['cantidad'] && $sinInv != 1){
                    $cantidad = $invActual['cantidad'];
                    $sinInv = 2;
                }

                //No ingresa el detalle de la devolucion si el producto no posee existencias 
                if($sinInv != 1){
                    $this->compras_model->insertarProductoDevolucionCompra($trannum, $idproducto, $idcentro, $cantidad, $um, $uniconv, $idbin, $idbatch, $precio, $tipotax, $notas);
                }

                if($trannumReferencia == 0){
                    $detalle = $this->compras_model->getInventarioByCatalogoDevoluciones($trannum, $idcatalogo, $idcentro, $tipopro);
                }else{
                    $detalle = $this->compras_model->getListadoProductosByReferencia($trannum, $trannumReferencia, $tipopro, $idcentro);
                }
                
                if($trannumReferencia == 0){
                    $datos = $this->compras_model->getDatosDevolucionesSobreCompra($trannum, $idcentro);
                }else{
                    $datos = $this->compras_model->getDatosDevolucionesSobreCompraReferencia($trannum, $trannumReferencia, $idcentro);
                }
                
                $cantidad = $this->compras_model->getTotalCantidades($trannum);
                $unidades = $this->compras_model->getTotalUnidades($trannum);

                $i=0;
                $items = array();
                foreach($detalle as $info){
                    //validacion duplicidad
					if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precioventa" => $info->precioventa,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precio" => $info->costounitario,
                            "costouni" => $info->costouni
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades),
                    "count" => $i,
                    "sinInventario" => $sinInv
                );
                
                echo json_encode($array);
            }
        }
        
        function modificarProductoDevolucionCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $idproducto = $this->input->post('idproducto');

                $trannum = $this->input->post('idtrannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $idcentro = $this->session->userdata('idcentrouser');
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post('tipoprod');
                $cantidad = $this->input->post('cantidad');
                $um = $this->input->post('um');
                $uniconv = $this->input->post('uniconv');
                $notas = trim($this->input->post('notas'));
                $precio = $this->input->post('precio');
                $trannumReferencia = $this->input->post('trannumReferencia');
                
                $this->load->model('compras_model');
                $this->load->model('invtran_model');
                
                $sinInv = false;
                $invActual = $this->invtran_model->getExistenciasProducto($idproducto, $idcentro, $trannum);
                if($cantidad > $invActual['cantidad']){
                    $cantidad = $invActual['cantidad'];
                    $sinInv = true;
                }
                
                $this->compras_model->modificarProductoDevolucionCompra($idrec, $cantidad, $precio, $notas, $um, $uniconv);
                
                if($trannumReferencia == 0){
                    $detalle = $this->compras_model->getInventarioByCatalogoDevoluciones($trannum, $idcatalogo, $idcentro, $tipopro);
                }else{
                    $detalle = $this->compras_model->getListadoProductosByReferencia($trannum, $trannumReferencia, $tipopro, $idcentro);
                } 
                
                if($trannumReferencia == 0){
                    $datos = $this->compras_model->getDatosDevolucionesSobreCompra($trannum, $idcentro);
                }else{
                    $datos = $this->compras_model->getDatosDevolucionesSobreCompraReferencia($trannum, $trannumReferencia, $idcentro);
                }
                
                $cantidad = $this->compras_model->getTotalCantidades($trannum);
                $unidades = $this->compras_model->getTotalUnidades($trannum);

                $i=0;
                $items = array();
                foreach($detalle as $info){
                    if($info->existe == "0"){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "tipotax" => $info->tipotax,
                            "precioventa" => $info->precioventa,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precio" => $info->costounitario,
                            "costouni" => $info->costouni
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $cantidad,
                    "unidades" => number_format($unidades),
                    "count" => $i,
                    "sinInventario" => $sinInv

                );
                
                echo json_encode($array);
            }
        }
        
        function getListadoLineasDevolucionesCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
				//$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post('tipoprod');
                $idcentro = $this->session->userdata('idcentrouser');
                
				$this->load->model('compras_model');
				$informacion = $this->compras_model->getGroupsProductosDevolucionCompra($trannum, $tipopro, $idcentro);
				
				$i=0;
				$array = array();				
				foreach($informacion as $info){
                    $array[$i] = array(
                        "idcatalogo" => $info->idcatalogo,
                        "imagen" => trim($info->imagen),
                        "descrip" => trim($info->descrip)
                    );
                    $i++;
				}
				
                echo json_encode($array);
            }
		}
        
        function getDatosDevolucionesSobreCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $trannumReferencia = $this->input->post('trannumReferencia');
                $idcentro = $this->session->userdata('idcentrouser');
				
                $this->load->model('compras_model');
                
                if($trannumReferencia == 0){
                    $array = $this->compras_model->getDatosDevolucionesSobreCompra($trannum, $idcentro);
                }else{
                    $array = $this->compras_model->getDatosDevolucionesSobreCompraReferencia($trannum, $trannumReferencia, $idcentro);
                }

                echo json_encode($array);
            }
        }
        
        function getValidateDevolucionCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				$trannumReferencia = $this->input->post('trannumReferencia');
				
				$this->load->model('compras_model');
				$cantidad = $this->compras_model->getTotalCantidades($trannum);
                $provee_tipo = $this->compras_model->getTipoProveedorCompra($trannum);
				$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
				
                $valExentas = 0; $valGravadas = 0; $generarPerRet = 0;
                $valIVA = 0; $valTotal = 0; $percepcion = 0; $retencion = 0;
                
				if($cantidad <= 0){
					$error = 1;
				}else{
					$result = $this->compras_model->getValidateCantidadesDevolucion($trannum);
					if($result > 0){
						$error = 2;
					}else{
                        $result2 = $this->compras_model->getValidatePreciosDevolucion($trannum);
                        if($result2 > 0){
                            $error = 3;
                        }else{
                            $error = 4;
                            $informacion = $this->compras_model->getProductosDevolucionCompra($trannum);
                            
                            if($trannumReferencia != 0){
                                $generarPerRet = $this->compras_model->verificacionDeCompraPercepcionRetencion($trannumReferencia);
                            }
                            
                            $i=0; $unidades=0;
                            foreach($informacion as $info){
                                if($info->tax1 == 0){
                                    $valExentas = $valExentas + (abs($info->cantidad) * $info->preciotran);
                                }else{
                                    $valIVA = $valIVA + ((abs($info->cantidad) * $info->preciotran) * ($info->tax1 / 100));
                                    $valGravadas = $valGravadas + (abs($info->cantidad) * $info->preciotran);
                                }
                                
                                $i++;
                                $unidades = $unidades + abs($info->cantidad);
                            }
                            
                            $valExentas = round($valExentas, 2);
                            $valGravadas = round($valGravadas, 2);
                            $valIVA = round($valIVA, 2);
                            
                            $valTotal = $valExentas + $valGravadas + $valIVA;
                            
                            if($generarPerRet == 1){
                                if($empper == 1){
                                    if($provee_tipo != 3){
                                        $retencion = number_format($valGravadas, 2, '.', '') * 0.01;
                                        $valTotal = number_format($valTotal, 2, '.', '') - number_format($retencion, 2, '.', '');
                                    }else{
                                        $valTotal = number_format($valTotal, 2, '.', '');
                                    }
                                }else{
                                    if($provee_tipo == 3){
                                        $percepcion = number_format($valGravadas, 2, '.', '') * 0.01;
                                        $valTotal = number_format($valTotal, 2, '.', '') + number_format($percepcion, 2, '.', '');
                                    }else{
                                        $valTotal = number_format($valTotal, 2, '.', '');
                                    }
                                }
                            }else{
                                if($empper == 1){
                                    if($provee_tipo != 3){
                                        if($valGravadas >= 100){
                                                $retencion = number_format($valGravadas, 2, '.', '') * 0.01;
                                                $valTotal = number_format($valTotal, 2, '.', '') - number_format($retencion, 2, '.', '');
                                        }else{
                                            $valTotal = number_format($valTotal, 2, '.', '');
                                        }
                                    }else{
                                        $valTotal = number_format($valTotal, 2, '.', '');
                                    }
                                }else{
                                    if($provee_tipo == 3){
                                        if($valGravadas >= 100){
                                                $percepcion = number_format($valGravadas, 2, '.', '') * 0.01;
                                                $valTotal = number_format($valTotal, 2, '.', '') + number_format($percepcion, 2, '.', '');
                                        }else{
                                            $valTotal = number_format($valTotal, 2, '.', '');
                                        }
                                    }else{
                                        $valTotal = number_format($valTotal, 2, '.', '');
                                    }
                                }
                            }
                            
                            $valTotal = round($valTotal, 2);
                        }
					}
				}
                
                $array = array(
                    'error' => $error,
                    'valExentas' => number_format($valExentas, 4, '.', ','),
                    'valGravadas' => number_format($valGravadas, 4, '.', ','),
                    'valIVA' => number_format($valIVA, 4, '.', ','),
                    'valTotal' => number_format($valTotal, 2, '.', ','),
                    'retencion' => $retencion,
                    'percepcion' => $percepcion,
                    'lineas' => $i,
                    'unidades' => $unidades
                );
				
				echo json_encode($array);
			}
		}
        
        function cerrarDevolucionCompra(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum            = $this->input->post('idtrannum');
				$serie              = $this->input->post('serie');
				$fecha              = $this->input->post('fecha');
				$numero             = $this->input->post('numero');
				$solicita           = $this->input->post('solicita');
				$idproveedor        = $this->input->post('idproveedor');
				$cajclase           = $this->input->post('cajclase');
				$notas              = trim($this->input->post('notas'));
				$valorTotal         = $this->input->post('valorTotal');
				$valorRetencion     = $this->input->post('valorRetencion');
				$numDocRetencion    = $this->input->post('numDocRetencion');
				$valorPercepcion    = $this->input->post('valorPercepcion');
				$numDocPercepcion   = $this->input->post('numDocPercepcion');
				
                $tipoDocumento      = $this->input->post('tipoDocumento');
                $numControl         = $this->input->post('numControl');
                $codigoGeneracion   = $this->input->post('codigoGeneracion');
                $selloRecepcion     = $this->input->post('selloRecepcion');
                
                $this->load->model('global_model');
				$this->load->model('compras_model');
				$idclase = $this->compras_model->cerrarDevolucionCompra($trannum, $serie, $fecha, $numero, $notas, $valorRetencion, $valorPercepcion);
				$this->compras_model->generacionCreditVoucher($trannum, $idclase, $fecha, 'CO', $cajclase, $idproveedor, $serie, $numero, $valorTotal, $notas);
                
                $insertado = 0;
                if($valorRetencion != 0){
                    $insertado = 1;
					$this->compras_model->insertarRegTran100pRetencion($trannum, $numDocRetencion);
				}
				
				if($valorPercepcion != 0){
                    $insertado = 1;
					$this->compras_model->insertarRegTran100pRetencion($trannum, $numDocPercepcion);
				}
				
                if($insertado == 0){
                    $this->global_model->insertarRegTran100p($trannum);
                }

                $array = $this->compras_model->callTotaliza100($trannum, 1);

                if ( $tipoDocumento == 1 ) {
                    $this->load->model('dte_model');
                    $this->dte_model->updateDatosDTE($trannum, $numControl, $codigoGeneracion, $selloRecepcion, '', '', '');
                }

				echo json_encode($array);
			}
		}
        
        function getDatosSearchDevoluciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $prosearch = $this->input->post('prosearch');
                $dato = $this->input->post('dato');
                $idcentro = $this->session->userdata('idcentrouser');
                $trannum = $this->input->post('idtrannum');
                //$tipopro = $this->session->userdata('tipoprod');
                //$tipopro = $this->session->userdata('tipo_producto_compra');
                $tipopro = $this->input->post('tipoprod');
                
                $this->load->model('compras_model');
                $detalle = $this->compras_model->getDatosProductoSearchDevoluciones($prosearch, $dato, $idcentro, $trannum, $tipopro);
                if($detalle != 0){
                    $i=0;
                    $agregado=0;
                    $items = array();
                    foreach($detalle as $info){
						//validacion duplicidad
                        if($info->existe == "0"){
                            $items[$i] = array(
                                "nameproducto" => $info->descrip,
                                "marca" => $info->marca,
                                "modelo" => $info->modelo,
                                "upc" => $info->barcode,
                                "notas" => $info->notas,
                                "idproducto" => $info->idproducto,
                                "um" => $info->um,
                                "imagen" => $info->imagen,
                                "cantidad" => $info->cantidad,
                                "tipotax" => $info->tipotax,
                                "namecatalogo" => $info->namecatalogo,
                                "precioventa" => $info->precioventa,
                                "idbin" => $info->idbin,
                                "idbatch" => $info->idbatch,
                                "precio" => $info->costounitario,
                                "costouni" => $info->costouni,
								"agregado" => 0
                            );
                            $i++;
                        }
                    }
                    
                    if($agregado == 1 && $i == 1){
						$datos = $this->compras_model->getDataTran100kProducto($trannum, $idcentro, $info->idproducto);
						$array = array(
                            "error" => "2",
							"datos" => $datos
                        );
                    }else{
                        $array = array(
                            "error" => "0",
                            "cantidad" => $i,
                            "datos" => $items
                        );
                    }
                }else{
                    $array = array(
                        "error" => "1",
                        "cantidad" => "0"
                    );
                }
                echo json_encode($array);
            }
        }

        function recepcionDeMercaderia($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionesApp = $this->configuracion_model->getProCentro($idApp);
                $infoopc = explode(",", $opcionesApp);
                $tipopro = $infoopc[0];

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'tipoprod' => $tipopro,
                    'tipo_producto_compra' => $tipopro
                );
                $this->session->set_userdata($resultAppName);
				
				$this->load->model('compras_model');
                $this->load->model('global_model');
                
                $direccion = $this->uri->segment(1);
				$idcentro = $this->session->userdata('idcentrouser');
                
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['descrip'] = $this->compras_model->getDescripTipoPro($tipopro);
                $this->data['tipo_producto_compra'] = $tipopro;
                
                $this->load->view('mantenimiento_recepcionmercaderia', $this->data); 
            }
        }

        function getListadoComprasRM(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipopro = $this->input->post('tipoproducto');
				$idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $datos = $this->compras_model->getListadoComprasRM('CO', $tipopro, $idcentro, 0);
                
                $i=0;
                $array = array();
                foreach($datos as $info){
                    $linea = 0; $canti = 0;
					
                    if($info->valcosto == null || $info->valcosto == ""){
                        $valcosto = 0;
                    }else{
                        $valcosto = number_format($info->valcosto, 2, '.', '');
                    }
                    
                    if($info->fecha4 == "0000-00-00"){
                        $fechacierre  = "";
                    }else{
                        $fechacierre  = $info->fecha4;
                    }
                    
                    $informacion = $this->compras_model->getDetalleLineasCompraRM($info->trannum);
                    foreach($informacion as $cmp){
                        $linea++;
                        $canti += $cmp->cantidad;
                    }
                    
                    $array[$i] = array(
						"trannum" => $info->trannum,
                        "fecha" => $info->fecha3,
                        "fecact" => $fechacierre,
                        "estatus" => $info->estatus,
                        "descrip" => $info->descrip,
                        "serie" => $info->serie.''.$info->numero,
                        "referencia" => $info->referencia,
                        "valventa" => $valcosto,
						"notas" => $info->notas,
						"lineaunidad" => $linea.'/'.number_format($canti)
                    );
                    $i++;
                }
                    
                echo json_encode($array);
            }
        }

        function detalleRecepcionDeMercaderia($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                
                $direccion = $this->uri->segment(1);
                $tipopro = $this->session->userdata('tipo_producto_compra');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('producto_model'); $this->load->model('configuracion_model');
                $this->load->model('compras_model'); $this->load->model('invtran_model');
                $this->load->model('global_model'); $this->load->model('variable_model');
                
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['tipo_pro'] = $tipopro;
                $this->data['tipo_tax'] = $this->producto_model->getTipoTax();
                $this->data['departamentos'] = $this->producto_model->viewDepartamentosTipo($tipopro);
                $this->data['subdepartamentos'] = $this->producto_model->viewsubDepartamentosTipo($tipopro);
                $this->data['modelos'] = $this->producto_model->getListadoModelosProductos();
                $this->data['modeloskm'] = $this->compras_model->getListadoModelosTran100km($trannum);
                $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
                $this->data['medidas'] = $this->producto_model->verUM();
                $opcionesApp = $this->configuracion_model->getProCentro($this->session->userdata('iddApp'));
                $informacion = $this->compras_model->getInformacionOrden($trannum);
                $this->data['informacion'] = $informacion;
                $lineas=0; $totalunidades=0;
                $dataLineas = $this->compras_model->getDetalleLineasCompraRM($trannum);
                foreach($dataLineas as $cmp){
                    $lineas++;
                    $totalunidades += $cmp->cantidad;
                }
                $this->data['lineas'] = $lineas;
				$this->data['unidades'] = $totalunidades;
                
                foreach($informacion as $key){
                    $this->data['estatus'] = $key->estatus;
                }
                
                $editCostos=0; $editPrecio=0; $editPrecio=0; $editMayusc=0; $desingModel=0;
                $infOpc = explode(",", $opcionesApp);
                for($i=0; $i<count($infOpc); $i++){
                    if($i==1){
                        $editCostos = $infOpc[$i];
                    }else if($i==2){
                        $editPrecio = $infOpc[$i];
                    }else if($i==3){
                        $editMayusc = $infOpc[$i];
                    }else if($i==4){
                        $desingModel = $infOpc[$i];
                    }
                }

                $this->data['editCostos'] = $editCostos;
                $this->data['editPrecio'] = $editPrecio;
                $this->data['editMayusc'] = $editMayusc;
                $this->data['desingModel'] = $desingModel;
                $this->load->view('mantenimiento_detalle_recepcionm', $this->data); 
            }
        }

        function getlistadoProductosPorModelo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $modelo = $this->input->post('modelo');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->getlistadoProductosPorModelo($modelo, $idcatalogo);
                
                echo json_encode($array);
            }
        }

        function getInformacionRecepcionDeMercaderia(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->getInformacionRecepcionDeMercaderia($trannum);
                
                echo json_encode($array);
            }
        }

        function getInformacionRecepcionModelo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $modelo = $this->input->post('modelo');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->getInformacionRecepcionModelo($trannum, $modelo);
                
                echo json_encode($array);
            }
        }

        function insertarProductosTran100km(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcatalogo = $this->input->post('idcatalogo');
                $iddepto = $this->input->post('iddepto');
                $modelo = trim($this->input->post('modelo'));
                $marca = trim($this->input->post('marca'));
                $descrip = trim($this->input->post('descrip'));
                $um = trim($this->input->post('um'));
                $variantes = $this->input->post('variantes');
                $disenos = $this->input->post('disenos');
                $costounitario = $this->input->post('costounitario');
                $precio = $this->input->post('precio');
                $impuesto = $this->input->post('impuesto');
                $descuento = $this->input->post('descuento');
                $editmayusc = $this->input->post('editmayusc');
                $tipopro = $this->session->userdata('tipo_producto_compra');
                
                $this->load->model('compras_model');
                $this->load->model('producto_model');
                
                //$validate = $this->compras_model->validateProductoModelo($trannum, $modelo);
                //$validate = 0;
                $infoInsertProductos = $this->compras_model->validateProductosModeloVariantes($trannum, $modelo, $variantes, $disenos);
                $validate = count($infoInsertProductos);
                
                if($validate == 0){
                    $this->compras_model->insertarProductosTran100km($trannum, $idcatalogo, $modelo, $marca, $descrip, $um, $variantes, $disenos, $costounitario, $precio, $impuesto, $descuento, $editmayusc);
                    $infoGrid = $this->compras_model->getInformacionRecepcionDeMercaderia($trannum);
                    $departamentos = $this->producto_model->viewDepartamentosTipo($tipopro);
                    $subdepartamentos = $this->producto_model->viewsubDepartamentosTipo($tipopro);
                    $modelos = $this->producto_model->getListadoModelosProductos();
                    $modeloskm = $this->compras_model->getListadoModelosTran100km($trannum);
                    
                    $numLineas=0; $numUnidades=0;
                    $infoLineas = $this->compras_model->getDetalleLineasCompraRM($trannum);
                    foreach($infoLineas as $infLin){
                        $numLineas++;
                        $numUnidades += $infLin->cantidad;
                    }

                    $i=0;
                    $dataSourceLineas = array();
                    foreach($departamentos as $dep){
                        $expanded = false;
                        if($dep->idcatalogo == $iddepto){
                            $expanded = true;
                        }
                        $dataSourceLineas[$i] = array(
                            "id" => "$dep->idcatalogo",
                            "itemnivel" => 1,
                            "expanded" => $expanded,
                            "descrip" => str_replace(array("\n", "\r", "\n\r"), " ", trim($dep->departamento)),
                        );
                        
                        $i++;
                        foreach($subdepartamentos as $sub){
                            if($sub->idnivel1 == $dep->idcatalogo){
                                $expanded = false;
                                if($sub->idcatalogo == $idcatalogo){
                                    $expanded = true;
                                }

                                $dataSourceLineas[$i] = array(
                                    "id" => $dep->idcatalogo . "_" . $sub->idcatalogo,
                                    "idcatalogo" => "$sub->idcatalogo",
                                    "itemnivel" => 2,
                                    "expanded" => $expanded,
                                    "descrip" => str_replace(array("\n", "\r", "\n\r"), " ", trim($sub->subdepartamento)),
                                    "departamento" => str_replace(array("\n", "\r", "\n\r"), " ", trim($dep->departamento)),
                                    "idSuperior" => $dep->idcatalogo,
                                    "variantes" => $sub->multiaux,
                                    "icon" => base_url()."img/add3.png",
                                );
                                
                                $i++; $j=1;
                                foreach($modelos as $mod){
                                    if($mod->idcatalogo == $sub->idcatalogo){
                                        $dataSourceLineas[$i] = array(
                                            "id" => $dep->idcatalogo . "_" . $sub->idcatalogo . "_" . $j,
                                            "idcatalogo" => $sub->idcatalogo,
                                            "itemnivel" => 3,
                                            "tran100km" => 0,
                                            "descrip" => str_replace("", "SIN MODELO", $mod->modelo),
                                            "idSuperior" => $dep->idcatalogo . "_" . $sub->idcatalogo
                                        );
                                        $i++; $j++;
                                    }
                                }

                                if($modeloskm != false){
                                    foreach($modeloskm as $modkm){
                                        if($modkm->idcatalogo == $sub->idcatalogo){
                                            $dataSourceLineas[$i] = array(
                                                "id" => $dep->idcatalogo."_".$sub->idcatalogo."_".$j,
                                                "idcatalogo" => $sub->idcatalogo,
                                                "itemnivel" => 3,
                                                "tran100km" => 1,
                                                "descrip" => str_replace("", "SIN MODELO", $modkm->modelo),
                                                "idSuperior" => $dep->idcatalogo . "_" . $sub->idcatalogo
                                            );
                                            $i++; $j++;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    $k=1;
                    $dataModelos = array();
                    $dataModelos[0] = array(
                        "id" => "TODOS",
                        "descrip" => "TODOS"
                    );
                    
                    if($modeloskm != false){
                        foreach($modeloskm as $infomod){
                            $dataModelos[$k] = array(
                                "id" => $infomod->modelo,
                                "descrip" => $infomod->modelo
                            );
                            $k++;
                        }
                    }

                    $array = array(
                        "infoGrid" => $infoGrid,
                        "dataSourceLineas" => $dataSourceLineas,
                        "dataModelos" => $dataModelos,
                        "modelo" => $modelo,
                        "numLineas" => $numLineas,
                        "numUnidades" => $numUnidades,
                        "validate" => $validate
                    );
                }else{
                    $array = array(
                        "validate" => $validate,
                        "infoProductos" => $infoInsertProductos
                    );
                }

                echo json_encode($array);
            }
        }

        function updateProductosTran100km(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idrec = $this->input->post('idrec');
                $descrip = $this->input->post('descrip');
                $marca = $this->input->post('marca');
                $modelo = $this->input->post('modelo');
                $barcode = $this->input->post('barcode');
                $color = $this->input->post('color');
                $cantidad = $this->input->post('cantidad');
                $costouni = $this->input->post('costouni');
                $editmayusc = $this->input->post('editmayusc');
                $precioventa = $this->input->post('precioventa');
                $modeloFiltro = $this->input->post('modeloFiltro');

                $this->load->model('compras_model');
                $this->compras_model->updateProductosTran100km($idrec, $descrip, $marca, $modelo, $barcode, $color, $cantidad, $costouni, $precioventa, $editmayusc);
                $infoGrid = $this->compras_model->getInformacionRecepcionModelo($trannum, $modeloFiltro);
                $numLineas=0; $numUnidades=0;
                $infoLineas = $this->compras_model->getDetalleLineasCompraRM($trannum);
                foreach($infoLineas as $infLin){
                    $numLineas++;
                    $numUnidades += $infLin->cantidad;
                }

                $array = array(
                    "infoGrid" => $infoGrid,
                    "numLineas" => $numLineas,
                    "numUnidades" => $numUnidades
                );

                echo json_encode($array);
            }
        }

        function deleteProductosTran100km(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('trannum');
                $modeloFiltro = $this->input->post('modeloFiltro');

                $this->load->model('compras_model');
                $this->compras_model->deleteProductosTran100km($idrec);
                $infoGrid = $this->compras_model->getInformacionRecepcionModelo($trannum, $modeloFiltro);
                $numLineas=0; $numUnidades=0;
                $infoLineas = $this->compras_model->getDetalleLineasCompraRM($trannum);
                foreach($infoLineas as $infLin){
                    $numLineas++;
                    $numUnidades += $infLin->cantidad;
                }

                $array = array(
                    "infoGrid" => $infoGrid,
                    "numLineas" => $numLineas,
                    "numUnidades" => $numUnidades
                );

                echo json_encode($array);
            }
        }

        function getInformacionLineasUnidadesRecepcionM(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('compras_model');
                $numLineas=0; $numUnidades=0;
                $infoGrid = $this->compras_model->getInformacionRecepcionModelo($trannum, "TODOS");
                $infoLineas = $this->compras_model->getDetalleLineasCompraRM($trannum);
                foreach($infoLineas as $infLin){
                    if($infLin->cantidad != 0){
                        $numLineas++;
                        $numUnidades += $infLin->cantidad;
                    }
                }

                $totalCosto = 0;
                foreach($infoGrid as $infGrid){
                    if($infGrid->cantidad != 0){
                        $totalCosto += ($infGrid->cantidad * $infGrid->costouni);
                    }
                }

                $array = array(
                    "numLineas" => $numLineas,
                    "numUnidades" => $numUnidades,
                    "totalCosto" => $totalCosto
                );

                echo json_encode($array);
            }
        }

        function enviarProductosToCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idprovee = $this->input->post('idprovee');
                $desingModel = $this->input->post('desingModel');
                
                $this->load->model('compras_model');
                $informacionProductos = $this->compras_model->getInformacionRecepcionProductos($trannum);
                $array = $this->compras_model->createFichasProductosTran100kt($trannum, $informacionProductos, $idprovee, $desingModel);
                
                echo json_encode($array);
            }
        }

        function analisisDeCompras($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                
                $funcion = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($funcion);
                
                $this->load->view('mantenimiento_analisis_compras', $this->data); 
            }
        }

        function getDatosAnalisisDeCompras(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fecha_ini = $this->input->post("fecha_ini");
                $fecha_fin = $this->input->post("fecha_fin");
                
                $this->load->model('compras_model');
                $informacion = $this->compras_model->getDatosAnalisisDeCompras($fecha_ini, $fecha_fin);
			
				$i=0;
				$array = array();
				if($informacion!=false){
					foreach($informacion as $info){
						$array[$i] = array(
                            "Fecha"=>$info->Fecha,
                            "Dia"=>$info->Dia,
                            "Proveedor"=>$info->Proveedor,
                            "Serie_Numero"=>$info->serieNumero,
                            "Hits" => $info->Hits,
                            "Comprador" => $info->Comprador,
                            "Línea" => $info->Línea,
                            "Departamento" => $info->Departamento,
                            "Tipo_De_Compra" => $info->tipoDocumento,
                            "Tipo_De_Producto" => $info->tipoProducto,
                            "Unidades" => $info->Unidades,
                            "Sucursal" => $info->Sucursal,
                            "Producto"=> "[".$info->idproducto."] ".$info->Producto,
                            "XposProducto"=> "[".$info->xpos."] ".$info->Producto,
                            "Marca"=>$info->Marca,
                            "Modelo"=>$info->Modelo,
                            "Costos" => $info->Costos
                        );
                        $i++;
					}
				}
                echo json_encode($array);
            }
        }

        function iniciarReversionCompra(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('compras_model');
                echo json_encode($this->compras_model->iniciarReversionCompra($trannum));
            }
        }

        function obtenerInformacionReversionCompra() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('compras_model');
                echo json_encode($this->compras_model->obtenerInformacionReversionCompra($trannum));
            }
        }
        
        function updateCantidadReversion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum   = $this->input->post('trannum');
                $idrec     = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                
                $this->load->model('compras_model');
                echo json_encode($this->compras_model->updateCantidadReversion($trannum, $idrec, $cantidad));
            }
        }

        function updateCostoPromedio() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum   = $this->input->post('trannum');
                $idrec     = $this->input->post('idrec');
                $aCantidad = $this->input->post('aCantidad');
                $aCosto    = $this->input->post('aCosto');
                $nCantidad = $this->input->post('nCantidad');
                $nCosto    = $this->input->post('nCosto');

                $aCostoTotal = number_format($aCantidad, 2, '.', '') * number_format($aCosto, 6, '.', '');
                $nCostoTotal = number_format($nCantidad, 2, '.', '') * number_format($nCosto, 6, '.', '');

                $sumCantidad = number_format($aCantidad, 2, '.', '') + number_format($nCantidad, 2, '.', '');
                $sumCosto = number_format($aCostoTotal, 6, '.', '') + number_format($nCostoTotal, 6, '.', '');

                if ( $aCantidad == 0 ) {
                    $costoPromedio = number_format($nCosto, 6, '.', '');
                } else {
                    $costoPromedio = number_format($sumCosto, 6, '.', '') / number_format($sumCantidad, 6, '.', '');
                }

                $this->load->model('compras_model');
                echo json_encode($this->compras_model->updateCostoPromedio($trannum, $idrec, $nCosto, $costoPromedio));
            }
        }

        function procesarReversionCompra() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                
                $this->load->model('compras_model');
                echo json_encode($this->compras_model->procesarReversionCompra($trannum));
            }
        }

        //  VENTAS POR PROVEEDOR
        public function comprasXProveedor($idApp)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $direccion = $this->uri->segment(1);
                $this->load->model('global_model');
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->load->view("mantenimiento_comprasproveedor", $this->data);
            }
        }
        public function getComprasxProveedor()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('compras_model');
                $ID = $this->input->post("ID");
                $fi = $this->input->post("fechai");
                $ff = $this->input->post("fechaf");
                $datos = $this->compras_model->getComprasProvee($fi, $ff, $ID);
                echo json_encode($datos);
            }
        }

        public function validacionArchivoJSON() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                try {
                    $data     = file_get_contents($_FILES['file']['tmp_name']);
                    $fileJSON = json_decode($data, true);
                    
                    if (!isset($fileJSON['identificacion'])) {
                        echo json_encode(array(
                            'totalErrores'      => 1,
                            'mensajeResultado'  => 'Lo sentimos pero ha ocurrido un error cargando la información.'
                        ));

                        return;
                    }

                    $infoJSON = $fileJSON['identificacion'];
                    
                    $codigoGeneracion = $infoJSON['codigoGeneracion'];
                    $numeroControl    = $infoJSON['numeroControl'];

                    if ( isset($fileJSON['respuestaHacienda']) ) {
                        $infoMH = $fileJSON['respuestaHacienda'];
                        $selloRecibido = $infoMH['selloRecibido'];
                    } else if ( isset($fileJSON['responseMH']) ) {
                        $infoMH = $fileJSON['responseMH'];
                        $selloRecibido = $infoMH['selloRecibido'];
                    } else if ( isset($fileJSON['selloRecibido']) ) {
                        $selloRecibido = $fileJSON['selloRecibido'];
                    } else if ( isset($fileJSON['sello']) ) {
                        $selloRecibido = $fileJSON['sello'];
                    } else if ( isset($infoJSON['SelloRecibido'])) {
                        $selloRecibido = $infoJSON['SelloRecibido'];
                    } else if ( isset($fileJSON['firmaElectronica'])) {
                        $infoMH = $fileJSON['firmaElectronica'];
                        if (isset($infoMH['selloRecibido'])) {
                            $selloRecibido = $infoMH['selloRecibido'];
                        } else {
                            $selloRecibido = "";
                        }
                    } else {
                        $selloRecibido = "";
                    }

                    echo json_encode(array(
                        'totalErrores'     => 0,
                        'mensajeResultado' => 'Carga de Datos Exitosa',
                        'codigoGeneracion' => $codigoGeneracion,
                        'numeroControl'    => $numeroControl,
                        'selloRecibido'    => $selloRecibido,
                        'fechaEmision'     => $infoJSON['fecEmi'],
                    ));
                } catch(Exception $e) {
                    echo json_encode(array(
                        'totalErrores'      => 1,
                        'mensajeResultado'  => 'Lo sentimos pero ha ocurrido un error cargando la información.'
                    ));
                }
            }
        }

        //--------------------------------------
        function getDetallePopupKardex(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                //$tipo = $this->input->post('tipoPro');
                //$categoria = $this->input->post('categoria');
                $sucursales = $this->input->post('sucursales');
                $idproducto = $this->input->post('idproducto');
				
                $this->load->model('compras_model');
                $detalle = $this->compras_model->getDetalleExistenciasUbicacionesProducto($sucursales,$idproducto);
                
                $i=0;
                $array = array();
                foreach($detalle as $det){
                    $array[$i] = array(
                        "idproducto" => $det->idproducto,
                        "fcompra" => $det->fcompra,
                        "dias_lote" => $det->dias_lote,
                        "producto" => $det->producto,
                        "centro" => $det->centro,
                        "ubicacion" => $det->ubicacion,
                        "lote" => $det->lote,
                        "cantidad" => round($det->cantidad,2),
                        "idbin" => $det->idbin,
                        "idbatch" => $det->idbatch,
                        "abrir" => 0,
                        "marca" => $det->marca,
                        "modelo" => $det->modelo,
                        "xpos" => $det->xpos,
                        "um" => $det->um,   
                        "imagen" => $det->imagen,
                        "barcode" => $det->barcode,
                    );
                    $i++;
                }

                echo json_encode($array);
            }
        }

        function getUnidadesVendidasPorMes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $periodo = $this->input->post('periodo');
                $prodAgrupa = ($this->input->post('prodAgrupa') !== null) ? $this->input->post('prodAgrupa') : 'VN';

                $this->load->model('compras_model');
                $informacion = $this->compras_model->getUnidadesVendidasPorMes($idproducto, $periodo[0], $periodo[1], $prodAgrupa);

                echo json_encode($informacion);
            }
        }

        function getUnidadesVendidasPorSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $periodo    = $this->input->post('periodo');
                $sucursales = $this->input->post('sucursales');

                $this->load->model('compras_model');
                $informacion = $this->compras_model->getUnidadesVendidasPorSucursal($idproducto, $sucursales, $periodo[0], $periodo[1]);

                echo json_encode($informacion);
            }
        }

        function getHistoralDeCompras(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                $periodo = $this->input->post('periodo');

                $this->load->model('compras_model');
                $informacion = $this->compras_model->getHistoralDeCompras($idproducto, $periodo[0], $periodo[1]);

                echo json_encode($informacion);
            }
        }

        function analisisParaCompras($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('global_model');
                $this->load->model('compras_model');
                $this->load->model('sucursal_model');
                $this->load->model('configuracion_model');

                $appName = $this->configuracion_model->getAppName($idApp);
                
                $infoAppName = array(
                    'iddApp'   => $idApp,
                    'appName'  => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($infoAppName);
				
                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days"));
                
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;
                $this->data['proveedores'] = $this->compras_model->getListProveedores(1);
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
				$this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));

                $this->load->view('mantenimiento_analisis_para_comprar', $this->data);
            }
        }

        function insertAnalisisCompras() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $titulo    = $this->input->post('titulo');
                $fechaini  = $this->input->post('fechaini');
                $fechafin  = $this->input->post('fechafin');
                $proveedor = $this->input->post('proveedor');
                $fpedido   = $this->input->post('fpedido');
                $sucursal  = $this->input->post('sucursal');
                $notas     = $this->input->post('notas');

                $this->load->model('compras_model');
                $result = $this->compras_model->insertAnalisisCompras($titulo, $fechaini, $fechafin, $proveedor, $sucursal, $fpedido, $notas);

                echo json_encode($array = array(
                    "res"     => "OK",
                    "trannum" => $result
                ));
            }
        }

        function getListadoAnalisisCompras() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');

                $this->load->model('compras_model');
                $informacion = $this->compras_model->getListadoAnalisisCompras($fechaini, $fechafin);

                echo json_encode($informacion);
            }
        }

        function detalleAnalisisParaCompras($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('compras_model');
                $this->load->model('sucursal_model');
                $this->load->model('empleado_model');
                $this->load->model('proveedor_model');

                $this->data['informacion'] = $this->compras_model->getInformacionAnalisisParaCompras($trannum);
                $this->data['formatos']    = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
                $this->data['sucursales']  = $this->sucursal_model->viewSucursalActiva();
                $this->data['proveedores'] = $this->proveedor_model->viewProveeActivos();
                $this->data['vendedores']  = $this->empleado_model->viewEmple();
                $this->data['formas_pago'] = $this->compras_model->formasPago();
                $this->data['tipoDoc']     = $this->compras_model->tipoDoc();


                $this->load->view('mantenimiento_detalle_analisis_para_comprar', $this->data);
            }
        }

        function getProductosAnalisisCompra() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $trannum  = $this->input->post('trannum');
                $idprovee = $this->input->post('idproveedor');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                
                $this->load->model('compras_model');
                $informacion = $this->compras_model->getProductosAnalisisCompra($trannum, $idprovee, $fechaini, $fechafin);

                echo json_encode($informacion);
            }
        }

        function generarOrdenCompraAnalisis(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $idcentrouser  = $this->session->userdata('idcentrouser');
                $proveedor     = $this->input->post('proveedor');
                $fechaingreso  = $this->input->post('fechaingreso');
                $tipoDocumento = $this->input->post('tipoDocumento');
                $cajclase      = $this->input->post('cajclase');
                $vendedor      = $this->input->post('vendedor');
                $fechaentrega  = $this->input->post('fechaentrega');
                $lugar_entrega = $this->input->post('lugar_entrega');
                $referencia    = $this->input->post('referencia');
                $notas         = trim($this->input->post('notas'));
                $whodidit      = $this->session->userdata('iduser');
                $tipoproC      = $this->input->post('compras_tipopro');
                $IDCDespacho   = $this->input->post('IDCDespacho');
                $productos     = $this->input->post('productos');
                $fechaDesdeHasta = $this->input->post('fechaDesdeHasta');

                $this->load->model('compras_model');
                // $save = $this->compras_model->insertOrden($idcentrouser, $proveedor, $fechaingreso, $tipoDocumento, $cajclase, $vendedor, $fechaentrega, $lugar_entrega, $referencia, $notas, $whodidit,$products_provee, $tipoproC, $fechaDesdeHasta);
                $save = $this->compras_model->generarOrdenCompraAnalisis($idcentrouser, $proveedor, $fechaingreso, $tipoDocumento, $cajclase, $vendedor, $fechaentrega, $lugar_entrega, $referencia, $notas, $whodidit, $tipoproC, $fechaDesdeHasta, $productos);
                if($save != 0){
                    $info = array(
                        'save' => $save,
                        'tipoproC' => $tipoproC,
                        'IDCDespacho' => $IDCDespacho
                    );
                    echo json_encode($info);
                }
            }
        }

        function modificarPeriodo() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $trannum  = $this->input->post('trannum');
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');

                $this->load->model('compras_model');
                $info = $this->compras_model->modificarPeriodo($trannum, $fechaini, $fechafin);

                echo json_encode($info);
            }
        }

        function getInfoDTE() {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('CerrarSesion');
            } else {
                $trannum = $this->input->post('trannum');

                $this->load->model('dte_model');
                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum);
                
                if (!$infoDTE) {
                    echo json_encode(array(
                        'status' => 0,
                        'message' => 'DTE No Encontrado'
                    ));
                } else {
                    echo json_encode(array(
                        'status' => 1,
                        'message' => 'DTE Encontrado',
                        'idrecDTE' => $infoDTE->idrec,
                        'cgeneracion' => $infoDTE->cgeneracion,
                        'srecepcion' => $infoDTE->srecepcion,
                        'ncontrol' => $infoDTE->ncontrol
                    ));
                }
            }
        }

        function ordenesDeProduccion($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcTran = $this->configuracion_model->getProCentro($idApp);

                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('global_model');
				$this->load->model('compras_model');
                
				$idcentro = $this->session->userdata('idcentrouser');
                
                $inClases = explode(",", $opcTran);

                $this->data['formatos']  = $this->global_model->getFormatosImpresionGrid($this->uri->segment(1));
				$this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['compras']   = $this->compras_model->getTiposCompras('CO');
                $this->data['descargas'] = $this->compras_model->getTiposDescargas('IN');
                $this->data['idclaseCO'] = $inClases[0];
                $this->data['idclaseIN'] = $inClases[1];

                $fecha_fin = $date->format('Y-m-d');
                $fecha_ini = date("Y-m-d", strtotime($fecha_fin. "- 30 days")); 
                
                $this->data['valFechaIni'] = $fecha_ini;
                $this->data['valFechafin'] = $fecha_fin;
                
                $this->load->view('mantenimiento_ordenesProduccion', $this->data); 
            }
        }

        function getListadoOrdenesDeProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $estado   = $this->input->post('estado');
				$idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $datos = $this->compras_model->getListadoOrdenesDeProduccion('OP', $idcentro, $fechaini, $fechafin, $estado);
                
                $i=0;
                $array = array();
                if ($datos != false) {
                    foreach($datos as $info){
                        if ($info->fecact == "0000-00-00") {
                            $fechacierre  = "";
                        } else {
                            $fechacierre  = $info->fecact;
                        }
                        
                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "fecha" => $info->fecha,
                            "fecact" => $fechacierre,
                            "estatus" => $info->estatus,
                            "documento" => $info->descrip,
                            "notas" => $info->notas,
                            "idclases" => $info->idclases,
                        );
                        $i++;
                    }
                }
                    
                echo json_encode($array);
            }
        }

        function adicionarOrdenDeProduccion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipode = $this->input->post('tipode');
                $tipoco = $this->input->post('tipoco');
                $fecha = $this->input->post('fecha');
                $idsolicita = $this->input->post('idsolicita');
                $notas = trim($this->input->post('notas'));
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->adicionarOrdenDeProduccion($tipode, $tipoco, $fecha, $idsolicita, $notas, $idcentro);
                echo json_encode($array);
            }
        }

        function detalleOrdenDeProduccion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
				$direccion = $this->uri->segment(1);
				
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['cantidades'] = $this->compras_model->getCantidadesTran100kt($trannum);
                $this->data['unidades'] = $this->compras_model->getUnidadesTran100kt($trannum);
                $this->data['empleados'] = $this->compras_model->getListProveedores(3);
                $this->data['compras'] = $this->compras_model->getTiposCompras('CO');
                $this->data['descargas'] = $this->compras_model->getTiposDescargas('IN');
                $this->data['numdecimales'] = $this->compras_model->getCantidadDecimales('po_decimales');
                $informacion = $this->compras_model->getInformacionOrdenDeProduccion($trannum);
                $this->data['informacion'] = $informacion;
                
                foreach($informacion as $key){
                    $this->data['estatus'] = $key->estatus;
                    // $idclase = $key->idclase;
                }
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');

                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }else{
                    $array = array(
                        "gv_prodsearch" => 1,
                        "gv_prodtext" => "Código Interno"
                    );
                }
                
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detalleOrdenDeProduccion', $this->data); 
            }
        }

        function getDatosProductosOrdenProduccion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->getDatosProductosOrdenProduccion($trannum, $idcentro);
                echo json_encode($array);
            }
        }

        function getListadoProductosProduccion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->getListadoProductosProduccion($trannum, $idcentro);
                echo json_encode($array);
            }
        }

        function insertProductoOrdenProduccion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum    = $this->input->post('trannum');
                $idproducto = $this->input->post('idproducto');
                $cantidad   = $this->input->post('cantidad');
                $fecha      = $this->input->post('fecha');
                $lote       = $this->input->post('lote');
                $um         = $this->input->post('um');
                $uniconv    = $this->input->post('uniconv');
                $notas      = $this->input->post('notas');
                $idcentro   = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $this->compras_model->insertProductoOrdenProduccion($trannum, $idproducto, $cantidad, $fecha, $lote, $um, $uniconv, $notas);

                echo json_encode(array(
                    'dataGrid' => $this->compras_model->getDatosProductosOrdenProduccion($trannum, $idcentro),
                    'dataProd' => $this->compras_model->getListadoProductosProduccion($trannum, $idcentro),
                    'cantidad' => $this->compras_model->getCantidadesTran100kt($trannum),
                    'unidades' => $this->compras_model->getUnidadesTran100kt($trannum),
                ));
            }
        }

        function updateProductoOrdenProduccion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $idrec    = $this->input->post('idrec');
                $cantidad = $this->input->post('cantidad');
                $fecha    = $this->input->post('fecha');
                $lote     = $this->input->post('lote');
                $notas    = $this->input->post('notas');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $this->compras_model->updateProductoOrdenProduccion($trannum, $idrec, $cantidad, $fecha, $lote, $notas);

                echo json_encode(array(
                    'dataGrid' => $this->compras_model->getDatosProductosOrdenProduccion($trannum, $idcentro),
                    'dataProd' => $this->compras_model->getListadoProductosProduccion($trannum, $idcentro),
                    'cantidad' => $this->compras_model->getCantidadesTran100kt($trannum),
                    'unidades' => $this->compras_model->getUnidadesTran100kt($trannum),
                ));
            }
        }

        function eliminarProductoProduccion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $idrec    = $this->input->post('idrec');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('compras_model');
                $this->compras_model->eliminarProductoProduccion($idrec);

                echo json_encode(array(
                    'dataGrid' => $this->compras_model->getDatosProductosOrdenProduccion($trannum, $idcentro),
                    'dataProd' => $this->compras_model->getListadoProductosProduccion($trannum, $idcentro),
                    'cantidad' => $this->compras_model->getCantidadesTran100kt($trannum),
                    'unidades' => $this->compras_model->getUnidadesTran100kt($trannum),
                ));
            }
        }

        function getDetalleComponentesProduccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $estado   = $this->input->post('estado');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('compras_model');
                $informacion = $this->compras_model->getDetalleComponentesProduccion($trannum, $idcentro, $estado);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        $array[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "tipoproducto" => $info->tipoproducto,
                            "um" => $info->um,
                            "useLote" => $info->useLote,
                            "costounitario" => number_format($info->costounitario, 6, '.', ''),
                            "cantidad" => number_format($info->cantidad, 2, '.', '') * 1,
                            "cantrp" => ($info->useLote == 1) ? 0 : number_format($info->cantidad, 2, '.', '') * 1,
                            "saldo" => number_format($info->saldo, 2, '.', '') * 1,
                            "subtotal" => number_format($info->costounitario, 6, '.', '') * number_format($info->cantidad, 2, '.', ''),
                        );

                        $i++;
                    }
                }

                echo json_encode($array);
            }
        }

        function anularOrdenProduccion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
				$trannum = $this->input->post('trannum');
				
                $this->load->model('compras_model');
                $array = $this->compras_model->anularOrdenProduccion($trannum);
				
				echo json_encode($array);
			}
		}

        function cerrarOrdenDeProduccion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $trannum   = $this->input->post('trannum');
                $tipoDE    = $this->input->post('tipoDE');
                $tipoCO    = $this->input->post('tipoCO');
                $idworker  = $this->input->post('idworker');
                $notas     = trim($this->input->post('notas'));
                $dataItems = $this->input->post('dataItems');
                $idcentro  = $this->session->userdata('idcentrouser');
                
                $this->load->model('compras_model');
                $array = $this->compras_model->cerrarOrdenDeProduccion($trannum, $tipoDE, $tipoCO, $idworker, $notas, $idcentro, $dataItems);
                
                echo json_encode($array);
            }
        }

        function getListadoLotesProduccion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idcomponent = $this->input->post('idcomponent');
                $idcentro = $this->input->post('idcentro');

                $this->load->model('compras_model');
                $array = $this->compras_model->getListadoLotesProduccion($idcomponent, $idcentro);

                echo json_encode($array);
            }
        }
    }
?>