<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Catalog extends CI_Controller {
        
        function __construct()
        {
            parent::__construct();
        }
        
        function verCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $mensaje = array(
                    'error' => 0,
                );
                $this->session->set_userdata($mensaje);
                $this->load->model('catalog_model');
                $this->data['catalog'] = $this->catalog_model->viewCatalogL1();
                $this->data['subcatalog'] = $this->catalog_model->viewCatalogL2();
                $this->load->view('mantenimiento_catalog', $this->data); 
            }
        }
        
        function verSubcatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('catalog_model');
                $data['subcatalog'] = $this->catalog_model->viewCatalogL2();
            }
        }
        
        function newCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('catalog_model');
                $this->load->model('producto_model');
                $tipo = 0;
                $idcatalogo = $this->uri->segment(2);
                if($idcatalogo!=null && $idcatalogo!=0 ){
                    $idCatalog_slc = array(
                        'idCatalog_slc' => $idcatalogo,
                        'namePage' => "Adicionar Catálogo",
                    );
                    $this->session->set_userdata($idCatalog_slc);
                }
                
                if($this->session->userdata('tipo_new_catalogo')!=null){
                    $tipo = $this->session->userdata('tipo_new_catalogo');
                }
                
                
                $this->data['tipo'] = $tipo;      
                $this->data['list_gvars'] = $this->catalog_model->viewGvars();      
                $this->data['tipo_pro'] = $this->producto_model->getTipoProd();
                $this->data['catalog_p'] = $this->catalog_model->viewCatalogL1();
                $this->data['listProcentro'] = $this->catalog_model->listProcentro();
                $this->load->view('new_catalog', $this->data);
            }
        }
        
        function registrarCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $tipo = $this->input->post('inputTipo');
                $procentro = $this->input->post('procentro');
                $descrip = $this->input->post('descrip');
                $nivel = $this->input->post('nivel');
                $posicion = $this->input->post('posicion');
                $img = $this->input->post('imgen');
                $estado = $this->input->post('estado');
                $notas = $this->input->post('notas');
                $whodidit = $this->session->userdata('iduser');
                $xpos = $this->input->post('xpos');
                $this->load->model('catalog_model');
                
                $nameImagen = $this->catalog_model->insertCatalog($tipo,$descrip, $nivel, $posicion, $img, $estado, $notas, $whodidit, $xpos, $procentro);  
                
                if($nameImagen != false){
                    $imgSplit = explode(".", $nameImagen);
                    $imagen = 'imagen';
                    $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['file_name'] = $imgSplit[0];
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $this->load->library('upload', $config);
                    $this->upload->do_upload($imagen);
                }
                
                redirect('Agrupacion_Productos/'.$this->session->userdata('iddApp'));
            }
        }
        
        function modificarCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->uri->segment(2);
                if($idcatalogo!=null && $idcatalogo!=0 ){
                    $idCatalog_slc = array(
                        'idCatalog_slc' => $idcatalogo,
                        'namePage' => "Modificación de Departamento  N°".$idcatalogo,
                    );
                    $this->session->set_userdata($idCatalog_slc);
                }
                
                $this->load->model('catalog_model');   
                $this->load->model('producto_model');
                $this->data['tipo_pro'] = $this->producto_model->getTipoProd();
                $this->data['catalog_dat'] = $this->catalog_model->callRegistro($idcatalogo);
                $this->data['listProcentro'] = $this->catalog_model->listProcentro();
                $this->data['list_gvars'] = $this->catalog_model->viewGvars();
                $this->load->view('form_update_catalog', $this->data);
            }
        }
        
        function actualizarCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $tipo = $this->input->post('inputTipo');
                $procentro = $this->input->post('procentro');
                $idcatalog = $this->input->post('idcatalog');
                $descrip = $this->input->post('descrip');
                $nivel = $this->input->post('nivel');
                $posicion = $this->input->post('posicion');
                $img = $this->input->post('imgen');
                $estado = $this->input->post('estado');
                $notas = $this->input->post('notas');
                $whodidit = $this->session->userdata('iduser');
                $xpos = $this->input->post('xpos');
                $this->load->model('catalog_model');
                $this->catalog_model->updateCatalog($tipo,$idcatalog, $descrip, $nivel, $posicion, $img, $estado, $notas, $whodidit, $xpos, $procentro);
                
                $imagen = 'imagen';
                $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                $config['file_name'] = "imgDepto_".$idcatalog;
                $config['over_write'] = "TRUE";
                $config['allowed_types'] = "gif|jpg|jpeg|png";
                $this->load->library('upload', $config);
                $this->upload->do_upload($imagen);
                
                redirect('Agrupacion_Productos/'.$this->session->userdata('iddApp'));
            }
        }
        
        function eliminarCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$idcatalogo = $this->input->post('idcatalogo');
				
                if($idcatalogo != null && $idcatalogo != 0){
                    $idCatalog_slc = array(
                        'idCatalog_slc' => $idcatalogo,
                    );
                    $this->session->set_userdata($idCatalog_slc);
                }
                
                $this->load->model('catalog_model');
                $array = $this->catalog_model->deleteCatalog($idcatalogo);
				echo json_encode($array);
			}
        }
        
        function getListDepartamento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                
                $this->load->model('catalog_model');
                $array = $this->catalog_model->getListLineasDepartamento($idcatalogo);
                echo json_encode($array);
            }
        }
        function getListLineasCatalog(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
				$this->load->model('catalog_model');
                $array = $this->catalog_model->getListLineasDepartamento($idcatalogo);
				$new_array = array();
				$i=0;
				if($array!=false){
					$new_array[$i] = array(
							"idcatalogo" => "99999",
							"descrip" => "-TODOS-",
						);
						$i++;
					foreach($array as $arr){
						$new_array[$i] = array(
							"idcatalogo" => $arr->idcatalogo,
							"descrip" => $arr->descrip,
						);
						$i++;
					}
					
				}
                echo json_encode($new_array);
            }
        }
        
        function setProcentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $listLineas = $this->input->post('listLineas');
                $listcero = $this->input->post('listcero');
                $procentro = $this->input->post('procentro');
                
                $this->load->model('catalog_model');
                if($listcero != ""){
                    $this->catalog_model->updateProcentroLineasCero($listcero);
                }
                $array = $this->catalog_model->updateProcentroLineas($listLineas, $procentro);
                echo json_encode($array);
            }
        }
        
        function getListLineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('catalog_model');
                $array = $this->catalog_model->listadoLineas();
                echo json_encode($array);
            }
        }
        
        function actualizarProcentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $procentro = $this->input->post('procentro');

                $this->load->model('catalog_model');
                $array = $this->catalog_model->updateProcentroCatalogo($idcatalogo, $procentro);
                echo json_encode($array);
            }
        }
        
        function catalogo_agrupacion($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('configuracion_model');
                //$result = $this->configuracion_model->confirmarAccesoApp($idApp);
                //$result == true ?: redirect('CerrarSesion');

                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'var_new_catalog' => 1,
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('catalog_model'); $this->load->model('producto_model');
                
                $controlador = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['tipo_producto'] = $this->producto_model->getTipoProd();
                $this->data['catalog'] = $this->catalog_model->viewCatalogL1();
                $this->data['subcatalog'] = $this->catalog_model->viewCatalogL2();
                $this->data['listProcentro'] = $this->catalog_model->listProcentro();
                $this->data['canjes_pro'] = $this->catalog_model->getValidateCanjesDeProducto();
                $this->load->view('mantenimiento_catalogo_nuevo', $this->data); 
            }
        }
        
        function getDepartamentosTipoPro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $tipo= $this->input->post('tipo');

                $this->load->model('catalog_model');
                $array = $this->catalog_model->getDepartamentosTipoPro($tipo);
                echo json_encode($array);
            }
        }
        
        function getLineasCatalogo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo= $this->input->post('idcatalogo');

                $this->load->model('catalog_model');
                $array = $this->catalog_model->getLineasCatalogo($idcatalogo);
                $sess = array(
                    'idCatalog_slc2' => $idcatalogo,
                );
                $this->session->set_userdata($sess);
                echo json_encode($array);
            }
        }
        
        function depto_selected(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $id = $this->input->post('idCatalogo');
                $tipo = $this->input->post('tipo_pro_add');
                $descrip_depto = $this->input->post('cat_name_new');
                $idCatalog_slc = array(
                    'idCatalog_slc2' => $id,
                    'tipo_new_catalogo' => $tipo,
                    'cat_name_new' =>$descrip_depto,
                    'var_new_catalog' =>1,
                );
                $this->session->set_userdata($idCatalog_slc);
                echo json_encode($id);
            }
        }
        
        function set_tipo_pro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $tipo_pro = $this->input->post('tipo_pro');
                $idCatalog_slc = array(
                    'tipo_pro_catalogo' => $tipo_pro,
                );
                $this->session->set_userdata($idCatalog_slc);
                echo json_encode(TRUE);
            }
        }
        
        function insertMultiplesLineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $lineas = $this->input->post('lineas');
                $tipo = $this->input->post('tipo');
                $this->load->model('catalog_model');
                $insert = $this->catalog_model->insertMuliLineas($idcatalogo, $lineas,$tipo);
                $array = $this->catalog_model->getLineasCatalogo($idcatalogo);
                echo json_encode($array);
            }
        }
        
        function listDepartamentosMov(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $this->load->model('catalog_model');
                $array = $this->catalog_model->getDepartamentosAgrupados($idcatalogo);
                echo json_encode($array);
            }
        }
        
        function listadoLineasCanjes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $iddepartamento = $this->input->post('iddepartamento');
                $tipopro = $this->input->post('tipopro');
                
                $this->load->model('catalog_model');
                $informacion = $this->catalog_model->getDepartamentosToCanje($iddepartamento, $tipopro);
                $canjesids = $this->catalog_model->getCanjesIds($idcatalogo);
                $arrayCanjes = explode(",", $canjesids);
                
                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $j=0;
                    $itemsLineas = array();
                    $infoLineas = $this->catalog_model->getListadoLineasByDepartment($info->idcatalogo, $idcatalogo,  $tipopro);
                    foreach($infoLineas as $infoLin){
                        $selected = false;
                        for($k=0; $k<count($arrayCanjes); $k++){
                            if($infoLin->idcatalogo == $arrayCanjes[$k]){
                                $selected = true;
                            }
                        }
                        
                        $itemsLineas[$j] = array(
                            "id" => $infoLin->idcatalogo,
                            "text" => $infoLin->descrip,
                            "selected" => $selected
                        );
                        $j++;
                    }
                    
                    $array[$i] = array(
                        "id" => $info->idcatalogo,
                        "text" => $info->descrip,
                        "items" => $itemsLineas
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
        
        function updateDatosDeCanje(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcanjes = $this->input->post('idcanjes');
                $idcatalogo = $this->input->post('idcatalogo');
                
                $this->load->model('catalog_model');
                $array = $this->catalog_model->updateDatosDeCanje($idcatalogo, $idcanjes);
                                
                echo json_encode($array);
            }
        }
        
        function moverApp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcatalogo = $this->input->post('idcatalogo');
                $idlinea = $this->input->post('idlinea');
                $id_newpadre = $this->input->post('id_newpadre');
                $this->load->model('catalog_model');
                $update = $this->catalog_model->recategorizarLinea($idlinea, $id_newpadre);
                $array = $this->catalog_model->getLineasCatalogo($idcatalogo);
                echo json_encode($array);
            }
        }
        
        function getLineasAgrupadas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $tipo= $this->input->post('tipo');
                $this->load->model('catalog_model');
                $array = $this->catalog_model->getLineasAgrupadas($tipo);
                echo json_encode($array);
            }
        }
        //------------------------------------------------------------------------  AGRUPACION DE PRODUCTOS ----------------------------------------------------------------------------------
        public function catalogo_agrupacionN($idApp)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('configuracion_model');
                //$result = $this->configuracion_model->confirmarAccesoApp($idApp);
                //$result == true ?: redirect('CerrarSesion');

                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'var_new_catalog' => 1,
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('catalog_model');
                
                $controlador = $this->uri->segment(1);
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['TProductos'] = $this->catalog_model->getTiposProductos();
                $this->data['listProcentro'] = $this->catalog_model->getData(1)->result();
                $this->load->view('mantenimiento_CatalogoProductos', $this->data); 
            }
        }
        #   GET DEPARTAMENTOS LINEAS
        public function getDepartamentosLineas()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                $Tipo = $this->input->post("tipo");
                $datos = $this->catalog_model->getDepartamentosLineas($Tipo);
                echo json_encode($datos);
            }
        }
        #   GET INFORMACION DATA
        public function getData()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                $tipoC = (int)$this->input->post("tipoC");
                switch ($tipoC) {
                    //  TO DEPARTAMENTOS
                    case 1:
                        if ($centros = $this->catalog_model->getData(1)) {
                            $Datos = [];
                            if ($centros->num_rows() > 0) {
                                foreach ($centros->result() as $dato) {
                                    $Datos[] = array(
                                        'ID' => (int)$dato->idcentro,
                                        'Name' => $dato->descrip,
                                        'Tipo' => $dato->tipo,
                                        'NTipo' => $dato->nombreTipo
                                    );
                                }
                            }
                            if ($ID = $this->input->post("ID")) {
                                if ($dato = $this->catalog_model->getCatalogo($ID)) {
                                    $datA[] = array('valido' => true);
                                    $datA[] = array(
                                        'centros' => $Datos,
                                        'dato' => $this->CDCatalogo($dato)
                                    );
                                } else $datA[] = array('valido' => false, 'error' => 1);
                            } else {
                                $datA[] = array('valido' => true);
                                $datA[] = array(
                                    'centros' => $Datos
                                );
                            }
                        } else $datA[] = array('valido' => false, 'error' => 0);
                    break;
                    //  TO LINEAS
                    case 2:
                        if (($centros = $this->catalog_model->getData(1))&&
                        ($variantes = $this->catalog_model->getData(2))  &&
                        ($opciones = $this->catalog_model->getData(3))
                        ) {
                            $Datos = [];
                            $Datos2 = [];
                            $Datos3 = [];
                            if ($centros->num_rows() > 0) {
                                foreach ($centros->result() as $dato) {
                                    $Datos[] = array(
                                        'ID' => (int)$dato->idcentro,
                                        'Name' => $dato->descrip,
                                        'Tipo' => $dato->tipo,
                                        'NTipo' => $dato->nombreTipo
                                    );
                                }
                            }
                            if ($variantes->num_rows() > 0) {
                                foreach ($variantes->result() as $dato) {
                                    $Datos2[] = array(
                                        'Name' => $dato->multiaux
                                    );
                                }
                            }//*/
                            if ($opciones->num_rows() >0) {
                                foreach ($opciones->result() as $dato) {
                                    $Datos3[] = array(
                                        'ID' => $dato->idrnum,
                                        'Name' => $dato->descripcion
                                    );
                                }
                            }//*/
                            if ($ID = $this->input->post("ID")) {
                                if ($dato = $this->catalog_model->getCatalogo($ID)) {
                                    $datA[] = array('valido' => true);
                                    $datA[] = array(
                                        'centros' => $Datos,
                                        'variantes' => $Datos2,
                                        'opciones' => $Datos3,
                                        'dato' => $this->CDCatalogo($dato)
                                    );
                                }
                            } else {
                                $datA[] = array('valido' => true);
                                $datA[] = array(
                                    'centros' => $Datos,
                                    'variantes' => $Datos2,
                                    'opciones' => $Datos3
                                );
                            }
                        } else $datA[] = array('valido' => false, 'error' => 0);
                    break;
                }
                echo json_encode($datA);
            }
        }
        #   SET DEPARTAMENTO - LINEAS
        public function setDepartamento()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $lineas = $this->input->post("lineas");
                $data = array(
                    'descrip' => $this->input->post("nombre"),
                    'nivel' => 1,
                    'posicion' => (int)$this->input->post("posicion"),
                    'procentro' => (int)$this->input->post("centro"),
                    'tipo' => $Tipo,
                    'xpos' => $this->input->post("xpos"),
                    'notas' => $this->input->post("notas"),
                    'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'whodidit' => $this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($IDDepto = $this->catalog_model->setCatalogo($data)) {
                    $cont = 0;
                    $valor = 1;
                    if ($lineas != '') {
                        foreach (explode("\n", $lineas) as $nombre) {
                            $datal = array(
                                'descrip' => $nombre,
                                'nivel' => 2,
                                'idnivel1' => $IDDepto,
                                'posicion' => $valor,
                                'tipo' => $Tipo,
                                'procentro' => (int)$this->input->post("centro"),
                                'estado' => 1,
                                'whodidit' => $this->session->userdata('iduser'),
                                'ingresa' => date_create()->format('Y-m-d H:i:s'),
                            );
                            //if (!$this->catalog_model->setCatalogo($datal)) $cont++;
                            if ($this->catalog_model->setCatalogo($datal)) $valor++;
                            else $cont++;
                        }
                    }
                    
                    if ($cont == 0) {
                        $datos = $this->catalog_model->getDepartamentosLineas($Tipo);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else $datA[] = array('valido' => false, 'tipo' => 2);
                } else $datA[] = array('valido' => false, 'tipo' => 1);
                echo json_encode($datA);
            }
        }
        #   CONVERTIR DATA DE CATALOGO
        private function CDCatalogo($dato)
        {
            $Dato = array(
                'ID' => (int)$dato->idcatalogo,
                'Descripcion' => $dato->descrip,
                'IDCentro' => (int)$dato->procentro,
                'posicion' => (int)$dato->posicion,
                'imagen' => $dato->imagen,
                'opcs' => $dato->gvars,
                'vars' => ($dato->multiaux == null) ? '' : $dato->multiaux,
                'xpos' => $dato->xpos,
                'notas' => ($dato->notas == null) ? '' : $dato->notas,
                'estado' => (int)$dato->estado
            );
            return $Dato;
        }
        #   UPDATE DEPARTAMENTO
        public function updateDepartamento()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $ID = (int)$this->input->post("ID");
                $data = array(
                    'descrip' => $this->input->post("nombre"),
                    'posicion' => (int)$this->input->post("posicion"),
                    'procentro' => (int)$this->input->post("centro"),
                    'xpos' => $this->input->post("xpos"),
                    'notas' => $this->input->post("notas"),
                    'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                    'whodidit' => $this->session->userdata('iduser'),
                    'modifica' => date_create()->format('Y-m-d H:i:s'),
                );
                if ($this->catalog_model->updateCatologo($data, $ID)) {
                    $datos = $this->catalog_model->getDepartamentosLineas($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #   SET LINEA
        public function setLinea()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $conteo = (int)$this->input->post("conteo");
                $sen = false;
                $error = '';
                if ($conteo > 0) {
                    $size = $_FILES['Archivo']['size'];
                    $ext = $_FILES['Archivo']['name'];
                    do {
                        $conteo = $this->catalog_model->getContImage();
                        $nombrei = "imgLinea"."_".$conteo."_".rand(10,1000).".".pathinfo($ext, PATHINFO_EXTENSION);
                    } while (!$this->catalog_model->validateNameImage($nombrei));
                    $config['upload_path']= "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $config['file_name'] = $nombrei;
                    $config['max_size'] = 200;
                    $this->load->library('upload',$config);
                    if ($this->upload->do_upload('Archivo')) $sen = true;
                    else {
                        $sen = false;
                        $error = $this->upload->display_errors();
                        if (($size / 1024) > 200) $error = 'sizeImagen';
                    }
                } else {
                    $nombrei = '';
                    $sen = true;
                }
                if ($sen) {
                    $data = array(
                        'descrip' => $this->input->post("nombre"),
                        'nivel' => 2,
                        'idnivel1' => (int)$this->input->post('IDDepto'),
                        'posicion' => (int)$this->input->post("posicion"),
                        'procentro' => (int)$this->input->post("centro"),
                        'tipo' => $Tipo,
                        'gvars' => $this->input->post('opciones'),
                        'multiaux' => $this->input->post('variantes'),
                        'xpos' => $this->input->post("xpos"),
                        'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                        'imagen' => $nombrei,
                        'notas' => $this->input->post("notas"),
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->catalog_model->setCatalogo($data)) {
                        $datos = $this->catalog_model->getDepartamentosLineas($Tipo);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else {
                        if ($conteo > 0) {
                            $path = "img_cuentas/".$this->session->userdata('diraccount')."/".$nombrei;
                            unlink($path);
                        }
                        $datA[] = array('valido' => false, 'sen' => $sen, 'error' => 'ingreso');
                    }
                } else $datA[] = array('valido' => false, 'sen' => $sen, 'error' => $error);
                echo json_encode($datA);
            }
        }
        #   UPDATE LINEA
        public function updateLinea()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $ID = (int)$this->input->post("ID");
                $dato = $this->catalog_model->getCatalogo($ID);
                $conteo = (int)$this->input->post("conteo");
                $sen = false;
                $error = '';
                if ($conteo > 0) {
                    $size = $_FILES['Archivo']['size'];
                    $ext = $_FILES['Archivo']['name'];
                    if (trim(strlen($dato->imagen)) > 0) {
                        $nombreActual = explode(".", $dato->imagen)[0];
                        if (strlen($nombreActual) > 0) $nombreold = $nombreActual;
                        else $nombreold = $this->getUpdateNameImagen(pathinfo($ext, PATHINFO_EXTENSION));
                    } else $nombreold = $this->getUpdateNameImagen(pathinfo($ext, PATHINFO_EXTENSION));
                    $nombrei = $nombreold.".".pathinfo($ext, PATHINFO_EXTENSION);
    
                    $config['upload_path']= "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $config['file_name'] = '123'.$nombrei;
                    $config['max_size'] = 200;
                    $this->load->library('upload',$config);
                    if ($this->upload->do_upload('Archivo')) {
                        $a = $this->upload->data();
                        $sen = true;
                    } else {
                        $sen = false;
                        $error = $this->upload->display_errors();
                        if (($size / 1024) > 200) $error = 'sizeImagen';
                    }
                } else {
                    $nombrei = $dato->imagen;
                    $sen = true;
                }
                if ($sen) {
                    $data = array(
                        'descrip' => $this->input->post("nombre"),
                        'posicion' => (int)$this->input->post("posicion"),
                        'procentro' => (int)$this->input->post("centro"),
                        'gvars' => $this->input->post('opciones'),
                        'multiaux' => $this->input->post('variantes'),
                        'xpos' => $this->input->post("xpos"),
                        'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                        'imagen' => $nombrei,
                        'notas' => $this->input->post("notas"),
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->catalog_model->updateCatologo($data, $ID)) {
                        if ($conteo > 0) {
                            if (trim(strlen($dato->imagen)) > 0) {
                                $path = "img_cuentas/".$this->session->userdata('diraccount')."/".$dato->imagen;
                                unlink($path);
                            }
                            rename($a['full_path'],$a['file_path'].$nombrei);
                        }
                        $datos = $this->catalog_model->getDepartamentosLineas($Tipo);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else {
                        if ($conteo > 0) {
                            $path = "img_cuentas/".$this->session->userdata('diraccount')."/123".$nombrei;
                            unlink($path);
                        }
                        $datA[] = array('valido' => false, 'sen' => $sen);
                    }
                } else $datA[] = array('valido' => false, 'sen' => $sen, 'error' => $error);
                echo json_encode($datA);
            }
        }
        private function getUpdateNameImagen($ext)
        {
            $valor = '';
            do {
                $conteo = $this->catalog_model->getContImage();
                $valor = "imgLinea"."_".$conteo."_".rand(10,1000).".".$ext;
            } while (!$this->catalog_model->validateNameImage($valor));
            return explode(".", $valor)[0];
        }
        #   AGREGAR MULTIPLES LINEAS
        public function addMLineas()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("IDTipo");
                $lineas = $this->input->post("lineas");
                $IDDepto = $this->input->post("IDDepto");
                $cont = 0;
                $valor = $this->catalog_model->getLastLinePosicion($IDDepto);
                $valor = $valor + 1;
                foreach (explode("\n", $lineas) as $nombre) {
                    $data = array(
                        'descrip' => $nombre,
                        'nivel' => 2,
                        'idnivel1' => $IDDepto,
                        'posicion' => $valor,
                        'tipo' => $Tipo,
                        'procentro' => (int)$this->input->post("IDCDepto"),
                        'estado' => 1,
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->catalog_model->setCatalogo($data)) $valor++;
                    else $cont++;
                }
                if ($cont == 0) {
                    $datos = $this->catalog_model->getDepartamentosLineas($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false);
                echo json_encode($datA);
            }
        }
        #   ELIMINAR DEPARTAMENTO
        public function delDepartamento()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("Tipo");
                $ID = (int)$this->input->post("ID");
                $valido = $this->catalog_model->hasLine($ID);
                if (!$valido) {
                    $this->catalog_model->delCatalogo($ID);
                    $datos = $this->catalog_model->getDepartamentosLineas($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => 1);
                echo json_encode($datA);
            }
        }
        #   ELIMINAR LINEA
        public function delLinea()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                date_default_timezone_set('America/El_Salvador');
                $Tipo = (int)$this->input->post("Tipo");
                $ID = (int)$this->input->post("ID");
                $dato = $this->catalog_model->getCatalogo($ID);
                $valido = $this->catalog_model->hasProducto($ID);
                if (!$valido) {
                    if (strlen($dato->imagen) > 0) {
                        $path = "img_cuentas/".$this->session->userdata('diraccount').'/'.$dato->imagen;
                        unlink($path);
                    }
                    $this->catalog_model->delCatalogo($ID);
                    $datos = $this->catalog_model->getDepartamentosLineas($Tipo);
                    $datA[] = array('valido' => true, 'datos' => $datos);
                } else $datA[] = array('valido' => false, 'tipo' => 2);
                echo json_encode($datA);
            }
        }
        //------------------------------------------------------------------------  FIN AGRUPACION DE PRODUCTOS ------------------------------------------------------------------------------
        //  IMPORTACION DE CATALOGOS Y LINEAS DE PRODUCTOS
        public function validacionImportarCatalogo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                $registros = $this->input->post("registros");
                

                $arrayRegistros = explode("\n", $registros);

                $valido = true;
                $arrayRespuesta = [];
                $arrayValidacion = []; //Array para validar si se repite linea y producto
                $conteo = 0;

                $departamentoActual = "¿123456!"; //Indica si hay un cambio de departamento
                foreach($arrayRegistros as $reg){
                    if($reg == ""){
                        $valido = false;

                        $arrayRespuesta[] = array(
                            'linea' => "Datos vacíos",
                            'departamento' => "Datos vacíos",
                            'tipo' => -1
                        );
                        $conteo++;
                        continue;
                    }

                    $dato = explode(",", $reg);

                    if(count($dato) != 2){
                        $valido = false;

                        $arrayRespuesta[] = array(
                            'linea' => "Datos erroneos",
                            'departamento' => "Datos erroneos",
                            'tipo' => -1
                        );
                        $conteo++;
                        continue;
                    }

                    $departamento = $dato[0];
                    $linea = $dato[1];
                    $tipo = 0;

                    //Verifica si hay departamento y linea repetida
                    if(in_array($reg, $arrayValidacion)){
                        $arrayRespuesta[] = array(
                            'linea' => $linea." [REPETIDO]",
                            'departamento' => $departamento." [REPETIDO]",
                            'tipo' => -1
                        );
                        $conteo++;
                        continue;
                    }else{
                        $arrayValidacion[] = $reg;
                    }

                    if(count($dato) == 2 && $departamento != "" && $linea != ""){
                    }else{
                        $valido = false;
                        if($departamento == ""){
                            $departamento = "Datos Incompletos";
                        }

                        if($linea == ""){
                            $linea = "Datos Incompletos";
                        }
                        
                        $arrayRespuesta[] = array(
                            'linea' => $linea,
                            'departamento' => $departamento,
                            'tipo' => -1
                        );
                        $conteo++;
                        continue;
                    }

                    if($this->catalog_model->existeDepartamentoLinea($departamento, $linea)){
                        $arrayRespuesta[] = array(
                            'linea' => $linea." [REPETIDO]",
                            'departamento' => $departamento,
                            'tipo' => -1
                        );
                        $conteo++;
                        continue;
                    }

                    $arrayRespuesta[] = array(
                        'linea' => $linea,
                        'departamento' => $departamento,
                        'tipo' => $this->input->post("tipo")
                    );
                }

                if($conteo > 0){
                    $valido = false;
                }

                $array[] = array('valido' => $valido, 'datos' => $arrayRespuesta);
                echo json_encode($array);
            }
        }

        public function importarCatalogo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('catalog_model');
                $registros = $this->input->post("registros");
                $tipo = $this->input->post("tipo");
                $procentro = $this->input->post("procentro");

                $arrayMalos = [];
                $valido = true;

                $departamentoActual = "¿¿¿123???";
                $idDepartamentoActual = 0;
                $arrayRegistros = explode("\n", $registros);

                $conteo = 0;
                foreach ($arrayRegistros as $reg) {
                    //Si el registro es vacio, lo ignora
                    if($reg == ""){
                        var_dump("AA");
                        continue;
                    }

                    $dato = explode(",", $reg);

                    //Si no sone exactamente dos items en el array, lo ignora
                    if(count($dato) != 2){
                        continue;
                    }

                    $departamento = $dato[0];
                    $linea = $dato[1];
                    
                    //Al detectar un cambio de departamente, crea un nuevo registro de nivel 1
                    if($departamento != $departamentoActual){
                        $departamentoActual = $departamento;
                        $idDepartamentoActual = $this->catalog_model->insertarImportarCatalogo($departamento, $tipo, $procentro, 1, 0);
                    }

                    if($idDepartamentoActual){
                        $this->catalog_model->insertarImportarCatalogo($linea, $tipo, $procentro, 2, $idDepartamentoActual);
                        $conteo++;
                    }else{
                        $valido = false;
                        $arrayMalos[] = array("departamento"=>$departamento, "linea"=>$linea);
                        $conteo++;

                    }
                  
                }

                if($valido){
                    $arrayResultado = array('valido'=>$valido, 'mensaje'=>'Se ha importado el catálogo de agrupación.', 'conteo'=>$conteo);
                }else{
                    $arrayResultado = array('valido'=>$valido, 'mensaje'=>'Hubo uno o más items del catálogo que no se importaron.', "malos"=>$arrayMalos, 'conteo'=>$conteo);

                }
                echo json_encode($arrayResultado);
            }
        }

        //--------------------------------------------- IMPORTAR DESCUENTOS POR CATALOGOS ---------------------------------------
        #   GET DEPARTAMENTOS LINEAS
        public function getDepartamentosLineasDesc()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                $this->load->model('catalog_model');
                $Tipo = $this->input->post("tipo");
                $datos = $this->catalog_model->getDepartamentosLineasDesc($Tipo);
                echo json_encode($datos);
            }
        }

        public function importDescCat(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");

                $this->load->model('catalog_model');
                $descuentos = $this->input->post("information");
                $information = array();
                $correctInformation = array();
                foreach($descuentos as $desc){
                    $information = array(
                        'idcatalogo' => $desc['codigo'],
                        'notas' => $desc['new_desc'],
                        'modifica' => $fecha_actual,
                    );
                    $correctInformation[] = $information;
                }
                //print_r($correctInformation);
                $datos = $this->catalog_model->importDescCat($correctInformation);
                echo json_encode($datos);
            }
        }
    }
