<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Caja extends CI_Controller{
        
        function __construct(){
            parent::__construct();
        }
        
        function verCaja(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->input->post('dato');
                $this->load->model('caja_model');
                $dtos = $this->caja_model->viewCajas($idcentro);
                echo json_encode($dtos);
            }
        }

        function verCajaCentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $this->load->model('caja_model');
                $dtos = $this->caja_model->getCajasByCentro($idcentro);
                echo json_encode($dtos);
            }
        }
        
        function newCaja($idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('sucursal_model');
                $data['idcentro'] = $this->sucursal_model->callRegistro($idcentro);
                $this->load->view('new_caja', $data);
            }
        }
        
        function registrarCaja(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $descrip = $this->input->post('descrip');
                $bfecha = $this->input->post('bfecha');
                $efecha = $this->input->post('efecha');
                $cajafondo = $this->input->post('cajafondo');
                $resolucion = $this->input->post('resolucion');
                $fresolucion = $this->input->post('fresolucion');
                $equipo = $this->input->post('equipo');
                $notas = $this->input->post('notas');
                $xpos = $this->input->post('xpos');
                $estatus = $this->input->post('estado');
                $ucajera = $this->input->post('ucajera');
                $whodidit = $this->session->userdata('iduser');
                
                $this->load->model('caja_model');
                $this->load->model('location_model');
                
                $this->caja_model->insertCaja($idcentro, $descrip, $bfecha, $efecha, $cajafondo, $resolucion, $fresolucion, $equipo, $whodidit, $xpos, $notas, $estatus,$ucajera);
                $invLocations = $this->location_model->getLocationsByCentro($idcentro);
                $ctCajas = $this->caja_model->getCajasByCentro($idcentro);
                
                $listTree = array();
                $itemsUbicaciones = array();
                $itemsCajas = array();
                
                $i=0;$j=0;
                
                foreach($invLocations as $inv){
                    $itemsUbicaciones[$i] = array(
                        "id" => "1_".$inv->idbin,
                        "name" => $inv->descrip,
                        "expanded" => false
                    );
                    $i++;
                }
                
                foreach($ctCajas as $caja){
                    $itemsCajas[$j] = array(
                        "id" => "2_".$caja->idcaja,
                        "name" => $caja->descrip,
                        "expanded" => true
                    );
                    $j++;
                }
                
                $itemsUbicaciones[$i] = array(
                    "id" => "1_0",
                    "name" => "",
                    "iconSrc" => base_url()."img/add3.png",
                    "expanded" => false
                );
                
                $itemsCajas[$j] = array(
                    "id" => "2_0",
                    "name" => "",
                    "iconSrc" => base_url()."img/add3.png",
                    "expanded" => true
                );
                
                $listTree[0] = array(
                    "id" => "1",
                    "name" => "Detalle Ubicaciones",
                    "expanded" => false,
                    "items" => $itemsUbicaciones
                );
                
                $listTree[1] = array(
                    "id" => "2",
                    "name" => "Detalle Cajas",
                    "expanded" => true,
                    "items" => $itemsCajas
                );
                
                echo json_encode($listTree);
            }
        }
        
        function actualizarCaja(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcaja = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');
                $descrip = $this->input->post('descrip');
                $bfecha = $this->input->post('bfecha');
                $efecha = $this->input->post('efecha');
                $cajafondo = $this->input->post('cajafondo');
                $resolucion = $this->input->post('resolucion');
                $fresolucion = $this->input->post('fresolucion');
                $equipo = $this->input->post('equipo');
                $notas = $this->input->post('notas');
                $xpos = $this->input->post('xpos');
                $estatus = $this->input->post('estado');
                $ucajera = $this->input->post('ucajera');
                $whodidit = $this->session->userdata('iduser');
                
                $this->load->model('location_model');
                $this->load->model('caja_model');
                
                $this->caja_model->updateCaja($idcaja, $descrip, $bfecha, $efecha, $cajafondo, $resolucion, $fresolucion, $equipo, $whodidit, $xpos, $notas, $estatus,$ucajera);
                $invLocations = $this->location_model->getLocationsByCentro($idcentro);
                $ctCajas = $this->caja_model->getCajasByCentro($idcentro);
                
                $listTree = array();
                $itemsUbicaciones = array();
                $itemsCajas = array();
                
                $i=0;$j=0;
                
                foreach($invLocations as $inv){
                    $itemsUbicaciones[$i] = array(
                        "id" => "1_".$inv->idbin,
                        "name" => $inv->descrip,
                        "expanded" => false
                    );
                    $i++;
                }
                
                foreach($ctCajas as $caja){
                    $itemsCajas[$j] = array(
                        "id" => "2_".$caja->idcaja,
                        "name" => $caja->descrip,
                        "expanded" => true
                    );
                    $j++;
                }
                
                $itemsUbicaciones[$i] = array(
                    "id" => "1_0",
                    "name" => "",
                    "iconSrc" => base_url()."img/add3.png",
                    "expanded" => false
                );
                
                $itemsCajas[$j] = array(
                    "id" => "2_0",
                    "name" => "",
                    "iconSrc" => base_url()."img/add3.png",
                    "expanded" => true
                );
                
                $listTree[0] = array(
                    "id" => "1",
                    "name" => "Detalle Ubicaciones",
                    "expanded" => false,
                    "items" => $itemsUbicaciones
                );
                
                $listTree[1] = array(
                    "id" => "2",
                    "name" => "Detalle Cajas",
                    "expanded" => true,
                    "items" => $itemsCajas
                );
                
                echo json_encode($listTree);
            }
        }
        
        function getInformacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcaja = $this->input->post('idcaja');
                $this->load->model('caja_model');
                $array = $this->caja_model->callRegistro($idcaja);
                echo json_encode($array);
            }
        }
        
        function modificarCaja($id){
            $this->load->model('caja_model');
            $this->data['dataCaja'] = $this->caja_model->callRegistro($id);
            $this->load->view('form_update_caja', $this->data);
        }
        
        function eliminarCaja(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcaja = $this->input->post('idcaja');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('caja_model');
                $this->load->model('location_model');
                
                $array = $this->caja_model->deleteCaja($idcaja);
                if($array != false){
                    $invLocations = $this->location_model->getLocationsByCentro($idcentro);
                    $ctCajas = $this->caja_model->getCajasByCentro($idcentro);

                    $listTree = array();
                    $itemsUbicaciones = array();
                    $itemsCajas = array();

                    $i=0;$j=0;

                    foreach($invLocations as $inv){
                    $itemsUbicaciones[$i] = array(
                        "id" => "1_".$inv->idbin,
                        "name" => $inv->descrip,
                        "expanded" => false
                    );
                    $i++;
                }
                
                foreach($ctCajas as $caja){
                    $itemsCajas[$j] = array(
                        "id" => "2_".$caja->idcaja,
                        "name" => $caja->descrip,
                        "expanded" => true
                    );
                    $j++;
                }
                
                $itemsUbicaciones[$i] = array(
                    "id" => "1_0",
                    "name" => "",
                    "iconSrc" => base_url()."img/add3.png",
                    "expanded" => false
                );
                
                $itemsCajas[$j] = array(
                    "id" => "2_0",
                    "name" => "",
                    "iconSrc" => base_url()."img/add3.png",
                    "expanded" => true
                );
                
                $listTree[0] = array(
                    "id" => "1",
                    "name" => "Detalle Ubicaciones",
                    "expanded" => false,
                    "items" => $itemsUbicaciones
                );
                
                $listTree[1] = array(
                    "id" => "2",
                    "name" => "Detalle Cajas",
                    "expanded" => true,
                    "items" => $itemsCajas
                );
                    
                }else{
                    $listTree = false;
                }
                
                echo json_encode($listTree);
            }
        }
        
        function verListCajas(){
            $sucursales = $this->input->post('dato');
            $this->load->model('caja_model');
            $datos = $this->caja_model->getListCaja($sucursales);
            echo json_encode($datos);
        }

        function mantenimientoDeCajas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('login/cerrar_sesion');
            }else{
                $infoApp = array(
                    'appName' => 'Configuración De Cajas',
                    'namePage' => 'Configuración De Cajas'
                );
                $this->session->set_userdata($infoApp);

                $this->load->view('mantenimiento_variable_cajas');
            }
        }

        function getDatosVariablesCajas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $itemIndex = $this->input->post('itemIndex');

                $this->load->model('media_model'); $this->load->model('caja_model');
                
                $informacion = $this->media_model->getDatosVariablesCajas($idcentro, $itemIndex);

                $i=0; $totalVariables=0;
                $array = array();
                foreach($informacion as $info){
                    if($info->tipo_valor == 1){
                        $tipoValor = 'Número';
                    }else if($info->tipo_valor == 2){
                        $tipoValor = 'Texto';
                    }

                    if($itemIndex == 0){
                        $dataGvar = $this->caja_model->getInformacionGvar($info->nombre, $info->tipo_valor);
                        
                        $idrec=0; $valorGvar = '';
                        if($dataGvar != false){
                            $idrec = $dataGvar['idrnum'];
                            $valorGvar = $dataGvar['valor'];
                            if($info->tipo_valor == 1){
                                $valorGvar = number_format($valorGvar, 0, '.', '');
                            }

                            $nuevaGvar = 0;
                        }else{
                            $nuevaGvar = 1;
                            $valorGvar = $info->valor;
                            $totalVariables++;
                            
                            $idrec = $this->caja_model->initGvarsCajas($info->nombre, $info->descripcion, $info->tipo_valor, $info->valor);
                        }

                        $array[$i] = array(
                            "idrec" => $idrec,
                            "nombre" => $info->nombre,
                            "descripcion" => $info->descripcion,
                            "tipo" => $info->tipo_valor,
                            "tipoValor" => $tipoValor,
                            "valorGvar" => $valorGvar,
                            "nuevaGvar" => $nuevaGvar
                        );

                        $i++;
                    }else if($itemIndex == 1){
                        $nombreVariable = $info->nombre . $idcentro;
                        $dataGvar = $this->caja_model->getInformacionGvar($nombreVariable, $info->tipo_valor);
                        
                        $idrec=0; $valorGvar = '';
                        if($dataGvar != false){
                            $idrec = $dataGvar['idrnum'];
                            $valorGvar = $dataGvar['valor'];
                            if($info->tipo_valor == 1){
                                $valorGvar = number_format($valorGvar, 0, '.', '');
                            }

                            $nuevaGvar = 0;
                        }else{
                            $nuevaGvar = 1;
                            $valorGvar = $info->valor;
                            $totalVariables++;
                            
                            $idrec = $this->caja_model->initGvarsCajas($nombreVariable, $info->descripcion, $info->tipo_valor, $info->valor);
                        }

                        $array[$i] = array(
                            "idrec" => $idrec,
                            "nombre" => $nombreVariable,
                            "descripcion" => $info->descripcion,
                            "tipo" => $info->tipo_valor,
                            "tipoValor" => $tipoValor,
                            "valorGvar" => $valorGvar,
                            "nuevaGvar" => $nuevaGvar
                        );

                        $i++;
                    }else if($itemIndex == 2){
                        $listCajas = $this->caja_model->getListadoCajasSucursal($idcentro);

                        if($listCajas != false){
                            foreach($listCajas as $infoCaja){
                                $nombreVariable = $info->nombre . $infoCaja->idcaja;
                                $dataGvar = $this->caja_model->getInformacionGvar($nombreVariable, $info->tipo_valor);
                                
                                $idrec=0; $valorGvar = '';
                                if($dataGvar != false){
                                    $idrec = $dataGvar['idrnum'];
                                    $valorGvar = $dataGvar['valor'];
                                    if($info->tipo_valor == 1){
                                        $valorGvar = number_format($valorGvar, 0, '.', '');
                                    }

                                    $nuevaGvar = 0;
                                }else{
                                    $nuevaGvar = 1;
                                    $valorGvar = $info->valor;
                                    $totalVariables++;
                                    
                                    $idrec = $this->caja_model->initGvarsCajas($nombreVariable, $info->descripcion, $info->tipo_valor, $info->valor);
                                }

                                $array[$i] = array(
                                    "idrec" => $idrec,
                                    "nombre" => $nombreVariable,
                                    "descripcion" => $info->descripcion,
                                    "tipo" => $info->tipo_valor,
                                    "nameCaja" => $infoCaja->nameCaja,
                                    "tipoValor" => $tipoValor,
                                    "valorGvar" => $valorGvar,
                                    "nuevaGvar" => $nuevaGvar
                                );

                                $i++;
                            }
                        }
                    }
                }

                $dataSource = array(
                    "informacion" => $array,
                    "totalVariables" => $totalVariables
                );

                echo json_encode($dataSource);
            }
        }

        function updateInformacionVariable(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $tipo = $this->input->post('tipo');
                $idrnum = $this->input->post('idrnum');
                $valor = $this->input->post('valor');
                $descrip = $this->input->post('descrip');

                $this->load->model('caja_model');
                $array = $this->caja_model->updateInformacionVariable($idrnum, $tipo, $descrip, $valor);

                echo json_encode($array);
            }
        }

        #-------------------------------------------------------------- CONTROL DE CAJAS
            #   VISTA
            public function controlCajas($idApp)
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('CerrarSesion');
                } else {
                    $controlador = $this->uri->segment(1);
                    $idApp = $this->uri->segment(2);

                    $this->load->model('configuracion_model');
                    $result = $this->configuracion_model->confirmarAccesoApp($idApp);
                    $result == true ?: redirect('CerrarSesion');
                    $opcionmenu = $this->configuracion_model->getProCentro($idApp);

                    $appName = $this->configuracion_model->getAppName($idApp);
                    $resultAppName = array(
                        'iddApp' => $idApp,
                        'appName' => $appName,
                        'namePage' => $appName
                    );
                    $this->session->set_userdata($resultAppName);
                    $this->load->model('global_model');
                    $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                    $this->data['OTipo'] = $opcionmenu;
                    //*/
                    $this->load->view('mantenimiento_CCajas', $this->data);
                }
            }
            #   CONSULTAR
            public function getCCajas()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('CerrarSesion');
                } else {
                    $this->load->model('caja_model');
                    $TCaja = (int)$this->input->post('tcaja');
                    $fecha = $this->input->post('fecha');
                    $datos = $this->caja_model->getCCajas($TCaja, $fecha);
                    echo json_encode($datos);
                }
            }
            #   GET MENUS
            public function getMenus()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('CerrarSesion');
                } else {
                    $this->load->model('caja_model');
                    $Datos = [];
                    $datos = $this->caja_model->TMenus();
                    foreach ($datos as $dato) {
                        if ($dato['estado'] == 1) {
                            $Datos[] = $dato;
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                    echo json_encode($datA);
                }
            }
            #   SET OPCION DE MENU EN CAJA
            public function setOptionMenu()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('CerrarSesion');
                } else {
                    $this->load->model('sucursal_model');
                    $this->load->model('caja_model');
                    date_default_timezone_set('America/El_Salvador');
                    $IDCaja = (int)$this->input->post('ID');
                    $IDM = (int)$this->input->post('IDM');
                    $TCaja = (int)$this->input->post('tcaja');
                    $fecha = $this->input->post('fecha');
                    $data = array(
                        'idmenu' => $IDM,
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->sucursal_model->updateCaja($data, $IDCaja)) {
                        $datos = $this->caja_model->getCCajas($TCaja, $fecha);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else $datA[] = array('valido' => false, 'tipo' => 0);
                    echo json_encode($datA);
                }
            }
        #-

        #-------------------------------------------------------------- GOXCAJAS MENUS
            #   VISTA
            public function goxCajaM($idApp)
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('login/cerrar_sesion');
                } else {
                    $controlador = $this->uri->segment(1);
                    $idApp = $this->uri->segment(2);
    
                    $this->load->model('configuracion_model');
                    $result = $this->configuracion_model->confirmarAccesoApp($idApp);
                    $result == true ?: redirect('CerrarSesion');
                    $opcionmenu = $this->configuracion_model->getProCentro($idApp);
    
                    $appName = $this->configuracion_model->getAppName($idApp);
                    $resultAppName = array(
                        'iddApp' => $idApp,
                        'appName' => $appName,
                        'namePage' => $appName
                    );
                    $this->session->set_userdata($resultAppName);
                    $this->load->model('global_model');
                    $this->load->model('caja_model');
                    $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                    $this->data['TMenus'] = $this->caja_model->TMenus();
                    //*/
                    $this->load->view('mantenimiento_GCMenus', $this->data);
                }
            }
            #   LOAD DEPTOS
            public function getDeptos()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('login/cerrar_sesion');
                } else {
                    $this->load->model('caja_model');
                    $datos = $this->caja_model->getDeptos14();
                    $datA[] = array('valido' => true, 'datos' => $datos);
                    echo json_encode($datA);
                }
            }
            #   AGREGAR MENU
            public function addMenu()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                } else {
                    $this->load->model('caja_model');
                    date_default_timezone_set('America/El_Salvador');
                    $submenus = $this->input->post('submenus');
                    $refact = [];
                    foreach(explode("\n", $submenus) as $tsmenu) {
                        $refact[] = trim($tsmenu);
                    }
                    $submenus = implode(',', $refact);
                    $data = array(
                        'descrip' => $this->input->post('nombre'),
                        'submenus' => $submenus,

                        'notas' => $this->input->post('notas'),
                        'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->caja_model->setMenu($data)) {
                        $datos = $this->caja_model->TMenus();
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else $datA[] = array('valido' => false, 'tipo' => 1);
                    echo json_encode($datA);
                }
            }
            #   EDITAR MENU
            public function updateMenu()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('login/cerrar_sesion');
                } else {
                    $this->load->model('caja_model');
                    date_default_timezone_set('America/El_Salvador');
                    $ID = (int)$this->input->post('ID');
                    $data = array(
                        'descrip' => $this->input->post('nombre'),
    
                        'notas' => $this->input->post('notas'),
                        'estado' => ($this->input->post('estado') == "true") ? 1 : 0,
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->caja_model->updateMenu($data, $ID)) {
                        $datos = $this->caja_model->TMenus();
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else $datA[] = array('valido' => false, 'tipo' => 1);
                    echo json_encode($datA);
                }
            }
            #   TXT
            public function getDataMenu($IDM)
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('login/cerrar_sesion');
                } else {
                    $this->load->model('caja_model');
                    $this->load->helper('download');
                    $Menu = $this->caja_model->getMenu($IDM);
                    if (count((array)$Menu) > 0) {
                        $data = [];
                        $datos = $this->caja_model->getDataMenu($IDM);
                        if ($datos->num_rows() > 0) {
                            foreach ($datos->result() as $boton) {
                                $momento = array(
                                    $boton->smenu_name,
                                    $boton->boton_code,
                                    $boton->boton_tit,
                                    (($boton->boton_pm == 0) ? $boton->precioventa : $boton->boton_pv),
                                    $boton->tipo
                                );
                                $data[] = implode(',', $momento);
                            }
                        }
                        if(count($data) > 0) $data = implode("\r\n", $data);
                        else $data = ' ';
                        $name = 'Menu-'.$IDM.'.txt';
                        force_download($name, $data);//*/
                    } else echo "-";
                }
            }
            
            #------------SUB MENUS
            #   GET SUB MENUS
            public function getSubsMenusC()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('login/cerrar_sesion');
                } else {
                    $this->load->model('caja_model');
                    $ID = (int)$this->input->post('ID');
                    $Data = $this->caja_model->getSubsMenusC($ID);
                    $deptos = $this->caja_model->getDeptos14();
                    $Data[0]['deptos'] = $deptos;
                    echo json_encode($Data);
                }
            }
            #   SET SUB MENU BTN
            public function setSubMenu()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('login/cerrar_sesion');
                } else {
                    date_default_timezone_set('America/El_Salvador');
                    $this->load->model('caja_model');
                    $ID = (int)$this->input->post('ID');
                    $nn = $this->input->post('nn');

                    $Menu = $this->caja_model->getMenu($ID);
                    $refact = [];

                    if (strlen(trim($Menu->submenus)) > 0) {
                        $refact = explode(',', $Menu->submenus);
                        $refact[] = $nn;
                    } else $refact[] = $nn;
                    $data = array(
                        'submenus' => implode(',', $refact),
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->caja_model->updateMenu($data, $ID)) {
                        $Data = $this->caja_model->getSubsMenusC($ID);
                        $datA = $Data;
                    } else $datA[] = array('valido' => false, 'tipo' => 0);
                    echo json_encode($datA);
                }
            }
            #   UPDATE SUB MENUS-BOTONS ALL
            public function updateSubMenuAll()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('login/cerrar_sesion');
                } else {
                    $this->load->model('caja_model');
                    $ID = (int)$this->input->post('ID');
                    $old = $this->input->post('oldn');
                    $nn = $this->input->post('nn');
                    $respuesta = $this->caja_model->updateSubMenuAll($ID, $old, $nn);
                    if ($respuesta == 7) {
                        $Data = $this->caja_model->getSubsMenusC($ID);
                        $datA = $Data;
                    } else $datA[] = array('valido' => false, 'tipo' => $respuesta);
                    echo json_encode($datA);
                }
            }
            #   DELETE SUB MENUS-BOTONS ALL
            public function deleteSubMenuAll()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('login/cerrar_sesion');
                } else {
                    $this->load->model('caja_model');
                    $ID = (int)$this->input->post('ID');
                    $old = $this->input->post('oldn');
                    if ($this->caja_model->deleteSubMenuAll($ID, $old)) {
                        $Data = $this->caja_model->getSubsMenusC($ID);
                        $datA = $Data;
                    } else $datA[] = array('valido' => false, 'tipo' => 1);
                    echo json_encode($datA);
                }
            }

            #------- DETALLE
            #   VISTA
            public function goxCajaMDetalle($IDM)
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('login/cerrar_sesion');
                } else {
                    $valido = 0;
                    $submenus = [];
                    $Productos1 = [];
                    $Productos4 = [];
                    $txt = '';
                    if ($IDM != null && is_numeric($IDM)) {
                        $this->load->model('caja_model');
                        $Menu = $this->caja_model->getMenu($IDM);
                        if (count((array)$Menu) > 0) {
                            $txt = $Menu->descrip;
                            $valido = 1;
                            $Productos1 = $this->caja_model->getAllProductosT(1);
                            $Productos4 = $this->caja_model->getAllProductosT(4);
                            //$submenus = implode(',', $Menu->submenus);
                            if (strlen(trim($Menu->submenus)) > 0) {
                                $cont = 1;
                                foreach (explode(',', $Menu->submenus) as $dato) {
                                    $submenus[] = array(
                                        'ID' => $cont++,
                                        'Name' => $dato
                                    );
                                }
                            }
                        }
                    }
                    $resultAppName = array(
                        'namePage' => 'Detalle de Menu - '.$txt
                    );
                    $this->session->set_userdata($resultAppName);
                    $direccion = $this->uri->segment(1);
                    $this->load->model('global_model');
                    $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                    $this->data['valido'] = $valido;
                    $this->data['submenus'] = $submenus;
                    $this->data['productos1'] = $Productos1;
                    $this->data['productos4'] = $Productos4;
                    $this->data['IDM'] = $IDM;
                    $this->load->view('mantenimiento_GCMenusDetalle', $this->data);
                }
            }
            #   GET BOTONES
            public function getBtns()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                    redirect('login/cerrar_sesion');
                } else {
                    $IDM = $this->input->post('IDM');
                    $submenu = $this->input->post('submenu');
                    $this->load->model('caja_model');
                    /*$Datos = [];
                    for ($i=0; $i < 64; $i++) { 
                        $Datos[] = array(
                            'idr' => 0,
                            'id' => $i + 1,
                            'idp' => 0,
                            'opp' => 0,
                            'pp' => 0,
                            'nboton' => '',
                            'ocupado' => false,
                        );
                    }
                    $datosc = $this->caja_model->getDBtns($IDM, $submenu);
                    if ($datosc->num_rows() > 0) {
                        foreach ($datosc->result() as $datoc) {
                            //print_r($datoc);
                            $Datos[$datoc->boton_id - 1] = array(
                                'idr' => (int)$datoc->idrec,
                                'id' => (int)$datoc->boton_id,
                                'idp' => (int)$datoc->boton_code,
                                'opp' => (int)$datoc->boton_pm,
                                'pp' => $datoc->boton_pv,
                                'nboton' => $datoc->boton_tit,
                                'ocupado' => true,
                            );
                        }
                    }//*/
                    $Datos = $this->caja_model->getDBtns($IDM, $submenu);
                    echo json_encode($Datos);
                }
            }
            #   SET BOTON
            public function setBtn()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                } else {
                    $this->load->model('caja_model');
                    date_default_timezone_set('America/El_Salvador');
                    $IDM = (int)$this->input->post('IDM');
                    $submenu = trim($this->input->post('nombreM'));
                    $pos = $this->caja_model->getPosSubMenu($IDM, $submenu);
                    $data = array(
                        'idmenu' => $IDM,
                        'smenu_name' => $submenu,
                        'smenu_pos' => $pos,
                        'boton_id' => (int)$this->input->post('idbtn'),
                        'boton_code' => (int)$this->input->post('idp'),
                        'boton_tit' => $this->input->post('nombre'),
                        'boton_pm' => 0,
                        'estado' => 1,
                        'notas' => '',
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s'),
                    );
                    //print_r($data);
                    if ($this->caja_model->setSubMenuBtn($data)){
                        $datos = $this->caja_model->getDBtns($IDM, $submenu);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else $datA[] = array('valido' => false, 'tipo' => 1);
                    echo json_encode($datA);
                }
            }
            #  UPDATE SIMPLE BOTON
            public function updateSimBtn()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                } else {
                    $this->load->model('caja_model');
                    date_default_timezone_set('America/El_Salvador');
                    $IDM = (int)$this->input->post('IDM');
                    $submenu = trim($this->input->post('nombreM'));
                    $IDR = (int)$this->input->post('idr');

                    $data = array(
                        'boton_tit' => $this->input->post('nombre'),
                        'boton_pm' => ($this->input->post('opp') == "true") ? 1 : 0,
                        'boton_pv' => $this->input->post('pp'),
                        'notas' => $this->input->post('notas'),

                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->caja_model->updateSubMenuBtn($data, $IDR)) {
                        $datos = $this->caja_model->getDBtns($IDM, $submenu);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else $datA[] = array('valido' => false, 'tipo' => 1);
                    echo json_encode($datA);
                }
            }
            #   DESACTUALIZAR SUB MENU-BOTON
            public function desupdateBtn()
            {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                } else {
                    $this->load->model('caja_model');
                    date_default_timezone_set('America/El_Salvador');
                    $IDM = (int)$this->input->post('IDM');
                    $submenu = trim($this->input->post('nombreM'));
                    $IDR = (int)$this->input->post('idr');
                    $data = array(
                        'estado' => 0,
                        'whodidit' => $this->session->userdata('iduser'),
                        'modifica' => date_create()->format('Y-m-d H:i:s'),
                    );
                    if ($this->caja_model->updateSubMenuBtn($data, $IDR)) {
                        $datos = $this->caja_model->getDBtns($IDM, $submenu);
                        $datA[] = array('valido' => true, 'datos' => $datos);
                    } else $datA[] = array('valido' => false, 'tipo' => 1);
                    echo json_encode($datA);
                }
            }
        #-
    }
?>