<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require 'vendor/autoload.php';

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
     
    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

    class Arap extends CI_Controller {
        
        function __construct(){
            parent::__construct(); 
        }

        function highlight_array($array, $name = 'var') {
            highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
        }
        
        //CUENTAS POR COBRAR
        function vercuentas_ar2($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $mensaje = array(
                    'error' => 0,
                );
                $idempleado = $this->uri->segment(4);
                
                $this->session->set_userdata($mensaje);
                $this->load->model('empleado_model');
                $empleados = $this->empleado_model->viewEmple();
                $this->data['emple_data'] = $empleados;
                $idvendedor = $idempleado;
                $this->data['idempleado'] = $idvendedor;
                
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                
                $this->load->model('arap_model');        
                $this->load->model('ventas_model');  
                $this->data['formasCargo'] = $this->arap_model->formasPago_ar("1");
                $this->data['formasAbono'] = $this->arap_model->formasPago_ar("-1");
                //$this->data['data_vendedor'] = $this->arap_model->getCuentas_ar($idvendedor);
                //$this->data['data_clientes'] = $this->arap_model->getClientes_ar($idvendedor);
                $this->load->view('mantenimiento_ventas_cuentasporcobrar', $this->data);
            }
        }
        
        function vercuentas_ar($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $mensaje = array(
                    'error' => 0,
                );
                $idempleado = $this->uri->segment(4);
                
                $this->session->set_userdata($mensaje);
                $this->load->model('empleado_model');
                $empleados = $this->empleado_model->viewEmple();
                $this->data['emple_data'] = $empleados;
                $idvendedor = $idempleado;
                $this->data['idempleado'] = $idvendedor;
                
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                
                $this->load->model('arap_model');        
                $this->load->model('ventas_model');  
                $this->data['formasCargo'] = $this->arap_model->formasPago_ar("1");
                $this->data['formasAbono'] = $this->arap_model->formasPago_ar("-1");
                $this->load->view('mantenimiento_ventas_cuentasporcobrar2', $this->data);
            }
        }
        
        function getData_ar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $invendedor = $this->input->post('invendedor');
                $this->load->model('arap_model');                
                $this->load->model('invtran_model');                
                $data = $this->arap_model->getCuentas_ar($invendedor);
                
                $i=0;
                $objeto_datos = array();
                if($data!=false)
                {
                    foreach($data as $dat){
                        $detalles = $this->invtran_model->getDataTran100k2($dat->trannum);
                        $i2=0;
                        $objeto_datos2 = array();
                        foreach($detalles as $det){
                            $objeto_datos2[$i2] = array(
                                "itemline" => $det->itemline,
                                "idproducto" => $det->idproducto,
                                "modelo" => $det->modelo,
                                "descrip" => $det->descrip,
                                "cantidad" => abs($det->cantidad),
                                "precioneto" => $det->precioneto
                            );
                            $i2++;
                        }
                        $cargos=0;
                        $abonos=0;
                        if($dat->cargos<0){
                            $abonos= abs($dat->cargos);
                            $cargos=abs($dat->abonos);
                        }else{
                            $abonos=$dat->abonos;
                            $cargos=$dat->cargos;
                        }
                        $objeto_datos[$i] = array(
                            "estado" => $dat->ccestatus,
                            "ccestatus" => $dat->ccestatus,
                            "trannum" => $dat->trannum,
                            "tipoDoc" => $dat->tipoDoc,
                            "numero" => $dat->numero,
                            "dias" => $dat->dias,
                            "fecha" => $dat->fecha,
                            "fecha_format" => $dat->fecha_format,
                            "idcliente" => $dat->idcliente,
                            "cliente" => $dat->cliente,
                            "cargos" => $cargos,
                            "abonos" => $abonos,
                            "saldo" => $dat->saldo,
                            "tipo" => $dat->inopera,
                            "tasks" => $objeto_datos2
                        );
                        $i++;
                    }
                    $array = array(
                        "datos" => $objeto_datos
                    );
                    }else{
                        $array = array(
                        "datos" => false
                    );
                }
                echo json_encode($array);
            }
        }
        
        function getData_ar_Todos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');                
                $this->load->model('invtran_model');                
                $data = $this->arap_model->getCuentas_ar_todos();
                
                $i=0;
                $objeto_datos = array();
                if($data!=false)
                {
                    foreach($data as $dat){
                        /*$detalles = $this->invtran_model->getDataTran100k2($dat->trannum);
                        $i2=0;
                        $objeto_datos2 = array();
                        foreach($detalles as $det){
                            $objeto_datos2[$i2] = array(
                                "itemline" => $det->itemline,
                                "idproducto" => $det->idproducto,
                                "modelo" => $det->modelo,
                                "descrip" => $det->descrip,
                                "cantidad" => abs($det->cantidad),
                                "precioneto" => $det->precioneto,
                                "tipotax" => $det->tipotax/100,
                                "nameVendedor" => $dat->nameVendedor
                            );
                            $i2++;
                        }*/
                        $cargos=0;
                        $abonos=0;
                        if($dat->cargos<0){
                            $abonos= abs($dat->cargos);
                            $cargos=abs($dat->abonos);
                        }else{
                            $abonos=$dat->abonos;
                            $cargos=$dat->cargos;
                        }
                        $objeto_datos[$i] = array(
                            "estado" => $dat->ccestatus,
                            "ccestatus" => $dat->ccestatus,
                            "trannum" => $dat->trannum,
                            "tipoDoc" => $dat->tipoDoc,
                            "numero" => $dat->numero,
                            "dias" => $dat->dias,
                            "grupoCliente" => $dat->grupoCliente,
                            "fecha" => $dat->fecha,
                            "fecha_format" => $dat->fecha_format,
                            "idcliente" => $dat->idcliente,
                            "cliente" => $dat->cliente,
                            "cargos" => $cargos,
                            "abonos" => $abonos,
                            "saldo" => $dat->saldo,
                            "tipo" => $dat->inopera,
                            "nameVendedor" => $dat->nameVendedor,
                            //"tasks" => $objeto_datos2
                        );
                        $i++;
                    }
                    
                    echo json_encode($objeto_datos);
                }else{
                    echo json_encode(false);
                }
            }
        }
        
        function getProducts_CC(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('invtran_model');                
                $i=0;
                $objeto_datos = array();
                $detalles = $this->invtran_model->getDataTran100k2($trannum);
                foreach($detalles as $det){
                    $detalle_pro = "";

                    if($det->notas!=""){
                        $detalle_pro = $det->descrip." ".$det->notas;
                    }else{
                        $detalle_pro = $det->descrip;
                    }
                    
                    $objeto_datos[$i] = array(
                        "itemline" => $det->itemline,
                        "idproducto" => $det->idproducto,
                        "modelo" => $det->modelo,
                        "descrip" => $detalle_pro,
                        "cantidad" => abs($det->cantidad),
                        "precioneto" => $det->precioneto*1,
                        "tipotax" => $det->tipotax/100,
                        "precio_neto_show" => (($det->precioneto*1) * ($det->tipotax/100)) + ($det->precioneto*1) ,
                        "subtotal_show" => ((($det->precioneto*1) * ($det->tipotax/100)) + ($det->precioneto*1) ) * abs($det->cantidad),
                    );
                    $i++;
                }
                echo json_encode($objeto_datos);
            }
        }
        
        function getProducts_CP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('invtran_model');                
                $i=0;
                $objeto_datos = array();
                $detalles = $this->invtran_model->getDataTran100k2($trannum);
                foreach($detalles as $det){
                    $objeto_datos[$i] = array(
                        "itemline" => $det->itemline,
                        "idproducto" => $det->idproducto,
                        "modelo" => $det->modelo,
                        "descrip" => $det->descrip,
                        "cantidad" => abs($det->cantidad),
                        "precioneto" => $det->preciotran*1,
                        "tipotax" => $det->tipotax/100,
                        "precio_neto_show" => $det->preciotran*1,
                        "subtotal_show" =>  ($det->preciotran*1)  * abs($det->cantidad),
                    );
                    $i++;
                }
                echo json_encode($objeto_datos);
            }
        }
        
        function detalleCuenta_ar($tranum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                 $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$tranum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('arap_model');
                $this->load->model('empleado_model');
                $this->data['vendedores'] = $this->empleado_model->viewEmpleActivo();
                $this->data['detalle'] = $this->arap_model->getDetalleCuenta_ar($tranum);
                $this->data['fechamin'] = $this->arap_model->getFechaEmision_ar($tranum);
                $this->data['monto'] = $this->arap_model->getMonto_ar($tranum);
                $this->data['trannum'] = $tranum;
                $this->data['detailsCuenta'] = $this->arap_model->detailsCuenta_ar($tranum);
                $this->data['detailsTrans'] = $this->arap_model->detailsTrans_ar($tranum);
                $this->data['formasCargo'] = $this->arap_model->formasPago_ar("1");
                $this->data['formasAbono'] = $this->arap_model->formasPago_ar("-1");
                $this->load->view('mantenimiento_detalle_ventasporcobrar', $this->data); 
            }
        }
        
        function get_facturas_cliente(){
            $cliente = $this->input->post('cliente');
            $idempleado = $this->input->post('idempleado');
            $this->load->model('arap_model');
            $datos = $this->arap_model->get_facturas_cliente($cliente,$idempleado);
            echo json_encode($datos);
        }
        function get_facturas_pendientes_cliente(){
            $cliente = $this->input->post('cliente');
            $valor = $this->input->post('valor');
            $this->load->model('arap_model');
            $datos = $this->arap_model->get_facturas_pendientes_cliente($cliente,$valor);
            echo json_encode($datos);
        }
        
        function get_dev_fact(){
            $trannum_factura = $this->input->post('trannum_factura');
            $this->load->model('arap_model');
            $saldo = $this->arap_model->get_dev_fact($trannum_factura);
            echo json_encode($saldo);
        }
        
        function savecuenta_ar(){
            $trannum = $this->input->post('trannum');
            $fecha = $this->input->post('fechaingreso');
            $cajclase = $this->input->post('formasPago');
            $idworker = $this->input->post('vendedor');
            $descrip = $this->input->post('descrip');
            $valor = $this->input->post('valor');
            $referencia = $this->input->post('referencia');
            $whodidit = $this->session->userdata('iduser');
            $this->load->model('arap_model');
                    
            $itemline = $this->arap_model->insertCuenta_ar($trannum, $fecha, $cajclase, $idworker, $descrip, $valor, $referencia, $whodidit);
            $actualiza = $this->arap_model->actualizaItemLine_ar($trannum, $itemline,$whodidit);
            $update_ccstatus = $this->arap_model->updateccestatus_ar($trannum);

            redirect('arap/detalleCuenta_ar/'.$trannum);
        }
        
        function updatecuenta_ar(){
            $idrec = $this->input->post('idrec');
            $trannum = $this->input->post('trannum');
            $opc = $this->input->post('opc');
            $fecha = $this->input->post('fechaingreso');
            $cajclase = $this->input->post('formasPago');
            $idworker = $this->input->post('vendedor');
            $descrip = $this->input->post('descrip');
            $valor = $this->input->post('valor');
            $notas = $this->input->post('notas');
            $referencia = $this->input->post('referencia');
            $whodidit = $this->session->userdata('iduser');
            $this->load->model('arap_model');
            if($opc==1){
                $itemline = $this->arap_model->updateCuenta_ar($idrec,$trannum, $fecha, $cajclase, $idworker, $descrip, $valor, $referencia, $whodidit);
            }
            
            if($opc==2){
                $itemline = $this->arap_model->deleteCuenta_ar($idrec, $trannum, $whodidit,$notas);
            }
            
            redirect('arap/detalleCuenta_ar/'.$trannum);
        }
        
        //CUENTAS POR PAGAR
        function vercuentas_ap($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->load->view('mantenimiento_cuentasporpagar', $this->data);
            }
        }
        
        function getData_ap(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');                
                $this->load->model('invtran_model');                
                $data = $this->arap_model->getCuentas_ap();
                
                $i=0;
                $objeto_datos = array();
                if($data!=false)
                {
                    foreach($data as $dat){
                    $detalles = $this->invtran_model->getDataTran100k($dat->trannum);
                    $i2=0;
                    $objeto_datos2 = array();
                    foreach($detalles as $det){
                        $objeto_datos2[$i2] = array(
                            "itemline" => $det->itemline,
                            "idproducto" => $det->idproducto,
                            "modelo" => $det->modelo,
                            "descrip" => $det->descrip,
                            "cantidad" => abs($det->cantidad),
                            "preciotran" => $det->preciotran,
                            "ubicacion" => $det->ubicacion,
                            "lote" => $det->lote
                        );
                        $i2++;
                    }
                    $objeto_datos[$i] = array(
                        "ccestatus" => $dat->ccestatus,
                        "trannum" => $dat->trannum,
                        "tipoDoc" => $dat->tipoDoc,
                        "numero" => $dat->s_n,
                        "dias" => $dat->dias,
                        "fecha" => $dat->fecha,
                        "idcliente" => $dat->idcliente,
                        "cliente" => $dat->cliente,
                        "cargos" => $dat->cargos,
                        "abonos" => $dat->abonos,
                        "saldo" => $dat->saldo,
                        "tasks" => $objeto_datos2
                    );
                    $i++;
                }
                
                $array = array(
                    "datos" => $objeto_datos,
                    "detalles" => $detalles
                );
                }else{
                    $array = array(
                    "datos" => false,
                    "detalles" => false
                );
                }
                
                
              
                echo json_encode($array);
            }
        }
               
        function detalleCuenta_ap($tranum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$tranum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('arap_model');
				$this->load->model('empleado_model');
				$this->load->model('global_model');
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['vendedores'] = $this->empleado_model->viewEmpleActivo(); 
                $this->data['detalle'] = $this->arap_model->getDetalleCuenta_ar($tranum);
                $this->data['fechamin'] = $this->arap_model->getFechaEmision_ar($tranum);
                $this->data['monto'] = $this->arap_model->getMonto_ap($tranum);
                $this->data['trannum'] = $tranum;
                $this->data['detailsCuenta'] = $this->arap_model->detailsCuenta_ap($tranum);
                $this->data['detailsTrans'] = $this->arap_model->detailsTrans_ap($tranum);
                $this->data['formasCargo'] = $this->arap_model->formasPago_ap("1");
                $this->data['formasAbono'] = $this->arap_model->formasPago_ap("-1");
                $this->load->view('mantenimiento_detalle_cuentasporpagar', $this->data); 
            }
        }
        
        function savecuenta_ap(){
            $trannum = $this->input->post('trannum');
            $fecha = $this->input->post('fechaingreso');
            $cajclase = $this->input->post('formasPago');
            $idworker = $this->input->post('vendedor');
            $descrip = $this->input->post('descrip');
            $valor = $this->input->post('valor');
            $referencia = $this->input->post('referencia');
            $whodidit = $this->session->userdata('iduser');
            $this->load->model('arap_model');
                    
            $itemline = $this->arap_model->insertCuenta_ar($trannum, $fecha, $cajclase, $idworker, $descrip, $valor, $referencia, $whodidit);
            $actualiza = $this->arap_model->actualizaItemLine_ar($trannum, $itemline,$whodidit);
            $actualiza_estado = $this->arap_model->updateccestatus_ap($trannum);
            redirect('arap/detalleCuenta_ap/'.$trannum);
        }    
        
        function updatecuenta_ap(){
            $idrec = $this->input->post('idrec');
            $trannum = $this->input->post('trannum');
            $opc = $this->input->post('opc');
            $fecha = $this->input->post('fechaingreso');
            $cajclase = $this->input->post('formasPago');
            $idworker = $this->input->post('vendedor');
            $descrip = $this->input->post('descrip');
            $valor = $this->input->post('valor');
            $notas = $this->input->post('notas');
            $referencia = $this->input->post('referencia');
            $whodidit = $this->session->userdata('iduser');
            $this->load->model('arap_model');
            if($opc==1){
                $itemline = $this->arap_model->updateCuenta_ar($idrec,$trannum, $fecha, $cajclase, $idworker, $descrip, $valor, $referencia, $whodidit);
            }
            if($opc==2){
                $itemline = $this->arap_model->deleteCuenta_ar($idrec, $trannum, $whodidit,$notas);
            }
            redirect('arap/detalleCuenta_ap/'.$trannum);
        }
        
        function update_dev_fact(){
            $trannum_factura = $this->input->post('trannum_factura');
            $trannum_dev = $this->input->post('trannum_dev');
            $valor = $this->input->post('valor');
            $fecha = $this->input->post('fecha');
            $formapago_factura = $this->input->post('formapago_factura');
            $formapago_dev = $this->input->post('formapago_dev');
            $vendedor = $this->input->post('vendedor');
            $notas = $this->input->post('notas');
            $whodidit = $this->session->userdata('iduser');
            $this->load->model('arap_model');
            $this->load->model('invtran_model');
                    
            $itemline_fact = $this->arap_model->insertCuenta_ar($trannum_factura, $fecha, $formapago_factura, $vendedor, $notas, $valor, 0, $whodidit);
            $actualiza_fact = $this->arap_model->actualizaItemLine_ar($trannum_factura, $itemline_fact,$whodidit);
            $update_ccstatus_fact = $this->arap_model->updateccestatus_ar($trannum_factura);

            $itemline_dev = $this->arap_model->insertCuenta_ar($trannum_dev, $fecha, $formapago_dev, $vendedor, $notas, $valor, 0, $whodidit);
            $actualiza_dev = $this->arap_model->actualizaItemLine_ar($trannum_dev, $itemline_dev,$whodidit);
            $update_ccstatus_dev = $this->arap_model->updateccestatus_ar($trannum_dev);
                
            $data = $this->arap_model->getCuentas_ar($vendedor);
            $i=0;
            $objeto_datos = array();
            if($data!=false)
            {
                foreach($data as $dat){
                    $detalles = $this->invtran_model->getDataTran100k2($dat->trannum);
                    $i2=0;
                    $objeto_datos2 = array();
                    foreach($detalles as $det){
                        $objeto_datos2[$i2] = array(
                            "itemline" => $det->itemline,
                            "idproducto" => $det->idproducto,
                            "modelo" => $det->modelo,
                            "descrip" => $det->descrip,
                            "cantidad" => abs($det->cantidad),
                            "precioneto" => $det->precioneto
                        );
                        $i2++;
                    }
                    $cargos=0;
                    $abonos=0;
                    if($dat->cargos<0){
                        $abonos= abs($dat->cargos);
                        $cargos=abs($dat->abonos);
                    }else{
                        $abonos=$dat->abonos;
                        $cargos=$dat->cargos;
                    }
                    $objeto_datos[$i] = array(
                        "estado" => $dat->ccestatus,
                        "ccestatus" => $dat->ccestatus,
                        "trannum" => $dat->trannum,
                        "tipoDoc" => $dat->tipoDoc,
                        "numero" => $dat->numero,
                        "dias" => $dat->dias,
                        "fecha" => $dat->fecha,
                        "fecha_format" => $dat->fecha_format,
                        "idcliente" => $dat->idcliente,
                        "cliente" => $dat->cliente,
                        "cargos" => $cargos,
                        "abonos" => $abonos,
                        "saldo" => $dat->saldo,
                        "tipo" => $dat->inopera,
                        "tasks" => $objeto_datos2
                    );
                    $i++;
                }
                $array = array(
                    "datos" => $objeto_datos
                );
            }else{
                $array = array(
                    "datos" => false
                );
            }
            echo json_encode($array);
        }
        
        function cobrosyventas($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->load->view('mantenimiento_cobrosyventas', $this->data);
            }
        }
        
        function getDatosVentasyCobros(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $fechaini = $this->input->post("fechaini"); 
                $fechafin = $this->input->post("fechafin"); 
                $this->load->model('arap_model');            
                
                $zonas = $this->arap_model->getZonasPeriodo($fechaini,$fechafin);
                $array = array();
                $i=0;
                foreach($zonas as $zn){
                    $zona = $zn->zona;
                    $info_zona = $this->arap_model->getDatosVentasyCobros($zona,$fechaini,$fechafin);
                    
                    $total_fact=0;
                    $ventaneta=0;
                    $devolucion=0;
                    foreach($info_zona as $in){
                        $total_fact+= $in->num_facturas;
                        $devolucion += $in->devoluciones;
                        $ventaneta += $in->ventaneta;
                    }
                    $cobrado = $this->arap_model->getCobradoZona($zona,$fechaini,$fechafin);
                    $detalle = $this->arap_model->detailTranZona($zona,$fechaini,$fechafin);
                    
                    $total = $ventaneta+$devolucion;
                    $porcobrar = abs($total)-abs($cobrado);
                    
                    $porcentaje = (abs($cobrado)/abs($total))*100;
                    $array[$i]= array(
                        "zona"=>$zona,           
                        "num_facturas"=>$total_fact,           
                        "ventaneta"=>$ventaneta,           
                        "devoluciones"=>$devolucion,           
                        "total"=>$total,   
                        "cobrado"=>abs($cobrado),
                        "porcentaje"=>number_format(round(abs($porcentaje), 2),2)."%",
                        "porcobrar"=>$porcobrar,
                        "transacciones"=>$detalle
                    );
                    $i++;
                }
                echo json_encode($array);
             }
        }
        
        function mantenimiento_cxc($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('empleado_model');
                $this->load->model('sucursal_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['emple_data'] = $this->empleado_model->viewEmple();
                $this->data['sucursales'] = $this->sucursal_model->viewSucursales_activas_asc();

                $this->load->view('mantenimiento_cxc', $this->data);
            }
        }
        
        function mantenimiento_detalle_cxc($idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                 $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName')
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');   
                $this->load->model('empleado_model');
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $this->load->model('variable_model');
                date_default_timezone_set('America/El_Salvador');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
				$this->data['pass_delete'] = $this->global_model->getValorNumVariable("cc_clave");
                $this->data['allow_cruce'] = $this->global_model->getValorNumVariable("cc_cruce");
                $cajclase_abono = $this->global_model->getValorNumVariable("cc_abono");
                $cajclase_cargo = $this->global_model->getValorNumVariable("cc_cargo");
                $this->data['cajclase_abono'] = round($cajclase_abono);
                $this->data['cajclase_cargo'] = round($cajclase_cargo);
				$permite_eliminar = $this->variable_model->getTextVar("cc_clave");
                if($permite_eliminar!=false){
                    $permite_eliminar = 1;
                }else{
                    $permite_eliminar = 0;
                }
				$this->data['permite_eliminar'] = $permite_eliminar;
                $this->data['idauxi'] = $idauxi;

                $idcredito = $this->arap_model->getBalanceCarteraCreditchk();
                $info= $this->arap_model->getInfoClienteCredito($idauxi, $idcredito, 0);

                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;

                /* DATOS DEL AUXI */
                $infoAuxi =  $this->auxi_model->getInfoAuxi($idauxi);
                $idauxi = $infoAuxi['idauxi'];
                $descrip = $infoAuxi['descrip'];
                $grupo = $infoAuxi['grupo'];
                $dias = $infoAuxi['dias'];
                $limite = $infoAuxi['limite'];

                /* DATOS DEL VENDEDOR */
                $infoVendedor =  $this->auxi_model->getInfoAuxi($infoAuxi['idcps']);
                if($infoVendedor){
                    $idvendedor = $infoVendedor['idauxi'];
                    $vendedor = $infoVendedor['descrip'];
                }else{
                    $idvendedor = $infoAuxi['idcps'];
                    $vendedor = '';
                }

                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30 += $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60 += $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90 += $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99 += $in->saldo;
                    }
                }
                
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = ($limite == "") ? 0 : $limite-$sum;//.j
                $this->data['descrip'] = $descrip;
				$this->data['grupo'] = $grupo;
				$this->data['vendedor'] = $vendedor;
				$this->data['idvendedor'] = $idvendedor;
				$this->data['sum_1_30'] = $sum_1_30;
				$this->data['sum_31_60'] = $sum_31_60;
				$this->data['sum_61_90'] = $sum_61_90;
				$this->data['sum_91_99'] = $sum_91_99;
				$this->data['saldo'] = $sum;
				$this->data['dias'] = $dias;
				$this->data['limite'] = $limite;
				$this->data['facturas'] = $info;
				$this->data['disponible'] = $disponible;
                $this->data['formasCargo'] = $this->arap_model->formasPago_ar("1");
                $this->data['formasAbono'] = $this->arap_model->formasPago_ar("-1");
                $this->data['vendedores'] = $this->empleado_model->viewEmpleActivo();
                $this->data['vendedores_update'] = $this->empleado_model->viewEmple();
                $this->data['factual'] = date_create()->format('Y-m-d');
                $this->data['finicial'] = date('Y-m-d', strtotime("-60 days"));
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                
                $this->data['array_ant'] = $array_ant;
                $this->load->view('mantenimiento_detalle_cxc', $this->data); 
            }
        }
        #   GET DATA DE CXC 
        public function getDataCxC()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('arap_model');
                $idauxi = (int)$this->input->post('idauxi');

                $notasCredito = [];
                $tabonos = [];
                $tcargos = [];

                $datos = $this->arap_model->getDataCxC(0, $idauxi);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $notasCredito[] = array(
                            'ID' => (int)$dato->trannum,
                            'Name' => $dato->serie.$dato->numero,
                            'montov' => number_format((float)abs($dato->monto), 2, '.', ','),
                            'fecha' => $dato->fecha,
                        );
                    }
                }

                $datos = $this->arap_model->getDataCxC(1);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        if ($dato->alcuadre == 1) {
                            $tcargos[] = array(
                                'ID' => (int)$dato->cajclase,
                                'Name' => $dato->descrip
                            );
                        } else {
                            $tabonos[] = array(
                                'ID' => (int)$dato->cajclase,
                                'Name' => $dato->descrip
                            );
                        }
                    }
                }


                $datA[] = array(
                    'valido' => true,
                    'notasCredito' => $notasCredito,
                    'tabonos' => $tabonos,
                    'tcargos' => $tcargos
                );
                echo json_encode($datA);
            }
        }
        #   SET APLICACION NOTA DE CREDITO
        public function setANCredito()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('arap_model');
                date_default_timezone_set('America/El_Salvador');
                $iddocactual = (int)$this->input->post('iddocactual');
                $idncredito = (int)$this->input->post('idncredito');
                $docactual = $this->arap_model->getDataCxC(3, $iddocactual);
                $ncredito = $this->arap_model->getDataCxC(3, $idncredito);
                $idtipoabono = (int)$this->input->post('tipoabono');
                $idtipocargo = (int)$this->input->post('tipocargo');
                $tipoabono = $this->arap_model->getDataCxC(4, $idtipoabono);
                $tipocargo = $this->arap_model->getDataCxC(4, $idtipocargo);
                $valor = (float)$this->input->post('valor');

                #   ABONO
                $dataA = array(
                    'trannum' => (int)$iddocactual,
                    'idclase' => (int)$docactual->idclase,
                    'fecha' => $this->input->post('fecha'),
                    'itemline' => (int)$docactual->lines100c + 1,
                    'cajclase' => (int)$idtipoabono,
                    'idworker' => (int)$docactual->idworker,
                    'descrip' => $tipoabono->descrip,
                    'valor' => $valor * $tipoabono->alcuadre,
                    'referencia' => $ncredito->serie.$ncredito->numero,
                    'notas' => trim($this->input->post('notas')),
                    'whodidit' => (int)$this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                );
                #   CARGO
                $dataC = array(
                    'trannum' => (int)$idncredito,
                    'idclase' => (int)$ncredito->idclase,
                    'fecha' => $this->input->post('fecha'),
                    'itemline' => (int)$ncredito->lines100c + 1,
                    'cajclase' => (int)$idtipocargo,
                    'idworker' => (int)$ncredito->idworker,
                    'descrip' => $tipocargo->descrip,
                    'valor' => $valor * $tipocargo->alcuadre,
                    'referencia' => $docactual->serie.$docactual->numero,
                    'notas' => trim($this->input->post('notas')),
                    'whodidit' => (int)$this->session->userdata('iduser'),
                    'ingresa' => date_create()->format('Y-m-d H:i:s'),
                );
                #   INSERTAR LOS TRAN100C
                #   EJECUTAR TOTALIZA100
                #   ACTUALIZAR LOS TRAN100 - ITEMLINES
                #   ACTUALIZAR LOS TRAN100 - CCESTATUS EN BASE AL NUEVO SALDO
                $this->arap_model->multiplesOpcionesCxC(0, [
                    'data' => $dataA,
                    'documento' => $docactual
                ]);
                $this->arap_model->multiplesOpcionesCxC(0, [
                    'data' => $dataC,
                    'documento' => $ncredito
                ]);//*/

                #   ------------COPIADO Y PEGADO DE DE  fun -> insert_cxc
                $trannum = $iddocactual;
                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detailsCuenta_ar($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar($trannum);  
                
                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                $idauxi=0;
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                    $idauxi = $dat->codigo;
                }
                $fact_pendientes = array();
                $pend_i =0;
                $fact_canceladas = array();
                $cance_i =0;
                
                $info= $this->arap_model->getInfoCliente($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $limite = $in->limite;
                    
                    if($in->ccestatus==0){
                        $fact_pendientes[$pend_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $pend_i++;
                    }else if($in->ccestatus==1 || $in->ccestatus==2){
                         $fact_canceladas[$cance_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $cance_i++;
                    }
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = $det->cargos;
                    $saldo_final = $det->cargos;
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += $tran->valor; 
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final-=abs($tran->valor);
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final+=abs($tran->valor);
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => $tran->valor,
                        "saldo" => $saldo,
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "abonos" => abs($abono_fact),   
                        "cargos" => abs($cargo_fact),     
                    );
                    $i++;
                }

                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => $saldo_inicial,
                    'cargos' => $cargos,
                    'abonos' => $abonos,
                    'saldo_final' => $saldo_final,
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc,
                    'saldo' => $sum,
                    'disponible' => $disponible,
                    'array_ant' => $array_ant,
                    'fact_pendientes' => $fact_pendientes,
                    'fact_canceladas' => $fact_canceladas,
                    
                );
                echo json_encode($array);
            }
        }
        #   MULTIOPCIONES CXC
        public function multiOpcionesCxC()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('arap_model');
                $opcion = (int)$this->input->post('opcion');
                switch ($opcion) {
                    case 1:#    BUSCAR TRANSACCION POR TRANNUM VN
                        $find = false;
                        $id = 0;
                        $norden = (int)$this->input->post('norden');
                        $vfind = $this->arap_model->multiplesOpcionesCxC(1, $norden);
                        if (count((array)$vfind) > 0) {
                            $find = true;
                            $id = $vfind->idcps;
                        }
                        $datA[] = array('valido' => $find, 'idauxi' => $id);
                    break;
                    default:$datA[] = array('valido' => false);break;
                }
                echo json_encode($datA);
            }
        }
        
        function getDetalleCC(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post("trannum"); 
                $this->load->model('arap_model');
                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detailsCuenta_ar($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar($trannum);
                
                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $doc_fecha=$dat->fecha;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                }
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = number_format(number_format($det->cargos, 3, '.', ''), 2, '.', '');
                    $saldo_final = number_format(number_format($det->cargos, 3, '.', ''), 2, '.', '');
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += number_format(number_format($tran->valor, 3, '.', ''), 2, '.', ''); 
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final -= number_format(number_format(abs($tran->valor), 3, '.', ''), 2, '.', '');
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final += number_format(number_format(abs($tran->valor), 3, '.', ''), 2, '.', '');
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => number_format(number_format($tran->valor, 3, '.', ''), 2, '.', ''),
                        "saldo" => number_format(number_format($saldo, 3, '.', ''), 2, '.', ''),
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "ingresa" => $tran->ingresa,  
                        "modifica" => $tran->modifica,  
                        "user_tran" => $tran->user_tran,  
                        "abonos" => number_format(abs($abono_fact), 2, '.', ''),   
                        "cargos" => number_format(abs($cargo_fact), 2, '.', ''),     
                    );
                    $i++;
                }
                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'doc_fecha' => $doc_fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => number_format($saldo_inicial, 2, '.', ''),
                    'cargos' => number_format($cargos, 2, '.', ''),
                    'abonos' => number_format($abonos, 2, '.', ''),
                    'saldo_final' => number_format($saldo_final, 2, '.', ''),
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc
                    
                );
                echo json_encode($array);
            }
        }
        
        function insert_cxc(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $fecha = $this->input->post('fecha');
                $cajclase = $this->input->post('formapago');
                $idworker = $this->input->post('vendedor');
                $descrip = $this->input->post('descrip');
                $valor = $this->input->post('valor');
                $referencia = $this->input->post('referencia');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('arap_model');
                $itemline = $this->arap_model->insertCuenta_ar($trannum, $fecha, $cajclase, $idworker, $descrip, $valor, $referencia, $whodidit);
                $actualiza = $this->arap_model->actualizaItemLine_ar($trannum, $itemline,$whodidit);
                $update_ccstatus = $this->arap_model->updateccestatus_ar($trannum);

                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detailsCuenta_ar($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar($trannum);  
                
                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                $idauxi=0;
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                    $idauxi = $dat->codigo;
                }
                $fact_pendientes = array();
                $pend_i =0;
                $fact_canceladas = array();
                $cance_i =0;
                
                $info= $this->arap_model->getInfoCliente($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $limite = $in->limite;
                    
                    if($in->ccestatus==0){
                        $fact_pendientes[$pend_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $pend_i++;
                    }else if($in->ccestatus==1 || $in->ccestatus==2){
                         $fact_canceladas[$cance_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $cance_i++;
                    }
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = $det->cargos;
                    $saldo_final = $det->cargos;
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += $tran->valor; 
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final-=abs($tran->valor);
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final+=abs($tran->valor);
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => $tran->valor,
                        "saldo" => $saldo,
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "abonos" => abs($abono_fact),   
                        "cargos" => abs($cargo_fact),     
                    );
                    $i++;
                }

                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => number_format($saldo_inicial, 2, '.', ''),
                    'cargos' => number_format($cargos, 2, '.', ''),
                    'abonos' => number_format($abonos, 2, '.', ''),
                    'saldo_final' => number_format($saldo_final, 2, '.', ''),
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc,
                    'saldo' => number_format($sum, 2, '.', ''),
                    'disponible' => $disponible,
                    'array_ant' => $array_ant,
                    'fact_pendientes' => $fact_pendientes,
                    'fact_canceladas' => $fact_canceladas,
                    
                );
                echo json_encode($array);
            }
        }
        
        function addMultiplesAbonos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $fecha = $this->input->post('fecha');
                $cajclase = $this->input->post('formapago');
                $idworker = $this->input->post('vendedor');
                $descrip = $this->input->post('descrip');
                $referencia = $this->input->post('referencia');
                $datasource = $this->input->post('datasource');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('arap_model');
                $this->arap_model->insertAbonoMultiple($trannum, $fecha, $cajclase, $idworker, $descrip, $datasource, $referencia, $whodidit);

                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detailsCuenta_ar($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar($trannum);  
                
                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                $idauxi=0;
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                    $idauxi = $dat->codigo;
                }
                $fact_pendientes = array();
                $pend_i =0;
                $fact_canceladas = array();
                $cance_i =0;
                
                $info= $this->arap_model->getInfoCliente($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $limite = $in->limite;
                    
                    if($in->ccestatus==0){
                        $fact_pendientes[$pend_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $pend_i++;
                    }else if($in->ccestatus==1 || $in->ccestatus==2){
                         $fact_canceladas[$cance_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $cance_i++;
                    }
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = $det->cargos;
                    $saldo_final = $det->cargos;
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += $tran->valor; 
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final-=abs($tran->valor);
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final+=abs($tran->valor);
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => $tran->valor,
                        "saldo" => $saldo,
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "abonos" => abs($abono_fact),   
                        "cargos" => abs($cargo_fact),     
                    );
                    $i++;
                }

                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => $saldo_inicial,
                    'cargos' => $cargos,
                    'abonos' => $abonos,
                    'saldo_final' => $saldo_final,
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc,
                    'saldo' => $sum,
                    'disponible' => $disponible,
                    'array_ant' => $array_ant,
                    'fact_pendientes' => $fact_pendientes,
                    'fact_canceladas' => $fact_canceladas,
                    
                );
                echo json_encode($array);
            }
        }
        
        function insert_cxc_cruce(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $trannum_cruce = $this->input->post('trannum_cruce');
                $fecha = $this->input->post('fecha');
                $cajclase = $this->input->post('formapago');
                $idworker = $this->input->post('vendedor');
                $descrip = $this->input->post('descrip');
                $valor = $this->input->post('valor');
                $referencia = $this->input->post('referencia');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('arap_model');
                $this->load->model('global_model');
                
                
                $cajclase_abono = $this->global_model->getValorNumVariable("cc_abono");
                $cajclase_cargo = $this->global_model->getValorNumVariable("cc_cargo");
                
                $itemline = $this->arap_model->insertCuenta_ar($trannum, $fecha, $cajclase_abono, $idworker, $descrip, $valor, $referencia, $whodidit);
                $actualiza = $this->arap_model->actualizaItemLine_ar($trannum, $itemline,$whodidit);
                $itemline2 = $this->arap_model->insertCuenta_ar($trannum_cruce, $fecha, $cajclase_cargo, $idworker, $descrip, $valor, $referencia, $whodidit);
                $actualiza2 = $this->arap_model->actualizaItemLine_ar($trannum, $itemline2,$whodidit);
                $update_ccstatus = $this->arap_model->updateccestatus_ar($trannum);
                $update_ccstatus = $this->arap_model->updateccestatus_ar($trannum_cruce);

                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detailsCuenta_ar($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar($trannum);  
                
                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                $idauxi=0;
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                    $idauxi = $dat->codigo;
                }
                $fact_pendientes = array();
                $pend_i =0;
                $fact_canceladas = array();
                $cance_i =0;
                
                $info= $this->arap_model->getInfoCliente($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $limite = $in->limite;
                    
                    if($in->ccestatus==0){
                        $fact_pendientes[$pend_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $pend_i++;
                    }else if($in->ccestatus==1 || $in->ccestatus==2){
                         $fact_canceladas[$cance_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $cance_i++;
                    }
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = $det->cargos;
                    $saldo_final = $det->cargos;
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += $tran->valor; 
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final-=abs($tran->valor);
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final+=abs($tran->valor);
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => $tran->valor,
                        "saldo" => $saldo,
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "abonos" => abs($abono_fact),   
                        "cargos" => abs($cargo_fact),     
                    );
                    $i++;
                }

                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => $saldo_inicial,
                    'cargos' => $cargos,
                    'abonos' => $abonos,
                    'saldo_final' => $saldo_final,
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc,
                    'saldo' => $sum,
                    'disponible' => $disponible,
                    'array_ant' => $array_ant,
                    'fact_pendientes' => $fact_pendientes,
                    'fact_canceladas' => $fact_canceladas,
                    
                );
                echo json_encode($array);
            }
        }
        
        function getlastdescrip(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idauxi = $this->input->post('idauxi');
                $cajclase = $this->input->post('cajclase');
                $this->load->model('arap_model');
                $datos = $this->arap_model->getlastdescrip($idauxi,$cajclase);
                echo json_encode($datos);
             }
        }
        
        function get_cxc_pendientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $calcula = $this->input->post('calcula');
                $valor = $this->input->post('valor');
                $this->load->model('arap_model');
                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $idauxi=0;
                foreach($datos as $dat){
                    $idauxi = $dat->codigo;
                }
                $fact_pendientes = array();
                $pend_i =0;
                
                $info= $this->arap_model->getInfoCliente($idauxi);
               
                $sobrante = $valor;
                foreach($info as $in){
                    $abono = 0;
                    if($calcula == "true" && $in->ccestatus == 0 ){
                        if($sobrante>=$in->val_fact){
                            $abono =  round($in->val_fact, 2);
                            $sobrante -= round($in->val_fact, 2);
                        }else{
                            $abono = $sobrante;
                            $sobrante = 0;
                        }
                    }
                    
                    if($in->ccestatus==0){
                        $fact_pendientes[$pend_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "fechadoc" => $in->fecha,
                            "fecvence" => $in->fecvence,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "abono" =>$abono
                        );
                        $pend_i++;
                    }
                }
                echo json_encode($fact_pendientes);
            }
        }
        
        
        function update_cxc(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('trannum');
                $cajclase = $this->input->post('formapago');
                $descrip = $this->input->post('descrip');
                $referencia = $this->input->post('referencia');
                $this->load->model('arap_model');

                $save = $this->arap_model->update_cc_cp($idrec, $trannum, $cajclase, $descrip, $referencia);
                $update_ccstatus = $this->arap_model->updateccestatus_ar($trannum);

                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detailsCuenta_ar($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar($trannum);  
                
                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                $idauxi=0;
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                    $idauxi = $dat->codigo;
                }
                $fact_pendientes = array();
                $pend_i =0;
                $fact_canceladas = array();
                $cance_i =0;
                
                $info= $this->arap_model->getInfoCliente($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $limite = $in->limite;
                    
                    if($in->ccestatus==0){
                        $fact_pendientes[$pend_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $pend_i++;
                    }else if($in->ccestatus==1 || $in->ccestatus==2){
                         $fact_canceladas[$cance_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $cance_i++;
                    }
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = $det->cargos;
                    $saldo_final = $det->cargos;
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += $tran->valor; 
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final-=abs($tran->valor);
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final+=abs($tran->valor);
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => $tran->valor,
                        "saldo" => $saldo,
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "abonos" => abs($abono_fact),   
                        "cargos" => abs($cargo_fact),     
                    );
                    $i++;
                }

                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => $saldo_inicial,
                    'cargos' => $cargos,
                    'abonos' => $abonos,
                    'saldo_final' => $saldo_final,
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc,
                    'saldo' => $sum,
                    'disponible' => $disponible,
                    'array_ant' => $array_ant,
                    'fact_pendientes' => $fact_pendientes,
                    'fact_canceladas' => $fact_canceladas,
                    
                );
                echo json_encode($array);
            }
        }
        
        function deleteAbono_cxc(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('trannum');
                
                $this->load->model('arap_model');

                $delete = $this->arap_model->deleteAbonoTran100c($idrec,$trannum);
                $update_ccstatus = $this->arap_model->updateccestatus_ar($trannum);

                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detailsCuenta_ar($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar($trannum);  
                
                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                $idauxi=0;
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                    $idauxi = $dat->codigo;
                }
                $fact_pendientes = array();
                $pend_i =0;
                $fact_canceladas = array();
                $cance_i =0;
                
                $info= $this->arap_model->getInfoCliente($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $limite = $in->limite;
                    
                    if($in->ccestatus==0){
                        $fact_pendientes[$pend_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $pend_i++;
                    }else if($in->ccestatus==1 || $in->ccestatus==2){
                         $fact_canceladas[$cance_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact,
                            "key" =>$in->Sucursal,
                            'isnotacredito' => (int)$in->isnotacredito
                        );
                        $cance_i++;
                    }
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = $det->cargos;
                    $saldo_final = $det->cargos;
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += $tran->valor; 
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final-=abs($tran->valor);
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final+=abs($tran->valor);
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => $tran->valor,
                        "saldo" => $saldo,
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "abonos" => abs($abono_fact),   
                        "cargos" => abs($cargo_fact),     
                    );
                    $i++;
                }

                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => $saldo_inicial,
                    'cargos' => $cargos,
                    'abonos' => $abonos,
                    'saldo_final' => $saldo_final,
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc,
                    'saldo' => $sum,
                    'disponible' => $disponible,
                    'array_ant' => $array_ant,
                    'fact_pendientes' => $fact_pendientes,
                    'fact_canceladas' => $fact_canceladas,
                    
                );
                echo json_encode($array);
            }
        }
        
        function mantenimiento_cxp($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('arap_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['provee_data'] = $this->arap_model->getListProveedores();

                $this->load->view('mantenimiento_cxp', $this->data);
            }
        }
        
        function balance_cartera_cxc($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('arap_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->load->view('mantenimiento_balance_cartera_cxc', $this->data);
            }
        }
        
        function mantenimiento_detalle_cxp($idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                 $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName')
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');   
                $this->load->model('empleado_model');
                $this->load->model('arap_model');
                $this->load->model('variable_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['idauxi'] = $idauxi;
                $info= $this->arap_model->getInfoProveedor($idauxi);
                $this->data['pass_delete'] = $this->global_model->getValorNumVariable("cc_clave");
                $permite_eliminar = $this->variable_model->getTextVar("cc_clave");
                if($permite_eliminar!=false){
                    $permite_eliminar = 1;
                }else{
                    $permite_eliminar = 0;
                }
                $this->data['permite_eliminar'] = $permite_eliminar;
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $descrip ="";
                $grupo ="";
                $vendedor ="";
                $idvendedor ="";
                $dias ="";
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $idauxi = $in->idauxi;
                    $descrip = $in->descrip;
                    $grupo = $in->grupo;
                    $vendedor = $in->vendedor;
                    $idvendedor = $in->idvendedor;
                    $dias = $in->dias;
                    $limite = $in->limite;
                }
                
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                $this->data['descrip'] = $descrip;
				$this->data['grupo'] = $grupo;
				$this->data['vendedor'] = $vendedor;
				$this->data['idvendedor'] = $idvendedor;
				$this->data['sum_1_30'] = $sum_1_30;
				$this->data['sum_31_60'] = $sum_31_60;
				$this->data['sum_61_90'] = $sum_61_90;
				$this->data['sum_91_99'] = $sum_91_99;
				$this->data['saldo'] = $sum;
				$this->data['dias'] = $dias;
				$this->data['limite'] = $limite;
				$this->data['facturas'] = $info;
				$this->data['disponible'] = $disponible;
                $this->data['formasCargo'] = $this->arap_model->formasPago_ap("1");
                $this->data['formasAbono'] = $this->arap_model->formasPago_ap("-1");
                $this->data['vendedores'] = $this->empleado_model->viewEmpleActivo();
                $this->data['vendedores_update'] = $this->empleado_model->viewEmple();
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                
                $this->data['array_ant'] = $array_ant;
                $this->load->view('mantenimiento_detalle_cxp', $this->data); 
            }
        }
        
        function getDetalleCP(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post("trannum"); 
                $this->load->model('arap_model');
                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detalle_cuenta_ar($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar2($trannum);

                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                }
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = $det->cargos;
                    $saldo_final = $det->cargos;
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += $tran->valor; 
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final-=abs($tran->valor);
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final+=abs($tran->valor);
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => $tran->valor,
                        "saldo" => $saldo,
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "abonos" => abs($abono_fact),   
                        "cargos" => abs($cargo_fact),     
                    );
                    $i++;
                }
                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => round($saldo_inicial,2),
                    'cargos' => round($cargos,2),
                    'abonos' => round($abonos,2),
                    'saldo_final' => round($saldo_final,2),
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc
                    
                );
                echo json_encode($array);
            }
        }
         
        function insert_cxp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $fecha = $this->input->post('fecha');
                $cajclase = $this->input->post('formapago');
                $idworker = $this->input->post('vendedor');
                $descrip = $this->input->post('descrip');
                $valor = $this->input->post('valor');
                $referencia = $this->input->post('referencia');
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('arap_model');
                $itemline = $this->arap_model->insertCuenta_ar($trannum, $fecha, $cajclase, $idworker, $descrip, $valor, $referencia, $whodidit);
                $actualiza = $this->arap_model->actualizaItemLine_ar($trannum, $itemline,$whodidit);
                $update_ccstatus = $this->arap_model->updateccestatus_ap($trannum);

                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detailsCuenta_ar2($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar2($trannum);  
                
                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                $idauxi=0;
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                    $idauxi = $dat->codigo;
                }
                $fact_pendientes = array();
                $pend_i =0;
                $fact_canceladas = array();
                $cance_i =0;
                
                $info= $this->arap_model->getInfoProveedor($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $limite = $in->limite;
                    
                    if($in->ccestatus==0){
                        $fact_pendientes[$pend_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact
                        );
                        $pend_i++;
                    }else if($in->ccestatus==1 || $in->ccestatus==2){
                         $fact_canceladas[$cance_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact
                        );
                        $cance_i++;
                    }
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = $det->cargos;
                    $saldo_final = $det->cargos;
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += $tran->valor; 
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final-=abs($tran->valor);
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final+=abs($tran->valor);
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => $tran->valor,
                        "saldo" => $saldo,
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "abonos" => abs($abono_fact),   
                        "cargos" => abs($cargo_fact),     
                    );
                    $i++;
                }

                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => $saldo_inicial,
                    'cargos' => $cargos,
                    'abonos' => $abonos,
                    'saldo_final' => $saldo_final,
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc,
                    'saldo' => $sum,
                    'disponible' => $disponible,
                    'array_ant' => $array_ant,
                    'fact_pendientes' => $fact_pendientes,
                    'fact_canceladas' => $fact_canceladas,
                    
                );
                echo json_encode($array);
            }
        }
        
        function update_cxp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('trannum');
                $cajclase = $this->input->post('formapago');
                $descrip = $this->input->post('descrip');
                $referencia = $this->input->post('referencia');
                $this->load->model('arap_model');

                $save = $this->arap_model->update_cc_cp($idrec, $trannum, $cajclase, $descrip, $referencia);
                $update_ccstatus = $this->arap_model->updateccestatus_ap($trannum);

                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detailsCuenta_ar2($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar2($trannum);  
                
                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                $idauxi=0;
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                    $idauxi = $dat->codigo;
                }
                $fact_pendientes = array();
                $pend_i =0;
                $fact_canceladas = array();
                $cance_i =0;
                
                $info= $this->arap_model->getInfoProveedor($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $limite = $in->limite;
                    
                    if($in->ccestatus==0){
                        $fact_pendientes[$pend_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact
                        );
                        $pend_i++;
                    }else if($in->ccestatus==1 || $in->ccestatus==2){
                         $fact_canceladas[$cance_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact
                        );
                        $cance_i++;
                    }
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = $det->cargos;
                    $saldo_final = $det->cargos;
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += $tran->valor; 
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final-=abs($tran->valor);
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final+=abs($tran->valor);
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => $tran->valor,
                        "saldo" => $saldo,
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "abonos" => abs($abono_fact),   
                        "cargos" => abs($cargo_fact),     
                    );
                    $i++;
                }

                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => $saldo_inicial,
                    'cargos' => $cargos,
                    'abonos' => $abonos,
                    'saldo_final' => $saldo_final,
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc,
                    'saldo' => $sum,
                    'disponible' => $disponible,
                    'array_ant' => $array_ant,
                    'fact_pendientes' => $fact_pendientes,
                    'fact_canceladas' => $fact_canceladas,
                    
                );
                echo json_encode($array);
            }
        }

        function deleteAbono_cxp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $trannum = $this->input->post('trannum');
                
                $this->load->model('arap_model');

                $delete = $this->arap_model->deleteAbonoTran100c($idrec,$trannum);
                $update_ccstatus = $this->arap_model->updateccestatus_ap($trannum);

                $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                $factura_principal = $this->arap_model->detailsCuenta_ar2($trannum);
                $transacciones = $this->arap_model->detailsTrans_ar2($trannum);
                
                $num_factura = 0;
                $fecha = 0;
                $fecha_vencimiento = 0;
                $saldo_inicial = 0;
                $cargos = 0;
                $abonos = 0;
                $saldo_final = 0;
                $tipodoc = "";
                $dias_doc = "";
                $idauxi=0;
                foreach($datos as $dat){
                    $num_factura=$dat->s_n;
                    $fecha=$dat->fechaEmision;
                    $fecha_vencimiento=$dat->fechaVencimiento;
                    $tipodoc = $dat->tipoDoc;
                    $dias_doc = $dat->dias;
                    $idauxi = $dat->codigo;
                }
                $fact_pendientes = array();
                $pend_i =0;
                $fact_canceladas = array();
                $cance_i =0;
                
                $info= $this->arap_model->getInfoProveedor($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $limite = $in->limite;
                    
                    if($in->ccestatus==0){
                        $fact_pendientes[$pend_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact
                        );
                        $pend_i++;
                    }else if($in->ccestatus==1 || $in->ccestatus==2){
                         $fact_canceladas[$cance_i] = array(
                            "trannum" => $in->trannum,
                            "fecha" => $in->fechaFormat,
                            "numero" => $in->serie.$in->numero,
                            "ccestatus" => $in->ccestatus,
                            "valor" => $in->val_fact
                        );
                        $cance_i++;
                    }
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                $array_ant = array();
                $array_ant[0] = array(
                    "descrip" => "01-30",
                    "cant" => $sum_1_30
                );
                $array_ant[1] = array(
                    "descrip" => "31-60",
                    "cant" => $sum_31_60
                );
                $array_ant[2] = array(
                    "descrip" => "61-90",
                    "cant" => $sum_61_90
                );
                $array_ant[3] = array(
                    "descrip" => "91-Más",
                    "cant" => $sum_91_99
                );
                
                $array_transacciones = array();
                $i = 0;
                $saldo=0;
                
                foreach($factura_principal as $det){
                    $saldo = $det->cargos;
                    $saldo_final = $det->cargos;
                    $saldo_inicial= $det->cargos;
                }
                
                foreach($transacciones as $tran){
                    $saldo += $tran->valor;
                    $cargo_fact = 0;
                    $abono_fact = 0;
                    if($tran->valor<0){
                        $abonos += abs($tran->valor);
                        $abono_fact = $tran->valor;
                        $saldo_final-=abs($tran->valor);
                    }else{
                        $cargos += $tran->valor;
                        $cargo_fact = $tran->valor;
                        $saldo_final+=abs($tran->valor);
                    }
                    $array_transacciones[$i] = array(
                        "linea" => $tran->itemline,
                        "fecha"=> $tran->fecha,
                        "referencia" => $tran->referencia,
                        "formaPago" => $tran->formaPago,
                        "descripcion" => trim($tran->descrip),
                        "valor" => $tran->valor,
                        "saldo" => $saldo,
                        "trannum" => $det->trannum,   
                        "idrec" => $tran->idrec,   
                        "idvendedor" => $tran->idworker,   
                        "cajclase" => $tran->cajclase,  
                        "abonos" => abs($abono_fact),   
                        "cargos" => abs($cargo_fact),     
                    );
                    $i++;
                }

                $array = array(
                    'transacciones' => $array_transacciones,
                    'num_factura' => $num_factura,
                    'fecha' => $fecha,
                    'fecha_vencimiento' => $fecha_vencimiento,
                    'saldo_inicial' => $saldo_inicial,
                    'cargos' => $cargos,
                    'abonos' => $abonos,
                    'saldo_final' => $saldo_final,
                    'trannum' => $trannum,
                    'tipo_doc' => $tipodoc,
                    'dias' => $dias_doc,
                    'saldo' => $sum,
                    'disponible' => $disponible,
                    'array_ant' => $array_ant,
                    'fact_pendientes' => $fact_pendientes,
                    'fact_canceladas' => $fact_canceladas,  
                );
                echo json_encode($array);
            }
        }
        
        function get_details_factura(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                
                $trannum = $this->input->post('trannum');
                $this->load->model('invtran_model');        
                $detalles = $this->invtran_model->getDataTran100k2($trannum);
                echo json_encode($detalles);
                
            }
        }
        
        function pagoProveedores($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('arap_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['provee_data'] = $this->arap_model->getListProveedores();   
                $this->data['cuentas_bancarias'] =$this->arap_model->getCuentasBancarias();
                $this->load->view('mantenimiento_pago_proveedores', $this->data);
            }
        }
        
        function getCuentasBancarias(){
            $this->load->model('arap_model');
            $datos = $this->arap_model->getCuentasBancarias();
            echo json_encode($datos);
        }
        
        
        function get_Bancos(){
            $this->load->model('arap_model');
            $datos = $this->arap_model->getBancosAgrupados();
            echo json_encode($datos);
        }
        
        function get_Bancos_Cheques(){
            $this->load->model('arap_model');
            $datos = $this->arap_model->get_Bancos_Cheques();
            $array = array();
            $i=0;
            foreach ($datos as $dat){
                if($dat->cantidad>0){
                    $array[$i] = array(
                        "cajclase" => $dat->cajclase,
                        "forma_pago" => $dat->forma_pago,
                        "idauxi" => $dat->idauxi,
                        "descrip" => $dat->descrip,
                    );
                    $i++;
                }
            }
            echo json_encode($array);
        }
        
        function getChequesporBanco(){
            $idcps = $this->input->post("idcps");
            $this->load->model('arap_model');
            $datos = $this->arap_model->getChequesporBanco($idcps);
            echo json_encode($datos);
        }

        function getProveedores(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                //$proveedores = $this->arap_model->getProveedores(1);
                $proveedores = $this->arap_model->getListProveedoresNew();
                echo json_encode($proveedores);
            }
        }
        
        function save_PagoProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');   
                
                $fecha = $this->input->post('fecha');
                $cuenta = $this->input->post('cuenta');
                $formaPago = $this->input->post('formaPago');
                $inicial = $this->input->post('inicial');
                //$limite = $this->input->post('limite');
                $notas = $this->input->post('notas');
                $estatus = $this->input->post('estatus');
                
                //$detalles = $this->arap_model->insert_Pago($fecha, $cuenta, $inicial, $limite, $notas);
                $detalles = $this->arap_model->insert_Pago($fecha, $cuenta, $formaPago, $inicial, $notas, $estatus);
                $lista_pagos = $this->arap_model->getListaPagos();
                echo json_encode($lista_pagos);
                
            }
        }

        //--------------------------------------------
        function getDocsPagoProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcps = $this->input->post("idcps");
                $trannum = $this->input->post("trannum");
                $this->load->model('arap_model');

                $datos = $this->arap_model->getDocsProveedor($idcps);

                //$array = array(
                    //'num_factura' => $num_factura,
                    //'fecha' => $fecha,
                    //'doc_fecha' => $doc_fecha,
                    //'fecha_vencimiento' => $fecha_vencimiento,
                    //'saldo_inicial' => number_format($saldo_inicial, 2, '.', ''),
                    //'cargos' => number_format($cargos, 2, '.', ''),
                    //'abonos' => number_format($abonos, 2, '.', ''),
                    //'saldo_final' => number_format($saldo_final, 2, '.', ''),
                    //'trannum' => $trannum,
                    //'tipo_doc' => $tipodoc,
                    //'dias' => $dias_doc
                //);

                echo json_encode($datos);
            }
        }

        function getDocsInPaymentProcess(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('arap_model');

                $datos = $this->arap_model->getDocsInPaymentProcess($trannum);
                echo json_encode($datos);
            }
        }

        function getSpecificDoc(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post("docTrannum");
                $this->load->model('arap_model');

                $datos = $this->arap_model->getSpecificDoc($trannum);

                echo json_encode($datos);
            }
        }

        function setDocumentInPaymentProcess(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $docTrannum = $this->input->post('docNum');
                $orderTrannum = $this->input->post('pagoNum');
                $descrip = $this->input->post('descrip');
                $precioN = $this->input->post('precioN');
                $notas = $this->input->post('notas');
                $this->load->model('arap_model');

                $response = $this->arap_model->setDocumentInPaymentProcess($docTrannum, $orderTrannum, $descrip, $precioN, $notas);
                echo json_encode($response);
            }
        }

        function deleteDocInPaymentProcess(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $this->load->model('arap_model');

                $response = $this->arap_model->deleteDocInPaymentProcess($idrec);
                echo json_encode($response);
            }
        }

        function changeOrderStatus(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $status = $this->input->post('status');
                $this->load->model('arap_model');

                $datos = $this->arap_model->changeOrderStatus($trannum, $status);

                echo json_encode($datos);
            }
        }

        function pagoProveedoresBAC() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
			}else{

                $asignNumber = $this->input->post('numAsignado');
                $baNumber = $this->input->post('numBatch');
                $enterpraise = $this->input->post('empresa');
                $information = json_decode($this->input->post('gridInfo'), true);
                $numCuenta = $this->input->post('numCuenta');

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $date = date_format($date, 'Y-m-d');
                $date = explode('-', $date);
                //var_dump($asignNumber);
                //var_dump($information);
                
                // require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                $objPHPExcel = new Spreadsheet();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Pago a Proveedores BAC") // Titulo
                ->setSubject("Pago a Proveedores BAC") //Asunto
                ->setDescription("Pago a Proveedores BAC") //Descripción
                ->setKeywords("Pago a Proveedores BAC") //Etiquetas
                ->setCategory("Pago a Proveedores BAC"); //Categorias

                $objPHPExcel->setActiveSheetIndex(0);

                //$default_border = array(
                    //'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    //'color' => array('argb' => "000")
                //);

				$correlativeNum_style = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                    ),
                    //'borders' => [
						//'allBorders' => [
							//'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							//'color' => ['argb' => '000000'],
						//],
					//],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'FFFF00',
						],
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );
				
				$style_texts_total = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
						'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                    ),
                    //'borders' => [
						//'allBorders' => [
							//'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							//'color' => ['argb' => '000000'],
						//],
					//],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'FCD5B4',
						],
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );

				$style_texts_rows = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );

                $style_texts_proveedor = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                    ),
                    // 'borders' => [
					// 	'allBorders' => [
					// 		'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
					// 		'color' => ['argb' => '000000'],
					// 	],
					// ],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'C4D79B',
						],
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );

                $style_num_order = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                    ),
                    // 'borders' => [
					// 	'allBorders' => [
					// 		'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
					// 		'color' => ['argb' => '000000'],
					// 	],
					// ],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'CCC0DA',
						],
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );

                $style_num_banco = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                    ),
                    // 'borders' => [
					// 	'allBorders' => [
					// 		'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
					// 		'color' => ['argb' => '000000'],
					// 	],
					// ],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => '92CDDC',
						],
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );

                //$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(2);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(5);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(6);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(21);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(5);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(5);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(3);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(3);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(14);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(5);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(31);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(2);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(61);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(21);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(2);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(10);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(11);

				//$objPHPExcel->getActiveSheet()->mergeCells('A1:I1');

                $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'B');
                $objPHPExcel->getActiveSheet()->SetCellValue('B1', $asignNumber);
                $objPHPExcel->getActiveSheet()->SetCellValue('C1', $baNumber);
                $objPHPExcel->getActiveSheet()->SetCellValue('F1', $date[0]);
                $objPHPExcel->getActiveSheet()->SetCellValue('G1', $date[1]);
                $objPHPExcel->getActiveSheet()->SetCellValue('H1', $date[2]);
                
                //$objPHPExcel->getActiveSheet()->getStyle("J1")->applyFromArray( $correlativeNum_style );
                //$objPHPExcel->getActiveSheet()->getStyle("A1:H1")->getFont()->setBold(true);
                //$objPHPExcel->getActiveSheet()->getStyle("A1:I1")->applyFromArray( $style_texts );
                //$objPHPExcel->getActiveSheet()->getStyle("A2:I2")->applyFromArray( $style_texts );
                //$objPHPExcel->getActiveSheet()->getStyle("A3:I3")->applyFromArray( $style_texts_border );

                //$objPHPExcel->getActiveSheet()->getStyle("A7:I7")->applyFromArray( $style_header );

                //$archivoTxt = fopen("PagoProveedoresBAC.csv",'w+');

                $totalDocs = 0; $totalPayment = 0; $numRow = 2;

                foreach($information as $info){
                    
                        $totalPayment  += $info['totalDocs'];
                        $totalDocs++;

                        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$numRow, 'T');
                        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$numRow, $asignNumber);
                        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$numRow, $baNumber);
                        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$numRow, str_replace('-', '',$info['provNit']));
                        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$numRow, $totalDocs);
                        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$numRow, $date[0]);
                        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$numRow, $date[1]);
                        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$numRow, $date[2]);
                        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$numRow, str_replace('.', '', number_format($info['totalDocs'], 2, '', '.')));
                        $objPHPExcel->getActiveSheet()->SetCellValue('K'.$numRow, substr(strtoupper($enterpraise), 0, 30));
                        $objPHPExcel->getActiveSheet()->SetCellValue('M'.$numRow, substr(strtoupper($info['provDescrip']), 0, 60));
                        $objPHPExcel->getActiveSheet()->SetCellValue('N'.$numRow, substr($info['orderNum'], 0, 20));
                        $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$numRow, substr($numCuenta, 0, 9));
                        
                        //$objPHPExcel->getActiveSheet()->getStyle("A".$numRow.":D".$numRow)->applyFromArray( $style_texts_rows );
                        //$objPHPExcel->getActiveSheet()->getStyle("F".$numRow.":G".$numRow)->applyFromArray( $style_texts_rows );
                        //$objPHPExcel->getActiveSheet()->getStyle("K".$numRow)->applyFromArray( $style_texts_rows );
                        //$objPHPExcel->getActiveSheet()->getStyle("E".$numRow)->applyFromArray( $correlativeNum_style );
                        //$objPHPExcel->getActiveSheet()->getStyle("I".$numRow)->applyFromArray( $style_texts_total );
                        //$objPHPExcel->getActiveSheet()->getStyle("M".$numRow)->applyFromArray( $style_texts_proveedor );
                        //$objPHPExcel->getActiveSheet()->getStyle("N".$numRow)->applyFromArray( $style_num_order );
                        //$objPHPExcel->getActiveSheet()->getStyle("Q".$numRow)->applyFromArray( $style_num_banco );
                        
                        $numRow++;
                }

                $objPHPExcel->getActiveSheet()->SetCellValue('I1', str_replace('.', '', number_format($totalPayment, 2, '', '.')));
                $objPHPExcel->getActiveSheet()->SetCellValue('J1', $totalDocs);
				
				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="Pago_a_Proveedores_BAC.csv"');
                header('Cache-Control: max-age=0');
                $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Csv');
                $objWriter->save('php://output');
            }
        }

        function pagoProveedoresPromerica() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
			}else{

                $asignNumber = $this->input->post('numAsignado');
                $baNumber = $this->input->post('numBatch');
                $enterpraise = $this->input->post('empresa');
                $information = json_decode($this->input->post('gridInfo'), true);
                $numCuenta = $this->input->post('numCuenta');

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $date = date_format($date, 'Y-m-d');
                $date = explode('-', $date);
                //var_dump($asignNumber);
                //var_dump($information);
                
                // require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                $objPHPExcel = new Spreadsheet();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Pago a Proveedores Promerica") // Titulo
                ->setSubject("Pago a Proveedores Promerica") //Asunto
                ->setDescription("Pago a Proveedores Promerica") //Descripción
                ->setKeywords("Pago a Proveedores Promerica") //Etiquetas
                ->setCategory("Pago a Proveedores Promerica"); //Categorias

                $objPHPExcel->setActiveSheetIndex(0);

                //$default_border = array(
                    //'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    //'color' => array('argb' => "000")
                //);

				$correlativeNum_style = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                    ),
                    //'borders' => [
						//'allBorders' => [
							//'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							//'color' => ['argb' => '000000'],
						//],
					//],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'FFFF00',
						],
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );
				
				$style_texts_total = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
						'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                    ),
                    //'borders' => [
						//'allBorders' => [
							//'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							//'color' => ['argb' => '000000'],
						//],
					//],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'FCD5B4',
						],
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );

				$style_texts_rows = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );

                $style_texts_proveedor = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                    ),
                    // 'borders' => [
					// 	'allBorders' => [
					// 		'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
					// 		'color' => ['argb' => '000000'],
					// 	],
					// ],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'C4D79B',
						],
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );

                $style_num_order = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                    ),
                    // 'borders' => [
					// 	'allBorders' => [
					// 		'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
					// 		'color' => ['argb' => '000000'],
					// 	],
					// ],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => 'CCC0DA',
						],
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );

                $style_num_banco = array(
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                    ),
                    // 'borders' => [
					// 	'allBorders' => [
					// 		'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
					// 		'color' => ['argb' => '000000'],
					// 	],
					// ],
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => '92CDDC',
						],
                    ),
                    'font' => array(
                        'bold' => false,
						'color' => array('rgb' => '000000'),
                        'size' => 11,
                        'name' => 'Calibri'
                    )
                );

                //$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(2);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(5);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(6);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(21);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(5);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(5);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(3);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(3);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(14);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(5);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(31);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(2);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(61);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(21);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(2);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(10);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(11);

				//$objPHPExcel->getActiveSheet()->mergeCells('A1:I1');

                // $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'B');
                // $objPHPExcel->getActiveSheet()->SetCellValue('B1', $asignNumber);
                // $objPHPExcel->getActiveSheet()->SetCellValue('C1', $baNumber);
                // $objPHPExcel->getActiveSheet()->SetCellValue('F1', $date[0]);
                // $objPHPExcel->getActiveSheet()->SetCellValue('G1', $date[1]);
                // $objPHPExcel->getActiveSheet()->SetCellValue('H1', $date[2]);
                
                //$objPHPExcel->getActiveSheet()->getStyle("J1")->applyFromArray( $correlativeNum_style );
                //$objPHPExcel->getActiveSheet()->getStyle("A1:H1")->getFont()->setBold(true);
                //$objPHPExcel->getActiveSheet()->getStyle("A1:I1")->applyFromArray( $style_texts );
                //$objPHPExcel->getActiveSheet()->getStyle("A2:I2")->applyFromArray( $style_texts );
                //$objPHPExcel->getActiveSheet()->getStyle("A3:I3")->applyFromArray( $style_texts_border );

                //$objPHPExcel->getActiveSheet()->getStyle("A7:I7")->applyFromArray( $style_header );

                //$archivoTxt = fopen("PagoProveedoresBAC.csv",'w+');

                $totalDocs = 0; $totalPayment = 0; $numRow = 1;

                foreach($information as $info){
                    
                        $totalPayment  += $info['totalDocs'];
                        $totalDocs++;

                        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$numRow, substr($numCuenta, 0, 9));
                        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$numRow, substr($info['orderNum'], 0, 20));
                        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$numRow, str_replace('.', '', number_format($info['totalDocs'], 2, '', '.')));
                        
                        //$objPHPExcel->getActiveSheet()->getStyle("A".$numRow.":D".$numRow)->applyFromArray( $style_texts_rows );
                        //$objPHPExcel->getActiveSheet()->getStyle("F".$numRow.":G".$numRow)->applyFromArray( $style_texts_rows );
                        //$objPHPExcel->getActiveSheet()->getStyle("K".$numRow)->applyFromArray( $style_texts_rows );
                        //$objPHPExcel->getActiveSheet()->getStyle("E".$numRow)->applyFromArray( $correlativeNum_style );
                        //$objPHPExcel->getActiveSheet()->getStyle("I".$numRow)->applyFromArray( $style_texts_total );
                        //$objPHPExcel->getActiveSheet()->getStyle("M".$numRow)->applyFromArray( $style_texts_proveedor );
                        //$objPHPExcel->getActiveSheet()->getStyle("N".$numRow)->applyFromArray( $style_num_order );
                        //$objPHPExcel->getActiveSheet()->getStyle("Q".$numRow)->applyFromArray( $style_num_banco );
                        
                        $numRow++;
                }

                // $objPHPExcel->getActiveSheet()->SetCellValue('I1', str_replace('.', '', number_format($totalPayment, 2, '', '.')));
                // $objPHPExcel->getActiveSheet()->SetCellValue('J1', $totalDocs);
				
				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="Pago_a_Proveedores_Promerica.csv"');
                header('Cache-Control: max-age=0');
                $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Csv');
                $objWriter->save('php://output');
            }
        }
        //--------------------------------------------
        
        function getOrdenesPagos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');        
                $lista_pagos = $this->arap_model->getListaPagos();
                echo json_encode($lista_pagos);
            }
        }
        
        function detallePagoProveedores($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $controlador = $this->uri->segment(1);
                $this->load->model('global_model');
                $this->load->model('arap_model');
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
				//$this->data['info_orden'] = $this->arap_model->getInfoOrden($trannum);
				$this->data['inf'] = $this->arap_model->getInfoOrdenNew($trannum);
                $this->data['trannum'] = $trannum;
                $this->data['password'] = $this->global_model->getValorNumVariable('pos_claveordenpago');
                $this->data['authPassword'] = $this->global_model->getValorTextoVariable('cp_clave');
                //$this->load->view('mantenimiento_detalle_pago_proveedores', $this->data);
                $this->load->view('mantenimiento_detalle_pago_proveedores_new', $this->data);
            }
        }
        
        function getInfoOrden(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('arap_model');
                $info_orden = $this->arap_model->getEstatusOrden($trannum);
                $error=0;
                if($info_orden!=false){
                    
                    foreach($info_orden as $info){
                        if($info->ccestatus==1){
                            $error = 0;
                            $datos = array();
                        }else{
                            $datos_transac = $this->arap_model->getDetalleCuenta_ar($trannum);
                            $num_factura = 0;
                            $fecha = 0;
                            $fecha_vencimiento = 0;
                            $saldoPendiente = 0;
                            $tipodoc = "";
                            $dias_doc = "";
                            $proveedor = "";
                            $cant = $this->arap_model->getpagosAbiertos($trannum);
                            foreach($datos_transac as $dat){
                                $num_factura=$dat->s_n;
                                $fecha=$dat->fecha;
                                $fecha_vencimiento=$dat->fechaVencimiento;
                                $tipodoc = $dat->tipoDoc;
                                $dias_doc = $dat->dias;
                                $proveedor = $dat->cliente;
                                $saldoPendiente = $dat->saldoPendiente-$cant;
                            }   
                            $datos = array(
                                'num_factura' => $num_factura,
                                'fecha' => $fecha,
                                'fecha_vencimiento' => $fecha_vencimiento,
                                'saldo_final' => round($saldoPendiente,2),
                                'trannum' => $trannum,
                                'tipo_doc' => $tipodoc,
                                'proveedor' => $proveedor,
                            );
                            $datos = array($datos);
                            $error = 1;
                        }
                    }
                    
                }else{
                    $datos = array();
                    $error = 2;
                }
                
                
                $array = array(
                    "message" =>$error,
                    "info" =>$datos,
                );
                echo json_encode($array);
            }
        }
        
        function getPagosProveedores(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('arap_model');
                $transacciones = $this->arap_model->getPagosProveedores($trannum);
                $array = array();
                $i=0;
                foreach($transacciones as $tran){
                    $cant_cheques=0;
                    if($tran->limite>0){
                        if($tran->valor<=$tran->limite){
                            $cant_cheques = 1;
                        }else{
                            $cant = round($tran->valor/$tran->limite);
                            if(($cant*$tran->limite)<$tran->valor){
                                $cant++;
                            }
                            $valor_cheque = $tran->valor/$cant;
                            for($j = 0; $j<$cant; $j++){
                                $cant_cheques++;
                            }
                        }
                    }else{
                        $cant_cheques = 1;
                    }
                    $lista_ordenes = $this->arap_model->getPagosxProveedor($trannum,$tran->idcps);
                    $array[$i] = array(
                        "cantidad" => $tran->cantidad,
                        "cantidad_cheques" => $cant_cheques,
                        "idcps" => $tran->idcps,
                        "proveedor" => $tran->proveedor,
                        "valor" => $tran->valor,
                        "lista_ordenes" =>$lista_ordenes
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
        function insertOrdenPagos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $orden = $this->input->post('orden');
                $valor = $this->input->post('valor');
                $this->load->model('arap_model');
                $detalles = $this->arap_model->insertOrdenPago($trannum,$orden, $valor);
                $transacciones = $this->arap_model->getPagosProveedores($trannum);
                $transacciones = $this->arap_model->getPagosProveedores($trannum);
                $array = array();
                $i=0;
                foreach($transacciones as $tran){
                    $cant_cheques=0;
                    if($tran->limite>0){
                        if($tran->valor<=$tran->limite){
                            $cant_cheques = 1;
                        }else{
                            $cant = round($tran->valor/$tran->limite);
                            if(($cant*$tran->limite)<$tran->valor){
                                $cant++;
                            }
                            $valor_cheque = $tran->valor/$cant;
                            for($j = 0; $j<$cant; $j++){
                                $cant_cheques++;
                            }
                        }
                    }else{
                        $cant_cheques = 1;
                    }
                    $lista_ordenes = $this->arap_model->getPagosxProveedor($trannum,$tran->idcps);
                    $array[$i] = array(
                        "cantidad" => $tran->cantidad,
                        "cantidad_cheques" => $cant_cheques,
                        "idcps" => $tran->idcps,
                        "proveedor" => $tran->proveedor,
                        "valor" => $tran->valor,
                        "lista_ordenes" =>$lista_ordenes
                    );
                    $i++;
                }
                echo json_encode($array);
            }
        }
        
        function deletePagoProveedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idrec = $this->input->post('idrec');
                $this->load->model('arap_model');
                
                
                $delete = $this->arap_model->deletePagoProveedor($idrec);
                $transacciones = $this->arap_model->getPagosProveedores($trannum);
                $array = array();
                $i=0;
                if($transacciones!=false){
                    foreach($transacciones as $tran){
                        $cant_cheques=0;
                        if($tran->limite>0){
                            if($tran->valor<=$tran->limite){
                                $cant_cheques = 1;
                            }else{
                                $cant = round($tran->valor/$tran->limite);
                                if(($cant*$tran->limite)<$tran->valor){
                                    $cant++;
                                }
                                $valor_cheque = $tran->valor/$cant;
                                for($j = 0; $j<$cant; $j++){
                                    $cant_cheques++;
                                }
                            }
                        }else{
                            $cant_cheques = 1;
                        }
                        $lista_ordenes = $this->arap_model->getPagosxProveedor($trannum,$tran->idcps);
                        $array[$i] = array(
                            "cantidad" => $tran->cantidad,
                            "cantidad_cheques" => $cant_cheques,
                            "idcps" => $tran->idcps,
                            "proveedor" => $tran->proveedor,
                            "valor" => $tran->valor,
                            "lista_ordenes" =>$lista_ordenes
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function emitir_cheques(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $trannum = $this->input->post('trannum');
                $array_cheques=json_decode($this->input->post('array_cheques'));
                $lista_ordenes = $this->arap_model->insert_cheques($trannum,$array_cheques);
                $actualiza =  $this->arap_model->actualiza_todos_trannum();
                echo json_encode($lista_ordenes);
            }
        }
        /*
        function getBalanceCartera(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                
                $this->load->model('arap_model');
                $datos = $this->arap_model->getBalanceCartera($fechaini, $fechafin);
                
                $i=0;
                $array = array();
                if($datos != false){
                    $sum_saldo_inicial  = 0;
                    $sum_ventas_periodo = 0;
                    
                    foreach($datos as $dat){
                        $sum_saldo_inicial  += ($dat->saldo_anterior + $dat->pagosFacturas);
                        $sum_ventas_periodo += $dat->ventas_periodo;
                    }
                    
                    foreach($datos as $dat){
                        $saldo_inicial  = $dat->saldo_anterior + $dat->pagosFacturas;
                        $ventas_periodo = $dat->ventas_periodo;
                        $saldo_inicial  = (number_format($saldo_inicial, 2, '.', '') == "-0.00" ? 0 : number_format($saldo_inicial, 2, '.', ''));
                        
                        if($saldo_inicial == 0 && $ventas_periodo == 0 && abs($dat->last_abono) == 0 && abs($dat->actual_abono) == 0 && abs($dat->last_cargo) == 0 && abs($dat->actual_cargo) == 0){
                                
                        }else{
                            $array[$i] = array(
                                "idcps"              => $dat->idcps,
                                "nombre"             => $dat->descrip,
                                "sum_saldo_inicial"  => (number_format($sum_saldo_inicial, 2, '.', '') == "-0.00" ? 0 : number_format($sum_saldo_inicial, 2, '.', '')),
                                "sum_ventas_periodo" => $sum_ventas_periodo,
                                "saldo_inicial"      => (number_format($saldo_inicial, 2, '.', '') == "-0.00" ? 0 : number_format($saldo_inicial, 2, '.', '')),
                                "ventas_periodo"     => $ventas_periodo,
                                "last_abono"         => abs($dat->last_abono), 
                                "actual_abono"       => abs($dat->actual_abono),
                                "last_cargo"         => abs($dat->last_cargo), 
                                "actual_cargo"       => abs($dat->actual_cargo),
                                "saldo_final"        => (number_format($saldo_inicial+$ventas_periodo+$dat->last_abono+$dat->actual_abono+$dat->last_cargo+$dat->actual_cargo, 2, '.', '') == "-0.00" ? 0 : number_format($saldo_inicial+$ventas_periodo+$dat->last_abono+$dat->actual_abono+$dat->last_cargo+$dat->actual_cargo, 2, '.', '')),
                            );
                            $i++;
                        }
                    }
                }

                echo json_encode($array);
            }
        }
        */
        function getMovClienteFechas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idcps = $this->input->post('idcps');
                $this->load->model('arap_model');
                $arreglo = array();
                $movimientos = $this->arap_model->getMovCliente($idcps);
                $cargos_abonos = $this->arap_model->getAbonosCargosCliente($idcps);
                if($cargos_abonos!=false){
                    $arreglo = array_merge($movimientos,$cargos_abonos);
                }else{
                    $arreglo = $movimientos;
                }
                echo json_encode($arreglo);
            }
        }
        
        function depositos_bancarios($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('global_model');
                $this->load->model('conta_model');
                $this->load->model('arap_model');
                $this->load->model('sucursal_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
				$this->data['sucursales'] = $this->sucursal_model->viewSucursales_activas_asc();
                $this->data['bancos']  = $this->conta_model->getAuxiliaresByAuxidef(10);
                $this->load->view('mantenimiento_depositos_bancarios', $this->data);
            }
        }
        
        function getFormatoComprobante(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idrec = $this->input->post('idrec');
                $this->load->model('arap_model');
                $nameReporte = $this->arap_model->getFormatoComprobante($idrec);
                echo json_encode($nameReporte);    
            }
        }
        
        function getDepositosSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $idsucursal = $this->input->post("idsucursal");
                $data = $this->arap_model->getDepositos($idsucursal);
                echo json_encode($data);    
            }
        }
        
        function getPagosSucursal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $idsucursal = $this->input->post("idsucursal");
                $formaspago = $this->input->post("formaspago");
                $data = $this->arap_model->getPagosSucursal($idsucursal,$formaspago);
                echo json_encode($data);    
            }
        }
        
        function getFacturasDeposito(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $trannum = $this->input->post("trannum");
                $data = $this->arap_model->getFacturasDeposito($trannum);
                echo json_encode($data);    
            }
        }
        
        function insertDepositoBancario(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $idsucursal = $this->input->post("idsucursal");
                $fecha = $this->input->post("fecha");
                $banco = $this->input->post("banco");
                $notas = $this->input->post("notas");
                $trannum = $this->arap_model->insertDepositoBancario($idsucursal,$fecha,$banco,$notas);
                $data = $this->arap_model->getDepositos($idsucursal);
                $array = array(
                    "trannum" => $trannum,
                    "datos" => $data
                );
                echo json_encode($array);       
            }
        }
        
        function insertPagoToDeposito(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $idsucursal= $this->input->post("idsucursal");
                $factura = $this->input->post("factura");
                $trannum = $this->input->post("trannum");
                $insert = $this->arap_model->insertPagoToDeposito($factura,$trannum);
                $grid = $this->arap_model->getFacturasDeposito($trannum);
                $saldo = $this->arap_model->getSaldoDeposito($trannum);
                $array = array(
                    "grid" => $grid,
                    "saldo" =>$saldo
                );
                echo json_encode($array);       
            }
        }
        
        function removePagoToDeposito(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $this->load->model('configuracion_model');
                $idsucursal= $this->input->post("idsucursal");
                $factura = $this->input->post("factura");
                $trannum = $this->input->post("trannum");
                $insert = $this->arap_model->removePagoToDeposito($factura,$trannum);
                $grid = $this->arap_model->getFacturasDeposito($trannum);
                $saldo = $this->arap_model->getSaldoDeposito($trannum);
                
                $idsucursal = $this->input->post("idsucursal");
                $formas_pago = $this->configuracion_model->getProCentro($this->session->userdata('iddApp'));
                $lista = $this->arap_model->getPagosSucursal($idsucursal,$formas_pago);
                
                $array = array(
                    "grid" => $grid,
                    "saldo" =>$saldo,
                    "lista" =>$lista,
                );
                echo json_encode($array);       
            }
        }
        
        function pass_All_Abonos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $idsucursal= $this->input->post("idsucursal");
                $formaspago= $this->input->post("formaspago");
                $trannum = $this->input->post("trannum");
                $insert = $this->arap_model->all_fact($idsucursal, $trannum,$formaspago);
                $lista = $this->arap_model->getPagosSucursal($idsucursal,$formaspago);
                $grid = $this->arap_model->getFacturasDeposito($trannum);
                $saldo = $this->arap_model->getSaldoDeposito($trannum);
                $array = array(
                    "lista" => $lista,
                    "grid" => $grid,
                    "saldo" =>$saldo
                );
                echo json_encode($array);       
            }
        }
        
        function regresar_All_Abonos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $idsucursal= $this->input->post("idsucursal");
                $formaspago= $this->input->post("formaspago");
                $trannum = $this->input->post("trannum");
                $insert = $this->arap_model->regresar_all_fact($idsucursal, $trannum,$formaspago);
                $lista = $this->arap_model->getPagosSucursal($idsucursal,$formaspago);
                $grid = $this->arap_model->getFacturasDeposito($trannum);
                $saldo = $this->arap_model->getSaldoDeposito($trannum);
                $array = array(
                    "lista" => $lista,
                    "grid" => $grid,
                    "saldo" =>$saldo
                );
                echo json_encode($array);       
            }
        }
        
        function closeDeposito(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $idsucursal= $this->input->post("idsucursal");
                $trannum = $this->input->post("trannum");
                $gastos = $this->input->post("gastos");
                $notas = $this->input->post("notas");

                $close = $this->arap_model->close_deposito($trannum, $gastos, $notas);
                echo json_encode(true);
            }
        }
        
        function detalle_depositos_bancarios($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('sucursal_model');
                $this->load->model('global_model');
                $this->load->model('arap_model');

                $formas_pago = $this->configuracion_model->getProCentro($this->session->userdata('iddApp'));
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['info_orden'] = $this->arap_model->getInfoDeposito($trannum);
                $this->data['trannum'] = $trannum;
                $this->data['sucursales'] = $this->sucursal_model->viewSucursales_activas_asc();
                $this->data['formas_pago'] = $formas_pago;
                
                $this->load->view('mantenimiento_detalle_depositos_bancarios', $this->data);
            }
        }
        
        
        function checkAbonoDeposito(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $idrec = $this->input->post("idrec");
                $permite = $this->arap_model->checkAbonoDeposito($idrec);
                echo json_encode($permite);
            }
        }
        
        
        function ExportacionDeCuentasxCobrar($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('sucursal_model');
                $this->data['sucursales'] = $this->sucursal_model->viewSucursalActiva();
                
                $this->load->view('mantenimiento_exportacion_cc', $this->data);
            }
        }
        
        
        function reporteExportacionCC(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcentro = $this->input->post('idcentro');
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
               $array = array();
                
                
                $this->load->model('arap_model');
                $infoCC = $this->arap_model->reporteExportacionCC($idcentro, $fechaini, $fechafin);
                $infoCCPagos = $this->arap_model->reporteExportacionPagosCC($idcentro, $fechaini, $fechafin);
               
                $i=0;
                $array = array();
    
                if($infoCC != false){
                    foreach($infoCC as $infovn){
                        $fecha_venc = "";
                        if($infovn->fecvence!= "0000-00-00"){
                            $fecha_venc = $infovn->fecvence;
                        }
                        $array[$i] = array(
                            "trannum" => $infovn->trannum,
                            "nameSucursal" => strtoupper($infovn->nameSucursal),
                            "nameCaja" => strtoupper($infovn->nameCaja),
                            "fecha" => $infovn->fecha,
                            "fecvence" => $fecha_venc,
                            "dias" => $infovn->dias,
                            "serienumero" => $infovn->serienumero,
                            "nameDocumento" => strtoupper($infovn->nameDocumento),
                            "nameCliente" => strtoupper($infovn->ClienteName),
                            "vendedorAsignado" => strtoupper($infovn->VendedorAsignado),
                            "gestionadoPor" => strtoupper($infovn->VendedorTran),
                            "valor" => $infovn->valor * 1,
                        );
                        $i++;
                    }
                }
                
                if($infoCCPagos != false){
                    foreach($infoCCPagos as $infovn){
                        $fecha_venc = "";
                        if($infovn->fecvence!= "0000-00-00"){
                            $fecha_venc = $infovn->fecvence;
                        }
                        
                        $array[$i] = array(
                            "trannum" => $infovn->trannum,
                            "nameSucursal" => strtoupper($infovn->nameSucursal),
                            "nameCaja" => strtoupper($infovn->nameCaja),
                            "fecha" => $infovn->fecha,
                            "fecvence" => $fecha_venc,
                            "dias" => $infovn->dias,
                            "serienumero" => $infovn->serienumero,
                            "nameDocumento" => strtoupper($infovn->formaPago),
                            "nameCliente" => strtoupper($infovn->ClienteName),
                            "vendedorAsignado" => strtoupper($infovn->VendedorAsignado),
                            "gestionadoPor" => strtoupper($infovn->VendedorTran),
                            "referencia" => strtoupper($infovn->referencia),
                            "observaciones" => strtoupper($infovn->descripAbonoCargo),
                            "gestionadoPor" => strtoupper($infovn->VendedorTran),
                            "valor" => $infovn->valorAbonoCargo * 1,
                        );
                        $i++;
                    }
                }
                echo json_encode($array);
            }
        }
        
        function get_analisis_cxc(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $info = $this->arap_model->get_analisis_cxc();
                $total_cxc = 0;
                if($info!=false){
                    foreach($info as $inf){
                        $total_cxc += $inf->sum_1_30 + $inf->sum_31_60 + $inf->sum_61_90 + $inf->sum_91_120 + $inf->sum_121;
                    }
                }
                
                $sum_1_30=0;
                $sum_31_60=0;
                $sum_61_90=0;
                $sum_91_120=0;
                $sum_121=0;
                $sum_1_30_cant=0;
                $sum_31_60_cant=0;
                $sum_61_90_cant=0;
                $sum_91_120_cant=0;
                $sum_121_cant=0;
                if($info!=false){
                    foreach($info as $inf){
                        if(($inf->sum_1_30*1)>0){
                            $sum_1_30= $sum_1_30 + $inf->sum_1_30;
                            $sum_1_30_cant++;
                        }
                        if(($inf->sum_31_60*1)>0){
                            $sum_31_60= $sum_31_60 + $inf->sum_31_60;
                            $sum_31_60_cant++;
                        }
                        if(($inf->sum_61_90*1)>0){
                            $sum_61_90= $sum_61_90 + $inf->sum_61_90;
                            $sum_61_90_cant++;
                        }
                        if(($inf->sum_91_120*1)>0){
                            $sum_91_120= $sum_91_120 + $inf->sum_91_120;
                            $sum_91_120_cant++;
                        }
                        if(($inf->sum_121*1)>0){
                            $sum_121= $sum_121 + $inf->sum_121;
                            $sum_121_cant++;
                        }
                    }
                }
                
                $array = array();
                $i = 0;
                
                if($total_cxc>0){
                    $porcentaje1 = round(((round($sum_1_30,2) / round($total_cxc,2)))*100,2);
                    $porcentaje2 = round(((round($sum_31_60,2) / round($total_cxc,2)))*100,2);
                    $porcentaje3 = round(((round($sum_61_90,2) / round($total_cxc,2)))*100,2);
                    $porcentaje4 = round(((round($sum_91_120,2) / round($total_cxc,2)))*100,2);
                    $porcentaje5 = round(((round($sum_121,2) / round($total_cxc,2)))*100,2);
                }
                
                $cadena = $this->session->userdata("simboloMoneda")." ";
                $input = number_format(round($sum_1_30,2),2,'.',',');
                $cadena.=str_replace('#', '&nbsp;', str_pad($input, 15, "#", STR_PAD_LEFT));
                $array[$i] = array(
                    "descrip" => "1 - 30",
                    "descrip2" => "1 - 30 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$cadena,
                    "valor" =>($sum_1_30*1),
                    "data"=>array(
                        "cant" =>$sum_1_30_cant,
                        "tag" =>1
                    )
                );
                $i++;
                $cadena = $this->session->userdata("simboloMoneda")." ";
                $input = number_format(round($sum_31_60,2),2,'.',',');
                $cadena.=str_replace('#', '&nbsp;', str_pad($input, 15, "#", STR_PAD_LEFT));
                $array[$i] = array(
                    "descrip" => "31 - 60",
                    "descrip2" => "31 - 60  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$cadena,
                    "valor" =>($sum_31_60*1),
                    "data"=>array(
                        "cant" =>$sum_31_60_cant,
                        "tag" =>2
                    )
                );
                $i++;
                $cadena = $this->session->userdata("simboloMoneda")." ";
                $input = number_format(round($sum_61_90,2),2,'.',',');
                $cadena.=str_replace('#', '&nbsp;', str_pad($input, 15, "#", STR_PAD_LEFT));
                $array[$i] = array(
                    "descrip" => "61 - 90",
                    "descrip2" => "61 - 90  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$cadena,
                    "valor" =>($sum_61_90*1),
                    "data"=>array(
                        "cant" =>$sum_61_90_cant,
                        "tag" =>3
                    )
                );
                $i++;
                $cadena = $this->session->userdata("simboloMoneda")." ";
                $input = number_format(round($sum_91_120,2),2,'.',',');
                $cadena.=str_replace('#', '&nbsp;', str_pad($input, 15, "#", STR_PAD_LEFT));
                $array[$i] = array(
                    "descrip" => "91 - 120",
                    "descrip2" => "91 - 120  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$cadena,
                    "valor" =>($sum_91_120*1),

                    "data"=>array(
                        "cant" =>$sum_91_120_cant,
                        "tag" =>4
                    )
                );
                $i++;
                $cadena = $this->session->userdata("simboloMoneda")." ";
                $input = number_format(round($sum_121,2),2,'.',',');
                $cadena.=str_replace('#', '&nbsp;', str_pad($input, 15, "#", STR_PAD_LEFT));
                $array[$i] = array(
                    "descrip" => "121 +",
                    "descrip2" => "121 +  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$cadena,
                    
                    "valor" =>($sum_121*1),
                    "data"=>array(
                        "cant" =>$sum_121_cant,
                        "tag" =>5
                    )
                );
                $array_info = array(
                    "chart" =>$array,
                    "sum_total" =>number_format(round($total_cxc,2),2,'.',','),
                );
                echo json_encode($array_info);
            }
        }
        
        function get_analisis_cxc_cliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idcliente = $this->input->post("idcliente");
                $this->load->model('arap_model');
                $info = $this->arap_model->get_analisis_cxc_cliente($idcliente);
                $total_cxc = 0;
                if($info!=false){
                    foreach($info as $inf){
                        $total_cxc += $inf->sum_1_30 + $inf->sum_31_60 + $inf->sum_61_90 + $inf->sum_91_120 + $inf->sum_121;
                    }
                }
                
                $sum_1_30=0;
                $sum_31_60=0;
                $sum_61_90=0;
                $sum_91_120=0;
                $sum_121=0;
                $sum_1_30_cant=0;
                $sum_31_60_cant=0;
                $sum_61_90_cant=0;
                $sum_91_120_cant=0;
                $sum_121_cant=0;
                if($info!=false){
                    foreach($info as $inf){
                        if(($inf->sum_1_30*1)>0){
                            $sum_1_30= $sum_1_30 + $inf->sum_1_30;
                            $sum_1_30_cant++;
                        }
                        if(($inf->sum_31_60*1)>0){
                            $sum_31_60= $sum_31_60 + $inf->sum_31_60;
                            $sum_31_60_cant++;
                        }
                        if(($inf->sum_61_90*1)>0){
                            $sum_61_90= $sum_61_90 + $inf->sum_61_90;
                            $sum_61_90_cant++;
                        }
                        if(($inf->sum_91_120*1)>0){
                            $sum_91_120= $sum_91_120 + $inf->sum_91_120;
                            $sum_91_120_cant++;
                        }
                        if(($inf->sum_121*1)>0){
                            $sum_121= $sum_121 + $inf->sum_121;
                            $sum_121_cant++;
                        }
                    }
                }
                
                $array = array();
                $i = 0;
                
                if($total_cxc>0){
                    $porcentaje1 = round(((round($sum_1_30,2) / round($total_cxc,2)))*100,2);
                    $porcentaje2 = round(((round($sum_31_60,2) / round($total_cxc,2)))*100,2);
                    $porcentaje3 = round(((round($sum_61_90,2) / round($total_cxc,2)))*100,2);
                    $porcentaje4 = round(((round($sum_91_120,2) / round($total_cxc,2)))*100,2);
                    $porcentaje5 = round(((round($sum_121,2) / round($total_cxc,2)))*100,2);
                }
                
                $cadena = $this->session->userdata("simboloMoneda")." ";
                $input = number_format(round($sum_1_30,2),2,'.',',');
                $cadena.=str_replace('#', '&nbsp;', str_pad($input, 10, "#", STR_PAD_LEFT));
                $array[$i] = array(
                    "descrip" => "1 - 30",
                    "descrip2" => "1 - 30 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$cadena,
                    "valor" =>($sum_1_30*1),
                    "data"=>array(
                        "cant" =>$sum_1_30_cant,
                        "tag" =>1
                    )
                );
                $i++;
                $cadena = $this->session->userdata("simboloMoneda")." ";
                $input = number_format(round($sum_31_60,2),2,'.',',');
                $cadena.=str_replace('#', '&nbsp;', str_pad($input, 10, "#", STR_PAD_LEFT));
                $array[$i] = array(
                    "descrip" => "31 - 60",
                    "descrip2" => "31 - 60  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$cadena,
                    "valor" =>($sum_31_60*1),
                    "data"=>array(
                        "cant" =>$sum_31_60_cant,
                        "tag" =>2
                    )
                );
                $i++;
                $cadena = $this->session->userdata("simboloMoneda")." ";
                $input = number_format(round($sum_61_90,2),2,'.',',');
                $cadena.=str_replace('#', '&nbsp;', str_pad($input, 10, "#", STR_PAD_LEFT));
                $array[$i] = array(
                    "descrip" => "61 - 90",
                    "descrip2" => "61 - 90  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$cadena,
                    "valor" =>($sum_61_90*1),
                    "data"=>array(
                        "cant" =>$sum_61_90_cant,
                        "tag" =>3
                    )
                );
                $i++;
                $cadena = $this->session->userdata("simboloMoneda")." ";
                $input = number_format(round($sum_91_120,2),2,'.',',');
                $cadena.=str_replace('#', '&nbsp;', str_pad($input, 10, "#", STR_PAD_LEFT));
                $array[$i] = array(
                    "descrip" => "91 - 120",
                    "descrip2" => "91 - 120  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$cadena,
                    "valor" =>($sum_91_120*1),

                    "data"=>array(
                        "cant" =>$sum_91_120_cant,
                        "tag" =>4
                    )
                );
                $i++;
                $cadena = $this->session->userdata("simboloMoneda")." ";
                $input = number_format(round($sum_121,2),2,'.',',');
                $cadena.=str_replace('#', '&nbsp;', str_pad($input, 10, "#", STR_PAD_LEFT));
                $array[$i] = array(
                    "descrip" => "121 +",
                    "descrip2" => "121 +  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$cadena,
                    
                    "valor" =>($sum_121*1),
                    "data"=>array(
                        "cant" =>$sum_121_cant,
                        "tag" =>5
                    )
                );
                $array_info = array(
                    "chart" =>$array,
                    "sum_total" =>number_format(round($total_cxc,2),2,'.',','),
                );
                echo json_encode($array_info);
            }
        }
        
        function get_cxc_periodo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('arap_model');
                $tipo = $this->input->post("tipo");
                $saldo_total = $this->input->post("saldo");
                $info = $this->arap_model->get_analisis_cxc();
                
                $array = array();
                $i = 0;
                $num_tran = 0;
                if($info!=false){
                    foreach($info as $inf){
                        $cant_tran = $this->arap_model->getCant_Trans($inf->idcliente);
                        
                        $saldo = 0;
                        switch($tipo){
                            case 1:
                                $saldo = $inf->sum_1_30;
                                $num_tran = $cant_tran['tran_1_30'];
                                break;
                            case 2:
                                $saldo = $inf->sum_31_60;
                                $num_tran = $cant_tran['tran_31_60'];
                                break;
                            case 3: 
                                $saldo = $inf->sum_61_90;
                                $num_tran = $cant_tran['tran_61_90'];
                                break;  
                            case 4:
                                $saldo = $inf->sum_91_120;
                                $num_tran = $cant_tran['tran_91_120'];
                                break;
                            case 5: 
                                $saldo = $inf->sum_121;
                                $num_tran = $cant_tran['tran_121'];
                                break;
                            default:
                                $saldo = 0;
                                break;
                        }
                        if($saldo!=0){
                            $array[$i] = array(
                                "idcliente"=>$inf->idcliente,
                                "descrip"=>$inf->cliente,
                                "cant"=>$num_tran,
                                "saldo"=>$saldo,
                                "porcentaje"=>round( (($saldo/$saldo_total)*100) ,2),
                            );
                            $i++;
                        }
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        
        function mantenimiento_listado_doc_cxc($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
				$this->data['gestiones'] = $this->variable_model->getVariablesNombre("cc_gestiones");
                $this->load->view('mantenimiento_listado_doc_cxc', $this->data);
            }
        }
        
		function getListadoDocs(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('arap_model');
				$data = $this->arap_model->getListadoDocs();
				echo json_encode($data);
			}
		}

		function getListadoGestiones(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$trannum = $this->input->post("trannum");
				$this->load->model('arap_model');
				$data = $this->arap_model->getListadoGestiones($trannum);
				echo json_encode($data);
			}
		}
		function insertGestion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$trannum = $this->input->post("trannum");
				$gestion = $this->input->post("gestion");
				$fecha = $this->input->post("fecha");
				$notas = $this->input->post("notas");
				$this->load->model('arap_model');
				$data = $this->arap_model->insertGestion($trannum,$gestion,$fecha,$notas);
				$data = $this->arap_model->getListadoGestiones($trannum);
				echo json_encode($data);
			}
		}
		function updateGestion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idrec = $this->input->post("idrec");
				$trannum = $this->input->post("trannum");
				$gestion = $this->input->post("gestion");
				$fecha = $this->input->post("fecha");
				$notas = $this->input->post("notas");
				$this->load->model('arap_model');
				$this->arap_model->updateGestion($idrec, $trannum,$gestion,$fecha,$notas);
				$data = $this->arap_model->getListadoGestiones($trannum);
				echo json_encode($data);
			}
		}
		function deleteGestion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idrec = $this->input->post("idrec");
				$trannum = $this->input->post("trannum");
				$this->load->model('arap_model');
				$this->arap_model->deleteGestion($idrec);
				$data = $this->arap_model->getListadoGestiones($trannum);
				echo json_encode($data);
			}
		}

		function saveSessionsData(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$filtros = $this->input->post("filtros");
				$columns = $this->input->post("columns");
				$result = array(
                    'filtros_docs' => $filtros,
                    'columns_docs' => $columns,
                );
                $save = $this->session->set_userdata($result);
				echo json_encode($save);
			}
		}

        #   PRUEBAS OPTIMIZACION BALANCE CARTERA
        function balance_cartera_cxc_test($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('global_model');
                $this->load->model('arap_model');
                $controlador = $this->uri->segment(1);
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->load->view('mantenimiento_balance_cartera_cxc_test', $this->data);
            }
        }

        function getBalanceCartera(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
  
                $this->load->model('arap_model');
                $cajclase = $this->arap_model->getBalanceCarteraCreditchk();

                $auxis = $this->arap_model->getBalanceCarteraAuxis($cajclase, $fechaini, $fechafin);
                $arrayBalance = [];
                $sum_saldo_inicial = 0;
                $sum_ventas_periodo = 0;
      
                $i = 0;
                if($auxis){
                    foreach($auxis as $auxi){
                        $saldoAnterior = $this->getBalanceCarteraSaldoAnterior($cajclase, $fechaini, $auxi->idcps);
                        $pagosFacturas = $this->getBalanceCarteraPagosFacturas($cajclase, $fechaini, $auxi->idcps);
                        $ventasPeriodo = $this->getBalanceCarteraVentasPeriodo($cajclase, $fechaini, $fechafin, $auxi->idcps);
                        $lastAbono = $this->getBalanceCarteraLastAbono($cajclase, $fechaini, $fechafin, $auxi->idcps);
                        $actualAbono = $this->getBalanceCarteraActualAbono($cajclase, $fechaini, $fechafin, $auxi->idcps);
                        $lastCargo = $this->getBalanceCarteraLastCargo($cajclase, $fechaini, $fechafin, $auxi->idcps);
                        $actualCargo = $this->getBalanceCarteraActualCargo($cajclase, $fechaini, $fechafin, $auxi->idcps);

                        $saldoInicial = $saldoAnterior + $pagosFacturas;
                        $saldoInicial = (number_format($saldoInicial, 2, '.', '') == "-0.00" ? 0 : number_format($saldoInicial, 2, '.', ''));
                        
                        if(!($saldoInicial == 0 && $ventasPeriodo == 0 && abs($lastAbono) == 0 && abs($actualAbono) == 0 && abs($lastCargo) == 0 && abs($actualCargo) == 0)){
                            $saldoFinal = number_format($saldoInicial + $ventasPeriodo + $lastAbono + $actualAbono + $lastCargo + $actualCargo, 2, '.', '');
                            $sum_saldo_inicial  += $saldoInicial;
                            $sum_ventas_periodo += $ventasPeriodo;

                            $arrayBalance[$i]=array(
                                "idcps"=>$auxi->idcps,
                                "nombre"=>$auxi->descrip,
                                "saldo_inicial"=>$saldoInicial,
                                "ventas_periodo"=>$ventasPeriodo,
                                "last_abono"=> abs($lastAbono),
                                "actual_abono"=> abs($actualAbono),
                                "last_cargo"=> abs($lastCargo),
                                "actual_cargo"=> abs($actualCargo),
                                "saldo_final"=> ($saldoFinal == "-0.00" ? 0 : number_format($saldoFinal, 2, '.', '')),
                                "sum_saldo_inicial"=> 0,
                                "sum_ventas_periodo"=> 0,
                            );
                            $i++;
                        }
                    }

                    foreach($arrayBalance as &$ar){
                        $ar['sum_saldo_inicial'] = $sum_saldo_inicial;
                        $ar['sum_ventas_periodo'] = $sum_ventas_periodo;
                    }

                }
                echo json_encode($arrayBalance);
            }
        }
        
        function getBalanceCarteraSaldoAnterior($cajclase, $fechaini, $idcps){
            $this->load->model('arap_model');

            $datos = $this->arap_model->getBalanceCarteraSaldoAnterior($cajclase, $fechaini, $idcps);
            $saldoAnterior = 0;

            //var_dump($datos);
            if($datos){
                foreach($datos as $dat){
                    $saldoAnterior += ($dat->valventan + $dat->valtax1);
                }
            }

            return $saldoAnterior;
        }

        function getBalanceCarteraPagosFacturas($cajclase, $fechaini, $idcps){
            $this->load->model('arap_model');

            $datos = $this->arap_model->getBalanceCarteraPagosFacturas($cajclase, $fechaini, $idcps);
            $pagosFacturas = 0;

            //var_dump($datos);
            if($datos){
                foreach($datos as $dat){
                    $pagosFacturas += ($dat->valor - $dat->vuelto);
                }
            }

            return $pagosFacturas;
        }

        function getBalanceCarteraVentasPeriodo($cajclase, $fechaini, $fechafin, $idcps){
            $this->load->model('arap_model');

            $datos = $this->arap_model->getBalanceCarteraVentasPeriodo($cajclase, $fechaini, $fechafin, $idcps);
            $ventasPeriodo = 0;

            //var_dump($datos);
            if($datos){
                foreach($datos as $dat){
                    $ventasPeriodo += ($dat->valventan + $dat->valtax1);
                }
            }

            return $ventasPeriodo;
        }

        function getBalanceCarteraLastAbono($cajclase, $fechaini, $fechain, $idcps){
            $this->load->model('arap_model');

            $datos = $this->arap_model->getBalanceCarteraLastAbono($cajclase, $fechaini, $fechain, $idcps);
            $lastabono = 0;

            //var_dump($datos);
            if($datos){
                foreach($datos as $dat){
                    $lastabono += ($dat->valor - $dat->vuelto);
                }
            }

            return $lastabono;
        }

        function getBalanceCarteraActualAbono($cajclase, $fechaini, $fechain, $idcps){
            $this->load->model('arap_model');

            $datos = $this->arap_model->getBalanceCarteraActualAbono($cajclase, $fechaini, $fechain, $idcps);
            $actualAbono = 0;

            //var_dump($datos);
            if($datos){
                foreach($datos as $dat){
                    $actualAbono += ($dat->valor - $dat->vuelto);
                }
            }

            return $actualAbono;
        }

        function getBalanceCarteraLastCargo($cajclase, $fechaini, $fechain, $idcps){
            $this->load->model('arap_model');

            $datos = $this->arap_model->getBalanceCarteraLastCargo($cajclase, $fechaini, $fechain, $idcps);
            $lastCargo = 0;

            //var_dump($datos);
            if($datos){
                foreach($datos as $dat){
                    $lastCargo += ($dat->valor - $dat->vuelto);
                }
            }

            return $lastCargo;
        }

        function getBalanceCarteraActualCargo($cajclase, $fechaini, $fechain, $idcps){
            $this->load->model('arap_model');

            $datos = $this->arap_model->getBalanceCarteraActualCargo($cajclase, $fechaini, $fechain, $idcps);
            $actualCargo = 0;

            //var_dump($datos);
            if($datos){
                foreach($datos as $dat){
                    $actualCargo += ($dat->valor - $dat->vuelto);
                }
            }

            return $actualCargo;
        }

        #   TRANSACCIONES CANCELADAS DETALLE CXC

        function getTransaccionesDetalleCxc(){
            $idauxi = $this->input->post('idauxi');
            $estado = $this->input->post('estado');
            $fechaini = $this->input->post('fechaini');
            $fechafin = $this->input->post('fechafin');

            $this->load->model('arap_model');
            $idcredito = $this->arap_model->getBalanceCarteraCreditchk();
            $info = $this->arap_model->getInfoClienteCredito($idauxi, $idcredito, $estado, $fechaini, $fechafin);
            $resultado = [];
            $i = 0;
            foreach($info as $in){
                $resultado[$i] = array(
                    "trannum" => $in->trannum,
                    "key" => $in->Sucursal,
                    "fecha" => $in->fechaFormat,
                    "numero" => $in->serie.$in->numero,
                    "ccestatus" => $in->ccestatus,
                    "valor" => round($in->val_fact),
                    "isnotacredtio" => (int)$in->isnotacredito,
                    "doc_fecha" => $in->fecha
                );

                $i++;
            }

            echo json_encode($resultado);
        }


        // BUSQUEDA DE DOCUMENTOS POR NUMERO
        function buscarDocumentoNumero(){
            $idauxi = $this->input->post('numero');

            $this->load->model('arap_model');
            $this->load->model('ventas_model');

            $idcredito = $this->arap_model->getBalanceCarteraCreditchk();
            $resultado = $this->arap_model->buscarDocumentoNumero($idauxi, $idcredito);

            if($resultado){
                foreach($resultado as $key=>$value){
                    $formato = $this->ventas_model->getFormatoPrintDef($value['idclase'],'ventas/facturaz/pprint');
                    $resultado[$key]['formato'] = $formato[0]->formname;
                }
            }

            echo json_encode($resultado);
        }
    }

?>