<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Acsventas extends CI_Controller {
        
        function __construct(){
            parent::__construct();
        }
		
		function facturacion($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcionmenu' => $opcionmenu
                );
                $this->session->set_userdata($resultAppName);
				$this->load->model('global_model');
                $this->load->model('acs_model');
				
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $direccion2 = $controlador.'/'.$funcion.'/pprint';
				$this->data['pprintfo'] = $this->global_model->getFormatosImpresionGrid($direccion2);
				$this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
				$this->data['documentos'] = $this->acs_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->acs_model->getVendedoresActivos();
                $this->data['newcliente'] = $this->acs_model->getFiltroBuscaProd('pos_newcli');
                $this->load->view('acs_mantenimiento_facturacion', $this->data);
				$showpprint = array(
					"show_pprint" => 0
				);
				$this->session->set_userdata($showpprint);
            }
		}
		
		function getFormatoPrintClase(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idclase = $this->input->post('idclase');
				$url = 'acsventas/facturacion/pprint';
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getFormatoPrintDef($idclase,$url);
				echo json_encode($array);
            }
		}
		
		function detallefacturacion($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
				
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
                $this->load->model('acs_model');
				$this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
				$controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->acs_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->acs_model->getVendedoresActivos();
                $this->data['informacion'] = $this->ventas_model->getDatosFactura($trannum);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $this->data['pdescuento'] = $this->ventas_model->getPerDescuento('pos_chgpre');
                $this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
				$this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
				$this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
				
                $this->load->view('acs_mantenimiento_detallefacturacion', $this->data);
            }
		}
		
		function getDatosVenta100k(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');                
                $this->load->model('acs_model');
                $array = $this->acs_model->getDataVenta100k($idtrannum);
                echo json_encode($array);
			}
		}
		
		function getCuotasPendientes(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idcps = $this->input->post('idcps');
                $this->load->model('acs_model');
                $array = $this->acs_model->getCuotasPendientesByAlumno($idcps);
                echo json_encode($array);
			}
		}
		
		function getInformacionCuota(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idrec = $this->input->post('idrec');
				$this->load->model('acs_model');
                $array = $this->acs_model->getInformacionCuotaById($idrec);
                echo json_encode($array);
			}
		}
		
		function updateInformacionCuotaAlumno(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idrec = $this->input->post('idrec');
				$numcuota = $this->input->post('numcuota');
				$valor = $this->input->post('valor');
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
				$fechavence = $this->input->post('fechavence');
				$this->load->model('acs_model');
                $array = $this->acs_model->updateInformacionCuotaAlumno($idrec,$numcuota,$valor,$fechaini,$fechafin,$fechavence);
                echo json_encode($array);
			}
		}
		
		function deleteInformacionCuotaAlumno(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idrec = $this->input->post('idrec');
				$this->load->model('acs_model');
                $array = $this->acs_model->deleteCuotaByCodigo($idrec);
                echo json_encode($array);
			}
		}
		
		function getListadoProductosVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idcps = $this->input->post('idcps');
                $this->load->model('acs_model');
                $tipos = $this->acs_model->getTiposProductos('gv_protipo');
                $productos = $this->acs_model->getListadoProductosVenta($idtrannum);
				
				$i=0;
				$datos = array();
				foreach($tipos as $tip){
					$j=0;
					$items = array();
					foreach($productos as $info){
						if($info->descripcion == $tip->descripcion){
							$items[$j] = array(
								"idproducto" => $info->idproducto,
								"descrip" => $info->descrip,
								"precioventa" => $info->precioventa,
								"imagen" => $info->imagen,
								"tipotax" => $info->tipotax
							);
							$j++;
						}
					}
					
					$datos[$i] = array(
						"key" => $tip->descripcion,
						"items" => $items
					);
					$i++;
				}
				
                echo json_encode($datos);
			}
		}
		
		function getDatosFacturasVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                
                $datosTemp = array(
                    'idcentroTemp' => $idcentro,
                    'idcajaTemp' => $idcaja,
                    'fechaini' => $fechaini,
                    'fechafin' => $fechafin
                );
                $this->session->set_userdata($datosTemp);
                
                $this->load->model('ventas_model');
                $this->load->model('acs_model');
                $datos = $this->ventas_model->getDatosFacturaciones('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    $detalle = $this->acs_model->getDetalleFacturas($info->trannum);
                    
                    $j=0;
                    $detailFacturas = array();
                    
                    foreach($detalle as $data){
						$valtax1 = $data->precioneto * ($data->tax1 / 100);
                        $total = abs($data->cantidad) * $data->precioneto + $valtax1;
						$detailFacturas[$j] = array(
                            "itemline" => $data->itemline,
                            "idproducto" => $data->idproducto,
                            "descrip" => $data->descrip,
							"cantidad" => abs($data->cantidad),
                            "precio" => "$".number_format($data->precioneto, 6, '.', ','),
                            "tax1" => "$".number_format($valtax1, 6, '.', ','),
                            "total" => "$".number_format($total, 2, '.', ',')
                        );
                        $j++;
                    }
                    
                    $totalVenta = $info->valventan + $info->valtax1;
                    
                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "numeroserie" => $info->numeroserie,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "valventan" => number_format($totalVenta, 2, '.', ''),
                        "detailFacturas" => $detailFacturas,
                        "estatus" => $info->estatus
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
		
		function updateTrannumCuota(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idcps = $this->input->post('idcps');
                $idrec = $this->input->post('idrec');
                $precio = $this->input->post('precio');
                $tipotax = $this->input->post('tipotax');
                $idproducto = $this->input->post('idproducto');
				
                $this->load->model('acs_model');
                $this->load->model('invtran_model');
				$this->acs_model->updateTrannumCuotaAlumno($idtrannum, $idrec, $precio, $tipotax, $idproducto);
				$this->invtran_model->deleteVenta100c($idtrannum);
				
                $cuotas = $this->acs_model->getCuotasPendientesByAlumno($idcps);
				$detalle = $this->acs_model->getDataVenta100k($idtrannum);
				$cantidad = $this->invtran_model->getCantidad100k($idtrannum);
                $unidades = $this->invtran_model->getUnidades100k($idtrannum);
				
				$array = array(
					"cuotas" => $cuotas,
					"detalle" => $detalle,
					"cantidad" => $cantidad,
					"unidades" => $unidades
				);
				
				echo json_encode($array);
			}
		}
		
		function deleteRegistroVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('idtrannum');
				$idcps = $this->input->post('idcps');
                $idrec = $this->input->post('idrec');
				$this->load->model('acs_model');
				$this->load->model('invtran_model');
				$this->acs_model->deletePagoCuotaAlumno($idtrannum, $idcps, $idrec);
				$this->invtran_model->deleteVenta100c($idtrannum);

                $cuotas = $this->acs_model->getCuotasPendientesByAlumno($idcps);
				$detalle = $this->acs_model->getDataVenta100k($idtrannum);
				$cantidad = $this->invtran_model->getCantidad100k($idtrannum);
                $unidades = $this->invtran_model->getUnidades100k($idtrannum);
				
				$array = array(
					"cuotas" => $cuotas,
					"detalle" => $detalle,
					"cantidad" => $cantidad,
					"unidades" => $unidades
				);
				
				echo json_encode($array);
			}
		}
		
		function agregarProductoFacturacion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$cantidad = $this->input->post('cantidad');
				$idcps = $this->input->post('idcps');
                $idproducto = $this->input->post('idproducto');
                $trannum = $this->input->post('idtrannum');
                $precio = $this->input->post('precio');
                $tipotax = $this->input->post('tipotax');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $idworker = $this->input->post('idworker');
                $idclase = $this->input->post('idclase');
				$notas = $this->input->post('notas');
                
                $this->load->model('acs_model');
                $this->load->model('invtran_model');
                $this->acs_model->insertarProductoVenta($idproducto,$cantidad,$trannum,$precio,$idworker,$notas,$tipotax,$pro_vende,$modevn);
                $this->invtran_model->deleteVenta100c($trannum);
				
                $cuotas = $this->acs_model->getCuotasPendientesByAlumno($idcps);
				$detalle = $this->acs_model->getDataVenta100k($trannum);
				$cantidad = $this->invtran_model->getCantidad100k($trannum);
                $unidades = $this->invtran_model->getUnidades100k($trannum);
				
				$total = 0;
                foreach($detalle as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                }
				
				$array = array(
					"cuotas" => $cuotas,
					"detalle" => $detalle,
					"cantidad" => $cantidad,
					"unidades" => $unidades,
                    "total" => $total
				);
                
                echo json_encode($array);
			}
		}
		
		function getDetallePagosVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                
                $this->load->model('ventas_model');
                $this->load->model('acs_model');
                $datos = $this->ventas_model->getDetallePagosVentas($idtrannum);
                $data = $this->acs_model->getDataVenta100k($idtrannum);
                
                $total = 0;
                foreach($data as $t100k){
                    $precioneto = $t100k->precioneto + ($t100k->precioneto * ($t100k->tipotax / 100));
                    $total = $total + $precioneto * abs($t100k->cantidad);
                }
                
                $i=0;
                $array = array();
                foreach($datos as $info){
                    $pendiente = $total + $info->valor;
                    $array[$i] = array(
                        "idrec" => $info->idrec,
                        "imagen" => $info->imagen,
                        "descrip" => $info->descrip,
                        "notas" => $info->notas,
                        "valor" => $info->valor,
                        "pendiente" => number_format($pendiente, 2, '.', ',')
                    );
                    
                    $total = $total + $info->valor;
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
		
		function insertPagoVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $valor = $this->input->post('valor');
                $idclase = $this->input->post('idclase');
                $cajclase = $this->input->post('cajclase');
                $idworker = $this->input->post('idworker');
                $notas = $this->input->post('notas');
                
                $this->load->model('ventas_model');
                $this->load->model('acs_model');
                
                $this->ventas_model->insertPagoVenta($idtrannum, $valor, $idclase, $cajclase, $idworker, $notas);
                $total = $this->ventas_model->getTotalCanceladoVentas($idtrannum);
                $this->ventas_model->updateCCEstatus($idtrannum, 1);
                $datos = $this->ventas_model->getDetallePagosVentas($idtrannum);
                $data = $this->acs_model->getDataVenta100k($idtrannum);
                
                $total = 0;
                foreach($data as $t100k){
                    $precioneto = $t100k->precioneto + ($t100k->precioneto * ($t100k->tipotax / 100));
                    $total = $total + $precioneto * abs($t100k->cantidad);
                }
                
                $i=0; $cancelado=0;
                $informacion = array();
                foreach($datos as $info){
                    $pendiente = $total + $info->valor;
                    $informacion[$i] = array(
                        "idrec" => $info->idrec,
                        "imagen" => $info->imagen,
                        "descrip" => $info->descrip,
                        "valor" => $info->valor,
                        "pendiente" => number_format($pendiente, 2, '.', ',')
                    );
                    
                    $cancelado = $cancelado + $info->valor;
                    
                    $total = $total + $info->valor;
                    $i++;
                }
                
                $array = array(
                    "datos" => $informacion,
                    "totalCancelado" => $cancelado
                );
                echo json_encode($array);
            }
        }
        
		function insertCreditoPagoVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $valor = $this->input->post('valor');
                $idclase = $this->input->post('idclase');
                $cajclase = $this->input->post('cajclase');
                $idworker = $this->input->post('idworker');
                $idcps = $this->input->post('idcps');
                $notas = $this->input->post('notas');
                
                $this->load->model('ventas_model');
                $this->load->model('acs_model');
                
                $this->ventas_model->insertCreditoPagoVenta($idtrannum, $valor, $idclase, $cajclase, $idworker, $notas, $idcps);
                $total = $this->ventas_model->getTotalCanceladoVentas($idtrannum);
                $this->ventas_model->updateCCEstatus($idtrannum, 0);
                $datos = $this->ventas_model->getDetallePagosVentas($idtrannum);
                $data = $this->acs_model->getDataVenta100k($idtrannum);
                
                $total = 0;
                foreach($data as $t100k){
                    $precioneto = $t100k->precioneto + ($t100k->precioneto * ($t100k->tipotax / 100));
                    $total = $total + $precioneto * abs($t100k->cantidad);
                }
                
                $i=0; $cancelado=0;
                $informacion = array();
                foreach($datos as $info){
                    $pendiente = $total + $info->valor;
                    $informacion[$i] = array(
                        "idrec" => $info->idrec,
                        "imagen" => $info->imagen,
                        "descrip" => $info->descrip,
                        "valor" => $info->valor,
                        "pendiente" => number_format($pendiente, 2, '.', ',')
                    );
                    
                    $cancelado = $cancelado + $info->valor;
                    
                    $total = $total + $info->valor;
                    $i++;
                }
                
                $array = array(
                    "datos" => $informacion,
                    "totalCancelado" => $cancelado
                );
                echo json_encode($array);
            }
        }
        
        function deletePagoVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $idtrannum = $this->input->post('idtrannum');
                $idrec = $this->input->post('idrec');
                
                $this->load->model('ventas_model');
                $this->load->model('acs_model');
                
                $this->ventas_model->deleteRegistroPago($idrec);
                $total = $this->ventas_model->getTotalCanceladoVentas($idtrannum);
				$this->ventas_model->updateCCEstatus($idtrannum, 0);
                $datos = $this->ventas_model->getDetallePagosVentas($idtrannum);
                $data = $this->acs_model->getDataVenta100k($idtrannum);
                
                $total = 0;
                foreach($data as $t100k){
                    $precioneto = $t100k->precioneto + ($t100k->precioneto * ($t100k->tipotax / 100));
                    $total = $total + $precioneto * abs($t100k->cantidad);
                }
                
                $i=0; $cancelado=0;
                $informacion = array();
                foreach($datos as $info){
                    $pendiente = $total + $info->valor;
                    $informacion[$i] = array(
                        "idrec" => $info->idrec,
                        "imagen" => $info->imagen,
                        "descrip" => $info->descrip,
                        "valor" => $info->valor,
                        "pendiente" => number_format($pendiente, 2, '.', ',')
                    );
                    
                    $cancelado = $cancelado + $info->valor;
                    
                    $total = $total - abs($info->valor);
                    $i++;
                }
                
                $array = array(
                    "datos" => $informacion,
                    "totalCancelado" => $cancelado
                );
                echo json_encode($array);
            }
        }
		
		function anulacionVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				$idtrannum = $this->input->post('trannum');
				$idcps = $this->input->post('idcps');
				$this->load->model('acs_model');
                $array = $this->acs_model->setAnulacionVenta($idtrannum, $idcps);
                echo json_encode($array);
			}
		}
		
		function insertInformacionCuotaAlumno(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$idproducto = $this->input->post('idproducto');
				$idauxi = $this->input->post('idauxi');
				$numcuota = $this->input->post('numcuota');
				$valor = $this->input->post('valor');
				$fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');
				$fechavence = $this->input->post('fechavence');
				$this->load->model('acs_model');
                $array = $this->acs_model->insertInformacionCuotaAlumno($idproducto,$idauxi,$numcuota,$valor,$fechaini,$fechafin,$fechavence);
                echo json_encode($array);
			}
		}
		
		function getInformacionFacturaPagada(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$trannum = $this->input->post('trannum');
				
				$this->load->model('acs_model');
                $detalle = $this->acs_model->getInformacionFacturaAlumno($trannum);
				$pagos = $this->acs_model->getInformacionPagoFacturaAlumno($trannum);
				
				$array = array(
					'detalle' => $detalle,
					'pagos' => $pagos
				);
				
                echo json_encode($array);
			}
		}
	}
?>