<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Acs extends CI_Controller{
    
	function __construct(){
        parent::__construct();
    }
    
    function verAlumno($idApp){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->load->model('global_model');
            $controlador = $this->uri->segment(1);
            $funcion = $this->uri->segment(2);
            $direccion = $controlador.'/'.$funcion;
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->session->set_userdata($resultAppName);
            $this->load->model('acs_model');
            $this->data['listcarreras'] = $this->acs_model->getListadoCarreras(1);
            $this->load->view('acs_mantenimiento_alumno', $this->data); 
        }
    }
    
	function getInasignados(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('acs_model');
            $array = $this->acs_model->getInasignados();
            echo json_encode($array);
        }
    }
    
    function verAlumnos(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('acs_model');
            $info_alumno = $this->acs_model->viewAlumnos();
            $i=0;
            $array = array();
            
            foreach($info_alumno as $student){
                $detailGestiones = array();
                $detail_ges = $this->acs_model->getGestionesStudent($student->idauxi);
                
                $j=0;
                if($detail_ges!=false){
                    foreach($detail_ges as $gest){
                        
                        if($gest->tipo==0){
                            $att="No asistió";
                        }else if($gest->tipo==1){
                            $att="Asistió";
                        }else if($gest->tipo==2){
                            $att="Permiso";
                        }else{
                            $att="";
                        }
                        
                        $detailGestiones[$j] = array(
                            "idrec" => $gest->idrec,
                            "idgestion" => $gest->idgestion,
                            "gestion" => $gest->gestion,
                            "idauxi" => $gest->idauxi,
                            "idcurso" => $gest->idcurso,
                            "fecha" => $gest->fecha,
                            "att" => $att,
                        );
                        $j++;
                    }
                }else{
                    $detailGestiones=false;
                }
                
                
                $array[$i] = array(
                    "idauxi" => $student->idauxi,
                    "descrip" => $student->descrip,
                    "telefono" => $student->telefono,
                    "correo" => $student->correo,
                    "nrc" => $student->nrc,
                    "idcurso" => $student->idcurso,
                    "idproducto" => $student->idproducto,
                    "infoGestiones"=>$detailGestiones
                );
                
                $i++;
            }
            
            echo json_encode($array);
        }
    }
        
    function newAlumno(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('acs_model');
            $this->load->model('cliente_model');
            
            $this->data['grupos'] = $this->acs_model->viewGrupos();
            $this->data['horarios'] = $this->acs_model->viewHorarios();
            $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
            $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
            $this->load->view('new_alumno', $this->data);
        }
    }
    
    function registrarAlumno(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idauxi = $this->input->post('idauxidef'); 
            $descrip = $this->input->post('descrip');
            $grupo = $this->input->post('grupo');
            $telefonoc = $this->input->post('telefono');
            $telefonom = $this->input->post('telefonom');
            $telefono = $telefonoc.",".$telefonom;
            $correo = $this->input->post('correo');
            $departamento = $this->input->post('departamento');
            $horario = $this->input->post('horario');
            $ingreso = $this->input->post('ingreso');
            $nacimiento = $this->input->post('nacimiento');
            $nrc = $this->input->post('dui');
            $nit = $this->input->post('nit');
            $dir = $this->input->post('direccion');
            $direccion = str_replace(array("\n", "\r", "\n\r"), " ", $dir);
            $whodidit = $this->session->userdata('iduser');
            $img = $this->input->post('imgen');
            $estado = $this->input->post('estado');
            $this->load->model('acs_model');
                
            if($estado == 1){
                $nameimagen = $this->acs_model->insertAlumnoA($idauxi, $descrip, $grupo, $telefono, $correo, $direccion, $departamento, $ingreso, $nacimiento, $nrc, $nit, $horario, $img, $whodidit); 
            }else{
                $nameimagen = $this->acs_model->insertAlumnoI($idauxi, $descrip, $grupo, $telefono, $correo, $direccion, $departamento, $ingreso, $nacimiento, $nrc, $nit, $horario, $img, $whodidit); 
            }
            
            $imgSplit = explode(".", $nameimagen);
            $archivo = 'imagenes';
            $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
            $config['file_name'] = $imgSplit[0];
            $config['over_write'] = "TRUE";
            $config['allowed_types'] = "gif|jpg|jpeg|png";
            $this->load->library('upload', $config);
            $this->upload->do_upload($archivo); 
                 
            redirect('acs/verAlumno/'.$this->session->userdata('iddApp'));
        }
    }

    function modificarAlumno($idauxi){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
			$resultAppName = array(
                'namePage' => 'Actualizar Alumno N°'.$idauxi
            );
			$this->session->set_userdata($resultAppName);
            
			$this->load->model('acs_model');
            $this->load->model('cliente_model');
            
            $idcurso = $this->acs_model->getCursoAlumno($idauxi);
            $this->data['listcarreras'] = $this->acs_model->getListadoCarreras(1);
            if($idcurso!=999999){
                $this->data['datoscurso'] = $this->acs_model->getDataRegistro($idcurso);
            }else{
                $i=0;            
                $datoscurso = array(
                    "idcurso" => "0",
                    "idcentro" => "0",
                    "idbin" => "0",
                    "fecha" => "0",
                    "fechaini" => "0",
                    "fechafin" => "0",
                    "idproducto" => "0",
                    "dias" => "0",
                    "horario" => "0",
                    "nameworker" => "0",
                    "namesalon" => "0",
                    "cupomax" => "0",
                    "inscritos" => "0",
                    "estatus" => "0",
                    "estado" => "0",
                    "idproducto"=> "0"
                );
                $this->data['datoscurso'] =$datoscurso;
                
            }
               
            $this->data['deptos'] = $this->cliente_model->viewDepto();
            $this->data['municip'] = $this->cliente_model->viewMunicipio();
            $this->data['informacion'] = $this->acs_model->getInformacionAuxi($idauxi);
            $this->data['infolab'] = $this->acs_model->getDatosLaborales($idauxi, 4);
            $this->data['infoadi'] = $this->acs_model->getDatosAdicionales($idauxi, 2);
            $this->load->view('acs_modificar_alumno', $this->data);
        }
    }
    
    function mantenimiento_cursos($idApp){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            
            $this->load->model('acs_model');
            $this->data['listcampus'] = $this->acs_model->getListadoCentros();
            $this->data['listcarreras'] = $this->acs_model->getListadoCarreras(1);
            $this->data['listdocumentos'] = $this->acs_model->getTiposDocumentos('VN');
            $this->data['listestatus'] = $this->acs_model->getListadoEstatus('acs_status');
            $this->load->view('acs_mantenimiento_cursos', $this->data);
        }
    }
    
    function getDatosCursos(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('acs_model');
            $dataCursos = $this->acs_model->getDataCursos();
            
            $i=0;
            $array = array();
            
            foreach($dataCursos as $dtcursos){
                $detailCostos = array();
                $dataCostos = $this->acs_model->getDataCostosCursos($dtcursos->idcurso);
                
                $j=0;
                foreach($dataCostos as $dtcostos){
                    $detailCostos[$j] = array(
                        "idrec" => $dtcostos->idrec,
                        "idcurso" => $dtcostos->idcurso,
                        "descrip" => $dtcostos->descrip,
                        "idproducto" => $dtcostos->idproducto,
                        "maxpagos" => $dtcostos->maxpagos,
                        "valortotal" => $dtcostos->valortotal,
                        "valorcuota" => $dtcostos->valorcuota,
                        "primerpago" => $dtcostos->primerpago,
                        "idclase" => $dtcostos->idclase
                    );
                    $j++;
                }
                
                $array[$i] = array(
                    "idcurso" => $dtcursos->idcurso,
                    "idcentro" => $dtcursos->idcentro,
                    "idbin" => $dtcursos->idbin,
                    "fecha" => $dtcursos->fecha,
                    "fechaini" => $dtcursos->fechaini,
                    "fechafin" => $dtcursos->fechafin,
                    "idproducto" => $dtcursos->idproducto,
                    "dias" => $dtcursos->dias,
                    "horario" => $dtcursos->horario,
                    "nameworker" => $dtcursos->nameworker,
                    "namesalon" => $dtcursos->namesalon,
                    "cupomax" => $dtcursos->cupomax,
                    "inscritos" => $dtcursos->inscritos,
                    "estatus" => $dtcursos->estatus,
                    "estado" => $dtcursos->estado,
                    "detailCost" => $detailCostos
                );
                
                $i++;
            }
            echo json_encode($array);
        }
    }
    
    function updateEstado(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $estado = $this->input->post('estado');
            $idcurso = $this->input->post('idcurso');
            $this->load->model('acs_model');
            $this->acs_model->updateEstatusCurso($estado, $idcurso);
            
            $dataCursos = $this->acs_model->getDataCursos();
            
            $i=0;
            $array = array();
            
            foreach($dataCursos as $dtcursos){
                $detailCostos = array();
                $dataCostos = $this->acs_model->getDataCostosCursos($dtcursos->idcurso);
                
                $j=0;
                foreach($dataCostos as $dtcostos){
                    $detailCostos[$j] = array(
                        "idrec" => $dtcostos->idrec,
                        "idcurso" => $dtcostos->idcurso,
                        "descrip" => $dtcostos->descrip,
                        "idproducto" => $dtcostos->idproducto,
                        "maxpagos" => $dtcostos->maxpagos,
                        "valortotal" => $dtcostos->valortotal,
                        "valorcuota" => $dtcostos->valorcuota,
                        "primerpago" => $dtcostos->primerpago,
                        "idclase" => $dtcostos->idclase
                    );
                    $j++;
                }
                
                $array[$i] = array(
                    "idcurso" => $dtcursos->idcurso,
                    "idcentro" => $dtcursos->idcentro,
                    "idbin" => $dtcursos->idbin,
                    "fecha" => $dtcursos->fecha,
                    "fechaini" => $dtcursos->fechaini,
                    "fechafin" => $dtcursos->fechafin,
                    "idproducto" => $dtcursos->idproducto,
                    "dias" => $dtcursos->dias,
                    "horario" => $dtcursos->horario,
                    "nameworker" => $dtcursos->nameworker,
                    "namesalon" => $dtcursos->namesalon,
                    "cupomax" => $dtcursos->cupomax,
                    "inscritos" => $dtcursos->inscritos,
                    "estatus" => $dtcursos->estatus,
                    "estado" => $dtcursos->estado,
                    "detailCost" => $detailCostos
                );
                
                $i++;
            }
            echo json_encode($array);
        }
    }
    
    function adicionarCursos($idcurso, $idcampus){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('acs_model');
            $this->data['listcampus'] = $this->acs_model->getListadoCentros();
            $this->data['listcarreras'] = $this->acs_model->getListadoCarreras(1);
            $this->data['listworkers'] = $this->acs_model->getListadoWorkers(3);
            $this->data['listestatus'] = $this->acs_model->getListadoEstatus('acs_status');
            $this->data['tipomatricula'] = $this->acs_model->getTiposMatricula(7);
            $this->data['listhorarios'] = $this->acs_model->getListHorarios();
            $this->data['listdias'] = $this->acs_model->getListDias();
            $array = array(
                "acs_idcurso" => $idcurso,
                "acs_idcampus" => $idcampus,
				'namePage' => 'Adicionar Curso'
            );
            $this->session->set_userdata($array);
            $this->load->view('acs_nuevo_curso', $this->data);
        }
    }
    
    function getSalonesCampus(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcentro = $this->input->post('idcentro');
            $this->load->model('acs_model');
            $array = $this->acs_model->getDataSalones($idcentro);
            echo json_encode($array);
        }
    }
    
    function getCostosMatricula(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idproducto = $this->input->post('idproducto');
            $this->load->model('acs_model');
            $dataCarrera = $this->acs_model->getDataCostoCarrera($idproducto);
            $dataCostos = $this->acs_model->getDataCostosMatricula($idproducto);
            
            $i=0;
            $array = array();
            
            foreach($dataCarrera as $datac){
                $array[$i] = array(
                    "askpwd" => "1",
                    "descrip" => $datac->descrip,
                    "uniconv" => $datac->idproducto,
                    "precioventa" => $datac->precioventa
                );
                $i++;
            }
            
            foreach($dataCostos as $dataco){
                $cont = $dataco->askpwd + 1;
                $array[$i] = array(
                    "askpwd" => $cont,
                    "descrip" => $dataco->descrip,
                    "uniconv" => $dataco->uniconv,
                    "maxpagos" => 1,
                    "precioventa" => $dataco->precioventa
                );
                $i++;
            }
            
            echo json_encode($array);
        }
    }
    
    function ingresarCurso(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcentro = $this->input->post('idcentro');
            $idbin = $this->input->post('idbin');
            $idproducto = $this->input->post('idproducto');
            $fechaIni = $this->input->post('fechaIni');
            $fechaFin = $this->input->post('fechaFin');
            $fechaGra = $this->input->post('fechaGra');
            $idworker = $this->input->post('idworker');
            $dias = $this->input->post('dias');
            $horario = $this->input->post('horario');
            $cupomax = $this->input->post('cupomax');
            $holidays = $this->input->post('holidays');
            $notas = $this->input->post('notas');
            $estatus = $this->input->post('estatus');
            
            $this->load->model('acs_model');
            $idcurso = $this->acs_model->insertNuevoCurso($idcentro,$idbin,$idproducto,$fechaIni,$fechaFin,$fechaGra,$idworker,$dias,$horario,$cupomax,$holidays,$notas,$estatus);
            
            $dataCarrera = $this->acs_model->getDataCostoCarrera($idproducto);
            $dataCostos = $this->acs_model->getDataCostosMatricula($idproducto);
            
            $i=0;
            $costos = array();
            
            foreach($dataCarrera as $datac){
                $costos[$i] = array(
                    "askpwd" => "1",
                    "descrip" => $datac->descrip,
                    "uniconv" => $datac->idproducto,
                    "maxpagos" => 12,
                    "precioventa" => $datac->precioventa,
					"frecuencia" => 1
                );
                $i++;
            }
            
            foreach($dataCostos as $dataco){
                $cont = $dataco->askpwd + 1;
				if($dataco->askpwd  < 4){
					$frecuencia = 0;
				}else{
					$frecuencia = 2;
				}
                $costos[$i] = array(
                    "askpwd" => $cont,
                    "descrip" => $dataco->descrip,
                    "uniconv" => $dataco->uniconv,
                    "maxpagos" => 1,
                    "precioventa" => $dataco->precioventa,
					"frecuencia" => $frecuencia
                );
                $i++;
            }
            
            $array = $this->acs_model->inserDetalleCosto($idcurso, $costos, $fechaIni, $fechaGra);
            echo json_encode($array);
        }
    }
    
    function modificarCurso($idcurso){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
			$namePage = array(
				'namePage' => 'Actualizar Curso N°'.$idcurso
            );
            $this->session->set_userdata($namePage);
			
            $this->load->model('acs_model');
            $this->data['listcampus'] = $this->acs_model->getListadoCentros();
            $this->data['listcarreras'] = $this->acs_model->getListadoCarreras(1);
            $this->data['listworkers'] = $this->acs_model->getListadoWorkers(3);
            $this->data['listestatus'] = $this->acs_model->getListadoEstatus('acs_status');
            $this->data['tipomatricula'] = $this->acs_model->getTiposMatricula(7);
            $this->data['listhorarios'] = $this->acs_model->getListHorarios();
            $this->data['listdias'] = $this->acs_model->getListDias();
            $this->data['datoscurso'] = $this->acs_model->getDataRegistro($idcurso);
            $this->load->view('acs_modificar_curso', $this->data);
        }
    }
    
    function actualizarInformacionCurso(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcurso = $this->input->post('idcurso');
            $idcentro = $this->input->post('idcentro');
            $idbin = $this->input->post('idbin');
            $idproducto = $this->input->post('idproducto');
            $fechaIni = $this->input->post('fechaIni');
            $fechaFin = $this->input->post('fechaFin');
            $fechaGra = $this->input->post('fechaGra');
            $idworker = $this->input->post('idworker');
            $dias = $this->input->post('dias');
            $horario = $this->input->post('horario');
            $cupomax = $this->input->post('cupomax');
            $holidays = $this->input->post('holidays');
            $notas = $this->input->post('notas');
            
            $this->load->model('acs_model');
            $array = $this->acs_model->updateInformacionCurso($idcurso,$idcentro,$idbin,$idproducto,$fechaIni,$fechaFin,$fechaGra,$idworker,$dias,$horario,$cupomax,$holidays,$notas);
            echo json_encode($array);
        }
    }
    
    function getCostosCurso(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcurso = $this->input->post('idcurso');
            $this->load->model('acs_model');
            $array = $this->acs_model->getDetailsCostoCurso($idcurso);
            echo json_encode($array);
        }
    }
    
    function actualizarCostosCurso(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idrec = $this->input->post('idrec');
            $cuotas = $this->input->post('cuotas');
            $monto = $this->input->post('monto');
            $fechamod = $this->input->post('fechamod');
            $idclase = $this->input->post('idclase');
            $this->load->model('acs_model');
            $array = $this->acs_model->updateCostosCurso($idrec, $cuotas, $monto, $fechamod, $idclase);
            echo json_encode($array);
        }
    }
    
    function inscribe($idApp){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
            
            $this->load->model('acs_model');
            $this->data['listcampus'] = $this->acs_model->getListadoCentros();
            $this->data['listcarreras'] = $this->acs_model->getListadoCarreras(1);
            $this->load->view('acs_mantenimiento_inscribe', $this->data);
        }
    }
	
	function getClientesNuevaVenta(){
		if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
			redirect('login/cerrar_sesion');
		}else{
			$idcps = $this->input->post('idcps');
			$idcentro = $this->input->post('idcentro');
			
			$this->load->model('acs_model');
			$datos = $this->acs_model->getListadoClientesCurso($idcps, $idcentro, 1);
                
			$i=0;
			$array = array();
			foreach($datos as $info){
				$array[$i] = array(
					'idauxi' => $info->idauxi,
					'descrip' => $info->descrip,
					'saldo' => $info->saldo
				);
				$i++;
			}
                
			echo json_encode($array);
		}
	}
    
    function getDataInscripcion(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('acs_model');
            $dataCursos = $this->acs_model->getDataCursosInscripcion();
            
            $i=0;
            $array = array();
            
            foreach($dataCursos as $dtcursos){
                $alumnos = array();
                $dataCtauxi = $this->acs_model->getDataAlumnosInscritos($dtcursos->idcurso);
                
                $j=0;
                foreach($dataCtauxi as $alum){
                    $alumnos[$j] = array(
                        "idauxi" => $alum->idauxi,
                        "descrip" => $alum->descrip,
                        "telefono" => $alum->telefono,
                        "correo" => $alum->correo,
                        "fechain" => $alum->fechain
                    );
                    $j++;
                }
                
                $array[$i] = array(
                    "idcurso" => $dtcursos->idcurso,
                    "idcentro" => $dtcursos->idcentro,
                    "idbin" => $dtcursos->idbin,
                    "fecha" => $dtcursos->fecha,
                    "fechaini" => $dtcursos->fechaini,
                    "fechafin" => $dtcursos->fechafin,
                    "idproducto" => $dtcursos->idproducto,
                    "dias" => $dtcursos->dias,
                    "horario" => $dtcursos->horario,
                    "nameworker" => $dtcursos->nameworker,
                    "namesalon" => $dtcursos->namesalon,
                    "cupomax" => $dtcursos->cupomax,
                    "inscritos" => $dtcursos->inscritos,
                    "estatus" => $dtcursos->estatus,
                    "estado" => $dtcursos->estado,
                    "ins_max" => $dtcursos->inscritos."/".$dtcursos->cupomax,
                    "detailAlumnos" => $alumnos
                );
                
                $i++;
            }
            echo json_encode($array);
        }
    }
    
    function nuevaInscripcion($idcurso){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
			$resultAppName = array(
                'namePage' => 'Inscribir Alumno'
            );
            $this->session->set_userdata($resultAppName);
			
            $this->load->model('acs_model');
            $this->load->model('cliente_model');
            
            $this->data['listcarreras'] = $this->acs_model->getListadoCarreras(1);
            $this->data['datoscurso'] = $this->acs_model->getDataRegistro($idcurso);
            $this->data['deptos'] = $this->cliente_model->viewDepto();
            $this->data['municip'] = $this->cliente_model->viewMunicipio();
            $this->data['listdocumentos'] = $this->acs_model->getTiposDocumentos('VN');
            $this->load->view('acs_nueva_inscripcion', $this->data);
        }
    }
    
    function modificarFicha($idauxi){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
			$resultAppName = array(
                'namePage' => 'Actualizar Alumno N°'.$idauxi
            );
            $this->session->set_userdata($resultAppName);
			
            $this->load->model('acs_model');
            $this->load->model('cliente_model');
            
            $idcurso = $this->acs_model->getCursoAlumno($idauxi);
            $this->data['listcarreras'] = $this->acs_model->getListadoCarreras(1);
            $this->data['datoscurso'] = $this->acs_model->getDataRegistro($idcurso);
            $this->data['deptos'] = $this->cliente_model->viewDepto();
            $this->data['municip'] = $this->cliente_model->viewMunicipio();
            $this->data['informacion'] = $this->acs_model->getInformacionAuxi($idauxi);
            $this->data['infolab'] = $this->acs_model->getDatosLaborales($idauxi, 4);
            $this->data['infoadi'] = $this->acs_model->getDatosAdicionales($idauxi, 2);
            $this->load->view('acs_modificar_ficha', $this->data);
        }
    }
    
    function getDataAcademica(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idauxi = $this->input->post('idauxi');

            $this->load->model('acs_model');
            $array = $this->acs_model->getDatosAcademicos($idauxi, 3);
            echo json_encode($array);
        }
    }
    
    function getDataLaboral(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idauxi = $this->input->post('idauxi');

            $this->load->model('acs_model');
            $array = $this->acs_model->getDatosLaborales($idauxi, 4);
            echo json_encode($array);
        }
    }
    
    function getDataAdicional(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idauxi = $this->input->post('idauxi');

            $this->load->model('acs_model');
            $array = $this->acs_model->getDatosAdicionales($idauxi, 2);
            echo json_encode($array);
        }
    }
    
    function getDatosCostoInscripcion(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcurso = $this->input->post('idcurso');
            $this->load->model('acs_model');
            $dataCostos = $this->acs_model->getDataCostosCursos($idcurso);
            
            echo json_encode($dataCostos);
        }
    }
    
    function inscribirAlumno(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcurso = $this->input->post('idcurso');
            $idproducto = $this->input->post('inputCarrera');
            $descrip = $this->input->post('inputDescrip');
            $telefonoFijo = $this->input->post('inputFijo');
            $telefonoMovil = $this->input->post('inputMovil');
            $email = $this->input->post('inputEmail');
            $direccion = $this->input->post('inputDireccion');
            $idzip = $this->input->post('inputDepartamento');
            $fechaIns = $this->input->post('inputFecIns');
            $fechaNac = $this->input->post('inputFecNacimiento');
            $numDui = $this->input->post('inputDui');
            $numNit = $this->input->post('inputNit');
            $horario = $this->input->post('inputHorario');
            $inputNivel = $this->input->post('inputNivel');
            $inputEstudios = $this->input->post('inputEstudios');
            $inputInstituto = $this->input->post('inputInstituto');
            $inputEmpresa = $this->input->post('inputEmpresa');
            $inputCargo = $this->input->post('inputCargo');
            $inputMeses = $this->input->post('inputMeses');
            $inputDirecEmp = $this->input->post('inputDirecEmp');
            $inputTeleEmp = $this->input->post('inputTeleEmp');
            $inputNameEmergencia = $this->input->post('inputNameEmergencia');
            $inputParentesco = $this->input->post('inputParentesco');
            $inputAdDirec = $this->input->post('inputAdDirec');
            $inputAdTelefono = $this->input->post('inputAdTelefono');
            $dataPagos = $this->input->post('dataPagos');
            
            $this->load->model('acs_model');
            $idalumno = $this->acs_model->insertNuevoAlumno($idcurso,$idproducto,$descrip,$telefonoFijo,$telefonoMovil,$email,$direccion,$idzip,$fechaIns,$fechaNac,$numDui,$numNit,$horario);
            
            if($inputNivel != "" || $inputEstudios != "" || $inputInstituto != ""){
                $this->acs_model->insertDatosAcademicos($idalumno, $inputNivel, $inputEstudios, $inputInstituto, 3);
            }
            
            if($inputEmpresa != "" || $inputCargo != "" || $inputMeses != "" || $inputDirecEmp != "" || $inputTeleEmp != ""){
                $this->acs_model->insertDatosLaborales($idalumno, $inputEmpresa, $inputCargo, $inputMeses, $inputDirecEmp, $inputTeleEmp, 4);
            }
            
            if($inputNameEmergencia != "" || $inputParentesco != "" || $inputAdDirec != "" || $inputAdTelefono != ""){
                $this->acs_model->insertDatosAdicionales($idalumno, $inputNameEmergencia, $inputParentesco, $inputAdDirec, $inputAdTelefono, 2);
            }
            
            $this->acs_model->insertDatosPagos($idalumno, $idcurso, $dataPagos);
            
            $array = $this->acs_model->updateInscritosCurso($idcurso);
            
            echo json_encode($array);
        }
    }
    
    function updateInfoAlumno(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idauxi = $this->input->post('idauxi');
            $idcurso = $this->input->post('idcurso');
            $idproducto = $this->input->post('inputCarrera');
            $descrip = $this->input->post('inputDescrip');
            $telefonoFijo = $this->input->post('inputFijo');
            $telefonoMovil = $this->input->post('inputMovil');
            $email = $this->input->post('inputEmail');
            $direccion = $this->input->post('inputDireccion');
            $idzip = $this->input->post('inputDepartamento');
            $fechaIns = $this->input->post('inputFecIns');
            $fechaNac = $this->input->post('inputFecNacimiento');
            $numDui = $this->input->post('inputDui');
            $numNit = $this->input->post('inputNit');
            $horario = $this->input->post('inputHorario');
            $inputNivel = $this->input->post('inputNivel');
            $inputEstudios = $this->input->post('inputEstudios');
            $inputInstituto = $this->input->post('inputInstituto');
            $inputEmpresa = $this->input->post('inputEmpresa');
            $inputCargo = $this->input->post('inputCargo');
            $inputMeses = $this->input->post('inputMeses');
            $inputDirecEmp = $this->input->post('inputDirecEmp');
            $inputTeleEmp = $this->input->post('inputTeleEmp');
            $inputNameEmergencia = $this->input->post('inputNameEmergencia');
            $inputParentesco = $this->input->post('inputParentesco');
            $inputAdDirec = $this->input->post('inputAdDirec');
            $inputAdTelefono = $this->input->post('inputAdTelefono');
            $inputImgUser = $this->input->post('inputImgUser');
            $idrec_acad = $this->input->post('idrec_acad');
            $idrec_lab = $this->input->post('idrec_lab');
            $idrec_adi = $this->input->post('idrec_adi');
            
            $this->load->model('acs_model');
            
            $array = $this->acs_model->updateDatosAlumno($idauxi,$descrip,$telefonoFijo,$telefonoMovil,$email,$direccion,$idzip,$fechaIns,$fechaNac,$numDui,$numNit,$inputImgUser);

            if($idrec_acad!=""){
                if($inputNivel != "" && $inputEstudios != "" && $inputInstituto != ""){
                    $array = $this->acs_model->updateDatosAcademicos($idauxi, $inputNivel, $inputEstudios, $inputInstituto, 3);
                }
            }else{
                if($inputNivel != "" && $inputEstudios != "" && $inputInstituto != ""){
                    $this->acs_model->insertDatosAcademicos($idauxi, $inputNivel, $inputEstudios, $inputInstituto, 3);
                }
            }
            
            if($idrec_lab!=""){
                if($inputEmpresa != "" && $inputCargo != "" && $inputMeses != "" && $inputDirecEmp != "" && $inputTeleEmp != ""){
                    $array = $this->acs_model->updateDatosLaborales($idauxi, $inputEmpresa, $inputCargo, $inputMeses, $inputDirecEmp, $inputTeleEmp, 4);
                }
            }else{
                if($inputEmpresa != "" && $inputCargo != "" && $inputMeses != "" && $inputDirecEmp != "" && $inputTeleEmp != ""){
                    $this->acs_model->insertDatosLaborales($idauxi, $inputEmpresa, $inputCargo, $inputMeses, $inputDirecEmp, $inputTeleEmp, 4);
                }
            }
            
            if($idrec_adi!=""){
                if($inputNameEmergencia != "" && $inputParentesco != "" && $inputAdDirec != "" && $inputAdTelefono != ""){
                    $array = $this->acs_model->updateDatosAdicionales($idauxi, $inputNameEmergencia, $inputParentesco, $inputAdDirec, $inputAdTelefono, 2);
                }
            }else{
                if($inputNameEmergencia != "" && $inputParentesco != "" && $inputAdDirec != "" && $inputAdTelefono != ""){
                    $this->acs_model->insertDatosAdicionales($idauxi, $inputNameEmergencia, $inputParentesco, $inputAdDirec, $inputAdTelefono, 2);
                }
            }
            
            echo json_encode($array);
        }
    }
	
    function removeEstudiante(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idauxi = $this->input->post('idauxi');
            $notas = $this->input->post('notas');
            
            $this->load->model('acs_model');
            
            $elimino = $this->acs_model->removeEstudiante($idauxi,$notas);

            
            $dataCursos = $this->acs_model->getDataCursosInscripcion();
            
            $i=0;
            $array = array();
            
            foreach($dataCursos as $dtcursos){
                $alumnos = array();
                $dataCtauxi = $this->acs_model->getDataAlumnosInscritos($dtcursos->idcurso);
                
                $j=0;
                foreach($dataCtauxi as $alum){
                    $alumnos[$j] = array(
                        "idauxi" => $alum->idauxi,
                        "descrip" => $alum->descrip,
                        "telefono" => $alum->telefono,
                        "correo" => $alum->correo,
                        "fechain" => $alum->fechain
                    );
                    $j++;
                }
                
                $array[$i] = array(
                    "idcurso" => $dtcursos->idcurso,
                    "idcentro" => $dtcursos->idcentro,
                    "idbin" => $dtcursos->idbin,
                    "fecha" => $dtcursos->fecha,
                    "fechaini" => $dtcursos->fechaini,
                    "fechafin" => $dtcursos->fechafin,
                    "idproducto" => $dtcursos->idproducto,
                    "dias" => $dtcursos->dias,
                    "horario" => $dtcursos->horario,
                    "nameworker" => $dtcursos->nameworker,
                    "namesalon" => $dtcursos->namesalon,
                    "cupomax" => $dtcursos->cupomax,
                    "inscritos" => $dtcursos->inscritos,
                    "estatus" => $dtcursos->estatus,
                    "estado" => $dtcursos->estado,
                    "ins_max" => $dtcursos->inscritos."/".$dtcursos->cupomax,
                    "detailAlumnos" => $alumnos
                );
                
                $i++;
            }
            echo json_encode($array);
        }
    }
	
    function detallePagos($idauxi){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('acs_model');
            
            $this->data['informacion'] = $this->acs_model->getInformacionAuxi($idauxi);
            $this->load->view('acs_detalle_pagos', $this->data);
        }
    }
	
    function recuentoCursos(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('acs_model');
            
            $actualizar = $this->acs_model->recuentoCursos();
            
            $dataCursos = $this->acs_model->getDataCursosInscripcion();
            
            $i=0;
            $array = array();
            
            foreach($dataCursos as $dtcursos){
                $alumnos = array();
                $dataCtauxi = $this->acs_model->getDataAlumnosInscritos($dtcursos->idcurso);
                
                $j=0;
                foreach($dataCtauxi as $alum){
                    $alumnos[$j] = array(
                        "idauxi" => $alum->idauxi,
                        "descrip" => $alum->descrip,
                        "telefono" => $alum->telefono,
                        "correo" => $alum->correo,
                        "fechain" => $alum->fechain
                    );
                    $j++;
                }
                
                $array[$i] = array(
                    "idcurso" => $dtcursos->idcurso,
                    "idcentro" => $dtcursos->idcentro,
                    "idbin" => $dtcursos->idbin,
                    "fecha" => $dtcursos->fecha,
                    "fechaini" => $dtcursos->fechaini,
                    "fechafin" => $dtcursos->fechafin,
                    "idproducto" => $dtcursos->idproducto,
                    "dias" => $dtcursos->dias,
                    "horario" => $dtcursos->horario,
                    "nameworker" => $dtcursos->nameworker,
                    "namesalon" => $dtcursos->namesalon,
                    "cupomax" => $dtcursos->cupomax,
                    "inscritos" => $dtcursos->inscritos,
                    "estatus" => $dtcursos->estatus,
                    "estado" => $dtcursos->estado,
                    "ins_max" => $dtcursos->inscritos."/".$dtcursos->cupomax,
                    "detailAlumnos" => $alumnos
                );
                
                $i++;
            }
            echo json_encode($array);
        }
    }
	
    function getDataPagos(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idauxi = $this->input->post('idauxi');
            $this->load->model('acs_model');
            
            $datos = $this->acs_model->getInformacionPagosAlumno($idauxi);
            $array = array();
            
            $i=0;
            foreach($datos as $info){
                if($info->barcode != null){
					$barcode = $info->barcode;
					$fechas = explode(', ', $info->notas);
					$fechaini = date(trim($fechas[1]));
					$fechafin = date(trim($fechas[2]));
					$fechaven = date(trim($fechas[0]));

					$fechaini = date_format(date_create($fechaini), 'd/m/Y');
					$fechafin = date_format(date_create($fechafin), 'd/m/Y');
					$fechaven = date_format(date_create($fechaven), 'd/m/Y');
				}else{
					$vocales = array("a", "e", "i", "o", "u", "A", "E", "I", "O", "U");
					$consona = array("b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "ñ", "p", "q", "r", "s", "t", "v", "w", "x", "y", "z");
					$consonM = array("B", "C", "D", "F", "G", "H", "J", "K", "L", "M", "N", "Ñ", "P", "Q", "R", "S", "T", "V", "W", "X", "Y", "Z", " ");
					$Texto1 = str_replace($vocales, "", $info->notas);
					$Texto2 = str_replace($consona, "", $Texto1);
					$Texto3 = str_replace($consonM, "", $Texto2);
					$barcode = str_replace("/12", "", $Texto3);
					
					$fechaini = '';
					$fechafin = '';
					$fechaven = '';
				}
                
				if($info->estatus == 1){
					$estado = 'Cancelado';
				}else if($info->estatus == 9){
					$estado = 'Anulada';
				}else if($info->estatus == 999){
					$estado = 'Pendiente';
				}else if($info->estatus == 0){
					$estado = 'En Proceso';
				}
				
                $array[$i] = array(
                    'idrec' => $info->idrec,
                    'trannum' => $info->trannum,
                    'estado' => $info->estatus,
                    'cuota' => $barcode,
                    'estatus' => $estado,
                    'descrip' => $info->descrip,
                    'fechavence' => $fechaven,
                    'fechaini' => $fechaini,
                    'fechafin' => $fechafin,
                    'valorcuota' => "$".number_format($info->precioneto, 2, '.', '')
                );
                $i++;
            }
            
            echo json_encode($array);
        }
    }
    
    function saveImagen(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            if(isset($_FILES["file_img"])){
                $file = $_FILES["file_img"];
                $idauxi = $_POST["idstudent_"];
                
                $nombre = $file["name"];
                $whodidit = $this->session->userdata('iduser');
                if($nombre != "" ){
                    $imgSplit = explode(".", $nombre);
                    $nuevonombre = "imgAlumno_".$idauxi;
                    $nombreimagn = $nuevonombre.".".$imgSplit[1];
                    $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['file_name'] = $nuevonombre;
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);
                    if($this->upload->do_upload('file_img')){ 
                        if($this->upload->data()['file_name']==""){
                            echo json_encode(true);
                        }else{
                            echo json_encode($this->upload->data()['file_name']);
                        }
                        
                    }else{
                        echo json_encode(false);
                    }
                }else{
                     echo json_encode(false);
                }
                
            }else{
                $array = false;
                echo json_encode($array);
            }
        }
    }
    
    function save_Opened(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcurso = $this->input->post('idcurso');
            $inputCarreras = $this->input->post('inputCarreras');
            $inputCampus = $this->input->post('inputCampus');
            $resultAppName = array(
                'idcurso_selected' => $idcurso,
                'acs_idcurso' => $inputCarreras,
                'acs_idcampus' => $inputCampus
            );
            $this->session->set_userdata($resultAppName);
            echo json_encode($idcurso);
        }
    }
    
    function attcontrol($idApp){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('configuracion_model');
            $this->load->model('sucursal_model');
            $this->load->model('acs_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $idcentro = $this->configuracion_model->getProCentro($idApp);
            $info_sucursal = $this->sucursal_model->callRegistro($idcentro);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName,
                'idcentro_app' =>$idcentro
            );
            $this->session->set_userdata($resultAppName);
            foreach($info_sucursal as $info){
                $name_sucursal = $info->descrip;
            }
            $this->data['name_sucursal'] = $name_sucursal;
            $this->data['id_sucursal'] = $idcentro;
            $this->data['listcarreras'] = $this->acs_model->getCarrera_Sucursal($idcentro, 3);
            $this->load->view('acs_mantenimiento_asistencias', $this->data);
        }
    }
    
    function getCursosCentroPro(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcentro = $this->input->post('idcentro');
            $product = $this->input->post('product');
            $this->load->model('acs_model');
            $dataCursos = $this->acs_model->getDataCursosAtt($idcentro,$product,3);
            echo json_encode($dataCursos);
        }
    }
    
    function getFechasAtt(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcurso = $this->input->post('idcurso');
            $this->load->model('acs_model');
            $list_fechas = $this->acs_model->getFechasAtt($idcurso,4);
            echo json_encode($list_fechas);
        }
    }
    
    function acs_attendance($idcurso, $fecha){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
			$resultAppName = array(
                'namePage' => 'Asistencia Alumnos',
            );
            $this->session->set_userdata($resultAppName);
			
            $this->load->model('acs_model');
            $this->data['idcurso'] = $idcurso;
            $this->data['fecha'] = $fecha;
            $this->data['datoscurso'] = $this->acs_model->getInfoCurso($idcurso);
            $this->load->view('acs_attendance_students', $this->data);
        }
    }
    
    function getAttStudents(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcurso = $this->input->post('idcurso');
            $fecha = $this->input->post('fecha');
            $this->load->model('acs_model');
            $data = $this->acs_model->getAttStudents($idcurso, $fecha);
            echo json_encode($data);
        }
    }
    
    function saveAttStudents(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idcurso = $this->input->post('idcurso');
            $fecha = $this->input->post('fecha');
            $estudiantes = $this->input->post('estudiantes');
            $valores = $this->input->post('valores');
            $this->load->model('acs_model');
            $data = $this->acs_model->saveAttStudents($idcurso,$fecha,$estudiantes,$valores);
            echo json_encode($data);
        }
    }
    
	function cxc($idApp){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->session->set_userdata($resultAppName);
			
            $this->load->model('global_model');
			$this->load->model('sucursal_model');
            $controlador = $this->uri->segment(1);
            $funcion = $this->uri->segment(2);
            $direccion = $controlador.'/'.$funcion;
			
			$this->data['sucursales'] = $this->sucursal_model->getDataSucursales();
            $this->load->view('acs_mantenimiento_pagos', $this->data); 
        }
    }
	
	function getAlumnosByCentro(){
		if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
			$idcentro = $this->input->post('idcentro');
			$estado = $this->input->post('estado');
			
			$this->load->model('acs_model');
			$alumnos = $this->acs_model->getListadoAlumnosCurso($idcentro, $estado);
			
            $i=0;
			$array = array();
			foreach($alumnos as $alum){
				
				$saldopendiente = 0;
				$datos = $this->acs_model->getInformacionPagosAlumnoView($alum->idauxi);
				foreach($datos as $info){
					if($info->estatus == 999){
						$saldopendiente = $saldopendiente + $info->precioneto;
					}
				}
				
				$array[$i] = array(
                    'idauxi' => $alum->idauxi,
                    'descrip' => $alum->descrip,
                    'idproducto' => $alum->idproducto,
                    'nameCurso' => $alum->nameCurso,
                    'salon' => $alum->salon,
                    'horario' => $alum->horario,
                    'saldopendiente' => $saldopendiente,
                );
                $i++;
			}
            
			echo json_encode($array);
		}
	}
	
	function getListadoAlumnosCursoCxC(){
		if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
			$idcentro = $this->input->post('idcentro');
			$estado = $this->input->post('estado');
			
			$this->load->model('acs_model');
			$alumnos = $this->acs_model->getListadoAlumnosCursoCxC($idcentro, $estado);
			
            $i=0;
			$array = array();
			foreach($alumnos as $alum){
				
				$saldopendiente = 0;
				$datos = $this->acs_model->getInformacionPagosAlumnoView($alum->idauxi);
				foreach($datos as $info){
					if($info->estatus == 999){
						$saldopendiente = $saldopendiente + $info->precioneto;
					}
				}
				
				$array[$i] = array(
                    'idauxi' => $alum->idauxi,
                    'descrip' => $alum->descrip,
                    'idproducto' => $alum->idproducto,
                    'nameCurso' => $alum->nameCurso,
                    'salon' => $alum->salon,
                    'horario' => $alum->horario,
                    'saldopendiente' => $saldopendiente,
                );
                $i++;
			}
            
			echo json_encode($array);
		}
	}
    
    function cc_control($idApp){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('configuracion_model');
            $appName = $this->configuracion_model->getAppName($idApp);
            $resultAppName = array(
                'iddApp' => $idApp,
                'appName' => $appName,
                'namePage' => $appName
            );
            $this->load->model('global_model');
            $controlador = $this->uri->segment(1);
            $funcion = $this->uri->segment(2);
            $direccion = $controlador.'/'.$funcion;
            $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
            $this->session->set_userdata($resultAppName);
            $this->load->model('acs_model');
            $this->data['listcampus'] = $this->acs_model->getListadoCentros();
            $this->load->view('acs_mantenimiento_controlcobros', $this->data); 
        }
    }
    
    function getControlCobros(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
			$idcentro = $this->input->post('sucursal');
			$fecha = $this->input->post('fecha');
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d");
            
            $array=array();
            $i=0;
            
			$this->load->model('acs_model');
			$information = $this->acs_model->getControlCobros($idcentro, $fecha);
            date_default_timezone_set('America/El_Salvador');
            
            foreach ($information as $info){
                
                
                $datetime1 = date_create($info->fechaPago);
                $datetime2 = date_create($fecha_actual);
    
                $interval = date_diff($datetime1, $datetime2);
                
                if($datetime2>$datetime1){
                    $diferencia = $interval->format("%a");
                }else{
                    $diferencia = $interval->format("%a") * -1;
                }
                 
                $array[$i] = array(
                    "studentID"=> $info->studentID,
                    "studentName"=> $info->studentName,
                    "telefono"=> $info->telefono,
                    "curso"=> $info->curso,
                    "instructor"=> $info->instructor,
                    "horario"=> $info->horario,
                    "fechaPago"=> $info->fechaPago,
                    "numCuota"=> ($info->numCuota*1),
                    "precioneto"=> $info->precioneto,
                    "dias"=> $diferencia
                );
                $i++;
            }
            echo json_encode($array);
        }
        
    }
    
    function getDocuments(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idauxi = $_POST["idauxi"];
            $this->load->model('acs_model');
            $info = $this->acs_model->getListadoMulti($idauxi);
            echo json_encode($info); 
        }
    }   
    function addDocument(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            if(isset($_FILES["addDoc"])){
                $file = $_FILES["addDoc"];
                $nombre = $file["name"];
                $nameDoc = $_POST["nameDoc"];
                $idauxi = $_POST["idauxi"];
                $whodidit = $this->session->userdata('iduser');
                $this->load->model('acs_model');
                if($nombre != ""){
                    $id = $this->acs_model->insertDoc($idauxi,5,$nameDoc);
                    $docSplit = explode(".", $nombre);
                    $nombredoc = "Doc_".$id;
                    $nombredoc_save = "Doc_".$id.".".$docSplit[1];
                    $config['upload_path'] =  "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                    $config['file_name'] = $nombredoc;
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "*";
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);
                    if($this->upload->do_upload('addDoc')){ 
                        $id_img = $this->acs_model->update_img($id,$nombredoc_save);      
                    }else{
                        $id_img = $this->acs_model->deletePromulti($id);          
                    }
                }
                $info = $this->acs_model->getListadoMulti($idauxi);
                echo json_encode($info); 
            }
        }   
    }
    
    function updateUsermulti(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idauxi = $_POST["idauxi"];
            $idrec = $_POST["idrec"];
            $descrip = $_POST["descrip"];
            $this->load->model('acs_model');
            $update = $this->acs_model->update_descrip($idrec,$descrip);
            $info = $this->acs_model->getListadoMulti($idauxi);
            echo json_encode($info); 
        }
    }
    
    function deleteUsermulti(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $idauxi = $_POST["idauxi"];
            $idrec = $_POST["idrec"];
            $this->load->model('acs_model');
            $del = $this->acs_model->deletePromulti($idrec);  
            $info = $this->acs_model->getListadoMulti($idauxi);
            echo json_encode($info); 
        }
    }
    
}
?>