<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller {

        function __construct(){
			if (session_status() == PHP_SESSION_NONE) {
                session_start();
            }
            parent::__construct();
            //$this->load->model('pdfs_model');
        }
		
        public function detect(){
            $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
            $os=array("WIN","MAC","LINUX");
            
            # definimos unos valores por defecto para el navegador y el sistema operativo
            $info['browser'] = "OTHER";
            $info['os'] = "OTHER";
            
            # buscamos el navegador con su sistema operativo
            foreach($browser as $parent){
                $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                $f = $s + strlen($parent);
                $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                $version = preg_replace('/[^0-9,.]/','',$version);
                
                if($s){
                    $info['browser'] = $parent;
                    $info['version'] = $version;
                }
            }
    
            # obtenemos el sistema operativo
            foreach($os as $val){
                if(strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
                    $info['os'] = $val;
            }
 
            # devolvemos el array de valores
            return $info;
        }
		
        function factura_pdf_nuevo($numero){
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(3, 5, 8);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 
            // Añadir una página
            // Este método tiene varias opciones, consulta la documentación para más información.
            // set auto page breaks
            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            //$pdf->SetAutoPageBreak(TRUE, 1);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );

            $this->load->model('mantenimiento_model');
            $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

            if(is_array($products) && $products!=false){
                $sucursal = strtoupper($products['descrip']);
                $pedido = $products['numero'];
                $cli_name = $products['cli_name'];
                $cli_phone = $products['cli_phone'];
                $date = date_format(date_create($products['date']),'d/m/Y');
                $dev_date2 = ucwords($products['dev_date2']);
                $dev_time = date("g:i a", strtotime($products['dev_time']));
                $tfecha = ucwords($products['tfecha']);
                $val_venta = $products['val_venta'];
                $val_anti = $products['val_anti'];
                $val_refund = $products['val_refund'];
                $tpastel = $products['val_pastel'];
                $taccesorios = $products['val_acc'];
                $tbases = $products['val_bases'];
                $tenvio = $products['val_envio'];

                $cli_email = $products['cli_email'];
                $dev_place = $products['dev_place'];
                $notas_obser = $products['notas'];
                $dev_notes = $products['dev_notes'];

                $imagen = $products['pastel_fotos'];
                $catreference = $products['catreference'];
                $dedicamsg = $products['dedicamsg'];
                
                $dev_contact = $products['dev_contact'];
                $dev_phone = $products['dev_phone'];

                $lugar = "";
                $tlugar = "";
                if($dev_place==1){
                    $lugar = $products['dev_direc'];
                    $tlugar = $products['dev_direc'];
                }elseif($dev_place==2){
                    $lugar = $products['dev_direc'];
                    $tlugar = "DOMICILIO";
                }elseif ($dev_place==3) {
                    $lugar = "Recoger en Producción";
                }

                $cktortas = $products['ck_tortas'];
                $ckslices = $products['porciones'];

                $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                $tamano = strlen($pedido);
                $codbar = "";
                
                if($tamano==1){
                    $codbar = "00000".$pedido;
                }elseif($tamano==2){
                    $codbar = "0000".$pedido;
                }elseif($tamano==3){
                    $codbar = "000".$pedido;
                }elseif($tamano==4){
                    $codbar = "00".$pedido;
                }elseif($tamano==5){
                    $codbar = "0".$pedido;
                }elseif($tamano==6){
                    $codbar = $pedido;
                }
            }else{
                redirect('pedidos_clientes/pasteles_al_gusto/');
            }

            /*$img = file_get_contents('http://example.com/wp-content/themes/example/map_image_leasing.php/?city=Calgary&suit_type=&min_area=&max_area=');
                $pdf->Image('@' . $img, 55, 19, '', '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);*/

            /*
            // define barcode style
            $style = array(
                'position' => '',
                'align' => 'C',
                'stretch' => false,
                'fitwidth' => true,
                'cellfitalign' => '',
                'border' => true,
                'hpadding' => 'auto',
                'vpadding' => 'auto',
                'fgcolor' => array(0,0,0),
                'bgcolor' => false, //array(255,255,255),
                'text' => true,
                'font' => 'helvetica',
                'fontsize' => 8,
                'stretchtext' => 4
            );
            $pdf->write1DBarcode('RIGHT', 'C128A', '', '', '', 15, 0.4, $style, 'N');*/
			
			if($catreference != ""){
				$fotoCatalogo = $this->mantenimiento_model->getNameImagenPastelCatalogo($catreference);
			}
			
            $estructura = '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                <td></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                            </tr>
                            <tr>
                                <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                            </tr>
                          </table>';


            $estructura .= '<br><br><table style="width:100%;">
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';
							
			if(isset($fotoCatalogo) and $fotoCatalogo!=""){
				$estructura .= '<img style="min-width: 25%; max-height: 300px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$fotoCatalogo.'">';
			}

                                
            $estructura .='     </td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';

            if($arrayPasteles!=false){
                $i=1;
                $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                        <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                    </tr>';
                foreach($arrayPasteles as $key => $value){
                    $estructura .= '
                            <tr>
                                <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                            </tr>
                            <tr>
                                <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                            </tr>';
                    $i++;
                }
                $estructura .= '</table>';
            }

            if($arrayAccesorios!=false){
                $i=0;
                $i = count($arrayAccesorios);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                    $i = count($arrayAccesorios);
                    foreach($arrayAccesorios as $key => $value){
                            
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';
            }  

            if($arrayBases!=false){
                $i=0;
                $i = count($arrayBases);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayBases) and $arrayBases!=false){
                    $i = count($arrayBases);
                    foreach($arrayBases as $key => $value){
                        
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';

            }    

            $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


            $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:  25px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                            </tr>
                        </table>';
			
			$estructura .= '<table style="width:100%; border-collapse: separate;">';
			
			$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($numero, 1);
			
			$trcreado = 0;
			if($datosimagen != false){
				$trcreado = 1;
				$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;"><img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">'.$datosimagen['notas'].'</td>';	
			}
			
			$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($numero, 2);
			
			if($datosimagen != false){
				if($trcreado == 0){
					$trcreado = 1;
					$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';	
				}else{
					$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';
				}
			}
			
			$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($numero, 3);
			
			if($datosimagen != false){
				if($trcreado == 0){
					$trcreado = 1;
					$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';	
				}else{
					$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';
				}
			}
			
			$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($numero, 4);
			
			if($datosimagen != false){
				if($trcreado == 0){
					$trcreado = 1;
					$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';	
				}else{
					$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';
				}	
			}
			if($trcreado == 1){
            	$estructura .= '</tr></table>';
			}else{
            	$estructura .= '</table>';
			}

            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }  
        
        function ordenventa($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden De Venta');
                $pdf->SetSubject('Orden De Venta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
				$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetAutoPageBreak(FALSE,PDF_MARGIN_TOP, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->setPrintHeader(false);
				
                $pdf->addPage('P', 'LETTER');
				
				$this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $this->load->model('pedclientes_model');
                
                $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $formapago = $this->ventas_model->getFormaDePagoTrannum($trannum);
                $name = $this->pedclientes_model->getnameImg();
                
                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
					$idcaja = $info->idcaja;
                    $tipocliente = $info->idtipo;
                }
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				if($formapago == ''){
					$formapago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);
				}
				
                $estructura = '
					<table style="width:100%; padding-top:0px;">
						<tr>
                    <td style="width:30%;"><img style="height:80px;"></td>
                            <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:45%;"><strong>TECNOVIDRI, S.A. DE C.V.<br>4° Calle Pte. y 25 Avenida Sur, Condominio Cuscatlan<br> 1 Planta San Salvador, San Salvador<br>PBX:2271-6099</strong></td>
                            <td style="text-align:center; border: 1px solid black; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;" ><br><br><br><strong>COTIZACION</strong><br>N°<br><strong style="font-size:14px;">'.$trannum.'</strong></td>
                        </tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
						</tr>
					</table>';
					$estructura .= '
						<table style="width:100%; border:1px solid black;">
							<tr>
								<td style="border-right:1px solid black; text-align:right; vertical-align:middle; font-weight:normal; font-size:5px; width:75%;"><br></td>
								<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:5px; width:25%;"><br></td>
							</tr>
							<tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;"></td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;"></td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Fecha:</strong> '.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>
							</tr>
                            <tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Nombre del Cliente:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["idcps"].' - '.$dataPedido["clientename"].'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nrc:</strong>'.$dataPedido["NRC"].'</td>
                                
							</tr>
                              <tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Direccion:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["direccion"].'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nit:</strong>'.$dataPedido["NIT"].'</td>
							</tr>
                            <tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Tipo Documento:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["tipodoc"].'</td>
							</tr> 
                            <tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Forma de Pago:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["formaPago"].'</td>
							</tr>
                             <tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan="2">Nota: </td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["notas"].'</td>
							</tr>
						</table>';
				
				$estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="background-color:#FFFF00; color:#000000; border:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"><strong>LINEA</strong></td>
						<td style="background-color:#FFFF00; color:#000000; border:1px solid #000000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;"><strong>CODIGO</strong></td>
						<td style="background-color:#FFFF00; color:#000000; border:1px solid #000000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;"><strong>DESCRIPCION DEL PRODUCTO</strong></td>
                        <td style="background-color:#FFFF00; color:#000000; border:1px solid #000000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>CANTIDAD</strong></td>
						<td style="background-color:#FFFF00; color:#000000; border:1px solid #000000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>PRECIO DE VENTA</strong></td>
						<td style="background-color:#FFFF00; color:#000000; border:1px solid #000000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>SUB TOTAL</strong></td>
					</tr>';
				
				$productos = $this->pedclientes_model->getDataProduct($trannum);
				
				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0;
                $m = 0; $i = 0; $d = 0;
				
				foreach($productos as $pro){
					if($pro->tipotax != 0 && $invexento == 0){
						$total = $total + number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$totalGravado = $totalGravado + number_format(round((($pro->precioneto * abs($pro->cantidad))/(1+($pro->tipotax / 100))),2), 2 ,'.','');
                        
						$vnExenta = "";
						$vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
					}else if($pro->tipotax != 0 && $invexento == 1){
						$total = $total + (($pro->precioneto * abs($pro->cantidad)));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax== 0 && $invexento == 0){
						$total = $total + (($pro->precioneto) * abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax == 0 && $invexento == 1){
						$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}
						
					$preciouni = $pro->precioneto;
                    $precioOrg = $pro->precioventa;
					$nombrepro = substr($pro->descrip, 0, 25);
                    
                    $descuento= (((number_format($preciouni, 2 ,'.','')-number_format($precioOrg, 2 ,'.',''))/$precioOrg)*100);
                    
                        $estructura .= '
                        <tr>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;">'.$pro->itemline.'</td>
							<td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;">'.$pro->modelo.'</td>
							<td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">'.$nombrepro.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.abs($pro->cantidad).'</td>
							<td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.number_format($preciouni, 2 ,'.','').'</td>
							<td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$vnExenta.''.$vnGravada.'</td>
						</tr>';
                    $m = $m + 1;
                    
                    if($descuento>0){
                        $estructura .= '
                        <tr>
							<td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"></td>
							<td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;"></td>
							<td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">Descuento</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$descuento.'</td>
							<td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
							<td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
						</tr>';
                    $d = $d + 1;
                    }
                    
				}
				 $lineasproduct = ($m + $d);
                 for($i = $lineasproduct; $i <= 36; $i++){
                    $estructura .= '
                        <tr>
                            <td style="font-size:11px; width:100%;"></td>
                        </tr>';
                }
				$estructura .= '</table>';
                
                 if(($dataPedido["idtipo"]==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                }else{
                    $retencion = 0;
                }
                    
                if($retencion == 0){
                    $retencion = "";
                }else{
                    $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                }
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
                
                $totalIVA = number_format(round(($totalGravado * ($pro->tipotax/100)), 2), 2 ,'.',''); 
 
                
				$estructura .=  '
                	<table style="padding:0px; margin:0px;">
                    	<tr style="padding:0px; margin:0px; background-color:#FFFF00;">
							<th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:100%"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                        </tr>
                        
                        <tr style="padding:0px; margin:0px; background-color:#FFFF00;">
							<th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>SUB-TOTAL</strong></th>
                            <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>IVA</strong></th>
                            <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>RETENCIÓN</strong></th>
                            <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                        </tr>
                        
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalGravado.'</strong></th>
                            <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalIVA.'</strong></th>
                            <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>'.$retencion.'</strong></th>
                            <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                        </tr>
                        <br>
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; text-align:left; width:100%"><strong>**VALIDEZ DE LA OFERTA 8 DIAS DESPUES DE SU EMISION PRECIOS Y EXISTENCIAS SUJETOS A PREVIA VENTA<br>**PRECIOS INCLUYEN IVA</strong></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; text-align:left; width:40%">Nota:</th>
                        </tr> 
                        
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; text-align:left; width:100%; border: 1px solid black"><br><br><br></th>
                        </tr> 
                        
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; text-align:center; width:30%">'.$info->idvendedor.' - '.$info->nameVendedor.'</th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; text-align:center; width:30%"></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; text-align:center; width:30%"></th>
                        </tr>        
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Atendido por</strong></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%">Autorizado por</th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%">Aceptado Cliente</th>
                        </tr>
                        
                    </table>';
                $pdf->setPrintFooter(false);
				
				$pdf->writeHTML($estructura, true, false, true, false, '');
            	$nombre_archivo = utf8_decode("OrdenDeVenta$trannum.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}
        
        function ordenventa1($trannum){
            $this->db->query('SET SQL_BIG_SELECTS=1'); 
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);
            set_time_limit(0);
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);      
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Cotización');
            $pdf->SetSubject('Cotización');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->SetAutoPageBreak(TRUE,10);
            $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, 5 );
            $pdf->SetHeaderMargin(0,0,0,0);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT, 50);
            $this->load->model('pedclientes_model');
            $this->load->model("global_model");
            $this->load->model("ventas_model");
            $this->load->model('producto_model');
            $this->load->model('fabrica_model');
            $this->load->model('compras_model');
            $function = $this->uri->segment(3);
            $nombre_doc="";
            $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
            $list_producto = $this->pedclientes_model->getDataProduct($trannum);
            $name = $this->pedclientes_model->getnameImg();
            $fecha = new DateTime();

            $footer =  '<br><br><br><br><br><br>
            <table style="padding:0px; margin:0px;">
                <tbody style="padding:0px; margin:0px;">
                    <tr style="padding:0px; margin:0px;">
                        <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                        <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                        <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                    </tr>
                </tbody>
                </table>';

            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);
            
            $header = '<table style="width:100%;">
                <tr>
                    <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                    <td style="width:70%;font-size:22px; text-align:right;"><br><br>COTIZACIÓN</td>
                </tr></table>';
            $header .= '<table style="width:100%;">
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Cliente&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["clientename"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">N°&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$trannum.'</td>
                </tr>
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Vendedor&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["workername"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>

                </tr>
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Lugar de Entrega&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["lugar_entrega"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha de Entrega&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["dev_date"]),'d/m/Y').'</td>
                </tr>
                
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Tipo de Documento&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:35%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["tipodoc"].'</td>
                    <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Forma de Pago&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:30%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["formaPago"].'</td>
                </tr>
            </table>';

            $pdf->setHtmlHeader($header);
            $pdf->setPrintFooter(true);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Portrait');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            $pdf->addPage('P', 'LETTER');
            $estructura ='';
            $tabla_presentacion = '<table style="width:100%;border: 0.3px solid #6E6E6E;padding:10px;">';
            $encabezado = $this->ventas_model->getAnexosHijos($trannum);
            if($encabezado!=false){
                foreach($encabezado as $enc){
                    $tabla_presentacion .= '<tr>
                        <td style="width:100%;padding:10px;">'.$enc->notas.'</td>
                    </tr>';
                }
                $tabla_presentacion.='</table>';
                $estructura.= $tabla_presentacion;
            }
            
            
            $estructura .='<br><br><table><tr>
                                    <th style="font-size:12px; font-weight:bold; text-align:left; width:85%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">&nbsp;&nbsp;Nombre del producto</th>
                                    <th style="font-size:12px; font-weight:bold; text-align:center; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Precio</th>
                                </tr>';
            if($list_producto!=false){
                foreach($list_producto as $pro){
                    $estructura .='<tr>
                        <td style="font-size:12px; text-align:left; width:85%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$pro->descrip.'</td>
                        <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E;">$'.number_format(round($pro->precioneto, 2),2).'&nbsp;&nbsp;</td>
                        </tr>';
                }
            }
            
            $estructura .='</table>';

            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }    
        
        function ordenes_pdf($fecha, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 5, 8);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);

            
                if($fecha=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $this->load->model('mantenimiento_model');

                $pedidos = $this->mantenimiento_model->get_id_ordenes(1,$fecha,$estado);
                $estructura = '';
        
                foreach ($pedidos as $key => $value){

                    $pdf->addPage('P', 'LETTER');
                    $products = $this->mantenimiento_model->getDataCake_for_ticket($value['numero']);

                    if(is_array($products) && $products!=false){
               
                        $sucursal = strtoupper($products['descrip']);
                        $pedido = $products['numero'];
                        $cli_name = $products['cli_name'];
                        $cli_phone = $products['cli_phone'];
                        $date = date_format(date_create($products['date']),'d/m/Y');
                        $dev_date2 = ucwords($products['dev_date2']);
                        $dev_time = date("g:i a", strtotime($products['dev_time']));
                        $tfecha = ucwords($products['tfecha']);
                        $val_venta = $products['val_venta'];
                        $val_anti = $products['val_anti'];
                        $val_refund = $products['val_refund'];
                        $tpastel = $products['val_pastel'];
                        $taccesorios = $products['val_acc'];
                        $tbases = $products['val_bases'];
                        $tenvio = $products['val_envio'];

                        $cli_email = $products['cli_email'];
                        $dev_place = $products['dev_place'];
                        $notas_obser = $products['notas'];
                        $dev_notes = $products['dev_notes'];

                        $imagen = $products['pastel_fotos'];
                        $catreference = $products['catreference'];
                        $dedicamsg = $products['dedicamsg'];

                        $dev_contact = $products['dev_contact'];
                        $dev_phone = $products['dev_phone'];

                        $lugar = "";
                        $tlugar = "";
                        
                        if($dev_place==1){
                            $lugar = $products['dev_direc'];
                            $tlugar = $products['dev_direc'];
                        }elseif($dev_place==2){
                            $lugar = $products['dev_direc'];
                            $tlugar = "DOMICILIO";
                        }elseif ($dev_place==3){
                            $lugar = "Recoger en Producción";
                        }

                        $cktortas = $products['ck_tortas'];
                        $ckslices = $products['porciones'];
                        
                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value['numero'],1);
                        $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],2);
                        $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],3);

                        $tamano= strlen($pedido);
                        $codbar = "";
                        
                        if($tamano==1){
                            $codbar = "00000".$pedido;
                        }elseif($tamano==2){
                            $codbar = "0000".$pedido;
                        }elseif($tamano==3){
                            $codbar = "000".$pedido;
                        }elseif($tamano==4){
                            $codbar = "00".$pedido;
                        }elseif($tamano==5){
                            $codbar = "0".$pedido;
                        }elseif($tamano==6){
                            $codbar = $pedido;
                        }

                    }else{
                        redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                    }
					
					if($catreference != ""){
						$fotoCatalogo = $this->mantenimiento_model->getNameImagenPastelCatalogo($catreference);
					}
					
                    $estructura = '<table style="width:100%;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                        <td></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                        <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                                    </tr>
                                 </table>';



                    $estructura .= '<br><br><table style="width:100%;">
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                    if(isset($fotoCatalogo) and $fotoCatalogo!=""){
						$estructura .= '<img style="min-width: 25%; max-height: 300px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$fotoCatalogo.'">';
					}
					
					$estructura .='</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                        <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                                    </tr>
                               </table>';

                    if($arrayPasteles!=false){
                        $i=1;
                        $estructura .= '<br><br><table style="width:100%;">
                                            <tr>
                                                <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                                <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                            </tr>';
                        foreach($arrayPasteles as $key => $value){
                            $estructura .= '
                                    <tr>
                                        <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                                    </tr>';
                            $i++;
                        }
                        $estructura .= '</table>';
                    }

                    if($accesorios!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                            <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';

                        $i = 1;

                        foreach ($accesorios as $key => $value){
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    if($bases!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:15%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases</td>
                                            <td colspan="6" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:85%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';
                        $i = 1;

                        foreach ($bases as $key => $value) {
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:  25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.</td>
                                </tr>
                            </table>';
					
					$estructura .= '<table style="width:100%; border-collapse: separate;">';
			
					$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 1);

					$trcreado = 0;
					if($datosimagen != false){
						$trcreado = 1;
						$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;"><img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">'.$datosimagen['notas'].'</td>';	
					}

					$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 2);

					if($datosimagen != false){
						if($trcreado == 0){
							$trcreado = 1;
							$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';	
						}else{
							$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';
						}
					}

					$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 3);

					if($datosimagen != false){
						if($trcreado == 0){
							$trcreado = 1;
							$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';	
						}else{
							$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';
						}
					}

					$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 4);

					if($datosimagen != false){
						if($trcreado == 0){
							$trcreado = 1;
							$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';	
						}else{
							$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';
						}	
					}
					if($trcreado == 1){
						$estructura .= '</tr></table>';
					}else{
						$estructura .= '</table>';
					}
					
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                }
                
                $nombre_archivo = utf8_decode("ticket_todos.pdf");
                $pdf->Output($nombre_archivo, 'I');
        
            }

        }
        
        function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                    </tr>
                                </table></center>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_emision.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:20%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="4" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteRecepcion($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('RECEPCION DE TRASLADOS');
                $pdf->SetSubject('RECEPCION DE TRASLADOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                    </tr>
                                </table></center>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_cierre.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="font-size:12px;  text-align:left; font-weight: bold;" width="100%">REFERENCIA: '.$data->tranref.'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="5" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Recepcion_Traslado_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteComprasLocales($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('COMPRAS LOCALES');
                $pdf->SetSubject('COMPRAS LOCALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                
              
                
                
                 $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>RECIBIDA</strong></label></td>
                                    </tr>
                                </table></center><br><br>';
                
                foreach($informacion as $inf){
                
                $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$idrec.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha Ingreso: '.date_format(date_create($inf->fecha), 'd/m/Y').' </strong></th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Referencia Interna:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->descrip.'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->referencia.'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Numero de Documento:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Solicitado Por:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->serie.''.$inf->numero.'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->solicita.'</td>
                                    </tr>
                                    
                                </tbody>
                    </table><br><br>
                     ';
                    
                
               }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                 $pdf->addPage( 'P', 'LETTER' );
                
                
                
                $titulo='
                  
                <table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:37%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                                      </tr>
                                </thead>
                    <tbody>';
                
                foreach($productos as $pro){
                    
                   
                    $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
                                <td style="width:37%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>
                                <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->preciotran.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">$'.($pro->cantidad * $pro->preciotran ).'</td></tr>';
                           
                    
                }
                
                 $titulo.='
                    </tbody>
                    </table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                
                $nombre_archivo = utf8_decode("Detalle_ComprasLocales_".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            
            }
        }
        
        function reporteSalida($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Compra Local');
                $pdf->SetSubject('Compra Local');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                $this->load->model('pedclientes_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                $name = $this->pedclientes_model->getnameImg();
                
                $fecha = new DateTime();
                $footer =  '<br><br>
                    <table style="padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%; border-bottom: 1px solid black;"></th>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%; border-bottom: 1px solid black;"></th>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%; border-bottom: 1px solid black;"></th>
                            <th style="font-size:10px; text-align:left; width:5%"></th>
                            </tr>
                            
                            <tr>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%;">Verificado por</th>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%;">Autorizado por</th>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%;">Elaborado por</th>
                            <th style="font-size:10px; text-align:left; width:5%"></th>
                            </tr>
                            
                            <tr>
                            <th style="font-size:10px; text-align:left; width:100%"></th>
                            </tr>
                            
                            <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                        </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);

                 $header = '<table style="width:100%; text-align:center;">
                                    <tr><td colspan="3" style="font-size:5px;"><br></td></tr>
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">SALIDA POR ENVIO</td>
                                    </tr>
                                </table>';
                
                foreach($informacion as $inf){
                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#FFFF00; width:50%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;No.</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$idrec.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->descrip.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Referencia: </td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->referencia.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Solicitado por: </td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Número de Documento:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->serie.''.$inf->numero.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->solicita.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Fecha:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.date_format(date_create($inf->fecha), 'd/m/Y').'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr><td style="font-size:10px;"><br></td></tr>
                                </table>';
                }
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='
                <table>
                    <thead>
                        <tr><td style="font-size:10px;"></td></tr>
                        <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px; background-color:#3cd5e5;">
                            <th style="background-color:#FFFF00; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                            <th style="background-color:#FFFF00; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:46%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                            <th style="background-color:#FFFF00; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                            <th style="background-color:#FFFF00; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                            <th style="background-color:#FFFF00; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:22%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Marca</th>
                            <th style="background-color:#FFFF00; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">UM</th>
                        </tr>
                    </thead>
                <tbody>';
                $sum_lines = 0;
                $sum_cant = 0;
                $sum_subtotal = 0;
                foreach($productos as $pro){
                    $sum_lines++;
                    $sum_cant+= $pro->cantidad;
                    $sum_subtotal+=($pro->cantidad * $pro->preciotran);
                    $titulo.='<tr style="border: 1px solidblack;">
                    <td style="width:5%; border-left: 1px solid #6E6E6E; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
                    <td style="width:46%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                    <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->modelo.'</td>
                    <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
                    <td style="width:22%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->marca.'</td>
                    <td style="width:10%; border-right: 1px solid #6E6E6E;text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'&nbsp;&nbsp;</td></tr>';
                }
                
                 
                
                $titulo.='<tr> <td style="border-top: 1px solid #6E6E6E;" colspan="8"><br></td></tr>';
                
                $titulo.='<tr style="border: 1px solidblack;">
                    <td style="width:5%; border-left: 1px solid #6E6E6E; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$sum_lines.'</strong></td>
                    <td colspan="4" style="border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;width:56%;  vertical-align:middle; padding:0px; font-size:10px;"><strong> </strong></td>
                    <td style="width:8%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.round($sum_cant, 0).'</strong></td>
                    <td style="width:10%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"></td>
                    <td style="width:22%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"><strong>&nbsp;&nbsp;</strong></td></tr>';
               
                $titulo.='</tbody>
                </table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Detalle_Compra".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function cuadre_vendedor($idvendedor, $fechai, $fechaf){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cuadre por vendedor');
                $pdf->SetSubject('Cuadre por vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
               // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                /*
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                */
                
                
                
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fechai = str_replace("-", "/", $fechai);
                $fechaf = str_replace("-", "/", $fechaf);
                $fecha1 = new Datetime($fechai);
                $fecha2 = new Datetime($fechaf);
                $this->load->model('ventas_model');
                $this->load->model('empleado_model');
                $docs = $this->ventas_model->tipos_doc($idvendedor, $fechai, $fechaf);
                $ventas = $this->ventas_model->ventas_diarias($idvendedor, $fechai, $fechaf);
                $abonos = $this->ventas_model->abonos_diarios($idvendedor, $fechai, $fechaf);
                $empleado = $this->empleado_model->viewEmple();
                $name="";
                foreach($empleado as $em){
                    if($em->idauxi==$idvendedor){
                        $name = $em->descrip;
                    }
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$name.'( Del '.$fecha1->format('d/m/Y').' al '.$fecha2->format('d/m/Y').')</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
               
                $titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 15%">N° de Factura</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Referencia</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 40%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:right;  font-weight: bold; width: 15%">Valor</th>
                        </tr>
                        <tr>
                        <th colspan="5"><br></th>
                        </tr>
                    </thead>
                <tbody>';
                
                $subtotal=0;
                $total=0;
                foreach($docs as $docs){
                    $subtotal=0;
                    $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;"><br>'.$docs->tipoDoc.'</th></tr>';
                    foreach($ventas as $ven){
                         if($docs->tipoDoc==$ven->tipoDoc){
                             $subtotal= $subtotal+$ven->saldo;
                             $date = date_format(date_create($ven->fecha),'d/m/Y');
                             $titulo .= '
                                 <tr>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$ven->numero.'</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">-</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$date.'</td>
                                    <td style="font-size:10px; text-align:left;  font-weight: normal; width: 40%">'.$ven->cliente.'</td>
                                    <td style="font-size:10px; text-align:right;  font-weight: normal; width: 15%">$'.number_format(round($ven->saldo, 2),2).'</td>
                                </tr>';
                         }
                    }              
                    $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';

                    $total =$total+$subtotal;
                    
                }
                $titulo .= '<tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;">ABONOS</th></tr>';
                $subtotal=0;
                foreach($abonos as $abo){
                    $date = date_format(date_create($abo->fecha),'d/m/Y');
                    $subtotal= $subtotal+$abo->saldo;
                    $titulo .= '
                        <tr>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->numero.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->referencia.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$date.'</td>
                            <td style="font-size:10px; text-align:left; font-weight: normal; width: 40%">'.$abo->cliente.'</td>
                            <td style="font-size:10px; text-align:right; font-weight: normal; width: 15%">$'.number_format(round($abo->saldo, 2),2).'</td>
                        </tr>';
                }
                $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';
                $total =$total+$subtotal;
                $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th  colspan="4"></th><th style="font-size:12px; text-align:right;  border-top: 1px solid black;  font-weight: bold;">Total: $'.number_format(round($total, 2),2).'</th></tr>';

                $titulo .= '</tbody></table>';
               
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Cuadre_Vendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function orden_print($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                //---------------------------------------------------------
                //establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);

                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );

                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                $nit_pro = $det['pro_nit'];
                $nrc_pro = $det['pro_nrc'];
                $val_pro = $det['val_pro'];
                if($nit_pro==""){
                    $nit_pro="N/A";
                }
                if($nrc_pro==""){
                    $nrc_pro="N/A";
                }
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        
                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado >= 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                
                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; fwidth:60%;">'.$direccion.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>';
                
                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }
                
                 

                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:8%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                        <td style="font-size:12px; text-align:center; width:12%; font-weight: bold;">Código</td>
                                        <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:12px; text-align:center; width:10%; font-weight: bold;">UM</td>
                                        <td style="font-size:12px; text-align:left; width:20%; font-weight: bold;">Notas</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:8%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:center; width:12%;">'.round($key->idproducto).'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.$key->um_orden.'</td>
                                                            <td style="font-size:9px; text-align:left; width:20%;">'.$key->notas.'</td>
                                                            <td style="font-size:9px; text-align:right; width:10%;">$'.number_format($key->precioneto, 6, '.', ',').'</td>
                                                            <td style="font-size:9px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 6, '.', ',').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:9px; text-align:left; width:70%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 2, '.', ',').'</td>
                                    </tr>';
                
                    if($provee_tipo!=3){
						if($gravado >= 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">- $'.number_format($percepcion, 2, '.', ',').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($val_pro, 2, '.', ',').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($val_pro, 2, '.', ',').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($val_pro, 2, '.', ',').'</td>
                                    </tr>';
                    }
                    
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Observaciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_orden.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr><tr>
                                        <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_cond.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>
                                    
                                </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        }
        
        function send_email($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $correo_pro = $det['pro_correo'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                if($correo_pro==""){
                    $correo_pro="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        
                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
                }
                
                $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
                $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
                                        <table style="padding:0px;margin:0px;">
                                            <tr><td style="font-size:15px;"></td></tr>
                                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:10px; text-align:left; font-weight: bold; ">'.$razon.'</td></tr>
                                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:10px; text-align:left;">'.$direccion.'</td></tr>
                                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:10px; text-align:left;"><b>NIT:</b>'.$nit.' / <b>NRC:</b>'.$nrc.'</td></tr>
                                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:10px; text-align:left; "><b>GIRO:</b>'.$giro.'</td></tr>
                                        </table></td>
                                        <td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td style="padding:0px;margin:0px;width:33.3%;">
                                        <table style="padding:0px;margin:0px;">
                                            <tr><td style="font-size:15px;"></td></tr>
                                            <tr><td style="font-size:25px; text-align:center;width:100%;">ORDEN DE COMPRA</td></tr>    
                                        </table></td>
                                        
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"></td>
                                        <td style="font-size:10px; text-align:center; background-color:#FF9900; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left;font-weight: bold;  width:60%;"> '.$proveedor.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; fwidth:60%;"> '.$direccion.'</td>  
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"> '.$muni_dep.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>';
                
                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"> Tel.: '.$tel_pro.' / Correo: '.$correo_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"></td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';
                }
                
                 

                 $estructura .= '<br><br><table style="width:100%;" class="fondo">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Detalles de entrega</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;" class="fondo">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:10px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:10px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:10px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;" class="fondo">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;" class="fondo" style="border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:11px; text-align:center; width:10%; font-weight: bold;">Cant.</td>
                                        <td style="font-size:11px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:11px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                        <td style="font-size:11px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:11px; text-align:right; width:10%; font-weight: bold;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '</table>
                                    <table style="width:100%;" style="border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Total Exento</td>
                                        <td style="font-size:10px; text-align:right; width:20%;">$'.number_format($exento, 2, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Total Gravado</td>
                                        <td style="font-size:10px; text-align:right; width:20%;">$'.number_format($gravado, 2, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">IVA</td>
                                        <td style="font-size:10px; text-align:right; width:20%;">$'.number_format($iva, 2, '.', '').'</td>
                                    </tr>';
                
                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Retención 1%</td>
											<td style="font-size:10px; text-align:right; width:20%; border-right: 1px solid #6E6E6E;">- $'.number_format($percepcion, 2, '.', '').'</td>
										</tr>
										<tr>
											<td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Total</td>
											<td style="font-size:10px; text-align:right; width:20%; border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:20%;border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:20%; border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
                    }
                
                
                    
                    $estructura .= '</table>
                                    <table style="width:100%;" >
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" rowspan="5">'.$notas_cond.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>
                                    
                                </table>';
                echo json_encode($estructura);
            }
        }
        
        function send_email2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $correo_pro = $det['pro_correo'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                if($correo_pro==""){
                    $correo_pro="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        
                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
                }
                
                $estructura ='
                <style>
                .fondo{
                    background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                }
                </style>';
                
                $estructura .= '<br><br><table style="width:100%;">
                <tr>
                    <td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
                        <table style="padding:0px;margin:0px;">
                            <tr><td style="font-size:15px;"></td></tr>
                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left; font-weight: bold; ">'.$razon.'</td></tr>
                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left;">'.$direccion.'</td></tr>
                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>NIT:</b>'.$nit.' / <b>NRC:</b>'.$nrc.'</td></tr>
                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left; "><b>GIRO:</b>'.$giro.'</td></tr>
                        </table></td>
                        <td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                        <td style="padding:0px;margin:0px;width:33.3%;">
                        <table style="padding:0px;margin:0px;">
                            <tr><td style="font-size:15px;"></td></tr>
                            <tr><td style="font-size:25px; text-align:center;width:100%;">ORDEN DE COMPRA</td></tr>    
                        </table></td>
                </tr>
                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#FF9900; width:40%; font-weight: bold; border: 1px solid #6E6E6E;">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;"> '.$proveedor.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; fwidth:60%;"> '.$direccion.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"> '.$muni_dep.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>';
                
                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"> Tel.: '.$tel_pro.' / Correo: '.$correo_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';
                }
                
                $estructura .= '<br><br><table style="width:100%;border: 1px solid #6E6E6E;" class="fondo">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; ">Detalles de entrega</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%;border: 1px solid #6E6E6E; font-weight: bold;">Fecha</td>
                                        <td style="font-size:12px; text-align:left; width:45%;border: 1px solid #6E6E6E; ">'.$fecha_entrega.'</td>
                                        <td style="font-size:12px; text-align:left; width:10%;border: 1px solid #6E6E6E; font-weight: bold;">Hora</td>
                                        <td style="font-size:12px; text-align:left; width:30%;border: 1px solid #6E6E6E; ">'.$dev_time.'</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%;border: 1px solid #6E6E6E;  font-weight: bold;">Lugar</td>
                                        <td style="font-size:12px; text-align:left; width:85%;border: 1px solid #6E6E6E; ">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%;border: 1px solid #6E6E6E; font-weight: bold;">Solicitado por:</td>
                                        <td style="font-size:12px; text-align:left; width:85%;border: 1px solid #6E6E6E; ">'.$cliente.'</td>
                                    </tr>
                                    </table><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Detalle del Pedido</td>
                                    </tr>
                                    </table><table style="width:100%;border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:10%; font-weight: bold;">Cant.</td>
                                        <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:12px; text-align:center; width:10%;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                            <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '</table><table style="width:100%;border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:15%;">$'.number_format($exento, 2, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:15%;">$'.number_format($gravado, 2, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:15%;">$'.number_format($iva, 2, '.', '').'</td>
                                    </tr>';
                
                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:15%;">- $'.number_format($percepcion, 2, '.', '').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Total</td>
											<td style="font-size:12px; text-align:right; width:15%;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:15%;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:15%;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
                    }
                
                
                    
                    $estructura .= '</table><table style="width:100%;border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Condiciones</td>
                                    </tr>
                                    </table><table style="width:100%;border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" rowspan="5">'.$notas_cond.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>
                                    
                                </table>';
                return($estructura);
            }
        }
        
        function reporteCompraLocal($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Compra Local');
                $pdf->SetSubject('Compra Local');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                $this->load->model('pedclientes_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                $name = $this->pedclientes_model->getnameImg();
                
                $fecha = new DateTime();
                $footer =  '<br><br>
                    <table style="padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%; border-bottom: 1px solid black;"></th>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%; border-bottom: 1px solid black;"></th>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%; border-bottom: 1px solid black;"></th>
                            <th style="font-size:10px; text-align:left; width:5%"></th>
                            </tr>
                            
                            <tr>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%;">Verificado por</th>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%;">Autorizado por</th>
                            <th style="font-size:10px; text-align:left; width:10%"></th>
                            <th style="font-size:10px; text-align:center; width:20%;">Elaborado por</th>
                            <th style="font-size:10px; text-align:left; width:5%"></th>
                            </tr>
                            
                            <tr>
                            <th style="font-size:10px; text-align:left; width:100%"></th>
                            </tr>
                            
                            <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                        </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);

                 $header = '<table style="width:100%; text-align:center;">
                                    <tr><td colspan="3" style="font-size:5px;"><br></td></tr>
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">COMPRA LOCAL</td>
                                    </tr>
                                </table>';
                
                foreach($informacion as $inf){
                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:50%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;No.</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$idrec.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->descrip.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Referencia: </td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->referencia.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Solicitado por: </td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Número de Documento:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->serie.''.$inf->numero.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->solicita.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Fecha:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.date_format(date_create($inf->fecha), 'd/m/Y').'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr><td style="font-size:10px;"><br></td></tr>
                                </table>';
                }
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='
                <table>
                    <thead>
                        <tr><td style="font-size:10px;"></td></tr>
                        <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#F4CE4D;">
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:30%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:16%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:11%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                        </tr>
                    </thead>
                <tbody>';
                $sum_lines = 0;
                $sum_cant = 0;
                $sum_subtotal = 0;
                foreach($productos as $pro){
                    $sum_lines++;
                    $sum_cant+= $pro->cantidad;
                    $sum_subtotal+=($pro->cantidad * $pro->preciotran);
                    $titulo.='<tr style="border: 1px solidblack;">
                    <td style="width:5%; border-left: 1px solid #6E6E6E; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->itemline.'</strong></td>
                    <td style="width:30%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                    <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
                    <td style="width:16%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
                    <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->modelo.'</td>
                    <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
                    <td style="width:11%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($pro->preciotran, 6),6).'</td>
                    <td style="width:10%; border-right: 1px solid #6E6E6E;text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(($pro->cantidad * $pro->preciotran),2).'&nbsp;&nbsp;</td></tr>';
                }
                
                 
                
                $titulo.='<tr> <td style="border-top: 1px solid #6E6E6E;" colspan="8"><br></td></tr>';
                
                $titulo.='<tr style="border: 1px solidblack;">
                    <td style="width:5%; border-left: 1px solid #6E6E6E; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$sum_lines.'</strong></td>
                    <td colspan="4" style="border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;width:67%;  vertical-align:middle; padding:0px; font-size:10px;"><strong> </strong></td>
                    <td style="width:8%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.round($sum_cant, 0).'</strong></td>
                    <td style="width:10%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"></td>
                    <td style="width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"><strong>$'.number_format(($sum_subtotal),2).'&nbsp;&nbsp;</strong></td></tr>';
               
                $titulo.='</tbody>
                </table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Detalle_Compra".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function enviar_correo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $de = $this->input->post('de');
                $para = $this->input->post('para');
                $cc = $this->input->post('cc');
                $asunto = $this->input->post('asunto');
                $mensaje = $this->input->post('mensaje');
                    
                if($de!=null){
                    $this->load->model('global_model');
                    $razon_social = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nombre_comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $tabla = $this->send_email2($trannum);  

                    $this->load->library('email');
                    //$this->load->library('My_PHPMailer');
                    $this->email->from($de, $nombre_comercial);
                    if($cc!=""){
                        $this->email->to($para.",".$cc);
                    }else{
                        $this->email->to($para);
                    }
                    $this->email->subject($asunto);
                    $this->email->set_mailtype("html");
                    $body ="<h1>".$nombre_comercial."</h1>";
                    $body .= "<h3>".$mensaje."</h3>";
                    $body .=$tabla;

                        $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Orden de Compra');
                    $pdf->SetSubject('Orden de Compra');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetMargins(5, 5, 5);
                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetAutoPageBreak(TRUE, 5);
                    //relación utilizada para ajustar la conversión de los píxeles
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    $pdf->setPrintHeader(true);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage( 'P', 'LETTER' );

                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $this->load->model('pedclientes_model');
                    $this->load->model('compras_model');
                    $this->load->model('variable_model');
                    $name = $this->pedclientes_model->getnameImg();
                    $list_productos = $this->compras_model->getDetail_products($trannum);
                    $det = $this->compras_model->detalleOrdenCompra2($trannum);
                    $vars = $this->variable_model->getTextVar("po_notas");
                    $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                    $notas_cond = $vars['valor_memo'];
                    $proveedor = $det['proveedor'];
                    $cliente = $det['workername'];
                    $formaPago = $det['formaPago'];
                    $orden = $det['trannum'];
                    $cli_phone = $det['trannum'];
                    $cli_email = $det['trannum'];
                    $valVenta = $det['trannum'];
                    $direccion = $det['direccion'];
                    $tel_pro = $det['tel_pro'];
                    $correo_pro = $det['pro_correo'];
                    $notas_orden = $det['notas'];
                    $caj_clase = $det['cajclase'];
                    $provee_dias = $det['provee_dias'];
                    $provee_tipo = $det['provee_tipo'];

                    if($tel_pro==""){
                        $tel_pro="N/A";
                    }
                    if($direccion==""){
                        $direccion="N/A";
                    }
                    if($correo_pro==""){
                        $correo_pro="N/A";
                    }
                    $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                    if($muni_dep==""){
                        $muni_dep="N/A";
                    }
                    $notas = "";
                    $date = date_format(date_create($det['fecha']),'d/m/Y');
                    $dia = date_format(date_create($det['fecha_entrega2']),'d');
                    $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                    $mes = date_format(date_create($det['fecha_entrega2']),'m');
                    $anio = date_format(date_create($det['fecha_entrega2']),'Y');

                    switch($dia_n){
                        case 0:
                            $dia_semana = "Domingo";
                            break;
                        case 1:
                            $dia_semana = "Lunes";
                            break;
                        case 2:
                            $dia_semana = "Martes";
                            break;
                        case 3:
                            $dia_semana = "Miércoles";
                            break;
                        case 4:
                            $dia_semana = "Jueves";
                            break;
                        case 5:
                            $dia_semana = "Viernes";
                            break;
                        case 6:
                            $dia_semana = "Sábado";
                            break;
                        default:
                            $dia_semana="";
                            break;
                    }

                    switch($mes){
                        case 1:
                            $mes_name = "Enero";
                            break;
                        case 2:
                            $mes_name = "Febrero";
                            break;
                        case 3:
                            $mes_name = "Marzo";
                            break;
                        case 4:
                            $mes_name = "Abril";
                            break;
                        case 5:
                            $mes_name = "Mayo";
                            break;
                        case 6:
                            $mes_name = "Junio";
                            break;
                        case 7:
                            $mes_name = "Julio";
                            break;
                        case 8:
                            $mes_name = "Agosto";
                            break;
                        case 9:
                            $mes_name = "Septiembre";
                            break;
                        case 10:
                            $mes_name = "Octubre";
                            break;
                        case 11:
                            $mes_name = "Noviembre";
                            break;
                        case 12:
                            $mes_name = "Diciembre";
                            break;
                        default:
                            $mes_name="";
                            break;
                    }

                    $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;


                    $dev_time = date("g:i a", strtotime($det['dev_time']));
                    $dev_place = $det['lugar_entrega'];    
                    $telefono = $det['telefono'];    

                    $inv_notas = $det['inv_notas'];
                    if($inv_notas!=""){
                        $dev_place .= ",".$inv_notas;
                    }


                    $exento = 0;
                    $gravado = 0;
                    $iva = 0;
                    $sub_total = 0;


                    if(is_array($list_productos) and $list_productos!=false){
                        foreach($list_productos as $key){

                            if($key->tipotax==0){
                                $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                                $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                            }else if($key->tipotax==13){
                                $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                                $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                                $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                            }
                            $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                        }
                    }

                    if($provee_tipo!=3){
                        if($gravado > 100){
                                $percepcion = number_format($gravado, 2, '.', '') * 0.01;
                                $en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                        }else{
                            $en_total = number_format($sub_total, 2, '.', '');
                        }
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }

                    foreach($info_empresa as $emp){
                        switch(round($emp->valor_num)){
                            case 1:
                                $razon = $emp->valor_memo;
                                break;
                            case 3:
                                $nrc = $emp->valor_memo;
                                break;
                            case 4:
                                $nit = $emp->valor_memo;
                                break;
                            case 5:
                                $giro = $emp->valor_memo;
                                break;
                            case 6: 
                                $direccion = $emp->valor_memo;
                                break;
                            case 7:
                                $depto_municipio = $emp->valor_memo;
                                break;

                        }
                    }

                    $estructura ='
                    <style>
                        .fondo{
                            background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                        }
                    </style>';

                    $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
                                            <table style="padding:0px;margin:0px;">
                                                <tr><td style="font-size:15px;"></td></tr>
                                                <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left; font-weight: bold; ">'.$razon.'</td></tr>
                                                <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left;">'.$direccion.'</td></tr>
                                                <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>NIT:</b>'.$nit.' / <b>NRC:</b>'.$nrc.'</td></tr>
                                                <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left; "><b>GIRO:</b>'.$giro.'</td></tr>
                                            </table></td>
                                            <td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                            <td style="padding:0px;margin:0px;width:33.3%;">
                                            <table style="padding:0px;margin:0px;">
                                                <tr><td style="font-size:15px;"></td></tr>
                                                <tr><td style="font-size:25px; text-align:center;width:100%;">ORDEN DE COMPRA</td></tr>    
                                            </table></td>

                                        </tr>
                                    </table>';

                    $estructura .= '<table style="width:100%;">
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%;"></td>
                                            <td style="font-size:12px; text-align:center; background-color:#FF9900; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                        </tr>
                                    </table>';

                    $estructura .= '<table style="width:100%;">
                                        <tr>
                                            <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;"> '.$proveedor.'</td>
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; fwidth:60%;"> '.$direccion.'</td>  
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                            <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%;"> '.$muni_dep.'</td>
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                        </tr>';

                    if($caj_clase==12){
                        $estructura .= '<tr>
                                            <td style="font-size:12px; text-align:left; width:60%;"> Tel.: '.$tel_pro.' / Correo: '.$correo_pro.'</td>
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%;"></td>
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                        </tr>
                                    </table>';
                    }else{
                        $estructura .= '
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                        </tr>
                                    </table>';
                    }



                     $estructura .= '<br><br><table style="width:100%;" class="fondo">
                                        <tr>
                                            <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                            <td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                            <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                            <td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                            <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                            <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                            <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                            <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                            <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                            <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                        </tr>';
                                    if(is_array($list_productos) and $list_productos!=false){
                                        foreach($list_productos as $key){
                                            //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                            $estructura .= '<tr>
                                                                <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                                                <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                                <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                                <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                                <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
                                                            </tr>';
                                                    }
                                    }

                    $estructura .= '<tr>
                                            <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:9px; text-align:left; width:70%;"></td>
                                            <td style="font-size:12px; text-align:center; width:10%;"></td>
                                            <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 2, '.', '').'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 2, '.', '').'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 2, '.', '').'</td>
                                        </tr>';

                        if($provee_tipo!=3){
                            if($gravado > 100){
                                $percepcion = number_format($gravado, 2, '.', '') * 0.01;
                                $sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                                $estructura .= '
                                            <tr>
                                                <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                                <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Retención 1%</td>
                                                <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">- $'.number_format($percepcion, 2, '.', '').'</td>
                                            </tr>
                                            <tr>
                                                <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                                <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                                <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                            </tr>';
                            }else{
                                $estructura .= '<tr>
                                            <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                        </tr>';
                            }
                        }else{
                            $estructura .= '<tr>
                                            <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                        </tr>';
                        }



                        $estructura .= '<tr>
                                            <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Condiciones</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_cond.'</td>
                                        </tr>
                                        <tr><td></td></tr>
                                        <tr><td></td></tr>
                                        <tr><td></td></tr>
                                        <tr><td></td></tr>
                                    </table><br><br><br>';
                        $estructura .= '<table style="width:100%;">
                                        <tr><td><br><br><br></td></tr>
                                        <tr>
                                            <td style="width:35%;"></td>
                                            <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                            <td style="width:35%;"></td>
                                        </tr>

                                    </table>';
                    
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $path = base_url()."doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                    $nombre_archivo = "orden_".$trannum;
                    $fullpath = $_SERVER['DOCUMENT_ROOT']."/".$nombre_archivo;
                    $pdf->Output($fullpath.".pdf",'F');


                    $this->email->message($body);
                    if($nombre_archivo!=''){
                        $this->email->attach($fullpath.".pdf");
                    }
                    if($this->email->send()){
                        unlink($fullpath.".pdf");

                        if($cc!=""){
                            $notas_correo = "Correo enviado de: ". $de . " a: ". $para . ','.$cc;
                        }else{
                            $notas_correo = "Correo enviado de: ". $de . " a: ". $para;
                        }


                        $sent_suc = $this->compras_model->insertOrders_100a($trannum,3,$notas_correo);

                        $array_result = array(
                            "mensaje" =>"Correo enviado",
                            "type" =>"success",

                        );
                        echo json_encode($array_result);
                    }else{
                        unlink($fullpath.".pdf");
                        $array_result = array(
                            "mensaje" =>"Correo no enviado",
                            "type" =>"warning",

                        );
                        echo json_encode($array_result);
                    }

                    }else{
                        $array_result = array(
                            "mensaje" =>"El empleado no tiene correo",
                            "type" =>"warning",

                        );
                    echo json_encode($array_result);
                }
            }
        }
        
        function analisis_antiguedad_ap(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ap();
                $info = $this->arap_model->getProveedores_ap();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo  && $i->saldo!=0){
                            
                            if($cant==0){
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee= $i->provee;
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_tantiguedad_ar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('global_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:9%; text-align:center;">Disponible</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar();
                $info = $this->arap_model->getListClientes_ar();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11"></th></tr><tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->workername).'<br></th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $last_direccion= "";
                    $last_telefono= "";
                    $last_depto= "";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->workername==$gr->workername and ($i->saldo!=0)){
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                 $cant++;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                    $cant=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_tantiguedad(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('global_model');
                $function = $this->uri->segment(3);
                
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage('P', 'LETTER');
                $titulo = '
                <table  style="width:100%;  border-collapse: collapse;">
                    <thead>
                        <tr>
                            <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                            <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                            <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                            <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">1-30</th>
                            <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">31-60</th>
                            <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">61-90</th>
                            <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">91-120</th>
                            <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">121+</th>
                            <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:right;">Saldo Total</th>
                            <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:right;">Límite</th>
                            <th style="border-bottom: 1px solid #6E6E6E; width:9%; text-align:right;">Disponible</th>
                        </tr>
                    </thead>';
                
                $sum_tot_dias1=0; $sum_tot_dias2=0; $sum_tot_dias3=0; $sum_tot_dias4=0; $sum_tot_dias5=0;
                $subtot_dias1=0; $subtot_dias2=0; $subtot_dias3=0; $subtot_dias4=0; $subtot_dias5=0;
                $sum_subtotal=0; $sub_cadena = "";
                
                $info = $this->arap_model->clientes_report();
                
                $vendedor_actual = 0;
                $impreso = 0;
                foreach($info as $i){
                    if($vendedor_actual!=$i->idworker){
                        $sum_vendedor = $subtot_dias1 + $subtot_dias2 + $subtot_dias3 + $subtot_dias4 + $subtot_dias5;
                        $sub_cadena .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_vendedor, 2),2).'</th></tr>';
                        $sum_tot_dias1 += $subtot_dias1;
                        $sum_tot_dias2 += $subtot_dias2;
                        $sum_tot_dias3 += $subtot_dias3;
                        $sum_tot_dias4 += $subtot_dias4;
                        $sum_tot_dias5 += $subtot_dias5;
                        
                        if(round($sum_vendedor,2)>0){
                            $impreso = 1;
                            $titulo.=$sub_cadena;
                        }
                        
                        $subtot_dias1=0;
                        $subtot_dias2=0;
                        $subtot_dias3=0;
                        $subtot_dias4=0;
                        $subtot_dias5=0;
                        $sub_cadena = '<tr><th colspan="11"></th></tr><tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.trim(strtoupper($i->vendedor)).'<br></th></tr>';
                        $sum_cliente=0;
                        $sum_vendedor = 0;
                        $sum_1_30 = $i->sum_1_30;
                        $sum_31_60 = $i->sum_31_60;
                        $sum_61_90 = $i->sum_61_90;
                        $sum_91_120 = $i->sum_91_120;
                        $sum_121 = $i->sum_121;
                        $sum_cliente = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_120+ $sum_121;
                        
                        if(round($sum_cliente,2) >0){
                            $sub_cadena .= '<tr><td style="width:8%;">'.$i->nrc.'</td><td style="width:32%;" colspan="2">'.trim($i->cliente).'</td>';
                            
                            if(round($sum_1_30, 2)>0){
                                $cadena1 = number_format(round($sum_1_30, 2),2);
                            }else{
                                $cadena1 = "";
                            }
                            if(round($sum_31_60, 2)>0){
                                $cadena2 = number_format(round($sum_31_60, 2),2);
                            }else{
                                $cadena2 = "";
                            }
                            if(round($sum_61_90, 2)>0){
                                $cadena3 = number_format(round($sum_61_90, 2),2);
                            }else{
                                $cadena3 = "";
                            }
                            if(round($sum_91_120, 2)>0){
                                $cadena4 = number_format(round($sum_91_120, 2),2);
                            }else{
                                $cadena4 = "";
                            }
                            if(round($sum_121, 2)>0){
                                $cadena5 = number_format(round($sum_121, 2),2);
                            }else{
                                $cadena5 = "";
                            }
                            $dispo = $i->limite-$sum_cliente;
                            $sub_cadena .='<td style="text-align:right;width:7%;">'.$cadena1.'</td><td style="text-align:right;width:7%;">'.$cadena2.'</td><td style="text-align:right;width:7%;">'.$cadena3.'</td><td style="text-align:right;width:7%;">'.$cadena4.'</td><td style="text-align:right;width:7%;">'.$cadena5.'</td><td style="text-align:right;width:8%;">'.number_format(round($sum_cliente, 2),2).'</td><td style="text-align:right;width:8%;">'.number_format(round($i->limite, 2),2).'</td><td style="text-align:right;width:9%;">'.number_format(round($dispo, 2),2).'</td></tr>';  
                        }
                        
                        $subtot_dias1 += $sum_1_30;
                        $subtot_dias2 += $sum_31_60;
                        $subtot_dias3 += $sum_61_90;
                        $subtot_dias4 += $sum_91_120;
                        $subtot_dias5 += $sum_121;
                        
                        $vendedor_actual = $i->idworker;
                    }else{
                        $impreso = 0;
                        
                        $sum_1_30 = $i->sum_1_30;
                        $sum_31_60 = $i->sum_31_60;
                        $sum_61_90 = $i->sum_61_90;
                        $sum_91_120 = $i->sum_91_120;
                        $sum_121 = $i->sum_121;
                        $sum_cliente = $sum_1_30 + $sum_31_60 + $sum_61_90 + $sum_91_120 + $sum_121;
                        
                        if(round($sum_cliente,2) >0){
                            $sub_cadena .= '<tr><td style="width:8%;">'.$i->nrc.'</td><td style="width:32%;" colspan="2">'.trim($i->cliente).'</td>';
                            $dispo = $i->limite-$sum_cliente;
                            if(round($sum_1_30, 2)>0){
                                $cadena1 = number_format(round($sum_1_30, 2),2);
                            }else{
                                $cadena1 = "";
                            }
                            if(round($sum_31_60, 2)>0){
                                $cadena2 = number_format(round($sum_31_60, 2),2);
                            }else{
                                $cadena2 = "";
                            }
                            if(round($sum_61_90, 2)>0){
                                $cadena3 = number_format(round($sum_61_90, 2),2);
                            }else{
                                $cadena3 = "";
                            }
                            if(round($sum_91_120, 2)>0){
                                $cadena4 = number_format(round($sum_91_120, 2),2);
                            }else{
                                $cadena4 = "";
                            }
                            if(round($sum_121, 2)>0){
                                $cadena5 = number_format(round($sum_121, 2),2);
                            }else{
                                $cadena5 = "";
                            }
                            $sub_cadena .='<td style="text-align:right;width:7%;">'.$cadena1.'</td><td style="text-align:right;width:7%;">'.$cadena2.'</td><td style="text-align:right;width:7%;">'.$cadena3.'</td><td style="text-align:right;width:7%;">'.$cadena4.'</td><td style="text-align:right;width:7%;">'.$cadena5.'</td><td style="text-align:right;width:8%;">'.number_format(round($sum_cliente, 2),2).'</td><td style="text-align:right;width:8%;">'.number_format(round($i->limite, 2),2).'</td><td style="text-align:right;width:9%;">'.number_format(round($dispo, 2),2).'</td></tr>';  
                        }
                        
                        $subtot_dias1 += $sum_1_30;
                        $subtot_dias2 += $sum_31_60;
                        $subtot_dias3 += $sum_61_90;
                        $subtot_dias4 += $sum_91_120;
                        $subtot_dias5 += $sum_121;
                        
                        $vendedor_actual = $i->idworker;
                    }
                }
                
                if($impreso == 0){
                    $sum_vendedor = $subtot_dias1 + $subtot_dias2 + $subtot_dias3 + $subtot_dias4 + $subtot_dias5;
                    $sub_cadena .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_vendedor, 2),2).'</th></tr>';
                    
                    $sum_tot_dias1 += $subtot_dias1;
                    $sum_tot_dias2 += $subtot_dias2;
                    $sum_tot_dias3 += $subtot_dias3;
                    $sum_tot_dias4 += $subtot_dias4;
                    $sum_tot_dias5 += $subtot_dias5;
                    
                    $titulo.=$sub_cadena;
                }
                                
                $gran_total= $sum_tot_dias1 + $sum_tot_dias2 + $sum_tot_dias3 + $sum_tot_dias4 + $sum_tot_dias5;
                
                if($gran_total==0){
                    $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                    $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';
                }else{
                    $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                    $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';
                }
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_antiguedad_ar($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 10, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $this->load->model('global_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Disponible</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:5%; text-align:right;">%</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar_vende($idvendedor);
                $info = $this->arap_model->getListClientes_ar_vende($idvendedor);
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                $last_provee="";
                $last_nrc= "";
                $last_direccion= "";
                $last_telefono= "";
                $last_depto= "";
                $sum_total_porcent=0;
                foreach($info as $i){
                    $sum_total_porcent +=$i->saldo;
                }
                
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo and ($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }else{
                                
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $porcen=0;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td><td style="text-align:right;">'.number_format(round((($sum_prov/$sum_total_porcent)*100), 2),2).'</td></tr>';

                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right;font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right;font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
		
        function inv_valorizado($depto, $suc_list){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $suc = $this->sucursal_model->viewSucursalActiva();
                
                if($suc_list==0){
                    $names="Totales";
                }else{
                    $arraySuc = explode("-", $suc_list);
                    $totRig = count($arraySuc);
                    $totReal = $totRig-1;
                    $names = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            foreach($suc as $sucur){
                                if($sucur->idcentro==$arraySuc[$i]){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            foreach($suc as $sucur){
                                if($sucur->tipo==$id){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }
                    }
                    $names =  substr($names, 0, -1);
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label><br><label style="text-align:center; font-size:12px;">'.$names.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos();
                $titulo='';
                if($depto=="0"){
                    //Mostrar kardex de todos los departamentos
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                                <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                            </tr></table>';
                    
                }else{
                    //Llenar tabla de departamento por parametro
                    
                    
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        if($dep->idcatalogo==$depto){
                            $sum_dep=0;

                            $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                        <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                        <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                    </tr></table>';
                }
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
		function departamentos_lineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos_products();
                $lineas_list = $this->catalog_model->list_lineas_productos();

                $titulo='';
                    //Mostrar kardex de todos los departamentos
                $titulo .='<table  style="width:100%;  border-collapse: collapse;">
                <tr style="border-bottom: 1px solid #6E6E6E;">
                    <th style="border-bottom: 1px solid #6E6E6E; width:45%; text-align:center;">Departamento/Línea</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Referencia</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:center;">Centro de Producción o Distribución</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:right;">Productos</th>
                </tr>';
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo){
                                $sum_dep +=$lin->cant;
                            }
                        }
                       // if($sum_dep!=0){
                            $titulo .='<tr>
                                <th style="width:45%; text-align:left; font-size:13px; padding-left:25px; font-weight:bold;color: #031634;"><br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$dep->departamento.'</th>
                                <th style="width:10%; text-align:center; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$dep->idcatalogo.'</th>
                                <th style="width:35%; text-align:left; font-size:13px; font-weight:bold;color: #031634;"><br><br></th>
                                <th style="width:10%; text-align:right; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$sum_dep.'</th>
                            </tr>';
                       // }
                       
                        foreach($lineas_list as $lin){
                            //&& $lin->cant!=0
                            if($lin->idnivel1==$dep->idcatalogo){
                                $titulo .='
                                    <tr>
                                        <td style="width:45%; text-align:right;  font-size:11px;">'.$lin->subdepartamento.'</td>
                                        <td style="width:10%; text-align:center;  font-size:11px;">'.$lin->idcatalogo.'</td>
                                        <td style="width:35%; text-align:center;  font-size:11px;">'.$lin->centro.'</td>
                                        <td style="width:10%; text-align:right;  font-size:11px;">'.$lin->cant.'</td>
                                    </tr>';
                            }
                        }
                    }
                    $titulo .='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("departamentos_lineas.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function carteraporvendedor($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cartera por Vendedor');
                $pdf->SetSubject('Cartera por Vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">';
                $info = $this->arap_model->getCuentas_ar_cartera($idvendedor);
                $clientes = $this->arap_model->getClientes_ar_cartera($idvendedor);
                $total_clientes=0;
                foreach($clientes as $client){
                    $titulo .='
                            <tr>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                                <td colspan="3" style="width:80%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br>'.$client->Name.'</td>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                            </tr>
                            <tr>
                                <th style="width:10%; text-align:left;font-size:11px;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;font-size:11px;">N°</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;font-size:11px;">Fecha</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:left;font-size:11px;">Tipo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:20%; text-align:right;font-size:11px;">Saldo</th>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>

                            </tr>';
                    
                    $sum=0;
                    foreach($info as $inf){
                        if($inf->idauxi==$client->ID && $inf->saldo!=0){
                            $sum += $inf->saldo;
                            $total_clientes+=$inf->saldo;
                            $titulo .='<tr>
                                <td style="width:10%; text-align:left;font-size:10px;"></td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->numero.'</td>
                                <td style="width:15%; text-align:center;font-size:10px;">'.$inf->fecha.'</td>
                                <td style="width:35%; text-align:left;font-size:10px;">'.$inf->tipoDoc.'</td>
                                <td style="width:20%; text-align:right;font-size:10px;">$'.number_format($inf->saldo,2).'</td>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>
                            </tr>';
                        }
                    }
                     $titulo .='
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Sub-Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($sum,2).'</th>
                                <td style="width:20%; text-align:left;font-size:10px;"></td>
                            </tr>';
                }
                $titulo .='<tr><th colspan="5"><br></th></tr>
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($total_clientes,2).'</th>
                                <td style="width:15%; text-align:left;font-size:10px;"></td>
                           </tr>';
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("carteraporvendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_variables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Variables Sistema');
                $pdf->SetSubject('Reporte de Variables Sistema');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 28, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                                                                        
                
                
                
                
                $this->load->model('variable_model');
                $nombres = $this->variable_model->verNombres();
                $variables = $this->variable_model->verVariables();
                

                
                
                 
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
               
                <th colspan="2" width="30%" style=" border-bottom: solid 3px black; font-size:12px;   text-align:left;  font-weight: bold;" >Descripción</th>
                <td width="10%"  style="border-bottom: solid 3px black;"></td>
                <th width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Filtro</th>
                <td width="5%" style="border-bottom: solid 3px black;"></td>
                <th width="24%" style="font-size:12px; border-bottom: solid 3px black;  text-align:right;  font-weight: bold;" >Valor</th>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                
                   
                
                foreach($nombres as $grupo){
                  
                    
                
                
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="6" style="font-size:17px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;" width="100%">'.$grupo->nombre.'</th>
                                  
                                </tr>
                                
                                </thead>';  
                
                $titulo .= '  <tbody>';
                    foreach($variables as $sub){  
                    
                       if($grupo->nombre == $sub->nombre){
                           
                           if($sub->tipo_valor == 1){
                              $tipo = "N";
                              $valor = $sub->valor_num;
                           }else if($sub->tipo_valor == 2){
                               $tipo = "T";
                               $valor = $sub->valor_txt;
                           }else if($sub->tipo_valor == 3){
                               $tipo = "F";
                               $valor = $sub->valor_fecha;
                           }else if($sub->tipo_valor == 4){
                               $tipo = "L";
                               $valor = $sub->valor_logico;
                           }else if($sub->tipo_valor == 5){
                               $tipo = "M";
                               $valor = $sub->valor_num;
                           }
                
                           $titulo .= '  
                                <tr>
                                   
                                    <td colspan="2" width="30%" style="font-size:11px; font-weight:bold;   text-align:left;" >'.$sub->descripcion.'('.$tipo.')</td>
                                    <td width="10%"></td>
                                    <td width="30%" style="font-size:11px;  text-align:center;" >'.$sub->filtro.'</td>
                                    <td width="5%"></td>
                                    <td width="24%" style="font-size:11px;  text-align:right;" >'.$valor.'</td>
                                </tr> ';
                           
                           if($sub->valor_memo == ""){ 
                            
                           }else{
                               
                                $titulo .= '<tr>
                                    <td width="5%"></td>
                                    <td colspan="2" width="45%" style="font-size:11px;   text-align:left;" >'.$sub->valor_memo.'</td>
                                    <td  width="30%" ></td>
                                    <td  width="5%" ></td>
                                    <td width="35%"  ></td>
                                </tr>';
                               
                               
                           }
                           
                                
                       }}
                    $titulo .= '<tbody></table><br><br>';
                }
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Variables_Sistema.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_aplicaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Listado de Aplicaciones');
                $pdf->SetSubject('Reporte de Listado de Aplicaciones');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 29, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                                                                        
                
                
                $this->load->model('apps_model');
                $menus = $this->apps_model->viewMenu();
                
                $apps = $this->apps_model->verApps();
                
               // $this->load->model('variable_model');
              //  $nombres = $this->variable_model->verNombres();
              //  $variables = $this->variable_model->verVariables();
                

                
                
                 
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
                
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="35%" style=" border-bottom: solid 3px black; font-size:12px; text-align:left;  font-weight: bold;" >Descripción</td>
                    <td width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre de la Aplicación</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Opciones</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Orden de Menú</td>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '<tbody>';
                
                
                foreach($menus as $key){
                    $titulo .= '<tr>
                                    <td colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">'.trim($key->descripcion).'</td>
                                </tr>';
                    foreach($apps as $key2){   
                        if(trim($key2->menuname) == trim($key->descripcion)){
                            
                            
                            
                            if($key2->menutype == 1){
                            
                            $titulo .= '<tr>
                                            <td width="3%"></td>
                                            <td colspan="5" style="font-size:12px; color: black; font-weight: bold; text-align:left;">'.trim($key2->descrip).'</td>
                                        </tr>';
                            
                           
                          
                                
                             foreach($apps as $key3){
                                    if($key2->idapp == $key3->idapphd){
                                        
                 $titulo .= '<tr>
                
                                    <td width="3%" ></td>
                                    <td width="3%" ></td>
                                    <td width="35%" style=" font-size:12px; text-align:left; " >'.trim($key3->descrip).'</td>
                                    <td width="30%" style="font-size:12px;   text-align:left; " >'.$key3->appname.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center;" >'.$key3->appoptions.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center; " >'.$key3->menuorder.'</td>
                                    </tr>
                                    ';
                                        
                                        
                                        if($key3->notas == ""){
                                    
                                    
                                        }else{
                                
                                           $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2" style=" font-size:11px; text-align:left; " >'.$key3->notas.'</td>
                                                            <td colspan="2"></td>
                                                        </tr>';
                                        }
                                        
                                        
                                        
                                        
                                        
                                        
                                    }
                             }  
                               
                                
                    
                          }else{
                                $titulo .= '<tr>
                                            <td width="3%" ></td>
                                            <td width="3%" ></td>
                                            <td width="35%" style="  font-size:12px; text-align:left; " >'.$key2->descrip.'</td>
                                            <td width="30%" style="font-size:12px;  text-align:left; " >'.$key2->appname.'</td>
                                            <td width="15%" style="font-size:12px;  text-align:center; " >'.$key2->appoptions.'</td>
                                            <td width="15%" style="font-size:12px;   text-align:center; " >'.$key2->menuorder.'</td>
                                    </tr> ';
                                
                                if($key2->notas == ""){
                                    
                                    
                                }else{
                                        $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2"style=" font-size:11px; text-align:left; " >'.$key2->notas.'</td>
                                                            <td colspan="2"></td>
                                                    </tr>';
                                }
                                
                                
                                
                                
                               
                                
                            }
                        }
                    }
                    
                    $titulo .= '<tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                    </tr> ';
                     
                 }
                   
                $titulo .= '</tbody></table><br><br>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Listado_Aplicaciones.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
		function centimos(){
			global $importe_parcial;
            $importe_parcial = $importe_parcial *1;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
				case 0:{
					$num_letra = "0";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			$numero = trim($numero);
            $numero = $numero*1; 
			if($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if($numero == 90)
						return "90";
					else if($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if($numero >= 80 && $numero <= 89){
					if($numero == 80)
						return "80";
					else if($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if($numero >= 70 && $numero <= 79){
					if($numero == 70)
						return "70";
					else if($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if($numero >= 60 && $numero <= 69){
					if($numero == 60)
						return "60";
					else if($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if($numero >= 50 && $numero <= 59){
					if($numero == 50)
						return "50";
					else if($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if($numero >= 40 && $numero <= 49){
					if($numero == 40)
						return "40";
					else if($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if($numero >= 30 && $numero <= 39){
					if($numero == 30)
						return "30";
					else if($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if($numero >= 20 && $numero <= 29){
					if($numero == 20)
						return "20";
					else if($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if($numero >= 10 && $numero <= 19){
					if($numero == 10)
						return "10";
					else if($numero == 11)
						return "11";
					else if($numero == 12)
						return "12";
					else if($numero == 13)
						return "13";
					else if($numero == 14)
						return "14";
					else if($numero == 15)
						return "15";
					else if($numero == 16)
						return "16";
					else if($numero == 17)
						return "17";
					else if($numero == 18)
						return "18";
					else if($numero == 19)
						return "19";
				}
			}else{
				return $this->unidad_centimos($numero);
			}
		}

		function unidad($numero){
			$numero = trim($numero); 
            $num = "cero";
			switch($numero){
				case 9:{
					$num = "nueve";
					break;
				}
				case 8:{
					$num = "ocho";
					break;
				}
				case 7:{
					$num = "siete";
					break;
				}
				case 6:{
					$num = "seis";
					break;
				}
				case 5:{
					$num = "cinco";
					break;
				}
				case 4:{
					$num = "cuatro";
					break;
				}
				case 3:{
					$num = "tres";
					break;
				}
				case 2:{
					$num = "dos";
					break;
				}
				case 1:{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			$numero = trim($numero);

			if($numero >= 90 && $numero <= 99){
				$num_letra = "noventa ";
				
				if($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}else if($numero >= 80 && $numero <= 89){
				$num_letra = "ochenta ";
				
				if($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}else if($numero >= 70 && $numero <= 79){
					$num_letra = "setenta ";

				if($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}else if($numero >= 60 && $numero <= 69){
				$num_letra = "sesenta ";

				if($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}else if($numero >= 50 && $numero <= 59){
				$num_letra = "cincuenta ";

				if($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}else if($numero >= 40 && $numero <= 49){
				$num_letra = "cuarenta ";

				if($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}else if($numero >= 30 && $numero <= 39){
				$num_letra = "treinta ";

				if($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}else if($numero >= 20 && $numero <= 29){
				if($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}else if($numero >= 10 && $numero <= 19){
				switch($numero){
					case 10:{
						$num_letra = "diez ";
						break;
					}
					case 11:{
						$num_letra = "once ";
						break;
					}
					case 12:{
						$num_letra = "doce ";
						break;
					}
					case 13:{
						$num_letra = "trece ";
						break;
					}
					case 14:{
						$num_letra = "catorce ";
						break;
					}
					case 15:{
						$num_letra = "quince ";
						break;
					}
					case 16:{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}else{
				$num_letra = $this->unidad($numero);
			}
			
			return $num_letra;
		}

		function centena($numero){
			$numero = trim($numero);
			if($numero >= 100){
				if ($numero >= 900 & $numero <= 999){
					$num_letra = "novecientos ";

					if($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}else if($numero >= 800 && $numero <= 899){
					$num_letra = "ochocientos ";

					if($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}else if($numero >= 700 && $numero <= 799){
					$num_letra = "setecientos ";

					if($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}else if($numero >= 600 && $numero <= 699){
					$num_letra = "seiscientos ";

					if($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}else if($numero >= 500 && $numero <= 599){
					$num_letra = "quinientos ";

					if($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}else if($numero >= 400 && $numero <= 499){
					$num_letra = "cuatrocientos ";

					if($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}else if($numero >= 300 && $numero <= 399){
					$num_letra = "trescientos ";

					if($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}else if($numero >= 200 && $numero <= 299){
					$num_letra = "doscientos ";

					if($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}else if($numero >= 100 && $numero <= 199){
					if($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}else{
				$num_letra = $this->decena($numero);
			}

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;
			$importe_parcial = $importe_parcial*1;
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			$num_letra = $this->centena($parcial).$this->centimos();
			
			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;
            $importe_parcial = $importe_parcial*1;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial > 0){
				if($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;
			$importe_parcial = $importe_parcial*1;
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";
			
			return $num_letras;
		}

		function convertir_a_letras($numero){
			global $importe_parcial;
			
			$numero = trim($numero);
			
			$importe_parcial = $numero;
			
			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function comprobanteQuedan($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
				$pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

				$pdf->SetCreator(PDF_CREATOR);
				$pdf->SetAuthor('Versanet Sistemas');
				$pdf->SetTitle('Comprobante Quedan');
				$pdf->SetSubject('Comprobante Quedan');
				$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				
				$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
				$pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
				$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
				$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
				$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
				$pdf->SetMargins(8, 5, 8);
				$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
				$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
				$pdf->SetAutoPageBreak(TRUE, 5);
				$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
				$pdf->setFontSubsetting(true);
				$pdf->setPageOrientation('P');
				$pdf->SetFont('Helvetica', '', 7, '', true);
				
				$pdf->setPrintHeader(false);
				$pdf->setPrintFooter(false);
				$pdf->addPage( 'P', 'LETTER');
				
				$this->load->model('compras_model');
				$this->load->model('pedclientes_model');
				
				$datos = $this->compras_model->getInformacionRecepcionCompra($trannum);
				$name = $this->pedclientes_model->getnameImg();
				
				foreach($datos as $info){
					$dia = date_format(date_create($info->fecact),'d');
					$mes = date_format(date_create($info->fecact),'m');
					$anio = date_format(date_create($info->fecact),'Y');
					
					switch($mes){
						case 1:
							$mes_name = "Enero";
							break;
						case 2:
							$mes_name = "Febrero";
							break;
						case 3:
							$mes_name = "Marzo";
							break;
						case 4:
							$mes_name = "Abril";
							break;
						case 5:
							$mes_name = "Mayo";
							break;
						case 6:
							$mes_name = "Junio";
							break;
						case 7:
							$mes_name = "Julio";
							break;
						case 8:
							$mes_name = "Agosto";
							break;
						case 9:
							$mes_name = "Septiembre";
							break;
						case 10:
							$mes_name = "Octubre";
							break;
						case 11:
							$mes_name = "Noviembre";
							break;
						case 12:
							$mes_name = "Diciembre";
							break;
						default:
							$mes_name="";
							break;
					}

					$fecha_quedan = $dia." DE ".strtoupper($mes_name)." DE ".$anio;
					$totalVenta = $info->valcosto + $info->valtax1 - abs($info->valtax5);

					$estructura = '
					<table style="width:100%;">
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:18px; width:20%;" rowspan="8"><img style="text-align:center; width:500px; height:300px; margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:18px; width:60%;"><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:18px; width:20%;" rowspan="8"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:60%;"><strong>'.strtoupper($info->sucursal).'</strong></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:6px; width:60%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:60%;">5a Avenida Sur, Barrio El Carmen, Nueva Concepción</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:60%;">Teléfonos: 2335-7082  Correo: gerente.compras@panlilian.com</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:6px; width:60%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:16px; width:60%;"><strong>COMPROBANTE DE QUEDAN</strong></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:60%;"></td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:14px; width:85%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:15%; border:solid 1px black;"><strong>N°: '.$info->trannum.'</strong></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:6px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;">NUEVA CONCEPCIÓN, '.$fecha_quedan.'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:6px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:6px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Señores: <strong>'.$info->descrip.'</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">Compras Gravadas:</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>$'.number_format($info->valcosto, 2, '.', '').'</strong></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Queda en nuestro poder el comprobante N°: <strong>'.$info->serie.''.$info->numero.'</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">13% IVA:</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>$'.number_format($info->valtax1, 2, '.', '').'</strong></td>
						</tr>';
					
					if($info->valtax5 != 0){
						$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Por un monto de: <strong>$'.number_format($totalVenta, 2, '.', '').'</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">Compras Exentas:</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>$00.00</strong></td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">Percepción 1%:</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border-bottom:solid 1px black;"><strong>$'.number_format($info->valtax5, 2, '.', '').'</strong></td>
						</tr>';
					}else{
						$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Por un monto de: <strong>$'.number_format($totalVenta, 2, '.', '').'</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">Compras Exentas:</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;  border-bottom:solid 1px black;"><strong>$00.00</strong></td>
						</tr>';
					}
					
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Con fecha de emisión: <strong>'.date_format(date_create($info->fecvence), 'd/m/Y').'</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:14px; width:25%;"><strong>TOTAL:</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:14px; width:25%;"><strong>$'.number_format($totalVenta, 2, '.', '').'</strong></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:30%;"><strong>'.date_format(date_create($info->fecact), 'd/m/Y').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:30%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:30%; border-top:solid 1px black;"><strong>Fecha de Proceso</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:30%; border-top:solid 1px black;"><strong>Elaborado Por.</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
						</tr>
					</table>';
				}

				$pdf->writeHTML($estructura, true, 0, false, false, 0);
				$nombreArchivo = utf8_decode("Comprobante Quedan.pdf");
				$pdf->Output($nombreArchivo, 'I');
			}
		}     
        
        function multi_mail($trannum){
           $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $this->load->model('pedclientes_model');
                
                $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $formapago = $this->ventas_model->getFormaDePagoTrannum($trannum);
                $name = $this->pedclientes_model->getnameImg();
                
                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
					$idcaja = $info->idcaja;
                    $tipocliente = $info->idtipo;
                }
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				if($formapago == ''){
					$formapago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);
				}
				
                $estructura = '
					<table style="width:100%; padding-top:0px;">
						<tr>
                    <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:45%;"><strong>TECNOVIDRI, S.A. DE C.V.<br>4° Calle Pte. y 25 Avenida Sur, Condominio Cuscatlan<br> 1 Planta San Salvador, San Salvador<br>PBX:2271-6099</strong></td>
                            <td style="text-align:center; border: 1px solid black; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;" ><br><br><br><strong>COTIZACION</strong><br>N°<br><strong style="font-size:14px;">'.$trannum.'</strong></td>
                        </tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
						</tr>
					</table>';
					$estructura .= '
						<table style="width:100%; border:1px solid black;">
							<tr>
								<td style="border-right:1px solid black; text-align:right; vertical-align:middle; font-weight:normal; font-size:5px; width:75%;"><br></td>
								<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:5px; width:25%;"><br></td>
							</tr>
							<tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;"></td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;"></td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Fecha:</strong> '.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>
							</tr>
                            <tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Nombre del Cliente:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["idcps"].' - '.$dataPedido["clientename"].'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nrc:</strong>'.$dataPedido["NRC"].'</td>
                                
							</tr>
                              <tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Direccion:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["direccion"].'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nit:</strong>'.$dataPedido["NIT"].'</td>
							</tr>
                            <tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Tipo Documento:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["tipodoc"].'</td>
							</tr> 
                            <tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Forma de Pago:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["formaPago"].'</td>
							</tr>
                             <tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan="2">Nota: '.$dataPedido["notas"].'</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;"></td>
							</tr>
						</table>';
				
				$estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="background-color:#FFFF00; color:#000000; border:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"><strong>LINEA</strong></td>
						<td style="background-color:#FFFF00; color:#000000; border:1px solid #000000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;"><strong>CODIGO</strong></td>
						<td style="background-color:#FFFF00; color:#000000; border:1px solid #000000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;"><strong>DESCRIPCION DEL PRODUCTO</strong></td>
                        <td style="background-color:#FFFF00; color:#000000; border:1px solid #000000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>CANTIDAD</strong></td>
						<td style="background-color:#FFFF00; color:#000000; border:1px solid #000000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>PRECIO DE VENTA</strong></td>
						<td style="background-color:#FFFF00; color:#000000; border:1px solid #000000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>SUB TOTAL</strong></td>
					</tr>';
				
				$productos = $this->pedclientes_model->getDataProduct($trannum);
				
				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0;
                $m = 0; $i = 0;
				
				foreach($productos as $pro){
					if($pro->tipotax != 0 && $invexento == 0){
						$total = $total + number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$totalGravado = $totalGravado + number_format(round((($pro->precioneto * abs($pro->cantidad))/(1+($pro->tipotax / 100))),2), 2 ,'.','');
                        
							
						$vnExenta = "";
						$vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
					}else if($pro->tipotax != 0 && $invexento == 1){
						$total = $total + (($pro->precioneto * abs($pro->cantidad)));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax== 0 && $invexento == 0){
						$total = $total + (($pro->precioneto) * abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax == 0 && $invexento == 1){
						$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}
						
					$preciouni = $pro->precioneto;
					$nombrepro = substr($pro->descrip, 0, 25);
                    /*.$pro->modelo.*/
					$estructura .= '
						<tr>
							<td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;">'.$pro->itemline.'</td>
							<td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;">'.$pro->modelo.'</td>
							<td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">'.$nombrepro.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.abs($pro->cantidad).'</td>
							<td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.number_format($preciouni, 2 ,'.','').'</td>
							<td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$vnExenta.''.$vnGravada.'</td>
						</tr>';
                    $m = $m + 1;
                    
				}
				
                 for($i = $m; $i <= 36; $i++){
                    $estructura .= '
                        <tr>
                            <td style="font-size:11px; width:100%;"></td>
                        </tr>';
                }
				$estructura .= '</table>';
                
                 if(($dataPedido["idtipo"]==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                }else{
                    $retencion = 0;
                }
                    
                if($retencion == 0){
                    $retencion = "";
                }else{
                    $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                }
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
                
                $totalIVA = number_format(round(($totalGravado * ($pro->tipotax/100)), 2), 2 ,'.',''); 
 
                
				$estructura .=  '
                	<table style="padding:0px; margin:0px;">
                    	<tr style="padding:0px; margin:0px; background-color:#FFFF00;">
							<th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:100%"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                        </tr>
                        
                        <tr style="padding:0px; margin:0px; background-color:#FFFF00;">
							<th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>SUB-TOTAL</strong></th>
                            <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>IVA</strong></th>
                            <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>RETENCIÓN</strong></th>
                            <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                        </tr>
                        
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalGravado.'</strong></th>
                            <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalIVA.'</strong></th>
                            <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>'.$retencion.'</strong></th>
                            <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                        </tr>
                        <br>
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; text-align:left; width:100%"><strong>**VALIDEZ DE LA OFERTA 8 DIAS DESPUES DE SU EMISION PRECIOS Y EXISTENCIAS SUJETOS A PREVIA VENTA<br>**PRECIOS INCLUYEN IVA</strong></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; text-align:left; width:40%">Nota:</th>
                        </tr> 
                        
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; text-align:left; width:100%; border: 1px solid black"><br><br><br></th>
                        </tr> 
                        
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; text-align:center; width:30%">'.$info->idvendedor.' - '.$info->nameVendedor.'</th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; text-align:center; width:30%"></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; text-align:center; width:30%"></th>
                        </tr>        
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Atendido por</strong></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%">Autorizado por</th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%">Aceptado Cliente</th>
                        </tr>
                        
                    </table>';

            echo json_encode($estructura);

        }
        
        function send_email_orden_venta($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $this->load->model('pedclientes_model');
                $this->load->model("global_model");
                $this->load->model("ventas_model");
                $this->load->model('producto_model');
                $this->load->model('fabrica_model');
                $this->load->model('compras_model');
                $function = $this->uri->segment(3);
                $nombre_doc="";
                $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                $name = $this->pedclientes_model->getnameImg();
                $fecha = new DateTime();

                $html_code = '<table style="width:100%;">
                    <tr>
                        <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                        <td style="width:70%;font-size:22px; text-align:right;"><br><br>COTIZACIÓN</td>
                    </tr></table>';
                $html_code .= '<table style="width:100%;">
                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Cliente&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["clientename"].'</td>
                        <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">N°&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$trannum.'</td>
                    </tr>
                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Vendedor&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["workername"].'</td>
                        <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>

                    </tr>
                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Lugar de Entrega&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["lugar_entrega"].'</td>
                        <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha de Entrega&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["dev_date"]),'d/m/Y').'</td>
                    </tr>

                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Tipo de Documento&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:35%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["tipodoc"].'</td>
                        <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Forma de Pago&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:30%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["formaPago"].'</td>
                    </tr>
                </table>';

                $tabla_presentacion = '<table style="width:100%;border: 0.3px solid #6E6E6E;padding:10px;">';
                $encabezado = $this->ventas_model->getAnexosHijos($trannum);
                if($encabezado!=false){
                    foreach($encabezado as $enc){
                        $tabla_presentacion .= '<tr>
                            <td style="width:100%;padding:2px;">'.$enc->notas.'</td>
                        </tr>';
                    }
                    $tabla_presentacion.='</table>';
                    $html_code.= $tabla_presentacion;
                }


                $html_code .='<br><table style="width:100%;"><tr>
                                        <th style="font-size:12px; font-weight:bold; text-align:left; width:85%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">&nbsp;&nbsp;Nombre del producto</th>
                                        <th style="font-size:12px; font-weight:bold; text-align:center; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Precio</th>
                                    </tr>';
                if($list_producto!=false){
                    foreach($list_producto as $pro){
                        $html_code .='<tr>
                            <td style="font-size:12px; text-align:left; width:85%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$pro->descrip.'</td>
                            <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E;">$'.number_format(round($pro->precioneto, 2),2).'&nbsp;&nbsp;</td>
                            </tr>';
                    }
                }

                $html_code .='</table>';

                return($html_code);
            }
        }
        
        function enviar_correo_orden_venta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $trannum = $this->input->post('trannum');
                $de = $this->input->post('de');
                $para = $this->input->post('para');
                $asunto = $this->input->post('asunto');
                $mensaje = $this->input->post('mensaje');
                if($de!=""){
                    $this->load->model('global_model');
                    $tabla = $this->send_email_orden_venta($trannum);
                    //$this->load->library('My_PHPMailer');
                    $this->load->model('global_model');
                    $razon_social = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nombre_comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $body ="<h1>".$nombre_comercial."</h1>";
                    $body .= "<h3>".$mensaje."</h3>";
                    $body .=$tabla;
                    $this->load->library('My_PHPMailer');
                    $mail = new PHPMailer();
                    $mail->IsSMTP(); // establecemos que utilizaremos SMTP
                    $mail->SMTPAuth   = true; // habilitamos la autenticación SMTP
                    $mail->SMTPSecure = "tls";
                    $mail->Host       = "smtp.gmail.com";      // establecemos GMail como nuestro servidor SMTP
                    $mail->Port       = 587;                   // establecemos el puerto SMTP en el servidor de GMail
                    $mail->Username   = "versanetsasv@gmail.com";  // la cuenta de correo GMail
                    $mail->Password   = "Egga#94662";            // password de la cuenta GMail
                    $mail->IsHTML(true);
                    $mail->SetFrom($de, $nombre_comercial);  //Quien envía el correo
                    $mail->addAddress($de);
                    $mail->addAddress($de);
                    $mail->Subject = $asunto;  //Asunto del mensaje
                    $mail->Body = $body;
                    $destino = $para;
                    $arreglo_para = explode(",", $para);
                    $cant = count($arreglo_para);
                    for($m = 0; $m<$cant; $m++){
                        $mail->AddAddress($arreglo_para[$m]);
                    }
                    $mail->CharSet = 'UTF-8';
                    
                    $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);      
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Cotización');
                    $pdf->SetSubject('Cotización');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetAutoPageBreak(TRUE,10);
                    $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, 5 );
                    $pdf->SetHeaderMargin(0,0,0,0);
                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT, 50);
                    $this->load->model('pedclientes_model');
                    $this->load->model("global_model");
                    $this->load->model("ventas_model");
                    $this->load->model('producto_model');
                    $this->load->model('fabrica_model');
                    $this->load->model('compras_model');
                    $function = $this->uri->segment(3);
                    $nombre_doc="";
                    $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                    $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                    $name = $this->pedclientes_model->getnameImg();
                    $fecha = new DateTime();

                    $footer =  '<br><br><br><br><br><br>
                    <table style="padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                                <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                        </table>';

                    $pdf->setHtmlFooter($footer);
                    $pdf->setPrintFooter(true);

                    $header = '<table style="width:100%;">
                        <tr>
                            <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="width:70%;font-size:22px; text-align:right;"><br><br>COTIZACIÓN</td>
                        </tr></table>';
                    $header .= '<table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Cliente&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["clientename"].'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">N°&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$trannum.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Vendedor&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["workername"].'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>

                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Lugar de Entrega&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["lugar_entrega"].'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha de Entrega&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["dev_date"]),'d/m/Y').'</td>
                        </tr>

                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Tipo de Documento&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:35%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["tipodoc"].'</td>
                            <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Forma de Pago&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:30%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["formaPago"].'</td>
                        </tr>
                    </table>';

                    $pdf->setHtmlHeader($header);
                    $pdf->setPrintFooter(true);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('Portrait');
                    $pdf->SetFont('Helvetica', '', 7, '', true);
                    $pdf->addPage('P', 'LETTER');
                    $estructura ='';
                    $tabla_presentacion = '<table style="width:100%;border: 0.3px solid #6E6E6E;padding:10px;">';
                    $encabezado = $this->ventas_model->getAnexosHijos($trannum);
                    if($encabezado!=false){
                        foreach($encabezado as $enc){
                            $tabla_presentacion .= '<tr>
                                <td style="width:100%;padding:10px;">'.$enc->notas.'</td>
                            </tr>';
                        }
                        $tabla_presentacion.='</table>';
                        $estructura.= $tabla_presentacion;
                    }


                    $estructura .='<br><br><table><tr>
                                            <th style="font-size:12px; font-weight:bold; text-align:left; width:85%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">&nbsp;&nbsp;Nombre del producto</th>
                                            <th style="font-size:12px; font-weight:bold; text-align:center; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Precio</th>
                                        </tr>';
                    if($list_producto!=false){
                        foreach($list_producto as $pro){
                            $estructura .='<tr>
                                <td style="font-size:12px; text-align:left; width:85%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$pro->descrip.'</td>
                                <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E;">$'.number_format(round($pro->precioneto, 2),2).'&nbsp;&nbsp;</td>
                                </tr>';
                        }
                    }

                    $estructura .='</table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $path = base_url()."doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                    $nombre_archivo = "cotizacion_".$trannum;
                    $fullpath = $_SERVER['DOCUMENT_ROOT']."/".$nombre_archivo.".pdf";
                    $pdf->Output($fullpath,'F');
                    //$this->email->message($body);
                    if($nombre_archivo!=''){
                        $mail->AddAttachment($fullpath, $name = $nombre_archivo.".pdf",  $encoding = 'base64', $type = 'application/pdf');
                    }

                    if(!$mail->Send()) {
                        unlink($fullpath);
                        $array_result = array(
                            "mensaje" =>"Correo no enviado",
                            "type" =>"warning",

                        );
                        echo json_encode($array_result);
                    } else {
                        unlink($fullpath);
                        $notas_correo = "Correo enviado de: ". $de . " a: ". $para;
                        $array_result = array(
                            "mensaje" =>"Correo enviado",
                            "type" =>"success",
                        );
                        echo json_encode($array_result);
                    }
                    }else{
                    $array_result = array(
                        "mensaje" =>"El empleado no tiene correo",
                        "type" =>"warning", 
                    );
                    echo json_encode($array_result);
                }
            }
        }      
        
        function agrupacion_productos($tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Agrupación de Productos');
                $pdf->SetSubject('Agrupación de Productos');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $tipoproduct = $this->producto_model->getDescripTipo($tipopro);
                $header = '<center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;font-weight:bold;">'.$nombre_doc.'</label><br><label style="text-align:center; font-size:15px;">'.$tipoproduct.'</label></center>';
                $header .= '<hr style="border-color:#031634;background-color:#031634;color:#031634;height:2px;"></hr><br>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $departamentos_list = $this->catalog_model->getDepartamentosTipo($tipopro);
                $titulo='';
                $row_cant = 0;
                $row1 = "";
                $row2 = "";
                $row3 = "";
                $pdf->AddPage('L', 'LETTER');

                foreach($departamentos_list as $dep){
                    if($row_cant>=0 && $row_cant<=40){
                        if($row_cant==0){
                            $row1 .='<tr><th style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;">'.$dep->descrip.' ('.$dep->cantidad.')</th></tr>';
                            $row_cant++;
                        }else{
                            $row1 .='<tr><th style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;"><br>'.$dep->descrip.' ('.$dep->cantidad.')</th></tr>';
                            $row_cant++;
                        }
                        
                    }
                    else if($row_cant>=41 && $row_cant<=80){
                        $row2 .='<tr><th style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;"><br>'.$dep->descrip.' ('.$dep->cantidad.')</th></tr>';
                        $row_cant++;
                    }
                    else if($row_cant>=81 && $row_cant<=120){
                        $row3 .='<tr><th style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;"><br>'.$dep->descrip.' ('.$dep->cantidad.')</th></tr>';
                        $row_cant++;
                        if($row_cant==120){
                            $titulo .='<table style="width:100%; border-collapse: collapse;"><tr><td style="width:33.33%;"><table>'.$row1.'</table></td><td style="width:33.33%;"><table>'.$row2.'</table></td><td style="width:33.33%;"><table>'.$row3.'</table></td></tr></table>';
                            $row1 = '';
                            $row2 = '';
                            $row3 = '';
                            $row_cant = 0;
                        }
                    }
                    $lineas_list = $this->catalog_model->getLineasTipo($dep->idcatalogo);
                    foreach($lineas_list as $lin){
                        if($lin->idnivel1==$dep->idcatalogo){
                            if($row_cant>=0 && $row_cant<=40){
                                $row1 .='<tr>
                                        <td style="width:5%; text-align:right;  font-size:11px;"></td>
                                        <td style="width:95%; text-align:left;  font-size:11px;">'.$lin->descrip.' <strong>('.$lin->cantidad.')</strong></td>
                                        </tr>';
                                $row_cant++;
                            }
                            else if($row_cant>=41 && $row_cant<=80){
                                $row2 .='<tr>
                                        <td style="width:5%; text-align:right;  font-size:11px;"></td>
                                        <td style="width:95%; text-align:left;  font-size:11px;">'.$lin->descrip.' <strong>('.$lin->cantidad.')</strong></td>
                                        </tr>';
                                $row_cant++;
                            }
                            else if($row_cant>=81 && $row_cant<=120){
                                $row3 .='<tr>
                                    <td style="width:5%; text-align:right;  font-size:11px;"></td>
                                    <td style="width:95%; text-align:left;  font-size:11px;">'.$lin->descrip.' <strong>('.$lin->cantidad.')</strong></td>
                                    </tr>';
                                $row_cant++;
                                if($row_cant==120){
                                    $titulo .='<table  style="width:100%;  border-collapse: collapse;"><tr><td style="width:33.33%;"><table>'.$row1.'</table></td><td style="width:33.33%;"><table>'.$row2.'</table></td><td style="width:33.33%;"><table>'.$row3.'</table></td></tr></table>';
                                    $row1 = '';
                                    $row2 = '';
                                    $row3 = '';
                                    $row_cant = 0;
                                }
                            }
                        }
                    }
                }
                $titulo .='<table  style="width:100%;  border-collapse: collapse;"><tr><td style="width:33.33%;"><table>'.$row1.'</table></td><td style="width:33.33%;"><table>'.$row2.'</table></td><td style="width:33.33%;"><table>'.$row3.'</table></td></tr></table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("agrupacion_productos.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function recuperacion_diaria($idcentro, $fechaini,$fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Recuperación Diaria');
                $pdf->SetSubject('Recuperación Diaria');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM); // set the margins 
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                $this->load->model('arap_model');   
                $funcion = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $pagos = $this->arap_model->getPagosRecuperacion($idcentro, $fechaini,$fechafin);
                $formaspagos = $this->arap_model->getFormasPagosRecuperacion($idcentro, $fechaini,$fechafin);
                $fecha = new DateTime();

                $estructura="";
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'<br>'.$nombreFormato.'<br>Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').' </label></center>';
               $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 35%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $estructura .='<table style="width:95%;"><thead style="border: 1px solid black;">
                <tr>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:8%;">Fecha</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:30%;">Cliente</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:10%;">Doc</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:12%;">Referencia</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:20%;">Descripción</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:7.5%;">Abonos</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:7.5%;">Cargos</th>
                </tr>
                </thead><tbody>';
                
                $array_totalizador = array();
                $count_totalizador = 0;
                foreach($formaspagos as $forms){
                    $estructura .='
                    <tr>
                    <td style="font-weight:bold;font-size:12px; text-align:left;width:95%;border-bottom:1px solid black;">'.strtoupper($forms->descrip).'</td>
                    </tr>';
                    $sum_abonos = 0;
                    $sum_cargos = 0;
                    foreach($pagos as $detalle){
                        if($forms->cajclase==$detalle->cajclase){
                            $cargo = 0;
                            $abono = 0;
                            if($detalle->valor<0){
                                $abono = abs($detalle->valor); 
                            }else{
                                $cargo = abs($detalle->valor); 
                            }
                            $sum_abonos += $abono;
                            $sum_cargos += $cargo;
                            $estructura .='
                            <tr>
                                <td style="font-weight:normal;font-size:9px; text-align:center;width:8%;">'.date_format(date_create($detalle->fecha), 'd/m/Y').'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:left;width:30%;">'.$detalle->cliente.'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:left;width:10%;">'.$detalle->serie.$detalle->numero.'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:left;width:12%;">'.$detalle->referencia.'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:left;width:20%;">'.$detalle->banco.'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:right;width:7.5%;">'.number_format(round($abono, 2), 2 ,'.',',').'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:right;width:7.5%;">'.number_format(round($cargo, 2), 2 ,'.',',').'</td>
                            </tr>';
                        }
                    }
                    $estructura .='
                    <tr>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:80%;">Subtotal</td>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:7.5%;">'.number_format(round($sum_abonos, 2), 2 ,'.',',').'</td>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:7.5%;">'.number_format(round($sum_cargos, 2), 2 ,'.',',').'</td>
                    </tr>';
                    
                    $array_totalizador[$count_totalizador] = array(
                        "descrip" =>  strtoupper($forms->descrip),
                        "abonos" =>  $sum_abonos,
                        "cargos" =>  $sum_cargos,
                    );
                    $count_totalizador++;
                }
                $estructura .='
                    <tr><td><br><br></td></tr>
                    <tr>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:75%;"></td>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:10%;border-bottom:1px solid black;">Abonos</td>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:10%;border-bottom:1px solid black;">Cargos</td>
                    </tr>';
                $grandtotal_abono = 0;
                $grandtotal_cargos = 0;
                for($i = 0; $i<$count_totalizador;$i++){
                    $dat = $array_totalizador[$i];
                    $estructura .='
                    <tr>
                    <td style="font-weight:bold;font-size:11px; text-align:right;width:75%;">'.$dat['descrip'].'</td>
                    <td style="font-weight:bold;font-size:11px; text-align:right;width:10%;">'.number_format(round($dat['abonos'], 2), 2 ,'.',',').'</td>
                    <td style="font-weight:bold;font-size:11px; text-align:right;width:10%;">'.number_format(round($dat['cargos'], 2), 2 ,'.',',').'</td>
                    </tr>'; 
                    $grandtotal_abono+=$dat['abonos'];
                    $grandtotal_cargos+=$dat['cargos'];
                }
                
                $estructura .='
                <tr>
                    <td style="font-weight:bold;font-size:11px; text-align:right;width:75%;"></td>
                    <td style="font-weight:bold;font-size:12px; text-align:right;width:10%;border-top:1px solid black;">'.number_format(round($grandtotal_abono, 2), 2 ,'.',',').'</td>
                    <td style="font-weight:bold;font-size:12px; text-align:right;width:10%;border-top:1px solid black;">'.number_format(round($grandtotal_cargos, 2), 2 ,'.',',').'</td>
                </tr>'; 
                
                $estructura.='</tbody></table>';
                $pdf->writeHTML($estructura, true, false, true, false, '');
				$nombre_archivo = utf8_decode("RecuperacionDiaria.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        
        }
        
		function book01($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Consumidor Final');
                $pdf->SetSubject('Libro de Ventas Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                
                
                
                $header = '
                <table>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td></tr>
                    <tr><td style="text-align:right;font-size:15px;width:40%;">N.I.T.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td><td style="width:20%;"></td><td style="text-align:left;font-size:15px;width:40%;">N.R.C.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
               </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('P', 'LETTER');
                $estructura = '<br><br><br><table>';
                $estructura .= '<thead><tr>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Día</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:21%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Tipo de Operación</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:12%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Del Número</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:12%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Al Número</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:50%; font-weight:bold; text-align:center; font-size:12px;" colspan="5">VENTAS</th>
                </tr>
                <tr>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">No Sujetas</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Exentas</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Gravadas Locales</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:10.5px;">Exportaciones</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Totales</th>
                </tr></thead>
                <tbody></tbody>';
                $sum_exento=0;
                $sum_gravado=0;
                $sum_total=0;
                $ventas = $this->iva_model->getVentasReporte($fechaini, $fechafin, $idcentro, $formatos);
                
                $fecha_ini=0;
                $fecha_fin=0;
                $idclase_ini=0;
                $estado_ini=0;
                $numserie_ini="";
                $numserie_fin="";
                $cant_docs = 0;
                $numserie_ante = "";
                $tipo_doc_ant = "";
                
                foreach($ventas as $vn){
                    
                    $exento=0;
                    $gravado=0;
                    if($vn->exento==1){
                        $exento = $vn->valventan;
                    }else{
                        $gravado = $vn->valventan+$vn->valtax1;
                    }
                    
                    $sum_exento+=$exento;
                    $sum_gravado+=$gravado;
                    $sum_total+= $exento+$gravado;
                    $dia = date_format(date_create($vn->fecha),'d');
                    
                    if($cant_docs==0){
                        $fecha_ini = $dia;
                        $idclase_ini = $vn->idclase;
                        $numserie_ini = $vn->numeroserie;
                        $numserie_ante = $vn->numeroserie;
                        $exento_sum_idclase = 0;
                        $gravado_sum_idclase = 0;
                        $exento_sum_idclase += $exento;
                        $gravado_sum_idclase += $gravado;
                        $numserie_ante = $vn->numeroserie;
                        if($vn->estatus==9){
                            $tipo_doc_ant = "ANULADO";
                        }else{
                            $tipo_doc_ant = $vn->tipodoc;
                        }
                        $estado_ini=$vn->estatus;
                    }else{
                        if($fecha_ini!=$dia || $idclase_ini!=$vn->idclase ||$estado_ini!=$vn->estatus){
                            $estructura.='<tr>
                                <td style="width:5%;text-align:center; font-size:9px;">'.$fecha_ini.'</td>
                                <td style="width:21%;text-align:left; font-size:9px;">'.strtoupper($tipo_doc_ant).'</td>
                                <td style="width:12%;text-align:right; font-size:9px;">'.$numserie_ini.'</td>
                                <td style="width:12%;text-align:right; font-size:9px;">'.$numserie_ante.'</td>
                                <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento_sum_idclase, 2),2).'</td>
                                <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($gravado_sum_idclase, 2),2).'</td>
                                <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento_sum_idclase+$gravado_sum_idclase, 2),2).'</td>
                            </tr>';
                            $fecha_ini = $dia;
                            $idclase_ini = $vn->idclase;
                            $numserie_ini = $vn->numeroserie;
                            $numserie_ante = $vn->numeroserie;
                            if($vn->estatus==9){
                                $tipo_doc_ant = "ANULADO";
                            }else{
                                $tipo_doc_ant = $vn->tipodoc;
                            }
                            $cant_docs==0;
                            $exento_sum_idclase = 0;
                            $gravado_sum_idclase = 0;
                            $exento_sum_idclase += $exento;
                            $gravado_sum_idclase += $gravado;
                            $estado_ini=$vn->estatus;
                        }else{
                            $exento_sum_idclase += $exento;
                            $gravado_sum_idclase += $gravado;
                            $numserie_ante = $vn->numeroserie;
                            if($vn->estatus==9){
                                $tipo_doc_ant = "ANULADO";
                            }else{
                                $tipo_doc_ant = $vn->tipodoc;
                            }
                        }
                    }
                    $cant_docs++;
                }
                $estructura.='<tr>
                    <td style="width:5%;text-align:center; font-size:9px;">'.$fecha_ini.'</td>
                    <td style="width:21%;text-align:left; font-size:9px;">'.strtoupper($tipo_doc_ant).'</td>
                    <td style="width:12%;text-align:right; font-size:9px;">'.$numserie_ini.'</td>
                    <td style="width:12%;text-align:right; font-size:9px;">'.$numserie_ante.'</td>
                    <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                    <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento_sum_idclase, 2),2).'</td>
                    <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($gravado_sum_idclase, 2),2).'</td>
                    <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                    <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento_sum_idclase+$gravado_sum_idclase, 2),2).'</td>
                </tr>';
                $estructura.='
                <tr>
                    <td style="width:5%;text-align:center; font-size:9px;"></td>
                    <td style="width:21%;text-align:left; font-size:9px;"></td>
                    <td style="width:12%;text-align:center; font-size:9px;"></td>
                    <td style="width:12%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>
                    <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;"></td>
                    <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>
                    <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>
                    <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;"></td>
                    <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>
                </tr>';
                $estructura.='</table>';
                
                $estructura .= '<br><br><table style="border-collapse: separate;border-spacing: 10px;">';
                $estructura .= '<thead>
                    <tr>
                        <th style="width: 35%;" ></th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                    </tr>
                </thead>
                <tbody>';
                $sum_exento=0;
                $sum_gravado=0;
                $sum_total=0;
                $sum_ivae=0;
                $sum_ivag=0;
                $sum_dev_exento =0;
                $sum_dev_gravado =0;
                $ventas = $this->iva_model->getVentasReporteT($fechaini, $fechafin, $idcentro, $formatos);
                foreach($ventas as $vn){
                    if($vn->exento==1){
                        if($vn->inopera==-1){
                            $sum_exento+=$vn->valventan;
                            $sum_ivae+=$vn->valtax1;
                        }else{
                            $sum_dev_exento+=$vn->valventan;
                        }
                    }else{
                        if($vn->inopera==-1){
                            $sum_gravado+=$vn->valventan;
                            $sum_ivag+=$vn->valtax1;
                        }else{
                            $sum_dev_gravado+=$vn->valventan;
                        }
                        
                    }
                }
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_dev_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_gravado+$sum_dev_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_gravado+$sum_dev_gravado+$sum_ivag, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_exento+$sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_exento+$sum_dev_exento+$sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                $estructura.='<hr style="width:100%;"><br><hr style="width:100%;">';
                
                $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_dev_gravado+$sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento+$sum_dev_gravado+$sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_ivag+$sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento+$sum_dev_gravado+$sum_dev_exento+$sum_ivag+$sum_ivae, 2),2).'</td>
                </tr>';
                
                 $estructura.='
                 <tr><td colspan="6"><br><br><br><br></td></tr>
                 <tr>
                    <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="4"></td>
                 </tr><tr>
                    <td colspan="2" style="text-align:center;font-size:12px;">'.$nombre_contador.'<br>Contador</td>
                    <td colspan="4"></td>
                 </tr>';
                $estructura.='</table>';
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function book02Original($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Consumidor Final');
                $pdf->SetSubject('Libro de Ventas Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 45, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                $header = '
                <table>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                    <tr><td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td><td colspan="2" style="text-align:right;font-size:14px;width:60%;">N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label></td></tr>
                </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Lanscape');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('L', 'LETTER');
                $estructura = '<table>';
                $estructura .= '<thead><tr>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N°</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">NUMERO CORRELATIVO PRE-IMPRESO</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">FECHA DE EMISIÓN</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:28%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:8%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N.R.C.</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:34%; font-weight:bold; text-align:center; font-size:12px;" colspan="4">VENTAS INTERNAS</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:8%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">VENTAS TOTALES</th>
                </tr>
                <tr>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:11px;">EXENTAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:11px;">NO SUJETAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:11px;">GRAVADAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:10.5px;">DEBITO FISCAL</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:10.5px;">RETENCIÓN</th>
                </tr></thead>
                <tbody></tbody>';
                
                $sum_exento=0;
                $sum_gravado=0;
                $sum_iva=0;
                $sum_total=0;
                $sum_retencion=0;
                $total=0;
                $ventas = $this->iva_model->getVentasReporte($fechaini, $fechafin, $idcentro, $formatos);
                $i=0;
                foreach($ventas as $vn){
                    $i++;    
                    $exento=0;
                    $gravado=0;
                    $iva=0;
                    $retencion=0;
                    if($vn->exento==1){
                        $exento = $vn->valventan;
                    }else{
                        $gravado = $vn->valventan;
                    }
                    $iva = $vn->valtax1;
                    $sum_exento+=$exento;
                    $sum_gravado+=$gravado;
                    $sum_iva+=$iva;
                    
                    
                    if(($vn->idtipo==3) && ($gravado>=100)){
                        $reten = $gravado * 0.01;
                        $retencion = '-'.number_format(round($reten, 2),2);
                        $total= $exento+$gravado+$iva-$reten;
                        $sum_total+= $exento+$gravado+$iva-$reten;
                        $sum_retencion+= $reten;
                    }else{
                        $retencion = 0;
                        $total=$exento+$gravado+$iva;
                        $sum_total+= $exento+$gravado+$iva;
                    }
                        
                    if($retencion == 0){
                        $retencion = "0.00";
                    }else{
                        $retencion = "".number_format(round($retencion, 2), 2 ,'.','');
                    }

                    $estructura.='<tr>
                        <td style="width:5%;text-align:center; font-size:9px;">'.$i.'</td>
                        <td style="width:10%;text-align:left; font-size:9px;">'.strtoupper($vn->numeroserie).'</td>
                        <td style="width:7%;text-align:center; font-size:9px;">'.date_format(date_create($vn->fecha),'d/m/Y').'</td>
                        <td style="width:28%;text-align:left; font-size:9px;">'.$vn->namecliente.'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.$vn->nrc.'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.$retencion.'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($total, 2),2).'</td>
                    </tr>';
                }
                $estructura.='<tr>
                        <td colspan="4" style="width:50%;text-align:center; font-size:9px;"></td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_iva, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$-'.number_format(round($sum_retencion, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>
                    </tr><tr><td colspan="10"><br><br><br></td></tr>';
                
                $estructura.='</table>';
                /*$pdf->writeHTML($estructura, true, 0, false, false, 0);
                $pdf->addPage('L', 'LETTER');*/
                
                $estructura .= '<br><br><br><br><br><br><table style="border-collapse: separate;border-spacing: 1px;">';
                $estructura .= '<thead>
                    <tr>
                        <th style="width: 35%;" ></th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                    </tr>
                </thead>
                <tbody>';
                $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>';
                
                $ventas = $this->iva_model->getVentasReporteCT($fechaini, $fechafin, $idcentro, $formatos);
                
                $cf_sum_exento=0;
                $cf_sum_gravado=0;
                $cf_sum_total=0;
                $cf_sum_ivae=0;
                $cf_sum_ivag=0;
                $cf_sum_dev_g=0;
                $cf_sum_dev_e=0;
                
                $c_sum_exento=0;
                $c_sum_gravado=0;
                $c_sum_total=0;
                $c_sum_ivae=0;
                $c_sum_ivag=0;
                $c_sum_dev_g=0;
                $c_sum_dev_e=0;
                
                foreach($ventas as $vn){
                    if($vn->ivabook==1){
                        if($vn->exento==1){
                            if($vn->inopera==-1){
                                $cf_sum_exento+=$vn->valventan;
                                $cf_sum_ivae+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_e+=$vn->valventan;
                            }
                        }else{
                            if($vn->inopera==-1){
                                $cf_sum_gravado+=$vn->valventan;
                                $cf_sum_ivag+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_g+=$vn->valventan;
                            }
                        }
                    }else if($vn->ivabook==2){
                        if($vn->exento==1){
                            if($vn->inopera==-1){
                                $c_sum_exento+=$vn->valventan;
                                $c_sum_ivae+=$vn->valtax1;
                            }else{
                                $c_sum_dev_e+=$vn->valventan;
                            }
                        }else{
                            
                            if($vn->inopera==-1){
                                $c_sum_gravado+=$vn->valventan;
                                $c_sum_ivag+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_g+=$vn->valventan;
                            }
                        }
                    }
                }
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado+$cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado+$c_sum_ivag, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento+$c_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento+$c_sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                
                $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>';
                
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado+$cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado+$cf_sum_dev_g+$cf_sum_ivag, 2),2).'</td>


                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento+$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento+$cf_sum_dev_e+$cf_sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                
               $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>';
                
                
                $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$c_sum_exento+$cf_sum_gravado+$cf_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($cf_sum_dev_g+$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$c_sum_exento+$cf_sum_gravado+$cf_sum_exento-$cf_sum_dev_g-$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_ivag+$c_sum_ivae+$cf_sum_ivag+$cf_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$cf_sum_gravado+$c_sum_exento+$cf_sum_exento+$cf_sum_dev_g+$cf_sum_dev_e+$c_sum_ivag+$c_sum_ivae+$cf_sum_ivag+$cf_sum_ivae, 2),2).'</td>
                </tr>';
                 $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                 $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                 $estructura.='
                 <tr><td colspan="6"><br><br><br><br></td></tr>
                 <tr>
                    <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="4"></td>
                 </tr><tr>
                    <td colspan="2" style="text-align:center;font-size:12px;">'.$nombre_contador.'<br>Contador</td>
                    <td colspan="4"></td>
                 </tr>';
                $estructura.='</table>';

                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("LibrodeContribuyentes.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function book02($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $fecha = new DateTime();
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $estructura = '<html lang="es"><meta charset="utf-8">
                <style type="text/css">
                    @media print {
                        @page { margin-top: 5px;margin-bottom: 5px;margin-right: 10px;margin-left: 10px; }
                    }
                    .background_color{
                        background: '.$this->session->userdata("FHBackground").';
                        color: '.$this->session->userdata('FHFontColor').';
                    }
                </style>
                <body style="padding:50px;">';
                
                $estructura .= '
                <table>
                    <tr>
                        <td style="width:100%; text-align:left; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td>
                    </tr>
                    <tr>
                        <td style="width:25%;text-align:left;font-size:15px;">'.$RazonSocial.'</td>
                    </tr>
                    <tr>
                        <td style="width:50%;text-align:left;font-size:15px;">NIT.: '.$NIT.'</td>
                    </tr>
                    <tr>
                        <td style="width:50%;text-align:left;font-size:15px;">NRC.: '.$NRC.'</td>
                    </tr>
                    <tr>
                        <td style="width:100%;text-align:left;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                    </tr>
                    <tr>
                        <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;border-rigth:1px solid black">'.$this->session->userdata('nameCentroUser').'</td>
                    </tr>
                    
                </table>';
                $this->load->model('global_model');
                $estructura .= '<table style="padding-bottom:20px">';
                $estructura .= '<thead><tr>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N°</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">NUMERO CORRELATIVO PRE-IMPRESO</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">FECHA DE EMISIÓN</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:28%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:8%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N.R.C.</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:34%; font-weight:bold; text-align:center; font-size:12px;" colspan="5">VENTAS INTERNAS</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:8%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">VENTAS TOTALES</th>
                </tr>
                <tr>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:11px;">EXENTAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:11px;">NO SUJETAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:11px;">GRAVADAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:10.5px;">DEBITO FISCAL</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:10.5px;">RETENCIÓN</th>
                </tr></thead>
                <tbody></tbody>';
                
                $sum_exento=0;
                $sum_gravado=0;
                $sum_iva=0;
                $sum_total=0;
                $sum_retencion=0;
                $total=0;
                $ventas = $this->iva_model->getVentasReporte($fechaini, $fechafin, $idcentro, $formatos);
                $i=0;
                foreach($ventas as $vn){
                    $i++;    
                    $exento=0;
                    $gravado=0;
                    $iva=0;
                    $retencion=0;
                    if($vn->exento==1){
                        $exento = $vn->valventan;
                    }else{
                        $gravado = $vn->valventan;
                    }
                    $iva = $vn->valtax1;
                    $sum_exento+=$exento;
                    $sum_gravado+=$gravado;
                    $sum_iva+=$iva;
                    
                    
                    if(($vn->idtipo==3) && ($gravado>=100)){
                        $reten = $gravado * 0.01;
                        $retencion = '-'.number_format(round($reten, 2),2);
                        $total= $exento+$gravado+$iva-$reten;
                        $sum_total+= $exento+$gravado+$iva-$reten;
                        $sum_retencion+= $reten;
                    }else{
                        $retencion = 0;
                        $total=$exento+$gravado+$iva;
                        $sum_total+= $exento+$gravado+$iva;
                    }
                        
                    if($retencion == 0){
                        $retencion = "0.00";
                    }else{
                        $retencion = "".number_format(round($retencion, 2), 2 ,'.','');
                    }

                    $estructura.='<tr>
                        <td style="width:5%;text-align:center; font-size:9px;">'.$i.'</td>
                        <td style="width:10%;text-align:left; font-size:9px;">'.strtoupper($vn->numeroserie).'</td>
                        <td style="width:7%;text-align:center; font-size:9px;">'.date_format(date_create($vn->fecha),'d/m/Y').'</td>
                        <td style="width:28%;text-align:left; font-size:9px;">'.$vn->namecliente.'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.$vn->nrc.'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.$retencion.'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($total, 2),2).'</td>
                    </tr>';
                }
                $estructura.='<tr>
                        <td colspan="4" style="width:50%;text-align:center; font-size:9px;"></td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_iva, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$-'.number_format(round($sum_retencion, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>
                    </tr><tr><td colspan="10"><br><br><br></td></tr>';
                
                $estructura.='</table>';
                /*$pdf->writeHTML($estructura, true, 0, false, false, 0);
                $pdf->addPage('L', 'LETTER');*/
                
                $sum_exentoCF=0;
                $sum_gravadoCF=0;
                $sum_ivaCF=0;
                $sum_totalCF=0;
                $sum_retencionCF=0;
                $totalCF=0;
                $ventasCF = $this->iva_model->getVentasReporteT($fechaini,$fechafin,$idcentro,9);
                
                foreach($ventasCF as $vnCF){
                            $exentoCF=0;
                            $gravadoCF=0;
                            $ivaCF=0;
                            $retencionCF=0;
                            if($vnCF->exento==1){
                                $exentoCF = $vnCF->exento;
                            }else{
                                $gravadoCF = $vnCF->valventan;
                            }
                            $ivaCF = $vnCF->valtax1;
                            $sum_exentoCF+=$exentoCF;
                            $sum_gravadoCF+=$gravadoCF;
                            $sum_ivaCF+=$ivaCF;


                            if(($vnCF->idtipo==3) && ($gravadoCF>=100)){
                                $retenCF = $gravado * 0.01;
                                $retencionCF = '-'.number_format(round($reten, 2),2);
                                $totalCF= $exentoCF+$gravadoCF+$ivaCF-$retenCF;
                                $sum_totalCF+= $exentoCF+$gravadoCF+$ivaCF-$retenCF;
                                $sum_retencionCF+= $retenCF;
                            }else{
                                $retencionCF = 0;
                                $totalCF=$exentoCF+$gravadoCF+$ivaCF;
                                $sum_totalCF+= $exentoCF+$gravadoCF+$ivaCF;
                            }

                            if($retencionCF == 0){
                                $retencionCF = "0.00";
                            }else{
                                $retencionCF = "".number_format(round($retencionCF, 2), 2 ,'.','');
                            }
                    
                }
                
                $total_sum_exento=$sum_exentoCF+$sum_exento;
                $total_sum_gravado=$sum_gravadoCF+$sum_gravado;
                $total_sum_iva=$sum_ivaCF+$sum_iva;
                $total_sum_total=$sum_totalCF+$sum_total;
                $total_sum_retencion=$sum_retencionCF+$sum_retencion;
                
                $estructura .= '<table style="width:100%">
                    <tr>
                        <td style="width:25%; font-size:12px;font-weight:bold;">RESUMEN DE OPERACIONES:</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;font-weight:bold;" >EXENTAS</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;font-weight:bold;" >EXPORTACIÓN</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;font-weight:bold;" >GRAVADAS</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;font-weight:bold;" >DEBITO FISCAL</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;font-weight:bold;" >TOTAL</td>
                        <td style="border:1px solid balck;width: 15%;font-size:12px;text-align:right;font-weight:bold;" >RETENCIONES</td>
                    </tr>
                        
                    <tr>
                        <td style="width:25%; font-size:12px; text-align:left;border-top:1px solid black;">Ventas a Consumidores Finales:</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round($sum_exentoCF, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round(0, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round($sum_gravadoCF, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round($sum_ivaCF, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round($sum_totalCF, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round($sum_retencionCF, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width:25%; font-size:12px; text-align:left;">Ventas a Contribuyentes:</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;" >$'.number_format(round($sum_exento, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;" >$'.number_format(round(0, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;" >$'.number_format(round($sum_gravado, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;" >$'.number_format(round($sum_iva, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;" >$'.number_format(round($sum_total, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;" >$'.number_format(round($sum_retencion, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width:25%; font-size:14px; text-align:left;font-weight:bold;border-top:1px solid black;">TOTAL DE OPERACIONES</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round($total_sum_exento, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round(0, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round($total_sum_gravado, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round($total_sum_iva, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round($total_sum_total, 2),2).'</td>
                        <td style="border:1px solid balck;width: 13%;font-size:12px;text-align:right;border-top:1px solid black;" >$'.number_format(round($total_sum_retencion, 2),2).'</td>
                    </tr>
                    
                    
                    <tr>
                </table><br><br><br>
                <h5 style="width:25%;border-top:1px solid black;text-align:center;">CONTADOR</h1>
                ';
                 $estructura .="<script type='text/javascript'>window.print();</script>";

                
               echo $estructura;
            }
        }
        
        function book03($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Consumidor Final');
                $pdf->SetSubject('Libro de Ventas Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 45, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                $header = '
                <table>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                    <tr><td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td><td colspan="2" style="text-align:right;font-size:14px;width:60%;">N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label></td></tr>
                </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Lanscape');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('L', 'LETTER');
                $estructura = '<table>';
                $estructura .= '<thead><tr>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N°</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">NUMERO CORRELATIVO PRE-IMPRESO</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">FECHA DE EMISIÓN</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:28%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N.R.C.</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:32%; font-weight:bold; text-align:center; font-size:12px;" colspan="4">VENTAS INTERNAS</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:8%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">VENTAS TOTALES</th>
                </tr>
                <tr>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">EXENTAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">NO SUJETAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">GRAVADAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:10.5px;">DEBITO FISCAL</th>
                </tr></thead>
                <tbody></tbody>';
                
                $sum_exento=0;
                $sum_gravado=0;
                $sum_iva=0;
                $sum_total=0;
                $ventas = $this->iva_model->getComprasContribuyentes($fechaini, $fechafin, $idcentro, $formatos);
                $i=0;
                foreach($ventas as $vn){
                    $i++;    
                    $exento=0;
                    $gravado=0;
                    $iva=0;
                    if($vn->exento==1){
                        $exento = $vn->valventan;
                    }else{
                        $gravado = $vn->valventan;
                    }
                    $iva = $vn->valtax1;
                    $sum_exento+=$exento;
                    $sum_gravado+=$gravado;
                    $sum_iva+=$iva;
                    $sum_total+= $exento+$gravado+$iva;

                    $estructura.='<tr>
                        <td style="width:5%;text-align:center; font-size:9px;">'.$i.'</td>
                        <td style="width:10%;text-align:left; font-size:9px;">'.strtoupper($vn->numeroserie).'</td>
                        <td style="width:7%;text-align:center; font-size:9px;">'.date_format(date_create($vn->fecha),'d/m/Y').'</td>
                        <td style="width:28%;text-align:left; font-size:9px;">'.$vn->namecliente.'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.$vn->nrc.'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($exento+$gravado+$iva, 2),2).'</td>
                    </tr>';
                }
                $estructura.='<tr>
                        <td colspan="4" style="width:50%;text-align:center; font-size:9px;"></td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_iva, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>
                    </tr><tr><td colspan="10"><br><br><br></td></tr>';
                
                $estructura.='</table>';
                /*$pdf->writeHTML($estructura, true, 0, false, false, 0);
                $pdf->addPage('L', 'LETTER');*/
                
                $estructura .= '<br><br><br><br><br><br><table style="border-collapse: separate;border-spacing: 1px;">';
                $estructura .= '<thead>
                    <tr>
                        <th style="width: 35%;" ></th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                    </tr>
                </thead>
                <tbody>';
                $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>';
                
                $ventas = $this->iva_model->getVentasReporteCT($fechaini, $fechafin, $idcentro, $formatos);
                
                $cf_sum_exento=0;
                $cf_sum_gravado=0;
                $cf_sum_total=0;
                $cf_sum_ivae=0;
                $cf_sum_ivag=0;
                $cf_sum_dev_g=0;
                $cf_sum_dev_e=0;
                
                $c_sum_exento=0;
                $c_sum_gravado=0;
                $c_sum_total=0;
                $c_sum_ivae=0;
                $c_sum_ivag=0;
                $c_sum_dev_g=0;
                $c_sum_dev_e=0;
                
                foreach($ventas as $vn){
                    if($vn->ivabook==1){
                        if($vn->exento==1){
                            if($vn->inopera==-1){
                                $cf_sum_exento+=$vn->valventan;
                                $cf_sum_ivae+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_e+=$vn->valventan;
                            }
                        }else{
                            if($vn->inopera==-1){
                                $cf_sum_gravado+=$vn->valventan;
                                $cf_sum_ivag+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_g+=$vn->valventan;
                            }
                        }
                    }else if($vn->ivabook==2){
                        if($vn->exento==1){
                            if($vn->inopera==-1){
                                $c_sum_exento+=$vn->valventan;
                                $c_sum_ivae+=$vn->valtax1;
                            }else{
                                $c_sum_dev_e+=$vn->valventan;
                            }
                        }else{
                            
                            if($vn->inopera==-1){
                                $c_sum_gravado+=$vn->valventan;
                                $c_sum_ivag+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_g+=$vn->valventan;
                            }
                        }
                    }
                }
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado+$cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado+$c_sum_ivag, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento+$c_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento+$c_sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                
                $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>';
                
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado+$cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado+$cf_sum_dev_g+$cf_sum_ivag, 2),2).'</td>


                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento+$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento+$cf_sum_dev_e+$cf_sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                
               $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>';
                
                
                $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$c_sum_exento+$cf_sum_gravado+$cf_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($cf_sum_dev_g+$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$c_sum_exento+$cf_sum_gravado+$cf_sum_exento-$cf_sum_dev_g-$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_ivag+$c_sum_ivae+$cf_sum_ivag+$cf_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$cf_sum_gravado+$c_sum_exento+$cf_sum_exento+$cf_sum_dev_g+$cf_sum_dev_e+$c_sum_ivag+$c_sum_ivae+$cf_sum_ivag+$cf_sum_ivae, 2),2).'</td>
                </tr>';
                 $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                 $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                 $estructura.='
                 <tr><td colspan="6"><br><br><br><br></td></tr>
                 <tr>
                    <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="4"></td>
                 </tr><tr>
                    <td colspan="2" style="text-align:center;font-size:12px;">'.$nombre_contador.'<br>Contador</td>
                    <td colspan="4"></td>
                 </tr>';
                $estructura.='</table>';

                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("LibrodeContribuyentes.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        #   FORMATOS DE FACTURACION
            function creditoFiscalold($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    
                    $this->db->query('SET SQL_BIG_SELECTS=1'); 
                    ini_set('memory_limit', '9999M');
                    ini_set('max_allowed_packet', '9999M');
                    ini_set('max_execution_time', 0);
                    set_time_limit(0);
                    
                    $this->load->library('Pdf');
                    
                    $width = 210; $height = 210;
                    $pagelayout = array($width, $height); 
                    $pdf = new Pdf('Portrait', 'mm', $pagelayout, true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Credito Fiscal');
                    $pdf->SetSubject('Credito Fiscal');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(-14, -25, 0, 0);
                    
                    
                    $pdf->SetHeaderMargin(0);
                    $pdf->SetFooterMargin(0);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 10, '', true);
                    $pdf->SetAutoPageBreak(TRUE, 0);
                    
                    $pdf->setPrintHeader(false);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage('P',$pagelayout);
                    
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                    
                    $tipocliente = 0;
                    
                    foreach($detailPagos as $dtpagos){
                        $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                    }
                    foreach($informacion as $info){
                        $idcps = $info->idcps;
                        $tipocliente = $info->idtipo;
                    }
                    $cant_ = 0;
                    $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                    foreach($infoGzips as $infg){
                        $departamento = trim($infg->depto);
                        $municipio = trim($infg->municipio);
                    }
                    
                    foreach($informacion as $info){
                        
                        
                        $estructura = '
                        <table style="width:100%; padding-top:0px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 16px; width:100%;"><br><br><br><br><br></td>
                            </tr><tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:72%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:14%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:37%; ">'.strtoupper(substr($info->nameCliente, 0, 49)).'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;">'.strtoupper(substr($info->direccion, 0, 44)).'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">Comprobante Credito Fiscal</td>
                                
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; "></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%; ">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:52%;"></td>    
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:30%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$info->numero.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:13%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;">'.strtoupper(substr($info->giro, 0, 47)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:50%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;">'.$info->nit.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:46%;">'.$info->ovnumero.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;">'.substr($info->nrc, 0, 10).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:50%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%;">'.strtoupper(substr($info->nameVendedor, 0, 9)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">'.$payment.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                            </tr>
                        </table>';
                        
                    }
                    $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    
                    $estructura .= '<table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"><br><br></td>
                        </tr>';
                    $total = 0;
                    $totalGravado = 0;
                    $totalExento = 0;
                    $totalIVA = 0;
                    $invexento = $info->exento;
                    $vnExenta = 0;
                    $vnGravada = 0;
                    $numProd = 0;
                    $lineamenosproduct = 0;
                    $lineadescuento = 0;
                    foreach($productos as $pro){
                        if($numProd < $maxlines){
                            if($pro->tax1 != 0 && $invexento == 0){

                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                
                                $vnExenta = "";
                                //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                $conIva= number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                                $sinIva= $conIva / (1+($pro->tax1/100));
                                $vnGravada = number_format(round($sinIva,2), 2,'.','');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1== 0 && $invexento == 0){
                                
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }
                            $ivaSepa = 1+($pro->tax1/100);
                            $preciouni = $pro->preciotran / $ivaSepa;
                            $discount =  ($pro->descuento/100) * $vnGravada;
                            $nombrepro = strtoupper($pro->modelo).'  '.strtoupper($pro->descrip).' '.$pro->notas;
                            $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">'.number_format(abs($pro->cantidad), 2 ,'.','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%;">'.$nombrepro.'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.number_format($preciouni, 4 ,'.','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;  ">'.$vnExenta.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.$vnGravada.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                </tr>
                            ';  
                            
                            if (strlen($nombrepro)>43){
                                $lineamenosproduct++;
                            }
                            
                            if($pro->descuento != 0){
                                $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:31%; ">Descuento</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.number_format($pro->descuento, 0 ,'','').'%</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;  ">-'.number_format(abs($discount), 2 , ',','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; "></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                </tr>
                            ';
                                $lineadescuento++;
                            }
                            
                        }
                        $numProd++;
                    }

                        $Totalineas = ($numProd + $lineamenosproduct + $lineadescuento);
                
                    for($i=$Totalineas; $i<30; $i++){
                        $estructura .= '
                            <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>';
                    }
                    $estructura .= '</table>';
                    
                    if($totalExento == 0){
                        $totalExento = "";
                    }else{
                        $totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
                    }
                    
                    
                    
                    if(($tipocliente==3) && ($totalGravado>=100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = '-'.$reten;
                        $total= $total-$reten;
                    }else{
                        $retencion = 0;
                    }
                        
                    if($retencion == 0){
                        $retencion = "";
                    }else{
                        $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                    }
                    
                    
                    $numero = number_format(round($total, 2), 2 ,'.','');
                    $TotalLetras = $this->convertir_a_letras($numero);
                    $totalGravIva = $totalGravado + $totalIVA;
                    $estructura .= '
                    <table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:40%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$'.number_format(round($totalGravado, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>    
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$'.number_format(round($totalIVA, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>    
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$'.number_format(round($totalGravIva, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>';
                    
                    $estructura .= '<tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$retencion.'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>';
                    
                    $estructura .= '
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.$totalExento.'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                            
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                    </table>';
                    
                    
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    //number_format(round($cantidad, 2),2)
                    //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                    //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
                    $nombre_archivo = utf8_decode("Credito_Fiscal".$trannum.".pdf");
                    $js = 'print(true);';

                    // set javascript
                    $pdf->IncludeJS($js);
                    
                    $pdf->Output($nombre_archivo, 'I');

                }
            }

            function creditoFiscal_v1($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    
                    $this->db->query('SET SQL_BIG_SELECTS=1'); 
                    ini_set('memory_limit', '9999M');
                    ini_set('max_allowed_packet', '9999M');
                    ini_set('max_execution_time', 0);
                    set_time_limit(0);
                    
                    $this->load->library('Pdf');
                    
                    $width = 210; $height = 210;
                    $pagelayout = array($width, $height); 
                    $pdf = new Pdf('Portrait', 'mm', $pagelayout, true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Credito Fiscal');
                    $pdf->SetSubject('Credito Fiscal');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(-14, -25, 0, 0);
                    
                    
                    $pdf->SetHeaderMargin(0);
                    $pdf->SetFooterMargin(0);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 10, '', true);
                    $pdf->SetAutoPageBreak(TRUE, 0);
                    
                    $pdf->setPrintHeader(false);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage('P',$pagelayout);
                    
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                    
                    $tipocliente = 0;
                    
                    foreach($detailPagos as $dtpagos){
                        $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                    }
                    foreach($informacion as $info){
                        $idcps = $info->idcps;
                        $tipocliente = $info->idtipo;
                    }
                    $cant_ = 0;
                    $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                    foreach($infoGzips as $infg){
                        $departamento = trim($infg->depto);
                        $municipio = trim($infg->municipio);
                    }
                    
                    foreach($informacion as $info){
                        
                        
                        $estructura = '
                        <table style="width:100%; padding-top:0px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 16px; width:100%;"><br><br><br><br><br></td>
                            </tr><tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:72%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:14%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:37%; ">'.strtoupper(substr($info->nameCliente, 0, 49)).'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;">'.strtoupper(substr($info->direccion, 0, 44)).'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">Comprobante Credito Fiscal</td>
                                
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:13%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; ">'.$departamento.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:7%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%; ">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:52%;"></td>    
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:30%;">'.$municipio.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$info->numero.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:13%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">'.strtoupper(substr($info->giro, 0, 47)).'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$info->ovnumero.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;">'.$info->nit.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:46%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;">'.substr($info->nrc, 0, 10).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:50%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%;">'.strtoupper(substr($info->nameVendedor, 0, 9)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">'.$payment.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                            </tr>
                        </table>';
                        
                    }
                    $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    
                    $estructura .= '<table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"><br><br></td>
                        </tr>';
                    $total = 0;
                    $totalGravado = 0;
                    $totalExento = 0;
                    $totalIVA = 0;
                    $invexento = $info->exento;
                    $vnExenta = 0;
                    $vnGravada = 0;
                    $numProd = 0;
                    $lineamenosproduct = 0;
                    $lineadescuento = 0;
                    foreach($productos as $pro){
                        if($numProd < $maxlines){
                            if($pro->tax1 != 0 && $invexento == 0){

                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                
                                $vnExenta = "";
                                //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                $conIva= number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                                $sinIva= $conIva / (1+($pro->tax1/100));
                                $vnGravada = number_format(round($sinIva,2), 2,'.','');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1== 0 && $invexento == 0){
                                
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }
                            $ivaSepa = 1+($pro->tax1/100);
                            $preciouni = $pro->preciotran / $ivaSepa;
                            $discount =  ($pro->descuento/100) * $vnGravada;
                            $nombrepro = trim(strtoupper($pro->descrip).' '.$pro->notas);
                            $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                            if($sumacantidad>0){
                                $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');
                            }else{
                                $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                            }
                            
                            $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">'.$cantidadPro.'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.strtoupper(substr($pro->modelo, 0, 13)).'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:21%;">'.substr($nombrepro, 0, 27).'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.number_format($preciouni, 4 ,'.','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;  ">'.$vnExenta.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.$vnGravada.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                </tr>
                            ';  
                            if (strlen($nombrepro)>26){
                            $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:25%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:33%;">'.trim(substr($nombrepro, 27, 25)).'</td>
                                </tr>
                                ';         
                                $lineamenosproduct++;
                            }
                            
                            if($pro->descuento != 0){
                                $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:31%; ">Descuento</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.number_format($pro->descuento, 0 ,'','').'%</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;  ">-'.number_format(abs($discount), 2 , ',','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; "></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                </tr>
                            ';
                                $lineadescuento++;
                            }
                            
                        }
                        $numProd++;
                    }

                        $Totalineas = ($numProd + $lineamenosproduct + $lineadescuento);
                
                    for($i=$Totalineas; $i<30; $i++){
                        $estructura .= '
                            <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>';
                    }
                    $estructura .= '</table>';
                    
                    if($totalExento == 0){
                        $totalExento = "";
                    }else{
                        $totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
                    }
                    
                    
                    
                    if(($tipocliente==3) && ($totalGravado>=100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = '-'.$reten;
                        $total= $total-$reten;
                    }else{
                        $retencion = 0;
                    }
                        
                    if($retencion == 0){
                        $retencion = "";
                    }else{
                        $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                    }
                    
                    
                    $numero = number_format(round($total, 2), 2 ,'.','');
                    $TotalLetras = $this->convertir_a_letras($numero);
                    $totalGravIva = $totalGravado + $totalIVA;
                    $estructura .= '
                    <table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:40%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$'.number_format(round($totalGravado, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$'.number_format(round($totalIVA, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>    
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$'.number_format(round($totalGravIva, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>';
                    
                    $estructura .= '<tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$retencion.'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>';
                    
                    $estructura .= '
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.$totalExento.'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
                        </tr>
                            
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                    </table>';
                    
                    
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    //number_format(round($cantidad, 2),2)
                    //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                    //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
                    $nombre_archivo = utf8_decode("Credito_Fiscal".$trannum.".pdf");
                    $js = 'print(true);';

                    // set javascript
                    $pdf->IncludeJS($js);
                    
                    $pdf->Output($nombre_archivo, 'I');

                }
            }
        
            #   PUMA GICO - OLD
                function creditoFiscalGICO($trannum){
                    if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                        redirect('login/cerrar_sesion');
                    }else{
                        
                        $this->db->query('SET SQL_BIG_SELECTS=1'); 
                        ini_set('memory_limit', '9999M');
                        ini_set('max_allowed_packet', '9999M');
                        ini_set('max_execution_time', 0);
                        set_time_limit(0);
                        $this->load->library('Pdf');
                        $width = 210; $height = 250;//h-210
                        $pagelayout = array($width, $height); 
                        $pdf = new Pdf('Portrait', 'mm', $pagelayout, true, 'UTF-8', false);
                        $pdf->SetCreator(PDF_CREATOR);
                        $pdf->SetAuthor('Versanet Sistemas');
                        $pdf->SetTitle('Credito Fiscal');
                        $pdf->SetSubject('Credito Fiscal');
                        $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                        $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                        $pdf->SetMargins(0, 0, 0, 0);// left top right
                        
                        $pdf->SetHeaderMargin(0);
                        $pdf->SetFooterMargin(0);
                        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                        $pdf->setFontSubsetting(true);
                        $pdf->setPageOrientation('P');
                        $pdf->SetFont('helvetica', '', 9);//$pdf->SetFont('Helvetica', '', 10, '', true);
                        $pdf->SetAutoPageBreak(TRUE, 0);
                        
                        $pdf->setPrintHeader(false);
                        $pdf->setPrintFooter(false);
                        $pdf->addPage('P',$pagelayout);
                        $this->load->model('ventas_model');
                        $this->load->model('invtran_model');
                        $this->load->model('global_model');
                        $informacion = $this->ventas_model->getDatosFactura($trannum);
                        $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                        $tipocliente = 0;
                        foreach($detailPagos as $dtpagos){
                            $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                        }
                        foreach($informacion as $info){
                            $idcps = $info->idcps;
                            $tipocliente = $info->idtipo;
                        }
                        $cant_ = 0;
                        $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                        foreach($infoGzips as $infg){
                            $departamento = trim($infg->depto);
                            $municipio = trim($infg->municipio);
                        }
                        
                        foreach($informacion as $info){        
                            $estructura = '
                                <table style="width: 75%; padding-top:0px;">
                                    <tr><td style="width:100%; line-height: 10px;"></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td style="width: 100%;" ></td></tr>
                                    <tr><td style="width:100%; line-height: 30px;"></td></tr>
                                    <tr>
                                        <td style="width: 70%;" ></td>
                                        <td style="width: 30%; text-align: center; vertical-align:middle; font-weight: normal; font-size: 10px;">'.$info->numero.'</td>
                                    </tr>
                                    <tr><td style="width:100%; line-height: 43px;"></td></tr>
                                    <tr>
                                        <td style="width: 9%; font-size: 9px;" ></td>
                                        <td style="width: 57%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.strtoupper(substr($info->nameCliente, 0, 50)).'</td>
                                        <td style="width: 5%; font-size: 9px;" ></td>
                                        <td style="width: 16%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; ">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 11%; font-size: 10px;" ></td>
                                        <td style="width: 55%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.substr($info->direccion, 0, 50).'</td>
                                        <td style="width: 4%; font-size: 9px;" ></td>
                                        <td style="width: 30%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; ">'.substr($info->nrc, 0, 26).'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 11%; font-size: 10px;" ></td>
                                        <td style="width: 55%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.strtoupper(substr($info->direccion, 50, 100)).'</td>
                                        <td style="width: 4%; font-size: 9px;" ></td>
                                        <td style="width: 30%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; ">'.strtoupper(substr($info->giro, 0, 26)).'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 11%; font-size: 10px;" ></td>
                                        <td style="width: 55%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.$municipio.'</td>
                                        <td style="width: 3%; font-size: 9px;" ></td>
                                        <td style="width: 31%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; ">'.strtoupper(substr($info->nit, 0, 27)).'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 66%; font-size: 10px;" ></td>
                                        <td style="width: 10%; font-size: 9px;" ></td>
                                        <td style="width: 24%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; ">'.substr($payment, 0, 26).'</td>
                                    </tr>
                                    <tr><td style="width:100%; line-height: 25px;"></td></tr>
                                </table>
                                <table style="width: 75%; padding:0px;">
                            ';//substr($info->nrc, 0, 10)
                        }
                        $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);//11
                        $productos = $this->invtran_model->getDataTran100k($trannum);
                        
                        $total = 0;
                        $totalGravado = 0;
                        $totalExento = 0;
                        $totalIVA = 0;
                        $invexento = $info->exento;
                        $vnExenta = 0;
                        $vnGravada = 0;
                        $numProd = 0;
                        $lineamenosproduct = 0;
                        $lineadescuento = 0;
                        foreach($productos as $pro){
                            if($numProd < $maxlines){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    $vnExenta = "";
                                    //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                    $conIva= number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                                    $sinIva= $conIva / (1+($pro->tax1/100));
                                    $vnGravada = number_format(round($sinIva,2), 4,'.','');
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 4 ,'.','');
                                    $vnGravada = "";
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 4 ,'.','');
                                    $vnGravada = "";
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 4 ,'.','');
                                    $vnGravada = "";
                                }
                                $ivaSepa = 1+($pro->tax1/100);
                                $preciouni = $pro->preciotran / $ivaSepa;
                                $discount =  ($pro->descuento/100) * $vnGravada;
                                $nombrepro = trim(strtoupper($pro->descrip).' '.$pro->notas);
                                $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                                if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                                else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                                $estructura .= '
                                    <tr style="width:100%; padding:0px;">
                                        <td style="width: 4%; text-align: center; vertical-align:middle; font-weight: normal; font-size: 9px;" ></td>
                                        <td style="width: 14%; text-align: center; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.$cantidadPro.'</td>
                                        <td style="width: 35%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.substr($nombrepro, 0, 31).'</td>
                                        <td style="width: 12.5%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.number_format($preciouni, 4 ,'.','').'</td>
                                        <td style="width: 9%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" ></td>
                                        <td style="width: 9%;text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.$vnExenta.'</td>
                                        <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.$vnGravada.'</td>
                                    </tr>
                                ';  
                                if (strlen($nombrepro)>31){
                                    $estructura .= '
                                        <tr style="width:100%; padding:0px;">
                                            <td style="width: 18%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;"></td>
                                            <td style="width: 35%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.trim(substr($nombrepro, 31, 60)).'</td>
                                        </tr>
                                    ';         
                                    $lineamenosproduct++;
                                }
                                
                                if($pro->descuento != 0){
                                    $estructura .= '
                                        <tr style="width:100%; padding:0px;">
                                            <td style="width: 18%; font-size: 10px;" ></td>
                                            <td style="width: 35%; text-align: center; vertical-align:middle; font-weight: normal; font-size: 9px;">Descuento</td>
                                            <td style="width: 12.5%; font-size: 10px;" ></td>
                                            <td style="width: 9%; text-align: center; vertical-align:middle; font-weight: normal; font-size: 9px; ">'.number_format($pro->descuento, 0 ,'','').'%</td>
                                            <td style="width: 9%; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px;"></td>
                                            <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;  ">-'.number_format(abs($discount), 4 , ',','').'</td>
                                        </tr>
                                    ';
                                    $lineadescuento++;
                                }
                            }
                            $numProd++;
                        }
                        $Totalineas = ($numProd + $lineamenosproduct + $lineadescuento);
                        for($i=$Totalineas; $i< $maxlines; $i++){
                            $estructura .= '
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                            ';
                        }
                        $estructura .= '</table>';
                        
                        if($totalExento == 0) $totalExento = "";	
                        else $totalExento = "$".number_format(round($totalExento, 2), 4,'.','');
                        
                        if(($tipocliente==3) && ($totalGravado>=100)){
                            $reten = $totalGravado * 0.01;
                            $retencion = '-'.$reten;
                            $total= $total-$reten;
                        } else $retencion = 0;
                            
                        if($retencion == 0) $retencion = "";    
                        else $retencion = "$".number_format(round($retencion, 2), 4 ,'.','');
                        
                        $numero = number_format(round($total, 2), 2 ,'.','');
                        $TotalLetras = $this->valorEnLetras($numero).'/DOLARES';
                        $totalGravIva = $totalGravado + $totalIVA;
                        $estructura .= '
                            <table style="width: 75%; padding:0px;">
                                <tr><td style="width:100%; line-height: 8px;"></td></tr>
                                <tr>
                                    <td style="width: 8%; font-size: 9px;" ></td>
                                    <td style="width: 49%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.substr(strtoupper($TotalLetras), 0,44).'</td>
                                    <td style="width: 8%; font-size: 9px;" ></td>
                                    <td style="width: 9%; font-size: 9px;" ></td>
                                    <td style="width: 9%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" ></td>
                                    <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >$'.number_format(round($totalGravado, 2), 4 ,'.','').'</td>
                                </tr>
                                <tr>
                                    <td style="width: 5%; font-size: 9px;" ></td>
                                    <td style="width: 52%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.substr(strtoupper($TotalLetras), 44,88).'</td>
                                    <td style="width: 8%; font-size: 9px;" ></td>
                                    <td style="width: 9%; font-size: 9px;" ></td>
                                    <td style="width: 9%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" ></td>
                                    <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >$'.number_format(round($totalIVA, 2), 4 ,'.','').'</td>
                                </tr>
                                <tr><td style="width: 100%; font-size: 10px;" ></td></tr>
                                <tr>
                                    <td style="width: 83%; font-size: 9px;" ></td>
                                    <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.$totalExento.'</td>
                                </tr>
                                <tr><td style="width: 100%; font-size: 18px;" ></td></tr>
                                <tr>
                                    <td style="width: 83%; font-size: 9px;" ></td>
                                    <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.$retencion.'</td>
                                </tr>
                                <tr>
                                    <td style="width: 83%; font-size: 9px;" ></td>
                                    <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >$'.number_format(round($total, 2), 4 ,'.','').'</td>
                                </tr>
                            </table>
                        ';
                        $pdf->writeHTML($estructura, true, 0, false, false, 0);
                        //number_format(round($cantidad, 2),2)
                        //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                        //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
                        $nombre_archivo = utf8_decode("Credito_Fiscal".$trannum.".pdf");
                        $js = 'print(true);';
                        // set javascript
                        $pdf->IncludeJS($js);
                        $pdf->Output($nombre_archivo, 'I');
                    }
                }
                function facturaConsumidorFinalGICO($trannum){
                    if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                        redirect('login/cerrar_sesion');
                    }else{
                        
                        $this->db->query('SET SQL_BIG_SELECTS=1'); 
                        ini_set('memory_limit', '9999M');
                        ini_set('max_allowed_packet', '9999M');
                        ini_set('max_execution_time', 0);
                        set_time_limit(0);
                        
                        $this->load->library('Pdf');
                        $width = 210; $height = 250;
                        $pagelayout = array($width, $height);
                        $pdf = new Pdf('Portrait', 'mm', 'Portrait', true, 'UTF-8', false);
                        $pdf->SetCreator(PDF_CREATOR);
                        $pdf->SetAuthor('Versanet Sistemas');
                        $pdf->SetTitle('Factura Consumir Final');
                        $pdf->SetSubject('Factura Consumir Final');
                        $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                        $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                        $pdf->SetMargins(0, 0, 0, 0);// left top right
                        
                        $pdf->SetHeaderMargin(0);
                        $pdf->SetFooterMargin(0);
                        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                        $pdf->setFontSubsetting(true);
                        $pdf->setPageOrientation('P');
                        $pdf->SetFont('Helvetica', '', 10, '', true);
                        $pdf->SetAutoPageBreak(TRUE, 0);
                        
                        $pdf->setPrintHeader(false);
                        $pdf->setPrintFooter(false);
                        $pdf->addPage('P',$pagelayout);
                        
                        $this->load->model('ventas_model');
                        $this->load->model('invtran_model');
                        $this->load->model('global_model');
                        $informacion = $this->ventas_model->getDatosFactura($trannum);
                        $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);				
                        $tipocliente = 0;                
                        foreach($detailPagos as $dtpagos){
                            $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                        }
                        foreach($informacion as $info){
                            $idcps = $info->idcps;
                            $tipocliente = $info->idtipo;
                        }
                        $cant_ = 0;
                        $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                        foreach($infoGzips as $infg){
                            $departamento = trim($infg->depto);
                            $municipio = trim($infg->municipio);
                        }
                        foreach($informacion as $info){
                            
                            if($info->idcliente != 325) { $nombreCliente = strtoupper(substr($info->nameCliente, 0, 49));} 
                            else if(($info->idcliente == 325) && (empty($info->notas))) { $nombreCliente = strtoupper(substr($info->nameCliente, 0, 49)); } 
                            else $nombreCliente = $info->notas;

                            $estructura = '
                                <table style="width: 75%; padding-top:0px;">
                                    <tr><td style="width:100%; line-height: 10px;"></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td style="width: 100%;" ></td></tr>
                                    <tr><td style="width:100%; line-height: 30px;"></td></tr>
                                    <tr>
                                        <td style="width: 70%;" ></td>
                                        <td style="width: 30%; text-align: center; vertical-align:middle; font-weight: normal; font-size: 10px;">'.$info->numero.'</td>
                                    </tr>
                                    <tr><td style="width:100%; line-height: 40px;"></td></tr>
                                    <tr>
                                        <td style="width: 8%; font-size: 9px;" ></td>
                                        <td style="width: 58%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.strtoupper(substr($info->nameCliente, 0, 51)).'</td>
                                        <td style="width: 4%; font-size: 9px;" ></td>
                                        <td style="width: 16%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; ">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 11%; font-size: 10px;" ></td>
                                        <td style="width: 55%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.strtoupper(substr($info->direccion, 0, 44)).'</td>
                                        <td style="width: 3%; font-size: 9px;" ></td>
                                        <td style="width: 31%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.strtoupper(substr($info->nrc, 0, 27)).'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 11%; font-size: 10px;" ></td>
                                        <td style="width: 55%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.strtoupper(substr($info->direccion, 44, 88)).'</td>
                                        <td style="width: 3%; font-size: 9px;" ></td>
                                        <td style="width: 31%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.strtoupper(substr($info->giro, 0, 27)).'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 11%; font-size: 10px;" ></td>
                                        <td style="width: 55%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.strtoupper(substr($municipio, 44, 88)).'</td>
                                        <td style="width: 3%; font-size: 9px;" ></td>
                                        <td style="width: 31%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.strtoupper(substr($info->nit, 0, 27)).'</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 11%; font-size: 10px;" ></td>
                                        <td style="width: 55%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;"></td>
                                        <td style="width: 9%; font-size: 9px;" ></td>
                                        <td style="width: 25%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.strtoupper(substr($payment, 0, 22)).'</td>
                                    </tr>
                                    <tr><td style="width:100%; line-height: 28px;"></td></tr>
                                </table>
                                <table style="width: 75%; padding:0px;">
                            ';
                        }
                        $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);//20
                        $productos = $this->invtran_model->getDataTran100k($trannum);
                        $total = 0; $totalGravado = 0; $totalExento = 0;
                        $totalIVA = 0;
                        $invexento = $info->exento;
                        $vnExenta = 0;
                        $vnGravada = 0;
                        $numProd = 0;
                        $lineamenosproduct = 0;
                        $lineadescuento = 0;
                        foreach($productos as $pro){
                            if($numProd < $maxlines){
                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    
                                    $vnExenta = "";
                                    //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 4), 2 ,'.','');
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "";
                                    
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "";
                                    
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    
                                    $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "";
                                    
                                }
                                
                                $preciouni = $pro->preciotran;
                                $discount =  ($pro->descuento/100) * $vnGravada;
                                $nombrepro = strtoupper($pro->descrip).' '.$pro->notas;
                                $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                                if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                                else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                                $estructura .= '
                                    <tr style="width:100%; padding:0px;">
                                        <td style="width: 3.5%; text-align: center; vertical-align:middle; font-weight: normal; font-size: 9px;" ></td>
                                        <td style="width: 14%; text-align: center; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.$cantidadPro.'</td>
                                        <td style="width: 35%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.substr($nombrepro, 0, 31).'</td>
                                        <td style="width: 12.5%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.number_format($preciouni, 2 ,'.','').'</td>
                                        <td style="width: 9%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" ></td>
                                        <td style="width: 9%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.$vnExenta.'</td>
                                        <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.$vnGravada.'</td>
                                    </tr>
                                ';  
                                if (strlen($nombrepro)>31){
                                    $estructura .= '
                                        <tr style="width:100%; padding:0px;">
                                            <td style="width: 17.5%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;"></td>
                                            <td style="width: 35%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.trim(substr($nombrepro, 31, 60)).'</td>
                                        </tr>
                                    ';         
                                    $lineamenosproduct++;
                                }
                                
                                if($pro->descuento != 0){
                                    $estructura .= '
                                        <tr style="width:100%; padding:0px;">
                                            <td style="width: 17.5%; font-size: 10px;" ></td>
                                            <td style="width: 35%; text-align: center; vertical-align:middle; font-weight: normal; font-size: 9px;">Descuento</td>
                                            <td style="width: 12.5%; font-size: 10px;" ></td>
                                            <td style="width: 9%; text-align: center; vertical-align:middle; font-weight: normal; font-size: 9px; ">'.number_format($pro->descuento, 0 ,'','').'%</td>
                                            <td style="width: 9%; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px;"></td>
                                            <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;  ">-'.number_format(abs($discount), 2 , ',','').'</td>
                                        </tr>
                                    ';
                                    $lineadescuento++;
                                }
                            }
                            $numProd++;
                        }
                        
                        $Totalineas = ($numProd + $lineamenosproduct + $lineadescuento);
                    
                        for($i=$Totalineas; $i<$maxlines; $i++){
                            $estructura .= '
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                                </tr>
                            ';
                        }
                        $estructura .= '</table>';
                        if($totalExento == 0) $totalExento = "";
                        else $totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');			
                        
                        if($tipocliente==3){
                            $reten = $totalGravado * 0.01;
                            $retencion = '-'.$reten;
                            $total= $total-$reten;
                        } else $retencion = 0;
                        if($retencion == 0) $retencion = "";
                        else $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                                        
                        $numero = number_format(round($total, 2), 2 ,'.','');
                        $TotalLetras = $this->valorEnLetras($numero);
                        $totalGravIva = $totalGravado + $totalIVA;
                        $estructura .= '
                            <table style="width: 75%; padding:0px;">
                                <tr>
                                    <td style="width: 8%; font-size: 9px;" ></td>
                                    <td style="width: 57%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.substr(strtoupper($TotalLetras), 0,50).'</td>
                                    <td style="width: 9%; font-size: 9px;" ></td>
                                    <td style="width: 9%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" ></td>
                                    <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >$'.number_format(round($totalGravIva, 2), 2,'.','').'</td>
                                </tr>
                                <tr>
                                    <td style="width: 5%; font-size: 9px;" ></td>
                                    <td style="width: 60%; text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px;">'.substr(strtoupper($TotalLetras), 50,100).'</td>
                                    <td style="width: 9%; font-size: 9px;" ></td>
                                    <td style="width: 9%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" ></td>
                                    <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" ></td>
                                </tr>
                                <tr><td style="width:100%; line-height: 25px;"></td></tr>
                                <tr>
                                    <td style="width: 83%; font-size: 9px;" ></td>
                                    <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >'.$totalExento.'</td>
                                </tr>
                                <tr><td style="width:100%; line-height: 10px;"></td></tr>
                                <tr>
                                    <td style="width: 83%; font-size: 9px;" ></td>
                                    <td style="width: 16%; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px;" >$'.number_format(round($total, 2), 2,'.','').'</td>
                                </tr>
                            </table>
                        ';
                        
                        $pdf->writeHTML($estructura, true, 0, false, false, 0);
                        //number_format(round($cantidad, 2),2)
                        //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                        //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
                        $nombre_archivo = utf8_decode("FacturaConsumidorFinal".$trannum.".pdf");
                        $js = 'print(true);';
                        // set javascript
                        $pdf->IncludeJS($js);				
                        $pdf->Output($nombre_archivo, 'I');
                    }
                }
            #-
            function notaDeCreditoGICO($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    
                    $this->db->query('SET SQL_BIG_SELECTS=1'); 
                    ini_set('memory_limit', '9999M');
                    ini_set('max_allowed_packet', '9999M');
                    ini_set('max_execution_time', 0);
                    set_time_limit(0);
                    
                    $this->load->library('Pdf');
                    
                    $width = 210; $height = 210;
                    $pagelayout = array($width, $height); 
                    $pdf = new Pdf('Portrait', 'mm', $pagelayout, true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Nota de Credito');
                    $pdf->SetSubject('Nota de Credito');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(-14, -25, 0, 0);
                    
                    
                    $pdf->SetHeaderMargin(0);
                    $pdf->SetFooterMargin(0);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 10, '', true);
                    $pdf->SetAutoPageBreak(TRUE, 0);
                    
                    $pdf->setPrintHeader(false);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage('P',$pagelayout);
                    
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                    
                    $tipocliente = 0;
                    
                    foreach($detailPagos as $dtpagos){
                        $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                    }
                    foreach($informacion as $info){
                        $idcps = $info->idcps;
                        $tipocliente = $info->idtipo;
                    }
                    $cant_ = 0;
                    $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                    foreach($infoGzips as $infg){
                        $departamento = trim($infg->depto);
                        $municipio = trim($infg->municipio);
                    }
                    
                    foreach($informacion as $info){
                        
                        
                        $estructura = '
                        <table style="width:100%; padding-top:0px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 16px; width:100%;"><br><br><br><br><br></td>
                            </tr><tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:72%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:14%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:37%; ">'.strtoupper(substr($info->nameCliente, 0, 49)).'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;">'.strtoupper(substr($info->direccion, 0, 44)).'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">Nota de Credito</td>
                                
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:13%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; ">'.$departamento.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:7%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%; ">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:52%;"></td>    
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:30%;">'.$municipio.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$info->numero.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:13%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">'.strtoupper(substr($info->giro, 0, 47)).'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$info->ovnumero.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;">'.$info->nit.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:46%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;">'.substr($info->nrc, 0, 10).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:50%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%;">'.strtoupper(substr($info->nameVendedor, 0, 9)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                            </tr>
                        </table>';
                        
                    }
                    $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    
                    $estructura .= '<table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"><br><br></td>
                        </tr>';
                    $total = 0;
                    $totalGravado = 0;
                    $totalExento = 0;
                    $totalIVA = 0;
                    $invexento = $info->exento;
                    $vnExenta = 0;
                    $vnGravada = 0;
                    $numProd = 0;
                    $lineamenosproduct = 0;
                    $lineadescuento = 0;
                    foreach($productos as $pro){
                        if($numProd < $maxlines){
                            if($pro->tax1 != 0 && $invexento == 0){

                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                
                                $vnExenta = "";
                                //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                $conIva= number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                                $sinIva= $conIva / (1+($pro->tax1/100));
                                $vnGravada = number_format(round($sinIva,2), 2,'.','');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1== 0 && $invexento == 0){
                                
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }
                            $ivaSepa = 1+($pro->tax1/100);
                            $preciouni = $pro->preciotran / $ivaSepa;
                            $discount =  ($pro->descuento/100) * $vnGravada;
                            $nombrepro = trim(strtoupper($pro->descrip).' '.$pro->notas);
                            $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                            if($sumacantidad>0){
                                $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');
                            }else{
                                $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                            }
                            
                            $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">-'.$cantidadPro.'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.strtoupper(substr($pro->modelo, 0, 13)).'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:21%;">'.substr($nombrepro, 0, 27).'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">-'.number_format($preciouni, 4 ,'.','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;  ">'.$vnExenta.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">-'.$vnGravada.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                </tr>
                            ';  
                            if (strlen($nombrepro)>26){
                            $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:25%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:33%;">'.trim(substr($nombrepro, 27, 25)).'</td>
                                </tr>
                                ';         
                                $lineamenosproduct++;
                            }
                            
                            if($pro->descuento != 0){
                                $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:31%; ">Descuento</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.number_format($pro->descuento, 0 ,'','').'%</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;  ">-'.number_format(abs($discount), 2 , ',','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; "></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                </tr>
                            ';
                                $lineadescuento++;
                            }
                            
                        }
                        $numProd++;
                    }

                        $Totalineas = ($numProd + $lineamenosproduct + $lineadescuento);
                
                    for($i=$Totalineas; $i<30; $i++){
                        $estructura .= '
                            <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>';
                    }
                    $estructura .= '</table>';
                    
                    if($totalExento == 0){
                        $totalExento = "";
                    }else{
                        $totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
                    }
                    
                    
                    
                    if(($tipocliente==3) && ($totalGravado>=100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = '-'.$reten;
                        $total= $total-$reten;
                    }else{
                        $retencion = 0;
                    }
                        
                    if($retencion == 0){
                        $retencion = "";
                    }else{
                        $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                    }
                    
                    
                    $numero = number_format(round($total, 2), 2 ,'.','');
                    $TotalLetras = $this->convertir_a_letras($numero);
                    $totalGravIva = $totalGravado + $totalIVA;
                    $estructura .= '
                    <table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:40%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$-'.number_format(round($totalGravado, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$-'.number_format(round($totalIVA, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>    
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$-'.number_format(round($totalGravIva, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>';
                    
                    $estructura .= '<tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$retencion.'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>';
                    
                    $estructura .= '
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.$totalExento.'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
                        </tr>
                            
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:56%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$-'.number_format(round($total, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                    </table>';
                    
                    
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    //number_format(round($cantidad, 2),2)
                    //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                    //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
                    $nombre_archivo = utf8_decode("NotaDeCredito".$trannum.".pdf");
                    $js = 'print(true);';

                    // set javascript
                    $pdf->IncludeJS($js);
                    
                    $pdf->Output($nombre_archivo, 'I');

                }
            }
            
            function devolucionFacturaConsumidorFinalGICO($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    
                    $this->db->query('SET SQL_BIG_SELECTS=1'); 
                    ini_set('memory_limit', '9999M');
                    ini_set('max_allowed_packet', '9999M');
                    ini_set('max_execution_time', 0);
                    set_time_limit(0);
                    
                    $this->load->library('Pdf');
                    $width = 210; $height = 210;
                    $pagelayout = array($width, $height);
                    $pdf = new Pdf('Portrait', 'mm', 'Portrait', true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Devolucion Consumir Final');
                    $pdf->SetSubject('Devolucion Consumir Final');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(-14, -25, 0, 0);
                    
                    $pdf->SetHeaderMargin(0);
                    $pdf->SetFooterMargin(0);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 10, '', true);
                    $pdf->SetAutoPageBreak(TRUE, 0);
                    
                    $pdf->setPrintHeader(false);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage('P',$pagelayout);
                    
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                    
                    $tipocliente = 0;
                    
                    foreach($detailPagos as $dtpagos){
                        $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                    }
                    foreach($informacion as $info){
                        $idcps = $info->idcps;
                        $tipocliente = $info->idtipo;
                    }
                    $cant_ = 0;
                    $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                    foreach($infoGzips as $infg){
                        $departamento = trim($infg->depto);
                        $municipio = trim($infg->municipio);
                    }
                    
                    foreach($informacion as $info){
                        
                        if(empty($info->direccion)){
                            $newMunicipio="";
                            $newDepartamento="";
                        }else{
                            $newMunicipio=$municipio;
                            $newDepartamento=$departamento;
                        }
                        
                        if($info->idcliente != 302){
                            $nombreCliente = strtoupper(substr($info->nameCliente, 0, 49));
                        }else{
                            $nombreCliente = $info->notas;
                        }
                        
                        $estructura = '
                        <table style="width:100%; padding-top:0px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 16px; width:100%;"><br><br><br><br><br></td>
                            </tr><tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:72%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 7px; width:100%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:37%; ">'.$nombreCliente.'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">Factura Consumidor Final</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:14%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;">'.strtoupper(substr($info->direccion, 0, 46)).'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; "></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%; ">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:52%;"></td>    
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:30%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$info->numero.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;">'.strtoupper(substr($info->giro, 0, 47)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:50%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;">'.$info->nit.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:46%;">'.$info->ovnumero.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;">'.substr($info->nrc, 0, 10).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:50%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:42%;">'.strtoupper(substr($info->nameVendedor, 0, 9)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">'.$payment.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                            </tr>
                        </table>';
                        
                    }
                    $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    $estructura .= '<table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"><br><br></td>
                        </tr>';
                    $total = 0; $totalGravado = 0; $totalExento = 0;
                    $totalIVA = 0;
                    $invexento = $info->exento;
                    $vnExenta = 0;
                    $vnGravada = 0;
                    $numProd = 0;
                    $lineamenosproduct = 0;
                    $lineadescuento = 0;
                    foreach($productos as $pro){
                        if($numProd < $maxlines){
                            if($pro->tax1 != 0 && $invexento == 0){

                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                
                                $vnExenta = "";
                                //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 4), 2 ,'.','');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1== 0 && $invexento == 0){
                                
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }
                            
                            $preciouni = $pro->preciotran;
                            $discount =  ($pro->descuento/100) * $vnGravada;
                            $nombrepro = strtoupper($pro->modelo).' '.strtoupper($pro->descrip).' '.$pro->notas;
                            $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;" colspan ="2" >-'.number_format(abs($pro->cantidad), 2 ,'.','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; ">'.$nombrepro.'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">-'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;  ">'.$vnExenta.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">-'.$vnGravada.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                </tr>
                            ';
                            
                            if (strlen($nombrepro)>43){
                                $lineamenosproduct++;
                            }
                                
                            if($pro->descuento != 0){
                                
                                $TotalDescuento=$vnGravada-abs($discount);
                                
                                $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:31%; ">Descuento</td>
                                    
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.number_format($pro->descuento, 0 ,'','').'%</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;  ">-'.number_format(abs($discount), 2 , ',','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; "></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                </tr>
                            ';
                                $lineadescuento++;
                            }
                            
                            $estructura .='    
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                            </tr>';
                        }
                        $numProd++;
                    }
                    
                    $Totalineas = (28 - $lineamenosproduct - $lineadescuento);
                    for($i=$numProd; $i<$Totalineas; $i++){
                        $estructura .= '
                            <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>';
                    }
                    $estructura .= '
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"><br></td>
                        </tr>';
                    
                    $estructura .= '</table>';
                    
                    if($totalExento == 0){
                        $totalExento = "";
                    }else{
                        $totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
                    }
                    
                    
                    if($tipocliente==3){
                        $reten = $totalGravado * 0.01;
                        $retencion = '-'.$reten;
                        $total= $total-$reten;
                    }else{
                        $retencion = 0;
                    }
                    
                    if($retencion == 0){
                        $retencion = "";
                    }else{
                        $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                    }
                    
                    
                    $numero = number_format(round($total, 2), 2 ,'.','');
                    $TotalLetras = $this->valorEnLetras($numero);
                    $totalGravIva = $totalGravado + $totalIVA;
                    $estructura .= '
                    <table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:40%;" rowspan="2">'.strtoupper($TotalLetras).'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$-'.number_format(round($totalGravIva, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>    
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>    
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$-'.number_format(round($totalGravIva, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$retencion.'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.$totalExento.'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        
                            
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">$-'.number_format(round($total, 2), 2 ,'.','').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                    </table>';
                    
                    
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    //number_format(round($cantidad, 2),2)
                    //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                    //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
                    $nombre_archivo = utf8_decode("DevolucionConsumidorFinal".$trannum.".pdf");
                    $js = 'print(true);';

                    // set javascript
                    $pdf->IncludeJS($js);
                    
                    $pdf->Output($nombre_archivo, 'I');

                }
            }
            
            function facturaConsumidorExportacionGICO($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    
                    $this->db->query('SET SQL_BIG_SELECTS=1'); 
                    ini_set('memory_limit', '9999M');
                    ini_set('max_allowed_packet', '9999M');
                    ini_set('max_execution_time', 0);
                    set_time_limit(0);
                    
                    $this->load->library('Pdf');
                    $pdf = new Pdf('Portrait', 'mm', 'Portrait', true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Factura Exportacion');
                    $pdf->SetSubject('Factura Exportacion');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(0, -25, 0,0);
                    
                    $pdf->SetHeaderMargin(0);
                    $pdf->SetFooterMargin(0);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 10, '', true);
                    $pdf->SetAutoPageBreak(TRUE, 0);
                    
                    $pdf->setPrintHeader(false);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage('P','Portrait');
                    
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                    
                    $tipocliente = 0;
                    
                    foreach($detailPagos as $dtpagos){
                        $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                    }
                    foreach($informacion as $info){
                        $idcps = $info->idcps;
                        $tipocliente = $info->idtipo;
                    }
                    $cant_ = 0;
                    $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                    foreach($infoGzips as $infg){
                        $departamento = trim($infg->depto);
                        $municipio = trim($infg->municipio);
                    }
                    
                    foreach($informacion as $info){
                        
                        if(empty($info->direccion)){
                            $newMunicipio="";
                            $newDepartamento="";
                        }else{
                            $newMunicipio=$municipio;
                            $newDepartamento=$departamento;
                        }
                        
                        $estructura = '
                        <table style="width:100%; padding-top:0px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 16px; width:100%;"><br><br><br><br><br></td>
                            </tr><tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"><br></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:72%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:38%; "></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:50%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:14%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:38%;">'.strtoupper(substr($info->nameCliente, 0, 49)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%; ">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:38%;"></td>    
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:30%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$info->numero.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;">'.strtoupper(substr($info->direccion, 0, 46)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:53%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:50%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:24%;">'.$info->nit.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:18%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;">'.substr($info->nrc, 0, 10).'</td>
                                
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 25px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:30%;">'.strtoupper(substr($info->nameVendedor, 0, 9)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:38%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">'.$payment.'</td>
                                
                            </tr>
                        </table>';
                        
                    }
                    $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    $estructura .= '<table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"><br><br></td>
                        </tr>';
                    $total = 0;
                    $totalGravado = 0;
                    $totalExento = 0;
                    $totalIVA = 0;
                    $invexento = $info->exento;
                    $vnExenta = 0;
                    $vnGravada = 0;
                    $numProd = 0;
                    foreach($productos as $pro){
                        if($numProd < $maxlines){
                            if($pro->tax1 != 0 && $invexento == 0){

                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                
                                $vnExenta = "";
                                //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 4), 2 ,'.','');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1== 0 && $invexento == 0){
                                
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }
                            
                            $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100));
                            $nombrepro = substr($pro->descrip, 0, 100);
                            $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">'.number_format(abs($pro->cantidad), 2 ,'.','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:3%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:46%; ">'.strtoupper($pro->modelo).'      '.strtoupper($nombrepro).' '.$pro->notas.'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">'.$vnExenta.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.$vnGravada.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                </tr>
                                
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                            </tr>';
                        }
                        $numProd++;
                    }
                    for($i=$numProd; $i<$maxlines; $i++){
                        $estructura .= '
                            <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>';
                    }
                    $estructura .= '
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"><br></td>
                        </tr>';
                    
                    $estructura .= '</table>';
                    
                    if($totalExento == 0){
                        $totalExento = "";
                    }else{
                        $totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
                    }
                    
                    
                    if($tipocliente==3){
                        $retencion = $totalGravado * 0.10;
                        $total= $total-$retencion;
                    }else{
                        $retencion = 0;
                    }
                    
                    if($retencion == 0){
                        $retencion = "";
                    }else{
                        $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                    }
                    
                    
                    $numero = number_format(round($total, 2), 2 ,'.','');
                    $TotalLetras = $this->convertir_a_letras($numero);
                    $totalGravIva = $totalGravado + $totalIVA;
                    $estructura .= '
                    <table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:40%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>    
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>    
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                            
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                    </table>';
                    
                    
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    //number_format(round($cantidad, 2),2)
                    //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                    //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
                    $nombre_archivo = utf8_decode("FacturaConsumidorFinal".$trannum.".pdf");
                    $js = 'print(true);';

                    // set javascript
                    $pdf->IncludeJS($js);
                    
                    $pdf->Output($nombre_archivo, 'I');

                }
            }
            
            function facturaConsumidorExportacionDevolucionGICO($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    
                    $this->db->query('SET SQL_BIG_SELECTS=1'); 
                    ini_set('memory_limit', '9999M');
                    ini_set('max_allowed_packet', '9999M');
                    ini_set('max_execution_time', 0);
                    set_time_limit(0);
                    
                    $this->load->library('Pdf');
                    $pdf = new Pdf('Portrait', 'mm', 'Portrait', true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Factura Exportacion Devolucion');
                    $pdf->SetSubject('Factura Exportacion Devolucion');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(0, -25, 0,0);
                    
                    $pdf->SetHeaderMargin(0);
                    $pdf->SetFooterMargin(0);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 10, '', true);
                    $pdf->SetAutoPageBreak(TRUE, 0);
                    
                    $pdf->setPrintHeader(false);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage('P','Portrait');
                    
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                    
                    $tipocliente = 0;
                    
                    foreach($detailPagos as $dtpagos){
                        $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                    }
                    foreach($informacion as $info){
                        $idcps = $info->idcps;
                        $tipocliente = $info->idtipo;
                    }
                    $cant_ = 0;
                    $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                    foreach($infoGzips as $infg){
                        $departamento = trim($infg->depto);
                        $municipio = trim($infg->municipio);
                    }
                    
                    foreach($informacion as $info){
                        
                        if(empty($info->direccion)){
                            $newMunicipio="";
                            $newDepartamento="";
                        }else{
                            $newMunicipio=$municipio;
                            $newDepartamento=$departamento;
                        }
                        
                        $estructura = '
                        <table style="width:100%; padding-top:0px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 16px; width:100%;"><br><br><br><br><br></td>
                            </tr><tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"><br></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:72%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:38%; "></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:50%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:14%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:38%;">'.strtoupper(substr($info->nameCliente, 0, 49)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%; ">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:38%;"></td>    
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:30%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$info->numero.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:12%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:35%;">'.strtoupper(substr($info->direccion, 0, 46)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:53%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:39%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:50%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:24%;">'.$info->nit.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:18%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:11%;">'.substr($info->nrc, 0, 10).'</td>
                                
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 25px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:30%;">'.strtoupper(substr($info->nameVendedor, 0, 9)).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:38%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">'.$payment.'</td>
                                
                            </tr>
                        </table>';
                        
                    }
                    $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    $estructura .= '<table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"><br><br></td>
                        </tr>';
                    $total = 0;
                    $totalGravado = 0;
                    $totalExento = 0;
                    $totalIVA = 0;
                    $invexento = $info->exento;
                    $vnExenta = 0;
                    $vnGravada = 0;
                    $numProd = 0;
                    foreach($productos as $pro){
                        if($numProd < $maxlines){
                            if($pro->tax1 != 0 && $invexento == 0){

                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                
                                $vnExenta = "";
                                //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 4), 2 ,'.','');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1== 0 && $invexento == 0){
                                
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                                
                            }
                            
                            $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100));
                            $nombrepro = substr($pro->descrip, 0, 100);
                            $estructura .= '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">-'.number_format(abs($pro->cantidad), 2 ,'.','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:3%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:46%; ">'.strtoupper($pro->modelo).'     '.strtoupper($nombrepro).' '.$pro->notas.'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">-'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">-'.$vnExenta.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; ">'.$vnGravada.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;"></td>
                                </tr>
                                
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                            </tr>';
                        }
                        $numProd++;
                    }
                    for($i=$numProd; $i<$maxlines; $i++){
                        $estructura .= '
                            <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>';
                    }
                    $estructura .= '
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"><br></td>
                        </tr>';
                    
                    $estructura .= '</table>';
                    
                    if($totalExento == 0){
                        $totalExento = "";
                    }else{
                        $totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
                    }
                    
                    
                    if($tipocliente==3){
                        $retencion = $totalGravado * 0.10;
                        $total= $total-$retencion;
                    }else{
                        $retencion = 0;
                    }
                    
                    if($retencion == 0){
                        $retencion = "";
                    }else{
                        $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                    }
                    
                    
                    $numero = number_format(round($total, 2), 2 ,'.','');
                    $TotalLetras = $this->convertir_a_letras($numero);
                    $totalGravIva = $totalGravado + $totalIVA;
                    $estructura .= '
                    <table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:40%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>    
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>    
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">$-'.number_format(round($total, 2), 2 ,'.','').'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:15%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                        </tr>
                            
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:58%;"></td>
                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;"></td>
                        </tr>
                    </table>';
                    
                    
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    //number_format(round($cantidad, 2),2)
                    //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                    //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
                    $nombre_archivo = utf8_decode("FacturaConsumidorFinal".$trannum.".pdf");
                    $js = 'print(true);';

                    // set javascript
                    $pdf->IncludeJS($js);
                    
                    $pdf->Output($nombre_archivo, 'I');

                }
            }
            
            function impresionComprobanteAbono($trannum, $rowIndex){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->library('Pdf');
                    $width = 280; $height = 200;
                    $pagelayout = array($width, $height); 
                    $pdf = new Pdf('Portrait', 'mm', $pagelayout, true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Nota de abono');
                    $pdf->SetSubject('Nota de abono');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(0, 10, 0,0);
                    
                    $pdf->SetHeaderMargin(0);
                    $pdf->SetFooterMargin(0);
                    $pdf->SetAutoPageBreak(TRUE, 0);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('Portrait');
                    $pdf->SetFont('Helvetica', '', 10, '', true);
                    $pdf->SetAutoPageBreak(TRUE, 0);
                    
                    $pdf->setPrintHeader(false);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage('P',$pagelayout);
                
                        date_default_timezone_set('America/El_Salvador');
                    $date = new DateTime();
                    
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                    
                    $this->load->model('ventas_model'); $this->load->model('global_model');
                    $this->load->model('arap_model'); $this->load->model('sucursal_model');
                    
                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                    
                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                    $datosimpresor = explode("/", $datosprint);
                    
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                    
                    $datos = $this->arap_model->getDetalleCuenta_ar($trannum);
                    $factura_principal = $this->arap_model->detailsCuenta_ar($trannum);
                    $transacciones = $this->arap_model->detailsTrans_ar($trannum);
                    
                    $num_factura = 0;
                    $fecha = 0; $fecha_vencimiento = 0;
                    $saldo_inicial = 0; $cargos = 0; $abonos = 0;
                    $saldo_final = 0; $tipodoc = ""; $dias_doc = "";
                    
                    $informacion = $this->ventas_model->getDatosFactura($trannum);                
                    
                    foreach($informacion as $info){
                        $cliente = $info->nameCliente;
                        $direccion = substr($info->direccion, 0,45);
                    }

                    
                    
                    foreach($datos as $dat){
                        $num_factura=$dat->s_n;
                        $fecha=$dat->fechaEmision;
                        $fecha_vencimiento=$dat->fechaVencimiento;
                        $tipodoc = $dat->tipoDoc;
                        $dias_doc = $dat->dias;
                    }
                    
                    $i = 0;
                    $saldo =0;
                    $array_transacciones = array();
                    
                    foreach($factura_principal as $det){
                        $saldo = $det->cargos;
                        $saldo_final = $det->cargos;
                        $saldo_inicial= $det->cargos;
                    }
                    
                    foreach($transacciones as $tran){
                        $saldo += $tran->valor; 
                        $cargo_fact = 0; $abono_fact = 0;
                        
                        if($tran->valor<0){
                            $abonos += abs($tran->valor);
                            $abono_fact = $tran->valor;
                            $saldo_final-=abs($tran->valor);
                        }else{
                            $cargos += $tran->valor;
                            $cargo_fact = $tran->valor;
                            $saldo_final+=abs($tran->valor);
                        }
                        
                        $array_transacciones[$i] = array(
                            "linea" => $tran->itemline,
                            "fecha"=> $tran->fecha,
                            "referencia" => $tran->referencia,
                            "formaPago" => $tran->formaPago,
                            "descripcion" => trim($tran->descrip),
                            "valor" => $tran->valor,
                            "saldo" => $saldo,
                            "trannum" => $det->trannum,   
                            "idrec" => $tran->idrec,   
                            "idvendedor" => $tran->idworker,   
                            "namevendedor" => $tran->namevendedor,   
                            "cajclase" => $tran->cajclase,  
                            "abonos" => abs($abono_fact),   
                            "cargos" => abs($cargo_fact),     
                        );
                        $i++;
                    }
                    
                    $fechaAbono = date_format(date_create($array_transacciones[$rowIndex]['fecha']), 'd/m/Y');
                    $fechaAbonoFile = date_format(date_create($array_transacciones[$rowIndex]['fecha']), 'dmY');
                    
                    if($rowIndex == 0){
                        $saldoAnterior = round($saldo_inicial, 2);
                    }else{
                        $j = $rowIndex - 1;
                        $saldoAnterior = round($array_transacciones[$j]['saldo'], 2);
                    }
                    
                    $saldoActual = $saldoAnterior - $array_transacciones[$rowIndex]['abonos'];
                    
                    
                    $estructura = '
                        <table style="width:100%; padding-top:0px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"><strong>TECNOVIDRI S.A DE C.V 
                                <br> 25 Av. Sur y 4ta. Calle Pte. No. 102 
                                <br> Telefono: 2271-6099 Fax: 2222-1990</strong></td>
                            </tr>
                            
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:75%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">No. '.$num_factura.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 7px; width:100%;"></td>
                            </tr>
                            <tr style="margin-top:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;"><strong>Nombre:</strong> '.substr($cliente, 0, 31).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;"><strong>Fecha:</strong> '.$date->format('d/m/Y').'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:25%;"><strong>Concepto:</strong>'.$array_transacciones[$rowIndex]['descripcion'].'</td>
                            </tr>
                            
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 1px; width:100%;"></td>
                            </tr>
                            
                            ';
                    
                    $estructura.='     
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:95%; padding-top:10px;"><strong>Forma de pago: </strong>'.$array_transacciones[$rowIndex]['formaPago'].'</td> 
                            </tr>
                            ';
                    
                    $numero = number_format(round($array_transacciones[$rowIndex]['abonos'], 2), 2 ,'.','');
                    $TotalLetras = $this->convertir_a_letras($numero);
                    $estructura.='                        
                                                
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; border-bottom: solid 1px black; width:100%;"><hr></td>
                            </tr>
                            
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
                            </tr>
            
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:95%;"><strong>Valor abono en letras:</strong>'.strtoupper($TotalLetras).'/DOLARES</td>
                            </tr>
                            
                            ';
                    
                    $estructura.='
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;" colspan="9"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;" colspan="9"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;" colspan="9"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;" colspan="9"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
                        </tr>';
                    
                    $estructura.='
                    <table style="width:100%; padding:0px;">
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; border-bottom: solid 1px black; width:100%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:40%;"><strong>Total abono: $'.number_format(round($array_transacciones[$rowIndex]['abonos'], 2), 2 ,'.','').'</strong></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:50%;"><strong>Saldo pendiente del cliente: </strong></td>
                            
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:60%;"></td>
                            <td style="text-align:left; border-bottom: solid 1px black; vertical-align:middle; font-weight: normal; font-size: 5px; width:25%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:60%;"></td>
                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:25%;"><strong>por TECNOVIDRI</strong></td>
                        </tr>
                    </table>';
                    
                    //Duplicado
                    
                    
                                
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $nombre_archivo = utf8_decode("creditoFiscal.pdf");
                    $js = 'print(true);';
                    $pdf->IncludeJS($js);
                    $pdf->Output($nombre_archivo, 'I');
                    
                }//cierre else.
            }
            #   FC Y FCF - OLD 2
                function facturaConsumidorFinal_v2($trannum){
                    if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                        redirect('login/cerrar_sesion');
                    }else{
                        
                        $this->load->model('ventas_model');
                        $this->load->model('invtran_model');
                        $this->load->model('global_model');
                        
                        $informacion = $this->ventas_model->getDatosFactura($trannum);
                        $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                        
                        foreach($informacion as $info){
                            
                            $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                            foreach($departamentoMunicipio as $info_dm){
                                $departamento = trim($info_dm->depto);
                                $municipio = trim($info_dm->municipio);
                            }
                            
                            $archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');
                            
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            
                            // $contenidoHeader = '@ 05,40 Say "No.'.$info->numero.'"';
                            // fwrite($archivoTxt, $contenidoHeader);
                            // fwrite($archivoTxt, "\r\n"); 
                            
                            $contenidoHeader = '@ Prow ()+7,00 Say "'.substr($info->nameCliente, 0, 50).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $contenidoHeader = '@ Prow (),58 Say "'.date_format(date_create($info->fecha), 'd/m/Y').'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $contenidoHeader = '@ Prow ()+1,00 Say "'.substr($info->direccion, 0, 50).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");    
                            
                            $contenidoHeader = '@ Prow ()+1,00 Say "'.$municipio.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
        
                            $contenidoHeader = '@ Prow (),55 Say "'.$info->nit.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");	
                        }
                            
                        $contenidoHeader = '@ Prow ()+3,00 SAY ""';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                        $productos = $this->invtran_model->getDataTran100k($trannum);
                        
                        $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                        $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                        $CooNum = 13;
                            
                        foreach($productos as $pro){
                            if($numProd < $maxlines){
                                if($pro->tipotax != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    
                                    $vnExenta = "";
                                    $vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                }else if($pro->tipotax != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        
                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "";
                                }else if($pro->tipotax== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        
                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "";
                                }else if($pro->tipotax == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    
                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "";
                                }
                                
                                $cotExenta = $this->ventas_model->validateDocumentoExentoTran100($trannum);
                                
                                if($cotExenta==1){
                                    $preciouni = $pro->precioneto;
                                }else{
                                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));    
                                }
                                $nombrepro = substr($pro->descrip.' '.$pro->notas, 0, 34);
                                
                                $CooNum++;
                                $contenidoHeader = '@ Prow()+1,00 Say "'.str_pad(abs($pro->cantidad), 4, " ", STR_PAD_LEFT).' '.substr($nombrepro, 0, 34).'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                                
                                $StringPreUni = str_pad(number_format(round($preciouni, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT);
                                
                                $contenidoHeader = '@ Prow(),40 Say "'.$StringPreUni.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                                
                                $StringVnEx = str_pad($vnExenta, 7, " ", STR_PAD_LEFT);
                                
                                $contenidoHeader = '@ Prow(),60 Say "'.$StringVnEx.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                                
                                $StringVnGr = str_pad($vnGravada, 7, " ", STR_PAD_LEFT);
                                                        
                                $contenidoHeader = '@ Prow(),73 Say "'.$StringVnGr.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                            }
                            
                            $numProd++;
                        }
        
                        if($totalExento == 0){
                            $totalExento = "0.00";
                        }else{
                            $totalExento = number_format(round($totalExento, 2), 2 ,'.','');
                        }
                        
                        if($totalGravado == 0){
                            $totalGravado = "0.00";
                        }else{
                            $totalGravado = number_format(round($totalGravado, 2), 2 ,'.','') + $totalIVA;
                        }
                        
                        $numero = number_format(round($total, 2), 2 ,'.','');
                        
                        $TotalLetras = $this->valorEnLetras(trim($numero));
                        
                        $contenidoHeader = '@ 22,00 Say "'.substr(strtoupper($TotalLetras), 0, 49).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ Prow (),74 Say "$'.str_pad(number_format(round($totalGravado, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ Prow () +1,00 Say "'.substr(strtoupper($TotalLetras), 50, 98).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
        
                        //$StringExento = str_pad($totalExento, 7, " ", STR_PAD_LEFT);
                        $contenidoHeader = '@ Prow ()+1,74 Say "$'.str_pad(number_format(round($totalExento, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
        
                        //$StringTot = str_pad($numero, 7, " ", STR_PAD_LEFT);
                        $contenidoHeader = '@ Prow() +1,74 Say "$'.str_pad(number_format(round($numero, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        if($efectivo == 1){
                            $contenidoProductos ='@ Prow(),Pcol() SAY CHR(27)+"p"+Chr(0)+"23"';
                            fwrite($archivoTxt, $contenidoProductos);
                            fwrite($archivoTxt, "\r\n");    
                        }
                        
                        $contenidoHeader = '@ 39,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                
                        $contenidoHeader = '@ 39,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                
                        $contenidoHeader = '@ 39,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 39,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 39,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $docTxt = $info->descrip.$info->numero.".gox";
                        if(file_exists($docTxt)){
                            header('Content-Description: File Transfer');
                            header('Content-Type: application/octet-stream');
                            header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                            header('Expires: 0');
                            header('Cache-Control: must-revalidate');
                            header('Pragma: public');
                            header('Content-Length: ' . filesize($docTxt));
                            readfile($docTxt);                    
                            unlink($docTxt);
                            exit;
                        }
                        
                    }
                } 
                function comprobanteCreditoFiscal_v2($trannum){
                    if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                        redirect('login/cerrar_sesion');
                    }else{
                        $this->load->model('ventas_model');
                        $this->load->model('invtran_model');
                        $this->load->model('global_model');
                        
                        $informacion = $this->ventas_model->getDatosFactura($trannum);
                        $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                        
                        foreach($informacion as $info){
                            $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                            $tipocliente = $info->idtipo;
                            
                            $idClase = $info->idclase;
                            foreach($departamentoMunicipio as $info_dm){
                                $departamento = trim($info_dm->depto);
                                $municipio = trim($info_dm->municipio);
                            }
                            
                            $fechaCredito = date_format(date_create($info->fecha), 'd m y');
                            $partesFecha = explode(" ", $fechaCredito);
                            
                            switch($partesFecha[1]){
                                case 1:
                                    $mes_name = "ENERO";
                                    break;
                                case 2:
                                    $mes_name = "FEBRERO";
                                    break;
                                case 3:
                                    $mes_name = "MARZO";
                                    break;
                                case 4:
                                    $mes_name = "ABRIL";
                                    break;
                                case 5:
                                    $mes_name = "MAYO";
                                    break;
                                case 6:
                                    $mes_name = "JUNIO";
                                    break;
                                case 7:
                                    $mes_name = "JULIO";
                                    break;
                                case 8:
                                    $mes_name = "AGOSTO";
                                    break;
                                case 9:
                                    $mes_name = "SEPTIEMBRE";
                                    break;
                                case 10:
                                    $mes_name = "OCTUBRE";
                                    break;
                                case 11:
                                    $mes_name = "NOVIEMBRE";
                                    break;
                                case 12:
                                    $mes_name = "DICIEMBRE";
                                    break;
                                default:
                                    $mes_name="";
                                    break;
                            }
                                                
                            $archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');
                            
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            
                            $contenidoHeader = '@ Prow ()+6,00 Say "'.substr($info->nameCliente, 0, 50).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $contenidoHeader = '@ Prow (),56 Say "'.$partesFecha[0].'/'.$mes_name.'/'.$partesFecha[2].'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $contenidoHeader = '@ Prow ()+1,00 Say "'.substr($info->direccion, 0, 50).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
        
                            $contenidoHeader = '@ Prow (),56 Say "'.$info->nrc.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
        
                            $contenidoHeader = '@ Prow ()+1,00 Say "'.substr($info->direccion, 51, 100).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
        
                            $contenidoHeader = '@ Prow (),56 Say "'.substr($info->giro, 0, 28).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $contenidoHeader = '@ Prow ()+1,00 Say "'.$departamento.', '.$municipio.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
        
                            $contenidoHeader = '@ Prow (),56 Say "'.$info->nit.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
            
                            foreach($detailPagos as $dtpagos){
                                $contenidoHeader = '@ Prow ()+1,60 Say "'.strtoupper(substr($dtpagos->namePago, 0, 10)).'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                            }
                        }
                        
                        $contenidoHeader = '@ Prow ()+2,00 Say ""';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                            
                        $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);
                        $productos = $this->invtran_model->getDataTran100k($trannum);
                            
                        $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                        $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                            
                        foreach($productos as $pro){
                            if($pro->tax1 != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                
                                $vnExenta = "";
                                $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }else if($pro->tax1== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
        
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }
                            
                            if($numProd < $maxlines){
                                $preciouni = $pro->precioneto;
                                $nombrepro = substr($pro->descrip.' '.$pro->notas, 0, 34);
                                
                                $contenidoHeader = '@ Prow()+1,00 Say "'.str_pad(abs($pro->cantidad), 4, " ", STR_PAD_LEFT).' '.substr($nombrepro, 0, 34).'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                                
                                $StringPreUni = str_pad(number_format(round($preciouni, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT);
                                
                                $contenidoHeader = '@ Prow(),40 Say "'.$StringPreUni.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                                
                                $StringVnEx = str_pad($vnExenta, 7, " ", STR_PAD_LEFT);
                                
                                $contenidoHeader = '@ Prow(),60 Say "'.$StringVnEx.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                                
                                $StringVnGr = str_pad($vnGravada, 7, " ", STR_PAD_LEFT);
                                                        
                                $contenidoHeader = '@ Prow(),73 Say "'.$StringVnGr.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                            }
                            $numProd++;
                        }
                            
                        if($totalExento == 0){
                            $totalExento = "0.00";
                        }else{
                            $totalExento = number_format(round($totalExento, 2), 2 ,'.','');
                        }
                        
                        if($totalGravado == 0){
                            $totalGravado = "0.00";
                        }else{
                            $totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');
                        }
                        
                        if(($tipocliente==3) && ($totalGravado>=100)){
                            $reten = $totalGravado * 0.01;
                            $retencion = '-'.$reten;
                            $total= $total-$reten;
                        }else{
                            $retencion = 0;
                        }
                            
                        if($retencion == 0){
                            $retencion = "$0.00";
                        }else{
                            $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                        }
                        
                        $totalGravIva = $totalGravado + $totalIVA;				
                        $numero = number_format($total, 2 ,'.','');
                        $TotalLetras = $this->valorEnLetras($numero);
                        
                        $contenidoHeader = '@ 21,00 Say "'.substr(strtoupper($TotalLetras), 0, 40).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ Prow (),74 Say "$'.str_pad(number_format(round($totalGravado, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ Prow () +1,00 Say "'.substr(strtoupper($TotalLetras), 41, 80).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ Prow (),74 Say "$'.str_pad(number_format(round($totalIVA, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ Prow ()+1,74 Say "$'.str_pad(number_format(round($totalExento, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ Prow()+1,74 Say "$'.str_pad(number_format(round($retencion, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $ventaTotal = $numero + $totalExento;
                        
                        $contenidoHeader = '@ Prow()+1,74 Say "$'.str_pad(number_format(round($ventaTotal, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        if($efectivo == 1){
                            $contenidoProductos ='@ Prow(),Pcol() SAY CHR(27)+"p"+Chr(0)+"23"';
                            fwrite($archivoTxt, $contenidoProductos);
                            fwrite($archivoTxt, "\r\n");    
                        }
                        
                        $contenidoHeader = '@ 50,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                
                        $contenidoHeader = '@ 50,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                
                        $contenidoHeader = '@ 50,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 50,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 50,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $docTxt = $info->descrip.$info->numero.".gox";
                        if(file_exists($docTxt)){
                            header('Content-Description: File Transfer');
                            header('Content-Type: application/octet-stream');
                            header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                            header('Expires: 0');
                            header('Cache-Control: must-revalidate');
                            header('Pragma: public');
                            header('Content-Length: ' . filesize($docTxt));
                            readfile($docTxt);                    
                            unlink($docTxt);
                            exit;
                        }
                    }
                }
            #-
            #   NUEVOS FORMATOS
                #   PUMA GICO - 2358362
                function facturaConsumidorFinal($trannum){
                    if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                        redirect('login/cerrar_sesion');
                    }else{
                        $this->load->model('ventas_model');
                        $this->load->model('invtran_model');
                        $this->load->model('global_model');
                        
                        $informacion = $this->ventas_model->getDatosFactura($trannum);
                        $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                        #   INFORMACION
                        foreach($informacion as $info){
                            $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                            foreach($departamentoMunicipio as $info_dm){
                                $departamento = trim($info_dm->depto);
                                $municipio = trim($info_dm->municipio);
                            }                
                            $archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');
            
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $contenidoHeader = '@ 07,41 Say "No.: '.$info->numero.' Orden#: '.$trannum.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow()+1,0 Say "'.substr($info->nameCliente, 0, 87).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow()+1,0 Say "'.substr($info->direccion, 0, 52).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow(),59 Say "'.date_format(date_create($info->fecha), 'd/m/Y').'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow()+1,1 Say "'.substr($municipio, 0, 52).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow()+1,0 Say "'.substr($info->nit, 0, 52).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $contenidoHeader = '@ Prow()+2,1 Say " "';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                                        
                            $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
                        }
                        #   PRODUCTOS
                        $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                        $productos = $this->invtran_model->getDataTran100k($trannum);
                        $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                        $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                        $CooNum = 13; $ivaCesc = 0; $cesc = 0; 

                        foreach($productos as $pro){
                            if($numProd < $maxlines){
                                if($pro->tipotax != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    $vnExenta = "";
                                    $vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                }else if($pro->tipotax != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "";
                                }else if($pro->tipotax== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "";
                                }else if($pro->tipotax == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "";
                                }

                                $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                                $nombrepro = substr($pro->descrip, 0, 12).' '.substr($pro->modelo, 0, 12);
                                $CooNum++;

                                $contenidoHeader = '@ Prow()+1,0 Say "'.abs($pro->cantidad).'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");

                                $contenidoHeader = '@ Prow(),6 Say "'.substr($nombrepro,0,35).'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                                
                                $StringPreUni = str_pad(number_format(round($preciouni, 2), 2 ,'.',''), 10, " ", STR_PAD_LEFT);
                                $contenidoHeader = '@ Prow(),43 Say "'.$StringPreUni.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");

                                $StringVnEx = str_pad($vnExenta, 9, " ", STR_PAD_LEFT);
                                $contenidoHeader = '@ Prow(),63 Say "'.$StringVnEx.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");

                                $StringVnGr = str_pad($vnGravada, 14, " ", STR_PAD_LEFT);
                                $contenidoHeader = '@ Prow(),74 Say "'.$StringVnGr.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                            }

                            if($pro->tax1 == 18){
                                $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                                $ivaCesc++;
                            }
                            $numProd++;
                        }
                        #   TOTALES
                        if($totalExento == 0) $totalExento = number_format(round($totalExento, 2), 2 ,'.','');
                        else $totalExento = number_format(round($totalExento, 2), 2 ,'.','');

                        $totalGravIva = $totalGravado + $totalIVA;
                        $totalGravIva = number_format(round($totalGravIva, 2), 2 ,'.','');
                        if($totalGravado == 0) $totalGravado = "";
                        else $totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');

                        #   GRAVADO
                        $numero = number_format(round($total, 2), 2 ,'.','');
                        $TotalLetras = trim($this->valorEnLetras($numero));
                        $contenidoHeader = '@ 23,0 Say "'.substr(strtoupper($TotalLetras), 0, 50).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow(),73 Say "$'.str_pad($totalGravIva, 14, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow()+1,0 Say "'.substr(strtoupper($TotalLetras), 50, 100).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        #   EXENTA
                        $TotalExe = str_pad($totalExento, 14, " ", STR_PAD_LEFT);
                        $contenidoHeader = '@  Prow()+1,73 Say "$'.$TotalExe.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        #   TOTAL
                        $StringTot = str_pad(number_format(round($total, 2), 2 ,'.',''), 14, " ", STR_PAD_LEFT);
                        $contenidoHeader = '@ Prow()+1,73 Say "$'.$StringTot.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        if($efectivo == 1){
                            $contenidoProductos ='@ Prow(),Pcol() SAY CHR(27)+"p"+Chr(0)+"23"';
                            fwrite($archivoTxt, $contenidoProductos);
                            fwrite($archivoTxt, "\r\n");    
                        }

                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                

                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                

                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $docTxt = $info->descrip.$info->numero.".gox";
                        if(file_exists($docTxt)){
                            header('Content-Description: File Transfer');
                            header('Content-Type: application/octet-stream');
                            header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                            header('Expires: 0');
                            header('Cache-Control: must-revalidate');
                            header('Pragma: public');
                            header('Content-Length: ' . filesize($docTxt));
                            readfile($docTxt);                    
                            unlink($docTxt);
                            exit;
                        }
                    }
                }
                #   PUMA GICO - 2358362
                function comprobanteCreditoFiscal($trannum){
                    if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                        redirect('login/cerrar_sesion');
                    }else{
                        $this->load->model('ventas_model');
                        $this->load->model('invtran_model');
                        $this->load->model('global_model');
                        $informacion = $this->ventas_model->getDatosFactura($trannum);
                        $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                        $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                        foreach($detailPagos as $dtpagos){
                            $payment = strtoupper(substr($dtpagos->descrip, 0, 18));
                        }
                        #   INFORMACION
                        foreach($informacion as $info){
                            $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                            $idClase = $info->idclase;
                            $tipocliente = $info->idtipo;
                            foreach($departamentoMunicipio as $info_dm){
                                $departamento = trim($info_dm->depto);
                                $municipio = trim($info_dm->municipio);
                            }
                            $fechaCredito = date_format(date_create($info->fecha), 'd m Y');
                            $partesFecha = explode(" ", $fechaCredito);
                            switch($partesFecha[1]){
                                case 1:
                                    $mes_name = "ENERO";
                                    break;
                                case 2:
                                    $mes_name = "FEBRERO";
                                    break;
                                case 3:
                                    $mes_name = "MARZO";
                                    break;
                                case 4:
                                    $mes_name = "ABRIL";
                                    break;
                                case 5:
                                    $mes_name = "MAYO";
                                    break;
                                case 6:
                                    $mes_name = "JUNIO";
                                    break;
                                case 7:
                                    $mes_name = "JULIO";
                                    break;
                                case 8:
                                    $mes_name = "AGOSTO";
                                    break;
                                case 9:
                                    $mes_name = "SEPTIEMBRE";
                                    break;
                                case 10:
                                    $mes_name = "OCTUBRE";
                                    break;
                                case 11:
                                    $mes_name = "NOVIEMBRE";
                                    break;
                                case 12:
                                    $mes_name = "DICIEMBRE";
                                    break;
                                default:
                                    $mes_name="";
                                    break;
                            }

                            $archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");                    
                            $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ 07,41 Say "No.'.$info->numero.' Orden#: '.$trannum.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ 08,0 Say "'.substr($info->nameCliente, 0, 52).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ 08,61 Say "'.$partesFecha[0].'/'.$partesFecha[1].'/'.$partesFecha[2].'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow()+1,1 Say "'.substr($info->direccion, 0, 51).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow(),60 Say "'.substr($info->nrc, 0, 27).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow()+1,0 Say "'.substr($info->direccion, 0, 52).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow(),60 Say "'.substr($info->giro, 0, 27).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow()+1,0 Say "'.substr($municipio, 0, 52).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow(),60 Say "'.substr($info->nit, 0, 27).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");//11

                            $contenidoHeader = '@ Prow()+1,66 Say "'.substr($payment, 0, 20).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ 13,1 Say " "';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                        }
                        #   PRODUCTOS
                        $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);
                        $productos = $this->invtran_model->getDataTran100k($trannum);
                        $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                        $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                        $ivaCesc = 0; $cesc = 0; 
                        foreach($productos as $pro){
                            if($pro->tax1 != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "";
                                $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }else if($pro->tax1== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }

                            if($numProd < $maxlines){
                                $preciouni = $pro->precioneto;
                                $nombrepro = substr($pro->descrip, 0, 20).' '.substr($pro->modelo, 0, 20);
                                
                                $contenidoHeader = '@ Prow()+1,0 Say "'.abs($pro->cantidad).'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");

                                $contenidoHeader = '@ Prow(),6 Say "'.substr($nombrepro, 0, 35).'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");

                                $StringPreUni = str_pad(number_format(round($preciouni, 4), 4 ,'.',''), 10, " ", STR_PAD_LEFT);                        
                                $contenidoHeader = '@ Prow(),43 Say "'.$StringPreUni.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");

                                $StringVnEx = str_pad($vnExenta, 9, " ", STR_PAD_LEFT);
                                $contenidoHeader = '@ Prow(),63 Say "'.$StringVnEx.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");

                                $StringVnGr = str_pad($vnGravada, 14, " ", STR_PAD_LEFT);
                                $contenidoHeader = '@ Prow(),73 Say "'.$StringVnGr.'"';
                                fwrite($archivoTxt, $contenidoHeader);
                                fwrite($archivoTxt, "\r\n");
                            }
                            if($pro->tax1 == 18){
                                $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                                $ivaCesc++;
                            }
                            $numProd++;
                        }
                        #   TOTALES
                        if($totalExento == 0) $totalExento = "";    
                        else $totalExento = number_format(round($totalExento, 2), 2 ,'.','');
                        
                        if($totalGravado == 0) $totalGravado = "";    
                        else $totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');

                        if(($tipocliente==3) && ($totalGravado>=100)){
                            $reten = $totalGravado * 0.01;
                            $retencion = '-'.$reten;
                            $total= $total-$reten;
                        } else $retencion = 0;
                        $totalGravIva = $totalGravado + $totalIVA;				

                        #   GRAVADO
                        $numero = number_format($total, 2 ,'.','');
                        $TotalLetras = trim($this->valorEnLetras($numero));
                        $contenidoHeader = '@ 23,0 Say "'.substr(strtoupper($TotalLetras), 0, 43).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $StringToGv = '$'.str_pad(number_format(round($totalGravado, 2), 2 ,'.',''), 13, " ", STR_PAD_LEFT);
                        $contenidoHeader = '@ Prow(),73 Say "'.$StringToGv.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        #   IVA
                        $contenidoHeader = '@ Prow()+1,0 Say "'.substr(strtoupper($TotalLetras), 43, 86).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $StringToIVA = '$'.str_pad(number_format(round($totalIVA, 2), 2 ,'.',''), 13, " ", STR_PAD_LEFT);
                        $contenidoHeader = '@ Prow(),73 Say "'.$StringToIVA.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        #   EXENTO
                        $StringToExen = '$'.str_pad(number_format(round($totalExento, 2), 2 ,'.',''), 13, " ", STR_PAD_LEFT);
                        $contenidoHeader = '@ Prow()+1,73 Say "'.$StringToExen.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        #   TOTAL
                        $StringTotal = '$'.str_pad(number_format(round($total, 2), 2 ,'.',''), 13, " ", STR_PAD_LEFT);
                        $contenidoHeader = '@ Prow()+1,73 Say "'.$StringTotal.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        if($efectivo == 1){
                            $contenidoProductos ='@ Prow(),Pcol() SAY CHR(27)+"p"+Chr(0)+"23"';
                            fwrite($archivoTxt, $contenidoProductos);
                            fwrite($archivoTxt, "\r\n");    
                        }

                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                
                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                
                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $docTxt = $info->descrip.$info->numero.".gox";
                        if(file_exists($docTxt)){
                            header('Content-Description: File Transfer');
                            header('Content-Type: application/octet-stream');
                            header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                            header('Expires: 0');
                            header('Cache-Control: must-revalidate');
                            header('Pragma: public');
                            header('Content-Length: ' . filesize($docTxt));
                            readfile($docTxt);                    
                            unlink($docTxt);
                            exit;
                        }
                    }
                }
            #-
        #-
        
        //CORTEZ DE CAJA-------------------------------------------------------------------
        //TMU950------------------------------------------------------------------------------------------------------------------
        #   GENERAL
            function valorEnLetras($x){ 
                $I7 = " ";
                $I9 = " ";
                if ($x<0) { $signo = "menos ";} 
                else      { $signo = "";} 
                $x = abs ($x); 
                $C1 = $x; 

                $G6 = floor($x/(1000000));  // 7 y mas 

                $E7 = floor($x/(100000)); 
                $G7 = $E7-$G6*10;   // 6 

                $E8 = floor($x/1000); 
                $G8 = $E8-$E7*100;   // 5 y 4 

                $E9 = floor($x/100); 
                $G9 = $E9-$E8*10;  //  3 

                $E10 = floor($x); 
                $G10 = $E10-$E9*100;  // 2 y 1 


                $G11 = round(($x-$E10)*100,0);  // Decimales 
                ////////////////////// 

                $H6 = $this->unidades($G6); 

                if($G7==1 AND $G8==0) { $H7 = "Cien "; } 
                else {    $H7 = $this->decenas($G7); } 

                $H8 = $this->unidades($G8); 

                if($G9==1 AND $G10==0) { $H9 = "Cien "; } 
                else {    $H9 = $this->decenas($G9); } 

                $H10 = $this->unidades($G10); 

                if($G11 < 10) { $H11 = "0".$G11; } 
                else { $H11 = $G11; } 

                ///////////////////////////// 
                    if($G6==0) { $I6=" "; } 
                elseif($G6==1) { $I6="Millón "; } 
                        else { $I6="Millones "; } 

                if ($G8==0 AND $G7==0) { $I8=" "; } 
                        else { $I8="Mil "; } 

                $I10 = ""; 
                $I11 = "/100 US DOLARES ";

                $C3 = $signo.$H6.$I6.$H7.$I7.$H8.$I8.$H9.$I9.$H10.$I10.$H11.$I11; 

                return $C3; //Retornar el resultado 
            }
            public function unidades($u){ 
                if ($u==0)  {$ru = " ";} 
                elseif ($u==1)  {$ru = "Un ";} 
                elseif ($u==2)  {$ru = "Dos ";} 
                elseif ($u==3)  {$ru = "Tres ";} 
                elseif ($u==4)  {$ru = "Cuatro ";} 
                elseif ($u==5)  {$ru = "Cinco ";} 
                elseif ($u==6)  {$ru = "Seis ";} 
                elseif ($u==7)  {$ru = "Siete ";} 
                elseif ($u==8)  {$ru = "Ocho ";} 
                elseif ($u==9)  {$ru = "Nueve ";} 
                elseif ($u==10) {$ru = "Diez ";} 

                elseif ($u==11) {$ru = "Once ";} 
                elseif ($u==12) {$ru = "Doce ";} 
                elseif ($u==13) {$ru = "Trece ";} 
                elseif ($u==14) {$ru = "Catorce ";} 
                elseif ($u==15) {$ru = "Quince ";} 
                elseif ($u==16) {$ru = "Dieciseis ";} 
                elseif ($u==17) {$ru = "Diecisiete ";} 
                elseif ($u==18) {$ru = "Dieciocho ";} 
                elseif ($u==19) {$ru = "Diecinueve ";} 
                elseif ($u==20) {$ru = "Veinte ";} 

                elseif ($u==21) {$ru = "Veintiun ";} 
                elseif ($u==22) {$ru = "Veintidos ";} 
                elseif ($u==23) {$ru = "Veintitres ";} 
                elseif ($u==24) {$ru = "Veinticuatro ";} 
                elseif ($u==25) {$ru = "Veinticinco ";} 
                elseif ($u==26) {$ru = "Veintiseis ";} 
                elseif ($u==27) {$ru = "Veintisiente ";} 
                elseif ($u==28) {$ru = "Veintiocho ";} 
                elseif ($u==29) {$ru = "Veintinueve ";} 
                elseif ($u==30) {$ru = "Treinta ";} 

                elseif ($u==31) {$ru = "Treinta y un ";} 
                elseif ($u==32) {$ru = "Treinta y dos ";} 
                elseif ($u==33) {$ru = "Treinta y tres ";} 
                elseif ($u==34) {$ru = "Treinta y cuatro ";} 
                elseif ($u==35) {$ru = "Treinta y cinco ";} 
                elseif ($u==36) {$ru = "Treinta y seis ";} 
                elseif ($u==37) {$ru = "Treinta y siete ";} 
                elseif ($u==38) {$ru = "Treinta y ocho  ";} 
                elseif ($u==39) {$ru = "Treinta y nueve ";} 
                elseif ($u==40) {$ru = "Cuarenta ";} 

                elseif ($u==41) {$ru = "Cuarenta y un ";} 
                elseif ($u==42) {$ru = "Cuarenta y dos ";} 
                elseif ($u==43) {$ru = "Cuarenta y tres ";} 
                elseif ($u==44) {$ru = "Cuarenta y cuatro ";} 
                elseif ($u==45) {$ru = "Cuarenta y cinco ";} 
                elseif ($u==46) {$ru = "Cuarenta y seis ";} 
                elseif ($u==47) {$ru = "Cuarenta y siete ";} 
                elseif ($u==48) {$ru = "Cuarenta y ocho  ";} 
                elseif ($u==49) {$ru = "Cuarenta y nueve ";} 
                elseif ($u==50) {$ru = "Cincuenta ";} 

                elseif ($u==51) {$ru = "Cincuenta y un ";} 
                elseif ($u==52) {$ru = "Cincuenta y dos ";} 
                elseif ($u==53) {$ru = "Cincuenta y tres ";} 
                elseif ($u==54) {$ru = "Cincuenta y cuatro ";} 
                elseif ($u==55) {$ru = "Cincuenta y cinco ";} 
                elseif ($u==56) {$ru = "Cincuenta y seis ";} 
                elseif ($u==57) {$ru = "Cincuenta y siete ";} 
                elseif ($u==58) {$ru = "Cincuenta y ocho  ";} 
                elseif ($u==59) {$ru = "Cincuenta y nueve ";} 
                elseif ($u==60) {$ru = "Sesenta ";} 

                elseif ($u==61) {$ru = "Sesenta y un ";} 
                elseif ($u==62) {$ru = "Sesenta y dos ";} 
                elseif ($u==63) {$ru = "Sesenta y tres ";} 
                elseif ($u==64) {$ru = "Sesenta y cuatro ";} 
                elseif ($u==65) {$ru = "Sesenta y cinco ";} 
                elseif ($u==66) {$ru = "Sesenta y seis ";} 
                elseif ($u==67) {$ru = "Sesenta y siete ";} 
                elseif ($u==68) {$ru = "Sesenta y ocho  ";} 
                elseif ($u==69) {$ru = "Sesenta y nueve ";} 
                elseif ($u==70) {$ru = "Setenta ";} 

                elseif ($u==71) {$ru = "Setenta y un ";} 
                elseif ($u==72) {$ru = "Setenta y dos ";} 
                elseif ($u==73) {$ru = "Setenta y tres ";} 
                elseif ($u==74) {$ru = "Setenta y cuatro ";} 
                elseif ($u==75) {$ru = "Setenta y cinco ";} 
                elseif ($u==76) {$ru = "Setenta y seis ";} 
                elseif ($u==77) {$ru = "Setenta y siete ";} 
                elseif ($u==78) {$ru = "Setenta y ocho  ";} 
                elseif ($u==79) {$ru = "Setenta y nueve ";} 
                elseif ($u==80) {$ru = "Ochenta ";} 

                elseif ($u==81) {$ru = "Ochenta y un ";} 
                elseif ($u==82) {$ru = "Ochenta y dos ";} 
                elseif ($u==83) {$ru = "Ochenta y tres ";} 
                elseif ($u==84) {$ru = "Ochenta y cuatro ";} 
                elseif ($u==85) {$ru = "Ochenta y cinco ";} 
                elseif ($u==86) {$ru = "Ochenta y seis ";} 
                elseif ($u==87) {$ru = "Ochenta y siete ";} 
                elseif ($u==88) {$ru = "Ochenta y ocho  ";} 
                elseif ($u==89) {$ru = "Ochenta y nueve ";} 
                elseif ($u==90) {$ru = "Noventa ";} 

                elseif ($u==91) {$ru = "Noventa y un ";} 
                elseif ($u==92) {$ru = "Noventa y dos ";} 
                elseif ($u==93) {$ru = "Noventa y tres ";} 
                elseif ($u==94) {$ru = "Noventa y cuatro ";} 
                elseif ($u==95) {$ru = "Noventa y cinco ";} 
                elseif ($u==96) {$ru = "Noventa y seis ";} 
                elseif ($u==97) {$ru = "Noventa y siete ";} 
                elseif ($u==98) {$ru = "Noventa y ocho  ";} 
                else            {$ru = "Noventa y nueve ";} 
                return $ru; //Retornar el resultado 
            }
            public function decenas($d){ 
                if ($d==0)  {$rd = "";} 
                elseif ($d==1)  {$rd = "Ciento ";} 
                elseif ($d==2)  {$rd = "Doscientos ";} 
                elseif ($d==3)  {$rd = "Trescientos ";} 
                elseif ($d==4)  {$rd = "Cuatrocientos ";} 
                elseif ($d==5)  {$rd = "Quinientos ";} 
                elseif ($d==6)  {$rd = "Seiscientos ";} 
                elseif ($d==7)  {$rd = "Setecientos ";} 
                elseif ($d==8)  {$rd = "Ochocientos ";} 
                else            {$rd = "Novecientos ";} 
                return $rd; //Retornar el resultado 
            }
            function eliminarTildes($cadena){
                $cadena = str_replace(
                    array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
                    array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
                    $cadena
                );
                
                $cadena = str_replace(
                    array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
                    array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
                    $cadena
                );
                
                $cadena = str_replace(
                    array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
                    array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
                    $cadena
                );
                
                $cadena = str_replace(
                    array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
                    array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
                    $cadena
                );
                
                $cadena = str_replace(
                    array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
                    array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
                    $cadena
                );
                
                $cadena = str_replace(
                    array('ñ', 'Ñ', 'ç', 'Ç'),
                    array('n', 'N', 'c', 'C'),
                    $cadena
                );
                
                return $cadena;
            }
        #-

        function imprimirApertura($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model'); $this->load->model('global_model');
				$this->load->model('sucursal_model'); $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$fondocaja = $caja->cajafondo;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				$partesFecha = explode("/", $fechaCorte);
                $archivoTxt = fopen("AperturaCaja".$partesFecha[2].$partesFecha[1].$partesFecha[0].".gox",'w+');
                
               // Small Font
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(1)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                // Turn ticket and audit On
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"z"+CHR(1)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n"); 
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(2)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(3)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                //
               
                
                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"2"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"2"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $RazonSocial = $this->eliminarTildes($RazonSocial);
                
                
                $contenidoHeader = '@ 01, 00 Say "'.str_pad(substr(trim($RazonSocial), 0, 38), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                if(strlen($RazonSocial)>38){
                    $contenidoHeader = '@ Prow()+1, 00 Say "'.str_pad(substr(trim($RazonSocial), 38, 38), 38, " ", STR_PAD_BOTH).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }
                        
                $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(strtoupper($namecaja), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(strtoupper($namecentro), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 04,02 Say "NRC: '.$NRF.' NIT:'.$NIT.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 05,04 Say "Giro: '.$GIRO.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                $contenidoHeader = '@ 06,13 Say "IVA D.L. N 296"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 07,12 Say "APERTURA DE CAJA"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 08,15 Say "'.$fechaCorte.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 09,07 Say "CAJERO: '.$this->session->userdata('userLog').'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 10,13 Say "FONDO: '.number_format($fondocaja, 2, '.', '').'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 11,12 Say "SE APERTURO CAJA"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                 $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                /*$contenidoProductos ='@ Prow()+1,00 Say CHR(27)+"i"';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");*/
                
                fclose($archivoTxt);
                
                $docTxt = "AperturaCaja".$partesFecha[2].$partesFecha[1].$partesFecha[0].".gox";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);                    
                    unlink($docTxt);
                    exit;
                }
            }
            
            function closeWin() {
                myWindow.close();
            }
        }
        
        function reporteCorteX($fechaactual, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');

                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;
                    
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
                
                
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                $cnt = 0;
                $valpag = array();

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                $archivoTxt = fopen("CorteX".$numero_x."Z".$numero_z.".gox",'w+');

               // Small Font
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(1)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                // Turn ticket and audit On
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"z"+CHR(1)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n"); 
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(2)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(3)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                //
               
                
                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"2"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"2"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $RazonSocial = $this->eliminarTildes($RazonSocial);
                
                $contenidoHeader = '@ 01, 00 Say "'.str_pad(substr(trim($RazonSocial), 0, 38), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                if(strlen($RazonSocial)>38){
                    $contenidoHeader = '@ Prow()+1, 00 Say "'.str_pad(substr(trim($RazonSocial), 38, 38), 38, " ", STR_PAD_BOTH).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }
                        
                $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(strtoupper($namecaja), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(strtoupper($namecentro), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                $contenidoHeader = '@ Prow()+1 ,00 Say "NRC: '.$NRF.' NIT: '.$NIT.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                        
                $contenidoHeader = '@ Prow()+1 ,00 Say "Giro: '.str_pad(substr($GIRO, 0, 32), 32, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                if(strlen($GIRO)>38){
                    
                    $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(substr($GIRO, 32, 38), 38, " ", STR_PAD_BOTH).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                }
                        
                $contenidoHeader = '@ 06,12 Say "IVA D.L. N 296"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ 07,13 Say "CORTE X N '.$numero_x.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ 08,13 Say "'.$fechaCorte.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ 10,00 SAY Replicate("-",36)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ 12,00 SAY "TRANSACCIONES:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");

                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;
				
                
                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $contenidoHeader = '@ Prow()+2,02 SAY "'.$docs->descrip.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;

                            if($t == 0){
                                $numInicial = $ven->numero;
                            }

                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;

                            $productos = $this->invtran_model->getDataTran100k($ven->trannum);

                            foreach($productos as $pro){
                                if($pro->tipotax != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }

                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;

                            foreach($tipospagos as $tip){
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
										}else{
											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }

                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }


                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '          '.$numInicial;
                    }else if($numTotal == 2){
                        $newString = '         '.$numInicial;
                    }else if($numTotal == 3){
                        $newString = '        '.$numInicial;
                    }else if($numTotal == 4){
                        $newString = '       '.$numInicial;
                    }else if($numTotal == 5){
                        $newString = '      '.$numInicial;
                    }else if($numTotal == 6){
                        $newString = '     '.$numInicial;
                    }else if($numTotal == 7){
                        $newString = '    '.$numInicial;
                    }else if($numTotal == 8){
                        $newString = '   '.$numInicial;
                    }else if($numTotal == 9){
                        $newString = '  '.$numInicial;
                    }

                    $contenidoHeader = '@ Prow()+1,15 SAY "Del:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '          '.$numFinal;
                    }else if($numTotal == 2){
                        $newString = '         '.$numFinal;
                    }else if($numTotal == 3){
                        $newString = '        '.$numFinal;
                    }else if($numTotal == 4){
                        $newString = '       '.$numFinal;
                    }else if($numTotal == 5){
                        $newString = '      '.$numFinal;
                    }else if($numTotal == 6){
                        $newString = '     '.$numFinal;
                    }else if($numTotal == 7){
                        $newString = '    '.$numFinal;
                    }else if($numTotal == 8){
                        $newString = '   '.$numFinal;
                    }else if($numTotal == 9){
                        $newString = '  '.$numFinal;
                    }

                    $contenidoHeader = '@ Prow()+1,16 SAY "Al:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '          '.$numdoc;
                    }else if($numTotal == 2){
                        $newString = '         '.$numdoc;
                    }else if($numTotal == 3){
                        $newString = '        '.$numdoc;
                    }else if($numTotal == 4){
                        $newString = '       '.$numdoc;
                    }else if($numTotal == 5){
                        $newString = '      '.$numdoc;
                    }else if($numTotal == 6){
                        $newString = '     '.$numdoc;
                    }else if($numTotal == 7){
                        $newString = '    '.$numdoc;
                    }else if($numTotal == 8){
                        $newString = '   '.$numdoc;
                    }else if($numTotal == 9){
                        $newString = '  '.$numdoc;
                    }

                    $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($subtotalex, 2),2);
                    }

                    $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($subtotalgr, 2),2);
                    }

                    $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($subtotaliv, 2),2);
                    }

                    $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($subtotal, 2),2);
                    }

                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;

                }
                
                $contenidoHeader = '@ Prow()+2,04 SAY "Totales"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");    
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){
                    $newString = '          '.$numdoc;
                }else if($numTotal == 2){
                    $newString = '         '.$numdoc;
                }else if($numTotal == 3){
                    $newString = '        '.$numdoc;
                }else if($numTotal == 4){
                    $newString = '       '.$numdoc;
                }else if($numTotal == 5){
                    $newString = '      '.$numdoc;
                }else if($numTotal == 6){
                    $newString = '     '.$numdoc;
                }else if($numTotal == 7){
                    $newString = '    '.$numdoc;
                }else if($numTotal == 8){
                    $newString = '   '.$numdoc;
                }else if($numTotal == 9){
                    $newString = '  '.$numdoc;
                }

                $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){
                    $newString = '         $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 2){
                    $newString = '        $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 3){
                    $newString = '       $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 4){
                    $newString = '      $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 5){
                    $newString = '     $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 6){
                    $newString = '    $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 7){
                    $newString = '   $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 8){
                    $newString = '  $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 9){
                    $newString = ' $'.number_format(round($totalexglobal, 2),2);
                }

                $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){
                    $newString = '         $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 2){
                    $newString = '        $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 3){
                    $newString = '       $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 4){
                    $newString = '      $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 5){
                    $newString = '     $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 6){
                    $newString = '    $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 7){
                    $newString = '   $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 8){
                    $newString = '  $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 9){
                    $newString = ' $'.number_format(round($totalgrglobal, 2),2);
                }

                $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){
                    $newString = '         $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 2){
                    $newString = '        $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 3){
                    $newString = '       $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 4){
                    $newString = '      $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 5){
                    $newString = '     $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 6){
                    $newString = '    $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 7){
                    $newString = '   $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 8){
                    $newString = '  $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 9){
                    $newString = ' $'.number_format(round($totalivglobal, 2),2);
                }

                $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){
                    $newString = '         $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 2){
                    $newString = '        $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 3){
                    $newString = '       $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 4){
                    $newString = '      $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 5){
                    $newString = '     $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 6){
                    $newString = '    $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 7){
                    $newString = '   $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 8){
                    $newString = '  $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 9){
                    $newString = ' $'.number_format(round($totalglobal, 2),2);
                }

                $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow()+2,00 SAY "INGRESOS:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");  
                
                $total_ing_sum=0;
                $l=0;
                foreach($tipospagos as $tip){
                    $l++;
                }
                
                $p=0;
                $newString='';
                foreach($tipospagos as $tip){
                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;
                    
                    if($totalString == '8'){
                        $newCoordenada = 10; 
                    }else if($totalString == '9'){
                        $newCoordenada = 9;
                    }else if($totalString == '10'){
                        $newCoordenada = 8;
                    }else if($totalString == '11'){
                        $newCoordenada = 7;
                    }else if($totalString == '12'){
                        $newCoordenada = 6;
                    }else if($totalString == '13'){
                        $newCoordenada = 5;
                    }else if($totalString == '14'){
                        $newCoordenada = 4;
                    }else if($totalString == '15'){
                        $newCoordenada = 3;
                    }else if($totalString == '16'){
                        $newCoordenada = 2;
                    }else if($totalString == '17'){
                        $newCoordenada = 1;
                    }else if($totalString == '18'){
                        $newCoordenada = 0;
                    }
                    
                    /*while($numTotal < 23){
                        $numCantidad = ' '.$numCantidad;
                    }*/

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($numTotal == 1){
                        $newString = '         $'.$numPrecio;
                    }else if($numTotal == 2){
                        $newString = '        $'.$numPrecio;
                    }else if($numTotal == 3){
                        $newString = '       $'.$numPrecio;
                    }else if($numTotal == 4){
                        $newString = '      $'.$numPrecio;
                    }else if($numTotal == 5){
                        $newString = '     $'.$numPrecio;
                    }else if($numTotal == 6){
                        $newString = '    $'.$numPrecio;
                    }else if($numTotal == 7){
                        $newString = '   $'.$numPrecio;
                    }else if($numTotal == 8){
                        $newString = '  $'.$numPrecio;
                    }else if($numTotal == 9){
                        $newString = ' $'.$numPrecio;
                    }

                    if($p == $l - 1){
                        $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }else{
                        $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){ 
                    $newString = '         $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 2){
                    $newString = '        $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 3){
                    $newString = '       $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 4){
                    $newString = '      $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 5){
                    $newString = '     $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 6){
                    $newString = '    $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 7){
                    $newString = '   $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 8){
                    $newString = '  $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 9){
                    $newString = ' $'.number_format(round($total_ing_sum, 2),2);
                }

                $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow()+2,00 SAY "CUADRE DE CAJA:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");  
                
                $contenidoHeader = '@Prow()+1,06 SAY "Sist"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@Prow(),17 SAY "Caja"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@Prow(),28 SAY "Dife"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);

                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;
                
                foreach($infoCuadre as $info){
                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2);
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    if($numTotal2 == 1){
                        $newString2 = '         $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 2){
                        $newString2 = '        $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 3){
                        $newString2 = '       $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 4){
                        $newString2 = '      $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 5){
                        $newString2 = '     $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 6){
                        $newString2 = '    $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 7){
                        $newString2 = '   $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 8){
                        $newString2 = '  $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 9){
                        $newString2 = ' $'.number_format(round($info->valorsys, 2),2);
                    }

                    $numCantidad3 = number_format(round($info->valorusr, 2),2);
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    if($numTotal3 == 1){
                        $newString3 = '         $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 2){
                        $newString3 = '        $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 3){
                        $newString3 = '       $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 4){
                        $newString3 = '      $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 5){
                        $newString3 = '     $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 6){
                        $newString3 = '    $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 7){
                        $newString3 = '   $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 8){
                        $newString3 = '  $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 9){
                        $newString3 = ' $'.number_format(round($info->valorusr, 2),2);
                    }

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{
                        $diferencia = $valorCaja - $valorSistema;
                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2);
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    if($numTotal4 == 1){
                        $newString4 = '         $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 2){
                        $newString4 = '        $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 3){
                        $newString4 = '       $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 4){
                        $newString4 = '      $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 5){
                        $newString4 = '     $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 6){
                        $newString4 = '    $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 7){
                        $newString4 = '   $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 8){
                        $newString4 = '  $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 9){
                        $newString4 = ' $'.number_format(round($diferencia, 2),2);
                    }

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    /*while($totalString < 5){
                        $stringCount = ' '.$stringCount;
                    }*/

                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);
                    /*
                    while($totalString < 5){
                        $stringCountUser = ' '.$stringCountUser;
                    }*/

                    $contenidoHeader = '@Prow()+1,00 SAY "'.$numCantidad.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow(),06 SAY "$ '.$numCantidad2.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow(),17 SAY "$ '.$numCantidad3.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow(),28 SAY "$ '.$numCantidad4.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $numerotransacc = $numerotransacc + 1;
                }
                
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                if($numSistema == 1){
                    $valorSistema = '         $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 2){
                    $valorSistema = '        $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 3){
                    $valorSistema = '       $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 4){
                    $valorSistema = '      $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 5){
                    $valorSistema = '     $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 6){
                    $valorSistema = '    $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 7){
                    $valorSistema = '   $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 8){
                    $valorSistema = '  $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 9){
                    $valorSistema = ' $'.number_format(round($totalSistema, 2),2);
                }

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                if($numCaja == 1){
                    $valorCaja = '         $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 2){
                    $valorCaja = '        $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 3){
                    $valorCaja = '       $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 4){
                    $valorCaja = '      $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 5){
                    $valorCaja = '     $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 6){
                    $valorCaja = '    $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 7){
                    $valorCaja = '   $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 8){
                    $valorCaja = '  $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 9){
                    $valorCaja = ' $'.number_format(round($totalCaja, 2),2);
                }

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numDif == 1){
                    $valorTotDif = '         $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 2){
                    $valorTotDif = '        $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 3){
                    $valorTotDif = '       $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 4){
                    $valorTotDif = '      $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 5){
                    $valorTotDif = '     $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 6){
                    $valorTotDif = '    $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 7){
                    $valorTotDif = '   $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 8){
                    $valorTotDif = '  $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 9){
                    $valorTotDif = ' $'.number_format(round($totalDiferencia, 2),2);
                }
                
            if($numerotransacc > 1){
                
                $contenidoHeader = '@Prow()+1,00 SAY "Resumen:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@Prow()+1,05 SAY "Sistema:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@Prow(),20 SAY "'.$valorSistema.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@Prow()+1,08 SAY "Caja:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@Prow(),20 SAY "'.$valorCaja.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                if($totalDiferencia > 0){
                    $contenidoHeader = '@Prow()+1,04 SAY "Sobrante:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }else if($totalDiferencia < 0){
                    $contenidoHeader = '@Prow()+1,04 SAY "Faltante:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }else if($totalDiferencia == 0){
                    $contenidoHeader = '@Prow()+1,02 SAY "Diferencia:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }
            }
                
                $contenidoHeader = '@Prow()+2,04 SAY "ACTIVIDAD EN CAJA:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@Prow()+1,06 SAY "Apertura de Gaveta:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);
                
                foreach($informacion as $info){
                    $fechahora = explode(" ", $info->ingresa);
                    $hora = explode(":", $fechahora[1]);
                    $hours = $hora[0];
                    $minutes = $hora[1];
                    $seconds = $hora[2];
                    $ampm = $hours >= 12 ? 'PM' : 'AM';
                    $hours = $hours % 12;
                    $hours = $hours ? $hours : 12;
                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;
                    $counthours = $hours;
                    $stringhours = $counthours;
                    /*
                    while(strlen($stringhours) < 2){
                        $stringhours = ' '.$stringhours;
                    }*/

                    $countmin = $minutes;
                    $stringmin = $countmin;
                    /*
                    while(strlen($stringmin) < 2){
                        $stringmin = ' '.$stringmin;
                    }*/

                    $countsec = $seconds;
                    $stringsec = $countsec;
                    /*
                    while(strlen($stringsec) < 2){
                        $stringsec = ' '.$stringsec;
                    }*/

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $contenidoHeader = '@Prow()+1,06 SAY "'.$hora_apertura.' '.$info->nameuser.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }
                
                $nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);
                
                $contenidoHeader = '@Prow()+2,00 SAY "F.___________________________________"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@Prow()+1,10 SAY "'.trim($this->session->userdata('userLog')).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@Prow()+1,13 SAY "'.$dia. '/' .$mes.'/'.$anio.'  '.$strTime.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@Prow()+1,00 SAY "_____________________________________"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@Prow()+1,00 SAY "_____________________________________"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                 $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                /*$contenidoProductos ='@ Prow()+1,00 Say CHR(27)+"i"';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");*/
                
                fclose($archivoTxt);

                $docTxt = "CorteX".$numero_x."Z".$numero_z.".gox";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);

                    unlink($docTxt);
                    exit;
                }
                
            }
            
            function closeWin() {
                myWindow.close();
            }
        }
        
        function impresionCorteX($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');

                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;        
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
                
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                $cnt = 0;
                $valpag = array();
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");

                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                $archivoTxt = fopen("impCorteX".$numero_x."Z".$numero_z.".gox",'w+');

                // Small Font
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(1)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                // Turn ticket and audit On
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"z"+CHR(1)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n"); 
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(2)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(3)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                //
               
                
                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"2"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"2"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $RazonSocial = $this->eliminarTildes($RazonSocial);
                
               $contenidoHeader = '@ 01, 00 Say "'.str_pad(substr(trim($RazonSocial), 0, 38), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                if(strlen($RazonSocial)>38){
                    $contenidoHeader = '@ Prow()+1, 00 Say "'.str_pad(substr(trim($RazonSocial), 38, 38), 38, " ", STR_PAD_BOTH).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }
                        
                $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(strtoupper($namecaja), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(strtoupper($namecentro), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                $contenidoHeader = '@ Prow()+1 ,00 Say "NRC: '.$NRF.' NIT: '.$NIT.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                        
                $contenidoHeader = '@ Prow()+1 ,00 Say "Giro: '.str_pad(substr($GIRO, 0, 32), 32, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                if(strlen($GIRO)>38){
                    
                    $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(substr($GIRO, 32, 38), 38, " ", STR_PAD_BOTH).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                }
                        
                $contenidoHeader = '@ 06,12 Say "IVA D.L. N 296"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");


                $contenidoHeader = '@ 07,13 Say "REIMPRECION CORTE X N '.$numero_x.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ 08,13 Say "'.$fechaCorte.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ 10,00 SAY Replicate("-",36)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ 12,00 SAY "TRANSACCIONES:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ 12,00 SAY "TRANSACCIONES:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;
                
                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $contenidoHeader = '@ Prow()+2,02 SAY "'.$docs->descrip.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0; $totalGravado = 0; $totalExento = 0;
							$totalIVA = 0; $invexento = $ven->exento;
							
							$productos = $this->invtran_model->getDataTran100kCorteZ($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tax1 != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tax1 != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tax1== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tax1 == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++; $numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}


                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    $newString = str_pad($numTotal, 11, " ", STR_PAD_LEFT);

                    /*if($numTotal == 1){
                        $newString = '          '.$numInicial;
                    }else if($numTotal == 2){
                        $newString = '         '.$numInicial;
                    }else if($numTotal == 3){
                        $newString = '        '.$numInicial;
                    }else if($numTotal == 4){
                        $newString = '       '.$numInicial;
                    }else if($numTotal == 5){
                        $newString = '      '.$numInicial;
                    }else if($numTotal == 6){
                        $newString = '     '.$numInicial;
                    }else if($numTotal == 7){
                        $newString = '    '.$numInicial;
                    }else if($numTotal == 8){
                        $newString = '   '.$numInicial;
                    }else if($numTotal == 9){
                        $newString = '  '.$numInicial;
                    }*/

                    $contenidoHeader = '@ Prow()+1,15 SAY "Del:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '          '.$numFinal;
                    }else if($numTotal == 2){
                        $newString = '         '.$numFinal;
                    }else if($numTotal == 3){
                        $newString = '        '.$numFinal;
                    }else if($numTotal == 4){
                        $newString = '       '.$numFinal;
                    }else if($numTotal == 5){
                        $newString = '      '.$numFinal;
                    }else if($numTotal == 6){
                        $newString = '     '.$numFinal;
                    }else if($numTotal == 7){
                        $newString = '    '.$numFinal;
                    }else if($numTotal == 8){
                        $newString = '   '.$numFinal;
                    }else if($numTotal == 9){
                        $newString = '  '.$numFinal;
                    }

                    $contenidoHeader = '@ Prow()+1,16 SAY "Al:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '          '.$numdoc;
                    }else if($numTotal == 2){
                        $newString = '         '.$numdoc;
                    }else if($numTotal == 3){
                        $newString = '        '.$numdoc;
                    }else if($numTotal == 4){
                        $newString = '       '.$numdoc;
                    }else if($numTotal == 5){
                        $newString = '      '.$numdoc;
                    }else if($numTotal == 6){
                        $newString = '     '.$numdoc;
                    }else if($numTotal == 7){
                        $newString = '    '.$numdoc;
                    }else if($numTotal == 8){
                        $newString = '   '.$numdoc;
                    }else if($numTotal == 9){
                        $newString = '  '.$numdoc;
                    }

                    $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($subtotalex, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($subtotalex, 2),2);
                    }

                    $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($subtotalgr, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($subtotalgr, 2),2);
                    }

                    $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($subtotaliv, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($subtotaliv, 2),2);
                    }

                    $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    $newString = str_pad('$'.$numCantidad, 11, " ", STR_PAD_LEFT);

                    /*if($numTotal == 1){
                        $newString = '         $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($subtotal, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($subtotal, 2),2);
                    }*/

                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;

                }
                
                $contenidoHeader = '@ Prow()+2,04 SAY "Totales"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");    
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){
                    $newString = '          '.$numdoc;
                }else if($numTotal == 2){
                    $newString = '         '.$numdoc;
                }else if($numTotal == 3){
                    $newString = '        '.$numdoc;
                }else if($numTotal == 4){
                    $newString = '       '.$numdoc;
                }else if($numTotal == 5){
                    $newString = '      '.$numdoc;
                }else if($numTotal == 6){
                    $newString = '     '.$numdoc;
                }else if($numTotal == 7){
                    $newString = '    '.$numdoc;
                }else if($numTotal == 8){
                    $newString = '   '.$numdoc;
                }else if($numTotal == 9){
                    $newString = '  '.$numdoc;
                }

                $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){
                    $newString = '         $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 2){
                    $newString = '        $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 3){
                    $newString = '       $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 4){
                    $newString = '      $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 5){
                    $newString = '     $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 6){
                    $newString = '    $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 7){
                    $newString = '   $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 8){
                    $newString = '  $'.number_format(round($totalexglobal, 2),2);
                }else if($numTotal == 9){
                    $newString = ' $'.number_format(round($totalexglobal, 2),2);
                }

                $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){
                    $newString = '         $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 2){
                    $newString = '        $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 3){
                    $newString = '       $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 4){
                    $newString = '      $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 5){
                    $newString = '     $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 6){
                    $newString = '    $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 7){
                    $newString = '   $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 8){
                    $newString = '  $'.number_format(round($totalgrglobal, 2),2);
                }else if($numTotal == 9){
                    $newString = ' $'.number_format(round($totalgrglobal, 2),2);
                }

                $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){
                    $newString = '         $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 2){
                    $newString = '        $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 3){
                    $newString = '       $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 4){
                    $newString = '      $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 5){
                    $newString = '     $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 6){
                    $newString = '    $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 7){
                    $newString = '   $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 8){
                    $newString = '  $'.number_format(round($totalivglobal, 2),2);
                }else if($numTotal == 9){
                    $newString = ' $'.number_format(round($totalivglobal, 2),2);
                }

                $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){
                    $newString = '         $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 2){
                    $newString = '        $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 3){
                    $newString = '       $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 4){
                    $newString = '      $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 5){
                    $newString = '     $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 6){
                    $newString = '    $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 7){
                    $newString = '   $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 8){
                    $newString = '  $'.number_format(round($totalglobal, 2),2);
                }else if($numTotal == 9){
                    $newString = ' $'.number_format(round($totalglobal, 2),2);
                }

                $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow()+2,00 SAY "INGRESOS:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");  
                $contenidoHeader = '@ Prow(),00 SAY "INGRESOS:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");  
                
                
                $total_ing_sum=0;
                $l=0;
                foreach($tipospagos as $tip){
                    $l++;
                }
                
                $p=0;
                $newString='';
                foreach($tipospagos as $tip){
                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;
                    
                    if($totalString == '8'){
                        $newCoordenada = 10; 
                    }else if($totalString == '9'){
                        $newCoordenada = 9;
                    }else if($totalString == '10'){
                        $newCoordenada = 8;
                    }else if($totalString == '11'){
                        $newCoordenada = 7;
                    }else if($totalString == '12'){
                        $newCoordenada = 6;
                    }else if($totalString == '13'){
                        $newCoordenada = 5;
                    }else if($totalString == '14'){
                        $newCoordenada = 4;
                    }else if($totalString == '15'){
                        $newCoordenada = 3;
                    }else if($totalString == '16'){
                        $newCoordenada = 2;
                    }else if($totalString == '17'){
                        $newCoordenada = 1;
                    }else if($totalString == '18'){
                        $newCoordenada = 0;
                    }
                    
                    /*while($numTotal < 23){
                        $numCantidad = ' '.$numCantidad;
                    }*/

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($numTotal == 1){
                        $newString = '         $'.$numPrecio;
                    }else if($numTotal == 2){
                        $newString = '        $'.$numPrecio;
                    }else if($numTotal == 3){
                        $newString = '       $'.$numPrecio;
                    }else if($numTotal == 4){
                        $newString = '      $'.$numPrecio;
                    }else if($numTotal == 5){
                        $newString = '     $'.$numPrecio;
                    }else if($numTotal == 6){
                        $newString = '    $'.$numPrecio;
                    }else if($numTotal == 7){
                        $newString = '   $'.$numPrecio;
                    }else if($numTotal == 8){
                        $newString = '  $'.$numPrecio;
                    }else if($numTotal == 9){
                        $newString = ' $'.$numPrecio;
                    }

                    if($p == $l - 1){
                        $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }else{
                        $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                if($numTotal == 1){ 
                    $newString = '         $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 2){
                    $newString = '        $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 3){
                    $newString = '       $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 4){
                    $newString = '      $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 5){
                    $newString = '     $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 6){
                    $newString = '    $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 7){
                    $newString = '   $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 8){
                    $newString = '  $'.number_format(round($total_ing_sum, 2),2);
                }else if($numTotal == 9){
                    $newString = ' $'.number_format(round($total_ing_sum, 2),2);
                }

                $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ Prow()+2,00 SAY "CUADRE DE CAJA:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n"); 
                $contenidoHeader = '@ Prow(),00 SAY "CUADRE DE CAJA:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n"); 
                
                $contenidoHeader = '@Prow()+1,06 SAY "Sist"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@Prow(),17 SAY "Caja"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@Prow(),28 SAY "Dife"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);

                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;
                
                foreach($infoCuadre as $info){
                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2);
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    if($numTotal2 == 1){
                        $newString2 = '         $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 2){
                        $newString2 = '        $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 3){
                        $newString2 = '       $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 4){
                        $newString2 = '      $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 5){
                        $newString2 = '     $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 6){
                        $newString2 = '    $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 7){
                        $newString2 = '   $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 8){
                        $newString2 = '  $'.number_format(round($info->valorsys, 2),2);
                    }else if($numTotal2 == 9){
                        $newString2 = ' $'.number_format(round($info->valorsys, 2),2);
                    }

                    $numCantidad3 = number_format(round($info->valorusr, 2),2);
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    if($numTotal3 == 1){
                        $newString3 = '         $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 2){
                        $newString3 = '        $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 3){
                        $newString3 = '       $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 4){
                        $newString3 = '      $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 5){
                        $newString3 = '     $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 6){
                        $newString3 = '    $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 7){
                        $newString3 = '   $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 8){
                        $newString3 = '  $'.number_format(round($info->valorusr, 2),2);
                    }else if($numTotal3 == 9){
                        $newString3 = ' $'.number_format(round($info->valorusr, 2),2);
                    }

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{
                        $diferencia = $valorCaja - $valorSistema;
                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2);
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    if($numTotal4 == 1){
                        $newString4 = '         $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 2){
                        $newString4 = '        $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 3){
                        $newString4 = '       $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 4){
                        $newString4 = '      $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 5){
                        $newString4 = '     $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 6){
                        $newString4 = '    $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 7){
                        $newString4 = '   $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 8){
                        $newString4 = '  $'.number_format(round($diferencia, 2),2);
                    }else if($numTotal4 == 9){
                        $newString4 = ' $'.number_format(round($diferencia, 2),2);
                    }

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    /*while($totalString < 5){
                        $stringCount = ' '.$stringCount;
                    }*/

                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);
                    /*
                    while($totalString < 5){
                        $stringCountUser = ' '.$stringCountUser;
                    }*/

                    $contenidoHeader = '@Prow()+1,00 SAY "'.$numCantidad.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '@Prow(),06 SAY "$'.$numCantidad2.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                
                    $contenidoHeader = '@Prow(),17 SAY "$'.$numCantidad3.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                
                    $contenidoHeader = '@Prow(),28 SAY "$'.$numCantidad4.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $numerotransacc = $numerotransacc + 1;
                    
                }
                
                //FIN FOR CUADRE DE CAJA
                
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                if($numSistema == 1){
                    $valorSistema = '         $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 2){
                    $valorSistema = '        $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 3){
                    $valorSistema = '       $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 4){
                    $valorSistema = '      $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 5){
                    $valorSistema = '     $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 6){
                    $valorSistema = '    $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 7){
                    $valorSistema = '   $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 8){
                    $valorSistema = '  $'.number_format(round($totalSistema, 2),2);
                }else if($numSistema == 9){
                    $valorSistema = ' $'.number_format(round($totalSistema, 2),2);
                }

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                if($numCaja == 1){
                    $valorCaja = '         $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 2){
                    $valorCaja = '        $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 3){
                    $valorCaja = '       $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 4){
                    $valorCaja = '      $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 5){
                    $valorCaja = '     $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 6){
                    $valorCaja = '    $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 7){
                    $valorCaja = '   $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 8){
                    $valorCaja = '  $'.number_format(round($totalCaja, 2),2);
                }else if($numCaja == 9){
                    $valorCaja = ' $'.number_format(round($totalCaja, 2),2);
                }

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numDif == 1){
                    $valorTotDif = '         $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 2){
                    $valorTotDif = '        $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 3){
                    $valorTotDif = '       $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 4){
                    $valorTotDif = '      $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 5){
                    $valorTotDif = '     $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 6){
                    $valorTotDif = '    $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 7){
                    $valorTotDif = '   $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 8){
                    $valorTotDif = '  $'.number_format(round($totalDiferencia, 2),2);
                }else if($numDif == 9){
                    $valorTotDif = ' $'.number_format(round($totalDiferencia, 2),2);
                }
                
                if($numerotransacc > 1){
                
                    $contenidoHeader = '@Prow()+2,00 SAY "Resumen:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,05 SAY "Sistema:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow(),20 SAY "'.$valorSistema.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,08 SAY "Caja:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow(),20 SAY "'.$valorCaja.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    

                    if($totalDiferencia > 0){
                        $contenidoHeader = '@Prow()+1,04 SAY "Sobrante:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }else if($totalDiferencia < 0){
                        $contenidoHeader = '@Prow()+1,04 SAY "Faltante:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }else if($totalDiferencia == 0){
                        $contenidoHeader = '@Prow()+1,02 SAY "Diferencia:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                }
                
            }        
                $contenidoHeader = '@Prow()+2,04 SAY "ACTIVIDAD EN CAJA:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@Prow()+1,06 SAY "Apertura de Gaveta:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);
                
                foreach($informacion as $info){
                    $fechahora = explode(" ", $info->ingresa);
                    $hora = explode(":", $fechahora[1]);
                    $hours = $hora[0];
                    $minutes = $hora[1];
                    $seconds = $hora[2];
                    $ampm = $hours >= 12 ? 'PM' : 'AM';
                    $hours = $hours % 12;
                    $hours = $hours ? $hours : 12;
                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;
                    $counthours = $hours;
                    $stringhours = $counthours;
                    /*
                    while(strlen($stringhours) < 2){
                        $stringhours = ' '.$stringhours;
                    }*/

                    $countmin = $minutes;
                    $stringmin = $countmin;
                    /*
                    while(strlen($stringmin) < 2){
                        $stringmin = ' '.$stringmin;
                    }*/

                    $countsec = $seconds;
                    $stringsec = $countsec;
                    /*
                    while(strlen($stringsec) < 2){
                        $stringsec = ' '.$stringsec;
                    }*/

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $contenidoHeader = '@Prow()+1,06 SAY "'.$hora_apertura.' '.$info->nameuser.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }
                
                $contenidoHeader = '@Prow()+2,00 SAY "F.___________________________________"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@Prow()+1,10 SAY "'.trim($this->session->userdata('userLog')).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@Prow()+1,04 SAY "'.$dia. '/' .$mes.'/'.$anio.'  '.$strTime.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@Prow()+1,00 SAY "_____________________________________"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@Prow()+1,00 SAY "_____________________________________"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                 $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                $contenidoProductos ='@ Prow()+1,00 Say " "';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoProductos ='@ Prow()+1,00 Say CHR(27)+"i"';
                fwrite($archivoTxt, $contenidoProductos);
                fwrite($archivoTxt, "\r\n");
                
                fclose($archivoTxt);

                $docTxt = "impCorteX".$numero_x."Z".$numero_z.".gox";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);

                    unlink($docTxt);
                    exit;
                }
                
                 echo "<script type='text/javascript'>
            setTimeout(function(){ window.close(); }, 1000);";
                
            }
           
        }
        
        function reporteCorteZFacturaz($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
                
                $documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
							
                $archivoTxt = fopen("CorteZ".$numero_z.".gox",'w+');

               // Small Font
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(1)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                // Turn ticket and audit On
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"z"+CHR(1)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n"); 
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(2)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(3)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                //
               
                
                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"2"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"2"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $RazonSocial = $this->eliminarTildes($RazonSocial);
                
                $contenidoHeader = '@ 01, 00 Say "'.str_pad(substr(trim($RazonSocial), 0, 38), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                if(strlen($RazonSocial)>38){
                    $contenidoHeader = '@ Prow()+1, 00 Say "'.str_pad(substr(trim($RazonSocial), 38, 38), 38, " ", STR_PAD_BOTH).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }
                        
                $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(strtoupper($namecaja), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(strtoupper($namecentro), 38, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                $contenidoHeader = '@ Prow()+1 ,00 Say "NRC: '.$NRF.' NIT: '.$NIT.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                        
                $contenidoHeader = '@ Prow()+1 ,00 Say "Giro: '.str_pad(substr($GIRO, 0, 32), 32, " ", STR_PAD_BOTH).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                    
                if(strlen($GIRO)>38){
                    
                    $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(substr($GIRO, 32, 38), 38, " ", STR_PAD_BOTH).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                }
                        
                $contenidoHeader = '@ 06,12 Say "IVA D.L. N 296"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ 07,13 Say "CORTE Z N '.$numero_z.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 08,13 Say "'.$fechaCorte.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ 09,00 SAY Replicate("-",39)';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                $contenidoHeader = '@ 11,00 SAY "DETALLE DE TRANSACCIONES:"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $anio = $date->format("Y");
                $mes = $date->fo