<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
    require 'vendor/autoload.php';
		
	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use Endroid\QrCode\QrCode;
    use Endroid\QrCode\Color\Color;
    use Endroid\QrCode\Encoding\Encoding;
    use Endroid\QrCode\ErrorCorrectionLevel;
    use Endroid\QrCode\Label\Label;
    use Endroid\QrCode\Logo\Logo;
    use Endroid\QrCode\RoundBlockSizeMode;
    use Endroid\QrCode\Writer\PngWriter;
    use Endroid\QrCode\Writer\ValidationException;

    class Reports extends CI_Controller {
        #   GENERAL
            function __construct(){
                parent::__construct();
            }

            function centimos(){
                global $importe_parcial;
                $importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
                if($importe_parcial > 0){
                    $num_letra = " con ".$this->decena_centimos($importe_parcial);
                }else{
                    $num_letra = " 00";
                }
                return $num_letra;
            }
            
            function unidad_centimos($numero){
                $numero = trim($numero);
                switch($numero){
                    case 9:{
                        $num_letra = "9";
                        break;
                    }
                    case 8:{
                        $num_letra = "8";
                        break;
                    }
                    case 7:{
                        $num_letra = "7";

                        break;

                    }

                    case 6:{

                        $num_letra = "6";

                        break;

                    }

                    case 5:{

                        $num_letra = "5";

                        break;

                    }

                    case 4:{

                        $num_letra = "4";

                        break;

                    }

                    case 3:{

                        $num_letra = "3";

                        break;

                    }

                    case 2:{

                        $num_letra = "2";

                        break;

                    }

                    case 1:{

                        $num_letra = "1";

                        break;

                    }

                }

                return $num_letra;

            }
    
            function decena_centimos($numero){

                $numero = trim($numero);

                if($numero >= 10){

                    if($numero >= 90 && $numero <= 99){

                        if($numero == 90)

                            return "90";

                        else if($numero == 91)

                            return "91";

                        else

                            return "9".$this->unidad_centimos($numero - 90);

                    }

                    if($numero >= 80 && $numero <= 89){

                        if($numero == 80)

                            return "80";

                        else if($numero == 81)

                            return "81";

                        else

                            return "8".$this->unidad_centimos($numero - 80);

                    }

                    if($numero >= 70 && $numero <= 79){

                        if($numero == 70)

                            return "70";

                        else if($numero == 71)

                            return "71";

                        else

                            return "7".$this->unidad_centimos($numero - 70);

                    }

                    if($numero >= 60 && $numero <= 69){

                        if($numero == 60)

                            return "60";

                        else if($numero == 61)

                            return "61";

                        else

                            return "6".$this->unidad_centimos($numero - 60);

                    }

                    if($numero >= 50 && $numero <= 59){

                        if($numero == 50)

                            return "50";

                        else if($numero == 51)

                            return "51";

                        else

                            return "5".$this->unidad_centimos($numero - 50);

                    }

                    if($numero >= 40 && $numero <= 49){

                        if($numero == 40)

                            return "40";

                        else if($numero == 41)

                            return "41";

                        else

                            return "4".$this->unidad_centimos($numero - 40);

                    }

                    if($numero >= 30 && $numero <= 39){

                        if($numero == 30)

                            return "30";

                        else if($numero == 91)

                            return "31";

                        else

                            return "3".$this->unidad_centimos($numero - 30);

                    }

                    if($numero >= 20 && $numero <= 29){

                        if($numero == 20)

                            return "20";

                        else if($numero == 21)

                            return "21";

                        else

                            return "2".$this->unidad_centimos($numero - 20);

                    }

                    if($numero >= 10 && $numero <= 19){

                        if($numero == 10)

                            return "10";

                        else if($numero == 11)

                            return "11";

                        else if($numero == 12)

                            return "12";

                        else if($numero == 13)

                            return "13";

                        else if($numero == 14)

                            return "14";

                        else if($numero == 15)

                            return "15";

                        else if($numero == 16)

                            return "16";

                        else if($numero == 17)

                            return "17";

                        else if($numero == 18)

                            return "18";

                        else if($numero == 19)

                            return "19";

                    }

                }else{

                    return $this->unidad_centimos($numero);

                }

            }     

            function unidad($numero){
                $numero = trim($numero);
                switch($numero){
                    case 9:{
                        $num = "nueve";

                        break;

                    }

                    case 8:{

                        $num = "ocho";

                        break;

                    }

                    case 7:{

                        $num = "siete";

                        break;

                    }

                    case 6:{

                        $num = "seis";

                        break;

                    }

                    case 5:{

                        $num = "cinco";

                        break;

                    }

                    case 4:{

                        $num = "cuatro";

                        break;

                    }

                    case 3:{

                        $num = "tres";

                        break;

                    }

                    case 2:{

                        $num = "dos";

                        break;

                    }

                    case 1:{

                        $num = "uno";

                        break;

                    }

                }

                return $num;

            }
        
            function decena($numero){

                $numero = trim($numero);



                if($numero >= 90 && $numero <= 99){

                    $num_letra = "noventa ";

                    

                    if($numero > 90)

                        $num_letra = $num_letra."y ".$this->unidad($numero - 90);

                }else if($numero >= 80 && $numero <= 89){

                    $num_letra = "ochenta ";

                    

                    if($numero > 80)

                        $num_letra = $num_letra."y ".$this->unidad($numero - 80);

                }else if($numero >= 70 && $numero <= 79){

                        $num_letra = "setenta ";



                    if($numero > 70)

                        $num_letra = $num_letra."y ".$this->unidad($numero - 70);

                }else if($numero >= 60 && $numero <= 69){

                    $num_letra = "sesenta ";



                    if($numero > 60)

                        $num_letra = $num_letra."y ".$this->unidad($numero - 60);

                }else if($numero >= 50 && $numero <= 59){

                    $num_letra = "cincuenta ";



                    if($numero > 50)

                        $num_letra = $num_letra."y ".$this->unidad($numero - 50);

                }else if($numero >= 40 && $numero <= 49){

                    $num_letra = "cuarenta ";



                    if($numero > 40)

                        $num_letra = $num_letra."y ".$this->unidad($numero - 40);

                }else if($numero >= 30 && $numero <= 39){

                    $num_letra = "treinta ";



                    if($numero > 30)

                        $num_letra = $num_letra."y ".$this->unidad($numero - 30);

                }else if($numero >= 20 && $numero <= 29){

                    if($numero == 20)

                        $num_letra = "veinte ";

                    else

                        $num_letra = "veinti".$this->unidad($numero - 20);

                }else if($numero >= 10 && $numero <= 19){

                    switch($numero){

                        case 10:{

                            $num_letra = "diez ";

                            break;

                        }

                        case 11:{

                            $num_letra = "once ";

                            break;

                        }

                        case 12:{

                            $num_letra = "doce ";

                            break;

                        }

                        case 13:{

                            $num_letra = "trece ";

                            break;

                        }

                        case 14:{

                            $num_letra = "catorce ";

                            break;

                        }

                        case 15:{

                            $num_letra = "quince ";

                            break;

                        }

                        case 16:{

                            $num_letra = "dieciseis ";

                            break;

                        }

                        case 17:{

                            $num_letra = "diecisiete ";

                            break;

                        }

                        case 18:{

                            $num_letra = "dieciocho ";

                            break;

                        }

                        case 19:{

                            $num_letra = "diecinueve ";

                            break;

                        }

                    }

                }else{

                    $num_letra = $this->unidad($numero);

                }

                

                return $num_letra;

            }

            function centena($numero){

                $numero = trim($numero);

                if($numero >= 100){

                    if ($numero >= 900 & $numero <= 999){

                        $num_letra = "novecientos ";



                        if($numero > 900)

                            $num_letra = $num_letra.$this->decena($numero - 900);

                    }else if($numero >= 800 && $numero <= 899){

                        $num_letra = "ochocientos ";



                        if($numero > 800)

                            $num_letra = $num_letra.$this->decena($numero - 800);

                    }else if($numero >= 700 && $numero <= 799){

                        $num_letra = "setecientos ";



                        if($numero > 700)

                            $num_letra = $num_letra.$this->decena($numero - 700);

                    }else if($numero >= 600 && $numero <= 699){

                        $num_letra = "seiscientos ";



                        if($numero > 600)

                            $num_letra = $num_letra.$this->decena($numero - 600);

                    }else if($numero >= 500 && $numero <= 599){

                        $num_letra = "quinientos ";



                        if($numero > 500)

                            $num_letra = $num_letra.$this->decena($numero - 500);

                    }else if($numero >= 400 && $numero <= 499){

                        $num_letra = "cuatrocientos ";



                        if($numero > 400)

                            $num_letra = $num_letra.$this->decena($numero - 400);

                    }else if($numero >= 300 && $numero <= 399){

                        $num_letra = "trescientos ";



                        if($numero > 300)

                            $num_letra = $num_letra.$this->decena($numero - 300);

                    }else if($numero >= 200 && $numero <= 299){

                        $num_letra = "doscientos ";



                        if($numero > 200)

                            $num_letra = $num_letra.$this->decena($numero - 200);

                    }else if($numero >= 100 && $numero <= 199){

                        if($numero == 100)

                            $num_letra = "cien ";

                        else

                            $num_letra = "ciento ".$this->decena($numero - 100);

                    }

                }else{

                    $num_letra = $this->decena($numero);

                }



                return $num_letra;

            }
            
            function cien(){

                global $importe_parcial;

                

                $parcial = 0; $car = 0;

                

                while(substr($importe_parcial, 0, 1) == 0)

                    $importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

                

                if($importe_parcial >= 1 && $importe_parcial <= 9.99)

                    $car = 1;

                else if($importe_parcial >= 10 && $importe_parcial <= 99.99)

                    $car = 2;

                else if($importe_parcial >= 100 && $importe_parcial <= 999.99)

                    $car = 3;

                

                $parcial = substr($importe_parcial, 0, $car);

                $importe_parcial = substr($importe_parcial, $car);

                

                $num_letra = $this->centena($parcial).$this->centimos();

                

                return $num_letra;

            }

            function cien_mil(){

                global $importe_parcial;

                

                $parcial = 0; $car = 0;

                

                while(substr($importe_parcial, 0, 1) == 0)

                    $importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

                

                if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)

                    $car = 1;

                else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)

                    $car = 2;

                else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)

                    $car = 3;

                

                $parcial = substr($importe_parcial, 0, $car);

                $importe_parcial = substr($importe_parcial, $car);

                

                if($parcial > 0){

                    if($parcial == 1)

                        $num_letra = "mil ";

                    else

                        $num_letra = $this->centena($parcial)." mil ";

                }



                return $num_letra;

            }

            function millon(){

                global $importe_parcial;

                

                $parcial = 0; $car = 0;

                

                while(substr($importe_parcial, 0, 1) == 0)

                    $importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

                

                if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)

                    $car = 1;

                else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)

                    $car = 2;

                else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)

                    $car = 3;

                

                $parcial = substr($importe_parcial, 0, $car);

                $importe_parcial = substr($importe_parcial, $car);

                

                if($parcial == 1)

                    $num_letras = "un millón ";

                else

                    $num_letras = $this->centena($parcial)." millones ";

                

                return $num_letras;

            }

            function convertir_a_letras($numero){

                global $importe_parcial;

                

                $numero = trim($numero);

                

                $importe_parcial = $numero;

                

                if($numero < 1000000000){

                    if($numero >= 1000000 && $numero <= 999999999.99)

                        $num_letras = $this->millon().$this->cien_mil().$this->cien();

                    else if($numero >= 1000 && $numero <= 999999.99)

                        $num_letras = $this->cien_mil().$this->cien();

                    else if($numero >= 1 && $numero <= 999.99)

                        $num_letras = $this->cien();

                    else if($numero >= 0.01 && $numero <= 0.99){

                        if($numero == 0.01)

                            $num_letras = "un céntimo";

                        else

                            $num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";

                    }

                }

                return $num_letras;

            }
        #
            
        //----------------------------------------------------------------------------------------------    
            function valorEnLetras($x){ 
                $I7 = " ";
                $I9 = " ";
                if ($x<0) { $signo = "menos ";} 
                else      { $signo = "";} 
                $x = abs ($x); 
                $C1 = $x; 

                $G6 = floor($x/(1000000));  // 7 y mas 

                $E7 = floor($x/(100000)); 
                $G7 = $E7-$G6*10;   // 6 

                $E8 = floor($x/1000); 
                $G8 = $E8-$E7*100;   // 5 y 4 

                $E9 = floor($x/100); 
                $G9 = $E9-$E8*10;  //  3 

                $E10 = floor($x); 
                $G10 = $E10-$E9*100;  // 2 y 1 


                $G11 = round(($x-$E10)*100,0);  // Decimales 
                ////////////////////// 

                $H6 = $this->unidades($G6); 

                if($G7==1 AND $G8==0) { $H7 = "Cien "; } 
                else {    $H7 = $this->decenas($G7); } 

                $H8 = $this->unidades($G8); 

                if($G9==1 AND $G10==0) { $H9 = "Cien "; } 
                else {    $H9 = $this->decenas($G9); } 

                $H10 = $this->unidades($G10); 

                if($G11 < 10) { $H11 = "0".$G11; } 
                else { $H11 = $G11; } 

                ///////////////////////////// 
                    if($G6==0) { $I6=" "; } 
                elseif($G6==1) { $I6="Millón "; } 
                        else { $I6="Millones "; } 

                if ($G8==0 AND $G7==0) { $I8=" "; } 
                        else { $I8="Mil "; } 

                $I10 = ""; 
                $I11 = "/100 US DOLARES ";

                $C3 = $signo.$H6.$I6.$H7.$I7.$H8.$I8.$H9.$I9.$H10.$I10.$H11.$I11; 

                return $C3; //Retornar el resultado 
            }
            
            function unidades($u){ 
                if ($u==0)  {$ru = " ";} 
                elseif ($u==1)  {$ru = "Un ";} 
                elseif ($u==2)  {$ru = "Dos ";} 
                elseif ($u==3)  {$ru = "Tres ";} 
                elseif ($u==4)  {$ru = "Cuatro ";} 
                elseif ($u==5)  {$ru = "Cinco ";} 
                elseif ($u==6)  {$ru = "Seis ";} 
                elseif ($u==7)  {$ru = "Siete ";} 
                elseif ($u==8)  {$ru = "Ocho ";} 
                elseif ($u==9)  {$ru = "Nueve ";} 
                elseif ($u==10) {$ru = "Diez ";} 

                elseif ($u==11) {$ru = "Once ";} 
                elseif ($u==12) {$ru = "Doce ";} 
                elseif ($u==13) {$ru = "Trece ";} 
                elseif ($u==14) {$ru = "Catorce ";} 
                elseif ($u==15) {$ru = "Quince ";} 
                elseif ($u==16) {$ru = "Dieciseis ";} 
                elseif ($u==17) {$ru = "Decisiete ";} 
                elseif ($u==18) {$ru = "Dieciocho ";} 
                elseif ($u==19) {$ru = "Diecinueve ";} 
                elseif ($u==20) {$ru = "Veinte ";} 

                elseif ($u==21) {$ru = "Veintiun ";} 
                elseif ($u==22) {$ru = "Veintidos ";} 
                elseif ($u==23) {$ru = "Veintitres ";} 
                elseif ($u==24) {$ru = "Veinticuatro ";} 
                elseif ($u==25) {$ru = "Veinticinco ";} 
                elseif ($u==26) {$ru = "Veintiseis ";} 
                elseif ($u==27) {$ru = "Veintisiente ";} 
                elseif ($u==28) {$ru = "Veintiocho ";} 
                elseif ($u==29) {$ru = "Veintinueve ";} 
                elseif ($u==30) {$ru = "Treinta ";} 

                elseif ($u==31) {$ru = "Treinta y un ";} 
                elseif ($u==32) {$ru = "Treinta y dos ";} 
                elseif ($u==33) {$ru = "Treinta y tres ";} 
                elseif ($u==34) {$ru = "Treinta y cuatro ";} 
                elseif ($u==35) {$ru = "Treinta y cinco ";} 
                elseif ($u==36) {$ru = "Treinta y seis ";} 
                elseif ($u==37) {$ru = "Treinta y siete ";} 
                elseif ($u==38) {$ru = "Treinta y ocho  ";} 
                elseif ($u==39) {$ru = "Treinta y nueve ";} 
                elseif ($u==40) {$ru = "Cuarenta ";} 

                elseif ($u==41) {$ru = "Cuarenta y un ";} 
                elseif ($u==42) {$ru = "Cuarenta y dos ";} 
                elseif ($u==43) {$ru = "Cuarenta y tres ";} 
                elseif ($u==44) {$ru = "Cuarenta y cuatro ";} 
                elseif ($u==45) {$ru = "Cuarenta y cinco ";} 
                elseif ($u==46) {$ru = "Cuarenta y seis ";} 
                elseif ($u==47) {$ru = "Cuarenta y siete ";} 
                elseif ($u==48) {$ru = "Cuarenta y ocho  ";} 
                elseif ($u==49) {$ru = "Cuarenta y nueve ";} 
                elseif ($u==50) {$ru = "Cincuenta ";} 

                elseif ($u==51) {$ru = "Cincuenta y un ";} 
                elseif ($u==52) {$ru = "Cincuenta y dos ";} 
                elseif ($u==53) {$ru = "Cincuenta y tres ";} 
                elseif ($u==54) {$ru = "Cincuenta y cuatro ";} 
                elseif ($u==55) {$ru = "Cincuenta y cinco ";} 
                elseif ($u==56) {$ru = "Cincuenta y seis ";} 
                elseif ($u==57) {$ru = "Cincuenta y siete ";} 
                elseif ($u==58) {$ru = "Cincuenta y ocho  ";} 
                elseif ($u==59) {$ru = "Cincuenta y nueve ";} 
                elseif ($u==60) {$ru = "Sesenta ";} 

                elseif ($u==61) {$ru = "Sesenta y un ";} 
                elseif ($u==62) {$ru = "Sesenta y dos ";} 
                elseif ($u==63) {$ru = "Sesenta y tres ";} 
                elseif ($u==64) {$ru = "Sesenta y cuatro ";} 
                elseif ($u==65) {$ru = "Sesenta y cinco ";} 
                elseif ($u==66) {$ru = "Sesenta y seis ";} 
                elseif ($u==67) {$ru = "Sesenta y siete ";} 
                elseif ($u==68) {$ru = "Sesenta y ocho  ";} 
                elseif ($u==69) {$ru = "Sesenta y nueve ";} 
                elseif ($u==70) {$ru = "Setenta ";} 

                elseif ($u==71) {$ru = "Setenta y un ";} 
                elseif ($u==72) {$ru = "Setenta y dos ";} 
                elseif ($u==73) {$ru = "Setenta y tres ";} 
                elseif ($u==74) {$ru = "Setenta y cuatro ";} 
                elseif ($u==75) {$ru = "Setenta y cinco ";} 
                elseif ($u==76) {$ru = "Setenta y seis ";} 
                elseif ($u==77) {$ru = "Setenta y siete ";} 
                elseif ($u==78) {$ru = "Setenta y ocho  ";} 
                elseif ($u==79) {$ru = "Setenta y nueve ";} 
                elseif ($u==80) {$ru = "Ochenta ";} 

                elseif ($u==81) {$ru = "Ochenta y un ";} 
                elseif ($u==82) {$ru = "Ochenta y dos ";} 
                elseif ($u==83) {$ru = "Ochenta y tres ";} 
                elseif ($u==84) {$ru = "Ochenta y cuatro ";} 
                elseif ($u==85) {$ru = "Ochenta y cinco ";} 
                elseif ($u==86) {$ru = "Ochenta y seis ";} 
                elseif ($u==87) {$ru = "Ochenta y siete ";} 
                elseif ($u==88) {$ru = "Ochenta y ocho  ";} 
                elseif ($u==89) {$ru = "Ochenta y nueve ";} 
                elseif ($u==90) {$ru = "Noventa ";} 

                elseif ($u==91) {$ru = "Noventa y un ";} 
                elseif ($u==92) {$ru = "Noventa y dos ";} 
                elseif ($u==93) {$ru = "Noventa y tres ";} 
                elseif ($u==94) {$ru = "Noventa y cuatro ";} 
                elseif ($u==95) {$ru = "Noventa y cinco ";} 
                elseif ($u==96) {$ru = "Noventa y seis ";} 
                elseif ($u==97) {$ru = "Noventa y siete ";} 
                elseif ($u==98) {$ru = "Noventa y ocho  ";} 
                else            {$ru = "Noventa y nueve ";} 
                return $ru; //Retornar el resultado 
            } 
            
            function decenas($d){ 
                if ($d==0)  {$rd = "";} 
                elseif ($d==1)  {$rd = "Ciento ";} 
                elseif ($d==2)  {$rd = "Doscientos ";} 
                elseif ($d==3)  {$rd = "Trescientos ";} 
                elseif ($d==4)  {$rd = "Cuatrocientos ";} 
                elseif ($d==5)  {$rd = "Quinientos ";} 
                elseif ($d==6)  {$rd = "Seiscientos ";} 
                elseif ($d==7)  {$rd = "Setecientos ";} 
                elseif ($d==8)  {$rd = "Ochocientos ";} 
                else            {$rd = "Novecientos ";} 
                return $rd; //Retornar el resultado 
            }
        //-

        //Cortez de caja en tickets-----------------------------------------------------------------------
            function eliminarTildes($cadena){

                $cadena = str_replace(

                    array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),

                    array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),

                    $cadena

                );

                

                $cadena = str_replace(

                    array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),

                    array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),

                    $cadena

                );

                

                $cadena = str_replace(

                    array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),

                    array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),

                    $cadena

                );

                

                $cadena = str_replace(

                    array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),

                    array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),

                    $cadena

                );

                

                $cadena = str_replace(

                    array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),

                    array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),

                    $cadena

                );

                

                $cadena = str_replace(

                    array('ñ', 'Ñ', 'ç', 'Ç'),

                    array('n', 'N', 'c', 'C'),

                    $cadena

                );

                

                return $cadena;

            }

            function imprimirApertura($fechaactual, $idcentro, $idcaja){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->load->model('ventas_model'); $this->load->model('global_model');

                    $this->load->model('sucursal_model'); $this->load->model('caja_model');

                    

                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);

                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);

                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);

                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);

                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);

                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);

                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                    

                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    $datoscaja = $this->caja_model->getNameCaja($idcaja);

                    

                    foreach($datoscaja as $caja){

                        $namecaja = $caja->descrip;

                        $numcaja = $caja->resolucion;

                        $fondocaja = $caja->cajafondo;

                    }

                    

                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                    $datospr = explode("/", $datosprint);

                    

                    $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                    $partesFecha = explode("/", $fechaCorte);

                    $archivoTxt = fopen("AperturaCaja".$partesFecha[2].$partesFecha[1].$partesFecha[0].".gox",'w+');

                    

                $contenidoHeader = '@ 01,11 Say Ansitooem("'.str_pad($RazonSocial, 10, " ", STR_PAD_BOTH).'")';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $address = substr($direccion ,0,30);

                    

                    $contenidoHeader = '@ Prow ()+1,00 Say "'.str_pad($address, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,13 Say "'.str_pad($namecaja, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,00 Say "NRC:'.$NRF.' NIT: '.$NIT.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,03 Say "'.str_pad($GIRO, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                        

                    $contenidoHeader = '@ Prow ()+1,00 Say "IVA D.L. N 296"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ 07,12 Say "APERTURA DE CAJA"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ 08,15 Say "'.$fechaCorte.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ 09,07 Say "CAJERO: '.$this->session->userdata('userLog').'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ 10,13 Say "FONDO: '.number_format($fondocaja, 2, '.', '').'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ 11,12 Say "SE APERTURO CAJA"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say CHR(27)+"i"';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    fclose($archivoTxt);

                    

                    $docTxt = "AperturaCaja".$partesFecha[2].$partesFecha[1].$partesFecha[0].".gox";

                    if(file_exists($docTxt)){

                        header('Content-Description: File Transfer');

                        header('Content-Type: application/octet-stream');

                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');

                        header('Expires: 0');

                        header('Cache-Control: must-revalidate');

                        header('Pragma: public');

                        header('Content-Length: ' . filesize($docTxt));

                        readfile($docTxt);                    

                        unlink($docTxt);

                        exit;

                    }

                }

            }
            
            function reporteCorteX($fechaactual, $idcentro, $idcaja){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->load->model('ventas_model');

                    $this->load->model('global_model');

                    $this->load->model('sucursal_model');

                    $this->load->model('invtran_model');

                    $this->load->model('caja_model');



                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);

                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);

                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);

                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);

                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);

                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);

                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                    

                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    $datoscaja = $this->caja_model->getNameCaja($idcaja);

                    

                    foreach($datoscaja as $caja){

                        $namecaja = $caja->descrip;

                        $numcaja = $caja->resolucion;

                        $numero_x = $caja->numx;

                        $numero_z = $caja->numz;

                    }

                    

                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                    $datospr = explode("/", $datosprint);

                    

                    $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                    $facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                    $tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);



                    $cnt = 0;

                    $valpag = array();



                    foreach($tipospagos as $tip){

                        $valpag[$tip->cajclase] = 0;

                        $valpagG[$tip->cajclase] = 0;

                        $cnt++;

                    }



                    $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                    $archivoTxt = fopen("CorteX".$numero_x."Z".$numero_z.".gox",'w+');



                $contenidoHeader = '@ 01,11 Say Ansitooem("'.str_pad($RazonSocial, 10, " ", STR_PAD_BOTH).'")';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $address = substr($direccion ,0,30);

                    

                    $contenidoHeader = '@ Prow ()+1,00 Say "'.str_pad($address, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,13 Say "'.str_pad($namecaja, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,00 Say "NRC:'.$NRF.' NIT: '.$NIT.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,03 Say "'.str_pad($GIRO, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                        

                    $contenidoHeader = '@ Prow ()+1,00 Say "IVA D.L. N 296"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 07,13 Say "CORTE X N '.$numero_x.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 08,13 Say "'.$fechaCorte.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 10,00 SAY Replicate("-",36)';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 12,00 SAY "TRANSACCIONES:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $subtotal=0; $totalglobal=0; $totalexglobal=0;

                    $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;

                    $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                    

                    date_default_timezone_set('America/El_Salvador');

                    $date = new DateTime();



                    $anio = $date->format("Y");

                    $mes = $date->format("m");

                    $dia = $date->format("d");



                    $hours = $date->format("h");

                    $minutes = $date->format("i");

                    $seconds = $date->format("s");

                    $ampm = $hours >= 12 ? 'PM' : 'AM';



                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12; // the hour '0' should be '12'

                    $minutes = $minutes < 10 ? '0'.$minutes : $minutes;

                    $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                    $subtotal=0;

                    $totalglobal=0;

                    $totalexglobal=0;

                    $totalgrglobal=0;

                    $totalivglobal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $numdoc = 0;

                    $numdocg = 0;

                    

                    

                    foreach($documentos as $docs){

                        $numdoc = 0; $subtotal=0;

                        $subtotalex = 0; $subtotalgr = 0;

                        $subtotaliv = 0; $t = 0;



                        $contenidoHeader = '@ Prow()+2,02 SAY "'.$docs->descrip.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        foreach($facturas as $ven){

                            if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                                $valtot = $ven->valventan + $ven->valtax1;

                                $subtotal= $subtotal+$valtot;



                                if($t == 0){

                                    $numInicial = $ven->numero;

                                }



                                $total = 0; $totalGravado = 0; $totalExento = 0;

                                $totalIVA = 0; $invexento = $ven->exento;



                                $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                                foreach($productos as $pro){

                                    if($pro->tax1 != 0 && $invexento == 0){

                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1 != 0 && $invexento == 1){

                                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1== 0 && $invexento == 0){

                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1 == 0 && $invexento == 1){

                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }

                                }



                                $subtotalex = $subtotalex + $totalExento;

                                $subtotalgr = $subtotalgr + $totalGravado;

                                $subtotaliv = $subtotaliv + $totalIVA;



                                foreach($tipospagos as $tip){

                                    $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                    foreach($pagos as $money){

                                        if($tip->cajclase == $money->cajclase){

                                            if($money->valor <= 0){

                                                $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

                                            }else{

                                                $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

                                            }

                                            

                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                        }

                                    }

                                }



                                $numdoc++; $numdocg++;

                                $numFinal = $ven->numero;

                                $t++;

                            }else{

                                foreach($tipospagos as $tip){

                                    $valpag[$tip->cajclase] = 0;

                                }

                            }

                        }





                        $numCantidad = $numInicial;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numInicial;

                        }else if($numTotal == 2){

                            $newString = '         '.$numInicial;

                        }else if($numTotal == 3){

                            $newString = '        '.$numInicial;

                        }else if($numTotal == 4){

                            $newString = '       '.$numInicial;

                        }else if($numTotal == 5){

                            $newString = '      '.$numInicial;

                        }else if($numTotal == 6){

                            $newString = '     '.$numInicial;

                        }else if($numTotal == 7){

                            $newString = '    '.$numInicial;

                        }else if($numTotal == 8){

                            $newString = '   '.$numInicial;

                        }else if($numTotal == 9){

                            $newString = '  '.$numInicial;

                        }



                        $contenidoHeader = '@ Prow()+1,15 SAY "Del:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = $numFinal;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numFinal;

                        }else if($numTotal == 2){

                            $newString = '         '.$numFinal;

                        }else if($numTotal == 3){

                            $newString = '        '.$numFinal;

                        }else if($numTotal == 4){

                            $newString = '       '.$numFinal;

                        }else if($numTotal == 5){

                            $newString = '      '.$numFinal;

                        }else if($numTotal == 6){

                            $newString = '     '.$numFinal;

                        }else if($numTotal == 7){

                            $newString = '    '.$numFinal;

                        }else if($numTotal == 8){

                            $newString = '   '.$numFinal;

                        }else if($numTotal == 9){

                            $newString = '  '.$numFinal;

                        }



                        $contenidoHeader = '@ Prow()+1,16 SAY "Al:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = $numdoc;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numdoc;

                        }else if($numTotal == 2){

                            $newString = '         '.$numdoc;

                        }else if($numTotal == 3){

                            $newString = '        '.$numdoc;

                        }else if($numTotal == 4){

                            $newString = '       '.$numdoc;

                        }else if($numTotal == 5){

                            $newString = '      '.$numdoc;

                        }else if($numTotal == 6){

                            $newString = '     '.$numdoc;

                        }else if($numTotal == 7){

                            $newString = '    '.$numdoc;

                        }else if($numTotal == 8){

                            $newString = '   '.$numdoc;

                        }else if($numTotal == 9){

                            $newString = '  '.$numdoc;

                        }



                        $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = number_format(round($subtotalex, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotalex, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad =number_format(round($subtotalgr, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotalgr, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = number_format(round($subtotaliv, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotaliv, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = number_format(round($subtotal, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotal, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $totalglobal = $totalglobal+$subtotal;

                        $totalexglobal = $totalexglobal + $subtotalex;

                        $totalgrglobal = $totalgrglobal + $subtotalgr;

                        $totalivglobal = $totalivglobal + $subtotaliv;



                    }

                    

                    $contenidoHeader = '@ Prow()+2,04 SAY "Totales"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");    

                    

                    $numCantidad = $numdoc;

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '          '.$numdoc;

                    }else if($numTotal == 2){

                        $newString = '         '.$numdoc;

                    }else if($numTotal == 3){

                        $newString = '        '.$numdoc;

                    }else if($numTotal == 4){

                        $newString = '       '.$numdoc;

                    }else if($numTotal == 5){

                        $newString = '      '.$numdoc;

                    }else if($numTotal == 6){

                        $newString = '     '.$numdoc;

                    }else if($numTotal == 7){

                        $newString = '    '.$numdoc;

                    }else if($numTotal == 8){

                        $newString = '   '.$numdoc;

                    }else if($numTotal == 9){

                        $newString = '  '.$numdoc;

                    }



                    $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $numCantidad = number_format(round($totalexglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalexglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $numCantidad = number_format(round($totalgrglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalgrglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $numCantidad = number_format(round($totalivglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalivglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $numCantidad = number_format(round($totalglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow()+2,00 SAY "INGRESOS:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");  

                    

                    $total_ing_sum=0;

                    $l=0;

                    foreach($tipospagos as $tip){

                        $l++;

                    }

                    

                    $p=0;

                    $newString='';

                    foreach($tipospagos as $tip){

                        $nameForma = substr($tip->descrip, 0, 13);

                        $totalString = strlen($nameForma);

                        $newCoordenada=0;

                        

                        if($totalString == '8'){

                            $newCoordenada = 10; 

                        }else if($totalString == '9'){

                            $newCoordenada = 9;

                        }else if($totalString == '10'){

                            $newCoordenada = 8;

                        }else if($totalString == '11'){

                            $newCoordenada = 7;

                        }else if($totalString == '12'){

                            $newCoordenada = 6;

                        }else if($totalString == '13'){

                            $newCoordenada = 5;

                        }else if($totalString == '14'){

                            $newCoordenada = 4;

                        }else if($totalString == '15'){

                            $newCoordenada = 3;

                        }else if($totalString == '16'){

                            $newCoordenada = 2;

                        }else if($totalString == '17'){

                            $newCoordenada = 1;

                        }else if($totalString == '18'){

                            $newCoordenada = 0;

                        }

                        

                        /*while($numTotal < 23){

                            $numCantidad = ' '.$numCantidad;

                        }*/



                        $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);

                        $valorString = strval($numPrecio);

                        $numTotal = strlen($valorString);



                        if($numTotal == 1){

                            $newString = '         $'.$numPrecio;

                        }else if($numTotal == 2){

                            $newString = '        $'.$numPrecio;

                        }else if($numTotal == 3){

                            $newString = '       $'.$numPrecio;

                        }else if($numTotal == 4){

                            $newString = '      $'.$numPrecio;

                        }else if($numTotal == 5){

                            $newString = '     $'.$numPrecio;

                        }else if($numTotal == 6){

                            $newString = '    $'.$numPrecio;

                        }else if($numTotal == 7){

                            $newString = '   $'.$numPrecio;

                        }else if($numTotal == 8){

                            $newString = '  $'.$numPrecio;

                        }else if($numTotal == 9){

                            $newString = ' $'.$numPrecio;

                        }



                        if($p == $l - 1){

                            $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");



                            $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                        }else{

                            $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':'.$newString.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                        }



                        $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2);

                        $p++;

                    }

                    

                    $numCantidad = number_format(round($total_ing_sum, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){ 

                        $newString = '         $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($total_ing_sum, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow()+2,00 SAY "CUADRE DE CAJA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");  

                    

                    $contenidoHeader = '@Prow()+1,06 SAY "Sist"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@Prow(),17 SAY "Caja"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@Prow(),28 SAY "Dife"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);



                    $totalSistema = 0;

                    $totalCaja = 0;

                    $numerotransacc = 0;

                    

                    foreach($infoCuadre as $info){

                        $numCantidad = substr($info->formapago, 0, 4);

                        $totalString = strval($numCantidad);



                        $numCantidad2 = number_format(round($info->valorsys, 2),2);

                        $totalString2 = strval($numCantidad2);

                        $numTotal2 = strlen($totalString2);



                        if($numTotal2 == 1){

                            $newString2 = '         $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 2){

                            $newString2 = '        $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 3){

                            $newString2 = '       $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 4){

                            $newString2 = '      $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 5){

                            $newString2 = '     $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 6){

                            $newString2 = '    $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 7){

                            $newString2 = '   $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 8){

                            $newString2 = '  $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 9){

                            $newString2 = ' $'.number_format(round($info->valorsys, 2),2);

                        }



                        $numCantidad3 = number_format(round($info->valorusr, 2),2);

                        $totalString3 = strval($numCantidad3);

                        $numTotal3 = strlen($totalString3);



                        if($numTotal3 == 1){

                            $newString3 = '         $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 2){

                            $newString3 = '        $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 3){

                            $newString3 = '       $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 4){

                            $newString3 = '      $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 5){

                            $newString3 = '     $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 6){

                            $newString3 = '    $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 7){

                            $newString3 = '   $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 8){

                            $newString3 = '  $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 9){

                            $newString3 = ' $'.number_format(round($info->valorusr, 2),2);

                        }



                        $valorSistema = round($info->valorsys, 2);

                        $valorCaja = round($info->valorusr, 2);



                        $totalSistema = $totalSistema + $valorSistema;

                        $totalCaja = $totalCaja + $valorCaja;



                        if($valorSistema == 0){

                            $diferencia = $valorCaja;

                        }else{

                            $diferencia = $valorCaja - $valorSistema;

                        }



                        $numCantidad4 = number_format(round($diferencia, 2),2);

                        $totalString4 = strval($numCantidad4);

                        $numTotal4 = strlen($totalString4);



                        if($numTotal4 == 1){

                            $newString4 = '         $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 2){

                            $newString4 = '        $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 3){

                            $newString4 = '       $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 4){

                            $newString4 = '      $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 5){

                            $newString4 = '     $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 6){

                            $newString4 = '    $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 7){

                            $newString4 = '   $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 8){

                            $newString4 = '  $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 9){

                            $newString4 = ' $'.number_format(round($diferencia, 2),2);

                        }



                        $countSys = '('.$info->countsys.')';

                        $stringCount = strval($countSys);

                        $totalString = strlen($stringCount);

                        /*while($totalString < 5){

                            $stringCount = ' '.$stringCount;

                        }*/



                        $countUser = '('.$info->countuser.')';

                        $stringCountUser = strval($countUser);

                        $totalString = strlen($stringCountUser);

                        /*

                        while($totalString < 5){

                            $stringCountUser = ' '.$stringCountUser;

                        }*/



                        $contenidoHeader = '@Prow()+1,00 SAY "'.$numCantidad.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),06 SAY "$ '.$numCantidad2.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),17 SAY "$ '.$numCantidad3.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),28 SAY "$ '.$numCantidad4.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        

                        $numerotransacc = $numerotransacc + 1;

                    }

                    

                    $numTotSistema = number_format(round($totalSistema, 2),2);

                    $countString = strval($numTotSistema);

                    $numSistema = strlen($countString);



                    if($numSistema == 1){

                        $valorSistema = '         $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 2){

                        $valorSistema = '        $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 3){

                        $valorSistema = '       $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 4){

                        $valorSistema = '      $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 5){

                        $valorSistema = '     $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 6){

                        $valorSistema = '    $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 7){

                        $valorSistema = '   $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 8){

                        $valorSistema = '  $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 9){

                        $valorSistema = ' $'.number_format(round($totalSistema, 2),2);

                    }



                    $numTotCaja = number_format(round($totalCaja, 2),2);

                    $countString = strval($numTotCaja);

                    $numCaja = strlen($countString);



                    if($numCaja == 1){

                        $valorCaja = '         $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 2){

                        $valorCaja = '        $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 3){

                        $valorCaja = '       $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 4){

                        $valorCaja = '      $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 5){

                        $valorCaja = '     $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 6){

                        $valorCaja = '    $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 7){

                        $valorCaja = '   $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 8){

                        $valorCaja = '  $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 9){

                        $valorCaja = ' $'.number_format(round($totalCaja, 2),2);

                    }



                    $totalDiferencia = $totalCaja - $totalSistema;

                    $numTotDif = number_format(round($totalDiferencia, 2),2);

                    $countString = strval($numTotDif);

                    $numDif = strlen($countString);



                    if($numDif == 1){

                        $valorTotDif = '         $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 2){

                        $valorTotDif = '        $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 3){

                        $valorTotDif = '       $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 4){

                        $valorTotDif = '      $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 5){

                        $valorTotDif = '     $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 6){

                        $valorTotDif = '    $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 7){

                        $valorTotDif = '   $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 8){

                        $valorTotDif = '  $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 9){

                        $valorTotDif = ' $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 10){

                        $valorTotDif = '$'.number_format(round($totalDiferencia, 2),2);

                    }

                    

                if($numerotransacc > 1){

                    

                    $contenidoHeader = '@Prow()+1,00 SAY "Resumen:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@Prow()+1,05 SAY "Sistema:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@Prow(),20 SAY "'.$valorSistema.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@Prow()+1,08 SAY "Caja:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@Prow(),20 SAY "'.$valorCaja.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    if($totalDiferencia > 0){

                        $contenidoHeader = '@Prow()+1,04 SAY "Sobrante:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    }else if($totalDiferencia < 0){

                        $contenidoHeader = '@Prow()+1,04 SAY "Faltante:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    }else if($totalDiferencia == 0){

                        $contenidoHeader = '@Prow()+1,02 SAY "Diferencia:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    }

                }

                    

                    $contenidoHeader = '@Prow()+2,04 SAY "ACTIVIDAD EN CAJA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@Prow()+1,06 SAY "Apertura de Gaveta:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                    

                    foreach($informacion as $info){

                        $fechahora = explode(" ", $info->ingresa);

                        $hora = explode(":", $fechahora[1]);

                        $hours = $hora[0];

                        $minutes = $hora[1];

                        $seconds = $hora[2];

                        $ampm = $hours >= 12 ? 'PM' : 'AM';

                        $hours = $hours % 12;

                        $hours = $hours ? $hours : 12;

                        $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                        $counthours = $hours;

                        $stringhours = $counthours;

                        /*

                        while(strlen($stringhours) < 2){

                            $stringhours = ' '.$stringhours;

                        }*/



                        $countmin = $minutes;

                        $stringmin = $countmin;

                        /*

                        while(strlen($stringmin) < 2){

                            $stringmin = ' '.$stringmin;

                        }*/



                        $countsec = $seconds;

                        $stringsec = $countsec;

                        /*

                        while(strlen($stringsec) < 2){

                            $stringsec = ' '.$stringsec;

                        }*/



                        $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;



                        $contenidoHeader = '@Prow()+1,06 SAY "'.$hora_apertura.' '.$info->nameuser.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    }

                    

                    $nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);

                    

                    $contenidoHeader = '@Prow()+2,00 SAY "F.___________________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,10 SAY "'.trim($this->session->userdata('userLog')).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,13 SAY "'.$dia. '/' .$mes.'/'.$anio.'  '.$strTime.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,00 SAY "_____________________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,00 SAY "_____________________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say CHR(27)+"i"';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    fclose($archivoTxt);



                    $docTxt = "CorteX".$numero_x."Z".$numero_z.".gox";

                    if(file_exists($docTxt)){

                        header('Content-Description: File Transfer');

                        header('Content-Type: application/octet-stream');

                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');

                        header('Expires: 0');

                        header('Cache-Control: must-revalidate');

                        header('Pragma: public');

                        header('Content-Length: ' . filesize($docTxt));

                        readfile($docTxt);



                        unlink($docTxt);

                        exit;

                    }

                    

                }

            }
        
            function impresionCorteX($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->load->model('ventas_model');

                    $this->load->model('global_model');

                    $this->load->model('sucursal_model');

                    $this->load->model('invtran_model');

                    $this->load->model('caja_model');



                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);

                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);

                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);

                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);

                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);

                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);

                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                    

                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    $datoscaja = $this->caja_model->getNameCaja($idcaja);

                    

                    foreach($datoscaja as $caja){

                        $namecaja = $caja->descrip;

                        $numcaja = $caja->resolucion;        

                    }

                    

                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                    $datospr = explode("/", $datosprint);

                    

                    $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                    $facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                    $tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);



                    $cnt = 0;

                    $valpag = array();

                    

                    date_default_timezone_set('America/El_Salvador');

                    $date = new DateTime();



                    $anio = $date->format("Y");

                    $mes = $date->format("m");

                    $dia = $date->format("d");



                    $hours = $date->format("h");

                    $minutes = $date->format("i");

                    $seconds = $date->format("s");

                    $ampm = $hours >= 12 ? 'PM' : 'AM';



                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12; // the hour '0' should be '12'

                    $minutes = $minutes < 10 ? '0'.$minutes : $minutes;

                    $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                    $subtotal=0;

                    $totalglobal=0;

                    $totalexglobal=0;

                    $totalgrglobal=0;

                    $totalivglobal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $numdoc = 0;

                    $numdocg = 0;



                    foreach($tipospagos as $tip){

                        $valpag[$tip->cajclase] = 0;

                        $valpagG[$tip->cajclase] = 0;

                        $cnt++;

                    }



                    $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                    $archivoTxt = fopen("impCorteX".$numero_x."Z".$numero_z.".gox",'w+');



                    $contenidoHeader = '@ 01,11 Say Ansitooem("'.str_pad($RazonSocial, 10, " ", STR_PAD_BOTH).'")';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $address = substr($direccion ,0,30);

                    

                    $contenidoHeader = '@ Prow ()+1,00 Say "'.str_pad($address, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,13 Say "'.str_pad($namecaja, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,00 Say "NRC:'.$NRF.' NIT: '.$NIT.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,03 Say "'.str_pad($GIRO, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                        

                    $contenidoHeader = '@ Prow ()+1,00 Say "IVA D.L. N 296"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 07,13 Say "CORTE X N '.$numero_x.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 08,13 Say "'.$fechaCorte.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 10,00 SAY Replicate("-",36)';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 12,00 SAY "TRANSACCIONES:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ 12,00 SAY "TRANSACCIONES:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    



                    $subtotal=0; $totalglobal=0; $totalexglobal=0;

                    $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;

                    $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                    

                    foreach($documentos as $docs){

                        $numdoc = 0; $subtotal=0;

                        $subtotalex = 0; $subtotalgr = 0;

                        $subtotaliv = 0; $t = 0;



                        $contenidoHeader = '@ Prow()+2,02 SAY "'.$docs->descrip.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        foreach($facturas as $ven){

                            if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                                $valtot = $ven->valventan + $ven->valtax1;

                                $subtotal= $subtotal+$valtot;



                                if($t == 0){

                                    $numInicial = $ven->numero;

                                }



                                $total = 0; $totalGravado = 0; $totalExento = 0;

                                $totalIVA = 0; $invexento = $ven->exento;



                                $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                                foreach($productos as $pro){

                                    if($pro->tax1 != 0 && $invexento == 0){

                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1 != 0 && $invexento == 1){

                                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1== 0 && $invexento == 0){

                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1 == 0 && $invexento == 1){

                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }

                                }



                                $subtotalex = $subtotalex + $totalExento;

                                $subtotalgr = $subtotalgr + $totalGravado;

                                $subtotaliv = $subtotaliv + $totalIVA;



                                foreach($tipospagos as $tip){

                                    $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                    foreach($pagos as $money){

                                        if($tip->cajclase == $money->cajclase){

                                            if($money->valor <= 0){

                                                $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

                                            }else{

                                                $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

                                            }

                                            

                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                        }

                                    }

                                }



                                $numdoc++; $numdocg++;

                                $numFinal = $ven->numero;

                                $t++;

                            }else{

                                foreach($tipospagos as $tip){

                                    $valpag[$tip->cajclase] = 0;

                                }

                            }

                        }





                        $numCantidad = $numInicial;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);

                        $newString = str_pad($numTotal, 11, " ", STR_PAD_LEFT);



                        /*if($numTotal == 1){

                            $newString = '          '.$numInicial;

                        }else if($numTotal == 2){

                            $newString = '         '.$numInicial;

                        }else if($numTotal == 3){

                            $newString = '        '.$numInicial;

                        }else if($numTotal == 4){

                            $newString = '       '.$numInicial;

                        }else if($numTotal == 5){

                            $newString = '      '.$numInicial;

                        }else if($numTotal == 6){

                            $newString = '     '.$numInicial;

                        }else if($numTotal == 7){

                            $newString = '    '.$numInicial;

                        }else if($numTotal == 8){

                            $newString = '   '.$numInicial;

                        }else if($numTotal == 9){

                            $newString = '  '.$numInicial;

                        }*/



                        $contenidoHeader = '@ Prow()+1,15 SAY "Del:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = $numFinal;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numFinal;

                        }else if($numTotal == 2){

                            $newString = '         '.$numFinal;

                        }else if($numTotal == 3){

                            $newString = '        '.$numFinal;

                        }else if($numTotal == 4){

                            $newString = '       '.$numFinal;

                        }else if($numTotal == 5){

                            $newString = '      '.$numFinal;

                        }else if($numTotal == 6){

                            $newString = '     '.$numFinal;

                        }else if($numTotal == 7){

                            $newString = '    '.$numFinal;

                        }else if($numTotal == 8){

                            $newString = '   '.$numFinal;

                        }else if($numTotal == 9){

                            $newString = '  '.$numFinal;

                        }



                        $contenidoHeader = '@ Prow()+1,16 SAY "Al:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = $numdoc;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numdoc;

                        }else if($numTotal == 2){

                            $newString = '         '.$numdoc;

                        }else if($numTotal == 3){

                            $newString = '        '.$numdoc;

                        }else if($numTotal == 4){

                            $newString = '       '.$numdoc;

                        }else if($numTotal == 5){

                            $newString = '      '.$numdoc;

                        }else if($numTotal == 6){

                            $newString = '     '.$numdoc;

                        }else if($numTotal == 7){

                            $newString = '    '.$numdoc;

                        }else if($numTotal == 8){

                            $newString = '   '.$numdoc;

                        }else if($numTotal == 9){

                            $newString = '  '.$numdoc;

                        }



                        $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = number_format(round($subtotalex, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotalex, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad =number_format(round($subtotalgr, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotalgr, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = number_format(round($subtotaliv, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotaliv, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = number_format(round($subtotal, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);

                        $newString = str_pad('$'.$numCantidad, 11, " ", STR_PAD_LEFT);



                        /*if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotal, 2),2);

                        }*/



                        $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $totalglobal = $totalglobal+$subtotal;

                        $totalexglobal = $totalexglobal + $subtotalex;

                        $totalgrglobal = $totalgrglobal + $subtotalgr;

                        $totalivglobal = $totalivglobal + $subtotaliv;



                    }

                    

                    $contenidoHeader = '@ Prow()+2,04 SAY "Totales"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");    

                    

                    $numCantidad = $numdoc;

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '          '.$numdoc;

                    }else if($numTotal == 2){

                        $newString = '         '.$numdoc;

                    }else if($numTotal == 3){

                        $newString = '        '.$numdoc;

                    }else if($numTotal == 4){

                        $newString = '       '.$numdoc;

                    }else if($numTotal == 5){

                        $newString = '      '.$numdoc;

                    }else if($numTotal == 6){

                        $newString = '     '.$numdoc;

                    }else if($numTotal == 7){

                        $newString = '    '.$numdoc;

                    }else if($numTotal == 8){

                        $newString = '   '.$numdoc;

                    }else if($numTotal == 9){

                        $newString = '  '.$numdoc;

                    }



                    $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $numCantidad = number_format(round($totalexglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalexglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $numCantidad = number_format(round($totalgrglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalgrglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $numCantidad = number_format(round($totalivglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalivglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $numCantidad = number_format(round($totalglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow()+2,00 SAY "INGRESOS:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");  

                    $contenidoHeader = '@ Prow(),00 SAY "INGRESOS:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");  

                    

                    

                    $total_ing_sum=0;

                    $l=0;

                    foreach($tipospagos as $tip){

                        $l++;

                    } 

                    $p=0;

                    $total_cre_sum=0;

                    $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);



                    

                    foreach($tipospagos as $tip){

                        $nameForma = substr($tip->descrip, 0, 13);

                        $totalString = strlen($nameForma);

                        $newCoordenada=0;

                        

                        if($totalString == '8'){

                            $newCoordenada = 10; 

                        }else if($totalString == '9'){

                            $newCoordenada = 9;

                        }else if($totalString == '10'){

                            $newCoordenada = 8;

                        }else if($totalString == '11'){

                            $newCoordenada = 7;

                        }else if($totalString == '12'){

                            $newCoordenada = 6;

                        }else if($totalString == '13'){

                            $newCoordenada = 5;

                        }else if($totalString == '14'){

                            $newCoordenada = 4;

                        }else if($totalString == '15'){

                            $newCoordenada = 3;

                        }else if($totalString == '16'){

                            $newCoordenada = 2;

                        }else if($totalString == '17'){

                            $newCoordenada = 1;

                        }else if($totalString == '18'){

                            $newCoordenada = 0;

                        }

                        

                        /*while($numTotal < 23){

                            $numCantidad = ' '.$numCantidad;

                        }*/



                        $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);

                        $valorString = strval($numPrecio);

                        $numTotal = strlen($valorString);



                        if($numTotal == 1){

                            $newString = '         $'.$numPrecio;

                        }else if($numTotal == 2){

                            $newString = '        $'.$numPrecio;

                        }else if($numTotal == 3){

                            $newString = '       $'.$numPrecio;

                        }else if($numTotal == 4){

                            $newString = '      $'.$numPrecio;

                        }else if($numTotal == 5){

                            $newString = '     $'.$numPrecio;

                        }else if($numTotal == 6){

                            $newString = '    $'.$numPrecio;

                        }else if($numTotal == 7){

                            $newString = '   $'.$numPrecio;

                        }else if($numTotal == 8){

                            $newString = '  $'.$numPrecio;

                        }else if($numTotal == 9){

                            $newString = ' $'.$numPrecio;

                        }



                        if($p == $l - 1){

                            $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");



                            $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                        }else{

                            $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':'.$newString.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                            

                            if($pagos_credito!=false){

                                foreach($pagos_credito as $pag){

                                    

                                    $nameFormaCr = 'Credito';

                                    $totalStringCr = strlen($nameFormaCr);

                                    $newCoordenada=0;



                                    if($totalStringCr == '8'){

                                        $newCoordenada = 10; 

                                    }else if($totalStringCr == '9'){

                                        $newCoordenada = 9;

                                    }else if($totalStringCr == '10'){

                                        $newCoordenada = 8;

                                    }else if($totalStringCr == '11'){

                                        $newCoordenada = 7;

                                    }else if($totalStringCr == '12'){

                                        $newCoordenada = 6;

                                    }else if($totalStringCr == '13'){

                                        $newCoordenada = 5;

                                    }else if($totalStringCr == '14'){

                                        $newCoordenada = 4;

                                    }else if($totalStringCr == '15'){

                                        $newCoordenada = 3;

                                    }else if($totalStringCr == '16'){

                                        $newCoordenada = 2;

                                    }else if($totalStringCr == '17'){

                                        $newCoordenada = 1;

                                    }else if($totalStringCr == '18'){

                                        $newCoordenada = 0;

                                    }   

                                    

                                    $numPrecioCr = number_format(round($pag->valor, 2),2);

                                    $valorStringCr = strval($numPrecio);

                                    $numTotalCr = strlen($valorString);

                                    

                                    if($numTotalCr == 1){

                                        $newString = '         $'.$numPrecioCr;

                                    }else if($numTotalCr == 2){

                                        $newString = '        $'.$numPrecioCr;

                                    }else if($numTotalCr == 3){

                                        $newString = '       $'.$numPrecioCr;

                                    }else if($numTotalCr == 4){

                                        $newString = '      $'.$numPrecioCr;

                                    }else if($numTotalCr == 5){

                                        $newString = '     $'.$numPrecioCr;

                                    }else if($numTotalCr == 6){

                                        $newString = '    $'.$numPrecioCr;

                                    }else if($numTotalCr == 7){

                                        $newString = '   $'.$numPrecioCr;

                                    }else if($numTotalCr == 8){

                                        $newString = '  $'.$numPrecioCr;

                                    }else if($numTotalCr == 9){

                                        $newString = ' $'.$numPrecioCr;

                                    }

                                    $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameFormaCr.':'.$newString.'"';

                                    fwrite($archivoTxt, $contenidoHeader);

                                    fwrite($archivoTxt, "\r\n");

                                    

                                    $total_cre_sum+=round($pag->valor, 2);

                                }

                            }

                        }



                        $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;

                        $p++;

                    }

                    

                    $numCantidad = number_format(round($total_ing_sum, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){ 

                        $newString = '         $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($total_ing_sum, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow()+2,00 SAY "CUADRE DE CAJA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n"); 

                    $contenidoHeader = '@ Prow(),00 SAY "CUADRE DE CAJA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n"); 

                    

                    $contenidoHeader = '@Prow()+1,06 SAY "Sist"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@Prow(),17 SAY "Caja"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@Prow(),28 SAY "Dife"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);



                    $totalSistema = 0;

                    $totalCaja = 0;

                    $numerotransacc = 0;

                    

                    foreach($infoCuadre as $info){

                        $numCantidad = substr($info->formapago, 0, 4);

                        $totalString = strval($numCantidad);



                        $numCantidad2 = number_format(round($info->valorsys, 2),2);

                        $totalString2 = strval($numCantidad2);

                        $numTotal2 = strlen($totalString2);



                        if($numTotal2 == 1){

                            $newString2 = '         $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 2){

                            $newString2 = '        $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 3){

                            $newString2 = '       $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 4){

                            $newString2 = '      $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 5){

                            $newString2 = '     $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 6){

                            $newString2 = '    $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 7){

                            $newString2 = '   $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 8){

                            $newString2 = '  $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 9){

                            $newString2 = ' $'.number_format(round($info->valorsys, 2),2);

                        }



                        $numCantidad3 = number_format(round($info->valorusr, 2),2);

                        $totalString3 = strval($numCantidad3);

                        $numTotal3 = strlen($totalString3);



                        if($numTotal3 == 1){

                            $newString3 = '         $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 2){

                            $newString3 = '        $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 3){

                            $newString3 = '       $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 4){

                            $newString3 = '      $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 5){

                            $newString3 = '     $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 6){

                            $newString3 = '    $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 7){

                            $newString3 = '   $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 8){

                            $newString3 = '  $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 9){

                            $newString3 = ' $'.number_format(round($info->valorusr, 2),2);

                        }



                        $valorSistema = round($info->valorsys, 2);

                        $valorCaja = round($info->valorusr, 2);



                        $totalSistema = $totalSistema + $valorSistema;

                        $totalCaja = $totalCaja + $valorCaja;



                        if($valorSistema == 0){

                            $diferencia = $valorCaja;

                        }else{

                            $diferencia = $valorCaja - $valorSistema;

                        }



                        $numCantidad4 = number_format(round($diferencia, 2),2);

                        $totalString4 = strval($numCantidad4);

                        $numTotal4 = strlen($totalString4);



                        if($numTotal4 == 1){

                            $newString4 = '         $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 2){

                            $newString4 = '        $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 3){

                            $newString4 = '       $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 4){

                            $newString4 = '      $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 5){

                            $newString4 = '     $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 6){

                            $newString4 = '    $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 7){

                            $newString4 = '   $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 8){

                            $newString4 = '  $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 9){

                            $newString4 = ' $'.number_format(round($diferencia, 2),2);

                        }



                        $countSys = '('.$info->countsys.')';

                        $stringCount = strval($countSys);

                        $totalString = strlen($stringCount);

                        /*while($totalString < 5){

                            $stringCount = ' '.$stringCount;

                        }*/



                        $countUser = '('.$info->countuser.')';

                        $stringCountUser = strval($countUser);

                        $totalString = strlen($stringCountUser);

                        /*

                        while($totalString < 5){

                            $stringCountUser = ' '.$stringCountUser;

                        }*/



                        $contenidoHeader = '@Prow()+1,00 SAY "'.$numCantidad.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        

                        $contenidoHeader = '@Prow(),06 SAY "$'.$numCantidad2.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    

                        $contenidoHeader = '@Prow(),17 SAY "$'.$numCantidad3.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    

                        $contenidoHeader = '@Prow(),28 SAY "$'.$numCantidad4.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        

                        $numerotransacc = $numerotransacc + 1;

                        

                    }

                    

                    //FIN FOR CUADRE DE CAJA

                    

                    $numTotSistema = number_format(round($totalSistema, 2),2);

                    $countString = strval($numTotSistema);

                    $numSistema = strlen($countString);



                    if($numSistema == 1){

                        $valorSistema = '         $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 2){

                        $valorSistema = '        $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 3){

                        $valorSistema = '       $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 4){

                        $valorSistema = '      $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 5){

                        $valorSistema = '     $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 6){

                        $valorSistema = '    $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 7){

                        $valorSistema = '   $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 8){

                        $valorSistema = '  $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 9){

                        $valorSistema = ' $'.number_format(round($totalSistema, 2),2);

                    }



                    $numTotCaja = number_format(round($totalCaja, 2),2);

                    $countString = strval($numTotCaja);

                    $numCaja = strlen($countString);



                    if($numCaja == 1){

                        $valorCaja = '         $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 2){

                        $valorCaja = '        $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 3){

                        $valorCaja = '       $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 4){

                        $valorCaja = '      $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 5){

                        $valorCaja = '     $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 6){

                        $valorCaja = '    $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 7){

                        $valorCaja = '   $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 8){

                        $valorCaja = '  $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 9){

                        $valorCaja = ' $'.number_format(round($totalCaja, 2),2);

                    }



                    $totalDiferencia = $totalCaja - $totalSistema;

                    $numTotDif = number_format(round($totalDiferencia, 2),2);

                    $countString = strval($numTotDif);

                    $numDif = strlen($countString);



                    if($numDif == 1){

                        $valorTotDif = '         $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 2){

                        $valorTotDif = '        $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 3){

                        $valorTotDif = '       $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 4){

                        $valorTotDif = '      $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 5){

                        $valorTotDif = '     $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 6){

                        $valorTotDif = '    $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 7){

                        $valorTotDif = '   $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 8){

                        $valorTotDif = '  $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 9){

                        $valorTotDif = ' $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 10){

                        $valorTotDif = '$'.number_format(round($totalDiferencia, 2),2);

                    }

                    

                    if($numerotransacc > 1){

                    

                        $contenidoHeader = '@Prow()+2,00 SAY "Resumen:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow()+1,05 SAY "Sistema:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),20 SAY "'.$valorSistema.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow()+1,08 SAY "Caja:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),20 SAY "'.$valorCaja.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        

                        



                        if($totalDiferencia > 0){

                            $contenidoHeader = '@Prow()+1,04 SAY "Sobrante:"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");



                            $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                        }else if($totalDiferencia < 0){

                            $contenidoHeader = '@Prow()+1,04 SAY "Faltante:"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");



                            $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                        }else if($totalDiferencia == 0){

                            $contenidoHeader = '@Prow()+1,02 SAY "Diferencia:"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");



                            $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                    }

                    

                }        

                    $contenidoHeader = '@Prow()+2,04 SAY "ACTIVIDAD EN CAJA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@Prow()+1,06 SAY "Apertura de Gaveta:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                    

                    foreach($informacion as $info){

                        $fechahora = explode(" ", $info->ingresa);

                        $hora = explode(":", $fechahora[1]);

                        $hours = $hora[0];

                        $minutes = $hora[1];

                        $seconds = $hora[2];

                        $ampm = $hours >= 12 ? 'PM' : 'AM';

                        $hours = $hours % 12;

                        $hours = $hours ? $hours : 12;

                        $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                        $counthours = $hours;

                        $stringhours = $counthours;

                        /*

                        while(strlen($stringhours) < 2){

                            $stringhours = ' '.$stringhours;

                        }*/



                        $countmin = $minutes;

                        $stringmin = $countmin;

                        /*

                        while(strlen($stringmin) < 2){

                            $stringmin = ' '.$stringmin;

                        }*/



                        $countsec = $seconds;

                        $stringsec = $countsec;

                        /*

                        while(strlen($stringsec) < 2){

                            $stringsec = ' '.$stringsec;

                        }*/



                        $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;



                        $contenidoHeader = '@Prow()+1,06 SAY "'.$hora_apertura.' '.$info->nameuser.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    }

                    

                    $contenidoHeader = '@Prow()+2,00 SAY "F.___________________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,10 SAY "'.trim($this->session->userdata('userLog')).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,04 SAY "'.$dia. '/' .$mes.'/'.$anio.'  '.$strTime.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,00 SAY "_____________________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,00 SAY "_____________________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say CHR(27)+"i"';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    fclose($archivoTxt);



                    $docTxt = "impCorteX".$numero_x."Z".$numero_z.".gox";

                    if(file_exists($docTxt)){

                        header('Content-Description: File Transfer');

                        header('Content-Type: application/octet-stream');

                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');

                        header('Expires: 0');

                        header('Cache-Control: must-revalidate');

                        header('Pragma: public');

                        header('Content-Length: ' . filesize($docTxt));

                        readfile($docTxt);



                        unlink($docTxt);

                        exit;

                    }

                    

                }

            }
            # v1
            function reporteCorteZFacturaz_v1($fechaactual, $idcentro, $idcaja){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->load->model('ventas_model');

                    $this->load->model('global_model');

                    $this->load->model('sucursal_model');

                    $this->load->model('invtran_model');

                    $this->load->model('caja_model');

                    

                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);

                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);

                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);

                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);

                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);

                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);

                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                    

                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    $datoscaja = $this->caja_model->getNameCaja($idcaja);

                    

                    foreach($datoscaja as $caja){

                        $namecaja = $caja->descrip;

                        $numcaja = $caja->resolucion;

                        $numero_x = $caja->numx;

                        $numero_z = $caja->numz;

                    }

                    

                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                    $datospr = explode("/", $datosprint);

                    $documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);

                    $facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);

                    $tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);

                    

                    $cnt = 0;

                    $valpag = array();

                    

                    foreach($tipospagos as $tip){

                        $valpag[$tip->cajclase] = 0;

                        $valpagG[$tip->cajclase] = 0;

                        $cnt++;

                    }

                    

                    $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                                

                    $archivoTxt = fopen("CorteZ".$numero_z.".gox",'w+');

                    

                    $contenidoHeader = '@ 01,11 Say Ansitooem("'.str_pad($RazonSocial, 10, " ", STR_PAD_BOTH).'")';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $address = substr($direccion ,0,30);

                    

                    $contenidoHeader = '@ Prow ()+1,00 Say "'.str_pad($address, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,13 Say "'.str_pad($namecaja, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,00 Say "NRC:'.$NRF.' NIT: '.$NIT.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,03 Say "'.str_pad($GIRO, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                        

                    $contenidoHeader = '@ Prow ()+1,00 Say "IVA D.L. N 296"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 07,13 Say "CORTE Z N '.$numero_z.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ 08,13 Say "'.$fechaCorte.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 09,00 SAY Replicate("-",39)';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 11,00 SAY "DETALLE DE TRANSACCIONES:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    date_default_timezone_set('America/El_Salvador');

                    $date = new DateTime();



                    $anio = $date->format("Y");

                    $mes = $date->format("m");

                    $dia = $date->format("d");



                    $hours = $date->format("h");

                    $minutes = $date->format("i");

                    $seconds = $date->format("s");

                    $ampm = $hours >= 12 ? 'PM' : 'AM';



                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12; // the hour '0' should be '12'

                    $minutes = $minutes < 10 ? '0'.$minutes : $minutes;

                    $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                    $subtotal=0;

                    $totalglobal=0;

                    $totalexglobal=0;

                    $totalgrglobal=0;

                    $totalivglobal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $numdoc = 0;

                    $numdocg = 0;

                    

                    foreach($documentos as $docs){

                        $numdoc = 0;

                        $subtotal=0;

                        $subtotalex = 0;

                        $subtotalgr = 0;

                        $subtotaliv = 0;

                        $t = 0;

                        $contenidoHeader = '@ Prow()+2,02 SAY "'.$docs->descrip.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        foreach($facturas as $ven){

                            if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                                $valtot = $ven->valventan + $ven->valtax1;

                                $subtotal= $subtotal+$valtot;

                                if($t == 0){

                                    $numInicial = $ven->numero;

                                }

                                $total = 0;

                                $totalGravado = 0;

                                $totalExento = 0;

                                $totalIVA = 0;

                                $invexento = $ven->exento;

                                $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                                foreach($productos as $pro){

                                    if($pro->tax1 != 0 && $invexento == 0){

                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1 != 0 && $invexento == 1){

                                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1== 0 && $invexento == 0){

                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1 == 0 && $invexento == 1){

                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }

                                }



                                $subtotalex = $subtotalex + $totalExento;

                                $subtotalgr = $subtotalgr + $totalGravado;

                                $subtotaliv = $subtotaliv + $totalIVA;

                                foreach($tipospagos as $tip){

                                    $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                    foreach($pagos as $money){

                                        if($tip->cajclase == $money->cajclase){

                                            if($money->valor <= 0){

                                                $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

                                            }else{

                                                $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

                                            }

                                            

                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                        }

                                    }

                                }

                                $numdoc++;

                                $numdocg++;

                                $numFinal = $ven->numero;

                                $t++;

                            }else{

                                foreach($tipospagos as $tip){

                                    $valpag[$tip->cajclase] = 0;

                                }

                            }

                        }

                                

                        $numCantidad = $numInicial;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numInicial;

                        }else if($numTotal == 2){

                            $newString = '         '.$numInicial;

                        }else if($numTotal == 3){

                            $newString = '        '.$numInicial;

                        }else if($numTotal == 4){

                            $newString = '       '.$numInicial;

                        }else if($numTotal == 5){

                            $newString = '      '.$numInicial;

                        }else if($numTotal == 6){

                            $newString = '     '.$numInicial;

                        }else if($numTotal == 7){

                            $newString = '    '.$numInicial;

                        }else if($numTotal == 8){

                            $newString = '   '.$numInicial;

                        }else if($numTotal == 9){

                            $newString = '  '.$numInicial;

                        }



                        $contenidoHeader = '@ Prow()+1,15 SAY "Del:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

            

                            

                        $numCantidad = $numFinal;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numFinal;

                        }else if($numTotal == 2){

                            $newString = '         '.$numFinal;

                        }else if($numTotal == 3){

                            $newString = '        '.$numFinal;

                        }else if($numTotal == 4){

                            $newString = '       '.$numFinal;

                        }else if($numTotal == 5){

                            $newString = '      '.$numFinal;

                        }else if($numTotal == 6){

                            $newString = '     '.$numFinal;

                        }else if($numTotal == 7){

                            $newString = '    '.$numFinal;

                        }else if($numTotal == 8){

                            $newString = '   '.$numFinal;

                        }else if($numTotal == 9){

                            $newString = '  '.$numFinal;

                        }



                        $contenidoHeader = '@ Prow()+1,16 SAY "Al:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");        

                            





                        $numCantidad = $numdoc;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numdoc;

                        }else if($numTotal == 2){

                            $newString = '         '.$numdoc;

                        }else if($numTotal == 3){

                            $newString = '        '.$numdoc;

                        }else if($numTotal == 4){

                            $newString = '       '.$numdoc;

                        }else if($numTotal == 5){

                            $newString = '      '.$numdoc;

                        }else if($numTotal == 6){

                            $newString = '     '.$numdoc;

                        }else if($numTotal == 7){

                            $newString = '    '.$numdoc;

                        }else if($numTotal == 8){

                            $newString = '   '.$numdoc;

                        }else if($numTotal == 9){

                            $newString = '  '.$numdoc;

                        }



                        $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = number_format(round($subtotalex, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotalex, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        

                        $numCantidad =number_format(round($subtotalgr, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotalgr, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                

                        $numCantidad = number_format(round($subtotaliv, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotaliv, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = number_format(round($subtotal, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotal, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    

                        $totalglobal = $totalglobal+$subtotal;

                        $totalexglobal = $totalexglobal + $subtotalex;

                        $totalgrglobal = $totalgrglobal + $subtotalgr;

                        $totalivglobal = $totalivglobal + $subtotaliv;      

                    }

                    

                    $contenidoHeader = '@ Prow()+2,04 SAY "Totales"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n"); 

                    

                    $numCantidad = $numdoc;

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '          '.$numdoc;

                    }else if($numTotal == 2){

                        $newString = '         '.$numdoc;

                    }else if($numTotal == 3){

                        $newString = '        '.$numdoc;

                    }else if($numTotal == 4){

                        $newString = '       '.$numdoc;

                    }else if($numTotal == 5){

                        $newString = '      '.$numdoc;

                    }else if($numTotal == 6){

                        $newString = '     '.$numdoc;

                    }else if($numTotal == 7){

                        $newString = '    '.$numdoc;

                    }else if($numTotal == 8){

                        $newString = '   '.$numdoc;

                    }else if($numTotal == 9){

                        $newString = '  '.$numdoc;

                    }



                    $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    

                    $numCantidad = number_format(round($totalexglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalexglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    

                    $numCantidad = number_format(round($totalgrglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalgrglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $numCantidad = number_format(round($totalivglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalivglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $numCantidad = number_format(round($totalglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow()+2,00 SAY "INGRESOS:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");  

                    $total_ing_sum=0;

                    $l=0;

                    foreach($tipospagos as $tip){

                        $l++;

                    }

                    $p=0;

                    foreach($tipospagos as $tip){

                        $nameForma = substr($tip->descrip, 0, 13);

                        $totalString = strlen($nameForma);

                        $newCoordenada=0;

                        

                        if($totalString == '8'){

                            $newCoordenada = 10; 

                        }else if($totalString == '9'){

                            $newCoordenada = 9;

                        }else if($totalString == '10'){

                            $newCoordenada = 8;

                        }else if($totalString == '11'){

                            $newCoordenada = 7;

                        }else if($totalString == '12'){

                            $newCoordenada = 6;

                        }else if($totalString == '13'){

                            $newCoordenada = 5;

                        }else if($totalString == '14'){

                            $newCoordenada = 4;

                        }else if($totalString == '15'){

                            $newCoordenada = 3;

                        }else if($totalString == '16'){

                            $newCoordenada = 2;

                        }else if($totalString == '17'){

                            $newCoordenada = 1;

                        }else if($totalString == '18'){

                            $newCoordenada = 0;

                        }  

                                                

                        $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);

                        $valorString = strval($numPrecio);

                        $numTotal = strlen($valorString);       



                        if($numTotal == 1){

                            $newString = '         $'.$numPrecio;

                        }else if($numTotal == 2){

                            $newString = '        $'.$numPrecio;

                        }else if($numTotal == 3){

                            $newString = '       $'.$numPrecio;

                        }else if($numTotal == 4){

                            $newString = '      $'.$numPrecio;

                        }else if($numTotal == 5){

                            $newString = '     $'.$numPrecio;

                        }else if($numTotal == 6){

                            $newString = '    $'.$numPrecio;

                        }else if($numTotal == 7){

                            $newString = '   $'.$numPrecio;

                        }else if($numTotal == 8){

                            $newString = '  $'.$numPrecio;

                        }else if($numTotal == 9){

                            $newString = ' $'.$numPrecio;

                        }

                                    

                        if($p == $l - 1){

                            $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");



                            $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                                        

                        }else{ 

                            $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':'.$newString.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                        }

                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);

                        $p++;

                    }

                        

                    $numCantidad = number_format(round($total_ing_sum, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){ 

                        $newString = '         $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($total_ing_sum, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow()+2,00 SAY "CUADRE DE CAJA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n"); 

                    

                    $contenidoHeader = '@Prow()+1,06 SAY "Sist"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@Prow(),17 SAY "Caja"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@Prow(),28 SAY "Dife"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);



                    $totalSistema = 0;

                    $totalCaja = 0;

                    $numerotransacc = 0;

                    

                    foreach($infoCuadre as $info){

                        $numCantidad = substr($info->formapago, 0, 4);

                        $totalString = strval($numCantidad);



                        $numCantidad2 = number_format(round($info->valorsys, 2),2);

                        $totalString2 = strval($numCantidad2);

                        $numTotal2 = strlen($totalString2);



                        if($numTotal2 == 1){

                            $newString2 = '         $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 2){

                            $newString2 = '        $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 3){

                            $newString2 = '       $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 4){

                            $newString2 = '      $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 5){

                            $newString2 = '     $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 6){

                            $newString2 = '    $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 7){

                            $newString2 = '   $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 8){

                            $newString2 = '  $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 9){

                            $newString2 = ' $'.number_format(round($info->valorsys, 2),2);

                        }



                        $numCantidad3 = number_format(round($info->valorusr, 2),2);

                        $totalString3 = strval($numCantidad3);

                        $numTotal3 = strlen($totalString3);



                        if($numTotal3 == 1){

                            $newString3 = '         $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 2){

                            $newString3 = '        $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 3){

                            $newString3 = '       $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 4){

                            $newString3 = '      $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 5){

                            $newString3 = '     $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 6){

                            $newString3 = '    $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 7){

                            $newString3 = '   $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 8){

                            $newString3 = '  $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 9){

                            $newString3 = ' $'.number_format(round($info->valorusr, 2),2);

                        }



                        $valorSistema = round($info->valorsys, 2);

                        $valorCaja = round($info->valorusr, 2);



                        $totalSistema = $totalSistema + $valorSistema;

                        $totalCaja = $totalCaja + $valorCaja;



                        if($valorSistema == 0){

                            $diferencia = $valorCaja;

                        }else{

                            $diferencia = $valorCaja - $valorSistema;

                        }



                        $numCantidad4 = number_format(round($diferencia, 2),2);

                        $totalString4 = strval($numCantidad4);

                        $numTotal4 = strlen($totalString4);



                        if($numTotal4 == 1){

                            $newString4 = '         $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 2){

                            $newString4 = '        $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 3){

                            $newString4 = '       $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 4){

                            $newString4 = '      $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 5){

                            $newString4 = '     $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 6){

                            $newString4 = '    $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 7){

                            $newString4 = '   $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 8){

                            $newString4 = '  $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 9){

                            $newString4 = ' $'.number_format(round($diferencia, 2),2);

                        }



                        $countSys = '('.$info->countsys.')';

                        $stringCount = strval($countSys);

                        $totalString = strlen($stringCount);

                        /*while($totalString < 5){

                            $stringCount = ' '.$stringCount;

                        }*/



                        $countUser = '('.$info->countuser.')';

                        $stringCountUser = strval($countUser);

                        $totalString = strlen($stringCountUser);

                        /*

                        while($totalString < 5){

                            $stringCountUser = ' '.$stringCountUser;

                        }*/



                        $contenidoHeader = '@Prow()+1,00 SAY "'.$numCantidad.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),06 SAY "$ '.$numCantidad2.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),17 SAY "$ '.$numCantidad3.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),28 SAY "$ '.$numCantidad4.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        

                        $numerotransacc = $numerotransacc + 1;

                    

                    }

                    

                    $this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);

                    

                    

                    $numTotSistema = number_format(round($totalSistema, 2),2);

                    $countString = strval($numTotSistema);

                    $numSistema = strlen($countString);



                    if($numSistema == 1){

                        $valorSistema = '         $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 2){

                        $valorSistema = '        $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 3){

                        $valorSistema = '       $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 4){

                        $valorSistema = '      $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 5){

                        $valorSistema = '     $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 6){

                        $valorSistema = '    $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 7){

                        $valorSistema = '   $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 8){

                        $valorSistema = '  $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 9){

                        $valorSistema = ' $'.number_format(round($totalSistema, 2),2);

                    }



                    $numTotCaja = number_format(round($totalCaja, 2),2);

                    $countString = strval($numTotCaja);

                    $numCaja = strlen($countString);



                    if($numCaja == 1){

                        $valorCaja = '         $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 2){

                        $valorCaja = '        $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 3){

                        $valorCaja = '       $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 4){

                        $valorCaja = '      $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 5){

                        $valorCaja = '     $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 6){

                        $valorCaja = '    $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 7){

                        $valorCaja = '   $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 8){

                        $valorCaja = '  $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 9){

                        $valorCaja = ' $'.number_format(round($totalCaja, 2),2);

                    }



                    $totalDiferencia = $totalCaja - $totalSistema;

                    $numTotDif = number_format(round($totalDiferencia, 2),2);

                    $countString = strval($numTotDif);

                    $numDif = strlen($countString);



                    if($numDif == 1){

                        $valorTotDif = '         $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 2){

                        $valorTotDif = '        $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 3){

                        $valorTotDif = '       $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 4){

                        $valorTotDif = '      $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 5){

                        $valorTotDif = '     $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 6){

                        $valorTotDif = '    $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 7){

                        $valorTotDif = '   $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 8){

                        $valorTotDif = '  $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 9){

                        $valorTotDif = ' $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 10){

                        $valorTotDif = '$'.number_format(round($totalDiferencia, 2),2);

                    }

                    

                if($numerotransacc > 1){

                    

                    $contenidoHeader = '@Prow()+1,00 SAY "Resumen:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@Prow()+1,05 SAY "Sistema:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@Prow(),20 SAY "'.$valorSistema.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@Prow()+1,08 SAY "Caja:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@Prow(),20 SAY "'.$valorCaja.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    if($totalDiferencia > 0){

                        $contenidoHeader = '@Prow()+1,04 SAY "Sobrante:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    }else if($totalDiferencia < 0){

                        $contenidoHeader = '@Prow()+1,04 SAY "Faltante:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    }else if($totalDiferencia == 0){

                        $contenidoHeader = '@Prow()+1,02 SAY "Diferencia:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    }

                    

                }

                    

                    

                    $contenidoHeader = '@Prow()+2,00 SAY "F._______________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,08 SAY "'.trim($this->session->userdata('userLog')).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,08 SAY "'.$dia. '/' .$mes.'/'.$anio.'  '.$strTime.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,00 SAY "_________________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,00 SAY "_________________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say CHR(27)+"i"';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    fclose($archivoTxt);



                    $docTxt = "CorteZ".$numero_z.".gox";

                    if(file_exists($docTxt)){

                        header('Content-Description: File Transfer');

                        header('Content-Type: application/octet-stream');

                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');

                        header('Expires: 0');

                        header('Cache-Control: must-revalidate');

                        header('Pragma: public');

                        header('Content-Length: ' . filesize($docTxt));

                        readfile($docTxt);



                        unlink($docTxt);

                        exit;

                    }    

                }

            }
            # v2
            function reporteCorteZFacturaz_v2($fechaactual, $idcentro, $idcaja){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->model('ventas_model');
                    $this->load->model('global_model');
                    $this->load->model('sucursal_model');
                    $this->load->model('invtran_model');
                    $this->load->model('caja_model');
                    
                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                    
                    
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    
                    foreach($datoscaja as $caja){
                        $namecaja = $caja->descrip;
                        $numcaja = $caja->resolucion;
                        $numero_x = $caja->numx;
                        $numero_z = $caja->numz;
                    }
                    
                    $documentos = $this->global_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual);
                    $facturas = $this->global_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual);
                    $tipospagos = $this->global_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual);
                    
                    $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                    
                    $cnt = 0;
                    $valpag = array();
                    
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                        $valpagG[$tip->cajclase] = 0;
                        $cnt++;
                    }
                    
                    $archivoTxt = fopen("CORTEZ".$numero_z.".gox", 'w+');
                    
                    /*$contenidoHeader = 'opBold + opBig + opCenter + "'.trim($RazonSocial).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");//*/

                    $contenidoHeader = 'opBold + opBig + opCenter + "'.strtoupper($namecentro).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = 'opBold + opCenter + "'.strtoupper($namecaja).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                

                    /*$contenidoHeader = 'opCenter + "NRC: '.$NRF.' NIT: '.$NIT.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = 'opCenter + "Giro: '.$GIRO.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = 'opCenter + "IVA D.L. N# 296"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");//*/
                    
                    $contenidoHeader = 'opBold + opCenter + "REPORTE VENTAS DIARIAS"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = 'opBold + opCenter + "'.$fechaCorte.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = 'opBold + opCenter + "------------------------------------------"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = 'opBold + " TRANSACCIONES:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                        
                    $subtotal=0; $totalglobal=0; $totalexglobal=0;
                    $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                    $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
                    $numdocg = 0;
                    
                    foreach($documentos as $docs){
                        $numdoc = 0; $subtotal=0; $subtotalex = 0;
                        $subtotalgr = 0; $subtotaliv = 0; $t = 0;
                        
                        $contenidoHeader = 'opBold + "  '.$docs->descrip.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        foreach($facturas as $ven){
                            if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                                $valtot = $ven->valventan + $ven->valtax1;
                                $subtotal= $subtotal+$valtot;
                                
                                if($t == 0){
                                    $numInicial = $ven->numero;
                                }
                                
                                $total = 0; $totalGravado = 0; $totalExento = 0;
                                $totalIVA = 0; $invexento = $ven->exento;
                                
                                $productos = $this->invtran_model->getDataTran100kCorteZ($ven->trannum);
                                
                                foreach($productos as $pro){
                                    if($pro->tax1 != 0 && $invexento == 0){
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tax1 != 0 && $invexento == 1){
                                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tax1== 0 && $invexento == 0){
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tax1 == 0 && $invexento == 1){
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
                                }
                                
                                $subtotalex = $subtotalex + $totalExento;
                                $subtotalgr = $subtotalgr + $totalGravado;
                                $subtotaliv = $subtotaliv + $totalIVA;
                                
                                foreach($tipospagos as $tip){
                                    $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                    foreach($pagos as $money){
                                        if($tip->cajclase == $money->cajclase){
                                            if($money->valor <= 0){
                                                $moneyvalor = abs(number_format(round($money->valor, 2),2));
                                            }else{
                                                $moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
                                            }
                                            
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        }
                                    }
                                }
                                $numdoc++;
                                $numdocg++;
                                $numFinal = $ven->numero;
                                $t++;
                            }else{
                                foreach($tipospagos as $tip){
                                    $valpag[$tip->cajclase] = 0;
                                }
                            }
                        }
                        
                        $nuevaCadena = str_pad($numInicial, 10, " ", STR_PAD_LEFT);
                        $contenidoHeader = '"                    Del:'.$nuevaCadena.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $nuevaCadena = str_pad($numFinal, 10, " ", STR_PAD_LEFT);
                        $contenidoHeader = '"                     Al:'.$nuevaCadena.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $nuevaCadena = str_pad($numdoc, 10, " ", STR_PAD_LEFT);
                        $contenidoHeader = '"            Operaciones:'.$nuevaCadena.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $nuevaCadena = str_pad("$".number_format(round($subtotalex, 2), 2, '.', ''), 10, " ", STR_PAD_LEFT);
                        $contenidoHeader = '"         Ventas Exentas:'.$nuevaCadena.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $nuevaCadena = str_pad("$".number_format(round($subtotalgr, 2), 2, '.', ''), 10, " ", STR_PAD_LEFT);
                        $contenidoHeader = '"        Ventas Gravadas:'.$nuevaCadena.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $nuevaCadena = str_pad("$".number_format(round($subtotaliv, 2), 2, '.', ''), 10, " ", STR_PAD_LEFT);
                        $contenidoHeader = '"                    IVA:'.$nuevaCadena.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = 'opBold + Replicate(" ", 24) + Replicate("-", 10)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $nuevaCadena = str_pad("$".number_format(round($subtotal, 2), 2, '.', ''), 10, " ", STR_PAD_LEFT);
                        $contenidoHeader = 'opBold + "                  Sumas:'.$nuevaCadena.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $totalglobal = $totalglobal + $subtotal;
                        $totalexglobal = $totalexglobal + $subtotalex;
                        $totalgrglobal = $totalgrglobal + $subtotalgr;
                        $totalivglobal = $totalivglobal + $subtotaliv;
                    }
                    
                    $contenidoHeader = 'opBold + "  Totales:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $nuevaCadena = str_pad($numdocg, 10, " ", STR_PAD_LEFT);
                    $contenidoHeader = '"            Operaciones:'.$nuevaCadena.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $nuevaCadena = str_pad("$".number_format(round($totalexglobal, 2), 2, '.', ''), 10, " ", STR_PAD_LEFT);
                    $contenidoHeader = '"         Ventas Exentas:'.$nuevaCadena.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $nuevaCadena = str_pad("$".number_format(round($totalgrglobal, 2), 2, '.', ''), 10, " ", STR_PAD_LEFT);
                    $contenidoHeader = '"        Ventas Gravadas:'.$nuevaCadena.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $nuevaCadena = str_pad("$".number_format(round($totalivglobal, 2), 2, '.', ''), 10, " ", STR_PAD_LEFT);
                    $contenidoHeader = '"                    IVA:'.$nuevaCadena.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = 'opBold + Replicate(" ", 24) + Replicate("-", 10)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $nuevaCadena = str_pad("$".number_format(round($totalglobal, 2), 2, '.', ''), 10, " ", STR_PAD_LEFT);
                    $contenidoHeader = 'opBold + "                  Sumas:'.$nuevaCadena.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                                    
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = 'opBold + " INGRESOS:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $total_ing_sum=0; $l=0;
                    foreach($tipospagos as $tip){
                        $l++;
                    }
                    
                    $p=0;
                    foreach($tipospagos as $tip){
                        $nuevaCadena = str_pad(substr($tip->descrip, 0, 20), 23, " ", STR_PAD_LEFT);
                        $nuevoValor = str_pad("$".number_format(round($valpagG[$tip->cajclase], 2), 2, '.', ''), 10, " ", STR_PAD_LEFT);
                        
                        $contenidoHeader = '"'.$nuevaCadena.':'.$nuevoValor.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $total_ing_sum += round($valpagG[$tip->cajclase], 2);
                        $p++;
                    }
                    
                    $contenidoHeader = 'opBold + Replicate(" ", 24) + Replicate("-", 10)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $nuevaCadena = str_pad("$".number_format(round($total_ing_sum, 2), 2, '.', ''), 10, " ", STR_PAD_LEFT);
                    $contenidoHeader = 'opBold + "                  Sumas:'.$nuevaCadena.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                                    
                    $contenidoHeader = '"F." + Replicate("_", 40)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = 'opCenter + "'.trim($this->session->userdata('userLog')).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    date_default_timezone_set('America/El_Salvador');
                    $date = new DateTime();
                    
                    $contenidoHeader = 'opCenter + "'.$date->format('d/m/Y H:i:s a').'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = 'Replicate("_", 42)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = 'Replicate("_", 42)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //1
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    fclose($archivoTxt);
                    $docTxt = "CORTEZ".$numero_z.".gox";
                    //$docTxt = "TICKET".$numero_z.".gox";
                    if(file_exists($docTxt)){
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($docTxt));
                        readfile($docTxt);
                        
                        unlink($docTxt);
                        
                        echo "<script>window.close();</script>";
                        
                        exit;
                    }
                }
            }
            # v3
            function reporteCorteZFacturazCentro($fechaactual, $idcentro, $idcaja){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->model('ventas_model');
                    $this->load->model('global_model');
                    $this->load->model('sucursal_model');
                    $this->load->model('invtran_model');
                    $this->load->model('caja_model');
                    
                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                    
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    
                    foreach($datoscaja as $caja){
                        $namecaja = $caja->descrip;
                        $numcaja = $caja->resolucion;
                        $numero_x = $caja->numx;
                        $numero_z = $caja->numz;
                    }
                    
                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                    $datospr = explode("/", $datosprint);
                    
                    $documentos = $this->global_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual);
                    $facturas = $this->global_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual);
                    $tipospagos = $this->global_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual);
                    
                    $cnt = 0;
                    $valpag = array();
                    
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                        $valpagG[$tip->cajclase] = 0;
                        $cnt++;
                    }
                    
                    $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                                
                    $archivoTxt = fopen("CorteZ".$numero_z.".gox",'w+');
    
                   // Small Font
                    $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(1)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    // Turn ticket and audit On
                    $contenidoHeader = '@ 0,0 SAY CHR(27)+"z"+CHR(1)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n"); 
                    $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(2)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(3)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    //
                   
                    
                    $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"2"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"2"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                            
                    $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(strtoupper($namecentro), 38, " ", STR_PAD_BOTH).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow()+1 ,00 Say "'.str_pad(strtoupper($namecaja), 38, " ", STR_PAD_BOTH).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '@ Prow()+1,13 Say "'.$fechaCorte.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $contenidoHeader = '@ Prow()+1,00 SAY Replicate("-",39)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $contenidoHeader = '@ Prow()+2,00 SAY "TRANSACCIONES:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    date_default_timezone_set('America/El_Salvador');
                    $date = new DateTime();
    
                    $anio = $date->format("Y");
                    $mes = $date->format("m");
                    $dia = $date->format("d");
    
                    $hours = $date->format("h");
                    $minutes = $date->format("i");
                    $seconds = $date->format("s");
                    $ampm = $hours >= 12 ? 'PM' : 'AM';
    
                    $hours = $hours % 12;
                    $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                    $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                    $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                    $subtotal=0;
                    $totalglobal=0;
                    $totalexglobal=0;
                    $totalgrglobal=0;
                    $totalivglobal=0;
                    $subtotalex = 0;
                    $subtotalgr = 0;
                    $subtotaliv = 0;
                    $numdoc = 0;
                    $numdocg = 0;
                    
                    foreach($documentos as $docs){
                        $numdoc = 0;
                        $subtotal=0;
                        $subtotalex = 0;
                        $subtotalgr = 0;
                        $subtotaliv = 0;
                        $t = 0;
                        $contenidoHeader = '@ Prow()+2,01 SAY "'.$docs->descrip.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        foreach($facturas as $ven){
                            if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                                $valtot = $ven->valventan + $ven->valtax1;
                                $subtotal= $subtotal+$valtot;
                                if($t == 0){
                                    $numInicial = $ven->numero;
                                }
                                $total = 0;
                                $totalGravado = 0;
                                $totalExento = 0;
                                $totalIVA = 0;
                                $invexento = $ven->exento;
                                $productos = $this->invtran_model->getDataTran100k($ven->trannum);      
                                foreach($productos as $pro){
                                    if($pro->tipotax != 0 && $invexento == 0){
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tipotax != 0 && $invexento == 1){
                                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tipotax== 0 && $invexento == 0){
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tipotax == 0 && $invexento == 1){
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
                                }   
    
                                $subtotalex = $subtotalex + $totalExento;
                                $subtotalgr = $subtotalgr + $totalGravado;
                                $subtotaliv = $subtotaliv + $totalIVA;
                                foreach($tipospagos as $tip){
                                    $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                    foreach($pagos as $money){
                                        if($tip->cajclase == $money->cajclase){
                                            if($money->valor <= 0){
                                                $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                            }else{
                                                $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                            }
                                            
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        }
                                    }
                                }
                                $numdoc++;
                                $numdocg++;
                                $numFinal = $ven->numero;
                                $t++;
                            }else{
                                foreach($tipospagos as $tip){
                                    $valpag[$tip->cajclase] = 0;
                                }
                            }
                        }
                                
                        $numCantidad = $numInicial;
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        if($numTotal == 1){
                            $newString = '          '.$numInicial;
                        }else if($numTotal == 2){
                            $newString = '         '.$numInicial;
                        }else if($numTotal == 3){
                            $newString = '        '.$numInicial;
                        }else if($numTotal == 4){
                            $newString = '       '.$numInicial;
                        }else if($numTotal == 5){
                            $newString = '      '.$numInicial;
                        }else if($numTotal == 6){
                            $newString = '     '.$numInicial;
                        }else if($numTotal == 7){
                            $newString = '    '.$numInicial;
                        }else if($numTotal == 8){
                            $newString = '   '.$numInicial;
                        }else if($numTotal == 9){
                            $newString = '  '.$numInicial;
                        }
    
                        $contenidoHeader = '@ Prow()+1,15 SAY "Del:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
            
                            
                        $numCantidad = $numFinal;
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        if($numTotal == 1){
                            $newString = '          '.$numFinal;
                        }else if($numTotal == 2){
                            $newString = '         '.$numFinal;
                        }else if($numTotal == 3){
                            $newString = '        '.$numFinal;
                        }else if($numTotal == 4){
                            $newString = '       '.$numFinal;
                        }else if($numTotal == 5){
                            $newString = '      '.$numFinal;
                        }else if($numTotal == 6){
                            $newString = '     '.$numFinal;
                        }else if($numTotal == 7){
                            $newString = '    '.$numFinal;
                        }else if($numTotal == 8){
                            $newString = '   '.$numFinal;
                        }else if($numTotal == 9){
                            $newString = '  '.$numFinal;
                        }
    
                        $contenidoHeader = '@ Prow()+1,16 SAY "Al:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");        
                            
    
    
                        $numCantidad = $numdoc;
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        if($numTotal == 1){
                            $newString = '          '.$numdoc;
                        }else if($numTotal == 2){
                            $newString = '         '.$numdoc;
                        }else if($numTotal == 3){
                            $newString = '        '.$numdoc;
                        }else if($numTotal == 4){
                            $newString = '       '.$numdoc;
                        }else if($numTotal == 5){
                            $newString = '      '.$numdoc;
                        }else if($numTotal == 6){
                            $newString = '     '.$numdoc;
                        }else if($numTotal == 7){
                            $newString = '    '.$numdoc;
                        }else if($numTotal == 8){
                            $newString = '   '.$numdoc;
                        }else if($numTotal == 9){
                            $newString = '  '.$numdoc;
                        }
    
                        $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $numCantidad = number_format(round($subtotalex, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        if($numTotal == 1){
                            $newString = '         $'.number_format(round($subtotalex, 2),2);
                        }else if($numTotal == 2){
                            $newString = '        $'.number_format(round($subtotalex, 2),2);
                        }else if($numTotal == 3){
                            $newString = '       $'.number_format(round($subtotalex, 2),2);
                        }else if($numTotal == 4){
                            $newString = '      $'.number_format(round($subtotalex, 2),2);
                        }else if($numTotal == 5){
                            $newString = '     $'.number_format(round($subtotalex, 2),2);
                        }else if($numTotal == 6){
                            $newString = '    $'.number_format(round($subtotalex, 2),2);
                        }else if($numTotal == 7){
                            $newString = '   $'.number_format(round($subtotalex, 2),2);
                        }else if($numTotal == 8){
                            $newString = '  $'.number_format(round($subtotalex, 2),2);
                        }else if($numTotal == 9){
                            $newString = ' $'.number_format(round($subtotalex, 2),2);
                        }
    
                        $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                          
                        $numCantidad =number_format(round($subtotalgr, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        if($numTotal == 1){
                            $newString = '         $'.number_format(round($subtotalgr, 2),2);
                        }else if($numTotal == 2){
                            $newString = '        $'.number_format(round($subtotalgr, 2),2);
                        }else if($numTotal == 3){
                            $newString = '       $'.number_format(round($subtotalgr, 2),2);
                        }else if($numTotal == 4){
                            $newString = '      $'.number_format(round($subtotalgr, 2),2);
                        }else if($numTotal == 5){
                            $newString = '     $'.number_format(round($subtotalgr, 2),2);
                        }else if($numTotal == 6){
                            $newString = '    $'.number_format(round($subtotalgr, 2),2);
                        }else if($numTotal == 7){
                            $newString = '   $'.number_format(round($subtotalgr, 2),2);
                        }else if($numTotal == 8){
                            $newString = '  $'.number_format(round($subtotalgr, 2),2);
                        }else if($numTotal == 9){
                            $newString = ' $'.number_format(round($subtotalgr, 2),2);
                        }
    
                        $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                 
                        $numCantidad = number_format(round($subtotaliv, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        if($numTotal == 1){
                            $newString = '         $'.number_format(round($subtotaliv, 2),2);
                        }else if($numTotal == 2){
                            $newString = '        $'.number_format(round($subtotaliv, 2),2);
                        }else if($numTotal == 3){
                            $newString = '       $'.number_format(round($subtotaliv, 2),2);
                        }else if($numTotal == 4){
                            $newString = '      $'.number_format(round($subtotaliv, 2),2);
                        }else if($numTotal == 5){
                            $newString = '     $'.number_format(round($subtotaliv, 2),2);
                        }else if($numTotal == 6){
                            $newString = '    $'.number_format(round($subtotaliv, 2),2);
                        }else if($numTotal == 7){
                            $newString = '   $'.number_format(round($subtotaliv, 2),2);
                        }else if($numTotal == 8){
                            $newString = '  $'.number_format(round($subtotaliv, 2),2);
                        }else if($numTotal == 9){
                            $newString = ' $'.number_format(round($subtotaliv, 2),2);
                        }
    
                        $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $numCantidad = number_format(round($subtotal, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        if($numTotal == 1){
                            $newString = '         $'.number_format(round($subtotal, 2),2);
                        }else if($numTotal == 2){
                            $newString = '        $'.number_format(round($subtotal, 2),2);
                        }else if($numTotal == 3){
                            $newString = '       $'.number_format(round($subtotal, 2),2);
                        }else if($numTotal == 4){
                            $newString = '      $'.number_format(round($subtotal, 2),2);
                        }else if($numTotal == 5){
                            $newString = '     $'.number_format(round($subtotal, 2),2);
                        }else if($numTotal == 6){
                            $newString = '    $'.number_format(round($subtotal, 2),2);
                        }else if($numTotal == 7){
                            $newString = '   $'.number_format(round($subtotal, 2),2);
                        }else if($numTotal == 8){
                            $newString = '  $'.number_format(round($subtotal, 2),2);
                        }else if($numTotal == 9){
                            $newString = ' $'.number_format(round($subtotal, 2),2);
                        }
                        $contenidoHeader = '@ Prow()+1,00 SAY Replicate("-",39)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    
                        $totalglobal = $totalglobal+$subtotal;
                        $totalexglobal = $totalexglobal + $subtotalex;
                        $totalgrglobal = $totalgrglobal + $subtotalgr;
                        $totalivglobal = $totalivglobal + $subtotaliv;      
                    }
                    # - TOTALES
                    $contenidoHeader = '@ Prow()+2,02 SAY "Totales"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n"); 
                    
                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    if($numTotal == 1){
                        $newString = '          '.$numdoc;
                    }else if($numTotal == 2){
                        $newString = '         '.$numdoc;
                    }else if($numTotal == 3){
                        $newString = '        '.$numdoc;
                    }else if($numTotal == 4){
                        $newString = '       '.$numdoc;
                    }else if($numTotal == 5){
                        $newString = '      '.$numdoc;
                    }else if($numTotal == 6){
                        $newString = '     '.$numdoc;
                    }else if($numTotal == 7){
                        $newString = '    '.$numdoc;
                    }else if($numTotal == 8){
                        $newString = '   '.$numdoc;
                    }else if($numTotal == 9){
                        $newString = '  '.$numdoc;
                    }
    
                    $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    
                    $numCantidad = number_format(round($totalexglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($totalexglobal, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($totalexglobal, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($totalexglobal, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($totalexglobal, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($totalexglobal, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($totalexglobal, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($totalexglobal, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($totalexglobal, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($totalexglobal, 2),2);
                    }
    
                    $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    
                    $numCantidad = number_format(round($totalgrglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($totalgrglobal, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($totalgrglobal, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($totalgrglobal, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($totalgrglobal, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($totalgrglobal, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($totalgrglobal, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($totalgrglobal, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($totalgrglobal, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($totalgrglobal, 2),2);
                    }
    
                    $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $numCantidad = number_format(round($totalivglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($totalivglobal, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($totalivglobal, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($totalivglobal, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($totalivglobal, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($totalivglobal, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($totalivglobal, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($totalivglobal, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($totalivglobal, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($totalivglobal, 2),2);
                    }
    
                    $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $numCantidad = number_format(round($totalglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    if($numTotal == 1){
                        $newString = '         $'.number_format(round($totalglobal, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($totalglobal, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($totalglobal, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($totalglobal, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($totalglobal, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($totalglobal, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($totalglobal, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($totalglobal, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($totalglobal, 2),2);
                    }

                    $contenidoHeader = '@ Prow()+1,00 SAY Replicate("-",39)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $contenidoHeader = '@ Prow()+2,00 SAY "INGRESOS:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");  
                    $total_ing_sum=0;
                    $l=0;
                    foreach($tipospagos as $tip){
                        $l++;
                    }
                    $p=0;
                    foreach($tipospagos as $tip){
                        $nameForma = substr($tip->descrip, 0, 13);
                        $totalString = strlen($nameForma);
                        $newCoordenada=0;
                        
                        if($totalString == '8'){
                            $newCoordenada = 10; 
                        }else if($totalString == '9'){
                            $newCoordenada = 9;
                        }else if($totalString == '10'){
                            $newCoordenada = 8;
                        }else if($totalString == '11'){
                            $newCoordenada = 7;
                        }else if($totalString == '12'){
                            $newCoordenada = 6;
                        }else if($totalString == '13'){
                            $newCoordenada = 5;
                        }else if($totalString == '14'){
                            $newCoordenada = 4;
                        }else if($totalString == '15'){
                            $newCoordenada = 3;
                        }else if($totalString == '16'){
                            $newCoordenada = 2;
                        }else if($totalString == '17'){
                            $newCoordenada = 1;
                        }else if($totalString == '18'){
                            $newCoordenada = 0;
                        }  
                                                
                        $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                        $valorString = strval($numPrecio);
                        $numTotal = strlen($valorString);       
    
                        if($numTotal == 1){
                            $newString = '         $'.$numPrecio;
                        }else if($numTotal == 2){
                            $newString = '        $'.$numPrecio;
                        }else if($numTotal == 3){
                            $newString = '       $'.$numPrecio;
                        }else if($numTotal == 4){
                            $newString = '      $'.$numPrecio;
                        }else if($numTotal == 5){
                            $newString = '     $'.$numPrecio;
                        }else if($numTotal == 6){
                            $newString = '    $'.$numPrecio;
                        }else if($numTotal == 7){
                            $newString = '   $'.$numPrecio;
                        }else if($numTotal == 8){
                            $newString = '  $'.$numPrecio;
                        }else if($numTotal == 9){
                            $newString = ' $'.$numPrecio;
                        }
                                    
                        if($p == $l - 1){
                            $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
    
                            $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                                        
                        }else{ 
                            $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':'.$newString.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                        }
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                        $p++;
                    }
                        
                    $numCantidad = number_format(round($total_ing_sum, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    if($numTotal == 1){ 
                        $newString = '         $'.number_format(round($total_ing_sum, 2),2);
                    }else if($numTotal == 2){
                        $newString = '        $'.number_format(round($total_ing_sum, 2),2);
                    }else if($numTotal == 3){
                        $newString = '       $'.number_format(round($total_ing_sum, 2),2);
                    }else if($numTotal == 4){
                        $newString = '      $'.number_format(round($total_ing_sum, 2),2);
                    }else if($numTotal == 5){
                        $newString = '     $'.number_format(round($total_ing_sum, 2),2);
                    }else if($numTotal == 6){
                        $newString = '    $'.number_format(round($total_ing_sum, 2),2);
                    }else if($numTotal == 7){
                        $newString = '   $'.number_format(round($total_ing_sum, 2),2);
                    }else if($numTotal == 8){
                        $newString = '  $'.number_format(round($total_ing_sum, 2),2);
                    }else if($numTotal == 9){
                        $newString = ' $'.number_format(round($total_ing_sum, 2),2);
                    }

                    $contenidoHeader = '@ Prow()+1,00 SAY Replicate("-",39)';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
    
                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    /*$contenidoHeader = '@ Prow()+2,00 SAY "CUADRE DE CAJA:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n"); 
                    
                    $contenidoHeader = '@Prow()+1,06 SAY "Sist"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '@Prow(),17 SAY "Caja"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '@Prow(),28 SAY "Dife"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");//*/
    
                    $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
    
                    $totalSistema = 0;
                    $totalCaja = 0;
                    $numerotransacc = 0;
                    
                    foreach($infoCuadre as $info){
                        $numCantidad = substr($info->formapago, 0, 4);
                        $totalString = strval($numCantidad);
    
                        $numCantidad2 = number_format(round($info->valorsys, 2),2);
                        $totalString2 = strval($numCantidad2);
                        $numTotal2 = strlen($totalString2);
    
                        if($numTotal2 == 1){
                            $newString2 = '         $'.number_format(round($info->valorsys, 2),2);
                        }else if($numTotal2 == 2){
                            $newString2 = '        $'.number_format(round($info->valorsys, 2),2);
                        }else if($numTotal2 == 3){
                            $newString2 = '       $'.number_format(round($info->valorsys, 2),2);
                        }else if($numTotal2 == 4){
                            $newString2 = '      $'.number_format(round($info->valorsys, 2),2);
                        }else if($numTotal2 == 5){
                            $newString2 = '     $'.number_format(round($info->valorsys, 2),2);
                        }else if($numTotal2 == 6){
                            $newString2 = '    $'.number_format(round($info->valorsys, 2),2);
                        }else if($numTotal2 == 7){
                            $newString2 = '   $'.number_format(round($info->valorsys, 2),2);
                        }else if($numTotal2 == 8){
                            $newString2 = '  $'.number_format(round($info->valorsys, 2),2);
                        }else if($numTotal2 == 9){
                            $newString2 = ' $'.number_format(round($info->valorsys, 2),2);
                        }
    
                        $numCantidad3 = number_format(round($info->valorusr, 2),2);
                        $totalString3 = strval($numCantidad3);
                        $numTotal3 = strlen($totalString3);
    
                        if($numTotal3 == 1){
                            $newString3 = '         $'.number_format(round($info->valorusr, 2),2);
                        }else if($numTotal3 == 2){
                            $newString3 = '        $'.number_format(round($info->valorusr, 2),2);
                        }else if($numTotal3 == 3){
                            $newString3 = '       $'.number_format(round($info->valorusr, 2),2);
                        }else if($numTotal3 == 4){
                            $newString3 = '      $'.number_format(round($info->valorusr, 2),2);
                        }else if($numTotal3 == 5){
                            $newString3 = '     $'.number_format(round($info->valorusr, 2),2);
                        }else if($numTotal3 == 6){
                            $newString3 = '    $'.number_format(round($info->valorusr, 2),2);
                        }else if($numTotal3 == 7){
                            $newString3 = '   $'.number_format(round($info->valorusr, 2),2);
                        }else if($numTotal3 == 8){
                            $newString3 = '  $'.number_format(round($info->valorusr, 2),2);
                        }else if($numTotal3 == 9){
                            $newString3 = ' $'.number_format(round($info->valorusr, 2),2);
                        }
    
                        $valorSistema = round($info->valorsys, 2);
                        $valorCaja = round($info->valorusr, 2);
    
                        $totalSistema = $totalSistema + $valorSistema;
                        $totalCaja = $totalCaja + $valorCaja;
    
                        if($valorSistema == 0){
                            $diferencia = $valorCaja;
                        }else{
                            $diferencia = $valorCaja - $valorSistema;
                        }
    
                        $numCantidad4 = number_format(round($diferencia, 2),2);
                        $totalString4 = strval($numCantidad4);
                        $numTotal4 = strlen($totalString4);
    
                        if($numTotal4 == 1){
                            $newString4 = '         $'.number_format(round($diferencia, 2),2);
                        }else if($numTotal4 == 2){
                            $newString4 = '        $'.number_format(round($diferencia, 2),2);
                        }else if($numTotal4 == 3){
                            $newString4 = '       $'.number_format(round($diferencia, 2),2);
                        }else if($numTotal4 == 4){
                            $newString4 = '      $'.number_format(round($diferencia, 2),2);
                        }else if($numTotal4 == 5){
                            $newString4 = '     $'.number_format(round($diferencia, 2),2);
                        }else if($numTotal4 == 6){
                            $newString4 = '    $'.number_format(round($diferencia, 2),2);
                        }else if($numTotal4 == 7){
                            $newString4 = '   $'.number_format(round($diferencia, 2),2);
                        }else if($numTotal4 == 8){
                            $newString4 = '  $'.number_format(round($diferencia, 2),2);
                        }else if($numTotal4 == 9){
                            $newString4 = ' $'.number_format(round($diferencia, 2),2);
                        }
    
                        $countSys = '('.$info->countsys.')';
                        $stringCount = strval($countSys);
                        $totalString = strlen($stringCount);
                        /*while($totalString < 5){
                            $stringCount = ' '.$stringCount;
                        }*/
    
                        $countUser = '('.$info->countuser.')';
                        $stringCountUser = strval($countUser);
                        $totalString = strlen($stringCountUser);
                        /*
                        while($totalString < 5){
                            $stringCountUser = ' '.$stringCountUser;
                        }*/
    
                        $contenidoHeader = '@Prow()+1,00 SAY "'.$numCantidad.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@Prow(),06 SAY "$ '.$numCantidad2.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@Prow(),17 SAY "$ '.$numCantidad3.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
    
                        $contenidoHeader = '@Prow(),28 SAY "$ '.$numCantidad4.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $numerotransacc = $numerotransacc + 1;
                      
                    }
                    
                    $this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);
                    
                    
                    $numTotSistema = number_format(round($totalSistema, 2),2);
                    $countString = strval($numTotSistema);
                    $numSistema = strlen($countString);
    
                    if($numSistema == 1){
                        $valorSistema = '         $'.number_format(round($totalSistema, 2),2);
                    }else if($numSistema == 2){
                        $valorSistema = '        $'.number_format(round($totalSistema, 2),2);
                    }else if($numSistema == 3){
                        $valorSistema = '       $'.number_format(round($totalSistema, 2),2);
                    }else if($numSistema == 4){
                        $valorSistema = '      $'.number_format(round($totalSistema, 2),2);
                    }else if($numSistema == 5){
                        $valorSistema = '     $'.number_format(round($totalSistema, 2),2);
                    }else if($numSistema == 6){
                        $valorSistema = '    $'.number_format(round($totalSistema, 2),2);
                    }else if($numSistema == 7){
                        $valorSistema = '   $'.number_format(round($totalSistema, 2),2);
                    }else if($numSistema == 8){
                        $valorSistema = '  $'.number_format(round($totalSistema, 2),2);
                    }else if($numSistema == 9){
                        $valorSistema = ' $'.number_format(round($totalSistema, 2),2);
                    }
    
                    $numTotCaja = number_format(round($totalCaja, 2),2);
                    $countString = strval($numTotCaja);
                    $numCaja = strlen($countString);
    
                    if($numCaja == 1){
                        $valorCaja = '         $'.number_format(round($totalCaja, 2),2);
                    }else if($numCaja == 2){
                        $valorCaja = '        $'.number_format(round($totalCaja, 2),2);
                    }else if($numCaja == 3){
                        $valorCaja = '       $'.number_format(round($totalCaja, 2),2);
                    }else if($numCaja == 4){
                        $valorCaja = '      $'.number_format(round($totalCaja, 2),2);
                    }else if($numCaja == 5){
                        $valorCaja = '     $'.number_format(round($totalCaja, 2),2);
                    }else if($numCaja == 6){
                        $valorCaja = '    $'.number_format(round($totalCaja, 2),2);
                    }else if($numCaja == 7){
                        $valorCaja = '   $'.number_format(round($totalCaja, 2),2);
                    }else if($numCaja == 8){
                        $valorCaja = '  $'.number_format(round($totalCaja, 2),2);
                    }else if($numCaja == 9){
                        $valorCaja = ' $'.number_format(round($totalCaja, 2),2);
                    }
    
                    $totalDiferencia = $totalCaja - $totalSistema;
                    $numTotDif = number_format(round($totalDiferencia, 2),2);
                    $countString = strval($numTotDif);
                    $numDif = strlen($countString);
    
                    if($numDif == 1){
                        $valorTotDif = '         $'.number_format(round($totalDiferencia, 2),2);
                    }else if($numDif == 2){
                        $valorTotDif = '        $'.number_format(round($totalDiferencia, 2),2);
                    }else if($numDif == 3){
                        $valorTotDif = '       $'.number_format(round($totalDiferencia, 2),2);
                    }else if($numDif == 4){
                        $valorTotDif = '      $'.number_format(round($totalDiferencia, 2),2);
                    }else if($numDif == 5){
                        $valorTotDif = '     $'.number_format(round($totalDiferencia, 2),2);
                    }else if($numDif == 6){
                        $valorTotDif = '    $'.number_format(round($totalDiferencia, 2),2);
                    }else if($numDif == 7){
                        $valorTotDif = '   $'.number_format(round($totalDiferencia, 2),2);
                    }else if($numDif == 8){
                        $valorTotDif = '  $'.number_format(round($totalDiferencia, 2),2);
                    }else if($numDif == 9){
                        $valorTotDif = ' $'.number_format(round($totalDiferencia, 2),2);
                    }
                    
                    if($numerotransacc > 1){
                        
                        $contenidoHeader = '@Prow()+1,00 SAY "Resumen:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
        
                        $contenidoHeader = '@Prow()+1,05 SAY "Sistema:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
        
                        $contenidoHeader = '@Prow(),20 SAY "'.$valorSistema.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
        
                        $contenidoHeader = '@Prow()+1,08 SAY "Caja:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
        
                        $contenidoHeader = '@Prow(),20 SAY "'.$valorCaja.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
        
                        if($totalDiferencia > 0){
                            $contenidoHeader = '@Prow()+1,04 SAY "Sobrante:"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
        
                            $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                        }else if($totalDiferencia < 0){
                            $contenidoHeader = '@Prow()+1,04 SAY "Faltante:"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
        
                            $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                        }else if($totalDiferencia == 0){
                            $contenidoHeader = '@Prow()+1,02 SAY "Diferencia:"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
        
                            $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                        }
                        
                    }
                    
                    $contenidoHeader = '@Prow()+2,00 SAY "F._____________________________________"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    $contenidoHeader = '@Prow()+1,08 SAY "'.trim($this->session->userdata('userLog')).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    $contenidoHeader = '@Prow()+1,08 SAY "'.$dia. '/' .$mes.'/'.$anio.'  '.$strTime.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    $contenidoHeader = '@Prow()+1,00 SAY "_______________________________________"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    $contenidoHeader = '@Prow()+1,00 SAY "_______________________________________"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    for ($i=0; $i < 15; $i++) { 
                        $contenidoProductos ='@ Prow()+1,00 Say CHR(13)+CHR(10)';
                        fwrite($archivoTxt, $contenidoProductos);
                        fwrite($archivoTxt, "\r\n");
                    }
                    
                    
                    $contenidoProductos ='@ Prow()+1,00 Say CHR(27)+"i"';
                    fwrite($archivoTxt, $contenidoProductos);
                    fwrite($archivoTxt, "\r\n");
                    
                    fclose($archivoTxt);
    
                    $docTxt = "CorteZ".$numero_z.".gox";
                    if(file_exists($docTxt)){
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($docTxt));
                        readfile($docTxt);
    
                        unlink($docTxt);
                        exit;
                    }    
                }
                function closeWin() {
                    myWindow.close();
                }
            }

            function reporteCorteZFacturazOld($fechaactual,$idcentro,$idcaja){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    
                    date_default_timezone_set('America/El_Salvador');
                    $date = new DateTime();
    
                    $this->load->model('ventas_model');
                    $this->load->model('global_model');
                    $this->load->model('sucursal_model');
                    $this->load->model('invtran_model');
                    $this->load->model('caja_model');
                    $comandosTM = new comandosTM();
    
                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                    
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    
                    foreach($datoscaja as $caja){
                        $namecaja = $caja->descrip;
                        $numcaja = $caja->resolucion;
                        $numero_x = $caja->numx;
                        $numero_z = $caja->numz;
                        $printerName = $caja->notas;

                    }
                    
                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                    $datospr = explode("/", $datosprint);
                    
                    $documentos = $this->global_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual);
                    $facturas = $this->global_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual);
                    $tipospagos = $this->global_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual);
                    
                    $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                    
                    $cnt = 0;
                    $valpag = array();
                    
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                        $valpagG[$tip->cajclase] = 0;
                        $cnt++;
                    }
    
                    $cmds = comandosTM::Initialize;
                    $cmds .= comandosTM::PrintTicket;
                    $cmds .= comandosTM::FontSmall;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::TextAlignCenter;
    
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($namecentro), 0, 56);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    if(strlen($namecentro)>56){
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= substr(trim($namecentro), 56, 56);
                        $cmds .= comandosTM::LineFeed;
                        $cmds .= comandosTM::FontBoldDisable;
                    }
                    $cmds .= substr(strtoupper($namecaja), 0, 56);
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $fechaCorte;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= str_repeat("-", 39);
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "TRANSACCIONES:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $subtotal=0; $totalglobal=0; $totalexglobal=0;
                    $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                    $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
                    $numdocg = 0;
                    
                    foreach($documentos as $docs){
                        $numdoc = 0;
                        $subtotal=0;
                        $subtotalex = 0;
                        $subtotalgr = 0;
                        $subtotaliv = 0;
                        $t = 0;
                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $docs->descrip;
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    
                        foreach($facturas as $ven){
                            if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                                $valtot = $ven->valventan + $ven->valtax1;
                                $subtotal= $subtotal+$valtot;
                                if($t == 0){
                                    $numInicial = $ven->numero;
                                }
                                $total = 0;
                                $totalGravado = 0;
                                $totalExento = 0;
                                $totalIVA = 0;
                                $invexento = $ven->exento;
                                $productos = $this->invtran_model->getDataTran100k($ven->trannum);
                                
                                foreach($productos as $pro){
                                    if($pro->tipotax != 0 && $invexento == 0){
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tipotax != 0 && $invexento == 1){
                                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tipotax== 0 && $invexento == 0){
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tipotax == 0 && $invexento == 1){
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
                                }
                                
                                $subtotalex = $subtotalex + $totalExento;
                                $subtotalgr = $subtotalgr + $totalGravado;
                                $subtotaliv = $subtotaliv + $totalIVA;
                                
                                foreach($tipospagos as $tip){
                                    $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                    foreach($pagos as $money){
                                        if($tip->cajclase == $money->cajclase){
                                            if($money->valor <= 0){
                                                $moneyvalor = abs(number_format(round($money->valor, 2),2, '.', ''));
                                            }else{
                                                $moneyvalor = abs(number_format(round($money->valor, 2),2, '.', '')) * -1;
                                            }
                                            
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        }
                                    }
                                }
                                $numdoc++;
                                $numdocg++;
                                $numFinal = $ven->numero;
                                $t++;
                            }else{
                                foreach($tipospagos as $tip){
                                    $valpag[$tip->cajclase] = 0;
                                }
                            }
                        }
                        
                        $cmds .= $comandosTM->padText("Del: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;   
    
                        $numCantidad = $numFinal;
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText("Al: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    
                        $numCantidad = $numdoc;
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    
                        $numCantidad = number_format(round($subtotalex, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    
                        $numCantidad =number_format(round($subtotalgr, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    
                        $numCantidad = number_format(round($subtotaliv, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        ///////////////  Retencion   ////////////////
    
                        $numCantidad = number_format(round($subtotal, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                        $totalglobal = $totalglobal+$subtotal;
                        $totalexglobal = $totalexglobal + $subtotalex;
                        $totalgrglobal = $totalgrglobal + $subtotalgr;
                        $totalivglobal = $totalivglobal + $subtotaliv;
        
                    }
                    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Totales";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    
                    $numCantidad = number_format(round($totalexglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    
                    $numCantidad = number_format(round($totalgrglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    
                    $numCantidad = number_format(round($totalivglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    
                    $numCantidad = number_format(round($totalglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "INGRESOS:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed; 
    
                    $total_ing_sum=0; $l=0;
                    foreach($tipospagos as $tip){
                        $l++;
                    }
                    $p=0;
                    
                    foreach($tipospagos as $tip){
                        $nameForma = substr($tip->descrip, 0, 13);
                        $totalString = strlen($nameForma);
                        $newCoordenada=0;
    
                        $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                        $valorString = strval($numPrecio);
                        $numTotal = strlen($valorString);       
    
                        if($p == $l - 1){
                            $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                            $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                            $cmds .= comandosTM::LineFeed;  
    
                        }else{ 
                            $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                            $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                            $cmds .= comandosTM::LineFeed;
                        }
    
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                        $p++;
                    }
                    
                    $numCantidad = number_format(round($total_ing_sum, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::TextAlignCenter;
    
                    $cmds .= "F.___________________________________";
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= trim($this->session->userdata('userLog'));
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= $date->format('d/m/Y H:i:s A');
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .=  "_____________________________________";
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .=  "_____________________________________";
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::FullCut950;
                    
           
                    $trannum= "CZ".$idcentro.$idcaja.$numero_z.$numero_x;
                    $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                    //echo $cmds;
                    header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                    exit;
                }
            }

            function reporteCorteZFacturaz($fechaactual,$idcentro,$idcaja){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    
                    date_default_timezone_set('America/El_Salvador');
                    $date = new DateTime();
    
                    $this->load->model('ventas_model');
                    $this->load->model('global_model');
                    $this->load->model('sucursal_model');
                    $this->load->model('invtran_model');
                    $this->load->model('caja_model');
                    $comandosTM = new comandosTM();
    
                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                    
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    
                    foreach($datoscaja as $caja){
                        $namecaja = $caja->descrip;
                        $numcaja = $caja->resolucion;
                        $numero_x = $caja->numx;
                        $numero_z = $caja->numz;
                        $printerName = $caja->notas;

                    }
                    
                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                    $datospr = explode("/", $datosprint);
                    
                    $documentos = $this->global_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual);
                    $facturas = $this->global_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual);
                    $tipospagos = $this->global_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual);
                    
                    $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                    
                    $cnt = 0;
                    $valpag = array();
                    
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                        $valpagG[$tip->cajclase] = 0;
                        $cnt++;
                    }
    
                    $cmds = comandosTM::Initialize;
                    $cmds .= comandosTM::PrintTicket;
                    $cmds .= comandosTM::FontSmall;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::TextAlignCenter;
    
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($namecentro), 0, 56);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    if(strlen($namecentro)>56){
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= substr(trim($namecentro), 56, 56);
                        $cmds .= comandosTM::LineFeed;
                        $cmds .= comandosTM::FontBoldDisable;
                    }
                    $cmds .= substr(strtoupper($namecaja), 0, 56);
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $fechaCorte;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= str_repeat("-", 39);
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "TRANSACCIONES:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $subtotal=0; $totalglobal=0; $totalexglobal=0;
                    $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                    $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
                    $numdocg = 0;
                    $subtotalreten = 0; $totalglobalreten = 0;
                    
                    foreach($documentos as $docs){
                        $numdoc = 0;
                        $subtotal=0;
                        $subtotalex = 0;
                        $subtotalgr = 0;
                        $subtotaliv = 0;
                        $t = 0;
                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $docs->descrip;
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    
                        foreach($facturas as $ven){
                            if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                                $valtot = $ven->valventan + $ven->valtax1;
                                $subtotal= $subtotal+$valtot;
                                if($t == 0){
                                    $numInicial = $ven->numero;
                                }
                                $total = 0;
                                $totalGravado = 0;
                                $totalExento = 0;
                                $totalIVA = 0;
                                $invexento = $ven->exento;
                                $productos = $this->invtran_model->getDataTran100k($ven->trannum);
                                
                                foreach($productos as $pro){
                                    if($pro->tipotax != 0 && $invexento == 0){
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tipotax != 0 && $invexento == 1){
                                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tipotax== 0 && $invexento == 0){
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }else if($pro->tipotax == 0 && $invexento == 1){
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
                                }
                                
                                $subtotalex = $subtotalex + $totalExento;
                                $subtotalgr = $subtotalgr + $totalGravado;
                                $subtotaliv = $subtotaliv + $totalIVA;

                                //////// Reten ///////////////////////

                                if($ven->idtipo == 3 && $totalGravado >= 100){
                                    $subtotalreten = $totalGravado * 0.01;
                                    $subtotal = $subtotal - $subtotalreten;
                                }

                                ////////////////////////////////////
                                
                                foreach($tipospagos as $tip){
                                    $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                    foreach($pagos as $money){
                                        if($tip->cajclase == $money->cajclase){
                                            if($money->valor <= 0){
                                                $moneyvalor = abs(number_format(round($money->valor, 2),2, '.', ''));
                                            }else{
                                                $moneyvalor = abs(number_format(round($money->valor, 2),2, '.', '')) * -1;
                                            }
                                            
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        }
                                    }
                                }
                                $numdoc++;
                                $numdocg++;
                                $numFinal = $ven->numero;
                                $t++;
                            }else{
                                foreach($tipospagos as $tip){
                                    $valpag[$tip->cajclase] = 0;
                                }
                            }
                        }
                        
                        $cmds .= $comandosTM->padText("Del: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;   
    
                        $numCantidad = $numFinal;
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText("Al: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    
                        $numCantidad = $numdoc;
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    
                        $numCantidad = number_format(round($subtotalex, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    
                        $numCantidad =number_format(round($subtotalgr, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    
                        $numCantidad = number_format(round($subtotaliv, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        ///////////////  Retencion   ////////////////

                        $numCantidad = number_format(round($subtotalreten, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);

                        $cmds .= $comandosTM->padText("Retencion: ", 24, 'LEFT');
                        if($subtotalreten != 0){
                            $cmds .= $comandosTM->padText('- $'.number_format(round($subtotalreten, 2),2), 11, 'LEFT');
                        }else{
                            $cmds .= $comandosTM->padText('$'.number_format(round($subtotalreten, 2),2), 11, 'LEFT');
                        }
                        $cmds .= comandosTM::LineFeed;

                      //////////////////////////////////////////////////
    
                        $numCantidad = number_format(round($subtotal, 2),2);
                        $totalString = strval($numCantidad);
                        $numTotal = strlen($totalString);
    
                        $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                        $totalglobalreten += $subtotalreten; // Reten 
                        $totalglobal = $totalglobal+$subtotal;
                        $totalexglobal = $totalexglobal + $subtotalex;
                        $totalgrglobal = $totalgrglobal + $subtotalgr;
                        $totalivglobal = $totalivglobal + $subtotaliv;
        
                    }
                    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Totales";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    
                    $numCantidad = number_format(round($totalexglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    
                    $numCantidad = number_format(round($totalgrglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    
                    $numCantidad = number_format(round($totalivglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    ////////////// Retencion /////////////////

                    $numCantidad = number_format(round($totalglobalreten, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Retencion: ", 24, 'LEFT');
                    if($subtotalreten != 0){
                        $cmds .= $comandosTM->padText('- $'.number_format(round($totalglobalreten, 2),2), 11, 'LEFT');
                    }else{
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalglobalreten, 2),2), 11, 'LEFT');
                    }
                    $cmds .= comandosTM::LineFeed;

                    //////////////////////////////////////////
    
                    $numCantidad = number_format(round($totalglobal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "INGRESOS:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed; 
    
                    $total_ing_sum=0; $l=0;
                    foreach($tipospagos as $tip){
                        $l++;
                    }
                    $p=0;
                    
                    foreach($tipospagos as $tip){
                        $nameForma = substr($tip->descrip, 0, 13);
                        $totalString = strlen($nameForma);
                        $newCoordenada=0;
    
                        $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                        $valorString = strval($numPrecio);
                        $numTotal = strlen($valorString);       
    
                        if($p == $l - 1){
                            $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                            $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                            $cmds .= comandosTM::LineFeed;  
    
                        }else{ 
                            $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                            $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                            $cmds .= comandosTM::LineFeed;
                        }
    
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                        $p++;
                    }
                    
                    $numCantidad = number_format(round($total_ing_sum, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::TextAlignCenter;
    
                    $cmds .= "F.___________________________________";
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= trim($this->session->userdata('userLog'));
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= $date->format('d/m/Y H:i:s A');
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .=  "_____________________________________";
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .=  "_____________________________________";
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::FullCut950;
                    
           
                    $trannum= "CZ".$idcentro.$idcaja.$numero_z.$numero_x;
                    $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                    //echo $cmds;
                    header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                    exit;
                }
            }
            
            function impresionCorteZ($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->load->model('ventas_model');

                    $this->load->model('global_model');

                    $this->load->model('sucursal_model');

                    $this->load->model('invtran_model');

                    $this->load->model('caja_model');

                    

                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);

                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);

                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);

                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);

                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);

                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);

                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                    

                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    $datoscaja = $this->caja_model->getNameCaja($idcaja);

                    

                    foreach($datoscaja as $caja){

                        $namecaja = $caja->descrip;

                        $numcaja = $caja->resolucion;

                        

                    }

                    

                    $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                    $datospr = explode("/", $datosprint);

                    

                    $documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);

                    $facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);

                    $tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);               

                    

                    $cnt = 0;

                    $valpag = array();

                    

                    foreach($tipospagos as $tip){

                        $valpag[$tip->cajclase] = 0;

                        $valpagG[$tip->cajclase] = 0;

                        $cnt++;

                    }

                    

                    $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                                

                    $archivoTxt = fopen("ReimpCorteZ".$numero_z.".gox",'w+');



                    $contenidoHeader = '@ 01,11 Say Ansitooem("'.str_pad($RazonSocial, 10, " ", STR_PAD_BOTH).'")';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $address = substr($direccion ,0,30);

                    

                    $contenidoHeader = '@ Prow ()+1,00 Say "'.str_pad($address, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,13 Say "'.str_pad($namecaja, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,00 Say "NRC:'.$NRF.' NIT: '.$NIT.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow ()+1,03 Say "'.str_pad($GIRO, 10, " ", STR_PAD_BOTH).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                        

                    $contenidoHeader = '@ Prow ()+1,00 Say "IVA D.L. N 296"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 07,13 Say "CORTE Z N '.$numero_z.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ 08,13 Say "'.$fechaCorte.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 09,00 SAY Replicate("-",39)';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ 11,00 SAY "DETALLE DE TRANSACCIONES:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    date_default_timezone_set('America/El_Salvador');

                    $date = new DateTime();



                    $anio = $date->format("Y");

                    $mes = $date->format("m");

                    $dia = $date->format("d");



                    $hours = $date->format("h");

                    $minutes = $date->format("i");

                    $seconds = $date->format("s");

                    $ampm = $hours >= 12 ? 'PM' : 'AM';



                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12; // the hour '0' should be '12'

                    $minutes = $minutes < 10 ? '0'.$minutes : $minutes;

                    $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                    $subtotal=0;

                    $totalglobal=0;

                    $totalexglobal=0;

                    $totalgrglobal=0;

                    $totalivglobal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $numdoc = 0;

                    $numdocg = 0;

                    

                    foreach($documentos as $docs){

                        $numdoc = 0;

                        $subtotal=0;

                        $subtotalex = 0;

                        $subtotalgr = 0;

                        $subtotaliv = 0;

                        $t = 0;

                        $contenidoHeader = '@ Prow()+2,02 SAY "'.$docs->descrip.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        foreach($facturas as $ven){

                            if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                                $valtot = $ven->valventan + $ven->valtax1;

                                $subtotal= $subtotal+$valtot;

                                if($t == 0){

                                    $numInicial = $ven->numero;

                                }

                                $total = 0;

                                $totalGravado = 0;

                                $totalExento = 0;

                                $totalIVA = 0;

                                $invexento = $ven->exento;

                                $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                                foreach($productos as $pro){

                                    if($pro->tax1 != 0 && $invexento == 0){

                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1 != 0 && $invexento == 1){

                                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1== 0 && $invexento == 0){

                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }else if($pro->tax1 == 0 && $invexento == 1){

                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    }

                                }



                                $subtotalex = $subtotalex + $totalExento;

                                $subtotalgr = $subtotalgr + $totalGravado;

                                $subtotaliv = $subtotaliv + $totalIVA;

                            

                                foreach($tipospagos as $tip){

                                    $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                    foreach($pagos as $money){

                                        if($tip->cajclase == $money->cajclase){

                                            if($money->valor <= 0){

                                                $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

                                            }else{

                                                $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

                                            }

                                            

                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                        }

                                    }

                                }

                                $numdoc++;

                                $numdocg++;

                                $numFinal = $ven->numero;

                                $t++;

                            }else{

                                foreach($tipospagos as $tip){

                                    $valpag[$tip->cajclase] = 0;

                                }

                            }

                        }

                                

                        $numCantidad = $numInicial;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numInicial;

                        }else if($numTotal == 2){

                            $newString = '         '.$numInicial;

                        }else if($numTotal == 3){

                            $newString = '        '.$numInicial;

                        }else if($numTotal == 4){

                            $newString = '       '.$numInicial;

                        }else if($numTotal == 5){

                            $newString = '      '.$numInicial;

                        }else if($numTotal == 6){

                            $newString = '     '.$numInicial;

                        }else if($numTotal == 7){

                            $newString = '    '.$numInicial;

                        }else if($numTotal == 8){

                            $newString = '   '.$numInicial;

                        }else if($numTotal == 9){

                            $newString = '  '.$numInicial;

                        }



                        $contenidoHeader = '@ Prow()+1,15 SAY "Del:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

            

                            

                        $numCantidad = $numFinal;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numFinal;

                        }else if($numTotal == 2){

                            $newString = '         '.$numFinal;

                        }else if($numTotal == 3){

                            $newString = '        '.$numFinal;

                        }else if($numTotal == 4){

                            $newString = '       '.$numFinal;

                        }else if($numTotal == 5){

                            $newString = '      '.$numFinal;

                        }else if($numTotal == 6){

                            $newString = '     '.$numFinal;

                        }else if($numTotal == 7){

                            $newString = '    '.$numFinal;

                        }else if($numTotal == 8){

                            $newString = '   '.$numFinal;

                        }else if($numTotal == 9){

                            $newString = '  '.$numFinal;

                        }



                        $contenidoHeader = '@ Prow()+1,16 SAY "Al:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");        

                            





                        $numCantidad = $numdoc;

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '          '.$numdoc;

                        }else if($numTotal == 2){

                            $newString = '         '.$numdoc;

                        }else if($numTotal == 3){

                            $newString = '        '.$numdoc;

                        }else if($numTotal == 4){

                            $newString = '       '.$numdoc;

                        }else if($numTotal == 5){

                            $newString = '      '.$numdoc;

                        }else if($numTotal == 6){

                            $newString = '     '.$numdoc;

                        }else if($numTotal == 7){

                            $newString = '    '.$numdoc;

                        }else if($numTotal == 8){

                            $newString = '   '.$numdoc;

                        }else if($numTotal == 9){

                            $newString = '  '.$numdoc;

                        }



                        $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = number_format(round($subtotalex, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotalex, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotalex, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        

                        $numCantidad =number_format(round($subtotalgr, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotalgr, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotalgr, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                

                        $numCantidad = number_format(round($subtotaliv, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotaliv, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotaliv, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numCantidad = number_format(round($subtotal, 2),2);

                        $totalString = strval($numCantidad);

                        $numTotal = strlen($totalString);



                        if($numTotal == 1){

                            $newString = '         $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 2){

                            $newString = '        $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 3){

                            $newString = '       $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 4){

                            $newString = '      $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 5){

                            $newString = '     $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 6){

                            $newString = '    $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 7){

                            $newString = '   $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 8){

                            $newString = '  $'.number_format(round($subtotal, 2),2);

                        }else if($numTotal == 9){

                            $newString = ' $'.number_format(round($subtotal, 2),2);

                        }



                        $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    

                        $totalglobal = $totalglobal+$subtotal;

                        $totalexglobal = $totalexglobal + $subtotalex;

                        $totalgrglobal = $totalgrglobal + $subtotalgr;

                        $totalivglobal = $totalivglobal + $subtotaliv;      

                    }

                    

                    $contenidoHeader = '@ Prow()+2,04 SAY "Totales"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n"); 

                    

                    $numCantidad = $numdoc;

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '          '.$numdoc;

                    }else if($numTotal == 2){

                        $newString = '         '.$numdoc;

                    }else if($numTotal == 3){

                        $newString = '        '.$numdoc;

                    }else if($numTotal == 4){

                        $newString = '       '.$numdoc;

                    }else if($numTotal == 5){

                        $newString = '      '.$numdoc;

                    }else if($numTotal == 6){

                        $newString = '     '.$numdoc;

                    }else if($numTotal == 7){

                        $newString = '    '.$numdoc;

                    }else if($numTotal == 8){

                        $newString = '   '.$numdoc;

                    }else if($numTotal == 9){

                        $newString = '  '.$numdoc;

                    }



                    $contenidoHeader = '@ Prow()+1,07 SAY "Operaciones:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    

                    $numCantidad = number_format(round($totalexglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalexglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalexglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,04 SAY "Ventas Exentas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    

                    $numCantidad = number_format(round($totalgrglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalgrglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalgrglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,03 SAY "Ventas Gravadas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $numCantidad = number_format(round($totalivglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalivglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalivglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,15 SAY "IVA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $numCantidad = number_format(round($totalglobal, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){

                        $newString = '         $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($totalglobal, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($totalglobal, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow()+2,00 SAY "INGRESOS:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");  

                    $total_ing_sum=0;

                    $l=0;

                    foreach($tipospagos as $tip){

                        $l++;

                    }

                    $p=0;

                    foreach($tipospagos as $tip){

                        $nameForma = substr($tip->descrip, 0, 13);

                        $totalString = strlen($nameForma);

                        $newCoordenada=0;

                        

                        if($totalString == '8'){

                            $newCoordenada = 10; 

                        }else if($totalString == '9'){

                            $newCoordenada = 9;

                        }else if($totalString == '10'){

                            $newCoordenada = 8;

                        }else if($totalString == '11'){

                            $newCoordenada = 7;

                        }else if($totalString == '12'){

                            $newCoordenada = 6;

                        }else if($totalString == '13'){

                            $newCoordenada = 5;

                        }else if($totalString == '14'){

                            $newCoordenada = 4;

                        }else if($totalString == '15'){

                            $newCoordenada = 3;

                        }else if($totalString == '16'){

                            $newCoordenada = 2;

                        }else if($totalString == '17'){

                            $newCoordenada = 1;

                        }else if($totalString == '18'){

                            $newCoordenada = 0;

                        }  

                                                

                        $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);

                        $valorString = strval($numPrecio);

                        $numTotal = strlen($valorString);       



                        if($numTotal == 1){

                            $newString = '         $'.$numPrecio;

                        }else if($numTotal == 2){

                            $newString = '        $'.$numPrecio;

                        }else if($numTotal == 3){

                            $newString = '       $'.$numPrecio;

                        }else if($numTotal == 4){

                            $newString = '      $'.$numPrecio;

                        }else if($numTotal == 5){

                            $newString = '     $'.$numPrecio;

                        }else if($numTotal == 6){

                            $newString = '    $'.$numPrecio;

                        }else if($numTotal == 7){

                            $newString = '   $'.$numPrecio;

                        }else if($numTotal == 8){

                            $newString = '  $'.$numPrecio;

                        }else if($numTotal == 9){

                            $newString = ' $'.$numPrecio;

                        }

                                    

                        if($p == $l - 1){

                            $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");



                            $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                                        

                        }else{ 

                            $contenidoHeader = '@ Prow()+1,'.$newCoordenada.' SAY "'.$nameForma.':'.$newString.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                        }

                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);

                        $p++;

                    }

                        

                    $numCantidad = number_format(round($total_ing_sum, 2),2);

                    $totalString = strval($numCantidad);

                    $numTotal = strlen($totalString);



                    if($numTotal == 1){ 

                        $newString = '         $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 2){

                        $newString = '        $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 3){

                        $newString = '       $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 4){

                        $newString = '      $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 5){

                        $newString = '     $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 6){

                        $newString = '    $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 7){

                        $newString = '   $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 8){

                        $newString = '  $'.number_format(round($total_ing_sum, 2),2);

                    }else if($numTotal == 9){

                        $newString = ' $'.number_format(round($total_ing_sum, 2),2);

                    }



                    $contenidoHeader = '@ Prow()+1,13 SAY "Sumas:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $contenidoHeader = '@ Prow(),20 SAY "'.$newString.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@ Prow()+2,00 SAY "CUADRE DE CAJA:"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");  

                    

                    $contenidoHeader = '@Prow()+1,06 SAY "Sist"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@Prow(),17 SAY "Caja"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoHeader = '@Prow(),28 SAY "Dife"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");



                    $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);



                    $totalSistema = 0;

                    $totalCaja = 0;

                    $numerotransacc = 0;

                    foreach($infoCuadre as $info){

                        $numCantidad = substr($info->formapago, 0, 4);

                        $totalString = strval($numCantidad);



                        $numCantidad2 = number_format(round($info->valorsys, 2),2);

                        $totalString2 = strval($numCantidad2);

                        $numTotal2 = strlen($totalString2);



                        if($numTotal2 == 1){

                            $newString2 = '         $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 2){

                            $newString2 = '        $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 3){

                            $newString2 = '       $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 4){

                            $newString2 = '      $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 5){

                            $newString2 = '     $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 6){

                            $newString2 = '    $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 7){

                            $newString2 = '   $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 8){

                            $newString2 = '  $'.number_format(round($info->valorsys, 2),2);

                        }else if($numTotal2 == 9){

                            $newString2 = ' $'.number_format(round($info->valorsys, 2),2);

                        }



                        $numCantidad3 = number_format(round($info->valorusr, 2),2);

                        $totalString3 = strval($numCantidad3);

                        $numTotal3 = strlen($totalString3);



                        if($numTotal3 == 1){

                            $newString3 = '         $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 2){

                            $newString3 = '        $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 3){

                            $newString3 = '       $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 4){

                            $newString3 = '      $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 5){

                            $newString3 = '     $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 6){

                            $newString3 = '    $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 7){

                            $newString3 = '   $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 8){

                            $newString3 = '  $'.number_format(round($info->valorusr, 2),2);

                        }else if($numTotal3 == 9){

                            $newString3 = ' $'.number_format(round($info->valorusr, 2),2);

                        }



                        $valorSistema = round($info->valorsys, 2);

                        $valorCaja = round($info->valorusr, 2);



                        $totalSistema = $totalSistema + $valorSistema;

                        $totalCaja = $totalCaja + $valorCaja;



                        if($valorSistema == 0){

                            $diferencia = $valorCaja;

                        }else{

                            $diferencia = $valorCaja - $valorSistema;

                        }



                        $numCantidad4 = number_format(round($diferencia, 2),2);

                        $totalString4 = strval($numCantidad4);

                        $numTotal4 = strlen($totalString4);



                        if($numTotal4 == 1){

                            $newString4 = '         $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 2){

                            $newString4 = '        $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 3){

                            $newString4 = '       $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 4){

                            $newString4 = '      $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 5){

                            $newString4 = '     $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 6){

                            $newString4 = '    $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 7){

                            $newString4 = '   $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 8){

                            $newString4 = '  $'.number_format(round($diferencia, 2),2);

                        }else if($numTotal4 == 9){

                            $newString4 = ' $'.number_format(round($diferencia, 2),2);

                        }



                        $countSys = '('.$info->countsys.')';

                        $stringCount = strval($countSys);

                        $totalString = strlen($stringCount);

                        /*while($totalString < 5){

                            $stringCount = ' '.$stringCount;

                        }*/



                        $countUser = '('.$info->countuser.')';

                        $stringCountUser = strval($countUser);

                        $totalString = strlen($stringCountUser);

                        /*

                        while($totalString < 5){

                            $stringCountUser = ' '.$stringCountUser;

                        }*/

                        

                        $contenidoHeader = '@Prow()+1,00 SAY "'. $numCantidad.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        

                        $contenidoHeader = '@Prow(),06 SAY "$'.$numCantidad2.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    

                        $contenidoHeader = '@Prow(),17 SAY "$'.$numCantidad3.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                    

                        $contenidoHeader = '@Prow(),28 SAY "$'.$numCantidad4.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $numerotransacc = $numerotransacc + 1;

                        

                    }

                    

                    //FINAL FOR CUADRE.

                    

                    $numTotSistema = number_format(round($totalSistema, 2),2);

                    $countString = strval($numTotSistema);

                    $numSistema = strlen($countString);



                    if($numSistema == 1){

                        $valorSistema = '         $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 2){

                        $valorSistema = '        $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 3){

                        $valorSistema = '       $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 4){

                        $valorSistema = '      $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 5){

                        $valorSistema = '     $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 6){

                        $valorSistema = '    $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 7){

                        $valorSistema = '   $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 8){

                        $valorSistema = '  $'.number_format(round($totalSistema, 2),2);

                    }else if($numSistema == 9){

                        $valorSistema = ' $'.number_format(round($totalSistema, 2),2);

                    }



                    $numTotCaja = number_format(round($totalCaja, 2),2);

                    $countString = strval($numTotCaja);

                    $numCaja = strlen($countString);



                    if($numCaja == 1){

                        $valorCaja = '         $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 2){

                        $valorCaja = '        $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 3){

                        $valorCaja = '       $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 4){

                        $valorCaja = '      $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 5){

                        $valorCaja = '     $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 6){

                        $valorCaja = '    $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 7){

                        $valorCaja = '   $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 8){

                        $valorCaja = '  $'.number_format(round($totalCaja, 2),2);

                    }else if($numCaja == 9){

                        $valorCaja = ' $'.number_format(round($totalCaja, 2),2);

                    }



                    $totalDiferencia = $totalCaja - $totalSistema;

                    $numTotDif = number_format(round($totalDiferencia, 2),2);

                    $countString = strval($numTotDif);

                    $numDif = strlen($countString);



                    if($numDif == 1){

                        $valorTotDif = '         $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 2){

                        $valorTotDif = '        $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 3){

                        $valorTotDif = '       $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 4){

                        $valorTotDif = '      $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 5){

                        $valorTotDif = '     $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 6){

                        $valorTotDif = '    $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 7){

                        $valorTotDif = '   $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 8){

                        $valorTotDif = '  $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 9){

                        $valorTotDif = ' $'.number_format(round($totalDiferencia, 2),2);

                    }else if($numDif == 10){

                        $valorTotDif = '$'.number_format(round($totalDiferencia, 2),2);

                    }

                    

                if($numerotransacc > 1){

                        $contenidoHeader = '@Prow()+2,00 SAY "Resumen:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow()+1,05 SAY "Sistema:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),20 SAY "'.$valorSistema.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow()+1,08 SAY "Caja:"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        $contenidoHeader = '@Prow(),20 SAY "'.$valorCaja.'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");



                        if($totalDiferencia > 0){

                            $contenidoHeader = '@Prow()+1,04 SAY "Sobrante:"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");



                            $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                        }else if($totalDiferencia < 0){

                            $contenidoHeader = '@Prow()+1,04 SAY "Faltante:"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");



                            $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                        }else if($totalDiferencia == 0){

                            $contenidoHeader = '@Prow()+1,02 SAY "Diferencia:"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");



                            $contenidoHeader = '@Prow(),20 SAY "'.$valorTotDif.'"';

                            fwrite($archivoTxt, $contenidoHeader);

                            fwrite($archivoTxt, "\r\n");

                        }

                    }                            

                    

                    $contenidoHeader = '@Prow()+3,00 SAY "F._______________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,08 SAY "'.trim($this->session->userdata('userLog')).'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,04 SAY "'.$dia. '/' .$mes.'/'.$anio.'  '.$strTime.'"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,00 SAY "_________________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@Prow()+1,00 SAY "_________________________________"';

                    fwrite($archivoTxt, $contenidoHeader);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    $contenidoProductos ='@ Prow()+1,00 Say " "';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    $contenidoProductos ='@ Prow()+1,00 Say CHR(27)+"i"';

                    fwrite($archivoTxt, $contenidoProductos);

                    fwrite($archivoTxt, "\r\n");

                    

                    fclose($archivoTxt);



                    $docTxt = "ReimpCorteZ".$numero_z.".gox";

                    if(file_exists($docTxt)){

                        header('Content-Description: File Transfer');

                        header('Content-Type: application/octet-stream');

                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');

                        header('Expires: 0');

                        header('Cache-Control: must-revalidate');

                        header('Pragma: public');

                        header('Content-Length: ' . filesize($docTxt));

                        readfile($docTxt);



                        unlink($docTxt);

                        exit;

                    }    

                }

            }
        //-

        //Formatos de Facturacion------------------------------------------------------------------
            # v4firocentr
           
            
            function ventaTicketFinal($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                   

                    $this->load->model('global_model');   $this->load->model('ventas_model');
                    $this->load->model('invtran_model');  $this->load->model('acs_model');
                    $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                    $this->load->model('sucursal_model'); $this->load->model('caja_model');
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $comandosTM = new comandosTM();
    
                    foreach($informacion as $info){
                        $idcentro = $info->idcentro;
                        $idcaja = $info->idcaja;
                        $serieDocumento = $info->serie;
                        $numeroRecibo = $info->numero;
                        $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                        $cliente = $this->eliminarTildes($info->nameCliente);
                        $clienteTipo = $info->idtipo;
                        $nrc = $info->nrc;
                        $nit = $info->nit;
                        $direccion = $this->eliminarTildes($info->direccion);
                        $giro = $this->eliminarTildes($info->giro);
                        $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                        $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                        $direccionSuc = $info->direccioncentro;
                    
                    }
    
                    $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    
                    foreach($datoscaja as $caja){
                        $this->eliminarTildes($namecaja = $caja->descrip);
                        $numcaja = $caja->resolucion;
                        $printerName = $caja->notas;
                    }
                    
                    foreach($infoRes as $infres){
                        $numres = $infres->resolucion;
                        $fecres = $infres->fresolucion;
                        $desder = $infres->serie.$infres->desde;
                        $hastar = $infres->serie.$infres->hasta;
                    }
    
                    $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                    $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                    $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                    $productos = $this->acs_model->getDataVenta100k($trannum);
                    $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);
    
                    $findRetencion = 0; $valRetencion = 0;
                    $partFechaName = explode("/", $fechaRecibo);
    
                    $cmds = comandosTM::Initialize;
                    $cmds .= comandosTM::PrintBoth;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::TextAlignCenter;
                    $cmds .= comandosTM::FontSmall;
    
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($namecentro), 0, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                
    
                    $cmds .= substr(strtoupper($namecaja), 0, 39);
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= strtoupper($info->descrip).' #'.$info->numero;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::FontSmall;
                    $cmds .= str_repeat("-", 39);
                    $cmds .= comandosTM::LineFeed;
                    
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    
                    $total = 0; $totalGravado = 0; $totalExento = 0;
                    $totalIVA = 0; $invexento = $info->exento; 
                    $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                    $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                    $ivaCesc = 0; $cesc = 0;
                    //var_dump($productos);
                    foreach($productos as $pro){
                        if($pro->tipotax != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta  = "";
                            $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tipotax != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }else if($pro->tipotax== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }else if($pro->tipotax == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }
    
                        $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                        $proname   = $pro->descrip." [".trim($pro->modelo)."]";
                        
                        if($pro->descuento != 0){
                            //PRODUCTO CON DESCUENTO
                            $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                            $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                            
                            $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                            $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                
    
                            $cmds .= comandosTM::TextAlignLeft;
                            $cmds .= $this->eliminarTildes($proname);
                            $cmds .= comandosTM::LineFeed;
    
                            $preciouni = $pro->precioneto;
                            $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                            $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                            $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                      
                            $descuento = $pro->descuento / 100;
                            $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                            $totdsc = $cantdes * abs($pro->cantidad);
                            $totalDesc = $totalDesc + $totdsc;
                            
                            $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                            $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                      
                            
                        }else{
                            //PRODUCTO SIN DESCUENTO
                            if(strlen($vnExenta) != 0){
                                $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $totalSumas = $totalSumas + $absTotal;
                            }else{
                                $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                $totalSumas = $totalSumas + $absTotal;
                            }
    
                            $cmds .= comandosTM::TextAlignLeft;
                            $cmds .= $this->eliminarTildes($proname);
                            $cmds .= comandosTM::LineFeed;
    
                            $preciouni = $pro->precioneto;
                            $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                            $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                            $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                        }
    
                        if($pro->tax1 == 18){
                            $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                            $ivaCesc++;
                        }
    
                        $numProd++;
                        $cantidades = $cantidades + abs($pro->cantidad);
                    }
    
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::LineFeed;
                    
                    $grantotal = $totalIVA + $totalGravado;

                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("L/U:   ", 20, "LEFT");
                    $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
    
                    if($totalDesc != 0){
                        $cmds .= $comandosTM->pad(1);
                        $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                        $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                        $cmds .= comandosTM::LineFeed;
                    }
    
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                    $cmds .= comandosTM::FontBoldDisable;              
                    $cmds .= comandosTM::LineFeed;
                    
    
                    $totalPagado = 0;
                    $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
    
                    foreach($detailPagos as $dtpagos){
                        $notasPago = $dtpagos->notas;
                        $nameForma = substr($dtpagos->namePago, 0, 13);
                        $totalString = strlen($nameForma);
                        $cmds .= $comandosTM->pad(1);
                        $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                        $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                        $cmds .= comandosTM::LineFeed;
    
                        $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                    }
    
                    $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');
    
                    if($totalVuelto != 0){
                        $cmds .= $comandosTM->pad(1);
                        $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                        $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                        $cmds .= comandosTM::LineFeed;
                    }
    
                    $cmds .= str_repeat("-", 39);
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= comandosTM::TextAlignCenter;
                    $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                    $cmds .= comandosTM::LineFeed;
    
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("d/m/Y H:i:s A");
    
                    $cmds .= $fecha_actual;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= 'GRACIAS POR SU COMPRA';
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::FullCut950;
                    $this->ventas_model->setCommandsPrint($trannum, $cmds);
                    header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                    exit;
                }
            }

            function printDevolucion($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                   

                    $this->load->model('global_model');   $this->load->model('ventas_model');
                    $this->load->model('invtran_model');  $this->load->model('acs_model');
                    $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                    $this->load->model('sucursal_model'); $this->load->model('caja_model');
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $comandosTM = new comandosTM();
    
                    foreach($informacion as $info){
                        $idcentro = $info->idcentro;
                        $idcaja = $info->idcaja;
                        $serieDocumento = $info->serie;
                        $numeroRecibo = $info->numero;
                        $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                        $cliente = $this->eliminarTildes($info->nameCliente);
                        $clienteTipo = $info->idtipo;
                        $nrc = $info->nrc;
                        $nit = $info->nit;
                        $direccion = $this->eliminarTildes($info->direccion);
                        $giro = $this->eliminarTildes($info->giro);
                        $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                        $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                        $direccionSuc = $info->direccioncentro;
                    
                    }
    
                    $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    
                    foreach($datoscaja as $caja){
                        $this->eliminarTildes($namecaja = $caja->descrip);
                        $numcaja = $caja->resolucion;
                        $printerName = $caja->notas;
                    }
                    
                    foreach($infoRes as $infres){
                        $numres = $infres->resolucion;
                        $fecres = $infres->fresolucion;
                        $desder = $infres->serie.$infres->desde;
                        $hastar = $infres->serie.$infres->hasta;
                    }
    
                    $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                    $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                    $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                    $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                    $productos = $this->acs_model->getDataVenta100k($trannum);
                    $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);
    
                    $findRetencion = 0; $valRetencion = 0;
                    $partFechaName = explode("/", $fechaRecibo);
    
                    $cmds = comandosTM::Initialize;
                    $cmds .= comandosTM::PrintBoth;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::TextAlignCenter;
                    $cmds .= comandosTM::FontSmall;
    
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($namecentro), 0, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                
    
                    $cmds .= substr(strtoupper($namecaja), 0, 39);
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= strtoupper($info->descrip).' #'.$info->numero;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::FontSmall;
                    $cmds .= str_repeat("-", 39);
                    $cmds .= comandosTM::LineFeed;
                    
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    
                    $total = 0; $totalGravado = 0; $totalExento = 0;
                    $totalIVA = 0; $invexento = $info->exento; 
                    $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                    $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                    $ivaCesc = 0; $cesc = 0;
                    //var_dump($productos);
                    foreach($productos as $pro){
                        if($pro->tipotax != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta  = "";
                            $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tipotax != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }else if($pro->tipotax== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }else if($pro->tipotax == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }
    
                        $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                        $proname   = $pro->descrip." [".trim($pro->modelo)."]";
                        
                        if($pro->descuento != 0){
                            //PRODUCTO CON DESCUENTO
                            $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                            $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                            
                            $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                            $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                
    
                            $cmds .= comandosTM::TextAlignLeft;
                            $cmds .= $this->eliminarTildes($proname);
                            $cmds .= comandosTM::LineFeed;
    
                            $preciouni = $pro->precioneto;
                            $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                            $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                            $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                      
                            $descuento = $pro->descuento / 100;
                            $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                            $totdsc = $cantdes * abs($pro->cantidad);
                            $totalDesc = $totalDesc + $totdsc;
                            
                            $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                            $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                      
                            
                        }else{
                            //PRODUCTO SIN DESCUENTO
                            if(strlen($vnExenta) != 0){
                                $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $totalSumas = $totalSumas + $absTotal;
                            }else{
                                $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                $totalSumas = $totalSumas + $absTotal;
                            }
    
                            $cmds .= comandosTM::TextAlignLeft;
                            $cmds .= $this->eliminarTildes($proname);
                            $cmds .= comandosTM::LineFeed;
    
                            $preciouni = $pro->precioneto;
                            $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                            $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                            $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                        }
    
                        if($pro->tax1 == 18){
                            $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                            $ivaCesc++;
                        }
    
                        $numProd++;
                        $cantidades = $cantidades + abs($pro->cantidad);
                    }
    
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::LineFeed;
                    
                    $grantotal = $totalIVA + $totalGravado;

                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("L/U:   ", 20, "LEFT");
                    $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
    
                    if($totalDesc != 0){
                        $cmds .= $comandosTM->pad(1);
                        $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                        $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                        $cmds .= comandosTM::LineFeed;
                    }
    
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                    $cmds .= comandosTM::FontBoldDisable;              
                    $cmds .= comandosTM::LineFeed;
                    
    
                    $totalPagado = 0;
                    $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
    
                    foreach($detailPagos as $dtpagos){
                        $notasPago = $dtpagos->notas;
                        $nameForma = substr($dtpagos->namePago, 0, 13);
                        $totalString = strlen($nameForma);
                        $cmds .= $comandosTM->pad(1);
                        $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                        $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                        $cmds .= comandosTM::LineFeed;
    
                        $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                    }
    
                    $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');
    
                    if($totalVuelto != 0){
                        $cmds .= $comandosTM->pad(1);
                        $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                        $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                        $cmds .= comandosTM::LineFeed;
                    }
    
                    $cmds .= str_repeat("-", 39);
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= comandosTM::TextAlignCenter;
                    $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                    $cmds .= comandosTM::LineFeed;
    
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("d/m/Y H:i:s A");
    
                    $cmds .= $fecha_actual;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::FullCut950;
                    $this->ventas_model->setCommandsPrint($trannum, $cmds);
                    header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                    exit;
                }
            }
            /////////////////////////////////

            /////////////////////////////////

            # v2 - prow - esc pos
            function facturaConsumidorFinalOld($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);
                    $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
                    $cotExenta = $this->ventas_model->validateDocumentoExentoTran100($trannum);
                    $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);

                    foreach($detailPagos as $dtpagos){
                        $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                    }
                    $findRetencion = 0; $valRetencion = 0;
                    foreach($pagosCredito as $informacionPagos){
                        if($informacionPagos->t100descrip == 'P_RT'){
                            $findRetencion = 1;
                            $valRetencion = $informacionPagos->valor * -1;
                        }
                    }
                    #   INFORMACION
                    foreach($informacion as $info){
                        if ($info->estatus == 9) {
                            redirect($this->session->userdata('dirReports') . '/reports/facturaAnuladaV/' . $trannum);
                        }
                        $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                        foreach($departamentoMunicipio as $info_dm){
                            $departamento = trim($info_dm->depto);
                            $municipio = trim($info_dm->municipio);
                        }
                        
                        $archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ 09,57 Say "No.:'.$info->numero.' Orden#: '.$trannum.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n"); 
                        $nombreCliente = $this->eliminarTildes($info->nameCliente);
                        $contenidoHeader = '@ Prow ()+2,14 Say "'.substr($nombreCliente, 0, 35).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//11
                        
                        $contenidoHeader = '@ Prow (),62 Say "'.date_format(date_create($info->fecha), 'd/m/Y').'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//11
                        
                        $contenidoHeader = '@ Prow ()+1,16 Say "'.substr($info->direccion, 0, 50).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//12

                        $nombreVendedor = $this->eliminarTildes($info->nameVendedor);
                        $contenidoHeader = '@ Prow ()+2,22 Say "'.substr($nombreVendedor, 0, 50).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//14

                        $contenidoHeader = '@ Prow()+3,1 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//17
                    }
                    #   PRODUCTOS
                    $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);//16
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                    $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                    $CooNum = 13; $ivaCesc = 0; $cesc = 0; 

                    foreach($productos as $pro){
                        if($numProd < $maxlines){
                            if($pro->tipotax != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "";
                                $vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            }else if($pro->tipotax != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                            }else if($pro->tipotax== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                            }else if($pro->tipotax == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                            }

                            $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                            //$nombrepro = substr($pro->descrip, 0, 12).' '.substr($pro->modelo, 0, 12);
                            $nombrepro = $pro->modelo.' '.$pro->descrip;
                            $nombrepro = $this->eliminarTildes($nombrepro);
                            $CooNum++;

                            $contenidoHeader = '@ Prow()+1,7 Say "'.str_pad(abs($pro->cantidad),4," ",STR_PAD_LEFT).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow(),15 Say "'.substr($nombrepro,0,36).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $StringPreUni = str_pad(number_format(round($preciouni, 2), 2 ,'.',''), 4, " ", STR_PAD_LEFT);
                            $contenidoHeader = '@ Prow(),56 Say "'.$StringPreUni.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $StringVnEx = str_pad($vnExenta, 4, " ", STR_PAD_LEFT);
                            $contenidoHeader = '@ Prow(),66 Say "'.$StringVnEx.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $StringVnGr = str_pad($vnGravada, 9, " ", STR_PAD_LEFT);
                            $contenidoHeader = '@ Prow(),76 Say "'.$StringVnGr.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                        }

                        if($pro->tax1 == 18){
                            $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                            $ivaCesc++;
                        }
                        $numProd++;
                    }//33
                    #   TOTALES
                    if($totalExento == 0) $totalExento = 0;
                    else $totalExento = number_format(round($totalExento, 2), 2 ,'.','');

                    if($totalGravado == 0) $totalGravado = 0;
                    else $totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');

                    #   CESC
                    if ($cesc > 0) {
                        $contenidoHeader = '@ 34,64 Say "CESC 5%: $'.str_pad($cesc, 9, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                    $numero = number_format(round($total, 2), 2 ,'.','');
                    $TotalLetras = trim($this->valorEnLetras(trim($numero)));
                    
                    #   VALOR EN LETRAS  PARTE 1
                    $contenidoHeader = '@ 36,10 Say "'.substr(strtoupper($TotalLetras), 0, 63).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    #   SUMAS
                    $sumas = ($ivaCesc > 0) ? ($total - $cesc) : $total;
                    $Sumas = number_format(round($sumas, 2), 2 ,'.','');
                    $contenidoHeader = '@ Prow(),74 Say "$'.str_pad($Sumas, 9, " ", STR_PAD_LEFT).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    #   VALOR EN LETRAS  PARTE 2
                    $contenidoHeader = '@ 37,10 Say "'.substr(strtoupper($TotalLetras), 63, 120).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");//*/
                    
                    #  NO SUJETA
                    $SUJETA = number_format(round(0, 2), 2 ,'.','');
                    $contenidoHeader = '@ 37,74 Say "$'.str_pad($SUJETA, 9, " ", STR_PAD_LEFT).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #  EXENTA
                    $EXENTA = number_format(round($totalExento, 2), 2 ,'.','');
                    $contenidoHeader = '@ 38,74 Say "$'.str_pad($EXENTA, 9, " ", STR_PAD_LEFT).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #  SUB TOTAL
                    $SubTotal = number_format(round($total, 2), 2 ,'.','');
                    $contenidoHeader = '@ 41,74 Say "$'.str_pad($SubTotal, 9, " ", STR_PAD_LEFT).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #  RETENCION
                    if ($findRetencion > 0) {
                        $retencionV = $totalGravado * 0.01;
                        $total = $total - $retencionV;
                    } else $retencionV = 0;
                    $Retencion = number_format(round($retencionV, 2), 2 ,'.','');
                    $contenidoHeader = '@ Prow()+1,74 Say "$-'.str_pad($Retencion, 8, " ", STR_PAD_LEFT).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #  TOTAL
                    $StringTot = number_format(round($total, 2), 2 ,'.','');
                    $StringTot = str_pad($StringTot, 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ Prow()+1,74 Say "$'.$StringTot.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    //----------------------------------------------------------------------------
                    if($efectivo == 1){
                        $contenidoProductos ='@ Prow(),Pcol() SAY CHR(27)+"p"+Chr(0)+"23"';
                        fwrite($archivoTxt, $contenidoProductos);
                        fwrite($archivoTxt, "\r\n");    
                    }//*/

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");//*/

                    $docTxt = $info->descrip.$info->numero.".gox";
                    if(file_exists($docTxt)){
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($docTxt));
                        readfile($docTxt);                    
                        unlink($docTxt);
                        exit;
                    }
                }
            }
            function facturaConsumidorFinal($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->model('global_model');   $this->load->model('ventas_model');
                    $this->load->model('invtran_model');  $this->load->model('acs_model');
                    $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                    $this->load->model('sucursal_model'); $this->load->model('caja_model');
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    date_default_timezone_set('America/El_Salvador');
    
                    $comandosTM = new comandosTM();
    
                    foreach($informacion as $info){
                        $tipocliente = $info->idtipo;

                        $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                        foreach($departamentoMunicipio as $info_dm){
                            $departamento = trim($info_dm->depto);
                            $municipio = trim($info_dm->municipio);
                        }
                        $nombreCliente = $this->eliminarTildes($info->nameCliente);
                        $direccion = $this->eliminarTildes($info->direccion);
    
                    }
                    if ($info->estatus == 9) {
                        redirect($this->session->userdata('dirReports') . '/reports/facturaAnuladaV/' . $trannum);
                    }
                    $idcaja = $info->idcaja;
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
    
                    foreach($datoscaja as $caja){    
                        $printerName = $caja->notas;
                    }
    
                    $now = new DateTime();
                    $fechaImpre = $now->format('d/m/Y');
                    $horaImpre = $now->format('h:i');
    
                    $cmds = comandosTM::Initialize;
                    $cmds .= comandosTM::PrintSlip;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::FontSmall;
                    $cmds .= comandosTM::TextAlignLeft;
    
                    $cmds .= comandosTM::LineFeed; $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed; $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed; $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= "123456789*123456789*123456789*123456789*123456789*123456789*123456789*";
                    $cmds .= $comandosTM->pad(61);
                    $cmds .= 'No.:'.$info->numero.' Orden#: '.$trannum;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(15);
                    $cmds .= $comandosTM->padText(substr($nombreCliente, 0,39), 39, "RIGHT");
                    $cmds .= $comandosTM->pad(7);
                    $cmds .= date_format(date_create($info->fecha), 'd/m/Y');     
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(17);
                    $cmds .= $comandosTM->padText(substr($direccion, 0,37), 37, "RIGHT");
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->pad(23);
                    $cmds .= substr($info->nameVendedor, 0,37);
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    $maxlines = 17;
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    
                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                    $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                    $CooNum = 13; 
    
                    foreach($productos as $pro){
                        if($numProd < $maxlines){
                            if($pro->tipotax != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                
                                $vnExenta = "";
                                $vnGravada = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            }else if($pro->tipotax != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
    
                                $vnExenta = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                            }else if($pro->tipotax== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
    
                                $vnExenta = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                            }else if($pro->tipotax == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                
                                $vnExenta = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                            }
                            
                            $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                            $nombrepro = substr($pro->modelo.' '.$pro->descrip, 0, 42);
                            
                            $CooNum++;
    
                            $cmds .= $comandosTM->pad(8);
                            $cmds .= $comandosTM->padText(abs($pro->cantidad), 6, "BOTH");
                            $cmds .= $comandosTM->padText($nombrepro, 43, "RIGHT");
                            $cmds .= $comandosTM->padText(number_format(round($preciouni, 2), 2 ,'.',''), 6, "LEFT");
                            $cmds .= $comandosTM->padText($vnExenta, 12, "LEFT");
                            $cmds .= $comandosTM->padText($vnGravada, 10, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                        }
                        $numProd++;
                    }
    
                    while($numProd < $maxlines){
                        $cmds .= comandosTM::LineFeed;
                        $numProd++;
                    }
    
                      //TOTALES
                      $subtotalventas = $totalExento + $totalGravado + $totalIVA;
                      if($totalExento == 0) $totalExento = "";	
                      else $totalExento = number_format(round($totalExento, 2), 2,'.','');
                      
                      if(($tipocliente==3) && ($totalGravado>=100)){
                          $reten = $totalGravado * 0.01;
                          $retencion = '-'.$reten;
                          $total= $total-$reten;
                      } else $retencion = 0;
                          
                      if($retencion == 0) $retencion = "";    
                      else { 
                          $retencion = abs(number_format(round($retencion, 2), 2 ,'.',''));
                      }
                      
                      $numero = number_format(round($total, 2), 2 ,'.','');
                      $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                      $totalGravIva = $totalGravado + $totalIVA;
          
                      $subtotal = $totalGravado + $totalIVA;
                      $total = $subtotal;
                      if($retencion != "") {
                          $total = $subtotal - $retencion;
                          $retencion= number_format(round($retencion, 2), 2 ,'.','');
                      }
          
                      if($totalExento != "") {
                          $total = $total + $totalExento;
                      }
                      
                      $total = number_format(round($total, 2), 2 ,'.','');
                      $subtotal = number_format(round($subtotal, 2), 2 ,'.','');
          
                      $numero = number_format(round($total, 2), 2 ,'.','');
                      $TotalLetras = trim($this->valorEnLetras($numero));
                      $totalGravado= number_format(round($totalGravado, 2), 2 ,'.','');
                      $totalIVA= number_format(round($totalIVA, 2), 2 ,'.','');
                      $totalGravIva = number_format(round($totalGravIva, 2), 2 ,'.','');
                      $subtotalventas = number_format(round($subtotalventas, 2), 2 ,'.','');
      
          
                      $total = number_format($total, 2 ,'.','');	
                      $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(14);
                    $cmds .= $comandosTM->padText(substr(strtoupper($TotalLetras), 0, 40), 40, "RIGHT");
                    $cmds .= $comandosTM->pad(22);
                    $cmds .= $comandosTM->padText("$".$totalGravIva, 10, "LEFT");
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(14);
                    $cmds .= $comandosTM->padText(substr(strtoupper($TotalLetras), 40, 40), 40, "RIGHT");
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    if($totalExento != ""){
                        $cmds .= $comandosTM->pad(76);
                        $cmds .= $comandosTM->padText("$".$totalExento, 10, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }else{
                       
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(76);
                    $cmds .= $comandosTM->padText("$".$subtotal, 10, "LEFT");
                    $cmds .= comandosTM::LineFeed;
    
                    if($retencion != ""){
                        $cmds .= $comandosTM->pad(76);
                        $cmds .= $comandosTM->padText("-$".$retencion, 10, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }else{
                       
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;
    
    
                    $cmds .= $comandosTM->pad(76);
                    $cmds .= $comandosTM->padText("$".$total, 10, "LEFT");
                    $cmds .= comandosTM::FormFeed;
    
                    $this->ventas_model->setCommandsPrint($trannum, $cmds);
                    header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                    exit;
                }
            }
            #   FACTURA ANULADA
            function facturaAnulada($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                } else {
                    
                    $archivoTxt = fopen(strtoupper('factura').$trannum.".gox",'w+');

                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");


                    $contenidoHeader = '"'.str_pad('Anulada', 30, " ", STR_PAD_LEFT).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '"'.str_pad('Anulada', 30, " ", STR_PAD_LEFT).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '"'.str_pad('Anulada', 30, " ", STR_PAD_LEFT).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '""';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    for ($i=0; $i < 10; $i++) {
                        $contenidoHeader = '"'.str_pad('Anulada', 30, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '""';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                    
                    
                    fclose($archivoTxt);
                    $docTxt = strtoupper('factura').$trannum.".gox";
                    if(file_exists($docTxt)){
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($docTxt));
                        readfile($docTxt);
                        
                        unlink($docTxt);
                        exit;
                    }
                }
            }

            function facturaAnuladaV($trannum) {
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                } else {
                    $archivoTxt = fopen(strtoupper('factura').$trannum.".gox",'w+');
                    # inicio
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    #-
                    # anulados
                        $contenidoHeader = '@ 10,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 12,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 14,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 16,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 18,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 20,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 22,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 24,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 26,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 28,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 30,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 32,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 36,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 40,40 Say "Anulada"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    #-
                    # fin
                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                

                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                

                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow()+1,76 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//*/
                    #-
                    fclose($archivoTxt);
                    $docTxt = strtoupper('factura').$trannum.".gox";
                    if(file_exists($docTxt)){
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($docTxt));
                        readfile($docTxt);
                        
                        unlink($docTxt);
                        exit;
                    }
                }
            }

            function devolucionFacturaConsumidorFinal($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                    
                    foreach($informacion as $info){
                        
                        $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                        foreach($departamentoMunicipio as $info_dm){
                            $departamento = trim($info_dm->depto);
                            $municipio = trim($info_dm->municipio);
                        }
                        
                        $archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');
        
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ 07,25 Say "No.'.$info->numero.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n"); 

                        $contenidoHeader = '@ 07,40 Say "Orden.'.$trannum.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n"); 
                        
                        $contenidoHeader = '@ Prow ()+1,25 Say "CLIENTE: '.substr($info->nameCliente, 0, 29).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ Prow (),70 Say "FECHA: '.date_format(date_create($info->fecha), 'd/m/Y').'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ Prow ()+1,25 Say "DIRECCION:'.substr($info->direccion, 0, 50).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow()+1,25 Say "CANT."';
                        fwrite($archivoTxt, $contenidoHeader);    
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow(),31 Say "DESCRIPCION"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow(),60 Say "UNIT."';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow(),72 Say "EXEN."';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow(),81 Say "GRAV."';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
                            
                            /*foreach($detailPagos as $dtpagos){

                                $contenidoHeader = '@ Prow ()+1,22 Say " FORMA DE PAGO:'.strtoupper(substr($dtpagos->namePago, 0, 20)).'"';

                                fwrite($archivoTxt, $contenidoHeader);

                                fwrite($archivoTxt, "\r\n");

                            }*/

                        

                        /*$contenidoHeader = '@ Prow (),54 Say " CAJERO:'.substr($info->facturadopor, 0, 25).'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");

                        

                        $contenidoHeader = '@ Prow ()+1,51 Say " VENDEDOR:'.substr($info->nameVendedor, 0, 25).'"';

                        fwrite($archivoTxt, $contenidoHeader);

                        fwrite($archivoTxt, "\r\n");*/

                    }

                    $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                    $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                    $CooNum = 13; $ivaCesc = 0; $cesc = 0; 

                    foreach($productos as $pro){
                        if($numProd < $maxlines){
                            if($pro->tipotax != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "";
                                $vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            }else if($pro->tipotax != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                            }else if($pro->tipotax== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                            }else if($pro->tipotax == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                                $vnGravada = "";
                            }

                            $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                            $nombrepro = substr($pro->descrip, 0, 12).' '.substr($pro->modelo, 0, 12);
                            $CooNum++;
                            $contenidoHeader = '@ Prow()+1,25 Say "'.abs($pro->cantidad).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow(),31 Say "'.$nombrepro.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                            
                            $StringPreUni = str_pad(number_format(round($preciouni, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT);
                            $contenidoHeader = '@ Prow(),58 Say "-'.$StringPreUni.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $StringVnEx = str_pad($vnExenta, 7, " ", STR_PAD_LEFT);
                            $contenidoHeader = '@ Prow(),70 Say "'.$StringVnEx.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $StringVnGr = str_pad($vnGravada, 7, " ", STR_PAD_LEFT);
                            $contenidoHeader = '@ Prow(),79 Say "-'.$StringVnGr.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");
                        }

                        if($pro->tax1 == 18){
                            $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                            $ivaCesc++;
                        }
                        $numProd++;
                    }

                    if($totalExento == 0){
                        $totalExento = "";
                    }else{
                        $totalExento = number_format(round($totalExento, 2), 2 ,'.','');
                    }

                    if($totalGravado == 0){
                        $totalGravado = "";
                    }else{
                        $totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');
                    }

                    $numero = number_format(round($total, 2), 2 ,'.','');
                    /*  if($numero>=1){
                        $TotalLetras = $this->convertir_a_letras(trim($numero));
                        $contenidoHeader = '@ 30,24 Say "SON: '.strtoupper($TotalLetras).'/DOLARES"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }*/

                    if(round($totalExento>0)){
                        $TotalEx1 = str_pad($totalExento, 7, " ", STR_PAD_LEFT);
                        $contenidoHeader = '@ Prow() ,68 Say "EXENT: $'.$TotalEx1.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }

                    if($ivaCesc > 0){
                        $sub_total = $total - $cesc;
                        $StringSubTotal = str_pad(number_format(round($sub_total, 2), 2 , '.',''), 7, " ", STR_PAD_LEFT);    
                        $contenidoHeader = '@ 26,70 Say "SUBTOTAL:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 26,79 Say "$'.number_format(round($StringSubTotal, 2), 2 ,'.','').'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $StringCesc = str_pad(number_format(round($cesc, 2), 2 , '.',''), 7, " ", STR_PAD_LEFT);
                        $contenidoHeader = '@ 27,74 Say "CESC:"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ 27,79 Say "$'.number_format(round($StringCesc, 2), 2 ,'.','').'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                    }

                    

                    $StringTot = str_pad(number_format(round($total, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 28,73 Say "TOTAL:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ 28,79 Say "$-'.number_format(round($StringTot, 2), 2 ,'.','').'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    if($efectivo == 1){
                        $contenidoProductos ='@ Prow(),Pcol() SAY CHR(27)+"p"+Chr(0)+"23"';
                        fwrite($archivoTxt, $contenidoProductos);
                        fwrite($archivoTxt, "\r\n");    
                    }

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $docTxt = $info->descrip.$info->numero.".gox";
                    if(file_exists($docTxt)){
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($docTxt));
                        readfile($docTxt);                    
                        unlink($docTxt);
                        exit;
                    }
                }
            }
            
            # v2 - prow esc - pos
            function creditoFiscalOldv2($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);
                    $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                    $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                    foreach($informacion as $info){
                        $idcps = $info->idcps;
                    }
                    foreach($detailPagos as $dtpagos){
                        $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                    }
                    $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                    foreach($infoGzips as $infg){
                        $departamento = trim($infg->depto);
                        $municipio = trim($infg->municipio);
                    }
                    $findRetencion = 0; $valRetencion = 0;
                    foreach($pagosCredito as $informacionPagos){
                        if($informacionPagos->t100descrip == 'P_RT'){
                            $findRetencion = 1;
                            $valRetencion = $informacionPagos->valor * -1;
                        }
                    }
                    #   INNFORMACION
                    foreach($informacion as $info){
                        if ($info->estatus == 9) {
                            redirect($this->session->userdata('dirReports') . '/reports/facturaAnuladaV/' . $trannum);
                        }
                        $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                        $idClase = $info->idclase;
                        $tipocliente = $info->idtipo;
                        
                        foreach($departamentoMunicipio as $info_dm){
                            $departamento = trim($info_dm->depto);
                            $municipio = trim($info_dm->municipio);
                        }

                        $fechaCredito = date_format(date_create($info->fecha), 'd m y');
                        $partesFecha = explode(" ", $fechaCredito);
                        switch($partesFecha[1]){
                            case 1:
                                $mes_name = "ENERO";
                                break;
                            case 2:
                                $mes_name = "FEBRERO";
                                break;
                            case 3:
                                $mes_name = "MARZO";
                                break;
                            case 4:
                                $mes_name = "ABRIL";
                                break;
                            case 5:
                                $mes_name = "MAYO";
                                break;
                            case 6:
                                $mes_name = "JUNIO";
                                break;
                            case 7:
                                $mes_name = "JULIO";
                                break;
                            case 8:
                                $mes_name = "AGOSTO";
                                break;
                            case 9:
                                $mes_name = "SEPTIEMBRE";
                                break;
                            case 10:
                                $mes_name = "OCTUBRE";
                                break;
                            case 11:
                                $mes_name = "NOVIEMBRE";
                                break;
                            case 12:
                                $mes_name = "DICIEMBRE";
                                break;
                            default:
                                $mes_name="";
                                break;
                        }

                        $archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");   
                        //-
                        $contenidoHeader = '@ 09,13 Say "No.: '.$info->numero.' Orden#: '.$trannum.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ 9,60 Say "'.$partesFecha[0].'/'.$partesFecha[1].'/'.$partesFecha[2].'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//9

                        $nombreCliente = $this->eliminarTildes($info->nameCliente);
                        $contenidoHeader = '@ 10,13 Say "'.substr($nombreCliente, 0, 38).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//10

                        $contenidoHeader = '@ Prow(),60 Say "'.substr($info->nrc, 0, 27).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//10

                        $contenidoHeader = '@ Prow()+1,14 Say "'.substr($info->direccion, 0, 37).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//11

                        $contenidoHeader = '@ Prow(),60 Say "'.substr($info->nit, 0, 27).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//11

                        $contenidoHeader = '@ Prow()+1,21 Say "'.substr($departamento, 0, 30).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//12

                        $contenidoHeader = '@ Prow(),57 Say "'.substr($info->giro, 0, 30).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//12

                        /*$contenidoHeader = '@ Prow()+1,67 Say "'.substr($info->nameVendedor, 0, 20).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//*///13
                        $contenidoHeader = '@ Prow()+1,67 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//13

                        $contenidoHeader = '@ Prow()+4,1 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//17
                    }
                    $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);
                    $productos = $this->invtran_model->getDataTran100k($trannum);

                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                    $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                    $ivaCesc = 0; $cesc = 0; 
                    #   PRODUCTOS
                    foreach($productos as $pro) {
                        if($numProd < $maxlines){
                            if($pro->tax1 != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "";
                                $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }else if($pro->tax1== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }

                            $preciouni = $pro->precioneto;
                            //$nombrepro = substr($pro->descrip, 0, 20).' '.substr($pro->modelo, 0, 20);
                            $nameProducto = trim($pro->modelo).' '.trim($pro->descrip);
                            $nombrepro = substr(trim($nameProducto), 0, 22);
                            
                            $contenidoHeader = '@ Prow()+1,7 Say "'.str_pad(abs($pro->cantidad),4," ",STR_PAD_LEFT).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow(),14 Say "'.substr($nombrepro, 0, 37).'"';//51
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $StringPreUni = str_pad(number_format(round($preciouni, 4), 4 ,'.',''), 9, " ", STR_PAD_LEFT);                        
                            $contenidoHeader = '@ Prow(),56 Say "'.$StringPreUni.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");//53-61

                            $StringVnEx = str_pad($vnExenta, 9, " ", STR_PAD_LEFT);
                            $contenidoHeader = '@ Prow(),66 Say "'.$StringVnEx.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");//66-75

                            $StringVnGr = str_pad($vnGravada, 9, " ", STR_PAD_LEFT);
                            $contenidoHeader = '@ Prow(),76 Say "'.$StringVnGr.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");//77-86
                        }
                        if($pro->tax1 == 18){
                            $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                            $ivaCesc++;
                        }
                        $numProd++;
                    }

                    if($totalExento == 0) $totalExento = 0;    
                    else $totalExento = number_format(round($totalExento, 2), 2 ,'.','');
                    
                    $totalGravIva = $totalGravado + $totalIVA;
                    
                    if($totalGravado == 0) $totalGravado = 0;    
                    else $totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');
                    if($valRetencion != 0) $total = $total - $valRetencion;
                    
                    if(($tipocliente==3) && ($totalGravado>=100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = '-'.$reten;
                        $total= $total-$reten;
                    }else{
                        $retencion = 0;
                    }//*/
                    #-------------------------   PAGOS
                    #   CESC 5% 
                    if($ivaCesc > 0) {
                        $totalIVA = $totalIVA - $cesc;
                        $contenidoHeader = '@ 34,64 Say "CESC 5%: $'.str_pad($cesc, 9, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                    #   VALOR EN LETRAS PARTE 1
                    $numero = number_format($total, 2 ,'.','');
                    $TotalLetras = $this->valorEnLetras($numero);
                    $contenidoHeader = '@ 36,10 Say "'.substr(strtoupper($TotalLetras), 0, 63).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   SUMAS-GRAVADO
                    $StringToGv = str_pad(number_format(round($totalGravado, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ Prow(),74 Say "$'.$StringToGv.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   VALOR EN LETRAS PARTE 2
                    $contenidoHeader = '@ 37,10 Say "'.substr(strtoupper($TotalLetras), 63, 120).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   IVA
                    $StringToIVA = str_pad(number_format(round($totalIVA, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ Prow(),74 Say "$'.$StringToIVA.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   SUB TOTAL
                    //$totalGravIva = $totalGravado + $totalIVA;
                    $StringToSubTotal = str_pad(number_format(round($totalGravIva, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 39,74 Say "$'.$StringToSubTotal.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   RETENIDO
                    //$retencion = 0;
                    $StringToReten = str_pad(number_format(round($retencion, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 40,74 Say "$'.$StringToReten.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   EXENTAS
                    $StringExenta = str_pad(number_format(round($totalExento, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 41,74 Say "$'.$StringExenta.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   NO SUJETA
                    $StringNSujeta = str_pad(number_format(round(0, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 43,74 Say "$'.$StringNSujeta.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   TOTAL
                    $StringTotal = str_pad(number_format(round($total, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 44,74 Say "$'.$StringTotal.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    #-----------------------------------------
                    if($efectivo == 1){
                        $contenidoProductos ='@ Prow(),Pcol() SAY CHR(27)+"p"+Chr(0)+"23"';
                        fwrite($archivoTxt, $contenidoProductos);
                        fwrite($archivoTxt, "\r\n");    
                    }
                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                
                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                
                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $docTxt = $info->descrip.$info->numero.".gox";
                    if(file_exists($docTxt)){
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($docTxt));
                        readfile($docTxt);                    
                        unlink($docTxt);
                        exit;
                    }
                }
            }
            function creditoFiscalOld($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);
                    $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                    $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                    foreach($informacion as $info){
                        $idcps = $info->idcps;
                    }
                    foreach($detailPagos as $dtpagos){
                        $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                    }
                    $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                    foreach($infoGzips as $infg){
                        $departamento = trim($infg->depto);
                        $municipio = trim($infg->municipio);
                    }
                    $findRetencion = 0; $valRetencion = 0;
                    foreach($pagosCredito as $informacionPagos){
                        if($informacionPagos->t100descrip == 'P_RT'){
                            $findRetencion = 1;
                            $valRetencion = $informacionPagos->valor * -1;
                        }
                    }
                    #   INNFORMACION
                    foreach($informacion as $info){
                        if ($info->estatus == 9) {
                            redirect($this->session->userdata('dirReports') . '/reports/facturaAnuladaV/' . $trannum);
                        }
                        $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                        $idClase = $info->idclase;
                        $tipocliente = $info->idtipo;
                        
                        foreach($departamentoMunicipio as $info_dm){
                            $departamento = trim($info_dm->depto);
                            $municipio = trim($info_dm->municipio);
                        }

                        $fechaCredito = date_format(date_create($info->fecha), 'd m y');
                        $partesFecha = explode(" ", $fechaCredito);
                        switch($partesFecha[1]){
                            case 1:
                                $mes_name = "ENERO";
                                break;
                            case 2:
                                $mes_name = "FEBRERO";
                                break;
                            case 3:
                                $mes_name = "MARZO";
                                break;
                            case 4:
                                $mes_name = "ABRIL";
                                break;
                            case 5:
                                $mes_name = "MAYO";
                                break;
                            case 6:
                                $mes_name = "JUNIO";
                                break;
                            case 7:
                                $mes_name = "JULIO";
                                break;
                            case 8:
                                $mes_name = "AGOSTO";
                                break;
                            case 9:
                                $mes_name = "SEPTIEMBRE";
                                break;
                            case 10:
                                $mes_name = "OCTUBRE";
                                break;
                            case 11:
                                $mes_name = "NOVIEMBRE";
                                break;
                            case 12:
                                $mes_name = "DICIEMBRE";
                                break;
                            default:
                                $mes_name="";
                                break;
                        }

                        $archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");   
                        //-
                        $contenidoHeader = '@ 10,13 Say "No.: '.$info->numero.' Orden#: '.$trannum.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ 10,60 Say "'.$partesFecha[0].'/'.$partesFecha[1].'/'.$partesFecha[2].'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//9

                        $nombreCliente = $this->eliminarTildes($info->nameCliente);
                        $contenidoHeader = '@ 11,13 Say "'.substr($nombreCliente, 0, 38).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//10

                        $contenidoHeader = '@ Prow(),60 Say "'.substr($info->nrc, 0, 27).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//10

                        $contenidoHeader = '@ Prow()+1,14 Say "'.substr($info->direccion, 0, 37).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//11

                        $contenidoHeader = '@ Prow(),60 Say "'.substr($info->nit, 0, 27).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//11

                        $contenidoHeader = '@ Prow()+1,21 Say "'.substr($departamento, 0, 30).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//12

                        $contenidoHeader = '@ Prow(),57 Say "'.substr($info->giro, 0, 30).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//12

                        /*$contenidoHeader = '@ Prow()+1,67 Say "'.substr($info->nameVendedor, 0, 20).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//*///13
                        /*$contenidoHeader = '@ Prow()+1,67 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//13//*/

                        $contenidoHeader = '@ Prow()+4,1 Say " "';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");//17
                    }
                    $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);
                    $productos = $this->invtran_model->getDataTran100k($trannum);

                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                    $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                    $ivaCesc = 0; $cesc = 0; 
                    #   PRODUCTOS
                    foreach($productos as $pro) {
                        if($numProd < $maxlines){
                            if($pro->tax1 != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "";
                                $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }else if($pro->tax1== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }

                            $preciouni = $pro->precioneto;
                            //$nombrepro = substr($pro->descrip, 0, 20).' '.substr($pro->modelo, 0, 20);
                            $nameProducto = trim($pro->modelo).' '.trim($pro->descrip);
                            $nombrepro = substr(trim($nameProducto), 0, 22);
                            
                            $contenidoHeader = '@ Prow()+1,7 Say "'.str_pad(abs($pro->cantidad),4," ",STR_PAD_LEFT).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow(),14 Say "'.substr($nombrepro, 0, 37).'"';//51
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $StringPreUni = str_pad(number_format(round($preciouni, 4), 4 ,'.',''), 9, " ", STR_PAD_LEFT);                        
                            $contenidoHeader = '@ Prow(),56 Say "'.$StringPreUni.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");//53-61

                            $StringVnEx = str_pad($vnExenta, 9, " ", STR_PAD_LEFT);
                            $contenidoHeader = '@ Prow(),66 Say "'.$StringVnEx.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");//66-75

                            $StringVnGr = str_pad($vnGravada, 9, " ", STR_PAD_LEFT);
                            $contenidoHeader = '@ Prow(),76 Say "'.$StringVnGr.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");//77-86
                        }
                        if($pro->tax1 == 18){
                            $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                            $ivaCesc++;
                        }
                        $numProd++;
                    }

                    if($totalExento == 0) $totalExento = 0;    
                    else $totalExento = number_format(round($totalExento, 2), 2 ,'.','');
                    
                    $totalGravIva = $totalGravado + $totalIVA;
                    
                    if($totalGravado == 0) $totalGravado = 0;    
                    else $totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');
                    if($valRetencion != 0) $total = $total - $valRetencion;
                    
                    if(($tipocliente==3) && ($totalGravado>=100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = '-'.$reten;
                        $total= $total-$reten;
                    }else{
                        $retencion = 0;
                    }//*/
                    #-------------------------   PAGOS
                    #   CESC 5% 
                    if($ivaCesc > 0) {
                        $totalIVA = $totalIVA - $cesc;
                        $contenidoHeader = '@ 34,64 Say "CESC 5%: $'.str_pad($cesc, 9, " ", STR_PAD_LEFT).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                    #   VALOR EN LETRAS PARTE 1
                    $numero = number_format($total, 2 ,'.','');
                    $TotalLetras = $this->valorEnLetras($numero);
                    $contenidoHeader = '@ 36,10 Say "'.substr(strtoupper($TotalLetras), 0, 63).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   SUMAS-GRAVADO
                    $StringToGv = str_pad(number_format(round($totalGravado, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ Prow(),74 Say "$'.$StringToGv.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   VALOR EN LETRAS PARTE 2
                    $contenidoHeader = '@ 37,10 Say "'.substr(strtoupper($TotalLetras), 63, 120).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   IVA
                    $StringToIVA = str_pad(number_format(round($totalIVA, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ Prow(),74 Say "$'.$StringToIVA.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   SUB TOTAL
                    //$totalGravIva = $totalGravado + $totalIVA;
                    $StringToSubTotal = str_pad(number_format(round($totalGravIva, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 39,74 Say "$'.$StringToSubTotal.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   RETENIDO
                    //$retencion = 0;
                    $StringToReten = str_pad(number_format(round($retencion, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 40,74 Say "$'.$StringToReten.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   EXENTAS
                    $StringExenta = str_pad(number_format(round($totalExento, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 41,74 Say "$'.$StringExenta.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   NO SUJETA
                    $StringNSujeta = str_pad(number_format(round(0, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 43,74 Say "$'.$StringNSujeta.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    #   TOTAL
                    $StringTotal = str_pad(number_format(round($total, 2), 2 ,'.',''), 9, " ", STR_PAD_LEFT);
                    $contenidoHeader = '@ 44,74 Say "$'.$StringTotal.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    #-----------------------------------------
                    if($efectivo == 1){
                        $contenidoProductos ='@ Prow(),Pcol() SAY CHR(27)+"p"+Chr(0)+"23"';
                        fwrite($archivoTxt, $contenidoProductos);
                        fwrite($archivoTxt, "\r\n");    
                    }
                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                
                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                
                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $docTxt = $info->descrip.$info->numero.".gox";
                    if(file_exists($docTxt)){
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($docTxt));
                        readfile($docTxt);                    
                        unlink($docTxt);
                        exit;
                    }
                }
            }
            
            function creditoFiscal($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->model('global_model');   $this->load->model('ventas_model');
                    $this->load->model('invtran_model');  $this->load->model('acs_model');
                    $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                    $this->load->model('sucursal_model'); $this->load->model('caja_model');
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    date_default_timezone_set('America/El_Salvador');
    
                    $comandosTM = new comandosTM();
    
                    foreach($informacion as $info){
                        $tipocliente = $info->idtipo;
    
                        $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                        foreach($departamentoMunicipio as $info_dm){
                            $departamento = trim($info_dm->depto);
                            $municipio = trim($info_dm->municipio);
                        }
                        $nombreCliente = $this->eliminarTildes($info->nameCliente);
                        $direccion = $this->eliminarTildes($info->direccion);
    
                    }
                   
                    $idcaja = $info->idcaja;
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
    
                    foreach($datoscaja as $caja){    
                        $printerName = $caja->notas;
                    }
                    $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                    foreach($detailPagos as $dtpagos){
                        $payment = strtoupper(substr($dtpagos->descrip, 0, 18));
                    }
                    $now = new DateTime();
                    $fechaImpre = $now->format('d/m/Y');
                    $horaImpre = $now->format('h:i');
    
                    $cmds = comandosTM::Initialize;
                    $cmds .= comandosTM::PrintSlip;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::FontSmall;
                    $cmds .= comandosTM::TextAlignLeft;
    
                    $cmds .= comandosTM::LineFeed; $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed; $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed; $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(15);
                    $cmds .= 'No.: '.$info->numero.' Orden#: '.$trannum;
                    $cmds .= comandosTM::LineFeed;
                   
                    $cmds .= $comandosTM->pad(15);
                    $cmds .= $comandosTM->padText(substr($nombreCliente, 0,39), 39, "RIGHT");
                    $cmds .= $comandosTM->pad(7);
                    $cmds .= date_format(date_create($info->fecha), 'd/m/Y');     
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(17);
                    $cmds .= $comandosTM->padText(substr($direccion, 0,37), 37, "RIGHT");
                    $cmds .= $comandosTM->pad(7);
                    $cmds .= $info->nrc;     
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(24);
                    $cmds .= $comandosTM->padText(substr($departamento, 0,30), 30, "RIGHT");
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= $info->nit;     
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(33);
                    $cmds .= $comandosTM->padText(substr($payment, 0,21), 21, "RIGHT");
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= $comandosTM->padText(substr($info->giro, 0,27), 27, "RIGHT");
    
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $maxlines = 17;
                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    
                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                    $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                    $CooNum = 13; 
    
                    foreach($productos as $pro){
                        if($numProd < $maxlines){
                            if($pro->tax1 != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "";
                                $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            }else if($pro->tax1 != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }else if($pro->tax1== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }else if($pro->tax1 == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                $vnGravada = "";
                            }
                            
                            $preciouni = $pro->precioneto;
                            $nombrepro = substr(trim($pro->modelo).' '.trim($pro->descrip), 0, 40);
                            
                            $CooNum++;
    
                            $cmds .= $comandosTM->pad(8);
                            $cmds .= $comandosTM->padText(abs($pro->cantidad), 6, "BOTH");
                            $cmds .= $comandosTM->padText($nombrepro, 41, "RIGHT");
                            $cmds .= $comandosTM->padText(number_format(round($preciouni, 4), 4 ,'.',''), 10, "LEFT");
                            $cmds .= $comandosTM->padText($vnExenta, 10, "LEFT");
                            $cmds .= $comandosTM->padText($vnGravada, 10, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                        }
                        $numProd++;
                    }
    
                    while($numProd < $maxlines){
                        $cmds .= comandosTM::LineFeed;
                        $numProd++;
                    }
    
                    //TOTALES
                    $subtotalventas = $totalExento + $totalGravado + $totalIVA;
                    if($totalExento == 0) $totalExento = "";	
                    else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                    
                    if(($tipocliente==3) && ($totalGravado>=100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = '-'.$reten;
                        $total= $total-$reten;
                    } else $retencion = 0;
                        
                    if($retencion == 0) $retencion = "";    
                    else { 
                        $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                    }
                   
                    $totalGravIva = $totalGravado + $totalIVA;
        
                    $subtotal = $totalGravado + $totalIVA;
                    $total = $subtotal;
                    if($retencion != "") {
                        $total = $subtotal - $retencion;
                        $retencion= number_format(round($retencion, 4), 4 ,'.','');
                    }
        
                    if($totalExento != "") {
                        $total = $total + $totalExento;
                    }
                    
                    $subtotal = number_format(round($subtotal, 4), 4 ,'.','');
        
                    $numero = number_format(round($total, 2), 2 ,'.','');
                    $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                    $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                    $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');
                    $subtotalventas = number_format(round($subtotalventas, 2), 2 ,'.','');
    
        
                    $total = number_format($total, 2 ,'.','');	
                    $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
    
                    $cmds .= $comandosTM->pad(14);
                    $cmds .= $comandosTM->padText(substr(strtoupper($TotalLetras), 0, 40), 40, "RIGHT");
                    $cmds .= $comandosTM->pad(22);
                    $cmds .= $comandosTM->padText("$".$totalGravado, 10, "LEFT");
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(14);
                    $cmds .= $comandosTM->padText(substr(strtoupper($TotalLetras), 40, 40), 40, "RIGHT");
                    $cmds .= $comandosTM->pad(22);
                    $cmds .= $comandosTM->padText("$".$totalIVA, 10, "LEFT");
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(76);
                    $cmds .= $comandosTM->padText("$".$totalGravIva, 10, "LEFT");
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    if($retencion != ""){
                        $cmds .= $comandosTM->pad(76);
                        $cmds .= $comandosTM->padText("-$".$retencion, 10, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }else{
                       
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;
    
    
                    if($totalExento != ""){
                        $cmds .= $comandosTM->pad(76);
                        $cmds .= $comandosTM->padText("$".$totalExento, 10, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }else{
                       
                        $cmds .= comandosTM::LineFeed;
                    }
                    
    
    
                    $cmds .= $comandosTM->pad(76);
                    $cmds .= $comandosTM->padText("$".$total, 10, "LEFT");
                    $cmds .= comandosTM::FormFeed;
    
                    $this->ventas_model->setCommandsPrint($trannum, $cmds);
                    header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                    exit;
                }
            }

            function notaDeCredito($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                    
                    foreach($informacion as $info){
                        $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                        $idClase = $info->idclase;
                        
                        foreach($departamentoMunicipio as $info_dm){
                            $departamento = trim($info_dm->depto);
                            $municipio = trim($info_dm->municipio);
                        }

                        $fechaCredito = date_format(date_create($info->fecha), 'd m y');
                        $partesFecha = explode(" ", $fechaCredito);
                        switch($partesFecha[1]){
                            case 1:
                                $mes_name = "ENERO";
                                break;
                            case 2:
                                $mes_name = "FEBRERO";
                                break;
                            case 3:
                                $mes_name = "MARZO";
                                break;
                            case 4:
                                $mes_name = "ABRIL";
                                break;
                            case 5:
                                $mes_name = "MAYO";
                                break;
                            case 6:
                                $mes_name = "JUNIO";
                                break;
                            case 7:
                                $mes_name = "JULIO";
                                break;
                            case 8:
                                $mes_name = "AGOSTO";
                                break;
                            case 9:
                                $mes_name = "SEPTIEMBRE";
                                break;
                            case 10:
                                $mes_name = "OCTUBRE";
                                break;
                            case 11:
                                $mes_name = "NOVIEMBRE";
                                break;
                            case 12:
                                $mes_name = "DICIEMBRE";
                                break;
                            default:
                                $mes_name="";
                                break;
                        }

                        $archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');
                        
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");                    
                        $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        $contenidoHeader = '@ Prow () , Pcol () SAY Chr(27)+"!"+CHR(1)';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");   
                        
                        $contenidoHeader = '@ 04,10 Say "No.'.$info->numero.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                        
                        $contenidoHeader = '@ 05,10 Say "Cliente:'.substr($info->nameCliente, 0, 40).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow (),71 Say "Fecha:'.$partesFecha[0].'/'.$partesFecha[1].'/'.$partesFecha[2].'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow ()+1,10 Say "Direccion:'.substr($info->direccion, 0, 70).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow()+1,10 Say "Departamento:'.$departamento.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow(),66 Say "NRC:'.substr($info->nrc, 0, 15).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow()+1,10 Say "Vendedor:'.substr($info->nameVendedor, 0, 25).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow(),66 Say "NIT.'.$info->nit.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow()+1,10 Say "Giro:'.substr($info->giro, 0, 45).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow (),57 Say ""';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow ()+1,60 Say ""';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }

                    $contenidoHeader = '@ Prow ()+1,05 Say "CANT"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow (),12 Say "DESCRIPCION"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow (),60 Say "UNITARIO"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow (),71 Say "EXENTAS"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow (),79 Say "GRAVADAS"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $maxlines = $this->ventas_model->getMaxLinesDoc($idClase);
                    $productos = $this->invtran_model->getDataTran100k($trannum);

                    $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                    $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                    $ivaCesc = 0; $cesc = 0; 
                    
                    foreach($productos as $pro){
                        if($pro->tax1 != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }

                        if($numProd < $maxlines){
                            $preciouni = $pro->precioneto;
                            $nombrepro = substr($pro->descrip, 0, 20).' '.substr($pro->modelo, 0, 20);
                            
                            $contenidoHeader = '@ Prow()+1,05 Say "'.abs($pro->cantidad).'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $contenidoHeader = '@ Prow(),12 Say "'.$nombrepro.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $StringPreUni = str_pad(number_format(round($preciouni, 4), 4 ,'.',''), 8, " ", STR_PAD_LEFT);
                            
                            $contenidoHeader = '@ Prow(),60 Say "'.$StringPreUni.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $StringVnEx = str_pad($vnExenta, 8, " ", STR_PAD_LEFT);

                            $contenidoHeader = '@ Prow(),71 Say "'.$StringVnEx.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $StringVnGr = str_pad($vnGravada, 8, " ", STR_PAD_LEFT);

                            $contenidoHeader = '@ Prow(),79 Say "'.$StringVnGr.'"';
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                        }

                        if($pro->tax1 == 18){
                            $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                            $ivaCesc++;
                        }

                        $numProd++;
                    }

                    if($totalExento == 0){
                        $totalExento = "";
                    }else{
                        $totalExento = number_format(round($totalExento, 2), 2 ,'.','');
                    }
                    
                    if($totalGravado == 0){
                        $totalGravado = "";
                    }else{
                        $totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');
                    }

                    $totalGravIva = $totalGravado + $totalIVA;				
                    $numero = number_format($total, 2 ,'.','');
                    $TotalLetras = $this->valorEnLetras($numero);
                
                    $contenidoHeader = '@ Prow()+2,07 Say "Son:'.strtoupper($TotalLetras).'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $StringToGv = "-".str_pad(number_format(round($totalGravado, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT);

                    $contenidoHeader = '@ Prow()+1,65 Say "Gravadas:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),79 Say "$'.$StringToGv.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    if($ivaCesc > 0){
                        $totalIVA = $totalIVA - $cesc;
                    }

                    $StringToIVA = "-".str_pad(number_format(round($totalIVA, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT);

                    $contenidoHeader = '@ Prow()+1,65 Say "Iva:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $contenidoHeader = '@ Prow(),79 Say "$'.$StringToIVA.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    if($ivaCesc > 0){    
                        $StringCesc = str_pad(number_format(round($cesc, 2), 2 , '.',''), 7, " ", STR_PAD_LEFT);
                        
                        $contenidoHeader = '@ Prow()+1,65 Say "CESC"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $contenidoHeader = '@ Prow(),79 Say "$'.number_format(round($StringCesc, 2), 2 ,'.','').'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }

                    $ventaTotal = $numero + $totalExento;
                    
                    $StringTotal = "-".str_pad(number_format(round($ventaTotal, 2), 2 ,'.',''), 7, " ", STR_PAD_LEFT);

                    $contenidoHeader = '@ Prow()+1,65 Say "Total:"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoHeader = '@ Prow(),79 Say "$'.$StringTotal.'"';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    if($efectivo == 1){
                        $contenidoProductos ='@ Prow(),Pcol() SAY CHR(27)+"p"+Chr(0)+"23"';
                        fwrite($archivoTxt, $contenidoProductos);
                        fwrite($archivoTxt, "\r\n");    
                    }

                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                
                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");                
                    $contenidoHeader = '@ Prow()+1,76 Say " "';
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    $docTxt = $info->descrip.$info->numero.".gox";
                    if(file_exists($docTxt)){
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($docTxt));
                        readfile($docTxt);                    
                        unlink($docTxt);
                        exit;
                    }
                }
            }

            
    

        //-
        
        //Formatos de Reportes-----------------------------------------------------------------------
            function reporteVentasDiarias($idcentro, $idcaja, $fechaini, $fechafin){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->load->library('Pdf');

                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                    $pdf->SetCreator(PDF_CREATOR);

                    $pdf->SetAuthor('Versanet Sistemas');

                    $pdf->SetTitle('Ventas Por Periodo');

                    $pdf->SetSubject('Ventas Por Periodo');

                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

                    $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);

                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 

                    $pdf->setFontSubsetting(true);

                    $pdf->setPageOrientation('P');

                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    $pdf->SetMargins(4, 40, 4, 0);

                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

                    $pdf->SetFooterMargin(0, 0, 0, 0);

                    $this->load->model('ventas_model');

                    $this->load->model('sucursal_model');

                    $this->load->model('invtran_model');

                    $this->load->model('caja_model');

                    $funcion = $this->uri->segment(3);

                    $this->load->model('global_model');

                    $nombreFormato = $this->global_model->getFormatosNombre($funcion);

                    

                    $this->load->model('pedclientes_model');

                    $nameImagen = $this->pedclientes_model->getnameImg();



                    

                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    $datoscaja = $this->caja_model->getNameCaja($idcaja);

                    foreach($datoscaja as $caja){

                        $namecaja = $caja->descrip;

                        $numcaja = $caja->resolucion;

                    }

                    

                    $tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);

                    $documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);

                    $facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);

                    $cnt = 0;

                    foreach($tipospagos as $tip){

                        $valpag[$tip->cajclase] = 0;

                        $valpagG[$tip->cajclase] = 0;

                        $cnt++;

                    }

                    $header = '

                    <table style="width:100%;">

                        <tr>

                            <td style="padding:0px;margin:0px;width:30%;"><img style="text-align:center; width:210px; height:95px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>

                            <td style="padding:0px;margin:0px;width:70%;padding:0px;margin:0px;">

                                <label style="font-size:18px;font-weight:bold;text-align:right; margin:0px;padding:0px;"><br>'.trim($this->session->userdata('descrip')).'</label>

                                <br><label style="text-align:right; font-size:15px;margin:0px;padding:0px;">'.strtoupper($nombreFormato).'<br>'.strtoupper($namecentro).' - '.strtoupper($namecaja).'<br> PERIODO: '.date_format(date_create($fechaini), 'd/m/Y').' - '.date_format(date_create($fechafin), 'd/m/Y').'</label>        

                            </td>

                        </tr>

                    </table>';

                

                    $pdf->setHtmlHeader($header);

                    $pdf->setPrintHeader(true);

                    $fecha = new DateTime();

                    $footer =  '<br><br><br><br><br><br>

                    <table style="padding:0px; margin:0px;">

                        <tbody style="padding:0px; margin:0px;">

                            <tr style="padding:0px; margin:0px;">

                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>

                                <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>

                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>

                            </tr>

                        </tbody>

                        </table>';

                    $pdf->setHtmlFooter($footer);

                    $pdf->setPrintFooter(true);

                    $pdf->addPage('P', 'LETTER' );

                    $titulo ='<table>

                        <thead>

                            <tr style="border-bottom: 1px solid black;">

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 7%">N°</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6%">Fecha</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 20%">Nombre de Cliente</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 15%">Nombre de Vendedor</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 8%">Exento</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 8%">Gravado</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 8%">IVA</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 8%">Total</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 15%">Forma de Pago</th></tr>

                                </thead>';

                    $titulo .='<tbody>';

                    $totalGeneral = 0;

                    $totalExento = 0;

                    $totalGravado = 0;

                    $totalIva = 0;

                    $totalDocs = 0;

                    foreach($documentos as $docs){

                        

                        $numdoc = 0;

                        $subtotal=0;

                        $subtotalexento = 0;

                        $subtotalgravado = 0;

                        $subtotaliva = 0;

                        $titulo .= '<tr><th colspan="10"><br></th></tr><tr><th colspan="10" style="font-size:11px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.strtoupper($docs->tipoDoc).'</th></tr>';

                        foreach($facturas as $fact){

                            if($docs->tipoDoc == $fact->tipodoc){

                                $numdoc++;

                                $totalDocs++;

                                $exento = 0;

                                $gravado = 0;

                                $iva = 0;

                                if($fact->exento==1){

                                    $exento = $fact->valventan;

                                }else{

                                    $gravado = ($fact->valtax1 / 0.13);

                                    $exento = $fact->valventan-$gravado;

                                }

                                $iva = $fact->valtax1;

                                $subtotal += $gravado+$exento+$iva;

                                $subtotalexento += $exento;

                                $subtotalgravado += $gravado;

                                $subtotaliva += $iva;

                                $date = date_format(date_create($fact->fecha),'d/m/Y');

                                $nameCliente = substr($fact->namecliente, 0, 28);

                                $nameVendedor = substr($fact->namevendedor, 0, 28);

                                $cadena_pago = "";

                                $cadena_pago = $this->ventas_model->getFormaDePagoCreditoTrannum($fact->trannum);

                                

                                if($cadena_pago==0){

                                    $pagos = $this->ventas_model->getPagosDoc($fact->trannum);

                                    if($pagos!=false){

                                        foreach($pagos as $money){

                                            $cadena_pago .= $money->descrip.",";

                                        }

                                        $cadena_pago = substr($cadena_pago, 0, -1);

                                    }

                                    $cadena_pago = substr($cadena_pago, 0, 25);

                                }else{

                                    $cadena_pago = substr($cadena_pago, 0, 25);

                                }

                                

                                foreach($tipospagos as $tip){

                                    $pagos = $this->ventas_model->getDatosPagosVentasPago($fact->trannum,$tip->cajclase);

                                    if($pagos!=false){

                                        foreach($pagos as $money){

                                            if($fact->inopera==1){

                                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));

                                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));

                                            }else{

                                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));

                                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));

                                            }

                                        }

                                    }

                                }

                                

                                $titulo .= '

                                <tr>

                                    <td style="font-size:7px; text-align:left; font-weight: normal; width: 7%">'.$fact->numeroserie.'</td>

                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 6%">'.$date.'</td>

                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$fact->hora.'</td>

                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 20%">'.$nameCliente.'</td>

                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 15%">'.$nameVendedor.'</td>

                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 8%">$'.number_format(round($exento, 2),2, '.', ',').'</td>

                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 8%">$'.number_format(round($gravado, 2),2, '.', ',').'</td>

                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 8%">$'.number_format(round($iva, 2),2, '.', ',').'</td>

                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 8%">$'.number_format(round($gravado+$iva+$exento, 2),2, '.', ',').'</td>

                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 15%">'.$cadena_pago.'</td></tr>';

                            }

                        }



                        $titulo .= '

                        <tr>

                            <th style="font-size:9px; text-align:left; border-top: 1px solid black; width:7%; font-weight: bold;">('.$numdoc.')</th>

                            <th style="font-size:9px; text-align:right; border-top: 1px solid black; width:46%; font-weight: bold;">Sub-Total '.($docs->tipoDoc).':</th>

                            <th style="font-size:9px; text-align:right; border-top: 1px solid black; width:8%; font-weight: bold;">$'.number_format(round($subtotalexento, 2),2).'</th>

                            <th style="font-size:9px; text-align:right; border-top: 1px solid black; width:8%; font-weight: bold;">$'.number_format(round($subtotalgravado, 2),2).'</th>

                            <th style="font-size:9px; text-align:right; border-top: 1px solid black; width:8%; font-weight: bold;">$'.number_format(round($subtotaliva, 2),2).'</th>

                            <th style="font-size:9px; text-align:right; border-top: 1px solid black; width:8%; font-weight: bold;">$'.number_format(round($subtotal, 2),2).'</th>

                            <th style="font-size:9px; text-align:right; border-top: 1px solid black; width:15%; font-weight: bold;"></th></tr>';

                        $numdoc=0;  

                        $totalGeneral += $subtotal;

                        $totalExento += $subtotalexento;

                        $totalGravado += $subtotalgravado;

                        $totalIva += $subtotaliva;

                    }

                    

                    $titulo .= '</tbody></table>';

                    $titulo .= '<br><br>';

                

                    $titulo .='<table>

                    <thead>

                        <tr style="border-bottom: 1px solid black;">

                        <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>

                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>

                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>

                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>

                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>

                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>

                    </thead><tbody>';

                    $titulo.='<tr style="border-bottom: 1px solid black;">

                        <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>

                        <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;">'.$totalDocs.'</th>

                        <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">$'.number_format(round($totalExento, 2),2).'</th>

                        <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">$'.number_format(round($totalGravado, 2),2).'</th>

                        <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">$'.number_format(round($totalIva, 2),2).'</th>

                        <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">$'.number_format(round($totalGeneral, 2),2).'</th>

                    </tr>';

                    $titulo .= '</tbody></table>';

                    

                    $titulo .='<br><br><table>

                    <thead>

                    <tr style="border-bottom: 1px solid black;">

                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>

                    <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>

                    <tr style="border-bottom: 1px solid black;">

                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';            

                

                    $pagos_credito = $this->ventas_model->getFormaDePagoCreditoPeriodo('VN', $idcentro, $idcaja, $fechaini, $fechafin);

                    $cant_fp = 1;

                    if($pagos_credito!=false){

                        foreach($pagos_credito as $tip){

                            $cant_fp++;

                        }

                    }

                    $per = 75/$cant_fp;

                    if($pagos_credito!=false){

                        foreach($pagos_credito as $pag){

                            $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$pag->descrip.'</th>';



                        }

                    }

                    $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold;background-color:#C2CBCE;width:'.$per.'%;">Sumas</th></tr></thead><tbody>';      



                    $titulo.='<tr style="border-bottom: 1px solid black;">

                    <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';

                    $total_ing_sum=0;

                    

                    if($pagos_credito!=false){

                        foreach($pagos_credito as $pag){

                            $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">$'.number_format(round($pag->valor, 2),2).'</td>';

                            $total_ing_sum+=round($pag->valor, 2);

                        }

                    }

                    

                    $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';



                    

                

                    $pdf->writeHTML($titulo, true, false, true, false, '');

                    $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");

                    $pdf->Output($nombre_archivo, 'I');

                }

            }
            
            function comp_inv($tipopro,$idcentro,$aniomes){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->load->library('Pdf');

                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                    $pdf->SetCreator(PDF_CREATOR);

                    $pdf->SetAuthor('Versanet Sistemas');

                    $pdf->SetTitle('Comprobación de Inventario');

                    $pdf->SetSubject('Comprobación de Inventario');

                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

                    $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);

                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 

                    $pdf->setFontSubsetting(true);

                    $pdf->setPageOrientation('P');

                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    $pdf->SetMargins(3, 30, 3, 0);

                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);

                    $this->load->model('sucursal_model');

                    $this->load->model('invtran_model');

                    

                    $fecha = explode("_", $aniomes);

                    $anio = $fecha[0];

                    $mes = $fecha[1];

                    $mes_letras = "";

                    switch(round($mes)){

                            case 1:

                                $mes_letras  = "Enero";

                                break;

                            case 2:

                                $mes_letras  = "Febrero";

                                break;

                            case 3:

                                $mes_letras  = "Marzo";

                                break;

                            case 4:

                                $mes_letras  = "Abril";

                                break;

                            case 5:

                                $mes_letras  = "Mayo";

                                break;

                            case 6:

                                $mes_letras  = "Junio";

                                break;

                            case 7:

                                $mes_letras  = "Julio";

                                break;

                            case 8:

                                $mes_letras  = "Agosto";

                                break;

                            case 9:

                                $mes_letras  = "Septiembre";

                                break;

                            case 10:

                                $mes_letras  = "Octubre";

                                break;

                            case 11:

                                $mes_letras  = "Noviembre";

                                break;

                            case 12:

                                $mes_letras  = "Diciembre";

                                break;

                            default:

                                $mes_letras  = "-";

                                break;

                        }

                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    

                    $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).'<br>'.strtoupper($mes_letras).'/'.$anio.'</label></center>';

                

                    $pdf->setHtmlHeader($header);

                    $pdf->setPrintHeader(true);

                    $fecha = new DateTime();

                    $footer =  '<br><br><br><br><br><br>

                    <table style="padding:0px; margin:0px;">

                        <tbody style="padding:0px; margin:0px;">

                            <tr style="padding:0px; margin:0px;">

                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>

                                <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>

                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>

                            </tr>

                        </tbody>

                        </table>';

                    $pdf->setHtmlFooter($footer);

                    $pdf->setPrintFooter(true);

                    $pdf->addPage('P', 'LETTER' );

                    $titulo ='<table>

                    <thead>

                        <tr style="border-bottom: 1px solid black;">

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Código</th>

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:left; font-weight: bold;">Descripción</th>

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">UM</th>

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Saldo Inicial</th>

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Compras</th>

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Ajustes +/-</th>

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Inventario Disponible</th>

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Venta</th>

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Inventario Final</th>

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:right; font-weight: bold;">Costo Unitario</th>

                        <th style="border-bottom: 1px solid black;font-size:10px; text-align:right; font-weight: bold;">Costo Total</th>';

                    $titulo .='</tr>

                    </thead>

                    <tbody>';

                    $info = $this->invtran_model->getComprobacionInv($tipopro,$idcentro,$anio,$mes);

                    $categorias = $this->invtran_model->getCategoriasInv($tipopro,$idcentro,$anio,$mes);

                    $lineas = $this->invtran_model->getLineasInv($tipopro,$idcentro,$anio,$mes);

                    $tot_saldo_lineas = 0;

                    $tot_compras_lineas = 0;

                    $tot_ajustes_lineas = 0;

                    $tot_invdisponible_lineas = 0;

                    $tot_venta_lineas = 0;

                    $tot_invfinal_lineas = 0;

                    $tot_costouni_lineas = 0;

                    $tot_costotot_lineas = 0;

                        

                    foreach($categorias as $cat){

                        $sum_saldo_lineas = 0;

                        $sum_compras_lineas = 0;

                        $sum_ajustes_lineas = 0;

                        $sum_invdisponible_lineas = 0;

                        $sum_venta_lineas = 0;

                        $sum_invfinal_lineas = 0;

                        $sum_costouni_lineas = 0;

                        $sum_costotot_lineas = 0;

                        $titulo .='

                        <tr>

                        <td colspan="11" style="border-bottom: 1px solid #0B2E59;font-size:12px; text-align:left; font-weight: bold;color:#0B2E59;"><br><br>'.$cat->departamento.'</td>

                        </tr>';

                        foreach($lineas as $lin){

                            $saldo_lineas = 0;

                            $compras_lineas = 0;

                            $ajustes_lineas = 0;

                            $invdisponible_lineas = 0;

                            $venta_lineas = 0;

                            $invfinal_lineas = 0;

                            $costouni_lineas = 0;

                            $costotot_lineas = 0;

                            if($lin->iddepartamento==$cat->iddepartamento){

                                $titulo .='

                                <tr>

                                    <td colspan="11" style="border-bottom: 1px solid #0B2E59;font-size:12px; text-align:left; font-weight: normal;color:#0B2E59;"><br>&nbsp;&nbsp;&nbsp;'.$lin->linea.'</td>

                                </tr>';   

                                foreach($info as $in){

                                    if($in->idlinea==$lin->idlinea){

                                        $inv_disponible = $in->saldoinicial+$in->compras+$in->ajustes;

                                        $inv_actual = $in->saldoinicial+$in->compras+$in->ajustes+$in->ventas;

                                        $costo_total = $in->costosaldoinicial + $in->costocompras + $in->costoajustes + $in->costoventas;

                                        if($inv_actual!=0){

                                            $costo_unitario = $costo_total / $inv_actual;

                                        }else{

                                            $costo_unitario=0;

                                        }

                                        $titulo .='

                                        <tr>

                                        <td style="font-size:10px; text-align:center; font-weight: normal;">'.$in->idproducto.'</td>

                                        <td style="font-size:10px; text-align:left; font-weight: normal;">'.$in->producto.'</td>

                                        <td style="font-size:10px; text-align:center; font-weight: normal;">'.$in->um.'</td>

                                        <td style="font-size:10px; text-align:center; font-weight: normal;">'.round($in->saldoinicial).'</td>

                                        <td style="font-size:10px; text-align:center; font-weight: normal;">'.round($in->compras).'</td>

                                        <td style="font-size:10px; text-align:center; font-weight: normal;">'.round($in->ajustes).'</td>

                                        <td style="font-size:10px; text-align:center; font-weight: normal;">'.round($inv_disponible).'</td>

                                        <td style="font-size:10px; text-align:center; font-weight: normal;">'.round(abs($in->ventas)).'</td>

                                        <td style="font-size:10px; text-align:center; font-weight: normal;">'.round($inv_actual).'</td>

                                        <td style="font-size:10px; text-align:right; font-weight: normal;">$'.number_format($costo_unitario, 2, '.', '').'</td>

                                        <td style="font-size:10px; text-align:right; font-weight: normal;">$'.number_format($costo_total, 2, '.', '').'</td></tr>';     

                                        $saldo_lineas+=round($in->saldoinicial);

                                        $compras_lineas+=round($in->compras);

                                        $ajustes_lineas+=round($in->ajustes);

                                        $invdisponible_lineas+=round($inv_disponible);

                                        $venta_lineas+=round(abs($in->ventas));

                                        $invfinal_lineas+=round($inv_actual);

                                        $costouni_lineas+=$costo_unitario;

                                        $costotot_lineas+=$costo_total;

                                        

                                        $sum_saldo_lineas+=round($in->saldoinicial);

                                        $sum_compras_lineas+=round($in->compras);

                                        $sum_ajustes_lineas+=round($in->ajustes);

                                        $sum_invdisponible_lineas+=round($inv_disponible);

                                        $sum_venta_lineas+=round(abs($in->ventas));

                                        $sum_invfinal_lineas+=round($inv_actual);

                                        $sum_costouni_lineas+=$costo_unitario;

                                        $sum_costotot_lineas+=$costo_total;

                                        

                                        $tot_saldo_lineas+=round($in->saldoinicial);

                                        $tot_compras_lineas+=round($in->compras);

                                        $tot_ajustes_lineas+=round($in->ajustes);

                                        $tot_invdisponible_lineas+=round($inv_disponible);

                                        $tot_venta_lineas+=round(abs($in->ventas));

                                        $tot_invfinal_lineas+=round($inv_actual);

                                        $tot_costouni_lineas+=$costo_unitario;

                                        $tot_costotot_lineas+=$costo_total;

                                    }

                                }

                                $titulo .='

                                        <tr>

                                        <td colspan="3" style="font-size:10px; text-align:right; font-weight: bold;">Sub Total '.$lin->linea.'&nbsp;&nbsp;&nbsp;</td>

                                        <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($saldo_lineas).'</td>

                                        <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($compras_lineas).'</td>

                                        <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($ajustes_lineas).'</td>

                                        <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($invdisponible_lineas).'</td>

                                        <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($venta_lineas).'</td>

                                        <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($invfinal_lineas).'</td>

                                        <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:right; font-weight: bold;">$'.number_format($costouni_lineas, 2, '.', '').'</td>

                                        <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:right; font-weight: bold;">$'.number_format($costotot_lineas, 2, '.', '').'</td></tr>';     

                            }

                        }

                        $titulo .='

                        <tr>

                        <td colspan="3" style="font-size:12px; text-align:right; font-weight: bold;color:#0B2E59;">Sub Total '.$cat->departamento.'&nbsp;&nbsp;&nbsp;</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_saldo_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_compras_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_ajustes_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_invdisponible_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_venta_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_invfinal_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:right; font-weight: bold;color:#0B2E59;">$'.number_format($sum_costouni_lineas, 2, '.', '').'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:right; font-weight: bold;color:#0B2E59;">$'.number_format($sum_costotot_lineas, 2, '.', '').'</td></tr>'; 

                

                    

                    }   

                    $titulo .='

                        <tr><td colspan="11"></td></tr>

                        <tr>

                        <td colspan="3" style="border-top: 1px solid black;font-size:12px; text-align:right; font-weight: bold;">TOTALES &nbsp;&nbsp;&nbsp;</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_saldo_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_compras_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_ajustes_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_invdisponible_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_venta_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_invfinal_lineas).'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:right; font-weight: bold;">$'.number_format($tot_costouni_lineas, 2, '.', '').'</td>

                        <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:right; font-weight: bold;">$'.number_format($tot_costotot_lineas, 2, '.', '').'</td></tr>'; 

                

                    $titulo.='</tbody></table>';

                            

                    $pdf->writeHTML($titulo, true, false, true, false, '');

                    $nombre_archivo = utf8_decode("Comprobacion_Inventario.pdf");

                    $pdf->Output($nombre_archivo, 'I');

                }

            }

            function agrupacion_productos($tipopro){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->db->query('SET SQL_BIG_SELECTS=1'); 

                    ini_set('memory_limit', '9999M');

                    ini_set('max_allowed_packet', '9999M');

                    ini_set('max_execution_time', 0);

                    set_time_limit(0);

                    

                    $this->load->library('Pdf');

                    $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);

                    $pdf->SetCreator(PDF_CREATOR);

                    $pdf->SetAuthor('Versanet Sistemas');

                    $pdf->SetTitle('Agrupación de Productos');

                    $pdf->SetSubject('Agrupación de Productos');

                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

                    $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);

                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 

                    $pdf->setFontSubsetting(true);

                    $pdf->setPageOrientation('L');

                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);

                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);

                    $this->load->model('sucursal_model');

                    $this->load->model('producto_model');

                    $this->load->model('catalog_model');

                    $function = $this->uri->segment(3);

                    $this->load->model("global_model");

                    $nombre_doc = $this->global_model->getFormatosNombre($function);

                    $tipoproduct = $this->producto_model->getDescripTipo($tipopro);

                    $header = '<center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;font-weight:bold;">'.$nombre_doc.'</label><br><label style="text-align:center; font-size:15px;">'.$tipoproduct.'</label></center>';

                    $header .= '<hr style="border-color:#031634;background-color:#031634;color:#031634;height:2px;"></hr><br>';

                    $pdf->setHtmlHeader($header);

                    $pdf->setPrintHeader(true);

                    $fecha = new DateTime();

                    $footer =  '<br><br><br><br><br><br>

                    <table style="padding:0px; margin:0px;">

                        <tbody style="padding:0px; margin:0px;">

                            <tr style="padding:0px; margin:0px;">

                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>

                                <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>

                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>

                            </tr>

                        </tbody>

                        </table>';

                    $pdf->setHtmlFooter($footer);

                    $pdf->setPrintFooter(true);

                    $departamentos_list = $this->catalog_model->getDepartamentosTipo($tipopro);

                    $titulo='';

                    $row_cant = 0;

                    $row1 = "";

                    $row2 = "";

                    $row3 = "";

                    $pdf->AddPage('L', 'LETTER');



                    foreach($departamentos_list as $dep){

                        if($row_cant>=0 && $row_cant<=40){

                            if($row_cant==0){

                                $row1 .='<tr><th style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;">'.$dep->descrip.' ('.$dep->cantidad.')</th></tr>';

                                $row_cant++;

                            }else{

                                $row1 .='<tr><th style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;"><br>'.$dep->descrip.' ('.$dep->cantidad.')</th></tr>';

                                $row_cant++;

                            }

                            

                        }

                        else if($row_cant>=41 && $row_cant<=80){

                            $row2 .='<tr><th style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;"><br>'.$dep->descrip.' ('.$dep->cantidad.')</th></tr>';

                            $row_cant++;

                        }

                        else if($row_cant>=81 && $row_cant<=120){

                            $row3 .='<tr><th style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;"><br>'.$dep->descrip.' ('.$dep->cantidad.')</th></tr>';

                            $row_cant++;

                            if($row_cant==120){

                                $titulo .='<table style="width:100%; border-collapse: collapse;"><tr><td style="width:33.33%;"><table>'.$row1.'</table></td><td style="width:33.33%;"><table>'.$row2.'</table></td><td style="width:33.33%;"><table>'.$row3.'</table></td></tr></table>';

                                $row1 = '';

                                $row2 = '';

                                $row3 = '';

                                $row_cant = 0;

                            }

                        }

                        $lineas_list = $this->catalog_model->getLineasTipo($dep->idcatalogo);

                        foreach($lineas_list as $lin){

                            if($lin->idnivel1==$dep->idcatalogo){

                                if($row_cant>=0 && $row_cant<=40){

                                    $row1 .='<tr>

                                            <td style="width:5%; text-align:right;  font-size:11px;"></td>

                                            <td style="width:95%; text-align:left;  font-size:11px;">'.$lin->descrip.' <strong>('.$lin->cantidad.')</strong></td>

                                            </tr>';

                                    $row_cant++;

                                }

                                else if($row_cant>=41 && $row_cant<=80){

                                    $row2 .='<tr>

                                            <td style="width:5%; text-align:right;  font-size:11px;"></td>

                                            <td style="width:95%; text-align:left;  font-size:11px;">'.$lin->descrip.' <strong>('.$lin->cantidad.')</strong></td>

                                            </tr>';

                                    $row_cant++;

                                }

                                else if($row_cant>=81 && $row_cant<=120){

                                    $row3 .='<tr>

                                        <td style="width:5%; text-align:right;  font-size:11px;"></td>

                                        <td style="width:95%; text-align:left;  font-size:11px;">'.$lin->descrip.' <strong>('.$lin->cantidad.')</strong></td>

                                        </tr>';

                                    $row_cant++;

                                    if($row_cant==120){

                                        $titulo .='<table  style="width:100%;  border-collapse: collapse;"><tr><td style="width:33.33%;"><table>'.$row1.'</table></td><td style="width:33.33%;"><table>'.$row2.'</table></td><td style="width:33.33%;"><table>'.$row3.'</table></td></tr></table>';

                                        $row1 = '';

                                        $row2 = '';

                                        $row3 = '';

                                        $row_cant = 0;

                                    }

                                }

                            }

                        }

                    }

                    $titulo .='<table  style="width:100%;  border-collapse: collapse;"><tr><td style="width:33.33%;"><table>'.$row1.'</table></td><td style="width:33.33%;"><table>'.$row2.'</table></td><td style="width:33.33%;"><table>'.$row3.'</table></td></tr></table>';

                    $pdf->writeHTML($titulo, true, false, true, false, '');

                    $nombre_archivo = utf8_decode("agrupacion_productos.pdf");

                    $pdf->Output($nombre_archivo, 'I');

                }

            }

            function book01($fechaini, $fechafin, $idcentro, $formatos){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->load->library('Pdf');

                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);  



                    $pdf->SetCreator(PDF_CREATOR);

                    $pdf->SetAuthor('Versanet Sistemas');

                    $pdf->SetTitle('Libro de Ventas Consumidor Final');

                    $pdf->SetSubject('Libro de Ventas Consumidor Final');

                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');



                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config

                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config

                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config

                

                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);

                    $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM );

                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);

                    

                    $fecha = new DateTime();

                    

                    $footer =  '<br><br><br><br><br><br>

                    <table style="padding:0px; margin:0px;">

                        <tbody style="padding:0px; margin:0px;">

                            <tr style="padding:0px; margin:0px;">

                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>

                                <th style="font-size:10px; text-align:center; width: 40%"></th>

                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>

                            </tr>

                        </tbody>

                        </table>';

                

                    $pdf->setHtmlFooter($footer);

                    $pdf->setPrintFooter(true);

                    $this->load->model('global_model');

                    $this->load->model('iva_model');

                    $function = $this->uri->segment(3);

                    $nombreFormato = $this->global_model->getFormatosNombre($function);

                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);

                    $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);

                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);

                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);

                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);

                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);

                    

                    $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);

                    if($nombre_contador==""){

                        $nombre_contador="NO ASIGNADO";

                    }

                    $mes = date_format(date_create($fechaini),'n');

                    $anio = date_format(date_create($fechaini),'Y');

                    switch($mes){

                        case 1:

                            $mes_name = "ENERO";

                            break;

                        case 2:

                            $mes_name = "FEBRERO";

                            break;

                        case 3:

                            $mes_name = "MARZO";

                            break;

                        case 4:

                            $mes_name = "ABRIL";

                            break;

                        case 5:

                            $mes_name = "MAYO";

                            break;

                        case 6:

                            $mes_name = "JUNIO";

                            break;

                        case 7:

                            $mes_name = "JULIO";

                            break;

                        case 8:

                            $mes_name = "AGOSTO";

                            break;

                        case 9:

                            $mes_name = "SEPTIEMBRE";

                            break;

                        case 10:

                            $mes_name = "OCTUBRE";

                            break;

                        case 11:

                            $mes_name = "NOVIEMBRE";

                            break;

                        case 12:

                            $mes_name = "DICIEMBRE";

                            break;

                        default:

                            $mes_name="";

                            break;

                    }

                    

                    

                    

                    

                    $header = '

                    <table>

                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>

                        <tr><td style="text-align:right;font-size:15px;width:40%;">N.I.T.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td><td style="width:20%;"></td><td style="text-align:left;font-size:15px;width:40%;">N.R.C.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td></tr>

                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>

                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>

                </table>';

                    

                    $pdf->setHtmlHeader($header);

                    $pdf->setPrintHeader(true);

                    

                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

                    $pdf->setFontSubsetting(true);

                    $pdf->setPageOrientation('Portrait');

                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    $this->load->model('global_model');

                    

                    $pdf->addPage('P', 'LETTER');

                    $estructura = '<br><br><br><table>';

                    $estructura .= '<thead><tr>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Día</th>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:21%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Tipo de Operación</th>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:12%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Del Número</th>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:12%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Al Número</th>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:50%; font-weight:bold; text-align:center; font-size:12px;" colspan="5">VENTAS</th>

                    </tr>

                    <tr>

                        <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">No Sujetas</th>

                        <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Exentas</th>

                        <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Gravadas Locales</th>

                        <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:10.5px;">Exportaciones</th>

                        <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Totales</th>

                    </tr></thead>

                    <tbody></tbody>';

                    $sum_exento=0;

                    $sum_gravado=0;

                    $sum_total=0;

                    $ventas = $this->iva_model->getVentasReporte($fechaini, $fechafin, $idcentro, $formatos);

                    $exento_sum_idclase=0;

                    $gravado_sum_idclase=0;

                    

                    $fecha_ini=0;

                    $fecha_fin=0;

                    $idclase_ini=0;

                    $numserie_ini="";

                    $numserie_fin="";

                    $cant_docs = 0;

                    $numserie_ante = "";

                    $tipo_doc_ant = "";

                    

                    foreach($ventas as $vn){

                        

                        $exento=0;

                        $gravado=0;

                        if($vn->exento==1){

                            $exento = $vn->valventan;

                        }else{

                            $gravado = $vn->valventan+$vn->valtax1;

                        }

                        

                        $sum_exento+=$exento;

                        $sum_gravado+=$gravado;

                        $sum_total+= $exento+$gravado;

                        $dia = date_format(date_create($vn->fecha),'d');

                        

                        if($cant_docs==0){

                            $fecha_ini = $dia;

                            $idclase_ini = $vn->idclase;

                            $numserie_ini = $vn->numeroserie;

                            $numserie_ante = $vn->numeroserie;

                            $exento_sum_idclase = 0;

                            $gravado_sum_idclase = 0;

                            $exento_sum_idclase += $exento;

                            $gravado_sum_idclase += $gravado;

                            $numserie_ante = $vn->numeroserie;

                            $tipo_doc_ant = $vn->tipodoc;

                        }else{

                            if($fecha_ini!=$dia || $idclase_ini!=$vn->idclase){

                                $estructura.='<tr>

                                    <td style="width:5%;text-align:center; font-size:9px;">'.$fecha_ini.'</td>

                                    <td style="width:21%;text-align:left; font-size:9px;">'.strtoupper($tipo_doc_ant).'</td>

                                    <td style="width:12%;text-align:right; font-size:9px;">'.$numserie_ini.'</td>

                                    <td style="width:12%;text-align:right; font-size:9px;">'.$numserie_ante.'</td>

                                    <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>

                                    <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento_sum_idclase, 2),2).'</td>

                                    <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($gravado_sum_idclase, 2),2).'</td>

                                    <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>

                                    <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento_sum_idclase+$gravado_sum_idclase, 2),2).'</td>

                                </tr>';

                                $fecha_ini = $dia;

                                $idclase_ini = $vn->idclase;

                                $numserie_ini = $vn->numeroserie;

                                $numserie_ante = $vn->numeroserie;

                                $tipo_doc_ant = $vn->tipodoc;

                                $cant_docs==0;

                                $exento_sum_idclase = 0;

                                $gravado_sum_idclase = 0;

                                $exento_sum_idclase += $exento;

                                $gravado_sum_idclase += $gravado;

                            }else{

                                $exento_sum_idclase += $exento;

                                $gravado_sum_idclase += $gravado;

                                $numserie_ante = $vn->numeroserie;

                                $tipo_doc_ant = $vn->tipodoc;

                            }

                        }

                        $cant_docs++;

                    }

                    $estructura.='<tr>

                        <td style="width:5%;text-align:center; font-size:9px;">'.$fecha_ini.'</td>

                        <td style="width:21%;text-align:left; font-size:9px;">'.strtoupper($tipo_doc_ant).'</td>

                        <td style="width:12%;text-align:right; font-size:9px;">'.$numserie_ini.'</td>

                        <td style="width:12%;text-align:right; font-size:9px;">'.$numserie_ante.'</td>

                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>

                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento_sum_idclase, 2),2).'</td>

                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($gravado_sum_idclase, 2),2).'</td>

                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>

                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento_sum_idclase+$gravado_sum_idclase, 2),2).'</td>

                    </tr>';

                    $estructura.='<tr>

                            <td style="width:5%;text-align:center; font-size:9px;"></td>

                            <td style="width:21%;text-align:left; font-size:9px;"></td>

                            <td style="width:12%;text-align:center; font-size:9px;"></td>

                            <td style="width:12%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>

                            <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;"></td>

                            <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>

                            <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>

                            <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;"></td>

                            <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>

                        </tr><tr><td colspan="9"><br><br><br></td></tr>';

                    

                    $estructura.='<tr>

                        <td colspan="3" style="border-bottom:1px solid #333333;"></td>

                        <td colspan="6"></td>

                    </tr><tr>

                        <td colspan="3" style="text-align:center;font-size:12px;">'.$nombre_contador.'</td>

                        <td colspan="6"></td>

                    </tr><tr>

                        <td colspan="3" style="text-align:center;font-size:11px;">Contador</td>

                        <td colspan="6"></td>

                    </tr>';

                    

                    $estructura.='</table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);

                    $nombre_archivo = utf8_decode("$nombreFormato.pdf");

                    $pdf->Output($nombre_archivo, 'I');

                }

            }
            
            function book02($fechaini, $fechafin, $idcentro, $formatos){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->load->library('Pdf');

                    $pdf = new Pdf('L', 'mm', 'A4', true, 'UTF-8', false);  



                    $pdf->SetCreator(PDF_CREATOR);

                    $pdf->SetAuthor('Versanet Sistemas');

                    $pdf->SetTitle('Libro de Ventas Consumidor Final');

                    $pdf->SetSubject('Libro de Ventas Consumidor Final');

                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');



                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config

                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config

                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config

                

                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);

                    $pdf->SetMargins(5, 45, 5, PDF_MARGIN_BOTTOM );

                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

                    $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);

                    

                    $fecha = new DateTime();

                    

                    $footer =  '<br><br><br><br><br><br>

                    <table style="padding:0px; margin:0px;">

                        <tbody style="padding:0px; margin:0px;">

                            <tr style="padding:0px; margin:0px;">

                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>

                                <th style="font-size:10px; text-align:center; width: 40%"></th>

                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>

                            </tr>

                        </tbody>

                        </table>';

                

                    $pdf->setHtmlFooter($footer);

                    $pdf->setPrintFooter(true);

                    $this->load->model('global_model');

                    $this->load->model('iva_model');

                    $function = $this->uri->segment(3);

                    $nombreFormato = $this->global_model->getFormatosNombre($function);

                    $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);

                    $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                    $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);

                    $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);

                    $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);

                    $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);

                    $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);

                    

                    $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);

                    if($nombre_contador==""){

                        $nombre_contador="NO ASIGNADO";

                    }

                    $mes = date_format(date_create($fechaini),'n');

                    $anio = date_format(date_create($fechaini),'Y');

                    switch($mes){

                        case 1:

                            $mes_name = "ENERO";

                            break;

                        case 2:

                            $mes_name = "FEBRERO";

                            break;

                        case 3:

                            $mes_name = "MARZO";

                            break;

                        case 4:

                            $mes_name = "ABRIL";

                            break;

                        case 5:

                            $mes_name = "MAYO";

                            break;

                        case 6:

                            $mes_name = "JUNIO";

                            break;

                        case 7:

                            $mes_name = "JULIO";

                            break;

                        case 8:

                            $mes_name = "AGOSTO";

                            break;

                        case 9:

                            $mes_name = "SEPTIEMBRE";

                            break;

                        case 10:

                            $mes_name = "OCTUBRE";

                            break;

                        case 11:

                            $mes_name = "NOVIEMBRE";

                            break;

                        case 12:

                            $mes_name = "DICIEMBRE";

                            break;

                        default:

                            $mes_name="";

                            break;

                    }

                    

                    

                    

                    

                    $header = '

                    <table>

                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>

                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>

                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>

                        <tr><td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('descrip').'</td><td colspan="2" style="text-align:right;font-size:14px;width:60%;">N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label></td></tr>

                        

                        

                </table>';

                    

                    $pdf->setHtmlHeader($header);

                    $pdf->setPrintHeader(true);

                    

                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

                    $pdf->setFontSubsetting(true);

                    $pdf->setPageOrientation('Lanscape');

                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    $this->load->model('global_model');

                    

                    $pdf->addPage('L', 'LETTER');

                    $estructura = '<table>';

                    $estructura .= '<thead><tr>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N°</th>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">NUMERO CORRELATIVO PRE-IMPRESO</th>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">FECHA DE EMISIÓN</th>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:28%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N.R.C.</th>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:32%; font-weight:bold; text-align:center; font-size:12px;" colspan="4">VENTAS INTERNAS</th>

                    <th style="border:0.1px solid #333333; vertical-align:middle;  width:8%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">VENTAS TOTALES</th>

                    </tr>

                    <tr>

                        <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">EXENTAS</th>

                        <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">NO SUJETAS</th>

                        <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">GRAVADAS</th>

                        <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:10.5px;">DEBITO FISCAL</th>

                    </tr></thead>

                    <tbody></tbody>';

                    

                    $sum_exento=0;

                    $sum_gravado=0;

                    $sum_iva=0;

                    $sum_total=0;

                    $ventas = $this->iva_model->getVentasReporte($fechaini, $fechafin, $idcentro, $formatos);

                    $i=0;

                    foreach($ventas as $vn){

                        $i++;    

                        $exento=0;

                        $gravado=0;

                        $iva=0;

                        if($vn->exento==1){

                            $exento = $vn->valventan;

                        }else{

                            $gravado = $vn->valventan;

                        }

                        $iva = $vn->valtax1;

                        $sum_exento+=$exento;

                        $sum_gravado+=$gravado;

                        $sum_iva+=$iva;

                        $sum_total+= $exento+$gravado+$iva;



                        $estructura.='<tr>

                            <td style="width:5%;text-align:center; font-size:9px;">'.$i.'</td>

                            <td style="width:10%;text-align:left; font-size:9px;">'.strtoupper($vn->numeroserie).'</td>

                            <td style="width:7%;text-align:center; font-size:9px;">'.date_format(date_create($vn->fecha),'d/m/Y').'</td>

                            <td style="width:28%;text-align:left; font-size:9px;">'.$vn->namecliente.'</td>

                            <td style="width:10%;text-align:right; font-size:9px;">'.$vn->nrc.'</td>

                            <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>

                            <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>

                            <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>

                            <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>

                            <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($exento+$gravado+$iva, 2),2).'</td>

                        </tr>';

                    }

                    $estructura.='<tr>

                            <td colspan="4" style="width:50%;text-align:center; font-size:9px;"></td>

                            <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>

                            <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>

                            <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>

                            <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>

                            <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_iva, 2),2).'</td>

                            <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>

                        </tr><tr><td colspan="10"><br><br><br></td></tr>';

                    

                    $estructura.='<tr>

                        <td colspan="3" style="border-bottom:1px solid #333333;"></td>

                        <td colspan="6"></td>

                    </tr><tr>

                        <td colspan="3" style="text-align:center;font-size:12px;">'.$nombre_contador.'</td>

                        <td colspan="6"></td>

                    </tr><tr>

                        <td colspan="3" style="text-align:center;font-size:11px;">Contador</td>

                        <td colspan="6"></td>

                    </tr>';

                    

                    $estructura.='</table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);

                    $nombre_archivo = utf8_decode("LibrodeContribuyentes.pdf");

                    $pdf->Output($nombre_archivo, 'I');

                }

            }
            
            function valueinv($sucursal, $tipopro){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->db->query('SET SQL_BIG_SELECTS=1'); 

                    ini_set('memory_limit', '9999M');

                    ini_set('max_allowed_packet', '9999M');

                    ini_set('max_execution_time', 0);

                    set_time_limit(0);

                    $fecha = new DateTime();

                    $this->load->library('Pdf');

                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                    $pdf->SetCreator(PDF_CREATOR);

                    $pdf->SetAuthor('Versanet Sistemas');

                    $pdf->SetTitle('Reporte de Inventario Valorizado');

                    $pdf->SetSubject('Reporte de Inventario Valorizado');

                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

                    $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);

                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 

                    $pdf->setFontSubsetting(true);

                    $pdf->setPageOrientation('P');

                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    

                    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);

                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);

                    $this->load->model('sucursal_model');

                    $nameSucursal = $this->sucursal_model->getNameCentro($sucursal);

                    $this->load->model('invtran_model');

                    $departamentos = $this->invtran_model->getInvValorizado_Dept($sucursal,$tipopro);

                    $dataLineas = $this->invtran_model->getInvValorizado_Lineas($sucursal,$tipopro);

                    $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Inventario Valorizado al '.$fecha->format('d/m/Y').'</label><br><label style="text-align:center; font-size:13px;">'.$nameSucursal.'</label></center>';

                

                    //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

                    //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    $pdf->setHtmlHeader($header);

                    $pdf->setPrintHeader(true);

                

                    $footer =  '<br><br><br><br><br><br>

                    <table style="padding:0px; margin:0px;">

                        <tbody style="padding:0px; margin:0px;">

                            <tr style="padding:0px; margin:0px;">

                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>

                                <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>

                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>

                            </tr>

                        </tbody>

                        </table>';

                    $pdf->setHtmlFooter($footer);

                    $pdf->setPrintFooter(true);

                    $pdf->addPage( 'P', 'LETTER' );

                    $total_costo=0;

                    $total_venta=0;

                    $total_cantidades=0;

                    $sum_margen=0;

                    $cant_dep=0;

                    $titulo='<table><thead><tr style="" >

                            <th style="width:45%; font-size:13px; border-bottom:1px solid #999; ">Departamento/Línea</th>

                            <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:center;">Productos</th>

                            <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Costo</th>

                            <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Venta Neto</th>

                            <th style="width:10%; font-size:13px; border-bottom:1px solid #999; text-align:right">Margen s/costo</th>

                    </tr></thead><tbody>';

                    

                    foreach($departamentos as $dep){

                        $total_costo = $total_costo+$dep->costo;

                        $total_venta = $total_venta+$dep->venta;

                        $total_cantidades = $total_cantidades+$dep->unidades;

                        $margen = (($dep->venta-$dep->costo)/$dep->venta)*100;

                        $sum_margen = $sum_margen+$margen;

                        $cant_dep++;

                        $titulo.='<tr><td></td><td></td><td></td><td></td></tr>

                            <tr>

                            <td style="border-bottom:0.5px solid #F6F6F6; width:45%;  font-size:12px; font-weight:bold;">'.$dep->descrip.'</td>

                            <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold;text-align:center;">'.$dep->unidades.'</td>

                            <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->costo, 2),2).'</td>

                            <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->venta, 2),2).'</td>

                            <td style="border-bottom:0.5px solid #F6F6F6; width:10%;  font-size:12px; font-weight:bold; text-align:right;">'.number_format(round($margen, 2),2).'%</td>

                    </tr>';

                        foreach($dataLineas as $line){



                            if($line->idnivel1==$dep->idcatalogo){

                                $margen_linea = (($line->venta-$line->costo)/$line->venta)*100;

                                $titulo.='<tr>

                                <td style="width:45%;  font-size:11px;">&nbsp;&nbsp;&nbsp;                                  '.$line->linea.'</td>

                                <td style="width:15%;  font-size:11px; text-align:center;">'.$line->unidades.'</td>

                                <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->costo, 2),2).'</td>

                                <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->venta, 2),2).'</td>

                                <td style="width:10%; font-size:11px;text-align:right;">'.number_format(round($margen_linea, 2),2).'%</td>

                                </tr>';

                            }

                        }

                    }

                    $prom_margen=$sum_margen/$cant_dep;

                    $titulo.='<tr><td></td><td></td><td></td><td></td></tr>

                            <tr>

                            <td style="width:45%;  font-size:12px; text-align:right; font-weight:bold;">TOTALES</td>

                            <td style="border-top:1px solid #999; width:15%;  font-size:11px; text-align:center; font-weight:bold;">'.$total_cantidades.'</td>

                            <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_costo, 2),2).'</td>

                            <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_venta, 2),2).'</td>

                            <td style="border-top:1px solid #999; width:10%;  font-size:11px;text-align:right; font-weight:bold;">'.number_format(round($prom_margen, 2),2).'% <br> Prom.</td>

                    </tr>';

                    

                    $titulo.='</tbody></table>';

                    

                    $pdf->writeHTML($titulo, true, false, true, false, '');

                    $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");

                    $pdf->Output($nombre_archivo, 'I');

                }

            }
            
            function reporteComprasLocales($idrec){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    

                    $this->load->library('Pdf');

                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                    $pdf->SetCreator(PDF_CREATOR);

                    $pdf->SetAuthor('Versanet Sistemas');

                    $pdf->SetTitle('COMPRAS LOCALES');

                    $pdf->SetSubject('COMPRAS LOCALES');

                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config

                    //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));

                    

                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config

                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config

                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config

                    $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 

                    //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);

                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);

                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config

                    $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);

                    //relación utilizada para ajustar la conversión de los píxeles

                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 

                    // ---------------------------------------------------------

                    // establecer el modo de fuente por defecto

                    $pdf->setFontSubsetting(true);

                    $pdf->setPageOrientation('P');

                    //$pdf->setPageOrientation('Portrait');

                    //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como

                    // Helvetica para reducir el tamaño del archivo.

                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    // Añadir una página

                    // Este método tiene varias opciones, consulta la documentación para más información.

                    // Añadir una página

                // $pdf->AddPage();

                    // Este método tiene varias opciones, consulta la documentación para más información.

                    

                    $this->load->model('compras_model');

                    $this->load->model('pedclientes_model');

                    

                    $informacion  = $this->compras_model->getInformacion($idrec); 

                    $productos = $this->compras_model->getProductos($idrec); 

                    $name = $this->pedclientes_model->getnameImg();

                    

                    $fecha = new DateTime();

                    $footer =  '<br><br><br><br>

                        <table style="padding:0px; margin:0px;">

                            <tbody style="padding:0px; margin:0px;">

                                <tr style="padding:0px; margin:0px;">

                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>

                                <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>

                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>

                            </tr>

                            </tbody>

                        </table>';

                    $pdf->setHtmlFooter($footer);

                    $pdf->setPrintFooter(true);



                    $header = '<table style="width:100%; text-align:center;">

                                        <tr><td colspan="3" style="font-size:5px;"><br></td></tr>

                                        <tr>

                                            <td style=""><img style="width:200px; height:70px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>

                                            <td></td>

                                            <td style="font-size:25px; text-align:center;">COMPRA LOCAL</td>

                                        </tr>

                                    </table>';

                    

                    foreach($informacion as $inf){

                        $header .= '<table style="width:100%;">

                                        <tr>

                                            <td style="font-size:12px; text-align:left; width:50%;"></td>

                                            <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:50%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>

                                        </tr>

                                    </table>';



                        $header .= '<table style="width:100%;">

                                        <tr>

                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Proveedor:</td>

                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;No.</td>

                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$idrec.'&nbsp;&nbsp;</td>

                                        </tr>

                                        <tr>

                                            <td style="font-size:12px; text-align:left; width:50%;">'.$inf->descrip.'</td>  

                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Referencia: </td>

                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->referencia.'&nbsp;&nbsp;</td>

                                        </tr>

                                        <tr>

                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Solicitado por: </td>

                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Número de Documento:</td>

                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->serie.''.$inf->numero.'&nbsp;&nbsp;</td>

                                        </tr>

                                        <tr>

                                            <td style="font-size:12px; text-align:left; width:50%;">'.$inf->solicita.'</td>

                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Fecha:</td>

                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.date_format(date_create($inf->fecha), 'd/m/Y').'&nbsp;&nbsp;</td>

                                        </tr>

                                        <tr><td style="font-size:10px;"><br></td></tr>

                                    </table>';

                    }

                    $pdf->setHtmlHeader($header);

                    $pdf->setPrintHeader(true);

                    $pdf->addPage( 'P', 'LETTER' );

                    $titulo='

                    <table>

                        <thead>

                            <tr><td style="font-size:10px;"></td></tr>

                            <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">

                                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>

                                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:37%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>

                                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>

                                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>

                                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>

                                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>

                                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>

                                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>

                            </tr>

                        </thead>

                    <tbody>';

                    $sum_lines = 0;

                    $sum_cant = 0;

                    $sum_subtotal = 0;

                    foreach($productos as $pro){

                        $sum_lines++;

                        $sum_cant+= $pro->cantidad;

                        $sum_subtotal+=($pro->cantidad * $pro->preciotran);

                        $titulo.='<tr style="border: 1px solidblack;">

                        <td style="width:5%; border-left: 1px solid #6E6E6E; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->itemline.'</strong></td>

                        <td style="width:37%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>

                        <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>

                        <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>

                        <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>

                        <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>

                        <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($pro->preciotran, 6),6).'</td>

                        <td style="width:10%; border-right: 1px solid #6E6E6E;text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(($pro->cantidad * $pro->preciotran),2).'&nbsp;&nbsp;</td></tr>';

                    }

                    

                    

                    

                    $titulo.='<tr> <td style="border-top: 1px solid #6E6E6E;" colspan="8"><br></td></tr>';

                    

                    $titulo.='<tr style="border: 1px solidblack;">

                        <td style="width:5%; border-left: 1px solid #6E6E6E; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$sum_lines.'</strong></td>

                        <td colspan="4" style="border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;width:67%;  vertical-align:middle; padding:0px; font-size:10px;"><strong> </strong></td>

                        <td style="width:8%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.round($sum_cant, 0).'</strong></td>

                        <td style="width:10%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"></td>

                        <td style="width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"><strong>$'.number_format(($sum_subtotal),2).'&nbsp;&nbsp;</strong></td></tr>';

                

                    $titulo.='</tbody>

                    </table>';

                    $pdf->writeHTML($titulo, true, false, true, false, '');

                    $nombre_archivo = utf8_decode("Detalle_ComprasLocales_".$idrec.".pdf");

                    $pdf->Output($nombre_archivo, 'I');

                }

            }

            function VentasPorPeriodo($idcentro, $idcaja, $fechaini, $fechafin){

                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                    redirect('login/cerrar_sesion');

                }else{

                    $this->load->library('Pdf');

                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                    $pdf->SetCreator(PDF_CREATOR);

                    $pdf->SetAuthor('Versanet Sistemas');

                    $pdf->SetTitle('Ventas Por Periodo');

                    $pdf->SetSubject('Ventas Por Periodo');

                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

                    $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);

                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 

                    $pdf->setFontSubsetting(true);

                    $pdf->setPageOrientation('P');

                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    $pdf->SetMargins(3, 30, 3, 0);

                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);

                    $this->load->model('ventas_model');

                    $this->load->model('sucursal_model');

                    $this->load->model('invtran_model');

                    $this->load->model('caja_model');

                    

                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    $datoscaja = $this->caja_model->getNameCaja($idcaja);

                    foreach($datoscaja as $caja){

                        $namecaja = $caja->descrip;

                        $numcaja = $caja->resolucion;

                    }

                    

                    $tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);

                    $documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);

                    $facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);

                    $cnt = 0;

                    $valpag = array();

                    foreach($tipospagos as $tip){

                        $valpag[$tip->cajclase] = 0;

                        $valpagG[$tip->cajclase] = 0;

                        $cnt++;

                    }

                    $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';

                

                    $pdf->setHtmlHeader($header);

                    $pdf->setPrintHeader(true);

                    $fecha = new DateTime();

                    $footer =  '<br><br><br><br><br><br>

                    <table style="padding:0px; margin:0px;">

                        <tbody style="padding:0px; margin:0px;">

                            <tr style="padding:0px; margin:0px;">

                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>

                                <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>

                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>

                            </tr>

                        </tbody>

                        </table>';

                    $pdf->setHtmlFooter($footer);

                    $pdf->setPrintFooter(true);

                    $pdf->addPage('P', 'LETTER' );

                    $titulo ='<table>

                        <thead>

                            <tr style="border-bottom: 1px solid black;">

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 8%">N°</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6.5%">Fecha</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 18%">Nombre de Cliente</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Exento</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Gravado</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">IVA</th>

                                <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Total</th>';

                    $porcentaje = 32.5/$cnt;

                    $porcentaje2 = 50/$cnt;

                    foreach($tipospagos as $tip){

                        $titulo .= '<th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: '.$porcentaje.'%">'.$tip->descrip.'</th>';

                    }

                    

                    $colspan = 8 + $cnt;

                    $titulo .='</tr>

                        </thead>

                        <tbody>';

                    

                    $subtotal=0;

                    $totalglobal=0;

                    $totalexglobal=0;

                    $totalgrglobal=0;

                    $totalivglobal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $numdoc = 0;

                    $numdocg = 0;

                    foreach($documentos as $docs){

                        $numdoc = 0;

                        $subtotal=0;

                        $subtotalex = 0;

                        $subtotalgr = 0;

                        $subtotaliv = 0;

                        foreach($tipospagos as $tip){

                            $valpag[$tip->cajclase] = 0;

                        }

                        

                        $titulo .= '<tr><th colspan="'.$colspan.'"><br></th></tr><tr><th colspan="'.$colspan.'" style="font-size:12px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.$docs->tipoDoc.'</th></tr>';

                        foreach($facturas as $ven){

                            if($docs->tipoDoc == $ven->tipodoc){

                            

                                $valtax_product = 0;

                                

                                

                                if($ven->exento == 0){

                                    $valtax_product = $ven->valtax1;

                                }else{

                                    $valtax=0;

                                }

                                

                                $valtot=$ven->valventan + $valtax_product;

                                

                                $subtotal= $subtotal+$valtot;

                                

                                $date = date_format(date_create($ven->fecha),'d/m/Y');

                                

                                $total = 0;

                                $totalGravado = 0;

                                $totalExento = 0;

                                $totalIVA = 0;

                                $invexento = $ven->exento;

                                $productos = $this->invtran_model->getDataTran100k($ven->trannum);

                                

                                foreach($productos as $pro){

                                    if($pro->tipotax != 0 && $invexento == 0){

                                        //DEVOLUCION

                                        if($ven->inopera==1){

                                            $total = $total - (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));

                                            $totalIVA = $totalIVA - (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));

                                            $totalGravado = $totalGravado - $pro->precioneto * abs($pro->cantidad);

                                        }else{

                                            //VENTA 

                                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));

                                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));

                                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                        }

                                        

                                    }else if($pro->tipotax != 0 && $invexento == 1){

                                        if($ven->inopera==1){

                                            $total = $total - (($pro->precioneto * abs($pro->cantidad)));

                                            $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);

                                        }else{

                                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                        }

                                        

                                    }else if($pro->tipotax== 0 && $invexento == 0){

                                        if($ven->inopera==1){

                                            $total = $total - (($pro->precioneto) * abs($pro->cantidad));

                                            $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);

                                        }else{

                                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                        }

                                        

                                    }else if($pro->tipotax == 0 && $invexento == 1){

                                        if($ven->inopera==1){

                                            $total = $total - (($pro->precioneto) * Math.abs($pro->cantidad));

                                            $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);

                                        }else{

                                            $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));

                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                        }

                                        

                                    }

                                }

                                

                                $subtotalex = $subtotalex + $totalExento;

                                $subtotalgr = $subtotalgr + $totalGravado;

                                $subtotaliv = $subtotaliv + $totalIVA;

                                

                                if($totalExento == 0){

                                    $totalExento = "";

                                }else{

                                    $totalExento = "$".number_format(round($totalExento, 2), 2 ,'.',',');

                                }

                                

                                if($totalGravado == 0){

                                    $totalGravado = "";

                                }else{

                                    $totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.',',');

                                }

                                

                                $namecliente = substr($ven->namecliente, 0, 37);

                                $titulo .= '

                                    <tr>

                                        <td style="font-size:7px; text-align:left; font-weight: normal; width: 8%">'.$ven->numeroserie.'</td>

                                        <td style="font-size:8px; text-align:center; font-weight: normal; width: 6.5%">'.$date.'</td>

                                        <td style="font-size:8px; text-align:left; font-weight: normal; width: 18%">'.$namecliente.'</td>

                                        <td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$ven->hora.'</td>

                                        <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalExento.'</td>

                                        <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalGravado.'</td>

                                        <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtax_product, 2),2, '.', ',').'</td>

                                        <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtot, 2),2, '.', ',').'</td>';

                                foreach($tipospagos as $tip){

                                    $pagos = $this->ventas_model->getDatosPagosVentasPago($ven->trannum,$tip->cajclase);

                                    if($pagos!=false){

                                        foreach($pagos as $money){

                                            if($ven->inopera==1){

                                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));

                                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));

                                                $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$-'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2, '.', ',').'</td>';



                                            }else{

                                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));

                                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));

                                                $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2, '.', ',').'</td>';



                                            }

                                        }

                                    }else{

                                        $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%"></td>';

                                    }

                                    

                                }

                                $titulo .='</tr>';

                                $numdoc++;

                                $numdocg++;

                            }

                        }

                        $titulo .= '<tr>

                            <th style="font-size:9px; text-align:left; font-weight: bold; width:10%;">('.$numdoc.')</th>

                            <th style="font-size:8px; text-align:right; font-weight: bold; width:35%;">Subtotal: $'.number_format(round($subtotalex, 2),2).'</th>

                            <th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalgr, 2),2).'</th>

                            <th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotaliv, 2),2).'</th>

                            <th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotal, 2),2).'</th>';

                        foreach($tipospagos as $tip){

                            $titulo .= '<th style="font-size:8px; text-align:right; font-weight: bold;  width:'.$porcentaje.'%">$'.number_format(round($valpag[$tip->cajclase], 2),2).'</th>';

                        }

                        $titulo .= '</tr>';

                        $totalglobal = $totalglobal+$subtotal;

                        $totalexglobal = $totalexglobal + $subtotalex;

                        $totalgrglobal = $totalgrglobal + $subtotalgr;

                        $totalivglobal = $totalivglobal + $subtotaliv;

                        

                    }

                    $titulo .= '

                        <tr>

                            <th colspan="'.$colspan.'"><br></th>

                        </tr>

                        <tr>

                            <th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdocg.')</th>

                            <th style="font-size:9px; text-align:right; border-top: 1px solid black; width:35%; font-weight: bold;">Total: $'.number_format(round($totalexglobal, 2),2).'</th>

                            <th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalgrglobal, 2),2).'</th>

                            <th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalivglobal, 2),2).'</th>

                            <th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalglobal, 2),2).'</th>';

                    foreach($tipospagos as $tip){

                        $titulo .= '<th style="font-size:9px; text-align:right; font-weight: bold; border-top: 1px solid black;  width:'.$porcentaje.'%">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</th>';

                    }

                    $titulo .= '</tr></tbody></table>';

                    $titulo .= '<br><br><br>';

                

                    $titulo .='<table>

                    <thead>

                        <tr style="border-bottom: 1px solid black;">

                        <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>

                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>

                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>

                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>

                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>

                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>

                    </thead><tbody>';

                    

                    $titulo.='<tr style="border-bottom: 1px solid black;">

                        <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>

                        <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">'.$numdocg.'</th>

                        <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalexglobal, 2),2).'</th>

                        <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalgrglobal, 2),2).'</th>

                        <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalivglobal, 2),2).'</th>

                        <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalglobal, 2),2).'</th>

                    </tr>';

                    $titulo .= '</tbody></table>';

                    $titulo .='<br><br><br><table>

                                    <thead>

                                    <tr style="border-bottom: 1px solid black;">

                                        <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>

                                        <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>

                                        <tr style="border-bottom: 1px solid black;">

                                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';



                        foreach($tipospagos as $tip){

                            $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE; width: '.$porcentaje2.'%">'.$tip->descrip.'</th>';

                        }

                        $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:'.$porcentaje2.'%;background-color:#C2CBCE;">Sumas</th></tr></thead><tbody>';



                        $titulo.='<tr style="border-bottom: 1px solid black;">

                                        <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';

                        $total_ing_sum=0;

                        foreach($tipospagos as $tip){

                            $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';

                            $total_ing_sum+=round($valpagG[$tip->cajclase], 2);

                        }



                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';



                    

                    

                    $pdf->writeHTML($titulo, true, false, true, false, '');

                    $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");

                    $pdf->Output($nombre_archivo, 'I');

                }

            }

            function impresionEtiquetasBarrasAnteriosMultiplesprecios($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    ini_set('memory_limit','1024M');

                    $this->load->library('Pdf');

                    $pageLayout = array(30, 30);
                    $pdf = new Pdf('P', 'mm', $pageLayout, true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Etiquetas');
                    $pdf->SetSubject('Etiquetas');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(0, 0, 0);
                    $pdf->SetAutoPageBreak(TRUE);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 7, '', true);
                    $pdf->addPage('P', $pageLayout);
                    
                    $num_rows=0; $cant=0;
                    $array_empresa = explode(" ", $this->session->userdata('descrip'));
                    $estructura = '<table style="width:100%;">';
                    
                    $this->load->model('scan_model');
                    $listado_products = $this->scan_model->getProductsOrderEspecificoOrderByItemLine($trannum);
                    $primera = true; $actual=0;
                    $array_datos = array();
                    $count_array_datos = 0; $cant = 0;
                    
                    if($listado_products!=false){
                        foreach($listado_products as $prod){
                            
                            $info_product = $this->scan_model->getDatosProduct($prod->idproducto);
                            $cant_etiquetas = $prod->cantidad;
                            $idproducto = $prod->idproducto;
                            $actual = 0;
                            
                            do{
                                $num = "";
                                if($idproducto>0 && $idproducto<10){
                                    $num = "000".$idproducto;
                                }else if($idproducto>=10 && $idproducto<100){
                                    $num = "00".$idproducto;
                                }else if($idproducto>=100 && $idproducto<999){
                                    $num = "0".$idproducto;
                                }else{
                                    $num = $idproducto; 
                                }
                                
                                $params = $pdf->serializeTCPDFtagParameters(array($num, 'C39', '', '', 28, 11, 0.4, array('position' => 'S', 'align' => 'C', 'border'=>false, 'padding'=>0, 'margin'=>0, 'fgcolor'=>array(1,1,1), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>7, 'stretchtext'=>1), 'N'));
                                
                                $precioB = $this->scan_model->getDatoPreciosMultiplesByDescrip('PRECIO B', $idproducto);
                                $precioC = $this->scan_model->getDatoPreciosMultiplesByDescrip('PRECIO C', $idproducto);

                                $estructura .= '
                                <tr style="padding:0px;margin:0px;">
                                    <td style="padding:0px; margin:0px; width:100%; height:20px;">
                                        <table style="padding:0px; width:100%; margin:0px;">
                                            <tr style="padding:0px; width:100%; margin:0px;"> 
                                                <td style="width:100%; font-size:10px; text-align:center;"><span style="font-size:9px">FRIO CENTER</span><br><span style="font-size:16px; font-weight:bold;">'.$prod->modelo.'</span><br><span style="font-size:6px">'.substr($prod->descrip, 0, 60).'</span></td>
                                            </tr>
                                            <tr style="padding:0px; width:100%; margin:0px;"> 
                                                <td style="width:100%; padding:0px; margin:0px; text-align:center;"><tcpdf method="write1DBarcode" style="padding:0px;margin:0px; width:100%;" params="'.$params.'" /><span style="color:black; text-align:left; font-weight:bold; font-size:7px">A $'.number_format($prod->precioventa, 2, '.', '').'</span>&nbsp;&nbsp;<span style="color:black; text-align:left; font-weight:bold; font-size:7px">B $'.number_format($precioB, 2, '.', '').'</span>&nbsp;<span style="color:black; text-align:left; font-weight:bold; font-size:7px">C $'.number_format($precioC, 2, '.', '').'</span></td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>';
                                
                                $num_rows++;
                                $actual++;
                            }while($actual < $cant_etiquetas);
                        }
                    }
                    
                    $estructura .= '</table>';
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $nombre_archivo = utf8_decode("Etiquetas.pdf");
                    $pdf->Output($nombre_archivo, 'I');
                }
            }

            function impresionEtiquetasBarras($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    ini_set('memory_limit','1024M');

                    $this->load->library('Pdf');

                    $pageLayout = array(30, 30);
                    $pdf = new Pdf('P', 'mm', $pageLayout, true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Etiquetas');
                    $pdf->SetSubject('Etiquetas');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(0, 0, 0);
                    $pdf->SetAutoPageBreak(TRUE);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 7, '', true);
                    $pdf->addPage('P', $pageLayout);
                    
                    $num_rows=0; $cant=0;
                    $array_empresa = explode(" ", $this->session->userdata('descrip'));
                    $estructura = '<table style="width:100%;">';
                    
                    $this->load->model('scan_model');
                    $listado_products = $this->scan_model->getProductsOrderEspecificoOrderByItemLine($trannum);
                    $primera = true; $actual=0;
                    $array_datos = array();
                    $count_array_datos = 0; $cant = 0;
                    
                    if($listado_products!=false){
                        foreach($listado_products as $prod){
                            
                            $info_product = $this->scan_model->getDatosProduct($prod->idproducto);
                            $cant_etiquetas = $prod->cantidad;
                            $idproducto = $prod->idproducto;
                            $actual = 0;
                            
                            do{
                                $num = "";
                                if($idproducto>0 && $idproducto<10){
                                    $num = "000".$idproducto;
                                }else if($idproducto>=10 && $idproducto<100){
                                    $num = "00".$idproducto;
                                }else if($idproducto>=100 && $idproducto<999){
                                    $num = "0".$idproducto;
                                }else{
                                    $num = $idproducto; 
                                }
                                
                                $params = $pdf->serializeTCPDFtagParameters(array($num, 'C39', '', '', 28, 11, 0.4, array('position' => 'S', 'align' => 'C', 'border'=>false, 'padding'=>0, 'margin'=>0, 'fgcolor'=>array(1,1,1), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>7, 'stretchtext'=>1), 'N'));
                                
                                $precioB = $this->scan_model->getDatoPreciosMultiplesByDescrip('PRECIO B', $idproducto);
                                $precioC = $this->scan_model->getDatoPreciosMultiplesByDescrip('PRECIO C', $idproducto);

                                $estructura .= '
                                <tr style="padding:0px;margin:0px;">
                                    <td style="padding:0px; margin:0px; width:100%; height:20px;">
                                        <table style="padding:0px; width:100%; margin:0px;">
                                            <tr style="padding:0px; width:100%; margin:0px;"> 
                                                <td style="width:100%; font-size:10px; text-align:center;"><span style="font-size:9px">FRIO CENTER</span><br><span style="font-size:16px; font-weight:bold;">'.$prod->modelo.'</span><br><span style="font-size:6px">'.substr($prod->descrip, 0, 60).'</span></td>
                                            </tr>
                                            <tr style="padding:0px; width:100%; margin:0px;"> 
                                                <td style="width:100%; padding:0px; margin:0px; text-align:left;"><tcpdf method="write1DBarcode" style="padding:0px;margin:0px; width:100%;" params="'.$params.'" /><span style="color:black; text-align:center; font-weight:bold; font-size:7px"> $'.number_format($prod->precioventa, 2, '.', '').'</span>&nbsp;&nbsp;<span style="color:black; text-align:left; font-weight:bold; font-size:7px"></span>&nbsp;<span style="color:black; text-align:left; font-weight:bold; font-size:7px"></span></td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>';
                                
                                $num_rows++;
                                $actual++;
                            }while($actual < $cant_etiquetas);
                        }
                    }
                    
                    $estructura .= '</table>';
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $nombre_archivo = utf8_decode("Etiquetas.pdf");
                    $pdf->Output($nombre_archivo, 'I');
                }
            }

            function impresionEtiquetaSinPrecio($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    ini_set('memory_limit','1024M');

                    $this->load->library('Pdf');

                    $pageLayout = array(30, 30);
                    $pdf = new Pdf('P', 'mm', $pageLayout, true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Etiquetas');
                    $pdf->SetSubject('Etiquetas');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(0, 0, 0);
                    $pdf->SetAutoPageBreak(TRUE);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 7, '', true);
                    $pdf->addPage('P', $pageLayout);
                    
                    $num_rows=0; $cant=0;
                    $array_empresa = explode(" ", $this->session->userdata('descrip'));
                    $estructura = '<table style="width:100%;">';
                    
                    $this->load->model('scan_model');
                    $listado_products = $this->scan_model->getProductsOrderEspecificoOrderByItemLine($trannum);
                    $primera = true; $actual=0;
                    $array_datos = array();
                    $count_array_datos = 0; $cant = 0;
                    
                    if($listado_products!=false){
                        foreach($listado_products as $prod){
                            
                            $info_product = $this->scan_model->getDatosProduct($prod->idproducto);
                            $cant_etiquetas = $prod->cantidad;
                            $idproducto = $prod->idproducto;
                            $actual = 0;
                            
                            do{
                                $num = "";
                                if($idproducto>0 && $idproducto<10){
                                    $num = "000".$idproducto;
                                }else if($idproducto>=10 && $idproducto<100){
                                    $num = "00".$idproducto;
                                }else if($idproducto>=100 && $idproducto<999){
                                    $num = "0".$idproducto;
                                }else{
                                    $num = $idproducto; 
                                }
                                
                                $params = $pdf->serializeTCPDFtagParameters(array($num, 'C39', '', '', 28, 13, 0.4, array('position' => 'S', 'align' => 'C', 'border'=>false, 'padding'=>0, 'margin'=>0, 'fgcolor'=>array(1,1,1), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>7, 'stretchtext'=>1), 'N'));
                                
                                $precioB = $this->scan_model->getDatoPreciosMultiplesByDescrip('PRECIO B', $idproducto);
                                $precioC = $this->scan_model->getDatoPreciosMultiplesByDescrip('PRECIO C', $idproducto);

                                $estructura .= '
                                <tr style="padding:0px;margin:0px;">
                                    <td style="padding:0px; margin:0px; width:100%; height:20px;">
                                        <table style="padding:0px; width:100%; margin:0px;">
                                            <tr style="padding:0px; width:100%; margin:0px;"> 
                                                <td style="width:100%; font-size:10px; text-align:center;"><span style="font-size:9px">FRIO CENTER</span><br><span style="font-size:16px; font-weight:bold;">'.$prod->modelo.'</span><br><span style="font-size:6px">'.substr($prod->descrip, 0, 60).'</span></td>
                                            </tr>
                                            <tr style="padding:0px; width:100%; margin:0px;"> 
                                                <td style="width:100%; padding:0px; margin:0px; text-align:center;"><tcpdf method="write1DBarcode" style="padding:0px;margin:0px; width:100%;" params="'.$params.'" /></td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>';
                                
                                $num_rows++;
                                $actual++;
                            }while($actual < $cant_etiquetas);
                        }
                    }
                    
                    $estructura .= '</table>';
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $nombre_archivo = utf8_decode("Etiquetas.pdf");
                    $pdf->Output($nombre_archivo, 'I');
                }
            }
            
            function impresionEtiquetasCompras($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    ini_set('memory_limit','1024M');

                    $this->load->library('Pdf');

                    $pageLayout = array(30, 30);
                    $pdf = new Pdf('P', 'mm', $pageLayout, true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Etiquetas');
                    $pdf->SetSubject('Etiquetas');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(0, 0, 0, 0);
                    $pdf->SetAutoPageBreak(TRUE);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 7, '', true);
                    $pdf->addPage('P', $pageLayout);
                    
                    $num_rows=0; $cant=0;
                    $array_empresa = explode(" ", $this->session->userdata('descrip'));
                    $estructura = '<table style="width:100%; padding:0px;">';
                    
                    $this->load->model('compras_model'); $this->load->model('scan_model');
                    $productos = $this->compras_model->getProductosCompraOrderByItemLine($trannum);
                    
                    $primera = true;
                    foreach($productos as $pro){
                        $proModelo = $this->eliminarTildes($pro->modelo);
                        
                        $actual = 0;
                        $cant_etiquetas = $pro->cantidad;
                        $array_empresa = explode(" ", $this->session->userdata('descrip'));
                                
                        do{
                            $num = "";
                            if($pro->idproducto>0 && $pro->idproducto<10){
                                $num = "000".$pro->idproducto;
                            }else if($pro->idproducto>=10 && $pro->idproducto<100){
                                $num = "00".$pro->idproducto;
                            }else if($pro->idproducto>=100 && $pro->idproducto<999){
                                $num = "0".$pro->idproducto;
                            }else{
                                $num = $pro->idproducto; 
                            }
                            
                            $params = $pdf->serializeTCPDFtagParameters(array($num, 'C39', '', '', 28, 11, 0.4, array('position' => 'S', 'align' => 'C', 'border'=>false, 'padding'=>0, 'margin'=>0, 'fgcolor'=>array(1,1,1), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>8, 'stretchtext'=>1), 'N'));
                                
                            $precioB = $this->scan_model->getDatoPreciosMultiplesByDescrip('PRECIO B', $pro->idproducto);
                            $precioC = $this->scan_model->getDatoPreciosMultiplesByDescrip('PRECIO C', $pro->idproducto);

                            $estructura .= '
                            <tr style="padding:0px;margin:0px;">
                                <td style="padding:0px; margin:0px; width:100%; height:20px;">
                                    <table style="padding:0px; width:100%; margin:0px;">
                                        <tr style="padding:0px; width:100%; margin:0px;"> 
                                            <td style="width:100%; padding:0px; font-size:10px; text-align:center;"><br><span style="font-size:9px">FRIO CENTER</span><br><span style="font-size:16px; font-weight:bold;">'.$proModelo.'</span><br><span style="font-size:6px">'.$pro->descrip.'</span></td>
                                        </tr>
                                        <tr style="padding:0px; width:100%; margin:0px;"> 
                                            <td style="width:100%; padding:0px; margin:0px; text-align:center;"><tcpdf method="write1DBarcode" style="padding:0px;margin:0px; width:100%;" params="'.$params.'" /><span style="color:black; text-align:left; font-weight:bold; font-size:6px">A: $'.number_format($pro->precioventa, 2, '.', '').'</span>&nbsp;&nbsp;&nbsp;<span style="color:black; text-align:left; font-weight:bold; font-size:6px">B: $'.number_format($precioB, 2, '.', '').'</span>&nbsp;&nbsp;&nbsp;<span style="color:black; text-align:left; font-weight:bold; font-size:6px">C:$'.number_format($precioC, 2, '.', '').'</span></td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>';
                            
                            $num_rows++;
                            $actual++;

                        }while($cant_etiquetas!=$actual); 
                    }    
                                    
                    $estructura .= '</table>';
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $nombre_archivo = utf8_decode("Etiquetas.pdf");
                    $pdf->Output($nombre_archivo, 'I');
                }
            }
            
            function ordenventaSinDescuento($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Orden De Venta');
                    $pdf->SetSubject('Orden De Venta');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(5, 5, 5, 0);
                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                    $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, 0);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 7, '', true);
                    $pdf->setPrintHeader(false);
                    
                    $pdf->addPage('P', 'LETTER');
                    
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('caja_model');
                    $this->load->model('pedclientes_model');
                    $this->load->model('sucursal_model');
                    
                    $background_color = $this->session->userdata('FHBackground');
                    $color = $this->session->userdata('FHFontColor');
                    
                    $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $formapago = $this->ventas_model->getFormaDePagoTrannum($trannum);
                    $name = $this->pedclientes_model->getnameImg();
                    $tipocliente = $dataPedido["idtipo"];
                    $notastran100 = $dataPedido["notas"];
                    $notasNameCliente = explode("\n", $notastran100);
                    $direccionSuc = $this->pedclientes_model->getLocationCotizacion($dataPedido["idcentro"]);
                    $namecentro = $this->sucursal_model->getNameCentro($dataPedido["idcentro"]);

                    if($dataPedido["idcps"] != 325){
                        $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                    }else if(($dataPedido["idcps"] == 325) && (empty($dataPedido["dev_contact"]))){
                        $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                    }else{
                        $nombreCliente = $dataPedido["dev_contact"];
                    }
                    
                    if($formapago == ''){
                        $formapago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);
                    }
                    $estructura = '
                        <table style="width:100%; padding-top:0px;">
                            <tr>
                                <td style="width:25%;"><img style="height:80px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;"><strong>'.trim($this->session->userdata('descrip')).'<br>'.$namecentro.'<br>'.$direccionSuc['notas'].'</strong></td>
                                <td style="text-align:center; border: 1px solid black; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;" ><br><br><strong>COTIZACION</strong><br>N°<br><strong style="font-size:14px;">'.$trannum.'</strong><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                            </tr>
                        </table>';
                    $estructura .= '
                        <table style="width:100%; border:1px solid black;">

                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Nombre del Cliente:</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["idcps"].' - '.$nombreCliente.'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Fecha:</strong> '.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Direccion:</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["direccion"].'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nrc:</strong>'.$dataPedido["NRC"].'</td>
                            </tr>
                            
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Correo:</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["correo"].'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nit:</strong>'.$dataPedido["NIT"].'</td>
                            </tr>
                            
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Tipo Documento:</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["tipodoc"].'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Vendedor: </strong></td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Forma de Pago:</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["formaPago"].'</td>
                                <td style="border-right:1px solid black; text-align:LEFT; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">'.$dataPedido["workername"].'</td>
                            </tr>
                        </table>';
                    
                    $estructura .= '
                        <table style="width:100%;">
                            <tr>
                                <td style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:4%;"><strong>No.</strong></td>
                                <td style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>CODIGO</strong></td>
                                <td style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;"><strong>DESCRIPCION DEL PRODUCTO</strong></td>
                                <td style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"><strong>UM</strong></td>
                                <td style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>CANTIDAD</strong></td>
                                <td style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>PRECIO DE VENTA</strong></td>
                                <td style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>SUB TOTAL</strong></td>
                            </tr>';
                    
                    $productos = $this->pedclientes_model->getDataProduct($trannum);
                    $cotExenta = $this->ventas_model->validateDocumentoExento($trannum);
                    
                    $total = 0; $totalGravado = 0; $totalExento = 0;
                    $totalIVA = 0; $invexento = $cotExenta; $vnExenta = 0; $vnGravada = 0;
                    $m = 0; $i = 0; $d = 0; $line=1;
                    
                    foreach($productos as $pro){
                        
                        if($pro->cantrp == 0){
                            $precioneto = $pro->precioneto;
                        }else{
                            $precioneto = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                        }   
                        
                        if($pro->tipotax != 0 && $invexento == 0){
                            $total = $total + number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalGravado = $totalGravado + number_format(round((($precioneto * abs($pro->cantidad))/(1+($pro->tipotax / 100))),4), 2 ,'.','');
                            
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tipotax != 0 && $invexento == 1){
                            $total = $total + (($precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                                
                            $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }else if($pro->tipotax== 0 && $invexento == 0){
                            $total = $total + (($precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                                
                            $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }else if($pro->tipotax == 0 && $invexento == 1){
                            $total = $total + (($precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                                
                            $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }
                        
                        if($pro->cantrp == 0){
                            $preciouni = $pro->precioneto;
                        }else{
                            $preciouni = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                        }
                        
                        $precioOrg = $pro->precioventa;
                        
                        if($pro->tipo != 4){
                            $nombrepro = $pro->descrip;
                        }else{
                            $nombrepro = $pro->notas;
                        }
                        
                        //$descuento = (((number_format($preciouni, 2 ,'.','') - number_format($precioOrg, 2 ,'.','')) / $precioOrg)*100);
                        $descuento = number_format($pro->cantrp, 0 ,'.','');
                        $estructura .= '
                            <tr>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:4%;">'.$line++.'</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$pro->modelo.'</td>
                                <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">'.$nombrepro.'</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:6%;">'.$pro->um.'</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.abs($pro->cantidad).'</td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.number_format($preciouni, 2 ,'.','').'</td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$vnExenta.''.$vnGravada.'</td>
                            </tr>';
                        $m = $m + 1;
                        
                        if($descuento>0){
                            $estructura .= '
                                <tr>
                                    <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"></td>
                                    <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;"></td>
                                    <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">DESCUENTO</td>
                                    <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$descuento.'%</td>
                                    <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                                    <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                                </tr>';
                            $d = $d + 1;
                        }
                        
                    }
                    
                    $lineasproduct = ($m + $d);
                
                    if($lineasproduct >= 1 && $lineasproduct <= 38){
                        $contFinal = 38;
                    }else if($lineasproduct > 34 && $lineasproduct <= 44){
                        $contFinal = 44;
                    }else if($lineasproduct > 48 && $lineasproduct <= 98){
                        $contFinal = 98;
                    }else{
                        $contFinal = 147;
                    }
                    
                    for($i=$lineasproduct; $i<=$contFinal; $i++){
                        $estructura .= '
                            <tr>
                                <td style="font-size:11px; width:100%;" colspan="6"></td>
                            </tr>';
                    }
                    
                    $estructura .= '</table>';
                    
                    if(($dataPedido["idtipo"]==3) && ($totalGravado>=100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = '-'.$reten;
                        $total= $total-$reten;
                    }else{
                        $retencion = 0;
                    }
                        
                    if($retencion == 0){
                        $retencion = "";
                    }else{
                        $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                    }
                    
                    $numero = number_format(round($total, 2), 2 ,'.','');
                    $TotalLetras = $this->convertir_a_letras($numero);
                    
                    $totalIVA = number_format(round(($totalGravado * ($pro->tipotax/100)), 2), 2 ,'.',''); 
                    
                    if($invexento==1){
                        $estructura .=  '
                            <table style="padding:0px; margin:0px;">
                                <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                    <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:75%" rowspan="2"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                                    <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                                </tr>
                                <tr style="padding:0px; margin:0px;">
                                    <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                                </tr>
                                <br>
                                <tr style="padding:0px; margin:0px;">
                                    <th style="font-size:10px; text-align:left; width:100%"><strong>Pago con cheque a nombre de: ESTRATEGIA COMERCIAL INTERNACIONAL S.A. DE C.V.</strong></th>
                                </tr>
                                ';  
                    }else{
                        $estructura .=  '
                            <table style="padding:0px; margin:0px;">
                                <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                    <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:100%"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                                </tr>
                                <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                    <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>SUB-TOTAL</strong></th>
                                    <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>IVA</strong></th>
                                    <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>RETENCIÓN</strong></th>
                                    <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                                </tr>
                                <tr style="padding:0px; margin:0px;">
                                    <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($totalGravado, 2), 2 ,'.',',').'</strong></th>
                                    <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalIVA.'</strong></th>
                                    <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>'.$retencion.'</strong></th>
                                    <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                                </tr>
                                <tr style="padding:0px; margin:0px;">
                                    <th style="font-size:10px; text-align:left; width:100%"><strong>Precios Incluyen IVA<br><br></strong></th>
                                </tr>
                                ';
                    }
                    
                    $estructura .=  '
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>'.$dataPedido["notas"].'</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Autorizado por</strong></th>
                                <th style="font-size:13px; text-align:center; width:5%"></th>
                                <th style="font-size:13px; text-align:center; width:30%"></th>
                                <th style="font-size:13px; text-align:center; width:5%"></th>
                                <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Aceptado Cliente</strong></th>
                            </tr>
                        </table>';
                    
                    $pdf->setPrintFooter(false);
                    $pdf->writeHTML($estructura, true, false, true, false, '');
                    $nombre_archivo = utf8_decode("OrdenDeVenta$trannum.pdf");
                    $pdf->Output($nombre_archivo, 'I');
                }
            }

            function ordenventa($trannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Orden De Venta');
                    $pdf->SetSubject('Orden De Venta');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    $pdf->SetMargins(5, 5, 5, 0);
                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                    $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, 0);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 7, '', true);
                    $pdf->setPrintHeader(false);
                    
                    $pdf->addPage('P', 'LETTER');
                    
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('caja_model');
                    $this->load->model('pedclientes_model');
                    $this->load->model('sucursal_model');
                    
                    $background_color = $this->session->userdata('FHBackground');
                    $color = $this->session->userdata('FHFontColor');
                    
                    $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                    $informacion = $this->ventas_model->getDatosFactura($trannum);
                    $formapago = $this->ventas_model->getFormaDePagoTrannum($trannum);
                    $name = $this->pedclientes_model->getnameImg();
                    $tipocliente = $dataPedido["idtipo"];
                    $notastran100 = $dataPedido["notas"];
                    $notasNameCliente = explode("\n", $notastran100);
                    $direccionSuc = $this->pedclientes_model->getLocationCotizacion($dataPedido["idcentro"]);
                    $namecentro = $this->sucursal_model->getNameCentro($dataPedido["idcentro"]);

                    if($dataPedido["idcps"] != 325){
                        $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                    }else if(($dataPedido["idcps"] == 325) && (empty($dataPedido["dev_contact"]))){
                        $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                    }else{
                        $nombreCliente = $dataPedido["dev_contact"];
                    }
                    
                    if($formapago == ''){
                        $formapago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);
                    }
                    $estructura = '
                        <table style="width:100%; padding-top:0px;">
                            <tr>
                                <td style="width:25%;"><img style="height:80px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;"><strong>'.trim($this->session->userdata('descrip')).'<br>'.$namecentro.'<br>'.$direccionSuc['notas'].'</strong></td>
                                <td style="text-align:center; border: 1px solid black; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;" ><br><br><strong>COTIZACION</strong><br>N°<br><strong style="font-size:14px;">'.$trannum.'</strong><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                            </tr>
                        </table>';
                    $estructura .= '
                        <table style="width:100%; border:1px solid black;">

                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Nombre del Cliente:</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["idcps"].' - '.$nombreCliente.'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Fecha:</strong> '.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Direccion:</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["direccion"].'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nrc:</strong>'.$dataPedido["NRC"].'</td>
                            </tr>
                            
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Correo:</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["correo"].'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nit:</strong>'.$dataPedido["NIT"].'</td>
                            </tr>
                            
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Tipo Documento:</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["tipodoc"].'</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Vendedor: </strong></td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Forma de Pago:</td>
                                <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["formaPago"].'</td>
                                <td style="border-right:1px solid black; text-align:LEFT; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">'.$dataPedido["workername"].'</td>
                            </tr>
                        </table>';
                    
                    $estructura .= '
                        <table style="width:100%;">
                            <thead>
                                <tr style="text-align:center;" >
                                    <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:4%;"><strong><br>No.<br></strong></th>
                                    <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CODIGO</strong></th>
                                    <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:40%;"><strong><br>DESCRIPCION DEL PRODUCTO</strong></th>
                                    <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:6%;"><strong><br>UM</strong></th>
                                    <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CANTIDAD</strong></th>
                                    <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>PRECIO</strong></th>
                                    <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>DESC.</strong></th>
                                    <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:11%;"><strong><br>SUB TOTAL</strong></th>
                                    <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>TOTAL</strong></th>
                                </tr>
                            </thead>';
                    
                    $productos = $this->pedclientes_model->getDataProduct($trannum);
                    $cotExenta = $this->ventas_model->validateDocumentoExento($trannum);
                    
                    $total = 0; $totalGravado = 0; $totalExento = 0;
                    $totalIVA = 0; $invexento = $cotExenta; $vnExenta = 0; $vnGravada = 0;
                    $m = 0; $i = 0; $d = 0; $line=1;
                    
                    foreach($productos as $pro){
                        
                        if($pro->cantrp == 0){
                            $precioneto = $pro->precioneto;
                        }else{
                            $precioneto = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                        }   
                        
                        if($pro->tipotax != 0 && $invexento == 0){
                            $total = $total + number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalGravado = $totalGravado + number_format(round((($precioneto * abs($pro->cantidad))/(1+($pro->tipotax / 100))),4), 2 ,'.','');
                            
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tipotax != 0 && $invexento == 1){
                            $total = $total + (($precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                                
                            $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }else if($pro->tipotax== 0 && $invexento == 0){
                            $total = $total + (($precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                                
                            $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }else if($pro->tipotax == 0 && $invexento == 1){
                            $total = $total + (($precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                                
                            $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                        }
                        
                        if($pro->cantrp == 0){
                            $preciouni = $pro->precioneto;                        
                        }else{
                            $preciouni = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                        }
                        
                        $precioOrg = $pro->precioventa;
                        
                        if($pro->tipo != 4){
                            $nombrepro = $pro->descrip;
                        }else{
                            $nombrepro = $pro->notas;
                        }
                        
                        //$descuento = (((number_format($preciouni, 2 ,'.','') - number_format($precioOrg, 2 ,'.','')) / $precioOrg)*100);
                        $descuento = number_format($pro->cantrp, 0 ,'.','');
                        // VALOR DE DESCUENTO
                        $valorDescuento = abs($preciouni - $pro->precioventa);
                        
                        $estructura .= '
                            <tr>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:4%;">'.$line++.'</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.$pro->modelo.'</td>
                                <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:40%;">'.$nombrepro.'</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:6%;">'.$pro->um.'</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.abs($pro->cantidad).'</td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:8%;">'.number_format($pro->precioventa, 2 ,'.','').'</td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:7%;">-'.number_format($valorDescuento, 2 ,'.','').'</td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:11%;">'.number_format($preciouni, 2 ,'.','').'</td>                            
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:7%;">'.$vnExenta.''.$vnGravada.'</td>
                            </tr>';
                        $m = $m + 1;
                        
                        if($descuento>0){
                            $estructura .= '
                                <tr>
                                    <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"></td>
                                    <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;"></td>
                                    <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">DESCUENTO</td>
                                    <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$descuento.'%</td>
                                    <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                                    <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                                </tr>';
                            $d = $d + 1;
                        }
                        
                    }
                    
                    $lineasproduct = ($m + $d);
                
                    if($lineasproduct >= 1 && $lineasproduct <= 38){
                        $contFinal = 32;
                    }else if($lineasproduct > 34 && $lineasproduct <= 44){
                        $contFinal = 38;
                    }else if($lineasproduct > 48 && $lineasproduct <= 98){
                        $contFinal = 92;
                    }else{
                        $contFinal = 141;
                    }
                    
                    for($i=$lineasproduct; $i<=$contFinal; $i++){
                        $estructura .= '
                            <tr>
                                <td style="font-size:11px; width:100%;" colspan="6"></td>
                            </tr>';
                    }
                    
                    $estructura .= '</table>';
                    
                    if(($dataPedido["idtipo"]==3) && ($totalGravado>=100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = '-'.$reten;
                        $total= $total-$reten;
                    }else{
                        $retencion = 0;
                    }
                        
                    if($retencion == 0){
                        $retencion = "";
                    }else{
                        $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                    }
                    
                    $numero = number_format(round($total, 2), 2 ,'.','');
                    $TotalLetras = $this->convertir_a_letras($numero);
                    
                    $totalIVA = number_format(round(($totalGravado * ($pro->tipotax/100)), 2), 2 ,'.',''); 
                    
                    if($invexento==1){
                        $estructura .=  '
                            <table style="padding:0px; margin:0px;">
                                <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                    <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:75%" rowspan="2"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                                    <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                                </tr>
                                <tr style="padding:0px; margin:0px;">
                                    <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                                </tr>
                                <br>
                                <tr style="padding:0px; margin:0px;">
                                    <th style="font-size:10px; text-align:left; width:100%"><strong>Pago con cheque a nombre de: ESTRATEGIA COMERCIAL INTERNACIONAL S.A. DE C.V.</strong></th>
                                </tr>
                                ';  
                    }else{
                        $estructura .=  '
                            <table style="padding:0px; margin:0px;">
                                <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                    <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:100%"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                                </tr>
                                <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                    <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>SUB-TOTAL</strong></th>
                                    <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>IVA</strong></th>
                                    <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>RETENCIÓN</strong></th>
                                    <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                                </tr>
                                <tr style="padding:0px; margin:0px;">
                                    <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($totalGravado, 2), 2 ,'.',',').'</strong></th>
                                    <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalIVA.'</strong></th>
                                    <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>'.$retencion.'</strong></th>
                                    <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                                </tr>
                                <tr style="padding:0px; margin:0px;">
                                    <th style="font-size:10px; text-align:left; width:100%"><strong>Precios Incluyen IVA<br><br></strong></th>
                                </tr>
                                ';
                    }
                    
                    $estructura .=  '
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>'.$dataPedido["notas"].'</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Autorizado por</strong></th>
                                <th style="font-size:13px; text-align:center; width:5%"></th>
                                <th style="font-size:13px; text-align:center; width:30%"></th>
                                <th style="font-size:13px; text-align:center; width:5%"></th>
                                <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Aceptado Cliente</strong></th>
                            </tr>
                        </table>';
                    
                    $pdf->setPrintFooter(false);
                    $pdf->writeHTML($estructura, true, false, true, false, '');
                    $nombre_archivo = utf8_decode("OrdenDeVenta$trannum.pdf");
                    $pdf->Output($nombre_archivo, 'I');
                }
            }

            function reporteTraslados($idtrannum){
                if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
                }else{
                    $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('TRASLADOS A SUCURSALES');
                    $pdf->SetSubject('TRASLADOS A SUCURSALES');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                    //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                    
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetMargins(5, 60, 5, 20); // set the margins 
                    //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                    $pdf->SetHeaderMargin(0,0,0,0);
                    $pdf->SetFooterMargin(0,0,0,0);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetAutoPageBreak(TRUE, 5);
                    //relación utilizada para ajustar la conversión de los píxeles
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                    // ---------------------------------------------------------
                    // establecer el modo de fuente por defecto
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    //$pdf->setPageOrientation('Portrait');
                    //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                    // Helvetica para reducir el tamaño del archivo.
                    $pdf->SetFont('Helvetica', '', 7, '', true);
                    // Añadir una página
                    // Este método tiene varias opciones, consulta la documentación para más información.
                    
                    
                    $this->load->model('invtran_model');
                    $this->load->model('global_model');
                    $this->load->model('variable_model');
                    $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                    $catalogo = $this->global_model->getCatalogoPrincipal();
                    $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                    $this->load->model('pedclientes_model');
                    $name = $this->pedclientes_model->getnameImg();
                    $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                    $funcion = $this->uri->segment(3);
                    $this->load->model('global_model');
                    $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                    foreach($info_empresa as $emp){
                        switch(round($emp->valor_num)){
                            case 1:
                                $razon = $emp->valor_memo;
                                break;
                            case 3:
                                $nrc = $emp->valor_memo;
                                break;
                            case 4:
                                $nit = $emp->valor_memo;
                                break;
                            case 5:
                                $giro = $emp->valor_memo;
                                break;
                            case 6: 
                                $direccion = $emp->valor_memo;
                                break;
                            case 7:
                                $depto_municipio = $emp->valor_memo;
                                break;
                                
                        }
                    }
                    
                    foreach($informacion as $data){
                        $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                        $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                        switch($data->estatus){
                            case 0:
                                $estado= "En proceso";
                                break;
                            case 1: 
                                $estado="Enviado";
                                break;
                            case 2:
                                $estado="Recibido";
                                break;
                            case 9: 
                                $estado="Anulado";
                                break;
                            default:
                                $estado="";
                                break;
                        }
                        
                        $estructura ='
                    <style>
                        .fondo{
                            background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                        }
                    </style>';
                    
                    $header = '<br><br>
                    <table style="width:100%;">
                        <tr>
                            <td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
                                <table style="padding:0px;margin:0px;">
                                    <tr>
                                        <td style="font-size:15px;"></td>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</td>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.' <b>NRC:</b>'.$nrc.'</td>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</td>
                                    </tr>
                                </table>
                            </td>
                            <td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="padding:0px;margin:0px;width:33.3%;">
                                <table style="padding:0px;margin:0px;">
                                    <tr>
                                        <td style="font-size:15px;"></td>
                                    </tr>
                                    <tr style="margin:0px;padding:0px;">
                                        <td style="font-size:10px; text-align:center;width:20%;"></td>
                                        <td style="font-size:15px; text-align:center;width:80%;">TRASLADOS <br>A<br> SUCURSALES</td>
                                    </tr>
                                    <tr style="margin:0px;padding:-5px;">
                                        <td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
                                        <td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$idtrannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>';
                        
                    $header .= '
                    <table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:37.5%; font-weight: bold; border: 1px solid #6E6E6E;" > Origen</td>
                            <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:37.5%; font-weight: bold; border: 1px solid #6E6E6E;" > Destino</td>
                            <td style="font-size:11px; text-align:right;width:10%;border: 1px solid #6E6E6E; background-color:#F4CE4D;">Referencia &nbsp;</td>
                            <td style="font-size:11px; text-align:left;width:15%;border: 1px solid #6E6E6E;"> '.$data->referencia.'</td>
                        </tr>
                    </table>';
                    $header .= '
                    <table style="width:100%;">
                        <tr>
                            <td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #6E6E6E;border-top: 1px solid #6E6E6E;" rowspan="2">'.$data->centrocd.'</td>
                            <td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #6E6E6E;border-top: 1px solid #6E6E6E;" rowspan="2">'.$data->idcentrod.' </td>
                            <td style="font-size:11px; text-align:right;width:10%;border: 1px solid #6E6E6E; background-color:#F4CE4D;">N° &nbsp;</td>
                            <td style="font-size:11px; text-align:left;width:15%;border: 1px solid #6E6E6E;"> '.$data->trannum.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:11px; text-align:right;width:10%;border: 1px solid #6E6E6E; background-color:#F4CE4D;">Fecha &nbsp;</td>
                            <td style="font-size:11px; text-align:left;width:15%;border: 1px solid #6E6E6E;"> '.$date_emision.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"> '.$data->encargadoinv.'</td>
                            <td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"> '.$data->encargadod.' </td>
                            <td style="font-size:11px; text-align:right;width:10%;border: 1px solid #6E6E6E; background-color:#F4CE4D;">Estado &nbsp;</td>
                            <td style="font-size:11px; text-align:left;width:15%;border: 1px solid #6E6E6E;"> '.$estado.'</td>
                        </tr>
                        </table>';
                    }
                    
                    $pdf->setHtmlHeader($header);
                    $pdf->setPrintHeader(true);
                    
                    $pdf->addPage( 'P', 'LETTER' );
                    
                    foreach($informacion as $data){
                        $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                        $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                        switch($data->estatus){
                            case 0:
                                $estado= "En proceso";
                                break;
                            case 1: 
                                $estado="Enviado";
                                break;
                            case 2:
                                $estado="Recibido";
                                break;
                            case 9: 
                                $estado="Anulado";
                                break;
                            default:
                                $estado="";
                                break;
                        }
                        
                        $titulo='<table style="width:100%;">
                        <tr style="vertical-align:middle;width:100%;">
                            <th style="width:15%; background-color: #F4CE4D; border: 1px solid black; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">CODIGO</th>
                            <th style="width:40%; background-color: #F4CE4D; border: 1px solid black; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">PRODUCTO</th>
                            <th style="width:15%; background-color: #F4CE4D; border: 1px solid black; text-align:center; vertical-align:middle; font-weight: bold; font-size:9px;">CANT.ENVIADA</th>
                            <th style="width:15%; background-color: #F4CE4D; border: 1px solid black; text-align:center; vertical-align:middle; font-weight: bold; font-size:9px;">CANT.RECIBIDA</th>
                            <th style="width:15%; background-color: #F4CE4D; border: 1px solid black; text-align:center; vertical-align:middle; font-weight: bold; font-size:9px;">CANT.DIFERENCIA</th>
                        </tr>            
                        </thead>
                        <tbody>';
                        //productos
                        
                        $productModelo = $this->invtran_model->getModeloProductos($idtrannum);
                        
                        $totalitems=0;
                        $totalcant=0;
                        
                        foreach($productModelo as $proModelo){
                            $titulo .='<tr style="border:  1px solid #6E6E6E; background-color:#A0D4A4; color:black; ">
                                            <td style="width:15%;text-align:left; border-left: 1px solid black; font-size:11px;"></td>    
                                            <td style="width:85%;text-align:left; border-right: 1px solid black; font-size:11px;" colspan="4"><strong>'.strtoupper($proModelo->modelo).'</strong></td></tr>';
                            
                            if($proModelo->modelo != 'SIN MODELO'){
                                $enviarModelo = $proModelo->modelo;
                            }else{
                                $enviarModelo = '';
                            }
                            
                            $productosPorModelo = $this->invtran_model->getProductoPorModelo($idtrannum,$enviarModelo);
                                
                                
                                foreach($productosPorModelo as $proporModel){
                                    $titulo .='<tr style="border:  1px solid #6E6E6E; ">
                                            <td style="width:15%; text-align:center; font-size:11px; border-left: 1px solid black;">'.$proporModel->idproducto.'</td>
                                            <td style="width:40%; text-align:left; font-size:11px;">'.trim($proporModel->descrip).'</td>
                                            <td style="width:15%; text-align:center; font-size:11px;">'.abs(number_format(round($proporModel->cantidad, 2),2)).'</td>
                                            <td style="width:5%; text-align:center; font-size:11px; "></td>
                                            <td style="width:5%; text-align:center; font-size:11px; border-bottom: 1px solid black"></td>
                                            <td style="width:5%; text-align:center; font-size:11px; "></td>
                                            <td style="width:5%; text-align:center; font-size:11px; "></td>
                                            <td style="width:5%; text-align:center; font-size:11px; border-bottom: 1px solid black"></td>
                                            <td style="width:5%; text-align:center; font-size:11px; border-right: 1px solid black"></td>
                                            </tr>';
                                    $totalitems++;
                                    $totalcant+= (abs($proporModel->cantidad) * 1);
                                }
                        }
                        
                        //$totalitems;
                        $titulo .='<br>
                        <tr style="border:1px solid #6E6E6E; font-size:12px;">
                            <td style="width:100%; text-align:center; vertical-align:middle; padding:0px; font-size:12px; border:1px solid black;" colspan="5"><strong>TOTAL UNIDADES: '.abs(round($totalcant, 2)).'</strong></td>
                        </tr>
                        </tbody>
                        </table>';
                        //fin tabla productos. 
                        $titulo .= '
                        <table>
                        <tr>
                            <td style="width:100%;"><br><br></td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:33.3%; font-weight:bold; border: 1px solid #6E6E6E;">Revisado Por</td>
                            <td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:33.3%; font-weight:bold; border: 1px solid #6E6E6E;">Transportado Por</td>
                            <td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:33.3%; font-weight:bold; border: 1px solid #6E6E6E;">Recibido Por</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid #6E6E6E;"><br><br><br><p style="font-size:12px; text-align:center; background-color:#F4CE4D; width:100%; font-weight:bold; border: 1px solid #6E6E6E;">Fecha y Hora</p></td>
                            <td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid #6E6E6E;"><br><br><br><br><br><br><br><br></td>
                            <td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid #6E6E6E;"><br><br><br><p style="font-size:12px; text-align:center; background-color:#F4CE4D; width:100%; font-weight:bold; border: 1px solid #6E6E6E;">Fecha y Hora</p></td>
                        </tr>
                    </table><br><br><br>';
                        
                    }   
                    $pdf->writeHTML($titulo, true, false, true, false, '');
                        
                    
                    //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                    $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                    $pdf->Output($nombre_archivo, 'I');
                }
            }
        //-

        function zebra_labelsOld($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
			}else{
				ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);

				$this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model'); $this->load->model('scan_model');
				$this->load->model('ventas_model');
                $printerName = $this->global_model->getValorTextoVariable("print_etiquetas");
                $comandosTM = new comandosTM();

                $num_rows=0;$cant = 0; 
                $coordActualY = 16; //Coordenada Y inicial -> 0.625 + 0.5 ...

				$array_empresa = explode(" ", $this->session->userdata('descrip'));
				$listado_products = $this->scan_model->getProductsOrderEspecificoOrderByItemLine($trannum);
				$primera = true;
				$actual=0;
				$array_datos = array();
				$count_array_datos = 0;
                $cmds = "^BY1^CI0";
				if($listado_products!=false){
                    //$this->highlight_array($listado_products);
					foreach($listado_products as $pro){
						$proModelo   	= $this->eliminarTildes($pro->descrip);
						$proColor    	= $this->eliminarTildes($pro->um);
						$proPresenta 	= $this->eliminarTildes($pro->presenta);
						$info_product = $this->scan_model->getDatosProduct($pro->idproducto);
                        $precioventa = number_format($pro->precioventa, 2, '.', '');
						$cant_etiquetas = $pro->cantidad;
						$actual = 0;
                        $baseX = 0;

                        $n = strlen(trim($pro->modelo));
                        if($n < 2){
                            $baseX = 80;
                        }else if($n >= 2 && $n < 3){
                            $baseX = 70;
                        }else if($n >= 3 && $n < 4){
                            $baseX = 60;
                        }else if($n >= 4 && $n < 5){
                            $baseX = 50;
                        }else if($n >= 5 && $n < 6){
                            $baseX = 40;
                        }else{
                            $baseX = 30;
                        }

                        $descrip = substr($pro->descrip,0,25);
                        $descrip2 = substr($pro->descrip,25,25);

                        while($actual<$cant_etiquetas){                        
                            switch($cant){
                                case 0:
                                    $cmds .= "^XA";
                                    $cmds .= "^FO".$baseX.",025,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO030,110^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO030,125^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";

                                    $cant++;
                                    break;
                                    
                                case 1:
                                    $cmds .= "^FO".($baseX + 280).",025,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO0310,110^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO0310,125^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";

                                    $cant++;
                                    break;
                                case 2:
                                    $cmds .= "^FO".($baseX + 560).",025,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO0590,110^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO0590,125^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";
                                    $cmds .= "^XZ";
                                    
                                    $cant=0;
                                    break;
                            }
                            
                            $actual++;
                        }
					}
                    $cmds .= "^XZ";
				}	

				$this->ventas_model->setCommandsPrint('ZL'.$trannum, $cmds, 2);
                $trannum='ZL'.$trannum;
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;

                //ZDesigner ZD220-203dpi ZPL
			}
		}

        function zebra_labelsCompraOld($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
			}else{
				ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);

				$this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model'); $this->load->model('scan_model');
				$this->load->model('ventas_model');
                $comandosTM = new comandosTM();
                $printerName = $this->global_model->getValorTextoVariable("print_etiquetas");

                $num_rows=0;$cant = 0; 
                $coordActualY = 16; //Coordenada Y inicial -> 0.625 + 0.5 ...

				$array_empresa = explode(" ", $this->session->userdata('descrip'));
                $listado_products = $this->compras_model->getProductosCompraOrderByItemLine($trannum);

				$primera = true;
				$actual=0;
				$array_datos = array();
				$count_array_datos = 0;
                $cmds = "^BY1^CI0";
				if($listado_products!=false){
					foreach($listado_products as $pro){
						$proModelo   	= $this->eliminarTildes($pro->descrip);
						$proColor    	= $this->eliminarTildes($pro->um);
						$proPresenta 	= $this->eliminarTildes($pro->presenta);
						$info_product = $this->scan_model->getDatosProduct($pro->idproducto);
                        $precioventa = number_format($pro->precioventa, 2, '.', '');
						$cant_etiquetas = $pro->cantidad;

                        $actual = 0;
                        $baseX = 0;
                        $n = strlen(trim($pro->modelo));
                        if($n < 2){
                            $baseX = 80;
                        }else if($n >= 2 && $n < 3){
                            $baseX = 70;
                        }else if($n >= 3 && $n < 4){
                            $baseX = 60;
                        }else if($n >= 4 && $n < 5){
                            $baseX = 50;
                        }else if($n >= 5 && $n < 6){
                            $baseX = 40;
                        }else{
                            $baseX = 30;
                        }
                        $descrip = substr($pro->descrip,0,25);
                        $descrip2 = substr($pro->descrip,25,25);

                        while($actual<$cant_etiquetas){    
                            switch($cant){
                                case 0:
                                    $cmds .= "^XA";
                                    $cmds .= "^FO".$baseX.",025,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO030,110^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO030,125^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";

                                    $cant++;
                                    break;
                                    
                                case 1:
                                    $cmds .= "^FO".($baseX + 280).",025,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO0310,110^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO0310,125^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";

                                    $cant++;
                                    break;
                                case 2:
                                    $cmds .= "^FO".($baseX + 560).",025,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO0590,110^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO0590,125^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";
                                    $cmds .= "^XZ";
                                    
                                    $cant=0;
                                    break;
                            }
                            $actual++;
                        }
					}
                    $cmds .= "^XZ";
				}	

				$this->ventas_model->setCommandsPrint('ZLC'.$trannum, $cmds, 2);
                $trannum='ZLC'.$trannum;
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;

                //ZDesigner ZD220-203dpi ZPL
			}
		}

        function zebra_labels($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
			}else{
				ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);

				$this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model'); $this->load->model('scan_model');
				$this->load->model('ventas_model');
                $printerName = $this->global_model->getValorTextoVariable("print_etiquetas");
                $comandosTM = new comandosTM();

                $num_rows=0;$cant = 0; 
                $coordActualY = 16; //Coordenada Y inicial -> 0.625 + 0.5 ...

				$array_empresa = explode(" ", $this->session->userdata('descrip'));
				$listado_products = $this->scan_model->getProductsOrderEspecificoOrderByItemLine($trannum);
				$primera = true;
				$actual=0;
				$array_datos = array();
				$count_array_datos = 0;
                $cmds = "^BY1^CI0";
				if($listado_products!=false){
                    //$this->highlight_array($listado_products);
					foreach($listado_products as $pro){
						$proModelo   	= $this->eliminarTildes($pro->descrip);
						$proColor    	= $this->eliminarTildes($pro->um);
						$proPresenta 	= $this->eliminarTildes($pro->presenta);
						$info_product = $this->scan_model->getDatosProduct($pro->idproducto);
                        $precioventa = number_format($pro->precioventa, 2, '.', '');
						$cant_etiquetas = $pro->cantidad;
						$actual = 0;
                        $baseX = 0;

                        $n = strlen(trim($pro->modelo));
                        if($n < 2){
                            $baseX = 80;
                        }else if($n >= 2 && $n < 3){
                            $baseX = 70;
                        }else if($n >= 3 && $n < 4){
                            $baseX = 60;
                        }else if($n >= 4 && $n < 5){
                            $baseX = 50;
                        }else if($n >= 5 && $n < 6){
                            $baseX = 40;
                        }else{
                            $baseX = 30;
                        }

                        $descrip = substr($pro->descrip,0,25);
                        $descrip2 = substr($pro->descrip,25,25);

                        while($actual<$cant_etiquetas){
                            switch($cant){
                                case 0:
                                    $cmds .= "^XA";
                                    $cmds .= "^FO".$baseX.",020,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO030,103^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO030,118^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO140,135^ACN,18,10^FD".$comandosTM->padText("$".number_format($pro->precioventa, 2, '.', ','),10, 'LEFT')."^FS";

                                    $cant++;
                                    break;
                                    
                                case 1:
                                    $cmds .= "^FO".($baseX + 280).",020,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO0310,103^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO0310,118^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO418,135^ACN,11,07^FD".$comandosTM->padText("$".number_format($pro->precioventa, 2, '.', ','),10, 'LEFT')."^FS";

                                    $cant++;
                                    break;
                                case 2:
                                    $cmds .= "^FO".($baseX + 560).",020,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO0590,103^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO0590,118^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO698,135^ACN,11,07^FD".$comandosTM->padText("$".number_format($pro->precioventa, 2, '.', ','),10, 'LEFT')."^FS";
                                    $cmds .= "^XZ";
                                    
                                    $cant=0;
                                    break;
                            }
                            
                            $actual++;
                        }
					}
                    $cmds .= "^XZ";
				}	

				$this->ventas_model->setCommandsPrint('ZL'.$trannum, $cmds, 2);
                $trannum='ZL'.$trannum;
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;

                //ZDesigner ZD220-203dpi ZPL
			}
		}

        function zebra_labelsCompra($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
			}else{
				ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);

				$this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model'); $this->load->model('scan_model');
				$this->load->model('ventas_model');
                $comandosTM = new comandosTM();
                $printerName = $this->global_model->getValorTextoVariable("print_etiquetas");

                $num_rows=0;$cant = 0; 
                $coordActualY = 16; //Coordenada Y inicial -> 0.625 + 0.5 ...

				$array_empresa = explode(" ", $this->session->userdata('descrip'));
                $listado_products = $this->compras_model->getProductosCompraOrderByItemLine($trannum);

				$primera = true;
				$actual=0;
				$array_datos = array();
				$count_array_datos = 0;
                $cmds = "^BY1^CI0";
				if($listado_products!=false){
					foreach($listado_products as $pro){
						$proModelo   	= $this->eliminarTildes($pro->descrip);
						$proColor    	= $this->eliminarTildes($pro->um);
						$proPresenta 	= $this->eliminarTildes($pro->presenta);
						$info_product = $this->scan_model->getDatosProduct($pro->idproducto);
                        $precioventa = number_format($pro->precioventa, 2, '.', '');
						$cant_etiquetas = $pro->cantidad;

                        $actual = 0;
                        $baseX = 0;
                        $n = strlen(trim($pro->modelo));
                        if($n < 2){
                            $baseX = 80;
                        }else if($n >= 2 && $n < 3){
                            $baseX = 70;
                        }else if($n >= 3 && $n < 4){
                            $baseX = 60;
                        }else if($n >= 4 && $n < 5){
                            $baseX = 50;
                        }else if($n >= 5 && $n < 6){
                            $baseX = 40;
                        }else{
                            $baseX = 30;
                        }
                        $descrip = substr($pro->descrip,0,25);
                        $descrip2 = substr($pro->descrip,25,25);

                        while($actual<$cant_etiquetas){    
                            switch($cant){
                                case 0:
                                    $cmds .= "^XA";
                                    $cmds .= "^FO".$baseX.",020,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO030,103^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO030,118^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO140,135^ACN,18,10^FD".$comandosTM->padText("$".number_format($pro->precioventa, 2, '.', ','),10, 'LEFT')."^FS";

                                    $cant++;
                                    break;
                                    
                                case 1:
                                    $cmds .= "^FO".($baseX + 280).",020,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO0310,103^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO0310,118^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO418,135^ACN,11,07^FD".$comandosTM->padText("$".number_format($pro->precioventa, 2, '.', ','),10, 'LEFT')."^FS";

                                    $cant++;
                                    break;
                                case 2:
                                    $cmds .= "^FO".($baseX + 560).",020,^BCN,60,Y,N,N^FD".trim($pro->modelo)."^FS";
                                    $cmds .= "^FO0590,103^ABN,05,10^FD".$comandosTM->padText($descrip, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO0590,118^ABN,05,10^FD".$comandosTM->padText($descrip2, 25, 'BOTH')."^FS";
                                    $cmds .= "^FO698,135^ACN,11,07^FD".$comandosTM->padText("$".number_format($pro->precioventa, 2, '.', ','),10, 'LEFT')."^FS";
                                    $cmds .= "^XZ";
                                    
                                    $cant=0;
                                    break;
                            }
                            $actual++;
                        }
					}
                    $cmds .= "^XZ";
				}	

				$this->ventas_model->setCommandsPrint('ZLC'.$trannum, $cmds, 2);
                $trannum='ZLC'.$trannum;
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;

                //ZDesigner ZD220-203dpi ZPL
			}
		}

        function registroControlInventariosExcel($idproducto, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$objPHPExcel = new Spreadsheet();
				$objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Reporte de Kardex") // Titulo
                ->setSubject("Reporte de Kardex") //Asunto
                ->setDescription("Reporte de Kardex") //Descripción
                ->setKeywords("Reporte de Kardex") //Etiquetas
                ->setCategory("Reporte de Kardex"); //Categorias
				$objPHPExcel->setActiveSheetIndex(0);

				/* Estilos */
                    $style_titulo = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 20,
                            'name'  => 'Verdana'
                        )
                    );

                    $style_subtitulo = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'color' => array('rgb' => '000000'),
                            'size'  => 15,
                            'name'  => 'Verdana'
                        )
                    );

                    $style_header_tabla = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'bold' => true,
                            'color' => array('rgb' => str_replace('#', '', $this->session->userdata('hdFontcolor'))),
                            'size'  => 11,
                            'name'  => 'Calibri'
                        ),
                        'fill' => [
                            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'startColor' => [
                                'rgb' => str_replace('#', '', $this->session->userdata('hdBackground')),
                            ],
                        ],
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['rgb' => str_replace('#', '', $this->session->userdata('hdFontcolor'))],
                            ],
                        ],
                    );

                    $style_categoria = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 12,
                            'name'  => 'Verdana'
                        )
                    );

                    $style_num = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'bold' => false,
                            'size'  => 11,
                            'color' => array('rgb' => '000000'),
                            'name'  => 'Calibri'
                        ),
                        'numberFormat' => [
                            'formatCode' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER
                        ]
                    );

                    $style_num_total = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 11,
                            'name'  => 'Calibri'
                        ),
                        'numberFormat' => [
                            'formatCode' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE
                        ]
                    );

                    $style_total = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 11,
                            'name'  => 'Calibri'
                        )
                    );

                    $style_bordes = array(
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['argb' => '000000'],
                            ],
                        ],
                    );

                    $style_bordes_all = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'bold' => true,
                            'size'  => 11,
                            'name'  => 'Calibri'
                        ),
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['argb' => '000000'],
                            ],
                        ],
                    );

                    $style_num_porcentaje = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'size'  => 11,
                            'bold' => false,
                            'color' => array('rgb' => '000000'),
                            'name'  => 'Verdana'
                        ),
                        'numberFormat' => [
                            'code' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
                        ]
                    );

                    $style_align_center = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                    );

                    $style_text_bold = array(
                        'font'  => array(
                            'bold' => true,
                        ),
                    );

                    $style_subtitulo_color = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'color' => array('rgb' => str_replace('#', '', $this->session->userdata('hdFontcolor'))),
                            'size'  => 15,
                            'name'  => 'Calibri'
                        )
                    );
                /* */
               
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
            
                $this->load->model('invtran_model');
                $this->load->model('auxi_model');
                $this->load->model('producto_model');
                $this->load->model('global_model');

                $function = $this->uri->segment(3);

                $nit = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $nrc = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                $nombre_doc = "Reporte de Kardex";

                $arrayIdProducto = explode("-", $idproducto);
                $hojaTrabajoActual = 0;

                foreach($arrayIdProducto as $idproducto){
                    //SI HAY MÁS DE UN PRODUCTO
                    //CREA UNA NUEVA HOJA DE TRABAJO
                    if($hojaTrabajoActual>0){
                        $objPHPExcel->createSheet();
                        $objPHPExcel->setActiveSheetIndex($hojaTrabajoActual);
                    }

                    //DATOS DEL PRODUCTO
                    $fichaProducto = $this->producto_model->getProducto($idproducto);

                    /* ENCABEZADOS */
                        $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(20);
                        $objPHPExcel->getActiveSheet()->setCellValue('A1', $nombre_doc);
                        $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($style_titulo);
                        $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');


                        $objPHPExcel->getActiveSheet()->setCellValue('A2', $this->session->userdata('descrip'));
                        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_subtitulo);
                        $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
                    /* */

                    /*  DATOS DEL PRODUCTO  */
                        $objPHPExcel->getActiveSheet()->setTitle('Reporte de Kardex');

                        $objPHPExcel->getActiveSheet()->setCellValue('A4', "UNIDAD DE MEDIDA: ".strtoupper($fichaProducto->um));
                        $objPHPExcel->getActiveSheet()->mergeCells('A4:D4');

                        $objPHPExcel->getActiveSheet()->setCellValue('E4', "NIT: ".$nit);
                        $objPHPExcel->getActiveSheet()->mergeCells('E4:F4');

                        $objPHPExcel->getActiveSheet()->setCellValue('G4', "NRC: ".$nrc);
                        $objPHPExcel->getActiveSheet()->mergeCells('G4:H4');

                        $objPHPExcel->getActiveSheet()->setCellValue('I4', "PERIODO: ". date_format(date_create($fechaini),'d/m/Y')." - ".  date_format(date_create($fechafin),'d/m/Y') );
                        $objPHPExcel->getActiveSheet()->mergeCells('I4:K4');

                        $objPHPExcel->getActiveSheet()->setCellValue('L4', "CÓDIGO: ".strtoupper($fichaProducto->modelo));
                        $objPHPExcel->getActiveSheet()->mergeCells('L4:N4');
                        $objPHPExcel->getActiveSheet()->getStyle('A4:N4')->applyFromArray($style_header_tabla);

                        $objPHPExcel->getActiveSheet()->setCellValue('A5', strtoupper($fichaProducto->descrip));
                        $objPHPExcel->getActiveSheet()->getStyle('A5')->applyFromArray($style_header_tabla);
                        $objPHPExcel->getActiveSheet()->getStyle('A5')->applyFromArray($style_subtitulo_color);

                        $objPHPExcel->getActiveSheet()->mergeCells('A5:N5');

                        //NOMBRE DE LA HOJA DE TRABAJO
                        $objPHPExcel->getActiveSheet()->setTitle(substr(strtoupper($fichaProducto->descrip),0,31));

                    /* */

                    /*  ANCHOS DE COLUMNAS   */
                        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(27);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(17);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(17);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(17);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(12);
                    /* */

                    /*  ENCABEZADOS TABLA DE MOVIMIENTOS */
                        $objPHPExcel->getActiveSheet()->SetCellValue('A6', 'NO.');
                        $objPHPExcel->getActiveSheet()->mergeCells('A6:A7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('B6', 'FECHA');
                        $objPHPExcel->getActiveSheet()->mergeCells('B6:B7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('C6', 'NO. DOC.');
                        $objPHPExcel->getActiveSheet()->mergeCells('C6:C7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('D6', 'DESCRIPCIÓN');
                        $objPHPExcel->getActiveSheet()->mergeCells('D6:D7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('E6', 'PROVEEDOR');
                        $objPHPExcel->getActiveSheet()->mergeCells('E6:E7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('F6', 'NACIONALIDAD');
                        $objPHPExcel->getActiveSheet()->mergeCells('F6:F7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('G6', 'DESCRIPCIÓN DEL PRODUCTO');
                        $objPHPExcel->getActiveSheet()->mergeCells('G6:H6');

                        $objPHPExcel->getActiveSheet()->SetCellValue('G7', 'PRECIO UNITARIO');

                        $objPHPExcel->getActiveSheet()->SetCellValue('H7', 'COSTO PROMEDIO');

                        $objPHPExcel->getActiveSheet()->SetCellValue('I6', 'UNIDADES');
                        $objPHPExcel->getActiveSheet()->mergeCells('I6:K6');

                        $objPHPExcel->getActiveSheet()->SetCellValue('I7', 'ENTRADAS');

                        $objPHPExcel->getActiveSheet()->SetCellValue('J7', 'SALIDAS');

                        $objPHPExcel->getActiveSheet()->SetCellValue('K7', 'SALDO');

                        $objPHPExcel->getActiveSheet()->SetCellValue('L6', 'VALORES');
                        $objPHPExcel->getActiveSheet()->mergeCells('L6:N6');

                        $objPHPExcel->getActiveSheet()->SetCellValue('L7', 'DEBE');

                        $objPHPExcel->getActiveSheet()->SetCellValue('M7', 'HABER');

                        $objPHPExcel->getActiveSheet()->SetCellValue('N7', 'SALDO');

                        $objPHPExcel->getActiveSheet()->getStyle('A6:N7')->applyFromArray($style_bordes_all);
                    /* */

                    
                    //DATOS INICIALES
                    $resultado = [];
                    $i = 1;
                    $costopromedio = 0;
                    $saldoInicialValores = 0;
                    $saldoInicialUnidades = 0;
                    $filaActual = 8;

                    //TOTALES
                    $totalEntradas = 0;
                    $totalSalidas = 0;
                    $totalDebe = 0;
                    $totalHaber = 0;                
                    $transaccionesIniciales = $this->invtran_model->getDatosPreviosF142($idcentro, $idproducto, $fechaini); 

                    //$this->highlight_array($transaccionesIniciales);
                    foreach($transaccionesIniciales as $tran){
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                    

                        //SALIDA
                        if($tran['inopera'] == -1){
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            //$totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorHaber;
                            //$totalHaber += $valorHaber;

                        
                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            //$totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            //$totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];
                        }
                    }

                    if($saldoInicialUnidades != 0){
                        $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                    }

                    $fecha = date_format(date_create($fechaini),'d/m/Y');

                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$filaActual, $i);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, $fecha);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$filaActual, 'SALDO INICIAL');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$filaActual, $costopromedio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, $saldoInicialUnidades);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$filaActual, $saldoInicialValores);
                    
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':C'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('I'.$filaActual.':N'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.00_-;-* #,##0.00_-;_-* "-"??_-;_-@_-');
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_bordes);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    $filaActual++;
                    
                    //DATOS DE LAS TRANSACCIONES
                    $transacciones = $this->invtran_model->getDatosF142($idcentro, $idproducto, $fechaini, $fechafin);

                    foreach($transacciones as $tran){
                        $i++;
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                        $nacionalidad = '';
                        $descripProveedor = '';

                        //calculo del costo promedio 
                        //se toman los saldos del registro anterior
                        if($saldoInicialUnidades != 0){
                            $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                        }

                        //SALIDA
                        if($tran['inopera'] == -1){ 
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            $totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$costopromedio;
                            $saldoInicialValores += $valorHaber;
                            $totalHaber += $valorHaber;

                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            $totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            $totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];

                            if($tran['agrupa'] == 'CO'){
                                //DATOS DEL PROVEEDOR SI ES COMPRA
                                if(array_key_exists('pais',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                    $nacionalidad = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['pais'];
                                }
        
                                if(array_key_exists('descrip',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                    $descripProveedor = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['descrip'];
                                }
                            }
                        }
                        $fecha = date_format(date_create($tran['fecha']),'d/m/Y');

                        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$filaActual, $i);
                        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, $fecha);
                        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$filaActual, $tran['serie'].$tran['numero']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$filaActual, $tran['descripDoc']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$filaActual, $descripProveedor);
                        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$filaActual, $nacionalidad);
                        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$filaActual, $precioUnitario);
                        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$filaActual,  $costopromedio);
                        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$filaActual, abs($unidadEntrada));
                        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$filaActual, abs($unidadSalida));
                        $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, $saldoInicialUnidades);
                        $objPHPExcel->getActiveSheet()->SetCellValue('L'.$filaActual,  abs($valorDebe));
                        $objPHPExcel->getActiveSheet()->SetCellValue('M'.$filaActual, abs($valorHaber));
                        $objPHPExcel->getActiveSheet()->SetCellValue('N'.$filaActual, $saldoInicialValores);

                        $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':C'.$filaActual)->applyFromArray($style_align_center);
                        $objPHPExcel->getActiveSheet()->getStyle('G'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.000000_-;-* #,##0.000000_-;_-* "-"??_-;_-@_-');
                        $objPHPExcel->getActiveSheet()->getStyle('I'.$filaActual.':N'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.00_-;-* #,##0.00_-;_-* "-"??_-;_-@_-');
                        $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_bordes);

                        
                        $filaActual++;
                    }

                    //SALDO FINAL
                    $i++;
                
                    $fecha = date_format(date_create($fechafin),'d/m/Y');

                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$filaActual, $i);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, $fecha);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$filaActual, 'SALDO FINAL');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$filaActual,  $costopromedio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$filaActual, abs($totalEntradas));
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$filaActual, abs($totalSalidas));
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, $saldoInicialUnidades);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$filaActual,  abs($totalDebe));
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$filaActual, abs($totalHaber));
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$filaActual, $saldoInicialValores);

                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':C'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('I'.$filaActual.':N'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.00_-;-* #,##0.00_-;_-* "-"??_-;_-@_-');
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_bordes);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    $filaActual +=5;

                    //FIRMAS 
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, 'F. __________________________________');
                    $objPHPExcel->getActiveSheet()->mergeCells('B'.$filaActual.':D'.$filaActual);

                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, 'F. __________________________________');
                    $objPHPExcel->getActiveSheet()->mergeCells('K'.$filaActual.':M'.$filaActual);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    $filaActual++;

                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, 'Representante Legal y/o Propietario');
                    $objPHPExcel->getActiveSheet()->mergeCells('B'.$filaActual.':D'.$filaActual);

                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, 'Encargado de Bodega');
                    $objPHPExcel->getActiveSheet()->mergeCells('K'.$filaActual.':M'.$filaActual);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    //AUMENTA EL NUMERO DE HOJAS DE TRABAJO
                    $hojaTrabajoActual++;
                }

				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header('Content-Disposition: attachment;filename="Reporte de Kardex.xlsx"');
				header('Cache-Control: max-age=0');
				$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
				$objWriter->save('php://output'); 
				exit;
            }
        }

        function registroControlInventariosPdf($idproducto, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle("Reporte de Kardex");
                $pdf->SetSubject("Reporte de Kardex");

                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                $pdf->SetFont('Helvetica', '', 8, '', true);
                $pdf->SetAutoPageBreak(TRUE, 10);
                $function = $this->uri->segment(3);

                $inicioY = 38;
                $nombre_doc = "Reporte de Kardex";

                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
            
                $this->load->model('invtran_model');
                $this->load->model('auxi_model');
                $this->load->model('producto_model');
                $this->load->model('global_model');

                $arrayIdProducto = explode("-", $idproducto);

                foreach($arrayIdProducto as $idproducto){
                    $pdf->resetHeaderTemplate();
                    $fichaProducto = $this->producto_model->getProducto($idproducto);
                    $nit = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $nrc = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                    $header = '<table style="width:100%; padding:0;">';
                        $header .= '<tr style="font-size: 15px">';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; font-weight: bold"></td>';
                        $header .= '<td style="text-align: center; width: 60%; padding: 0; font-weight: bold">'.$this->session->userdata('descrip').'</td>';
                        $header .= '<td style="text-align: right; width: 20%; padding: 0; font-weight: bold; "></td>';
                        $header .= '</tr>';

                        $header .= '<tr style="font-size: 15px">';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; font-weight: bold"></td>';
                        $header .= '<td style="text-align: center; width: 60%; padding: 0; font-weight: bold">'.strtoupper($nombre_doc).'</td>';
                        $header .= '<td style="text-align: right; width: 20%; padding: 0; font-weight: bold; "></td>';
                        $header .= '</tr>';

                        $header .= '<tr style="font-size: 15px">';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; font-weight: bold"></td>';
                        $header .= '<td style="text-align: center; width: 60%; padding: 0; font-weight: bold">'.strtoupper($fichaProducto->descrip).'</td>';
                        $header .= '<td style="text-align: right; width: 20%; padding: 0; font-weight: bold; "></td>';
                        $header .= '</tr>';

                        $header .= '<tr>';
                        $header .= '<td style="text-align: center; width: 100%; padding: 0; font-weight: bold"></td>';
                        $header .= '</tr>';

                        $header .= '<tr style="font-size: 12px">';
                        $header .= '<td style="text-align: center; width: 30%; padding: 0; border: 1px solid black; font-weight: bold">UNIDAD DE MEDIDAS</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black; font-weight: bold">NIT</td>';
                        $header .= '<td style="text-align: center; width: 10%; padding: 0; border: 1px solid black; font-weight: bold">NRC</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black; font-weight: bold">PERIODO</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black; font-weight: bold">CÓDIGO</td>';
                        $header .= '</tr>';

                        $header .= '<tr style="font-size: 12px">';
                        $header .= '<td style="text-align: center; width: 30%; padding: 0; border: 1px solid black;">'.strtoupper($fichaProducto->um).'</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black;">'.$nit.'</td>';
                        $header .= '<td style="text-align: center; width: 10%; padding: 0; border: 1px solid black;">'.$nrc.'</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black;">'.date_format(date_create($fechaini),'d/m/Y').' - '.date_format(date_create($fechafin),'d/m/Y').'</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black;">'.strtoupper($fichaProducto->modelo).'</td>';
                        $header .= '</tr>';
                    $header .= '</table>';
                    $pdf->setHtmlHeader($header);
                    
                    $pdf->SetPrintHeader(true);
                    $pdf->SetMargins(8, $inicioY, 8, true);

                    //  FOOTER
                    date_default_timezone_set('America/El_Salvador');
                    $date = new DateTime();
                    $footer = '<br><br><br><br><table style="width:100%;font-size: 12px;">';
                    $footer .= '<tr>';
                    $footer .= '<td style="text-align: left; width: 50%; padding: 0; ">'.date_format($date, 'd/m/Y h:i a').'</td>';
                    $footer .= '<td style="text-align: right; width: 50%; padding: 0; ">PÁG. '.trim($pdf->getAliasNumPage()).'/'.trim($pdf->getAliasNbPages()).'</td>';

                    $footer .= '</tr>';
                    $footer .= '</table>';
                    $pdf->SetFooterMargin(0, 0, 0, 0);
                    $pdf->setHtmlFooter($footer);
                    $pdf->SetPrintFooter(true);

                    //DATOS INICIALES
                    $resultado = [];

                    $costopromedio = 0;
                    $saldoInicialValores = 0;
                    $saldoInicialUnidades = 0;
                    $filaActual = 8;
                    $i = 1;

                    //TOTALES
                    $totalEntradas = 0;
                    $totalSalidas = 0;
                    $totalDebe = 0;
                    $totalHaber = 0;                
                    $transaccionesIniciales = $this->invtran_model->getDatosPreviosF142($idcentro, $idproducto, $fechaini); 

                    $tabla = '<table style="width:100%; padding:0;">';
                    $tabla .= '<tr style="font-size: 8px">';
                    $tabla .= '<td style="width: 3%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">NO.</td>';
                    $tabla .= '<td style="width: 5%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">FECHA</td>';
                    $tabla .= '<td style="width: 11%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">NO. DOC.</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">DESCRIPCIÓN</td>';
                    $tabla .= '<td style="width: 11%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">PROVEEDOR</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">NACIONALIDAD</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">PRE. UNI.</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">CTO. PROM.</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">ENTRADAS</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">SALIDAS</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">SALDO</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">DEBE</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">HABER</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">SALDO</td>';
                    $tabla .= '</tr>';
                    //$this->highlight_array($transaccionesIniciales);
                    foreach($transaccionesIniciales as $tran){
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                    

                        //SALIDA
                        if($tran['inopera'] == -1){
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            //$totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorHaber;
                            //$totalHaber += $valorHaber;

                        
                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            //$totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            //$totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];
                        }
                    }

                    if($saldoInicialUnidades != 0){
                        $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                    }

                    $fecha = date_format(date_create($fechaini),'d/m/Y');

                    $tabla .= '<tr style="font-size: 8px">';
                    $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; font-weight: bold">'.$i.'</td>';
                    $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; font-weight: bold">'.$fecha.'</td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold">SALDO INICIAL</td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format($costopromedio, 6, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format($saldoInicialUnidades, 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format($saldoInicialValores, 2, '.','').'</td>';
                    $tabla .= '</tr>';
                
                    
                    //DATOS DE LAS TRANSACCIONES
                    $transacciones = $this->invtran_model->getDatosF142($idcentro, $idproducto, $fechaini, $fechafin);

                    foreach($transacciones as $tran){
                        $i++;
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                        $nacionalidad = '';
                        $descripProveedor = '';

                        //calculo del costo promedio 
                        //se toman los saldos del registro anterior
                        if($saldoInicialUnidades != 0){
                            $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                        }

                        //SALIDA
                        if($tran['inopera'] == -1){ 
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            $totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$costopromedio;
                            $saldoInicialValores += $valorHaber;
                            $totalHaber += $valorHaber;

                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            $totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            $totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];

                            if($tran['agrupa'] == 'CO'){
                                //DATOS DEL PROVEEDOR SI ES COMPRA
                                if(array_key_exists('pais',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                    $nacionalidad = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['pais'];
                                }
        
                                if(array_key_exists('descrip',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                    $descripProveedor = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['descrip'];
                                }
                            }
                        }
                        $fecha = date_format(date_create($tran['fecha']),'d/m/Y');

                        $tabla .= '<tr style="font-size: 8px">';
                        $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; ">'.$i.'</td>';
                        $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; ">'.$fecha.'</td>';
                        $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; ">'.$tran['serie'].$tran['numero'].'</td>';
                        $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; ">'.$tran['descripDoc'].'</td>';
                        $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; ">'.$descripProveedor.'</td>';
                        $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; ">'.$nacionalidad.'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format($precioUnitario, 6, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format($costopromedio, 6, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format(abs($unidadEntrada), 2, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format(abs($unidadSalida), 2, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format($saldoInicialUnidades, 2, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format(abs($valorDebe), 2, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format(abs($valorHaber), 2, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format($saldoInicialValores, 2, '.','').'</td>';
                        $tabla .= '</tr>';

                    }

                    $i++;
                    $tabla .= '<tr style="font-size: 8px">';
                    $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; font-weight: bold">'.$i.'</td>';
                    $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; font-weight: bold">'.$fecha.'</td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold">SALDO FINAL</td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format($costopromedio, 6, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format(abs($totalEntradas), 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format(abs($totalSalidas), 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format($saldoInicialUnidades, 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'. number_format(abs($totalDebe), 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'. number_format(abs($totalHaber), 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'. number_format($saldoInicialValores, 2, '.','').'</td>';
                    $tabla .= '</tr>';

                    $tabla .= '</table>';
                    $pdf->addPage('L', 'LETTER');
                    $pdf->SetY( $inicioY );            
                    $pdf->writeHTML($tabla, true, false, true, false, ''); 
                }

				//var_dump($info);
                $nombre_archivo = utf8_decode("Reporte_Kardex.pdf");
                $pdf->Output($nombre_archivo, 'I');
				exit;
            }
        }

        //Facturación DTE
        function facturaConsumidorFinalDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/facturaConsumidorFinalDTE/' . $trannum);
            }
        }

        function comprobanteCreditoFiscalDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/comprobanteCreditoFiscalDTE/' . $trannum);
            }
        }

        function facturaDeExportacionDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/facturaDeExportacionDTE/' . $trannum);
            }
        }

        function notaDeCreditoDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/notaDeCreditoDTE/' . $trannum);
            }
        }

        //Formatos personalizados DTE
        function facturaConsumidorFinalElectronicBills($trannum, $idYear = 0, $docToSend = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->model('dev_model');
                $this->load->model('dte_model');
                $this->load->model('global_model');
                $this->load->model('pedclientes_model');
                $this->load->model('ventas_model');

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Documento Tributario Electrónico');
                $pdf->SetSubject('Documento Tributario Electrónico');
                $pdf->SetMargins(7.5, 10.5, 9, true);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetAutoPageBreak(TRUE, 7);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('helvetica', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                $x = 3; $y = 3;

                $informacion = $this->dev_model->electronicBills($trannum, $idYear);

                foreach($informacion as $info){
                    $jsonInfo = $info['jsonDoc'];
                    $sRecepcion = $info['sRecepcion'];
                    $respHacienda = $info['respHacienda'];
                    $firmaJson = $info['firmaJson'];
                }

                if(isset($jsonInfo['identificacion'])) $identificacion = $jsonInfo['identificacion'];
                if(isset($jsonInfo['documentoRelacionado'])) $documentoRelacionado = $jsonInfo['documentoRelacionado'];
                if(isset($jsonInfo['emisor'])) $emisor = $jsonInfo['emisor'];
                if(isset($emisor['direccion'])) $direcEmisor = $emisor['direccion'];
                if(isset($jsonInfo['receptor'])) $receptor = $jsonInfo['receptor'];
                if(isset($jsonInfo['sujetoExcluido'])) $sujetoExcluido = $jsonInfo['sujetoExcluido'];
                if(isset($receptor['direccion'])) $direcReceptor = $receptor['direccion'];
                if(isset($sujetoExcluido['direccion'])) $direcRsujetoExcluido = $sujetoExcluido['direccion'];
                if(isset($jsonInfo['ventaTercero'])) $ventaTercero = $jsonInfo['ventaTercero'];
                if(isset($jsonInfo['cuerpoDocumento'])) $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
                if(isset($jsonInfo['resumen'])) $resumen = $jsonInfo['resumen'];
                if(isset($resumen['tributos'])) $tributos  = $resumen['tributos'];
                if(isset($jsonInfo['extension'])) $extension = $jsonInfo['extension'];
                if(isset($jsonInfo['apendice'])) $apendice = $jsonInfo['apendice'];
                $tipoDocumento = '';

                $infoFact = $this->ventas_model->getDatosFactura($trannum);
                foreach($infoFact as $info){
                    $idClase = $info->idclase;
                    $nameSucursal = $info->nameSucursal;
                    $nameVendedor = $info->nameVendedor;
                    $extension['observaciones'] = $info->notas;
                    $diasCredito = $info->dias.' dias';
                    $referenciaOT = $info->referencia;
                    $idCliente = (int) $info->idcliente;
                    $idCentro = (int) $info->idcentro;
                }

                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

                if ( $dteSucursal == 0 ) {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                    $nameImagen = $this->pedclientes_model->getnameImg();
                } else {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 10);
                    $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0'.$idCentro);
                }

                $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'],'CAT-003');
                $modeloFacturacion = explode(" ", $modFac['descrip']);
                $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'],'CAT-004');
                $tipoTransmision = explode(" ", $tipoTrans['descrip']);
                $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'],'CAT-002');
                $tipoDocumento = $identificacion['tipoDte'];
                $nameVendedor = '';

                /* --- INICIO SECCION CABECERAS --- */
                $emisorEstab = array();
                if(isset($emisor['tipoEstablecimiento'])){
                    $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'],'CAT-009');
                }

                if(!isset($emisorEstab['descrip'])) $emisorEstab['descrip'] = '';

                $imgHeader1Hght = '20px';

                $header1 = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                        <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: '.$imgHeader1Hght.';"><img style="max-width: 100%; display: block; width: auto; height: 78px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">'.substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.5px; width:100%;">'.substr(mb_strtoupper($direcEmisor['complemento']), 0, 112).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. '.substr($emisor['telefono'].' Sucursal: '.$nameSucursal, 0, 44).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: '.substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: '.substr($emisor['nit'], 0, 19).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: '.substr($emisor['nrc'], 0, 19).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: '.substr($nameVendedor, 0, 40).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: '.$trannum.'</td>
                    </tr>';
                $header1 .= '</table>';

                $header2 = '
                <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">'.mb_strtoupper($tipoDoc['descrip'],'UTF-8').'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">'.$identificacion['codigoGeneracion'].'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">'.$sRecepcion.'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">'.$identificacion['numeroControl'].'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">'.ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">'.$identificacion['version'].'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">'.ucfirst($tipoTransmision[array_key_last($tipoTransmision)]).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">'.date_format(date_create($identificacion['fecEmi']),"d/m/Y").'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">'.date_format(date_create($identificacion['horEmi']),"h:i:s A").'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

                        $nControlP = explode('-', $identificacion['numeroControl']);

                    $header2 .= '
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">'.(int) $nControlP[3].'</td>
                        </tr>';
                $header2 .= '</table>';

                $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT']."dte_files", '/') . "/";

                $portalMHImg = $destinationFolder.$identificacion['codigoGeneracion'].'-MH.png';
                $codGeneracionImg = $destinationFolder.$identificacion['codigoGeneracion'].'.png';
                $selloRecibidoImg = $destinationFolder.$sRecepcion.'.png';
                $numeroControlImg = $destinationFolder.$identificacion['numeroControl'].'.png';
                
                if (!is_dir($destinationFolder)) {
                    mkdir($destinationFolder, 0777, true);
                }

                $this->createQrImage('https://admin.factura.gob.sv/consultaPublica?ambiente=' . $identificacion['ambiente'] . '&codGen=' . $identificacion['codigoGeneracion'] . '&fechaEmi=' . $identificacion['fecEmi'], 'Portal de Hacienda', $portalMHImg);
                $this->createQrImage($identificacion['codigoGeneracion'], 'Cód. Generación', $codGeneracionImg);
                $this->createQrImage($sRecepcion, 'Sello Recibido', $selloRecibidoImg);
                $this->createQrImage($identificacion['numeroControl'], 'N° de Control', $numeroControlImg);

                $qrCode = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                            <img src="' . $portalMHImg . '" style="height: 95px;"/>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="' . $codGeneracionImg . '" style="height: 75px;"/>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="' . $selloRecibidoImg . '" style="height: 75px;"/>
                        </td>
                        <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                            <br><br>
                            <img src="' . $numeroControlImg . '" style="height: 75px;"/>
                        </td>
                    </tr>
                </table>';

                if(isset($direcReceptor)){
                    $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'],$direcReceptor['departamento']);
                    $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
                }else{
                    $receptorMun = array();
                    $receptorDep = array();
                }

                if(isset($direcRsujetoExcluido)){
                    $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'],$direcRsujetoExcluido['departamento']);
                    $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
                }else{
                    $sujetoExcluidoMun = array();
                    $sujetoExcluidoDep = array();
                }

                $receptorDoc = array();
                if(isset($receptor['tipoDocumento'])){
                    if($receptor['tipoDocumento'] != ''){
                        $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'],'CAT-022');
                    }
                }

                $sujetoExcluidoDoc = array();
                if(isset($sujetoExcluido['tipoDocumento'])){
                    if($sujetoExcluido['tipoDocumento'] != ''){
                        $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'],'CAT-022');
                    }
                }

                if(!isset($receptorDoc['descrip'])){
                    $receptorDoc['descrip'] = 'Doc. Identificación';
                }

                if(!isset($receptor['numDocumento'])){
                    $receptor['numDocumento'] = '';
                }

                if(!isset($sujetoExcluidoDoc['descrip'])){
                    $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
                }

                if(!isset($receptor['nombreComercial'])){
                    $receptor['nombreComercial'] = '';
                }

                if(!isset($receptor['nit'])){
                    $receptor['nit'] = '';
                }

                if(!isset($direcReceptor['complemento'])){
                    $direcReceptor['complemento'] = '';
                }

                if(!isset($direcRsujetoExcluido['complemento'])){
                    $direcRsujetoExcluido['complemento'] = '';
                }

                if(!isset($receptor['correo'])){
                    $receptor['correo'] = '';
                }

                $condicionPago = array();
                if(isset($resumen['condicionOperacion'])){
                    if($resumen['condicionOperacion'] != ''){
                        $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'],'CAT-016');
                    }
                }else{
                    $condicionPago['descrip'] = '';
                }

                if(!isset($extension['observaciones'])){
                    $extension['observaciones'] = '';
                }

                if(!isset($extension['nombEntrega'])){
                    $extension['nombEntrega'] = '';
                }

                if(!isset($extension['docuEntrega'])){
                    $extension['docuEntrega'] = '';
                }

                if(!isset($extension['nombRecibe'])){
                    $extension['nombRecibe'] = '';
                }

                if(!isset($extension['docuRecibe'])){
                    $extension['docuRecibe'] = '';
                }

                $ordenString = '';
                $referenciaOT = '';

                $header3 = '
                <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Razon social:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.$ordenString.'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.$referenciaOT.'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Nombre Comercial:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr(mb_strtoupper($receptor['nombreComercial'], 'UTF-8'), 0, 64).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.$receptorDoc['descrip'].':</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['numDocumento'], 0, 19).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Correo:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr($receptor['correo'], 0, 64).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">NRC:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['nrc'], 0, 19).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Dirección:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:54%;">'.mb_strtoupper($direcReceptor['complemento'], 'UTF-8').'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Teléfono:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['telefono'], 0, 19).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">';
                    foreach($receptorMun as $muni){
                        if(!isset($muni['municipio'])) $muni['municipio'] = '';
                        $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Municipio:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                        break;
                    }
                        if($this->session->userdata('idaccount') == '2922210'){
                            $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"> &nbsp; &nbsp; &nbsp; &nbsp;'.substr($condicionPago['descrip'], 0, 19).' '.$diasCredito.'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">';
                        }else{
                        $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($condicionPago['descrip'], 0, 19).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">';}
                    foreach($receptorDep as $depto){
                        if(!isset($depto['depto'])) $depto['depto'] = '';
                        $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Departamento:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                        break;
                    }
                        $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Moneda:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19).'</td>
                    </tr>
                </table>';

                $header = '<table style="width:100%; margin:0; padding:0;">
                        <tr>
                            <td rowspan="2" style="width: 40%;">'.$header1.'</td>
                            <td style="margin:0; padding:0; width: 60%;">'.$header2.'</td>
                        </tr>
                        <tr>
                            <td style="margin:0; padding:0;">'.$qrCode.'</td>
                        </tr>
                        <tr>
                            <td style="margin:0; padding:0; line-height: 6px;"></td>
                        </tr>
                        <tr>
                            <td colspan="2" style="margin:0; padding:0;">'.$header3.'</td>
                        </tr>
                    </table>';

                //$pdf->setPrintHeader(true);
                //$pdf->setHTMLHeader($header);

                $pdf->SetXY( 4.5 + $x, 10.5 + $y );
                $pdf->writeHTML($header, true, false, true, false, '');

                /* --- FIN SECCION CABECERAS --- */

                //INICIO CUERPO DE DOCUMENTO FACTURA CONSUMIDOR FINAL
                    /* --- INICIO SECCION PRODUCTOS --- */

                    // for($i = 0; $i < 258; $i++){
                    //     $cuerpoDocumento[$i] = $cuerpoDocumento[0];
                    // }

                    $cantLines = 0;
                    $lineasPorProducto = 0;
                    foreach($cuerpoDocumento as $body){
                        $lineasPorProducto = ceil(strlen($body['descripcion']) / 65);
                        $cantLines += $lineasPorProducto;
                    }

                    if ($cantLines <= 32) {
                        $cantPages = 1;
                    } elseif ($cantLines > 32 && $cantLines <= 101) {
                        $cantPages = 2;
                    } else {
                        $cantPages = (ceil(abs($cantLines - 101) / 63)) + 2;
                    }

                    $numProd = 0;
                    $maxlines = 32;

                    if ($cantLines <= 32) {
                        $maxlines = 32;
                    } else {
                        if ($cantLines > 32 && $cantLines <= 101) {
                            if ($cantLines <= 40) {
                                $maxlines = 32;
                            } else {
                                $maxlines = 44;
                            }
                        } else if ($cantLines > 101) {
                            $maxlines = 44;
                        }
                    }

                    $stop_index = $maxlines;
                    $aux2 = 1;

                    $bodyDoc = '
                    <table style="width: 100%; padding: 0.5px;">
                    <thead>
                        <tr style="width: 100%;">
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 8px; width: 5.8%; border-left: 0.1px solid #000; border-top:    0.1px solid #000; border-bottom: 0.1px solid #000;">LINEA</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 8px; width:  10%; border-top: 0.1px solid  #000; border-bottom: 0.1px solid #000;">MODELO</th>
                            <th style="text-align:  left; vertical-align: middle; font-weight: bold; font-size: 8px; width:45.4%; border-top: 0.1px solid  #000; border-bottom: 0.1px solid #000;">DESCRIPCIÓN</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 8px; width: 7.8%; border-top: 0.1px solid  #000; border-bottom: 0.1px solid #000;">CANTIDAD</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 8px; width:   9%; border-top: 0.1px solid  #000; border-bottom: 0.1px solid #000;">PRECIO UNIT</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 6.5px; width: 8%; border-top: 0.1px solid  #000; border-bottom: 0.1px solid #000;">VTAS.NO SUJETAS</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 6.5px; width: 6%; border-top: 0.1px solid  #000; border-bottom: 0.1px solid #000;">VTAS. EXENTAS</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 6.5px; width: 8%; border-top: 0.1px solid  #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">VTAS. GRAVADAS</th>
                        </tr>
                    </thead>';

                    foreach($cuerpoDocumento as $body){
                    //foreach($cuerpoDocumento2 as $body){
                        //if($numProd < $maxlines){
                            $ventaNosj = number_format(floatval($body['ventaNoSuj']), 2, '.', ',');
                            $ventaExenta = number_format(floatval($body['ventaExenta']), 2, '.', ',');
                            $ventaGravada = number_format(floatval($body['ventaGravada']), 2, '.', ',');
                            if($ventaNosj == '0'){
                                $ventaNosj = '';
                            }
                            if($ventaExenta == '0'){
                                $ventaExenta = '';
                            }

                            if($numProd >= $stop_index){
                                $breakValue = 'always';
                                $numProd = 0;
                                $aux2++;
                            }else{
                                $breakValue = 'avoid';
                            }

                            $infoExtraPro = $this->dte_model->getInfoExtraProducto($body['codigo']);
                            $modelo = strtoupper($this->eliminarTildes($infoExtraPro->modelo));

                            $wrapped = wordwrap(trim($body['descripcion']), 65, '<br>');

                            $bodyDoc .= '<tr style=" page-break-before: '.$breakValue.'; padding: 0px;">';
                                $bodyDoc .= '<td style="width: 5.8%; text-align: center;">'.$body['numItem'].'</td>';
                                //$bodyDoc .= '<td style="width:55.4%; text-align: left; font-size:8.6px;">'.substr(trim($body['descripcion']),0, 70).'</td>';
                                $bodyDoc .= '<td style="width:10%; text-align: center; font-size:8.6px;">'.$modelo.'</td>';
                                $bodyDoc .= '<td style="width:45.4%; text-align: left; font-size:8.6px;">'.$wrapped.'</td>';
                                $bodyDoc .= '<td style="width: 7.8%; text-align: center;">'.$body['cantidad'].'</td>';
                                $bodyDoc .= '<td style="width:   9%; text-align:  right;">'.number_format($body['precioUni'], 4, '.', ',').'</td>';
                                $bodyDoc .= '<td style="width:   8%; text-align:  right;">'.$ventaNosj.'</td>';
                                $bodyDoc .= '<td style="width:   6%; text-align:  right;">'.$ventaExenta.'</td>';
                                $bodyDoc .= '<td style="width:   8%; text-align:  right;">'.$ventaGravada.'</td>';
                            $bodyDoc .= '</tr>';

                            if($aux2 > 1 && $aux2 <= $cantPages){
                                $stop_index = 56;
                            }

                            $numProd += ceil(strlen($body['descripcion']) / 65);
                            //var_dump($numProd);
                        //}
                    }

                    if($cantPages > 1){
                        $maxlines = 57;
                    }

                    for($i = $numProd; $i < $maxlines; $i++){
                        $bodyDoc .= '<tr style="padding: 0px;">
                            <td style="font-size:9px; text-align:center; width:100%;"></td>
                        </tr>';
                    }
                    //$bodyDoc .='</table>';

                    //$pdf->SetXY( 4.5 + $x, 93.5 + $y );
                    //$pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 24.1px; width:1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="line-height: 24.1px; text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:19%; border-top: 0.1px solid #000;">Valor en letras:</td>
                            <td style="line-height: 24.1px; text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-top: 0.1px solid #000; "></td>
                            <td style="line-height: 24.1px; text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:79%; border-top: 0.1px solid #000; border-right: 0.1px solid #000;">'.strtoupper($this->eliminarTildes(trim($resumen['totalLetras']))).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 17px; text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">EXTENSION</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="width:1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:17%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Nombre entrega:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:42%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 50).'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:18%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">No Documento:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:21%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.$extension['docuEntrega'].'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="width:1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:17%; border-bottom: 0.1px solid #000;">Nombre recibe:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:42%; border-bottom: 0.1px solid #000;">'.substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 50).'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-bottom: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:18%; border-bottom: 0.1px solid #000;">No Documento:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:21%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">'.$extension['docuRecibe'].'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="width:1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:17%; border-bottom: 0.1px solid #000;">Firma:</td>
                            <td style="line-height: 34px; text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:31.5%; border-bottom: 0.1px solid #000;"></td>
                            <td style="line-height: 34px; text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:18%; border-bottom: 0.1px solid #000; ">Firma:</td>
                            <td style="line-height: 34px; text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:31.5%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 17px; text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">OBSERVACIONES</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:99%; border-right: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 0, 86).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:99%; border-right: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 86, 86).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:99%; border-right: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 172, 86).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:99%; border-right: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 258, 86).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:99%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 344, 86).'</td>
                        </tr>
                    </table>';

                //$pdf->SetXY( 4.5, 210 );
                //$pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                <table style="width:100%; padding:0px; ">
                    <tr style="width:100%; padding:0px;">
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:32.9%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Suma de Ventas:</td>
                        <td style="line-height: 24.1px;text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalNoSuj'], 2, '.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:23.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalExenta'],2 ,'.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format(floatval($resumen['totalGravada']),2 ,'.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Sumatoria de Ventas:</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['subTotalVentas'], 2, '.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Vtas.Exentas:</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalExenta'],2 ,'.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Vtas.No Sujetas:</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalNoSuj'], 2, '.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                    </tr>';
                if(isset($tributos)){
                    foreach($tributos as $trib){
                        $totals .= '<tr style="width:100%; padding:0px;">
                                    <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">'.$trib["descripcion"].'</td>
                                    <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                    <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($trib["valor"], 2, '.', ',').'</td>
                                    <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                                </tr>';
                    }
                }
                $totals .='
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Sub - Total:</td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['subTotal'], 2, '.', ',').'</td>
                            <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">IVA Retenido:</td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['ivaRete1'], 2, '.', ',').'</td>
                            <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Total a Pagar:</td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalPagar'], 2, '.', ',').'</td>
                            <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        </tr>
                    </table>';

                //$pdf->SetXY( 128.4, 210 );
                //$pdf->writeHTML($totals, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2514 3094</a></p>';
                //$pdf->SetXY( 4.5, 265 );
                //$pdf->writeHTML($message, true, false, true, false, '');

                $bodyDoc .='
                    <tr style="width:100%;">
                        <td style="width:60%;">'.$extention.'</td>
                        <td style="width:40%;">'.$totals.'</td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:100%;">'.$message.'</td>
                    </tr>
                </table>';

                $pdf->SetXY( 4.5 + $x, 93.5 + $y );
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                    /* --- FIN SECCION TOTALES --- */
                //FIN CUERPO DE DOCUMENTO FACTURA CONSUMIDOR FINAL

                /* --- GENERACION DE PDF --- */ 

                $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'].'.pdf');
                $fullpath = $destinationFolder.$nombre_archivo;

                /*
                    *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
                    *D: send to the browser and force a file download with the name given by name.
                    *F: save to a local server file with the name given by name.
                    *S: return the document as a string. name is ignored.
                    *FI: equivalent to F + I option
                    *FD: equivalent to F + D option
                 */

                //$docToSend = 1;
                
                if($docToSend == 0){
                    $pdf->Output($nombre_archivo, 'I');
                }else{
                    $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                    //$pdf->Output($nombre_archivo, 'I');

                    if($infoDoc->correo != ''){
                        $pdf->Output($fullpath, 'F');
                        $docIntern = (int) $nControlP[3];
                        $emiDate = date_format(date_create($identificacion['fecEmi']),"d/m/Y");

                        if(isset($receptor['nombre'])) $nameCliente = mb_strtoupper($receptor['nombre'], 'UTF-8');
                        if(isset($sujetoExcluido['nombre'])) $nameCliente = mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8');

                        $jsonFile = $this->createJsonFile($jsonInfo, $identificacion['codigoGeneracion'], $respHacienda, $firmaJson);
                        $response = $this->sendEmailWithPdf($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);

                        if($response == true){
                            $title = 'Correo Enviado';
                            $bodyMsg = 'DTE enviado exitosamente a la direccion de correo <b style=\'color: #79bd53;\'>' . $infoDoc->correo . '</b>';
                            $type = 'success';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        }else{
                            $title = 'Error de Envio';
                            $bodyMsg = 'DTE no pudo ser enviado a la dirección de correo <b style=\'color: #f27474;\'>' . $infoDoc->correo . '</b>';
                            $type = 'error';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        }
                    }else{
                        $title = 'Error de Envio';
                        $bodyMsg = 'DTE no pudo ser enviado debido a que el cliente no tiene dirección de correo registrada en el sistema.';
                        $type = 'error';
                        echo $this->closeTabFunction($title, $bodyMsg, $type);
                    }
                }
            }
        }

        function creditoFiscalElectronicBills($trannum, $idYear = 0, $docToSend = 0)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                    redirect('login/cerrar_sesion');
            } else {
                    $this->load->model('dev_model');
                    $this->load->model('dte_model');
                    $this->load->model('global_model');
                    $this->load->model('pedclientes_model');
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');

                    $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Documento Tributario Electrónico');
                    $pdf->SetSubject('Documento Tributario Electrónico');
                    $pdf->SetMargins(7.5, 15, 9, true);
                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                    $pdf->SetAutoPageBreak(TRUE, 7);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('helvetica', '', 7.5, '', true);
                    $pdf->addPage('P', 'LETTER');

                    $x = 3;
                    $y = 3;

                    $informacion = $this->dev_model->electronicBills($trannum, $idYear);

                    foreach ($informacion as $info) {
                            $jsonInfo = $info['jsonDoc'];
                            $sRecepcion = $info['sRecepcion'];
                            $respHacienda = $info['respHacienda'];
                            $firmaJson = $info['firmaJson'];
                    }

                    if (isset($jsonInfo['identificacion'])) $identificacion = $jsonInfo['identificacion'];
                    if (isset($jsonInfo['documentoRelacionado'])) $documentoRelacionado = $jsonInfo['documentoRelacionado'];
                    if (isset($jsonInfo['emisor'])) $emisor = $jsonInfo['emisor'];
                    if (isset($emisor['direccion'])) $direcEmisor = $emisor['direccion'];
                    if (isset($jsonInfo['receptor'])) $receptor = $jsonInfo['receptor'];
                    if (isset($jsonInfo['sujetoExcluido'])) $sujetoExcluido = $jsonInfo['sujetoExcluido'];
                    if (isset($receptor['direccion'])) $direcReceptor = $receptor['direccion'];
                    if (isset($sujetoExcluido['direccion'])) $direcRsujetoExcluido = $sujetoExcluido['direccion'];
                    if (isset($jsonInfo['ventaTercero'])) $ventaTercero = $jsonInfo['ventaTercero'];
                    if (isset($jsonInfo['cuerpoDocumento'])) $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
                    if (isset($jsonInfo['resumen'])) $resumen = $jsonInfo['resumen'];
                    if (isset($resumen['tributos'])) $tributos  = $resumen['tributos'];
                    if (isset($jsonInfo['extension'])) $extension = $jsonInfo['extension'];
                    if (isset($jsonInfo['apendice'])) $apendice = $jsonInfo['apendice'];
                    $tipoDocumento = '';

                    $infoFact = $this->ventas_model->getDatosFactura($trannum);
                    foreach ($infoFact as $info) {
                            $idClase = $info->idclase;
                            $nameSucursal = $info->nameSucursal;
                            $nameVendedor = $info->nameVendedor;
                            $referenciaOT = $info->referencia;
                            $idCliente = (int) $info->idcliente;
                            $idCentro = (int) $info->idcentro;
                            if ($tipoDocumento == '03') {
                                    $extension['observaciones'] = $info->notas;
                            }
                    }

                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

                    if ( $dteSucursal == 0 ) {
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                        $nameImagen = $this->pedclientes_model->getnameImg();
                    } else {
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 2);
                        $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 10);
                        $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0'.$idCentro);
                    }
                    
                    $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
                    $modeloFacturacion = explode(" ", $modFac['descrip']);
                    $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
                    $tipoTransmision = explode(" ", $tipoTrans['descrip']);
                    $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
                    $tipoDocumento = $identificacion['tipoDte'];
                    $nameVendedor = '';                

                    /* --- INICIO SECCION CABECERAS --- */
                    $emisorEstab = array();
                    if (isset($emisor['tipoEstablecimiento'])) {
                            $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
                    }

                    if (!isset($emisorEstab['descrip'])) $emisorEstab['descrip'] = '';

                    $imgHeader1Hght = '20px';

                    $header1 = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: '.$imgHeader1Hght.';"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">'.substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.5px; width:100%;">'.substr(mb_strtoupper($direcEmisor['complemento']), 0, 112).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. '.substr($emisor['telefono'].' Sucursal: '.$nameSucursal, 0, 44).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: '.substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: '.substr($emisor['nit'], 0, 19).'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: '.substr($emisor['nrc'], 0, 19).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: '.substr($nameVendedor, 0, 40).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: '.$trannum.'</td>
                        </tr>';
                    $header1 .= '</table>';

                    $header2 = '
                        <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['numeroControl'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . $identificacion['version'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($tipoTransmision[array_key_last($tipoTransmision)]) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . date_format(date_create($identificacion['fecEmi']), "d/m/Y") . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . date_format(date_create($identificacion['horEmi']), "h:i:s A") . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

                    $nControlP = explode('-', $identificacion['numeroControl']);

                    $header2 .= '
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . (int) $nControlP[3] . '</td>
                            </tr>';
                    $header2 .= '</table>';

                    $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT']."dte_files", '/') . "/";

                    $portalMHImg = $destinationFolder.$identificacion['codigoGeneracion'].'-MH.png';
                    $codGeneracionImg = $destinationFolder.$identificacion['codigoGeneracion'].'.png';
                    $selloRecibidoImg = $destinationFolder.$sRecepcion.'.png';
                    $numeroControlImg = $destinationFolder.$identificacion['numeroControl'].'.png';
                    
                    if (!is_dir($destinationFolder)) {
                        mkdir($destinationFolder, 0777, true);
                    }

                    $this->createQrImage('https://admin.factura.gob.sv/consultaPublica?ambiente=' . $identificacion['ambiente'] . '&codGen=' . $identificacion['codigoGeneracion'] . '&fechaEmi=' . $identificacion['fecEmi'], 'Portal de Hacienda', $portalMHImg);
                    $this->createQrImage($identificacion['codigoGeneracion'], 'Cód. Generación', $codGeneracionImg);
                    $this->createQrImage($sRecepcion, 'Sello Recibido', $selloRecibidoImg);
                    $this->createQrImage($identificacion['numeroControl'], 'N° de Control', $numeroControlImg);

                    $qrCode = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                                <img src="' . $portalMHImg . '" style="height: 95px;"/>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="' . $codGeneracionImg . '" style="height: 75px;"/>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="' . $selloRecibidoImg . '" style="height: 75px;"/>
                            </td>
                            <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="' . $numeroControlImg . '" style="height: 75px;"/>
                            </td>
                        </tr>
                    </table>';

                    if (isset($direcReceptor)) {
                            $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'], $direcReceptor['departamento']);
                            $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
                    } else {
                            $receptorMun = array();
                            $receptorDep = array();
                    }

                    if (isset($direcRsujetoExcluido)) {
                            $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'], $direcRsujetoExcluido['departamento']);
                            $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
                    } else {
                            $sujetoExcluidoMun = array();
                            $sujetoExcluidoDep = array();
                    }

                    $receptorDoc = array();
                    if (isset($receptor['tipoDocumento'])) {
                            if ($receptor['tipoDocumento'] != '') {
                                    $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'], 'CAT-022');
                            }
                    }

                    $sujetoExcluidoDoc = array();
                    if (isset($sujetoExcluido['tipoDocumento'])) {
                            if ($sujetoExcluido['tipoDocumento'] != '') {
                                    $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'], 'CAT-022');
                            }
                    }

                    if (!isset($receptorDoc['descrip'])) {
                            $receptorDoc['descrip'] = 'Doc. Identificación';
                    }

                    if (!isset($sujetoExcluidoDoc['descrip'])) {
                            $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
                    }

                    if (!isset($receptor['nombreComercial'])) {
                            $receptor['nombreComercial'] = '';
                    }

                    if (!isset($direcReceptor['complemento'])) {
                            $direcReceptor['complemento'] = '';
                    }

                    if (!isset($direcRsujetoExcluido['complemento'])) {
                            $direcRsujetoExcluido['complemento'] = '';
                    }

                    if (!isset($receptor['correo'])) {
                            $receptor['correo'] = '';
                    }

                    $condicionPago = array();
                    if (isset($resumen['condicionOperacion'])) {
                            if ($resumen['condicionOperacion'] != '') {
                                    $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'], 'CAT-016');
                            }
                    } else {
                            $condicionPago['descrip'] = '';
                    }

                    if (!isset($extension['observaciones'])) {
                            $extension['observaciones'] = '';
                    }

                    if (!isset($extension['nombEntrega'])) {
                            $extension['nombEntrega'] = '';
                    }

                    if (!isset($extension['docuEntrega'])) {
                            $extension['docuEntrega'] = '';
                    }

                    if (!isset($extension['nombRecibe'])) {
                            $extension['nombRecibe'] = '';
                    }

                    if (!isset($extension['docuRecibe'])) {
                            $extension['docuRecibe'] = '';
                    }

                    $direcFontSize = '8px';
                    
                    if (strlen($direcReceptor['complemento']) > 89) {
                        $direcFontSize = '7.5px';
                    }

                    $ordenString = '';
                    $referenciaOT = '';

                    $header3 = '
                        <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">'. $ordenString .'</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.8px; width:16%;">'.trim($referenciaOT).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$direcFontSize.'; width:59%;">' . mb_strtoupper($direcReceptor['complemento'], 'UTF-8') . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">';
                    foreach ($receptorMun as $muni) {
                            $header3 .= '
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                            break;
                    }
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">';
                    foreach ($receptorDep as $depto) {
                            $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                            break;
                    }
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Moneda:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19) . '</td>
                            </tr>
                    </table>';

                    $header = '<table style="width:100%; margin:0; padding:0;">
                                    <tr>
                                                    <td rowspan="2" style="width: 40%;">' . $header1 . '</td>
                                                    <td style="margin:0; padding:0; width: 60%;">' . $header2 . '</td>
                                    </tr>
                                    <tr>
                                                    <td style="margin:0; padding:0;">' . $qrCode . '</td>
                                    </tr>
                                    <tr>
                                                    <td colspan="2" style="margin:0; padding:0;">' . $header3 . '</td>
                                    </tr>
                    </table>';

                    //$pdf->setPrintHeader(true);
                    //$pdf->setHTMLHeader($header);

                    $pdf->SetXY(4.5 + $x, 10.5 + $y);
                    $pdf->writeHTML($header, true, false, true, false, '');

                    /* --- FIN SECCION CABECERAS --- */

                    //INICIO CUERPO DE DOCUMENTO CREDITO FISCAL
                    /* --- INICIO SECCION PRODUCTOS --- */

                    $cantLines = 0;
                    $lineasPorProducto = 0;
                    foreach($cuerpoDocumento as $body){
                        $lineasPorProducto = ceil(strlen($body['descripcion']) / 57);
                        $cantLines += $lineasPorProducto;
                    }

                    if ($cantLines <= 40) {
                        $cantPages = 1;
                    } elseif ($cantLines > 40 && $cantLines <= 113) {
                        $cantPages = 2;
                    } else {
                        $cantPages = (ceil(abs($cantLines - 113) / 65)) + 2;
                    }
    
                    $numProd = 0;
                    $maxlines = 40;
    
                    $docLines = count($cuerpoDocumento);
                    if ($docLines <= 40) {
                        $maxlines = 40;
                    } else {
                        if ($docLines > 40 && $docLines <= 113) {
                            if ($docLines <= 44) {
                                $maxlines = 40;
                            } else {
                                $maxlines = 48;
                            }
                        } else if ($docLines > 113) {
                            $maxlines = 48;
                        }
                    }

                    $stop_index = $maxlines;
                    $aux2 = 1;

                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    $total = 0;
                    $totalGravado = 0;
                    $totalExento = 0;
                    $totalIVA = 0;
                    //$invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                    $invexento = 0;
                    $vnExenta = 0;
                    $vnGravada = 0;
                    $numProd = 0; //linea echa para poder visualizar el pdf
                    $ivaCesc = 0;
                    $cesc = 0;
                    $lineasOcupa = 0;
                    $totalDesc = 0;
                    $discount = 0;

                    $bodyDoc = '
                    <table style="width:100%; padding:0px;">
                    <thead>
                        <tr style="width:100%; padding:0px;">
                                        <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:4.5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No. Item</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5.5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Modelo</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:46%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:8%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                        </tr>
                    </thead>';

                    foreach ($productos as $pro) {
                            //if($numProd < $maxlines){
                            /*$ventaNosj = number_format(floatval($body['ventaNoSuj']), 4, '.', ',');
                            $ventaExenta = number_format(floatval($body['ventaExenta']), 4, '.', ',');
                            if($ventaNosj == '0'){
                                            $ventaNosj = '';
                            }
                            if($ventaExenta == '0'){
                                            $ventaExenta = '';
                            }*/

                            if ($pro->tax1 != 0 && $invexento == 0) {
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "";
                                    //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            } else if ($pro->tax1 != 0 && $invexento == 1) {
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                    $vnGravada = "";
                            } else if ($pro->tax1 == 0 && $invexento == 0) {
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                    $vnGravada = "";
                            } else if ($pro->tax1 == 0 && $invexento == 1) {
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                    $vnGravada = "";
                            }

                            $ivaSepa = 1 + ($pro->tax1 / 100);
                            $preciouni = $pro->precioneto;
                            if ($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != "") {
                                    $discount =  ($pro->descuento / 100) * $preciouni;
                                    $totalDesc += $discount * abs($pro->cantidad);
                            }

                            if ($pro->notas != "") {
                                    $notas = strtoupper(trim($pro->notas));
                            } else {
                                    $notas = "";
                            }

                            if ($pro->tipo == "4") {
                                    $idpro = "";
                                    $nombrepro = strtoupper(trim($notas));

                                    if ( $nombrepro == '' ) {
                                        $nombrepro = strtoupper(trim($pro->descrip));
                                    }
                            } else {
                                    $idpro = $pro->idproducto;
                                    $nombrepro = strtoupper(trim($pro->descrip)).' '.$notas;
                            }

                            $sumacantidad = (number_format(abs($pro->cantidad), 4, '.', '') - number_format(abs($pro->cantidad), 0, '.', ''));
                            if ($sumacantidad != 0) $cantidadPro = number_format(abs($pro->cantidad), 4, '.', '');
                            else $cantidadPro = number_format(abs($pro->cantidad), 0, '.', '');

                            if ($numProd >= $stop_index) {
                                    $breakValue = 'always';
                                    $numProd = 0;
                                    $aux2++;
                            } else {
                                    $breakValue = 'avoid';
                            }

                            $wrapped = wordwrap(trim(mb_strtoupper($nombrepro, 'UTF-8')), 57, '<br>');

                            $bodyDoc .= '<tr style="width:100%; padding:0px; page-break-before: ' . $breakValue . ';">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:4.5%;">' . $pro->itemline . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5.5%;">' . $cantidadPro . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8.8px; width:9%;">' . $pro->modelo . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">' . $wrapped . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($preciouni, 6, '.', '') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $vnExenta . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $vnGravada . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                            </tr>';

                            if ($aux2 > 1 && $aux2 <= $cantPages) {
                                $stop_index = 65;
                            }

                            $totalDesc = 0;
                            $numProd += ceil(strlen($nombrepro) / 57);
                            //$numProd++;
                            //}
                    }

                    if ($cantPages > 1) {
                        $maxlines = 65;
                    }

                    for ($i = $numProd; $i < $maxlines; $i++) {
                        $bodyDoc .= '
                        <tr>
                            <td style="font-size: 9px; text-align:center; width:100%;"></td>
                        </tr>';
                    }
                    //$bodyDoc .='</table>';

                    //$pdf->SetXY( 4.5 + $x, 93.5 + $y );
                    //$pdf->writeHTML($bodyDoc, true, false, true, false, '');

                    /* --- INICIO SECCION TOTALES --- */

                    /* --- INICIO SECCION EXTENSION --- */

                    $extention = '
                    <table style="width:100%; padding:0px; border: 0.1px solid #000; margin: 0px;">
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%; border-top: 0.1px solid #000;">Valor en letras:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%; border-top: 0.1px solid #000;">' . trim($resumen['totalLetras']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                        </tr>';
                    if ($extension['observaciones'] == '') {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    } else if (strlen(trim($extension['observaciones'])) <= 86) {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    } else {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%; border-bottom: 0.1px solid #000;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                            </tr>';
                    }

                    $extention .= '
                    </table>';

                    //$pdf->SetXY( 4.5, 210 );
                    //$pdf->writeHTML($extention, true, false, true, false, '');

                    /* --- INICIO SECCION TOTALES --- */

                    $totals = '
                    <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; margin: 0px;">
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total descuentos</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalDescu'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>';
                    foreach ($tributos as $trib) {
                            $totals .= '
                            <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';

                        $resumen['subTotal'] = floatval($trib["valor"]) + floatval($resumen['subTotal']);
                    }
                    $totals .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total otros montos no afectos</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%; border-bottom: 0.1px solid #000;">TOTAL A PAGAR</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-bottom: 0.1px solid #000;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                            </tr>
                    </table>';

                    //$pdf->SetXY( 128.4, 210 );
                    //$pdf->writeHTML($totals, true, false, true, false, '');

                    /* --- FIN SECCION TOTALES --- */

                    $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2514 3094</a></p>';
                    //$pdf->SetXY( 4.5, 265 );
                    //$pdf->writeHTML($message, true, false, true, false, '');

                    $bodyDoc .= '
                        <tr style="width:100%; margin: 0px; padding: 0px;">
                            <td style="width:60%; margin: 0px; padding: 0px; text-align: left;">' . $extention . '</td>
                            <td style="width:40%; margin: 0px; padding: 0px; text-align: left;">' . $totals . '</td>
                        </tr>
                        <tr style="width:100%;">
                            <td style="width:1%; margin: 0px; padding: 0px;"></td>
                            <td style="width:99%; margin: 0px; padding: 0px;">' . $message . '</td>
                        </tr>
                    </table>';

                    $pdf->SetXY(4.5 + $x, 93.5 + $y);
                    $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                    // FIN CUERPO DE DOCUMENTO CREDITO FISCAL

                    /* --- GENERACION DE PDF --- */

                    $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'] . '.pdf');
                    $fullpath = $destinationFolder.$nombre_archivo;

                    /*
                    *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
                    *D: send to the browser and force a file download with the name given by name.
                    *F: save to a local server file with the name given by name.
                    *S: return the document as a string. name is ignored.
                    *FI: equivalent to F + I option
                    *FD: equivalent to F + D option
                    */

                    //$docToSend = 1;

                    if ($docToSend == 0) {
                            $pdf->Output($nombre_archivo, 'I');
                    } else {
                            $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                            //$pdf->Output($nombre_archivo, 'I');

                            if ($infoDoc->correo != '') {
                                    $pdf->Output($fullpath, 'F');
                                    $docIntern = (int) $nControlP[3];
                                    $emiDate = date_format(date_create($identificacion['fecEmi']), "d/m/Y");

                                    if (isset($receptor['nombre'])) $nameCliente = mb_strtoupper($receptor['nombre'], 'UTF-8');
                                    if (isset($sujetoExcluido['nombre'])) $nameCliente = mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8');

                                    $jsonFile = $this->createJsonFile($jsonInfo, $identificacion['codigoGeneracion'], $respHacienda, $firmaJson);
                                    $response = $this->sendEmailWithPdf($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);

                                    if ($response == true) {
                                            $title = 'Correo Enviado';
                                            $bodyMsg = 'DTE enviado exitosamente a la direccion de correo <b style=\'color: #79bd53;\'>' . $infoDoc->correo . '</b>';
                                            $type = 'success';
                                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                                    } else {
                                            $title = 'Error de Envio';
                                            $bodyMsg = 'DTE no pudo ser enviado a la dirección de correo <b style=\'color: #f27474;\'>' . $infoDoc->correo . '</b>';
                                            $type = 'error';
                                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                                    }
                            } else {
                                    $title = 'Error de Envio';
                                    $bodyMsg = 'DTE no pudo ser enviado debido a que el cliente no tiene dirección de correo registrada en el sistema.';
                                    $type = 'error';
                                    echo $this->closeTabFunction($title, $bodyMsg, $type);
                            }
                    }
            }
        }

        function notaCreditoElectronicBills($trannum, $idYear = 0, $docToSend = 0)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('dev_model');
                $this->load->model('dte_model');
                $this->load->model('global_model');
                $this->load->model('pedclientes_model');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Documento Tributario Electrónico');
                $pdf->SetSubject('Documento Tributario Electrónico');
                $pdf->SetMargins(7.5, 15, 9, true);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetAutoPageBreak(TRUE, 7);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('helvetica', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                $x = 3;
                $y = 3;

                $informacion = $this->dev_model->electronicBills($trannum, $idYear);

                foreach ($informacion as $info) {
                    $jsonInfo = $info['jsonDoc'];
                    $sRecepcion = $info['sRecepcion'];
                    $respHacienda = $info['respHacienda'];
                    $firmaJson = $info['firmaJson'];
                }

                if (isset($jsonInfo['identificacion'])) $identificacion = $jsonInfo['identificacion'];
                if (isset($jsonInfo['documentoRelacionado'])) $documentoRelacionado = $jsonInfo['documentoRelacionado'];
                if (isset($jsonInfo['emisor'])) $emisor = $jsonInfo['emisor'];
                if (isset($emisor['direccion'])) $direcEmisor = $emisor['direccion'];
                if (isset($jsonInfo['receptor'])) $receptor = $jsonInfo['receptor'];
                if (isset($jsonInfo['sujetoExcluido'])) $sujetoExcluido = $jsonInfo['sujetoExcluido'];
                if (isset($receptor['direccion'])) $direcReceptor = $receptor['direccion'];
                if (isset($sujetoExcluido['direccion'])) $direcRsujetoExcluido = $sujetoExcluido['direccion'];
                if (isset($jsonInfo['ventaTercero'])) $ventaTercero = $jsonInfo['ventaTercero'];
                if (isset($jsonInfo['cuerpoDocumento'])) $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
                if (isset($jsonInfo['resumen'])) $resumen = $jsonInfo['resumen'];
                if (isset($resumen['tributos'])) $tributos  = $resumen['tributos'];
                if (isset($jsonInfo['extension'])) $extension = $jsonInfo['extension'];
                if (isset($jsonInfo['apendice'])) $apendice = $jsonInfo['apendice'];
                $tipoDocumento = '';

                $infoFact = $this->ventas_model->getDatosFactura($trannum);
                foreach ($infoFact as $info) {
                    $idClase = $info->idclase;
                    $nameSucursal = $info->nameSucursal;
                    $nameVendedor = $info->nameVendedor;
                    $referenciaOT = $info->referencia;
                    $idCliente = (int) $info->idcliente;
                    $idCentro = (int) $info->idcentro;
                    if ($tipoDocumento == '03') {
                        $extension['observaciones'] = $info->notas;
                    }
                }

                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

                if ( $dteSucursal == 0 ) {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                    $nameImagen = $this->pedclientes_model->getnameImg();
                } else {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 10);
                    $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0'.$idCentro);
                }

                $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
                $modeloFacturacion = explode(" ", $modFac['descrip']);
                $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
                $tipoTransmision = explode(" ", $tipoTrans['descrip']);
                $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
                $tipoDocumento = $identificacion['tipoDte'];
                $nameVendedor = '';

                /* --- INICIO SECCION CABECERAS --- */
                $emisorEstab = array();
                if (isset($emisor['tipoEstablecimiento'])) {
                    $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
                }

                if (!isset($emisorEstab['descrip'])) $emisorEstab['descrip'] = '';

                $imgHeader1Hght = '20px';

                $header1 = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                            <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: '.$imgHeader1Hght.';"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.5px; width:100%;">' . substr(mb_strtoupper($direcEmisor['complemento']), 0, 112) . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                    </tr>
                </table>';

                $header2 = '
                <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
   